Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Spinors",
 FontSlant->"Italic",
 FontColor->RGBColor[1, 0, 0]]], "Title",
 CellChangeTimes->{{3.424432795274125*^9, 
  3.424432798147224*^9}},ExpressionUUID->"1dd66255-6ba6-470b-b74b-\
202cdb3d816e"],

Cell[TextData[StyleBox["Spinors in General Relativity",
 FontColor->RGBColor[0, 0, 1]]], "Subtitle",
 CellChangeTimes->{{3.432628764630637*^9, 
  3.432628770497842*^9}},ExpressionUUID->"62aa69bc-f622-448e-8f38-\
e61b5325951d"],

Cell[TextData[{
 StyleBox["Alfonso Garc\[IAcute]a-Parrado G\[OAcute]mez-Lobo\n",
  FontSize->18],
 StyleBox["alfonso@math.uminho.pt",
  FontSize->14],
 "\n",
 StyleBox["Universidade do Minho, Portugal",
  FontSize->14],
 "\n\n",
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a\n",
  FontSize->18],
 StyleBox["jose@xact.es",
  FontSize->14],
 "\n\n",
 StyleBox["(c) 2006-2026, under GPL\n\nhttp://www.xAct.es/\n\
http://groups.google.com/group/xAct",
  FontSize->14]
}], "Subsubtitle",ExpressionUUID->"b2d91284-a199-41ac-8fac-1538f97b5183"],

Cell[TextData[{
 StyleBox["Spinors",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is a package for spinor computations on a curved 4d Lorentzian spacetime.\n\
\n",
 StyleBox["Spinors",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is distributed under the GNU General Public License, and runs on top of ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", a free package for fast manipulation of abstract tensor expressions. Both \
can be downloaded from ",
 ButtonBox["http://www.xact.es/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.xact.es"], None},
  ButtonNote->"http://www.xact.es"]
}], "Text",ExpressionUUID->"e5713ac9-c059-4dfe-9950-e27afcc1819c"],

Cell[CellGroupData[{

Cell[BoxData["Today"], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"698defd1-c765-4296-a1aa-cd27c6d047fd"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Thu 1 Jan 2026\""}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{"2026", ",", "1", ",", "1"}], "}"}], ",", "\"Day\""}], "]"}]},
  "DateObject",
  Editable->False]], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"5ad33ef7-8450-48a8-b00b-a7b84d28e8cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xAct`Spinors`$xTensorVersionExpected", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.1.1\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2014", ",", "9", ",", "28"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`Spinors`$Version", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<1.0.7\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}], "}"}]}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[2]:=",ExpressionUUID->"36a2b044-43f4-44d7-beb7-43f6ea217ff8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1.0.7\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",ExpressionUUID->"629bcd7b-9762-4212-ac08-17dd750819ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "1. ",
 StyleBox["Initialization",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"043e66f2-94cf-4012-879e-ea5a8c60c7ff"],

Cell["1.0. TODO list", \
"Subsubsection",ExpressionUUID->"38ed680f-ec87-4eaa-a8fa-f136a7522e27"],

Cell[CellGroupData[{

Cell["1.1. GPL", \
"Subsubsection",ExpressionUUID->"1fac49a6-ded4-4b72-a772-13d912dcc9a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Spinors", ":", " ", 
    RowBox[{
    "spinor", " ", "calculus", " ", "in", " ", "General", " ", 
     "Relativity"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Copyright", " ", 
     RowBox[{"(", "C", ")"}], " ", "2006"}], "-", 
    RowBox[{"2026", " ", "Alfonso", " ", "Garcia"}], "-", 
    RowBox[{"Parrado", " ", "Gomez"}], "-", 
    RowBox[{"Lobo", " ", "and", " ", "Jose", " ", 
     RowBox[{"M", ".", " ", "Martin"}]}], "-", "Garcia"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", " ", "it", " ", "under", " ",
       "the", " ", "terms", " ", "of", " ", "the", " ", "GNU", " ", "General",
       " ", "Public", " ", "License", " ", "as", " ", "published", " ", "by", 
      " ", "the", " ", "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], " ",
      "program", " ", "is", " ", "distributed", " ", "in", " ", "the", " ", 
     "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", "useful"}], 
    ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", " ", 
      "General", " ", "Public", " ", "License", " ", "for", " ", "more", " ", 
      
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], " ",
       "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ", 
      "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", " ", "along", " ", "with", " ", "this", " ", "program"}], ";",
      " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", " ", 
     "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", " ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"50855377-c048-4e22-928f-8f58c2e21fce"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Info package", \
"Subsubsection",ExpressionUUID->"bfa9c98f-4192-4d19-8e7a-f9f0cea1d2c7"],

Cell["\<\
(* :Title: Spinors *)

(* :Author: Alfonso Garcia-Parrado Gomez-Lobo and Jose M. Martin-Garcia *)

(* :Summary: spinor calculus in General Relativity *)

(* :Brief Discussion:
   - Spinors extends xAct to perform spinor computations on 4d Lorentzian \
spacetimes.
   - Defines spin structures, spinors, spin connections and their curvature \
spinors.
   - Allows conversion from tensors to spinors and viceversa.
   - The documentation explains how to construct the Newman-Penrose and
    Geroch-Held-Penrose formalism.
*)
  
(* :Context: xAct`Spinors` *)

(* :Package Version: 1.0.7 *)

(* :Copyright: Alfonso Garcia-Parrado Gomez-Lobo and Jose M. Martin-Garcia \
(2006-2026) *)

(* :History: See Spinors.History *)

(* :Keywords: *)

(* :Source: Spinors.nb *)

(* :Warning: *)

(* :Mathematica Version: 6.0 and later *)

(* :Limitations:
\t- 4d Lorentzian spacetime only *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellLabel->"In[4]:=",ExpressionUUID->"56f501c5-3d64-4f3c-89c3-125dcce78d9b"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. BeginPackage", \
"Subsubsection",ExpressionUUID->"8bf80ea4-a927-4e7c-9e4f-cc35cf05c641"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xAct`Spinors`Private`SpinorsSymbols", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Names", "[", "\"\<xAct`Spinors`*\>\"", "]"}], ",", 
         RowBox[{"Names", "[", "\"\<xAct`Spinors`Private`*\>\"", "]"}]}], 
        "]"}], ",", 
       RowBox[{"\"\<$Version\>\"", "|", "\"\<xAct`Spinors`$Version\>\"", 
        "|", "\"\<$xTensorVersionExpected\>\"", 
        "|", "\"\<xAct`Spinors`$xTensorVersionExpected\>\""}]}], "]"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "/@", "xAct`Spinors`Private`SpinorsSymbols"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Clear", "/@", "xAct`Spinors`Private`SpinorsSymbols"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[29]:=",ExpressionUUID->"d3f78503-d9c6-4267-af4b-3634b31913c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`Spinors`\>\""}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4232371765761337`*^9, 3.4232371975315447`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"65c70985-cb25-4701-af7b-7dfb7ec9484f"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellChangeTimes->{{3.423237204071299*^9, 3.423237206170257*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"a619fe8b-beb8-407d-8bc6-98056a6609b0"],

Cell[BoxData["\<\"xAct`Spinors`\"\>"], "Output",
 CellLabel->
  "Out[31]=",ExpressionUUID->"e67e90a5-2ab7-4c76-83a6-12d6e24f02b2"]
}, Open  ]],

Cell[TextData[{
 "Explicit (not hidden) import of ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", ",
 StyleBox["xPerm",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " and ",
 StyleBox["xCore",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ":"
}], "Text",ExpressionUUID->"0c52e3dd-a44e-41bb-8da5-7c9766fb670b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`Spinors`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", 
     ",", "\"\<xAct`xCore`\>\""}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[32]:=",ExpressionUUID->"f1965188-8ff2-49fd-bcdc-d26819d77e5d"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"01796b18-1f16-4ff8-b802-ac3d797c1c0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.4", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"18360611-d204-4d98-a23e-da1f2dbd6c25"],

Cell[BoxData["\<\"CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"16455dc3-0333-40bf-acec-24f1ea8403c5"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"401d2cbc-a482-48f3-9584-32c403f1f0c7"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"4d000ffd-a372-4e51-8a66-607e961fc332"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"2426ca4e-8cf8-4a4d-a4b2-472a31326841"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.3.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.3.0", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"7e928d1b-a78d-4291-b02a-87191ea2773d"],

Cell[BoxData["\<\"CopyRight (C) 2002-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"a2e299c5-633d-46db-b751-81b5d3e1a0e4"]
}, Open  ]],

Cell[BoxData["\<\"xAct`Spinors`\"\>"], "Output",
 CellLabel->
  "Out[32]=",ExpressionUUID->"bd907db3-0e0c-44c8-9f6d-3ab9031cdd8c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Not", "@", 
    RowBox[{"OrderedQ", "@", 
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"{", 
        RowBox[{
        "xAct`Spinors`$xTensorVersionExpected", ",", 
         "xAct`xTensor`$Version"}], "}"}]}], "]"}]}]}], ",", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"General", "::", "versions"}], ",", "\"\<xTensor\>\"", ",", 
      "xAct`xTensor`$Version", ",", "xAct`Spinors`$xTensorVersionExpected"}], 
     "]"}]}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[33]:=",ExpressionUUID->"218021fd-fd14-4f8e-addb-345252558c7b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`Spinors`  version \>\"", ",", 
    RowBox[{"xAct`Spinors`$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"xAct`Spinors`$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", "\"\<CopyRight (C) 2006-2026, Alfonso Garcia-Parrado \
Gomez-Lobo and Jose M. Martin-Garcia, under the General Public License.\>\"", 
   "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[34]:=",ExpressionUUID->"f90e7cb1-bc60-468f-8b3d-d724f0525b3b"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"227fa7e9-b2ef-4a2e-8ec5-ee1227315a42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Spinors`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.7\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`Spinors`  version ", "1.0.7", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"6944563a-5b3a-471f-920d-2777d443d944"],

Cell[BoxData["\<\"CopyRight (C) 2006-2026, Alfonso Garcia-Parrado Gomez-Lobo \
and Jose M. Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"1b35f0d6-b94e-495b-be83-afd7f0ce76a9"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We specify the context xAct`Spinors` to avoid overriding the Disclaimer of \
the other packages. However we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"89c88554-dd29-4006-a7d5-208640bcee58"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`Spinors`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[37]:=",ExpressionUUID->"740ffacd-a61f-40da-9001-24690d5f9bc6"],

Cell[TextData[{
 "If ",
 StyleBox["Spinors",
  FontSlant->"Italic"],
 " is not being called from other package then write this GPL short \
disclaimer:"
}], "Text",ExpressionUUID->"c30e672c-c333-4195-ad47-0826f9ae440d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
   "xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`Spinors`\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Print", "[", "\"\<These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\>\"", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4232372878945827`*^9, 3.423237289581603*^9}, {
  3.423283390363858*^9, 3.4232834081506033`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"0f9f17b5-5e3d-4b05-8981-8c841dc3ef9a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"fd540f1c-d174-4138-b7d1-6e42a6bf1ce2"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"a908783f-7c04-43f0-88f1-f56526ed42f7"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"5e0e556a-79db-4700-8feb-4c1135a1cbae"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Note that symbols in the Global` context cannot be accessed right now.\
\>", "Text",
 CellChangeTimes->{
  3.423568541839567*^9},ExpressionUUID->"3b6d5a85-d488-4ed2-9cbd-\
b10052e35c10"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"7cd6aee8-a733-430c-a868-1ff915ca3c34"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`Spinors`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellLabel->
  "Out[41]=",ExpressionUUID->"b56ec99a-0f4f-4601-b8fa-58ff33bbb156"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"b45b2b9a-a24b-47ae-b8af-a1ead71c4fde"],

Cell[BoxData["\<\"xAct`Spinors`\"\>"], "Output",
 CellLabel->
  "Out[42]=",ExpressionUUID->"ef898504-0a82-44e5-9a74-e1ff5fa193bf"]
}, Open  ]],

Cell["Established connection to external executable?", "Text",
 CellChangeTimes->{{3.419152978029696*^9, 
  3.419152995868268*^9}},ExpressionUUID->"4847d758-03a3-4e38-be4f-\
ad55520e46e6"],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], "Input",
 CellChangeTimes->{{3.419152970981339*^9, 3.4191529720352583`*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"aa2dfbcf-88fb-41f9-8f73-125814d78a95"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[43]=",ExpressionUUID->"33f7bf86-6ce7-474a-868c-158bdfa0fdfe"]
}, Open  ]],

Cell[TextData[{
 "Private functions of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " used here :\n      FrozenMetricQ\n      FindFreeAndDummyIndices\n      \
TransposeDaggerPairs\n      SignedVBundleOfIndex\n      MakeLinearDerivative\n\
      $MultiIndexCovDs\n      SymbolRelations"
}], "Text",ExpressionUUID->"e7a5718c-3c26-4a09-925a-57c6b66b6445"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. Non-standard setup", "Subsubsection",
 CellChangeTimes->{{3.4259903997539062`*^9, 
  3.425990420166374*^9}},ExpressionUUID->"8c653335-71c5-4cbe-9fa2-\
42b6e1080ac8"],

Cell["Screen all dollar indices:", "Text",
 CellChangeTimes->{
  3.4232298843102837`*^9},ExpressionUUID->"f6a1e353-9ead-4114-bafe-\
49e399e2ba76"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[44]:=",ExpressionUUID->"06ae3acf-b637-4f08-ac65-4b05501351c3"],

Cell["We shall allow metric contractions everywhere:", \
"Text",ExpressionUUID->"34b9b13c-9017-4bec-84be-1d50b54932e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"ContractMetric", ",", 
   RowBox[{"AllowUpperDerivatives", "\[Rule]", "True"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[45]:=",ExpressionUUID->"1f652932-b3de-4204-bad2-34eb7763f148"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AllowUpperDerivatives", "\[Rule]", "True"}], ",", 
   RowBox[{"OverDerivatives", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellLabel->
  "Out[45]=",ExpressionUUID->"0c9ec6c2-246f-41a5-a011-457af15b2529"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"MakeRule", ",", 
   RowBox[{"MetricOn", "\[Rule]", "All"}], ",", 
   RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[46]:=",ExpressionUUID->"88e2768d-23d8-491a-9b2b-768bf5c8e017"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PatternIndices", "\[Rule]", "All"}], ",", 
   RowBox[{"TestIndices", "\[Rule]", "True"}], ",", 
   RowBox[{"MetricOn", "\[Rule]", "All"}], ",", 
   RowBox[{"UseSymmetries", "\[Rule]", "True"}], ",", 
   RowBox[{"Verbose", "\[Rule]", "False"}], ",", 
   RowBox[{"ContractMetrics", "\[Rule]", "True"}], ",", 
   RowBox[{"Evaluate", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellLabel->
  "Out[46]=",ExpressionUUID->"fd40817f-9840-4c2c-b2ef-df84044a1620"]
}, Open  ]],

Cell["\<\
Timings will be shown if they are above 1 Second (Only for this notebook; \
this is not included in the package):\
\>", "Text",ExpressionUUID->"66fbe032-8023-4a73-953a-f171f6678df5"],

Cell[BoxData[
 RowBox[{"<<", "xAct/ShowTime1.m"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"3eba4022-e485-4bc2-a0b6-4d3dd0b5b350"],

Cell[CellGroupData[{

Cell[BoxData["$ShowTimeThreshold"], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"29a97c36-dc6e-4afa-a32e-037d38ebdf11"],

Cell[BoxData["1"], "Output",
 CellLabel->
  "Out[48]=",ExpressionUUID->"e33f94c6-3c2a-424a-85dd-3ff09418b97d"]
}, Open  ]],

Cell[TextData[{
 "We also read the package (this is not automatic in ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " anymore since its version 0.6.2). This is not included in the package."
}], "Text",ExpressionUUID->"dc4ea1ae-b2be-4702-869e-464541a5dea4"],

Cell[BoxData[
 RowBox[{"<<", "xAct/ExpressionManipulation.m"}]], "Input",
 CellLabel->
  "In[49]:=",ExpressionUUID->"67011ef7-e6a4-4c73-8bc7-bbf644037ef6"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5. Usage messages", \
"Subsubsection",ExpressionUUID->"3a216e1a-8411-4349-b155-a95a2374b537"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Definition", " ", "of", " ", "spin", " ", "structures"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefSpinStructure", "::", "usage"}], 
     "=", "\"\<DefSpinStructure[g, VB, {A,B,C,...}, epsilon, sigma, CDe,  \
options] defines a spin structure on the manifold in which the metric g[-a, \
-b] is defined, creating the inner vbundle VB with abstract indices \
{A,B,C,...}. Currently it only works on 4-dimensional Lorentzian manifolds, \
and so VB is defined as 2-dimensional and complex. The spin metric is \
epsilon[-A, -B] and the soldering form is sigma[a, -B, -B\[Dagger]]. The spin \
covariant derivative CDe,  compatible with sigma and epsilon, is defined on \
this vbundle extending the Levi-Civita connection of g. We adopt the \
convention of taking the head of the soldering form as the symbol \
representing the spin structure.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefSpinStructure", "::", "usage"}], 
     "=", "\"\<UndefSpinStructure[sp] removes the spin structure associated \
to the symbol sp and all its dependent objects (servants). The symbol sp can \
be the soldering form, the vector bundle or the extended covariant \
derivative.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$SolderingForms", "::", "usage"}], 
     "=", "\"\<$SolderingForms is a list containing the set of soldering \
forms (spin structures) existing in the session.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SpinorPrefix", "::", "usage"}], 
     "=", "\"\<SpinorPrefix is an option for DefSpinStructure giving the \
symbol to be prepended when constructing the spinor equivalent of a tensor or \
viceversa. By default it is Identity, which is replaced by the soldering form \
defined with the SpinStructure. SpinorPrefix[sigma] stores that symbol as an \
upvalue for the soldering form sigma.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SpinorMark", "::", "usage"}], 
     "=", "\"\<SpinorMark is an option for DefSpinStructure specifying how to \
modify the PrintAs string of a tensor when constructing its spinor \
equivalent. It can be a string (to be prepended to the  PrintAs string) or a \
function (acting on it). By default it is PrintAs, which is replaced by a \
delayed call to PrintAs[sigma] for the soldering form sigma. \
SpinorMark[sigma] stores the value of the option as an upvalue for the \
soldering form sigma.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefSpinor", "::", "usage"}], 
     "=", "\"\<DefSpinor is a renaming of DefTensor with the option \
Dagger->Complex, for the sake of clarity.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefSpinor", "::", "usage"}], 
     "=", "\"\<UndefSpinor is a renaming of UndefTensor, for the sake of \
clarity.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sigma", "::", "usage"}], 
     "=", "\"\<Sigma[sigma] is automatically transformed into the symbol \
Sigmasigma, where sigma is a soldering form. The symbol Sigmasigma is the \
head used to represent the quantity sigma[a,-A,-A\[Dagger]]sigma[b,-B,A\
\[Dagger]] which often appears in the transformation of spinor expressions \
into tensor ones.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintDaggerAs", "::", "usage"}], 
     "=", "\"\<PrintDaggerAs is an optional function for DefSpinor that \
specifies how the PrintAs string for the complex conjugate spinor should be \
generated from the PrintAs string for the original spinor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddDagger", "::", "usage"}], 
     "=", "\"\<Built-in option value for PrintDaggerAs. This option value \
simply appends the $DaggerCharacter to the string chosen for PrintAs.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddBar", "::", "usage"}], 
     "=", "\"\<Built-in option value for PrintDaggerAs. This option value \
adds an overbar to the string chosen for PrintAs.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddTilde", "::", "usage"}], 
     "=", "\"\<Built-in option value for PrintDaggerAs. This option value \
adds a tilde on top of the string chosen for PrintAs.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6074033292387247`*^9, 3.607403332062971*^9}, {
  3.612061564461231*^9, 3.612061624226408*^9}, {3.612065062090151*^9, 
  3.612065112411234*^9}, {3.612065227012702*^9, 3.612065310556301*^9}, {
  3.6120653887009077`*^9, 3.6120654142558737`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"c905b16e-4534-4397-b155-ae2456567889"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Info", " ", "functions"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TangentBundleOfSolderingForm", "::", "usage"}], 
     "=", "\"\<TangentBundleOfSolderingForm[sigma] returns the tangent bundle \
on which the soldering sigma has been defined.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SpinMetricOfSolderingForm", "::", "usage"}], 
     "=", "\"\<SpinMetricOfSolderingForm[sigma] returns the antisymmetric \
spin metric associated to the soldering form sigma.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VBundleOfSolderingForm", "::", "usage"}], 
     "=", "\"\<VBundleOfSolderingForm[sigma] returns the inner vbundle (spin \
bundle) on which the soldering form sigma has been defined.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SolderingFormOfVBundle", "::", "usage"}], 
     "=", "\"\<SolderingFormOfVBundle[vbundle] returns the soldering form \
defined on the vbundle, or Null otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SpinCovDsOfSolderingForm", "::", "usage"}], 
     "=", "\"\<SpinCovDsOfSolderingForm[sigma] returns a list of all \
covariant derivatives which are compatible with the soldering form \
sigma.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SolderingFormOfSpinCovD", "::", "usage"}], 
     "=", "\"\<SolderingFormOfSpinCovD[SpinCovD] returns the soldering form \
which is compatible with the covariant derivative SpinCovD\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[62]:=",ExpressionUUID->"08c2b265-dbc0-49e8-9779-021839cb549d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Relations", " ", "between", " ", "tensors", " ", "and", " ", "spinors"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefSpinorOfTensor", "::", "usage"}], 
     "=", "\"\<DefSpinorOfTensor[sp[inds1],tn[inds2],sigma] defines the \
spinor counterpart sp[inds1] of the already present tensor tn[inds2] with \
respect to the spin structure associated to the soldering form sigma. Spinor \
indices in the sequence inds1 must be sorted according to the pattern \
index,Dagger[index]. The symmetries of the spinor sp are automatically \
computed from those of the tensor tn.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefTensorOfSpinor", "::", "usage"}], 
     "=", "\"\<DefTensorOfSpinor[tn[inds1],sp[inds2],sigma] defines the \
tensor counterpart tn[inds1] of the already present spinor sp[inds2] with \
respect to the spin structure associated to the soldering form sigma. Spinor \
indices in the sequence inds2 must be sorted according to the pattern \
index,Dagger[index]. The symmetries of the tensor tn are automatically \
computed from those of the spinor sp.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SpinorOfTensor", "::", "usage"}], 
     "=", "\"\<SpinorOfTensor[tensor,sigma] gives the spinor counterpart of \
the tensor named tensor with respect to the spin structure associated to the \
soldering for sigma.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorOfSpinor", "::", "usage"}], 
     "=", "\"\<TensorOfSpinor[spinor,sigma] gives the tensor counterpart of \
the spinor named spinor with respect to the spin structure associated to the \
soldering for sigma.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[68]:=",ExpressionUUID->"0a1962e6-ee54-4ea1-81fc-e74f40e779b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Decomposition", " ", "of", " ", "a", " ", "spinor", " ", "into", " ", 
    "irreducible", " ", "parts"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"IrreducibleDecomposition", "::", "usage"}], 
    "=", "\"\<IrreducibleDecomposition[spinor[inds]] returns the \
decomposition of the spinor spinor[inds] into totally symmetric irreducible \
spinors. These are multiplied by apropriate factors of the antisymmetric \
metric. The irreducible spinors are constructed by appending the TF to the \
head spinor and using label indices to distinguish the different irreducible \
spinors intervening in the decomposition\>\""}], ";"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[72]:=",ExpressionUUID->"ba941f09-2b1c-4cc6-a64e-33204539373c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"The", " ", "soldering", " ", "form"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "::", "usage"}], 
     "=", "\"\<PutSolderingForm[expr, inds, sigma] contracts free indices of \
expr with the soldering form sigma. The free indices are specified by means \
of the second argument, which can be given in several formats: an index, an \
IndexList of indices, a conjugated pair Pair[A,A\[Dagger]], a vbundle, a \
tensor, a covd or an IndicesOf expression with selectors (see xTensor \
documentation). Both the second and third arguments are sequentially folded \
over lists. PutSolderingForm[expr, inds] is converted into \
PutSolderingForm[expr, inds, $SolderingForms]. PutSolderingForm[expr] is \
converted into PutSolderingForm[expr, IndicesOf[]], adding soldering forms to \
all possible indices and pairs.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractSolderingForm", "::", "usage"}], 
     "=", "\"\<ContracSolderingForm[expr, inds] replaces the contracted \
product of subexpressions in expr with one or several soldering forms by a \
new expression in which tensor or spinor indices have been inserted \
appropriately. This process may require the definition of a new tensor or \
spinor which is handled by the system automatically. The second argument \
enables us to single out specific soldering forms by selecting the dummy \
indices in the contracted product, and can be given in several formats: an \
index, an IndexList of indices, a vbundle, a tensor or an IndicesOf \
expression with selectors (see xTensor documentation).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SeparateSolderingForm", "::", "usage"}], 
     "=", "\"\<SeparateSolderingForm[sigma, basis][expr, inds] separates from \
expr a number of soldering sigma, creating new dummy indices in the given \
basis. This may require the definition of a new tensor or spinor, which is \
carried out automatically. The indices to separate are specified through the \
inds argument, which can be given in several formats: an index, an IndexList \
of indices, a vbundle, a tensor, a covd, or an IndicesOf expression with \
selectors (see xTensor documentation). The default for basis is AIndex, which \
introduces abstract dummy indices. The sigma argument is folded over lists, \
and its default is $SolderingForm. SeparateSolderingForm[][expr] is converted \
into SeparateSolderingForm[][expr, IndicesOf[]], separating all possible \
soldering forms from expr.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[73]:=",ExpressionUUID->"2c9d635c-4b8b-47b7-94f7-2aaa79a7e1b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Spinor", " ", "derivatives", " ", "and", " ", "curvature", " ", 
    "spinors"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefSpinCovD", "::", "usage"}], 
     "=", "\"\<DefSpinCovD[cd[-a],sigma,{post,pre}] defines a spin-compatible \
covariant derivative cd with respect to the spin structure associated to the \
soldering form sigma. This covariant derivative will be represented in \
StandardForm using the character pre in PreFix notation and the character \
post in PostFix notation. DefSpinCovD supports similar options as the xTensor \
command DefSpinCovD.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefSpinCovD", "::", "usage"}], 
     "=", "\"\<UndefSpinCov[scd] undefines the spin-compatible covariant \
derivative scd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SpinCovDQ", "::", "usage"}], 
     "=", "\"\<SpinCovDQ[cd] returns True if the symbol cd has been declared \
as a spin covariant derivative using DefSpinCovD, and False otherwise.\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Chi", "::", "usage"}], 
     "=", "\"\<Chi is a reserved symbol in Spinors denoting the first \
curvature spinor.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Phi", "::", "usage"}], 
     "=", "\"\<Phi is a reserved symbol in Spinors denoting the second \
curvature spinor.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Psi", "::", "usage"}], 
     "=", "\"\<Psi is a reserved symbol in Spinors denoting the Weyl \
spinor.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Lambda", "::", "usage"}], 
     "=", "\"\<Lambda is a reserved symbol in Spinors denoting the Lambda \
scalar.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Omega", "::", "usage"}], 
     "=", "\"\<Omega is a reserved symbol in Spinors denoting the torsion \
spinor\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ChiSign", "::", "usage"}], 
     "=", "\"\<$ChiSign is a global variable which sets the sign convention \
adopted to define the first curvature spinor. Its default value is +1.\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$PhiSign", "::", "usage"}], 
     "=", "\"\<$PhiSign is a global variable which sets the sign convention \
adopted to define the second curvature spinor. Its default value is \
+1.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$PsiSign", "::", "usage"}], 
     "=", "\"\<$PsiSign is a global variable which sets the sign convention \
adopted to define the Weyl spinor. Its default value is +1.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$LambdaSign", "::", "usage"}], 
     "=", "\"\<$LambdaSign is a global variable which sets the sign \
convention adopted to define the Lambda scalar. Its default value is \
+1.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$OmegaSign", "::", "usage"}], 
     "=", "\"\<$OmegaSign is a global variable which sets the sign convention \
adopted to define the torsion spinor. Its default value is +1.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Decomposition", "::", "usage"}], 
     "=", "\"\<Decomposition[expr, object, covd] decomposes curvature tensors \
of covd in expr according to predefined rules. Possible objects are Riemann, \
Ricci, TFRicci, Weyl, RicciScalar, FRiemann or Chi.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BoxToCovD", "::", "usage"}], 
     "=", "\"\<BoxToCovD[expr,boxcd] expands all instances of boxcd into \
symmetrized second covariant derivatives, according to the definition of the \
box operator.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BoxToCurvature", "::", "usage"}], 
     "=", "\"\<BoxToCurvature[expr,boxcd] expands all instances of boxcd into \
expressions which are linear in the curvature spinors of the spin covariant \
derivative cd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortSpinCovDs", "::", "usage"}], 
     "=", "\"\<SortSpinCovDs[expr,spincovd] performs a function similar to \
SortCovDs for 2-index spin covariant derivatives. The basic identity used to \
re-order the spin covariant derivatives is their commutator in terms of the \
box operator\>\""}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[76]:=",ExpressionUUID->"201cbbef-716c-48dc-8cb3-032c9666242a"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.6. Begin private", \
"Subsubsection",ExpressionUUID->"41743b7f-eb7f-4454-a27e-2564ee662039"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[93]:=",ExpressionUUID->"8092eeae-e480-4402-9069-e0bb70abbb9a"],

Cell[BoxData["\<\"xAct`Spinors`Private`\"\>"], "Output",
 CellLabel->
  "Out[93]=",ExpressionUUID->"c7ebdb7d-b998-45dd-91d6-58fc01c25aaa"]
}, Open  ]],

Cell["There are 46 reserved words in version 1.0.7 :", \
"Text",ExpressionUUID->"1d9f6aca-535c-4fa1-9542-90faee72b5a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`Spinors`*\>\"", "]"}]], "Input",
 CellLabel->"In[94]:=",ExpressionUUID->"4efc0619-b618-484d-b77c-7abceab3a457"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AddBar\"\>", ",", "\<\"AddDagger\"\>", ",", "\<\"AddTilde\"\>",
    ",", "\<\"BoxToCovD\"\>", ",", "\<\"BoxToCurvature\"\>", 
   ",", "\<\"Chi\"\>", ",", "\<\"ContractSolderingForm\"\>", 
   ",", "\<\"Decomposition\"\>", ",", "\<\"DefSpinCovD\"\>", 
   ",", "\<\"DefSpinor\"\>", ",", "\<\"DefSpinorOfTensor\"\>", 
   ",", "\<\"DefSpinStructure\"\>", ",", "\<\"DefTensorOfSpinor\"\>", 
   ",", "\<\"Disclaimer\"\>", ",", "\<\"IrreducibleDecomposition\"\>", 
   ",", "\<\"Lambda\"\>", ",", "\<\"Omega\"\>", ",", "\<\"Phi\"\>", 
   ",", "\<\"PrintDaggerAs\"\>", ",", "\<\"Psi\"\>", 
   ",", "\<\"PutSolderingForm\"\>", ",", "\<\"SeparateSolderingForm\"\>", 
   ",", "\<\"Sigma\"\>", ",", "\<\"SolderingFormOfSpinCovD\"\>", 
   ",", "\<\"SolderingFormOfVBundle\"\>", ",", "\<\"SortSpinCovDs\"\>", 
   ",", "\<\"SpinCovDQ\"\>", ",", "\<\"SpinCovDsOfSolderingForm\"\>", 
   ",", "\<\"SpinMetricOfSolderingForm\"\>", ",", "\<\"SpinorMark\"\>", 
   ",", "\<\"SpinorOfTensor\"\>", ",", "\<\"SpinorPrefix\"\>", 
   ",", "\<\"TangentBundleOfSolderingForm\"\>", ",", "\<\"TensorOfSpinor\"\>",
    ",", "\<\"UndefSpinCovD\"\>", ",", "\<\"UndefSpinor\"\>", 
   ",", "\<\"UndefSpinStructure\"\>", ",", "\<\"VBundleOfSolderingForm\"\>", 
   ",", "\<\"$ChiSign\"\>", ",", "\<\"$LambdaSign\"\>", 
   ",", "\<\"$OmegaSign\"\>", ",", "\<\"$PhiSign\"\>", 
   ",", "\<\"$PsiSign\"\>", ",", "\<\"$SolderingForms\"\>", 
   ",", "\<\"$Version\"\>", ",", "\<\"$xTensorVersionExpected\"\>"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[94]=",ExpressionUUID->"080d2b24-3e75-4f3f-89f5-ffbeb23f8ccb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Length"}]], "Input",
 CellLabel->"In[95]:=",ExpressionUUID->"2a841158-e786-48ff-82cb-59fecd9d9053"],

Cell[BoxData["46"], "Output",
 CellLabel->
  "Out[95]=",ExpressionUUID->"2ab4f95d-b318-4ba1-8b7b-02c664b9a748"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 InitializationCell->True,
 CellLabel->"In[96]:=",ExpressionUUID->"31567dbd-15b3-4255-9a81-18d14351107e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`ExpressionManipulation`\"\>", 
   ",", "\<\"Utilities`ShowTime`\"\>", ",", "\<\"xAct`Spinors`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellLabel->
  "Out[96]=",ExpressionUUID->"52d7e3a4-3646-47a2-aad0-4c9f7d198225"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[97]:=",ExpressionUUID->"3777bcfa-74b5-4b56-a6b8-5d76fb869f4d"],

Cell[BoxData["\<\"xAct`Spinors`Private`\"\>"], "Output",
 CellLabel->
  "Out[97]=",ExpressionUUID->"449514cf-be19-42df-bab6-688e2f0ca5ea"]
}, Open  ]],

Cell["Now this is not being used. Deactivated cell :", \
"Text",ExpressionUUID->"9be3b05f-daa3-4579-9932-ef8bac04c291"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BeginExamples", "[", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Set", "[", 
     RowBox[{"$Context", ",", "\"\<Global`\>\""}], "]"}], ";", 
    RowBox[{"Global`symbols", "=", 
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}]}], ";", "Null"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Global`EndExamples", "[", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<There are new symbols in Global`:\>\"", ",", "#"}], 
         "]"}]}], "]"}], ";", 
      RowBox[{"Set", "[", 
       RowBox[{"$Context", ",", "\"\<xAct`Spinors`Private`\>\""}], "]"}], ";",
       "Null"}], ")"}], "&"}], "@", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], ",", "Global`symbols"}],
     "]"}]}]}]}], "Input",
 Evaluatable->False,ExpressionUUID->"4069f438-d98e-48e3-abdb-481a622a2026"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Spin structures", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"43e13a61-cfd5-46e1-9a66-ce024987dae7"],

Cell[CellGroupData[{

Cell["2.1. Definition", "Subsubsection",
 CellChangeTimes->{{3.423571404495481*^9, 
  3.4235714113708553`*^9}},ExpressionUUID->"3bd483c5-e8b0-44af-b8a3-\
52cf4941477a"],

Cell["\<\
A spin structure is a composite abstract type formed by several objects. It \
is constructed from a previously defined manifold with metric, and constructs
\t- an inner vbundle on that manifold,
\t- the epsilon antisymmetric metric,
\t- the soldering form sigma, and
\t- a covariant derivative CDe extending the Levi-Civita of the metric.
The properties of epsilon and sigma are different for different \
manifold-dimensions and different metric-signatures. At the moment we only \
consider 4d Lorentzian spacetimes. See appendix to Penrose & Rindler.\
\>", "Text",
 CellChangeTimes->{{3.4232379918627167`*^9, 3.423238099319078*^9}, {
  3.423238196416257*^9, 3.4232384052782087`*^9}, {3.423238481267914*^9, 
  3.42323860418522*^9}, {3.423240668845462*^9, 3.4232406893383007`*^9}, {
  3.423569232261045*^9, 3.42356941527717*^9}, {3.423657460858736*^9, 
  3.423657461426669*^9}, {3.4236575316726027`*^9, 3.423657533420804*^9}, {
  3.423657771172862*^9, 3.423657772074744*^9}, {3.426358503580083*^9, 
  3.4263585401527653`*^9}, {3.4941373297904663`*^9, 
  3.494137366791766*^9}},ExpressionUUID->"79941112-4c4b-4075-ad2b-\
44ddd543a41b"],

Cell["\<\
We start by checking the properties of the preexisting metric\
\>", "Text",
 CellChangeTimes->{{3.4232388320700808`*^9, 3.423238841205277*^9}, {
  3.423238914320393*^9, 3.4232389288606043`*^9}, {3.42323960154422*^9, 
  3.423239606421177*^9}, {3.423569439514832*^9, 
  3.423569443532433*^9}},ExpressionUUID->"aeebb9cd-b5b2-4c1e-92a5-\
9c855a66c5ae"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CheckMetric", "[", 
    RowBox[{"metric_", ",", "tbundle_"}], "]"}], ":=", "\[IndentingNewLine]", 
   
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"!", 
      RowBox[{"MetricQ", "[", "metric", "]"}]}], ",", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"DefSpinStructure", "::", "unknown"}], ",", "\"\<metric\>\"", 
        ",", "metric"}], "]"}]}], ",", 
     RowBox[{"xAct`xTensor`Private`FrozenMetricQ", "[", "metric", "]"}], ",", 
     
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"DefSpinStructure", "::", "error"}], 
        ",", "\"\<A frozen metric cannot be used.\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TangentBundleOfManifold", "@", 
       RowBox[{"BaseOfVBundle", "@", "tbundle"}]}], "=!=", "tbundle"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"DefSpinStructure", "::", "error"}], 
        ",", "\"\<The metric must be defined on a tangent bundle.\>\""}], 
       "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"DimOfVBundle", "[", "tbundle", "]"}], "=!=", "4"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"DefSpinStructure", "::", "notyet"}], 
        ",", "\"\<non 4d manifolds\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SignDetOfMetric", "[", "metric", "]"}], "=!=", 
      RowBox[{"-", "1"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"DefSpinStructure", "::", "invalid"}], ",", "metric", 
        ",", "\"\<Lorentzian metric\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SignatureOfMetric", "[", "metric", "]"}], "=!=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"DefSpinStructure", "::", "invalid"}], ",", "metric", 
        ",", "\"\<metric of signature +,-,-,-.\>\""}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"626820df-143b-432c-8dc0-fb2f5e05e415"],

Cell[TextData[{
 "Something annoying in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that With cannot replace pattern names whitin Set, Rule and similar \
constructs. We want to pass correct indices to our definitions and so we \
define intermediate holding heads isetdelayed, itagset and itagsetdelayed to \
fool ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " during the evaluation of With:"
}], "Text",
 CellChangeTimes->{{3.423285386458552*^9, 3.423285547173077*^9}, 
   3.425991310206135*^9, {3.4271950790469303`*^9, 
   3.427195085611188*^9}},ExpressionUUID->"b4381a16-2c1b-4e27-b2bf-\
ad5626464e41"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"isetdelayed", ",", "itagset", ",", "itagsetdelayed"}], "}"}], ",",
     "HoldAll"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"isetdelayed", "=", "SetDelayed"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"itagset", "=", "TagSet"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"itagsetdelayed", "=", "TagSetDelayed"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.423284455119913*^9, 3.423284485783136*^9}, {
  3.423284636948946*^9, 3.4232846500985327`*^9}, {3.423285374947356*^9, 
  3.423285383764449*^9}, {3.425991311184124*^9, 3.425991312219061*^9}, {
  3.42702223664646*^9, 
  3.4270222576800737`*^9}},ExpressionUUID->"b52f3a2a-4be8-4b0e-a632-\
38fccfb6b7ce"],

Cell["\<\
Global variable storing all defined soldering forms. It is used by \
ContractSolderingForm:\
\>", "Text",
 CellChangeTimes->{{3.42358071955168*^9, 3.423580735483164*^9}, {
  3.423657679468595*^9, 3.4236576920230703`*^9}, {3.427195094061357*^9, 
  3.427195095780442*^9}},ExpressionUUID->"345daa08-5fa5-447b-a496-\
01a0eed41e1e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$SolderingForms", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.423580741632552*^9, 
  3.423580747914942*^9}},ExpressionUUID->"103fc389-bdea-4073-bf7c-\
c7b4833620c2"],

Cell["Sigma spinor, square of the soldering form :", "Text",
 CellChangeTimes->{{3.4236697415637817`*^9, 
  3.423669751643671*^9}},ExpressionUUID->"268886f8-df38-42d9-8652-\
05959d57a698"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Sigma", "[", "sigma_Symbol", "]"}], ":=", 
   RowBox[{"GiveSymbol", "[", 
    RowBox[{"Sigma", ",", "sigma"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GiveOutputString", "[", 
    RowBox[{"Sigma", ",", "sigma_Symbol"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\[CapitalSigma]\>\"", ",", 
     RowBox[{"PrintAs", "[", "sigma", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Sigma", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Sigma", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.423660349959141*^9, 3.42366040170255*^9}, {
  3.423663106725088*^9, 3.4236631094791822`*^9}, {3.425991414384799*^9, 
  3.4259914181570253`*^9}, {3.427195133918644*^9, 
  3.427195141805623*^9}},ExpressionUUID->"f886cd8b-13f1-450f-ad75-\
9a2f1848d8fb"],

Cell["\<\
Main function :
      - It is difficult to do name validation in this function because there \
are many names to validate.
      - We cannot pass the PrintAs values of vbundle, epsilon and sigma. Do \
that later by hand.
      - epsdag is constructed before eps is validated. We trust the user in \
this point...\
\>", "Text",
 CellChangeTimes->{{3.494137545983885*^9, 
  3.494137548001918*^9}},ExpressionUUID->"d9f264c5-4d79-436a-8080-\
40fcad27cd95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DefSpinStructure"}]], "Input",
 CellChangeTimes->{{3.409488943333411*^9, 
  3.409488957353121*^9}},ExpressionUUID->"94525fd6-960a-42d1-be8d-\
587f159f3745"],

Cell[BoxData[
 StyleBox["\<\"DefSpinStructure[g, VB, {A,B,C,...}, epsilon, sigma, CDe,  \
options] defines a spin structure on the manifold in which the metric g[-a, \
-b] is defined, creating the inner vbundle VB with abstract indices \
{A,B,C,...}. Currently it only works on 4-dimensional Lorentzian manifolds, \
and so VB is defined as 2-dimensional and complex. The spin metric is \
epsilon[-A, -B] and the soldering form is sigma[a, -B, -B\[Dagger]]. The spin \
covariant derivative CDe,  compatible with sigma and epsilon, is defined on \
this vbundle extending the Levi-Civita connection of g. We adopt the \
convention of taking the head of the soldering form as the symbol \
representing the spin structure.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3588025981-1170166",ExpressionUUID->"6b524cd3-5d52-41f2-8245-\
5e25106ac08b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Options", " ", "for", " ", "formatting"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "DefSpinStructure", "]"}], ":=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SpinorPrefix", "\[Rule]", "Identity"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SpinorMark", "\[Rule]", "PrintAs"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"DefInfo", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<spin structure\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
      "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Backwards", " ", "compatibility"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefSpinStructure", "[", 
      RowBox[{
      "metric_", ",", "vbundle_", ",", "vbinds_", ",", "eps_", ",", "sigma_", 
       ",", "cd_", ",", 
       RowBox[{"cdsymbols", ":", 
        RowBox[{"{", 
         RowBox[{"_String", ",", "_String"}], "}"}]}], ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"DefSpinStructure", "[", 
      RowBox[{
      "metric", ",", "vbundle", ",", "vbinds", ",", "eps", ",", "sigma", ",", 
       "cd", ",", 
       RowBox[{"SymbolOfCovD", "\[Rule]", "cdsymbols"}], ",", "options"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Main", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefSpinStructure", "[", 
      RowBox[{
      "metric_Symbol", ",", "vbundle_Symbol", ",", "vbinds_List", ",", 
       "eps_Symbol", ",", "sigma_Symbol", ",", "cd_Symbol", ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Catch", "@", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"tbundle", "=", 
          RowBox[{"VBundleOfMetric", "[", "metric", "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"CheckMetric", "[", 
          RowBox[{"metric", ",", "tbundle"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"With", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"base", "=", 
              RowBox[{"BaseOfVBundle", "[", "tbundle", "]"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"covd", "=", 
              RowBox[{"CovDOfMetric", "[", "metric", "]"}]}]}], "}"}], ",", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{
            "1.", " ", "Create", " ", "2", "d", " ", "complex", " ", "inner", 
             " ", "vbundle"}], " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"DefVBundle", "[", 
             RowBox[{"vbundle", ",", "base", ",", "2", ",", "vbinds", ",", 
              RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
              RowBox[{"FilterRules", "[", 
               RowBox[{
                RowBox[{"{", "options", "}"}], ",", 
                RowBox[{"Options", "[", "DefVBundle", "]"}]}], "]"}]}], "]"}],
             ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "2.", " ", "Relations", " ", "in", " ", "the", " ", "spin", " ", 
              "structure"}], " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}], "^=", 
             "vbundle"}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"SolderingFormOfVBundle", "[", "vbundle", "]"}], "^=", 
             "sigma"}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"TangentBundleOfSolderingForm", "[", "sigma", "]"}], "^=",
              "tbundle"}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"SpinMetricOfSolderingForm", "[", "sigma", "]"}], "^=", 
             "eps"}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"SpinCovDsOfSolderingForm", "[", "sigma", "]"}], "^=", 
             RowBox[{"{", "}"}]}], ";", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"{", "cd", "}"}], ";"}], "*)"}], "\[IndentingNewLine]", 
            
            RowBox[{
             RowBox[{"SolderingFormOfSpinCovD", "[", "cd", "]"}], "^=", 
             "sigma"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "3.", " ", "Construct", " ", "indices", " ", "and", " ", "feed", 
              " ", "them", " ", "with", " ", "With"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
               "Ai", ",", "Adi", ",", "Bi", ",", "Bdi", ",", "Ci", ",", "Cdi",
                 ",", "Di", ",", "Ddi", ",", "ai", ",", "bi", ",", "ci", ",", 
                "di", ",", "ei", ",", "fi"}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Ai", ",", "Bi", ",", "Ci", ",", "Di"}], "}"}], "=", 
                
                RowBox[{"GetIndicesOfVBundle", "[", 
                 RowBox[{"vbundle", ",", "4", ",", 
                  RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Adi", ",", "Bdi", ",", "Cdi", ",", "Ddi"}], "}"}], "=", 
                RowBox[{"DaggerIndex", "/@", 
                 RowBox[{"{", 
                  RowBox[{"Ai", ",", "Bi", ",", "Ci", ",", "Di"}], "}"}]}]}], 
               ";", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "ai", ",", "bi", ",", "ci", ",", "di", ",", "ei", ",", 
                  "fi"}], "}"}], "=", 
                RowBox[{"GetIndicesOfVBundle", "[", 
                 RowBox[{"tbundle", ",", "6", ",", 
                  RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"With", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"A", "=", "Ai"}], ",", 
                   RowBox[{"Ad", "=", "Adi"}], ",", 
                   RowBox[{"B", "=", "Bi"}], ",", 
                   RowBox[{"Bd", "=", "Bdi"}], ",", 
                   RowBox[{"C", "=", "Ci"}], ",", 
                   RowBox[{"Cd", "=", "Cdi"}], ",", 
                   RowBox[{"D", "=", "Di"}], ",", 
                   RowBox[{"Dd", "=", "Ddi"}], ",", 
                   RowBox[{"a", "=", "ai"}], ",", 
                   RowBox[{"b", "=", "bi"}], ",", 
                   RowBox[{"c", "=", "ci"}], ",", 
                   RowBox[{"d", "=", "di"}], ",", 
                   RowBox[{"e", "=", "ei"}], ",", 
                   RowBox[{"f", "=", "fi"}], ",", 
                   RowBox[{"vbundledag", "=", 
                    RowBox[{"Dagger", "[", "vbundle", "]"}]}], ",", 
                   RowBox[{"epsdag", "=", 
                    RowBox[{"MakeDaggerSymbol", "[", "eps", "]"}]}]}], "}"}], 
                 ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 RowBox[{"(*", " ", 
                  RowBox[{
                  "4.", " ", "Define", " ", "the", " ", "soldering", " ", 
                   "form"}], " ", "*)"}], "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"DefTensor", "[", 
                   RowBox[{
                    RowBox[{"sigma", "[", 
                    RowBox[{"a", ",", 
                    RowBox[{"-", "C"}], ",", 
                    RowBox[{"-", "Dd"}]}], "]"}], ",", "base", ",", 
                    RowBox[{"Dagger", "\[Rule]", "Hermitian"}], ",", 
                    RowBox[{"ProtectNewSymbol", "\[Rule]", "False"}], ",", 
                    RowBox[{"Master", "\[Rule]", "vbundle"}], ",", 
                    RowBox[{"DefInfo", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<soldering form\>\"", ",", "\"\<\>\""}], 
                    "}"}]}], ",", 
                    RowBox[{"FilterRules", "[", 
                    RowBox[{
                    RowBox[{"{", "options", "}"}], ",", 
                    RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}]}], 
                   "]"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"AppendTo", "[", 
                   RowBox[{"$SolderingForms", ",", "sigma"}], "]"}], ";", 
                  "\[IndentingNewLine]", "\[IndentingNewLine]", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                   "5.", " ", "Define", " ", "eps", " ", "and", " ", "its", " ",
                     "conjugate"}], " ", "*)"}], "\[IndentingNewLine]", 
                  RowBox[{"DefTensor", "[", 
                   RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], ",", "base", ",", 
                    RowBox[{"Antisymmetric", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
                    RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
                    RowBox[{"ProtectNewSymbol", "\[Rule]", "False"}], ",", 
                    RowBox[{"Master", "\[Rule]", "sigma"}], ",", 
                    RowBox[{"DefInfo", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<spin metric\>\"", ",", "\"\<\>\""}], "}"}]}],
                     ",", 
                    RowBox[{"FilterRules", "[", 
                    RowBox[{
                    RowBox[{"{", "options", "}"}], ",", 
                    RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}]}], 
                   "]"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"(*", " ", 
                   RowBox[{"Metric", " ", "properties"}], " ", "*)"}], 
                  "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"MetricQ", "[", "eps", "]"}], "^=", "True"}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"MetricQ", "[", "epsdag", "]"}], "^=", "True"}], ";",
                   "\[IndentingNewLine]", 
                  RowBox[{"xUpAppendTo", "[", 
                   RowBox[{
                    RowBox[{"MetricsOfVBundle", "[", "vbundle", "]"}], ",", 
                    "eps"}], "]"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"xUpAppendTo", "[", 
                   RowBox[{
                    RowBox[{"MetricsOfVBundle", "[", "vbundledag", "]"}], ",",
                     "epsdag"}], "]"}], ";", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"VBundleOfMetric", "[", "eps", "]"}], "^=", 
                   "vbundle"}], ";", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"VBundleOfMetric", "[", "epsdag", "]"}], "^=", 
                   "vbundledag"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"$Metrics", "=", 
                   RowBox[{"Join", "[", 
                    RowBox[{"$Metrics", ",", 
                    RowBox[{"{", 
                    RowBox[{"eps", ",", "epsdag"}], "}"}]}], "]"}]}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"InducedFrom", "[", "eps", "]"}], "^=", "Null"}], ";",
                   "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"InducedFrom", "[", "epsdag", "]"}], "^=", 
                   "Null"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                   "Conversion", " ", "into", " ", "delta", " ", "for", " ", 
                    "mixed", " ", "abstract", " ", "indices"}], " ", "*)"}], 
                  "\[IndentingNewLine]", 
                  RowBox[{"isetdelayed", "[", 
                   RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{"A_Symbol", ",", 
                    RowBox[{"-", "B_Symbol"}]}], "]"}], ",", 
                    RowBox[{"delta", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"-", "B"}]}], "]"}]}], "]"}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"isetdelayed", "[", 
                   RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A_Symbol"}], ",", "B_Symbol"}], "]"}], ",", 
                    
                    RowBox[{"delta", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", "B"}], "]"}]}], "]"}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"isetdelayed", "[", 
                   RowBox[{
                    RowBox[{"epsdag", "[", 
                    RowBox[{"A_Symbol", ",", 
                    RowBox[{"-", "B_Symbol"}]}], "]"}], ",", 
                    RowBox[{"delta", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"-", "B"}]}], "]"}]}], "]"}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"isetdelayed", "[", 
                   RowBox[{
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "A_Symbol"}], ",", "B_Symbol"}], "]"}], ",", 
                    
                    RowBox[{"delta", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", "B"}], "]"}]}], "]"}], ";", 
                  "\[IndentingNewLine]", "\[IndentingNewLine]", 
                  RowBox[{"(*", " ", 
                   RowBox[{"6.", " ", "Spinor", " ", "construction"}], " ", 
                   "*)"}], "\[IndentingNewLine]", 
                  RowBox[{"Module", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"sigmaprefix", ",", "sigmamark"}], "}"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"sigmaprefix", ",", "sigmamark"}], "}"}], "=", 
                    RowBox[{"OptionValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"DefSpinStructure", ",", "DefCovD"}], "}"}], ",", 
                    
                    RowBox[{"{", "options", "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"SpinorPrefix", ",", "SpinorMark"}], "}"}]}], 
                    "]"}]}], ";", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"SpinorPrefix", "[", "sigma", "]"}], "^=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"sigmaprefix", "===", "Identity"}], ",", "sigma", 
                    ",", "sigmaprefix"}], "]"}]}], ";", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"SpinorMark", "[", "sigma", "]"}], "^=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"sigmamark", "===", "PrintAs"}], ",", 
                    RowBox[{"PrintAs", "[", "sigma", "]"}], ",", 
                    "sigmamark"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
                   "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                   "7.", " ", "Products", " ", "of", " ", "two", " ", 
                    "sigma"}], " ", "*)"}], "\[IndentingNewLine]", 
                  RowBox[{"With", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"vQ", "=", 
                    RowBox[{
                    "xAct`xTensor`Private`VBundleIndexPMQ", "[", "vbundle", 
                    "]"}]}], ",", 
                    RowBox[{"vdQ", "=", 
                    RowBox[{
                    "xAct`xTensor`Private`VBundleIndexPMQ", "[", "vbundledag",
                     "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"itagset", "[", 
                    RowBox[{"sigma", ",", 
                    RowBox[{
                    RowBox[{"sigma", "[", 
                    RowBox[{"a_", ",", "A_", ",", "Dd_"}], "]"}], 
                    RowBox[{"sigma", "[", 
                    RowBox[{
                    RowBox[{"-", "a_"}], ",", "C_", ",", "Cd_"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{"A", ",", "C"}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Dd", ",", "Cd"}], "]"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"AutomaticRules", "[", 
                    RowBox[{"sigma", ",", 
                    RowBox[{"MakeRule", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"sigma", "[", 
                    RowBox[{"a", ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Dd"}]}], "]"}], 
                    RowBox[{"sigma", "[", 
                    RowBox[{"b", ",", "B", ",", "Dd"}], "]"}]}], ",", 
                    RowBox[{"metric", "[", 
                    RowBox[{"a", ",", "b"}], "]"}]}], "}"}], ",", 
                    RowBox[{"MetricOn", "\[Rule]", "All"}], ",", 
                    RowBox[{"ContractMetrics", "\[Rule]", "False"}], ",", 
                    RowBox[{"TestIndices", "\[Rule]", "False"}]}], "]"}], ",", 
                    RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}]}]}], 
                   "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"With", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Sigmaname", "=", 
                    RowBox[{"GiveSymbol", "[", 
                    RowBox[{"Sigma", ",", "sigma"}], "]"}]}], ",", 
                    RowBox[{"Tetraname", "=", 
                    RowBox[{"Tetra", "[", "metric", "]"}]}]}], "}"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"DefTensor", "[", 
                    RowBox[{
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{"a", ",", "b", ",", 
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], ",", "base", ",", 
                    RowBox[{"StrongGenSet", "[", 
                    RowBox[{
                    RowBox[{"{", "1", "}"}], ",", 
                    RowBox[{"GenSet", "[", 
                    RowBox[{"-", 
                    RowBox[{"xAct`xPerm`Cycles", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}],
                     ",", 
                    RowBox[{"PrintAs", "\[RuleDelayed]", 
                    RowBox[{"GiveOutputString", "[", 
                    RowBox[{"Sigma", ",", "sigma"}], "]"}]}], ",", 
                    RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
                    RowBox[{"Master", "\[Rule]", "sigma"}], ",", 
                    RowBox[{"FilterRules", "[", 
                    RowBox[{
                    RowBox[{"{", "options", "}"}], ",", 
                    RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}]}], 
                    "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{"a_", ",", "b_", ",", "C_", ",", 
                    RowBox[{"-", "C_"}]}], "]"}], ":=", 
                    RowBox[{"-", 
                    RowBox[{"metric", "[", 
                    RowBox[{"a", ",", "b"}], "]"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{"a_", ",", "b_", ",", 
                    RowBox[{"-", "C_"}], ",", "C_"}], "]"}], ":=", 
                    RowBox[{"metric", "[", 
                    RowBox[{"a", ",", "b"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{"a_", ",", 
                    RowBox[{"-", "a_"}], ",", "C_", ",", "D_"}], "]"}], ":=", 
                    
                    RowBox[{
                    RowBox[{"-", "2"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{"C", ",", "D"}], "]"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{
                    RowBox[{"-", "a_"}], ",", "a_", ",", "C_", ",", "D_"}], 
                    "]"}], ":=", 
                    RowBox[{
                    RowBox[{"-", "2"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{"C", ",", "D"}], "]"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Sigmanamedag", "=", 
                    RowBox[{"Dagger", "[", "Sigmaname", "]"}]}], ",", 
                    RowBox[{"Tetranamedag", "=", 
                    RowBox[{"Dagger", "[", "Tetraname", "]"}]}]}], "}"}], ",",
                     "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sigmanamedag", "[", 
                    RowBox[{"a_", ",", "b_", ",", "Cd_", ",", 
                    RowBox[{"-", "Cd_"}]}], "]"}], ":=", 
                    RowBox[{"-", 
                    RowBox[{"metric", "[", 
                    RowBox[{"a", ",", "b"}], "]"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Sigmanamedag", "[", 
                    RowBox[{"a_", ",", "b_", ",", 
                    RowBox[{"-", "Cd_"}], ",", "Cd_"}], "]"}], ":=", 
                    RowBox[{"metric", "[", 
                    RowBox[{"a", ",", "b"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Sigmanamedag", "[", 
                    RowBox[{"a_", ",", 
                    RowBox[{"-", "a_"}], ",", "Cd_", ",", "Dd_"}], "]"}], ":=", 
                    RowBox[{
                    RowBox[{"-", "2"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Cd", ",", "Dd"}], "]"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Sigmanamedag", "[", 
                    RowBox[{
                    RowBox[{"-", "a_"}], ",", "a_", ",", "Cd_", ",", "Dd_"}], 
                    "]"}], ":=", 
                    RowBox[{
                    RowBox[{"-", "2"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Cd", ",", "Dd"}], "]"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"AutomaticRules", "[", 
                    RowBox[{"Sigmaname", ",", 
                    RowBox[{"MakeRule", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{"a", ",", "b", ",", "A", ",", "B"}], "]"}], 
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{"c", ",", "d", ",", "C", ",", 
                    RowBox[{"-", "B"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Tetraname", "[", 
                    RowBox[{"b", ",", "d", ",", 
                    RowBox[{"-", "e"}], ",", "a"}], "]"}]}], 
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{"e", ",", "c", ",", "A", ",", "C"}], "]"}]}]}], 
                    "}"}], ",", 
                    RowBox[{"MetricOn", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], 
                    "}"}]}], ",", 
                    RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}], ",", 
                    RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"AutomaticRules", "[", 
                    RowBox[{"Sigmanamedag", ",", 
                    RowBox[{"MakeRule", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sigmanamedag", "[", 
                    RowBox[{"a", ",", "b", ",", "Ad", ",", "Dd"}], "]"}], 
                    RowBox[{"Sigmanamedag", "[", 
                    RowBox[{"c", ",", "d", ",", "Cd", ",", 
                    RowBox[{"-", "Dd"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Tetranamedag", "[", 
                    RowBox[{"b", ",", "d", ",", 
                    RowBox[{"-", "e"}], ",", "a"}], "]"}]}], 
                    RowBox[{"Sigmanamedag", "[", 
                    RowBox[{"e", ",", "c", ",", "Ad", ",", "Cd"}], "]"}]}]}], 
                    "}"}], ",", 
                    RowBox[{"MetricOn", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    "a", ",", "b", ",", "c", ",", "d", ",", "Ad", ",", "Cd"}],
                     "}"}]}], ",", 
                    RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}], ",", 
                    RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"itagsetdelayed", "[", 
                    RowBox[{"Sigmaname", ",", 
                    RowBox[{
                    RowBox[{"Tetraname", "[", 
                    RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}], 
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{"e_", ",", "f_", ",", "C_", ",", "D_"}], "]"}]}], 
                    ",", 
                    RowBox[{"Condition", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"metric", "[", 
                    RowBox[{"a", ",", "b"}], "]"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{"C", ",", "D"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"PairQ", "[", 
                    RowBox[{"c", ",", "e"}], "]"}], "&&", 
                    RowBox[{"PairQ", "[", 
                    RowBox[{"d", ",", "f"}], "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"PairQ", "[", 
                    RowBox[{"c", ",", "f"}], "]"}], "&&", 
                    RowBox[{"PairQ", "[", 
                    RowBox[{"d", ",", "e"}], "]"}]}]}]}], "]"}]}], "]"}], ";",
                     "\[IndentingNewLine]", 
                    RowBox[{"itagsetdelayed", "[", 
                    RowBox[{"Sigmaname", ",", 
                    RowBox[{
                    RowBox[{"Tetraname", "[", 
                    RowBox[{"c_", ",", "d_", ",", "a_", ",", "b_"}], "]"}], 
                    RowBox[{"Sigmaname", "[", 
                    RowBox[{"e_", ",", "f_", ",", "C_", ",", "D_"}], "]"}]}], 
                    ",", 
                    RowBox[{"Condition", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"metric", "[", 
                    RowBox[{"a", ",", "b"}], "]"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{"C", ",", "D"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"PairQ", "[", 
                    RowBox[{"c", ",", "e"}], "]"}], "&&", 
                    RowBox[{"PairQ", "[", 
                    RowBox[{"d", ",", "f"}], "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"PairQ", "[", 
                    RowBox[{"c", ",", "f"}], "]"}], "&&", 
                    RowBox[{"PairQ", "[", 
                    RowBox[{"d", ",", "e"}], "]"}]}]}]}], "]"}]}], "]"}], ";",
                     "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"itagsetdelayed", "[", 
                    RowBox[{"Sigmanamedag", ",", 
                    RowBox[{
                    RowBox[{"Tetranamedag", "[", 
                    RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}], 
                    RowBox[{"Sigmanamedag", "[", 
                    RowBox[{"e_", ",", "f_", ",", "Cd_", ",", "Dd_"}], 
                    "]"}]}], ",", 
                    RowBox[{"Condition", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"metric", "[", 
                    RowBox[{"a", ",", "b"}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Cd", ",", "Dd"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"PairQ", "[", 
                    RowBox[{"c", ",", "e"}], "]"}], "&&", 
                    RowBox[{"PairQ", "[", 
                    RowBox[{"d", ",", "f"}], "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"PairQ", "[", 
                    RowBox[{"c", ",", "f"}], "]"}], "&&", 
                    RowBox[{"PairQ", "[", 
                    RowBox[{"d", ",", "e"}], "]"}]}]}]}], "]"}]}], "]"}], ";",
                     "\[IndentingNewLine]", 
                    RowBox[{"itagsetdelayed", "[", 
                    RowBox[{"Sigmanamedag", ",", 
                    RowBox[{
                    RowBox[{"Tetranamedag", "[", 
                    RowBox[{"c_", ",", "d_", ",", "a_", ",", "b_"}], "]"}], 
                    RowBox[{"Sigmanamedag", "[", 
                    RowBox[{"e_", ",", "f_", ",", "Cd_", ",", "Dd_"}], 
                    "]"}]}], ",", 
                    RowBox[{"Condition", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"metric", "[", 
                    RowBox[{"a", ",", "b"}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Cd", ",", "Dd"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"PairQ", "[", 
                    RowBox[{"c", ",", "e"}], "]"}], "&&", 
                    RowBox[{"PairQ", "[", 
                    RowBox[{"d", ",", "f"}], "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"PairQ", "[", 
                    RowBox[{"c", ",", "f"}], "]"}], "&&", 
                    RowBox[{"PairQ", "[", 
                    RowBox[{"d", ",", "e"}], "]"}]}]}]}], "]"}]}], "]"}], 
                    ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
                   "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
                  "\[IndentingNewLine]", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                   "8.", " ", "Define", " ", "the", " ", "spinor", " ", 
                    "equivalent", " ", "of", " ", "the", " ", "metric", " ", 
                    "tensor", " ", "and", " ", "the", " ", "volume", " ", 
                    "element"}], " ", "*)"}], "\[IndentingNewLine]", 
                  RowBox[{"With", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"MetricName", "=", 
                    RowBox[{"AddSpinorPrefix", "[", 
                    RowBox[{"metric", ",", 
                    RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EpsilonSpin", "=", 
                    RowBox[{"AddSpinorPrefix", "[", 
                    RowBox[{
                    RowBox[{"epsilon", "@", "metric"}], ",", 
                    RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "]"}]}]}], 
                    "}"}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"DefSpinorOfTensor", "[", 
                    RowBox[{
                    RowBox[{"MetricName", "[", 
                    RowBox[{"A", ",", "Cd", ",", "B", ",", "Dd"}], "]"}], ",", 
                    RowBox[{"metric", "[", 
                    RowBox[{
                    RowBox[{"-", "a"}], ",", 
                    RowBox[{"-", "b"}]}], "]"}], ",", "sigma", ",", 
                    RowBox[{"FilterRules", "[", 
                    RowBox[{
                    RowBox[{"{", "options", "}"}], ",", 
                    RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}]}], 
                    "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"itagset", "[", 
                    RowBox[{"MetricName", ",", 
                    RowBox[{"MetricName", "[", 
                    RowBox[{"A_", ",", "Cd_", ",", "B_", ",", "Dd_"}], "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{"A", ",", "B"}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Cd", ",", "Dd"}], "]"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"DefSpinorOfTensor", "[", 
                    RowBox[{
                    RowBox[{"EpsilonSpin", "[", 
                    RowBox[{
                    "A", ",", "Ad", ",", "B", ",", "Bd", ",", "C", ",", "Cd", 
                    ",", "D", ",", "Dd"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"epsilon", "[", "metric", "]"}], "[", 
                    RowBox[{
                    RowBox[{"-", "a"}], ",", 
                    RowBox[{"-", "b"}], ",", 
                    RowBox[{"-", "c"}], ",", 
                    RowBox[{"-", "d"}]}], "]"}], ",", "sigma", ",", 
                    "options"}], "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"itagsetdelayed", "[", 
                    RowBox[{"EpsilonSpin", ",", 
                    RowBox[{"EpsilonSpin", "[", 
                    RowBox[{
                    "A_", ",", "Ad_", ",", "B_", ",", "Bd_", ",", "C_", ",", 
                    "Cd_", ",", "D_", ",", "Dd_"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"epsilonOrientation", "[", 
                    RowBox[{"metric", ",", "AIndex"}], "]"}], " ", "I", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"eps", "[", 
                    RowBox[{"A", ",", "D"}], "]"}]}], 
                    RowBox[{"eps", "[", 
                    RowBox[{"B", ",", "C"}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Ad", ",", "Cd"}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Bd", ",", "Dd"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{"A", ",", "C"}], "]"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{"B", ",", "D"}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Ad", ",", "Dd"}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"Bd", ",", "Cd"}], "]"}]}]}], ")"}]}]}], "]"}], 
                    ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
                  "\[IndentingNewLine]", "\[IndentingNewLine]", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                   "9.", " ", "Define", " ", "the", " ", "covariant", " ", 
                    "derivative", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    "and", " ", "the", " ", "curvature", " ", "spinors"}], 
                    ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
                  RowBox[{"DefSpinCovD", "[", 
                   RowBox[{
                    RowBox[{"cd", "[", 
                    RowBox[{"-", "a"}], "]"}], ",", "sigma", ",", 
                    RowBox[{"Torsion", "\[Rule]", 
                    RowBox[{"TorsionQ", "@", "covd"}]}], ",", 
                    RowBox[{"ExtendedFrom", "\[Rule]", "covd"}], ",", 
                    RowBox[{"Master", "\[Rule]", "sigma"}], ",", 
                    RowBox[{"ProtectNewSymbol", "\[Rule]", "False"}], ",", 
                    RowBox[{"FilterRules", "[", 
                    RowBox[{
                    RowBox[{"{", "options", "}"}], ",", 
                    RowBox[{"Options", "[", "DefSpinCovD", "]"}]}], "]"}]}], 
                   "]"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                    RowBox[{"Compatibility", " ", "with", " ", "metric"}], ",",
                     " ", 
                    RowBox[{
                    "for", " ", "all", " ", "index", " ", 
                    "configurations"}]}], " ", "*)"}], "\[IndentingNewLine]", 
                  
                  RowBox[{"isetdelayed", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"cd", "[", "a__", "]"}], "[", 
                    RowBox[{"eps", "[", 
                    RowBox[{"A_", ",", "B_"}], "]"}], "]"}], ",", "0"}], 
                   "]"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"isetdelayed", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"cd", "[", "a__", "]"}], "[", 
                    RowBox[{"epsdag", "[", 
                    RowBox[{"A_", ",", "B_"}], "]"}], "]"}], ",", "0"}], 
                   "]"}], ";", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"CovDOfMetric", "[", "eps", "]"}], "^=", "cd"}], ";",
                   "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"CovDOfMetric", "[", "epsdag", "]"}], "^=", "cd"}],
                   ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}], 
          "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"DefSpinStructure", ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "DefSpinStructure", "]"}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.598184318060506*^9, 3.5981843239509573`*^9}, {
  3.598184449146654*^9, 3.598184463861652*^9}, {3.598184520083227*^9, 
  3.598184526720064*^9}, {3.6005191580653477`*^9, 
  3.600519176809597*^9}},ExpressionUUID->"a70d3918-4e3b-4eda-9de5-\
b50333dec1d6"],

Cell["\<\
Alfonso: in the formula which gives the decomposition of the spinor \
couterpart of the volume element there is a sign discrepancy between our \
formula and the formula of Penrose & Rindler. I think that this has to do \
with some convention when defining the volume element.\
\>", "Text",
 CellChangeTimes->{{3.427351652390977*^9, 3.4273517191947603`*^9}, {
  3.427371503328878*^9, 3.4273715056962442`*^9}, {3.494137575214916*^9, 
  3.4941375773088617`*^9}},ExpressionUUID->"08b59087-440a-425e-bb20-\
5bed10791f9b"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. Undefinition", "Subsubsection",
 CellChangeTimes->{{3.423669254158578*^9, 
  3.4236692569915667`*^9}},ExpressionUUID->"b5b5365a-5b73-4269-b08a-\
0544b4786010"],

Cell["\<\
To undefine a spin structure, undefine its soldering form (preferred), \
vbundle or covd.\
\>", "Text",
 CellChangeTimes->{{3.408447814087221*^9, 3.408447846487019*^9}, {
  3.408447879890625*^9, 3.408447893562587*^9}, {3.423301205086478*^9, 
  3.423301207888174*^9}, {3.423571339244152*^9, 3.423571351654107*^9}, {
  3.4259914829135523`*^9, 3.42599148480626*^9}, {3.425991528934966*^9, 
  3.425991542534815*^9}, {3.425991720118825*^9, 
  3.4259917230708227`*^9}},ExpressionUUID->"8782a1fc-eb27-48b0-8b0e-\
c8878f6dc4a1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UndefSpinStructure", "[", 
    RowBox[{"vbundle_", "?", "VBundleQ"}], "]"}], ":=", 
   RowBox[{"UndefSpinStructure", "[", 
    RowBox[{"SolderingFormOfVBundle", "[", "vbundle", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefSpinStructure", "[", 
    RowBox[{"covd_", "?", "CovDQ"}], "]"}], ":=", 
   RowBox[{"UndefSpinStructure", "[", 
    RowBox[{"SolderingFormOfSpinCovD", "[", "covd", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefSpinStructure", "[", 
    RowBox[{"sigma_", "?", "xTensorQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"newlist", "=", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{"$SolderingForms", ",", "sigma"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"UndefVBundle", "[", 
        RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"$SolderingForms", "=", "newlist"}], ";"}]}], "]"}], "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{"$SolderingForms", ",", "sigma"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefSpinStructure", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"UndefSpinStructure", "::", "unknown"}], 
      ",", "\"\<spin structure\>\"", ",", " ", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"UndefSpinStructure", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "UndefSpinStructure", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"9dfba42c-ef70-41b7-95fb-9786a408a787"],

Cell["\<\
Just one comment : we compute initially the new list $SolderingForms, while \
sigma still exists, and store it in newlist. We then remove the spin \
structure, checking that everything goes smoothly. Finally, we update the \
value of the symbol $SolderingForms. Otherwise, we could find problems during \
removal after having lost track of the soldering-form character of sigma:\
\>", "Text",
 CellChangeTimes->{{3.423730718716756*^9, 3.423730937354722*^9}, {
  3.423762796637908*^9, 
  3.423762809912356*^9}},ExpressionUUID->"25c7722c-8a60-44af-a534-\
b430cc96c3ed"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Tensors and spinors", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"3f9d1494-fe6d-4ef4-8101-c1ef0e88c7d5"],

Cell[CellGroupData[{

Cell["3.0. Comments", "Subsubsection",
 CellChangeTimes->{{3.425991772067698*^9, 
  3.425991774850971*^9}},ExpressionUUID->"c1898041-c8c3-4db5-a56e-\
5f12da8f66a6"],

Cell["\<\
A spinor is actually a tensor with indices on the inner vbundle. Hence, it \
can be defined/undefined using DefTensor/UndefTensor. However, for aesthetic \
reasons, we include these two heads:\
\>", "Text",
 CellChangeTimes->{{3.425991784128746*^9, 3.4259918408794622`*^9}, {
  3.425991871265915*^9, 3.425991873918715*^9}, {3.610078123330405*^9, 
  3.610078129258463*^9}},ExpressionUUID->"7b99c71c-ff62-4878-ae22-\
49728e93d849"],

Cell["\<\
Some built-in options for PrintDaggerAs. Code supplied by Thomas B\
\[ADoubleDot]ckdahl.
Jose: I think these two are the functions Overline[...] and TildeString[...] \
of xCore`, acting on the PrintAs forms of Dagger[T]. Beware that this T is \
already a daggered object, so the Dagger@ here is needed to recover the \
original undaggered object.\
\>", "Text",ExpressionUUID->"40faf408-5ffb-45c9-9eeb-1cde264f1c72"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AddBar", "[", 
    RowBox[{"T_", "?", "xTensorQ"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\!\\(\>\"", ",", "\"\<\\*OverscriptBox[\\(\>\"", ",", 
     RowBox[{"PrintAs", "@", 
      RowBox[{"Evaluate", "@", 
       RowBox[{"Dagger", "[", "T", "]"}]}]}], ",", "\"\<\\),\\(_\\)]\>\"", 
     ",", "\"\<\\)\>\""}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AddTilde", "[", 
    RowBox[{"T_", "?", "xTensorQ"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\!\\(\>\"", ",", "\"\<\\*OverscriptBox[\\(\>\"", ",", 
     RowBox[{"PrintAs", "@", 
      RowBox[{"Evaluate", "@", 
       RowBox[{"Dagger", "@", "T"}]}]}], ",", "\"\<\\),\\(~\\)]\>\"", 
     ",", "\"\<\\)\>\""}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AddDagger", "[", 
    RowBox[{"T_", "?", "xTensorQ"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"PrintAs", "@", 
      RowBox[{"Evaluate", "@", 
       RowBox[{"Dagger", "@", "T"}]}]}], ",", "$DaggerCharacter"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.612061423989097*^9, 3.612061423994802*^9}, {
  3.612062254062397*^9, 3.612062257099844*^9}, {3.612062928458147*^9, 
  3.612062943977069*^9}, {3.612063073988072*^9, 3.6120630947966003`*^9}, {
  3.6120633868891087`*^9, 3.612063396009863*^9}, {3.612063695227092*^9, 
  3.612063695688628*^9}},ExpressionUUID->"02ae27b3-e9d6-4fd1-bf93-\
e91b3b67de23"],

Cell["\<\
Thomas B\[ADoubleDot]ckdahl code to include printing options for dagger \
spinors.\
\>", "Text",
 CellChangeTimes->{{3.607363025317233*^9, 3.607363048828104*^9}, {
  3.612062700224327*^9, 
  3.612062704471878*^9}},ExpressionUUID->"eed94ed7-ecb1-4d05-9379-\
cf4e862b9b54"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefSpinor", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"PrintDaggerAs", "\[Rule]", "AddDagger"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DefSpinor", "[", 
     RowBox[{
      RowBox[{"spinor_", "[", "inds___", "]"}], ",", "deps_", ",", 
      RowBox[{"options", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"{", 
         RowBox[{"DefSpinor", ",", "DefTensor"}], "}"}], "]"}]}]}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DefTensor", "[", 
       RowBox[{
        RowBox[{"spinor", "[", "inds", "]"}], ",", "deps", ",", 
        RowBox[{"FilterRules", "[", 
         RowBox[{
          RowBox[{"{", "options", "}"}], ",", 
          RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
        RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
        RowBox[{"DefInfo", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<spinor\>\"", ",", "\"\<\>\""}], "}"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Dagger", "@", "spinor"}], "=!=", "spinor"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"xAct`xTensor`Private`SetPrintAs", "[", 
         RowBox[{
          RowBox[{"Dagger", "@", "spinor"}], ",", 
          RowBox[{"xAct`xTensor`Private`PrintAsString", "[", 
           RowBox[{
            RowBox[{"Dagger", "@", "spinor"}], ",", 
            RowBox[{"OptionValue", "[", "PrintDaggerAs", "]"}]}], "]"}]}], 
         "]"}]}], "\[IndentingNewLine]", "]"}], ";"}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefSpinor", "[", 
    RowBox[{
     RowBox[{"spinor_", "[", "inds___", "]"}], ",", "deps_", ",", "sym_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"{", 
        RowBox[{"DefSpinor", ",", "DefTensor"}], "}"}], "]"}]}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"DefTensor", "[", 
      RowBox[{
       RowBox[{"spinor", "[", "inds", "]"}], ",", "deps", ",", "sym", ",", 
       RowBox[{"FilterRules", "[", 
        RowBox[{
         RowBox[{"{", "options", "}"}], ",", 
         RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
       RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
       RowBox[{"DefInfo", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<spinor\>\"", ",", "\"\<\>\""}], "}"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Dagger", "@", "spinor"}], "=!=", "spinor"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"xAct`xTensor`Private`SetPrintAs", "[", 
        RowBox[{
         RowBox[{"Dagger", "@", "spinor"}], ",", 
         RowBox[{"xAct`xTensor`Private`PrintAsString", "[", 
          RowBox[{
           RowBox[{"Dagger", "@", "spinor"}], ",", 
           RowBox[{"OptionValue", "[", "PrintDaggerAs", "]"}]}], "]"}]}], 
        "]"}]}], "\[IndentingNewLine]", "]"}], ";"}], ")"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"UndefSpinor", "=", "UndefTensor"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefSpinor", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"DefSpinor", ",", "UndefSpinor"}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d90dd1f1-258d-4c83-9ab5-1d9a8ceedba3"],

Cell["\<\
There is no function SpinorQ, though it might be introduced, probably \
performing additional checks to xTensorQ.\
\>", "Text",
 CellChangeTimes->{{3.426002368341506*^9, 
  3.426002394145482*^9}},ExpressionUUID->"9ffbb2c3-c24b-46a3-85c4-\
73a2ed7f5636"],

Cell["\<\
Any tensor (real or complex) has an associated spinor (Hermitian or complex, \
respectively). However, not any spinor has an associated tensor. Only those \
spinors with equal number of indices in VB and Dagger[VB] can have an \
associated tensor. We shall follow the convention that the indices in a \
spinor are paired in the following way: the first index of VB is paired with \
the first index of Dagger[VB], the second with the second, etc. Indeed, we \
have a more restrictive convention [ A, A\[Dagger], B, B\[Dagger], ... ] \
\>", "Text",
 CellChangeTimes->{{3.425991925857099*^9, 3.4259920790353317`*^9}, {
  3.427196463773427*^9, 3.427196501992991*^9}, {3.494137934753875*^9, 
  3.4941379391166573`*^9}},ExpressionUUID->"211036d1-0615-4fbb-904b-\
94c426e0c2d3"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1. Spinor / tensor equivalents", "Subsubsection",
 CellChangeTimes->{{3.42330611693041*^9, 3.4233061233918543`*^9}, {
  3.423371321985386*^9, 
  3.4233713287428503`*^9}},ExpressionUUID->"65f65418-c275-4d4a-b556-\
06373e7af3d6"],

Cell["\<\
Given a tensor (spinor) we want to construct its spinor (tensor) equivalent \
with respect to a given soldering-form.  We need to deal with five different \
issues:
        - The name of the spinor: we link a prefix symbol and the tensor \
symbol. There is the possibility of having already the prefix at the \
beginning of the tensor symbol, meaning that the symbol itself comes from a \
spinor. Then we would remove the prefix. Anyway, the names will be related \
finally through TensorOfSpinor and SpinorOfTensor, and this can be changed by \
the user and he/she likes.
        - The output of the spinor: we use the spinor mark
        - The symmetry of the spinor: This is a difficult point. Currently we \
trust everything is consistent and do not perform checks.
        - The relations among the slots of the tensor and the spinor. We \
follow the convention above of having corresponding sequences of indices in \
TM, VB and Dagger[VB].
        - Due to the see-saw rule, it is not enough to say that the spinor of \
T[a] is \[Xi][A,A\[Dagger]] porque \[Xi][A,A\[Dagger]]\[Sigma][a,-A,-A\
\[Dagger]] has a changed sign with respect to \
\[Xi][A,-A\[Dagger]]\[Sigma][a,-A,A\[Dagger]], and so it is not obvious which \
one must be declared to be T[a]. We will solve this by establishing that the \
configuration in SlotsOfTensor[\[Xi]] is priviledged and has no sign in the \
conversion to a tensor.\
\>", "Text",ExpressionUUID->"4a64c48c-3f3b-47e7-b3dd-b30937d8b667"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReplaceFrees", "[", 
    RowBox[{"expr_", ",", "inds_IndexList"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"all", "=", 
       RowBox[{
       "xAct`xTensor`Private`FindFreeAndDummyIndices", "[", "expr", "]"}]}], 
      "}"}], ",", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"frees", "=", 
          RowBox[{"First", "@", "all"}]}], ",", 
         RowBox[{"dummies", "=", 
          RowBox[{"Last", "@", "all"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ReplaceIndex", "[", 
        RowBox[{"expr", ",", 
         RowBox[{"Inner", "[", 
          RowBox[{"Rule", ",", "frees", ",", 
           RowBox[{
            RowBox[{"DeleteCases", "[", 
             RowBox[{"inds", ",", 
              RowBox[{"Alternatives", "@@", "dummies"}]}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"Range", "@", 
              RowBox[{"Length", "@", "frees"}]}], "]"}], "]"}], ",", "List"}],
           "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"e3912d53-6ce3-4800-8651-3ece8d61623f"],

Cell[TextData[{
 StyleBox["1) Names of the spinors\n\n",
  FontWeight->"Bold"],
 "These two linking functions are defined in ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellChangeTimes->{{3.419164950359055*^9, 3.419164973593367*^9}, {
  3.423305488254286*^9, 
  3.42330551844135*^9}},ExpressionUUID->"98ea55a9-8401-4a28-8476-\
eb2e601ad12b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "LinkSymbols"}]], \
"Input",ExpressionUUID->"e00e397c-91c8-4ffb-a1ad-aa4c1919e3dc"],

Cell[BoxData[
 StyleBox["\<\"LinkSymbols[{s1, s2, ...}] returns a single symbol formed by \
joining the symbols s1, s2, ... inserting the charcter $LinkCharacter in \
between any two of them.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3588025981-1170166",ExpressionUUID->"fd24bafc-6cba-48a3-9bfb-\
4aa7bbe8a0e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "UnlinkSymbol"}]], \
"Input",ExpressionUUID->"838e2ebe-18c4-4f50-a087-13542ea87581"],

Cell[BoxData[
 StyleBox["\<\"UnlinkSymbol[symbol] returns a list of symbols obtained by \
breaking the given symbol at those points having the character \
$LinkCharacter.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3588025982-1170166",ExpressionUUID->"fe4221c5-6580-4ef2-852b-\
addb1fa88438"]
}, Open  ]],

Cell["\<\
The function AddSpinorPrefix is rather general, including the possibility of \
removing the prefix as well. This must be a private function; the user driver \
is the pair TensorOfSpinor and SpinorOfTensor.\
\>", "Text",
 CellChangeTimes->{{3.419164993196484*^9, 3.4191649955599213`*^9}, {
   3.419165076391719*^9, 3.41916508827524*^9}, {3.423242670225945*^9, 
   3.423242674208445*^9}, {3.42330586266121*^9, 3.423305895096093*^9}, {
   3.423336984556863*^9, 3.42333699065905*^9}, {3.423370932351656*^9, 
   3.4233709788993464`*^9}, {3.423571512085705*^9, 3.423571514159586*^9}, 
   3.4235717761119337`*^9, {3.423571963371244*^9, 3.423571966035746*^9}, {
   3.425992319655156*^9, 
   3.425992323658038*^9}},ExpressionUUID->"20efeaae-9036-46ac-8b78-\
f6e02c521059"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AddSpinorPrefix", "[", 
    RowBox[{"object_Symbol", ",", "prefix_Symbol"}], "]"}], ":=", 
   RowBox[{"ASP", "[", 
    RowBox[{
     RowBox[{"UnlinkSymbol", "[", "object", "]"}], ",", "prefix"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ASP", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"prefix_", ",", "other__"}], "}"}], ",", "prefix_"}], "]"}], ":=", 
   RowBox[{"LinkSymbols", "[", 
    RowBox[{"{", "other", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ASP", "[", 
    RowBox[{
     RowBox[{"{", "other__", "}"}], ",", "prefix_"}], "]"}], ":=", 
   RowBox[{"LinkSymbols", "[", 
    RowBox[{"{", 
     RowBox[{"prefix", ",", "other"}], "}"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4233055993031073`*^9, 3.423305600163191*^9}, 
   3.423305804895537*^9, 3.4233058561950502`*^9, {3.423386902209351*^9, 
   3.423386907754758*^9}, {3.423549212932022*^9, 3.4235492475627213`*^9}, {
   3.4235493521707478`*^9, 3.4235493597908*^9}, {3.423571479344912*^9, 
   3.4235715049598618`*^9}, 3.423571776925806*^9, {3.423571927028857*^9, 
   3.423571933993088*^9}, {3.4235728559282923`*^9, 
   3.42357285985915*^9}},ExpressionUUID->"41301f21-75d6-412b-ac46-\
4e03b018b878"],

Cell["\<\
The functions SpinorOfTensor and TensorOfSpinor will be used through \
upvalues, but return a default name, together with a message. These two \
functions can be used to prepare in advance any alternative way of naming the \
spinor and tensor equivalents:\
\>", "Text",
 CellChangeTimes->{{3.423336253485076*^9, 3.423336317247855*^9}, {
  3.423370814818572*^9, 3.423370889512885*^9}, {3.423371045742507*^9, 
  3.423371080062829*^9}, {3.425987288762982*^9, 
  3.425987293540234*^9}},ExpressionUUID->"a85a6765-942c-48d3-a790-\
b8aa2278eff4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SpinorOfTensor", "::", "name"}], 
   "=", "\"\<Spinor of `1` not defined. Prepending `2`.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorOfSpinor", "::", "name"}], 
   "=", "\"\<Tensor of `1` not defined. Prepending `2`.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinorOfTensor", "[", 
    RowBox[{"tensor_", ",", "sigma_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"prefix", "=", 
       RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"SpinorOfTensor", "::", "name"}], ",", "tensor", ",", 
        "prefix"}], "]"}], ";", 
      RowBox[{"AddSpinorPrefix", "[", 
       RowBox[{"tensor", ",", "prefix"}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TensorOfSpinor", "[", 
     RowBox[{"spinor_", ",", "sigma_"}], "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"prefix", "=", 
        RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"TensorOfSpinor", "::", "name"}], ",", "spinor", ",", 
         "prefix"}], "]"}], ";", 
       RowBox[{"AddSpinorPrefix", "[", 
        RowBox[{"spinor", ",", "prefix"}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Default", " ", "choice", " ", "of", " ", "spinor", " ", "prefix"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinorPrefix", "[", "sigma_", "]"}], ":=", "sigma"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"SpinorPrefix", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"SpinorOfTensor", ",", "2"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"TensorOfSpinor", ",", "2"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"SpinorPrefix", ",", "SpinorOfTensor", ",", "TensorOfSpinor"}], 
   "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.423328426751114*^9, 3.423328490297683*^9}, {
  3.423335928067544*^9, 3.423335943236642*^9}, {3.4233706732711573`*^9, 
  3.423370804753686*^9}, {3.423545656096394*^9, 3.423545658340083*^9}, {
  3.423546075140649*^9, 3.423546085437298*^9}, {3.4235463501833887`*^9, 
  3.4235463724124537`*^9}, {3.423549373303403*^9, 3.423549388986594*^9}, {
  3.423551277064131*^9, 3.423551282533495*^9}, {3.4235715388046913`*^9, 
  3.423571555696744*^9}, {3.423571778040811*^9, 3.423571897412169*^9}, {
  3.423571935477027*^9, 3.423571940421084*^9}, {3.423572117711344*^9, 
  3.423572120282968*^9}, {3.423572163682304*^9, 3.4235722347901793`*^9}, {
  3.4259924608322573`*^9, 
  3.425992469254755*^9}},ExpressionUUID->"5b4d4336-7fe3-461e-83ff-\
9d0f1e2dc9ec"],

Cell[TextData[{
 StyleBox["2) Formatting",
  FontWeight->"Bold"],
 "\n\nThen we need to worry about output formatting. The private function \
AddSpinorMark adds a mark to a string, returning another string . Two \
possibilities:"
}], "Text",
 CellChangeTimes->{{3.419165054910816*^9, 3.419165057997072*^9}, {
   3.419165090859541*^9, 3.419165105496141*^9}, {3.423242811452335*^9, 
   3.42324282749203*^9}, {3.423242898699102*^9, 3.423242907559816*^9}, {
   3.423305912629179*^9, 3.4233059178475847`*^9}, 3.423572280889123*^9, {
   3.423573346869961*^9, 3.423573347367399*^9}, {3.425992497050788*^9, 
   3.425992497944983*^9}},ExpressionUUID->"cddca446-0f4d-4aad-83b5-\
e5b5f8e5c646"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AddSpinorMark", "[", 
    RowBox[{"character_String", ",", "mark_String"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"mark", ",", "character"}], "]"}]}], ";"}], "\[IndentingNewLine]",
 
 RowBox[{
  RowBox[{
   RowBox[{"AddSpinorMark", "[", 
    RowBox[{"character_String", ",", "function_"}], "]"}], ":=", 
   RowBox[{"function", "[", "character", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4082839760821323`*^9, 3.408284092989113*^9}, {
  3.4082847724118958`*^9, 3.408284843636899*^9}, {3.423242880225916*^9, 
  3.4232429160949593`*^9}, {3.423572281957798*^9, 3.423572337580742*^9}, {
  3.423572773631013*^9, 3.423572798072747*^9}, {3.423572877292184*^9, 
  3.423572958182064*^9}, {3.423573235276422*^9, 3.423573262499934*^9}, {
  3.423573335053008*^9, 
  3.4235733364264297`*^9}},ExpressionUUID->"5428b14f-9d6e-480e-81ef-\
6dffd5d1b6ef"],

Cell["Examples :", "Text",
 CellChangeTimes->{{3.423242939562519*^9, 
  3.4232429415122557`*^9}},ExpressionUUID->"e337ca7f-df70-491c-9659-\
380d716ca3b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddSpinorMark", "[", 
  RowBox[{"\"\<\[EmptyDownTriangle]\>\"", ",", 
   RowBox[{"ColorString", "[", 
    RowBox[{"\"\<S\>\"", ",", "Red"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.408284136547697*^9, 3.4082841692754173`*^9}, {
   3.408285291680664*^9, 3.408285292832465*^9}, 3.423572286236475*^9, {
   3.423572378401813*^9, 3.4235723815487127`*^9}, {3.423572994851363*^9, 
   3.4235729965959682`*^9}, {3.423658328812326*^9, 
   3.423658332524531*^9}},ExpressionUUID->"4d4cd60e-3bed-4eff-bff6-\
b171cf9dcaff"],

Cell[BoxData["\<\"\\!\\(\\*StyleBox[\\\"S\\\",FontColor->RGBColor[1., 0., \
0.]]\\)\[EmptyDownTriangle]\"\>"], \
"Output",ExpressionUUID->"9509c2c9-4987-4f99-89b7-7cd3e2fce303"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddSpinorMark", "[", 
  RowBox[{"\"\<\[EmptyDownTriangle]\>\"", ",", "OverTilde"}], "]"}]], "Input",
 
 CellChangeTimes->{{3.408284191450637*^9, 3.4082842617692633`*^9}, {
   3.408285295966557*^9, 3.408285296734022*^9}, 3.42357228670016*^9, {
   3.423572388548671*^9, 3.423572389939444*^9}, {3.423572999313979*^9, 
   3.423573001481551*^9}, {3.423658334850677*^9, 
   3.423658337621174*^9}},ExpressionUUID->"87879873-5576-4372-9420-\
2778fca49246"],

Cell[BoxData[
 OverscriptBox["\<\"\[EmptyDownTriangle]\"\>", 
  "~"]], "Output",ExpressionUUID->"a9913bf0-a95f-40b1-a12b-4adcae3b9ddd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddSpinorMark", "[", 
  RowBox[{"\"\<R\>\"", ",", 
   RowBox[{"Function", "[", 
    RowBox[{"TildeString", "[", 
     RowBox[{"#", ",", "1", ",", "Blue"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.408284280728155*^9, 3.408284321531693*^9}, {
   3.408285299929562*^9, 3.408285302986783*^9}, 3.4235722873166323`*^9, {
   3.423572393233075*^9, 3.423572394920248*^9}, {3.423573004037325*^9, 
   3.4235730066577177`*^9}, {3.4236583394177027`*^9, 
   3.423658343856991*^9}},ExpressionUUID->"bacebe7c-698e-411a-97fe-\
560f7dcc3fa2"],

Cell[BoxData["\<\"\\!\\(R\\&\\*StyleBox[\\\"~\\\",FontColor->RGBColor[0, 0, \
1]]\\)\"\>"], \
"Output",ExpressionUUID->"73cb7989-e963-491d-aaf4-0ca828b49d52"]
}, Open  ]],

Cell[TextData[{
 StyleBox["3) Relations among indices",
  FontWeight->"Bold"],
 "\n\nWe need to check that the indices of the spinor and the tensor are \
consistent, and we need to find out their mutual relations. The output of \
indRules is a list of rules of the form nt->nv indicating that slot nt of the \
tensor corresponds to slot nv of the spinor, or rules of the form \
nt->{nv,nv+1} indicating that slot nt of tensor corresponds to a pair of \
slots in the spinor. The function proceeds analyzing index by index:"
}], "Text",
 CellChangeTimes->{{3.423306818098567*^9, 3.4233068309089527`*^9}, {
   3.423309293427652*^9, 3.423309296402162*^9}, {3.423310885651824*^9, 
   3.423311025923562*^9}, 3.423386873061817*^9, {3.425992586277667*^9, 
   3.425992602379446*^9}, {3.42599780171343*^9, 
   3.425997801960958*^9}},ExpressionUUID->"f9563b46-c045-4657-8d1c-\
1ee18db06a8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Same", " ", 
    RowBox[{"index", ":", " ", 
     RowBox[{"shift", " ", "slots"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"indRules", "[", 
      RowBox[{"f_", ",", 
       RowBox[{"{", 
        RowBox[{"vbundle_", ",", "nv_", ",", 
         RowBox[{"IndexList", "[", 
          RowBox[{"A_", ",", "spinds___"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tbundle_", ",", "nt_", ",", 
         RowBox[{"IndexList", "[", 
          RowBox[{"A_", ",", "inds___"}], "]"}]}], "}"}], ",", "rules_List"}],
       "]"}], ":=", 
     RowBox[{"indRules", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"vbundle", ",", 
         RowBox[{"nv", "+", "1"}], ",", 
         RowBox[{"IndexList", "[", "spinds", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tbundle", ",", 
         RowBox[{"nt", "+", "1"}], ",", 
         RowBox[{"IndexList", "[", "inds", "]"}]}], "}"}], ",", 
       RowBox[{"Append", "[", 
        RowBox[{"rules", ",", 
         RowBox[{"nt", "\[Rule]", "nv"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "tbundle", " ", "index", " ", "corresponds", " ", "to", " ", "a", " ", 
     "pair", " ", "of", " ", 
     RowBox[{"vbundle", "/", "vbundledag"}], " ", "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"indRules", "[", 
      RowBox[{"f_", ",", 
       RowBox[{"{", 
        RowBox[{"vbundle_", ",", "nv_", ",", 
         RowBox[{"IndexList", "[", 
          RowBox[{"A_", ",", "Bd_", ",", "spinds___"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tbundle_", ",", "nt_", ",", 
         RowBox[{"IndexList", "[", 
          RowBox[{"a_", ",", "inds___"}], "]"}]}], "}"}], ",", "rules_List"}],
       "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"indRules", "[", 
       RowBox[{"f", ",", 
        RowBox[{"{", 
         RowBox[{"vbundle", ",", 
          RowBox[{"nv", "+", "2"}], ",", 
          RowBox[{"IndexList", "[", "spinds", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"tbundle", ",", 
          RowBox[{"nt", "+", "1"}], ",", 
          RowBox[{"IndexList", "[", "inds", "]"}]}], "}"}], ",", 
        RowBox[{"Append", "[", 
         RowBox[{"rules", ",", 
          RowBox[{"nt", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"nv", ",", 
             RowBox[{"nv", "+", "1"}]}], "}"}]}]}], "]"}]}], "]"}], "/;", 
      RowBox[{
       RowBox[{"AIndexQ", "[", 
        RowBox[{"A", ",", "vbundle"}], "]"}], "&&", 
       RowBox[{"AIndexQ", "[", 
        RowBox[{"Bd", ",", 
         RowBox[{"Dagger", "[", "vbundle", "]"}]}], "]"}], "&&", 
       RowBox[{"AIndexQ", "[", 
        RowBox[{"a", ",", "tbundle"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Exit", " ", "point"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"indRules", "[", 
      RowBox[{"f_", ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", 
         RowBox[{"IndexList", "[", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", 
         RowBox[{"IndexList", "[", "]"}]}], "}"}], ",", "rules_List"}], "]"}],
      ":=", "rules"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Other", " ", 
     RowBox[{"case", ":", " ", "error"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "incomp"}], 
     "=", "\"\<Indices `1` and `2` are incompatible.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"indRules", "[", 
      RowBox[{"DefSpinorOfTensor", ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", "spinds_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", "inds_"}], "}"}], ",", "_"}], "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"DefSpinorOfTensor", "::", "incomp"}], ",", "spinds", ",", 
        "inds"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"indRules", "[", 
      RowBox[{"DefTensorOfSpinor", ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", "spinds_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", "inds_"}], "}"}], ",", "_"}], "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"DefTensorOfSpinor", "::", "incomp"}], ",", "inds", ",", 
        "spinds"}], "]"}]}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.423307689229165*^9, 3.42330772717282*^9}, {
  3.423307803865816*^9, 3.423307882464099*^9}, {3.423307989139187*^9, 
  3.42330801829605*^9}, {3.4233080825872793`*^9, 3.423308190014902*^9}, {
  3.4233086120923557`*^9, 3.423308719083674*^9}, {3.4233087512045307`*^9, 
  3.423308757073132*^9}, {3.423308792215335*^9, 3.423308924589219*^9}, {
  3.423308964611752*^9, 3.4233089762855167`*^9}, {3.423309034137261*^9, 
  3.423309266724348*^9}, {3.423309398079074*^9, 3.423309408022223*^9}, {
  3.4233870683315773`*^9, 3.423387112529607*^9}, {3.4253044189340677`*^9, 
  3.425304476631319*^9}, {3.42599278437488*^9, 3.425992789431621*^9}, {
  3.425997046313244*^9, 3.425997048238079*^9}, {3.42599742330149*^9, 
  3.425997434253686*^9}, {3.425997465827531*^9, 3.425997481292469*^9}, {
  3.425997648307476*^9, 3.425997696107045*^9}, {3.425997974019821*^9, 
  3.425997976676669*^9}},ExpressionUUID->"56be87d2-28b5-4738-b280-\
7eaacf49c4d5"],

Cell["\<\
QUESTION : Is there any overlapping between this function and TransposeDagger?\
\>", "Text",ExpressionUUID->"92ad8f24-f37f-46ce-a356-5b4f75f67270"],

Cell[TextData[{
 StyleBox["4) Symmetry",
  FontWeight->"Bold"],
 "\n\nGiven the symmetry of the tensor we construct the symmetry of its \
spinorial equivalent. We assume that the slots in the spinor are in \
correspondence with those in the tensor, as specified by the list of rules. \
Note that we are using the full form of SymmetryGroupOfTensor, feeding the \
indices, but probably these commands can be used for a tensor with a variable \
number of indices, because the spinorial equivalent will not inherit that \
property."
}], "Text",
 CellChangeTimes->{{3.423306137874654*^9, 3.423306228823373*^9}, {
   3.423371143016719*^9, 3.423371175845302*^9}, 3.4233713997039433`*^9, {
   3.4233715927254267`*^9, 3.42337165563457*^9}, 3.423386879292342*^9, {
   3.426001085820684*^9, 
   3.426001087545182*^9}},ExpressionUUID->"28a3ea58-8983-43e9-892b-\
6efc4fce44a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "assumes", " ", "a", " ", "GenSet", " ", "in", " ", "cyclic", 
    " ", "form"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SpinorSymmetry", "[", 
      RowBox[{
       RowBox[{"tensor_", "[", "inds___", "]"}], ",", "rules_List"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"SymmetryGroupOfTensor", "[", 
       RowBox[{"tensor", "[", "inds", "]"}], "]"}], "/.", 
      RowBox[{
       RowBox[{"StrongGenSet", "[", 
        RowBox[{"base_", ",", "genset_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"StrongGenSet", "[", 
        RowBox[{
         RowBox[{"first", "/@", 
          RowBox[{"(", 
           RowBox[{"base", "/.", "rules"}], ")"}]}], ",", 
         RowBox[{"genset", "/.", 
          RowBox[{"perm_Cycles", "\[RuleDelayed]", 
           RowBox[{
            RowBox[{"spinorCycles", "[", "rules", "]"}], "/@", "perm"}]}]}]}],
         "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"first", "[", "i_Integer", "]"}], ":=", "i"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"first", "[", "list_List", "]"}], ":=", 
     RowBox[{"First", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"spinorCycles", "[", "rules_List", "]"}], "[", "cycle_List", 
      "]"}], ":=", 
     RowBox[{"spinorCyclesTranspose", "[", 
      RowBox[{"cycle", "/.", "rules"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"spinorCyclesTranspose", "[", 
      RowBox[{"cycle", ":", 
       RowBox[{"{", "__Integer", "}"}]}], "]"}], ":=", "cycle"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"spinorCyclesTranspose", "[", 
      RowBox[{"cycle", ":", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"_", ",", "_"}], "}"}], ".."}], "}"}]}], "]"}], ":=", 
     RowBox[{"Sequence", "@@", 
      RowBox[{"Transpose", "[", "cycle", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"spinorCyclesTranspose", "[", "cycle_", "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"DefSpinorOfTensor", "::", "error"}], 
        ",", "\"\<Symmetry of tensor incompatible with indices.\>\""}], 
       "]"}]}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.423306164932496*^9, 3.423306168221146*^9}, 
   3.423306231797175*^9, {3.423306474029387*^9, 3.423306504056765*^9}, {
   3.423306595601535*^9, 3.423306662564665*^9}, {3.4233067225037527`*^9, 
   3.423306794274021*^9}, {3.423311138327167*^9, 3.42331130936364*^9}, {
   3.423330217242671*^9, 3.423330316061079*^9}, {3.423330347076902*^9, 
   3.42333038705711*^9}, {3.4233712533498898`*^9, 
   3.423371282063211*^9}},ExpressionUUID->"d38c61a2-efdc-4fa1-940a-\
7257e3987c46"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "assumes", " ", "a", " ", "GenSet", " ", "in", " ", "cyclic", 
    " ", "form"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SymmetryOfTensor", "[", 
      RowBox[{
       RowBox[{"spinor_", "[", "spinds___", "]"}], ",", "rules_List"}], "]"}],
      ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"firstrules", "=", 
         RowBox[{"Map", "[", 
          RowBox[{"first", ",", "rules", ",", 
           RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SymmetryGroupOfTensor", "[", 
         RowBox[{"spinor", "[", "spinds", "]"}], "]"}], "/.", 
        RowBox[{
         RowBox[{"StrongGenSet", "[", 
          RowBox[{"base_", ",", "genset_"}], "]"}], "\[RuleDelayed]", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Cases", "[", 
             RowBox[{"base", ",", 
              RowBox[{"Alternatives", "@@", 
               RowBox[{"(", 
                RowBox[{"First", "/@", "firstrules"}], ")"}]}]}], "]"}], "/.",
             "firstrules"}], ",", 
           RowBox[{"genset", "/.", 
            RowBox[{"perm_Cycles", "\[RuleDelayed]", 
             RowBox[{
              RowBox[{"tensorCycles", "[", "firstrules", "]"}], "/@", 
              "perm"}]}]}]}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"tensorCycles", "[", "firstrules_List", "]"}], "[", 
      "cycle_List", "]"}], ":=", 
     RowBox[{"Which", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Complement", "[", 
         RowBox[{"cycle", ",", 
          RowBox[{"First", "/@", "firstrules"}]}], "]"}], "===", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"cycle", "/.", "firstrules"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Intersection", "[", 
         RowBox[{"cycle", ",", 
          RowBox[{"First", "/@", "firstrules"}]}], "]"}], "===", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "True", ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"DefTensorOfSpinor", "::", "error"}], 
          ",", "\"\<Symmetry of spinor cannot be reduced to tensor.\>\""}], 
         "]"}]}]}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6bd7ae26-0514-41cc-8b09-858081ec4d36"],

Cell[TextData[{
 StyleBox["5) DefSpinorOfTensor and DefTensorOfSpinor",
  FontWeight->"Bold"],
 "\n\nThis is the function which defines the spinorial equivalent of a tensor:"
}], "Text",
 CellChangeTimes->{{3.423309425716131*^9, 3.423309438478697*^9}, {
  3.4233279108231173`*^9, 3.4233279262144938`*^9}, {3.423387919630169*^9, 
  3.423387925411014*^9}},ExpressionUUID->"279b08c0-676e-4676-92af-\
78a61ea04bb7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefSpinorOfTensor", "[", 
    RowBox[{
     RowBox[{"spinor_Symbol", "[", "spinds___", "]"}], ",", 
     RowBox[{"tensor_Symbol", "[", "inds___", "]"}], ",", "sigma_Symbol", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"vbundle", ",", "tbundle", ",", "rules", ",", "sym"}], "}"}], ",",
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Check", " ", "tensor"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"xTensorQ", "[", "tensor", "]"}]}], ",", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"DefSpinorOfTensor", "::", "unknown"}], 
            ",", "\"\<tensor\>\"", ",", "tensor"}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "VBundles", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"vbundle", "=", 
        RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"tbundle", "=", 
        RowBox[{"TangentBundleOfSolderingForm", "[", "sigma", "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Check", " ", "index", " ", "compatibility", " ", "and", " ", 
         "construct", " ", "rules"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"rules", "=", 
        RowBox[{"indRules", "[", 
         RowBox[{"DefSpinorOfTensor", ",", 
          RowBox[{"{", 
           RowBox[{"vbundle", ",", "1", ",", 
            RowBox[{"IndexList", "[", "spinds", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"tbundle", ",", "1", ",", 
            RowBox[{"IndexList", "[", "inds", "]"}]}], "}"}], ",", 
          RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"sym", "=", 
        RowBox[{"SpinorSymmetry", "[", 
         RowBox[{
          RowBox[{"tensor", "[", "inds", "]"}], ",", "rules"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Define", " ", 
         RowBox[{"spinor", ".", " ", "Do"}], " ", "not", " ", "give", " ", 
         "master"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"DefTensor", "[", 
        RowBox[{
         RowBox[{"spinor", "[", "spinds", "]"}], ",", 
         RowBox[{"DependenciesOfTensor", "[", "tensor", "]"}], ",", "sym", ",", 
         RowBox[{"Dagger", "\[RuleDelayed]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"DaggerQ", "[", "tensor", "]"}], ",", "Complex", ",", 
            "Hermitian"}], "]"}]}], ",", 
         RowBox[{"Master", "\[Rule]", "Null"}], ",", 
         RowBox[{"FilterRules", "[", 
          RowBox[{
           RowBox[{"{", "options", "}"}], ",", 
           RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PrintAs", "\[RuleDelayed]", 
          RowBox[{"AddSpinorMark", "[", 
           RowBox[{
            RowBox[{"PrintAs", "[", "tensor", "]"}], ",", 
            RowBox[{"SpinorMark", "[", "sigma", "]"}]}], "]"}]}], ",", 
         RowBox[{"DefInfo", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<spinor\>\"", ",", 
            RowBox[{"\"\<Equivalent of tensor \>\"", "<>", 
             RowBox[{"ToString", "[", "tensor", "]"}]}], ",", 
            RowBox[{"\"\<Equivalent of tensor \>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"Dagger", "[", "tensor", "]"}], "]"}]}]}], "}"}]}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Register", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"RegisterSpinorOfTensor", "[", 
        RowBox[{"spinor", ",", "tensor", ",", "sigma"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"SetVisitorHost", "[", 
        RowBox[{"spinor", ",", "tensor", ",", "sigma"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"DaggerQ", "@", "tensor"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"RegisterSpinorOfTensor", "[", 
           RowBox[{
            RowBox[{"Dagger", "[", "spinor", "]"}], ",", 
            RowBox[{"Dagger", "[", "tensor", "]"}], ",", "sigma"}], "]"}], 
          ";"}]}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"SetVisitorHost", "[", 
          RowBox[{
           RowBox[{"Dagger", "[", "spinor", "]"}], ",", 
           RowBox[{"Dagger", "[", "tensor", "]"}], ",", "sigma"}], "]"}], 
         "*)"}], "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]",
      "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefSpinorOfTensor", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DefSpinorOfTensor", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"ca84fbeb-9784-43cc-b2e0-28b06355fd88"],

Cell["\<\
JMM : The Hosts/Visitors assignments on the complex conjugated tensor/spinor \
gives problems. Now deactivated.\
\>", "Text",
 CellChangeTimes->{{3.4260018960319223`*^9, 3.426001926874132*^9}, {
  3.4262746521021*^9, 
  3.4262746807003517`*^9}},ExpressionUUID->"96997eed-19b5-4c3d-8d4f-\
86cc8a4c9f53"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RegisterSpinorOfTensor", "[", 
    RowBox[{"spinor_", ",", "tensor_", ",", "sigma_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"xTagSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tensor", ",", 
         RowBox[{"SpinorOfTensor", "[", 
          RowBox[{"tensor", ",", "sigma"}], "]"}]}], "}"}], ",", "spinor"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"xTagSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"spinor", ",", 
         RowBox[{"TensorOfSpinor", "[", 
          RowBox[{"spinor", ",", "sigma"}], "]"}]}], "}"}], ",", "tensor"}], 
      "]"}], ";"}], "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetVisitorHost", "[", 
    RowBox[{"visitor_", ",", "host_", ",", "sigma_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"xUpAppendTo", "[", 
      RowBox[{
       RowBox[{"HostsOf", "[", "visitor", "]"}], ",", "sigma"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"xUpAppendTo", "[", 
      RowBox[{
       RowBox[{"HostsOf", "[", "visitor", "]"}], ",", "host"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"xUpAppendTo", "[", 
      RowBox[{
       RowBox[{"VisitorsOf", "[", "sigma", "]"}], ",", "visitor"}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"xUpAppendTo", "[", 
      RowBox[{
       RowBox[{"VisitorsOf", "[", "host", "]"}], ",", "visitor"}], "]"}], 
     ";"}], "\[IndentingNewLine]", ")"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.426001609418418*^9, 3.426001643847027*^9}, {
  3.426001776157341*^9, 3.426001811978572*^9}, {3.4260020045655622`*^9, 
  3.426002073706653*^9}, {3.426002115230235*^9, 3.4260021236186333`*^9}, {
  3.426002177457253*^9, 
  3.426002177951235*^9}},ExpressionUUID->"6508cc91-31fa-4c1b-a597-\
fb386b00d585"],

Cell["\<\
And this is the parallel structure to define a tensor from a spinor :\
\>", "Text",
 CellChangeTimes->{{3.42337309783854*^9, 
  3.423373122579029*^9}},ExpressionUUID->"3c8a262e-0435-4843-9d2d-\
0afb42119510"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefTensorOfSpinor", "[", 
    RowBox[{
     RowBox[{"tensor_Symbol", "[", "inds___", "]"}], ",", 
     RowBox[{"spinor_Symbol", "[", "spinds___", "]"}], ",", "sigma_Symbol", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"vbundle", ",", "tbundle", ",", "rules", ",", "sym"}], "}"}], ",",
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Check", " ", "spinor"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"xTensorQ", "[", "spinor", "]"}]}], ",", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"DefTensorOfSpinor", "::", "unknown"}], 
            ",", "\"\<spinor\>\"", ",", "spinor"}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "VBundles", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"vbundle", "=", 
        RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"tbundle", "=", 
        RowBox[{"TangentBundleOfSolderingForm", "[", "sigma", "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Check", " ", "index", " ", "compatibility", " ", "and", " ", 
         "construct", " ", "rules"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"rules", "=", 
        RowBox[{"Reverse", "/@", 
         RowBox[{"indRules", "[", 
          RowBox[{"DefTensorOfSpinor", ",", 
           RowBox[{"{", 
            RowBox[{"vbundle", ",", "1", ",", 
             RowBox[{"IndexList", "[", "spinds", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"tbundle", ",", "1", ",", 
             RowBox[{"IndexList", "[", "inds", "]"}]}], "}"}], ",", 
           RowBox[{"{", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"sym", "=", 
        RowBox[{"SymmetryOfTensor", "[", 
         RowBox[{
          RowBox[{"spinor", "[", "spinds", "]"}], ",", "rules"}], "]"}]}], ";",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Define", " ", 
         RowBox[{"tensor", ".", " ", "Do"}], " ", "not", " ", "give", " ", 
         "master"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"DefTensor", "[", 
        RowBox[{
         RowBox[{"tensor", "[", "inds", "]"}], ",", 
         RowBox[{"DependenciesOfTensor", "[", "spinor", "]"}], ",", "sym", ",", 
         RowBox[{"Dagger", "\[RuleDelayed]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"HermitianQ", "[", "spinor", "]"}], ",", "Real", ",", 
            "Complex"}], "]"}]}], ",", 
         RowBox[{"Master", "\[Rule]", "Null"}], ",", 
         RowBox[{"FilterRules", "[", 
          RowBox[{
           RowBox[{"{", "options", "}"}], ",", 
           RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PrintAs", "\[RuleDelayed]", 
          RowBox[{"AddSpinorMark", "[", 
           RowBox[{
            RowBox[{"PrintAs", "[", "spinor", "]"}], ",", 
            RowBox[{"SpinorMark", "[", "sigma", "]"}]}], "]"}]}], ",", 
         RowBox[{"DefInfo", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<tensor\>\"", ",", 
            RowBox[{"\"\<Equivalent of spinor \>\"", "<>", 
             RowBox[{"ToString", "[", "spinor", "]"}]}], ",", 
            RowBox[{"\"\<Equivalent of spinor \>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"Dagger", "[", "spinor", "]"}], "]"}]}]}], "}"}]}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Register", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"RegisterSpinorOfTensor", "[", 
        RowBox[{"spinor", ",", "tensor", ",", "sigma"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"SetVisitorHost", "[", 
        RowBox[{"tensor", ",", "spinor", ",", "sigma"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"DaggerQ", "[", "tensor", "]"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{
          RowBox[{
           RowBox[{"RegisterSpinorOfTensor", "[", 
            RowBox[{
             RowBox[{"Dagger", "[", "spinor", "]"}], ",", 
             RowBox[{"Dagger", "[", "tensor", "]"}], ",", "sigma"}], "]"}], 
           ";"}], "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"SetVisitorHost", "[", 
            RowBox[{
             RowBox[{"Dagger", "[", "spinor", "]"}], ",", 
             RowBox[{"Dagger", "[", "tensor", "]"}], ",", "sigma"}], "]"}], 
           "*)"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefTensorOfSpinor", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DefTensorOfSpinor", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"85d84ed9-6cd8-4d87-8d8a-6c942a9eba89"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. Pairs of complex indices", "Subsubsection",
 CellChangeTimes->{{3.4259402747143707`*^9, 3.425940294906259*^9}, {
  3.426523701892394*^9, 
  3.426523708576693*^9}},ExpressionUUID->"0cb469ed-abb3-4bc6-9f0a-\
164e9e6580f1"],

Cell["\<\
The functions ContractSolderingForm / SeparateSolderingForm /PutSolderingForm \
can manipulate pairs of indices, and not only indices. We need a function \
which can extract the default pairs from an expression, following some \
conventions: indices of a pair belong to the same tensor, or to the same spin \
covd. The user can, however, specify pairs of indices not following that rule.\
\>", "Text",
 CellChangeTimes->{{3.426605965327373*^9, 
  3.426606079312694*^9}},ExpressionUUID->"5b796722-c2b3-4ddd-90e9-\
401c69d9fe82"],

Cell["\<\
FindPairs returns a List of pairs (each a List of two indices). Note that \
there is nothing yet for Bracket. There is the danger of confusing a pair of \
indices with a BC-index. The function TransposeDaggerPairs contains the \
convention of pairing indices in order (first of V with first in V*, etc).
Note the final IndexList@@, in spite of having Join[IndexList[...], ...]. The \
problem is that Join[] gives {} and we need to convert it into IndexList[].\
\>", "Text",ExpressionUUID->"c364de63-2613-49c8-8e7f-3c0f8fd63bba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Return", " ", "an", " ", "IndexList", " ", "of", " ", "Pair", " ", 
    "pairs"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"FindPairs", "[", 
      RowBox[{"expr_", ",", "vbs_List"}], "]"}], ":=", 
     RowBox[{"IndexList", "@@", 
      RowBox[{"Apply", "[", 
       RowBox[{"Join", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"xAct`xTensor`Private`TransposeDaggerPairs", "[", 
           RowBox[{"#", ",", "vbs", ",", "False"}], "]"}], "&"}], "/@", 
         RowBox[{"Join", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"FindAllOfType", "[", 
            RowBox[{"expr", ",", "Tensor"}], "]"}], ",", 
           RowBox[{"Cases", "[", 
            RowBox[{
             RowBox[{"FindAllOfType", "[", 
              RowBox[{"expr", ",", "CovD"}], "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"_Symbol", "?", "SpinCovDQ"}], "[", 
                RowBox[{"a_", ",", "b_"}], "]"}], "[", "_", "]"}], "\[Rule]", 
              
              RowBox[{"IndexList", "[", 
               RowBox[{"a", ",", "b"}], "]"}]}]}], "]"}]}], 
          "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Separate", " ", "pairs", " ", "in", " ", "the", " ", "given", " ", 
     "indices", " ", "list"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindPairs", "[", 
      RowBox[{"expr_", ",", "vbs_List", ",", "indices_IndexList"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"pairs", "=", 
         RowBox[{"FindPairs", "[", 
          RowBox[{"expr", ",", "vbs"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"List", "@@", 
            RowBox[{"Complement", "[", 
             RowBox[{"indices", ",", 
              RowBox[{"Flatten", "[", 
               RowBox[{
                RowBox[{"Apply", "[", 
                 RowBox[{"IndexList", ",", "pairs", ",", "1"}], "]"}], ",", 
                "1"}], "]"}]}], "]"}]}], ",", 
           RowBox[{"Cases", "[", 
            RowBox[{"pairs", ",", 
             RowBox[{"pair_", "/;", 
              RowBox[{
               RowBox[{"Intersection", "[", 
                RowBox[{
                 RowBox[{"IndexList", "@@", "pair"}], ",", "indices"}], "]"}],
                "=!=", 
               RowBox[{"IndexList", "[", "]"}]}]}]}], "]"}]}], "}"}], ",", 
         "1"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"89d42840-a429-42c4-bee9-2c971950cac2"],

Cell["\<\
With three arguments we split the indices list into pairs and the rest.\
\>", "Text",
 CellChangeTimes->{{3.426531971170519*^9, 3.4265319859222727`*^9}, {
  3.426535450354321*^9, 3.4265354712110662`*^9}, {3.4266097713122377`*^9, 
  3.4266097717370043`*^9}},ExpressionUUID->"da295e3a-c208-4a55-b676-\
e4f35bfb459a"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. PutSolderingForm", "Subsubsection",
 CellChangeTimes->{{3.4088725984129343`*^9, 3.408872613854953*^9}, 
   3.419237877819063*^9, 3.425988701937647*^9, 
   3.4267852072850313`*^9},ExpressionUUID->"6fcabeb7-2d2e-4eb9-a77c-\
d29398bcb9ff"],

Cell["\<\
This command enables us to transform tensors into spinors by means of the \
contraction with the soldering form.\
\>", "Text",
 CellChangeTimes->{{3.4088829136482563`*^9, 3.408882969579817*^9}, {
   3.408883020974825*^9, 3.408883032950526*^9}, {3.409052839791203*^9, 
   3.409052868544484*^9}, {3.419231847240878*^9, 3.419231851111787*^9}, 
   3.419422785781206*^9},ExpressionUUID->"89d91539-aef8-457d-b995-\
df43998abf07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PutSolderingForm"}]], \
"Input",ExpressionUUID->"288bf52c-747e-437e-8693-1739141a3296"],

Cell[BoxData[
 StyleBox["\<\"PutSolderingForm[expr, inds, sigma] contracts free indices of \
expr with the soldering form sigma. The free indices are specified by means \
of the second argument, which can be given in several formats: an index, an \
IndexList of indices, a conjugated pair Pair[A,A\[Dagger]], a vbundle, a \
tensor, a covd or an IndicesOf expression with selectors (see xTensor \
documentation). Both the second and third arguments are sequentially folded \
over lists. PutSolderingForm[expr, inds] is converted into \
PutSolderingForm[expr, inds, $SolderingForms]. PutSolderingForm[expr] is \
converted into PutSolderingForm[expr, IndicesOf[]], adding soldering forms to \
all possible indices and pairs.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3588025982-1170166",ExpressionUUID->"99ec10de-636d-4a8b-8ff9-\
59f017cf8ca0"]
}, Open  ]],

Cell["User driver :", "Text",
 CellChangeTimes->{{3.426785268951932*^9, 
  3.426785271989361*^9}},ExpressionUUID->"de6e21a2-104e-40d0-9c49-\
8f22ebdeaec6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Shortcuts", " ", "for", " ", "the", " ", "third", " ", "argument"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "[", "expr_", "]"}], ":=", 
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndicesOf", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr_", ",", "inds_"}], "]"}], ":=", 
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr", ",", "inds", ",", "$SolderingForms"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr_", ",", "inds_", ",", "list_List"}], "]"}], ":=", 
     RowBox[{"Fold", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PutSolderingForm", "[", 
         RowBox[{"#1", ",", "inds", ",", "#2"}], "]"}], "&"}], ",", "expr", ",",
        "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Second", " ", "argument"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"ind_", "?", "GIndexQ"}], ",", "sigma_Symbol"}], "]"}], ":=", 
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndexList", "[", "ind", "]"}], ",", "sigma"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr_", ",", "list_List", ",", "sigma_Symbol"}], "]"}], ":=", 
     RowBox[{"Fold", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PutSolderingForm", "[", 
         RowBox[{"#1", ",", "#2", ",", "sigma"}], "]"}], "&"}], ",", "expr", ",",
        "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"master", ":", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"_Symbol", "?", "VBundleQ"}], "|", 
          RowBox[{"_Symbol", "?", "xTensorQ"}], "|", 
          RowBox[{"_Symbol", "?", "CovDQ"}]}], ")"}]}], ",", "sigma_Symbol"}],
       "]"}], ":=", 
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndicesOf", "[", 
        RowBox[{"Free", ",", "master"}], "]"}], ",", "sigma"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr_", ",", "f_IndicesOf", ",", "sigma_Symbol"}], "]"}], ":=", 
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr", ",", 
       RowBox[{
        RowBox[{"DeleteDuplicates", "[", 
         RowBox[{"Prepend", "[", 
          RowBox[{"f", ",", "Free"}], "]"}], "]"}], "[", "expr", "]"}], ",", 
       "sigma"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Actual", " ", "working", " ", 
     RowBox[{"function", ".", " ", "Two"}], " ", "entry", " ", "points"}], 
    " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr_", ",", "pair_Pair", ",", "sigma_Symbol"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"PutSolderingForm1", "[", 
       RowBox[{
        RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}], ",", "sigma"}],
        "]"}], "[", 
      RowBox[{"expr", ",", "pair"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PutSolderingForm", "[", 
      RowBox[{"expr_", ",", "inds_IndexList", ",", "sigma_Symbol"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"vbundle", "=", 
         RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}], "}"}], ",", 
       
       RowBox[{"Fold", "[", 
        RowBox[{
         RowBox[{"PutSolderingForm1", "[", 
          RowBox[{"vbundle", ",", "sigma"}], "]"}], ",", "expr", ",", 
         RowBox[{"FindPairs", "[", 
          RowBox[{"expr", ",", 
           RowBox[{"{", 
            RowBox[{"vbundle", ",", 
             RowBox[{"Dagger", "[", "vbundle", "]"}]}], "}"}], ",", "inds"}], 
          "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Other", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"PutSolderingForm", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Protect", "[", "PutSolderingForm", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"13cffc16-e8fa-414b-b9c8-48969d09ba54"],

Cell["\<\
Put soldering-form contracting both spin indices. A spacetime free index is \
generated:\
\>", "Text",
 CellChangeTimes->{{3.419167792284404*^9, 3.419167803837483*^9}, {
  3.419168111280881*^9, 3.41916811204*^9}, {3.4191682561467037`*^9, 
  3.419168272001001*^9}},ExpressionUUID->"12d677bf-2746-4897-99d6-\
2d14578a1293"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PutSolderingForm1", "[", 
     RowBox[{"vbundle_", ",", "sigma_"}], "]"}], "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"Pair", "[", 
      RowBox[{"index1_", ",", "index2_"}], "]"}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"indices", "=", 
       RowBox[{"FindIndices", "[", "expr", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Some", " ", "Checks"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"VBundleOfIndex", "[", "index1", "]"}], "=!=", "vbundle"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"VBundleOfIndex", "[", "index2", "]"}], "=!=", 
          RowBox[{"Dagger", "[", "vbundle", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"indices", ",", "index1"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"indices", ",", "index2"}], "]"}]}], "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Problem", ":", " ", 
         RowBox[{"do", " ", "nothing"}]}], " ", "*)"}], "\[IndentingNewLine]",
        "expr", ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Do", " ", "Put"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"A1", "=", 
            RowBox[{"DummyAs", "[", "index1", "]"}]}], ",", 
           RowBox[{"A2", "=", 
            RowBox[{"DummyAs", "[", "index2", "]"}]}], ",", 
           RowBox[{"a", "=", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UpIndexQ", "[", "index1", "]"}], ",", "UpIndex", ",", 
               "DownIndex"}], "]"}], "@", 
             RowBox[{"First", "@", 
              RowBox[{"GetIndicesOfVBundle", "[", 
               RowBox[{
                RowBox[{"TangentBundleOfManifold", "@", 
                 RowBox[{"BaseOfVBundle", "[", "vbundle", "]"}]}], ",", "1", ",", 
                RowBox[{"UpIndex", "/@", 
                 RowBox[{"FindIndices", "@", "expr"}]}]}], "]"}]}]}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ReplaceIndex", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"index1", "\[Rule]", "A1"}], ",", 
              RowBox[{"index2", "\[Rule]", "A2"}]}], "}"}]}], "]"}], 
          RowBox[{"sigma", "[", 
           RowBox[{"a", ",", 
            RowBox[{"-", "A1"}], ",", 
            RowBox[{"-", "A2"}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"115fe8ec-afc3-4c99-9917-36a599abea45"],

Cell["\<\
Put soldering form contracting the spacetime index. A pair of free indices in \
the spin vbundle and its conjugate are generated:\
\>", "Text",
 CellChangeTimes->{{3.419167175238427*^9, 3.4191671933095093`*^9}, {
  3.419167786941307*^9, 3.419167787236785*^9}, {3.419168226340905*^9, 
  3.419168264640991*^9}, {3.419422800885345*^9, 
  3.4194228012186213`*^9}},ExpressionUUID->"23d203ee-7557-450c-b0e9-\
24c5cd436700"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PutSolderingForm1", "[", 
     RowBox[{"vbundle_", ",", "sigma_"}], "]"}], "[", 
    RowBox[{"0", ",", "AnyIndices"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PutSolderingForm1", "[", 
     RowBox[{"vbundle_", ",", "sigma_"}], "]"}], "[", 
    RowBox[{"expr_", ",", "index_"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"indices", "=", 
       RowBox[{"FindIndices", "[", "expr", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Some", " ", "Checks"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"VBundleOfIndex", "[", "index", "]"}], "=!=", 
          RowBox[{"TangentBundleOfManifold", "@", 
           RowBox[{"BaseOfVBundle", "[", "vbundle", "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"indices", ",", "index"}], "]"}]}], "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Problem", ":", " ", 
         RowBox[{"do", " ", "nothing"}]}], " ", "*)"}], "\[IndentingNewLine]",
        "expr", ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Do", " ", "Put"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "A", ",", 
           RowBox[{"inds", "=", 
            RowBox[{"UpIndex", "/@", "indices"}]}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"a", "=", 
           RowBox[{"DummyAs", "[", "index", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"inds", "=", 
           RowBox[{"Union", "[", 
            RowBox[{"inds", ",", 
             RowBox[{"DaggerIndex", "/@", "inds"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"A", "=", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"UpIndexQ", "[", "index", "]"}], ",", "UpIndex", ",", 
              "DownIndex"}], "]"}], "@", 
            RowBox[{"First", "@", 
             RowBox[{"GetIndicesOfVBundle", "[", 
              RowBox[{"vbundle", ",", "1", ",", "inds"}], "]"}]}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ReplaceIndex", "[", 
            RowBox[{"expr", ",", 
             RowBox[{"index", "\[Rule]", "a"}]}], "]"}], 
           RowBox[{"sigma", "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", "A", ",", 
             RowBox[{"DaggerIndex", "[", "A", "]"}]}], "]"}]}]}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c38880bf-ff9f-45f4-ade4-4f6dd959f14d"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4. ContractSolderingForm", "Subsubsection",
 CellChangeTimes->{3.425988699271118*^9, 
  3.42678520906988*^9},ExpressionUUID->"6da08009-6221-4898-a8c2-0f4e6d625e1f"],

Cell["\<\
This is a complicated function, mostly due to the fact that there are \
actually two different functions here: contraction of the soldering form on \
the tbundle index and contraction on the pair of vbundle indices. We separate \
the code in seven parts.\
\>", "Text",
 CellChangeTimes->{{3.423766128766411*^9, 3.423766207767016*^9}, {
  3.426009425063922*^9, 
  3.426009425477808*^9}},ExpressionUUID->"6dec0abf-8afa-4829-9c22-\
93b253b7fc4e"],

Cell["\<\
Note that ContractSolderingForm is an index - driven function, and not a \
soldering-form - driven function, as we might have anticipated. In this \
sense, it is more similar to ContractBasis (also index - driven) than to \
ContractMetric (which is metric - driven). This is the result of the \
intermediate state of allowing a choice for the soldering-form (like a metric \
choice), but then working with a single soldering-form (like the single Basis \
tensor). This is partially solved allowing a tensor (which could be the \
soldering-form itself) as second argument.\
\>", "Text",
 CellChangeTimes->{{3.426010273141898*^9, 3.426010357324638*^9}, {
  3.426010408248783*^9, 3.426010467056099*^9}, {3.426010589853847*^9, 
  3.4260106223381777`*^9}, {3.432615720208658*^9, 
  3.432615724875629*^9}},ExpressionUUID->"0c6f4760-3bdf-4ea0-a879-\
b75fd22e1580"],

Cell["1) This is the user driver:", "Text",
 CellChangeTimes->{{3.423765762212537*^9, 
  3.423765763078692*^9}},ExpressionUUID->"25f364c8-fe31-445e-86c9-\
57a2faa36a6c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Single", " ", "option"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "ContractSolderingForm", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"OverDerivatives", "\[Rule]", "True"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Shortcuts", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndicesOf", "[", "]"}], ",", "options"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"tensor_Symbol", "?", "xTensorQ"}], ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndicesOf", "[", "tensor", "]"}], ",", "options"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"vbundle_Symbol", "?", "VBundleQ"}], ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndicesOf", "[", "vbundle", "]"}], ",", "options"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"index_", "?", "GIndexQ"}], ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndexList", "[", "index", "]"}], ",", "options"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr_", ",", "f_IndicesOf", ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"f", "[", "expr", "]"}], ",", "options"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Main", " ", "definition"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractSolderingForm", "[", 
      RowBox[{"expr_", ",", "list_IndexList", ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Fold", "[", 
      RowBox[{
       RowBox[{"CSF1", "[", 
        RowBox[{
         RowBox[{"OptionValue", "[", "OverDerivatives", "]"}], ",", "list"}], 
        "]"}], ",", 
       RowBox[{"Expand", "[", "expr", "]"}], ",", "$SolderingForms"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Other", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"ContractSolderingForm", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "ContractSolderingForm", "]"}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ad621192-cdd7-44cd-b515-f02b7a9eb39d"],

Cell["\<\
2) CSF1 folds over lists of indices, calling CSF2, which will introduce heads \
SpinorTMP and TensorTMP, which are finally removed with RemoveTMP. The \
motivation for the TMP heads is the following: in general a tensor will have \
several indices to contract; we introduce the TMP heads when contracting the \
first index, and remove it after contracting the last one.\
\>", "Text",ExpressionUUID->"ff1d3d3e-49ff-4475-9ef4-09513bf15d28"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plus", ":", " ", "thread"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CSF1", "[", 
       RowBox[{"TF_", ",", "inds_IndexList"}], "]"}], "[", 
      RowBox[{"expr_Plus", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CSF1", "[", 
         RowBox[{"TF", ",", "inds"}], "]"}], "[", 
        RowBox[{"#", ",", "sigma"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CSF1", "[", 
       RowBox[{"TF_", ",", "inds_IndexList"}], "]"}], "[", 
      RowBox[{"0", ",", "sigma_"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CSF1", "[", 
       RowBox[{"TF_", ",", "inds_IndexList"}], "]"}], "[", 
      RowBox[{"expr_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{"RemoveTMP", "@", 
      RowBox[{"Fold", "[", 
       RowBox[{
        RowBox[{"CSF2", "[", 
         RowBox[{"TF", ",", "sigma"}], "]"}], ",", "expr", ",", "inds"}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RemoveTMP", "[", "expr_", "]"}], ":=", 
     RowBox[{"expr", "/.", 
      RowBox[{
       RowBox[{"new", ":", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"SpinorTMP", "|", "TensorTMP"}], ")"}], "[", "__", "]"}], "[",
          "___", "]"}]}], "\[RuleDelayed]", 
       RowBox[{"ArrangeSpinTMP", "[", "new", "]"}]}]}]}], ";"}]}]}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"f89d67ac-0af9-407e-a3c6-15648f98cfda"],

Cell["\<\
3) There are two possibilities : either the index to contract is a real index \
on the tangent vbundle or it is a complex index on the inner vbundle. We \
separate those two cases to avoid many useless rules. This also allow us to \
know whether we will be converting a tensor into a spinor or viceversa. Note \
that from the user's point of view this can be controlled by specifying a \
vbundle in the second argument of the second pair of brackets.\
\>", "Text",
 CellChangeTimes->{{3.423334186410726*^9, 3.423334287686906*^9}, {
  3.423765926396987*^9, 3.4237659862534027`*^9}, {3.4237660499641857`*^9, 
  3.423766050650552*^9}},ExpressionUUID->"3f5a0dbf-38ce-4649-a791-\
e51d651c0447"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CSF2", "[", 
     RowBox[{"TF_", ",", "sigma_"}], "]"}], "[", 
    RowBox[{"expr_", ",", "i_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CSF2", "[", 
     RowBox[{"TF", ",", "sigma"}], "]"}], "[", 
    RowBox[{"expr", ",", "i", ",", 
     RowBox[{"ChangeIndex", "[", "i", "]"}], ",", 
     RowBox[{
      RowBox[{"DaggerIndex", "[", "i", "]"}], "===", "i"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4233343890610456`*^9, 3.423334416730802*^9}, {
  3.423334486475642*^9, 3.4233345370717297`*^9}, {3.423334734501876*^9, 
  3.423334788417408*^9}, {3.423341143868895*^9, 3.423341184387747*^9}, {
  3.423545012991034*^9, 3.4235450667019587`*^9}, {3.423545379153219*^9, 
  3.4235453841285133`*^9}, {3.4235764025341263`*^9, 3.423576435217968*^9}, {
  3.432616339394562*^9, 
  3.432616359691385*^9}},ExpressionUUID->"c11c5f89-4047-42ad-8027-\
f467286074b3"],

Cell["\<\
It would be nicer to code up this part with a single function CSF, and not \
two.\
\>", "Text",
 CellChangeTimes->{{3.432616560666185*^9, 
  3.432616588842473*^9}},ExpressionUUID->"a163ce77-3ee6-49da-b71a-\
0335a0680b70"],

Cell["\<\
4a) Recall that the tindex-contracted product of two sigmas gives a product \
of epsilons automatically. Hence we do not need a tensor=!=sigma check here. \
Also, when contracting the soldering form we need to check whether the master \
object is the spinor being acted upon or its dagger. This is to ensure that \
our conventions which establish the sorting of  spinor indices are met at any \
time.\
\>", "Text",ExpressionUUID->"9f5ae06d-f307-46ff-8d75-7f817894130b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Contraction", " ", "with", " ", "tensors", " ", "and", " ", 
    "derivatives"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CSF2", "[", 
       RowBox[{"False", ",", "sigma_"}], "]"}], "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"i_", "?", "ABIndexQ"}], ",", "ic_", ",", "True"}], "]"}], ":=", 
     RowBox[{"Expand", "[", 
      RowBox[{"expr", "/.", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"i", ",", "a_", ",", "b_"}], "]"}], 
           RowBox[{
            RowBox[{"tensor_", "?", "xTensorQ"}], "[", 
            RowBox[{"i1___", ",", "ic", ",", "i2___"}], "]"}]}], "\[RuleDelayed]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"HasDaggerCharacterQ", "[", "tensor", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"SpinorTMP", "[", 
              RowBox[{"tensor", ",", "sigma"}], "]"}], "[", 
             RowBox[{"i1", ",", "b", ",", "a", ",", "i2"}], "]"}], ",", 
            RowBox[{
             RowBox[{"SpinorTMP", "[", 
              RowBox[{"tensor", ",", "sigma"}], "]"}], "[", 
             RowBox[{"i1", ",", "a", ",", "b", ",", "i2"}], "]"}]}], "]"}]}], 
         ",", 
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"ic", ",", "a_", ",", "b_"}], "]"}], 
           RowBox[{
            RowBox[{"tensor_", "?", "xTensorQ"}], "[", 
            RowBox[{"i1___", ",", "i", ",", "i2___"}], "]"}]}], "\[RuleDelayed]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"HasDaggerCharacterQ", "[", "tensor", "]"}], ",", 
            RowBox[{
             RowBox[{"SpinorTMP", "[", 
              RowBox[{"tensor", ",", "sigma"}], "]"}], "[", 
             RowBox[{"i1", ",", "b", ",", "a", ",", "i2"}], "]"}], ",", 
            RowBox[{
             RowBox[{"SpinorTMP", "[", 
              RowBox[{"tensor", ",", "sigma"}], "]"}], "[", 
             RowBox[{"i1", ",", "a", ",", "b", ",", "i2"}], "]"}]}], "]"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"i", ",", "a_", ",", "b_"}], "]"}], 
           RowBox[{
            RowBox[{
             RowBox[{"covd_Symbol", "?", "SpinCovDQ"}], "[", "ic", "]"}], "[",
             "expr1_", "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"covd", "[", 
            RowBox[{"a", ",", "b"}], "]"}], "[", "expr1", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"ic", ",", "a_", ",", "b_"}], "]"}], 
           RowBox[{
            RowBox[{
             RowBox[{"covd_Symbol", "?", "SpinCovDQ"}], "[", "i", "]"}], "[", 
            "expr1_", "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"covd", "[", 
            RowBox[{"a", ",", "b"}], "]"}], "[", "expr1", "]"}]}]}], "}"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Recursion", " ", "through", " ", "covariant", " ", "derivatives"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CSF2", "[", 
       RowBox[{"True", ",", "sigma_"}], "]"}], "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"i_", "?", "AIndexQ"}], ",", "ic_", ",", "True"}], "]"}], ":=", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"CSF2", "[", 
         RowBox[{"False", ",", "sigma"}], "]"}], "[", 
        RowBox[{"expr", ",", "i", ",", "ic", ",", "True"}], "]"}], "/.", 
       RowBox[{
        RowBox[{"rest_.", 
         RowBox[{"sigma", "[", 
          RowBox[{"i", ",", "a_", ",", "b_"}], "]"}], 
         RowBox[{
          RowBox[{
           RowBox[{"covd_Symbol", "?", "CovDQ"}], "[", "inds__", "]"}], "[", 
          "expr1_", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"rest", " ", 
          RowBox[{
           RowBox[{"covd", "[", "inds", "]"}], "[", 
           RowBox[{
            RowBox[{"CSF2", "[", 
             RowBox[{"True", ",", "sigma"}], "]"}], "[", 
            RowBox[{
             RowBox[{
              RowBox[{"sigma", "[", 
               RowBox[{"i", ",", "a", ",", "b"}], "]"}], "expr1"}], ",", "i", 
             ",", "ic", ",", "True"}], "]"}], "]"}]}], "/;", 
         RowBox[{
          RowBox[{"IsIndexOf", "[", 
           RowBox[{"expr1", ",", "ic"}], "]"}], "&&", 
          RowBox[{
           RowBox[{"SolderingFormOfSpinCovD", "[", "covd", "]"}], "===", 
           "sigma"}]}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"For", " ", "other", " ", "types", " ", "of", " ", "indices"}], ",",
      " ", 
     RowBox[{"do", " ", "nothing"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CSF2", "[", 
       RowBox[{"_", ",", "_"}], "]"}], "[", 
      RowBox[{"expr_", ",", "_", ",", "_", ",", "True"}], "]"}], ":=", 
     "expr"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"75b1ef86-b324-4845-a5ff-ef3bd0b93202"],

Cell["\<\
4b) Note the structure of the function SST: the original expression \
sigma[a,i,j]*spinor[i1,ic,jc,i2] is being converted into tensor[i1,a,i2].\
\>", "Text",
 CellChangeTimes->{{3.432617175656928*^9, 3.432617255335593*^9}, 
   3.432620466005963*^9},ExpressionUUID->"8c8d86a5-296d-4ced-b55a-\
a3e7d9a557a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SST", "[", 
     RowBox[{"sigma_", ",", "a_"}], "]"}], "[", 
    RowBox[{"spinor_", ",", 
     RowBox[{"{", "i1___", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ic_", ",", "jc_"}], "}"}], ",", 
     RowBox[{"{", "i2___", "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"TensorTMP", "[", 
     RowBox[{"spinor", ",", "sigma", ",", 
      RowBox[{"a", "\[RuleDelayed]", 
       RowBox[{"Sequence", "[", 
        RowBox[{"ic", ",", "jc"}], "]"}]}]}], "]"}], "[", 
    RowBox[{"i1", ",", "a", ",", "i2"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4326170673549*^9, 3.432617078039797*^9}, {
   3.43261991405218*^9, 3.432619966613911*^9}, {3.432620035010771*^9, 
   3.432620041404608*^9}, {3.432620430007675*^9, 3.432620441935331*^9}, {
   3.432620551613266*^9, 3.432620560066063*^9}, 3.432621456515301*^9, {
   3.432621644847514*^9, 
   3.432621664533986*^9}},ExpressionUUID->"f63a53aa-1fcb-451d-9b57-\
bbd278554f9e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Contraction", " ", "with", " ", "tensors", " ", "and", " ", "2"}], "-", 
    RowBox[{"index", " ", "derivatives"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CSF2", "[", 
       RowBox[{"False", ",", "sigma_"}], "]"}], "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"i_", "?", "EIndexQ"}], ",", "ic_", ",", "False"}], "]"}], ":=", 
     RowBox[{"Expand", "[", 
      RowBox[{"expr", "/.", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"a_", ",", "j_", ",", "i"}], "]"}], 
           RowBox[{"sigma", "[", 
            RowBox[{"b_", ",", "k_", ",", 
             RowBox[{"ic", "?", "UpIndexQ"}]}], "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"Sigma", "[", "sigma", "]"}], "[", 
           RowBox[{"a", ",", "b", ",", "j", ",", "k"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"a_", ",", "i", ",", "j_"}], "]"}], 
           RowBox[{"sigma", "[", 
            RowBox[{"b_", ",", 
             RowBox[{"ic", "?", "UpIndexQ"}], ",", "k_"}], "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"Dagger", "[", 
            RowBox[{"Sigma", "[", "sigma", "]"}], "]"}], "[", 
           RowBox[{"a", ",", "b", ",", "j", ",", "k"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "j_", ",", "i"}], "]"}], "|", 
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "i", ",", "j_"}], "]"}]}], ")"}], 
           RowBox[{
            RowBox[{"spinor_", "?", "xTensorQ"}], "[", 
            RowBox[{"i1___", ",", "ic", ",", "jc_", ",", "i2___"}], "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{
            RowBox[{"SST", "[", 
             RowBox[{"sigma", ",", "a"}], "]"}], "[", 
            RowBox[{"spinor", ",", 
             RowBox[{"{", "i1", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"ic", ",", "jc"}], "}"}], ",", 
             RowBox[{"{", "i2", "}"}]}], "]"}], "/;", 
           RowBox[{"PairQ", "[", 
            RowBox[{"j", ",", "jc"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "jc_", ",", "ic"}], "]"}], "|", 
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "ic", ",", "jc_"}], "]"}]}], ")"}], 
           RowBox[{
            RowBox[{"spinor_", "?", "xTensorQ"}], "[", 
            RowBox[{"i1___", ",", "i", ",", "j_", ",", "i2___"}], "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{
            RowBox[{"SST", "[", 
             RowBox[{"sigma", ",", "a"}], "]"}], "[", 
            RowBox[{"spinor", ",", 
             RowBox[{"{", "i1", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "j"}], "}"}], ",", 
             RowBox[{"{", "i2", "}"}]}], "]"}], "/;", 
           RowBox[{"PairQ", "[", 
            RowBox[{"j", ",", "jc"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "i", ",", "j_"}], "]"}], "|", 
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "j_", ",", "i"}], "]"}]}], ")"}], 
           RowBox[{
            RowBox[{"spinor_", "?", "xTensorQ"}], "[", 
            RowBox[{"i1___", ",", "jc_", ",", "ic", ",", "i2___"}], "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{
            RowBox[{"SST", "[", 
             RowBox[{"sigma", ",", "a"}], "]"}], "[", 
            RowBox[{"spinor", ",", 
             RowBox[{"{", "i1", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"jc", ",", "ic"}], "}"}], ",", 
             RowBox[{"{", "i2", "}"}]}], "]"}], "/;", 
           RowBox[{"PairQ", "[", 
            RowBox[{"j", ",", "jc"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "jc_", ",", "ic"}], "]"}], "|", 
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "ic", ",", "jc_"}], "]"}]}], ")"}], 
           RowBox[{
            RowBox[{"spinor_", "?", "xTensorQ"}], "[", 
            RowBox[{"i1___", ",", "j_", ",", "i", ",", "i2___"}], "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{
            RowBox[{"SST", "[", 
             RowBox[{"sigma", ",", "a"}], "]"}], "[", 
            RowBox[{"spinor", ",", 
             RowBox[{"{", "i1", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "i"}], "}"}], ",", 
             RowBox[{"{", "i2", "}"}]}], "]"}], "/;", 
           RowBox[{"PairQ", "[", 
            RowBox[{"j", ",", "jc"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"a_", ",", "i", ",", "j_"}], "]"}], 
           RowBox[{
            RowBox[{
             RowBox[{"covd_", "?", "SpinCovDQ"}], "[", 
             RowBox[{"ic", ",", "jc_"}], "]"}], "[", "expr1_", "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{
            RowBox[{"CovDSpinSign", "[", 
             RowBox[{"ic", ",", "jc"}], "]"}], 
            RowBox[{
             RowBox[{"covd", "[", "a", "]"}], "[", "expr1", "]"}]}], "/;", 
           RowBox[{"PairQ", "[", 
            RowBox[{"j", ",", "jc"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"a_", ",", "ic", ",", "jc_"}], "]"}], 
           RowBox[{
            RowBox[{
             RowBox[{"covd_", "?", "SpinCovDQ"}], "[", 
             RowBox[{"i", ",", "j_"}], "]"}], "[", "expr1_", "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{
            RowBox[{"CovDSpinSign", "[", 
             RowBox[{"i", ",", "j"}], "]"}], 
            RowBox[{
             RowBox[{"covd", "[", "a", "]"}], "[", "expr1", "]"}]}], "/;", 
           RowBox[{"PairQ", "[", 
            RowBox[{"j", ",", "jc"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"a_", ",", "j_", ",", "i"}], "]"}], 
           RowBox[{
            RowBox[{
             RowBox[{"covd_", "?", "SpinCovDQ"}], "[", 
             RowBox[{"jc_", ",", "ic"}], "]"}], "[", "expr1_", "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{
            RowBox[{"CovDSpinSign", "[", 
             RowBox[{"jc", ",", "ic"}], "]"}], 
            RowBox[{
             RowBox[{"covd", "[", "a", "]"}], "[", "expr1", "]"}]}], "/;", 
           RowBox[{"PairQ", "[", 
            RowBox[{"j", ",", "jc"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"a_", ",", "jc_", ",", "ic"}], "]"}], 
           RowBox[{
            RowBox[{
             RowBox[{"covd_", "?", "SpinCovDQ"}], "[", 
             RowBox[{"j_", ",", "i"}], "]"}], "[", "expr1_", "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{
            RowBox[{"CovDSpinSign", "[", 
             RowBox[{"j", ",", "i"}], "]"}], 
            RowBox[{
             RowBox[{"covd", "[", "a", "]"}], "[", "expr1", "]"}]}], "/;", 
           RowBox[{"PairQ", "[", 
            RowBox[{"j", ",", "jc"}], "]"}]}]}]}], "}"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Recursion", " ", "through", " ", "covariant", " ", "derivatives"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CSF2", "[", 
       RowBox[{"True", ",", "sigma_"}], "]"}], "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"i_", "?", "AIndexQ"}], ",", "ic_", ",", "False"}], "]"}], ":=", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"CSF2", "[", 
         RowBox[{"False", ",", "sigma"}], "]"}], "[", 
        RowBox[{"expr", ",", "i", ",", "ic", ",", "False"}], "]"}], "/.", 
       RowBox[{
        RowBox[{"rest_.", 
         RowBox[{"(", 
          RowBox[{"sig", ":", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "i", ",", "j_"}], "]"}], "|", 
             RowBox[{"sigma", "[", 
              RowBox[{"a_", ",", "j_", ",", "i"}], "]"}]}], ")"}]}], ")"}], 
         RowBox[{
          RowBox[{
           RowBox[{"covd_Symbol", "?", "CovDQ"}], "[", "inds__", "]"}], "[", 
          "expr1_", "]"}]}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"rest", " ", 
          RowBox[{
           RowBox[{"covd", "[", "inds", "]"}], "[", 
           RowBox[{
            RowBox[{"CSF2", "[", 
             RowBox[{"True", ",", "sigma"}], "]"}], "[", 
            RowBox[{
             RowBox[{"sig", " ", "expr1"}], ",", "i", ",", "ic", ",", 
             "False"}], "]"}], "]"}]}], "/;", 
         RowBox[{
          RowBox[{"IsIndexOf", "[", 
           RowBox[{"expr1", ",", "ic"}], "]"}], "&&", 
          RowBox[{"IsIndexOf", "[", 
           RowBox[{"expr1", ",", 
            RowBox[{"ChangeIndex", "[", "j", "]"}]}], "]"}], "&&", 
          RowBox[{
           RowBox[{"SolderingFormOfSpinCovD", "[", "covd", "]"}], "===", 
           "sigma"}]}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"For", " ", "other", " ", "types", " ", "of", " ", "indices"}], ",",
      " ", 
     RowBox[{"do", " ", "nothing"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CSF2", "[", 
       RowBox[{"_", ",", "_"}], "]"}], "[", 
      RowBox[{"expr_", ",", "_", ",", "_", ",", "False"}], "]"}], ":=", 
     "expr"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"53ed347f-ae53-471f-84b3-5bb4db5c6bb7"],

Cell["\<\
5) There is nothing yet for OverDerivatives -> True, and there is nothing yet \
for Lie brackets.\
\>", "Text",
 CellChangeTimes->{{3.423336104986249*^9, 3.423336115354838*^9}, {
  3.423336150914463*^9, 3.423336159443392*^9}, {3.4237661051760693`*^9, 
  3.423766105690736*^9}},ExpressionUUID->"198a9539-25c1-47f1-b78c-\
12fdc747b957"],

Cell["\<\
6) The heads SpinorTMP and TensorTMP mark those objects which are being \
transformed from tensors to spinors or viceversa, respectively. They contain \
the name of the object being transformed, the name of the soldering form \
being used for the transformation and then a sequence of rules with the \
indices being transformed. This sequence can be empty.\
\>", "Text",
 CellChangeTimes->{{3.423338533183003*^9, 3.423338548379911*^9}, {
  3.4237661009154882`*^9, 3.423766103976268*^9}, {3.43262224545795*^9, 
  3.432622295617122*^9}},ExpressionUUID->"8add3d45-9b93-437c-8bf1-\
e2300c31351b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Generalize", " ", "some", " ", "Q"}], "-", "functions"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SpinorTMP", "/:", 
     RowBox[{"HasDaggerCharacterQ", "[", 
      RowBox[{"SpinorTMP", "[", 
       RowBox[{"tensor_", ",", "sigma_", ",", "___"}], "]"}], "]"}], ":=", 
     RowBox[{"HasDaggerCharacterQ", "[", "tensor", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SpinorTMP", "/:", 
     RowBox[{"xTensorQ", "[", 
      RowBox[{"SpinorTMP", "[", 
       RowBox[{"tensor_", ",", "sigma_", ",", "___"}], "]"}], "]"}], ":=", 
     RowBox[{"xTensorQ", "[", "tensor", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorTMP", "/:", 
     RowBox[{"xTensorQ", "[", 
      RowBox[{"TensorTMP", "[", 
       RowBox[{"spinor_", ",", "sigma_", ",", "___"}], "]"}], "]"}], ":=", 
     RowBox[{"xTensorQ", "[", "spinor", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "IsIndexOf", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SpinorTMP", "/:", 
     RowBox[{"IsIndexOf", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"SpinorTMP", "[", "__", "]"}], "[", "inds__", "]"}], ",", 
       "ind_", ",", "_"}], "]"}], ":=", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"{", "inds", "}"}], ",", "ind"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorTMP", "/:", 
     RowBox[{"IsIndexOf", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"TensorTMP", "[", "__", "]"}], "[", "inds__", "]"}], ",", 
       "ind_", ",", "_"}], "]"}], ":=", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"{", "inds", "}"}], ",", "ind"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Recursion", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SpinorTMP", "[", 
      RowBox[{
       RowBox[{"SpinorTMP", "[", 
        RowBox[{"tensor_", ",", "sigma_", ",", "rules1___"}], "]"}], ",", 
       "sigma_", ",", "rules2___"}], "]"}], ":=", 
     RowBox[{"SpinorTMP", "[", 
      RowBox[{"tensor", ",", "sigma", ",", "rules1", ",", "rules2"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorTMP", "[", 
      RowBox[{
       RowBox[{"TensorTMP", "[", 
        RowBox[{"spinor_", ",", "sigma_", ",", "rules1___"}], "]"}], ",", 
       "sigma_", ",", "rules2___"}], "]"}], ":=", 
     RowBox[{"TensorTMP", "[", 
      RowBox[{"spinor", ",", "sigma", ",", "rules1", ",", "rules2"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SpinorTMP", "[", 
      RowBox[{
       RowBox[{"SpinorTMP", "[", "__", "]"}], ",", "__"}], "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"ContractSolderingForm", "::", "error"}], 
        ",", "\"\<Cannot contract two different soldering forms on the same \
tensor.\>\""}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorTMP", "[", 
      RowBox[{
       RowBox[{"TensorTMP", "[", "__", "]"}], ",", "__"}], "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"ContractSolderingForm", "::", "error"}], 
        ",", "\"\<Cannot contract two different soldering forms on the same \
spinor.\>\""}], "]"}]}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3f6f4197-946b-4366-8c49-8ff1fce2282c"],

Cell["\<\
7) These functions return the new objects, creating them if they do not exist \
yet:\
\>", "Text",
 CellChangeTimes->{{3.423335505290955*^9, 3.4233355966003923`*^9}, {
  3.423766119220942*^9, 
  3.423766120204153*^9}},ExpressionUUID->"b4151ce1-41b7-45d0-9111-\
2f4e70cf98d8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArrangeSpinTMP", "[", 
    RowBox[{
     RowBox[{"SpinorTMP", "[", 
      RowBox[{"tensor_", ",", "sigma_", ",", "rules___"}], "]"}], "[", 
     "spinds___", "]"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"spinor", "=", 
       RowBox[{"SpinorOfTensor", "[", 
        RowBox[{"tensor", ",", "sigma"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"xTensorQ", "[", "spinor", "]"}]}], ",", 
        RowBox[{"DefSpinorOfTensor", "[", 
         RowBox[{
          RowBox[{"spinor", "[", "spinds", "]"}], ",", 
          RowBox[{"Apply", "[", 
           RowBox[{"tensor", ",", 
            RowBox[{"DummyIn", "/@", 
             RowBox[{"SlotsOfTensor", "[", "tensor", "]"}]}]}], "]"}], ",", 
          "sigma"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"SpinorSign", "[", 
         RowBox[{"spinor", ",", "rules"}], "]"}], "[", "spinds", "]"}], 
       RowBox[{"spinor", "[", "spinds", "]"}]}]}]}], "]"}]}], ";"}]], "Input",
 
 InitializationCell->True,
 CellChangeTimes->{{3.41916533034486*^9, 3.419165334959661*^9}, {
   3.41942574138645*^9, 3.4194257483515472`*^9}, {3.423334963393701*^9, 
   3.423334987398096*^9}, {3.423335018690505*^9, 3.423335026137323*^9}, {
   3.42333507502811*^9, 3.423335187881547*^9}, {3.423335966803097*^9, 
   3.4233359856530457`*^9}, {3.423336022303013*^9, 3.42333602289926*^9}, 
   3.423336072767893*^9, {3.4233385868912983`*^9, 3.4233385896814632`*^9}, {
   3.423338881700582*^9, 3.423338910765545*^9}, {3.42357635489858*^9, 
   3.42357636389406*^9}, {3.432622130861694*^9, 3.432622157517941*^9}, {
   3.432622632403295*^9, 
   3.432622632544038*^9}},ExpressionUUID->"01bdc105-2b4d-4f56-89fb-\
8d7be5691a12"],

Cell["\<\
Converting a spinor into a tensor we need to worry about the index \
characters, because the global sign of the final expression depends on those, \
through the see - saw rule.\
\>", "Text",
 CellChangeTimes->{{3.432620359232718*^9, 
  3.432620416316792*^9}},ExpressionUUID->"72468578-8e80-4524-bfa8-\
e95f448b317a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArrangeSpinTMP", "[", 
    RowBox[{
     RowBox[{"TensorTMP", "[", 
      RowBox[{"spinor_", ",", "sigma_", ",", "rules___"}], "]"}], "[", 
     "tinds___", "]"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tensor", "=", 
       RowBox[{"TensorOfSpinor", "[", 
        RowBox[{"spinor", ",", "sigma"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"xTensorQ", "[", "tensor", "]"}]}], ",", 
        RowBox[{"DefTensorOfSpinor", "[", 
         RowBox[{
          RowBox[{"tensor", "[", "tinds", "]"}], ",", 
          RowBox[{"Apply", "[", 
           RowBox[{"spinor", ",", 
            RowBox[{"DummyIn", "/@", 
             RowBox[{"SlotsOfTensor", "[", "spinor", "]"}]}]}], "]"}], ",", 
          "sigma"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"TensorSign", "[", 
         RowBox[{"spinor", ",", "rules"}], "]"}], "[", "tinds", "]"}], 
       RowBox[{"tensor", "[", "tinds", "]"}]}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.41916533034486*^9, 3.419165334959661*^9}, {
   3.41942574138645*^9, 3.4194257483515472`*^9}, {3.423334963393701*^9, 
   3.423334987398096*^9}, {3.423335018690505*^9, 3.423335026137323*^9}, {
   3.42333507502811*^9, 3.423335187881547*^9}, {3.423335349229438*^9, 
   3.42333541548912*^9}, {3.423335999735153*^9, 3.423336027988161*^9}, 
   3.4233360694277487`*^9, {3.423338597135944*^9, 3.4233386012519627`*^9}, {
   3.423338889198962*^9, 3.423338945063265*^9}, {3.4235436135669947`*^9, 
   3.423543624514144*^9}, {3.4235494172392063`*^9, 3.423549417607272*^9}, {
   3.423576366879772*^9, 3.4235763738096113`*^9}, {3.432620353070627*^9, 
   3.432620355218411*^9}, 3.432620891168562*^9, {3.432621554704702*^9, 
   3.432621562982722*^9}, 3.432622069714472*^9, 3.432622161397379*^9, {
   3.432622615800724*^9, 
   3.432622616485832*^9}},ExpressionUUID->"ae0868f2-1c66-43b5-8e03-\
7cd96226b393"],

Cell["Here is how we do it :", "Text",
 CellChangeTimes->{{3.432621600385715*^9, 
  3.432621605677744*^9}},ExpressionUUID->"a9b8ede0-6c50-4066-85ee-\
01a4b14154e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Derivatives", ":", " ", 
    RowBox[{"correct", " ", "character", " ", "is", " ", "covariant"}]}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CovDSpinSign", "[", 
      RowBox[{"i_", ",", "j_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"UpIndexQ", "[", "i", "]"}], ",", 
        RowBox[{"-", "1"}], ",", "1"}], "]"}], 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"UpIndexQ", "[", "j", "]"}], ",", 
        RowBox[{"-", "1"}], ",", "1"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Transforming", " ", "spinor", " ", "into", " ", "tensor"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"TensorSign", "[", "spinor_", "]"}], "[", "___", "]"}], ":=", 
     "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"TensorSign", "[", 
       RowBox[{"spinor_", ",", "rules__"}], "]"}], "[", "tinds___", "]"}], ":=", 
     RowBox[{"Apply", "[", 
      RowBox[{
       RowBox[{"SpinorSign", "[", 
        RowBox[{"spinor", ",", "rules"}], "]"}], ",", 
       RowBox[{
        RowBox[{"IndexList", "[", "tinds", "]"}], "/.", 
        RowBox[{"{", "rules", "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Transforming", " ", "tensor", " ", "into", " ", "spinor"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SpinorSign", "[", "spinor_", "]"}], "[", "___", "]"}], ":=", 
     "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SpinorSign", "[", 
       RowBox[{"spinor_", ",", "rules__"}], "]"}], "[", "spinds___", "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"repinds", "=", 
         RowBox[{"Last", "/@", 
          RowBox[{"{", "rules", "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"Inner", "[", 
        RowBox[{"checkVB", ",", 
         RowBox[{
         "xAct`xTensor`Private`SignedVBundleOfIndex", "/@", "repinds"}], ",", 
         
         RowBox[{
          RowBox[{"SlotsOfTensor", "[", "spinor", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{
                RowBox[{"{", "spinds", "}"}], ",", "#"}], "]"}], "&"}], "/@", 
             "repinds"}], "]"}], "]"}], "]"}], ",", "Times"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Check", " ", "vbundles", " ", "are", " ", "correct"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"checkVB", "[", 
      RowBox[{"vb_", ",", 
       RowBox[{"-", "vb_"}]}], "]"}], ":=", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"checkVB", "[", 
      RowBox[{
       RowBox[{"-", "vb_"}], ",", "vb_"}], "]"}], ":=", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"checkVB", "[", 
      RowBox[{"vb_", ",", "vb_"}], "]"}], ":=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"checkVB", "[", 
      RowBox[{"_", ",", "_"}], "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"ContractSolderingForm", "::", "error"}], 
        ",", "\"\<Internal inconsistency. Tell JMM.\>\""}], "]"}]}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.432620876617502*^9, 3.432620963682202*^9}, {
   3.432621044614453*^9, 3.432621067169663*^9}, {3.432621097661851*^9, 
   3.432621208767917*^9}, {3.432621244152944*^9, 3.432621289770657*^9}, {
   3.432621421659372*^9, 3.43262146440555*^9}, {3.43262153942947*^9, 
   3.432621543971527*^9}, {3.432622083132074*^9, 3.432622096287986*^9}, {
   3.43262262336795*^9, 3.432622720584715*^9}, {3.43262286384362*^9, 
   3.432622914280783*^9}, {3.432627183322462*^9, 3.4326271988958*^9}, {
   3.432627287044953*^9, 3.432627320747363*^9}, {3.432627374670487*^9, 
   3.432627378172725*^9}, {3.432627458728533*^9, 3.432627460765182*^9}, 
   3.432627559131471*^9, {3.432627597627897*^9, 3.4326276615041*^9}, {
   3.432627719906183*^9, 
   3.432627804842297*^9}},ExpressionUUID->"728013b9-3728-4304-b910-\
a9571c22b24d"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.5. SeparateSolderingForm", "Subsubsection",
 CellChangeTimes->{{3.419237880662826*^9, 3.419237888230817*^9}, {
   3.423576552250349*^9, 3.4235765549809093`*^9}, 3.423637756138484*^9, {
   3.4259403003170547`*^9, 3.42594030054053*^9}, 
   3.426785210304873*^9},ExpressionUUID->"7312d156-34e6-4f99-b198-\
bae867e1490d"],

Cell["\<\
This is the inverse operation to ContractSolderingForm. We will follow its \
same complicated structure in steps:\
\>", "Text",
 CellChangeTimes->{{3.423766266187862*^9, 3.42376640267426*^9}, {
  3.426009080137388*^9, 
  3.426009122963792*^9}},ExpressionUUID->"ad7740f4-7552-47f6-99bf-\
bc6613eb2f8a"],

Cell["\<\
1) This is the user driver. It has four arguments in general:
          - the expression in which to separate
          - the indices to separate, with a number of shortcuts, all giving \
an IndexList at the end
          - the soldering-form to separate
          - the basis of the dummy index introduced, with AIndex as default.\
\>", "Text",
 CellChangeTimes->{{3.423765762212537*^9, 3.423765763078692*^9}, {
  3.426010870141005*^9, 3.426010897474482*^9}, {3.426010930519112*^9, 
  3.426011033564969*^9}, {3.4260110833100243`*^9, 3.426011093700643*^9}, {
  3.426013729537489*^9, 
  3.42601373646988*^9}},ExpressionUUID->"653e029e-2ecb-4d0d-ba4b-\
eaa5966db9ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"To", " ", "four", " ", "arguments"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", "args___", "]"}], "[", "expr_", 
      "]"}], ":=", 
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", "args", "]"}], "[", 
      RowBox[{"expr", ",", "All"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", "]"}], "[", 
      RowBox[{"expr_", ",", "inds_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"$SolderingForms", ",", "AIndex"}], "]"}], "[", 
      RowBox[{"expr", ",", "inds"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", "sigma_", "]"}], "[", 
      RowBox[{"expr_", ",", "inds_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma", ",", "AIndex"}], "]"}], "[", 
      RowBox[{"expr", ",", "inds"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Four", " ", "arguments"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"list_List", ",", "basis_"}], "]"}], "[", 
      RowBox[{"expr_", ",", "inds_"}], "]"}], ":=", 
     RowBox[{"Fold", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"SeparateSolderingForm", "[", 
          RowBox[{"#2", ",", "basis"}], "]"}], "[", 
         RowBox[{"#1", ",", "inds"}], "]"}], "&"}], ",", "expr", ",", 
       "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma_Symbol", ",", "basis_"}], "]"}], "[", 
      RowBox[{"expr_", ",", "All"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma", ",", "basis"}], "]"}], "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndicesOf", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma_Symbol", ",", "basis_"}], "]"}], "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"vb_Symbol", "?", "VBundleQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma", ",", "basis"}], "]"}], "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndicesOf", "[", "vb", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma_Symbol", ",", "basis_"}], "]"}], "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"covd_Symbol", "?", "CovDQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma", ",", "basis"}], "]"}], "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndicesOf", "[", "covd", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma_Symbol", ",", "basis_"}], "]"}], "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"ind_", "?", "GIndexQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma", ",", "basis"}], "]"}], "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndexList", "[", "ind", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Thread", " ", "over", " ", "sums"}], ",", " ", 
     RowBox[{"before", " ", "using", " ", "IndicesOf"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma_Symbol", ",", "basis_"}], "]"}], "[", 
      RowBox[{"expr_Plus", ",", "inds_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"SeparateSolderingForm", "[", 
         RowBox[{"sigma", ",", "basis"}], "]"}], "[", 
        RowBox[{"#", ",", "inds"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma_Symbol", ",", "basis_"}], "]"}], "[", 
      RowBox[{"expr_", ",", "f_IndicesOf"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma", ",", "basis"}], "]"}], "[", 
      RowBox[{"expr", ",", 
       RowBox[{"f", "[", "expr", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Expand", " ", "list", " ", "of", " ", "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"sigma_Symbol", ",", "basis_"}], "]"}], "[", 
      RowBox[{"expr_", ",", "list_IndexList"}], "]"}], ":=", 
     RowBox[{"RemoveTMP", "@", 
      RowBox[{"Fold", "[", 
       RowBox[{
        RowBox[{"SSF1", "[", 
         RowBox[{"sigma", ",", "basis"}], "]"}], ",", "expr", ",", 
        RowBox[{"FindPairs", "[", 
         RowBox[{"expr", ",", 
          RowBox[{"{", 
           RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}], "}"}], ",", 
          "list"}], "]"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Errors", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", "x__", "]"}], "[", 
      RowBox[{"_", ",", "_IndexList"}], "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"SeparateSolderingForm", "::", "invalid"}], ",", 
        RowBox[{"{", "x", "}"}], ",", "\"\<sigma or basis info\>\""}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateSolderingForm", "[", 
       RowBox[{"_", ",", "_"}], "]"}], "[", 
      RowBox[{"_", ",", "x__"}], "]"}], ":=", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"SeparateSolderingForm", "::", "\"\<argrx\>\""}], ",", 
       "SeparateSolderingForm", ",", 
       RowBox[{"2", "+", 
        RowBox[{"Length", "[", 
         RowBox[{"{", "x", "}"}], "]"}]}], ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "SeparateSolderingForm", "]"}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4260111047067223`*^9, 3.4260113871535788`*^9}, {
   3.4260115134289494`*^9, 3.4260115848276043`*^9}, {3.426011624641543*^9, 
   3.426011872388165*^9}, {3.426011939018703*^9, 3.426012118854065*^9}, {
   3.4260121674046917`*^9, 3.426012168784712*^9}, {3.4260122008675222`*^9, 
   3.426012277349972*^9}, {3.426012634322659*^9, 3.426012668142365*^9}, {
   3.426012746414114*^9, 3.426012855652997*^9}, {3.4260128868122673`*^9, 
   3.426012907282641*^9}, {3.426012939668476*^9, 3.426013006031901*^9}, {
   3.426013052211899*^9, 3.426013410683659*^9}, {3.426013463895677*^9, 
   3.426013497631873*^9}, {3.426014168736433*^9, 3.426014170906451*^9}, {
   3.42601460580982*^9, 3.426014640332912*^9}, {3.426031747155218*^9, 
   3.426031748131195*^9}, {3.426032220524741*^9, 3.426032221773539*^9}, {
   3.42603236022696*^9, 3.4260323991459713`*^9}, {3.4265221365025873`*^9, 
   3.426522194067432*^9}, {3.426522259525517*^9, 3.426522273441277*^9}, {
   3.426522459874741*^9, 3.42652246402242*^9}, {3.426523257770759*^9, 
   3.426523304393385*^9}, {3.426524790981996*^9, 3.426524791376367*^9}, {
   3.4265249428296127`*^9, 3.426524945372088*^9}, {3.4265250771176357`*^9, 
   3.426525078128203*^9}, {3.426529519750177*^9, 3.4265295224521933`*^9}, 
   3.426794087768417*^9},ExpressionUUID->"91097b21-ceb5-4a7e-8c92-\
1fc73f685dd2"],

Cell["\<\
2) Now we separate those cases with an index on a tangent vbundle and an \
index on an inner vbundle :\
\>", "Text",
 CellChangeTimes->{{3.425925896334049*^9, 3.425925900181313*^9}, {
  3.4259294161397057`*^9, 3.425929458183032*^9}, {3.4260123522860413`*^9, 
  3.4260123529486647`*^9}},ExpressionUUID->"ac881418-a422-473f-b41d-\
82d25013f999"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SSF1", "[", 
     RowBox[{"sigma_", ",", "basis_"}], "]"}], "[", 
    RowBox[{"expr_", ",", "pair_Pair"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SSFInner", "[", 
     RowBox[{"sigma", ",", "basis"}], "]"}], "[", 
    RowBox[{"expr", ",", "pair"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SSF1", "[", 
     RowBox[{"sigma_", ",", "basis_"}], "]"}], "[", 
    RowBox[{"0", ",", "AnyIndices"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SSF1", "[", 
     RowBox[{"sigma_", ",", "basis_"}], "]"}], "[", 
    RowBox[{"expr_", ",", "index_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"SSFTangent", "[", 
      RowBox[{"sigma", ",", "basis"}], "]"}], "[", 
     RowBox[{"expr", ",", "index"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"DaggerIndex", "[", "index", "]"}], "===", "index"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SSF1", "[", "__", "]"}], "[", 
    RowBox[{"expr_", ",", "_"}], "]"}], ":=", "expr"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"24d9c641-f057-402b-9d1f-6383de50f6ea"],

Cell["3) Separation of soldering form for a tbundle index :", "Text",
 CellChangeTimes->{{3.426016633314089*^9, 
  3.426016650071518*^9}},ExpressionUUID->"b0f0260f-35a3-4df7-bb7a-\
8c5bb6d4e745"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SSFTangent", "[", 
     RowBox[{"sigma_", ",", "basis_"}], "]"}], "[", 
    RowBox[{"expr_", ",", "index_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ivb", "=", 
        RowBox[{"VBundleOfIndex", "[", "index", "]"}]}], ",", 
       RowBox[{"svb", "=", 
        RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}]}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ivb", "=!=", 
         RowBox[{"TangentBundleOfManifold", "@", 
          RowBox[{"BaseOfVBundle", "@", "svb"}]}]}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"SeparateSolderingForm", "::", "invalid"}], ",", "sigma", ",", 
           RowBox[{"\"\<soldering form for index \>\"", "<>", 
            RowBox[{"ToString", "[", "index", "]"}]}]}], "]"}]}]}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"expr", "/.", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"tensor_", "?", "xTensorQ"}], "[", 
           RowBox[{"a___", ",", "index", ",", "b___"}], "]"}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"A", "=", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"UpIndexQ", "[", "index", "]"}], ",", "1", ",", 
                   RowBox[{"-", "1"}]}], "]"}], 
                 RowBox[{"DummyIn", "[", 
                  RowBox[{"svb", ",", "basis"}], "]"}]}]}], ",", "Ad"}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Ad", "=", 
               RowBox[{"DaggerIndex", "[", "A", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"HasDaggerCharacterQ", "[", "tensor", "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"SpinorTMP", "[", 
                   RowBox[{"tensor", ",", "sigma", ",", 
                    RowBox[{"index", "\[RuleDelayed]", 
                    RowBox[{"Sequence", "[", 
                    RowBox[{"Ad", ",", "A"}], "]"}]}]}], "]"}], "[", 
                  RowBox[{"a", ",", "Ad", ",", "A", ",", "b"}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"SpinorTMP", "[", 
                   RowBox[{"tensor", ",", "sigma", ",", 
                    RowBox[{"index", "\[RuleDelayed]", 
                    RowBox[{"Sequence", "[", 
                    RowBox[{"A", ",", "Ad"}], "]"}]}]}], "]"}], "[", 
                  RowBox[{"a", ",", "A", ",", "Ad", ",", "b"}], "]"}]}], 
                "\[IndentingNewLine]", "]"}], 
               RowBox[{"sigma", "[", 
                RowBox[{"index", ",", 
                 RowBox[{"-", "A"}], ",", 
                 RowBox[{"-", "Ad"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
            "]"}], "/;", 
           RowBox[{"tensor", "=!=", "sigma"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"covd_Symbol", "?", "CovDQ"}], "[", 
            RowBox[{"a___", ",", "index", ",", "b___"}], "]"}], "[", "expr1_",
            "]"}], "\[RuleDelayed]", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"A", "=", 
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"UpIndexQ", "[", "index", "]"}], ",", "1", ",", 
                  RowBox[{"-", "1"}]}], "]"}], 
                RowBox[{"DummyIn", "[", 
                 RowBox[{"svb", ",", "basis"}], "]"}]}]}], ",", "Ad"}], "}"}],
             ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Ad", "=", 
              RowBox[{"DaggerIndex", "[", "A", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CovDSpinSign", "[", 
               RowBox[{"A", ",", "Ad"}], "]"}], 
              RowBox[{
               RowBox[{"covd", "[", 
                RowBox[{"a", ",", "A", ",", "Ad", ",", "b"}], "]"}], "[", 
               "expr1", "]"}], 
              RowBox[{"sigma", "[", 
               RowBox[{"index", ",", 
                RowBox[{"-", "A"}], ",", 
                RowBox[{"-", "Ad"}]}], "]"}]}]}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "}"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b80b8243-fed8-446a-a580-3f20700480b0"],

Cell["4) Separation of soldering form for an inner index :", "Text",
 CellChangeTimes->{{3.426016657068016*^9, 
  3.426016668532909*^9}},ExpressionUUID->"eef9fb42-9d14-4bcd-8a12-\
3485c7b4c374"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SSFInner", "[", 
     RowBox[{"sigma_", ",", "basis_"}], "]"}], "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"Pair", "[", 
      RowBox[{"i1_", ",", "i2_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tbundle", "=", 
        RowBox[{"TangentBundleOfManifold", "@", 
         RowBox[{"BaseOfVBundle", "@", 
          RowBox[{"VBundleOfIndex", "[", "i1", "]"}]}]}]}], ",", 
       RowBox[{"ii1", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"HasDaggerCharacterQ", "[", "i2", "]"}], ",", "i1", ",", 
          "i2"}], "]"}]}], ",", 
       RowBox[{"ii2", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"HasDaggerCharacterQ", "[", "i2", "]"}], ",", "i2", ",", 
          "i1"}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"expr", "/.", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"spinor_", "?", "xTensorQ"}], "[", 
          RowBox[{"a___", ",", "ii1", ",", "ii2", ",", "b___"}], "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"dummy", "=", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"UpIndexQ", "[", "ii1", "]"}], ",", "1", ",", 
                 RowBox[{"-", "1"}]}], "]"}], 
               RowBox[{"DummyIn", "[", 
                RowBox[{"tbundle", ",", "basis"}], "]"}]}]}], "}"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"TensorTMP", "[", 
               RowBox[{"spinor", ",", "sigma"}], "]"}], "[", 
              RowBox[{"a", ",", "dummy", ",", "b"}], "]"}], 
             RowBox[{"sigma", "[", 
              RowBox[{
               RowBox[{"-", "dummy"}], ",", "ii1", ",", "ii2"}], "]"}]}]}], 
           "]"}], "/;", 
          RowBox[{"spinor", "=!=", "sigma"}]}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{
          RowBox[{"spinor_", "?", "xTensorQ"}], "[", 
          RowBox[{"a___", ",", "ii2", ",", "ii1", ",", "b___"}], "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"dummy", "=", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"UpIndexQ", "[", "ii1", "]"}], ",", "1", ",", 
                 RowBox[{"-", "1"}]}], "]"}], 
               RowBox[{"DummyIn", "[", 
                RowBox[{"tbundle", ",", "basis"}], "]"}]}]}], "}"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"TensorTMP", "[", 
               RowBox[{"spinor", ",", "sigma"}], "]"}], "[", 
              RowBox[{"a", ",", "dummy", ",", "b"}], "]"}], 
             RowBox[{"sigma", "[", 
              RowBox[{
               RowBox[{"-", "dummy"}], ",", "ii1", ",", "ii2"}], "]"}]}]}], 
           "]"}], "/;", 
          RowBox[{"spinor", "=!=", "sigma"}]}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"covd_Symbol", "?", "CovDQ"}], "[", 
           RowBox[{"ii1", ",", "ii2"}], "]"}], "[", "expr1_", "]"}], "\[RuleDelayed]", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"dummy", "=", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"UpIndexQ", "[", "ii1", "]"}], ",", "1", ",", 
                RowBox[{"-", "1"}]}], "]"}], 
              RowBox[{"DummyIn", "[", 
               RowBox[{"tbundle", ",", "basis"}], "]"}]}]}], "}"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"covd", "[", "dummy", "]"}], "[", "expr1", "]"}], 
            RowBox[{"sigma", "[", 
             RowBox[{
              RowBox[{"-", "dummy"}], ",", "ii1", ",", "ii2"}], "]"}]}]}], 
          "]"}]}]}], "\[IndentingNewLine]", "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.425931677020149*^9, 3.425931689422255*^9}, {
   3.426014952364006*^9, 3.426015061894841*^9}, {3.4260153959207697`*^9, 
   3.426015412325893*^9}, {3.4260154671787853`*^9, 3.426015600567912*^9}, {
   3.4260163451327543`*^9, 3.4260164175429077`*^9}, {3.4260164480062838`*^9, 
   3.4260164870260277`*^9}, {3.426016569285816*^9, 3.4260166011340637`*^9}, 
   3.426032013605527*^9, {3.426032870943244*^9, 3.426032922715405*^9}, 
   3.4260330998488007`*^9, {3.426521075492956*^9, 3.426521085087771*^9}, {
   3.426523412330542*^9, 3.426523539831594*^9}, {3.42652650784147*^9, 
   3.426526529745936*^9}, {3.426527515307581*^9, 3.426527590685525*^9}, {
   3.426527633404543*^9, 3.426527691697483*^9}, {3.426793855874159*^9, 
   3.426793859648468*^9}},ExpressionUUID->"08eaf61a-4288-40e7-92a6-\
470f366afcdf"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.6. IrreducibleDecomposition", "Subsubsection",
 CellChangeTimes->{{3.419237880662826*^9, 3.419237888230817*^9}, {
   3.423576552250349*^9, 3.4235765549809093`*^9}, 3.423637756138484*^9, {
   3.4259403003170547`*^9, 3.42594030054053*^9}, 3.426785210304873*^9, {
   3.43312856114876*^9, 3.433128567357892*^9}, {3.433128693544784*^9, 
   3.433128700726158*^9}, 
   3.4343757313196793`*^9},ExpressionUUID->"f7ea3cb9-1ede-4efd-882c-\
c372d0d2238f"],

Cell["\<\
In this section we create a command to decompose any spinor into irreducible \
parts, according to the result of e. g.  proposition 3.3.54 of vol. I of \
Penrose & Rindler.\
\>", "Text",
 CellChangeTimes->{{3.433128753949923*^9, 3.433128757597596*^9}, {
  3.433128814216898*^9, 3.433128846271949*^9}, {3.433128927943918*^9, 
  3.4331289440074053`*^9}},ExpressionUUID->"c670ca7c-3b63-46f4-9ce1-\
7d661da445e0"],

Cell["User driver :", \
"Text",ExpressionUUID->"20b47e4b-511e-4a4f-a4d7-4f4af1895d9e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "We", " ", "should", " ", "check", " ", "that", " ", "these", " ", "are", 
     " ", "indeed", " ", "spin"}], "-", "indices"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"IrreducibleDecomposition", "[", 
      RowBox[{
       RowBox[{"tensor_Symbol", "?", "xTensorQ"}], "[", "inds__", "]"}], 
      "]"}], ":=", 
     RowBox[{"IrreducibleDecomposition", "[", 
      RowBox[{
       RowBox[{"tensor", "[", "inds", "]"}], ",", 
       RowBox[{"First", "@", 
        RowBox[{"Union", "@", 
         RowBox[{"Sort", "[", 
          RowBox[{"VBundleOfIndex", "/@", 
           RowBox[{"IndexList", "@", "inds"}]}], "]"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Scalar", " ", "case"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IrreducibleDecomposition", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"tensor_Symbol", "?", "xTensorQ"}], "[", "]"}], ",", "_"}], 
      "]"}], ":=", 
     RowBox[{"tensor", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Vector", " ", "case"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IrreducibleDecomposition", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"tensor_Symbol", "?", "xTensor"}], "[", "a_", "]"}], ",", 
       "_"}], "]"}], ":=", 
     RowBox[{"tensor", "[", "a", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"General", " ", 
     RowBox[{"case", ":", " ", 
      RowBox[{
      "create", " ", "TF", " ", "tensor", " ", "and", " ", "separate", " ", 
       "VB", " ", "and", " ", "VBdagger"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IrreducibleDecomposition", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"tensor_Symbol", "?", "xTensorQ"}], "[", "inds__", "]"}], ",",
        "spinVB_"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"pos1", "=", 
          RowBox[{"SlotsOfVBundle", "[", 
           RowBox[{
            RowBox[{"tensor", "[", "inds", "]"}], ",", "spinVB"}], "]"}]}], ",", 
         RowBox[{"pos2", "=", 
          RowBox[{"SlotsOfVBundle", "[", 
           RowBox[{
            RowBox[{"tensor", "[", "inds", "]"}], ",", 
            RowBox[{"Dagger", "@", "spinVB"}]}], "]"}]}], ",", 
         RowBox[{"epsilon", "=", 
          RowBox[{"First", "@", 
           RowBox[{"MetricsOfVBundle", "@", "spinVB"}]}]}], ",", 
         RowBox[{"tft", "=", 
          RowBox[{"SymbolJoin", "[", 
           RowBox[{"\"\<TF\>\"", ",", "tensor"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"xTensorQ", "[", "tft", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"DefTensor", "[", 
           RowBox[{
            RowBox[{"tft", "[", 
             RowBox[{
              RowBox[{"LI", "[", "\"\<TF\>\"", "]"}], ",", 
              RowBox[{"AnyIndices", "@", "spinVB"}], ",", 
              RowBox[{"AnyIndices", "@", 
               RowBox[{"Dagger", "@", "spinVB"}]}]}], "]"}], ",", 
            RowBox[{"BaseOfVBundle", "[", "spinVB", "]"}], ",", 
            RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
            RowBox[{"Master", "\[Rule]", "tensor"}], ",", 
            RowBox[{"ProtectNewSymbol", "\[Rule]", "False"}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", 
          RowBox[{"tft", "[", "inds1__", "]"}], "]"}], "^:=", 
         RowBox[{"JoinSGS", "[", 
          RowBox[{
           RowBox[{"Symmetric", "[", 
            RowBox[{"SlotsOfVBundle", "[", 
             RowBox[{
              RowBox[{"tft", "[", "inds1", " ", "]"}], ",", "spinVB"}], "]"}],
             "]"}], ",", 
           RowBox[{"Symmetric", "[", 
            RowBox[{"SlotsOfVBundle", "[", 
             RowBox[{
              RowBox[{"tft", "[", "inds1", "]"}], ",", 
              RowBox[{"Dagger", "@", "spinVB"}]}], "]"}], "]"}]}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tft", "[", 
          RowBox[{"___", ",", "a_", ",", "___", ",", 
           RowBox[{"-", "a_"}], ",", "___"}], "]"}], ":=", "0"}], ";", " ", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tft", "[", 
          RowBox[{"___", ",", 
           RowBox[{"-", "a_"}], ",", "___", ",", "a_", ",", "___"}], "]"}], ":=",
          "0"}], ";", 
        RowBox[{"Apply", "[", 
         RowBox[{"Plus", ",", 
          RowBox[{
           RowBox[{"DecoBuild", "[", 
            RowBox[{"tft", ",", 
             RowBox[{"{", "inds", "}"}], ",", "epsilon", ",", 
             RowBox[{"Dagger", "@", "epsilon"}]}], "]"}], "/@", 
           RowBox[{"DecoOuter", "[", 
            RowBox[{"pos1", ",", "pos2", ",", 
             RowBox[{"Length", "[", 
              RowBox[{"{", "inds", "}"}], "]"}]}], "]"}]}]}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"51db484e-b980-44d9-9268-0f0050eb1497"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfVBundle", "[", 
    RowBox[{"list_", ",", "vbundle_"}], "]"}], ":=", 
   RowBox[{"Flatten", "@", 
    RowBox[{"Position", "[", 
     RowBox[{"list", ",", 
      RowBox[{"_", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"AIndexQ", "[", 
          RowBox[{"#", ",", "vbundle"}], "]"}], "&"}], ")"}]}], ",", 
      RowBox[{"{", "1", "}"}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.433588519494391*^9, 3.433588625663176*^9}, {
  3.433588704784023*^9, 
  3.433588710444761*^9}},ExpressionUUID->"ab4e1432-efb5-4271-a83d-\
6e582b846d37"],

Cell["Internal code :", \
"Text",ExpressionUUID->"26ef7243-cec0-479a-9112-569fa9c2ea67"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Given", " ", "a", " ", "list", " ", "of", " ", "slots"}], ",", 
    " ", 
    RowBox[{"return", " ", "all", " ", "possible", " ", "pairs"}], ",", " ", 
    "sorted"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DecoPairs", "[", "list_", "]"}], ":=", 
     RowBox[{"Union", "@", 
      RowBox[{"Map", "[", 
       RowBox[{"Sort", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Partition", "[", 
           RowBox[{"#", ",", "2"}], "]"}], "&"}], "/@", 
         RowBox[{"Permutations", "[", "list", "]"}]}], ",", "2"}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Given", " ", "a", " ", "list", " ", "of", " ", "slots"}], ",", 
     " ", 
     RowBox[{
     "return", " ", "all", " ", "possibe", " ", "groups", " ", "of", " ", "2",
       "n", " ", "slots"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecoGroups", "[", "list_", "]"}], ":=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"DecoPairs", "/@", 
          RowBox[{"Subsets", "[", 
           RowBox[{"list", ",", 
            RowBox[{"{", "n", "}"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "0", ",", 
           RowBox[{"Length", "@", "list"}], ",", "2"}], "}"}]}], "]"}], ",", 
       "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Given", " ", "spin", " ", "slots", " ", "and", " ", "spindag", " ", 
      "slots"}], ",", " ", 
     RowBox[{
     "return", " ", "all", " ", "combinations", " ", "and", " ", "the", " ", 
      "complementary", " ", "slots"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecoOuter", "[", 
      RowBox[{"list1_", ",", "list2_", ",", "length_"}], "]"}], ":=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{
         RowBox[{"DecoArrange", "[", "length", "]"}], ",", 
         RowBox[{"DecoGroups", "[", "list1", "]"}], ",", 
         RowBox[{"DecoGroups", "[", "list2", "]"}], ",", "1"}], "]"}], ",", 
       "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"DecoArrange", "[", "n_", "]"}], "[", 
      RowBox[{"list1_", ",", "list2_"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"list1", ",", "list2", ",", 
       RowBox[{"Complement", "[", 
        RowBox[{
         RowBox[{"Range", "[", "n", "]"}], ",", 
         RowBox[{"Flatten", "@", "list1"}], ",", 
         RowBox[{"Flatten", "@", "list2"}]}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Construct", " ", "actual", " ", "TFT", " ", "tensor", " ", "and", " ", 
     "product", " ", "of", " ", "epsilons"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"DecoBuild", "[", 
       RowBox[{"tft_", ",", "inds_", ",", "eps_", ",", "epsdag_"}], "]"}], "[", 
      RowBox[{"{", 
       RowBox[{"list1_", ",", "list2_", ",", "list_"}], "}"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"tft", "[", 
       RowBox[{
        RowBox[{"LI", "@", 
         RowBox[{"Join", "[", 
          RowBox[{"list1", ",", "list2"}], "]"}]}], ",", 
        RowBox[{"Sequence", "@@", 
         RowBox[{"(", 
          RowBox[{"inds", "[", 
           RowBox[{"[", "list", "]"}], "]"}], ")"}]}]}], "]"}], 
      RowBox[{"Times", "@@", 
       RowBox[{"Apply", "[", 
        RowBox[{"eps", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"inds", ",", "#"}], "]"}], "&"}], "/@", "list1"}], ",", 
         "1"}], "]"}]}], 
      RowBox[{"Times", "@@", 
       RowBox[{"Apply", "[", 
        RowBox[{"epsdag", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"inds", ",", "#"}], "]"}], "&"}], "/@", "list2"}], ",", 
         "1"}], "]"}]}]}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.43358659205539*^9, {3.433588327120115*^9, 3.433588328695642*^9}, {
   3.433588899858676*^9, 3.433588907084895*^9}, {3.433589768985762*^9, 
   3.433589772447364*^9}, 3.433668442686132*^9, 3.434115315996934*^9, 
   3.4341154756835318`*^9},ExpressionUUID->"7c0d4fdc-9282-4a1c-9092-\
3648c73d7230"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. Spin derivatives and curvature spinors", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"862843bd-eb8b-4df9-9119-1c7e06b44958"],

Cell[CellGroupData[{

Cell["4.1. SpinCovDs", "Subsubsection",
 CellChangeTimes->{{3.423579149543933*^9, 
  3.423579151403883*^9}},ExpressionUUID->"e56d3725-29fb-4699-927c-\
814375394096"],

Cell["\<\
This function defines a spin derivative associated to a previously defined \
spin-structure. That means that this derivative vanish on its soldering form, \
but not necessarily on its epsilon spinor. Here we define both the action of \
the derivative on the tangent bundle and on the inner bundle of the \
spin-structure.

There are several important options affecting the \"tangent\" derivative: \
Torsion, Curvature, FromMetric and ExtendedFrom. Note that FromMetric could \
refer to any metric on the base manifold, not necessarily the metric of the \
spin-structure, but currently if it is not the sps-metric (which is always \
the first-metric of the base manifold) then we throw an error. The order of \
priorities is the following: 
\t- If ExtendedFrom is not Null (call it cde) then the properties on the base \
are those of cde and Torsion / Curvature / FromMetric have no effect.
\t- If cde is the Levi-Civita connection of the sps-metric, then we are \
defining a metric-compatible connection. Note that we do not impose here \
compatibility with the epsilon spinor of the spin-structure.
\t- If cde is not the Levi-Civita connection of the sps-metric then the only \
accepted possibility is that cde has no associated metric.
\t- If ExtendedFrom is Null then we create a fully new derivative:
\t- If FromMetric is not Null then the new derivative will be compatible with \
that metric, and we check again that this metric is that of the \
spin-structure. If not, the metric association is simply removed.
\t- If FromMetric is Null then the new derivative is not metric compatible.\
\>", "Text",
 CellChangeTimes->{{3.408289901505513*^9, 3.40828991266418*^9}, {
  3.40829002205727*^9, 3.408290030785337*^9}, {3.408290079487176*^9, 
  3.4082901077581377`*^9}, {3.408290208252686*^9, 3.408290215812319*^9}, {
  3.40829097108412*^9, 3.408291040209653*^9}, {3.408291092606104*^9, 
  3.4082911389935427`*^9}, {3.419238233475404*^9, 3.419238237927354*^9}, {
  3.41923834566492*^9, 3.419238368840989*^9}, {3.426016932010584*^9, 
  3.426016937688305*^9}},ExpressionUUID->"f1481bb3-e493-4941-9af5-\
79a5f28344c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DefCovD", "]"}]], "Input",
 CellChangeTimes->{{3.419241752797497*^9, 3.419241759511929*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"6c06a8d3-09b8-45fc-9aa6-051de7cc8c35"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SymbolOfCovD", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\";\"\>", ",", "\<\"\[EmptyDownTriangle]\"\>"}], "}"}]}], ",", 
   RowBox[{"Torsion", "\[Rule]", "False"}], ",", 
   RowBox[{"Curvature", "\[Rule]", "True"}], ",", 
   RowBox[{"FromMetric", "\[Rule]", "Null"}], ",", 
   RowBox[{"CurvatureRelations", "\[Rule]", "True"}], ",", 
   RowBox[{"ExtendedFrom", "\[Rule]", "Null"}], ",", 
   RowBox[{"OtherDependencies", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"OrthogonalTo", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"ProjectedWith", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"WeightedWithBasis", "\[Rule]", "Null"}], ",", 
   RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
   
   RowBox[{"Master", "\[Rule]", "Null"}], ",", 
   RowBox[{"DefInfo", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"covariant derivative\"\>", ",", "\<\"\"\>"}], "}"}]}]}], 
  "}"}]], "Output",
 CellLabel->
  "Out[98]=",ExpressionUUID->"0a49f97e-21b6-43fc-b5ef-4578bd91accc"]
}, Open  ]],

Cell["\<\
Note that $SpinCovDs is private. We do not need it to be public. It is only \
used in Decomposition and UndefSpinCovD.\
\>", "Text",
 CellChangeTimes->{{3.427196689092805*^9, 3.427196712721828*^9}, {
  3.427196789517589*^9, 3.4271967960543747`*^9}, {3.427196890658342*^9, 
  3.427196895337908*^9}},ExpressionUUID->"1b1a1c1a-e4db-471e-b6f3-\
f5d0b9069cec"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefSpinCovD", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SymbolOfCovD", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"Torsion", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FromMetric", "\[Rule]", "Null"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ExtendedFrom", "\[Rule]", "Null"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"ProtectNewSymbol", "\[Rule]", "$ProtectNewSymbols"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Master", "\[Rule]", "Null"}], ",", "\[IndentingNewLine]", 
     RowBox[{"DefInfo", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<spin covariant derivative\>\"", ",", "\"\<\>\""}], 
       "}"}]}]}], "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$SpinCovDs", ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Join", ",", 
     RowBox[{"SpinCovDsOfSolderingForm", "/@", "$SolderingForms"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefSpinCovD", "[", 
    RowBox[{
     RowBox[{"covd_", "[", 
      RowBox[{"-", "a_"}], "]"}], ",", "sigma_", ",", "symbols_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "metric", ",", "ef", ",", "newsymbols", ",", "a1", ",", "A1", ",", 
        "A1d", ",", "B1", ",", "B1d"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", "a1", "}"}], "=", 
        RowBox[{"GetIndicesOfVBundle", "[", 
         RowBox[{
          RowBox[{"VBundleOfIndex", "[", "a", "]"}], ",", "1"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"A1", ",", "B1"}], "}"}], "=", 
        RowBox[{"GetIndicesOfVBundle", "[", 
         RowBox[{
          RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}], ",", "2"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"A1d", ",", "B1d"}], "}"}], "=", 
        RowBox[{"DaggerIndex", "/@", 
         RowBox[{"{", 
          RowBox[{"A1", ",", "B1"}], "}"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"metric", ",", "ef"}], "}"}], "=", 
        RowBox[{"OptionValue", "[", 
         RowBox[{"{", 
          RowBox[{"FromMetric", ",", "ExtendedFrom"}], "}"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"If", " ", "extended"}], ",", " ", 
         RowBox[{
         "the", " ", "properties", " ", "of", " ", "covd", " ", "are", " ", 
          "those", " ", "of", " ", "ef", " ", 
          RowBox[{"(", 
           RowBox[{"forget", " ", "options"}], ")"}]}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ef", "=!=", "Null"}], ",", 
         RowBox[{"metric", "=", 
          RowBox[{"MetricOfCovD", "[", "ef", "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Check", " ", "metric", " ", "argument"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"metric", "=!=", "Null"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BaseOfVBundle", "@", 
              RowBox[{"VBundleOfMetric", "[", "metric", "]"}]}], "=!=", 
             RowBox[{"BaseOfVBundle", "@", 
              RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}]}], ",", 
            
            RowBox[{"Throw", "@", 
             RowBox[{"Message", "[", 
              RowBox[{
               RowBox[{"DefSpinCovD", "::", "error"}], 
               ",", "\"\<Incompatible vbundles of metric and soldering \
form.\>\""}], "]"}]}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Association", " ", "to", " ", "a", " ", "frozen", " ", "metric", " ",
           "is", " ", "removed", " ", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
            "xAct`xTensor`Private`FrozenMetricQ", "[", "metric", "]"}], ",", 
            RowBox[{
             RowBox[{"Message", "[", 
              RowBox[{
               RowBox[{"DefSpinCovD", "::", "error"}], 
               ",", "\"\<A frozen metric cannot be used.\>\""}], "]"}], ";", 
             RowBox[{"metric", "=", "Null"}]}]}], "]"}]}], "*)"}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Define", " ", 
         RowBox[{"derivative", ".", " ", "How"}], " ", "do", " ", "we", " ", 
         "pass", " ", "the", " ", 
         RowBox[{"options", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"DefCovD", "[", 
        RowBox[{
         RowBox[{"covd", "[", 
          RowBox[{"-", "a"}], "]"}], ",", 
         RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}], ",", 
         "symbols", ",", 
         RowBox[{"FilterRules", "[", 
          RowBox[{
           RowBox[{"{", "options", "}"}], ",", 
           RowBox[{"Options", "[", "DefCovD", "]"}]}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SpinCovDQ", "[", "covd", "]"}], "^=", "True"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Relations", " ", "between", " ", "the", " ", "covariant", " ", 
         "derivative", " ", "and", " ", "the", " ", "soldering", " ", 
         "form"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SolderingFormOfSpinCovD", "[", "covd", "]"}], "^=", 
        "sigma"}], ";", "\[IndentingNewLine]", 
       RowBox[{"xUpAppendTo", "[", 
        RowBox[{
         RowBox[{"SpinCovDsOfSolderingForm", "[", "sigma", "]"}], ",", 
         "covd"}], "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"If", " ", "ef"}], "===", 
         RowBox[{
         "Null", " ", "then", " ", "use", " ", "the", " ", "trick", " ", "of",
           " ", "extending", " ", "from", " ", "covd"}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ef", "===", "Null"}], ",", 
         RowBox[{"ef", "=", "covd"}]}], "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Construct", " ", "associated", " ", "curvature", " ", "spinors"}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"ConstructRTSpinors", "[", 
        RowBox[{
        "covd", ",", "ef", ",", "sigma", ",", "metric", ",", "options"}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Define", " ", "associated", " ", "box", " ", "operators"}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"DefBox", "[", "covd", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Compatibility", " ", "with", " ", "the", " ", "spin", " ", 
         "structure"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"metric", "===", "Null"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"covd", "[", "__", "]"}], "[", 
            RowBox[{"sigma", "[", 
             RowBox[{"b_Symbol", ",", 
              RowBox[{"-", "F_"}], ",", 
              RowBox[{"-", "G_"}]}], "]"}], "]"}], ":=", "0"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"covd", "[", "__", "]"}], "[", 
            RowBox[{"sigma", "[", 
             RowBox[{
              RowBox[{"-", "b_"}], ",", "F_Symbol", ",", "G_Symbol"}], "]"}], 
            "]"}], ":=", "0"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"covd", "[", "__", "]"}], "[", 
           RowBox[{"sigma", "[", 
            RowBox[{"b_", ",", "F_", ",", "G_"}], "]"}], "]"}], ":=", "0"}]}],
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Definitions", " ", "as", " ", "2"}], "-", 
         RowBox[{"index", " ", "derivative"}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"xAct`xTensor`Private`MakeLinearDerivative", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"covd", "[", 
            RowBox[{"F_", ",", "G_"}], "]"}], ",", 
           RowBox[{"covd", "[", 
            RowBox[{"F", ",", "G"}], "]"}]}], "}"}], ",", "True"}], "]"}], ";",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Relations", " ", "between", " ", "2"}], "-", 
         RowBox[{
         "index", " ", "derivative", " ", "and", " ", "spacetime", " ", 
          "derivative"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SpinorToTensor", "[", 
         RowBox[{"covd", ",", "sigma"}], "]"}], ":=", 
        RowBox[{"MakeRule", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"covd", "[", 
              RowBox[{"A1", ",", "A1d"}], "]"}], "@", "expr_"}], ",", 
            RowBox[{
             RowBox[{"sigma", "[", 
              RowBox[{"a1", ",", "A1", ",", "A1d"}], "]"}], 
             RowBox[{
              RowBox[{"covd", "[", 
               RowBox[{"-", "a1"}], "]"}], "@", "expr"}]}]}], "}"}], ",", 
          RowBox[{"UseSymmetries", "\[Rule]", "False"}], ",", 
          RowBox[{"Evaluate", "\[Rule]", "True"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"TensorToSpinor", "[", 
         RowBox[{"covd", ",", "sigma"}], "]"}], ":=", 
        RowBox[{"MakeRule", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"covd", "[", "a1", "]"}], "@", "expr_"}], ",", 
            RowBox[{
             RowBox[{"sigma", "[", 
              RowBox[{"a1", ",", "A1", ",", "A1d"}], "]"}], 
             RowBox[{
              RowBox[{"covd", "[", 
               RowBox[{
                RowBox[{"-", "A1"}], ",", 
                RowBox[{"-", "A1d"}]}], "]"}], "@", "expr"}]}]}], "}"}], ",", 
          
          RowBox[{"UseSymmetries", "\[Rule]", "False"}], ",", 
          RowBox[{"Evaluate", "\[Rule]", "True"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Behaviour", " ", "under", " ", "complex", " ", 
         RowBox[{"conjugation", ":", " ", "\"\<Hermitian\>\""}]}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"xAct`xTensor`Private`DaggerCovD", "[", 
         RowBox[{"covd", "[", "inds__", "]"}], "]"}], "^:=", 
        RowBox[{"Apply", "[", 
         RowBox[{"covd", ",", 
          RowBox[{"TransposeDagger", "@", 
           RowBox[{"DaggerIndex", "@", 
            RowBox[{"IndexList", "[", "inds", "]"}]}]}]}], "]"}]}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefSpinCovD", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DefSpinCovD", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[99]:=",ExpressionUUID->"5ba8eb81-77c9-4820-9e26-c76da5615f5f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UndefSpinCovD", "[", "covd_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"$SpinCovDs", ",", "covd"}], "]"}], ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"SpinCovDs", "::", "unknown"}], ",", "\"\<spin covd\>\"", ",",
           "covd"}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Undef", "/@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"VisitorsOf", "/@", 
        RowBox[{"ServantsOf", "[", "covd", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"UndefCovD", "[", "covd", "]"}], ";"}], "\[IndentingNewLine]", 
    ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"UndefSpinCovD", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DefSpinCovD", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.424436771248075*^9, 3.4244368941200542`*^9}, {
  3.427232187414456*^9, 
  3.42723220993192*^9}},ExpressionUUID->"e22ca9cd-47aa-40bb-a875-\
ffaec4deb2ff"],

Cell["Default for the private function SpinCovDQ :", \
"Text",ExpressionUUID->"4f39abfe-0abb-4b1b-8ef2-6dd2546190fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SpinCovDQ", "[", "covd_", "]"}], ":=", "False"}], ";"}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"94bb9bf0-6a1c-4110-9d87-4263026add3c"],

Cell["\<\
Multi-index covariant derivatives are still first - order derivatives in this \
context :\
\>", "Text",ExpressionUUID->"86903eda-69d4-49a2-a19f-7c714fd084c3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "FirstDerQ", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FirstDerQ", "[", 
    RowBox[{
     RowBox[{"_Symbol", "?", "SpinCovDQ"}], "[", "__", "]"}], "]"}], ":=", 
   "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "FirstDerQ", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"ad4e8da4-8e8c-4b60-a90a-91175ff50238"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.2. Curvature spinors", \
"Subsubsection",ExpressionUUID->"a679c894-02cb-4331-afa0-068e6dc50d1b"],

Cell["\<\
Given a covariant derivative compatible with a spin structure, we need to \
construct the associated curvature and torsion spinors. Note that when the \
derivative is an extension of the Levi-Civita derivative of the metric of the \
spin-structure, then the curvature spinors are all uniquely defined by the \
base Levi-Civita connection, and the only freedom left in the extended \
derivative is in the AChristoffel tensor.\
\>", "Text",
 CellChangeTimes->{{3.408451367199173*^9, 
  3.408451368386755*^9}},ExpressionUUID->"213e176b-af31-40c3-b61e-\
817fb54783a7"],

Cell["\<\
Output form for the curvature spinors (we do not mark them with the \
spin-structure) :\
\>", "Text",
 CellChangeTimes->{{3.408360808473822*^9, 3.408360814745019*^9}, {
  3.4083608485900908`*^9, 
  3.408360857742281*^9}},ExpressionUUID->"720431da-815f-4651-a650-\
02c175adc402"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GiveOutputString", "[", 
    RowBox[{"Chi", ",", "covd_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\[CapitalChi]\>\"", ",", "\"\<[\>\"", ",", 
     RowBox[{
      RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", "\"\<]\>\""}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GiveOutputString", "[", 
    RowBox[{"Phi", ",", "covd_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\[CapitalPhi]\>\"", ",", "\"\<[\>\"", ",", 
     RowBox[{
      RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", "\"\<]\>\""}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GiveOutputString", "[", 
    RowBox[{"Psi", ",", "covd_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\[CapitalPsi]\>\"", ",", "\"\<[\>\"", ",", 
     RowBox[{
      RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", "\"\<]\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GiveOutputString", "[", 
    RowBox[{"Lambda", ",", "covd_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\[CapitalLambda]\>\"", ",", "\"\<[\>\"", ",", 
     RowBox[{
      RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", "\"\<]\>\""}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.408346639578314*^9, 3.408346697816025*^9}, {
  3.419242399147731*^9, 
  3.419242412801012*^9}},ExpressionUUID->"08fa7f21-d215-4046-879b-\
db67e7b454d1"],

Cell["\<\
Here we should place the output form for the torsion spinors :\
\>", "Text",
 CellChangeTimes->{{3.408360879842235*^9, 3.4083608904456472`*^9}, {
  3.4084268407521772`*^9, 
  3.408426849242016*^9}},ExpressionUUID->"02200397-c9ba-4bf6-aab6-\
a9d0f5449529"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GiveOutputString", "[", 
    RowBox[{"Omega", ",", "covd_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\[CapitalOmega]\>\"", ",", "\"\<[\>\"", ",", 
     RowBox[{
      RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", "\"\<]\>\""}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.434608399370132*^9, 
  3.434608407700088*^9}},ExpressionUUID->"458a8913-6c5d-47a7-a508-\
1b2fba09d8f8"],

Cell["Symbols of the curvature spinors and the torsion.", "Text",
 CellChangeTimes->{{3.4346084294070044`*^9, 
  3.434608437684389*^9}},ExpressionUUID->"2e641c87-b292-45c5-89e4-\
6e5b633033e8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Chi", "[", 
    RowBox[{"covd_Symbol", "?", "CovDQ"}], "]"}], ":=", 
   RowBox[{"GiveSymbol", "[", 
    RowBox[{"Chi", ",", "covd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Phi", "[", 
    RowBox[{"covd_Symbol", "?", "CovDQ"}], "]"}], ":=", 
   RowBox[{"GiveSymbol", "[", 
    RowBox[{"Phi", ",", "covd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Psi", "[", 
    RowBox[{"covd_Symbol", "?", "CovDQ"}], "]"}], ":=", 
   RowBox[{"GiveSymbol", "[", 
    RowBox[{"Psi", ",", "covd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Lambda", "[", 
    RowBox[{"covd_Symbol", "?", "CovDQ"}], "]"}], ":=", 
   RowBox[{"GiveSymbol", "[", 
    RowBox[{"Lambda", ",", "covd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Omega", "[", 
    RowBox[{"covd_Symbol", "?", "CovDQ"}], "]"}], ":=", 
   RowBox[{"GiveSymbol", "[", 
    RowBox[{"Omega", ",", "covd"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.408361237796232*^9, 3.408361257518836*^9}, {
  3.408361292460904*^9, 3.408361338780182*^9}, {3.434608468541739*^9, 
  3.434608497206355*^9}},ExpressionUUID->"fbd0a200-4a67-4deb-84c1-\
516041238b3a"],

Cell["\<\
Message on the decomposition rules of a tensor  (now deactivated);\
\>", "Text",
 CellChangeTimes->{{3.419242427869589*^9, 3.419242438287735*^9}, {
  3.424434915507029*^9, 
  3.424434920445548*^9}},ExpressionUUID->"f1c5539d-76ef-46a4-803e-\
bd7a10d7f915"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"compumessage", "[", 
    RowBox[{"covd_", ",", "tensor_"}], "]"}], ":=", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<** Computing \>\"", ",", "tensor", 
     ",", "\"\< Decomposition rules for \>\"", ",", "covd"}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"1dd6c162-238c-4f75-9339-f160858e1220"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"compumessage", "[", 
    RowBox[{"covd_", ",", "tensor_"}], "]"}], ":=", "Null"}], ";"}]], "Input",
 
 InitializationCell->True,
 CellChangeTimes->{{3.408361049289468*^9, 3.408361073738955*^9}, {
  3.423576808639496*^9, 3.423576829221127*^9}, {3.423578736245071*^9, 
  3.423578739933825*^9}, {3.4244348965672617`*^9, 
  3.42443491095833*^9}},ExpressionUUID->"1d23dcf9-2579-484b-a9f6-\
0afb64061b0e"],

Cell["\<\
Default value for those global variables fixing our conventions for the \
definition of the curvature spinors and the torsion.\
\>", "Text",
 CellChangeTimes->{{3.426961774671636*^9, 3.426961803820788*^9}, {
  3.426961897230732*^9, 3.426961905805224*^9}, {3.434608738664937*^9, 
  3.43460874171815*^9}},ExpressionUUID->"4c740356-976e-4966-876e-\
002984cc2747"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xAct`xTensor`Private`DefSign", "[", 
   RowBox[{
   "$ChiSign", ",", "\"\<\!\(\*SubscriptBox[\(s\), \(\[CapitalChi]\)]\)\>\"", 
    ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xTensor`Private`DefSign", "[", 
   RowBox[{
   "$PhiSign", ",", "\"\<\!\(\*SubscriptBox[\(s\), \(\[CapitalPhi]\)]\)\>\"", 
    ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xTensor`Private`DefSign", "[", 
   RowBox[{
   "$PsiSign", ",", "\"\<\!\(\*SubscriptBox[\(s\), \(\[CapitalPsi]\)]\)\>\"", 
    ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xTensor`Private`DefSign", "[", 
   RowBox[{
   "$LambdaSign", 
    ",", "\"\<\!\(\*SubscriptBox[\(s\), \(\[CapitalLambda]\)]\)\>\"", ",", 
    "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xTensor`Private`DefSign", "[", 
   RowBox[{
   "$OmegaSign", 
    ",", "\"\<\!\(\*SubscriptBox[\(s\), \(\[CapitalOmega]\)]\)\>\"", ",", 
    "1"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4941424549921083`*^9, 
  3.494142622949877*^9}},ExpressionUUID->"8e158bd1-277b-468f-a617-\
2588123de71b"],

Cell["\<\
This is an important private function: covd is the derivative being defined; \
ef is the derivative we are extending from (when Null it is converted into \
covd); metric is the metric associated to covd, and currently it is either \
the sps-metric or Null.

Torsion tensors are created if *and only if* the derivative has torsion.\
\>", "Text",ExpressionUUID->"086cc252-75ea-4ace-ab03-91dc0a2c7b9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConstructRTSpinors", "[", 
    RowBox[{"covd_", ",", "ef_", ",", "sigma_", ",", "metric_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"RiemannName", "=", 
        RowBox[{"AddSpinorPrefix", "[", 
         RowBox[{
          RowBox[{"Riemann", "[", "ef", "]"}], ",", 
          RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"RicciName", "=", 
        RowBox[{"AddSpinorPrefix", "[", 
         RowBox[{
          RowBox[{"Ricci", "[", "ef", "]"}], ",", 
          RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"WeylName", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"metric", "=!=", "Null"}], ",", 
          RowBox[{"AddSpinorPrefix", "[", 
           RowBox[{
            RowBox[{"Weyl", "[", "ef", "]"}], ",", 
            RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "]"}]}], "]"}]}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"TFRicciName", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"metric", "=!=", "Null"}], ",", 
          RowBox[{"AddSpinorPrefix", "[", 
           RowBox[{
            RowBox[{"TFRicci", "[", "ef", "]"}], ",", 
            RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "]"}]}], "]"}]}], ",",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"TorsionName", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"TorsionQ", "[", "covd", "]"}], ",", 
          RowBox[{"AddSpinorPrefix", "[", 
           RowBox[{
            RowBox[{"Torsion", "[", "ef", "]"}], ",", 
            RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "]"}]}], "]"}]}], ",",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"FRiemannName", "=", 
        RowBox[{"AddSpinorPrefix", "[", 
         RowBox[{
          RowBox[{"FRiemann", "[", "covd", "]"}], ",", 
          RowBox[{"SpinorPrefix", "[", "sigma", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ChiName", "=", 
        RowBox[{"Chi", "[", "covd", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PhiName", "=", 
        RowBox[{"Phi", "[", "covd", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PsiName", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"metric", "=!=", "Null"}], ",", 
          RowBox[{"Psi", "[", "covd", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LambdaName", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"metric", "=!=", "Null"}], ",", 
          RowBox[{"Lambda", "[", "covd", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"OmegaName", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"TorsionQ", "[", "covd", "]"}], ",", 
          RowBox[{"Omega", "[", "covd", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"vbundle", "=", 
        RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"vbundledag", "=", 
        RowBox[{"Dagger", "@", 
         RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"base", "=", 
        RowBox[{"BaseOfVBundle", "@", 
         RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"tbundle", "=", 
        RowBox[{"TangentBundleOfSolderingForm", "[", "sigma", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"eps", "=", 
        RowBox[{"SpinMetricOfSolderingForm", "[", "sigma", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"epsdag", "=", 
        RowBox[{"Dagger", "@", 
         RowBox[{"SpinMetricOfSolderingForm", "[", "sigma", "]"}]}]}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"LeviCivitaQ", "=", 
        RowBox[{
         RowBox[{"metric", "=!=", "Null"}], "&&", 
         RowBox[{"!", 
          RowBox[{"TorsionQ", "[", "covd", "]"}]}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LeviCivitaTorsionQ", "=", 
        RowBox[{
         RowBox[{"metric", "=!=", "Null"}], "&&", 
         RowBox[{"TorsionQ", "[", "covd", "]"}]}]}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "A", ",", "B", ",", "F", ",", "G", ",", "Ad", ",", "Bd", ",", "Fd", ",",
          "Gd", ",", "a", ",", "b", ",", "c", ",", "d", ",", "PsiNamedag", ",",
          "FRiemannNamedag", ",", "ChiNamedag", ",", "PhiNamedag", ",", 
         "OmegaNamedag", ",", "MakeRuleOptions"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"A", ",", "B", ",", "F", ",", "G"}], "}"}], "=", 
         RowBox[{"GetIndicesOfVBundle", "[", 
          RowBox[{"vbundle", ",", "4", ",", 
           RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Ad", ",", "Bd", ",", "Fd", ",", "Gd"}], "}"}], "=", 
         RowBox[{"DaggerIndex", "/@", 
          RowBox[{"{", 
           RowBox[{"A", ",", "B", ",", "F", ",", "G"}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
         RowBox[{"GetIndicesOfVBundle", "[", 
          RowBox[{"tbundle", ",", "4", ",", 
           RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Change", " ", "temporarily", " ", "default", " ", "options", " ", 
          "for", " ", "MakeRule"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"MakeRuleOptions", "=", 
         RowBox[{"Options", "[", "MakeRule", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"MakeRule", ",", 
          RowBox[{"UseSymmetries", "\[Rule]", "False"}], ",", 
          RowBox[{"ContractMetrics", "\[Rule]", "False"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Definition", " ", "of", " ", "curvature", " ", "spinors", " ", 
          RowBox[{"(", 
           RowBox[{
           "we", " ", "check", " ", "that", " ", "the", " ", "original", " ", 
            "inner", " ", "curvature", " ", "is", " ", "different", " ", 
            "from", " ", "zero"}], " "}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"FRiemann", "[", "covd", "]"}], "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}], ",", 
             RowBox[{"-", "F"}], ",", 
             RowBox[{"-", "G"}]}], "]"}], "=!=", "0"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"DefSpinorOfTensor", "[", 
            RowBox[{
             RowBox[{"FRiemannName", "[", 
              RowBox[{
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "Ad"}], ",", 
               RowBox[{"-", "B"}], ",", 
               RowBox[{"-", "Bd"}], ",", 
               RowBox[{"-", "F"}], ",", 
               RowBox[{"-", "G"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"FRiemann", "[", "covd", "]"}], "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "b"}], ",", 
               RowBox[{"-", "F"}], ",", 
               RowBox[{"-", "G"}]}], "]"}], ",", "sigma", ",", 
             RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", "options"}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"FRiemannNamedag", "=", 
            RowBox[{"Dagger", "[", "FRiemannName", "]"}]}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"DefTensor", "[", 
            RowBox[{
             RowBox[{"ChiName", "[", 
              RowBox[{
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "B"}], ",", 
               RowBox[{"-", "F"}], ",", 
               RowBox[{"-", "G"}]}], "]"}], ",", "base", ",", 
             RowBox[{"Which", "[", 
              RowBox[{"LeviCivitaTorsionQ", ",", 
               RowBox[{"StrongGenSet", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"1", ",", "3"}], "}"}], ",", 
                 RowBox[{"GenSet", "[", 
                  RowBox[{
                   RowBox[{"xAct`xPerm`Cycles", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
                   RowBox[{"xAct`xPerm`Cycles", "[", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]}], "]"}], ",",
                "LeviCivitaQ", ",", 
               RowBox[{"StrongGenSet", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"1", ",", "3"}], "}"}], ",", 
                 RowBox[{"GenSet", "[", 
                  RowBox[{
                   RowBox[{"xAct`xPerm`Cycles", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
                   RowBox[{"xAct`xPerm`Cycles", "[", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
                   RowBox[{"xAct`xPerm`Cycles", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", "3"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}],
                ",", "True", ",", 
               RowBox[{"Symmetric", "[", 
                RowBox[{"{", 
                 RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}], ",", 
             RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
             RowBox[{"PrintAs", "\[RuleDelayed]", 
              RowBox[{"GiveOutputString", "[", 
               RowBox[{"Chi", ",", "covd"}], "]"}]}], ",", 
             RowBox[{"Master", "\[Rule]", "covd"}], ",", 
             RowBox[{"FilterRules", "[", 
              RowBox[{
               RowBox[{"{", "options", "}"}], ",", 
               RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
             RowBox[{"DefInfo", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<curvature spinor\>\"", ",", "\"\<\>\""}], 
               "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"ChiNamedag", ":=", 
            RowBox[{"Dagger", "[", "ChiName", "]"}]}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"DefTensor", "[", 
            RowBox[{
             RowBox[{"PhiName", "[", 
              RowBox[{
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "B"}], ",", 
               RowBox[{"-", "Fd"}], ",", 
               RowBox[{"-", "Gd"}]}], "]"}], ",", "base", ",", 
             RowBox[{"If", "[", 
              RowBox[{"LeviCivitaQ", ",", 
               RowBox[{"StrongGenSet", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"1", ",", "3"}], "}"}], ",", 
                 RowBox[{"GenSet", "[", 
                  RowBox[{
                   RowBox[{"xAct`xPerm`Cycles", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
                   RowBox[{"xAct`xPerm`Cycles", "[", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"Symmetric", "[", 
                RowBox[{"{", 
                 RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{"LeviCivitaQ", ",", 
               RowBox[{"Dagger", "\[Rule]", "Hermitian"}], ",", 
               RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}], ",", 
             RowBox[{"PrintAs", "\[RuleDelayed]", 
              RowBox[{"GiveOutputString", "[", 
               RowBox[{"Phi", ",", "covd"}], "]"}]}], ",", 
             RowBox[{"Master", "\[Rule]", "covd"}], ",", 
             RowBox[{"FilterRules", "[", 
              RowBox[{
               RowBox[{"{", "options", "}"}], ",", 
               RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
             RowBox[{"DefInfo", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<curvature spinor\>\"", ",", "\"\<\>\""}], 
               "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"PhiNamedag", "=", 
            RowBox[{"Dagger", "[", "PhiName", "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Computation", " ", "of", " ", "the", " ", "decomposition", " ", 
          "rules", " ", "for", " ", "the", " ", "curvature", " ", "spinors"}],
          "*)"}], "\[IndentingNewLine]", 
        RowBox[{"compumessage", "[", 
         RowBox[{"covd", ",", "FRiemann"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"xTensorQ", "@", "FRiemannName"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"covd", "/:", 
           RowBox[{"DecompositionRules", "[", 
            RowBox[{"covd", ",", "FRiemann"}], "]"}], "=", 
           RowBox[{"Flatten", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"MakeRule", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"FRiemannName", "[", 
                  RowBox[{
                   RowBox[{"-", "A"}], ",", 
                   RowBox[{"-", "Ad"}], ",", 
                   RowBox[{"-", "B"}], ",", 
                   RowBox[{"-", "Bd"}], ",", 
                   RowBox[{"-", "F"}], ",", 
                   RowBox[{"-", "G"}]}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"$ChiSign", " ", 
                   RowBox[{"ChiName", "[", 
                    RowBox[{
                    RowBox[{"-", "F"}], ",", 
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], 
                   RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], "$PhiSign", " ", 
                   RowBox[{"PhiName", "[", 
                    RowBox[{
                    RowBox[{"-", "F"}], ",", 
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}]}]}]}], "}"}], "]"}], ",", 
              RowBox[{"MakeRule", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Evaluate", "@", 
                  RowBox[{"FRiemannNamedag", "[", 
                   RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Fd"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}]}], ",", 
                 RowBox[{
                  RowBox[{"$ChiSign", " ", 
                   RowBox[{"ChiNamedag", "[", 
                    RowBox[{
                    RowBox[{"-", "Fd"}], ",", 
                    RowBox[{"-", "Gd"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}], 
                   RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}], "$PhiSign", " ", 
                   RowBox[{"PhiNamedag", "[", 
                    RowBox[{
                    RowBox[{"-", "Fd"}], ",", 
                    RowBox[{"-", "Gd"}], ",", 
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}]}]}]}], "}"}], "]"}]}], "}"}], 
            "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
         "LeviCivitaQ", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"DefTensor", "[", 
            RowBox[{
             RowBox[{"LambdaName", "[", "]"}], ",", "base", ",", 
             RowBox[{"Dagger", "\[Rule]", "Real"}], ",", 
             RowBox[{"PrintAs", "\[RuleDelayed]", 
              RowBox[{"GiveOutputString", "[", 
               RowBox[{"Lambda", ",", "covd"}], "]"}]}], ",", 
             RowBox[{"Master", "\[Rule]", "covd"}], ",", 
             RowBox[{"FilterRules", "[", 
              RowBox[{
               RowBox[{"{", "options", "}"}], ",", 
               RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
             RowBox[{"DefInfo", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<spinor scalar curvature\>\"", ",", "\"\<\>\""}], 
               "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"DefTensor", "[", 
            RowBox[{
             RowBox[{"PsiName", "[", 
              RowBox[{
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "B"}], ",", 
               RowBox[{"-", "F"}], ",", 
               RowBox[{"-", "G"}]}], "]"}], ",", "base", ",", 
             RowBox[{"Symmetric", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
             RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
             RowBox[{"PrintAs", "\[RuleDelayed]", 
              RowBox[{"GiveOutputString", "[", 
               RowBox[{"Psi", ",", "covd"}], "]"}]}], ",", 
             RowBox[{"Master", "\[Rule]", "covd"}], ",", 
             RowBox[{"FilterRules", "[", 
              RowBox[{
               RowBox[{"{", "options", "}"}], ",", 
               RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
             RowBox[{"DefInfo", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<Weyl spinor\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"PsiNamedag", "=", 
            RowBox[{"Dagger", "[", "PsiName", "]"}]}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"compumessage", "[", 
            RowBox[{"covd", ",", "Chi"}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"SymmetryGroupOfTensor", "[", "ChiName", "]"}], "^=", 
              RowBox[{"StrongGenSet", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "3"}], "}"}], ",", 
                RowBox[{"GenSet", "[", 
                 RowBox[{
                  RowBox[{"Cycles", "[", 
                   RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
                  RowBox[{"Cycles", "[", 
                   RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]}], "]"}]}],
              ";"}], "*)"}], "\[IndentingNewLine]", 
           RowBox[{"covd", "/:", 
            RowBox[{"DecompositionRules", "[", 
             RowBox[{"covd", ",", "Chi"}], "]"}], "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"MakeRule", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"ChiName", "[", 
                   RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "F"}], ",", 
                    RowBox[{"-", "G"}]}], "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"$LambdaSign", "/", "$ChiSign"}], ")"}], " ", 
                    RowBox[{"LambdaName", "[", "]"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "G"}]}], "]"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "G"}]}], "]"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"(", 
                    RowBox[{"$PsiSign", "/", "$ChiSign"}], ")"}], ")"}], " ", 
                    
                    RowBox[{"PsiName", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "F"}], ",", 
                    RowBox[{"-", "G"}]}], "]"}]}]}]}], "}"}], "]"}], ",", 
               RowBox[{"MakeRule", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Evaluate", "[", 
                   RowBox[{"ChiNamedag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "Fd"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}], "]"}], ",", " ", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"$LambdaSign", "/", "$ChiSign"}], ")"}], 
                    RowBox[{"LambdaName", "[", "]"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"(", 
                    RowBox[{"$PsiSign", "/", "$ChiSign"}], ")"}], ")"}], 
                    RowBox[{"PsiNamedag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "Fd"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}]}]}]}], "}"}], "]"}]}], "}"}],
              "]"}]}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "This", " ", "part", " ", "will", " ", "be", " ", "executed", " ", 
          "only", " ", "if", " ", "the", " ", "Torsion", " ", "spinor", " ", 
          "has", " ", "not", " ", "been", " ", "defined"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"xTensorQ", "[", "TorsionName", "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"$DefInfoQ", ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<** DefSpinCovD:  Torsion spinor for tangent \
derivative \>\"", ",", "ef", ",", "\"\< already defined\>\""}], "]"}]}], 
           "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"DefSpinorOfTensor", "[", 
            RowBox[{
             RowBox[{"TorsionName", "[", 
              RowBox[{
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "Ad"}], ",", 
               RowBox[{"-", "B"}], ",", 
               RowBox[{"-", "Bd"}], ",", 
               RowBox[{"-", "F"}], ",", 
               RowBox[{"-", "Fd"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"Torsion", "[", "ef", "]"}], "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "b"}], ",", 
               RowBox[{"-", "c"}]}], "]"}], ",", "sigma", ",", "options"}], 
            "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Define", " ", "the", " ", "torsion", " ", "spinor"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"TorsionQ", "@", "covd"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"DefTensor", "[", 
            RowBox[{
             RowBox[{"OmegaName", "[", 
              RowBox[{
               RowBox[{"-", "Ad"}], ",", 
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "B"}], ",", 
               RowBox[{"-", "F"}]}], "]"}], ",", "base", ",", 
             RowBox[{"Symmetric", "[", 
              RowBox[{"{", 
               RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
             RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
             RowBox[{"PrintAs", "\[RuleDelayed]", 
              RowBox[{"GiveOutputString", "[", 
               RowBox[{"Omega", ",", "covd"}], "]"}]}], ",", 
             RowBox[{"Master", "\[Rule]", "covd"}], ",", 
             RowBox[{"FilterRules", "[", 
              RowBox[{
               RowBox[{"{", "options", "}"}], ",", 
               RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
             RowBox[{"DefInfo", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<torsion spinor\>\"", ",", "\"\<\>\""}], "}"}]}]}],
             "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"OmegaNamedag", "=", 
            RowBox[{"Dagger", "[", "OmegaName", "]"}]}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"covd", "/:", 
            RowBox[{"DecompositionRules", "[", 
             RowBox[{"covd", ",", "Torsion"}], "]"}], "=", 
            "\[IndentingNewLine]", 
            RowBox[{"MakeRule", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TorsionName", "[", 
                RowBox[{
                 RowBox[{"-", "A"}], ",", 
                 RowBox[{"-", "Ad"}], ",", 
                 RowBox[{"-", "B"}], ",", 
                 RowBox[{"-", "Bd"}], ",", 
                 RowBox[{"-", "F"}], ",", 
                 RowBox[{"-", "Fd"}]}], "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"epsdag", "[", 
                  RowBox[{
                   RowBox[{"-", "Bd"}], ",", 
                   RowBox[{"-", "Fd"}]}], "]"}], "$OmegaSign", " ", 
                 RowBox[{"OmegaName", "[", 
                  RowBox[{
                   RowBox[{"-", "Ad"}], ",", 
                   RowBox[{"-", "A"}], ",", 
                   RowBox[{"-", "B"}], ",", 
                   RowBox[{"-", "F"}]}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"eps", "[", 
                  RowBox[{
                   RowBox[{"-", "B"}], ",", 
                   RowBox[{"-", "F"}]}], "]"}], "$OmegaSign", " ", 
                 RowBox[{"OmegaNamedag", "[", 
                  RowBox[{
                   RowBox[{"-", "A"}], ",", 
                   RowBox[{"-", "Ad"}], ",", 
                   RowBox[{"-", "Bd"}], ",", 
                   RowBox[{"-", "Fd"}]}], "]"}]}]}]}], "}"}], "]"}]}], 
           ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "The", " ", "remaining", " ", "part", " ", "will", " ", "be", " ", 
          "executed", " ", "only", " ", "if", " ", "the", " ", "Riemann", " ",
           "spinor", " ", "has", " ", "not", " ", "been", " ", "defined", " ",
           "and", " ", "if", " ", "the", " ", "Riemann", " ", "and", " ", 
          "Ricci", " ", "tensors", " ", "do", " ", "not", " ", "vanish"}], 
         " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"xTensorQ", "[", "RiemannName", "]"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Riemann", "[", "ef", "]"}], "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "b"}], ",", 
               RowBox[{"-", "c"}], ",", 
               RowBox[{"-", "d"}]}], "]"}], "=!=", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Ricci", "[", "ef", "]"}], "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "b"}]}], "]"}], "=!=", "0"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"$DefInfoQ", ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<** DefSpinCovD:  Curvature spinors for tangent \
derivative \>\"", ",", "ef", ",", "\"\< already defined\>\""}], "]"}]}], 
           "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"DefSpinorOfTensor", "[", 
            RowBox[{
             RowBox[{"RiemannName", "[", 
              RowBox[{
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "Ad"}], ",", 
               RowBox[{"-", "B"}], ",", 
               RowBox[{"-", "Bd"}], ",", 
               RowBox[{"-", "F"}], ",", 
               RowBox[{"-", "Fd"}], ",", 
               RowBox[{"-", "G"}], ",", 
               RowBox[{"-", "Gd"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"Riemann", "[", "ef", "]"}], "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "b"}], ",", 
               RowBox[{"-", "c"}], ",", 
               RowBox[{"-", "d"}]}], "]"}], ",", "sigma", ",", "options"}], 
            "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"DefSpinorOfTensor", "[", 
            RowBox[{
             RowBox[{"RicciName", "[", 
              RowBox[{
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "Ad"}], ",", 
               RowBox[{"-", "B"}], ",", 
               RowBox[{"-", "Bd"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"Ricci", "[", "ef", "]"}], "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "b"}]}], "]"}], ",", "sigma", ",", "options"}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"!", "LeviCivitaQ"}], "&&", 
              RowBox[{"xTensorQ", "@", "RiemannName"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"compumessage", "[", 
               RowBox[{"covd", ",", "Riemann"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"covd", "/:", 
               RowBox[{"DecompositionRules", "[", 
                RowBox[{"covd", ",", "Riemann"}], "]"}], "=", 
               RowBox[{"MakeRule", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"RiemannName", "[", 
                   RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "F"}], ",", 
                    RowBox[{"-", "Fd"}], ",", 
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "F"}], ",", 
                    RowBox[{"-", "G"}]}], "]"}], 
                    RowBox[{"FRiemannNamedag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Gd"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}]}], "+", 
                   RowBox[{
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Fd"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}], 
                    RowBox[{"FRiemannName", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}]}]}]}], "}"}], "]"}]}]}]}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
            "LeviCivitaQ", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
             
             RowBox[{
              RowBox[{"PsiNamedag", "=", 
               RowBox[{"Dagger", "[", "PsiName", "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"DefSpinorOfTensor", "[", 
               RowBox[{
                RowBox[{"WeylName", "[", 
                 RowBox[{
                  RowBox[{"-", "A"}], ",", 
                  RowBox[{"-", "Ad"}], ",", 
                  RowBox[{"-", "B"}], ",", 
                  RowBox[{"-", "Bd"}], ",", 
                  RowBox[{"-", "F"}], ",", 
                  RowBox[{"-", "Fd"}], ",", 
                  RowBox[{"-", "G"}], ",", 
                  RowBox[{"-", "Gd"}]}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Weyl", "[", "ef", "]"}], "[", 
                 RowBox[{
                  RowBox[{"-", "a"}], ",", 
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "c"}], ",", 
                  RowBox[{"-", "d"}]}], "]"}], ",", "sigma", ",", "options"}],
                "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"DefSpinorOfTensor", "[", 
               RowBox[{
                RowBox[{"TFRicciName", "[", 
                 RowBox[{
                  RowBox[{"-", "A"}], ",", 
                  RowBox[{"-", "Ad"}], ",", 
                  RowBox[{"-", "B"}], ",", 
                  RowBox[{"-", "Bd"}]}], "]"}], ",", 
                RowBox[{
                 RowBox[{"TFRicci", "[", "ef", "]"}], "[", 
                 RowBox[{
                  RowBox[{"-", "a"}], ",", 
                  RowBox[{"-", "b"}]}], "]"}], ",", "sigma", ",", "options"}],
                "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"compumessage", "[", 
               RowBox[{"covd", ",", "Riemann"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"covd", "/:", 
               RowBox[{"DecompositionRules", "[", 
                RowBox[{"covd", ",", "Riemann"}], "]"}], "=", 
               RowBox[{"MakeRule", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"RiemannName", "[", 
                   RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "F"}], ",", 
                    RowBox[{"-", "Fd"}], ",", 
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}]}], 
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "G"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "G"}]}], "]"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}]}]}], ")"}], "$LambdaSign", " ", 
                    RowBox[{"LambdaName", "[", "]"}]}], "-", 
                   RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}], "$PhiSign", " ", 
                    RowBox[{"PhiName", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Gd"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}]}], "-", 
                   RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Gd"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}], "$PhiSign", " ", 
                    RowBox[{"PhiName", "[", 
                    RowBox[{
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "F"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}]}], "-", 
                   RowBox[{
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Gd"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}], "$PsiSign", " ", 
                    RowBox[{"PsiName", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}]}], "-", 
                   RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}], "$PsiSign", " ", 
                    RowBox[{"PsiNamedag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "Gd"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}]}]}]}], "}"}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"compumessage", "[", 
               RowBox[{"covd", ",", "Ricci"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"covd", "/:", 
               RowBox[{"DecompositionRules", "[", 
                RowBox[{"covd", ",", "Ricci"}], "]"}], "=", 
               RowBox[{"MakeRule", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"RicciName", "[", 
                   RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"6", "$LambdaSign", " ", 
                    RowBox[{"LambdaName", "[", "]"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}]}], "-", 
                   RowBox[{"2", "$PhiSign", " ", 
                    RowBox[{"PhiName", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}]}]}]}], "}"}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"compumessage", "[", 
               RowBox[{"covd", ",", "TFRicci"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"covd", "/:", 
               RowBox[{"DecompositionRules", "[", 
                RowBox[{"covd", ",", "TFRicci"}], "]"}], "=", 
               RowBox[{"MakeRule", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"TFRicciName", "[", 
                   RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"-", "2"}], "$PhiSign", " ", 
                   RowBox[{"PhiName", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}]}]}], "}"}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"(*", " ", 
               RowBox[{
               "We", " ", "use", " ", "the", " ", "RicciScalar", " ", "and", " ",
                 "not", " ", "its", " ", "spinor"}], " ", "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"compumessage", "[", 
               RowBox[{"covd", ",", "RicciScalar"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"covd", "/:", 
               RowBox[{"DecompositionRules", "[", 
                RowBox[{"covd", ",", "RicciScalar"}], "]"}], "=", 
               RowBox[{"MakeRule", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Evaluate", "[", 
                   RowBox[{
                    RowBox[{"RicciScalar", "[", "ef", "]"}], "[", "]"}], 
                   "]"}], ",", 
                  RowBox[{"24", "$LambdaSign", " ", 
                   RowBox[{"LambdaName", "[", "]"}]}]}], "}"}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"compumessage", "[", 
               RowBox[{"covd", ",", "Weyl"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"covd", "/:", 
               RowBox[{"DecompositionRules", "[", 
                RowBox[{"covd", ",", "Weyl"}], "]"}], "=", 
               RowBox[{"MakeRule", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"WeylName", "[", 
                   RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "F"}], ",", 
                    RowBox[{"-", "Fd"}], ",", 
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "Gd"}]}], "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}]}], "]"}]}], 
                    RowBox[{"epsdag", "[", 
                    RowBox[{
                    RowBox[{"-", "Gd"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}], "$PsiSign", " ", 
                    RowBox[{"PsiName", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}]}], "-", 
                   RowBox[{
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], 
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "G"}], ",", 
                    RowBox[{"-", "F"}]}], "]"}], "$PsiSign", " ", 
                    RowBox[{"PsiNamedag", "[", 
                    RowBox[{
                    RowBox[{"-", "Ad"}], ",", 
                    RowBox[{"-", "Bd"}], ",", 
                    RowBox[{"-", "Gd"}], ",", 
                    RowBox[{"-", "Fd"}]}], "]"}]}]}]}], "}"}], "]"}]}], 
              ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Return", " ", "to", " ", "original", " ", "options"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Options", "[", "MakeRule", "]"}], "=", "MakeRuleOptions"}], 
        ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"aafe9e66-0537-4e39-bba9-ab5d38991a84"],

Cell["\<\
We define next the rules implementing the decomposition in irreducible parts \
of certain curvature objects. \
\>", "Text",
 CellChangeTimes->{{3.4083618351735687`*^9, 3.4083618382722282`*^9}, 
   3.408362302222023*^9},ExpressionUUID->"d40e26e5-7dcc-4e41-abae-\
a79b4f6ccdea"],

Cell["User function :", "Text",
 CellChangeTimes->{{3.408361841801569*^9, 
  3.408361843858549*^9}},ExpressionUUID->"88ee958d-0325-410a-abce-\
315248c42e0a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Decomposition"}]], "Input",
 CellChangeTimes->{{3.4083625071755857`*^9, 
  3.408362508758006*^9}},ExpressionUUID->"f338bad4-f025-41ab-b8a0-\
d607e9b108c1"],

Cell[BoxData[
 StyleBox["\<\"Decomposition[expr, object, covd] decomposes curvature tensors \
of covd in expr according to predefined rules. Possible objects are Riemann, \
Ricci, TFRicci, Weyl, RicciScalar, FRiemann or Chi.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3588025983-1170166",ExpressionUUID->"bf303ca5-bc96-4306-8968-\
a88732ea4529"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Decomposition", "[", "expr_", "]"}], ":=", 
   RowBox[{"Decomposition", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"{", 
      RowBox[{
      "FRiemann", ",", "Riemann", ",", "Ricci", ",", "TFRicci", ",", 
       "RicciScalar", ",", "Weyl", ",", "Torsion"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Decomposition", "[", 
    RowBox[{"expr_", ",", "object_"}], "]"}], ":=", 
   RowBox[{"Decomposition", "[", 
    RowBox[{"expr", ",", "object", ",", "$SpinCovDs"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Decomposition", "[", 
    RowBox[{"expr_", ",", "objects_List", ",", "covd_"}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Decomposition", "[", 
       RowBox[{"#1", ",", "#2", ",", "covd"}], "]"}], "&"}], ",", "expr", ",",
      "objects"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Decomposition", "[", 
    RowBox[{"expr_", ",", "object_", ",", "covds_List"}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Decomposition", "[", 
       RowBox[{"#1", ",", "object", ",", "#2"}], "]"}], "&"}], ",", "expr", ",",
      "covds"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Decomposition", "[", 
    RowBox[{"expr_", ",", "object_", ",", "covd_"}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"DecompositionRules", "[", 
     RowBox[{"covd", ",", "object"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DecompositionRules", "[", 
    RowBox[{"covd_", ",", "object_"}], "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Decomposition", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Decomposition", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.408361851511091*^9, 3.4083618577546167`*^9}, {
  3.408362104252046*^9, 3.408362139874613*^9}, {3.408362172781602*^9, 
  3.408362266449071*^9}, {3.408362319871418*^9, 3.408362373282515*^9}, {
  3.408362408110403*^9, 3.408362427745077*^9}, {3.423579006223825*^9, 
  3.4235790319699783`*^9}, {3.423580951406969*^9, 3.423580995683527*^9}, {
  3.423671526003273*^9, 3.423671536800342*^9}, {3.434610240032946*^9, 
  3.434610241292726*^9}},ExpressionUUID->"fad1544a-868d-46ea-b79f-\
923a8ab37a79"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.3. Box operator", "Subsubsection",
 CellChangeTimes->{{3.4242658754553747`*^9, 3.424265882165186*^9}, 
   3.424280868959271*^9},ExpressionUUID->"8be5efce-cc71-4b18-b513-\
4d15c84a10be"],

Cell["\<\
This is the Box operator of a spincovd. We do not define the conjugated \
symbol DaggerBox because it is possible (and simpler) to work with just one \
symbol. Whether we are using one or the other is encoded in the indices.

In spite of being a symmetrized second derivative, this operator is actually \
a first derivative, and so it can be defined using the type CovD. Note that \
it is CovD and not SpinCovD. However, we do not use DefCovD to define it. We \
can use UndefCovD to undefine it, because UndefCovD knows what to do with the \
objects in the private list $MultiIndexCovDs.\
\>", "Text",
 CellChangeTimes->{{3.4242809396964827`*^9, 3.424280948958803*^9}, {
  3.424281030127132*^9, 3.424281084985877*^9}, {3.425989983161866*^9, 
  3.4259899848404713`*^9}, {3.4260170325067987`*^9, 3.426017033068828*^9}, {
  3.426017480069644*^9, 3.426017523184885*^9}, {3.426017611688901*^9, 
  3.426017673489419*^9}, {3.426531753354951*^9, 
  3.426531761149466*^9}},ExpressionUUID->"130a3bd3-dd1a-4da4-b7ff-\
0959d988f301"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefBox", "[", "covd_Symbol", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"boxcd", "=", 
       RowBox[{"SymbolJoin", "[", 
        RowBox[{"\"\<Box\>\"", ",", "covd"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"CovDQ", "[", "boxcd", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"xAct`xTensor`Private`$MultiIndexCovDs", ",", "boxcd"}], "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`MakeLinearDerivative", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"boxcd", "[", 
           RowBox[{"A_", ",", "B_"}], "]"}], ",", 
          RowBox[{"boxcd", "[", 
           RowBox[{"A", ",", "B"}], "]"}]}], "}"}], ",", "True"}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SymmetryGroupOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"Symmetric", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", "xAct`xPerm`Cycles"}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ManifoldOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"ManifoldOfCovD", "[", "covd", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"VBundlesOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"VBundlesOfCovD", "[", "covd", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"DependenciesOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"DependenciesOfCovD", "[", "covd", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CovDOfBox", "[", "boxcd", "]"}], "^=", "covd"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"boxcd", "/:", 
       RowBox[{"Dagger", "[", 
        RowBox[{
         RowBox[{"boxcd", "[", 
          RowBox[{"A_", ",", "B_"}], "]"}], "[", "expr_", "]"}], "]"}], ":=", 
       
       RowBox[{
        RowBox[{"boxcd", "[", 
         RowBox[{
          RowBox[{"DaggerIndex", "[", "A", "]"}], ",", 
          RowBox[{"DaggerIndex", "[", "B", "]"}]}], "]"}], "[", 
        RowBox[{"Dagger", "[", "expr", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SymbolOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"First", "[", 
          RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "]"}], ",", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"\"\<\[EmptySquare]\>\"", ",", "\"\<[\>\"", ",", 
           RowBox[{"Part", "[", 
            RowBox[{
             RowBox[{"SymbolOfCovD", "@", "covd"}], ",", "2"}], "]"}], 
           ",", "\"\<]\>\""}], "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
       RowBox[{"boxcd", ",", "covd", ",", 
        RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "boxcd", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"34b5f439-d14b-41a2-a6fb-803fe6add296"],

Cell[TextData[{
 "Note that we have not used the symbol Box, which is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " built-in."
}], "Text",
 CellChangeTimes->{{3.424280954075314*^9, 
  3.424280993931987*^9}},ExpressionUUID->"1066e92e-2436-4f9c-b344-\
834853db7b0e"],

Cell["\<\
This code expands the box operator into covariant derivatives (formula \
(4.9.2) of Penrose & Rindler Vol 2).\
\>", "Text",
 CellChangeTimes->{{3.42513073727642*^9, 3.4251307383648252`*^9}, {
   3.425130784143442*^9, 3.4251308337860823`*^9}, {3.425962229063937*^9, 
   3.4259622546237*^9}, 
   3.4259623257677937`*^9},ExpressionUUID->"8063bad1-c749-4671-a3dd-\
f6dda4af3987"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BoxToCovD", "[", 
    RowBox[{"expr_", ",", "boxcd_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"cd", "=", 
        RowBox[{"CovDOfBox", "@", "boxcd"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"spin", "=", 
        RowBox[{
         RowBox[{"VBundlesOfCovD", "[", "boxcd", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"spindag", "=", 
        RowBox[{
         RowBox[{"VBundlesOfCovD", "[", "boxcd", "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"expr", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"boxcd", "[", 
           RowBox[{"A_", ",", "B_"}], "]"}], "@", "L_"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Cdag", "=", 
              RowBox[{"DummyIn", "[", "spindag", "]"}]}], "}"}], ",", 
            RowBox[{"xAct`xTensor`Symmetrize", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"cd", "[", 
                RowBox[{"A", ",", 
                 RowBox[{"-", "Cdag"}]}], "]"}], "@", 
               RowBox[{
                RowBox[{"cd", "[", 
                 RowBox[{"B", ",", "Cdag"}], "]"}], "@", "L"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "B"}], "}"}]}], "]"}]}], "]"}], "/;", 
          RowBox[{
           RowBox[{"ABIndexQ", "[", 
            RowBox[{"A", ",", "spin"}], "]"}], "&&", 
           RowBox[{"ABIndexQ", "[", 
            RowBox[{"B", ",", "spin"}], "]"}]}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"boxcd", "[", 
           RowBox[{"A_", ",", "B_"}], "]"}], "@", "L_"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"C", "=", 
              RowBox[{"DummyIn", "[", "spin", "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"xAct`xTensor`Symmetrize", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"cd", "[", 
                RowBox[{
                 RowBox[{"-", "C"}], ",", "A"}], "]"}], "@", 
               RowBox[{
                RowBox[{"cd", "[", 
                 RowBox[{"C", ",", "B"}], "]"}], "@", "L"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "B"}], "}"}]}], "]"}]}], "]"}], "/;", 
          RowBox[{
           RowBox[{"ABIndexQ", "[", 
            RowBox[{"A", ",", "spindag"}], "]"}], "&&", 
           RowBox[{"ABIndexQ", "[", 
            RowBox[{"B", ",", "spindag"}], "]"}]}]}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"BoxToCovD", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "BoxToCovD", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d11e0162-1d95-4bd5-a400-cd2a10de8cbf"],

Cell["\<\
Expansion of the box operator in terms of the curvature spinors (Eqs. \
(4.9.8)-(4.9.17) of  Penrose & Rindler Vol 2).\
\>", "Text",
 CellChangeTimes->{{3.425198479411376*^9, 3.425198494145225*^9}, {
  3.425962264248962*^9, 
  3.425962323183688*^9}},ExpressionUUID->"f3bb9e50-9a6b-4776-be02-\
fe551e2deac9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BoxToCurvature", "[", 
    RowBox[{"expr_", ",", "boxcd_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"spin", "=", 
        RowBox[{
         RowBox[{"VBundlesOfCovD", "[", "boxcd", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"spindag", "=", 
        RowBox[{
         RowBox[{"VBundlesOfCovD", "[", "boxcd", "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"expr", "/.", 
      RowBox[{
       RowBox[{
        RowBox[{"boxcd", "[", 
         RowBox[{"A_", ",", "B_"}], "]"}], "@", "L_"}], "\[RuleDelayed]", 
       RowBox[{"addCurvatureBox", "[", 
        RowBox[{"L", ",", 
         RowBox[{"CovDOfBox", "@", "boxcd"}], ",", 
         RowBox[{"{", 
          RowBox[{"A", ",", "B"}], "}"}], ",", 
         RowBox[{"List", "@@", 
          RowBox[{"FindFreeIndices", "[", "L", "]"}]}], ",", "spin", ",", 
         "spindag"}], "]"}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"BoxToCurvature", ",", "2"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "BoxToCurvature", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4252002128393097`*^9, 3.425200357769566*^9}, {
   3.4252004707863493`*^9, 3.425200487297297*^9}, {3.425200602482752*^9, 
   3.425200602934391*^9}, {3.425200675667132*^9, 3.4252007245890303`*^9}, {
   3.4252007902958393`*^9, 3.4252008125805492`*^9}, {3.425200906854094*^9, 
   3.42520092655233*^9}, 3.425201124482519*^9, {3.4252011648098373`*^9, 
   3.425201171802116*^9}, 3.425201434671611*^9, {3.425201487267651*^9, 
   3.425201498731805*^9}, {3.425201766532363*^9, 3.425201769444604*^9}, {
   3.42520232745144*^9, 3.425202338684593*^9}, 3.425202647075729*^9, 
   3.425203845419788*^9, {3.42601933171898*^9, 3.426019419542202*^9}, {
   3.4260195061408567`*^9, 3.426019507137783*^9}, {3.427197328360682*^9, 
   3.42719734741924*^9}},ExpressionUUID->"a9d31d81-9c1c-4332-8470-\
2c6810fd9c31"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"addCurvatureBox", "[", 
    RowBox[{"expr_", ",", "covd_", ",", 
     RowBox[{"{", 
      RowBox[{"A_", ",", "B_"}], "}"}], ",", "frees_", ",", "vb_", ",", 
     "vbdag_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dummy1", "=", 
        RowBox[{"DummyIn", "[", "vb", "]"}]}], ",", 
       RowBox[{"dummy2", "=", 
        RowBox[{"DummyIn", "[", "vbdag", "]"}]}], ",", 
       RowBox[{"vbQ", "=", 
        RowBox[{"xAct`xTensor`Private`VBundleIndexQ", "[", "vb", "]"}]}], ",", 
       RowBox[{"vbdagQ", "=", 
        RowBox[{"xAct`xTensor`Private`VBundleIndexQ", "[", "vbdag", "]"}]}], ",", 
       RowBox[{"vbpmQ", "=", 
        RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "[", "vb", "]"}]}], ",", 
       RowBox[{"vbpmdagQ", "=", 
        RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "[", "vbdag", "]"}]}],
        ",", 
       RowBox[{"chicd", "=", 
        RowBox[{"Chi", "[", "covd", "]"}]}], ",", 
       RowBox[{"phicd", "=", 
        RowBox[{"Phi", "[", "covd", "]"}]}], ",", 
       RowBox[{"omegacd", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"TorsionQ", "[", "covd", "]"}], ",", 
          RowBox[{"Omega", "[", "covd", "]"}], ",", "Zero"}], "]"}]}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Which", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ABIndexQ", "[", 
         RowBox[{"A", ",", "vb"}], "]"}], "&&", 
        RowBox[{"ABIndexQ", "[", 
         RowBox[{"B", ",", "vb"}], "]"}], "&&", 
        RowBox[{"TorsionQ", "@", "covd"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "$ChiSign"}], " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"chicd", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"-", "dummy1"}], ",", "A", ",", "B"}], "]"}], " ", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", "dummy1"}]}], "]"}]}], "&"}], ")"}], 
            "/@", 
            RowBox[{"Select", "[", 
             RowBox[{"frees", ",", "vbQ"}], "]"}]}], ")"}]}]}], "+", 
        RowBox[{"$ChiSign", " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"chicd", "[", 
                RowBox[{"dummy1", ",", "#", ",", "A", ",", "B"}], "]"}], " ", 
               
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", 
                  RowBox[{"-", "dummy1"}]}]}], "]"}]}], "&"}], ")"}], "/@", 
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{"frees", ",", "vbpmQ"}], "]"}], ",", 
              RowBox[{"Select", "[", 
               RowBox[{"frees", ",", "vbQ"}], "]"}]}], "]"}]}], ")"}]}]}], "-", 
        RowBox[{"$PhiSign", " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Dagger", "[", "phicd", "]"}], "[", 
                RowBox[{"#", ",", 
                 RowBox[{"-", "dummy2"}], ",", "A", ",", "B"}], "]"}], " ", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", "dummy2"}]}], "]"}]}], "&"}], ")"}], 
            "/@", 
            RowBox[{"Select", "[", 
             RowBox[{"frees", ",", "vbdagQ"}], "]"}]}], ")"}]}]}], "+", 
        RowBox[{"$PhiSign", " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Dagger", "[", "phicd", "]"}], "[", 
                RowBox[{"dummy2", ",", "#", ",", "A", ",", "B"}], "]"}], " ", 
               
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", 
                  RowBox[{"-", "dummy2"}]}]}], "]"}]}], "&"}], ")"}], "/@", 
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{"frees", ",", "vbpmdagQ"}], "]"}], ",", 
              RowBox[{"Select", "[", 
               RowBox[{"frees", ",", "vbdagQ"}], "]"}]}], "]"}]}], ")"}]}]}], 
        "-", 
        RowBox[{"$TorsionSign", " ", "$OmegaSign", " ", 
         RowBox[{"omegacd", "[", 
          RowBox[{"dummy2", ",", "dummy1", ",", "A", ",", "B"}], "]"}], 
         RowBox[{
          RowBox[{"covd", "[", 
           RowBox[{
            RowBox[{"-", "dummy1"}], ",", 
            RowBox[{"-", "dummy2"}]}], "]"}], "@", "expr"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ABIndexQ", "[", 
         RowBox[{"A", ",", "vb"}], "]"}], "&&", 
        RowBox[{"ABIndexQ", "[", 
         RowBox[{"B", ",", "vb"}], "]"}], "&&", 
        RowBox[{"!", 
         RowBox[{"TorsionQ", "@", "covd"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "$ChiSign"}], " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"chicd", "[", 
                RowBox[{
                 RowBox[{"-", "dummy1"}], ",", "#", ",", "A", ",", "B"}], 
                "]"}], " ", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", "dummy1"}]}], "]"}]}], "&"}], ")"}], 
            "/@", 
            RowBox[{"Select", "[", 
             RowBox[{"frees", ",", "vbpmQ"}], "]"}]}], ")"}]}]}], "-", 
        RowBox[{"$PhiSign", " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Dagger", "[", "phicd", "]"}], "[", 
                RowBox[{
                 RowBox[{"-", "dummy2"}], ",", "#", ",", "A", ",", "B"}], 
                "]"}], " ", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", "dummy2"}]}], "]"}]}], "&"}], ")"}], 
            "/@", 
            RowBox[{"Select", "[", 
             RowBox[{"frees", ",", "vbpmdagQ"}], "]"}]}], ")"}]}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ABIndexQ", "[", 
         RowBox[{"A", ",", "vbdag"}], "]"}], "&&", 
        RowBox[{"ABIndexQ", "[", 
         RowBox[{"B", ",", "vbdag"}], "]"}], "&&", 
        RowBox[{"TorsionQ", "@", "covd"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "$ChiSign"}], " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Dagger", "[", "chicd", "]"}], "[", 
                RowBox[{"#", ",", 
                 RowBox[{"-", "dummy2"}], ",", "A", ",", "B"}], "]"}], " ", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", "dummy2"}]}], "]"}]}], "&"}], ")"}], 
            "/@", 
            RowBox[{"Select", "[", 
             RowBox[{"frees", ",", "vbdagQ"}], "]"}]}], ")"}]}]}], "+", 
        RowBox[{"$ChiSign", " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Dagger", "[", "chicd", "]"}], "[", 
                RowBox[{"dummy2", ",", "#", ",", "A", ",", "B"}], "]"}], " ", 
               
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", 
                  RowBox[{"-", "dummy2"}]}]}], "]"}]}], "&"}], ")"}], "/@", 
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{"frees", ",", "vbpmdagQ"}], "]"}], ",", 
              RowBox[{"Select", "[", 
               RowBox[{"frees", ",", "vbdagQ"}], "]"}]}], "]"}]}], ")"}]}]}], 
        "-", 
        RowBox[{"$PhiSign", " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"phicd", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"-", "dummy1"}], ",", "A", ",", "B"}], "]"}], " ", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", "dummy1"}]}], "]"}]}], "&"}], ")"}], 
            "/@", 
            RowBox[{"Select", "[", 
             RowBox[{"frees", ",", "vbQ"}], "]"}]}], ")"}]}]}], "+", 
        RowBox[{"$PhiSign", " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"phicd", "[", 
                RowBox[{"dummy1", ",", "#", ",", "A", ",", "B"}], "]"}], " ", 
               
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", 
                  RowBox[{"-", "dummy1"}]}]}], "]"}]}], "&"}], ")"}], "/@", 
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{"frees", ",", "vbpmQ"}], "]"}], ",", 
              RowBox[{"Select", "[", 
               RowBox[{"frees", ",", "vbQ"}], "]"}]}], "]"}]}], ")"}]}]}], "-", 
        RowBox[{"$TorsionSign", " ", "$OmegaSign", " ", 
         RowBox[{
          RowBox[{"Dagger", "[", "omegacd", "]"}], "[", 
          RowBox[{"dummy1", ",", "dummy2", ",", "A", ",", "B"}], "]"}], 
         RowBox[{
          RowBox[{"covd", "[", 
           RowBox[{
            RowBox[{"-", "dummy1"}], ",", 
            RowBox[{"-", "dummy2"}]}], "]"}], "@", "expr"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ABIndexQ", "[", 
         RowBox[{"A", ",", "vbdag"}], "]"}], "&&", 
        RowBox[{"ABIndexQ", "[", 
         RowBox[{"B", ",", "vbdag"}], "]"}], "&&", 
        RowBox[{"!", 
         RowBox[{"TorsionQ", "@", "covd"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "$ChiSign"}], " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Dagger", "[", "chicd", "]"}], "[", 
                RowBox[{
                 RowBox[{"-", "dummy2"}], ",", "#", ",", "A", ",", "B"}], 
                "]"}], " ", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", "dummy2"}]}], "]"}]}], "&"}], ")"}], 
            "/@", 
            RowBox[{"Select", "[", 
             RowBox[{"frees", ",", "vbpmdagQ"}], "]"}]}], ")"}]}]}], "-", 
        RowBox[{"$PhiSign", " ", "$RiemannSign", " ", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"phicd", "[", 
                RowBox[{
                 RowBox[{"-", "dummy1"}], ",", "#", ",", "A", ",", "B"}], 
                "]"}], " ", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#", "\[Rule]", "dummy1"}]}], "]"}]}], "&"}], ")"}], 
            "/@", 
            RowBox[{"Select", "[", 
             RowBox[{"frees", ",", "vbpmQ"}], "]"}]}], ")"}]}]}]}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6dcd8425-ef15-4657-ab39-312777064b16"],

Cell["\<\
The commutation of 2-index spin covariant derivatives can be written in terms \
of the box operator as follows:\
\>", "Text",
 CellChangeTimes->{{3.4943255325428753`*^9, 3.494325563021702*^9}, {
  3.494325717113998*^9, 
  3.494325726271063*^9}},ExpressionUUID->"130c7701-b19b-4e77-8316-\
5bfb9314bce3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SortSpinCovDs", "[", 
    RowBox[{"expr1_", ",", 
     RowBox[{"cd_", "?", "CovDQ"}]}], "]"}], ":=", 
   RowBox[{"expr1", "/.", 
    RowBox[{
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"A_", ",", "A\[Dagger]_"}], "]"}], "@", 
      RowBox[{
       RowBox[{"cd", "[", 
        RowBox[{"B_", ",", "B\[Dagger]_"}], "]"}], "@", "expr_"}]}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cd", "[", 
         RowBox[{"B", ",", "B\[Dagger]"}], "]"}], "@", 
        RowBox[{
         RowBox[{"cd", "[", 
          RowBox[{"A", ",", "A\[Dagger]"}], "]"}], "@", "expr"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"SpinMetricOfSolderingForm", "[", 
          RowBox[{"SolderingFormOfSpinCovD", "@", "cd"}], "]"}], "[", 
         RowBox[{"A", ",", "B"}], "]"}], " ", 
        RowBox[{
         RowBox[{
          RowBox[{"SymbolJoin", "[", 
           RowBox[{"\"\<Box\>\"", ",", "cd"}], "]"}], "[", 
          RowBox[{"A\[Dagger]", ",", "B\[Dagger]"}], "]"}], "@", "expr"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"Dagger", "[", 
          RowBox[{"SpinMetricOfSolderingForm", "[", 
           RowBox[{"SolderingFormOfSpinCovD", "@", "cd"}], "]"}], "]"}], "[", 
         
         RowBox[{"A\[Dagger]", ",", "B\[Dagger]"}], "]"}], " ", 
        RowBox[{
         RowBox[{
          RowBox[{"SymbolJoin", "[", 
           RowBox[{"\"\<Box\>\"", ",", "cd"}], "]"}], "[", 
          RowBox[{"A", ",", "B"}], "]"}], "@", "expr"}]}]}], "/;", 
      RowBox[{"DisorderedPairQ", "[", 
       RowBox[{"A", ",", "B"}], "]"}]}]}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.494325934296401*^9},ExpressionUUID->"63ec7231-a835-41a1-a2ef-6c738e752072"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5. End private and package", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"4fda7044-301d-42af-a85b-9a980bf28b71"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"End", "[", "]"}], "\[IndentingNewLine]", 
 RowBox[{"EndPackage", "[", "]"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5ed98360-4a89-42bd-9db9-2cf6070ac0c4"],

Cell[BoxData["\<\"xAct`Spinors`Private`\"\>"], \
"Output",ExpressionUUID->"0e3b5828-2da3-4e0b-aaad-331aa2e9a4bb"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["6. Examples", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"f0fd4720-3324-48a6-a517-9a5f4a371d46"],

Cell["The user context is empty :", \
"Text",ExpressionUUID->"7f477e24-1054-4153-ba3a-38de8d8e656c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Global`*"}]], \
"Input",ExpressionUUID->"0dc49c41-3915-46f9-8998-767c591a6c55"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Information", "::", "nomatch"}], "MessageName"], ":", 
  " ", "\<\"No symbol matching \[NoBreak]\\!\\(\\\"Global`*\\\"\\)\[NoBreak] \
found. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Information/nomatch\\\", ButtonNote -> \
\\\"Information::nomatch\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"7028e480-bbb3-4925-b662-2096a1d015ab"]
}, Open  ]],

Cell["0) Spacetime setup :", "Text",
 CellChangeTimes->{{3.4267739169976788`*^9, 3.426773921589923*^9}, {
  3.426774778548151*^9, 3.426774781956991*^9}},
 FontWeight->"Bold",ExpressionUUID->"55bc258a-d529-45ef-8efb-d09bb072d51d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M4", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.408875689695436*^9, 3.408875690366577*^9}, {
  3.419662195279158*^9, 
  3.4196621954256687`*^9}},ExpressionUUID->"f5ca1bfb-3269-40fc-9305-\
fb1c10a15fc5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M4, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"c6e08e08-609e-4305-a2d8-383d4f419000"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM4, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"7c5ea872-3a61-40ba-b0af-12ec6c1da78a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD"}], 
  "]"}]], "Input",ExpressionUUID->"a212badb-0096-4f6f-a29c-70efbd7d1a29"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"03808697-7753-4a54-9eb2-82884d21d52d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"f5d3a144-bf7f-4fea-9ce6-ad170854cf15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"86f10426-8680-4cdd-a11f-d7e0a3e064dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"61274ff8-e00e-4c0d-82de-be8a677abcb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"50021a0f-1edb-46e6-af32-c2b624aa2d82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"5ab75107-5b24-4603-803c-8672d5f09be2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"98ac409f-3c15-4ce6-af9d-a7e1e6863a36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e883b512-456f-44b5-b98e-a5653ffabc52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e553df83-ef24-40a3-a55f-c5597b0919b0"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], \
"Print",ExpressionUUID->"048db5a5-47e3-462c-a0b9-12b528b098cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"80f62b1e-6878-4ea7-b5cf-fdc39c3a584f"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], \
"Print",ExpressionUUID->"bbe805f1-c300-4274-9e81-eeed93e00b6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"03b8c44a-2ad9-4664-ae89-0882e3753e7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"7ef8e92c-ceec-4ec4-a5f3-20c96117f138"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"5acbca8a-5e6a-4e39-820d-af78323a460a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"28de3ee3-89cf-4586-a8db-30f733f59c4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"02722022-84a4-4e8f-867e-10cc4e94cc8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"8685dca2-4e83-4656-9d82-f6b886624353"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"a58b7dd4-88d0-4aea-bc98-050c3274ef7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->
   False]], "Print",ExpressionUUID->"d7f93f2a-fed9-4996-a78b-3fba3564f02c"]
}, Open  ]]
}, Open  ]],

Cell["1) The Tetra tensor:", "Text",
 CellChangeTimes->{{3.423662729994843*^9, 3.423662754340467*^9}, {
  3.426773938816874*^9, 3.426773944259594*^9}},
 FontWeight->"Bold",ExpressionUUID->"9b319a92-f7ae-46dc-8609-c82f853e53ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tetrag", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4236624068979683`*^9, 
  3.423662411859066*^9}},ExpressionUUID->"9a5b2ee9-e043-4098-b570-\
4249f8d4313b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"Gg", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Tetrag[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->
   False]], "Output",ExpressionUUID->"5e1e1be8-824b-4e28-96c0-1149fe76eec5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"TetraRule", "[", "g", "]"}]}]], "Input",
 CellChangeTimes->{{3.4236624165688543`*^9, 
  3.4236624246601057`*^9}},ExpressionUUID->"92d12c55-6ffb-4e42-8bc6-\
0535f953f103"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]g", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`c, -$CellContext`d],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"9b31830d-ec68-4d12-bb6a-fe56acc45c8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tetrag\[Dagger]", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4236624068979683`*^9, 
  3.423662436794063*^9}},ExpressionUUID->"a8364393-d4cb-4849-a8a3-\
0fecdf5daa20"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"Gg", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "d", "c", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Tetrag[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
  Editable->
   False]], "Output",ExpressionUUID->"3cc1d5dc-5f26-40bd-8d72-43960d673bea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"TetraRule", "[", "g", "]"}]}]], "Input",
 CellChangeTimes->{{3.4236624165688543`*^9, 
  3.4236624246601057`*^9}},ExpressionUUID->"a3027b45-bcf9-4841-9b22-\
3cf39a53a8cb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]g", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "d", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilong[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`c, -$CellContext`b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`d, -$CellContext`c],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"a3257389-298e-4a4c-9b3c-787a5030c79d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tetrag", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "-", 
   RowBox[{"Tetrag", "[", 
    RowBox[{"c", ",", "d", ",", "a", ",", "b"}], "]"}]}], "//", 
  "ToCanonical"}]], "Input",
 CellChangeTimes->{{3.423662457287237*^9, 
  3.4236624816841593`*^9}},ExpressionUUID->"d902f120-10b1-4e10-b22a-\
6a2b9497b141"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"e5863d32-98d3-4636-af04-b9cb6fc600d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tetrag", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "-", 
   RowBox[{"Tetrag", "[", 
    RowBox[{"b", ",", "a", ",", "d", ",", "c"}], "]"}]}], "//", 
  "ToCanonical"}]], "Input",
 CellChangeTimes->{{3.423662457287237*^9, 
  3.423662495999412*^9}},ExpressionUUID->"a29b89a2-d0a3-415f-bb4d-\
157fcb0b92ca"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"9685ff93-9b7a-4cfd-952f-618b9d3cfaad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "b"}], ",", "c", ",", 
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "/.", 
   RowBox[{"TetraRule", "[", "g", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellChangeTimes->{{3.4236624992146387`*^9, 
  3.423662525004537*^9}},ExpressionUUID->"7f2fe3e6-9a7d-44d8-bca4-\
06131cd801e5"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"b", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`b, -$CellContext`d],
   Editable->
    False]}]], "Output",ExpressionUUID->"46b1542a-5d12-4002-8632-92db772c4e8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}], ",", "b", ",", 
     RowBox[{"-", "b"}]}], "]"}], "/.", 
   RowBox[{"TetraRule", "[", "g", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellChangeTimes->{{3.4236624992146387`*^9, 
  3.423662543099207*^9}},ExpressionUUID->"e9ee2684-4f7b-4d8a-9e03-\
2b4150457363"],

Cell[BoxData[
 RowBox[{"2", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`c, -$CellContext`d],
   Editable->
    False]}]], "Output",ExpressionUUID->"7edcffa2-51af-4b96-aa84-e5de98afc591"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Tetrag", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "c", ",", 
      RowBox[{"-", "b"}], ",", "d"}], "]"}], 
    RowBox[{"Tetrag", "[", 
     RowBox[{
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "f"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], "/.", 
   RowBox[{"TetraRule", "[", "g", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellChangeTimes->{{3.423662549419649*^9, 3.42366257751291*^9}, {
  3.423729182362074*^9, 
  3.423729185861689*^9}},ExpressionUUID->"a6fc5524-8e9b-479e-a9a4-\
72358e208460"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "e"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`a, -$CellContext`e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"b", "f"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`b, -$CellContext`f],
   Editable->
    False]}]], "Output",ExpressionUUID->"f8a143a8-6833-4358-9b7d-135f87588f50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Tetrag", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], 
    RowBox[{"Tetrag\[Dagger]", "[", 
     RowBox[{
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "f"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], "/.", 
   RowBox[{"TetraRule", "[", "g", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellChangeTimes->{{3.423662549419649*^9, 
  3.423662610984989*^9}},ExpressionUUID->"b3174bfc-e9c1-4fd3-8746-\
3c1c73d25b58"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"e", "f"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`e, -$CellContext`f],
   Editable->
    False]}]], "Output",ExpressionUUID->"8f70a9fd-e857-49f6-b082-526bd8ebfd45"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Tetrag", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], 
    RowBox[{"Tetrag", "[", 
     RowBox[{
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "f"}]}], "]"}]}], "/.", 
   RowBox[{"TetraRule", "[", "g", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellChangeTimes->{{3.423662549419649*^9, 3.423662610984989*^9}, {
  3.4237290434503927`*^9, 3.423729050963335*^9}, {3.423729081765327*^9, 
  3.4237290843965893`*^9}},ExpressionUUID->"7abe4487-dcbe-4316-b36a-\
d971a0e6571d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"e", "f"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`e, -$CellContext`f],
   Editable->
    False]}]], "Output",ExpressionUUID->"322b2da4-1e71-48a9-9923-38a3b8ee0b3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Tetrag", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], 
      RowBox[{"Tetrag", "[", 
       RowBox[{"c", ",", "d", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "f"}]}], "]"}]}], "-", 
     RowBox[{"2", 
      RowBox[{"Tetrag", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "f"}]}], "]"}]}]}], "/.", 
    RowBox[{"TetraRule", "[", "g", "]"}]}], "//", "ContractMetric"}], "//", 
  "ToCanonical"}]], \
"Input",ExpressionUUID->"5879b570-7435-47d6-8b54-0c194e174dcc"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"8ce48c53-eb6d-4d1e-a827-2824fbe19bdc"]
}, Open  ]],

Cell["2) Spin structure :", "Text",
 CellChangeTimes->{{3.4267740370060043`*^9, 3.426774043209366*^9}},
 FontWeight->"Bold",ExpressionUUID->"63492474-11d4-4c2e-86d7-cd2f331d3537"],

Cell["\<\
We can define a spin structure by specifying the names of the metric, \
soldering form and covariant derivative:\
\>", "Text",ExpressionUUID->"570addf2-5b62-407a-9b6b-c5d86b3f3e45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "G"}], "}"}], ",",
    "\[Epsilon]", ",", "\[Sigma]", ",", "cd"}], 
  "]"}]], "Input",ExpressionUUID->"1f8f6d83-0828-414f-8db7-ac8ac4339fc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "Spin", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`Spin, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"d687571f-6d6d-46c9-b160-f13b3353006e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], ":", 
  " ", "\<\"System name \[NoBreak]\\!\\(\\\"C\\\"\\)\[NoBreak] is overloaded \
as an abstract index.\"\>"}]], "Message", \
"MSG",ExpressionUUID->"0d6b3fd2-5cea-4c60-be9b-7a9afbde2a3a"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], ":", 
  " ", "\<\"System name \[NoBreak]\\!\\(\\\"D\\\"\\)\[NoBreak] is overloaded \
as an abstract index.\"\>"}]], "Message", \
"MSG",ExpressionUUID->"c4ab274d-13ea-42b5-8432-fa586bcb1ddd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "Spin\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between Spin and \
Spin\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`Spin\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between Spin and Spin\[Dagger]"],
  Editable->
   False]], "Print",ExpressionUUID->"8984610c-feb9-4095-99d9-d89653b6436f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma][$CellContext`a, -C, -$CellContext`D\[Dagger]], ". ", 
   ""],
  Editable->
   False]], "Print",ExpressionUUID->"29a4097c-0654-4d3f-8437-5577c273ce8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[Dagger]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma]\[Dagger][$CellContext`a, -$CellContext`C\[Dagger], -
    D], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"d6c8665d-dd8d-49b7-a56f-a09e0d72e1c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"ffa054c4-70ed-4241-828d-de11e966ae34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"637a38f7-8f1f-45ab-918a-1a3812b87474"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[Sigma]", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[Sigma][$CellContext`a, $CellContext`b, \
-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"9fde8372-e057-48cd-b62b-b8200e957b55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[Sigma]\[Dagger]", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[Sigma]\[Dagger][$CellContext`a, $CellContext`b, \
-$CellContext`A\[Dagger], -$CellContext`B\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"d1977c6c-21d2-4774-ad33-f1e186c97456"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]g", "[", 
    RowBox[{"A", ",", "C\[Dagger]", ",", "B", ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor g\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]g[$CellContext`A, $CellContext`C\
\[Dagger], $CellContext`B, $CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor g"],
  Editable->
   False]], "Print",ExpressionUUID->"236c57fa-80d1-4830-be5a-1af73c84590e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]g\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "C", ",", "B\[Dagger]", ",", "D"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor g\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]g\[Dagger][$CellContext`A\[Dagger], 
    C, $CellContext`B\[Dagger], D], ". ", "Equivalent of tensor g"],
  Editable->
   False]], "Print",ExpressionUUID->"9cbfbe0f-c595-4ba5-af68-16eafa7659b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]epsilong", "[", 
    RowBox[{
    "A", ",", "A\[Dagger]", ",", "B", ",", "B\[Dagger]", ",", "C", ",", 
     "C\[Dagger]", ",", "D", ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor epsilong\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]epsilong[$CellContext`A, \
$CellContext`A\[Dagger], $CellContext`B, $CellContext`B\[Dagger], 
    C, $CellContext`C\[Dagger], D, $CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor epsilong"],
  Editable->
   False]], "Print",ExpressionUUID->"c509af99-b365-4d67-99bd-fd53a01160ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]epsilong\[Dagger]", "[", 
    RowBox[{
    "A\[Dagger]", ",", "A", ",", "B\[Dagger]", ",", "B", ",", "C\[Dagger]", ",",
      "C", ",", "D\[Dagger]", ",", "D"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor epsilong\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]epsilong\[Dagger][$CellContext`A\
\[Dagger], $CellContext`A, $CellContext`B\[Dagger], $CellContext`B, \
$CellContext`C\[Dagger], C, $CellContext`D\[Dagger], D], ". ", 
   "Equivalent of tensor epsilong"],
  Editable->
   False]], "Print",ExpressionUUID->"c7043500-95b7-45b1-af54-38b2f9941516"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"cd", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`cd[-$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"6130f4a3-b4b5-4ea7-b8a1-56e77cf8d1ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelcdCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`ChristoffelcdCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e054c40d-32cf-46c1-a1df-08808e6a621d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"AChristoffelcd", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelcd[$CellContext`A, -$CellContext`b, -C], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"a295c45a-cf37-4db8-98cb-1f062d203419"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"AChristoffelcd\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelcd\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"9c430b06-ad14-4fa3-8606-5d4d929efd24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemanncd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemanncd[-$CellContext`a, -$CellContext`b, -C, D], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->
   False]], "Print",ExpressionUUID->"820b921f-1dfb-48d5-91c5-75581914263b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemanncd\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemanncd\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->
   False]], "Print",ExpressionUUID->"2c07e7a6-35ad-421b-b15b-e8fb8afbef96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]FRiemanncd", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemanncd\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]FRiemanncd[-$CellContext`A, \
-$CellContext`A\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -C, -D], 
   ". ", "Equivalent of tensor FRiemanncd"],
  Editable->
   False]], "Print",ExpressionUUID->"64118edb-d18b-47cd-9ad5-e3f3e39b966a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]FRiemanncd\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemanncd\[Dagger]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]FRiemanncd\[Dagger][-$CellContext`A\
\[Dagger], -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, \
-$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor FRiemanncd\[Dagger]"],
  Editable->
   False]], "Print",ExpressionUUID->"ce968fc9-0118-4078-b1a3-7dc23e9de536"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Chicd", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Chicd[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"d1e713a8-0a6f-4f98-8b85-efe64c503027"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Chicd\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Chicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"d18e6edf-9814-41d3-87e0-6aecc3a2dc29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Phicd", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Phicd[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"3c9add3a-ba1d-4ab8-b982-5bf2ca0f8a91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Phicd\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Phicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -C, -D], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"5267bfc4-dc24-48f7-952e-0f77f1409d62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor scalar curvature \"\>", "\[InvisibleSpace]", 
   RowBox[{"Lambdacd", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "spinor scalar curvature ", 
   $CellContext`Lambdacd[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"159b7759-5c4d-4b35-aa30-9b9438d53390"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Psicd", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl spinor ", 
   $CellContext`Psicd[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"b999c364-4309-4d62-90de-09c880c339f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Psicd\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl spinor ", 
   $CellContext`Psicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"afbc2bf5-bcc1-4fe5-830a-c6c87125adca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RiemannCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]RiemannCD[-$CellContext`A, \
-$CellContext`A\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor RiemannCD"],
  Editable->
   False]], "Print",ExpressionUUID->"c8a94bd7-71ba-4741-aa92-8d4d2c12a52d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]RiemannCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RiemannCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]RiemannCD\[Dagger][-$CellContext`A\
\[Dagger], -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, \
-$CellContext`C\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", 
   "Equivalent of tensor RiemannCD"],
  Editable->
   False]], "Print",ExpressionUUID->"bd607d8b-75f1-4883-8f91-2afadc34f1fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]RicciCD[-$CellContext`A, \
-$CellContext`A\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", 
   "Equivalent of tensor RicciCD"],
  Editable->
   False]], "Print",ExpressionUUID->"ae821c52-943f-46e5-811b-049d5ed3d248"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]RicciCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]RicciCD\[Dagger][-$CellContext`A\
\[Dagger], -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor RicciCD"],
  Editable->
   False]], "Print",ExpressionUUID->"be42f3a5-8e31-4d69-abe3-fe337219e84b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor WeylCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]WeylCD[-$CellContext`A, \
-$CellContext`A\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor WeylCD"],
  Editable->
   False]], "Print",ExpressionUUID->"493df82f-7afd-4f8b-bf87-4aa3f6a680b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]WeylCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor WeylCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]WeylCD\[Dagger][-$CellContext`A\
\[Dagger], -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, \
-$CellContext`C\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", 
   "Equivalent of tensor WeylCD"],
  Editable->
   False]], "Print",ExpressionUUID->"30d2a147-8a4a-4d58-a5d8-7dcb4114362b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor TFRicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]TFRicciCD[-$CellContext`A, \
-$CellContext`A\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", 
   "Equivalent of tensor TFRicciCD"],
  Editable->
   False]], "Print",ExpressionUUID->"68742dc7-8e0a-476d-8470-f958f720b8f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[UnderBracket]TFRicciCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor TFRicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]\[UnderBracket]TFRicciCD\[Dagger][-$CellContext`A\
\[Dagger], -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor TFRicciCD"],
  Editable->
   False]], "Print",ExpressionUUID->"00ddf2f3-f620-4a9b-a898-fa8369ae3235"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Compare with formula 3.4.57 of Penrose and Rindler . This is their tensor \
U[-a,-b,c,d]:\
\>", "Text",ExpressionUUID->"caf8ce61-3c59-4aa0-afc8-f86be53526be"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"U", "[", 
   RowBox[{
    RowBox[{"-", "a_"}], ",", 
    RowBox[{"-", "b_"}], ",", "c_", ",", "d_"}], "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Epsilon]", "[", 
      RowBox[{
       RowBox[{"-", "A"}], ",", "D"}], "]"}], 
     RowBox[{"\[Epsilon]", "[", 
      RowBox[{
       RowBox[{"-", "B"}], ",", "C"}], "]"}], 
     RowBox[{"\[Epsilon]\[Dagger]", "[", 
      RowBox[{
       RowBox[{"-", "A\[Dagger]"}], ",", "C\[Dagger]"}], "]"}], 
     RowBox[{"\[Epsilon]\[Dagger]", "[", 
      RowBox[{
       RowBox[{"-", "B\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
     RowBox[{"\[Sigma]", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", "A", ",", "A\[Dagger]"}], "]"}], 
     RowBox[{"\[Sigma]", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "B", ",", "B\[Dagger]"}], "]"}], 
     RowBox[{"\[Sigma]", "[", 
      RowBox[{"c", ",", 
       RowBox[{"-", "C"}], ",", 
       RowBox[{"-", "C\[Dagger]"}]}], "]"}], 
     RowBox[{"\[Sigma]", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "D"}], ",", 
       RowBox[{"-", "D\[Dagger]"}]}], "]"}]}], "//", 
    "ContractSolderingForm"}], "//", 
   "ToCanonical"}]}]], \
"Input",ExpressionUUID->"a76f751f-6a58-48d9-a667-e2b9add1c53b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"Gg", 
      StyleBox[GridBox[{
         {" ", "d", " ", "c"},
         {"a", " ", "b", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Tetrag[-$CellContext`a, $CellContext`d, -$CellContext`b, \
$CellContext`c],
  Editable->
   False]], "Output",ExpressionUUID->"653a4302-d3d7-49d8-a852-7caf32a71462"]
}, Open  ]],

Cell["This formula is identical to theirs:", \
"Text",ExpressionUUID->"78886645-bee9-4bca-8ced-263aa7aa2336"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"TetraRule", "[", "g", "]"}]}], "//", 
  "ToCanonical"}]], \
"Input",ExpressionUUID->"ef718560-829c-47fb-80c1-729c8a4aee38"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "d"},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`a, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "c"},
           {"b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`b, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "c"},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "d"},
           {"b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`b, $CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]g", 
        StyleBox[GridBox[{
           {" ", " ", "c", "d"},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilong[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"5dfc6dfe-ffff-4b49-9710-60fdaf6804c8"]
}, Open  ]],

Cell["This is their formula 3.4.66 :", \
"Text",ExpressionUUID->"17f4a67f-a929-4d21-858f-af06c0cdc7df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"U", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], 
     RowBox[{"U", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "e", ",", "f"}], "]"}]}], "/.", 
    RowBox[{"TetraRule", "[", "g", "]"}]}], "//", "ContractMetric"}], "//", 
  "ToCanonical"}]], \
"Input",ExpressionUUID->"ab1f91cf-3bbf-45a2-a865-1d02649158a9"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Delta]", 
       StyleBox[GridBox[{
          {" ", "e"},
          {"a", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`delta[-$CellContext`a, $CellContext`e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Delta]", 
       StyleBox[GridBox[{
          {" ", "f"},
          {"b", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
   Editable->
    False]}]], "Output",ExpressionUUID->"e9971644-8c68-4dda-ae8f-8c38b1f007b8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Remove", "[", "U", "]"}], 
  ";"}]], "Input",ExpressionUUID->"589e2018-c06d-4c48-843d-c7f94ed12d4f"],

Cell["3) Define spinors and their tensor equivalents :", "Text",
 CellChangeTimes->{{3.426774354259777*^9, 3.426774366102375*^9}},
 FontWeight->"Bold",ExpressionUUID->"a384a75b-7143-491d-8cd4-3f50806a8007"],

Cell["\<\
We define a spinor (note that we do not need to add the option \
Dagger->Complex; this is introduced by DefSpinor):\
\>", "Text",
 CellChangeTimes->{{3.425962412461544*^9, 3.4259624158759108`*^9}, {
  3.426774310811953*^9, 
  3.4267743394897947`*^9}},ExpressionUUID->"d1f58452-f509-4bc9-99cb-\
2d26fd62970f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Kappa]", "[", 
    RowBox[{"A", ",", "A\[Dagger]"}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.414414441563696*^9, 3.4144144599671926`*^9}, {
  3.4191555109126177`*^9, 3.419155514283029*^9}, {3.425204129839877*^9, 
  3.425204136516781*^9}, {3.425962418237583*^9, 3.425962420169031*^9}, {
  3.426774305100388*^9, 
  3.426774305388638*^9}},ExpressionUUID->"5efff045-b0cc-4d95-b16c-\
dd6942f50911"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]", "[", 
    RowBox[{"A", ",", "A\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Kappa][$CellContext`A, $CellContext`A\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"16f7736f-7f8a-481e-a8ae-43aac4bc3476"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "A"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Kappa]\[Dagger][$CellContext`A\[Dagger], $CellContext`A], 
   ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"c65655d2-d0e7-4abc-89d1-deb8479cfad2"]
}, Open  ]]
}, Open  ]],

Cell["Some other checks :", "Text",
 CellChangeTimes->{{3.4267744952863083`*^9, 
  3.426774502860832*^9}},ExpressionUUID->"25ab472d-e0d7-49ca-83cc-\
e87e6d48196c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"DefSpinor", "[", 
   RowBox[{
    RowBox[{"test", "[", 
     RowBox[{"A", ",", "B", ",", "C\[Dagger]"}], "]"}], ",", "M4", ",", 
    RowBox[{"Symmetric", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.426774385041313*^9, 
  3.426774412137321*^9}},ExpressionUUID->"0d24633a-00a6-4994-95e1-\
f9e877b67424"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"DefTensor", "::", "wrongsym"}], "MessageName"], ":", 
  " ", "\<\"Symmetry properties are inconsistent with indices of \
tensor.\"\>"}]], "Message", \
"MSG",ExpressionUUID->"5ea55470-3cb5-4427-890f-a2e30070621e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"test", "[", 
    RowBox[{"A", ",", "B", ",", "C\[Dagger]", ",", "D\[Dagger]"}], "]"}], ",",
    "M4", ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"5eb012b4-20b2-4b39-a3f2-47757e885e14"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"test", "[", 
    RowBox[{"A", ",", "B", ",", "C\[Dagger]", ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`test[$CellContext`A, $CellContext`B, $CellContext`C\[Dagger], \
$CellContext`D\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"cdda6b4d-70f5-4b0d-a7e0-497d313af10c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"test\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "B\[Dagger]", ",", "C", ",", "D"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`test\[Dagger][$CellContext`A\[Dagger], \
$CellContext`B\[Dagger], C, D], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"c0e362f8-fb4e-42a6-a549-8eedeb9af810"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefSpinor", "[", "test", "]"}]], "Input",
 CellChangeTimes->{{3.42677448481357*^9, 
  3.426774488527809*^9}},ExpressionUUID->"5f51f935-4969-41a9-8fbc-\
4946da0038d2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "test\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`test\[Dagger]],
  Editable->
   False]], "Print",ExpressionUUID->"1c4c7906-5e3f-4815-b637-a9820c956cf1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"spinor\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "test"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "spinor", 
   " ", $CellContext`test],
  Editable->
   False]], "Print",ExpressionUUID->"c5593b71-079c-4244-a5e7-30697b79901a"]
}, Open  ]]
}, Open  ]],

Cell["\<\
The \[Kappa] spinor has a tensorial equivalent, which is complex and hence \
defines its conjugate. We can choose an arbitrary name for it:\
\>", "Text",
 CellChangeTimes->{{3.425962462848373*^9, 3.4259624724393663`*^9}, {
  3.426535992920632*^9, 3.4265360071559963`*^9}, {3.4267745172824097`*^9, 
  3.4267745422178392`*^9}},ExpressionUUID->"8cffe61f-c15f-4671-939c-\
ff88f17f6c70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensorOfSpinor", "[", 
  RowBox[{
   RowBox[{"KT", "[", "a", "]"}], ",", 
   RowBox[{"\[Kappa]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", "A\[Dagger]"}], "]"}], ",", "\[Sigma]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.425278409437641*^9, 3.42527844993666*^9}, {
   3.425278633017295*^9, 3.4252786693058233`*^9}, {3.425299006855914*^9, 
   3.4252990303550863`*^9}, {3.425359353729491*^9, 3.425359360303186*^9}, 
   3.431845248876176*^9},ExpressionUUID->"51bf063e-9784-4646-87c5-\
4bda49054bca"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"KT", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of spinor \[Kappa]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`KT[$CellContext`a], ". ", "Equivalent of spinor \[Kappa]"],
  Editable->
   False]], "Print",ExpressionUUID->"feb2bc7e-7a24-427c-be7f-216fe8f3bf9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"KT\[Dagger]", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of spinor \[Kappa]\[Dagger]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`KT\[Dagger][$CellContext`a], ". ", 
   "Equivalent of spinor \[Kappa]\[Dagger]"],
  Editable->
   False]], "Print",ExpressionUUID->"dfede5f5-144b-43ee-8002-ff3a65825eaa"]
}, Open  ]]
}, Open  ]],

Cell["Note the following relations, all having \[Sigma] and not \[Sigma]\
\[Dagger] :", "Text",
 CellChangeTimes->{{3.426774679634939*^9, 
  3.4267747039524918`*^9}},ExpressionUUID->"621f4729-4c13-4fc0-81e7-\
f37269afbd9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TensorOfSpinor", "[", 
  RowBox[{"\[Kappa]", ",", "\[Sigma]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4267746112307568`*^9, 
  3.42677462015403*^9}},ExpressionUUID->"c869e7f5-cdbe-4b0c-b952-\
1c784f27fb6c"],

Cell[BoxData["KT"], \
"Output",ExpressionUUID->"6b8819d2-10ca-4ee4-8424-1cdb7c31a72a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TensorOfSpinor", "[", 
  RowBox[{"\[Kappa]\[Dagger]", ",", "\[Sigma]"}], "]"}]], "Input",
 CellChangeTimes->{{3.42677462221544*^9, 
  3.426774632620419*^9}},ExpressionUUID->"cfc0db08-159e-4c99-92d7-\
77d1ce1f683c"],

Cell[BoxData["KT\[Dagger]"], \
"Output",ExpressionUUID->"b68006df-5d31-4d5b-a039-9552e4cffc2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorOfTensor", "[", 
  RowBox[{"KT", ",", "\[Sigma]"}], "]"}]], "Input",
 CellChangeTimes->{{3.42677464690571*^9, 
  3.426774656697178*^9}},ExpressionUUID->"45f8b93f-54fe-41a3-8f36-\
ef196f6189da"],

Cell[BoxData["\[Kappa]"], \
"Output",ExpressionUUID->"c48f1cf6-eab3-4730-bf9e-415aab6d8142"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorOfTensor", "[", 
  RowBox[{"KT\[Dagger]", ",", "\[Sigma]"}], "]"}]], "Input",
 CellChangeTimes->{{3.426774658418861*^9, 
  3.4267746687454433`*^9}},ExpressionUUID->"054c20ed-4ccb-4c73-bd2a-\
2f6d7f8e5c0f"],

Cell[BoxData["\[Kappa]\[Dagger]"], \
"Output",ExpressionUUID->"3c6733ef-99f0-46b0-80fc-30f5121a0901"]
}, Open  ]],

Cell["\<\
Note that we shall be using the default choice of PrintAs form :\
\>", "Text",ExpressionUUID->"fe0c979f-1ad3-4fd4-9493-0dabd23fa25e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrintAs", "[", "KT", "]"}]], "Input",
 CellChangeTimes->{{3.426779471544621*^9, 
  3.426779474637569*^9}},ExpressionUUID->"1145d2fb-9708-4b33-aa86-\
ead36d327794"],

Cell[BoxData["\<\"\[Sigma]\[Kappa]\"\>"], \
"Output",ExpressionUUID->"913ebe3b-56e4-4d35-afc8-535d1254919c"]
}, Open  ]],

Cell["\<\
This is formula 3.3.31 of Penrose and Rindler, with the same sign convention:\
\
\>", "Text",ExpressionUUID->"ee637159-8690-4afe-b724-e697e7ea21ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"epsilong", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}]}], "]"}], "//", 
  RowBox[{
  "SeparateSolderingForm", "[", 
   "]"}]}]], "Input",ExpressionUUID->"4b8bb770-4285-401d-86e4-ce1091f06bde"],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A", "C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`A, -C],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"B", "D"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`B, -D],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]\[Dagger]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A\[Dagger]", "D\[Dagger]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]\[Dagger]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"B\[Dagger]", "C\[Dagger]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A", "D"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`A, -D],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"B", "C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`B, -C],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]\[Dagger]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A\[Dagger]", "C\[Dagger]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]\[Dagger]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"B\[Dagger]", "D\[Dagger]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
      Editable->False]}]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", "B\[Dagger]"},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "C", "C\[Dagger]"},
          {"c", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "D", "D\[Dagger]"},
          {"d", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`d, D, $CellContext`D\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"7ab19060-e1bb-4dd7-8d24-322bddcef1e7"]
}, Open  ]],

Cell["4) Pairs of conjugated indices :", "Text",
 CellChangeTimes->{{3.426778597964862*^9, 3.426778604855754*^9}},
 FontWeight->"Bold",ExpressionUUID->"58a6ad79-b9d9-45ce-b2aa-3826c1233fe8"],

Cell[TextData[{
 "This is the private function in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " in charge of deciding which indices are paired :"
}], "Text",
 CellChangeTimes->{{3.4267788676092997`*^9, 
  3.42677888779953*^9}},ExpressionUUID->"ade3ba5e-4090-47f3-a156-\
738da38da96e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xTensor`Private`TransposeDaggerPairs", "[", 
  RowBox[{"\[Kappa]", "[", 
   RowBox[{"A", ",", "B", ",", "C\[Dagger]", ",", "D\[Dagger]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.426778772528646*^9, 
  3.4267788116600113`*^9}},ExpressionUUID->"1c0ef9f2-9c71-4262-8998-\
c98eba026bf0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"Pair", "[", 
      RowBox[{"A", ",", "C\[Dagger]"}], "]"}], ",", "\[ThinSpace]", 
     RowBox[{"Pair", "[", 
      RowBox[{"B", ",", "D\[Dagger]"}], "]"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[
   xAct`xTensor`Pair[$CellContext`A, $CellContext`C\[Dagger]], 
   xAct`xTensor`Pair[$CellContext`B, $CellContext`D\[Dagger]]],
  Editable->
   False]], "Output",ExpressionUUID->"80572c83-d2f9-4ad1-9b1a-8ed3ebd5a0ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.426787698260085*^9, 
  3.4267877038357773`*^9}},ExpressionUUID->"901a8012-6bb7-4ae6-9122-\
baf8a2fbafae"],

Cell["IndexList[Pair[A, C\[Dagger]], Pair[B, D\[Dagger]]]", \
"Output",ExpressionUUID->"c4b7f4e7-27c0-4e76-abbd-d4ceab3edf37"]
}, Open  ]],

Cell["\<\
By default it throws an error when the numbers of indices do not coincide :\
\>", "Text",
 CellChangeTimes->{{3.426778897813272*^9, 
  3.426778918286462*^9}},ExpressionUUID->"caf90b33-ceb8-4f04-9726-\
25d31c51bddf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"xAct`xTensor`Private`TransposeDaggerPairs", "[", 
   RowBox[{"\[Kappa]", "[", 
    RowBox[{"A", ",", "B", ",", "C\[Dagger]", ",", "D\[Dagger]", ",", "F"}], 
    "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.426778772528646*^9, 
  3.426778833991618*^9}},ExpressionUUID->"c3b95143-fee9-4d7b-9d96-\
2eeaf053f252"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"TransposeDagger", "::", "error3"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"Different number of indices of\\\"\\)\
\[NoBreak] \[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\\"Spin\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], Spin, Rule[Editable, \
False]]\\)\[NoBreak] \[NoBreak]\\!\\(\\\"and its conjugate\\\"\\)\[NoBreak] \
\[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\\"Spin\[Dagger]\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], Spin\\\\[Dagger], \
Rule[Editable, False]]\\)\[NoBreak]\"\>"}]], "Message", \
"MSG",ExpressionUUID->"ed54d699-1e2e-4843-a0b8-36aaaa6208f2"]
}, Open  ]],

Cell["\<\
However, that feature can be deactivated, and then one of the lists is \
shortened :\
\>", "Text",
 CellChangeTimes->{{3.426778922796702*^9, 
  3.426778950156597*^9}},ExpressionUUID->"6d5af979-bb7e-4913-b608-\
cc47870eae60"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xTensor`Private`TransposeDaggerPairs", "[", 
  RowBox[{
   RowBox[{"\[Kappa]", "[", 
    RowBox[{"A", ",", "B", ",", "C\[Dagger]", ",", "D\[Dagger]", ",", "F"}], 
    "]"}], ",", "Spin", ",", "False"}], "]"}]], "Input",
 CellChangeTimes->{{3.426778772528646*^9, 3.426778857901615*^9}, {
  3.461421281923307*^9, 
  3.4614212830199213`*^9}},ExpressionUUID->"2a27d103-5015-4fc3-a32b-\
b3e70d6a5a12"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"Pair", "[", 
      RowBox[{"A", ",", "C\[Dagger]"}], "]"}], ",", "\[ThinSpace]", 
     RowBox[{"Pair", "[", 
      RowBox[{"B", ",", "D\[Dagger]"}], "]"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[
   xAct`xTensor`Pair[$CellContext`A, $CellContext`C\[Dagger]], 
   xAct`xTensor`Pair[$CellContext`B, $CellContext`D\[Dagger]]],
  Editable->
   False]], "Output",ExpressionUUID->"c2272d7c-989b-4897-a52e-ed336b15fd44"]
}, Open  ]],

Cell["\<\
For this function, the order between dagger and nondaggered indices is \
irrelevant. It only matters the order within each set :\
\>", "Text",
 CellChangeTimes->{{3.426778988260144*^9, 
  3.42677903003512*^9}},ExpressionUUID->"802deb9f-6302-400a-b297-\
cbb87ef85cf3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xTensor`Private`TransposeDaggerPairs", "[", 
  RowBox[{"\[Kappa]", "[", 
   RowBox[{"C\[Dagger]", ",", "A", ",", "D\[Dagger]", ",", "B"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.426778772528646*^9, 3.4267788116600113`*^9}, {
  3.4267789740006933`*^9, 3.426778981956505*^9}, {3.426779066764813*^9, 
  3.4267790690867853`*^9}},ExpressionUUID->"1b46e261-b67a-4e14-a145-\
095afdf0a28f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"Pair", "[", 
      RowBox[{"A", ",", "C\[Dagger]"}], "]"}], ",", "\[ThinSpace]", 
     RowBox[{"Pair", "[", 
      RowBox[{"B", ",", "D\[Dagger]"}], "]"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[
   xAct`xTensor`Pair[$CellContext`A, $CellContext`C\[Dagger]], 
   xAct`xTensor`Pair[$CellContext`B, $CellContext`D\[Dagger]]],
  Editable->
   False]], "Output",ExpressionUUID->"257be0ce-631c-41fd-a19c-29db15e6f685"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xTensor`Private`TransposeDaggerPairs", "[", 
  RowBox[{"\[Kappa]", "[", 
   RowBox[{"B", ",", "C\[Dagger]", ",", "D\[Dagger]", ",", "A"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.426778772528646*^9, 3.4267788116600113`*^9}, {
  3.4267789740006933`*^9, 3.426778981956505*^9}, {3.426779047762595*^9, 
  3.4267790496013517`*^9}},ExpressionUUID->"0a02aba0-63e9-4cf5-9961-\
712c87173366"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"Pair", "[", 
      RowBox[{"B", ",", "C\[Dagger]"}], "]"}], ",", "\[ThinSpace]", 
     RowBox[{"Pair", "[", 
      RowBox[{"A", ",", "D\[Dagger]"}], "]"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[
   xAct`xTensor`Pair[$CellContext`B, $CellContext`C\[Dagger]], 
   xAct`xTensor`Pair[$CellContext`A, $CellContext`D\[Dagger]]],
  Editable->
   False]], "Output",ExpressionUUID->"6640809a-989f-40dc-9c79-4a0f393e6467"]
}, Open  ]],

Cell["\<\
Note that daggered indices are always sorted last in the pairs:\
\>", "Text",
 CellChangeTimes->{{3.426779166590979*^9, 3.426779216095941*^9}, {
  3.4267917898503523`*^9, 
  3.426791790720173*^9}},ExpressionUUID->"5c351c8f-266a-4b70-8d48-\
2301f7f27658"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetIndicesOfVBundle", "[", 
  RowBox[{"Spin", ",", "20"}], "]"}]], "Input",
 CellChangeTimes->{{3.426779118312295*^9, 
  3.426779125941704*^9}},ExpressionUUID->"6e4264bd-1d77-4dda-97c1-\
2a59b97d330e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "G", ",", "G1", ",", "G2",
    ",", "G3", ",", "G4", ",", "G5", ",", "G6", ",", "G7", ",", "G8", ",", 
   "G9", ",", "G10", ",", "G11", ",", "G12", ",", "G13", ",", "G14"}], 
  "}"}]], "Output",ExpressionUUID->"c39befc1-ad76-4de0-a00a-e303ee92ac04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xTensor`Private`TransposeDaggerPairs", "[", 
  RowBox[{"\[Kappa]", "[", 
   RowBox[{"G\[Dagger]", ",", "G14", ",", "C\[Dagger]", ",", "D"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.426778772528646*^9, 3.4267788116600113`*^9}, {
  3.4267789740006933`*^9, 3.426778981956505*^9}, {3.426779066764813*^9, 
  3.426779139346714*^9}},ExpressionUUID->"a38d9933-0244-4107-a344-\
8b288e97efd6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"Pair", "[", 
      RowBox[{"G14", ",", "G\[Dagger]"}], "]"}], ",", "\[ThinSpace]", 
     RowBox[{"Pair", "[", 
      RowBox[{"D", ",", "C\[Dagger]"}], "]"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[
   xAct`xTensor`Pair[$CellContext`G14, $CellContext`G\[Dagger]], 
   xAct`xTensor`Pair[D, $CellContext`C\[Dagger]]],
  Editable->
   False]], "Output",ExpressionUUID->"edc96c2d-00e2-43c7-b4f2-0c80642c9083"]
}, Open  ]],

Cell["5) Manipulations with the soldering - form :", "Text",
 CellChangeTimes->{{3.42677923884161*^9, 3.426779247001822*^9}, {
  3.4272323066360073`*^9, 3.42723230765436*^9}},
 FontWeight->"Bold",ExpressionUUID->"6a2712ca-3ad4-4b0e-bbcf-024a7c7e91ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{"\[Kappa]", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.425299118907699*^9, 3.425299127266512*^9}, {
  3.4267795354437027`*^9, 
  3.426779536318115*^9}},ExpressionUUID->"2962426c-3f55-45f7-87fe-\
8b19342991c9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Kappa]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"A", "A\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
  Editable->
   False]], "Output",ExpressionUUID->"55aa7a2c-a2e5-484b-8fb9-5b3aa6951efb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.42679180991815*^9, 3.426791819599113*^9}, {
  3.4267918528040447`*^9, 3.4267918905450563`*^9}, {3.426792081166444*^9, 
  3.4267920897185287`*^9}},ExpressionUUID->"2cb840bb-f829-4a74-8b65-\
e02e3457cf8d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Kappa]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"d8b94373-4f9e-40d7-b962-fbc775736467"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.425299161802443*^9, 3.425299167802252*^9}, {
  3.4267795610589447`*^9, 
  3.426779569231512*^9}},ExpressionUUID->"12ebd9d1-fc72-406c-8f46-\
1e06168b283f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Sigma]\[Kappa]", 
      StyleBox[GridBox[{
         {" "},
         {"a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`KT[-$CellContext`a],
  Editable->
   False]], "Output",ExpressionUUID->"d9722de9-66fd-495f-85ab-5d96f5d01945"]
}, Open  ]],

Cell["\<\
We can also use  many other structures in the second argument:\
\>", "Text",
 CellChangeTimes->{{3.426792109504732*^9, 
  3.426792143510882*^9}},ExpressionUUID->"ddb60dc5-1ad9-487f-9a1e-\
ea8299417b45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.42679180991815*^9, 3.426791819599113*^9}, {
  3.4267918528040447`*^9, 3.4267918905450563`*^9}, {3.426792081166444*^9, 
  3.426792127507332*^9}},ExpressionUUID->"7e39b0a6-be86-4962-a5ad-\
4840d28caea4"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Kappa]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"a80705cf-683a-4acf-8aac-0ef7ff5e2058"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"expr", ",", "Spin"}], "]"}]], "Input",
 CellChangeTimes->{{3.42679180991815*^9, 3.426791819599113*^9}, {
  3.4267918528040447`*^9, 3.4267918905450563`*^9}, {3.426792081166444*^9, 
  3.426792127507332*^9}, {3.426792211066641*^9, 
  3.426792211662662*^9}},ExpressionUUID->"0388b45d-ed43-4928-85cc-\
3a99fb094884"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Kappa]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"b68358d6-be8d-45d8-a61d-06309df085d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"expr", ",", "\[Kappa]"}], "]"}]], "Input",
 CellChangeTimes->{{3.42679180991815*^9, 3.426791819599113*^9}, {
  3.4267918528040447`*^9, 3.4267918905450563`*^9}, {3.426792081166444*^9, 
  3.426792127507332*^9}, {3.426792211066641*^9, 
  3.426792218960907*^9}},ExpressionUUID->"3d5536f2-6570-4cad-9c97-\
bdc09399a6c6"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Kappa]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"2c85e2e9-cee9-482a-ad3d-e2def047f58d"]
}, Open  ]],

Cell["\<\
We assume that Pair always has the non - daggered index first, even when that \
is not the order in the expression:\
\>", "Text",
 CellChangeTimes->{{3.426792185965824*^9, 3.4267921987465773`*^9}, {
  3.4267922390071983`*^9, 
  3.426792252811816*^9}},ExpressionUUID->"870d661a-b769-46df-9251-\
6870e4979a0c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.42679180991815*^9, 3.426791819599113*^9}, {
  3.4267918528040447`*^9, 3.4267918905450563`*^9}, {3.426792081166444*^9, 
  3.4267921479660997`*^9}},ExpressionUUID->"7d54029d-4d4b-49b8-b33a-\
8b63da8d3297"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Kappa]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"A", "A\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
  Editable->
   False]], "Output",ExpressionUUID->"20cf29e5-16d0-45fa-a238-44c9697bc44b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{
   RowBox[{"Dagger", "[", "expr", "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.42679180991815*^9, 3.426791819599113*^9}, {
  3.4267918528040447`*^9, 3.4267918905450563`*^9}, {3.426792081166444*^9, 
  3.426792173842667*^9}},ExpressionUUID->"15083e6c-65a6-4eef-8bcd-\
f6bab519abe8"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Kappa]\[Dagger]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A\[Dagger]", "A"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Kappa]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"9128f1a3-af6e-4550-8d92-9d179bf1303d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.426779372832919*^9, 3.426779383575626*^9}, {
  3.426779546653639*^9, 3.42677954790434*^9}, {3.426793965690337*^9, 
  3.426793970493499*^9}, {3.426794056859223*^9, 3.426794059884184*^9}, {
  3.4267941363453293`*^9, 
  3.4267941384565687`*^9}},ExpressionUUID->"fb888908-13ef-4213-b817-\
609a4787fa41"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]\[Kappa]", 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`KT[-$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"be3a31d0-91dc-4375-99fe-835e42f68c2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.426779551619502*^9, 
  3.4267795575454693`*^9}},ExpressionUUID->"20b199ee-d9cc-4099-9150-\
3aae58f52fa7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Kappa]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"A", "A\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
  Editable->
   False]], "Output",ExpressionUUID->"7d871b9b-cf4c-46dd-8264-41dbb2a6345e"]
}, Open  ]],

Cell["\<\
It is possible to contract the soldering form on daggered expressions:\
\>", "Text",
 CellChangeTimes->{{3.4265360851136827`*^9, 3.4265361380496397`*^9}, {
  3.4265370395671988`*^9, 3.426537071720397*^9}, {3.426780161595943*^9, 
  3.4267801771259108`*^9}},ExpressionUUID->"a9752906-82ac-422c-8f5e-\
8a40f01e99c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{"\[Kappa]\[Dagger]", "[", 
   RowBox[{
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4265360245699253`*^9, 3.4265360341657057`*^9}, {
  3.4267795810775337`*^9, 3.426779582096868*^9}, {3.426779864877492*^9, 
  3.426779865319578*^9}},ExpressionUUID->"1e963def-e986-417c-982e-\
681b4f77a962"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Kappa]\[Dagger]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"A\[Dagger]", "B"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Kappa]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B],
  Editable->
   False]], "Output",ExpressionUUID->"21bb539b-d442-47f5-b207-3c4ea25dc61e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.426536036632094*^9, 3.426536045537076*^9}, {
  3.426794156104095*^9, 
  3.4267941618943377`*^9}},ExpressionUUID->"29948c6e-2123-4367-9fd7-\
fe5d455424c9"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Kappa]\[Dagger]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A\[Dagger]", "A"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Kappa]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"3829c8d0-d603-4f9c-9462-a2a3ccbb9479"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.426536054896742*^9, 
  3.42653606015207*^9}},ExpressionUUID->"e960e32e-0a50-4982-bc6d-\
e6edd6e6ed10"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Sigma]\[Kappa]\[Dagger]", 
      StyleBox[GridBox[{
         {" "},
         {"a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`KT\[Dagger][-$CellContext`a],
  Editable->
   False]], "Output",ExpressionUUID->"f90259a5-0cfe-4293-8508-679188f7cb17"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.42679417460227*^9, 
  3.426794184335227*^9}},ExpressionUUID->"4b3a5f55-f13c-43b4-96fa-\
6d411ab2a4c9"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]\[Kappa]\[Dagger]", 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`KT\[Dagger][-$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "B", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, -$CellContext`A\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"2043bb61-70a5-4727-a9d8-af93acfedc45"]
}, Open  ]],

Cell["6) Define tensors and their spinor equivalents :", "Text",
 CellChangeTimes->{{3.426780270949007*^9, 3.426780279619289*^9}},
 FontWeight->"Bold",ExpressionUUID->"376b0060-d2df-410f-9bbe-3fe0b8581999"],

Cell["We define now a complex tensor.", "Text",
 CellChangeTimes->{{3.425962944632001*^9, 3.425962949904059*^9}, 
   3.425962989712061*^9},ExpressionUUID->"ac0eee2e-fe1b-454d-9116-\
25a8beb66148"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"t", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.425290885058675*^9, 
  3.425290899697256*^9}},ExpressionUUID->"d675af05-d388-4f56-a270-\
fbbb5d280c55"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"t", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`t[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e5f2ec8a-cea4-42b3-bdd9-d6f094a44a4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"t\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`t\[Dagger][-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e9dd7aa1-d4b5-411f-a7c0-e55eab4c0463"]
}, Open  ]]
}, Open  ]],

Cell["This tensor has a spinor counterpart.", "Text",
 CellChangeTimes->{{3.425962978160163*^9, 
  3.425962991904513*^9}},ExpressionUUID->"6b740dc6-8fa1-4aff-a470-\
72e0e455312d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinorOfTensor", "[", 
  RowBox[{
   RowBox[{"\[Sigma]t", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", 
   RowBox[{"t", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "\[Sigma]"}], "]"}]], "Input",
 CellChangeTimes->{{3.42529035995654*^9, 3.425290409467391*^9}, {
   3.4252907610484467`*^9, 3.425290765659245*^9}, {3.4252909081537123`*^9, 
   3.425290914435714*^9}, {3.425290973891951*^9, 3.425290996530357*^9}, {
   3.425298290346054*^9, 3.425298304649583*^9}, 
   3.4253593972566757`*^9},ExpressionUUID->"f3a3201b-52a6-4891-a259-\
a678ab8bc56e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]t", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor t\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]t[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]], ". ", "Equivalent of tensor t"],
  Editable->
   False]], "Print",ExpressionUUID->"78f094b1-c25d-4a02-b6e3-1b064cb3dbcc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]t\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor t\[Dagger]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Sigma]t\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A, \
-$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor t\[Dagger]"],
  Editable->
   False]], "Print",ExpressionUUID->"958204e0-f75e-427d-888a-e9ec0b09f303"]
}, Open  ]]
}, Open  ]],

Cell["Now we check that everything works as it should", "Text",
 CellChangeTimes->{{3.4259633047949133`*^9, 
  3.425963331144106*^9}},ExpressionUUID->"fb36e5dc-d766-406b-a826-\
d0b790d60bfc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.425359418255251*^9, 
  3.42535942058307*^9}},ExpressionUUID->"a04c7809-dd18-43e4-905a-\
88a956b6c281"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"t", 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`t[-$CellContext`a, -$CellContext`b],
  Editable->
   False]], "Output",ExpressionUUID->"759ccb4b-e860-44e7-b9e0-08d7b2be8698"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.4253594361765203`*^9, 3.425359444062418*^9}, {
  3.426794206397979*^9, 
  3.426794208650443*^9}},ExpressionUUID->"0d32702d-cfea-46c3-9275-\
f8920d6ba33c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"t", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`t[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"1de3d08a-0ff3-4633-ab32-0057f94b2957"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "C\[Dagger]"}]}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"b", ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "D\[Dagger]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.426526190055141*^9, 
  3.42652620748673*^9}},ExpressionUUID->"b50317bc-5502-4688-85b1-\
4023b84047aa"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"t", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`t[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", "C\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`C\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", "D\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`D\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"07675afb-d638-4983-863b-d646a3a4ba38"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", 
  "%"}]], "Input",ExpressionUUID->"b87b3c20-be3a-4455-b6e0-e53f6f23f214"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Sigma]t", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"A", "C\[Dagger]", "B", "D\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Sigma]t[-$CellContext`A, -$CellContext`C\[Dagger], \
-$CellContext`B, -$CellContext`D\[Dagger]],
  Editable->
   False]], "Output",ExpressionUUID->"13f1f066-34f7-4df6-8333-a9da70a9a3fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{
   RowBox[{"SeparateSolderingForm", "[", "]"}], "[", "%", "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.426523993833537*^9, 3.42652401377345*^9}, {
  3.4265246810705976`*^9, 3.4265246912442007`*^9}, {3.426524839142626*^9, 
  3.426524840300157*^9}, {3.426525778861786*^9, 3.426525781162586*^9}, {
  3.42652621751108*^9, 3.4265262178877773`*^9}, {3.426528202916745*^9, 
  3.426528205833602*^9}},ExpressionUUID->"1d403543-7ee3-4841-83fd-\
74ac32c5bede"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"t\[Dagger]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`t\[Dagger][-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "C", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -C, -$CellContext`A\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "D", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -D, -$CellContext`B\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"8bd62de1-fe74-489d-92fc-5ffc07749ae4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", 
  RowBox[{"Dagger", "[", "%%", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.426525796599042*^9, 3.426525800826784*^9}, {
  3.4265262254687757`*^9, 3.426526225863871*^9}, {3.4265277616208773`*^9, 
  3.426527761833643*^9}, {3.426528138717058*^9, 3.426528139797024*^9}, {
  3.426528213944213*^9, 
  3.426528223860609*^9}},ExpressionUUID->"c52b5a46-89e7-42aa-8874-\
ccd9c3adc29e"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"t\[Dagger]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`t\[Dagger][-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "C", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -C, -$CellContext`A\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "D", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -D, -$CellContext`B\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"b237019a-c87f-49c3-92b6-ef349ccdbdf8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.42652584193686*^9, 
  3.426525846312564*^9}},ExpressionUUID->"4e9831a7-5812-4c7c-a6c5-\
ce038f8a2ac9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Sigma]t\[Dagger]", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"A\[Dagger]", "C", "B\[Dagger]", "D"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Sigma]t\[Dagger][-$CellContext`A\[Dagger], -
   C, -$CellContext`B\[Dagger], -D],
  Editable->
   False]], "Output",ExpressionUUID->"14f35c5e-6afc-4f46-aefc-60ce93ec96d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t\[Dagger]", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.425359418255251*^9, 3.42535942058307*^9}, {
  3.425963349691888*^9, 
  3.425963350310763*^9}},ExpressionUUID->"85f0375b-53f8-418b-9a2b-\
a9f843ed2aee"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"t\[Dagger]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`t\[Dagger][-$CellContext`a, -$CellContext`b],
  Editable->
   False]], "Output",ExpressionUUID->"f6cf0f5a-5385-4348-8e21-3eb8f6c20959"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4253594361765203`*^9, 3.425359444062418*^9}, {
  3.426794221873344*^9, 
  3.426794222437945*^9}},ExpressionUUID->"f3ac0dc6-bae7-4504-81ed-\
ee4d095edadf"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"t\[Dagger]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`t\[Dagger][-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"f7b4af09-5c24-4916-a9be-f57cf25f1bf6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", 
  "%"}]], "Input",ExpressionUUID->"d6f0ed35-b571-487e-ac62-59ea45808409"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Sigma]t\[Dagger]", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"A\[Dagger]", "A", "B\[Dagger]", "B"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Sigma]t\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A, \
-$CellContext`B\[Dagger], -$CellContext`B],
  Editable->
   False]], "Output",ExpressionUUID->"6446172b-527c-412c-a807-e23656455eb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorOfTensor", "[", 
  RowBox[{"t\[Dagger]", ",", "\[Sigma]"}], "]"}]], "Input",
 CellChangeTimes->{{3.425297636198863*^9, 3.425297641522028*^9}, 
   3.425297717775916*^9, {3.425963390531219*^9, 3.4259633912710037`*^9}, {
   3.425963953599949*^9, 
   3.425963975352275*^9}},ExpressionUUID->"d4efcaa2-2439-4c00-a4bc-\
2f4e7781c4bc"],

Cell[BoxData["\[Sigma]t\[Dagger]"], \
"Output",ExpressionUUID->"b58bd361-c682-465e-87af-0ec0d3268100"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinorOfTensor", "[", 
  RowBox[{"t", ",", "\[Sigma]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.4259639817599688`*^9},ExpressionUUID->"729b6f63-88c5-4bc6-994f-\
9ff2ab835776"],

Cell[BoxData["\[Sigma]t"], \
"Output",ExpressionUUID->"d5e4bb22-3655-4fe3-b228-47a22386e1aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", 
  RowBox[{"t", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.426032068558517*^9, 3.426032098543152*^9}, {
  3.42603216008352*^9, 3.4260321811183767`*^9}, {3.426032472928377*^9, 
  3.426032543893334*^9}},ExpressionUUID->"99483943-b53f-4f5d-8e3f-\
8c334a304589"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", "B\[Dagger]"},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]t", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "A\[Dagger]", "B", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]t[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"2a0c9a19-63b5-4872-b939-4a8ea7ebdded"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.426033198780452*^9, 
  3.426033203727232*^9}},ExpressionUUID->"b325b845-5bf0-4a3c-be29-\
2c816b9a08f9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"t", 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`t[-$CellContext`a, -$CellContext`b],
  Editable->
   False]], "Output",ExpressionUUID->"f6e7f01a-33e5-42e1-a3b2-94d516285f9a"]
}, Open  ]],

Cell["8) Spin covds :", "Text",
 CellChangeTimes->{{3.426780323041357*^9, 3.42678032955401*^9}},
 FontWeight->"Bold",ExpressionUUID->"26555854-9e6e-4250-b84a-52ffbe12e768"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D\[Dagger]"}]}], "]"}], "[", 
  RowBox[{"t", "[", "A", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.426032551619025*^9, 3.4260325602749977`*^9}, {
   3.426033261260147*^9, 3.426033262865926*^9}, 3.426034020285921*^9, {
   3.426034054797415*^9, 3.426034083360917*^9}, {3.426034120389324*^9, 
   3.426034120766551*^9}},ExpressionUUID->"d0103a7e-600e-40e0-8c9d-\
a7fe2802e4cb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "CD\[Dagger]", "  "], GridBox[{
      {"t", 
       StyleBox[GridBox[{
          {"A"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`cd[-C, -$CellContext`D\[Dagger]][
   $CellContext`t[$CellContext`A]],
  Editable->
   False]], "Output",ExpressionUUID->"554667b3-c48f-4b88-9959-4fd05bcc8d40"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", 
  RowBox[{"%", ",", "cd"}], "]"}]], "Input",
 CellChangeTimes->{{3.4260325628753777`*^9, 3.426032590331428*^9}, {
  3.4260326519083347`*^9, 3.426032652252302*^9}, {3.426033026901423*^9, 
  3.426033028626224*^9}, {3.426033172632648*^9, 3.426033189718423*^9}, {
  3.426528295585498*^9, 3.426528296109164*^9}, {3.426528339972568*^9, 
  3.426528348126377*^9}, {3.426530198776827*^9, 
  3.426530212813139*^9}},ExpressionUUID->"cbcd7983-ae35-4b2f-890d-\
84794cbe3128"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "C", "D\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -C, -$CellContext`D\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
        {"t", 
         StyleBox[GridBox[{
            {"A"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`cd[-$CellContext`a][
     $CellContext`t[$CellContext`A]],
    Editable->False], 
   ")"}]}]], "Output",ExpressionUUID->"79fdf5fc-4f77-4ecd-999d-9f0233daa420"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.426033206566042*^9, 3.426033212522272*^9}, {
  3.4260332679027367`*^9, 3.426033272155056*^9}, {3.4260340250186462`*^9, 
  3.426034027260581*^9}},ExpressionUUID->"ba39d134-fd7c-4109-ab7e-\
d7a8a3241898"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "CD\[Dagger]", "  "], GridBox[{
      {"t", 
       StyleBox[GridBox[{
          {"A"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`cd[-C, -$CellContext`D\[Dagger]][
   $CellContext`t[$CellContext`A]],
  Editable->
   False]], "Output",ExpressionUUID->"9678dd93-f085-4495-9efd-0474d275df3f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.426034091716846*^9, 
  3.42603409393979*^9}},ExpressionUUID->"61f3ca16-a65b-4df2-8774-\
84cb139b1a87"],

Cell["cd[-C, -D\[Dagger]][t[A]]", \
"Output",ExpressionUUID->"dfbaa01c-0c1a-4899-b414-b97aaf95bcb8"]
}, Open  ]],

Cell["Look at this:", "Text",
 CellChangeTimes->{{3.426034137916195*^9, 3.4260341445834827`*^9}, {
  3.4265302911271973`*^9, 
  3.426530297815918*^9}},ExpressionUUID->"d9b6c39a-0018-4b77-8b7f-\
dc581e01d2dd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"cd", "[", 
    RowBox[{
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "[", 
   RowBox[{"t", "[", 
    RowBox[{"a", ",", "A"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.426032551619025*^9, 3.4260325602749977`*^9}, {
   3.426033261260147*^9, 3.426033262865926*^9}, 3.426034020285921*^9, {
   3.426034054797415*^9, 3.426034083360917*^9}, {3.426034120389324*^9, 
   3.426034120766551*^9}, {3.4260341520868683`*^9, 3.426034152445991*^9}, {
   3.426780364316555*^9, 
   3.426780365311462*^9}},ExpressionUUID->"c647541c-e4e8-4259-bbbc-\
a7713d0d6f60"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "CD\[Dagger]", "  "], GridBox[{
      {"t", 
       StyleBox[GridBox[{
          {"a", "A"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`cd[-C, -$CellContext`D\[Dagger]][
   $CellContext`t[$CellContext`a, $CellContext`A]],
  Editable->
   False]], "Output",ExpressionUUID->"012f42e3-8d80-4e1e-91d8-2ad32e8dc109"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.4260325628753777`*^9, 3.426032590331428*^9}, {
  3.4260326519083347`*^9, 3.426032652252302*^9}, {3.426033026901423*^9, 
  3.426033028626224*^9}, {3.426033172632648*^9, 3.426033189718423*^9}, {
  3.426530282568623*^9, 3.426530301858986*^9}, {3.42678036740138*^9, 
  3.426780368146257*^9}},ExpressionUUID->"4732f490-19a0-4590-8819-\
1130f118df1d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "B", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "C", "D\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -C, -$CellContext`D\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
        {"\[Sigma]t", 
         StyleBox[GridBox[{
            {"B", "A\[Dagger]", "A"},
            {" ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`cd[-$CellContext`b][
     $CellContext`\[Sigma]t[$CellContext`B, $CellContext`A\[Dagger], \
$CellContext`A]],
    Editable->False], 
   ")"}]}]], "Output",ExpressionUUID->"17c8ab07-86a5-4f6b-8d14-8188fc5b201e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", 
  RowBox[{"expr", ",", "Spin"}], "]"}]], "Input",
 CellChangeTimes->{{3.426530330364003*^9, 3.426530338615505*^9}, {
  3.4267803706036253`*^9, 
  3.426780371470173*^9}},ExpressionUUID->"bd5e3d0b-4b2c-4a63-aed4-\
3e74243d0b9f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "C", "D\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -C, -$CellContext`D\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
        {"t", 
         StyleBox[GridBox[{
            {"a", "A"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`cd[-$CellContext`b][
     $CellContext`t[$CellContext`a, $CellContext`A]],
    Editable->False], 
   ")"}]}]], "Output",ExpressionUUID->"8eb76f4e-b029-476a-92ed-00e54cfe2f0f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "[", 
  RowBox[{"expr", ",", "TangentM4"}], "]"}]], "Input",
 CellChangeTimes->{{3.426530340349619*^9, 3.4265303618358994`*^9}, {
  3.426780373911265*^9, 
  3.426780374995338*^9}},ExpressionUUID->"7d8366fb-25cc-4106-a862-\
0e347fbfb47a"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "B", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubsuperscriptBox["\[EmptyDownTriangle]", "CD\[Dagger]", "  "], GridBox[{
        {"\[Sigma]t", 
         StyleBox[GridBox[{
            {"B", "A\[Dagger]", "A"},
            {" ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`cd[-C, -$CellContext`D\[Dagger]][
     $CellContext`\[Sigma]t[$CellContext`B, $CellContext`A\[Dagger], \
$CellContext`A]],
    Editable->False], 
   ")"}]}]], "Output",ExpressionUUID->"674dff1a-1848-42ee-957c-023f7059f3a4"]
}, Open  ]],

Cell["Contraction through derivatives:", "Text",
 CellChangeTimes->{{3.494141755785561*^9, 
  3.494141756732443*^9}},ExpressionUUID->"c9b950e7-51c2-48c0-a816-\
d564873789a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.426033206566042*^9, 3.426033212522272*^9}, {
   3.4260332679027367`*^9, 3.426033272155056*^9}, {3.4260340250186462`*^9, 
   3.426034027260581*^9}, 3.426034178476201*^9, 
   3.426530379699267*^9},ExpressionUUID->"bdd63fbd-d9b7-4c88-9ee0-\
b8ca56741ac2"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "CD\[Dagger]", "  "], GridBox[{
      {"t", 
       StyleBox[GridBox[{
          {"a", "A"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`cd[-C, -$CellContext`D\[Dagger]][
   $CellContext`t[$CellContext`a, $CellContext`A]],
  Editable->
   False]], "Output",ExpressionUUID->"746611a8-57dd-4712-b29b-6fff7755c1d0"]
}, Open  ]],

Cell["We define another spinor", "Text",
 CellChangeTimes->{{3.425964102694229*^9, 
  3.425964106836994*^9}},ExpressionUUID->"d2e28657-b9b5-464e-acd7-\
f18eab1ab07b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Xi]", "[", "A", "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.425204198193967*^9, 3.425204201138039*^9}, {
   3.42596410920061*^9, 3.425964111296898*^9}, 
   3.426780433452775*^9},ExpressionUUID->"a3e81690-df76-4db2-acc7-\
044934b798f4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Xi]", "[", "A", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Xi][$CellContext`A], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"09a33e11-2ea8-4a19-8464-ff2957dff5b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Xi]\[Dagger]", "[", "A\[Dagger]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Xi]\[Dagger][$CellContext`A\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e1742c69-a692-4a79-a64b-064a6b56c706"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}]}], "]"}], 
  RowBox[{
   RowBox[{"cd", "[", 
    RowBox[{"-", "a"}], "]"}], "[", 
   RowBox[{"g", "[", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.423339258436029*^9, 
  3.4233393082774067`*^9}},ExpressionUUID->"1b7df9db-9bd2-4c4e-a81b-\
bf9c8d4278eb"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "B", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "a"], "g"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`cd[-$CellContext`a][
     $CellContext`g[]],
    Editable->False], 
   ")"}]}]], "Output",ExpressionUUID->"92791b1b-4452-40c6-a232-3bd4b439d548"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.4233405626567793`*^9, 
  3.423340568869707*^9}},ExpressionUUID->"b02209ce-3afc-4817-9228-\
e2c5bd55f596"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "BB\[Dagger]", "  "], "g"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`cd[-$CellContext`B, -$CellContext`B\[Dagger]][
   $CellContext`g[]],
  Editable->
   False]], "Output",ExpressionUUID->"b6f125ca-d199-49eb-95de-b95caab21722"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.423340572002226*^9, 
  3.423340578704245*^9}},ExpressionUUID->"3446ee70-0d46-4a37-a7ca-\
523468b18055"],

Cell["cd[-B, -B\[Dagger]][g[]]", \
"Output",ExpressionUUID->"3a278b79-ae12-4a56-8012-00d24e7df19d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}]}], "]"}], 
  RowBox[{
   RowBox[{"cd", "[", 
    RowBox[{"-", "a"}], "]"}], "[", 
   RowBox[{"g", "[", "C", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.423339258436029*^9, 3.4233393082774067`*^9}, 
   3.4233405893008833`*^9},ExpressionUUID->"cfdfa1ef-d797-4400-b267-\
665e8f0d9a99"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "B", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"C"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`cd[-$CellContext`a][
     $CellContext`g[C]],
    Editable->False], 
   ")"}]}]], "Output",ExpressionUUID->"3b06b5f6-15b8-488d-848f-b21e249c616e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.4233405626567793`*^9, 
  3.423340568869707*^9}},ExpressionUUID->"92c57f2a-f19c-4134-a99a-\
990c2f9a7cb8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "BB\[Dagger]", "  "], GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"C"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`cd[-$CellContext`B, -$CellContext`B\[Dagger]][
   $CellContext`g[C]],
  Editable->
   False]], "Output",ExpressionUUID->"6bd90b1a-cc4a-405e-b407-c44e6987f559"]
}, Open  ]],

Cell["More on two - index derivatives :", "Text",
 CellChangeTimes->{{3.4194289597904*^9, 3.4194289635441437`*^9}, {
  3.42332931758394*^9, 3.423329318757977*^9}, {3.4267804610085793`*^9, 
  3.426780465422142*^9}},ExpressionUUID->"be930ed1-3d02-4fb5-9db5-\
05882f70f136"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B\[Dagger]"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"g", "[", "]"}], "+", 
   RowBox[{"3", 
    RowBox[{"\[Sigma]", "[", "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4194289297736197`*^9, 
  3.419428954654977*^9}},ExpressionUUID->"06255c0c-17b7-4b12-838a-\
1ca809d44af3"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[EmptyDownTriangle]", "AB\[Dagger]", "  "], "g"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`cd[-$CellContext`A, -$CellContext`B\[Dagger]][
    $CellContext`g[]],
   Editable->False], "+", 
  RowBox[{"3", " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", "AB\[Dagger]", "  "], 
       "\[Sigma]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`cd[-$CellContext`A, -$CellContext`B\[Dagger]][
      $CellContext`\[Sigma][]],
     Editable->False], 
    ")"}]}]}]], \
"Output",ExpressionUUID->"8f94f6b5-f8ca-4024-82bf-55a77e0dd8e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.423340646188833*^9, 
  3.423340650409886*^9}},ExpressionUUID->"26ae92ef-bc26-4ffb-8778-\
21496bb7e908"],

Cell["cd[-A, -B\[Dagger]][g[]] + 3*cd[-A, -B\[Dagger]][\[Sigma][]]", \
"Output",ExpressionUUID->"2fca4a50-db0c-43fc-b95c-ac2b34d731ff"]
}, Open  ]],

Cell["9) Decompositions :", "Text",
 CellChangeTimes->{{3.426780476966062*^9, 3.4267804806986322`*^9}},
 FontWeight->"Bold",ExpressionUUID->"e8b796fa-df3d-4a74-8cf8-bfb2619b4906"],

Cell["This is the Riemann tensor", "Text",
 CellChangeTimes->{{3.408883720853859*^9, 3.408883723578238*^9}, {
  3.409050776290996*^9, 
  3.409050780603294*^9}},ExpressionUUID->"1e5ca5cd-4d92-4dd1-a194-\
d752f0a08f66"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.408878924947839*^9, 3.408878931342156*^9}, {
  3.408878968038067*^9, 3.408878976893429*^9}, {3.4088824131942673`*^9, 
  3.408882435130514*^9}, {3.4088828046463003`*^9, 3.408882809089301*^9}, {
  3.4094913859207067`*^9, 
  3.409491390728795*^9}},ExpressionUUID->"d34f844a-6848-4d5d-a369-\
5e0db1548759"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->
   False]], "Output",ExpressionUUID->"35ae8388-ed09-4514-9af6-6869ba56c26d"]
}, Open  ]],

Cell["\<\
We find the decomposittion of the Riemann tensor by two different procedures \
and compare the results at the end\
\>", "Text",
 CellChangeTimes->{{3.409552976412736*^9, 
  3.409553006004456*^9}},ExpressionUUID->"a3dd2572-7edb-4ac5-b595-\
e25431e52fad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "RiemannToWeyl"}]], "Input",
 CellChangeTimes->{{3.409491403120109*^9, 
  3.4094914198976927`*^9}},ExpressionUUID->"4773bbda-a840-4c26-9c98-\
084bedd90f5d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`b, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`b, -$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->
    False]}]], "Output",ExpressionUUID->"bc67bebe-943a-4c2e-85ee-a63037d1cf3f"]
}, Open  ]],

Cell["The spinor equivalent of this expression is given by", "Text",
 CellChangeTimes->{{3.409053654049128*^9, 3.409053660177114*^9}, {
  3.409553016332739*^9, 
  3.409553025699998*^9}},ExpressionUUID->"57e83889-47d3-4742-82c6-\
a272f7b15060"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{
  3.419257140013145*^9, {3.426794260930613*^9, 
   3.4267942615426683`*^9}},ExpressionUUID->"f03f2f50-f92e-499e-915e-\
2fa8d46c4c4b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"b", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`b, -$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
      Editable->False]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"b", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`b, -$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciCD[-$CellContext`a, -$CellContext`d],
      Editable->False]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`a, -$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"b", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciCD[-$CellContext`b, -$CellContext`c],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`a, -$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"b", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciCD[-$CellContext`b, -$CellContext`d],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`a, -$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"b", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`b, -$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarCD[],
      Editable->False]}], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`a, -$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"b", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`b, -$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarCD[],
      Editable->False]}], "+", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", "C\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", " ", " "},
          {" ", "D", "D\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`D\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"339cbd73-b9d7-4fc0-b068-e9b368dea130"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "@", "%"}]], "Input",
 CellChangeTimes->{{3.409561140982663*^9, 3.409561145567286*^9}, {
  3.424268736394472*^9, 
  3.4242687371832848`*^9}},ExpressionUUID->"f87fed16-59a0-4fce-8fe9-\
a2ab400c435c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "A", "A\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "C", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -C, -$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "B", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "C", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -C, -$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "A", "A\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "D", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -D, -$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "B", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "D", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -D, -$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "A", "A\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "B", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"c", " ", " "},
           {" ", "C", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"d", " ", " "},
           {" ", "D", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`D\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"4207aaf6-2b19-4788-8784-4e19585d5b8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4088820588233557`*^9, 3.4088820653132772`*^9}, {
  3.423542073760179*^9, 
  3.4235420815217133`*^9}},ExpressionUUID->"9f49787c-ffdf-4fda-90ce-\
3b62518485fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[Sigma]R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "A\[Dagger]", "C", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma]\[UnderBracket]RicciCD[-$CellContext`A, \
-$CellContext`A\[Dagger], -C, -$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[Sigma]R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "A\[Dagger]", "D", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma]\[UnderBracket]RicciCD[-$CellContext`A, \
-$CellContext`A\[Dagger], -D, -$CellContext`D\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[Sigma]R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "B\[Dagger]", "C", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma]\[UnderBracket]RicciCD[-$CellContext`B, \
-$CellContext`B\[Dagger], -C, -$CellContext`C\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[Sigma]R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "B\[Dagger]", "D", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma]\[UnderBracket]RicciCD[-$CellContext`B, \
-$CellContext`B\[Dagger], -D, -$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"\[Sigma]W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " ", " ", " ", " ", " "},
          {"A", "A\[Dagger]", "B", "B\[Dagger]", "C", "C\[Dagger]", "D", 
           "D\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma]\[UnderBracket]WeylCD[-$CellContext`A, \
-$CellContext`A\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"54b63944-aaff-464b-8ef9-5fe056fd3b60"]
}, Open  ]],

Cell["We can find the decomposition of this into irreducible parts", "Text",
 CellChangeTimes->{{3.409053665299726*^9, 3.409053675721974*^9}, {
  3.409553054821434*^9, 
  3.409553059565461*^9}},ExpressionUUID->"a562911f-783b-4e2c-8df7-\
63bf91251531"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Decomposition", "[", "%", "]"}], "//", "ContractMetric"}]], "Input",
 CellChangeTimes->{{3.408882830479249*^9, 3.40888283284147*^9}, {
  3.4094914539566717`*^9, 3.409491456795513*^9}, {3.4094918571742973`*^9, 
  3.409491858297682*^9}, {3.4191559092201014`*^9, 3.419155919103735*^9}, {
  3.423542102029853*^9, 
  3.423542105759121*^9}},ExpressionUUID->"2e578e5e-bbc6-4993-b6bc-\
d2f99bd8ac64"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          "\[Dagger]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A\[Dagger]", "B\[Dagger]", "D\[Dagger]", "C\[Dagger]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Psicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`D\[Dagger], -$CellContext`C\[Dagger]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-D, -C],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "D", "B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     D, -$CellContext`B\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "C", "B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     C, -$CellContext`B\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "D", "A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     D, -$CellContext`A\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "C", "A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     C, -$CellContext`A\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd[-$CellContext`A, -$CellContext`B, -D, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"b383fd02-7d01-416a-bae4-0dad227efab9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.409551482408771*^9, 
  3.409551487040393*^9}},ExpressionUUID->"8d416259-0110-44f3-8fe2-\
2a13b3ddb794"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         "\[Dagger]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A\[Dagger]", "B\[Dagger]", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "D", "B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     D, -$CellContext`B\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "C", "B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     C, -$CellContext`B\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "D", "A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     D, -$CellContext`A\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "C", "A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     C, -$CellContext`A\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"f8ba7d64-d08e-4f31-a17c-c8dfeb90f2e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Lambdacd", "[", "]"}], ",", "FactorTerms"}], "]"}]], "Input",
 CellChangeTimes->{{3.4095523076998577`*^9, 3.409552320220984*^9}, {
  3.409552401832659*^9, 3.409552410057315*^9}, {3.409553078624421*^9, 
  3.409553080740363*^9}},ExpressionUUID->"4aa11290-43b1-4230-99e4-\
ffd9e2a1ed79"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         "\[Dagger]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A\[Dagger]", "B\[Dagger]", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "D", "B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     D, -$CellContext`B\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "C", "B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     C, -$CellContext`B\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "D", "A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     D, -$CellContext`A\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "C", "A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     C, -$CellContext`A\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"d1590e77-eba5-4310-9374-a5af45eabfbc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exprA", "=", "%"}]], "Input",
 CellChangeTimes->{{3.409553084506411*^9, 
  3.4095530895399227`*^9}},ExpressionUUID->"fd103eb2-f9aa-4b00-a4b7-\
fd02e3614d94"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         "\[Dagger]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A\[Dagger]", "B\[Dagger]", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "D", "B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     D, -$CellContext`B\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "C", "B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     C, -$CellContext`B\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "D", "A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     D, -$CellContext`A\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "C", "A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     C, -$CellContext`A\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"7ec382cc-9b7b-4671-b105-f211d0c2295f"]
}, Open  ]],

Cell["The alternative procedure is as follows", "Text",
 CellChangeTimes->{{3.4095531068396397`*^9, 
  3.409553116576915*^9}},ExpressionUUID->"84287304-35a8-4a9c-ac38-\
90ece5b26723"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"RiemannCD", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.409553122358842*^9, 3.409553130167048*^9}, 
   3.419257180598216*^9, {3.426794278698946*^9, 
   3.426794279326666*^9}},ExpressionUUID->"d9470c4f-a3d3-402b-af44-\
70232b64802c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", "C\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", " ", " "},
          {" ", "D", "D\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`D\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"b1ddf441-e739-43d7-a4d4-0db0aaaffc2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.409553135574018*^9, 
  3.409553141334969*^9}},ExpressionUUID->"6fd3649d-0488-46ea-b423-\
1514f13cea24"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"\[Sigma]R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"A", "A\[Dagger]", "B", "B\[Dagger]", "C", "C\[Dagger]", "D", 
          "D\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Sigma]\[UnderBracket]RiemannCD[-$CellContext`A, \
-$CellContext`A\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
   C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]],
  Editable->
   False]], "Output",ExpressionUUID->"d9460bae-fca0-4fa6-b083-858636291f79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Decomposition"}]], "Input",
 CellChangeTimes->{{3.4095531740767593`*^9, 
  3.4095531774488583`*^9}},ExpressionUUID->"68e751f1-8150-4cad-b1aa-\
8352299f872f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          "\[Dagger]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A\[Dagger]", "B\[Dagger]", "D\[Dagger]", "C\[Dagger]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Psicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`D\[Dagger], -$CellContext`C\[Dagger]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-D, -C],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "D\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -$CellContext`B, -$CellContext`D\
\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-D, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False]}]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"D", "C", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-D, -
     C, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd[-$CellContext`A, -$CellContext`B, -D, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"185190a6-1c7e-4bb2-bf6a-5d97bf1300a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.409553182184246*^9, 
  3.4095531975141487`*^9}},ExpressionUUID->"efa37370-c385-48b5-a0bb-\
a230244445ce"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         "\[Dagger]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A\[Dagger]", "B\[Dagger]", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"C", "D", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-C, -
     D, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"990e4f7d-c048-4934-8310-cc4932aa5cd4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Lambdacd", "[", "]"}], ",", "FactorTerms"}], "]"}]], "Input",
 CellChangeTimes->{{3.409555404335395*^9, 
  3.4095554185663843`*^9}},ExpressionUUID->"4b3e535a-5a4a-4157-b2f9-\
3bcc2467dbff"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         "\[Dagger]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A\[Dagger]", "B\[Dagger]", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"C", "D", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-C, -
     D, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"9b71be3a-70e6-4b91-bc32-63c5d06151df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exprB", "=", "%"}]], "Input",
 CellChangeTimes->{{3.409553204900539*^9, 
  3.409553216466617*^9}},ExpressionUUID->"b2ea067a-8b5b-404f-986f-\
5531689eba16"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         "\[Dagger]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A\[Dagger]", "B\[Dagger]", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A\[Dagger]", "C\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]\[Dagger]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B\[Dagger]", "D\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"C", "D", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-C, -
     D, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"7551575d-f8a5-4d61-a123-5f232fbacec7"]
}, Open  ]],

Cell["This must be zero using dim-dep relations:", "Text",
 CellChangeTimes->{{3.4192572184040327`*^9, 3.419257228296666*^9}, {
  3.419334931931951*^9, 3.4193349588087807`*^9}, {3.423340692268158*^9, 
  3.423340705145328*^9}},ExpressionUUID->"475af902-70ac-4137-ad87-\
e15b14618cc7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"diff", "=", 
  RowBox[{
   RowBox[{"exprA", "-", "exprB"}], "//", "ToCanonical"}]}]], "Input",
 CellChangeTimes->{{3.4095532228853083`*^9, 3.409553227811523*^9}, {
  3.419258093859906*^9, 3.4192581023711863`*^9}, {3.426021311596188*^9, 
  3.4260213125901012`*^9}},ExpressionUUID->"24c0e447-0c92-4ece-9ba1-\
dbc24de80877"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A", "B", "C\[Dagger]", "D\[Dagger]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Phicd[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "D", "B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     D, -$CellContext`B\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "C", "B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     C, -$CellContext`B\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "D", "A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     D, -$CellContext`A\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "C", "A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     C, -$CellContext`A\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"C", "D", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-C, -
     D, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"16e20cc5-2905-472f-a792-ad55823eef97"]
}, Open  ]],

Cell["\<\
Let us check it. First we generate all possible dim - dep relation, using \
brute force on the 24 x 24 possible index configurations:\
\>", "Text",
 CellChangeTimes->{{3.4260210097979307`*^9, 
  3.42602105454924*^9}},ExpressionUUID->"21fec32e-9dba-4d44-8935-\
34c7d9e8505a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"antisym1", "[", 
   RowBox[{"{", 
    RowBox[{
    "a_", ",", "b_", ",", "c_", ",", "d_", ",", "adg_", ",", "bdg_", ",", 
     "cdg_", ",", "ddg_"}], "}"}], "]"}], ":=", 
  RowBox[{"ToCanonical", "[", 
   RowBox[{"3", 
    RowBox[{"Antisymmetrize", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Phicd", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "adg"}], ",", 
         RowBox[{"-", "bdg"}]}], "]"}], 
       RowBox[{"\[Epsilon]", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], 
       RowBox[{"\[Epsilon]\[Dagger]", "[", 
        RowBox[{
         RowBox[{"-", "cdg"}], ",", 
         RowBox[{"-", "ddg"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f15a5a42-21d5-4180-9894-89ff6e9d5cda"],

Cell[BoxData[
 RowBox[{
  RowBox[{"antisym2", "[", 
   RowBox[{"{", 
    RowBox[{
    "a_", ",", "b_", ",", "c_", ",", "d_", ",", "adg_", ",", "bdg_", ",", 
     "cdg_", ",", "ddg_"}], "}"}], "]"}], ":=", 
  RowBox[{"ToCanonical", "[", 
   RowBox[{"3", 
    RowBox[{"Antisymmetrize", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Phicd", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "adg"}], ",", 
         RowBox[{"-", "bdg"}]}], "]"}], 
       RowBox[{"\[Epsilon]", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], 
       RowBox[{"\[Epsilon]\[Dagger]", "[", 
        RowBox[{
         RowBox[{"-", "cdg"}], ",", 
         RowBox[{"-", "ddg"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "adg"}], ",", 
        RowBox[{"-", "cdg"}], ",", 
        RowBox[{"-", "ddg"}]}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"4cfe5d38-b905-4470-bf8d-4f24220e1eef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"list1", "=", 
   RowBox[{"antisym1", "/@", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Outer", "[", 
       RowBox[{"Join", ",", 
        RowBox[{"Permutations", "[", 
         RowBox[{"{", 
          RowBox[{"A", ",", "B", ",", "C", ",", "D"}], "}"}], "]"}], ",", 
        RowBox[{"Permutations", "[", 
         RowBox[{"{", 
          RowBox[{
          "A\[Dagger]", ",", "B\[Dagger]", ",", "C\[Dagger]", ",", 
           "D\[Dagger]"}], "}"}], "]"}], ",", "1"}], "]"}], ",", "1"}], 
     "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4260206662192497`*^9, 3.4260208039480658`*^9}, {
  3.4260208987988663`*^9, 3.426020901528748*^9}, {3.4272335457836943`*^9, 
  3.427233547042205*^9}},ExpressionUUID->"2ea04083-65e9-4371-88cf-\
32c93eac92a3"],

Cell[BoxData["31.72188500000000033196556614711880683899`7.521958899641926"], \
"Print",ExpressionUUID->"8caffe00-ac2b-4f40-9238-1f3e7486fd39"],

Cell[BoxData["576"], \
"Output",ExpressionUUID->"717f482f-c20c-4c72-96f3-49c68cef44f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"list2", "=", 
   RowBox[{"antisym2", "/@", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Outer", "[", 
       RowBox[{"Join", ",", 
        RowBox[{"Permutations", "[", 
         RowBox[{"{", 
          RowBox[{"A", ",", "B", ",", "C", ",", "D"}], "}"}], "]"}], ",", 
        RowBox[{"Permutations", "[", 
         RowBox[{"{", 
          RowBox[{
          "A\[Dagger]", ",", "B\[Dagger]", ",", "C\[Dagger]", ",", 
           "D\[Dagger]"}], "}"}], "]"}], ",", "1"}], "]"}], ",", "1"}], 
     "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4260206662192497`*^9, 3.4260208039480658`*^9}, {
  3.4260208987988663`*^9, 3.426020901528748*^9}, {3.4272335457836943`*^9, 
  3.427233566180397*^9}},ExpressionUUID->"9b728f10-8b2b-4ca3-8556-\
27e48ae5ee27"],

Cell[BoxData["32.38657800000000008822098607197403907776`7.530964975700771"], \
"Print",ExpressionUUID->"009c43d8-08b5-48cb-9502-1ef8dca397cb"],

Cell[BoxData["576"], \
"Output",ExpressionUUID->"a8637338-5ff5-4835-a156-8959d64a4676"]
}, Open  ]],

Cell["\<\
There are 48 independent relations (actually half of them because all \
relations are repeated due to a minus sign) in each case:\
\>", "Text",
 CellChangeTimes->{{3.4260210570570593`*^9, 3.4260211130513144`*^9}, {
  3.426794306060728*^9, 3.426794312194337*^9}, {3.42723366211031*^9, 
  3.427233665222405*^9}},ExpressionUUID->"0fc65c47-d541-45cb-b452-\
c8d63fdf7597"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"list1", "=", 
   RowBox[{"Union", "[", "list1", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.426020974170125*^9, 3.426020995496159*^9}, {
  3.4272335785955763`*^9, 
  3.4272335797213917`*^9}},ExpressionUUID->"c5482d06-769e-475a-94a8-\
7b2a2e99398f"],

Cell[BoxData["48"], \
"Output",ExpressionUUID->"7fb25b27-1a01-4cab-abe5-d020e5a7678d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"list2", "=", 
   RowBox[{"Union", "[", "list2", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.426020974170125*^9, 3.426020995496159*^9}, {
  3.4272335785955763`*^9, 
  3.427233585498969*^9}},ExpressionUUID->"ef572677-146f-40b0-bed7-\
6fe3c7158ab2"],

Cell[BoxData["48"], \
"Output",ExpressionUUID->"5499dd39-87cf-4066-a6cd-89a3eee19bf7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"list", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"list1", ",", "list2"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.427233901631999*^9, 
  3.4272339167716093`*^9}},ExpressionUUID->"a640d09a-e5ca-4249-83c8-\
4d629f5ef058"],

Cell[BoxData["96"], \
"Output",ExpressionUUID->"bd9de9ac-57ca-46fe-ab71-05e778b89429"]
}, Open  ]],

Cell["\<\
We write our equation as a linear combination of those identities, and then \
equate the coefficients to zero :\
\>", "Text",ExpressionUUID->"ecf31caa-7553-4dc1-b5df-52f486b9a69e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"system", "=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "\[Equal]", "0"}], "&"}], ",", 
    RowBox[{"First", "/@", 
     RowBox[{"List", "@@", 
      RowBox[{"Collect", "[", 
       RowBox[{
        RowBox[{"diff", "+", 
         RowBox[{
          RowBox[{"Array", "[", 
           RowBox[{"c", ",", 
            RowBox[{"{", "96", "}"}]}], "]"}], ".", "list"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Phicd", "[", "__", "]"}], ",", 
          RowBox[{"\[Epsilon]", "[", "__", "]"}], ",", 
          RowBox[{"\[Epsilon]\[Dagger]", "[", "__", "]"}]}], "}"}], ",", 
        "Simplify"}], "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4260213166364603`*^9, 3.426021413636277*^9}, {
  3.427233607105659*^9, 3.427233615956324*^9}, {3.427233720042388*^9, 
  3.4272337211243773`*^9}, {3.4272339222206287`*^9, 
  3.4272339224962606`*^9}},ExpressionUUID->"cddbfab4-f1c3-4f1a-b848-\
c8c278f5e90c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "1", "]"}]}], "+", 
     RowBox[{"c", "[", "2", "]"}], "-", 
     RowBox[{"c", "[", "3", "]"}], "+", 
     RowBox[{"c", "[", "4", "]"}], "-", 
     RowBox[{"c", "[", "25", "]"}], "+", 
     RowBox[{"c", "[", "26", "]"}], "-", 
     RowBox[{"c", "[", "45", "]"}], "+", 
     RowBox[{"c", "[", "46", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "[", "1", "]"}], "-", 
     RowBox[{"c", "[", "2", "]"}], "-", 
     RowBox[{"c", "[", "5", "]"}], "+", 
     RowBox[{"c", "[", "7", "]"}], "-", 
     RowBox[{"c", "[", "27", "]"}], "+", 
     RowBox[{"c", "[", "28", "]"}], "-", 
     RowBox[{"c", "[", "47", "]"}], "+", 
     RowBox[{"c", "[", "48", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "[", "3", "]"}], "-", 
     RowBox[{"c", "[", "4", "]"}], "+", 
     RowBox[{"c", "[", "5", "]"}], "-", 
     RowBox[{"c", "[", "7", "]"}], "-", 
     RowBox[{"c", "[", "29", "]"}], "+", 
     RowBox[{"c", "[", "30", "]"}], "-", 
     RowBox[{"c", "[", "49", "]"}], "+", 
     RowBox[{"c", "[", "50", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "1", "]"}]}], "+", 
     RowBox[{"c", "[", "2", "]"}], "-", 
     RowBox[{"c", "[", "6", "]"}], "+", 
     RowBox[{"c", "[", "8", "]"}], "-", 
     RowBox[{"c", "[", "31", "]"}], "+", 
     RowBox[{"c", "[", "33", "]"}], "-", 
     RowBox[{"c", "[", "51", "]"}], "+", 
     RowBox[{"c", "[", "53", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "3", "]"}]}], "+", 
     RowBox[{"c", "[", "4", "]"}], "+", 
     RowBox[{"c", "[", "6", "]"}], "-", 
     RowBox[{"c", "[", "8", "]"}], "-", 
     RowBox[{"c", "[", "35", "]"}], "+", 
     RowBox[{"c", "[", "37", "]"}], "-", 
     RowBox[{"c", "[", "55", "]"}], "+", 
     RowBox[{"c", "[", "57", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"c", "[", "5", "]"}], "-", 
     RowBox[{"c", "[", "6", "]"}], "+", 
     RowBox[{"c", "[", "7", "]"}], "+", 
     RowBox[{"c", "[", "8", "]"}], "-", 
     RowBox[{"c", "[", "39", "]"}], "+", 
     RowBox[{"c", "[", "42", "]"}], "-", 
     RowBox[{"c", "[", "59", "]"}], "+", 
     RowBox[{"c", "[", "62", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "9", "]"}]}], "+", 
     RowBox[{"c", "[", "10", "]"}], "-", 
     RowBox[{"c", "[", "11", "]"}], "+", 
     RowBox[{"c", "[", "12", "]"}], "+", 
     RowBox[{"c", "[", "25", "]"}], "-", 
     RowBox[{"c", "[", "26", "]"}], "-", 
     RowBox[{"c", "[", "65", "]"}], "+", 
     RowBox[{"c", "[", "67", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"c", "[", "9", "]"}], "-", 
     RowBox[{"c", "[", "10", "]"}], "-", 
     RowBox[{"c", "[", "13", "]"}], "+", 
     RowBox[{"c", "[", "15", "]"}], "+", 
     RowBox[{"c", "[", "27", "]"}], "-", 
     RowBox[{"c", "[", "28", "]"}], "-", 
     RowBox[{"c", "[", "69", "]"}], "+", 
     RowBox[{"c", "[", "71", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "[", "11", "]"}], "-", 
     RowBox[{"c", "[", "12", "]"}], "+", 
     RowBox[{"c", "[", "13", "]"}], "-", 
     RowBox[{"c", "[", "15", "]"}], "+", 
     RowBox[{"c", "[", "29", "]"}], "-", 
     RowBox[{"c", "[", "30", "]"}], "-", 
     RowBox[{"c", "[", "73", "]"}], "+", 
     RowBox[{"c", "[", "75", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "9", "]"}]}], "+", 
     RowBox[{"c", "[", "10", "]"}], "-", 
     RowBox[{"c", "[", "14", "]"}], "+", 
     RowBox[{"c", "[", "16", "]"}], "+", 
     RowBox[{"c", "[", "31", "]"}], "-", 
     RowBox[{"c", "[", "33", "]"}], "-", 
     RowBox[{"c", "[", "77", "]"}], "+", 
     RowBox[{"c", "[", "80", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "11", "]"}]}], "+", 
     RowBox[{"c", "[", "12", "]"}], "+", 
     RowBox[{"c", "[", "14", "]"}], "-", 
     RowBox[{"c", "[", "16", "]"}], "+", 
     RowBox[{"c", "[", "35", "]"}], "-", 
     RowBox[{"c", "[", "37", "]"}], "-", 
     RowBox[{"c", "[", "83", "]"}], "+", 
     RowBox[{"c", "[", "86", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "13", "]"}]}], "-", 
     RowBox[{"c", "[", "14", "]"}], "+", 
     RowBox[{"c", "[", "15", "]"}], "+", 
     RowBox[{"c", "[", "16", "]"}], "+", 
     RowBox[{"c", "[", "39", "]"}], "-", 
     RowBox[{"c", "[", "42", "]"}], "-", 
     RowBox[{"c", "[", "89", "]"}], "+", 
     RowBox[{"c", "[", "93", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "17", "]"}]}], "+", 
     RowBox[{"c", "[", "18", "]"}], "-", 
     RowBox[{"c", "[", "19", "]"}], "+", 
     RowBox[{"c", "[", "20", "]"}], "+", 
     RowBox[{"c", "[", "45", "]"}], "-", 
     RowBox[{"c", "[", "46", "]"}], "+", 
     RowBox[{"c", "[", "65", "]"}], "-", 
     RowBox[{"c", "[", "67", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "[", "17", "]"}], "-", 
     RowBox[{"c", "[", "18", "]"}], "-", 
     RowBox[{"c", "[", "21", "]"}], "+", 
     RowBox[{"c", "[", "23", "]"}], "+", 
     RowBox[{"c", "[", "47", "]"}], "-", 
     RowBox[{"c", "[", "48", "]"}], "+", 
     RowBox[{"c", "[", "69", "]"}], "-", 
     RowBox[{"c", "[", "71", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"c", "[", "19", "]"}], "-", 
     RowBox[{"c", "[", "20", "]"}], "+", 
     RowBox[{"c", "[", "21", "]"}], "-", 
     RowBox[{"c", "[", "23", "]"}], "+", 
     RowBox[{"c", "[", "49", "]"}], "-", 
     RowBox[{"c", "[", "50", "]"}], "+", 
     RowBox[{"c", "[", "73", "]"}], "-", 
     RowBox[{"c", "[", "75", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "17", "]"}]}], "+", 
     RowBox[{"c", "[", "18", "]"}], "-", 
     RowBox[{"c", "[", "22", "]"}], "+", 
     RowBox[{"c", "[", "24", "]"}], "+", 
     RowBox[{"c", "[", "51", "]"}], "-", 
     RowBox[{"c", "[", "53", "]"}], "+", 
     RowBox[{"c", "[", "77", "]"}], "-", 
     RowBox[{"c", "[", "80", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "19", "]"}]}], "+", 
     RowBox[{"c", "[", "20", "]"}], "+", 
     RowBox[{"c", "[", "22", "]"}], "-", 
     RowBox[{"c", "[", "24", "]"}], "+", 
     RowBox[{"c", "[", "55", "]"}], "-", 
     RowBox[{"c", "[", "57", "]"}], "+", 
     RowBox[{"c", "[", "83", "]"}], "-", 
     RowBox[{"c", "[", "86", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "21", "]"}]}], "-", 
     RowBox[{"c", "[", "22", "]"}], "+", 
     RowBox[{"c", "[", "23", "]"}], "+", 
     RowBox[{"c", "[", "24", "]"}], "+", 
     RowBox[{"c", "[", "59", "]"}], "-", 
     RowBox[{"c", "[", "62", "]"}], "+", 
     RowBox[{"c", "[", "89", "]"}], "-", 
     RowBox[{"c", "[", "93", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "25", "]"}]}], "+", 
     RowBox[{"c", "[", "26", "]"}], "-", 
     RowBox[{"c", "[", "32", "]"}], "+", 
     RowBox[{"c", "[", "34", "]"}], "-", 
     RowBox[{"c", "[", "36", "]"}], "+", 
     RowBox[{"c", "[", "38", "]"}], "-", 
     RowBox[{"c", "[", "66", "]"}], "+", 
     RowBox[{"c", "[", "68", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "27", "]"}]}], "+", 
     RowBox[{"c", "[", "28", "]"}], "+", 
     RowBox[{"c", "[", "32", "]"}], "-", 
     RowBox[{"c", "[", "34", "]"}], "-", 
     RowBox[{"c", "[", "40", "]"}], "+", 
     RowBox[{"c", "[", "43", "]"}], "-", 
     RowBox[{"c", "[", "70", "]"}], "+", 
     RowBox[{"c", "[", "72", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "29", "]"}]}], "+", 
     RowBox[{"c", "[", "30", "]"}], "+", 
     RowBox[{"c", "[", "36", "]"}], "-", 
     RowBox[{"c", "[", "38", "]"}], "+", 
     RowBox[{"c", "[", "40", "]"}], "-", 
     RowBox[{"c", "[", "43", "]"}], "-", 
     RowBox[{"c", "[", "74", "]"}], "+", 
     RowBox[{"c", "[", "76", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"c", "[", "31", "]"}], "-", 
     RowBox[{"c", "[", "32", "]"}], "+", 
     RowBox[{"c", "[", "33", "]"}], "+", 
     RowBox[{"c", "[", "34", "]"}], "-", 
     RowBox[{"c", "[", "41", "]"}], "+", 
     RowBox[{"c", "[", "44", "]"}], "-", 
     RowBox[{"c", "[", "78", "]"}], "+", 
     RowBox[{"c", "[", "81", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "35", "]"}]}], "-", 
     RowBox[{"c", "[", "36", "]"}], "+", 
     RowBox[{"c", "[", "37", "]"}], "+", 
     RowBox[{"c", "[", "38", "]"}], "+", 
     RowBox[{"c", "[", "41", "]"}], "-", 
     RowBox[{"c", "[", "44", "]"}], "-", 
     RowBox[{"c", "[", "84", "]"}], "+", 
     RowBox[{"c", "[", "87", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "39", "]"}]}], "-", 
     RowBox[{"c", "[", "40", "]"}], "-", 
     RowBox[{"c", "[", "41", "]"}], "+", 
     RowBox[{"c", "[", "42", "]"}], "+", 
     RowBox[{"c", "[", "43", "]"}], "+", 
     RowBox[{"c", "[", "44", "]"}], "-", 
     RowBox[{"c", "[", "90", "]"}], "+", 
     RowBox[{"c", "[", "94", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "45", "]"}]}], "+", 
     RowBox[{"c", "[", "46", "]"}], "-", 
     RowBox[{"c", "[", "52", "]"}], "+", 
     RowBox[{"c", "[", "54", "]"}], "-", 
     RowBox[{"c", "[", "56", "]"}], "+", 
     RowBox[{"c", "[", "58", "]"}], "+", 
     RowBox[{"c", "[", "66", "]"}], "-", 
     RowBox[{"c", "[", "68", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "47", "]"}]}], "+", 
     RowBox[{"c", "[", "48", "]"}], "+", 
     RowBox[{"c", "[", "52", "]"}], "-", 
     RowBox[{"c", "[", "54", "]"}], "-", 
     RowBox[{"c", "[", "60", "]"}], "+", 
     RowBox[{"c", "[", "63", "]"}], "+", 
     RowBox[{"c", "[", "70", "]"}], "-", 
     RowBox[{"c", "[", "72", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "49", "]"}]}], "+", 
     RowBox[{"c", "[", "50", "]"}], "+", 
     RowBox[{"c", "[", "56", "]"}], "-", 
     RowBox[{"c", "[", "58", "]"}], "+", 
     RowBox[{"c", "[", "60", "]"}], "-", 
     RowBox[{"c", "[", "63", "]"}], "+", 
     RowBox[{"c", "[", "74", "]"}], "-", 
     RowBox[{"c", "[", "76", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "51", "]"}]}], "-", 
     RowBox[{"c", "[", "52", "]"}], "+", 
     RowBox[{"c", "[", "53", "]"}], "+", 
     RowBox[{"c", "[", "54", "]"}], "-", 
     RowBox[{"c", "[", "61", "]"}], "+", 
     RowBox[{"c", "[", "64", "]"}], "+", 
     RowBox[{"c", "[", "78", "]"}], "-", 
     RowBox[{"c", "[", "81", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"c", "[", "55", "]"}], "-", 
     RowBox[{"c", "[", "56", "]"}], "+", 
     RowBox[{"c", "[", "57", "]"}], "+", 
     RowBox[{"c", "[", "58", "]"}], "+", 
     RowBox[{"c", "[", "61", "]"}], "-", 
     RowBox[{"c", "[", "64", "]"}], "+", 
     RowBox[{"c", "[", "84", "]"}], "-", 
     RowBox[{"c", "[", "87", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "59", "]"}]}], "-", 
     RowBox[{"c", "[", "60", "]"}], "-", 
     RowBox[{"c", "[", "61", "]"}], "+", 
     RowBox[{"c", "[", "62", "]"}], "+", 
     RowBox[{"c", "[", "63", "]"}], "+", 
     RowBox[{"c", "[", "64", "]"}], "+", 
     RowBox[{"c", "[", "90", "]"}], "-", 
     RowBox[{"c", "[", "94", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"c", "[", "65", "]"}], "-", 
     RowBox[{"c", "[", "66", "]"}], "+", 
     RowBox[{"c", "[", "67", "]"}], "+", 
     RowBox[{"c", "[", "68", "]"}], "-", 
     RowBox[{"c", "[", "79", "]"}], "+", 
     RowBox[{"c", "[", "82", "]"}], "-", 
     RowBox[{"c", "[", "85", "]"}], "+", 
     RowBox[{"c", "[", "88", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "69", "]"}]}], "-", 
     RowBox[{"c", "[", "70", "]"}], "+", 
     RowBox[{"c", "[", "71", "]"}], "+", 
     RowBox[{"c", "[", "72", "]"}], "+", 
     RowBox[{"c", "[", "79", "]"}], "-", 
     RowBox[{"c", "[", "82", "]"}], "-", 
     RowBox[{"c", "[", "91", "]"}], "+", 
     RowBox[{"c", "[", "95", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "73", "]"}]}], "-", 
     RowBox[{"c", "[", "74", "]"}], "+", 
     RowBox[{"c", "[", "75", "]"}], "+", 
     RowBox[{"c", "[", "76", "]"}], "+", 
     RowBox[{"c", "[", "85", "]"}], "-", 
     RowBox[{"c", "[", "88", "]"}], "+", 
     RowBox[{"c", "[", "91", "]"}], "-", 
     RowBox[{"c", "[", "95", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "77", "]"}]}], "-", 
     RowBox[{"c", "[", "78", "]"}], "-", 
     RowBox[{"c", "[", "79", "]"}], "+", 
     RowBox[{"c", "[", "80", "]"}], "+", 
     RowBox[{"c", "[", "81", "]"}], "+", 
     RowBox[{"c", "[", "82", "]"}], "-", 
     RowBox[{"c", "[", "92", "]"}], "+", 
     RowBox[{"c", "[", "96", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "83", "]"}]}], "-", 
     RowBox[{"c", "[", "84", "]"}], "-", 
     RowBox[{"c", "[", "85", "]"}], "+", 
     RowBox[{"c", "[", "86", "]"}], "+", 
     RowBox[{"c", "[", "87", "]"}], "+", 
     RowBox[{"c", "[", "88", "]"}], "+", 
     RowBox[{"c", "[", "92", "]"}], "-", 
     RowBox[{"c", "[", "96", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"c", "[", "89", "]"}]}], "-", 
     RowBox[{"c", "[", "90", "]"}], "-", 
     RowBox[{"c", "[", "91", "]"}], "-", 
     RowBox[{"c", "[", "92", "]"}], "+", 
     RowBox[{"c", "[", "93", "]"}], "+", 
     RowBox[{"c", "[", "94", "]"}], "+", 
     RowBox[{"c", "[", "95", "]"}], "+", 
     RowBox[{"c", "[", "96", "]"}]}], "\[Equal]", "0"}]}], 
  "}"}]], "Output",ExpressionUUID->"d6e4465e-718c-47ca-a886-7c36bc07d3f5"]
}, Open  ]],

Cell["There are many solutions :", "Text",
 CellChangeTimes->{{3.427233824003124*^9, 
  3.427233838884879*^9}},ExpressionUUID->"33b1d234-cce4-49ae-b7e7-\
f9e42069f094"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"system", ",", 
   RowBox[{"Array", "[", 
    RowBox[{"c", ",", "96"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"eaaae278-a381-4b74-b2e9-c7f1ab19be1d"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], ":", 
  " ", "\<\"Equations may not give solutions for all \\\"solve\\\" variables. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"7902a995-d7eb-41c8-afbb-f80c8b23d662"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "[", "20", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "1", "]"}], "-", 
      RowBox[{"c", "[", "2", "]"}], "+", 
      RowBox[{"c", "[", "3", "]"}], "-", 
      RowBox[{"c", "[", "4", "]"}], "+", 
      RowBox[{"c", "[", "9", "]"}], "-", 
      RowBox[{"c", "[", "10", "]"}], "+", 
      RowBox[{"c", "[", "11", "]"}], "-", 
      RowBox[{"c", "[", "12", "]"}], "+", 
      RowBox[{"c", "[", "17", "]"}], "-", 
      RowBox[{"c", "[", "18", "]"}], "+", 
      RowBox[{"c", "[", "19", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "23", "]"}], "\[Rule]", 
     RowBox[{"1", "-", 
      RowBox[{"c", "[", "1", "]"}], "+", 
      RowBox[{"c", "[", "2", "]"}], "+", 
      RowBox[{"c", "[", "5", "]"}], "-", 
      RowBox[{"c", "[", "7", "]"}], "-", 
      RowBox[{"c", "[", "9", "]"}], "+", 
      RowBox[{"c", "[", "10", "]"}], "+", 
      RowBox[{"c", "[", "13", "]"}], "-", 
      RowBox[{"c", "[", "15", "]"}], "-", 
      RowBox[{"c", "[", "17", "]"}], "+", 
      RowBox[{"c", "[", "18", "]"}], "+", 
      RowBox[{"c", "[", "21", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "24", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "1", "]"}], "-", 
      RowBox[{"c", "[", "2", "]"}], "+", 
      RowBox[{"c", "[", "6", "]"}], "-", 
      RowBox[{"c", "[", "8", "]"}], "+", 
      RowBox[{"c", "[", "9", "]"}], "-", 
      RowBox[{"c", "[", "10", "]"}], "+", 
      RowBox[{"c", "[", "14", "]"}], "-", 
      RowBox[{"c", "[", "16", "]"}], "+", 
      RowBox[{"c", "[", "17", "]"}], "-", 
      RowBox[{"c", "[", "18", "]"}], "+", 
      RowBox[{"c", "[", "22", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "46", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "1", "]"}], "-", 
      RowBox[{"c", "[", "2", "]"}], "+", 
      RowBox[{"c", "[", "3", "]"}], "-", 
      RowBox[{"c", "[", "4", "]"}], "+", 
      RowBox[{"c", "[", "25", "]"}], "-", 
      RowBox[{"c", "[", "26", "]"}], "+", 
      RowBox[{"c", "[", "45", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "48", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"c", "[", "1", "]"}]}], "+", 
      RowBox[{"c", "[", "2", "]"}], "+", 
      RowBox[{"c", "[", "5", "]"}], "-", 
      RowBox[{"c", "[", "7", "]"}], "+", 
      RowBox[{"c", "[", "27", "]"}], "-", 
      RowBox[{"c", "[", "28", "]"}], "+", 
      RowBox[{"c", "[", "47", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "50", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"c", "[", "3", "]"}]}], "+", 
      RowBox[{"c", "[", "4", "]"}], "-", 
      RowBox[{"c", "[", "5", "]"}], "+", 
      RowBox[{"c", "[", "7", "]"}], "+", 
      RowBox[{"c", "[", "29", "]"}], "-", 
      RowBox[{"c", "[", "30", "]"}], "+", 
      RowBox[{"c", "[", "49", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "53", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "1", "]"}], "-", 
      RowBox[{"c", "[", "2", "]"}], "+", 
      RowBox[{"c", "[", "6", "]"}], "-", 
      RowBox[{"c", "[", "8", "]"}], "+", 
      RowBox[{"c", "[", "31", "]"}], "-", 
      RowBox[{"c", "[", "33", "]"}], "+", 
      RowBox[{"c", "[", "51", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "57", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "3", "]"}], "-", 
      RowBox[{"c", "[", "4", "]"}], "-", 
      RowBox[{"c", "[", "6", "]"}], "+", 
      RowBox[{"c", "[", "8", "]"}], "+", 
      RowBox[{"c", "[", "35", "]"}], "-", 
      RowBox[{"c", "[", "37", "]"}], "+", 
      RowBox[{"c", "[", "55", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "58", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"c", "[", "1", "]"}]}], "+", 
      RowBox[{"c", "[", "2", "]"}], "-", 
      RowBox[{"c", "[", "3", "]"}], "+", 
      RowBox[{"c", "[", "4", "]"}], "+", 
      RowBox[{"c", "[", "32", "]"}], "-", 
      RowBox[{"c", "[", "34", "]"}], "+", 
      RowBox[{"c", "[", "36", "]"}], "-", 
      RowBox[{"c", "[", "38", "]"}], "+", 
      RowBox[{"c", "[", "52", "]"}], "-", 
      RowBox[{"c", "[", "54", "]"}], "+", 
      RowBox[{"c", "[", "56", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "62", "]"}], "\[Rule]", 
     RowBox[{"1", "+", 
      RowBox[{"c", "[", "5", "]"}], "+", 
      RowBox[{"c", "[", "6", "]"}], "-", 
      RowBox[{"c", "[", "7", "]"}], "-", 
      RowBox[{"c", "[", "8", "]"}], "+", 
      RowBox[{"c", "[", "39", "]"}], "-", 
      RowBox[{"c", "[", "42", "]"}], "+", 
      RowBox[{"c", "[", "59", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "63", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "1", "]"}], "-", 
      RowBox[{"c", "[", "2", "]"}], "-", 
      RowBox[{"c", "[", "5", "]"}], "+", 
      RowBox[{"c", "[", "7", "]"}], "-", 
      RowBox[{"c", "[", "32", "]"}], "+", 
      RowBox[{"c", "[", "34", "]"}], "+", 
      RowBox[{"c", "[", "40", "]"}], "-", 
      RowBox[{"c", "[", "43", "]"}], "-", 
      RowBox[{"c", "[", "52", "]"}], "+", 
      RowBox[{"c", "[", "54", "]"}], "+", 
      RowBox[{"c", "[", "60", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "64", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"c", "[", "1", "]"}], "+", 
      RowBox[{"c", "[", "2", "]"}], "-", 
      RowBox[{"c", "[", "6", "]"}], "+", 
      RowBox[{"c", "[", "8", "]"}], "+", 
      RowBox[{"c", "[", "32", "]"}], "-", 
      RowBox[{"c", "[", "34", "]"}], "+", 
      RowBox[{"c", "[", "41", "]"}], "-", 
      RowBox[{"c", "[", "44", "]"}], "+", 
      RowBox[{"c", "[", "52", "]"}], "-", 
      RowBox[{"c", "[", "54", "]"}], "+", 
      RowBox[{"c", "[", "61", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "67", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "9", "]"}], "-", 
      RowBox[{"c", "[", "10", "]"}], "+", 
      RowBox[{"c", "[", "11", "]"}], "-", 
      RowBox[{"c", "[", "12", "]"}], "-", 
      RowBox[{"c", "[", "25", "]"}], "+", 
      RowBox[{"c", "[", "26", "]"}], "+", 
      RowBox[{"c", "[", "65", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "68", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "25", "]"}], "-", 
      RowBox[{"c", "[", "26", "]"}], "+", 
      RowBox[{"c", "[", "32", "]"}], "-", 
      RowBox[{"c", "[", "34", "]"}], "+", 
      RowBox[{"c", "[", "36", "]"}], "-", 
      RowBox[{"c", "[", "38", "]"}], "+", 
      RowBox[{"c", "[", "66", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "71", "]"}], "\[Rule]", 
     RowBox[{"1", "-", 
      RowBox[{"c", "[", "9", "]"}], "+", 
      RowBox[{"c", "[", "10", "]"}], "+", 
      RowBox[{"c", "[", "13", "]"}], "-", 
      RowBox[{"c", "[", "15", "]"}], "-", 
      RowBox[{"c", "[", "27", "]"}], "+", 
      RowBox[{"c", "[", "28", "]"}], "+", 
      RowBox[{"c", "[", "69", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "72", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "27", "]"}], "-", 
      RowBox[{"c", "[", "28", "]"}], "-", 
      RowBox[{"c", "[", "32", "]"}], "+", 
      RowBox[{"c", "[", "34", "]"}], "+", 
      RowBox[{"c", "[", "40", "]"}], "-", 
      RowBox[{"c", "[", "43", "]"}], "+", 
      RowBox[{"c", "[", "70", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "75", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"c", "[", "11", "]"}]}], "+", 
      RowBox[{"c", "[", "12", "]"}], "-", 
      RowBox[{"c", "[", "13", "]"}], "+", 
      RowBox[{"c", "[", "15", "]"}], "-", 
      RowBox[{"c", "[", "29", "]"}], "+", 
      RowBox[{"c", "[", "30", "]"}], "+", 
      RowBox[{"c", "[", "73", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "76", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "29", "]"}], "-", 
      RowBox[{"c", "[", "30", "]"}], "-", 
      RowBox[{"c", "[", "36", "]"}], "+", 
      RowBox[{"c", "[", "38", "]"}], "-", 
      RowBox[{"c", "[", "40", "]"}], "+", 
      RowBox[{"c", "[", "43", "]"}], "+", 
      RowBox[{"c", "[", "74", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "80", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "9", "]"}], "-", 
      RowBox[{"c", "[", "10", "]"}], "+", 
      RowBox[{"c", "[", "14", "]"}], "-", 
      RowBox[{"c", "[", "16", "]"}], "-", 
      RowBox[{"c", "[", "31", "]"}], "+", 
      RowBox[{"c", "[", "33", "]"}], "+", 
      RowBox[{"c", "[", "77", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "81", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"c", "[", "31", "]"}], "+", 
      RowBox[{"c", "[", "32", "]"}], "-", 
      RowBox[{"c", "[", "33", "]"}], "-", 
      RowBox[{"c", "[", "34", "]"}], "+", 
      RowBox[{"c", "[", "41", "]"}], "-", 
      RowBox[{"c", "[", "44", "]"}], "+", 
      RowBox[{"c", "[", "78", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "86", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "11", "]"}], "-", 
      RowBox[{"c", "[", "12", "]"}], "-", 
      RowBox[{"c", "[", "14", "]"}], "+", 
      RowBox[{"c", "[", "16", "]"}], "-", 
      RowBox[{"c", "[", "35", "]"}], "+", 
      RowBox[{"c", "[", "37", "]"}], "+", 
      RowBox[{"c", "[", "83", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "87", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "35", "]"}], "+", 
      RowBox[{"c", "[", "36", "]"}], "-", 
      RowBox[{"c", "[", "37", "]"}], "-", 
      RowBox[{"c", "[", "38", "]"}], "-", 
      RowBox[{"c", "[", "41", "]"}], "+", 
      RowBox[{"c", "[", "44", "]"}], "+", 
      RowBox[{"c", "[", "84", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "88", "]"}], "\[Rule]", 
     RowBox[{"1", "-", 
      RowBox[{"c", "[", "9", "]"}], "+", 
      RowBox[{"c", "[", "10", "]"}], "-", 
      RowBox[{"c", "[", "11", "]"}], "+", 
      RowBox[{"c", "[", "12", "]"}], "-", 
      RowBox[{"c", "[", "32", "]"}], "+", 
      RowBox[{"c", "[", "34", "]"}], "-", 
      RowBox[{"c", "[", "36", "]"}], "+", 
      RowBox[{"c", "[", "38", "]"}], "+", 
      RowBox[{"c", "[", "79", "]"}], "-", 
      RowBox[{"c", "[", "82", "]"}], "+", 
      RowBox[{"c", "[", "85", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "93", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "13", "]"}], "+", 
      RowBox[{"c", "[", "14", "]"}], "-", 
      RowBox[{"c", "[", "15", "]"}], "-", 
      RowBox[{"c", "[", "16", "]"}], "-", 
      RowBox[{"c", "[", "39", "]"}], "+", 
      RowBox[{"c", "[", "42", "]"}], "+", 
      RowBox[{"c", "[", "89", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "94", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"c", "[", "39", "]"}], "+", 
      RowBox[{"c", "[", "40", "]"}], "+", 
      RowBox[{"c", "[", "41", "]"}], "-", 
      RowBox[{"c", "[", "42", "]"}], "-", 
      RowBox[{"c", "[", "43", "]"}], "-", 
      RowBox[{"c", "[", "44", "]"}], "+", 
      RowBox[{"c", "[", "90", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "95", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"c", "[", "9", "]"}], "-", 
      RowBox[{"c", "[", "10", "]"}], "-", 
      RowBox[{"c", "[", "13", "]"}], "+", 
      RowBox[{"c", "[", "15", "]"}], "+", 
      RowBox[{"c", "[", "32", "]"}], "-", 
      RowBox[{"c", "[", "34", "]"}], "-", 
      RowBox[{"c", "[", "40", "]"}], "+", 
      RowBox[{"c", "[", "43", "]"}], "-", 
      RowBox[{"c", "[", "79", "]"}], "+", 
      RowBox[{"c", "[", "82", "]"}], "+", 
      RowBox[{"c", "[", "91", "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"c", "[", "96", "]"}], "\[Rule]", 
     RowBox[{"1", "-", 
      RowBox[{"c", "[", "9", "]"}], "+", 
      RowBox[{"c", "[", "10", "]"}], "-", 
      RowBox[{"c", "[", "14", "]"}], "+", 
      RowBox[{"c", "[", "16", "]"}], "-", 
      RowBox[{"c", "[", "32", "]"}], "+", 
      RowBox[{"c", "[", "34", "]"}], "-", 
      RowBox[{"c", "[", "41", "]"}], "+", 
      RowBox[{"c", "[", "44", "]"}], "+", 
      RowBox[{"c", "[", "79", "]"}], "-", 
      RowBox[{"c", "[", "82", "]"}], "+", 
      RowBox[{"c", "[", "92", "]"}]}]}]}], "}"}], 
  "}"}]], "Output",ExpressionUUID->"ebd80d3f-7666-4fe3-885f-e1a94dafa527"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"First", "[", "%", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.427233848028667*^9, 
  3.427233854487688*^9}},ExpressionUUID->"bb96759c-c449-4820-8eb2-\
464871830272"],

Cell[BoxData["27"], \
"Output",ExpressionUUID->"05cfb72f-4eaa-4a7a-8e61-d03aa1b6cd8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"instance", "=", 
  RowBox[{"First", "@", 
   RowBox[{"FindInstance", "[", 
    RowBox[{"system", ",", 
     RowBox[{"Array", "[", 
      RowBox[{"c", ",", "96"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4272337234369698`*^9, 
  3.427233784596931*^9}},ExpressionUUID->"5265a7ed-8201-45e2-98ba-\
3e4a5844b700"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "[", "1", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "2", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "3", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "4", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "5", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "6", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "7", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "8", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "9", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "10", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "11", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "12", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "13", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "14", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "15", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "16", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "17", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "18", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "19", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "20", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "21", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "22", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "23", "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "24", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "25", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "26", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "27", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "28", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "29", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "30", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "31", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "32", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "33", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "34", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "35", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "36", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "37", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "38", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "39", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "40", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "41", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "42", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "43", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "44", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "45", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "46", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "47", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "48", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "49", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "50", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "51", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "52", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "53", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "54", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "55", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "56", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "57", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "58", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "59", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "60", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "61", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "62", "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "63", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "64", "]"}], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"c", "[", "65", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "66", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "67", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "68", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "69", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "70", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "71", "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "72", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "73", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "74", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "75", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "76", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "77", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "78", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "79", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "80", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "81", "]"}], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"c", "[", "82", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "83", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "84", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "85", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "86", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "87", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "88", "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "89", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "90", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "91", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "92", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "93", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "94", "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "95", "]"}], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"c", "[", "96", "]"}], "\[Rule]", "1"}]}], 
  "}"}]], "Output",ExpressionUUID->"5db7c803-6a11-4cb8-83cb-7f8537c0b005"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"instance", ",", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"_", "\[Rule]", 
     RowBox[{"1", "|", 
      RowBox[{"-", "1"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"391bba0d-6d6f-4317-bd6a-eba0c52d925e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "[", "23", "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "62", "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "64", "]"}], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"c", "[", "71", "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "81", "]"}], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"c", "[", "88", "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"c", "[", "95", "]"}], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"c", "[", "96", "]"}], "\[Rule]", "1"}]}], 
  "}"}]], "Output",ExpressionUUID->"9d43dc36-5e6a-4ee1-b792-b3c6b7b616a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"list", ".", 
   RowBox[{"Array", "[", 
    RowBox[{"c", ",", "96"}], "]"}]}], "/.", 
  "instance"}]], \
"Input",ExpressionUUID->"f07f7deb-b29c-44c8-b024-23424305d58d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "D", "B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     D, -$CellContext`B\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"B", "C", "B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`B, -
     C, -$CellContext`B\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "D", "A\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     D, -$CellContext`A\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "C", "A\[Dagger]", "C\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -
     C, -$CellContext`A\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -D],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"C", "D", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-C, -
     D, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`D\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"da2c5974-3a64-4666-b7bf-4ccee29d740b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"diff", "+", "%"}], "//", 
  "ToCanonical"}]], \
"Input",ExpressionUUID->"2a48a4ac-cbf9-44b0-9dc1-50619e6a3676"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"104cd9fc-9e8a-4e7d-b90d-3dee12a9d9c6"]
}, Open  ]],

Cell["\<\
which says that our original expression is a linear combination of the \
dim-dep identities. Clean up:\
\>", "Text",
 CellChangeTimes->{{3.461421406377974*^9, 
  3.461421407249316*^9}},ExpressionUUID->"57c0c667-a704-48d3-8f1c-\
b8e03b6a5de3"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "antisym1", ",", "antisym2", ",", "list1", ",", "list2", ",", "list", ",", 
   "system", ",", "diff", ",", "instance", ",", "exprA", ",", "exprB", ",", 
   "adg", ",", "bdg", ",", "cdg", ",", "ddg"}], 
  "]"}]], "Input",ExpressionUUID->"7f451bcb-ba10-4178-a00e-97a7cd892186"],

Cell["With the Ricci tensor :", "Text",
 CellChangeTimes->{{3.419258111716641*^9, 
  3.419258115434383*^9}},ExpressionUUID->"63543a4a-e318-4527-9715-\
91b63a6d48ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.409555701631792*^9, 3.409555722934348*^9}, 
   3.419257238486166*^9, {3.426794323868102*^9, 
   3.4267943244456367`*^9}},ExpressionUUID->"8cf6276d-b248-436b-9ad6-\
b4ca84e64e11"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", "A\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", "B\[Dagger]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"ddfd351b-d5b6-474d-b8f2-cb0761a961c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.409555725544402*^9, 
  3.409555732366086*^9}},ExpressionUUID->"956f9d6e-c194-40fb-85f5-\
618a6076af60"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"\[Sigma]R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"A", "A\[Dagger]", "B", "B\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Sigma]\[UnderBracket]RicciCD[-$CellContext`A, \
-$CellContext`A\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]],
  Editable->
   False]], "Output",ExpressionUUID->"2febe9e6-e88d-406b-a6c5-5c0d80c21696"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.423302504085627*^9, 
  3.423302506392333*^9}},ExpressionUUID->"d616e6fd-8e76-4712-82ef-\
a2d16bf0c9b3"],

Cell["\[Sigma]\[UnderBracket]RicciCD[-A, -A\[Dagger], -B, -B\[Dagger]]", \
"Output",ExpressionUUID->"0cf2b0fe-3e08-41ba-889b-202d652ef1e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.4095557345114803`*^9, 
  3.4095557428547907`*^9}},ExpressionUUID->"f1d26681-0b19-48a5-84ee-\
73090755a8b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -$CellContext`B, -$CellContext`A\
\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{"6", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"744b5aa8-8d8d-4960-af2a-1d2ea483dc88"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.409555746893717*^9, 
  3.409555753711657*^9}},ExpressionUUID->"fc667a3c-6ba2-434d-b82e-\
3ac97d18b244"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Phicd[-$CellContext`A, -$CellContext`B, -$CellContext`A\
\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False]}], "+", 
  RowBox[{"6", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Lambdacd[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A\[Dagger]", "B\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"838540c2-c619-4c12-99b9-3f15a61be0ba"]
}, Open  ]],

Cell["We can work out similar calculations for the Weyl tensor :", "Text",
 CellChangeTimes->{{3.408362831232996*^9, 3.408362833763386*^9}, {
  3.408883765293333*^9, 3.408883769039012*^9}, {3.409053739069888*^9, 
  3.4090537441900578`*^9}, {3.409053815281786*^9, 3.409053834194694*^9}, {
  3.419334964150996*^9, 3.419334965105845*^9}, {3.419336717367196*^9, 
  3.419336719970873*^9}},ExpressionUUID->"288b8bb6-eeb4-4d90-bed0-\
f7781a40d26d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeylCD", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellChangeTimes->{{3.408883799628558*^9, 
  3.408883807572377*^9}},ExpressionUUID->"d50a5c17-b0f1-4214-bf57-\
800ae3c0bacf"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {"a", "b", "c", "d"},
         {" ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`WeylCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
  Editable->
   False]], "Output",ExpressionUUID->"403d1a46-068b-4166-a6e8-538b5929b169"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.408883812523819*^9, 3.408883823272286*^9}, 
   3.419257246961899*^9, {3.426794331883575*^9, 
   3.426794332402246*^9}},ExpressionUUID->"b8b0f821-2371-419f-9abc-\
4cbfb313e44b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {"a", "b", "c", "d"},
          {" ", " ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "A\[Dagger]"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", "B\[Dagger]"},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "C", "C\[Dagger]"},
          {"c", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "D", "D\[Dagger]"},
          {"d", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`d, D, $CellContext`D\[Dagger]],
   Editable->
    False]}]], "Output",ExpressionUUID->"7d04f03d-845f-4b96-bd54-7e4cb90a2a11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.4088838543197117`*^9, 
  3.408883860166727*^9}},ExpressionUUID->"0ee010fa-16ff-47e0-b959-\
c29035242d02"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"\[Sigma]W", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {"A", "A\[Dagger]", "B", "B\[Dagger]", "C", "C\[Dagger]", "D", 
          "D\[Dagger]"},
         {" ", " ", " ", " ", " ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Sigma]\[UnderBracket]WeylCD[$CellContext`A, $CellContext`A\
\[Dagger], $CellContext`B, $CellContext`B\[Dagger], 
   C, $CellContext`C\[Dagger], D, $CellContext`D\[Dagger]],
  Editable->
   False]], "Output",ExpressionUUID->"fa4e1747-ebe4-4ea2-934e-e0f08b6cf4c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decomposition", "[", 
  RowBox[{"%", ",", "Weyl"}], "]"}]], "Input",
 CellChangeTimes->{{3.423581099758046*^9, 
  3.42358111188833*^9}},ExpressionUUID->"35e702b4-32f5-41ae-8f9c-\
9bb1a56ee819"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]", 
       StyleBox[GridBox[{
          {"A", "F"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon][$CellContext`A, $CellContext`F],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]", 
       StyleBox[GridBox[{
          {"B", "G"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon][$CellContext`B, $CellContext`G],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]", 
       StyleBox[GridBox[{
          {"C", "G1"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon][C, $CellContext`G1],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]", 
       StyleBox[GridBox[{
          {"D", "G10"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon][D, $CellContext`G10],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]\[Dagger]", 
       StyleBox[GridBox[{
          {"A\[Dagger]", "F\[Dagger]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon]\[Dagger][$CellContext`A\[Dagger], $CellContext`F\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]\[Dagger]", 
       StyleBox[GridBox[{
          {"B\[Dagger]", "G10\[Dagger]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon]\[Dagger][$CellContext`B\[Dagger], $CellContext`G10\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]\[Dagger]", 
       StyleBox[GridBox[{
          {"C\[Dagger]", "G11\[Dagger]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon]\[Dagger][$CellContext`C\[Dagger], $CellContext`G11\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]\[Dagger]", 
       StyleBox[GridBox[{
          {"D\[Dagger]", "G12\[Dagger]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon]\[Dagger][$CellContext`D\[Dagger], $CellContext`G12\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
            "\[Dagger]"}], 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {"F\[Dagger]", "G10\[Dagger]", "G12\[Dagger]", "G11\[Dagger]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Psicd\[Dagger][-$CellContext`F\[Dagger], \
-$CellContext`G10\[Dagger], -$CellContext`G12\[Dagger], -$CellContext`G11\
\[Dagger]],
       Editable->False]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"F", "G"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`F, -$CellContext`G],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"G10", "G1"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`G10, -$CellContext`G1],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"F", "G", "G10", "G1"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Psicd[-$CellContext`F, -$CellContext`G, -$CellContext`G10, \
-$CellContext`G1],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]\[Dagger]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"F\[Dagger]", "G10\[Dagger]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][-$CellContext`F\[Dagger], \
-$CellContext`G10\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]\[Dagger]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"G12\[Dagger]", "G11\[Dagger]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][-$CellContext`G12\[Dagger], \
-$CellContext`G11\[Dagger]],
      Editable->False]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"ef8f6973-78fd-4ec4-88f6-3de166c85248"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "@", "%"}]], "Input",
 CellChangeTimes->{{3.408883867348555*^9, 
  3.408883878767818*^9}},ExpressionUUID->"7542a49d-ce3c-4609-b7ed-\
5a1c4422bb71"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         "\[Dagger]"}], 
        StyleBox[GridBox[{
           {"A\[Dagger]", "B\[Dagger]", "D\[Dagger]", "C\[Dagger]"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd\[Dagger][$CellContext`A\[Dagger], $CellContext`B\
\[Dagger], $CellContext`D\[Dagger], $CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"B", "A"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][$CellContext`B, $CellContext`A],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"D", "C"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][D, C],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"A", "B", "D", "C"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Psicd[$CellContext`A, $CellContext`B, D, C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {"B\[Dagger]", "A\[Dagger]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][$CellContext`B\[Dagger], $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {"D\[Dagger]", "C\[Dagger]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][$CellContext`D\[Dagger], $CellContext`C\
\[Dagger]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"58735ede-54e4-48d8-84ad-47f4196f8e92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"-", "a"}], "]"}], "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.408293665022477*^9, 
  3.408293669243114*^9}},ExpressionUUID->"fef4f6e3-57d8-4d5f-b3fe-\
07e87f10abb7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {"B\[Dagger]", "A\[Dagger]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][$CellContext`B\[Dagger], $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]\[Dagger]", 
        StyleBox[GridBox[{
           {"D\[Dagger]", "C\[Dagger]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][$CellContext`D\[Dagger], $CellContext`C\
\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"A", "B", "D", "C"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`cd[-$CellContext`a][
      $CellContext`Psicd[$CellContext`A, $CellContext`B, D, C]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"B", "A"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][$CellContext`B, $CellContext`A],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"D", "C"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][D, C],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {
          RowBox[{
           RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
           "\[Dagger]"}], 
          StyleBox[GridBox[{
             {"A\[Dagger]", "B\[Dagger]", "D\[Dagger]", "C\[Dagger]"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Ration