(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    464663,      12210]
NotebookOptionsPosition[    450078,      11770]
NotebookOutlinePosition[    450480,      11788]
CellTagsIndexPosition[    450437,      11785]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 StyleBox["Example cases with ",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Spinors",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[" included in\nhttp://arxiv.org/abs/1110.2662v1   ",
  FontColor->RGBColor[0, 0, 1]]
}], "Subtitle",
 CellChangeTimes->{{3.432628764630637*^9, 3.432628770497842*^9}, {
  3.528893045792652*^9, 3.528893054344263*^9}, {3.528893271053823*^9, 
  3.5288933115412073`*^9}, {3.528893379389071*^9, 3.528893460125081*^9}}],

Cell[TextData[{
 StyleBox["Alfonso Garc\[IAcute]a-Parrado G\[OAcute]mez-Lobo\n",
  FontSize->18],
 StyleBox["alfonso@math.uminho.pt",
  FontSize->14],
 "\n\n",
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a\n",
  FontSize->18],
 StyleBox["jose@xAct.es",
  FontSize->14],
 "\n\n",
 StyleBox["(c) 2006-2014, under GPL\n\nhttp://www.xAct.es/\n\
http://groups.google.com/group/xAct",
  FontSize->14]
}], "Subsubtitle",
 CellChangeTimes->{{3.528893472814106*^9, 3.528893473925939*^9}, {
  3.611405920691081*^9, 3.6114059207549353`*^9}}],

Cell[CellGroupData[{

Cell["Session start and simple examples", "Subsection",
 CellChangeTimes->{{3.5248228905132017`*^9, 3.524822896794283*^9}, {
   3.5258712103935537`*^9, 3.52587121380063*^9}, 3.526119413672344*^9}],

Cell[TextData[{
 "We load ",
 StyleBox["Spinors.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.524814043804006*^9, 3.524814052022143*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`Spinors`"}]], "Input",
 CellChangeTimes->{{3.5248130523527603`*^9, 3.5248130585765657`*^9}}],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717757208*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2014", ",", "2", ",", "15"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.1", ", ", {2014, 2, 15}],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717758412*^9}],

Cell[BoxData["\<\"CopyRight (C) 2003-2014, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717759406*^9}],

Cell[BoxData["\<\"Connecting to external linux executable...\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717780526*^9}],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717794483*^9}],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717794997*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2014", ",", "2", ",", "23"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.0", ", ", {2014, 2, 23}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717795602*^9}],

Cell[BoxData["\<\"CopyRight (C) 2002-2014, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717796247*^9}],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.6114067179054947`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Spinors`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2014", ",", "2", ",", "15"}], "}"}]}],
  SequenceForm[
  "Package xAct`Spinors`  version ", "1.0.5", ", ", {2014, 2, 15}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717915812*^9}],

Cell[BoxData["\<\"CopyRight (C) 2006-2012, Alfonso Garcia-Parrado Gomez-Lobo \
and Jose M. Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717916271*^9}],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.611406717916752*^9}],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.6114067179172*^9}],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.5288105847165527`*^9, 3.528828388782456*^9, 
  3.5288935026850033`*^9, 3.543573714787648*^9, 3.543578877106017*^9, 
  3.5981843815565777`*^9, 3.598184587588912*^9, 3.59818477978345*^9, 
  3.598184872897456*^9, 3.611405950485773*^9, 3.611406042200305*^9, 
  3.611406543450036*^9, 3.6114067179177*^9}]
}, Open  ]],

Cell["\<\
We define the 4-dimensional manifold and the Lorentzian metric.\
\>", "Text",
 CellChangeTimes->{{3.524814058703106*^9, 3.524814095748355*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M4", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "h", ",", "p"}],
     "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.524813082075573*^9, 3.52481308833361*^9}, {
  3.5248131637365923`*^9, 3.524813174027841*^9}, {3.5249045732264853`*^9, 
  3.524904589177033*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M4, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810586358616*^9, 3.528828389010928*^9, 
  3.528893502979444*^9, 3.543573715093313*^9, 3.543578877426364*^9, 
  3.59818438188752*^9, 3.598184587932026*^9, 3.59818478012122*^9, 
  3.598184873168737*^9, 3.611405950815427*^9, 3.611406042626248*^9, 
  3.611406543678481*^9, 3.611406717983613*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM4, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810586358616*^9, 3.528828389010928*^9, 
  3.528893502979444*^9, 3.543573715093313*^9, 3.543578877426364*^9, 
  3.59818438188752*^9, 3.598184587932026*^9, 3.59818478012122*^9, 
  3.598184873168737*^9, 3.611405950815427*^9, 3.611406042626248*^9, 
  3.611406543678481*^9, 3.6114067179991913`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD"}], "]"}]], "Input",
 CellChangeTimes->{{3.52481317634448*^9, 3.5248132041591873`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718021562*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.6114067180375*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.6114067180386057`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718039496*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718040307*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718041009*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718041931*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718042549*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718044779*^9}],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718064986*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718080635*^9}],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.6114067180908203`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.6114067180996523`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.6114067181435547`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.6114067182860947`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718316066*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718317191*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.611406718452272*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.61140671846719*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810587806735*^9, 3.528828389026276*^9, 
  3.528893503005658*^9, 3.543573715111001*^9, 3.543578877461524*^9, 
  3.598184381926463*^9, 3.59818458797908*^9, 3.598184780167314*^9, 
  3.5981848732524633`*^9, 3.6114059508833103`*^9, 3.6114060427174788`*^9, 
  3.6114065437021847`*^9, 3.6114067184840803`*^9}]
}, Open  ]],

Cell["We define the spin structure and its formatting options.  ", "Text",
 CellChangeTimes->{{3.524814388148225*^9, 3.524814408687663*^9}, {
  3.5258712348725348`*^9, 3.5258712402806463`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "P"}], "}"}], 
   ",", "\[Epsilon]", ",", "\[Sigma]", ",", "CDe", ",", 
   RowBox[{"SpinorPrefix", "\[Rule]", "SP"}], ",", 
   RowBox[{"SpinorMark", "\[Rule]", "\"\<S\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.524813228450288*^9, 3.524813242564487*^9}, {
  3.5248133520385933`*^9, 3.524813366589457*^9}, {3.524813584648424*^9, 
  3.524813609152042*^9}, {3.5248175363822813`*^9, 3.524817536748589*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "Spin", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`Spin, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718500553*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"System name \[NoBreak]\\!\\(\\\"C\\\"\\)\[NoBreak] is \
overloaded as an abstract index.\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.528810589549715*^9, 3.528828389483807*^9, 
  3.528893503426629*^9, 3.543573715725773*^9, 3.543578878063232*^9, 
  3.598184382683764*^9, 3.5981845886721478`*^9, 3.598184780915835*^9, 
  3.598184874019919*^9, 3.611405951653598*^9, 3.611406043438075*^9, 
  3.611406544407095*^9, 3.611406718638345*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"System name \[NoBreak]\\!\\(\\\"D\\\"\\)\[NoBreak] is \
overloaded as an abstract index.\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.528810589549715*^9, 3.528828389483807*^9, 
  3.528893503426629*^9, 3.543573715725773*^9, 3.543578878063232*^9, 
  3.598184382683764*^9, 3.5981845886721478`*^9, 3.598184780915835*^9, 
  3.598184874019919*^9, 3.611405951653598*^9, 3.611406043438075*^9, 
  3.611406544407095*^9, 3.61140671880719*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "Spin\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between Spin and \
Spin\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`Spin\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between Spin and Spin\[Dagger]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718822563*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma][$CellContext`a, -C, -$CellContext`D\[Dagger]], ". ", 
   ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.6114067188230877`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"soldering form \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Sigma]\[Dagger]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "soldering form ", 
   $CellContext`\[Sigma]\[Dagger][$CellContext`a, -$CellContext`C\[Dagger], -
    D], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.6114067188236513`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718824149*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spin metric \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Epsilon]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spin metric ", 
   $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718824655*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[Sigma]", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[Sigma][$CellContext`a, $CellContext`b, \
-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718852326*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Sigma\[Sigma]\[Dagger]", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Sigma\[Sigma]\[Dagger][$CellContext`a, $CellContext`b, \
-$CellContext`A\[Dagger], -$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718866847*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]g", "[", 
    RowBox[{"A", ",", "C\[Dagger]", ",", "B", ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor g\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]g[$CellContext`A, $CellContext`C\[Dagger], \
$CellContext`B, $CellContext`D\[Dagger]], ". ", "Equivalent of tensor g"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718928369*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]g\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", "C", ",", "B\[Dagger]", ",", "D"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor g\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]g\[Dagger][$CellContext`A\[Dagger], 
    C, $CellContext`B\[Dagger], D], ". ", "Equivalent of tensor g"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718942984*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]epsilong", "[", 
    RowBox[{
    "A", ",", "A\[Dagger]", ",", "B", ",", "B\[Dagger]", ",", "C", ",", 
     "C\[Dagger]", ",", "D", ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor epsilong\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]epsilong[$CellContext`A, $CellContext`A\
\[Dagger], $CellContext`B, $CellContext`B\[Dagger], 
    C, $CellContext`C\[Dagger], D, $CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor epsilong"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.61140671894352*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]epsilong\[Dagger]", "[", 
    RowBox[{
    "A\[Dagger]", ",", "A", ",", "B\[Dagger]", ",", "B", ",", "C\[Dagger]", 
     ",", "C", ",", "D\[Dagger]", ",", "D"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor epsilong\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]epsilong\[Dagger][$CellContext`A\[Dagger], \
$CellContext`A, $CellContext`B\[Dagger], $CellContext`B, $CellContext`C\
\[Dagger], C, $CellContext`D\[Dagger], D], ". ", 
   "Equivalent of tensor epsilong"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.6114067189447193`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDe", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDe[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718954674*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDe", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`ChristoffelCDCDe[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.61140671895608*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCDe", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelCDe[$CellContext`A, -$CellContext`b, -C], ". ", 
   ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718956883*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCDe\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelCDe\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718957509*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannCDe", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannCDe[-$CellContext`a, -$CellContext`b, -C, D], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718958116*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannCDe\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718958729*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemannCDe\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]FRiemannCDe[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -C, -D], ". ", 
   "Equivalent of tensor FRiemannCDe"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.61140671895957*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemannCDe\[Dagger]\"\>"}],
  
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]FRiemannCDe\[Dagger][-$CellContext`A\[Dagger]\
, -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor FRiemannCDe\[Dagger]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718969378*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`ChiCDe[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718970037*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChiCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`ChiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.6114067189706717`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PhiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718971383*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PhiCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`PhiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718971993*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor scalar curvature \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"LambdaCDe", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "spinor scalar curvature ", 
   $CellContext`LambdaCDe[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406718997056*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PsiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl spinor ", 
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406719011838*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"PsiCDe\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl spinor ", 
   $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406719012517*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RiemannCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]RiemannCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor RiemannCD"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406719030126*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RiemannCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RiemannCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]RiemannCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", 
   "Equivalent of tensor RiemannCD"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406719042605*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]RicciCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", 
   "Equivalent of tensor RicciCD"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406719043148*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]RicciCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor RicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]RicciCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor RicciCD"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.6114067190436897`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor WeylCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]WeylCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor WeylCD"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.6114067190442953`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]WeylCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor WeylCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]WeylCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", 
   "Equivalent of tensor WeylCD"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.611406719053357*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor TFRicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]TFRicciCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", 
   "Equivalent of tensor TFRicciCD"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.6114067190540037`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]TFRicciCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor TFRicciCD\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]TFRicciCD\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor TFRicciCD"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810589514433*^9, 3.528828389415402*^9, 
  3.528893503414592*^9, 3.543573715697456*^9, 3.543578878032463*^9, 
  3.598184382468175*^9, 3.598184588483684*^9, 3.598184780780427*^9, 
  3.5981848738870487`*^9, 3.6114059514418983`*^9, 3.611406043294881*^9, 
  3.611406544209066*^9, 3.6114067190546083`*^9}]
}, Open  ]],

Cell["\<\
The spin structure defines automatically a number of objects as shown in the \
output messsages.  Some of these are the Weyl and the Ricci spinors.\
\>", "Text",
 CellChangeTimes->{{3.524814426353677*^9, 3.524814435914908*^9}, {
  3.5255826176266937`*^9, 3.525582680089472*^9}, {3.5258712509606333`*^9, 
  3.5258712717763987`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PsiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], ",", 
   RowBox[{"PhiCDe", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.524813379748686*^9, 3.5248134113183203`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "C\[Dagger]", "D\[Dagger]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.528810591309527*^9, 3.528828389786972*^9, 
  3.52889350368933*^9, 3.543573716154735*^9, 3.543578878508709*^9, 
  3.5981843832637672`*^9, 3.598184589257761*^9, 3.598184781708137*^9, 
  3.598184874546842*^9, 3.611405952195912*^9, 3.611406043964675*^9, 
  3.611406544847886*^9, 3.611406719162161*^9}]
}, Open  ]],

Cell["\<\
The spinor counterpart of the Ricci tensor gets also automatically defined.\
\>", "Text",
 CellChangeTimes->{{3.524814444589189*^9, 3.524814456517714*^9}, {
  3.525582690657158*^9, 3.5255826933130293`*^9}, {3.5255830614467487`*^9, 
  3.52558307926923*^9}, {3.525871284953224*^9, 3.525871285889173*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SP\[UnderBracket]RicciCD", "[", 
  RowBox[{
   RowBox[{"-", "A"}], ",", 
   RowBox[{"-", "A\[Dagger]"}], ",", 
   RowBox[{"-", "B"}], ",", 
   RowBox[{"-", "B\[Dagger]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.524813502074648*^9, 3.524813510471108*^9}, {
  3.524813618982885*^9, 3.5248136343229303`*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"SR", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"A", "A\[Dagger]", "B", "B\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP\[UnderBracket]RicciCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]],
  Editable->False]], "Output",
 CellChangeTimes->{3.528810592483572*^9, 3.528828389801057*^9, 
  3.528893503708538*^9, 3.543573716166477*^9, 3.543578878537065*^9, 
  3.598184383642688*^9, 3.598184589331374*^9, 3.598184781804624*^9, 
  3.598184874618689*^9, 3.611405952265223*^9, 3.611406044056869*^9, 
  3.61140654486707*^9, 3.611406719181694*^9}]
}, Open  ]],

Cell["\<\
We can modify the  output display of any quantity. For example we can select \
a displayed output for primed indices similar to that of textbooks.\
\>", "Text",
 CellChangeTimes->{{3.524814468871592*^9, 3.524814480040884*^9}, {
  3.5255831501004763`*^9, 3.525583255020282*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAs", "[", "A\[Dagger]", "]"}], "^=", "\"\<A'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "@", "B\[Dagger]"}], "^=", "\"\<B'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "@", "C\[Dagger]"}], "^=", "\"\<C'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "@", "D\[Dagger]"}], "^=", "\"\<D'\>\""}], ",", 
    RowBox[{
     RowBox[{"PrintAs", "@", "F\[Dagger]"}], "^=", "\"\<F'\>\""}]}], "}"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.524814481172297*^9, 3.52481460612254*^9}, 
   3.5248147198970633`*^9}],

Cell["\<\
Something similar can be done with the complex conjugate of the spin metric.\
\>", "Text",
 CellChangeTimes->{{3.524815201451745*^9, 3.524815230872019*^9}, {
  3.525583261787418*^9, 3.5255832763066607`*^9}, {3.525871314023334*^9, 
  3.5258713476711903`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "@", "\[Epsilon]\[Dagger]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[Epsilon]\), \(_\)]\)\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.524815232840959*^9, 3.524815254752124*^9}}],

Cell["\<\
We test now some of the built-in commands. For example let us compute the \
irreducible decomposition of the Riemann spinor.\
\>", "Text",
 CellChangeTimes->{{3.524815373875578*^9, 3.524815394399839*^9}, {
  3.5255832926516857`*^9, 3.525583331026208*^9}, {3.525871396054723*^9, 
  3.525871396511572*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SP\[UnderBracket]RiemannCD", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "B\[Dagger]"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "C\[Dagger]"}], ",", 
    RowBox[{"-", "D"}], ",", 
    RowBox[{"-", "D\[Dagger]"}]}], "]"}], "//", "Decomposition"}]], "Input",
 CellChangeTimes->{{3.524815395942415*^9, 3.524815432667561*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          "\[Dagger]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"B", "'"}], 
             RowBox[{"D", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PsiCDe\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`D\[Dagger], -$CellContext`C\[Dagger]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-D, -C],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", 
            RowBox[{"D", "'"}], 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`D\
\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-D, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "_"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LambdaCDe[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "_"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               RowBox[{"A", "'"}], 
               RowBox[{"D", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "_"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               RowBox[{"B", "'"}], 
               RowBox[{"C", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`A, -C],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"B", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon][-$CellContext`B, -D],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "_"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               RowBox[{"A", "'"}], 
               RowBox[{"C", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`C\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Epsilon]", "_"], 
           StyleBox[GridBox[{
              {" ", " "},
              {
               RowBox[{"B", "'"}], 
               RowBox[{"D", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`D\[Dagger]],
       Editable->False]}]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"D", "C", 
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PhiCDe[-D, -
     C, -$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "_"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"D", "'"}], 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", "B", "D", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -D, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "_"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"A", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "_"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"D", "'"}], 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`D\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.528810597471361*^9, 3.5288283898298063`*^9, 
  3.528893503739326*^9, 3.543573716247541*^9, 3.543578878633003*^9, 
  3.598184383758293*^9, 3.598184589554759*^9, 3.598184781959017*^9, 
  3.5981848747626963`*^9, 3.611405952389666*^9, 3.611406044181217*^9, 
  3.6114065449192333`*^9, 3.611406719253634*^9}]
}, Open  ]],

Cell["Handling of the 2-index spin covariant derivative.", "Text",
 CellChangeTimes->{{3.524815462207876*^9, 3.5248154759889107`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDe", "[", 
   RowBox[{
    RowBox[{"-", "F"}], ",", 
    RowBox[{"-", "F\[Dagger]"}]}], "]"}], "@", 
  RowBox[{"PsiCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.524815479235592*^9, 3.5248155010285063`*^9}, {
  3.525873139686406*^9, 3.525873154179937*^9}, {3.5258741382546797`*^9, 
  3.525874148295486*^9}, {3.525874634956916*^9, 3.5258746885759783`*^9}, {
  3.525874784971201*^9, 3.5258747955713043`*^9}, {3.525874879212885*^9, 
  3.525874880026268*^9}, {3.526202634098322*^9, 3.526202635130513*^9}, {
  3.526204311281733*^9, 3.5262043126413527`*^9}, {3.5262043443697853`*^9, 
  3.526204346639298*^9}, {3.52629062429431*^9, 3.5262906286311903`*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", 
     RowBox[{"FF", "'"}], "  "], GridBox[{
      {
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[-$CellContext`F, -$CellContext`F\[Dagger]][
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D]],
  Editable->False]], "Output",
 CellChangeTimes->{3.528810599214902*^9, 3.528828389841942*^9, 
  3.528893503756777*^9, 3.543573716257485*^9, 3.543578878667399*^9, 
  3.598184383823415*^9, 3.5981845896453238`*^9, 3.5981847820437098`*^9, 
  3.59818487480764*^9, 3.6114059524690638`*^9, 3.611406044262142*^9, 
  3.611406544939816*^9, 3.611406719278981*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  RowBox[{"SeparateSolderingForm", "[", "]"}]}]], "Input",
 CellChangeTimes->{{3.526204322631805*^9, 3.526204329023226*^9}}],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "F", 
           RowBox[{"F", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`F, -$CellContext`F\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
        {
         RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A", "B", "C", "D"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`a][
     $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{3.528810622727107*^9, 3.528828389854773*^9, 
  3.5288935037880697`*^9, 3.5435737162672863`*^9, 3.543578878680923*^9, 
  3.5981843838787603`*^9, 3.598184589722294*^9, 3.598184782216915*^9, 
  3.598184874841982*^9, 3.611405952540535*^9, 3.611406044341689*^9, 
  3.611406544967964*^9, 3.61140671931081*^9}]
}, Open  ]],

Cell["We define a hermitian spinor", "Text",
 CellChangeTimes->{{3.524815901667616*^9, 3.524815907213937*^9}, {
  3.524815952242778*^9, 3.524815956755499*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Kappa]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"Dagger", "->", "Hermitian"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5248159082167597`*^9, 3.5248159280286217`*^9}, {
  3.524815968148424*^9, 3.5248159778988934`*^9}, {3.524816251733898*^9, 
  3.5248162889455147`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810625135303*^9, 3.528828389865453*^9, 
  3.528893503804323*^9, 3.543573716277214*^9, 3.543578878731*^9, 
  3.598184384008251*^9, 3.5981845898086767`*^9, 3.598184782319666*^9, 
  3.598184874897047*^9, 3.611405952614695*^9, 3.6114060444287653`*^9, 
  3.611406544991048*^9, 3.611406719345916*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Kappa]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Kappa]\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528810625135303*^9, 3.528828389865453*^9, 
  3.528893503804323*^9, 3.543573716277214*^9, 3.543578878731*^9, 
  3.598184384008251*^9, 3.5981845898086767`*^9, 3.598184782319666*^9, 
  3.598184874897047*^9, 3.611405952614695*^9, 3.6114060444287653`*^9, 
  3.611406544991048*^9, 3.611406719366825*^9}]
}, Open  ]],

Cell["We check the hermiticity of the new spinor", "Text",
 CellChangeTimes->{{3.524815988479892*^9, 3.52481600150537*^9}, {
  3.524816124290249*^9, 3.524816127466552*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Kappa]", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "//", "Dagger"}]], "Input",
 CellChangeTimes->{{3.524816140625548*^9, 3.524816142201282*^9}, {
  3.524816254321849*^9, 3.524816254810042*^9}, {3.524816291711741*^9, 
  3.524816292187035*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Kappa]", 
      StyleBox[GridBox[{
         {" ", " "},
         {"A", 
          RowBox[{"A", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]],
  Editable->False]], "Output",
 CellChangeTimes->{3.528810626444791*^9, 3.5288283898777037`*^9, 
  3.528893503824501*^9, 3.543573716287339*^9, 3.54357887874511*^9, 
  3.598184384083444*^9, 3.598184589995141*^9, 3.598184782412134*^9, 
  3.5981848750471687`*^9, 3.6114059526947327`*^9, 3.611406044511899*^9, 
  3.611406545026309*^9, 3.6114067193924437`*^9}]
}, Open  ]],

Cell["We start now with the canonicalisation examples. ", "Text",
 CellChangeTimes->{{3.524817096703537*^9, 3.524817108352903*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Mu]", "[", "A", "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.5248172313687897`*^9, 3.5248172449840393`*^9}, {
  3.524902035245063*^9, 3.5249020357159348`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Mu]", "[", "A", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Mu][$CellContext`A], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106279164457`*^9, 3.528828389888914*^9, 
  3.528893503828924*^9, 3.543573716317535*^9, 3.543578878772263*^9, 
  3.5981843841469393`*^9, 3.598184590092703*^9, 3.598184782637752*^9, 
  3.598184875096925*^9, 3.611405952769582*^9, 3.611406044594946*^9, 
  3.611406545036892*^9, 3.611406719399055*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Mu]\[Dagger]", "[", "A\[Dagger]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Mu]\[Dagger][$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106279164457`*^9, 3.528828389888914*^9, 
  3.528893503828924*^9, 3.543573716317535*^9, 3.543578878772263*^9, 
  3.5981843841469393`*^9, 3.598184590092703*^9, 3.598184782637752*^9, 
  3.598184875096925*^9, 3.611405952769582*^9, 3.611406044594946*^9, 
  3.611406545036892*^9, 3.6114067194151077`*^9}]
}, Open  ]],

Cell[TextData[{
 "First we check that ",
 StyleBox["Spinors",
  FontSlant->"Italic"],
 " observes the spinorial conventions for raising and lowering of spinor \
indices."
}], "Text",
 CellChangeTimes->{{3.524817955957408*^9, 3.52481799261205*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Mu]", "[", 
     RowBox[{"-", "B"}], "]"}], 
    RowBox[{"\[Epsilon]", "[", 
     RowBox[{"A", ",", "B"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"\[Mu]", "[", "B", "]"}], 
    RowBox[{"\[Epsilon]", "[", 
     RowBox[{
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "A"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"\[Epsilon]\[Dagger]", "[", 
     RowBox[{"C\[Dagger]", ",", "A\[Dagger]"}], "]"}], 
    RowBox[{
     RowBox[{"CDe", "[", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "A\[Dagger]"}]}], "]"}], "@", 
     RowBox[{"\[Mu]", "[", 
      RowBox[{"-", "B"}], "]"}]}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.524817255140259*^9, 3.524817306996582*^9}, {
  3.524817339668045*^9, 3.5248173596116877`*^9}, {3.5249020442086363`*^9, 
  3.524902050786313*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {"A", "B"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][$CellContext`A, $CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Mu]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Mu][-$CellContext`B],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"B", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`B, -$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Mu]", 
         StyleBox[GridBox[{
            {"B"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Mu][$CellContext`B],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Epsilon]", "_"], 
         StyleBox[GridBox[{
            {
             RowBox[{"C", "'"}], 
             RowBox[{"A", "'"}]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][$CellContext`C\[Dagger], $CellContext`A\
\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubsuperscriptBox["\[EmptyDownTriangle]", 
         RowBox[{"AA", "'"}], "  "], GridBox[{
          {"\[Mu]", 
           StyleBox[GridBox[{
              {" "},
              {"B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
       $CellContext`\[Mu][-$CellContext`B]],
      Editable->False], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.5288106295607433`*^9, 3.5288283899106073`*^9, 
  3.528893503847484*^9, 3.543573716333593*^9, 3.543578878790101*^9, 
  3.598184384258184*^9, 3.5981845903193274`*^9, 3.59818478276206*^9, 
  3.598184875408043*^9, 3.611405952856854*^9, 3.6114060447640247`*^9, 
  3.6114065450589867`*^9, 3.61140671945201*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "@", "%"}]], "Input",
 CellChangeTimes->{{3.52481731438315*^9, 3.524817323945691*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Mu]", 
        StyleBox[GridBox[{
           {"A"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Mu][$CellContext`A],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Mu]", 
        StyleBox[GridBox[{
           {" "},
           {"A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Mu][-$CellContext`A],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubsuperscriptBox["\[EmptyDownTriangle]", 
       RowBox[{"A", " "}], 
       RowBox[{" ", 
        RowBox[{"C", "'"}]}]], GridBox[{
        {"\[Mu]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`A, $CellContext`C\[Dagger]][
     $CellContext`\[Mu][-$CellContext`B]],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.528810630053844*^9, 3.528828389924301*^9, 
  3.528893503909128*^9, 3.5435737163439083`*^9, 3.543578878802199*^9, 
  3.5981843843086243`*^9, 3.5981845905088463`*^9, 3.598184782846327*^9, 
  3.5981848754610167`*^9, 3.61140595293421*^9, 3.6114060448498707`*^9, 
  3.611406545079689*^9, 3.611406719489936*^9}]
}, Open  ]],

Cell["Canonicalisation of assorted expressions.", "Text",
 CellChangeTimes->{{3.524818024486842*^9, 3.524818033471542*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Mu]", "[", "A", "]"}], 
    RowBox[{"\[Mu]", "[", 
     RowBox[{"-", "A"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"\[Kappa]", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "B\[Dagger]"}]}], "]"}], 
    RowBox[{"\[Mu]\[Dagger]", "[", "B\[Dagger]", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"CDe", "[", 
      RowBox[{
       RowBox[{"-", "F"}], ",", 
       RowBox[{"-", "F\[Dagger]"}]}], "]"}], "@", 
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{
        RowBox[{"-", "A"}], ",", "F\[Dagger]"}], "]"}], "@", 
      RowBox[{"PsiCDe", "[", 
       RowBox[{
        RowBox[{"-", "B"}], ",", 
        RowBox[{"-", "C"}], ",", 
        RowBox[{"-", "D"}], ",", 
        RowBox[{"-", "P"}]}], "]"}]}]}], "+", 
    RowBox[{
     RowBox[{"CDe", "[", 
      RowBox[{
       RowBox[{"-", "F"}], ",", "F\[Dagger]"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "F\[Dagger]"}]}], "]"}], "@", 
      RowBox[{"PsiCDe", "[", 
       RowBox[{
        RowBox[{"-", "B"}], ",", 
        RowBox[{"-", "C"}], ",", 
        RowBox[{"-", "D"}], ",", 
        RowBox[{"-", "P"}]}], "]"}]}]}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.524817379299012*^9, 3.524817455092065*^9}, {
  3.524817560018949*^9, 3.524817569952828*^9}, {3.524817911340741*^9, 
  3.52481791985463*^9}, {3.5249020572180853`*^9, 3.52490207884518*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Mu]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Mu][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Mu]", 
         StyleBox[GridBox[{
            {"A"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Mu][$CellContext`A],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Kappa]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", 
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa][-$CellContext`A, -$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Mu]\[Dagger]", 
         StyleBox[GridBox[{
            {
             RowBox[{"B", "'"}]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Mu]\[Dagger][$CellContext`B\[Dagger]],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"FF", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"A", " "}], 
        RowBox[{" ", 
         RowBox[{"F", "'"}]}]], GridBox[{
         {
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"B", "C", "D", "P"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`F, -$CellContext`F\[Dagger]][
      $CellContext`CDe[-$CellContext`A, $CellContext`F\[Dagger]][
       $CellContext`PsiCDe[-$CellContext`B, -C, -D, -$CellContext`P]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"F", " "}], 
        RowBox[{" ", 
         RowBox[{"F", "'"}]}]], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"AF", "'"}], "  "], GridBox[{
         {
          RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"B", "C", "D", "P"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`F, $CellContext`F\[Dagger]][
      $CellContext`CDe[-$CellContext`A, -$CellContext`F\[Dagger]][
       $CellContext`PsiCDe[-$CellContext`B, -C, -D, -$CellContext`P]]],
     Editable->False]}]}], "}"}]], "Output",
 CellChangeTimes->{3.528810631130849*^9, 3.528828389938633*^9, 
  3.5288935039320393`*^9, 3.5435737163750877`*^9, 3.543578878816293*^9, 
  3.598184384419352*^9, 3.598184590718577*^9, 3.5981847829442787`*^9, 
  3.5981848755951357`*^9, 3.611405953027096*^9, 3.611406044940144*^9, 
  3.611406545101284*^9, 3.611406719533516*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.524817929278742*^9, 3.524817931788176*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Kappa]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"B", "'"}]},
             {"A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Kappa][-$CellContext`A, $CellContext`B\[Dagger]],
      Editable->False]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Mu]\[Dagger]", 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Mu]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.5288106331013937`*^9, 3.52882839000284*^9, 
  3.528893503963025*^9, 3.543573716403166*^9, 3.5435788788493567`*^9, 
  3.598184384519247*^9, 3.598184590832288*^9, 3.598184783071822*^9, 
  3.598184875691071*^9, 3.611405953146452*^9, 3.6114060451408043`*^9, 
  3.6114065451545057`*^9, 3.61140671960255*^9}]
}, Open  ]],

Cell["Working with spin covariant derivatives", "Text",
 CellChangeTimes->{{3.524818037544511*^9, 3.52481804803384*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CDe", "[", 
    RowBox[{
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "@", 
   RowBox[{
    RowBox[{"CDe", "[", 
     RowBox[{
      RowBox[{"-", "B"}], ",", 
      RowBox[{"-", "B\[Dagger]"}]}], "]"}], "@", 
    RowBox[{"\[Kappa]", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "A\[Dagger]"}]}], "]"}]}]}], "-", 
  RowBox[{
   RowBox[{"CDe", "[", 
    RowBox[{
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "@", 
   RowBox[{
    RowBox[{"CDe", "[", 
     RowBox[{
      RowBox[{"-", "C"}], ",", 
      RowBox[{"-", "C\[Dagger]"}]}], "]"}], "@", 
    RowBox[{"\[Kappa]", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "A\[Dagger]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.524818081241486*^9, 3.524818109044764*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"BB", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"CC", "'"}], "  "], GridBox[{
         {"\[Kappa]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
      $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
       $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]]]],
     Editable->False], ")"}]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[EmptyDownTriangle]", 
      RowBox[{"CC", "'"}], "  "], 
     SubsuperscriptBox["\[EmptyDownTriangle]", 
      RowBox[{"BB", "'"}], "  "], GridBox[{
       {"\[Kappa]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", 
            RowBox[{"A", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
    $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
     $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]]]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.528810634108197*^9, 3.528828390015436*^9, 
  3.528893504003886*^9, 3.543573716430745*^9, 3.543578878865635*^9, 
  3.598184384597583*^9, 3.598184590933216*^9, 3.598184783154126*^9, 
  3.59818487578551*^9, 3.611405953309985*^9, 3.6114060452320843`*^9, 
  3.611406545179161*^9, 3.611406719646694*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortSpinCovDs", "[", 
  RowBox[{"%", ",", "CDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.5248181170896597`*^9, 3.524818127040391*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "_"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"C", "'"}], 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`C\[Dagger], \
-$CellContext`B\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox[
        RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], "CB", 
        "  "], GridBox[{
         {"\[Kappa]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`BoxCDe[-C, -$CellContext`B][
      $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"C", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-C, -$CellContext`B],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox[
        RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], 
        RowBox[{
         RowBox[{"C", "'"}], 
         RowBox[{"B", "'"}]}], "  "], GridBox[{
         {"\[Kappa]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`BoxCDe[-$CellContext`C\[Dagger], -$CellContext`B\[Dagger]][
      $CellContext`\[Kappa][-$CellContext`A, -$CellContext`A\[Dagger]]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{3.528810634765271*^9, 3.528828390027894*^9, 
  3.528893504027722*^9, 3.543573716445216*^9, 3.543578878880642*^9, 
  3.598184384668631*^9, 3.598184591117128*^9, 3.59818478325032*^9, 
  3.598184875850197*^9, 3.6114059533858757`*^9, 3.61140604531679*^9, 
  3.6114065451961937`*^9, 3.611406719686697*^9}]
}, Open  ]],

Cell["\<\
Expansion of the \"Box operator\".  The box operator can be expanded either \
in terms of covariant derivatives or in terms of curvature spinors.\
\>", "Text",
 CellChangeTimes->{{3.524818149639969*^9, 3.524818160873304*^9}, {
  3.524818271249435*^9, 3.52481829601201*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BoxCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}], "@", 
  RowBox[{"\[Kappa]", "[", 
   RowBox[{
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "C\[Dagger]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.524818205838767*^9, 3.524818222463417*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"\[EmptySquare]", "[", "\[EmptyDownTriangle]", "]"}], "AB", 
     "  "], GridBox[{
      {"\[Kappa]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"C", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`BoxCDe[-$CellContext`A, -$CellContext`B][
   $CellContext`\[Kappa][-C, -$CellContext`C\[Dagger]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.52881063655521*^9, 3.5288283901113358`*^9, 
  3.528893504045288*^9, 3.543573716455851*^9, 3.543578878890194*^9, 
  3.5981843847754917`*^9, 3.5981845912150707`*^9, 3.598184783336136*^9, 
  3.598184875931966*^9, 3.611405953458827*^9, 3.6114060453975554`*^9, 
  3.611406545210513*^9, 3.611406719719151*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCovD", "[", 
  RowBox[{"%", ",", "BoxCDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.524818227570697*^9, 3.524818237527402*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"AA", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"B", " "}], 
        RowBox[{" ", 
         RowBox[{"A", "'"}]}]], GridBox[{
         {"\[Kappa]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"C", 
              RowBox[{"C", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
      $CellContext`CDe[-$CellContext`B, $CellContext`A\[Dagger]][
       $CellContext`\[Kappa][-C, -$CellContext`C\[Dagger]]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"BA", "'"}], "  "], 
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"A", " "}], 
        RowBox[{" ", 
         RowBox[{"A", "'"}]}]], GridBox[{
         {"\[Kappa]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"C", 
              RowBox[{"C", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`B, -$CellContext`A\[Dagger]][
      $CellContext`CDe[-$CellContext`A, $CellContext`A\[Dagger]][
       $CellContext`\[Kappa][-C, -$CellContext`C\[Dagger]]]],
     Editable->False]}], ")"}]}]], "Output",
 CellChangeTimes->{3.528810637325349*^9, 3.528828390129291*^9, 
  3.52889350406316*^9, 3.543573716469008*^9, 3.543578878918782*^9, 
  3.598184384855051*^9, 3.598184591292357*^9, 3.598184783492647*^9, 
  3.598184875982946*^9, 3.611405953544241*^9, 3.611406045471344*^9, 
  3.611406545230433*^9, 3.6114067197616568`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxToCurvature", "[", 
  RowBox[{"%%", ",", "BoxCDe"}], "]"}]], "Input",
 CellChangeTimes->{{3.524818244577506*^9, 3.5248182575950603`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalPhi]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"A", "B", 
             RowBox[{"A", "'"}], 
             RowBox[{"C", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`PhiCDe[-$CellContext`A, -$CellContext`B, -$CellContext`A\
\[Dagger], -$CellContext`C\[Dagger]],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Kappa]", 
        StyleBox[GridBox[{
           {" ", 
            RowBox[{"A", "'"}]},
           {"C", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa][-C, $CellContext`A\[Dagger]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalChi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"D", "C", "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChiCDe[-D, -C, -$CellContext`A, -$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Kappa]", 
        StyleBox[GridBox[{
           {"D", " "},
           {" ", 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Kappa][D, -$CellContext`C\[Dagger]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.528810639221677*^9, 3.528828390141589*^9, 
  3.52889350409092*^9, 3.5435737164945707`*^9, 3.543578878946583*^9, 
  3.598184384920454*^9, 3.598184591518808*^9, 3.5981847837369547`*^9, 
  3.59818487615879*^9, 3.611405953630061*^9, 3.6114060455528393`*^9, 
  3.6114065452526007`*^9, 3.611406719791423*^9}]
}, Open  ]],

Cell["Now, we define a new spin covariant derivative with torsion.", "Text",
 CellChangeTimes->{{3.524818410691733*^9, 3.524818417228331*^9}, {
  3.524818460826887*^9, 3.524818463538868*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinCovD", "[", 
  RowBox[{
   RowBox[{"nb", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "\[Sigma]", ",", 
   RowBox[{"SymbolOfCovD", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<|\>\"", ",", "\"\<D\>\""}], "}"}]}], ",", 
   RowBox[{"Torsion", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.524818451880163*^9, 3.524818457008898*^9}, 
   3.598184656994151*^9, 3.5981847250481863`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"nb", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`nb[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.6114067198138733`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Torsionnb", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`Torsionnb[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.61140671982931*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Christoffelnb", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`Christoffelnb[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.6114067198302603`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Riemannnb", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`Riemannnb[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719831134*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Riccinb", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`Riccinb[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.61140671983222*^9}],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719833173*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelnb", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelnb[$CellContext`A, -$CellContext`b, -C], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.61140671983421*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelnb\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelnb\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719835143*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannnb", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannnb[-$CellContext`a, -$CellContext`b, -C, D], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719836155*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannnb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannnb\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719846428*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannnb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemannnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]FRiemannnb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -C, -D], ". ", 
   "Equivalent of tensor FRiemannnb"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719847026*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]FRiemannnb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor FRiemannnb\[Dagger]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]FRiemannnb\[Dagger][-$CellContext`A\[Dagger],\
 -$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor FRiemannnb\[Dagger]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719847611*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Chinb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Chinb[-$CellContext`A, -$CellContext`B, -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719848137*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Chinb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Chinb\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -$CellContext`C\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719848679*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Phinb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Phinb[-$CellContext`A, -$CellContext`B, -$CellContext`C\
\[Dagger], -$CellContext`D\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.6114067198567142`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"curvature spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Phinb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "curvature spinor ", 
   $CellContext`Phinb\[Dagger][-$CellContext`A\[Dagger], -$CellContext`B\
\[Dagger], -C, -D], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.6114067198572702`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Torsionnb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Torsionnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Torsionnb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger]], ". ", "Equivalent of tensor Torsionnb"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719878845*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Torsionnb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Torsionnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Torsionnb\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C], ". ", "Equivalent of tensor Torsionnb"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.6114067198884773`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Omeganb", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion spinor ", 
   $CellContext`Omeganb[-$CellContext`A\[Dagger], -$CellContext`A, \
-$CellContext`B, -C], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.6114067198897047`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Omeganb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion spinor ", 
   $CellContext`Omeganb\[Dagger][-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger], -$CellContext`C\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.6114067198908*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Riemannnb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "D"}], ",", 
     RowBox[{"-", "D\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riemannnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Riemannnb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]], ". ", 
   "Equivalent of tensor Riemannnb"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719901373*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Riemannnb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", 
     RowBox[{"-", "C"}], ",", 
     RowBox[{"-", "D\[Dagger]"}], ",", 
     RowBox[{"-", "D"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riemannnb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Riemannnb\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B, -$CellContext`C\
\[Dagger], -C, -$CellContext`D\[Dagger], -D], ". ", 
   "Equivalent of tensor Riemannnb"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719910963*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Riccinb", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riccinb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Riccinb[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger]], ". ", 
   "Equivalent of tensor Riccinb"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.611406719911525*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]Riccinb\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor Riccinb\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]Riccinb\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", 
   "Equivalent of tensor Riccinb"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288106402341013`*^9, 3.528828390153844*^9, 
  3.528893504117159*^9, 3.543573716566197*^9, 3.5435788791530437`*^9, 
  3.598184384989401*^9, 3.598184591615767*^9, 3.598184660764488*^9, 
  3.598184783847433*^9, 3.598184876231159*^9, 3.611405953716262*^9, 
  3.6114060456345387`*^9, 3.6114065452742567`*^9, 3.6114067199120626`*^9}]
}, Open  ]],

Cell["\<\
The new spin covariant derivative is compatible with the spin structure, as \
it should. \
\>", "Text",
 CellChangeTimes->{{3.5248184786289177`*^9, 3.524818496663849*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "[", 
   RowBox[{"-", "a"}], "]"}], "@", 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"b", ",", 
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5248185014900723`*^9, 3.524818518583338*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5288106422028913`*^9, 3.528828390270961*^9, 
  3.528893504213773*^9, 3.543573716674996*^9, 3.543578879232544*^9, 
  3.598184385114204*^9, 3.598184591753375*^9, 3.598184784132465*^9, 
  3.598184876338105*^9, 3.611405953914839*^9, 3.611406045766968*^9, 
  3.611406545396771*^9, 3.6114067199316177`*^9}]
}, Open  ]],

Cell["The torsion spinors", "Text",
 CellChangeTimes->{{3.524818529732036*^9, 3.524818533052134*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "@", 
  RowBox[{"Torsionnb", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"ST", "[", "D", "]"}], 
       StyleBox[GridBox[{
          {"A", 
           RowBox[{"A", "'"}], " ", " ", " ", " "},
          {" ", " ", "B", 
           RowBox[{"B", "'"}], "C", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SP\[UnderBracket]Torsionnb[$CellContext`A, $CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
    C, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", 
           RowBox[{"B", "'"}]},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "C", 
           RowBox[{"C", "'"}]},
          {"c", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.5288106432155123`*^9, 3.528828390289844*^9, 
  3.528893504230715*^9, 3.543573716709257*^9, 3.543578879261589*^9, 
  3.5981843852646027`*^9, 3.5981845918163643`*^9, 3.598184784335828*^9, 
  3.5981848763733053`*^9, 3.611405953993788*^9, 3.611406045853339*^9, 
  3.611406545422633*^9, 3.6114067199539957`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", 
  RowBox[{"Decomposition", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.524818576407713*^9, 3.524818586367015*^9}}],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]", 
       StyleBox[GridBox[{
          {"A", "D"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon][$CellContext`A, D],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       OverscriptBox["\[Epsilon]", "_"], 
       StyleBox[GridBox[{
          {
           RowBox[{"A", "'"}], 
           RowBox[{"D", "'"}]},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Epsilon]\[Dagger][$CellContext`A\[Dagger], $CellContext`D\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{
           RowBox[{"\[CapitalOmega]", "[", "D", "]"}], "\[Dagger]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"D", 
              RowBox[{"D", "'"}], 
              RowBox[{"B", "'"}], 
              RowBox[{"C", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Omeganb\[Dagger][-
       D, -$CellContext`D\[Dagger], -$CellContext`B\[Dagger], -$CellContext`C\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"B", "C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon][-$CellContext`B, -C],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"\[CapitalOmega]", "[", "D", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {
              RowBox[{"D", "'"}], "D", "B", "C"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Omeganb[-$CellContext`D\[Dagger], -D, -$CellContext`B, -C],
      
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          OverscriptBox["\[Epsilon]", "_"], 
          StyleBox[GridBox[{
             {" ", " "},
             {
              RowBox[{"B", "'"}], 
              RowBox[{"C", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.528810643765609*^9, 3.528828390374061*^9, 
  3.5288935042632837`*^9, 3.543573716756569*^9, 3.543578879308708*^9, 
  3.598184385412108*^9, 3.598184591889009*^9, 3.598184784455834*^9, 
  3.598184876440393*^9, 3.611405954090271*^9, 3.611406045952978*^9, 
  3.61140654546528*^9, 3.611406720007285*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "@", "%"}]], "Input",
 CellChangeTimes->{{3.524818595377486*^9, 3.524818598512525*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         RowBox[{"\[CapitalOmega]", "[", "D", "]"}], "\[Dagger]"}], 
        StyleBox[GridBox[{
           {"A", 
            RowBox[{"A", "'"}], " ", " "},
           {" ", " ", 
            RowBox[{"B", "'"}], 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Omeganb\[Dagger][$CellContext`A, $CellContext`A\[Dagger], \
-$CellContext`B\[Dagger], -$CellContext`C\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][-$CellContext`B, -C],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalOmega]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {
            RowBox[{"A", "'"}], "A", " ", " "},
           {" ", " ", "B", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Omeganb[$CellContext`A\[Dagger], $CellContext`A, \
-$CellContext`B, -C],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        OverscriptBox["\[Epsilon]", "_"], 
        StyleBox[GridBox[{
           {" ", " "},
           {
            RowBox[{"B", "'"}], 
            RowBox[{"C", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon]\[Dagger][-$CellContext`B\[Dagger], \
-$CellContext`C\[Dagger]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.528810644244475*^9, 3.5288283903912477`*^9, 
  3.528893504299361*^9, 3.543573716788658*^9, 3.5435788793442574`*^9, 
  3.598184385471434*^9, 3.5981845919497757`*^9, 3.598184784548455*^9, 
  3.598184876489253*^9, 3.611405954176523*^9, 3.611406046143128*^9, 
  3.611406545489743*^9, 3.6114067200397882`*^9}]
}, Open  ]],

Cell["\<\
Interplay between single index and two index notation for spin covariant \
derivatives.\
\>", "Text",
 CellChangeTimes->{{3.5248187680846157`*^9, 3.524818791775696*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "@", 
  RowBox[{"\[Mu]", "[", 
   RowBox[{"-", "C"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.524818796777363*^9, 3.5248188083667097`*^9}, {
  3.524818857537726*^9, 3.524818872257229*^9}, {3.524818917481098*^9, 
  3.52481893888804*^9}, {3.524822580697752*^9, 3.5248225815166473`*^9}, {
  3.5249047031197433`*^9, 3.524904704562701*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["D", 
     RowBox[{"AA", "'"}], "  "], GridBox[{
      {"\[Mu]", 
       StyleBox[GridBox[{
          {" "},
          {"C"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`nb[-$CellContext`A, -$CellContext`A\[Dagger]][
   $CellContext`\[Mu][-C]],
  Editable->False]], "Output",
 CellChangeTimes->{3.5288106459377203`*^9, 3.528828390405856*^9, 
  3.5288935043260098`*^9, 3.5435737168135843`*^9, 3.543578879353547*^9, 
  3.5981843855531187`*^9, 3.598184592012806*^9, 3.598184784812647*^9, 
  3.59818487664433*^9, 3.611405954346187*^9, 3.611406046224965*^9, 
  3.611406545508277*^9, 3.611406720075643*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "@", "%"}]], "Input",
 CellChangeTimes->{{3.5248188130357656`*^9, 3.5248188179589643`*^9}}],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["D", "a"], GridBox[{
        {"\[Mu]", 
         StyleBox[GridBox[{
            {" "},
            {"C"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`nb[-$CellContext`a][
     $CellContext`\[Mu][-C]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{3.5288106465024843`*^9, 3.528828390411104*^9, 
  3.528893504346696*^9, 3.5435737168335543`*^9, 3.5435788793622637`*^9, 
  3.598184385650893*^9, 3.59818459207045*^9, 3.5981847848990517`*^9, 
  3.5981848767252073`*^9, 3.611405954423341*^9, 3.611406046304945*^9, 
  3.611406545529648*^9, 3.611406720110436*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Relations between spinors and tensors", "Subsection",
 CellChangeTimes->{{3.524822977621546*^9, 3.524822992951391*^9}}],

Cell["We start with a simple example with the Riemann tensor", "Text",
 CellChangeTimes->{{3.52482301386621*^9, 3.524823028892386*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", 
  RowBox[{"RiemannCD", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.524823113697163*^9, 3.524823127384725*^9}}],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", " ", " "},
          {" ", "D", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.528813044982478*^9, 3.528828390456162*^9, 
  3.528893509104031*^9, 3.543573716875267*^9, 3.598184817972198*^9, 
  3.5981848767853937`*^9, 3.611405954516968*^9, 3.611406046401827*^9, 
  3.6114065455587063`*^9, 3.611406720155006*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.524823132162931*^9, 3.5248231365744677`*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"SR", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", " ", " ", " ", " "},
         {"A", 
          RowBox[{"A", "'"}], "B", 
          RowBox[{"B", "'"}], "C", 
          RowBox[{"C", "'"}], "D", 
          RowBox[{"D", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`SP\[UnderBracket]RiemannCD[-$CellContext`A, -$CellContext`A\
\[Dagger], -$CellContext`B, -$CellContext`B\[Dagger], -
   C, -$CellContext`C\[Dagger], -D, -$CellContext`D\[Dagger]],
  Editable->False]], "Output",
 CellChangeTimes->{3.528813045061762*^9, 3.528828390473961*^9, 
  3.528893509165112*^9, 3.543573716890792*^9, 3.598184818120351*^9, 
  3.598184876868971*^9, 3.611405954593609*^9, 3.611406046477325*^9, 
  3.611406545590331*^9, 3.6114067202838583`*^9}]
}, Open  ]],

Cell["\<\
The Riemann spinor can be transformed back into the Riemann tensor as follows\
\
\>", "Text",
 CellChangeTimes->{{3.524823165415099*^9, 3.524823182505435*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "\[Sigma]", "]"}], "@", 
  "%"}]], "Input",
 CellChangeTimes->{{3.5248231444711723`*^9, 3.524823158578122*^9}}],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", " ", " "},
          {" ", "D", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, -D, -$CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.528813045100748*^9, 3.528828390491975*^9, 
  3.52889350918701*^9, 3.5435737169191847`*^9, 3.598184818205168*^9, 
  3.59818487696562*^9, 3.611405954687488*^9, 3.61140604657066*^9, 
  3.611406545613002*^9, 3.611406720313102*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5248234381509943`*^9, 3.524823442144463*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellChangeTimes->{3.528813045143587*^9, 3.528828390512982*^9, 
  3.528893509223011*^9, 3.5435737169379272`*^9, 3.5981848182787237`*^9, 
  3.598184877040296*^9, 3.611405954761063*^9, 3.61140604663968*^9, 
  3.611406545642416*^9, 3.611406720351503*^9}]
}, Open  ]],

Cell["\<\
We study next further examples. First of all, we define a new tensor \
\>", "Text",
 CellChangeTimes->{{3.52482396910931*^9, 3.524824001025817*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"M", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.524824004992012*^9, 3.52482401594494*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"M", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`M[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528813045172615*^9, 3.528828390527666*^9, 
  3.528893509235442*^9, 3.543573716949358*^9, 3.598184818355241*^9, 
  3.598184877087577*^9, 3.611405954836441*^9, 3.611406046717148*^9, 
  3.6114065456628942`*^9, 3.6114067203738813`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "@", 
  RowBox[{"M", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5248240200801077`*^9, 3.5248240349159193`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"SpinorOfTensor", "::", "name"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Spinor of \[NoBreak]\\!\\(M\\)\[NoBreak] not defined. \
Prepending \[NoBreak]\\!\\(SP\\)\[NoBreak].\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.528813045244012*^9, 3.528828390558642*^9, 
  3.528893509262351*^9, 3.543573717022744*^9, 3.598184818466168*^9, 
  3.5981848772415123`*^9, 3.61140595494519*^9, 3.611406046896899*^9, 
  3.6114065457717524`*^9, 3.611406720497518*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]M", "[", 
    RowBox[{
     RowBox[{"-", "P$4201"}], ",", 
     RowBox[{"-", "P\[Dagger]$4201"}], ",", 
     RowBox[{"-", "P$4203"}], ",", 
     RowBox[{"-", "P\[Dagger]$4203"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor M\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]M[-$CellContext`P$4201, -$CellContext`P\
\[Dagger]$4201, -$CellContext`P$4203, -$CellContext`P\[Dagger]$4203], ". ", 
   "Equivalent of tensor M"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528813045246005*^9, 3.52882839056479*^9, 
  3.528893509263096*^9, 3.543573717023922*^9, 3.598184818468334*^9, 
  3.598184877275066*^9, 3.611405954946672*^9, 3.6114060468999*^9, 
  3.6114065457748203`*^9, 3.6114067205150337`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SP\[UnderBracket]M\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "P\[Dagger]$4201"}], ",", 
     RowBox[{"-", "P$4201"}], ",", 
     RowBox[{"-", "P\[Dagger]$4203"}], ",", 
     RowBox[{"-", "P$4203"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor M\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SP\[UnderBracket]M\[Dagger][-$CellContext`P\[Dagger]$4201, \
-$CellContext`P$4201, -$CellContext`P\[Dagger]$4203, -$CellContext`P$4203], 
   ". ", "Equivalent of tensor M"],
  Editable->False]], "Print",
 CellChangeTimes->{3.528813045246005*^9, 3.52882839056479*^9, 
  3.528893509263096*^9, 3.543573717023922*^9, 3.598184818468334*^9, 
  3.598184877275066*^9, 3.611405954946672*^9, 3.6114060468999*^9, 
  3.6114065457748203`*^9, 3.6114067205159082`*^9}],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"SM", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", 
           RowBox[{"A", "'"}], "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SP\[UnderBracket]M[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", 
           RowBox[{"B", "'"}]},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.528813045249858*^9, 3.5288283905665216`*^9, 
  3.528893509278283*^9, 3.543573717030118*^9, 3.5981848185372334`*^9, 
  3.598184877366096*^9, 3.611405955010667*^9, 3.611406046982416*^9, 
  3.61140654578653*^9, 3.6114067205394278`*^9}]
}, Open  ]],

Cell[TextData[{
 "As we see, the spinor ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[GridBox[{
      {"SM", 
       StyleBox[GridBox[{
          {" ", "  ", " ", "  "},
          {"A", 
           RowBox[{"A", "'"}], "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SP\[UnderBracket]M[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]],
   Editable->False]], "Output",
  CellChangeTimes->{3.524824035523099*^9}],
 " is automatically defined. It is possible to define this spinor \"by \
hand\""
}], "Text",
 CellChangeTimes->{{3.524824143421489*^9, 3.5248241830100517`*^9}, {
  3.524824298099175*^9, 3.524824306653883*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinorOfTensor", "[", 
  RowBox[{
   RowBox[{"SPM", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", 
   RowBox[{"M", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "\[Sigma]", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<\[ScriptCapitalM]\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.524824307749486*^9, 3.524824345388014*^9}, {
  3.524826179999423*^9, 3.524826196519526*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SPM", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor M\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SPM[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]], ". ", "Equivalent of tensor M"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288130452624683`*^9, 3.528828390577365*^9, 
  3.528893509289427*^9, 3.5435737170419807`*^9, 3.598184818603654*^9, 
  3.59818487745824*^9, 3.61140595509264*^9, 3.611406047148077*^9, 
  3.6114065458067303`*^9, 3.611406720576695*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"SPM\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of tensor M\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`SPM\[Dagger][-$CellContext`A\[Dagger], -$CellContext`A, \
-$CellContext`B\[Dagger], -$CellContext`B], ". ", "Equivalent of tensor M"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288130452624683`*^9, 3.528828390577365*^9, 
  3.528893509289427*^9, 3.5435737170419807`*^9, 3.598184818603654*^9, 
  3.59818487745824*^9, 3.61140595509264*^9, 3.611406047148077*^9, 
  3.6114065458067303`*^9, 3.611406720592801*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateSolderingForm", "[", "]"}], "@", 
  RowBox[{"M", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5248240200801077`*^9, 3.5248240349159193`*^9}}],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[ScriptCapitalM]", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", 
           RowBox[{"A", "'"}], "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`SPM[-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "B", 
           RowBox[{"B", "'"}]},
          {"b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.528813045275134*^9, 3.5288283905895863`*^9, 
  3.528893509305085*^9, 3.543573717067336*^9, 3.598184818671471*^9, 
  3.598184877539495*^9, 3.611405955176854*^9, 3.611406047226873*^9, 
  3.6114065458342943`*^9, 3.6114067206245213`*^9}]
}, Open  ]],

Cell["Manipulation of products of soldering forms", "Text",
 CellChangeTimes->{{3.52482816757089*^9, 3.5248281801100473`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Sigma]", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
   RowBox[{"\[Sigma]", "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "B"}], ",", "A\[Dagger]"}], "]"}]}], "//", 
  "ContractSolderingForm"}]], "Input",
 CellChangeTimes->{{3.524828216915216*^9, 3.5248282630788527`*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[CapitalSigma]\[Sigma]", 
      StyleBox[GridBox[{
         {"a", "b", " ", " "},
         {" ", " ", "A", "B"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Sigma\[Sigma][$CellContext`a, $CellContext`b, -$CellContext`A, \
-$CellContext`B],
  Editable->False]], "Output",
 CellChangeTimes->{3.528813045285409*^9, 3.528828390600072*^9, 
  3.528893509319599*^9, 3.543573717092754*^9, 3.5981848187540092`*^9, 
  3.5981848776625957`*^9, 3.611405955252288*^9, 3.611406047320603*^9, 
  3.6114065458737707`*^9, 3.611406720662284*^9}]
}, Open  ]],

Cell["The tetra-metric and its explicit expansion", "Text",
 CellChangeTimes->{{3.5248283031192303`*^9, 3.524828307871607*^9}, {
  3.5248283417247763`*^9, 3.5248283431885233`*^9}, {3.5248283895868607`*^9, 
  3.524828402876713*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tetrag", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5248283096193666`*^9, 3.524828324175659*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"Gg", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"a", "b", "c", "d"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Tetrag[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
  Editable->False]], "Output",
 CellChangeTimes->{3.52881304531929*^9, 3.528828390611003*^9, 
  3.528893509332089*^9, 3.543573717122768*^9, 3.598184818828651*^9, 
  3.5981848777157917`*^9, 3.611405955417622*^9, 3.61140604741227*^9, 
  3.611406545884932*^9, 3.6114067206958323`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"TetraRule", "@", "g"}]}]], "Input",
 CellChangeTimes->{{3.524828329432427*^9, 3.524828334207686*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]g", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`b, -$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`c, -$CellContext`d],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.5288130453456*^9, 3.528828390639782*^9, 
  3.528893509350071*^9, 3.543573717157864*^9, 3.598184818889309*^9, 
  3.598184877760425*^9, 3.61140595552054*^9, 3.611406047494935*^9, 
  3.611406545916473*^9, 3.6114067207250834`*^9}]
}, Open  ]],

Cell[TextData[{
 "The quantity ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[CapitalSigma]\[Sigma]", 
       StyleBox[GridBox[{
          {"a", "b", " ", " "},
          {" ", " ", "A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Sigma\[Sigma][$CellContext`a, $CellContext`b, \
-$CellContext`A, -$CellContext`B],
   Editable->False]], "Output",
  CellChangeTimes->{{3.524828248263636*^9, 3.524828264182849*^9}}],
 " is the \"square root\" of the tetra-metric"
}], "Text",
 CellChangeTimes->{{3.524828629884068*^9, 3.524828654719961*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sigma\[Sigma]", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}], 
  RowBox[{"Sigma\[Sigma]", "[", 
   RowBox[{
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}], ",", "A", ",", "B"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5248286162829113`*^9, 3.524828625416635*^9}, {
  3.5248286938836327`*^9, 3.524828743947422*^9}}],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"Gg", 
      StyleBox[GridBox[{
         {" ", " ", " ", " "},
         {"d", "b", "a", "c"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Tetrag[-$CellContext`d, -$CellContext`b, -$CellContext`a, \
-$CellContext`c],
  Editable->False]], "Output",
 CellChangeTimes->{3.5288130453564177`*^9, 3.528828390649663*^9, 
  3.528893509362475*^9, 3.543573717185417*^9, 3.598184818968708*^9, 
  3.598184877812627*^9, 3.61140595560707*^9, 3.611406047574781*^9, 
  3.611406545936653*^9, 3.611406720746348*^9}]
}, Open  ]],

Cell["\<\
The tetra-metric appears naturally when transforming spinorial expressions \
into tensor ones.  As an example, consider the relation between the Weyl \
spinor and the Weyl tensor, encoded in the rule.\
\>", "Text",
 CellChangeTimes->{{3.524828757997654*^9, 3.524828783072802*^9}, {
  3.5248291408504267`*^9, 3.5248291814963284`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WSToWT", "=", 
  RowBox[{
   RowBox[{"PsiCDe", "[", 
    RowBox[{"A_", ",", "B_", ",", "C_", ",", "D_"}], "]"}], 
   "\[RightTeeArrow]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", "4"}], 
    RowBox[{"WeylCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], 
    RowBox[{"\[Sigma]", "[", 
     RowBox[{"a", ",", "A", ",", "A\[Dagger]"}], "]"}], 
    RowBox[{"\[Sigma]", "[", 
     RowBox[{"b", ",", "B", ",", 
      RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
    RowBox[{"\[Sigma]", "[", 
     RowBox[{"c", ",", "C", ",", "C\[Dagger]"}], "]"}], 
    RowBox[{"\[Sigma]", "[", 
     RowBox[{"d", ",", "D", ",", 
      RowBox[{"-", "C\[Dagger]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5248290029354143`*^9, 3.524829050516162*^9}, {
  3.5248291022934217`*^9, 3.524829127793335*^9}, {3.52490008530569*^9, 
  3.524900107957082*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldPattern", "[", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {
            UnderscriptBox["A", "_"], 
            UnderscriptBox["B", "_"], 
            UnderscriptBox["C", "_"], 
            UnderscriptBox["D", "_"]},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`PsiCDe[
     Pattern[$CellContext`A, 
      Blank[]], 
     Pattern[$CellContext`B, 
      Blank[]], 
     Pattern[C, 
      Blank[]], 
     Pattern[D, 
      Blank[]]],
    Editable->False], "]"}], "\[RuleDelayed]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "a", ",", "A\[Dagger]", ",", "b", ",", "c", ",", "C\[Dagger]", ",", 
      "d"}], "}"}], ",", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "4"]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"a", "b", "c", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", "A", 
              RowBox[{"A", "'"}]},
             {" ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"b", "B", " "},
             {" ", " ", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`b, $CellContext`B, -$CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"c", "C", 
              RowBox[{"C", "'"}]},
             {" ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`c, C, $CellContext`C\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"d", "D", " "},
             {" ", " ", 
              RowBox[{"C", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`d, D, -$CellContext`C\[Dagger]],
      Editable->False]}]}], "]"}]}]], "Output",
 CellChangeTimes->{3.5288130453701973`*^9, 3.528828390665998*^9, 
  3.5288935093920593`*^9, 3.5435737172201023`*^9, 3.598184819047858*^9, 
  3.598184877875339*^9, 3.611405955695723*^9, 3.611406047657789*^9, 
  3.6114065459575663`*^9, 3.61140672078572*^9}]
}, Open  ]],

Cell["\<\
We compute next the tensor form of the following spinor expression\
\>", "Text",
 CellChangeTimes->{{3.524899948771434*^9, 3.52489995621271*^9}, {
  3.524899997833345*^9, 3.524900026300407*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PsiCDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}], ",", 
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}]}], "]"}], 
  RowBox[{"PsiCDe", "[", 
   RowBox[{"A", ",", "B", ",", "C", ",", "D"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.524900032344784*^9, 3.524900047598403*^9}}],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`PsiCDe[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"\[CapitalPsi]", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {"A", "B", "C", "D"},
          {" ", " ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`PsiCDe[$CellContext`A, $CellContext`B, C, D],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.528813045379887*^9, 3.528828390675414*^9, 
  3.528893509408682*^9, 3.543573717248006*^9, 3.5981848192443047`*^9, 
  3.598184877919065*^9, 3.611405955773685*^9, 3.6114060477450933`*^9, 
  3.611406545978701*^9, 3.611406720822112*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", "WSToWT"}]], "Input",
 CellChangeTimes->{{3.524900054130825*^9, 3.524900060015544*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "c", "f", "p"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`c, -$CellContext`f, \
-$CellContext`p],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"b", "d", "h", "p1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`b, -$CellContext`d, -$CellContext`h, \
-$CellContext`p1],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", 
           RowBox[{"A", "'"}]},
          {" ", "A", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", "A", 
           RowBox[{"B", "'"}]},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, $CellContext`A, $CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "B", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -$CellContext`B, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"d", "B", " "},
          {" ", " ", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`d, $CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"f", " ", 
           RowBox[{"C", "'"}]},
          {" ", "C", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`f, -C, $CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"h", "C", 
           RowBox[{"D", "'"}]},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`h, C, $CellContext`D\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"p", " ", " "},
          {" ", "D", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`p, -D, -$CellContext`C\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"p1", "D", " "},
          {" ", " ", 
           RowBox[{"D", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`p1, D, -$CellContext`D\[Dagger]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.528813045428721*^9, 3.528828390695572*^9, 
  3.5288935094219*^9, 3.5435737173055067`*^9, 3.598184819342311*^9, 
  3.598184877987225*^9, 3.611405955868949*^9, 3.611406047848525*^9, 
  3.611406546018283*^9, 3.611406720872816*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractSolderingForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"IndicesOf", "@", "Spin"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.524900149452963*^9, 3.524900161977923*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"p2", "c"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`p2, $CellContext`c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"p3", "p"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`p3, $CellContext`p],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"Gg", 
       StyleBox[GridBox[{
          {"b", "a", " ", "d"},
          {" ", " ", "p2", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Tetrag[$CellContext`b, $CellContext`a, -$CellContext`p2, \
$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"Gg", 
       StyleBox[GridBox[{
          {"h", "f", " ", "p1"},
          {" ", " ", "p3", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Tetrag[$CellContext`h, $CellContext`f, -$CellContext`p3, \
$CellContext`p1],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "c", "f", "p"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`c, -$CellContext`f, \
-$CellContext`p],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"b", "d", "h", "p1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`b, -$CellContext`d, -$CellContext`h, \
-$CellContext`p1],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.528813045486309*^9, 3.5288283907186317`*^9, 
  3.528893509447628*^9, 3.543573717336308*^9, 3.598184819429922*^9, 
  3.598184878065386*^9, 3.611405955977028*^9, 3.611406047954707*^9, 
  3.611406546057027*^9, 3.611406720924849*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"TetraRule", "@", "g"}]}]], "Input",
 CellChangeTimes->{{3.524900172718226*^9, 3.5249001770285997`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]g", 
          StyleBox[GridBox[{
             {"b", "a", " ", "d"},
             {" ", " ", "p2", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`epsilong[$CellContext`b, $CellContext`a, -$CellContext`p2, \
$CellContext`d],
      Editable->False]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "b"},
             {"p2", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`p2, $CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "d"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`a, $CellContext`d],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "d"},
             {"p2", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`p2, $CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "a"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`a],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "a"},
             {"p2", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`p2, $CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "d"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`d],
      Editable->False]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]g", 
          StyleBox[GridBox[{
             {"h", "f", " ", "p1"},
             {" ", " ", "p3", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`epsilong[$CellContext`h, $CellContext`f, -$CellContext`p3, \
$CellContext`p1],
      Editable->False]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "h"},
             {"p3", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`p3, $CellContext`h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"f", "p1"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`f, $CellContext`p1],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "p1"},
             {"p3", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`p3, $CellContext`p1],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"h", "f"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`h, $CellContext`f],
      Editable->False]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"p3", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`p3, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"h", "p1"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`h, $CellContext`p1],
      Editable->False]}]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"p2", "c"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`p2, $CellContext`c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"p3", "p"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`p3, $CellContext`p],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "c", "f", "p"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`c, -$CellContext`f, \
-$CellContext`p],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"b", "d", "h", "p1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`WeylCD[-$CellContext`b, -$CellContext`d, -$CellContext`h, \
-$CellContext`p1],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.528813045572867*^9, 3.528828390752925*^9, 
  3.528893509483265*^9, 3.543573717391683*^9, 3.598184819532853*^9, 
  3.598184878157599*^9, 3.6114059560948277`*^9, 3.611406048066514*^9, 
  3.611406546117585*^9, 3.611406720987665*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.5249001804405813`*^9, 3.524900187459448*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "8"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", "b", "c", "d"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "16"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]g", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "d", "f", "h"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilong[-$CellContext`c, -$CellContext`d, -$CellContext`f, \
-$CellContext`h],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "f", "h"},
           {"a", "b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, $CellContext`f, \
$CellContext`h],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", "b", "c", "d"},
           {" ", " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`WeylCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.528813045891159*^9, 3.528828390966956*^9, 
  3.5288935097109613`*^9, 3.543573717697764*^9, 3.5981848199450502`*^9, 
  3.598184878603188*^9, 3.611405956516797*^9, 3.611406048568963*^9, 
  3.611406546481683*^9, 3.6114067213019857`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example: the Sparling equation", "Subsection",
 CellChangeTimes->{{3.524901779431532*^9, 3.524901787062768*^9}}],

Cell[CellGroupData[{

Cell["Preliminary definitions", "Subsubsection",
 CellChangeTimes->{{3.5249183114841137`*^9, 3.5249183189804583`*^9}}],

Cell["We start by defining the spinors intervening in our problem.", "Text",
 CellChangeTimes->{{3.5249031285766153`*^9, 3.524903143731134*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[Lambda]", "[", 
    RowBox[{"-", "A"}], "]"}], ",", "M4", ",", 
   RowBox[{
   "PrintDaggerAs", "\[Rule]", 
    "\"\<\!\(\*OverscriptBox[\(\[Lambda]\), \(_\)]\)\>\""}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.52216931700023*^9, 3.522169328970186*^9}, {
  3.522208306397493*^9, 3.522208307286214*^9}, {3.611405927080611*^9, 
  3.6114059409066257`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Lambda]", "[", 
    RowBox[{"-", "A"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Lambda][-$CellContext`A], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288283910052023`*^9, 3.528893953508746*^9, 
  3.543573765962014*^9, 3.598184829338049*^9, 3.598184878660541*^9, 
  3.611405956646727*^9, 3.611406048634604*^9, 3.6114065465048437`*^9, 
  3.611406721356914*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Lambda]\[Dagger]", "[", 
    RowBox[{"-", "A\[Dagger]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[Lambda]\[Dagger][-$CellContext`A\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288283910052023`*^9, 3.528893953508746*^9, 
  3.543573765962014*^9, 3.598184829338049*^9, 3.598184878660541*^9, 
  3.611405956646727*^9, 3.611406048634604*^9, 3.6114065465048437`*^9, 
  3.611406721357841*^9}]
}, Open  ]],

Cell["Nester-Witten spinor and its tensor counterpart:", "Text",
 CellChangeTimes->{{3.522395788603877*^9, 3.522395799308689*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"\[CapitalXi]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"-", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "A"}], ",", 
         RowBox[{"-", "B"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "A\[Dagger]"}], ",", 
         RowBox[{"-", "B\[Dagger]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
   RowBox[{
   "PrintDaggerAs", "\[Rule]", 
    "\"\<\!\(\*OverscriptBox[\(\[CapitalXi]\), \(_\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5221693853734903`*^9, 3.522169400914282*^9}, {
  3.5222165637771807`*^9, 3.5222166057589493`*^9}, {3.611406009239073*^9, 
  3.611406020039212*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[CapitalXi]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[CapitalXi][-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.52882839102958*^9, 3.5288939537518263`*^9, 
  3.543573766054063*^9, 3.5981848295834923`*^9, 3.5981848787471724`*^9, 
  3.6114059567991943`*^9, 3.61140604870856*^9, 3.611406546532618*^9, 
  3.611406721384265*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"spinor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[CapitalXi]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B\[Dagger]"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "spinor ", 
   $CellContext`\[CapitalXi]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`A, -$CellContext`B\[Dagger], -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.52882839102958*^9, 3.5288939537518263`*^9, 
  3.543573766054063*^9, 3.5981848295834923`*^9, 3.5981848787471724`*^9, 
  3.6114059567991943`*^9, 3.61140604870856*^9, 3.611406546532618*^9, 
  3.6114067214031353`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensorOfSpinor", "[", 
  RowBox[{
   RowBox[{"\[ScriptCapitalF]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", 
   RowBox[{"\[CapitalXi]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", "\[Sigma]"}], "]"}]], "Input",\

 CellChangeTimes->{{3.522170966690267*^9, 3.522171018815071*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[ScriptCapitalF]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of spinor \[CapitalXi]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[ScriptCapitalF][-$CellContext`a, -$CellContext`b], ". ", 
   "Equivalent of spinor \[CapitalXi]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288283910441427`*^9, 3.5288939538089857`*^9, 
  3.543573766129546*^9, 3.598184829649774*^9, 3.598184878847967*^9, 
  3.611405956904101*^9, 3.6114060487920227`*^9, 3.611406546556511*^9, 
  3.611406721434532*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[ScriptCapitalF]\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Equivalent of spinor \[CapitalXi]\[Dagger]\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[ScriptCapitalF]\[Dagger][-$CellContext`a, -$CellContext`b], 
   ". ", "Equivalent of spinor \[CapitalXi]\[Dagger]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5288283910441427`*^9, 3.5288939538089857`*^9, 
  3.543573766129546*^9, 3.598184829649774*^9, 3.598184878847967*^9, 
  3.611405956904101*^9, 3.6114060487920227`*^9, 3.611406546556511*^9, 
  3.6114067214360743`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "@", "\[ScriptCapitalF]\[Dagger]"}], "^=", 
   "\"\<\!\(\*OverscriptBox[\(\[ScriptCapitalF]\), \(_\)]\)\>\""}], ";", 
  RowBox[{
   RowBox[{"PrintAs", "@", "\[ScriptCapitalF]"}], "^=", 
   "\"\<\[ScriptCapitalF]\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.522171025505756*^9, 3.522171056060298*^9}, 
   3.5226425805385923`*^9}],

Cell["Null vector counterpart of \[Lambda]\[Lambda]\[Dagger]", "Text",
 CellChangeTimes->{{3.522395809883316*^9, 3.522395814812499*^9}, {
  3.5224912951213017`*^9, 3.522491296424879*^9}, {3.5261909742396517`*^9, 
  3.526190977356238*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"\[Xi]", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.5221696347666473`*^9, 3.522169644971414*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Xi]", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Xi][-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.528828391062574*^9, 3.528893953853554*^9, 
  3.543573766179715*^9, 3.59818482973146*^9, 3.598184878980461*^9, 
  3.611405957080536*^9, 3.611406048967894*^9, 3.61140654658322*^9, 
  3.611406721472292*^9}]
}, Open  ]],

Cell["We change the default formatting of the volume form", "Text",
 CellChangeTimes->{{3.52490182921181*^9, 3.524901840172515*^9}, 
   3.5249018843069*^9, {3.526181786833954*^9, 3.526181793753952*^9}, 
   3.5261909933233852`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "@", "epsilong"}], "^=", "\"\<\[Eta]\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5249018860795517`*^9, 3.5249019006983*^9}, {
  3.526273703079646*^9, 3.526273704270891*^9}}],

Cell["The Nester-Witten spinor is given by", "Text",
 CellChangeTimes->{{3.522988997095113*^9, 3.522989005133644*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NesterWittenSpinor", "=", 
  RowBox[{
   RowBox[{"\[CapitalXi]", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], "\[Equal]", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "I"}], " ", 
       RowBox[{"\[Lambda]\[Dagger]", "[", 
        RowBox[{"-", "B\[Dagger]"}], "]"}], 
       RowBox[{
        RowBox[{"CDe", "[", 
         RowBox[{
          RowBox[{"-", "A"}], ",", 
          RowBox[{"-", "A\[Dagger]"}]}], "]"}], "@", 
        RowBox[{"\[Lambda]", "[", 
         RowBox[{"-", "B"}], "]"}]}]}], "+", 
      RowBox[{"I", " ", 
       RowBox[{"\[Lambda]\[Dagger]", "[", 
        RowBox[{"-", "A\[Dagger]"}], "]"}], 
       RowBox[{
        RowBox[{"CDe", "[", 
         RowBox[{
          RowBox[{"-", "B"}], ",", 
          RowBox[{"-", "B\[Dagger]"}]}], "]"}], "@", 
        RowBox[{"\[Lambda]", "[", 
         RowBox[{"-", "A"}], "]"}]}]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.522169501536046*^9, 3.5221695406415052`*^9}, {
  3.522169573629945*^9, 3.522169614027493*^9}, {3.522169664919302*^9, 
  3.5221696773628407`*^9}, {3.522381374112897*^9, 3.522381375408045*^9}}],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[CapitalXi]", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", 
           RowBox[{"A", "'"}], "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[CapitalXi][-$CellContext`A, -$CellContext`A\[Dagger], \
-$CellContext`B, -$CellContext`B\[Dagger]],
   Editable->False], "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Lambda]", "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Lambda]\[Dagger][-$CellContext`B\[Dagger]],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubsuperscriptBox["\[EmptyDownTriangle]", 
           RowBox[{"AA", "'"}], "  "], GridBox[{
            {"\[Lambda]", 
             StyleBox[GridBox[{
                {" "},
                {"B"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
         $CellContext`\[Lambda][-$CellContext`B]],
        Editable->False], ")"}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox["\[Lambda]", "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               RowBox[{"A", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Lambda]\[Dagger][-$CellContext`A\[Dagger]],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubsuperscriptBox["\[EmptyDownTriangle]", 
           RowBox[{"BB", "'"}], "  "], GridBox[{
            {"\[Lambda]", 
             StyleBox[GridBox[{
                {" "},
                {"A"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->Rational[39, 4]]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
         $CellContext`\[Lambda][-$CellContext`A]],
        Editable->False], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.528828391078104*^9, 3.528893953876225*^9, 
  3.543573766201689*^9, 3.598184829803917*^9, 3.5981848790521517`*^9, 
  3.611405957194498*^9, 3.611406049079307*^9, 3.6114065466088133`*^9, 
  3.611406721510662*^9}]
}, Open  ]],

Cell["Short form for \"IndexSolve\".", "Text",
 CellChangeTimes->{{3.52428985066192*^9, 3.524289864349998*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"IndSV", "[", "expr_Equal", "]"}], ":=", 
   RowBox[{"IndexSolve", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"First", "@", "expr"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.524289710630131*^9, 3.524289741835837*^9}}],

Cell["We also define the shortcut canonicalization function:", "Text",
 CellChangeTimes->{{3.526182144833724*^9, 3.526182164373622*^9}, 
   3.526183587546051*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TC", "[", "expr_", "]"}], ":=", 
  RowBox[{"ToCanonical", "[", 
   RowBox[{"ContractMetric", "[", "expr", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.526182166635311*^9, 3.5261821774964333`*^9}}],

Cell["\<\
and this function to multiply and canonicalize both sides of an equation:\
\>", "Text",
 CellChangeTimes->{{3.526183590051565*^9, 3.526183622072204*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EqualTimes", "[", 
   RowBox[{
    RowBox[{"Equal", "[", 
     RowBox[{"lhs_", ",", "rhs_"}], "]"}], ",", "x_"}], "]"}], ":=", 
  RowBox[{"Equal", "[", 
   RowBox[{
    RowBox[{"TC", "[", 
     RowBox[{"x", " ", "lhs"}], "]"}], ",", 
    RowBox[{"TC", "[", 
     RowBox[{"x", " ", "rhs"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.526183061693502*^9, 3.5261830984901037`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Exterior derivative of ",
 Cell[BoxData[GridBox[{
    {"\[ScriptCapitalF]", 
     StyleBox[GridBox[{
        {" ", " "},
        {"a", "b"}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.], {
            Offset[0.034999999999999996`]}, 
           Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
            Offset[0.]}}, "RowsIndexed" -> {}}],
      FontSize->9]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.034999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]], "Output",
  CellChangeTimes->{
   3.52249141572094*^9, 3.522491484103429*^9, {3.52249152501236*^9, 
    3.522491530999959*^9}, 3.522491585113401*^9, {3.522491661871956*^9, 
    3.522491696156252*^9}, 3.522491917217514*^9, 3.52249215703907*^9, 
    3.522498895207375*^9, 3.5226498617385902`*^9, {3.522667187986766*^9, 
    3.522667213921104*^9}, 3.522667701008369*^9, 3.52266821259883*^9, 
    3.522668776756922*^9, 3.522727427533168*^9, 3.522733910499803*^9, 
    3.522758691349321*^9, 3.522840528277446*^9}]
}], "Subsubsection",
 CellChangeTimes->{{3.522304623613985*^9, 3.522304626015915*^9}, {
  3.522384155679349*^9, 3.522384157797261*^9}, {3.5229891059351797`*^9, 
  3.5229891195147667`*^9}}],

Cell[TextData[{
 "We wish to compute the exterior derivative of ",
 Cell[BoxData[GridBox[{
    {"\[ScriptCapitalF]", 
     StyleBox[GridBox[{
        {" ", " "},
        {"a", "b"}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.], {
            Offset[0.034999999999999996`]}, 
           Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
            Offset[0.]}}, "RowsIndexed" -> {}}],
      FontSize->9]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.034999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]], "Output",
  CellChangeTimes->{3.52249141572094*^9}],
 " (Sparling equation) "
}], "Text",
 CellChangeTimes->{{3.522491455224489*^9, 3.522491482886448*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d\[ScriptCapitalF]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CDe", "[", 
      RowBox[{"-", "c"}], "]"}], "@", 
     RowBox[{"\[ScriptCapitalF]", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "//", "Antisymmetrize"}], "//", 
   "TC"}]}]], "Input",
 CellChangeTimes->{{3.522491402126341*^9, 3.522491414976577*^9}, {
   3.5224915204276323`*^9, 3.5224915303826027`*^9}, {3.522491911384412*^9, 
   3.52249191438186*^9}, 3.522667213216744*^9, {3.526181877544325*^9, 
   3.526181888575589*^9}, {3.526183114779718*^9, 3.526183115040506*^9}, {
   3.526192366800075*^9, 3.526192372239381*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"\[ScriptCapitalF]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"b", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`a][
      $CellContext`\[ScriptCapitalF][-$CellContext`b, -$CellContext`c]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"\[ScriptCapitalF]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`b][
      $CellContext`\[ScriptCapitalF][-$CellContext`a, -$CellContext`c]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"\[ScriptCapitalF]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`c][
      $CellContext`\[ScriptCapitalF][-$CellContext`a, -$CellContext`b]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.5288283914661922`*^9, 3.528893954481106*^9, 3.5435737686217527`*^9, {
   3.598184829885702*^9, 3.598184843406505*^9}, 3.5981848791517487`*^9, 
   3.611405957365706*^9, 3.6114060493306026`*^9, 3.6114065466691313`*^9, 
   3.611406721596697*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"d\[ScriptCapitalF]", "//", 
    RowBox[{"SeparateSolderingForm", "[", "\[Sigma]", "]"}]}], ")"}], "/.", 
  RowBox[{"IndSV", "[", "NesterWittenSpinor", "]"}]}]], "Input",
 CellChangeTimes->{{3.524210920689684*^9, 3.52421093775356*^9}, {
  3.524211837718539*^9, 3.524211841382308*^9}, {3.5261818976786833`*^9, 
  3.526181901221545*^9}, {3.526191783288724*^9, 3.5261917839036703`*^9}, {
  3.5261923737903843`*^9, 3.526192374277845*^9}, {3.526192766935787*^9, 
  3.526192767527226*^9}, {3.526192886816689*^9, 3.5261928874962053`*^9}, {
  3.526276963813346*^9, 3.5262769715137053`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "A", 
            RowBox[{"A", "'"}]},
           {"a", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "B", 
            RowBox[{"B", "'"}]},
           {"b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "C", 
            RowBox[{"C", "'"}]},
           {"c", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"AA", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"C"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
            $CellContext`\[Lambda][-C]],
           Editable->False], ")"}], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"BB", "'"}], "  "], GridBox[{
               {
                OverscriptBox["\[Lambda]", "_"], 
                StyleBox[GridBox[{
                   {" "},
                   {
                    RowBox[{"C", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
            $CellContext`\[Lambda]\[Dagger][-$CellContext`C\[Dagger]]],
           Editable->False], ")"}]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {
              OverscriptBox["\[Lambda]", "_"], 
              StyleBox[GridBox[{
                 {" "},
                 {
                  RowBox[{"C", "'"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Lambda]\[Dagger][-$CellContext`C\[Dagger]],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"BB", "'"}], "  "], 
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"AA", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"C"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
            $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
             $CellContext`\[Lambda][-C]]],
           Editable->False], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {
              OverscriptBox["\[Lambda]", "_"], 
              StyleBox[GridBox[{
                 {" "},
                 {
                  RowBox[{"A", "'"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Lambda]\[Dagger][-$CellContext`A\[Dagger]],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"BB", "'"}], "  "], 
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"CC", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"A"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
            $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
             $CellContext`\[Lambda][-$CellContext`A]]],
           Editable->False], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"BB", "'"}], "  "], GridBox[{
               {
                OverscriptBox["\[Lambda]", "_"], 
                StyleBox[GridBox[{
                   {" "},
                   {
                    RowBox[{"A", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
            $CellContext`\[Lambda]\[Dagger][-$CellContext`A\[Dagger]]],
           Editable->False], ")"}], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"CC", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"A"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
            $CellContext`\[Lambda][-$CellContext`A]],
           Editable->False], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "A", 
            RowBox[{"A", "'"}]},
           {"a", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "B", 
            RowBox[{"B", "'"}]},
           {"b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "C", 
            RowBox[{"C", "'"}]},
           {"c", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {
              OverscriptBox["\[Lambda]", "_"], 
              StyleBox[GridBox[{
                 {" "},
                 {
                  RowBox[{"C", "'"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Lambda]\[Dagger][-$CellContext`C\[Dagger]],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"AA", "'"}], "  "], 
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"BB", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"C"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
            $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
             $CellContext`\[Lambda][-C]]],
           Editable->False], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"AA", "'"}], "  "], GridBox[{
               {
                OverscriptBox["\[Lambda]", "_"], 
                StyleBox[GridBox[{
                   {" "},
                   {
                    RowBox[{"C", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
            $CellContext`\[Lambda]\[Dagger][-$CellContext`C\[Dagger]]],
           Editable->False], ")"}], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"BB", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"C"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
            $CellContext`\[Lambda][-C]],
           Editable->False], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {
              OverscriptBox["\[Lambda]", "_"], 
              StyleBox[GridBox[{
                 {" "},
                 {
                  RowBox[{"B", "'"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Lambda]\[Dagger][-$CellContext`B\[Dagger]],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"AA", "'"}], "  "], 
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"CC", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"B"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
            $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
             $CellContext`\[Lambda][-$CellContext`B]]],
           Editable->False], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"AA", "'"}], "  "], GridBox[{
               {
                OverscriptBox["\[Lambda]", "_"], 
                StyleBox[GridBox[{
                   {" "},
                   {
                    RowBox[{"B", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
            $CellContext`\[Lambda]\[Dagger][-$CellContext`B\[Dagger]]],
           Editable->False], ")"}], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"CC", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"B"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
            $CellContext`\[Lambda][-$CellContext`B]],
           Editable->False], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "A", 
            RowBox[{"A", "'"}]},
           {"a", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "B", 
            RowBox[{"B", "'"}]},
           {"b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`b, $CellContext`B, $CellContext`B\
\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "C", 
            RowBox[{"C", "'"}]},
           {"c", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`c, C, $CellContext`C\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"AA", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"B"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
            $CellContext`\[Lambda][-$CellContext`B]],
           Editable->False], ")"}], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"CC", "'"}], "  "], GridBox[{
               {
                OverscriptBox["\[Lambda]", "_"], 
                StyleBox[GridBox[{
                   {" "},
                   {
                    RowBox[{"B", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
            $CellContext`\[Lambda]\[Dagger][-$CellContext`B\[Dagger]]],
           Editable->False], ")"}]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {
              OverscriptBox["\[Lambda]", "_"], 
              StyleBox[GridBox[{
                 {" "},
                 {
                  RowBox[{"B", "'"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Lambda]\[Dagger][-$CellContext`B\[Dagger]],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"CC", "'"}], "  "], 
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"AA", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"B"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
            $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
             $CellContext`\[Lambda][-$CellContext`B]]],
           Editable->False], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"BB", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"A"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
            $CellContext`\[Lambda][-$CellContext`A]],
           Editable->False], ")"}], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"CC", "'"}], "  "], GridBox[{
               {
                OverscriptBox["\[Lambda]", "_"], 
                StyleBox[GridBox[{
                   {" "},
                   {
                    RowBox[{"A", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
            $CellContext`\[Lambda]\[Dagger][-$CellContext`A\[Dagger]]],
           Editable->False], ")"}]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {
              OverscriptBox["\[Lambda]", "_"], 
              StyleBox[GridBox[{
                 {" "},
                 {
                  RowBox[{"A", "'"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Lambda]\[Dagger][-$CellContext`A\[Dagger]],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"CC", "'"}], "  "], 
             SubsuperscriptBox["\[EmptyDownTriangle]", 
              RowBox[{"BB", "'"}], "  "], GridBox[{
               {"\[Lambda]", 
                StyleBox[GridBox[{
                   {" "},
                   {"A"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CDe[-C, -$CellContext`C\[Dagger]][
            $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
             $CellContext`\[Lambda][-$CellContext`A]]],
           Editable->False], ")"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.528828391556898*^9, 3.5288939546624517`*^9, 3.543573768793174*^9, {
   3.598184829992647*^9, 3.598184843634726*^9}, 3.598184879296239*^9, 
   3.6114059575420713`*^9, 3.611406049498493*^9, 3.611406546761026*^9, 
   3.6114067216967793`*^9}]
}, Open  ]],

Cell["\<\
Some terms can be written in terms of the curvature spinors if we just use \
the Ricci identity.\
\>", "Text",
 CellChangeTimes->{{3.522384320806727*^9, 3.522384344899105*^9}, {
  3.522727429752225*^9, 3.522727430441495*^9}, {3.5249033315449343`*^9, 
  3.524903334216773*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SortSpinCovDs", "[", 
   RowBox[{"%", ",", "CDe"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.522216935779999*^9, 3.5222169577293873`*^9}, 
   3.522384349075157*^9, {3.52249174175834*^9, 3.522491746686242*^9}, {
   3.52611827544911*^9, 3.526118280624604*^9}, 3.526191726227601*^9, {
   3.526191790465809*^9, 3.5261917909834843`*^9}, {3.526191966637828*^9, 
   3.526191967773362*^9}, {3.526192212729615*^9, 3.526192213495469*^9}, {
   3.526192307554289*^9, 3.526192308193675*^9}, {3.526192356289304*^9, 
   3.5261923574788103`*^9}, {3.526192389484971*^9, 3.526192412819333*^9}, 
   3.5261925361667957`*^9, {3.526192923566469*^9, 3.5261929533962812`*^9}, {
   3.526193380316698*^9, 3.526193381771859*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BoxToCurvature", "[", 
   RowBox[{"%", ",", "BoxCDe"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.522217071201263*^9, 3.522217082570466*^9}, 
   3.522384364534957*^9, {3.5224917650165443`*^9, 3.522491768866252*^9}, {
   3.526118282432755*^9, 3.526118285658687*^9}, 3.52619173073137*^9, 
   3.526191969933565*^9, {3.526192220087575*^9, 3.526192221263068*^9}, {
   3.5261923056446943`*^9, 3.526192306289583*^9}, {3.5261923593351*^9, 
   3.526192360782652*^9}, {3.5261924299226303`*^9, 3.526192436620483*^9}, {
   3.5261925391242037`*^9, 3.5261925418306093`*^9}, {3.52619277319123*^9, 
   3.526192773758831*^9}, 3.526192941637329*^9}],

Cell["We decompose the curvature spinors into irreducible parts.", "Text",
 CellChangeTimes->{{3.522384370990176*^9, 3.522384382559355*^9}, {
  3.5261839867500067`*^9, 3.526184008346015*^9}, {3.5261842717979393`*^9, 
  3.526184272290633*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d\[CapitalXi]", "=", 
   RowBox[{
    RowBox[{"Decomposition", "[", 
     RowBox[{"%", ",", "Chi", ",", "CDe"}], "]"}], "//", "TC"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.522217130796956*^9, 3.5222171343762207`*^9}, {
   3.52221720045226*^9, 3.522217217508401*^9}, 3.522384366947859*^9, {
   3.5224917779871893`*^9, 3.522491782319215*^9}, {3.5261822053840933`*^9, 
   3.526182224932516*^9}, 3.526191734989079*^9, 3.526191977118759*^9, {
   3.526192230631057*^9, 3.526192231198196*^9}, {3.5261923160737877`*^9, 
   3.526192321497754*^9}, {3.526192441874959*^9, 3.52619244237822*^9}, {
   3.526192544444723*^9, 3.5261925484172707`*^9}, {3.52619277619139*^9, 
   3.526192776790997*^9}, 3.5261929343981733`*^9, 3.5261930072181253`*^9}],

Cell["\<\
We split this equation into two parts: terms containing derivatives of \
\[Lambda] and terms not containing derivatives of \[Lambda]\
\>", "Text",
 CellChangeTimes->{{3.522395934113016*^9, 3.522395975469656*^9}, 
   3.522491832887957*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d\[CapitalXi]1", "=", 
   RowBox[{"d\[CapitalXi]", "/.", 
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", "__", "]"}], "@", 
      RowBox[{"\[Lambda]", "[", "_", "]"}]}], "\[RuleDelayed]", "0"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[CapitalXi]2", "=", 
   RowBox[{"d\[CapitalXi]", "-", "d\[CapitalXi]1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5223959682314167`*^9, 3.52239606804671*^9}, {
  3.52249184159973*^9, 3.522491850703673*^9}, {3.526183131279697*^9, 
  3.526183139236517*^9}, {3.526191738139489*^9, 3.526191738874742*^9}, {
  3.526191983213194*^9, 3.5261919843327513`*^9}, {3.526192779567252*^9, 
  3.5261927891099997`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Tensor part of the sparling equation (Einstein form)", "Subsubsection",
 CellChangeTimes->{{3.522396078440559*^9, 3.5223960838418922`*^9}, {
  3.522491874738687*^9, 3.522491879183988*^9}}],

Cell["We compute next the tensor form of this expression. ", "Text",
 CellChangeTimes->{{3.522296801659564*^9, 3.522296813453603*^9}, {
   3.52249195395264*^9, 3.5224919752321587`*^9}, 3.524211760695736*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d\[CapitalXi]1", "/.", "WSToWT"}], "/.", 
   RowBox[{"IndexRule", "[", 
    RowBox[{
     RowBox[{"PhiCDe", "[", 
      RowBox[{
       RowBox[{"-", "A_"}], ",", 
       RowBox[{"-", "B_"}], ",", 
       RowBox[{"-", "A\[Dagger]_"}], ",", 
       RowBox[{"-", "B\[Dagger]_"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], 
      RowBox[{"TFRicciCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], 
      RowBox[{"\[Sigma]", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
      RowBox[{"\[Sigma]", "[", 
       RowBox[{"b", ",", 
        RowBox[{"-", "B"}], ",", 
        RowBox[{"-", "B\[Dagger]"}]}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.522221814036686*^9, 3.5222218206394444`*^9}, 
   3.5222288117697163`*^9, {3.52273503782336*^9, 3.522735044619828*^9}, {
   3.524221970148466*^9, 3.52422197057031*^9}, {3.524222028148748*^9, 
   3.524222082850637*^9}, 3.524222137548401*^9, {3.524903393754004*^9, 
   3.524903463226757*^9}, 3.524903581701045*^9, 3.5249041277533197`*^9, {
   3.526192677974502*^9, 3.526192678637578*^9}, {3.526193023369543*^9, 
   3.52619303109233*^9}, {3.526277403449588*^9, 3.526277408776052*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"IndexRule", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Lambda]", "[", "B_", "]"}], 
       RowBox[{"\[Lambda]\[Dagger]", "[", "B\[Dagger]_", "]"}]}], ",", 
      RowBox[{
       RowBox[{"\[Xi]", "[", 
        RowBox[{"-", "a"}], "]"}], 
       RowBox[{"\[Sigma]", "[", 
        RowBox[{"a", ",", "B", ",", "B\[Dagger]"}], "]"}]}]}], "]"}]}], "//", 
   "TC"}], ";"}]], "Input",
 CellChangeTimes->{{3.524903474841847*^9, 3.5249035151538067`*^9}, {
  3.524903557247532*^9, 3.5249035624327908`*^9}, {3.526192598995998*^9, 
  3.526192600457437*^9}, {3.5261930742706738`*^9, 3.526193128386882*^9}, {
  3.543573784142152*^9, 3.543573855781784*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d\[CapitalXi]1", "=", 
   RowBox[{
    RowBox[{"ContractSolderingForm", "[", 
     RowBox[{"%", ",", 
      RowBox[{"IndicesOf", "@", "Spin"}]}], "]"}], "//", "TC"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.52222182543224*^9, 3.5222218324174337`*^9}, {
   3.522221871700859*^9, 3.522221879320759*^9}, 3.524905085625863*^9, {
   3.5261847656009912`*^9, 3.52618477699179*^9}, {3.5261858492670813`*^9, 
   3.5261858508262253`*^9}, 3.526192007454782*^9, {3.5261922421441298`*^9, 
   3.526192246416264*^9}, {3.526192451786071*^9, 3.526192455443912*^9}, {
   3.526192558339957*^9, 3.5261925667151613`*^9}, {3.526193159057313*^9, 
   3.5261931649448023`*^9}, {3.526194546137203*^9, 3.5261945515870857`*^9}, 
   3.526194643524667*^9, 3.5262775622779093`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[" Sparling  3 form", "Subsubsection",
 CellChangeTimes->{{3.522297173153623*^9, 3.52229718662358*^9}, {
  3.522304641830299*^9, 3.5223046457303543`*^9}, {3.522396338203583*^9, 
  3.522396353148341*^9}}],

Cell["\<\
The products of derivatives of \[Lambda] have a tensor counterpart wich we \
define next\
\>", "Text",
 CellChangeTimes->{{3.5222974744309893`*^9, 3.522297524531888*^9}, {
  3.52619420257454*^9, 3.526194206146174*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"\[ScriptCapitalZ]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.522297526626635*^9, 3.522297573078917*^9}, {
  3.5222976735284233`*^9, 3.522297675145775*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[ScriptCapitalZ]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[ScriptCapitalZ][-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.598184880128124*^9, 3.6114059583877172`*^9, 
  3.6114060503135777`*^9, 3.611406547556082*^9, 3.611406722419529*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PutSolderingForm", "@", 
  RowBox[{"\[ScriptCapitalZ]", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[ScriptCapitalZ]", 
       StyleBox[GridBox[{
          {" ", " ", " "},
          {"a", "b", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[ScriptCapitalZ][-$CellContext`a, -$CellContext`b, \
-$CellContext`c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"b", " ", " "},
          {" ", "B", 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"c", " ", " "},
          {" ", "C", 
           RowBox[{"C", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.528828392180419*^9, 3.528893958358018*^9, 3.543573863658079*^9, {
   3.598184830880362*^9, 3.598184880201071*^9}, 3.611405958463182*^9, 
   3.611406050393156*^9, 3.611406547573986*^9, 3.611406722444838*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalZ]rule", "=", 
  RowBox[{"IndexRule", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{
        RowBox[{"-", "B_"}], ",", 
        RowBox[{"-", "C\[Dagger]_"}]}], "]"}], "@", 
      RowBox[{"\[Lambda]", "[", 
       RowBox[{"-", "A_"}], "]"}]}], 
     RowBox[{
      RowBox[{"CDe", "[", 
       RowBox[{
        RowBox[{"-", "C_"}], ",", 
        RowBox[{"-", "B\[Dagger]_"}]}], "]"}], "@", 
      RowBox[{"\[Lambda]\[Dagger]", "[", 
       RowBox[{"-", "A\[Dagger]_"}], "]"}]}]}], ",", "%"}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.5261938349558983`*^9, 3.526193871144121*^9}, {
   3.526193903238302*^9, 3.526193947343088*^9}, {3.526193987092512*^9, 
   3.5261940563658037`*^9}, {3.526194418147773*^9, 3.526194422297336*^9}, 
   3.5261944573678226`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldPattern", "[", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubsuperscriptBox["\[EmptyDownTriangle]", 
         RowBox[{
          UnderscriptBox["B", "_"], 
          UnderscriptBox[
           RowBox[{"C", "'"}], "_"]}], "  "], GridBox[{
          {"\[Lambda]", 
           StyleBox[GridBox[{
              {" "},
              {
               UnderscriptBox["A", "_"]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[-Pattern[$CellContext`B, 
         Blank[]], -Pattern[$CellContext`C\[Dagger], 
         Blank[]]][
       $CellContext`\[Lambda][-Pattern[$CellContext`A, 
          Blank[]]]],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubsuperscriptBox["\[EmptyDownTriangle]", 
         RowBox[{
          UnderscriptBox["C", "_"], 
          UnderscriptBox[
           RowBox[{"B", "'"}], "_"]}], "  "], GridBox[{
          {
           OverscriptBox["\[Lambda]", "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               UnderscriptBox[
                RowBox[{"A", "'"}], "_"]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[-Pattern[C, 
         Blank[]], -Pattern[$CellContext`B\[Dagger], 
         Blank[]]][
       $CellContext`\[Lambda]\[Dagger][-Pattern[$CellContext`A\[Dagger], 
          Blank[]]]],
      Editable->False], ")"}]}], "]"}], "\[RuleDelayed]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[ScriptCapitalZ]", 
          StyleBox[GridBox[{
             {" ", " ", " "},
             {"a", "b", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[ScriptCapitalZ][-$CellContext`a, -$CellContext`b, \
-$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"a", " ", " "},
             {" ", "A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"b", " ", " "},
             {" ", "B", 
              RowBox[{"B", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`b, -$CellContext`B, -$CellContext`B\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"c", " ", " "},
             {" ", "C", 
              RowBox[{"C", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`c, -C, -$CellContext`C\[Dagger]],
      Editable->False]}]}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.5288283922016582`*^9, 3.528893958383286*^9, 3.543573863712599*^9, {
   3.598184830924073*^9, 3.598184880261365*^9}, 3.611405958552318*^9, 
   3.611406050487298*^9, 3.611406547598855*^9, 3.611406722485777*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d\[CapitalXi]2", "=", 
  RowBox[{
   RowBox[{"ContractSolderingForm", "[", 
    RowBox[{
     RowBox[{"d\[CapitalXi]2", "/.", "\[ScriptCapitalZ]rule"}], ",", 
     RowBox[{"IndicesOf", "@", "Spin"}]}], "]"}], "//", "TC"}]}]], "Input",
 CellChangeTimes->{{3.5222983078655653`*^9, 3.522298321462473*^9}, {
   3.522492812883417*^9, 3.5224928160090857`*^9}, {3.522844335146575*^9, 
   3.522844347057473*^9}, 3.522844396472576*^9, 3.5261820730120564`*^9, {
   3.526182353220196*^9, 3.526182353955594*^9}, {3.526185901753929*^9, 
   3.526185907342841*^9}, 3.526192043740602*^9, {3.526192272516652*^9, 
   3.526192273500551*^9}, 3.526193245270151*^9, 3.5261943052390203`*^9, 
   3.526194487119685*^9, 3.5261945917297573`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"Gg", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "d", "c", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Tetrag[-$CellContext`b, -$CellContext`d, -$CellContext`c, \
-$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalZ]", 
        StyleBox[GridBox[{
           {" ", "d", "f"},
           {"a", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalZ][-$CellContext`a, $CellContext`d, \
$CellContext`f],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"Gg", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "f", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Tetrag[-$CellContext`b, -$CellContext`f, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalZ]", 
        StyleBox[GridBox[{
           {" ", "d", "f"},
           {"a", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalZ][-$CellContext`a, $CellContext`d, \
$CellContext`f],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"Gg", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "d", "c", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Tetrag[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalZ]", 
        StyleBox[GridBox[{
           {" ", "d", "f"},
           {"b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalZ][-$CellContext`b, $CellContext`d, \
$CellContext`f],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"Gg", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "f", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Tetrag[-$CellContext`a, -$CellContext`f, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalZ]", 
        StyleBox[GridBox[{
           {" ", "d", "f"},
           {"b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalZ][-$CellContext`b, $CellContext`d, \
$CellContext`f],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"Gg", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "d", "b", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Tetrag[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalZ]", 
        StyleBox[GridBox[{
           {" ", "d", "f"},
           {"c", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalZ][-$CellContext`c, $CellContext`d, \
$CellContext`f],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"Gg", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "f", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Tetrag[-$CellContext`a, -$CellContext`f, -$CellContext`b, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalZ]", 
        StyleBox[GridBox[{
           {" ", "d", "f"},
           {"c", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalZ][-$CellContext`c, $CellContext`d, \
$CellContext`f],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.528828392269682*^9, 3.528893958483333*^9, 3.543573863840083*^9, {
   3.598184831055695*^9, 3.598184880393927*^9}, 3.611405958778048*^9, 
   3.611406050637343*^9, 3.611406547679229*^9, 3.6114067225901833`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Final step ", "Subsubsection",
 CellChangeTimes->{{3.526185974779593*^9, 3.5261859906395073`*^9}, 
   3.526192991010663*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"d\[ScriptCapitalF]", "==", 
     RowBox[{"d\[CapitalXi]1", "+", "d\[CapitalXi]2"}]}], "/.", 
    RowBox[{"TetraRule", "@", "g"}]}], "//", "TC"}], ";"}]], "Input",
 CellChangeTimes->{{3.526185927974929*^9, 3.526185932188531*^9}, {
   3.526185967218955*^9, 3.526185967562326*^9}, {3.526186386845331*^9, 
   3.526186402289887*^9}, {3.526192050147409*^9, 3.526192053032196*^9}, {
   3.526193296380054*^9, 3.526193299538211*^9}, 3.526194602023622*^9, 
   3.526283245061029*^9, 3.526283303260219*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualTimes", "[", 
  RowBox[{"%", ",", 
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "p"}], ",", "a", ",", "b", ",", "c"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5261860213140497`*^9, 3.526186023711046*^9}, {
  3.5261864989006844`*^9, 3.526186506644312*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Eta]", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"p", "a", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`epsilong[-$CellContext`p, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"\[ScriptCapitalF]", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[$CellContext`c][
      $CellContext`\[ScriptCapitalF][$CellContext`a, $CellContext`b]],
     Editable->False], ")"}]}], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalZ]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "a", "p"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalZ][$CellContext`a, -$CellContext`a, \
-$CellContext`p],
    Editable->False], "-", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalZ]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "p", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[ScriptCapitalZ][$CellContext`a, -$CellContext`p, \
-$CellContext`a],
    Editable->False], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"S", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", " "},
            {"p", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TFRicciCD[-$CellContext`p, -$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi][$CellContext`a],
     Editable->False]}], "+", 
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LambdaCDe[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {" "},
            {"p"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi][-$CellContext`p],
     Editable->False]}]}]}]], "Output",
 CellChangeTimes->{3.528828394049038*^9, 3.528893960991613*^9, 
  3.543573873501421*^9, 3.598184834319961*^9, 3.5981848832928*^9, 
  3.611405961597514*^9, 3.6114060533148403`*^9, 3.6114065504268208`*^9, 
  3.6114067254304657`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualTimes", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"epsilong", "[", 
     RowBox[{"p", ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "h"}], ",", 
      RowBox[{"-", "f"}]}], "]"}], "/", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.526186048119128*^9, 3.52618604992589*^9}, {
  3.5261861104833527`*^9, 3.526186110698806*^9}, {3.526186516483832*^9, 
  3.5261865427544937`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
        {"\[ScriptCapitalF]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"f", "h"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`d][
     $CellContext`\[ScriptCapitalF][-$CellContext`f, -$CellContext`h]],
    Editable->False], "-", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "f"], GridBox[{
        {"\[ScriptCapitalF]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"d", "h"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`f][
     $CellContext`\[ScriptCapitalF][-$CellContext`d, -$CellContext`h]],
    Editable->False], "+", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
        {"\[ScriptCapitalF]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"d", "f"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`h][
     $CellContext`\[ScriptCapitalF][-$CellContext`d, -$CellContext`f]],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Eta]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "f", "h", "p"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`epsilong[-$CellContext`d, -$CellContext`f, -$CellContext`h, \
-$CellContext`p],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[ScriptCapitalZ]", 
         StyleBox[GridBox[{
            {"a", " ", "p"},
            {" ", "a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[ScriptCapitalZ][$CellContext`a, -$CellContext`a, \
$CellContext`p],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Eta]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "f", "h", "p"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`epsilong[-$CellContext`d, -$CellContext`f, -$CellContext`h, \
-$CellContext`p],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[ScriptCapitalZ]", 
         StyleBox[GridBox[{
            {"a", "p", " "},
            {" ", " ", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[ScriptCapitalZ][$CellContext`a, $CellContext`p, \
-$CellContext`a],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Eta]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "f", "h", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`epsilong[-$CellContext`d, -$CellContext`f, -$CellContext`h, \
-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[CapitalLambda]", "[", "\[EmptyDownTriangle]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LambdaCDe[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi][$CellContext`a],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Eta]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "f", "h", "p"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`epsilong[-$CellContext`d, -$CellContext`f, -$CellContext`h, \
-$CellContext`p],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"S", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", "p"},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TFRicciCD[-$CellContext`a, $CellContext`p],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi][$CellContext`a],
     Editable->False]}]}]}]], "Output",
 CellChangeTimes->{3.528828394106044*^9, 3.528893961106533*^9, 
  3.543573873585766*^9, 3.59818483449646*^9, 3.5981848834172*^9, 
  3.6114059617180033`*^9, 3.611406053408423*^9, 3.611406550510108*^9, 
  3.611406725549671*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"%", "//", "TFRicciToRicci"}], "//", "RicciToEinstein"}], "//", 
   "Decomposition"}], "//", "TC"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
        {"\[ScriptCapitalF]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"f", "h"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`d][
     $CellContext`\[ScriptCapitalF][-$CellContext`f, -$CellContext`h]],
    Editable->False], "-", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "f"], GridBox[{
        {"\[ScriptCapitalF]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"d", "h"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`f][
     $CellContext`\[ScriptCapitalF][-$CellContext`d, -$CellContext`h]],
    Editable->False], "+", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
        {"\[ScriptCapitalF]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"d", "f"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`h][
     $CellContext`\[ScriptCapitalF][-$CellContext`d, -$CellContext`f]],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Eta]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "f", "h", "p"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`epsilong[-$CellContext`d, -$CellContext`f, -$CellContext`h, \
-$CellContext`p],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[ScriptCapitalZ]", 
         StyleBox[GridBox[{
            {"a", " ", "p"},
            {" ", "a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[ScriptCapitalZ][$CellContext`a, -$CellContext`a, \
$CellContext`p],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Eta]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "f", "h", "p"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`epsilong[-$CellContext`d, -$CellContext`f, -$CellContext`h, \
-$CellContext`p],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[ScriptCapitalZ]", 
         StyleBox[GridBox[{
            {"a", "p", " "},
            {" ", " ", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[ScriptCapitalZ][$CellContext`a, $CellContext`p, \
-$CellContext`a],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"G", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {" ", "p"},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`EinsteinCD[-$CellContext`a, $CellContext`p],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Eta]", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "f", "h", "p"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`epsilong[-$CellContext`d, -$CellContext`f, -$CellContext`h, \
-$CellContext`p],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Xi][$CellContext`a],
     Editable->False]}]}]}]], "Output",
 CellChangeTimes->{3.528828394150074*^9, 3.528893961159533*^9, 
  3.543573873666193*^9, 3.598184834634492*^9, 3.598184883526738*^9, 
  3.611405961842456*^9, 3.611406053487453*^9, 3.611406550570796*^9, 
  3.611406725639758*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
CellGrouping->Manual,
WindowSize->{1079, 688},
WindowMargins->{{395, Automatic}, {Automatic, 165}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"9.0 for Linux x86 (64-bit) (February 7, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 481, 11, 117, "Subtitle"],
Cell[1029, 33, 541, 16, 289, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1595, 53, 196, 2, 64, "Subsection"],
Cell[1794, 57, 151, 5, 45, "Text"],
Cell[CellGroupData[{
Cell[1970, 66, 127, 2, 45, "Input"],
Cell[2100, 70, 419, 6, 70, "Print"],
Cell[2522, 78, 691, 14, 70, "Print"],
Cell[3216, 94, 440, 6, 70, "Print"],
Cell[3659, 102, 399, 5, 70, "Print"],
Cell[4061, 109, 380, 5, 70, "Print"],
Cell[4444, 116, 419, 6, 70, "Print"],
Cell[4866, 124, 695, 14, 70, "Print"],
Cell[5564, 140, 440, 6, 70, "Print"],
Cell[6007, 148, 421, 6, 70, "Print"],
Cell[6431, 156, 695, 14, 70, "Print"],
Cell[7129, 172, 478, 6, 70, "Print"],
Cell[7610, 180, 419, 6, 70, "Print"],
Cell[8032, 188, 572, 8, 70, "Print"],
Cell[8607, 198, 417, 6, 70, "Print"]
}, Open  ]],
Cell[9039, 207, 153, 3, 45, "Text"],
Cell[CellGroupData[{
Cell[9217, 214, 369, 8, 45, "Input"],
Cell[9589, 224, 746, 14, 70, "Print"],
Cell[10338, 240, 758, 14, 70, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11133, 259, 318, 9, 45, "Input"],
Cell[11454, 270, 913, 19, 70, "Print"],
Cell[12370, 291, 1017, 22, 70, "Print"],
Cell[13390, 315, 992, 20, 70, "Print"],
Cell[14385, 337, 1008, 20, 70, "Print"],
Cell[15396, 359, 841, 17, 70, "Print"],
Cell[16240, 378, 961, 20, 70, "Print"],
Cell[17204, 400, 979, 21, 70, "Print"],
Cell[18186, 423, 1005, 21, 70, "Print"],
Cell[19194, 446, 923, 19, 70, "Print"],
Cell[20120, 467, 430, 6, 70, "Print"],
Cell[20553, 475, 807, 15, 70, "Print"],
Cell[21363, 492, 436, 6, 70, "Print"],
Cell[21802, 500, 941, 20, 70, "Print"],
Cell[22746, 522, 992, 20, 70, "Print"],
Cell[23741, 544, 933, 19, 70, "Print"],
Cell[24677, 565, 819, 15, 70, "Print"],
Cell[25499, 582, 565, 10, 70, "Print"],
Cell[26067, 594, 557, 10, 70, "Print"],
Cell[26627, 606, 568, 10, 70, "Print"],
Cell[27198, 618, 825, 15, 70, "Print"]
}, Open  ]],
Cell[28038, 636, 193, 2, 45, "Text"],
Cell[CellGroupData[{
Cell[28256, 642, 569, 10, 75, "Input"],
Cell[28828, 654, 752, 14, 70, "Print"],
Cell[29583, 670, 566, 11, 70, "Message"],
Cell[30152, 683, 565, 11, 70, "Message"],
Cell[30720, 696, 926, 17, 70, "Print"],
Cell[31649, 715, 939, 19, 70, "Print"],
Cell[32591, 736, 958, 19, 70, "Print"],
Cell[33552, 757, 897, 17, 70, "Print"],
Cell[34452, 776, 953, 18, 70, "Print"],
Cell[35408, 796, 947, 18, 70, "Print"],
Cell[36358, 816, 1001, 18, 70, "Print"],
Cell[37362, 836, 997, 17, 70, "Print"],
Cell[38362, 855, 992, 17, 70, "Print"],
Cell[39357, 874, 1158, 21, 70, "Print"],
Cell[40518, 897, 1176, 21, 70, "Print"],
Cell[41697, 920, 840, 17, 70, "Print"],
Cell[42540, 939, 949, 19, 70, "Print"],
Cell[43492, 960, 977, 21, 70, "Print"],
Cell[44472, 983, 1042, 21, 70, "Print"],
Cell[45517, 1006, 1036, 20, 70, "Print"],
Cell[46556, 1028, 1122, 22, 70, "Print"],
Cell[47681, 1052, 1194, 23, 70, "Print"],
Cell[48878, 1077, 1298, 25, 70, "Print"],
Cell[50179, 1104, 972, 20, 70, "Print"],
Cell[51154, 1126, 1092, 21, 70, "Print"],
Cell[52249, 1149, 1036, 21, 70, "Print"],
Cell[53288, 1172, 1028, 21, 70, "Print"],
Cell[54319, 1195, 822, 16, 70, "Print"],
Cell[55144, 1213, 959, 19, 70, "Print"],
Cell[56106, 1234, 1077, 20, 70, "Print"],
Cell[57186, 1256, 1324, 26, 70, "Print"],
Cell[58513, 1284, 1339, 26, 70, "Print"],
Cell[59855, 1312, 1109, 21, 70, "Print"],
Cell[60967, 1335, 1129, 21, 70, "Print"],
Cell[62099, 1358, 1314, 26, 70, "Print"],
Cell[63416, 1386, 1327, 26, 70, "Print"],
Cell[64746, 1414, 1119, 21, 70, "Print"],
Cell[65868, 1437, 1137, 21, 70, "Print"]
}, Open  ]],
Cell[67020, 1461, 341, 6, 74, "Text"],
Cell[CellGroupData[{
Cell[67386, 1471, 484, 15, 45, "Input"],
Cell[67873, 1488, 2624, 66, 70, "Output"]
}, Open  ]],
Cell[70512, 1557, 312, 5, 45, "Text"],
Cell[CellGroupData[{
Cell[70849, 1566, 331, 8, 45, "Input"],
Cell[71183, 1576, 1442, 35, 70, "Output"]
}, Open  ]],
Cell[72640, 1614, 287, 5, 74, "Text"],
Cell[72930, 1621, 602, 16, 75, "Input"],
Cell[73535, 1639, 268, 5, 45, "Text"],
Cell[73806, 1646, 237, 5, 45, "Input"],
Cell[74046, 1653, 314, 6, 74, "Text"],
Cell[CellGroupData[{
Cell[74385, 1663, 461, 12, 45, "Input"],
Cell[74849, 1677, 23297, 632, 70, "Output"]
}, Open  ]],
Cell[98161, 2312, 134, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[98320, 2317, 820, 18, 45, "Input"],
Cell[99143, 2337, 1560, 38, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100740, 2380, 159, 3, 45, "Input"],
Cell[100902, 2385, 2646, 69, 70, "Output"]
}, Open  ]],
Cell[103563, 2457, 159, 2, 45, "Text"],
Cell[CellGroupData[{
Cell[103747, 2463, 418, 10, 45, "Input"],
Cell[104168, 2475, 898, 17, 70, "Print"],
Cell[105069, 2494, 920, 18, 70, "Print"]
}, Open  ]],
Cell[106004, 2515, 172, 2, 45, "Text"],
Cell[CellGroupData[{
Cell[106201, 2521, 327, 8, 45, "Input"],
Cell[106531, 2531, 1332, 34, 70, "Output"]
}, Open  ]],
Cell[107878, 2568, 131, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[108034, 2573, 240, 5, 45, "Input"],
Cell[108277, 2580, 792, 14, 70, "Print"],
Cell[109072, 2596, 830, 14, 70, "Print"]
}, Open  ]],
Cell[109917, 2613, 247, 7, 74, "Text"],
Cell[CellGroupData[{
Cell[110189, 2624, 859, 26, 45, "Input"],
Cell[111051, 2652, 6925, 187, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118013, 2844, 127, 2, 45, "Input"],
Cell[118143, 2848, 3544, 97, 70, "Output"]
}, Open  ]],
Cell[121702, 2948, 123, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[121850, 2953, 1496, 46, 104, "Input"],
Cell[123349, 3001, 7628, 202, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[131014, 3208, 125, 2, 45, "Input"],
Cell[131142, 3212, 2607, 68, 70, "Output"]
}, Open  ]],
Cell[133764, 3283, 120, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[133909, 3288, 877, 30, 75, "Input"],
Cell[134789, 3320, 3158, 81, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137984, 3406, 159, 3, 45, "Input"],
Cell[138146, 3411, 5238, 142, 70, "Output"]
}, Open  ]],
Cell[143399, 3556, 283, 5, 74, "Text"],
Cell[CellGroupData[{
Cell[143707, 3565, 320, 10, 45, "Input"],
Cell[144030, 3577, 1525, 39, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145592, 3621, 156, 3, 45, "Input"],
Cell[145751, 3626, 3359, 87, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149147, 3718, 164, 3, 45, "Input"],
Cell[149314, 3723, 4786, 128, 70, "Output"]
}, Open  ]],
Cell[154115, 3854, 191, 2, 45, "Text"],
Cell[CellGroupData[{
Cell[154331, 3860, 432, 10, 45, "Input"],
Cell[154766, 3872, 866, 17, 70, "Print"],
Cell[155635, 3891, 959, 19, 70, "Print"],
Cell[156597, 3912, 1012, 21, 70, "Print"],
Cell[157612, 3935, 1080, 20, 70, "Print"],
Cell[158695, 3957, 953, 19, 70, "Print"],
Cell[159651, 3978, 453, 6, 70, "Print"],
Cell[160107, 3986, 996, 20, 70, "Print"],
Cell[161106, 4008, 1066, 21, 70, "Print"],
Cell[162175, 4031, 1060, 20, 70, "Print"],
Cell[163238, 4053, 1146, 22, 70, "Print"],
Cell[164387, 4077, 1217, 23, 70, "Print"],
Cell[165607, 4102, 1317, 24, 70, "Print"],
Cell[166927, 4128, 996, 20, 70, "Print"],
Cell[167926, 4150, 1114, 21, 70, "Print"],
Cell[169043, 4173, 1062, 21, 70, "Print"],
Cell[170108, 4196, 1054, 21, 70, "Print"],
Cell[171165, 4219, 1245, 23, 70, "Print"],
Cell[172413, 4244, 1262, 23, 70, "Print"],
Cell[173678, 4269, 1031, 21, 70, "Print"],
Cell[174712, 4292, 1094, 21, 70, "Print"],
Cell[175809, 4315, 1350, 26, 70, "Print"],
Cell[177162, 4343, 1365, 26, 70, "Print"],
Cell[178530, 4371, 1135, 21, 70, "Print"],
Cell[179668, 4394, 1155, 21, 70, "Print"]
}, Open  ]],
Cell[180838, 4418, 181, 4, 45, "Text"],
Cell[CellGroupData[{
Cell[181044, 4426, 283, 8, 45, "Input"],
Cell[181330, 4436, 350, 5, 70, "Output"]
}, Open  ]],
Cell[181695, 4444, 101, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[181821, 4449, 202, 6, 45, "Input"],
Cell[182026, 4457, 4714, 129, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186777, 4591, 165, 3, 45, "Input"],
Cell[186945, 4596, 7275, 200, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194257, 4801, 128, 2, 45, "Input"],
Cell[194388, 4805, 4896, 133, 70, "Output"]
}, Open  ]],
Cell[199299, 4941, 179, 4, 45, "Text"],
Cell[CellGroupData[{
Cell[199503, 4949, 466, 11, 45, "Input"],
Cell[199972, 4962, 1413, 37, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201422, 5004, 162, 3, 45, "Input"],
Cell[201587, 5009, 2499, 68, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[204135, 5083, 125, 1, 50, "Subsection"],
Cell[204263, 5086, 135, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[204423, 5091, 290, 8, 45, "Input"],
Cell[204716, 5101, 5521, 153, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210274, 5259, 137, 2, 45, "Input"],
Cell[210414, 5263, 1568, 39, 70, "Output"]
}, Open  ]],
Cell[211997, 5305, 169, 4, 45, "Text"],
Cell[CellGroupData[{
Cell[212191, 5313, 175, 4, 45, "Input"],
Cell[212369, 5319, 5516, 153, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217922, 5477, 132, 2, 45, "Input"],
Cell[218057, 5481, 1325, 34, 70, "Output"]
}, Open  ]],
Cell[219397, 5518, 158, 3, 45, "Text"],
Cell[CellGroupData[{
Cell[219580, 5525, 247, 7, 45, "Input"],
Cell[219830, 5534, 800, 16, 70, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[220667, 5555, 254, 7, 45, "Input"],
Cell[220924, 5564, 506, 10, 70, "Message"],
Cell[221433, 5576, 1057, 21, 70, "Print"],
Cell[222493, 5599, 1071, 20, 70, "Print"],
Cell[223567, 5621, 3488, 96, 70, "Output"]
}, Open  ]],
Cell[227070, 5720, 1418, 39, 79, "Text"],
Cell[CellGroupData[{
Cell[228513, 5763, 572, 16, 45, "Input"],
Cell[229088, 5781, 982, 19, 70, "Print"],
Cell[230073, 5802, 1000, 19, 70, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[231110, 5826, 254, 7, 45, "Input"],
Cell[231367, 5835, 3489, 96, 70, "Output"]
}, Open  ]],
Cell[234871, 5934, 126, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[235022, 5939, 382, 11, 45, "Input"],
Cell[235407, 5952, 1301, 33, 70, "Output"]
}, Open  ]],
Cell[236723, 5988, 231, 3, 45, "Text"],
Cell[CellGroupData[{
Cell[236979, 5995, 246, 7, 45, "Input"],
Cell[237228, 6004, 1271, 33, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[238536, 6042, 147, 3, 45, "Input"],
Cell[238686, 6047, 7525, 210, 70, "Output"]
}, Open  ]],
Cell[246226, 6260, 1288, 35, 50, "Text"],
Cell[CellGroupData[{
Cell[247539, 6299, 451, 13, 45, "Input"],
Cell[247993, 6314, 1270, 33, 70, "Output"]
}, Open  ]],
Cell[249278, 6350, 343, 6, 102, "Text"],
Cell[CellGroupData[{
Cell[249646, 6360, 972, 27, 104, "Input"],
Cell[250621, 6389, 7656, 209, 70, "Output"]
}, Open  ]],
Cell[258292, 6601, 204, 4, 45, "Text"],
Cell[CellGroupData[{
Cell[258521, 6609, 344, 10, 45, "Input"],
Cell[258868, 6621, 2409, 63, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[261314, 6689, 121, 2, 45, "Input"],
Cell[261438, 6693, 10777, 302, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[272252, 7000, 198, 4, 45, "Input"],
Cell[272453, 7006, 6473, 180, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[278963, 7191, 149, 3, 45, "Input"],
Cell[279115, 7196, 20017, 550, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[299169, 7751, 163, 3, 45, "Input"],
Cell[299335, 7756, 5897, 158, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[305281, 7920, 118, 1, 50, "Subsection"],
Cell[CellGroupData[{
Cell[305424, 7925, 118, 1, 50, "Subsubsection"],
Cell[305545, 7928, 144, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[305714, 7933, 421, 11, 52, "Input"],
Cell[306138, 7946, 730, 14, 34, "Print"],
Cell[306871, 7962, 766, 14, 34, "Print"]
}, Open  ]],
Cell[307652, 7979, 130, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[307807, 7984, 919, 27, 84, "Input"],
Cell[308729, 8013, 936, 19, 34, "Print"],
Cell[309668, 8034, 956, 19, 34, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[310661, 8058, 477, 14, 45, "Input"],
Cell[311141, 8074, 882, 17, 34, "Print"],
Cell[312026, 8093, 920, 17, 34, "Print"]
}, Open  ]],
Cell[312961, 8113, 387, 9, 47, "Input"],
Cell[313351, 8124, 238, 3, 45, "Text"],
Cell[CellGroupData[{
Cell[313614, 8131, 207, 5, 45, "Input"],
Cell[313824, 8138, 716, 14, 34, "Print"]
}, Open  ]],
Cell[314555, 8155, 230, 3, 45, "Text"],
Cell[314788, 8160, 236, 6, 45, "Input"],
Cell[315027, 8168, 118, 1, 45, "Text"],
Cell[CellGroupData[{
Cell[315170, 8173, 1289, 36, 104, "Input"],
Cell[316462, 8211, 6552, 171, 65, "Output"]
}, Open  ]],
Cell[323029, 8385, 111, 1, 45, "Text"],
Cell[323143, 8388, 275, 7, 45, "Input"],
Cell[323421, 8397, 162, 2, 45, "Text"],
Cell[323586, 8401, 234, 5, 45, "Input"],
Cell[323823, 8408, 163, 3, 45, "Text"],
Cell[323989, 8413, 420, 12, 45, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[324446, 8430, 1517, 36, 43, "Subsubsection"],
Cell[325966, 8468, 998, 28, 50, "Text"],
Cell[CellGroupData[{
Cell[326989, 8500, 670, 16, 45, "Input"],
Cell[327662, 8518, 4101, 111, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[331800, 8634, 633, 11, 45, "Input"],
Cell[332436, 8647, 46249, 1171, 320, "Output"]
}, Open  ]],
Cell[378700, 9821, 286, 6, 45, "Text"],
Cell[378989, 9829, 742, 12, 45, "Input"],
Cell[379734, 9843, 670, 11, 45, "Input"],
Cell[380407, 9856, 242, 3, 45, "Text"],
Cell[380652, 9861, 773, 14, 45, "Input"],
Cell[381428, 9877, 248, 5, 74, "Text"],
Cell[381679, 9884, 703, 16, 75, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[382419, 9905, 194, 2, 39, "Subsubsection"],
Cell[382616, 9909, 207, 2, 45, "Text"],
Cell[382826, 9913, 1338, 33, 75, "Input"],
Cell[384167, 9948, 722, 18, 45, "Input"],
Cell[384892, 9968, 789, 15, 45, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[385718, 9988, 207, 3, 39, "Subsubsection"],
Cell[385928, 9993, 228, 5, 45, "Text"],
Cell[CellGroupData[{
Cell[386181, 10002, 346, 9, 45, "Input"],
Cell[386530, 10013, 766, 16, 34, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[387333, 10034, 202, 6, 45, "Input"],
Cell[387538, 10042, 4413, 123, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[391988, 10170, 835, 23, 45, "Input"],
Cell[392826, 10195, 8023, 216, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[400886, 10416, 742, 13, 45, "Input"],
Cell[401631, 10431, 13343, 365, 116, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[415023, 10802, 130, 2, 39, "Subsubsection"],
Cell[415156, 10806, 554, 11, 45, "Input"],
Cell[CellGroupData[{
Cell[415735, 10821, 310, 8, 45, "Input"],
Cell[416048, 10831, 8082, 222, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[424167, 11058, 426, 11, 45, "Input"],
Cell[424596, 11071, 13799, 374, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[438432, 11450, 169, 5, 45, "Input"],
Cell[438604, 11457, 11434, 308, 65, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
