(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   3071960,      70673]
NotebookOptionsPosition[   2960211,      68870]
NotebookOutlinePosition[   2960935,      68895]
CellTagsIndexPosition[   2960892,      68892]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["SymManipulator",
 FontSlant->"Italic",
 FontColor->RGBColor[1, 0, 0]]], "Title",
 CellChangeTimes->{{3.424432795274125*^9, 3.424432798147224*^9}, {
  3.515744094758826*^9, 3.515744097651992*^9}, {3.515938160464596*^9, 
  3.515938165706205*^9}},ExpressionUUID->"377862db-d62f-455a-8f49-\
851076d0463c"],

Cell[TextData[StyleBox["Symmetrized tensor expressions",
 FontColor->RGBColor[0, 0, 1]]], "Subtitle",
 CellChangeTimes->{{3.432628764630637*^9, 3.432628770497842*^9}, {
  3.515744107853575*^9, 3.515744118206167*^9}, {3.5445929647531424`*^9, 
  3.544592965622192*^9}},ExpressionUUID->"027dc16a-b119-4d76-bbf9-\
933d508e9efd"],

Cell[TextData[{
 StyleBox["Thomas B\[ADoubleDot]ckdahl",
  FontSize->18],
 "     thomas.backdahl@chalmers.se\nMathematical Sciences,\nChalmers \
University of Technology and University of Gothenburg\nGothenburg, Sweden\n\n\
(c) 2011-2024, under GPL\n\nhttp://www.xAct.es/\n\
http://groups.google.com/group/xAct"
}], "Subsubtitle",
 CellChangeTimes->{{3.515744127407694*^9, 3.515744214153655*^9}, {
   3.515938182944235*^9, 3.515938183474636*^9}, {3.53545464507944*^9, 
   3.5354546469202437`*^9}, {3.5671882614270697`*^9, 
   3.5671882618482695`*^9}, {3.582348307226815*^9, 3.5823483224212413`*^9}, {
   3.582348357521304*^9, 3.5823483734177313`*^9}, {3.582348422418418*^9, 
   3.582348460420084*^9}, {3.5891985108400106`*^9, 3.589198511947613*^9}, 
   3.598170071223643*^9, {3.6483947941911926`*^9, 3.648394815851222*^9}, {
   3.648394855558444*^9, 3.648394928298605*^9}, {3.680003670440614*^9, 
   3.680003688900429*^9}, {3.8387105765180273`*^9, 3.8387105767075214`*^9}, {
   3.83880384888338*^9, 3.8388038521975555`*^9}, 3.838803949229465*^9, 
   3.8388206260743427`*^9, 3.872752429560192*^9, 
   3.9234486569645214`*^9},ExpressionUUID->"4a327c6d-327f-4a3a-942d-\
2344e664c1e2"],

Cell[TextData[{
 StyleBox["SymManipulator",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is a package for handling symmetrized tensor expressions and making \
irreducible decompositions of spinor expressions.\n\n",
 StyleBox["SymManipulator",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is distributed under the GNU General Public License, and runs on top of ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", a free package for fast manipulation of abstract tensor expressions. Both \
can be downloaded from ",
 StyleBox["http://www.xAct.es/",
  FontWeight->"Bold"]
}], "Text",
 CellChangeTimes->{{3.419078218575598*^9, 3.419078246806376*^9}, {
  3.425990024306922*^9, 3.425990025430625*^9}, {3.494136330043101*^9, 
  3.494136333188654*^9}, {3.515744221923099*^9, 3.5157442456454573`*^9}, {
  3.515938190057847*^9, 3.51593820845028*^9}, {3.529237811545199*^9, 
  3.529237844414456*^9}},ExpressionUUID->"b83909a8-e287-47ec-bdda-\
a1a95a48dc93"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "]"}]], "Input",
 CellChangeTimes->{{3.461421019166093*^9, 3.461421020263547*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"f865cdd3-9156-4393-97df-e97beb85acff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2021", ",", "9", ",", "3", ",", "21", ",", "50", ",", 
   "6.8116973`8.585830313221484"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5201748450984583`*^9, 3.520175592850561*^9, 3.52017596479801*^9, 
   3.5201760928938336`*^9, 3.5201762671609383`*^9, 3.520176752597585*^9, 
   3.5201779201008253`*^9, 3.5201779700665092`*^9, 3.5201780303834147`*^9, 
   3.520178119921769*^9, 3.520178320764917*^9, 3.520179006952915*^9, 
   3.5201791070766892`*^9, 3.520179190298833*^9, 3.52017923484451*^9, 
   3.520179281313389*^9, 3.520179460495299*^9, 3.5201795483158517`*^9, 
   3.520181356801396*^9, 3.52018163326988*^9, 3.520268558614688*^9, 
   3.520268726626528*^9, 3.520268859119117*^9, 3.52026889611597*^9, 
   3.520269087468241*^9, 3.520271811210497*^9, 3.520310595427935*^9, 
   3.520310975876489*^9, 3.5203117778404226`*^9, 3.5203120960882998`*^9, 
   3.5271449373462715`*^9, 3.5271458071433992`*^9, 3.52714600064714*^9, 
   3.527147021733333*^9, 3.527147592398936*^9, 3.527148045611931*^9, 
   3.527148262935913*^9, 3.527148685191058*^9, 3.527150049445654*^9, 
   3.527150171734269*^9, 3.527150352273386*^9, 3.5271505062924576`*^9, 
   3.527150790680956*^9, 3.527150864063485*^9, 3.5292308221613216`*^9, 
   3.5292324657178087`*^9, 3.5292325704563932`*^9, 3.529235908180855*^9, 
   3.529236216250196*^9, 3.529236415821347*^9, 3.5292366532537637`*^9, 
   3.5292367147802715`*^9, 3.529236965912513*^9, 3.529237056345872*^9, 
   3.534068568038586*^9, 3.534068950442058*^9, 3.534069381392814*^9, 
   3.534069950559814*^9, 3.53407017563701*^9, 3.5342496349881587`*^9, 
   3.537621497408594*^9, 3.537621623940417*^9, 3.5376228407123547`*^9, {
   3.537622948290143*^9, 3.537622963078969*^9}, 3.537623181697753*^9, 
   3.5376233601932664`*^9, 3.5376254387741175`*^9, 3.5376287880242715`*^9, 
   3.5376946984858675`*^9, 3.537694866373363*^9, 3.537695500467676*^9, 
   3.537695580246217*^9, 3.5376959119193993`*^9, 3.5376963939602447`*^9, 
   3.537697103606492*^9, 3.5376974590531163`*^9, {3.537697970468815*^9, 
   3.5376979899220486`*^9}, 3.537700569234584*^9, 3.537700987268518*^9, 
   3.537701148557202*^9, 3.537705074151097*^9, 3.537767648391486*^9, 
   3.537780184692705*^9, 3.5377805825558047`*^9, 3.537780919595396*^9, 
   3.537781078622076*^9, 3.537781240737561*^9, 3.5377813767854*^9, 
   3.537781525859261*^9, 3.5377817242760096`*^9, 3.537782397667793*^9, 
   3.537782738543991*^9, 3.537782929706727*^9, 3.5377831903675847`*^9, 
   3.5377834392358212`*^9, 3.5377835716176553`*^9, 3.537784106542594*^9, 
   3.537784243386034*^9, 3.544092207879559*^9, 3.544097238595995*^9, 
   3.544097364160615*^9, 3.544097951565047*^9, 3.5440997528856115`*^9, 
   3.544103371360767*^9, 3.544103462558527*^9, 3.544103703767151*^9, 
   3.544103916145923*^9, 3.54410405055576*^9, 3.5441050983794007`*^9, 
   3.544105713004879*^9, 3.5441059477540917`*^9, 3.544107146242797*^9, 
   3.54459125186217*^9, 3.544591489073738*^9, 3.544591651463026*^9, 
   3.5445929032206225`*^9, 3.5446721717281303`*^9, 3.544672373193654*^9, 
   3.544673272411086*^9, {3.544673382043357*^9, 3.544673401580474*^9}, 
   3.544949217507423*^9, 3.5449516127414327`*^9, 3.545015660637729*^9, 
   3.54501572313144*^9, 3.545106140417047*^9, 3.545114019247418*^9, 
   3.5528211940801983`*^9, 3.5528226582373714`*^9, 3.55282279426961*^9, 
   3.552822985433346*^9, 3.5528231946453133`*^9, 3.5528236648769393`*^9, 
   3.552823969889675*^9, 3.552826115362443*^9, 3.552826308086182*^9, 
   3.5542072700575094`*^9, 3.554208465536409*^9, 3.561371696187217*^9, 
   3.561732584986005*^9, 3.561779196492604*^9, 3.561781486672226*^9, 
   3.561781560741156*^9, 3.561781651626916*^9, 3.561781901133754*^9, 
   3.561781932411809*^9, 3.5617821001443033`*^9, 3.561782193338867*^9, 
   3.561782386732407*^9, 3.56178249126819*^9, 3.561782524418249*^9, 
   3.5617842329196496`*^9, 3.562766624845748*^9, 3.5627667425479555`*^9, 
   3.562767080990549*^9, 3.5627678918497734`*^9, 3.562769544564476*^9, 
   3.56276966650989*^9, {3.562771127485657*^9, 3.562771145768888*^9}, 
   3.5627731129021435`*^9, 3.562773200792698*^9, 3.562821270227209*^9, 
   3.562822344586497*^9, 3.562823596443895*^9, 3.562823659733206*^9, 
   3.56282406054471*^9, 3.562824597420654*^9, 3.562825242122986*^9, 
   3.562825310466705*^9, 3.562825370511211*^9, 3.562825957931243*^9, 
   3.562826132589149*^9, 3.56282624664095*^9, 3.562828064642171*^9, 
   3.562828562563845*^9, 3.562828735240548*^9, 3.5628288774815984`*^9, 
   3.562830488202028*^9, 3.56283130395866*^9, 3.5628316985779543`*^9, 
   3.562831819602967*^9, 3.56283185036622*^9, 3.562832306979022*^9, 
   3.562832420360021*^9, 3.5628327279769616`*^9, 3.562833668581614*^9, 
   3.56283376305538*^9, 3.562833833598703*^9, 3.563425631373389*^9, 
   3.563426365869479*^9, 3.563427212265566*^9, 3.563428698122376*^9, 
   3.563428790068938*^9, 3.563428868849076*^9, 3.563429665169074*^9, 
   3.564123611308436*^9, 3.564124344510723*^9, 3.564124861044231*^9, 
   3.564125016296704*^9, 3.5641304406546316`*^9, 3.564635024021423*^9, 
   3.5646354965618525`*^9, 3.5646721277594867`*^9, 3.565759285923563*^9, 
   3.565773665638832*^9, 3.565892021411496*^9, 3.566194850147024*^9, 
   3.566203969745868*^9, 3.5662119026396637`*^9, 3.5662126380007563`*^9, 
   3.566214732351235*^9, 3.5663991476361327`*^9, 3.566543710509116*^9, 
   3.567082812248925*^9, 3.5671851346335764`*^9, 3.567586520134695*^9, 
   3.5676004782589216`*^9, 3.5678594368679476`*^9, 3.567860569571337*^9, 
   3.567861305722031*^9, 3.5678615186780047`*^9, 3.5678616178473797`*^9, 
   3.5678617145831485`*^9, 3.567861808822914*^9, 3.56786203435251*^9, 
   3.567862203456807*^9, 3.5678625351767893`*^9, 3.5678626821290483`*^9, 
   3.567862769941602*^9, 3.567863318968967*^9, 3.567863413676733*^9, 
   3.567863935279249*^9, 3.567864087489717*^9, 3.567864252475606*^9, 
   3.567864765732108*^9, 3.5678650145213447`*^9, 3.5678653135738688`*^9, 
   3.5678655273420453`*^9, 3.567877452606958*^9, 3.5679119462244897`*^9, 
   3.5679130610960474`*^9, 3.567916908038382*^9, 3.567917675232129*^9, 
   3.5679183595127316`*^9, 3.5679186135435777`*^9, 3.5679194434182353`*^9, 
   3.567919755465583*^9, 3.56792425656309*^9, 3.567926173807457*^9, 
   3.567926475558787*^9, 3.5679268601774635`*^9, 3.567929472625652*^9, 
   3.567929589376257*^9, 3.5679296707928*^9, 3.567929855029124*^9, 
   3.5679300820417233`*^9, 3.567930173535883*^9, 3.567930335339367*^9, 
   3.567930621194269*^9, 3.567931057183835*^9, 3.567931209284102*^9, 
   3.567931330277914*^9, 3.5679314656861534`*^9, 3.5679315186804466`*^9, 
   3.567931624479831*^9, 3.567931948976002*^9, 3.567932630369598*^9, 
   3.5679327498814087`*^9, 3.5679331244234657`*^9, 3.5679332316892548`*^9, 
   3.5679334628192596`*^9, 3.567934708810049*^9, 3.567935970697265*^9, 
   3.5681150026035533`*^9, 3.568115907094141*^9, 3.568122251894486*^9, 
   3.5681223539654646`*^9, 3.568123410993121*^9, 3.568895115070609*^9, 
   3.5688954820612535`*^9, 3.5716491543915567`*^9, 3.5721653869828267`*^9, 
   3.572175134176747*^9, 3.572175205390873*^9, 3.572176523048187*^9, 
   3.572177188429157*^9, {3.572177272357304*^9, 3.5721772891897335`*^9}, 
   3.574769480521033*^9, 3.582348619150363*^9, 3.582348666012845*^9, {
   3.582348892899644*^9, 3.582348909030072*^9}, 3.5830663213411694`*^9, 
   3.5830672363451777`*^9, 3.583562342878081*^9, 3.583562486320333*^9, 
   3.5841966543245296`*^9, 3.584767089203996*^9, 3.5847677728595977`*^9, 
   3.584768128587021*^9, 3.584768643279725*^9, 3.584773809529071*^9, 
   3.584774005574615*^9, 3.584774459146412*^9, 3.584774880581152*^9, 
   3.5847752356533756`*^9, 3.5847754980302362`*^9, 3.5847756359344783`*^9, {
   3.584777748024189*^9, 3.584777757072204*^9}, 3.584882231194465*^9, 
   3.5870251651548524`*^9, 3.587653681929231*^9, {3.5876537669201818`*^9, 
   3.587653775749797*^9}, 3.588238727201561*^9, 3.589198365385356*^9, 
   3.589894498515334*^9, 3.5901468883279686`*^9, 3.590147520487879*^9, 
   3.590148329396099*^9, 3.590148590524958*^9, 3.590318327991581*^9, 
   3.592139785614528*^9, 3.592140061115914*^9, 3.592140124496002*^9, 
   3.592140370796347*^9, 3.592141012717246*^9, 3.592142181498882*^9, 
   3.592218077040033*^9, 3.592218376350452*^9, 3.592218786041025*^9, 
   3.5922191924825945`*^9, 3.592219365292837*^9, 3.5981704075141134`*^9, 
   3.5981880835340505`*^9, 3.600328175679326*^9, 3.603719760281646*^9, 
   3.603719895081835*^9, 3.6037200262720194`*^9, 3.603720434732591*^9, 
   3.603720657382902*^9, 3.6037207925240917`*^9, 3.603720921324272*^9, 
   3.603721579805194*^9, 3.603721639395277*^9, 3.6037225555175605`*^9, 
   3.607076276715502*^9, 3.615127544009867*^9, 3.6151276714800453`*^9, 
   3.615127771120185*^9, 3.615127835710275*^9, 3.615128168817133*^9, 
   3.6151290204283247`*^9, 3.615129055248374*^9, 3.61512972405931*^9, 
   3.619615812606519*^9, 3.619616041040887*^9, 3.61961696820737*^9, 
   3.619617065997507*^9, 3.61961721237176*^9, 3.619689235186535*^9, 
   3.6196894513508863`*^9, 3.619689491820943*^9, 3.619689955670688*^9, 
   3.6196901212509203`*^9, 3.6205393058984756`*^9, 3.6208036376006565`*^9, 
   3.620804077621272*^9, 3.6208041465913696`*^9, 3.63903560056736*^9, 
   3.648395060125345*^9, 3.648395209865555*^9, 3.680003707490243*^9, 
   3.680101706645404*^9, 3.8387111407646217`*^9, 3.8387112732497826`*^9, 
   3.838805500438156*^9, 3.8388824997290587`*^9, 3.8391498899532638`*^9, 
   3.839151421748799*^9, 3.839671968795105*^9, 3.83967207564751*^9, 
   3.839687406833611*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"7ee093ff-3a06-4688-8691-8c28d7f4b6a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`SymManipulator`$Version", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<0.9.6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2024", ",", "04", ",", "30"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5201736763242097`*^9, 3.52017367651141*^9}, 
   3.5202677233961115`*^9, {3.524975610240281*^9, 3.524975619007497*^9}, {
   3.526043102559106*^9, 3.5260431029851303`*^9}, 3.5262094698353777`*^9, {
   3.527143521454584*^9, 3.527143523888189*^9}, 3.527145380935051*^9, {
   3.527148024473894*^9, 3.527148025066695*^9}, {3.527150851411863*^9, 
   3.527150853003065*^9}, {3.527487735477854*^9, 3.527487735649454*^9}, {
   3.529235948304126*^9, 3.529235955495738*^9}, {3.530340543752088*^9, 
   3.530340544270118*^9}, {3.5340680436748643`*^9, 3.5340680511160784`*^9}, {
   3.534248359249119*^9, 3.53424836010712*^9}, {3.5354546246122036`*^9, 
   3.535454629229812*^9}, {3.5376260016865067`*^9, 3.53762600379251*^9}, 
   3.537697958987195*^9, 3.5377801890451126`*^9, {3.54020534631925*^9, 
   3.540205347773333*^9}, {3.544091585983466*^9, 3.544091587418669*^9}, 
   3.5441070904258986`*^9, 3.54459029794861*^9, {3.5446732637615914`*^9, 
   3.544673264066609*^9}, {3.5451058294149003`*^9, 3.545105832690906*^9}, 
   3.545113412655953*^9, {3.549022343760488*^9, 3.549022346287692*^9}, {
   3.552826297821364*^9, 3.5528263005513687`*^9}, {3.56094496233256*^9, 
   3.560944965093765*^9}, 3.561368747422238*^9, {3.562821017366365*^9, 
   3.562821018239967*^9}, {3.562821058690838*^9, 3.562821059408439*^9}, {
   3.56412500309908*^9, 3.564125006531086*^9}, {3.5646349977977777`*^9, 
   3.564634998328178*^9}, {3.567188270256685*^9, 3.5671882813795037`*^9}, {
   3.5678591469726386`*^9, 3.5678591471286387`*^9}, {3.567920466734233*^9, 
   3.567920467171033*^9}, 3.568122916627253*^9, {3.568895100640584*^9, 
   3.568895103354988*^9}, {3.5695822059707413`*^9, 3.569582206173542*^9}, {
   3.572177261608885*^9, 3.572177262825688*^9}, {3.574769468337412*^9, 
   3.574769469382613*^9}, 3.574831910601655*^9, {3.582348607309942*^9, 
   3.582348609369146*^9}, {3.5830663119655538`*^9, 3.583066312199554*^9}, {
   3.583562619029765*^9, 3.5835626202309675`*^9}, {3.5841777191143513`*^9, 
   3.58417771923915*^9}, {3.584767069298361*^9, 3.584767079063978*^9}, 
   3.584881396108399*^9, {3.585235423477005*^9, 3.5852354236486044`*^9}, {
   3.586838863886363*^9, 3.5868388639799633`*^9}, {3.5870251513488283`*^9, 
   3.587025153501632*^9}, 3.587122588675266*^9, 3.587653689526445*^9, {
   3.588066885157487*^9, 3.588066885282287*^9}, 3.5882387034271197`*^9, {
   3.5891983140924654`*^9, 3.5891983144512663`*^9}, {3.589894487610915*^9, 
   3.58989449091812*^9}, 3.590147506619455*^9, {3.590215567365875*^9, 
   3.5902155677608986`*^9}, 3.590237501179349*^9, {3.590308422883808*^9, 
   3.5903084442714453`*^9}, {3.5904906511222076`*^9, 3.5904906515322084`*^9}, 
   3.591096459021846*^9, {3.5921279194217677`*^9, 3.592127919641767*^9}, 
   3.592218050399996*^9, {3.597208474205775*^9, 3.59720848241139*^9}, {
   3.59817005535362*^9, 3.5981700611736283`*^9}, {3.599302375778889*^9, 
   3.5993023759088902`*^9}, 3.5995492418230953`*^9, {3.601472763302945*^9, 
   3.601472768842954*^9}, {3.6015566705915284`*^9, 3.601556671101529*^9}, {
   3.603719231839906*^9, 3.603719233689909*^9}, {3.6039806663208675`*^9, 
   3.603980666510868*^9}, {3.607076267195489*^9, 3.607076269095492*^9}, {
   3.607876646386898*^9, 3.607876646506898*^9}, {3.607925225198322*^9, 
   3.607925227808326*^9}, 3.608357297970894*^9, 3.608545275755491*^9, {
   3.6088804044557514`*^9, 3.608880404605751*^9}, 3.6093305386391397`*^9, 
   3.6120047250359426`*^9, {3.61380289772174*^9, 3.613802900451744*^9}, {
   3.615131065824986*^9, 3.615131066027786*^9}, {3.619617201121744*^9, 
   3.6196172035117474`*^9}, 3.619687121353238*^9, 3.619689945536626*^9, 
   3.620025617582897*^9, {3.620203268542678*^9, 3.620203268732678*^9}, {
   3.620539282268443*^9, 3.6205392843584456`*^9}, {3.620804067821259*^9, 
   3.62080406829126*^9}, {3.639035586647341*^9, 3.639035591277347*^9}, {
   3.6483947823611755`*^9, 3.648394782421175*^9}, {3.648394950105191*^9, 
   3.648394952015194*^9}, {3.680003656580752*^9, 3.680003658340735*^9}, 
   3.680090162343729*^9, {3.685192425652608*^9, 3.68519242741261*^9}, {
   3.689401572322432*^9, 3.689401574434643*^9}, {3.838710584068235*^9, 
   3.838710592403426*^9}, 3.838803856422213*^9, 3.838882489421023*^9, 
   3.839127830396103*^9, {3.839671923020236*^9, 3.8396719266914225`*^9}, 
   3.8399307650976095`*^9, {3.840629772724206*^9, 3.8406297728758006`*^9}, {
   3.8727524156713476`*^9, 3.8727524224901032`*^9}, {3.9234487523064785`*^9, 
   3.9234487596129665`*^9}},ExpressionUUID->"05fa329c-178c-4a31-b22f-\
dc9fec05e8af"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0.9.5\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "9", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.520174845114058*^9, 3.520175592870561*^9, 3.52017596481361*^9, 
   3.5201760929094343`*^9, 3.5201762671765385`*^9, 3.520176752628785*^9, 
   3.520177920110825*^9, 3.5201779700765095`*^9, 3.5201780303990145`*^9, 
   3.520178119941769*^9, 3.5201783207805166`*^9, 3.520179006968516*^9, 
   3.5201791070766892`*^9, 3.520179190314433*^9, 3.5201792348601108`*^9, 
   3.5201792813333898`*^9, 3.5201794605108986`*^9, 3.5201795483358517`*^9, 
   3.520181356816996*^9, 3.52018163328988*^9, 3.520268558624688*^9, 
   3.520268726636527*^9, 3.520268859139117*^9, 3.52026889613597*^9, 
   3.520269087488241*^9, 3.520271811230497*^9, 3.520310595447935*^9, 
   3.52031097590649*^9, 3.520311777850422*^9, 3.5203120961082993`*^9, {
   3.5271449345382667`*^9, 3.5271449373462715`*^9}, 3.5271458071589994`*^9, 
   3.5271460006627398`*^9, 3.527147021748933*^9, 3.527147592414536*^9, 
   3.527148045627531*^9, 3.5271482629515142`*^9, 3.527148685206658*^9, 
   3.527150049461254*^9, 3.527150171749869*^9, 3.527150352288986*^9, 
   3.527150506308057*^9, 3.527150790696556*^9, 3.527150864079085*^9, 
   3.529230822176922*^9, 3.529232465733408*^9, 3.529232570471993*^9, 
   3.529235908196455*^9, 3.529236216250196*^9, 3.5292364158369465`*^9, 
   3.5292366532693634`*^9, 3.5292367147958717`*^9, 3.529236965928113*^9, 
   3.5292370563770733`*^9, 3.534068568069786*^9, 3.534068950473258*^9, 
   3.534069381439615*^9, 3.5340699506066146`*^9, 3.53407017566821*^9, 
   3.5342496350193586`*^9, 3.5376214974397945`*^9, 3.5376216239560165`*^9, 
   3.537622840743554*^9, {3.537622948321343*^9, 3.537622963110169*^9}, 
   3.537623181744553*^9, 3.537623360224467*^9, 3.5376254388521175`*^9, 
   3.537628788086672*^9, 3.537694698517068*^9, 3.537694866404563*^9, 
   3.5376955004988766`*^9, 3.537695580277416*^9, 3.537695911934999*^9, 
   3.537696393991445*^9, 3.537697103653292*^9, 3.5376974590843167`*^9, {
   3.537697970500015*^9, 3.537697989953249*^9}, 3.537700569265784*^9, 
   3.537700987299718*^9, 3.537701148572801*^9, 3.5377050741978965`*^9, 
   3.537767648453886*^9, 3.537780184723905*^9, 3.537780582602604*^9, 
   3.537780919626597*^9, 3.537781078653276*^9, 3.53778124076876*^9, 
   3.537781376816599*^9, 3.537781525906061*^9, 3.5377817243072095`*^9, 
   3.537782397698993*^9, 3.5377827385751915`*^9, 3.5377829297379265`*^9, 
   3.537783190398784*^9, 3.537783439267022*^9, 3.5377835716488547`*^9, 
   3.537784106589394*^9, 3.537784243417235*^9, 3.544092207910759*^9, 
   3.5440972386271954`*^9, 3.544097364207415*^9, 3.544097951596247*^9, 
   3.544099752916811*^9, 3.5441033713919673`*^9, 3.544103462589727*^9, 
   3.544103703798351*^9, 3.544103916177123*^9, 3.5441040506025605`*^9, 
   3.544105098395*^9, 3.5441057130360794`*^9, 3.544105947785292*^9, 
   3.544107146273997*^9, 3.544591251895172*^9, 3.54459148910574*^9, 
   3.544591651494028*^9, 3.544592903244624*^9, 3.544672171765133*^9, 
   3.544672373224655*^9, 3.5446732724500885`*^9, {3.544673382081359*^9, 
   3.544673401615476*^9}, 3.544949217538623*^9, 3.544951612772632*^9, 
   3.54501566066893*^9, 3.54501572316264*^9, 3.5451061404482465`*^9, 
   3.545114019278618*^9, 3.5528211941113997`*^9, 3.552822658268571*^9, 
   3.55282279430081*^9, 3.552822985464546*^9, 3.5528231946765137`*^9, 
   3.552823664923739*^9, 3.5528239699208746`*^9, 3.552826115393643*^9, 
   3.552826308117382*^9, 3.55420727008871*^9, 3.554208465552009*^9, 
   3.561371696218417*^9, 3.561732585001605*^9, 3.5617791965238037`*^9, 
   3.561781486703426*^9, 3.561781560772356*^9, 3.561781651673716*^9, 
   3.561781901164954*^9, 3.561781932443009*^9, 3.5617821001599035`*^9, 
   3.561782193370067*^9, 3.561782386763607*^9, 3.561782491299391*^9, 
   3.561782524449448*^9, 3.5617842329508495`*^9, 3.5627666248769474`*^9, 
   3.562766742579155*^9, 3.5627670810217485`*^9, 3.562767891880973*^9, 
   3.562769544595676*^9, 3.5627696665254908`*^9, {3.562771127516856*^9, 
   3.5627711458000884`*^9}, 3.562773112933344*^9, 3.562773200808298*^9, 
   3.562821270274009*^9, 3.562822344617697*^9, 3.562823596475095*^9, 
   3.562823659764406*^9, 3.56282406057591*^9, 3.562824597436254*^9, 
   3.562825242169785*^9, 3.5628253104979057`*^9, 3.562825370542411*^9, 
   3.562825957962443*^9, 3.56282613262035*^9, 3.56282624667215*^9, 
   3.56282806468897*^9, 3.562828562579445*^9, 3.562828735271748*^9, 
   3.5628288775127983`*^9, 3.5628304882332277`*^9, 3.56283130397426*^9, 
   3.562831698609154*^9, 3.562831819618566*^9, 3.56283185039742*^9, 
   3.562832307010222*^9, 3.562832420391221*^9, 3.562832728008161*^9, 
   3.562833668612814*^9, 3.56283376308658*^9, 3.562833833629904*^9, 
   3.563425631435789*^9, 3.5634263659006796`*^9, 3.563427212281166*^9, 
   3.563428698169176*^9, 3.563428790100138*^9, 3.563428868895876*^9, 
   3.5634296652002745`*^9, 3.564123611339635*^9, 3.564124344541923*^9, 
   3.5641248610754313`*^9, 3.564125016327903*^9, 3.564130440685831*^9, 
   3.564635024052623*^9, 3.564635496593053*^9, 3.564672127790686*^9, 
   3.5657592859547625`*^9, 3.565773665670033*^9, 3.565892021427097*^9, 
   3.566194850193825*^9, 3.566203969777068*^9, 3.566211902686464*^9, 
   3.566212638047556*^9, 3.5662147323668346`*^9, 3.566399147698532*^9, 
   3.566543710555917*^9, 3.567082812295725*^9, 3.567185134711577*^9, 
   3.567586520197096*^9, 3.567600478274522*^9, 3.567859436914747*^9, 
   3.567860569602537*^9, 3.567861305737631*^9, 3.567861518709205*^9, 
   3.567861617862979*^9, 3.567861714614349*^9, 3.567861808869714*^9, 
   3.56786203438371*^9, 3.567862203488007*^9, 3.5678625352079897`*^9, 
   3.567862682175848*^9, 3.567862769988403*^9, 3.567863319015766*^9, 
   3.567863413707933*^9, 3.567863935294849*^9, 3.5678640875053177`*^9, 
   3.5678642525068073`*^9, 3.567864765763308*^9, 3.567865014552544*^9, 
   3.56786531358947*^9, 3.5678655273732443`*^9, 3.567877452638158*^9, 
   3.5679119462556896`*^9, 3.567913061127247*^9, 3.567916908069582*^9, 
   3.5679176752633295`*^9, 3.5679183595439315`*^9, 3.5679186135591774`*^9, 
   3.567919443449435*^9, 3.567919755496784*^9, 3.56792425659429*^9, 
   3.567926173838657*^9, 3.567926475589987*^9, 3.567926860208663*^9, 
   3.567929472656852*^9, 3.5679295893918576`*^9, 3.5679296708084*^9, 
   3.567929855044724*^9, 3.567930082057322*^9, 3.567930173567083*^9, 
   3.567930335354967*^9, 3.567930621225469*^9, 3.5679310572150354`*^9, 
   3.567931209299702*^9, 3.567931330309115*^9, 3.5679314657017536`*^9, 
   3.567931518711645*^9, 3.567931624511031*^9, 3.567931949007201*^9, 
   3.567932630400798*^9, 3.567932749912608*^9, 3.567933124454666*^9, 
   3.567933231720454*^9, 3.56793346285046*^9, 3.5679347088412495`*^9, 
   3.567935970728465*^9, 3.568115002619152*^9, 3.568115907125342*^9, 
   3.568122251925686*^9, 3.568122353981065*^9, 3.5681234110243216`*^9, 
   3.568895115148609*^9, 3.568895482108054*^9, 3.571649154422757*^9, 
   3.572165386998427*^9, 3.5721751342079477`*^9, 3.572175205422073*^9, 
   3.572176523094987*^9, 3.572177188491556*^9, {3.57217727574251*^9, 
   3.572177289236533*^9}, 3.5747694805366325`*^9, 3.582348619181563*^9, 
   3.582348666044045*^9, {3.582348892930844*^9, 3.582348909076872*^9}, 
   3.5830663187047653`*^9, 3.583067236391977*^9, 3.583562342909281*^9, 
   3.583562486367132*^9, 3.58419665435573*^9, 3.584767089250796*^9, 
   3.5847677728907976`*^9, 3.584768128618221*^9, 3.5847686433109255`*^9, 
   3.584773809560271*^9, 3.584774005605815*^9, 3.584774459177612*^9, 
   3.584774880612352*^9, 3.5847752356845756`*^9, 3.5847754980614376`*^9, 
   3.5847756359656787`*^9, {3.5847777480553894`*^9, 3.5847777572126055`*^9}, 
   3.584882231256865*^9, 3.587025165217253*^9, 3.5876536819916315`*^9, {
   3.587653766935781*^9, 3.5876537757809973`*^9}, 3.588238727232761*^9, 
   3.5891983654321556`*^9, 3.589894495910129*^9, 3.590146888359168*^9, 
   3.5901475205502787`*^9, 3.5901483294740987`*^9, 3.590148590556158*^9, 
   3.5903183280227814`*^9, 3.592139785644528*^9, 3.592140061145914*^9, 
   3.592140124526002*^9, 3.5921403708263474`*^9, 3.592141012747246*^9, 
   3.5921421815488815`*^9, 3.592218077050033*^9, 3.592218376370452*^9, 
   3.592218786061025*^9, 3.5922191925125947`*^9, 3.5922193653128366`*^9, 
   3.598170407544113*^9, 3.5981880835740504`*^9, 3.600328175699327*^9, 
   3.603719760321646*^9, 3.603719895121835*^9, 3.603720026302019*^9, 
   3.603720434762591*^9, 3.603720657572904*^9, 3.603720792554092*^9, 
   3.603720921354272*^9, 3.603721579845194*^9, 3.603721639425277*^9, 
   3.6037225555475607`*^9, 3.607076276765502*^9, 3.615127544019867*^9, 
   3.6151276714900455`*^9, 3.615127771130185*^9, 3.6151278357402754`*^9, 
   3.615128168857133*^9, 3.615129020448325*^9, 3.6151290552583737`*^9, 
   3.61512972406931*^9, 3.619615812606519*^9, 3.619616041050887*^9, 
   3.61961696820737*^9, 3.619617066007507*^9, 3.6196172123817596`*^9, 
   3.619689235196535*^9, 3.6196894513508863`*^9, 3.619689491840943*^9, 
   3.619689955680689*^9, 3.6196901212709208`*^9, 3.620539305908476*^9, 
   3.620803637610657*^9, 3.6208040776312733`*^9, 3.620804146601369*^9, 
   3.639035597487356*^9, 3.648395060135346*^9, 3.648395209865555*^9, 
   3.6800037075602436`*^9, 3.6801017066554046`*^9, 3.838711140828957*^9, 
   3.838711273322178*^9, 3.838805500531928*^9, 3.838882499827796*^9, 
   3.839149890024102*^9, 3.839151421861498*^9, 3.8396719689047823`*^9, 
   3.839672075783148*^9, 3.839687406974235*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"a5ea6e18-6279-4d00-ae80-cf3ddff2bb00"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`SymManipulator`$xTensorVersionExpected", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<1.1.5\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2021", ",", " ", "8", ",", " ", "29"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590148106081707*^9, 3.5901481444109745`*^9}, {
  3.639035569167316*^9, 3.639035573777323*^9}, {3.838710706220667*^9, 
  3.838710713715341*^9}, {3.839672005299018*^9, 3.839672038955842*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"26c8b267-5f14-4173-949c-3dcec496dead"],

Cell[CellGroupData[{

Cell[TextData[{
 "1. ",
 StyleBox["Initialization",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"2312527b-7923-4ce8-a4bd-d6df1bb00792"],

Cell[CellGroupData[{

Cell["1.0. TODO list", "Subsubsection",ExpressionUUID->"2927a46d-3f57-4b09-b558-6f845d243b0d"],

Cell["\<\
*The canonicalization of general groups don\[CloseCurlyQuote]t not move \
symmerizations exactly as we would like. A new algorithm is desperately \
needed to speed it up.
*Allow non-spinor VBundles in the fundamental spinor operators.\
\>", "Text",
 CellChangeTimes->{{3.587654193948731*^9, 3.587654245117822*^9}, {
   3.587654305242327*^9, 3.5876544377509604`*^9}, {3.5901450280081*^9, 
   3.590145028086101*^9}, 3.590306749311869*^9, {3.59031184035249*^9, 
   3.590311841194892*^9}, {3.6078824789710636`*^9, 
   3.6078825230011253`*^9}},ExpressionUUID->"b00f6a80-ae9c-48db-a979-\
eb7efc5e5041"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1. GPL", "Subsubsection",ExpressionUUID->"1669996e-dca4-411a-9b31-35035b40d170"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"SymManipulator", ":", " ", 
    RowBox[{"Symmetrized", " ", "tensor", " ", "expressions"}]}], " ", "*)"}],
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Copyright", " ", 
     RowBox[{"(", "C", ")"}], " ", "2011"}], "-", 
    RowBox[{"2021", " ", "Thomas", " ", "B\[ADoubleDot]ckdahl"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", " ", "it", " ", "under", " ",
       "the", " ", "terms", " ", "of", " ", "the", " ", "GNU", " ", "General",
       " ", "Public", " ", "License", " ", "as", " ", "published", " ", "by", 
      " ", "the", " ", "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], 
     " ", "program", " ", "is", " ", "distributed", " ", "in", " ", "the", 
     " ", "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", 
     "useful"}], ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", " ", 
      "General", " ", "Public", " ", "License", " ", "for", " ", "more", " ", 
      
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], 
      " ", "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ",
       "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", " ", "along", " ", "with", " ", "this", " ", "program"}], 
     ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", " ", 
     "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", " ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744689999872*^9, 3.5157447334903593`*^9}, {
   3.5159382492443514`*^9, 3.515938255219162*^9}, {3.544107100285116*^9, 
   3.5441071015331182`*^9}, 3.567188293812725*^9, 3.5981700797136545`*^9, 
   3.648394981115235*^9, {3.838710724660015*^9, 3.838710724843499*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"c659ab9d-6c43-4099-80e8-5d11195a8274"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Info package", "Subsubsection",ExpressionUUID->"f2f12e51-27a3-43f1-b236-bf44069ea828"],

Cell["\<\
(* :Title: SymManipulator *)

(* :Author: Thomas B\[ADoubleDot]ckdahl *)

(* :Summary: Symmetrized tensor expressions and irreducible decomposition 
    of spinor expressions *)

(* :Brief Discussion:
   - Handles symmetrized tensor expressions. It also handles irreducible \
decompositions of spinor expressions, and fundamental spinor operators. *)
  
(* :Context: xAct`SymManipulator` *)

(* :Package Version: 0.9.6 *)

(* :Copyright: Thomas B\[ADoubleDot]ckdahl (2011-2024) *)

(* :History: See SymManipulator.History *)

(* :Keywords: *)

(* :Source: SymManipulator.nb *)

(* :Warning: *)

(* :Mathematica Version: 9.0 and later *)

(* :Limitations:
\t- Only abstract indices can be used. *)
\t
(* :Acknowledgements:
\tThis work was partly funded by scholarships from the Albert Einstein 
\tInstitut and the Wenner-Gren foundarions. Furthermore the autor would like \
to 
\tthank J. M. Mart\[IAcute]n-Garc\[IAcute]a, A. Garc\[IAcute]a-Parrado, Teake \
Nutma, Leonard Soicher 
\tand Peter Cameron for helpful comments. *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellChangeTimes->{{3.52748768805377*^9, 3.527487716711021*^9}, 
   3.529235942500916*^9, {3.529237855818076*^9, 3.5292378954733458`*^9}, 
   3.534068072144915*^9, {3.537679017041196*^9, 3.537679018772799*^9}, 
   3.5441071118759375`*^9, {3.56718831328156*^9, 3.567188332438393*^9}, {
   3.56718841025133*^9, 3.5671884486117983`*^9}, {3.590311852192911*^9, 
   3.590311924421038*^9}, 3.598170095603677*^9, {3.619614455557426*^9, 
   3.619614455627426*^9}, {3.648394989505246*^9, 3.64839499870526*^9}, {
   3.8387107340828185`*^9, 3.838710736403028*^9}, 3.838803876668059*^9, {
   3.9234487703083115`*^9, 
   3.923448772682949*^9}},ExpressionUUID->"29b8b48e-c556-40fc-ac00-\
b5e8b6507b49"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. BeginPackage", "Subsubsection",ExpressionUUID->"d3bd8629-0d1b-495b-8d55-3275042b96f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "=", 
     "\"\<xAct`SymManipulator`\>\""}]}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4232371765761347`*^9, 3.423237197531545*^9}, {
   3.515744613533498*^9, 3.51574461619365*^9}, 3.515938295217633*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"8a4ff063-817c-442c-ba12-bfe7f212d56d"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellChangeTimes->{{3.423237204071299*^9, 3.423237206170257*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"d9aa9e3d-f50c-4ff0-94c5-c3086849e497"],

Cell[BoxData["\<\"xAct`SymManipulator`\"\>"], "Output",
 CellChangeTimes->{
  3.520174845160857*^9, 3.520175592900562*^9, 3.5201759648448105`*^9, 
   3.520176092940634*^9, 3.520176267207738*^9, 3.520176752659986*^9, 
   3.520177920150825*^9, 3.52017797011651*^9, 3.520178030430215*^9, 
   3.520178119981769*^9, 3.520178320811716*^9, 3.520179007015315*^9, 
   3.520179107107889*^9, 3.520179190361234*^9, 3.52017923490691*^9, 
   3.5201792813733892`*^9, 3.520179460557699*^9, 3.5201795483758516`*^9, 
   3.520181356863796*^9, 3.52018163333988*^9, 3.5202685586746883`*^9, 
   3.520268726676527*^9, 3.520268859179117*^9, 3.5202688961659703`*^9, 
   3.520269087528241*^9, 3.520271811250497*^9, 3.5203105954979362`*^9, 
   3.52031097592649*^9, 3.520311777890422*^9, 3.5203120961482997`*^9, 
   3.527144937377472*^9, 3.5271458071901994`*^9, 3.52714600070954*^9, 
   3.527147021780133*^9, 3.527147592445735*^9, 3.5271480456587315`*^9, 
   3.527148262967113*^9, 3.527148685253458*^9, 3.527150049508054*^9, 
   3.527150171796669*^9, 3.527150352335786*^9, 3.527150506323656*^9, 
   3.527150790727756*^9, 3.527150864110285*^9, 3.5292308222081213`*^9, 
   3.529232465764608*^9, 3.5292325705031924`*^9, 3.529235908227656*^9, 
   3.529236216281396*^9, 3.529236415883747*^9, 3.529236653300564*^9, 
   3.5292367148426733`*^9, 3.529236965959314*^9, 3.529237056423872*^9, 
   3.5340685681321864`*^9, 3.5340689505200577`*^9, 3.534069381502015*^9, 
   3.534069950669015*^9, 3.5340701757150097`*^9, 3.5342496350817585`*^9, 
   3.537621497502195*^9, 3.537621624018417*^9, 3.537622840805954*^9, {
   3.537622948352543*^9, 3.5376229631725693`*^9}, 3.537623181791353*^9, 
   3.537623360286867*^9, 3.5376254388989177`*^9, 3.537628788133472*^9, 
   3.537694698563867*^9, 3.537694866498163*^9, 3.537695500561277*^9, 
   3.5376955803398166`*^9, 3.5376959120129995`*^9, 3.537696394053846*^9, 
   3.5376971037156925`*^9, 3.537697459162317*^9, {3.537697970531215*^9, 
   3.5376979900156493`*^9}, 3.5377005693437843`*^9, 3.537700987377718*^9, 
   3.537701148650802*^9, 3.5377050742758965`*^9, 3.537767648531886*^9, 
   3.537780184770705*^9, 3.537780582665005*^9, 3.537780919688997*^9, 
   3.537781078715676*^9, 3.537781240831161*^9, 3.537781376878999*^9, 
   3.537781525968461*^9, 3.53778172436961*^9, 3.5377823977769933`*^9, 
   3.537782738653191*^9, 3.537782929815927*^9, 3.5377831904611845`*^9, 
   3.537783439329422*^9, 3.537783571711254*^9, 3.537784106636194*^9, 
   3.537784243479635*^9, 3.5440922080043592`*^9, 3.5440972386895957`*^9, 
   3.5440973642698154`*^9, 3.544097951643048*^9, 3.544099752979211*^9, 
   3.544103371469967*^9, 3.544103462652127*^9, 3.5441037038763514`*^9, 
   3.544103916239524*^9, 3.54410405068056*^9, 3.544105098473*^9, 
   3.5441057130828795`*^9, 3.5441059478632917`*^9, 3.544107146336397*^9, 
   3.544591251956176*^9, 3.544591489160743*^9, 3.544591651567032*^9, 
   3.5445929033066273`*^9, 3.544672171844137*^9, 3.544672373283659*^9, 
   3.544673272506092*^9, {3.5446733821213617`*^9, 3.54467340168248*^9}, 
   3.544949217601023*^9, 3.544951612835032*^9, 3.545015660731331*^9, 
   3.54501572325624*^9, 3.545106140510647*^9, 3.545114019341018*^9, 
   3.5528211941893992`*^9, 3.552822658330971*^9, 3.55282279436321*^9, 
   3.552822985526946*^9, 3.5528231947233133`*^9, 3.5528236649861393`*^9, 
   3.5528239699832745`*^9, 3.552826115456043*^9, 3.552826308164181*^9, 
   3.55420727016671*^9, 3.554208465614409*^9, 3.561371696265218*^9, 
   3.561732585064005*^9, 3.5617791965862036`*^9, 3.561781486765826*^9, 
   3.561781560819157*^9, 3.561781651736116*^9, 3.561781901211754*^9, 
   3.5617819325054092`*^9, 3.561782100222304*^9, 3.561782193448067*^9, 
   3.561782386826007*^9, 3.561782491377391*^9, 3.561782524527449*^9, 
   3.56178423302885*^9, 3.5627666249393477`*^9, 3.5627667426415553`*^9, 
   3.562767081084149*^9, 3.562767891958973*^9, 3.562769544689276*^9, 
   3.5627696665878906`*^9, {3.5627711275480566`*^9, 3.562771145862489*^9}, 
   3.5627731129957438`*^9, 3.562773200855098*^9, 3.5628212703208094`*^9, 
   3.5628223446644964`*^9, 3.562823596553095*^9, 3.562823659826806*^9, 
   3.56282406062271*^9, 3.562824597498654*^9, 3.5628252422477856`*^9, 
   3.562825310575906*^9, 3.562825370604811*^9, 3.562825958024843*^9, 
   3.56282613269835*^9, 3.56282624673455*^9, 3.5628280647357707`*^9, 
   3.562828562657445*^9, 3.562828735318548*^9, 3.5628288775907984`*^9, 
   3.562830488311228*^9, 3.5628313040522604`*^9, 3.562831698655954*^9, 
   3.562831819649766*^9, 3.5628318504598203`*^9, 3.562832307057022*^9, 
   3.562832420438021*^9, 3.5628327280549617`*^9, 3.5628336686596136`*^9, 
   3.56283376313338*^9, 3.562833833692304*^9, 3.5634256314825897`*^9, 
   3.5634263659630795`*^9, 3.563427212343566*^9, 3.563428698247176*^9, 
   3.563428790162538*^9, 3.563428868958276*^9, 3.5634296652782745`*^9, 
   3.564123611433235*^9, 3.564124344588723*^9, 3.5641248611378317`*^9, 
   3.5641250163747034`*^9, 3.564130440748231*^9, 3.5646350240994225`*^9, 
   3.564635496671053*^9, 3.564672127884287*^9, 3.565759286001563*^9, 
   3.565773665716832*^9, 3.5658920215050964`*^9, 3.566194850240625*^9, 
   3.5662039698550687`*^9, 3.5662119027332635`*^9, 3.566212638094356*^9, 
   3.5662147324292345`*^9, 3.5663991477453327`*^9, 3.566543710602717*^9, 
   3.567082812342525*^9, 3.5671851347583766`*^9, 3.5675865202438955`*^9, 
   3.567600478352522*^9, 3.567859436945947*^9, 3.5678605696337376`*^9, 
   3.5678613057688303`*^9, 3.5678615187248044`*^9, 3.567861617894179*^9, 
   3.567861714645549*^9, 3.567861808885314*^9, 3.5678620344149103`*^9, 
   3.5678622035036073`*^9, 3.56786253522359*^9, 3.567862682207048*^9, 
   3.567862770019603*^9, 3.5678633190469666`*^9, 3.5678634137235327`*^9, 
   3.567863935326049*^9, 3.567864087536516*^9, 3.5678642525380073`*^9, 
   3.567864765778908*^9, 3.567865014568145*^9, 3.5678653136206703`*^9, 
   3.567865527388845*^9, 3.567877452669359*^9, 3.567911946286889*^9, 
   3.5679130611584477`*^9, 3.567916908100782*^9, 3.56791767527893*^9, 
   3.567918359559532*^9, 3.567918613590378*^9, 3.5679194434650354`*^9, 
   3.5679197555123844`*^9, 3.567924256625489*^9, 3.567926173869857*^9, 
   3.567926475605587*^9, 3.567926860239863*^9, 3.567929472688052*^9, 
   3.567929589423057*^9, 3.5679296708395996`*^9, 3.567929855075923*^9, 
   3.567930082088522*^9, 3.567930173598283*^9, 3.567930335386167*^9, 
   3.56793062124107*^9, 3.567931057230636*^9, 3.567931209330902*^9, 
   3.567931330324715*^9, 3.567931465732952*^9, 3.567931518742846*^9, 
   3.567931624526632*^9, 3.567931949038401*^9, 3.5679326304319987`*^9, 
   3.567932749928209*^9, 3.5679331244702663`*^9, 3.5679332317360554`*^9, 
   3.567933462866061*^9, 3.567934708872449*^9, 3.5679359707596655`*^9, 
   3.5681150026503534`*^9, 3.568115907156541*^9, 3.568122251941286*^9, 
   3.568122354012265*^9, 3.5681234110555215`*^9, 3.56889511544501*^9, 
   3.568895482123654*^9, 3.571649154453957*^9, 3.572165387029627*^9, 
   3.572175134239147*^9, 3.5721752054376726`*^9, 3.5721765231573873`*^9, 
   3.572177188522757*^9, 3.5721772892677336`*^9, 3.574769480567833*^9, 
   3.582348619212763*^9, 3.582348666059645*^9, {3.582348892962044*^9, 
   3.582348909108072*^9}, 3.583067236438777*^9, 3.58356234294048*^9, 
   3.583562486398333*^9, 3.58419665437133*^9, 3.584767089281996*^9, 
   3.584767772906397*^9, 3.5847681286494217`*^9, 3.584768643342126*^9, 
   3.584773809591471*^9, 3.584774005621415*^9, 3.584774459364812*^9, 
   3.584774880627952*^9, 3.5847752357001753`*^9, 3.584775498077037*^9, 
   3.584775635996878*^9, {3.58477774807099*^9, 3.584777757306205*^9}, 
   3.584882231288066*^9, 3.587025165248452*^9, 3.587653682022832*^9, {
   3.587653766966981*^9, 3.5876537758121977`*^9}, 3.588238727263961*^9, 
   3.5891983654633555`*^9, 3.590146888405969*^9, 3.590147520565879*^9, 
   3.590148329489699*^9, 3.5901485906185584`*^9, 3.590318328069581*^9, 
   3.592139785674528*^9, 3.592140061175914*^9, 3.592140124546002*^9, 
   3.5921403708463473`*^9, 3.592141012777246*^9, 3.5921421816088815`*^9, 
   3.592218077090033*^9, 3.592218376500452*^9, 3.592218786091025*^9, 
   3.5922191925325947`*^9, 3.5922193653428364`*^9, 3.598170407584113*^9, 
   3.59818808360405*^9, 3.600328175739327*^9, 3.603719760361646*^9, 
   3.603719895151835*^9, 3.603720026332019*^9, 3.603720434782591*^9, 
   3.603720657602904*^9, 3.603720792584091*^9, 3.6037209213842716`*^9, 
   3.6037215798651943`*^9, 3.603721639455277*^9, 3.6037225555775604`*^9, 
   3.607076276815502*^9, 3.615127544049867*^9, 3.6151276715300455`*^9, 
   3.615127771200185*^9, 3.6151278357802753`*^9, 3.615128168877133*^9, 
   3.6151290204683247`*^9, 3.615129055288374*^9, 3.6151297240893097`*^9, 
   3.619615812636519*^9, 3.619616041070887*^9, 3.6196169682273707`*^9, 
   3.619617066027507*^9, 3.61961721240176*^9, 3.619689235236535*^9, 
   3.6196894513908863`*^9, 3.619689491870943*^9, 3.619689955710688*^9, 
   3.6196901213109207`*^9, 3.6205393059284773`*^9, 3.6208036376306562`*^9, 
   3.6208040776512733`*^9, 3.62080414662137*^9, 3.648395060155345*^9, 
   3.648395209895555*^9, 3.6800037076202416`*^9, 3.6801017066754045`*^9, 
   3.838711140885804*^9, 3.838711273383015*^9, 3.8388055006246567`*^9, 
   3.838882499961438*^9, 3.83914989010087*^9, 3.8391514219402876`*^9, 
   3.839671968977588*^9, 3.839672075880887*^9, 3.839687407057041*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"9b187cc8-3b0f-4bd9-8738-7ee527568bff"]
}, Open  ]],

Cell[TextData[{
 "Explicit (not hidden) import of ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", ",
 StyleBox["xPerm",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " and ",
 StyleBox["xCore",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ":"
}], "Text",ExpressionUUID->"463cd075-2ea5-49a1-bab7-fd15b8d86ce5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`SymManipulator`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", ",", 
     "\"\<xAct`xCore`\>\""}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744641041072*^9, 3.515744644398264*^9}, 
   3.5159383064496517`*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"6a90753f-2099-4b08-b3ca-fb25b77dd8e4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.615129055348374*^9, 3.615129724159311*^9, 
  3.6196158127165194`*^9, 3.6196160411408873`*^9, 3.61961696829737*^9, 
  3.619617066097507*^9, 3.61961721247176*^9, 3.6196892353165355`*^9, 
  3.619689451460886*^9, 3.619689491950943*^9, 3.619689955790688*^9, 
  3.6196901213809204`*^9, 3.620539305998476*^9, 3.620803637720657*^9, 
  3.620804077721273*^9, 3.62080414670137*^9, 3.648395060255346*^9, 
  3.648395210005555*^9, 3.6800037077202406`*^9, 3.680101706785404*^9, 
  3.838711140980552*^9, 3.8387112735086794`*^9, 3.83880550070846*^9, 
  3.838882500064163*^9, 3.839149890228555*^9, 3.839151422031047*^9, 
  3.839671969102282*^9, 3.839672075977627*^9, 3.839687407147804*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"d178107c-57ac-451f-a894-85d57a375894"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.615129055348374*^9, 3.615129724159311*^9, 
  3.6196158127165194`*^9, 3.6196160411408873`*^9, 3.61961696829737*^9, 
  3.619617066097507*^9, 3.61961721247176*^9, 3.6196892353165355`*^9, 
  3.619689451460886*^9, 3.619689491950943*^9, 3.619689955790688*^9, 
  3.6196901213809204`*^9, 3.620539305998476*^9, 3.620803637720657*^9, 
  3.620804077721273*^9, 3.62080414670137*^9, 3.648395060255346*^9, 
  3.648395210005555*^9, 3.6800037077202406`*^9, 3.680101706785404*^9, 
  3.838711140980552*^9, 3.8387112735086794`*^9, 3.83880550070846*^9, 
  3.838882500064163*^9, 3.839149890228555*^9, 3.839151422031047*^9, 
  3.839671969102282*^9, 3.839672075977627*^9, 3.8396874071498*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"da6f7d72-292b-424c-9d8c-acda15698e1d"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{3.615129055348374*^9, 3.615129724159311*^9, 
  3.6196158127165194`*^9, 3.6196160411408873`*^9, 3.61961696829737*^9, 
  3.619617066097507*^9, 3.61961721247176*^9, 3.6196892353165355`*^9, 
  3.619689451460886*^9, 3.619689491950943*^9, 3.619689955790688*^9, 
  3.6196901213809204`*^9, 3.620539305998476*^9, 3.620803637720657*^9, 
  3.620804077721273*^9, 3.62080414670137*^9, 3.648395060255346*^9, 
  3.648395210005555*^9, 3.6800037077202406`*^9, 3.680101706785404*^9, 
  3.838711140980552*^9, 3.8387112735086794`*^9, 3.83880550070846*^9, 
  3.838882500064163*^9, 3.839149890228555*^9, 3.839151422031047*^9, 
  3.839671969102282*^9, 3.839672075977627*^9, 3.8396874071567764`*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"005b09f2-db02-4ad4-b146-3832144f2264"],

Cell[BoxData["\<\"Connecting to external MinGW executable...\"\>"], "Print",
 CellChangeTimes->{3.615129055348374*^9, 3.615129724159311*^9, 
  3.6196158127165194`*^9, 3.6196160411408873`*^9, 3.61961696829737*^9, 
  3.619617066097507*^9, 3.61961721247176*^9, 3.6196892353165355`*^9, 
  3.619689451460886*^9, 3.619689491950943*^9, 3.619689955790688*^9, 
  3.6196901213809204`*^9, 3.620539305998476*^9, 3.620803637720657*^9, 
  3.620804077721273*^9, 3.62080414670137*^9, 3.648395060255346*^9, 
  3.648395210005555*^9, 3.6800037077202406`*^9, 3.680101706785404*^9, 
  3.838711140980552*^9, 3.8387112735086794`*^9, 3.83880550070846*^9, 
  3.838882500064163*^9, 3.839149890228555*^9, 3.839151422031047*^9, 
  3.839671969102282*^9, 3.839672075977627*^9, 3.839687407225564*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"6446452a-a1e4-4833-8934-8d1e52915ec6"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{3.615129055348374*^9, 3.615129724159311*^9, 
  3.6196158127165194`*^9, 3.6196160411408873`*^9, 3.61961696829737*^9, 
  3.619617066097507*^9, 3.61961721247176*^9, 3.6196892353165355`*^9, 
  3.619689451460886*^9, 3.619689491950943*^9, 3.619689955790688*^9, 
  3.6196901213809204`*^9, 3.620539305998476*^9, 3.620803637720657*^9, 
  3.620804077721273*^9, 3.62080414670137*^9, 3.648395060255346*^9, 
  3.648395210005555*^9, 3.6800037077202406`*^9, 3.680101706785404*^9, 
  3.838711140980552*^9, 3.8387112735086794`*^9, 3.83880550070846*^9, 
  3.838882500064163*^9, 3.839149890228555*^9, 3.839151422031047*^9, 
  3.839671969102282*^9, 3.839672075977627*^9, 3.839687407345244*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"12ff7448-1f1a-4271-8601-fadb75052eea"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.615129055348374*^9, 3.615129724159311*^9, 
  3.6196158127165194`*^9, 3.6196160411408873`*^9, 3.61961696829737*^9, 
  3.619617066097507*^9, 3.61961721247176*^9, 3.6196892353165355`*^9, 
  3.619689451460886*^9, 3.619689491950943*^9, 3.619689955790688*^9, 
  3.6196901213809204`*^9, 3.620539305998476*^9, 3.620803637720657*^9, 
  3.620804077721273*^9, 3.62080414670137*^9, 3.648395060255346*^9, 
  3.648395210005555*^9, 3.6800037077202406`*^9, 3.680101706785404*^9, 
  3.838711140980552*^9, 3.8387112735086794`*^9, 3.83880550070846*^9, 
  3.838882500064163*^9, 3.839149890228555*^9, 3.839151422031047*^9, 
  3.839671969102282*^9, 3.839672075977627*^9, 3.839687407348235*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"db3ffee2-27e6-4cbc-99c0-49dce83d0ca8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "8", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.5", ", ", {2021, 8, 29}],
  Editable->False]], "Print",
 CellChangeTimes->{3.615129055348374*^9, 3.615129724159311*^9, 
  3.6196158127165194`*^9, 3.6196160411408873`*^9, 3.61961696829737*^9, 
  3.619617066097507*^9, 3.61961721247176*^9, 3.6196892353165355`*^9, 
  3.619689451460886*^9, 3.619689491950943*^9, 3.619689955790688*^9, 
  3.6196901213809204`*^9, 3.620539305998476*^9, 3.620803637720657*^9, 
  3.620804077721273*^9, 3.62080414670137*^9, 3.648395060255346*^9, 
  3.648395210005555*^9, 3.6800037077202406`*^9, 3.680101706785404*^9, 
  3.838711140980552*^9, 3.8387112735086794`*^9, 3.83880550070846*^9, 
  3.838882500064163*^9, 3.839149890228555*^9, 3.839151422031047*^9, 
  3.839671969102282*^9, 3.839672075977627*^9, 3.839687407353223*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"908d79d9-25e8-4186-8b36-7dbc0fea1783"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{3.615129055348374*^9, 3.615129724159311*^9, 
  3.6196158127165194`*^9, 3.6196160411408873`*^9, 3.61961696829737*^9, 
  3.619617066097507*^9, 3.61961721247176*^9, 3.6196892353165355`*^9, 
  3.619689451460886*^9, 3.619689491950943*^9, 3.619689955790688*^9, 
  3.6196901213809204`*^9, 3.620539305998476*^9, 3.620803637720657*^9, 
  3.620804077721273*^9, 3.62080414670137*^9, 3.648395060255346*^9, 
  3.648395210005555*^9, 3.6800037077202406`*^9, 3.680101706785404*^9, 
  3.838711140980552*^9, 3.8387112735086794`*^9, 3.83880550070846*^9, 
  3.838882500064163*^9, 3.839149890228555*^9, 3.839151422031047*^9, 
  3.839671969102282*^9, 3.839672075977627*^9, 3.839687407356213*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"fb11bf62-305b-408a-96b1-e37c56b3ccad"]
}, Open  ]],

Cell[BoxData["\<\"xAct`SymManipulator`\"\>"], "Output",
 CellChangeTimes->{
  3.582348910278074*^9, 3.583067236828778*^9, 3.583562343424081*^9, 
   3.583562486866333*^9, 3.584196654870531*^9, 3.584767089749997*^9, 
   3.584767773327597*^9, 3.584768129070622*^9, 3.584768643700926*^9, 
   3.584773809981471*^9, 3.584774006011416*^9, 3.584774459848413*^9, 
   3.584774881002354*^9, 3.5847752361369767`*^9, 3.584775498451437*^9, 
   3.5847756364492793`*^9, {3.584777748102188*^9, 3.584777757836606*^9}, 
   3.584882231662466*^9, 3.587025165654053*^9, 3.587653682444033*^9, {
   3.5876537669981813`*^9, 3.587653776217798*^9}, 3.5882387276695614`*^9, 
   3.5891983659781566`*^9, 3.5901468888895693`*^9, 3.5901475209870796`*^9, 
   3.5901483299109*^9, 3.590148591024159*^9, 3.590318328429383*^9, 
   3.592139786074529*^9, 3.5921400615859146`*^9, 3.592140125066003*^9, 
   3.592140371246348*^9, 3.592141013177246*^9, 3.5921421820188823`*^9, 
   3.592218077480034*^9, 3.592218376870453*^9, 3.592218786471026*^9, 
   3.5922191929025955`*^9, 3.592219365742837*^9, 3.5981704079741135`*^9, 
   3.598188084014051*^9, 3.600328176089327*^9, 3.603719760701647*^9, 
   3.603719895481836*^9, 3.60372002666202*^9, 3.603720435122591*^9, 
   3.603720657922903*^9, 3.6037207929240937`*^9, 3.603720921714273*^9, 
   3.6037215802151947`*^9, 3.603721639805278*^9, 3.60372255592756*^9, 
   3.607076277145502*^9, 3.615127544299867*^9, 3.615127671790046*^9, 
   3.615127771460185*^9, 3.6151278360302753`*^9, 3.615128169197133*^9, 
   3.615129020478325*^9, 3.615129055518374*^9, 3.615129724329311*^9, 
   3.619615812956519*^9, 3.619616041340887*^9, 3.619616968487371*^9, 
   3.6196170662675076`*^9, 3.6196172126417603`*^9, 3.6196892355065355`*^9, 
   3.619689451630886*^9, 3.619689492120943*^9, 3.619689955970689*^9, 
   3.619690121570921*^9, 3.6205393061784773`*^9, 3.620803637950657*^9, 
   3.620804077901273*^9, 3.62080414689137*^9, 3.648395060485346*^9, 
   3.648395210225556*^9, 3.680003707970238*^9, 3.680101707435405*^9, 
   3.838711141254405*^9, 3.8387112737849407`*^9, 3.8388055009906774`*^9, 
   3.838882500326462*^9, 3.8391498905297527`*^9, 3.839151422312266*^9, 
   3.83967196943736*^9, 3.839672076300764*^9, 3.8396874074669185`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"8a6f64c6-80ce-414f-bc2d-00d01c75b9de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "xAct`xCore`Private`bars", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`SymManipulator`  version \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<CopyRight (C) 2011-2021, Thomas B\[ADoubleDot]ckdahl, under the \
General Public License.\>\"", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5157446619242663`*^9, 3.5157446758810644`*^9}, {
   3.515744748063194*^9, 3.515744750743346*^9}, {3.515938308727256*^9, 
   3.515938317666072*^9}, {3.567188468470632*^9, 3.567188472292639*^9}, 
   3.6001544325270452`*^9, 3.648395024475295*^9, 3.6800037193901243`*^9, {
   3.8387112447847986`*^9, 3.8387112449573383`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"69899cce-9447-4af4-8560-fa077145c3f9"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.520174849509264*^9, 3.520175596098965*^9, 3.520175968590816*^9, 
   3.520176096258639*^9, 3.5201762704681425`*^9, 3.520176756057991*^9, 
   3.5201779236516304`*^9, 3.520177973427715*^9, 3.52017803394102*^9, 
   3.520178123221773*^9, 3.520178324027721*^9, 3.52017901033572*^9, 
   3.520179110845495*^9, 3.5201791936240377`*^9, 3.5201792382921166`*^9, 
   3.520179284833394*^9, 3.520179463876904*^9, 3.520179551655855*^9, 
   3.520181360161802*^9, 3.520181636615485*^9, 3.520268562511894*^9, 
   3.520268730947734*^9, 3.520268862571923*^9, 3.520268899680375*^9, 
   3.520269091998247*^9, 3.520271814190901*^9, 3.520310605197149*^9, 
   3.5203109866249046`*^9, 3.520311787180435*^9, 3.520312104904713*^9, {
   3.5271449361606693`*^9, 3.527144937439872*^9}, 3.527145808391402*^9, 
   3.5271460019419417`*^9, 3.527147022965735*^9, 3.5271475939589376`*^9, 
   3.527148046875534*^9, 3.527148264183915*^9, 3.52714868648586*^9, 
   3.5271500507716575`*^9, 3.527150172997871*^9, 3.527150353614989*^9, 
   3.527150507556059*^9, 3.527150791991359*^9, 3.5271508653426876`*^9, 
   3.529230823877325*^9, 3.529232467059411*^9, 3.529232571751195*^9, 
   3.5292359095068574`*^9, 3.529236217513799*^9, 3.529236417194149*^9, 
   3.5292366545797663`*^9, 3.529236716075074*^9, 3.529236967176115*^9, 
   3.529237057671874*^9, 3.5340685699417887`*^9, 3.53406895170566*^9, 
   3.534069382718817*^9, 3.534069951854617*^9, 3.534070176931813*^9, 
   3.534249637172163*^9, 3.537621498672197*^9, 3.5376216251884193`*^9, 
   3.537622841944757*^9, {3.537622948446143*^9, 3.537622964373771*^9}, 
   3.5376231829301553`*^9, 3.537623361519269*^9, 3.5376254399285183`*^9, 
   3.537628789615475*^9, 3.53769469982747*^9, 3.5376948677461658`*^9, 
   3.537695501762479*^9, 3.537695581556619*^9, 3.537695913229801*^9, 
   3.537696395239448*^9, 3.537697105010495*^9, 3.5376974604259186`*^9, {
   3.537697970624815*^9, 3.537697991232452*^9}, 3.537700570638586*^9, 
   3.5377009886725206`*^9, 3.5377011498208036`*^9, 3.537705075508299*^9, 
   3.537767649951489*^9, 3.537780185987508*^9, 3.537780583897407*^9, 
   3.5377809208901987`*^9, 3.537781079916878*^9, 3.5377812420011635`*^9, 
   3.537781378142602*^9, 3.537781527200863*^9, 3.537781725586412*^9, 
   3.537782399040595*^9, 3.5377827398387933`*^9, 3.5377829310015287`*^9, 
   3.537783191740387*^9, 3.537783440546224*^9, 3.5377835728656573`*^9, 
   3.537784107868596*^9, 3.5377842446964374`*^9, 3.544092209221161*^9, 
   3.544097239984397*^9, 3.5440973654710183`*^9, 3.544097952797449*^9, 
   3.544099754133613*^9, 3.5441033727023697`*^9, 3.544103463868929*^9, 
   3.544103705030752*^9, 3.544103917456326*^9, 3.544104051850562*^9, 
   3.544105099611802*^9, 3.5441057142684813`*^9, 3.544105949064494*^9, 
   3.544107147443999*^9, 3.544591253200247*^9, 3.5445914903948135`*^9, 
   3.5445916527811027`*^9, 3.544592904605701*^9, 3.544672173055206*^9, 
   3.5446723745247293`*^9, 3.544673273684159*^9, {3.5446733821943655`*^9, 
   3.544673402912551*^9}, 3.5449492188490252`*^9, 3.544951614114234*^9, 
   3.545015662681334*^9, 3.5450157245042424`*^9, 3.5451061422266498`*^9, 
   3.5451140205734205`*^9, 3.5528211954218006`*^9, 3.552822659532173*^9, 
   3.5528227955020127`*^9, 3.552822986681348*^9, 3.552823195877715*^9, 
   3.5528236662185407`*^9, 3.552823971168877*^9, 3.552826116626045*^9, 
   3.552826309287384*^9, 3.554207271336712*^9, 3.554208466846811*^9, 
   3.56137169743522*^9, 3.561732586327607*^9, 3.561779198364607*^9, 
   3.561781487967029*^9, 3.561781561957958*^9, 3.561781652921718*^9, 
   3.561781901274155*^9, 3.561781933675411*^9, 3.5617821014079056`*^9, 
   3.5617821946492686`*^9, 3.561782388074009*^9, 3.561782492562993*^9, 
   3.5617825257130513`*^9, 3.561784234167652*^9, 3.562766627014151*^9, 
   3.562766743842757*^9, 3.5627670822697515`*^9, 3.562767893144575*^9, 
   3.562769545796878*^9, 3.562769667711093*^9, {3.5627711276260576`*^9, 
   3.562771147063691*^9}, 3.562773114181346*^9, 3.5627732020563*^9, 
   3.562821271771612*^9, 3.562822345818898*^9, 3.562823597723097*^9, 
   3.5628236609812083`*^9, 3.562824061823913*^9, 3.562824598637455*^9, 
   3.5628252433865876`*^9, 3.562825311761508*^9, 3.562825371806013*^9, 
   3.562825959194845*^9, 3.5628261338527513`*^9, 3.562826247904552*^9, 
   3.5628280657185726`*^9, 3.5628285638898473`*^9, 3.562828736504151*^9, 
   3.5628288786984005`*^9, 3.56283048949683*^9, 3.5628313051442623`*^9, 
   3.5628316998415556`*^9, 3.5628318197277665`*^9, 3.562831851645423*^9, 
   3.5628323081802244`*^9, 3.5628324215456233`*^9, 3.562832729178163*^9, 
   3.562833669814016*^9, 3.5628337642409816`*^9, 3.562833834846705*^9, 
   3.563425632980192*^9, 3.5634263671330814`*^9, 3.563427213529168*^9, 
   3.563428699385978*^9, 3.56342879144174*^9, 3.563428870143878*^9, 
   3.563429666479477*^9, 3.564123612696838*^9, 3.5641243458523264`*^9, 
   3.564124862401434*^9, 3.564125017622706*^9, 3.564130442089834*^9, 
   3.5646350262366266`*^9, 3.564635497825455*^9, 3.56467212978749*^9, 
   3.565759287764366*^9, 3.565773666964835*^9, 3.5658920235955*^9, 
   3.566194852674229*^9, 3.566203971352671*^9, 3.566211903794065*^9, 
   3.5662126406527605`*^9, 3.566214734004837*^9, 3.566399150303737*^9, 
   3.56654371253712*^9, 3.567082814807329*^9, 3.5671851370203805`*^9, 
   3.5675865229115*^9, 3.567600479600524*^9, 3.5678594381939497`*^9, 
   3.567860570772539*^9, 3.567861306845233*^9, 3.567861519957207*^9, 
   3.567861619048581*^9, 3.567861715815551*^9, 3.5678618101177173`*^9, 
   3.5678620356317124`*^9, 3.5678622047516093`*^9, 3.567862536440392*^9, 
   3.5678626834706507`*^9, 3.5678627712988043`*^9, 3.567863320294968*^9, 
   3.5678634149403353`*^9, 3.567863936574051*^9, 3.567864088753319*^9, 
   3.567864253786009*^9, 3.56786476698011*^9, 3.567865015816147*^9, 
   3.567865314837472*^9, 3.5678655286212473`*^9, 3.56787745385496*^9, 
   3.5679119479404926`*^9, 3.56791306243765*^9, 3.567916910019585*^9, 
   3.5679176765113325`*^9, 3.567918361150734*^9, 3.5679186147915792`*^9, 
   3.567919444681837*^9, 3.567919756744786*^9, 3.5679242578890924`*^9, 
   3.56792617508666*^9, 3.5679264768847895`*^9, 3.567926861456665*^9, 
   3.567929473936054*^9, 3.567929590686659*^9, 3.567929672134403*^9, 
   3.567929856308326*^9, 3.567930083367725*^9, 3.567930174908685*^9, 
   3.5679303366497693`*^9, 3.567930622504671*^9, 3.567931058541037*^9, 
   3.5679312105477047`*^9, 3.567931331603917*^9, 3.5679314669965553`*^9, 
   3.5679315200376487`*^9, 3.5679316258214345`*^9, 3.567931950286405*^9, 
   3.5679326316332*^9, 3.56793275120741*^9, 3.567933125749468*^9, 
   3.5679332329996576`*^9, 3.567933464176462*^9, 3.5679347101828523`*^9, 
   3.5679359720232677`*^9, 3.568115004553556*^9, 3.568115908404544*^9, 
   3.568122253158088*^9, 3.5681223552758675`*^9, 3.568123412287924*^9, 
   3.568895116739812*^9, 3.5688954833872557`*^9, 3.57164915616996*^9, 
   3.572165389806432*^9, 3.5721751355183487`*^9, 3.572175206670075*^9, 
   3.5721765243429894`*^9, 3.572177189786359*^9, 3.572177290562536*^9, 
   3.5747694831574373`*^9, 3.582348620413965*^9, 3.582348667323248*^9, 
   3.582348910340474*^9, 3.5830672368599787`*^9, 3.583562343502081*^9, 
   3.583562486897534*^9, 3.584196654901731*^9, 3.584767089781197*^9, 
   3.584767773343198*^9, 3.584768129101822*^9, 3.584768643732126*^9, 
   3.584773810012672*^9, 3.5847740060270166`*^9, 3.5847744598640137`*^9, 
   3.584774881033553*^9, 3.584775236168177*^9, 3.584775498482638*^9, 
   3.5847756364804797`*^9, {3.5847777481333895`*^9, 3.584777757867806*^9}, 
   3.5848822316936665`*^9, 3.587025165700854*^9, 3.5876536824752326`*^9, {
   3.5876537670137815`*^9, 3.587653776248998*^9}, 3.588238727700762*^9, 
   3.5891983660249577`*^9, 3.5901468889207697`*^9, 3.59014752100268*^9, 
   3.5901483299421*^9, 3.590148591039759*^9, 3.590318328444982*^9, 
   3.592139786104529*^9, 3.592140061605914*^9, 3.592140125086003*^9, 
   3.592140371266348*^9, 3.592141013197246*^9, 3.5921421820488825`*^9, 
   3.5922180775100336`*^9, 3.592218376910453*^9, 3.592218786491026*^9, 
   3.592219192922595*^9, 3.5922193657628374`*^9, 3.598170408004114*^9, 
   3.598188084044051*^9, 3.600328176129328*^9, 3.603719760741647*^9, 
   3.603719895501836*^9, 3.603720026682019*^9, 3.603720435142591*^9, 
   3.6037206579429035`*^9, 3.603720792944092*^9, 3.603720921744272*^9, 
   3.603721580245194*^9, 3.603721639835278*^9, 3.603722555957561*^9, 
   3.607076277165503*^9, 3.6151275443798676`*^9, 3.615127671870046*^9, 
   3.615127771560186*^9, 3.6151278360402756`*^9, 3.615128169207134*^9, 
   3.615129020488325*^9, 3.615129055528374*^9, 3.6151297243393106`*^9, 
   3.619615813036519*^9, 3.619616041420888*^9, 3.619616968497371*^9, 
   3.619617066277508*^9, 3.61961721265176*^9, 3.6196892355965357`*^9, 
   3.619689451710887*^9, 3.619689492200943*^9, 3.619689956050689*^9, 
   3.619690121660921*^9, 3.6205393061784773`*^9, 3.620803638030658*^9, 
   3.620804077911273*^9, 3.62080414689137*^9, 3.648395060565346*^9, 
   3.648395210305556*^9, 3.680003707980238*^9, 3.680101707525405*^9, 
   3.8387111412952957`*^9, 3.838711273827825*^9, 3.838805501038577*^9, 
   3.83888250037932*^9, 3.839149890576627*^9, 3.839151422357146*^9, 
   3.839671969464287*^9, 3.839672076336668*^9, 3.83968740750386*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"0f8ebb95-6162-4da2-b831-44191df9d15a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SymManipulator`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.9.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "9", ",", "3"}], "}"}]}],
  SequenceForm[
  "Package xAct`SymManipulator`  version ", "0.9.5", ", ", {2021, 9, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520174849509264*^9, 3.520175596098965*^9, 3.520175968590816*^9, 
   3.520176096258639*^9, 3.5201762704681425`*^9, 3.520176756057991*^9, 
   3.5201779236516304`*^9, 3.520177973427715*^9, 3.52017803394102*^9, 
   3.520178123221773*^9, 3.520178324027721*^9, 3.52017901033572*^9, 
   3.520179110845495*^9, 3.5201791936240377`*^9, 3.5201792382921166`*^9, 
   3.520179284833394*^9, 3.520179463876904*^9, 3.520179551655855*^9, 
   3.520181360161802*^9, 3.520181636615485*^9, 3.520268562511894*^9, 
   3.520268730947734*^9, 3.520268862571923*^9, 3.520268899680375*^9, 
   3.520269091998247*^9, 3.520271814190901*^9, 3.520310605197149*^9, 
   3.5203109866249046`*^9, 3.520311787180435*^9, 3.520312104904713*^9, {
   3.5271449361606693`*^9, 3.527144937439872*^9}, 3.527145808391402*^9, 
   3.5271460019419417`*^9, 3.527147022965735*^9, 3.5271475939589376`*^9, 
   3.527148046875534*^9, 3.527148264183915*^9, 3.52714868648586*^9, 
   3.5271500507716575`*^9, 3.527150172997871*^9, 3.527150353614989*^9, 
   3.527150507556059*^9, 3.527150791991359*^9, 3.5271508653426876`*^9, 
   3.529230823877325*^9, 3.529232467059411*^9, 3.529232571751195*^9, 
   3.5292359095068574`*^9, 3.529236217513799*^9, 3.529236417194149*^9, 
   3.5292366545797663`*^9, 3.529236716075074*^9, 3.529236967176115*^9, 
   3.529237057671874*^9, 3.5340685699417887`*^9, 3.53406895170566*^9, 
   3.534069382718817*^9, 3.534069951854617*^9, 3.534070176931813*^9, 
   3.534249637172163*^9, 3.537621498672197*^9, 3.5376216251884193`*^9, 
   3.537622841944757*^9, {3.537622948446143*^9, 3.537622964373771*^9}, 
   3.5376231829301553`*^9, 3.537623361519269*^9, 3.5376254399285183`*^9, 
   3.537628789615475*^9, 3.53769469982747*^9, 3.5376948677461658`*^9, 
   3.537695501762479*^9, 3.537695581556619*^9, 3.537695913229801*^9, 
   3.537696395239448*^9, 3.537697105010495*^9, 3.5376974604259186`*^9, {
   3.537697970624815*^9, 3.537697991232452*^9}, 3.537700570638586*^9, 
   3.5377009886725206`*^9, 3.5377011498208036`*^9, 3.537705075508299*^9, 
   3.537767649951489*^9, 3.537780185987508*^9, 3.537780583897407*^9, 
   3.5377809208901987`*^9, 3.537781079916878*^9, 3.5377812420011635`*^9, 
   3.537781378142602*^9, 3.537781527200863*^9, 3.537781725586412*^9, 
   3.537782399040595*^9, 3.5377827398387933`*^9, 3.5377829310015287`*^9, 
   3.537783191740387*^9, 3.537783440546224*^9, 3.5377835728656573`*^9, 
   3.537784107868596*^9, 3.5377842446964374`*^9, 3.544092209221161*^9, 
   3.544097239984397*^9, 3.5440973654710183`*^9, 3.544097952797449*^9, 
   3.544099754133613*^9, 3.5441033727023697`*^9, 3.544103463868929*^9, 
   3.544103705030752*^9, 3.544103917456326*^9, 3.544104051850562*^9, 
   3.544105099611802*^9, 3.5441057142684813`*^9, 3.544105949064494*^9, 
   3.544107147443999*^9, 3.544591253200247*^9, 3.5445914903948135`*^9, 
   3.5445916527811027`*^9, 3.544592904605701*^9, 3.544672173055206*^9, 
   3.5446723745247293`*^9, 3.544673273684159*^9, {3.5446733821943655`*^9, 
   3.544673402912551*^9}, 3.5449492188490252`*^9, 3.544951614114234*^9, 
   3.545015662681334*^9, 3.5450157245042424`*^9, 3.5451061422266498`*^9, 
   3.5451140205734205`*^9, 3.5528211954218006`*^9, 3.552822659532173*^9, 
   3.5528227955020127`*^9, 3.552822986681348*^9, 3.552823195877715*^9, 
   3.5528236662185407`*^9, 3.552823971168877*^9, 3.552826116626045*^9, 
   3.552826309287384*^9, 3.554207271336712*^9, 3.554208466846811*^9, 
   3.56137169743522*^9, 3.561732586327607*^9, 3.561779198364607*^9, 
   3.561781487967029*^9, 3.561781561957958*^9, 3.561781652921718*^9, 
   3.561781901274155*^9, 3.561781933675411*^9, 3.5617821014079056`*^9, 
   3.5617821946492686`*^9, 3.561782388074009*^9, 3.561782492562993*^9, 
   3.5617825257130513`*^9, 3.561784234167652*^9, 3.562766627014151*^9, 
   3.562766743842757*^9, 3.5627670822697515`*^9, 3.562767893144575*^9, 
   3.562769545796878*^9, 3.562769667711093*^9, {3.5627711276260576`*^9, 
   3.562771147063691*^9}, 3.562773114181346*^9, 3.5627732020563*^9, 
   3.562821271771612*^9, 3.562822345818898*^9, 3.562823597723097*^9, 
   3.5628236609812083`*^9, 3.562824061823913*^9, 3.562824598637455*^9, 
   3.5628252433865876`*^9, 3.562825311761508*^9, 3.562825371806013*^9, 
   3.562825959194845*^9, 3.5628261338527513`*^9, 3.562826247904552*^9, 
   3.5628280657185726`*^9, 3.5628285638898473`*^9, 3.562828736504151*^9, 
   3.5628288786984005`*^9, 3.56283048949683*^9, 3.5628313051442623`*^9, 
   3.5628316998415556`*^9, 3.5628318197277665`*^9, 3.562831851645423*^9, 
   3.5628323081802244`*^9, 3.5628324215456233`*^9, 3.562832729178163*^9, 
   3.562833669814016*^9, 3.5628337642409816`*^9, 3.562833834846705*^9, 
   3.563425632980192*^9, 3.5634263671330814`*^9, 3.563427213529168*^9, 
   3.563428699385978*^9, 3.56342879144174*^9, 3.563428870143878*^9, 
   3.563429666479477*^9, 3.564123612696838*^9, 3.5641243458523264`*^9, 
   3.564124862401434*^9, 3.564125017622706*^9, 3.564130442089834*^9, 
   3.5646350262366266`*^9, 3.564635497825455*^9, 3.56467212978749*^9, 
   3.565759287764366*^9, 3.565773666964835*^9, 3.5658920235955*^9, 
   3.566194852674229*^9, 3.566203971352671*^9, 3.566211903794065*^9, 
   3.5662126406527605`*^9, 3.566214734004837*^9, 3.566399150303737*^9, 
   3.56654371253712*^9, 3.567082814807329*^9, 3.5671851370203805`*^9, 
   3.5675865229115*^9, 3.567600479600524*^9, 3.5678594381939497`*^9, 
   3.567860570772539*^9, 3.567861306845233*^9, 3.567861519957207*^9, 
   3.567861619048581*^9, 3.567861715815551*^9, 3.5678618101177173`*^9, 
   3.5678620356317124`*^9, 3.5678622047516093`*^9, 3.567862536440392*^9, 
   3.5678626834706507`*^9, 3.5678627712988043`*^9, 3.567863320294968*^9, 
   3.5678634149403353`*^9, 3.567863936574051*^9, 3.567864088753319*^9, 
   3.567864253786009*^9, 3.56786476698011*^9, 3.567865015816147*^9, 
   3.567865314837472*^9, 3.5678655286212473`*^9, 3.56787745385496*^9, 
   3.5679119479404926`*^9, 3.56791306243765*^9, 3.567916910019585*^9, 
   3.5679176765113325`*^9, 3.567918361150734*^9, 3.5679186147915792`*^9, 
   3.567919444681837*^9, 3.567919756744786*^9, 3.5679242578890924`*^9, 
   3.56792617508666*^9, 3.5679264768847895`*^9, 3.567926861456665*^9, 
   3.567929473936054*^9, 3.567929590686659*^9, 3.567929672134403*^9, 
   3.567929856308326*^9, 3.567930083367725*^9, 3.567930174908685*^9, 
   3.5679303366497693`*^9, 3.567930622504671*^9, 3.567931058541037*^9, 
   3.5679312105477047`*^9, 3.567931331603917*^9, 3.5679314669965553`*^9, 
   3.5679315200376487`*^9, 3.5679316258214345`*^9, 3.567931950286405*^9, 
   3.5679326316332*^9, 3.56793275120741*^9, 3.567933125749468*^9, 
   3.5679332329996576`*^9, 3.567933464176462*^9, 3.5679347101828523`*^9, 
   3.5679359720232677`*^9, 3.568115004553556*^9, 3.568115908404544*^9, 
   3.568122253158088*^9, 3.5681223552758675`*^9, 3.568123412287924*^9, 
   3.568895116739812*^9, 3.5688954833872557`*^9, 3.57164915616996*^9, 
   3.572165389806432*^9, 3.5721751355183487`*^9, 3.572175206670075*^9, 
   3.5721765243429894`*^9, 3.572177189786359*^9, 3.572177290562536*^9, 
   3.5747694831574373`*^9, 3.582348620413965*^9, 3.582348667323248*^9, 
   3.582348910340474*^9, 3.5830672368599787`*^9, 3.583562343502081*^9, 
   3.583562486897534*^9, 3.584196654901731*^9, 3.584767089781197*^9, 
   3.584767773343198*^9, 3.584768129101822*^9, 3.584768643732126*^9, 
   3.584773810012672*^9, 3.5847740060270166`*^9, 3.5847744598640137`*^9, 
   3.584774881033553*^9, 3.584775236168177*^9, 3.584775498482638*^9, 
   3.5847756364804797`*^9, {3.5847777481333895`*^9, 3.584777757867806*^9}, 
   3.5848822316936665`*^9, 3.587025165700854*^9, 3.5876536824752326`*^9, {
   3.5876537670137815`*^9, 3.587653776248998*^9}, 3.588238727700762*^9, 
   3.5891983660249577`*^9, 3.5901468889207697`*^9, 3.59014752100268*^9, 
   3.5901483299421*^9, 3.590148591039759*^9, 3.590318328444982*^9, 
   3.592139786104529*^9, 3.592140061605914*^9, 3.592140125086003*^9, 
   3.592140371266348*^9, 3.592141013197246*^9, 3.5921421820488825`*^9, 
   3.5922180775100336`*^9, 3.592218376910453*^9, 3.592218786491026*^9, 
   3.592219192922595*^9, 3.5922193657628374`*^9, 3.598170408004114*^9, 
   3.598188084044051*^9, 3.600328176129328*^9, 3.603719760741647*^9, 
   3.603719895501836*^9, 3.603720026682019*^9, 3.603720435142591*^9, 
   3.6037206579429035`*^9, 3.603720792944092*^9, 3.603720921744272*^9, 
   3.603721580245194*^9, 3.603721639835278*^9, 3.603722555957561*^9, 
   3.607076277165503*^9, 3.6151275443798676`*^9, 3.615127671870046*^9, 
   3.615127771560186*^9, 3.6151278360402756`*^9, 3.615128169207134*^9, 
   3.615129020488325*^9, 3.615129055528374*^9, 3.6151297243393106`*^9, 
   3.619615813036519*^9, 3.619616041420888*^9, 3.619616968497371*^9, 
   3.619617066277508*^9, 3.61961721265176*^9, 3.6196892355965357`*^9, 
   3.619689451710887*^9, 3.619689492200943*^9, 3.619689956050689*^9, 
   3.619690121660921*^9, 3.6205393061784773`*^9, 3.620803638030658*^9, 
   3.620804077911273*^9, 3.62080414689137*^9, 3.648395060565346*^9, 
   3.648395210305556*^9, 3.680003707980238*^9, 3.680101707525405*^9, 
   3.8387111412952957`*^9, 3.838711273827825*^9, 3.838805501038577*^9, 
   3.83888250037932*^9, 3.839149890576627*^9, 3.839151422357146*^9, 
   3.839671969464287*^9, 3.839672076336668*^9, 3.8396874075068364`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"3c2de369-dac8-473a-8907-f620f62f2beb"],

Cell[BoxData["\<\"CopyRight (C) 2011-2021, Thomas B\[ADoubleDot]ckdahl, under \
the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.520174849509264*^9, 3.520175596098965*^9, 3.520175968590816*^9, 
   3.520176096258639*^9, 3.5201762704681425`*^9, 3.520176756057991*^9, 
   3.5201779236516304`*^9, 3.520177973427715*^9, 3.52017803394102*^9, 
   3.520178123221773*^9, 3.520178324027721*^9, 3.52017901033572*^9, 
   3.520179110845495*^9, 3.5201791936240377`*^9, 3.5201792382921166`*^9, 
   3.520179284833394*^9, 3.520179463876904*^9, 3.520179551655855*^9, 
   3.520181360161802*^9, 3.520181636615485*^9, 3.520268562511894*^9, 
   3.520268730947734*^9, 3.520268862571923*^9, 3.520268899680375*^9, 
   3.520269091998247*^9, 3.520271814190901*^9, 3.520310605197149*^9, 
   3.5203109866249046`*^9, 3.520311787180435*^9, 3.520312104904713*^9, {
   3.5271449361606693`*^9, 3.527144937439872*^9}, 3.527145808391402*^9, 
   3.5271460019419417`*^9, 3.527147022965735*^9, 3.5271475939589376`*^9, 
   3.527148046875534*^9, 3.527148264183915*^9, 3.52714868648586*^9, 
   3.5271500507716575`*^9, 3.527150172997871*^9, 3.527150353614989*^9, 
   3.527150507556059*^9, 3.527150791991359*^9, 3.5271508653426876`*^9, 
   3.529230823877325*^9, 3.529232467059411*^9, 3.529232571751195*^9, 
   3.5292359095068574`*^9, 3.529236217513799*^9, 3.529236417194149*^9, 
   3.5292366545797663`*^9, 3.529236716075074*^9, 3.529236967176115*^9, 
   3.529237057671874*^9, 3.5340685699417887`*^9, 3.53406895170566*^9, 
   3.534069382718817*^9, 3.534069951854617*^9, 3.534070176931813*^9, 
   3.534249637172163*^9, 3.537621498672197*^9, 3.5376216251884193`*^9, 
   3.537622841944757*^9, {3.537622948446143*^9, 3.537622964373771*^9}, 
   3.5376231829301553`*^9, 3.537623361519269*^9, 3.5376254399285183`*^9, 
   3.537628789615475*^9, 3.53769469982747*^9, 3.5376948677461658`*^9, 
   3.537695501762479*^9, 3.537695581556619*^9, 3.537695913229801*^9, 
   3.537696395239448*^9, 3.537697105010495*^9, 3.5376974604259186`*^9, {
   3.537697970624815*^9, 3.537697991232452*^9}, 3.537700570638586*^9, 
   3.5377009886725206`*^9, 3.5377011498208036`*^9, 3.537705075508299*^9, 
   3.537767649951489*^9, 3.537780185987508*^9, 3.537780583897407*^9, 
   3.5377809208901987`*^9, 3.537781079916878*^9, 3.5377812420011635`*^9, 
   3.537781378142602*^9, 3.537781527200863*^9, 3.537781725586412*^9, 
   3.537782399040595*^9, 3.5377827398387933`*^9, 3.5377829310015287`*^9, 
   3.537783191740387*^9, 3.537783440546224*^9, 3.5377835728656573`*^9, 
   3.537784107868596*^9, 3.5377842446964374`*^9, 3.544092209221161*^9, 
   3.544097239984397*^9, 3.5440973654710183`*^9, 3.544097952797449*^9, 
   3.544099754133613*^9, 3.5441033727023697`*^9, 3.544103463868929*^9, 
   3.544103705030752*^9, 3.544103917456326*^9, 3.544104051850562*^9, 
   3.544105099611802*^9, 3.5441057142684813`*^9, 3.544105949064494*^9, 
   3.544107147443999*^9, 3.544591253200247*^9, 3.5445914903948135`*^9, 
   3.5445916527811027`*^9, 3.544592904605701*^9, 3.544672173055206*^9, 
   3.5446723745247293`*^9, 3.544673273684159*^9, {3.5446733821943655`*^9, 
   3.544673402912551*^9}, 3.5449492188490252`*^9, 3.544951614114234*^9, 
   3.545015662681334*^9, 3.5450157245042424`*^9, 3.5451061422266498`*^9, 
   3.5451140205734205`*^9, 3.5528211954218006`*^9, 3.552822659532173*^9, 
   3.5528227955020127`*^9, 3.552822986681348*^9, 3.552823195877715*^9, 
   3.5528236662185407`*^9, 3.552823971168877*^9, 3.552826116626045*^9, 
   3.552826309287384*^9, 3.554207271336712*^9, 3.554208466846811*^9, 
   3.56137169743522*^9, 3.561732586327607*^9, 3.561779198364607*^9, 
   3.561781487967029*^9, 3.561781561957958*^9, 3.561781652921718*^9, 
   3.561781901274155*^9, 3.561781933675411*^9, 3.5617821014079056`*^9, 
   3.5617821946492686`*^9, 3.561782388074009*^9, 3.561782492562993*^9, 
   3.5617825257130513`*^9, 3.561784234167652*^9, 3.562766627014151*^9, 
   3.562766743842757*^9, 3.5627670822697515`*^9, 3.562767893144575*^9, 
   3.562769545796878*^9, 3.562769667711093*^9, {3.5627711276260576`*^9, 
   3.562771147063691*^9}, 3.562773114181346*^9, 3.5627732020563*^9, 
   3.562821271771612*^9, 3.562822345818898*^9, 3.562823597723097*^9, 
   3.5628236609812083`*^9, 3.562824061823913*^9, 3.562824598637455*^9, 
   3.5628252433865876`*^9, 3.562825311761508*^9, 3.562825371806013*^9, 
   3.562825959194845*^9, 3.5628261338527513`*^9, 3.562826247904552*^9, 
   3.5628280657185726`*^9, 3.5628285638898473`*^9, 3.562828736504151*^9, 
   3.5628288786984005`*^9, 3.56283048949683*^9, 3.5628313051442623`*^9, 
   3.5628316998415556`*^9, 3.5628318197277665`*^9, 3.562831851645423*^9, 
   3.5628323081802244`*^9, 3.5628324215456233`*^9, 3.562832729178163*^9, 
   3.562833669814016*^9, 3.5628337642409816`*^9, 3.562833834846705*^9, 
   3.563425632980192*^9, 3.5634263671330814`*^9, 3.563427213529168*^9, 
   3.563428699385978*^9, 3.56342879144174*^9, 3.563428870143878*^9, 
   3.563429666479477*^9, 3.564123612696838*^9, 3.5641243458523264`*^9, 
   3.564124862401434*^9, 3.564125017622706*^9, 3.564130442089834*^9, 
   3.5646350262366266`*^9, 3.564635497825455*^9, 3.56467212978749*^9, 
   3.565759287764366*^9, 3.565773666964835*^9, 3.5658920235955*^9, 
   3.566194852674229*^9, 3.566203971352671*^9, 3.566211903794065*^9, 
   3.5662126406527605`*^9, 3.566214734004837*^9, 3.566399150303737*^9, 
   3.56654371253712*^9, 3.567082814807329*^9, 3.5671851370203805`*^9, 
   3.5675865229115*^9, 3.567600479600524*^9, 3.5678594381939497`*^9, 
   3.567860570772539*^9, 3.567861306845233*^9, 3.567861519957207*^9, 
   3.567861619048581*^9, 3.567861715815551*^9, 3.5678618101177173`*^9, 
   3.5678620356317124`*^9, 3.5678622047516093`*^9, 3.567862536440392*^9, 
   3.5678626834706507`*^9, 3.5678627712988043`*^9, 3.567863320294968*^9, 
   3.5678634149403353`*^9, 3.567863936574051*^9, 3.567864088753319*^9, 
   3.567864253786009*^9, 3.56786476698011*^9, 3.567865015816147*^9, 
   3.567865314837472*^9, 3.5678655286212473`*^9, 3.56787745385496*^9, 
   3.5679119479404926`*^9, 3.56791306243765*^9, 3.567916910019585*^9, 
   3.5679176765113325`*^9, 3.567918361150734*^9, 3.5679186147915792`*^9, 
   3.567919444681837*^9, 3.567919756744786*^9, 3.5679242578890924`*^9, 
   3.56792617508666*^9, 3.5679264768847895`*^9, 3.567926861456665*^9, 
   3.567929473936054*^9, 3.567929590686659*^9, 3.567929672134403*^9, 
   3.567929856308326*^9, 3.567930083367725*^9, 3.567930174908685*^9, 
   3.5679303366497693`*^9, 3.567930622504671*^9, 3.567931058541037*^9, 
   3.5679312105477047`*^9, 3.567931331603917*^9, 3.5679314669965553`*^9, 
   3.5679315200376487`*^9, 3.5679316258214345`*^9, 3.567931950286405*^9, 
   3.5679326316332*^9, 3.56793275120741*^9, 3.567933125749468*^9, 
   3.5679332329996576`*^9, 3.567933464176462*^9, 3.5679347101828523`*^9, 
   3.5679359720232677`*^9, 3.568115004553556*^9, 3.568115908404544*^9, 
   3.568122253158088*^9, 3.5681223552758675`*^9, 3.568123412287924*^9, 
   3.568895116739812*^9, 3.5688954833872557`*^9, 3.57164915616996*^9, 
   3.572165389806432*^9, 3.5721751355183487`*^9, 3.572175206670075*^9, 
   3.5721765243429894`*^9, 3.572177189786359*^9, 3.572177290562536*^9, 
   3.5747694831574373`*^9, 3.582348620413965*^9, 3.582348667323248*^9, 
   3.582348910340474*^9, 3.5830672368599787`*^9, 3.583562343502081*^9, 
   3.583562486897534*^9, 3.584196654901731*^9, 3.584767089781197*^9, 
   3.584767773343198*^9, 3.584768129101822*^9, 3.584768643732126*^9, 
   3.584773810012672*^9, 3.5847740060270166`*^9, 3.5847744598640137`*^9, 
   3.584774881033553*^9, 3.584775236168177*^9, 3.584775498482638*^9, 
   3.5847756364804797`*^9, {3.5847777481333895`*^9, 3.584777757867806*^9}, 
   3.5848822316936665`*^9, 3.587025165700854*^9, 3.5876536824752326`*^9, {
   3.5876537670137815`*^9, 3.587653776248998*^9}, 3.588238727700762*^9, 
   3.5891983660249577`*^9, 3.5901468889207697`*^9, 3.59014752100268*^9, 
   3.5901483299421*^9, 3.590148591039759*^9, 3.590318328444982*^9, 
   3.592139786104529*^9, 3.592140061605914*^9, 3.592140125086003*^9, 
   3.592140371266348*^9, 3.592141013197246*^9, 3.5921421820488825`*^9, 
   3.5922180775100336`*^9, 3.592218376910453*^9, 3.592218786491026*^9, 
   3.592219192922595*^9, 3.5922193657628374`*^9, 3.598170408004114*^9, 
   3.598188084044051*^9, 3.600328176129328*^9, 3.603719760741647*^9, 
   3.603719895501836*^9, 3.603720026682019*^9, 3.603720435142591*^9, 
   3.6037206579429035`*^9, 3.603720792944092*^9, 3.603720921744272*^9, 
   3.603721580245194*^9, 3.603721639835278*^9, 3.603722555957561*^9, 
   3.607076277165503*^9, 3.6151275443798676`*^9, 3.615127671870046*^9, 
   3.615127771560186*^9, 3.6151278360402756`*^9, 3.615128169207134*^9, 
   3.615129020488325*^9, 3.615129055528374*^9, 3.6151297243393106`*^9, 
   3.619615813036519*^9, 3.619616041420888*^9, 3.619616968497371*^9, 
   3.619617066277508*^9, 3.61961721265176*^9, 3.6196892355965357`*^9, 
   3.619689451710887*^9, 3.619689492200943*^9, 3.619689956050689*^9, 
   3.619690121660921*^9, 3.6205393061784773`*^9, 3.620803638030658*^9, 
   3.620804077911273*^9, 3.62080414689137*^9, 3.648395060565346*^9, 
   3.648395210305556*^9, 3.680003707980238*^9, 3.680101707525405*^9, 
   3.8387111412952957`*^9, 3.838711273827825*^9, 3.838805501038577*^9, 
   3.83888250037932*^9, 3.839149890576627*^9, 3.839151422357146*^9, 
   3.839671969464287*^9, 3.839672076336668*^9, 3.839687407520774*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"192ee65f-16e8-433f-a7ab-600cabfd80ca"]
}, Open  ]]
}, Open  ]],

Cell["Check if we have the correct version of xTensor.", "Text",
 CellChangeTimes->{
  3.590148298710846*^9},ExpressionUUID->"76cb1b1b-c1d0-4f2e-8df8-\
a4f1e413755f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"Not", "@", 
     RowBox[{"OrderedQ", "@", 
      RowBox[{"Map", "[", 
       RowBox[{"Last", ",", " ", 
        RowBox[{"{", 
         RowBox[{
         "xAct`SymManipulator`$xTensorVersionExpected", ",", " ", 
          "xAct`xTensor`$Version"}], "}"}]}], "]"}]}]}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"General", "::", "versions"}], ",", " ", "\"\<xTensor\>\"", 
       ",", " ", "xAct`xTensor`$Version", ",", " ", 
       "xAct`SymManipulator`$xTensorVersionExpected"}], "]"}], ";", "\n", 
     "\t", 
     RowBox[{"Abort", "[", "]"}]}]}], "\n", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590148043681598*^9, 3.590148071090846*^9}, {
  3.5901482924552345`*^9, 3.590148296136841*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"88aa52b8-acde-41c6-ae36-c6a73b0faaaf"],

Cell["\<\
We specify the context xAct`SymManipulator` to avoid overriding the \
Disclaimer of the other packages. However we need to turn off the message \
General:shdw temporarily:\
\>", "Text",
 CellChangeTimes->{{3.590148026537167*^9, 
  3.590148029906773*^9}},ExpressionUUID->"3df63cb9-fc81-4c6a-a43c-\
b8ed62e009a3"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`SymManipulator`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", 
   "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744758879812*^9, 3.515744761860983*^9}, 
   3.5159383434841175`*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"c91a25d7-9cdd-4425-88f8-f5f0073a67dd"],

Cell[TextData[{
 "If ",
 StyleBox["SymManipulator",
  FontSlant->"Italic"],
 " is not being called from other package then write this GPL short \
disclaimer:"
}], "Text",
 CellChangeTimes->{{3.519296661172683*^9, 
  3.51929666543149*^9}},ExpressionUUID->"1dcc1202-1c17-412f-b78b-\
88fa18bf3c4e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
   "xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`SymManipulator`\>\""}],
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Print", "[", 
     "\"\<These packages come with ABSOLUTELY NO WARRANTY; for details type \
Disclaimer[]. This is free software, and you are welcome to redistribute it \
under certain conditions. See the General Public License for details.\>\"", 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4232372878945837`*^9, 3.423237289581603*^9}, {
  3.423283390363858*^9, 3.423283408150604*^9}, {3.519296677771112*^9, 
  3.5192966829815207`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"8a347edf-da11-411e-aec7-145a9fc0bead"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.520174849540465*^9, 3.520175596128967*^9, 3.520175968622016*^9, 
   3.520176096289839*^9, 3.520176270499343*^9, 3.520176756087992*^9, 
   3.5201779236828303`*^9, 3.520177973458915*^9, 3.52017803397222*^9, 
   3.520178123251774*^9, 3.520178324058921*^9, 3.52017901036572*^9, 
   3.520179110875495*^9, 3.520179193654038*^9, 3.520179238322116*^9, 
   3.520179284863394*^9, 3.520179463908104*^9, 3.520179551695855*^9, 
   3.520181360208601*^9, 3.5201816366466846`*^9, 3.520268562601894*^9, 
   3.5202687309789333`*^9, 3.5202688626119227`*^9, 3.520268899711575*^9, 
   3.520269092038248*^9, 3.520271814240901*^9, 3.520310605227149*^9, 
   3.520310986656105*^9, 3.520311787220435*^9, 3.5203121049347124`*^9, {
   3.5271449362230697`*^9, 3.5271449374710712`*^9}, 3.527145808422602*^9, 
   3.5271460019731417`*^9, 3.527147022996935*^9, 3.527147593974538*^9, 
   3.527148046906734*^9, 3.5271482641995153`*^9, 3.5271486865170603`*^9, 
   3.527150050818457*^9, 3.527150173029071*^9, 3.5271503536305885`*^9, 
   3.527150507571659*^9, 3.527150792006958*^9, 3.527150865373887*^9, 
   3.5292308239241247`*^9, 3.529232467106211*^9, 3.529232571782395*^9, 
   3.5292359095380573`*^9, 3.529236217544998*^9, 3.5292364172253494`*^9, 
   3.5292366546109657`*^9, 3.529236716121874*^9, 3.529236967207316*^9, 
   3.529237057703075*^9, 3.534068569988589*^9, 3.5340689517524605`*^9, 
   3.5340693827656174`*^9, 3.5340699518858166`*^9, 3.534070176963012*^9, 
   3.534249637234564*^9, 3.537621498718997*^9, 3.537621625219619*^9, 
   3.537622841991556*^9, {3.5376229484929442`*^9, 3.537622964404971*^9}, 
   3.537623182976956*^9, 3.5376233615504684`*^9, 3.53762543997532*^9, 
   3.5376287896778746`*^9, 3.537694699889869*^9, 3.537694867792965*^9, 
   3.5376955018092785`*^9, 3.537695581603419*^9, 3.537695913276601*^9, 
   3.537696395270648*^9, 3.537697105057295*^9, 3.537697460457119*^9, {
   3.537697970656016*^9, 3.537697991279251*^9}, 3.537700570700987*^9, 
   3.537700988719321*^9, 3.537701149867604*^9, 3.537705075586299*^9, 
   3.5377676500294886`*^9, 3.5377801860343075`*^9, 3.537780583944206*^9, 
   3.537780920936999*^9, 3.537781079948078*^9, 3.537781242047962*^9, 
   3.5377813781738014`*^9, 3.5377815272320642`*^9, 3.537781725617612*^9, 
   3.537782399071794*^9, 3.5377827399011936`*^9, 3.537782931048329*^9, 
   3.537783191771588*^9, 3.5377834405930243`*^9, 3.5377835728968573`*^9, 
   3.537784107915396*^9, 3.537784244743237*^9, 3.5440922092835608`*^9, 
   3.544097240358798*^9, 3.5440973655022182`*^9, 3.5440979528442492`*^9, 
   3.544099754164813*^9, 3.5441033727647686`*^9, 3.544103463915729*^9, 
   3.544103705077553*^9, 3.5441039175031257`*^9, 3.544104051881762*^9, 
   3.5441050996586013`*^9, 3.544105714315282*^9, 3.544105949111294*^9, 
   3.544107147490799*^9, 3.544591253264251*^9, 3.544591490440816*^9, 
   3.544591652821104*^9, 3.544592904641704*^9, 3.54467217312121*^9, 
   3.5446723745717325`*^9, 3.544673273733162*^9, {3.544673382226367*^9, 
   3.544673402974554*^9}, 3.5449492188958254`*^9, 3.5449516141610346`*^9, 
   3.545015662743734*^9, 3.5450157245354424`*^9, 3.54510614225785*^9, 
   3.54511402062022*^9, 3.552821195484202*^9, 3.552822659563373*^9, 
   3.552822795564412*^9, 3.552822986743748*^9, 3.552823195908915*^9, 
   3.5528236662653418`*^9, 3.5528239712156773`*^9, 3.552826116688446*^9, 
   3.5528263093185835`*^9, 3.5542072713991117`*^9, 3.554208466893612*^9, 
   3.561371697466419*^9, 3.561732586374408*^9, 3.561779198411407*^9, 
   3.5617814880138283`*^9, 3.561781562004759*^9, 3.561781652952918*^9, 
   3.561781901305354*^9, 3.561781933722211*^9, 3.561782101439106*^9, 
   3.561782194680469*^9, 3.561782388120809*^9, 3.5617824925941925`*^9, 
   3.5617825257442513`*^9, 3.561784234214452*^9, 3.5627666270609517`*^9, 
   3.562766743889557*^9, 3.562767082316551*^9, 3.562767893175775*^9, 
   3.5627695458436785`*^9, 3.562769667742293*^9, {3.562771127657257*^9, 
   3.562771147110491*^9}, 3.562773114228146*^9, 3.5627732020875*^9, 
   3.562821271834012*^9, 3.5628223458656983`*^9, 3.5628235977542973`*^9, 
   3.5628236610124087`*^9, 3.562824061855112*^9, 3.5628245986686554`*^9, 
   3.5628252434333878`*^9, 3.562825311792708*^9, 3.5628253718372135`*^9, 
   3.562825959226045*^9, 3.562826133883952*^9, 3.562826247951352*^9, 
   3.5628280657497725`*^9, 3.5628285639366474`*^9, 3.562828736535351*^9, 
   3.5628288787296004`*^9, 3.56283048952803*^9, 3.562831305175463*^9, 
   3.5628316998727555`*^9, 3.5628318197433662`*^9, 3.562831851692223*^9, 
   3.562832308211424*^9, 3.5628324215924234`*^9, 3.5628327292249637`*^9, 
   3.562833669845216*^9, 3.5628337642877817`*^9, 3.562833834893506*^9, 
   3.563425633042592*^9, 3.5634263671798816`*^9, 3.563427213575969*^9, 
   3.5634286994327784`*^9, 3.56342879147294*^9, 3.5634288701906776`*^9, 
   3.563429666526277*^9, 3.564123612743638*^9, 3.564124345899125*^9, 
   3.5641248624482336`*^9, 3.564125017653906*^9, 3.564130442136634*^9, 
   3.564635026283427*^9, 3.5646354978722553`*^9, 3.56467212984989*^9, 
   3.565759287826766*^9, 3.565773667011635*^9, 3.5658920236579*^9, 
   3.566194852705429*^9, 3.566203971383871*^9, 3.5662119038408647`*^9, 
   3.566212640683961*^9, 3.566214734036038*^9, 3.566399150350537*^9, 
   3.5665437125839195`*^9, 3.567082814838529*^9, 3.5671851370671806`*^9, 
   3.567586522958301*^9, 3.567600479647324*^9, 3.5678594382563505`*^9, 
   3.56786057083494*^9, 3.567861306954433*^9, 3.567861519988407*^9, 
   3.56786161907978*^9, 3.567861715831151*^9, 3.5678618101489167`*^9, 
   3.567862035647312*^9, 3.5678622047828093`*^9, 3.567862536471592*^9, 
   3.5678626835174503`*^9, 3.567862771330005*^9, 3.567863320326169*^9, 
   3.567863414971535*^9, 3.567863936589651*^9, 3.5678640887845197`*^9, 
   3.567864253817209*^9, 3.56786476699571*^9, 3.567865015831747*^9, 
   3.567865314868672*^9, 3.567865528652448*^9, 3.56787745388616*^9, 
   3.567911947971692*^9, 3.567913062468849*^9, 3.567916910050785*^9, 
   3.567917676526932*^9, 3.5679183611819353`*^9, 3.56791861482278*^9, 
   3.5679194446974382`*^9, 3.5679197567759867`*^9, 3.5679242579046926`*^9, 
   3.567926175102259*^9, 3.567926476900389*^9, 3.567926861487865*^9, 
   3.567929473967254*^9, 3.567929590702259*^9, 3.567929672165602*^9, 
   3.567929856339526*^9, 3.567930083398925*^9, 3.567930174939885*^9, 
   3.567930336680969*^9, 3.567930622520272*^9, 3.567931058572237*^9, 
   3.567931210578904*^9, 3.5679313316351175`*^9, 3.567931467027755*^9, 
   3.567931520068848*^9, 3.5679316258526344`*^9, 3.5679319503176045`*^9, 
   3.5679326316488*^9, 3.567932751238611*^9, 3.5679331257806687`*^9, 
   3.567933233015257*^9, 3.567933464207663*^9, 3.567934710198451*^9, 
   3.567935972054468*^9, 3.568115004584756*^9, 3.568115908435744*^9, 
   3.568122253173688*^9, 3.568122355322667*^9, 3.5681234123191237`*^9, 
   3.568895116786613*^9, 3.568895483418456*^9, 3.57164915618556*^9, 
   3.5721653898376317`*^9, 3.57217513554955*^9, 3.5721752066856747`*^9, 
   3.572176524374189*^9, 3.572177189817559*^9, 3.5721772905781355`*^9, 
   3.574769483204238*^9, 3.5823486204451647`*^9, 3.582348667354448*^9, 
   3.582348910371674*^9, 3.583067236891178*^9, 3.5835623435644817`*^9, 
   3.583562486944333*^9, 3.5841966549173317`*^9, 3.584767089812397*^9, 
   3.584767773374398*^9, 3.584768129133022*^9, 3.584768643841327*^9, 
   3.5847738100282717`*^9, 3.5847740060582156`*^9, 3.584774459895213*^9, 
   3.5847748810491533`*^9, 3.5847752361837764`*^9, 3.584775498498237*^9, 
   3.584775636511679*^9, {3.584777748164589*^9, 3.584777757899006*^9}, 
   3.5848822317404666`*^9, 3.587025165763253*^9, 3.587653682506433*^9, {
   3.587653767044981*^9, 3.587653776280198*^9}, 3.588238727731962*^9, 
   3.589198366071757*^9, 3.59014688893637*^9, 3.5901475210338793`*^9, 
   3.5901483299733*^9, 3.590148591070959*^9, 3.590318328476182*^9, 
   3.592139786144529*^9, 3.5921400616259146`*^9, 3.592140125116003*^9, 
   3.592140371296348*^9, 3.592141013217247*^9, 3.5921421820888824`*^9, 
   3.5922180775300336`*^9, 3.592218376950453*^9, 3.592218786521026*^9, 
   3.592219192972595*^9, 3.592219365792837*^9, 3.598170408034114*^9, 
   3.598188084084051*^9, 3.600328176179327*^9, 3.6037197607816477`*^9, 
   3.6037198955318356`*^9, 3.603720026712019*^9, 3.603720435172591*^9, 
   3.603720657972903*^9, 3.603720792974092*^9, 3.603720921774273*^9, 
   3.603721580265194*^9, 3.603721639865278*^9, 3.603722555997561*^9, 
   3.607076277195503*^9, 3.615127544399867*^9, 3.615127671900046*^9, 
   3.615127771600186*^9, 3.6151278360702753`*^9, 3.6151281692271338`*^9, 
   3.6151290204983253`*^9, 3.615129055618374*^9, 3.61512972435931*^9, 
   3.6196158130665193`*^9, 3.6196160414408875`*^9, 3.61961696851737*^9, 
   3.619617066307508*^9, 3.6196172126717606`*^9, 3.619689235626536*^9, 
   3.6196894517408867`*^9, 3.619689492230943*^9, 3.619689956080689*^9, 
   3.619690121690921*^9, 3.6205393061984773`*^9, 3.6208036380606575`*^9, 
   3.620804077931273*^9, 3.62080414700137*^9, 3.648395060595346*^9, 
   3.648395210335555*^9, 3.6800037080302386`*^9, 3.680101707545405*^9, 
   3.838711141364717*^9, 3.8387112747936525`*^9, 3.83880550113333*^9, 
   3.838882500468083*^9, 3.839149890665361*^9, 3.83915142243394*^9, 
   3.839671969537121*^9, 3.8396720764074793`*^9, 3.839687407582633*^9},
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"887cf1e1-e975-4cc4-8e59-2d814914c0be"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{
  3.520174849540465*^9, 3.520175596128967*^9, 3.520175968622016*^9, 
   3.520176096289839*^9, 3.520176270499343*^9, 3.520176756087992*^9, 
   3.5201779236828303`*^9, 3.520177973458915*^9, 3.52017803397222*^9, 
   3.520178123251774*^9, 3.520178324058921*^9, 3.52017901036572*^9, 
   3.520179110875495*^9, 3.520179193654038*^9, 3.520179238322116*^9, 
   3.520179284863394*^9, 3.520179463908104*^9, 3.520179551695855*^9, 
   3.520181360208601*^9, 3.5201816366466846`*^9, 3.520268562601894*^9, 
   3.5202687309789333`*^9, 3.5202688626119227`*^9, 3.520268899711575*^9, 
   3.520269092038248*^9, 3.520271814240901*^9, 3.520310605227149*^9, 
   3.520310986656105*^9, 3.520311787220435*^9, 3.5203121049347124`*^9, {
   3.5271449362230697`*^9, 3.5271449374710712`*^9}, 3.527145808422602*^9, 
   3.5271460019731417`*^9, 3.527147022996935*^9, 3.527147593974538*^9, 
   3.527148046906734*^9, 3.5271482641995153`*^9, 3.5271486865170603`*^9, 
   3.527150050818457*^9, 3.527150173029071*^9, 3.5271503536305885`*^9, 
   3.527150507571659*^9, 3.527150792006958*^9, 3.527150865373887*^9, 
   3.5292308239241247`*^9, 3.529232467106211*^9, 3.529232571782395*^9, 
   3.5292359095380573`*^9, 3.529236217544998*^9, 3.5292364172253494`*^9, 
   3.5292366546109657`*^9, 3.529236716121874*^9, 3.529236967207316*^9, 
   3.529237057703075*^9, 3.534068569988589*^9, 3.5340689517524605`*^9, 
   3.5340693827656174`*^9, 3.5340699518858166`*^9, 3.534070176963012*^9, 
   3.534249637234564*^9, 3.537621498718997*^9, 3.537621625219619*^9, 
   3.537622841991556*^9, {3.5376229484929442`*^9, 3.537622964404971*^9}, 
   3.537623182976956*^9, 3.5376233615504684`*^9, 3.53762543997532*^9, 
   3.5376287896778746`*^9, 3.537694699889869*^9, 3.537694867792965*^9, 
   3.5376955018092785`*^9, 3.537695581603419*^9, 3.537695913276601*^9, 
   3.537696395270648*^9, 3.537697105057295*^9, 3.537697460457119*^9, {
   3.537697970656016*^9, 3.537697991279251*^9}, 3.537700570700987*^9, 
   3.537700988719321*^9, 3.537701149867604*^9, 3.537705075586299*^9, 
   3.5377676500294886`*^9, 3.5377801860343075`*^9, 3.537780583944206*^9, 
   3.537780920936999*^9, 3.537781079948078*^9, 3.537781242047962*^9, 
   3.5377813781738014`*^9, 3.5377815272320642`*^9, 3.537781725617612*^9, 
   3.537782399071794*^9, 3.5377827399011936`*^9, 3.537782931048329*^9, 
   3.537783191771588*^9, 3.5377834405930243`*^9, 3.5377835728968573`*^9, 
   3.537784107915396*^9, 3.537784244743237*^9, 3.5440922092835608`*^9, 
   3.544097240358798*^9, 3.5440973655022182`*^9, 3.5440979528442492`*^9, 
   3.544099754164813*^9, 3.5441033727647686`*^9, 3.544103463915729*^9, 
   3.544103705077553*^9, 3.5441039175031257`*^9, 3.544104051881762*^9, 
   3.5441050996586013`*^9, 3.544105714315282*^9, 3.544105949111294*^9, 
   3.544107147490799*^9, 3.544591253264251*^9, 3.544591490440816*^9, 
   3.544591652821104*^9, 3.544592904641704*^9, 3.54467217312121*^9, 
   3.5446723745717325`*^9, 3.544673273733162*^9, {3.544673382226367*^9, 
   3.544673402974554*^9}, 3.5449492188958254`*^9, 3.5449516141610346`*^9, 
   3.545015662743734*^9, 3.5450157245354424`*^9, 3.54510614225785*^9, 
   3.54511402062022*^9, 3.552821195484202*^9, 3.552822659563373*^9, 
   3.552822795564412*^9, 3.552822986743748*^9, 3.552823195908915*^9, 
   3.5528236662653418`*^9, 3.5528239712156773`*^9, 3.552826116688446*^9, 
   3.5528263093185835`*^9, 3.5542072713991117`*^9, 3.554208466893612*^9, 
   3.561371697466419*^9, 3.561732586374408*^9, 3.561779198411407*^9, 
   3.5617814880138283`*^9, 3.561781562004759*^9, 3.561781652952918*^9, 
   3.561781901305354*^9, 3.561781933722211*^9, 3.561782101439106*^9, 
   3.561782194680469*^9, 3.561782388120809*^9, 3.5617824925941925`*^9, 
   3.5617825257442513`*^9, 3.561784234214452*^9, 3.5627666270609517`*^9, 
   3.562766743889557*^9, 3.562767082316551*^9, 3.562767893175775*^9, 
   3.5627695458436785`*^9, 3.562769667742293*^9, {3.562771127657257*^9, 
   3.562771147110491*^9}, 3.562773114228146*^9, 3.5627732020875*^9, 
   3.562821271834012*^9, 3.5628223458656983`*^9, 3.5628235977542973`*^9, 
   3.5628236610124087`*^9, 3.562824061855112*^9, 3.5628245986686554`*^9, 
   3.5628252434333878`*^9, 3.562825311792708*^9, 3.5628253718372135`*^9, 
   3.562825959226045*^9, 3.562826133883952*^9, 3.562826247951352*^9, 
   3.5628280657497725`*^9, 3.5628285639366474`*^9, 3.562828736535351*^9, 
   3.5628288787296004`*^9, 3.56283048952803*^9, 3.562831305175463*^9, 
   3.5628316998727555`*^9, 3.5628318197433662`*^9, 3.562831851692223*^9, 
   3.562832308211424*^9, 3.5628324215924234`*^9, 3.5628327292249637`*^9, 
   3.562833669845216*^9, 3.5628337642877817`*^9, 3.562833834893506*^9, 
   3.563425633042592*^9, 3.5634263671798816`*^9, 3.563427213575969*^9, 
   3.5634286994327784`*^9, 3.56342879147294*^9, 3.5634288701906776`*^9, 
   3.563429666526277*^9, 3.564123612743638*^9, 3.564124345899125*^9, 
   3.5641248624482336`*^9, 3.564125017653906*^9, 3.564130442136634*^9, 
   3.564635026283427*^9, 3.5646354978722553`*^9, 3.56467212984989*^9, 
   3.565759287826766*^9, 3.565773667011635*^9, 3.5658920236579*^9, 
   3.566194852705429*^9, 3.566203971383871*^9, 3.5662119038408647`*^9, 
   3.566212640683961*^9, 3.566214734036038*^9, 3.566399150350537*^9, 
   3.5665437125839195`*^9, 3.567082814838529*^9, 3.5671851370671806`*^9, 
   3.567586522958301*^9, 3.567600479647324*^9, 3.5678594382563505`*^9, 
   3.56786057083494*^9, 3.567861306954433*^9, 3.567861519988407*^9, 
   3.56786161907978*^9, 3.567861715831151*^9, 3.5678618101489167`*^9, 
   3.567862035647312*^9, 3.5678622047828093`*^9, 3.567862536471592*^9, 
   3.5678626835174503`*^9, 3.567862771330005*^9, 3.567863320326169*^9, 
   3.567863414971535*^9, 3.567863936589651*^9, 3.5678640887845197`*^9, 
   3.567864253817209*^9, 3.56786476699571*^9, 3.567865015831747*^9, 
   3.567865314868672*^9, 3.567865528652448*^9, 3.56787745388616*^9, 
   3.567911947971692*^9, 3.567913062468849*^9, 3.567916910050785*^9, 
   3.567917676526932*^9, 3.5679183611819353`*^9, 3.56791861482278*^9, 
   3.5679194446974382`*^9, 3.5679197567759867`*^9, 3.5679242579046926`*^9, 
   3.567926175102259*^9, 3.567926476900389*^9, 3.567926861487865*^9, 
   3.567929473967254*^9, 3.567929590702259*^9, 3.567929672165602*^9, 
   3.567929856339526*^9, 3.567930083398925*^9, 3.567930174939885*^9, 
   3.567930336680969*^9, 3.567930622520272*^9, 3.567931058572237*^9, 
   3.567931210578904*^9, 3.5679313316351175`*^9, 3.567931467027755*^9, 
   3.567931520068848*^9, 3.5679316258526344`*^9, 3.5679319503176045`*^9, 
   3.5679326316488*^9, 3.567932751238611*^9, 3.5679331257806687`*^9, 
   3.567933233015257*^9, 3.567933464207663*^9, 3.567934710198451*^9, 
   3.567935972054468*^9, 3.568115004584756*^9, 3.568115908435744*^9, 
   3.568122253173688*^9, 3.568122355322667*^9, 3.5681234123191237`*^9, 
   3.568895116786613*^9, 3.568895483418456*^9, 3.57164915618556*^9, 
   3.5721653898376317`*^9, 3.57217513554955*^9, 3.5721752066856747`*^9, 
   3.572176524374189*^9, 3.572177189817559*^9, 3.5721772905781355`*^9, 
   3.574769483204238*^9, 3.5823486204451647`*^9, 3.582348667354448*^9, 
   3.582348910371674*^9, 3.583067236891178*^9, 3.5835623435644817`*^9, 
   3.583562486944333*^9, 3.5841966549173317`*^9, 3.584767089812397*^9, 
   3.584767773374398*^9, 3.584768129133022*^9, 3.584768643841327*^9, 
   3.5847738100282717`*^9, 3.5847740060582156`*^9, 3.584774459895213*^9, 
   3.5847748810491533`*^9, 3.5847752361837764`*^9, 3.584775498498237*^9, 
   3.584775636511679*^9, {3.584777748164589*^9, 3.584777757899006*^9}, 
   3.5848822317404666`*^9, 3.587025165763253*^9, 3.587653682506433*^9, {
   3.587653767044981*^9, 3.587653776280198*^9}, 3.588238727731962*^9, 
   3.589198366071757*^9, 3.59014688893637*^9, 3.5901475210338793`*^9, 
   3.5901483299733*^9, 3.590148591070959*^9, 3.590318328476182*^9, 
   3.592139786144529*^9, 3.5921400616259146`*^9, 3.592140125116003*^9, 
   3.592140371296348*^9, 3.592141013217247*^9, 3.5921421820888824`*^9, 
   3.5922180775300336`*^9, 3.592218376950453*^9, 3.592218786521026*^9, 
   3.592219192972595*^9, 3.592219365792837*^9, 3.598170408034114*^9, 
   3.598188084084051*^9, 3.600328176179327*^9, 3.6037197607816477`*^9, 
   3.6037198955318356`*^9, 3.603720026712019*^9, 3.603720435172591*^9, 
   3.603720657972903*^9, 3.603720792974092*^9, 3.603720921774273*^9, 
   3.603721580265194*^9, 3.603721639865278*^9, 3.603722555997561*^9, 
   3.607076277195503*^9, 3.615127544399867*^9, 3.615127671900046*^9, 
   3.615127771600186*^9, 3.6151278360702753`*^9, 3.6151281692271338`*^9, 
   3.6151290204983253`*^9, 3.615129055618374*^9, 3.61512972435931*^9, 
   3.6196158130665193`*^9, 3.6196160414408875`*^9, 3.61961696851737*^9, 
   3.619617066307508*^9, 3.6196172126717606`*^9, 3.619689235626536*^9, 
   3.6196894517408867`*^9, 3.619689492230943*^9, 3.619689956080689*^9, 
   3.619690121690921*^9, 3.6205393061984773`*^9, 3.6208036380606575`*^9, 
   3.620804077931273*^9, 3.62080414700137*^9, 3.648395060595346*^9, 
   3.648395210335555*^9, 3.6800037080302386`*^9, 3.680101707545405*^9, 
   3.838711141364717*^9, 3.8387112747936525`*^9, 3.83880550113333*^9, 
   3.838882500468083*^9, 3.839149890665361*^9, 3.83915142243394*^9, 
   3.839671969537121*^9, 3.8396720764074793`*^9, 3.839687407588592*^9},
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"179f75ca-4f91-4953-adfd-25f724076485"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.520174849540465*^9, 3.520175596128967*^9, 3.520175968622016*^9, 
   3.520176096289839*^9, 3.520176270499343*^9, 3.520176756087992*^9, 
   3.5201779236828303`*^9, 3.520177973458915*^9, 3.52017803397222*^9, 
   3.520178123251774*^9, 3.520178324058921*^9, 3.52017901036572*^9, 
   3.520179110875495*^9, 3.520179193654038*^9, 3.520179238322116*^9, 
   3.520179284863394*^9, 3.520179463908104*^9, 3.520179551695855*^9, 
   3.520181360208601*^9, 3.5201816366466846`*^9, 3.520268562601894*^9, 
   3.5202687309789333`*^9, 3.5202688626119227`*^9, 3.520268899711575*^9, 
   3.520269092038248*^9, 3.520271814240901*^9, 3.520310605227149*^9, 
   3.520310986656105*^9, 3.520311787220435*^9, 3.5203121049347124`*^9, {
   3.5271449362230697`*^9, 3.5271449374710712`*^9}, 3.527145808422602*^9, 
   3.5271460019731417`*^9, 3.527147022996935*^9, 3.527147593974538*^9, 
   3.527148046906734*^9, 3.5271482641995153`*^9, 3.5271486865170603`*^9, 
   3.527150050818457*^9, 3.527150173029071*^9, 3.5271503536305885`*^9, 
   3.527150507571659*^9, 3.527150792006958*^9, 3.527150865373887*^9, 
   3.5292308239241247`*^9, 3.529232467106211*^9, 3.529232571782395*^9, 
   3.5292359095380573`*^9, 3.529236217544998*^9, 3.5292364172253494`*^9, 
   3.5292366546109657`*^9, 3.529236716121874*^9, 3.529236967207316*^9, 
   3.529237057703075*^9, 3.534068569988589*^9, 3.5340689517524605`*^9, 
   3.5340693827656174`*^9, 3.5340699518858166`*^9, 3.534070176963012*^9, 
   3.534249637234564*^9, 3.537621498718997*^9, 3.537621625219619*^9, 
   3.537622841991556*^9, {3.5376229484929442`*^9, 3.537622964404971*^9}, 
   3.537623182976956*^9, 3.5376233615504684`*^9, 3.53762543997532*^9, 
   3.5376287896778746`*^9, 3.537694699889869*^9, 3.537694867792965*^9, 
   3.5376955018092785`*^9, 3.537695581603419*^9, 3.537695913276601*^9, 
   3.537696395270648*^9, 3.537697105057295*^9, 3.537697460457119*^9, {
   3.537697970656016*^9, 3.537697991279251*^9}, 3.537700570700987*^9, 
   3.537700988719321*^9, 3.537701149867604*^9, 3.537705075586299*^9, 
   3.5377676500294886`*^9, 3.5377801860343075`*^9, 3.537780583944206*^9, 
   3.537780920936999*^9, 3.537781079948078*^9, 3.537781242047962*^9, 
   3.5377813781738014`*^9, 3.5377815272320642`*^9, 3.537781725617612*^9, 
   3.537782399071794*^9, 3.5377827399011936`*^9, 3.537782931048329*^9, 
   3.537783191771588*^9, 3.5377834405930243`*^9, 3.5377835728968573`*^9, 
   3.537784107915396*^9, 3.537784244743237*^9, 3.5440922092835608`*^9, 
   3.544097240358798*^9, 3.5440973655022182`*^9, 3.5440979528442492`*^9, 
   3.544099754164813*^9, 3.5441033727647686`*^9, 3.544103463915729*^9, 
   3.544103705077553*^9, 3.5441039175031257`*^9, 3.544104051881762*^9, 
   3.5441050996586013`*^9, 3.544105714315282*^9, 3.544105949111294*^9, 
   3.544107147490799*^9, 3.544591253264251*^9, 3.544591490440816*^9, 
   3.544591652821104*^9, 3.544592904641704*^9, 3.54467217312121*^9, 
   3.5446723745717325`*^9, 3.544673273733162*^9, {3.544673382226367*^9, 
   3.544673402974554*^9}, 3.5449492188958254`*^9, 3.5449516141610346`*^9, 
   3.545015662743734*^9, 3.5450157245354424`*^9, 3.54510614225785*^9, 
   3.54511402062022*^9, 3.552821195484202*^9, 3.552822659563373*^9, 
   3.552822795564412*^9, 3.552822986743748*^9, 3.552823195908915*^9, 
   3.5528236662653418`*^9, 3.5528239712156773`*^9, 3.552826116688446*^9, 
   3.5528263093185835`*^9, 3.5542072713991117`*^9, 3.554208466893612*^9, 
   3.561371697466419*^9, 3.561732586374408*^9, 3.561779198411407*^9, 
   3.5617814880138283`*^9, 3.561781562004759*^9, 3.561781652952918*^9, 
   3.561781901305354*^9, 3.561781933722211*^9, 3.561782101439106*^9, 
   3.561782194680469*^9, 3.561782388120809*^9, 3.5617824925941925`*^9, 
   3.5617825257442513`*^9, 3.561784234214452*^9, 3.5627666270609517`*^9, 
   3.562766743889557*^9, 3.562767082316551*^9, 3.562767893175775*^9, 
   3.5627695458436785`*^9, 3.562769667742293*^9, {3.562771127657257*^9, 
   3.562771147110491*^9}, 3.562773114228146*^9, 3.5627732020875*^9, 
   3.562821271834012*^9, 3.5628223458656983`*^9, 3.5628235977542973`*^9, 
   3.5628236610124087`*^9, 3.562824061855112*^9, 3.5628245986686554`*^9, 
   3.5628252434333878`*^9, 3.562825311792708*^9, 3.5628253718372135`*^9, 
   3.562825959226045*^9, 3.562826133883952*^9, 3.562826247951352*^9, 
   3.5628280657497725`*^9, 3.5628285639366474`*^9, 3.562828736535351*^9, 
   3.5628288787296004`*^9, 3.56283048952803*^9, 3.562831305175463*^9, 
   3.5628316998727555`*^9, 3.5628318197433662`*^9, 3.562831851692223*^9, 
   3.562832308211424*^9, 3.5628324215924234`*^9, 3.5628327292249637`*^9, 
   3.562833669845216*^9, 3.5628337642877817`*^9, 3.562833834893506*^9, 
   3.563425633042592*^9, 3.5634263671798816`*^9, 3.563427213575969*^9, 
   3.5634286994327784`*^9, 3.56342879147294*^9, 3.5634288701906776`*^9, 
   3.563429666526277*^9, 3.564123612743638*^9, 3.564124345899125*^9, 
   3.5641248624482336`*^9, 3.564125017653906*^9, 3.564130442136634*^9, 
   3.564635026283427*^9, 3.5646354978722553`*^9, 3.56467212984989*^9, 
   3.565759287826766*^9, 3.565773667011635*^9, 3.5658920236579*^9, 
   3.566194852705429*^9, 3.566203971383871*^9, 3.5662119038408647`*^9, 
   3.566212640683961*^9, 3.566214734036038*^9, 3.566399150350537*^9, 
   3.5665437125839195`*^9, 3.567082814838529*^9, 3.5671851370671806`*^9, 
   3.567586522958301*^9, 3.567600479647324*^9, 3.5678594382563505`*^9, 
   3.56786057083494*^9, 3.567861306954433*^9, 3.567861519988407*^9, 
   3.56786161907978*^9, 3.567861715831151*^9, 3.5678618101489167`*^9, 
   3.567862035647312*^9, 3.5678622047828093`*^9, 3.567862536471592*^9, 
   3.5678626835174503`*^9, 3.567862771330005*^9, 3.567863320326169*^9, 
   3.567863414971535*^9, 3.567863936589651*^9, 3.5678640887845197`*^9, 
   3.567864253817209*^9, 3.56786476699571*^9, 3.567865015831747*^9, 
   3.567865314868672*^9, 3.567865528652448*^9, 3.56787745388616*^9, 
   3.567911947971692*^9, 3.567913062468849*^9, 3.567916910050785*^9, 
   3.567917676526932*^9, 3.5679183611819353`*^9, 3.56791861482278*^9, 
   3.5679194446974382`*^9, 3.5679197567759867`*^9, 3.5679242579046926`*^9, 
   3.567926175102259*^9, 3.567926476900389*^9, 3.567926861487865*^9, 
   3.567929473967254*^9, 3.567929590702259*^9, 3.567929672165602*^9, 
   3.567929856339526*^9, 3.567930083398925*^9, 3.567930174939885*^9, 
   3.567930336680969*^9, 3.567930622520272*^9, 3.567931058572237*^9, 
   3.567931210578904*^9, 3.5679313316351175`*^9, 3.567931467027755*^9, 
   3.567931520068848*^9, 3.5679316258526344`*^9, 3.5679319503176045`*^9, 
   3.5679326316488*^9, 3.567932751238611*^9, 3.5679331257806687`*^9, 
   3.567933233015257*^9, 3.567933464207663*^9, 3.567934710198451*^9, 
   3.567935972054468*^9, 3.568115004584756*^9, 3.568115908435744*^9, 
   3.568122253173688*^9, 3.568122355322667*^9, 3.5681234123191237`*^9, 
   3.568895116786613*^9, 3.568895483418456*^9, 3.57164915618556*^9, 
   3.5721653898376317`*^9, 3.57217513554955*^9, 3.5721752066856747`*^9, 
   3.572176524374189*^9, 3.572177189817559*^9, 3.5721772905781355`*^9, 
   3.574769483204238*^9, 3.5823486204451647`*^9, 3.582348667354448*^9, 
   3.582348910371674*^9, 3.583067236891178*^9, 3.5835623435644817`*^9, 
   3.583562486944333*^9, 3.5841966549173317`*^9, 3.584767089812397*^9, 
   3.584767773374398*^9, 3.584768129133022*^9, 3.584768643841327*^9, 
   3.5847738100282717`*^9, 3.5847740060582156`*^9, 3.584774459895213*^9, 
   3.5847748810491533`*^9, 3.5847752361837764`*^9, 3.584775498498237*^9, 
   3.584775636511679*^9, {3.584777748164589*^9, 3.584777757899006*^9}, 
   3.5848822317404666`*^9, 3.587025165763253*^9, 3.587653682506433*^9, {
   3.587653767044981*^9, 3.587653776280198*^9}, 3.588238727731962*^9, 
   3.589198366071757*^9, 3.59014688893637*^9, 3.5901475210338793`*^9, 
   3.5901483299733*^9, 3.590148591070959*^9, 3.590318328476182*^9, 
   3.592139786144529*^9, 3.5921400616259146`*^9, 3.592140125116003*^9, 
   3.592140371296348*^9, 3.592141013217247*^9, 3.5921421820888824`*^9, 
   3.5922180775300336`*^9, 3.592218376950453*^9, 3.592218786521026*^9, 
   3.592219192972595*^9, 3.592219365792837*^9, 3.598170408034114*^9, 
   3.598188084084051*^9, 3.600328176179327*^9, 3.6037197607816477`*^9, 
   3.6037198955318356`*^9, 3.603720026712019*^9, 3.603720435172591*^9, 
   3.603720657972903*^9, 3.603720792974092*^9, 3.603720921774273*^9, 
   3.603721580265194*^9, 3.603721639865278*^9, 3.603722555997561*^9, 
   3.607076277195503*^9, 3.615127544399867*^9, 3.615127671900046*^9, 
   3.615127771600186*^9, 3.6151278360702753`*^9, 3.6151281692271338`*^9, 
   3.6151290204983253`*^9, 3.615129055618374*^9, 3.61512972435931*^9, 
   3.6196158130665193`*^9, 3.6196160414408875`*^9, 3.61961696851737*^9, 
   3.619617066307508*^9, 3.6196172126717606`*^9, 3.619689235626536*^9, 
   3.6196894517408867`*^9, 3.619689492230943*^9, 3.619689956080689*^9, 
   3.619690121690921*^9, 3.6205393061984773`*^9, 3.6208036380606575`*^9, 
   3.620804077931273*^9, 3.62080414700137*^9, 3.648395060595346*^9, 
   3.648395210335555*^9, 3.6800037080302386`*^9, 3.680101707545405*^9, 
   3.838711141364717*^9, 3.8387112747936525`*^9, 3.83880550113333*^9, 
   3.838882500468083*^9, 3.839149890665361*^9, 3.83915142243394*^9, 
   3.839671969537121*^9, 3.8396720764074793`*^9, 3.839687407596572*^9},
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"148f9b42-c0e6-4e3c-8097-cf41bc2cf2c6"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Note that symbols in the Global` context cannot be accessed right now.\
\>", "Text",
 CellChangeTimes->{
  3.423568541839567*^9},ExpressionUUID->"6d6ddc25-5899-4449-a012-\
b5710de2154c"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"f60d7d97-cb22-487a-ad63-86860a844214"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`SymManipulator`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellChangeTimes->{
  3.520174849571665*^9, 3.520175596158966*^9, 3.520175968637616*^9, 
   3.520176096321039*^9, 3.520176270530543*^9, 3.520176756107991*^9, 
   3.5201779237140303`*^9, 3.520177973474515*^9, 3.52017803398782*^9, 
   3.520178123271774*^9, 3.520178324074521*^9, 3.5201790103857203`*^9, 
   3.520179110895495*^9, 3.520179193674038*^9, 3.520179238352116*^9, 
   3.5201792848833942`*^9, 3.520179463923704*^9, 3.5201795517158556`*^9, 
   3.5201813602398014`*^9, 3.520181636662285*^9, 3.520268562631894*^9, 
   3.5202687310101337`*^9, 3.520268862631922*^9, 3.5202688997271757`*^9, 
   3.520269092058247*^9, 3.520271814260901*^9, 3.5203106052471485`*^9, 
   3.520310986671705*^9, 3.520311787240435*^9, 3.520312104954713*^9, 
   3.527144937502272*^9, 3.527145808438202*^9, 3.527146001988742*^9, 
   3.527147023012535*^9, 3.527147593990138*^9, 3.5271480469223347`*^9, 
   3.5271482642151155`*^9, 3.52714868653266*^9, 3.5271500508652573`*^9, 
   3.527150173044671*^9, 3.5271503536617885`*^9, 3.527150507602859*^9, 
   3.527150792038159*^9, 3.5271508653894877`*^9, 3.529230823939725*^9, 
   3.529232467121811*^9, 3.529232571797995*^9, 3.529235909553657*^9, 
   3.529236217560599*^9, 3.529236417240949*^9, 3.529236654626566*^9, 
   3.529236716137474*^9, 3.529236967238515*^9, 3.529237057734275*^9, 
   3.5340685700041885`*^9, 3.53406895176806*^9, 3.5340693827968173`*^9, 
   3.534069951917017*^9, 3.534070176994212*^9, 3.534249637281363*^9, 
   3.537621498765797*^9, 3.537621625250819*^9, 3.537622842022757*^9, {
   3.537622948508543*^9, 3.5376229644517713`*^9}, 3.537623183008155*^9, 
   3.537623361581669*^9, 3.5376254400065193`*^9, 3.5376287897246747`*^9, 
   3.5376946999366703`*^9, 3.5376948678241653`*^9, 3.537695501840479*^9, 
   3.5376955816346188`*^9, 3.5376959133078003`*^9, 3.537696395301848*^9, 
   3.537697105088495*^9, 3.537697460488319*^9, {3.537697970687215*^9, 
   3.5376979913104515`*^9}, 3.537700570747787*^9, 3.537700988750521*^9, 
   3.5377011498988037`*^9, 3.537705075633099*^9, 3.5377676500762887`*^9, 
   3.537780186049908*^9, 3.5377805839754066`*^9, 3.5377809209681983`*^9, 
   3.537781079994878*^9, 3.537781242079163*^9, 3.537781378205002*^9, 
   3.537781527263264*^9, 3.537781725648813*^9, 3.537782399102995*^9, 
   3.537782739932393*^9, 3.537782931079529*^9, 3.537783191802788*^9, 
   3.537783440624224*^9, 3.5377835729280577`*^9, 3.537784107946596*^9, 
   3.537784244774437*^9, 3.5440922093459606`*^9, 3.544097240421198*^9, 
   3.5440973655334187`*^9, 3.544097952875449*^9, 3.5440997541960144`*^9, 
   3.544103372811569*^9, 3.544103463946929*^9, 3.544103705108753*^9, 
   3.5441039175343256`*^9, 3.544104051912962*^9, 3.544105099689802*^9, 
   3.544105714330881*^9, 3.544105949142494*^9, 3.5441071475220003`*^9, 
   3.544591253302253*^9, 3.544591490474818*^9, 3.544591652854106*^9, 
   3.544592904670706*^9, 3.544672173166213*^9, 3.544672374605735*^9, 
   3.5446732737821646`*^9, {3.544673382250368*^9, 3.544673403030557*^9}, 
   3.544949218942625*^9, 3.5449516141922345`*^9, 3.545015662774934*^9, 
   3.5450157245666423`*^9, 3.5451061422890496`*^9, 3.545114020651421*^9, 
   3.552821195562202*^9, 3.5528226596101737`*^9, 3.5528227955956125`*^9, 
   3.552822986774948*^9, 3.552823195955715*^9, 3.5528236662965417`*^9, 
   3.552823971262478*^9, 3.552826116735245*^9, 3.552826309349784*^9, 
   3.554207271430312*^9, 3.5542084669248123`*^9, 3.56137169749762*^9, 
   3.561732586421208*^9, 3.561779198442607*^9, 3.561781488045029*^9, 
   3.5617815620359592`*^9, 3.561781652984119*^9, 3.5617819013209553`*^9, 
   3.561781933737811*^9, 3.561782101470306*^9, 3.5617821946960697`*^9, 
   3.5617823881520095`*^9, 3.561782492625393*^9, 3.561782525775451*^9, 
   3.561784234245652*^9, 3.5627666270921516`*^9, 3.562766743905157*^9, 
   3.562767082332152*^9, 3.562767893206976*^9, 3.562769545859278*^9, 
   3.562769667773493*^9, {3.562771127672857*^9, 3.562771147141691*^9}, 
   3.562773114243746*^9, 3.5627732021187005`*^9, 3.562821271865212*^9, 
   3.562822345881298*^9, 3.562823597785497*^9, 3.5628236610436087`*^9, 
   3.5628240618863134`*^9, 3.5628245986998553`*^9, 3.562825243448988*^9, 
   3.562825311823908*^9, 3.5628253718684134`*^9, 3.562825959257245*^9, 
   3.562826133915152*^9, 3.5628262479825535`*^9, 3.562828065780973*^9, 
   3.562828563952247*^9, 3.562828736550951*^9, 3.5628288787608004`*^9, 
   3.56283048955923*^9, 3.562831305206662*^9, 3.5628316999039555`*^9, 
   3.562831819774567*^9, 3.562831851723422*^9, 3.5628323082426248`*^9, 
   3.562832421623623*^9, 3.562832729256163*^9, 3.562833669876416*^9, 
   3.562833764303382*^9, 3.562833834924705*^9, 3.563425633073792*^9, 
   3.563426367211082*^9, 3.563427213607168*^9, 3.5634286994639783`*^9, 
   3.56342879150414*^9, 3.563428870221878*^9, 3.563429666557477*^9, 
   3.5641236127904387`*^9, 3.5641243459303265`*^9, 3.564124862479433*^9, 
   3.564125017685106*^9, 3.5641304421678343`*^9, 3.5646350263146267`*^9, 
   3.5646354979034553`*^9, 3.56467212988109*^9, 3.5657592878579674`*^9, 
   3.565773667042835*^9, 3.5658920237203*^9, 3.566194852736629*^9, 
   3.5662039714150715`*^9, 3.566211903872065*^9, 3.5662126407151604`*^9, 
   3.566214734067238*^9, 3.566399150366137*^9, 3.56654371261512*^9, 
   3.567082814869729*^9, 3.567185137082781*^9, 3.567586522973901*^9, 
   3.567600479678524*^9, 3.56785943828755*^9, 3.56786057086614*^9, 
   3.567861306985633*^9, 3.567861520004007*^9, 3.567861619110981*^9, 
   3.5678617158623514`*^9, 3.5678618101801176`*^9, 3.5678620356785126`*^9, 
   3.567862204798409*^9, 3.567862536502792*^9, 3.56786268353305*^9, 
   3.5678627713612046`*^9, 3.5678633203573685`*^9, 3.567863414987135*^9, 
   3.567863936620851*^9, 3.567864088800119*^9, 3.5678642538328085`*^9, 
   3.56786476702691*^9, 3.567865015862947*^9, 3.567865314884272*^9, 
   3.567865528668048*^9, 3.56787745390176*^9, 3.5679119479872937`*^9, 
   3.56791306250005*^9, 3.5679169100819855`*^9, 3.5679176765425324`*^9, 
   3.567918361213135*^9, 3.56791861483838*^9, 3.567919444713038*^9, 
   3.567919756791586*^9, 3.567924257935892*^9, 3.567926175117859*^9, 
   3.567926476931589*^9, 3.567926861503465*^9, 3.567929473982854*^9, 
   3.567929590733459*^9, 3.567929672196802*^9, 3.5679298563707256`*^9, 
   3.567930083414524*^9, 3.5679301749710855`*^9, 3.56793033669657*^9, 
   3.5679306225514727`*^9, 3.567931058587837*^9, 3.567931210610104*^9, 
   3.567931331666317*^9, 3.5679314670433555`*^9, 3.567931520084448*^9, 
   3.567931625883834*^9, 3.567931950348804*^9, 3.567932631680001*^9, 
   3.567932751254211*^9, 3.5679331257962685`*^9, 3.567933233030856*^9, 
   3.567933464223263*^9, 3.567934710229652*^9, 3.567935972070068*^9, 
   3.5681150046159573`*^9, 3.5681159084669447`*^9, 3.568122253204888*^9, 
   3.5681223553538675`*^9, 3.5681234123347235`*^9, 3.568895116817813*^9, 
   3.5688954834340563`*^9, 3.57164915620116*^9, 3.5721653898688307`*^9, 
   3.57217513556515*^9, 3.572175206716875*^9, 3.5721765243897886`*^9, 
   3.572177189848758*^9, 3.572177290609336*^9, 3.574769483219837*^9, 
   3.5823486204607644`*^9, 3.582348667370047*^9, 3.582348910402875*^9, 
   3.5830672369223785`*^9, 3.5835623435956817`*^9, 3.5835624869599338`*^9, 
   3.584196654932931*^9, 3.584767089843597*^9, 3.584767773374398*^9, 
   3.584768129148622*^9, 3.584768643856927*^9, 3.584773810043872*^9, 
   3.584774006073816*^9, 3.584774459910813*^9, 3.584774881064753*^9, 
   3.584775236199376*^9, 3.584775498513837*^9, 3.58477563652728*^9, {
   3.5847777481801896`*^9, 3.584777757914606*^9}, 3.584882231756067*^9, 
   3.5870251657944536`*^9, 3.587653682553233*^9, {3.587653767060581*^9, 
   3.587653776295798*^9}, 3.588238727747562*^9, 3.589198366102957*^9, 
   3.5901468889519696`*^9, 3.59014752106508*^9, 3.5901483299889*^9, 
   3.5901485911021595`*^9, 3.590318328507382*^9, 3.592139786164529*^9, 
   3.592140061645914*^9, 3.592140125126003*^9, 3.592140371306348*^9, 
   3.592141013237246*^9, 3.592142182118883*^9, 3.5922180775400333`*^9, 
   3.5922183769804525`*^9, 3.592218786531026*^9, 3.592219193002595*^9, 
   3.5922193658028374`*^9, 3.598170408054115*^9, 3.598188084104051*^9, 
   3.600328176209327*^9, 3.6037197608116474`*^9, 3.603719895541836*^9, 
   3.603720026722019*^9, 3.603720435182591*^9, 3.603720657992904*^9, 
   3.603720792994092*^9, 3.603720921784272*^9, 3.6037215802851954`*^9, 
   3.603721639885278*^9, 3.603722556017561*^9, 3.6070762772155037`*^9, 
   3.615127544409868*^9, 3.6151276719100456`*^9, 3.6151277716101856`*^9, 
   3.615127836090276*^9, 3.615128169237133*^9, 3.615129020508325*^9, 
   3.615129055628374*^9, 3.615129724369311*^9, 3.619615813076519*^9, 
   3.6196160414508877`*^9, 3.619616968527371*^9, 3.6196170663175077`*^9, 
   3.6196172126817603`*^9, 3.619689235636535*^9, 3.619689451760887*^9, 
   3.619689492240943*^9, 3.619689956110689*^9, 3.6196901217109213`*^9, 
   3.620539306208476*^9, 3.6208036380706577`*^9, 3.6208040779412737`*^9, 
   3.62080414701137*^9, 3.648395060605346*^9, 3.648395210345556*^9, 
   3.6800037080502386`*^9, 3.680101707555406*^9, 3.838711141412157*^9, 
   3.83871127483651*^9, 3.838805501185179*^9, 3.838882500522937*^9, 
   3.8391498907172527`*^9, 3.839151422489798*^9, 3.839671969576044*^9, 
   3.839672076450364*^9, 3.839687407635467*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"c88cdcf1-9c90-4939-9284-b0646622179d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"a1aa3723-abd9-4ab2-9aba-6c06c82b37b2"],

Cell[BoxData["\<\"xAct`SymManipulator`\"\>"], "Output",
 CellChangeTimes->{
  3.520174849587264*^9, 3.520175596168967*^9, 3.520175968653217*^9, 
   3.520176096336639*^9, 3.520176270546143*^9, 3.520176756127992*^9, 
   3.5201779237296305`*^9, 3.520177973490115*^9, 3.52017803400342*^9, 
   3.520178123281773*^9, 3.520178324090121*^9, 3.52017901040572*^9, 
   3.520179110915495*^9, 3.520179193684038*^9, 3.520179238362116*^9, 
   3.520179284893394*^9, 3.5201794639393044`*^9, 3.520179551735856*^9, 
   3.520181360255401*^9, 3.520181636677885*^9, 3.520268562661894*^9, 
   3.520268731025734*^9, 3.520268862651922*^9, 3.520268899742776*^9, 
   3.520269092078248*^9, 3.520271814280901*^9, 3.520310605257149*^9, 
   3.520310986687305*^9, 3.520311787260435*^9, 3.5203121049747124`*^9, 
   3.527144937517872*^9, 3.527145808453801*^9, 3.527146002019942*^9, 
   3.5271470230281353`*^9, 3.5271475940057387`*^9, 3.5271480469223347`*^9, 
   3.5271482642307153`*^9, 3.52714868656386*^9, 3.527150050896458*^9, 
   3.5271501730602713`*^9, 3.527150353677388*^9, 3.527150507602859*^9, 
   3.527150792038159*^9, 3.5271508653894877`*^9, 3.529230823955325*^9, 
   3.529232467137411*^9, 3.529232571813595*^9, 3.5292359095692577`*^9, 
   3.529236217576199*^9, 3.529236417256549*^9, 3.529236654642166*^9, 
   3.5292367161530747`*^9, 3.529236967254115*^9, 3.529237057749874*^9, 
   3.53406857003539*^9, 3.53406895179926*^9, 3.534069382812418*^9, 
   3.534069951932617*^9, 3.5340701770098124`*^9, 3.5342496373281627`*^9, 
   3.537621498796997*^9, 3.537621625282019*^9, 3.5376228420383573`*^9, {
   3.5376229485397434`*^9, 3.5376229644673715`*^9}, 3.5376231830393553`*^9, 
   3.537623361612869*^9, 3.5376254400377197`*^9, 3.537628789755874*^9, 
   3.5376946999678707`*^9, 3.5376948678397655`*^9, 3.537695501871679*^9, 
   3.5376955816658187`*^9, 3.537695913339001*^9, 3.537696395333048*^9, 
   3.5376971051196947`*^9, 3.537697460519519*^9, {3.537697970702815*^9, 
   3.5376979913416514`*^9}, 3.537700570794586*^9, 3.537700988781721*^9, 
   3.537701149914404*^9, 3.537705075664299*^9, 3.5377676501074886`*^9, 
   3.5377801860811076`*^9, 3.5377805840066066`*^9, 3.537780920999399*^9, 
   3.537781080010478*^9, 3.537781242094763*^9, 3.537781378236202*^9, 
   3.537781527294464*^9, 3.537781725680012*^9, 3.537782399134195*^9, 
   3.5377827399635935`*^9, 3.537782931095129*^9, 3.537783191833987*^9, 
   3.537783440639824*^9, 3.537783572943657*^9, 3.537784107977797*^9, 
   3.5377842447900376`*^9, 3.544092209377161*^9, 3.544097240436798*^9, 
   3.544097365564618*^9, 3.54409795289105*^9, 3.544099754227213*^9, 
   3.544103372842769*^9, 3.544103463962529*^9, 3.5441037051399536`*^9, 
   3.544103917549926*^9, 3.544104051944162*^9, 3.544105099705403*^9, 
   3.5441057143620815`*^9, 3.544105949173694*^9, 3.544107147537599*^9, 
   3.5445912533272552`*^9, 3.54459149050082*^9, 3.544591652882108*^9, 
   3.544592904694707*^9, 3.544672173200215*^9, 3.544672374631736*^9, 
   3.5446732738201666`*^9, {3.5446733822693696`*^9, 3.544673403063559*^9}, 
   3.544949218973825*^9, 3.5449516142078342`*^9, 3.545015662806134*^9, 
   3.545015724597842*^9, 3.54510614230465*^9, 3.545114020667021*^9, 
   3.552821195593402*^9, 3.5528226596413736`*^9, 3.5528227956268125`*^9, 
   3.552822986806148*^9, 3.5528231959713154`*^9, 3.552823666327741*^9, 
   3.5528239712936773`*^9, 3.552826116766446*^9, 3.552826309380984*^9, 
   3.554207271461512*^9, 3.554208466956012*^9, 3.5613716975132194`*^9, 
   3.561732586436807*^9, 3.561779198473807*^9, 3.561781488076228*^9, 
   3.5617815620515594`*^9, 3.561781652999718*^9, 3.561781901336555*^9, 
   3.5617819337690115`*^9, 3.5617821014859056`*^9, 3.56178219471167*^9, 
   3.56178238816761*^9, 3.561782492640993*^9, 3.561782525806651*^9, 
   3.561784234276852*^9, 3.5627666271233516`*^9, 3.5627667439363575`*^9, 
   3.562767082363351*^9, 3.562767893222576*^9, 3.5627695458748784`*^9, 
   3.562769667789092*^9, {3.562771127688457*^9, 3.562771147157291*^9}, 
   3.562773114274946*^9, 3.5627732021343*^9, 3.562821271896412*^9, 
   3.562822345912499*^9, 3.562823597801098*^9, 3.562823661059208*^9, 
   3.5628240619019136`*^9, 3.562824598715455*^9, 3.562825243480188*^9, 
   3.562825311839508*^9, 3.562825371884013*^9, 3.562825959288445*^9, 
   3.562826133930752*^9, 3.562826247998153*^9, 3.562828065812173*^9, 
   3.562828563967848*^9, 3.5628287365821505`*^9, 3.5628288787764006`*^9, 
   3.56283048957483*^9, 3.562831305222263*^9, 3.5628316999195557`*^9, 
   3.5628318197901664`*^9, 3.5628318517390227`*^9, 3.562832308258224*^9, 
   3.562832421654823*^9, 3.562832729287364*^9, 3.562833669907616*^9, 
   3.562833764334582*^9, 3.5628338349403057`*^9, 3.5634256331049924`*^9, 
   3.563426367226682*^9, 3.5634272136383686`*^9, 3.5634286994795785`*^9, 
   3.563428791535341*^9, 3.5634288702530785`*^9, 3.563429666573077*^9, 
   3.564123612821638*^9, 3.5641243459459267`*^9, 3.564124862495033*^9, 
   3.564125017716306*^9, 3.5641304421990347`*^9, 3.564635026345827*^9, 
   3.564635497934655*^9, 3.56467212991229*^9, 3.565759287889167*^9, 
   3.565773667058435*^9, 3.5658920237515*^9, 3.566194852767829*^9, 
   3.566203971430671*^9, 3.5662119038876657`*^9, 3.56621264073076*^9, 
   3.566214734082837*^9, 3.566399150397337*^9, 3.56654371263072*^9, 
   3.5670828149009295`*^9, 3.567185137098381*^9, 3.5675865230051003`*^9, 
   3.567600479694124*^9, 3.56785943830315*^9, 3.5678605708817396`*^9, 
   3.567861307001233*^9, 3.5678615200196066`*^9, 3.5678616191265807`*^9, 
   3.5678617158779516`*^9, 3.567861810195717*^9, 3.5678620356941123`*^9, 
   3.567862204798409*^9, 3.567862536518392*^9, 3.5678626835486503`*^9, 
   3.567862771376805*^9, 3.567863320372969*^9, 3.567863415002735*^9, 
   3.5678639366364512`*^9, 3.5678640888157196`*^9, 3.567864253848409*^9, 
   3.56786476704251*^9, 3.567865015862947*^9, 3.5678653148998723`*^9, 
   3.567865528683647*^9, 3.567877453917361*^9, 3.567911948002892*^9, 
   3.56791306251565*^9, 3.567916910097586*^9, 3.567917676558132*^9, 
   3.567918361213135*^9, 3.56791861485398*^9, 3.567919444728638*^9, 
   3.567919756791586*^9, 3.567924257935892*^9, 3.567926175133459*^9, 
   3.56792647694719*^9, 3.567926861519065*^9, 3.567929473998454*^9, 
   3.567929590749059*^9, 3.5679296722124033`*^9, 3.567929856386326*^9, 
   3.5679300834301248`*^9, 3.5679301749866858`*^9, 3.567930336712169*^9, 
   3.5679306225670724`*^9, 3.567931058603439*^9, 3.5679312106257052`*^9, 
   3.567931331681918*^9, 3.5679314670745554`*^9, 3.567931520100048*^9, 
   3.567931625899434*^9, 3.5679319503644047`*^9, 3.5679326316956005`*^9, 
   3.5679327512698116`*^9, 3.567933125827468*^9, 3.5679332330464573`*^9, 
   3.5679334642388625`*^9, 3.567934710245251*^9, 3.5679359720856676`*^9, 
   3.568115004631556*^9, 3.568115908482544*^9, 3.568122253220488*^9, 
   3.568122355385067*^9, 3.568123412365924*^9, 3.568895116833412*^9, 
   3.5688954834340563`*^9, 3.571649156216759*^9, 3.572165389884432*^9, 
   3.57217513558075*^9, 3.5721752067324758`*^9, 3.5721765243897886`*^9, 
   3.572177189848758*^9, 3.572177290624936*^9, 3.5747694832354374`*^9, 
   3.582348620491965*^9, 3.582348667385648*^9, 3.582348910418475*^9, 
   3.583067236937978*^9, 3.5835623436112814`*^9, 3.583562486975534*^9, 
   3.584196654948531*^9, 3.584767089859197*^9, 3.584767773389998*^9, 
   3.584768129148622*^9, 3.584768643856927*^9, 3.5847738100594716`*^9, 
   3.584774006089416*^9, 3.584774459926413*^9, 3.584774881080353*^9, 
   3.584775236214977*^9, 3.584775498529437*^9, 3.584775636542879*^9, {
   3.5847777481957893`*^9, 3.584777757930206*^9}, 3.5848822317716665`*^9, 
   3.5870251658256536`*^9, 3.587653682568833*^9, {3.587653767076182*^9, 
   3.587653776295798*^9}, 3.5882387277631617`*^9, 3.589198366118557*^9, 
   3.59014688896757*^9, 3.59014752108068*^9, 3.5901483300045*^9, 
   3.5901485911021595`*^9, 3.590318328507382*^9, 3.592139786184529*^9, 
   3.592140061655915*^9, 3.5921401251460032`*^9, 3.592140371316348*^9, 
   3.5921410132472467`*^9, 3.592142182138883*^9, 3.5922180775500336`*^9, 
   3.592218376990453*^9, 3.592218786541026*^9, 3.592219193012595*^9, 
   3.592219365832837*^9, 3.598170408074114*^9, 3.598188084124051*^9, 
   3.600328176229327*^9, 3.603719760831647*^9, 3.603719895561836*^9, 
   3.603720026742019*^9, 3.603720435192591*^9, 3.603720658002903*^9, 
   3.603720793004092*^9, 3.603720921794273*^9, 3.603721580295194*^9, 
   3.6037216399052777`*^9, 3.60372255602756*^9, 3.607076277225503*^9, 
   3.6151275444198675`*^9, 3.615127671920046*^9, 3.615127771620186*^9, 
   3.615127836090276*^9, 3.6151281692471337`*^9, 3.615129020518325*^9, 
   3.615129055638375*^9, 3.615129724369311*^9, 3.6196158130865192`*^9, 
   3.6196160414508877`*^9, 3.619616968527371*^9, 3.6196170663175077`*^9, 
   3.6196172126817603`*^9, 3.619689235646536*^9, 3.619689451770887*^9, 
   3.619689492250943*^9, 3.619689956110689*^9, 3.619690121720921*^9, 
   3.6205393062184772`*^9, 3.620803638080657*^9, 3.6208040779412737`*^9, 
   3.62080414702137*^9, 3.648395060615346*^9, 3.648395210345556*^9, 
   3.680003708060237*^9, 3.680101707565405*^9, 3.8387111422518854`*^9, 
   3.838711274878399*^9, 3.838805501234054*^9, 3.838882500575795*^9, 
   3.839149890761106*^9, 3.839151422539658*^9, 3.839671969601972*^9, 
   3.839672076479287*^9, 3.8396874076674156`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"a3bca7d3-f82b-47c5-8882-aece8acce451"]
}, Open  ]],

Cell["Established connection to external executable?", "Text",
 CellChangeTimes->{{3.419152978029696*^9, 
  3.419152995868268*^9}},ExpressionUUID->"ee9f1aab-f955-48b4-9b02-\
d94cac1bcd78"],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], "Input",
 CellChangeTimes->{{3.419152970981339*^9, 3.419152972035258*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"c2f3d2c9-a486-4b39-b615-3d56a6fd0ecc"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.520174849618465*^9, 3.520175596188966*^9, 3.520175968668816*^9, 
   3.520176096352239*^9, 3.520176270561743*^9, 3.520176756147991*^9, 
   3.5201779237452307`*^9, 3.520177973505715*^9, 3.52017803401902*^9, 
   3.520178123301774*^9, 3.520178324105721*^9, 3.52017901042572*^9, 
   3.520179110925495*^9, 3.520179193704038*^9, 3.5201792383821173`*^9, 
   3.520179284913394*^9, 3.520179463954904*^9, 3.520179551755856*^9, 
   3.520181360286601*^9, 3.520181636693485*^9, 3.520268562681895*^9, 
   3.520268731041334*^9, 3.520268862661923*^9, 3.520268899758375*^9, 
   3.520269092098248*^9, 3.5202718143009014`*^9, 3.520310605277149*^9, 
   3.5203109867029057`*^9, 3.5203117872904363`*^9, 3.520312104994713*^9, 
   3.527144937533472*^9, 3.527145808469402*^9, 3.5271460020355415`*^9, 
   3.527147023043735*^9, 3.527147594021338*^9, 3.527148046937934*^9, 
   3.527148264246315*^9, 3.52714868657946*^9, 3.527150050927658*^9, 
   3.527150173075871*^9, 3.527150353692989*^9, 3.5271505076184597`*^9, 
   3.5271507920537586`*^9, 3.527150865405088*^9, 3.529230823970925*^9, 
   3.529232467153011*^9, 3.529232571829195*^9, 3.529235909584858*^9, 
   3.529236217591799*^9, 3.529236417272149*^9, 3.529236654657767*^9, 
   3.529236716169675*^9, 3.5292369672697153`*^9, 3.5292370577654753`*^9, 
   3.53406857005099*^9, 3.53406895181486*^9, 3.5340693828436174`*^9, 
   3.534069951963816*^9, 3.534070177041013*^9, 3.534249637359363*^9, 
   3.537621498828197*^9, 3.537621625297619*^9, 3.537622842069556*^9, {
   3.537622948555344*^9, 3.537622964498571*^9}, 3.537623183054955*^9, 
   3.5376233616440687`*^9, 3.5376254400689197`*^9, 3.537628789787075*^9, 
   3.53769469999907*^9, 3.537694867870965*^9, 3.5376955018872786`*^9, 
   3.537695581681419*^9, 3.537695913354602*^9, 3.537696395348648*^9, 
   3.537697105135295*^9, 3.5376974605507193`*^9, {3.5376979707340155`*^9, 
   3.537697991357251*^9}, 3.5377005708257866`*^9, 3.537700988812921*^9, 
   3.5377011499300036`*^9, 3.5377050756954994`*^9, 3.537767650138689*^9, 
   3.537780186096708*^9, 3.537780584022207*^9, 3.5377809210149984`*^9, 
   3.537781080041678*^9, 3.5377812421259637`*^9, 3.5377813782518015`*^9, 
   3.537781527325664*^9, 3.537781725711212*^9, 3.537782399149794*^9, 
   3.537782740010394*^9, 3.537782931110729*^9, 3.537783191865187*^9, 
   3.537783440655424*^9, 3.537783572974857*^9, 3.537784107993397*^9, 
   3.537784244821237*^9, 3.544092209408361*^9, 3.544097240452398*^9, 
   3.544097365580218*^9, 3.544097952906649*^9, 3.544099754242813*^9, 
   3.544103372873969*^9, 3.544103463978129*^9, 3.544103705155553*^9, 
   3.544103917581126*^9, 3.544104051959762*^9, 3.544105099736603*^9, 
   3.5441057143776817`*^9, 3.544105949189294*^9, 3.544107147568799*^9, 
   3.544591253350256*^9, 3.5445914905248213`*^9, 3.544591652905109*^9, 
   3.5445929047197084`*^9, 3.544672173238217*^9, 3.5446723746587377`*^9, 
   3.544673273854169*^9, {3.544673382290371*^9, 3.54467340309656*^9}, 
   3.544949219005025*^9, 3.544951614239035*^9, 3.5450156628373346`*^9, 
   3.545015724629042*^9, 3.54510614233585*^9, 3.5451140206982203`*^9, 
   3.5528211956246023`*^9, 3.5528226596725736`*^9, 3.5528227956580124`*^9, 
   3.552822986837348*^9, 3.552823196002516*^9, 3.552823666358942*^9, 
   3.552823971309277*^9, 3.552826116797646*^9, 3.552826309396584*^9, 
   3.554207271492712*^9, 3.554208466987212*^9, 3.56137169754442*^9, 
   3.561732586483608*^9, 3.561779198505007*^9, 3.561781488107429*^9, 
   3.5617815620827594`*^9, 3.561781653030918*^9, 3.561781901352155*^9, 
   3.5617819337846117`*^9, 3.561782101517106*^9, 3.56178219474287*^9, 
   3.561782388183209*^9, 3.561782492656594*^9, 3.5617825258378515`*^9, 
   3.561784234308052*^9, 3.5627666271545515`*^9, 3.5627667439519577`*^9, 
   3.562767082378951*^9, 3.562767893253775*^9, 3.562769545906079*^9, 
   3.5627696678046927`*^9, {3.562771127719657*^9, 3.562771147188491*^9}, 
   3.562773114290546*^9, 3.5627732021655006`*^9, 3.5628212719276133`*^9, 
   3.5628223459280987`*^9, 3.562823597832298*^9, 3.5628236610904083`*^9, 
   3.5628240619331126`*^9, 3.5628245987310557`*^9, 3.562825243495788*^9, 
   3.5628253118551083`*^9, 3.5628253719152136`*^9, 3.562825959304045*^9, 
   3.562826133961952*^9, 3.562826248029352*^9, 3.562828065827773*^9, 
   3.5628285639990473`*^9, 3.5628287365977507`*^9, 3.5628288788076005`*^9, 
   3.56283048960603*^9, 3.562831305253463*^9, 3.562831699935156*^9, 
   3.562831819805766*^9, 3.562831851770223*^9, 3.5628323082738247`*^9, 
   3.562832421670423*^9, 3.562832729318564*^9, 3.562833669923216*^9, 
   3.562833764365782*^9, 3.562833834971506*^9, 3.5634256331361923`*^9, 
   3.563426367257882*^9, 3.563427213653969*^9, 3.563428699495178*^9, 
   3.56342879155094*^9, 3.563428870268679*^9, 3.563429666604277*^9, 
   3.564123612837238*^9, 3.564124345961526*^9, 3.564124862526234*^9, 
   3.564125017731906*^9, 3.564130442214634*^9, 3.5646350263770266`*^9, 
   3.5646354979502554`*^9, 3.56467212994349*^9, 3.565759287904766*^9, 
   3.565773667089635*^9, 3.5658920237827*^9, 3.566194852783429*^9, 
   3.566203971461871*^9, 3.566211903918866*^9, 3.566212640746361*^9, 
   3.566214734098438*^9, 3.5663991504129376`*^9, 3.566543712646321*^9, 
   3.56708281491653*^9, 3.5671851371295805`*^9, 3.5675865230207005`*^9, 
   3.567600479725324*^9, 3.56785943831875*^9, 3.56786057089734*^9, 
   3.567861307001233*^9, 3.567861520035207*^9, 3.5678616191421804`*^9, 
   3.567861715893551*^9, 3.567861810195717*^9, 3.5678620357097125`*^9, 
   3.5678622048140097`*^9, 3.567862536518392*^9, 3.56786268357985*^9, 
   3.567862771392405*^9, 3.567863320388569*^9, 3.567863415033935*^9, 
   3.5678639366520514`*^9, 3.567864088831319*^9, 3.567864253864009*^9, 
   3.56786476705811*^9, 3.5678650158785467`*^9, 3.567865314915472*^9, 
   3.567865528699248*^9, 3.56787745393296*^9, 3.5679119480184927`*^9, 
   3.56791306253125*^9, 3.567916910113186*^9, 3.567917676573732*^9, 
   3.567918361244334*^9, 3.56791861485398*^9, 3.567919444744238*^9, 
   3.567919756807186*^9, 3.567924257951492*^9, 3.56792617514906*^9, 
   3.5679264769627895`*^9, 3.567926861534665*^9, 3.567929474014055*^9, 
   3.567929590764659*^9, 3.567929672228002*^9, 3.567929856401926*^9, 
   3.5679300834457245`*^9, 3.567930175002285*^9, 3.567930336727769*^9, 
   3.567930622582671*^9, 3.567931058619037*^9, 3.5679312106413054`*^9, 
   3.567931331697517*^9, 3.567931467090155*^9, 3.5679315201156487`*^9, 
   3.5679316259150343`*^9, 3.567931950380004*^9, 3.567932631711201*^9, 
   3.5679327512698116`*^9, 3.567933125843068*^9, 3.567933233062057*^9, 
   3.567933464254463*^9, 3.567934710260851*^9, 3.567935972101268*^9, 
   3.568115004647156*^9, 3.568115908498144*^9, 3.568122253236088*^9, 
   3.568122355400667*^9, 3.568123412381524*^9, 3.568895116849013*^9, 
   3.568895483449656*^9, 3.57164915623236*^9, 3.572165389900032*^9, 
   3.5721751355963492`*^9, 3.572175206748075*^9, 3.57217652440539*^9, 
   3.572177189879959*^9, 3.572177290640537*^9, 3.574769483251037*^9, 
   3.582348620507565*^9, 3.582348667401248*^9, 3.582348910434075*^9, 
   3.583067236953578*^9, 3.583562343626881*^9, 3.583562486991134*^9, 
   3.584196654948531*^9, 3.584767089859197*^9, 3.5847677734055986`*^9, 
   3.5847681291642222`*^9, 3.584768643872526*^9, 3.5847738100594716`*^9, 
   3.584774006105016*^9, 3.584774459926413*^9, 3.584774881080353*^9, 
   3.584775236230577*^9, 3.584775498529437*^9, 3.5847756365584793`*^9, {
   3.5847777482113895`*^9, 3.584777757945806*^9}, 3.584882231787267*^9, 
   3.5870251658412538`*^9, 3.587653682584433*^9, {3.587653767091781*^9, 
   3.587653776311398*^9}, 3.588238727778762*^9, 3.589198366134157*^9, 
   3.59014688896757*^9, 3.59014752109628*^9, 3.5901483300200996`*^9, 
   3.590148591117759*^9, 3.5903183285229816`*^9, 3.5921397861945286`*^9, 
   3.592140061675915*^9, 3.592140125156003*^9, 3.5921403713263483`*^9, 
   3.592141013257247*^9, 3.592142182158883*^9, 3.5922180775800333`*^9, 
   3.592218377010453*^9, 3.5922187865710263`*^9, 3.592219193042595*^9, 
   3.5922193658428373`*^9, 3.598170408104114*^9, 3.5981880841340513`*^9, 
   3.600328176249327*^9, 3.603719760841647*^9, 3.6037198955718355`*^9, 
   3.603720026752019*^9, 3.603720435202591*^9, 3.603720658012904*^9, 
   3.603720793014092*^9, 3.603720921814273*^9, 3.603721580305194*^9, 
   3.603721639915278*^9, 3.6037225560475616`*^9, 3.607076277245503*^9, 
   3.6151275444198675`*^9, 3.615127671930046*^9, 3.615127771630185*^9, 
   3.6151278361002755`*^9, 3.6151281692471337`*^9, 3.615129020528325*^9, 
   3.615129055648375*^9, 3.6151297243793106`*^9, 3.6196158130865192`*^9, 
   3.619616041460888*^9, 3.619616968537371*^9, 3.619617066327507*^9, 
   3.61961721269176*^9, 3.619689235656536*^9, 3.619689451770887*^9, 
   3.6196894922609434`*^9, 3.619689956130689*^9, 3.619690121720921*^9, 
   3.6205393062884774`*^9, 3.620803638080657*^9, 3.620804077951273*^9, 
   3.62080414702137*^9, 3.648395060615346*^9, 3.648395210355556*^9, 
   3.680003708070237*^9, 3.680101707565405*^9, 3.8387111423346853`*^9, 
   3.8387112748883715`*^9, 3.838805501283892*^9, 3.838882500622669*^9, 
   3.839149890776067*^9, 3.839151422588527*^9, 3.839671969624918*^9, 
   3.839672076513197*^9, 3.839687407702289*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"9bff7804-9c25-4a29-ad69-60100bb671f6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. Non-standard setup", "Subsubsection",
 CellChangeTimes->{{3.4259903997539062`*^9, 
  3.425990420166374*^9}},ExpressionUUID->"e3f7add1-5207-4260-8094-\
14bae37d8975"],

Cell["Screen all dollar indices:", "Text",
 CellChangeTimes->{
  3.4232298843102837`*^9},ExpressionUUID->"b92043cd-ccbd-4d46-8a18-\
75d23e66f32a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[46]:=",ExpressionUUID->"4a39469f-9441-4bc4-a58e-97cc9f46f954"],

Cell["\<\
Timings will be shown if they are above 0.1 Second (Only for this notebook; \
this is not included in the package):\
\>", "Text",
 CellChangeTimes->{{3.5292379513058443`*^9, 
  3.5292379516490445`*^9}},ExpressionUUID->"1240b198-8ea2-43ad-a43f-\
a140f6ede4da"],

Cell[BoxData[
 RowBox[{"<<", "xAct/ShowTime1.m"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"e861049f-24b4-45f4-bbe9-e9e239829f03"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$ShowTimeThreshold", "=", "0.1"}]], "Input",
 CellChangeTimes->{{3.515938832123775*^9, 3.51593883486938*^9}, {
  3.517390968479415*^9, 3.517390975967428*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"140e200e-b1bd-4df5-abb2-74e12e5aed63"],

Cell[BoxData["0.1`"], "Output",
 CellChangeTimes->{
  3.520174849634065*^9, 3.520175596218966*^9, 3.520175968700016*^9, 
   3.520176096367839*^9, 3.5201762705773435`*^9, 3.520176756177991*^9, 
   3.5201779237608304`*^9, 3.520177973536915*^9, 3.52017803405022*^9, 
   3.520178123321774*^9, 3.520178324136921*^9, 3.52017901045572*^9, 
   3.520179110955495*^9, 3.5201791937340384`*^9, 3.520179238402116*^9, 
   3.520179284933394*^9, 3.520179463986104*^9, 3.520179551785856*^9, 
   3.520181360317802*^9, 3.520181636724685*^9, 3.520268562701894*^9, 
   3.520268731056934*^9, 3.520268862691922*^9, 3.520268899789575*^9, 
   3.520269092118248*^9, 3.520271814330901*^9, 3.520310605307149*^9, 
   3.520310986734105*^9, 3.5203117873204365`*^9, 3.520312105014713*^9, 
   3.5271449375490727`*^9, 3.5271458084850016`*^9, 3.527146002051142*^9, 
   3.527147023074935*^9, 3.5271475940369387`*^9, 3.527148046969134*^9, 
   3.527148264277516*^9, 3.5271486865950603`*^9, 3.527150050958857*^9, 
   3.527150173107071*^9, 3.5271503537085886`*^9, 3.527150507634059*^9, 
   3.527150792084958*^9, 3.527150865420687*^9, 3.529230824002125*^9, 
   3.529232467184211*^9, 3.529232571844795*^9, 3.5292359096160574`*^9, 
   3.529236217622998*^9, 3.529236417303349*^9, 3.5292366546889668`*^9, 
   3.529236716200875*^9, 3.529236967285316*^9, 3.5292370577966757`*^9, 
   3.53406857008219*^9, 3.53406895186166*^9, 3.534069382874818*^9, 
   3.5340699520106177`*^9, 3.534070177072212*^9, 3.534249637421764*^9, 
   3.537621498874997*^9, 3.5376216253444195`*^9, 3.5376228421163573`*^9, {
   3.537622948602144*^9, 3.5376229645453715`*^9}, 3.537623183101755*^9, 
   3.5376233616908693`*^9, 3.537625440100119*^9, 3.5376287898338747`*^9, 
   3.537694700045871*^9, 3.537694867917765*^9, 3.537695501934079*^9, 
   3.537695581728219*^9, 3.537695913401401*^9, 3.537696395395448*^9, 
   3.5376971051820946`*^9, 3.537697460597519*^9, {3.537697970780815*^9, 
   3.537697991404052*^9}, 3.537700570872587*^9, 3.5377009888597207`*^9, 
   3.537701149976804*^9, 3.537705075742299*^9, 3.537767650201089*^9, 
   3.537780186143508*^9, 3.537780584069007*^9, 3.537780921061799*^9, 
   3.537781080088478*^9, 3.537781242157164*^9, 3.537781378298602*^9, 
   3.5377815273724647`*^9, 3.537781725742412*^9, 3.537782399196595*^9, 
   3.5377827400571947`*^9, 3.537782931157529*^9, 3.537783191896387*^9, 
   3.5377834407178245`*^9, 3.537783573006057*^9, 3.537784108055797*^9, 
   3.537784244852437*^9, 3.544092209439561*^9, 3.544097240499198*^9, 
   3.5440973656426187`*^9, 3.5440979529534492`*^9, 3.5440997542896137`*^9, 
   3.544103372920769*^9, 3.544103464024929*^9, 3.5441037052023535`*^9, 
   3.544103917612326*^9, 3.544104051990962*^9, 3.5441050997834024`*^9, 
   3.544105714424483*^9, 3.5441059492360945`*^9, 3.544107147615599*^9, 
   3.544591253394258*^9, 3.5445914905668235`*^9, 3.544591652948112*^9, 
   3.544592904760711*^9, 3.54467217329022*^9, 3.54467237470474*^9, 
   3.5446732739081717`*^9, {3.5446733823533745`*^9, 3.544673403151563*^9}, 
   3.5449492190674257`*^9, 3.544951614270234*^9, 3.5450156628841343`*^9, 
   3.545015724660242*^9, 3.54510614236705*^9, 3.545114020745021*^9, 
   3.552821195671402*^9, 3.552822659734974*^9, 3.552822795704812*^9, 
   3.552822986899748*^9, 3.5528231960649157`*^9, 3.552823666421342*^9, 
   3.552823971387277*^9, 3.552826116844446*^9, 3.552826309443384*^9, 
   3.554207271555112*^9, 3.554208467049612*^9, 3.56137169757562*^9, 
   3.561732586514808*^9, 3.5617791985518074`*^9, 3.5617814881542287`*^9, 
   3.5617815621139593`*^9, 3.561781653062119*^9, 3.561781901414555*^9, 
   3.561781933815811*^9, 3.561782101548306*^9, 3.56178219477407*^9, 
   3.5617823882300096`*^9, 3.561782492703393*^9, 3.5617825258690515`*^9, 
   3.561784234354853*^9, 3.562766627201352*^9, 3.562766743983157*^9, 
   3.5627670824101515`*^9, 3.5627678933005753`*^9, 3.562769545937279*^9, 
   3.562769667835893*^9, {3.562771127750857*^9, 3.5627711472196918`*^9}, 
   3.562773114337346*^9, 3.5627732021967*^9, 3.5628212719588118`*^9, 
   3.562822345959298*^9, 3.562823597863498*^9, 3.5628236611216087`*^9, 
   3.562824061964313*^9, 3.562824598762256*^9, 3.562825243526988*^9, 
   3.562825311901908*^9, 3.562825371946414*^9, 3.562825959350845*^9, 
   3.562826133993151*^9, 3.562826248060553*^9, 3.562828065874573*^9, 
   3.5628285640302477`*^9, 3.562828736628951*^9, 3.562828878838801*^9, 
   3.56283048963723*^9, 3.5628313052846622`*^9, 3.562831699981956*^9, 
   3.562831819852567*^9, 3.5628318518170233`*^9, 3.5628323083206244`*^9, 
   3.562832421717223*^9, 3.562832729349764*^9, 3.5628336699856157`*^9, 
   3.562833764396982*^9, 3.562833835018306*^9, 3.563425633167393*^9, 
   3.563426367289082*^9, 3.5634272137163696`*^9, 3.563428699541979*^9, 
   3.56342879159774*^9, 3.563428870315479*^9, 3.563429666635477*^9, 
   3.564123612899638*^9, 3.564124346008326*^9, 3.564124862557433*^9, 
   3.5641250177631054`*^9, 3.5641304422614346`*^9, 3.564635026408227*^9, 
   3.564635497997055*^9, 3.56467212999029*^9, 3.565759287951567*^9, 
   3.565773667120836*^9, 3.5658920238139*^9, 3.566194852830229*^9, 
   3.566203971493071*^9, 3.566211903965666*^9, 3.566212640793161*^9, 
   3.566214734129638*^9, 3.566399150459737*^9, 3.56654371269312*^9, 
   3.5670828149633293`*^9, 3.567185137160781*^9, 3.5675865230675*^9, 
   3.567600479756524*^9, 3.5678594383343506`*^9, 3.5678605709285398`*^9, 
   3.5678613070324335`*^9, 3.5678615200664077`*^9, 3.56786161915778*^9, 
   3.567861715924751*^9, 3.5678618102269173`*^9, 3.567862035725312*^9, 
   3.56786220482961*^9, 3.567862536549592*^9, 3.5678626835954504`*^9, 
   3.567862771423605*^9, 3.567863320404169*^9, 3.5678634150495353`*^9, 
   3.567863936683251*^9, 3.567864088846919*^9, 3.5678642538796086`*^9, 
   3.5678647670893106`*^9, 3.567865015909747*^9, 3.5678653149466724`*^9, 
   3.567865528730448*^9, 3.5678774539485598`*^9, 3.567911948049692*^9, 
   3.5679130625624504`*^9, 3.5679169101443853`*^9, 3.567917676589332*^9, 
   3.567918361275535*^9, 3.56791861488518*^9, 3.5679194447598376`*^9, 
   3.567919756822786*^9, 3.567924257982692*^9, 3.567926175180259*^9, 
   3.5679264769783897`*^9, 3.567926861565865*^9, 3.567929474029654*^9, 
   3.567929590780259*^9, 3.5679296722436028`*^9, 3.5679298564331255`*^9, 
   3.567930083476925*^9, 3.5679301750334854`*^9, 3.56793033675897*^9, 
   3.5679306226138716`*^9, 3.567931058650237*^9, 3.5679312106725054`*^9, 
   3.567931331713117*^9, 3.567931467105755*^9, 3.5679315201468487`*^9, 
   3.567931625930634*^9, 3.5679319503956046`*^9, 3.5679326317268004`*^9, 
   3.56793275130101*^9, 3.5679331258586683`*^9, 3.5679332330776577`*^9, 
   3.567933464285663*^9, 3.5679347102920523`*^9, 3.567935972132468*^9, 
   3.568115004678356*^9, 3.568115908529344*^9, 3.568122253267288*^9, 
   3.5681223554474683`*^9, 3.568123412397125*^9, 3.5688951168958125`*^9, 
   3.568895483480856*^9, 3.57164915624796*^9, 3.572165389931232*^9, 
   3.57217513562755*^9, 3.572175206779275*^9, 3.5721765244365897`*^9, 
   3.5721771898955593`*^9, 3.572177290656136*^9, 3.574769483282237*^9, 
   3.5823486205231647`*^9, 3.582348667432448*^9, 3.582348910449674*^9, 
   3.583067236984778*^9, 3.583562343658081*^9, 3.583562487022333*^9, 
   3.5841966549797306`*^9, 3.584767089890397*^9, 3.584767773421198*^9, 
   3.584768129179822*^9, 3.5847686438881264`*^9, 3.584773810075072*^9, 
   3.584774006120616*^9, 3.584774459957613*^9, 3.5847748811115537`*^9, 
   3.584775236246177*^9, 3.5847754985606375`*^9, 3.584775636574079*^9, {
   3.584777748273789*^9, 3.584777757977006*^9}, 3.584882231802867*^9, 
   3.5870251659036536`*^9, 3.587653682600033*^9, {3.5876537671541815`*^9, 
   3.587653776342598*^9}, 3.588238727809963*^9, 3.589198366165357*^9, 
   3.5901468889987698`*^9, 3.59014752112748*^9, 3.590148330035701*^9, 
   3.590148591133359*^9, 3.590318328554182*^9, 3.592139786214529*^9, 
   3.5921400616859145`*^9, 3.592140125176003*^9, 3.592140371346348*^9, 
   3.592141013277246*^9, 3.5921421821788826`*^9, 3.5922180776100335`*^9, 
   3.592218377040453*^9, 3.5922187866010265`*^9, 3.5922191930925946`*^9, 
   3.592219365872837*^9, 3.5981704081341147`*^9, 3.598188084164051*^9, 
   3.600328176279328*^9, 3.6037197608616476`*^9, 3.6037198955918355`*^9, 
   3.6037200267720203`*^9, 3.603720435222591*^9, 3.603720658032904*^9, 
   3.603720793034092*^9, 3.603720921824272*^9, 3.6037215803251953`*^9, 
   3.603721639935278*^9, 3.60372255606756*^9, 3.607076277265503*^9, 
   3.6151275444498672`*^9, 3.615127671960046*^9, 3.6151277716501856`*^9, 
   3.6151278361202755`*^9, 3.615128169267133*^9, 3.6151290205583253`*^9, 
   3.615129055658375*^9, 3.615129724389311*^9, 3.6196158131065197`*^9, 
   3.6196160414808874`*^9, 3.619616968617371*^9, 3.619617066407508*^9, 
   3.6196172127717605`*^9, 3.619689235686536*^9, 3.619689451800887*^9, 
   3.6196894922809434`*^9, 3.619689956150689*^9, 3.619690121750921*^9, 
   3.6205393063084774`*^9, 3.620803638110657*^9, 3.620804078031273*^9, 
   3.62080414704137*^9, 3.648395060635346*^9, 3.6483952103855557`*^9, 
   3.680003708110237*^9, 3.6801017075854063`*^9, 3.8387111423875237`*^9, 
   3.8387112749372406`*^9, 3.838805501355701*^9, 3.838882500690488*^9, 
   3.839149890859843*^9, 3.8391514226762924`*^9, 3.8396719696757503`*^9, 
   3.83967207656805*^9, 3.839687407747169*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"f14b9e0d-2137-40b5-8f0b-aa3ed3fafe0d"]
}, Open  ]],

Cell[TextData[{
 "We also read the package (this is not automatic in ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " anymore since its version 0.6.2):"
}], "Text",ExpressionUUID->"c0fef759-3857-49da-9158-d222be134616"],

Cell[BoxData[
 RowBox[{"<<", "xAct/ExpressionManipulation.m"}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"972a4843-c720-4c82-9162-9cb0a14ca75e"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5. Usage messages", "Subsubsection",ExpressionUUID->"7d0150d9-67e0-41b3-8e4c-705b980d3912"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SymH", "::", "usage"}], "=", 
   "\"\<SymH[headlist, sym, label][indices] represents a symmetrized tensor \
expression if the product of the tensors in headlist. The imposed symmetry is \
sym, and label displayed under the symbol. Observe that traces are taken \
after the symmetrization. These operations do not generally commute unless \
they work on disjoint sets of indices.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeSym", "::", "usage"}], "=", 
   "\"\<ImposeSym[expr, inds, sym] creates a symmetrized expression \
equivalent to ImposeSymmetry[expr, inds, sym]. The result is displayed as \
SymH objects. If expr, already has the symmetry sym, expr is returned as is \
is. The output is 0 if the result due to single terms symmetries can be \
reduced to zero. Warning if expr contains traces, the resulting expression \
will be an expression where the traces are taken after the symmetization. The \
trace and symmetriation operations do not generally commute unless they work \
on disjoint sets of indices. The user needs to check that symmetrizations are \
not taken on contracted indices. Warning, ImposeSym requires expr to be \
expanded. For general expressions use ImposeSym[Expand@expr, inds, \
sym]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandSym", "::", "usage"}], " ", "=", 
   "\"\<ExpandSym[expr] expands the SymH objects in expr. If the option \
SmartExpand is used, a smaller number of terms are produced by using the \
interplay between the internal symmetry and the imposed symmetry.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveSym", "::", "usage"}], " ", "=", 
   "\"\<RemoveSym[expr] removes the SymH objects in the sence that the first \
term of ExpandSym[expr] is computed. Observe that traces of the symmetrized \
expressions are taken after the symmetrization. The trace and symmetriation \
operations do not generally commute unless they work on disjoint sets of \
indices. The user needs to check that symmetrizations are not taken on \
contracted indices.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveSuperfluousSym", "::", "usage"}], " ", "=", 
   "\"\<RemoveSuperfluousSym[expr] if an expression inside a SymH object \
already has the imposed symmetry, the extra symmetrization will be removed.\>\
\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveSuperfluousInnerSym", "::", "usage"}], " ", "=", 
   "\"\<RemoveSuperfluousInnerSym[expr] if an expression has nested SymH \
symbols, and an inner symmetrization is a part of an outer symmetrization, \
the inner symmetrization will be removed. For instance if an expression is \
symmetrized over slot 1 and 2, and then symmetrized over slots 1, 2, and 3, \
then the symmetrization over slot 1 and 2 can be removed.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveTrivialSym", "::", "usage"}], " ", "=", " ", 
   "\"\<RemoveTrivialSym[expr] replaces SymH objects in expr with 0 if they \
vanish due to single terms symmetries.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MoveTensorsOutsideSym", "::", "usage"}], " ", "=", 
   "\"\<MoveTensorsOutSideSym[expr] moves all tensors that are not part of \
the symmetry outside the SymH object.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MoveTensorsInsideSym", "::", "usage"}], " ", "=", " ", 
   "\"\<MoveTensorsInsideSym[expr] moves all tensors that inside the SymH \
object.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CanonicalizeGroupInSym", "::", "usage"}], " ", "=", 
   "\"\<CanonicalizeGroupInSym[expr] finds a canonical representaion of all \
SymH objects. Observe that the indices are not canonicalized, so the correct \
usage for complete canonicalization is \
ToCanonical@CanonicalizeGroupInSym[expr].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SubgroupQ", "::", "usage"}], " ", "=", 
   "\"\<SubgroupQ[sym1, sym2] returns true iff sym1 is a subgroup of \
sym2.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CompatibleSymmetric", "::", "usage"}], " ", "=", 
   "\"\<CompatibleSymmetric[inds] splits inds into sets accoring to vbundle. \
The result is then the disjoint union of the symmetric groups on these \
sets.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandSymOneIndex", "::", "usage"}], " ", "=", 
   "\"\<ExpandSymOneIndex[expr, ExpansionIndex] expands expr so that \
ExpansionIndex is not part of the symmetry.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InertHeadHead", "::", "usage"}], "=", 
   "\"\<InertHeadHead[inerthead, tensorh] a representaiton of a tensor head \
such that InertHeadHead[H1,T][inds]=H1[T[inds]].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CovarD", "::", "usage"}], " ", "=", 
   "\"\<CovarD[CD, tensorh ,slotlist] a representaiton of a tensor head such \
that CovarD[CD,T,{-a,-b,...}][inds]=CD[-a, -b,...][T[inds]]].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZeroTensor", "::", "usage"}], " ", "=", 
   "\"\<ZeroTensor[slotlist_] is a representation of the zero tensor with \
slots defined by slotlist. That is ZeroTensor[{TangentM, ...}][-a, \
...]=0.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorToZeroRule", "::", "usage"}], "=", 
   "\"\<TensorToZeroRule[tensorhead] makes a replacement rule \
tensorhead->ZeroTensor[slotlist] with the aproproate slotlist.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MoveSymIndicesDown", "::", "usage"}], " ", "=", 
   "\"\<MoveSymIndicesDown[expr] moves the indices in the SymH objects so \
that the symmetrized indices are in a down position. This position is \
required for a good TexPrint output. Warning, this function requires that all \
indices can be moved with the metric. This check is not done automatically.\>\
\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortTensorsInSym", "::", "usage"}], " ", "=", " ", 
   "\"\<SortTensorsInSym[expr] sorts the tensors in the SymH objects \
alphabetically.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IrrDecompose", "::", "usage"}], " ", "=", " ", 
   "\"\<IrrDecompose[expr] computes the irreducible decomposition of over all \
spinor indices.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CompleteIrrDecompose", "::", "usage"}], " ", "=", " ", 
   "\"\<CompleteIrrDecompose[expr] computes the irreducible decomposition of \
over all spinor indices. The symmetries of expr is then imposed on the \
resulting expression. This can also be done with the option UseSym in \
IrrDecompose.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UseSym", "::", "usage"}], "=", 
   "\"\<UseSym is an option for IrrDecompose. If this option is set to True, \
then the symmetries of the expression is omposed on the decomposed \
expression. This often simplifies the expression.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IrrDecImposeNewMethod", "::", "usage"}], " ", "=", 
   "\"\<An option for IrrDecompose.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ResultType", "::", "usage"}], "=", 
   "\"\<An option for IrrDecompose. The default is\\\"Expression\\\". Other \
possibilities are \\\"Equation\\\", \\\"Rule\\\" or \
\\\"CompareRule\\\".\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InternalCommutingSymmetry", "::", "usage"}], " ", "=", " ", 
   "\"\<InternalCommutingSymmetry is a tag that describes the part of the \
internal symmetry of a SymH object that commutes with the imposed symmetry.\>\
\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SmartExpand", "::", "usage"}], " ", "=", 
   "\"\<An option for ExpandSym.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeLargerSym", "::", "usage"}], " ", "=", 
   "\"\<An option for ImposeSym.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeSuperfluousSym", "::", "usage"}], " ", "=", 
   "\"\<An option for ImposeSym.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"deltaH", "::", "usage"}], " ", "=", 
   "\"\<deltaH[vbundle] is the delta on the vector bundle vbundle.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ContractMetricsInsideSym", "::", "usage"}], " ", "=", 
   "\"\<ContractMetricsInsideSym[expr] checks if any SymH object has a metric \
inside that can be contracted, and contracting this.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SmartSymmetrize", "::", "usage"}], " ", "=", 
   "\"\<Does the same thing as Symmetrize, but reducing the number of terms \
due to the internal symmetry.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SmartAntisymmetrize", "::", "usage"}], " ", "=", 
   "\"\<Does the same thing as Antisymmetrize, but reducing the number of \
terms due to the internal symmetry.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandInternalSym", "::", "usage"}], "=", 
   "\"\<Applies ExpandSym to the internal expression of a SymH object.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToCanonicalSym", "::", "usage"}], "=", 
   "\"\<Runs CanonicalizeGroupInSym followed by ToCanonical.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RuleInSym", "::", "usage"}], " ", "=", 
   "\"\<Applies a rule inside a SymH object. Observe that this can \
decanonicalize all SymH objects.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FunctionInSym", "::", "usage"}], "=", 
   "\"\<Applies a function inside a SymH object. Observe that this can \
decanonicalize all SymH objects.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$MixedSymSpecialCode", "::", "usage"}], " ", "=", " ", 
   "\"\<Default True, General code False. Old behaviour SetStabilizer. \
Observe that SetStabilizer gives only a subgroup of the correct group, but it \
is faster.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TransversalInSymmetricGroup", "::", "usage"}], " ", "=", 
   "\"\<TransversalInSymmetricGroup[H_StrongGenSet,G_Symmetric] computes the \
transversal of H in G. If H is not a subgroup, an error is thrown. (Not \
tested well.)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$MixedSymVerbose", "::", "usage"}], " ", "=", 
   "\"\<Display timing info from MixedSymmetry calculations.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryOfExpression", "::", "usage"}], " ", "=", 
   "\"\<SymmetryOfExpression[expr] computes the symmetry group of the free \
indices of expr and returns a strong generating set and a list of the free \
indices.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeCompareRule", "::", "usage"}], " ", "=", " ", 
   "\"\<MakeCompareRule is used in the same way as MakeRule, but only one \
rule is generated. When applied to an expression, it is compared to the LHS. \
If a match is found it is replaced by the corresponding RHS. At the moment \
the LHS can only be a single tensor, a product of tensors, or a covariant \
derivative of a single tensor.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CompatibleSymQ", "::", "usage"}], " ", "=", 
   "\"\<CompatibleSymQ[vbundles, sym] returns true if the total symmetry is a \
subgroup of sym. Each vbundle gives a symmetric group. The total symmetry if \
the union of these groups. Signs of vbundles are dropped before the rest of \
the computation.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveSuperfluousPartialSym", "::", "usage"}], " ", "=", " ", 
   "\"\<Tries to factor the imposed group, and remove superfluous factors. It \
is also an option for ToCanonicalSym.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IrrDecSpinBundles", "::", "usage"}], " ", "=", 
   "\"\<An option for IrrDecompose and CompleteIrrDecompose.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandBox", "::", "usage"}], " ", "=", 
   "\"\<ExpandBox[expr,CDe] converts the BoxCDe in expr to curvature.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefFundSpinOperators", "::", "usage"}], " ", "=", 
   "\"\<DefFundSpinOperators[CDe] defines the operators DivCDe, CurlCDe, \
CurlDgCDe and TwistCDe what acts on symmetric spinors. Also commutator rules \
like CommuteDivCurlCDe are defined.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HideCovDSymbolReference", "::", "usage"}], "=", 
   "\"\<HideCovDSymbolReference is an option for DefFundSpinOperators. If set \
to True, the default PrintAs command for the derived symbols will not contain \
a bracket with the covd symbol.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ShowValenceInfo", "::", "usage"}], "=", 
   "\"\<ShowValenceInfo is an option for DefFundSpinOperators. If set to \
True, the default PrintAs command for the operators will contain numbers \
indicating the valence of the spinor it acts on.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefFundSpinOperators", "::", "usage"}], " ", "=", 
   "\"\<UndefFundSpinOperators[CDe] undefines all objects defined by \
DefFundSpinOperators[CDe].\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FundSpinOpQ", "::", "usage"}], "=", 
   "\"\<FundSpinOpQ[op] returns True if the symbol op is a fundamental spinor \
operator.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CovDOfFundSpinOp", "::", "usage"}], "=", 
   "\"\<CovDOfFundSpinOp[op] returns the covariant derivative associated with \
the fundamental spinor operator op.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeFundSpinOp", "::", "usage"}], "=", 
   "\"\<ImposeFundSpinOp[expr, op, {inds}] applies the fundamental spinor \
operator op to expr and gives the result the indices inds.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandFundSpinOp", "::", "usage"}], "=", 
   "\"\<ExpandFundSpinOp[expr, covd] expands the fundamental spinor operators \
related to covd into symmetrized derivatives.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FunctionInFundSpinOp", "::", "usage"}], "=", 
   "\"\<FunctionInFundSpinOp[expr, func, l, outerfunc] applies the function \
func, inside the fundamental spinor operators at level l. The optional \
function outerfunc is applied to the results at all lower levels. The default \
level is 1 and the default outerfunc is Identity.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IrrDecomposeCovD", "::", "usage"}], "=", 
   "\"\<IrrDecomposeCovD[covd[...]@T[...]] produces the irreducible \
decomposition of covd[...]@T[...] using the corresponding fundamental \
operators.\nIrrDecomposeCovD[T, covd] does the same, but you do not have to \
give any indices.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToFundSpinOp", "::", "usage"}], "=", 
   "\"\<ToFundSpinOp[expr, covd] tries to represent all covariant spinor \
derivatives in expr in terms of the fundamental spinor operators. When \
several nested derivatives appear, one might need to apply the function \
several times.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteFundSpinOp", "::", "usage"}], "=", 
   "\"\<CommuteFundSpinOp[op1,op2] gives the commutator rule for the \
fundamental spinor operators op1, op2. Observe that this function only gives \
the proper commutator relations. There are other commutator like relations \
with two derivative terms in the right hand side. \
CommuteFundSpinOp[op1,op2,op3,op4] gives a commutator like rule where \
op1[op2[expr]] is turned into an expression with a term op3[op4[expr]] if \
possible.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GetIndexRange", "::", "usage"}], "=", 
   "\"\<GetIndexRange[k, vbundle] gives the first k indices of vbundle. New \
indices are constructed if needed.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GiveIndicesToTensor", "::", "usage"}], " ", "=", 
   "\"\<GiveIndicesToTensor[TT] gives the tensor TT down indices in the \
correct vbundles. A list of vbundles can be given as a second argument. \
Indices in these vbundles will then be up indices.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChangeFreeIndicesToDefault", "::", "usage"}], " ", "=", 
   "\"\<ChangeFreeIndicesToDefault[expr] changes the free indices of expr. \
The indices are taken from the beginning of the list of indices for the \
corresponding VBundle. A list of VBundles can be given as a second argument. \
Free indices belonging to these VBundles are given up indices. The default is \
that all new free indices are down. The dummy indices are also \
changed.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MoveCovDInsideSym", "::", "usage"}], "\[Equal]", 
   "\"\<MoveCovDInsideSym is a rule that moves covariant derivatives inside \
SymH objects.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindTensorCoefficients", "::", "usage"}], "\[Equal]", 
   "\"\<FindTensorCoefficients[expr,{T1[...], T2[...]T3[...]}] finds the \
coefficients of the tensor expressions T1[...] and T2[...]T3[...] in expr. \
The result is a list of the form {{rest, 1},{c1, T1[...]},{c2, \
T2[...]T3[...]}}. Plus@@Times@@@FindTensorCoefficients[expr, {...}] is \
equivalent to expr, but with tensors collected.\>\""}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpatialSpinCovDQ", "::", "usage"}], " ", "=", 
   "\"\<SpatialSpinCovDQ Reserved for spatial spinors.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PlaceIndicesInTensor", "::", "usage"}], " ", "=", 
   "\"\<PlaceIndicesInTensor[T,{inds}] places the indices inds in their \
correct positions in the tensor T, where the correct positions are given by \
SlotsOfTensor.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ValenceNumbersOfSpinor", "::", "usage"}], "=", 
   "\"\<ValenceNumbersOfSpinor[T, Spin], gives a list {k,l} where k is the \
number of Spin slots and l is the number of Spin\[Dagger] slots of the spinor \
T.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IndepIrrDecompose", "::", "usage"}], "=", 
   "\"\<IndepIrrDecompose[expr, options] computes the irreducible \
deomposition of expr, tries to find relations between the irreducible parts, \
and reduces the expression with respect to these relations. If all such \
relations wever found the remainign irreducible parts should be independent. \
However, the algorithm is not analysed for completeness, so this can not be \
guanranteed of several irreducible pieces have the same valence.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindSpinorsInIrrDec", "::", "usage"}], "=", 
   "\"\<FindSpinorsInIrrDec[expr, {\[Epsilon], \[Epsilon]\[Dagger]}] gives \
the irreducible parts of expr assuming that expr is the result of \
IrrDecompose or IndepIrrDecompose.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefIrreducibleSpinors", "::", "usage"}], "=", 
   "\"\<DefIrrDecSpinors[irrdecspinors, basename, baseprintas ,spin]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EqToCompareRule", "::", "usage"}], "=", 
   "\"\<EqToCompareRule[eq] takes an equation eq and tranforms it into a \
replacement rule with MakeCompareRule.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtractUnprimedAndPrimed", "::", "usage"}], "=", 
   "\"\<ExtractUnprimedAndPrimed[Spin] returns a function that extract the \
unprimed and primed indices from a list.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NumOfUnprimedVBundles", "::", "usage"}], "=", 
   "\"\<NumOfUnprimedVBundles[Spin] returns a function that counts the number \
of unprimed spin bundles in a list.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NumOfPrimedVBundles", "::", "usage"}], "=", 
   "\"\<NumOfPrimedVBundles[Spin] returns a function that counts the number \
of primed spin bundles in a list.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NumOfUnprimedSlots", "::", "usage"}], "=", 
   "\"\<NumOfUnprimedSlots[Spin] returns a function that counts the number of \
unprimed slots of a spinor.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NumOfPrimedSlots", "::", "usage"}], "=", 
   "\"\<NumOfPrimedSlots[Spin] returns a function that counts the number of \
primed slots of a spinor.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NumOfUnprimedSlotsDyad", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NumOfPrimedSlotsDyad", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetricSpinorOfValenceQ", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "::", "usage"}], "=", 
   "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandSymS", "::", "usage"}], "=", 
   "\"\<ExpandSymS[expr] is a shorthand for ExpandSym[expr, \
SmartExpand\[Rule]True]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EnoughIndsQSpin", "::", "usage"}], "=", 
   "\"\<EnoughIndsQSpin[T,k,l,Spin] returns True if the spinor T has at least \
k unprimed and l primed indices with respect to the spin bundle Spin.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetricOfValence", "::", "usage"}], "=", 
   "\"\<SymmetricOfValence[k,l,spin,ovb] gives the slot VBundles of a \
symmetric spinor of valence k,l, possibly with extra VBundles ovb.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZeroTensorOfTensor", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EqToRule", "::", "usage"}], "=", 
   "\"\<EqToRule[lhs == rhs] transforms the equation into an rule using \
MakeRule. This is used for indexed expressions assuming that lhs only \
contains one term.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FlipEquation", "::", "usage"}], "=", 
   "\"\<FlipEquation[lhs == rhs] flips the lhs and rhs. If rhs contains a \
constant factor, the equation is divided by this constant.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Isolate", "::", "usage"}], "=", 
   "\"\<Isolate[eq, p] tries to rewrite the equation eq so that the pattern p \
becomes the left hand side.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744873041342*^9, 3.515744875786498*^9}, {
   3.515752357772452*^9, 3.515752485805774*^9}, {3.515752530513332*^9, 
   3.515752580994219*^9}, {3.515752792292305*^9, 3.515752843418229*^9}, {
   3.515752909483008*^9, 3.5157530669740157`*^9}, {3.515753114096711*^9, 
   3.5157531288345537`*^9}, {3.515753177796355*^9, 3.5157531884669647`*^9}, {
   3.515754350630437*^9, 3.5157544018233647`*^9}, {3.515754521818228*^9, 
   3.515754543948494*^9}, {3.5157551839040966`*^9, 3.515755185479187*^9}, {
   3.515756679933959*^9, 3.5157567010719976`*^9}, 3.515817672587903*^9, {
   3.515819570034835*^9, 3.515819583825259*^9}, {3.516080973625267*^9, 
   3.5160810939411483`*^9}, {3.51608742753641*^9, 3.516087441747223*^9}, {
   3.516427897898315*^9, 3.516427925769909*^9}, {3.516767566705311*^9, 
   3.516767724252322*^9}, {3.516767786053857*^9, 3.516768041993496*^9}, {
   3.516768087065074*^9, 3.516768204604797*^9}, {3.516768235956589*^9, 
   3.516768382185954*^9}, {3.516768430100694*^9, 3.516768447764704*^9}, {
   3.516768491947232*^9, 3.516768564590387*^9}, {3.516768610219996*^9, 
   3.516768643946925*^9}, {3.5167687187662053`*^9, 3.5167687431966023`*^9}, {
   3.516768783753922*^9, 3.516768821436077*^9}, {3.516769431673981*^9, 
   3.516769454367279*^9}, {3.516769555066039*^9, 3.516769568013779*^9}, {
   3.516769607622044*^9, 3.516769737645481*^9}, {3.5167697693372946`*^9, 
   3.516769863248666*^9}, {3.5167699172817564`*^9, 3.516769989810904*^9}, {
   3.516770032231331*^9, 3.516770071396571*^9}, {3.516770112180904*^9, 
   3.516770239339177*^9}, {3.517388530248932*^9, 3.5173885520577717`*^9}, {
   3.5173885834138246`*^9, 3.5173887285096807`*^9}, {3.517388783686978*^9, 
   3.517388799536605*^9}, {3.517388855025903*^9, 3.5173890999931326`*^9}, {
   3.5173891951689*^9, 3.517389218756141*^9}, {3.51738925747541*^9, 
   3.5173892724670362`*^9}, {3.5173893172547145`*^9, 3.517389505367445*^9}, {
   3.517389536458299*^9, 3.517389536988701*^9}, {3.517389585021185*^9, 
   3.517389590730795*^9}, {3.51738969585938*^9, 3.517389754531083*^9}, {
   3.517389804887971*^9, 3.5173900811644573`*^9}, {3.517390121412527*^9, 
   3.5173903801233816`*^9}, {3.5173904199346514`*^9, 3.517390531755648*^9}, {
   3.5174725116140275`*^9, 3.517472608037797*^9}, {3.5175604707467995`*^9, 
   3.517560532507308*^9}, {3.517836544687015*^9, 3.517836560076895*^9}, {
   3.5178368202007732`*^9, 3.517836841925016*^9}, {3.518950541449158*^9, 
   3.518950640509332*^9}, {3.518958798714661*^9, 3.518958922455079*^9}, {
   3.5189589533743334`*^9, 3.518959032903272*^9}, {3.5190135857193613`*^9, 
   3.519013596608181*^9}, {3.529236186251344*^9, 3.52923619565816*^9}, {
   3.534069228699747*^9, 3.534069341238344*^9}, {3.534250091632161*^9, 
   3.534250113128999*^9}, {3.537696927512383*^9, 3.537696927855583*^9}, {
   3.537780075180513*^9, 3.5377801410282288`*^9}, {3.544103304483449*^9, 
   3.544103344528719*^9}, {3.544104665368439*^9, 3.544104681670469*^9}, {
   3.5441056394975505`*^9, 3.544105640012351*^9}, {3.5446731227805276`*^9, 
   3.544673140426537*^9}, {3.54467318541111*^9, 3.544673244912514*^9}, {
   3.560944870073998*^9, 3.5609449402897215`*^9}, {3.560945062734337*^9, 
   3.560945130438455*^9}, {3.561368684507327*^9, 3.561368737937421*^9}, {
   3.564124565517311*^9, 3.5641246654978876`*^9}, {3.5679259868567286`*^9, 
   3.567926070535276*^9}, {3.567926379961819*^9, 3.5679263819274235`*^9}, {
   3.567926422627894*^9, 3.567926445996735*^9}, {3.5679291740099277`*^9, 
   3.5679292391712418`*^9}, {3.567931718407596*^9, 3.56793176575368*^9}, {
   3.56812296074413*^9, 3.5681230069826126`*^9}, {3.569584094449659*^9, 
   3.569584123153709*^9}, {3.574769007776802*^9, 3.5747690796461287`*^9}, 
   3.58488267211364*^9, {3.584882998871814*^9, 3.584883035890679*^9}, {
   3.584883080927958*^9, 3.584883183825739*^9}, {3.584883254650863*^9, 
   3.584883387890698*^9}, {3.586838876303985*^9, 3.586838933150485*^9}, {
   3.58683896425694*^9, 3.58683903905907*^9}, {3.586839071569528*^9, 
   3.586839490383464*^9}, {3.587025088137517*^9, 3.5870251380420046`*^9}, {
   3.587025785957943*^9, 3.587025786831544*^9}, 3.587025840246038*^9, {
   3.58702588670292*^9, 3.587025887342521*^9}, {3.587025922224182*^9, 
   3.587026037665385*^9}, {3.5870265436054745`*^9, 3.5870265544006934`*^9}, {
   3.587653230409638*^9, 3.5876532947451515`*^9}, {3.588066829761789*^9, 
   3.5880668577950397`*^9}, {3.589198044711192*^9, 3.589198143256565*^9}, {
   3.589198190509048*^9, 3.589198215827893*^9}, {3.589198252581558*^9, 
   3.589198306916453*^9}, {3.590213398184806*^9, 3.590213498312533*^9}, {
   3.5902135837104177`*^9, 3.5902137863840094`*^9}, {3.590490370431815*^9, 
   3.590490634002184*^9}, {3.5910966672041397`*^9, 3.5910966673441396`*^9}, {
   3.592141821418378*^9, 3.592142115258788*^9}, {3.592218548630694*^9, 
   3.592218743600966*^9}, {3.5922189160312066`*^9, 3.592218921251215*^9}, {
   3.592219040622382*^9, 3.592219147762532*^9}, {3.592222857158725*^9, 
   3.592222879848757*^9}, {3.5922272542598825`*^9, 3.5922273432400074`*^9}, {
   3.59222743118013*^9, 3.5922274313601303`*^9}, {3.597209549000863*^9, 
   3.5972095527760696`*^9}, {3.5972096981215253`*^9, 
   3.5972097016939316`*^9}, {3.597210093207819*^9, 3.5972101640007434`*^9}, {
   3.598170233043869*^9, 3.598170318283988*^9}, {3.598170350744034*^9, 
   3.5981703554240403`*^9}, {3.598179478696947*^9, 3.598179707307267*^9}, {
   3.5981814735017414`*^9, 3.5981815282918186`*^9}, {3.5981815770818872`*^9, 
   3.598181649551988*^9}, {3.598182517643203*^9, 3.598182588943303*^9}, {
   3.598183200415159*^9, 3.598183238825213*^9}, {3.598188579084744*^9, 
   3.598188632714819*^9}, {3.5981886684348693`*^9, 3.598188841475112*^9}, {
   3.598188874785158*^9, 3.5981888754651594`*^9}, {3.598188988635318*^9, 
   3.598189003785339*^9}, {3.5981890392453885`*^9, 3.598189128705514*^9}, {
   3.599302413958943*^9, 3.5993024639090137`*^9}, {3.599549325829242*^9, 
   3.599549439506642*^9}, {3.680003200356803*^9, 3.680003362838679*^9}, {
   3.6800046577774434`*^9, 3.680004762057444*^9}, {3.680089360241606*^9, 
   3.6800894672017555`*^9}, {3.680089508541814*^9, 3.6800897424521422`*^9}, {
   3.680089966072455*^9, 3.6800901483837094`*^9}, {3.680090611794359*^9, 
   3.68009065555442*^9}, {3.680101561875201*^9, 3.680101615825277*^9}, {
   3.680103675944481*^9, 3.680103736254566*^9}, 3.685192607054861*^9, {
   3.838804041507916*^9, 3.8388040635349965`*^9}, {3.838804473987985*^9, 
   3.838804508299176*^9}, {3.839127483036377*^9, 3.839127529875166*^9}, {
   3.839127562964115*^9, 3.839127577956566*^9}, {3.839127619941742*^9, 
   3.83912765331566*^9}, {3.839127691532366*^9, 3.839127806598121*^9}, {
   3.8391291393245*^9, 3.839129232190213*^9}, {3.839147962558802*^9, 
   3.839148057465069*^9}, {3.839150987452055*^9, 3.839150996270508*^9}, {
   3.839155390435002*^9, 3.839155394979852*^9}, {3.839686512020554*^9, 
   3.839686723213264*^9}, {3.839686780852948*^9, 3.839686921037285*^9}, {
   3.839687028660605*^9, 3.8396871435651245`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"eaea7ac9-43b3-4fe1-8533-c9d69de6c759"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.6. Begin private", "Subsubsection",ExpressionUUID->"6c2d635a-c7a0-4bcf-b976-63022a93d9eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[135]:=",ExpressionUUID->"2f22132c-0823-4509-b10e-29d9773e3e75"],

Cell[BoxData["\<\"xAct`SymManipulator`Private`\"\>"], "Output",
 CellChangeTimes->{
  3.520174849805665*^9, 3.520175596378967*^9, 3.520175968902817*^9, 
   3.520176096523839*^9, 3.520176270733343*^9, 3.520176756317992*^9, 
   3.520177923916831*^9, 3.520177973692915*^9, 3.52017803420622*^9, 
   3.5201781234817743`*^9, 3.5201783242929215`*^9, 3.5201790106057205`*^9, 
   3.5201791111454954`*^9, 3.5201791938840384`*^9, 3.520179238562116*^9, 
   3.5201792850933948`*^9, 3.520179464142104*^9, 3.520179551935856*^9, 
   3.5201813604738016`*^9, 3.520181636880685*^9, 3.520268562871895*^9, 
   3.5202687312285337`*^9, 3.520268862851923*^9, 3.5202688999455757`*^9, 
   3.520269092278248*^9, 3.520271814500901*^9, 3.5203106054671497`*^9, 
   3.5203109869057055`*^9, 3.5203117874904366`*^9, 3.520312105174713*^9, {
   3.52714493626987*^9, 3.527144937705072*^9}, 3.527145808625402*^9, 
   3.527146002191542*^9, 3.527147023215336*^9, 3.527147594177339*^9, 
   3.5271480471095347`*^9, 3.527148264417916*^9, 3.5271486867510605`*^9, 
   3.527150051130457*^9, 3.527150173247472*^9, 3.5271503538489885`*^9, 
   3.527150507774459*^9, 3.5271507922253594`*^9, 3.527150865561088*^9, 
   3.529230824158125*^9, 3.5292324673090115`*^9, 3.5292325720007954`*^9, 
   3.529235909756458*^9, 3.529236217747799*^9, 3.529236417443749*^9, 
   3.529236654844967*^9, 3.5292367163412747`*^9, 3.5292369674257154`*^9, 
   3.5292370579370756`*^9, 3.53406857025379*^9, 3.534068952002061*^9, 
   3.5340693830464177`*^9, 3.534069952166618*^9, 3.534070177212613*^9, 
   3.534249637593364*^9, 3.5376214990465975`*^9, 3.53762162551602*^9, 
   3.537622842272357*^9, {3.537622948742544*^9, 3.537622964716972*^9}, 
   3.5376231832577553`*^9, 3.5376233618468695`*^9, 3.53762544027172*^9, 
   3.537628790021075*^9, 3.537694700217471*^9, 3.5376948680737658`*^9, 
   3.537695502074479*^9, 3.537695581868619*^9, 3.537695913573002*^9, 
   3.537696395567048*^9, 3.537697105353695*^9, 3.5376974607535195`*^9, {
   3.5376979709212155`*^9, 3.537697991575652*^9}, 3.5377005710441866`*^9, 
   3.5377009890469213`*^9, 3.537701150148404*^9, 3.5377050758982997`*^9, 
   3.537767650388289*^9, 3.537780186299508*^9, 3.537780584225007*^9, 
   3.537780921233399*^9, 3.537781080244478*^9, 3.537781242313163*^9, 
   3.537781378470202*^9, 3.537781527544064*^9, 3.5377817259140134`*^9, 
   3.537782399368195*^9, 3.537782740213194*^9, 3.53778293129793*^9, 
   3.537783192083587*^9, 3.537783440889425*^9, 3.537783573177657*^9, 
   3.537784108196197*^9, 3.5377842450240383`*^9, 3.5440922096267614`*^9, 
   3.5440972412636*^9, 3.544097365798619*^9, 3.5440979531094494`*^9, 
   3.544099754461214*^9, 3.5441033730923696`*^9, 3.54410346418093*^9, 
   3.544103705373953*^9, 3.544103917783926*^9, 3.5441040521625633`*^9, 
   3.5441050999394026`*^9, 3.544105714611682*^9, 3.544105949423295*^9, 
   3.5441071477716*^9, 3.544591253566268*^9, 3.544591490719833*^9, 
   3.544591653118121*^9, 3.54459290492672*^9, 3.54467217346423*^9, 
   3.54467237487175*^9, 3.544673274102183*^9, {3.5446733824803815`*^9, 
   3.544673403328574*^9}, 3.544949219239026*^9, 3.544951614426235*^9, 
   3.545015663024534*^9, 3.545015724831843*^9, 3.545106142523051*^9, 
   3.545114020916621*^9, 3.552821195843002*^9, 3.552822659906574*^9, 
   3.5528227958920126`*^9, 3.552822987071349*^9, 3.552823196220916*^9, 
   3.552823666592942*^9, 3.552823971558878*^9, 3.552826117016046*^9, 
   3.5528263095837836`*^9, 3.554207271726712*^9, 3.5542084672368126`*^9, 
   3.56137169774722*^9, 3.561732586702008*^9, 3.5617791987390075`*^9, 
   3.561781488357029*^9, 3.5617815622855597`*^9, 3.561781653249319*^9, 
   3.561781901554955*^9, 3.5617819339874115`*^9, 3.561782101735506*^9, 
   3.5617821949612703`*^9, 3.56178238840161*^9, 3.561782492874994*^9, 
   3.5617825260562515`*^9, 3.561784234526453*^9, 3.562766627372952*^9, 
   3.562766744170357*^9, 3.562767082597352*^9, 3.562767893456577*^9, 
   3.562769546124479*^9, 3.562769668007493*^9, {3.562771127922457*^9, 
   3.562771147406891*^9}, 3.562773114493346*^9, 3.562773202368301*^9, 
   3.5628212721616135`*^9, 3.5628223461308985`*^9, 3.562823598019498*^9, 
   3.562823661308809*^9, 3.562824062135913*^9, 3.562824598933856*^9, 
   3.562825243698588*^9, 3.562825312089108*^9, 3.562825372118014*^9, 
   3.562825959538046*^9, 3.562826134164752*^9, 3.562826248247753*^9, 
   3.5628280660617733`*^9, 3.562828564201848*^9, 3.5628287368005514`*^9, 
   3.562828879026001*^9, 3.56283048979323*^9, 3.562831305440663*^9, 
   3.562831700153556*^9, 3.562831819977367*^9, 3.562831852019823*^9, 
   3.5628323084766245`*^9, 3.562832421888824*^9, 3.5628327295369644`*^9, 
   3.5628336701728168`*^9, 3.562833764584183*^9, 3.5628338352055063`*^9, 
   3.563425633354593*^9, 3.563426367460682*^9, 3.563427213887969*^9, 
   3.5634286997135787`*^9, 3.563428791784941*^9, 3.563428870471479*^9, 
   3.5634296668070784`*^9, 3.5641236130712385`*^9, 3.564124346179926*^9, 
   3.564124862744633*^9, 3.5641250179347057`*^9, 3.564130442417435*^9, 
   3.5646350265954275`*^9, 3.564635498137456*^9, 3.564672130161891*^9, 
   3.565759288123167*^9, 3.5657736672768354`*^9, 3.5658920240011*^9, 
   3.566194853001829*^9, 3.566203971664672*^9, 3.566211904137266*^9, 
   3.566212640949161*^9, 3.566214734285638*^9, 3.566399150631337*^9, 
   3.5665437128647203`*^9, 3.5670828151349297`*^9, 3.5671851373323812`*^9, 
   3.5675865232235007`*^9, 3.567600479928124*^9, 3.567859438427951*^9, 
   3.56786057100654*^9, 3.567861307094833*^9, 3.567861520144407*^9, 
   3.5678616192357807`*^9, 3.567861715987151*^9, 3.5678618102893176`*^9, 
   3.567862035803313*^9, 3.56786220490761*^9, 3.567862536627592*^9, 
   3.56786268367345*^9, 3.567862771501605*^9, 3.567863320482169*^9, 
   3.5678634151275353`*^9, 3.567863936745651*^9, 3.567864088924919*^9, 
   3.5678642540512085`*^9, 3.56786476715171*^9, 3.5678650161125474`*^9, 
   3.5678653150246725`*^9, 3.567865528808448*^9, 3.5678774540265603`*^9, 
   3.567911948112092*^9, 3.56791306264045*^9, 3.567916910222386*^9, 
   3.567917676651732*^9, 3.567918361400335*^9, 3.56791861496318*^9, 
   3.567919444822238*^9, 3.567919756900786*^9, 3.567924258060692*^9, 
   3.5679261752582593`*^9, 3.56792647705639*^9, 3.567926861628265*^9, 
   3.567929474107654*^9, 3.567929590858259*^9, 3.5679296723216033`*^9, 
   3.567929856511126*^9, 3.567930083539325*^9, 3.5679301750958853`*^9, 
   3.56793033682137*^9, 3.567930622676272*^9, 3.567931058712639*^9, 
   3.5679312107349052`*^9, 3.567931331791117*^9, 3.567931467183755*^9, 
   3.567931520224848*^9, 3.567931626008634*^9, 3.5679319504736047`*^9, 
   3.5679326318048005`*^9, 3.5679327513634114`*^9, 3.567933125936669*^9, 
   3.567933233140057*^9, 3.5679334643480625`*^9, 3.567934710354451*^9, 
   3.5679359721948676`*^9, 3.568115004787557*^9, 3.5681159086073446`*^9, 
   3.568122253329688*^9, 3.568122355525468*^9, 3.568123412475124*^9, 
   3.5688951169738126`*^9, 3.568895483558856*^9, 3.57164915632596*^9, 
   3.5721653899936323`*^9, 3.57217513570555*^9, 3.572175206857275*^9, 
   3.572176524498989*^9, 3.572177189973559*^9, 3.572177290734136*^9, 
   3.574769483360238*^9, 3.5823486206167645`*^9, 3.582348667510448*^9, 
   3.5823489105276747`*^9, 3.583067237047179*^9, 3.5835623437360816`*^9, 
   3.5835624871003346`*^9, 3.584196655042131*^9, 3.584767089968397*^9, 
   3.584767773483598*^9, 3.584768129257822*^9, 3.584768643950527*^9, 
   3.5847738101530714`*^9, 3.584774006183016*^9, 3.584774460020013*^9, 
   3.584774881173953*^9, 3.5847752363085766`*^9, 3.5847754986230373`*^9, 
   3.58477563663648*^9, {3.584777749443791*^9, 3.584777758055006*^9}, 
   3.584882231880867*^9, 3.587025165981654*^9, 3.587653682693633*^9, {
   3.587653768370984*^9, 3.587653776420598*^9}, 3.588238727872362*^9, 
   3.5891983662433577`*^9, 3.5901468891859703`*^9, 3.59014752118988*^9, 
   3.590148330113701*^9, 3.5901485912113595`*^9, 3.590318328616583*^9, 
   3.592139786314529*^9, 3.592140061775915*^9, 3.592140125266003*^9, 
   3.592140371436348*^9, 3.592141013367246*^9, 3.592142182288883*^9, 
   3.592218077700034*^9, 3.592218377130453*^9, 3.5922187867010264`*^9, 
   3.592219193182595*^9, 3.5922193659628377`*^9, 3.598170408224114*^9, 
   3.5981880842640514`*^9, 3.600328176379328*^9, 3.603719760951648*^9, 
   3.603719895671836*^9, 3.6037200268520203`*^9, 3.6037204353125916`*^9, 
   3.603720658122903*^9, 3.603720793124092*^9, 3.603720921924273*^9, 
   3.603721580415195*^9, 3.603721640025278*^9, 3.603722556167561*^9, 
   3.607076277355503*^9, 3.6151275445398674`*^9, 3.615127672050046*^9, 
   3.615127771750186*^9, 3.615127836220276*^9, 3.615128169367133*^9, 
   3.615129021858327*^9, 3.615129055758374*^9, 3.615129724539311*^9, 
   3.619615813186519*^9, 3.6196160415608873`*^9, 3.619616968697371*^9, 
   3.619617066487508*^9, 3.619617212861761*^9, 3.619689235776536*^9, 
   3.619689451890887*^9, 3.6196894923809433`*^9, 3.619689956240689*^9, 
   3.619690121830921*^9, 3.6205393063884773`*^9, 3.620803638210657*^9, 
   3.6208040781112742`*^9, 3.62080414712137*^9, 3.648395060735346*^9, 
   3.648395210485556*^9, 3.680003708230236*^9, 3.680101707685406*^9, 
   3.8387111424448414`*^9, 3.838711275042959*^9, 3.838805501426535*^9, 
   3.838882500852056*^9, 3.83914989091971*^9, 3.839151422745108*^9, 
   3.839671969782494*^9, 3.839672076655815*^9, 3.839687407973588*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"02a7040d-789a-46f1-af2d-2e4ee781526f"]
}, Open  ]],

Cell["The reserved words in version 0.9.1 :", "Text",
 CellChangeTimes->{{3.5157533805469513`*^9, 3.515753397729934*^9}, 
   3.5157546086511946`*^9, {3.515754643534189*^9, 3.515754643595193*^9}, {
   3.5157566043206267`*^9, 3.5157566044298263`*^9}, {3.517824627882413*^9, 
   3.517824627935416*^9}, {3.5178247353335586`*^9, 3.5178247353725605`*^9}, {
   3.5178368637722654`*^9, 3.5178368687315497`*^9}, 3.599549486961925*^9, {
   3.619614498157486*^9, 
   3.619614498237486*^9}},ExpressionUUID->"50187168-c6eb-4b79-b9f5-\
00ee7f75358a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`SymManipulator`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.515744906140235*^9, 3.5157449089503956`*^9}, 
   3.515938353904936*^9},
 CellLabel->
  "In[136]:=",ExpressionUUID->"61a6add5-682a-4a2d-a636-75edbdcf6491"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"CanonicalizeGroupInSym\"\>", 
   ",", "\<\"ChangeFreeIndicesToDefault\"\>", 
   ",", "\<\"CommuteFundSpinOp\"\>", ",", "\<\"CompatibleSymmetric\"\>", 
   ",", "\<\"CompatibleSymQ\"\>", ",", "\<\"CompleteIrrDecompose\"\>", 
   ",", "\<\"ContractMetricsInsideSym\"\>", ",", "\<\"CovarD\"\>", 
   ",", "\<\"CovDOfFundSpinOp\"\>", ",", "\<\"DefFundSpinOperators\"\>", 
   ",", "\<\"DefIrreducibleSpinors\"\>", ",", "\<\"deltaH\"\>", 
   ",", "\<\"Disclaimer\"\>", ",", "\<\"EnoughIndsQSpin\"\>", 
   ",", "\<\"EqToCompareRule\"\>", ",", "\<\"EqToRule\"\>", 
   ",", "\<\"ExpandBox\"\>", ",", "\<\"ExpandFundSpinOp\"\>", 
   ",", "\<\"ExpandInternalSym\"\>", ",", "\<\"ExpandSym\"\>", 
   ",", "\<\"ExpandSymOneIndex\"\>", ",", "\<\"ExpandSymS\"\>", 
   ",", "\<\"ExtractUnprimedAndPrimed\"\>", 
   ",", "\<\"FindSpinorsInIrrDec\"\>", ",", "\<\"FindTensorCoefficients\"\>", 
   ",", "\<\"FlipEquation\"\>", ",", "\<\"FunctionInFundSpinOp\"\>", 
   ",", "\<\"FunctionInSym\"\>", ",", "\<\"FundSpinOpQ\"\>", 
   ",", "\<\"GetIndexRange\"\>", ",", "\<\"GiveIndicesToTensor\"\>", 
   ",", "\<\"HideCovDSymbolReference\"\>", ",", "\<\"ImposeFundSpinOp\"\>", 
   ",", "\<\"ImposeLargerSym\"\>", ",", "\<\"ImposeSuperfluousSym\"\>", 
   ",", "\<\"ImposeSym\"\>", ",", "\<\"IndepIrrDecompose\"\>", 
   ",", "\<\"InertHeadHead\"\>", ",", "\<\"InternalCommutingSymmetry\"\>", 
   ",", "\<\"IrrDecImposeNewMethod\"\>", ",", "\<\"IrrDecompose\"\>", 
   ",", "\<\"IrrDecomposeCovD\"\>", ",", "\<\"IrrDecSpinBundles\"\>", 
   ",", "\<\"Isolate\"\>", ",", "\<\"MakeCompareRule\"\>", 
   ",", "\<\"MoveCovDInsideSym\"\>", ",", "\<\"MoveSymIndicesDown\"\>", 
   ",", "\<\"MoveTensorsInsideSym\"\>", ",", "\<\"MoveTensorsOutsideSym\"\>", 
   ",", "\<\"NumOfPrimedSlots\"\>", ",", "\<\"NumOfPrimedSlotsDyad\"\>", 
   ",", "\<\"NumOfPrimedVBundles\"\>", ",", "\<\"NumOfUnprimedSlots\"\>", 
   ",", "\<\"NumOfUnprimedSlotsDyad\"\>", 
   ",", "\<\"NumOfUnprimedVBundles\"\>", ",", "\<\"PlaceIndicesInTensor\"\>", 
   ",", "\<\"RemoveSuperfluousInnerSym\"\>", 
   ",", "\<\"RemoveSuperfluousPartialSym\"\>", 
   ",", "\<\"RemoveSuperfluousSym\"\>", ",", "\<\"RemoveSym\"\>", 
   ",", "\<\"RemoveTrivialSym\"\>", ",", "\<\"ResultType\"\>", 
   ",", "\<\"RuleInSym\"\>", ",", "\<\"ShowValenceInfo\"\>", 
   ",", "\<\"SmartAntisymmetrize\"\>", ",", "\<\"SmartExpand\"\>", 
   ",", "\<\"SmartSymmetrize\"\>", ",", "\<\"SortTensorsInSym\"\>", 
   ",", "\<\"SpatialSpinCovDQ\"\>", ",", "\<\"SubgroupQ\"\>", 
   ",", "\<\"SymH\"\>", ",", "\<\"SymmetricOfValence\"\>", 
   ",", "\<\"SymmetricSpinorOfArbitraryValenceQ\"\>", 
   ",", "\<\"SymmetricSpinorOfValenceQ\"\>", 
   ",", "\<\"SymmetryOfExpression\"\>", ",", "\<\"TensorToZeroRule\"\>", 
   ",", "\<\"ToCanonicalSym\"\>", ",", "\<\"ToFundSpinOp\"\>", 
   ",", "\<\"TransversalInSymmetricGroup\"\>", 
   ",", "\<\"UndefFundSpinOperators\"\>", ",", "\<\"UseSym\"\>", 
   ",", "\<\"ValenceNumbersOfSpinor\"\>", ",", "\<\"ZeroTensor\"\>", 
   ",", "\<\"ZeroTensorOfTensor\"\>", ",", "\<\"$MixedSymSpecialCode\"\>", 
   ",", "\<\"$MixedSymVerbose\"\>", ",", "\<\"$Version\"\>", 
   ",", "\<\"$xTensorVersionExpected\"\>"}], "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQB2Kv4zz7RC6/ctwjLn+q5+Yrxxblb7dA9NTn0a9B9LQl
WXK9QHqfg4sViK7xUvEG0dXmdtEg2mh271oQ/aqIcSuIrmNoU+8D0nIsa7Z9
vg80b4bgf7/3rxwv2jLx+wPpwuAKaRCdE9euDKKrBHV8QbSj9J7tILroxY/d
IPrL5In8AUD6/OxlHfe+v3JcNM1oKYje8kVM8j6QbrANUAXR5U9nm4NoP+3K
JKYfrxwFrtTUgug5TT1NIHoZa8ceEL3fyvoiiLYV8i1d+POV4wL+421Kv145
phgf2QuipdpSjoHoBzenPzuk99pxxm3/nyCaaUP7eZ7s146HHMpW2gDp9bPP
rzk0843jk3VJe0G0mdr6/R+AtPXfORFis944Zh2NezEDSAcl3Fw+E0i7n7O8
Mn32G0c+rmkPQXQBD0PcfCANAECszq0=
  "],
 CellLabel->
  "Out[136]=",ExpressionUUID->"e4309a2d-bc00-4f05-b28c-b72e91ffb77c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\"\<CanonicalizeGroupInSym\>\"", ",", "\"\<ChangeFreeIndicesToDefault\>\"",
    ",", "\"\<CompatibleSymmetric\>\"", ",", "\"\<CompatibleSymQ\>\"", ",", 
   "\"\<CompleteIrrDecompose\>\"", ",", "\"\<ContractMetricsInsideSym\>\"", 
   ",", "\"\<CovarD\>\"", ",", "\"\<CovDOfFundSpinOp\>\"", ",", 
   "\"\<DefFundSpinOperators\>\"", ",", "\"\<deltaH\>\"", ",", 
   "\"\<Disclaimer\>\"", ",", "\"\<ExpandBox\>\"", ",", 
   "\"\<ExpandFundSpinOp\>\"", ",", "\"\<ExpandInternalSym\>\"", ",", 
   "\"\<ExpandSym\>\"", ",", "\"\<ExpandSymOneIndex\>\"", ",", 
   "\"\<FindTensorCoefficients\>\"", ",", "\"\<FunctionInFundSpinOp\>\"", 
   ",", "\"\<FunctionInSym\>\"", ",", "\"\<FundSpinOpQ\>\"", ",", 
   "\"\<GetIndexRange\>\"", ",", "\"\<GiveIndicesToTensor\>\"", ",", 
   "\"\<HideCovDSymbolReference\>\"", ",", "\"\<ImposeFundSpinOp\>\"", ",", 
   "\"\<ImposeLargerSym\>\"", ",", "\"\<ImposeSuperfluousSym\>\"", ",", 
   "\"\<ImposeSym\>\"", ",", "\"\<InertHeadHead\>\"", ",", 
   "\"\<InternalCommutingSymmetry\>\"", ",", "\"\<IrrDecImposeNewMethod\>\"", 
   ",", "\"\<IrrDecompose\>\"", ",", "\"\<IrrDecomposeCovD\>\"", ",", 
   "\"\<IrrDecSpinBundles\>\"", ",", "\"\<MakeCompareRule\>\"", ",", 
   "\"\<MoveCovDInsideSym\>\"", ",", "\"\<MoveSymIndicesDown\>\"", ",", 
   "\"\<MoveTensorsInsideSym\>\"", ",", "\"\<MoveTensorsOutsideSym\>\"", ",", 
   "\"\<RemoveSuperfluousInnerSym\>\"", ",", 
   "\"\<RemoveSuperfluousPartialSym\>\"", ",", "\"\<RemoveSuperfluousSym\>\"",
    ",", "\"\<RemoveSym\>\"", ",", "\"\<RemoveTrivialSym\>\"", ",", 
   "\"\<ResultType\>\"", ",", "\"\<RuleInSym\>\"", ",", 
   "\"\<SmartAntisymmetrize\>\"", ",", "\"\<SmartExpand\>\"", ",", 
   "\"\<SmartSymmetrize\>\"", ",", "\"\<SortTensorsInSym\>\"", ",", 
   "\"\<SubgroupQ\>\"", ",", "\"\<SymH\>\"", ",", 
   "\"\<SymmetryOfExpression\>\"", ",", "\"\<TensorToZeroRule\>\"", ",", 
   "\"\<ToCanonicalSym\>\"", ",", "\"\<ToFundSpinOp\>\"", ",", 
   "\"\<TransversalInSymmetricGroup\>\"", ",", 
   "\"\<UndefFundSpinOperators\>\"", ",", "\"\<UseSym\>\"", ",", 
   "\"\<ZeroTensor\>\"", ",", "\"\<$MixedSymSpecialCode\>\"", ",", 
   "\"\<$MixedSymVerbose\>\"", ",", "\"\<$Version\>\"", ",", 
   "\"\<$xTensorVersionExpected\>\""}], "}"}]], "Input",
 CellChangeTimes->{{3.599549439725043*^9, 3.5995494397406416`*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"db5ee446-6e18-4859-85ad-dbd54180180b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"CanonicalizeGroupInSym\"\>", 
   ",", "\<\"ChangeFreeIndicesToDefault\"\>", 
   ",", "\<\"CompatibleSymmetric\"\>", ",", "\<\"CompatibleSymQ\"\>", 
   ",", "\<\"CompleteIrrDecompose\"\>", 
   ",", "\<\"ContractMetricsInsideSym\"\>", ",", "\<\"CovarD\"\>", 
   ",", "\<\"CovDOfFundSpinOp\"\>", ",", "\<\"DefFundSpinOperators\"\>", 
   ",", "\<\"deltaH\"\>", ",", "\<\"Disclaimer\"\>", ",", "\<\"ExpandBox\"\>",
    ",", "\<\"ExpandFundSpinOp\"\>", ",", "\<\"ExpandInternalSym\"\>", 
   ",", "\<\"ExpandSym\"\>", ",", "\<\"ExpandSymOneIndex\"\>", 
   ",", "\<\"FindTensorCoefficients\"\>", ",", "\<\"FunctionInFundSpinOp\"\>",
    ",", "\<\"FunctionInSym\"\>", ",", "\<\"FundSpinOpQ\"\>", 
   ",", "\<\"GetIndexRange\"\>", ",", "\<\"GiveIndicesToTensor\"\>", 
   ",", "\<\"HideCovDSymbolReference\"\>", ",", "\<\"ImposeFundSpinOp\"\>", 
   ",", "\<\"ImposeLargerSym\"\>", ",", "\<\"ImposeSuperfluousSym\"\>", 
   ",", "\<\"ImposeSym\"\>", ",", "\<\"InertHeadHead\"\>", 
   ",", "\<\"InternalCommutingSymmetry\"\>", 
   ",", "\<\"IrrDecImposeNewMethod\"\>", ",", "\<\"IrrDecompose\"\>", 
   ",", "\<\"IrrDecomposeCovD\"\>", ",", "\<\"IrrDecSpinBundles\"\>", 
   ",", "\<\"MakeCompareRule\"\>", ",", "\<\"MoveCovDInsideSym\"\>", 
   ",", "\<\"MoveSymIndicesDown\"\>", ",", "\<\"MoveTensorsInsideSym\"\>", 
   ",", "\<\"MoveTensorsOutsideSym\"\>", 
   ",", "\<\"RemoveSuperfluousInnerSym\"\>", 
   ",", "\<\"RemoveSuperfluousPartialSym\"\>", 
   ",", "\<\"RemoveSuperfluousSym\"\>", ",", "\<\"RemoveSym\"\>", 
   ",", "\<\"RemoveTrivialSym\"\>", ",", "\<\"ResultType\"\>", 
   ",", "\<\"RuleInSym\"\>", ",", "\<\"SmartAntisymmetrize\"\>", 
   ",", "\<\"SmartExpand\"\>", ",", "\<\"SmartSymmetrize\"\>", 
   ",", "\<\"SortTensorsInSym\"\>", ",", "\<\"SubgroupQ\"\>", 
   ",", "\<\"SymH\"\>", ",", "\<\"SymmetryOfExpression\"\>", 
   ",", "\<\"TensorToZeroRule\"\>", ",", "\<\"ToCanonicalSym\"\>", 
   ",", "\<\"ToFundSpinOp\"\>", ",", "\<\"TransversalInSymmetricGroup\"\>", 
   ",", "\<\"UndefFundSpinOperators\"\>", ",", "\<\"UseSym\"\>", 
   ",", "\<\"ZeroTensor\"\>", ",", "\<\"$MixedSymSpecialCode\"\>", 
   ",", "\<\"$MixedSymVerbose\"\>", ",", "\<\"$Version\"\>", 
   ",", "\<\"$xTensorVersionExpected\"\>"}], "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQB2IzSd59IpdfOa7IlD/Vc/OVY0Hpt1sgusEy5jWIbvqW
JdcLpKc9cbEC0cHvVLxBdNBtu2gQzWHftxZEHxJj2gqiw5a0qfcB6W/L12z7
fB9o3ivB/37vXznu6Wfi9wfSMUsrpEF0xIZ2ZRCdlqzjC6Il9u/ZDqKLXvzY
DaIfPJ3IHwCkd79d1nHv+yvHRdOMloLo+W7ikveBdE5/gCqI9uucYw6iLWsr
k5h+vHL8o1pbC6I7rvQ0gehJ4R17QPSqHuuLINpWyLd04c9XjuWbj7cp/Xrl
GNB6ZC+IZruRcgxEn9Ge8eyQ3mvHZt2AnyD6ZnDHeZ7s147rJpWttAHSam8v
rDk0842jSVn5XhBtFb5p/wcgvWfqvAixWW8ck44mvpgBpG+svLN8JpCeW2l1
ZfrsN45Fa2c+BNH1Fxji5gNpAByj1L8=
  "],
 CellLabel->
  "Out[137]=",ExpressionUUID->"b6fdba49-172d-4851-a810-2a6e091d8499"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Length"}]], "Input",
 CellLabel->
  "In[138]:=",ExpressionUUID->"c0fe5d47-31d4-4491-90a8-72d49ddd2b8d"],

Cell[BoxData["63"], "Output",
 CellChangeTimes->{
  3.5201748498524656`*^9, 3.5201755964289665`*^9, 3.520175968965217*^9, 
   3.520176096570639*^9, 3.520176270795743*^9, 3.5201767563679924`*^9, 
   3.5201779239636307`*^9, 3.5201779737397156`*^9, 3.520178034253021*^9, 
   3.5201781235217743`*^9, 3.520178324339721*^9, 3.5201790106557207`*^9, 
   3.520179111215495*^9, 3.520179193934038*^9, 3.520179238612116*^9, 
   3.5201792851333942`*^9, 3.520179464188905*^9, 3.5201795519958572`*^9, 
   3.520181360520602*^9, 3.520181636927486*^9, 3.520268562921894*^9, 
   3.520268731275334*^9, 3.520268862901922*^9, 3.520268899992377*^9, 
   3.520269092323848*^9, 3.5202718145609016`*^9, 3.520310605527149*^9, 
   3.520310986952505*^9, 3.5203117875504365`*^9, 3.5203121052247133`*^9, 
   3.527144937736272*^9, 3.527145808656602*^9, 3.527146002238343*^9, 
   3.5271470232621355`*^9, 3.527147594208538*^9, 3.527148047140734*^9, 
   3.5271482644491158`*^9, 3.52714868679786*^9, 3.527150051177257*^9, 
   3.5271501732786713`*^9, 3.527150353895789*^9, 3.52715050780566*^9, 
   3.5271507922409596`*^9, 3.527150865592288*^9, 3.5292308241893253`*^9, 
   3.529232467355811*^9, 3.529232572031996*^9, 3.529235909787658*^9, 
   3.529236217794599*^9, 3.52923641747495*^9, 3.529236654876167*^9, 
   3.529236716388075*^9, 3.529236967456916*^9, 3.529237057968275*^9, 
   3.5340685703005905`*^9, 3.5340689520644608`*^9, 3.534069383093218*^9, 
   3.5340699522134175`*^9, 3.534070177259413*^9, 3.5342496376713643`*^9, 
   3.5376214991089973`*^9, 3.5376216255628195`*^9, 3.537622842319157*^9, {
   3.537622948789344*^9, 3.537622964779372*^9}, 3.537623183304556*^9, 
   3.5376233619092693`*^9, 3.53762544031852*^9, 3.537628790067875*^9, 
   3.537694700279871*^9, 3.537694868120566*^9, 3.537695502136879*^9, 
   3.537695581915419*^9, 3.537695913619802*^9, 3.537696395629449*^9, 
   3.5376971054160957`*^9, 3.53769746081592*^9, {3.5376979709680157`*^9, 
   3.537697991622452*^9}, 3.537700571106588*^9, 3.537700989109321*^9, 
   3.537701150179604*^9, 3.5377050759606996`*^9, 3.5377676504506893`*^9, 
   3.537780186346308*^9, 3.537780584271807*^9, 3.5377809212957993`*^9, 
   3.537781080291279*^9, 3.537781242359963*^9, 3.537781378517002*^9, 
   3.537781527590864*^9, 3.537781725960813*^9, 3.537782399414995*^9, 
   3.5377827402755947`*^9, 3.537782931344729*^9, 3.537783192130388*^9, 
   3.537783440951825*^9, 3.5377835732244577`*^9, 3.537784108242998*^9, 
   3.537784245070837*^9, 3.544092209673561*^9, 3.544097241778401*^9, 
   3.544097365845418*^9, 3.5440979531562495`*^9, 3.544099754508014*^9, 
   3.54410337315477*^9, 3.54410346422773*^9, 3.544103705420754*^9, 
   3.5441039178463273`*^9, 3.5441040522093635`*^9, 3.5441050999862027`*^9, 
   3.5441057146584826`*^9, 3.544105949470095*^9, 3.5441071478184*^9, 
   3.544591253616271*^9, 3.544591490768835*^9, 3.544591653174124*^9, 
   3.5445929049717226`*^9, 3.544672173520233*^9, 3.544672374923753*^9, 
   3.544673274156186*^9, {3.5446733825253844`*^9, 3.544673403397578*^9}, 
   3.5449492192858253`*^9, 3.544951614473035*^9, 3.545015663086934*^9, 
   3.545015724878643*^9, 3.54510614256985*^9, 3.545114020963421*^9, 
   3.552821195921003*^9, 3.552822659968974*^9, 3.552822795938813*^9, 
   3.552822987118149*^9, 3.552823196283316*^9, 3.5528236666397424`*^9, 
   3.552823971605678*^9, 3.552826117078446*^9, 3.552826309646185*^9, 
   3.554207271773513*^9, 3.5542084672836123`*^9, 3.56137169779402*^9, 
   3.561732586780009*^9, 3.5617791987858076`*^9, 3.561781488403829*^9, 
   3.561781562332359*^9, 3.561781653280519*^9, 3.561781901586155*^9, 
   3.561781934034212*^9, 3.5617821017823076`*^9, 3.56178219500807*^9, 
   3.56178238844841*^9, 3.561782492921794*^9, 3.561782526118652*^9, 
   3.561784234588853*^9, 3.562766627419752*^9, 3.562766744201557*^9, 
   3.5627670826285515`*^9, 3.562767893503376*^9, 3.562769546155679*^9, 
   3.562769668054293*^9, {3.562771127953657*^9, 3.5627711474536915`*^9}, 
   3.5627731145401464`*^9, 3.562773202415101*^9, 3.562821272208412*^9, 
   3.562822346162099*^9, 3.5628235980662975`*^9, 3.562823661355609*^9, 
   3.562824062182713*^9, 3.562824598980656*^9, 3.562825243729788*^9, 
   3.5628253121203084`*^9, 3.562825372164814*^9, 3.5628259596004453`*^9, 
   3.562826134211552*^9, 3.562826248294553*^9, 3.562828066108573*^9, 
   3.562828564233048*^9, 3.562828736847351*^9, 3.562828879072801*^9, 
   3.5628304898400307`*^9, 3.562831305487463*^9, 3.5628317002003574`*^9, 
   3.562831820008567*^9, 3.562831852082223*^9, 3.562832308507825*^9, 
   3.562832421935624*^9, 3.562832729583764*^9, 3.5628336702196164`*^9, 
   3.562833764630983*^9, 3.562833835252307*^9, 3.563425633401393*^9, 
   3.5634263675074835`*^9, 3.563427213950369*^9, 3.563428699760379*^9, 
   3.563428791831741*^9, 3.563428870518279*^9, 3.5634296668538775`*^9, 
   3.5641236131336384`*^9, 3.564124346226726*^9, 3.564124862791435*^9, 
   3.5641250179815073`*^9, 3.564130442464235*^9, 3.564635026642227*^9, 
   3.564635498184255*^9, 3.5646721302086897`*^9, 3.565759288169967*^9, 
   3.565773667323635*^9, 3.565892024047901*^9, 3.5661948530486293`*^9, 
   3.5662039717114716`*^9, 3.5662119041996665`*^9, 3.566212640995961*^9, 
   3.566214734316838*^9, 3.566399150678138*^9, 3.566543712911521*^9, 
   3.56708281518173*^9, 3.567185137379181*^9, 3.567586523270301*^9, 
   3.567600479974924*^9, 3.5678594384591503`*^9, 3.56786057103774*^9, 
   3.567861307126033*^9, 3.567861520175607*^9, 3.567861619266981*^9, 
   3.567861716018351*^9, 3.567861810320517*^9, 3.567862035834513*^9, 
   3.567862204938809*^9, 3.5678625366587925`*^9, 3.567862683720251*^9, 
   3.5678627715328045`*^9, 3.5678633205289693`*^9, 3.567863415158735*^9, 
   3.567863936792452*^9, 3.567864088956119*^9, 3.567864254082409*^9, 
   3.56786476718291*^9, 3.567865016128147*^9, 3.5678653150558724`*^9, 
   3.567865528839648*^9, 3.5678774540577602`*^9, 3.567911948143292*^9, 
   3.56791306267165*^9, 3.567916910269186*^9, 3.567917676682932*^9, 
   3.567918361447135*^9, 3.56791861497878*^9, 3.567919444853438*^9, 
   3.5679197569163866`*^9, 3.567924258091893*^9, 3.567926175289459*^9, 
   3.5679264770875897`*^9, 3.567926861659465*^9, 3.567929474138854*^9, 
   3.567929590889459*^9, 3.567929672352803*^9, 3.567929856542326*^9, 
   3.567930083586125*^9, 3.567930175127086*^9, 3.56793033685257*^9, 
   3.567930622707472*^9, 3.567931058759439*^9, 3.5679312107661057`*^9, 
   3.567931331822317*^9, 3.567931467214955*^9, 3.567931520256048*^9, 
   3.567931626039834*^9, 3.5679319505048046`*^9, 3.567932631836001*^9, 
   3.5679327513946114`*^9, 3.567933125967869*^9, 3.567933233171257*^9, 
   3.567933464394863*^9, 3.5679347104012523`*^9, 3.567935972226068*^9, 
   3.5681150048343573`*^9, 3.5681159086541443`*^9, 3.5681222533764887`*^9, 
   3.568122355556668*^9, 3.568123412521924*^9, 3.5688951170050125`*^9, 
   3.5688954835900564`*^9, 3.57164915635716*^9, 3.572165390040432*^9, 
   3.57217513573675*^9, 3.572175206904075*^9, 3.572176524530189*^9, 
   3.572177190004759*^9, 3.572177290765336*^9, 3.574769483391438*^9, 
   3.582348620647966*^9, 3.582348667541648*^9, 3.582348910558875*^9, 
   3.5830672370783787`*^9, 3.5835623437672815`*^9, 3.583562487131534*^9, 
   3.584196655073331*^9, 3.584767089999598*^9, 3.584767773514798*^9, 
   3.584768129289022*^9, 3.5847686439817266`*^9, 3.5847738101686716`*^9, 
   3.584774006214216*^9, 3.5847744600512137`*^9, 3.584774881205153*^9, 
   3.584775236339777*^9, 3.5847754986542377`*^9, 3.58477563668328*^9, {
   3.584777749537392*^9, 3.584777758070606*^9}, 3.584882231927667*^9, 
   3.587025166028454*^9, 3.587653682724833*^9, {3.5876537684489846`*^9, 
   3.587653776451798*^9}, 3.588238727903562*^9, 3.589198366274557*^9, 
   3.59014688920157*^9, 3.59014752122108*^9, 3.590148330144901*^9, 
   3.5901485912425594`*^9, 3.590318328647783*^9, 3.592139786344529*^9, 
   3.5921400617959146`*^9, 3.592140125296003*^9, 3.592140371466348*^9, 
   3.592141013397247*^9, 3.5921421823288827`*^9, 3.592218077730034*^9, 
   3.592218377160453*^9, 3.5922187867410264`*^9, 3.592219193212596*^9, 
   3.592219365992838*^9, 3.5981704082641144`*^9, 3.598188084294051*^9, 
   3.600328176419328*^9, 3.603719761001647*^9, 3.6037198957218356`*^9, 
   3.60372002689202*^9, 3.603720435352592*^9, 3.6037206581629047`*^9, 
   3.603720793164092*^9, 3.603720921974273*^9, 3.6037215804551954`*^9, 
   3.603721640075279*^9, 3.6037225562175612`*^9, 3.607076277405503*^9, 
   3.615127544559868*^9, 3.615127672090046*^9, 3.615127771780186*^9, 
   3.615127836250276*^9, 3.615128169397134*^9, 3.615129021928327*^9, 
   3.615129055788375*^9, 3.615129724569311*^9, 3.619615813226519*^9, 
   3.6196160415908875`*^9, 3.619616968737371*^9, 3.619617066537508*^9, 
   3.619617212891761*^9, 3.6196892358065357`*^9, 3.619689451920887*^9, 
   3.6196894924109435`*^9, 3.619689956270689*^9, 3.619690121870921*^9, 
   3.6205393064284773`*^9, 3.620803638240658*^9, 3.620804078151274*^9, 
   3.62080414715137*^9, 3.648395060765346*^9, 3.648395210515556*^9, 
   3.680003708270235*^9, 3.6801017077154064`*^9, 3.838711142577792*^9, 
   3.83871127578105*^9, 3.8388055016259785`*^9, 3.8388825010066423`*^9, 
   3.839149891107215*^9, 3.839151422945599*^9, 3.839671969911145*^9, 
   3.8396720768323436`*^9, 3.839687408046397*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"68f635ab-0052-4d97-aa70-a16a93f00361"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 InitializationCell->True,
 CellLabel->
  "In[139]:=",ExpressionUUID->"922830ab-226e-4202-a37f-d1082d3caf36"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`ExpressionManipulation`\"\>", 
   ",", "\<\"Utilities`ShowTime`\"\>", ",", "\<\"xAct`SymManipulator`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellChangeTimes->{
  3.520174849868065*^9, 3.520175596438967*^9, 3.520175968980817*^9, 
   3.520176096586239*^9, 3.520176270811343*^9, 3.520176756377991*^9, 
   3.520177923979231*^9, 3.520177973755316*^9, 3.520178034268621*^9, 
   3.5201781235417743`*^9, 3.520178324355322*^9, 3.52017901067572*^9, 
   3.520179111225496*^9, 3.5201791939440384`*^9, 3.5201792386321173`*^9, 
   3.520179285153395*^9, 3.5201794642045045`*^9, 3.520179552015856*^9, 
   3.520181360551802*^9, 3.5201816369430857`*^9, 3.5202685629418945`*^9, 
   3.520268731290934*^9, 3.520268862911923*^9, 3.520268899992377*^9, 
   3.520269092355048*^9, 3.5202718145709014`*^9, 3.5203106055371494`*^9, 
   3.5203109869681053`*^9, 3.5203117875704365`*^9, 3.520312105244713*^9, {
   3.5271449362854695`*^9, 3.527144937751872*^9}, 3.527145808672202*^9, 
   3.527146002253942*^9, 3.527147023277736*^9, 3.527147594208538*^9, 
   3.527148047156334*^9, 3.5271482644647155`*^9, 3.5271486868134604`*^9, 
   3.527150051192858*^9, 3.527150173294271*^9, 3.527150353911389*^9, 
   3.52715050782126*^9, 3.527150792256559*^9, 3.5271508656078877`*^9, 
   3.529230824204925*^9, 3.529232467355811*^9, 3.529232572047595*^9, 
   3.529235909803258*^9, 3.529236217810199*^9, 3.529236417490549*^9, 
   3.5292366548917665`*^9, 3.529236716403675*^9, 3.529236967488116*^9, 
   3.529237057983875*^9, 3.5340685703161907`*^9, 3.534068952080061*^9, 
   3.534069383108818*^9, 3.5340699522446175`*^9, 3.534070177275013*^9, 
   3.534249637702564*^9, 3.5376214991401978`*^9, 3.5376216255784197`*^9, 
   3.537622842350357*^9, {3.537622948804944*^9, 3.5376229648105717`*^9}, 
   3.537623183335756*^9, 3.537623361924869*^9, 3.53762544034972*^9, 
   3.5376287900990753`*^9, 3.537694700311071*^9, 3.5376948681361656`*^9, 
   3.537695502152479*^9, 3.5376955819466195`*^9, 3.537695913651002*^9, 
   3.537696395645048*^9, 3.537697105447295*^9, 3.53769746084712*^9, {
   3.537697970999215*^9, 3.537697991653652*^9}, 3.537700571137787*^9, 
   3.537700989140521*^9, 3.537701150210804*^9, 3.5377050759918995`*^9, 
   3.5377676504662895`*^9, 3.537780186377508*^9, 3.537780584287407*^9, 
   3.5377809213114*^9, 3.5377810803224792`*^9, 3.537781242391163*^9, 
   3.537781378548203*^9, 3.537781527622064*^9, 3.5377817259764137`*^9, 
   3.5377823994305954`*^9, 3.537782740291194*^9, 3.53778293137593*^9, 
   3.537783192161588*^9, 3.537783440967425*^9, 3.537783573255657*^9, 
   3.537784108274197*^9, 3.537784245086437*^9, 3.544092209704761*^9, 
   3.5440972418096*^9, 3.544097365876618*^9, 3.5440979531718493`*^9, 
   3.544099754539214*^9, 3.5441033731703696`*^9, 3.5441034642589293`*^9, 
   3.544103705451953*^9, 3.544103917861926*^9, 3.5441040522405634`*^9, 
   3.5441051000018024`*^9, 3.544105714674083*^9, 3.544105949501295*^9, 
   3.5441071478496*^9, 3.5445912536382732`*^9, 3.544591490792836*^9, 
   3.5445916531991253`*^9, 3.544592904996724*^9, 3.544672173544234*^9, 
   3.5446723749487543`*^9, 3.544673274189188*^9, {3.544673382547386*^9, 
   3.54467340343158*^9}, 3.544949219317026*^9, 3.544951614504235*^9, 
   3.5450156631025343`*^9, 3.545015724894243*^9, 3.545106142601051*^9, 
   3.545114020979021*^9, 3.552821195952203*^9, 3.552822660000174*^9, 
   3.552822795970013*^9, 3.5528229871493483`*^9, 3.5528231963301163`*^9, 
   3.5528236666709423`*^9, 3.552823971636878*^9, 3.552826117109646*^9, 
   3.552826309677385*^9, 3.554207271804713*^9, 3.5542084673148127`*^9, 
   3.56137169780962*^9, 3.561732586795608*^9, 3.561779198801408*^9, 
   3.56178148841943*^9, 3.561781562363559*^9, 3.561781653311719*^9, 
   3.561781901617355*^9, 3.5617819340654116`*^9, 3.561782101797907*^9, 
   3.56178219503927*^9, 3.5617823884640102`*^9, 3.561782492952994*^9, 
   3.561782526134251*^9, 3.561784234604453*^9, 3.562766627450953*^9, 
   3.562766744232757*^9, 3.562767082659752*^9, 3.562767893518976*^9, 
   3.562769546186879*^9, 3.562769668069893*^9, {3.5627711279692574`*^9, 
   3.562771147469292*^9}, 3.562773114555746*^9, 3.562773202430701*^9, 
   3.5628212722240133`*^9, 3.562822346193299*^9, 3.562823598081898*^9, 
   3.562823661371209*^9, 3.562824062213913*^9, 3.562824598996256*^9, 
   3.5628252437453885`*^9, 3.5628253121515083`*^9, 3.562825372196014*^9, 
   3.562825959616046*^9, 3.562826134242752*^9, 3.5628262483257537`*^9, 
   3.562828066124173*^9, 3.562828564264248*^9, 3.5628287368629518`*^9, 
   3.562828879088401*^9, 3.56283048987123*^9, 3.562831305503063*^9, 
   3.5628317002159576`*^9, 3.562831820024167*^9, 3.562831852113424*^9, 
   3.562832308523425*^9, 3.562832421966824*^9, 3.5628327295993643`*^9, 
   3.5628336702352166`*^9, 3.562833764646583*^9, 3.5628338352835064`*^9, 
   3.5634256334325933`*^9, 3.563426367523083*^9, 3.5634272139971695`*^9, 
   3.563428699775979*^9, 3.563428791847341*^9, 3.5634288705494785`*^9, 
   3.563429666885078*^9, 3.5641236131492386`*^9, 3.564124346242326*^9, 
   3.564124862822635*^9, 3.564125018012706*^9, 3.564130442495435*^9, 
   3.5646350266578274`*^9, 3.5646354982154555`*^9, 3.564672130239891*^9, 
   3.565759288185567*^9, 3.5657736673392353`*^9, 3.565892024063501*^9, 
   3.566194853079829*^9, 3.566203971727072*^9, 3.566211904215266*^9, 
   3.566212641027161*^9, 3.566214734332438*^9, 3.5663991506937375`*^9, 
   3.56654371292712*^9, 3.56708281519733*^9, 3.567185137394781*^9, 
   3.567586523285901*^9, 3.5676004800061245`*^9, 3.56785943847475*^9, 
   3.56786057105334*^9, 3.567861307141633*^9, 3.567861520191207*^9, 
   3.5678616192825813`*^9, 3.567861716033951*^9, 3.567861810336117*^9, 
   3.567862035850113*^9, 3.567862204938809*^9, 3.567862536674393*^9, 
   3.567862683735851*^9, 3.567862771548405*^9, 3.567863320544569*^9, 
   3.5678634151743355`*^9, 3.567863936808051*^9, 3.567864088971719*^9, 
   3.567864254098009*^9, 3.56786476719851*^9, 3.567865016143747*^9, 
   3.567865315071472*^9, 3.567865528855248*^9, 3.5678774540733604`*^9, 
   3.567911948158892*^9, 3.5679130626872506`*^9, 3.567916910284786*^9, 
   3.567917676682932*^9, 3.567918361478335*^9, 3.56791861499438*^9, 
   3.567919444869038*^9, 3.567919756931986*^9, 3.567924258091893*^9, 
   3.56792617530506*^9, 3.5679264771031895`*^9, 3.567926861675065*^9, 
   3.567929474154454*^9, 3.567929590905059*^9, 3.567929672368403*^9, 
   3.567929856557926*^9, 3.567930083586125*^9, 3.567930175142686*^9, 
   3.56793033686817*^9, 3.567930622723072*^9, 3.567931058775038*^9, 
   3.5679312107817054`*^9, 3.5679313318379188`*^9, 3.567931467230555*^9, 
   3.567931520271649*^9, 3.567931626055434*^9, 3.567931950520404*^9, 
   3.5679326318516006`*^9, 3.567932751410211*^9, 3.567933125983468*^9, 
   3.567933233186857*^9, 3.567933464410463*^9, 3.567934710416852*^9, 
   3.567935972241668*^9, 3.568115004849957*^9, 3.568115908669744*^9, 
   3.568122253392088*^9, 3.568122355587868*^9, 3.568123412537524*^9, 
   3.568895117020613*^9, 3.568895483605656*^9, 3.57164915637276*^9, 
   3.572165390040432*^9, 3.5721751357523503`*^9, 3.572175206904075*^9, 
   3.5721765245457892`*^9, 3.572177190020359*^9, 3.5721772907809367`*^9, 
   3.5747694834070377`*^9, 3.5823486206635647`*^9, 3.582348667557248*^9, 
   3.582348910574475*^9, 3.583067237093978*^9, 3.583562343798482*^9, 
   3.583562487162734*^9, 3.584196655073331*^9, 3.5847670900151978`*^9, 
   3.584767773514798*^9, 3.5847681293046227`*^9, 3.5847686439817266`*^9, 
   3.584773810184272*^9, 3.584774006229816*^9, 3.584774460066814*^9, 
   3.584774881205153*^9, 3.5847752363553777`*^9, 3.5847754986542377`*^9, 
   3.58477563668328*^9, {3.584777749568591*^9, 3.584777758086206*^9}, 
   3.584882231943267*^9, 3.587025166028454*^9, 3.587653682740433*^9, {
   3.587653768495784*^9, 3.5876537764673986`*^9}, 3.588238727919162*^9, 
   3.589198366290158*^9, 3.59014688921717*^9, 3.59014752123668*^9, 
   3.5901483301605*^9, 3.5901485912425594`*^9, 3.5903183286633825`*^9, 
   3.592139786354529*^9, 3.592140061815915*^9, 3.592140125306003*^9, 
   3.5921403714763484`*^9, 3.592141013407247*^9, 3.5921421823488827`*^9, 
   3.592218077740034*^9, 3.592218377170453*^9, 3.592218786751026*^9, 
   3.592219193222595*^9, 3.5922193660028377`*^9, 3.598170408274114*^9, 
   3.5981880843040514`*^9, 3.600328176439328*^9, 3.603719761011647*^9, 
   3.603719895731836*^9, 3.60372002690202*^9, 3.6037204353625917`*^9, 
   3.603720658172903*^9, 3.6037207931740932`*^9, 3.603720921994273*^9, 
   3.6037215804651957`*^9, 3.603721640085278*^9, 3.603722556237561*^9, 
   3.607076277415503*^9, 3.6151275445698676`*^9, 3.615127672100046*^9, 
   3.615127771790186*^9, 3.615127836260276*^9, 3.615128169397134*^9, 
   3.615129021948327*^9, 3.615129055798374*^9, 3.615129724569311*^9, 
   3.619615813226519*^9, 3.6196160416008873`*^9, 3.619616968747371*^9, 
   3.619617066537508*^9, 3.619617212901761*^9, 3.619689235816536*^9, 
   3.6196894519308867`*^9, 3.6196894924209433`*^9, 3.6196899562806892`*^9, 
   3.6196901218809214`*^9, 3.6205393064284773`*^9, 3.620803638250657*^9, 
   3.620804078161273*^9, 3.62080414716137*^9, 3.648395060775346*^9, 
   3.648395210525556*^9, 3.680003708280236*^9, 3.6801017077154064`*^9, 
   3.838711142589759*^9, 3.838711275822445*^9, 3.838805501673879*^9, 
   3.838882501055511*^9, 3.839149891149089*^9, 3.839151422990481*^9, 
   3.8396719699340873`*^9, 3.839672076862263*^9, 3.8396874080693355`*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"c00232fc-0012-4379-b58f-d23e078fb76b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->
  "In[140]:=",ExpressionUUID->"f14886e0-7b1b-472c-9762-189352d55138"],

Cell[BoxData["\<\"xAct`SymManipulator`Private`\"\>"], "Output",
 CellChangeTimes->{
  3.520174849883665*^9, 3.5201755964589667`*^9, 3.520175968996417*^9, 
   3.520176096601839*^9, 3.520176270826943*^9, 3.5201767563879924`*^9, 
   3.520177923994831*^9, 3.520177973770916*^9, 3.52017803428422*^9, 
   3.520178123551774*^9, 3.520178324370921*^9, 3.520179010695721*^9, 
   3.520179111245496*^9, 3.5201791939640384`*^9, 3.5201792386421175`*^9, 
   3.520179285163395*^9, 3.5201794642201047`*^9, 3.5201795520358567`*^9, 
   3.520181360567402*^9, 3.5201816369586854`*^9, 3.5202685629618945`*^9, 
   3.520268731306534*^9, 3.520268862931923*^9, 3.5202689000079765`*^9, 
   3.5202690923706484`*^9, 3.5202718145909014`*^9, 3.520310605557149*^9, 
   3.520310986983705*^9, 3.5203117875904365`*^9, 3.5203121052647133`*^9, 
   3.527144937767473*^9, 3.527145808687803*^9, 3.527146002269542*^9, 
   3.527147023293336*^9, 3.5271475942241387`*^9, 3.527148047171934*^9, 
   3.527148264480316*^9, 3.52714868682906*^9, 3.527150051208457*^9, 
   3.5271501733098717`*^9, 3.527150353911389*^9, 3.52715050782126*^9, 
   3.527150792272159*^9, 3.527150865623488*^9, 3.5292308242205253`*^9, 
   3.5292324673870115`*^9, 3.529232572063195*^9, 3.529235909818858*^9, 
   3.529236217825799*^9, 3.5292364175061493`*^9, 3.5292366549073677`*^9, 
   3.529236716419275*^9, 3.529236967519316*^9, 3.529237057999475*^9, 
   3.5340685703317904`*^9, 3.534068952111261*^9, 3.5340693831244183`*^9, 
   3.534069952260218*^9, 3.534070177306213*^9, 3.534249637764964*^9, 
   3.537621499171398*^9, 3.537621625609619*^9, 3.537622842365957*^9, {
   3.5376229488205442`*^9, 3.537622964826172*^9}, 3.5376231833513556`*^9, 
   3.53762336195607*^9, 3.5376254403809204`*^9, 3.5376287901302757`*^9, 
   3.537694700326671*^9, 3.537694868167366*^9, 3.537695502183679*^9, 
   3.537695581962219*^9, 3.537695913666602*^9, 3.537696395676248*^9, 
   3.5376971054628954`*^9, 3.53769746087832*^9, {3.5376979710148153`*^9, 
   3.537697991669252*^9}, 3.5377005711689878`*^9, 3.537700989171721*^9, 
   3.537701150226404*^9, 3.5377050760231*^9, 3.53776765049749*^9, 
   3.5377801863931084`*^9, 3.5377805843186073`*^9, 3.537780921342599*^9, 
   3.537781080353679*^9, 3.537781242406763*^9, 3.537781378563803*^9, 
   3.537781527637664*^9, 3.537781726007612*^9, 3.5377823994617953`*^9, 
   3.537782740322394*^9, 3.537782931391529*^9, 3.537783192192788*^9, 
   3.537783440998625*^9, 3.537783573286857*^9, 3.537784108305397*^9, 
   3.537784245117637*^9, 3.544092209735962*^9, 3.5440972418252*^9, 
   3.544097365892218*^9, 3.5440979531874495`*^9, 3.544099754570414*^9, 
   3.5441033732015696`*^9, 3.5441034642745295`*^9, 3.544103705467553*^9, 
   3.5441039178931265`*^9, 3.5441040522717633`*^9, 3.544105100033003*^9, 
   3.544105714705282*^9, 3.544105949516895*^9, 3.5441071478652*^9, 
   3.5445912536622744`*^9, 3.544591490817838*^9, 3.544591653224127*^9, 
   3.544592905018725*^9, 3.5446721735762367`*^9, 3.5446723749727554`*^9, 
   3.54467327422219*^9, {3.544673382568387*^9, 3.544673403464582*^9}, 
   3.544949219332627*^9, 3.544951614535435*^9, 3.545015663133734*^9, 
   3.545015724925443*^9, 3.545106142616651*^9, 3.5451140210102215`*^9, 
   3.5528211959834027`*^9, 3.5528226600157743`*^9, 3.552822796001213*^9, 
   3.552822987196149*^9, 3.552823196361317*^9, 3.5528236667177424`*^9, 
   3.552823971668078*^9, 3.552826117140846*^9, 3.552826309708585*^9, 
   3.5542072718359137`*^9, 3.5542084673460126`*^9, 3.56137169782522*^9, 
   3.561732586826808*^9, 3.5617791988326077`*^9, 3.561781488450629*^9, 
   3.561781562379159*^9, 3.561781653327319*^9, 3.561781901632955*^9, 
   3.561781934081012*^9, 3.5617821018291063`*^9, 3.56178219505487*^9, 
   3.5617823884952097`*^9, 3.5617824929685936`*^9, 3.561782526165452*^9, 
   3.561784234635653*^9, 3.5627666274665527`*^9, 3.562766744248358*^9, 
   3.562767082675352*^9, 3.5627678935501757`*^9, 3.562769546202479*^9, 
   3.562769668085493*^9, {3.562771128000458*^9, 3.562771147500492*^9}, 
   3.5627731145869465`*^9, 3.5627732024619017`*^9, 3.562821272239613*^9, 
   3.562822346208898*^9, 3.562823598113098*^9, 3.5628236614024096`*^9, 
   3.562824062229513*^9, 3.562824599011856*^9, 3.5628252437765884`*^9, 
   3.562825312167108*^9, 3.562825372211614*^9, 3.562825959647246*^9, 
   3.5628261342583523`*^9, 3.562826248356954*^9, 3.562828066155373*^9, 
   3.562828564279848*^9, 3.562828736878551*^9, 3.5628288791196003`*^9, 
   3.5628304898868303`*^9, 3.562831305534263*^9, 3.5628317002315574`*^9, 
   3.562831820055367*^9, 3.5628318521446238`*^9, 3.562832308554624*^9, 
   3.562832421998024*^9, 3.5628327296305647`*^9, 3.562833670266417*^9, 
   3.562833764677782*^9, 3.562833835299106*^9, 3.563425633448193*^9, 
   3.563426367554282*^9, 3.563427214028369*^9, 3.5634286998071785`*^9, 
   3.5634287918785405`*^9, 3.563428870580679*^9, 3.5634296669006786`*^9, 
   3.5641236131648383`*^9, 3.564124346273526*^9, 3.5641248628382344`*^9, 
   3.564125018028306*^9, 3.564130442511034*^9, 3.5646350266890273`*^9, 
   3.5646354982310557`*^9, 3.5646721302554913`*^9, 3.565759288216767*^9, 
   3.5657736673548355`*^9, 3.565892024094701*^9, 3.56619485309543*^9, 
   3.566203971758272*^9, 3.5662119042308664`*^9, 3.566212641042761*^9, 
   3.566214734363638*^9, 3.566399150709337*^9, 3.5665437129583206`*^9, 
   3.56708281521293*^9, 3.567185137410382*^9, 3.5675865233171005`*^9, 
   3.5676004800217247`*^9, 3.567859438490351*^9, 3.56786057106894*^9, 
   3.5678613071572337`*^9, 3.567861520206807*^9, 3.567861619298181*^9, 
   3.567861716049551*^9, 3.567861810351717*^9, 3.567862035865713*^9, 
   3.567862204954409*^9, 3.567862536689993*^9, 3.5678626837514505`*^9, 
   3.567862771564005*^9, 3.567863320560169*^9, 3.5678634151899357`*^9, 
   3.5678639368236513`*^9, 3.567864088987319*^9, 3.5678642541136093`*^9, 
   3.567864767229711*^9, 3.5678650161593475`*^9, 3.567865315087073*^9, 
   3.5678655288708477`*^9, 3.56787745408896*^9, 3.567911948174492*^9, 
   3.56791306270285*^9, 3.567916910300386*^9, 3.567917676698532*^9, 
   3.567918361493935*^9, 3.56791861500998*^9, 3.567919444869038*^9, 
   3.567919756947586*^9, 3.567924258107492*^9, 3.5679261753206596`*^9, 
   3.5679264771187897`*^9, 3.5679268616906652`*^9, 3.567929474170055*^9, 
   3.567929590920659*^9, 3.5679296723840036`*^9, 3.567929856573526*^9, 
   3.567930083617325*^9, 3.5679301751738853`*^9, 3.5679303368837695`*^9, 
   3.567930622738672*^9, 3.567931058790639*^9, 3.5679312107973056`*^9, 
   3.567931331853518*^9, 3.567931467246155*^9, 3.567931520287248*^9, 
   3.567931626071034*^9, 3.567931950536004*^9, 3.567932631867201*^9, 
   3.567932751425811*^9, 3.567933125983468*^9, 3.5679332332024574`*^9, 
   3.567933464426063*^9, 3.567934710432452*^9, 3.567935972257268*^9, 
   3.5681150048655577`*^9, 3.568115908700944*^9, 3.568122253407688*^9, 
   3.568122355603468*^9, 3.568123412553124*^9, 3.568895117036213*^9, 
   3.5688954836212564`*^9, 3.57164915637276*^9, 3.572165390056032*^9, 
   3.57217513578355*^9, 3.572175206935275*^9, 3.57217652456139*^9, 
   3.572177190035959*^9, 3.572177290796537*^9, 3.574769483422638*^9, 
   3.582348620679166*^9, 3.5823486675728483`*^9, 3.582348910574475*^9, 
   3.583067237109578*^9, 3.583562343814082*^9, 3.583562487193934*^9, 
   3.584196655088931*^9, 3.5847670900151978`*^9, 3.5847677735303984`*^9, 
   3.5847681293046227`*^9, 3.584768643997327*^9, 3.5847738101998715`*^9, 
   3.584774006229816*^9, 3.584774460066814*^9, 3.5847748812207537`*^9, 
   3.5847752363553777`*^9, 3.5847754986698375`*^9, 3.58477563669888*^9, {
   3.584777749615392*^9, 3.5847777581486073`*^9}, 3.584882231958867*^9, 
   3.587025166059654*^9, 3.587653682756033*^9, {3.5876537685269847`*^9, 
   3.587653776482998*^9}, 3.588238727934762*^9, 3.589198366305758*^9, 
   3.59014688923277*^9, 3.59014752125228*^9, 3.5901483301761003`*^9, 
   3.590148591258159*^9, 3.590318328678983*^9, 3.592139786374529*^9, 
   3.592140061825915*^9, 3.592140125316004*^9, 3.592140371486348*^9, 
   3.592141013417247*^9, 3.592142182358884*^9, 3.592218077760034*^9, 
   3.5922183771904535`*^9, 3.5922187867610264`*^9, 3.592219193242595*^9, 
   3.5922193660228376`*^9, 3.598170408294114*^9, 3.598188084314051*^9, 
   3.600328176449328*^9, 3.6037197610216484`*^9, 3.6037198957418356`*^9, 
   3.6037200269120207`*^9, 3.6037204353825912`*^9, 3.6037206581829047`*^9, 
   3.603720793184093*^9, 3.603720922004273*^9, 3.6037215804751954`*^9, 
   3.603721640095278*^9, 3.603722556247561*^9, 3.607076277435503*^9, 
   3.615127544579868*^9, 3.615127672110046*^9, 3.615127771800186*^9, 
   3.615127836270276*^9, 3.6151281694071336`*^9, 3.6151290219683275`*^9, 
   3.615129055808375*^9, 3.615129724579311*^9, 3.61961581323652*^9, 
   3.6196160416008873`*^9, 3.619616968747371*^9, 3.619617066547508*^9, 
   3.619617212901761*^9, 3.619689235826536*^9, 3.619689451940886*^9, 
   3.6196894924309435`*^9, 3.619689956290689*^9, 3.619690121890921*^9, 
   3.620539306438477*^9, 3.620803638260658*^9, 3.620804078161273*^9, 
   3.62080414716137*^9, 3.648395060775346*^9, 3.648395210525556*^9, 
   3.680003708300235*^9, 3.680101707725405*^9, 3.838711142628691*^9, 
   3.838711275869321*^9, 3.8388055017217503`*^9, 3.8388825011063757`*^9, 
   3.839149891191987*^9, 3.8391514230383244`*^9, 3.8396719699560013`*^9, 
   3.83967207688919*^9, 3.839687408081276*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"4deb7140-724a-4b25-a2dd-9619f2c3bda2"]
}, Open  ]],

Cell["Now this is not being used. Deactivated cell :", "Text",ExpressionUUID->"84bb3443-3e2c-461e-a950-102aa1c686b1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BeginExamples", "[", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Set", "[", 
     RowBox[{"$Context", ",", "\"\<Global`\>\""}], "]"}], ";", 
    RowBox[{"Global`symbols", "=", 
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}]}], ";", "Null"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Global`EndExamples", "[", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<There are new symbols in Global`:\>\"", ",", "#"}], 
         "]"}]}], "]"}], ";", 
      RowBox[{"Set", "[", 
       RowBox[{"$Context", ",", "\"\<xAct`SymManipulator`Private`\>\""}], 
       "]"}], ";", "Null"}], ")"}], "&"}], "@", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], ",", "Global`symbols"}],
     "]"}]}]}]}], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.461421131680689*^9, 3.4614211327892327`*^9}, {
   3.515744927762471*^9, 3.515744930469626*^9}, 
   3.5159383601761465`*^9},ExpressionUUID->"b6d4a812-d5f1-4e2e-af02-\
045998eaf69f"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Group theory", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"ee579a5e-87e7-4008-b9f1-4b27fa57e95f"],

Cell[CellGroupData[{

Cell["2.0. MathLink", "Subsubsection",
 CellChangeTimes->{{3.6037192558499413`*^9, 
  3.603719259859946*^9}},ExpressionUUID->"00f67f60-1707-4e13-8408-\
5aa3aac8c915"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MathLinkBaseChangeStabilizerChain", "[", 
   RowBox[{"sgs_", ",", "newbase_"}], "]"}], ":=", 
  RowBox[{"MathLinkBaseChangeStabilizerChain", "[", 
   RowBox[{"sgs", ",", "newbase", ",", 
    RowBox[{"Max", "[", 
     RowBox[{
      RowBox[{"PermLength", "@", "sgs"}], ",", 
      RowBox[{"Max", "@", "newbase"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.603721339784858*^9, 3.603721346304867*^9}, {
  3.6202030894883785`*^9, 3.620203090928381*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"0e1cddb2-252a-4f65-9db0-91d420feaa0b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MathLinkBaseChangeStabilizerChain", "[", 
    RowBox[{"sgs_", ",", "newbase_", ",", "len_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "tmp", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"tmp", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{"xAct`xPerm`Private`TMPHead", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"len", "+", "2"}], ",", "\[IndentingNewLine]", 
           RowBox[{"xAct`xPerm`Private`tosgslist", "[", 
            RowBox[{"sgs", ",", "len", ",", "False"}], "]"}], ",", 
           "\[IndentingNewLine]", "newbase"}], "\[IndentingNewLine]", "]"}], 
         ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"TranslatePerm", "[", 
         RowBox[{
          RowBox[{"xAct`xPerm`Private`ToSign", "[", 
           RowBox[{"#", ",", "len"}], "]"}], ",", 
          RowBox[{"NotationOfPerm", "[", "sgs", "]"}]}], "]"}], "&"}], "/@", 
       RowBox[{"Apply", "[", 
        RowBox[{
        "xAct`xPerm`Private`MLBaseChangeStabilizerChain", ",", "tmp"}], 
        "]"}]}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6002732577771297`*^9, 3.6002733589578886`*^9}, {
   3.6002734211864405`*^9, 3.60027343093449*^9}, {3.60027349452277*^9, 
   3.600273513159042*^9}, {3.600273662950078*^9, 3.60027366408985*^9}, {
   3.6002738333669877`*^9, 3.60027385800206*^9}, {3.600273889617735*^9, 
   3.600273892587141*^9}, 3.600273977960063*^9, {3.600275158526711*^9, 
   3.6002751627361217`*^9}, {3.6002753111863356`*^9, 3.600275332703323*^9}, {
   3.600275862413153*^9, 3.6002758627431073`*^9}, {3.6009734718473687`*^9, 
   3.600973554317484*^9}, {3.600973603187552*^9, 3.60097363024759*^9}, {
   3.60156629292221*^9, 3.601566302352223*^9}, {3.601566419402387*^9, 
   3.6015664409024177`*^9}, {3.6015664931524897`*^9, 3.601566496012494*^9}, 
   3.601566849392988*^9, 3.6015668797330313`*^9, 3.601566917753084*^9, {
   3.601566965593151*^9, 3.601566975253165*^9}, 3.601567012143216*^9, {
   3.601567492123888*^9, 3.601567495463893*^9}, {3.6033814638902082`*^9, 
   3.603381511560275*^9}, 3.6033849339780664`*^9, 3.603476373574383*^9, 
   3.603551512166024*^9, 3.603551614256168*^9, {3.60371993446189*^9, 
   3.603719938821896*^9}, {3.6037203781025124`*^9, 3.603720393602533*^9}, {
   3.603720607212832*^9, 3.603720635982872*^9}, {3.603721349664871*^9, 
   3.603721355174879*^9}, {3.603721625645258*^9, 3.603721626095259*^9}, {
   3.619615407791904*^9, 3.6196154308119364`*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"70276e48-000e-47eb-8931-fc9f2a95c435"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MathLinkBaseChange", "[", 
    RowBox[{"sgs_", ",", "newbase_", ",", "len_", ",", "options___"}], "]"}], 
   ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "tmp", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"tmp", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{"xAct`xPerm`Private`TMPHead", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"len", "+", "2"}], ",", "\[IndentingNewLine]", 
           RowBox[{"xAct`xPerm`Private`tosgslist", "[", 
            RowBox[{"sgs", ",", "len", ",", "False"}], "]"}], ",", 
           "\[IndentingNewLine]", "newbase"}], "\[IndentingNewLine]", "]"}], 
         ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"TranslatePerm", "[", 
       RowBox[{
        RowBox[{"xAct`xPerm`Private`ToSign", "[", 
         RowBox[{
          RowBox[{"Apply", "[", 
           RowBox[{"xAct`xPerm`Private`MLBaseChange", ",", "tmp"}], "]"}], 
          ",", "len"}], "]"}], ",", 
        RowBox[{"NotationOfPerm", "[", "sgs", "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6002732577771297`*^9, 3.6002733589578886`*^9}, {
   3.6002734211864405`*^9, 3.60027343093449*^9}, {3.60027349452277*^9, 
   3.600273513159042*^9}, {3.600273662950078*^9, 3.60027366408985*^9}, {
   3.6002738333669877`*^9, 3.60027385800206*^9}, {3.600273889617735*^9, 
   3.600273892587141*^9}, 3.600273977960063*^9, {3.600275158526711*^9, 
   3.6002751627361217`*^9}, {3.6002753111863356`*^9, 3.600275332703323*^9}, {
   3.600275862413153*^9, 3.6002758627431073`*^9}, {3.6009734718473687`*^9, 
   3.600973554317484*^9}, {3.600973603187552*^9, 3.60097363024759*^9}, {
   3.60156629292221*^9, 3.601566302352223*^9}, {3.601566419402387*^9, 
   3.6015664409024177`*^9}, {3.6015664931524897`*^9, 3.601566496012494*^9}, 
   3.601566849392988*^9, 3.6015668797330313`*^9, 3.601566917753084*^9, {
   3.601566965593151*^9, 3.601566975253165*^9}, 3.601567012143216*^9, {
   3.601567492123888*^9, 3.601567495463893*^9}, {3.6033814638902082`*^9, 
   3.603381511560275*^9}, 3.6033849339780664`*^9, 3.603476373574383*^9, {
   3.603477258496622*^9, 3.603477266917633*^9}, {3.603477372937782*^9, 
   3.603477419257847*^9}, {3.603477739808295*^9, 3.603477755668318*^9}, {
   3.603551622766179*^9, 3.603551639036202*^9}, {3.603718808929314*^9, 
   3.603718816379325*^9}, {3.603718851309374*^9, 3.6037188517193747`*^9}, {
   3.6037198413717604`*^9, 3.6037198714218016`*^9}, {3.6037199419219017`*^9, 
   3.603719995291975*^9}, 3.603720403092546*^9, {3.603720868814198*^9, 
   3.603720890734229*^9}, {3.603721267784758*^9, 3.603721315884824*^9}, {
   3.619615058277367*^9, 3.6196150602273693`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"86762c15-dba8-40f3-b890-1eda2d4a5433"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "BaseChange2", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"MathLink", "\[Rule]", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"LinkPatterns", "[", "$xpermLink", "]"}], "/.", 
        RowBox[{"HoldForm", "\[Rule]", "Head"}]}], ",", 
       "xAct`xPerm`Private`MLBaseChange"}], "]"}]}], "}"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.619614749111885*^9, 3.619614775011922*^9}, {
   3.619614815551978*^9, 3.6196148314420004`*^9}, 3.619616346496363*^9},
 CellLabel->
  "In[144]:=",ExpressionUUID->"88b30147-713c-4351-a51b-7dfca0bd1a39"],

Cell[BoxData[
 RowBox[{
  RowBox[{"BaseChange2", "[", 
   RowBox[{"sgs_StrongGenSet", ",", "newbase_"}], "]"}], ":=", 
  RowBox[{"BaseChange2", "[", 
   RowBox[{"sgs", ",", "newbase", ",", 
    RowBox[{"Max", "[", 
     RowBox[{
      RowBox[{"PermLength", "@", "sgs"}], ",", 
      RowBox[{"Max", "@", "newbase"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6037212944447947`*^9, 3.603721309544815*^9}, {
  3.603722232867108*^9, 3.603722235407111*^9}, {3.619614908833109*^9, 
  3.619614924333131*^9}, {3.620203074278358*^9, 3.620203075228359*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"c8d0552a-8004-45e2-924d-a99067c06adc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BaseChange2", "[", 
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_", ",", " ", "gs_"}], "]"}], ",", "base_", ",", "len_"}], 
    "]"}], ":=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{"base", ",", " ", "gs"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.603722240587119*^9, 3.6037222782271724`*^9}, {
  3.619614928253136*^9, 3.619614929963138*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"5001a9bc-e8fc-4344-8edd-a3be687cedb6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BaseChange2", "[", 
    RowBox[{"sgs_", ",", "newbase_", ",", "len_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"OptionValue", "[", "MathLink", "]"}], ",", 
      "MathLinkBaseChange", ",", "BaseChange"}], "]"}], "[", 
    RowBox[{"sgs", ",", "newbase", ",", "len", ",", "options"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.619614952173169*^9, 3.619615033047331*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"6ec804e6-d3ad-4fa9-8b02-bf9be3e2c270"],

Cell[TextData[{
 "Observe that the current ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " code keeps the order of the rest of the base as the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " impementation."
}], "Text",
 CellChangeTimes->{{3.619687651343077*^9, 3.619687723943178*^9}, {
  3.620025578012841*^9, 3.6200255967228675`*^9}, {3.620539224688362*^9, 
  3.620539254768404*^9}},ExpressionUUID->"f6689d9a-10aa-4815-8c72-\
6561ba200ca4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MathLinkStabilizerSGS", "[", 
    RowBox[{"pts_", ",", "sgs_", ",", "len_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "tmp", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"tmp", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{"xAct`xPerm`Private`TMPHead", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"len", "+", "2"}], ",", "\[IndentingNewLine]", 
           RowBox[{"xAct`xPerm`Private`tosgslist", "[", 
            RowBox[{"sgs", ",", "len", ",", "False"}], "]"}], ",", 
           "\[IndentingNewLine]", "pts"}], "\[IndentingNewLine]", "]"}], ",", 
         
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"TranslatePerm", "[", 
       RowBox[{
        RowBox[{"xAct`xPerm`Private`ToSign", "[", 
         RowBox[{
          RowBox[{"Apply", "[", 
           RowBox[{"xAct`xPerm`Private`MLStabilizerSGS", ",", "tmp"}], "]"}], 
          ",", "len"}], "]"}], ",", 
        RowBox[{"NotationOfPerm", "[", "sgs", "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[148]:=",ExpressionUUID->"859c4fac-9c6a-42a7-a6f1-463a7906d23d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "StabilizerSGS", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"MathLink", "\[Rule]", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"LinkPatterns", "[", "$xpermLink", "]"}], "/.", 
        RowBox[{"HoldForm", "\[Rule]", "Head"}]}], ",", 
       "xAct`xPerm`Private`StabilizerSGS"}], "]"}]}], "}"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.619687178813319*^9, 3.619687203823354*^9}, {
  3.620025606212881*^9, 3.6200256069728827`*^9}, {3.6205392614184146`*^9, 
  3.620539271148427*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"236521d1-5781-4ff0-8a69-3e610d37d763"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StabilizerSGS", "[", 
    RowBox[{"points_List", ",", "SGS_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"StabilizerSGS", "[", 
    RowBox[{"points", ",", "SGS", ",", 
     RowBox[{"PermLength", "[", "SGS", "]"}], ",", "options"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"StabilizerSGS", "[", 
    RowBox[{"ps_List", ",", 
     RowBox[{"Symmetric", "[", "list_", "]"}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"Complement", "[", 
     RowBox[{"list", ",", "ps"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"StabilizerSGS", "[", 
    RowBox[{"ps_List", ",", 
     RowBox[{"Antisymmetric", "[", "list_", "]"}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"Complement", "[", 
     RowBox[{"list", ",", "ps"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"StabilizerSGS", "[", 
    RowBox[{"points_List", ",", 
     RowBox[{"SGS", ":", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base_", ",", "GS_"}], "]"}]}], ",", "len_Integer", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"OptionValue", "[", "MathLink", "]"}], ",", 
     RowBox[{"MathLinkStabilizerSGS", "[", 
      RowBox[{"points", ",", "SGS", ",", "len"}], "]"}], ",", 
     RowBox[{"Stabilizer", "[", 
      RowBox[{"points", ",", "SGS", ",", "len"}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.619687168053304*^9, 3.619687172593311*^9}, 
   3.619687391018664*^9, {3.6196874549887533`*^9, 3.619687463998766*^9}, {
   3.619687496868812*^9, 3.619687598463003*^9}, {3.6196893984208117`*^9, 
   3.619689427130852*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"d100f0bc-3eb8-4e4a-8094-8afc7b34bad2"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1. Basic group and set theory", "Subsubsection",ExpressionUUID->"e2e28474-2b90-40ea-ada7-67177b44f363"],

Cell[TextData[{
 "We need the internal function PartitionRagged. For old versions of ",
 StyleBox["Mathematica, ",
  FontSlant->"Italic"],
 "we need to supply an implementation."
}], "Text",
 CellChangeTimes->{{3.590312034416831*^9, 
  3.590312098891744*^9}},ExpressionUUID->"844942dc-577e-4ae5-8c59-\
ce2afc9cf3de"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"oldPartitionRagged", "[", 
     RowBox[{"l_", ",", "p_"}], "]"}], ":=", 
    RowBox[{"Last", "/@", 
     RowBox[{"Rest", "@", 
      RowBox[{"FoldList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Drop", "[", 
            RowBox[{
             RowBox[{"#1", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}], ",", 
           RowBox[{"Take", "[", 
            RowBox[{
             RowBox[{"#1", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}]}], "}"}], 
         "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"l", ",", 
          RowBox[{"{", "}"}]}], "}"}], ",", "p"}], "]"}]}]}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"System`$VersionNumber", "<", "8."}], ",", 
    RowBox[{"partitionRagged", "=", "oldPartitionRagged"}], ",", 
    RowBox[{"partitionRagged", "=", "Internal`PartitionRagged"}]}], "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.583561961847411*^9, 3.583561961847411*^9}, {
   3.583562084432427*^9, 3.58356209738045*^9}, {3.58356214299493*^9, 
   3.5835621687973757`*^9}, {3.583562225394274*^9, 3.583562237749496*^9}, 
   3.583562471578306*^9},
 CellLabel->
  "In[154]:=",ExpressionUUID->"700a6e1f-3dd6-4a61-8f15-01e972bdaf44"],

Cell[TextData[{
 "Check if a set is a subset of the other. Observe that a new function in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 10 has the same name and meaning, but a different order of the arguments."
}], "Text",
 CellChangeTimes->{{3.590312113072169*^9, 3.590312140263017*^9}, {
  3.6151296123791537`*^9, 
  3.6151296728292384`*^9}},ExpressionUUID->"84218826-f4b1-4298-af3b-\
63f31f52bce5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"System`$VersionNumber", "<", "10."}], ",", 
    RowBox[{
     RowBox[{"subsetQ", "[", 
      RowBox[{"inds1_", ",", "inds2_"}], "]"}], ":=", 
     RowBox[{"And", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"List", "@@", "inds2"}], ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"(", 
         RowBox[{"List", "@@", "inds1"}], ")"}]}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"subsetQ", "[", 
      RowBox[{"inds1_", ",", "inds2_"}], "]"}], ":=", 
     RowBox[{"SubsetQ", "[", 
      RowBox[{"inds2", ",", "inds1"}], "]"}]}]}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.615125923113234*^9, 3.615125932963248*^9}, {
  3.615129400168856*^9, 3.615129428758897*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"27fc2b67-df89-4a76-a702-9ee548132948"],

Cell["Check if a group is a subgroup of the other. ", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.590312113072169*^9, 3.590312140263017*^9}, {
   3.590312476682504*^9, 3.5903125221721835`*^9}, 
   3.59031255402744*^9},ExpressionUUID->"40cd2d58-36f0-4202-a37f-\
0e181bfd92c6"],

Cell["Symmetric cases.", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.590312556055444*^9, 3.5903125692062664`*^9}, {
  3.5903126116071405`*^9, 3.590312615397948*^9}, {3.5903127359861593`*^9, 
  3.5903127588246*^9}},ExpressionUUID->"b3b48ef4-ae69-4c55-8b20-01056af50297"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubgroupQ", "[", 
   RowBox[{
    RowBox[{"sym1", ":", 
     RowBox[{"(", 
      RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], ",", 
    "sym2_StrongGenSet"}], "]"}], ":=", 
  RowBox[{"SubgroupQ", "[", 
   RowBox[{
    RowBox[{"GenSet", "@", "sym1"}], ",", "sym2"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5678598374620514`*^9, 3.5678598530620785`*^9}, {
  3.5678599366938252`*^9, 3.567859938597029*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"31ba98c9-641e-450b-94d6-25693b45a162"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubgroupQ", "[", 
   RowBox[{"sym1_", ",", 
    RowBox[{"sym2", ":", 
     RowBox[{"(", 
      RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}]}], "]"}], ":=", 
  RowBox[{"SubgroupQ", "[", 
   RowBox[{"sym1", ",", 
    RowBox[{"Append", "[", 
     RowBox[{"sym2", ",", "Cycles"}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5678623699558997`*^9, 3.5678624862239037`*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"f9f47462-3ba6-4310-8f39-608697b007f3"],

Cell["\<\
For general cases we need to check that the generators of the first group is \
in the other group.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.590312556055444*^9, 
  3.5903125692062664`*^9}},ExpressionUUID->"4b0d7b6c-d5a5-4c8f-8204-\
1ee653bee8b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubgroupQ", "[", 
   RowBox[{"sym1_StrongGenSet", ",", "sym2_StrongGenSet"}], "]"}], ":=", 
  RowBox[{"SubgroupQ", "[", 
   RowBox[{
    RowBox[{"Last", "@", "sym1"}], ",", "sym2"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567859200246732*^9, 3.5678592420236053`*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"afbcc003-c3c8-430c-931a-71a67d0b1778"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubgroupQ", "[", 
   RowBox[{"gs1_GenSet", ",", "sym2_StrongGenSet"}], "]"}], ":=", 
  RowBox[{"And", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"PermMemberQ", "[", 
       RowBox[{"#", ",", "sym2"}], "]"}], "&"}], "/@", 
     RowBox[{"List", "@@", "gs1"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.495469281175005*^9, 3.495469313451404*^9}, {
   3.511527480953811*^9, 3.5115274970218115`*^9}, {3.567859169093477*^9, 
   3.5678591969707265`*^9}, {3.567859247967216*^9, 3.5678592535052257`*^9}, 
   3.567861967194392*^9},
 CellLabel->
  "In[160]:=",ExpressionUUID->"43565681-6d0c-49b2-b7ca-bc35f78f5ebe"],

Cell["\<\
Computation of the group support, i. e. the points that are moved by some \
element in the group.\
\>", "Text",
 CellChangeTimes->{{3.590312638189587*^9, 
  3.590312664803234*^9}},ExpressionUUID->"afadf0a8-7bfe-4b1b-ad8a-\
004d3ff3b57b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroupSupport", "[", 
   RowBox[{"sym", ":", 
    RowBox[{"(", 
     RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], "]"}], ":=", 
  RowBox[{"Sort", "@", 
   RowBox[{"First", "@", "sym"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567859535851122*^9, 3.56785957503839*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"dd09955e-fb46-4f27-8ac3-58c0b157c5ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroupSupport", "[", "gs1_GenSet", "]"}], ":=", 
  RowBox[{"xAct`xTensor`Private`support", "[", "gs1", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567859404965892*^9, 3.567859476804018*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"21bc30ef-6b42-4406-82b0-c8ecac610f9b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroupSupport", "[", "SGS1_StrongGenSet", "]"}], ":=", 
  RowBox[{"xAct`xTensor`Private`support", "[", 
   RowBox[{"Last", "@", "SGS1"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567859489721841*^9, 3.567859520188694*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"91378ba4-3037-497a-ab05-f4ae36caf053"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroupSupport", "[", "sym_", "]"}], ":=", 
  RowBox[{"xAct`xTensor`Private`support", "[", 
   RowBox[{"Last", "@", 
    RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "sym"}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.5678596291548843`*^9, 3.567859674816166*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"78d53978-ce1a-487d-b268-df6975ce3243"],

Cell["Find a nicer representation of the group.", "Text",
 CellChangeTimes->{{3.59031277618743*^9, 
  3.590312789244653*^9}},ExpressionUUID->"13080188-ae2c-4597-a8a4-\
0fb8329abbdf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TidySGS", "[", "sym_", "]"}], ":=", 
  RowBox[{"DeleteSomeRedundantGenerators", "@", 
   RowBox[{"BaseChange2", "[", 
    RowBox[{
     RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "sym"}], ",", 
     RowBox[{"GroupSupport", "@", "sym"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5678600467364197`*^9, 3.567860052102829*^9}, {
   3.567860087608491*^9, 3.567860183096258*^9}, {3.6015569491639194`*^9, 
   3.6015569618539376`*^9}, {3.601557503584696*^9, 3.601557507824702*^9}, {
   3.603719365040093*^9, 3.6037193696500998`*^9}, 3.6196151173474493`*^9},
 CellLabel->
  "In[165]:=",ExpressionUUID->"3ef8bad7-101e-4fdb-8a6f-a2bcd6defe4b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TidyGroup", "[", "sym_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"unstablepoints", "=", 
      RowBox[{"GroupSupport", "@", "sym"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Which", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "@", "unstablepoints"}], "\[Equal]", "0"}], ",", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"SubgroupQ", "[", 
       RowBox[{
        RowBox[{"Symmetric", "@", "unstablepoints"}], ",", "sym"}], "]"}], 
      ",", 
      RowBox[{"Symmetric", "@", "unstablepoints"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SubgroupQ", "[", 
       RowBox[{
        RowBox[{"Antisymmetric", "@", "unstablepoints"}], ",", "sym"}], "]"}],
       ",", 
      RowBox[{"Antisymmetric", "@", "unstablepoints"}], ",", 
      "\[IndentingNewLine]", "True", ",", 
      RowBox[{"TidySGS", "@", "sym"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567860204983097*^9, 3.5678604164102683`*^9}, 
   3.567860533535274*^9, {3.567864014918389*^9, 3.567864057506464*^9}, {
   3.567919608466525*^9, 3.567919610260528*^9}, {3.567919646858193*^9, 
   3.567919648527396*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"e5710f68-148e-4afa-bc43-acbb56579cd0"],

Cell["Try to factor the group.", "Text",
 CellChangeTimes->{{3.5903128022550755`*^9, 
  3.590312810070689*^9}},ExpressionUUID->"d5530309-822e-4782-99e1-\
ee9f0a61a851"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroupFactorization1", "[", "SGS_StrongGenSet", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"orbits", "=", 
       RowBox[{"Orbits", "@", "SGS"}]}], ",", "factors", ",", "prodgroup"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"factors", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Stabilizer", "[", 
         RowBox[{
          RowBox[{"Flatten", "@", 
           RowBox[{"Delete", "[", 
            RowBox[{"orbits", ",", "#"}], "]"}]}], ",", "SGS"}], "]"}], "&"}],
        "/@", 
       RowBox[{"Range", "@", 
        RowBox[{"Length", "@", "orbits"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"prodgroup", "=", 
      RowBox[{"JoinSGS", "@@", "factors"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "If", " ", "the", " ", "group", " ", "factors", " ", "completely", " ",
         "into", " ", "ints", " ", "orbits"}], ",", " ", 
       RowBox[{"return", " ", "the", " ", "factorization"}], ",", " ", 
       RowBox[{
        RowBox[{
        "otherwise", " ", "return", " ", "the", " ", "group", " ", "as", " ", 
         "it", " ", 
         RowBox[{"is", ".", " ", "If"}], " ", "we", " ", "have", " ", 
         "several", " ", "orbits", " ", "the", " ", "second", " ", "case", 
         " ", "can", " ", "be", " ", "improved"}], "..."}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"And", "[", 
        RowBox[{
         RowBox[{"SubgroupQ", "[", 
          RowBox[{"SGS", ",", "prodgroup"}], "]"}], ",", 
         RowBox[{"SubgroupQ", "[", 
          RowBox[{"prodgroup", ",", "SGS"}], "]"}]}], "]"}], ",", "factors", 
       ",", 
       RowBox[{"{", "SGS", "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.619687846407398*^9, 3.619687846817399*^9}, 
   3.619687882757449*^9},
 CellLabel->
  "In[167]:=",ExpressionUUID->"8ff2bd47-eb05-403f-9ba9-cb1e3f71f3ae"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. More group theory", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{
  3.527143618439955*^9, {3.566218071274899*^9, 3.566218104223157*^9}, {
   3.6014727947329884`*^9, 
   3.601472798602994*^9}},ExpressionUUID->"e6511545-3433-44de-b6a9-\
f9781793d4e8"],

Cell["\<\
We implement a new code for the stabilizer chain which is much quicker.\
\>", "Text",
 CellChangeTimes->{{3.601560637123083*^9, 
  3.601560673493134*^9}},ExpressionUUID->"7764a530-f33d-4654-b920-\
4c7868bbdcd9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain2", "[", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{"base_List", ",", "GS_GenSet"}], "]"}], "]"}], ":=", 
  RowBox[{"Thread", "@", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Drop", "[", 
        RowBox[{"base", ",", "#"}], "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"Length", "@", "base"}]}], "]"}]}], ",", 
     RowBox[{"FoldList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Stabilizer", "[", 
         RowBox[{
          RowBox[{"{", "#2", "}"}], ",", "#1"}], "]"}], "&"}], ",", "GS", ",",
        "base"}], "]"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[168]:=",ExpressionUUID->"22ff758c-33f5-439c-b463-88fcbc6236bd"],

Cell["\<\
Here we extend the base change algorithm to work directly on the stabilizer \
chain instead. This can actually make it quicker.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.601472858283078*^9, 
  3.601472924883171*^9}},ExpressionUUID->"28eb3e33-e557-47ee-8baa-\
f9ca0e9ec8ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasicOrbitStabChain", "[", 
    RowBox[{"j_Integer", ",", "k_Integer", ",", "chain_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Orbit", "[", 
     RowBox[{
      RowBox[{"chain", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1", ",", "j"}], "]"}], "]"}], ",", 
      RowBox[{"chain", "[", 
       RowBox[{"[", 
        RowBox[{"k", "+", "1"}], "]"}], "]"}]}], "]"}], "/;", 
    RowBox[{"k", "<", "j"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6011287229699516`*^9, 3.6011287248299546`*^9}, {
   3.60112877221002*^9, 3.601128878100168*^9}, {3.601128919170225*^9, 
   3.601128976720307*^9}, 3.6011291255105147`*^9, {3.60112920071062*^9, 
   3.601129217240643*^9}, {3.601129302240762*^9, 3.601129326470796*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"06f84ef9-e7d0-423d-9ceb-f3ef905ee319"],

Cell["\<\
This is algorithm 12.3 of Butler with some slight modifications so it now \
works on the stabilizer chain.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{
  3.601472858283078*^9, {3.601473261743643*^9, 
   3.601473305473703*^9}},ExpressionUUID->"f32de050-b2d6-41f1-9df5-\
4a4946df3305"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterchangeStabChain", "[", 
   RowBox[{"chain_List", ",", "j_Integer", ",", "len_Integer"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"base", "=", 
      RowBox[{"First", "@", 
       RowBox[{"First", "@", "chain"}]}]}], "}"}], ",", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Deltaj", ",", "Deltajp1", ",", "LDeltaBarjp1", ",", "T", ",", "Gamma",
         ",", "Delta", ",", "gamma", ",", "p", ",", "g1", ",", "g2", ",", 
        "newT", ",", " ", "newbase", ",", "newGSj"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Deltaj", "=", 
        RowBox[{"BasicOrbitStabChain", "[", 
         RowBox[{"j", ",", 
          RowBox[{"j", "-", "1"}], ",", "chain"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Deltajp1", "=", 
        RowBox[{"BasicOrbitStabChain", "[", 
         RowBox[{
          RowBox[{"j", "+", "1"}], ",", "j", ",", "chain"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"LDeltaBarjp1", "=", 
        RowBox[{
         RowBox[{"Length", "[", "Deltajp1", "]"}], 
         RowBox[{
          RowBox[{"Length", "[", "Deltaj", "]"}], "/", 
          RowBox[{"Length", "[", 
           RowBox[{"BasicOrbitStabChain", "[", 
            RowBox[{
             RowBox[{"j", "+", "1"}], ",", 
             RowBox[{"j", "-", "1"}], ",", "chain"}], "]"}], "]"}]}]}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"T", "=", 
        RowBox[{"chain", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"j", "+", "2"}], ",", "2"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Gamma", "=", 
        RowBox[{"Complement", "[", 
         RowBox[{"Deltaj", ",", 
          RowBox[{"base", "[", 
           RowBox[{"[", 
            RowBox[{"{", 
             RowBox[{"j", ",", 
              RowBox[{"j", "+", "1"}]}], "}"}], "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Delta", "=", 
        RowBox[{"{", 
         RowBox[{"base", "[", 
          RowBox[{"[", "j", "]"}], "]"}], "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "Delta", "]"}], "\[NotEqual]", 
          "LDeltaBarjp1"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"gamma", "=", 
           RowBox[{"First", "[", "Gamma", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"g1", "=", 
           RowBox[{"TraceSchreier", "[", 
            RowBox[{"gamma", ",", 
             RowBox[{"SchreierOrbit", "[", 
              RowBox[{
               RowBox[{"base", "[", 
                RowBox[{"[", "j", "]"}], "]"}], ",", 
               RowBox[{"chain", "[", 
                RowBox[{"[", "j", "]"}], "]"}], ",", "len"}], "]"}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"p", "=", 
           RowBox[{"OnPoints", "[", 
            RowBox[{
             RowBox[{"base", "[", 
              RowBox[{"[", 
               RowBox[{"j", "+", "1"}], "]"}], "]"}], ",", 
             RowBox[{"InversePerm", "[", "g1", "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{"Deltajp1", ",", "p"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"g2", "=", 
              RowBox[{"TraceSchreier", "[", 
               RowBox[{"p", ",", 
                RowBox[{"SchreierOrbit", "[", 
                 RowBox[{
                  RowBox[{"base", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", "+", "1"}], "]"}], "]"}], ",", 
                  RowBox[{"chain", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", "+", "1"}], "]"}], "]"}], ",", "len"}], 
                 "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Do", " ", "we", " ", "need", " ", "to", " ", "check", " ", 
               "if", " ", 
               RowBox[{"PermProduct", "[", 
                RowBox[{"g2", ",", "g1"}], "]"}], " ", "is", " ", "already", 
               " ", "in", " ", "T", " ", "before", " ", "we", " ", "add", " ", 
               RowBox[{"it", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"AppendTo", "[", 
              RowBox[{"T", ",", 
               RowBox[{"PermProduct", "[", 
                RowBox[{"g2", ",", "g1"}], "]"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Delta", "=", 
              RowBox[{"Orbit", "[", 
               RowBox[{
                RowBox[{"base", "[", 
                 RowBox[{"[", "j", "]"}], "]"}], ",", "T"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Gamma", "=", 
              RowBox[{"Complement", "[", 
               RowBox[{"Gamma", ",", "Delta"}], "]"}]}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Gamma", "=", 
             RowBox[{"Complement", "[", 
              RowBox[{"Gamma", ",", 
               RowBox[{"Orbit", "[", 
                RowBox[{"gamma", ",", "T"}], "]"}]}], "]"}]}]}], 
           "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"newT", "=", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{
          RowBox[{"Drop", "[", 
           RowBox[{"T", ",", 
            RowBox[{"Length", "@", 
             RowBox[{"chain", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"j", "+", "2"}], ",", "2"}], "]"}], "]"}]}]}], "]"}], 
          ",", 
          RowBox[{"Alternatives", "@@", 
           RowBox[{"chain", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "2"}], "]"}], "]"}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"newGSj", "=", 
        RowBox[{"Stabilizer", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"base", "[", 
            RowBox[{"[", 
             RowBox[{"j", "+", "1"}], "]"}], "]"}], "}"}], ",", 
          RowBox[{"Union", "[", 
           RowBox[{
            RowBox[{"chain", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", "newT"}], "]"}]}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"newbase", "=", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Take", "[", 
           RowBox[{"base", ",", 
            RowBox[{"j", "-", "1"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"base", "[", 
             RowBox[{"[", 
              RowBox[{"j", "+", "1"}], "]"}], "]"}], ",", 
            RowBox[{"base", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"Drop", "[", 
           RowBox[{"base", ",", 
            RowBox[{"j", "+", "1"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Thread", "@", 
          RowBox[{"StrongGenSet", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Drop", "[", 
               RowBox[{"newbase", ",", "#"}], "]"}], "&"}], "/@", 
             RowBox[{"Range", "[", 
              RowBox[{"0", ",", "j"}], "]"}]}], ",", 
            RowBox[{"Append", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Join", "[", 
                 RowBox[{"#", ",", "newT"}], "]"}], "&"}], "/@", 
               RowBox[{"chain", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "j"}], ",", "2"}], "]"}], "]"}]}], ",", 
              "newGSj"}], "]"}]}], "]"}]}], ",", 
         RowBox[{"Drop", "[", 
          RowBox[{"chain", ",", 
           RowBox[{"j", "+", "1"}]}], "]"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.601129396380894*^9, 3.601129398260897*^9}, {
   3.60112953663109*^9, 3.6011295505011096`*^9}, {3.601129583051155*^9, 
   3.601129621281209*^9}, {3.601129945871663*^9, 3.601129949951669*^9}, {
   3.601129981611714*^9, 3.601129999071738*^9}, {3.601130092001868*^9, 
   3.601130095061872*^9}, {3.601130146011943*^9, 3.6011301480819473`*^9}, {
   3.601130186051999*^9, 3.601130188612003*^9}, {3.6011345101801734`*^9, 
   3.60113451583018*^9}, {3.601134592920288*^9, 3.601134599690298*^9}, {
   3.601135268521235*^9, 3.601135284081256*^9}, {3.6011356802918105`*^9, 
   3.6011357158718605`*^9}, {3.601135800361979*^9, 3.601135809371991*^9}, {
   3.601135972942221*^9, 3.6011360437223206`*^9}, {3.601136101992401*^9, 
   3.60113613711245*^9}, {3.6011366464841638`*^9, 3.601136706334247*^9}, {
   3.601136738394292*^9, 3.601136740744295*^9}, {3.6011368414744377`*^9, 
   3.601136887874501*^9}, {3.6011369579546*^9, 3.601137038594713*^9}, {
   3.601137103584803*^9, 3.60113715789488*^9}, {3.601137590155484*^9, 
   3.601137626655536*^9}, {3.601137671295598*^9, 3.601137764985729*^9}, {
   3.601137810355793*^9, 3.601137813035796*^9}, {3.601138077946168*^9, 
   3.601138166006291*^9}, 3.601138252106411*^9, 3.6011383171565037`*^9, {
   3.601138533106805*^9, 3.60113853706681*^9}, {3.6011386895770235`*^9, 
   3.6011386899970245`*^9}, {3.60113882967822*^9, 3.601138830478221*^9}, {
   3.601138979098429*^9, 3.601139005408467*^9}, 3.601139116568621*^9, {
   3.601450415491702*^9, 3.601450459571763*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"79c6b731-8017-4e88-87ec-f820616c5db3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConjugateStabChain", "[", 
   RowBox[{"chain_List", ",", 
    RowBox[{"g_", "?", "PermQ"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"newbase", "=", 
       RowBox[{"OnPoints", "[", 
        RowBox[{
         RowBox[{"First", "@", 
          RowBox[{"First", "@", "chain"}]}], ",", "g"}], "]"}]}], ",", 
      RowBox[{"oldGS", "=", 
       RowBox[{"Last", "@", 
        RowBox[{"First", "@", "chain"}]}]}], ",", "newGS", ",", 
      RowBox[{"l", "=", 
       RowBox[{"Length", "@", "chain"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"newGS", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"PermProduct", "[", 
         RowBox[{
          RowBox[{"InversePerm", "[", "g", "]"}], ",", "#", ",", "g"}], "]"}],
         "&"}], "/@", "oldGS"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Thread", "@", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Drop", "[", 
           RowBox[{"newbase", ",", "#"}], "]"}], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", 
           RowBox[{"l", "-", "1"}]}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "chain"}], ")"}], "/.", 
         RowBox[{"Thread", "@", 
          RowBox[{"Rule", "[", 
           RowBox[{
            RowBox[{"List", "@@", "oldGS"}], ",", 
            RowBox[{"List", "@@", "newGS"}]}], "]"}]}]}]}], "]"}]}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.601451533723267*^9, 3.601451579503331*^9}, {
  3.601451654783437*^9, 3.6014518566037197`*^9}, {3.601451888394764*^9, 
  3.6014519989849186`*^9}, {3.6014520563449993`*^9, 3.601452113155079*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"6bbeeb56-0502-4960-93fa-de9a5a6ec3d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendBasePointStabChain", "[", 
   RowBox[{"chain_List", ",", "p_"}], "]"}], ":=", 
  RowBox[{"Append", "[", 
   RowBox[{
    RowBox[{"MapAt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Append", "[", 
        RowBox[{"#", ",", "p"}], "]"}], "&"}], ",", "chain", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", "1"}], "}"}], "&"}], "/@", 
       RowBox[{"Range", "@", 
        RowBox[{"Length", "@", "chain"}]}]}]}], "]"}], ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.601452570715719*^9, 3.60145258601574*^9}, {
  3.601452621945791*^9, 3.601452711605917*^9}, {3.601452836336091*^9, 
  3.6014528929861703`*^9}, {3.6014530548563976`*^9, 3.6014530608264055`*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"6d7ca465-9ff3-4650-b0d7-d669acf48f46"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "BaseChangeStabChain", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"MathLink", "\[Rule]", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"LinkPatterns", "[", "$xpermLink", "]"}], "/.", 
        RowBox[{"HoldForm", "\[Rule]", "Head"}]}], ",", 
       "xAct`xPerm`Private`MLBaseChangeStabilizerChain"}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.619615301891755*^9, 3.6196153261417885`*^9}, 
   3.619616361146384*^9, 3.619616410726453*^9},
 CellLabel->
  "In[173]:=",ExpressionUUID->"42cdfc82-5ff6-402f-9f4f-d096a07c3396"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BaseChangeStabChain", "[", 
    RowBox[{"SGS_StrongGenSet", ",", "base_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"BaseChangeStabChain", "[", 
    RowBox[{"SGS", ",", "base", ",", 
     RowBox[{"PermLength", "[", "SGS", "]"}], ",", "options"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BaseChangeStabChain", "[", 
    RowBox[{"SGS_StrongGenSet", ",", "newbase_List", ",", "len_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"OptionValue", "[", "MathLink", "]"}], ",", 
     RowBox[{"MathLinkBaseChangeStabilizerChain", "[", 
      RowBox[{"SGS", ",", "newbase", ",", "len"}], "]"}], ",", 
     RowBox[{"BaseChangeStabChain2", "[", 
      RowBox[{
       RowBox[{"StabilizerChain2", "[", "SGS", "]"}], ",", "newbase", ",", 
       "len"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BaseChangeStabChain", "[", 
    RowBox[{"chain_List", ",", "base_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"BaseChangeStabChain", "[", 
    RowBox[{"chain", ",", "base", ",", 
     RowBox[{"PermLength", "@", 
      RowBox[{"First", "[", "chain", "]"}]}], ",", "options"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BaseChangeStabChain", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"GenSet", "[", "]"}]}], "]"}], "}"}], ",", "base_", ",", 
     "len_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"#", ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Drop", "[", 
        RowBox[{"base", ",", "#"}], "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"Length", "[", "base", "]"}]}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BaseChangeStabChain", "[", 
    RowBox[{"chain_List", ",", "newbase_List", ",", "len_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"OptionValue", "[", "MathLink", "]"}], ",", 
     RowBox[{"MathLinkBaseChangeStabilizerChain", "[", 
      RowBox[{
       RowBox[{"First", "@", "chain"}], ",", "newbase", ",", "len"}], "]"}], 
     ",", 
     RowBox[{"BaseChangeStabChain2", "[", 
      RowBox[{"chain", ",", "newbase", ",", "len"}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.601473020023304*^9, 3.601473179933528*^9}, {
   3.601473230573599*^9, 3.6014732322636013`*^9}, {3.601558655808309*^9, 
   3.601558702348375*^9}, {3.601558736468422*^9, 3.601558751458443*^9}, {
   3.601558894048643*^9, 3.601558894208643*^9}, 3.601560702723175*^9, {
   3.6037214494250116`*^9, 3.603721514415102*^9}, {3.619615449131962*^9, 
   3.6196154784920025`*^9}, {3.619615513302051*^9, 3.619615674556326*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"94e402e0-6258-4879-b85b-14409c9c6474"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BaseChangeStabChain2", "[", 
    RowBox[{"chain_List", ",", "newbase_List", ",", "len_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "=", "0"}], ",", "j", ",", 
       RowBox[{"g", "=", "ID"}], ",", "more", ",", 
       RowBox[{"B", "=", 
        RowBox[{"First", "@", 
         RowBox[{"First", "@", "chain"}]}]}], ",", 
       RowBox[{"newchain", "=", "chain"}], ",", "pos", ",", 
       RowBox[{"sorbits", "=", 
        RowBox[{"{", "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"more", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "newbase", "]"}], ">", "0"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"BasicOrbitStabChain", "[", 
            RowBox[{"1", ",", "0", ",", "chain"}], "]"}], ",", 
           RowBox[{"newbase", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "False"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"more", ",", 
        RowBox[{"sorbits", "=", 
         RowBox[{"SchreierOrbits", "[", 
          RowBox[{
           RowBox[{"Last", "@", 
            RowBox[{"First", "@", "chain"}]}], ",", "len"}], "]"}]}]}], "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{"more", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"i", "=", 
          RowBox[{"i", "+", "1"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"g", "=", 
          RowBox[{"PermProduct", "[", 
           RowBox[{
            RowBox[{"TraceSchreier", "[", 
             RowBox[{
              RowBox[{"OnPoints", "[", 
               RowBox[{
                RowBox[{"newbase", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{"InversePerm", "[", "g", "]"}]}], "]"}], ",", 
              "sorbits"}], "]"}], ",", "g"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"more", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"i", "+", "1"}], ")"}], "\[LessEqual]", 
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"Length", "[", "B", "]"}], ",", 
             RowBox[{"Length", "[", "newbase", "]"}]}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"more", ",", 
           RowBox[{"more", "=", 
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"OnPoints", "[", 
               RowBox[{
                RowBox[{"newbase", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", "+", "1"}], "]"}], "]"}], ",", 
                RowBox[{"InversePerm", "[", "g", "]"}]}], "]"}], ",", 
              RowBox[{"BasicOrbitStabChain", "[", 
               RowBox[{
                RowBox[{"i", "+", "1"}], ",", "i", ",", "chain"}], "]"}]}], 
             "]"}]}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"PermEqual", "[", 
          RowBox[{"g", ",", "ID"}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"newchain", "=", 
          RowBox[{"ConjugateStabChain", "[", 
           RowBox[{"chain", ",", "g"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"B", "=", 
          RowBox[{"First", "@", 
           RowBox[{"First", "@", "newchain"}]}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"j", "=", 
         RowBox[{"i", "+", "1"}]}], ",", 
        RowBox[{"j", "\[LessEqual]", 
         RowBox[{"Length", "[", "newbase", "]"}]}], ",", 
        RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"B", ",", 
             RowBox[{"newbase", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"pos", "=", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"B", ",", 
               RowBox[{"newbase", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"AppendTo", "[", 
             RowBox[{"B", ",", 
              RowBox[{"newbase", "[", 
               RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ";", 
            RowBox[{"newchain", "=", 
             RowBox[{"AppendBasePointStabChain", "[", 
              RowBox[{"newchain", ",", 
               RowBox[{"newbase", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}], ";", 
            RowBox[{"pos", "=", 
             RowBox[{"Length", "[", "B", "]"}]}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"While", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"pos", "\[NotEqual]", "j"}], " ", "&&", 
            RowBox[{"pos", ">", "1"}]}], ",", 
           RowBox[{
            RowBox[{"newchain", "=", 
             RowBox[{"InterchangeStabChain", "[", 
              RowBox[{"newchain", ",", 
               RowBox[{"pos", "-", "1"}], ",", "len"}], "]"}]}], ";", 
            RowBox[{"B", "=", 
             RowBox[{"First", "@", 
              RowBox[{"First", "@", "newchain"}]}]}], ";", 
            RowBox[{"pos", "=", 
             RowBox[{"pos", "-", "1"}]}]}]}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "newchain"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.601451008042532*^9, 3.601451018662546*^9}, 
   3.601451064872611*^9, {3.60145117840277*^9, 3.6014511816527743`*^9}, {
   3.601451211712816*^9, 3.6014512160528226`*^9}, {3.601451303632945*^9, 
   3.6014513460330048`*^9}, {3.60145140716309*^9, 3.6014514193231063`*^9}, {
   3.60145217848517*^9, 3.6014521856251793`*^9}, {3.601452229435241*^9, 
   3.601452313185358*^9}, {3.60145234976541*^9, 3.601452399705479*^9}, {
   3.601452432035525*^9, 3.601452545215684*^9}, 3.60371942011017*^9, 
   3.6037207515730352`*^9, 3.6037213882949266`*^9},
 CellLabel->
  "In[179]:=",ExpressionUUID->"780e37ca-cd5d-4ba8-b2b1-a6a495bccd6e"],

Cell["\<\
Instead of using the slow function DeleteRedundantGenerators, we use a \
quicker version, which only removes the redundant generators that are easy to \
find.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.5903128305379252`*^9, 
  3.590312938755316*^9}},ExpressionUUID->"751b5bbe-151c-4df5-820c-\
d0b67768f8cb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DeleteSomeRedundantGenerators", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{"base_", ",", "GS_GenSet"}], "]"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Si", ",", "Sip1", ",", "i", ",", 
       RowBox[{"T", "=", 
        RowBox[{"GenSet", "[", "]"}]}], ",", "orbit", ",", "gens", ",", 
       "check", ",", "toadd"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sip1", "=", 
       RowBox[{"GenSet", "[", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"check", "[", 
        RowBox[{"i_", ",", "gen_", ",", "t_"}], "]"}], ":=", 
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"Orbit", "[", 
          RowBox[{
           RowBox[{"base", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "t"}], "]"}], ",", 
         RowBox[{"OnPoints", "[", 
          RowBox[{
           RowBox[{"base", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "gen"}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"toadd", "[", 
        RowBox[{"i_", ",", "gs_", ",", "T_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"TT", "=", "T"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"check", "[", 
               RowBox[{"i", ",", "#", ",", "TT"}], "]"}], ",", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"TT", ",", "#"}], "]"}]}], "]"}], "&"}], "/@", "gs"}], 
          ";", 
          RowBox[{"Complement", "[", 
           RowBox[{"TT", ",", "T"}], "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", 
         RowBox[{"Length", "[", "base", "]"}]}], ",", 
        RowBox[{"i", "\[GreaterEqual]", "1"}], ",", 
        RowBox[{"i", "--"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Si", "=", 
          RowBox[{"Stabilizer", "[", 
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{"base", ",", 
              RowBox[{"i", "-", "1"}]}], "]"}], ",", "GS"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"gens", "=", 
          RowBox[{"Complement", "[", 
           RowBox[{"Si", ",", "Sip1"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"T", "=", 
          RowBox[{"Join", "[", 
           RowBox[{"T", ",", 
            RowBox[{"toadd", "[", 
             RowBox[{"i", ",", "gens", ",", "T"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Sip1", "=", "Si"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base", ",", "T"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.566218036424438*^9, 3.566218057110074*^9}},
 CellLabel->
  "In[180]:=",ExpressionUUID->"6581f716-f544-40fd-8455-e78b045c351e"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3. New code for SetStabilizer", "Subsubsection",
 CellChangeTimes->{
  3.56621814007202*^9},ExpressionUUID->"97d9c7db-700a-4878-8c1f-e06a41777089"],

Cell["\<\
This is not used at the moment, but it might be needed for larger examples \
later.\
\>", "Text",
 CellChangeTimes->{{3.5173929542825036`*^9, 
  3.5173930249818277`*^9}},ExpressionUUID->"61230125-fde5-4547-a010-\
405a484be5d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetStabilizerProperty", "[", 
    RowBox[{"points_List", ",", "perm_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Complement", "[", 
     RowBox[{
      RowBox[{"OnPoints", "[", 
       RowBox[{"points", ",", "perm"}], "]"}], ",", "points"}], "]"}], "===", 
    
    RowBox[{"{", "}"}]}]}], ";"}]], "Input",
 CellLabel->
  "In[181]:=",ExpressionUUID->"28b2fc6a-3936-4bc9-81e8-54becf79b9bc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "Search2", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"xPermVerbose", "\[Rule]", "False"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5091898273272*^9, 3.5091898367028*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"c10ceb39-7371-4019-95c6-3d5e9586761a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SearchSetStabilizer", "[", 
    RowBox[{
    "chain_List", ",", "s_Integer", ",", " ", "l_Integer", ",", "stabset_", 
     ",", "SGSK_", ",", "options___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"base", "=", 
        RowBox[{"chain", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"newSGSK", "=", "SGSK"}], ",", 
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"Length", "[", "chain", "]"}], "-", "1"}]}], ",", "Deltas", 
       ",", "gammas", ",", "Korbit", ",", "verb"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"verb", "=", 
       RowBox[{
        RowBox[{"xPermVerbose", "/.", 
         RowBox[{"CheckOptions", "[", "options", "]"}]}], "/.", 
        RowBox[{"Options", "[", "Search", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"s", "\[Equal]", "l"}], ",", "\[IndentingNewLine]", 
        RowBox[{"newSGSK", "=", 
         RowBox[{"chain", "[", 
          RowBox[{"[", "l", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"newSGSK", "=", 
          RowBox[{"SearchSetStabilizer", "[", 
           RowBox[{"chain", ",", 
            RowBox[{"s", "+", "1"}], ",", "l", ",", "stabset", ",", "SGSK", 
            ",", "options"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Deltas", "=", 
          RowBox[{"Orbit", "[", 
           RowBox[{
            RowBox[{"base", "[", 
             RowBox[{"[", "s", "]"}], "]"}], ",", 
            RowBox[{"chain", "[", 
             RowBox[{"[", 
              RowBox[{"s", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Branching over points \>\"", ",", "Deltas"}], 
            "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Avoid", " ", "rechecking", " ", 
           RowBox[{"permutations", ".", " ", "Not"}], " ", "in", " ", 
           RowBox[{"Butler", "'"}], "s", " ", "algorithm"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"s", "=!=", "k"}], ",", 
             RowBox[{"Deltas", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"Deltas", ",", "1"}], "]"}]}]}], "]"}], ";"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"gammas", "=", 
             RowBox[{"Deltas", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"Korbit", "=", 
             RowBox[{"Orbit", "[", 
              RowBox[{"gammas", ",", 
               RowBox[{"newSGSK", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"gammas", "===", 
               RowBox[{"MinB", "[", 
                RowBox[{"Korbit", ",", "base"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"newSGSK", "=", 
                RowBox[{"GenerateSetStabilizer", "[", 
                 RowBox[{"chain", ",", "s", ",", "l", ",", " ", 
                  RowBox[{"s", "+", "1"}], ",", 
                  RowBox[{"Append", "[", 
                   RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"base", ",", 
                    RowBox[{"s", "-", "1"}]}], "]"}], ",", "gammas"}], "]"}], 
                  ",", " ", "stabset", ",", "newSGSK", ",", "verb"}], "]"}]}],
                ";", "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Head", "[", "newSGSK", "]"}], "===", "Times"}], 
                 ",", 
                 RowBox[{"newSGSK", "=", 
                  RowBox[{"-", "newSGSK"}]}]}], "]"}]}]}], "]"}]}], 
           "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "Deltas", "]"}]}], "}"}]}], "]"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "newSGSK"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.509189157588001*^9, 3.5091891767448*^9}, 
   3.5091898040832*^9, {3.509350257039*^9, 3.5093502674442*^9}, {
   3.5093503547262*^9, 3.5093503652562*^9}, {3.5093504208389997`*^9, 
   3.5093504621166*^9}, {3.5093508467814007`*^9, 3.5093508753138*^9}, {
   3.5093512600254*^9, 3.5093512606026*^9}, {3.509351696685*^9, 
   3.5093517201318*^9}, {3.5093518572402*^9, 3.509351949951*^9}, 
   3.5093572848087997`*^9, {3.5093584667584*^9, 3.5093584746988*^9}, {
   3.5093585791408*^9, 3.5093586028386*^9}, {3.509358766311*^9, 
   3.5093587676058*^9}, {3.5093664773134003`*^9, 3.509366482633*^9}, {
   3.5093671966918*^9, 3.509367217159*^9}, 3.5093680166902*^9, {
   3.5093735808046*^9, 3.5093735836126003`*^9}, {3.587652060383582*^9, 
   3.587652091724037*^9}, 3.587652305167612*^9, {3.58765244048625*^9, 
   3.5876524472098613`*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"97fb312c-40b5-4cbd-95e0-ac856cf62f8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenerateSetStabilizer", "[", 
    RowBox[{
    "chain_List", ",", "s_", ",", "l_", ",", "i_", ",", "list_", ",", 
     "stabset_", ",", "SGSK_", ",", "verb_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"base", "=", 
        RowBox[{"chain", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"Length", "[", "chain", "]"}], "-", "1"}]}], ",", "g", ",", 
       RowBox[{"newSGSK", "=", "SGSK"}], ",", "Deltag", ",", "gammai", ",", 
       "otherSGSK"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<GenerateSetStabilizer[\>\"", ",", "chain", ",", "\"\<,\>\"", 
           ",", "s", ",", "\"\<,\>\"", ",", "l", ",", "\"\<,\>\"", ",", "i", 
           ",", "\"\<,\>\"", ",", "list", ",", "\"\<,\>\"", ",", "stabset", 
           ",", "\"\<,\>\"", ",", "SGSK", ",", "\"\<,\>\"", ",", "verb", ",", 
           "\"\<]\>\""}], "]"}]}], "]"}], ";"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g", "=", 
       RowBox[{"FromBaseImage", "[", 
        RowBox[{"list", ",", 
         RowBox[{"ReplacePart", "[", 
          RowBox[{
           RowBox[{"chain", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"Take", "[", 
            RowBox[{"base", ",", 
             RowBox[{"Length", "[", "list", "]"}]}], "]"}], ",", "1"}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i", "\[Equal]", "l"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<Generate at level \>\"", ",", "s", ",", "\"\< with i=\>\"", 
             ",", "i", ",", "\"\<. We have list \>\"", ",", "list", ",", 
             "\"\< and permutation \>\"", ",", "g"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Not", "@", 
             RowBox[{"PermEqual", "[", 
              RowBox[{"g", ",", "ID"}], "]"}]}], "&&", 
            RowBox[{"SetStabilizerProperty", "[", 
             RowBox[{"stabset", ",", "g"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "}"}], ",", 
             RowBox[{
              RowBox[{"newSGSK", "=", 
               RowBox[{"-", 
                RowBox[{"StrongGenSet", "[", 
                 RowBox[{"base", ",", 
                  RowBox[{"Append", "[", 
                   RowBox[{
                    RowBox[{"Last", "[", "SGSK", "]"}], ",", "g"}], "]"}]}], 
                 "]"}]}]}], ";", " ", 
              RowBox[{"(*", " ", 
               RowBox[{"Is", " ", "this", " ", "a", " ", "good", " ", 
                RowBox[{"base", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{"verb", ",", 
                RowBox[{"Print", "[", 
                 RowBox[{
                 "\"\<  Added permutation \>\"", ",", "g", ",", 
                  "\"\<, newSGSK: \>\"", ",", 
                  RowBox[{"-", "newSGSK"}], ",", " ", "\"\<, SGSK: \>\"", ",",
                   "SGSK"}], "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Deltag", "=", 
          RowBox[{"Intersection", "[", 
           RowBox[{
            RowBox[{"OnPoints", "[", 
             RowBox[{
              RowBox[{"Orbit", "[", 
               RowBox[{
                RowBox[{"base", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{"chain", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}], ",", "g"}], 
             "]"}], ",", "stabset"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Generating over points \>\"", ",", "Deltag"}], 
            "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"gammai", "=", 
             RowBox[{"Deltag", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"newSGSK", "=", 
             RowBox[{"GenerateSetStabilizer", "[", 
              RowBox[{"chain", ",", "s", ",", "l", ",", 
               RowBox[{"i", "+", "1"}], ",", 
               RowBox[{"Append", "[", 
                RowBox[{"list", ",", "gammai"}], "]"}], ",", "stabset", ",", 
               "newSGSK", ",", "verb"}], "]"}]}], ";", "\[IndentingNewLine]", 
            
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Head", "[", "newSGSK", "]"}], "===", "Times"}], ",", 
              RowBox[{"Break", "[", "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "Deltag", "]"}]}], "}"}]}], "]"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "newSGSK"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.509189806782*^9, 3.509189810994*^9}, {
   3.5093508839406*^9, 3.5093509104294*^9}, {3.5093509447650003`*^9, 
   3.509350944999*^9}, {3.509351726075401*^9, 3.5093517413946*^9}, {
   3.5093519653014*^9, 3.5093519761278*^9}, {3.5093580843244*^9, 
   3.5093580952288*^9}, {3.509358450394*^9, 3.5093584542316*^9}, {
   3.5093586111534*^9, 3.5093586183606*^9}, {3.509366586919*^9, 
   3.509366592379*^9}, {3.5093666229706*^9, 3.5093666341246*^9}, {
   3.5093671688614006`*^9, 3.5093671846486*^9}, {3.5093673199318*^9, 
   3.5093673213826*^9}, 3.5093678843866*^9, 3.5093680038046*^9, {
   3.5093685123958*^9, 3.5093686217362003`*^9}, {3.5093686914214*^9, 
   3.5093687466922*^9}, 3.5093695748026*^9, 3.5093702312818003`*^9, {
   3.5093720648746*^9, 3.509372069851*^9}, {3.5093722095022*^9, 
   3.509372209939*^9}, {3.5093722453978*^9, 3.5093722518874006`*^9}, {
   3.5093723113078003`*^9, 3.5093723215102*^9}, {3.5093724710518*^9, 
   3.5093724745774*^9}, {3.5093726174734*^9, 3.509372671387*^9}, {
   3.5093729088501997`*^9, 3.5093729168374*^9}, {3.5093731560634003`*^9, 
   3.5093731855162*^9}, {3.509373308257*^9, 3.5093733506422*^9}, {
   3.584177573300894*^9, 3.5841776427054167`*^9}},
 CellLabel->
  "In[184]:=",ExpressionUUID->"8f5eeb22-23df-4d9b-996c-b6855684efa6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetStabilizer2", "[", 
    RowBox[{"points_", ",", 
     RowBox[{"sgs", ":", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base_", ",", "GS_"}], "]"}]}], ",", "options___"}], "]"}], ":=",
    "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"newbasesgschain", "=", 
       RowBox[{"StabilizerChain2", "@", 
        RowBox[{"BaseChange", "[", 
         RowBox[{"sgs", ",", "points"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SearchSetStabilizer", "[", 
      RowBox[{"newbasesgschain", ",", "1", ",", " ", 
       RowBox[{
        RowBox[{"Length", "[", "points", "]"}], "+", "1"}], ",", " ", 
       "points", ",", 
       RowBox[{"newbasesgschain", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"Length", "[", "points", "]"}], "+", "1"}], "]"}], "]"}], 
       ",", "options"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.5091900470376*^9, {3.509351178999*^9, 3.5093511900594*^9}, {
   3.509351380395*^9, 3.509351380473*^9}, {3.509358115696*^9, 
   3.5093581204384*^9}, {3.5093581704676*^9, 3.5093581743052*^9}, {
   3.5093586268626003`*^9, 3.5093587277478*^9}, {3.5093587869342003`*^9, 
   3.5093588051082*^9}, {3.5093589053226*^9, 3.509358918707401*^9}, {
   3.5093596650582*^9, 3.5093596735758*^9}, {3.509359818765001*^9, 
   3.5093598993389997`*^9}, {3.5093599659042*^9, 3.5093599660914*^9}, {
   3.5093600249346*^9, 3.5093600312838*^9}, 3.5093680262841997`*^9, {
   3.60155702797403*^9, 3.6015570368640428`*^9}, {3.6015575812048044`*^9, 
   3.6015575911748185`*^9}, {3.601557812605129*^9, 3.601557820325139*^9}, 
   3.601560710583186*^9},
 CellLabel->
  "In[185]:=",ExpressionUUID->"9aa4b35e-601c-4fa9-b649-a1fad4ef975b"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4. Smallest image of a set", "Subsubsection",
 CellChangeTimes->{{3.527143549628234*^9, 3.5271435600490527`*^9}, 
   3.5662181427552247`*^9},ExpressionUUID->"aade1c93-687a-4f67-840e-\
6b79cd132729"],

Cell["\<\
This is an algorithm for computing the smallest image of a set Delta when a \
group G is acting on it. 
The algorithm can be found in the paper: Linton, S., \
\[OpenCurlyDoubleQuote]Finding the smallest image of a set\
\[CloseCurlyDoubleQuote], ISSAC \[OpenCurlyQuote]04, 229-234 (2004) \
http://dx.doi.org/10.1145/1005285.1005319\
\>", "Text",
 CellChangeTimes->{{3.5087643535128*^9, 3.5087644156164*^9}, {
   3.508764568512*^9, 3.5087645967636003`*^9}, {3.518014499212058*^9, 
   3.518014565572175*^9}, {3.518014604915444*^9, 3.518014627535484*^9}, 
   3.518014796592981*^9},ExpressionUUID->"af74133b-9f1a-459c-8385-\
3f49558585aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindSmallestImage", "[", 
   RowBox[{"Delta_List", ",", "G_StrongGenSet", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"MinOrbit", ",", "FindFirstAndAppend", ",", "MapPoints", ",", 
      RowBox[{"GpChain", "=", 
       RowBox[{"StabilizerChain2", "@", "G"}]}], ",", 
      RowBox[{"Cands", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "}"}], ",", "Delta"}], "}"}], "}"}]}], ",", "Pass", 
      ",", 
      RowBox[{"Mp", "=", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"k", "=", 
       RowBox[{"Length", "@", "Delta"}]}], ",", "m", ",", "i", ",", "MRs", 
      ",", "FirstSchreierOrbit", ",", "xs", ",", "gs", ",", "DRjs", ",", 
      "DRgs"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"MinOrbit", "[", "expr_", "]"}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"Min", "@", 
         RowBox[{"Orbit", "[", 
          RowBox[{"#", ",", 
           RowBox[{"First", "@", "GpChain"}]}], "]"}]}], "&"}], "/@", 
       "expr"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"FindFirstAndAppend", "[", 
       RowBox[{"elements_", ",", "cand_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"Append", "[", 
         RowBox[{
          RowBox[{"cand", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"First", "@", 
           RowBox[{"First", "@", 
            RowBox[{"Position", "[", 
             RowBox[{
              RowBox[{"cand", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "#", ",", "1", ",", "1"}],
              "]"}]}]}]}], "]"}], "&"}], "/@", "elements"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MapPoints", "[", 
       RowBox[{"DR_", ",", "gs_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"OnPoints", "[", 
         RowBox[{"DR", ",", "#"}], "]"}], "&"}], "/@", "gs"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", "k"}], ",", 
       RowBox[{"i", "+=", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"m", "=", 
         RowBox[{"n", "+", "1"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"MRs", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"MinOrbit", "[", "#", "]"}], "]"}], "&"}], "/@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"Complement", "[", 
                RowBox[{
                 RowBox[{"Range", "[", 
                  RowBox[{"1", ",", "k"}], "]"}], ",", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}], "&"}], "/@",
             "Cands"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "MRs"}], ">", "0"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"First", "@", "MRs"}], "<", "m"}], ",", 
             "\[IndentingNewLine]", "  ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Pass", "=", 
                RowBox[{"{", 
                 RowBox[{"First", "@", "Cands"}], "}"}]}], ",", 
               RowBox[{"m", "=", 
                RowBox[{"First", "@", "MRs"}]}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"First", "@", "MRs"}], "==", "m"}], ",", 
               RowBox[{"Pass", "=", 
                RowBox[{"Append", "[", 
                 RowBox[{"Pass", ",", 
                  RowBox[{"First", "@", "Cands"}]}], "]"}]}]}], "]"}]}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"MRs", "=", 
            RowBox[{"Rest", "@", "MRs"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Cands", "=", 
            RowBox[{"Rest", "@", "Cands"}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"GpChain", "=", 
         RowBox[{"BaseChangeStabChain", "[", 
          RowBox[{"GpChain", ",", 
           RowBox[{"{", "m", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"FirstSchreierOrbit", "=", 
         RowBox[{"SchreierOrbit", "[", 
          RowBox[{"m", ",", 
           RowBox[{"First", "@", "GpChain"}], ",", "n"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"xs", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Intersection", "[", 
            RowBox[{
             RowBox[{"First", "@", "FirstSchreierOrbit"}], ",", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], "/@", 
          "Pass"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"gs", "=", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"InversePerm", "@", 
              RowBox[{"TraceSchreier", "[", 
               RowBox[{"#", ",", "FirstSchreierOrbit"}], "]"}]}], "&"}], "/@",
             "#"}], "&"}], "/@", "xs"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"DRjs", "=", 
         RowBox[{"MapThread", "[", 
          RowBox[{"FindFirstAndAppend", ",", 
           RowBox[{"{", 
            RowBox[{"xs", ",", "Pass"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"DRgs", "=", 
         RowBox[{"MapThread", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MapPoints", "[", 
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "#2"}], "]"}], "&"}], ",", 
           RowBox[{"{", 
            RowBox[{"Pass", ",", "gs"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Cands", "=", 
         RowBox[{"MapThread", "[", 
          RowBox[{"List", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Flatten", "[", 
              RowBox[{"DRjs", ",", "1"}], "]"}], ",", 
             RowBox[{"Flatten", "[", 
              RowBox[{"DRgs", ",", "1"}], "]"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"GpChain", "=", 
         RowBox[{"Rest", "@", "GpChain"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Mp", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"Mp", ",", "m"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", "Mp"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5087622915984*^9, 3.5087626083876*^9}, {
   3.5087626500864*^9, 3.5087626778544*^9}, {3.5087627101776*^9, 
   3.5087627377428*^9}, {3.5087627687244*^9, 3.5087628092376003`*^9}, {
   3.5087628562872*^9, 3.5087629521024*^9}, {3.5087632128252*^9, 
   3.5087632951776*^9}, {3.5087634852012*^9, 3.50876352846*^9}, {
   3.5087639224848003`*^9, 3.5087639860704*^9}, {3.508764018534*^9, 
   3.50876401986*^9}, {3.584177321438452*^9, 3.58417736602333*^9}, {
   3.601557068724087*^9, 3.601557075524097*^9}, {3.601557127574169*^9, 
   3.601557218804298*^9}, 3.601560716543195*^9},
 CellLabel->
  "In[186]:=",ExpressionUUID->"3295cbab-a9c8-43eb-9722-2cfa4679901b"],

Cell["\<\
The same thing but keep track of the permutation that maps to the smallest \
image with slightly streamlined programming. Can we use a better base change \
algorithm here?\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.5088386226038*^9, 3.5088386723678*^9}, {
  3.5688949070286436`*^9, 3.568894934765493*^9}, {3.590313061324731*^9, 
  3.590313072977951*^9}},ExpressionUUID->"24932223-0c11-48d0-811f-\
5805d6ec5b44"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindSmallestImageAndMapping", "[", 
   RowBox[{"Delta_List", ",", " ", "G_StrongGenSet", ",", " ", "n_"}], "]"}], 
  " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "MinOrbit", ",", " ", "FindFirstAndAppend", ",", " ", "MapPoints", ",", 
      " ", "PermProducts", ",", " ", 
      RowBox[{"Gp", " ", "=", " ", "G"}], ",", " ", 
      RowBox[{"Cands", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "}"}], ",", " ", "Delta", ",", " ", "ID"}], "}"}], 
        "}"}]}], ",", " ", "Pass", ",", " ", 
      RowBox[{"Mp", " ", "=", " ", 
       RowBox[{"{", "}"}]}], ",", " ", 
      RowBox[{"k", " ", "=", " ", 
       RowBox[{"Length", "@", "Delta"}]}], ",", " ", "m", ",", " ", "i", ",", 
      " ", "MRs", ",", " ", "FirstSchreierOrbit", ",", " ", "gs", ",", " ", 
      "CandFromPass"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"MinOrbit", "[", "expr_", "]"}], " ", ":=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Min", "@", 
         RowBox[{"Orbit", "[", 
          RowBox[{"#", ",", " ", "Gp"}], "]"}]}], " ", "&"}], " ", "/@", " ", 
       "expr"}]}], ";", 
     RowBox[{
      RowBox[{"CandFromPass", "[", 
       RowBox[{"{", 
        RowBox[{"JR_", ",", " ", "DR_", ",", " ", "gperm_"}], "}"}], "]"}], 
      " ", ":=", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"xs", " ", "=", " ", 
          RowBox[{"Intersection", "[", 
           RowBox[{
            RowBox[{"First", "@", "FirstSchreierOrbit"}], ",", " ", "DR"}], 
           "]"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"gs", " ", "=", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"InversePerm", "@", 
             RowBox[{"TraceSchreier", "[", 
              RowBox[{"#", ",", " ", "FirstSchreierOrbit"}], "]"}]}], " ", 
            "&"}], " ", "/@", " ", "xs"}]}], ";", 
         RowBox[{"Sequence", " ", "@@", " ", 
          RowBox[{"MapThread", "[", 
           RowBox[{"List", ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Append", "[", 
                 RowBox[{"JR", ",", " ", 
                  RowBox[{"First", "@", 
                   RowBox[{"First", "@", 
                    RowBox[{"Position", "[", 
                    RowBox[{
                    "DR", ",", " ", "#", ",", " ", "1", ",", " ", "1"}], 
                    "]"}]}]}]}], "]"}], " ", "&"}], " ", "/@", " ", "xs"}], 
              ",", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"OnPoints", "[", 
                 RowBox[{"DR", ",", " ", "#"}], "]"}], " ", "&"}], " ", "/@", 
               " ", "gs"}], ",", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"PermProduct", "[", 
                 RowBox[{"gperm", ",", " ", "#"}], "]"}], " ", "&"}], " ", "/@",
                " ", "gs"}]}], "}"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", " ", "=", " ", "1"}], ",", " ", 
       RowBox[{"i", " ", "<=", " ", "k"}], ",", " ", 
       RowBox[{"i", " ", "+=", " ", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"m", " ", "=", " ", 
         RowBox[{"n", " ", "+", " ", "1"}]}], ";", 
        RowBox[{"MRs", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"MinOrbit", "[", "#", "]"}], "]"}], " ", "&"}], " ", "/@",
           " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
               RowBox[{"Complement", "[", 
                RowBox[{
                 RowBox[{"Range", "[", 
                  RowBox[{"1", ",", " ", "k"}], "]"}], ",", " ", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}], " ", 
             "&"}], " ", "/@", " ", "Cands"}], ")"}]}]}], ";", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "MRs"}], " ", ">", " ", "0"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"First", "@", "MRs"}], " ", "<", " ", "m"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Pass", " ", "=", " ", 
               RowBox[{"{", 
                RowBox[{"First", "@", "Cands"}], "}"}]}], ";", " ", 
              RowBox[{"m", " ", "=", " ", 
               RowBox[{"First", "@", "MRs"}]}]}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"First", "@", "MRs"}], " ", "==", " ", "m"}], ",", 
               " ", 
               RowBox[{"Pass", " ", "=", " ", 
                RowBox[{"Append", "[", 
                 RowBox[{"Pass", ",", " ", 
                  RowBox[{"First", "@", "Cands"}]}], "]"}]}]}], "]"}]}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"MRs", " ", "=", " ", 
            RowBox[{"Rest", "@", "MRs"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Cands", " ", "=", " ", 
            RowBox[{"Rest", "@", "Cands"}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Gp", " ", "=", " ", 
         RowBox[{"BaseChange2", "[", 
          RowBox[{"Gp", ",", " ", 
           RowBox[{"{", "m", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"FirstSchreierOrbit", " ", "=", " ", 
         RowBox[{"SchreierOrbit", "[", 
          RowBox[{"m", ",", " ", "Gp", ",", " ", "n"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Cands", " ", "=", " ", 
         RowBox[{"CandFromPass", " ", "/@", " ", "Pass"}]}], ";", 
        RowBox[{"Gp", " ", "=", " ", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"Rest", "@", 
            RowBox[{"First", "@", "Gp"}]}], ",", " ", 
           RowBox[{"Stabilizer", "[", 
            RowBox[{
             RowBox[{"{", "m", "}"}], ",", " ", 
             RowBox[{"Gp", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Mp", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"Mp", ",", " ", "m"}], "]"}]}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Mp", ",", " ", 
       RowBox[{"Cands", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", " ", "3"}], "]"}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5087622915984*^9, 3.5087626083876*^9}, {
   3.5087626500864*^9, 3.5087626778544*^9}, {3.5087627101776*^9, 
   3.5087627377428*^9}, {3.5087627687244*^9, 3.5087628092376003`*^9}, {
   3.5087628562872*^9, 3.5087629521024*^9}, {3.5087632128252*^9, 
   3.5087632951776*^9}, {3.5087634852012*^9, 3.50876352846*^9}, {
   3.5087639224848003`*^9, 3.5087639860704*^9}, {3.508764018534*^9, 
   3.50876401986*^9}, {3.5087677890072002`*^9, 3.508767791846401*^9}, {
   3.5087678451360006`*^9, 3.5087679100944*^9}, {3.5087683385484*^9, 
   3.5087683629780006`*^9}, {3.5087684335368*^9, 3.508768446126*^9}, {
   3.5087686149960003`*^9, 3.5087686300656*^9}, {3.5087696847972*^9, 
   3.5087697224712*^9}, {3.5087699094996*^9, 3.5087700261252003`*^9}, {
   3.5087706384564*^9, 3.5087706386280003`*^9}, {3.5087706757248*^9, 
   3.5087707354416*^9}, {3.5087708168736*^9, 3.5087708405232*^9}, {
   3.5087711158476*^9, 3.5087711464392*^9}, {3.5087711871396*^9, 
   3.5087712123336*^9}, {3.50877219699*^9, 3.5087722331976*^9}, {
   3.5087722721664*^9, 3.5087723355959997`*^9}, {3.5087726227296*^9, 
   3.5087726278152*^9}, {3.508838554697*^9, 3.5088386165042*^9}, {
   3.517812137729017*^9, 3.5178121951323*^9}, {3.517812280901206*^9, 
   3.5178122984492097`*^9}, {3.517812545408335*^9, 3.5178125885228004`*^9}, {
   3.5178128462505417`*^9, 3.517812864852606*^9}, {3.517816576094877*^9, 
   3.517816586044446*^9}, 3.5678625875460815`*^9, 3.568894866062972*^9, {
   3.568895004981216*^9, 3.5688950644641204`*^9}, {3.568895410706728*^9, 
   3.5688954426243844`*^9}, {3.601557248074338*^9, 3.601557287584394*^9}, {
   3.6015573201244392`*^9, 3.601557341454469*^9}, {3.601559552939565*^9, 
   3.6015596298896728`*^9}, 3.601559727659809*^9, 3.601561009793605*^9, {
   3.601561493885282*^9, 3.601561493885282*^9}, 3.601561851596784*^9, 
   3.6015621023871346`*^9, {3.603374762237308*^9, 3.603374904197507*^9}, {
   3.603719594020414*^9, 3.603719595960416*^9}, 3.6196151383774786`*^9},
 CellLabel->
  "In[187]:=",ExpressionUUID->"00ca5bce-ec51-4dfc-b835-dd655f1c26d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindSmallestImageAndMapping2", "[", 
   RowBox[{"Delta_List", ",", " ", "G_StrongGenSet", ",", " ", "n_"}], "]"}], 
  " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "MinOrbit", ",", " ", "FindFirstAndAppend", ",", " ", "MapPoints", ",", 
      " ", "PermProducts", ",", " ", 
      RowBox[{"GpChain", " ", "=", " ", 
       RowBox[{"StabilizerChain2", "@", "G"}]}], ",", " ", 
      RowBox[{"Cands", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "}"}], ",", " ", "Delta", ",", " ", "ID"}], "}"}], 
        "}"}]}], ",", " ", "Pass", ",", " ", 
      RowBox[{"Mp", " ", "=", " ", 
       RowBox[{"{", "}"}]}], ",", " ", 
      RowBox[{"k", " ", "=", " ", 
       RowBox[{"Length", "@", "Delta"}]}], ",", " ", "m", ",", " ", "i", ",", 
      " ", "MRs", ",", " ", "FirstSchreierOrbit", ",", " ", "gs", ",", " ", 
      "CandFromPass"}], "}"}], ",", "\n", "      ", 
    RowBox[{
     RowBox[{
      RowBox[{"MinOrbit", "[", "expr_", "]"}], " ", ":=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Min", "@", 
         RowBox[{"Orbit", "[", 
          RowBox[{"#", ",", " ", 
           RowBox[{"First", "@", "GpChain"}]}], "]"}]}], " ", "&"}], " ", "/@",
        " ", "expr"}]}], ";", "\n", "      ", 
     RowBox[{
      RowBox[{"CandFromPass", "[", 
       RowBox[{"{", 
        RowBox[{"JR_", ",", " ", "DR_", ",", " ", "gperm_"}], "}"}], "]"}], 
      " ", ":=", " ", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"xs", " ", "=", " ", 
          RowBox[{"Intersection", "[", 
           RowBox[{
            RowBox[{"First", "@", "FirstSchreierOrbit"}], ",", " ", "DR"}], 
           "]"}]}], "}"}], ",", "\n", "            ", 
        RowBox[{
         RowBox[{"gs", " ", "=", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"InversePerm", "@", 
             RowBox[{"TraceSchreier", "[", 
              RowBox[{"#", ",", " ", "FirstSchreierOrbit"}], "]"}]}], " ", 
            "&"}], " ", "/@", " ", "xs"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Sequence", " ", "@@", " ", 
          RowBox[{"MapThread", "[", 
           RowBox[{"List", ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Append", "[", 
                 RowBox[{"JR", ",", " ", 
                  RowBox[{"First", "@", 
                   RowBox[{"First", "@", 
                    RowBox[{"Position", "[", 
                    RowBox[{
                    "DR", ",", " ", "#", ",", " ", "1", ",", " ", "1"}], 
                    "]"}]}]}]}], "]"}], " ", "&"}], " ", "/@", " ", "xs"}], 
              ",", 
              RowBox[{
               RowBox[{
                RowBox[{"OnPoints", "[", 
                 RowBox[{"DR", ",", " ", "#"}], "]"}], " ", "&"}], " ", "/@", 
               " ", "gs"}], ",", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"PermProduct", "[", 
                 RowBox[{"gperm", ",", " ", "#"}], "]"}], " ", "&"}], " ", "/@",
                " ", "gs"}]}], "}"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", " ", "=", " ", "1"}], ",", " ", 
       RowBox[{"i", " ", "<=", " ", "k"}], ",", " ", 
       RowBox[{"i", " ", "+=", " ", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"m", " ", "=", " ", 
         RowBox[{"n", " ", "+", " ", "1"}]}], ";", 
        RowBox[{"MRs", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"MinOrbit", "[", "#", "]"}], "]"}], " ", "&"}], " ", "/@",
           " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
               RowBox[{"Complement", "[", 
                RowBox[{
                 RowBox[{"Range", "[", 
                  RowBox[{"1", ",", " ", "k"}], "]"}], ",", " ", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}], " ", 
             "&"}], " ", "/@", " ", "Cands"}], ")"}]}]}], ";", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "MRs"}], " ", ">", " ", "0"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"First", "@", "MRs"}], " ", "<", " ", "m"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Pass", " ", "=", " ", 
               RowBox[{"{", 
                RowBox[{"First", "@", "Cands"}], "}"}]}], ";", " ", 
              "\[IndentingNewLine]", 
              RowBox[{"m", " ", "=", " ", 
               RowBox[{"First", "@", "MRs"}]}]}], ",", "\[IndentingNewLine]", 
             
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"First", "@", "MRs"}], " ", "==", " ", "m"}], ",", 
               " ", 
               RowBox[{"Pass", " ", "=", " ", 
                RowBox[{"Append", "[", 
                 RowBox[{"Pass", ",", " ", 
                  RowBox[{"First", "@", "Cands"}]}], "]"}]}]}], "]"}]}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"MRs", " ", "=", " ", 
            RowBox[{"Rest", "@", "MRs"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Cands", " ", "=", " ", 
            RowBox[{"Rest", "@", "Cands"}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"GpChain", " ", "=", " ", 
         RowBox[{"BaseChangeStabChain", "[", 
          RowBox[{"GpChain", ",", " ", 
           RowBox[{"{", "m", "}"}]}], "]"}]}], ";", "\n", "        ", 
        RowBox[{"FirstSchreierOrbit", " ", "=", " ", 
         RowBox[{"SchreierOrbit", "[", 
          RowBox[{"m", ",", " ", 
           RowBox[{"First", "@", "GpChain"}], ",", " ", "n"}], "]"}]}], ";", 
        "\n", "        ", 
        RowBox[{"Cands", " ", "=", " ", 
         RowBox[{"CandFromPass", " ", "/@", " ", "Pass"}]}], ";", "\n", 
        "        ", 
        RowBox[{"GpChain", " ", "=", " ", 
         RowBox[{"Rest", "@", "GpChain"}]}], ";", "\n", "        ", 
        RowBox[{"Mp", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"Mp", ",", " ", "m"}], "]"}]}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Mp", ",", " ", 
       RowBox[{"Cands", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", " ", "3"}], "]"}], "]"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5087622915984*^9, 3.5087626083876*^9}, {
   3.5087626500864*^9, 3.5087626778544*^9}, {3.5087627101776*^9, 
   3.5087627377428*^9}, {3.5087627687244*^9, 3.5087628092376003`*^9}, {
   3.5087628562872*^9, 3.5087629521024*^9}, {3.5087632128252*^9, 
   3.5087632951776*^9}, {3.5087634852012*^9, 3.50876352846*^9}, {
   3.5087639224848003`*^9, 3.5087639860704*^9}, {3.508764018534*^9, 
   3.50876401986*^9}, {3.5087677890072002`*^9, 3.508767791846401*^9}, {
   3.5087678451360006`*^9, 3.5087679100944*^9}, {3.5087683385484*^9, 
   3.5087683629780006`*^9}, {3.5087684335368*^9, 3.508768446126*^9}, {
   3.5087686149960003`*^9, 3.5087686300656*^9}, {3.5087696847972*^9, 
   3.5087697224712*^9}, {3.5087699094996*^9, 3.5087700261252003`*^9}, {
   3.5087706384564*^9, 3.5087706386280003`*^9}, {3.5087706757248*^9, 
   3.5087707354416*^9}, {3.5087708168736*^9, 3.5087708405232*^9}, {
   3.5087711158476*^9, 3.5087711464392*^9}, {3.5087711871396*^9, 
   3.5087712123336*^9}, {3.50877219699*^9, 3.5087722331976*^9}, {
   3.5087722721664*^9, 3.5087723355959997`*^9}, {3.5087726227296*^9, 
   3.5087726278152*^9}, {3.508838554697*^9, 3.5088386165042*^9}, {
   3.517812137729017*^9, 3.5178121951323*^9}, {3.517812280901206*^9, 
   3.5178122984492097`*^9}, {3.517812545408335*^9, 3.5178125885228004`*^9}, {
   3.5178128462505417`*^9, 3.517812864852606*^9}, {3.517816576094877*^9, 
   3.517816586044446*^9}, 3.5678625875460815`*^9, 3.568894866062972*^9, {
   3.568895004981216*^9, 3.5688950644641204`*^9}, {3.568895410706728*^9, 
   3.5688954426243844`*^9}, {3.601557248074338*^9, 3.601557287584394*^9}, {
   3.6015573201244392`*^9, 3.601557341454469*^9}, {3.6015594980894885`*^9, 
   3.6015595011494927`*^9}, {3.601561018223617*^9, 3.601561266043964*^9}, 
   3.6015615237653246`*^9, 3.601561856796791*^9, 3.601562094007123*^9},
 CellLabel->
  "In[188]:=",ExpressionUUID->"08f14f7b-0689-4e8d-ae5a-e049919372e3"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5. Comparing groups", "Subsubsection",
 CellChangeTimes->{{3.527143549628234*^9, 3.5271435600490527`*^9}, {
   3.527143634461183*^9, 3.5271436530876155`*^9}, 
   3.566218144611628*^9},ExpressionUUID->"8269d223-a8c0-446e-ae26-\
8ee3d944ec78"],

Cell["\<\
This section contains algorithms for comparing groups. In theory we compare \
two groups by computing the lexicographically ordered lists of elements, and \
then compare these lists lexicographically. This is not practical so we use \
algorithms that make an equivalent comparison.
The algorithms can be found in the paper: Hulpke, A., Linton, S., \
\[OpenCurlyDoubleQuote]Total Ordering on Subgroups and Cosets\
\[CloseCurlyDoubleQuote], ISSAC \[OpenCurlyQuote]03, 156-160 (2003) \
http://dx.doi.org/10.1145/860854.860892\
\>", "Text",
 CellChangeTimes->{{3.5087643535128*^9, 3.5087644156164*^9}, {
   3.508764568512*^9, 3.5087645967636003`*^9}, {3.518014499212058*^9, 
   3.518014565572175*^9}, {3.518014604915444*^9, 3.518014627535484*^9}, 
   3.518014796592981*^9, {3.527143661917231*^9, 3.527143958708753*^9}, {
   3.5271439899088073`*^9, 3.5271440205628614`*^9}, {3.5271441130876236`*^9, 
   3.527144131121256*^9}, 
   3.527144218684209*^9},ExpressionUUID->"8d9ab1c8-6140-46bc-84b0-\
4335be287659"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmallestGenSet", "[", "G_StrongGenSet", "]"}], ":=", 
  RowBox[{"SmallestGenSet", "[", 
   RowBox[{"SmallestBaseStabChain", "@", "G"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.527083470395859*^9, 3.527083518365943*^9}, {
  3.527143129106294*^9, 3.5271431458607244`*^9}},
 CellLabel->
  "In[189]:=",ExpressionUUID->"f7f8cabd-1939-487e-a64c-8f2b50cefe9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmallestGenSet", "[", "SmallBaseStabChainG_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"PermLength", "[", 
        RowBox[{"First", "@", "SmallBaseStabChainG"}], "]"}]}], ",", 
      RowBox[{"L", "=", 
       RowBox[{"{", "}"}]}], ",", "i", ",", " ", "Gi", ",", "betai", ",", 
      "orbbetai", ",", "orb", ",", "t", ",", "x"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"i", "=", 
      RowBox[{
       RowBox[{"Length", "[", "SmallBaseStabChainG", "]"}], "-", "1"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", ">", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Gi", "=", 
         RowBox[{"SmallBaseStabChainG", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"betai", "=", 
         RowBox[{"First", "@", 
          RowBox[{"First", "@", "Gi"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"orbbetai", "=", 
         RowBox[{"SchreierOrbit", "[", 
          RowBox[{"betai", ",", 
           RowBox[{"Gi", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"orb", "=", 
         RowBox[{"Complement", "[", 
          RowBox[{
           RowBox[{"First", "@", "orbbetai"}], ",", 
           RowBox[{"Orbit", "[", 
            RowBox[{"betai", ",", 
             RowBox[{"GenSet", "@@", "L"}]}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "orb", "]"}], ">", "0"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"t", "=", 
            RowBox[{"TraceSchreier", "[", 
             RowBox[{
              RowBox[{"Min", "[", "orb", "]"}], ",", "orbbetai"}], "]"}]}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"x", "=", 
            RowBox[{"SmallestCoset", "[", 
             RowBox[{"t", ",", 
              RowBox[{"SmallBaseStabChainG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ";;", 
                 RowBox[{"Length", "[", "SmallBaseStabChainG", "]"}]}], "]"}],
                "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"L", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"L", ",", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"orb", "=", 
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"First", "@", "orbbetai"}], ",", 
              RowBox[{"Orbit", "[", 
               RowBox[{"betai", ",", 
                RowBox[{"GenSet", "@@", "L"}]}], "]"}]}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"i", "=", 
         RowBox[{"i", "-", "1"}]}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "L"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.525350843282637*^9, 3.5253511316631317`*^9}, {
  3.5253511656990786`*^9, 3.525351183706108*^9}, {3.525351253155081*^9, 
  3.5253513770731688`*^9}, {3.5253514433719606`*^9, 3.52535152413558*^9}, {
  3.5253515706642413`*^9, 3.5253515823609114`*^9}, {3.525352109851081*^9, 
  3.525352119153613*^9}, {3.52535279255713*^9, 3.5253528180025845`*^9}, {
  3.52535297456554*^9, 3.5253530177080073`*^9}, {3.527082009982694*^9, 
  3.5270820133210993`*^9}, {3.527082148183337*^9, 3.527082162644562*^9}, {
  3.527083456511834*^9, 3.5270834604742413`*^9}, {3.527083528630761*^9, 
  3.527083561702819*^9}, {3.52714314898073*^9, 3.527143153091138*^9}},
 CellLabel->
  "In[190]:=",ExpressionUUID->"c4c449d2-2b93-4b6a-b557-80cd0ba61cde"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmallestCoset", "[", 
   RowBox[{"p_", ",", "G_StongGenSet"}], "]"}], ":=", 
  RowBox[{"SmallestCoset", "[", 
   RowBox[{"p", ",", 
    RowBox[{"SmallestBaseStabChain", "@", "G"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.527143216801649*^9, 3.5271432457241*^9}},
 CellLabel->
  "In[191]:=",ExpressionUUID->"9ae7c989-8fc7-4b1b-ae4f-f6f0a5b5e938"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmallestCoset", "[", 
   RowBox[{"p_", ",", "StabChainG_List"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"rep", "=", "p"}], ",", " ", "Gi", ",", "betai", ",", "orb", 
      ",", " ", "img", ",", " ", "mu", ",", " ", "omega", ",", "t", ",", 
      "x"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", "<", " ", 
        RowBox[{"Length", "[", "StabChainG", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Gi", "=", 
         RowBox[{"StabChainG", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"betai", "=", 
         RowBox[{"First", "@", 
          RowBox[{"First", "@", "Gi"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<i, betai, rep: \>\"", ",", "i", ",", "\"\<, \>\"", ",", 
            "betai", ",", "\"\<, \>\"", ",", "rep"}], "]"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"orb", "=", 
         RowBox[{"SchreierOrbit", "[", 
          RowBox[{"betai", ",", 
           RowBox[{"Gi", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"img", "=", 
         RowBox[{"OnPoints", "[", 
          RowBox[{
           RowBox[{"First", "@", "orb"}], ",", "rep"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mu", "=", 
         RowBox[{"Min", "[", "img", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"omega", "=", 
         RowBox[{"OnPoints", "[", 
          RowBox[{"mu", ",", 
           RowBox[{"InversePerm", "[", "rep", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"t", "=", 
         RowBox[{"TraceSchreier", "[", 
          RowBox[{"omega", ",", "orb"}], "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<img, mu, omega, omegatest, t: \>\"", ",", "img", ",", " ", 
            "\"\<, \>\"", ",", "mu", ",", "\"\<, \>\"", ",", "omega", ",", 
            "\"\<, \>\"", ",", 
            RowBox[{"OnPoints", "[", 
             RowBox[{"betai", ",", "t"}], "]"}], ",", "\"\<, \>\"", ",", 
            "t"}], " ", "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"rep", "=", 
         RowBox[{"PermProduct", "[", 
          RowBox[{"t", ",", "rep"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"i", "=", 
         RowBox[{"i", "+", "1"}]}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "rep"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.525350843282637*^9, 3.5253511316631317`*^9}, {
   3.5253511656990786`*^9, 3.525351183706108*^9}, {3.525351253155081*^9, 
   3.5253513770731688`*^9}, {3.5253514433719606`*^9, 3.52535152413558*^9}, {
   3.5253515706642413`*^9, 3.5253515823609114`*^9}, {3.525352109851081*^9, 
   3.525352119153613*^9}, {3.52535279255713*^9, 3.5253528180025845`*^9}, {
   3.52535297456554*^9, 3.5253530177080073`*^9}, {3.52707785158859*^9, 
   3.527077984064022*^9}, {3.527078049335537*^9, 3.527078252853495*^9}, {
   3.527078371632103*^9, 3.527078372802105*^9}, {3.527078425124596*^9, 
   3.527078493140716*^9}, 3.527078524434371*^9, {3.527078561562436*^9, 
   3.527078562654439*^9}, {3.5270786020445075`*^9, 3.527078653399798*^9}, {
   3.527079233862218*^9, 3.5270792595398626`*^9}, {3.5270793079311476`*^9, 
   3.527079345527214*^9}, {3.527079490841469*^9, 3.527079501090687*^9}, {
   3.527079568748006*^9, 3.527079647808945*^9}, {3.5270796848590097`*^9, 
   3.5270796883378158`*^9}, {3.5270797536863313`*^9, 3.527079755979534*^9}, {
   3.527079937517053*^9, 3.527079954942284*^9}, {3.527080609317633*^9, 
   3.527080640268088*^9}, {3.5270807045246005`*^9, 3.527080706661804*^9}, 
   3.5270814304094753`*^9, {3.527081951700991*^9, 3.52708196803422*^9}, {
   3.527143200640022*^9, 3.527143201030022*^9}, 3.5678625875460815`*^9},
 CellLabel->
  "In[192]:=",ExpressionUUID->"a2db6ba8-eb45-4207-99f5-53b04d9f319a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LargestElementInGroup", "[", "G_StongGenSet", "]"}], ":=", 
  RowBox[{"LargestElementInGroup", "[", 
   RowBox[{"SmallestBaseStabChain", "@", "G"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.527143283741368*^9, 3.527143293506984*^9}, {
  3.527148631915964*^9, 3.527148633163966*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"df770f40-7765-459a-a098-a716144d901a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LargestElementInGroup", "[", "StabChainG_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"rep", "=", "ID"}], ",", " ", "Gi", ",", "betai", ",", "orb", 
      ",", " ", "img", ",", " ", "mu", ",", " ", "omega", ",", "t", ",", 
      "x"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", "<", " ", 
        RowBox[{"Length", "[", "StabChainG", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Gi", "=", 
         RowBox[{"StabChainG", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"betai", "=", 
         RowBox[{"First", "@", 
          RowBox[{"First", "@", "Gi"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"orb", "=", 
         RowBox[{"SchreierOrbit", "[", 
          RowBox[{"betai", ",", 
           RowBox[{"Gi", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"img", "=", 
         RowBox[{"OnPoints", "[", 
          RowBox[{
           RowBox[{"First", "@", "orb"}], ",", "rep"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mu", "=", 
         RowBox[{"Max", "[", "img", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"omega", "=", 
         RowBox[{"OnPoints", "[", 
          RowBox[{"mu", ",", 
           RowBox[{"InversePerm", "[", "rep", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"t", "=", 
         RowBox[{"TraceSchreier", "[", 
          RowBox[{"omega", ",", "orb"}], "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"rep", "=", 
         RowBox[{"PermProduct", "[", 
          RowBox[{"t", ",", "rep"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"i", "=", 
         RowBox[{"i", "+", "1"}]}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "rep"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.525350843282637*^9, 3.5253511316631317`*^9}, {
   3.5253511656990786`*^9, 3.525351183706108*^9}, {3.525351253155081*^9, 
   3.5253513770731688`*^9}, {3.5253514433719606`*^9, 3.52535152413558*^9}, {
   3.5253515706642413`*^9, 3.5253515823609114`*^9}, {3.525352109851081*^9, 
   3.525352119153613*^9}, {3.52535279255713*^9, 3.5253528180025845`*^9}, {
   3.52535297456554*^9, 3.5253530177080073`*^9}, {3.52707785158859*^9, 
   3.527077984064022*^9}, {3.527078049335537*^9, 3.527078252853495*^9}, {
   3.527078371632103*^9, 3.527078372802105*^9}, {3.527078425124596*^9, 
   3.527078493140716*^9}, 3.527078524434371*^9, {3.527078561562436*^9, 
   3.527078562654439*^9}, {3.5270786020445075`*^9, 3.527078653399798*^9}, {
   3.527078960782738*^9, 3.527078980719573*^9}, {3.527079014727633*^9, 
   3.5270790151488333`*^9}, {3.527080695304984*^9, 3.5270806976605887`*^9}, {
   3.527081358165749*^9, 3.527081418459854*^9}, 3.527081974040231*^9, {
   3.527143035615331*^9, 3.527143051574159*^9}, 3.5271486606522145`*^9, 
   3.5678625875616817`*^9},
 CellLabel->
  "In[194]:=",ExpressionUUID->"1682e9a8-4b98-4548-8106-ea98b42405e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "RemoveSuperfluousBasePointInStabChain", "[", "StabChain_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"firstelem", "=", 
       RowBox[{"First", "@", "StabChain"}]}], ",", "tempchain"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "StabChain", "]"}], "\[Equal]", "1"}], ",", 
      "\[IndentingNewLine]", "StabChain", ",", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"firstelem", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "===", " ", 
         RowBox[{"StabChain", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"RemoveSuperfluousBasePointInStabChain", "[", 
         RowBox[{"Rest", "@", "StabChain"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tempchain", "=", 
          RowBox[{"RemoveSuperfluousBasePointInStabChain", "[", 
           RowBox[{"Rest", "@", "StabChain"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Prepend", "[", 
          RowBox[{"tempchain", ",", 
           RowBox[{"StrongGenSet", "[", 
            RowBox[{
             RowBox[{"Prepend", "[", 
              RowBox[{
               RowBox[{"tempchain", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"firstelem", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ",", 
             RowBox[{"firstelem", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], 
     "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.525348834061716*^9, 3.525349000063211*^9}, {
  3.525349044424748*^9, 3.5253493037765827`*^9}, {3.525349487691102*^9, 
  3.525349627211082*^9}, {3.5271433073130083`*^9, 3.527143307703009*^9}},
 CellLabel->
  "In[195]:=",ExpressionUUID->"decc0a12-19a2-4560-be8c-b907a9a520aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmallestBaseStabChain", "[", "G_StrongGenSet", "]"}], ":=", 
  RowBox[{"RemoveSuperfluousBasePointInStabChain", "@", 
   RowBox[{"BaseChangeStabChain", "[", 
    RowBox[{"G", ",", 
     RowBox[{"Range", "[", 
      RowBox[{"PermLength", "[", "G", "]"}], "]"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5253481786032267`*^9, 3.525348183181488*^9}, {
  3.525349697642111*^9, 3.5253497310900235`*^9}, {3.527143100324244*^9, 
  3.52714310353785*^9}, {3.6015592206691*^9, 3.601559228939112*^9}},
 CellLabel->
  "In[196]:=",ExpressionUUID->"2dc1704c-1ec5-497f-8b19-74222d96d3eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroupLessOrEqualQ", "[", 
   RowBox[{"U_StrongGenSet", ",", "V_StrongGenSet"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SmallChainU", "=", 
       RowBox[{"SmallestBaseStabChain", "@", "U"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SmallChainV", "=", 
       RowBox[{"SmallestBaseStabChain", "@", "V"}]}], ",", 
      "\[IndentingNewLine]", "SmallGenSetU", ",", "SmallGenSetV", ",", "lenU",
       ",", "lenV", ",", "MaxElem", ",", "n"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"PermLength", "[", "U", "]"}], ",", 
        RowBox[{"PermLength", "[", "V", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SmallGenSetU", "=", 
      RowBox[{"SmallestGenSet", "@", "SmallChainU"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SmallGenSetV", "=", 
      RowBox[{"SmallestGenSet", "@", "SmallChainV"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"lenU", "=", 
      RowBox[{"Length", "[", "SmallGenSetU", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"lenV", "=", 
      RowBox[{"Length", "[", "SmallGenSetV", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Which", "[", 
      RowBox[{
       RowBox[{"lenU", "<", "lenV"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MaxElem", "=", 
         RowBox[{"LargestElementInGroup", "@", "SmallChainU"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"SmallGenSetU", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"SmallGenSetU", ",", 
           RowBox[{"Table", "[", 
            RowBox[{"MaxElem", ",", 
             RowBox[{"{", 
              RowBox[{"lenV", "-", "lenU"}], "}"}]}], "]"}]}], "]"}]}]}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"lenU", ">", "lenV"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MaxElem", "=", 
         RowBox[{"LargestElementInGroup", "@", "SmallChainV"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"SmallGenSetV", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"SmallGenSetV", ",", 
           RowBox[{"Table", "[", 
            RowBox[{"MaxElem", ",", 
             RowBox[{"{", 
              RowBox[{"lenU", "-", "lenV"}], "}"}]}], "]"}]}], "]"}]}]}], ",",
        "\[IndentingNewLine]", "True", ",", "Null"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SmallGenSetU", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"xAct`xPerm`Private`FromSign", "[", 
         RowBox[{
          RowBox[{"TranslatePerm", "[", 
           RowBox[{"#", ",", 
            RowBox[{"{", 
             RowBox[{"Images", ",", "n"}], "}"}]}], "]"}], ",", "n"}], "]"}], 
        "&"}], "/@", "SmallGenSetU"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"SmallGenSetV", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"xAct`xPerm`Private`FromSign", "[", 
         RowBox[{
          RowBox[{"TranslatePerm", "[", 
           RowBox[{"#", ",", 
            RowBox[{"{", 
             RowBox[{"Images", ",", "n"}], "}"}]}], "]"}], ",", "n"}], "]"}], 
        "&"}], "/@", "SmallGenSetV"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<SmallGenSetU: \>\"", ",", "SmallGenSetU"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<SmallGenSetV: \>\"", ",", "SmallGenSetV"}], "]"}], ";"}],
       "*)"}], "\[IndentingNewLine]", 
     RowBox[{"OrderedQ", "[", 
      RowBox[{"{", 
       RowBox[{"SmallGenSetU", ",", "SmallGenSetV"}], "}"}], "]"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5270831184436407`*^9, 3.527083139160477*^9}, {
   3.527083356905659*^9, 3.527083400476536*^9}, {3.5270836013736887`*^9, 
   3.527083808292452*^9}, {3.527083873859368*^9, 3.527083876526972*^9}, {
   3.527083948833099*^9, 3.527083975852347*^9}, {3.5270840229030294`*^9, 
   3.527084102868769*^9}, {3.5270841410888376`*^9, 3.527084198403338*^9}, {
   3.5270842411630135`*^9, 3.527084246342222*^9}, {3.5270843316431713`*^9, 
   3.527084607592057*^9}, 3.527084923461411*^9, {3.5270850187931786`*^9, 
   3.527085148881807*^9}, {3.527085202359701*^9, 3.527085203358103*^9}, {
   3.527085244729375*^9, 3.527085262373006*^9}, {3.527085396704842*^9, 
   3.527085400355248*^9}, {3.52708543579851*^9, 3.527085439636118*^9}, {
   3.5270856548540955`*^9, 3.527085687582954*^9}, {3.5271434189624047`*^9, 
   3.527143456839271*^9}, {3.5274877462106733`*^9, 3.5274877554614897`*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"b244408f-616a-4427-9872-e7f9f9d2c976"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmallestGroup", "[", "GroupList_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SmallChains", "=", 
       RowBox[{"SmallestBaseStabChain", "/@", "GroupList"}]}], ",", 
      "\[IndentingNewLine]", "SmallGenSets", ",", "SetLenths", ",", 
      "MaxLength", ",", "MaxElem", ",", 
      RowBox[{"i", "=", "1"}], ",", "n", ",", " ", "SmallestIndex", ",", 
      "SmallestCanonicalGroup"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"Max", "@@", 
       RowBox[{"(", 
        RowBox[{"PermLength", "/@", "GroupList"}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SmallGenSets", "=", 
      RowBox[{"SmallestGenSet", "/@", "SmallChains"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SetLenths", "=", 
      RowBox[{"Length", "/@", "SmallGenSets"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"MaxLength", "=", 
      RowBox[{"Max", "@@", "SetLenths"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"Length", "@", "GroupList"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"SetLenths", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "<", "MaxLength"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"MaxElem", "=", 
            RowBox[{"LargestElementInGroup", "[", 
             RowBox[{"SmallChains", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"SmallGenSets", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "=", 
            RowBox[{"Join", "[", 
             RowBox[{
              RowBox[{"SmallGenSets", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"Table", "[", 
               RowBox[{"MaxElem", ",", 
                RowBox[{"{", 
                 RowBox[{"MaxLength", "-", 
                  RowBox[{"SetLenths", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}]}], 
             "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"i", "=", 
         RowBox[{"i", "+", "1"}]}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SmallGenSets", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"xAct`xPerm`Private`FromSign", "[", 
          RowBox[{
           RowBox[{"TranslatePerm", "[", 
            RowBox[{"#", ",", 
             RowBox[{"{", 
              RowBox[{"Images", ",", "n"}], "}"}]}], "]"}], ",", "n"}], "]"}],
          "&"}], ",", "SmallGenSets", ",", 
        RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"SmallestIndex", "=", 
      RowBox[{"First", "@", 
       RowBox[{"Ordering", "[", 
        RowBox[{"SmallGenSets", ",", "1"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SmallestCanonicalGroup", "=", 
      RowBox[{"GenSet", "@@", 
       RowBox[{"Take", "[", 
        RowBox[{
         RowBox[{"SmallGenSets", "[", 
          RowBox[{"[", "SmallestIndex", "]"}], "]"}], ",", 
         RowBox[{"SetLenths", "[", 
          RowBox[{"[", "SmallestIndex", "]"}], "]"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"#", ",", "Cycles"}], "]"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"SmallestCanonicalGroup", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"xAct`xPerm`Private`ToSign", "[", 
          RowBox[{"#", ",", "n"}], "]"}], "&"}], ",", 
        "SmallestCanonicalGroup", ",", 
        RowBox[{"{", "1", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"SmallestIndex", ",", 
       RowBox[{"StrongGenSet", "[", " ", 
        RowBox[{
         RowBox[{"SmallChains", "[", 
          RowBox[{"[", 
           RowBox[{"SmallestIndex", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
         "SmallestCanonicalGroup"}], "]"}]}], "}"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5270965792425227`*^9, 3.527096761248042*^9}, {
  3.527096794990901*^9, 3.527096825239354*^9}, {3.527096886391462*^9, 
  3.527096893099474*^9}, {3.527096940975958*^9, 3.52709721561444*^9}, {
  3.527097264863727*^9, 3.527097296968583*^9}, {3.5270973841103373`*^9, 
  3.527097392565551*^9}, {3.527097588315695*^9, 3.5270976298117676`*^9}, {
  3.527097743301968*^9, 3.527097751601182*^9}, {3.527097783144437*^9, 
  3.5270978037520742`*^9}, {3.5270978370737314`*^9, 3.52709785297016*^9}, {
  3.5270978893962235`*^9, 3.527097916992672*^9}, {3.527097981373986*^9, 
  3.527098128731844*^9}, {3.527098320768181*^9, 3.527098355837043*^9}, {
  3.527098391810706*^9, 3.527098401529523*^9}, {3.527143440677643*^9, 
  3.5271434411300435`*^9}, {3.527146996539288*^9, 3.527146999877694*^9}, {
  3.527487762747702*^9, 3.527487763948904*^9}, {3.561781379671638*^9, 
  3.561781409670491*^9}},
 CellLabel->
  "In[198]:=",ExpressionUUID->"1189fcfc-862d-49c3-b4d8-e0a946709071"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6. Group canonicalization (old version)", "Subsubsection",
 CellChangeTimes->{
  3.5271436157255497`*^9, {3.5628214323738937`*^9, 3.562821435306699*^9}, 
   3.566218146499231*^9},ExpressionUUID->"96798d70-abb0-429c-8387-\
a77de57040c6"],

Cell["This is an old code that is not used at the moment.", "Text",
 CellChangeTimes->{{3.5617812567434235`*^9, 
  3.561781271048647*^9}},ExpressionUUID->"6232c31c-72c6-4bce-a89b-\
49eebbf75bd2"],

Cell["\<\
We canonicalize the representation of a group by checking if it has been used \
before. If it has been used, use the representation in the list $UsedGroups. \
If not, add it to $UsedGroups. 
All groups seen by ToCanonicalSGS can be found in $UsedGroups, along with the \
label for this group.
Hence, if you want to give a group sym, (not in $UsedGroups) a specific \
label, call ToCanonicalSGS[sym, label].\
\>", "Text",
 CellChangeTimes->{{3.4811918048422008`*^9, 3.4811918905862*^9}, {
  3.481191922302201*^9, 3.4811920735481997`*^9}, {3.4811927650602*^9, 
  3.4811927774922*^9}},ExpressionUUID->"1d782144-c49f-43b3-9940-981f0c516fca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$UsedGroups", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellLabel->
  "In[199]:=",ExpressionUUID->"92cb6267-857c-4932-a07a-b25f5334292f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonicalSGS", "[", "sym_StrongGenSet", "]"}], ":=", 
  RowBox[{"ToCanonicalSGS", "[", 
   RowBox[{"sym", ",", "Null"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4811877231422*^9, 3.4811878088472*^9}, {
  3.4811881041272*^9, 3.4811881190502*^9}, {3.4811889419412007`*^9, 
  3.4811889762082*^9}, {3.4811891775262003`*^9, 3.4811891779412007`*^9}, {
  3.4811895062792*^9, 3.4811895088382*^9}, {3.4811897049422*^9, 
  3.4811897088572006`*^9}},
 CellLabel->
  "In[200]:=",ExpressionUUID->"b0e1d36f-0ccf-4621-87ed-80cf5f604caa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonicalSGS", "[", 
   RowBox[{"sym_StrongGenSet", ",", "label_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"groupcount", "=", "1"}], ",", 
      RowBox[{"found", "=", "False"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"groupcount", "<=", 
          RowBox[{"Length", "[", "$UsedGroups", "]"}]}], ")"}], "&&", 
        RowBox[{"!", "found"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"found", "=", 
         RowBox[{
          RowBox[{"SubgroupQ", "[", 
           RowBox[{
            RowBox[{"$UsedGroups", "[", 
             RowBox[{"[", 
              RowBox[{"groupcount", ",", "1"}], "]"}], "]"}], ",", "sym"}], 
           "]"}], "&&", 
          RowBox[{"SubgroupQ", "[", 
           RowBox[{"sym", ",", 
            RowBox[{"$UsedGroups", "[", 
             RowBox[{"[", 
              RowBox[{"groupcount", ",", "1"}], "]"}], "]"}]}], "]"}]}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", "found"}], ",", 
          RowBox[{"groupcount", "=", 
           RowBox[{"groupcount", "+", "1"}]}]}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"!", "found"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"label", "===", "Null"}], ",", "\[IndentingNewLine]", 
         RowBox[{"$UsedGroups", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"$UsedGroups", ",", 
            RowBox[{"{", 
             RowBox[{"sym", ",", 
              RowBox[{"DefaultLabelSym", "[", "sym", "]"}]}], "}"}]}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"$UsedGroups", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"$UsedGroups", ",", 
            RowBox[{"{", 
             RowBox[{"sym", ",", "label"}], "}"}]}], "]"}]}]}], "]"}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"$UsedGroups", "[", 
      RowBox[{"[", "groupcount", "]"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQrXYobNm19y8dDWbarQfR3X8bD4BoS9f0wyB6XoPe
CRDt+PH7LRD93qL1MYjOUHoCpvn2CbwC0ct09D+C6DVrT3yDqP8Npjfp1f2F
iIewXgfSVUs/8IDoEpV4GRDdFJipBKLtj3HYgGgd5yf2IJrluY3DdbC58l4g
OqRkgj+I/rYzKBhEP+95kwCiZV7X5YJonxPqZSD6wuaXDSBaS4KzA0R3Xro2
EUTff/AeTBsf2bgIRPcHOywG0WqH/q0E0Xp5/1eDaK6MbYo3gHSZ/y4wzZUx
zQpE/+Kf6gCiAaW+vmw=
  "],
 CellLabel->
  "In[201]:=",ExpressionUUID->"41f0d3a2-43f0-4e2b-8713-4795f19d0b68"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CanonicalizeGroupsInSym", "[", "expr_", "]"}], ":=", 
  RowBox[{"expr", "/.", 
   RowBox[{
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], 
    "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"canonicalsym", ",", "newlabel"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"canonicalsym", ",", "newlabel"}], "}"}], "=", 
        RowBox[{"ToCanonicalSGS", "[", 
         RowBox[{"sym", ",", "label"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"SymH", "[", 
        RowBox[{"headlist", ",", "canonicalsym", ",", "newlabel"}], "]"}]}]}],
      "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4811928537552*^9, 3.4811929548642*^9}, {
  3.4811930008372*^9, 3.4811930263392*^9}, {3.4947528495030003`*^9, 
  3.4947528507042*^9}, {3.4957027507508*^9, 3.4957027554152*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"b30c2658-07db-4abb-bcff-329fbc8c9359"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7. Product of groups", "Subsubsection",
 CellChangeTimes->{3.527143618439955*^9, 
  3.566218148683235*^9},ExpressionUUID->"f5c6eb7e-57fe-4448-9ca7-\
9f9dccdecfcc"],

Cell["\<\
Here follows an algorithm that checks if perm is such that perm is in H.G \
where G is given by GS1 and H is given GS2. Observe that we need the same \
base for the two strong generating sets.
The idea is to write perm=PermProduct[u2,newperm,u1], where u1 is in G, u2 in \
H and newperm don't move the first point in the base. 
This means First@base = OnPoints[First@base,PermProduct[InversePerm[u2], \
perm, InversePerm[u1]]]. But this is equivalent to 
First@base = OnPoints[First@base,PermProduct[u1, InversePerm[perm], u2]] = \
OnPoints[OnPoints[First@base, u1], PermProduct[InversePerm[perm]], u2]].
We can rewrite this as OnPoints[First@base,PermProduct[InversePerm[u2]], \
perm]] = OnPoints[First@base, u1].
Let orbit1 and orbit2 denote the orbits of the first base point in G and H \
respectively.
Define point1=OnPoints[First@base, u1], then point1 must be in orbit1, but \
also in OnPoints[orbit2,perm].

In reality we don't know u1 and u2, but we can compute them from a \
TraceSchreier operation using point.
Hence, we consider all possible choices of point1 in the intersection between \
orbit1 and OnPoints[orbit2,perm].

From a specific choice of point1, we compute u1, and u2, and newperm.
We can then iterate with the first point removed from the base.

The different choices of point1 gives a tree. We check the first possible \
choice first, if that turns out to not give a solution, we remove that \
choice, and try the next one.\
\>", "Text",
 CellChangeTimes->{{3.483626326477*^9, 3.4836266301140003`*^9}, {
  3.483627772705*^9, 3.483627783858*^9}, {3.4836278179780006`*^9, 
  3.483627857125*^9}, {3.483627939293*^9, 3.483627945504*^9}, {
  3.483628011899*^9, 3.48362801574*^9}, {3.483628064148*^9, 
  3.483628492041*^9}, {3.483628524693*^9, 3.483628578227*^9}, {
  3.483628718277*^9, 3.483628891701*^9}, {3.4836289465360007`*^9, 
  3.483629101409*^9}, {3.483629172908*^9, 3.4836294103570004`*^9}, {
  3.483629476783*^9, 3.483629591333*^9}, {3.483629633193*^9, 
  3.483629770946*^9}, {3.483629802039*^9, 3.48362983087*^9}, {
  3.498657486637*^9, 3.4986574904434*^9}, {3.5157487206244187`*^9, 
  3.515748734306201*^9}, {3.567862587639682*^9, 
  3.5678625879828825`*^9}},ExpressionUUID->"935f6b49-c4ff-4d08-a3be-\
deecc208ff0b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sifting", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_List", ",", "GS1_GenSet"}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_List", ",", "GS2_GenSet"}], "]"}], ",", 
     RowBox[{"word1_List", ":", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"word2_List", ":", 
      RowBox[{"{", "}"}]}]}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "base", "]"}], "===", "0"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PermEqual", "[", 
        RowBox[{"perm", ",", "ID"}], "]"}], ",", "word1", ",", "word2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Sorbit1", "=", 
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "[", "base", "]"}], ",", "GS1", ",", 
            RowBox[{"Max", "[", 
             RowBox[{
              RowBox[{"PermDeg", "[", "perm", "]"}], ",", 
              RowBox[{"PermDeg", "[", "GS1", "]"}], ",", 
              RowBox[{"PermDeg", "[", "GS2", "]"}]}], "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Sorbit2", "=", 
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "[", "base", "]"}], ",", "GS2", ",", 
            RowBox[{"Max", "[", 
             RowBox[{
              RowBox[{"PermDeg", "[", "perm", "]"}], ",", 
              RowBox[{"PermDeg", "[", "GS1", "]"}], ",", 
              RowBox[{"PermDeg", "[", "GS2", "]"}]}], "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", "mappedorbit2", ",", "possiblepoints", ",", 
         "\[IndentingNewLine]", "point1", ",", "u1", ",", "u2", ",", 
         "newperm", ",", " ", 
         RowBox[{"foundID", "=", "False"}], ",", 
         RowBox[{"newword1", "=", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"newword2", "=", 
          RowBox[{"{", "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"mappedorbit2", "=", 
         RowBox[{"OnPoints", "[", 
          RowBox[{
           RowBox[{"First", "@", "Sorbit2"}], ",", "perm"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"possiblepoints", "=", 
         RowBox[{"Cases", "[", 
          RowBox[{
           RowBox[{"First", "@", "Sorbit1"}], ",", 
           RowBox[{"Alternatives", "@@", "mappedorbit2"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "[", "possiblepoints", "]"}], ">", "0"}], 
            ")"}], " ", "&&", " ", 
           RowBox[{"Not", "[", "foundID", "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"point1", "=", 
            RowBox[{"First", "@", "possiblepoints"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"possiblepoints", "=", 
            RowBox[{"Rest", "@", "possiblepoints"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"u1", "=", 
            RowBox[{"TraceSchreier", "[", 
             RowBox[{"point1", ",", "Sorbit1"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"u2", "=", 
            RowBox[{"InversePerm", "@", 
             RowBox[{"TraceSchreier", "[", 
              RowBox[{
               RowBox[{"OnPoints", "[", 
                RowBox[{"point1", ",", 
                 RowBox[{"InversePerm", "[", "perm", "]"}]}], "]"}], ",", 
               "Sorbit2"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"newperm", "=", 
            RowBox[{"PermProduct", "[", 
             RowBox[{
              RowBox[{"InversePerm", "[", "u2", "]"}], ",", "perm", ",", 
              RowBox[{"InversePerm", "[", "u1", "]"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"foundID", ",", "newword1", ",", "newword2"}], "}"}], 
            "=", 
            RowBox[{"Sifting", "[", 
             RowBox[{"newperm", ",", 
              RowBox[{"StrongGenSet", "[", 
               RowBox[{
                RowBox[{"Rest", "[", "base", "]"}], ",", 
                RowBox[{"Stabilizer", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"First", "[", "base", "]"}], "}"}], ",", "GS1"}], 
                 "]"}]}], "]"}], ",", 
              RowBox[{"StrongGenSet", "[", 
               RowBox[{
                RowBox[{"Rest", "[", "base", "]"}], ",", 
                RowBox[{"Stabilizer", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"First", "[", "base", "]"}], "}"}], ",", "GS2"}], 
                 "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Append", "[", 
               RowBox[{"word1", ",", "u2"}], "]"}], ",", 
              RowBox[{"Prepend", "[", 
               RowBox[{"word2", ",", "u1"}], "]"}]}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"foundID", ",", "newword1", ",", "newword2"}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.483459692193*^9, 3.4834597070285997`*^9}, {
   3.4834597605678*^9, 3.483459787836601*^9}, {3.4834598395506*^9, 
   3.4834598430137997`*^9}, {3.483459878207401*^9, 3.4834598900634003`*^9}, {
   3.483459987969*^9, 3.483460002009*^9}, {3.4834602776922*^9, 
   3.4834603334309998`*^9}, {3.483460395909*^9, 3.4834604550642*^9}, {
   3.483460671093*^9, 3.4834607060682*^9}, {3.483460793787*^9, 
   3.4834608194178*^9}, {3.4834609689126*^9, 3.4834611964854*^9}, {
   3.483461358039*^9, 3.4834613698794007`*^9}, {3.483461429206199*^9, 
   3.4834615317918*^9}, 3.483461563335*^9, {3.4834616881818*^9, 
   3.4834617331098003`*^9}, {3.4834617886614*^9, 3.4834618356486*^9}, {
   3.483461902401*^9, 3.4834619051934*^9}, {3.4834621893006*^9, 
   3.4834621912662*^9}, {3.4834622580342*^9, 3.4834623573594*^9}, {
   3.4834625394894*^9, 3.483462549723*^9}, {3.4834626112338*^9, 
   3.4834626131682*^9}, {3.4834630456002*^9, 3.4834630585326*^9}, {
   3.4834632041898003`*^9, 3.4834632187914*^9}, {3.4834634056326*^9, 
   3.4834634193138*^9}, {3.483463494973799*^9, 3.4834635104802*^9}, {
   3.4834636204133997`*^9, 3.4834636515042*^9}, {3.483463839219*^9, 
   3.4834638422454*^9}, {3.483463907625*^9, 3.4834639122894*^9}, {
   3.4834639497606*^9, 3.4834639622874002`*^9}, {3.4834640682894*^9, 
   3.4834641935886*^9}, {3.4834642535081997`*^9, 3.4834642643814*^9}, {
   3.4834642970322*^9, 3.4834642993254004`*^9}, {3.4834643528958*^9, 
   3.483464485683*^9}, {3.4834645329978*^9, 3.4834646538822002`*^9}, {
   3.4834646841618*^9, 3.4834647046914*^9}, {3.483464901267*^9, 
   3.4834649084274*^9}, {3.4834707230436*^9, 3.4834708896186*^9}, {
   3.4834709208445997`*^9, 3.4834709227046003`*^9}, {3.4834709760576*^9, 
   3.4834710627076*^9}, {3.4834710979316*^9, 3.4834711577726*^9}, {
   3.4834713601906*^9, 3.4834714963826*^9}, {3.4834716873466*^9, 
   3.4834717496686*^9}, {3.4834718283136*^9, 3.4834719490356*^9}, {
   3.4834720288856*^9, 3.4834720316476*^9}, {3.4834720899636*^9, 
   3.4834720923336*^9}, {3.4834722404066*^9, 3.4834722753936*^9}, {
   3.4834730798826*^9, 3.4834732265666*^9}, {3.4834732727756*^9, 
   3.4834733098566*^9}, {3.4834733413186*^9, 3.4834733659896*^9}, {
   3.4834735575316*^9, 3.4834736450346003`*^9}, {3.4834736826566*^9, 
   3.4834737493896*^9}, {3.4834738821766*^9, 3.4834740357866*^9}, {
   3.483474092355601*^9, 3.4834742306056004`*^9}, {3.4834743710776*^9, 
   3.4834743844706*^9}, {3.4834745527576*^9, 3.4834746117936*^9}, {
   3.4834749369796*^9, 3.4834749456656*^9}, {3.4834750292566*^9, 
   3.4834750589786*^9}, {3.4834751559536*^9, 3.4834752015946*^9}, {
   3.4834759276956*^9, 3.4834759696796*^9}, 3.4834760810446*^9, 
   3.4834761180546*^9, {3.4834761567916*^9, 3.4834762114596*^9}, {
   3.4834763023876*^9, 3.4834763487056*^9}, {3.4834764281026*^9, 
   3.4834765285666*^9}, {3.4834770730685997`*^9, 3.4834770983926*^9}, {
   3.4834775189696*^9, 3.4834775215556*^9}, {3.4834775822796*^9, 
   3.4834775897346*^9}, {3.4834777236106*^9, 3.4834777244796*^9}, {
   3.483618793756*^9, 3.483618989196*^9}, {3.483619041054*^9, 
   3.483619041118*^9}, {3.483619173558*^9, 3.483619176289*^9}, {
   3.483619211552*^9, 3.483619211613*^9}, {3.4836193416940002`*^9, 
   3.483619353783*^9}, {3.483619386829*^9, 3.483619419578*^9}, {
   3.483619488605*^9, 3.483619516601*^9}, {3.483619557473*^9, 
   3.483619576486*^9}, {3.483619613766*^9, 3.4836196884040003`*^9}, {
   3.483619726636*^9, 3.483619802185*^9}, {3.483619837899*^9, 
   3.483619886836*^9}, 3.483619938485*^9, {3.4836199968380003`*^9, 
   3.483620043609*^9}, {3.483620083367*^9, 3.483620219432*^9}, {
   3.483620285285*^9, 3.4836203035150003`*^9}, {3.483620351993*^9, 
   3.483620367680001*^9}, {3.483620398484*^9, 3.483620399685*^9}, {
   3.48362044536*^9, 3.483620533875*^9}, {3.4836206337860003`*^9, 
   3.483620654201*^9}, {3.483620748747001*^9, 3.483620795483*^9}, {
   3.483621016045*^9, 3.483621040933*^9}, {3.483621449882*^9, 
   3.483621461781*^9}, {3.483621493241*^9, 3.4836215797870007`*^9}, {
   3.483621660508*^9, 3.483621679663*^9}, {3.483621755248*^9, 
   3.483621779907*^9}, {3.4836218950360007`*^9, 3.483621931642*^9}, {
   3.483622029203*^9, 3.483622043766*^9}, {3.483622216782*^9, 
   3.483622222183*^9}, {3.48362387158*^9, 3.483623877699*^9}, {
   3.483623918140001*^9, 3.48362392495*^9}, {3.483626704108*^9, 
   3.483626706689*^9}, {3.483627116244*^9, 3.4836271184700007`*^9}, {
   3.483627175668*^9, 3.483627179772001*^9}, {3.483627378140001*^9, 
   3.483627494698*^9}, {3.483627650288*^9, 3.483627663473*^9}, {
   3.4836940328974*^9, 3.4836940550464*^9}, {3.4836942501624007`*^9, 
   3.4836942768564*^9}, {3.4986671227882*^9, 3.4986671255806*^9}, {
   3.5192969388853707`*^9, 3.5192969586194053`*^9}, {3.562831194524468*^9, 
   3.5628312485473647`*^9}, {3.562831410616048*^9, 3.562831415093255*^9}, {
   3.5628316159748087`*^9, 3.5628316226048203`*^9}, 3.567862587998483*^9},
 CellLabel->
  "In[203]:=",ExpressionUUID->"6ff9559c-3607-4a16-86e3-2f56b8d9ab37"],

Cell["\<\
A somewhat streamlined version of the above algorithm: 
Here follows an algorithm that checks if perm is such that perm is in H.G \
where G is given by GS1 and H is given GS2. 
Observe that we need the same base for the two strong generating sets.
The idea is to write perm=PermProduct[InversePerm[u2], newperm, u1]
or equivalently newperm = PermProduct[u2, perm, InversePerm[u1]], where u1 is \
in G, u2 in H and newperm don't move the first point in the base. 
This means First@base = OnPoints[First@base,PermProduct[u2, perm, \
InversePerm[u1]]]. But this is equivalent to 
First@base = OnPoints[First@base,PermProduct[u1, InversePerm[perm], \
InvesePerm[u2]]] 
= OnPoints[OnPoints[First@base, u1], PermProduct[InversePerm[perm]], \
InvesePerm[u2]]]
= OnPoints[OnPoints[First@base, u1], InversePerm[PermProduct[u2,perm]]].
We can rewrite this as OnPoints[First@base,PermProduct[u2, perm]] = \
OnPoints[First@base, u1].
Let orbit1 and orbit2 denote the orbits of the first base point in G and H \
respectively.
Define point1=OnPoints[First@base, u1], then point1 must be in orbit1, but \
also in OnPoints[orbit2,perm].

In reality we don't know u1 and u2, but we can compute them from a \
TraceSchreier operation using point1.
Hence, we consider all possible choices of point1 in the intersection between \
orbit1 and OnPoints[orbit2,perm].

From all possible choices of point1, we compute u1, and u2, and newperm. 
All posibilities of newperm are computed, and sorted and duplicates removed. \
Call this list possiblenewperm.
We can then iterate with the first point removed from the base, and the first \
element in possiblenewperm as the permutation.
If the result is false, we try the next element in possiblenewperm.\
\>", "Text",
 CellChangeTimes->{{3.483629850754*^9, 3.483629879032*^9}, {
   3.4986566952646*^9, 3.498656755309*^9}, {3.4986571522198*^9, 
   3.498657178849*^9}, {3.498657598645*^9, 3.4986577202469997`*^9}, {
   3.498657815797*^9, 3.498657985993*^9}, {3.498658024384599*^9, 
   3.498658048627*^9}, 3.4986580821202*^9, {3.4986581211202*^9, 
   3.498658200649*^9}, {3.4986582985546*^9, 3.4986583276954*^9}, {
   3.498666376531*^9, 3.4986663898222*^9}, {3.4986664665274*^9, 
   3.4986665772874002`*^9}, {3.4986666737734*^9, 3.4986668450302*^9}, {
   3.4986669048406*^9, 3.4986669477874002`*^9}, {3.515748759084618*^9, 
   3.515748759389636*^9}, {3.567862588092083*^9, 
   3.5678625885756836`*^9}},ExpressionUUID->"5a3705c9-4ebb-4782-b200-\
0273a3964ca5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sifting2", "[", 
    RowBox[{
    "perm_", ",", "base_List", ",", "GS1_GenSet", ",", "GS2_GenSet", ",", 
     "n_"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "base", "]"}], "===", "0"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PermEqual", "[", 
      RowBox[{"perm", ",", "ID"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Compute", " ", "the", " ", "Schreierorbits", " ", "of", " ", "the", 
          " ", "first", " ", "base", " ", "point"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Sorbit1", "=", 
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "[", "base", "]"}], ",", "GS1", ",", "n"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Sorbit2", "=", 
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "[", "base", "]"}], ",", "GS2", ",", "n"}], 
           "]"}]}], ",", "\[IndentingNewLine]", "mappedorbit2", ",", 
         "possiblepoints1", ",", "\[IndentingNewLine]", 
         RowBox[{"foundID", "=", "False"}], ",", " ", "possibleu1", ",", 
         "possibleu2", ",", "possiblenewperm"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Which", " ", "points", " ", "does", " ", "perm", " ", "map", " ", 
         "Sorbit2", " ", 
         RowBox[{"to", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"mappedorbit2", "=", 
         RowBox[{"OnPoints", "[", 
          RowBox[{
           RowBox[{"First", "@", "Sorbit2"}], ",", "perm"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "point1", " ", "must", " ", "be", " ", "in", " ", "orbit1", " ", 
          "and", " ", "in", " ", 
          RowBox[{"mappedorbit2", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"possiblepoints1", "=", 
         RowBox[{"Cases", "[", 
          RowBox[{
           RowBox[{"First", "@", "Sorbit1"}], ",", 
           RowBox[{"Alternatives", "@@", "mappedorbit2"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Compute", " ", "the", " ", "corresponding", " ", "u1", " ", "and", 
          " ", "u2", " ", "for", " ", "the", " ", "points", " ", "in", " ", 
          "possiblepoints1"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"possibleu1", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"TraceSchreier", "[", 
            RowBox[{"#", ",", "Sorbit1"}], "]"}], "&"}], "/@", 
          "possiblepoints1"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"possibleu2", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"TraceSchreier", "[", 
            RowBox[{
             RowBox[{"OnPoints", "[", 
              RowBox[{"#", ",", 
               RowBox[{"InversePerm", "[", "perm", "]"}]}], "]"}], ",", 
             "Sorbit2"}], "]"}], "&"}], "/@", "possiblepoints1"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Compute", " ", "all", " ", "possible", " ", "newperm"}], 
          ",", " ", 
          RowBox[{
          "remove", " ", "duplicates", " ", "and", " ", "sort", " ", "the", 
           " ", "list"}], ",", " ", 
          RowBox[{
          "so", " ", "we", " ", "find", " ", "ID", " ", "as", " ", "quickly", 
           " ", "as", " ", 
           RowBox[{"possible", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"possiblenewperm", "=", 
         RowBox[{"PermSort", "@", 
          RowBox[{"Union", "@", 
           RowBox[{"Inner", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"PermProduct", "[", 
               RowBox[{"#2", ",", "perm", ",", 
                RowBox[{"InversePerm", "[", "#1", "]"}]}], "]"}], "&"}], ",", 
             "possibleu1", ",", "possibleu2", ",", "List"}], "]"}]}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "[", "possiblenewperm", "]"}], ">", "0"}], 
            ")"}], " ", "&&", " ", 
           RowBox[{"Not", "[", "foundID", "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"foundID", "=", 
            RowBox[{"Sifting2", "[", 
             RowBox[{
              RowBox[{"First", "@", "possiblenewperm"}], ",", 
              RowBox[{"Rest", "[", "base", "]"}], ",", 
              RowBox[{"Stabilizer", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"First", "[", "base", "]"}], "}"}], ",", "GS1"}], 
               "]"}], ",", 
              RowBox[{"Stabilizer", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"First", "[", "base", "]"}], "}"}], ",", "GS2"}], 
               "]"}], ",", "n"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"possiblenewperm", "=", 
            RowBox[{"Rest", "@", "possiblenewperm"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "foundID"}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.483459692193*^9, 3.4834597070285997`*^9}, {
   3.4834597605678*^9, 3.483459787836601*^9}, {3.4834598395506*^9, 
   3.4834598430137997`*^9}, {3.483459878207401*^9, 3.4834598900634003`*^9}, {
   3.483459987969*^9, 3.483460002009*^9}, {3.4834602776922*^9, 
   3.4834603334309998`*^9}, {3.483460395909*^9, 3.4834604550642*^9}, {
   3.483460671093*^9, 3.4834607060682*^9}, {3.483460793787*^9, 
   3.4834608194178*^9}, {3.4834609689126*^9, 3.4834611964854*^9}, {
   3.483461358039*^9, 3.4834613698794007`*^9}, {3.483461429206199*^9, 
   3.4834615317918*^9}, 3.483461563335*^9, {3.4834616881818*^9, 
   3.4834617331098003`*^9}, {3.4834617886614*^9, 3.4834618356486*^9}, {
   3.483461902401*^9, 3.4834619051934*^9}, {3.4834621893006*^9, 
   3.4834621912662*^9}, {3.4834622580342*^9, 3.4834623573594*^9}, {
   3.4834625394894*^9, 3.483462549723*^9}, {3.4834626112338*^9, 
   3.4834626131682*^9}, {3.4834630456002*^9, 3.4834630585326*^9}, {
   3.4834632041898003`*^9, 3.4834632187914*^9}, {3.4834634056326*^9, 
   3.4834634193138*^9}, {3.483463494973799*^9, 3.4834635104802*^9}, {
   3.4834636204133997`*^9, 3.4834636515042*^9}, {3.483463839219*^9, 
   3.4834638422454*^9}, {3.483463907625*^9, 3.4834639122894*^9}, {
   3.4834639497606*^9, 3.4834639622874002`*^9}, {3.4834640682894*^9, 
   3.4834641935886*^9}, {3.4834642535081997`*^9, 3.4834642643814*^9}, {
   3.4834642970322*^9, 3.4834642993254004`*^9}, {3.4834643528958*^9, 
   3.483464485683*^9}, {3.4834645329978*^9, 3.4834646538822002`*^9}, {
   3.4834646841618*^9, 3.4834647046914*^9}, {3.483464901267*^9, 
   3.4834649084274*^9}, {3.4834707230436*^9, 3.4834708896186*^9}, {
   3.4834709208445997`*^9, 3.4834709227046003`*^9}, {3.4834709760576*^9, 
   3.4834710627076*^9}, {3.4834710979316*^9, 3.4834711577726*^9}, {
   3.4834713601906*^9, 3.4834714963826*^9}, {3.4834716873466*^9, 
   3.4834717496686*^9}, {3.4834718283136*^9, 3.4834719490356*^9}, {
   3.4834720288856*^9, 3.4834720316476*^9}, {3.4834720899636*^9, 
   3.4834720923336*^9}, {3.4834722404066*^9, 3.4834722753936*^9}, {
   3.4834730798826*^9, 3.4834732265666*^9}, {3.4834732727756*^9, 
   3.4834733098566*^9}, {3.4834733413186*^9, 3.4834733659896*^9}, {
   3.4834735575316*^9, 3.4834736450346003`*^9}, {3.4834736826566*^9, 
   3.4834737493896*^9}, {3.4834738821766*^9, 3.4834740357866*^9}, {
   3.483474092355601*^9, 3.4834742306056004`*^9}, {3.4834743710776*^9, 
   3.4834743844706*^9}, {3.4834745527576*^9, 3.4834746117936*^9}, {
   3.4834749369796*^9, 3.4834749456656*^9}, {3.4834750292566*^9, 
   3.4834750589786*^9}, {3.4834751559536*^9, 3.4834752015946*^9}, {
   3.4834759276956*^9, 3.4834759696796*^9}, 3.4834760810446*^9, 
   3.4834761180546*^9, {3.4834761567916*^9, 3.4834762114596*^9}, {
   3.4834763023876*^9, 3.4834763487056*^9}, {3.4834764281026*^9, 
   3.4834765285666*^9}, {3.4834770730685997`*^9, 3.4834770983926*^9}, {
   3.4834775189696*^9, 3.4834775215556*^9}, {3.4834775822796*^9, 
   3.4834775897346*^9}, {3.4834777236106*^9, 3.4834777244796*^9}, {
   3.483618793756*^9, 3.483618989196*^9}, {3.483619041054*^9, 
   3.483619041118*^9}, {3.483619173558*^9, 3.483619176289*^9}, {
   3.483619211552*^9, 3.483619211613*^9}, {3.4836193416940002`*^9, 
   3.483619353783*^9}, {3.483619386829*^9, 3.483619419578*^9}, {
   3.483619488605*^9, 3.483619516601*^9}, {3.483619557473*^9, 
   3.483619576486*^9}, {3.483619613766*^9, 3.4836196884040003`*^9}, {
   3.483619726636*^9, 3.483619802185*^9}, {3.483619837899*^9, 
   3.483619886836*^9}, 3.483619938485*^9, {3.4836199968380003`*^9, 
   3.483620043609*^9}, {3.483620083367*^9, 3.483620219432*^9}, {
   3.483620285285*^9, 3.4836203035150003`*^9}, {3.483620351993*^9, 
   3.483620367680001*^9}, {3.483620398484*^9, 3.483620399685*^9}, {
   3.48362044536*^9, 3.483620533875*^9}, {3.4836206337860003`*^9, 
   3.483620654201*^9}, {3.483620748747001*^9, 3.483620795483*^9}, {
   3.483621016045*^9, 3.483621040933*^9}, {3.483621449882*^9, 
   3.483621461781*^9}, {3.483621493241*^9, 3.4836215797870007`*^9}, {
   3.483621660508*^9, 3.483621679663*^9}, {3.483621755248*^9, 
   3.483621779907*^9}, {3.4836218950360007`*^9, 3.483621931642*^9}, {
   3.483622029203*^9, 3.483622043766*^9}, {3.483622216782*^9, 
   3.483622222183*^9}, {3.48362387158*^9, 3.483623877699*^9}, {
   3.483623918140001*^9, 3.483624052844*^9}, {3.483624225372*^9, 
   3.48362425215*^9}, {3.483624291428*^9, 3.483624291893*^9}, {
   3.483625143644*^9, 3.483625166398*^9}, {3.483625673791*^9, 
   3.483625695034*^9}, 3.483625753935*^9, {3.48362587849*^9, 
   3.483625879126*^9}, 3.483625930352*^9, {3.48362599151*^9, 
   3.483626015142*^9}, {3.483626045307*^9, 3.483626049514*^9}, {
   3.483627517263*^9, 3.483627540937001*^9}, {3.483627673958*^9, 
   3.483627681267*^9}, {3.4955508944676*^9, 3.4955509642776003`*^9}, {
   3.4955514566604*^9, 3.4955514636492*^9}, {3.4955519648148*^9, 
   3.4955519962176*^9}, {3.4985694295378*^9, 3.4985694419554*^9}, {
   3.498653668069*^9, 3.498653668537*^9}, {3.4986565375954*^9, 
   3.4986566551258*^9}, {3.498656793529*^9, 3.4986568960834*^9}, {
   3.4986569729914*^9, 3.4986570094174*^9}, {3.4986570747658*^9, 
   3.4986570763726*^9}, {3.4986571502698*^9, 3.4986571600042*^9}, {
   3.4986607406722*^9, 3.4986607968946*^9}, {3.4986608529454*^9, 
   3.498660881353*^9}, {3.4986610206921997`*^9, 3.4986610377274*^9}, {
   3.4986612102166*^9, 3.4986612389518003`*^9}, {3.498661456915*^9, 
   3.498661477429*^9}, {3.498661933807*^9, 3.4986620217441993`*^9}, {
   3.4986620569066*^9, 3.4986620892766*^9}, {3.4986621247822*^9, 
   3.4986621971818*^9}, {3.4986622819834003`*^9, 3.4986622829818*^9}, {
   3.498662362027*^9, 3.498662422477*^9}, {3.4986625108354*^9, 
   3.4986626365246*^9}, {3.4986627725878*^9, 3.498662834161*^9}, {
   3.4986628908982*^9, 3.4986629013814*^9}, 3.4986640223194*^9, 
   3.4986640640962*^9, {3.4986662244934*^9, 3.4986662273638*^9}, {
   3.51801501834737*^9, 3.5180150212489758`*^9}, 3.567862588591284*^9},
 CellLabel->
  "In[204]:=",ExpressionUUID->"6440bdac-3a0e-477a-9b16-d304ea5c68e3"],

Cell["\<\
The same thing, but we take the the shreierorbits of the first points in the \
base for all groups in the stabilizer chain.\
\>", "Text",
 CellChangeTimes->{{3.5903157654666805`*^9, 
  3.590315835355803*^9}},ExpressionUUID->"769ab544-9307-42df-b6da-\
d43c5f3a5b52"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sifting2b", "[", 
    RowBox[{
    "perm_", ",", "base_List", ",", "StabChainSchOrbitsG1_List", ",", 
     "StabChainSchOrbitsG2_List", ",", "n_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "base", "]"}], "===", "0"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PermEqual", "[", 
      RowBox[{"perm", ",", "ID"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Compute", " ", "the", " ", "Schreierorbits", " ", "of", " ", "the", 
          " ", "first", " ", "base", " ", "point"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Sorbit1", "=", 
          RowBox[{"First", "@", "StabChainSchOrbitsG1"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Sorbit2", "=", 
          RowBox[{"First", "@", "StabChainSchOrbitsG2"}]}], ",", 
         "\[IndentingNewLine]", "mappedorbit2", ",", "possiblepoints1", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"foundID", "=", "False"}], ",", " ", "possibleu1", ",", 
         "possibleu2", ",", "possiblenewperm"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Which", " ", "points", " ", "does", " ", "perm", " ", "map", " ", 
         "Sorbit2", " ", 
         RowBox[{"to", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"mappedorbit2", "=", 
         RowBox[{"OnPoints", "[", 
          RowBox[{
           RowBox[{"First", "@", "Sorbit2"}], ",", "perm"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "point1", " ", "must", " ", "be", " ", "in", " ", "orbit1", " ", 
          "and", " ", "in", " ", 
          RowBox[{"mappedorbit2", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"possiblepoints1", "=", 
         RowBox[{"Cases", "[", 
          RowBox[{
           RowBox[{"First", "@", "Sorbit1"}], ",", 
           RowBox[{"Alternatives", "@@", "mappedorbit2"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Compute", " ", "the", " ", "corresponding", " ", "u1", " ", "and", 
          " ", "u2", " ", "for", " ", "the", " ", "points", " ", "in", " ", 
          "possiblepoints1"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"possibleu1", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"TraceSchreier", "[", 
            RowBox[{"#", ",", "Sorbit1"}], "]"}], "&"}], "/@", 
          "possiblepoints1"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"possibleu2", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"TraceSchreier", "[", 
            RowBox[{
             RowBox[{"OnPoints", "[", 
              RowBox[{"#", ",", 
               RowBox[{"InversePerm", "[", "perm", "]"}]}], "]"}], ",", 
             "Sorbit2"}], "]"}], "&"}], "/@", "possiblepoints1"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Compute", " ", "all", " ", "possible", " ", "newperm"}], 
          ",", " ", 
          RowBox[{
          "remove", " ", "duplicates", " ", "and", " ", "sort", " ", "the", 
           " ", "list"}], ",", " ", 
          RowBox[{
          "so", " ", "we", " ", "find", " ", "ID", " ", "as", " ", "quickly", 
           " ", "as", " ", 
           RowBox[{"possible", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"possiblenewperm", "=", 
         RowBox[{"PermSort", "@", 
          RowBox[{"Union", "@", 
           RowBox[{"Inner", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"PermProduct", "[", 
               RowBox[{"#2", ",", "perm", ",", 
                RowBox[{"InversePerm", "[", "#1", "]"}]}], "]"}], "&"}], ",", 
             "possibleu1", ",", "possibleu2", ",", "List"}], "]"}]}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "[", "possiblenewperm", "]"}], ">", "0"}], 
            ")"}], " ", "&&", " ", 
           RowBox[{"Not", "[", "foundID", "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"foundID", "=", 
            RowBox[{"Sifting2b", "[", 
             RowBox[{
              RowBox[{"First", "@", "possiblenewperm"}], ",", 
              RowBox[{"Rest", "[", "base", "]"}], ",", 
              RowBox[{"Rest", "@", "StabChainSchOrbitsG1"}], ",", 
              RowBox[{"Rest", "@", "StabChainSchOrbitsG2"}], ",", "n"}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"possiblenewperm", "=", 
            RowBox[{"Rest", "@", "possiblenewperm"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "foundID"}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590315749835453*^9, 3.590315754468661*^9}},
 CellLabel->
  "In[205]:=",ExpressionUUID->"b616b4f9-7acb-414f-bb13-2fc2ae8ef3cb"],

Cell["\<\
The sifting would be much quicker if the points moved by the permutation are \
the first points in the base.
Sifting3 changes base so this is the case and then calles Sifting2. The base \
change can probably be done in a better and safer way. Can we guarantee that \
the bases of the groups are the same?\
\>", "Text",
 CellChangeTimes->{{3.4986691476057997`*^9, 3.498669255355*^9}, {
  3.5180153584757676`*^9, 
  3.518015411593861*^9}},ExpressionUUID->"0a33838f-3c7c-4e5d-ae91-\
517e1346063b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sifting3", "[", 
   RowBox[{"perm_", ",", "SGS1_StrongGenSet", ",", "SGS2_StrongGenSet"}], 
   "]"}], ":=", 
  RowBox[{"Sifting3", "[", 
   RowBox[{"perm", ",", "SGS1", ",", "SGS2", ",", 
    RowBox[{"Max", "[", 
     RowBox[{
      RowBox[{"PermDeg", "@", "perm"}], ",", 
      RowBox[{"PermLength", "@", "SGS1"}], ",", 
      RowBox[{"PermLength", "@", "SGS2"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4991638907004004`*^9, 3.4991639211204*^9}, {
  3.620203137832495*^9, 3.6202031448425045`*^9}},
 CellLabel->
  "In[206]:=",ExpressionUUID->"1131dbe3-dd2c-49c8-86fe-cf31ae5df979"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sifting3", "[", 
   RowBox[{
   "perm_", ",", "SGS1_StrongGenSet", ",", "SGS2_StrongGenSet", ",", " ", 
    "len_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"base", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"First", "@", "SGS1"}], ",", 
         RowBox[{"Complement", "[", 
          RowBox[{
           RowBox[{"First", "@", "SGS2"}], ",", 
           RowBox[{"First", "@", "SGS1"}]}], "]"}]}], "]"}]}], ",", 
      "movedpoints", ",", "GS1", ",", "GS2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"movedpoints", ":=", 
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{"1", ",", 
          RowBox[{"PermDeg", "@", "perm"}]}], "]"}], ",", 
        RowBox[{"StablePoints", "@", "perm"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"base", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"movedpoints", ",", 
        RowBox[{"Complement", "[", 
         RowBox[{"base", ",", "movedpoints"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GS1", "=", 
      RowBox[{"Last", "@", 
       RowBox[{"BaseChange2", "[", 
        RowBox[{"SGS1", ",", "base"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"GS2", "=", 
      RowBox[{"Last", "@", 
       RowBox[{"BaseChange2", "[", 
        RowBox[{"SGS2", ",", "base"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"Sifting2", "[", 
      RowBox[{"perm", ",", "base", ",", "GS1", ",", "GS2", ",", "len"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4986680033302*^9, 3.4986681232005987`*^9}, {
   3.4986681691738*^9, 3.4986681884709997`*^9}, {3.4986682457386*^9, 
   3.4986682840053997`*^9}, {3.498668322350199*^9, 3.498668382067*^9}, {
   3.4986684437806*^9, 3.498668454045399*^9}, {3.4986688844962*^9, 
   3.4986689032318*^9}, {3.4986689349934*^9, 3.4986690613066*^9}, 
   3.4986691340493994`*^9, {3.4991638646172*^9, 3.4991638776276*^9}, {
   3.5115272750338116`*^9, 3.511527287810212*^9}, {3.603719618570448*^9, 
   3.603719628150461*^9}, {3.619615141767483*^9, 3.6196151440074863`*^9}, 
   3.620203154522518*^9},
 CellLabel->
  "In[207]:=",ExpressionUUID->"aeef05b9-18e9-4495-9cde-f1610f094b70"],

Cell["\<\
Check if - ID is in the product of the groups: (Improved 2014-09-14)\
\>", "Text",
 CellChangeTimes->{{3.4947591462558*^9, 3.4947591664578*^9}, 
   3.4947595109370003`*^9, {3.619688465446361*^9, 
   3.619688475246375*^9}},ExpressionUUID->"23008105-7e7e-4a1a-a74c-\
3f9f61ffaacf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MinusIDInProductQ", "[", 
   RowBox[{"H0_Symmetric", ",", "G0_Symmetric"}], "]"}], ":=", 
  "False"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567860974797649*^9, 3.56786099217708*^9}},
 CellLabel->
  "In[208]:=",ExpressionUUID->"e0fe0d26-c293-4ff6-9444-e254f1bd09fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MinusIDInProductQ", "[", 
   RowBox[{"H0_Antisymmetric", ",", "G0_Antisymmetric"}], "]"}], ":=", 
  "False"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567861000398294*^9, 3.567861006965906*^9}},
 CellLabel->
  "In[209]:=",ExpressionUUID->"a68c6aad-6c67-4fc4-b8ff-78036597f45e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MinusIDInProductQ", "[", 
   RowBox[{"H0_Symmetric", ",", "G0_Antisymmetric"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Length", "@", 
    RowBox[{"Intersection", "[", 
     RowBox[{
      RowBox[{"First", "@", "H0"}], ",", 
      RowBox[{"First", "@", "G0"}]}], "]"}]}], "\[GreaterEqual]", 
   "2"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567861020007529*^9, 3.5678610604584*^9}},
 CellLabel->
  "In[210]:=",ExpressionUUID->"e4f4622c-2ff5-4d60-ac44-3bd60cf28ef9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MinusIDInProductQ", "[", 
   RowBox[{"H0_Antisymmetric", ",", "G0_Symmetric"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Length", "@", 
    RowBox[{"Intersection", "[", 
     RowBox[{
      RowBox[{"First", "@", "H0"}], ",", 
      RowBox[{"First", "@", "G0"}]}], "]"}]}], "\[GreaterEqual]", 
   "2"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567861020007529*^9, 3.567861085870844*^9}},
 CellLabel->
  "In[211]:=",ExpressionUUID->"122ec667-ec1b-474c-bbf0-e20d3cbe4d4a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MinusIDInProductQ", "[", 
   RowBox[{"H0_StrongGenSet", ",", "G0_Symmetric"}], "]"}], ":=", 
  RowBox[{"Not", "@", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"sign", "/@", 
      RowBox[{"List", "@@", 
       RowBox[{"Stabilizer", "[", 
        RowBox[{
         RowBox[{"Complement", "[", 
          RowBox[{
           RowBox[{"GroupSupport", "@", "H0"}], ",", 
           RowBox[{"First", "@", "G0"}]}], "]"}], ",", 
         RowBox[{"H0", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567917538045489*^9, 3.5679175769831576`*^9}, {
   3.590313841717101*^9, 3.5903138474423122`*^9}, {3.619688106887763*^9, 
   3.619688107347763*^9}, {3.6196882845220594`*^9, 3.6196882932920723`*^9}, 
   3.6196883603721657`*^9},
 CellLabel->
  "In[212]:=",ExpressionUUID->"ad95d03f-197d-4faa-9fde-04b70899e1cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MinusIDInProductQ", "[", 
   RowBox[{"H0_Symmetric", ",", "G0_StrongGenSet"}], "]"}], ":=", 
  RowBox[{"Not", "@", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"sign", "/@", 
      RowBox[{"List", "@@", 
       RowBox[{"Stabilizer", "[", 
        RowBox[{
         RowBox[{"Complement", "[", 
          RowBox[{
           RowBox[{"GroupSupport", "@", "G0"}], ",", 
           RowBox[{"First", "@", "H0"}]}], "]"}], ",", 
         RowBox[{"G0", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567917538045489*^9, 3.567917632753255*^9}, {
   3.590313852652721*^9, 3.5903138582063313`*^9}, {3.619688136527804*^9, 
   3.6196881764419084`*^9}, {3.6196882873220634`*^9, 3.619688297042077*^9}, 
   3.61968836396217*^9},
 CellLabel->
  "In[213]:=",ExpressionUUID->"da89311d-8520-4d8a-8b20-2a4f9deeac7e"],

Cell["Old code for checking if -ID is in the product.", "Text",
 CellChangeTimes->{{3.590318115612808*^9, 
  3.590318138529248*^9}},ExpressionUUID->"e71b6ecf-8c77-4d8a-97ea-\
3e9879d144ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MinusIDInProductQold", "[", 
    RowBox[{"H0_StrongGenSet", ",", "G0_StrongGenSet"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"G1", ",", "H1"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Arrange", " ", "so", " ", "that", " ", "the", " ", "groups", " ", 
       "have", " ", "the", " ", "same", " ", "bases", " ", "and", " ", 
       "cycle", " ", "notation"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"H1", "=", 
       RowBox[{"BaseChange2", "[", 
        RowBox[{"H0", ",", 
         RowBox[{"First", "@", "G0"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"G1", "=", 
       RowBox[{"BaseChange2", "[", 
        RowBox[{"G0", ",", 
         RowBox[{"First", "@", "H1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Sifting2", "[", 
       RowBox[{
        RowBox[{"-", "ID"}], ",", 
        RowBox[{"G1", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"G1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"H1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"PermLength", "@", "G1"}], ",", 
          RowBox[{"PermLength", "@", "H1"}]}], "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4947588310889993`*^9, 3.4947590942609997`*^9}, {
  3.494759387775*^9, 3.4947594493326*^9}, {3.4947595870338*^9, 
  3.4947596309946*^9}, {3.5115273942022114`*^9, 3.5115274053562117`*^9}, {
  3.5118698534365997`*^9, 3.5118699111722*^9}, {3.5118699583778*^9, 
  3.5118699858182*^9}, {3.5118700342094*^9, 3.5118700576717997`*^9}, {
  3.5118730326542*^9, 3.5118730353529997`*^9}, {3.511875669413*^9, 
  3.5118756883046*^9}, {3.5678609586048203`*^9, 3.567860963472029*^9}, {
  3.590316148276753*^9, 3.590316148900754*^9}, {3.6037196346404705`*^9, 
  3.603719642710482*^9}, {3.619615147617492*^9, 3.6196151500774946`*^9}},
 CellLabel->
  "In[214]:=",ExpressionUUID->"26d103a2-f3de-4e56-b4f9-dd9d2a0f37d5"],

Cell["\<\
Slightly improved code. Now the Schreier vectors are only computed once. \
Changed 2013-10-09.\
\>", "Text",
 CellChangeTimes->{{3.590318115612808*^9, 
  3.590318184440129*^9}},ExpressionUUID->"8074450b-2fce-4478-90fa-\
2d0031b255fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MinusIDInProductQ", "[", 
    RowBox[{"H0_StrongGenSet", ",", "G0_StrongGenSet"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"G1", ",", "H1", ",", "n"}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"(*", " ", 
      RowBox[{
      "Arrange", " ", "so", " ", "that", " ", "the", " ", "groups", " ", 
       "have", " ", "the", " ", "same", " ", "base"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"H1", "=", 
       RowBox[{"BaseChange2", "[", 
        RowBox[{"H0", ",", 
         RowBox[{"First", "@", "G0"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"G1", "=", 
       RowBox[{"ReplacePart", "[", 
        RowBox[{"G0", ",", 
         RowBox[{"1", "\[Rule]", " ", 
          RowBox[{"First", "@", "H1"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"n", "=", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{"PermLength", "@", "G1"}], ",", 
         RowBox[{"PermLength", "@", "H1"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Sifting2b", "[", 
       RowBox[{
        RowBox[{"-", "ID"}], ",", 
        RowBox[{"G1", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "@", 
             RowBox[{"First", "@", "#"}]}], ",", "#", ",", "n"}], "]"}], 
          "&"}], "/@", 
         RowBox[{"(", 
          RowBox[{"Most", "@", 
           RowBox[{"StabilizerChain2", "[", "G1", "]"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "@", 
             RowBox[{"First", "@", "#"}]}], ",", "#", ",", "n"}], "]"}], 
          "&"}], "/@", 
         RowBox[{"(", 
          RowBox[{"Most", "@", 
           RowBox[{"StabilizerChain2", "[", "H1", "]"}]}], ")"}]}], ",", 
        "n"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4947588310889993`*^9, 3.4947590942609997`*^9}, {
   3.494759387775*^9, 3.4947594493326*^9}, {3.4947595870338*^9, 
   3.4947596309946*^9}, {3.5115273942022114`*^9, 3.5115274053562117`*^9}, {
   3.5118698534365997`*^9, 3.5118699111722*^9}, {3.5118699583778*^9, 
   3.5118699858182*^9}, {3.5118700342094*^9, 3.5118700576717997`*^9}, {
   3.5118730326542*^9, 3.5118730353529997`*^9}, {3.511875669413*^9, 
   3.5118756883046*^9}, {3.5678609586048203`*^9, 3.567860963472029*^9}, 
   3.590316166091984*^9, {3.5903162084772596`*^9, 3.590316243218519*^9}, {
   3.590316291797005*^9, 3.5903163234026604`*^9}, {3.601560729753213*^9, 
   3.601560731343215*^9}, {3.6037196509004936`*^9, 3.603719658070503*^9}, 
   3.6196151540675*^9},
 CellLabel->
  "In[215]:=",ExpressionUUID->"eeecb50f-049d-4dbf-943e-ba30e7fa8191"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MinusIDInProductQ", "[", 
   RowBox[{"H0_", ",", "G0_"}], "]"}], ":=", 
  RowBox[{"MinusIDInProductQ", "[", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "H0"}], ",", 
    RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "G0"}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.567861230280298*^9, 3.567861262962355*^9}},
 CellLabel->
  "In[216]:=",ExpressionUUID->"0abc15c3-d8e1-4e46-b63a-d09ce8e6e878"],

Cell["\<\
Old version of almost brute force search for the symmetry of the product of \
two groups.\
\>", "Text",
 CellChangeTimes->{{3.590317887774409*^9, 
  3.59031792320207*^9}},ExpressionUUID->"260015e5-4bcd-4ed0-b6be-\
183d1e7ea69f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GpinHGQBruteForceOld", "[", 
   RowBox[{"p_", ",", "G_", ",", "H_", ",", "n_", ",", "Gelements_"}], "]"}], 
  ":=", "\[IndentingNewLine]", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"Sifting2", "[", 
     RowBox[{"p", ",", 
      RowBox[{"First", "@", "G"}], ",", 
      RowBox[{"Last", "@", "G"}], ",", 
      RowBox[{"Last", "@", "H"}], ",", "n"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"TestList", "=", "Gelements"}], ",", "\[IndentingNewLine]", 
        RowBox[{"result", "=", "True"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Length", "[", "TestList", "]"}], ">", "0"}], ")"}], "&&",
           "result"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"result", "=", 
           RowBox[{"And", "@@", 
            RowBox[{"(", 
             RowBox[{"Sifting2", "[", 
              RowBox[{
               RowBox[{"PermProduct", "[", 
                RowBox[{
                 RowBox[{"First", "@", "TestList"}], ",", "p"}], "]"}], ",", 
               RowBox[{"First", "@", "G"}], ",", 
               RowBox[{"Last", "@", "G"}], ",", 
               RowBox[{"Last", "@", "H"}], ",", "n"}], "]"}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"TestList", "=", 
           RowBox[{"Rest", "@", "TestList"}]}], ";"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "result"}]}], "\[IndentingNewLine]", "]"}], ",",
     "\[IndentingNewLine]", "False"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4833397030982*^9, 3.4833397622222*^9}, {
   3.4833398049662*^9, 3.4833398342318*^9}, {3.4833399905906*^9, 
   3.4833400170638*^9}, {3.4833400653614006`*^9, 3.4833400658138*^9}, {
   3.4833401035346003`*^9, 3.4833401063582*^9}, {3.4833403505137997`*^9, 
   3.4833404172974*^9}, {3.4834263005954*^9, 3.4834263056186*^9}, {
   3.4834264146938*^9, 3.4834264149434*^9}, {3.4834265467946*^9, 
   3.483426556170201*^9}, {3.4834272015266*^9, 3.4834272518366013`*^9}, {
   3.4834272835046*^9, 3.4834273039874*^9}, {3.4834274363845997`*^9, 
   3.4834277055314007`*^9}, {3.4834277877434*^9, 3.4834278044354*^9}, {
   3.483428364335*^9, 3.483428475251*^9}, {3.4834325274602003`*^9, 
   3.4834325331542*^9}, {3.4834333523882*^9, 3.4834333565846*^9}, {
   3.4834334028386*^9, 3.4834334045546*^9}, {3.4834341701870008`*^9, 
   3.4834341724178*^9}, {3.4834587586734*^9, 3.4834587663954*^9}, {
   3.483622876859*^9, 3.4836228779780006`*^9}, {3.483623151273*^9, 
   3.483623153471*^9}, {3.483623222239001*^9, 3.483623308084*^9}, {
   3.483624076017*^9, 3.4836241290439997`*^9}, {3.483624165329*^9, 
   3.483624169527*^9}, {3.483625209723*^9, 3.483625265233*^9}, {
   3.483625353224*^9, 3.483625362497*^9}, {3.483625488035*^9, 
   3.483625504907*^9}, {3.483625851836*^9, 3.483625868936*^9}, {
   3.483625962185*^9, 3.483625984809*^9}, {3.483626024133*^9, 
   3.4836260646940002`*^9}, {3.483630616226*^9, 3.483630616607001*^9}, {
   3.4957018567304*^9, 3.4957018594604*^9}, {3.4957020137444*^9, 
   3.4957021052384*^9}, {3.4957022554508*^9, 3.4957022615192003`*^9}, {
   3.4957032498416*^9, 3.4957032779528*^9}, {3.4985687590030003`*^9, 
   3.4985687719978*^9}, {3.4985688041493998`*^9, 3.4985688223702*^9}, {
   3.4985688569242*^9, 3.498568870777*^9}, {3.4985689563585997`*^9, 
   3.4985689648761997`*^9}, {3.4985692060834*^9, 3.4985692179394*^9}, {
   3.4985693290738*^9, 3.4985693482618*^9}, {3.4986534353638*^9, 
   3.498653510197*^9}, {3.4986535484482*^9, 3.4986535528942003`*^9}, {
   3.4986535915198*^9, 3.4986536155906*^9}, 3.498653689363*^9, 
   3.4986539232693987`*^9, {3.5202576502862835`*^9, 3.520257653856288*^9}, {
   3.520258704757996*^9, 3.520258705647997*^9}, {3.5202677875802016`*^9, 
   3.520267791965409*^9}, 3.5678625886068835`*^9, {3.584177470824314*^9, 
   3.58417747413152*^9}, {3.590317822488293*^9, 3.590317822815894*^9}},
 CellLabel->
  "In[217]:=",ExpressionUUID->"4d785554-8444-469a-83cf-780606763d2d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryOfProductOfGroupsBruteForceOld", "[", 
   RowBox[{"G0_StrongGenSet", ",", "H0_StrongGenSet"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "G1", ",", "H1", ",", "permdeg", ",", "K1", ",", "F1", ",", " ", 
      "GElements", ",", " ", "unstablepoints", ",", "time"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Arrange", " ", "so", " ", "that", " ", "the", " ", "groups", " ", 
      "have", " ", "the", " ", "same", " ", "bases", " ", "and", " ", "cycle",
       " ", "notation"}], " ", "*)"}], "\[IndentingNewLine]", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<SymmetryOfProductOfGroupsBruteForce[\>\"", ",", "G0", ",", 
        "\"\<,\>\"", ",", "H0", ",", "\"\<]\>\""}], "]"}], ";"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "@", 
        RowBox[{"Last", "@", "H0"}]}], "===", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"G0", ",", "H0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"H1", "=", 
        RowBox[{"BaseChange2", "[", 
         RowBox[{"H0", ",", 
          RowBox[{"First", "@", "G0"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"G1", "=", 
        RowBox[{"BaseChange2", "[", 
         RowBox[{"G0", ",", 
          RowBox[{"First", "@", "H1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"permdeg", "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"Max", "@@", 
           RowBox[{"First", "[", "H1", "]"}]}], ",", 
          RowBox[{"PermDeg", "[", 
           RowBox[{"Last", "@", "G1"}], "]"}], ",", 
          RowBox[{"PermDeg", "[", 
           RowBox[{"Last", "@", "H1"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<H1: \>\"", ",", "H1"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<G1: \>\"", ",", "G1"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<permdeg: \>\"", ",", "permdeg"}], "]"}], ";"}], "*)"}],
        "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"GElements", "=", 
          RowBox[{"Rest", "[", 
           RowBox[{"List", "@@", 
            RowBox[{"Dimino", "[", "G1", "]"}]}], "]"}]}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "It", " ", "should", " ", "be", " ", "enough", " ", "to", " ", "test",
          " ", "one", " ", "from", " ", "each", " ", "coset", " ", 
         RowBox[{"H", ".", "p"}], " ", "where", " ", "p", " ", "is", " ", 
         "in", " ", "G"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"time", ",", "GElements"}], "}"}], "=", 
        RowBox[{"AbsoluteTiming", "@", 
         RowBox[{"Rest", "[", 
          RowBox[{"Union", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"First", "[", 
              RowBox[{"RightCosetRepresentative", "[", 
               RowBox[{"#", ",", "permdeg", ",", "H1"}], "]"}], "]"}], "&"}], 
            "/@", 
            RowBox[{"List", "@@", 
             RowBox[{"Dimino", "@", "G1"}]}]}], "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<GElements timing: \>\"", ",", "time", ",", " ", 
           "\"\< length: \>\"", ",", " ", 
           RowBox[{"Length", "@", "GElements"}]}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<GElements: \>\"", ",", "GElements"}], "]"}], ";"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"K1", "=", 
        RowBox[{"Search", "[", 
         RowBox[{"H1", ",", 
          RowBox[{
           RowBox[{"GpinHGQBruteForce", "[", 
            RowBox[{
            "#", ",", "G1", ",", "H1", ",", "permdeg", ",", "GElements"}], 
            "]"}], "&"}], ",", "1", ",", 
          RowBox[{"StrongGenSet", "[", 
           RowBox[{
            RowBox[{"{", "}"}], ",", 
            RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<K1: \>\"", ",", "K1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{"SchreierSims", "[", 
         RowBox[{
          RowBox[{"Range", "@", "permdeg"}], ",", 
          RowBox[{"Join", "[", 
           RowBox[{
            RowBox[{"Last", "@", "K1"}], ",", 
            RowBox[{"Last", "@", "G1"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{"DeleteSomeRedundantGenerators", "[", "F1", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"unstablepoints", "=", 
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"Range", "@", "permdeg"}], ",", 
          RowBox[{"StablePoints", "[", 
           RowBox[{
            RowBox[{"Last", "@", "F1"}], ",", "permdeg"}], "]"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{"ReplacePart", "[", 
         RowBox[{"F1", ",", 
          RowBox[{"1", "->", "unstablepoints"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<F1: \>\"", ",", "F1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"F1", ",", "K1"}], "}"}]}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5202649159853115`*^9, 3.5202649336853366`*^9}, {
   3.5202669450034094`*^9, 3.520266947553414*^9}, {3.520267054841965*^9, 
   3.520267103824834*^9}, {3.520267216146194*^9, 3.5202672207517996`*^9}, 
   3.520267698916477*^9, 3.5202682041317883`*^9, {3.520268241959441*^9, 
   3.520268294615115*^9}, {3.5202684758505707`*^9, 3.5202684788021755`*^9}, {
   3.520268986767299*^9, 3.520269063468208*^9}, {3.520311980974537*^9, 
   3.5203120754382706`*^9}, {3.524976308576508*^9, 3.524976312195714*^9}, {
   3.534068517338497*^9, 3.5340685232197065`*^9}, {3.5354545901829443`*^9, 
   3.53545460528377*^9}, 3.566218186248101*^9, {3.5678643629082007`*^9, 
   3.567864371410215*^9}, {3.590317827121502*^9, 3.590317827417902*^9}, {
   3.6037196676605177`*^9, 3.603719672470523*^9}, {3.6196151568575044`*^9, 
   3.6196151588175077`*^9}},
 CellLabel->
  "In[218]:=",ExpressionUUID->"ee400d86-1ba6-4279-8f1e-024ad939cb7f"],

Cell["\<\
Newer version where the Schreier vectors are computed only once. Changed \
2013-10-09. This is still not efficient, so a new algorithm is needed.\
\>", "Text",
 CellChangeTimes->{{3.59031792881808*^9, 
  3.5903180529474993`*^9}},ExpressionUUID->"64cd6bc8-769b-46f8-bdb1-\
8f5f64f6b023"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GpinHGQBruteForce", "[", 
   RowBox[{
   "p_", ",", "base_", ",", "StabChainSchOrbG_", ",", "StabChainSchOrbH_", 
    ",", "n_", ",", "Gelements_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"xAct`SymManipulator`Private`Sifting2b", "[", 
     RowBox[{
     "p", ",", "base", ",", "StabChainSchOrbG", ",", "StabChainSchOrbH", ",", 
      "n"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"TestList", "=", "Gelements"}], ",", "\[IndentingNewLine]", 
        RowBox[{"result", "=", "True"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Length", "[", "TestList", "]"}], ">", "0"}], ")"}], "&&",
           "result"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"result", "=", 
           RowBox[{"xAct`SymManipulator`Private`Sifting2b", "[", 
            RowBox[{
             RowBox[{"PermProduct", "[", 
              RowBox[{
               RowBox[{"First", "@", "TestList"}], ",", "p"}], "]"}], ",", 
             "base", ",", "StabChainSchOrbG", ",", "StabChainSchOrbH", ",", 
             "n"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"TestList", "=", 
           RowBox[{"Rest", "@", "TestList"}]}], ";"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "result"}]}], "\[IndentingNewLine]", "]"}], ",",
     "\[IndentingNewLine]", "False"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590317839507923*^9, 3.590317839929124*^9}},
 CellLabel->
  "In[219]:=",ExpressionUUID->"a22031f3-1f98-4c13-bfd3-455e1eaba373"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryOfProductOfGroupsBruteForce", "[", 
   RowBox[{"G0_StrongGenSet", ",", "H0_StrongGenSet"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "G1", ",", "H1", ",", "permdeg", ",", "K1", ",", "F1", ",", " ", 
      "GElements", ",", " ", "unstablepoints", ",", "time", ",", 
      "StabChainSchOrbG", ",", " ", "StabChainSchOrbH"}], " ", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Arrange", " ", "so", " ", "that", " ", "the", " ", "groups", " ", 
      "have", " ", "the", " ", "same", " ", "bases", " ", "and", " ", "cycle",
       " ", "notation"}], " ", "*)"}], "\[IndentingNewLine]", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<SymmetryOfProductOfGroupsBruteForce[\>\"", ",", "G0", ",", 
        "\"\<,\>\"", ",", "H0", ",", "\"\<]\>\""}], "]"}], ";"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "@", 
        RowBox[{"Last", "@", "H0"}]}], "===", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"G0", ",", "H0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"H1", "=", 
        RowBox[{"BaseChange2", "[", 
         RowBox[{"H0", ",", 
          RowBox[{"First", "@", "G0"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"G1", "=", 
        RowBox[{"ReplacePart", "[", 
         RowBox[{"G0", ",", 
          RowBox[{"1", "\[Rule]", " ", 
           RowBox[{"First", "@", "H1"}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"permdeg", "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"Max", "@@", 
           RowBox[{"First", "[", "H1", "]"}]}], ",", 
          RowBox[{"PermDeg", "[", 
           RowBox[{"Last", "@", "G1"}], "]"}], ",", 
          RowBox[{"PermDeg", "[", 
           RowBox[{"Last", "@", "H1"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"StabChainSchOrbG", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "@", 
             RowBox[{"First", "@", "#"}]}], ",", "#", ",", "permdeg"}], "]"}],
           "&"}], "/@", 
         RowBox[{"(", 
          RowBox[{"Most", "@", 
           RowBox[{"StabilizerChain2", "[", "G1", "]"}]}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"StabChainSchOrbH", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "@", 
             RowBox[{"First", "@", "#"}]}], ",", "#", ",", "permdeg"}], "]"}],
           "&"}], "/@", 
         RowBox[{"(", 
          RowBox[{"Most", "@", 
           RowBox[{"StabilizerChain2", "[", "H1", "]"}]}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<H1: \>\"", ",", "H1"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<G1: \>\"", ",", "G1"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<permdeg: \>\"", ",", "permdeg"}], "]"}], ";"}], "*)"}],
        "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"GElements", "=", 
          RowBox[{"Rest", "[", 
           RowBox[{"List", "@@", 
            RowBox[{"Dimino", "[", "G1", "]"}]}], "]"}]}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "It", " ", "should", " ", "be", " ", "enough", " ", "to", " ", "test",
          " ", "one", " ", "from", " ", "each", " ", "coset", " ", 
         RowBox[{"H", ".", "p"}], " ", "where", " ", "p", " ", "is", " ", 
         "in", " ", "G"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"time", ",", "GElements"}], "}"}], "=", 
        RowBox[{"AbsoluteTiming", "@", 
         RowBox[{"Rest", "[", 
          RowBox[{"Union", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"First", "[", 
              RowBox[{"RightCosetRepresentative", "[", 
               RowBox[{"#", ",", "permdeg", ",", "H1"}], "]"}], "]"}], "&"}], 
            "/@", 
            RowBox[{"List", "@@", 
             RowBox[{"Dimino", "@", "G1"}]}]}], "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<GElements timing: \>\"", ",", "time", ",", " ", 
           "\"\< length: \>\"", ",", " ", 
           RowBox[{"Length", "@", "GElements"}]}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<GElements: \>\"", ",", "GElements"}], "]"}], ";"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"K1", "=", 
        RowBox[{"Search", "[", 
         RowBox[{"H1", ",", 
          RowBox[{
           RowBox[{"GpinHGQBruteForce", "[", 
            RowBox[{"#", ",", 
             RowBox[{"First", "@", "G1"}], ",", "StabChainSchOrbG", ",", 
             "StabChainSchOrbH", ",", "permdeg", ",", "GElements"}], "]"}], 
           "&"}], ",", "1", ",", 
          RowBox[{"StrongGenSet", "[", 
           RowBox[{
            RowBox[{"{", "}"}], ",", 
            RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<K1: \>\"", ",", "K1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{"SchreierSims", "[", 
         RowBox[{
          RowBox[{"Range", "@", "permdeg"}], ",", 
          RowBox[{"Join", "[", 
           RowBox[{
            RowBox[{"Last", "@", "K1"}], ",", 
            RowBox[{"Last", "@", "G1"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{
        "xAct`SymManipulator`Private`DeleteSomeRedundantGenerators", "[", 
         "F1", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"unstablepoints", "=", 
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"Range", "@", "permdeg"}], ",", 
          RowBox[{"StablePoints", "[", 
           RowBox[{
            RowBox[{"Last", "@", "F1"}], ",", "permdeg"}], "]"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{"ReplacePart", "[", 
         RowBox[{"F1", ",", 
          RowBox[{"1", "->", "unstablepoints"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<F1: \>\"", ",", "F1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"F1", ",", "K1"}], "}"}]}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590317875200786*^9, 3.5903178756063876`*^9}, {
   3.5903182001181564`*^9, 3.590318200430157*^9}, {3.601560740683228*^9, 
   3.601560742283231*^9}, 3.603719679410533*^9, 3.619615161667511*^9},
 CellLabel->
  "In[220]:=",ExpressionUUID->"e7d7a539-7b68-435c-9ec6-9ee8e8d66de3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryOfProductOfGroupsBruteForce", "[", 
   RowBox[{"G0_", ",", "H0_"}], "]"}], ":=", 
  RowBox[{"SymmetryOfProductOfGroupsBruteForce", "[", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "G0"}], ",", 
    RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "H0"}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.5678654570171227`*^9, 3.567865488934778*^9}},
 CellLabel->
  "In[221]:=",ExpressionUUID->"b220f4b6-fac4-4b0b-8849-79e6a17d793e"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.8. Transversals", "Subsubsection",
 CellChangeTimes->{{3.533455997913866*^9, 3.533456008459484*^9}, {
   3.534248408326805*^9, 3.534248409450007*^9}, 3.534249620620534*^9, 
   3.566218151163639*^9},ExpressionUUID->"bbb9d274-a984-4905-8a25-\
a24709b31e7f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SchreierTransversal", "[", 
   RowBox[{"x_", ",", "base_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"TraceSchreier", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], "/@", 
   RowBox[{"(", 
    RowBox[{"SortB", "[", 
     RowBox[{
      RowBox[{"First", "@", "x"}], ",", "base"}], "]"}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.572174732257642*^9, {3.57217489070712*^9, 3.57217490164274*^9}, 
   3.572175084865061*^9},
 CellLabel->
  "In[222]:=",ExpressionUUID->"31ab7c54-7392-4680-b806-c46a88280c46"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SchreierTransversals", "[", "SGS_", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Gchain", "=", 
       RowBox[{"StabilizerChain2", "@", "SGS"}]}], ",", "SchreierOrbits1"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SchreierOrbits1", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"SchreierOrbit", "[", 
         RowBox[{
          RowBox[{"Gchain", "[", 
           RowBox[{"[", 
            RowBox[{"#", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"Gchain", "[", 
           RowBox[{"[", "#", "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"PermLength", "@", 
           RowBox[{"Gchain", "[", 
            RowBox[{"[", "#", "]"}], "]"}]}]}], "]"}], "&"}], "/@", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"Length", "[", "Gchain", "]"}], "-", "1"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"SchreierTransversal", "[", 
        RowBox[{"#", ",", 
         RowBox[{"First", "@", "SGS"}]}], "]"}], "&"}], "/@", 
      "SchreierOrbits1"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.572174661636318*^9, {3.572174733334043*^9, 3.57217475370768*^9}, {
   3.5721749071495485`*^9, 3.5721749103319545`*^9}, {3.5721749881136913`*^9, 
   3.5721749921384983`*^9}, {3.572175088499867*^9, 3.572175091417073*^9}, 
   3.572175178340425*^9, 3.601560748723239*^9},
 CellLabel->
  "In[223]:=",ExpressionUUID->"e89d701c-92db-471d-8361-dba400574d2c"],

Cell["\<\
The following algorithm is taken from \[OpenCurlyDoubleQuote]Handbook of \
computational group theory\[CloseCurlyDoubleQuote] by Derek F. Holt page 128.
This implementation has to be verified (does it produce the correct thing \
even if the base is not sorted?):\
\>", "Text",
 CellChangeTimes->{{3.534248771011842*^9, 3.534248783008263*^9}, {
  3.53425292593176*^9, 3.5342529771778507`*^9}, {3.5342530181591225`*^9, 
  3.534253018408723*^9}, {3.534253074147621*^9, 3.534253090496449*^9}, {
  3.5681243041726913`*^9, 
  3.5681243236883245`*^9}},ExpressionUUID->"0acdecbb-669d-400e-832c-\
53e4224a057e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TransversalComputation", "[", 
   RowBox[{"H0_", ",", "G0_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"base", "=", 
       RowBox[{"First", "@", "G0"}]}], ",", 
      RowBox[{"baselength", "=", 
       RowBox[{"Length", "@", 
        RowBox[{"First", "@", "G0"}]}]}], ",", 
      RowBox[{"StabChainG0", "=", 
       RowBox[{"StabilizerChain2", "@", "G0"}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"StabChainH0", "=", 
       RowBox[{"StabilizerChain2", "@", "H0"}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"STransG0", "=", 
       RowBox[{"SchreierTransversals", "@", "G0"}]}], ",", 
      "\[IndentingNewLine]", "TransversalLengths", ",", "RestBaseOrbitsH", 
      ",", "TList", ",", "TBar", ",", "i", ",", "j", ",", "Checku", ",", 
      "ElementsNeeded"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Checku", "[", 
       RowBox[{"u_", ",", "n_"}], "]"}], ":=", "\[IndentingNewLine]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"tuList", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"PermProduct", "[", 
              RowBox[{"#", ",", "u"}], "]"}], "&"}], "/@", "TList"}]}], ",", 
          RowBox[{"FirstBaseImageUnderu", "=", 
           RowBox[{"OnPoints", "[", 
            RowBox[{
             RowBox[{"StabChainH0", "[", 
              RowBox[{"[", 
               RowBox[{"n", ",", "1", ",", "1"}], "]"}], "]"}], ",", "u"}], 
            "]"}]}], ",", "\[IndentingNewLine]", "SelectionList"}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<Checku[\>\"", ",", "u", ",", "\"\<,\>\"", ",", "n", ",", 
            "\"\<]\>\""}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SelectionList", "=", 
          RowBox[{"And", "@@@", 
           RowBox[{"Outer", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Not", "[", 
               RowBox[{"xAct`xPerm`Private`LessB", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"OnPoints", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}], ",", 
                   "FirstBaseImageUnderu"}], "}"}], ",", "base"}], "]"}], 
               "]"}], "&"}], ",", "tuList", ",", 
             RowBox[{"RestBaseOrbitsH", "[", 
              RowBox[{"[", "n", "]"}], "]"}]}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"\"\<SelectionList:\>\"", ",", "SelectionList"}], "]"}], 
           ";"}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Pick", "[", 
          RowBox[{"tuList", ",", "SelectionList"}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"TransversalLengths", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"OrderOfGroup", "[", 
           RowBox[{"StabChainG0", "[", 
            RowBox[{"[", "#", "]"}], "]"}], "]"}], "/", 
          RowBox[{"OrderOfGroup", "[", 
           RowBox[{"StabChainH0", "[", 
            RowBox[{"[", "#", "]"}], "]"}], "]"}]}], ")"}], "&"}], "/@", 
       RowBox[{"Range", "[", 
        RowBox[{"baselength", "+", "1"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"RestBaseOrbitsH", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Rest", "@", 
         RowBox[{"Orbit", "[", 
          RowBox[{
           RowBox[{"StabChainH0", "[", 
            RowBox[{"[", 
             RowBox[{"#", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"StabChainH0", "[", 
            RowBox[{"[", "#", "]"}], "]"}]}], "]"}]}], "&"}], "/@", 
       RowBox[{"Range", "[", "baselength", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TList", "=", 
      RowBox[{"{", "ID", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"i", "=", "baselength"}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", "\[GreaterEqual]", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"TBar", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"j", "=", "2"}], ";", "\[IndentingNewLine]", 
        RowBox[{"ElementsNeeded", "=", 
         RowBox[{
          RowBox[{"TransversalLengths", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "-", 
          RowBox[{"Length", "[", "TList", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "TBar", "]"}], "<", "ElementsNeeded"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"j", "\[LessEqual]", 
             RowBox[{"Length", "[", 
              RowBox[{"STransG0", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}]}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"TBar", "=", 
            RowBox[{"Join", "[", 
             RowBox[{"TBar", ",", 
              RowBox[{"Checku", "[", 
               RowBox[{
                RowBox[{"STransG0", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", "i"}], "]"}]}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"j", "=", 
            RowBox[{"j", "+", "1"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"TList", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"TList", ",", "TBar"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"i", "=", 
         RowBox[{"i", "-", "1"}]}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "TList"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5336384347746363`*^9, 3.533638469890298*^9}, {
   3.5336385369860168`*^9, 3.533638664968641*^9}, {3.533638736978367*^9, 
   3.5336388496261654`*^9}, {3.533638888797834*^9, 3.533638932852311*^9}, {
   3.533638997686025*^9, 3.533639030726883*^9}, {3.5336390780573673`*^9, 
   3.5336391395214744`*^9}, {3.533639214854007*^9, 3.533639430165584*^9}, {
   3.5336394959197*^9, 3.5336395426105833`*^9}, {3.533639598677081*^9, 
   3.533639676084417*^9}, {3.5336397163636875`*^9, 3.533639722666099*^9}, {
   3.5336397539285536`*^9, 3.533639795206227*^9}, {3.5336398326462917`*^9, 
   3.533640063011896*^9}, {3.533640134506822*^9, 3.533640144350439*^9}, {
   3.533640193724526*^9, 3.5336402402594075`*^9}, {3.53364027624867*^9, 
   3.533640424246131*^9}, {3.533640490483847*^9, 3.533640501637867*^9}, {
   3.533640533087522*^9, 3.5336407418782887`*^9}, {3.533640773203143*^9, 
   3.533640785948366*^9}, 3.53397092011306*^9, {3.53397120484476*^9, 
   3.533971220351188*^9}, {3.533971291783713*^9, 3.533971316650157*^9}, 
   3.5678625886068835`*^9, {3.6015607561632495`*^9, 3.601560764313261*^9}},
 CellLabel->
  "In[224]:=",ExpressionUUID->"b1586311-ef93-4639-b98f-d7991e792147"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TransversalInSymmetricGroup", "[", 
   RowBox[{"H0_StrongGenSet", ",", "G0_Symmetric"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"suppH0", "=", 
       RowBox[{"GroupSupport", "@", "H0"}]}], ",", "H0partofbase", ",", " ", 
      "newbase", ",", "G1"}], "}"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Not", "@", 
        RowBox[{"subsetQ", "[", 
         RowBox[{"suppH0", ",", 
          RowBox[{"First", "@", "G0"}]}], "]"}]}], ",", 
       RowBox[{"Throw", "[", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"General", "::", "error"}], ",", 
          "\"\<TransversalInSymmetricGroup: Not a subgroup.\>\""}], "]"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Arrange", " ", "so", " ", "both", " ", "groups", " ", "have", " ", 
       "the", " ", "same", " ", 
       RowBox[{"base", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Elliminate", " ", "points", " ", "in", " ", "the", " ", "base", " ", 
       "that", " ", "is", " ", "not", " ", "in", " ", 
       RowBox[{"G0", "."}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"H0partofbase", "=", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"First", "@", "H0"}], ",", 
        RowBox[{
         RowBox[{"Not", "@", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"#", ",", 
            RowBox[{"First", "@", "G0"}]}], "]"}]}], "&"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"construct", " ", "the", " ", "new", " ", 
       RowBox[{"base", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"newbase", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"H0partofbase", ",", 
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"First", "@", "G0"}], ",", "H0partofbase"}], "]"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Construct", " ", "symmetric", " ", "group", " ", "with", " ", 
       "correct", " ", 
       RowBox[{"base", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"G1", "=", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"newbase", ",", 
        RowBox[{"GenSet", "@@", 
         RowBox[{"(", 
          RowBox[{"Cycles", "/@", 
           RowBox[{"Partition", "[", 
            RowBox[{
             RowBox[{"DeleteCases", "[", 
              RowBox[{"newbase", ",", 
               RowBox[{
                RowBox[{"Not", "@", 
                 RowBox[{"MemberQ", "[", 
                  RowBox[{"#", ",", 
                   RowBox[{"First", "@", "G0"}]}], "]"}]}], "&"}]}], "]"}], 
             ",", "2", ",", "1"}], "]"}]}], ")"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Compute", " ", "the", " ", 
       RowBox[{"transversal", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"TransversalComputation", "[", 
      RowBox[{
       RowBox[{"ReplacePart", "[", 
        RowBox[{"H0", ",", 
         RowBox[{"1", "\[Rule]", "newbase"}]}], "]"}], ",", "G1"}], "]"}]}]}],
    "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5679261093169436`*^9, 3.567926125182172*^9}, {
   3.568124784981135*^9, 3.568124922761578*^9}, {3.5721754164748425`*^9, 
   3.5721754244776573`*^9}, {3.572175548763076*^9, 3.5721755735515194`*^9}, {
   3.5721756044249735`*^9, 3.5721756771835003`*^9}, {3.572175859547821*^9, 
   3.572175898891091*^9}, {3.572175929498344*^9, 3.572175950558381*^9}, {
   3.572176007077281*^9, 3.5721760427701435`*^9}, {3.572176077059004*^9, 
   3.572176159926349*^9}, {3.572176213418843*^9, 3.5721762269752674`*^9}, {
   3.572176258284522*^9, 3.5721765002409472`*^9}, {3.57217713399306*^9, 
   3.572177155372699*^9}, 3.615129448988925*^9},
 CellLabel->
  "In[225]:=",ExpressionUUID->"64a39f21-dd29-4949-8cbf-6a77f70188d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TransversalInCompatibleSymmGroup", "[", 
   RowBox[{"H0_StrongGenSet", ",", "G0_Symmetric"}], "]"}], ":=", 
  RowBox[{"TransversalInSymmetricGroup", "[", 
   RowBox[{"H0", ",", "G0"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.584882065724975*^9, 3.584882080623001*^9}},
 CellLabel->
  "In[226]:=",ExpressionUUID->"70b035f2-c213-472b-8150-96006427a535"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TransversalInCompatibleSymmGroup", "[", 
   RowBox[{"H0_StrongGenSet", ",", "G0_StrongGenSet"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"suppH0", "=", 
       RowBox[{"GroupSupport", "@", "H0"}]}], ",", 
      RowBox[{"suppG0", "=", 
       RowBox[{"GroupSupport", "@", "G0"}]}], ",", "H0partofbase", ",", " ", 
      "newbase", ",", "G1"}], "}"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Not", "@", 
        RowBox[{"subsetQ", "[", 
         RowBox[{"suppH0", ",", "suppG0"}], "]"}]}], ",", 
       RowBox[{"Throw", "[", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"General", "::", "error"}], ",", 
          "\"\<TransversalInCompatibleSymmGroup: Not a subgroup.\>\""}], 
         "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Arrange", " ", "so", " ", "both", " ", "groups", " ", "have", " ", 
       "the", " ", "same", " ", 
       RowBox[{"base", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Elliminate", " ", "points", " ", "in", " ", "the", " ", "base", " ", 
       "that", " ", "is", " ", "not", " ", "in", " ", 
       RowBox[{"G0", "."}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"H0partofbase", "=", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"First", "@", "H0"}], ",", 
        RowBox[{
         RowBox[{"Not", "@", 
          RowBox[{"MemberQ", "[", 
           RowBox[{"#", ",", "suppG0"}], "]"}]}], "&"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"construct", " ", "the", " ", "new", " ", 
       RowBox[{"base", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"newbase", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"H0partofbase", ",", 
        RowBox[{"Complement", "[", 
         RowBox[{"suppG0", ",", "H0partofbase"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Construct", " ", "symmetric", " ", "group", " ", "with", " ", 
       "correct", " ", 
       RowBox[{"base", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"G1", "=", 
      RowBox[{"BaseChange2", "[", 
       RowBox[{"G0", ",", "newbase"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Compute", " ", "the", " ", 
       RowBox[{"transversal", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"TransversalComputation", "[", 
      RowBox[{
       RowBox[{"ReplacePart", "[", 
        RowBox[{"H0", ",", 
         RowBox[{"1", "\[Rule]", "newbase"}]}], "]"}], ",", "G1"}], "]"}]}]}],
    "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.584881781913677*^9, 3.584881953201978*^9}, 
   3.603719686301543*^9, 3.615129458578939*^9, 3.619615165997517*^9},
 CellLabel->
  "In[227]:=",ExpressionUUID->"1ee357d8-ecf4-4e78-b20d-a224eeefe53e"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Definition of Sym and development of some tools", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"518de499-a550-4803-a058-f514b8dd2809"],

Cell[CellGroupData[{

Cell["3.1. Definition of ZeroTensor and deltaH", "Subsubsection",
 CellChangeTimes->{{3.537696815956587*^9, 
  3.5376968188425927`*^9}},ExpressionUUID->"f12debb5-7444-4b6d-a5d5-\
f2a3c3386e1f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], "]"}], "^:=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], "]"}], "^:=", 
   "\"\<0\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`TexAct`Tex", "[", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], "]"}], "^:=", 
   "\"\<0\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], "]"}], "^:=", "slotlist"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"\"\<tensor\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<ZeroTensor with slots \>\"", ",", 
       RowBox[{"ToString", "/@", "slotlist"}], ",", "\"\< .\>\""}], "]"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{"ZeroTensor", "[", "slotlist_List", "]"}], "]"}], "^:=", 
  RowBox[{"ZeroTensor", "[", 
   RowBox[{"Dagger", "/@", "slotlist"}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.480405644895*^9, 3.4804056452226*^9}, {
   3.480419176029559*^9, 3.480419264116117*^9}, {3.4806765820919*^9, 
   3.4806765835271*^9}, {3.480749135709*^9, 3.4807491391097994`*^9}, {
   3.4807693525154*^9, 3.4807693590362*^9}, {3.4808326215861998`*^9, 
   3.480832636999*^9}, {3.4947526533174*^9, 3.4947526897902*^9}, {
   3.515748953542741*^9, 3.515748954151776*^9}, {3.5173849480594406`*^9, 
   3.517385172699835*^9}, {3.6070762126854134`*^9, 3.607076213055413*^9}, {
   3.839129758869109*^9, 3.839129761816677*^9}, 3.83912987339847*^9},
 CellLabel->
  "In[228]:=",ExpressionUUID->"812e449d-efae-437c-bd62-b0474630d409"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], "[", "___", "]"}], ":=", 
  "0"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5173851794702463`*^9, 3.517385186318659*^9}},
 CellLabel->
  "In[237]:=",ExpressionUUID->"ceda08e7-76ec-4834-8e68-5e4d6bdbef97"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TensorToZeroRule", "[", 
   RowBox[{"T_", "?", "xTensorQ"}], "]"}], ":=", 
  RowBox[{"T", "\[Rule]", 
   RowBox[{"ZeroTensor", "[", 
    RowBox[{"SlotsOfTensor", "@", "T"}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5174724384498982`*^9, 3.5174724790099707`*^9}, {
  3.5174728525994267`*^9, 3.517472853129827*^9}},
 CellLabel->
  "In[238]:=",ExpressionUUID->"a76d8e80-a45c-49b8-84bc-784812704e04"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"deltaH", "[", "vbundle_", "]"}], "]"}], "^:=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"deltaH", "[", "vbundle_", "]"}], "]"}], "^:=", 
   "\"\<\[Delta]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"deltaH", "[", "vbundle_", "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "vbundle"}], ",", "vbundle"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"deltaH", "[", "vbundle_", "]"}], "]"}], "^=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"deltaH", "[", "vbundle_", "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"deltaH", "[", "vbundle_", "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"\"\<tensor\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\< delta on \>\"", ",", 
       RowBox[{"ToString", "/@", "vbundle"}], ",", "\"\< .\>\""}], "]"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", 
    RowBox[{"deltaH", "[", "vbundle_", "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"deltaH", "[", "vbundle_", "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.53769688609431*^9, 3.537696916592364*^9}},
 CellLabel->
  "In[239]:=",ExpressionUUID->"cb19843f-37bf-453b-b76a-07676ede369f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"deltaHTodelta", "=", 
   RowBox[{
    RowBox[{"deltaH", "[", "vbundle_", "]"}], "\[RuleDelayed]", "delta"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[247]:=",ExpressionUUID->"43e46ded-b4ce-4693-ad16-6dec8529c54c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MetricOrdeltaHOfVBundle", "[", "vbundle_", "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"metrics", "=", 
       RowBox[{"MetricsOfVBundle", "[", "vbundle", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", "metrics"}], ">", "0"}], ",", 
       RowBox[{"First", "@", "metrics"}], ",", 
       RowBox[{"deltaH", "[", "vbundle", "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5376966898771653`*^9, 3.537696797252155*^9}, {
  3.537697049677198*^9, 3.5376970509564*^9}},
 CellLabel->
  "In[248]:=",ExpressionUUID->"628062b9-8bea-4a9e-b4f2-2b20e8f8a622"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. Definition of the SymH object", "Subsubsection",ExpressionUUID->"63c64ae1-2bae-4af1-8ea4-39eca175aa59"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"nosign", "[", 
    RowBox[{"-", "x_"}], "]"}], ":=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nosign", "[", "x_", "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sign", "[", 
    RowBox[{"-", "x_"}], "]"}], ":=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sign", "[", "x_", "]"}], ":=", "1"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4976170963964*^9, 3.4976171135095997`*^9}, {
  3.497617560387201*^9, 3.497617568608401*^9}},
 CellLabel->
  "In[249]:=",ExpressionUUID->"e5ef4881-0d2f-4093-80c9-2ea5208caca7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"slot", "=", "xAct`xTensor`Private`slot"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[253]:=",ExpressionUUID->"32ec2bef-636f-4de4-b3c1-5952f5025a76"],

Cell["The SymH symbol is a place holder for ImposeSymmetry.", "Text",
 CellChangeTimes->{{3.4803239314096003`*^9, 3.4803240225916*^9}, {
   3.480337706904462*^9, 3.48033770694394*^9}, 3.480337741610383*^9, {
   3.480338124057756*^9, 3.480338146894411*^9}, {3.480419460085125*^9, 
   3.480419460323116*^9}, 3.4807491331506*^9, {3.515748898655601*^9, 
   3.515748907570111*^9}, 
   3.5445905296668634`*^9},ExpressionUUID->"d2e034c3-67d2-401d-9dd7-\
8748adedc041"],

Cell["First general definition of the SymH symbol.", "Text",
 CellChangeTimes->{{3.480682435784199*^9, 3.480682477249*^9}, {
   3.4807491341958*^9, 3.4807491346326*^9}, {3.4808453206726*^9, 
   3.480845335944999*^9}, 3.51574889128718*^9, 
   3.5445905349641657`*^9},ExpressionUUID->"915af5fd-44db-4479-bf67-\
18b0145f44f9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], "^:=", 
   "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"UnderscriptBox", "[", 
       RowBox[{"\"\<Sym\>\"", ",", 
        RowBox[{"StyleBox", "[", 
         RowBox[{"label", ",", "Tiny"}], "]"}]}], "]"}], ",", "\"\<[\>\"", 
      ",", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"(", 
        RowBox[{"PrintAs", "/@", "headlist"}], ")"}]}], ",", "\"\<]\>\""}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], "^:=", 
   RowBox[{"Join", "@@", 
    RowBox[{"(", 
     RowBox[{"SlotsOfTensor", "/@", "headlist"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], "^:=", 
   RowBox[{"Union", "@@", 
    RowBox[{"(", 
     RowBox[{"DependenciesOfTensor", "/@", "headlist"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DefInfo", "[", 
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], "^:=", 
    
    RowBox[{"{", 
     RowBox[{"\"\<tensor\>\"", ",", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"\"\<Symmetrized \>\"", ",", 
        RowBox[{"Sequence", "@@", 
         RowBox[{"(", 
          RowBox[{"ToString", "/@", "headlist"}], ")"}]}], ",", 
        "\"\< .\>\""}], "]"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"JMM", ":", " ", 
     RowBox[{
     "These", " ", "two", " ", "should", " ", "also", " ", "be", " ", 
      "generalized"}]}], ",", " ", 
    RowBox[{
    "but", " ", "are", " ", "not", " ", "relevant", " ", "for", " ", "us"}]}],
    " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", 
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.480405644895*^9, 3.4804056452226*^9}, {
  3.480419176029559*^9, 3.480419264116117*^9}, {3.4806765820919*^9, 
  3.4806765835271*^9}, {3.480749135709*^9, 3.4807491391097994`*^9}, {
  3.4807693525154*^9, 3.4807693590362*^9}, {3.4808326215861998`*^9, 
  3.480832636999*^9}, {3.4947526533174*^9, 3.4947526897902*^9}, {
  3.515748953542741*^9, 3.515748954151776*^9}},
 CellLabel->
  "In[254]:=",ExpressionUUID->"88649843-0f8e-4d36-b5f2-0dd53d02d5b9"],

Cell["\<\
If the ZeroTensor appears in the headlist, the entire object is a ZeroTensor.\
\
\>", "Text",
 CellChangeTimes->{{3.517385444935913*^9, 
  3.517385479255973*^9}},ExpressionUUID->"2785d42b-b926-4015-b5f4-\
fbc12e6e2188"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymH", "[", 
   RowBox[{
    RowBox[{"headlist", ":", 
     RowBox[{"{", 
      RowBox[{"___", ",", 
       RowBox[{"ZeroTensor", "[", "_", "]"}], ",", "___"}], "}"}]}], ",", 
    "sym_", ",", "label_"}], "]"}], ":=", 
  RowBox[{"ZeroTensor", "[", 
   RowBox[{"Join", "@@", 
    RowBox[{"(", 
     RowBox[{"SlotsOfTensor", "/@", "headlist"}], ")"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5173852718068085`*^9, 3.5173854379315004`*^9}, {
  3.51738551713284*^9, 3.517385518224841*^9}, {3.517472297706452*^9, 
  3.5174723026360607`*^9}},
 CellLabel->
  "In[261]:=",ExpressionUUID->"ace14c25-3476-4286-867d-fb04fd8803ed"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. Expanding the symmetry", "Subsubsection",
 CellChangeTimes->{{3.534248884564441*^9, 
  3.534248910897287*^9}},ExpressionUUID->"cffd038f-3832-4458-b8d4-\
7b040d87fbfc"],

Cell["\<\
Extracting the internal expression. Observe that CovarD is not expanded.\
\>", "Text",
 CellChangeTimes->{{3.515748972670835*^9, 3.5157490038736186`*^9}, {
  3.515749061949941*^9, 
  3.515749084200214*^9}},ExpressionUUID->"e44b8818-530c-4ec3-9f49-\
ac45473a60c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InternalExprSym", "[", 
   RowBox[{"SymH", "[", 
    RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"numindices", "=", 
       RowBox[{"Length", "/@", 
        RowBox[{"SlotsOfTensor", "/@", "headlist"}]}]}], ",", "slotlist", ",",
       "partitionedslots", ",", "internalexpr"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"slotlist", "=", 
      RowBox[{"IndexList", "@@", 
       RowBox[{"slot", "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"Plus", "@@", "numindices"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Extract", " ", "indices", " ", "belonging", " ", "to", " ", "the", " ",
        "different", " ", 
       RowBox[{"tensors", ".", " ", "Can"}], " ", "this", " ", "be", " ", 
       "done", " ", "in", " ", "a", " ", "simpler", " ", 
       RowBox[{"way", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"partitionedslots", "=", 
        RowBox[{"IndexList", "@@@", 
         RowBox[{"Last", "/@", 
          RowBox[{"Rest", "@", 
           RowBox[{"FoldList", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Drop", "[", 
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}], ",", 
                RowBox[{"Take", "[", 
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}]}], 
               "}"}], "&"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"List", "@@", "slotlist"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", "numindices"}], 
            "]"}]}]}]}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"partitionedslots", "=", 
      RowBox[{"IndexList", "@@@", 
       RowBox[{"partitionRagged", "[", 
        RowBox[{
         RowBox[{"List", "@@", "slotlist"}], ",", "numindices"}], "]"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"internalexpr", "=", 
      RowBox[{"Inner", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"#1", "@@", "#2"}], ")"}], "&"}], ",", "headlist", ",", 
        "partitionedslots", ",", "Times"}], "]"}]}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.480772329919858*^9, 3.480772407389458*^9}, {
   3.4807778905542*^9, 3.4807779587972*^9}, {3.4807780899242*^9, 
   3.4807781267792*^9}, {3.4807781819552*^9, 3.4807781893322*^9}, {
   3.4807782855852003`*^9, 3.4807783174962*^9}, {3.4807783504572*^9, 
   3.4807783519432*^9}, {3.4808401164658*^9, 3.4808401169182*^9}, {
   3.4808401619398*^9, 3.480840247927*^9}, {3.480841124803*^9, 
   3.4808411299198*^9}, 3.4947527013185997`*^9, {3.517068326408663*^9, 
   3.517068336728253*^9}, {3.5170684073332906`*^9, 3.517068428514503*^9}, {
   3.5748262939169893`*^9, 3.5748263035578065`*^9}, 3.5835622551591268`*^9},
 CellLabel->
  "In[262]:=",ExpressionUUID->"0aced042-cb82-42a6-bf07-952cd8a28ba7"],

Cell["\<\
Extracting the internal symmetry.
Unfortunately you can not take SymmetryOf@InternalExprSym[x], because \
Identify requires specification of VBundle. Therefore, we introduce temporary \
indices.\
\>", "Text",
 CellChangeTimes->{{3.4807887169912*^9, 3.4807887802472*^9}, {
  3.4808339912194*^9, 3.4808340304222*^9}, {3.515749132268964*^9, 
  3.5157491539582033`*^9}},ExpressionUUID->"e2f4fb39-76e5-4235-adef-\
7a27183b45bb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InternalSymmetrySym", "[", 
   RowBox[{"x", ":", 
    RowBox[{"(", 
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], ")"}]}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"internalexpr", "=", 
       RowBox[{"InternalExprSym", "[", "x", "]"}]}], ",", "tempinds", ",", 
      "internalsym", ",", "slotrules", ",", "inverseslotrules", ",", " ", "n",
       ",", "tmpinternal", ",", "internalslotrules", ",", " ", 
      "slotpermutations"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"tempinds", "=", 
      RowBox[{"DummyIn", "/@", 
       RowBox[{"SlotsOfTensor", "[", "x", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"slotrules", "=", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{
         RowBox[{"slot", "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"Length", "@", "tempinds"}], "]"}]}], ",", "tempinds"}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"inverseslotrules", "=", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{"tempinds", ",", 
         RowBox[{"slot", "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"Length", "@", "tempinds"}], "]"}]}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "n", ",", "tmpinternal", ",", "internalslotrules", ",", 
        "internalsym"}], "}"}], "=", 
      RowBox[{"List", "@@", 
       RowBox[{"SymmetryOf", "[", 
        RowBox[{"internalexpr", "/.", "slotrules"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"slotpermutations", "=", 
      RowBox[{"(", 
       RowBox[{"internalslotrules", "/.", "inverseslotrules"}], ")"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"internalsym", "/.", 
      RowBox[{"(", 
       RowBox[{"slotpermutations", "/.", 
        RowBox[{
         RowBox[{"slot", "[", "nn_", "]"}], "\[RuleDelayed]", "nn"}]}], 
       ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4807898193082*^9, 3.4807899688662*^9}, {
   3.4807901210432*^9, 3.4807901460892*^9}, {3.4807901881172*^9, 
   3.4807902369052*^9}, {3.4807902690742*^9, 3.4807903557702*^9}, {
   3.4807905121732*^9, 3.4807905581082*^9}, {3.4807906042581997`*^9, 
   3.4807906526222*^9}, {3.4811873760426006`*^9, 3.4811873775402*^9}, 
   3.494752713783*^9},
 CellLabel->
  "In[263]:=",ExpressionUUID->"f18bf0ad-9a0b-4c06-9ef2-ad2f73797533"],

Cell["Expanding the imposed symmetry. ", "Text",
 CellChangeTimes->{{3.515749571260073*^9, 3.515749623303049*^9}, 
   3.515752660366759*^9, 
   3.534248478402128*^9},ExpressionUUID->"04d2fd70-57ca-45a9-ae42-\
1e20eabfbf96"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandSym1", "[", 
   RowBox[{"x", ":", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"SymH", "[", 
       RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
      "inds___", "]"}], ")"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"indlist", "=", 
       RowBox[{"List", "[", "inds", "]"}]}], ",", 
      RowBox[{"slotlist", "=", 
       RowBox[{"slot", "/@", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", 
          RowBox[{"List", "[", "inds", "]"}]}]}]}]}], ",", "internalexpr", 
      ",", " ", "slotexpansion"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"internalexpr", "=", 
      RowBox[{"InternalExprSym", "[", 
       RowBox[{"Head", "@", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"slotexpansion", "=", 
      RowBox[{"ImposeSymmetry", "[", 
       RowBox[{"internalexpr", ",", 
        RowBox[{"IndexList", "@@", "slotlist"}], ",", "sym"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"slotexpansion", "/.", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{"slotlist", ",", "indlist"}], "]"}]}]}]}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.4804062121578*^9, 3.480406259862601*^9}, {
   3.4804062943698*^9, 3.4804063908402*^9}, {3.4804100584782*^9, 
   3.4804100889138*^9}, {3.4804101424218*^9, 3.4804103137722*^9}, {
   3.4804104213654003`*^9, 3.4804105300038*^9}, {3.480410588067*^9, 
   3.4804106817606*^9}, {3.4804107378738003`*^9, 3.4804108075434*^9}, {
   3.4804108405062*^9, 3.4804108644522*^9}, {3.480410981499*^9, 
   3.4804110290478*^9}, {3.4804111018686*^9, 3.4804111529898*^9}, {
   3.4804120159974008`*^9, 3.4804120416282*^9}, {3.4804131632214003`*^9, 
   3.4804131948269997`*^9}, {3.480413233749*^9, 3.4804133010162*^9}, {
   3.4804133518722*^9, 3.4804133568798*^9}, {3.480413400981*^9, 
   3.4804134678114*^9}, {3.4804231649596*^9, 3.4804232441764*^9}, {
   3.4804232804932003`*^9, 3.480423438412*^9}, {3.4804246029832*^9, 
   3.4804246095664*^9}, {3.480424787656*^9, 3.4804248686824007`*^9}, {
   3.4804249096792*^9, 3.4804249207864*^9}, {3.4804249607848*^9, 
   3.4804249813144*^9}, {3.4804250243236*^9, 3.4804250884396*^9}, {
   3.4804251229936*^9, 3.4804251978268003`*^9}, {3.4804252300095997`*^9, 
   3.4804252752651997`*^9}, {3.4804253456368*^9, 3.4804253666968*^9}, {
   3.4804265850724*^9, 3.4804267442392*^9}, {3.4804267799632*^9, 
   3.4804268452648*^9}, {3.4807491403422003`*^9, 3.4807491407790003`*^9}, {
   3.480772542313858*^9, 3.480772637801458*^9}, {3.4807783658092003`*^9, 
   3.4807783674952*^9}, {3.4807791375872*^9, 3.4807791432822*^9}, {
   3.4808452146862*^9, 3.480845222689*^9}, 3.4947527245002*^9, 
   3.515752668058199*^9, {3.515997885363767*^9, 3.515997928341843*^9}, {
   3.515998196818314*^9, 3.515998236676385*^9}, {3.5159985003792477`*^9, 
   3.515998512406869*^9}, {3.5159987496676855`*^9, 3.515998756968498*^9}, {
   3.515998886401926*^9, 3.5159989251523943`*^9}, {3.515999003027731*^9, 
   3.515999021903764*^9}, {3.515999224064519*^9, 3.5159993246222954`*^9}, 
   3.516000552188452*^9},
 CellLabel->
  "In[264]:=",ExpressionUUID->"8d24c22e-7696-433e-93d1-e3106fe238ad"],

Cell["\<\
The following expands the imposed symmetry, but the internal symmetry is used \
to reduce the number of terms. \[LineSeparator]Instead of expanding the \
imposed symmetry, the complete mixed symmetry is used instead. The terms is \
then taken as a transversal of InternalCommutingSymmetry as a subgroup of \
this mixed symmetry.\
\>", "Text",
 CellChangeTimes->{{3.53424847960333*^9, 3.53424855916347*^9}, {
  3.534248590550725*^9, 3.534248624511985*^9}, {3.534248662513652*^9, 
  3.534248738657385*^9}},ExpressionUUID->"7ebf0097-6c39-46db-b1be-\
58c3a4a53648"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandSym2", "[", 
   RowBox[{"x", ":", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"SymH", "[", 
       RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
      "inds___", "]"}], ")"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"indlist", "=", 
       RowBox[{"List", "[", "inds", "]"}]}], ",", 
      RowBox[{"slotlist", "=", 
       RowBox[{"slot", "/@", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", 
          RowBox[{"List", "[", "inds", "]"}]}]}]}]}], ",", "internalexpr", 
      ",", " ", "slotexpansion", ",", " ", "bigsym", ",", "smallsym", ",", 
      "transversal"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"internalexpr", "=", 
      RowBox[{"xAct`SymManipulator`Private`InternalExprSym", "[", 
       RowBox[{"Head", "@", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bigsym", "=", 
      RowBox[{"SymmetryGroupOfTensor", "[", 
       RowBox[{"Head", "@", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"smallsym", "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"BaseChange2", "[", 
         RowBox[{
          RowBox[{"xAct`xTensor`Private`SGSofsym", "@", 
           RowBox[{"InternalCommutingSymmetry", "[", 
            RowBox[{"Head", "@", "x"}], "]"}]}], ",", 
          RowBox[{"First", "@", "bigsym"}]}], "]"}], ",", 
        RowBox[{"1", "->", 
         RowBox[{"First", "@", "bigsym"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Not", "@", 
          RowBox[{"SubgroupQ", "[", 
           RowBox[{"smallsym", ",", "bigsym"}], "]"}]}], ",", 
         RowBox[{"Print", "[", "\"\<Not a subgroup...\>\"", "]"}]}], "]"}], 
       ";"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"transversal", "=", 
      RowBox[{"InversePerm", "/@", 
       RowBox[{"TransversalComputation", "[", 
        RowBox[{"smallsym", ",", "bigsym"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"slotexpansion", "=", 
      RowBox[{
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"PermuteIndices", "[", 
            RowBox[{"internalexpr", ",", 
             RowBox[{"IndexList", "@@", "slotlist"}], ",", "#"}], "]"}], 
           "&"}], "/@", "transversal"}], ")"}]}], "/", 
       RowBox[{"Length", "[", "transversal", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"slotexpansion", "/.", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{"slotlist", ",", "indlist"}], "]"}]}]}]}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.534071481031703*^9, 3.534071501218138*^9}, {
   3.534071703160493*^9, 3.534071903574044*^9}, {3.534071953837333*^9, 
   3.534071985318188*^9}, {3.534072016970644*^9, 3.5340720736923437`*^9}, {
   3.534072226463413*^9, 3.5340722546214614`*^9}, {3.534072485657867*^9, 
   3.534072493457881*^9}, {3.5678644023450694`*^9, 3.5678644171806955`*^9}, 
   3.603719697511559*^9, 3.6196151696375227`*^9},
 CellLabel->
  "In[265]:=",ExpressionUUID->"5ec59629-7f21-449a-bc09-f91cb91e5d7e"],

Cell["\<\
Removing the imposed symmetry. This is the same thing as InternalExprSym, but \
with the correct indices, not some dummy indices. Observe that this can be \
dangerous if there are contractions on any of the slots in the symmetry. The \
contractions should be taken after the symmetry is imposed.\
\>", "Text",
 CellChangeTimes->{{3.5157496427161593`*^9, 3.515749724580842*^9}, {
  3.515749762925035*^9, 3.515749828537788*^9}, {3.515749859948584*^9, 
  3.5157498904923315`*^9}},ExpressionUUID->"aa7d7a38-6e49-4909-8df8-\
7de9f8fb1cff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveSym1", "[", 
   RowBox[{"x", ":", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"SymH", "[", 
       RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
      "inds___", "]"}], ")"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"indlist", "=", 
       RowBox[{"List", "[", "inds", "]"}]}], ",", 
      RowBox[{"slotlist", "=", 
       RowBox[{"IndexList", "@@", 
        RowBox[{"slot", "/@", 
         RowBox[{"Range", "@", 
          RowBox[{"Length", "@", 
           RowBox[{"List", "[", "inds", "]"}]}]}]}]}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"InternalExprSym", "[", 
      RowBox[{"Head", "@", "x"}], "]"}], "/.", 
     RowBox[{"Thread", "@", 
      RowBox[{"Rule", "[", 
       RowBox[{
        RowBox[{"List", "@@", "slotlist"}], ",", "indlist"}], "]"}]}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4935439775431967`*^9, 3.493544033359997*^9}, 
   3.4947527318322*^9, {3.515749976543253*^9, 3.515749980136459*^9}, 
   3.515752742077433*^9},
 CellLabel->
  "In[266]:=",ExpressionUUID->"cd9bfda6-13ee-44b3-9ead-f5fd5c18faf0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ExpandSym", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"SmartExpand", "\[Rule]", "False"}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5342491897633777`*^9, 3.5342492062994065`*^9}},
 CellLabel->
  "In[267]:=",ExpressionUUID->"ffe894d3-0ae3-4af5-b519-b0c3235744d0"],

Cell["\<\
User versions of the functions above. These work on any expression, it does \
not have to be just a SymH object. It also expands CovarD.\
\>", "Text",
 CellChangeTimes->{{3.515749924474275*^9, 3.5157500103281846`*^9}, 
   3.839127435840534*^9},ExpressionUUID->"017ef12e-4139-4c94-8b41-\
8d97c4890f08"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandSym", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"options", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
  RowBox[{"ExpandCovarDAndInertHeadHead", "[", "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"OptionValue", "[", "SmartExpand", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"expr", "/.", 
      RowBox[{
       RowBox[{"x", ":", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"SymH", "[", "___", "]"}], "[", "inds___", "]"}], ")"}]}], ":>", 
       RowBox[{"ExpandSym2", "[", "x", "]"}]}]}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"expr", "/.", 
      RowBox[{
       RowBox[{"x", ":", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"SymH", "[", "___", "]"}], "[", "inds___", "]"}], ")"}]}], ":>", 
       RowBox[{"ExpandSym1", "[", "x", "]"}]}]}]}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.484471790717*^9, 3.484471838552*^9}, 3.4937201398962*^9,
    3.494752741707*^9, 3.515752680206894*^9, {3.5157527152738986`*^9, 
   3.515752716761985*^9}, {3.5260454092890425`*^9, 3.5260454277740993`*^9}, {
   3.534249236282659*^9, 3.53424923668826*^9}, {3.5342493832973175`*^9, 
   3.534249429535799*^9}, {3.5342495088463387`*^9, 3.5342495665820394`*^9}, {
   3.534250360295833*^9, 3.534250361684236*^9}, {3.5342504998224783`*^9, 
   3.534250503160884*^9}, 3.5876525014853578`*^9, 3.58765254277963*^9, {
   3.587653756218562*^9, 3.587653757809765*^9}},
 CellLabel->
  "In[268]:=",ExpressionUUID->"44de756b-fc4c-4cfa-8ab9-6059b88ad268"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandSymS", "[", "LL_", "]"}], ":=", 
  RowBox[{"ExpandSym", "[", 
   RowBox[{"LL", ",", 
    RowBox[{"SmartExpand", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.839127456243993*^9},
 CellLabel->
  "In[269]:=",ExpressionUUID->"2971ecce-f476-4a08-b859-785c2163dd54"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveSym", "[", "expr_", "]"}], ":=", 
  RowBox[{"ExpandCovarDAndInertHeadHead", "[", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"SymH", "[", "___", "]"}], "[", "inds___", "]"}], ")"}]}], 
     "\[RuleDelayed]", 
     RowBox[{"RemoveSym1", "[", "x", "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.493544043141197*^9, 3.493544051674397*^9}, 
   3.4937201350758*^9, 3.4947527444681997`*^9, {3.5157527552841883`*^9, 
   3.515752779393567*^9}, {3.526045435682553*^9, 3.5260454400028*^9}},
 CellLabel->
  "In[270]:=",ExpressionUUID->"5238550e-5cf5-4744-8d12-0ee3d7845393"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4. Labels", "Subsubsection",
 CellChangeTimes->{{3.534248922862509*^9, 
  3.534248954015763*^9}},ExpressionUUID->"5396edec-1a73-47f6-9f4a-\
a745dfc49f3e"],

Cell["\<\
Here are some functions for generating a label that can sometimes describe \
the symmetry. If the group is not recognized, the unstable slots are listed \
as the description. One can recognize a disjoint union of symmetric and \
antisymmetric groups by studying the group orbit by orbit. This is probably \
not true for other groups.\
\>", "Text",
 CellChangeTimes->{{3.4806819801706*^9, 3.480682041541*^9}, {
  3.5157500301473193`*^9, 3.515750078839104*^9}, {3.54510594864591*^9, 
  3.5451059968343945`*^9}, {3.5451060595777044`*^9, 
  3.545106098889774*^9}},ExpressionUUID->"a76876d4-f387-4cd3-afb1-\
8eaeb2cd904f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefaultOrbitLabel", "[", 
   RowBox[{"points_", ",", "sym_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"orbitlabel", "=", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"ToString", "/@", "points"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"SubgroupQ", "[", 
       RowBox[{
        RowBox[{"Symmetric", "[", "points", "]"}], ",", "sym"}], "]"}], ",", 
      RowBox[{"(*", " ", "Symmetric", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"\"\<(\>\"", ",", "orbitlabel", ",", "\"\<)\>\""}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"SubgroupQ", "[", 
       RowBox[{
        RowBox[{"Antisymmetric", "[", "points", "]"}], ",", "sym"}], "]"}], 
      ",", 
      RowBox[{"(*", " ", "Antisymmetric", " ", "*)"}], "\[IndentingNewLine]", 
      
      RowBox[{"StringJoin", "[", 
       RowBox[{"\"\<[\>\"", ",", "orbitlabel", ",", "\"\<]\>\""}], "]"}], ",",
       "\[IndentingNewLine]", "True", ",", 
      RowBox[{"(*", " ", 
       RowBox[{"Everything", " ", "else"}], " ", "*)"}], 
      "\[IndentingNewLine]", "orbitlabel"}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517819303990904*^9, 3.517819449774242*^9}, 
   3.517820148914231*^9},
 CellLabel->
  "In[271]:=",ExpressionUUID->"eb44f7c8-2c5d-48b5-b5ff-d4ad5be135d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefaultLabelSym", "[", "sym_StrongGenSet", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"PermLength", "@", 
        RowBox[{"Last", "[", "sym", "]"}]}]}], ",", " ", "longorbits", ",", 
      "unstableslots", ",", " ", "orbitlabels"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"longorbits", "=", 
      RowBox[{"Sort", "/@", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"Orbits", "[", 
          RowBox[{"sym", ",", "n"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "#", "]"}], ">", "1"}], "&"}]}], "]"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"orbitlabels", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"DefaultOrbitLabel", "[", 
         RowBox[{"#", ",", "sym"}], "]"}], "&"}], "/@", "longorbits"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"ToString", "/@", "orbitlabels"}], "]"}]}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.517819175480553*^9, 3.5178192224502397`*^9}, {
  3.5178195710511785`*^9, 3.517819672746995*^9}, {3.5178199401572905`*^9, 
  3.517819940625317*^9}, {3.517820189070527*^9, 3.517820228586787*^9}, {
  3.545105916463053*^9, 3.545105923327065*^9}, {3.567860831199397*^9, 
  3.5678608352710037`*^9}, {3.620203192892572*^9, 3.620203193892574*^9}},
 CellLabel->
  "In[272]:=",ExpressionUUID->"9ead661d-9a1a-44b8-acb1-7bc6587d1573"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefaultLabelSym", "[", "sym_Symmetric", "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<(\>\"", ",", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"ToString", "/@", 
      RowBox[{"First", "@", "sym"}]}], "]"}], ",", "\"\<)\>\""}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567860845504622*^9, 3.567860911274338*^9}, 
   3.567862731113134*^9},
 CellLabel->
  "In[273]:=",ExpressionUUID->"60c5c4cd-4606-4645-a47e-a2ec801d3006"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefaultLabelSym", "[", "sym_Antisymmetric", "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<[\>\"", ",", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"ToString", "/@", 
      RowBox[{"First", "@", "sym"}]}], "]"}], ",", "\"\<]\>\""}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.56786091837235*^9, 3.567860924799561*^9}, 
   3.567862736432743*^9},
 CellLabel->
  "In[274]:=",ExpressionUUID->"f6f31f21-2a07-49dd-9219-d7af71401cf3"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.5. Computation of the total symmetry of the symmetrized object\
\>", "Subsubsection",
 CellChangeTimes->{
  3.5342489653101826`*^9},ExpressionUUID->"1cb6823b-9561-448e-8896-\
7f54ece5f80f"],

Cell["\<\
This computation is only works if the imposed symmetry is Symmetric[ _ ] or \
Antisymmetric[ _ ].
In all other cases it returns the imposed symmetry only.
Observe that we compute the symmetry only once. \
\>", "Text",
 CellChangeTimes->{{3.515749308364035*^9, 3.515749327031103*^9}, {
  3.515749399294236*^9, 3.515749487714293*^9}, {3.51628646811552*^9, 
  3.516286468380721*^9}, {3.516286921358717*^9, 3.516286922466319*^9}, {
  3.517817400708042*^9, 
  3.517817412898739*^9}},ExpressionUUID->"bb532502-7233-482a-9cb7-\
a12b2b9d71a8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$MixedSymSpecialCode", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$MixedSymVerbose", "=", "False"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.564124678055909*^9, 3.564124680333513*^9}, 
   3.567929432564781*^9, {3.567931815642568*^9, 3.5679318160013685`*^9}, {
   3.567931915123942*^9, 3.5679319160131435`*^9}},
 CellLabel->
  "In[275]:=",ExpressionUUID->"536895a4-2ac9-4bed-9e20-2008a2123b8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryGroupOfTensor", "[", 
   RowBox[{"x", " ", ":", " ", 
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", " ", "sym_", ",", " ", "label_"}], "]"}]}], 
   "]"}], " ", "^:=", 
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", "x", "]"}], "^=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "=", 
        RowBox[{"Plus", "@@", 
         RowBox[{"(", 
          RowBox[{"Length", "/@", 
           RowBox[{"SlotsOfTensor", "/@", "headlist"}]}], ")"}]}]}], ",", 
       "unstableslots", ",", "newlabel", ",", "symmetrygroup", ",", " ", 
       "internalcommutingsym"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"unstableslots", "=", 
       RowBox[{"GroupSupport", "@", "sym"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "In", " ", "the", " ", "special", " ", "cases", " ", "when", " ", 
         "the", " ", "symmetry", " ", "is", " ", "\[IndentingNewLine]", 
         RowBox[{"Symmetric", "[", "unstableslots", "]"}]}], ",", " ", 
        RowBox[{"or", " ", 
         RowBox[{"Antysymmetric", "[", "unstableslots", "]"}]}], ",", " ", 
        RowBox[{"we", " ", "compute", " ", "the", " ", "mixed", " ", 
         RowBox[{"symmetry", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"symmetrygroup", ",", " ", "internalcommutingsym"}], "}"}], 
       "=", "\[IndentingNewLine]", 
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{"And", "[", 
          RowBox[{
           RowBox[{"$MixedSymSpecialCode", "===", "True"}], ",", 
           RowBox[{
            RowBox[{"Head", "@", "sym"}], "===", "Symmetric"}]}], "]"}], ",", 
         
         RowBox[{"(*", " ", "Symmetric", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"SymmetryOfProductOfGroupsSymmetricCase2b", "[", 
          RowBox[{"unstableslots", ",", 
           RowBox[{"InternalSymmetrySym", "[", 
            RowBox[{"SymH", "[", 
             RowBox[{"headlist", ",", " ", "sym", ",", " ", "label"}], "]"}], 
            "]"}], ",", "False"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"And", "[", 
          RowBox[{
           RowBox[{"$MixedSymSpecialCode", "===", "SetStabilizer"}], ",", 
           RowBox[{
            RowBox[{"Head", "@", "sym"}], "===", "Symmetric"}]}], "]"}], ",", 
         
         RowBox[{"(*", " ", "Symmetric", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"SymmetricMixedSymmetry", "[", 
          RowBox[{"unstableslots", ",", 
           RowBox[{"InternalSymmetrySym", "[", 
            RowBox[{"SymH", "[", 
             RowBox[{"headlist", ",", " ", "sym", ",", " ", "label"}], "]"}], 
            "]"}], ",", "sym", ",", "n"}], "]"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"And", "[", 
          RowBox[{
           RowBox[{"$MixedSymSpecialCode", "===", "SetStabilizer"}], ",", 
           RowBox[{
            RowBox[{"Head", "@", "sym"}], "===", "Antisymmetric"}]}], "]"}], 
         ",", 
         RowBox[{"(*", " ", "Antisymmetric", " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"AntisymmetricMixedSymmetry", "[", 
          RowBox[{"unstableslots", ",", 
           RowBox[{"InternalSymmetrySym", "[", 
            RowBox[{"SymH", "[", 
             RowBox[{"headlist", ",", " ", "sym", ",", " ", "label"}], "]"}], 
            "]"}], ",", "sym", ",", "n"}], "]"}], ",", "\[IndentingNewLine]", 
         "True", ",", 
         RowBox[{"(*", " ", 
          RowBox[{"Everything", " ", "else"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"GeneralMixedSymmetry", "[", 
          RowBox[{"unstableslots", ",", 
           RowBox[{"InternalSymmetrySym", "[", 
            RowBox[{"SymH", "[", 
             RowBox[{"headlist", ",", " ", "sym", ",", " ", "label"}], "]"}], 
            "]"}], ",", "sym", ",", "n"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"InternalCommutingSymmetry", "[", "x", "]"}], "^=", " ", 
       "internalcommutingsym"}], ";", "\[IndentingNewLine]", 
      "symmetrygroup"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4955499752376*^9, 3.4955499758304*^9}, 
   3.5088459203122*^9, {3.5088460008394003`*^9, 3.5088461014282*^9}, {
   3.5088462123286*^9, 3.5088462841354*^9}, {3.5088463273162003`*^9, 
   3.5088463494838*^9}, {3.5088464254402*^9, 3.508846482193*^9}, {
   3.5088465353578*^9, 3.5088466225150003`*^9}, {3.508846657771*^9, 
   3.5088466771774*^9}, {3.5088467235094*^9, 3.5088467294217997`*^9}, {
   3.508846803631*^9, 3.5088468097462*^9}, {3.5088478232296*^9, 
   3.5088478312792*^9}, {3.5088487096226*^9, 3.5088487192634*^9}, {
   3.5088488183389997`*^9, 3.5088488306474*^9}, {3.50909499893574*^9, 
   3.50909519328054*^9}, 3.50909592674574*^9, 3.5090996057249403`*^9, 
   3.5093591012274*^9, 3.5093682095842*^9, {3.5093682538726*^9, 
   3.5093682892222*^9}, {3.5093709493185997`*^9, 3.5093709520174*^9}, 
   3.5093711200606003`*^9, {3.50971614612*^9, 3.509716157052*^9}, {
   3.509716187167*^9, 3.509716189703*^9}, {3.511527507427012*^9, 
   3.5115275161318116`*^9}, {3.5116696727813997`*^9, 3.5116696762757993`*^9}, 
   3.5116729083942*^9, 3.5116729690313993`*^9, 3.5116730589498*^9, {
   3.5116730890578*^9, 3.5116730944554*^9}, {3.5116746179826*^9, 
   3.5116746257202*^9}, 3.5116747202874002`*^9, {3.5118476848412*^9, 
   3.5118476864168*^9}, {3.5118477520304008`*^9, 3.511847759924*^9}, 
   3.516284009875802*^9, {3.516284093335949*^9, 3.516284115768788*^9}, {
   3.516284276511471*^9, 3.516284355276009*^9}, {3.516284404572096*^9, 
   3.516284433120146*^9}, {3.516285285522243*^9, 3.516285293790257*^9}, 
   3.5162864657755165`*^9, 3.5162869264131246`*^9, {3.516428137359011*^9, 
   3.516428156471104*^9}, {3.51642846480274*^9, 3.51642848629797*^9}, {
   3.516428632751346*^9, 3.516428655766662*^9}, {3.516432012256218*^9, 
   3.516432012753246*^9}, {3.5170681470514045`*^9, 3.517068207428858*^9}, {
   3.5170682604388885`*^9, 3.517068299940149*^9}, {3.517068443974387*^9, 
   3.517068450632768*^9}, {3.517068711606695*^9, 3.5170687463606825`*^9}, {
   3.5170689334583836`*^9, 3.5170689337393994`*^9}, {3.5202686917072783`*^9, 
   3.520268706366499*^9}, {3.5340681918127246`*^9, 3.534068263494851*^9}, {
   3.534068302370119*^9, 3.534068332649772*^9}, {3.5641242811278124`*^9, 
   3.564124316742674*^9}, {3.564124686214723*^9, 3.5641247581932507`*^9}, {
   3.567862816913285*^9, 3.5678629117614512`*^9}, {3.5679185652614937`*^9, 
   3.567918582125122*^9}, {3.5679292793569126`*^9, 3.567929326437795*^9}, {
   3.567929385546299*^9, 3.5679294183999577`*^9}, {3.5679316047145977`*^9, 
   3.567931605104597*^9}, {3.568116261167963*^9, 3.568116298155628*^9}, {
   3.5681223328430276`*^9, 3.568122334933431*^9}, {3.584196597743231*^9, 
   3.5841966023452396`*^9}, 3.689425662583516*^9, {3.6894257178845167`*^9, 
   3.689425719556516*^9}},
 CellLabel->
  "In[277]:=",ExpressionUUID->"c456b2ed-4efb-434d-81a4-8d6e6d753fa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ClearRememberedSymHSymmetry", "[", "tensor_", "]"}], ":=", 
   RowBox[{
    RowBox[{"UpValues", "[", "SymH", "]"}], "=", 
    RowBox[{"DeleteCases", "[", 
     RowBox[{
      RowBox[{"UpValues", "[", "SymH", "]"}], ",", 
      RowBox[{"_", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "0"}], "]"}], "]"}], "\[Equal]", 
            "HoldPattern"}], ")"}], "&&", 
          RowBox[{"Or", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1", ",", "0"}], "]"}], "]"}], "\[Equal]", 
             "SymmetryGroupOfTensor"}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1", ",", "0"}], "]"}], "]"}], "\[Equal]", 
             "InternalCommutingSymmetry"}]}], "]"}], "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1", ",", " ", "1", ",", "0"}], "]"}], "]"}], 
            "\[Equal]", "SymH"}], ")"}], "&&", 
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
            "tensor", ",", "Infinity"}], "]"}]}], "&"}], ")"}]}]}], "]"}]}]}],
   ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5164277909261966`*^9, 3.5164278302964487`*^9}, {
  3.534069800971152*^9, 3.534069813248373*^9}, {3.534069847303233*^9, 
  3.534069904804934*^9}, {3.562835193734892*^9, 3.5628351981965003`*^9}},
 CellLabel->
  "In[278]:=",ExpressionUUID->"814e5d19-69ba-46a4-9f13-bf6c8cfd61d3"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.6. Changing UndefTensor to clear SymmetryGroupOfTensor results\
\>", "Subsubsection",
 CellChangeTimes->{
  3.534248968305388*^9},ExpressionUUID->"cfb511c9-9c13-4bab-afb0-\
6d20d03afd64"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xTension", "[", 
    RowBox[{
    "\"\<SymManipulator`\>\"", ",", "UndefTensor", ",", "\"\<Beginning\>\""}],
     "]"}], "=", "ClearRememberedSymHSymmetry"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.544590957295322*^9, 3.5445910050450544`*^9}, {
   3.5445912225244937`*^9, 3.544591222956517*^9}, {3.544591439903926*^9, 
   3.544591442003046*^9}, 3.5445916138988776`*^9, 3.544591831970351*^9},
 CellLabel->
  "In[279]:=",ExpressionUUID->"860ee986-9668-4ce8-92bc-ac2db04df2fa"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.7. InertHeadHead and CovarD", "Subsubsection",
 CellChangeTimes->{
  3.534248970255392*^9},ExpressionUUID->"bef8714a-cd44-481d-8e0c-\
cdb4bc1542e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "InertHeadHead", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[280]:=",ExpressionUUID->"656fdb5c-731f-4d8b-9496-f230d01cfdc3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"InertHeadHead", "[", 
     RowBox[{
      RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"InertHeadHead", "[", 
     RowBox[{
      RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PrintAs", "[", "H1", "]"}], ",", 
      RowBox[{"PrintAs", "[", "T", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"InertHeadHead", "[", 
     RowBox[{
      RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"SlotsOfTensor", "[", "T", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"InertHeadHead", "[", 
     RowBox[{
      RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"DependenciesOfTensor", "[", "T", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"InertHeadHead", "[", 
     RowBox[{
      RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"SymmetryGroupOfTensor", "[", "T", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"InertHeadHead", "[", 
     RowBox[{
      RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"\"\<tensor\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "H1", "]"}], ",", 
       RowBox[{"ToString", "[", "T", "]"}]}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", 
    RowBox[{"InertHeadHead", "[", 
     RowBox[{
      RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"InertHeadHead", "[", 
     RowBox[{
      RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4838600931809998`*^9, 3.483860126512*^9}, {
   3.483860180858*^9, 3.483860354747*^9}, {3.483860429788*^9, 
   3.4838605260299997`*^9}, 3.516083182136587*^9, 3.516083361505846*^9, {
   3.563170396196651*^9, 3.563170400471058*^9}},
 CellLabel->
  "In[281]:=",ExpressionUUID->"9a5dff31-a673-4f5a-becf-b4dc2bea9791"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "CovarD", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[289]:=",ExpressionUUID->"a77be026-7551-45e0-ba54-b55fdc01f320"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"CovarD", "[", 
     RowBox[{
      RowBox[{"D1_", "?", "CovDQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], "^:=", 
   "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"CovarD", "[", 
     RowBox[{
      RowBox[{"D1_", "?", "CovDQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Last", "@", 
       RowBox[{"SymbolOfCovD", "[", "D1", "]"}]}], ",", 
      RowBox[{"PrintAs", "[", "T", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SlotsOfTensor", "[", 
     RowBox[{"CovarD", "[", 
      RowBox[{
       RowBox[{"D1_", "?", "CovDQ"}], ",", 
       RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], "^:=", 
    RowBox[{"Join", "[", 
     RowBox[{"list", ",", 
      RowBox[{"SlotsOfTensor", "[", "T", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Is", " ", "this", " ", 
    RowBox[{"correct", "?"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"CovarD", "[", 
     RowBox[{
      RowBox[{"D1_", "?", "CovDQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], "^:=", 
   RowBox[{"DependenciesOfTensor", "[", "T", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"CovarD", "[", 
     RowBox[{
      RowBox[{"D1_", "?", "CovDQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], "^:=", 
   "\[IndentingNewLine]", 
   RowBox[{"JoinSGS", "[", 
    RowBox[{
     RowBox[{"SymmetryGroupOfCovD", "[", "D1", "]"}], ",", 
     RowBox[{
      RowBox[{"SymmetryGroupOfTensor", "[", "T", "]"}], "/.", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{
         RowBox[{"Range", "@", 
          RowBox[{"Length", "@", 
           RowBox[{"SlotsOfTensor", "[", "T", "]"}]}]}], ",", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"1", "+", 
            RowBox[{"Length", "[", "list", "]"}]}], ",", 
           RowBox[{
            RowBox[{"Length", "[", "list", "]"}], "+", 
            RowBox[{"Length", "@", 
             RowBox[{"SlotsOfTensor", "[", "T", "]"}]}]}]}], "]"}]}], 
        "]"}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DefInfo", "[", 
     RowBox[{"CovarD", "[", 
      RowBox[{
       RowBox[{"D1_", "?", "CovDQ"}], ",", 
       RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], "^:=", 
    RowBox[{"{", 
     RowBox[{"\"\<tensor\>\"", ",", 
      RowBox[{"StringJoin", "[", 
       RowBox[{
        RowBox[{"ToString", "[", "D1", "]"}], ",", 
        RowBox[{"ToString", "[", "T", "]"}]}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "These", " ", "two", " ", "should", " ", "also", " ", "be", " ", 
     "generalized"}], "..."}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", 
    RowBox[{"CovarD", "[", 
     RowBox[{
      RowBox[{"D1_", "?", "CovDQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"CovarD", "[", 
     RowBox[{
      RowBox[{"D1_", "?", "CovDQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.4807581444302*^9, 3.4807582914914*^9, {3.4807584309242*^9, 
   3.4807585565978007`*^9}, {3.4807585961282*^9, 3.4807586323202*^9}, {
   3.4807592311730003`*^9, 3.4807592941502*^9}, 3.4807593570338*^9, {
   3.480759406751*^9, 3.4807594188722*^9}, {3.4807595091962*^9, 
   3.4807597459262*^9}, {3.4807597835066*^9, 3.4807598090126*^9}, 
   3.4807600049018*^9, {3.4807601056622*^9, 3.480760108205*^9}, {
   3.4807615749326*^9, 3.480761607443*^9}, {3.4807632693266*^9, 
   3.4807632802466*^9}, {3.4807633456262*^9, 3.4807633470614*^9}, 
   3.4807636880774*^9, {3.493550337756797*^9, 3.493550340174797*^9}, {
   3.4935505316491966`*^9, 3.493550535252797*^9}, 3.5160832069070034`*^9, 
   3.5160833719344425`*^9},
 CellLabel->
  "In[290]:=",ExpressionUUID->"25dadaef-61c2-4739-aca7-7b1b47937549"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CovarD", "[", 
   RowBox[{
    RowBox[{"D1_", "?", "CovDQ"}], ",", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}], ",", "list_"}], "]"}], ":=", 
  RowBox[{"ZeroTensor", "[", 
   RowBox[{"Join", "[", 
    RowBox[{"list", ",", "slotlist"}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517473050064574*^9, 3.517473116130689*^9}},
 CellLabel->
  "In[298]:=",ExpressionUUID->"07da18c3-7aef-43d8-9aa7-1b1eb5776efc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InertHeadHead", "[", 
   RowBox[{
    RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
    RowBox[{"ZeroTensor", "[", "slotlist_", "]"}]}], "]"}], ":=", 
  RowBox[{"ZeroTensor", "[", "slotlist", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567327878428987*^9, 3.5673279183962584`*^9}, {
  3.56732800533521*^9, 3.567328024367244*^9}},
 CellLabel->
  "In[299]:=",ExpressionUUID->"57ec09a5-a4e7-493c-9b6a-245b5c3f7c35"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandInertHeadHead", "[", 
   RowBox[{
    RowBox[{"InertHeadHead", "[", 
     RowBox[{
      RowBox[{"H1_", "?", "InertHeadQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}]}], "]"}], "[", "inds___", "]"}], "]"}], 
  ":=", 
  RowBox[{"H1", "[", 
   RowBox[{"T", "[", "inds", "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4807570870154*^9, 3.4807571542202*^9}, {
   3.4807572060278*^9, 3.4807572246386003`*^9}, {3.4807572808922*^9, 
   3.4807574110118*^9}, {3.4807578248174*^9, 3.4807579722061996`*^9}, 
   3.4807582926926007`*^9, {3.4807583318798*^9, 3.4807583407874002`*^9}, 
   3.4807598194021997`*^9, {3.4807598512574*^9, 3.480759884033*^9}, {
   3.483860552403*^9, 3.4838606247790003`*^9}},
 CellLabel->
  "In[300]:=",ExpressionUUID->"30f0a123-92e8-4bd3-ba29-2f793567b199"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandCovarD", "[", 
   RowBox[{
    RowBox[{"CovarD", "[", 
     RowBox[{
      RowBox[{"D1_", "?", "CovDQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "[", "inds___", 
    "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"D1", "[", 
    RowBox[{"Sequence", "@@", 
     RowBox[{"Take", "[", 
      RowBox[{
       RowBox[{"List", "[", "inds", "]"}], ",", 
       RowBox[{"Length", "@", "list"}]}], "]"}]}], "]"}], "[", 
   RowBox[{"T", "[", 
    RowBox[{"Sequence", "@@", 
     RowBox[{"Drop", "[", 
      RowBox[{
       RowBox[{"List", "[", "inds", "]"}], ",", 
       RowBox[{"Length", "@", "list"}]}], "]"}]}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4807570870154*^9, 3.4807571542202*^9}, {
   3.4807572060278*^9, 3.4807572246386003`*^9}, {3.4807572808922*^9, 
   3.4807574110118*^9}, {3.4807578248174*^9, 3.4807579722061996`*^9}, 
   3.4807582926926007`*^9, {3.4807583318798*^9, 3.4807583407874002`*^9}, 
   3.4807598194021997`*^9, {3.4807598512574*^9, 3.480759884033*^9}},
 CellLabel->
  "In[301]:=",ExpressionUUID->"b596790e-471a-4b3a-8b86-9155a699d864"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandCovarDAndInertHeadHead", "[", "expr_", "]"}], ":=", 
  RowBox[{"expr", "//.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", ":", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"InertHeadHead", "[", "___", "]"}], "[", "inds___", "]"}], 
        ")"}]}], ":>", 
      RowBox[{"ExpandInertHeadHead", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ":", 
        RowBox[{
         RowBox[{"CovarD", "[", "___", "]"}], "[", "inds___", "]"}]}], ")"}], 
      ":>", 
      RowBox[{"ExpandCovarD", "[", "x", "]"}]}]}], "}"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4913118990414*^9, 3.491311908885*^9}, {
  3.4913119447494*^9, 3.4913119735626*^9}, {3.526045350867701*^9, 
  3.5260453533638434`*^9}, {3.584690260191892*^9, 3.584690271486312*^9}},
 CellLabel->
  "In[302]:=",ExpressionUUID->"eda99417-7e58-42ed-a104-335481099a40"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToInertHeadHead", "[", 
   RowBox[{
    RowBox[{"H1_", "?", "InertHeadQ"}], "[", 
    RowBox[{
     RowBox[{"T_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"InertHeadHead", "[", 
    RowBox[{"H1", ",", "T"}], "]"}], "[", "inds", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4838608339960003`*^9, 3.483860932758*^9}},
 CellLabel->
  "In[303]:=",ExpressionUUID->"eef2c7d9-b375-480f-b582-e81d9695ef9a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToInertHeadHead", "[", 
   RowBox[{
    RowBox[{"H1_", "?", "InertHeadQ"}], "[", 
    RowBox[{
     RowBox[{"H2_", "?", "InertHeadQ"}], "[", "expr_", "]"}], "]"}], "]"}], ":=", 
  RowBox[{"ToInertHeadHead", "[", 
   RowBox[{"H1", "@", 
    RowBox[{"ToInertHeadHead", "[", 
     RowBox[{"H2", "[", "expr", "]"}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567327651245788*^9, 3.5673277011034765`*^9}},
 CellLabel->
  "In[304]:=",ExpressionUUID->"0ad8738b-53aa-416d-badd-f67f9a4755bd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToInertHeadHead", "[", 
   RowBox[{
    RowBox[{"H1_", "?", "InertHeadQ"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D1_", "?", "CovDQ"}], "[", "covdinds___", "]"}], "[", "expr_", 
     "]"}], "]"}], "]"}], ":=", 
  RowBox[{"ToInertHeadHead", "[", 
   RowBox[{"H1", "@", 
    RowBox[{"ToCovarD", "[", 
     RowBox[{
      RowBox[{"D1", "[", "covdinds", "]"}], "[", "expr", "]"}], "]"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5631694372317657`*^9, 3.563169447465384*^9}, {
  3.56316951883551*^9, 3.563169579660016*^9}, {3.5631700533080482`*^9, 
  3.5631700572236557`*^9}},
 CellLabel->
  "In[305]:=",ExpressionUUID->"ca8453db-107d-4c24-8327-0e9a91c5320e"],

Cell["\<\
Always use DownIndex as standard position. It is important that we do not \
have any freedom in the choice. Otherwise we need to deal with this ambiguity \
during canonicalization.\
\>", "Text",
 CellChangeTimes->{{3.4808445119374*^9, 
  3.480844671775*^9}},ExpressionUUID->"7d41a165-2d87-458d-b8c0-44d1ec125fde"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCovarD", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D1_", "?", "CovDQ"}], "[", "covdinds___", "]"}], "[", 
    RowBox[{
     RowBox[{"T_", "?", "xTensorQ"}], "[", "tensorinds___", "]"}], "]"}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CovarD", "[", 
    RowBox[{"D1", ",", "T", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", 
         RowBox[{"VBundleOfIndex", "[", "#", "]"}]}], ")"}], "&"}], "/@", 
      RowBox[{"List", "[", "covdinds", "]"}]}]}], "]"}], "[", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"List", "[", "covdinds", "]"}], ",", 
      RowBox[{"List", "[", "tensorinds", "]"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4807616174582*^9, 3.4807616756618*^9}, {
  3.4807627168994*^9, 3.4807627980038*^9}, {3.4807637181542*^9, 
  3.4807637317106*^9}, {3.4808443257826*^9, 3.480844343317*^9}},
 CellLabel->
  "In[306]:=",ExpressionUUID->"04a6276e-5485-4405-b6a1-1cfb03059291"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCovarD", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D1_", "?", "CovDQ"}], "[", "covdinds___", "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D2_", "?", "CovDQ"}], "[", "covdinds2___", "]"}], "[", "expr_",
      "]"}], "]"}], "]"}], ":=", 
  RowBox[{"ToCovarD", "[", 
   RowBox[{
    RowBox[{"D1", "[", "covdinds", "]"}], "@", 
    RowBox[{"ToCovarD", "[", 
     RowBox[{
      RowBox[{"D2", "[", "covdinds2", "]"}], "[", "expr", "]"}], "]"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.480761739965*^9, 3.480761836763*^9}},
 CellLabel->
  "In[307]:=",ExpressionUUID->"9ed5a039-2311-4642-b713-6df84a045f0d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCovarD", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D1_", "?", "CovDQ"}], "[", "covdinds___", "]"}], "[", 
    RowBox[{
     RowBox[{"H1_", "?", "InertHeadQ"}], "[", "expr_", "]"}], "]"}], "]"}], ":=", 
  RowBox[{"ToCovarD", "[", 
   RowBox[{
    RowBox[{"D1", "[", "covdinds", "]"}], "@", 
    RowBox[{"ToInertHeadHead", "[", 
     RowBox[{"H1", "[", "expr", "]"}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.483862447247*^9, 3.483862500633*^9}},
 CellLabel->
  "In[308]:=",ExpressionUUID->"8cbad140-e662-4f56-a0f2-17dea972eed7"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.8. Dagger", "Subsubsection",
 CellChangeTimes->{
  3.5342489723457947`*^9},ExpressionUUID->"8d9a0697-7225-44a9-9a2d-\
c6462aab657d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "Dagger", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.483874397662*^9, 3.4838744040299997`*^9}, 
   3.484481082943*^9},
 CellLabel->
  "In[309]:=",ExpressionUUID->"80e6ec9c-5e35-4b6c-a635-1de7009d5ebe"],

Cell["\<\
This overloads the dagger symbol for ordinary tensors, so we have to remove \
that first, and add it later.\
\>", "Text",
 CellChangeTimes->{{3.484481326103*^9, 3.484481333584*^9}, {
  3.5178232214819717`*^9, 3.517823254905883*^9}, {3.5178237550304885`*^9, 
  3.5178238069904604`*^9}, {3.517823848981862*^9, 3.517823857931374*^9}, {
  3.517823892467349*^9, 
  3.5178238943024545`*^9}},ExpressionUUID->"12495660-6276-41b3-998f-\
25d1b7030925"],

Cell["\<\
Dagger[xAct`xTenosr`Private`tensor_?xTensorQ[xAct`xTenosr`Private`inds___]] =.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.5178234872341714`*^9, 3.51782352286821*^9}, 
   3.544672297638333*^9},ExpressionUUID->"8b904b33-10ae-494a-8517-\
099940843b5d"],

Cell["\<\
To avoid problems with contracted indices, we replace the indices with \
temporary ones.\
\>", "Text",
 CellChangeTimes->{{3.5178239772131968`*^9, 
  3.517824037532647*^9}},ExpressionUUID->"5165a260-5e11-4e43-af24-\
2ec6065139cd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{"x", ":", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymH", "[", 
        RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "?", 
       "xTensorQ"}], "[", "inds___", "]"}], ")"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tempinds", "=", 
      RowBox[{"DummyAs", "/@", 
       RowBox[{"IndexList", "[", "inds", "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ImposeSym", "[", 
      RowBox[{
       RowBox[{"Dagger", "@", 
        RowBox[{"RemoveSym1", "[", 
         RowBox[{"Apply", "[", 
          RowBox[{
           RowBox[{"Head", "@", "x"}], ",", "tempinds"}], "]"}], "]"}]}], ",", 
       RowBox[{"DaggerIndex", "/@", "tempinds"}], ",", "sym"}], "]"}], "/.", 
     RowBox[{"Thread", "@", 
      RowBox[{"Rule", "[", 
       RowBox[{
        RowBox[{"DaggerIndex", "/@", 
         RowBox[{"(", 
          RowBox[{"List", "@@", "tempinds"}], ")"}]}], ",", 
        RowBox[{"DaggerIndex", "/@", 
         RowBox[{"List", "[", "inds", "]"}]}]}], "]"}]}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517821319030157*^9, 3.517821345850692*^9}, {
   3.51782140125286*^9, 3.5178214025639358`*^9}, {3.517821436285864*^9, 
   3.517821462674373*^9}, {3.517821517242495*^9, 3.517821531345301*^9}, {
   3.51782159811912*^9, 3.517821706579324*^9}, {3.51782173833714*^9, 
   3.517821761041439*^9}, {3.517821840923008*^9, 3.517821894133051*^9}, {
   3.517821972354525*^9, 3.517821981936074*^9}, {3.517822142748271*^9, 
   3.517822148773616*^9}, {3.517822326668791*^9, 3.51782235742655*^9}, {
   3.5178224435914783`*^9, 3.517822556470935*^9}, {3.517822775217447*^9, 
   3.517822793873513*^9}, {3.5178228553680305`*^9, 3.5178229609830713`*^9}, {
   3.5178229921918564`*^9, 3.51782299662611*^9}, {3.517823061597827*^9, 
   3.5178230799078736`*^9}, {3.517823126716551*^9, 3.5178232090172586`*^9}, {
   3.517823967929665*^9, 3.517823973873006*^9}, 3.51782411417103*^9, {
   3.517824197156777*^9, 3.5178242170199137`*^9}, {3.5178242573902216`*^9, 
   3.51782429687348*^9}, {3.517824353899742*^9, 3.51782442904804*^9}, 
   3.544672290887946*^9, 3.5830672044899206`*^9},
 CellLabel->
  "In[310]:=",ExpressionUUID->"61733ca5-6a96-480e-9d3a-785e0a8d4ee6"],

Cell["\<\
Dagger[tensor_?xTensorQ[inds___]] := Apply[Dagger[tensor], \
DaggerIndex@IndexList[inds]];\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{
  3.544672301198536*^9},ExpressionUUID->"c70ca9e1-4e08-4fd7-a565-\
0a80ffe4bf41"],

Cell["This might not be correct for all cases", "Text",
 CellChangeTimes->{{3.484481326103*^9, 
  3.484481333584*^9}},ExpressionUUID->"9929327a-52ef-46f6-a758-67045edef1c8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{"CovarD", "[", 
    RowBox[{
     RowBox[{"D1_", "?", "CovDQ"}], ",", 
     RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], ":=", 
  RowBox[{"CovarD", "[", 
   RowBox[{"D1", ",", 
    RowBox[{"Dagger", "[", "T", "]"}], ",", 
    RowBox[{"Dagger", "/@", "list"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.484481087683*^9, 3.484481119749*^9}, {3.484481320717*^9,
   3.484481358043*^9}, {3.484481388652*^9, 3.484481389725*^9}, {
  3.484481522849*^9, 3.484481523563*^9}},
 CellLabel->
  "In[311]:=",ExpressionUUID->"ad66e10d-e5b0-4fd5-b7da-1d6d6dce6501"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "Dagger", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.483874407259*^9, 3.483874412402*^9}, 
   3.484481085107001*^9},
 CellLabel->
  "In[312]:=",ExpressionUUID->"a4e196a5-40cb-4065-90b1-1c984138cb8d"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.9. Imposing the symmetry on expressions", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{
  3.5342489746233993`*^9},ExpressionUUID->"f1f1a845-7790-41c4-9529-\
71e15abd24fa"],

Cell["First some tools", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.590146574719618*^9, 
  3.5901465814900293`*^9}},ExpressionUUID->"6f159c65-3f3b-49a9-ad50-\
cda86a88d67f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateVBundles", "[", "inds_IndexList", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"VBundleOfIndexQ", ",", "VBlist", ",", "sepatatedinds"}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Temporary", " ", "function", " ", "for", " ", "checking", " ", "if", 
      " ", "an", " ", "index", " ", "belongs", " ", "to", " ", "VBundle1"}], 
     " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"VBundleOfIndexQ", "[", "VBundle1_", "]"}], ":=", 
      RowBox[{
       RowBox[{"VBundle1", "==", 
        RowBox[{"VBundleOfIndex", "[", "#", "]"}]}], "&"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"List", " ", "the", " ", "VBundles", " ", "in", " ", "inds"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"VBlist", "=", 
      RowBox[{"List", "@@", 
       RowBox[{"Union", "@", 
        RowBox[{"Sort", "[", 
         RowBox[{"VBundleOfIndex", "/@", "inds"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Separate", " ", "the", " ", "indices", " ", "according", " ", "to", 
       " ", "VBundles"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"sepatatedinds", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{"List", "@@", "inds"}], ",", 
          RowBox[{"VBundleOfIndexQ", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
       "VBlist"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Find", " ", "the", " ", "corresponding", " ", "position", " ", "in", 
       " ", "the", " ", "list", " ", "inds", " ", "and", " ", "retun", " ", 
       RowBox[{"that", "."}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"First", "@", 
          RowBox[{"First", "@", 
           RowBox[{"Position", "[", 
            RowBox[{"inds", ",", "#", ",", "1"}], "]"}]}]}], "&"}], "/@", 
        "#"}], "&"}], "/@", "sepatatedinds"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4799722613386*^9, 3.4799723513196*^9}, {
  3.4799724320856*^9, 3.4799724548456*^9}, {3.4799725009955997`*^9, 
  3.4799725025256*^9}},
 CellLabel->
  "In[313]:=",ExpressionUUID->"4ad1b13b-ccd9-4429-ac82-50f34026b4dd"],

Cell["\<\
The following code computes the strong generating set for a totally symmetric \
tensor/spinor. The symmetries are taken over the different VBundles separately.
This is important if the spinor has both primed and unprimed indices.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.4799347524272013`*^9, 3.4799347801462*^9}, {
  3.4799348597172008`*^9, 3.4799349471482*^9}, {3.4799355791432*^9, 
  3.4799356159792*^9}, {3.590146511492707*^9, 
  3.590146536983151*^9}},ExpressionUUID->"9237a952-0fc5-428d-9a75-\
2d3fbe733cdc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CompatibleSymmetric", "[", "inds_IndexList", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"VBundles", ",", "SGSlist"}], "}"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{"(*", " ", 
     RowBox[{
     "Compute", " ", "the", " ", "strong", " ", "generating", " ", "sets", 
      " ", "for", " ", "the", " ", "separate", " ", "symmetries"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"VBundles", "=", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"SeparateVBundles", "[", "inds", "]"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Length", "[", "#", "]"}], "\[GreaterEqual]", "2"}], ")"}],
          "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", "VBundles"}], "\[Equal]", "1"}], ",", 
       RowBox[{"SGSlist", "=", 
        RowBox[{"Symmetric", "/@", "VBundles"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SGSlist", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Symmetric", "[", 
            RowBox[{"#", ",", "Cycles"}], "]"}], "&"}], "/@", "VBundles"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Join", " ", "the", " ", "symmetries"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "SGSlist", "]"}], "\[GreaterEqual]", "2"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"SGSlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "=", 
            RowBox[{"JoinSGS", "[", 
             RowBox[{
              RowBox[{"SGSlist", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"SGSlist", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"SGSlist", "=", 
            RowBox[{"Delete", "[", 
             RowBox[{"SGSlist", ",", "1"}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Return", " ", "the", " ", "remaining", " ", "SGS", " ", "or", " ", 
       "the", " ", "trivial", " ", "SGS", " ", "if", " ", "the", " ", "list", 
       " ", "is", " ", 
       RowBox[{"empty", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "SGSlist", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{"First", "@", "SGSlist"}], ",", 
       RowBox[{"StrongGenSet", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", " ", 
         RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4799331619832*^9, 3.479933348434201*^9}, {
   3.4799334668772*^9, 3.4799334814542*^9}, 3.4799339041142*^9, {
   3.4799339385072*^9, 3.4799339931742*^9}, {3.4799340336422*^9, 
   3.4799340774812*^9}, {3.4799341704642*^9, 3.4799343251202*^9}, {
   3.4799343828392*^9, 3.4799344699502*^9}, {3.4799345604232*^9, 
   3.4799345794332*^9}, {3.4799346212042*^9, 3.4799347021462*^9}, {
   3.4799349605672*^9, 3.4799352532152*^9}, {3.4799726102076*^9, 
   3.4799726731535993`*^9}, {3.4957997936717997`*^9, 3.4957998121734*^9}, {
   3.4957999770341997`*^9, 3.4957999994982*^9}, {3.495800165263799*^9, 
   3.4958001732822*^9}, {3.4958002059954*^9, 3.495800324025*^9}, {
   3.4958003775018*^9, 3.4958003953482*^9}, {3.495800438841*^9, 
   3.4958004403073997`*^9}, {3.4958004734418*^9, 3.495800520663*^9}, {
   3.4958008822866*^9, 3.4958009030814*^9}, {3.4958009933742*^9, 
   3.4958009937642*^9}, {3.567861385048169*^9, 3.567861445357876*^9}, 
   3.5678639127996097`*^9},
 CellLabel->
  "In[314]:=",ExpressionUUID->"74662d44-d60f-4de1-9a69-b4332cf396f0"],

Cell["\<\
The same thing but just give it the VBundles. Perhaps the code above can be \
replaced by this.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.586844802332405*^9, 3.58684482269044*^9}, {
  3.586844855590898*^9, 3.586844865964916*^9}, {3.586844905042985*^9, 
  3.586844925323021*^9}},ExpressionUUID->"63517b4c-fa4a-4d35-a71b-\
0bbf55c5fb30"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CompatibleSym", "[", "vbundles_List", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sgs", "=", 
       RowBox[{"JoinSGS", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Symmetric", "[", 
            RowBox[{"#", ",", "Cycles"}], "]"}], "&"}], "/@", 
          RowBox[{"GatherBy", "[", 
           RowBox[{
            RowBox[{"Range", "@", 
             RowBox[{"Length", "@", "vbundles"}]}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"UpIndex", "/@", "vbundles"}], ")"}], "[", 
              RowBox[{"[", "#", "]"}], "]"}], "&"}]}], "]"}]}], ")"}]}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Last", "@", "sgs"}], "===", 
        RowBox[{"GenSet", "[", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"StrongGenSet", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       "sgs"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5868448328928585`*^9, 3.586844837838067*^9}, {
  3.586844909504593*^9, 3.586844910580994*^9}, {3.586865505581611*^9, 
  3.5868655970455723`*^9}, {3.586865971399429*^9, 3.58686597164903*^9}},
 CellLabel->
  "In[315]:=",ExpressionUUID->"9db952c5-3912-4259-b053-92226a0d2056"],

Cell["\<\
A second argument can be given to specify which VBundles we want to \
symmetrize over.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.586844802332405*^9, 3.58684482269044*^9}, {
  3.586844855590898*^9, 3.586844865964916*^9}, {3.586844905042985*^9, 
  3.586844925323021*^9}, {3.612006010198742*^9, 
  3.612006056248806*^9}},ExpressionUUID->"f8a98bb0-c23f-4203-8c9a-\
2c26aae8e4e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CompatibleSym", "[", 
    RowBox[{"vbundles_List", ",", "selectionVBs_List"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sgs", "=", 
       RowBox[{"JoinSGS", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Symmetric", "[", 
            RowBox[{"#", ",", "Cycles"}], "]"}], "&"}], "/@", 
          RowBox[{"(", 
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"GatherBy", "[", 
              RowBox[{
               RowBox[{"Range", "@", 
                RowBox[{"Length", "@", "vbundles"}]}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"UpIndex", "/@", "vbundles"}], ")"}], "[", 
                 RowBox[{"[", "#", "]"}], "]"}], "&"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"selectionVBs", ",", 
                RowBox[{"UpIndex", "@", 
                 RowBox[{"vbundles", "[", 
                  RowBox[{"[", 
                   RowBox[{"First", "[", "#", "]"}], "]"}], "]"}]}]}], "]"}], 
              "&"}]}], "]"}], ")"}]}], ")"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Last", "@", "sgs"}], "===", 
        RowBox[{"GenSet", "[", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"StrongGenSet", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       "sgs"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[316]:=",ExpressionUUID->"dad4b33a-caa9-4486-8168-c16353604594"],

Cell["Check if sym is CompatibleSym.", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.586844932155833*^9, 
  3.586844952716669*^9}},ExpressionUUID->"07446bdc-195f-43b4-9cec-\
1cb9594d7ff8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CompatibleSymQ", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "sym_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"OrderOfGroup", "@", "sym"}], "\[Equal]", "1"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.589787799218791*^9, 3.5897878096552095`*^9}},
 CellLabel->
  "In[317]:=",ExpressionUUID->"ad38cf6a-1007-4969-bcd8-45aa4663dc6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CompatibleSymQ", "[", 
   RowBox[{"vbundles_List", ",", "sym_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "@", "vbundles"}]}], ",", 
      RowBox[{"upvbundles", "=", 
       RowBox[{"UpIndex", "/@", "vbundles"}]}], ",", "disjsubgroups"}], "}"}],
     ",", 
    RowBox[{
     RowBox[{"disjsubgroups", "=", 
      RowBox[{"Symmetric", "/@", 
       RowBox[{"GatherBy", "[", 
        RowBox[{
         RowBox[{"Range", "@", "n"}], ",", 
         RowBox[{
          RowBox[{"upvbundles", "[", 
           RowBox[{"[", "#", "]"}], "]"}], "&"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SubgroupQ", "[", 
      RowBox[{
       RowBox[{"Join", "@@", 
        RowBox[{"(", 
         RowBox[{"GenSet", "/@", "disjsubgroups"}], ")"}]}], ",", "sym"}], 
      "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.589787733963877*^9, 3.589787734884279*^9}},
 CellLabel->
  "In[318]:=",ExpressionUUID->"e6c27c90-7a63-4087-a713-4cb4b41f8cf1"],

Cell["\<\
A third argument can be given to specify which VBundles we want to symmetrize \
over.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.586844802332405*^9, 3.58684482269044*^9}, {
  3.586844855590898*^9, 3.586844865964916*^9}, {3.586844905042985*^9, 
  3.586844925323021*^9}, {3.612006010198742*^9, 3.612006056248806*^9}, {
  3.620803341450242*^9, 
  3.6208033445502462`*^9}},ExpressionUUID->"d3225405-1254-43e2-a479-\
f900378a432d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CompatibleSymQ", "[", 
   RowBox[{"vbundles_List", ",", "sym_", ",", "selectionVBs_List"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "@", "vbundles"}]}], ",", "disjsubgroups"}], "}"}], 
    ",", 
    RowBox[{
     RowBox[{"disjsubgroups", "=", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Symmetric", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"(", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"GatherBy", "[", 
            RowBox[{
             RowBox[{"Range", "@", "n"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"UpIndex", "/@", "vbundles"}], ")"}], "[", 
               RowBox[{"[", "#", "]"}], "]"}], "&"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{"selectionVBs", ",", 
              RowBox[{"UpIndex", "@", 
               RowBox[{"vbundles", "[", 
                RowBox[{"[", 
                 RowBox[{"First", "[", "#", "]"}], "]"}], "]"}]}]}], "]"}], 
            "&"}]}], "]"}], ")"}]}], ")"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", "disjsubgroups"}], "\[Equal]", "0"}], ",", 
       "True", ",", "\[IndentingNewLine]", 
       RowBox[{"SubgroupQ", "[", 
        RowBox[{
         RowBox[{"Join", "@@", 
          RowBox[{"(", 
           RowBox[{"GenSet", "/@", "disjsubgroups"}], ")"}]}], ",", "sym"}], 
        "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.620803349550253*^9, 3.6208033586102657`*^9}, {
  3.620803419180351*^9, 3.6208034634204125`*^9}, {3.6208035035504684`*^9, 
  3.620803528430504*^9}, {3.620803559650547*^9, 3.620803607510615*^9}, {
  3.620803872930986*^9, 3.6208038731909866`*^9}, {3.6208055759943705`*^9, 
  3.620805619554431*^9}, {3.620806106356113*^9, 3.6208061069861135`*^9}},
 CellLabel->
  "In[319]:=",ExpressionUUID->"0dc57a64-e06e-4896-863b-f1967f54cd60"],

Cell["\<\
Refer back to the previous code for tensors or product of tensors\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.4806821725030003`*^9, 
  3.4806821928142*^9}},ExpressionUUID->"ef93301e-1de5-4dac-8bdf-85430c8e2f74"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TimesToList", "[", "expr_Times", "]"}], ":=", 
  RowBox[{"List", "@@", "expr"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4955433817104*^9, 3.4955433834576*^9}, {
  3.544091693999056*^9, 3.5440917052310762`*^9}},
 CellLabel->
  "In[320]:=",ExpressionUUID->"9c37921c-c87b-4abc-b656-47e921032fe3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TimesToList", "[", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`VerbatimProduct", "[", "Times", "]"}], "[", 
    "expr__", "]"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"List", "[", "expr", "]"}], "/.", 
    RowBox[{
     RowBox[{"xAct`xTensor`Private`Scalar1", "[", "Scalarexpr_", "]"}], ":>", 
     "Scalarexpr"}]}], ")"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4806762786095*^9, 3.4806762946307*^9}, {
   3.4807491566442003`*^9, 3.4807491571278*^9}, {3.494761612803*^9, 
   3.4947616148778*^9}, {3.4955419456368*^9, 3.4955419466352*^9}, {
   3.495542846256*^9, 3.495542867394*^9}, {3.495543372756*^9, 
   3.495543374659199*^9}, {3.544091722001106*^9, 3.544091727071114*^9}, {
   3.54409202693484*^9, 3.544092047714077*^9}, 3.58306592289987*^9, {
   3.583066263340268*^9, 3.583066297020727*^9}},
 CellLabel->
  "In[321]:=",ExpressionUUID->"976a9fda-7f09-4cb9-b2f0-02e726f5d29d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TimesToList", "[", 
   RowBox[{
    RowBox[{"T_", "?", "xTensorQ"}], "[", "tensorinds__", "]"}], "]"}], ":=", 
  
  RowBox[{"List", "[", 
   RowBox[{"T", "[", "tensorinds", "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4806762065063*^9, 3.4806762583763*^9}, {
   3.4807491557862*^9, 3.4807491562386*^9}, 3.4947615916182003`*^9, {
   3.495541954138799*^9, 3.4955419576331997`*^9}, {3.4955428855836*^9, 
   3.4955428991712*^9}},
 CellLabel->
  "In[322]:=",ExpressionUUID->"ffc79642-6afe-44fc-9e95-148b3237c5e3"],

Cell["Main code", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.590146711517258*^9, 
  3.5901467164156666`*^9}},ExpressionUUID->"48a6352a-6fc4-4b0d-9825-\
595e2e95c747"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ImposeSym", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ImposeLargerSym", "\[Rule]", "False"}], ",", 
     RowBox[{"ImposeSuperfluousSym", "\[Rule]", "False"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5342491897633777`*^9, 3.5342492062994065`*^9}, {
  3.544102602591416*^9, 3.544102669624734*^9}},
 CellLabel->
  "In[323]:=",ExpressionUUID->"04a190fc-6b47-4d12-85c3-a986b135523d"],

Cell["Shortcuts", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.4806821620198*^9, 3.480682165561*^9}, {
  3.5901454047955627`*^9, 
  3.5901454110823736`*^9}},ExpressionUUID->"a0411cda-a569-4804-a31d-\
400b48eec564"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ImposeSym", "[", "0", "]"}], ":=", "0"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeSym", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
  RowBox[{"ImposeSym", "[", 
   RowBox[{"expr", ",", 
    RowBox[{"FindFreeIndices", "[", "expr", "]"}], ",", "options"}], 
   "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515751723874195*^9, 3.5157517414441996`*^9}, {
  3.544103198247263*^9, 3.544103205454475*^9}, {3.561373137131548*^9, 
  3.5613731442139606`*^9}},
 CellLabel->
  "In[324]:=",ExpressionUUID->"ea314316-4233-47b4-8ab2-8e27e048416d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym", "[", 
   RowBox[{"expr_", ",", "inds_", ",", 
    RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
  RowBox[{"ImposeSym", "[", 
   RowBox[{"expr", ",", "inds", ",", 
    RowBox[{"CompatibleSymmetric", "[", "inds", "]"}], ",", "options"}], 
   "]"}], " "}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4807494258378*^9, 3.4807494375534*^9}, {
   3.544103208808481*^9, 3.5441032345173273`*^9}, 3.561373150875172*^9},
 CellLabel->
  "In[326]:=",ExpressionUUID->"0548fe26-ecfb-4a65-a276-c8a4c1172561"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym", "[", 
   RowBox[{"expr_", ",", "imposedinds_", ",", "sym_GenSet", ",", 
    RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"PermLength", "[", "sym", "]"}]}], ",", "unstableslots", ",", 
      "SGS"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"unstableslots", "=", 
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"Range", "@", "n"}], ",", 
        RowBox[{"StablePoints", "[", 
         RowBox[{"sym", ",", "n"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SGS", "=", 
      RowBox[{"SchreierSims", "[", 
       RowBox[{"unstableslots", ",", "sym"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ImposeSym", "[", 
      RowBox[{"expr", ",", "imposedinds", ",", "SGS", ",", "options"}], 
      "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.519299081971335*^9, 3.519299126509413*^9}, {
   3.519299161219474*^9, 3.5192991977859383`*^9}, {3.519299310122735*^9, 
   3.519299364426431*^9}, {3.519299442566968*^9, 3.519299510395887*^9}, {
   3.5192995987856426`*^9, 3.5192996273492928`*^9}, 3.544102761415295*^9, {
   3.5441027924905496`*^9, 3.544102801725766*^9}, 3.590146058764312*^9, 
   3.5901463860840864`*^9, {3.59014643427257*^9, 3.5901464413861833`*^9}},
 CellLabel->
  "In[327]:=",ExpressionUUID->"2b6e2095-4134-4a33-9f04-44f337f8afe4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"IndexList", "[", "___", "]"}], ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "___", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "other___"}], "]"}], ":=", 
  "expr"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.5901458402235274`*^9},
 CellLabel->
  "In[328]:=",ExpressionUUID->"b98c1afa-e0f1-4822-91f6-93d831dc46a4"],

Cell["Step 0: Expand input.", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.5901453856075287`*^9, 3.590145389710336*^9}, {
  3.590145619061939*^9, 
  3.5901456257543507`*^9}},ExpressionUUID->"3de7d3c3-9a6b-4db3-9ac2-\
2ecb8de4953c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym", "[", 
   RowBox[{"expr_", ",", "inds_", ",", "sym_", ",", 
    RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`MathInputExpand", "@", "expr"}], ",", 
    "inds", ",", "sym", ",", "options"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590145415731182*^9, 3.590145451346044*^9}, {
   3.5901455140113544`*^9, 3.590145533916989*^9}, 3.590145633850765*^9},
 CellLabel->
  "In[329]:=",ExpressionUUID->"3ae4a63a-53ea-427a-afff-dc176717d52a"],

Cell["Step 1: Reduce to a product of tensors", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.590145392643141*^9, 3.590145395185945*^9}, {
  3.590145628421955*^9, 3.5901456285623555`*^9}, {3.5901456617748137`*^9, 
  3.590145663085216*^9}, {3.590145735859344*^9, 
  3.590145740289752*^9}},ExpressionUUID->"24a3d157-bc62-4e2b-a1f0-\
00c1323cef5c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{"expr_Plus", ",", "other__"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"ImposeSym1", "[", 
     RowBox[{"#", ",", "other"}], "]"}], "&"}], "/@", "expr"}]}], "\n", 
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{"0", ",", "other__"}], "]"}], ":=", "0"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.5901459387689*^9},
 CellLabel->
  "In[330]:=",ExpressionUUID->"98d5825a-271d-4d34-9417-30746fe9fce9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "?", "ConstantQ"}], " ", "y_"}], ",", "other__"}], "]"}], ":=", 
  RowBox[{"x", " ", 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{"y", ",", "other"}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Scalar", "[", "x_", "]"}], " ", "y_"}], ",", "other__"}], "]"}],
   ":=", 
  RowBox[{
   RowBox[{"Scalar", "[", "x", "]"}], " ", 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{"y", ",", "other"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F_", "?", "ScalarFunctionQ"}], ")"}], "[", 
      RowBox[{"Scalar", "[", "x_", "]"}], "]"}], "y_"}], ",", "other__"}], 
   "]"}], ":=", 
  RowBox[{
   RowBox[{"F", "[", 
    RowBox[{"Scalar", "[", "x", "]"}], "]"}], " ", 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{"y", ",", "other"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F_", "?", "ScalarFunctionQ"}], ")"}], "[", 
      RowBox[{
       RowBox[{"x_", "?", "xTensorQ"}], "[", "]"}], "]"}], "y_"}], ",", 
    "other__"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"F", "[", 
    RowBox[{"x", "[", "]"}], "]"}], " ", 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{"y", ",", "other"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "?", "ScalarQ"}], " ", "y_"}], ",", "other__"}], "]"}], ":=", 
  RowBox[{"x", " ", 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{"y", ",", "other"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{"x___", ",", 
      RowBox[{
       RowBox[{"y_", "?", "xTensorQ"}], "[", "]"}], ",", "z___"}], "]"}], ",",
     "other__"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"y", "[", "]"}], 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{
     RowBox[{"Times", "[", 
      RowBox[{"x", ",", "z"}], "]"}], ",", "other"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{"x___", ",", 
      RowBox[{"Power", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y_", "?", "xTensorQ"}], "[", "]"}], ",", "n_"}], "]"}], ",",
       "z___"}], "]"}], ",", "other__"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Power", "[", 
    RowBox[{
     RowBox[{"y", "[", "]"}], ",", "n"}], "]"}], 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{
     RowBox[{"Times", "[", 
      RowBox[{"x", ",", "z"}], "]"}], ",", "other"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{"x___", ",", 
      RowBox[{"Power", "[", 
       RowBox[{
        RowBox[{"Scalar", "[", "y_", "]"}], ",", "n_"}], "]"}], ",", "z___"}],
      "]"}], ",", "other__"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Power", "[", 
    RowBox[{
     RowBox[{"Scalar", "[", "y", "]"}], ",", "n"}], "]"}], 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{
     RowBox[{"Times", "[", 
      RowBox[{"x", ",", "z"}], "]"}], ",", "other"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{"x___", ",", 
      RowBox[{"Power", "[", 
       RowBox[{
        RowBox[{"y_", "?", "ScalarQ"}], " ", ",", "n_"}], "]"}], ",", 
      "z___"}], "]"}], ",", "other__"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Power", "[", 
    RowBox[{"y", ",", "n"}], "]"}], 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{
     RowBox[{"Times", "[", 
      RowBox[{"x", ",", "z"}], "]"}], ",", "other"}], "]"}]}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4806759047243*^9, 3.4806759433810997`*^9}, {
   3.4806760007267*^9, 3.4806760008827*^9}, {3.4806762501707*^9, 
   3.4806762543827*^9}, {3.4807491477678003`*^9, 3.4807491528378*^9}, {
   3.5069296016964006`*^9, 3.506929626048*^9}, {3.530339204989964*^9, 
   3.5303392629752655`*^9}, {3.530339346225594*^9, 3.530339379356488*^9}, {
   3.530339559327782*^9, 3.5303395965239096`*^9}, {3.530339653832188*^9, 
   3.53033966855503*^9}, {3.530339718859907*^9, 3.5303397560450344`*^9}, {
   3.561373057914609*^9, 3.561373078147845*^9}, {3.561373111890704*^9, 
   3.5613731141995077`*^9}, {3.590145542465804*^9, 3.590145591761891*^9}, {
   3.5901456358631682`*^9, 3.590145637859972*^9}, {3.5901457447045593`*^9, 
   3.590145783283427*^9}, 3.590145934525693*^9, {3.5901459781121693`*^9, 
   3.5901459784241705`*^9}, {3.5908341902820997`*^9, 3.5908341976321096`*^9}},
 
 CellLabel->
  "In[332]:=",ExpressionUUID->"5806d19d-c8ab-4a06-bc6b-49e23a35c56e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"z", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x_", "?", "InertHeadQ"}], "[", "___", "]"}], ")"}]}], ",", 
    "other__"}], "]"}], ":=", 
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"ToInertHeadHead", "[", "z", "]"}], ",", "other"}], "]"}], 
  " "}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.483860979855*^9, 3.483861007936*^9}, {3.48386168912*^9, 
  3.483861695065*^9}, {3.5901460344282675`*^9, 3.5901460365654726`*^9}},
 CellLabel->
  "In[341]:=",ExpressionUUID->"038b30b9-e251-4a0b-8cc3-a61cafec7761"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"z", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"x_", "?", "CovDQ"}], "[", "__", "]"}], "[", "y_", "]"}], 
      ")"}]}], ",", "other__"}], "]"}], ":=", 
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"ToCovarD", "[", "z", "]"}], ",", "other"}], "]"}], 
  " "}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4806758451635*^9, 3.4806758486423*^9}, {
  3.4806760720811*^9, 3.4806761764451*^9}, {3.4807603784282*^9, 
  3.4807603817666*^9}, {3.4807618903802*^9, 3.4807619147162*^9}, {
  3.4807662153398*^9, 3.480766216385*^9}, {3.59014603527067*^9, 
  3.5901460370178733`*^9}},
 CellLabel->
  "In[342]:=",ExpressionUUID->"1fffda27-9465-43d0-b39c-2ecd19875f4f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"LieD", "[", "dir_", "]"}], "[", "expr_", "]"}], ",", 
    "other___"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"LieD", "[", "dir", "]"}], "@", 
   RowBox[{"ImposeSym1", "[", 
    RowBox[{"expr", ",", "other"}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.549022432619244*^9, 3.549022437002851*^9}, {
  3.590146037844674*^9, 3.590146039669878*^9}},
 CellLabel->
  "In[343]:=",ExpressionUUID->"41ac4a7c-a42a-4d59-a9da-bbb46e69ff99"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{"z___", ",", 
      RowBox[{"x", ":", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"_", "?", "InertHeadQ"}], "[", "___", "]"}], ")"}]}], ",", 
      "y___"}], "]"}], ",", "other__"}], "]"}], ":=", 
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{"z", ",", 
      RowBox[{"ToInertHeadHead", "[", "x", "]"}], ",", "y"}], "]"}], ",", 
    "other"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.483861026851*^9, 3.483861043075*^9}, 
   3.4838617091610007`*^9, {3.5901460419162817`*^9, 3.5901460423998823`*^9}},
 CellLabel->
  "In[344]:=",ExpressionUUID->"979af3ed-596a-4ef3-9daf-16bbec0646ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{"z___", ",", 
      RowBox[{"x", ":", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"_", "?", "CovDQ"}], "[", "___", "]"}], "[", "___", "]"}], 
        ")"}]}], ",", "y___"}], "]"}], ",", "other__"}], "]"}], ":=", 
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{"z", ",", 
      RowBox[{"ToCovarD", "[", "x", "]"}], ",", "y"}], "]"}], ",", "other"}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4806762786095*^9, 3.4806762946307*^9}, {
  3.4806768764795*^9, 3.4806769236695*^9}, {3.4806770221835003`*^9, 
  3.4806770545223*^9}, {3.4806771437699003`*^9, 3.4806771471707*^9}, {
  3.480760383311*^9, 3.4807603884746*^9}, {3.4807619213774*^9, 
  3.4807619367902*^9}, {3.4807624610594*^9, 3.4807625195906*^9}, {
  3.4807625864054008`*^9, 3.4807625968262*^9}, {3.4807662173522*^9, 
  3.4807662200354*^9}, {3.5901460430394835`*^9, 3.590146043616685*^9}},
 CellLabel->
  "In[345]:=",ExpressionUUID->"be1c5e1e-22bd-4bb5-92c6-6050896a99b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{"expr", ":", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"_", "?", "xTensorQ"}], "[", "__", "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"_", "?", "xTensorQ"}], "[", "__", "]"}], "..."}]}], "]"}]}],
     ",", "other__"}], "]"}], ":=", 
  RowBox[{"ImposeSym2", "[", 
   RowBox[{"expr", ",", "other"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4806762786095*^9, 3.4806762946307*^9}, {
  3.4807491566442003`*^9, 3.4807491571278*^9}, {3.494761612803*^9, 
  3.4947616148778*^9}, {3.4955419456368*^9, 3.4955419466352*^9}, {
  3.4955430588684*^9, 3.4955430600852*^9}, {3.495544648446*^9, 
  3.4955446646076*^9}, {3.544091834071702*^9, 3.5440918589849463`*^9}, {
  3.590146045223488*^9, 3.590146046736691*^9}},
 CellLabel->
  "In[346]:=",ExpressionUUID->"19600e6e-241c-48ad-8e94-960b8d5d4937"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"T_", "?", "xTensorQ"}], "[", "tensorinds__", "]"}], ",", 
    "other__"}], "]"}], ":=", 
  RowBox[{"ImposeSym2", "[", 
   RowBox[{
    RowBox[{"T", "[", "tensorinds", "]"}], ",", "other"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4806762065063*^9, 3.4806762583763*^9}, {
   3.4807491557862*^9, 3.4807491562386*^9}, 3.4947615916182003`*^9, {
   3.495541954138799*^9, 3.4955419576331997`*^9}, {3.495543062862*^9, 
   3.4955430656544*^9}, {3.4955446683828*^9, 3.4955446743576*^9}, {
   3.590146048561894*^9, 3.5901460509018974`*^9}},
 CellLabel->
  "In[347]:=",ExpressionUUID->"cfa08c52-dd51-4213-99b3-11d15b9723b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym1", "[", "other__", "]"}], ":=", 
  RowBox[{"Throw", "@", 
   RowBox[{"Message", "[", 
    RowBox[{
     RowBox[{"ImposeSym", "::", "error"}], ",", 
     "\"\<Unable to impose symmetry: ImposeSym[\>\"", ",", 
     RowBox[{"StringJoin", "@@", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"ToString", "/@", 
         RowBox[{"{", "other", "}"}]}], ",", "\"\<,\>\""}], "]"}]}], ",", 
     "\"\<]\>\""}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590146139026452*^9, 3.590146284574708*^9}},
 CellLabel->
  "In[348]:=",ExpressionUUID->"8ca71300-591c-4478-a412-4be61162b7bc"],

Cell["Step 2: Impose symmetry on product of tensors.", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.5901453192606125`*^9, 3.5901453238002195`*^9}, {
  3.590146459404215*^9, 
  3.590146478358248*^9}},ExpressionUUID->"9dad8cc5-2b53-4b47-bad5-\
a476627e2b56"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSym2", "[", 
   RowBox[{"expr_", ",", "imposedinds_", ",", 
    RowBox[{"sym", ":", 
     RowBox[{"(", 
      RowBox[{"_StrongGenSet", "|", "_Symmetric", "|", "_Antisymmetric"}], 
      ")"}]}], ",", 
    RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "LargerSymOption", ",", "SuperfluousSymOption", ",", "n", ",", 
      "slotexpr", ",", "slotrules", ",", "internalsym", ",", "slotexprlist", 
      ",", " ", "slotlist1", ",", " ", "slotlist2", ",", "HeadList", ",", " ",
       "tensorinds", ",", "imposedorderinds", ",", "extendedtensorinds", ",", 
      "perm1", ",", "perm2", ",", "newsym", ",", "newlabel", ",", " ", 
      "deltapos", ",", " ", "deltareplacements"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"LargerSymOption", ",", "SuperfluousSymOption"}], "}"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"ImposeLargerSym", ",", "ImposeSuperfluousSym"}], "}"}], "/.", 
        RowBox[{"CheckOptions", "[", "options", "]"}]}], "/.", 
       RowBox[{"Options", "[", "ImposeSym", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"And", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", 
           RowBox[{"GroupSupport", "@", "sym"}]}], "\[Equal]", "0"}], ",", 
         RowBox[{"Not", "@", "SuperfluousSymOption"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"expr", "//.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"x", ":", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"CovarD", "[", "__", "]"}], "[", "___", "]"}], ")"}]}], 
           ":>", 
           RowBox[{"ExpandCovarD", "[", "x", "]"}]}], ",", 
          RowBox[{
           RowBox[{"x", ":", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"InertHeadHead", "[", "__", "]"}], "[", "___", "]"}], 
             ")"}]}], ":>", 
           RowBox[{"ExpandInertHeadHead", "[", "x", "]"}]}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "n", ",", "slotexpr", ",", "slotrules", ",", "internalsym"}], "}"}],
          "=", 
         RowBox[{"List", "@@", 
          RowBox[{"SymmetryOf", "[", "expr", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Sort", " ", "the", " ", "tensors"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"slotexprlist", "=", 
         RowBox[{"Sort", "@", 
          RowBox[{"TimesToList", "[", "slotexpr", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"slotlist1", "=", 
         RowBox[{"Join", "@@", 
          RowBox[{"List", "@@@", "slotexprlist"}]}]}], ";", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Remove", " ", "slots", " ", "that", " ", "does", " ", "not", " ", 
          "contain", " ", "abstract", " ", "indices"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"slotlist2", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"slotlist1", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "#", "]"}], "===", 
             "xAct`xTensor`Private`slot"}], "&"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"HeadList", "=", 
         RowBox[{"Head", "/@", "slotexprlist"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "We", " ", "need", " ", "to", " ", "replace", " ", "deltas", " ", 
          "with", " ", "metrics", " ", "or", " ", "deltaH", " ", "that", " ", 
          "carries", " ", "its", " ", "VBundle"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"deltapos", "=", 
         RowBox[{"First", "/@", 
          RowBox[{"Position", "[", 
           RowBox[{"HeadList", ",", "delta", ",", "1"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "deltapos"}], ">", "0"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"deltareplacements", "=", 
            RowBox[{"MetricOrdeltaHOfVBundle", "/@", 
             RowBox[{"VBundleOfIndex", "/@", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"First", "/@", 
                  RowBox[{"Part", "[", 
                   RowBox[{"slotexprlist", ",", "deltapos"}], "]"}]}], ")"}], 
                "/.", "slotrules"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"HeadList", "=", 
            RowBox[{"ReplacePart", "[", 
             RowBox[{"HeadList", ",", 
              RowBox[{"Thread", "@", 
               RowBox[{"Rule", "[", 
                RowBox[{
                "deltapos", ",", "\[InvisibleSpace] ", "deltareplacements"}], 
                "]"}]}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"tensorinds", "=", 
         RowBox[{"slotlist1", "/.", "slotrules"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "If", " ", "we", " ", "have", " ", "indices", " ", "in", " ", "the", 
          " ", "sym", " ", "that", " ", "are", " ", "not", " ", "in", " ", 
          "tensorinds"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"extendedtensorinds", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"tensorinds", ",", 
           RowBox[{"Complement", "[", 
            RowBox[{
             RowBox[{"List", "@@", "imposedinds"}], ",", "tensorinds"}], 
            "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"imposedorderinds", "=", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"List", "@@", "imposedinds"}], ",", 
           RowBox[{"Cases", "[", 
            RowBox[{"tensorinds", ",", 
             RowBox[{"Except", "[", 
              RowBox[{"Alternatives", "@@", "imposedinds"}], "]"}]}], "]"}]}],
           "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"perm1", "=", 
         RowBox[{"TranslatePerm", "[", 
          RowBox[{
           RowBox[{"PermutationFromTo", "[", 
            RowBox[{"imposedorderinds", ",", "extendedtensorinds"}], "]"}], 
           ",", "Rules"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"newsym", "=", 
         RowBox[{"sym", "/.", 
          RowBox[{"List", "@@", "perm1"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "The", " ", "extra", " ", "indices", " ", "in", " ", "the", " ", 
           "sym", " ", "that", " ", "are", " ", "not", " ", "in", " ", 
           "tensorinds"}], ",", " ", 
          RowBox[{
          "does", " ", "not", " ", "act", " ", "on", " ", "anything", " ", 
           "so", " ", "stabilize", " ", "these", " ", 
           RowBox[{"points", "."}]}]}], "*)"}], " ", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Changed", " ", "to", " ", "StabilizerSGS", " ", "instead", " ", 
          "of", " ", "Stabilizer"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"newsym", "=", 
         RowBox[{"StabilizerSGS", "[", 
          RowBox[{
           RowBox[{"Range", "[", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{"Length", "@", "tensorinds"}]}], ",", 
             RowBox[{"Length", "@", "extendedtensorinds"}]}], "]"}], ",", 
           "newsym"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"newsym", "=", 
         RowBox[{"TidyGroup", "@", "newsym"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"perm2", "=", 
         RowBox[{"TranslatePerm", "[", 
          RowBox[{
           RowBox[{"PermutationFromTo", "[", 
            RowBox[{
             RowBox[{"slot", "/@", 
              RowBox[{"Range", "@", "n"}]}], ",", "slotlist2"}], "]"}], ",", 
           "Rules"}], "]"}]}], ";", 
        RowBox[{"internalsym", "=", 
         RowBox[{"internalsym", "/.", 
          RowBox[{"List", "@@", "perm2"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"internalsym", "=", 
         RowBox[{"TidyGroup", "@", "internalsym"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Simplify", " ", "if", " ", "possible"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MinusIDInProductQ", "[", 
           RowBox[{"newsym", ",", "internalsym"}], "]"}], ",", 
          "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"Not", "@", "SuperfluousSymOption"}], ",", 
              RowBox[{"SubgroupQ", "[", 
               RowBox[{"newsym", ",", "internalsym"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ExpandCovarDAndInertHeadHead", "[", "expr", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"LargerSymOption", ",", "\[IndentingNewLine]", 
              RowBox[{"Module", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"LargerGroup", ",", " ", 
                  RowBox[{"tempsymhead", "=", 
                   RowBox[{"SymH", "[", 
                    RowBox[{"HeadList", ",", "newsym", ",", 
                    RowBox[{"DefaultLabelSym", "[", "newsym", "]"}]}], 
                    "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"LargerGroup", "=", 
                  RowBox[{"SymmetryGroupOfTensor", "@", "tempsymhead"}]}], 
                 ";", "\[IndentingNewLine]", 
                 RowBox[{"newlabel", "=", 
                  RowBox[{"DefaultLabelSym", "[", "LargerGroup", "]"}]}], ";",
                  "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"SymH", "[", 
                   RowBox[{"HeadList", ",", "LargerGroup", ",", "newlabel"}], 
                   "]"}], "[", 
                  RowBox[{"Sequence", "@@", "tensorinds"}], "]"}]}]}], "]"}], 
              ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"SymH", "[", 
                RowBox[{"HeadList", ",", "newsym", ",", 
                 RowBox[{"DefaultLabelSym", "[", "newsym", "]"}]}], "]"}], 
               "[", 
               RowBox[{"Sequence", "@@", "tensorinds"}], "]"}]}], "]"}]}], 
           "]"}]}], "]"}]}]}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.526045175351662*^9, 3.5260452437545753`*^9}, {
   3.526049262340657*^9, 3.526049277051483*^9}, {3.53769451778975*^9, 
   3.537694554293815*^9}, {3.537694740824342*^9, 3.537694741853944*^9}, {
   3.537694820150481*^9, 3.53769485306654*^9}, {3.537695369021845*^9, 
   3.537695372812652*^9}, {3.5376954586128025`*^9, 3.537695489906458*^9}, {
   3.537695553429769*^9, 3.5376955698877983`*^9}, {3.537695779037366*^9, 
   3.537695811190022*^9}, {3.537695866211319*^9, 3.5376959024345827`*^9}, {
   3.537696094283719*^9, 3.537696108682545*^9}, {3.537696168274649*^9, 
   3.5376961848262787`*^9}, {3.53769633365054*^9, 3.5376963857858315`*^9}, {
   3.537696543455309*^9, 3.537696565732147*^9}, {3.53769698325228*^9, 
   3.537697021004347*^9}, {3.5376970787088485`*^9, 3.537697088396466*^9}, {
   3.5376972510423517`*^9, 3.537697327513685*^9}, {3.53769740414102*^9, 
   3.537697444451491*^9}, 3.5441028149857893`*^9, {3.544102893017126*^9, 
   3.544103031404969*^9}, {3.544103093992279*^9, 3.544103149699977*^9}, {
   3.54410760895521*^9, 3.544107612855217*^9}, 3.563428670135927*^9, {
   3.5678605942037807`*^9, 3.5678606151702175`*^9}, {3.567860669723513*^9, 
   3.567860724666809*^9}, {3.567860761904075*^9, 3.5678608031817474`*^9}, {
   3.567861573153301*^9, 3.567861600593748*^9}, {3.567861693944312*^9, 
   3.567861694334313*^9}, {3.567861791179283*^9, 3.567861791444484*^9}, {
   3.5678620138696737`*^9, 3.56786201759808*^9}, {3.567862151695916*^9, 
   3.5678621866243777`*^9}, 3.567862754279175*^9, {3.5679129491658506`*^9, 
   3.567913041081212*^9}, {3.567913395217434*^9, 3.5679134138438663`*^9}, {
   3.5689548532108946`*^9, 3.56895489072896*^9}, {3.574830260476557*^9, 
   3.574830314109451*^9}, {3.574830346526308*^9, 3.5748303663695426`*^9}, {
   3.574831933408895*^9, 3.574831950085325*^9}, 3.590146361482843*^9, {
   3.590147112281962*^9, 3.5901471195671744`*^9}, {3.6196885704675083`*^9, 
   3.619688570947509*^9}, {3.619688659627633*^9, 3.619688675817655*^9}},
 CellLabel->
  "In[349]:=",ExpressionUUID->"fc0b6437-81ec-41bb-99e6-812c8b6c1cca"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.10. SmartSymmetrize and SmartAntisymmetrize", "Subsubsection",
 CellChangeTimes->{{3.534248977275404*^9, 3.534248977837005*^9}, {
  3.5446725248283267`*^9, 
  3.544672545983537*^9}},ExpressionUUID->"81dbbfb2-8704-42ec-8c83-\
ad885e6a597e"],

Cell["\<\
These are new tools to compute ToCanonical@Symmetrize[expr, inds] quicker. \
Observe that ToCanonical might still be needed, but the number of \
intermediate terms should be greatly reduced. In principle a general \
SmartImposeSymmetry should work, but my current code for computing the mixed \
symmetries for a general imposed symmetry is way too slow to be useful for \
this purpose.\
\>", "Text",
 CellChangeTimes->{{3.544672834529041*^9, 
  3.544673086125431*^9}},ExpressionUUID->"47fa77b6-c40a-4a0f-af91-\
c790ca8d05ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SmartSymmetrize", "[", "expr_", "]"}], ":=", 
   RowBox[{"SmartSymmetrize", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"FindFreeIndices", "[", "expr", "]"}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.5446725493367286`*^9, 3.544672610422222*^9}},
 CellLabel->
  "In[350]:=",ExpressionUUID->"c19f08b2-aabb-4bf8-b45f-dd41fb52ebfd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SmartSymmetrize", "[", 
    RowBox[{"expr_", ",", "inds_"}], "]"}], ":=", 
   RowBox[{"ExpandSym", "[", 
    RowBox[{
     RowBox[{"ImposeSym", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndexList", "@@", "inds"}], ",", 
       RowBox[{"Symmetric", "@", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", "inds"}]}]}], ",", 
       RowBox[{"ImposeSuperfluousSym", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"SmartExpand", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5446726162125535`*^9, 3.544672620663808*^9}, {
  3.5446727576526446`*^9, 3.544672781140988*^9}, {3.544674203282329*^9, 
  3.544674205088433*^9}},
 CellLabel->
  "In[351]:=",ExpressionUUID->"c00e4f1f-3588-4196-a885-98252c3ede81"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SmartAntisymmetrize", "[", "expr_", "]"}], ":=", 
   RowBox[{"SmartAntisymmetrize", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"FindFreeIndices", "[", "expr", "]"}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.5446725493367286`*^9, 3.544672610422222*^9}, {
  3.5446727910835557`*^9, 3.544672806416433*^9}},
 CellLabel->
  "In[352]:=",ExpressionUUID->"de959a69-b994-4a78-a069-91a49ac0c400"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SmartAntisymmetrize", "[", 
    RowBox[{"expr_", ",", "inds_"}], "]"}], ":=", 
   RowBox[{"ExpandSym", "[", 
    RowBox[{
     RowBox[{"ImposeSym", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"IndexList", "@@", "inds"}], ",", 
       RowBox[{"Antisymmetric", "@", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", "inds"}]}]}], ",", 
       RowBox[{"ImposeSuperfluousSym", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"SmartExpand", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5446726162125535`*^9, 3.544672620663808*^9}, {
  3.5446727576526446`*^9, 3.5446728110676985`*^9}, {3.544674208081603*^9, 
  3.544674209494684*^9}},
 CellLabel->
  "In[353]:=",ExpressionUUID->"92575d99-27fd-4c4c-bd0c-0f739564cc51"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.11. More tools", "Subsubsection",
 CellChangeTimes->{{3.534248977275404*^9, 3.534248977837005*^9}, 
   3.544672517625915*^9},ExpressionUUID->"1cd75ea0-6f19-4a37-85d6-\
d2febc7668c0"],

Cell["Sorting the Heads in the SymH object", "Text",
 CellChangeTimes->{{3.4806823479874*^9, 3.4806823579558*^9}, {
  3.515750296499554*^9, 
  3.5157503104833536`*^9}},ExpressionUUID->"54704209-4952-4358-a751-\
455c8290909c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SortTensorsInSym1", "[", 
   RowBox[{
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", "inds___",
     "]"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"sortedheads", "=", 
       RowBox[{"Sort", "[", "headlist", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"slotlist", "=", 
       RowBox[{"IndexList", "@@", 
        RowBox[{"slot", "/@", 
         RowBox[{"Range", "@", 
          RowBox[{"Length", "@", 
           RowBox[{"List", "[", "inds", "]"}]}]}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"numindices", "=", 
       RowBox[{"Length", "/@", 
        RowBox[{"SlotsOfTensor", "/@", "headlist"}]}]}], ",", 
      "partitionedslots", ",", "symbolpermutation", ",", " ", "newslots", ",",
       "slotpermutation", ",", "newinds", ",", "newsym", ",", "newlabel"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"partitionedslots", "=", 
      RowBox[{"IndexList", "@@@", 
       RowBox[{"partitionRagged", "[", 
        RowBox[{
         RowBox[{"List", "@@", "slotlist"}], ",", "numindices"}], "]"}]}]}], 
     ";", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"partitionedslots", "=", 
        RowBox[{"IndexList", "@@@", 
         RowBox[{"Last", "/@", 
          RowBox[{"Rest", "@", 
           RowBox[{"FoldList", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Drop", "[", 
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}], ",", 
                RowBox[{"Take", "[", 
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}]}], 
               "}"}], "&"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"List", "@@", "slotlist"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", "numindices"}], 
            "]"}]}]}]}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"symbolpermutation", "=", 
      RowBox[{"PermutationFromTo", "[", 
       RowBox[{"headlist", ",", "sortedheads"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newslots", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"List", "@@@", 
        RowBox[{"PermuteList", "[", 
         RowBox[{"partitionedslots", ",", "symbolpermutation"}], "]"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"slotpermutation", "=", 
      RowBox[{"PermutationFromTo", "[", 
       RowBox[{
        RowBox[{"List", "@@", "slotlist"}], ",", "newslots"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newinds", "=", 
      RowBox[{"PermuteList", "[", 
       RowBox[{
        RowBox[{"List", "[", "inds", "]"}], ",", "slotpermutation"}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"newsym", "=", 
      RowBox[{"sym", "/.", 
       RowBox[{"List", "@@", 
        RowBox[{"TranslatePerm", "[", 
         RowBox[{"slotpermutation", ",", "Rules"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Also", " ", "sort", " ", "the", " ", "base", " ", "of", " ", "the", 
       " ", "sym"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"newsym", "=", 
      RowBox[{"TidyGroup", "@", "newsym"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "One", " ", "should", " ", "probably", " ", "change", " ", "the", " ", 
       "label", " ", 
       RowBox[{"too", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"newlabel", "=", 
      RowBox[{"DefaultLabelSym", "[", "newsym", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SymH", "[", 
       RowBox[{"sortedheads", ",", "newsym", ",", "newlabel"}], "]"}], "[", 
      RowBox[{"Sequence", "@@", "newinds"}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.480426190954*^9, 3.4804262272552*^9}, {
   3.4804262581432*^9, 3.4804262772688*^9}, {3.4804263294664*^9, 
   3.4804263744724*^9}, {3.4804270380652*^9, 3.4804270449136*^9}, {
   3.4804271102464*^9, 3.4804273752436*^9}, {3.4804274197348*^9, 
   3.4804275588244*^9}, {3.4804276010068*^9, 3.4804276292116003`*^9}, {
   3.4804276872436*^9, 3.4804276886476*^9}, {3.4804277380528*^9, 
   3.480427835272001*^9}, {3.4804278733516*^9, 3.4804280487112*^9}, {
   3.4804282575328*^9, 3.480428360992*^9}, {3.4804284128932*^9, 
   3.4804284575872*^9}, {3.4804285361956*^9, 3.4804287075772*^9}, {
   3.4804288177444*^9, 3.4804288795671997`*^9}, {3.480435440491*^9, 
   3.480435440761*^9}, {3.480439343417*^9, 3.480439344887*^9}, {
   3.4806084613532*^9, 3.4806085223452*^9}, {3.4807491649746*^9, 
   3.4807491668310003`*^9}, {3.4811906643262*^9, 3.4811906660772*^9}, {
   3.494752823685*^9, 3.4947528273042*^9}, 3.517836663368803*^9, {
   3.567864472935193*^9, 3.567864483824013*^9}, {3.5748264115255957`*^9, 
   3.574826419965211*^9}, 3.583562258934333*^9},
 CellLabel->
  "In[354]:=",ExpressionUUID->"a6e20859-4c27-4140-bb41-2bfa24b04b35"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SortTensorsInSym", "[", "expr_", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"(", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{
       RowBox[{"SymH", "[", "___", "]"}], "[", "___", "]"}]}], 
     "\[RuleDelayed]", 
     RowBox[{"SortTensorsInSym1", "[", "x", "]"}]}]}], ")"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517836729817604*^9, 3.517836779243431*^9}},
 CellLabel->
  "In[355]:=",ExpressionUUID->"313bd014-b7d2-4acf-8d93-1bd4e302991a"],

Cell["More tools", "Text",
 CellChangeTimes->{{3.4804289066956*^9, 3.4804289129512*^9}, {
  3.4807487623542*^9, 
  3.4807487641794*^9}},ExpressionUUID->"6c6ce176-96e5-486f-bb33-e90536e3e591"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SuperfluousSymQ", "[", 
   RowBox[{"x", ":", 
    RowBox[{"(", 
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], ")"}]}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"SubgroupQ", "[", 
   RowBox[{"sym", ",", 
    RowBox[{"InternalSymmetrySym", "[", "x", "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4799969971582*^9, 3.4799970207382*^9}, {
   3.4799971947152*^9, 3.4799972386182003`*^9}, {3.4799972830162*^9, 
   3.4799973724342003`*^9}, {3.4799974123872004`*^9, 3.4799975031872*^9}, {
   3.4799975558042*^9, 3.4799975717842*^9}, {3.4799976167492*^9, 
   3.4799977555332003`*^9}, {3.4799978617532*^9, 3.4799978661122*^9}, {
   3.4799981401932*^9, 3.4799981546932*^9}, {3.4807774884172*^9, 
   3.4807775754082003`*^9}, {3.4807777181312*^9, 3.4807777191142*^9}, {
   3.4807777679372*^9, 3.4807777905382*^9}, {3.4807786038542*^9, 
   3.4807786240671997`*^9}, {3.4807786767172003`*^9, 3.4807787323012*^9}, {
   3.4807787919462*^9, 3.4807788084502*^9}, {3.4807788603582*^9, 
   3.4807788694672003`*^9}, {3.4807792886122*^9, 3.4807793274712*^9}, {
   3.4807880520372*^9, 3.4807881288022003`*^9}, {3.4807882605102*^9, 
   3.4807882840052*^9}, {3.4807883763912*^9, 3.4807883954302*^9}, {
   3.4807884780822*^9, 3.4807884782962*^9}, 3.480788555012201*^9, {
   3.4807886201892*^9, 3.4807886249552*^9}, {3.4807888112942*^9, 
   3.4807889759192*^9}, {3.4807890163132*^9, 3.4807891003082*^9}, {
   3.4807892618142*^9, 3.4807892666192*^9}, {3.4807893178822002`*^9, 
   3.4807893194882*^9}, {3.4807893544952*^9, 3.4807893601652*^9}, {
   3.4807894848162003`*^9, 3.480789518710201*^9}, {3.4807900982202*^9, 
   3.4807901151472*^9}, {3.4807907006262007`*^9, 3.4807907128982*^9}, 
   3.4947528300498*^9},
 CellLabel->
  "In[356]:=",ExpressionUUID->"5b146d12-335c-4257-adf5-665c3a1893b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveSuperfluousSym", "[", "expr_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"SymH", "[", 
         RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
        "inds___", "]"}], ")"}]}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"ExpandCovarDAndInertHeadHead", "[", 
       RowBox[{
        RowBox[{"InternalExprSym", "[", 
         RowBox[{"Head", "@", "x"}], "]"}], "/.", 
        RowBox[{"Thread", "@", 
         RowBox[{"Rule", "[", 
          RowBox[{
           RowBox[{"slot", "/@", 
            RowBox[{"Range", "[", 
             RowBox[{"Length", "@", 
              RowBox[{"List", "[", "inds", "]"}]}], "]"}]}], ",", 
           RowBox[{"List", "[", "inds", "]"}]}], "]"}]}]}], "]"}], "/;", 
      RowBox[{"SuperfluousSymQ", "[", 
       RowBox[{"Head", "@", "x"}], "]"}]}]}]}], ")"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4799982036921997`*^9, 3.4799982903282*^9}, {
   3.4799983208622*^9, 3.479998373324199*^9}, {3.480229967628074*^9, 
   3.480230016409274*^9}, {3.480232173780074*^9, 3.480232210908074*^9}, {
   3.4807810095292*^9, 3.4807810630992*^9}, {3.4807811147542*^9, 
   3.4807812363372*^9}, {3.4807834196562*^9, 3.4807834721292*^9}, {
   3.4807840575712*^9, 3.4807840613982*^9}, {3.4807840988972*^9, 
   3.4807840999972*^9}, {3.4807841695432*^9, 3.4807841718642*^9}, {
   3.4807895510812*^9, 3.4807895757092*^9}, {3.4807896225502*^9, 
   3.4807896677872*^9}, 3.4813599724038*^9, 3.4813601798838*^9, {
   3.4849146681210012`*^9, 3.484914671709*^9}, 3.4919210095408*^9, 
   3.4947528373662*^9, {3.5094526663636*^9, 3.5094526795456*^9}, {
   3.587024905679597*^9, 3.587024926692834*^9}},
 CellLabel->
  "In[357]:=",ExpressionUUID->"34479bbb-da5e-46b7-87a0-e5a23b0ab62d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveSuperfluousInnerSym", "[", "expr_", "]"}], ":=", 
  RowBox[{"ExpandCovarDAndInertHeadHead", "[", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"SymH", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"SymH", "[", 
         RowBox[{"headlist_", ",", "innersym_", ",", "innerlabel_"}], "]"}], 
        "}"}], ",", "outersym_", ",", "outerlabel_"}], "]"}], 
     "\[RuleDelayed]", " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"SubgroupQ", "[", 
          RowBox[{"innersym", ",", "outersym"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"RemoveTrivialSym", "@", 
          RowBox[{"SymH", "[", 
           RowBox[{"headlist", ",", "outersym", ",", "outerlabel"}], "]"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"SymH", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"SymH", "[", 
             RowBox[{"headlist", ",", "innersym", ",", "innerlabel"}], "]"}], 
            "}"}], ",", "outersym", ",", "outerlabel"}], "]"}]}], "]"}]}], 
      "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4958041408302*^9, 3.495804144387*^9}, {
  3.4958041753686*^9, 3.4958042069118*^9}, {3.517200573189914*^9, 
  3.517200574500317*^9}, {3.517201607862732*^9, 3.517201634866379*^9}, {
  3.5173858636884484`*^9, 3.517385873064065*^9}, {3.587024975520919*^9, 
  3.5870250135069857`*^9}},
 CellLabel->
  "In[358]:=",ExpressionUUID->"c44d2bb2-6635-4200-8565-18cffbd82a3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveTrivialSym", "[", "expr_", "]"}], ":=", 
  RowBox[{"expr", "/.", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"(", 
      RowBox[{"SymH", "[", 
       RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], ")"}]}], 
    "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"ZeroTensor", "[", 
      RowBox[{"SlotsOfTensor", "@", "x"}], "]"}], "/;", 
     RowBox[{"MinusIDInProductQ", "[", 
      RowBox[{"sym", ",", 
       RowBox[{"InternalSymmetrySym", "@", "x"}]}], "]"}]}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.50945270215*^9, 3.50945276299*^9}, 3.5094528582436*^9, {
   3.5173857909757204`*^9, 3.517385807121749*^9}, {3.51738584192641*^9, 
   3.517385848603222*^9}},
 CellLabel->
  "In[359]:=",ExpressionUUID->"489c64ea-e564-4fc6-8d31-5a94f56a0573"],

Cell["\<\
The following code partially expands a Sym object. The symmetrizations in the \
expansion does not include \"ExpansionIndex\". This code needs to be verified \
theoretically.\
\>", "Text",
 CellChangeTimes->{{3.4807897401662006`*^9, 3.4807897462402*^9}, {
  3.4807923115562*^9, 3.4807923274192*^9}, {3.4808459360769997`*^9, 
  3.480846030956199*^9}, {3.497622095978*^9, 
  3.4976222246468*^9}},ExpressionUUID->"0497a562-1ef3-48eb-909a-77e7f36fa0b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandSymOneIndex1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
     "inds___", "]"}], ",", "ExpansionIndex_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "@", 
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"List", "[", "inds", "]"}], ",", "ExpansionIndex", ",", "1", 
        ",", "1"}], "]"}]}], "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SymH", "[", 
      RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "[", "inds", 
     "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ExpansionSlot", "=", 
         RowBox[{"First", "@", 
          RowBox[{"First", "@", 
           RowBox[{"Position", "[", 
            RowBox[{
             RowBox[{"List", "[", "inds", "]"}], ",", "ExpansionIndex", ",", 
             "1", ",", "1"}], "]"}]}]}]}], ",", " ", "newsym"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"newsym", "=", 
        RowBox[{"BaseChange2", "[", 
         RowBox[{
          RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "sym"}], ",", 
          RowBox[{"{", "ExpansionSlot", "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"IndexSOrbit", "=", 
            RowBox[{"SchreierOrbit", "[", 
             RowBox[{"ExpansionSlot", ",", "newsym", ",", 
              RowBox[{"PermLength", "@", "newsym"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", "PermsForOrbit", ",", "SlotChanges", ",", 
           "GroupList", ",", "SignList", ",", "LabelList", ",", "SymHHeads", 
           ",", "PermutedIndices", ",", "SymHList", ",", "FF"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"PermsForOrbit", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"TraceSchreier", "[", 
              RowBox[{"#", ",", "IndexSOrbit"}], "]"}], "&"}], "/@", 
            RowBox[{"First", "[", "IndexSOrbit", "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"SignList", "=", 
           RowBox[{"sign", "/@", "PermsForOrbit"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"SlotChanges", "=", 
           RowBox[{"List", "@@@", 
            RowBox[{"TranslatePerm", "[", 
             RowBox[{
              RowBox[{"nosign", "/@", "PermsForOrbit"}], ",", "Rules"}], 
             "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"GroupList", "=", 
           RowBox[{"TidyGroup", "/@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"StabilizerChain2", "[", "newsym", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], "/.", "SlotChanges"}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"SymHHeads", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"SymH", "[", 
              RowBox[{"headlist", ",", "#", ",", 
               RowBox[{"DefaultLabelSym", "@", "#"}]}], "]"}], "&"}], "/@", 
            "GroupList"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"PermutedIndices", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"FF", "@@", 
              RowBox[{"PermuteList", "[", 
               RowBox[{
                RowBox[{"List", "[", "inds", "]"}], ",", "#"}], "]"}]}], 
             "&"}], "/@", "PermsForOrbit"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"SymHList", "=", 
           RowBox[{"MapThread", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"#1", "@@", "#2"}], ")"}], "&"}], ",", 
             RowBox[{"{", 
              RowBox[{"SymHHeads", ",", "PermutedIndices"}], "}"}], ",", 
             "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"RemoveSuperfluousSym", "[", 
           RowBox[{
            RowBox[{"Inner", "[", 
             RowBox[{"Times", ",", "SignList", ",", "SymHList", ",", "Plus"}],
              "]"}], "/", 
            RowBox[{"Length", "[", 
             RowBox[{"First", "[", "IndexSOrbit", "]"}], "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4976174004872*^9, 3.4976174216252003`*^9}, {
   3.4976174699228*^9, 3.4976175369091997`*^9}, {3.4976176011656*^9, 
   3.4976176746416*^9}, {3.4976177801132*^9, 3.4976177843096*^9}, {
   3.4976178166796*^9, 3.4976180094332*^9}, {3.4976180491507998`*^9, 
   3.497618088962*^9}, {3.4976181297404*^9, 3.4976181596612*^9}, {
   3.4976182796563997`*^9, 3.4976183107004004`*^9}, {3.4976183807756*^9, 
   3.4976184005875998`*^9}, {3.4976185119560003`*^9, 
   3.4976186152279997`*^9}, {3.4976186726672*^9, 3.4976186820896*^9}, {
   3.497618813114*^9, 3.4976188768712*^9}, {3.4976189792696*^9, 
   3.497618983856*^9}, {3.4976190697184*^9, 3.497619070592*^9}, {
   3.4976191381244*^9, 3.4976192194316*^9}, {3.4976192772608*^9, 
   3.49761927854*^9}, {3.4976193157148*^9, 3.4976193293336*^9}, {
   3.4976193854624*^9, 3.4976195585132*^9}, {3.4976195896507998`*^9, 
   3.4976195901032*^9}, {3.4976197004888*^9, 3.4976198705132*^9}, {
   3.4976208119264*^9, 3.4976208881948*^9}, {3.497620919894*^9, 
   3.4976209274288*^9}, {3.5117629095586*^9, 3.511762992378999*^9}, {
   3.511763123653*^9, 3.5117631371626*^9}, {3.5118456640162*^9, 
   3.5118456657166*^9}, {3.511862086049*^9, 3.5118621206342*^9}, {
   3.5118622437338*^9, 3.5118622587722*^9}, {3.5118622913761992`*^9, 
   3.511862294309*^9}, {3.5118641529866*^9, 3.5118641930162*^9}, {
   3.5118651071762*^9, 3.5118651143522*^9}, {3.5121142117384*^9, 
   3.512114214016*^9}, {3.5121143703124*^9, 3.5121143719348*^9}, {
   3.51211441861*^9, 3.512114453788*^9}, {3.512114517124*^9, 
   3.5121145267335997`*^9}, {3.5121148006540003`*^9, 3.512114812354*^9}, {
   3.5121162509704*^9, 3.5121162602056*^9}, {3.5121165383380003`*^9, 
   3.5121165423472*^9}, {3.5121168273904*^9, 3.512116917418*^9}, {
   3.5121170053708*^9, 3.5121170099884*^9}, {3.5121170632156*^9, 
   3.5121170738704*^9}, 3.515756624273061*^9, {3.519297850426172*^9, 
   3.519297876259817*^9}, {3.537623792221425*^9, 3.537623844965118*^9}, {
   3.567864510047659*^9, 3.567864523338882*^9}, {3.56791923526707*^9, 
   3.567919243535084*^9}, {3.5679193244836264`*^9, 3.567919331581639*^9}, {
   3.5679196774810476`*^9, 3.567919684485459*^9}, {3.584177522366804*^9, 
   3.584177528310415*^9}, 3.601560770823271*^9, 3.603719704801569*^9, 
   3.61961517523753*^9},
 CellLabel->
  "In[360]:=",ExpressionUUID->"5115605d-df48-4f5b-a4c1-8e67244bbefc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandSymOneIndexInternal", "[", 
   RowBox[{
    RowBox[{"y", ":", 
     RowBox[{
      RowBox[{"SymH", "[", 
       RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
      "inds___", "]"}]}], ",", "ExpansionIndex_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"SymHpositions", ",", " ", 
      RowBox[{"return", "=", "y"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SymHpositions", "=", 
      RowBox[{"Position", "[", 
       RowBox[{"headlist", ",", "SymH"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "SymHpositions", "]"}], ">", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"internalexpr", "=", 
            RowBox[{"InternalExprSym", "@", 
             RowBox[{"Head", "@", "y"}]}]}], ",", "expandedinternalexpr", ",",
            " ", "dummylist", ",", "dummiestoinds", ",", "indstodummies"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"dummylist", "=", 
           RowBox[{"DummyAs", "/@", 
            RowBox[{"List", "[", "inds", "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"dummiestoinds", "=", 
           RowBox[{"Thread", "@", 
            RowBox[{"Rule", "[", 
             RowBox[{"dummylist", ",", 
              RowBox[{"List", "[", "inds", "]"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"indstodummies", "=", 
           RowBox[{"Thread", "@", 
            RowBox[{"Rule", "[", 
             RowBox[{
              RowBox[{"List", "[", "inds", "]"}], ",", "dummylist"}], 
             "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"internalexpr", "=", 
           RowBox[{"internalexpr", "/.", 
            RowBox[{"Thread", "@", 
             RowBox[{"Rule", "[", 
              RowBox[{
               RowBox[{"slot", "/@", 
                RowBox[{"Range", "@", 
                 RowBox[{"Length", "@", 
                  RowBox[{"List", "[", "inds", "]"}]}]}]}], ",", 
               "dummylist"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"expandedinternalexpr", "=", 
           RowBox[{
            RowBox[{"internalexpr", "/.", 
             RowBox[{
              RowBox[{"x", ":", 
               RowBox[{
                RowBox[{"SymH", "[", "___", "]"}], "[", "___", "]"}]}], 
              "\[RuleDelayed]", 
              RowBox[{"ExpandSymOneIndex1", "[", 
               RowBox[{"x", ",", 
                RowBox[{"ExpansionIndex", "/.", "indstodummies"}]}], 
               "]"}]}]}], "/.", 
            RowBox[{
             RowBox[{"x", ":", 
              RowBox[{
               RowBox[{"SymH", "[", "___", "]"}], "[", "___", "]"}]}], 
             "\[RuleDelayed]", 
             RowBox[{"ExpandSymOneIndexInternal", "[", 
              RowBox[{"x", ",", 
               RowBox[{"ExpansionIndex", "/.", "indstodummies"}]}], 
              "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"return", "=", 
           RowBox[{"RemoveSuperfluousInnerSym", "[", 
            RowBox[{
             RowBox[{"ImposeSym", "[", 
              RowBox[{
               RowBox[{"Expand", "@", "expandedinternalexpr"}], ",", 
               RowBox[{"IndexList", "@@", "dummylist"}], ",", "sym"}], "]"}], 
             "/.", "dummiestoinds"}], "]"}]}], ";"}]}], "\[IndentingNewLine]",
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", "return"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5118481584416*^9, 3.5118482175811987`*^9}, {
   3.5118482709332*^9, 3.5118482723059998`*^9}, {3.5118483065011992`*^9, 
   3.5118484265275993`*^9}, 3.5118486392492*^9, {3.5118487312111993`*^9, 
   3.5118487340972*^9}, {3.511848981575599*^9, 3.5118490156148*^9}, {
   3.51184928108*^9, 3.5118493530896*^9}, {3.5118494379536*^9, 
   3.511849467266*^9}, {3.5118496133132*^9, 3.511849738082*^9}, {
   3.5118499528472*^9, 3.511849979024*^9}, {3.5118501636968*^9, 
   3.5118501660368*^9}, {3.5118502039136*^9, 3.5118502048964*^9}, {
   3.5118502499648*^9, 3.5118502529444*^9}, {3.5118503124272*^9, 
   3.5118503485724*^9}, {3.511850390396*^9, 3.5118504356984*^9}, {
   3.5118506522108*^9, 3.511850673224*^9}, {3.5118545665058*^9, 
   3.5118545680346003`*^9}, {3.5118623002682*^9, 3.5118623235278*^9}, 
   3.511862395631*^9, {3.5118625408826*^9, 3.5118625463738*^9}, {
   3.5118640092326*^9, 3.511864013429*^9}, {3.5118650826373997`*^9, 
   3.5118651445226*^9}, {3.512035543524681*^9, 3.512035545661881*^9}, {
   3.512035690944681*^9, 3.5120357923914814`*^9}, {3.512035905975081*^9, 
   3.5120359237902803`*^9}, {3.512036045314281*^9, 3.512036109601881*^9}, {
   3.512036482239081*^9, 3.512036484469881*^9}, 3.512036662528281*^9, {
   3.512037162118281*^9, 3.5120372437842813`*^9}, {3.512037309039081*^9, 
   3.512037349489881*^9}, {3.512037380253081*^9, 3.5120374124982805`*^9}, {
   3.512037472776681*^9, 3.512037514163481*^9}, {3.512042547630081*^9, 
   3.512042577316881*^9}, {3.512047044080481*^9, 3.512047055328081*^9}, 
   3.515756637704685*^9, {3.5175604461299567`*^9, 3.5175604475495586`*^9}, {
   3.519297888115838*^9, 3.519297908395873*^9}, 3.583067204536721*^9},
 CellLabel->
  "In[361]:=",ExpressionUUID->"11a056b1-fdb6-49a8-b9c8-501bcd89f46a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandSymOneIndex", "[", 
   RowBox[{"expr_", ",", "ExpansionIndex_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"result", "=", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"expr", "/.", 
         RowBox[{
          RowBox[{"x", ":", 
           RowBox[{
            RowBox[{"SymH", "[", "___", "]"}], "[", "___", "]"}]}], 
          "\[RuleDelayed]", 
          RowBox[{"ExpandSymOneIndex1", "[", 
           RowBox[{"x", ",", "ExpansionIndex"}], "]"}]}]}], "/.", 
        RowBox[{
         RowBox[{"y", ":", 
          RowBox[{
           RowBox[{"SymH", "[", "___", "]"}], "[", "___", "]"}]}], 
         "\[RuleDelayed]", 
         RowBox[{"ExpandSymOneIndexInternal", "[", 
          RowBox[{"y", ",", "ExpansionIndex"}], "]"}]}]}], ")"}]}], ";", 
     "\[IndentingNewLine]", "result"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.511855276025*^9, 3.5118553093778*^9}, {
  3.511860333076999*^9, 3.5118604601546*^9}, {3.5118605346134*^9, 
  3.5118605608838*^9}, {3.5118607629818*^9, 3.5118607736366*^9}, {
  3.5118651252566*^9, 3.5118651267854*^9}, {3.515756652711912*^9, 
  3.515756659061123*^9}, {3.51929791797429*^9, 3.5192979184422913`*^9}},
 CellLabel->
  "In[362]:=",ExpressionUUID->"19afe5c5-c0fd-4d13-a623-4d93cf787f1c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandSymOneSlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
     "inds___", "]"}], ",", "ExpansionSlot_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"newsym", "=", 
      RowBox[{"BaseChange2", "[", 
       RowBox[{
        RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "sym"}], ",", 
        RowBox[{"{", "ExpansionSlot", "}"}]}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"IndexSOrbit", "=", 
         RowBox[{"SchreierOrbit", "[", 
          RowBox[{"ExpansionSlot", ",", "newsym", ",", 
           RowBox[{"PermLength", "@", "newsym"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", "PermsForOrbit", ",", 
        RowBox[{"stabsym", "=", 
         RowBox[{"TidyGroup", "[", 
          RowBox[{
           RowBox[{"StabilizerChain2", "[", "newsym", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", " ", "newinds", ",", 
        " ", "newlabel"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"PermsForOrbit", "=", 
        RowBox[{"InversePerm", "/@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"TraceSchreier", "[", 
             RowBox[{"#", ",", "IndexSOrbit"}], "]"}], "&"}], "/@", 
           RowBox[{"First", "[", "IndexSOrbit", "]"}]}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"newinds", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"PermuteList", "[", 
           RowBox[{
            RowBox[{"List", "[", "inds", "]"}], ",", "#"}], "]"}], "&"}], "/@",
          "PermsForOrbit"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"newlabel", "=", 
        RowBox[{"DefaultLabelSym", "[", "stabsym", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Length", "[", 
          RowBox[{"First", "[", "IndexSOrbit", "]"}], "]"}]}], "*", 
        RowBox[{"Plus", "@@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"SymH", "[", 
            RowBox[{"headlist", ",", "stabsym", ",", "newlabel"}], "]"}], "@@@",
            "newinds"}], ")"}]}]}]}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5117768130898*^9, 3.5117768230582*^9}, {
   3.5117773620226*^9, 3.5117773638789997`*^9}, {3.5117774689606*^9, 
   3.5117774908162003`*^9}, {3.511777642339*^9, 3.5117776639918003`*^9}, {
   3.5117777272497997`*^9, 3.5117777510086*^9}, {3.5117778303034*^9, 
   3.5117778351549997`*^9}, {3.5117779928398*^9, 3.5117781330214*^9}, {
   3.511778330377*^9, 3.5117783856322*^9}, {3.5117784779217997`*^9, 
   3.5117785328338*^9}, {3.5117786075734*^9, 3.5117786186493998`*^9}, {
   3.5117786741386*^9, 3.5117786840914*^9}, {3.5117789624734*^9, 
   3.511778971615*^9}, {3.5117790086026*^9, 3.511779010615*^9}, {
   3.567864563867753*^9, 3.5678645870025945`*^9}, {3.567919373717313*^9, 
   3.567919379395723*^9}, 3.6015607781232805`*^9, 3.603719714501582*^9, 
   3.6196151789675355`*^9},
 CellLabel->
  "In[363]:=",ExpressionUUID->"4cf2a6e7-6416-4643-bbbf-be41cb030783"],

Cell["\<\
There is still a problem if headlist contains a Sym object which symmetrizes \
over ExpansionIndex.....?\
\>", "Text",
 CellChangeTimes->{{3.4976880464576*^9, 3.4976881140368*^9}, {
   3.4976881478576*^9, 3.49768814831*^9}, 
   3.5440994139594154`*^9},ExpressionUUID->"7567035f-9d00-4538-b7ac-\
be309fa416ff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveCovDInsideSym", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"covd_", "?", "CovDQ"}], "[", "covdinds___", "]"}], "@", 
     RowBox[{
      RowBox[{"SymH", "[", 
       RowBox[{"headlist_", ",", " ", "sym_", ",", " ", "label_"}], "]"}], 
      "[", "inds___", "]"}]}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"indlist", "=", 
         RowBox[{"List", "[", "inds", "]"}]}], ",", 
        RowBox[{"slotlist", "=", 
         RowBox[{"xAct`SymManipulator`Private`slot", "/@", 
          RowBox[{"Range", "@", 
           RowBox[{"Length", "@", 
            RowBox[{"List", "[", "inds", "]"}]}]}]}]}], ",", "internalexpr", 
        ",", 
        RowBox[{"tempinds", "=", 
         RowBox[{"DummyAs", "/@", 
          RowBox[{"List", "[", "inds", "]"}]}]}], ",", "newinternalexpr"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"internalexpr", "=", 
        RowBox[{"xAct`SymManipulator`Private`InternalExprSym", "[", 
         RowBox[{"SymH", "[", 
          RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"newinternalexpr", "=", 
        RowBox[{"Expand", "@", 
         RowBox[{
         "xAct`SymManipulator`Private`ExpandCovarDAndInertHeadHead", "[", 
          RowBox[{"internalexpr", "/.", 
           RowBox[{"Thread", "@", 
            RowBox[{"Rule", "[", 
             RowBox[{"slotlist", ",", "tempinds"}], "]"}]}]}], "]"}]}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ImposeSym", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"covd", "[", "covdinds", "]"}], "@", "newinternalexpr"}], 
          ",", 
          RowBox[{"IndexList", "@@", "tempinds"}], ",", "sym"}], "]"}], "/.", 
        
        RowBox[{"Thread", "@", 
         RowBox[{"Rule", "[", 
          RowBox[{"tempinds", ",", "indlist"}], "]"}]}]}]}]}], "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[364]:=",ExpressionUUID->"a2513be1-1b40-43b9-8a19-3fe9bfe7d388"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveTensorsOutsideSym", "[", 
   RowBox[{"expr_", ",", " ", 
    RowBox[{"onlymetrics_", ":", "False"}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"expr", "/.", 
     RowBox[{
      RowBox[{"x", ":", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"SymH", "[", 
          RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
         "inds___", "]"}], ")"}]}], "\[RuleDelayed]", "\[IndentingNewLine]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "stableslots", ",", "newlabel", ",", "tensornotinsymQ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"numindices", "=", 
           RowBox[{"Length", "/@", 
            RowBox[{"SlotsOfTensor", "/@", "headlist"}]}]}], ",", "slotlist", 
          ",", "partitionedslots", ",", " ", "tensornotinsymQpos", ",", 
          "\[IndentingNewLine]", "symbolpermutation", ",", "newslots", ",", 
          "slotpermutation", ",", " ", "newinds", ",", "innerinds", ",", " ", 
          "innersym", ",", "innerheads", ",", " ", "outerheads", ",", " ", 
          "newsym", ",", " ", "newpartitionedslots", ",", " ", 
          "newnumindices", ",", " ", "partitionednewinds", ",", 
          "tensorinsymQpos"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"slotlist", "=", 
          RowBox[{"Range", "[", 
           RowBox[{"Plus", "@@", "numindices"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Extract", " ", "indices", " ", "belonging", " ", "to", " ", "the", 
           " ", "different", " ", 
           RowBox[{"tensors", ".", " ", "Can"}], " ", "this", " ", "be", " ", 
           "done", " ", "in", " ", "a", " ", "simpler", " ", 
           RowBox[{"way", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"partitionedslots", "=", 
            RowBox[{"Last", "/@", 
             RowBox[{"Rest", "@", 
              RowBox[{"FoldList", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Drop", "[", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}], ",", 
                   RowBox[{"Take", "[", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}]}], 
                  "}"}], "&"}], ",", 
                RowBox[{"{", 
                 RowBox[{"slotlist", ",", 
                  RowBox[{"{", "}"}]}], "}"}], ",", "numindices"}], 
               "]"}]}]}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"partitionedslots", "=", 
          RowBox[{"partitionRagged", "[", 
           RowBox[{"slotlist", ",", "numindices"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"stableslots", "=", 
          RowBox[{"Complement", "[", 
           RowBox[{
            RowBox[{"Range", "@", 
             RowBox[{"Length", "@", 
              RowBox[{"List", "[", "inds", "]"}]}]}], ",", 
            RowBox[{"GroupSupport", "@", "sym"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"tensornotinsymQ", " ", "=", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"subsetQ", "[", 
             RowBox[{"#", ",", "stableslots"}], "]"}], "&"}], "/@", 
           "partitionedslots"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "If", " ", "the", " ", "flag", " ", "onlymetrics", " ", "is", " ", 
           "set", " ", "we", " ", "only", " ", "move", " ", "metrics", " ", 
           RowBox[{"outside", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"onlymetrics", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"tensornotinsymQ", "=", 
             RowBox[{"Thread", "@", 
              RowBox[{"And", "[", 
               RowBox[{"tensornotinsymQ", ",", 
                RowBox[{"MetricQ", "/@", "headlist"}]}], "]"}]}]}], ";"}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"tensornotinsymQpos", "=", 
          RowBox[{"Select", "[", 
           RowBox[{
            RowBox[{"Range", "@", 
             RowBox[{"Length", "@", "headlist"}]}], ",", 
            RowBox[{
             RowBox[{"tensornotinsymQ", "[", 
              RowBox[{"[", "#", "]"}], "]"}], "&"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"outerheads", "=", 
          RowBox[{"headlist", "[", 
           RowBox[{"[", "tensornotinsymQpos", "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"tensorinsymQpos", "=", 
          RowBox[{"Complement", "[", 
           RowBox[{
            RowBox[{"Range", "@", 
             RowBox[{"Length", "@", "headlist"}]}], ",", 
            "tensornotinsymQpos"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"innerheads", "=", 
          RowBox[{"headlist", "[", 
           RowBox[{"[", "tensorinsymQpos", "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"symbolpermutation", "=", 
          RowBox[{"PermutationFromTo", "[", 
           RowBox[{
            RowBox[{"Range", "@", 
             RowBox[{"Length", "@", "headlist"}]}], ",", 
            RowBox[{"Join", "[", 
             RowBox[{"tensorinsymQpos", ",", " ", "tensornotinsymQpos"}], 
             "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"newpartitionedslots", "=", 
          RowBox[{"PermuteList", "[", 
           RowBox[{"partitionedslots", ",", "symbolpermutation"}], "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"newslots", "=", 
          RowBox[{"Flatten", "[", "newpartitionedslots", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"slotpermutation", "=", 
          RowBox[{"PermutationFromTo", "[", 
           RowBox[{"slotlist", ",", "newslots"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"newinds", "=", 
          RowBox[{"PermuteList", "[", 
           RowBox[{
            RowBox[{"List", "[", "inds", "]"}], ",", "slotpermutation"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"newnumindices", "=", 
          RowBox[{"Length", "/@", 
           RowBox[{"Take", "[", 
            RowBox[{"newpartitionedslots", ",", " ", 
             RowBox[{"-", 
              RowBox[{"Length", "@", "outerheads"}]}]}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"newnumindices", "=", 
          RowBox[{"Prepend", "[", 
           RowBox[{"newnumindices", ",", 
            RowBox[{
             RowBox[{"Length", "[", "newinds", "]"}], "-", 
             RowBox[{"Plus", "@@", "newnumindices"}]}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"partitionednewinds", "=", 
          RowBox[{"IndexList", "@@@", 
           RowBox[{"Last", "/@", 
            RowBox[{"Rest", "@", 
             RowBox[{"FoldList", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Drop", "[", 
                   RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}], ",", 
                  RowBox[{"Take", "[", 
                   RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}]}], 
                 "}"}], "&"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"List", "@@", "newinds"}], ",", 
                 RowBox[{"{", "}"}]}], "}"}], ",", "newnumindices"}], 
              "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"newsym", "=", 
          RowBox[{"sym", "/.", 
           RowBox[{"List", "@@", 
            RowBox[{"TranslatePerm", "[", 
             RowBox[{"slotpermutation", ",", "Rules"}], "]"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Also", " ", "sort", " ", "the", " ", "base", " ", "of", " ", "the",
            " ", "sym"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"newsym", "=", 
          RowBox[{"TidyGroup", "@", "newsym"}]}], ";", "\[IndentingNewLine]", 
         
         RowBox[{"(*", " ", 
          RowBox[{
          "One", " ", "should", " ", "probably", " ", "change", " ", "the", 
           " ", "label", " ", 
           RowBox[{"too", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"newlabel", "=", 
          RowBox[{"DefaultLabelSym", "[", "newsym", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"outerheads", "=", 
          RowBox[{"Prepend", "[", 
           RowBox[{"outerheads", ",", 
            RowBox[{"SymH", "[", 
             RowBox[{"innerheads", ",", "newsym", ",", "newlabel"}], "]"}]}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Inner", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"#1", "@@", "#2"}], ")"}], "&"}], ",", "outerheads", ",",
            "partitionednewinds", ",", "Times"}], "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", ")"}], "//.", 
   RowBox[{
    RowBox[{"y", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"CovarD", "[", "___", "]"}], "[", "___", "]"}], ")"}]}], ":>", 
    
    RowBox[{"ExpandCovarD", "[", "y", "]"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.5117798795974*^9, {3.511779952777*^9, 3.5117799890158*^9}, {
   3.5117801549686003`*^9, 3.5117802080398*^9}, {3.5117803034962*^9, 
   3.511780375771*^9}, {3.511780430215*^9, 3.5117805974158*^9}, {
   3.5117806885198*^9, 3.5117807156326*^9}, {3.5117807470978007`*^9, 
   3.5117807488918*^9}, {3.5117808207454*^9, 3.5117808328978*^9}, {
   3.5117808728806*^9, 3.5117808737854*^9}, {3.5117809685086*^9, 
   3.5117809709734*^9}, 3.5117811168178*^9, 3.5117811715114*^9, {
   3.5117812138185997`*^9, 3.5117812462198*^9}, {3.5117812853134003`*^9, 
   3.5117813092126*^9}, {3.5117814028126*^9, 3.5117816141926003`*^9}, {
   3.5117816534890003`*^9, 3.5117817383998003`*^9}, {3.511782283807*^9, 
   3.5117823060838*^9}, {3.5117823664558*^9, 3.5117824179982*^9}, {
   3.5117824908970003`*^9, 3.511782528415*^9}, {3.5117825667598*^9, 
   3.5117825829526*^9}, {3.5117826476926007`*^9, 3.5117826493774*^9}, {
   3.511783048675*^9, 3.5117830531521997`*^9}, {3.5117831047882*^9, 
   3.5117831204818*^9}, {3.5117831654722*^9, 3.5117831855025997`*^9}, {
   3.5117832161878*^9, 3.511783239775*^9}, {3.5117832764974008`*^9, 
   3.5117832983686*^9}, {3.5117833336870003`*^9, 3.511783339849*^9}, {
   3.5117833937938*^9, 3.5117835246154003`*^9}, {3.5117835764854*^9, 
   3.5117836026622*^9}, 3.5117836757326*^9, {3.511783712767*^9, 
   3.5117838081454*^9}, {3.5117838575506*^9, 3.511783865491*^9}, {
   3.5117839129306*^9, 3.5117839151614*^9}, 3.5158176544606705`*^9, {
   3.5262094255936995`*^9, 3.526209449820543*^9}, {3.537700148766045*^9, 
   3.5377001683128796`*^9}, {3.5377002469370184`*^9, 3.537700265766251*^9}, {
   3.5377004454317665`*^9, 3.537700512683484*^9}, {3.537700761083721*^9, 
   3.537700776980149*^9}, {3.537700898457562*^9, 3.537700962464475*^9}, {
   3.5377814366115046`*^9, 3.537781456485939*^9}, {3.5678646100282345`*^9, 
   3.567864618046648*^9}, {3.567864919033577*^9, 3.567864951122834*^9}, {
   3.574826461586084*^9, 3.574826521022188*^9}, 3.583562288870786*^9, 
   3.615129471738957*^9},
 CellLabel->
  "In[365]:=",ExpressionUUID->"b22d47a7-8579-4b29-bf38-bbdc6cfbc97f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveTensorsInsideSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
     "sinds___", "]"}], ",", "hllist_List", ",", "indlist_List"}], "]"}], ":=",
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SymH", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{"headlist", ",", "hllist"}], "]"}], ",", "sym", ",", "label"}], 
    "]"}], "[", 
   RowBox[{"sinds", ",", 
    RowBox[{"Sequence", "@@", "indlist"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515818630975586*^9, 3.515818663408043*^9}, {
  3.515818767273025*^9, 3.515818896113651*^9}, {3.5158192882983403`*^9, 
  3.515819315520388*^9}, {3.515819360308067*^9, 3.515819405984947*^9}},
 CellLabel->
  "In[366]:=",ExpressionUUID->"00f177bd-ef52-45f7-96df-24fecb97c70d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveTensorsInsideSym", "[", "expr_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"TempFF", ",", " ", "intermediateexpr"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"intermediateexpr", "=", 
      RowBox[{"expr", "/.", 
       RowBox[{
        RowBox[{"y", ":", 
         RowBox[{
          RowBox[{"SymH", "[", 
           RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
          "sinds___", "]"}]}], "\[RuleDelayed]", " ", 
        RowBox[{"TempFF", "[", 
         RowBox[{"y", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"intermediateexpr", "=", 
      RowBox[{"intermediateexpr", "//.", 
       RowBox[{
        RowBox[{"Times", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"TT_", "?", "xTensorQ"}], "[", "tinds___", "]"}], ",", 
          RowBox[{"TempFF", "[", 
           RowBox[{"y_", ",", "hllist_List", ",", "indlist_List"}], "]"}], 
          ",", "z___"}], "]"}], "\[RuleDelayed]", " ", 
        RowBox[{"Times", "[", 
         RowBox[{"z", ",", 
          RowBox[{"TempFF", "[", 
           RowBox[{"y", ",", 
            RowBox[{"Append", "[", 
             RowBox[{"hllist", ",", "TT"}], "]"}], ",", 
            RowBox[{"Join", "[", 
             RowBox[{"indlist", ",", 
              RowBox[{"{", "tinds", "}"}]}], "]"}]}], "]"}]}], "]"}]}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"intermediateexpr", "=", 
      RowBox[{"intermediateexpr", "/.", 
       RowBox[{"TempFF", "->", "MoveTensorsInsideSym1"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"intermediateexpr", "/.", 
      RowBox[{
       RowBox[{"x", ":", 
        RowBox[{
         RowBox[{"SymH", "[", "___", "]"}], "[", "___", "]"}]}], 
       "\[RuleDelayed]", 
       RowBox[{"SortTensorsInSym", "[", "x", "]"}]}]}]}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.515818426662027*^9, 3.515818477252917*^9}, {
  3.515818536111819*^9, 3.515818591351517*^9}, {3.515819011413454*^9, 
  3.515819173232538*^9}, {3.515819416436966*^9, 3.515819428776587*^9}, {
  3.5158194855294867`*^9, 3.515819489367093*^9}, {3.515819616990918*^9, 
  3.515819618862921*^9}, {3.515819976369749*^9, 3.515820041312663*^9}, {
  3.515820137954833*^9, 3.515820140154437*^9}},
 CellLabel->
  "In[367]:=",ExpressionUUID->"ba7f8bf0-b650-4ec6-a23f-83c1f4f7688a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveDummiesFromSym", "[", "expr_Plus", "]"}], ":=", 
  RowBox[{"RemoveDummiesFromSym", "/@", "expr"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.511855705539799*^9, 3.5118557444618*^9}},
 CellLabel->
  "In[368]:=",ExpressionUUID->"1544eaf9-ced6-48e2-bf44-708ff4d82467"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveDummiesFromSym", "[", "expr_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dummies", "=", 
      RowBox[{"FindDummyIndices", "[", "expr", "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dummies", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Times", "[", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "#"}], "]"}], "&"}], "/@", "dummies"}], 
        ",", "dummies"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Fold", "[", 
      RowBox[{"ExpandSymOneIndex", ",", "expr", ",", "dummies"}], "]"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5118557535722*^9, 3.5118557768006*^9}, {
  3.511855823351*^9, 3.5118558600266*^9}, {3.5118559223174*^9, 
  3.5118559237213993`*^9}, {3.5118560208002*^9, 3.5118560329214*^9}, {
  3.511856086367*^9, 3.511856169203*^9}, {3.511856207813*^9, 
  3.5118562093106*^9}, {3.516080480790079*^9, 3.516080481945144*^9}, {
  3.52923582531351*^9, 3.5292358257191105`*^9}},
 CellLabel->
  "In[369]:=",ExpressionUUID->"1599c94b-2855-475c-894b-2228a0c47db6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MoveSymIndicesDown1", "[", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"SymH", "[", 
         RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
        "sinds___", "]"}], ")"}]}], ",", "expr2_"}], "]"}], ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "=", 
        RowBox[{"Length", "@", 
         RowBox[{"List", "[", "sinds", "]"}]}]}], ",", "unstableslots", ",", 
       "unstableindices", ",", "needtomoveindices", ",", " ", "metricfactors",
        ",", "indexchanges"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"unstableslots", "=", 
       RowBox[{"GroupSupport", "[", "sym", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"unstableindices", "=", 
       RowBox[{
        RowBox[{"List", "[", "sinds", "]"}], "[", 
        RowBox[{"[", "unstableslots", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"needtomoveindices", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"unstableindices", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"DownIndex", "[", "#", "]"}], "=!=", "#"}], "&"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"metricfactors", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"First", "[", 
            RowBox[{"MetricsOfVBundle", "@", 
             RowBox[{"VBundleOfIndex", "[", "#", "]"}]}], "]"}], "[", 
           RowBox[{"#", ",", 
            RowBox[{"DummyAs", "[", "#", "]"}]}], "]"}], ")"}], "&"}], "/@", 
        "needtomoveindices"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"indexchanges", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Rule", "[", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"ChangeIndex", "[", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}], "&"}], "/@", 
        "metricfactors"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Times", "[", 
       RowBox[{
        RowBox[{"ReplaceIndex", "[", 
         RowBox[{"x", ",", "indexchanges"}], "]"}], ",", 
        RowBox[{"ContractMetric", "@", 
         RowBox[{"Times", "[", 
          RowBox[{
           RowBox[{"Times", "@@", "metricfactors"}], ",", "expr2"}], 
          "]"}]}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.516087316985087*^9, 3.516087327618695*^9}, {
   3.5695822519128237`*^9, 3.5695822627392416`*^9}, 3.583067204552321*^9},
 CellLabel->
  "In[370]:=",ExpressionUUID->"d4152fee-0b55-479c-9529-b533d9e5edce"],

Cell["\<\
Needs to implement something that works with derivatives too ...\
\>", "Text",
 CellChangeTimes->{{3.516289758130901*^9, 
  3.5162897816557417`*^9}},ExpressionUUID->"52a231c9-6332-415f-8ed6-\
0b3eac20f205"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveSymIndicesDown", "[", "expr_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"TempFF", ",", " ", "intermediateexpr"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "Derivatives", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"intermediateexpr", "=", 
      RowBox[{"expr", "//.", 
       RowBox[{
        RowBox[{"x", ":", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"D1_", "?", "CovDQ"}], "[", 
            RowBox[{"___", ",", 
             RowBox[{"-", 
              RowBox[{"(", "A_Symbol", ")"}]}], ",", "___"}], "]"}], "[", 
           RowBox[{
            RowBox[{"SymH", "[", 
             RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
            RowBox[{"___", ",", 
             RowBox[{"(", "A_Symbol", ")"}], ",", "___"}], "]"}], "]"}], 
          ")"}]}], ":>", 
        RowBox[{
         RowBox[{"xAct`xTensor`Private`SymmetryOfIndex", "[", "A", "]"}], "*", 
         RowBox[{"ReplaceIndex", "[", 
          RowBox[{"x", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"A", "\[Rule]", 
              RowBox[{"-", "A"}]}], ",", 
             RowBox[{
              RowBox[{"-", "A"}], "\[Rule]", "A"}]}], "}"}]}], "]"}]}]}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "Tensors", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"intermediateexpr", "=", 
      RowBox[{"intermediateexpr", "/.", 
       RowBox[{
        RowBox[{"x", ":", 
         RowBox[{
          RowBox[{"SymH", "[", 
           RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
          "sinds___", "]"}]}], "\[RuleDelayed]", " ", 
        RowBox[{"TempFF", "[", 
         RowBox[{"x", ",", "1"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"intermediateexpr", "=", 
      RowBox[{"intermediateexpr", "//.", 
       RowBox[{
        RowBox[{"Times", "[", 
         RowBox[{
          RowBox[{"TempFF", "[", 
           RowBox[{"x_", ",", "y_"}], "]"}], ",", "z___"}], "]"}], 
        "\[RuleDelayed]", " ", 
        RowBox[{"TempFF", "[", 
         RowBox[{"x", ",", 
          RowBox[{"Times", "[", 
           RowBox[{"y", ",", "z"}], "]"}]}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"intermediateexpr", "=", 
      RowBox[{"intermediateexpr", "/.", 
       RowBox[{"TempFF", "->", "MoveSymIndicesDown1"}]}]}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515818426662027*^9, 3.515818477252917*^9}, {
   3.515818536111819*^9, 3.515818591351517*^9}, {3.515819011413454*^9, 
   3.515819173232538*^9}, {3.515819416436966*^9, 3.515819428776587*^9}, {
   3.5158194855294867`*^9, 3.515819489367093*^9}, {3.515819616990918*^9, 
   3.515819618862921*^9}, {3.515819976369749*^9, 3.515820041312663*^9}, {
   3.515820137954833*^9, 3.515820140154437*^9}, {3.5160881150597334`*^9, 
   3.5160882735958004`*^9}, {3.518025631750066*^9, 3.518025693416974*^9}, {
   3.518027335789859*^9, 3.5180273386134644`*^9}, 3.518027710252917*^9, 
   3.518027833773934*^9},
 CellLabel->
  "In[371]:=",ExpressionUUID->"7d6b8ccd-2f9c-4e07-997d-3626e3bbc3e4"],

Cell["\<\
The following code contracts metrics inside the SymH object. This is new in \
release 0.8.2 and should initially be considered as experimental.\
\>", "Text",
 CellChangeTimes->{{3.516289758130901*^9, 3.5162897816557417`*^9}, {
  3.544099561098874*^9, 3.5440995675884852`*^9}, {3.5440996342942023`*^9, 
  3.544099727441966*^9}},ExpressionUUID->"852ccd10-092b-424c-95ce-\
231208f15002"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractMetricsInsideSym", "[", "expr_", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"expr", "//.", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"SymH", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"headlist", ":", 
           RowBox[{"{", 
            RowBox[{"___", ",", 
             RowBox[{"TT_", "?", "MetricQ"}], ",", "___"}], "}"}]}], ")"}], 
         ",", "sym_", ",", "label_"}], "]"}], "[", "inds___", "]"}], ")"}]}], 
    "\[RuleDelayed]", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"stableslots", ",", "newlabel", ",", 
        RowBox[{"removetensor", "=", "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"numindices", "=", 
         RowBox[{"Length", "/@", 
          RowBox[{"SlotsOfTensor", "/@", "headlist"}]}]}], ",", "slotlist", 
        ",", "partitionedslots", ",", "\[IndentingNewLine]", 
        RowBox[{"indlist", "=", 
         RowBox[{"List", "[", "inds", "]"}]}], ",", "metricpositions", ",", 
        "metricslots", ",", "slottoind", ",", "contractionpos1", ",", 
        "contractionpos2", ",", "firstcontractedmetric1", ",", 
        "firstcontractedmetric2", ",", "contractionslots", ",", 
        "contractionindex", ",", " ", "stablecontraction", ",", "slotchange1",
         ",", 
        RowBox[{"contractionsign", "=", "1"}], ",", "\[IndentingNewLine]", 
        "symbolpermutation", ",", "newslots", ",", "slotpermutation", ",", 
        " ", "newinds", ",", "innerheads", ",", " ", "newsym", ",", " ", 
        "newpartitionedslots"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slotlist", "=", 
        RowBox[{"Range", "[", 
         RowBox[{"Plus", "@@", "numindices"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"metricpositions", "=", 
        RowBox[{"First", "/@", 
         RowBox[{"Position", "[", 
          RowBox[{
           RowBox[{"MetricQ", "/@", "headlist"}], ",", "True"}], "]"}]}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "If", " ", "we", " ", "have", " ", "no", " ", "metric", " ", "just", 
         " ", "return"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", "metricpositions"}], "\[Equal]", "0"}], ",", 
         "x", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"slottoind", "=", 
           RowBox[{"Thread", "@", 
            RowBox[{"Rule", "[", 
             RowBox[{"slotlist", ",", 
              RowBox[{"List", "[", "inds", "]"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Extract", " ", "indices", " ", "belonging", " ", "to", " ", "the",
             " ", "different", " ", 
            RowBox[{"tensors", ".", " ", "Can"}], " ", "this", " ", "be", " ",
             "done", " ", "in", " ", "a", " ", "simpler", " ", 
            RowBox[{"way", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"partitionedslots", "=", 
           RowBox[{"partitionRagged", "[", 
            RowBox[{"slotlist", ",", "numindices"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"stableslots", "=", 
           RowBox[{"Complement", "[", 
            RowBox[{
             RowBox[{"Range", "@", 
              RowBox[{"Length", "@", 
               RowBox[{"List", "[", "inds", "]"}]}]}], ",", 
             RowBox[{"GroupSupport", "@", "sym"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"metricslots", "=", 
           RowBox[{"Part", "[", 
            RowBox[{"partitionedslots", ",", "metricpositions"}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "At", " ", "which", " ", "slot", " ", "do", " ", "we", " ", "find",
             " ", "an", " ", "index", " ", "contracted", " ", "with", " ", 
            "the", " ", "index", " ", "in", " ", 
            RowBox[{
             RowBox[{"metricslots", "\[InvisibleSpace]", "[", 
              RowBox[{"[", 
               RowBox[{"n", ",", "1"}], "]"}], "]"}], "?"}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"contractionpos1", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"First", "/@", 
               RowBox[{"Position", "[", 
                RowBox[{"indlist", ",", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", "#1", ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "/.", "slottoind"}], 
                   ")"}]}], ",", "1"}], "]"}]}], ")"}], "&"}], "/@", 
            "metricslots"}]}], "\[InvisibleSpace]", ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "At", " ", "which", " ", "slot", " ", "do", " ", "we", " ", "find",
             " ", "an", " ", "index", " ", "contracted", " ", "with", " ", 
            "the", " ", "index", " ", "in", " ", 
            RowBox[{
             RowBox[{"metricslots", "\[InvisibleSpace]", "[", 
              RowBox[{"[", 
               RowBox[{"n", ",", "2"}], "]"}], "]"}], "?"}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"contractionpos2", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"First", "/@", 
               RowBox[{"Position", "[", 
                RowBox[{"indlist", ",", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", "#1", ")"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "/.", "slottoind"}], 
                   ")"}]}], ",", "1"}], "]"}]}], ")"}], "&"}], "/@", 
            "metricslots"}]}], "\[InvisibleSpace]", ";", 
          "\[IndentingNewLine]", 
          RowBox[{"firstcontractedmetric1", "=", 
           RowBox[{"First", "/@", 
            RowBox[{"Position", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Length", "[", "#", "]"}], ">", "0"}], ")"}], "&"}],
                "/@", "contractionpos1"}], ",", "True", ",", "1"}], "]"}]}]}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"firstcontractedmetric2", "=", 
           RowBox[{"First", "/@", 
            RowBox[{"Position", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Length", "[", "#", "]"}], ">", "0"}], ")"}], "&"}],
                "/@", "contractionpos2"}], ",", "True", ",", "1"}], "]"}]}]}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"newpartitionedslots", "=", "partitionedslots"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "@", "firstcontractedmetric1"}], ">", "0"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"contractionslots", "=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"metricslots", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"First", "@", "firstcontractedmetric1"}], ",", 
                   "1"}], "]"}], "]"}], ",", 
                RowBox[{"First", "@", 
                 RowBox[{"contractionpos1", "[", 
                  RowBox[{"[", 
                   RowBox[{"First", "@", "firstcontractedmetric1"}], "]"}], 
                  "]"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Print", "[", 
                RowBox[{
                "\"\<Found contraction between the first index (at slot \>\"",
                  ",", 
                 RowBox[{"contractionslots", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 "\"\<) of metric tensor \>\"", ",", " ", 
                 RowBox[{"headlist", "[", 
                  RowBox[{"[", 
                   RowBox[{"metricpositions", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "@", "firstcontractedmetric1"}], "]"}], 
                    "]"}], "]"}], "]"}], ",", 
                 "\"\< with the index at slot \>\"", ",", " ", 
                 RowBox[{"contractionslots", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], " ", "*)"}],
              "\[IndentingNewLine]", 
             RowBox[{"stablecontraction", "=", 
              RowBox[{"subsetQ", "[", 
               RowBox[{"contractionslots", ",", "stableslots"}], "]"}]}], ";",
              "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{"stablecontraction", ",", "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{"Print", "[", "\"\<Stable\>\"", "]"}], ";"}], " ", 
                "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"removetensor", "=", 
                 RowBox[{"metricpositions", "[", 
                  RowBox[{"[", 
                   RowBox[{"First", "@", "firstcontractedmetric1"}], "]"}], 
                  "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"slotchange1", "=", 
                 RowBox[{
                  RowBox[{"partitionedslots", "[", 
                   RowBox[{"[", 
                    RowBox[{"removetensor", ",", "2"}], "]"}], "]"}], "->", 
                  RowBox[{"contractionslots", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"contractionindex", "=", 
                 RowBox[{
                  RowBox[{"contractionslots", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "/.", "slottoind"}]}], ";",
                 "\[IndentingNewLine]", 
                RowBox[{"contractionsign", "=", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"UpIndexQ", "[", "contractionindex", "]"}], ",", 
                   RowBox[{
                   "xAct`xTensor`Private`SymmetryOfIndex", "[", 
                    "contractionindex", "]"}], ",", "1"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"contractionslots", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "==", 
                   RowBox[{"partitionedslots", "[", 
                    RowBox[{"[", 
                    RowBox[{"removetensor", ",", "2"}], "]"}], "]"}]}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                    RowBox[{"Print", "[", "\"\<Self contraction\>\"", "]"}], 
                    ";"}], "*)"}], "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"contractionsign", "=", 
                    RowBox[{"contractionsign", "*", 
                    RowBox[{"DimOfVBundle", "@", 
                    RowBox[{
                    "VBundleOfIndex", "[", "contractionindex", "]"}]}]}]}], 
                   ";"}]}], "]"}]}], "\[IndentingNewLine]", ",", 
               "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{"Print", "[", 
                  RowBox[{"\"\<Not stable: \>\"", ",", " ", "x"}], "]"}], 
                 ";"}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"removetensor", "=", "0"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"removetensor", "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"Length", "@", "firstcontractedmetric2"}], ">", 
               "0"}]}], "]"}], ",", " ", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"contractionslots", "=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"metricslots", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"First", "@", "firstcontractedmetric2"}], ",", 
                   "2"}], "]"}], "]"}], ",", 
                RowBox[{"First", "@", 
                 RowBox[{"contractionpos2", "[", 
                  RowBox[{"[", 
                   RowBox[{"First", "@", "firstcontractedmetric2"}], "]"}], 
                  "]"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Print", "[", 
                RowBox[{
                "\"\<Found contraction between the second index (at slot \
\>\"", ",", 
                 RowBox[{"contractionslots", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 "\"\<) of metric tensor \>\"", ",", " ", 
                 RowBox[{"headlist", "[", 
                  RowBox[{"[", 
                   RowBox[{"metricpositions", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "@", "firstcontractedmetric2"}], "]"}], 
                    "]"}], "]"}], "]"}], ",", 
                 "\"\< with the index at slot \>\"", ",", " ", 
                 RowBox[{"contractionslots", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], " ", "*)"}],
              "\[IndentingNewLine]", 
             RowBox[{"stablecontraction", "=", 
              RowBox[{"subsetQ", "[", 
               RowBox[{"contractionslots", ",", "stableslots"}], "]"}]}], ";",
              "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{"stablecontraction", ",", "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{"Print", "[", "\"\<Stable\>\"", "]"}], ";"}], "*)"}],
                "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"removetensor", "=", 
                 RowBox[{"metricpositions", "[", 
                  RowBox[{"[", 
                   RowBox[{"First", "@", "firstcontractedmetric2"}], "]"}], 
                  "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"slotchange1", "=", 
                 RowBox[{
                  RowBox[{"partitionedslots", "[", 
                   RowBox[{"[", 
                    RowBox[{"removetensor", ",", "1"}], "]"}], "]"}], "->", 
                  RowBox[{"contractionslots", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"contractionindex", "=", 
                 RowBox[{
                  RowBox[{"contractionslots", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "/.", "slottoind"}]}], ";",
                 "\[IndentingNewLine]", 
                RowBox[{"contractionsign", "=", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"UpIndexQ", "[", "contractionindex", "]"}], ",", 
                   "1", ",", 
                   RowBox[{
                   "xAct`xTensor`Private`SymmetryOfIndex", "[", 
                    "contractionindex", "]"}]}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"contractionslots", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "==", 
                   RowBox[{"partitionedslots", "[", 
                    RowBox[{"[", 
                    RowBox[{"removetensor", ",", "1"}], "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"Print", "[", "\"\<Self contraction\>\"", "]"}], 
                   ";", "\[IndentingNewLine]", 
                   RowBox[{"contractionsign", "=", 
                    RowBox[{"contractionsign", "*", 
                    RowBox[{"DimOfVBundle", "@", 
                    RowBox[{
                    "VBundleOfIndex", "[", "contractionindex", "]"}]}]}]}], 
                   ";"}]}], "]"}]}], "\[IndentingNewLine]", ",", 
               "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{"Print", "[", 
                  RowBox[{"\"\<Not stable: \>\"", ",", " ", "x"}], "]"}], 
                 ";"}], " ", "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"removetensor", "=", "0"}], ";"}]}], 
              "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"removetensor", "==", "0"}], ",", "x", ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"innerheads", "=", 
              RowBox[{"Delete", "[", 
               RowBox[{"headlist", ",", "removetensor"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"symbolpermutation", "=", 
              RowBox[{"PermutationFromTo", "[", 
               RowBox[{
                RowBox[{"Range", "@", 
                 RowBox[{"Length", "@", "headlist"}]}], ",", 
                RowBox[{"Append", "[", 
                 RowBox[{
                  RowBox[{"Delete", "[", 
                   RowBox[{
                    RowBox[{"Range", "@", 
                    RowBox[{"Length", "@", "headlist"}]}], ",", 
                    "removetensor"}], "]"}], ",", "removetensor"}], "]"}]}], 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"newpartitionedslots", "=", 
              RowBox[{"PermuteList", "[", 
               RowBox[{"partitionedslots", ",", "symbolpermutation"}], 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"newslots", "=", 
              RowBox[{"Flatten", "[", "newpartitionedslots", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"slotpermutation", "=", 
              RowBox[{"PermutationFromTo", "[", 
               RowBox[{
                RowBox[{"slotlist", "/.", 
                 RowBox[{"{", 
                  RowBox[{"slotchange1", ",", 
                   RowBox[{"Reverse", "@", "slotchange1"}]}], "}"}]}], ",", 
                "newslots"}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"newinds", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{
                RowBox[{"PermuteList", "[", 
                 RowBox[{
                  RowBox[{"List", "[", "inds", "]"}], ",", 
                  "slotpermutation"}], "]"}], ",", 
                RowBox[{"-", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"newsym", "=", 
              RowBox[{"sym", "/.", 
               RowBox[{"List", "@@", 
                RowBox[{"TranslatePerm", "[", 
                 RowBox[{"slotpermutation", ",", "Rules"}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Also", " ", "sort", " ", "the", " ", "base", " ", "of", " ", 
               "the", " ", "sym"}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"newsym", "=", 
              RowBox[{"TidyGroup", "@", "newsym"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "One", " ", "should", " ", "probably", " ", "change", " ", 
               "the", " ", "label", " ", 
               RowBox[{"too", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"newlabel", "=", 
              RowBox[{"DefaultLabelSym", "[", "newsym", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"RemoveSuperfluousSym", "[", 
              RowBox[{"contractionsign", "*", 
               RowBox[{
                RowBox[{"SymH", "[", 
                 RowBox[{"innerheads", ",", "newsym", ",", "newlabel"}], 
                 "]"}], "[", 
                RowBox[{"Sequence", "@@", "newinds"}], "]"}]}], "]"}]}]}], 
           "]"}]}]}], "]"}]}]}], "]"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5377814694183617`*^9, 3.537781500244016*^9}, {
   3.537782317904852*^9, 3.5377823820989647`*^9}, {3.537782834172159*^9, 
   3.537782853001392*^9}, {3.537782911875895*^9, 3.537782922468314*^9}, {
   3.537783045942531*^9, 3.537783046394932*^9}, {3.537783115659054*^9, 
   3.537783175282358*^9}, {3.5377833573824787`*^9, 3.5377833936213417`*^9}, {
   3.537783547203612*^9, 3.537783560744436*^9}, 3.537783735137142*^9, {
   3.5377839515875216`*^9, 3.5377839582799344`*^9}, {3.537784002396811*^9, 
   3.537784004596415*^9}, {3.537784051911298*^9, 3.5377840829241533`*^9}, {
   3.53778419550955*^9, 3.537784214229583*^9}, {3.544099453037484*^9, 
   3.544099534220027*^9}, {3.567864637000682*^9, 3.5678646539423122`*^9}, 
   3.567865209818087*^9, {3.574826592860315*^9, 3.574826609708344*^9}, 
   3.583562294065595*^9, {3.590147370462415*^9, 3.590147370930416*^9}, 
   3.591096558203987*^9, {3.615129477608965*^9, 3.615129507329007*^9}},
 CellLabel->
  "In[372]:=",ExpressionUUID->"efc61448-322f-4f96-bc32-5f1f13d43438"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandInternalSym", "[", 
   RowBox[{"expr_", ",", "options___"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"expr", "/.", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"SymH", "[", "___", "]"}], "[", "inds___", "]"}], ")"}]}], ":>", 
    RowBox[{"ExpandInternalSym1", "[", 
     RowBox[{"x", ",", "options"}], "]"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.560932089155002*^9, 3.5609321224932604`*^9}, {
  3.560932934318686*^9, 3.5609329528203197`*^9}},
 CellLabel->
  "In[373]:=",ExpressionUUID->"778f4208-d631-4c4f-b1d7-987c4f776193"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandInternalSym1", "[", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"SymH", "[", 
        RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
       "inds___", "]"}], ")"}]}], ",", "options___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"indlist", "=", 
       RowBox[{"List", "[", "inds", "]"}]}], ",", 
      RowBox[{"slotlist", "=", 
       RowBox[{"IndexList", "@@", 
        RowBox[{"slot", "/@", 
         RowBox[{"Range", "@", 
          RowBox[{"Length", "@", 
           RowBox[{"List", "[", "inds", "]"}]}]}]}]}]}], ",", "slotrules"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"slotrules", "=", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{
         RowBox[{"List", "@@", "slotlist"}], ",", "indlist"}], "]"}]}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"ImposeSym", "[", 
      RowBox[{
       RowBox[{"Expand", "@", 
        RowBox[{"ExpandSym", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"InternalExprSym", "[", 
            RowBox[{"Head", "@", "x"}], "]"}], "/.", "slotrules"}], ",", 
          "options"}], "]"}]}], ",", "indlist", ",", "sym", ",", "options"}], 
      "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.560932397131743*^9, {3.560932431795004*^9, 3.560932527173571*^9}, {
   3.560932609182916*^9, 3.560932611179719*^9}, {3.560932958061928*^9, 
   3.560932963225538*^9}, {3.560932997061997*^9, 3.560932999714001*^9}, {
   3.560934960889046*^9, 3.560934972261466*^9}, {3.560944838827143*^9, 
   3.560944845316755*^9}, {3.584451679611733*^9, 3.584451680906535*^9}, {
   3.584777599589928*^9, 3.5847776736588573`*^9}},
 CellLabel->
  "In[374]:=",ExpressionUUID->"9356f980-87a1-4caa-99bb-551858a001af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RuleInSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
     "inds___", "]"}], ",", "rule_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"indlist", "=", 
       RowBox[{"List", "[", "inds", "]"}]}], ",", 
      RowBox[{"slotlist", "=", 
       RowBox[{"slot", "/@", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", 
          RowBox[{"List", "[", "inds", "]"}]}]}]}]}], ",", "internalexpr", 
      ",", 
      RowBox[{"tempinds", "=", 
       RowBox[{"DummyAs", "/@", 
        RowBox[{"List", "[", "inds", "]"}]}]}], ",", "newinternalexpr"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"internalexpr", "=", 
      RowBox[{"InternalExprSym", "[", 
       RowBox[{"SymH", "[", 
        RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newinternalexpr", "=", 
      RowBox[{"Expand", "[", 
       RowBox[{
        RowBox[{"Expand", "@", 
         RowBox[{"ExpandCovarDAndInertHeadHead", "[", 
          RowBox[{"internalexpr", "/.", 
           RowBox[{"Thread", "@", 
            RowBox[{"Rule", "[", 
             RowBox[{"slotlist", ",", "tempinds"}], "]"}]}]}], "]"}]}], "/.", 
        "rule"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ImposeSym", "[", 
       RowBox[{"newinternalexpr", ",", 
        RowBox[{"IndexList", "@@", "tempinds"}], ",", "sym"}], "]"}], "/.", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{"tempinds", ",", "indlist"}], "]"}]}]}]}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{
  3.561371673567178*^9, 3.5830672045679216`*^9, {3.588067264425353*^9, 
   3.588067265657755*^9}},
 CellLabel->
  "In[375]:=",ExpressionUUID->"a8550ad5-5ad7-4f40-99de-fffa7a523d2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RuleInSym", "[", 
   RowBox[{"expr_", ",", "rule_"}], "]"}], ":=", 
  RowBox[{"expr", "/.", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"SymH", "[", "___", "]"}], "[", "inds___", "]"}], ")"}]}], ":>", 
    RowBox[{"RuleInSym1", "[", 
     RowBox[{"x", ",", "rule"}], "]"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.561368551361094*^9, 3.561368561157911*^9}},
 CellLabel->
  "In[376]:=",ExpressionUUID->"95b96096-0aed-48b4-b2bd-b5bfb76eb146"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInSym1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
     "inds___", "]"}], ",", "func_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"indlist", "=", 
       RowBox[{"List", "[", "inds", "]"}]}], ",", 
      RowBox[{"slotlist", "=", 
       RowBox[{"slot", "/@", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", 
          RowBox[{"List", "[", "inds", "]"}]}]}]}]}], ",", "internalexpr", 
      ",", 
      RowBox[{"tempinds", "=", 
       RowBox[{"DummyAs", "/@", 
        RowBox[{"List", "[", "inds", "]"}]}]}], ",", "newinternalexpr"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"internalexpr", "=", 
      RowBox[{"InternalExprSym", "[", 
       RowBox[{"SymH", "[", 
        RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newinternalexpr", "=", 
      RowBox[{"Expand", "@", 
       RowBox[{"func", "[", 
        RowBox[{"Expand", "[", 
         RowBox[{"ExpandCovarDAndInertHeadHead", "[", 
          RowBox[{"internalexpr", "/.", 
           RowBox[{"Thread", "@", 
            RowBox[{"Rule", "[", 
             RowBox[{"slotlist", ",", "tempinds"}], "]"}]}]}], "]"}], "]"}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ImposeSym", "[", 
       RowBox[{"newinternalexpr", ",", 
        RowBox[{"IndexList", "@@", "tempinds"}], ",", "sym"}], "]"}], "/.", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{"tempinds", ",", "indlist"}], "]"}]}]}]}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{
  3.561371673567178*^9, 3.5830672045679216`*^9, {3.58806676173007*^9, 
   3.588066799700537*^9}, {3.588067224302083*^9, 3.588067242944116*^9}, 
   3.58806737629315*^9},
 CellLabel->
  "In[377]:=",ExpressionUUID->"035fb524-3cec-4594-9958-eb365dbb1f95"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInSym", "[", 
   RowBox[{"expr_", ",", "func_"}], "]"}], ":=", 
  RowBox[{"expr", "/.", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"SymH", "[", "___", "]"}], "[", "inds___", "]"}], ")"}]}], 
    "\[RuleDelayed]", 
    RowBox[{"FunctionInSym1", "[", 
     RowBox[{"x", ",", "func"}], "]"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.561368551361094*^9, 3.561368561157911*^9}, {
  3.588066756441661*^9, 3.588066780574904*^9}},
 CellLabel->
  "In[378]:=",ExpressionUUID->"af6b471f-73fe-4d74-837b-c8a130f53793"],

Cell["\<\
Try to factor the imposed group, and remove factors that are not needed.\
\>", "Text",
 CellChangeTimes->{{3.587024798928609*^9, 
  3.587024831439066*^9}},ExpressionUUID->"654be068-dc6c-4317-8480-\
2325a8d1f2e4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveSuperfluousPartialSym1", "[", 
   RowBox[{"x", ":", 
    RowBox[{"(", 
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], ")"}]}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"intsym", "=", 
       RowBox[{"InternalSymmetrySym", "[", "x", "]"}]}], ",", 
      RowBox[{"symfactors", "=", 
       RowBox[{"GroupFactorization1", "@", 
        RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "sym"}]}]}]}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"newsym", "=", 
        RowBox[{"TidyGroup", "[", 
         RowBox[{"JoinSGS", "@@", 
          RowBox[{"(", 
           RowBox[{"Select", "[", 
            RowBox[{"symfactors", ",", 
             RowBox[{
              RowBox[{"Not", "@", 
               RowBox[{"SubgroupQ", "[", 
                RowBox[{"#", ",", "intsym"}], "]"}]}], "&"}]}], "]"}], 
           ")"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"SymH", "[", 
       RowBox[{"headlist", ",", "newsym", ",", 
        RowBox[{"DefaultLabelSym", "@", "newsym"}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.587023288345756*^9, 3.5870233038677835`*^9}, {
   3.5870233394982452`*^9, 3.5870233719619036`*^9}, {3.587023521254165*^9, 
   3.587023523172968*^9}, {3.587023948164515*^9, 3.587023962766141*^9}, {
   3.587024219714192*^9, 3.587024246906041*^9}, {3.587024331614188*^9, 
   3.587024523213725*^9}, {3.587024555287381*^9, 3.587024600839462*^9}, {
   3.587024633037918*^9, 3.587024638887928*^9}, {3.587027323841262*^9, 
   3.587027337226086*^9}, {3.587027491728757*^9, 3.587027494567962*^9}, 
   3.590147482501812*^9},
 CellLabel->
  "In[379]:=",ExpressionUUID->"b101de0f-9d3d-4536-8bed-8c9ef4ba9303"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveSuperfluousPartialSym", "[", "expr_", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"(", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{"SymH", "[", "___", "]"}]}], "\[RuleDelayed]", 
     RowBox[{"RemoveSuperfluousPartialSym1", "[", "x", "]"}]}]}], 
   ")"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5870247230188756`*^9, 3.58702475357933*^9}},
 CellLabel->
  "In[380]:=",ExpressionUUID->"741e6efd-8bdd-42af-b7b7-1718c1a8dba6"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. Computation of mixed symmetries", "Subsection",
 CellChangeTimes->{{3.527145165077472*^9, 3.527145178259495*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"18dc6725-5531-4815-8a45-0d7d88773803"],

Cell[CellGroupData[{

Cell["4.1. Symmetric case", "Subsubsection",
 CellChangeTimes->{{3.527145244512811*^9, 
  3.527145256384432*^9}},ExpressionUUID->"62625e4b-f1f3-4480-8a3f-\
6e0cf52813ee"],

Cell["Old code which is incomplete", "Text",
 CellChangeTimes->{{3.5679271649561987`*^9, 
  3.567927175876217*^9}},ExpressionUUID->"6de4a0e6-59b5-40a3-8929-\
6a80e0ec686f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetricMixedSymmetry", "[", 
   RowBox[{"unstableslots_", ",", "internalsym_", ",", "sym_", ",", "n_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"internalstabilizer", ",", " ", "newsym"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"internalstabilizer", "=", 
      RowBox[{"SetStabilizer", "[", 
       RowBox[{"unstableslots", ",", "internalsym"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newsym", "=", 
      RowBox[{"TidySGS", "@", 
       RowBox[{"SchreierSims", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Union", "[", 
          RowBox[{
           RowBox[{"internalstabilizer", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"Append", "[", 
             RowBox[{"sym", ",", "Cycles"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"newsym", ",", "internalstabilizer"}], "}"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5162839700333323`*^9, 3.516284013323408*^9}, {
   3.516284063508696*^9, 3.5162840751307173`*^9}, {3.516284112040382*^9, 
   3.5162841436772375`*^9}, {3.516284187856515*^9, 3.51628425914864*^9}, {
   3.5162874240238*^9, 3.516287425225002*^9}, {3.516428140511191*^9, 
   3.516428168316782*^9}, {3.516428771667291*^9, 3.516428825435367*^9}, {
   3.5164288935052595`*^9, 3.5164289357646766`*^9}, {3.51643183850928*^9, 
   3.516431854219179*^9}, {3.516431889681207*^9, 3.516431911620462*^9}, {
   3.5164319458814216`*^9, 3.5164319529478254`*^9}, 3.517834988370999*^9, {
   3.5178351078658333`*^9, 3.51783517983895*^9}, {3.5178352879141316`*^9, 
   3.517835356024027*^9}, {3.5178354958740263`*^9, 3.5178354971090965`*^9}, {
   3.517835560817741*^9, 3.517835564652961*^9}, {3.5178356050672717`*^9, 
   3.517835608675478*^9}, {3.519297310758823*^9, 3.519297352379697*^9}, 
   3.51929742237702*^9, {3.526380528027481*^9, 3.526380542176706*^9}, {
   3.5263809141125593`*^9, 3.526380945390614*^9}, {3.534068389543072*^9, 
   3.534068400353892*^9}, 3.5662181946097145`*^9, {3.567862941994305*^9, 
   3.567863064548119*^9}, 3.567863381291076*^9},
 CellLabel->
  "In[381]:=",ExpressionUUID->"c8cc31ba-d534-4e91-881a-733b1f239430"],

Cell["\<\
Newer code. By setting antisym to True, one can also handle the antisymmetric \
case.\
\>", "Text",
 CellChangeTimes->{{3.56792715503458*^9, 3.567927162272993*^9}, {
  3.5681163148632574`*^9, 3.568116360555738*^9}, {3.56811640172421*^9, 
  3.568116414984233*^9}},ExpressionUUID->"f138fd9c-aa59-42f5-a2b9-\
3959d57ebddd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryOfProductOfGroupsSymmetricCase", "[", 
   RowBox[{"Delta0_List", ",", "H0_StrongGenSet", ",", 
    RowBox[{"antisym_", ":", "False"}]}], "]"}], ":=", "\[IndentingNewLine]", 
  
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Delta", "=", 
       RowBox[{"Sort", "@", "Delta0"}]}], ",", "Deltacompl", ",", "G1", ",", 
      "H1", ",", " ", "chainH1", ",", "permdeg", ",", " ", "mm", ",", 
      "alpham", ",", "Hmm1", ",", "Kmm1", ",", "K1", ",", "F1", ",", " ", 
      "GElements", ",", " ", "unstablepoints", ",", "time", ",", "testfunc"}],
      "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Arrange", " ", "so", " ", "that", " ", "the", " ", "groups", " ", 
      "have", " ", "the", " ", "same", " ", "bases", " ", "and", " ", "cycle",
       " ", "notation"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<SymmetryOfProductOfGroupsBruteForce[\>\"", ",", "G0", ",", 
        "\"\<,\>\"", ",", "H0", ",", "\"\<]\>\""}], "]"}], ";"}], " ", "*)"}],
     "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"subsetQ", "[", 
       RowBox[{
        RowBox[{"GroupSupport", "@", "H0"}], ",", "Delta"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{"antisym", ",", "\[IndentingNewLine]", 
          RowBox[{"Antisymmetric", "[", 
           RowBox[{"Delta", ",", "Cycles"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Symmetric", "[", 
           RowBox[{"Delta", ",", "Cycles"}], "]"}]}], "]"}], ",", "H0"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"permdeg", "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"Max", "@@", 
           RowBox[{"First", "[", "H0", "]"}]}], ",", 
          RowBox[{"Max", "@", "Delta"}], ",", 
          RowBox[{"PermDeg", "[", 
           RowBox[{"Last", "@", "H0"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"mm", "=", 
        RowBox[{"permdeg", "-", 
         RowBox[{"Length", "@", "Delta"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Deltacompl", "=", 
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"Range", "@", "permdeg"}], ",", "Delta"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"H1", "=", 
        RowBox[{"DeleteSomeRedundantGenerators", "@", 
         RowBox[{"BaseChange2", "[", 
          RowBox[{"H0", ",", 
           RowBox[{"Join", "[", 
            RowBox[{"Deltacompl", ",", "Delta"}], "]"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"antisym", ",", "\[IndentingNewLine]", 
         RowBox[{"G1", "=", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"Antisymmetric", "[", 
             RowBox[{"Delta", ",", "Cycles"}], "]"}], ",", 
            RowBox[{"1", "->", 
             RowBox[{"First", "@", "H1"}]}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"G1", "=", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"Symmetric", "[", 
             RowBox[{"Delta", ",", "Cycles"}], "]"}], ",", 
            RowBox[{"1", "->", 
             RowBox[{"First", "@", "H1"}]}]}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<H1: \>\"", ",", "H1"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<G1: \>\"", ",", "G1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"chainH1", "=", 
        RowBox[{"StabilizerChain2", "[", "H1", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Hmm1", "=", 
        RowBox[{"chainH1", "[", 
         RowBox[{"[", "mm", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"alpham", "=", 
        RowBox[{"Hmm1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<permdeg: \>\"", ",", "permdeg"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<mm: \>\"", ",", "mm"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Hm: \>\"", ",", 
           RowBox[{
            RowBox[{"StabilizerChain", "[", "H1", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", "+", "mm"}], "]"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Hm-1: \>\"", ",", "Hmm1"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<alpham: \>\"", ",", "alpham"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Intersection", "[", 
           RowBox[{
            RowBox[{"Orbit", "[", 
             RowBox[{"alpham", ",", 
              RowBox[{"Hmm1", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "Delta"}], "]"}],
           "===", "Delta"}], ",", 
         RowBox[{"Kmm1", "=", "Hmm1"}], ",", 
         RowBox[{"Kmm1", "=", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"chainH1", "[", 
             RowBox[{"[", 
              RowBox[{"1", "+", "mm"}], "]"}], "]"}], ",", 
            RowBox[{"1", "->", 
             RowBox[{"chainH1", "[", 
              RowBox[{"[", 
               RowBox[{"mm", ",", "1"}], "]"}], "]"}]}]}], "]"}]}]}], "]"}], 
       ";", "\[IndentingNewLine]", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Kmm1: \>\"", ",", "Kmm1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"mm", "\[Equal]", "1"}], ",", 
         RowBox[{"K1", "=", "Kmm1"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"testfunc", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "@", 
              RowBox[{"Complement", "[", 
               RowBox[{"Deltacompl", ",", 
                RowBox[{"StablePoints", "[", 
                 RowBox[{
                  RowBox[{"First", "@", 
                   RowBox[{"SpecialPermWord", "[", 
                    RowBox[{"#", ",", "H1", ",", 
                    RowBox[{"Length", "@", "Delta"}]}], "]"}]}], ",", 
                  "permdeg"}], "]"}]}], "]"}]}], "==", "0"}], "&"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"GElements", "=", 
             RowBox[{"Rest", "[", 
              RowBox[{"List", "@@", 
               RowBox[{"Dimino", "[", "G1", "]"}]}], "]"}]}], ";"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "It", " ", "should", " ", "be", " ", "enough", " ", "to", " ", 
            "test", " ", "one", " ", "from", " ", "each", " ", "coset", " ", 
            RowBox[{"Hm", ".", "p"}], " ", "where", " ", "p", " ", "is", " ", 
            "in", " ", "G1"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"time", ",", "GElements"}], "}"}], "=", 
           RowBox[{"AbsoluteTiming", "[", 
            RowBox[{"InversePerm", "/@", 
             RowBox[{"Rest", "[", 
              RowBox[{"TransversalComputation", "[", 
               RowBox[{
                RowBox[{"chainH1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", "+", "mm"}], "]"}], "]"}], ",", 
                RowBox[{"ReplacePart", "[", 
                 RowBox[{"G1", ",", 
                  RowBox[{"1", "->", 
                   RowBox[{"chainH1", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", "+", "mm"}], ",", "1"}], "]"}], "]"}]}]}], 
                 "]"}]}], "]"}], "]"}]}], "]"}]}], ";", " ", 
          RowBox[{"If", "[", 
           RowBox[{"$MixedSymVerbose", ",", 
            RowBox[{"Print", "[", 
             RowBox[{
             "\"\<GElements timing: \>\"", ",", "time", ",", " ", 
              "\"\< length: \>\"", ",", " ", 
              RowBox[{"Length", "@", "GElements"}]}], "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<GElements: \>\"", ",", "GElements"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<testfunc: \>\"", ",", "testfunc"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<Search \>\"", ",", 
              RowBox[{"{", 
               RowBox[{"H1", ",", 
                RowBox[{
                 RowBox[{"GpinHGQBruteForceSymmetric", "[", 
                  RowBox[{"#", ",", "testfunc", ",", "GElements"}], "]"}], 
                 "&"}], ",", "1", ",", "Kmm1"}], "}"}]}], "]"}], ";"}], 
           "*)"}], "\[IndentingNewLine]", 
          RowBox[{"K1", "=", 
           RowBox[{"SearchSym1", "[", 
            RowBox[{"chainH1", ",", 
             RowBox[{
              RowBox[{"GpinHGQBruteForceSymmetric", "[", 
               RowBox[{"#", ",", "testfunc", ",", "GElements"}], "]"}], "&"}],
              ",", "1", ",", 
             RowBox[{"mm", "+", "1"}], ",", "Kmm1", ",", "Delta"}], "]"}]}], 
          ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<K1: \>\"", ",", "K1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{"StrongGenSet", "[", 
         RowBox[{
          RowBox[{"H1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Join", "[", 
           RowBox[{
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"K1", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"StabilizerChain2", "[", "H1", "]"}], "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"1", "+", "mm"}], ",", "2"}], "]"}], "]"}]}], "]"}], 
            ",", 
            RowBox[{"G1", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{"DeleteRedundantGenerators", "[", "F1", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"unstablepoints", "=", 
        RowBox[{"GroupSupport", "@", "F1"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<F1: \>\"", ",", "F1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"DeleteSomeRedundantGenerators", "@", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"BaseChange2", "[", 
             RowBox[{"F1", ",", "unstablepoints"}], "]"}], ",", 
            RowBox[{"1", "->", "unstablepoints"}]}], "]"}]}], ",", 
         RowBox[{"DeleteSomeRedundantGenerators", "@", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"BaseChange2", "[", 
             RowBox[{"K1", ",", "unstablepoints"}], "]"}], ",", 
            RowBox[{"1", "->", "unstablepoints"}]}], "]"}]}]}], "}"}]}]}], 
     "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.564635721342648*^9, 3.564635724993054*^9}, {
   3.564635859496491*^9, 3.5646358907433453`*^9}, {3.564636886207117*^9, 
   3.564636928529991*^9}, {3.564637010898136*^9, 3.564637039430586*^9}, {
   3.56463709323508*^9, 3.564637100629493*^9}, {3.56463733795371*^9, 
   3.56463737196277*^9}, {3.564637445501299*^9, 3.5646374557349176`*^9}, {
   3.5646383385152807`*^9, 3.564638338577681*^9}, {3.564638393318177*^9, 
   3.564638431007843*^9}, {3.5646389452471466`*^9, 3.5646389584603696`*^9}, {
   3.564673732694116*^9, 3.564673810522653*^9}, {3.565770461050004*^9, 
   3.5657705296901245`*^9}, {3.565770570952197*^9, 3.565770726749671*^9}, {
   3.5657719826766777`*^9, 3.5657720436103835`*^9}, {3.565772082002051*^9, 
   3.565772152155374*^9}, {3.5657722474247417`*^9, 3.565772306205644*^9}, 
   3.5657724648735237`*^9, {3.565772547007668*^9, 3.565772573699314*^9}, {
   3.565772843252188*^9, 3.565772873672241*^9}, {3.565772958832792*^9, 
   3.5657729770068226`*^9}, 3.565773025070507*^9, {3.5657732765897493`*^9, 
   3.5657732773229513`*^9}, {3.565773405352375*^9, 3.5657734078639793`*^9}, {
   3.5657754686872067`*^9, 3.565775508794876*^9}, {3.566203295496084*^9, 
   3.566203387239845*^9}, {3.566203660880926*^9, 3.566203662862129*^9}, {
   3.56620376565071*^9, 3.566203797802367*^9}, {3.56620391923298*^9, 
   3.566203924802189*^9}, {3.566216838497334*^9, 3.566216855267364*^9}, {
   3.566545681480978*^9, 3.566545716191039*^9}, {3.567083866371577*^9, 
   3.5670839186628685`*^9}, {3.567086226283322*^9, 3.567086363298363*^9}, {
   3.5670868522188215`*^9, 3.567086886897682*^9}, {3.5670883591980677`*^9, 
   3.567088399056138*^9}, {3.567088483530286*^9, 3.567088487867094*^9}, {
   3.5670885545104117`*^9, 3.567088569439637*^9}, {3.5670886647870045`*^9, 
   3.5670886742250214`*^9}, {3.567088780071207*^9, 3.567088785671618*^9}, 
   3.567088852049734*^9, {3.567088891845404*^9, 3.5670889383802853`*^9}, {
   3.567089279553884*^9, 3.567089279694285*^9}, {3.567089413932521*^9, 
   3.567089417364527*^9}, {3.5670903686853986`*^9, 3.567090382351022*^9}, {
   3.567090617599435*^9, 3.567090639813874*^9}, {3.567185525897864*^9, 
   3.5671855952877855`*^9}, {3.5671859366163855`*^9, 3.567185941748794*^9}, {
   3.56718686745442*^9, 3.567186897858874*^9}, {3.567187013813877*^9, 
   3.567187033407512*^9}, {3.5671870795367937`*^9, 3.567187080784795*^9}, {
   3.5671872703875284`*^9, 3.56718732838943*^9}, {3.567187979440974*^9, 
   3.56718798875419*^9}, {3.5671881317284403`*^9, 3.567188138202452*^9}, {
   3.567586569415182*^9, 3.5675865811464033`*^9}, {3.567597134329648*^9, 
   3.567597134891249*^9}, {3.567597234637824*^9, 3.567597259083067*^9}, {
   3.567597489729472*^9, 3.567597490119473*^9}, 3.5675999908984656`*^9, {
   3.5676001615783653`*^9, 3.567600167350375*^9}, {3.567600583621507*^9, 
   3.567600593028323*^9}, {3.56760088155083*^9, 3.5676008997404613`*^9}, {
   3.5676010947262044`*^9, 3.5676010950694046`*^9}, {3.567601130887068*^9, 
   3.567601135707477*^9}, {3.5676050580545654`*^9, 3.567605085448213*^9}, {
   3.5676087253110065`*^9, 3.5676087263250084`*^9}, {3.5676087693810844`*^9, 
   3.567608773140691*^9}, {3.5676088190827713`*^9, 3.5676088453532176`*^9}, {
   3.567608967860233*^9, 3.567608974693044*^9}, {3.5676186396369314`*^9, 
   3.567618647718746*^9}, {3.567619685026968*^9, 3.5676196863217697`*^9}, {
   3.567877539015509*^9, 3.567877545629921*^9}, {3.567877827959217*^9, 
   3.567877830580022*^9}, {3.567927195859852*^9, 3.567927198483857*^9}, {
   3.567927250197948*^9, 3.567927288667616*^9}, {3.5679295563977995`*^9, 
   3.5679295572870016`*^9}, {3.567929647174358*^9, 3.567929647642359*^9}, {
   3.567929975055734*^9, 3.5679299915293636`*^9}, {3.567930038221245*^9, 
   3.567930061371686*^9}, {3.567930122258593*^9, 3.567930123724995*^9}, 
   3.5679305025872607`*^9, {3.567930567857775*^9, 3.567930594455822*^9}, {
   3.567931001460537*^9, 3.567931012333756*^9}, {3.567931129583562*^9, 
   3.5679311823272552`*^9}, {3.567931280888228*^9, 3.56793131077788*^9}, {
   3.567931425999683*^9, 3.5679314464669194`*^9}, {3.5679314897891946`*^9, 
   3.567931493907603*^9}, {3.567931846437022*^9, 3.567931850243428*^9}, {
   3.56793258578472*^9, 3.567932596267939*^9}, {3.567932684922894*^9, 
   3.567932722128959*^9}, {3.567933047546532*^9, 3.567933084596596*^9}, {
   3.567933186854776*^9, 3.5679332158396273`*^9}, {3.567933416799179*^9, 
   3.567933424458793*^9}, {3.568116101735684*^9, 3.56811617407301*^9}, {
   3.5681163735505605`*^9, 3.5681163940957966`*^9}, {3.574831494688324*^9, 
   3.5748315254047785`*^9}, {3.5832182208816*^9, 3.583218229102814*^9}, {
   3.583221692434947*^9, 3.583221717831792*^9}, {3.583233375297602*^9, 
   3.583233395484038*^9}, 3.5838390332700863`*^9, {3.60156078493329*^9, 
   3.601560790933298*^9}, 3.603719723641595*^9, 3.615129525709032*^9, {
   3.619615197977562*^9, 3.619615217487589*^9}},
 CellLabel->
  "In[382]:=",ExpressionUUID->"3d75b7d3-aa00-432e-98da-696f20cf9a9b"],

Cell["\<\
An improved version. Updated 2013-10-09 and 2015-04-26. Bug detected \
2016-11-29.\
\>", "Text",
 CellChangeTimes->{{3.56792715503458*^9, 3.567927162272993*^9}, {
  3.5681163148632574`*^9, 3.568116360555738*^9}, {3.56811640172421*^9, 
  3.568116414984233*^9}, {3.590320299727844*^9, 3.590320303893051*^9}, {
  3.590320660572078*^9, 3.59032066153928*^9}, {3.590320730444601*^9, 
  3.5903207335490065`*^9}, {3.590320841001995*^9, 3.590320848865409*^9}, {
  3.639035618627385*^9, 3.639035624927394*^9}, {3.6894255644765167`*^9, 
  3.689425577787516*^9}},ExpressionUUID->"2c818ac7-cbfe-4978-a8a5-\
6b41b71beb3d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryOfProductOfGroupsSymmetricCase2", "[", 
   RowBox[{"Delta0_List", ",", "H0_StrongGenSet", ",", 
    RowBox[{"antisym_", ":", "False"}]}], "]"}], ":=", "\[IndentingNewLine]", 
  
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Delta", "=", 
       RowBox[{"Sort", "@", "Delta0"}]}], ",", "Deltacompl", ",", "G1", ",", 
      "H1", ",", " ", "chainH1", ",", "permdeg", ",", " ", "mm", ",", 
      "alpham", ",", "Hmm1", ",", "Kmm1", ",", "K1", ",", "F1", ",", " ", 
      "GElements", ",", " ", "unstablepoints", ",", "time"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Arrange", " ", "so", " ", "that", " ", "the", " ", "groups", " ", 
      "have", " ", "the", " ", "same", " ", "bases", " ", "and", " ", "cycle",
       " ", "notation"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<SymmetryOfProductOfGroupsBruteForce[\>\"", ",", "G0", ",", 
        "\"\<,\>\"", ",", "H0", ",", "\"\<]\>\""}], "]"}], ";"}], " ", "*)"}],
     "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"subsetQ", "[", 
       RowBox[{
        RowBox[{"GroupSupport", "@", "H0"}], ",", "Delta"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{"antisym", ",", "\[IndentingNewLine]", 
          RowBox[{"Antisymmetric", "[", 
           RowBox[{"Delta", ",", "Cycles"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Symmetric", "[", 
           RowBox[{"Delta", ",", "Cycles"}], "]"}]}], "]"}], ",", "H0"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"permdeg", "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"Max", "@@", 
           RowBox[{"First", "[", "H0", "]"}]}], ",", 
          RowBox[{"Max", "@", "Delta"}], ",", 
          RowBox[{"PermDeg", "[", 
           RowBox[{"Last", "@", "H0"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"mm", "=", 
        RowBox[{"permdeg", "-", 
         RowBox[{"Length", "@", "Delta"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Deltacompl", "=", 
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"Range", "@", "permdeg"}], ",", "Delta"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"H1", "=", 
        RowBox[{"DeleteSomeRedundantGenerators", "@", 
         RowBox[{"BaseChange2", "[", 
          RowBox[{"H0", ",", 
           RowBox[{"Join", "[", 
            RowBox[{"Deltacompl", ",", "Delta"}], "]"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"antisym", ",", "\[IndentingNewLine]", 
         RowBox[{"G1", "=", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"Antisymmetric", "[", 
             RowBox[{"Delta", ",", "Cycles"}], "]"}], ",", 
            RowBox[{"1", "->", 
             RowBox[{"First", "@", "H1"}]}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"G1", "=", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"Symmetric", "[", 
             RowBox[{"Delta", ",", "Cycles"}], "]"}], ",", 
            RowBox[{"1", "->", 
             RowBox[{"First", "@", "H1"}]}]}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<H1: \>\"", ",", "H1"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<G1: \>\"", ",", "G1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"chainH1", "=", 
        RowBox[{"StabilizerChain2", "[", "H1", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Hmm1", "=", 
        RowBox[{"chainH1", "[", 
         RowBox[{"[", "mm", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"alpham", "=", 
        RowBox[{"Hmm1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<permdeg: \>\"", ",", "permdeg"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<mm: \>\"", ",", "mm"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Hm: \>\"", ",", 
           RowBox[{"chainH1", "[", 
            RowBox[{"[", 
             RowBox[{"1", "+", "mm"}], "]"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Hm-1: \>\"", ",", "Hmm1"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<alpham: \>\"", ",", "alpham"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Intersection", "[", 
           RowBox[{
            RowBox[{"Orbit", "[", 
             RowBox[{"alpham", ",", 
              RowBox[{"Hmm1", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "Delta"}], "]"}],
           "===", "Delta"}], ",", 
         RowBox[{"Kmm1", "=", "Hmm1"}], ",", 
         RowBox[{"Kmm1", "=", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"chainH1", "[", 
             RowBox[{"[", 
              RowBox[{"1", "+", "mm"}], "]"}], "]"}], ",", 
            RowBox[{"1", "->", 
             RowBox[{"chainH1", "[", 
              RowBox[{"[", 
               RowBox[{"mm", ",", "1"}], "]"}], "]"}]}]}], "]"}]}]}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Kmm1: \>\"", ",", "Kmm1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"mm", "\[Equal]", "1"}], ",", 
         RowBox[{"K1", "=", "Kmm1"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"GElements", "=", 
            RowBox[{"Rest", "[", 
             RowBox[{"List", "@@", 
              RowBox[{"Dimino", "[", "G1", "]"}]}], "]"}]}], ";"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "It", " ", "should", " ", "be", " ", "enough", " ", "to", " ", 
           "test", " ", "one", " ", "from", " ", "each", " ", "coset", " ", 
           RowBox[{"Hm", ".", "p"}], " ", "where", " ", "p", " ", "is", " ", 
           "in", " ", "G1"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"time", ",", "GElements"}], "}"}], "=", 
           RowBox[{"AbsoluteTiming", "[", 
            RowBox[{"InversePerm", "/@", 
             RowBox[{"Rest", "[", 
              RowBox[{"TransversalComputation", "[", 
               RowBox[{
                RowBox[{"chainH1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", "+", "mm"}], "]"}], "]"}], ",", 
                RowBox[{"ReplacePart", "[", 
                 RowBox[{"G1", ",", 
                  RowBox[{"1", "->", 
                   RowBox[{"chainH1", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", "+", "mm"}], ",", "1"}], "]"}], "]"}]}]}], 
                 "]"}]}], "]"}], "]"}]}], "]"}]}], ";", " ", 
          RowBox[{"If", "[", 
           RowBox[{"$MixedSymVerbose", ",", 
            RowBox[{"Print", "[", 
             RowBox[{
             "\"\<GElements timing: \>\"", ",", "time", ",", " ", 
              "\"\< length: \>\"", ",", " ", 
              RowBox[{"Length", "@", "GElements"}]}], "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<GElements: \>\"", ",", "GElements"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<Search \>\"", ",", 
              RowBox[{"{", 
               RowBox[{"chainH1", ",", "1", ",", 
                RowBox[{"mm", "+", "1"}], ",", "Kmm1", ",", "Delta", ",", 
                "GElements"}], "}"}]}], "]"}], ";"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"K1", "=", 
           RowBox[{"SearchSym2", "[", 
            RowBox[{"chainH1", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"SchreierOrbits", "[", 
                RowBox[{"#", ",", "permdeg"}], "]"}], "&"}], "/@", 
              "chainH1"}], ",", "1", ",", 
             RowBox[{"mm", "+", "1"}], ",", "Kmm1", ",", "Delta", ",", 
             "GElements"}], "]"}]}], ";"}]}], "]"}], ";", 
       "\[IndentingNewLine]", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<K1: \>\"", ",", "K1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{"StrongGenSet", "[", 
         RowBox[{
          RowBox[{"H1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Join", "[", 
           RowBox[{
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"K1", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"chainH1", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"1", "+", "mm"}], ",", "2"}], "]"}], "]"}]}], "]"}], 
            ",", 
            RowBox[{"G1", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"F1", "=", 
        RowBox[{"DeleteSomeRedundantGenerators", "[", "F1", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"unstablepoints", "=", 
        RowBox[{"GroupSupport", "@", "F1"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<F1: \>\"", ",", "F1"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"DeleteSomeRedundantGenerators", "@", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"BaseChange2", "[", 
             RowBox[{"F1", ",", "unstablepoints"}], "]"}], ",", 
            RowBox[{"1", "->", "unstablepoints"}]}], "]"}]}], ",", 
         RowBox[{"DeleteSomeRedundantGenerators", "@", 
          RowBox[{"ReplacePart", "[", 
           RowBox[{
            RowBox[{"BaseChange2", "[", 
             RowBox[{"K1", ",", "unstablepoints"}], "]"}], ",", 
            RowBox[{"1", "->", "unstablepoints"}]}], "]"}]}]}], "}"}]}]}], 
     "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.583839172250731*^9, 3.583839218442412*^9}, {
   3.5838393372054205`*^9, 3.583839357017455*^9}, 3.583839454985627*^9, {
   3.5838397259737034`*^9, 3.583839739077727*^9}, {3.583847714886576*^9, 
   3.583847742217824*^9}, {3.5838510628472886`*^9, 3.5838510662480936`*^9}, {
   3.584166674986357*^9, 3.584166677919163*^9}, {3.5841670469700117`*^9, 
   3.58416709182009*^9}, {3.584167154032999*^9, 3.584167167059022*^9}, {
   3.584167288208835*^9, 3.584167305821265*^9}, {3.584167337551721*^9, 
   3.584167340266126*^9}, {3.5841674319162865`*^9, 3.584167432680688*^9}, {
   3.5841674863447824`*^9, 3.584167488918787*^9}, 3.5841675311948614`*^9, 
   3.584167574937338*^9, {3.584167620863819*^9, 3.584167626167828*^9}, {
   3.5841676638574953`*^9, 3.5841676749803143`*^9}, {3.584168486307539*^9, 
   3.58416849268795*^9}, {3.5841694090969596`*^9, 3.584169429891796*^9}, {
   3.5841695162223487`*^9, 3.584169516487549*^9}, {3.584169648775781*^9, 
   3.584169649992583*^9}, {3.584176063633693*^9, 3.584176064866095*^9}, {
   3.584176169152278*^9, 3.584176172693485*^9}, {3.5841778787182307`*^9, 
   3.584177891759854*^9}, {3.584178076714778*^9, 3.584178098695217*^9}, {
   3.584178293430359*^9, 3.5841783074547834`*^9}, {3.584178348186455*^9, 
   3.584178383426917*^9}, 3.5841831553076987`*^9, {3.5841843402243805`*^9, 
   3.5841844708590097`*^9}, {3.5841848400346584`*^9, 
   3.5841848429830637`*^9}, {3.5841862337421055`*^9, 
   3.5841862626021576`*^9}, {3.584186301259024*^9, 3.584186321071059*^9}, {
   3.584196444722562*^9, 3.584196515406286*^9}, {3.584198548012856*^9, 
   3.5841985534884653`*^9}, 3.5841997952672467`*^9, 3.5841998783373938`*^9, {
   3.584199915637059*^9, 3.584199952142123*^9}, {3.584200176361316*^9, 
   3.584200177905719*^9}, {3.584201361870798*^9, 3.584201377751626*^9}, {
   3.584201631782473*^9, 3.5842016838865643`*^9}, {3.590320598296769*^9, 
   3.590320614395997*^9}, 3.5903206743781023`*^9, {3.5903207505998373`*^9, 
   3.590320768851869*^9}, 3.6015607971033072`*^9, 3.6151295380990496`*^9, {
   3.639035628347399*^9, 3.639035637117411*^9}},
 CellLabel->
  "In[383]:=",ExpressionUUID->"0291c59f-2a8b-4c13-acc4-9d81251aac0a"],

Cell["Attempted bugfix 2016-11-29. Only works with antisym=False.", "Text",
 CellChangeTimes->{{3.56792715503458*^9, 3.567927162272993*^9}, {
  3.5681163148632574`*^9, 3.568116360555738*^9}, {3.56811640172421*^9, 
  3.568116414984233*^9}, {3.590320299727844*^9, 3.590320303893051*^9}, {
  3.590320660572078*^9, 3.59032066153928*^9}, {3.590320730444601*^9, 
  3.5903207335490065`*^9}, {3.590320841001995*^9, 3.590320848865409*^9}, {
  3.639035618627385*^9, 3.639035624927394*^9}, {3.6894255644765167`*^9, 
  3.689425577787516*^9}, {3.6894256192725167`*^9, 
  3.6894256424955173`*^9}},ExpressionUUID->"00cfdb42-3a82-48d9-824f-\
3ab5b761836a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryOfProductOfGroupsSymmetricCase2b", "[", 
   RowBox[{"Delta0_List", ",", "H0_StrongGenSet", ",", 
    RowBox[{"antisym_", ":", "False"}]}], "]"}], ":=", "\[IndentingNewLine]", 
  
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Delta", "=", 
       RowBox[{"Sort", "@", "Delta0"}]}], ",", "Deltacompl", ",", "H0b", ",", 
      "G1", ",", "H1", ",", " ", "chainH1", ",", "origpermdeg", ",", 
      "permdeg", ",", " ", "mm", ",", "alpham", ",", "Hmm1", ",", "Kmm1", ",",
       "K1", ",", "F1", ",", " ", "GElements", ",", " ", "unstablepoints", 
      ",", " ", "unstablepointsnosign", ",", "time"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Arrange", " ", "so", " ", "that", " ", "the", " ", "groups", " ", 
      "have", " ", "the", " ", "same", " ", "bases", " ", "and", " ", "cycle",
       " ", "notation"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{"antisym", ",", 
       RowBox[{
       "Print", "[", 
        "\"\<Warning: SymmetryOfProductOfGroupsSymmetricCase2b called with \
antisym=True\>\"", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"subsetQ", "[", 
        RowBox[{
         RowBox[{"GroupSupport", "@", "H0"}], ",", "Delta"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"antisym", ",", "\[IndentingNewLine]", 
           RowBox[{"Antisymmetric", "[", 
            RowBox[{"Delta", ",", "Cycles"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Symmetric", "[", 
            RowBox[{"Delta", ",", "Cycles"}], "]"}]}], "]"}], ",", "H0"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"origpermdeg", "=", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"Max", "@@", 
            RowBox[{"First", "[", "H0", "]"}]}], ",", 
           RowBox[{"Max", "@", "Delta"}], ",", 
           RowBox[{"PermDeg", "[", 
            RowBox[{"Last", "@", "H0"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"H0b", "=", 
         RowBox[{"xAct`xPerm`Private`FromSign", "[", 
          RowBox[{"H0", ",", "origpermdeg"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permdeg", "=", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"Max", "@@", 
            RowBox[{"First", "[", "H0b", "]"}]}], ",", 
           RowBox[{"Max", "@", "Delta"}], ",", 
           RowBox[{"PermDeg", "[", 
            RowBox[{"Last", "@", "H0b"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mm", "=", 
         RowBox[{"permdeg", "-", 
          RowBox[{"Length", "@", "Delta"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Deltacompl", "=", 
         RowBox[{"Complement", "[", 
          RowBox[{
           RowBox[{"Range", "@", "permdeg"}], ",", "Delta"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"H1", "=", 
         RowBox[{"DeleteSomeRedundantGenerators", "@", 
          RowBox[{"BaseChange2", "[", 
           RowBox[{"H0b", ",", 
            RowBox[{"Join", "[", 
             RowBox[{"Deltacompl", ",", "Delta"}], "]"}]}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"antisym", ",", "\[IndentingNewLine]", 
          RowBox[{"G1", "=", 
           RowBox[{"DeleteSomeRedundantGenerators", "@", 
            RowBox[{"BaseChange2", "[", 
             RowBox[{
              RowBox[{"xAct`xPerm`Private`FromSign", "[", 
               RowBox[{
                RowBox[{"Antisymmetric", "[", 
                 RowBox[{"Delta", ",", "Cycles"}], "]"}], ",", 
                "origpermdeg"}], "]"}], ",", 
              RowBox[{"First", "@", "H1"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"G1", "=", 
           RowBox[{"ReplacePart", "[", 
            RowBox[{
             RowBox[{"Symmetric", "[", 
              RowBox[{"Delta", ",", "Cycles"}], "]"}], ",", 
             RowBox[{"1", "->", 
              RowBox[{"First", "@", "H1"}]}]}], "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<H1: \>\"", ",", "H1"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<G1: \>\"", ",", "G1"}], "]"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"chainH1", "=", 
         RowBox[{"StabilizerChain2", "[", "H1", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Hmm1", "=", 
         RowBox[{"chainH1", "[", 
          RowBox[{"[", "mm", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"alpham", "=", 
         RowBox[{"Hmm1", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<permdeg: \>\"", ",", "permdeg"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<mm: \>\"", ",", "mm"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Hm: \>\"", ",", 
            RowBox[{"chainH1", "[", 
             RowBox[{"[", 
              RowBox[{"1", "+", "mm"}], "]"}], "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Hm-1: \>\"", ",", "Hmm1"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<alpham: \>\"", ",", "alpham"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Orbit alpham: \>\"", ",", 
            RowBox[{"Orbit", "[", 
             RowBox[{"alpham", ",", 
              RowBox[{"Hmm1", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], ";"}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "The", " ", "following", " ", "line", " ", "is", " ", "probably", 
           " ", "wrong", " ", "if", " ", "Hmm1", " ", "has", " ", "signed", 
           " ", "permutations"}], "..."}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Intersection", "[", 
            RowBox[{
             RowBox[{"Orbit", "[", 
              RowBox[{"alpham", ",", 
               RowBox[{"Hmm1", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "Delta"}], 
            "]"}], "===", "Delta"}], ",", 
          RowBox[{"Kmm1", "=", "Hmm1"}], ",", 
          RowBox[{"Kmm1", "=", 
           RowBox[{"ReplacePart", "[", 
            RowBox[{
             RowBox[{"chainH1", "[", 
              RowBox[{"[", 
               RowBox[{"1", "+", "mm"}], "]"}], "]"}], ",", 
             RowBox[{"1", "->", 
              RowBox[{"chainH1", "[", 
               RowBox[{"[", 
                RowBox[{"mm", ",", "1"}], "]"}], "]"}]}]}], "]"}]}]}], "]"}], 
        ";", "\[IndentingNewLine]", " ", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Kmm1: \>\"", ",", "Kmm1"}], "]"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"mm", "\[Equal]", "1"}], ",", 
          RowBox[{"K1", "=", "Kmm1"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"GElements", "=", 
             RowBox[{"Rest", "[", 
              RowBox[{"List", "@@", 
               RowBox[{"Dimino", "[", "G1", "]"}]}], "]"}]}], ";"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "It", " ", "should", " ", "be", " ", "enough", " ", "to", " ", 
            "test", " ", "one", " ", "from", " ", "each", " ", "coset", " ", 
            RowBox[{"Hm", ".", "p"}], " ", "where", " ", "p", " ", "is", " ", 
            "in", " ", "G1"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"time", ",", "GElements"}], "}"}], "=", 
            RowBox[{"AbsoluteTiming", "[", 
             RowBox[{"InversePerm", "/@", 
              RowBox[{"Rest", "[", 
               RowBox[{"TransversalComputation", "[", 
                RowBox[{
                 RowBox[{"chainH1", "[", 
                  RowBox[{"[", 
                   RowBox[{"1", "+", "mm"}], "]"}], "]"}], ",", 
                 RowBox[{"ReplacePart", "[", 
                  RowBox[{"G1", ",", 
                   RowBox[{"1", "->", 
                    RowBox[{"chainH1", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", "+", "mm"}], ",", "1"}], "]"}], "]"}]}]}], 
                  "]"}]}], "]"}], "]"}]}], "]"}]}], ";", " ", 
           RowBox[{"If", "[", 
            RowBox[{"$MixedSymVerbose", ",", 
             RowBox[{"Print", "[", 
              RowBox[{
              "\"\<GElements timing: \>\"", ",", "time", ",", " ", 
               "\"\< length: \>\"", ",", " ", 
               RowBox[{"Length", "@", "GElements"}]}], "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<GElements: \>\"", ",", "GElements"}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Print", "[", 
              RowBox[{"\"\<Search \>\"", ",", 
               RowBox[{"{", 
                RowBox[{"chainH1", ",", "1", ",", 
                 RowBox[{"mm", "+", "1"}], ",", "Kmm1", ",", "Delta", ",", 
                 "GElements"}], "}"}]}], "]"}], ";"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"K1", "=", 
            RowBox[{"SearchSym2", "[", 
             RowBox[{"chainH1", ",", 
              RowBox[{
               RowBox[{
                RowBox[{"SchreierOrbits", "[", 
                 RowBox[{"#", ",", "permdeg"}], "]"}], "&"}], "/@", 
               "chainH1"}], ",", "1", ",", 
              RowBox[{"mm", "+", "1"}], ",", "Kmm1", ",", "Delta", ",", 
              "GElements"}], "]"}]}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "  ", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<K1: \>\"", ",", "K1"}], "]"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"F1", "=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"H1", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"Join", "[", 
            RowBox[{
             RowBox[{"Complement", "[", 
              RowBox[{
               RowBox[{"K1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"chainH1", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", "+", "mm"}], ",", "2"}], "]"}], "]"}]}], "]"}],
              ",", 
             RowBox[{"G1", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"F1", "=", 
         RowBox[{"DeleteSomeRedundantGenerators", "[", "F1", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"unstablepoints", "=", 
         RowBox[{"GroupSupport", "@", "F1"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"unstablepointsnosign", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{"unstablepoints", ",", 
           RowBox[{
            RowBox[{"origpermdeg", "+", "1"}], "|", 
            RowBox[{"origpermdeg", "+", "2"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<F1: \>\"", ",", "F1"}], "]"}], ";", 
          "\[IndentingNewLine]", " ", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<unstablepoints: \>\"", ",", "unstablepoints"}], "]"}],
           ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"DeleteSomeRedundantGenerators", "@", 
           RowBox[{"ReplacePart", "[", 
            RowBox[{
             RowBox[{"xAct`xPerm`Private`ToSign", "[", 
              RowBox[{
               RowBox[{"BaseChange2", "[", 
                RowBox[{"F1", ",", "unstablepoints"}], "]"}], ",", 
               "origpermdeg"}], "]"}], ",", 
             RowBox[{"1", "->", "unstablepointsnosign"}]}], "]"}]}], ",", 
          RowBox[{"DeleteSomeRedundantGenerators", "@", 
           RowBox[{"ReplacePart", "[", 
            RowBox[{
             RowBox[{"xAct`xPerm`Private`ToSign", "[", 
              RowBox[{
               RowBox[{"BaseChange2", "[", 
                RowBox[{"K1", ",", "unstablepoints"}], "]"}], ",", 
               "origpermdeg"}], "]"}], ",", 
             RowBox[{"1", "->", "unstablepointsnosign"}]}], "]"}]}]}], 
         "}"}]}]}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.689425759099516*^9, 3.689425864405516*^9}},
 CellLabel->
  "In[384]:=",ExpressionUUID->"fe1c3c30-a6ef-473b-bc25-e760d1f214b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SearchSym1", "[", 
    RowBox[{
    "chain_List", ",", "property_", ",", "s_Integer", ",", " ", "l_Integer", 
     ",", "SGSK_", ",", "Delta_", ",", "options___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"base", "=", 
        RowBox[{"chain", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"newSGSK", "=", "SGSK"}], ",", 
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"Length", "[", "chain", "]"}], "-", "1"}]}], ",", "Deltas", 
       ",", "gammas", ",", "Korbit", ",", "verb"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"verb", "=", 
       RowBox[{
        RowBox[{"xPermVerbose", "/.", 
         RowBox[{"CheckOptions", "[", "options", "]"}]}], "/.", 
        RowBox[{"Options", "[", "Search", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"verb", ",", " ", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<SearchSym1[\>\"", ",", "chain", ",", "\"\<,\>\"", ",", 
          "property", ",", "\"\<,\>\"", ",", "s", ",", "\"\<,\>\"", ",", " ", 
          "l", ",", "\"\<,\>\"", ",", "SGSK", ",", "\"\<,\>\"", ",", "Delta", 
          ",", "\"\<]\>\""}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"s", "\[Equal]", 
         RowBox[{"l", "-", "1"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"newSGSK", "=", "SGSK"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"newSGSK", "=", 
          RowBox[{"SearchSym1", "[", 
           RowBox[{"chain", ",", "property", ",", 
            RowBox[{"s", "+", "1"}], ",", "l", ",", "SGSK", ",", "Delta", ",",
             "options"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Deltas", "=", 
          RowBox[{"Orbit", "[", 
           RowBox[{
            RowBox[{"base", "[", 
             RowBox[{"[", "s", "]"}], "]"}], ",", 
            RowBox[{"chain", "[", 
             RowBox[{"[", 
              RowBox[{"s", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Intersection", "[", 
             RowBox[{"Deltas", ",", "Delta"}], "]"}], "=!=", "Delta"}], ",", 
           RowBox[{"Deltas", "=", 
            RowBox[{"Complement", "[", 
             RowBox[{"Deltas", ",", "Delta"}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<Branching over points \>\"", ",", "Deltas", ",", " ", 
             "\"\< s=\>\"", ",", "s"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Avoid", " ", "rechecking", " ", 
           RowBox[{"permutations", ".", " ", "Not"}], " ", "in", " ", 
           RowBox[{"Butler", "'"}], "s", " ", "algorithm"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"s", "=!=", "k"}], ",", 
             RowBox[{"Deltas", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"Deltas", ",", "1"}], "]"}]}]}], "]"}], ";"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"s", "=!=", 
            RowBox[{"l", "-", "2"}]}], ",", 
           RowBox[{"Deltas", "=", 
            RowBox[{"Drop", "[", 
             RowBox[{"Deltas", ",", "1"}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"gammas", "=", 
             RowBox[{"Deltas", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"Korbit", "=", 
             RowBox[{"Orbit", "[", 
              RowBox[{"gammas", ",", 
               RowBox[{"newSGSK", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"verb", ",", 
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<gammas \>\"", ",", " ", "gammas", ",", " ", 
                "\"\< Korbit \>\"", ",", " ", "Korbit"}], "]"}]}], "]"}], ";",
             "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"gammas", "===", 
               RowBox[{"MinB", "[", 
                RowBox[{"Korbit", ",", "base"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"newSGSK", "=", 
                RowBox[{"GenerateSym1", "[", 
                 RowBox[{"chain", ",", "property", ",", "s", ",", "l", ",", 
                  RowBox[{"s", "+", "1"}], ",", 
                  RowBox[{"Append", "[", 
                   RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"base", ",", 
                    RowBox[{"s", "-", "1"}]}], "]"}], ",", "gammas"}], "]"}], 
                  ",", "newSGSK", ",", "Delta", ",", "verb"}], "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Head", "[", "newSGSK", "]"}], "===", "Times"}], 
                 ",", 
                 RowBox[{"newSGSK", "=", 
                  RowBox[{"-", "newSGSK"}]}]}], "]"}]}]}], "]"}]}], 
           "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "Deltas", "]"}]}], "}"}]}], "]"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"verb", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Return SGSK: \>\"", ",", " ", "newSGSK"}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "newSGSK"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567185633461053*^9, 3.567185684597943*^9}, {
   3.56718575710687*^9, 3.5671858788650846`*^9}, {3.567186054396592*^9, 
   3.567186117093102*^9}, {3.567186231098103*^9, 3.5671862317377043`*^9}, {
   3.567186338285891*^9, 3.567186363994736*^9}, {3.567186419936434*^9, 
   3.5671864248036423`*^9}, 3.5671864580005016`*^9, {3.567186539682245*^9, 
   3.567186545719455*^9}, {3.5671866005379524`*^9, 3.567186616434379*^9}, {
   3.5671866550132465`*^9, 3.567186659537255*^9}, {3.56718673644539*^9, 
   3.567186747989412*^9}, {3.567187461535664*^9, 3.567187464140868*^9}, {
   3.567596477520695*^9, 3.567596478175896*^9}, {3.567597156918488*^9, 
   3.5675971569340887`*^9}, {3.5675973215143776`*^9, 
   3.5675973218107786`*^9}, {3.567597360764046*^9, 3.567597360795246*^9}, {
   3.56759749985389*^9, 3.567597506203101*^9}, {3.567597676680201*^9, 
   3.567597735897905*^9}, {3.567597793368406*^9, 3.5675978229772587`*^9}, {
   3.567598126740991*^9, 3.567598131108999*^9}, {3.5675982675624394`*^9, 
   3.5675983186681285`*^9}, {3.567598374968627*^9, 3.567598386029047*^9}, {
   3.56759905971723*^9, 3.567599060918432*^9}, {3.567599161257809*^9, 
   3.567599161881809*^9}, {3.5675992049378858`*^9, 3.5675992090406933`*^9}, {
   3.5676024333801546`*^9, 3.567602456436996*^9}, {3.567606624157916*^9, 
   3.5676066305383277`*^9}, {3.5676068023102293`*^9, 
   3.5676068394070945`*^9}, {3.567607017949408*^9, 3.567607018417409*^9}, {
   3.567607407809693*^9, 3.567607420679715*^9}, {3.567608855976836*^9, 
   3.567608859128042*^9}, {3.56761898038933*^9, 3.567618998812963*^9}, {
   3.5838400811707273`*^9, 3.583840085070734*^9}, {3.583840422670927*^9, 
   3.583840455930185*^9}, {3.5838476333140326`*^9, 3.5838476561524734`*^9}, {
   3.58390298829706*^9, 3.583903033053539*^9}},
 CellLabel->
  "In[385]:=",ExpressionUUID->"3c746381-8596-4faf-88b4-7588199fafc9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenerateSym1", "[", 
    RowBox[{
    "chain_List", ",", "property_", ",", "s_", ",", "l_", ",", "i_", ",", 
     "list_", ",", "SGSK_", ",", "Delta_", ",", "verb_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"base", "=", 
        RowBox[{"chain", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"Length", "[", "chain", "]"}], "-", "1"}]}], ",", "g", ",", 
       RowBox[{"newSGSK", "=", "SGSK"}], ",", "Deltag", ",", "gammai", ",", 
       "otherSGSK", ",", 
       RowBox[{"schvecs", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"SchreierOrbits", "[", 
           RowBox[{"#", ",", 
            RowBox[{"PermLength", "[", 
             RowBox[{"chain", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}], "&"}], "/@", 
         "chain"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", " ", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<GenerateSym1[\>\"", ",", "chain", ",", "\"\<,\>\"", ",", 
           "property", ",", "\"\<,\>\"", ",", "s", ",", "\"\<,\>\"", ",", "l",
            ",", "\"\<,\>\"", ",", "i", ",", "\"\<,\>\"", ",", "list", ",", 
           "\"\<,\>\"", ",", "SGSK", ",", "\"\<,\>\"", ",", "Delta", ",", 
           "\"\<,\>\"", ",", "verb", ",", "\"\<]\>\""}], "]"}]}], "]"}], 
       ";"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g", "=", 
       RowBox[{"First", "@", 
        RowBox[{"FromBaseImage2", "[", 
         RowBox[{"list", ",", "schvecs"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"verb", ",", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Pregenerate at level \>\"", ",", "s", ",", "\"\< with i=\>\"", 
          ",", "i", ",", "\"\<. We have list \>\"", ",", "list", ",", 
          "\"\< and permutation \>\"", ",", "g"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i", "\[Equal]", "l"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<Generate at level \>\"", ",", "s", ",", "\"\< with i=\>\"", 
             ",", "i", ",", "\"\<. We have list \>\"", ",", "list", ",", 
             "\"\< and permutation \>\"", ",", "g"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Not", "@", 
             RowBox[{"PermEqual", "[", 
              RowBox[{"g", ",", "ID"}], "]"}]}], "&&", 
            RowBox[{"Or", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "@", 
                RowBox[{"Intersection", "[", 
                 RowBox[{"Delta", ",", "list"}], "]"}]}], "\[Equal]", "0"}], 
              ",", 
              RowBox[{"property", "[", "g", "]"}]}], "]"}], "&&", 
            RowBox[{"Not", "@", 
             RowBox[{"PermMemberQ", "[", 
              RowBox[{"g", ",", "SGSK"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"newSGSK", "=", 
             RowBox[{"-", 
              RowBox[{"StrongGenSet", "[", 
               RowBox[{
                RowBox[{"chain", "[", 
                 RowBox[{"[", 
                  RowBox[{"s", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"Append", "[", 
                 RowBox[{
                  RowBox[{"Last", "[", "SGSK", "]"}], ",", "g"}], "]"}]}], 
               "]"}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"verb", ",", 
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<  Added permutation \>\"", ",", "g", ",", 
                "\"\< New SGSK: \>\"", ",", " ", "newSGSK"}], "]"}]}], 
             "]"}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Deltag", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{
            RowBox[{"Orbit", "[", 
             RowBox[{
              RowBox[{"base", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"chain", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}], ",", "g"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "Here", " ", "we", " ", "should", " ", "check", " ", "if", " ", 
            "a", " ", "point", " ", "in", " ", "Deltag", " ", "is", " ", "in",
             " ", "Delta"}], ",", " ", "\[IndentingNewLine]", 
           RowBox[{
           "then", " ", "the", " ", "entire", " ", "Delta", " ", "has", " ", 
            "to", " ", "be", " ", "in", " ", "the", " ", "orbit", " ", "in", 
            " ", 
            RowBox[{
             RowBox[{"chain", "[", 
              RowBox[{"[", "s", "]"}], "]"}], ".", " ", "\[IndentingNewLine]",
              "Otherwise"}], " ", "g", " ", "can", " ", "not", " ", "be", " ",
             "in", " ", "the", " ", 
            RowBox[{"group", ".", " ", "\[IndentingNewLine]", "Can"}], " ", 
            "we", " ", "refine", " ", "this", " ", "to", " ", "the", " ", 
            "orbit", " ", "in", " ", 
            RowBox[{"chain", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{"??", "?"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Deltag", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"Deltag", ",", 
            RowBox[{
             RowBox[{"Or", "[", 
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{"Delta", ",", "#"}], "]"}], ",", 
               RowBox[{"subsetQ", "[", 
                RowBox[{"Delta", ",", 
                 RowBox[{"Orbit", "[", 
                  RowBox[{"#", ",", 
                   RowBox[{"chain", "[", 
                    RowBox[{"[", 
                    RowBox[{"s", ",", "2"}], "]"}], "]"}]}], "]"}]}], "]"}]}],
               "]"}], "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<Generating over points \>\"", ",", "Deltag", ",", " ", 
             "\"\<, s=\>\"", ",", " ", "s", ",", " ", "\"\<, i=\>\"", ",", 
             "i", ",", "\"\<, list \>\"", ",", "list"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"gammai", "=", 
             RowBox[{"Deltag", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"newSGSK", "=", 
             RowBox[{"GenerateSym1", "[", 
              RowBox[{"chain", ",", "property", ",", "s", ",", "l", ",", 
               RowBox[{"i", "+", "1"}], ",", 
               RowBox[{"Append", "[", 
                RowBox[{"list", ",", "gammai"}], "]"}], ",", "newSGSK", ",", 
               "Delta", ",", "verb"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Head", "[", "newSGSK", "]"}], "===", "Times"}], ",", 
              RowBox[{"Break", "[", "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "Deltag", "]"}]}], "}"}]}], "]"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "newSGSK"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5671874385568237`*^9, 3.567187445389635*^9}, {
   3.5671877458305635`*^9, 3.567187746485764*^9}, {3.56718786357957*^9, 
   3.567187866527975*^9}, {3.567188073540339*^9, 3.567188077143945*^9}, {
   3.567596488783914*^9, 3.5675965096567516`*^9}, {3.5675965946467*^9, 
   3.5675965964563046`*^9}, 3.567596699634885*^9, {3.567597142831663*^9, 
   3.567597143065664*^9}, {3.567598137879411*^9, 3.567598161279452*^9}, {
   3.5675982328679786`*^9, 3.56759823447478*^9}, {3.567598410942291*^9, 
   3.567598436245535*^9}, {3.567599045864406*^9, 3.5675990520732174`*^9}, {
   3.5676019339764786`*^9, 3.567601940060489*^9}, {3.567602462209007*^9, 
   3.567602495546264*^9}, {3.5676025526579657`*^9, 3.5676025530947657`*^9}, {
   3.5676046014885635`*^9, 3.5676046209729986`*^9}, {3.567604851057802*^9, 
   3.567604862570623*^9}, {3.567606641848348*^9, 3.5676066419107475`*^9}, {
   3.567606706510461*^9, 3.567606706806862*^9}, {3.567614385796847*^9, 
   3.567614406248483*^9}, {3.567614469615794*^9, 3.567614517102278*^9}, {
   3.567615044882405*^9, 3.567615055927224*^9}, {3.5676151185457335`*^9, 
   3.567615151118591*^9}, {3.567615223455919*^9, 3.5676152363727407`*^9}, {
   3.567616101253859*^9, 3.5676161352619195`*^9}, {3.5676161722027845`*^9, 
   3.5676162170840635`*^9}, {3.5676162613101406`*^9, 3.567616287830188*^9}, {
   3.567616385361559*^9, 3.5676163934735727`*^9}, {3.567618036883073*^9, 
   3.567618054885505*^9}, {3.567618118908017*^9, 3.5676181965493536`*^9}, {
   3.56761826264667*^9, 3.567618307902349*^9}, {3.567618375278867*^9, 
   3.567618400644512*^9}, {3.567618448598996*^9, 3.5676186169232917`*^9}, {
   3.567927213771884*^9, 3.56792721743789*^9}, {3.567929805421036*^9, 
   3.567929831114281*^9}, {3.567929904169209*^9, 3.567929907039615*^9}, {
   3.567930307945719*^9, 3.5679303084293203`*^9}, {3.5679304778456182`*^9, 
   3.5679304797488203`*^9}, {3.583840202928941*^9, 3.5838402931126995`*^9}, {
   3.5838470023241243`*^9, 3.583847021465358*^9}, {3.5838473037634535`*^9, 
   3.5838473178658786`*^9}, {3.584168718295547*^9, 3.5841687433647904`*^9}, {
   3.5841709893339357`*^9, 3.584170992578741*^9}, {3.5841816847545156`*^9, 
   3.5841816870633206`*^9}, {3.584181803860725*^9, 3.58418184091079*^9}, {
   3.584182326648843*^9, 3.584182346055277*^9}, {3.584182392169958*^9, 
   3.584182395648764*^9}, 3.6151295428990574`*^9},
 CellLabel->
  "In[386]:=",ExpressionUUID->"d056839a-f2c5-4cb5-b52b-f07067c362d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SearchSym2", "[", 
    RowBox[{
    "chain_List", ",", "schvecs_", ",", "s_Integer", ",", " ", "l_Integer", 
     ",", "SGSK_", ",", "Delta_", ",", "GElements_", ",", "options___"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"base", "=", 
        RowBox[{"chain", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"newSGSK", "=", "SGSK"}], ",", 
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"Length", "[", "chain", "]"}], "-", "1"}]}], ",", "Deltas", 
       ",", "gammas", ",", "Korbit", ",", "verb"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"verb", "=", 
       RowBox[{
        RowBox[{"xPermVerbose", "/.", 
         RowBox[{"CheckOptions", "[", "options", "]"}]}], "/.", 
        RowBox[{"Options", "[", "Search", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"verb", ",", " ", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<SearchSym2[\>\"", ",", "chain", ",", "\"\<,\>\"", ",", 
          "schvecs", ",", "\"\<,\>\"", ",", "s", ",", "\"\<,\>\"", ",", " ", 
          "l", ",", "\"\<,\>\"", ",", "SGSK", ",", "\"\<,\>\"", ",", "Delta", 
          ",", "\"\<,\>\"", ",", "GElements", ",", "\"\<]\>\""}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"s", "\[Equal]", 
         RowBox[{"l", "-", "1"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"newSGSK", "=", "SGSK"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"newSGSK", "=", 
          RowBox[{"SearchSym2", "[", 
           RowBox[{"chain", ",", "schvecs", ",", 
            RowBox[{"s", "+", "1"}], ",", "l", ",", "SGSK", ",", "Delta", ",",
             "GElements", ",", "options"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Deltas", "=", 
          RowBox[{"Orbit", "[", 
           RowBox[{
            RowBox[{"base", "[", 
             RowBox[{"[", "s", "]"}], "]"}], ",", 
            RowBox[{"chain", "[", 
             RowBox[{"[", 
              RowBox[{"s", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Intersection", "[", 
             RowBox[{"Deltas", ",", "Delta"}], "]"}], "=!=", "Delta"}], ",", 
           RowBox[{"Deltas", "=", 
            RowBox[{"Complement", "[", 
             RowBox[{"Deltas", ",", "Delta"}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<Branching over points \>\"", ",", "Deltas", ",", " ", 
             "\"\< s=\>\"", ",", "s"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Avoid", " ", "rechecking", " ", 
           RowBox[{"permutations", ".", " ", "Not"}], " ", "in", " ", 
           RowBox[{"Butler", "'"}], "s", " ", "algorithm"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"s", "=!=", "k"}], ",", 
             RowBox[{"Deltas", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{"Deltas", ",", "1"}], "]"}]}]}], "]"}], ";"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"s", "=!=", 
            RowBox[{"l", "-", "2"}]}], ",", 
           RowBox[{"Deltas", "=", 
            RowBox[{"Drop", "[", 
             RowBox[{"Deltas", ",", "1"}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"gammas", "=", 
             RowBox[{"Deltas", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"Korbit", "=", 
             RowBox[{"Orbit", "[", 
              RowBox[{"gammas", ",", 
               RowBox[{"newSGSK", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"verb", ",", 
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<gammas \>\"", ",", " ", "gammas", ",", " ", 
                "\"\< Korbit \>\"", ",", " ", "Korbit"}], "]"}]}], "]"}], ";",
             "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"gammas", "===", 
               RowBox[{"MinB", "[", 
                RowBox[{"Korbit", ",", "base"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"newSGSK", "=", 
                RowBox[{"GenerateSym2", "[", 
                 RowBox[{"chain", ",", "schvecs", ",", "s", ",", "l", ",", 
                  RowBox[{"s", "+", "1"}], ",", 
                  RowBox[{"Append", "[", 
                   RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"base", ",", 
                    RowBox[{"s", "-", "1"}]}], "]"}], ",", "gammas"}], "]"}], 
                  ",", "newSGSK", ",", "Delta", ",", "GElements", ",", 
                  "verb"}], "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Head", "[", "newSGSK", "]"}], "===", "Times"}], 
                 ",", 
                 RowBox[{"newSGSK", "=", 
                  RowBox[{"-", "newSGSK"}]}]}], "]"}]}]}], "]"}]}], 
           "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "Deltas", "]"}]}], "}"}]}], "]"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"verb", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Return SGSK: \>\"", ",", " ", "newSGSK"}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "newSGSK"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567185633461053*^9, 3.567185684597943*^9}, {
   3.56718575710687*^9, 3.5671858788650846`*^9}, {3.567186054396592*^9, 
   3.567186117093102*^9}, {3.567186231098103*^9, 3.5671862317377043`*^9}, {
   3.567186338285891*^9, 3.567186363994736*^9}, {3.567186419936434*^9, 
   3.5671864248036423`*^9}, 3.5671864580005016`*^9, {3.567186539682245*^9, 
   3.567186545719455*^9}, {3.5671866005379524`*^9, 3.567186616434379*^9}, {
   3.5671866550132465`*^9, 3.567186659537255*^9}, {3.56718673644539*^9, 
   3.567186747989412*^9}, {3.567187461535664*^9, 3.567187464140868*^9}, {
   3.567596477520695*^9, 3.567596478175896*^9}, {3.567597156918488*^9, 
   3.5675971569340887`*^9}, {3.5675973215143776`*^9, 
   3.5675973218107786`*^9}, {3.567597360764046*^9, 3.567597360795246*^9}, {
   3.56759749985389*^9, 3.567597506203101*^9}, {3.567597676680201*^9, 
   3.567597735897905*^9}, {3.567597793368406*^9, 3.5675978229772587`*^9}, {
   3.567598126740991*^9, 3.567598131108999*^9}, {3.5675982675624394`*^9, 
   3.5675983186681285`*^9}, {3.567598374968627*^9, 3.567598386029047*^9}, {
   3.56759905971723*^9, 3.567599060918432*^9}, {3.567599161257809*^9, 
   3.567599161881809*^9}, {3.5675992049378858`*^9, 3.5675992090406933`*^9}, {
   3.5676024333801546`*^9, 3.567602456436996*^9}, {3.567606624157916*^9, 
   3.5676066305383277`*^9}, {3.5676068023102293`*^9, 
   3.5676068394070945`*^9}, {3.567607017949408*^9, 3.567607018417409*^9}, {
   3.567607407809693*^9, 3.567607420679715*^9}, {3.567608855976836*^9, 
   3.567608859128042*^9}, {3.56761898038933*^9, 3.567618998812963*^9}, {
   3.5838400811707273`*^9, 3.583840085070734*^9}, {3.583840422670927*^9, 
   3.583840455930185*^9}, {3.5838476333140326`*^9, 3.5838476561524734`*^9}, {
   3.58390298829706*^9, 3.583903033053539*^9}, {3.584184138282026*^9, 
   3.584184292129495*^9}, {3.584184707060025*^9, 3.584184747354895*^9}},
 CellLabel->
  "In[387]:=",ExpressionUUID->"f21cbe25-2a49-4207-bb7c-f6f23c15a584"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenerateSym2", "[", 
    RowBox[{
    "chain_List", ",", " ", "schvecs_", ",", "s_", ",", "l_", ",", "i_", ",", 
     "list_", ",", "SGSK_", ",", "Delta_", ",", "GElements_", ",", "verb_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"base", "=", 
        RowBox[{"chain", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"Length", "[", "chain", "]"}], "-", "1"}]}], ",", "g", ",", 
       RowBox[{"newSGSK", "=", "SGSK"}], ",", "Deltag", ",", "gammai", ",", 
       "otherSGSK", ",", "Deltacompl"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", " ", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<GenerateSym1[\>\"", ",", "chain", ",", "\"\<,\>\"", ",", 
           "property", ",", "\"\<,\>\"", ",", "s", ",", "\"\<,\>\"", ",", "l",
            ",", "\"\<,\>\"", ",", "i", ",", "\"\<,\>\"", ",", "list", ",", 
           "\"\<,\>\"", ",", "SGSK", ",", "\"\<,\>\"", ",", "Delta", ",", 
           "\"\<,\>\"", ",", "verb", ",", "\"\<]\>\""}], "]"}]}], "]"}], 
       ";"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Deltacompl", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{"base", ",", 
         RowBox[{"-", 
          RowBox[{"Length", "@", "Delta"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"First", "@", 
        RowBox[{"FromBaseImage2", "[", 
         RowBox[{"list", ",", "schvecs"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"verb", ",", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Pregenerate at level \>\"", ",", "s", ",", "\"\< with i=\>\"", 
          ",", "i", ",", "\"\<. We have list \>\"", ",", "list", ",", 
          "\"\< and permutation \>\"", ",", "g"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i", "\[Equal]", "l"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<Generate at level \>\"", ",", "s", ",", "\"\< with i=\>\"", 
             ",", "i", ",", "\"\<. We have list \>\"", ",", "list", ",", 
             "\"\< and permutation \>\"", ",", "g"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Not", "@", 
             RowBox[{"PermEqual", "[", 
              RowBox[{"g", ",", "ID"}], "]"}]}], "&&", 
            RowBox[{"Or", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "@", 
                RowBox[{"Intersection", "[", 
                 RowBox[{"Delta", ",", "list"}], "]"}]}], "\[Equal]", "0"}], 
              ",", 
              RowBox[{"GpinHGQBruteForceSymmetric2", "[", 
               RowBox[{
               "list", ",", "Deltacompl", ",", " ", "schvecs", ",", 
                "GElements"}], "]"}]}], "]"}], "&&", 
            RowBox[{"Not", "@", 
             RowBox[{"PermMemberQ", "[", 
              RowBox[{"g", ",", "SGSK"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"newSGSK", "=", 
             RowBox[{"-", 
              RowBox[{"StrongGenSet", "[", 
               RowBox[{
                RowBox[{"chain", "[", 
                 RowBox[{"[", 
                  RowBox[{"s", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"Append", "[", 
                 RowBox[{
                  RowBox[{"Last", "[", "SGSK", "]"}], ",", "g"}], "]"}]}], 
               "]"}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"verb", ",", 
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<  Added permutation \>\"", ",", "g", ",", 
                "\"\< New SGSK: \>\"", ",", " ", "newSGSK"}], "]"}]}], 
             "]"}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Deltag", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{
            RowBox[{"Orbit", "[", 
             RowBox[{
              RowBox[{"base", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"chain", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}], ",", "g"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "Here", " ", "we", " ", "should", " ", "check", " ", "if", " ", 
            "a", " ", "point", " ", "in", " ", "Deltag", " ", "is", " ", "in",
             " ", "Delta"}], ",", " ", "\[IndentingNewLine]", 
           RowBox[{
           "then", " ", "the", " ", "entire", " ", "Delta", " ", "has", " ", 
            "to", " ", "be", " ", "in", " ", "the", " ", "orbit", " ", "in", 
            " ", 
            RowBox[{
             RowBox[{"chain", "[", 
              RowBox[{"[", "s", "]"}], "]"}], ".", " ", "\[IndentingNewLine]",
              "Otherwise"}], " ", "g", " ", "can", " ", "not", " ", "be", " ",
             "in", " ", "the", " ", 
            RowBox[{"group", ".", " ", "\[IndentingNewLine]", "Can"}], " ", 
            "we", " ", "refine", " ", "this", " ", "to", " ", "the", " ", 
            "orbit", " ", "in", " ", 
            RowBox[{"chain", "[", 
             RowBox[{"[", "i", "]"}], "]"}], 
            RowBox[{"??", "?"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Deltag", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"Deltag", ",", 
            RowBox[{
             RowBox[{"Or", "[", 
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{"Delta", ",", "#"}], "]"}], ",", 
               RowBox[{"subsetQ", "[", 
                RowBox[{"Delta", ",", 
                 RowBox[{"Orbit", "[", 
                  RowBox[{"#", ",", 
                   RowBox[{"chain", "[", 
                    RowBox[{"[", 
                    RowBox[{"s", ",", "2"}], "]"}], "]"}]}], "]"}]}], "]"}]}],
               "]"}], "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<Generating over points \>\"", ",", "Deltag", ",", " ", 
             "\"\<, s=\>\"", ",", " ", "s", ",", " ", "\"\<, i=\>\"", ",", 
             "i", ",", "\"\<, list \>\"", ",", "list"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"gammai", "=", 
             RowBox[{"Deltag", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"newSGSK", "=", 
             RowBox[{"GenerateSym2", "[", 
              RowBox[{"chain", ",", "schvecs", ",", "s", ",", "l", ",", 
               RowBox[{"i", "+", "1"}], ",", 
               RowBox[{"Append", "[", 
                RowBox[{"list", ",", "gammai"}], "]"}], ",", "newSGSK", ",", 
               "Delta", ",", "GElements", ",", "verb"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Head", "[", "newSGSK", "]"}], "===", "Times"}], ",", 
              RowBox[{"Break", "[", "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "Deltag", "]"}]}], "}"}]}], "]"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "newSGSK"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5671874385568237`*^9, 3.567187445389635*^9}, {
   3.5671877458305635`*^9, 3.567187746485764*^9}, {3.56718786357957*^9, 
   3.567187866527975*^9}, {3.567188073540339*^9, 3.567188077143945*^9}, {
   3.567596488783914*^9, 3.5675965096567516`*^9}, {3.5675965946467*^9, 
   3.5675965964563046`*^9}, 3.567596699634885*^9, {3.567597142831663*^9, 
   3.567597143065664*^9}, {3.567598137879411*^9, 3.567598161279452*^9}, {
   3.5675982328679786`*^9, 3.56759823447478*^9}, {3.567598410942291*^9, 
   3.567598436245535*^9}, {3.567599045864406*^9, 3.5675990520732174`*^9}, {
   3.5676019339764786`*^9, 3.567601940060489*^9}, {3.567602462209007*^9, 
   3.567602495546264*^9}, {3.5676025526579657`*^9, 3.5676025530947657`*^9}, {
   3.5676046014885635`*^9, 3.5676046209729986`*^9}, {3.567604851057802*^9, 
   3.567604862570623*^9}, {3.567606641848348*^9, 3.5676066419107475`*^9}, {
   3.567606706510461*^9, 3.567606706806862*^9}, {3.567614385796847*^9, 
   3.567614406248483*^9}, {3.567614469615794*^9, 3.567614517102278*^9}, {
   3.567615044882405*^9, 3.567615055927224*^9}, {3.5676151185457335`*^9, 
   3.567615151118591*^9}, {3.567615223455919*^9, 3.5676152363727407`*^9}, {
   3.567616101253859*^9, 3.5676161352619195`*^9}, {3.5676161722027845`*^9, 
   3.5676162170840635`*^9}, {3.5676162613101406`*^9, 3.567616287830188*^9}, {
   3.567616385361559*^9, 3.5676163934735727`*^9}, {3.567618036883073*^9, 
   3.567618054885505*^9}, {3.567618118908017*^9, 3.5676181965493536`*^9}, {
   3.56761826264667*^9, 3.567618307902349*^9}, {3.567618375278867*^9, 
   3.567618400644512*^9}, {3.567618448598996*^9, 3.5676186169232917`*^9}, {
   3.567927213771884*^9, 3.56792721743789*^9}, {3.567929805421036*^9, 
   3.567929831114281*^9}, {3.567929904169209*^9, 3.567929907039615*^9}, {
   3.567930307945719*^9, 3.5679303084293203`*^9}, {3.5679304778456182`*^9, 
   3.5679304797488203`*^9}, {3.583840202928941*^9, 3.5838402931126995`*^9}, {
   3.5838470023241243`*^9, 3.583847021465358*^9}, {3.5838473037634535`*^9, 
   3.5838473178658786`*^9}, {3.584168718295547*^9, 3.5841687433647904`*^9}, {
   3.5841709893339357`*^9, 3.584170992578741*^9}, {3.5841816847545156`*^9, 
   3.5841816870633206`*^9}, {3.584181803860725*^9, 3.58418184091079*^9}, {
   3.584182326648843*^9, 3.584182346055277*^9}, {3.584182392169958*^9, 
   3.584182395648764*^9}, {3.5841835115509253`*^9, 3.5841835532965984`*^9}, {
   3.584183587507459*^9, 3.5841835918130655`*^9}, {3.5841837206380916`*^9, 
   3.584183792694618*^9}, {3.584183879742771*^9, 3.5841838969028015`*^9}, {
   3.584184022685822*^9, 3.584184068253502*^9}, {3.584185887702298*^9, 
   3.584185888139099*^9}, 3.615129543669058*^9},
 CellLabel->
  "In[388]:=",ExpressionUUID->"78b34b39-cdca-4b7a-9894-8d3afa74eaec"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SpecialPermWord", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_List", ",", "GS_GenSet"}], "]"}], ",", "Deltalength_", 
     ",", 
     RowBox[{"word_List", ":", 
      RowBox[{"{", "}"}]}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "base", "]"}], "\[LessEqual]", "Deltalength"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Prepend", "[", 
      RowBox[{"word", ",", "perm"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Sorbit", "=", 
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "[", "base", "]"}], ",", "GS", ",", 
            RowBox[{"Max", "[", 
             RowBox[{
              RowBox[{"PermDeg", "[", "perm", "]"}], ",", 
              RowBox[{"PermDeg", "[", "GS", "]"}], ",", 
              RowBox[{"Max", "[", "base", "]"}]}], "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"point", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{
            RowBox[{"First", "[", "base", "]"}], ",", "perm"}], "]"}]}], ",", 
         "\[IndentingNewLine]", "u"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"First", "[", "Sorbit", "]"}], ",", "point"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"u", "=", 
           RowBox[{"TraceSchreier", "[", 
            RowBox[{"point", ",", "Sorbit"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"SpecialPermWord", "[", 
           RowBox[{
            RowBox[{"PermProduct", "[", 
             RowBox[{"perm", ",", 
              RowBox[{"InversePerm", "[", "u", "]"}]}], "]"}], ",", 
            RowBox[{"StrongGenSet", "[", 
             RowBox[{
              RowBox[{"Rest", "[", "base", "]"}], ",", 
              RowBox[{"Stabilizer", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"First", "[", "base", "]"}], "}"}], ",", "GS"}], 
               "]"}]}], "]"}], ",", "Deltalength", ",", 
            RowBox[{"Prepend", "[", 
             RowBox[{"word", ",", "u"}], "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Prepend", "[", 
          RowBox[{"word", ",", "perm"}], "]"}]}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.566546972993646*^9, 3.566547000933295*^9}, {
   3.566547609849165*^9, 3.5665476400508184`*^9}, {3.566547671859274*^9, 
   3.5665476735128775`*^9}, 3.5675972468214464`*^9, 3.567862588684884*^9},
 CellLabel->
  "In[389]:=",ExpressionUUID->"c5aada30-ee7a-472f-bf3c-ba8a9cc53e71"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpecialPermMemberQ", "[", 
   RowBox[{"p_", ",", "H_", ",", "Delta_", ",", "n_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Length", "@", 
    RowBox[{"Complement", "[", 
     RowBox[{
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"Range", "@", "n"}], ",", "Delta"}], "]"}], ",", 
      RowBox[{"StablePoints", "[", 
       RowBox[{
        RowBox[{"First", "@", 
         RowBox[{"SpecialPermWord", "[", 
          RowBox[{"p", ",", "H", ",", 
           RowBox[{"Length", "@", "Delta"}]}], "]"}]}], ",", "n"}], "]"}]}], 
     "]"}]}], "==", "0"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567085527619495*^9, 3.567085637771288*^9}, {
  3.567085671202147*^9, 3.567085754928494*^9}},
 CellLabel->
  "In[390]:=",ExpressionUUID->"450b8eb0-7b5f-4163-9dc2-7c058e8de82d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GpinHGQBruteForceSymmetric", "[", 
   RowBox[{"p_", ",", "testfunc_", ",", "Gelements_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TestList", "=", "Gelements"}], ",", "\[IndentingNewLine]", 
      RowBox[{"result", "=", "True"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Length", "[", "TestList", "]"}], ">", "0"}], ")"}], "&&", 
        "result"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"result", "=", 
         RowBox[{"testfunc", "@", 
          RowBox[{"PermProduct", "[", 
           RowBox[{"p", ",", 
            RowBox[{"First", "@", "TestList"}]}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"TestList", "=", 
         RowBox[{"Rest", "@", "TestList"}]}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "result"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567085147212827*^9, 3.567085155340441*^9}, {
   3.5670854136456947`*^9, 3.567085440586942*^9}, {3.567085774085328*^9, 
   3.567085787626151*^9}, {3.567085950474838*^9, 3.567086061734233*^9}, {
   3.5670902599844074`*^9, 3.567090263135613*^9}, 3.567862588700484*^9},
 CellLabel->
  "In[391]:=",ExpressionUUID->"5c9b73b0-5541-4680-851d-159feb25e13c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GpinHGQBruteForceSymmetric2", "[", 
   RowBox[{
   "list_", ",", "deltacompl_", ",", " ", "schvecs_", ",", "Gelements_"}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TestList", "=", "Gelements"}], ",", "\[IndentingNewLine]", 
      RowBox[{"result", "=", "True"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Length", "[", "TestList", "]"}], ">", "0"}], ")"}], "&&", 
        "result"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"result", "=", 
         RowBox[{"deltacompl", "==", 
          RowBox[{"Last", "@", 
           RowBox[{"FromBaseImage2", "[", 
            RowBox[{
             RowBox[{"OnPoints", "[", 
              RowBox[{"list", ",", 
               StyleBox[
                RowBox[{"First", "@", "TestList"}],
                ShowAutoStyles->False,
                AutoSpacing->False]}], 
              StyleBox["]",
               ShowAutoStyles->False,
               AutoSpacing->False]}], ",", "schvecs"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Tested \>\"", ",", " ", 
            RowBox[{"First", "@", "TestList"}], ",", " ", "\"\<: \>\"", ",", 
            " ", "result"}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"TestList", "=", 
         RowBox[{"Rest", "@", "TestList"}]}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "result"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.567085147212827*^9, 3.567085155340441*^9}, {
   3.5670854136456947`*^9, 3.567085440586942*^9}, {3.567085774085328*^9, 
   3.567085787626151*^9}, {3.567085950474838*^9, 3.567086061734233*^9}, {
   3.5670902599844074`*^9, 3.567090263135613*^9}, 3.567862588700484*^9, {
   3.584183264960291*^9, 3.584183397576124*^9}, {3.5841857942425346`*^9, 
   3.5841858426026196`*^9}, {3.584186195693639*^9, 3.584186198470444*^9}},
 CellLabel->
  "In[392]:=",ExpressionUUID->"4f94b0ea-d718-487a-9af2-cfdca552ccc1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FromBaseImage2", "[", 
   RowBox[{"images_List", ",", "schvecs_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", "u", ",", 
      RowBox[{"g", "=", "ID"}], ",", 
      RowBox[{"imgs", "=", "images"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"Length", "[", "imgs", "]"}]}], ",", 
       RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"schvecs", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"imgs", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"u", "=", 
           RowBox[{"TraceSchreier", "[", 
            RowBox[{
             RowBox[{"imgs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"schvecs", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"g", "=", 
           RowBox[{"PermProduct", "[", 
            RowBox[{"u", ",", "g"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"imgs", "=", 
           RowBox[{"OnPoints", "[", 
            RowBox[{"imgs", ",", 
             RowBox[{"InversePerm", "[", "u", "]"}]}], "]"}]}]}]}], 
        "\[IndentingNewLine]", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"g", ",", "imgs"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.584179751987121*^9, 3.584179775527562*^9}, {
  3.5841798609845133`*^9, 3.584179894150171*^9}, {3.5841804789961987`*^9, 
  3.584180569741557*^9}, {3.5841806616725197`*^9, 3.5841806639345226`*^9}, {
  3.584181117208919*^9, 3.584181124665732*^9}, {3.5841812128994875`*^9, 
  3.5841812202627*^9}, {3.58418457346139*^9, 3.584184583398607*^9}},
 CellLabel->
  "In[393]:=",ExpressionUUID->"c6dcbd63-f135-4ade-9a45-8e19081913ba"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.2. Antisymmetric case", "Subsubsection",
 CellChangeTimes->{{3.527145244512811*^9, 
  3.527145272670861*^9}},ExpressionUUID->"9155b6d4-f015-4565-b6d5-\
d85f50adc5a4"],

Cell["Old code which is incomplete", "Text",
 CellChangeTimes->{{3.568116428930658*^9, 3.568116432409464*^9}, {
  3.5681222258112392`*^9, 
  3.568122232363251*^9}},ExpressionUUID->"d4ffc0b0-28ef-4192-9573-\
c5946e74d1ce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AntisymmetricMixedSymmetry", "[", 
   RowBox[{"unstableslots_", ",", "internalsym_", ",", "sym_", ",", "n_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"internalstabilizer", ",", " ", "newsym"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"internalstabilizer", "=", 
      RowBox[{"SetStabilizer", "[", 
       RowBox[{"unstableslots", ",", "internalsym"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newsym", "=", 
      RowBox[{"TidySGS", "@", 
       RowBox[{"SchreierSims", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Union", "[", 
          RowBox[{
           RowBox[{"internalstabilizer", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"Append", "[", 
             RowBox[{"sym", ",", "Cycles"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"newsym", ",", "internalstabilizer"}], "}"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5162839700333323`*^9, 3.516284013323408*^9}, {
   3.516284063508696*^9, 3.5162840751307173`*^9}, {3.516284112040382*^9, 
   3.5162841436772375`*^9}, {3.516284187856515*^9, 3.51628425914864*^9}, {
   3.5162843635596237`*^9, 3.5162843670696297`*^9}, {3.516286305795235*^9, 
   3.516286322877265*^9}, {3.5162869321695347`*^9, 3.5162869326375365`*^9}, {
   3.5162874278614063`*^9, 3.5162874288442073`*^9}, {3.5164281442484045`*^9, 
   3.516428173577082*^9}, {3.516431920967997*^9, 3.516431921192009*^9}, {
   3.5164319573000746`*^9, 3.5164319587791595`*^9}, {3.517835502816424*^9, 
   3.5178355030264354`*^9}, {3.51929743421744*^9, 3.519297450145068*^9}, {
   3.526380560038738*^9, 3.526380569695154*^9}, {3.526380873942489*^9, 
   3.5263809070301466`*^9}, 3.53406841635952*^9, 3.566218199944925*^9, 
   3.567863084999756*^9, 3.5678633948475*^9},
 CellLabel->
  "In[394]:=",ExpressionUUID->"b1f3ede9-a3a3-4226-aef4-c349e475347a"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1. More general cases", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.527145244512811*^9, 3.5271452849792824`*^9}, {
  3.562825742385664*^9, 
  3.562825748407275*^9}},ExpressionUUID->"c7eea459-a4ed-4188-9e75-\
75917464f30d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GeneralMixedSymmetry", "[", 
   RowBox[{"unstableslots_", ",", "internalsym_", ",", "sym_", ",", "n_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "time", ",", "result", ",", "longorbits", ",", "joinedsymmetric"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"SubgroupQ", "[", 
       RowBox[{"internalsym", ",", "sym"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xAct`xTensor`Private`SGSofsym", "@", "sym"}], ",", 
        "internalsym"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"time", ",", "result"}], "}"}], "=", 
        RowBox[{"AbsoluteTiming", "@", 
         RowBox[{"SymmetryOfProductOfGroupsBruteForce", "[", 
          RowBox[{"sym", ",", "internalsym"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"$MixedSymVerbose", ",", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<GeneralMixedSymmetry: \>\"", ",", " ", "time", ",", " ", 
           "\"\<s.\>\""}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "result"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5162839700333323`*^9, 3.516284013323408*^9}, {
   3.516284063508696*^9, 3.5162840751307173`*^9}, {3.516284112040382*^9, 
   3.5162841436772375`*^9}, {3.516284187856515*^9, 3.51628425914864*^9}, {
   3.5162874240238*^9, 3.516287425225002*^9}, {3.516428140511191*^9, 
   3.516428168316782*^9}, {3.516428771667291*^9, 3.516428825435367*^9}, {
   3.5164288935052595`*^9, 3.5164289357646766`*^9}, {3.51643183850928*^9, 
   3.516431854219179*^9}, {3.516431889681207*^9, 3.516431911620462*^9}, {
   3.5164319458814216`*^9, 3.5164319529478254`*^9}, 3.517834988370999*^9, {
   3.5178351078658333`*^9, 3.51783517983895*^9}, {3.5178352879141316`*^9, 
   3.517835356024027*^9}, {3.5178354958740263`*^9, 3.5178354971090965`*^9}, {
   3.517835560817741*^9, 3.517835564652961*^9}, {3.5178356050672717`*^9, 
   3.517835608675478*^9}, {3.519297310758823*^9, 3.519297352379697*^9}, 
   3.51929742237702*^9, {3.52026794929943*^9, 3.520267950929433*^9}, {
   3.520268029739143*^9, 3.5202680513891735`*^9}, {3.52026808433922*^9, 
   3.5202681571017227`*^9}, {3.520268348089591*^9, 3.520268449854134*^9}, {
   3.540205196131659*^9, 3.540205236158949*^9}, {3.5402054775807576`*^9, 
   3.5402054838561163`*^9}, {3.56276644394783*^9, 3.562766448206638*^9}, {
   3.5627665353015904`*^9, 3.562766573147257*^9}, 3.562766677059039*^9, {
   3.562766912494653*^9, 3.5627670279348555`*^9}, {3.5627672641046705`*^9, 
   3.562767264307471*^9}, {3.562825758188492*^9, 3.5628258581066675`*^9}, {
   3.562826083215063*^9, 3.562826100499893*^9}, {3.567918333928686*^9, 
   3.5679183407770996`*^9}, {3.567931661857498*^9, 3.5679316657575045`*^9}, {
   3.567931869259861*^9, 3.567931870913464*^9}, {3.5681228239630904`*^9, 
   3.568122875443181*^9}},
 CellLabel->
  "In[395]:=",ExpressionUUID->"bf565a81-4558-4faa-8fed-2a5da13197eb"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5. Canonicalization of the group", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{3.527145150351045*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"082cc4d8-5944-4b28-8e78-96a17e431b5e"],

Cell[CellGroupData[{

Cell["5.1. Canonicalization for nested SymH objects", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{
  3.527145152145049*^9, {3.527146210046307*^9, 
   3.527146234819151*^9}},ExpressionUUID->"0f4802a2-ebf9-43eb-8daa-\
b1a15cde3466"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInternalCanonicalSymGroupAndPerm", "[", 
   RowBox[{"SymH", "[", 
    RowBox[{
     RowBox[{"headlist", ":", 
      RowBox[{"{", 
       RowBox[{"SymH", "[", 
        RowBox[{"intheadlist_", ",", " ", "intsym_", ",", " ", "intlabel_"}], 
        "]"}], "}"}]}], ",", "sym_", ",", "label_"}], "]"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "newinternalSymH", ",", " ", "intcanonperm", ",", "newsym", ",", 
      "newSymH", ",", " ", "canonicalizingperm", ",", " ", "tmpexpr"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"newinternalSymH", ",", " ", "intcanonperm"}], "}"}], "=", 
      RowBox[{"FindInternalCanonicalSymGroupAndPerm", "[", 
       RowBox[{"SymH", "[", 
        RowBox[{"intheadlist", ",", " ", "intsym", ",", " ", "intlabel"}], 
        "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"newsym", "=", 
      RowBox[{"sym", "/.", 
       RowBox[{"List", "@@", 
        RowBox[{"(", 
         RowBox[{"TranslatePerm", "[", 
          RowBox[{
           RowBox[{"nosign", "@", "intcanonperm"}], ",", "Rules"}], "]"}], 
         ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"newsym", "=", 
      RowBox[{"TidyGroup", "@", "newsym"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tmpexpr", "=", 
      RowBox[{"SymH", "[", 
       RowBox[{
        RowBox[{"{", "newinternalSymH", "}"}], ",", "newsym", ",", 
        "\"\<\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"newSymH", ",", " ", "canonicalizingperm"}], "}"}], "=", 
      RowBox[{"FindCanonicalSymGroupAndPerm", "[", "tmpexpr", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"newSymH", ",", " ", 
       RowBox[{"PermProduct", "[", 
        RowBox[{"intcanonperm", ",", "canonicalizingperm"}], "]"}]}], 
      "}"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.520175562029708*^9, {3.520175621584609*^9, 3.520175712735569*^9}, {
   3.5201757995517206`*^9, 3.520175808428136*^9}, {3.520175873043449*^9, 
   3.520175941761571*^9}, {3.520176062936981*^9, 3.5201760844230185`*^9}, {
   3.5201761232194843`*^9, 3.5201761478519287`*^9}, 3.520176253370513*^9, {
   3.520176737387559*^9, 3.520176740476364*^9}, {3.52017735143423*^9, 
   3.520177402166318*^9}, {3.5201774809932566`*^9, 3.520177508854906*^9}, {
   3.5201777697569633`*^9, 3.520177816647044*^9}, {3.520177861263123*^9, 
   3.520177911526411*^9}, {3.520177960774895*^9, 3.520177962038497*^9}, {
   3.5201780057041717`*^9, 3.520178009323378*^9}, {3.52017809197132*^9, 
   3.5201780940149236`*^9}, {3.520178267256823*^9, 3.5201783116701*^9}, {
   3.5201788845599008`*^9, 3.5201789391755967`*^9}, {3.5201789741352577`*^9, 
   3.5201789892048836`*^9}, {3.520179271738572*^9, 3.5201792728461747`*^9}, {
   3.5201794475316772`*^9, 3.520179451977684*^9}, {3.52017950742298*^9, 
   3.520179515705394*^9}, {3.520180228960437*^9, 3.5201802294908376`*^9}, 
   3.567862588684884*^9, {3.567863137072647*^9, 3.5678631612058897`*^9}, 
   3.567864233661973*^9},
 CellLabel->
  "In[396]:=",ExpressionUUID->"39dd0fa7-5fd7-47b2-8418-4c3440cef386"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInternalCanonicalSymGroupAndPerm", "[", 
   RowBox[{"SymH", "[", 
    RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], ":=", 
  RowBox[{"FindCanonicalSymGroupAndPerm", "[", 
   RowBox[{"SymH", "[", 
    RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5201758187085547`*^9, 3.520175831796977*^9}, 
   3.52017615471594*^9, 3.52017625714572*^9},
 CellLabel->
  "In[397]:=",ExpressionUUID->"58d00312-79b6-420f-a740-a5931e42aadf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindCanonicalSymGroupAndPerm", "[", 
   RowBox[{"SymH", "[", 
    RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"Length", "/@", 
          RowBox[{"SlotsOfTensor", "/@", "headlist"}]}], ")"}]}]}], ",", 
      "unstableslots", ",", " ", "newsymh", ",", " ", "perm"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"unstableslots", "=", 
      RowBox[{"GroupSupport", "@", "sym"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"newsymh", ",", "perm"}], "}"}], "=", 
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Head", "@", "sym"}], "===", "Symmetric"}], ",", 
        RowBox[{"(*", " ", "Symmetric", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"CanonicalizeSymmetricGroupInSym", "[", 
         RowBox[{
          RowBox[{"SymH", "[", 
           RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], ",", "n", 
          ",", "unstableslots"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Head", "@", "sym"}], "===", "Antisymmetric"}], ",", 
        RowBox[{"(*", " ", "Antisymmetric", " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"CanonicalizeAntisymmetricGroupInSym", "[", 
         RowBox[{
          RowBox[{"SymH", "[", 
           RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], ",", "n", 
          ",", "unstableslots"}], "]"}], ",", "\[IndentingNewLine]", "True", 
        ",", 
        RowBox[{"(*", " ", 
         RowBox[{"Everything", " ", "else"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"CanonicalizeGeneralGroupInSym", "[", 
         RowBox[{
          RowBox[{"SymH", "[", 
           RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], ",", "n"}], 
         "]"}]}], "]"}]}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520173776633185*^9, 3.520173817895258*^9}, {
   3.520173907377014*^9, 3.520174085498927*^9}, {3.520174155539449*^9, 
   3.520174289824485*^9}, {3.520174528056302*^9, 3.520174531207507*^9}, {
   3.52017760904468*^9, 3.5201776095594816`*^9}, {3.520177673067193*^9, 
   3.520177725046485*^9}, {3.524975694138228*^9, 3.5249757179594707`*^9}, {
   3.524975748738324*^9, 3.524975758051541*^9}, {3.527145559711365*^9, 
   3.5271455838446074`*^9}, {3.527145652515928*^9, 3.527145665619951*^9}, {
   3.527145973690292*^9, 3.527145987309116*^9}, {3.563427182032713*^9, 
   3.5634271901291275`*^9}, {3.567863176681117*^9, 3.567863255976056*^9}, 
   3.588238693443102*^9, 3.588239107405429*^9, 3.5882393166173973`*^9, 
   3.5882403331005807`*^9},
 CellLabel->
  "In[398]:=",ExpressionUUID->"1703362d-4fba-4cd5-b32c-124a0f96354c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CanonicalizeGroupInSym", "[", "expr_", "]"}], ":=", 
  RowBox[{"expr", "/.", 
   RowBox[{
    RowBox[{
     RowBox[{"SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
     "inds___", "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"newSymH", ",", " ", "canonicalizingperm"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"newSymH", ",", "canonicalizingperm"}], "}"}], "=", 
        RowBox[{"FindInternalCanonicalSymGroupAndPerm", "[", 
         RowBox[{"SymH", "[", 
          RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sign", "[", "canonicalizingperm", "]"}], "*", 
        RowBox[{"newSymH", "@@", 
         RowBox[{"PermuteList", "[", 
          RowBox[{
           RowBox[{"{", "inds", "}"}], ",", "canonicalizingperm"}], 
          "]"}]}]}]}]}], "]"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4811928537552*^9, 3.4811929548642*^9}, {
   3.4811930008372*^9, 3.4811930263392*^9}, {3.4947528495030003`*^9, 
   3.4947528507042*^9}, {3.4957027507508*^9, 3.4957027554152*^9}, {
   3.5087662812516007`*^9, 3.5087662879440002`*^9}, {3.5087663236991997`*^9, 
   3.5087664808848*^9}, {3.5087668106688004`*^9, 3.5087668442868*^9}, {
   3.5087668824444*^9, 3.5087669172012*^9}, {3.50876720577*^9, 
   3.5087672300436*^9}, {3.508767279168*^9, 3.5087673410376*^9}, {
   3.5087713699248*^9, 3.5087714115768003`*^9}, {3.5087715250512*^9, 
   3.508771569402*^9}, {3.5087716075596*^9, 3.5087716319268*^9}, {
   3.5087716732668*^9, 3.5087716889136*^9}, {3.5087717744016*^9, 
   3.5087718188460007`*^9}, {3.5087718719952*^9, 3.5087718989676*^9}, {
   3.5087719779036*^9, 3.508771978668*^9}, {3.5087721375852003`*^9, 
   3.5087721499248*^9}, {3.5087724715968*^9, 3.5087724931404*^9}, {
   3.5087725473816*^9, 3.5087725634807997`*^9}, 3.508772611482001*^9, 
   3.5087726772204*^9, {3.5087728284936*^9, 3.5087728303968*^9}, {
   3.5118445016758*^9, 3.5118445025338*^9}, 3.5121192244396*^9, 
   3.512119589932*^9, {3.5159957790606675`*^9, 3.515995845859985*^9}, {
   3.515996046008336*^9, 3.5159960656643705`*^9}, {3.5159964458682384`*^9, 
   3.515996448333043*^9}, {3.515996500140734*^9, 3.515996501965937*^9}, {
   3.516000570549684*^9, 3.516000580377701*^9}, 3.516000830867341*^9, 
   3.516280351668377*^9, {3.516280440448133*^9, 3.516280475376594*^9}, {
   3.516280543486314*^9, 3.516280637616879*^9}, {3.51706899196773*^9, 
   3.517068995018905*^9}, {3.5173874955449142`*^9, 3.517387523687364*^9}, {
   3.517387681949642*^9, 3.517387725645319*^9}, {3.517387989878583*^9, 
   3.517388038503868*^9}, {3.5173880795943403`*^9, 3.5173881134932*^9}, {
   3.5201743563586016`*^9, 3.520174469321199*^9}, 3.520175954397593*^9},
 CellLabel->
  "In[399]:=",ExpressionUUID->"bdf2020d-f483-42cf-a2b9-2250a115cced"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Options", "[", "ToCanonicalSym", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"RemoveSuperfluousPartialSym", "\[Rule]", "False"}], 
   "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.587026234912132*^9, 3.5870262812754135`*^9}, {
  3.5870264659797378`*^9, 3.587026466588138*^9}},
 CellLabel->
  "In[400]:=",ExpressionUUID->"cc82475e-aea9-4d6c-a1c2-77545cd2e1e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"RemoveSuperfluousPartialSym", "\[Rule]", "False"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.587653695236055*^9, 3.5876537884804196`*^9, 3.588238739868783*^9, 
   3.5891983674757595`*^9, 3.590147522281883*^9, 3.5901483311745024`*^9, 
   3.590148592240961*^9, 3.590318329614984*^9, 3.592139804144554*^9, 
   3.592140062835917*^9, 3.59214014406603*^9, 3.592140376026355*^9, 
   3.592141036517279*^9, 3.5921422040789137`*^9, 3.592218078870035*^9, 
   3.592218378510455*^9, 3.5922187879810286`*^9, 3.5922191944825974`*^9, 
   3.592219367192839*^9, 3.598170409454116*^9, 3.598188085484053*^9, 
   3.600328177599329*^9, 3.603719773301665*^9, 3.603719896701838*^9, 
   3.603720039022037*^9, 3.603720447402608*^9, 3.603720671212921*^9, 
   3.603720806194111*^9, 3.603720934064289*^9, 3.603721592495211*^9, 
   3.603721641115279*^9, 3.6037225685375786`*^9, 3.6070762786355057`*^9, 
   3.615127546719871*^9, 3.6151276739400487`*^9, 3.615127773590188*^9, 
   3.615127838030278*^9, 3.615128170617135*^9, {3.615129029668338*^9, 
   3.615129057068377*^9}, 3.615129725399312*^9, 3.619615814376521*^9, 
   3.619616042720889*^9, 3.619616969637372*^9, 3.619617067427509*^9, 
   3.619617213781762*^9, 3.6196892373765388`*^9, 3.6196894535308886`*^9, 
   3.6196894940209446`*^9, 3.619689957940692*^9, 3.619690123490924*^9, 
   3.6205393072784786`*^9, 3.620803639380659*^9, 3.620804079121275*^9, 
   3.620804148121372*^9, 3.6483950619953485`*^9, 3.6483952118155584`*^9, 
   3.6800037113502045`*^9, 3.680101708705408*^9, 3.838711144521073*^9, 
   3.8387112771267977`*^9, 3.83880550565376*^9, 3.838882504754617*^9, 
   3.839149894452259*^9, 3.8391514262360287`*^9, 3.8396719755046*^9, 
   3.839672082219983*^9, 3.839687413645402*^9},
 CellLabel->
  "Out[400]=",ExpressionUUID->"5c0d285c-0fec-4c88-a3b2-1cca75bb7c20"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonicalSym", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"options", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
  RowBox[{"ToCanonical", "@", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"remsuppartsym", "=", 
       RowBox[{"OptionValue", "[", "RemoveSuperfluousPartialSym", "]"}]}], 
      "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{"remsuppartsym", ",", 
       RowBox[{"CanonicalizeGroupInSym", "@", 
        RowBox[{"RemoveSuperfluousPartialSym", "@", 
         RowBox[{"RemoveSuperfluousSym", "@", "expr"}]}]}], ",", 
       RowBox[{"CanonicalizeGroupInSym", "@", "expr"}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.560945008555441*^9, 3.5609450348726873`*^9}, {
  3.58702631411347*^9, 3.587026460582128*^9}, {3.5870265937283616`*^9, 
  3.587026606317584*^9}, {3.58765294698234*^9, 3.587652975234989*^9}},
 CellLabel->
  "In[401]:=",ExpressionUUID->"250492ba-906d-47d5-9be6-ee5714a5f889"]
}, Closed]],

Cell[CellGroupData[{

Cell["5.2. Canonicalization for Symmetric and Antisymmetric groups", \
"Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{3.527145152145049*^9, 
  3.527146242932165*^9},ExpressionUUID->"e3d3d968-b4cd-45b3-831c-\
276751d875dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CanonicalizeSymmetricGroupInSym", "[", 
   RowBox[{
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], ",", "n_", ",",
     "unstableslots_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CanonicalSym", "=", "sym"}], ",", 
      RowBox[{"newlabel", "=", "label"}], ",", "InternalSym", ",", " ", 
      "canonicalslots", ",", "canonicalizingperm"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"InternalSym", "=", 
      RowBox[{"InternalSymmetrySym", "[", 
       RowBox[{"SymH", "[", 
        RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"canonicalslots", ",", "canonicalizingperm"}], "}"}], "=", 
      RowBox[{"FindSmallestImageAndMapping", "[", 
       RowBox[{"unstableslots", ",", "InternalSym", ",", "n"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CanonicalSym", "=", 
      RowBox[{"Symmetric", "@", 
       RowBox[{"Sort", "@", "canonicalslots"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newlabel", "=", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"\"\<(\>\"", ",", 
        RowBox[{"ToString", "/@", "canonicalslots"}], ",", "\"\<)\>\""}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SymH", "[", 
        RowBox[{"headlist", ",", "CanonicalSym", ",", "newlabel"}], "]"}], 
       ",", "canonicalizingperm"}], "}"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4811928537552*^9, 3.4811929548642*^9}, {
   3.4811930008372*^9, 3.4811930263392*^9}, {3.4947528495030003`*^9, 
   3.4947528507042*^9}, {3.4957027507508*^9, 3.4957027554152*^9}, {
   3.5087662812516007`*^9, 3.5087662879440002`*^9}, {3.5087663236991997`*^9, 
   3.5087664808848*^9}, {3.5087668106688004`*^9, 3.5087668442868*^9}, {
   3.5087668824444*^9, 3.5087669172012*^9}, {3.50876720577*^9, 
   3.5087672300436*^9}, {3.508767279168*^9, 3.5087673410376*^9}, {
   3.5087713699248*^9, 3.5087714115768003`*^9}, {3.5087715250512*^9, 
   3.508771569402*^9}, {3.5087716075596*^9, 3.5087716319268*^9}, {
   3.5087716732668*^9, 3.5087716889136*^9}, {3.5087717744016*^9, 
   3.5087718188460007`*^9}, {3.5087718719952*^9, 3.5087718989676*^9}, {
   3.5087719779036*^9, 3.508771978668*^9}, {3.5087721375852003`*^9, 
   3.5087721499248*^9}, {3.5087724715968*^9, 3.5087724931404*^9}, {
   3.5087725473816*^9, 3.5087725634807997`*^9}, 3.508772611482001*^9, 
   3.5087726772204*^9, {3.5087728284936*^9, 3.5087728303968*^9}, {
   3.5118445016758*^9, 3.5118445025338*^9}, 3.5121192244396*^9, 
   3.512119589932*^9, {3.5159957790606675`*^9, 3.515995845859985*^9}, {
   3.515996046008336*^9, 3.5159960656643705`*^9}, {3.5159964458682384`*^9, 
   3.515996448333043*^9}, {3.515996500140734*^9, 3.515996501965937*^9}, {
   3.516000570549684*^9, 3.516000580377701*^9}, 3.516000830867341*^9, {
   3.516280382369231*^9, 3.516280412196483*^9}, {3.516280660221319*^9, 
   3.516280689814571*^9}, {3.517567089499052*^9, 3.5175671460491514`*^9}, {
   3.517567687792303*^9, 3.517567689243106*^9}, {3.517816804047915*^9, 
   3.5178168077951293`*^9}, {3.518678104302259*^9, 3.518678108405066*^9}, {
   3.518678754402201*^9, 3.518678757085407*^9}, {3.518678882309626*^9, 
   3.5186789358333197`*^9}, 3.518955768122538*^9, {3.5189559708770943`*^9, 
   3.5189560110315647`*^9}, {3.518956288306452*^9, 3.518956290022455*^9}, {
   3.5189564955070157`*^9, 3.518956495990617*^9}, {3.518956602523204*^9, 
   3.518956603178405*^9}, {3.520174501193055*^9, 3.520174503751459*^9}, {
   3.520174536589517*^9, 3.52017461229645*^9}},
 CellLabel->
  "In[402]:=",ExpressionUUID->"9a83008a-0d47-442f-8043-bd7a9a247b71"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CanonicalizeAntisymmetricGroupInSym", "[", 
   RowBox[{
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], ",", "n_", ",",
     "unstableslots_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CanonicalSym", "=", "sym"}], ",", 
      RowBox[{"newlabel", "=", "label"}], ",", "InternalSym", ",", " ", 
      "canonicalslots", ",", "canonicalizingperm"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"InternalSym", "=", 
      RowBox[{"InternalSymmetrySym", "[", 
       RowBox[{"SymH", "[", 
        RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"canonicalslots", ",", "canonicalizingperm"}], "}"}], "=", 
      RowBox[{"FindSmallestImageAndMapping", "[", 
       RowBox[{"unstableslots", ",", "InternalSym", ",", "n"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CanonicalSym", "=", 
      RowBox[{"Antisymmetric", "@", 
       RowBox[{"Sort", "@", "canonicalslots"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newlabel", "=", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"\"\<[\>\"", ",", 
        RowBox[{"ToString", "/@", "canonicalslots"}], ",", "\"\<]\>\""}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SymH", "[", 
        RowBox[{"headlist", ",", "CanonicalSym", ",", "newlabel"}], "]"}], 
       ",", "canonicalizingperm"}], "}"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4811928537552*^9, 3.4811929548642*^9}, {
   3.4811930008372*^9, 3.4811930263392*^9}, {3.4947528495030003`*^9, 
   3.4947528507042*^9}, {3.4957027507508*^9, 3.4957027554152*^9}, {
   3.5087662812516007`*^9, 3.5087662879440002`*^9}, {3.5087663236991997`*^9, 
   3.5087664808848*^9}, {3.5087668106688004`*^9, 3.5087668442868*^9}, {
   3.5087668824444*^9, 3.5087669172012*^9}, {3.50876720577*^9, 
   3.5087672300436*^9}, {3.508767279168*^9, 3.5087673410376*^9}, {
   3.5087713699248*^9, 3.5087714115768003`*^9}, {3.5087715250512*^9, 
   3.508771569402*^9}, {3.5087716075596*^9, 3.5087716319268*^9}, {
   3.5087716732668*^9, 3.5087716889136*^9}, {3.5087717744016*^9, 
   3.5087718188460007`*^9}, {3.5087718719952*^9, 3.5087718989676*^9}, {
   3.5087719779036*^9, 3.508771978668*^9}, {3.5087721375852003`*^9, 
   3.5087721499248*^9}, {3.5087724715968*^9, 3.5087724931404*^9}, {
   3.5087725473816*^9, 3.5087725634807997`*^9}, 3.508772611482001*^9, 
   3.5087726772204*^9, {3.5087728284936*^9, 3.5087728303968*^9}, {
   3.5118445016758*^9, 3.5118445025338*^9}, 3.5121192244396*^9, 
   3.512119589932*^9, {3.5159957790606675`*^9, 3.515995845859985*^9}, {
   3.515996046008336*^9, 3.5159960656643705`*^9}, {3.5159964458682384`*^9, 
   3.515996448333043*^9}, {3.515996500140734*^9, 3.515996501965937*^9}, {
   3.516000570549684*^9, 3.516000580377701*^9}, 3.516000830867341*^9, {
   3.516280382369231*^9, 3.516280412196483*^9}, {3.516280660221319*^9, 
   3.516280689814571*^9}, {3.5162808451284437`*^9, 3.5162808475152483`*^9}, {
   3.5162809671830583`*^9, 3.516280994061905*^9}, {3.516281112856114*^9, 
   3.516281146208973*^9}, {3.516281338120509*^9, 3.516281553400888*^9}, {
   3.516281803734527*^9, 3.516281831252976*^9}, 3.51628192441634*^9, {
   3.516282064738586*^9, 3.516282066657389*^9}, {3.516282318582231*^9, 
   3.5162823819339433`*^9}, {3.5162830174644594`*^9, 3.516283072485756*^9}, {
   3.516283531703762*^9, 3.516283592512669*^9}, {3.516283852674327*^9, 
   3.516283858290336*^9}, {3.517567160089176*^9, 3.5175671649407845`*^9}, {
   3.517567678869087*^9, 3.5175676809594917`*^9}, {3.517816812798416*^9, 
   3.5178168157365837`*^9}, 3.51867876504142*^9, {3.518678912136879*^9, 
   3.518678922027296*^9}, {3.518956098625719*^9, 3.518956098828519*^9}, {
   3.5189562791492352`*^9, 3.518956280958838*^9}, {3.518956394105838*^9, 
   3.518956414589673*^9}, {3.518956506021435*^9, 3.5189565306850777`*^9}, {
   3.518956608045614*^9, 3.518956608544814*^9}, {3.520174630595282*^9, 
   3.520174664526141*^9}},
 CellLabel->
  "In[403]:=",ExpressionUUID->"ec6b1273-7426-42c2-a6ae-17c0ff5ccfc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["5.3. Canonicalization for general groups", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{
  3.527145152145049*^9, {3.527145459980389*^9, 3.5271454693560057`*^9}, 
   3.527146244741768*^9},ExpressionUUID->"7537be94-14c4-4b3f-b8ae-\
6b831ca1606d"],

Cell["This is experimental and very slow.", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.527146355782764*^9, 3.5271463673423843`*^9}, {
  3.527146507103029*^9, 
  3.527146510800236*^9}},ExpressionUUID->"bd092532-863b-4ce2-9039-\
d2d82121b31e"],

Cell["\<\
The original version pushes the symmetrizations to the right, but we need \
them pushed to the left. Therefore we reverse the points. This is still not \
exactly what we want...\
\>", "Text",
 CellChangeTimes->{{3.561717601440087*^9, 3.561717638022151*^9}, {
  3.561782575461539*^9, 3.561782591779167*^9}, {3.5876530040170403`*^9, 
  3.58765302102207*^9}},ExpressionUUID->"14b72cc6-baf2-4bf0-bd8c-\
cc1803cd397b"],

Cell["Older code", "Text",
 CellChangeTimes->{{3.5882384963835554`*^9, 
  3.588238501047964*^9}},ExpressionUUID->"3c7cbd9f-964e-4761-bc8e-\
70d36630866c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CanonicalizeGeneralGroupInSym", "[", 
   RowBox[{
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], ",", "n_"}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"time", ",", "result"}], "}"}], "=", 
      RowBox[{"AbsoluteTiming", "@", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"newlabel", "=", "label"}], ",", " ", "newsym", ",", " ", 
           "InternalSym", ",", " ", "InternalSymElements", ",", " ", 
           "PermIndex", ",", "newunstableslots", ",", 
           RowBox[{"reverserule", "=", 
            RowBox[{"Thread", "@", 
             RowBox[{"Rule", "[", 
              RowBox[{
               RowBox[{"Range", "@", "n"}], ",", 
               RowBox[{"Reverse", "@", 
                RowBox[{"Range", "@", "n"}]}]}], "]"}]}]}], ",", "intsymel", 
           ",", "reversesym"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Find", " ", "a", " ", "short", " ", "representation", " ", "of", 
           " ", "the", " ", "reversed", " ", "version", " ", "of", " ", 
           RowBox[{"sym", ".", " ", "This"}], " ", "makes", " ", "the", " ", 
           "following", " ", "computations", " ", 
           RowBox[{"faster", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"reversesym", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"StrongGenSet", "[", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"GenSet", "@@", 
                RowBox[{
                "xAct`SymManipulator`Private`SmallestGenSet", "@", "#"}]}]}], 
              "]"}], "&"}], "@", 
            RowBox[{
            "xAct`SymManipulator`Private`SmallestBaseStabChain", "[", 
             RowBox[{"sym", "/.", "reverserule"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"InternalSym", "=", 
           RowBox[{
            RowBox[{"InternalSymmetrySym", "[", 
             RowBox[{"SymH", "[", 
              RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "]"}], "/.",
             "reverserule"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"InternalSymElements", "=", 
           RowBox[{"List", "@@", 
            RowBox[{"Dimino", "@", "InternalSym"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"PermIndex", ",", " ", "newsym"}], "}"}], "=", 
           RowBox[{"SmallestGroup", "[", 
            RowBox[{"reversesym", "/.", 
             RowBox[{"List", "@@@", 
              RowBox[{"TranslatePerm", "[", 
               RowBox[{
                RowBox[{"nosign", "/@", "InternalSymElements"}], ",", 
                "Rules"}], "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"newsym", "=", 
           RowBox[{"TranslatePerm", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"StrongGenSet", "[", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", 
                   RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                 RowBox[{"GenSet", "@@", 
                  RowBox[{
                  "xAct`SymManipulator`Private`SmallestGenSet", "@", 
                   "#"}]}]}], "]"}], "&"}], "@", 
              RowBox[{
              "xAct`SymManipulator`Private`SmallestBaseStabChain", "[", 
               RowBox[{
                RowBox[{"TranslatePerm", "[", 
                 RowBox[{"newsym", ",", "Cycles"}], "]"}], "/.", 
                "reverserule"}], "]"}]}], ",", "Cycles"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"newsym", "=", 
             RowBox[{"TranslatePerm", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"TranslatePerm", "[", 
                 RowBox[{"newsym", ",", "Rules"}], "]"}], "/.", 
                "reverserule"}], ",", "Cycles"}], "]"}]}], ";"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"newsym", "=", 
           RowBox[{"MapAt", "[", 
            RowBox[{"Sort", ",", "newsym", ",", 
             RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"intsymel", "=", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"InternalSymElements", "[", 
              RowBox[{"[", "PermIndex", "]"}], "]"}], ")"}], "/.", 
            "reverserule"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"newlabel", "=", 
           RowBox[{"DefaultLabelSym", "[", "newsym", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"newunstableslots", "=", 
           RowBox[{"Complement", "[", 
            RowBox[{
             RowBox[{"Range", "@", "n"}], ",", 
             RowBox[{"StablePoints", "[", 
              RowBox[{
               RowBox[{"Last", "@", "newsym"}], ",", "n"}], "]"}]}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"newunstableslots", "=", 
           RowBox[{"DeleteDuplicates", "@", 
            RowBox[{"Join", "[", 
             RowBox[{
              RowBox[{"First", "@", "newsym"}], ",", "newunstableslots"}], 
             "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"newsym", "=", 
           RowBox[{"ReplacePart", "[", 
            RowBox[{"newsym", ",", 
             RowBox[{"1", "->", "newunstableslots"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"SymH", "[", 
             RowBox[{"headlist", ",", "newsym", ",", "newlabel"}], "]"}], ",",
             "intsymel"}], "}"}]}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<CanonicalizeGeneralGroupInSym: \>\"", ",", " ", "time", ",", 
         " ", "\"\<s.\>\""}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
     "result"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.527145601441438*^9, 3.527145609865453*^9}, {
   3.5271456726087627`*^9, 3.5271457224352508`*^9}, {3.527145762496121*^9, 
   3.527145763650523*^9}, {3.527146292259452*^9, 3.527146300979867*^9}, {
   3.527146495668209*^9, 3.527146537679083*^9}, {3.527147253939741*^9, 
   3.527147398130794*^9}, {3.527147454260693*^9, 3.527147554007268*^9}, {
   3.5271481447501054`*^9, 3.527148178882965*^9}, {3.527150117914174*^9, 
   3.527150159160647*^9}, {3.5271502946312847`*^9, 3.527150299982094*^9}, 
   3.527150334754555*^9, 3.527150494140035*^9, {3.5609447529177938`*^9, 
   3.560944756302998*^9}, {3.561717694041849*^9, 3.561717754148755*^9}, {
   3.561732244141006*^9, 3.561732277010264*^9}, {3.561732400858881*^9, 
   3.561732453196973*^9}, {3.5617324838354273`*^9, 3.5617324883906355`*^9}, {
   3.561732528170705*^9, 3.561732564144368*^9}, 3.561779164855748*^9, {
   3.561781440542945*^9, 3.561781449606561*^9}, {3.561781628663676*^9, 
   3.561781629272077*^9}, {3.5617817760839353`*^9, 3.5617817805455427`*^9}, {
   3.5617820738114576`*^9, 3.561782079037466*^9}, {3.561782164354017*^9, 
   3.5617821715612288`*^9}, {3.561782347139538*^9, 3.5617823663587713`*^9}, {
   3.561782425623275*^9, 3.56178244510771*^9}, {3.5617841740451465`*^9, 
   3.561784218692425*^9}, {3.585235153970932*^9, 3.585235180225778*^9}, {
   3.585235281516756*^9, 3.585235404351372*^9}, {3.585236651449763*^9, 
   3.585236775625981*^9}, {3.588238436822651*^9, 3.588238437165851*^9}, {
   3.5883407980191298`*^9, 3.588340840966006*^9}, {3.58834092865376*^9, 
   3.588340944394187*^9}},
 CellLabel->
  "In[404]:=",ExpressionUUID->"d0f3bdf5-17ea-4dac-a369-f8ef7de53c6f"],

Cell["Newer code which does not work properly yet.", "Text",
 CellChangeTimes->{{3.588238512529584*^9, 3.588238516335991*^9}, {
  3.588240349028209*^9, 
  3.5882403620542326`*^9}},ExpressionUUID->"98f47e6e-3db4-4196-8633-\
0adaec754ae2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindCanonicalGroup", "[", 
   RowBox[{"G1_", ",", "H1_", ",", "n_", ",", 
    RowBox[{"perm_", ":", 
     RowBox[{"Cycles", "[", "]"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"G2", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"GenSet", "@@", 
            RowBox[{
            "xAct`SymManipulator`Private`SmallestGenSet", "@", "#"}]}]}], 
          "]"}], "&"}], "@", 
        RowBox[{
        "xAct`SymManipulator`Private`SmallestBaseStabChain", "[", "G1", 
         "]"}]}]}], ",", 
      RowBox[{"longorbits", "=", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"Sort", "/@", 
          RowBox[{"Orbits", "@", "H1"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "#"}], ">", "1"}], "&"}]}], "]"}]}], ",", 
      "firstorbitpoint", ",", " ", "firstschreierorbit", ",", " ", 
      "firstperms", ",", "PermIndex", ",", "G3"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "@", "longorbits"}], "==", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"G2", ",", "perm"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"firstorbitpoint", "=", 
        RowBox[{"First", "@", 
         RowBox[{"Sort", "[", 
          RowBox[{"First", "/@", "longorbits"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"firstschreierorbit", "=", 
        RowBox[{"SchreierOrbit", "[", 
         RowBox[{"firstorbitpoint", ",", 
          RowBox[{"Last", "@", "H1"}], ",", "n"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"firstperms", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"TraceSchreier", "[", 
           RowBox[{"#", ",", "firstschreierorbit"}], "]"}], "&"}], "/@", 
         RowBox[{"First", "@", "firstschreierorbit"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"PermIndex", ",", " ", "G3"}], "}"}], "=", 
        RowBox[{"xAct`SymManipulator`Private`SmallestGroup", "[", 
         RowBox[{"G2", "/.", 
          RowBox[{"List", "@@@", 
           RowBox[{"TranslatePerm", "[", 
            RowBox[{
             RowBox[{
             "xAct`SymManipulator`Private`nosign", "/@", "firstperms"}], ",", 
             "Rules"}], "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"FindCanonicalGroup", "[", 
        RowBox[{
         RowBox[{"TranslatePerm", "[", 
          RowBox[{"G3", ",", "Cycles"}], "]"}], ",", 
         RowBox[{"Stabilizer", "[", 
          RowBox[{
           RowBox[{"{", "firstorbitpoint", "}"}], ",", "H1"}], "]"}], ",", 
         "n", ",", 
         RowBox[{"PermProduct", "[", 
          RowBox[{"perm", ",", 
           RowBox[{"firstperms", "[", 
            RowBox[{"[", "PermIndex", "]"}], "]"}]}], "]"}]}], "]"}]}]}], 
     "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.58822996462697*^9, 3.58822999351822*^9}, {
   3.5882300308958864`*^9, 3.588230032346689*^9}, {3.588230113778831*^9, 
   3.588230168020128*^9}, 3.588230259576688*^9, {3.588230299980759*^9, 
   3.588230453687829*^9}, {3.588230495776703*^9, 3.588230500331911*^9}, {
   3.588230553543604*^9, 3.588230582996456*^9}, {3.588230672775614*^9, 
   3.5882306745228176`*^9}, {3.588230735160123*^9, 3.588230745612142*^9}, {
   3.588230779464201*^9, 3.588230779682602*^9}, {3.5882308118810587`*^9, 
   3.588230812021458*^9}, {3.588231040203059*^9, 3.588231048845475*^9}, 
   3.5882311407608356`*^9, {3.588231247293424*^9, 3.588231298664313*^9}, {
   3.588231398691689*^9, 3.588231512915089*^9}, {3.588231587623621*^9, 
   3.588231595127234*^9}, {3.588231641552915*^9, 3.588231667807761*^9}, {
   3.588232066046261*^9, 3.588232098993519*^9}, {3.588232142782796*^9, 
   3.588232144841999*^9}, {3.588232187960475*^9, 3.5882321911428804`*^9}, {
   3.588232276896231*^9, 3.5882323272999196`*^9}, {3.588232425221291*^9, 
   3.588232459837753*^9}, {3.5882325038610296`*^9, 3.5882325419094973`*^9}, {
   3.588232622374439*^9, 3.588232662981309*^9}, {3.5882329999273014`*^9, 
   3.588233001128503*^9}, {3.588234020123293*^9, 3.588234022042096*^9}, {
   3.5882343368506494`*^9, 3.5882343407662573`*^9}},
 CellLabel->
  "In[405]:=",ExpressionUUID->"cde9dff2-224f-4645-ac0f-856e285c07fc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CanonicalizeGeneralGroupInSym2", "[", 
   RowBox[{
    RowBox[{"SymH", "[", 
     RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], ",", "n_"}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"time", ",", "result"}], "}"}], "=", 
      RowBox[{"AbsoluteTiming", "@", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"newlabel", "=", "label"}], ",", " ", "newsym", ",", " ", 
           "InternalSym", ",", " ", "InternalSymElements", ",", " ", 
           "PermIndex", ",", "newunstableslots", ",", 
           RowBox[{"reverserule", "=", 
            RowBox[{"Thread", "@", 
             RowBox[{"Rule", "[", 
              RowBox[{
               RowBox[{"Range", "@", "n"}], ",", 
               RowBox[{"Reverse", "@", 
                RowBox[{"Range", "@", "n"}]}]}], "]"}]}]}], ",", "intsymel", 
           ",", "reversesym", ",", " ", "firstorbitpoint"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Find", " ", "a", " ", "short", " ", "representation", " ", "of", 
           " ", "the", " ", "reversed", " ", "version", " ", "of", " ", 
           RowBox[{"sym", ".", " ", "This"}], " ", "makes", " ", "the", " ", 
           "following", " ", "computations", " ", 
           RowBox[{"faster", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"reversesym", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"StrongGenSet", "[", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"GenSet", "@@", 
                RowBox[{
                "xAct`SymManipulator`Private`SmallestGenSet", "@", "#"}]}]}], 
              "]"}], "&"}], "@", 
            RowBox[{
            "xAct`SymManipulator`Private`SmallestBaseStabChain", "[", 
             RowBox[{"sym", "/.", "reverserule"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"InternalSym", "=", 
           RowBox[{
            RowBox[{"xAct`SymManipulator`Private`InternalSymmetrySym", "[", 
             RowBox[{"SymH", "[", 
              RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "]"}], "/.",
             "reverserule"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"newsym", ",", "intsymel"}], "}"}], "=", 
           RowBox[{"FindCanonicalGroup", "[", 
            RowBox[{"reversesym", ",", "InternalSym", ",", "n"}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"newsym", "=", 
           RowBox[{"TranslatePerm", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TranslatePerm", "[", 
               RowBox[{"newsym", ",", "Rules"}], "]"}], "/.", "reverserule"}],
              ",", "Cycles"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"newsym", "=", 
           RowBox[{"MapAt", "[", 
            RowBox[{"Sort", ",", "newsym", ",", 
             RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"intsymel", "=", 
           RowBox[{"intsymel", "/.", "reverserule"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"newlabel", "=", 
           RowBox[{
           "xAct`SymManipulator`Private`DefaultLabelSym", "[", "newsym", 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"newunstableslots", "=", 
           RowBox[{"Complement", "[", 
            RowBox[{
             RowBox[{"Range", "@", "n"}], ",", 
             RowBox[{"StablePoints", "[", 
              RowBox[{
               RowBox[{"Last", "@", "newsym"}], ",", "n"}], "]"}]}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"newunstableslots", "=", 
           RowBox[{"DeleteDuplicates", "@", 
            RowBox[{"Join", "[", 
             RowBox[{
              RowBox[{"First", "@", "newsym"}], ",", "newunstableslots"}], 
             "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"newsym", "=", 
           RowBox[{"ReplacePart", "[", 
            RowBox[{"newsym", ",", 
             RowBox[{"1", "->", "newunstableslots"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"SymH", "[", 
             RowBox[{"headlist", ",", "newsym", ",", "newlabel"}], "]"}], ",",
             "intsymel"}], "}"}]}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<CanonicalizeGeneralGroupInSym2: \>\"", ",", " ", "time", ",", 
         " ", "\"\<s.\>\""}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
     "result"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.527145601441438*^9, 3.527145609865453*^9}, {
   3.5271456726087627`*^9, 3.5271457224352508`*^9}, {3.527145762496121*^9, 
   3.527145763650523*^9}, {3.527146292259452*^9, 3.527146300979867*^9}, {
   3.527146495668209*^9, 3.527146537679083*^9}, {3.527147253939741*^9, 
   3.527147398130794*^9}, {3.527147454260693*^9, 3.527147554007268*^9}, {
   3.5271481447501054`*^9, 3.527148178882965*^9}, {3.527150117914174*^9, 
   3.527150159160647*^9}, {3.5271502946312847`*^9, 3.527150299982094*^9}, 
   3.527150334754555*^9, 3.527150494140035*^9, {3.5609447529177938`*^9, 
   3.560944756302998*^9}, {3.561717694041849*^9, 3.561717754148755*^9}, {
   3.561732244141006*^9, 3.561732277010264*^9}, {3.561732400858881*^9, 
   3.561732453196973*^9}, {3.5617324838354273`*^9, 3.5617324883906355`*^9}, {
   3.561732528170705*^9, 3.561732564144368*^9}, 3.561779164855748*^9, {
   3.561781440542945*^9, 3.561781449606561*^9}, {3.561781628663676*^9, 
   3.561781629272077*^9}, {3.5617817760839353`*^9, 3.5617817805455427`*^9}, {
   3.5617820738114576`*^9, 3.561782079037466*^9}, {3.561782164354017*^9, 
   3.5617821715612288`*^9}, {3.561782347139538*^9, 3.5617823663587713`*^9}, {
   3.561782425623275*^9, 3.56178244510771*^9}, {3.5617841740451465`*^9, 
   3.561784218692425*^9}, {3.585235153970932*^9, 3.585235180225778*^9}, {
   3.585235281516756*^9, 3.585235404351372*^9}, {3.585236651449763*^9, 
   3.585236775625981*^9}, {3.5882277082994075`*^9, 3.588227765223907*^9}, {
   3.588227796782762*^9, 3.588227884517316*^9}, 3.588230081517975*^9, {
   3.588230435030196*^9, 3.5882304374014*^9}, {3.588233324688671*^9, 
   3.588233445401684*^9}, {3.58823348299775*^9, 3.5882334837465506`*^9}, {
   3.5882336229923964`*^9, 3.588233658981659*^9}, 3.588233947333565*^9, {
   3.588235401397519*^9, 3.588235418339149*^9}, {3.588235735316106*^9, 
   3.588235735908907*^9}, {3.5882381878608136`*^9, 3.588238192322421*^9}, {
   3.588238531639618*^9, 3.588238548128846*^9}},
 CellLabel->
  "In[406]:=",ExpressionUUID->"4a0beb30-e1c5-4d89-9617-c4cc8f4f787b"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6. Irreducible decomposition", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{
  3.527145150351045*^9, {3.529231764340576*^9, 3.5292317747769957`*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"44e357bb-d759-449d-b7cc-ab080b9b3ba1"],

Cell[CellGroupData[{

Cell["6.1. IrrDecompose", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{
  3.527145152145049*^9, {3.527146210046307*^9, 3.527146234819151*^9}, {
   3.529231821421077*^9, 3.52923182326188*^9}, 
   3.529235602980919*^9},ExpressionUUID->"f6605bd5-6a7b-4123-808f-\
1ac6fa812e37"],

Cell["\<\
Check that the spinors package is loaded. Expand the expression before \
irreducible decomposition.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.529232136136029*^9, 3.529232211671362*^9}, {
  3.592216036426176*^9, 
  3.59221603921618*^9}},ExpressionUUID->"1ac8ba36-9d5f-42b8-a723-\
5d4e5a1c39f5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "IrrDecompose", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Verbose", "\[Rule]", "False"}], ",", 
     RowBox[{"IrrDecSpinBundles", "\[Rule]", "All"}], ",", " ", 
     RowBox[{"UseSym", "\[Rule]", "True"}], ",", 
     RowBox[{"IrrDecImposeNewMethod", "\[Rule]", "False"}], ",", 
     RowBox[{"TimeVerbose", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"ResultType", "\[Rule]", "\"\<Expression\>\""}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5528216593822165`*^9, 3.552821705558298*^9}, {
   3.552821786350839*^9, 3.552821790875848*^9}, {3.592216162446353*^9, 
   3.592216172756367*^9}, {3.592216219556433*^9, 3.592216244556467*^9}, {
   3.592216722767137*^9, 3.592216734287153*^9}, {3.59221723967886*^9, 
   3.592217239778861*^9}, {3.592217291938934*^9, 3.592217314448965*^9}, {
   3.592217419489112*^9, 3.592217421899115*^9}, {3.592217462569173*^9, 
   3.592217464169175*^9}, 3.592217685199484*^9, {3.592217958379866*^9, 
   3.592217964019874*^9}},
 CellLabel->
  "In[407]:=",ExpressionUUID->"a6762c10-baff-48e0-b96f-fa1f7b148550"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IrrDecompose", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"options", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "verb", ",", "AllIrrDecSpinBundles", ",", "spinbundlesoption", ",", 
      "SpinVBs", ",", 
      RowBox[{"expandedexpr", "=", 
       RowBox[{"Expand", "[", "expr", "]"}]}], ",", " ", "irrdecexpr1", ",", 
      "MethodOption", ",", "TimeVerboseOption", ",", " ", "usesymoption", ",",
       "time", ",", "resulttype"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Not", "@", 
        RowBox[{"MemberQ", "[", 
         RowBox[{"$ContextPath", ",", "\"\<xAct`Spinors`\>\""}], "]"}]}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"IrrDecompose", "::", "error"}], ",", 
          "\"\<The Spinors package is needed for this. Please load the \
package Spinors first.\>\""}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "MethodOption", ",", "TimeVerboseOption", ",", "spinbundlesoption", 
        ",", "usesymoption", ",", "resulttype", ",", "verb"}], "}"}], "=", 
      RowBox[{"OptionValue", "[", 
       RowBox[{"{", 
        RowBox[{
        "IrrDecImposeNewMethod", ",", "TimeVerbose", ",", "IrrDecSpinBundles",
          ",", " ", "UseSym", ",", " ", "ResultType", ",", "Verbose"}], "}"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"AllIrrDecSpinBundles", "=", 
      RowBox[{
      "xAct`Spinors`VBundleOfSolderingForm", "/@", 
       "xAct`Spinors`$SolderingForms"}]}], ";", 
     RowBox[{"AllIrrDecSpinBundles", "=", 
      RowBox[{"Union", "[", 
       RowBox[{"AllIrrDecSpinBundles", ",", 
        RowBox[{"Dagger", "/@", "AllIrrDecSpinBundles"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SpinVBs", "=", "AllIrrDecSpinBundles"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{"spinbundlesoption", "===", "All"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SpinVBs", "=", 
        RowBox[{"Intersection", "[", 
         RowBox[{"AllIrrDecSpinBundles", ",", "spinbundlesoption"}], 
         "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"time", ",", " ", "irrdecexpr1"}], "}"}], " ", "=", " ", 
      RowBox[{"AbsoluteTiming", "@", 
       RowBox[{"IrrDecompose2", "[", 
        RowBox[{"expandedexpr", ",", 
         RowBox[{"{", 
          RowBox[{"SpinVBs", ",", "verb"}], "}"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"TimeVerboseOption", ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<IrrDecompose step 1 timing:\>\"", ",", " ", "time"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"And", "[", 
        RowBox[{"usesymoption", ",", 
         RowBox[{
          RowBox[{"Head", "@", "expandedexpr"}], "=!=", "Plus"}]}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"freeinds", ",", " ", "freesym"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"freeinds", ",", " ", "freesym"}], "}"}], "=", 
           RowBox[{"SymmetryOfFreeIndices", "[", 
            RowBox[{"expandedexpr", ",", "SpinVBs"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"MethodOption", ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"time", ",", " ", "irrdecexpr1"}], "}"}], " ", "=", " ", 
             RowBox[{"AbsoluteTiming", "@", 
              RowBox[{"ToCanonical", "@", 
               RowBox[{"ImposeSymmetryOnIrrdecTerms", "[", 
                RowBox[{
                "irrdecexpr1", ",", "freeinds", ",", " ", "freesym", ",", 
                 "SpinVBs"}], "]"}]}]}]}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"time", ",", " ", "irrdecexpr1"}], "}"}], " ", "=", " ", 
             RowBox[{"AbsoluteTiming", "@", 
              RowBox[{"ToCanonical", "@", 
               RowBox[{"ImposeSymmetry", "[", 
                RowBox[{"irrdecexpr1", ",", "freeinds", ",", "freesym"}], 
                "]"}]}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"TimeVerboseOption", ",", 
            RowBox[{"Print", "[", 
             RowBox[{
             "\"\<IrrDecompose step 2 timing:\>\"", ",", " ", "time"}], 
             "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{
      "resulttype", ",", "\[IndentingNewLine]", "\"\<Expression\>\"", ",", 
       "irrdecexpr1", ",", "\[IndentingNewLine]", "\"\<Equation\>\"", ",", 
       RowBox[{"Equal", "[", 
        RowBox[{"expr", ",", "irrdecexpr1"}], "]"}], ",", 
       "\[IndentingNewLine]", "\"\<Rule\>\"", ",", 
       RowBox[{"MakeRule", "[", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"expr", ",", "irrdecexpr1"}], "}"}], ",", 
          RowBox[{"MetricOn", "\[Rule]", "All"}], ",", 
          RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}], "]"}], ",",
        "\[IndentingNewLine]", "\"\<CompareRule\>\"", ",", 
       RowBox[{"MakeCompareRule", "[", 
        RowBox[{"Evaluate", "[", 
         RowBox[{"{", 
          RowBox[{"expr", ",", "irrdecexpr1"}], "}"}], "]"}], "]"}], ",", 
       "\[IndentingNewLine]", "_", ",", "Null"}], "]"}]}]}], "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.529232052192282*^9, 3.529232066544307*^9}, {
   3.5292321078219795`*^9, 3.529232128008415*^9}, {3.529233648575286*^9, 
   3.529233649074487*^9}, {3.529233686873353*^9, 3.529233744874255*^9}, {
   3.529236298321941*^9, 3.52923631521677*^9}, 3.5292363882560987`*^9, {
   3.529236884059169*^9, 3.529236907755611*^9}, 3.5440925159498997`*^9, {
   3.544092556899972*^9, 3.544092575464004*^9}, {3.544092628223297*^9, 
   3.5440926291124988`*^9}, {3.544092707549436*^9, 3.544092763740735*^9}, {
   3.54409730425651*^9, 3.544097353552596*^9}, {3.5528218305935173`*^9, 
   3.552821864975978*^9}, {3.552821916190868*^9, 3.5528219176104703`*^9}, 
   3.5528219548477354`*^9, {3.5528220181994467`*^9, 3.55282202021185*^9}, {
   3.5528221338580494`*^9, 3.552822153810485*^9}, {3.552822186055742*^9, 
   3.552822221592604*^9}, {3.552822254461862*^9, 3.55282229974874*^9}, {
   3.5528227573755455`*^9, 3.5528227721643715`*^9}, {3.5528228866539726`*^9, 
   3.552822921114433*^9}, {3.552822956058494*^9, 3.5528229649973097`*^9}, {
   3.58765308329838*^9, 3.5876531021286125`*^9}, {3.590148509872816*^9, 
   3.590148552726092*^9}, {3.592216501806827*^9, 3.592216524786859*^9}, {
   3.5922165712969246`*^9, 3.59221668979709*^9}, {3.592216747977172*^9, 
   3.592216774307209*^9}, {3.592216861457331*^9, 3.5922169495274544`*^9}, {
   3.5922170161475477`*^9, 3.5922171563777437`*^9}, {3.592217187337787*^9, 
   3.592217223348838*^9}, {3.592217325658981*^9, 3.5922173904390717`*^9}, {
   3.592217441759144*^9, 3.5922176252094*^9}, 3.5922176908594923`*^9, {
   3.592217974369889*^9, 3.592217978729895*^9}, {3.592218325580381*^9, 
   3.5922183276203837`*^9}, {3.592219299522744*^9, 3.592219316402768*^9}, {
   3.5922253121561637`*^9, 3.5922253137161646`*^9}, 3.6800824903159876`*^9},
 CellLabel->
  "In[408]:=",ExpressionUUID->"5e7367a1-1a53-4588-a06f-c7568703e0ee"],

Cell["For backwards compatibility we also define", "Text",
 CellChangeTimes->{{3.592217651079437*^9, 3.592217652899439*^9}, {
  3.592217728669545*^9, 
  3.5922177575995855`*^9}},ExpressionUUID->"663e9a5d-c066-404e-a87f-\
06464a612f91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CompleteIrrDecompose", "[", 
   RowBox[{"expr_", ",", "opt___"}], "]"}], ":=", 
  RowBox[{"IrrDecompose", "[", 
   RowBox[{"expr", ",", 
    RowBox[{"UseSym", "\[Rule]", "True"}], ",", "opt"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5922177649195957`*^9, 3.59221779622964*^9}},
 CellLabel->
  "In[409]:=",ExpressionUUID->"fb5030fb-593c-4635-bd34-fb9e6dd17414"],

Cell["Thread over plus.", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.529232224478985*^9, 3.5292322347594028`*^9}, 
   3.529236437661385*^9},ExpressionUUID->"5ca7f4ba-d9ab-4f6a-baf4-\
32bc5d2b2ba8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IrrDecompose2", "[", 
   RowBox[{"expr_Plus", ",", "opt_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"IrrDecompose2", "[", 
     RowBox[{"#", ",", "opt"}], "]"}], "&"}], "/@", "expr"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.495801329913*^9, 3.4958013496782*^9}, {
  3.529232043503067*^9, 3.529232046872673*^9}, {3.55282231045036*^9, 
  3.552822330340395*^9}},
 CellLabel->
  "In[410]:=",ExpressionUUID->"9b383093-a1f3-4278-8193-ca5fce655901"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IrrDecompose2", "[", 
   RowBox[{
    RowBox[{"s_", "?", "ScalarQ"}], ",", "opt_"}], "]"}], ":=", 
  "s"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.529232384738066*^9, 3.5292323894960747`*^9}, {
  3.552822336112405*^9, 3.552822337157607*^9}},
 CellLabel->
  "In[411]:=",ExpressionUUID->"80918877-232c-4947-a9b0-e74e93f95243"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IrrDecompose2", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"{", 
     RowBox[{"SpinVBs_", ",", "verb_"}], "}"}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"frees", "=", 
       RowBox[{"FindFreeIndices", "@", "expr"}]}], ",", "n", ",", "slotexpr", 
      ",", "slotrules", ",", "sym", ",", "freeslots", ",", "totalsymoffrees", 
      ",", "return"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Finds", " ", "the", " ", "free", " ", "indices", " ", "that", " ", 
      "are", " ", "in", " ", "SpinVBs"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"frees", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"frees", ",", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{"SpinVBs", ",", 
           RowBox[{"VBundleOfIndex", "@", "#"}]}], "]"}], "&"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", ",", "slotexpr", ",", "slotrules", ",", "sym"}], "}"}], 
      "=", 
      RowBox[{"List", "@@", 
       RowBox[{"SymmetryOf", "[", "expr", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Which", " ", "slots", " ", "contains", " ", "the", " ", "free", " ", 
       "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"freeslots", "=", 
      RowBox[{"First", "/@", 
       RowBox[{"List", "@@", 
        RowBox[{"Replace", "[", 
         RowBox[{
          RowBox[{"List", "@@", "frees"}], ",", " ", 
          RowBox[{"Reverse", "/@", "slotrules"}], ",", " ", 
          RowBox[{"{", "1", "}"}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"totalsymoffrees", "=", 
      RowBox[{
       RowBox[{"CompatibleSymmetric", "[", "frees", "]"}], "/.", 
       RowBox[{"Thread", "@", 
        RowBox[{"Rule", "[", 
         RowBox[{
          RowBox[{"Range", "@", 
           RowBox[{"Length", "@", "frees"}]}], ",", "freeslots"}], 
         "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "Check", " ", "if", " ", "expr", " ", "is", " ", "already", " ", 
        "irreducible"}], ",", " ", 
       RowBox[{
       "that", " ", "is", " ", "if", " ", "it", " ", "has", " ", "maximal", 
        " ", "symmetry", " ", "on", " ", "its", " ", "free", " ", 
        "indices"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"verb", ",", 
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<IrrDecompose2[\>\"", ",", "expr", ",", "\"\<,{\>\"", ",", 
         "SpinVBs", ",", "\"\<,\>\"", ",", "verb", ",", "\"\<}]\>\""}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"return", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"SubgroupQ", "[", 
         RowBox[{"totalsymoffrees", ",", "sym"}], "]"}], ",", 
        "\[IndentingNewLine]", "expr", ",", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "If", " ", "it", " ", "is", " ", "not", " ", "irreducible"}], ",", 
          " ", 
          RowBox[{"rewrite", " ", 
           RowBox[{"ImposeSym", "[", 
            RowBox[{"expr", ",", "frees"}], "]"}], " ", "with", " ", 
           RowBox[{"DecomposeStep2", "[", 
            RowBox[{"expr", ",", "frees"}], "]"}], "\[IndentingNewLine]", 
           "  ", "After", " ", "that", " ", "metrics", " ", "are", " ", 
           "moved", " ", "outside", " ", "the", " ", "sym", " ", "if", " ", 
           "they", " ", "are", " ", "not", " ", "symmetrized", " ", 
           RowBox[{"upon", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"ToCanonical", "[", "\[IndentingNewLine]", 
         RowBox[{"(", 
          RowBox[{"expr", "+", 
           RowBox[{"ToCanonicalSym", "@", 
            RowBox[{"RemoveSuperfluousInnerSym", "@", 
             RowBox[{"MoveTensorsOutsideSym", "[", 
              RowBox[{
               RowBox[{"ImposeSym", "[", 
                RowBox[{"expr", ",", "frees"}], "]"}], ",", "True"}], 
              "]"}]}]}], "-", 
           RowBox[{"DecomposeStep2", "[", 
            RowBox[{"expr", ",", "frees", ",", 
             RowBox[{"{", 
              RowBox[{"SpinVBs", ",", "verb"}], "}"}]}], "]"}]}], ")"}], 
         "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", "return"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4801777249106*^9, 3.4801778497626*^9}, {
   3.4801779320316*^9, 3.4801779510166006`*^9}, {3.4801780476936*^9, 
   3.4801780930786*^9}, {3.4801781977896*^9, 3.4801782854726*^9}, {
   3.4801783180476*^9, 3.4801784025636*^9}, {3.4801784661956*^9, 
   3.4801785314986*^9}, {3.4801785656806*^9, 3.4801786331275997`*^9}, {
   3.4801787190976*^9, 3.480178730487601*^9}, 3.4801788859636*^9, 
   3.4801796023016*^9, {3.4801800820936007`*^9, 3.4801800982716*^9}, {
   3.480230807890874*^9, 3.480230896077674*^9}, {3.480230930413274*^9, 
   3.480230931240074*^9}, {3.4802551269502*^9, 3.480255183547*^9}, {
   3.4803100349286003`*^9, 3.4803100565346007`*^9}, 3.4803100903241997`*^9, {
   3.4807664813822*^9, 3.4807664991194*^9}, {3.480766547339*^9, 
   3.4807665552014*^9}, {3.4807667227766*^9, 3.4807667473622*^9}, 
   3.4807671533677998`*^9, {3.4807673572286*^9, 3.4807673652626*^9}, 
   3.4807675157402*^9, {3.4807678585346007`*^9, 3.4807678691114*^9}, {
   3.4807684829558*^9, 3.480768514109*^9}, {3.4807695477026*^9, 
   3.4807695722726*^9}, {3.495468567319005*^9, 3.495468587333805*^9}, {
   3.495468713210205*^9, 3.495468731150204*^9}, {3.495469144175805*^9, 
   3.4954691445658035`*^9}, {3.4955439091307993`*^9, 
   3.4955439267743993`*^9}, {3.4955451488316*^9, 3.4955451549156*^9}, {
   3.4955465456868*^9, 3.4955465519268*^9}, {3.4957038424388*^9, 
   3.4957038570248003`*^9}, {3.495794663877*^9, 3.4957946648754*^9}, {
   3.4957977495726*^9, 3.4957977505086*^9}, {3.4958028074358*^9, 
   3.4958028109146*^9}, {3.4958032660914*^9, 3.4958032679322*^9}, {
   3.4958043342078*^9, 3.4958043607278*^9}, {3.495805031793*^9, 
   3.4958050352406*^9}, {3.5094547008844*^9, 3.509454703318*^9}, {
   3.509455479885999*^9, 3.5094555184336*^9}, {3.5094560356516*^9, 
   3.5094561031528*^9}, {3.5094561698584*^9, 3.5094562205584*^9}, {
   3.509458113067199*^9, 3.5094581156879997`*^9}, {3.5094582003803997`*^9, 
   3.5094582019560003`*^9}, {3.5094586747764*^9, 3.5094586773972*^9}, {
   3.5094598352448*^9, 3.509459837928*^9}, 3.511709560306816*^9, 
   3.5117097477720175`*^9, {3.5117588954702*^9, 3.5117589027398*^9}, {
   3.5118439545837994`*^9, 3.5118439563778*^9}, {3.5118440840014*^9, 
   3.511844092051*^9}, 3.5118443568297997`*^9, 3.511844953093*^9, {
   3.5118461096146*^9, 3.511846122890199*^9}, {3.5118463489653997`*^9, 
   3.5118463505566*^9}, {3.5118488437964*^9, 3.511848845684*^9}, {
   3.5118490799804*^9, 3.5118490815559993`*^9}, 3.5118505613408*^9, {
   3.511850804966*^9, 3.5118508057304*^9}, {3.5118509941472*^9, 
   3.5118509986088*^9}, {3.5118546420566*^9, 3.5118546439442*^9}, {
   3.5118548428442*^9, 3.511854845309*^9}, {3.5118551097445993`*^9, 
   3.5118551309762*^9}, {3.5118554312138*^9, 3.5118554339126*^9}, {
   3.511855593719*^9, 3.511855594889*^9}, {3.5118556530146*^9, 
   3.5118556615478*^9}, 3.511856271461*^9, {3.511856310617*^9, 
   3.5118563211938*^9}, 3.5118563901302*^9, {3.5118575563082*^9, 
   3.5118575588822002`*^9}, {3.5118581638658*^9, 3.5118581655818*^9}, {
   3.5118585172838*^9, 3.5118585380006*^9}, {3.511858746557*^9, 
   3.5118587493494*^9}, 3.5118589194517994`*^9, {3.5118589609634*^9, 
   3.5118589636622*^9}, {3.5118590758574*^9, 3.5118590780882*^9}, {
   3.511859167133*^9, 3.5118591693326*^9}, {3.5118596939294*^9, 
   3.511859722961*^9}, {3.5118597534434*^9, 3.5118597859694*^9}, {
   3.5118690097262*^9, 3.5118690139694*^9}, {3.5118757600802*^9, 
   3.5118757621082*^9}, {3.5118762044462*^9, 3.5118762050234*^9}, {
   3.5118763381538*^9, 3.5118763393082*^9}, {3.511876944557*^9, 
   3.5118769454462*^9}, {3.5120420236104803`*^9, 3.512042031082881*^9}, 
   3.5120429814036803`*^9, {3.5120430273612804`*^9, 3.512043033008481*^9}, {
   3.512043265183281*^9, 3.512043266462481*^9}, {3.512043448342881*^9, 
   3.512043462663681*^9}, {3.5121051390854*^9, 3.5121051417998*^9}, {
   3.5121176955148*^9, 3.5121176973087997`*^9}, {3.516080439840736*^9, 
   3.516080441196814*^9}, {3.517067717963862*^9, 3.517067722055096*^9}, {
   3.5170690344691606`*^9, 3.517069037651344*^9}, {3.529231972741343*^9, 
   3.5292319783729534`*^9}, 3.529232049134677*^9, 3.529232097385562*^9, 
   3.529232277737479*^9, {3.5292327575943217`*^9, 3.529232777094355*^9}, {
   3.529233834185412*^9, 3.5292339306247807`*^9}, {3.5292341379491453`*^9, 
   3.529234205341264*^9}, {3.529234398017203*^9, 3.529234402712811*^9}, {
   3.537621584160347*^9, 3.5376216095883913`*^9}, {3.537625350306362*^9, 
   3.5376253526931663`*^9}, {3.53770111367554*^9, 3.5377011266547627`*^9}, {
   3.537701480681784*^9, 3.537701531912275*^9}, {3.537704798592214*^9, 
   3.5377048373738804`*^9}, {3.544092911410594*^9, 3.544092939755844*^9}, {
   3.54409306284006*^9, 3.5440930855225*^9}, {3.544093262785611*^9, 
   3.544093384497025*^9}, {3.544093522869268*^9, 3.5440936153930306`*^9}, {
   3.544093645485483*^9, 3.544093664767118*^9}, {3.5528223449264207`*^9, 
   3.5528223658772573`*^9}, 3.552822408293732*^9, {3.552822439821387*^9, 
   3.552822510239911*^9}, {3.552822553873188*^9, 3.5528225581475954`*^9}, {
   3.587026666284089*^9, 3.587026671385298*^9}, {3.587122504731518*^9, 
   3.587122505090318*^9}, {3.5871225757428436`*^9, 3.58712258004845*^9}},
 CellLabel->
  "In[412]:=",ExpressionUUID->"ee749926-8359-41aa-af40-cd00a77d6063"],

Cell["\<\
DecomposeStep2[expr, inds] represents the same expression as ImposeSym[expr, \
inds] but written as expr + epsilon times traces. \
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.529234564750295*^9, 3.529234566263499*^9}, {
  3.5292346291628084`*^9, 3.529234632111214*^9}, {3.529234669473279*^9, 
  3.5292347330589905`*^9}, {3.529234764789447*^9, 
  3.5292347670202513`*^9}},ExpressionUUID->"38c18b3c-0bfa-4f44-bed0-\
594d10f39737"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DecomposeStep2", "[", 
   RowBox[{"expr_", ",", " ", "inds_", ",", 
    RowBox[{"{", 
     RowBox[{"SpinVBs_", ",", "verb_"}], "}"}]}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"frees", " ", "=", " ", 
       RowBox[{"FindFreeIndices", "[", "expr", "]"}]}], ",", " ", 
      "splitindices"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{"verb", ",", 
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<DecomposeStep2[\>\"", ",", "expr", ",", "\"\<,\>\"", ",", "inds",
          ",", "\"\<,{\>\"", ",", "SpinVBs", ",", "\"\<,\>\"", ",", "verb", 
         ",", "\"\<}]\>\""}], "]"}]}], "]"}], ";", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "inds", "]"}], " ", "<", " ", "2"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "If", " ", "we", " ", "have", " ", "less", " ", "than", " ", "two", 
         " ", "indices", " ", "we", " ", "can", " ", "not", " ", "rewrite", 
         " ", "the", " ", "expression"}], " ", "*)"}], "\[IndentingNewLine]", 
       "expr", ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"splitindices", " ", "=", " ", 
         RowBox[{"Select", "[", 
          RowBox[{"inds", ",", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"VBundleOfIndex", "[", "#", "]"}], " ", "==", " ", 
             RowBox[{"VBundleOfIndex", "@", 
              RowBox[{"First", "@", "inds"}]}]}], " ", "&"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "splitindices", "]"}], " ", "<", " ", "2"}],
           ",", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
            "If", " ", "we", " ", "only", " ", "have", " ", "one", " ", 
             "index", " ", "in", " ", "this", " ", "VBundle"}], ",", " ", 
            RowBox[{
            "then", " ", "we", " ", "can", " ", "not", " ", "do", " ", 
             "anything", " ", "with", " ", "this", " ", "index"}], ",", 
            "\[IndentingNewLine]", "   ", 
            RowBox[{
            "so", " ", "we", " ", "continue", " ", "the", " ", "procedure", 
             " ", "with", " ", "the", " ", "rest", " ", "of", " ", "the", " ", 
             RowBox[{"indices", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"DecomposeStep2", "[", 
           RowBox[{"expr", ",", " ", 
            RowBox[{"Rest", "@", "inds"}], ",", 
            RowBox[{"{", 
             RowBox[{"SpinVBs", ",", "verb"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
            "If", " ", "we", " ", "more", " ", "indices", " ", "in", " ", 
             "this", " ", "VBundle"}], ",", " ", 
            RowBox[{
            "then", " ", "we", " ", "do", " ", "something", " ", "more", " ", 
             
             RowBox[{"complicated", "."}]}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "tmpexpr", ",", " ", "tmpexpr2", ",", " ", "tmpexpr3", ",", " ", 
              "tmpexpr4", ",", " ", "tmpexpr4b", ",", " ", "tmpexpr5", ",", 
              " ", "tmpexpr6", ",", " ", "finaltmpexpr", ",", " ", 
              "dummyindex", ",", " ", "permutationrules"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"First", ",", " ", 
              RowBox[{
               RowBox[{
               "make", " ", "a", " ", "recursive", " ", "call", " ", "to", 
                " ", "guarantee", " ", "that", " ", "tmpexpr", " ", 
                "represents", " ", 
                RowBox[{"ImposeSym", "[", 
                 RowBox[{"expr", ",", 
                  RowBox[{"Rest", "@", "inds"}]}], "]"}], 
                "\[IndentingNewLine]", "   ", "written", " ", "as", " ", 
                "expr"}], " ", "+", " ", 
               RowBox[{"epsilon", " ", "times", " ", "traces"}]}]}], " ", 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpexpr", " ", "=", " ", 
              RowBox[{"DecomposeStep2", "[", 
               RowBox[{"expr", ",", " ", 
                RowBox[{"Rest", "@", "inds"}], ",", 
                RowBox[{"{", 
                 RowBox[{"SpinVBs", ",", "verb"}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Let", " ", "tmpexpr2", " ", "be", " ", "the", " ", "same", " ",
                "thing", " ", "but", " ", "represented", " ", "as", " ", "a", 
               " ", "SymH", " ", "object"}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"tmpexpr2", " ", "=", " ", 
              RowBox[{"ImposeSym", "[", 
               RowBox[{"expr", ",", " ", 
                RowBox[{"Rest", "@", "inds"}], ",", " ", 
                RowBox[{"CompatibleSymmetric", "[", 
                 RowBox[{"Rest", "@", "inds"}], "]"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{
               "We", " ", "want", " ", "to", " ", "take", " ", "a", " ", 
                "trace", " ", "between", " ", 
                RowBox[{"splitindices", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], " ", "and", " ", 
                RowBox[{
                 RowBox[{"splitindices", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ".", "\[IndentingNewLine]", 
                 " ", "First"}], " ", "we", " ", "remove", " ", "these", " ", 
                "two", " ", "indices", " ", "from", " ", "the", " ", 
                "symmetry"}], ",", " ", "\[IndentingNewLine]", "   ", 
               RowBox[{
               "and", " ", "move", " ", "possible", " ", "metrics", " ", 
                "outside", " ", "the", " ", "SymH", " ", 
                RowBox[{"object", "."}]}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{"verb", ",", 
               RowBox[{
                RowBox[{"Print", "[", 
                 RowBox[{
                 "\"\<DecomposeStep2[\>\"", ",", "expr", ",", "\"\<,\>\"", 
                  ",", "inds", ",", "\"\<...]: tmpexpr=\>\"", ",", 
                  "tmpexpr"}], "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"Print", "[", 
                 RowBox[{
                 "\"\<DecomposeStep2[\>\"", ",", "expr", ",", "\"\<,\>\"", 
                  ",", "inds", ",", "\"\<...]: tmpexpr2=\>\"", ",", 
                  "tmpexpr2"}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
             
             RowBox[{"tmpexpr3", " ", "=", 
              RowBox[{"MoveTensorsOutsideSym", "[", 
               RowBox[{
                RowBox[{"Expand", "@", 
                 RowBox[{"ExpandSymOneIndex", "[", 
                  RowBox[{
                   RowBox[{"ExpandSymOneIndex", "[", 
                    RowBox[{"tmpexpr2", ",", " ", 
                    RowBox[{"splitindices", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", " ", 
                   RowBox[{"splitindices", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ",", "True"}], 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Generate", " ", "a", " ", "new", " ", "dummy", " ", "index", 
               " ", "for", " ", "the", " ", 
               RowBox[{"trace", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"dummyindex", " ", "=", 
              RowBox[{"DownIndex", "@", 
               RowBox[{"DummyIn", "@", 
                RowBox[{"VBundleOfIndex", "[", 
                 RowBox[{"splitindices", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{"Make", " ", "the", " ", 
               RowBox[{"contraction", "."}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"tmpexpr4", " ", "=", " ", 
              RowBox[{"ReplaceIndex", "[", 
               RowBox[{
                RowBox[{"Evaluate", "@", "tmpexpr3"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"splitindices", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "->", " ", 
                   RowBox[{"-", "dummyindex"}]}], ",", " ", 
                  RowBox[{
                   RowBox[{"splitindices", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "->", " ", 
                   "dummyindex"}]}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{"verb", ",", 
               RowBox[{"Print", "[", 
                RowBox[{
                "\"\<DecomposeStep2[\>\"", ",", "expr", ",", "\"\<,\>\"", ",",
                  "inds", ",", "\"\<...]: tmpexpr4=\>\"", ",", "tmpexpr4"}], 
                "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{
               "If", " ", "we", " ", "now", " ", "got", " ", "a", " ", 
                "metric", " ", "with", " ", "one", " ", "index", " ", 
                "contracted", " ", "and", " ", "the", " ", "other", " ", "in",
                 " ", "the", " ", "symmetry"}], ",", "\[IndentingNewLine]", 
               "   ", 
               RowBox[{"we", " ", "can", " ", "contract", " ", "this", " ", 
                RowBox[{"metric", ".", " ", "After"}], " ", "that"}], ",", 
               " ", 
               RowBox[{"the", " ", "expression", " ", "is", " ", 
                RowBox[{"canonicalized", "."}]}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"tmpexpr4b", " ", "=", " ", 
              RowBox[{"ToCanonicalSym", "@", 
               RowBox[{"ContractMetricsInsideSym", "@", "tmpexpr4"}]}]}], ";",
              "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Find", " ", "the", " ", "Irreducible", " ", "decomposition", 
               " ", "of", " ", "this", " ", "symmetrized", " ", "and", " ", 
               "contracted", " ", 
               RowBox[{"expression", "."}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"tmpexpr5", " ", "=", " ", 
              RowBox[{"IrrDecompose2", "[", 
               RowBox[{"tmpexpr4b", ",", 
                RowBox[{"{", 
                 RowBox[{"SpinVBs", ",", "verb"}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Multiply", " ", "this", " ", "with", " ", "the", " ", 
               "epsilon", " ", "of", " ", "the", " ", "first", " ", "two", 
               " ", "splitindices"}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"tmpexpr6", " ", "=", " ", 
              RowBox[{"Expand", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"First", "@", 
                   RowBox[{"MetricsOfVBundle", "@", 
                    RowBox[{"VBundleOfIndex", "[", 
                    RowBox[{"splitindices", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ")"}], "[", 
                 RowBox[{
                  RowBox[{"splitindices", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                  RowBox[{"splitindices", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "*", "tmpexpr5"}],
                "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{
               "The", " ", "idea", " ", "is", " ", "now", " ", "that", " ", 
                "expr", " ", "can", " ", "be", " ", "written", " ", "as", " ",
                 "tmpexpr"}], " ", "+", " ", 
               RowBox[{"c", "*", 
                RowBox[{
                 RowBox[{"ImposeSym", "[", 
                  RowBox[{"tmpexpr6", ",", " ", 
                   RowBox[{"Rest", "@", "splitindices"}]}], "]"}], ".", 
                 "\[IndentingNewLine]", "The"}], " ", "problem", " ", "is", 
                " ", "that", " ", "the", " ", "second", " ", "term", " ", 
                "will", " ", "contain", " ", "epsilons", " ", "with", " ", 
                RowBox[{
                "symmetrizations", ".", " ", "\[IndentingNewLine]", "We"}], 
                " ", "want", " ", "to", " ", "avoid", " ", 
                RowBox[{"that", ".", " ", "We"}], " ", "notive", " ", "that", 
                " ", "tmpexpr6", " ", "is", " ", "symmetric", " ", "in", " ", 
                
                RowBox[{
                 RowBox[{"Rest", "@", 
                  RowBox[{"Rest", "@", "splitinices"}]}], ".", 
                 "\[IndentingNewLine]", "The"}], " ", "symmetrization", " ", 
                "can", " ", "therefore", " ", "be", " ", "represented", " ", 
                "by", " ", "the", " ", "permutations", " ", "that", " ", 
                "interchange", " ", "\[IndentingNewLine]", " ", 
                RowBox[{"splitindices", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], " ", "with", " ", 
                RowBox[{"Rest", "@", "splitindices"}]}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Construct", " ", "the", " ", "rules", " ", "that", " ", 
               "interchange", " ", 
               RowBox[{"splitindices", "[", 
                RowBox[{"[", "2", "]"}], "]"}], " ", "with", " ", 
               RowBox[{
                RowBox[{"Rest", "@", "splitindices"}], "."}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"permutationrules", " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Rule", "[", 
                   RowBox[{
                    RowBox[{"splitindices", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"splitindices", "[", 
                    RowBox[{"[", "#", "]"}], "]"}]}], "]"}], ",", " ", 
                  RowBox[{"Rule", "[", 
                   RowBox[{
                    RowBox[{"splitindices", "[", 
                    RowBox[{"[", "#", "]"}], "]"}], ",", " ", 
                    RowBox[{"splitindices", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], "&"}], 
               " ", "/@", " ", 
               RowBox[{"Range", "[", 
                RowBox[{"2", ",", " ", 
                 RowBox[{"Length", "[", "splitindices", "]"}]}], "]"}]}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "The", " ", "final", " ", "expression", " ", "therefore", " ", 
               "has", " ", "this", " ", 
               RowBox[{"form", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"finaltmpexpr", " ", "=", " ", 
              RowBox[{"Expand", "[", 
               RowBox[{"tmpexpr", " ", "+", " ", 
                RowBox[{
                 RowBox[{"1", "/", 
                  RowBox[{"Length", "[", "splitindices", "]"}]}], "*", 
                 RowBox[{"Plus", " ", "@@", " ", 
                  RowBox[{"(", 
                   RowBox[{"tmpexpr6", " ", "/.", " ", "permutationrules"}], 
                   ")"}]}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
             "finaltmpexpr"}]}], "]"}]}], "]"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4801623828640003`*^9, 3.4801626604504004`*^9}, {
   3.4801626962679996`*^9, 3.48016277263*^9}, {3.4801628069032*^9, 
   3.4801628135332*^9}, {3.4801628616280003`*^9, 3.4801628739988*^9}, {
   3.4801640864152*^9, 3.4801641539164*^9}, {3.4801642587328*^9, 
   3.4801642651288*^9}, {3.480164419132*^9, 3.4801644294904003`*^9}, {
   3.4801644881776*^9, 3.4801645009852*^9}, {3.4801655813943996`*^9, 
   3.480165594358*^9}, {3.4801656660244*^9, 3.48016568242*^9}, {
   3.4801657436188*^9, 3.480165751122401*^9}, {3.4801658134444*^9, 
   3.48016581463*^9}, 3.4801658464852*^9, {3.4801658775916*^9, 
   3.4801658805556*^9}, {3.4801659275428*^9, 3.4801659286504*^9}, {
   3.4801661283928003`*^9, 3.4801661357716*^9}, {3.4801674247684*^9, 
   3.4801674552352*^9}, 3.4801676737132*^9, 3.4801677092812*^9, {
   3.4801684441348*^9, 3.480168448534*^9}, {3.4801685038828*^9, 
   3.4801685587324*^9}, {3.4801686013048*^9, 3.4801686022564*^9}, {
   3.4801691440132*^9, 3.48016926223*^9}, {3.4801693255192003`*^9, 
   3.4801693268764*^9}, {3.4801694049544*^9, 3.4801694118964*^9}, {
   3.4801696098448*^9, 3.480169623682*^9}, 3.4801760597986*^9, {
   3.4801761184886*^9, 3.4801761195406*^9}, {3.4801761531186*^9, 
   3.4801761539396*^9}, {3.4801764584686007`*^9, 3.4801764852546*^9}, {
   3.4801769569436*^9, 3.4801770081726*^9}, {3.4801770451426*^9, 
   3.480177051888601*^9}, {3.480177096737601*^9, 3.4801771290736*^9}, {
   3.4801771914386*^9, 3.4801771918336*^9}, 3.4801772688136*^9, {
   3.4801773478706007`*^9, 3.4801773901196003`*^9}, {3.4801774358576*^9, 
   3.4801774456896*^9}, {3.4801775053166*^9, 3.4801775846996*^9}, {
   3.4801776482316*^9, 3.4801776495016007`*^9}, {3.4801792955686*^9, 
   3.4801792991836*^9}, {3.4801793855416*^9, 3.4801793867616*^9}, {
   3.4801799250576*^9, 3.4801799405076*^9}, {3.4801800915606008`*^9, 
   3.4801801008516*^9}, {3.480230373259274*^9, 3.4802303992176747`*^9}, {
   3.480230581332074*^9, 3.480230615995274*^9}, 3.480230708082074*^9, 
   3.4802309257956743`*^9, {3.480230959897274*^9, 3.480230961628874*^9}, {
   3.480231080641274*^9, 3.480231081062475*^9}, {3.480231244488075*^9, 
   3.480231273925274*^9}, 3.4802526555514*^9, {3.4802526913066*^9, 
   3.480252741289*^9}, {3.4802527723486*^9, 3.4802528306458*^9}, {
   3.4802528722354*^9, 3.4802530226974*^9}, 3.480253061635*^9, {
   3.4802531978074*^9, 3.4802532688966*^9}, {3.480253302577*^9, 
   3.4802533435114*^9}, {3.4802534128534*^9, 3.4802534833654*^9}, {
   3.4802535395566*^9, 3.4802535399154*^9}, {3.480253631347*^9, 
   3.4802536321114*^9}, 3.480253710283*^9, {3.4802538595282*^9, 
   3.4802538756429996`*^9}, {3.4802539963246*^9, 3.4802540148886*^9}, {
   3.4802540596138*^9, 3.480254099425*^9}, {3.4802541353986*^9, 
   3.4802541572386*^9}, 3.4802542986058*^9, {3.4802543833450003`*^9, 
   3.4802543970106*^9}, {3.480310137717*^9, 3.4803101425842*^9}, {
   3.480766566137*^9, 3.4807665844202003`*^9}, {3.4807669554974008`*^9, 
   3.4807669846070004`*^9}, {3.4807684114142*^9, 3.4807684413974*^9}, {
   3.4807685736542*^9, 3.4807687313389997`*^9}, {3.480768762149*^9, 
   3.4807687623674*^9}, {3.480768816671*^9, 3.480768818309*^9}, {
   3.480768852395*^9, 3.4807688784782*^9}, {3.4807689652142*^9, 
   3.480768970955*^9}, {3.4807690337918*^9, 3.4807690374110007`*^9}, {
   3.4807694642738*^9, 3.4807694794526*^9}, 3.4807695676394*^9, {
   3.495468610406204*^9, 3.495468625382205*^9}, {3.4955438524404*^9, 
   3.495543859398*^9}, {3.4955450708004*^9, 3.4955450771496*^9}, {
   3.495546503364*^9, 3.4955465103528*^9}, {3.4957946737518*^9, 
   3.495794679009*^9}, {3.495796478001*^9, 3.4957964933358*^9}, {
   3.495797829663*^9, 3.4957978575558*^9}, {3.4957979475834*^9, 
   3.495797983869*^9}, {3.4957980260982*^9, 3.4957980566118*^9}, {
   3.4957983490025997`*^9, 3.4957983868482*^9}, {3.4957986712518*^9, 
   3.495798692889*^9}, {3.4957987508118*^9, 3.4957987613886003`*^9}, {
   3.4957987959582*^9, 3.4957988588886003`*^9}, {3.4957988917265997`*^9, 
   3.4957988997138*^9}, 3.495798972597*^9, {3.4957990849482*^9, 
   3.495799114947*^9}, {3.4957992338970003`*^9, 3.4957992444114*^9}, {
   3.495799284909*^9, 3.4957992903222*^9}, {3.4957994278361998`*^9, 
   3.4957994581782*^9}, {3.4957995012342*^9, 3.495799506429*^9}, {
   3.4957995959105997`*^9, 3.4957996541610003`*^9}, {3.4957999001418*^9, 
   3.4957999053054*^9}, 3.4958007636486*^9, {3.495800794068599*^9, 
   3.4958008461102*^9}, {3.4958009352017994`*^9, 3.495800964795*^9}, {
   3.4958018544318*^9, 3.4958019119646*^9}, {3.495802399059*^9, 
   3.495802399995*^9}, {3.4958026452894*^9, 3.495802646475*^9}, {
   3.4958030437914*^9, 3.4958030595629997`*^9}, {3.4958031386237993`*^9, 
   3.4958031490758*^9}, {3.4958033099898*^9, 3.495803310723*^9}, {
   3.4958034612785993`*^9, 3.495803464913399*^9}, {3.4958042955198*^9, 
   3.4958043078126*^9}, {3.497621048126*^9, 3.4976210660036*^9}, {
   3.4976210989196*^9, 3.4976211655316*^9}, {3.497621766038*^9, 
   3.4976217693296003`*^9}, {3.497621933114*^9, 3.4976219391823997`*^9}, {
   3.497686623035599*^9, 3.497686632068*^9}, 3.4976866983524*^9, 
   3.49768707581*^9, 3.497687198816*^9, {3.49768728095*^9, 
   3.4976872989524*^9}, {3.4976875397072*^9, 3.4976875725764*^9}, {
   3.497687829134*^9, 3.49768783124*^9}, {3.4976878810352*^9, 
   3.4976878869944*^9}, {3.4976880133232*^9, 3.497688013838*^9}, {
   3.5094548476336*^9, 3.5094548501296*^9}, {3.5094550305123997`*^9, 
   3.509455093786*^9}, {3.50945529877*^9, 3.5094553709044*^9}, {
   3.5094563332995987`*^9, 3.5094563384944*^9}, {3.5094564308775997`*^9, 
   3.509456438896*^9}, {3.5094565162564*^9, 3.509456545678*^9}, {
   3.5094566142712*^9, 3.5094566381548*^9}, {3.5094567433612003`*^9, 
   3.5094567777904*^9}, 3.5094571006168*^9, {3.5094579361164*^9, 
   3.5094580058328*^9}, {3.5094580402152*^9, 3.5094580761576*^9}, {
   3.5094581236907988`*^9, 3.5094581776668*^9}, {3.5094582991596*^9, 
   3.509458300236*^9}, {3.5094585786492*^9, 3.509458646478*^9}, {
   3.5094591010308*^9, 3.5094591394067993`*^9}, {3.5094591806844*^9, 
   3.5094591823691993`*^9}, {3.5094592200432*^9, 3.5094592522416*^9}, {
   3.5094594178668*^9, 3.5094594401748*^9}, {3.5094596463912*^9, 
   3.5094596468904*^9}, {3.5094606503136*^9, 3.5094606677076*^9}, {
   3.5117091857508163`*^9, 3.511709188652416*^9}, {3.511709292876016*^9, 
   3.511709300629216*^9}, {3.511709806162816*^9, 3.5117098262244167`*^9}, {
   3.5117099368752165`*^9, 3.511709939184016*^9}, {3.511710062408417*^9, 
   3.511710064405216*^9}, {3.511710112968016*^9, 3.5117101212360168`*^9}, {
   3.511710217597216*^9, 3.511710221746816*^9}, {3.511710313537216*^9, 
   3.511710318404416*^9}, {3.511710533232016*^9, 3.511710534792016*^9}, {
   3.511710949268417*^9, 3.511711030762817*^9}, {3.511711132209616*^9, 
   3.511711134019216*^9}, {3.511711288584016*^9, 3.511711292530816*^9}, {
   3.511711529073616*^9, 3.511711529572816*^9}, {3.511711586154017*^9, 
   3.5117115933612165`*^9}, {3.5117119482466173`*^9, 
   3.5117119740802164`*^9}, {3.5117120464798164`*^9, 3.511712074528616*^9}, {
   3.5117123366398163`*^9, 3.511712375171816*^9}, {3.511712463733016*^9, 
   3.511712493669416*^9}, {3.511712578829816*^9, 3.511712587207016*^9}, 
   3.5117569245662*^9, {3.5117585361865997`*^9, 3.5117585404765997`*^9}, {
   3.5117605375318003`*^9, 3.5117605555498*^9}, {3.5117616394846*^9, 
   3.5117616776266007`*^9}, {3.5117617812106*^9, 3.5117618055466003`*^9}, {
   3.5117619631066*^9, 3.5117619933082*^9}, {3.5117620598266*^9, 
   3.5117621298862*^9}, {3.5117622226282*^9, 3.5117622283534*^9}, {
   3.5117622628762*^9, 3.511762291034199*^9}, {3.5117623306426*^9, 
   3.5117623383022003`*^9}, {3.5117625057838*^9, 3.5117625301822*^9}, {
   3.5117632557538*^9, 3.5117632853626003`*^9}, {3.5117633156422*^9, 
   3.5117633206654*^9}, {3.5117634031738*^9, 3.5117634209421997`*^9}, {
   3.511763532061*^9, 3.5117635387846003`*^9}, {3.5117636017618*^9, 
   3.5117636109658*^9}, {3.5117636746762*^9, 3.5117637291514*^9}, {
   3.511763789461*^9, 3.5117638100685997`*^9}, {3.5117638705810003`*^9, 
   3.511763878537*^9}, {3.511767756931*^9, 3.5117677699102*^9}, {
   3.5117678069914*^9, 3.5117678071786003`*^9}, {3.5117678475982*^9, 
   3.5117678483782*^9}, {3.5117678876278*^9, 3.5117678889538*^9}, 
   3.511767952399*^9, {3.5117679966094*^9, 3.5117680343926*^9}, {
   3.5117680645942*^9, 3.5117680677922*^9}, {3.5117681339517994`*^9, 
   3.511768151533*^9}, {3.5117682474886*^9, 3.5117682516226*^9}, {
   3.511768365253*^9, 3.5117683843162*^9}, {3.5117684160934*^9, 
   3.511768475779*^9}, {3.5117685108789997`*^9, 3.5117685519226*^9}, {
   3.5117687116822*^9, 3.5117687152858*^9}, {3.5117690878294*^9, 
   3.5117690988274*^9}, {3.5117692276210003`*^9, 3.5117692368406*^9}, {
   3.5117693874118*^9, 3.5117694268954*^9}, {3.5117696861362*^9, 
   3.511769695355799*^9}, {3.5117697480526*^9, 3.5117698022158003`*^9}, {
   3.5117698559110003`*^9, 3.5117698633054*^9}, {3.5117700909718*^9, 
   3.5117701576462*^9}, {3.511770254023*^9, 3.5117702913382*^9}, {
   3.5117703441442*^9, 3.511770420163*^9}, {3.5117704633282*^9, 
   3.5117704655278*^9}, {3.5117705036854*^9, 3.5117705198626003`*^9}, {
   3.5118422090998*^9, 3.5118422626233997`*^9}, {3.5118423228862*^9, 
   3.5118423420898*^9}, {3.5118423839758*^9, 3.5118424217434*^9}, {
   3.5118425565898*^9, 3.511842610285*^9}, 3.511842665789799*^9, {
   3.5118428114314*^9, 3.5118428680594*^9}, {3.5118429037522*^9, 
   3.511843066507*^9}, 3.5118432446434*^9, {3.5118433098982*^9, 
   3.5118433232518*^9}, {3.5118434158066*^9, 3.5118434172262*^9}, {
   3.5118435540226*^9, 3.5118435573766003`*^9}, {3.5118436844074*^9, 
   3.5118437237038*^9}, {3.5118437718766003`*^9, 3.511843775293*^9}, {
   3.5118438833386*^9, 3.5118439125886*^9}, {3.5118440204782*^9, 
   3.511844030977*^9}, {3.5118442405474*^9, 3.5118442545874*^9}, {
   3.5118448006809998`*^9, 3.5118448103218*^9}, 3.5118448998346*^9, {
   3.5118450430114*^9, 3.5118450447586*^9}, {3.5118450848974*^9, 
   3.5118450958174*^9}, {3.5118451959382*^9, 3.511845206047*^9}, {
   3.5118452679322*^9, 3.5118452697262*^9}, {3.511845311892999*^9, 
   3.5118453289282*^9}, {3.5118453967258*^9, 3.511845405836199*^9}, {
   3.5118456933442*^9, 3.5118456965577993`*^9}, 3.511846135042599*^9, {
   3.5118462267706*^9, 3.5118462528226*^9}, {3.511846300621*^9, 
   3.5118463026958*^9}, {3.5118463389346*^9, 3.5118463393402*^9}, {
   3.5118463929574003`*^9, 3.5118463998058*^9}, {3.5118464962606*^9, 
   3.5118465057298*^9}, {3.5118476274175997`*^9, 3.511847629788799*^9}, {
   3.51184848509*^9, 3.5118485160247993`*^9}, {3.5118508157924*^9, 
   3.511850832344*^9}, {3.5118510121652*^9, 3.5118510862028*^9}, {
   3.5118544050614*^9, 3.511854422627*^9}, {3.5118547407734003`*^9, 
   3.511854799211*^9}, {3.5118551875418*^9, 3.5118552029546*^9}, 
   3.511855258319*^9, {3.5118553380818*^9, 3.511855358627*^9}, {
   3.511855623359*^9, 3.5118556447466*^9}, {3.5118570730514*^9, 
   3.5118570809449997`*^9}, {3.5118577957214003`*^9, 
   3.5118577976870003`*^9}, {3.5118578294018*^9, 3.5118578679182*^9}, {
   3.5118580872074003`*^9, 3.5118580910606*^9}, {3.5118583656362*^9, 
   3.5118583687094*^9}, {3.5118585484681993`*^9, 3.5118585505586*^9}, {
   3.511858735481*^9, 3.5118587391158*^9}, {3.5118588658346*^9, 
   3.511858869953*^9}, {3.511858980557*^9, 3.5118589947374*^9}, {
   3.5118593652998*^9, 3.511859367359*^9}, {3.5118594363421993`*^9, 
   3.5118594538922*^9}, {3.5118598999274*^9, 3.5118599005826*^9}, {
   3.5118599983946*^9, 3.5118600384866*^9}, {3.5118609741434*^9, 
   3.5118609786674*^9}, {3.5118610086974*^9, 3.5118611217038*^9}, {
   3.5118615292226*^9, 3.5118615322802*^9}, {3.5118616107014*^9, 
   3.5118616122614*^9}, {3.5118680434622*^9, 3.5118680920718*^9}, {
   3.5118681517106*^9, 3.511868193237798*^9}, {3.5118686775866*^9, 
   3.511868697539*^9}, {3.5118691543226*^9, 3.5118691562726*^9}, {
   3.5118692381414003`*^9, 3.5118692609798*^9}, {3.5118732153613997`*^9, 
   3.5118732171085997`*^9}, {3.5118734458358*^9, 3.5118736206806*^9}, {
   3.5118736535654*^9, 3.511873683455*^9}, {3.5118737790986*^9, 
   3.5118737794574003`*^9}, {3.5118739370954*^9, 3.5118739882478*^9}, {
   3.5118744413654003`*^9, 3.5118744655922003`*^9}, {3.5118745306598*^9, 
   3.511874554559*^9}, {3.5118745899709997`*^9, 3.5118746018894*^9}, {
   3.511874896745*^9, 3.511874946353*^9}, {3.511875049703*^9, 
   3.5118750538213997`*^9}, {3.5118750918854*^9, 3.511875124973*^9}, {
   3.5118752632826*^9, 3.5118753271802*^9}, {3.511875748817*^9, 
   3.5118757504393997`*^9}, {3.5118763583246*^9, 3.5118763658282*^9}, {
   3.511876973260999*^9, 3.5118770046637993`*^9}, {3.5118772025966*^9, 
   3.511877218181*^9}, {3.512038237005081*^9, 3.512038252542681*^9}, {
   3.5120385235458803`*^9, 3.512038555853481*^9}, {3.512040384924081*^9, 
   3.512040458821281*^9}, {3.512041061230881*^9, 3.5120410739448805`*^9}, {
   3.512041210366881*^9, 3.512041297711281*^9}, {3.5120414311536803`*^9, 
   3.512041435584081*^9}, {3.5120417231232805`*^9, 3.5120417239968805`*^9}, 
   3.512041786537281*^9, {3.512042279466081*^9, 3.512042279466081*^9}, {
   3.51204259974968*^9, 3.512042815294881*^9}, 3.512043495174081*^9, {
   3.512043548931681*^9, 3.512043550226481*^9}, {3.512043761356881*^9, 
   3.512043768470481*^9}, {3.5121051617834*^9, 3.5121051901441994`*^9}, 
   3.5121052439018*^9, {3.5121066621446*^9, 3.5121067491302*^9}, {
   3.5121069224462*^9, 3.5121069395126*^9}, {3.5121145832368*^9, 
   3.512114618212*^9}, {3.5121149333476*^9, 3.5121149660764*^9}, {
   3.5121151132156*^9, 3.512115114448*^9}, {3.512117178484*^9, 
   3.5121172110880003`*^9}, {3.516080461340966*^9, 3.516080471747561*^9}, {
   3.517067866762373*^9, 3.517067870267574*^9}, {3.517069024855612*^9, 
   3.51706902866183*^9}, 3.529232085014739*^9, {3.529234828671559*^9, 
   3.52923492604693*^9}, {3.537622754927803*^9, 3.537622830665937*^9}, {
   3.537622908837674*^9, 3.537622918852891*^9}, {3.537623129702862*^9, 
   3.5376231716513352`*^9}, 3.537623322971601*^9, {3.537625357217174*^9, 
   3.537625374892005*^9}, {3.537701598851992*^9, 3.5377016029548*^9}, {
   3.5377803862918596`*^9, 3.5377804386143517`*^9}, {3.537780548032945*^9, 
   3.537780566050975*^9}, {3.537780676062369*^9, 3.537780706889023*^9}, {
   3.537780749633098*^9, 3.537780752753104*^9}, {3.5377808149504137`*^9, 
   3.537780815870815*^9}, {3.537780900422962*^9, 3.537780909673778*^9}, {
   3.5377810637084494`*^9, 3.5377810684040585`*^9}, {3.537781192954677*^9, 
   3.537781232703546*^9}, {3.537781366645381*^9, 3.537781368283385*^9}, {
   3.53778167285832*^9, 3.537781707100379*^9}, {3.5440937424718547`*^9, 
   3.54409387689729*^9}, {3.54409397361746*^9, 3.54409403639197*^9}, {
   3.544094223763899*^9, 3.544094241797531*^9}, {3.544094279409197*^9, 
   3.544094434613869*^9}, {3.544094467483127*^9, 3.544094562237694*^9}, {
   3.544094601190962*^9, 3.5440946022829647`*^9}, {3.5440947364120007`*^9, 
   3.5440947750532675`*^9}, {3.544094871773438*^9, 3.544094926685534*^9}, {
   3.544094960677994*^9, 3.544095042468937*^9}, {3.544095082951009*^9, 
   3.544095116974668*^9}, {3.54409520343102*^9, 3.544095243023889*^9}, {
   3.544095284457563*^9, 3.5440953381372566`*^9}, 3.544095382363334*^9, {
   3.544095493341929*^9, 3.5440955855068913`*^9}, {3.5440956268625636`*^9, 
   3.544095718091524*^9}, {3.5440963554774446`*^9, 3.544096361296254*^9}, {
   3.5440963935883102`*^9, 3.5440966249523177`*^9}, {3.544096686526625*^9, 
   3.544096708007863*^9}, {3.544096750611538*^9, 3.544096750923538*^9}, {
   3.544096812980447*^9, 3.544096860810131*^9}, {3.5440969144274254`*^9, 
   3.544096916471029*^9}, {3.544096958169902*^9, 3.544097048603261*^9}, {
   3.552822573123622*^9, 3.552822630625323*^9}, {3.55282310168475*^9, 
   3.552823178764485*^9}, {3.552823554085544*^9, 3.5528236467185073`*^9}, {
   3.552823835556839*^9, 3.5528238477560606`*^9}, 3.5528260960184093`*^9, {
   3.587026703365354*^9, 3.587026719230582*^9}, {3.5871225270551577`*^9, 
   3.587122534106369*^9}},
 CellLabel->
  "In[413]:=",ExpressionUUID->"b5837ae6-9d1f-4a40-bf5c-e3d6216d6912"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryOfFreeIndices", "[", 
   RowBox[{"expr_", ",", "SpinVBs_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"freeinds", "=", 
       RowBox[{"FindFreeIndices", "@", "expr"}]}], ",", " ", 
      "\[IndentingNewLine]", "freeinvbslots", ",", " ", "restslots", ",", " ",
       "slotexpr", ",", "slotrules", ",", "sym", ",", "n", ",", 
      "freefirstperm", ",", " ", "freesym", ",", "freeinvb", ",", 
      "restfrees"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", ",", "slotexpr", ",", "slotrules", ",", "sym"}], "}"}], 
      "=", 
      RowBox[{"List", "@@", 
       RowBox[{"SymmetryOf", "[", "expr", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"freeinvb", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"freeinds", ",", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{"SpinVBs", ",", 
           RowBox[{"UpIndex", "@", 
            RowBox[{"VBundleOfIndex", "[", "#", "]"}]}]}], "]"}], "&"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"freeinvbslots", "=", 
      RowBox[{"First", "/@", 
       RowBox[{"List", "@@", 
        RowBox[{"Replace", "[", 
         RowBox[{
          RowBox[{"List", "@@", "freeinvb"}], ",", " ", 
          RowBox[{"Reverse", "/@", "slotrules"}], ",", " ", 
          RowBox[{"{", "1", "}"}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"restslots", "=", 
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"Range", "@", "n"}], ",", "freeinvbslots"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"freefirstperm", "=", 
      RowBox[{"List", "@@", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{
         RowBox[{"PermutationFromTo", "[", 
          RowBox[{
           RowBox[{"Range", "@", "n"}], ",", 
           RowBox[{"Join", "[", 
            RowBox[{"freeinvbslots", ",", "restslots"}], "]"}]}], "]"}], ",", 
         "Rules"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "The", " ", "stabilizer", " ", "only", " ", "gives", " ", "a", " ", 
        "subset", " ", "of", " ", "the", " ", "symmetry"}], ",", " ", 
       RowBox[{"but", " ", "might", " ", "be", " ", "good", " ", 
        RowBox[{"enough", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"freesym", "=", 
      RowBox[{"StabilizerSGS", "[", 
       RowBox[{"restslots", ",", "sym"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"freesym", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "=", 
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"freesym", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "restslots"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"freesym", "=", 
      RowBox[{"freesym", "/.", "freefirstperm"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"IndexList", "@@", "freeinvb"}], ",", " ", "freesym"}], 
      "}"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5120440463064814`*^9, 3.5120441363964806`*^9}, {
   3.512044169967681*^9, 3.5120443099932804`*^9}, {3.512044359195681*^9, 
   3.512044374405681*^9}, {3.5120444870532804`*^9, 3.512044490126481*^9}, {
   3.512044529828481*^9, 3.512044544430081*^9}, {3.512044621400481*^9, 
   3.512044678293681*^9}, {3.512044772470881*^9, 3.512044787041281*^9}, {
   3.512045021103681*^9, 3.5120452329828806`*^9}, {3.512045265836481*^9, 
   3.51204530617808*^9}, {3.5120453415588803`*^9, 3.512045421586881*^9}, {
   3.512045479447281*^9, 3.51204557064488*^9}, {3.544097175759084*^9, 
   3.5440971846667*^9}, {3.5903072696663833`*^9, 3.590307367774955*^9}, {
   3.590307454901108*^9, 3.590307542339261*^9}, 3.590307608982579*^9, {
   3.5903077740006685`*^9, 3.590307936771355*^9}, {3.5903079710758142`*^9, 
   3.590308054629561*^9}, {3.590308096063234*^9, 3.590308113972066*^9}, 
   3.5903081448289194`*^9, {3.6196887282077293`*^9, 3.6196887286177297`*^9}},
 CellLabel->
  "In[414]:=",ExpressionUUID->"ce9e4008-dea6-49d8-8a8c-9f02853694fe"],

Cell[TextData[{
 "When CompleteIrrDecImposeNewMethod is set to True, we \
don\[CloseCurlyQuote]t use the complete group G = ",
 StyleBox["freesym",
  FontSlant->"Italic"],
 ". The ideal method would be to use ImposeSym and ExpandSym with the option \
SmartExpand->True. This however, requires the computation of the mixed \
symmetry which takes a long time to compute. Instead we extract the indices \
of the irreducible part. If we stabilize all other points of G we get a \
subgroup P of H (the internal symmetry). All permutations in P will give \
expressions that canonicalizes to the same expression. We can therefore use a \
transversal of P in G instead of the complete group G."
}], "Text",
 CellChangeTimes->{{3.584776000118119*^9, 3.584776187146847*^9}, {
  3.584776225897315*^9, 3.584776420164456*^9}, {3.5847764533457146`*^9, 
  3.584776486324172*^9}, {3.5847765390522647`*^9, 3.584776595087564*^9}, {
  3.5847766299536247`*^9, 3.584776738623416*^9}, {3.5847768678072433`*^9, 
  3.5847769846670475`*^9}, {3.584777047581958*^9, 
  3.584777065053989*^9}},ExpressionUUID->"47511d46-e4d7-4283-af85-\
c46d4b8a6f43"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FreeIndsOfIrrDecPart", "[", 
   RowBox[{"expr_", ",", "spinmetrics_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"vbPMQs", "=", 
      RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "/@", 
       RowBox[{"VBundleOfMetric", "/@", "spinmetrics"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FindFreeIndices", "@", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"expr", "/.", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"A_", ",", "B_"}], "]"}], "\[Rule]", "1"}], ")"}], 
           "&"}], "/@", "spinmetrics"}], ")"}]}], "/.", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"delta", "[", 
             RowBox[{
              RowBox[{"A_", "?", "#"}], ",", 
              RowBox[{"B_", "?", "#"}]}], "]"}], "\[Rule]", "1"}], ")"}], 
          "&"}], "/@", "vbPMQs"}], ")"}]}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.584768711514245*^9, 3.584768718206657*^9}, {
   3.584768775879958*^9, 3.584768892817764*^9}, {3.584768923659017*^9, 
   3.584768940039047*^9}, {3.584768979881517*^9, 3.584769013764776*^9}, {
   3.5847691945222936`*^9, 3.584769220199939*^9}, {3.5847692636148148`*^9, 
   3.584769308262094*^9}, {3.5847693712082043`*^9, 3.584769377947416*^9}, {
   3.584769422703894*^9, 3.584769592042192*^9}, {3.5847696258006516`*^9, 
   3.584769686656358*^9}, 3.584772121183905*^9, 3.584773578586265*^9, {
   3.5847745786582212`*^9, 3.5847746155990868`*^9}, {3.584775176856872*^9, 
   3.5847752059977236`*^9}, 3.584775577044376*^9, 3.5871277307436976`*^9, 
   3.587128272220648*^9},
 CellLabel->
  "In[415]:=",ExpressionUUID->"a21d735c-3274-4156-852a-cfbf190b8df3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSymmetryOnIrrdecTerms", "[", 
   RowBox[{"expr_", ",", "freeinds_", ",", " ", "freesym_", ",", "SpinVBs_"}],
    "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "spinmetrics", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"spinmetrics", "=", 
      RowBox[{"First", "/@", 
       RowBox[{"MetricsOfVBundle", "/@", "SpinVBs"}]}]}], ";", 
     RowBox[{"ImposeSymmetryOnIrrdecTerm", "[", 
      RowBox[{
       RowBox[{"Expand", "@", "expr"}], ",", "spinmetrics", ",", "freeinds", 
       ",", " ", "freesym"}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.584773338782644*^9, 3.584773383164721*^9}, {
   3.584773434410811*^9, 3.584773517324957*^9}, 3.584773967307748*^9, {
   3.5847747511633253`*^9, 3.5847747898669934`*^9}, 3.584774821503848*^9, {
   3.584775448437749*^9, 3.584775452103756*^9}, {3.5903074115174317`*^9, 
   3.590307419442245*^9}, {3.590307716170367*^9, 3.590307733907598*^9}},
 CellLabel->
  "In[416]:=",ExpressionUUID->"d225174a-460d-4f1d-8a8a-1823b454e230"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSymmetryOnIrrdecTerm", "[", 
   RowBox[{
   "expr_Plus", ",", "spinmetrics_", ",", "freeinds_", ",", " ", "freesym_"}],
    "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"ImposeSymmetryOnIrrdecTerm", "[", 
     RowBox[{"#", ",", "spinmetrics", ",", "freeinds", ",", " ", "freesym"}], 
     "]"}], "&"}], "/@", "expr"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.584773530647381*^9, 3.5847735550146236`*^9}, {
  3.584774826854658*^9, 3.5847748291322613`*^9}},
 CellLabel->
  "In[417]:=",ExpressionUUID->"a9a7c532-db4d-4df6-b366-1977bdd944fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImposeSymmetryOnIrrdecTerm", "[", 
   RowBox[{
   "expr_", ",", "spinmetrics_", ",", "freeinds_", ",", " ", "freesym_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "irrdecpartfrees", ",", "stabpoints", ",", "newfreesym", ",", 
      "permlist"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"irrdecpartfrees", "=", 
      RowBox[{"FreeIndsOfIrrDecPart", "[", 
       RowBox[{"expr", ",", "spinmetrics"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"stabpoints", "=", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", "freeinds"}]}], ",", 
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{"irrdecpartfrees", ",", 
           RowBox[{"freeinds", "[", 
            RowBox[{"[", "#", "]"}], "]"}], ",", "1"}], "]"}], "&"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"newfreesym", "=", 
      RowBox[{"BaseChange2", "[", 
       RowBox[{"freesym", ",", "stabpoints"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"permlist", "=", 
      RowBox[{"InversePerm", "/@", 
       RowBox[{"xAct`SymManipulator`Private`TransversalComputation", "[", 
        RowBox[{
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"newfreesym", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"Stabilizer", "[", 
            RowBox[{"stabpoints", ",", 
             RowBox[{"newfreesym", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], ",", 
         "newfreesym"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Expand", "@", 
      RowBox[{"ImposeSymmetry", "[", 
       RowBox[{"expr", ",", "freeinds", ",", 
        RowBox[{"Group", "@@", "permlist"}], ",", "Identity"}], "]"}]}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.584772051389383*^9, 3.5847721008414693`*^9}, {
   3.5847721367527328`*^9, 3.584772159201172*^9}, {3.5847721977644396`*^9, 
   3.584772372266346*^9}, {3.5847724541508904`*^9, 3.584772461732503*^9}, {
   3.5847727243589644`*^9, 3.584772782671867*^9}, {3.58477284683478*^9, 
   3.584772922573913*^9}, {3.584773260189706*^9, 3.5847732668353186`*^9}, 
   3.584773301810579*^9, {3.584774356185231*^9, 3.584774366122448*^9}, {
   3.584774399944308*^9, 3.5847744302083607`*^9}, {3.584774661244767*^9, 
   3.584774697858031*^9}, {3.5847747342684946`*^9, 3.584774740633306*^9}, 
   3.584774990077744*^9, {3.5847754223389034`*^9, 3.584775423649305*^9}, 
   3.584775583752387*^9, 3.6196888353119273`*^9, {3.619688891312005*^9, 
   3.619688941032075*^9}},
 CellLabel->
  "In[418]:=",ExpressionUUID->"55481610-1b6e-4613-a25d-a55ba1c7b702"]
}, Closed]],

Cell[CellGroupData[{

Cell["6.2. IndepIrrDecompose", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.680089274121486*^9, 
  3.680089293481512*^9}},ExpressionUUID->"8e9d39cb-5986-4773-9838-\
43fdb9ca535f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DgSpinVBOfSpinVB", "[", "spin_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"ServantsOf", "[", "spin", "]"}], ",", 
      RowBox[{"Dagger", "@", "spin"}]}], "]"}], ",", "spin", ",", 
    RowBox[{"Dagger", "@", "spin"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.680084749091151*^9, 3.680084774051185*^9}, {
  3.680085019131528*^9, 3.68008502755154*^9}},
 CellLabel->
  "In[419]:=",ExpressionUUID->"5fb1e3b3-e0f9-4570-b846-15cd1c2e38a7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RemoveConstantFactors", "[", 
    RowBox[{
     RowBox[{"c_", "?", "ConstantQ"}], "*", "expr_"}], "]"}], ":=", "expr"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveConstantFactors", "[", "expr_", "]"}], ":=", "expr"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.59048370236848*^9, 3.590483760738561*^9}, {
  3.680089903492367*^9, 3.680089903712367*^9}},
 CellLabel->
  "In[420]:=",ExpressionUUID->"8f57e950-4c33-4f3e-a832-3f52e8dc8b54"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindSpinorsInIrrDec", "[", 
   RowBox[{"expr_", ",", "spinmetrics_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"vbPMQs", "=", 
       RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "/@", 
        RowBox[{"VBundleOfMetric", "/@", "spinmetrics"}]}]}], ",", 
      RowBox[{"termlist", "=", 
       RowBox[{"xAct`xTensor`Private`ListOfTerms", "[", "expr", "]"}]}], ",", 
      
      RowBox[{"spindgs", "=", 
       RowBox[{"Union", "[", 
        RowBox[{"DgSpinVBOfSpinVB", "/@", 
         RowBox[{"VBundleOfMetric", "/@", "spinmetrics"}]}], "]"}]}]}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"Union", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ChangeFreeIndicesToDefault", "[", 
        RowBox[{
         RowBox[{"RemoveConstantFactors", "[", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "/.", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"A_", ",", "B_"}], "]"}], "\[Rule]", "1"}], ")"}], 
                "&"}], "/@", "spinmetrics"}], ")"}]}], "/.", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"delta", "[", 
                  RowBox[{
                   RowBox[{"A_", "?", "#"}], ",", 
                   RowBox[{"B_", "?", "#"}]}], "]"}], "\[Rule]", "1"}], ")"}],
                "&"}], "/@", "vbPMQs"}], ")"}]}], ")"}], "]"}], ",", 
         "spindgs"}], "]"}], "&"}], "/@", "termlist"}], "]"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.680083786338803*^9, 3.680083872738923*^9}, {
   3.680084698061079*^9, 3.680084704001087*^9}, {3.6800850595215845`*^9, 
   3.680085130881685*^9}, {3.6800851629617295`*^9, 3.6800852052317886`*^9}, 
   3.680101641165312*^9},
 CellLabel->
  "In[422]:=",ExpressionUUID->"ad45b906-ae92-479f-b2ac-3e7796e292b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "IndepIrrDecompose", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Verbose", "\[Rule]", "False"}], ",", 
     RowBox[{"IrrDecSpinBundles", "\[Rule]", "All"}], ",", " ", 
     RowBox[{"UseSym", "\[Rule]", "True"}], ",", 
     RowBox[{"IrrDecImposeNewMethod", "\[Rule]", "False"}], ",", 
     RowBox[{"TimeVerbose", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"ResultType", "\[Rule]", "\"\<Expression\>\""}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.680082428925902*^9},
 CellLabel->
  "In[423]:=",ExpressionUUID->"281f032a-8b19-4b51-87b3-8a335a4ac3d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IndepIrrDecompose", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"options", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "irrdec", ",", "irrdecparts", ",", "AllIrrDecSpinBundles", ",", 
      "SpinVBs", ",", "spinbundlesoption", ",", "SpinMetrics", ",", 
      "valences", ",", "duplicatevalences", ",", "possilbydep", ",", 
      "irrdecrule", ",", "relations", ",", "reductioneqs", ",", "indepirrdec",
       ",", "resulttype", ",", "verb"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"spinbundlesoption", ",", " ", "resulttype", ",", "verb"}], 
       "}"}], "=", 
      RowBox[{"OptionValue", "[", 
       RowBox[{"{", 
        RowBox[{"IrrDecSpinBundles", ",", "ResultType", ",", "Verbose"}], 
        "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"AllIrrDecSpinBundles", "=", 
      RowBox[{
      "xAct`Spinors`VBundleOfSolderingForm", "/@", 
       "xAct`Spinors`$SolderingForms"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"AllIrrDecSpinBundles", "=", 
      RowBox[{"Union", "[", 
       RowBox[{"AllIrrDecSpinBundles", ",", 
        RowBox[{"Dagger", "/@", "AllIrrDecSpinBundles"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SpinVBs", "=", "AllIrrDecSpinBundles"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{"spinbundlesoption", "===", "All"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SpinVBs", "=", 
        RowBox[{"Intersection", "[", 
         RowBox[{"AllIrrDecSpinBundles", ",", "spinbundlesoption"}], 
         "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"SpinMetrics", "=", 
      RowBox[{"First", "/@", 
       RowBox[{"MetricsOfVBundle", "/@", "SpinVBs"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"verb", ",", 
       RowBox[{
       "Print", "[", "\"\<Computing irreducible decomposition.\>\"", "]"}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"irrdec", "=", 
      RowBox[{"IrrDecompose", "[", 
       RowBox[{"expr", ",", 
        RowBox[{"ResultType", "\[Rule]", "\"\<Expression\>\""}], ",", 
        RowBox[{"FilterRules", "[", 
         RowBox[{
          RowBox[{"{", "options", "}"}], ",", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Options", "[", "IrrDecompose", "]"}], "/.", 
             RowBox[{"ResultType", "\[Rule]", "\"\<\>\""}]}], "/.", 
            RowBox[{"Verbose", "\[Rule]", "False"}]}], ")"}]}], "]"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"verb", ",", 
       RowBox[{"Print", "[", "\"\<Finding irrducible parts.\>\"", "]"}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"irrdecparts", "=", 
      RowBox[{"FindSpinorsInIrrDec", "[", 
       RowBox[{"irrdec", ",", "SpinMetrics"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"verb", ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Found \>\"", ",", 
         RowBox[{"Length", "@", "irrdecparts"}], " ", ",", 
         "\"\< irreducible parts.\>\""}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"valences", "=", 
      RowBox[{"Tally", "/@", 
       RowBox[{"Map", "[", 
        RowBox[{"VBundleOfIndex", ",", 
         RowBox[{"List", "@@@", 
          RowBox[{"(", 
           RowBox[{"FindFreeIndices", "/@", "irrdecparts"}], ")"}]}], ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"duplicatevalences", "=", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Tally", "@", "valences"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Last", "[", "#", "]"}], ">", "1"}], "&"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"possilbydep", "=", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Pick", "[", 
          RowBox[{"irrdecparts", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "===", "x"}], "&"}], "/@", "valences"}]}], "]"}]}], 
        "]"}], "/@", 
       RowBox[{"First", "/@", "duplicatevalences"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"verb", ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Possibly dependent \>\"", ",", " ", "possilbydep"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"irrdecrule", "=", 
      RowBox[{"MakeCompareRule", "[", 
       RowBox[{"Evaluate", "[", 
        RowBox[{"{", 
         RowBox[{"expr", ",", "irrdec"}], "}"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"relations", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "\[Equal]", 
          RowBox[{"ScreenDollarIndices", "@", 
           RowBox[{"ToCanonical", "@", 
            RowBox[{"ImposeSym", "@", 
             RowBox[{"ToCanonical", "@", 
              RowBox[{"ContractMetric", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SeparateMetric", "[", "]"}], "@", 
                 RowBox[{"RemoveSym", "@", "#"}]}], "/.", "irrdecrule"}], 
               "]"}]}]}]}]}]}], "&"}], ",", "possilbydep", ",", 
        RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"reductioneqs", "=", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"Solve", "/@", "relations"}], "]"}], "/.", 
       RowBox[{"Rule", "\[Rule]", "Equal"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"verb", ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Found relations \>\"", ",", " ", "reductioneqs"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"indepirrdec", "=", 
      RowBox[{"Expand", "[", 
       RowBox[{"irrdec", "/.", 
        RowBox[{"Flatten", "[", 
         RowBox[{"EqToCompareRule", "/@", "reductioneqs"}], "]"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{
      "resulttype", ",", "\[IndentingNewLine]", "\"\<Expression\>\"", ",", 
       "indepirrdec", ",", "\[IndentingNewLine]", "\"\<Equation\>\"", ",", 
       RowBox[{"Equal", "[", 
        RowBox[{"expr", ",", "indepirrdec"}], "]"}], ",", 
       "\[IndentingNewLine]", "\"\<Rule\>\"", ",", 
       RowBox[{"MakeRule", "[", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"expr", ",", "indepirrdec"}], "}"}], ",", 
          RowBox[{"MetricOn", "\[Rule]", "All"}], ",", 
          RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}], "]"}], ",",
        "\[IndentingNewLine]", "\"\<CompareRule\>\"", ",", 
       RowBox[{"MakeCompareRule", "[", 
        RowBox[{"Evaluate", "[", 
         RowBox[{"{", 
          RowBox[{"expr", ",", "indepirrdec"}], "}"}], "]"}], "]"}], ",", 
       "\[IndentingNewLine]", "_", ",", "Null"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6800823494857907`*^9, 3.6800823704258204`*^9}, 
   3.680082464975952*^9, {3.6800825172660255`*^9, 3.680082542586061*^9}, {
   3.6800825879861245`*^9, 3.6800826857562613`*^9}, {3.680082729806323*^9, 
   3.680082764866372*^9}, {3.680083074056805*^9, 3.680083215107003*^9}, {
   3.680083325588157*^9, 3.6800833318981657`*^9}, {3.6800833920982504`*^9, 
   3.6800833928682513`*^9}, {3.680083557748482*^9, 3.6800836153085628`*^9}, {
   3.680083730868725*^9, 3.680083768278777*^9}, {3.680084344889585*^9, 
   3.680084380609635*^9}, {3.680086178074151*^9, 3.680086244554244*^9}, {
   3.680086295914316*^9, 3.680086520954631*^9}, 3.680086680494854*^9, {
   3.680086729735924*^9, 3.680086764655972*^9}, {3.680086814976043*^9, 
   3.680086869436119*^9}, {3.680086937306214*^9, 3.680087035596352*^9}, 
   3.680087137966495*^9, {3.680087265936674*^9, 3.680087336136772*^9}, {
   3.680087366416815*^9, 3.6800873686468186`*^9}, {3.6800878553985*^9, 
   3.680087938518616*^9}, {3.680087972698664*^9, 3.680088018878728*^9}, {
   3.680088109668855*^9, 3.6800881596489253`*^9}, {3.6800881936789727`*^9, 
   3.680088237719034*^9}, {3.6800882876791043`*^9, 3.680088317559146*^9}, {
   3.6800884135892797`*^9, 3.680088421609292*^9}, {3.680088465109353*^9, 
   3.680088525239437*^9}, {3.680088606369551*^9, 3.680088857759903*^9}, {
   3.680088894919955*^9, 3.680088922619993*^9}, {3.680088960901047*^9, 
   3.6800889692110586`*^9}, {3.680089020511131*^9, 3.68008909837124*^9}, 
   3.68010165434533*^9, {3.685193202820696*^9, 3.6851932030906973`*^9}, {
   3.689401637125912*^9, 3.689401644902689*^9}},
 CellLabel->
  "In[424]:=",ExpressionUUID->"d170ffd0-aad1-4ed5-90c4-b41338301e30"]
}, Closed]],

Cell[CellGroupData[{

Cell["6.3. Naming irreducible parts", "Subsubsection",
 CellChangeTimes->{{3.680090290343909*^9, 
  3.680090324703957*^9}},ExpressionUUID->"05f14e13-6c66-4ea1-bcff-\
80ddbe4275e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NameTensors1", "[", 
   RowBox[{
   "struct_List", ",", "basename_String", ",", "baseprintas_String", ",", 
    "spin_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "@", "struct"}], "\[Equal]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Symbol", "[", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"basename", ",", 
           RowBox[{"ToString", "[", 
            RowBox[{"struct", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], ",", 
           RowBox[{"ToString", "[", 
            RowBox[{"struct", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}], "]"}], "@@", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"DownIndex", "/@", 
           RowBox[{"GetIndexRange", "[", 
            RowBox[{
             RowBox[{"struct", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "spin"}], "]"}]}], 
          ",", 
          RowBox[{"GetIndexRange", "[", 
           RowBox[{
            RowBox[{"struct", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
            RowBox[{"Dagger", "@", "spin"}]}], "]"}]}], "]"}]}], ",", 
       RowBox[{"struct", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{"StringJoin", "[", 
        RowBox[{
        "\"\<\\!\\(\\*UnderscriptBox[\\(\>\"", ",", "baseprintas", ",", 
         "\"\<\\), \\(\>\"", ",", 
         RowBox[{"ToString", "[", 
          RowBox[{"struct", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], ",", "\"\<,\>\"", 
         ",", " ", 
         RowBox[{"ToString", "[", 
          RowBox[{"struct", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}], ",", 
         "\"\<\\)]\\)\>\""}], "]"}], ",", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\\\underset{\>\"", ",", 
         RowBox[{"ToString", "[", 
          RowBox[{"struct", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], ",", "\"\<,\>\"", 
         ",", " ", 
         RowBox[{"ToString", "[", 
          RowBox[{"struct", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}], ",", "\"\<}{\>\"", 
         ",", 
         RowBox[{"xAct`TexAct`Tex", "[", "baseprintas", "]"}], ",", 
         "\"\<}{}\>\""}], "]"}]}], "}"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Symbol", "[", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"basename", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"struct", "[", 
              RowBox[{"[", 
               RowBox[{"#", ",", "1"}], "]"}], "]"}], "]"}], ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"struct", "[", 
              RowBox[{"[", 
               RowBox[{"#", ",", "2"}], "]"}], "]"}], "]"}], ",", 
            RowBox[{"FromCharacterCode", "[", 
             RowBox[{"96", "+", "#"}], "]"}]}], "]"}], "]"}], "@@", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"DownIndex", "/@", 
            RowBox[{"GetIndexRange", "[", 
             RowBox[{
              RowBox[{"struct", "[", 
               RowBox[{"[", 
                RowBox[{"#", ",", "1"}], "]"}], "]"}], ",", "spin"}], "]"}]}],
            ",", 
           RowBox[{"GetIndexRange", "[", 
            RowBox[{
             RowBox[{"struct", "[", 
              RowBox[{"[", 
               RowBox[{"#", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"Dagger", "@", "spin"}]}], "]"}]}], "]"}]}], ",", 
        RowBox[{"struct", "[", 
         RowBox[{"[", 
          RowBox[{"#", ",", "3"}], "]"}], "]"}], ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
         "\"\<\\!\\(\\*UnderscriptBox[\\(\>\"", ",", "baseprintas", ",", 
          RowBox[{"FromCharacterCode", "[", 
           RowBox[{"96", "+", "#"}], "]"}], ",", "\"\<\\), \\(\>\"", ",", 
          RowBox[{"ToString", "[", 
           RowBox[{"struct", "[", 
            RowBox[{"[", 
             RowBox[{"#", ",", "1"}], "]"}], "]"}], "]"}], ",", "\"\<,\>\"", 
          ",", " ", 
          RowBox[{"ToString", "[", 
           RowBox[{"struct", "[", 
            RowBox[{"[", 
             RowBox[{"#", ",", "2"}], "]"}], "]"}], "]"}], ",", 
          "\"\<\\)]\\)\>\""}], "]"}], ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{"\"\<\\\\underset{\>\"", ",", 
          RowBox[{"ToString", "[", 
           RowBox[{"struct", "[", 
            RowBox[{"[", 
             RowBox[{"#", ",", "1"}], "]"}], "]"}], "]"}], ",", "\"\<,\>\"", 
          ",", " ", 
          RowBox[{"ToString", "[", 
           RowBox[{"struct", "[", 
            RowBox[{"[", 
             RowBox[{"#", ",", "2"}], "]"}], "]"}], "]"}], ",", "\"\<}{\>\"", 
          ",", 
          RowBox[{"xAct`TexAct`Tex", "[", "baseprintas", "]"}], ",", 
          RowBox[{"FromCharacterCode", "[", 
           RowBox[{"96", "+", "#"}], "]"}], ",", "\"\<}{}\>\""}], "]"}]}], 
       "}"}], "&"}], "/@", 
     RowBox[{"Range", "@", 
      RowBox[{"Length", "@", "struct"}]}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5904866315145802`*^9, 3.5904867907848034`*^9}, {
   3.590486857544897*^9, 3.590486889604941*^9}, {3.590486921424986*^9, 
   3.590486957285036*^9}, {3.590487004805103*^9, 3.5904870050751033`*^9}, {
   3.590487215075398*^9, 3.5904872795054874`*^9}, {3.59048740977567*^9, 
   3.590487564005885*^9}, {3.590487671167036*^9, 3.590487778107186*^9}, {
   3.5904878565472956`*^9, 3.590487927537395*^9}, {3.590487993317487*^9, 
   3.590487998297494*^9}, {3.59048803147754*^9, 3.5904881122676535`*^9}, {
   3.5904881581077175`*^9, 3.590488163817725*^9}, {3.590488274867881*^9, 
   3.5904883343479643`*^9}, {3.590488396478051*^9, 3.590488425798092*^9}, {
   3.5904885979483337`*^9, 3.590488605688344*^9}, {3.590489392819446*^9, 
   3.590489406479465*^9}, {3.590489578909707*^9, 3.5904896436497974`*^9}, {
   3.6800904971241975`*^9, 3.6800905375642548`*^9}, 3.6800905698542995`*^9, {
   3.680104039804991*^9, 3.680104086665056*^9}},
 CellLabel->
  "In[425]:=",ExpressionUUID->"7ffe0b8d-aa6f-4187-9d54-6d0cb824685f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GiveNamesToIrreducibleParts", "[", 
   RowBox[{
   "irrdectensors_List", ",", "basename_String", ",", "baseprintas_String", 
    ",", "spin_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NumOfUnprimedVBundles", "=", 
       RowBox[{
        RowBox[{"Length", "@", 
         RowBox[{"Cases", "[", 
          RowBox[{
           RowBox[{"UpIndex", "/@", "#"}], ",", "spin"}], "]"}]}], "&"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"NumOfPrimedVBundles", "=", 
       RowBox[{
        RowBox[{"Length", "@", 
         RowBox[{"Cases", "[", 
          RowBox[{
           RowBox[{"UpIndex", "/@", "#"}], ",", 
           RowBox[{"Dagger", "[", "spin", "]"}]}], "]"}]}], "&"}]}]}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sortedtensors", "=", "\[IndentingNewLine]", 
         RowBox[{"Sort", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"NumOfUnprimedVBundles", "[", 
               RowBox[{"VBundleOfIndex", "/@", 
                RowBox[{"FindFreeIndices", "@", "#"}]}], "]"}], ",", 
              RowBox[{"NumOfPrimedVBundles", "[", 
               RowBox[{"VBundleOfIndex", "/@", 
                RowBox[{"FindFreeIndices", "@", "#"}]}], "]"}], ",", "#"}], 
             "}"}], "&"}], "/@", "irrdectensors"}], "]"}]}], ",", 
        "numberofkind"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"NameTensors1", "[", 
           RowBox[{"#", ",", "basename", ",", "baseprintas", ",", "spin"}], 
           "]"}], "&"}], "/@", 
         RowBox[{"GatherBy", "[", 
          RowBox[{"sortedtensors", ",", "Most"}], "]"}]}], ",", "1"}], 
       "]"}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590485568212092*^9, 3.590485671992237*^9}, {
   3.590485726342313*^9, 3.590485739792332*^9}, {3.590486348354184*^9, 
   3.590486410834271*^9}, {3.590486518494422*^9, 3.5904865202044244`*^9}, {
   3.590488207167786*^9, 3.5904882082077875`*^9}, 3.590488241917835*^9, {
   3.590488504858203*^9, 3.590488543698257*^9}, {3.590488702178479*^9, 
   3.590488706718486*^9}, {3.6800904383041153`*^9, 3.6800904456741257`*^9}, {
   3.6800904934741926`*^9, 3.680090494364194*^9}, {3.680101506915124*^9, 
   3.680101510765129*^9}},
 CellLabel->
  "In[426]:=",ExpressionUUID->"8ef3e47b-3894-4b74-9001-3f4176bb4531"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefIrreducibleSpinors", "[", 
   RowBox[{
   "irrdectensors_List", ",", "basename_String", ",", "baseprintas_String", 
    ",", "spin_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"namestruct", "=", 
       RowBox[{"GiveNamesToIrreducibleParts", "[", 
        RowBox[{
        "irrdectensors", ",", "basename", ",", "baseprintas", ",", "spin"}], 
        "]"}]}], ",", "defcommands"}], "}"}], ",", 
    RowBox[{
     RowBox[{"defcommands", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"First", "[", "#", "]"}], ",", 
          RowBox[{"BaseOfVBundle", "[", "spin", "]"}], ",", 
          RowBox[{"CompatibleSymmetric", "[", 
           RowBox[{"IndexList", "@@", 
            RowBox[{"First", "[", "#", "]"}]}], "]"}], ",", 
          RowBox[{"PrintAs", "\[Rule]", 
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
       "namestruct"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"xAct`Spinors`DefSpinor", "@@@", "defcommands"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"xAct`TexAct`Tex", "[", 
          RowBox[{"Head", "[", 
           RowBox[{"First", "[", "#", "]"}], "]"}], "]"}], "^=", 
         RowBox[{"#", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], ")"}], "&"}], "/@", 
      "namestruct"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Equal", "@@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", "2"}], "]"}], "&"}], "/@", "namestruct"}], 
       ")"}]}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590488825038651*^9, 3.590488832338661*^9}, {
   3.590488882038731*^9, 3.5904889923888845`*^9}, {3.590489063048984*^9, 
   3.590489092819026*^9}, {3.5904891580291176`*^9, 3.590489341669375*^9}, {
   3.590489519529623*^9, 3.5904895702296944`*^9}, {3.5904896527098103`*^9, 
   3.5904896532098107`*^9}, {3.5904897210999055`*^9, 3.590489770529975*^9}, 
   3.590489830020058*^9, {3.590490014171316*^9, 3.590490031701341*^9}, {
   3.680090411014077*^9, 3.680090431354106*^9}, {3.680101529355156*^9, 
   3.680101540135171*^9}, 3.680104094755068*^9, {3.6801043888064804`*^9, 
   3.680104398906495*^9}, {3.680104530856679*^9, 3.680104539856691*^9}},
 CellLabel->
  "In[427]:=",ExpressionUUID->"c28bb8e8-70de-4438-b219-d7dfaa9d4756"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["7. More tools", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{
  3.527145150351045*^9, {3.529231764340576*^9, 3.5292317747769957`*^9}, {
   3.57476893236627*^9, 3.5747689402442837`*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"f5bed154-72f7-42cd-85c5-ea6e28bbc165"],

Cell[CellGroupData[{

Cell["7.1. SymmetryOfExpression", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{
  3.527145152145049*^9, {3.527146210046307*^9, 3.527146234819151*^9}, {
   3.529231821421077*^9, 3.52923182326188*^9}, 3.529235602980919*^9, {
   3.5747689345814743`*^9, 
   3.574768955844311*^9}},ExpressionUUID->"55409199-4263-49b0-aa82-\
fddb984eaf1d"],

Cell["\<\
This function computed the symmetry of the free indices of any expression by \
a conducting a tree search. At the nodes the symmetry is tested with HasSym, \
which checks if a permutation is in the symmetry by checking if the permuted \
expression minus the original expression canonicalizes to 0. Signed \
permutations are handled as a permutation of two extra points as in xPerm.\
\>", "Text",
 CellChangeTimes->{{3.574769110846184*^9, 
  3.574769439602161*^9}},ExpressionUUID->"d9f5dee2-50f4-437d-b348-\
8afbe5979338"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryOfExpression", "[", "expr_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"frees", "=", 
       RowBox[{"FindFreeIndices", "@", "expr"}]}], ",", "HasSym", ",", 
      "completesymmetricSGS"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", "=", 
        RowBox[{"Length", "@", "frees"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"HasSym", "[", "p_", "]"}], ":=", 
        RowBox[{
         RowBox[{"ToCanonical", "[", 
          RowBox[{
           RowBox[{"PermuteIndices", "[", 
            RowBox[{"expr", ",", "frees", ",", 
             RowBox[{"xAct`xPerm`Private`ToSign", "[", 
              RowBox[{"p", ",", "n"}], "]"}]}], "]"}], "-", "expr"}], "]"}], "===",
          "0"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"completesymmetricSGS", "=", 
        RowBox[{"JoinSGS", "[", 
         RowBox[{
          RowBox[{"Symmetric", "[", 
           RowBox[{
            RowBox[{"Range", "@", "n"}], ",", "Cycles"}], "]"}], ",", 
          RowBox[{"Symmetric", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"n", "+", "1"}], ",", 
              RowBox[{"n", "+", "2"}]}], "}"}], ",", "Cycles"}], "]"}]}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"completesymmetricSGS", "=", 
        RowBox[{"ReplacePart", "[", 
         RowBox[{"completesymmetricSGS", ",", 
          RowBox[{"1", "\[Rule]", 
           RowBox[{"Append", "[", 
            RowBox[{
             RowBox[{"Range", "[", 
              RowBox[{"n", "-", "1"}], "]"}], ",", 
             RowBox[{"n", "+", "1"}]}], "]"}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"xAct`xPerm`Private`ToSign", "[", 
          RowBox[{
           RowBox[{"Search", "[", 
            RowBox[{"completesymmetricSGS", ",", "HasSym", ",", "1", ",", 
             RowBox[{"StrongGenSet", "[", 
              RowBox[{
               RowBox[{"{", "}"}], ",", 
               RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", "n"}], 
          "]"}], ",", "frees"}], "}"}]}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[428]:=",ExpressionUUID->"4d509e2f-69d6-450e-9c5c-74fedf2f3bed"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.2. MakeCompareRule", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.4799310238962*^9, 3.4799310278942003`*^9}, {
   3.584881422222845*^9, 3.584881423002846*^9}, 
   3.5848826798512535`*^9},ExpressionUUID->"12f1d122-1ba6-45d7-8bad-\
e64a0f5bacb2"],

Cell["\<\
MakeCompare rule is an alternative to MakeRule. Instead of generating all \
symmetry equivalent left hand sides it makes a general rule that decides at \
application time if the expression can be rewritten as the left hand side of \
the rule.
The comparison is made with a modified version of EqualExpressionsQ. \
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.5390807230609865`*^9, 3.5390807282932863`*^9}, {
  3.575637916004838*^9, 3.5756379241948524`*^9}, {3.5848827001312895`*^9, 
  3.5848829219012785`*^9}},ExpressionUUID->"5e27160d-049c-4db4-9396-\
349b2f7e7d8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SpecialEqualExpressionsQ", "[", 
    RowBox[{"0", ",", "expr2_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"expr2", "===", "0"}], ",", "1", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[429]:=",ExpressionUUID->"50f3f930-3215-4d2e-bffd-d1267999fcf3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SpecialEqualExpressionsQ", "[", 
    RowBox[{"expr1_", ",", "expr2_"}], "]"}], ":=", "\n", "    ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "inds1", ",", "frees1", ",", "frees2", ",", "dummies1", ",", "dummies2",
        ",", "sortedfrees1", ",", "sortedfrees2", ",", " ", "sortrule1", ",", 
       "dummies1slots", ",", " ", "frees1slots", ",", "slotrules1", ",", " ", 
       "expr1SGS", ",", " ", "stabilizerSGS", ",", " ", "compatiblesymfrees1",
        ",", " ", "transversal1", ",", " ", "indstoslotnumbers", ",", 
       "freesym1", ",", "perms1", ",", "arrexpr2", ",", "newexpr2", ",", "\n",
        "        ", "count", ",", 
       RowBox[{"result", "=", "False"}], ",", 
       RowBox[{"perm", "=", 
        RowBox[{"{", "}"}]}], ",", "xxx", ",", "equation", ",", 
       RowBox[{"solution", "=", "0"}]}], "}"}], ",", "\n", "      ", 
     RowBox[{"(*", " ", 
      RowBox[{"Indices", " ", "of", " ", "expr1"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<SpecialEqualExpressionsQ[\>\"", ",", "expr1", ",", "\"\<,\>\"", 
         ",", "expr2", ",", "\"\<]\>\""}], "]"}], ";"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"inds1", "=", 
       RowBox[{"FindIndices", "[", "expr1", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dummies1", "=", 
       RowBox[{"List", "@@", 
        RowBox[{"xAct`xTensor`Private`TakeEPairs", "@", "inds1"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"frees1", "=", 
       RowBox[{"List", "@@", 
        RowBox[{"xAct`xTensor`Private`TakeFrees", "@", "inds1"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Indices", " ", "of", " ", "expr2"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"frees2", ",", "dummies2"}], "}"}], "=", 
       RowBox[{"List", "@@", 
        RowBox[{
        "xAct`xTensor`Private`FindFreeAndDummyIndices", "[", "expr2", 
         "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sortedfrees2", "=", 
       RowBox[{"List", "@@", 
        RowBox[{"(", 
         RowBox[{"Last", "/@", 
          RowBox[{"Sort", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"VBundleOfIndex", "[", "#", "]"}], ",", "#"}], "}"}], 
             "&"}], "/@", 
            RowBox[{"IndexSort", "[", "frees2", "]"}]}], "]"}]}], ")"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"sortedfrees1", "=", 
       RowBox[{"List", "@@", 
        RowBox[{"(", 
         RowBox[{"Last", "/@", 
          RowBox[{"Sort", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"VBundleOfIndex", "[", "#", "]"}], ",", "#"}], "}"}], 
             "&"}], "/@", 
            RowBox[{"IndexSort", "[", "frees1", "]"}]}], "]"}]}], ")"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "frees1", "]"}], "==", 
           RowBox[{"Length", "[", "frees2", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"VBundleOfIndex", "/@", "sortedfrees1"}], ")"}], "===", 
           RowBox[{"(", 
            RowBox[{"VBundleOfIndex", "/@", "sortedfrees2"}], ")"}]}]}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"dummies2", "=", 
          RowBox[{"List", "@@", "dummies2"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"inds1", "=", 
          RowBox[{"List", "@@", "inds1"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"slotrules1", ",", "expr1SGS"}], "}"}], "=", 
          RowBox[{"List", "@@", 
           RowBox[{"Take", "[", 
            RowBox[{
             RowBox[{"SymmetryOf", "@", "expr1"}], ",", 
             RowBox[{"-", "2"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"indstoslotnumbers", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Reverse", "/@", "slotrules1"}], ")"}], "/.", 
           RowBox[{
            RowBox[{"xAct`xTensor`Private`slot", "[", "x_", "]"}], "\[Rule]", 
            "x"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"sortrule1", "=", 
          RowBox[{"Thread", "@", 
           RowBox[{"Rule", "[", 
            RowBox[{
             RowBox[{"Range", "@", 
              RowBox[{"Length", "@", "frees1"}]}], ",", 
             RowBox[{"sortedfrees1", "/.", "indstoslotnumbers"}]}], "]"}]}]}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"dummies1slots", "=", 
          RowBox[{"dummies1", "/.", "indstoslotnumbers"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"frees1slots", "=", 
          RowBox[{"frees1", "/.", "indstoslotnumbers"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xAct`xTensor`Private`checkChangeFreeIndices", "[", 
          RowBox[{"sortedfrees1", ",", "sortedfrees2"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Computing", " ", "permutations", " ", "of", " ", "the", " ", 
           "free", " ", "indices", " ", "of", " ", "expr1"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"One", " ", "could", " ", "use", " ", "perms1"}], "=", 
            RowBox[{"Permutations", "[", 
             RowBox[{"List", "@@", "frees1"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", "  ", 
           RowBox[{
           "but", " ", "this", " ", "can", " ", "be", " ", "reduced", " ", 
            "by", " ", "considering", " ", "the", " ", "symmetries", " ", 
            "of", " ", "the", " ", "free", " ", "indices", " ", "of", " ", 
            "expr1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "The", " ", "stabilizer", " ", "of", " ", "the", " ", "dummies", 
           " ", "for", " ", "the", " ", "symmetry", " ", "of", " ", "expr1", 
           " ", "gives", " ", "a", " ", "subset", " ", "of", " ", "the", " ", 
           "symmetry", " ", "on", " ", 
           RowBox[{"dummies1", ".", " ", "\[IndentingNewLine]", "The"}], " ", 
           "numbers", " ", "in", " ", "the", " ", "group", " ", "correspond", 
           " ", "to", " ", "the", " ", "position", " ", "of", " ", "the", " ",
            "index", " ", "in", " ", 
           RowBox[{"frees1", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"stabilizerSGS", "=", 
          RowBox[{
           RowBox[{"StabilizerSGS", "[", 
            RowBox[{"dummies1slots", ",", "expr1SGS"}], "]"}], "/.", 
           RowBox[{"Reverse", "/@", "sortrule1"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"compatiblesymfrees1", "=", 
          RowBox[{"CompatibleSymmetric", "[", 
           RowBox[{"IndexList", "@@", "sortedfrees1"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "If", " ", "the", " ", "stabilizer", " ", "is", " ", "trivial"}], 
           ",", " ", 
           RowBox[{"we", " ", "will", " ", "have", " ", "all", " ", 
            RowBox[{"permutations", "."}]}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"stabilizerSGS", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "===", 
            RowBox[{"GenSet", "[", "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"transversal1", " ", "=", 
            RowBox[{"List", "@@", 
             RowBox[{"Dimino", "@", "compatiblesymfrees1"}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{
            "The", " ", "code", " ", "for", " ", "the", " ", "transversal", 
             " ", "is", " ", "probably", " ", "not", " ", 
             RowBox[{"optimal", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transversal1", " ", "=", 
             RowBox[{"TransversalInCompatibleSymmGroup", "[", 
              RowBox[{"stabilizerSGS", ",", "compatiblesymfrees1"}], "]"}]}], 
            ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Translate", " ", "this", " ", "to", " ", "permutations", " ", "of",
            " ", "the", " ", "same", " ", "kind", " ", "as", " ", 
           RowBox[{"Permutations", "[", 
            RowBox[{"List", "@@", "frees1"}], "]"}], " ", 
           RowBox[{"gives", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"perms1", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"TranslatePerm", "[", 
             RowBox[{"transversal1", ",", 
              RowBox[{"{", 
               RowBox[{"Perm", ",", 
                RowBox[{"Length", "@", "frees1"}]}], "}"}]}], "]"}], "/.", 
            RowBox[{
             RowBox[{"Perm", "[", 
              RowBox[{"{", "x___", "}"}], "]"}], "\[Rule]", 
             RowBox[{"{", "x", "}"}]}]}], "/.", 
           RowBox[{"Thread", "@", 
            RowBox[{"Rule", "[", 
             RowBox[{
              RowBox[{"Range", "@", 
               RowBox[{"Length", "@", "frees1"}]}], ",", "sortedfrees1"}], 
             "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Remove", " ", "collisions", " ", "between", " ", "frees1", " ", 
           "and", " ", "dummies2"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"arrexpr2", "=", 
          RowBox[{"xAct`xTensor`Private`arrangedummies", "[", 
           RowBox[{"expr2", ",", "dummies2", ",", "frees1"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"DefConstantSymbol", "[", 
          RowBox[{"xxx", ",", 
           RowBox[{"DefInfo", "->", "False"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"newexpr2", "=", 
             RowBox[{"xAct`xTensor`Private`changeFreeIndices", "[", 
              RowBox[{"arrexpr2", ",", "sortedfrees2", ",", 
               RowBox[{"perms1", "[", 
                RowBox[{"[", "count", "]"}], "]"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"equation", "=", 
             RowBox[{"ToCanonical", "[", 
              RowBox[{"expr1", "-", 
               RowBox[{"xxx", " ", "newexpr2"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"solution", "=", 
             RowBox[{"First", "[", 
              RowBox[{"xxx", "/.", 
               RowBox[{"Solve", "[", 
                RowBox[{
                 RowBox[{"equation", "==", "0"}], ",", "xxx"}], "]"}]}], 
              "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"ConstantQ", "[", "solution", "]"}], ",", 
              RowBox[{
               RowBox[{"result", "=", "True"}], ";", "\[IndentingNewLine]", 
               RowBox[{"perm", "=", 
                RowBox[{"Inner", "[", 
                 RowBox[{"Rule", ",", 
                  RowBox[{"perms1", "[", 
                   RowBox[{"[", "count", "]"}], "]"}], ",", "sortedfrees2", 
                  ",", "List"}], "]"}]}], ";", 
               RowBox[{"Break", "[", "]"}]}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"count", ",", 
             RowBox[{"Length", "[", "perms1", "]"}]}], "}"}]}], "]"}]}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"result", ",", "solution", ",", "sortedfrees2", ",", "perm"}], 
       "}"}]}]}], "\n", "      ", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4778523766275997`*^9, 3.4778524090912*^9}, {
   3.4778525577436*^9, 3.4778525831247993`*^9}, {3.477852688066*^9, 
   3.4778527021996*^9}, {3.4778534739316*^9, 3.4778534746804*^9}, {
   3.4778539995112*^9, 3.4778540062816*^9}, {3.47785449556*^9, 
   3.4778545718596*^9}, {3.477854657737601*^9, 3.4778546814652*^9}, {
   3.4778548981024*^9, 3.477854898898*^9}, {3.4778550572536*^9, 
   3.4778550626824*^9}, {3.4778551012455993`*^9, 3.4778551111204*^9}, {
   3.4778566536328*^9, 3.4778567063452*^9}, {3.4778567480752*^9, 
   3.477856783534*^9}, {3.478266417537651*^9, 3.478266472855251*^9}, {
   3.4782665529144506`*^9, 3.478266636936051*^9}, {3.4783460694542*^9, 
   3.4783461846446*^9}, {3.478346299835*^9, 3.4783463306762*^9}, {
   3.4794531214326*^9, 3.479453172039*^9}, {3.479625803492678*^9, 
   3.479625814594678*^9}, {3.4796258910776787`*^9, 3.479625893741678*^9}, {
   3.479625931075678*^9, 3.4796259562346783`*^9}, {3.479626000775678*^9, 
   3.4796261001416783`*^9}, {3.4796261444266787`*^9, 3.479626147677678*^9}, {
   3.4796263816276784`*^9, 3.4796263979476786`*^9}, {3.4796269415216784`*^9, 
   3.4796269726456785`*^9}, {3.479627010191678*^9, 3.4796270495706787`*^9}, {
   3.4796271183386784`*^9, 3.4796271381146784`*^9}, {3.4796272205806785`*^9, 
   3.479627248282679*^9}, {3.4796278897576785`*^9, 3.479627994523678*^9}, {
   3.4796281329126787`*^9, 3.479628186990678*^9}, {3.4796282361276784`*^9, 
   3.479628327555678*^9}, {3.4796284947706776`*^9, 3.479628544090678*^9}, {
   3.4796285928226786`*^9, 3.479628652373678*^9}, {3.479628782387678*^9, 
   3.4796287865756783`*^9}, {3.4796294382526784`*^9, 3.479629529840678*^9}, {
   3.4796295628306785`*^9, 3.4796296517526784`*^9}, {3.4796303776946783`*^9, 
   3.479630430500678*^9}, {3.479630476013678*^9, 3.479630503664678*^9}, {
   3.4796308047466784`*^9, 3.4796309207676783`*^9}, 3.4796309695216784`*^9, {
   3.4796310713496785`*^9, 3.4796311080086784`*^9}, {3.479631649286679*^9, 
   3.479631668872679*^9}, {3.479631933350678*^9, 3.479631961243678*^9}, {
   3.479632131474678*^9, 3.479632142229678*^9}, {3.479632172443678*^9, 
   3.479632233432678*^9}, {3.479633148735679*^9, 3.4796331512046785`*^9}, {
   3.4796331979366784`*^9, 3.4796332009436784`*^9}, {3.479633234098678*^9, 
   3.479633282283678*^9}, {3.479633330503678*^9, 3.4796335023236785`*^9}, {
   3.479633541367679*^9, 3.479633549820679*^9}, {3.479635201077679*^9, 
   3.4796352279366784`*^9}, {3.479635295414678*^9, 3.4796353076926785`*^9}, {
   3.479635421482678*^9, 3.479635430404678*^9}, {3.479635464359678*^9, 
   3.4796354681696787`*^9}, {3.4796355011766787`*^9, 3.479635534597678*^9}, {
   3.4796507990116787`*^9, 3.4796508497466784`*^9}, {3.4796509914886775`*^9, 
   3.4796510373516784`*^9}, {3.4796511712406783`*^9, 3.479651311943678*^9}, {
   3.4796513490116787`*^9, 3.4796513558396783`*^9}, {3.479667020313649*^9, 
   3.479667075435649*^9}, {3.479667128593649*^9, 3.479667128999649*^9}, 
   3.563707717284831*^9, {3.563707996125752*^9, 3.56370800637497*^9}, {
   3.569587472140392*^9, 3.569587497303236*^9}, {3.5695876852055655`*^9, 
   3.569587708028406*^9}, {3.5695878210350046`*^9, 3.569587832922225*^9}, 
   3.569587912295165*^9, {3.569588461183129*^9, 3.56958848473917*^9}, {
   3.569588714589974*^9, 3.569588726539595*^9}, {3.569588906361111*^9, 
   3.569588907936714*^9}, {3.569588951133189*^9, 3.5695889739404297`*^9}, 
   3.5756379115588303`*^9, {3.575966330806411*^9, 3.5759663714756823`*^9}, 
   3.584882004463667*^9, {3.6196890666062994`*^9, 3.619689067356301*^9}},
 CellLabel->
  "In[430]:=",ExpressionUUID->"4dc52a8e-ffca-44c5-bf12-71a3e8c0344e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"SpecialEqualExpressionsQ", ",", "2"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "SpecialEqualExpressionsQ", "]"}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.4778540211484003`*^9, 3.4778540305396*^9}},
 CellLabel->
  "In[431]:=",ExpressionUUID->"e2f30a8e-5315-4421-954e-aa6efccf1b23"],

Cell["\<\
Make a rule that looks for a tensors and replaces it with a properly \
reformulated RHS, if tensora[indsa] is equal to tensora[indsaeq].
The expressions are compared with SpecialEqualExpressionsQ \
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.4779031068508*^9, 3.4779031540252*^9}, {
  3.4779031975179996`*^9, 3.4779032245216*^9}, {3.4779032552536*^9, 
  3.4779033096352*^9}, {3.4796671884246483`*^9, 
  3.479667247786649*^9}},ExpressionUUID->"111e706d-70e2-4ab6-942c-\
98beae215a3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"MakeCompareRule", ",", "HoldFirst"}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4796516186816783`*^9, 3.479651620260678*^9}},
 CellLabel->
  "In[433]:=",ExpressionUUID->"2b571219-b1db-4216-893d-37efb231c3ec"],

Cell["For a single tensor:", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.479666824264649*^9, 
  3.479666837029649*^9}},ExpressionUUID->"99057f4a-0f74-47c7-8c2e-\
6c06770799e1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeCompareRule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"tensora_", "?", "xTensorQ"}], "[", "indsaeq___", "]"}], ",", 
       "RHS_"}], "}"}], ",", "___"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dummieseq", "=", 
       RowBox[{"xAct`xTensor`Private`TakeEPairs", "[", 
        RowBox[{"{", "indsaeq", "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"numdummiesaeq", "=", 
         RowBox[{"Length", "@", 
          RowBox[{"Intersection", "[", 
           RowBox[{"dummieseq", ",", 
            RowBox[{"{", "indsaeq", "}"}]}], "]"}]}]}], "}"}], ",", 
       RowBox[{"RuleDelayed", "[", 
        RowBox[{
         RowBox[{"HoldPattern", "@", 
          RowBox[{"tensora", "[", "indsa___", "]"}]}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"dummies", "=", 
              RowBox[{"xAct`xTensor`Private`TakeEPairs", "[", 
               RowBox[{"{", "indsa", "}"}], "]"}]}], ",", 
             RowBox[{"frees", "=", 
              RowBox[{"xAct`xTensor`Private`TakeFrees", "[", 
               RowBox[{"{", "indsa", "}"}], "]"}]}]}], "}"}], ",", 
           RowBox[{
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
               "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}], 
               "}"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}], 
                 "}"}], "=", 
                RowBox[{"SpecialEqualExpressionsQ", "[", 
                 RowBox[{
                  RowBox[{"tensora", "[", "indsaeq", "]"}], ",", 
                  RowBox[{"tensora", "[", "indsa", "]"}]}], "]"}]}], ";", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"arrexpr2", "=", 
                    RowBox[{"ReplaceDummies", "[", "RHS", "]"}]}], "}"}], ",", 
                  RowBox[{"ReplaceIndex", "[", 
                   RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"sign", "*", "arrexpr2"}], "]"}], ",", "perm"}], 
                   "]"}]}], "]"}], "/;", "equalexpr"}]}]}], "]"}], "/;", 
            RowBox[{
             RowBox[{"Length", "@", 
              RowBox[{"Intersection", "[", 
               RowBox[{"dummies", ",", 
                RowBox[{"{", "indsa", "}"}]}], "]"}]}], "\[Equal]", 
             "numdummiesaeq"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.477898316278*^9, 3.477898327198*^9}, {
   3.4778986712404003`*^9, 3.4778987796604*^9}, {3.4778993062539997`*^9, 
   3.4778994190108*^9}, {3.4778994584007998`*^9, 3.4778995038124*^9}, {
   3.477899557616801*^9, 3.477899661622*^9}, {3.4778997069088*^9, 
   3.4778998591336*^9}, {3.4778999043424*^9, 3.4778999073376*^9}, {
   3.4778999388028*^9, 3.4778999704084*^9}, {3.4779000211708*^9, 
   3.4779000854896*^9}, {3.4779002015848*^9, 3.4779002082772*^9}, {
   3.4779002454676*^9, 3.477900261800801*^9}, {3.4779008961748*^9, 
   3.477900923506*^9}, {3.4779014575252*^9, 3.4779016056004*^9}, {
   3.4779017051596007`*^9, 3.4779017060488*^9}, {3.4779017948908*^9, 
   3.4779017957176*^9}, {3.4779021568108*^9, 3.4779021937827992`*^9}, {
   3.4779022396624*^9, 3.4779022426108*^9}, {3.4779023264296*^9, 
   3.4779025687912*^9}, {3.4779026403172*^9, 3.4779026429692*^9}, {
   3.4779026902216*^9, 3.4779027103456*^9}, {3.4779027524656*^9, 
   3.477902768362*^9}, 3.4779028675312*^9, {3.4779029384175997`*^9, 
   3.477902940664*^9}, {3.4779029743912*^9, 3.4779029751556*^9}, {
   3.477903011956001*^9, 3.477903032938*^9}, {3.4784187972802*^9, 
   3.4784188955134*^9}, 3.4796392867426786`*^9, 3.479639432282678*^9, {
   3.479651667066678*^9, 3.479651674401678*^9}, {3.494057229026*^9, 
   3.4940572296812*^9}, {3.494057360549599*^9, 3.4940573615948*^9}, {
   3.4940574879392*^9, 3.4940575162376003`*^9}, 3.5393403728936176`*^9, {
   3.53934057928198*^9, 3.539340588657597*^9}, {3.5393408153103943`*^9, 
   3.539340819694002*^9}, {3.5393520619221487`*^9, 3.539352065307355*^9}, {
   3.5481380877109966`*^9, 3.5481380960258102`*^9}, {3.548141598780963*^9, 
   3.548141603804171*^9}},
 CellLabel->
  "In[434]:=",ExpressionUUID->"cc522904-d328-4768-bc21-35e72fc1d58b"],

Cell["A similar thing for a product of tensors:", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.479666824264649*^9, 3.4796668555906487`*^9}, {
  3.479667280421649*^9, 
  3.479667296777649*^9}},ExpressionUUID->"a2209cf9-deff-450c-bd9d-\
0e27c8de6419"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeCompareRule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"LHS", ":", 
        RowBox[{"Times", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}], "..."}]}], 
         "]"}]}], ",", "RHS_"}], "}"}], ",", "___"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"indslist", "=", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<tinds\>\"", ",", 
            RowBox[{"ToString", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"Length", "@", "LHS"}], "]"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rulelhs", "=", 
          RowBox[{"MapIndexed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "0", "]"}], "]"}], "[", 
              RowBox[{"First", "@", 
               RowBox[{"indslist", "[", 
                RowBox[{"[", "#2", "]"}], "]"}]}], "]"}], "&"}], ",", "LHS"}],
            "]"}]}], ",", 
         RowBox[{"rulelhspattern", "=", 
          RowBox[{"MapIndexed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "0", "]"}], "]"}], "[", 
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"patterninds", "=", 
                  RowBox[{"First", "@", 
                   RowBox[{"indslist", "[", 
                    RowBox[{"[", "#2", "]"}], "]"}]}]}], "}"}], ",", 
                RowBox[{"Pattern", "[", 
                 RowBox[{"patterninds", ",", 
                  RowBox[{"BlankNullSequence", "[", "]"}]}], "]"}]}], "]"}], 
              "]"}], "&"}], ",", "LHS"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"RuleDelayed", "[", 
        RowBox[{
         RowBox[{"HoldPattern", "@", "rulelhspattern"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"rulelhsinds", "=", 
             RowBox[{"FindIndices", "[", "rulelhs", "]"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"dummieslhs", "=", 
                RowBox[{
                "xAct`xTensor`Private`TakeEPairs", "[", "rulelhsinds", 
                 "]"}]}], ",", 
               RowBox[{"freeslhs", "=", 
                RowBox[{
                "xAct`xTensor`Private`TakeFrees", "[", "rulelhsinds", 
                 "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}], 
                "}"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                  "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}],
                   "}"}], "=", 
                 RowBox[{"SpecialEqualExpressionsQ", "[", 
                  RowBox[{"LHS", ",", "rulelhs"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"Module", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"arrexpr2", "=", 
                    RowBox[{"ReplaceDummies", "[", "RHS", "]"}]}], "}"}], ",", 
                   RowBox[{"ReplaceIndex", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"sign", "*", "arrexpr2"}], "]"}], ",", "perm"}], 
                    "]"}]}], "]"}], "/;", "equalexpr"}]}]}], "]"}]}], "]"}]}],
           "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.479639459399678*^9, 3.479639477548678*^9}, {
   3.4796395622786784`*^9, 3.479639609756678*^9}, {3.479639640566678*^9, 
   3.479639642570679*^9}, {3.4796397046676784`*^9, 3.4796397334426785`*^9}, {
   3.4796399463206787`*^9, 3.479639948816678*^9}, {3.479640026357678*^9, 
   3.479640030920678*^9}, {3.479640236549678*^9, 3.4796402405546784`*^9}, {
   3.479640275553678*^9, 3.4796402767606783`*^9}, {3.479640386355678*^9, 
   3.4796403874336777`*^9}, {3.479640443578678*^9, 3.479640509423678*^9}, {
   3.479640553680678*^9, 3.479640554624678*^9}, 3.479640586557678*^9, {
   3.479640618290678*^9, 3.4796406350916777`*^9}, {3.479640676324678*^9, 
   3.4796406774376783`*^9}, {3.479640942316678*^9, 3.479641003199678*^9}, {
   3.479641482880678*^9, 3.479641540366678*^9}, {3.479641580329678*^9, 
   3.479641690175678*^9}, {3.479642300282678*^9, 3.479642395952678*^9}, {
   3.479642437604678*^9, 3.479642470470678*^9}, {3.4796425334426775`*^9, 
   3.4796425432386775`*^9}, {3.4796425836386776`*^9, 3.479642633566678*^9}, {
   3.479642675467678*^9, 3.479642721821678*^9}, {3.479642777344678*^9, 
   3.479642790068678*^9}, {3.479642829222678*^9, 3.479642830248678*^9}, {
   3.479642876807678*^9, 3.479642884011678*^9}, {3.479644829261678*^9, 
   3.479644893652678*^9}, {3.479644992573678*^9, 3.4796450998036776`*^9}, {
   3.4796451331016774`*^9, 3.4796451804296775`*^9}, {3.4796466360406775`*^9, 
   3.4796467253526783`*^9}, {3.4796467701416783`*^9, 3.479646841090678*^9}, 
   3.479646919939678*^9, {3.4796469510586777`*^9, 3.479647023756678*^9}, {
   3.4796470580496783`*^9, 3.479647122740678*^9}, {3.479647202592678*^9, 
   3.4796472059856787`*^9}, {3.4796472456096783`*^9, 
   3.4796472888586783`*^9}, {3.4796473288376784`*^9, 3.479647366308678*^9}, 
   3.4796474007496777`*^9, {3.479647438672678*^9, 3.479647583869678*^9}, {
   3.479647654398678*^9, 3.479647671049678*^9}, {3.479647708347678*^9, 
   3.479647812144678*^9}, {3.4796478474696784`*^9, 3.479648112371678*^9}, {
   3.479648145870678*^9, 3.4796482095886774`*^9}, {3.479648240408678*^9, 
   3.4796484045296774`*^9}, {3.479648477945678*^9, 3.4796485746226783`*^9}, {
   3.4796486086026783`*^9, 3.4796487130496774`*^9}, {3.4796487544336777`*^9, 
   3.479648754949678*^9}, {3.479648792898678*^9, 3.4796488153956776`*^9}, {
   3.479648905962678*^9, 3.4796489208696775`*^9}, {3.4796490239596777`*^9, 
   3.479649025321678*^9}, {3.479649075453678*^9, 3.479649100924678*^9}, {
   3.4796492199526787`*^9, 3.479649223620678*^9}, {3.4796492809626784`*^9, 
   3.479649406812678*^9}, {3.479649859389678*^9, 3.479649873186678*^9}, {
   3.4796499695346775`*^9, 3.4796499741336775`*^9}, {3.479650208997679*^9, 
   3.479650214157678*^9}, {3.479651679450678*^9, 3.4796516872776785`*^9}, {
   3.4940572335344*^9, 3.4940572341584*^9}, {3.4940573656664*^9, 
   3.4940573665088*^9}, {3.4940575333196*^9, 3.4940575493564*^9}, 
   3.539340370709614*^9, {3.5393520698469625`*^9, 3.539352072327367*^9}, {
   3.5481381101750355`*^9, 3.548138118973451*^9}, {3.5481416110737844`*^9, 
   3.548141615457392*^9}},
 CellLabel->
  "In[435]:=",ExpressionUUID->"8d0878f4-5b7f-46a9-8b29-991731ff8f1c"],

Cell["For a derivative of a single tensor:", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.479666824264649*^9, 3.479666837029649*^9}, {
  3.5393397136520596`*^9, 
  3.539339723199276*^9}},ExpressionUUID->"8d2a34e7-c780-4e23-bb0f-\
c1e862a4affc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeCompareRule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"covd_", "?", "CovDQ"}], "[", "indscdeq___", "]"}], "[", 
        RowBox[{
         RowBox[{"tensora_", "?", "xTensorQ"}], "[", "indsaeq___", "]"}], 
        "]"}], ",", "RHS_"}], "}"}], ",", "___"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dummieseq", "=", 
       RowBox[{"xAct`xTensor`Private`TakeEPairs", "[", 
        RowBox[{"{", 
         RowBox[{"indscdeq", ",", "indsaeq"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"numdummiesaeq", "=", 
         RowBox[{"Length", "@", 
          RowBox[{"Intersection", "[", 
           RowBox[{"dummieseq", ",", 
            RowBox[{"{", 
             RowBox[{"indscdeq", ",", "indsaeq"}], "}"}]}], "]"}]}]}], "}"}], 
       ",", 
       RowBox[{"RuleDelayed", "[", 
        RowBox[{
         RowBox[{"HoldPattern", "@", 
          RowBox[{
           RowBox[{"covd", "[", "indscd___", "]"}], "[", 
           RowBox[{"tensora", "[", "indsa___", "]"}], "]"}]}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"dummies", "=", 
              RowBox[{"xAct`xTensor`Private`TakeEPairs", "[", 
               RowBox[{"{", 
                RowBox[{"indscd", ",", "indsa"}], "}"}], "]"}]}], ",", 
             RowBox[{"frees", "=", 
              RowBox[{"xAct`xTensor`Private`TakeFrees", "[", 
               RowBox[{"{", 
                RowBox[{"indscd", ",", "indsa"}], "}"}], "]"}]}]}], "}"}], 
           ",", 
           RowBox[{
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
               "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}], 
               "}"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}], 
                 "}"}], "=", 
                RowBox[{"SpecialEqualExpressionsQ", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"covd", "[", "indscdeq", "]"}], "[", 
                   RowBox[{"tensora", "[", "indsaeq", "]"}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"covd", "[", "indscd", "]"}], "[", 
                   RowBox[{"tensora", "[", "indsa", "]"}], "]"}]}], "]"}]}], 
               ";", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"arrexpr2", "=", 
                    RowBox[{"ReplaceDummies", "[", "RHS", "]"}]}], "}"}], ",", 
                  RowBox[{"ReplaceIndex", "[", 
                   RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"sign", "*", "arrexpr2"}], "]"}], ",", "perm"}], 
                   "]"}]}], "]"}], "/;", "equalexpr"}]}]}], "]"}], "/;", 
            RowBox[{
             RowBox[{"Length", "@", 
              RowBox[{"Intersection", "[", 
               RowBox[{"dummies", ",", 
                RowBox[{"{", 
                 RowBox[{"indscd", ",", "indsa"}], "}"}]}], "]"}]}], 
             "\[Equal]", "numdummiesaeq"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.477898316278*^9, 3.477898327198*^9}, {
   3.4778986712404003`*^9, 3.4778987796604*^9}, {3.4778993062539997`*^9, 
   3.4778994190108*^9}, {3.4778994584007998`*^9, 3.4778995038124*^9}, {
   3.477899557616801*^9, 3.477899661622*^9}, {3.4778997069088*^9, 
   3.4778998591336*^9}, {3.4778999043424*^9, 3.4778999073376*^9}, {
   3.4778999388028*^9, 3.4778999704084*^9}, {3.4779000211708*^9, 
   3.4779000854896*^9}, {3.4779002015848*^9, 3.4779002082772*^9}, {
   3.4779002454676*^9, 3.477900261800801*^9}, {3.4779008961748*^9, 
   3.477900923506*^9}, {3.4779014575252*^9, 3.4779016056004*^9}, {
   3.4779017051596007`*^9, 3.4779017060488*^9}, {3.4779017948908*^9, 
   3.4779017957176*^9}, {3.4779021568108*^9, 3.4779021937827992`*^9}, {
   3.4779022396624*^9, 3.4779022426108*^9}, {3.4779023264296*^9, 
   3.4779025687912*^9}, {3.4779026403172*^9, 3.4779026429692*^9}, {
   3.4779026902216*^9, 3.4779027103456*^9}, {3.4779027524656*^9, 
   3.477902768362*^9}, 3.4779028675312*^9, {3.4779029384175997`*^9, 
   3.477902940664*^9}, {3.4779029743912*^9, 3.4779029751556*^9}, {
   3.477903011956001*^9, 3.477903032938*^9}, {3.4784187972802*^9, 
   3.4784188955134*^9}, 3.4796392867426786`*^9, 3.479639432282678*^9, {
   3.479651667066678*^9, 3.479651674401678*^9}, {3.494057229026*^9, 
   3.4940572296812*^9}, {3.494057360549599*^9, 3.4940573615948*^9}, {
   3.4940574879392*^9, 3.4940575162376003`*^9}, {3.5393397574257374`*^9, 
   3.539339779811776*^9}, {3.5393398361902747`*^9, 3.539339843054287*^9}, {
   3.539340070253086*^9, 3.53934016942246*^9}, {3.5393402198105483`*^9, 
   3.539340273708643*^9}, {3.539340361084397*^9, 3.539340367964009*^9}, {
   3.539352076960575*^9, 3.5393520798309803`*^9}, {3.548138124714261*^9, 
   3.548138132467475*^9}, {3.548141621198202*^9, 3.54814162555061*^9}},
 CellLabel->
  "In[436]:=",ExpressionUUID->"7e0705b3-238c-4da0-9c40-294311bca169"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3. Giving indices to tensors", "Subsubsection",
 CellChangeTimes->{{3.590213340073481*^9, 3.590213364010851*^9}, {
  3.590318245592237*^9, 
  3.5903182467154393`*^9}},ExpressionUUID->"f94185ef-af5b-4c4b-aeb7-\
9afbe9921535"],

Cell["Get a range of k indices in vbundle.", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.59014921237811*^9, 3.5901492206149244`*^9}, {
  3.590152439650378*^9, 
  3.590152486700061*^9}},ExpressionUUID->"c6834929-2775-4f99-b973-\
f3ad4bc58b42"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GetIndexRange", "[", 
   RowBox[{"k_", ",", "vbundle_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", "=", 
      RowBox[{"Length", "@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"IndicesOfVBundle", "[", "vbundle", "]"}], "]"}]}]}], "}"}], 
    ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"NewIndexIn", "[", "vbundle", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"k", "-", "n"}], "]"}]}], ";", 
     RowBox[{"Take", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"IndicesOfVBundle", "[", "vbundle", "]"}], "]"}], ",", "k"}], 
      "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[437]:=",ExpressionUUID->"26b38a13-452d-41a7-a76d-82bf8e787b67"],

Cell["\<\
Give indices to a tensor. The second argument is a list of vbundles which \
should have up indices. The default is down indices for all vbundles.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.5902132358475204`*^9, 
  3.590213321264406*^9}},ExpressionUUID->"a2d5892e-1ee5-4e8b-9b23-\
df77353329c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GiveIndicesToTensor", "[", 
   RowBox[{
    RowBox[{"TT_", "?", "xTensorQ"}], ",", 
    RowBox[{"upvbundles_", ":", 
     RowBox[{"{", "}"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "@", 
        RowBox[{"SlotsOfTensor", "@", "TT"}]}]}], ",", 
      RowBox[{"vbundles", "=", 
       RowBox[{"UpIndex", "/@", 
        RowBox[{"SlotsOfTensor", "@", "TT"}]}]}], ",", "gatheredslots", ",", 
      "inds", ",", "slotrules"}], "}"}], ",", 
    RowBox[{
     RowBox[{"gatheredslots", "=", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Range", "@", "n"}], ",", 
        RowBox[{
         RowBox[{"vbundles", "[", 
          RowBox[{"[", "#", "]"}], "]"}], "&"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"inds", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"GetIndexRange", "@@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Length", "@", "#"}], ",", 
             RowBox[{"vbundles", "[", 
              RowBox[{"[", 
               RowBox[{"First", "@", "#"}], "]"}], "]"}]}], "}"}], "&"}], "/@",
           "gatheredslots"}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"inds", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"upvbundles", ",", 
            RowBox[{"VBundleOfIndex", "[", "#", "]"}]}], "]"}], ",", "#", ",", 
          RowBox[{"DownIndex", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
       "inds"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"slotrules", "=", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{
         RowBox[{"Flatten", "@", "gatheredslots"}], ",", "inds"}], "]"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"TT", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Range", "@", "n"}], "/.", "slotrules"}], ")"}]}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590213816729745*^9, 3.590213822113053*^9}},
 CellLabel->
  "In[438]:=",ExpressionUUID->"b8c1d964-32c2-441b-84b2-d3ceed83efcd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ChangeFreeIndicesToDefault", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"upvbundles_", ":", 
      RowBox[{"{", "}"}]}]}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"freeinds", "=", 
       RowBox[{"List", "@@", 
        RowBox[{"FindFreeIndices", "@", 
         RowBox[{"Evaluate", "[", "expr", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "=", 
          RowBox[{"Length", "@", "freeinds"}]}], ",", 
         RowBox[{"vbundles", "=", 
          RowBox[{"UpIndex", "/@", 
           RowBox[{"VBundleOfIndex", "/@", "freeinds"}]}]}], ",", 
         "gatheredslots", ",", "inds", ",", "slotrules", ",", "indsrule"}], 
        "}"}], ",", 
       RowBox[{
        RowBox[{"gatheredslots", "=", 
         RowBox[{"GatherBy", "[", 
          RowBox[{
           RowBox[{"Range", "@", "n"}], ",", 
           RowBox[{
            RowBox[{"vbundles", "[", 
             RowBox[{"[", "#", "]"}], "]"}], "&"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"inds", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"GetIndexRange", "@@@", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Length", "@", "#"}], ",", 
                RowBox[{"vbundles", "[", 
                 RowBox[{"[", 
                  RowBox[{"First", "@", "#"}], "]"}], "]"}]}], "}"}], "&"}], "/@",
              "gatheredslots"}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"inds", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{"upvbundles", ",", 
               RowBox[{"VBundleOfIndex", "[", "#", "]"}]}], "]"}], ",", "#", 
             ",", 
             RowBox[{"DownIndex", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
          "inds"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"slotrules", "=", 
         RowBox[{"Thread", "@", 
          RowBox[{"Rule", "[", 
           RowBox[{
            RowBox[{"Flatten", "@", "gatheredslots"}], ",", "inds"}], 
           "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"indsrule", "=", 
         RowBox[{"Thread", "@", 
          RowBox[{"Rule", "[", 
           RowBox[{"freeinds", ",", 
            RowBox[{
             RowBox[{"Range", "@", "n"}], "/.", "slotrules"}]}], "]"}]}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"ScreenDollarIndices", "[", 
         RowBox[{"ReplaceIndex", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"ReplaceDummies", "@", "expr"}], "]"}], ",", "indsrule"}],
           "]"}], "]"}]}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590499060127042*^9, 3.590499076497065*^9}},
 CellLabel->
  "In[439]:=",ExpressionUUID->"c96ae2c4-bd12-4a63-983c-ed222df5f0ca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceIndicesInTensor", "[", 
   RowBox[{
    RowBox[{"TT_", "?", "xTensorQ"}], ",", 
    RowBox[{"{", "inds___", "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"gatheredinds", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Prepend", "[", 
          RowBox[{"#", ",", 
           RowBox[{"(", 
            RowBox[{"VBundleOfIndex", "@", 
             RowBox[{"First", "@", "#"}]}], ")"}]}], "]"}], "&"}], "/@", 
        RowBox[{"GatherBy", "[", 
         RowBox[{
          RowBox[{"{", "inds", "}"}], ",", "VBundleOfIndex"}], "]"}]}]}], ",",
       "pos", ",", "slotrules"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pos", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"Position", "[", 
          RowBox[{
           RowBox[{"DownIndex", "@", 
            RowBox[{"SlotsOfTensor", "@", "TT"}]}], ",", "#", ",", "1"}], 
          "]"}], "]"}], "&"}], "/@", 
       RowBox[{"First", "/@", "gatheredinds"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Length", "/@", "pos"}], ")"}], "=!=", 
        RowBox[{"(", 
         RowBox[{"Length", "/@", 
          RowBox[{"(", 
           RowBox[{"Rest", "/@", "gatheredinds"}], ")"}]}], ")"}]}], ",", 
       RowBox[{"Throw", "[", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"General", "::", "error"}], ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<PlaceIndicesInTensor: Indices does not fit in tensor: \>\"", 
            ",", 
            RowBox[{"ToString", "@", "TT"}], ",", "\"\<, \>\"", ",", " ", 
            RowBox[{"ToString", "[", 
             RowBox[{"{", "inds", "}"}], "]"}]}], "]"}]}], "]"}], "]"}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"slotrules", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"MapThread", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Thread", "[", 
           RowBox[{"Rule", "[", 
            RowBox[{"#1", ",", "#2"}], "]"}], "]"}], "&"}], ",", 
         RowBox[{"{", 
          RowBox[{"pos", ",", 
           RowBox[{"Rest", "/@", "gatheredinds"}]}], "}"}]}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"TT", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", 
          RowBox[{"SlotsOfTensor", "[", "TT", "]"}]}]}], "/.", "slotrules"}], 
       ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.680001724332962*^9, 3.680001788712962*^9}, {
   3.680001874462962*^9, 3.680001915892962*^9}, 3.6800019622629633`*^9, {
   3.6800021620041866`*^9, 3.680002164224208*^9}, {3.6800023298658643`*^9, 
   3.6800023594061604`*^9}, {3.680002545429021*^9, 3.680002645290019*^9}, {
   3.680002676890335*^9, 3.680002699590562*^9}, {3.680002762731194*^9, 
   3.680002815871725*^9}, {3.680002847132038*^9, 3.68000290535978*^9}, {
   3.6800030625262012`*^9, 3.680003072894646*^9}, {3.68000339120726*^9, 
   3.680003592221396*^9}, {3.680003622941089*^9, 3.6800036249310684`*^9}, 
   3.685192650584923*^9},
 CellLabel->
  "In[440]:=",ExpressionUUID->"215a7957-580f-462d-9f91-8a9d1467e272"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceIndicesInSpinor", "[", 
   RowBox[{
    RowBox[{"TT_", "?", "xTensorQ"}], ",", 
    RowBox[{"{", "inds___", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"spin_", ",", "spindg_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"slotsTT", "=", 
       RowBox[{"SlotsOfTensor", "@", "TT"}]}], ",", 
      RowBox[{"unprimedinds", "=", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"{", "inds", "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"VBundleOfIndex", "[", "#", "]"}], "==", "spin"}], "&"}]}],
         "]"}]}], ",", 
      RowBox[{"primedinds", "=", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"{", "inds", "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"VBundleOfIndex", "[", "#", "]"}], "==", "spindg"}], 
          "&"}]}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"unprimedpos", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"Range", "@", 
            RowBox[{"Length", "@", "slotsTT"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"UpIndex", "[", 
               RowBox[{"slotsTT", "[", 
                RowBox[{"[", "#", "]"}], "]"}], "]"}], "\[Equal]", "spin"}], 
             ")"}], "&"}]}], "]"}]}], ",", 
        RowBox[{"primedpos", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"Range", "@", 
            RowBox[{"Length", "@", "slotsTT"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"UpIndex", "[", 
               RowBox[{"slotsTT", "[", 
                RowBox[{"[", "#", "]"}], "]"}], "]"}], "\[Equal]", "spindg"}],
              ")"}], "&"}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"TT", "[", 
       RowBox[{"Sequence", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Range", "@", 
           RowBox[{"Length", "@", "slotsTT"}]}], "/.", 
          RowBox[{"Join", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{"primedpos", "\[Rule]", "primedinds"}], "]"}], ",", 
            RowBox[{"Thread", "[", 
             RowBox[{"unprimedpos", "\[Rule]", "unprimedinds"}], "]"}], ",", 
            RowBox[{"SlotRulesOtherVBs", "[", 
             RowBox[{"slotsTT", ",", 
              RowBox[{"{", "inds", "}"}], ",", "spin", ",", "spindg"}], 
             "]"}]}], "]"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.838882384699138*^9},
 CellLabel->
  "In[441]:=",ExpressionUUID->"06ae16fa-35c8-4662-888d-2e89ed0627af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlaceIndicesInSpinor", "[", 
   RowBox[{
    RowBox[{"TT_", "?", "xTensorQ"}], ",", 
    RowBox[{"{", "inds___", "}"}], ",", 
    RowBox[{"spin_", "?", "VBundleQ"}]}], "]"}], ":=", 
  RowBox[{"PlaceIndicesInSpinor", "[", 
   RowBox[{"TT", ",", 
    RowBox[{"{", "inds", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"spin", ",", 
      RowBox[{"Dagger", "@", "spin"}]}], "}"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8388823997438498`*^9, 3.8388824027859573`*^9}, {
  3.83888245401008*^9, 3.838882474127929*^9}},
 CellLabel->
  "In[442]:=",ExpressionUUID->"0acaf9e6-774b-449d-a1d6-7a2048eb5700"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.4. Valence numbers", "Subsubsection",
 CellChangeTimes->{{3.590213340073481*^9, 3.590213364010851*^9}, {
  3.590318245592237*^9, 3.5903182467154393`*^9}, {3.83880400350883*^9, 
  3.838804008181358*^9}},ExpressionUUID->"341be5aa-bd28-42fb-a98e-\
a9e38001e81a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ValenceNumbersOfSpinor", "[", 
   RowBox[{
    RowBox[{"T_", "?", "xTensorQ"}], ",", "spin_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "T", "]"}], ",", 
    RowBox[{
     RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "T", "]"}]}], 
   "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6800043911474433`*^9, 3.680004399107443*^9}, {
   3.6800044483374434`*^9, 3.680004502867442*^9}, 3.6800045809774437`*^9, {
   3.839930730594242*^9, 3.8399307452865334`*^9}, {3.923449728327553*^9, 
   3.9234497481840935`*^9}},ExpressionUUID->"64d6292c-3aa7-4166-a42d-\
7a6d2625c3e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtractUnprimedAndPrimed", "[", "spin_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Select", "[", 
      RowBox[{"#", ",", 
       RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "@", "spin"}]}], "]"}],
      ",", 
     RowBox[{"Select", "[", 
      RowBox[{"#", ",", 
       RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "@", 
        RowBox[{"Dagger", "@", "spin"}]}]}], "]"}]}], "}"}], "&"}]}]], "Input",\

 InitializationCell->True,
 CellLabel->
  "In[444]:=",ExpressionUUID->"1248d6c6-0fc7-414c-9bd8-db7956d5f106"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SymmetricOfValence", "[", 
    RowBox[{"k_", ",", "l_", ",", "spin_"}], "]"}], ":=", 
   RowBox[{"SymmetricOfValence", "[", 
    RowBox[{"k", ",", "l", ",", "spin", ",", 
     RowBox[{"{", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SymmetricOfValence", "[", 
   RowBox[{
    RowBox[{"k_", "?", "NumericQ"}], ",", 
    RowBox[{"l_", "?", "NumericQ"}], ",", "spin_", ",", "ovb_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"ovb", ",", 
     RowBox[{"ConstantArray", "[", 
      RowBox[{
       RowBox[{"-", "spin"}], ",", "k"}], "]"}], ",", 
     RowBox[{"ConstantArray", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Dagger", "@", "spin"}]}], ",", "l"}], "]"}]}], "]"}], "/;", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"k", "\[GreaterEqual]", "0"}], ",", 
     RowBox[{"l", "\[GreaterEqual]", "0"}]}], "]"}]}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7725349155867815`*^9, 3.772534917081867*^9}, {
   3.837842260926482*^9, 3.837842289810196*^9}, {3.839147887366344*^9, 
   3.8391479255188656`*^9}, 3.839149859588363*^9, {3.8391526615457134`*^9, 
   3.839152698694409*^9}, {3.8391527356526175`*^9, 3.839152893076414*^9}, 
   3.8391529303619967`*^9, {3.8391529811747456`*^9, 3.839153007788037*^9}, {
   3.8391638880910234`*^9, 3.839163914027903*^9}, {3.8391639704541607`*^9, 
   3.8391639729644594`*^9}},
 CellLabel->
  "In[445]:=",ExpressionUUID->"4ff6bc90-3ef7-4e34-bc6f-329b1426511e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExtractOtherVBundles", "[", "spin_", "]"}], "[", "vbs_List", 
   "]"}], ":=", 
  RowBox[{"DeleteCases", "[", 
   RowBox[{"vbs", ",", 
    RowBox[{"Alternatives", "[", 
     RowBox[{"spin", ",", 
      RowBox[{"-", "spin"}], ",", 
      RowBox[{"Dagger", "@", "spin"}], ",", 
      RowBox[{"-", 
       RowBox[{"Dagger", "@", "spin"}]}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.839151107636357*^9, 3.839151125580389*^9}},
 CellLabel->
  "In[447]:=",ExpressionUUID->"bd77c661-2103-42ca-97c3-30a9a90bef73"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfUnprimedVBundles", "[", "spin_", "]"}], "[", 
    RowBox[{"SymmetricOfValence", "[", 
     RowBox[{"k_", ",", "l_", ",", "spin_", ",", "ovb_"}], "]"}], "]"}], ":=",
    "k"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfPrimedVBundles", "[", "spin_", "]"}], "[", 
    RowBox[{"SymmetricOfValence", "[", 
     RowBox[{"k_", ",", "l_", ",", "spin_", ",", "ovb_"}], "]"}], "]"}], ":=",
    "l"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExtractOtherVBundles", "[", "spin_", "]"}], "[", 
    RowBox[{"SymmetricOfValence", "[", 
     RowBox[{"k_", ",", "l_", ",", "spin_", ",", "ovb_"}], "]"}], "]"}], ":=",
    "ovb"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.839148729222795*^9, 3.8391487582744155`*^9}, {
  3.8391487910135603`*^9, 3.839148823070965*^9}},
 CellLabel->
  "In[448]:=",ExpressionUUID->"16155ff9-75f1-4afa-9118-cc16e4e5bc54"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfUnprimedVBundles", "[", "spin_", "]"}], "[", "vbs_List", 
    "]"}], ":=", 
   RowBox[{"Length", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"UpIndex", "/@", "vbs"}], ",", "spin"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfPrimedVBundles", "[", "spin_", "]"}], "[", "vbs_List", 
    "]"}], ":=", 
   RowBox[{"Length", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"UpIndex", "/@", "vbs"}], ",", 
      RowBox[{"Dagger", "@", "spin"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfUnprimedSlots", "[", "spin_", "]"}], "[", "T_", "]"}], ":=", 
   RowBox[{
    RowBox[{"NumOfUnprimedVBundles", "[", "spin", "]"}], "[", 
    RowBox[{"SlotsOfTensor", "[", "T", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfPrimedSlots", "[", "spin_", "]"}], "[", "T_", "]"}], ":=", 
   RowBox[{
    RowBox[{"NumOfPrimedVBundles", "[", "spin", "]"}], "[", 
    RowBox[{"SlotsOfTensor", "[", "T", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NumOfUnprimedSlotsDyad", "[", "dyad_", "]"}], ":=", 
   RowBox[{"NumOfUnprimedSlots", "[", 
    RowBox[{"xAct`xCoba`VBundleOfBasis", "@", "dyad"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NumOfPrimedSlotsDyad", "[", "dyad_", "]"}], ":=", 
   RowBox[{"NumOfPrimedSlots", "[", 
    RowBox[{"xAct`xCoba`VBundleOfBasis", "@", "dyad"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.838957436816845*^9, 3.838957450888235*^9}, {
  3.8391485973413267`*^9, 3.839148648544097*^9}, {3.8391637700754814`*^9, 
  3.839163797405632*^9}, {3.9234487977225666`*^9, 
  3.923448811673807*^9}},ExpressionUUID->"09edec10-8182-4103-86c5-\
13cbba5c7354"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymmetricSpinorOfValenceQ", "[", 
    RowBox[{"TT_", ",", " ", "k_", ",", " ", "l_", ",", " ", "spin_"}], "]"}],
    " ", ":=", " ", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"xTensorQ", "[", "TT", "]"}], ",", "\n", "      ", 
     RowBox[{
      RowBox[{
       RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "TT", "]"}], 
      " ", "==", " ", "k"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "TT", "]"}], " ", 
      "==", " ", "l"}], ",", " ", 
     RowBox[{
      RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin", "]"}], "[", 
      "TT", "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4d313c4f-6e73-8745-a802-f6eb3405f7e0"],

Cell["\<\
SymmetricSpinorOfValenceQ[TT_, k_, l_, spin_] := And[xTensorQ[TT],
   With[{slots = SlotsOfTensor[TT]}, If[Head[slots] === SymmetricOfValence, \
True, CompatibleSymQ[slots, SymmetryGroupOfTensor@TT, {spin, Dagger@spin}]]],
   ValenceNumbersOfSpinor[TT, spin] === {k, l}];\
\>", "Text",
 CellChangeTimes->{{3.839149077238312*^9, 3.839149079814424*^9}, {
   3.8391491387559166`*^9, 3.8391491649628606`*^9}, {3.839149197135096*^9, 
   3.8391492501636677`*^9}, {3.83914929082501*^9, 3.839149329783086*^9}, 
   3.9234490634489975`*^9},
 CellLabel->
  "In[457]:=",ExpressionUUID->"8cd0780a-8346-4111-b24a-796e77e15bca"],

Cell["\<\
Old code:\[LineSeparator]SymmetricSpinorOfArbitraryValenceQ[spin_][TT_?\
xTensorQ] := SymmetricSpinorOfArbitraryValenceQ[spin][TT] = With[{k = \
NumOfUnprimedSlots[spin][TT], l = NumOfPrimedSlots[spin][TT]}, \
SymmetricSpinorOfValenceQ[TT, k, l, spin]]\
\>", "Text",
 CellChangeTimes->{{3.83878520431179*^9, 3.838785205409388*^9}, {
   3.838785245330949*^9, 3.838785275347644*^9}, 3.8387853495139527`*^9, {
   3.838804109077178*^9, 3.838804112011682*^9}, {3.838804249839513*^9, 
   3.8388042622912707`*^9}, {3.838804546628193*^9, 3.838804551207081*^9}, {
   3.838807980377041*^9, 3.83880801406491*^9}, {3.839149355804597*^9, 
   3.839149358251057*^9}, {3.923448999059393*^9, 
   3.923449007560972*^9}},ExpressionUUID->"5587fdbf-9b93-409d-b52c-\
f77b929eaf75"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin_", "]"}], "[", 
    "TT_", "]"}], " ", ":=", " ", 
   RowBox[{"UpSet", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin", "]"}], "[", 
      "TT", "]"}], ",", " ", 
     RowBox[{"And", "[", 
      RowBox[{
       RowBox[{"xTensorQ", "[", "TT", "]"}], ",", " ", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"slots", " ", "=", " ", 
           RowBox[{"SlotsOfTensor", "[", "TT", "]"}]}], "}"}], ",", " ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Head", "[", "slots", "]"}], " ", "===", " ", 
            "SymmetricOfValence"}], ",", " ", "True", ",", " ", 
           RowBox[{"CompatibleSymQ", "[", 
            RowBox[{"slots", ",", " ", 
             RowBox[{"SymmetryGroupOfTensor", "@", "TT"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"spin", ",", " ", 
               RowBox[{"Dagger", "@", "spin"}]}], "}"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2207c259-7633-584d-8ad7-45a90137ec00"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EnoughIndsQSpin", "=", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"TTT", ",", "k", ",", "l", ",", "spin"}], "}"}], ",", 
     RowBox[{"And", "[", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "TTT", "]"}],
          "\[GreaterEqual]", "k"}], "]"}], ",", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "TTT", "]"}], 
         "\[GreaterEqual]", "l"}], "]"}]}], "]"}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellLabel->
  "In[459]:=",ExpressionUUID->"ea0a8ce4-5181-44ee-84db-b7f5214d7234"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ZeroTensorOfTensor", "[", "TT_", "]"}], ":=", 
  RowBox[{"ZeroTensor", "@", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "xAct`SymManipulator`Private`$SlotsOfTensorWarning", "=", "False"}], 
      "}"}], ",", 
     RowBox[{"SlotsOfTensor", "@", "TT"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[460]:=",ExpressionUUID->"42993d67-30d3-44e9-ae78-2139350518ea"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5. Finding tensor coefficients", "Subsubsection",
 CellChangeTimes->{{3.590500098119496*^9, 3.5905001251595335`*^9}, {
   3.592137407220198*^9, 3.592137437780241*^9}, 
   3.8388039908760552`*^9},ExpressionUUID->"f005e314-ca38-4b8b-bac9-\
02894d9fd5ad"],

Cell["\<\
It is often important to be able to find the coefficient of a tensor. The \
following idea works only if the complete expression does not have any free \
indices. However, if the expression has free indices, these can usually be \
contracted with an arbitrary tensor. It is also important that the tensor we \
are interested in only appears once per term. The tensor we are interested in \
can be a single tensor or a product, with or without contractions. Observe \
that different contractions will be treated as different tensors unless they \
canonicalize to the same expression.
The idea here is to change xSortPrecedence for the tensor we are interested \
in. After canonicalization, this tensor will then have the same index \
configuration in all terms where it appears. Unfortunately it might be \
difficult to know which index configuration will be due to possible dummy \
indices, therefore we construct some rules that looks for the tensor or \
product of tensors in question and records the actual index configuration it \
found in $IndexConfigs. The tensor coefficients can then be found by the \
Mathematica function Coefficient.\
\>", "Text",
 CellChangeTimes->{{3.592137666241561*^9, 3.592137670091566*^9}, {
  3.592137946281953*^9, 3.592138039382083*^9}, {3.59213825111238*^9, 
  3.592138311832465*^9}, {3.592138523652761*^9, 3.5921390154134493`*^9}, {
  3.592139048383497*^9, 3.592139266573801*^9}, {3.592139311223864*^9, 
  3.592139325413883*^9}, {3.839151343713541*^9, 
  3.839151366085388*^9}},ExpressionUUID->"39a97554-89f5-40a9-890f-\
ff3e75c49e65"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IndexConfigs", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[461]:=",ExpressionUUID->"6dc9bc17-7676-4163-a777-fd9e6fa40fe5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AddToIndexConfigRule", "[", 
    RowBox[{
     RowBox[{"tensora_", "?", "xTensorQ"}], "[", "indsaeq___", "]"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dummieseq", "=", 
       RowBox[{"xAct`xTensor`Private`TakeEPairs", "[", 
        RowBox[{"{", "indsaeq", "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"numdummiesaeq", "=", 
         RowBox[{"Length", "@", 
          RowBox[{"Intersection", "[", 
           RowBox[{"dummieseq", ",", 
            RowBox[{"{", "indsaeq", "}"}]}], "]"}]}]}], "}"}], ",", 
       RowBox[{"RuleDelayed", "[", 
        RowBox[{
         RowBox[{"HoldPattern", "@", 
          RowBox[{"tensora", "[", "indsa___", "]"}]}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"dummies", "=", 
              RowBox[{"xAct`xTensor`Private`TakeEPairs", "[", 
               RowBox[{"{", "indsa", "}"}], "]"}]}], ",", 
             RowBox[{"frees", "=", 
              RowBox[{"xAct`xTensor`Private`TakeFrees", "[", 
               RowBox[{"{", "indsa", "}"}], "]"}]}]}], "}"}], ",", 
           RowBox[{
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
               "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}], 
               "}"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}], 
                 "}"}], "=", 
                RowBox[{"SpecialEqualExpressionsQ", "[", 
                 RowBox[{
                  RowBox[{"tensora", "[", "indsaeq", "]"}], ",", 
                  RowBox[{"tensora", "[", "indsa", "]"}]}], "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{"equalexpr", ",", 
                 RowBox[{"AppendTo", "[", 
                  RowBox[{"$IndexConfigs", ",", 
                   RowBox[{"tensora", "[", "indsa", "]"}]}], "]"}]}], "]"}], 
               ";", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"tensora", "[", "indsa", "]"}], "/;", 
                "equalexpr"}]}]}], "]"}], "/;", 
            RowBox[{
             RowBox[{"Length", "@", 
              RowBox[{"Intersection", "[", 
               RowBox[{"dummies", ",", 
                RowBox[{"{", "indsa", "}"}]}], "]"}]}], "\[Equal]", 
             "numdummiesaeq"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590499245677302*^9, 3.5904992518673115`*^9}, {
   3.590499321197408*^9, 3.590499421647548*^9}, {3.5904995196776857`*^9, 
   3.590499547637725*^9}, {3.590499653027872*^9, 3.5904996652378893`*^9}, {
   3.590499903709223*^9, 3.5904999108792334`*^9}, {3.5905007053503456`*^9, 
   3.590500711420354*^9}, 3.839151381547815*^9},
 CellLabel->
  "In[462]:=",ExpressionUUID->"5d17b735-c3df-4b85-b007-860e6330206c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AddToIndexConfigRule", "[", 
    RowBox[{"LHS", ":", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}], "..."}]}], 
      "]"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"indslist", "=", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<tinds\>\"", ",", 
            RowBox[{"ToString", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
         RowBox[{"Range", "[", 
          RowBox[{"Length", "@", "LHS"}], "]"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rulelhs", "=", 
          RowBox[{"MapIndexed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "0", "]"}], "]"}], "[", 
              RowBox[{"First", "@", 
               RowBox[{"indslist", "[", 
                RowBox[{"[", "#2", "]"}], "]"}]}], "]"}], "&"}], ",", "LHS"}],
            "]"}]}], ",", 
         RowBox[{"rulelhspattern", "=", 
          RowBox[{"MapIndexed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"#1", "[", 
               RowBox[{"[", "0", "]"}], "]"}], "[", 
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"patterninds", "=", 
                  RowBox[{"First", "@", 
                   RowBox[{"indslist", "[", 
                    RowBox[{"[", "#2", "]"}], "]"}]}]}], "}"}], ",", 
                RowBox[{"Pattern", "[", 
                 RowBox[{"patterninds", ",", 
                  RowBox[{"BlankNullSequence", "[", "]"}]}], "]"}]}], "]"}], 
              "]"}], "&"}], ",", "LHS"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"RuleDelayed", "[", 
        RowBox[{
         RowBox[{"HoldPattern", "@", "rulelhspattern"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"rulelhsinds", "=", 
             RowBox[{"FindIndices", "[", "rulelhs", "]"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"dummieslhs", "=", 
                RowBox[{
                "xAct`xTensor`Private`TakeEPairs", "[", "rulelhsinds", 
                 "]"}]}], ",", 
               RowBox[{"freeslhs", "=", 
                RowBox[{
                "xAct`xTensor`Private`TakeFrees", "[", "rulelhsinds", 
                 "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}], 
                "}"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                  "equalexpr", ",", "sign", ",", "sortedfrees", ",", "perm"}],
                   "}"}], "=", 
                 RowBox[{"SpecialEqualExpressionsQ", "[", 
                  RowBox[{"LHS", ",", "rulelhs"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{"equalexpr", ",", 
                  RowBox[{"AppendTo", "[", 
                   RowBox[{"$IndexConfigs", ",", "rulelhs"}], "]"}]}], "]"}], 
                ";", "\[IndentingNewLine]", 
                RowBox[{"rulelhs", "/;", "equalexpr"}]}]}], "]"}]}], "]"}]}], 
          "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590499737507991*^9, 3.590499762228025*^9}, {
   3.590499875189183*^9, 3.590499942089277*^9}, 3.839151391449371*^9},
 CellLabel->
  "In[463]:=",ExpressionUUID->"3d4b04af-ba15-493a-9419-bde1b4d77c0f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSymmetryOfFreeIndices", "[", "expr_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"freeinds", "=", 
       RowBox[{"FindFreeIndices", "@", "expr"}]}], ",", "abstractfree", ",", 
      "actractfreeslots", ",", " ", "restslots", ",", " ", "slotexpr", ",", 
      "slotrules", ",", "reverseslotrules", ",", "sym", ",", "n", ",", 
      "freefirstperm", ",", " ", "freesym", ",", "restfrees", ",", " ", 
      "tmpsym", ",", "inds", ",", "HasSym", ",", "completesymmetricSGS"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", ",", "slotexpr", ",", "slotrules", ",", "sym"}], "}"}], 
      "=", 
      RowBox[{"List", "@@", 
       RowBox[{"SymmetryOf", "[", "expr", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"And", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"OrderOfGroup", "[", "sym", "]"}], "\[Equal]", "1"}], ",", 
         " ", 
         RowBox[{
          RowBox[{"Length", "@", "freeinds"}], "\[Equal]", "n"}]}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "freeinds"}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"inds", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"xAct`xTensor`Private`slot", "/@", 
            RowBox[{"Range", "[", "n", "]"}]}], ")"}], "/.", "slotrules"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"reverseslotrules", "=", 
         RowBox[{"Reverse", "/@", "slotrules"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"abstractfree", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"freeinds", ",", "AIndexQ"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"actractfreeslots", "=", 
         RowBox[{"First", "/@", 
          RowBox[{"List", "@@", 
           RowBox[{"Replace", "[", 
            RowBox[{
             RowBox[{"List", "@@", "abstractfree"}], ",", "reverseslotrules", 
             " ", ",", " ", 
             RowBox[{"{", "1", "}"}]}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"restslots", "=", 
         RowBox[{"Complement", "[", 
          RowBox[{
           RowBox[{"Range", "@", "n"}], ",", "actractfreeslots"}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Find", " ", "a", " ", "permutation", " ", "that", " ", "moves", " ",
           "the", " ", "free", " ", "indices", " ", 
          RowBox[{"first", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"freefirstperm", "=", 
         RowBox[{"List", "@@", 
          RowBox[{"TranslatePerm", "[", 
           RowBox[{
            RowBox[{"PermutationFromTo", "[", 
             RowBox[{
              RowBox[{"Range", "@", "n"}], ",", 
              RowBox[{"Join", "[", 
               RowBox[{"actractfreeslots", ",", "restslots"}], "]"}]}], "]"}],
             ",", "Rules"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Change", " ", "the", " ", "base", " ", "of", " ", "sym", " ", "so", 
          " ", "it", " ", "begins", " ", "with", " ", "the", " ", "dummy", 
          " ", 
          RowBox[{"indices", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"tmpsym", "=", 
         RowBox[{
          RowBox[{"StabilizerSGS", "[", 
           RowBox[{"restslots", ",", "sym"}], "]"}], "/.", 
          "freefirstperm"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"n", "=", 
         RowBox[{"Length", "@", "freeinds"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"CompatibleSymQ", "[", 
           RowBox[{
            RowBox[{"List", "@@", 
             RowBox[{"(", 
              RowBox[{"UpIndex", "/@", 
               RowBox[{"VBundleOfIndex", "/@", "freeinds"}]}], ")"}]}], ",", 
            "tmpsym"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"freesym", "=", "tmpsym"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"HasSym", "[", "p_", "]"}], ":=", 
            RowBox[{
             RowBox[{"ToCanonical", "[", 
              RowBox[{
               RowBox[{"PermuteIndices", "[", 
                RowBox[{"expr", ",", "freeinds", ",", 
                 RowBox[{"xAct`xPerm`Private`ToSign", "[", 
                  RowBox[{"p", ",", "n"}], "]"}]}], "]"}], "-", "expr"}], 
              "]"}], "===", "0"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"completesymmetricSGS", "=", 
            RowBox[{"JoinSGS", "[", 
             RowBox[{
              RowBox[{"CompatibleSymmetric", "[", "freeinds", "]"}], ",", 
              RowBox[{"Symmetric", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"n", "+", "1"}], ",", 
                  RowBox[{"n", "+", "2"}]}], "}"}], ",", "Cycles"}], "]"}]}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"completesymmetricSGS", "=", 
            RowBox[{"ReplacePart", "[", 
             RowBox[{"completesymmetricSGS", ",", 
              RowBox[{"1", "\[Rule]", 
               RowBox[{"Append", "[", 
                RowBox[{
                 RowBox[{"Range", "[", 
                  RowBox[{"n", "-", "1"}], "]"}], ",", 
                 RowBox[{"n", "+", "1"}]}], "]"}]}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"freesym", "=", 
            RowBox[{"xAct`xPerm`Private`ToSign", "[", 
             RowBox[{
              RowBox[{"Search", "[", 
               RowBox[{
               "completesymmetricSGS", ",", "HasSym", ",", "1", ",", 
                "tmpsym"}], "]"}], ",", "n"}], "]"}]}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"freesym", ",", "freeinds"}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590902365176928*^9, 3.590902365746929*^9}, {
   3.590902445867041*^9, 3.590902447267043*^9}, {3.590902483307093*^9, 
   3.590902587397239*^9}, {3.590902638977311*^9, 3.590902711807413*^9}, {
   3.590902745937461*^9, 3.590902810377551*^9}, 3.590902854837614*^9, {
   3.5909031511680284`*^9, 3.590903218658123*^9}, {3.590903454948454*^9, 
   3.590903455148454*^9}, {3.590903571568617*^9, 3.590903580038628*^9}, {
   3.590903618988683*^9, 3.590903680208769*^9}, {3.5909037481788645`*^9, 
   3.590903758758879*^9}, {3.590903809939951*^9, 3.5909038897500625`*^9}, {
   3.590903949110145*^9, 3.5909039674101715`*^9}, {3.590904415561799*^9, 
   3.590904418351803*^9}, {3.5909044945019093`*^9, 3.5909046034320617`*^9}, {
   3.590904648282125*^9, 3.590904769572294*^9}, {3.5909048018723397`*^9, 
   3.590904815282358*^9}, {3.590904871282437*^9, 3.5909049166825*^9}, {
   3.590904988762601*^9, 3.5909050227626486`*^9}, {3.5909050588926992`*^9, 
   3.590905098912755*^9}, {3.590905249342966*^9, 3.590905250162967*^9}, {
   3.5909055157033386`*^9, 3.590905537453369*^9}, {3.590905621493487*^9, 
   3.590905627093495*^9}, {3.590905684503575*^9, 3.590905686243578*^9}, {
   3.590905784873715*^9, 3.590905785173716*^9}, {3.590905819933764*^9, 
   3.590905876833844*^9}, {3.5909059274039154`*^9, 3.590905950323947*^9}, {
   3.590905982683993*^9, 3.590905983423993*^9}, {3.590906056884096*^9, 
   3.590906094614149*^9}, {3.590906578748936*^9, 3.590906857659327*^9}, {
   3.5909071431507263`*^9, 3.590907148550734*^9}, {3.590907245100869*^9, 
   3.5909072487208753`*^9}, {3.590907685871486*^9, 3.590907701131508*^9}, {
   3.59090792447182*^9, 3.590907930211828*^9}, {3.5909079879819098`*^9, 
   3.590907989671912*^9}, {3.590908099222065*^9, 3.5909081581821475`*^9}, {
   3.590908306492356*^9, 3.5909083241323795`*^9}, {3.5909083946124783`*^9, 
   3.590908422342517*^9}, {3.5909085165426493`*^9, 3.590908545173689*^9}, {
   3.592140842037008*^9, 3.592140891127076*^9}, {3.592140962027175*^9, 
   3.5921409969072237`*^9}, {3.619689086196327*^9, 3.6196890866563272`*^9}},
 CellLabel->
  "In[464]:=",ExpressionUUID->"f158102e-ac62-4718-b0fd-c759a9416e3a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindTensorHeads", "[", 
   RowBox[{
    RowBox[{"TT_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], ":=", 
  RowBox[{"{", "TT", "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590911618018992*^9, 3.590911662359054*^9}},
 CellLabel->
  "In[465]:=",ExpressionUUID->"8855bbe8-96ea-4f1b-b6f4-d75e1476a57a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindTensorHeads", "[", "expr_Times", "]"}], ":=", 
  RowBox[{"FindTensorHeads", "/@", 
   RowBox[{"(", 
    RowBox[{"List", "@@", "expr"}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.590911682179081*^9, 3.590911718629133*^9}},
 CellLabel->
  "In[466]:=",ExpressionUUID->"d867756b-f9bd-473a-be8c-909cceb634be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindTensorCoefficients", "[", 
   RowBox[{
    RowBox[{"expr_", "?", "ScalarQ"}], ",", "tensors_List"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AddToIndexConfigR1", "=", 
       RowBox[{"AddToIndexConfigRule", "/@", "tensors"}]}], ",", 
      "TensorHeads", ",", "canonicalizedexpr", ",", "tensorsasinexpr", ",", 
      "ImposeCorrectSym", ",", " ", "oldxsortprecendence", ",", " ", 
      "coefflist"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"TensorHeads", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"FindTensorHeads", "/@", "tensors"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ImposeCorrectSym", "[", 
       RowBox[{"expr1_", ",", "expr2_"}], "]"}], ":=", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"fullsym", "=", 
          RowBox[{"FullSymmetryOfFreeIndices", "[", "expr2", "]"}]}], "}"}], 
        ",", 
        RowBox[{"ImposeSym", "[", 
         RowBox[{"expr1", ",", 
          RowBox[{"ChangeIndex", "/@", 
           RowBox[{"fullsym", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"fullsym", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"oldxsortprecendence", "=", 
      RowBox[{"xSortPrecedence", "/@", "TensorHeads"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"xSortPrecedence", "[", "#", "]"}], "^=", "2"}], ")"}], 
       "&"}], "/@", "TensorHeads"}], ";", "\[IndentingNewLine]", 
     RowBox[{"$IndexConfigs", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"canonicalizedexpr", "=", 
      RowBox[{
       RowBox[{"ScreenDollarIndices", "[", 
        RowBox[{"ToCanonical", "[", "expr", "]"}], "]"}], "/.", 
       "AddToIndexConfigR1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tensorsasinexpr", "=", 
      RowBox[{"Union", "@", "$IndexConfigs"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"xSortPrecedence", "[", 
          RowBox[{"TensorHeads", "[", 
           RowBox[{"[", "#", "]"}], "]"}], "]"}], "^=", 
         RowBox[{"oldxsortprecendence", "[", 
          RowBox[{"[", "#", "]"}], "]"}]}], ")"}], "&"}], "/@", 
      RowBox[{"Range", "@", 
       RowBox[{"Length", "@", "TensorHeads"}]}]}], ";", "\[IndentingNewLine]",
      " ", 
     RowBox[{"coefflist", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ImposeCorrectSym", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"canonicalizedexpr", ",", "#"}], "]"}], ",", "#"}], 
           "]"}], ",", "#"}], "}"}], "&"}], "/@", "tensorsasinexpr"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ToCanonical", "@", 
           RowBox[{"ExpandSym", "[", 
            RowBox[{"expr", "-", 
             RowBox[{"Plus", "@@", 
              RowBox[{"Times", "@@@", "coefflist"}]}]}], "]"}]}], ",", "1"}], 
         "}"}], "}"}], ",", "coefflist"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->CompressedData["
1:eJwdxU0oQwEAB/DFXGabcvERxoUlFw6mtuKxUTsomo3Jmi2zZbNabWxWblqW
Rj5iRZPYmpNWDvsos8MWmpLWsjU5UHutRUhy8f7v8OvXpjGPz1UwGIxGCt4Q
PyjlVyShkFi0mNVRpceCMcKKrzN5O1ax63ew0+A5wiJXnn7xg7/eFCcJu/HV
jQ1BxRZ+mfTs4shCuxf3+Ip+bJxKXWDOdzGJN0usHOZljfR9B67LFmr+SiiG
BZ3aFC5U2+6wdML8TM8tvOGbVeE7Jpkj9MG6st6aIIknjseEk/NxqY06Fm6Q
Y0f5axpH/m6dWLw3eoh12k8f3j6XneHjR7Uf33szaRy1OLKYrWaWcOC3mT7B
OxEtUXN/dP24t3JYhmtz3TPYJFdp8NpgQI9bhwbMOB06pY+6Z+1YKd534i52
VrhMLQnXiPA/UI/eqQ==
  "],
 CellLabel->
  "In[467]:=",ExpressionUUID->"9aab30a7-d210-4a82-9a86-45a579eaed58"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindTensorCoefficients", "[", "___", "]"}], ":=", 
  RowBox[{"Throw", "@", 
   RowBox[{"Message", "[", 
    RowBox[{
     RowBox[{"FindTensorCoefficients", "::", "error"}], ",", " ", 
     "\"\<Only scalar expressions are allowed.\>\""}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5921422754290137`*^9, 3.592142292029037*^9}, {
  3.592142326189085*^9, 3.592142358169129*^9}},
 CellLabel->
  "In[468]:=",ExpressionUUID->"75c5c612-4782-4882-b413-075aea68b4e8"]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6. General equation handling tools", "Subsubsection",
 CellChangeTimes->{{3.590500098119496*^9, 3.5905001251595335`*^9}, {
   3.592137407220198*^9, 3.592137437780241*^9}, 3.8388039908760552`*^9, {
   3.83968647047532*^9, 
   3.83968647832354*^9}},ExpressionUUID->"25db2aba-60d2-4787-9c20-\
4e6118ef269d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"EqToRule", "[", "expr_Equal", "]"}], ":=", 
  RowBox[{"MakeRule", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"List", "@@", "expr"}], "]"}], ",", 
    RowBox[{"MetricOn", "\[Rule]", "All"}], ",", 
    RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EqToRule", "[", "True", "]"}], "=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.412482655748526*^9, 3.412482694002795*^9}, {
   3.6017516530607634`*^9, 3.601751656130768*^9}, 3.601751692670819*^9, {
   3.711951642667324*^9, 3.711951642817325*^9}},
 CellLabel->
  "In[469]:=",ExpressionUUID->"e3224293-c7b1-489f-9c47-95eba1ef779f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"EqToCompareRule", "[", "expr_Equal", "]"}], ":=", 
   RowBox[{"MakeCompareRule", "[", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"List", "@@", "expr"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EqToCompareRule", "[", "True", "]"}], "=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.839686407220659*^9, 3.83968641920372*^9}},
 CellLabel->
  "In[471]:=",ExpressionUUID->"e1dea1da-db99-4161-bc6a-1206e86685e8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FlipEquation", "[", 
   RowBox[{"LHS_", "\[Equal]", 
    RowBox[{"Times", "[", 
     RowBox[{
      RowBox[{"a_", "?", "NumberQ"}], ",", "RHS1_", ",", "RHSS2___"}], 
     "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Times", "[", 
    RowBox[{"RHS1", ",", "RHSS2"}], "]"}], "\[Equal]", 
   RowBox[{
    RowBox[{"(", "LHS", ")"}], "/", "a"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FlipEquation", "[", 
   RowBox[{"LHS_", "==", "RHS_"}], "]"}], ":=", 
  RowBox[{"RHS", "\[Equal]", "LHS"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.523938648740342*^9, 3.523938652125548*^9}, {
   3.5243002214756002`*^9, 3.5243002453914433`*^9}, {3.524300328274389*^9, 
   3.5243003299591913`*^9}, {3.524300539077559*^9, 3.524300598872463*^9}, 
   3.524300745949522*^9, {3.5846990189443088`*^9, 3.5846990189443088`*^9}, {
   3.839686964404476*^9, 3.8396869645490885`*^9}},
 CellLabel->
  "In[473]:=",ExpressionUUID->"662c606b-9f79-4ede-ab14-029763c209ea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Isolate", "[", 
   RowBox[{
    RowBox[{"LHS_", "\[Equal]", "RHS_"}], ",", "pattern_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"eq", "=", 
       RowBox[{"LHS", "-", "RHS"}]}], ",", "pos"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pos", "=", 
      RowBox[{"Position", "[", 
       RowBox[{"eq", ",", "pattern"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", "pos"}], "==", "0"}], ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"Isolate", "::", "error"}], ",", " ", 
          RowBox[{"\"\<Could not find \>\"", "<>", 
           RowBox[{"ToString", "@", "pattern"}]}]}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"pos", "=", 
      RowBox[{"First", "@", 
       RowBox[{"First", "@", "pos"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"FlipEquation", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"eq", "[", 
         RowBox[{"[", "pos", "]"}], "]"}], "-", "eq"}], "\[Equal]", 
       RowBox[{"eq", "[", 
        RowBox[{"[", "pos", "]"}], "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.528089251010678*^9, 3.528089297389559*^9}, {
  3.528089327419612*^9, 3.5280894521418304`*^9}, {3.8396871955250382`*^9, 
  3.839687249244876*^9}, {3.839687283927473*^9, 3.839687324045107*^9}},
 CellLabel->
  "In[475]:=",ExpressionUUID->"2dc4351c-5d08-471b-957c-1051eafa5647"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["8. Fundamental spinor operators", "Subsection",
 CellChangeTimes->{
  3.527145154765854*^9, 3.5292318049006476`*^9, {3.574768858574627*^9, 
   3.5747688589646277`*^9}, {3.589197859726068*^9, 3.58919786644968*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"83b92f28-2cb6-40e7-b96c-5867fb1ae110"],

Cell[CellGroupData[{

Cell["8.1. Common functions for the fundamental spinor operators", \
"Subsubsection",
 CellChangeTimes->{{3.5539192482194357`*^9, 3.553919256393849*^9}, {
   3.5539225601370573`*^9, 3.5539225625082607`*^9}, {3.589197911190558*^9, 
   3.589197916853368*^9}, {3.589197965338253*^9, 3.589197978052275*^9}, {
   3.5901524319283643`*^9, 3.590152434159168*^9}, 3.590213338156372*^9, 
   3.590318254499852*^9, {3.592220758365787*^9, 
   3.59222079620584*^9}},ExpressionUUID->"a3e36ae1-7527-47a5-9fe1-\
393a7da84d8d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DivName", "[", 
    RowBox[{"covd_", "?", "xAct`Spinors`SpinCovDQ"}], "]"}], ":=", 
   RowBox[{"Symbol", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<Div\>\"", ",", 
      RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], ";", " ", 
  RowBox[{
   RowBox[{"CurlName", "[", 
    RowBox[{"covd_", "?", "xAct`Spinors`SpinCovDQ"}], "]"}], ":=", 
   RowBox[{"Symbol", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<Curl\>\"", ",", 
      RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], ";", " ", 
  RowBox[{
   RowBox[{"CurlDgName", "[", 
    RowBox[{"covd_", "?", "xAct`Spinors`SpinCovDQ"}], "]"}], ":=", 
   RowBox[{"Symbol", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<CurlDg\>\"", ",", 
      RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], ";", " ", 
  RowBox[{
   RowBox[{"TwistName", "[", 
    RowBox[{"covd_", "?", "xAct`Spinors`SpinCovDQ"}], "]"}], ":=", 
   RowBox[{"Symbol", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<Twist\>\"", ",", 
      RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BoxName", "[", 
    RowBox[{"covd_", "?", "xAct`Spinors`SpinCovDQ"}], "]"}], ":=", 
   RowBox[{"Symbol", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<Box\>\"", ",", 
      RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.592220621244594*^9, 3.592220728765745*^9}, {
   3.592224183151582*^9, 3.592224189641591*^9}, {3.592224272201707*^9, 
   3.59222429608174*^9}, 3.592232206802663*^9},
 CellLabel->
  "In[476]:=",ExpressionUUID->"8de2ccbf-39d9-42d1-aed3-77af0a756a86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExtractUnprimedAndPrimedIndsGivenCovD", "[", 
    RowBox[{"inds_List", ",", 
     RowBox[{"covd_", "?", "xAct`Spinors`SpinCovDQ"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"spin", "=", 
        RowBox[{
         RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"spindg", "=", 
        RowBox[{
         RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{"inds", ",", 
         RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "@", "spin"}]}], 
        "]"}], ",", 
       RowBox[{"Select", "[", 
        RowBox[{"inds", ",", 
         RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "@", "spindg"}]}], 
        "]"}], ",", 
       RowBox[{"Select", "[", 
        RowBox[{"inds", ",", 
         RowBox[{
          RowBox[{"Not", "@", 
           RowBox[{"Or", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "@", "spin"}], 
               ")"}], "[", "#", "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
               "xAct`xTensor`Private`VBundleIndexPMQ", "@", "spindg"}], ")"}],
               "[", "#", "]"}]}], "]"}]}], "&"}]}], "]"}]}], "}"}]}], "]"}]}],
   ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.592220259534088*^9, 3.5922203065741544`*^9}, {
   3.592220405764293*^9, 3.592220511174441*^9}, {3.5922210886262493`*^9, 
   3.592221095636259*^9}, 3.592224192321594*^9, {3.608356603739921*^9, 
   3.608356667420011*^9}, {3.6083571242906504`*^9, 3.608357133780664*^9}, {
   3.608357263090845*^9, 3.6083572634508457`*^9}},
 CellLabel->
  "In[478]:=",ExpressionUUID->"314602ec-b175-46a3-b4c2-aa2edcf0626a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SpatialSpinCovDQ", "[", "_", "]"}], ":=", "False"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.599302646579269*^9, 3.599302664009293*^9}, 
   3.59930322570008*^9},
 CellLabel->
  "In[479]:=",ExpressionUUID->"c6890235-44ea-41da-b3cd-5c9167eb39c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpacetimeSpinCovDQ", "=", 
   RowBox[{
    RowBox[{"And", "[", 
     RowBox[{
      RowBox[{"xAct`Spinors`SpinCovDQ", "[", "#", "]"}], ",", 
      RowBox[{"Not", "@", 
       RowBox[{"SpatialSpinCovDQ", "[", "#", "]"}]}]}], "]"}], "&"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.599302552099137*^9, 3.5993025813891783`*^9}, {
   3.599302673729307*^9, 3.599302677299312*^9}, 3.604585087154887*^9, {
   3.607076241795453*^9, 3.607076254135471*^9}},
 CellLabel->
  "In[480]:=",ExpressionUUID->"26c86a4b-0adb-4bea-a71a-699fa76d43c9"]
}, Closed]],

Cell[CellGroupData[{

Cell["8.2. Definition of fundamental spinor operators and tools", \
"Subsubsection",
 CellChangeTimes->{{3.5539192482194357`*^9, 3.553919256393849*^9}, {
   3.5539225601370573`*^9, 3.5539225625082607`*^9}, {3.589197911190558*^9, 
   3.589197916853368*^9}, {3.589197965338253*^9, 3.589197978052275*^9}, {
   3.5901524319283643`*^9, 3.590152434159168*^9}, 3.590213338156372*^9, 
   3.590318254499852*^9, 
   3.592220754195781*^9},ExpressionUUID->"24a4c41d-79e0-4346-bc71-\
4a6d52325a91"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FundSpinOpQ", "[", "_", "]"}], ":=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteFundSpinOp", "[", "__", "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5981891511155453`*^9, 3.5981891850155926`*^9}},
 CellLabel->
  "In[481]:=",ExpressionUUID->"2422dac1-3735-47f7-b51a-9a6296bf1d0c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FundSpinOpCovDs", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FundSpinVBundles", "=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5972104434752345`*^9, 3.597210454145653*^9}, {
  3.598172049387412*^9, 3.598172059997427*^9}, {3.59930276841944*^9, 
  3.5993027712494435`*^9}, {3.607885296135423*^9, 3.607885306865438*^9}},
 CellLabel->
  "In[483]:=",ExpressionUUID->"dee23292-4508-45e5-90a2-cec934f0e8a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymFromOtherVBs", "[", 
   RowBox[{"TT_", ",", "spin_", ",", "spindg_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"slotsTT", "=", 
       RowBox[{"SlotsOfTensor", "@", "TT"}]}], ",", "spinpositions", ",", 
      "oVBpositions"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"spinpositions", "=", 
      RowBox[{"Flatten", "@", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"GatherBy", "[", 
          RowBox[{
           RowBox[{"Range", "@", 
            RowBox[{"Length", "@", "slotsTT"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"UpIndex", "/@", "slotsTT"}], ")"}], "[", 
             RowBox[{"[", "#", "]"}], "]"}], "&"}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"spin", ",", "spindg"}], "}"}], ",", 
            RowBox[{"UpIndex", "@", 
             RowBox[{"slotsTT", "[", 
              RowBox[{"[", 
               RowBox[{"First", "[", "#", "]"}], "]"}], "]"}]}]}], "]"}], 
          "&"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"oVBpositions", "=", 
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", "slotsTT"}]}], ",", "spinpositions"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StabilizerSGS", "[", 
       RowBox[{"spinpositions", ",", 
        RowBox[{"TranslatePerm", "[", 
         RowBox[{
          RowBox[{"SymmetryGroupOfTensor", "@", "TT"}], ",", "Cycles"}], 
         "]"}]}], "]"}], "/.", 
      RowBox[{"Thread", "@", 
       RowBox[{"Rule", "[", 
        RowBox[{"oVBpositions", ",", 
         RowBox[{"Range", "@", 
          RowBox[{"Length", "@", "oVBpositions"}]}]}], "]"}]}]}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6120064468793535`*^9, 3.612006506869437*^9}, {
  3.6120066534177012`*^9, 3.61200667352773*^9}, {3.612006765147858*^9, 
  3.61200678083788*^9}, {3.612006928438086*^9, 3.612006936058097*^9}, {
  3.612006984448165*^9, 3.6120069937881775`*^9}, {3.6120070887283115`*^9, 
  3.612007244348529*^9}, {3.612007283598584*^9, 3.6120073609986925`*^9}, {
  3.612007400438747*^9, 3.612007478428857*^9}, {3.612007994539579*^9, 
  3.612007995689581*^9}, {3.612008167270821*^9, 3.6120081732808285`*^9}, {
  3.6196891982264833`*^9, 3.619689198676484*^9}},
 CellLabel->
  "In[485]:=",ExpressionUUID->"93086c5c-5c76-4439-994b-43b7e0cf3448"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SlotRulesOtherVBs", "[", 
   RowBox[{"slotsTT_", ",", "inds_", ",", "spin_", ",", "spindg_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"gatheredinds", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Prepend", "[", 
          RowBox[{"#", ",", 
           RowBox[{"(", 
            RowBox[{"xAct`xTensor`Private`SignedVBundleOfIndex", "@", 
             RowBox[{"First", "@", "#"}]}], ")"}]}], "]"}], "&"}], "/@", 
        RowBox[{"GatherBy", "[", 
         RowBox[{"inds", ",", "xAct`xTensor`Private`SignedVBundleOfIndex"}], 
         "]"}]}]}], ",", "otherinds", ",", "otherpos"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"otherinds", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"gatheredinds", ",", 
        RowBox[{
         RowBox[{"And", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"First", "@", "#"}], "=!=", 
            RowBox[{"-", "spin"}]}], ",", 
           RowBox[{
            RowBox[{"First", "@", "#"}], "=!=", 
            RowBox[{"-", "spindg"}]}], ",", 
           RowBox[{
            RowBox[{"First", "@", "#"}], "=!=", "spin"}], ",", 
           RowBox[{
            RowBox[{"First", "@", "#"}], "=!=", "spindg"}]}], "]"}], "&"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"otherpos", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"Position", "[", 
          RowBox[{"slotsTT", ",", "#", ",", "1"}], "]"}], "]"}], "&"}], "/@", 
       
       RowBox[{"First", "/@", "otherinds"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Flatten", "[", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Thread", "[", 
          RowBox[{"Rule", "[", 
           RowBox[{"#1", ",", "#2"}], "]"}], "]"}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"otherpos", ",", 
          RowBox[{"Rest", "/@", "otherinds"}]}], "}"}]}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.607928489685892*^9},
 CellLabel->
  "In[486]:=",ExpressionUUID->"b6ce4260-5fdc-4f96-a360-03afd2181757"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefFundSpinOperators", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HideCovDSymbolReference", "\[Rule]", "True"}], ",", 
     RowBox[{"ShowValenceInfo", "\[Rule]", "True"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.598179035956328*^9, 3.598179074796382*^9}, {
   3.598179269636655*^9, 3.5981792714066577`*^9}, {3.599549253710316*^9, 
   3.599549300323198*^9}, 3.599549440005843*^9},
 CellLabel->
  "In