(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    762054,      17294]
NotebookOptionsPosition[    726934,      16728]
NotebookOutlinePosition[    727628,      16751]
CellTagsIndexPosition[    727585,      16748]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["SymSpin",
 FontSlant->"Italic",
 FontColor->RGBColor[1, 0, 0]]], "Title",
 CellChangeTimes->{{3.424432795274125*^9, 3.424432798147224*^9}, {
   3.5157440947588263`*^9, 3.515744097651992*^9}, {3.515938160464596*^9, 
   3.515938165706205*^9}, {3.5703531597164736`*^9, 3.5703531655508842`*^9}, 
   3.570353218013776*^9, {3.6070688762726407`*^9, 3.607068878462644*^9}, 
   3.64725427347031*^9, {3.838697467948556*^9, 3.838697468989202*^9}, 
   3.839044775482863*^9},ExpressionUUID->"6f880094-9dab-4837-94e7-\
8a6701328358"],

Cell[TextData[StyleBox["A symmetric spinor algebra",
 FontColor->RGBColor[0, 0, 1]]], "Subtitle",
 CellChangeTimes->{{3.432628764630637*^9, 3.432628770497842*^9}, {
   3.515744107853575*^9, 3.515744118206167*^9}, {3.5445929647531424`*^9, 
   3.544592965622192*^9}, {3.5703531863769207`*^9, 3.5703531999801445`*^9}, {
   3.60706888989266*^9, 3.607068919842702*^9}, {3.838697483931102*^9, 
   3.838697498427641*^9}, 
   3.83869763383694*^9},ExpressionUUID->"67ee7837-b726-4bc4-8ce6-\
9b89f5aa46fe"],

Cell[TextData[{
 StyleBox[" Thomas B\[ADoubleDot]ckdahl",
  FontSize->18],
 "     thomas.backdahl@chalmers.se\nMathematical Sciences,\nChalmers \
University of Technology and University of Gothenburg\nGothenburg, Sweden\n\n",
 StyleBox["Steffen Aksteiner",
  FontSize->18],
 "\n\n(c) 2021 - 2025, under GPL\n\nhttp://www.xAct.es/\n\
http://groups.google.com/group/xAct"
}], "Subsubtitle",
 CellChangeTimes->{{3.515744127407694*^9, 3.515744214153655*^9}, {
   3.515938182944235*^9, 3.515938183474636*^9}, {3.5354546450794406`*^9, 
   3.5354546469202437`*^9}, {3.5671882614270687`*^9, 
   3.5671882618482695`*^9}, {3.570353203630551*^9, 3.570353206017355*^9}, 
   3.5844269015311675`*^9, {3.6070689307227173`*^9, 3.6070689720927753`*^9}, {
   3.6070922060210805`*^9, 3.607092238511126*^9}, {3.607092282741188*^9, 
   3.6070923348112607`*^9}, {3.6426482700187693`*^9, 3.642648286348792*^9}, 
   3.6426483776589203`*^9, {3.642648411018967*^9, 3.6426484609990373`*^9}, {
   3.647254400111488*^9, 3.6472544077114983`*^9}, {3.647254476692595*^9, 
   3.647254488722612*^9}, {3.6472545354992237`*^9, 3.64725454820195*^9}, {
   3.679984186682398*^9, 3.679984203232233*^9}, 3.6975458285765853`*^9, {
   3.7282074055277305`*^9, 3.7282074076763673`*^9}, {3.8386975095159407`*^9, 
   3.838697514159733*^9}, {3.838803937701015*^9, 3.838803945669986*^9}, {
   3.8396761820808372`*^9, 3.8396761908550863`*^9}, 3.863077446977451*^9, {
   3.8630814082202883`*^9, 3.863081412994523*^9}, 3.8912653422440033`*^9, 
   3.9555116542306194`*^9, {3.9555329748014793`*^9, 3.9555329755866776`*^9}, {
   3.955674664073923*^9, 3.955674673374857*^9}, {3.9556753945141983`*^9, 
   3.955675418152231*^9}, {3.9569828625685387`*^9, 
   3.9569828633305435`*^9}},ExpressionUUID->"98a13709-b737-4068-9b03-\
af4efdd40af7"],

Cell[TextData[{
 StyleBox["SymSpin",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is a package for handling symmetric spinor expressions.\n\n",
 StyleBox["SymSpin",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is distributed under the GNU General Public License, and runs on top of ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", a free package for fast manipulation of abstract tensor expressions. "
}], "Text",
 CellChangeTimes->{{3.419078218575598*^9, 3.419078246806376*^9}, {
  3.425990024306922*^9, 3.425990025430625*^9}, {3.4941363300431013`*^9, 
  3.494136333188654*^9}, {3.5157442219230995`*^9, 3.5157442456454563`*^9}, {
  3.5159381900578475`*^9, 3.51593820845028*^9}, {3.5292378115451984`*^9, 
  3.529237844414456*^9}, {3.5703532254081893`*^9, 3.5703532547362404`*^9}, {
  3.607068979982786*^9, 3.6070690089828267`*^9}, {3.64264848454907*^9, 
  3.642648495859086*^9}, {3.647254279020318*^9, 3.6472542806703205`*^9}, {
  3.8386975296097937`*^9, 
  3.838697559928713*^9}},ExpressionUUID->"4d5f45eb-afe2-46a9-84e1-\
d2d265874e55"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "]"}]], "Input",
 CellChangeTimes->{{3.461421019166093*^9, 3.461421020263547*^9}},
 CellLabel->
  "In[366]:=",ExpressionUUID->"72c1b1f7-df50-4873-bff6-f70f796b7795"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2025", ",", "6", ",", "23", ",", "9", ",", "19", ",", 
   "52.7697917`9.474960227203493"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5201748450984573`*^9, 3.520175592850561*^9, 3.52017596479801*^9, 
   3.5201760928938336`*^9, 3.5201762671609373`*^9, 3.520176752597585*^9, 
   3.5201779201008253`*^9, 3.5201779700665092`*^9, 3.5201780303834147`*^9, 
   3.520178119921769*^9, 3.5201783207649164`*^9, 3.520179006952915*^9, 
   3.5201791070766892`*^9, 3.520179190298833*^9, 3.52017923484451*^9, 
   3.520179281313389*^9, 3.520179460495299*^9, 3.5201795483158507`*^9, 
   3.520181356801396*^9, 3.52018163326988*^9, 3.520268558614688*^9, 
   3.5202687266265273`*^9, 3.520268859119117*^9, 3.52026889611597*^9, 
   3.5202690874682417`*^9, 3.520271811210497*^9, 3.5203105954279346`*^9, 
   3.520310975876489*^9, 3.5203117778404217`*^9, 3.5203120960882998`*^9, 
   3.5271449373462715`*^9, 3.5271458071433992`*^9, 3.5271460006471395`*^9, 
   3.5271470217333326`*^9, 3.5271475923989353`*^9, 3.527148045611931*^9, 
   3.527148262935913*^9, 3.5271486851910577`*^9, 3.527150049445654*^9, 
   3.527150171734269*^9, 3.527150352273386*^9, 3.5271505062924566`*^9, 
   3.527150790680956*^9, 3.527150864063485*^9, 3.5292308221613216`*^9, 
   3.5292324657178087`*^9, 3.5292325704563923`*^9, 3.529235908180855*^9, 
   3.529236216250196*^9, 3.5292364158213468`*^9, 3.5292366532537637`*^9, 
   3.5292367147802715`*^9, 3.529236965912513*^9, 3.529237056345872*^9, 
   3.5340685680385866`*^9, 3.534068950442058*^9, 3.5340693813928146`*^9, 
   3.5340699505598145`*^9, 3.53407017563701*^9, 3.5342496349881597`*^9, 
   3.537621497408594*^9, 3.537621623940417*^9, 3.5376228407123537`*^9, {
   3.537622948290143*^9, 3.537622963078969*^9}, 3.537623181697753*^9, 
   3.5376233601932664`*^9, 3.5376254387741175`*^9, 3.5376287880242715`*^9, 
   3.5376946984858675`*^9, 3.5376948663733625`*^9, 3.537695500467676*^9, 
   3.5376955802462163`*^9, 3.5376959119193993`*^9, 3.5376963939602456`*^9, 
   3.537697103606492*^9, 3.5376974590531163`*^9, {3.537697970468815*^9, 
   3.5376979899220486`*^9}, 3.537700569234584*^9, 3.537700987268518*^9, 
   3.5377011485572014`*^9, 3.5377050741510963`*^9, 3.537767648391486*^9, 
   3.537780184692705*^9, 3.5377805825558043`*^9, 3.537780919595396*^9, 
   3.5377810786220756`*^9, 3.5377812407375603`*^9, 3.5377813767853994`*^9, 
   3.537781525859261*^9, 3.5377817242760096`*^9, 3.5377823976677923`*^9, 
   3.537782738543991*^9, 3.537782929706727*^9, 3.5377831903675847`*^9, 
   3.5377834392358217`*^9, 3.5377835716176543`*^9, 3.537784106542594*^9, 
   3.537784243386034*^9, 3.5440922078795586`*^9, 3.544097238595995*^9, 
   3.544097364160615*^9, 3.544097951565047*^9, 3.5440997528856106`*^9, 
   3.5441033713607664`*^9, 3.5441034625585265`*^9, 3.5441037037671504`*^9, 
   3.544103916145923*^9, 3.5441040505557594`*^9, 3.5441050983794003`*^9, 
   3.5441057130048795`*^9, 3.5441059477540913`*^9, 3.544107146242797*^9, 
   3.54459125186217*^9, 3.544591489073738*^9, 3.544591651463026*^9, 
   3.5445929032206225`*^9, 3.5446721717281303`*^9, 3.544672373193654*^9, 
   3.544673272411086*^9, {3.544673382043357*^9, 3.544673401580474*^9}, 
   3.5449492175074224`*^9, 3.5449516127414317`*^9, 3.5450156606377296`*^9, 
   3.54501572313144*^9, 3.5451061404170465`*^9, 3.545114019247418*^9, 
   3.5528211940801992`*^9, 3.5528226582373714`*^9, 3.55282279426961*^9, 
   3.552822985433346*^9, 3.5528231946453133`*^9, 3.5528236648769393`*^9, 
   3.552823969889675*^9, 3.5528261153624434`*^9, 3.552826308086182*^9, 
   3.5542072700575094`*^9, 3.5542084655364094`*^9, 3.561371696187217*^9, 
   3.561732584986005*^9, 3.5617791964926033`*^9, 3.561781486672226*^9, 
   3.561781560741156*^9, 3.561781651626916*^9, 3.561781901133754*^9, 
   3.561781932411809*^9, 3.5617821001443033`*^9, 3.561782193338867*^9, 
   3.561782386732407*^9, 3.5617824912681904`*^9, 3.561782524418249*^9, 
   3.5617842329196496`*^9, 3.562766624845748*^9, 3.5627667425479546`*^9, 
   3.562767080990549*^9, 3.5627678918497734`*^9, 3.562769544564476*^9, 
   3.5627696665098906`*^9, {3.5627711274856567`*^9, 3.5627711457688885`*^9}, 
   3.5627731129021435`*^9, 3.562773200792698*^9, 3.562821270227209*^9, 
   3.5628223445864964`*^9, 3.5628235964438953`*^9, 3.562823659733206*^9, 
   3.56282406054471*^9, 3.5628245974206533`*^9, 3.562825242122986*^9, 
   3.5628253104667053`*^9, 3.562825370511211*^9, 3.562825957931243*^9, 
   3.5628261325891495`*^9, 3.56282624664095*^9, 3.562828064642171*^9, 
   3.562828562563845*^9, 3.562828735240548*^9, 3.5628288774815984`*^9, 
   3.5628304882020273`*^9, 3.56283130395866*^9, 3.5628316985779533`*^9, 
   3.5628318196029663`*^9, 3.56283185036622*^9, 3.562832306979022*^9, 
   3.562832420360021*^9, 3.5628327279769616`*^9, 3.5628336685816135`*^9, 
   3.56283376305538*^9, 3.5628338335987034`*^9, 3.5634256313733892`*^9, 
   3.563426365869479*^9, 3.563427212265566*^9, 3.563428698122376*^9, 
   3.5634287900689373`*^9, 3.563428868849076*^9, 3.563429665169074*^9, 
   3.5641236113084354`*^9, 3.564124344510723*^9, 3.5641248610442305`*^9, 
   3.5641250162967033`*^9, 3.5641304406546307`*^9, 3.564635024021423*^9, 
   3.5646354965618525`*^9, 3.5646721277594867`*^9, 3.565759285923563*^9, 
   3.565773665638832*^9, 3.565892021411496*^9, 3.566194850147024*^9, 
   3.5662039697458687`*^9, 3.5662119026396637`*^9, 3.5662126380007563`*^9, 
   3.5662147323512344`*^9, 3.5663991476361322`*^9, 3.566543710509116*^9, 
   3.5670828122489247`*^9, 3.5671851346335764`*^9, 3.567586520134695*^9, 
   3.5676004782589216`*^9, 3.5678594368679476`*^9, 3.567860569571337*^9, 
   3.5678613057220306`*^9, 3.5678615186780043`*^9, 3.5678616178473787`*^9, 
   3.5678617145831485`*^9, 3.567861808822914*^9, 3.56786203435251*^9, 
   3.567862203456807*^9, 3.5678625351767898`*^9, 3.5678626821290483`*^9, 
   3.567862769941602*^9, 3.5678633189689665`*^9, 3.567863413676733*^9, 
   3.567863935279249*^9, 3.5678640874897165`*^9, 3.567864252475606*^9, 
   3.5678647657321076`*^9, 3.5678650145213447`*^9, 3.5678653135738697`*^9, 
   3.5678655273420453`*^9, 3.567877452606958*^9, 3.5679119462244887`*^9, 
   3.5679130610960464`*^9, 3.567916908038382*^9, 3.567917675232129*^9, 
   3.5679183595127316`*^9, 3.5679186135435777`*^9, 3.5679194434182353`*^9, 
   3.567919755465583*^9, 3.5679242565630894`*^9, 3.567926173807457*^9, 
   3.567926475558787*^9, 3.5679268601774626`*^9, 3.5679294726256514`*^9, 
   3.567929589376257*^9, 3.5679296707928*^9, 3.5679298550291233`*^9, 
   3.5679300820417223`*^9, 3.567930173535883*^9, 3.567930335339367*^9, 
   3.567930621194269*^9, 3.567931057183835*^9, 3.567931209284102*^9, 
   3.567931330277914*^9, 3.5679314656861525`*^9, 3.5679315186804457`*^9, 
   3.567931624479831*^9, 3.5679319489760013`*^9, 3.567932630369598*^9, 
   3.5679327498814077`*^9, 3.5679331244234657`*^9, 3.5679332316892543`*^9, 
   3.5679334628192596`*^9, 3.567934708810049*^9, 3.567935970697265*^9, 
   3.5681150026035523`*^9, 3.568115907094141*^9, 3.5681222518944855`*^9, 
   3.5681223539654646`*^9, 3.568123410993121*^9, 3.568895115070609*^9, 
   3.5688954820612535`*^9, {3.5703549460922117`*^9, 3.5703549577298317`*^9}, 
   3.5703573260021915`*^9, 3.570357445187401*^9, 3.570357531814353*^9, 
   3.5703576096896896`*^9, 3.5703577455981283`*^9, 3.57035780350543*^9, 
   3.5703578487923098`*^9, 3.5703579038448067`*^9, 3.5703579385236673`*^9, 
   3.57035800254618*^9, 3.570358231273782*^9, 3.570358626937277*^9, 
   3.5703592156833105`*^9, 3.57035930621027*^9, 3.5703598570472374`*^9, 
   3.5703601271149116`*^9, 3.570360996271438*^9, 3.5703610755195775`*^9, 
   3.5703612145002213`*^9, 3.5703614867206993`*^9, 3.5703615676380415`*^9, 
   3.5703616682894187`*^9, 3.5703618773453856`*^9, 3.5703628434716825`*^9, 
   3.570363006476369*^9, 3.5703631489982195`*^9, 3.5703632374503746`*^9, 
   3.570363298462082*^9, 3.570363360768591*^9, 3.5703635558469343`*^9, 
   3.570364084204262*^9, 3.5703641642636023`*^9, 3.570364365426956*^9, 
   3.570364471491542*^9, 3.5703645571044927`*^9, 3.5703647228235836`*^9, 
   3.5703648613986273`*^9, 3.570364932487952*^9, 3.570365043528947*^9, {
   3.5703653939055624`*^9, 3.5703654025635777`*^9}, 3.5703654620932817`*^9, 
   3.5703657261549463`*^9, 3.5703657903022585`*^9, {3.570365854121971*^9, 
   3.570365873107204*^9}, 3.5703659361625147`*^9, 3.5703659877830057`*^9, 
   3.5703660954241943`*^9, 3.570366175233935*^9, 3.570366231862034*^9, 
   3.570366296227747*^9, 3.570366338238621*^9, 3.5703664051315384`*^9, 
   3.570366436503194*^9, 3.570366572317032*^9, 3.5703669449392867`*^9, 
   3.570367244600213*^9, 3.5703673996488853`*^9, 3.5703674942162514`*^9, 
   3.5703677596049175`*^9, 3.570367807247401*^9, 3.570367863813101*^9, 
   3.570368556657118*^9, 3.5703686384792614`*^9, 3.570368782093114*^9, 
   3.5703688692660666`*^9, 3.570368929731773*^9, 3.570426909393371*^9, 
   3.5704275268736553`*^9, 3.570427596450778*^9, 3.5704276663389006`*^9, 
   3.5704277532310534`*^9, 3.5704319397968063`*^9, 3.5704321823148327`*^9, 
   3.5704330968050385`*^9, 3.570436513343156*^9, 3.5704380375906334`*^9, 
   3.5704381700982656`*^9, 3.5704382588156223`*^9, 3.5704383504969826`*^9, 
   3.570438571330971*^9, 3.570438755255294*^9, 3.5704388113217926`*^9, 
   3.5769885463038497`*^9, 3.5769896635788116`*^9, 3.5769897122508974`*^9, 
   3.5769897551665726`*^9, 3.5769897956642437`*^9, 3.5769901331864367`*^9, 
   3.576990313756754*^9, 3.5769903603540354`*^9, 3.576990526369527*^9, 
   3.576991387846441*^9, 3.5769916115352335`*^9, 3.5769924500689063`*^9, 
   3.576992811880342*^9, 3.5769933535288935`*^9, 3.576993430593029*^9, 
   3.5769937348403635`*^9, 3.5769941730773325`*^9, 3.57699510528817*^9, 
   3.5769952490736227`*^9, 3.5844271621452255`*^9, 3.584427295182259*^9, 
   3.5844273969256377`*^9, 3.584427666806112*^9, 3.584427731203025*^9, 
   3.584428021676535*^9, 3.584428063640609*^9, 3.5844284675721183`*^9, 
   3.584428588643931*^9, 3.5844287680764465`*^9, 3.5844292423640795`*^9, 
   3.584429323203421*^9, 3.584429364169093*^9, 3.584429426335202*^9, 
   3.5844295922414937`*^9, 3.584429987640788*^9, 3.584431509128061*^9, 
   3.5844319821530914`*^9, 3.6070699122540913`*^9, 3.6070712694724903`*^9, 
   3.6070714045326796`*^9, 3.607071523812846*^9, 3.6070715698829107`*^9, 
   3.607072815625655*^9, 3.6070729091057863`*^9, 3.607082476986291*^9, 
   3.6070831948372955`*^9, 3.607083375237548*^9, 3.6070835059677315`*^9, 
   3.607084231979748*^9, 3.607084313089861*^9, 3.607084514960144*^9, 
   3.6070849548807597`*^9, 3.607085010740838*^9, 3.607085774542907*^9, 
   3.6070858723230443`*^9, 3.607085966473176*^9, 3.60708624815357*^9, 
   3.6070875388563776`*^9, 3.6070879179669085`*^9, 3.607088068717119*^9, 
   3.6070886281479025`*^9, 3.6070895554702005`*^9, 3.6070896260302997`*^9, 
   3.6070926240416656`*^9, 3.619081946208799*^9, 3.619084939085471*^9, 
   3.6229569236606293`*^9, 3.6426665138880124`*^9, {3.642758184021817*^9, 
   3.642758192041828*^9}, 3.6433505204773846`*^9, 3.643995860257306*^9, 
   3.6439959281874013`*^9, 3.6440359322451954`*^9, 3.644036051745363*^9, 
   3.64403653491704*^9, 3.644036618097156*^9, 3.6440377573597507`*^9, 
   3.6450048356917396`*^9, 3.645010389893707*^9, 3.6450108489253497`*^9, 
   3.6463712502692738`*^9, 3.647254637813076*^9, 3.6472549594924746`*^9, 
   3.647255873421749*^9, 3.647256111794383*^9, 3.6472562962029305`*^9, {
   3.6472563828908887`*^9, 3.6472564119515505`*^9}, {3.6473287118012233`*^9, 
   3.6473287268912444`*^9}, 3.648264225027068*^9, 3.6482650406995*^9, 
   3.648350172644245*^9, 3.6490027405461044`*^9, 3.6491724514963536`*^9, 
   3.649214295282587*^9, 3.649214330052636*^9, 3.6799843377218876`*^9, 
   3.697546182021084*^9, 3.697546232062155*^9, 3.728207784224468*^9, 
   3.728208063468984*^9, 3.728209631953427*^9, 3.728209698699793*^9, 
   3.728792429537939*^9, 3.838963096659074*^9, {3.839150621916216*^9, 
   3.839150645419112*^9}, 3.8391507129943347`*^9, 3.839150749960822*^9, 
   3.839150899374437*^9, 3.8396763991536894`*^9, 3.8396764406799984`*^9, 
   3.8400276359802094`*^9, 3.840028369917205*^9, 3.840029048527373*^9, 
   3.8449217761696215`*^9, 3.863080459171502*^9, 3.8631706932430983`*^9, 
   3.9556746498746185`*^9, 3.9562786545830994`*^9, 3.956312133302534*^9, 
   3.956316135913286*^9, 3.9568103201792984`*^9, 3.9568113586308823`*^9, 
   3.9569828503871365`*^9, 3.9573631248748455`*^9, 3.958384157946575*^9, 
   3.9583842318149223`*^9, 3.9583842621854706`*^9, 3.9596519927767735`*^9},
 CellLabel->
  "Out[366]=",ExpressionUUID->"1205e731-76d3-314a-aab2-b51e7533c863"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`SymSpin`$Version", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<0.1.3\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2025", ",", "06", ",", "23"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5201736763242097`*^9, 3.5201736765114098`*^9}, 
   3.5202677233961115`*^9, {3.524975610240281*^9, 3.5249756190074964`*^9}, {
   3.526043102559106*^9, 3.5260431029851303`*^9}, 3.5262094698353777`*^9, {
   3.527143521454584*^9, 3.527143523888189*^9}, 3.527145380935051*^9, {
   3.527148024473894*^9, 3.527148025066695*^9}, {3.5271508514118624`*^9, 
   3.527150853003065*^9}, {3.527487735477854*^9, 3.527487735649454*^9}, {
   3.529235948304126*^9, 3.529235955495738*^9}, {3.530340543752088*^9, 
   3.5303405442701178`*^9}, {3.5340680436748652`*^9, 
   3.5340680511160784`*^9}, {3.534248359249119*^9, 3.5342483601071205`*^9}, {
   3.5354546246122046`*^9, 3.5354546292298126`*^9}, {3.5376260016865063`*^9, 
   3.53762600379251*^9}, 3.5376979589871945`*^9, 3.5377801890451126`*^9, {
   3.54020534631925*^9, 3.5402053477733326`*^9}, {3.544091585983466*^9, 
   3.5440915874186687`*^9}, 3.5441070904258986`*^9, 3.5445902979486094`*^9, {
   3.5446732637615914`*^9, 3.544673264066609*^9}, {3.5451058294149003`*^9, 
   3.545105832690906*^9}, 3.5451134126559525`*^9, {3.549022343760488*^9, 
   3.549022346287692*^9}, {3.552826297821364*^9, 3.5528263005513687`*^9}, {
   3.56094496233256*^9, 3.560944965093765*^9}, 3.561368747422238*^9, {
   3.5628210173663645`*^9, 3.5628210182399664`*^9}, {3.562821058690838*^9, 
   3.5628210594084387`*^9}, {3.56412500309908*^9, 3.564125006531086*^9}, {
   3.5646349977977767`*^9, 3.5646349983281775`*^9}, {3.5671882702566843`*^9, 
   3.5671882813795033`*^9}, {3.5678591469726386`*^9, 
   3.5678591471286387`*^9}, {3.567920466734233*^9, 3.567920467171033*^9}, 
   3.568122916627253*^9, {3.568895100640584*^9, 3.5688951033549886`*^9}, {
   3.5695822059707413`*^9, 3.569582206173542*^9}, {3.570353266155461*^9, 
   3.57035327135027*^9}, {3.5769949374006753`*^9, 3.5769949405362806`*^9}, {
   3.5844269100799828`*^9, 3.584426912232786*^9}, {3.6078433216072335`*^9, 
   3.6078433353772526`*^9}, {3.619081919608762*^9, 3.6190819210887637`*^9}, 
   3.61911341679828*^9, {3.6228633657147503`*^9, 3.622863371025758*^9}, 
   3.622956907228606*^9, {3.642648504849098*^9, 3.64264851326911*^9}, 
   3.6427581735818024`*^9, 3.6428317353803535`*^9, {3.6429095493118205`*^9, 
   3.642909549670621*^9}, 3.643080330212715*^9, 3.6432782009342537`*^9, 
   3.6433505087673683`*^9, {3.643988065120393*^9, 3.6439880652803926`*^9}, 
   3.644036608967143*^9, {3.644204609341963*^9, 3.6442046240319834`*^9}, {
   3.644940238333227*^9, 3.644940249093242*^9}, 3.6450043621910763`*^9, {
   3.646371016028946*^9, 3.646371027668962*^9}, 3.6472542863903284`*^9, {
   3.647254352460421*^9, 3.6472543628904357`*^9}, 3.647328717991232*^9, {
   3.6476918391997614`*^9, 3.6476918428889723`*^9}, 3.6477693591079426`*^9, {
   3.6482086300895977`*^9, 3.6482086302595987`*^9}, {3.64826390185138*^9, 
   3.6482639019295416`*^9}, 3.648350160894229*^9, 3.6490023987446256`*^9, {
   3.6491709964943166`*^9, 3.649170996704317*^9}, 3.649214285072573*^9, {
   3.6799841752325125`*^9, 3.679984179592469*^9}, {3.6975458420896044`*^9, 
   3.697545849641615*^9}, {3.728209066283142*^9, 3.728209074575499*^9}, {
   3.728792415112114*^9, 3.728792415668146*^9}, {3.8386975689167137`*^9, 
   3.838697584238452*^9}, 3.83880396022007*^9, 3.838870618759988*^9, 
   3.8388707077054043`*^9, 3.8391506086982174`*^9, {3.839676195125642*^9, 
   3.839676201157518*^9}, 3.839928886697225*^9, 3.8400276266500406`*^9, {
   3.840626471416831*^9, 3.8406264717848473`*^9}, 3.8406966957069693`*^9, 
   3.8408838997721443`*^9, {3.8444286770293093`*^9, 3.8444286804034777`*^9}, {
   3.84492155899559*^9, 3.8449215613560963`*^9}, {3.8630774531608744`*^9, 
   3.863077475544053*^9}, 3.86317068359694*^9, {3.891265330507903*^9, 
   3.891265335131531*^9}, 3.8913074558528194`*^9, 3.8916007095756397`*^9, {
   3.955511640463703*^9, 3.955511648497244*^9}, 3.955589681162895*^9, 
   3.95567465438818*^9, {3.956047642729046*^9, 3.9560476430815945`*^9}, 
   3.9562786496393967`*^9, {3.956810316581917*^9, 3.9568103166387615`*^9}, 
   3.956982847071966*^9, 3.957363121038109*^9, {3.9583575725187206`*^9, 
   3.9583575757368507`*^9}, 3.9583841693939953`*^9, {3.9596519882239513`*^9, 
   3.959651988456354*^9}},
 CellLabel->
  "In[367]:=",ExpressionUUID->"24adaa30-bb78-4a74-a433-410c0b6c0f3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0.1.3\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "6", ",", "23"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8389630832933283`*^9, {3.8391506219581037`*^9, 3.8391506454799776`*^9}, 
   3.8391507130421805`*^9, 3.839150750011659*^9, 3.8391508994641747`*^9, 
   3.8396763992097607`*^9, 3.8396764407647357`*^9, 3.840027636052986*^9, 
   3.840028369974053*^9, 3.8400290485852175`*^9, 3.8449217762454185`*^9, 
   3.863080459254281*^9, 3.863170693322831*^9, 3.955674655204073*^9, 
   3.9562786563673286`*^9, 3.9563121365478535`*^9, 3.9568103214838104`*^9, 
   3.9569828518412437`*^9, 3.9573631274619274`*^9, {3.9583841622583027`*^9, 
   3.9583841704358826`*^9}, 3.9583842322477665`*^9, 3.9583842622813263`*^9, 
   3.959651994385498*^9},
 CellLabel->
  "Out[367]=",ExpressionUUID->"6fe10e00-6afa-4e4a-94de-7a74887da5bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "1. ",
 StyleBox["Initialization",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsection",
 CellChangeTimes->{{3.576988657188844*^9, 3.576988658280846*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"70826498-dcb5-4e71-b60e-47489e5eb564"],

Cell["1.0. TODO list", "Subsubsection",ExpressionUUID->"0886241c-cc9d-4feb-a35f-4dc3af1b9335"],

Cell[CellGroupData[{

Cell["1.1. GPL", "Subsubsection",ExpressionUUID->"ce757d05-1fc4-4607-a839-20c8f5bb25b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"SymSpin", ":", " ", 
    RowBox[{"A", " ", "symmetric", " ", "spinor", " ", "algebra"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Copyright", " ", 
     RowBox[{"(", "C", ")"}], " ", "2021"}], " ", "-", " ", 
    RowBox[{
    "2025", " ", "Thomas", " ", "B\[ADoubleDot]ckdahl", " ", "and", " ", 
     "Steffen", " ", "Aksteiner"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", " ", "it", " ", "under", " ",
       "the", " ", "terms", " ", "of", " ", "the", " ", "GNU", " ", "General",
       " ", "Public", " ", "License", " ", "as", " ", "published", " ", "by", 
      " ", "the", " ", "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], 
     " ", "program", " ", "is", " ", "distributed", " ", "in", " ", "the", 
     " ", "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", 
     "useful"}], ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", " ", 
      "General", " ", "Public", " ", "License", " ", "for", " ", "more", " ", 
      
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], 
      " ", "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ",
       "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", " ", "along", " ", "with", " ", "this", " ", "program"}], 
     ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", " ", 
     "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", " ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744689999872*^9, 3.5157447334903593`*^9}, {
   3.5159382492443514`*^9, 3.515938255219162*^9}, {3.544107100285116*^9, 
   3.5441071015331182`*^9}, 3.567188293812725*^9, {3.5703532799926853`*^9, 
   3.57035331145794*^9}, {3.607069035712864*^9, 3.607069066512907*^9}, {
   3.607092353351287*^9, 3.60709237712132*^9}, {3.6426485342791395`*^9, 
   3.6426485527691655`*^9}, 3.647254303000352*^9, 3.6799842541527233`*^9, 
   3.697546198404107*^9, 3.7282096782984514`*^9, {3.838697612061164*^9, 
   3.83869762524973*^9}, {3.8388194095565877`*^9, 3.838819409768049*^9}, {
   3.840027114590633*^9, 3.840027124891281*^9}, 3.863077462704358*^9, {
   3.863081418385111*^9, 3.8630814215017796`*^9}, {3.9556754629994946`*^9, 
   3.955675478425377*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"a58e9110-a380-4f7c-b4db-f3cefd868167"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Info package", "Subsubsection",ExpressionUUID->"09c196d2-58a9-42f0-9b79-138d532abf0d"],

Cell["\<\
(* :Title: SymSpin *)

(* :Authors: Thomas B\[ADoubleDot]ckdahl and Steffen Aksteiner *)

(* :Summary: Setup of a symmetric spinor algebra *)

(* :Brief Discussion:
   - Introduces a product on symmetric spinor spaces. *)
  
(* :Context: xAct`SymSpin` *)

(* :Package Version: 0.1.3 *)

(* :Copyright: Thomas B\[ADoubleDot]ckdahl and Steffen Aksteiner (2021 - \
2025) *)

(* :History: See SymSpin.History *)

(* :Keywords: *)

(* :Source: SymSpin.nb *)

(* :Warning: *)

(* :Mathematica Version: 9.0 and later *)

(* :Limitations: *)
\t
(* :Acknowledgements: We thank Simon Jacobsson for testing and suggestions. *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellChangeTimes->{{3.52748768805377*^9, 3.5274877167110205`*^9}, 
   3.5292359425009155`*^9, {3.529237855818076*^9, 3.5292378954733458`*^9}, 
   3.534068072144915*^9, {3.537679017041196*^9, 3.537679018772799*^9}, 
   3.5441071118759365`*^9, {3.56718831328156*^9, 3.567188332438393*^9}, {
   3.56718841025133*^9, 3.5671884486117973`*^9}, {3.5703533217695584`*^9, 
   3.570353449689783*^9}, {3.607069081182928*^9, 3.607069138983009*^9}, {
   3.6070691707430534`*^9, 3.6070692330831404`*^9}, {3.6070692944432263`*^9, 
   3.6070693360332847`*^9}, {3.607092397721349*^9, 3.6070925198515196`*^9}, {
   3.607092571691592*^9, 3.6070925782916017`*^9}, {3.6426485796992035`*^9, 
   3.6426486562593107`*^9}, {3.646371048568991*^9, 3.6463711126990814`*^9}, {
   3.646371152739137*^9, 3.6463711736291666`*^9}, {3.647254303070352*^9, 
   3.647254303210352*^9}, {3.647328582741042*^9, 3.647328583861044*^9}, {
   3.679984263292632*^9, 3.6799842662626023`*^9}, 3.6975462094281225`*^9, {
   3.7282096654877205`*^9, 3.728209668189596*^9}, {3.838697653031209*^9, 
   3.838697755973177*^9}, 3.83881942083744*^9, {3.839676411060959*^9, 
   3.839676412750448*^9}, {3.840027132408326*^9, 3.8400271369860954`*^9}, {
   3.8406264899836855`*^9, 3.8406265392337446`*^9}, {3.863077477568615*^9, 
   3.863077478959895*^9}, {3.863081429649088*^9, 3.8630814328485336`*^9}, {
   3.9556754851352158`*^9, 3.9556755089078903`*^9}, 3.9583841772730427`*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"30491853-cf28-49d3-9cc8-4e2d4f2beb4b"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. BeginPackage", "Subsubsection",ExpressionUUID->"0753a3b2-eb22-47c3-af26-0aa9348f4fea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`SymSpin`\>\""}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4232371765761337`*^9, 3.4232371975315447`*^9}, {
   3.5157446135334983`*^9, 3.5157446161936502`*^9}, 3.5159382952176323`*^9, {
   3.570353461920204*^9, 3.5703534651650105`*^9}, {3.6070693547133107`*^9, 
   3.6070693608633194`*^9}, 3.647254303210352*^9, {3.838697811804701*^9, 
   3.838697812629244*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"e8af212a-d1dd-4aaa-b934-abf8e2f2f59e"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellChangeTimes->{{3.423237204071299*^9, 3.423237206170257*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"3e51c4d6-39f3-4d8a-b882-cddba51a5ee2"],

Cell[BoxData["\<\"xAct`SymSpin`\"\>"], "Output",
 CellChangeTimes->{
  3.647254637866079*^9, 3.647254959524477*^9, 3.64725587344475*^9, 
   3.647256111815384*^9, 3.647256296230932*^9, {3.6472563829218903`*^9, 
   3.647256411984553*^9}, {3.6473287118312235`*^9, 3.6473287269312444`*^9}, 
   3.6482642251520753`*^9, 3.6482650408713837`*^9, 3.648350172674245*^9, 
   3.6490027405861044`*^9, 3.6491724515163536`*^9, 3.6492142953025875`*^9, 
   3.6492143300726357`*^9, 3.679984337821887*^9, 3.697546182071084*^9, 
   3.6975462321021547`*^9, 3.7282077843578453`*^9, 3.728208063558242*^9, 
   3.7282096320501165`*^9, 3.7282096987960906`*^9, 3.7287924296129436`*^9, {
   3.8391506220578375`*^9, 3.839150645586665*^9}, 3.839150713080078*^9, 
   3.839150750051551*^9, 3.839150899520993*^9, 3.8396763992516756`*^9, 
   3.8396764437240825`*^9, 3.840027636086895*^9, 3.8400283700129485`*^9, 
   3.8400290486281033`*^9, 3.8449217762953095`*^9, 3.8630804592822065`*^9, 
   3.863170693354843*^9, 3.9583842322937527`*^9, 3.9583842623128777`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"e270f5fc-8710-3441-ad8b-9bab9abfb45e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\"\<xAct`SymSpin`\>\""], "Input",
 CellChangeTimes->{{3.647254303220352*^9, 3.647254303220352*^9}, {
  3.8386978228680153`*^9, 3.83869782377602*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"77cf01ec-34f5-426a-bad5-6c6380cf06b9"],

Cell[BoxData["\<\"xAct`SymSpin`\"\>"], "Output",
 CellChangeTimes->{
  3.647254637869079*^9, 3.6472549595304775`*^9, 3.6472558734497504`*^9, 
   3.647256111819384*^9, 3.6472562962369328`*^9, {3.647256382926891*^9, 
   3.647256411990553*^9}, {3.6473287118412232`*^9, 3.647328726941244*^9}, 
   3.6482642251989555`*^9, 3.648265040933889*^9, 3.648350172674245*^9, 
   3.6490027405861044`*^9, 3.6491724515163536`*^9, 3.6492142953025875`*^9, 
   3.6492143300726357`*^9, 3.679984337831887*^9, 3.697546182071084*^9, 
   3.6975462321021547`*^9, 3.7282077843578453`*^9, 3.728208063558242*^9, 
   3.7282096320661936`*^9, 3.7282096987991333`*^9, 3.728792429622944*^9, {
   3.8391506220827703`*^9, 3.8391506456146173`*^9}, 3.839150713105013*^9, 
   3.8391507500774813`*^9, 3.8391508995649033`*^9, 3.839676399268631*^9, 
   3.839676443789933*^9, 3.84002763610385*^9, 3.8400283700448637`*^9, 
   3.840029048653036*^9, 3.844921776318224*^9, 3.8630804592951717`*^9, 
   3.8631706933710704`*^9, 3.9583842323097305`*^9, 3.958384262328705*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"f2443ba3-6617-524e-958f-627c95a47c88"]
}, Open  ]],

Cell[TextData[{
 "Explicit (not hidden) import of ",
 StyleBox["TexAct,",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " ",
 StyleBox["xCoba,",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " ",
 StyleBox["Spinors,",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", ",
 StyleBox["xPerm",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " and ",
 StyleBox["xCore",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ":"
}], "Text",
 CellChangeTimes->{{3.57035348776945*^9, 3.5703535035722775`*^9}, {
  3.5703538815775414`*^9, 3.5703538894243555`*^9}, {3.570353941466047*^9, 
  3.5703539460368547`*^9}, {3.607069405043381*^9, 3.6070694057833824`*^9}, {
  3.6070728644457235`*^9, 
  3.6070728737557364`*^9}},ExpressionUUID->"c35d76c3-fdf3-4ded-9669-\
169a5980ead1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`SymSpin`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<xAct`SpinFrames`\>\"", ",", "\"\<xAct`SymManipulator`\>\"", ",", 
     "\"\<xAct`TexAct`\>\"", ",", "\"\<xAct`xCoba`\>\"", ",", 
     "\"\<xAct`Spinors`\>\"", ",", "\"\<xAct`xTensor`\>\"", ",", 
     "\"\<xAct`xPerm`\>\"", ",", "\"\<xAct`xCore`\>\""}], "}"}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744641041072*^9, 3.515744644398264*^9}, 
   3.5159383064496517`*^9, {3.570353474181826*^9, 3.570353477348632*^9}, {
   3.570353512355093*^9, 3.5703535203579073`*^9}, {3.5703538965847683`*^9, 
   3.5703539054455833`*^9}, {3.570353951294064*^9, 3.5703539570660744`*^9}, {
   3.6070694135933933`*^9, 3.607069424213408*^9}, {3.6070728821557484`*^9, 
   3.6070728909057603`*^9}, {3.642653585181058*^9, 3.6426535923710675`*^9}, 
   3.647254303230352*^9, {3.838697860831911*^9, 3.8386978658564587`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"1a34fde2-1556-4922-b179-2fabba33b839"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.9583842624858246`*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"cd3da268-46a6-9642-aac2-c14bba83537e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.9583842624858246`*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"477ae80a-8bd6-4240-a3aa-100c3dbbb860"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.9583842624960766`*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"e201a790-1885-2745-b371-3128c86ffdda"],

Cell[BoxData["\<\"Connecting to external MinGW executable...\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.9583842625831585`*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"6b93f7c7-3fdb-9f41-a0e6-ac9e7c1158e1"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.9583842626767235`*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"f03aa23a-5387-8d43-bda4-bae7518039e1"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.9583842626767235`*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"49cb9a10-a263-a946-99d8-0cf1fc48da9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.9583842626767235`*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"25e487df-05dc-774c-9345-40d48fc50517"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.9583842626925735`*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"40952512-2255-6a48-8f9c-95e35aba4ea4"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.958384262803831*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"78550b9a-6cdf-dc49-ac06-d78cd1c1328f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SymManipulator`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.9.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2024", ",", "4", ",", "30"}], "}"}]}],
  SequenceForm[
  "Package xAct`SymManipulator`  version ", "0.9.6", ", ", {2024, 4, 30}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.958384262803831*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"eb7f2cfb-f6d4-a848-9547-6251c578edbb"],

Cell[BoxData["\<\"CopyRight (C) 2011-2021, Thomas B\[ADoubleDot]ckdahl, under \
the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.958384262803831*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"3f8f7486-0111-3343-81e3-eea520b23fb0"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.958384262871311*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"658e6cfb-06c0-fd49-9c70-857c42533e49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`TexAct`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.4.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2024", ",", "4", ",", "5"}], "}"}]}],
  SequenceForm["Package xAct`TexAct`  version ", "0.4.4", ", ", {2024, 4, 5}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.9583842628728924`*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"ded4c2e1-7208-814d-90e3-c4572f48c546"],

Cell[BoxData["\<\"CopyRight (C) 2008-2021, Thomas B\[ADoubleDot]ckdahl, Jose \
M. Martin-Garcia and Barry Wardell, under the General Public License.\"\>"], \
"Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, {3.958384232909828*^9, 
   3.958384262874468*^9}},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"95f6bac5-f0f8-4a4d-a711-72fa2a96e3fb"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, 3.958384232909828*^9, 
   3.958384263042938*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"bb302bf0-7e81-7f4f-9ded-d5f2b5d397e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.6", ", ", {2021, 2, 28}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, 3.958384232909828*^9, 
   3.958384263042938*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"f33f45e1-c2ce-2b49-945f-1b61a85607b2"],

Cell[BoxData["\<\"CopyRight (C) 2005-2021, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, 3.958384232909828*^9, 
   3.958384263042938*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"9067087f-272f-b847-b0e3-e3b7214214da"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, 3.958384232909828*^9, 
   3.9583842653799896`*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"bc065bd6-aaa6-6d41-b067-65971d2f05b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Spinors`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`Spinors`  version ", "1.0.6", ", ", {2021, 2, 28}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, 3.958384232909828*^9, 
   3.9583842653958187`*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"45a2b2e7-567a-b340-bcd9-d25c623016f8"],

Cell[BoxData["\<\"CopyRight (C) 2006-2018, Alfonso Garcia-Parrado Gomez-Lobo \
and Jose M. Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, 3.958384232909828*^9, 
   3.958384265397827*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"12c5d1b3-8a63-404b-a775-208879635102"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, 3.958384232909828*^9, 
   3.958384265430023*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"e733a719-14f2-7543-bb28-bc41ce22c90f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SpinFrames`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.5.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "6", ",", "8"}], "}"}]}],
  SequenceForm[
  "Package xAct`SpinFrames`  version ", "0.5.4", ", ", {2025, 6, 8}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, 3.958384232909828*^9, 
   3.958384265430023*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"ad447df1-0b9a-9043-a2ad-fe97d29594c1"],

Cell[BoxData["\<\"CopyRight (C) 2014-2024, Thomas B\[ADoubleDot]ckdahl and \
Steffen Aksteiner, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.6483501727842455`*^9, 3.6490027406761045`*^9, 3.6491724516263533`*^9, 
   3.6492142953825874`*^9, 3.6492143301626363`*^9, 3.6799843379318857`*^9, 
   3.6975461821810846`*^9, 3.697546232192155*^9, 3.7282077844869666`*^9, 
   3.7282080637156134`*^9, 3.728209632169551*^9, 3.728209698915224*^9, 
   3.7287924297389507`*^9, {3.8391506221984887`*^9, 3.8391506457063456`*^9}, 
   3.8391507132037754`*^9, 3.8391507502091537`*^9, 3.839150899659624*^9, 
   3.839676399354373*^9, 3.8396764439345193`*^9, 3.840027636268437*^9, 
   3.8400283701306343`*^9, 3.840029048746786*^9, 3.844921776402031*^9, 
   3.8630804595175767`*^9, 3.863170693508563*^9, 3.958384232909828*^9, 
   3.958384265430023*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"b7ed5d1d-40f0-4f4c-a96a-2d40046fd785"]
}, Open  ]],

Cell[BoxData["\<\"xAct`SymSpin`\"\>"], "Output",
 CellChangeTimes->{
  3.6472546385831203`*^9, 3.6472549601195107`*^9, 3.647255874012782*^9, 
   3.6472561123894167`*^9, 3.647256296809965*^9, {3.647256383475922*^9, 
   3.6472564125605855`*^9}, {3.647328712401224*^9, 3.647328727521245*^9}, {
   3.6482642209643555`*^9, 3.648264225245829*^9}, {3.648265036380331*^9, 
   3.6482650410120163`*^9}, 3.648350173314246*^9, 3.6490027411361055`*^9, 
   3.649172452236355*^9, 3.649214295852588*^9, 3.6492143306626368`*^9, 
   3.67998433848188*^9, 3.6975461826410847`*^9, 3.6975462326621556`*^9, 
   3.7282077852722654`*^9, 3.72820806445399*^9, 3.728209632885846*^9, 
   3.7282096996706605`*^9, 3.7287924302109776`*^9, {3.8391506231339607`*^9, 
   3.8391506465162106`*^9}, 3.8391507138829317`*^9, 3.8391507508903093`*^9, 
   3.83915090032591*^9, 3.8396764001931314`*^9, 3.8396764448470817`*^9, 
   3.8400276373306575`*^9, 3.8400283709384747`*^9, 3.840029049559613*^9, 
   3.844921777181147*^9, 3.863080460837077*^9, 3.8631706947130623`*^9, {
   3.958384235836073*^9, 3.95838426545903*^9}},
 CellLabel->"Out[34]=",ExpressionUUID->"96488b75-8b7e-2242-a587-03b0292785fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\"\<xAct`SymSpin`\>\""], "Input",
 CellChangeTimes->{{3.6472543032403517`*^9, 3.647254303250352*^9}, {
  3.8386978756546717`*^9, 3.838697876611155*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"73bbe32e-571a-41c5-acc2-ab24303ceac0"],

Cell[BoxData["\<\"xAct`SymSpin`\"\>"], "Output",
 CellChangeTimes->{
  3.64725463858712*^9, 3.64725496027852*^9, 3.64725587415279*^9, 
   3.647256112546426*^9, 3.6472562969819746`*^9, {3.64725638361693*^9, 
   3.647256412710594*^9}, {3.6473287125412245`*^9, 3.6473287276612453`*^9}, 
   3.6482642252770805`*^9, 3.648265041090149*^9, 3.6483501735042467`*^9, 
   3.649002741266105*^9, 3.6491724523763547`*^9, 3.6492142959825883`*^9, 
   3.649214330842637*^9, 3.67998433849188*^9, 3.6975461827910852`*^9, 
   3.697546232832156*^9, 3.7282077853720865`*^9, 3.72820806445399*^9, 
   3.728209632901479*^9, 3.72820969967671*^9, 3.728792430221978*^9, {
   3.8391506231918063`*^9, 3.839150646579013*^9}, 3.839150713907897*^9, 
   3.839150750899285*^9, 3.8391509003507757`*^9, 3.8396764002659645`*^9, 
   3.839676444965767*^9, 3.8400276373944864`*^9, 3.8400283709923306`*^9, 
   3.8400290496413946`*^9, 3.844921777201067*^9, 3.8630804609487505`*^9, 
   3.863170694850869*^9, {3.958384235991482*^9, 3.9583842658269386`*^9}},
 CellLabel->"Out[35]=",ExpressionUUID->"30808b50-0a08-b847-adc1-917935da8c7b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "xAct`xCore`Private`bars", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`SymSpin`  version \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<CopyRight (C) 2021, Steffen Aksteiner and Thomas \
B\[ADoubleDot]ckdahl, under the General Public License.\>\"", "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5157446619242663`*^9, 3.5157446758810644`*^9}, {
   3.5157447480631933`*^9, 3.515744750743346*^9}, {3.515938308727256*^9, 
   3.515938317666072*^9}, {3.567188468470632*^9, 3.567188472292639*^9}, {
   3.6070694443134365`*^9, 3.60706945419345*^9}, {3.607092557931573*^9, 
   3.60709256267158*^9}, {3.607155256466303*^9, 3.607155261196309*^9}, {
   3.642648671769332*^9, 3.6426486847093506`*^9}, 3.647254303250352*^9, 
   3.6799842853424115`*^9, 3.7282096425525446`*^9, {3.838697889692631*^9, 
   3.838697895193239*^9}, {3.8400271482908983`*^9, 3.8400271542969027`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"ee2ea5ef-09fd-4b23-ab91-34301e2a0df5"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.520174849509264*^9, 3.5201755960989656`*^9, 3.520175968590816*^9, 
   3.520176096258639*^9, 3.5201762704681425`*^9, 3.520176756057991*^9, 
   3.5201779236516304`*^9, 3.520177973427715*^9, 3.5201780339410205`*^9, 
   3.5201781232217736`*^9, 3.520178324027721*^9, 3.52017901033572*^9, 
   3.5201791108454947`*^9, 3.5201791936240377`*^9, 3.5201792382921157`*^9, 
   3.520179284833394*^9, 3.520179463876904*^9, 3.520179551655855*^9, 
   3.5201813601618013`*^9, 3.5201816366154847`*^9, 3.5202685625118937`*^9, 
   3.520268730947734*^9, 3.5202688625719223`*^9, 3.5202688996803756`*^9, 
   3.5202690919982476`*^9, 3.520271814190901*^9, 3.520310605197149*^9, 
   3.5203109866249046`*^9, 3.520311787180435*^9, 3.5203121049047127`*^9, {
   3.5271449361606693`*^9, 3.527144937439872*^9}, 3.5271458083914013`*^9, 
   3.5271460019419413`*^9, 3.527147022965735*^9, 3.5271475939589376`*^9, 
   3.5271480468755336`*^9, 3.527148264183915*^9, 3.52714868648586*^9, 
   3.5271500507716565`*^9, 3.527150172997871*^9, 3.5271503536149883`*^9, 
   3.527150507556059*^9, 3.5271507919913583`*^9, 3.5271508653426867`*^9, 
   3.529230823877325*^9, 3.529232467059411*^9, 3.529232571751195*^9, 
   3.5292359095068574`*^9, 3.5292362175137987`*^9, 3.529236417194149*^9, 
   3.5292366545797663`*^9, 3.529236716075074*^9, 3.529236967176115*^9, 
   3.529237057671874*^9, 3.5340685699417896`*^9, 3.53406895170566*^9, 
   3.534069382718817*^9, 3.534069951854617*^9, 3.5340701769318123`*^9, 
   3.5342496371721635`*^9, 3.537621498672197*^9, 3.5376216251884193`*^9, 
   3.5376228419447565`*^9, {3.537622948446143*^9, 3.537622964373771*^9}, 
   3.5376231829301553`*^9, 3.537623361519269*^9, 3.5376254399285192`*^9, 
   3.5376287896154747`*^9, 3.53769469982747*^9, 3.5376948677461653`*^9, 
   3.537695501762479*^9, 3.5376955815566187`*^9, 3.537695913229801*^9, 
   3.537696395239448*^9, 3.5376971050104947`*^9, 3.5376974604259186`*^9, {
   3.537697970624815*^9, 3.5376979912324514`*^9}, 3.537700570638586*^9, 
   3.5377009886725206`*^9, 3.5377011498208036`*^9, 3.537705075508299*^9, 
   3.5377676499514885`*^9, 3.537780185987508*^9, 3.5377805838974066`*^9, 
   3.5377809208901987`*^9, 3.5377810799168777`*^9, 3.5377812420011625`*^9, 
   3.5377813781426015`*^9, 3.537781527200863*^9, 3.5377817255864115`*^9, 
   3.537782399040595*^9, 3.5377827398387933`*^9, 3.5377829310015287`*^9, 
   3.537783191740387*^9, 3.537783440546224*^9, 3.5377835728656564`*^9, 
   3.537784107868596*^9, 3.5377842446964364`*^9, 3.544092209221161*^9, 
   3.544097239984397*^9, 3.5440973654710174`*^9, 3.544097952797449*^9, 
   3.544099754133613*^9, 3.5441033727023687`*^9, 3.544103463868929*^9, 
   3.544103705030752*^9, 3.5441039174563255`*^9, 3.5441040518505616`*^9, 
   3.544105099611802*^9, 3.5441057142684813`*^9, 3.544105949064494*^9, 
   3.544107147443999*^9, 3.544591253200247*^9, 3.5445914903948135`*^9, 
   3.5445916527811017`*^9, 3.5445929046057014`*^9, 3.5446721730552063`*^9, 
   3.5446723745247297`*^9, 3.544673273684159*^9, {3.5446733821943655`*^9, 
   3.5446734029125504`*^9}, 3.5449492188490252`*^9, 3.544951614114234*^9, 
   3.5450156626813335`*^9, 3.5450157245042424`*^9, 3.5451061422266493`*^9, 
   3.5451140205734205`*^9, 3.5528211954218016`*^9, 3.552822659532173*^9, 
   3.5528227955020123`*^9, 3.552822986681348*^9, 3.5528231958777156`*^9, 
   3.5528236662185416`*^9, 3.552823971168877*^9, 3.5528261166260457`*^9, 
   3.552826309287384*^9, 3.554207271336712*^9, 3.5542084668468113`*^9, 
   3.5613716974352193`*^9, 3.561732586327607*^9, 3.561779198364607*^9, 
   3.5617814879670286`*^9, 3.561781561957958*^9, 3.5617816529217176`*^9, 
   3.5617819012741547`*^9, 3.561781933675411*^9, 3.5617821014079056`*^9, 
   3.5617821946492696`*^9, 3.561782388074009*^9, 3.561782492562993*^9, 
   3.5617825257130513`*^9, 3.561784234167652*^9, 3.5627666270141516`*^9, 
   3.5627667438427563`*^9, 3.5627670822697515`*^9, 3.562767893144575*^9, 
   3.562769545796878*^9, 3.5627696677110925`*^9, {3.5627711276260567`*^9, 
   3.562771147063691*^9}, 3.562773114181346*^9, 3.5627732020563*^9, 
   3.5628212717716117`*^9, 3.562822345818898*^9, 3.562823597723097*^9, 
   3.5628236609812083`*^9, 3.5628240618239126`*^9, 3.562824598637455*^9, 
   3.5628252433865876`*^9, 3.562825311761508*^9, 3.562825371806013*^9, 
   3.562825959194845*^9, 3.5628261338527517`*^9, 3.562826247904552*^9, 
   3.5628280657185726`*^9, 3.5628285638898478`*^9, 3.562828736504151*^9, 
   3.5628288786984005`*^9, 3.56283048949683*^9, 3.5628313051442623`*^9, 
   3.5628316998415556`*^9, 3.5628318197277665`*^9, 3.5628318516454225`*^9, 
   3.5628323081802244`*^9, 3.5628324215456233`*^9, 3.5628327291781635`*^9, 
   3.562833669814016*^9, 3.5628337642409816`*^9, 3.5628338348467054`*^9, 
   3.563425632980192*^9, 3.5634263671330814`*^9, 3.563427213529168*^9, 
   3.5634286993859777`*^9, 3.56342879144174*^9, 3.563428870143878*^9, 
   3.563429666479477*^9, 3.5641236126968374`*^9, 3.5641243458523254`*^9, 
   3.5641248624014325`*^9, 3.5641250176227055`*^9, 3.5641304420898333`*^9, 
   3.5646350262366266`*^9, 3.5646354978254547`*^9, 3.56467212978749*^9, 
   3.565759287764366*^9, 3.5657736669648347`*^9, 3.5658920235955*^9, 
   3.5661948526742287`*^9, 3.566203971352671*^9, 3.5662119037940655`*^9, 
   3.5662126406527605`*^9, 3.566214734004837*^9, 3.5663991503037367`*^9, 
   3.56654371253712*^9, 3.567082814807329*^9, 3.5671851370203805`*^9, 
   3.5675865229115*^9, 3.567600479600524*^9, 3.5678594381939497`*^9, 
   3.567860570772539*^9, 3.5678613068452325`*^9, 3.5678615199572067`*^9, 
   3.567861619048581*^9, 3.567861715815551*^9, 3.5678618101177163`*^9, 
   3.5678620356317124`*^9, 3.5678622047516093`*^9, 3.567862536440392*^9, 
   3.5678626834706507`*^9, 3.5678627712988043`*^9, 3.5678633202949686`*^9, 
   3.5678634149403353`*^9, 3.567863936574051*^9, 3.567864088753319*^9, 
   3.5678642537860084`*^9, 3.5678647669801097`*^9, 3.567865015816147*^9, 
   3.567865314837472*^9, 3.5678655286212473`*^9, 3.56787745385496*^9, 
   3.5679119479404917`*^9, 3.5679130624376493`*^9, 3.5679169100195856`*^9, 
   3.5679176765113316`*^9, 3.567918361150734*^9, 3.5679186147915792`*^9, 
   3.567919444681837*^9, 3.5679197567447853`*^9, 3.5679242578890915`*^9, 
   3.5679261750866594`*^9, 3.5679264768847895`*^9, 3.5679268614566646`*^9, 
   3.567929473936054*^9, 3.567929590686659*^9, 3.5679296721344023`*^9, 
   3.567929856308326*^9, 3.5679300833677244`*^9, 3.567930174908685*^9, 
   3.5679303366497693`*^9, 3.567930622504671*^9, 3.567931058541037*^9, 
   3.5679312105477037`*^9, 3.567931331603917*^9, 3.5679314669965544`*^9, 
   3.5679315200376477`*^9, 3.5679316258214335`*^9, 3.5679319502864037`*^9, 
   3.5679326316332*^9, 3.56793275120741*^9, 3.567933125749468*^9, 
   3.5679332329996567`*^9, 3.567933464176462*^9, 3.5679347101828513`*^9, 
   3.5679359720232677`*^9, 3.568115004553556*^9, 3.568115908404544*^9, 
   3.5681222531580877`*^9, 3.5681223552758675`*^9, 3.568123412287924*^9, 
   3.568895116739812*^9, 3.5688954833872557`*^9, {3.5703549462170115`*^9, 
   3.5703549591338344`*^9}, 3.570357327359394*^9, 3.5703574465758033`*^9, 
   3.570357533202756*^9, 3.5703576111092925`*^9, 3.5703577470021315`*^9, 
   3.5703578048626328`*^9, 3.5703578501495123`*^9, 3.5703579051552086`*^9, 
   3.57035793992767*^9, 3.570358003887782*^9, 3.5703582327713842`*^9, 
   3.570358628356879*^9, 3.5703592170717134`*^9, 3.5703593076610727`*^9, 
   3.5703598584356394`*^9, 3.570360128456514*^9, 3.5703609977222404`*^9, 
   3.57036107700158*^9, 3.570361215935424*^9, 3.570361488155902*^9, 
   3.5703615690576444`*^9, 3.570361669709021*^9, 3.570361878780588*^9, 
   3.570362844813285*^9, 3.5703630119363785`*^9, 3.570363150433422*^9, 
   3.5703632389011774`*^9, 3.5703632998816843`*^9, 3.570363362188194*^9, 
   3.570363557297736*^9, 3.5703640865130663`*^9, 3.570364165698805*^9, 
   3.5703643668777585`*^9, 3.570364472957945*^9, 3.570364558570895*^9, 
   3.5703647243367863`*^9, 3.5703648628806295`*^9, 3.570364933938754*^9, 
   3.5703650449485493`*^9, {3.5703653939991627`*^9, 3.57036540396758*^9}, 
   3.570365463497285*^9, 3.570365727527748*^9, 3.5703657916282606`*^9, {
   3.5703658554635735`*^9, 3.5703658744644065`*^9}, 3.570365937550917*^9, 
   3.570365989124608*^9, 3.570366096843797*^9, 3.570366176591137*^9, 
   3.570366233250437*^9, 3.5703662975537496`*^9, 3.5703663396114235`*^9, 
   3.5703664064731407`*^9, 3.570366437813596*^9, 3.5703665736430345`*^9, 
   3.5703669462652893`*^9, 3.5703672460666156`*^9, 3.570367400974888*^9, 
   3.570367495667054*^9, 3.57036776096212*^9, 3.5703678086202035`*^9, 
   3.570367865154703*^9, 3.57036855806112*^9, 3.570368639914464*^9, 
   3.5703687835439157`*^9, 3.570368870607669*^9, 3.570368931073375*^9, 
   3.570426911265374*^9, 3.570427528152858*^9, 3.57042759776118*^9, 
   3.570427667618103*^9, 3.5704277544946556`*^9, 3.570431941169609*^9, 
   3.570432183640835*^9, 3.5704330981310415`*^9, 3.570436514606758*^9, 
   3.5704380390726357`*^9, 3.5704381714242687`*^9, 3.5704382601260242`*^9, 
   3.570438351822985*^9, 3.5704385726881733`*^9, 3.570438756596896*^9, 
   3.5704388126165943`*^9, 3.5769885490650544`*^9, 3.576989664858014*^9, 
   3.5769897136705*^9, 3.576989756508175*^9, 3.5769897970370464`*^9, 
   3.576990134528039*^9, 3.576990315035956*^9, 3.576990361633238*^9, 
   3.57699052775793*^9, 3.5769913891724434`*^9, 3.576991612830036*^9, 
   3.5769924513637085`*^9, 3.5769928131439443`*^9, 3.576993354808096*^9, 
   3.576993431872231*^9, 3.576993736181966*^9, 3.5769941744813356`*^9, 
   3.576995106551772*^9, 3.576995250337225*^9, 3.5844271627536263`*^9, 
   3.58442729568146*^9, 3.584427397518439*^9, 3.584427667289713*^9, 
   3.584427731717826*^9, 3.584428022269336*^9, 3.58442806420221*^9, 
   3.584428468180519*^9, 3.584428589236732*^9, 3.584428768638047*^9, 
   3.58442924292568*^9, 3.5844293237806225`*^9, 3.5844293647306943`*^9, 
   3.5844294268968034`*^9, 3.584429592881095*^9, 3.5844299883115897`*^9, 
   3.5844315096896615`*^9, 3.5844319827146926`*^9, 3.607069912704092*^9, 
   3.607071269922491*^9, 3.60707140497268*^9, 3.607071524262847*^9, 
   3.6070715703229113`*^9, 3.6070728160456553`*^9, 3.6070729097857866`*^9, 
   3.6070824775762916`*^9, 3.607083195367296*^9, 3.607083375787549*^9, 
   3.607083506597732*^9, 3.6070842325297484`*^9, 3.607084313659862*^9, 
   3.6070845155201445`*^9, 3.60708495542076*^9, 3.6070850113108387`*^9, 
   3.607085775102908*^9, 3.607085872883045*^9, 3.607085967053177*^9, 
   3.6070862487935715`*^9, 3.607087539466378*^9, 3.6070879185169086`*^9, 
   3.6070880693071203`*^9, 3.6070886287879033`*^9, 3.6070895560402017`*^9, 
   3.6070896266003003`*^9, 3.607092624591666*^9, 3.6190819466887994`*^9, 
   3.619084939655472*^9, 3.6229569244206305`*^9, {3.6426665133480115`*^9, 
   3.6426665139680123`*^9}, {3.6427581834118166`*^9, 3.6427581927718296`*^9}, 
   3.6433505212173853`*^9, 3.6439958609873075`*^9, 3.6439959289274025`*^9, 
   3.644035933015197*^9, 3.6440360525153637`*^9, 3.6440365357370405`*^9, 
   3.644036618847157*^9, 3.644037758129752*^9, 3.645004836581741*^9, 
   3.645010390653708*^9, 3.6450108496553507`*^9, 3.646371251119275*^9, 
   3.64725463859212*^9, 3.64725496028452*^9, 3.647255874157791*^9, 
   3.647256112551426*^9, 3.6472562969889755`*^9, {3.6472563836229305`*^9, 
   3.6472564127175946`*^9}, {3.647328712551224*^9, 3.6473287276712456`*^9}, {
   3.648264221214368*^9, 3.648264225323965*^9}, {3.6482650367397184`*^9, 
   3.648265041168282*^9}, 3.6483501735142465`*^9, 3.649002741276105*^9, 
   3.6491724523863544`*^9, 3.649214295992588*^9, 3.649214330842637*^9, 
   3.6799843385018797`*^9, 3.697546182811085*^9, 3.697546232832156*^9, 
   3.728207785387721*^9, 3.7282080644696145`*^9, 3.72820963292352*^9, 
   3.728209699693875*^9, 3.7287924302399797`*^9, {3.83915062321275*^9, 
   3.839150646606965*^9}, 3.8391507139358187`*^9, 3.839150750906266*^9, 
   3.8391509003767357`*^9, 3.8396764002848873`*^9, 3.839676444993689*^9, 
   3.84002763741942*^9, 3.8400283710102825`*^9, 3.840029049687272*^9, 
   3.8449217772709084`*^9, 3.863080460971649*^9, 3.863170694882799*^9, {
   3.9583842360077057`*^9, 3.9583842658535366`*^9}},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"981b315a-0283-3946-8e25-c21f1023ae41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SymSpin`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.1.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "6", ",", "8"}], "}"}]}],
  SequenceForm["Package xAct`SymSpin`  version ", "0.1.3", ", ", {2025, 6, 8}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520174849509264*^9, 3.5201755960989656`*^9, 3.520175968590816*^9, 
   3.520176096258639*^9, 3.5201762704681425`*^9, 3.520176756057991*^9, 
   3.5201779236516304`*^9, 3.520177973427715*^9, 3.5201780339410205`*^9, 
   3.5201781232217736`*^9, 3.520178324027721*^9, 3.52017901033572*^9, 
   3.5201791108454947`*^9, 3.5201791936240377`*^9, 3.5201792382921157`*^9, 
   3.520179284833394*^9, 3.520179463876904*^9, 3.520179551655855*^9, 
   3.5201813601618013`*^9, 3.5201816366154847`*^9, 3.5202685625118937`*^9, 
   3.520268730947734*^9, 3.5202688625719223`*^9, 3.5202688996803756`*^9, 
   3.5202690919982476`*^9, 3.520271814190901*^9, 3.520310605197149*^9, 
   3.5203109866249046`*^9, 3.520311787180435*^9, 3.5203121049047127`*^9, {
   3.5271449361606693`*^9, 3.527144937439872*^9}, 3.5271458083914013`*^9, 
   3.5271460019419413`*^9, 3.527147022965735*^9, 3.5271475939589376`*^9, 
   3.5271480468755336`*^9, 3.527148264183915*^9, 3.52714868648586*^9, 
   3.5271500507716565`*^9, 3.527150172997871*^9, 3.5271503536149883`*^9, 
   3.527150507556059*^9, 3.5271507919913583`*^9, 3.5271508653426867`*^9, 
   3.529230823877325*^9, 3.529232467059411*^9, 3.529232571751195*^9, 
   3.5292359095068574`*^9, 3.5292362175137987`*^9, 3.529236417194149*^9, 
   3.5292366545797663`*^9, 3.529236716075074*^9, 3.529236967176115*^9, 
   3.529237057671874*^9, 3.5340685699417896`*^9, 3.53406895170566*^9, 
   3.534069382718817*^9, 3.534069951854617*^9, 3.5340701769318123`*^9, 
   3.5342496371721635`*^9, 3.537621498672197*^9, 3.5376216251884193`*^9, 
   3.5376228419447565`*^9, {3.537622948446143*^9, 3.537622964373771*^9}, 
   3.5376231829301553`*^9, 3.537623361519269*^9, 3.5376254399285192`*^9, 
   3.5376287896154747`*^9, 3.53769469982747*^9, 3.5376948677461653`*^9, 
   3.537695501762479*^9, 3.5376955815566187`*^9, 3.537695913229801*^9, 
   3.537696395239448*^9, 3.5376971050104947`*^9, 3.5376974604259186`*^9, {
   3.537697970624815*^9, 3.5376979912324514`*^9}, 3.537700570638586*^9, 
   3.5377009886725206`*^9, 3.5377011498208036`*^9, 3.537705075508299*^9, 
   3.5377676499514885`*^9, 3.537780185987508*^9, 3.5377805838974066`*^9, 
   3.5377809208901987`*^9, 3.5377810799168777`*^9, 3.5377812420011625`*^9, 
   3.5377813781426015`*^9, 3.537781527200863*^9, 3.5377817255864115`*^9, 
   3.537782399040595*^9, 3.5377827398387933`*^9, 3.5377829310015287`*^9, 
   3.537783191740387*^9, 3.537783440546224*^9, 3.5377835728656564`*^9, 
   3.537784107868596*^9, 3.5377842446964364`*^9, 3.544092209221161*^9, 
   3.544097239984397*^9, 3.5440973654710174`*^9, 3.544097952797449*^9, 
   3.544099754133613*^9, 3.5441033727023687`*^9, 3.544103463868929*^9, 
   3.544103705030752*^9, 3.5441039174563255`*^9, 3.5441040518505616`*^9, 
   3.544105099611802*^9, 3.5441057142684813`*^9, 3.544105949064494*^9, 
   3.544107147443999*^9, 3.544591253200247*^9, 3.5445914903948135`*^9, 
   3.5445916527811017`*^9, 3.5445929046057014`*^9, 3.5446721730552063`*^9, 
   3.5446723745247297`*^9, 3.544673273684159*^9, {3.5446733821943655`*^9, 
   3.5446734029125504`*^9}, 3.5449492188490252`*^9, 3.544951614114234*^9, 
   3.5450156626813335`*^9, 3.5450157245042424`*^9, 3.5451061422266493`*^9, 
   3.5451140205734205`*^9, 3.5528211954218016`*^9, 3.552822659532173*^9, 
   3.5528227955020123`*^9, 3.552822986681348*^9, 3.5528231958777156`*^9, 
   3.5528236662185416`*^9, 3.552823971168877*^9, 3.5528261166260457`*^9, 
   3.552826309287384*^9, 3.554207271336712*^9, 3.5542084668468113`*^9, 
   3.5613716974352193`*^9, 3.561732586327607*^9, 3.561779198364607*^9, 
   3.5617814879670286`*^9, 3.561781561957958*^9, 3.5617816529217176`*^9, 
   3.5617819012741547`*^9, 3.561781933675411*^9, 3.5617821014079056`*^9, 
   3.5617821946492696`*^9, 3.561782388074009*^9, 3.561782492562993*^9, 
   3.5617825257130513`*^9, 3.561784234167652*^9, 3.5627666270141516`*^9, 
   3.5627667438427563`*^9, 3.5627670822697515`*^9, 3.562767893144575*^9, 
   3.562769545796878*^9, 3.5627696677110925`*^9, {3.5627711276260567`*^9, 
   3.562771147063691*^9}, 3.562773114181346*^9, 3.5627732020563*^9, 
   3.5628212717716117`*^9, 3.562822345818898*^9, 3.562823597723097*^9, 
   3.5628236609812083`*^9, 3.5628240618239126`*^9, 3.562824598637455*^9, 
   3.5628252433865876`*^9, 3.562825311761508*^9, 3.562825371806013*^9, 
   3.562825959194845*^9, 3.5628261338527517`*^9, 3.562826247904552*^9, 
   3.5628280657185726`*^9, 3.5628285638898478`*^9, 3.562828736504151*^9, 
   3.5628288786984005`*^9, 3.56283048949683*^9, 3.5628313051442623`*^9, 
   3.5628316998415556`*^9, 3.5628318197277665`*^9, 3.5628318516454225`*^9, 
   3.5628323081802244`*^9, 3.5628324215456233`*^9, 3.5628327291781635`*^9, 
   3.562833669814016*^9, 3.5628337642409816`*^9, 3.5628338348467054`*^9, 
   3.563425632980192*^9, 3.5634263671330814`*^9, 3.563427213529168*^9, 
   3.5634286993859777`*^9, 3.56342879144174*^9, 3.563428870143878*^9, 
   3.563429666479477*^9, 3.5641236126968374`*^9, 3.5641243458523254`*^9, 
   3.5641248624014325`*^9, 3.5641250176227055`*^9, 3.5641304420898333`*^9, 
   3.5646350262366266`*^9, 3.5646354978254547`*^9, 3.56467212978749*^9, 
   3.565759287764366*^9, 3.5657736669648347`*^9, 3.5658920235955*^9, 
   3.5661948526742287`*^9, 3.566203971352671*^9, 3.5662119037940655`*^9, 
   3.5662126406527605`*^9, 3.566214734004837*^9, 3.5663991503037367`*^9, 
   3.56654371253712*^9, 3.567082814807329*^9, 3.5671851370203805`*^9, 
   3.5675865229115*^9, 3.567600479600524*^9, 3.5678594381939497`*^9, 
   3.567860570772539*^9, 3.5678613068452325`*^9, 3.5678615199572067`*^9, 
   3.567861619048581*^9, 3.567861715815551*^9, 3.5678618101177163`*^9, 
   3.5678620356317124`*^9, 3.5678622047516093`*^9, 3.567862536440392*^9, 
   3.5678626834706507`*^9, 3.5678627712988043`*^9, 3.5678633202949686`*^9, 
   3.5678634149403353`*^9, 3.567863936574051*^9, 3.567864088753319*^9, 
   3.5678642537860084`*^9, 3.5678647669801097`*^9, 3.567865015816147*^9, 
   3.567865314837472*^9, 3.5678655286212473`*^9, 3.56787745385496*^9, 
   3.5679119479404917`*^9, 3.5679130624376493`*^9, 3.5679169100195856`*^9, 
   3.5679176765113316`*^9, 3.567918361150734*^9, 3.5679186147915792`*^9, 
   3.567919444681837*^9, 3.5679197567447853`*^9, 3.5679242578890915`*^9, 
   3.5679261750866594`*^9, 3.5679264768847895`*^9, 3.5679268614566646`*^9, 
   3.567929473936054*^9, 3.567929590686659*^9, 3.5679296721344023`*^9, 
   3.567929856308326*^9, 3.5679300833677244`*^9, 3.567930174908685*^9, 
   3.5679303366497693`*^9, 3.567930622504671*^9, 3.567931058541037*^9, 
   3.5679312105477037`*^9, 3.567931331603917*^9, 3.5679314669965544`*^9, 
   3.5679315200376477`*^9, 3.5679316258214335`*^9, 3.5679319502864037`*^9, 
   3.5679326316332*^9, 3.56793275120741*^9, 3.567933125749468*^9, 
   3.5679332329996567`*^9, 3.567933464176462*^9, 3.5679347101828513`*^9, 
   3.5679359720232677`*^9, 3.568115004553556*^9, 3.568115908404544*^9, 
   3.5681222531580877`*^9, 3.5681223552758675`*^9, 3.568123412287924*^9, 
   3.568895116739812*^9, 3.5688954833872557`*^9, {3.5703549462170115`*^9, 
   3.5703549591338344`*^9}, 3.570357327359394*^9, 3.5703574465758033`*^9, 
   3.570357533202756*^9, 3.5703576111092925`*^9, 3.5703577470021315`*^9, 
   3.5703578048626328`*^9, 3.5703578501495123`*^9, 3.5703579051552086`*^9, 
   3.57035793992767*^9, 3.570358003887782*^9, 3.5703582327713842`*^9, 
   3.570358628356879*^9, 3.5703592170717134`*^9, 3.5703593076610727`*^9, 
   3.5703598584356394`*^9, 3.570360128456514*^9, 3.5703609977222404`*^9, 
   3.57036107700158*^9, 3.570361215935424*^9, 3.570361488155902*^9, 
   3.5703615690576444`*^9, 3.570361669709021*^9, 3.570361878780588*^9, 
   3.570362844813285*^9, 3.5703630119363785`*^9, 3.570363150433422*^9, 
   3.5703632389011774`*^9, 3.5703632998816843`*^9, 3.570363362188194*^9, 
   3.570363557297736*^9, 3.5703640865130663`*^9, 3.570364165698805*^9, 
   3.5703643668777585`*^9, 3.570364472957945*^9, 3.570364558570895*^9, 
   3.5703647243367863`*^9, 3.5703648628806295`*^9, 3.570364933938754*^9, 
   3.5703650449485493`*^9, {3.5703653939991627`*^9, 3.57036540396758*^9}, 
   3.570365463497285*^9, 3.570365727527748*^9, 3.5703657916282606`*^9, {
   3.5703658554635735`*^9, 3.5703658744644065`*^9}, 3.570365937550917*^9, 
   3.570365989124608*^9, 3.570366096843797*^9, 3.570366176591137*^9, 
   3.570366233250437*^9, 3.5703662975537496`*^9, 3.5703663396114235`*^9, 
   3.5703664064731407`*^9, 3.570366437813596*^9, 3.5703665736430345`*^9, 
   3.5703669462652893`*^9, 3.5703672460666156`*^9, 3.570367400974888*^9, 
   3.570367495667054*^9, 3.57036776096212*^9, 3.5703678086202035`*^9, 
   3.570367865154703*^9, 3.57036855806112*^9, 3.570368639914464*^9, 
   3.5703687835439157`*^9, 3.570368870607669*^9, 3.570368931073375*^9, 
   3.570426911265374*^9, 3.570427528152858*^9, 3.57042759776118*^9, 
   3.570427667618103*^9, 3.5704277544946556`*^9, 3.570431941169609*^9, 
   3.570432183640835*^9, 3.5704330981310415`*^9, 3.570436514606758*^9, 
   3.5704380390726357`*^9, 3.5704381714242687`*^9, 3.5704382601260242`*^9, 
   3.570438351822985*^9, 3.5704385726881733`*^9, 3.570438756596896*^9, 
   3.5704388126165943`*^9, 3.5769885490650544`*^9, 3.576989664858014*^9, 
   3.5769897136705*^9, 3.576989756508175*^9, 3.5769897970370464`*^9, 
   3.576990134528039*^9, 3.576990315035956*^9, 3.576990361633238*^9, 
   3.57699052775793*^9, 3.5769913891724434`*^9, 3.576991612830036*^9, 
   3.5769924513637085`*^9, 3.5769928131439443`*^9, 3.576993354808096*^9, 
   3.576993431872231*^9, 3.576993736181966*^9, 3.5769941744813356`*^9, 
   3.576995106551772*^9, 3.576995250337225*^9, 3.5844271627536263`*^9, 
   3.58442729568146*^9, 3.584427397518439*^9, 3.584427667289713*^9, 
   3.584427731717826*^9, 3.584428022269336*^9, 3.58442806420221*^9, 
   3.584428468180519*^9, 3.584428589236732*^9, 3.584428768638047*^9, 
   3.58442924292568*^9, 3.5844293237806225`*^9, 3.5844293647306943`*^9, 
   3.5844294268968034`*^9, 3.584429592881095*^9, 3.5844299883115897`*^9, 
   3.5844315096896615`*^9, 3.5844319827146926`*^9, 3.607069912704092*^9, 
   3.607071269922491*^9, 3.60707140497268*^9, 3.607071524262847*^9, 
   3.6070715703229113`*^9, 3.6070728160456553`*^9, 3.6070729097857866`*^9, 
   3.6070824775762916`*^9, 3.607083195367296*^9, 3.607083375787549*^9, 
   3.607083506597732*^9, 3.6070842325297484`*^9, 3.607084313659862*^9, 
   3.6070845155201445`*^9, 3.60708495542076*^9, 3.6070850113108387`*^9, 
   3.607085775102908*^9, 3.607085872883045*^9, 3.607085967053177*^9, 
   3.6070862487935715`*^9, 3.607087539466378*^9, 3.6070879185169086`*^9, 
   3.6070880693071203`*^9, 3.6070886287879033`*^9, 3.6070895560402017`*^9, 
   3.6070896266003003`*^9, 3.607092624591666*^9, 3.6190819466887994`*^9, 
   3.619084939655472*^9, 3.6229569244206305`*^9, {3.6426665133480115`*^9, 
   3.6426665139680123`*^9}, {3.6427581834118166`*^9, 3.6427581927718296`*^9}, 
   3.6433505212173853`*^9, 3.6439958609873075`*^9, 3.6439959289274025`*^9, 
   3.644035933015197*^9, 3.6440360525153637`*^9, 3.6440365357370405`*^9, 
   3.644036618847157*^9, 3.644037758129752*^9, 3.645004836581741*^9, 
   3.645010390653708*^9, 3.6450108496553507`*^9, 3.646371251119275*^9, 
   3.64725463859212*^9, 3.64725496028452*^9, 3.647255874157791*^9, 
   3.647256112551426*^9, 3.6472562969889755`*^9, {3.6472563836229305`*^9, 
   3.6472564127175946`*^9}, {3.647328712551224*^9, 3.6473287276712456`*^9}, {
   3.648264221214368*^9, 3.648264225323965*^9}, {3.6482650367397184`*^9, 
   3.648265041168282*^9}, 3.6483501735142465`*^9, 3.649002741276105*^9, 
   3.6491724523863544`*^9, 3.649214295992588*^9, 3.649214330842637*^9, 
   3.6799843385018797`*^9, 3.697546182811085*^9, 3.697546232832156*^9, 
   3.728207785387721*^9, 3.7282080644696145`*^9, 3.72820963292352*^9, 
   3.728209699693875*^9, 3.7287924302399797`*^9, {3.83915062321275*^9, 
   3.839150646606965*^9}, 3.8391507139358187`*^9, 3.839150750906266*^9, 
   3.8391509003767357`*^9, 3.8396764002848873`*^9, 3.839676444993689*^9, 
   3.84002763741942*^9, 3.8400283710102825`*^9, 3.840029049687272*^9, 
   3.8449217772709084`*^9, 3.863080460971649*^9, 3.863170694882799*^9, {
   3.9583842360077057`*^9, 3.9583842658535366`*^9}},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"d9f88489-0402-0740-9fbe-50d20da7d7ce"],

Cell[BoxData["\<\"CopyRight (C) 2021, Steffen Aksteiner and Thomas B\
\[ADoubleDot]ckdahl, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.520174849509264*^9, 3.5201755960989656`*^9, 3.520175968590816*^9, 
   3.520176096258639*^9, 3.5201762704681425`*^9, 3.520176756057991*^9, 
   3.5201779236516304`*^9, 3.520177973427715*^9, 3.5201780339410205`*^9, 
   3.5201781232217736`*^9, 3.520178324027721*^9, 3.52017901033572*^9, 
   3.5201791108454947`*^9, 3.5201791936240377`*^9, 3.5201792382921157`*^9, 
   3.520179284833394*^9, 3.520179463876904*^9, 3.520179551655855*^9, 
   3.5201813601618013`*^9, 3.5201816366154847`*^9, 3.5202685625118937`*^9, 
   3.520268730947734*^9, 3.5202688625719223`*^9, 3.5202688996803756`*^9, 
   3.5202690919982476`*^9, 3.520271814190901*^9, 3.520310605197149*^9, 
   3.5203109866249046`*^9, 3.520311787180435*^9, 3.5203121049047127`*^9, {
   3.5271449361606693`*^9, 3.527144937439872*^9}, 3.5271458083914013`*^9, 
   3.5271460019419413`*^9, 3.527147022965735*^9, 3.5271475939589376`*^9, 
   3.5271480468755336`*^9, 3.527148264183915*^9, 3.52714868648586*^9, 
   3.5271500507716565`*^9, 3.527150172997871*^9, 3.5271503536149883`*^9, 
   3.527150507556059*^9, 3.5271507919913583`*^9, 3.5271508653426867`*^9, 
   3.529230823877325*^9, 3.529232467059411*^9, 3.529232571751195*^9, 
   3.5292359095068574`*^9, 3.5292362175137987`*^9, 3.529236417194149*^9, 
   3.5292366545797663`*^9, 3.529236716075074*^9, 3.529236967176115*^9, 
   3.529237057671874*^9, 3.5340685699417896`*^9, 3.53406895170566*^9, 
   3.534069382718817*^9, 3.534069951854617*^9, 3.5340701769318123`*^9, 
   3.5342496371721635`*^9, 3.537621498672197*^9, 3.5376216251884193`*^9, 
   3.5376228419447565`*^9, {3.537622948446143*^9, 3.537622964373771*^9}, 
   3.5376231829301553`*^9, 3.537623361519269*^9, 3.5376254399285192`*^9, 
   3.5376287896154747`*^9, 3.53769469982747*^9, 3.5376948677461653`*^9, 
   3.537695501762479*^9, 3.5376955815566187`*^9, 3.537695913229801*^9, 
   3.537696395239448*^9, 3.5376971050104947`*^9, 3.5376974604259186`*^9, {
   3.537697970624815*^9, 3.5376979912324514`*^9}, 3.537700570638586*^9, 
   3.5377009886725206`*^9, 3.5377011498208036`*^9, 3.537705075508299*^9, 
   3.5377676499514885`*^9, 3.537780185987508*^9, 3.5377805838974066`*^9, 
   3.5377809208901987`*^9, 3.5377810799168777`*^9, 3.5377812420011625`*^9, 
   3.5377813781426015`*^9, 3.537781527200863*^9, 3.5377817255864115`*^9, 
   3.537782399040595*^9, 3.5377827398387933`*^9, 3.5377829310015287`*^9, 
   3.537783191740387*^9, 3.537783440546224*^9, 3.5377835728656564`*^9, 
   3.537784107868596*^9, 3.5377842446964364`*^9, 3.544092209221161*^9, 
   3.544097239984397*^9, 3.5440973654710174`*^9, 3.544097952797449*^9, 
   3.544099754133613*^9, 3.5441033727023687`*^9, 3.544103463868929*^9, 
   3.544103705030752*^9, 3.5441039174563255`*^9, 3.5441040518505616`*^9, 
   3.544105099611802*^9, 3.5441057142684813`*^9, 3.544105949064494*^9, 
   3.544107147443999*^9, 3.544591253200247*^9, 3.5445914903948135`*^9, 
   3.5445916527811017`*^9, 3.5445929046057014`*^9, 3.5446721730552063`*^9, 
   3.5446723745247297`*^9, 3.544673273684159*^9, {3.5446733821943655`*^9, 
   3.5446734029125504`*^9}, 3.5449492188490252`*^9, 3.544951614114234*^9, 
   3.5450156626813335`*^9, 3.5450157245042424`*^9, 3.5451061422266493`*^9, 
   3.5451140205734205`*^9, 3.5528211954218016`*^9, 3.552822659532173*^9, 
   3.5528227955020123`*^9, 3.552822986681348*^9, 3.5528231958777156`*^9, 
   3.5528236662185416`*^9, 3.552823971168877*^9, 3.5528261166260457`*^9, 
   3.552826309287384*^9, 3.554207271336712*^9, 3.5542084668468113`*^9, 
   3.5613716974352193`*^9, 3.561732586327607*^9, 3.561779198364607*^9, 
   3.5617814879670286`*^9, 3.561781561957958*^9, 3.5617816529217176`*^9, 
   3.5617819012741547`*^9, 3.561781933675411*^9, 3.5617821014079056`*^9, 
   3.5617821946492696`*^9, 3.561782388074009*^9, 3.561782492562993*^9, 
   3.5617825257130513`*^9, 3.561784234167652*^9, 3.5627666270141516`*^9, 
   3.5627667438427563`*^9, 3.5627670822697515`*^9, 3.562767893144575*^9, 
   3.562769545796878*^9, 3.5627696677110925`*^9, {3.5627711276260567`*^9, 
   3.562771147063691*^9}, 3.562773114181346*^9, 3.5627732020563*^9, 
   3.5628212717716117`*^9, 3.562822345818898*^9, 3.562823597723097*^9, 
   3.5628236609812083`*^9, 3.5628240618239126`*^9, 3.562824598637455*^9, 
   3.5628252433865876`*^9, 3.562825311761508*^9, 3.562825371806013*^9, 
   3.562825959194845*^9, 3.5628261338527517`*^9, 3.562826247904552*^9, 
   3.5628280657185726`*^9, 3.5628285638898478`*^9, 3.562828736504151*^9, 
   3.5628288786984005`*^9, 3.56283048949683*^9, 3.5628313051442623`*^9, 
   3.5628316998415556`*^9, 3.5628318197277665`*^9, 3.5628318516454225`*^9, 
   3.5628323081802244`*^9, 3.5628324215456233`*^9, 3.5628327291781635`*^9, 
   3.562833669814016*^9, 3.5628337642409816`*^9, 3.5628338348467054`*^9, 
   3.563425632980192*^9, 3.5634263671330814`*^9, 3.563427213529168*^9, 
   3.5634286993859777`*^9, 3.56342879144174*^9, 3.563428870143878*^9, 
   3.563429666479477*^9, 3.5641236126968374`*^9, 3.5641243458523254`*^9, 
   3.5641248624014325`*^9, 3.5641250176227055`*^9, 3.5641304420898333`*^9, 
   3.5646350262366266`*^9, 3.5646354978254547`*^9, 3.56467212978749*^9, 
   3.565759287764366*^9, 3.5657736669648347`*^9, 3.5658920235955*^9, 
   3.5661948526742287`*^9, 3.566203971352671*^9, 3.5662119037940655`*^9, 
   3.5662126406527605`*^9, 3.566214734004837*^9, 3.5663991503037367`*^9, 
   3.56654371253712*^9, 3.567082814807329*^9, 3.5671851370203805`*^9, 
   3.5675865229115*^9, 3.567600479600524*^9, 3.5678594381939497`*^9, 
   3.567860570772539*^9, 3.5678613068452325`*^9, 3.5678615199572067`*^9, 
   3.567861619048581*^9, 3.567861715815551*^9, 3.5678618101177163`*^9, 
   3.5678620356317124`*^9, 3.5678622047516093`*^9, 3.567862536440392*^9, 
   3.5678626834706507`*^9, 3.5678627712988043`*^9, 3.5678633202949686`*^9, 
   3.5678634149403353`*^9, 3.567863936574051*^9, 3.567864088753319*^9, 
   3.5678642537860084`*^9, 3.5678647669801097`*^9, 3.567865015816147*^9, 
   3.567865314837472*^9, 3.5678655286212473`*^9, 3.56787745385496*^9, 
   3.5679119479404917`*^9, 3.5679130624376493`*^9, 3.5679169100195856`*^9, 
   3.5679176765113316`*^9, 3.567918361150734*^9, 3.5679186147915792`*^9, 
   3.567919444681837*^9, 3.5679197567447853`*^9, 3.5679242578890915`*^9, 
   3.5679261750866594`*^9, 3.5679264768847895`*^9, 3.5679268614566646`*^9, 
   3.567929473936054*^9, 3.567929590686659*^9, 3.5679296721344023`*^9, 
   3.567929856308326*^9, 3.5679300833677244`*^9, 3.567930174908685*^9, 
   3.5679303366497693`*^9, 3.567930622504671*^9, 3.567931058541037*^9, 
   3.5679312105477037`*^9, 3.567931331603917*^9, 3.5679314669965544`*^9, 
   3.5679315200376477`*^9, 3.5679316258214335`*^9, 3.5679319502864037`*^9, 
   3.5679326316332*^9, 3.56793275120741*^9, 3.567933125749468*^9, 
   3.5679332329996567`*^9, 3.567933464176462*^9, 3.5679347101828513`*^9, 
   3.5679359720232677`*^9, 3.568115004553556*^9, 3.568115908404544*^9, 
   3.5681222531580877`*^9, 3.5681223552758675`*^9, 3.568123412287924*^9, 
   3.568895116739812*^9, 3.5688954833872557`*^9, {3.5703549462170115`*^9, 
   3.5703549591338344`*^9}, 3.570357327359394*^9, 3.5703574465758033`*^9, 
   3.570357533202756*^9, 3.5703576111092925`*^9, 3.5703577470021315`*^9, 
   3.5703578048626328`*^9, 3.5703578501495123`*^9, 3.5703579051552086`*^9, 
   3.57035793992767*^9, 3.570358003887782*^9, 3.5703582327713842`*^9, 
   3.570358628356879*^9, 3.5703592170717134`*^9, 3.5703593076610727`*^9, 
   3.5703598584356394`*^9, 3.570360128456514*^9, 3.5703609977222404`*^9, 
   3.57036107700158*^9, 3.570361215935424*^9, 3.570361488155902*^9, 
   3.5703615690576444`*^9, 3.570361669709021*^9, 3.570361878780588*^9, 
   3.570362844813285*^9, 3.5703630119363785`*^9, 3.570363150433422*^9, 
   3.5703632389011774`*^9, 3.5703632998816843`*^9, 3.570363362188194*^9, 
   3.570363557297736*^9, 3.5703640865130663`*^9, 3.570364165698805*^9, 
   3.5703643668777585`*^9, 3.570364472957945*^9, 3.570364558570895*^9, 
   3.5703647243367863`*^9, 3.5703648628806295`*^9, 3.570364933938754*^9, 
   3.5703650449485493`*^9, {3.5703653939991627`*^9, 3.57036540396758*^9}, 
   3.570365463497285*^9, 3.570365727527748*^9, 3.5703657916282606`*^9, {
   3.5703658554635735`*^9, 3.5703658744644065`*^9}, 3.570365937550917*^9, 
   3.570365989124608*^9, 3.570366096843797*^9, 3.570366176591137*^9, 
   3.570366233250437*^9, 3.5703662975537496`*^9, 3.5703663396114235`*^9, 
   3.5703664064731407`*^9, 3.570366437813596*^9, 3.5703665736430345`*^9, 
   3.5703669462652893`*^9, 3.5703672460666156`*^9, 3.570367400974888*^9, 
   3.570367495667054*^9, 3.57036776096212*^9, 3.5703678086202035`*^9, 
   3.570367865154703*^9, 3.57036855806112*^9, 3.570368639914464*^9, 
   3.5703687835439157`*^9, 3.570368870607669*^9, 3.570368931073375*^9, 
   3.570426911265374*^9, 3.570427528152858*^9, 3.57042759776118*^9, 
   3.570427667618103*^9, 3.5704277544946556`*^9, 3.570431941169609*^9, 
   3.570432183640835*^9, 3.5704330981310415`*^9, 3.570436514606758*^9, 
   3.5704380390726357`*^9, 3.5704381714242687`*^9, 3.5704382601260242`*^9, 
   3.570438351822985*^9, 3.5704385726881733`*^9, 3.570438756596896*^9, 
   3.5704388126165943`*^9, 3.5769885490650544`*^9, 3.576989664858014*^9, 
   3.5769897136705*^9, 3.576989756508175*^9, 3.5769897970370464`*^9, 
   3.576990134528039*^9, 3.576990315035956*^9, 3.576990361633238*^9, 
   3.57699052775793*^9, 3.5769913891724434`*^9, 3.576991612830036*^9, 
   3.5769924513637085`*^9, 3.5769928131439443`*^9, 3.576993354808096*^9, 
   3.576993431872231*^9, 3.576993736181966*^9, 3.5769941744813356`*^9, 
   3.576995106551772*^9, 3.576995250337225*^9, 3.5844271627536263`*^9, 
   3.58442729568146*^9, 3.584427397518439*^9, 3.584427667289713*^9, 
   3.584427731717826*^9, 3.584428022269336*^9, 3.58442806420221*^9, 
   3.584428468180519*^9, 3.584428589236732*^9, 3.584428768638047*^9, 
   3.58442924292568*^9, 3.5844293237806225`*^9, 3.5844293647306943`*^9, 
   3.5844294268968034`*^9, 3.584429592881095*^9, 3.5844299883115897`*^9, 
   3.5844315096896615`*^9, 3.5844319827146926`*^9, 3.607069912704092*^9, 
   3.607071269922491*^9, 3.60707140497268*^9, 3.607071524262847*^9, 
   3.6070715703229113`*^9, 3.6070728160456553`*^9, 3.6070729097857866`*^9, 
   3.6070824775762916`*^9, 3.607083195367296*^9, 3.607083375787549*^9, 
   3.607083506597732*^9, 3.6070842325297484`*^9, 3.607084313659862*^9, 
   3.6070845155201445`*^9, 3.60708495542076*^9, 3.6070850113108387`*^9, 
   3.607085775102908*^9, 3.607085872883045*^9, 3.607085967053177*^9, 
   3.6070862487935715`*^9, 3.607087539466378*^9, 3.6070879185169086`*^9, 
   3.6070880693071203`*^9, 3.6070886287879033`*^9, 3.6070895560402017`*^9, 
   3.6070896266003003`*^9, 3.607092624591666*^9, 3.6190819466887994`*^9, 
   3.619084939655472*^9, 3.6229569244206305`*^9, {3.6426665133480115`*^9, 
   3.6426665139680123`*^9}, {3.6427581834118166`*^9, 3.6427581927718296`*^9}, 
   3.6433505212173853`*^9, 3.6439958609873075`*^9, 3.6439959289274025`*^9, 
   3.644035933015197*^9, 3.6440360525153637`*^9, 3.6440365357370405`*^9, 
   3.644036618847157*^9, 3.644037758129752*^9, 3.645004836581741*^9, 
   3.645010390653708*^9, 3.6450108496553507`*^9, 3.646371251119275*^9, 
   3.64725463859212*^9, 3.64725496028452*^9, 3.647255874157791*^9, 
   3.647256112551426*^9, 3.6472562969889755`*^9, {3.6472563836229305`*^9, 
   3.6472564127175946`*^9}, {3.647328712551224*^9, 3.6473287276712456`*^9}, {
   3.648264221214368*^9, 3.648264225323965*^9}, {3.6482650367397184`*^9, 
   3.648265041168282*^9}, 3.6483501735142465`*^9, 3.649002741276105*^9, 
   3.6491724523863544`*^9, 3.649214295992588*^9, 3.649214330842637*^9, 
   3.6799843385018797`*^9, 3.697546182811085*^9, 3.697546232832156*^9, 
   3.728207785387721*^9, 3.7282080644696145`*^9, 3.72820963292352*^9, 
   3.728209699693875*^9, 3.7287924302399797`*^9, {3.83915062321275*^9, 
   3.839150646606965*^9}, 3.8391507139358187`*^9, 3.839150750906266*^9, 
   3.8391509003767357`*^9, 3.8396764002848873`*^9, 3.839676444993689*^9, 
   3.84002763741942*^9, 3.8400283710102825`*^9, 3.840029049687272*^9, 
   3.8449217772709084`*^9, 3.863080460971649*^9, 3.863170694882799*^9, {
   3.9583842360077057`*^9, 3.9583842658535366`*^9}},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"69100a3b-827a-814a-8e45-82df9979169b"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We specify the context xAct`Spinors` to avoid overriding the Disclaimer of \
the other packages. However we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"df7f7f02-31ed-4f7f-b6d1-daaea5984a1e"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`SymSpin`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", 
   "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744758879812*^9, 3.5157447618609824`*^9}, 
   3.5159383434841175`*^9, {3.838819448005977*^9, 3.838819449523918*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"c5505a26-6a6b-4094-b977-0a47d9c5af97"],

Cell[TextData[{
 "If ",
 StyleBox["xSpaceSpinors",
  FontSlant->"Italic"],
 " is not being called from other package then write this GPL short \
disclaimer:"
}], "Text",
 CellChangeTimes->{{3.519296661172683*^9, 3.51929666543149*^9}, {
  3.5703535775476074`*^9, 
  3.5703535804024124`*^9}},ExpressionUUID->"5c10de1c-a608-4908-b83b-\
7ebfc7bd5d06"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
   "xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`SymSpin`\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Print", "[", 
     "\"\<These packages come with ABSOLUTELY NO WARRANTY; for details type \
Disclaimer[]. This is free software, and you are welcome to redistribute it \
under certain conditions. See the General Public License for details.\>\"", 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4232372878945827`*^9, 3.423237289581603*^9}, {
   3.423283390363858*^9, 3.4232834081506033`*^9}, {3.519296677771112*^9, 
   3.5192966829815207`*^9}, 3.570353587422425*^9, {3.6070694657434664`*^9, 
   3.60706946835347*^9}, 3.647254303260352*^9, {3.838697939259162*^9, 
   3.838697943521831*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"d38dc3c0-7f34-45f6-96a7-ffb97dad0214"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.5201748495404644`*^9, 3.5201755961289663`*^9, 3.520175968622016*^9, 
   3.520176096289839*^9, 3.5201762704993424`*^9, 3.5201767560879908`*^9, 
   3.5201779236828303`*^9, 3.5201779734589148`*^9, 3.5201780339722204`*^9, 
   3.520178123251774*^9, 3.520178324058921*^9, 3.52017901036572*^9, 
   3.520179110875495*^9, 3.520179193654038*^9, 3.520179238322116*^9, 
   3.520179284863394*^9, 3.520179463908104*^9, 3.520179551695855*^9, 
   3.520181360208601*^9, 3.5201816366466846`*^9, 3.520268562601894*^9, 
   3.5202687309789333`*^9, 3.5202688626119223`*^9, 3.5202688997115755`*^9, 
   3.520269092038248*^9, 3.520271814240901*^9, 3.520310605227149*^9, 
   3.520310986656105*^9, 3.520311787220435*^9, 3.5203121049347124`*^9, {
   3.5271449362230697`*^9, 3.5271449374710712`*^9}, 3.5271458084226017`*^9, 
   3.5271460019731417`*^9, 3.527147022996935*^9, 3.527147593974538*^9, 
   3.5271480469067335`*^9, 3.5271482641995153`*^9, 3.5271486865170603`*^9, 
   3.5271500508184566`*^9, 3.527150173029071*^9, 3.5271503536305885`*^9, 
   3.5271505075716586`*^9, 3.527150792006958*^9, 3.527150865373887*^9, 
   3.5292308239241247`*^9, 3.5292324671062107`*^9, 3.529232571782395*^9, 
   3.5292359095380573`*^9, 3.529236217544998*^9, 3.5292364172253494`*^9, 
   3.5292366546109657`*^9, 3.529236716121874*^9, 3.5292369672073154`*^9, 
   3.5292370577030745`*^9, 3.5340685699885893`*^9, 3.5340689517524605`*^9, 
   3.5340693827656174`*^9, 3.5340699518858166`*^9, 3.534070176963012*^9, 
   3.534249637234564*^9, 3.537621498718997*^9, 3.537621625219619*^9, 
   3.537622841991556*^9, {3.5376229484929433`*^9, 3.537622964404971*^9}, 
   3.5376231829769554`*^9, 3.5376233615504684`*^9, 3.53762543997532*^9, 
   3.5376287896778746`*^9, 3.5376946998898697`*^9, 3.537694867792965*^9, 
   3.5376955018092785`*^9, 3.537695581603419*^9, 3.5376959132766013`*^9, 
   3.537696395270648*^9, 3.537697105057295*^9, 3.537697460457119*^9, {
   3.5376979706560154`*^9, 3.537697991279251*^9}, 3.5377005707009864`*^9, 
   3.5377009887193203`*^9, 3.5377011498676033`*^9, 3.537705075586299*^9, 
   3.5377676500294886`*^9, 3.5377801860343075`*^9, 3.537780583944206*^9, 
   3.5377809209369984`*^9, 3.537781079948078*^9, 3.537781242047962*^9, 
   3.5377813781738014`*^9, 3.5377815272320633`*^9, 3.537781725617612*^9, 
   3.5377823990717945`*^9, 3.5377827399011936`*^9, 3.5377829310483294`*^9, 
   3.5377831917715874`*^9, 3.5377834405930243`*^9, 3.5377835728968563`*^9, 
   3.537784107915396*^9, 3.5377842447432365`*^9, 3.5440922092835608`*^9, 
   3.5440972403587976`*^9, 3.5440973655022173`*^9, 3.5440979528442492`*^9, 
   3.544099754164813*^9, 3.5441033727647686`*^9, 3.544103463915729*^9, 
   3.544103705077553*^9, 3.5441039175031257`*^9, 3.5441040518817616`*^9, 
   3.5441050996586018`*^9, 3.544105714315282*^9, 3.544105949111294*^9, 
   3.544107147490799*^9, 3.5445912532642508`*^9, 3.544591490440816*^9, 
   3.544591652821104*^9, 3.544592904641704*^9, 3.54467217312121*^9, 
   3.5446723745717325`*^9, 3.544673273733162*^9, {3.544673382226367*^9, 
   3.544673402974554*^9}, 3.5449492188958254`*^9, 3.5449516141610346`*^9, 
   3.545015662743734*^9, 3.5450157245354424`*^9, 3.5451061422578497`*^9, 
   3.54511402062022*^9, 3.552821195484202*^9, 3.5528226595633736`*^9, 
   3.552822795564412*^9, 3.552822986743748*^9, 3.5528231959089155`*^9, 
   3.5528236662653418`*^9, 3.5528239712156773`*^9, 3.552826116688446*^9, 
   3.5528263093185844`*^9, 3.5542072713991117`*^9, 3.554208466893612*^9, 
   3.561371697466419*^9, 3.5617325863744073`*^9, 3.5617791984114065`*^9, 
   3.5617814880138283`*^9, 3.5617815620047584`*^9, 3.561781652952918*^9, 
   3.561781901305354*^9, 3.561781933722211*^9, 3.561782101439106*^9, 
   3.5617821946804695`*^9, 3.5617823881208096`*^9, 3.5617824925941925`*^9, 
   3.5617825257442513`*^9, 3.561784234214452*^9, 3.5627666270609517`*^9, 
   3.562766743889557*^9, 3.562767082316551*^9, 3.5627678931757755`*^9, 
   3.5627695458436785`*^9, 3.5627696677422924`*^9, {3.5627711276572566`*^9, 
   3.562771147110491*^9}, 3.562773114228146*^9, 3.5627732020875*^9, 
   3.562821271834012*^9, 3.5628223458656983`*^9, 3.5628235977542973`*^9, 
   3.5628236610124083`*^9, 3.562824061855112*^9, 3.5628245986686554`*^9, 
   3.5628252434333878`*^9, 3.562825311792708*^9, 3.5628253718372135`*^9, 
   3.562825959226045*^9, 3.562826133883952*^9, 3.562826247951352*^9, 
   3.5628280657497725`*^9, 3.5628285639366474`*^9, 3.562828736535351*^9, 
   3.5628288787296004`*^9, 3.56283048952803*^9, 3.5628313051754627`*^9, 
   3.5628316998727555`*^9, 3.5628318197433662`*^9, 3.5628318516922226`*^9, 
   3.562832308211424*^9, 3.5628324215924234`*^9, 3.5628327292249637`*^9, 
   3.562833669845216*^9, 3.5628337642877817`*^9, 3.562833834893506*^9, 
   3.563425633042592*^9, 3.5634263671798816`*^9, 3.5634272135759687`*^9, 
   3.5634286994327784`*^9, 3.56342879147294*^9, 3.5634288701906776`*^9, 
   3.5634296665262766`*^9, 3.5641236127436376`*^9, 3.564124345899125*^9, 
   3.5641248624482327`*^9, 3.5641250176539054`*^9, 3.564130442136634*^9, 
   3.564635026283427*^9, 3.5646354978722553`*^9, 3.5646721298498907`*^9, 
   3.565759287826766*^9, 3.565773667011635*^9, 3.5658920236579*^9, 
   3.5661948527054286`*^9, 3.566203971383871*^9, 3.5662119038408656`*^9, 
   3.566212640683961*^9, 3.5662147340360374`*^9, 3.566399150350537*^9, 
   3.5665437125839195`*^9, 3.567082814838529*^9, 3.5671851370671806`*^9, 
   3.5675865229583006`*^9, 3.567600479647324*^9, 3.5678594382563505`*^9, 
   3.56786057083494*^9, 3.5678613069544325`*^9, 3.567861519988407*^9, 
   3.5678616190797806`*^9, 3.567861715831151*^9, 3.5678618101489162`*^9, 
   3.567862035647312*^9, 3.5678622047828093`*^9, 3.567862536471592*^9, 
   3.5678626835174503`*^9, 3.5678627713300047`*^9, 3.567863320326169*^9, 
   3.567863414971535*^9, 3.567863936589651*^9, 3.5678640887845187`*^9, 
   3.5678642538172083`*^9, 3.56786476699571*^9, 3.567865015831747*^9, 
   3.567865314868672*^9, 3.5678655286524477`*^9, 3.56787745388616*^9, 
   3.567911947971692*^9, 3.567913062468849*^9, 3.5679169100507855`*^9, 
   3.567917676526932*^9, 3.5679183611819344`*^9, 3.5679186148227797`*^9, 
   3.5679194446974373`*^9, 3.5679197567759857`*^9, 3.5679242579046917`*^9, 
   3.567926175102259*^9, 3.567926476900389*^9, 3.5679268614878645`*^9, 
   3.5679294739672537`*^9, 3.567929590702259*^9, 3.5679296721656017`*^9, 
   3.5679298563395257`*^9, 3.5679300833989244`*^9, 3.567930174939885*^9, 
   3.567930336680969*^9, 3.5679306225202713`*^9, 3.567931058572237*^9, 
   3.567931210578904*^9, 3.5679313316351166`*^9, 3.567931467027755*^9, 
   3.5679315200688477`*^9, 3.5679316258526335`*^9, 3.5679319503176036`*^9, 
   3.5679326316488*^9, 3.5679327512386103`*^9, 3.5679331257806683`*^9, 
   3.5679332330152564`*^9, 3.5679334642076626`*^9, 3.567934710198451*^9, 
   3.5679359720544677`*^9, 3.568115004584756*^9, 3.5681159084357433`*^9, 
   3.568122253173688*^9, 3.568122355322667*^9, 3.5681234123191233`*^9, 
   3.5688951167866125`*^9, 3.568895483418456*^9, {3.5703549462326117`*^9, 
   3.5703549591650343`*^9}, 3.5703573273749943`*^9, 3.570357446607003*^9, 
   3.5703575332183557`*^9, 3.570357611124892*^9, 3.570357747017731*^9, 
   3.5703578048938327`*^9, 3.5703578501651125`*^9, 3.570357905186409*^9, 
   3.5703579399432697`*^9, 3.5703580039189825`*^9, 3.5703582328025846`*^9, 
   3.570358628388079*^9, 3.570359217087313*^9, 3.570359307692272*^9, 
   3.57035985846684*^9, 3.570360128487714*^9, 3.5703609977378407`*^9, 
   3.57036107701718*^9, 3.5703612159666243`*^9, 3.5703614881871023`*^9, 
   3.570361569073244*^9, 3.5703616697246213`*^9, 3.5703618788117886`*^9, 
   3.5703628448444853`*^9, 3.570363011967579*^9, 3.570363150464622*^9, 
   3.570363238916777*^9, 3.5703632999128847`*^9, 3.5703633622037935`*^9, 
   3.5703635573133364`*^9, 3.5703640865442657`*^9, 3.570364165714405*^9, 
   3.570364366893358*^9, 3.570364472973545*^9, 3.5703645585864954`*^9, 
   3.5703647243679867`*^9, 3.5703648628962297`*^9, 3.5703649339543543`*^9, 
   3.5703650449641495`*^9, {3.570365394014763*^9, 3.57036540398318*^9}, 
   3.570365463528485*^9, 3.5703657275433483`*^9, 3.570365791643861*^9, {
   3.570365855494773*^9, 3.5703658744956064`*^9}, 3.570365937566517*^9, 
   3.570365989140208*^9, 3.570366096874997*^9, 3.570366176606737*^9, 
   3.570366233266037*^9, 3.5703662975693493`*^9, 3.570366339642624*^9, 
   3.570366406488741*^9, 3.570366437829196*^9, 3.5703665736586347`*^9, 
   3.570366946280889*^9, 3.5703672460822153`*^9, 3.5703674010060873`*^9, 
   3.570367495682654*^9, 3.5703677609777203`*^9, 3.570367808651404*^9, 
   3.5703678651859035`*^9, 3.57036855809232*^9, 3.5703686399300637`*^9, 
   3.570368783559516*^9, 3.5703688706388693`*^9, 3.570368931088975*^9, 
   3.5704269112965746`*^9, 3.570427528168458*^9, 3.57042759777678*^9, 
   3.5704276676337028`*^9, 3.570427754525855*^9, 3.570431941200809*^9, 
   3.570432183656435*^9, 3.5704330981466413`*^9, 3.5704365146379585`*^9, 
   3.570438039088236*^9, 3.5704381714398685`*^9, 3.5704382601416245`*^9, 
   3.570438351838585*^9, 3.5704385727037735`*^9, 3.570438756628096*^9, 
   3.5704388126321945`*^9, 3.576988549080654*^9, 3.5769896648736143`*^9, 
   3.5769897137017*^9, 3.5769897565393753`*^9, 3.5769897970526466`*^9, 
   3.5769901345592394`*^9, 3.5769903150671563`*^9, 3.576990361648838*^9, 
   3.57699052777353*^9, 3.576991389203643*^9, 3.576991612861236*^9, 
   3.576992451394909*^9, 3.5769928131595445`*^9, 3.5769933548392954`*^9, 
   3.576993431903431*^9, 3.5769937362131653`*^9, 3.576994174512535*^9, 
   3.5769951065985727`*^9, 3.576995250368425*^9, 3.584427162769226*^9, 
   3.58442729569706*^9, 3.5844273975340385`*^9, 3.584427667320913*^9, 
   3.584427731733426*^9, 3.584428022284936*^9, 3.5844280642178097`*^9, 
   3.5844284681961193`*^9, 3.584428589267932*^9, 3.5844287686536474`*^9, 
   3.5844292429568806`*^9, 3.5844293237962227`*^9, 3.584429364746294*^9, 
   3.584429426912403*^9, 3.584429592912295*^9, 3.5844299883271894`*^9, 
   3.584431509720862*^9, 3.5844319827302923`*^9, 3.607069912724092*^9, 
   3.607071269942491*^9, 3.60707140499268*^9, 3.6070715242828474`*^9, 
   3.6070715703429117`*^9, 3.6070728160656557`*^9, 3.607072909795787*^9, 
   3.6070824775962915`*^9, 3.6070831953872967`*^9, 3.607083375807549*^9, 
   3.607083506607732*^9, 3.6070842325497484`*^9, 3.607084313679862*^9, 
   3.607084515540145*^9, 3.6070849554307604`*^9, 3.607085011330839*^9, 
   3.607085775122908*^9, 3.607085872893045*^9, 3.607085967073177*^9, 
   3.607086248813571*^9, 3.6070875394863787`*^9, 3.607087918526909*^9, 
   3.60708806933712*^9, 3.6070886288079033`*^9, 3.6070895560602016`*^9, 
   3.6070896266203003`*^9, 3.6070926246116667`*^9, 3.6190819467087994`*^9, 
   3.619084939675472*^9, 3.62295692445063*^9, {3.6426665133680115`*^9, 
   3.6426665139880123`*^9}, {3.642758183431816*^9, 3.642758192791829*^9}, 
   3.6433505212373857`*^9, 3.6439958609973073`*^9, 3.6439959289374027`*^9, 
   3.644035933035197*^9, 3.644036052535364*^9, 3.6440365357470407`*^9, 
   3.644036618857157*^9, 3.6440377581497517`*^9, 3.6450048365917406`*^9, 
   3.645010390673708*^9, 3.6450108496753507`*^9, 3.646371251129275*^9, 
   3.6472546386021214`*^9, 3.6472549602995214`*^9, 3.6472558741697917`*^9, 
   3.647256112564427*^9, 3.647256297003976*^9, {3.6472563836379313`*^9, 
   3.647256412733596*^9}, {3.6473287125612245`*^9, 3.647328727691245*^9}, {
   3.648264221308123*^9, 3.648264225402094*^9}, {3.6482650368334775`*^9, 
   3.6482650412776546`*^9}, 3.648350173524246*^9, 3.649002741286105*^9, 
   3.6491724523963547`*^9, 3.6492142960025883`*^9, 3.6492143308626375`*^9, 
   3.6799843385318794`*^9, 3.697546182831085*^9, 3.6975462328521557`*^9, 
   3.7282077854254026`*^9, 3.7282080645538673`*^9, 3.7282096329547763`*^9, 
   3.72820969971558*^9, 3.7287924302719812`*^9, {3.8391506232476563`*^9, 
   3.839150646645867*^9}, 3.839150713972725*^9, 3.839150750951146*^9, 
   3.839150900477437*^9, 3.8396764003207903`*^9, 3.83967644504156*^9, 
   3.8400276374553213`*^9, 3.840028371044192*^9, 3.840029049747142*^9, 
   3.8449217773187833`*^9, 3.863080463058073*^9, 3.863170694929841*^9, {
   3.9583842360397854`*^9, 3.9583842658943386`*^9}},
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"dad14f96-fab4-064a-bf33-bf0e6ead647d"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{
  3.5201748495404644`*^9, 3.5201755961289663`*^9, 3.520175968622016*^9, 
   3.520176096289839*^9, 3.5201762704993424`*^9, 3.5201767560879908`*^9, 
   3.5201779236828303`*^9, 3.5201779734589148`*^9, 3.5201780339722204`*^9, 
   3.520178123251774*^9, 3.520178324058921*^9, 3.52017901036572*^9, 
   3.520179110875495*^9, 3.520179193654038*^9, 3.520179238322116*^9, 
   3.520179284863394*^9, 3.520179463908104*^9, 3.520179551695855*^9, 
   3.520181360208601*^9, 3.5201816366466846`*^9, 3.520268562601894*^9, 
   3.5202687309789333`*^9, 3.5202688626119223`*^9, 3.5202688997115755`*^9, 
   3.520269092038248*^9, 3.520271814240901*^9, 3.520310605227149*^9, 
   3.520310986656105*^9, 3.520311787220435*^9, 3.5203121049347124`*^9, {
   3.5271449362230697`*^9, 3.5271449374710712`*^9}, 3.5271458084226017`*^9, 
   3.5271460019731417`*^9, 3.527147022996935*^9, 3.527147593974538*^9, 
   3.5271480469067335`*^9, 3.5271482641995153`*^9, 3.5271486865170603`*^9, 
   3.5271500508184566`*^9, 3.527150173029071*^9, 3.5271503536305885`*^9, 
   3.5271505075716586`*^9, 3.527150792006958*^9, 3.527150865373887*^9, 
   3.5292308239241247`*^9, 3.5292324671062107`*^9, 3.529232571782395*^9, 
   3.5292359095380573`*^9, 3.529236217544998*^9, 3.5292364172253494`*^9, 
   3.5292366546109657`*^9, 3.529236716121874*^9, 3.5292369672073154`*^9, 
   3.5292370577030745`*^9, 3.5340685699885893`*^9, 3.5340689517524605`*^9, 
   3.5340693827656174`*^9, 3.5340699518858166`*^9, 3.534070176963012*^9, 
   3.534249637234564*^9, 3.537621498718997*^9, 3.537621625219619*^9, 
   3.537622841991556*^9, {3.5376229484929433`*^9, 3.537622964404971*^9}, 
   3.5376231829769554`*^9, 3.5376233615504684`*^9, 3.53762543997532*^9, 
   3.5376287896778746`*^9, 3.5376946998898697`*^9, 3.537694867792965*^9, 
   3.5376955018092785`*^9, 3.537695581603419*^9, 3.5376959132766013`*^9, 
   3.537696395270648*^9, 3.537697105057295*^9, 3.537697460457119*^9, {
   3.5376979706560154`*^9, 3.537697991279251*^9}, 3.5377005707009864`*^9, 
   3.5377009887193203`*^9, 3.5377011498676033`*^9, 3.537705075586299*^9, 
   3.5377676500294886`*^9, 3.5377801860343075`*^9, 3.537780583944206*^9, 
   3.5377809209369984`*^9, 3.537781079948078*^9, 3.537781242047962*^9, 
   3.5377813781738014`*^9, 3.5377815272320633`*^9, 3.537781725617612*^9, 
   3.5377823990717945`*^9, 3.5377827399011936`*^9, 3.5377829310483294`*^9, 
   3.5377831917715874`*^9, 3.5377834405930243`*^9, 3.5377835728968563`*^9, 
   3.537784107915396*^9, 3.5377842447432365`*^9, 3.5440922092835608`*^9, 
   3.5440972403587976`*^9, 3.5440973655022173`*^9, 3.5440979528442492`*^9, 
   3.544099754164813*^9, 3.5441033727647686`*^9, 3.544103463915729*^9, 
   3.544103705077553*^9, 3.5441039175031257`*^9, 3.5441040518817616`*^9, 
   3.5441050996586018`*^9, 3.544105714315282*^9, 3.544105949111294*^9, 
   3.544107147490799*^9, 3.5445912532642508`*^9, 3.544591490440816*^9, 
   3.544591652821104*^9, 3.544592904641704*^9, 3.54467217312121*^9, 
   3.5446723745717325`*^9, 3.544673273733162*^9, {3.544673382226367*^9, 
   3.544673402974554*^9}, 3.5449492188958254`*^9, 3.5449516141610346`*^9, 
   3.545015662743734*^9, 3.5450157245354424`*^9, 3.5451061422578497`*^9, 
   3.54511402062022*^9, 3.552821195484202*^9, 3.5528226595633736`*^9, 
   3.552822795564412*^9, 3.552822986743748*^9, 3.5528231959089155`*^9, 
   3.5528236662653418`*^9, 3.5528239712156773`*^9, 3.552826116688446*^9, 
   3.5528263093185844`*^9, 3.5542072713991117`*^9, 3.554208466893612*^9, 
   3.561371697466419*^9, 3.5617325863744073`*^9, 3.5617791984114065`*^9, 
   3.5617814880138283`*^9, 3.5617815620047584`*^9, 3.561781652952918*^9, 
   3.561781901305354*^9, 3.561781933722211*^9, 3.561782101439106*^9, 
   3.5617821946804695`*^9, 3.5617823881208096`*^9, 3.5617824925941925`*^9, 
   3.5617825257442513`*^9, 3.561784234214452*^9, 3.5627666270609517`*^9, 
   3.562766743889557*^9, 3.562767082316551*^9, 3.5627678931757755`*^9, 
   3.5627695458436785`*^9, 3.5627696677422924`*^9, {3.5627711276572566`*^9, 
   3.562771147110491*^9}, 3.562773114228146*^9, 3.5627732020875*^9, 
   3.562821271834012*^9, 3.5628223458656983`*^9, 3.5628235977542973`*^9, 
   3.5628236610124083`*^9, 3.562824061855112*^9, 3.5628245986686554`*^9, 
   3.5628252434333878`*^9, 3.562825311792708*^9, 3.5628253718372135`*^9, 
   3.562825959226045*^9, 3.562826133883952*^9, 3.562826247951352*^9, 
   3.5628280657497725`*^9, 3.5628285639366474`*^9, 3.562828736535351*^9, 
   3.5628288787296004`*^9, 3.56283048952803*^9, 3.5628313051754627`*^9, 
   3.5628316998727555`*^9, 3.5628318197433662`*^9, 3.5628318516922226`*^9, 
   3.562832308211424*^9, 3.5628324215924234`*^9, 3.5628327292249637`*^9, 
   3.562833669845216*^9, 3.5628337642877817`*^9, 3.562833834893506*^9, 
   3.563425633042592*^9, 3.5634263671798816`*^9, 3.5634272135759687`*^9, 
   3.5634286994327784`*^9, 3.56342879147294*^9, 3.5634288701906776`*^9, 
   3.5634296665262766`*^9, 3.5641236127436376`*^9, 3.564124345899125*^9, 
   3.5641248624482327`*^9, 3.5641250176539054`*^9, 3.564130442136634*^9, 
   3.564635026283427*^9, 3.5646354978722553`*^9, 3.5646721298498907`*^9, 
   3.565759287826766*^9, 3.565773667011635*^9, 3.5658920236579*^9, 
   3.5661948527054286`*^9, 3.566203971383871*^9, 3.5662119038408656`*^9, 
   3.566212640683961*^9, 3.5662147340360374`*^9, 3.566399150350537*^9, 
   3.5665437125839195`*^9, 3.567082814838529*^9, 3.5671851370671806`*^9, 
   3.5675865229583006`*^9, 3.567600479647324*^9, 3.5678594382563505`*^9, 
   3.56786057083494*^9, 3.5678613069544325`*^9, 3.567861519988407*^9, 
   3.5678616190797806`*^9, 3.567861715831151*^9, 3.5678618101489162`*^9, 
   3.567862035647312*^9, 3.5678622047828093`*^9, 3.567862536471592*^9, 
   3.5678626835174503`*^9, 3.5678627713300047`*^9, 3.567863320326169*^9, 
   3.567863414971535*^9, 3.567863936589651*^9, 3.5678640887845187`*^9, 
   3.5678642538172083`*^9, 3.56786476699571*^9, 3.567865015831747*^9, 
   3.567865314868672*^9, 3.5678655286524477`*^9, 3.56787745388616*^9, 
   3.567911947971692*^9, 3.567913062468849*^9, 3.5679169100507855`*^9, 
   3.567917676526932*^9, 3.5679183611819344`*^9, 3.5679186148227797`*^9, 
   3.5679194446974373`*^9, 3.5679197567759857`*^9, 3.5679242579046917`*^9, 
   3.567926175102259*^9, 3.567926476900389*^9, 3.5679268614878645`*^9, 
   3.5679294739672537`*^9, 3.567929590702259*^9, 3.5679296721656017`*^9, 
   3.5679298563395257`*^9, 3.5679300833989244`*^9, 3.567930174939885*^9, 
   3.567930336680969*^9, 3.5679306225202713`*^9, 3.567931058572237*^9, 
   3.567931210578904*^9, 3.5679313316351166`*^9, 3.567931467027755*^9, 
   3.5679315200688477`*^9, 3.5679316258526335`*^9, 3.5679319503176036`*^9, 
   3.5679326316488*^9, 3.5679327512386103`*^9, 3.5679331257806683`*^9, 
   3.5679332330152564`*^9, 3.5679334642076626`*^9, 3.567934710198451*^9, 
   3.5679359720544677`*^9, 3.568115004584756*^9, 3.5681159084357433`*^9, 
   3.568122253173688*^9, 3.568122355322667*^9, 3.5681234123191233`*^9, 
   3.5688951167866125`*^9, 3.568895483418456*^9, {3.5703549462326117`*^9, 
   3.5703549591650343`*^9}, 3.5703573273749943`*^9, 3.570357446607003*^9, 
   3.5703575332183557`*^9, 3.570357611124892*^9, 3.570357747017731*^9, 
   3.5703578048938327`*^9, 3.5703578501651125`*^9, 3.570357905186409*^9, 
   3.5703579399432697`*^9, 3.5703580039189825`*^9, 3.5703582328025846`*^9, 
   3.570358628388079*^9, 3.570359217087313*^9, 3.570359307692272*^9, 
   3.57035985846684*^9, 3.570360128487714*^9, 3.5703609977378407`*^9, 
   3.57036107701718*^9, 3.5703612159666243`*^9, 3.5703614881871023`*^9, 
   3.570361569073244*^9, 3.5703616697246213`*^9, 3.5703618788117886`*^9, 
   3.5703628448444853`*^9, 3.570363011967579*^9, 3.570363150464622*^9, 
   3.570363238916777*^9, 3.5703632999128847`*^9, 3.5703633622037935`*^9, 
   3.5703635573133364`*^9, 3.5703640865442657`*^9, 3.570364165714405*^9, 
   3.570364366893358*^9, 3.570364472973545*^9, 3.5703645585864954`*^9, 
   3.5703647243679867`*^9, 3.5703648628962297`*^9, 3.5703649339543543`*^9, 
   3.5703650449641495`*^9, {3.570365394014763*^9, 3.57036540398318*^9}, 
   3.570365463528485*^9, 3.5703657275433483`*^9, 3.570365791643861*^9, {
   3.570365855494773*^9, 3.5703658744956064`*^9}, 3.570365937566517*^9, 
   3.570365989140208*^9, 3.570366096874997*^9, 3.570366176606737*^9, 
   3.570366233266037*^9, 3.5703662975693493`*^9, 3.570366339642624*^9, 
   3.570366406488741*^9, 3.570366437829196*^9, 3.5703665736586347`*^9, 
   3.570366946280889*^9, 3.5703672460822153`*^9, 3.5703674010060873`*^9, 
   3.570367495682654*^9, 3.5703677609777203`*^9, 3.570367808651404*^9, 
   3.5703678651859035`*^9, 3.57036855809232*^9, 3.5703686399300637`*^9, 
   3.570368783559516*^9, 3.5703688706388693`*^9, 3.570368931088975*^9, 
   3.5704269112965746`*^9, 3.570427528168458*^9, 3.57042759777678*^9, 
   3.5704276676337028`*^9, 3.570427754525855*^9, 3.570431941200809*^9, 
   3.570432183656435*^9, 3.5704330981466413`*^9, 3.5704365146379585`*^9, 
   3.570438039088236*^9, 3.5704381714398685`*^9, 3.5704382601416245`*^9, 
   3.570438351838585*^9, 3.5704385727037735`*^9, 3.570438756628096*^9, 
   3.5704388126321945`*^9, 3.576988549080654*^9, 3.5769896648736143`*^9, 
   3.5769897137017*^9, 3.5769897565393753`*^9, 3.5769897970526466`*^9, 
   3.5769901345592394`*^9, 3.5769903150671563`*^9, 3.576990361648838*^9, 
   3.57699052777353*^9, 3.576991389203643*^9, 3.576991612861236*^9, 
   3.576992451394909*^9, 3.5769928131595445`*^9, 3.5769933548392954`*^9, 
   3.576993431903431*^9, 3.5769937362131653`*^9, 3.576994174512535*^9, 
   3.5769951065985727`*^9, 3.576995250368425*^9, 3.584427162769226*^9, 
   3.58442729569706*^9, 3.5844273975340385`*^9, 3.584427667320913*^9, 
   3.584427731733426*^9, 3.584428022284936*^9, 3.5844280642178097`*^9, 
   3.5844284681961193`*^9, 3.584428589267932*^9, 3.5844287686536474`*^9, 
   3.5844292429568806`*^9, 3.5844293237962227`*^9, 3.584429364746294*^9, 
   3.584429426912403*^9, 3.584429592912295*^9, 3.5844299883271894`*^9, 
   3.584431509720862*^9, 3.5844319827302923`*^9, 3.607069912724092*^9, 
   3.607071269942491*^9, 3.60707140499268*^9, 3.6070715242828474`*^9, 
   3.6070715703429117`*^9, 3.6070728160656557`*^9, 3.607072909795787*^9, 
   3.6070824775962915`*^9, 3.6070831953872967`*^9, 3.607083375807549*^9, 
   3.607083506607732*^9, 3.6070842325497484`*^9, 3.607084313679862*^9, 
   3.607084515540145*^9, 3.6070849554307604`*^9, 3.607085011330839*^9, 
   3.607085775122908*^9, 3.607085872893045*^9, 3.607085967073177*^9, 
   3.607086248813571*^9, 3.6070875394863787`*^9, 3.607087918526909*^9, 
   3.60708806933712*^9, 3.6070886288079033`*^9, 3.6070895560602016`*^9, 
   3.6070896266203003`*^9, 3.6070926246116667`*^9, 3.6190819467087994`*^9, 
   3.619084939675472*^9, 3.62295692445063*^9, {3.6426665133680115`*^9, 
   3.6426665139880123`*^9}, {3.642758183431816*^9, 3.642758192791829*^9}, 
   3.6433505212373857`*^9, 3.6439958609973073`*^9, 3.6439959289374027`*^9, 
   3.644035933035197*^9, 3.644036052535364*^9, 3.6440365357470407`*^9, 
   3.644036618857157*^9, 3.6440377581497517`*^9, 3.6450048365917406`*^9, 
   3.645010390673708*^9, 3.6450108496753507`*^9, 3.646371251129275*^9, 
   3.6472546386021214`*^9, 3.6472549602995214`*^9, 3.6472558741697917`*^9, 
   3.647256112564427*^9, 3.647256297003976*^9, {3.6472563836379313`*^9, 
   3.647256412733596*^9}, {3.6473287125612245`*^9, 3.647328727691245*^9}, {
   3.648264221308123*^9, 3.648264225402094*^9}, {3.6482650368334775`*^9, 
   3.6482650412776546`*^9}, 3.648350173524246*^9, 3.649002741286105*^9, 
   3.6491724523963547`*^9, 3.6492142960025883`*^9, 3.6492143308626375`*^9, 
   3.6799843385318794`*^9, 3.697546182831085*^9, 3.6975462328521557`*^9, 
   3.7282077854254026`*^9, 3.7282080645538673`*^9, 3.7282096329547763`*^9, 
   3.72820969971558*^9, 3.7287924302719812`*^9, {3.8391506232476563`*^9, 
   3.839150646645867*^9}, 3.839150713972725*^9, 3.839150750951146*^9, 
   3.839150900477437*^9, 3.8396764003207903`*^9, 3.83967644504156*^9, 
   3.8400276374553213`*^9, 3.840028371044192*^9, 3.840029049747142*^9, 
   3.8449217773187833`*^9, 3.863080463058073*^9, 3.863170694929841*^9, {
   3.9583842360397854`*^9, 3.9583842658943386`*^9}},
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"5bdd1703-207e-5d40-9906-d72c0905960a"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.5201748495404644`*^9, 3.5201755961289663`*^9, 3.520175968622016*^9, 
   3.520176096289839*^9, 3.5201762704993424`*^9, 3.5201767560879908`*^9, 
   3.5201779236828303`*^9, 3.5201779734589148`*^9, 3.5201780339722204`*^9, 
   3.520178123251774*^9, 3.520178324058921*^9, 3.52017901036572*^9, 
   3.520179110875495*^9, 3.520179193654038*^9, 3.520179238322116*^9, 
   3.520179284863394*^9, 3.520179463908104*^9, 3.520179551695855*^9, 
   3.520181360208601*^9, 3.5201816366466846`*^9, 3.520268562601894*^9, 
   3.5202687309789333`*^9, 3.5202688626119223`*^9, 3.5202688997115755`*^9, 
   3.520269092038248*^9, 3.520271814240901*^9, 3.520310605227149*^9, 
   3.520310986656105*^9, 3.520311787220435*^9, 3.5203121049347124`*^9, {
   3.5271449362230697`*^9, 3.5271449374710712`*^9}, 3.5271458084226017`*^9, 
   3.5271460019731417`*^9, 3.527147022996935*^9, 3.527147593974538*^9, 
   3.5271480469067335`*^9, 3.5271482641995153`*^9, 3.5271486865170603`*^9, 
   3.5271500508184566`*^9, 3.527150173029071*^9, 3.5271503536305885`*^9, 
   3.5271505075716586`*^9, 3.527150792006958*^9, 3.527150865373887*^9, 
   3.5292308239241247`*^9, 3.5292324671062107`*^9, 3.529232571782395*^9, 
   3.5292359095380573`*^9, 3.529236217544998*^9, 3.5292364172253494`*^9, 
   3.5292366546109657`*^9, 3.529236716121874*^9, 3.5292369672073154`*^9, 
   3.5292370577030745`*^9, 3.5340685699885893`*^9, 3.5340689517524605`*^9, 
   3.5340693827656174`*^9, 3.5340699518858166`*^9, 3.534070176963012*^9, 
   3.534249637234564*^9, 3.537621498718997*^9, 3.537621625219619*^9, 
   3.537622841991556*^9, {3.5376229484929433`*^9, 3.537622964404971*^9}, 
   3.5376231829769554`*^9, 3.5376233615504684`*^9, 3.53762543997532*^9, 
   3.5376287896778746`*^9, 3.5376946998898697`*^9, 3.537694867792965*^9, 
   3.5376955018092785`*^9, 3.537695581603419*^9, 3.5376959132766013`*^9, 
   3.537696395270648*^9, 3.537697105057295*^9, 3.537697460457119*^9, {
   3.5376979706560154`*^9, 3.537697991279251*^9}, 3.5377005707009864`*^9, 
   3.5377009887193203`*^9, 3.5377011498676033`*^9, 3.537705075586299*^9, 
   3.5377676500294886`*^9, 3.5377801860343075`*^9, 3.537780583944206*^9, 
   3.5377809209369984`*^9, 3.537781079948078*^9, 3.537781242047962*^9, 
   3.5377813781738014`*^9, 3.5377815272320633`*^9, 3.537781725617612*^9, 
   3.5377823990717945`*^9, 3.5377827399011936`*^9, 3.5377829310483294`*^9, 
   3.5377831917715874`*^9, 3.5377834405930243`*^9, 3.5377835728968563`*^9, 
   3.537784107915396*^9, 3.5377842447432365`*^9, 3.5440922092835608`*^9, 
   3.5440972403587976`*^9, 3.5440973655022173`*^9, 3.5440979528442492`*^9, 
   3.544099754164813*^9, 3.5441033727647686`*^9, 3.544103463915729*^9, 
   3.544103705077553*^9, 3.5441039175031257`*^9, 3.5441040518817616`*^9, 
   3.5441050996586018`*^9, 3.544105714315282*^9, 3.544105949111294*^9, 
   3.544107147490799*^9, 3.5445912532642508`*^9, 3.544591490440816*^9, 
   3.544591652821104*^9, 3.544592904641704*^9, 3.54467217312121*^9, 
   3.5446723745717325`*^9, 3.544673273733162*^9, {3.544673382226367*^9, 
   3.544673402974554*^9}, 3.5449492188958254`*^9, 3.5449516141610346`*^9, 
   3.545015662743734*^9, 3.5450157245354424`*^9, 3.5451061422578497`*^9, 
   3.54511402062022*^9, 3.552821195484202*^9, 3.5528226595633736`*^9, 
   3.552822795564412*^9, 3.552822986743748*^9, 3.5528231959089155`*^9, 
   3.5528236662653418`*^9, 3.5528239712156773`*^9, 3.552826116688446*^9, 
   3.5528263093185844`*^9, 3.5542072713991117`*^9, 3.554208466893612*^9, 
   3.561371697466419*^9, 3.5617325863744073`*^9, 3.5617791984114065`*^9, 
   3.5617814880138283`*^9, 3.5617815620047584`*^9, 3.561781652952918*^9, 
   3.561781901305354*^9, 3.561781933722211*^9, 3.561782101439106*^9, 
   3.5617821946804695`*^9, 3.5617823881208096`*^9, 3.5617824925941925`*^9, 
   3.5617825257442513`*^9, 3.561784234214452*^9, 3.5627666270609517`*^9, 
   3.562766743889557*^9, 3.562767082316551*^9, 3.5627678931757755`*^9, 
   3.5627695458436785`*^9, 3.5627696677422924`*^9, {3.5627711276572566`*^9, 
   3.562771147110491*^9}, 3.562773114228146*^9, 3.5627732020875*^9, 
   3.562821271834012*^9, 3.5628223458656983`*^9, 3.5628235977542973`*^9, 
   3.5628236610124083`*^9, 3.562824061855112*^9, 3.5628245986686554`*^9, 
   3.5628252434333878`*^9, 3.562825311792708*^9, 3.5628253718372135`*^9, 
   3.562825959226045*^9, 3.562826133883952*^9, 3.562826247951352*^9, 
   3.5628280657497725`*^9, 3.5628285639366474`*^9, 3.562828736535351*^9, 
   3.5628288787296004`*^9, 3.56283048952803*^9, 3.5628313051754627`*^9, 
   3.5628316998727555`*^9, 3.5628318197433662`*^9, 3.5628318516922226`*^9, 
   3.562832308211424*^9, 3.5628324215924234`*^9, 3.5628327292249637`*^9, 
   3.562833669845216*^9, 3.5628337642877817`*^9, 3.562833834893506*^9, 
   3.563425633042592*^9, 3.5634263671798816`*^9, 3.5634272135759687`*^9, 
   3.5634286994327784`*^9, 3.56342879147294*^9, 3.5634288701906776`*^9, 
   3.5634296665262766`*^9, 3.5641236127436376`*^9, 3.564124345899125*^9, 
   3.5641248624482327`*^9, 3.5641250176539054`*^9, 3.564130442136634*^9, 
   3.564635026283427*^9, 3.5646354978722553`*^9, 3.5646721298498907`*^9, 
   3.565759287826766*^9, 3.565773667011635*^9, 3.5658920236579*^9, 
   3.5661948527054286`*^9, 3.566203971383871*^9, 3.5662119038408656`*^9, 
   3.566212640683961*^9, 3.5662147340360374`*^9, 3.566399150350537*^9, 
   3.5665437125839195`*^9, 3.567082814838529*^9, 3.5671851370671806`*^9, 
   3.5675865229583006`*^9, 3.567600479647324*^9, 3.5678594382563505`*^9, 
   3.56786057083494*^9, 3.5678613069544325`*^9, 3.567861519988407*^9, 
   3.5678616190797806`*^9, 3.567861715831151*^9, 3.5678618101489162`*^9, 
   3.567862035647312*^9, 3.5678622047828093`*^9, 3.567862536471592*^9, 
   3.5678626835174503`*^9, 3.5678627713300047`*^9, 3.567863320326169*^9, 
   3.567863414971535*^9, 3.567863936589651*^9, 3.5678640887845187`*^9, 
   3.5678642538172083`*^9, 3.56786476699571*^9, 3.567865015831747*^9, 
   3.567865314868672*^9, 3.5678655286524477`*^9, 3.56787745388616*^9, 
   3.567911947971692*^9, 3.567913062468849*^9, 3.5679169100507855`*^9, 
   3.567917676526932*^9, 3.5679183611819344`*^9, 3.5679186148227797`*^9, 
   3.5679194446974373`*^9, 3.5679197567759857`*^9, 3.5679242579046917`*^9, 
   3.567926175102259*^9, 3.567926476900389*^9, 3.5679268614878645`*^9, 
   3.5679294739672537`*^9, 3.567929590702259*^9, 3.5679296721656017`*^9, 
   3.5679298563395257`*^9, 3.5679300833989244`*^9, 3.567930174939885*^9, 
   3.567930336680969*^9, 3.5679306225202713`*^9, 3.567931058572237*^9, 
   3.567931210578904*^9, 3.5679313316351166`*^9, 3.567931467027755*^9, 
   3.5679315200688477`*^9, 3.5679316258526335`*^9, 3.5679319503176036`*^9, 
   3.5679326316488*^9, 3.5679327512386103`*^9, 3.5679331257806683`*^9, 
   3.5679332330152564`*^9, 3.5679334642076626`*^9, 3.567934710198451*^9, 
   3.5679359720544677`*^9, 3.568115004584756*^9, 3.5681159084357433`*^9, 
   3.568122253173688*^9, 3.568122355322667*^9, 3.5681234123191233`*^9, 
   3.5688951167866125`*^9, 3.568895483418456*^9, {3.5703549462326117`*^9, 
   3.5703549591650343`*^9}, 3.5703573273749943`*^9, 3.570357446607003*^9, 
   3.5703575332183557`*^9, 3.570357611124892*^9, 3.570357747017731*^9, 
   3.5703578048938327`*^9, 3.5703578501651125`*^9, 3.570357905186409*^9, 
   3.5703579399432697`*^9, 3.5703580039189825`*^9, 3.5703582328025846`*^9, 
   3.570358628388079*^9, 3.570359217087313*^9, 3.570359307692272*^9, 
   3.57035985846684*^9, 3.570360128487714*^9, 3.5703609977378407`*^9, 
   3.57036107701718*^9, 3.5703612159666243`*^9, 3.5703614881871023`*^9, 
   3.570361569073244*^9, 3.5703616697246213`*^9, 3.5703618788117886`*^9, 
   3.5703628448444853`*^9, 3.570363011967579*^9, 3.570363150464622*^9, 
   3.570363238916777*^9, 3.5703632999128847`*^9, 3.5703633622037935`*^9, 
   3.5703635573133364`*^9, 3.5703640865442657`*^9, 3.570364165714405*^9, 
   3.570364366893358*^9, 3.570364472973545*^9, 3.5703645585864954`*^9, 
   3.5703647243679867`*^9, 3.5703648628962297`*^9, 3.5703649339543543`*^9, 
   3.5703650449641495`*^9, {3.570365394014763*^9, 3.57036540398318*^9}, 
   3.570365463528485*^9, 3.5703657275433483`*^9, 3.570365791643861*^9, {
   3.570365855494773*^9, 3.5703658744956064`*^9}, 3.570365937566517*^9, 
   3.570365989140208*^9, 3.570366096874997*^9, 3.570366176606737*^9, 
   3.570366233266037*^9, 3.5703662975693493`*^9, 3.570366339642624*^9, 
   3.570366406488741*^9, 3.570366437829196*^9, 3.5703665736586347`*^9, 
   3.570366946280889*^9, 3.5703672460822153`*^9, 3.5703674010060873`*^9, 
   3.570367495682654*^9, 3.5703677609777203`*^9, 3.570367808651404*^9, 
   3.5703678651859035`*^9, 3.57036855809232*^9, 3.5703686399300637`*^9, 
   3.570368783559516*^9, 3.5703688706388693`*^9, 3.570368931088975*^9, 
   3.5704269112965746`*^9, 3.570427528168458*^9, 3.57042759777678*^9, 
   3.5704276676337028`*^9, 3.570427754525855*^9, 3.570431941200809*^9, 
   3.570432183656435*^9, 3.5704330981466413`*^9, 3.5704365146379585`*^9, 
   3.570438039088236*^9, 3.5704381714398685`*^9, 3.5704382601416245`*^9, 
   3.570438351838585*^9, 3.5704385727037735`*^9, 3.570438756628096*^9, 
   3.5704388126321945`*^9, 3.576988549080654*^9, 3.5769896648736143`*^9, 
   3.5769897137017*^9, 3.5769897565393753`*^9, 3.5769897970526466`*^9, 
   3.5769901345592394`*^9, 3.5769903150671563`*^9, 3.576990361648838*^9, 
   3.57699052777353*^9, 3.576991389203643*^9, 3.576991612861236*^9, 
   3.576992451394909*^9, 3.5769928131595445`*^9, 3.5769933548392954`*^9, 
   3.576993431903431*^9, 3.5769937362131653`*^9, 3.576994174512535*^9, 
   3.5769951065985727`*^9, 3.576995250368425*^9, 3.584427162769226*^9, 
   3.58442729569706*^9, 3.5844273975340385`*^9, 3.584427667320913*^9, 
   3.584427731733426*^9, 3.584428022284936*^9, 3.5844280642178097`*^9, 
   3.5844284681961193`*^9, 3.584428589267932*^9, 3.5844287686536474`*^9, 
   3.5844292429568806`*^9, 3.5844293237962227`*^9, 3.584429364746294*^9, 
   3.584429426912403*^9, 3.584429592912295*^9, 3.5844299883271894`*^9, 
   3.584431509720862*^9, 3.5844319827302923`*^9, 3.607069912724092*^9, 
   3.607071269942491*^9, 3.60707140499268*^9, 3.6070715242828474`*^9, 
   3.6070715703429117`*^9, 3.6070728160656557`*^9, 3.607072909795787*^9, 
   3.6070824775962915`*^9, 3.6070831953872967`*^9, 3.607083375807549*^9, 
   3.607083506607732*^9, 3.6070842325497484`*^9, 3.607084313679862*^9, 
   3.607084515540145*^9, 3.6070849554307604`*^9, 3.607085011330839*^9, 
   3.607085775122908*^9, 3.607085872893045*^9, 3.607085967073177*^9, 
   3.607086248813571*^9, 3.6070875394863787`*^9, 3.607087918526909*^9, 
   3.60708806933712*^9, 3.6070886288079033`*^9, 3.6070895560602016`*^9, 
   3.6070896266203003`*^9, 3.6070926246116667`*^9, 3.6190819467087994`*^9, 
   3.619084939675472*^9, 3.62295692445063*^9, {3.6426665133680115`*^9, 
   3.6426665139880123`*^9}, {3.642758183431816*^9, 3.642758192791829*^9}, 
   3.6433505212373857`*^9, 3.6439958609973073`*^9, 3.6439959289374027`*^9, 
   3.644035933035197*^9, 3.644036052535364*^9, 3.6440365357470407`*^9, 
   3.644036618857157*^9, 3.6440377581497517`*^9, 3.6450048365917406`*^9, 
   3.645010390673708*^9, 3.6450108496753507`*^9, 3.646371251129275*^9, 
   3.6472546386021214`*^9, 3.6472549602995214`*^9, 3.6472558741697917`*^9, 
   3.647256112564427*^9, 3.647256297003976*^9, {3.6472563836379313`*^9, 
   3.647256412733596*^9}, {3.6473287125612245`*^9, 3.647328727691245*^9}, {
   3.648264221308123*^9, 3.648264225402094*^9}, {3.6482650368334775`*^9, 
   3.6482650412776546`*^9}, 3.648350173524246*^9, 3.649002741286105*^9, 
   3.6491724523963547`*^9, 3.6492142960025883`*^9, 3.6492143308626375`*^9, 
   3.6799843385318794`*^9, 3.697546182831085*^9, 3.6975462328521557`*^9, 
   3.7282077854254026`*^9, 3.7282080645538673`*^9, 3.7282096329547763`*^9, 
   3.72820969971558*^9, 3.7287924302719812`*^9, {3.8391506232476563`*^9, 
   3.839150646645867*^9}, 3.839150713972725*^9, 3.839150750951146*^9, 
   3.839150900477437*^9, 3.8396764003207903`*^9, 3.83967644504156*^9, 
   3.8400276374553213`*^9, 3.840028371044192*^9, 3.840029049747142*^9, 
   3.8449217773187833`*^9, 3.863080463058073*^9, 3.863170694929841*^9, {
   3.9583842360397854`*^9, 3.9583842659009647`*^9}},
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"c82b5d1f-5842-f247-950e-de739acdbbf3"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Note that symbols in the Global` context cannot be accessed right now.\
\>", "Text",
 CellChangeTimes->{
  3.423568541839567*^9},ExpressionUUID->"91eb080c-735b-47e3-bd25-\
17300737abd3"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"5e881a07-ebfb-47b4-8bf7-ed1fd724c51b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`SymSpin`\"\>", ",", "\<\"xAct`SpinFrames`\"\>", 
   ",", "\<\"xAct`SymManipulator`\"\>", ",", "\<\"xAct`TexAct`\"\>", 
   ",", "\<\"xAct`xCoba`\"\>", ",", "\<\"xAct`Spinors`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6472546386101217`*^9, 3.6472549603085213`*^9, 3.647255874177792*^9, 
   3.6472561125724273`*^9, 3.6472562970149765`*^9, {3.6472563836469316`*^9, 
   3.6472564127445965`*^9}, {3.647328712571224*^9, 3.6473287277012453`*^9}, 
   3.6482642254645977`*^9, 3.6482650413870397`*^9, 3.6483501735342464`*^9, 
   3.6490027412961054`*^9, 3.649172452406355*^9, 3.6492142960125885`*^9, 
   3.6492143308626375`*^9, 3.6799843385418797`*^9, 3.6975461828410854`*^9, 
   3.697546232872156*^9, 3.728207785460286*^9, 3.728208064591171*^9, 
   3.7282096329704027`*^9, 3.728209699798417*^9, 3.7287924302889824`*^9, {
   3.8391506232715926`*^9, 3.839150646677778*^9}, 3.8391507140036097`*^9, 
   3.839150750963114*^9, 3.839150900509379*^9, 3.8396764003457236`*^9, 
   3.8396764450764675`*^9, 3.84002763748724*^9, 3.840028371069125*^9, 
   3.8400290497870054`*^9, 3.8449217773526616`*^9, 3.8630804630790167`*^9, 
   3.8631706949613647`*^9, {3.9583842360558853`*^9, 3.9583842659323864`*^9}},
 CellLabel->"Out[43]=",ExpressionUUID->"4e47b0fb-6558-dc47-a4f3-cac3d96387bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\"\<xAct`SymSpin`\>\"", ",", "\"\<xAct`SpinFrames`\>\"", ",", 
   "\"\<xAct`SymManipulator`\>\"", ",", "\"\<xAct`TexAct`\>\"", ",", 
   "\"\<xAct`xCoba`\>\"", ",", "\"\<xAct`Spinors`\>\"", ",", 
   "\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", ",", 
   "\"\<xAct`xCore`\>\"", ",", "\"\<System`\>\""}], "}"}]], "Input",
 CellChangeTimes->{{3.647254303260352*^9, 3.647254303270352*^9}, {
  3.83869796857543*^9, 3.8386979731865053`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"b77ec0a7-fb0c-4e48-8b53-7095892cffeb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`SymSpin`\"\>", ",", "\<\"xAct`SpinFrames`\"\>", 
   ",", "\<\"xAct`SymManipulator`\"\>", ",", "\<\"xAct`TexAct`\"\>", 
   ",", "\<\"xAct`xCoba`\"\>", ",", "\<\"xAct`Spinors`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6472546386141214`*^9, 3.647254960315522*^9, 3.647255874182792*^9, 
   3.6472561125784273`*^9, 3.6472562970219774`*^9, {3.6472563836539326`*^9, 
   3.6472564127515965`*^9}, {3.6473287125812244`*^9, 3.6473287277112455`*^9}, 
   3.6482642255114746`*^9, 3.6482650414651656`*^9, 3.6483501735442467`*^9, 
   3.649002741306105*^9, 3.649172452406355*^9, 3.6492142960125885`*^9, 
   3.6492143308726373`*^9, 3.67998433855188*^9, 3.697546182851085*^9, 
   3.697546232872156*^9, 3.7282077854759483`*^9, 3.7282080646068*^9, 
   3.7282096330392313`*^9, 3.728209699799389*^9, 3.7287924303009825`*^9, {
   3.839150623294532*^9, 3.8391506467077007`*^9}, 3.839150714031559*^9, 
   3.8391507509710927`*^9, 3.839150900535282*^9, 3.8396764003666677`*^9, 
   3.8396764451063924`*^9, 3.8400276375061607`*^9, 3.8400283710900693`*^9, 
   3.8400290497999706`*^9, 3.8449217773716106`*^9, 3.8630804630889893`*^9, 
   3.8631706949935718`*^9, {3.9583842360558853`*^9, 3.9583842659546757`*^9}},
 CellLabel->"Out[44]=",ExpressionUUID->"6d69cf9c-90a8-bd48-8679-3cd76efffd8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"95ca7771-6a5d-45f5-ae9a-4cce08f67426"],

Cell[BoxData["\<\"xAct`SymSpin`\"\>"], "Output",
 CellChangeTimes->{
  3.647254638618122*^9, 3.6472549603215227`*^9, 3.6472558741867924`*^9, 
   3.647256112582428*^9, 3.647256297027978*^9, {3.6472563836589327`*^9, 
   3.647256412757597*^9}, {3.6473287125912247`*^9, 3.6473287277112455`*^9}, 
   3.6482642255583496`*^9, 3.648265041543294*^9, 3.6483501735442467`*^9, 
   3.649002741306105*^9, 3.649172452416355*^9, 3.6492142960225887`*^9, 
   3.6492143308726373`*^9, 3.679984338561879*^9, 3.697546182851085*^9, 
   3.697546232882156*^9, 3.7282077854915733`*^9, 3.728208064628474*^9, 
   3.7282096330392313`*^9, 3.728209699815034*^9, 3.7287924303129835`*^9, {
   3.8391506233015127`*^9, 3.839150646735628*^9}, 3.8391507140953646`*^9, 
   3.839150750978074*^9, 3.8391509005612135`*^9, 3.839676400378636*^9, 
   3.83967644512337*^9, 3.840027637526107*^9, 3.8400283711080213`*^9, 
   3.8400290498358746`*^9, 3.8449217773895626`*^9, 3.8630804631019545`*^9, 
   3.8631706949935718`*^9, {3.9583842360558853`*^9, 3.9583842659830074`*^9}},
 CellLabel->"Out[45]=",ExpressionUUID->"bf4b960e-9617-b344-900e-5bdbacef9d4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\"\<xAct`SymSpin`\>\""], "Input",
 CellChangeTimes->{{3.647254303270352*^9, 3.647254303280352*^9}, {
  3.838697979050539*^9, 3.8386979799434137`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"ceb7d0ac-bc1e-451e-9799-6b52cf8b9585"],

Cell[BoxData["\<\"xAct`SymSpin`\"\>"], "Output",
 CellChangeTimes->{
  3.647254638623122*^9, 3.6472549603275228`*^9, 3.6472558741917925`*^9, 
   3.647256112587428*^9, 3.647256297034978*^9, {3.6472563836649327`*^9, 
   3.647256412764597*^9}, {3.6473287126012244`*^9, 3.647328727721246*^9}, 
   3.6482642256052227`*^9, 3.6482650416370525`*^9, 3.6483501735542464`*^9, 
   3.649002741316105*^9, 3.649172452416355*^9, 3.6492142960225887`*^9, 
   3.649214330882637*^9, 3.6799843385718794`*^9, 3.697546182861085*^9, 
   3.6975462328921556`*^9, 3.7282077855082455`*^9, 3.7282080646379995`*^9, 
   3.728209633054859*^9, 3.7282096998306875`*^9, 3.728792430323984*^9, {
   3.839150623325449*^9, 3.8391506467435727`*^9}, 3.8391507141023607`*^9, 
   3.839150751033925*^9, 3.8391509005722113`*^9, 3.8396764004005775`*^9, 
   3.8396764451432896`*^9, 3.840027637535083*^9, 3.8400283711239786`*^9, 
   3.8400290498667927`*^9, 3.8449217774075146`*^9, 3.8630804631079392`*^9, 
   3.8631706973137364`*^9, {3.9583842360719814`*^9, 3.9583842659830074`*^9}},
 CellLabel->"Out[46]=",ExpressionUUID->"e60ddf31-be47-644b-b3bf-ce630ec2f0e7"]
}, Open  ]],

Cell["Established connection to external executable?", "Text",
 CellChangeTimes->{{3.419152978029696*^9, 
  3.419152995868268*^9}},ExpressionUUID->"03c822ac-c3ea-4d53-bcdd-\
0718505a2fb5"],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], "Input",
 CellChangeTimes->{{3.419152970981339*^9, 3.4191529720352583`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"da86f24c-2580-435b-8b44-26ddf1e21aa1"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.5201748496184645`*^9, 3.520175596188966*^9, 3.520175968668816*^9, 
   3.5201760963522387`*^9, 3.5201762705617423`*^9, 3.520176756147991*^9, 
   3.5201779237452307`*^9, 3.520177973505715*^9, 3.52017803401902*^9, 
   3.520178123301774*^9, 3.5201783241057215`*^9, 3.52017901042572*^9, 
   3.520179110925495*^9, 3.520179193704038*^9, 3.5201792383821163`*^9, 
   3.520179284913394*^9, 3.520179463954904*^9, 3.5201795517558556`*^9, 
   3.520181360286601*^9, 3.520181636693485*^9, 3.5202685626818943`*^9, 
   3.5202687310413337`*^9, 3.5202688626619225`*^9, 3.5202688997583756`*^9, 
   3.520269092098248*^9, 3.5202718143009014`*^9, 3.5203106052771487`*^9, 
   3.5203109867029047`*^9, 3.5203117872904353`*^9, 3.520312104994713*^9, 
   3.527144937533472*^9, 3.5271458084694014`*^9, 3.5271460020355415`*^9, 
   3.5271470230437355`*^9, 3.527147594021338*^9, 3.527148046937934*^9, 
   3.527148264246315*^9, 3.52714868657946*^9, 3.5271500509276567`*^9, 
   3.5271501730758715`*^9, 3.5271503536929884`*^9, 3.5271505076184587`*^9, 
   3.5271507920537586`*^9, 3.5271508654050875`*^9, 3.529230823970925*^9, 
   3.529232467153011*^9, 3.529232571829195*^9, 3.529235909584858*^9, 
   3.5292362175917983`*^9, 3.529236417272149*^9, 3.5292366546577663`*^9, 
   3.5292367161696744`*^9, 3.5292369672697153`*^9, 3.5292370577654743`*^9, 
   3.53406857005099*^9, 3.5340689518148603`*^9, 3.5340693828436174`*^9, 
   3.5340699519638166`*^9, 3.5340701770410123`*^9, 3.5342496373593636`*^9, 
   3.537621498828197*^9, 3.537621625297619*^9, 3.537622842069556*^9, {
   3.5376229485553436`*^9, 3.5376229644985714`*^9}, 3.5376231830549555`*^9, 
   3.5376233616440687`*^9, 3.5376254400689197`*^9, 3.537628789787075*^9, 
   3.53769469999907*^9, 3.537694867870965*^9, 3.5376955018872786`*^9, 
   3.537695581681419*^9, 3.537695913354602*^9, 3.537696395348648*^9, 
   3.537697105135295*^9, 3.5376974605507193`*^9, {3.5376979707340155`*^9, 
   3.537697991357251*^9}, 3.5377005708257866`*^9, 3.5377009888129206`*^9, 
   3.5377011499300036`*^9, 3.5377050756954994`*^9, 3.537767650138689*^9, 
   3.537780186096708*^9, 3.537780584022207*^9, 3.5377809210149984`*^9, 
   3.537781080041678*^9, 3.5377812421259623`*^9, 3.5377813782518015`*^9, 
   3.5377815273256636`*^9, 3.537781725711212*^9, 3.5377823991497946`*^9, 
   3.5377827400103936`*^9, 3.537782931110729*^9, 3.537783191865187*^9, 
   3.537783440655424*^9, 3.537783572974857*^9, 3.5377841079933963`*^9, 
   3.5377842448212366`*^9, 3.544092209408361*^9, 3.544097240452398*^9, 
   3.5440973655802174`*^9, 3.544097952906649*^9, 3.544099754242813*^9, 
   3.544103372873969*^9, 3.5441034639781294`*^9, 3.544103705155553*^9, 
   3.544103917581126*^9, 3.544104051959762*^9, 3.5441050997366023`*^9, 
   3.5441057143776817`*^9, 3.544105949189294*^9, 3.544107147568799*^9, 
   3.5445912533502555`*^9, 3.5445914905248213`*^9, 3.5445916529051085`*^9, 
   3.5445929047197084`*^9, 3.5446721732382174`*^9, 3.5446723746587377`*^9, 
   3.544673273854169*^9, {3.544673382290371*^9, 3.5446734030965605`*^9}, 
   3.5449492190050254`*^9, 3.5449516142390347`*^9, 3.5450156628373337`*^9, 
   3.5450157246290426`*^9, 3.54510614233585*^9, 3.5451140206982203`*^9, 
   3.5528211956246023`*^9, 3.5528226596725736`*^9, 3.5528227956580124`*^9, 
   3.5528229868373485`*^9, 3.552823196002516*^9, 3.552823666358942*^9, 
   3.5528239713092775`*^9, 3.552826116797646*^9, 3.5528263093965845`*^9, 
   3.554207271492712*^9, 3.554208466987212*^9, 3.5613716975444193`*^9, 
   3.5617325864836073`*^9, 3.561779198505007*^9, 3.5617814881074286`*^9, 
   3.5617815620827584`*^9, 3.561781653030918*^9, 3.5617819013521547`*^9, 
   3.5617819337846117`*^9, 3.561782101517106*^9, 3.56178219474287*^9, 
   3.5617823881832094`*^9, 3.5617824926565933`*^9, 3.5617825258378515`*^9, 
   3.561784234308052*^9, 3.5627666271545515`*^9, 3.5627667439519567`*^9, 
   3.562767082378951*^9, 3.5627678932537756`*^9, 3.5627695459060783`*^9, 
   3.5627696678046923`*^9, {3.562771127719657*^9, 3.562771147188491*^9}, 
   3.562773114290546*^9, 3.5627732021655006`*^9, 3.5628212719276123`*^9, 
   3.5628223459280987`*^9, 3.5628235978322973`*^9, 3.5628236610904083`*^9, 
   3.5628240619331126`*^9, 3.5628245987310553`*^9, 3.562825243495788*^9, 
   3.5628253118551083`*^9, 3.5628253719152136`*^9, 3.562825959304045*^9, 
   3.562826133961952*^9, 3.562826248029352*^9, 3.562828065827773*^9, 
   3.5628285639990473`*^9, 3.5628287365977507`*^9, 3.5628288788076005`*^9, 
   3.56283048960603*^9, 3.562831305253463*^9, 3.562831699935156*^9, 
   3.562831819805766*^9, 3.5628318517702227`*^9, 3.5628323082738247`*^9, 
   3.5628324216704235`*^9, 3.562832729318564*^9, 3.562833669923216*^9, 
   3.562833764365782*^9, 3.562833834971506*^9, 3.5634256331361923`*^9, 
   3.563426367257882*^9, 3.5634272136539683`*^9, 3.563428699495178*^9, 
   3.56342879155094*^9, 3.5634288702686787`*^9, 3.5634296666042767`*^9, 
   3.564123612837238*^9, 3.564124345961526*^9, 3.5641248625262327`*^9, 
   3.564125017731906*^9, 3.564130442214634*^9, 3.5646350263770266`*^9, 
   3.5646354979502554`*^9, 3.5646721299434905`*^9, 3.565759287904766*^9, 
   3.565773667089635*^9, 3.5658920237827005`*^9, 3.566194852783429*^9, 
   3.566203971461871*^9, 3.566211903918866*^9, 3.566212640746361*^9, 
   3.5662147340984373`*^9, 3.5663991504129367`*^9, 3.5665437126463203`*^9, 
   3.5670828149165297`*^9, 3.5671851371295805`*^9, 3.5675865230207005`*^9, 
   3.5676004797253237`*^9, 3.5678594383187504`*^9, 3.56786057089734*^9, 
   3.5678613070012326`*^9, 3.567861520035207*^9, 3.5678616191421804`*^9, 
   3.567861715893551*^9, 3.5678618101957164`*^9, 3.5678620357097125`*^9, 
   3.5678622048140097`*^9, 3.567862536518392*^9, 3.56786268357985*^9, 
   3.5678627713924046`*^9, 3.567863320388569*^9, 3.5678634150339355`*^9, 
   3.5678639366520514`*^9, 3.567864088831319*^9, 3.567864253864009*^9, 
   3.56786476705811*^9, 3.5678650158785467`*^9, 3.567865314915472*^9, 
   3.567865528699248*^9, 3.56787745393296*^9, 3.5679119480184917`*^9, 
   3.5679130625312495`*^9, 3.567916910113186*^9, 3.567917676573732*^9, 
   3.567918361244334*^9, 3.56791861485398*^9, 3.567919444744238*^9, 
   3.5679197568071856`*^9, 3.567924257951492*^9, 3.5679261751490593`*^9, 
   3.5679264769627895`*^9, 3.567926861534665*^9, 3.5679294740140543`*^9, 
   3.567929590764659*^9, 3.567929672228002*^9, 3.5679298564019256`*^9, 
   3.5679300834457245`*^9, 3.567930175002285*^9, 3.567930336727769*^9, 
   3.567930622582671*^9, 3.567931058619037*^9, 3.5679312106413045`*^9, 
   3.567931331697517*^9, 3.5679314670901546`*^9, 3.5679315201156483`*^9, 
   3.5679316259150333`*^9, 3.567931950380004*^9, 3.5679326317112007`*^9, 
   3.5679327512698107`*^9, 3.567933125843068*^9, 3.5679332330620565`*^9, 
   3.5679334642544627`*^9, 3.567934710260851*^9, 3.567935972101268*^9, 
   3.568115004647156*^9, 3.5681159084981437`*^9, 3.568122253236088*^9, 
   3.568122355400667*^9, 3.568123412381524*^9, 3.5688951168490124`*^9, 
   3.5688954834496565`*^9, {3.5703549462638116`*^9, 3.5703549591962347`*^9}, 
   3.570357327421794*^9, 3.570357446653804*^9, 3.570357533265156*^9, 
   3.5703576111716924`*^9, 3.5703577470645313`*^9, 3.5703578049250326`*^9, 
   3.570357850211912*^9, 3.5703579052332087`*^9, 3.5703579399900703`*^9, 
   3.570358003965782*^9, 3.5703582328493843`*^9, 3.5703586284348793`*^9, 
   3.5703592171341133`*^9, 3.5703593077390723`*^9, 3.5703598585136395`*^9, 
   3.570360128534514*^9, 3.570360997784641*^9, 3.57036107706398*^9, 
   3.570361216013424*^9, 3.5703614882183027`*^9, 3.5703615691200447`*^9, 
   3.5703616697714214`*^9, 3.5703618788429885`*^9, 3.570362844906885*^9, 
   3.570363011998779*^9, 3.570363150495822*^9, 3.5703632389635773`*^9, 
   3.570363299944084*^9, 3.570363362250594*^9, 3.5703635573601365`*^9, 
   3.570364086591066*^9, 3.570364165761205*^9, 3.570364366940159*^9, 
   3.5703644730047445`*^9, 3.570364558633295*^9, 3.570364724399186*^9, 
   3.57036486294303*^9, 3.570364934001155*^9, 3.5703650450265493`*^9, {
   3.5703653940615625`*^9, 3.57036540402998*^9}, 3.5703654635596848`*^9, 
   3.5703657275901484`*^9, 3.570365791690661*^9, {3.5703658555259733`*^9, 
   3.5703658745424066`*^9}, 3.5703659376133175`*^9, 3.570365989187008*^9, 
   3.5703660969217973`*^9, 3.5703661766535373`*^9, 3.5703662332972364`*^9, 
   3.57036629761615*^9, 3.5703663396894236`*^9, 3.570366406535541*^9, 
   3.570366437875996*^9, 3.570366573705435*^9, 3.570366946327689*^9, 
   3.5703672461446157`*^9, 3.5703674010372877`*^9, 3.5703674957450542`*^9, 
   3.57036776102452*^9, 3.570367808698204*^9, 3.570367865232703*^9, 
   3.57036855813912*^9, 3.570368639976864*^9, 3.570368783606316*^9, 
   3.570368870670069*^9, 3.570368931135775*^9, 3.5704269113433743`*^9, 
   3.570427528199658*^9, 3.5704275978235803`*^9, 3.570427667680503*^9, 
   3.5704277545726557`*^9, 3.570431941232009*^9, 3.5704321837032347`*^9, 
   3.5704330981934414`*^9, 3.570436514684758*^9, 3.570438039135036*^9, 
   3.5704381714866686`*^9, 3.570438260188424*^9, 3.5704383518853855`*^9, 
   3.570438572750573*^9, 3.5704387566748962`*^9, 3.570438812678995*^9, 
   3.5769885491430545`*^9, 3.5769896649048142`*^9, 3.5769897137797003`*^9, 
   3.576989756586175*^9, 3.576989797083846*^9, 3.576990134606039*^9, 
   3.5769903151139565`*^9, 3.5769903616956377`*^9, 3.5769905278203297`*^9, 
   3.5769913892348433`*^9, 3.576991612908036*^9, 3.5769924514417086`*^9, 
   3.5769928132063446`*^9, 3.576993354886096*^9, 3.5769934319502316`*^9, 
   3.5769937362755656`*^9, 3.576994174574936*^9, 3.5769951066609726`*^9, 
   3.576995250415225*^9, 3.5844271628004265`*^9, 3.58442729572826*^9, 
   3.584427397580839*^9, 3.584427667352113*^9, 3.584427731764626*^9, 
   3.5844280223161364`*^9, 3.5844280642646103`*^9, 3.5844284682273197`*^9, 
   3.5844285892991323`*^9, 3.584428768700447*^9, 3.5844292429880805`*^9, 
   3.5844293238430223`*^9, 3.5844293647774944`*^9, 3.5844294269436035`*^9, 
   3.584429592943495*^9, 3.5844299883739896`*^9, 3.5844315097832623`*^9, 
   3.584431982777093*^9, 3.607069912764092*^9, 3.6070712699824915`*^9, 
   3.6070714050226803`*^9, 3.607071524332847*^9, 3.607071570392912*^9, 
   3.6070728161056557`*^9, 3.6070729098257866`*^9, 3.6070824776362915`*^9, 
   3.6070831954272966`*^9, 3.607083375837549*^9, 3.6070835066377325`*^9, 
   3.6070842325697484`*^9, 3.607084313719862*^9, 3.607084515580145*^9, 
   3.6070849554607606`*^9, 3.607085011370839*^9, 3.6070857751629086`*^9, 
   3.607085872923045*^9, 3.607085967113177*^9, 3.6070862488335714`*^9, 
   3.6070875395263786`*^9, 3.607087918556909*^9, 3.60708806937712*^9, 
   3.6070886288579035`*^9, 3.607089556110202*^9, 3.6070896266603003`*^9, 
   3.6070926246516666`*^9, 3.6190819467387996`*^9, 3.619084939705472*^9, 
   3.62295692449063*^9, 3.642666514018012*^9, {3.6427581841518173`*^9, 
   3.6427581928218293`*^9}, 3.6433505212573857`*^9, 3.6439958610173073`*^9, 
   3.643995928957402*^9, 3.644035933055197*^9, 3.644036052555364*^9, 
   3.6440365357770405`*^9, 3.644036618877157*^9, 3.644037758169752*^9, 
   3.645004836621741*^9, 3.645010390693708*^9, 3.6450108496953506`*^9, 
   3.6463712511392746`*^9, 3.6472546386271224`*^9, 3.647254960335523*^9, 
   3.647255874195793*^9, 3.6472561125914288`*^9, 3.6472562970409784`*^9, {
   3.647256383671933*^9, 3.6472564127705975`*^9}, {3.6473287126012244`*^9, 
   3.6473287277312455`*^9}, 3.6482642256677256`*^9, 3.6482650417308035`*^9, 
   3.6483501735542464`*^9, 3.649002741316105*^9, 3.649172452416355*^9, 
   3.6492142960225887`*^9, 3.649214330882637*^9, 3.679984338581879*^9, 
   3.697546182871085*^9, 3.6975462328921556`*^9, 3.728207785510232*^9, 
   3.728208064653776*^9, 3.728209633070485*^9, 3.728209699846322*^9, 
   3.7287924303359847`*^9, {3.8391506233334274`*^9, 3.839150646770528*^9}, 
   3.8391507141312685`*^9, 3.8391507510419035`*^9, 3.839150900596154*^9, 
   3.8396764004185286`*^9, 3.839676445161242*^9, 3.8400276375570245`*^9, 
   3.8400283711399364`*^9, 3.8400290498777905`*^9, 3.844921777432475*^9, 
   3.86308046311891*^9, 3.8631706975585413`*^9, {3.9583842360881367`*^9, 
   3.9583842660150585`*^9}},
 CellLabel->"Out[47]=",ExpressionUUID->"442fce38-7e22-fb4b-a8a6-1632449a4ea6"]
}, Open  ]]
}, Closed]],

Cell["1.4. Non-standard setup", "Subsubsection",
 CellChangeTimes->{{3.4259903997539062`*^9, 
  3.425990420166374*^9}},ExpressionUUID->"ebd94145-228c-4b3b-b738-\
b17f8d86441b"],

Cell[CellGroupData[{

Cell["1.5. Usage messages", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.8386981405442*^9, 3.8386981419224863`*^9}, {
  3.8396556548959084`*^9, 
  3.839655656149048*^9}},ExpressionUUID->"773287f2-a634-4944-90d5-\
cde852675271"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InitSymSpin", "::", "usage"}], "=", 
   "\"\<InitSymSpin[sigma] initializes the SymSpin package by setting \
$DefaultSpinBundle to be the VBundleOfSolderingForm of sigma\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$DefaultSpinBundle", "::", "usage"}], "=", 
   "\"\<$DefaultSpinBundle is a global variable initialized by \
InitSymSpin[sigma] and set to be the VBundleOfSolderingForm of sigma\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HeldxTensorQ", "::", "usage"}], "=", 
   "\"\<Displays tensors using PrintAs even if no indices are given.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymSpinor", "::", "usage"}], " ", "=", 
   "\"\<SymSpinor[numunprim,numprim,symb,vb] is a symmetric spinor with \
numunprim unprimed and numprim primed indices and symbol symb (optional, \
blank by default) on the vector bundle vb (optional, $DefaultSpinBundle by \
default). numunprim and numprim can be numeric or more generally, \
constants.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefSymmetricSpinor", "::", "usage"}], " ", "=", 
   "\"\<DefSymmetricSpinor[symb,numunprim,numprim,vb,printas] defines a \
symmetric spinor symb with numunprim unprimed and numprim primed indices on \
the vector bundle vb and with displayform printas. numunprim and numprim can \
be numeric or more generally, constants.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultScal", "::", "usage"}], " ", "=", 
   "\"\<MultScal[scal,TT] multiplies thr scsalar field scal to the tensor \
head TT.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DummyTensor", "::", "usage"}], "=", 
   "\"\<DummyTensor[vbs_,sym_] is a tensor head element of the vector bundle \
vbs (e.g. by SlotsOfTensor) and symmetry sym (e.g. by \
SymmetryGroupOfTensor)\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "::", "usage"}], "=", 
   "\"\<TensorPlus[T1, T2, ...] is a Plus on tensor heads Ti.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IsolateTensorPlus", "::", "usage"}], "=", 
   "\"\<IsolateTensorPlus[eq,i] isolates the ith term of a TensorPlus \
equation with default value i=1.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IsolateTensorPlusPattern", "::", "usage"}], "=", 
   "\"\<IsolateTensorPlusPattern[eq,p] isolates the term containing p from an \
equation with TensorPlus.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetLinearOperatorRules", "::", "usage"}], "=", 
   "\"\<SetLinearOperatorRules[op] sets op to be linear w.r.t. TensorPlus and \
MultScal.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearOperatorQ", "::", "usage"}], "=", 
   "\"\<LinearOperatorQ[op] gives True if op was set by \
SetLinearOperatorRules[op] ad False otherwise.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "::", "usage"}], "=", 
   "\"\<CommuteOp[op1, op2] commutes operators op1 and op2. Examples are \
fundamental spinor operators or CommuteOp[SymMult,MultScal]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymMult", "::", "usage"}], "=", 
   "\"\<SymMult[T1,numunprim,numprim,vb][T2] contracts numunprim unprimed and \
numprim primed indices (on the vector bundle vb, which is optional and \
$DefaultSpinBundle by default) of symmetric spinors T1, T2 and symmetrizes.\>\
\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymMultRule", "::", "usage"}], "=", 
   "\"\<Expands SymMult[T1,numunprim,numprim,vb][T2][inds] into indexed \
spinor expressions.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymHToSymMultRule", "::", "usage"}], "=", 
   "\"\<Converts SymH terms involving two symmetric spinors into SymMult \
terms.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymMultLeibnizRules", "::", "usage"}], "=", 
   "\"\<SymMultLeibnizRules[covd] commutes SymMult out of Fundamental spinor \
operators of covd (optional, \
First[SpinCovDsOfSolderingForm[SolderingFormOfVBundle[$DefaultSpinBundle]]] \
by default).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultScalLeibnizRules", "::", "usage"}], "=", 
   "\"\<MultScalLeibnizRules[covd] commutes MultScal out of Fundamental \
spinor operators of covd (optional, \
First[SpinCovDsOfSolderingForm[SolderingFormOfVBundle[$DefaultSpinBundle]]] \
by default).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortSymMult", "::", "usage"}], "=", 
   "\"\<SortSymMult[orderingfunc] sorts T1, T2 in SymMult[T1,m,n,spin][T2] \
according to orderingfunc.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortSymMultReverse", "::", "usage"}], "=", 
   "\"\<Reverse ordering to SortSymMult\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymMultToMultScalRule", "::", "usage"}], "=", 
   "\"\<Converts SymMult[f,0,0,spin_][T] into MultScal[f[],T] if f is a \
scalar function.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultScalToSymMultRule", "::", "usage"}], "=", 
   "\"\<MultScalToSymMultRule[spin] converts \
MultScal[f[],T]\[RuleDelayed]SymMult[f,0,0,spin][T]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IrrDecomposeSymMult", "::", "usage"}], "=", 
   "\"\<IrrDecomposeSymMult[T1,T2,{p_,q_},spin_] expands (p,q) contractions \
of T1, T2 into a TensorPlus of SymMult terms.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymMultCoeffFunc", "::", "usage"}], "=", 
   "\"\<SymMultCoeffFunc[i_,r_,k_,t_,mm_,MM_] is the coefficient function \
appearing in sorting nested SymMult objects.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteSymMultRuleOut", "::", "usage"}], "=", 
   "\"\<CommuteSymMultRuleOut[T2] commutes SymMult[T2,..] outside in \
SymMult[T1,t,u,spin][SymMult[T2,m,n,spin][T3]]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteSymMultRuleIn", "::", "usage"}], "=", 
   "\"\<CommuteSymMultRuleIn[T1] commutes SymMult[T1,..] inside in \
SymMult[T1,t,u,spin][SymMult[T2,m,n,spin][T3]]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToGHPComponents", "::", "usage"}], "=", 
   "\"\<ToGHPComponents[expr,dyad] returns a list of dyad components of the \
index free expr\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TermToIndexFree", "::", "usage"}], "=", 
   "\"\<TermToIndexFree[term] is a function called from ToIndexFree that \
turns a single term into an index free expression. If special code is needed \
for some specific situation please add the definitions here.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToIndexFree", "::", "usage"}], "=", 
   "\"\<ToIndexFree[expr] converts an indexed expression expr to an unindexed \
version. It is assumed that expr does not have any dummy indices and that it \
is completely symmetric.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToIndexed", "::", "usage"}], "=", 
   "\"\<ToIndexed[expr] assumes that expr is an index free expression or an \
equation with indexfree expressions. The output is the same with appropriate \
indices inserted.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorMinus", "::", "usage"}], " ", "=", 
   "\"\<TensorMinus is automatically converted into the corresponding \
TensorPlus expression.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IndexFreeEqToZeroLHS", "::", "usage"}], " ", "=", 
   "\"\<IndexFreeEqToZeroLHS[eq] transforms the index free tensor equation eq \
to a form with a zero tensor in the left hand side.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtractCoeffsIndexFree", "::", "usage"}], "=", 
   "\"\<ExtractCoeffsIndexFree[expr, field] contracts expr with a test field \
and extracts the coefficients of all irreducible components of field times \
the test field. This is still experimental so please check the validity \
afterwards. expr can be an indexfree spinor, an index free equation or a \
list. field can indexfree spinor or a list.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IsolateFirstInLHS", "::", "usage"}], "=", 
   "\"\<IsolateFirstInLHS[eq] isolates the first term in the left hand side \
of an indexfree equation.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IsolateFirstInRHS", "::", "usage"}], "=", 
   "\"\<IsolateFirstInRHS[eq] isolates the first term in the right hand side \
of an indexfree equation.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AllSymMultCommutatorRules", "::", "usage"}], "=", 
   "\"\<AllSymMultCommutatorRules[T,spin] only work for valence 1,1 spinors \
at the moment.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortTensorPlusRule", "::", "usage"}], "=", 
   "\"\<SortTensorPlusRule is a rule that can sort the terms in a TensorPlus \
expression using TensorPlusSortFunc\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlusSortFunc", "::", "usage"}], "=", 
   "\"\<SortTensorPlusRule will sort with respect to \
TensorPlusSortFunc.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FundSpinOpBianchiRules", "::", "usage"}], "=", 
   "\"\<FundSpinOpBianchiRules[covd] gives the Bianchi equations for the \
fundamental spinor operators of the covariant derivative covd.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InitVarSH", "::", "usage"}], "=", 
   "\"\<InitVarSH[covd, base] defines spinors for the linearized metric with \
the names base22 and base00. These are then used by VarSH.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VarSH", "::", "usage"}], "=", 
   "\"\<VarSH[expr] represesents the spinor variation of expr.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinMetricOfSpinCovD", "::", "usage"}], "=", 
   "\"\<LinMetricOfSpinCovD[covd] gives a list of spinors {G22, G00} with the \
trace-free and trace parts of the linearized metric.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VarSHLeibnizRule", "::", "usage"}], "=", 
   "\"\<VarSHLeibnizRule gives a Leibniz rule for the variational operator \
VarSH.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VarSHCurvatureRules", "::", "usage"}], "=", 
   "\"\<VarSHCurvatureRules[covd] gives rules that expands the linearized \
curvature in terms of the linearized metric.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorMatrix", "::", "usage"}], "=", 
   "\"\<TensorMatrix[mat] represents mat as a matrix of tensors.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorMatrixOp", "::", "usage"}], "=", 
   "\"\<TensorMatrixOp[mat] represents mat as a matrix of operators acting on \
tensor heads.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TensorMatrixOpRule", "::", "usage"}], " ", "=", 
  "\"\<TensorMatrixOpRule is a rule that expands the operation the \
TensorMatrixOp operators. Currently it only works for operators acting on \
symmetric spinors.\>\""}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorMatrixToList", "::", "usage"}], "=", 
   "\"\<TensorMatrixToList is a rule that transforms a TensorMatrix object to \
a list of tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorMatrixEqToList", "::", "usage"}], "=", 
   "\"\<TensorMatrixEqToList[TensorMatrix[A]==TensorMatrix[B]] transforms the \
expression into a corresponding list of equations.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EqListToTensorMatrixEq", "::", "usage"}], "=", 
   "\"\<EqListToTensorMatrixEq[eqlist, varlist] transforms a list of tensor \
equations to matrix operator form.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ListToTensorMatrix", "::", "usage"}], "=", 
   "\"\<ListToTensorMatrix[exprlist, varlist] transforms a list of tensors to \
matrix operator form.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5703551580029836`*^9, 3.570355181605825*^9}, {
   3.5703552181410894`*^9, 3.5703553832517796`*^9}, {3.570355430285862*^9, 
   3.570355495150776*^9}, {3.570355534431645*^9, 3.5703555345096445`*^9}, {
   3.5703555799057245`*^9, 3.57035575356623*^9}, {3.570365006572482*^9, 
   3.570365012313292*^9}, {3.5703657000561*^9, 3.570365704502108*^9}, {
   3.570367042891859*^9, 3.5703670491318693`*^9}, {3.57036816495603*^9, 
   3.570368176141249*^9}, {3.5704269990623283`*^9, 3.570427004007537*^9}, {
   3.5769925952427616`*^9, 3.5769926097975874`*^9}, {3.5769927120089664`*^9, 
   3.5769927804150867`*^9}, {3.5844272514865828`*^9, 
   3.5844272518921833`*^9}, {3.6070695242135477`*^9, 
   3.6070695394735694`*^9}, {3.6070880131570415`*^9, 
   3.6070880437870846`*^9}, {3.6070895919002514`*^9, 3.607089599260262*^9}, {
   3.6071487812673473`*^9, 3.6071488075073843`*^9}, {3.6071511509917355`*^9, 
   3.607151156371743*^9}, {3.6071514536821594`*^9, 3.6071514579021654`*^9}, {
   3.6071722531493573`*^9, 3.607172258689365*^9}, {3.60718293696027*^9, 
   3.6071829420502768`*^9}, {3.619106668952724*^9, 3.6191066740127316`*^9}, {
   3.62286520667245*^9, 3.622865225052481*^9}, {3.622866721415676*^9, 
   3.6228667266156836`*^9}, {3.622868514845323*^9, 3.622868535470356*^9}, {
   3.6228715937118864`*^9, 3.6228715981728926`*^9}, {3.622878543195595*^9, 
   3.6228785470856*^9}, {3.622892584956569*^9, 3.622892593158581*^9}, {
   3.6229537505390763`*^9, 3.622953765261097*^9}, {3.642654302683062*^9, 
   3.642654326253095*^9}, {3.6426550407340956`*^9, 3.642655057094118*^9}, {
   3.6426666487882013`*^9, 3.6426666533282075`*^9}, {3.642669204513779*^9, 
   3.6426692095837865`*^9}, {3.642669884824732*^9, 3.6426698895647383`*^9}, {
   3.6426699204747815`*^9, 3.642669921314783*^9}, {3.6426835896723175`*^9, 
   3.6426835915223207`*^9}, {3.64268598887261*^9, 3.642685993382617*^9}, {
   3.642688826268821*^9, 3.64268883317883*^9}, {3.6428315833901405`*^9, 
   3.642831589680149*^9}, {3.642831652140237*^9, 3.642831722430335*^9}, {
   3.6428349880069075`*^9, 3.6428350144569445`*^9}, {3.642842030731524*^9, 
   3.642842057031561*^9}, {3.6428436370247726`*^9, 3.6428436447747836`*^9}, {
   3.643112721317829*^9, 3.6431128286679792`*^9}, {3.6431128803580513`*^9, 
   3.6431129347681274`*^9}, {3.6431129808081923`*^9, 
   3.6431130957183533`*^9}, {3.6431131519084315`*^9, 3.643113271248599*^9}, {
   3.6431133095506525`*^9, 3.6431133487807074`*^9}, {3.643113390140765*^9, 
   3.6431134112207947`*^9}, {3.643113480380892*^9, 3.6431135209009485`*^9}, {
   3.643113575551025*^9, 3.643113580051031*^9}, {3.6431136376011114`*^9, 
   3.6431137523112726`*^9}, {3.6431138321213837`*^9, 
   3.6431139030714836`*^9}, {3.6431139351715283`*^9, 3.643113978661589*^9}, {
   3.643114063421708*^9, 3.6431141183017845`*^9}, {3.6431141844018774`*^9, 
   3.643114282012014*^9}, {3.6431144251942143`*^9, 3.643114630124501*^9}, 
   3.6431148929148693`*^9, {3.6431149423449383`*^9, 3.643114951404951*^9}, {
   3.6431150057850275`*^9, 3.643115072895121*^9}, {3.64311510788517*^9, 
   3.64311533615649*^9}, {3.643115373227542*^9, 3.6431154941477113`*^9}, {
   3.643115896972072*^9, 3.6431159687421727`*^9}, {3.6431160043122225`*^9, 
   3.6431160290622573`*^9}, {3.6431161258223925`*^9, 
   3.6431162409725537`*^9}, {3.6431162871226187`*^9, 
   3.6431163172026606`*^9}, {3.6431163836827536`*^9, 3.64311654545298*^9}, {
   3.6431165802430286`*^9, 3.6431167480032635`*^9}, {3.6431167794633074`*^9, 
   3.6431167819333115`*^9}, {3.643116817763361*^9, 3.6431169257455125`*^9}, {
   3.643279729300138*^9, 3.6432797985486593`*^9}, {3.643284376700899*^9, 
   3.6432844056857505`*^9}, {3.643285234530806*^9, 3.643285297586117*^9}, {
   3.6432892497027764`*^9, 3.6432892605135956`*^9}, {3.64334818878212*^9, 
   3.643348205092143*^9}, {3.6433504549172926`*^9, 3.643350466057308*^9}, {
   3.643989085062821*^9, 3.6439891243828754`*^9}, {3.6439917796685934`*^9, 
   3.6439918089186344`*^9}, {3.6439928811311355`*^9, 3.643992938671216*^9}, {
   3.6439930258213377`*^9, 3.643993056381381*^9}, {3.6440357120448875`*^9, 
   3.644035883045127*^9}, {3.644037436578302*^9, 3.644037601068532*^9}, {
   3.644038298870509*^9, 3.644038401200652*^9}, {3.6441286358210545`*^9, 
   3.6441286361910553`*^9}, {3.6441347506013503`*^9, 3.644134791871408*^9}, {
   3.644204043541171*^9, 3.644204065841202*^9}, {3.644207030807353*^9, 
   3.644207127637489*^9}, {3.6442073230477624`*^9, 3.644207323927764*^9}, {
   3.6442080298687515`*^9, 3.6442080881588335`*^9}, {3.644208403489275*^9, 
   3.644208425920306*^9}, {3.644209387131652*^9, 3.644209462311757*^9}, 
   3.6442109810748835`*^9, {3.645004380571102*^9, 3.6450044340611773`*^9}, {
   3.6450046843615274`*^9, 3.6450046900815353`*^9}, {3.6450047636316385`*^9, 
   3.645004765431641*^9}, {3.6450102473835073`*^9, 3.6450102600735254`*^9}, 
   3.6463714508895545`*^9, 3.646371549599693*^9, {3.647328536170977*^9, 
   3.647328536630978*^9}, {3.6491710685744176`*^9, 3.6491710778044305`*^9}, {
   3.649171182684577*^9, 3.6491711980445986`*^9}, {3.6491715039850273`*^9, 
   3.6491715415950794`*^9}, {3.649171782465417*^9, 3.6491717957654357`*^9}, {
   3.649171987555704*^9, 3.649171993315712*^9}, {3.6491721634359503`*^9, 
   3.6491721801959734`*^9}, {3.680001382992094*^9, 3.680001443880962*^9}, {
   3.680001486932962*^9, 3.680001588682962*^9}, {3.680003956117442*^9, 
   3.680003966697442*^9}, {3.6800040121474423`*^9, 3.680004160197442*^9}, {
   3.6975459042536917`*^9, 3.6975459791097975`*^9}, {3.838698053990775*^9, 
   3.8386980692366343`*^9}, {3.838698155202888*^9, 3.838698156756658*^9}, {
   3.838819960827525*^9, 3.838819963148323*^9}, {3.838821937360352*^9, 
   3.838822018247591*^9}, {3.838875135676519*^9, 3.838875154287833*^9}, 
   3.838875297111329*^9, {3.838875349316742*^9, 3.8388753623207407`*^9}, {
   3.838875406412858*^9, 3.8388754093220882`*^9}, {3.8388754997700443`*^9, 
   3.838875522029216*^9}, {3.838875789223114*^9, 3.838875794445572*^9}, {
   3.838881137430767*^9, 3.838881140971072*^9}, {3.83888130470752*^9, 
   3.83888131130048*^9}, {3.8388814425413446`*^9, 3.838881454478321*^9}, {
   3.838883664572322*^9, 3.838883668445578*^9}, {3.838907244398435*^9, 
   3.838907253619063*^9}, {3.838965242258518*^9, 3.838965279892078*^9}, {
   3.8390423176231833`*^9, 3.839042321188884*^9}, {3.839150842553031*^9, 
   3.839150842934004*^9}, {3.839596843995618*^9, 3.8395968532317533`*^9}, {
   3.839596960899897*^9, 3.8395969676996937`*^9}, {3.839647783418717*^9, 
   3.839647844042204*^9}, {3.839647880539447*^9, 3.839647906567511*^9}, {
   3.839647972491322*^9, 3.839647998738593*^9}, {3.839648040775361*^9, 
   3.839648047730824*^9}, {3.83964818099402*^9, 3.839648258006645*^9}, {
   3.839648383855549*^9, 3.8396484010302467`*^9}, {3.839648440582932*^9, 
   3.839648485027841*^9}, {3.8396485308609247`*^9, 3.839648541577072*^9}, {
   3.839648584381587*^9, 3.839648730095783*^9}, {3.83964878644314*^9, 
   3.839648835740769*^9}, {3.83964889774312*^9, 3.839648939389523*^9}, 
   3.839652831468669*^9, {3.839652988276359*^9, 3.839653006833537*^9}, {
   3.839653053438211*^9, 3.8396531554926853`*^9}, {3.839653194992733*^9, 
   3.839653240850029*^9}, {3.8396532758618813`*^9, 3.839653322552864*^9}, {
   3.839653387054641*^9, 3.839653438300788*^9}, {3.839653485053733*^9, 
   3.8396535609425783`*^9}, {3.839654299080282*^9, 3.839654571347506*^9}, {
   3.839654900403945*^9, 3.839654952124888*^9}, {3.839655217683897*^9, 
   3.839655242608824*^9}, {3.839655298094433*^9, 3.8396553469141417`*^9}, {
   3.83965543123209*^9, 3.839655505508121*^9}, {3.8396555496005373`*^9, 
   3.8396555532722073`*^9}, {3.839656762903221*^9, 3.839656774809833*^9}, {
   3.8396568182815104`*^9, 3.839657006434926*^9}, {3.83965703959901*^9, 
   3.8396570953985023`*^9}, {3.8396572595205173`*^9, 3.839657288246883*^9}, {
   3.839657368208721*^9, 3.839657450829804*^9}, {3.839657488053053*^9, 
   3.839657729367309*^9}, {3.839657765644445*^9, 3.839657823262752*^9}, {
   3.839657861119644*^9, 3.8396578874061403`*^9}, 3.8396579345127373`*^9, {
   3.8396899473110824`*^9, 3.839690020832959*^9}, {3.839690413911027*^9, 
   3.839690425946207*^9}, {3.840002059791965*^9, 3.8400020870557013`*^9}, {
   3.8400270777550273`*^9, 3.8400270999621353`*^9}, {3.8400276701299524`*^9, 
   3.840027715379501*^9}, {3.8400280096446075`*^9, 3.8400281777543936`*^9}, {
   3.840028329235376*^9, 3.8400283298587093`*^9}, {3.840626741993744*^9, 
   3.840626851694558*^9}, {3.8407003120255113`*^9, 3.8407003336438417`*^9}, {
   3.8407003732679625`*^9, 3.8407004169521637`*^9}, {3.86307838996949*^9, 
   3.8630784010180244`*^9}, {3.863078452568511*^9, 3.8630785035854073`*^9}, {
   3.8630793811124816`*^9, 3.8630794428006163`*^9}, {3.8630794849369545`*^9, 
   3.863079794137374*^9}, {3.8630799560971556`*^9, 3.86308000705692*^9}, {
   3.8631634426048126`*^9, 3.863163452694306*^9}, {3.8912652723234076`*^9, 
   3.8912653239564347`*^9}, {3.8913096926402483`*^9, 
   3.8913097284240365`*^9}, {3.8913097586322308`*^9, 
   3.8913098550324535`*^9}, {3.9555119498603687`*^9, 
   3.9555121200668488`*^9}, {3.9555139780891113`*^9, 3.955514181484829*^9}, {
   3.9555306236147575`*^9, 3.9555307232579384`*^9}, {3.955530874512535*^9, 
   3.9555309527395706`*^9}, {3.9555318945730095`*^9, 
   3.9555319406109447`*^9}, {3.9555896078499203`*^9, 
   3.9555896644646664`*^9}, {3.955592472099083*^9, 3.955592494836996*^9}, {
   3.9555925318961735`*^9, 3.9555925546798077`*^9}, {3.955674957501154*^9, 
   3.955674963342655*^9}, 3.9556752647217636`*^9, 3.958357587292679*^9, {
   3.95835762404611*^9, 3.958357647940277*^9}, {3.9583588181702824`*^9, 
   3.9583588258009033`*^9}, {3.9583773991169815`*^9, 
   3.9583773995181675`*^9}, {3.9583834528550835`*^9, 
   3.9583835769477577`*^9}, {3.958383626077345*^9, 3.958383663994013*^9}, {
   3.9583837610059414`*^9, 3.958383766928112*^9}, {3.9583838252969913`*^9, 
   3.9583838515746555`*^9}, {3.958383907062107*^9, 3.9583839399687977`*^9}, {
   3.9583840506596947`*^9, 3.9583840837281*^9}, {3.9583841361895657`*^9, 
   3.9583841457444954`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"1e43a7e6-2907-42db-aa08-1e97775a32aa"],

Cell[BoxData["\<\"TensorMatrixOpRule is a rule that expands the operation the \
TensorMatrixOp operators. Currently it only works for operators acting on \
symmetric spinors.\"\>"], "Output",
 CellChangeTimes->{{3.9583842360881367`*^9, 3.9583842660418987`*^9}},
 CellLabel->"Out[94]=",ExpressionUUID->"441ef8fc-1c54-6742-99e8-893943531d54"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.6. Begin private", "Subsubsection",
 CellChangeTimes->{
  3.838698147467067*^9, {3.83881953949113*^9, 
   3.8388195421250844`*^9}},ExpressionUUID->"6183166b-1876-4f7c-a21c-\
368147392322"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[99]:=",ExpressionUUID->"52435f4b-6b87-4002-ac1d-2fe30a59a5f9"],

Cell[BoxData["\<\"xAct`SymSpin`Private`\"\>"], "Output",
 CellChangeTimes->{
  3.6472546386541243`*^9, 3.647254960369525*^9, 3.6472558742197943`*^9, 
   3.64725611262043*^9, 3.647256297084981*^9, {3.647256383701935*^9, 
   3.6472564128106003`*^9}, {3.6473287126412244`*^9, 3.647328727771246*^9}, {
   3.648264221433135*^9, 3.648264225808358*^9}, {3.648265036974113*^9, 
   3.648265041933939*^9}, 3.648350173604246*^9, 3.6490027413461056`*^9, 
   3.649172452456355*^9, 3.6492142960625887`*^9, 3.649214330932637*^9, 
   3.679984338631879*^9, 3.697546182911085*^9, 3.697546232932156*^9, 
   3.7282077856413093`*^9, 3.7282080647006865`*^9, 3.7282096331228533`*^9, 
   3.728209699894591*^9, 3.7287924303909883`*^9, {3.839150623358361*^9, 
   3.8391506468044376`*^9}, 3.8391507141622143`*^9, 3.8391507510538716`*^9, 
   3.839150900635043*^9, 3.8396764004464817`*^9, 3.8396764451981697`*^9, 
   3.8400276375839796`*^9, 3.840028371166864*^9, 3.840029049919651*^9, 
   3.8449217774613705`*^9, 3.8630804631378584`*^9, 3.8631706976018047`*^9, {
   3.958384236112671*^9, 3.9583842660635433`*^9}},
 CellLabel->"Out[99]=",ExpressionUUID->"f31b2d68-697b-5041-83b1-3baeababc11a"]
}, Open  ]],

Cell["The reserved words in the current version:", "Text",
 CellChangeTimes->{{3.5157533805469513`*^9, 3.5157533977299337`*^9}, 
   3.5157546086511946`*^9, {3.5157546435341897`*^9, 3.515754643595193*^9}, {
   3.5157566043206267`*^9, 3.5157566044298267`*^9}, {3.517824627882413*^9, 
   3.5178246279354157`*^9}, {3.5178247353335586`*^9, 
   3.5178247353725605`*^9}, {3.5178368637722654`*^9, 
   3.5178368687315493`*^9}, {3.646371236239254*^9, 
   3.646371267919298*^9}},ExpressionUUID->"0d8ccdfd-9ea1-4fd7-b800-\
87ce42c2190b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`SymSpin`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.515744906140235*^9, 3.5157449089503956`*^9}, 
   3.515938353904936*^9, 3.5703536314613028`*^9, {3.60706955418359*^9, 
   3.607069556983594*^9}, 3.647254303290352*^9, {3.838819504981256*^9, 
   3.8388195064283857`*^9}},
 CellLabel->
  "In[100]:=",ExpressionUUID->"8f0b1470-25b8-41e0-8cf4-1de02677fabf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AllSymMultCommutatorRules\"\>", ",", "\<\"CommuteOp\"\>", 
   ",", "\<\"CommuteSymMultRuleIn\"\>", ",", "\<\"CommuteSymMultRuleOut\"\>", 
   ",", "\<\"DefSymmetricSpinor\"\>", ",", "\<\"Disclaimer\"\>", 
   ",", "\<\"DummyTensor\"\>", ",", "\<\"EqListToTensorMatrixEq\"\>", 
   ",", "\<\"ExtractCoeffsIndexFree\"\>", 
   ",", "\<\"FundSpinOpBianchiRules\"\>", ",", "\<\"HeldxTensorQ\"\>", 
   ",", "\<\"IndexFreeEqToZeroLHS\"\>", ",", "\<\"InitSymSpin\"\>", 
   ",", "\<\"InitVarSH\"\>", ",", "\<\"IrrDecomposeSymMult\"\>", 
   ",", "\<\"IsolateFirstInLHS\"\>", ",", "\<\"IsolateFirstInRHS\"\>", 
   ",", "\<\"IsolateTensorPlus\"\>", ",", "\<\"IsolateTensorPlusPattern\"\>", 
   ",", "\<\"LinearOperatorQ\"\>", ",", "\<\"LinMetricOfSpinCovD\"\>", 
   ",", "\<\"ListToTensorMatrix\"\>", ",", "\<\"MultScal\"\>", 
   ",", "\<\"MultScalLeibnizRules\"\>", ",", "\<\"MultScalToSymMultRule\"\>", 
   ",", "\<\"SetLinearOperatorRules\"\>", ",", "\<\"SortSymMult\"\>", 
   ",", "\<\"SortSymMultReverse\"\>", ",", "\<\"SortTensorPlusRule\"\>", 
   ",", "\<\"SymHToSymMultRule\"\>", ",", "\<\"SymMult\"\>", 
   ",", "\<\"SymMultCoeffFunc\"\>", ",", "\<\"SymMultLeibnizRules\"\>", 
   ",", "\<\"SymMultRule\"\>", ",", "\<\"SymMultToMultScalRule\"\>", 
   ",", "\<\"SymSpinor\"\>", ",", "\<\"TensorMatrix\"\>", 
   ",", "\<\"TensorMatrixEqToList\"\>", ",", "\<\"TensorMatrixOp\"\>", 
   ",", "\<\"TensorMatrixOpRule\"\>", ",", "\<\"TensorMatrixToList\"\>", 
   ",", "\<\"TensorMinus\"\>", ",", "\<\"TensorPlus\"\>", 
   ",", "\<\"TensorPlusSortFunc\"\>", ",", "\<\"TermToIndexFree\"\>", 
   ",", "\<\"ToGHPComponents\"\>", ",", "\<\"ToIndexed\"\>", 
   ",", "\<\"ToIndexFree\"\>", ",", "\<\"VarSH\"\>", 
   ",", "\<\"VarSHCurvatureRules\"\>", ",", "\<\"VarSHLeibnizRule\"\>", 
   ",", "\<\"$DefaultSpinBundle\"\>", ",", "\<\"$Version\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5201748498368645`*^9, 3.520175596408966*^9, 3.520175968949617*^9, 
   3.520176096570639*^9, 3.520176270780143*^9, 3.520176756357991*^9, 
   3.5201779239480305`*^9, 3.5201779737241154`*^9, 3.520178034237421*^9, 
   3.520178123511774*^9, 3.5201783243241215`*^9, 3.5201790106457205`*^9, 
   3.520179111195495*^9, 3.5201791939140387`*^9, 3.520179238602116*^9, 
   3.5201792851233945`*^9, 3.5201794641733046`*^9, 3.520179551975856*^9, 
   3.520181360505002*^9, 3.5201816369274855`*^9, 3.5202685629118943`*^9, 
   3.520268731259734*^9, 3.5202688628819227`*^9, 3.520268899976776*^9, 
   3.5202690923082485`*^9, 3.520271814540901*^9, 3.520310605507149*^9, 
   3.520310986936905*^9, 3.5203117875304356`*^9, 3.520312105214713*^9, 
   3.527144937720672*^9, 3.5271458086410017`*^9, 3.527146002222742*^9, 
   3.5271470232465353`*^9, 3.5271475941929383`*^9, 3.527148047125134*^9, 
   3.5271482644335155`*^9, 3.5271486867822604`*^9, 3.527150051146057*^9, 
   3.5271501732630715`*^9, 3.527150353880189*^9, 3.527150507790059*^9, 
   3.5271507922409587`*^9, 3.5271508655766873`*^9, 3.529230824173725*^9, 
   3.529232467340211*^9, 3.529232572016395*^9, 3.5292359097720575`*^9, 
   3.529236217778999*^9, 3.5292364174593496`*^9, 3.529236654860566*^9, 
   3.5292367163568745`*^9, 3.5292369674413157`*^9, 3.529237057952675*^9, 
   3.53406857026939*^9, 3.534068952033261*^9, 3.534069383062018*^9, 
   3.5340699521978173`*^9, 3.5340701772438126`*^9, 3.5342496376401644`*^9, 
   3.537621499077798*^9, 3.5376216255316195`*^9, 3.537622842303557*^9, {
   3.537622948758144*^9, 3.537622964748172*^9}, 3.5376231832733555`*^9, 
   3.5376233618780694`*^9, 3.5376254403029203`*^9, 3.5376287900366755`*^9, 
   3.5376947002486706`*^9, 3.5376948680893655`*^9, 3.5376955021056795`*^9, 
   3.5376955818998194`*^9, 3.537695913588602*^9, 3.5376963955982485`*^9, 
   3.5376971053848953`*^9, 3.5376974607847195`*^9, {3.5376979709524155`*^9, 
   3.537697991606852*^9}, 3.537700571075387*^9, 3.537700989078121*^9, 
   3.5377011501640043`*^9, 3.5377050759294996`*^9, 3.53776765041949*^9, 
   3.5377801863307085`*^9, 3.5377805842406073`*^9, 3.537780921264599*^9, 
   3.5377810802756786`*^9, 3.537781242344363*^9, 3.537781378501402*^9, 
   3.537781527575264*^9, 3.537781725929612*^9, 3.5377823993837953`*^9, 
   3.5377827402443943`*^9, 3.5377829313291297`*^9, 3.537783192099188*^9, 
   3.5377834409206247`*^9, 3.5377835732088575`*^9, 3.537784108227397*^9, 
   3.537784245039637*^9, 3.5440922096423616`*^9, 3.5440972417628*^9, 
   3.544097365814218*^9, 3.5440979531250496`*^9, 3.5440997544924135`*^9, 
   3.5441033731235695`*^9, 3.5441034642121296`*^9, 3.5441037054051533`*^9, 
   3.5441039178151264`*^9, 3.5441040521937623`*^9, 3.544105099955003*^9, 
   3.544105714627282*^9, 3.5441059494388947`*^9, 3.5441071478027997`*^9, 
   3.544591253590269*^9, 3.5445914907438335`*^9, 3.544591653144122*^9, 
   3.5445929049517217`*^9, 3.544672173493232*^9, 3.5446723748987513`*^9, 
   3.5446732741261845`*^9, {3.544673382502383*^9, 3.5446734033675766`*^9}, 
   3.544949219254626*^9, 3.5449516144574347`*^9, 3.5450156630557346`*^9, 
   3.5450157248474426`*^9, 3.5451061425542502`*^9, 3.545114020932221*^9, 
   3.552821195889803*^9, 3.5528226599377737`*^9, 3.552822795907613*^9, 
   3.5528229871025486`*^9, 3.552823196252116*^9, 3.5528236666085424`*^9, 
   3.552823971574478*^9, 3.5528261170472465`*^9, 3.5528263096149845`*^9, 
   3.5542072717423124`*^9, 3.5542084672524123`*^9, 3.56137169777842*^9, 
   3.561732586748808*^9, 3.561779198754607*^9, 3.561781488372629*^9, 
   3.561781562316759*^9, 3.5617816532649183`*^9, 3.5617819015705547`*^9, 
   3.561781934018612*^9, 3.5617821017667065`*^9, 3.5617821949924703`*^9, 
   3.56178238843281*^9, 3.5617824929061937`*^9, 3.561782526087452*^9, 
   3.5617842345576525`*^9, 3.562766627404152*^9, 3.562766744185957*^9, 
   3.5627670826129513`*^9, 3.562767893487776*^9, 3.5627695461400785`*^9, 
   3.5627696680386925`*^9, {3.562771127938057*^9, 3.562771147422491*^9}, 
   3.5627731145245466`*^9, 3.5627732023839006`*^9, 3.5628212721772127`*^9, 
   3.5628223461464987`*^9, 3.562823598050698*^9, 3.5628236613244085`*^9, 
   3.5628240621671133`*^9, 3.5628245989494557`*^9, 3.5628252437141886`*^9, 
   3.5628253121047087`*^9, 3.562825372149214*^9, 3.5628259595692453`*^9, 
   3.5628261341959524`*^9, 3.5628262482789526`*^9, 3.5628280660773735`*^9, 
   3.562828564217448*^9, 3.562828736816151*^9, 3.562828879041601*^9, 
   3.5628304898244305`*^9, 3.5628313054562626`*^9, 3.562831700169156*^9, 
   3.5628318199929667`*^9, 3.562831852051023*^9, 3.5628323084922247`*^9, 
   3.562832421920024*^9, 3.5628327295525646`*^9, 3.5628336701884165`*^9, 
   3.5628337645997825`*^9, 3.5628338352211065`*^9, 3.5634256333857927`*^9, 
   3.563426367476282*^9, 3.563427213919169*^9, 3.563428699729179*^9, 
   3.5634287918005404`*^9, 3.563428870502679*^9, 3.5634296668226776`*^9, 
   3.564123613102438*^9, 3.564124346195526*^9, 3.564124862760233*^9, 
   3.564125017965906*^9, 3.564130442448634*^9, 3.5646350266110272`*^9, 
   3.5646354981686554`*^9, 3.564672130193091*^9, 3.565759288138767*^9, 
   3.565773667292435*^9, 3.5658920240167007`*^9, 3.5661948530174294`*^9, 
   3.566203971680272*^9, 3.566211904168466*^9, 3.566212640980361*^9, 
   3.566214734301238*^9, 3.5663991506469374`*^9, 3.5665437128803205`*^9, 
   3.56708281515053*^9, 3.5671851373479815`*^9, 3.5675865232391005`*^9, 
   3.5676004799593244`*^9, 3.56785943844355*^9, 3.5678605710221395`*^9, 
   3.5678613071104326`*^9, 3.567861520160007*^9, 3.567861619251381*^9, 
   3.5678617160027514`*^9, 3.5678618103205166`*^9, 3.5678620358189125`*^9, 
   3.5678622049232097`*^9, 3.5678625366431923`*^9, 3.5678626836890507`*^9, 
   3.5678627715172048`*^9, 3.567863320513369*^9, 3.567863415143135*^9, 
   3.5678639367768517`*^9, 3.567864088940519*^9, 3.5678642540668087`*^9, 
   3.56786476716731*^9, 3.567865016128147*^9, 3.5678653150402727`*^9, 
   3.567865528824048*^9, 3.5678774540421605`*^9, 3.567911948143292*^9, 
   3.5679130626560497`*^9, 3.567916910253586*^9, 3.5679176766673317`*^9, 
   3.567918361431535*^9, 3.56791861497878*^9, 3.5679194448378377`*^9, 
   3.5679197569163857`*^9, 3.567924258076292*^9, 3.5679261752738595`*^9, 
   3.5679264770719895`*^9, 3.567926861659465*^9, 3.5679294741232543`*^9, 
   3.5679295908738594`*^9, 3.567929672337202*^9, 3.567929856526726*^9, 
   3.5679300835705247`*^9, 3.5679301751114855`*^9, 3.5679303368369694`*^9, 
   3.567930622707472*^9, 3.5679310587438374`*^9, 3.5679312107505045`*^9, 
   3.567931331806717*^9, 3.567931467199355*^9, 3.567931520240448*^9, 
   3.567931626024234*^9, 3.5679319504892035`*^9, 3.5679326318204*^9, 
   3.5679327513946104`*^9, 3.5679331259522686`*^9, 3.567933233155657*^9, 
   3.567933464379263*^9, 3.5679347103856516`*^9, 3.567935972210468*^9, 
   3.568115004818756*^9, 3.568115908638544*^9, 3.568122253360888*^9, 
   3.5681223555410676`*^9, 3.568123412490724*^9, 3.5688951169894123`*^9, 
   3.568895483574456*^9, {3.570354946544612*^9, 3.5703549593054347`*^9}, 
   3.5703573275309944`*^9, 3.5703574467630033`*^9, 3.5703575333899555`*^9, 
   3.5703576112808924`*^9, 3.5703577471737313`*^9, 3.570357805018633*^9, 
   3.5703578503055124`*^9, 3.5703579053580093`*^9, 3.57035794008367*^9, 
   3.5703580040749826`*^9, 3.570358232958585*^9, 3.5703586285440793`*^9, 
   3.570359217243314*^9, 3.5703593078482723`*^9, 3.57035985862284*^9, 
   3.570360128628114*^9, 3.5703609978938413`*^9, 3.5703610771731806`*^9, 
   3.5703612161226244`*^9, 3.5703614883275023`*^9, 3.5703615692448444`*^9, 
   3.570361669865021*^9, 3.5703618789521885`*^9, 3.5703628450160856`*^9, 
   3.5703630120923786`*^9, 3.5703631506050224`*^9, 3.570363239088378*^9, 
   3.5703633000376844`*^9, 3.570363362375394*^9, 3.5703635574693365`*^9, 
   3.5703640867002664`*^9, 3.570364165870405*^9, 3.570364367049359*^9, 
   3.570364473113945*^9, 3.5703645587268953`*^9, 3.5703647245083866`*^9, 
   3.57036486305223*^9, 3.570364934110355*^9, 3.57036504513575*^9, {
   3.570365394467163*^9, 3.5703654041235805`*^9}, 3.5703654636844845`*^9, 
   3.5703657276993484`*^9, 3.570365791799861*^9, {3.5703658556351733`*^9, 
   3.570365874636007*^9}, 3.5703659377381177`*^9, 3.570365989280608*^9, 
   3.5703660970309973`*^9, 3.5703661767627373`*^9, 3.570366233406437*^9, 
   3.57036629774095*^9, 3.570366339798624*^9, 3.570366406644741*^9, 
   3.570366437969596*^9, 3.570366573814635*^9, 3.5703669464212894`*^9, 
   3.5703672462538157`*^9, 3.570367401146488*^9, 3.5703674958542547`*^9, 
   3.5703677611337204`*^9, 3.570367808823004*^9, 3.5703678653575034`*^9, 
   3.5703685582639203`*^9, 3.5703686400860643`*^9, 3.570368783715516*^9, 
   3.570368870779269*^9, 3.5703689312449756`*^9, 3.5704269114525747`*^9, 
   3.5704275282932577`*^9, 3.57042759791718*^9, 3.570427667774103*^9, 
   3.5704277546818557`*^9, 3.5704319413412094`*^9, 3.570432183796835*^9, 
   3.5704330982870417`*^9, 3.5704365147783585`*^9, 3.570438039228636*^9, 
   3.570438171595869*^9, 3.5704382602976246`*^9, 3.5704383519633856`*^9, 
   3.5704385728597736`*^9, 3.5704387567996964`*^9, 3.570438812803795*^9, 
   3.5769885492522545`*^9, 3.5769896649984145`*^9, 3.5769897139201*^9, 
   3.576989756679775*^9, 3.5769897971930466`*^9, 3.5769901346996393`*^9, 
   3.5769903152231565`*^9, 3.576990361804838*^9, 3.57699052792953*^9, 
   3.5769913893440437`*^9, 3.5769916130172367`*^9, 3.5769924515353093`*^9, 
   3.5769928132999444`*^9, 3.576993354995296*^9, 3.576993432059431*^9, 
   3.576993736415966*^9, 3.5769941746841354`*^9, 3.576995106785773*^9, 
   3.576995250540025*^9, 3.5844271628940268`*^9, 3.5844272958218603`*^9, 
   3.5844273976744394`*^9, 3.584427667445713*^9, 3.584427731858226*^9, 
   3.5844280223941364`*^9, 3.58442806435821*^9, 3.5844284683209195`*^9, 
   3.5844285893927326`*^9, 3.584428768778447*^9, 3.5844292430816803`*^9, 
   3.584429324045823*^9, 3.5844293648710947`*^9, 3.584429427146404*^9, 
   3.584429593037095*^9, 3.58442998846759*^9, 3.584431509876862*^9, 
   3.584431982855093*^9, 3.6070699128540916`*^9, 3.607071270072491*^9, 
   3.6070714051226807`*^9, 3.6070715244228473`*^9, 3.607071570482912*^9, 
   3.607072816195656*^9, 3.6070729101757874`*^9, 3.607082477956292*^9, 
   3.607083195747297*^9, 3.6070833761475496`*^9, 3.6070835069377327`*^9, 
   3.607084232869749*^9, 3.6070843140398626`*^9, 3.6070845159001455`*^9, 
   3.607084955770761*^9, 3.6070850116908393`*^9, 3.6070857754929085`*^9, 
   3.6070858732330456`*^9, 3.6070859674231777`*^9, 3.607086249153572*^9, 
   3.607087539846379*^9, 3.6070879188969097`*^9, 3.607088069707121*^9, 
   3.60708864087792*^9, 3.6070895564202023`*^9, 3.607089626990301*^9, 
   3.6070926249716673`*^9, 3.6190819470288*^9, 3.6190849400154724`*^9, 
   3.6229569245406303`*^9, 3.642666514068012*^9, {3.6427581842018175`*^9, 
   3.6427581928718295`*^9}, 3.6433505212973857`*^9, 3.6439958610573072`*^9, 
   3.643995928997402*^9, 3.644035933125197*^9, 3.6440360526253643`*^9, 
   3.644036535847041*^9, 3.644036618937157*^9, 3.6440377582197523`*^9, 
   3.6450048366817408`*^9, 3.645010390753708*^9, 3.645010849745351*^9, 
   3.646371251189275*^9, 3.647254638671125*^9, 3.6472549603905263`*^9, 
   3.6472558742367954`*^9, 3.6472561126384315`*^9, 3.6472562971169825`*^9, {
   3.647256383723936*^9, 3.6472564128356013`*^9}, {3.6473287126812243`*^9, 
   3.6473287277912455`*^9}, 3.648264225917738*^9, 3.648265042121456*^9, 
   3.6483501736342463`*^9, 3.649002741366105*^9, 3.649172452466355*^9, 
   3.6492142960725884`*^9, 3.649214330962637*^9, 3.6799843386618786`*^9, 
   3.697546182951085*^9, 3.697546232952156*^9, 3.728207785709944*^9, 
   3.7282080647537026`*^9, 3.7282096331546535`*^9, 3.7282096999227953`*^9, 
   3.7287924304339905`*^9, {3.839150623388281*^9, 3.839150646863281*^9}, 
   3.839150714217066*^9, 3.8391507510798025`*^9, 3.839150900686904*^9, 
   3.8396764004743795`*^9, 3.839676445242056*^9, 3.8400276376368318`*^9, 
   3.840028371201771*^9, 3.84002904998348*^9, 3.844921777498299*^9, 
   3.8630804631578054`*^9, 3.86317069762915*^9, {3.958384236136093*^9, 
   3.9583842661005936`*^9}},
 CellLabel->
  "Out[100]=",ExpressionUUID->"a1398ba5-6615-ec43-9d95-a1cd1eb696cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Length"}]], "Input",
 CellLabel->
  "In[101]:=",ExpressionUUID->"9e795ee4-fa4a-40a8-82bf-00c6bfb6dc12"],

Cell[BoxData["53"], "Output",
 CellChangeTimes->{
  3.5201748498524647`*^9, 3.5201755964289665`*^9, 3.5201759689652166`*^9, 
   3.520176096570639*^9, 3.520176270795743*^9, 3.5201767563679914`*^9, 
   3.5201779239636307`*^9, 3.5201779737397156`*^9, 3.520178034253021*^9, 
   3.5201781235217743`*^9, 3.5201783243397217`*^9, 3.5201790106557207`*^9, 
   3.520179111215495*^9, 3.520179193934038*^9, 3.520179238612116*^9, 
   3.5201792851333942`*^9, 3.520179464188905*^9, 3.5201795519958563`*^9, 
   3.5201813605206017`*^9, 3.5201816369274855`*^9, 3.520268562921894*^9, 
   3.520268731275334*^9, 3.520268862901922*^9, 3.5202688999923763`*^9, 
   3.5202690923238482`*^9, 3.5202718145609016`*^9, 3.520310605527149*^9, 
   3.520310986952505*^9, 3.5203117875504355`*^9, 3.5203121052247133`*^9, 
   3.527144937736272*^9, 3.527145808656602*^9, 3.5271460022383423`*^9, 
   3.5271470232621355`*^9, 3.527147594208538*^9, 3.5271480471407337`*^9, 
   3.5271482644491158`*^9, 3.5271486867978606`*^9, 3.527150051177257*^9, 
   3.5271501732786713`*^9, 3.527150353895789*^9, 3.5271505078056593`*^9, 
   3.5271507922409587`*^9, 3.5271508655922875`*^9, 3.5292308241893253`*^9, 
   3.529232467355811*^9, 3.5292325720319953`*^9, 3.5292359097876577`*^9, 
   3.5292362177945986`*^9, 3.52923641747495*^9, 3.5292366548761663`*^9, 
   3.529236716388075*^9, 3.529236967456916*^9, 3.529237057968275*^9, 
   3.5340685703005905`*^9, 3.5340689520644608`*^9, 3.534069383093218*^9, 
   3.5340699522134175`*^9, 3.534070177259413*^9, 3.5342496376713643`*^9, 
   3.5376214991089973`*^9, 3.5376216255628195`*^9, 3.5376228423191566`*^9, {
   3.537622948789344*^9, 3.537622964779372*^9}, 3.537623183304556*^9, 
   3.5376233619092693`*^9, 3.53762544031852*^9, 3.537628790067875*^9, 
   3.537694700279871*^9, 3.5376948681205654`*^9, 3.537695502136879*^9, 
   3.537695581915419*^9, 3.537695913619802*^9, 3.537696395629449*^9, 
   3.5376971054160953`*^9, 3.53769746081592*^9, {3.5376979709680157`*^9, 
   3.537697991622452*^9}, 3.5377005711065874`*^9, 3.537700989109321*^9, 
   3.537701150179604*^9, 3.5377050759606996`*^9, 3.5377676504506893`*^9, 
   3.537780186346308*^9, 3.537780584271807*^9, 3.5377809212957993`*^9, 
   3.5377810802912784`*^9, 3.537781242359963*^9, 3.537781378517002*^9, 
   3.537781527590864*^9, 3.5377817259608126`*^9, 3.537782399414995*^9, 
   3.5377827402755938`*^9, 3.5377829313447294`*^9, 3.5377831921303873`*^9, 
   3.537783440951825*^9, 3.5377835732244573`*^9, 3.5377841082429967`*^9, 
   3.537784245070837*^9, 3.5440922096735616`*^9, 3.5440972417784004`*^9, 
   3.544097365845418*^9, 3.5440979531562495`*^9, 3.5440997545080137`*^9, 
   3.54410337315477*^9, 3.54410346422773*^9, 3.5441037054207535`*^9, 
   3.5441039178463264`*^9, 3.5441040522093625`*^9, 3.5441050999862027`*^9, 
   3.5441057146584826`*^9, 3.5441059494700947`*^9, 3.5441071478183994`*^9, 
   3.5445912536162705`*^9, 3.544591490768835*^9, 3.544591653174124*^9, 
   3.5445929049717226`*^9, 3.544672173520233*^9, 3.544672374923753*^9, 
   3.544673274156186*^9, {3.5446733825253844`*^9, 3.5446734033975782`*^9}, 
   3.5449492192858257`*^9, 3.544951614473035*^9, 3.545015663086934*^9, 
   3.545015724878643*^9, 3.54510614256985*^9, 3.545114020963421*^9, 
   3.552821195921003*^9, 3.552822659968974*^9, 3.552822795938813*^9, 
   3.552822987118149*^9, 3.552823196283316*^9, 3.5528236666397424`*^9, 
   3.552823971605678*^9, 3.5528261170784464`*^9, 3.552826309646185*^9, 
   3.554207271773513*^9, 3.5542084672836123`*^9, 3.5613716977940197`*^9, 
   3.5617325867800083`*^9, 3.5617791987858076`*^9, 3.561781488403829*^9, 
   3.561781562332359*^9, 3.5617816532805185`*^9, 3.561781901586155*^9, 
   3.561781934034212*^9, 3.5617821017823067`*^9, 3.56178219500807*^9, 
   3.56178238844841*^9, 3.561782492921794*^9, 3.561782526118652*^9, 
   3.561784234588853*^9, 3.562766627419752*^9, 3.562766744201557*^9, 
   3.5627670826285515`*^9, 3.562767893503376*^9, 3.5627695461556787`*^9, 
   3.5627696680542927`*^9, {3.562771127953657*^9, 3.5627711474536915`*^9}, 
   3.5627731145401464`*^9, 3.562773202415101*^9, 3.562821272208412*^9, 
   3.562822346162099*^9, 3.5628235980662975`*^9, 3.562823661355609*^9, 
   3.562824062182713*^9, 3.5628245989806557`*^9, 3.5628252437297883`*^9, 
   3.5628253121203084`*^9, 3.562825372164814*^9, 3.5628259596004457`*^9, 
   3.5628261342115526`*^9, 3.562826248294553*^9, 3.562828066108573*^9, 
   3.562828564233048*^9, 3.562828736847351*^9, 3.562828879072801*^9, 
   3.5628304898400307`*^9, 3.562831305487463*^9, 3.5628317002003565`*^9, 
   3.562831820008567*^9, 3.562831852082223*^9, 3.562832308507825*^9, 
   3.562832421935624*^9, 3.562832729583764*^9, 3.5628336702196164`*^9, 
   3.5628337646309824`*^9, 3.5628338352523065`*^9, 3.563425633401393*^9, 
   3.5634263675074825`*^9, 3.563427213950369*^9, 3.563428699760379*^9, 
   3.5634287918317404`*^9, 3.563428870518279*^9, 3.5634296668538775`*^9, 
   3.5641236131336384`*^9, 3.564124346226726*^9, 3.5641248627914333`*^9, 
   3.5641250179815063`*^9, 3.5641304424642344`*^9, 3.564635026642227*^9, 
   3.5646354981842556`*^9, 3.5646721302086906`*^9, 3.5657592881699667`*^9, 
   3.565773667323635*^9, 3.565892024047901*^9, 3.5661948530486293`*^9, 
   3.5662039717114716`*^9, 3.5662119041996665`*^9, 3.566212640995961*^9, 
   3.566214734316838*^9, 3.5663991506781373`*^9, 3.5665437129115205`*^9, 
   3.56708281518173*^9, 3.567185137379181*^9, 3.567586523270301*^9, 
   3.567600479974924*^9, 3.5678594384591503`*^9, 3.5678605710377398`*^9, 
   3.567861307126033*^9, 3.5678615201756067`*^9, 3.567861619266981*^9, 
   3.567861716018351*^9, 3.5678618103205166`*^9, 3.5678620358345127`*^9, 
   3.5678622049388094`*^9, 3.5678625366587925`*^9, 3.567862683720251*^9, 
   3.5678627715328045`*^9, 3.5678633205289693`*^9, 3.5678634151587353`*^9, 
   3.567863936792452*^9, 3.5678640889561186`*^9, 3.567864254082409*^9, 
   3.56786476718291*^9, 3.567865016128147*^9, 3.5678653150558724`*^9, 
   3.5678655288396482`*^9, 3.5678774540577602`*^9, 3.567911948143292*^9, 
   3.56791306267165*^9, 3.567916910269186*^9, 3.567917676682932*^9, 
   3.567918361447135*^9, 3.56791861497878*^9, 3.5679194448534374`*^9, 
   3.5679197569163857`*^9, 3.5679242580918922`*^9, 3.567926175289459*^9, 
   3.5679264770875893`*^9, 3.567926861659465*^9, 3.567929474138854*^9, 
   3.567929590889459*^9, 3.5679296723528023`*^9, 3.567929856542326*^9, 
   3.567930083586125*^9, 3.5679301751270857`*^9, 3.5679303368525696`*^9, 
   3.567930622707472*^9, 3.5679310587594376`*^9, 3.5679312107661047`*^9, 
   3.567931331822317*^9, 3.567931467214955*^9, 3.567931520256048*^9, 
   3.567931626039834*^9, 3.5679319505048037`*^9, 3.5679326318360004`*^9, 
   3.5679327513946104`*^9, 3.5679331259678683`*^9, 3.567933233171257*^9, 
   3.567933464394863*^9, 3.5679347104012513`*^9, 3.5679359722260675`*^9, 
   3.5681150048343563`*^9, 3.5681159086541443`*^9, 3.5681222533764877`*^9, 
   3.5681223555566673`*^9, 3.568123412521924*^9, 3.5688951170050125`*^9, 
   3.5688954835900564`*^9, {3.570354946560212*^9, 3.5703549593054347`*^9}, 
   3.570357327546594*^9, 3.5703574467786036`*^9, 3.5703575333899555`*^9, 
   3.5703576112964926`*^9, 3.570357747189331*^9, 3.570357805034233*^9, 
   3.5703578503211126`*^9, 3.5703579053736095`*^9, 3.57035794008367*^9, 
   3.5703580040749826`*^9, 3.5703582329741845`*^9, 3.5703586285440793`*^9, 
   3.5703592172589135`*^9, 3.5703593078638725`*^9, 3.57035985862284*^9, 
   3.5703601286437144`*^9, 3.570360997909441*^9, 3.5703610771887803`*^9, 
   3.5703612161382246`*^9, 3.5703614883275023`*^9, 3.5703615692604446`*^9, 
   3.5703616698806214`*^9, 3.5703618789677887`*^9, 3.570362845031686*^9, 
   3.570363012107979*^9, 3.570363150620622*^9, 3.5703632391039777`*^9, 
   3.5703633000532846`*^9, 3.570363362390994*^9, 3.5703635574849367`*^9, 
   3.570364086715866*^9, 3.5703641658860054`*^9, 3.5703643670649586`*^9, 
   3.570364473129545*^9, 3.5703645587424955`*^9, 3.570364724523987*^9, 
   3.57036486306783*^9, 3.5703649341259546`*^9, 3.57036504515135*^9, {
   3.5703653944983635`*^9, 3.57036540413918*^9}, 3.5703654637000847`*^9, 
   3.5703657277149487`*^9, 3.570365791815461*^9, {3.570365855650773*^9, 
   3.5703658746516066`*^9}, 3.5703659377537174`*^9, 3.570365989296208*^9, 
   3.5703660970465975`*^9, 3.5703661767783375`*^9, 3.570366233422037*^9, 
   3.57036629775655*^9, 3.570366339814224*^9, 3.570366406644741*^9, 
   3.570366437985196*^9, 3.5703665738302345`*^9, 3.570366946436889*^9, 
   3.570367246269416*^9, 3.570367401146488*^9, 3.5703674958698545`*^9, 
   3.5703677611337204`*^9, 3.570367808838604*^9, 3.570367865373103*^9, 
   3.5703685582795205`*^9, 3.570368640101664*^9, 3.570368783715516*^9, 
   3.570368870779269*^9, 3.5703689312605753`*^9, 3.570426911468175*^9, 
   3.570427528308858*^9, 3.5704275979327803`*^9, 3.5704276677897034`*^9, 
   3.5704277546818557`*^9, 3.570431941356809*^9, 3.570432183812435*^9, 
   3.5704330983026414`*^9, 3.5704365147939587`*^9, 3.570438039244236*^9, 
   3.570438171611469*^9, 3.5704382603132243`*^9, 3.570438351978986*^9, 
   3.570438572875374*^9, 3.5704387568152966`*^9, 3.570438812819395*^9, 
   3.5769885492678547`*^9, 3.5769896650140142`*^9, 3.5769897139357004`*^9, 
   3.5769897566953754`*^9, 3.5769897971930466`*^9, 3.5769901347152395`*^9, 
   3.576990315238756*^9, 3.5769903618204384`*^9, 3.5769905279451303`*^9, 
   3.5769913893596435`*^9, 3.5769916130328364`*^9, 3.576992451550909*^9, 
   3.576992813315544*^9, 3.5769933550108957`*^9, 3.5769934320750313`*^9, 
   3.576993736431566*^9, 3.576994174715336*^9, 3.5769951068013725`*^9, 
   3.5769952505556254`*^9, 3.584427162909627*^9, 3.5844272958374605`*^9, 
   3.584427397690039*^9, 3.5844276674613132`*^9, 3.584427731873826*^9, 
   3.5844280224097366`*^9, 3.58442806435821*^9, 3.5844284683209195`*^9, 
   3.5844285894083323`*^9, 3.5844287687940474`*^9, 3.5844292430816803`*^9, 
   3.584429324045823*^9, 3.5844293648866944`*^9, 3.5844294271620035`*^9, 
   3.584429593037095*^9, 3.5844299884831896`*^9, 3.584431509908062*^9, 
   3.5844319828706927`*^9, 3.607069912864092*^9, 3.607071270082491*^9, 
   3.6070714051326804`*^9, 3.607071524432847*^9, 3.6070715705029116`*^9, 
   3.607072816205656*^9, 3.6070729102657876`*^9, 3.607082477966292*^9, 
   3.607083195767297*^9, 3.60708337615755*^9, 3.607083506947733*^9, 
   3.6070842328797493`*^9, 3.6070843140598626`*^9, 3.6070845159101453`*^9, 
   3.607084955780761*^9, 3.607085011700839*^9, 3.6070857755029087`*^9, 
   3.6070858732330456`*^9, 3.607085967443177*^9, 3.607086249163572*^9, 
   3.6070875398563786`*^9, 3.6070879189169097`*^9, 3.6070880697171206`*^9, 
   3.60708864091792*^9, 3.607089556430202*^9, 3.607089627000301*^9, 
   3.607092624981667*^9, 3.6190819470388002`*^9, 3.6190849400254726`*^9, 
   3.6229569245506306`*^9, 3.6426665140780125`*^9, {3.6427581842018175`*^9, 
   3.6427581928818293`*^9}, 3.6433505213073854`*^9, 3.6439958610573072`*^9, 
   3.643995928997402*^9, 3.6440359331351967`*^9, 3.6440360526353645`*^9, 
   3.644036535857041*^9, 3.644036618937157*^9, 3.6440377582297525`*^9, 
   3.6450048366817408`*^9, 3.645010390753708*^9, 3.645010849745351*^9, 
   3.646371251199275*^9, 3.6472546386761255`*^9, 3.6472549603975267`*^9, 
   3.6472558742417955`*^9, 3.647256112644431*^9, 3.647256297123983*^9, {
   3.6472563837299366`*^9, 3.647256412842602*^9}, {3.647328712691224*^9, 
   3.6473287278012457`*^9}, 3.6482642261208773`*^9, 3.648265042215204*^9, 
   3.648350173644246*^9, 3.6490027413761053`*^9, 3.6491724524763546`*^9, 
   3.649214296082588*^9, 3.649214330962637*^9, 3.6799843386618786`*^9, 
   3.6975461829610853`*^9, 3.6975462329621563`*^9, 3.728207785725684*^9, 
   3.7282080647693615`*^9, 3.7282096331702485`*^9, 3.7282096999419084`*^9, 
   3.728792430446991*^9, {3.8391506233962593`*^9, 3.839150646870261*^9}, 
   3.839150714249951*^9, 3.839150751085786*^9, 3.8391509006978483`*^9, 
   3.839676400495324*^9, 3.839676445258979*^9, 3.8400276376537657`*^9, 
   3.8400283712177277`*^9, 3.8400290500134*^9, 3.8449217775142293`*^9, 
   3.8630804631697736`*^9, 3.86317069766322*^9, {3.958384236136093*^9, 
   3.95838426613183*^9}},
 CellLabel->
  "Out[101]=",ExpressionUUID->"235b86f8-f437-ed45-a7db-2e7cb5b68b29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 InitializationCell->True,
 CellLabel->
  "In[102]:=",ExpressionUUID->"519f7bc8-9374-4a40-9f0f-c4c74682e61b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`SymSpin`\"\>", ",", "\<\"xAct`SpinFrames`\"\>", 
   ",", "\<\"xAct`SymManipulator`\"\>", ",", "\<\"xAct`TexAct`\"\>", 
   ",", "\<\"xAct`xCoba`\"\>", ",", "\<\"xAct`Spinors`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6472546386801257`*^9, 3.6472549604035273`*^9, 3.6472558742457957`*^9, 
   3.647256112648432*^9, 3.6472562971299834`*^9, {3.647256383736937*^9, 
   3.647256412847602*^9}, {3.6473287127012243`*^9, 3.647328727811246*^9}, {
   3.648264221480011*^9, 3.6482642261521425`*^9}, {3.6482650370366163`*^9, 
   3.64826504229334*^9}, 3.648350173644246*^9, 3.6490027413861055`*^9, 
   3.6491724524763546`*^9, 3.649214296082588*^9, 3.649214330972637*^9, 
   3.6799843386718783`*^9, 3.6975461829710855`*^9, 3.6975462329621563`*^9, 
   3.7282077857413425`*^9, 3.7282080647849817`*^9, 3.7282096331702485`*^9, 
   3.7282096999419084`*^9, 3.728792430458992*^9, {3.839150623416206*^9, 
   3.839150646897189*^9}, 3.8391507142838883`*^9, 3.839150751090773*^9, 
   3.839150900726797*^9, 3.8396764005043*^9, 3.8396764452759533`*^9, 
   3.8400276376607475`*^9, 3.84002837123568*^9, 3.840029050042323*^9, 
   3.8449217775311832`*^9, 3.863080463187725*^9, 3.8631706977124534`*^9, 
   3.958384236136093*^9, 3.9583842661587353`*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"e149e4eb-69e6-1446-8405-3ce497795bd5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->
  "In[103]:=",ExpressionUUID->"8dea597f-19e8-44bb-bea7-dd6dadc276c1"],

Cell[BoxData["\<\"xAct`SymSpin`Private`\"\>"], "Output",
 CellChangeTimes->{
  3.647254638689126*^9, 3.647254960417528*^9, 3.6472558742547965`*^9, 
   3.6472561126574326`*^9, 3.647256297141984*^9, {3.6472563837479377`*^9, 
   3.647256412859603*^9}, {3.6473287127112246`*^9, 3.6473287278312454`*^9}, 
   3.648264226245881*^9, 3.6482650424495993`*^9, 3.6483501736642466`*^9, 
   3.649002741396106*^9, 3.649172452486355*^9, 3.6492142960925884`*^9, 
   3.6492143309826374`*^9, 3.6799843386918783`*^9, 3.697546182981086*^9, 
   3.697546232982156*^9, 3.7282077857569685`*^9, 3.7282080648098965`*^9, 
   3.728209633201501*^9, 3.728209699973193*^9, 3.728792430482993*^9, {
   3.8391506234381475`*^9, 3.8391506469241176`*^9}, 3.8391507143167734`*^9, 
   3.839150751095785*^9, 3.8391509007517285`*^9, 3.839676400520257*^9, 
   3.839676445293886*^9, 3.8400276376786995`*^9, 3.8400283712516375`*^9, 
   3.840029050071245*^9, 3.84492177754714*^9, 3.863080463203683*^9, 
   3.8631706977472095`*^9, 3.9583842361518936`*^9, 3.9583842661587353`*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"e008f733-0ade-764f-ac80-8b6dcbdeb721"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. General tools", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.5703536834717937`*^9, 3.5703536884170027`*^9}, 
   3.5703540316030054`*^9, {3.570354071211475*^9, 3.570354074799481*^9}, {
   3.5703542672726192`*^9, 3.5703543005474777`*^9}, {3.6070695939336452`*^9, 
   3.6070696173636785`*^9}, {3.6070712241324267`*^9, 3.6070712297424345`*^9}, 
   3.644209823622263*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"7312c92b-59fe-4b2a-8a1e-413b4393a5f0"],

Cell["\<\
NumOfPrimedSlots, SymMultLeibnizRules etc should be defined in code called \
from DefFundSpinOperators..

Valence numbers should be controlled with one common setting. We have \
ShowValenceInfo and  TexValenceNumbers. I think ShowValenceInfo should be \
made flexible enough to be set during computations.
\[LineSeparator]Linear operator rules (including SymMult) should move \
constants out also for MultScal[const*something,_]\
\>", "Text",
 CellChangeTimes->{{3.837837865962536*^9, 3.8378381445566587`*^9}, {
  3.8378495802508793`*^9, 3.8378495877028933`*^9}, {3.8378509674989843`*^9, 
  3.837851025790203*^9}, {3.837851075115082*^9, 3.8378511110850353`*^9}, {
  3.838698879777926*^9, 
  3.83869888097019*^9}},ExpressionUUID->"b77f7a08-1380-48dd-a271-\
8a08f5280261"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InitSymSpin", "[", "sigma_", "]"}], ":=", 
  RowBox[{"$DefaultSpinBundle", "=", 
   RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.837849436388197*^9, 3.837849451344122*^9}, {
  3.8378495222924967`*^9, 3.8378495408918858`*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"69e974ae-2675-4005-a07a-f65143949571"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Index free spinor tools", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.4803237489364*^9, 3.4803237550828*^9}, {
   3.480337698869611*^9, 3.480337699179432*^9}, {3.4806826853529997`*^9, 
   3.4806827158666*^9}, 3.4807491220122004`*^9, 3.5160803831814957`*^9, {
   3.839127332605364*^9, 
   3.839127346498226*^9}},ExpressionUUID->"2c4e91b1-8ad7-428a-9d95-\
655419608b83"],

Cell[CellGroupData[{

Cell["Displaying tensors", "Subsubsection",
 CellChangeTimes->{{3.839042870862256*^9, 3.8390428741411123`*^9}, {
  3.839128931451537*^9, 
  3.8391289457253857`*^9}},ExpressionUUID->"28ffa8e3-04f2-4eab-87b8-\
f23e5ce2a709"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"HeldxTensorQ", ",", "HoldAllComplete"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"HeldxTensorQ", "[", "expr_", "]"}], ":=", 
   RowBox[{"xTensorQ", "[", 
    RowBox[{"Unevaluated", "[", "expr", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"MakeBoxes", "[", 
   RowBox[{
    RowBox[{"tensor_", "?", "HeldxTensorQ"}], ",", "StandardForm"}], "]"}], ":=", 
  RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
   RowBox[{"tensor", ",", 
    RowBox[{"xAct`xTensor`Private`xTensorBox", "[", 
     RowBox[{"tensor", ",", 
      RowBox[{"{", "}"}]}], "]"}]}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[105]:=",ExpressionUUID->"ddd7d09b-ed6a-4cd4-9469-912b5a389dcb"]
}, Closed]],

Cell[CellGroupData[{

Cell["Symmetric spinors of arbitrary valence", "Subsubsection",
 CellChangeTimes->{{3.839596704612186*^9, 
  3.839596719361332*^9}},ExpressionUUID->"36327dc2-5fb5-46f0-82ce-\
61d26def5ffc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "]"}], ":=", 
   RowBox[{
   "SymmetricSpinorOfArbitraryValenceQ", "[", "$DefaultSpinBundle", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8399288519713235`*^9, 3.839928873706938*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"eb1a694d-b813-475f-b3f5-19845ed34250"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "DummySymbol", "]"}], "^:=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "DummySymbol", "]"}], "^:=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeDaggerSymbol", "[", "DummySymbol", "]"}], "^:=", 
   "DummySymbol"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.83957020662097*^9, 3.839570212289209*^9}, {
  3.839571098706242*^9, 3.8395711523871403`*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"eda632b9-f89e-4b8e-a781-3307159039eb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SymSpinor", "[", 
   RowBox[{"numunprim_", ",", "numprim_", ",", 
    RowBox[{"vb_", "?", "VBundleQ"}]}], "]"}], ":=", 
  RowBox[{"SymSpinor", "[", 
   RowBox[{"numunprim", ",", "numprim", ",", "DummySymbol", ",", "vb"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SymSpinor", "[", 
   RowBox[{"numunprim_", ",", "numprim_", ",", "symb_"}], "]"}], ":=", 
  RowBox[{"SymSpinor", "[", 
   RowBox[{
   "numunprim", ",", "numprim", ",", "symb", ",", "$DefaultSpinBundle"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SymSpinor", "[", 
   RowBox[{"numunprim_", ",", "numprim_"}], "]"}], ":=", 
  RowBox[{"SymSpinor", "[", 
   RowBox[{
   "numunprim", ",", "numprim", ",", "DummySymbol", ",", 
    "$DefaultSpinBundle"}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.839570808096772*^9, 3.839570986480521*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"4f704b8e-62a3-48a2-8dba-2ea58bc64414"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"SymSpinor", "[", 
     RowBox[{"numunprim_", ",", "numprim_", ",", "symb_", ",", "vb_"}], "]"}],
     "]"}], "^:=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"SymSpinor", "[", 
     RowBox[{"numunprim_", ",", "numprim_", ",", "symb_", ",", "vb_"}], "]"}],
     "]"}], "^:=", 
   RowBox[{"SymmetricOfValence", "[", 
    RowBox[{"numunprim", ",", "numprim", ",", "vb"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"SymSpinor", "[", 
     RowBox[{"numunprim_", ",", "numprim_", ",", "symb_", ",", "vb_"}], "]"}],
     "]"}], "^:=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"And", "[", 
      RowBox[{
       RowBox[{"IntegerQ", "@", "numunprim"}], ",", 
       RowBox[{"IntegerQ", "@", "numprim"}], ",", 
       RowBox[{"numunprim", ">=", "0"}], ",", 
       RowBox[{"numprim", ">=", "0"}]}], "]"}], ",", 
     RowBox[{"xAct`SymManipulator`Private`CompatibleSym", "@", 
      RowBox[{"SlotsOfTensor", "[", 
       RowBox[{"SymSpinor", "[", 
        RowBox[{"numunprim", ",", "numprim", ",", "symb", ",", "vb"}], "]"}], 
       "]"}]}], ",", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"SymmetryGroupOfTensor", "::", "error"}], ",", 
        RowBox[{
        "\"\<Asked for the symmetry group of spinor with valence \
numbers(\>\"", "<>", 
         RowBox[{"ToString", "[", "numunprim", "]"}], "<>", "\"\<,\>\"", "<>", 
         RowBox[{"ToString", "[", "numprim", "]"}], "<>", "\"\<)\>\""}]}], 
       "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "vb_", "]"}], "[", 
    RowBox[{"SymSpinor", "[", 
     RowBox[{"numunprim_", ",", "numprim_", ",", "symb_", ",", "vb_"}], "]"}],
     "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"SymSpinor", "[", 
     RowBox[{"numunprim_", ",", "numprim_", ",", "symb_", ",", "vb_"}], "]"}],
     "]"}], "^:=", 
   RowBox[{"PrintAs", "[", "symb", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"SymSpinor", "[", 
     RowBox[{"numunprim_", ",", "numprim_", ",", "symb_", ",", "vb_"}], "]"}],
     "]"}], "^:=", 
   RowBox[{"Tex", "[", "symb", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{"SymSpinor", "[", 
    RowBox[{"numunprim_", ",", "numprim_", ",", "symb_", ",", "vb_"}], "]"}], 
   "]"}], "^:=", 
  RowBox[{"SymSpinor", "[", 
   RowBox[{"numprim", ",", "numunprim", ",", 
    RowBox[{"MakeDaggerSymbol", "[", "symb", "]"}], ",", "vb"}], 
   "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.839405400728777*^9, 3.839405498064797*^9}, {
   3.8394058913637543`*^9, 3.8394059429841948`*^9}, {3.839406069959503*^9, 
   3.8394060712509327`*^9}, {3.839473657233185*^9, 3.839473659793297*^9}, {
   3.839489186193885*^9, 3.8394892236285143`*^9}, {3.839490673561521*^9, 
   3.839490717293242*^9}, {3.839490780064739*^9, 3.839490839920169*^9}, {
   3.839491053593588*^9, 3.839491056906996*^9}, {3.839558039178314*^9, 
   3.839558063878134*^9}, {3.839562174151103*^9, 3.8395622603264847`*^9}, {
   3.8395624378717833`*^9, 3.839562545863061*^9}, {3.83956268803919*^9, 
   3.8395626978952208`*^9}, {3.8395627402632475`*^9, 3.839562744498996*^9}, {
   3.8395633927752275`*^9, 3.8395633948327274`*^9}, {3.8395637349436984`*^9, 
   3.8395637360078316`*^9}, 3.839564117248663*^9, {3.8395690178582373`*^9, 
   3.839569058403451*^9}, {3.839570267763207*^9, 3.839570298657751*^9}, 
   3.8395707333066483`*^9, {3.8395707781643248`*^9, 3.839570799348606*^9}, {
   3.839571004985899*^9, 3.839571074614315*^9}, {3.839571199307556*^9, 
   3.839571202329422*^9}, {3.8395718885459833`*^9, 3.83957189366858*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"075d1695-b66e-4c65-977b-804f8ad21895"],

Cell["UndefSpinor should work for these objects too:", "Text",
 CellChangeTimes->{{3.839406100805299*^9, 3.8394061133232*^9}, {
  3.83959856987368*^9, 
  3.83959859333407*^9}},ExpressionUUID->"8bb47fb2-b432-4837-ba6e-\
73d9397ee31b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefSymmetricSpinor", "[", 
   RowBox[{
   "symb_", ",", "numunprim_", ",", "numprim_", ",", "vb_", ",", "printas_"}],
    "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"symbdg", "=", 
      RowBox[{"MakeDaggerSymbol", "@", "symb"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"xTensorQ", "[", "symb", "]"}], "^:=", "True"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SlotsOfTensor", "[", "symb", "]"}], "^:=", 
      RowBox[{"Simplify", "@", 
       RowBox[{"SymmetricOfValence", "[", 
        RowBox[{"numunprim", ",", "numprim", ",", "vb"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SymmetryGroupOfTensor", "[", "symb", "]"}], "^:=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{"IntegerQ", "@", "numunprim"}], ",", 
          RowBox[{"IntegerQ", "@", "numprim"}], ",", 
          RowBox[{"numunprim", ">=", "0"}], ",", 
          RowBox[{"numprim", ">=", "0"}]}], "]"}], ",", 
        RowBox[{"xAct`SymManipulator`Private`CompatibleSym", "@", 
         RowBox[{"SlotsOfTensor", "[", "symb", "]"}]}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"SymmetryGroupOfTensor", "::", "error"}], ",", 
           RowBox[{
           "\"\<Asked for the symmetry group of spinor with valence \
numbers(\>\"", "<>", 
            RowBox[{"ToString", "[", "numunprim", "]"}], "<>", "\"\<,\>\"", "<>", 
            RowBox[{"ToString", "[", "numprim", "]"}], "<>", "\"\<)\>\""}]}], 
          "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "vb", "]"}], "[", 
       "symb", "]"}], "^=", "True"}], ";", "\n", 
     RowBox[{
      RowBox[{"DefInfo", "[", "symb", "]"}], "^:=", 
      RowBox[{"{", 
       RowBox[{"\"\<spinor\>\"", ",", " ", "\"\<\>\""}], "}"}]}], ";", "\n", 
     RowBox[{
      RowBox[{"HostsOf", "[", "symb", "]"}], "^:=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"BaseOfVBundle", "[", "vb", "]"}], ",", "vb"}], "}"}]}], ";", 
     "\n", 
     RowBox[{
      RowBox[{"ServantsOf", "[", "symb", "]"}], "^:=", 
      RowBox[{"{", "symbdg", "}"}]}], ";", "\n", 
     RowBox[{
      RowBox[{"DependenciesOfTensor", "[", "symb", "]"}], "^:=", 
      RowBox[{"{", 
       RowBox[{"BaseOfVBundle", "[", "vb", "]"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PrintAs", "[", "symb", "]"}], "^:=", "printas"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Tex", "[", "symb", "]"}], "^:=", 
      RowBox[{"Tex", "[", "printas", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Dagger", "[", "symb", "]"}], "^:=", "symbdg"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"xTensorQ", "[", "symbdg", "]"}], "^:=", "True"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SlotsOfTensor", "[", "symbdg", "]"}], "^:=", 
      RowBox[{"SymmetricOfValence", "[", 
       RowBox[{"numprim", ",", "numunprim", ",", "vb"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SymmetryGroupOfTensor", "[", "symbdg", "]"}], "^:=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{"IntegerQ", "@", "numunprim"}], ",", 
          RowBox[{"IntegerQ", "@", "numprim"}], ",", 
          RowBox[{"numunprim", ">=", "0"}], ",", 
          RowBox[{"numprim", ">=", "0"}]}], "]"}], ",", 
        RowBox[{"xAct`SymManipulator`Private`CompatibleSym", "@", 
         RowBox[{"SlotsOfTensor", "[", "symbdg", "]"}]}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"SymmetryGroupOfTensor", "::", "error"}], ",", 
           RowBox[{
           
           "\"\<Asked for the symmetry group of spinor with valence \
numbers(\>\"", "<>", 
            RowBox[{"ToString", "[", "numprim", "]"}], "<>", "\"\<,\>\"", "<>", 
            RowBox[{"ToString", "[", "numunprim", "]"}], "<>", 
            "\"\<)\>\""}]}], "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "vb", "]"}], "[", 
       "symbdg", "]"}], "^=", "True"}], ";", "\n", 
     RowBox[{
      RowBox[{"DefInfo", "[", "symbdg", "]"}], "^:=", 
      RowBox[{"{", 
       RowBox[{"\"\<spinor\>\"", ",", " ", "\"\<\>\""}], "}"}]}], ";", "\n", 
     RowBox[{
      RowBox[{"HostsOf", "[", "symbdg", "]"}], "^:=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"BaseOfVBundle", "[", 
         RowBox[{"Dagger", "[", "vb", "]"}], "]"}], ",", 
        RowBox[{"Dagger", "[", "vb", "]"}]}], "}"}]}], ";", "\n", 
     RowBox[{
      RowBox[{"ServantsOf", "[", "symbdg", "]"}], "^:=", 
      RowBox[{"{", "}"}]}], ";", "\n", 
     RowBox[{
      RowBox[{"DependenciesOfTensor", "[", "symbdg", "]"}], "^:=", 
      RowBox[{"{", 
       RowBox[{"BaseOfVBundle", "[", 
        RowBox[{"Dagger", "[", "vb", "]"}], "]"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PrintAs", "[", "symbdg", "]"}], "^:=", 
      RowBox[{"OverscriptBox", "[", 
       RowBox[{"printas", ",", "\"\<_\>\""}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Tex", "[", "symbdg", "]"}], "^:=", 
      RowBox[{"Tex", "[", 
       RowBox[{"OverscriptBox", "[", 
        RowBox[{"printas", ",", "\"\<_\>\""}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Dagger", "[", "symbdg", "]"}], "^:=", "symb"}], ";"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8407039649071407`*^9, 3.8407039665367823`*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"304c69d0-03bd-41ac-9cb3-370c76e1d6e9"]
}, Closed]],

Cell[CellGroupData[{

Cell["MultScal", "Subsubsection",
 CellChangeTimes->{{3.837837098811248*^9, 3.8378371377586718`*^9}, 
   3.837854903079381*^9, 3.838698647703586*^9, 3.839676243774181*^9, 
   3.8396763567020173`*^9},ExpressionUUID->"4cdec2f0-04b6-4103-a111-\
83157f3a6f37"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_", ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_", ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"SlotsOfTensor", "[", "LL", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_", ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"SymmetryGroupOfTensor", "[", "LL", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5983401343061852`*^9, 3.59834013778619*^9}, {
   3.59834019492627*^9, 3.5983402231263094`*^9}, 3.598340257576358*^9, 
   3.5983407124969945`*^9, {3.600587457682276*^9, 3.600587472642297*^9}, {
   3.6074207535924625`*^9, 3.6074207543224635`*^9}, {3.6081922217456264`*^9, 
   3.6081922276056347`*^9}, {3.837853889285348*^9, 3.837853898721283*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"46df5fd8-e65d-4be4-b045-7a3d8c678181"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MultScal", "[", 
    RowBox[{"c_", ",", "expr_TensorPlus"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"MultScal", "[", 
      RowBox[{"c", ",", "#"}], "]"}], "&"}], "/@", "expr"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultScal", "[", 
    RowBox[{"scal_", ",", 
     RowBox[{"ZeroTensor", "[", "vbs_", "]"}]}], "]"}], ":=", 
   RowBox[{"ZeroTensor", "[", "vbs", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultScal", "[", 
    RowBox[{"c1_", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{"c2_", ",", 
       RowBox[{"TT_", "?", "xTensorQ"}]}], "]"}]}], "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{
     RowBox[{"c1", "*", "c2"}], ",", "TT"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultScal", "[", 
    RowBox[{"1", ",", "expr_"}], "]"}], ":=", "expr"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_", ",", "LL_"}], "]"}], "[", "inds___", "]"}], ":=", 
   RowBox[{"scal", "*", 
    RowBox[{"LL", "[", "inds", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultScal", "[", 
    RowBox[{"c_", ",", "expr_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"MultScal", "[", 
      RowBox[{"c", ",", "#"}], "]"}], "&"}], "/@", "expr"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.677655079979556*^9, 3.6776551823796997`*^9}, {
  3.837853943579941*^9, 3.837853980322173*^9}, {3.837854010886981*^9, 
  3.837854011106041*^9}, {3.8388199188746667`*^9, 3.8388199371349025`*^9}, {
  3.8400282847618937`*^9, 3.840028292434012*^9}, {3.958392082868595*^9, 
  3.958392119374151*^9}},ExpressionUUID->"3b1c74da-aa6e-46d6-a6c2-\
b8465996a782"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfUnprimedSlots", "[", "spin_", "]"}], "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"Scal_", ",", 
      RowBox[{"BB_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "BB", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfPrimedSlots", "[", "spin_", "]"}], "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"Scal_", ",", 
      RowBox[{"BB_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "BB", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[131]:=",ExpressionUUID->"9d63dc88-a343-4b77-ade3-9c51100b07bb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MultScal", "[", 
    RowBox[{"0", ",", 
     RowBox[{"TT_", "?", "xTensorQ"}]}], "]"}], ":=", 
   RowBox[{"ZeroTensorOfTensor", "@", "TT"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.839129642804485*^9, 3.8391296605322437`*^9}, {
  3.839154988352277*^9, 3.8391549969791784`*^9}, {3.839155410842948*^9, 
  3.839155414645834*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"dd113303-f598-486f-9fea-715b5ffb5235"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{"MultScal", "[", 
    RowBox[{"scal_", ",", 
     RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
  RowBox[{"MultScal", "[", 
   RowBox[{
    RowBox[{"Dagger", "@", "scal"}], ",", 
    RowBox[{"DaggerTensor", "@", "LL"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6569093915461874`*^9, 3.6569094374003696`*^9}, {
  3.821872119265035*^9, 3.82187211998411*^9}},
 CellLabel->
  "In[134]:=",ExpressionUUID->"f284edf3-2592-42bc-948f-cf9ba51fde83"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_Plus", ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<(\>\"", ",", "\"\<(\>\"", ",", 
      RowBox[{"MakeBoxes", "[", 
       RowBox[{"scal", ",", "StandardForm"}], "]"}], ",", "\"\<)\>\"", ",", 
      RowBox[{"PrintAs", "[", "LL", "]"}], ",", "\"\<)\>\""}], "}"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<(\>\"", ",", "\"\<-\>\"", ",", 
      RowBox[{"PrintAs", "[", "LL", "]"}], ",", "\"\<)\>\""}], "}"}], "]"}]}],
   ";", 
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_", ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<(\>\"", ",", 
      RowBox[{"MakeBoxes", "[", 
       RowBox[{"scal", ",", "StandardForm"}], "]"}], ",", 
      RowBox[{"PrintAs", "[", "LL", "]"}], ",", "\"\<)\>\""}], "}"}], "]"}]}],
   ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.820729629430834*^9, 3.8207296714866114`*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"485ce97e-22dd-44f2-b685-f9323163f15f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrintAsNoPar", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_Plus", ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<(\>\"", ",", 
      RowBox[{"MakeBoxes", "[", 
       RowBox[{"scal", ",", "StandardForm"}], "]"}], ",", "\"\<)\>\"", ",", 
      RowBox[{"PrintAs", "[", "LL", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAsNoPar", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", 
      RowBox[{"PrintAs", "[", "LL", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAsNoPar", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_", ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"MakeBoxes", "[", 
       RowBox[{"scal", ",", "StandardForm"}], "]"}], ",", 
      RowBox[{"PrintAs", "[", "LL", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PrintAsNoPar", "[", "expr___", "]"}], ":=", 
  RowBox[{"PrintAs", "[", "expr", "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.820728148865039*^9, 3.8207282043514533`*^9}, {
  3.8207284337043624`*^9, 3.8207284479362803`*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"6e3f1310-b5b8-42d5-a559-3d8cd2501b21"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_", ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"xAct`TexAct`Private`TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
     RowBox[{"xAct`TexAct`Private`TexFactor", "[", 
      RowBox[{"scal", "/.", "xAct`TexAct`ToOrderedPlus"}], "]"}], ",", 
     RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", "LL", "]"}], ",", 
     RowBox[{"xAct`TexAct`Private`TexClose", "[", "\"\<)\>\"", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.839168510126968*^9, 3.8391685197921314`*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"c0c537eb-3af4-4048-a919-37a6402b7e12"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"scal_", ",", 
      RowBox[{"LL_", "?", "xTensorQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"xAct`TexAct`Private`TexFactor", "[", 
      RowBox[{"scal", "/.", "xAct`TexAct`ToOrderedPlus"}], "]"}], ",", 
     RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", "LL", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8391685605102863`*^9, 3.8391685676551867`*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"34184e2f-eea5-4c88-b77a-ba535334bbef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$KopExclude", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[143]:=",ExpressionUUID->"691f76bb-7c18-495b-b753-72a5abca7e4a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ImposeMultScal", "[", 
    RowBox[{"expr_Plus", ",", "scal_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"ImposeMultScal", "[", 
      RowBox[{"#", ",", "scal"}], "]"}], "&"}], "/@", "expr"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeMultScal", "[", 
    RowBox[{"expr_Equal", ",", "scal_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"ImposeMultScal", "[", 
      RowBox[{"#", ",", "scal"}], "]"}], "&"}], "/@", "expr"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeMultScal", "[", 
    RowBox[{"0", ",", "scal_"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeMultScal", "[", 
    RowBox[{"expr_", ",", "0"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeMultScal", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c_", "?", "ConstantQ"}], "*", "expr_"}], ",", "scal_"}], "]"}],
    ":=", 
   RowBox[{"c", "*", 
    RowBox[{"ImposeMultScal", "[", 
     RowBox[{"expr", ",", "scal"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeMultScal", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"TT_", "?", "xTensorQ"}], "[", "tinds___", "]"}], ",", 
     "scal_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"MultScal", "[", 
     RowBox[{"scal", ",", "TT"}], "]"}], "[", "tinds", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeMultScal", "[", 
   RowBox[{"expr_Times", ",", "scal_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"factorlist", "=", 
      RowBox[{"xAct`xTensor`Private`ListOfFactors", "@", "expr"}]}], "}"}], 
    ",", 
    RowBox[{
     RowBox[{"Times", "@@", 
      RowBox[{"Select", "[", 
       RowBox[{"factorlist", ",", 
        RowBox[{"Function", "[", 
         RowBox[{"x", ",", 
          RowBox[{"Not", "@", 
           RowBox[{"AllTrue", "[", 
            RowBox[{"$KopExclude", ",", 
             RowBox[{
              RowBox[{"FreeQ", "[", 
               RowBox[{"x", ",", "#"}], "]"}], "&"}]}], "]"}]}]}], "]"}]}], 
       "]"}]}], "*", 
     RowBox[{"ImposeMultScal2", "[", 
      RowBox[{
       RowBox[{"Times", "@@", 
        RowBox[{"Select", "[", 
         RowBox[{"factorlist", ",", 
          RowBox[{"Function", "[", 
           RowBox[{"x", ",", 
            RowBox[{"AllTrue", "[", 
             RowBox[{"$KopExclude", ",", 
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{"x", ",", "#"}], "]"}], "&"}]}], "]"}]}], "]"}]}], 
         "]"}]}], ",", "scal"}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeMultScal2", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"TT_", "?", "xTensorQ"}], "[", "tinds___", "]"}], ",", 
     "scal_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"MultScal", "[", 
     RowBox[{"scal", ",", "TT"}], "]"}], "[", "tinds", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ImposeMultScal2", "[", 
    RowBox[{
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"TT_", "?", "xTensorQ"}], "[", "tinds1___", "]"}], ",", 
       "z__"}], "]"}], ",", "scal_"}], "]"}], ":=", 
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MultScal", "[", 
       RowBox[{"scal", ",", "TT"}], "]"}], "[", "tinds1", "]"}], ",", "z"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ImposeMultScal2", "[", 
   RowBox[{"z_", ",", "scal_"}], "]"}], ":=", 
  RowBox[{"Times", "[", 
   RowBox[{"z", ",", "scal"}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[144]:=",ExpressionUUID->"92a12f91-ce2b-4f34-89cf-018b3e76d735"]
}, Closed]],

Cell[CellGroupData[{

Cell["TensorPlus", "Subsubsection",
 CellChangeTimes->{{3.672053539448455*^9, 3.6720535453194637`*^9}, {
   3.6720536331995864`*^9, 3.6720536373095922`*^9}, {3.6720537626697674`*^9, 
   3.6720537665997734`*^9}, {3.6720538687999163`*^9, 
   3.6720538751299253`*^9}, {3.8378371640853024`*^9, 
   3.8378371923786163`*^9}, {3.83783725186909*^9, 3.837837265370945*^9}, {
   3.837851674837686*^9, 3.837851676908133*^9}, {3.8378548850945883`*^9, 
   3.837854896127878*^9}, 3.8388202523326955`*^9, {3.8396762365025196`*^9, 
   3.839676238399978*^9}},ExpressionUUID->"3e688684-cb10-4391-83d5-\
98ad70c62658"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{
      RowBox[{"TT_", "?", "xTensorQ"}], ",", "more__"}], "]"}], "]"}], "^:=", 
   "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{
      RowBox[{"TT_", "?", "xTensorQ"}], ",", "more__"}], "]"}], "]"}], "^:=", 
   
   RowBox[{"SlotsOfTensor", "@", "TT"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.837854408377267*^9, 3.837854408681789*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"279edba8-7c24-4874-91ac-e3f568a9fe14"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{"TT_", "?", "xTensorQ"}], "]"}], ":=", "TT"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[156]:=",ExpressionUUID->"5b0e66bf-0455-473f-8112-729bcc490eb2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", "tensors___", "]"}], "[", "inds___", "]"}], ":=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", "inds", "]"}], "&"}], "/@", 
     RowBox[{"List", "[", "tensors", "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[157]:=",ExpressionUUID->"5e157419-a66a-4f46-a195-13a5ae13f4d2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z___", ",", 
     RowBox[{"ZeroTensor", "[", "vbs_", "]"}], ",", "more___"}], "]"}], ":=", 
   
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z", ",", "more"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z___", ",", "0", ",", "more___"}], "]"}], ":=", 
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z", ",", "more"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{"x___", ",", 
     RowBox[{"TensorPlus", "[", "expr__", "]"}], ",", "z___"}], "]"}], ":=", 
   RowBox[{"TensorPlus", "[", 
    RowBox[{"x", ",", "expr", ",", "z"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8378546015622168`*^9, 3.8378546262465487`*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"72e4655a-e899-4b5c-bce4-c3327aa1fbbd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z___", ",", "a_", ",", "b___", ",", "a_", ",", "d___"}], "]"}], ":=", 
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{"2", ",", "a"}], "]"}], ",", "b", ",", "d"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z___", ",", "a_", ",", "f___", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{"c_", ",", "a_"}], "]"}], ",", "d___"}], "]"}], ":=", 
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{
       RowBox[{"c", "+", "1"}], ",", "a"}], "]"}], ",", "f", ",", "d"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z___", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{"c_", ",", "a_"}], "]"}], ",", "f___", ",", "a_", ",", "d___"}],
     "]"}], ":=", 
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{
       RowBox[{"c", "+", "1"}], ",", "a"}], "]"}], ",", "f", ",", "d"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z___", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{"b_", ",", "a_"}], "]"}], ",", "f___", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{"c_", ",", "a_"}], "]"}], ",", "d___"}], "]"}], ":=", 
   RowBox[{"TensorPlus", "[", 
    RowBox[{"z", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{
       RowBox[{"b", "+", "c"}], ",", "a"}], "]"}], ",", "f", ",", "d"}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7725351620438786`*^9, 3.7725351880583663`*^9}, {
  3.776747147741058*^9, 3.7767471481100445`*^9}, {3.7767516250092306`*^9, 
  3.7767517684282336`*^9}, {3.8378548032138233`*^9, 3.837854817909625*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"9d102934-9801-4eb3-b5da-916893a458a6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{
     RowBox[{"lhs1_", "\[Equal]", "rhs1_"}], ",", 
     RowBox[{"lhs2_", "\[Equal]", "rhs2_"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"TensorPlus", "[", 
     RowBox[{"lhs1", ",", "lhs2"}], "]"}], "==", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{"rhs1", ",", "rhs2"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{
     RowBox[{"lhs1_", "\[Equal]", "rhs1_"}], ",", "expr_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"TensorPlus", "[", 
     RowBox[{"lhs1", ",", "expr"}], "]"}], "==", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{"rhs1", ",", "expr"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlus", "[", 
    RowBox[{"list1_List", ",", "list2_List"}], "]"}], ":=", 
   RowBox[{"MapThread", "[", 
    RowBox[{"TensorPlus", ",", 
     RowBox[{"{", 
      RowBox[{"list1", ",", "list2"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9583873382249203`*^9, 
  3.958387349579199*^9}},ExpressionUUID->"7910d4c0-4566-4cdb-98a9-\
f0b22ca8812e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TensorMinus", "[", 
    RowBox[{
     RowBox[{"lhs1_", "\[Equal]", "rhs1_"}], ",", 
     RowBox[{"lhs2_", "\[Equal]", "rhs2_"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"TensorPlus", "[", 
     RowBox[{"lhs1", ",", 
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "lhs2"}], "]"}]}], "]"}], "==", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{"rhs1", ",", 
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "rhs2"}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorMinus", "[", 
    RowBox[{
     RowBox[{"lhs1_", "\[Equal]", "rhs1_"}], ",", "expr_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"TensorPlus", "[", 
     RowBox[{"lhs1", ",", 
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "expr"}], "]"}]}], "]"}], "==", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{"rhs1", ",", 
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "expr"}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorMinus", "[", 
    RowBox[{"list1_List", ",", "list2_List"}], "]"}], ":=", 
   RowBox[{"MapThread", "[", 
    RowBox[{"TensorMinus", ",", 
     RowBox[{"{", 
      RowBox[{"list1", ",", "list2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorMinus", "[", 
    RowBox[{"expr1_", ",", "expr2_"}], "]"}], ":=", 
   RowBox[{"TensorPlus", "[", 
    RowBox[{"expr1", ",", 
     RowBox[{"MultScal", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "expr2"}], "]"}]}], "]"}]}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.840700237556052*^9, 3.8407002414357567`*^9}, 
   3.8407002876826053`*^9, {3.958387042841442*^9, 3.9583870965693703`*^9}, {
   3.9583873169613743`*^9, 
   3.958387328930668*^9}},ExpressionUUID->"47849868-a21f-4a6b-899d-\
ff8affac9b40"],

Cell["\<\
Perhaps we should check that all tensors in a TensorPlus has the same valence?\
\>", "Text",
 CellChangeTimes->{{3.8391496089065027`*^9, 
  3.83914963884975*^9}},ExpressionUUID->"a5b79cc8-90c5-49e3-a516-\
803d740a6bc5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfUnprimedSlots", "[", "spin_", "]"}], "[", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{
      RowBox[{"TT_", "?", "xTensorQ"}], ",", "more__"}], "]"}], "]"}], "^:=", 
   
   RowBox[{
    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfPrimedSlots", "[", "spin_", "]"}], "[", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{
      RowBox[{"TT_", "?", "xTensorQ"}], ",", "more__"}], "]"}], "]"}], "^:=", 
   
   RowBox[{
    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.83784302845949*^9, 3.8378430410878763`*^9}, {
  3.838964807107132*^9, 3.838964816228479*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"0d8523dd-6ac4-4c9f-921d-5bac23f35ac3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CoeffFromMultScal", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{
      RowBox[{"c_", "?", "ConstantQ"}], ",", " ", "T_"}], "]"}], "]"}], " ", ":=",
    " ", "c"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CoeffFromMultScal", "[", "_", "]"}], " ", ":=", " ", "1"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[172]:=",ExpressionUUID->"cfb2ef23-47e1-483b-b4ca-c5e97d1b6068"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlusToList", "[", "expr_TensorPlus", "]"}], ":=", 
   RowBox[{"List", "@@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlusToList", "[", 
    RowBox[{"ZeroTensor", "[", "__", "]"}], "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlusToList", "[", "expr_", "]"}], ":=", 
   RowBox[{"{", "expr", "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8447632594307814`*^9, 3.8447632922677975`*^9}, {
  3.863163323825885*^9, 3.8631633433112683`*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"13fc7bb0-da63-4000-aae0-3f54dfaea3e8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IsolateTensorPlus", "[", 
   RowBox[{"eq_Equal", ",", 
    RowBox[{"i_", ":", "1"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tmpexpr", "=", 
      RowBox[{"TensorPlusToList", "@", 
       RowBox[{"TensorMinus", "[", 
        RowBox[{
         RowBox[{"eq", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"eq", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MultScal", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"CoeffFromMultScal", "[", 
         RowBox[{"tmpexpr", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", 
       RowBox[{"tmpexpr", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "==", 
     RowBox[{"MultScal", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"CoeffFromMultScal", "[", 
          RowBox[{"tmpexpr", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], ",", 
       RowBox[{"TensorPlus", "@@", 
        RowBox[{"Append", "[", 
         RowBox[{
          RowBox[{"Delete", "[", 
           RowBox[{"tmpexpr", ",", 
            RowBox[{"{", "i", "}"}]}], "]"}], ",", 
          RowBox[{"ZeroTensorOfTensor", "@", 
           RowBox[{"tmpexpr", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8447683408701954`*^9, 3.8447683673835506`*^9}, {
  3.8447684158844323`*^9, 3.844768447845644*^9}, {3.844768543946348*^9, 
  3.8447685453189974`*^9}, {3.8447685977234077`*^9, 3.8447686871596813`*^9}, {
  3.844768723637839*^9, 3.8447688578857155`*^9}, {3.863077942328566*^9, 
  3.863077945632761*^9}, {3.8631706147701197`*^9, 3.8631706226110673`*^9}},
 CellLabel->
  "In[177]:=",ExpressionUUID->"0bcfb45c-deec-4845-a119-751af86d6654"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"IsolateTensorPlusPattern", "[", 
    RowBox[{"eq_Equal", ",", "pat_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tmpexpr", "=", 
        RowBox[{"TensorPlusToList", "@", 
         RowBox[{"TensorMinus", "[", 
          RowBox[{
           RowBox[{"eq", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"eq", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], ",", "pos", ",", 
       "i"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pos", "=", 
       RowBox[{"Position", "[", 
        RowBox[{"tmpexpr", ",", "pat"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", "pos"}], "==", "0"}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"IsolateTensorPlusPattern", "::", "error"}], ",", " ", 
           RowBox[{"\"\<Could not find \>\"", "<>", 
            RowBox[{"ToString", "@", "pat"}]}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i", "=", 
       RowBox[{"First", "@", 
        RowBox[{"First", "@", "pos"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MultScal", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"CoeffFromMultScal", "[", 
           RowBox[{"tmpexpr", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"tmpexpr", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "==", 
       RowBox[{"MultScal", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", 
          RowBox[{"CoeffFromMultScal", "[", 
           RowBox[{"tmpexpr", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"TensorPlus", "@@", 
          RowBox[{"Append", "[", 
           RowBox[{
            RowBox[{"Delete", "[", 
             RowBox[{"tmpexpr", ",", 
              RowBox[{"{", "i", "}"}]}], "]"}], ",", 
            RowBox[{"ZeroTensorOfTensor", "@", 
             RowBox[{"tmpexpr", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]}], "]"}]}]}], "]"}]}]}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8396900823931065`*^9, 3.8396901153272033`*^9}, {
  3.8396901975182996`*^9, 3.839690213881558*^9}, {3.863170560985221*^9, 
  3.8631705766704483`*^9}},
 CellLabel->
  "In[178]:=",ExpressionUUID->"bf94af3d-0008-431e-827a-b78fb93cda5e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"IsolateFirstInLHS", "[", 
    RowBox[{"Equal", "[", 
     RowBox[{"lhs_", ",", "rhs_"}], "]"}], "]"}], ":=", 
   RowBox[{"IsolateTensorPlusPattern", "[", 
    RowBox[{
     RowBox[{"lhs", "==", "rhs"}], ",", 
     RowBox[{"RemoveMultscalCoeff", "@", 
      RowBox[{"First", "@", 
       RowBox[{"TensorPlusToList", "[", "lhs", "]"}]}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8447681454968834`*^9, 3.8447682032942815`*^9}, {
   3.844768248889377*^9, 3.8447682492578*^9}, {3.844768953869841*^9, 
   3.844768964649821*^9}, {3.8630798917204943`*^9, 3.8630799319527082`*^9}, {
   3.8631693297657747`*^9, 3.863169331325408*^9}, 3.863169435678852*^9},
 CellLabel->
  "In[179]:=",ExpressionUUID->"8fee5ed6-4814-455c-8177-d382c3a89147"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"IsolateFirstInRHS", "[", 
    RowBox[{"Equal", "[", 
     RowBox[{"lhs_", ",", "rhs_"}], "]"}], "]"}], ":=", 
   RowBox[{"IsolateTensorPlusPattern", "[", 
    RowBox[{
     RowBox[{"lhs", "==", "rhs"}], ",", 
     RowBox[{"RemoveMultscalCoeff", "@", 
      RowBox[{"First", "@", 
       RowBox[{"TensorPlusToList", "[", "rhs", "]"}]}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8447681454968834`*^9, 3.8447682032942815`*^9}, {
   3.844768248889377*^9, 3.8447682492578*^9}, {3.844768953869841*^9, 
   3.844768964649821*^9}, {3.8630798917204943`*^9, 3.8630799319527082`*^9}, {
   3.8631634205004835`*^9, 3.8631634233735104`*^9}, {3.8631693341303434`*^9, 
   3.8631693360646267`*^9}, 3.863169438317686*^9},
 CellLabel->
  "In[180]:=",ExpressionUUID->"9a5fa022-edc5-4042-ac4c-67afb8672d5c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrintAs", "[", 
   RowBox[{"TensorPlus", "[", 
    RowBox[{"expr1_", ",", "expr2___"}], "]"}], "]"}], "^:=", 
  RowBox[{"RowBox", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
       RowBox[{"expr1", ",", 
        RowBox[{"PrintAsNoPar", "[", "expr1", "]"}]}], "]"}], "}"}], ",", 
     RowBox[{"Join", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"xAct`SpinFrames`Private`BoxStartWithMinusQ", "[", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"xAct`xTensor`Private`interpretbox", "@@", "#"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"\"\<+\>\"", ",", 
             RowBox[{"xAct`xTensor`Private`interpretbox", "@@", "#"}]}], 
            "}"}]}], "]"}], "&"}], "/@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"#", ",", 
             RowBox[{"PrintAsNoPar", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
          RowBox[{"List", "[", "expr2", "]"}]}], ")"}]}], ")"}]}]}], "]"}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.820729228639411*^9, 3.8207292656884775`*^9}, {
   3.820729307809532*^9, 3.8207293100734773`*^9}, 3.821873645399929*^9},
 CellLabel->
  "In[181]:=",ExpressionUUID->"556782ae-2100-445c-a22f-8504f1c0f279"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"TensorPlus", "[", "expr___", "]"}], "]"}], "^:=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Riffle", "[", 
     RowBox[{
      RowBox[{"xAct`SymManipulator`Private`TexFundOp", "/@", 
       RowBox[{"List", "[", "expr", "]"}]}], ",", "\"\< + \>\""}], "]"}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.672057163075528*^9, 3.672057178025549*^9}, {
  3.6720572269256177`*^9, 3.6720572485056477`*^9}, {3.6720572939157114`*^9, 
  3.6720572950857134`*^9}, {3.672057354875797*^9, 3.672057398435858*^9}, {
  3.672057433995908*^9, 3.67205744303592*^9}, {3.6720575239360332`*^9, 
  3.672057525426036*^9}, {3.672108629504411*^9, 3.672108649664439*^9}, {
  3.672109106575079*^9, 3.672109111465086*^9}, {3.6721099723172913`*^9, 
  3.6721099878373127`*^9}, {3.820729395715678*^9, 3.8207293967369065`*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"5b9f4b19-5e6f-4cc5-8fe3-e2dfead1e2d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xAct`TexAct`Private`TexFactor", "[", "expr_TensorPlus", "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"xAct`TexAct`Private`TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
     RowBox[{"Tex", "[", "expr", "]"}], ",", 
     RowBox[{"xAct`TexAct`Private`TexClose", "[", "\"\<)\>\"", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[183]:=",ExpressionUUID->"07755b8a-3448-41a3-ad66-13da90ce329f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
   "xAct`SymManipulator`Private`TexFundOp", "[", "expr_TensorPlus", "]"}], ":=", 
   RowBox[{"xAct`TexAct`Private`TexFactor", "[", "expr", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7338426195648336`*^9, 3.7338426426971564`*^9}},
 CellLabel->
  "In[184]:=",ExpressionUUID->"75885b45-5ca1-46b7-90be-3cd560f9dc1b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymmetricSpinorOfValenceQ", "[", 
    RowBox[{
     RowBox[{"TensorPlus", "[", "arg__", "]"}], ",", "k_", ",", "l_", ",", 
     "spin_"}], "]"}], "^:=", 
   RowBox[{"And", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymmetricSpinorOfValenceQ", "[", 
        RowBox[{"#", ",", "k", ",", "l", ",", "spin"}], "]"}], "&"}], "/@", 
      RowBox[{"List", "[", "arg", "]"}]}], ")"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8391493941869926`*^9, 3.8391494200596013`*^9}},
 CellLabel->
  "In[185]:=",ExpressionUUID->"92c2205e-29ff-4525-8565-10076100b3f4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"DummyTensor", "[", 
     RowBox[{"vbs_", ",", "sym_"}], "]"}], "]"}], "^=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"DummyTensor", "[", 
     RowBox[{"vbs_", ",", "sym_"}], "]"}], "]"}], "^:=", "vbs"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"DummyTensor", "[", 
     RowBox[{"vbs_", ",", "sym_"}], "]"}], "]"}], "^:=", "sym"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"DummyTensor", "[", 
     RowBox[{"vbs_", ",", "sym_"}], "]"}], "]"}], "^=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"DummyTensor", "[", 
     RowBox[{"vbs_", ",", "sym_"}], "]"}], "]"}], "^=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TensorToDummyTensor", "[", 
   RowBox[{"TT_", "?", "xTensorQ"}], "]"}], ":=", 
  RowBox[{"TT", "\[Rule]", 
   RowBox[{"DummyTensor", "[", 
    RowBox[{
     RowBox[{"SlotsOfTensor", "[", "TT", "]"}], ",", 
     RowBox[{"SymmetryGroupOfTensor", "[", "TT", "]"}]}], "]"}]}]}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.672055645692404*^9, 3.672055767992575*^9}, {
  3.67205594989383*^9, 3.672056013263919*^9}, {3.6721086003743706`*^9, 
  3.6721086047543764`*^9}, {3.6733393040113735`*^9, 3.6733393063214197`*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"e6ee073d-b043-4dca-b9ad-1abb15be6dc3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{"DummyTensor", "[", 
    RowBox[{"vbs_", ",", "sym_"}], "]"}], "]"}], "^:=", 
  RowBox[{
   RowBox[{"DummyTensor", "[", 
    RowBox[{
     RowBox[{"Reverse", "[", 
      RowBox[{"Dagger", "/@", "vbs"}], "]"}], ",", 
     RowBox[{"xAct`SymManipulator`Private`CompatibleSym", "@", 
      RowBox[{"Reverse", "[", 
       RowBox[{"Dagger", "/@", "vbs"}], "]"}]}]}], "]"}], "/;", 
   RowBox[{"CompatibleSymQ", "[", 
    RowBox[{"vbs", ",", "sym"}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6830273815242124`*^9, 3.6830273889342127`*^9}, {
  3.683027426494212*^9, 3.6830274346442127`*^9}, {3.683027865543569*^9, 
  3.683027875882535*^9}, {3.6830279415059724`*^9, 3.6830279990037155`*^9}},
 CellLabel->
  "In[192]:=",ExpressionUUID->"05ec62d5-b588-449a-93f2-7ffb3e1210c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{
    RowBox[{"DummyTensor", "[", 
     RowBox[{"vbs_", ",", "sym_"}], "]"}], "[", "inds___", "]"}], "]"}], "^:=", 
  RowBox[{"PlaceIndicesInTensor", "[", 
   RowBox[{
    RowBox[{"Evaluate", "@", 
     RowBox[{"Dagger", "[", 
      RowBox[{"DummyTensor", "[", 
       RowBox[{"vbs", ",", "sym"}], "]"}], "]"}]}], ",", 
    RowBox[{"DaggerIndex", "/@", 
     RowBox[{"{", "inds", "}"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6831961999117355`*^9, 3.6831962385117893`*^9}, 
   3.6831963338419228`*^9, {3.68319648189213*^9, 3.683196484572134*^9}, {
   3.6831965369922075`*^9, 3.68319654628222*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"e6c26a40-109e-4b74-8bd4-c52d5728f7ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetLinearOperatorRules", "[", "op_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"LinearOperatorQ", "[", "op", "]"}], "^=", "True"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"op", "[", 
       RowBox[{"expr_TensorPlus", ",", "z___"}], "]"}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"op", "[", 
         RowBox[{"#", ",", "z"}], "]"}], "&"}], "/@", "expr"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"op", "[", 
       RowBox[{
        RowBox[{"ZeroTensor", "[", "vbs_", "]"}], ",", "z___"}], "]"}], ":=", 
      
      RowBox[{"ZeroTensorOfTensor", "@", 
       RowBox[{"op", "[", 
        RowBox[{
         RowBox[{"DummyTensor", "[", 
          RowBox[{"vbs", ",", 
           RowBox[{"CompatibleSymmetric", "[", "vbs", "]"}]}], "]"}], ",", 
         "z"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"op", "[", 
       RowBox[{
        RowBox[{"MultScal", "[", 
         RowBox[{
          RowBox[{"c_", "?", "ConstantQ"}], ",", 
          RowBox[{"TT_", "?", "xTensorQ"}]}], "]"}], ",", "z___"}], "]"}], ":=", 
      RowBox[{"MultScal", "[", 
       RowBox[{"c", ",", 
        RowBox[{"op", "[", 
         RowBox[{"TT", ",", "z"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"op", "[", 
       RowBox[{
        RowBox[{"MultScal", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c_", "?", "ConstantQ"}], ")"}], "*", "d_"}], ",", 
          RowBox[{"TT_", "?", "xTensorQ"}]}], "]"}], ",", "z___"}], "]"}], ":=", 
      RowBox[{"MultScal", "[", 
       RowBox[{"c", ",", 
        RowBox[{"op", "[", 
         RowBox[{
          RowBox[{"MultScal", "[", 
           RowBox[{"d", ",", "TT"}], "]"}], ",", "z"}], "]"}]}], "]"}]}], 
     ";"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6778515207290974`*^9, 3.677851549959138*^9}, {
   3.677851602609212*^9, 3.6778516834093246`*^9}, {3.6778517238093815`*^9, 
   3.677851791869477*^9}, {3.677851899739628*^9, 3.6778519181746626`*^9}, {
   3.6778521356781917`*^9, 3.67785220590829*^9}, 3.677990688894178*^9, {
   3.677990869934431*^9, 3.677990873814437*^9}, {3.839155426476682*^9, 
   3.839155430525384*^9}, {3.8913074129412546`*^9, 3.891307438045193*^9}},
 CellLabel->
  "In[194]:=",ExpressionUUID->"29be9550-9471-411f-8674-e4857a6cd6eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DaggerTensor", "[", "expr_", "]"}], ":=", 
  RowBox[{"Which", "[", 
   RowBox[{
    RowBox[{"HermitianQ", "[", "expr", "]"}], ",", "expr", ",", 
    RowBox[{"AntihermitianQ", "[", "expr", "]"}], ",", 
    RowBox[{"MultScal", "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "expr"}], "]"}], ",", "True", ",", 
    RowBox[{"Dagger", "[", "expr", "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[195]:=",ExpressionUUID->"1488afce-5966-4acb-9e85-a1af97b8068f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{"TensorPlus", "[", "arg___", "]"}], "]"}], "^:=", 
  RowBox[{"DaggerTensor", "/@", 
   RowBox[{"TensorPlus", "[", "arg", "]"}]}]}]], "Code",
 CellLabel->
  "In[196]:=",ExpressionUUID->"307566e8-9efd-4379-9357-4ce030e4d900"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToTensorPlusRules", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Plus", "[", 
       RowBox[{
        RowBox[{"T1_", "?", "TensorQ"}], ",", 
        RowBox[{"T2_", "?", "TensorQ"}]}], "]"}], "\[RuleDelayed]", 
      RowBox[{"TensorPlus", "[", 
       RowBox[{"T1", ",", "T2"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"c_", "?", "ConstantQ"}], "*", 
       RowBox[{"T_", "?", "TensorQ"}]}], "\[RuleDelayed]", 
      RowBox[{"MultScal", "[", 
       RowBox[{"c", ",", "T"}], "]"}]}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[197]:=",ExpressionUUID->"a9f55ee2-864f-44da-b172-2008d4d2b254"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlusSortFunc", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"TensorPlusSortFunc", "[", "b", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorPlusSortFunc", "[", "b_", "]"}], ":=", "b"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[198]:=",ExpressionUUID->"1529ec42-8a6f-45f5-a3e3-35aff183824f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SortTensorPlusRule", "=", 
   RowBox[{"expr_TensorPlus", "\[RuleDelayed]", 
    RowBox[{"SortBy", "[", 
     RowBox[{"expr", ",", "TensorPlusSortFunc"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[200]:=",ExpressionUUID->"af385adc-76d4-48ca-a9e1-2e1181f2eca3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetricDummySpinor", "[", 
   RowBox[{"k_", ",", "l_", ",", 
    RowBox[{"spin_", ":", "$DefaultSpinBundle"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"vbs", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"-", "spin"}], ",", "k"}], "]"}], ",", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Dagger", "[", "spin", "]"}]}], ",", "l"}], "]"}]}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"DummyTensor", "[", 
     RowBox[{"vbs", ",", 
      RowBox[{"xAct`SymManipulator`Private`CompatibleSym", "@", "vbs"}]}], 
     "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[201]:=",ExpressionUUID->"9ef1423f-11c0-45da-a66b-f00085213a01"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExprToIndexFreeTensor", "[", "0", "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExprToIndexFreeTensor", "[", "expr_Plus", "]"}], ":=", 
   RowBox[{"TensorPlus", "@@", 
    RowBox[{"(", 
     RowBox[{"ExprToIndexFreeTensor", "/@", "expr"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExprToIndexFreeTensor", "[", 
    RowBox[{
     RowBox[{"c_", "?", "ConstantQ"}], "*", "expr_"}], "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{"c", ",", 
     RowBox[{"ExprToIndexFreeTensor", "[", "expr", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExprToIndexFreeTensor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"TT_", "?", "xTensorQ"}], "[", "]"}], "*", "expr_"}], "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{
     RowBox[{"TT", "[", "]"}], ",", 
     RowBox[{"ExprToIndexFreeTensor", "[", "expr", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExprToIndexFreeTensor", "[", 
    RowBox[{
     RowBox[{"TT_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], ":=", 
   "TT"}], ";"}]}], "Code",
 CellChangeTimes->{{3.672056473734563*^9, 3.672056543354661*^9}, {
   3.672056674234844*^9, 3.6720566881748633`*^9}, {3.6720567746249847`*^9, 
   3.672056849185089*^9}, {3.672057479795972*^9, 3.6720575002260003`*^9}, {
   3.6733400310895257`*^9, 3.673340059428675*^9}, 3.673340311476843*^9, {
   3.6733403678668423`*^9, 3.6733404663677597`*^9}, {3.673340511288658*^9, 
   3.6733405117786674`*^9}, {3.6733405548095284`*^9, 
   3.6733405726098843`*^9}, {3.6733413843514147`*^9, 
   3.6733414124622583`*^9}, {3.673341551966443*^9, 3.6733415530864763`*^9}, {
   3.673341740295602*^9, 3.673341745994861*^9}, {3.673341912617614*^9, 
   3.6733419351069393`*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"9dd9d863-b24e-49d7-a70b-1316e242f378"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExprToIndexFreeTensor2", "[", 
   RowBox[{"lia_List", ",", "vbs_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"ExprToIndexFreeTensor", "[", 
     RowBox[{"#", ",", "vbs"}], "]"}], "&"}], "/@", "lia"}]}]], "Code",
 CellChangeTimes->{{3.6733409622987537`*^9, 3.673340975799158*^9}, {
  3.673341346300273*^9, 3.6733413805112996`*^9}},
 CellLabel->
  "In[207]:=",ExpressionUUID->"f405f76a-4799-4a4a-9519-5d0f8537b540"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IndexFreeEqToZeroLHS", "[", 
   RowBox[{"Equal", "[", 
    RowBox[{
     RowBox[{"lhs_", "?", "xTensorQ"}], ",", 
     RowBox[{"rhs_", "?", "xTensorQ"}]}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"ZeroTensorOfTensor", "[", "lhs", "]"}], "==", 
   RowBox[{"TensorMinus", "[", 
    RowBox[{"rhs", ",", "lhs"}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8620315302270823`*^9, 3.862031641985358*^9}},
 CellLabel->
  "In[208]:=",ExpressionUUID->"c285175e-e855-4c4b-9412-2d7560318e74"]
}, Closed]],

Cell[CellGroupData[{

Cell["Fundamental spinor operators", "Subsubsection",
 CellChangeTimes->{{3.838821652935227*^9, 
  3.838821661620779*^9}},ExpressionUUID->"3fee42f7-364e-4c00-86c6-\
4b9e1bd97f95"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xTension", "[", 
    RowBox[{
    "\"\<SymSpin`\>\"", ",", "DefFundSpinOperators", ",", "\"\<End\>\""}], 
    "]"}], "=", "ExtraDefFundSpinOpFunction"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[209]:=",ExpressionUUID->"2d475a87-baeb-46e4-816d-6bc2ab396c45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtraDefFundSpinOpFunction", "[", 
   RowBox[{"covd_", ",", "options___"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"divcd", "=", 
       RowBox[{"xAct`SymManipulator`Private`DivName", "@", "covd"}]}], ",", 
      " ", 
      RowBox[{"curlcd", "=", 
       RowBox[{"xAct`SymManipulator`Private`CurlName", "@", "covd"}]}], ",", 
      " ", 
      RowBox[{"curldgcd", "=", 
       RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", "covd"}]}], ",",
       " ", 
      RowBox[{"twistcd", "=", 
       RowBox[{"xAct`SymManipulator`Private`TwistName", "@", "covd"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"spin", "=", 
       RowBox[{"VBundleOfSolderingForm", "[", 
        RowBox[{"SolderingFormOfSpinCovD", "[", "covd", "]"}], "]"}]}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetLinearOperatorRules", "@", "divcd"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SetLinearOperatorRules", "@", "curlcd"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SetLinearOperatorRules", "@", "curldgcd"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SetLinearOperatorRules", "@", "twistcd"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"FundSpinOpBianchiRules", "[", "covd", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"divcd", "[", 
          RowBox[{"Phi", "[", "covd", "]"}], "]"}], "->", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"twistcd", "[", 
            RowBox[{"Lambda", "[", "covd", "]"}], "]"}]}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"curldgcd", "[", 
          RowBox[{"Psi", "[", "covd", "]"}], "]"}], "->", 
         RowBox[{"curlcd", "[", 
          RowBox[{"Phi", "[", "covd", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"curlcd", "[", 
          RowBox[{"Dagger", "[", 
           RowBox[{"Psi", "[", "covd", "]"}], "]"}], "]"}], "->", 
         RowBox[{"curldgcd", "[", 
          RowBox[{"Phi", "[", "covd", "]"}], "]"}]}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"divcd", ",", "curlcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"divcd", "[", 
        RowBox[{"curlcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"k", "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}], ",", 
              RowBox[{"curlcd", "[", 
               RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"l", "-", "2"}], ")"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "3", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{"k", ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "2", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "0", ",", "2", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"curlcd", ",", "divcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"curlcd", "[", 
        RowBox[{"divcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}], "/", "k"}], ",", 
              RowBox[{"divcd", "[", 
               RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"l", "-", "2"}], ")"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "k"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "3", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "2", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "1", ",", "2", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"divcd", ",", "curldgcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"divcd", "[", 
        RowBox[{"curldgcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"l", "/", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}], ",", 
              RowBox[{"curldgcd", "[", 
               RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "-", "2"}], ")"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "3", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{"l", ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "2", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "2", ",", "0", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"curldgcd", ",", "divcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"curldgcd", "[", 
        RowBox[{"divcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}], "/", "l"}], ",", 
              RowBox[{"divcd", "[", 
               RowBox[{"curldgcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"k", "-", "2"}], ")"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}], "/", "l"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "3", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "2", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "2", ",", "1", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"curlcd", ",", "twistcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"curlcd", "[", 
        RowBox[{"twistcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"l", "/", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}], ",", 
              RowBox[{"twistcd", "[", 
               RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{"k", ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "1", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{"l", ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "0", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "0", ",", "0", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"twistcd", ",", "curlcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"twistcd", "[", 
        RowBox[{"curlcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}], "/", "l"}], ",", 
              RowBox[{"curlcd", "[", 
               RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "k"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}], "/", "l"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "1", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "0", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "0", ",", "1", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"curldgcd", ",", "twistcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"curldgcd", "[", 
        RowBox[{"twistcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"k", "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}], ",", 
              RowBox[{"twistcd", "[", 
               RowBox[{"curldgcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{"l", ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "1", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{"k", ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "0", ",", "0", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"twistcd", ",", "curldgcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"twistcd", "[", 
        RowBox[{"curldgcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}], "/", "k"}], ",", 
              RowBox[{"curldgcd", "[", 
               RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "l"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "k"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "1", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"divcd", ",", "twistcd", ",", "curlcd", ",", "curldgcd"}], 
       "]"}], "^=", 
      RowBox[{
       RowBox[{"divcd", "[", 
        RowBox[{"twistcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "/", 
                  RowBox[{"(", 
                   RowBox[{"k", "+", "1"}], ")"}]}], "+", 
                 RowBox[{"1", "/", 
                  RowBox[{"(", 
                   RowBox[{"l", "+", "1"}], ")"}]}]}], ")"}]}], ",", 
              RowBox[{"curlcd", "[", 
               RowBox[{"curldgcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"l", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "+", "2"}], ")"}], "/", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"l", "+", "1"}], ")"}], "^", "2"}]}]}], ",", 
              RowBox[{"twistcd", "[", 
               RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "+", "2"}], ")"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "2", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "+", "2"}], ")"}], 
               RowBox[{"l", "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "2"}], ")"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "2"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", " ", 
             RowBox[{
              RowBox[{"l", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "-", "1"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "2", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", " ", 
             RowBox[{
              RowBox[{"l", " ", 
               RowBox[{"k", "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", " ", "l"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "+", "2"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"twistcd", ",", "divcd", ",", "curlcd", ",", "curldgcd"}], 
       "]"}], "^=", 
      RowBox[{
       RowBox[{"twistcd", "[", 
        RowBox[{"divcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "l"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k"}], ")"}], "*", "l", "*", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{"curlcd", "[", 
               RowBox[{"curldgcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}], "^", "2"}], "/", 
               RowBox[{"(", 
                RowBox[{"l", "*", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{"divcd", "[", 
               RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}]}], " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}], "/", "l"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "2", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "l"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}], "/", "l"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "2"}], ")"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}], "/", "l"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "l"}], 
               RowBox[{"(", 
                RowBox[{"l", "-", "1"}], ")"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "*", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", "l"}], ")"}]}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "2", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "k"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "l"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"l", "+", "1"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"divcd", ",", "twistcd", ",", "curldgcd", ",", "curlcd"}], 
       "]"}], "^=", 
      RowBox[{
       RowBox[{"divcd", "[", 
        RowBox[{"twistcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "/", 
                  RowBox[{"(", 
                   RowBox[{"k", "+", "1"}], ")"}]}], "+", 
                 RowBox[{"1", "/", 
                  RowBox[{"(", 
                   RowBox[{"l", "+", "1"}], ")"}]}]}], ")"}]}], ",", 
              RowBox[{"curldgcd", "[", 
               RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"k", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "2"}], ")"}], "/", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}], "^", "2"}]}]}], ",", 
              RowBox[{"twistcd", "[", 
               RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "2"}], ")"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "-", "1"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "2", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "2"}], ")"}], 
               RowBox[{"k", "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "2"}], ")"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "+", "2"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"k", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "2", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"l", " ", 
               RowBox[{"k", "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "k"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "2"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "0", ",", "1", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"twistcd", ",", "divcd", ",", "curldgcd", ",", "curlcd"}], 
       "]"}], "^=", 
      RowBox[{
       RowBox[{"twistcd", "[", 
        RowBox[{"divcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "l"}], ")"}], "*", "k", "*", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], ",", 
              RowBox[{"curldgcd", "[", 
               RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}], "^", "2"}], "/", 
               RowBox[{"(", 
                RowBox[{"k", "*", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], ",", 
              RowBox[{"divcd", "[", 
               RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"l", "-", "1"}], ")"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}], "/", "k"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "2", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"1", "+", "k"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "+", "2"}], ")"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}], "/", "k"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "k"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "2", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "l"}], " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "k"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "k"}], ")"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"curlcd", ",", "curldgcd", ",", "curldgcd", ",", "curlcd"}], 
       "]"}], "^=", 
      RowBox[{
       RowBox[{"curlcd", "[", 
        RowBox[{"curldgcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"curldgcd", "[", 
             RowBox[{"curlcd", "[", "TT", "]"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}]}], "-", 
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"l", "+", "1"}], ")"}]}]}], ")"}], ",", 
              RowBox[{"twistcd", "[", 
               RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "-", "1"}], ")"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "2", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{"l", ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"k", "+", "2"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"l", "-", "1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "2", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", " ", 
             RowBox[{
              RowBox[{"-", "k"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"l", "+", "2"}], ")"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"curldgcd", ",", "curlcd", ",", "curlcd", ",", "curldgcd"}], 
       "]"}], "^=", 
      RowBox[{
       RowBox[{"curldgcd", "[", 
        RowBox[{"curlcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"curlcd", "[", 
             RowBox[{"curldgcd", "[", "TT", "]"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"l", "+", "1"}], ")"}]}], "-", 
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}]}]}], ")"}], ",", 
              RowBox[{"twistcd", "[", 
               RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"k", "-", "1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "2", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", "l"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "+", "2"}], ")"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"l", "-", "1"}], ")"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "2", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{"k", ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"l", "+", "2"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"curldgcd", ",", "curlcd", ",", "divcd", ",", "twistcd"}], 
       "]"}], "^=", 
      RowBox[{
       RowBox[{"curldgcd", "[", 
        RowBox[{"curlcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{"divcd", "[", 
               RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{"twistcd", "[", 
               RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "l"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "2", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", "k", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "2", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", " ", "l", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "0", ",", "1", ",", "spin"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"curlcd", ",", "curldgcd", ",", "divcd", ",", "twistcd"}], 
       "]"}], "^=", 
      RowBox[{
       RowBox[{"curlcd", "[", 
        RowBox[{"curldgcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
             ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{"divcd", "[", 
               RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k"}], ")"}], " ", "l", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "l"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{"twistcd", "[", 
               RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Psi", "[", "covd", "]"}], ",", "2", ",", "0", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k"}], ")"}], " ", "l", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "l"}], ")"}], " ", "l"}], ")"}], 
               "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", 
                 "2", ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k"}], ")"}], " ", "l"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Phi", "[", "covd", "]"}], ",", "1", ",", "1", ",", 
                 "spin"}], "]"}], "[", "TT", "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], " ", "l", " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", 
                 ",", "spin"}], "]"}], "[", "TT", "]"}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
        RowBox[{"EnoughIndsQSpin", "[", 
         RowBox[{"TT", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}]}], 
     ";"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8388217410252347`*^9, 3.8388218140436096`*^9}, {
  3.8388221232733316`*^9, 3.8388222042332025`*^9}, {3.8388833197942266`*^9, 
  3.838883358867157*^9}, {3.838883547726077*^9, 3.838883548781836*^9}, {
  3.838883711781405*^9, 3.83888387870187*^9}, {3.838883915415186*^9, 
  3.83888406730301*^9}, {3.838884109328293*^9, 3.838884119912203*^9}, {
  3.8388841548773413`*^9, 3.838884235668643*^9}, {3.838884278402313*^9, 
  3.838884604204064*^9}, {3.8389636959950953`*^9, 3.838963752109982*^9}, {
  3.83896447935846*^9, 3.838964482089658*^9}, {3.9555121575881557`*^9, 
  3.9555123202203503`*^9}},
 CellLabel->
  "In[210]:=",ExpressionUUID->"39e3779e-28ae-441d-989f-36ea89cf2533"]
}, Closed]],

Cell[CellGroupData[{

Cell["Indexed to index free expressions", "Subsubsection",
 CellChangeTimes->{{3.8378514348854237`*^9, 3.837851449239895*^9}, {
  3.8378515226520863`*^9, 3.837851523190097*^9}, {3.8378515936787863`*^9, 
  3.837851597139782*^9}, {3.838964623492907*^9, 3.838964624411483*^9}, {
  3.8400270439608693`*^9, 
  3.8400270666486173`*^9}},ExpressionUUID->"b1a19ce2-a611-4efa-b2e5-\
aa27e1415649"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TermToIndexFree", "[", 
    RowBox[{
     RowBox[{"TT_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
      "SymmetricSpinorOfArbitraryValenceQ", "[", "$DefaultSpinBundle", "]"}], 
      "@", "TT"}], ",", "TT", ",", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"TermToIndexFree", "::", "error"}], ",", 
        RowBox[{"\"\<The tensor \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TT", ",", "InputForm"}], "]"}], "<>", 
         "\"\< is not symmetric.\>\""}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TermToIndexFree", "[", 
    RowBox[{
     RowBox[{"c_", "?", "ConstantQ"}], "*", "z_"}], "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{"c", ",", 
     RowBox[{"TermToIndexFree", "[", "z", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TermToIndexFree", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c_", "?", "xTensorQ"}], "[", "]"}], "*", "z_"}], "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{
     RowBox[{"c", "[", "]"}], ",", 
     RowBox[{"TermToIndexFree", "[", "z", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TermToIndexFree", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_", "?", "xTensorQ"}], "[", "]"}], ")"}], "^", 
     RowBox[{"(", "i_", ")"}]}], "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "[", "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"i", "-", "1"}], ")"}]}], ",", "c"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TermToIndexFree", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c_", "?", "xTensorQ"}], "[", "]"}], ")"}], "^", 
      RowBox[{"(", "i_", ")"}]}], "*", "z_"}], "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "[", "]"}], "^", "i"}], ",", 
     RowBox[{"TermToIndexFree", "[", "z", "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8400306447643795`*^9, 3.8400306470542583`*^9}, {
  3.8400307129320726`*^9, 3.8400307247235518`*^9}, {3.8400307845368133`*^9, 
  3.8400308684457417`*^9}, {3.8400310879402957`*^9, 3.8400311007500877`*^9}, {
  3.840031184372533*^9, 3.84003119137986*^9}},
 CellLabel->
  "In[211]:=",ExpressionUUID->"0e1d9e8b-2714-42ea-8b64-307ac50d319c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TermToIndexFree", "[", "expr_", "]"}], ":=", 
  RowBox[{"Throw", "@", 
   RowBox[{"Message", "[", 
    RowBox[{
     RowBox[{"TermToIndexFree", "::", "error"}], ",", 
     RowBox[{"\"\<Can not turn \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"expr", ",", "InputForm"}], "]"}], "<>", 
      "\"\< into an unindexed form\>\""}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.8400290226447167`*^9},
 CellLabel->
  "In[216]:=",ExpressionUUID->"2a2ed514-4a9a-4704-8fbf-dcd897f79059"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ToIndexFree", "[", "l_List", "]"}], ":=", 
   RowBox[{"ToIndexFree", "/@", "l"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToIndexFree", "[", 
    RowBox[{"lhs_", "\[Equal]", "0"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"indexfreelhs", "=", 
       RowBox[{"ToIndexFree", "[", "lhs", "]"}]}], "}"}], ",", 
     RowBox[{"indexfreelhs", "==", 
      RowBox[{"ZeroTensorOfTensor", "@", "indexfreelhs"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToIndexFree", "[", 
    RowBox[{"0", "==", "rhs_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"indexfreerhs", "=", 
       RowBox[{"ToIndexFree", "[", "rhs", "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"ZeroTensorOfTensor", "@", "indexfreerhs"}], "==", 
      "indexfreerhs"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToIndexFree", "[", "eq_Equal", "]"}], ":=", 
   RowBox[{"ToIndexFree", "/@", "eq"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToIndexFree", "[", "expr_", "]"}], ":=", 
   RowBox[{"TensorPlus", "@@", 
    RowBox[{"(", 
     RowBox[{"TermToIndexFree", "/@", 
      RowBox[{"xAct`xTensor`Private`ListOfTerms", "[", "expr", "]"}]}], 
     ")"}]}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8400312098754196`*^9, 3.8400312263854475`*^9}},
 CellLabel->
  "In[217]:=",ExpressionUUID->"2594f83c-ad31-4b94-9f3b-ab87ca712557"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ToIndexed", "[", "eq_Equal", "]"}], ":=", 
   RowBox[{"ToIndexed", "/@", "eq"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToIndexed", "[", 
   RowBox[{"TT_", "?", "xTensorQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"GiveIndicesToTensor", "[", "TT", "]"}], "//.", 
   "SymMultRule"}]}]}], "Code",
 CellChangeTimes->{{3.840626625931847*^9, 3.8406267187297134`*^9}, {
  3.8406271932895265`*^9, 3.8406271977446175`*^9}},
 CellLabel->
  "In[222]:=",ExpressionUUID->"981fdfe6-b197-4fd2-8afe-2d7446fcfc37"],

Cell["Older deactivated code", "Text",
 CellChangeTimes->{{3.840027559610444*^9, 
  3.840027565650365*^9}},ExpressionUUID->"16d5e040-3480-43bf-9fc7-\
fcc74b1f12c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"OpToPatternOp", "[", 
   RowBox[{"op_", "[", 
    RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"op", "[", "TT", "]"}], "/.", 
    RowBox[{"TT", "\[Rule]", 
     RowBox[{"xAct`xTensor`Private`pattern", "[", 
      RowBox[{"TT", ",", "_"}], "]"}]}]}], "/.", 
   RowBox[{
   "xAct`xTensor`Private`pattern", "\[Rule]", "Pattern"}]}]}]], "Input",
 CellLabel->
  "In[224]:=",ExpressionUUID->"6c23bbc9-c0ec-4b99-a84f-6536b59908a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EqToOpRule", "[", 
   RowBox[{"lhs_", "\[Equal]", "rhs_"}], "]"}], ":=", 
  RowBox[{"RuleDelayed", "[", 
   RowBox[{
    RowBox[{"OpToPatternOp", "@", 
     RowBox[{"TermToOp", "@", "lhs"}]}], ",", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"TensorPlus", "@@", 
      RowBox[{"(", 
       RowBox[{"TermToOp", "/@", 
        RowBox[{"xAct`xTensor`Private`ListOfTerms", "[", "rhs", "]"}]}], 
       ")"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[225]:=",ExpressionUUID->"4facbb3a-353b-4c5b-8e22-3990a58e1234"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EqToTensorOpRule", "[", 
    RowBox[{"lhs_", "\[Equal]", "0"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"TermToOp", "[", "lhs", "]"}], "\[Rule]", 
    RowBox[{"ZeroTensorOfTensor", "@", 
     RowBox[{"TermToOp", "[", "lhs", "]"}]}]}]}], ";", 
  RowBox[{
   RowBox[{"EqToTensorOpRule", "[", 
    RowBox[{"lhs_", "\[Equal]", "rhs_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"TermToOp", "[", "lhs", "]"}], "\[RuleDelayed]", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"TensorPlus", "@@", 
      RowBox[{"TermToOp", "/@", 
       RowBox[{"xAct`xTensor`Private`ListOfTerms", "[", "rhs", "]"}]}]}], 
     "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.837851351182723*^9, {3.8391554467965355`*^9, 3.839155450466726*^9}},
 CellLabel->
  "In[226]:=",ExpressionUUID->"fd2d6765-0b64-4c23-accf-a21c70840213"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SymMult", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.683259950582352*^9, 3.6832599568089795`*^9}, {
  3.7007432119192495`*^9, 3.700743213500252*^9}, {3.7008821239837265`*^9, 
  3.700882125929838*^9}, {3.837837775707291*^9, 3.8378378421306777`*^9}, {
  3.837849564691972*^9, 
  3.8378495658734217`*^9}},ExpressionUUID->"a31e7942-4b03-45c0-a46d-\
107de1aa0d96"],

Cell[CellGroupData[{

Cell["SymMult definitions", "Subsubsection",
 CellChangeTimes->{{3.838698715540696*^9, 3.8386987289005203`*^9}, {
  3.955674805654951*^9, 
  3.9556748073093853`*^9}},ExpressionUUID->"95064bca-7106-4024-b5bc-\
7410b24d3e99"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymMult", "[", 
   RowBox[{
    RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_"}], "]"}], ":=", 
  RowBox[{"SymMult", "[", 
   RowBox[{"AA", ",", "unprim", ",", "prim", ",", "$DefaultSpinBundle"}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[227]:=",ExpressionUUID->"129a616e-035c-4908-889d-017686535231"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
       "vb_"}], "]"}], "[", 
     RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "]"}], "^=", "True"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[228]:=",ExpressionUUID->"0dfc518a-f3d9-44d1-af8a-ce3eeaa19002"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
       "spin_"}], "]"}], "[", 
     RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "AA", "]"}], 
         "+", 
         RowBox[{
          RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "BB", "]"}], 
         "-", 
         RowBox[{"2", "unprim"}]}]}], ",", 
       RowBox[{"l", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "AA", "]"}], 
         "+", 
         RowBox[{
          RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "BB", "]"}], 
         "-", 
         RowBox[{"2", "prim"}]}]}]}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"And", "[", 
        RowBox[{"xAct`SymManipulator`Private`$SlotsOfTensorWarning", ",", 
         RowBox[{"Or", "[", 
          RowBox[{
           RowBox[{"k", "<", "0"}], ",", 
           RowBox[{"l", "<", "0"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"SymMult", "::", "error"}], ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Not enough indices:\>\"", ",", 
            RowBox[{"ToString", "@", 
             RowBox[{"InputForm", "@", 
              RowBox[{
               RowBox[{"SymMult", "[", " ", 
                RowBox[{"AA", ",", "unprim", ",", "prim", ",", "spin"}], 
                "]"}], "[", "BB", "]"}]}]}]}], "]"}]}], "]"}]}], ",", 
       RowBox[{"SymmetricOfValence", "[", 
        RowBox[{"k", ",", "l", ",", "spin", ",", 
         RowBox[{"{", "}"}]}], "]"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.839154258466118*^9, 3.8391543346162424`*^9}, {
   3.8391543805395727`*^9, 3.8391545626576347`*^9}, {3.839154600835821*^9, 
   3.8391547012729063`*^9}, 3.839156027694691*^9},
 CellLabel->
  "In[229]:=",ExpressionUUID->"b29c1e8e-d94f-4bb6-9755-c34de81e5207"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
       "vb_"}], "]"}], "[", 
     RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"xAct`SymManipulator`Private`CompatibleSym", "@", 
    RowBox[{"SlotsOfTensor", "[", 
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{"AA", ",", "unprim", ",", "prim", ",", "vb"}], "]"}], "[", 
      "BB", "]"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[230]:=",ExpressionUUID->"11f77082-1e45-477a-b27d-65fa173bc4d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin_", "]"}], "[", 
    RowBox[{"SymMult", "[", 
     RowBox[{
      RowBox[{"AA_", "?", "xTensorQ"}], ",", " ", "unprim_", ",", " ", 
      "prim_", ",", " ", "spin_"}], "]"}], "]"}], " ", "^=", " ", "True"}], 
  ";"}]], "Code",
 CellChangeTimes->{{3.9556746313802376`*^9, 3.9556746318476143`*^9}},
 CellLabel->
  "In[231]:=",ExpressionUUID->"76da42cf-0f8f-9748-a1be-982af92f040d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymMultRule", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{
        RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
        "spin_"}], "]"}], "[", 
      RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "[", "inds___", "]"}], 
    "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"unprimdummies", "=", 
         RowBox[{"DummyIn", "/@", 
          RowBox[{"Table", "[", 
           RowBox[{"spin", ",", "unprim"}], "]"}]}]}], ",", 
        RowBox[{"primdummies", "=", 
         RowBox[{"DummyIn", "/@", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Dagger", "@", "spin"}], ",", "prim"}], "]"}]}]}], ",", 
        RowBox[{"unprimedinds", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"{", "inds", "}"}], ",", 
           RowBox[{"SymbolJoin", "[", 
            RowBox[{"spin", ",", "\"\<`pmQ\>\""}], "]"}]}], "]"}]}], ",", 
        RowBox[{"primedinds", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"{", "inds", "}"}], ",", 
           RowBox[{"SymbolJoin", "[", 
            RowBox[{
             RowBox[{"Dagger", "@", "spin"}], ",", "\"\<`pmQ\>\""}], "]"}]}], 
          "]"}]}], ",", 
        RowBox[{"numunprimA", "=", 
         RowBox[{
          RowBox[{"NumOfUnprimedVBundles", "[", "spin", "]"}], "[", 
          RowBox[{"SlotsOfTensor", "[", "AA", "]"}], "]"}]}], ",", 
        RowBox[{"numprimA", "=", 
         RowBox[{
          RowBox[{"NumOfPrimedVBundles", "[", "spin", "]"}], "[", 
          RowBox[{"SlotsOfTensor", "[", "AA", "]"}], "]"}]}], ",", 
        RowBox[{"numunprimB", "=", 
         RowBox[{
          RowBox[{"NumOfUnprimedVBundles", "[", "spin", "]"}], "[", 
          RowBox[{"SlotsOfTensor", "[", "BB", "]"}], "]"}]}], ",", 
        RowBox[{"numprimB", "=", 
         RowBox[{
          RowBox[{"NumOfPrimedVBundles", "[", "spin", "]"}], "[", 
          RowBox[{"SlotsOfTensor", "[", "BB", "]"}], "]"}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ImposeSym", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"xAct`SymManipulator`Private`PlaceIndicesInSpinor", "[", 
          RowBox[{"AA", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Sequence", "@@", "unprimdummies"}], ",", 
             RowBox[{"Sequence", "@@", 
              RowBox[{"(", 
               RowBox[{"Take", "[", 
                RowBox[{"unprimedinds", ",", 
                 RowBox[{"numunprimA", "-", "unprim"}]}], "]"}], ")"}]}], ",", 
             RowBox[{"Sequence", "@@", "primdummies"}], ",", 
             RowBox[{"Sequence", "@@", 
              RowBox[{"(", 
               RowBox[{"Take", "[", 
                RowBox[{"primedinds", ",", 
                 RowBox[{"numprimA", "-", "prim"}]}], "]"}], ")"}]}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{"spin", ",", 
             RowBox[{"Dagger", "@", "spin"}]}], "}"}]}], "]"}], 
         RowBox[{"xAct`SymManipulator`Private`PlaceIndicesInSpinor", "[", 
          RowBox[{"BB", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Sequence", "@@", 
              RowBox[{"(", 
               RowBox[{"ChangeIndex", "/@", "unprimdummies"}], ")"}]}], ",", 
             RowBox[{"Sequence", "@@", 
              RowBox[{"(", 
               RowBox[{"Take", "[", 
                RowBox[{"unprimedinds", ",", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"numunprimB", "-", "unprim"}], ")"}]}]}], "]"}], 
               ")"}]}], ",", 
             RowBox[{"Sequence", "@@", 
              RowBox[{"(", 
               RowBox[{"ChangeIndex", "/@", "primdummies"}], ")"}]}], ",", 
             RowBox[{"Sequence", "@@", 
              RowBox[{"(", 
               RowBox[{"Take", "[", 
                RowBox[{"primedinds", ",", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"numprimB", "-", "prim"}], ")"}]}]}], "]"}], 
               ")"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"spin", ",", 
             RowBox[{"Dagger", "@", "spin"}]}], "}"}]}], "]"}]}], ",", 
        RowBox[{"IndexList", "[", "inds", "]"}]}], "]"}]}], "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[232]:=",ExpressionUUID->"cdfd35b0-f73c-46dd-b0e5-aa06d768c5fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
       "spin_"}], "]"}], "[", 
     RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"AtomQ", "[", "AA", "]"}]}], ",", "\"\<(\>\"", ",", 
        "\"\<\>\""}], "]"}], ",", 
      RowBox[{"PrintAs", "[", "AA", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"AtomQ", "[", "AA", "]"}]}], ",", "\"\<)\>\"", ",", 
        "\"\<\>\""}], "]"}], ",", 
      RowBox[{"UnderoverscriptBox", "[", 
       RowBox[{"\"\<\[CircleDot]\>\"", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"OptionValue", "[", 
           RowBox[{"DefFundSpinOperators", ",", "ShowValenceInfo"}], "]"}], 
          ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"DisplayForm", "@", 
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                "BB"}]}], ",", "StandardForm"}], "]"}], ",", "\"\<,\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"DisplayForm", "@", 
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "BB"}]}],
               ",", "StandardForm"}], "]"}]}], "]"}], ",", "\"\<\>\""}], 
         "]"}], ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"DisplayForm", "@", "unprim"}], ",", "StandardForm"}], 
           "]"}], ",", "\"\<,\>\"", ",", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"DisplayForm", "@", "prim"}], ",", "StandardForm"}], 
           "]"}]}], "]"}]}], "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"AtomQ", "[", "BB", "]"}]}], ",", "\"\<(\>\"", ",", 
        "\"\<\>\""}], "]"}], ",", 
      RowBox[{"PrintAs", "[", "BB", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"AtomQ", "[", "BB", "]"}]}], ",", "\"\<)\>\"", ",", 
        "\"\<\>\""}], "]"}]}], "}"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.840700729234791*^9, {3.8407007681786423`*^9, 3.8407007822111177`*^9}},
 CellLabel->
  "In[233]:=",ExpressionUUID->"d83fe5de-3b65-4f7d-9f74-7f9ae75a8a8f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
       "spin_"}], "]"}], "[", 
     RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"AtomQ", "[", "AA", "]"}]}], ",", "\"\<(\>\"", ",", 
        "\"\<\>\""}], "]"}], ",", 
      RowBox[{"PrintAs", "[", "AA", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"AtomQ", "[", "AA", "]"}]}], ",", "\"\<)\>\"", ",", 
        "\"\<\>\""}], "]"}], ",", 
      RowBox[{"UnderoverscriptBox", "[", 
       RowBox[{"\"\<\[CircleDot]\>\"", ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"DisplayForm", "@", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "BB"}]}],
             ",", "StandardForm"}], "]"}], ",", "\"\<,\>\"", ",", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"DisplayForm", "@", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "BB"}]}], 
            ",", "StandardForm"}], "]"}]}], "]"}], ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"DisplayForm", "@", "unprim"}], ",", "StandardForm"}], 
           "]"}], ",", "\"\<,\>\"", ",", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"DisplayForm", "@", "prim"}], ",", "StandardForm"}], 
           "]"}]}], "]"}]}], "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"AtomQ", "[", "BB", "]"}]}], ",", "\"\<(\>\"", ",", 
        "\"\<\>\""}], "]"}], ",", 
      RowBox[{"PrintAs", "[", "BB", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"AtomQ", "[", "BB", "]"}]}], ",", "\"\<)\>\"", ",", 
        "\"\<\>\""}], "]"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8390419758068123`*^9, 3.8390419758084927`*^9}},
 CellLabel->
  "In[234]:=",ExpressionUUID->"cd8f99c4-7112-4e5d-9bec-223685fce152"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfUnprimedSlots", "[", "spin_", "]"}], "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
       "spin_"}], "]"}], "[", 
     RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{
    RowBox[{
     RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "AA", "]"}], "+", 
    
    RowBox[{
     RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "BB", "]"}], "-", 
    
    RowBox[{"2", "unprim"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfPrimedSlots", "[", "spin_", "]"}], "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
       "spin_"}], "]"}], "[", 
     RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{
    RowBox[{
     RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "AA", "]"}], "+", 
    RowBox[{
     RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "BB", "]"}], "-", 
    RowBox[{"2", "prim"}]}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[235]:=",ExpressionUUID->"6a12aa5b-287a-4d07-a345-d99423192a0f"],

Cell["\<\
Some of these needs to be updated so they will work with arbitrary valence.\
\>", "Text",
 CellChangeTimes->{{3.8391503110509377`*^9, 
  3.8391503393614073`*^9}},ExpressionUUID->"d3cc56a9-e7b6-4c84-927b-\
0ff6ba219d0c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{"expr_TensorPlus", ",", "unprim_", ",", "prim_", ",", "spin_"}], 
     "]"}], "[", "BB_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"#1", ",", "unprim", ",", "prim", ",", "spin"}], "]"}], "[", 
       "BB", "]"}], "&"}], ")"}], "/@", "expr"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{"AA_", ",", "unprim_", ",", "prim_", ",", "spin_"}], "]"}], "[", 
    "expr_TensorPlus", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "unprim", ",", "prim", ",", "spin"}], "]"}], "[", 
       "#1", "]"}], "&"}], ")"}], "/@", "expr"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{
      RowBox[{"ZeroTensor", "[", "vbs_", "]"}], ",", "unprim_", ",", "prim_", 
      ",", "spin_"}], "]"}], "[", "BB_", "]"}], ":=", 
   RowBox[{"ZeroTensorOfTensor", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"DummyTensor", "[", 
        RowBox[{"vbs", ",", 
         RowBox[{"CompatibleSymmetric", "[", "vbs", "]"}]}], "]"}], ",", 
       "unprim", ",", "prim", ",", "spin"}], "]"}], "[", "BB", "]"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{"AA_", ",", "unprim_", ",", "prim_", ",", "spin_"}], "]"}], "[", 
    
    RowBox[{"ZeroTensor", "[", "vbs_", "]"}], "]"}], ":=", 
   RowBox[{"ZeroTensorOfTensor", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA", ",", "unprim", ",", "prim", ",", "spin"}], "]"}], "@", 
     RowBox[{"DummyTensor", "[", 
      RowBox[{"vbs", ",", 
       RowBox[{"CompatibleSymmetric", "[", "vbs", "]"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{"c_", "?", "ConstantQ"}], ",", 
        RowBox[{"AA_", "?", "xTensorQ"}]}], "]"}], ",", "unprim_", ",", 
      "prim_", ",", "spin_"}], "]"}], "[", "BB_", "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{"c", ",", 
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{"AA", ",", "unprim", ",", "prim", ",", "spin"}], "]"}], "[", 
      "BB", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{"AA_", ",", "unprim_", ",", "prim_", ",", "spin_"}], "]"}], "[", 
    
    RowBox[{"MultScal", "[", 
     RowBox[{
      RowBox[{"c_", "?", "ConstantQ"}], ",", 
      RowBox[{"BB_", "?", "xTensorQ"}]}], "]"}], "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{"c", ",", 
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{"AA", ",", "unprim", ",", "prim", ",", "spin"}], "]"}], "[", 
      "BB", "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8391554901094847`*^9, 3.8391555196932244`*^9}},
 CellLabel->
  "In[237]:=",ExpressionUUID->"d9f85a39-3770-4935-a58b-e2071dd847af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{
      RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
      "spin_"}], "]"}], "[", 
    RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
  RowBox[{
   RowBox[{"SymMult", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"HermitianQ", "[", "AA", "]"}], ",", "AA", ",", 
       RowBox[{"Dagger", "[", "AA", "]"}]}], "]"}], ",", "prim", ",", 
     "unprim", ",", "spin"}], "]"}], "[", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"HermitianQ", "[", "BB", "]"}], ",", "BB", ",", 
     RowBox[{"Dagger", "[", "BB", "]"}]}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[243]:=",ExpressionUUID->"a74746a4-4467-47a8-89fa-0e4fc032b474"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
       "spin_"}], "]"}], "[", 
     RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "[", "inds__", "]"}], "]"}], "^:=", 
  RowBox[{"xAct`SymManipulator`Private`PlaceIndicesInSpinor", "[", 
   RowBox[{
    RowBox[{"Dagger", "[", 
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{"AA", ",", "unprim", ",", "prim", ",", "spin"}], "]"}], "[", 
      "BB", "]"}], "]"}], ",", 
    RowBox[{"DaggerIndex", "/@", 
     RowBox[{"{", "inds", "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"spin", ",", 
      RowBox[{"Dagger", "@", "spin"}]}], "}"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8393031549356413`*^9, 3.839303162938786*^9}},
 CellLabel->
  "In[244]:=",ExpressionUUID->"1d07cc2c-ec7d-4e45-8b46-05fdbb47845c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"x", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{
         RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
         "spin_"}], "]"}], "[", 
       RowBox[{"BB_", "?", "xTensorQ"}], "]"}], ")"}]}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"xAct`TexAct`Private`TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
     RowBox[{"xAct`SymManipulator`Private`TexFundOp", "@", "x"}], ",", 
     RowBox[{"xAct`TexAct`Private`TexClose", "[", "\"\<)\>\"", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[245]:=",ExpressionUUID->"ea271608-b3b2-4d80-9d59-e5658fe2734f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"AA_", "?", "xTensorQ"}], ",", "unprim_", ",", "prim_", ",", 
       "spin_"}], "]"}], "[", 
     RowBox[{"BB_", "?", "xTensorQ"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"xAct`TexAct`Private`TexFactor", "[", "AA", "]"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"OptionValue", "[", 
        RowBox[{"DefFundSpinOperators", ",", "ShowValenceInfo"}], "]"}], ",", 
       
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\\\underset{\>\"", ",", 
         RowBox[{"Tex", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "BB", 
            "]"}], "/.", "ToOrderedPlus"}], "]"}], ",", "\"\<,\>\"", ",", 
         RowBox[{"Tex", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "BB", "]"}], 
           "/.", "ToOrderedPlus"}], "]"}], ",", "\"\<}\>\""}], "]"}], ",", 
       "\"\<\>\""}], "]"}], ",", "\"\<{\\\\overset{\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"Tex", "[", 
        RowBox[{"unprim", "/.", "ToOrderedPlus"}], "]"}], ",", "\"\<,\>\"", 
       ",", 
       RowBox[{"Tex", "[", 
        RowBox[{"prim", "/.", "ToOrderedPlus"}], "]"}]}], "]"}], ",", 
     "\"\<}{\\\\odot }}\>\"", ",", 
     RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", "BB", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[246]:=",ExpressionUUID->"c7e9fc76-3f85-4c82-b3c4-3a62a6b1292d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{"SymMult", ",", "MultScal"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{
         RowBox[{"MultScal", "[", 
          RowBox[{"s_", ",", "AA_"}], "]"}], ",", "unprim_", ",", "prim_", 
         ",", "spin_"}], "]"}], "[", "BB_", "]"}], "\[RuleDelayed]", 
      RowBox[{"MultScal", "[", 
       RowBox[{"s", ",", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"AA", ",", "unprim", ",", "prim", ",", "spin"}], "]"}], "[",
          "BB", "]"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA_", ",", "unprim_", ",", "prim_", ",", "spin_"}], "]"}], 
       "[", 
       RowBox[{"MultScal", "[", 
        RowBox[{"s_", ",", "BB_"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"MultScal", "[", 
       RowBox[{"s", ",", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"AA", ",", "unprim", ",", "prim", ",", "spin"}], "]"}], "[",
          "BB", "]"}]}], "]"}]}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.8400019941000853`*^9, {3.95567499783543*^9, 3.9556749981113644`*^9}, {
   3.9556752746779213`*^9, 3.955675275547159*^9}},
 CellLabel->
  "In[247]:=",ExpressionUUID->"81fdb2c7-0792-41c4-b07f-2463730ddb9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{"MultScal", ",", "SymMult"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MultScal", "[", 
      RowBox[{"s_", ",", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA_", ",", "unprim_", ",", "prim_", ",", "spin_"}], "]"}], 
        "[", "BB_", "]"}]}], "]"}], ":>", 
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{"AA", ",", "unprim", ",", "prim", ",", "spin"}], "]"}], "[", 
      RowBox[{"MultScal", "[", 
       RowBox[{"s", ",", "BB"}], "]"}], "]"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.95567502946653*^9, 3.95567507309972*^9}, {
  3.95567519821336*^9, 3.9556752330133877`*^9}},
 CellLabel->
  "In[248]:=",ExpressionUUID->"eebfc304-a5e2-5445-b0ec-2a8f3ca59753"]
}, Closed]],

Cell[CellGroupData[{

Cell["Valence (1, 1) and some (2,0) - commutators", "Subsubsection",
 CellChangeTimes->{{3.838698715540696*^9, 3.8386987289005203`*^9}, {
  3.955674760226265*^9, 3.955674766495447*^9}, {3.956049563793585*^9, 
  3.9560495656831055`*^9}, {3.9560496274144745`*^9, 
  3.956049628020729*^9}},ExpressionUUID->"a78e59e2-886b-1b4e-9b75-\
5ddd1d6e1679"],

Cell["\<\
Quick valence check. No symmetry check is needed for valence (1,1).\
\>", "Text",
 CellChangeTimes->{{3.83915648790252*^9, 3.8391565129195414`*^9}, {
  3.9556747711574783`*^9, 
  3.955674772636738*^9}},ExpressionUUID->"5ee804df-52ad-4f73-bbd0-\
448af8d2bf83"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SpinorOfValenceQ", "[", 
    RowBox[{"k_", ",", "l_", ",", "spin_"}], "]"}], "[", "TT_", "]"}], ":=", 
  RowBox[{"And", "[", 
   RowBox[{
    RowBox[{"xTensorQ", "[", "TT", "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "TT", "]"}], 
     "\[Equal]", "k"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "TT", "]"}], 
     "\[Equal]", "l"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[249]:=",ExpressionUUID->"4bbb713c-4766-468b-b33a-c867c138b4ac"],

Cell["For valence 1, 1 spinors", "Text",
 CellChangeTimes->{{3.8391564568137035`*^9, 
  3.8391564719033422`*^9}},ExpressionUUID->"26f7e7c0-8a5d-498a-bf5f-\
5cf30ed287d0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{"k", "/", 
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
             "TT", "]"}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "0", ",", "2", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "k"}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
             "TT", "]"}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "1", ",", "2", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], ";", 
  
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{"l", "/", 
            RowBox[{"(", 
             RowBox[{"l", "+", "1"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
             "TT", "]"}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "2", ",", "0", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"l", "+", "1"}], ")"}], "/", "l"}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
             "TT", "]"}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "2", ",", "1", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"k", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
          ",", 
          RowBox[{"l", "=", 
           RowBox[{
            RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"MultScal", "[", 
         RowBox[{
          RowBox[{"l", "/", 
           RowBox[{"(", 
            RowBox[{"l", "+", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
            "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"k", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
          ",", 
          RowBox[{"l", "=", 
           RowBox[{
            RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"MultScal", "[", 
         RowBox[{
          RowBox[{"k", "/", 
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
            "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"l", "+", "1"}], ")"}], "/", "l"}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
             "TT", "]"}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "0", ",", "1", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "k"}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
             "TT", "]"}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
             "TT", "]"}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}], "-", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ")"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
             "TT", "]"}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}], "-", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ")"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}]}], "+", 
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"l", "+", "1"}], ")"}]}]}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"l", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "+", "2"}], ")"}], "/", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}], "^", "2"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}]}], "+", 
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"l", "+", "1"}], ")"}]}]}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"k", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "2"}], ")"}], "/", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "^", "2"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "0", ",", "1", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}], "*", "l", "*", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "l"}], ")"}]}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "l"}], ")"}], "^", "2"}], "/", 
              RowBox[{"(", 
               RowBox[{"l", "*", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "l"}], ")"}]}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "0", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "0", ",", "1", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}], "*", "k", "*", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "k"}], ")"}], "^", "2"}], "/", 
              RowBox[{"(", 
               RowBox[{"k", "*", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"TT", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.83915552537204*^9, 3.8391555295159616`*^9}, {
   3.8391555657879486`*^9, 3.839155601596482*^9}, {3.839156244223792*^9, 
   3.839156261497637*^9}, {3.839156371371069*^9, 3.839156376149269*^9}, {
   3.839156445407196*^9, 3.8391564502871504`*^9}, 3.839156542948546*^9, {
   3.839156794833272*^9, 3.839156871094409*^9}, {3.8391570225278406`*^9, 
   3.839157150156788*^9}, {3.839157186499814*^9, 3.8391571898209085`*^9}, {
   3.839157271503541*^9, 3.83915735688547*^9}, {3.891268132655943*^9, 
   3.8912681333112183`*^9}, {3.9568096696913776`*^9, 3.956809736319252*^9}, {
   3.9568097686827316`*^9, 3.9568097752282333`*^9}, {3.9568098068756866`*^9, 
   3.956809839033716*^9}},
 CellLabel->
  "In[250]:=",ExpressionUUID->"770d88fd-7d6d-46ce-9f03-9a749390ab9b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AllSymMultCommutatorRules", "[", 
    RowBox[{"AA_", ",", 
     RowBox[{"spin_", ":", "$DefaultSpinBundle"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}]}], "]"}], ",", 
      RowBox[{"CommuteOp", "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}]}], "]"}], ",", 
      RowBox[{"CommuteOp", "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}]}], "]"}], ",", 
      RowBox[{"CommuteOp", "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}]}], "]"}], ",", 
      RowBox[{"CommuteOp", "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}]}], "]"}], ",", 
      RowBox[{"CommuteOp", "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "0", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}]}], "]"}], ",", 
      RowBox[{"CommuteOp", "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], ",", 
        RowBox[{"SymMult", "[", 
         RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}]}], "]"}]}], 
     "}"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.839156269618558*^9, {3.8391573855827584`*^9, 3.8391574292452364`*^9}, 
   3.891265208356454*^9},
 CellLabel->
  "In[263]:=",ExpressionUUID->"90d6497c-2544-4a2c-bd65-cf23289014ca"],

Cell["\<\
Two SymMult operators commute if the contraction numbers agree and both \
spinors are of valence (1,1)
Are these covered by the general rule?\
\>", "Text",
 CellChangeTimes->{{3.7008980564310102`*^9, 3.700898077210199*^9}, {
  3.700898672437244*^9, 3.700898708892329*^9}, {3.8391576402928085`*^9, 
  3.8391576573243856`*^9}},ExpressionUUID->"7afa05fe-89c9-4f74-a672-\
2e6d267f8c65"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "i_", ",", "j_", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"BB_", ",", "i_", ",", "j_", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "i", ",", "j", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"BB", ",", "i", ",", "j", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"BB", ",", "i", ",", "j", ",", "spin"}], "]"}], "[", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"AA", ",", "i", ",", "j", ",", "spin"}], "]"}], "[", "TT", 
         "]"}], "]"}], "/;", 
       RowBox[{"AA", "=!=", "BB"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{
      RowBox[{"SpinorOfValenceQ", "[", 
       RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}], "&&", 
     RowBox[{
      RowBox[{"SpinorOfValenceQ", "[", 
       RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "BB", "]"}]}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8391562741006007`*^9, 3.8391562849882374`*^9}, {
  3.839157491107869*^9, 3.839157550889612*^9}},
 CellLabel->
  "In[264]:=",ExpressionUUID->"98585b23-580d-4bbe-ae4d-f9fcc7472ea0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"BB_", ",", "0", ",", "1", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"BB", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", 
              RowBox[{"(", 
               RowBox[{"k", "+", "1"}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"BB", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"k", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "2"}], ")"}], "/", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "^", "2"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"BB", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"AA", "=!=", "BB"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{
      RowBox[{"SpinorOfValenceQ", "[", 
       RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}], "&&", 
     RowBox[{
      RowBox[{"SpinorOfValenceQ", "[", 
       RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "BB", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"AA_", ",", "1", ",", "1", ",", "spin_"}], "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"BB_", ",", "1", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"BB", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", 
              RowBox[{"(", 
               RowBox[{"l", "+", "1"}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"BB", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"l", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "+", "2"}], ")"}], "/", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}], "^", "2"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"BB", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"AA", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
               "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"AA", "=!=", "BB"}]}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{
      RowBox[{"SpinorOfValenceQ", "[", 
       RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "AA", "]"}], "&&", 
     RowBox[{
      RowBox[{"SpinorOfValenceQ", "[", 
       RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "BB", "]"}]}]}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8391562890952587`*^9, 3.8391562970031433`*^9}, {
  3.839157609996318*^9, 3.839157635154549*^9}},
 CellLabel->
  "In[265]:=",ExpressionUUID->"6cb47521-09f3-41a9-85ad-5af86e612e73"],

Cell["Valence (2,0)", "Text",
 CellChangeTimes->{{3.9560482227150307`*^9, 
  3.956048237388695*^9}},ExpressionUUID->"5cbefc96-09a2-2540-a4b8-\
abf0d952f845"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", "0", ",", "0", ",", "spin_"}], 
      "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"T_", ",", "1", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], "]"}], ":>", 
      RowBox[{
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[Phi]"}]}], "}"}], ",", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "+", "k"}], ")"}], "/", "k"}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
             "\[Phi]", "]"}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}], ")"}],
     "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"2", ",", "0", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", "1", ",", "0", ",", "spin_"}], 
      "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"T_", ",", "0", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
        RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], "]"}], ":>", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"k", "=", 
          RowBox[{
           RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
           "\[Phi]"}]}], "}"}], ",", 
        RowBox[{"MultScal", "[", 
         RowBox[{
          RowBox[{"k", "/", 
           RowBox[{"(", 
            RowBox[{"2", "+", "k"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
            "\[Phi]", "]"}], "]"}]}], "]"}]}], "]"}]}], ")"}], "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"2", ",", "0", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", "0", ",", "0", ",", "spin_"}], 
      "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"T_", ",", "2", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
        "\[Phi]_", "]"}], "]"}], ":>", 
      RowBox[{
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[Phi]"}]}], "}"}], ",", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "*", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"4", "*", "k", "*", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k"}], ")"}], "^", "2"}]}], ")"}]}], ",", 
             
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}]}]}], ")"}],
     "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"2", ",", "0", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", "2", ",", "0", ",", "spin_"}], 
      "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"T_", ",", "0", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
        "\[Phi]_", "]"}], "]"}], ":>", 
      RowBox[{
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[Phi]"}]}], "}"}], ",", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"-", "4"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "+", "k"}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
              RowBox[{"k", "^", 
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}]}], " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "k"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}]}], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", "k"}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}], ")"}],
     "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"2", ",", "0", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", "1", ",", "0", ",", "spin_"}], 
      "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"T_", ",", "2", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
        "\[Phi]_", "]"}], "]"}], ":>", 
      RowBox[{
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[Phi]"}]}], "}"}], ",", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{"k", "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "k"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
             "\[Phi]", "]"}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}]}]}], ")"}],
     "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"2", ",", "0", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", "2", ",", "0", ",", "spin_"}], 
      "]"}], ",", 
     RowBox[{"SymMult", "[", 
      RowBox[{"T_", ",", "1", ",", "0", ",", "spin_"}], "]"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
        "\[Phi]_", "]"}], "]"}], ":>", 
      RowBox[{
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[Phi]"}]}], "}"}], ",", 
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "k"}], ")"}], "/", "k"}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
             "\[Phi]", "]"}], "]"}]}], "]"}]}], "]"}], "/;", 
       RowBox[{"EnoughIndsQSpin", "[", 
        RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}]}]}], ")"}],
     "/;", 
    RowBox[{
     RowBox[{"SpinorOfValenceQ", "[", 
      RowBox[{"2", ",", "0", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956048327860182*^9, 3.9560483755751*^9}, {
   3.9560484270717964`*^9, 3.956048555625866*^9}, {3.956048596609783*^9, 
   3.95604859971323*^9}, {3.9560486518885784`*^9, 3.9560486564061375`*^9}, {
   3.956048804561619*^9, 3.956048819090435*^9}, {3.956049282195381*^9, 
   3.9560492878863354`*^9}, {3.9560494138114014`*^9, 3.956049432359232*^9}, 
   3.956202665353882*^9, {3.9562027495931206`*^9, 3.956202800538315*^9}, {
   3.9569819651924744`*^9, 3.9569819957727222`*^9}, {3.9569820589069424`*^9, 
   3.9569821161489143`*^9}, {3.956982164791874*^9, 3.956982236504463*^9}, {
   3.956982365144562*^9, 3.9569823875098*^9}, {3.9569824560156326`*^9, 
   3.956982485028099*^9}, {3.956982826490986*^9, 3.956982835865923*^9}},
 CellLabel->
  "In[267]:=",ExpressionUUID->"42d1367d-e892-f544-a74b-29bc857d84b9"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
SymHToSymMultRule, SymMultLeibnizRules, MultScalLeibnizRules, SortSymMult\
\>", "Subsubsection",
 CellChangeTimes->{{3.838707189208108*^9, 3.838707209994882*^9}, {
  3.8387072507367373`*^9, 
  3.838707256409544*^9}},ExpressionUUID->"c37dcb1b-5f9c-4031-bed4-\
d851dffe653b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymHToSymMultRule", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", ":", 
       RowBox[{
        RowBox[{"SymH", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"T1_", ",", "T2_"}], " ", "}"}], ",", "group_", ",", 
          "label_"}], "]"}], "[", "inds___", "]"}]}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"dummybundles", "=", 
           RowBox[{"VBundleOfIndex", "/@", 
            RowBox[{"List", "@@", 
             RowBox[{"FindDummyIndices", "@", 
              RowBox[{"Evaluate", "@", "x"}]}]}]}]}], ",", "symmultexpr", ",",
           "symmulteq", ",", "TFirst", ",", "TSecond", ",", 
          RowBox[{"spin", "=", "$DefaultSpinBundle"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"TFirst", ",", "TSecond"}], "}"}], "=", 
          RowBox[{"SortBy", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"T1", ",", "T2"}], "}"}], ",", 
            RowBox[{
             RowBox[{"Length", "@", 
              RowBox[{"SlotsOfTensor", "@", "#"}]}], "&"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"symmultexpr", "=", 
          RowBox[{"GiveIndicesToTensor", "@", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"TFirst", ",", 
              RowBox[{
               RowBox[{"NumOfUnprimedVBundles", "[", "spin", "]"}], "@", 
               "dummybundles"}], ",", 
              RowBox[{
               RowBox[{"NumOfPrimedVBundles", "[", "spin", "]"}], "@", 
               "dummybundles"}]}], "]"}], "[", "TSecond", "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"symmulteq", "=", 
          RowBox[{"symmultexpr", "==", 
           RowBox[{"ToCanonicalSym", "[", 
            RowBox[{"symmultexpr", "/.", "SymMultRule"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ToCanonicalSym", "[", "x", "]"}], "/.", 
          RowBox[{"EqToCompareRule", "@", 
           RowBox[{"FlipEquation", "@", "symmulteq"}]}]}]}]}], 
       "\[IndentingNewLine]", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", ":", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"T1_", "?", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"And", "[", 
              RowBox[{
               RowBox[{"xTensorQ", "[", "#", "]"}], ",", 
               RowBox[{
                RowBox[{"Not", "@", 
                 RowBox[{"MetricQ", "[", "#", "]"}]}], "&&", 
                RowBox[{"Not", "[", 
                 RowBox[{"#", "===", "delta"}], "]"}]}]}], "]"}], "&"}], 
            ")"}]}], "[", "indsa__", "]"}], 
         RowBox[{
          RowBox[{"T2_", "?", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"And", "[", 
              RowBox[{
               RowBox[{"xTensorQ", "[", "#", "]"}], ",", 
               RowBox[{
                RowBox[{"Not", "@", 
                 RowBox[{"MetricQ", "[", "#", "]"}]}], "&&", 
                RowBox[{"Not", "[", 
                 RowBox[{"#", "===", "delta"}], "]"}]}]}], "]"}], "&"}], 
            ")"}]}], "[", "indsb__", "]"}]}], ")"}]}], "\[RuleDelayed]", " ", 
      
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"dummybundles", "=", 
           RowBox[{"VBundleOfIndex", "/@", 
            RowBox[{"List", "@@", 
             RowBox[{"FindDummyIndices", "@", 
              RowBox[{"Evaluate", "@", "x"}]}]}]}]}], ",", "unprimed", ",", 
          "primed", ",", "symmultexpr", ",", "symmulteq", ",", "TFirst", ",", 
          "TSecond", ",", 
          RowBox[{"spin", "=", "$DefaultSpinBundle"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"unprimed", "=", 
          RowBox[{
           RowBox[{"NumOfUnprimedVBundles", "[", "spin", "]"}], "@", 
           "dummybundles"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"primed", "=", 
          RowBox[{
           RowBox[{"NumOfPrimedVBundles", "[", "spin", "]"}], "@", 
           "dummybundles"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"TFirst", ",", "TSecond"}], "}"}], "=", 
          RowBox[{"SortBy", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"T1", ",", "T2"}], "}"}], ",", 
            RowBox[{
             RowBox[{"Length", "@", 
              RowBox[{"SlotsOfTensor", "@", "#"}]}], "&"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"unprimed", "+", "primed"}], "==", "0"}], ",", "x", ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"symmultexpr", "=", 
             RowBox[{"GiveIndicesToTensor", "@", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"TFirst", ",", "unprimed", ",", "primed"}], "]"}], 
               "[", "TSecond", "]"}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"symmulteq", "=", 
             RowBox[{"symmultexpr", "==", 
              RowBox[{"ToCanonical", "[", 
               RowBox[{"symmultexpr", "/.", "SymMultRule"}], "]"}]}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"symmulteq", "===", "True"}], ",", "x", ",", 
              RowBox[{"x", "/.", 
               RowBox[{"EqToCompareRule", "@", 
                RowBox[{"FlipEquation", "@", "symmulteq"}]}]}]}], "]"}]}]}], 
          "\[IndentingNewLine]", "]"}]}]}], "]"}]}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8391576948376727`*^9, 3.839157698724311*^9}, {
  3.8391577522054987`*^9, 3.8391578275414486`*^9}, {3.8400304754840183`*^9, 
  3.84003049211666*^9}, {3.8406265555535655`*^9, 3.8406265613805485`*^9}},
 CellLabel->
  "In[272]:=",ExpressionUUID->"2883df3c-aa13-44ce-9ebe-9fe11b55dd2f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymMultLeibnizRules", "[", "]"}], ":=", 
  RowBox[{"SymMultLeibnizRules", "[", 
   RowBox[{"First", "[", 
    RowBox[{"SpinCovDsOfSolderingForm", "[", 
     RowBox[{"SolderingFormOfVBundle", "[", "$DefaultSpinBundle", "]"}], 
     "]"}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[273]:=",ExpressionUUID->"5993a9df-08d6-4520-89af-40ecbd54491d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymMultLeibnizRules", "[", "covd_", "]"}], ":=", "\n", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", "\n", 
      RowBox[{
       RowBox[{"divcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`DivName", "@", "covd"}]}], ",", 
       " ", "\n", 
       RowBox[{"curlcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`CurlName", "@", "covd"}]}], ",", 
       " ", "\n", 
       RowBox[{"curldgcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", "covd"}]}], 
       ",", " ", "\n", 
       RowBox[{"twistcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`TwistName", "@", "covd"}]}]}], 
      "}"}], ",", "\n", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"twistcd", "[", 
         RowBox[{
          RowBox[{"SymMult", "[", 
           RowBox[{
            RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
            "spin_"}], "]"}], "[", 
          RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "]"}], 
        "\[RuleDelayed]", "\n", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
              "\[Phi]"}]}], ",", 
            RowBox[{"j", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
              "\[Phi]"}]}], ",", 
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
              "\[CurlyPhi]"}]}], ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
              "\[CurlyPhi]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"m", "+", "n"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", "m", ",", "n", ",", "spin"}], 
                "]"}], "@", 
               RowBox[{"twistcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}]}], "*", 
               RowBox[{"n", "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", "m", ",", 
                 RowBox[{"n", "-", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"curlcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}]}], "*", 
               RowBox[{"m", "/", 
                RowBox[{"(", 
                 RowBox[{"i", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", 
                 RowBox[{"m", "-", "1"}], ",", "n", ",", "spin"}], "]"}], "@", 
               RowBox[{"curldgcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}]}], "*", "m", "*", 
               RowBox[{
                RowBox[{"n", "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "1"}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", 
                 RowBox[{"m", "-", "1"}], ",", 
                 RowBox[{"n", "-", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"divcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], "@", 
             RowBox[{"twistcd", "[", "\[CurlyPhi]", "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"n", "/", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", "m", ",", 
                 RowBox[{"n", "-", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"curlcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"m", "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"m", "-", "1"}], ",", "n", ",", "spin"}], "]"}], "@", 
               RowBox[{"curldgcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"m", "*", 
               RowBox[{
                RowBox[{"n", "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"m", "-", "1"}], ",", 
                 RowBox[{"n", "-", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"divcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"curlcd", "[", 
         RowBox[{
          RowBox[{"SymMult", "[", 
           RowBox[{
            RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
            "spin_"}], "]"}], "[", 
          RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "]"}], 
        "\[RuleDelayed]", "\n", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
              "\[Phi]"}]}], ",", 
            RowBox[{"j", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
              "\[Phi]"}]}], ",", 
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
              "\[CurlyPhi]"}]}], ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
              "\[CurlyPhi]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "n"}], ")"}]}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"l", "-", "n"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "l", "-", 
                  RowBox[{"2", "n"}]}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", "m", ",", 
                 RowBox[{"n", "+", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"twistcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}]}], "*", 
               RowBox[{"(", 
                RowBox[{"j", "-", "n"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", "n", "+", "1"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", 
                   RowBox[{"2", "n"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", "m", ",", "n", ",", "spin"}], 
                "]"}], "@", 
               RowBox[{"curlcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "n"}], ")"}]}]}], "*", "m", "*", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"l", "-", "n"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", 
                   RowBox[{"2", "n"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"i", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", 
                 RowBox[{"m", "-", "1"}], ",", 
                 RowBox[{"n", "+", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"curldgcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}]}], "*", "m", "*", 
               RowBox[{"(", 
                RowBox[{"j", "-", "n"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"j", "+", "l", "-", "n", "+", "1"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"j", "+", "l", "-", 
                    RowBox[{"2", "n"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "1"}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", 
                 RowBox[{"m", "-", "1"}], ",", "n", ",", "spin"}], "]"}], "@", 
               RowBox[{"divcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"j", "-", "n"}], ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"j", "+", "l", "-", 
                 RowBox[{"2", "n"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", "m", ",", 
                 RowBox[{"n", "+", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"twistcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "-", "n"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", "n", "+", "1"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", 
                   RowBox[{"2", "n"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], 
               "@", 
               RowBox[{"curlcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "m"}], "*", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"j", "-", "n"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", 
                   RowBox[{"2", "n"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"m", "-", "1"}], ",", 
                 RowBox[{"n", "+", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"curldgcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"m", "*", 
               RowBox[{"(", 
                RowBox[{"l", "-", "n"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"j", "+", "l", "-", "n", "+", "1"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"j", "+", "l", "-", 
                    RowBox[{"2", "n"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"m", "-", "1"}], ",", "n", ",", "spin"}], "]"}], "@", 
               RowBox[{"divcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"curldgcd", "[", 
         RowBox[{
          RowBox[{"SymMult", "[", 
           RowBox[{
            RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
            "spin_"}], "]"}], "[", 
          RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "]"}], 
        "\[RuleDelayed]", "\n", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
              "\[Phi]"}]}], ",", 
            RowBox[{"j", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
              "\[Phi]"}]}], ",", 
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
              "\[CurlyPhi]"}]}], ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
              "\[CurlyPhi]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "n"}], ")"}]}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "m"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"i", "+", "k", "-", 
                  RowBox[{"2", "m"}]}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", 
                 RowBox[{"m", "+", "1"}], ",", "n", ",", "spin"}], "]"}], "@", 
               RowBox[{"twistcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "n"}], ")"}]}]}], "*", "n", "*", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "-", "m"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "k", "-", 
                   RowBox[{"2", "m"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", 
                 RowBox[{"m", "+", "1"}], ",", 
                 RowBox[{"n", "-", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"curlcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}]}], "*", 
               RowBox[{"(", 
                RowBox[{"i", "-", "m"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"i", "+", "k", "-", "m", "+", "1"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "k", "-", 
                   RowBox[{"2", "m"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"i", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", "m", ",", "n", ",", "spin"}], 
                "]"}], "@", 
               RowBox[{"curldgcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}]}], "*", "n", "*", 
               RowBox[{"(", 
                RowBox[{"i", "-", "m"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", "m", "+", "1"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", 
                    RowBox[{"2", "m"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "1"}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", "m", ",", 
                 RowBox[{"n", "-", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"divcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"i", "-", "m"}], ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"i", "+", "k", "-", 
                 RowBox[{"2", "m"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"m", "+", "1"}], ",", "n", ",", "spin"}], "]"}], "@", 
               RowBox[{"twistcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "n"}], "*", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"i", "-", "m"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "k", "-", 
                   RowBox[{"2", "m"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"m", "+", "1"}], ",", 
                 RowBox[{"n", "-", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"curlcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "m"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"i", "+", "k", "-", "m", "+", "1"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "k", "-", 
                   RowBox[{"2", "m"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], 
               "@", 
               RowBox[{"curldgcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"n", "*", 
               RowBox[{"(", 
                RowBox[{"k", "-", "m"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", "m", "+", "1"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", 
                    RowBox[{"2", "m"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", "m", ",", 
                 RowBox[{"n", "-", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"divcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"divcd", "[", 
         RowBox[{
          RowBox[{"SymMult", "[", 
           RowBox[{
            RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
            "spin_"}], "]"}], "[", 
          RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "]"}], 
        "\[RuleDelayed]", "\n", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
              "\[Phi]"}]}], ",", 
            RowBox[{"j", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
              "\[Phi]"}]}], ",", 
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
              "\[CurlyPhi]"}]}], ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
              "\[CurlyPhi]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"TensorPlus", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}]}], 
               RowBox[{"(", 
                RowBox[{"k", "-", "m"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"l", "-", "n"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "k", "-", 
                   RowBox[{"2", "m"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "l", "-", 
                  RowBox[{"2", "n"}]}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", 
                 RowBox[{"m", "+", "1"}], ",", 
                 RowBox[{"n", "+", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"twistcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "n"}], ")"}]}]}], 
               RowBox[{"(", 
                RowBox[{"k", "-", "m"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"j", "-", "n"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"j", "+", "l", "-", "n", "+", "1"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", 
                    RowBox[{"2", "m"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", 
                   RowBox[{"2", "n"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", 
                 RowBox[{"m", "+", "1"}], ",", "n", ",", "spin"}], "]"}], "@", 
               RowBox[{"curlcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "n"}], ")"}]}]}], 
               RowBox[{"(", 
                RowBox[{"l", "-", "n"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"i", "-", "m"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", "m", "+", "1"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", 
                    RowBox[{"2", "m"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", 
                   RowBox[{"2", "n"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"i", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", "m", ",", 
                 RowBox[{"n", "+", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"curldgcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"-", "1"}], ")"}], "^", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}]}], 
               RowBox[{"(", 
                RowBox[{"i", "-", "m"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"j", "-", "n"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"i", "+", "k", "-", "m", "+", "1"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"j", "+", "l", "-", "n", "+", "1"}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"i", "+", "k", "-", 
                    RowBox[{"2", "m"}]}], ")"}]}], "/", 
                  RowBox[{"(", 
                   RowBox[{"j", "+", "l", "-", 
                    RowBox[{"2", "n"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "1"}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[CurlyPhi]", ",", "m", ",", "n", ",", "spin"}], 
                "]"}], "@", 
               RowBox[{"divcd", "[", "\[Phi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"i", "-", "m"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"j", "-", "n"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"i", "+", "k", "-", 
                   RowBox[{"2", "m"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"j", "+", "l", "-", 
                  RowBox[{"2", "n"}]}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"m", "+", "1"}], ",", 
                 RowBox[{"n", "+", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"twistcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"i", "-", "m"}], ")"}]}], 
               RowBox[{"(", 
                RowBox[{"l", "-", "n"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"j", "+", "l", "-", "n", "+", "1"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", 
                    RowBox[{"2", "m"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", 
                   RowBox[{"2", "n"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"m", "+", "1"}], ",", "n", ",", "spin"}], "]"}], "@", 
               RowBox[{"curlcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"k", "-", "m"}], ")"}]}], 
               RowBox[{"(", 
                RowBox[{"j", "-", "n"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", "m", "+", "1"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"i", "+", "k", "-", 
                    RowBox[{"2", "m"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"j", "+", "l", "-", 
                   RowBox[{"2", "n"}]}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", "m", ",", 
                 RowBox[{"n", "+", "1"}], ",", "spin"}], "]"}], "@", 
               RowBox[{"curldgcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "m"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"l", "-", "n"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"i", "+", "k", "-", "m", "+", "1"}], ")"}], 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"j", "+", "l", "-", "n", "+", "1"}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"i", "+", "k", "-", 
                    RowBox[{"2", "m"}]}], ")"}]}], "/", 
                  RowBox[{"(", 
                   RowBox[{"j", "+", "l", "-", 
                    RowBox[{"2", "n"}]}], ")"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}]}], "/", 
                RowBox[{"(", 
                 RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], 
               "@", 
               RowBox[{"divcd", "[", "\[CurlyPhi]", "]"}]}]}], "]"}]}], 
           "\[IndentingNewLine]", "]"}]}], "]"}]}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[274]:=",ExpressionUUID->"a5fdbd71-0eca-4563-b385-0e5f84b9996b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"TwistMultScal", "[", 
   RowBox[{"covd_", ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"T_", "?", "xTensorQ"}], ")"}], "[", "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"xAct`SymManipulator`Private`TwistName", "@", "covd"}], ")"}], 
   "[", "T", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TwistMultScal", "[", 
   RowBox[{"covd_", ",", 
    RowBox[{"Times", "[", 
     RowBox[{"a_", ",", "rest__"}], "]"}]}], "]"}], ":=", 
  RowBox[{"TensorPlus", "[", 
   RowBox[{
    RowBox[{"MultScal", "[", 
     RowBox[{
      RowBox[{"Times", "[", "rest", "]"}], ",", 
      RowBox[{"TwistMultScal", "[", 
       RowBox[{"covd", ",", "a"}], "]"}]}], "]"}], ",", 
    RowBox[{"MultScal", "[", 
     RowBox[{"a", ",", 
      RowBox[{"TwistMultScal", "[", 
       RowBox[{"covd", ",", 
        RowBox[{"Times", "[", "rest", "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TwistMultScal", "[", 
   RowBox[{"covd_", ",", 
    RowBox[{"Power", "[", 
     RowBox[{"a_", ",", 
      RowBox[{"c_", "?", "ConstantQ"}]}], "]"}]}], "]"}], ":=", 
  RowBox[{"MultScal", "[", 
   RowBox[{
    RowBox[{"c", "*", 
     RowBox[{"Power", "[", 
      RowBox[{"a", ",", 
       RowBox[{"c", "-", "1"}]}], "]"}]}], ",", 
    RowBox[{"TwistMultScal", "[", 
     RowBox[{"covd", ",", "a"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TwistMultScal", "[", 
   RowBox[{"covd_", ",", "expr_Plus"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"TwistMultScal", "[", 
     RowBox[{"covd", ",", "#"}], "]"}], "&"}], "/@", 
   RowBox[{"TensorPlus", "@@", "expr"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TwistMultScal", "[", 
   RowBox[{"covd_", ",", 
    RowBox[{"c_", "?", "ConstantQ"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"spin", "=", 
       RowBox[{
        RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ",", 
      RowBox[{"spindg", "=", 
       RowBox[{
        RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"ZeroTensor", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "spin"}], ",", 
       RowBox[{"-", "spindg"}]}], "}"}], "]"}]}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.776737806532586*^9, 3.776737850993584*^9}, {
  3.7767395067657394`*^9, 3.776739523430374*^9}, {3.8388791855273247`*^9, 
  3.838879297398347*^9}, {3.839155632517634*^9, 3.8391556492935333`*^9}, {
  3.839155761491336*^9, 3.8391557769012885`*^9}},
 CellLabel->
  "In[275]:=",ExpressionUUID->"5745b62e-9bd2-477e-b47a-5dca8470a755"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MultScalLeibnizRules", "[", "]"}], ":=", 
  RowBox[{"MultScalLeibnizRules", "[", 
   RowBox[{"First", "[", 
    RowBox[{"SpinCovDsOfSolderingForm", "[", 
     RowBox[{"SolderingFormOfVBundle", "[", "$DefaultSpinBundle", "]"}], 
     "]"}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[280]:=",ExpressionUUID->"21ce6db1-cd18-4dd4-86da-a746c8d24d8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MultScalLeibnizRules", "[", "covd_", "]"}], ":=", "\n", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", "\n", 
      RowBox[{
       RowBox[{"divcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`DivName", "@", "covd"}]}], ",", 
       " ", "\n", 
       RowBox[{"curlcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`CurlName", "@", "covd"}]}], ",", 
       " ", "\n", 
       RowBox[{"curldgcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", "covd"}]}], 
       ",", " ", "\n", 
       RowBox[{"twistcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`TwistName", "@", "covd"}]}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"spin", "=", 
        RowBox[{"VBundleOfSolderingForm", "@", 
         RowBox[{"SolderingFormOfSpinCovD", "[", "covd", "]"}]}]}]}], "}"}], 
     ",", "\n", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"divcd", "[", 
         RowBox[{"MultScal", "[", 
          RowBox[{"expr_", ",", "T_"}], "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{"TensorPlus", "[", 
         RowBox[{
          RowBox[{"MultScal", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"divcd", "[", "T", "]"}]}], "]"}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{
             RowBox[{"TwistMultScal", "[", 
              RowBox[{"covd", ",", "expr"}], "]"}], ",", "1", ",", "1", ",", 
             "spin"}], "]"}], "[", "T", "]"}]}], "]"}]}], ",", "\n", 
       RowBox[{
        RowBox[{"curlcd", "[", 
         RowBox[{"MultScal", "[", 
          RowBox[{"expr_", ",", "T_"}], "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{"TensorPlus", "[", 
         RowBox[{
          RowBox[{"MultScal", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"curlcd", "[", "T", "]"}]}], "]"}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{
             RowBox[{"TwistMultScal", "[", 
              RowBox[{"covd", ",", "expr"}], "]"}], ",", "0", ",", "1", ",", 
             "spin"}], "]"}], "[", "T", "]"}]}], "]"}]}], ",", "\n", 
       RowBox[{
        RowBox[{"curldgcd", "[", 
         RowBox[{"MultScal", "[", 
          RowBox[{"expr_", ",", "T_"}], "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{"TensorPlus", "[", 
         RowBox[{
          RowBox[{"MultScal", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"curldgcd", "[", "T", "]"}]}], "]"}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{
             RowBox[{"TwistMultScal", "[", 
              RowBox[{"covd", ",", "expr"}], "]"}], ",", "1", ",", "0", ",", 
             "spin"}], "]"}], "[", "T", "]"}]}], "]"}]}], ",", "\n", 
       RowBox[{
        RowBox[{"twistcd", "[", 
         RowBox[{"MultScal", "[", 
          RowBox[{"expr_", ",", "T_"}], "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{"TensorPlus", "[", 
         RowBox[{
          RowBox[{"MultScal", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"twistcd", "[", "T", "]"}]}], "]"}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{
             RowBox[{"TwistMultScal", "[", 
              RowBox[{"covd", ",", "expr"}], "]"}], ",", "0", ",", "0", ",", 
             "spin"}], "]"}], "[", "T", "]"}]}], "]"}]}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8444286485252905`*^9, 3.8444286548862963`*^9}},
 CellLabel->
  "In[281]:=",ExpressionUUID->"7fd1c544-e119-4fe2-98d2-acb5be41fe73"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefaultSortSymMultFunc", "[", "spin_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "#", "]"}], "+", 
      RowBox[{
       RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "#", "]"}]}], ",", 
     RowBox[{
      RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "#", "]"}], ",", 
     
     RowBox[{
      RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "#", "]"}]}], 
    "}"}], "&"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[282]:=",ExpressionUUID->"2cd0bd95-7955-4368-90a9-16f726e8410a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SortSymMult", "[", "]"}], " ", ":=", " ", 
   RowBox[{"SortSymMult", "[", 
    RowBox[{"DefaultSortSymMultFunc", "[", "$DefaultSpinBundle", "]"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SortSymMultReverse", "[", "]"}], ":=", 
   RowBox[{"SortSymMultReverse", "[", 
    RowBox[{"DefaultSortSymMultFunc", "[", "$DefaultSpinBundle", "]"}], 
    "]"}]}], ";"}]}], "Code",
 CellChangeTimes->{{3.8399321410033364`*^9, 3.839932236810989*^9}},
 CellLabel->
  "In[283]:=",ExpressionUUID->"ffea4ddb-58ed-4845-b1c3-a17123f1f5a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SortSymMult", "[", "orderingfunc_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{
        RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
        "spin_"}], "]"}], "[", 
      RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"\[CurlyPhi]", ",", "m", ",", "n", ",", "spin"}], "]"}], 
         "[", "\[Phi]", "]"}]}], "]"}], "/;", 
      RowBox[{"Not", "[", 
       RowBox[{"OrderedQ", "[", 
        RowBox[{"orderingfunc", "/@", 
         RowBox[{"{", 
          RowBox[{"\[Phi]", ",", "\[CurlyPhi]"}], "}"}]}], "]"}], "]"}]}]}], 
    ",", 
    RowBox[{
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{
        RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
        "spin_"}], "]"}], "[", 
      RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"ZeroTensorOfTensor", "@", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], "[", 
        "\[Phi]", "]"}]}], "/;", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n"}], ")"}]}], "\[Equal]", 
        RowBox[{"-", "1"}]}], ")"}]}]}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.8449216668288636`*^9},
 CellLabel->
  "In[285]:=",ExpressionUUID->"44d37725-a70a-4e5e-a38a-9c156a87b58f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SortSymMultReverse", "[", "orderingfunc_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{
        RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
        "spin_"}], "]"}], "[", 
      RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"\[CurlyPhi]", ",", "m", ",", "n", ",", "spin"}], "]"}], 
         "[", "\[Phi]", "]"}]}], "]"}], "/;", 
      RowBox[{"Not", "[", 
       RowBox[{"OrderedQ", "[", 
        RowBox[{"orderingfunc", "/@", 
         RowBox[{"{", 
          RowBox[{"\[CurlyPhi]", ",", "\[Phi]"}], "}"}]}], "]"}], "]"}]}]}], 
    ",", 
    RowBox[{
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{
        RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
        "spin_"}], "]"}], "[", 
      RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"ZeroTensorOfTensor", "@", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], "[", 
        "\[Phi]", "]"}]}], "/;", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n"}], ")"}]}], "\[Equal]", 
        RowBox[{"-", "1"}]}], ")"}]}]}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.8449216693548393`*^9},
 CellLabel->
  "In[286]:=",ExpressionUUID->"34ad20b0-80cd-4b88-bb49-ee3722b51147"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymMultToMultScalRule", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "0", ",", "0", ",", 
       "spin_"}], "]"}], "[", 
     RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"MultScal", "[", 
      RowBox[{
       RowBox[{"\[Phi]", "[", "]"}], ",", "\[CurlyPhi]"}], "]"}], "/;", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "\[Phi]", 
        "]"}], "+", 
       RowBox[{
        RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]", 
        "]"}]}], "\[Equal]", "0"}]}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.841226065241753*^9, 3.841226065385736*^9}},
 CellLabel->
  "In[287]:=",ExpressionUUID->"296d17e8-0c78-461f-afd6-3e0c2da54766"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MultScalToSymMultRule", "[", "spin_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Phi]_", "?", "xTensorQ"}], ")"}], "[", "]"}], ",", 
        RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}]}], "]"}], "\[RuleDelayed]", 
      
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
       "\[CurlyPhi]", "]"}]}], ",", 
     RowBox[{
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{"c_", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Phi]_", "?", "xTensorQ"}], ")"}], "[", "]"}]}], ",", 
        RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}]}], "]"}], "\[RuleDelayed]", 
      
      RowBox[{"MultScal", "[", 
       RowBox[{"c", ",", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
         "\[CurlyPhi]", "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{"Plus", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Phi]_", "?", "xTensorQ"}], ")"}], "[", "]"}], ",", 
          "d__"}], "]"}], ",", 
        RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}]}], "]"}], "\[RuleDelayed]", 
      
      RowBox[{"TensorPlus", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
         "\[CurlyPhi]", "]"}], ",", 
        RowBox[{"MultScal", "[", 
         RowBox[{"d", ",", "\[CurlyPhi]"}], "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MultScal", "[", 
       RowBox[{
        RowBox[{"Plus", "[", 
         RowBox[{
          RowBox[{"c_", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"\[Phi]_", "?", "xTensorQ"}], ")"}], "[", "]"}]}], ",", 
          "d__"}], "]"}], ",", 
        RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}]}], "]"}], "\[RuleDelayed]", 
      
      RowBox[{"TensorPlus", "[", 
       RowBox[{
        RowBox[{"MultScal", "[", 
         RowBox[{"c", ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           "\[CurlyPhi]", "]"}]}], "]"}], ",", 
        RowBox[{"MultScal", "[", 
         RowBox[{"d", ",", "\[CurlyPhi]"}], "]"}]}], "]"}]}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8408839386686773`*^9, 3.84088407196362*^9}},
 CellLabel->
  "In[288]:=",ExpressionUUID->"baf7e029-da28-4c8f-8a29-d3e001524f4c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ProductSymmetric", "[", 
   RowBox[{"Ainds_", ",", "Binds_", ",", "ADginds_", ",", "BDginds_"}], "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"VBundles", ",", "SGSlist"}], "}"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{"(*", " ", 
     RowBox[{
     "Compute", " ", "the", " ", "strong", " ", "generating", " ", "sets", 
      " ", "for", " ", "the", " ", "separate", " ", "symmetries"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"VBundles", "=", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"First", "@", 
             RowBox[{"First", "@", 
              RowBox[{"Position", "[", 
               RowBox[{
                RowBox[{"IndexList", "[", 
                 RowBox[{
                  RowBox[{"Sequence", "@@", "Ainds"}], ",", 
                  RowBox[{"Sequence", "@@", "Binds"}], ",", 
                  RowBox[{"Sequence", "@@", "ADginds"}], ",", 
                  RowBox[{"Sequence", "@@", "BDginds"}]}], "]"}], ",", "#", 
                ",", "1"}], "]"}]}]}], "&"}], "/@", "#"}], "&"}], "/@", 
         RowBox[{"{", 
          RowBox[{"Ainds", ",", "Binds", ",", "ADginds", ",", "BDginds"}], 
          "}"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Length", "[", "#", "]"}], "\[GreaterEqual]", "2"}], ")"}],
          "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", "VBundles"}], "\[Equal]", "1"}], ",", 
       RowBox[{"SGSlist", "=", 
        RowBox[{"Symmetric", "/@", "VBundles"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SGSlist", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Symmetric", "[", 
            RowBox[{"#", ",", "Cycles"}], "]"}], "&"}], "/@", "VBundles"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Join", " ", "the", " ", "symmetries"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "SGSlist", "]"}], "\[GreaterEqual]", "2"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"SGSlist", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "=", 
            RowBox[{"JoinSGS", "[", 
             RowBox[{
              RowBox[{"SGSlist", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"SGSlist", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"SGSlist", "=", 
            RowBox[{"Delete", "[", 
             RowBox[{"SGSlist", ",", "1"}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Return", " ", "the", " ", "remaining", " ", "SGS", " ", "or", " ", 
       "the", " ", "trivial", " ", "SGS", " ", "if", " ", "the", " ", "list", 
       " ", "is", " ", 
       RowBox[{"empty", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "SGSlist", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{"First", "@", "SGSlist"}], ",", 
       RowBox[{"StrongGenSet", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", " ", 
         RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[289]:=",ExpressionUUID->"d6658b17-f77d-4457-8dec-4ba6f4c5335c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IrrDecomposeSymMult", "[", 
   RowBox[{
    RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", 
    RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], ",", 
    RowBox[{"{", 
     RowBox[{"p_", ",", "q_"}], "}"}], ",", "spin_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "k", ",", "l", ",", "i", ",", "j", ",", "allinds", ",", "Ainds", ",", 
       "Binds", ",", "Cinds", ",", "ADginds", ",", "BDginds", ",", 
       "CDginds"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j"}], "}"}], "=", 
       RowBox[{"ValenceNumbersOfSpinor", "[", 
        RowBox[{"\[Phi]", ",", "spin"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", "l"}], "}"}], "=", 
       RowBox[{"ValenceNumbersOfSpinor", "[", 
        RowBox[{"\[CurlyPhi]", ",", "spin"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"allinds", "=", 
       RowBox[{"List", "@@", 
        RowBox[{"GiveIndicesToTensor", "@", 
         RowBox[{
          RowBox[{"SymMult", "[", 
           RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
          "\[CurlyPhi]", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ainds", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"allinds", ",", 
         RowBox[{"i", "-", "p"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Binds", "=", 
       RowBox[{"Take", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{"allinds", ",", 
           RowBox[{"i", "-", "p"}]}], "]"}], ",", 
         RowBox[{"k", "-", "p"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Cinds", "=", 
       RowBox[{"Take", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{"allinds", ",", 
           RowBox[{"i", "+", "k", "-", 
            RowBox[{"2", "p"}]}]}], "]"}], ",", "p"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ADginds", "=", 
       RowBox[{"Take", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{"allinds", ",", 
           RowBox[{"i", "+", "k"}]}], "]"}], ",", 
         RowBox[{"j", "-", "q"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"BDginds", "=", 
       RowBox[{"Take", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{"allinds", ",", 
           RowBox[{"i", "+", "k", "+", "j", "-", "q"}]}], "]"}], ",", 
         RowBox[{"l", "-", "q"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"CDginds", "=", 
       RowBox[{"Take", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{"allinds", ",", 
           RowBox[{"i", "+", "k", "+", "j", "+", "l", "-", 
            RowBox[{"2", "q"}]}]}], "]"}], ",", "q"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"xAct`SymManipulator`Private`PlaceIndicesInSpinor", "[", 
         RowBox[{"\[Phi]", ",", 
          RowBox[{"Join", "[", 
           RowBox[{"Ainds", ",", 
            RowBox[{"ChangeIndex", "/@", "Cinds"}], ",", "ADginds", ",", 
            RowBox[{"ChangeIndex", "/@", "CDginds"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"spin", ",", 
            RowBox[{"Dagger", "@", "spin"}]}], "}"}]}], "]"}], 
        RowBox[{"xAct`SymManipulator`Private`PlaceIndicesInSpinor", "[", 
         RowBox[{"\[CurlyPhi]", ",", 
          RowBox[{"Join", "[", 
           RowBox[{"Binds", ",", "Cinds", ",", "BDginds", ",", "CDginds"}], 
           "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"spin", ",", 
            RowBox[{"Dagger", "@", "spin"}]}], "}"}]}], "]"}]}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}]}], 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n"}], ")"}]}], 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{"i", "-", "p"}], ",", 
             RowBox[{"m", "-", "p"}]}], "]"}], 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{"k", "-", "p"}], ",", 
             RowBox[{"m", "-", "p"}]}], "]"}], 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{"j", "-", "q"}], ",", 
             RowBox[{"n", "-", "q"}]}], "]"}], 
           RowBox[{
            RowBox[{
             RowBox[{"Binomial", "[", 
              RowBox[{
               RowBox[{"l", "-", "q"}], ",", 
               RowBox[{"n", "-", "q"}]}], "]"}], "/", 
             RowBox[{"Binomial", "[", 
              RowBox[{
               RowBox[{"i", "+", "k", "-", "m", "-", "p", "+", "1"}], ",", 
               RowBox[{"m", "-", "p"}]}], "]"}]}], "/", 
            RowBox[{"Binomial", "[", 
             RowBox[{
              RowBox[{"j", "+", "l", "-", "n", "-", "q", "+", "1"}], ",", 
              RowBox[{"n", "-", "q"}]}], "]"}]}], "*", 
           RowBox[{"ImposeSym", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"First", "[", 
                  RowBox[{"MetricsOfVBundle", "[", "spin", "]"}], "]"}], "[", 
                 
                 RowBox[{
                  RowBox[{"Ainds", "[", 
                   RowBox[{"[", "r", "]"}], "]"}], ",", 
                  RowBox[{"Binds", "[", 
                   RowBox[{"[", "r", "]"}], "]"}]}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"r", ",", "1", ",", 
                  RowBox[{"m", "-", "p"}]}], "}"}]}], "]"}], "*", 
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"Dagger", "[", 
                  RowBox[{"First", "[", 
                   RowBox[{"MetricsOfVBundle", "[", "spin", "]"}], "]"}], 
                  "]"}], "[", 
                 RowBox[{
                  RowBox[{"ADginds", "[", 
                   RowBox[{"[", "r", "]"}], "]"}], ",", 
                  RowBox[{"BDginds", "[", 
                   RowBox[{"[", "r", "]"}], "]"}]}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"r", ",", "1", ",", 
                  RowBox[{"n", "-", "q"}]}], "}"}]}], "]"}], "*", 
              RowBox[{"xAct`SymManipulator`Private`PlaceIndicesInSpinor", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], 
                 "[", "\[CurlyPhi]", "]"}], ",", 
                RowBox[{"Flatten", "@", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Drop", "[", 
                    RowBox[{"Ainds", ",", 
                    RowBox[{"m", "-", "p"}]}], "]"}], ",", 
                   RowBox[{"Drop", "[", 
                    RowBox[{"Binds", ",", 
                    RowBox[{"m", "-", "p"}]}], "]"}], ",", 
                   RowBox[{"Drop", "[", 
                    RowBox[{"ADginds", ",", 
                    RowBox[{"n", "-", "q"}]}], "]"}], ",", 
                   RowBox[{"Drop", "[", 
                    RowBox[{"BDginds", ",", 
                    RowBox[{"n", "-", "q"}]}], "]"}]}], "}"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"spin", ",", 
                  RowBox[{"Dagger", "@", "spin"}]}], "}"}]}], "]"}]}], ",", 
             RowBox[{"IndexList", "@@", 
              RowBox[{"Flatten", "@", 
               RowBox[{"{", 
                RowBox[{
                "Ainds", ",", "Binds", ",", "ADginds", ",", "BDginds"}], 
                "}"}]}]}], ",", 
             RowBox[{"ProductSymmetric", "[", 
              RowBox[{"Ainds", ",", "Binds", ",", "ADginds", ",", "BDginds"}],
               "]"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"m", ",", "p", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"i", ",", "k"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "q", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"j", ",", "l"}], "]"}]}], "}"}]}], "]"}]}]}]}]}], 
    "\[IndentingNewLine]", "]"}], "/;", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"CompatibleSymQ", "[", 
      RowBox[{
       RowBox[{"SlotsOfTensor", "@", "\[Phi]"}], ",", 
       RowBox[{"SymmetryGroupOfTensor", "@", "\[Phi]"}]}], "]"}], ",", 
     RowBox[{"CompatibleSymQ", "[", 
      RowBox[{
       RowBox[{"SlotsOfTensor", "@", "\[CurlyPhi]"}], ",", 
       RowBox[{"SymmetryGroupOfTensor", "@", "\[CurlyPhi]"}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[290]:=",ExpressionUUID->"b37b9ed8-b374-45d3-9a63-9e5e75822388"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"IrrDecomposeSymMult", "[", 
    RowBox[{"\[Phi]_", ",", " ", "\[CurlyPhi]_", ",", " ", 
     RowBox[{"{", 
      RowBox[{"p_", ",", " ", "q_"}], "}"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"IrrDecomposeSymMult", "[", 
    RowBox[{"\[Phi]", ",", " ", "\[CurlyPhi]", ",", " ", 
     RowBox[{"{", 
      RowBox[{"p", ",", " ", "q"}], "}"}], ",", " ", "$DefaultSpinBundle"}], 
    "]"}]}], ";"}]], "Code",
 CellChangeTimes->{{3.844921595564767*^9, 3.8449216296314297`*^9}},
 CellLabel->
  "In[291]:=",ExpressionUUID->"7b8dc0fb-7054-4bba-b619-327e94278320"]
}, Closed]],

Cell[CellGroupData[{

Cell["Commutation inside derivative", "Subsubsection",
 CellChangeTimes->{{3.838707189208108*^9, 3.838707209994882*^9}, {
  3.8387072507367373`*^9, 3.838707256409544*^9}, {3.9562787372325935`*^9, 
  3.9562787547328644`*^9}},ExpressionUUID->"a16cbeed-3503-434f-aed3-\
d4fa91c9f1c9"],

Cell["MultScal", "Text",
 CellChangeTimes->{{3.956278770580782*^9, 3.956278777383562*^9}, {
  3.956316114588583*^9, 
  3.9563161162740993`*^9}},ExpressionUUID->"879831ce-0f5f-ce40-ab7d-\
0ef12fa806de"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{"MultScal", ",", 
     RowBox[{"op_", "?", "FundSpinOpQ"}]}], "]"}], "^:=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"cd", "=", 
        RowBox[{"CovDOfFundSpinOp", "@", "op"}]}], ",", 
       RowBox[{"spin", "=", 
        RowBox[{
         RowBox[{"VBundlesOfCovD", "[", 
          RowBox[{"CovDOfFundSpinOp", "[", "op", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"divcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`DivName", "@", 
         RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
       RowBox[{"curlcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`CurlName", "@", 
         RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
       RowBox[{"curldgcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", 
         RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
       RowBox[{"twistcd", "=", 
        RowBox[{"xAct`SymManipulator`Private`TwistName", "@", 
         RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{
      "op", ",", "\[IndentingNewLine]", "divcd", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"MultScal", "[", 
          RowBox[{"c_", ",", 
           RowBox[{"divcd", "[", "\[Phi]_", "]"}]}], "]"}], ":>", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"xAct`SymSpin`Private`TwistMultScal", "[", 
                 RowBox[{"cd", ",", "c"}], "]"}], ",", "1", ",", "1", ",", 
                "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
           RowBox[{"divcd", "[", 
            RowBox[{"MultScal", "[", 
             RowBox[{"c", ",", "\[Phi]"}], "]"}], "]"}]}], "]"}]}], "}"}], 
       ",", "\[IndentingNewLine]", "curlcd", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"MultScal", "[", 
          RowBox[{"c_", ",", 
           RowBox[{"curlcd", "[", "\[Phi]_", "]"}]}], "]"}], ":>", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"xAct`SymSpin`Private`TwistMultScal", "[", 
                 RowBox[{"cd", ",", "c"}], "]"}], ",", "0", ",", "1", ",", 
                "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
           RowBox[{"curlcd", "[", 
            RowBox[{"MultScal", "[", 
             RowBox[{"c", ",", "\[Phi]"}], "]"}], "]"}]}], "]"}]}], "}"}], 
       ",", "\[IndentingNewLine]", "curldgcd", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"MultScal", "[", 
          RowBox[{"c_", ",", 
           RowBox[{"curldgcd", "[", "\[Phi]_", "]"}]}], "]"}], ":>", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"xAct`SymSpin`Private`TwistMultScal", "[", 
                 RowBox[{"cd", ",", "c"}], "]"}], ",", "1", ",", "0", ",", 
                "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
           RowBox[{"curldgcd", "[", 
            RowBox[{"MultScal", "[", 
             RowBox[{"c", ",", "\[Phi]"}], "]"}], "]"}]}], "]"}]}], "}"}], 
       ",", "\[IndentingNewLine]", "twistcd", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"MultScal", "[", 
          RowBox[{"c_", ",", 
           RowBox[{"twistcd", "[", "\[Phi]_", "]"}]}], "]"}], ":>", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"xAct`SymSpin`Private`TwistMultScal", "[", 
                 RowBox[{"cd", ",", "c"}], "]"}], ",", "0", ",", "0", ",", 
                "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
           RowBox[{"twistcd", "[", 
            RowBox[{"MultScal", "[", 
             RowBox[{"c", ",", "\[Phi]"}], "]"}], "]"}]}], "]"}]}], "}"}], 
       ",", "\[IndentingNewLine]", "_", ",", 
       RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9563155886369305`*^9, 3.9563156936033497`*^9}, {
  3.956315777402439*^9, 3.956315808467371*^9}, {3.956315934403414*^9, 
  3.9563159739631996`*^9}, {3.9563160208902645`*^9, 3.956316070012903*^9}},
 CellLabel->
  "In[292]:=",ExpressionUUID->"c656688e-5b3b-fa46-a9fc-f05e1a334824"],

Cell["Valence (2, 0)", "Text",
 CellChangeTimes->{{3.956278770580782*^9, 
  3.956278777383562*^9}},ExpressionUUID->"0b6cc421-d2e7-2346-a658-\
0e9794bf6d03"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", " ", "0", ",", " ", "0", ",", 
       " ", "spin_"}], "]"}], ",", 
     RowBox[{"op_", "?", "FundSpinOpQ"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"divcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`DivName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curlcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curldgcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"twistcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`TwistName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
       "op", ",", "\[IndentingNewLine]", "divcd", ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"divcd", "[", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
                 "\[Phi]", "]"}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"2", "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                 RowBox[{"curlcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "/", "3"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curlcd", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"TensorPlus", "[", 
            RowBox[{
             RowBox[{"curlcd", "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}], ",", 
             RowBox[{"MultScal", "[", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{
                RowBox[{"SymMult", "[", 
                 RowBox[{
                  RowBox[{"twistcd", "[", "T", "]"}], ",", "0", ",", "1", ",",
                   "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "0", ",", "1", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curldgcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curldgcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"curldgcd", "[", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
                 "\[Phi]", "]"}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"2", "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                 RowBox[{"twistcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "/", "3"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "twistcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{"TensorPlus", "[", 
           RowBox[{
            RowBox[{"twistcd", "[", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
              "\[Phi]", "]"}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", "1"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"twistcd", "[", "T", "]"}], ",", "0", ",", "0", ",", 
                 "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], 
         "}"}], ",", "\[IndentingNewLine]", "_", ",", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
    RowBox[{
     RowBox[{"xAct`SymSpin`Private`SpinorOfValenceQ", "[", 
      RowBox[{"2", ",", "0", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956203727924774*^9, 3.9562037655263004`*^9}, {
   3.9562038051861515`*^9, 3.956203810577366*^9}, {3.956203876690056*^9, 
   3.9562039261534653`*^9}, {3.956203966513727*^9, 3.956203991173628*^9}, {
   3.9562040706558743`*^9, 3.956204090424515*^9}, {3.956204131665552*^9, 
   3.956204210038622*^9}, {3.956204286622196*^9, 3.956204300757637*^9}, {
   3.9562043983162727`*^9, 3.9562045045778008`*^9}, {3.9562054882097855`*^9, 
   3.956205652282938*^9}, 3.9562058074039*^9, {3.95627786745693*^9, 
   3.956277983087311*^9}, {3.956278080199312*^9, 3.9562781365132084`*^9}, {
   3.9562781775435677`*^9, 3.956278191270876*^9}, {3.956278315920059*^9, 
   3.9562784033853703`*^9}, {3.9562785506876793`*^9, 3.9562785970640545`*^9}},
 
 CellLabel->
  "In[293]:=",ExpressionUUID->"70049b08-9591-8244-a0e9-6d76e82990c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", " ", "1", ",", " ", "0", ",", 
       " ", "spin_"}], "]"}], ",", 
     RowBox[{"op_", "?", "FundSpinOpQ"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"divcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`DivName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curlcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curldgcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"twistcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`TwistName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
       "op", ",", "\[IndentingNewLine]", "divcd", ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", "=", 
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                "\[Phi]", "]"}]}], ",", 
              RowBox[{"l", "=", 
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
                 "]"}]}]}], "}"}], ",", 
            RowBox[{"TensorPlus", "[", 
             RowBox[{
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"k", "^", 
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}]}], ",", 
                RowBox[{"curlcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"divcd", "[", 
               RowBox[{
                RowBox[{"SymMult", "[", 
                 RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
                "\[Phi]", "]"}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", "1"}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"twistcd", "[", "T", "]"}], ",", "2", ",", "1", 
                   ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"Rational", "[", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "3"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"curldgcd", "[", "T", "]"}], ",", "1", ",", "1", 
                   ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "curlcd", 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", "k"}], ")"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{"3", "*", "k"}], "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}]}], ",", 
                 RowBox[{"curlcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ",", 
                 RowBox[{"divcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "+", "k"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"3", "*", "k"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "0", ",", "1", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curldgcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curldgcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"curldgcd", "[", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
                 "\[Phi]", "]"}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"k", "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}], ",", 
                 RowBox[{"twistcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "2", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "3"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "1", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "twistcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", "=", 
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                "\[Phi]", "]"}]}], ",", 
              RowBox[{"l", "=", 
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
                 "]"}]}]}], "}"}], ",", 
            RowBox[{"TensorPlus", "[", 
             RowBox[{
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}]}], ",", 
                RowBox[{"curldgcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "*", 
                   RowBox[{"(", 
                    RowBox[{"3", "+", "k"}], ")"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], ",", 
                RowBox[{"twistcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{"k", "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "0", 
                   ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "+", "k"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   RowBox[{"3", "*", "k"}]}], ")"}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "0", 
                   ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "_", ",", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
    RowBox[{
     RowBox[{"xAct`SymSpin`Private`SpinorOfValenceQ", "[", 
      RowBox[{"2", ",", "0", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956203727924774*^9, 3.9562037655263004`*^9}, {
   3.9562038051861515`*^9, 3.956203810577366*^9}, {3.956203876690056*^9, 
   3.9562039261534653`*^9}, {3.956203966513727*^9, 3.956203991173628*^9}, {
   3.9562040706558743`*^9, 3.956204090424515*^9}, {3.956204131665552*^9, 
   3.956204210038622*^9}, {3.956204286622196*^9, 3.956204300757637*^9}, {
   3.9562043983162727`*^9, 3.9562045045778008`*^9}, {3.9562054882097855`*^9, 
   3.956205652282938*^9}, 3.9562058074039*^9},
 CellLabel->
  "In[294]:=",ExpressionUUID->"75044a23-d9b1-e348-b63e-1c305b893f3a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", " ", "2", ",", " ", "0", ",", 
       " ", "spin_"}], "]"}], ",", 
     RowBox[{"op_", "?", "FundSpinOpQ"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"divcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`DivName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curlcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curldgcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"twistcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`TwistName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
       "op", ",", "\[IndentingNewLine]", "divcd", ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"TensorPlus", "[", 
            RowBox[{
             RowBox[{"divcd", "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}], ",", 
             RowBox[{"MultScal", "[", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{
                RowBox[{"SymMult", "[", 
                 RowBox[{
                  RowBox[{"twistcd", "[", "T", "]"}], ",", "3", ",", "1", ",",
                   "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "3", ",", "1", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curlcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "k", "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                 RowBox[{"curlcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}]}], ",", 
                 RowBox[{"divcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "k"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "2", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"3", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "1", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "2", ",", "1", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curldgcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curldgcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"TensorPlus", "[", 
            RowBox[{
             RowBox[{"curldgcd", "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}], ",", 
             RowBox[{"MultScal", "[", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{
                RowBox[{"SymMult", "[", 
                 RowBox[{
                  RowBox[{"twistcd", "[", "T", "]"}], ",", "3", ",", "0", ",",
                   "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "twistcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "2"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}]}], ",", 
                 RowBox[{"curldgcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
                  RowBox[{"k", "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}], " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                 RowBox[{"twistcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "2", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "k"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "2", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Rational", "[", 
                   RowBox[{"2", ",", "3"}], "]"}], " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "1", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "_", ",", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
    RowBox[{
     RowBox[{"xAct`SymSpin`Private`SpinorOfValenceQ", "[", 
      RowBox[{"2", ",", "0", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956203727924774*^9, 3.9562037655263004`*^9}, {
   3.9562038051861515`*^9, 3.956203810577366*^9}, {3.956203876690056*^9, 
   3.9562039261534653`*^9}, {3.956203966513727*^9, 3.956203991173628*^9}, {
   3.9562040706558743`*^9, 3.956204090424515*^9}, {3.956204131665552*^9, 
   3.956204210038622*^9}, {3.956204286622196*^9, 3.956204300757637*^9}, {
   3.9562043983162727`*^9, 3.9562045045778008`*^9}, {3.9562054882097855`*^9, 
   3.956205652282938*^9}, 3.9562058074039*^9, {3.9562760409179974`*^9, 
   3.95627608191243*^9}, {3.9562761124580555`*^9, 3.9562763236325417`*^9}, {
   3.9562765798058968`*^9, 3.956276583521015*^9}, {3.95627667011475*^9, 
   3.9562766752660713`*^9}, {3.9562767776278057`*^9, 3.9562768002253494`*^9}, 
   3.956276919120655*^9, {3.9563127995232887`*^9, 3.9563128011020603`*^9}},
 CellLabel->
  "In[295]:=",ExpressionUUID->"89946650-f9d9-d44c-819b-52b8572c1471"],

Cell["Valence (1, 1)", "Text",
 CellChangeTimes->{{3.956278770580782*^9, 3.956278777383562*^9}, {
  3.956280026036909*^9, 
  3.956280027876667*^9}},ExpressionUUID->"b694474c-ded1-534b-b5fe-\
aef6baca937f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", " ", "1", ",", " ", "1", ",", 
       " ", "spin_"}], "]"}], ",", 
     RowBox[{"op_", "?", "FundSpinOpQ"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"divcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`DivName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curlcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curldgcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"twistcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`TwistName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
       "op", ",", "\[IndentingNewLine]", "divcd", ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
           RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"TensorPlus", "[", 
            RowBox[{
             RowBox[{"divcd", "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}], ",", 
             RowBox[{"MultScal", "[", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{
                RowBox[{"SymMult", "[", 
                 RowBox[{
                  RowBox[{"twistcd", "[", "T", "]"}], ",", "2", ",", "2", ",",
                   "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "2", ",", "2", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curlcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
           RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", "2"}]}], ",", 
                 RowBox[{"curlcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ",", 
                 RowBox[{"divcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "2", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "+", "k"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{"2", "*", "k"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "2", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "0", ",", "2", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curldgcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
           RowBox[{"curldgcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"l", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], "^", "2"}]}], ",", 
                 RowBox[{"curldgcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ",", 
                 RowBox[{"divcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"l", "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "2", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "+", "l"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{"2", "*", "l"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curlcd", "[", "T", "]"}], ",", "2", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "twistcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], "[", 
           RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", "=", 
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                "\[Phi]", "]"}]}], ",", 
              RowBox[{"l", "=", 
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
                 "]"}]}]}], "}"}], ",", 
            RowBox[{"TensorPlus", "[", 
             RowBox[{
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "*", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "*", "l", "*", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", "2"}], "*", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], "^", "2"}]}], ")"}]}], 
                ",", 
                RowBox[{"twistcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", "2"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}]}], ")"}]}], ",", 
                RowBox[{"curlcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"l", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], "^", "2"}]}], ")"}]}], 
                  ")"}]}], ",", 
                RowBox[{"curldgcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k", "+", "l", "+", 
                   RowBox[{"k", "*", "l"}]}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}]}], ",", 
                RowBox[{"divcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "*", "l"}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k", "+", "l", "+", 
                    RowBox[{"k", "*", "l"}]}], ")"}]}], ")"}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "1", 
                   ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "*", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"curlcd", "[", "T", "]"}], ",", "1", ",", "0", ",",
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "*", "l"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "1", 
                   ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "4"}], "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}]}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"divcd", "[", "T", "]"}], ",", "0", ",", "0", ",", 
                   "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], 
           "]"}]}], "}"}], ",", "\[IndentingNewLine]", "_", ",", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
    RowBox[{
     RowBox[{"xAct`SymSpin`Private`SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956203727924774*^9, 3.9562037655263004`*^9}, {
   3.9562038051861515`*^9, 3.956203810577366*^9}, {3.956203876690056*^9, 
   3.9562039261534653`*^9}, {3.956203966513727*^9, 3.956203991173628*^9}, {
   3.9562040706558743`*^9, 3.956204090424515*^9}, {3.956204131665552*^9, 
   3.956204210038622*^9}, {3.956204286622196*^9, 3.956204300757637*^9}, {
   3.9562043983162727`*^9, 3.9562045045778008`*^9}, {3.9562054882097855`*^9, 
   3.956205652282938*^9}, 3.9562058074039*^9, {3.95627786745693*^9, 
   3.956277983087311*^9}, {3.956278080199312*^9, 3.9562781365132084`*^9}, {
   3.9562781775435677`*^9, 3.956278191270876*^9}, {3.956278315920059*^9, 
   3.9562784033853703`*^9}, {3.9562785506876793`*^9, 
   3.9562785970640545`*^9}, {3.9562789545518055`*^9, 3.956278966713169*^9}, {
   3.9562798727985*^9, 3.9562799497141743`*^9}, 3.9562808342347584`*^9},
 CellLabel->
  "In[296]:=",ExpressionUUID->"e632dd32-3bc1-e345-b519-278236a8af24"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", " ", "1", ",", " ", "0", ",", 
       " ", "spin_"}], "]"}], ",", 
     RowBox[{"op_", "?", "FundSpinOpQ"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"divcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`DivName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curlcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curldgcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"twistcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`TwistName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
       "op", ",", "\[IndentingNewLine]", "divcd", ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "l"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}], ",", 
                 RowBox[{"curldgcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"divcd", "[", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
                 "\[Phi]", "]"}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "2", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curlcd", "[", "T", "]"}], ",", "2", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "2", ",", "1", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curlcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", "2"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}]}], ",", 
                 RowBox[{"twistcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", "2"}]}], ",", 
                 RowBox[{"curlcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k", "+", "l", "+", 
                    RowBox[{"k", "*", "l"}]}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ",", 
                 RowBox[{"curldgcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ",", 
                 RowBox[{"divcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{"k", "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curlcd", "[", "T", "]"}], ",", "1", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "+", "k"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{"2", "*", "k"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "+", "k"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"4", "+", 
                    RowBox[{"4", "*", "k"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"divcd", "[", "T", "]"}], ",", "0", ",", "0", ",",
                     "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "0", ",", "1", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curldgcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curldgcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"TensorPlus", "[", 
            RowBox[{
             RowBox[{"curldgcd", "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}], ",", 
             RowBox[{"MultScal", "[", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{
                RowBox[{"SymMult", "[", 
                 RowBox[{
                  RowBox[{"twistcd", "[", "T", "]"}], ",", "2", ",", "0", ",",
                   "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "twistcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", "=", 
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                "\[Phi]", "]"}]}], ",", 
              RowBox[{"l", "=", 
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
                 "]"}]}]}], "}"}], ",", 
            RowBox[{"TensorPlus", "[", 
             RowBox[{
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "*", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}], "^", "2"}]}], ",", 
                RowBox[{"twistcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}]}], ",", 
                RowBox[{"curldgcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{"k", "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "0", 
                   ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{"2", "*", "k"}]}], ")"}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "0", 
                   ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "_", ",", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
    RowBox[{
     RowBox[{"xAct`SymSpin`Private`SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956203727924774*^9, 3.9562037655263004`*^9}, {
   3.9562038051861515`*^9, 3.956203810577366*^9}, {3.956203876690056*^9, 
   3.9562039261534653`*^9}, {3.956203966513727*^9, 3.956203991173628*^9}, {
   3.9562040706558743`*^9, 3.956204090424515*^9}, {3.956204131665552*^9, 
   3.956204210038622*^9}, {3.956204286622196*^9, 3.956204300757637*^9}, {
   3.9562043983162727`*^9, 3.9562045045778008`*^9}, {3.9562054882097855`*^9, 
   3.956205652282938*^9}, 3.9562058074039*^9, {3.95627786745693*^9, 
   3.956277983087311*^9}, {3.956278080199312*^9, 3.9562781365132084`*^9}, {
   3.9562781775435677`*^9, 3.956278191270876*^9}, {3.956278315920059*^9, 
   3.9562784033853703`*^9}, {3.9562785506876793`*^9, 
   3.9562785970640545`*^9}, {3.9562789545518055`*^9, 3.956278966713169*^9}, {
   3.9562798727985*^9, 3.9562799497141743`*^9}, {3.956280294791849*^9, 
   3.956280325215*^9}, {3.956280372128891*^9, 3.956280373847269*^9}, {
   3.956280579105215*^9, 3.9562806066568584`*^9}, {3.956280768987028*^9, 
   3.956280797845701*^9}, {3.9562814575569706`*^9, 3.956281485368122*^9}, 
   3.956281566843918*^9, {3.9562818014148884`*^9, 3.956281824040428*^9}, {
   3.956303015752426*^9, 3.9563030432012444`*^9}, {3.9563030920480804`*^9, 
   3.9563030967674713`*^9}, {3.956303314352207*^9, 3.956303350570122*^9}},
 CellLabel->
  "In[297]:=",ExpressionUUID->"c52facd9-9466-064b-8c7a-536323b563a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", " ", "0", ",", " ", "1", ",", 
       " ", "spin_"}], "]"}], ",", 
     RowBox[{"op_", "?", "FundSpinOpQ"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"divcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`DivName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curlcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curldgcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"twistcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`TwistName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
       "op", ",", "\[IndentingNewLine]", "divcd", ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
           RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}], ",", 
                 RowBox[{"curlcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"divcd", "[", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
                 "\[Phi]", "]"}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "2", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "2", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "2", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curlcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
           RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"TensorPlus", "[", 
            RowBox[{
             RowBox[{"curlcd", "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
               "\[Phi]", "]"}], "]"}], ",", 
             RowBox[{"MultScal", "[", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{
                RowBox[{"SymMult", "[", 
                 RowBox[{
                  RowBox[{"twistcd", "[", "T", "]"}], ",", "0", ",", "2", ",",
                   "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "0", ",", "2", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curldgcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
           RowBox[{"curldgcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"l", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], "^", "2"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                 RowBox[{"twistcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"l", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], "^", "2"}]}], ",", 
                 RowBox[{"curldgcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k", "+", "l", "+", 
                    RowBox[{"k", "*", "l"}]}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ",", 
                 RowBox[{"curlcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ",", 
                 RowBox[{"divcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"l", "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{"l", "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "+", "l"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{"2", "*", "l"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curlcd", "[", "T", "]"}], ",", "1", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "+", "l"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"4", "+", 
                    RowBox[{"4", "*", "l"}]}], ")"}]}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"divcd", "[", "T", "]"}], ",", "0", ",", "0", ",",
                     "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "twistcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], "[", 
           RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", "=", 
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                "\[Phi]", "]"}]}], ",", 
              RowBox[{"l", "=", 
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
                 "]"}]}]}], "}"}], ",", 
            RowBox[{"TensorPlus", "[", 
             RowBox[{
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"l", "*", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "l"}], ")"}]}], ")"}], "/", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "l"}], ")"}], "^", "2"}]}], ",", 
                RowBox[{"twistcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "l"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}]}], ",", 
                RowBox[{"curlcd", "[", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[",
                   "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{"l", "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"twistcd", "[", "T", "]"}], ",", "0", ",", "1", 
                   ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
              RowBox[{"MultScal", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "+", "l"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{"2", "*", "l"}]}], ")"}]}], ",", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{
                   RowBox[{"curlcd", "[", "T", "]"}], ",", "0", ",", "0", ",",
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}],
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", "_", ",", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
    RowBox[{
     RowBox[{"xAct`SymSpin`Private`SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956203727924774*^9, 3.9562037655263004`*^9}, {
   3.9562038051861515`*^9, 3.956203810577366*^9}, {3.956203876690056*^9, 
   3.9562039261534653`*^9}, {3.956203966513727*^9, 3.956203991173628*^9}, {
   3.9562040706558743`*^9, 3.956204090424515*^9}, {3.956204131665552*^9, 
   3.956204210038622*^9}, {3.956204286622196*^9, 3.956204300757637*^9}, {
   3.9562043983162727`*^9, 3.9562045045778008`*^9}, {3.9562054882097855`*^9, 
   3.956205652282938*^9}, 3.9562058074039*^9, {3.95627786745693*^9, 
   3.956277983087311*^9}, {3.956278080199312*^9, 3.9562781365132084`*^9}, {
   3.9562781775435677`*^9, 3.956278191270876*^9}, {3.956278315920059*^9, 
   3.9562784033853703`*^9}, {3.9562785506876793`*^9, 
   3.9562785970640545`*^9}, {3.9562789545518055`*^9, 3.956278966713169*^9}, {
   3.9562798727985*^9, 3.9562799497141743`*^9}, {3.956280294791849*^9, 
   3.956280325215*^9}, {3.956280372128891*^9, 3.956280373847269*^9}, {
   3.956280579105215*^9, 3.9562806066568584`*^9}, {3.956280768987028*^9, 
   3.956280797845701*^9}, {3.9562814575569706`*^9, 3.956281485368122*^9}, 
   3.956281566843918*^9, {3.9562818014148884`*^9, 3.956281824040428*^9}, {
   3.956303015752426*^9, 3.9563030432012444`*^9}, {3.9563030920480804`*^9, 
   3.9563030967674713`*^9}, {3.956303314352207*^9, 3.956303350570122*^9}, {
   3.9563034196596146`*^9, 3.95630364988509*^9}},
 CellLabel->
  "In[298]:=",ExpressionUUID->"35ca8dc9-3176-9a41-94b1-1be11ded696c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CommuteOp", "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"T_", "?", "xTensorQ"}], ",", " ", "0", ",", "0", ",", " ", 
       "spin_"}], "]"}], ",", 
     RowBox[{"op_", "?", "FundSpinOpQ"}]}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"divcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`DivName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curlcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"curldgcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}], ",", " ", "\n", 
        RowBox[{"twistcd", "=", 
         RowBox[{"xAct`SymManipulator`Private`TwistName", "@", 
          RowBox[{"CovDOfFundSpinOp", "@", "op"}]}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
       "op", ",", "\[IndentingNewLine]", "divcd", ",", "\[IndentingNewLine]", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k", "+", "l", "+", 
                    RowBox[{"k", "*", "l"}]}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}], ",", 
                 RowBox[{"twistcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}], ",", 
                 RowBox[{"curlcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "l"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}], ",", 
                 RowBox[{"curldgcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"divcd", "[", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
                 "\[Phi]", "]"}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curlcd", "[", "T", "]"}], ",", "1", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "4"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"divcd", "[", "T", "]"}], ",", "0", ",", "0", ",",
                     "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "1", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curlcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "l"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}], ",", 
                 RowBox[{"twistcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "0", ",", "1", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"curlcd", "[", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
                 "\[Phi]", "]"}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "0", ",", "1", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curlcd", "[", "T", "]"}], ",", "0", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "0", ",", "1", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "curldgcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"curldgcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                 "\[Phi]", "]"}]}]}], "}"}], ",", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}], ",", 
                 RowBox[{"twistcd", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"T", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                   "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"curldgcd", "[", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
                 "\[Phi]", "]"}], "]"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", "T", "]"}], ",", "1", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
               
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{
                    RowBox[{"curldgcd", "[", "T", "]"}], ",", "0", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], 
              "]"}]}], "]"}], "/;", 
           RowBox[{"EnoughIndsQSpin", "[", 
            RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "twistcd", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
           RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
          RowBox[{"TensorPlus", "[", 
           RowBox[{
            RowBox[{"twistcd", "[", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"T", ",", "0", ",", "0", ",", "spin"}], "]"}], "[", 
              "\[Phi]", "]"}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"-", "1"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{
                 RowBox[{"twistcd", "[", "T", "]"}], ",", "0", ",", "0", ",", 
                 "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], 
         "}"}], ",", "\[IndentingNewLine]", "_", ",", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], "]"}], "/;", 
    RowBox[{
     RowBox[{"xAct`SymSpin`Private`SpinorOfValenceQ", "[", 
      RowBox[{"1", ",", "1", ",", "spin"}], "]"}], "[", "T", "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956203727924774*^9, 3.9562037655263004`*^9}, {
   3.9562038051861515`*^9, 3.956203810577366*^9}, {3.956203876690056*^9, 
   3.9562039261534653`*^9}, {3.956203966513727*^9, 3.956203991173628*^9}, {
   3.9562040706558743`*^9, 3.956204090424515*^9}, {3.956204131665552*^9, 
   3.956204210038622*^9}, {3.956204286622196*^9, 3.956204300757637*^9}, {
   3.9562043983162727`*^9, 3.9562045045778008`*^9}, {3.9562054882097855`*^9, 
   3.956205652282938*^9}, 3.9562058074039*^9, {3.95627786745693*^9, 
   3.956277983087311*^9}, {3.956278080199312*^9, 3.9562781365132084`*^9}, {
   3.9562781775435677`*^9, 3.956278191270876*^9}, {3.956278315920059*^9, 
   3.9562784033853703`*^9}, {3.9562785506876793`*^9, 
   3.9562785970640545`*^9}, {3.9562789545518055`*^9, 3.956278966713169*^9}, {
   3.9562798727985*^9, 3.9562799497141743`*^9}, {3.956280294791849*^9, 
   3.956280325215*^9}, {3.956280372128891*^9, 3.956280373847269*^9}, {
   3.956280579105215*^9, 3.9562806066568584`*^9}, {3.956280768987028*^9, 
   3.956280797845701*^9}, {3.9562814575569706`*^9, 3.956281485368122*^9}, 
   3.956281566843918*^9, {3.9562818014148884`*^9, 3.956281824040428*^9}, {
   3.956303015752426*^9, 3.9563030432012444`*^9}, {3.9563030920480804`*^9, 
   3.9563030967674713`*^9}, {3.956303314352207*^9, 3.956303350570122*^9}, {
   3.9563034196596146`*^9, 3.95630364988509*^9}, {3.9563042956649513`*^9, 
   3.9563043213951874`*^9}, {3.9563046132619305`*^9, 
   3.9563046522230453`*^9}, {3.9563059314623833`*^9, 3.956305936174778*^9}, {
   3.956306006387087*^9, 3.95630603777495*^9}, {3.9563118332609024`*^9, 
   3.956311834860653*^9}, {3.9563120399407177`*^9, 3.956312065870409*^9}},
 CellLabel->
  "In[299]:=",ExpressionUUID->"e8b5ff80-b298-8d49-8827-5ddcfc08e455"]
}, Closed]],

Cell[CellGroupData[{

Cell["SymMultCommutators", "Subsubsection",ExpressionUUID->"1967da8a-3dc9-4b1a-b85e-ce28ece19396"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymMultCoeffFunc", "[", 
    RowBox[{
    "i_Integer", ",", "r_Integer", ",", "k_Integer", ",", "t_Integer", ",", 
     "mm_Integer", ",", "MM_Integer"}], "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "p"}], "+", "t", "+", "q"}], ")"}]}], "*", 
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{"k", "-", "mm"}], ",", "p"}], "]"}], "*", 
          RowBox[{"Binomial", "[", 
           RowBox[{"mm", ",", 
            RowBox[{"MM", "-", "p", "-", "q"}]}], "]"}], "*", 
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{"k", "-", "mm", "-", "p"}], ",", "q"}], "]"}], "*", 
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "mm"}], "+", "r"}], ",", 
            RowBox[{
             RowBox[{"-", "p"}], "+", "t"}]}], "]"}], "*", 
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{"i", "-", "t"}], ",", 
            RowBox[{"MM", "-", "p", "-", "q"}]}], "]"}], "*", 
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], "+", "t"}], ",", "q"}], "]"}]}], ")"}], "/", 
        
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{"1", "+", "i", "+", "k", "-", "MM", "-", "p"}], ",", 
            RowBox[{"MM", "-", "p"}]}], "]"}], "*", 
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{"MM", "-", "p"}], ",", "q"}], "]"}], "*", 
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{"k", "-", 
             RowBox[{"2", "*", "mm"}], "+", "r"}], ",", "t"}], "]"}]}], 
         ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"q", ",", 
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{"MM", "-", "mm", "-", "p"}], ",", 
           RowBox[{"MM", "+", "t", "-", "i", "-", "p"}]}], "]"}], ",", 
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"MM", "-", "p"}], ",", 
           RowBox[{"k", "-", "mm", "-", "p"}], ",", 
           RowBox[{"t", "-", "p"}]}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"Max", "[", 
        RowBox[{"0", ",", 
         RowBox[{"mm", "-", "r", "+", "t"}]}], "]"}], ",", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{"k", "-", "mm"}], ",", "MM", ",", "t"}], "]"}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8407009856231384`*^9, 3.840701000945631*^9}},
 CellLabel->
  "In[300]:=",ExpressionUUID->"1687fae9-f070-47b2-bc8e-9940bd111451"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymMultCoeffFunc", "[", 
    RowBox[{"i_", ",", "r_", ",", "k_", ",", "t_", ",", "mm_", ",", "MM_"}], 
    "]"}], ":=", 
   RowBox[{"FullSimplify", "@", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "t", "+", "q"}], ")"}]}], "*", 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{"k", "-", "mm"}], ",", "p"}], "]"}], "*", 
           RowBox[{"Binomial", "[", 
            RowBox[{"mm", ",", 
             RowBox[{"MM", "-", "p", "-", "q"}]}], "]"}], "*", 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{"k", "-", "mm", "-", "p"}], ",", "q"}], "]"}], "*", 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "mm"}], "+", "r"}], ",", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "t"}]}], "]"}], "*", 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{"i", "-", "t"}], ",", 
             RowBox[{"MM", "-", "p", "-", "q"}]}], "]"}], "*", 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "p"}], "+", "t"}], ",", "q"}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{"1", "+", "i", "+", "k", "-", "MM", "-", "p"}], ",", 
             RowBox[{"MM", "-", "p"}]}], "]"}], "*", 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{"MM", "-", "p"}], ",", "q"}], "]"}], "*", 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{"k", "-", 
              RowBox[{"2", "*", "mm"}], "+", "r"}], ",", "t"}], "]"}]}], 
          ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"q", ",", "0", ",", 
          RowBox[{"MM", "-", "p"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"p", ",", "0", ",", "MM"}], "}"}]}], "]"}]}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{3.840701003251464*^9},
 CellLabel->
  "In[301]:=",ExpressionUUID->"291844db-2743-4b39-a352-37b35e5dbb72"],

Cell["\<\
Special case, which is included in the general case, but it might be useful \
for theoretical calculations. This can spoil cases when the other indices are \
out of range, so it is now inactivated.\
\>", "Text",
 CellChangeTimes->{{3.776739726755666*^9, 
  3.776739770124962*^9}},ExpressionUUID->"39aff2ec-aa9f-4e06-9c6e-\
1dd61b5927c8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymMultCoeffFunc", "[", 
    RowBox[{"i_", ",", "r_", ",", "k_", ",", "0", ",", "mm_", ",", "MM_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Binomial", "[", 
       RowBox[{"i", ",", "MM"}], "]"}], " ", 
      RowBox[{"Binomial", "[", 
       RowBox[{"mm", ",", "MM"}], "]"}]}], ")"}], "/", 
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"1", "+", "i", "+", "k", "-", "MM"}], ",", "MM"}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->
  "In[302]:=",ExpressionUUID->"dff99eb0-a0ea-454c-b474-b05fcb475f42"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CommuteSymMultRuleOut", "[", 
   RowBox[{
    RowBox[{"\[Omega]_", "?", "xTensorQ"}], ",", 
    RowBox[{"AllowSame_", ":", "False"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{
        RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "t_", ",", "u_", ",", 
        "spin_"}], "]"}], "[", 
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"\[Omega]", ",", "m_", ",", "n_", ",", "spin_"}], "]"}], "[", 
       
       RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "]"}], 
     "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[Phi]"}]}], ",", 
          RowBox[{"j", "=", 
           RowBox[{
            RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "\[Phi]"}]}],
           ",", 
          RowBox[{"k", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[CurlyPhi]"}]}], ",", 
          RowBox[{"l", "=", 
           RowBox[{
            RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
            "\[CurlyPhi]"}]}], ",", 
          RowBox[{"r", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[Omega]"}]}], ",", 
          RowBox[{"s", "=", 
           RowBox[{
            RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
            "\[Omega]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"NNmin", "=", 
             RowBox[{"Simplify", "@", 
              RowBox[{"Max", "[", 
               RowBox[{"0", ",", 
                RowBox[{"u", "+", "n", "-", "s"}]}], "]"}]}]}], ",", 
            RowBox[{"NNmax", "=", 
             RowBox[{"Simplify", "@", 
              RowBox[{"Min", "[", 
               RowBox[{"j", ",", "l"}], "]"}]}]}], ",", 
            RowBox[{"Mmin", "=", 
             RowBox[{"Simplify", "@", 
              RowBox[{"Max", "[", 
               RowBox[{"0", ",", 
                RowBox[{"t", "+", "m", "-", "r"}]}], "]"}]}]}], ",", 
            RowBox[{"Mmax", "=", 
             RowBox[{"Simplify", "@", 
              RowBox[{"Min", "[", 
               RowBox[{"i", ",", "k"}], "]"}]}]}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"And", "@@", 
             RowBox[{"(", 
              RowBox[{"IntegerQ", "/@", 
               RowBox[{"{", 
                RowBox[{"NNmin", ",", "NNmax", ",", "Mmin", ",", "Mmax"}], 
                "}"}]}], ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"TensorPlus", "@@", 
             RowBox[{"Flatten", "@", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"MultScal", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"SymMultCoeffFunc", "@@", 
                    RowBox[{"(", 
                    RowBox[{"Simplify", "/@", 
                    RowBox[{"{", 
                    RowBox[{
                    "i", ",", "r", ",", "k", ",", "t", ",", "m", ",", "M"}], 
                    "}"}]}], ")"}]}], "*", 
                   RowBox[{"SymMultCoeffFunc", "@@", 
                    RowBox[{"(", 
                    RowBox[{"Simplify", "/@", 
                    RowBox[{"{", 
                    RowBox[{
                    "j", ",", "s", ",", "l", ",", "u", ",", "n", ",", "NN"}], 
                    "}"}]}], ")"}]}]}], ",", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"\[Omega]", ",", 
                    RowBox[{"t", "+", "m", "-", "M"}], ",", 
                    RowBox[{"u", "+", "n", "-", "NN"}], ",", "spin"}], "]"}], 
                   "[", 
                   RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "M", ",", "NN", ",", "spin"}], 
                    "]"}], "[", "\[CurlyPhi]", "]"}], "]"}]}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"M", ",", "Mmin", ",", "Mmax"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"NN", ",", "NNmin", ",", "NNmax"}], "}"}]}], 
               "]"}]}]}], ",", 
            RowBox[{"Throw", "@", 
             RowBox[{"Message", "[", 
              RowBox[{
               RowBox[{"CommuteSymMultRuleOut", "::", "error1"}], ",", 
               "\"\<Can not determine ranges for number of contractions. \
\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"NNmin", ",", "NNmax", ",", "Mmin", ",", "Mmax"}], 
                "}"}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}], "/;", 
      RowBox[{"(", 
       RowBox[{"Or", "[", 
        RowBox[{"AllowSame", ",", 
         RowBox[{"\[Phi]", "=!=", "\[Omega]"}]}], "]"}], ")"}]}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"\[Omega]", ",", "m_", ",", "n_", ",", "spin_"}], "]"}], 
         "[", 
         RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], ",", "t_", ",", 
        "u_", ",", "spin_"}], "]"}], "[", 
      RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[Phi]"}]}], ",", 
          RowBox[{"j", "=", 
           RowBox[{
            RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "\[Phi]"}]}],
           ",", 
          RowBox[{"k", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[CurlyPhi]"}]}], ",", 
          RowBox[{"l", "=", 
           RowBox[{
            RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
            "\[CurlyPhi]"}]}], ",", 
          RowBox[{"r", "=", 
           RowBox[{
            RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
            "\[Omega]"}]}], ",", 
          RowBox[{"s", "=", 
           RowBox[{
            RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
            "\[Omega]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"NNmin", "=", 
             RowBox[{"Simplify", "@", 
              RowBox[{"Max", "[", 
               RowBox[{"0", ",", 
                RowBox[{"u", "+", "n", "-", "s"}]}], "]"}]}]}], ",", 
            RowBox[{"NNmax", "=", 
             RowBox[{"Simplify", "@", 
              RowBox[{"Min", "[", 
               RowBox[{"j", ",", "l"}], "]"}]}]}], ",", 
            RowBox[{"Mmin", "=", 
             RowBox[{"Simplify", "@", 
              RowBox[{"Max", "[", 
               RowBox[{"0", ",", 
                RowBox[{"t", "+", "m", "-", "r"}]}], "]"}]}]}], ",", 
            RowBox[{"Mmax", "=", 
             RowBox[{"Simplify", "@", 
              RowBox[{"Min", "[", 
               RowBox[{"i", ",", "k"}], "]"}]}]}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"And", "@@", 
             RowBox[{"(", 
              RowBox[{"IntegerQ", "/@", 
               RowBox[{"{", 
                RowBox[{"NNmin", ",", "NNmax", ",", "Mmin", ",", "Mmax"}], 
                "}"}]}], ")"}]}], ",", 
            RowBox[{"TensorPlus", "@@", 
             RowBox[{"Flatten", "@", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"MultScal", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"t", "+", "u"}], ")"}]}], "*", 
                   RowBox[{"SymMultCoeffFunc", "@@", 
                    RowBox[{"(", 
                    RowBox[{"Simplify", "/@", 
                    RowBox[{"{", 
                    RowBox[{
                    "i", ",", "r", ",", "k", ",", "t", ",", "m", ",", "M"}], 
                    "}"}]}], ")"}]}], "*", 
                   RowBox[{"SymMultCoeffFunc", "@@", 
                    RowBox[{"(", 
                    RowBox[{"Simplify", "/@", 
                    RowBox[{"{", 
                    RowBox[{
                    "j", ",", "s", ",", "l", ",", "u", ",", "n", ",", "NN"}], 
                    "}"}]}], ")"}]}]}], ",", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"\[Omega]", ",", 
                    RowBox[{"t", "+", "m", "-", "M"}], ",", 
                    RowBox[{"u", "+", "n", "-", "NN"}], ",", "spin"}], "]"}], 
                   "[", 
                   RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "M", ",", "NN", ",", "spin"}], 
                    "]"}], "[", "\[CurlyPhi]", "]"}], "]"}]}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"M", ",", "Mmin", ",", "Mmax"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"NN", ",", "NNmin", ",", "NNmax"}], "}"}]}], 
               "]"}]}]}], ",", 
            RowBox[{"Throw", "@", 
             RowBox[{"Message", "[", 
              RowBox[{
               RowBox[{"CommuteSymMultRuleOut", "::", "error1"}], ",", 
               "\"\<Can not determine ranges for number of contractions. \
\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"NNmin", ",", "NNmax", ",", "Mmin", ",", "Mmax"}], 
                "}"}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}], "/;", 
      RowBox[{"(", 
       RowBox[{"Or", "[", 
        RowBox[{"AllowSame", ",", 
         RowBox[{"\[Phi]", "=!=", "\[Omega]"}]}], "]"}], ")"}]}]}]}], 
   "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.840703080243738*^9, 3.840703156052884*^9}, {
   3.956811279334772*^9, 3.956811299026129*^9}, 3.957365239201639*^9, {
   3.9573652741452236`*^9, 3.9573652748164616`*^9}, {3.957365326321764*^9, 
   3.9573654247047234`*^9}, {3.9573654935678997`*^9, 3.957365588618391*^9}, {
   3.957365661610256*^9, 3.957365776330038*^9}, {3.957365828886793*^9, 
   3.957365859273531*^9}, {3.9573658948653812`*^9, 3.957365957986786*^9}, {
   3.957365994649805*^9, 3.957365999726204*^9}, {3.9573660969910526`*^9, 
   3.9573661455005264`*^9}, 3.9573661773763084`*^9, {3.9573662347898254`*^9, 
   3.957366290098852*^9}, {3.9573663544019737`*^9, 3.957366390121456*^9}, {
   3.9573664266599464`*^9, 3.957366444812639*^9}, {3.957366502306938*^9, 
   3.9573665389001102`*^9}, {3.959651829236168*^9, 3.9596518501631947`*^9}, {
   3.959651888907564*^9, 
   3.959651967338812*^9}},ExpressionUUID->"7eb921bb-d411-4112-8457-\
53870fb4dfbb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CommuteSymMultRuleIn", "[", 
   RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{"\[Phi]", ",", "t_", ",", "u_", ",", "spin_"}], "]"}], "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{
       RowBox[{"\[Omega]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
       "spin_"}], "]"}], "[", 
     RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "]"}], 
   "\[RuleDelayed]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "=", 
        RowBox[{
         RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "\[Phi]"}]}], 
       ",", 
       RowBox[{"j", "=", 
        RowBox[{
         RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "\[Phi]"}]}], 
       ",", 
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
         "\[CurlyPhi]"}]}], ",", 
       RowBox[{"l", "=", 
        RowBox[{
         RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
         "\[CurlyPhi]"}]}], ",", 
       RowBox[{"r", "=", 
        RowBox[{
         RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
         "\[Omega]"}]}], ",", 
       RowBox[{"s", "=", 
        RowBox[{
         RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
         "\[Omega]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NNmax", "=", 
          RowBox[{"Simplify", "@", 
           RowBox[{"Min", "[", 
            RowBox[{"j", ",", "l"}], "]"}]}]}], ",", 
         RowBox[{"Mmax", "=", 
          RowBox[{"Simplify", "@", 
           RowBox[{"Min", "[", 
            RowBox[{"i", ",", "k"}], "]"}]}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"And", "@@", 
          RowBox[{"(", 
           RowBox[{"IntegerQ", "/@", 
            RowBox[{"{", 
             RowBox[{"NNmax", ",", "Mmax"}], "}"}]}], ")"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "@@", 
          RowBox[{"Flatten", "@", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"MultScal", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"SymMultCoeffFunc", "@@", 
                 RowBox[{"(", 
                  RowBox[{"Simplify", "/@", 
                   RowBox[{"{", 
                    RowBox[{
                    "i", ",", "r", ",", "k", ",", "t", ",", "m", ",", "M"}], 
                    "}"}]}], ")"}]}], "*", 
                RowBox[{"SymMultCoeffFunc", "@@", 
                 RowBox[{"(", 
                  RowBox[{"Simplify", "/@", 
                   RowBox[{"{", 
                    RowBox[{
                    "j", ",", "s", ",", "l", ",", "u", ",", "n", ",", "NN"}], 
                    "}"}]}], ")"}]}]}], ",", 
               RowBox[{
                RowBox[{"SymMult", "[", 
                 RowBox[{"\[Omega]", ",", 
                  RowBox[{"t", "+", "m", "-", "M"}], ",", 
                  RowBox[{"u", "+", "n", "-", "NN"}], ",", "spin"}], "]"}], 
                "[", 
                RowBox[{
                 RowBox[{"SymMult", "[", 
                  RowBox[{"\[Phi]", ",", "M", ",", "NN", ",", "spin"}], "]"}],
                  "[", "\[CurlyPhi]", "]"}], "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"M", ",", "0", ",", "Mmax"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"NN", ",", "0", ",", "NNmax"}], "}"}]}], "]"}]}]}], ",", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"CommuteSymMultRuleIn", "::", "error1"}], ",", 
            "\"\<Can not determine ranges for number of contractions. \>\"", 
            ",", 
            RowBox[{"{", 
             RowBox[{"NNmax", ",", "Mmax"}], "}"}]}], "]"}]}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8407030030743876`*^9, 3.840703048651921*^9}, {
  3.9568113074336567`*^9, 3.9568113088414803`*^9}, {3.957366707133795*^9, 
  3.9573668947501335`*^9}},
 CellLabel->
  "In[304]:=",ExpressionUUID->"33ed3a4e-61af-4962-a710-d9c36674f030"],

Cell["\<\
The following rules should probably not be in the rules at the moment.\
\>", "Text",
 CellChangeTimes->{{3.8378375091484275`*^9, 
  3.837837562964554*^9}},ExpressionUUID->"0cf773fb-cfd4-4b99-8305-\
f4a35eea62b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CommuteSymMultRuleOutSame", "[", 
   RowBox[{"\[Omega]_", "?", "xTensorQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{"\[Omega]", ",", "t_", ",", "u_", ",", "spin_"}], "]"}], "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"\[Omega]", ",", "m_", ",", "n_", ",", "spin_"}], "]"}], "[", 
     RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "]"}], 
   "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
         "\[CurlyPhi]"}]}], ",", 
       RowBox[{"l", "=", 
        RowBox[{
         RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
         "\[CurlyPhi]"}]}], ",", 
       RowBox[{"r", "=", 
        RowBox[{
         RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
         "\[Omega]"}]}], ",", 
       RowBox[{"s", "=", 
        RowBox[{
         RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", 
         "\[Omega]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"TensorPlus", "@@", 
      RowBox[{"Flatten", "@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"MultScal", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SymMultCoeffFunc", "[", 
             RowBox[{"r", ",", "r", ",", "k", ",", "t", ",", "m", ",", "M"}], 
             "]"}], 
            RowBox[{"SymMultCoeffFunc", "[", 
             RowBox[{"s", ",", "s", ",", "l", ",", "u", ",", "n", ",", "NN"}],
              "]"}]}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"\[Omega]", ",", 
              RowBox[{"t", "+", "m", "-", "M"}], ",", 
              RowBox[{"u", "+", "n", "-", "NN"}], ",", "spin"}], "]"}], "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"\[Omega]", ",", "M", ",", "NN", ",", "spin"}], "]"}], 
             "[", "\[CurlyPhi]", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"M", ",", 
           RowBox[{"Max", "[", 
            RowBox[{"0", ",", 
             RowBox[{"t", "+", "m", "-", "r"}]}], "]"}], ",", 
           RowBox[{"Min", "[", 
            RowBox[{"r", ",", "k"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"NN", ",", 
           RowBox[{"Max", "[", 
            RowBox[{"0", ",", 
             RowBox[{"u", "+", "n", "-", "s"}]}], "]"}], ",", 
           RowBox[{"Min", "[", 
            RowBox[{"s", ",", "l"}], "]"}]}], "}"}]}], "]"}]}]}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7767443416703835`*^9, 3.776744443867754*^9}, {
   3.776744778723261*^9, 3.7767447983238773`*^9}, 3.776748202644552*^9, {
   3.837849271946581*^9, 3.837849293833271*^9}},
 CellLabel->
  "In[305]:=",ExpressionUUID->"5ebb05f5-d3d2-49a7-9f1e-5574ef6faf34"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CommuteSymMultRuleOutSameAdv", "[", 
   RowBox[{"\[Omega]_", "?", "xTensorQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"SymMult", "[", 
     RowBox[{"\[Omega]", ",", "t_", ",", "u_", ",", "spin_"}], "]"}], "[", 
    RowBox[{
     RowBox[{"SymMult", "[", 
      RowBox[{"\[Omega]", ",", "m_", ",", "n_", ",", "spin_"}], "]"}], "[", 
     RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], "]"}], 
   "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tmpeq1", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"SymMult", "[", 
           RowBox[{"\[Omega]", ",", "t", ",", "u", ",", "spin"}], "]"}], "[", 
          
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"\[Omega]", ",", "m", ",", "n", ",", "spin"}], "]"}], "[",
            "\[CurlyPhi]", "]"}], "]"}], "==", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"\[Omega]", ",", "t", ",", "u", ",", "spin"}], "]"}], 
            "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"\[Omega]", ",", "m", ",", "n", ",", "spin"}], "]"}], 
             "[", "\[CurlyPhi]", "]"}], "]"}], "/.", 
           RowBox[{"CommuteSymMultRuleOutSame", "[", "\[Omega]", "]"}]}], 
          ")"}]}]}], ",", "tmpeq2"}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"tmpeq1", "===", "True"}], ",", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"\[Omega]", ",", "t", ",", "u", ",", "spin"}], "]"}], "[", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"\[Omega]", ",", "m", ",", "n", ",", "spin"}], "]"}], "[", 
         "\[CurlyPhi]", "]"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tmpeq2", "=", 
         RowBox[{"IsolateTensorPlus", "[", "tmpeq1", "]"}]}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"\[Omega]", ",", "t", ",", "u", ",", "spin"}], "]"}], 
            "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"\[Omega]", ",", "m", ",", "n", ",", "spin"}], "]"}], 
             "[", "\[CurlyPhi]", "]"}], "]"}], "===", 
           RowBox[{"tmpeq2", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"tmpeq2", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{"\[Omega]", ",", "t", ",", "u", ",", "spin"}], "]"}], "[", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"\[Omega]", ",", "m", ",", "n", ",", "spin"}], "]"}], 
            "[", "\[CurlyPhi]", "]"}], "]"}]}], "]"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7767483676721487`*^9, 3.7767485335896854`*^9}, {
  3.776748623082802*^9, 3.7767486233485146`*^9}, {3.776748682176774*^9, 
  3.776748745118354*^9}, {3.776748949387283*^9, 3.7767489505593257`*^9}, {
  3.7767491945775523`*^9, 3.776749273160883*^9}, {3.776749362788561*^9, 
  3.776749371416293*^9}, {3.7767494383081636`*^9, 3.7767494634434896`*^9}, {
  3.776749586649922*^9, 3.7767495891695213`*^9}, {3.837849298836543*^9, 
  3.837849349932366*^9}},
 CellLabel->
  "In[306]:=",ExpressionUUID->"0a39a591-f0f2-4d64-bd8f-d3602e818f2b"]
}, Closed]],

Cell[CellGroupData[{

Cell["GHPComponentRules of SymMult, MultScal, ToGHPComponents", \
"Subsubsection",
 CellChangeTimes->{{3.837837660406247*^9, 3.8378376705660815`*^9}, {
  3.83869858656383*^9, 3.8386985904245777`*^9}, {3.838784402279729*^9, 
  3.8387844036913643`*^9}, {3.8388811822361383`*^9, 
  3.838881182954887*^9}},ExpressionUUID->"c831cb9a-b90b-4dfe-a973-\
92eb8883f25b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GHPComponentRules", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{
        RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "m_", ",", "n_", ",", 
        "spin_"}], "]"}], "[", 
      RowBox[{"\[CurlyPhi]_", "?", "xTensorQ"}], "]"}], ",", "dyad_"}], "]"}],
    ":=", 
   RowBox[{
    RowBox[{"GHPComponentRules", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], "[", 
       "\[CurlyPhi]", "]"}], ",", "dyad"}], "]"}], "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"s", ",", "r", ",", "t", ",", "u", ",", "p", ",", "q", ",", 
        RowBox[{"i", "=", 
         RowBox[{
          RowBox[{"NumOfUnprimedSlotsDyad", "[", "dyad", "]"}], "@", 
          "\[Phi]"}]}], ",", 
        RowBox[{"j", "=", 
         RowBox[{
          RowBox[{"NumOfPrimedSlotsDyad", "[", "dyad", "]"}], "@", 
          "\[Phi]"}]}], ",", 
        RowBox[{"k", "=", 
         RowBox[{
          RowBox[{"NumOfUnprimedSlotsDyad", "[", "dyad", "]"}], "@", 
          "\[CurlyPhi]"}]}], ",", 
        RowBox[{"l", "=", 
         RowBox[{
          RowBox[{"NumOfPrimedSlotsDyad", "[", "dyad", "]"}], "@", 
          "\[CurlyPhi]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"xAct`SpinFrames`SetGHPWeightAndFormatSymmetric", "[", 
        RowBox[{"\[CurlyPhi]", ",", "dyad"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xAct`SpinFrames`SetGHPWeightAndFormatSymmetric", "[", 
        RowBox[{"\[Phi]", ",", "dyad"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"xAct`SpinFrames`SetGHPWeightAndFormatSymmetric", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"SymMult", "[", 
           RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], "[", 
          "\[CurlyPhi]", "]"}], ",", "dyad"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"$DyadCalcInfo", ",", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<Calculating the \>\"", ",", "dyad", ",", 
           "\"\<components of \>\"", ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], "]"}], "[", 
            "\[CurlyPhi]", "]"}], ",", 
           "\"\< in GHP form. (Improved code)\>\""}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Expand", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Expand", "[", 
            RowBox[{
             RowBox[{"Flatten", "[", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "xAct`SpinFrames`DyadComponentByNumberSymmetric", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "m", ",", "n", ",", "spin"}], 
                    "]"}], "[", "\[CurlyPhi]", "]"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"s", ",", "t"}], "}"}], ",", "dyad"}], "]"}], 
                 "\[Rule]", 
                 RowBox[{"Sum", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Sum", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", "p"}], "*", 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"i", ",", "r"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"i", "-", "r"}], ",", "p"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"r", ",", 
                    RowBox[{"m", "-", "p"}]}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"k", ",", 
                    RowBox[{"s", "+", "m", "-", "r"}]}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"k", "-", "s", "-", "m", "+", "r"}], ",", 
                    RowBox[{"m", "-", "p"}]}], "]"}], 
                    RowBox[{
                    RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"s", "+", "m", "-", "r"}], ",", "p"}], "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Binomial", "[", 
                    RowBox[{"i", ",", "m"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"k", ",", "m"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"m", ",", "p"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"i", "+", "k", "-", 
                    RowBox[{"2", "m"}]}], ",", "s"}], "]"}]}], ")"}]}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"p", ",", "0", ",", "m"}], "}"}]}], "]"}], 
                    RowBox[{"Sum", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", "q"}], "*", 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"j", ",", "u"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"j", "-", "u"}], ",", "q"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"n", "-", "q"}]}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"l", ",", 
                    RowBox[{"t", "+", "n", "-", "u"}]}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"l", "-", "t", "-", "n", "+", "u"}], ",", 
                    RowBox[{"n", "-", "q"}]}], "]"}], 
                    RowBox[{
                    RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"t", "+", "n", "-", "u"}], ",", "q"}], "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Binomial", "[", 
                    RowBox[{"j", ",", "n"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"l", ",", "n"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{"n", ",", "q"}], "]"}], 
                    RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"j", "+", "l", "-", 
                    RowBox[{"2", "n"}]}], ",", "t"}], "]"}]}], ")"}]}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"q", ",", "0", ",", "n"}], "}"}]}], "]"}], 
                    RowBox[{
                    "xAct`SpinFrames`DyadComponentByNumberSymmetric", "[", 
                    RowBox[{"\[Phi]", ",", 
                    RowBox[{"{", 
                    RowBox[{"r", ",", "u"}], "}"}], ",", "dyad"}], "]"}], 
                    RowBox[{
                    "xAct`SpinFrames`DyadComponentByNumberSymmetric", "[", 
                    RowBox[{"\[CurlyPhi]", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"s", "+", "m", "-", "r"}], ",", 
                    RowBox[{"t", "+", "n", "-", "u"}]}], "}"}], ",", "dyad"}],
                     "]"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"r", ",", 
                    RowBox[{"s", "+", "m", "-", "k"}], ",", 
                    RowBox[{"s", "+", "m"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"u", ",", 
                    RowBox[{"t", "+", "n", "-", "l"}], ",", 
                    RowBox[{"t", "+", "n"}]}], "}"}]}], "]"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"s", ",", "0", ",", 
                  RowBox[{"i", "+", "k", "-", 
                   RowBox[{"2", "m"}]}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", "0", ",", 
                  RowBox[{"j", "+", "l", "-", 
                   RowBox[{"2", "n"}]}]}], "}"}]}], "]"}], "]"}], "//.", 
             "$GHPExtraRules"}], "]"}], "/.", 
           RowBox[{"GHPComponentRules", "[", 
            RowBox[{"\[Phi]", ",", "dyad"}], "]"}]}], "/.", 
          RowBox[{"GHPComponentRules", "[", 
           RowBox[{"\[CurlyPhi]", ",", "dyad"}], "]"}]}], "//.", 
         "$GHPExtraRules"}], "]"}]}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8449295985878663`*^9, 3.8449296203644295`*^9}},
 CellLabel->
  "In[307]:=",ExpressionUUID->"528dc62e-6c84-4023-9ed1-8f5002384bad"],

Cell["Old code used when MultScal was not expanded automatically.", "Text",
 CellChangeTimes->{{3.891600592033225*^9, 
  3.891600637727313*^9}},ExpressionUUID->"0bb76bed-e137-4a09-9967-\
7d6a5757b826"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GHPComponentRules", "[", 
    RowBox[{
     RowBox[{"lhs", ":", 
      RowBox[{"(", 
       RowBox[{"MultScal", "[", 
        RowBox[{"s_", ",", 
         RowBox[{"\[Phi]_", "?", "xTensorQ"}]}], "]"}], ")"}]}], ",", 
     "dyad_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"GHPComponentRules", "[", 
     RowBox[{"lhs", ",", "dyad"}], "]"}], "=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"k", "=", 
         RowBox[{
          RowBox[{"NumOfUnprimedSlotsDyad", "[", "dyad", "]"}], "@", 
          "lhs"}]}], ",", 
        RowBox[{"l", "=", 
         RowBox[{
          RowBox[{"NumOfPrimedSlotsDyad", "[", "dyad", "]"}], "@", "lhs"}]}], 
        ",", 
        RowBox[{"comps", "=", 
         RowBox[{"xAct`SpinFrames`AllDyadComponentsSymmetric", "[", 
          RowBox[{"lhs", ",", "dyad"}], "]"}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"xAct`SpinFrames`SetGHPWeightAndFormatSymmetric", "[", 
        RowBox[{"lhs", ",", "dyad"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Thread", "[", 
        RowBox[{"comps", "\[Rule]", 
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Expand", "[", 
             RowBox[{"comps", "//.", "$GHPExtraRules"}], "]"}], "/.", 
            RowBox[{"GHPComponentRules", "[", 
             RowBox[{"\[Phi]", ",", "dyad"}], "]"}]}], "//.", 
           "$GHPExtraRules"}], "]"}]}], "]"}]}]}], "]"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{
  3.8400283209056425`*^9, {3.84492962489331*^9, 3.8449296294733095`*^9}},
 CellLabel->
  "In[308]:=",ExpressionUUID->"70b87309-ed89-40f7-8c95-339569af3322"],

Cell["New code. Just pass through.", "Text",
 CellChangeTimes->{{3.891600651769781*^9, 
  3.8916006668547506`*^9}},ExpressionUUID->"ae650a1f-ac74-4497-ba1c-\
14c4629d94e8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GHPComponentRules", "[", 
    RowBox[{
     RowBox[{"lhs", ":", 
      RowBox[{"(", 
       RowBox[{"MultScal", "[", 
        RowBox[{"s_", ",", 
         RowBox[{"\[Phi]_", "?", "xTensorQ"}]}], "]"}], ")"}]}], ",", 
     "dyad_"}], "]"}], ":=", 
   RowBox[{"GHPComponentRules", "[", 
    RowBox[{"\[Phi]", ",", "dyad"}], "]"}]}], ";"}]], "Code",
 CellChangeTimes->{
  3.8400283209056425`*^9, {3.84492962489331*^9, 3.8449296294733095`*^9}, {
   3.8916006887842493`*^9, 3.8916006937758923`*^9}},
 CellLabel->
  "In[309]:=",ExpressionUUID->"f5e2c78b-0038-4da2-a311-52e399fda60b"],

Cell["\<\
ToGHPComponents should make checks that spinors are symmetric etc before it \
calls ToGHPComponents1.\
\>", "Text",
 CellChangeTimes->{
  3.837834459808552*^9},ExpressionUUID->"d3392ac7-80eb-4474-a3e8-\
0a699ae35c2d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToGHPComponents", "[", 
   RowBox[{"expr_", ",", "dyad_"}], "]"}], ":=", 
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{"expr", ",", "dyad"}], "]"}]}]], "Code",
 CellLabel->
  "In[310]:=",ExpressionUUID->"1d7a8f4d-73c3-4685-800a-7d5a83b5cfe0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{
    RowBox[{"0", "\[Equal]", "expr_"}], ",", "dyad_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"0", "\[Equal]", "#"}], "&"}], ")"}], "/@", 
   RowBox[{"ToGHPComponents1", "[", 
    RowBox[{"expr", ",", "dyad"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{
    RowBox[{"expr_", "\[Equal]", "0"}], ",", "dyad_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"#", "\[Equal]", "0"}], "&"}], ")"}], "/@", 
   RowBox[{"ToGHPComponents1", "[", 
    RowBox[{"expr", ",", "dyad"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{"expr_Equal", ",", "dyad_"}], "]"}], ":=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ToGHPComponents1", "[", 
      RowBox[{"#", ",", "dyad"}], "]"}], "&"}], "/@", "expr"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{"expr_Plus", ",", "dyad_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"ToGHPComponents1", "[", 
     RowBox[{"#", ",", "dyad"}], "]"}], "&"}], "/@", 
   "expr"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{"expr_TensorPlus", ",", "dyad_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"ToGHPComponents1", "[", 
     RowBox[{"#", ",", "dyad"}], "]"}], "&"}], "/@", 
   RowBox[{"Plus", "@@", "expr"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{
    RowBox[{"Times", "[", 
     RowBox[{
      RowBox[{"c_", "?", "ScalarQ"}], ",", "more__"}], "]"}], ",", "dyad_"}], 
   "]"}], ":=", 
  RowBox[{"Expand", "[", 
   RowBox[{"c", "*", 
    RowBox[{"ToGHPComponents1", "[", 
     RowBox[{
      RowBox[{"Times", "[", "more", "]"}], ",", "dyad"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{
    RowBox[{"MultScal", "[", 
     RowBox[{"s_", ",", 
      RowBox[{"\[Phi]_", "?", "xTensorQ"}]}], "]"}], ",", "dyad_"}], "]"}], ":=", 
  RowBox[{"Expand", "[", 
   RowBox[{"s", "*", 
    RowBox[{"ToGHPComponents1", "[", 
     RowBox[{"\[Phi]", ",", "dyad"}], "]"}]}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8916034545219564`*^9, 3.8916034574421673`*^9}, {
  3.8916035110337963`*^9, 3.8916035114816074`*^9}, {3.8916035640650663`*^9, 
  3.8916035892657394`*^9}},
 CellLabel->
  "In[311]:=",ExpressionUUID->"a16705cf-3329-4272-9313-b0e2b71fb7f3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{
    RowBox[{"\[Phi]_", "?", "xTensorQ"}], ",", "dyad_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"xAct`SpinFrames`SetGHPWeightAndFormatSymmetric", "[", 
      RowBox[{"\[Phi]", ",", "dyad"}], "]"}], ";", 
     RowBox[{"xAct`SpinFrames`AllDyadComponentsSymmetric", "[", 
      RowBox[{"\[Phi]", ",", "dyad"}], "]"}]}], ")"}], "/.", 
   RowBox[{"GHPComponentRules", "[", 
    RowBox[{"\[Phi]", ",", "dyad"}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8449296353076696`*^9, 3.844929639411709*^9}, {
  3.8916035145533953`*^9, 3.8916035270181646`*^9}, {3.891603562490244*^9, 
  3.8916035702016273`*^9}},
 CellLabel->
  "In[318]:=",ExpressionUUID->"819a7949-7aa3-420e-98c5-73b17e4424df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToGHPComponents1", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Phi]_", "?", "xTensorQ"}], "[", "inds___", "]"}], ",", 
    "dyad_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"xAct`SpinFrames`SetGHPWeightAndFormatSymmetric", "[", 
      RowBox[{"\[Phi]", ",", "dyad"}], "]"}], ";", 
     RowBox[{"xAct`SpinFrames`AllDyadComponentsSymmetric", "[", 
      RowBox[{"\[Phi]", ",", "dyad"}], "]"}]}], ")"}], "/.", 
   RowBox[{"GHPComponentRules", "[", 
    RowBox[{"\[Phi]", ",", "dyad"}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8449296436836934`*^9, 3.8449296482654076`*^9}},
 CellLabel->
  "In[319]:=",ExpressionUUID->"f386251e-e590-47e0-a0c1-a268ba45e1c0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Extracting spinor coefficients", "Subsubsection",
 CellChangeTimes->{{3.863077658315585*^9, 
  3.8630776702865777`*^9}},ExpressionUUID->"1f9007b9-9c3f-400a-9035-\
0426c2b79ac8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtractSymMultCoeff", "[", 
   RowBox[{"expr_", ",", "spinor_", ",", 
    RowBox[{"spin_", ":", "$DefaultSpinBundle"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"sortedexpr", "=", 
       RowBox[{"expr", "//.", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"SortSymMult", "[", 
           RowBox[{
            RowBox[{"#", "=!=", "spinor"}], "&"}], "]"}], ",", 
          RowBox[{"CommuteSymMultRuleOut", "[", "spinor", "]"}]}], "]"}]}]}], 
      ",", "extractedcoeffs"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"extractedcoeffs", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"ExtractSymMultCoeffFromTerm", "[", 
         RowBox[{"#", ",", "spinor", ",", "spin"}], "]"}], "&"}], "/@", 
       RowBox[{"TensorPlusToList", "[", "sortedexpr", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"TensorPlus", "@@", 
      RowBox[{"SortBy", "[", 
       RowBox[{"extractedcoeffs", ",", "TensorPlusSortFunc"}], "]"}]}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8447625688209076`*^9, 3.844762685107862*^9}, {
   3.844762741631996*^9, 3.844762743966589*^9}, {3.844762776680087*^9, 
   3.844762790967515*^9}, {3.84476295361071*^9, 3.844763037491379*^9}, {
   3.84476316055114*^9, 3.8447632254919367`*^9}, {3.8447633047048535`*^9, 
   3.84476332325309*^9}, {3.8447635990127716`*^9, 3.844763600164647*^9}, {
   3.844763638913803*^9, 3.8447636451960444`*^9}, {3.8447640034624376`*^9, 
   3.844764011154871*^9}, {3.844764337152776*^9, 3.844764400712788*^9}, {
   3.8447644911078978`*^9, 3.8447644943015547`*^9}, {3.844764589218465*^9, 
   3.8447645922710204`*^9}, {3.8447693051414127`*^9, 3.844769317061671*^9}, {
   3.8447694017912693`*^9, 3.8447694175140824`*^9}, {3.844771804616289*^9, 
   3.844771892213605*^9}, {3.8447720208770485`*^9, 3.8447720359106627`*^9}, 
   3.8447721052130013`*^9, {3.8447722159551144`*^9, 3.8447722207578526`*^9}, 
   3.8447723005009956`*^9, {3.8447731208556595`*^9, 3.8447731703464174`*^9}, {
   3.8447741163433714`*^9, 3.844774118016585*^9}, 3.8630783194328117`*^9, {
   3.863162445438159*^9, 3.8631624613122025`*^9}},
 CellLabel->
  "In[320]:=",ExpressionUUID->"4a6164a3-2d6c-4952-b17c-f28f6d806f14"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExtractSymMultCoeffFromTerm", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{"spinor_", ",", "__"}], "]"}], "[", "expr_", "]"}], ",", 
     "spinor_", ",", "spin_"}], "]"}], ":=", "expr"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtractSymMultCoeffFromTerm", "[", 
    RowBox[{
     RowBox[{"MultScal", "[", 
      RowBox[{"a_", ",", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"spinor_", ",", "__"}], "]"}], "[", "expr_", "]"}]}], "]"}], 
     ",", "spinor_", ",", "spin_"}], "]"}], ":=", 
   RowBox[{"MultScal", "[", 
    RowBox[{"a", ",", "expr"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExtractSymMultCoeffFromTerm", "[", 
   RowBox[{"expr_", ",", "spinor_", ",", "spin_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"ZeroTensor", "@", 
    RowBox[{"SymmetricOfValence", "[", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ValenceNumbersOfSpinor", "[", 
          RowBox[{"spinor", ",", "spin"}], "]"}], "-", 
         RowBox[{"ValenceNumbersOfSpinor", "[", 
          RowBox[{"expr", ",", "spin"}], "]"}]}], ")"}]}], ",", "spin"}], 
     "]"}]}], "/;", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"expr", ",", "spinor"}], "]"}]}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8447634679170837`*^9, 3.8447634762601624`*^9}, {
  3.8447635214300056`*^9, 3.8447635817220755`*^9}, {3.844763626154541*^9, 
  3.8447636340094967`*^9}, {3.8447636770629177`*^9, 3.844763703358897*^9}, {
  3.8447637905887403`*^9, 3.8447638116229115`*^9}, {3.8447639313845015`*^9, 
  3.8447639689380784`*^9}, {3.84476453500712*^9, 3.8447645391730103`*^9}, {
  3.8447645726107664`*^9, 3.8447645733266945`*^9}, {3.8447646619671316`*^9, 
  3.8447646641889176`*^9}, {3.8447723032929535`*^9, 3.844772367034657*^9}, {
  3.8447725225420303`*^9, 3.844772523360282*^9}, {3.844772586982847*^9, 
  3.844772588492653*^9}, {3.8447728360477333`*^9, 3.8447728663272657`*^9}, {
  3.844773286859665*^9, 3.8447732944648666`*^9}, {3.8447740916418314`*^9, 
  3.844774094842328*^9}, {3.86316211142422*^9, 3.86316214306225*^9}, {
  3.8631624033192234`*^9, 3.863162436821116*^9}},
 CellLabel->
  "In[321]:=",ExpressionUUID->"9ad18cd0-131a-49ff-860d-71d188235228"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RemoveMultscalCoeff", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"a_", ",", "expr_"}], "]"}], "]"}], ":=", "expr"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveMultscalCoeff", "[", "expr_", "]"}], ":=", "expr"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8447680942617645`*^9, 3.8447681260555477`*^9}},
 CellLabel->
  "In[324]:=",ExpressionUUID->"b12d80fa-09e0-4c37-8e50-7f399a61188a"],

Cell["\<\
Given an index free expression, this function extracts the irreducible \
coefficients of a specified field. ( This is still experimental. )\
\>", "Text",
 CellChangeTimes->{{3.8620300800912323`*^9, 3.8620300901762238`*^9}, {
  3.8620301312804613`*^9, 3.862030172817645*^9}, {3.8620302945284123`*^9, 
  3.8620303467049217`*^9}, {3.863078940368293*^9, 3.8630790262882924`*^9}, {
  3.8630793441622744`*^9, 
  3.863079344679889*^9}},ExpressionUUID->"31288d3d-d5e9-4e7d-ae53-\
382139edad58"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtractCoeffsIndexFree", "[", 
   RowBox[{
    RowBox[{"expr_", "?", "xTensorQ"}], ",", 
    RowBox[{"field_", "?", "xTensorQ"}], ",", 
    RowBox[{"spin_", ":", "$DefaultSpinBundle"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "sortedexpr", ",", "exprlist", ",", "TestField", ",", "ExprValence", ",",
       "FieldValence", ",", "TestFieldFieldIrrDecParts", ",", 
      "contractedExpr", ",", "extractedcoeffs"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Make", " ", "sure", " ", "that", " ", "\"\<field\>\"", " ", "is", " ", 
      RowBox[{"innermost", "."}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"sortedexpr", "=", 
      RowBox[{"expr", "//.", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"SortSymMult", "[", 
          RowBox[{
           RowBox[{"Not", "@", 
            RowBox[{"FreeQ", "[", 
             RowBox[{"#", ",", "field"}], "]"}]}], "&"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"CommuteSymMultRuleIn", "[", "field", "]"}], "}"}]}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"exprlist", "=", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"TensorPlusToList", "[", "sortedexpr", "]"}], ",", 
        RowBox[{
         RowBox[{"Not", "@", 
          RowBox[{"FreeQ", "[", 
           RowBox[{"#", ",", "field"}], "]"}]}], "&"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ExprValence", "=", 
      RowBox[{"ValenceNumbersOfSpinor", "[", 
       RowBox[{"expr", ",", "spin"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"FieldValence", "=", 
      RowBox[{"ValenceNumbersOfSpinor", "[", 
       RowBox[{"field", ",", "spin"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Constructing", " ", "a", " ", "test", " ", "field", " ", "to", " ", 
       "contract", " ", "away", " ", "all", " ", "free", " ", "indices", " ", 
       "in", " ", 
       RowBox[{"expr", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"TestField", "=", 
      RowBox[{"SymSpinor", "[", 
       RowBox[{
        RowBox[{"Sequence", "@@", "ExprValence"}], ",", "\"\<T\>\"", ",", 
        "spin"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Constructing", " ", "all", " ", "irreducible", " ", "products", " ", 
       "of", " ", "\"\<field\>\"", " ", "and", " ", "the", " ", "test", " ", 
       RowBox[{"field", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"TestFieldFieldIrrDecParts", "=", 
      RowBox[{"Flatten", "@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"SymMult", "[", 
           RowBox[{"TestField", ",", "i", ",", "j"}], "]"}], "@", "field"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", 
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"ExprValence", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"FieldValence", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", 
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"ExprValence", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"FieldValence", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}]}], "]"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Contracting", " ", "the", " ", "expression", " ", "with", " ", "the", 
       " ", "test", " ", "field", " ", "to", " ", "get", " ", "a", " ", 
       "scalar", " ", 
       RowBox[{"expression", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"contractedExpr", "=", 
      RowBox[{"TensorPlus", "@@", 
       RowBox[{
        RowBox[{"SymMult", "[", 
         RowBox[{"TestField", ",", 
          RowBox[{"Sequence", "@@", "ExprValence"}]}], "]"}], "/@", 
        "exprlist"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Commute", " ", "the", " ", "thestfield", " ", 
       RowBox[{"inside", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"contractedExpr", "=", 
      RowBox[{"contractedExpr", "//.", 
       RowBox[{"CommuteSymMultRuleIn", "[", "TestField", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Return", " ", "a", " ", "list", " ", "of", " ", "extracted", " ", 
       RowBox[{"coefficients", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"ExtractSymMultCoeff", "[", 
        RowBox[{"contractedExpr", ",", "#", ",", "spin"}], "]"}], "&"}], "/@",
       "TestFieldFieldIrrDecParts"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8620282064024324`*^9, 3.862028414641057*^9}, {
   3.8620284885293055`*^9, 3.8620285375258064`*^9}, {3.862028573472484*^9, 
   3.8620287716888113`*^9}, {3.8620289075530443`*^9, 
   3.8620289312733107`*^9}, {3.8620289621382647`*^9, 
   3.8620290356751957`*^9}, {3.862029096882039*^9, 3.8620291044046144`*^9}, {
   3.862029315686637*^9, 3.862029367263936*^9}, {3.862029420152933*^9, 
   3.862029423564818*^9}, {3.862029580088725*^9, 3.862029580274229*^9}, {
   3.862029641993687*^9, 3.862029693249235*^9}, {3.862029894471264*^9, 
   3.862029946705083*^9}, {3.862030635897068*^9, 3.862030692017867*^9}, {
   3.8630785359445925`*^9, 3.863078614552144*^9}, {3.863078747737042*^9, 
   3.8630788082174044`*^9}, {3.863078865062442*^9, 3.863078889845292*^9}, {
   3.863078932174128*^9, 3.8630789348809633`*^9}, 3.8630790385205865`*^9, {
   3.863079176001111*^9, 3.8630792697045574`*^9}, {3.86307931064911*^9, 
   3.8630793357527575`*^9}, {3.8630802153857265`*^9, 
   3.8630802560985703`*^9}, {3.8630802891850824`*^9, 
   3.8630802970415144`*^9}, {3.8630803335372496`*^9, 3.863080366056907*^9}, {
   3.863080397168705*^9, 3.8630804338328385`*^9}, {3.8631618143292007`*^9, 
   3.8631618343490543`*^9}, {3.863162474264429*^9, 3.8631624751306076`*^9}, 
   3.8631625450431013`*^9},
 CellLabel->
  "In[326]:=",ExpressionUUID->"2697fbf4-e3c5-4ea2-9d22-fe6083c835d0"],

Cell["\<\
The same, but given an index free equation instead. This returns a list of \
non-trivial equations. \
\>", "Text",
 CellChangeTimes->{{3.8620303591325626`*^9, 
  3.862030425112667*^9}},ExpressionUUID->"1cba11fb-7c67-4068-a683-\
04bc1bdd299d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtractCoeffsIndexFree", "[", 
   RowBox[{
    RowBox[{"Equal", "[", 
     RowBox[{
      RowBox[{"lhs_", "?", "xTensorQ"}], ",", 
      RowBox[{"rhs_", "?", "xTensorQ"}]}], "]"}], ",", 
    RowBox[{"field_", "?", "xTensorQ"}]}], "]"}], ":=", 
  RowBox[{"DeleteCases", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ZeroTensorOfTensor", "[", "#", "]"}], "==", "#"}], ")"}], 
      "&"}], "/@", 
     RowBox[{"ExtractCoeffsIndexFree", "[", 
      RowBox[{
       RowBox[{"TensorMinus", "[", 
        RowBox[{"rhs", ",", "lhs"}], "]"}], ",", "field"}], "]"}]}], ",", 
    "True"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.862029984361182*^9, 3.86203006868941*^9}, {
  3.862030201112796*^9, 3.8620302861935863`*^9}},
 CellLabel->
  "In[327]:=",ExpressionUUID->"c244cc21-6855-43cd-a4bb-d35d62dfbc63"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtractCoeffsIndexFree", "[", 
   RowBox[{"l_List", ",", "f_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"ExtractCoeffsIndexFree", "[", 
     RowBox[{"#", ",", "f"}], "]"}], "&"}], "/@", "l"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8620335273769407`*^9, 3.862033553232608*^9}, {
  3.8620335916194315`*^9, 3.8620335969532003`*^9}},
 CellLabel->
  "In[328]:=",ExpressionUUID->"21c70763-0ad0-46e4-bcf4-e386c2b9983f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtractCoeffsIndexFree", "[", 
   RowBox[{"expr_", ",", "l_List"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"ExtractCoeffsIndexFree", "[", 
     RowBox[{"expr", ",", "#"}], "]"}], "&"}], "/@", "l"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8620335709770923`*^9, 3.8620335720572047`*^9}, {
  3.8620336188811274`*^9, 3.862033631047229*^9}},
 CellLabel->
  "In[329]:=",ExpressionUUID->"3fd64fa0-26ec-4394-aaf7-e7f64db79cc8"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variational operator", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.683259950582352*^9, 3.6832599568089795`*^9}, {
  3.7007432119192495`*^9, 3.700743213500252*^9}, {3.7008821239837265`*^9, 
  3.700882125929838*^9}, {3.837837775707291*^9, 3.8378378421306777`*^9}, {
  3.837849564691972*^9, 3.8378495658734217`*^9}, {3.955513347750698*^9, 
  3.9555133546395035`*^9}},ExpressionUUID->"4b4c41ca-fe78-cd4f-9d7e-\
fac84ca0592c"],

Cell[CellGroupData[{

Cell["VarSH", "Subsubsection",
 CellChangeTimes->{{3.838698715540696*^9, 3.8386987289005203`*^9}, {
  3.955513357916666*^9, 3.9555133586550694`*^9}, {3.9555328275413475`*^9, 
  3.955532831270958*^9}},ExpressionUUID->"4a06d9ab-fd04-3c44-a31e-\
1371eb716e17"],

Cell["See  arXiv:1505.03770 for definition of the operator. ", "Text",
 CellChangeTimes->{{3.9555320937257233`*^9, 
  3.9555321276334*^9}},ExpressionUUID->"b9756ec3-3d19-d946-8681-a68085b85a9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InitVarSH", "[", 
   RowBox[{"covd_", ",", 
    RowBox[{"namebase_", ":", "\"\<G\>\""}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"divcd", "=", 
       RowBox[{"xAct`SymManipulator`Private`DivName", "@", "covd"}]}], ",", 
      " ", 
      RowBox[{"curlcd", "=", 
       RowBox[{"xAct`SymManipulator`Private`CurlName", "@", "covd"}]}], ",", 
      " ", 
      RowBox[{"curldgcd", "=", 
       RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", "covd"}]}], ",",
       " ", 
      RowBox[{"twistcd", "=", 
       RowBox[{"xAct`SymManipulator`Private`TwistName", "@", "covd"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"spin", "=", 
       RowBox[{"VBundleOfSolderingForm", "[", 
        RowBox[{"SolderingFormOfSpinCovD", "[", "covd", "]"}], "]"}]}], ",", 
      RowBox[{"g22", "=", 
       RowBox[{"(", 
        RowBox[{"Symbol", "@", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"namebase", ",", "\"\<22\>\""}], "]"}]}], ")"}]}], ",", 
      RowBox[{"g00", "=", 
       RowBox[{"(", 
        RowBox[{"Symbol", "@", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"namebase", ",", "\"\<00\>\""}], "]"}]}], ")"}]}]}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"$TexInitLatexPackages", ",", "\"\<{slashed}\>\""}], "]"}], 
       ",", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"$TexInitLatexPackages", ",", "\"\<{slashed}\>\""}], "]"}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"DefSpinor", "[", 
      RowBox[{
       RowBox[{"g22", "@@", 
        RowBox[{"(", 
         RowBox[{"-", 
          RowBox[{"Join", "[", 
           RowBox[{
            RowBox[{"GetIndicesOfVBundle", "[", 
             RowBox[{"spin", ",", "2"}], "]"}], ",", 
            RowBox[{"GetIndicesOfVBundle", "[", 
             RowBox[{
              RowBox[{"Dagger", "[", "spin", "]"}], ",", "2"}], "]"}]}], 
           "]"}]}], ")"}]}], ",", 
       RowBox[{"BaseOfVBundle", "@", "spin"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"Dagger", "\[Rule]", "Hermitian"}], ",", 
       RowBox[{"PrintAs", "\[Rule]", "namebase"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"DefSpinor", "[", 
      RowBox[{
       RowBox[{"g00", "[", "]"}], ",", 
       RowBox[{"BaseOfVBundle", "@", "spin"}], ",", 
       RowBox[{"Dagger", "\[Rule]", "Real"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PrintAs", "[", "g00", "]"}], "^=", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"OverlayBox", "[", 
         RowBox[{"{", 
          RowBox[{"namebase", ",", "\"\</\>\""}], "}"}], "]"}], "}"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Tex", "[", "g00", "]"}], "^=", 
      RowBox[{"\"\<\\\\slashed{\>\"", "<>", 
       RowBox[{"Tex", "[", "namebase", "]"}], "<>", "\"\<}\>\""}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"LinMetricOfSpinCovD", "[", "covd", "]"}], "^=", 
      RowBox[{"{", 
       RowBox[{"g22", ",", "g00"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"VarSH", ",", "twistcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"VarSH", "[", 
        RowBox[{"twistcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"twistcd", "[", 
            RowBox[{"VarSH", "[", "TT", "]"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "8"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g00", ",", "0", ",", "0"}], "]"}], "[", 
              RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "1", ",", "1"}], "]"}], "[", 
              RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"k", "+", "l"}], ")"}]}], "/", "16"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"twistcd", "[", "g00", "]"}], ",", "0", ",", "0"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "+", "l"}], ")"}], "/", "12"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"divcd", "[", "g22", "]"}], ",", "0", ",", "0"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"l", "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"curldgcd", "[", "g22", "]"}], ",", "0", ",", "1"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"l", "/", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "1", ",", "0"}], "]"}], "[", 
              RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"k", "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "0", ",", "1"}], "]"}], "[", 
              RowBox[{"curldgcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"k", "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"curlcd", "[", "g22", "]"}], ",", "1", ",", "0"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "/", "2"}], "*", "k", "*", 
              RowBox[{
               RowBox[{"l", "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "0", ",", "0"}], "]"}], "[", 
              RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}]}], ";", "\n", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"VarSH", ",", "curlcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"VarSH", "[", 
        RowBox[{"curlcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"curlcd", "[", 
            RowBox[{"VarSH", "[", "TT", "]"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "8"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g00", ",", "0", ",", "0"}], "]"}], "[", 
              RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "1", ",", "2"}], "]"}], "[", 
              RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"l", "-", "k", "+", "2"}], ")"}], "/", "16"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"twistcd", "[", "g00", "]"}], ",", "0", ",", "1"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"l", "-", "k", "+", "2"}], ")"}]}], "/", "12"}], ",", 
             
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"divcd", "[", "g22", "]"}], ",", "0", ",", "1"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"1", "/", "2"}], "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "-", "1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "1", ",", "1"}], "]"}], "[", 
              RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"l", "-", "1"}], ")"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"curldgcd", "[", "g22", "]"}], ",", "0", ",", "2"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"k", "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"curlcd", "[", "g22", "]"}], ",", "1", ",", "1"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"k", "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "0", ",", "2"}], "]"}], "[", 
              RowBox[{"curldgcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "/", "2"}], "*", 
              RowBox[{"(", 
               RowBox[{"l", "-", "1"}], ")"}], "*", 
              RowBox[{
               RowBox[{"k", "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "0", ",", "1"}], "]"}], "[", 
              RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}]}], ";", "\n", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"VarSH", ",", "curldgcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"VarSH", "[", 
        RowBox[{"curldgcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"curldgcd", "[", 
            RowBox[{"VarSH", "[", "TT", "]"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "8"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g00", ",", "0", ",", "0"}], "]"}], "[", 
              RowBox[{"curldgcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "2", ",", "1"}], "]"}], "[", 
              RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "-", "l", "+", "2"}], ")"}], "/", "16"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"twistcd", "[", "g00", "]"}], ",", "1", ",", "0"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"k", "-", "l", "+", "2"}], ")"}]}], "/", "12"}], ",", 
             
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"divcd", "[", "g22", "]"}], ",", "1", ",", "0"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"1", "/", "2"}], "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "1", ",", "1"}], "]"}], "[", 
              RowBox[{"curldgcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "-", "1"}], ")"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"curlcd", "[", "g22", "]"}], ",", "2", ",", "0"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"l", "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"curldgcd", "[", "g22", "]"}], ",", "1", ",", "1"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"l", "/", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "2", ",", "0"}], "]"}], "[", 
              RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "/", "2"}], "*", 
              RowBox[{"(", 
               RowBox[{"k", "-", "1"}], ")"}], "*", 
              RowBox[{
               RowBox[{"l", "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "1", ",", "0"}], "]"}], "[", 
              RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}]}], ";", "\n", 
     RowBox[{
      RowBox[{"CommuteOp", "[", 
       RowBox[{"VarSH", ",", "divcd"}], "]"}], "^=", 
      RowBox[{
       RowBox[{"VarSH", "[", 
        RowBox[{"divcd", "[", 
         RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"k", "=", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}]}], 
           ",", 
           RowBox[{"l", "=", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"divcd", "[", 
            RowBox[{"VarSH", "[", "TT", "]"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "8"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g00", ",", "0", ",", "0"}], "]"}], "[", 
              RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "2", ",", "2"}], "]"}], "[", 
              RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "+", "l", "+", "4"}], ")"}], "/", "16"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"twistcd", "[", "g00", "]"}], ",", "1", ",", "1"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"k", "+", "l", "+", "4"}], ")"}]}], "/", "12"}], ",", 
             
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"divcd", "[", "g22", "]"}], ",", "1", ",", "1"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "-", "1"}], ")"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"curlcd", "[", "g22", "]"}], ",", "2", ",", "1"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "1", ",", "2"}], "]"}], "[", 
              RowBox[{"curldgcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"1", "/", "2"}], "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"l", "-", "1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"l", "+", "1"}], ")"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "2", ",", "1"}], "]"}], "[", 
              RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"l", "-", "1"}], ")"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"curldgcd", "[", "g22", "]"}], ",", "1", ",", "2"}], 
               "]"}], "[", "TT", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "/", "2"}], "*", 
              RowBox[{"(", 
               RowBox[{"l", "-", "1"}], ")"}], "*", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "l"}], ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}]}]}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{"g22", ",", "1", ",", "1"}], "]"}], "[", 
              RowBox[{"divcd", "[", "TT", "]"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"VarSHCurvatureRules", "[", "covd", "]"}], "^=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"VarSH", "[", 
          RowBox[{"Psi", "[", "covd", "]"}], "]"}], "->", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"Rational", "[", 
              RowBox[{"1", ",", "2"}], "]"}], ",", 
             RowBox[{"curlcd", "[", 
              RowBox[{"curlcd", "[", "g22", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"Rational", "[", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "4"}], "]"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"Psi", "[", "covd", "]"}], ",", "0", ",", "0", ",", 
                "spin"}], "]"}], "[", "g00", "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"Rational", "[", 
              RowBox[{"1", ",", "2"}], "]"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"Phi", "[", "covd", "]"}], ",", "0", ",", "2", ",", 
                "spin"}], "]"}], "[", "g22", "]"}]}], "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"VarSH", "[", 
          RowBox[{"Phi", "[", "covd", "]"}], "]"}], "->", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"1", "/", "6"}], ",", 
             RowBox[{"twistcd", "[", 
              RowBox[{"divcd", "[", "g22", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "8"}], ",", 
             RowBox[{"twistcd", "[", 
              RowBox[{"twistcd", "[", "g00", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"curlcd", "[", 
              RowBox[{"curldgcd", "[", "g22", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"Dagger", "[", 
                 RowBox[{"Psi", "[", "covd", "]"}], "]"}], ",", "0", ",", "2",
                 ",", "spin"}], "]"}], "[", "g22", "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "4"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"Phi", "[", "covd", "]"}], ",", "0", ",", "0", ",", 
                "spin"}], "]"}], "[", "g00", "]"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"SymMult", "[", 
             RowBox[{
              RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", ",", 
              "spin"}], "]"}], "[", "g22", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"VarSH", "[", 
          RowBox[{"Lambda", "[", "covd", "]"}], "]"}], "->", 
         RowBox[{"TensorPlus", "[", 
          RowBox[{
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "24"}], ",", 
             RowBox[{"divcd", "[", 
              RowBox[{"divcd", "[", "g22", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"1", "/", "32"}], ",", 
             RowBox[{"divcd", "[", 
              RowBox[{"twistcd", "[", "g00", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "4"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"Lambda", "[", "covd", "]"}], ",", "0", ",", "0", ",",
                 "spin"}], "]"}], "[", "g00", "]"}]}], "]"}], ",", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"1", "/", "12"}], ",", 
             RowBox[{
              RowBox[{"SymMult", "[", 
               RowBox[{
                RowBox[{"Phi", "[", "covd", "]"}], ",", "2", ",", "2", ",", 
                "spin"}], "]"}], "[", "g22", "]"}]}], "]"}]}], "]"}]}]}], 
       "}"}]}], ";"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9555135550301514`*^9, 3.9555135762837048`*^9}, {
   3.955513730201292*^9, 3.955513748439234*^9}, {3.9555138328486557`*^9, 
   3.955513849328327*^9}, {3.955513900515682*^9, 3.9555139428666267`*^9}, {
   3.955519473544468*^9, 3.955519475975382*^9}, {3.955529678415209*^9, 
   3.9555297347663193`*^9}, {3.9555298106982365`*^9, 3.955529833000952*^9}, {
   3.955530007422411*^9, 3.9555300539004326`*^9}, {3.9555301086877594`*^9, 
   3.9555302418349648`*^9}, {3.9555303269450455`*^9, 
   3.9555303294162197`*^9}, {3.95553039011561*^9, 3.9555305082196465`*^9}, {
   3.95553056398921*^9, 3.955530610028286*^9}, 3.9555307477744274`*^9, {
   3.955530980119173*^9, 3.9555309805483646`*^9}, {3.955531051679962*^9, 
   3.955531211077997*^9}, {3.955531267828495*^9, 3.955531521043892*^9}, {
   3.955531571440136*^9, 3.9555318781878815`*^9}, 3.955532425855032*^9},
 CellLabel->
  "In[330]:=",ExpressionUUID->"1fbdce1b-7485-7643-b7d2-a4f6f096fc8c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"VarSH", "[", 
     RowBox[{"LL_", "?", "xTensorQ"}], "]"}], "]"}], "^=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"VarSH", "[", 
     RowBox[{"LL_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"SlotsOfTensor", "[", "LL", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"VarSH", "[", 
     RowBox[{"LL_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"SymmetryGroupOfTensor", "[", "LL", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"VarSH", "[", 
     RowBox[{"LL_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<\[CurlyTheta]\>\"", ",", 
      RowBox[{"PrintAs", "[", "LL", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", 
    RowBox[{"VarSH", "[", 
     RowBox[{"LL_", "?", "xTensorQ"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\vartheta \>\"", ",", 
     RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", "LL", "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"x", ":", 
     RowBox[{
      RowBox[{"(", "VarSH", ")"}], "[", "___", "]"}]}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"xAct`TexAct`Private`TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
     RowBox[{"xAct`SymManipulator`Private`TexFundOp", "@", "x"}], ",", 
     RowBox[{"xAct`TexAct`Private`TexClose", "[", "\"\<)\>\"", "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.685417299190425*^9, 3.6854173100304403`*^9}, {
  3.685417383691543*^9, 3.6854174312526097`*^9}, {3.685417499072705*^9, 
  3.685417506002714*^9}, {3.6854175367237577`*^9, 3.6854175952538395`*^9}, {
  3.6854178929972563`*^9, 3.685417901988269*^9}},
 CellLabel->
  "In[331]:=",ExpressionUUID->"7222e7c3-17e4-2c4f-8c23-cef4179b901d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfUnprimedSlots", "[", "spin_", "]"}], "[", 
    RowBox[{"VarSH", "[", 
     RowBox[{"LL_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "LL", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NumOfPrimedSlots", "[", "spin_", "]"}], "[", 
    RowBox[{"VarSH", "[", 
     RowBox[{"LL_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "LL", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.955513522563345*^9, 3.955513533747896*^9}},
 CellLabel->
  "In[337]:=",ExpressionUUID->"363c8fa5-7fdf-e140-95bd-7635a7946c45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetLinearOperatorRules", "[", "VarSH", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.89123732439283*^9, 3.8912373314728556`*^9}},
 CellLabel->
  "In[339]:=",ExpressionUUID->"a9910da1-44d4-3749-bcca-26d6c8e5a1af"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Dagger", "[", 
    RowBox[{"VarSH", "[", "expr_", "]"}], "]"}], "^:=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"HermitianQ", "[", "expr", "]"}], ",", 
     RowBox[{"VarSH", "[", "expr", "]"}], ",", 
     RowBox[{"VarSH", "[", 
      RowBox[{"Dagger", "[", "expr", "]"}], "]"}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.9555104958427353`*^9, 3.9555105292414703`*^9}, {
  3.955510634852026*^9, 3.955510658733288*^9}},
 CellLabel->
  "In[340]:=",ExpressionUUID->"d2e5e3ee-90c0-2841-87a5-fc37ebf05158"],

Cell[BoxData[
 RowBox[{
  RowBox[{"VarSHLeibnizRule", " ", "=", " ", 
   RowBox[{
    RowBox[{"VarSH", "[", 
     RowBox[{
      RowBox[{"SymMult", "[", 
       RowBox[{"T1_", ",", " ", "i_", ",", " ", "j_", ",", " ", "spin_"}], 
       "]"}], "[", "T2_", "]"}], "]"}], " ", ":>", " ", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{
         RowBox[{"VarSH", "[", "T1", "]"}], ",", " ", "i", ",", " ", "j", ",",
          " ", "spin"}], "]"}], "[", "T2", "]"}], ",", " ", 
      RowBox[{
       RowBox[{"SymMult", "[", 
        RowBox[{"T1", ",", " ", "i", ",", " ", "j", ",", " ", "spin"}], "]"}],
        "[", 
       RowBox[{"VarSH", "[", "T2", "]"}], "]"}]}], "]"}]}]}], ";"}]], "Code",
 CellChangeTimes->{{3.891236290235319*^9, 3.891236307226883*^9}, {
  3.955504648735073*^9, 3.9555046526663666`*^9}, {3.955530859195505*^9, 
  3.955530863562111*^9}},
 CellLabel->
  "In[341]:=",ExpressionUUID->"6951f02f-3799-2143-9147-078e9013bd6d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrix Operators", "Subsection",
 CellChangeTimes->{{3.672053539448455*^9, 3.6720535453194637`*^9}, {
  3.6720536331995845`*^9, 3.672053637309592*^9}, {3.6720537626697674`*^9, 
  3.6720537665997734`*^9}, {3.672053868799917*^9, 3.672053875129925*^9}, {
  3.844408466256935*^9, 3.844408471218889*^9}, {3.957862332559658*^9, 
  3.9578623401214314`*^9}, {3.958357719255148*^9, 3.958357720004034*^9}, {
  3.958383127801243*^9, 3.9583831289051704`*^9}, {3.9583834909360657`*^9, 
  3.9583834913046207`*^9}},ExpressionUUID->"7317d895-0c99-431c-9ed0-\
13d5c04d009e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MakeBoxes", "[", 
   RowBox[{
    RowBox[{"TensorMatrix", "[", "matrix_List", "]"}], ",", "StandardForm"}], 
   "]"}], ":=", 
  RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
   RowBox[{
    RowBox[{"TensorMatrix", "[", "matrix", "]"}], ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<(\>\"", ",", 
       RowBox[{"Map", "[", 
        RowBox[{"PrintAs", ",", 
         RowBox[{"GridBox", "[", "matrix", "]"}], ",", 
         RowBox[{"{", "3", "}"}]}], "]"}], ",", "\"\<)\>\""}], "}"}], "]"}]}],
    "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6720547498511496`*^9, 3.6720547796911917`*^9}, {
   3.672055029591541*^9, 3.672055044271562*^9}, 3.672055090351626*^9, {
   3.672055179891752*^9, 3.672055198881778*^9}, {3.672055234191828*^9, 
   3.672055252981854*^9}, {3.672055307801931*^9, 3.672055334761967*^9}, {
   3.672055386882042*^9, 3.672055415842082*^9}, {3.67205547158216*^9, 
   3.67205550715221*^9}, 3.6720594865564103`*^9},
 CellLabel->
  "In[342]:=",ExpressionUUID->"2c23f1f0-2688-4b57-88b5-08701e047ba3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"TensorMatrix", "[", "matrix_List", "]"}], "]"}], ":=", 
   RowBox[{"TexBMatrix", "[", "matrix", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.672108475694195*^9, 3.672108492544219*^9}, {
   3.67210912846511*^9, 3.672109139355125*^9}, 3.8444137849454036`*^9, {
   3.9583832734185944`*^9, 3.9583832768705845`*^9}, {3.9583852731095333`*^9, 
   3.958385286333332*^9}, {3.95840047723328*^9, 
   3.9584004803920918`*^9}},ExpressionUUID->"f894c297-49c3-4a42-8491-\
98cb3d05613b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Plus", "[", 
    RowBox[{
     RowBox[{"TensorMatrix", "[", "a_", "]"}], ",", 
     RowBox[{"TensorMatrix", "[", "b_", "]"}]}], "]"}], "^:=", 
   RowBox[{"TensorMatrix", "[", 
    RowBox[{"TensorPlus", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.958393176572365*^9, 
  3.9583931925849705`*^9}},ExpressionUUID->"c20e4803-1dd4-5041-8661-\
d045754d925a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TensorMatrix", "[", 
     RowBox[{"zeromat", ":", 
      RowBox[{"{", 
       RowBox[{"Repeated", "[", 
        RowBox[{"{", 
         RowBox[{"ZeroTensor", "[", "_", "]"}], "}"}], "]"}], "}"}]}], "]"}], 
    "+", 
    RowBox[{
     RowBox[{"TensorMatrixOp", "[", "opmat_", "]"}], "[", "expr_", "]"}]}], "^:=", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorMatrixOp", "[", "opmat", "]"}], "[", "expr", "]"}], "/;", 
    
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Length", "[", "zeromat", "]"}], "==", 
      RowBox[{"Length", "[", "opmat", "]"}]}], ")"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"321e5d7d-c79c-f247-a887-1ad40f39ebb3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TexNoparOp", "[", "expr_TensorPlus", "]"}], " ", ":=", " ", 
   RowBox[{"Tex", "[", "expr", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TexNoparOp", "[", "expr_", "]"}], " ", ":=", " ", 
   RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", "expr", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[344]:=",ExpressionUUID->"1e32b5bf-4969-47e8-badb-431eeda110f6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"TensorMatrixOp", "[", "opmatrix_List", "]"}], "]"}], " ", ":=", 
   " ", 
   RowBox[{"TexBMatrix", "[", 
    RowBox[{"opmatrix", ",", "TexNoparOp"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.844413698953108*^9, 3.95838320209334*^9, {3.9583853332869415`*^9, 
   3.9583853376024113`*^9}, {3.9584004887284336`*^9, 
   3.958400491885004*^9}},ExpressionUUID->"68b1072a-f040-46dd-82c0-\
1d0c051e970e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{
    RowBox[{"TensorMatrixOp", "[", "opmatrix_List", "]"}], "[", "expr_", 
    "]"}], "]"}], "^:=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"TexNoparOp", "[", 
     RowBox[{"TensorMatrixOp", "[", "opmatrix", "]"}], "]"}], ",", 
    RowBox[{"Tex", "[", "expr", "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.672108535334279*^9, 3.672108576704337*^9}, {
   3.672109148285138*^9, 3.672109160015154*^9}, {3.672109543815691*^9, 
   3.672109552525704*^9}, 3.672109595405763*^9, {3.820725548538124*^9, 
   3.820725558791349*^9}, {3.844412763501274*^9, 3.8444127856851244`*^9}, {
   3.844412911413062*^9, 3.84441291186186*^9}, {3.844413017581463*^9, 
   3.8444130450662637`*^9}, 3.844413196239089*^9, {3.8444137028196497`*^9, 
   3.844413710638623*^9}, {3.9583770395706882`*^9, 3.958377042654827*^9}, 
   3.958383245935564*^9, {3.9583833061947136`*^9, 3.958383358328869*^9}},
 CellLabel->
  "In[347]:=",ExpressionUUID->"338bad9b-75c5-4ddf-9e47-79393f9db5f6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MakeBoxes", "[", 
   RowBox[{
    RowBox[{"TensorMatrixOp", "[", "matrix_List", "]"}], ",", 
    "StandardForm"}], "]"}], ":=", 
  RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
   RowBox[{
    RowBox[{"TensorMatrixOp", "[", "matrix", "]"}], ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<(\>\"", ",", 
       RowBox[{"Map", "[", 
        RowBox[{"xAct`SymSpin`Private`PrintAsNoPar", ",", 
         RowBox[{"GridBox", "[", "matrix", "]"}], ",", 
         RowBox[{"{", "3", "}"}]}], "]"}], ",", "\"\<)\>\""}], "}"}], "]"}]}],
    "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6720547498511496`*^9, 3.6720547796911917`*^9}, {
   3.672055029591541*^9, 3.672055044271562*^9}, 3.672055090351626*^9, {
   3.672055179891752*^9, 3.672055198881778*^9}, {3.672055234191828*^9, 
   3.672055252981854*^9}, {3.672055307801931*^9, 3.672055334761967*^9}, {
   3.672055386882042*^9, 3.672055415842082*^9}, {3.67205547158216*^9, 
   3.67205550715221*^9}, {3.672056422804492*^9, 3.672056425344496*^9}, {
   3.820729712401737*^9, 3.820729714008189*^9}, {3.8444111502254443`*^9, 
   3.8444111678437405`*^9}, {3.9583833684376316`*^9, 3.95838337119396*^9}},
 CellLabel->
  "In[348]:=",ExpressionUUID->"c1772828-9da4-4c6a-8c05-c2f4bde10986"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SpinorToDummySpinor", "[", 
   RowBox[{"MultScal", "[", 
    RowBox[{"c_", ",", 
     RowBox[{"TT_", "?", 
      RowBox[{"(", 
       RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "]"}], ")"}]}]}], 
    "]"}], "]"}], ":=", 
  RowBox[{"TT", "->", 
   RowBox[{"MultScal", "[", 
    RowBox[{
     RowBox[{"1", "/", "c"}], ",", 
     RowBox[{"SymSpinor", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"NumOfUnprimedSlots", "[", "$DefaultSpinBundle", "]"}], "[", 
        "TT", "]"}], ",", 
       RowBox[{
        RowBox[{"NumOfPrimedSlots", "[", "$DefaultSpinBundle", "]"}], "[", 
        "TT", "]"}], ",", "xAct`SymSpin`Private`DummySymbol", ",", 
       "$DefaultSpinBundle"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpinorToDummySpinor", "[", 
   RowBox[{"TT_", "?", 
    RowBox[{"(", 
     RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "]"}], ")"}]}], "]"}],
   ":=", 
  RowBox[{"TT", "->", 
   RowBox[{"SymSpinor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NumOfUnprimedSlots", "[", "$DefaultSpinBundle", "]"}], "[", 
      "TT", "]"}], ",", 
     RowBox[{
      RowBox[{"NumOfPrimedSlots", "[", "$DefaultSpinBundle", "]"}], "[", "TT",
       "]"}], ",", "xAct`SymSpin`Private`DummySymbol", ",", 
     "$DefaultSpinBundle"}], "]"}]}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.672055645692404*^9, 3.672055767992575*^9}, {
  3.67205594989383*^9, 3.672056013263919*^9}, {3.6721086003743706`*^9, 
  3.6721086047543764`*^9}, {3.673339304011374*^9, 3.673339306321422*^9}, {
  3.844408668586128*^9, 3.8444086702666903`*^9}, {3.8444089252809997`*^9, 
  3.844408973903195*^9}, {3.844409417171185*^9, 3.8444094299024744`*^9}, {
  3.844409462500241*^9, 3.844409473274527*^9}, {3.8444095139567227`*^9, 
  3.844409526589916*^9}, {3.8444111828415084`*^9, 3.844411186112573*^9}, {
  3.9583582188015175`*^9, 3.958358351835644*^9}},
 CellLabel->
  "In[349]:=",ExpressionUUID->"dda2bca5-e0dc-b64d-bb36-9f7a62a6de23"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DummySpinorToSpinor", "[", 
   RowBox[{"MultScal", "[", 
    RowBox[{"c_", ",", 
     RowBox[{"TT_", "?", 
      RowBox[{"(", 
       RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "]"}], ")"}]}]}], 
    "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"SymSpinor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NumOfUnprimedSlots", "[", "$DefaultSpinBundle", "]"}], "[", 
      "TT", "]"}], ",", 
     RowBox[{
      RowBox[{"NumOfPrimedSlots", "[", "$DefaultSpinBundle", "]"}], "[", "TT",
       "]"}], ",", "xAct`SymSpin`Private`DummySymbol", ",", 
     "$DefaultSpinBundle"}], "]"}], "->", 
   RowBox[{"MultScal", "[", 
    RowBox[{"c", ",", "TT"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DummySpinorToSpinor", "[", 
   RowBox[{"TT_", "?", 
    RowBox[{"(", 
     RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "]"}], ")"}]}], "]"}],
   ":=", 
  RowBox[{
   RowBox[{"SymSpinor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NumOfUnprimedSlots", "[", "$DefaultSpinBundle", "]"}], "[", 
      "TT", "]"}], ",", 
     RowBox[{
      RowBox[{"NumOfPrimedSlots", "[", "$DefaultSpinBundle", "]"}], "[", "TT",
       "]"}], ",", "xAct`SymSpin`Private`DummySymbol", ",", 
     "$DefaultSpinBundle"}], "]"}], "->", "TT"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.672055645692404*^9, 3.672055767992575*^9}, {
  3.67205594989383*^9, 3.672056013263919*^9}, {3.6721086003743706`*^9, 
  3.6721086047543764`*^9}, {3.673339304011374*^9, 3.673339306321422*^9}, {
  3.844408668586128*^9, 3.8444086702666903`*^9}, {3.8444089252809997`*^9, 
  3.844408973903195*^9}, {3.844409417171185*^9, 3.8444094299024744`*^9}, {
  3.844409462500241*^9, 3.844409473274527*^9}, {3.8444095139567227`*^9, 
  3.844409526589916*^9}, {3.8444111828415084`*^9, 3.844411186112573*^9}, {
  3.9583582188015175`*^9, 3.958358351835644*^9}, {3.958358422474699*^9, 
  3.9583584396844215`*^9}, {3.9583584721906013`*^9, 3.958358536908121*^9}},
 CellLabel->
  "In[351]:=",ExpressionUUID->"abe0fac3-5302-9d49-be95-d0663ca2ce4c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MultScalTensorToZeroRule", "[", 
    RowBox[{"MultScal", "[", 
     RowBox[{"c_", ",", "TT_"}], "]"}], "]"}], ":=", 
   RowBox[{"TensorToZeroRule", "[", "TT", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MultScalTensorToZeroRule", "[", "TT_", "]"}], ":=", 
   RowBox[{"TensorToZeroRule", "[", "TT", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.95837847786438*^9, {3.958378517910902*^9, 3.958378545048891*^9}},
 CellLabel->
  "In[353]:=",ExpressionUUID->"4b3965a9-3ecc-2f48-98d9-36ede3e80cfb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TensorMatrixOpRule", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorMatrixOp", "[", "opmatrix_List", "]"}], "[", 
     RowBox[{"TensorMatrix", "[", "tmatrix_List", "]"}], "]"}], 
    "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"TensorMatrix", "@", 
       RowBox[{"Inner", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"#1", "/.", 
           RowBox[{"DummySpinorToSpinor", "[", "#2", "]"}]}], "&"}], ",", 
         "opmatrix", ",", "tmatrix", ",", "TensorPlus"}], "]"}]}]}], 
     "]"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.672057745046343*^9, 3.6720578371364717`*^9}, {
   3.6720578967965555`*^9, 3.672057904296566*^9}, {3.672057976526667*^9, 
   3.672057981406674*^9}, {3.672058681479356*^9, 3.672058697622438*^9}, {
   3.672058940851069*^9, 3.672059006086275*^9}, {3.672059143351582*^9, 
   3.672059158348719*^9}, 3.679997506314533*^9, {3.844409598509424*^9, 
   3.844409603494085*^9}, {3.95835857993799*^9, 3.9583585922877903`*^9}, 
   3.9583833962432823`*^9, {3.958385311443756*^9, 
   3.9583853123712597`*^9}},ExpressionUUID->"6af69cf6-ca2b-4bae-894d-\
209ec82611ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TensorMatrixToList", "=", 
   RowBox[{
    RowBox[{"TensorMatrix", "[", "tmatrix_List", "]"}], "\[RuleDelayed]", 
    "tmatrix"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.672059363060122*^9, 3.672059368150129*^9}, 
   3.672059495056422*^9, {3.6720596311266127`*^9, 3.6720596753366747`*^9}, {
   3.67205977974682*^9, 3.6720597802768207`*^9}, {3.672059888906974*^9, 
   3.672059889356974*^9}, {3.958384030558834*^9, 3.95838403346496*^9}},
 CellLabel->
  "In[356]:=",ExpressionUUID->"2db0804f-3bcd-426b-99cd-4c702ea8161e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TensorMatrixEqToList", "[", "expr_Equal", "]"}], ":=", 
   RowBox[{"Expand", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Thread", "/@", 
      RowBox[{"Thread", "[", 
       RowBox[{"expr", "/.", "TensorMatrixToList"}], "]"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.672059785566828*^9, 3.67205980776686*^9}, {
   3.672059866546943*^9, 3.67205988651697*^9}, 3.844409643081529*^9},
 CellLabel->
  "In[357]:=",ExpressionUUID->"49498c7a-7cea-4076-9e1e-a36e7e4450ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EqListToTensorMatrixEq", "[", 
   RowBox[{"teqlist_List", ",", "vars_List"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"TensorMatrix", "[", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"(", 
       RowBox[{"First", "/@", "teqlist"}], ")"}], "}"}], "]"}], "]"}], "==", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"main", "=", 
       RowBox[{
        RowBox[{"TensorMatrixOp", "[", 
         RowBox[{"Outer", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"TensorMinus", "[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "/.", 
                  RowBox[{"MultScalTensorToZeroRule", "[", "#2", "]"}]}], 
                 ")"}]}], "]"}], "/.", 
              RowBox[{"SpinorToDummySpinor", "[", "#2", "]"}]}], ")"}], "&"}],
            ",", "teqlist", ",", "vars"}], "]"}], "]"}], "@", 
        RowBox[{"TensorMatrix", "[", 
         RowBox[{"Transpose", "[", 
          RowBox[{"{", "vars", "}"}], "]"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"main", "+", " ", 
      RowBox[{"TensorMatrix", "[", 
       RowBox[{"TensorMinus", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{"(", 
            RowBox[{"Last", "/@", "teqlist"}], ")"}], "}"}], "]"}], ",", 
         RowBox[{"First", "[", 
          RowBox[{"main", "/.", "TensorMatrixOpRule"}], "]"}]}], "]"}], 
       "]"}]}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.67206644142069*^9, 3.672066499590771*^9}, {
   3.672066612570929*^9, 3.672066628770952*^9}, {3.6720666823610277`*^9, 
   3.672066802781196*^9}, {3.6720668451212554`*^9, 3.6720669038113375`*^9}, 
   3.672067015701494*^9, 3.673340613450701*^9, {3.673340820944851*^9, 
   3.673340865965864*^9}, {3.673340904077007*^9, 3.6733409420281453`*^9}, {
   3.673341188125529*^9, 3.673341240287094*^9}, {3.673341752294042*^9, 
   3.673341767732036*^9}, {3.8444097148918715`*^9, 3.844409733084787*^9}, {
   3.844411039130195*^9, 3.84441104693151*^9}, 3.844411954007489*^9, {
   3.9583784447817993`*^9, 3.9583784463879623`*^9}, {3.9583836886237926`*^9, 
   3.958383689500437*^9}, {3.9583863055765686`*^9, 3.9583863653997726`*^9}, {
   3.9583864405635433`*^9, 3.9583864585617905`*^9}, {3.9583869558678646`*^9, 
   3.9583869680061874`*^9}, {3.958392561439995*^9, 3.9583925618495903`*^9}, {
   3.9583930755702686`*^9, 
   3.95839308291704*^9}},ExpressionUUID->"ccbb04c3-91a0-482d-8372-\
313661ffa445"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListToTensorMatrix", "[", 
   RowBox[{"oplist_List", ",", "vars_List"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"TensorMatrixOp", "[", 
    RowBox[{"Outer", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"TensorMinus", "[", 
          RowBox[{"#1", ",", 
           RowBox[{"(", 
            RowBox[{"#1", "/.", 
             RowBox[{"MultScalTensorToZeroRule", "[", "#2", "]"}]}], ")"}]}], 
          "]"}], "/.", 
         RowBox[{"SpinorToDummySpinor", "[", "#2", "]"}]}], ")"}], "&"}], ",",
       "oplist", ",", "vars"}], "]"}], "]"}], "@", 
   RowBox[{"TensorMatrix", "[", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", "vars", "}"}], "]"}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8444108654378815`*^9, 3.844410906865399*^9}, {
   3.84441101931371*^9, 3.8444110306892133`*^9}, 3.9583784572743263`*^9, {
   3.958383714802906*^9, 3.958383715986614*^9}},
 CellLabel->
  "In[359]:=",ExpressionUUID->"5ae8a992-7d5a-44f1-b6c0-85fd3262c582"]
}, Closed]],

Cell[CellGroupData[{

Cell["7. End private and package", "Subsection",
 CellChangeTimes->{
  3.527145154765854*^9, 3.5292318049006476`*^9, 3.5703537164502516`*^9, 
   3.5703543041198835`*^9, {3.6070696339837017`*^9, 3.607069645633718*^9}, 
   3.6070712426424527`*^9, 3.622863477371907*^9, 3.6440355071146007`*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"516100c1-a781-47e2-925b-3bb6c6e6db1d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[360]:=",ExpressionUUID->"47e66c31-4cd8-4e6a-b1c7-6c555f676ff9"]
}, Closed]],

Cell[CellGroupData[{

Cell["8. Examples", "Subsection",
 CellChangeTimes->{
  3.5271451565598564`*^9, 3.529231807084652*^9, 3.570353718961856*^9, 
   3.5703543056018867`*^9, {3.607069635463704*^9, 3.60706964686372*^9}, 
   3.6070712440724545`*^9, 3.6228634786719093`*^9, 3.644035509064603*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"1ee655f3-96b5-4ac5-9270-72ad022cde2c"],

Cell["The user context is empty :", "Text",ExpressionUUID->"9057472d-8969-4492-885e-c6dfc06954c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellChangeTimes->{{3.9583842438462296`*^9, 3.958384245321953*^9}},
 CellLabel->
  "In[362]:=",ExpressionUUID->"9c10f20e-3afc-4278-816a-9c55805ce7cf"],

Cell[BoxData[
 RowBox[{"Missing", "[", 
  RowBox[{"\<\"UnknownSymbol\"\>", ",", "\<\"Global`*\"\>"}], "]"}]], "Output",\

 CellChangeTimes->{{3.8391506255514994`*^9, 3.83915064908232*^9}, 
   3.839150716907847*^9, 3.83915075248405*^9, 3.839150903467478*^9, 
   3.839676404421856*^9, 3.839676446225424*^9, 3.8400276413239822`*^9, 
   3.840028374949752*^9, 3.840029053939437*^9, 3.8449217814567113`*^9, 
   3.863080463785128*^9, 3.863170698406124*^9, {3.9583842471017513`*^9, 
   3.9583842668843517`*^9}},
 CellLabel->
  "Out[362]=",ExpressionUUID->"3d6d2cda-91fc-8741-bb3a-65917db7cbd5"]
}, Open  ]],

Cell["Define a manifold", "Text",
 CellChangeTimes->{{3.517390655215265*^9, 
  3.5173906600668736`*^9}},ExpressionUUID->"756fd65f-beef-4245-be76-\
76a4997eae5d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.584429958343937*^9, 3.584429964615148*^9}},
 CellLabel->
  "In[363]:=",ExpressionUUID->"76df22be-696c-4138-bac1-8f3e000b4e11"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CVVerbose", "=", "False"}], ";"}]], "Input",
 CellLabel->
  "In[364]:=",ExpressionUUID->"29a56691-45ea-4a28-ab8a-9ccfc2a178b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"AutomaticRules", ",", 
    RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{3.584427462866954*^9},
 CellLabel->
  "In[365]:=",ExpressionUUID->"d11b8755-a3eb-4081-b0d8-96921aecd1a6"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M4", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "h", ",", "l", ",", "m",
      ",", "p", ",", "q"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.458061600629331*^9, 3.4580616119243917`*^9}, 
   3.4930234672464*^9, 3.4930252618884*^9, {3.4930256821434*^9, 
   3.4930256973644*^9}, 3.5844293408782525`*^9, 3.5844293831699266`*^9},
 CellLabel->
  "In[366]:=",ExpressionUUID->"a51bf9c4-0355-4338-bb8c-c2b81b31638b"],

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.584428050021785*^9, 3.584428050271385*^9}, {
  3.5844293080557947`*^9, 3.5844293081181946`*^9}, {3.584429390423939*^9, 
  3.584429399097554*^9}},
 CellLabel->
  "In[367]:=",ExpressionUUID->"793821ec-f1d8-4a79-8a2e-5299122eb6b4"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"ValidateSymbol", "::", "\"\<capital\>\""}], "]"}]], "Input",
 CellLabel->
  "In[368]:=",ExpressionUUID->"5e736c59-e989-46ea-b052-e2495fd034e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"DefAbstractIndex", ",", 
   RowBox[{"PrintAs", "\[Rule]", "PrimeDagger"}]}], "]"}]], "Input",
 CellLabel->
  "In[369]:=",ExpressionUUID->"a59b6ac4-1a0b-41a2-bfd7-21a810cf0d70"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PrintAs", "\[Rule]", "PrimeDagger"}], ",", 
   RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.607069913574093*^9, 3.607071270802492*^9, 3.607071405852681*^9, 
   3.6070715251628485`*^9, 3.6070715712129126`*^9, 3.607072816915657*^9, 
   3.6070729108057885`*^9, 3.6070824896663084`*^9, 3.6070832074573135`*^9, 
   3.607083377137551*^9, 3.6070835186377487`*^9, 3.607084245569767*^9, 
   3.6070843277898817`*^9, 3.6070845276601615`*^9, 3.6070849674907775`*^9, 
   3.6070850123908405`*^9, 3.6070857761829095`*^9, 3.607085884973062*^9, 
   3.6070859801931953`*^9, 3.6070862609535885`*^9, 3.6070875515963955`*^9, 
   3.607087930766926*^9, 3.6070880815171375`*^9, 3.607088642797923*^9, 
   3.607089568190219*^9, 3.607089627720302*^9, 3.607092625801668*^9, 
   3.6190819477188005`*^9, 3.619084940735473*^9, 3.622956925910632*^9, 
   3.642666515068014*^9, {3.642758185241819*^9, 3.6427581939718313`*^9}, 
   3.6433505225473876`*^9, 3.643995862227309*^9, 3.643995930157404*^9, 
   3.6440359346451993`*^9, 3.6440360538953657`*^9, 3.6440365371470428`*^9, 
   3.644036620197159*^9, 3.6440377595997543`*^9, 3.645004838021743*^9, 
   3.64501039210371*^9, 3.6450108510453525`*^9, 3.646371252699277*^9, 
   3.6472546400582047`*^9, 3.647254961739603*^9, 3.647255875468866*^9, 
   3.6472561138615007`*^9, 3.6472562984900613`*^9, {3.6472563850260105`*^9, 
   3.6472564142046795`*^9}, {3.6473287140812263`*^9, 3.6473287291712475`*^9}, 
   3.6482642308935723`*^9, 3.648265047684246*^9, 3.6483501751542487`*^9, 
   3.649002742656107*^9, 3.6491724536863565`*^9, 3.64921429726259*^9, 
   3.649214332202639*^9, 3.679984342001845*^9, 3.6975461843220873`*^9, 
   3.6975462342431583`*^9, 3.7282077888298345`*^9, 3.728208067639823*^9, 
   3.728209636100206*^9, 3.728209702879625*^9, 3.728792432586114*^9, {
   3.839150625899568*^9, 3.8391506494543266`*^9}, 3.8391507172559156`*^9, 
   3.839150752878993*^9, 3.839150903821498*^9, 3.8396764047790117`*^9, 
   3.839676446543569*^9, 3.840027641659059*^9, 3.840028375277875*^9, 
   3.840029054314432*^9, 3.8449217818292904`*^9, 3.8630804641312027`*^9, 
   3.8631706987252407`*^9, {3.958384237217169*^9, 3.958384267172716*^9}},
 CellLabel->
  "Out[369]=",ExpressionUUID->"7df12220-cb22-5a43-8013-f2417cd4dd07"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{
    "A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "H", ",", "L", ",", "M",
      ",", "P", ",", "Q", ",", "R", ",", "S"}], "}"}], ",", "\[Epsilon]", ",",
    "\[Sigma]", ",", "CDe", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}], ",", 
   RowBox[{"SpinorPrefix", "->", "SP"}], ",", 
   RowBox[{"SpinorMark", "->", "\"\<S\>\""}]}], "]"}]], "Input",
 CellLabel->
  "In[370]:=",ExpressionUUID->"17e9545f-fefb-4265-a82d-ef033551d268"],

Cell["\<\
Follow Penrose Rindler sign conventions ($RiemannSign is opposite to the \
conventions of Wald)\
\>", "Text",
 CellChangeTimes->{{3.6472546675667777`*^9, 
  3.6472547068460245`*^9}},ExpressionUUID->"79b2d79c-d253-43f3-8203-\
f96442e15933"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RiemannSign", "=", 
   RowBox[{"-", "1"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.647254712516349*^9, 3.6472547142374473`*^9}},
 CellLabel->
  "In[371]:=",ExpressionUUID->"eee67161-6851-4b25-a00d-cfbeba0fffda"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAs", "[", "PsiCDe", "]"}], "^=", "\"\<\[CapitalPsi]\>\""}],
     ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "PhiCDe", "]"}], "^=", "\"\<\[CapitalPhi]\>\""}],
     ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "LambdaCDe", "]"}], "^=", 
     "\"\<\[CapitalLambda]\>\""}]}], "}"}], ";"}]], "Input",
 CellChangeTimes->{{3.607083443767644*^9, 3.6070834481576505`*^9}},
 CellLabel->
  "In[372]:=",ExpressionUUID->"0c9c389a-b75e-4d3d-ad39-b6d6bdc6b0c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`SpinFrames`Private`PrintDaggerAsBar", "/@", 
  RowBox[{"{", 
   RowBox[{"\[Epsilon]", ",", "PsiCDe"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.607083392327572*^9, 3.607083435037632*^9}, 
   3.6472543035203524`*^9},
 CellLabel->
  "In[373]:=",ExpressionUUID->"e6c0e36c-3057-41e3-9049-6dae6a9050b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\\!\\(\[Epsilon]\\&_\\)\"\>", 
   ",", "\<\"\\!\\(\[CapitalPsi]\\&_\\)\"\>"}], "}"}]], "Output",
 CellChangeTimes->{
  3.607083450957654*^9, 3.607083518947749*^9, 3.607084245889767*^9, 
   3.6070843281098824`*^9, 3.6070845279801617`*^9, 3.6070849678107777`*^9, 
   3.607085012700841*^9, 3.60708577649291*^9, 3.6070858853030624`*^9, 
   3.6070859805131955`*^9, 3.607086261283589*^9, 3.6070875519163957`*^9, 
   3.6070879311369267`*^9, 3.6070880818371377`*^9, 3.6070886436179237`*^9, 
   3.6070895685002193`*^9, 3.607089628030302*^9, 3.6070926261416683`*^9, 
   3.619084940995474*^9, 3.6229569263006325`*^9, 3.6426665153380146`*^9, {
   3.642758185511819*^9, 3.642758194251831*^9}, 3.643350522817388*^9, 
   3.6439958625073094`*^9, 3.6439959304674044`*^9, 3.6440359349852*^9, 
   3.644036054165366*^9, 3.6440365374170427`*^9, 3.6440366204771595`*^9, 
   3.6440377598697543`*^9, 3.6450048382917433`*^9, 3.6450103923837104`*^9, 
   3.6450108513253527`*^9, 3.6463712529692774`*^9, 3.647254735413658*^9, 
   3.647254962017619*^9, 3.647256114137517*^9, 3.6472562987650766`*^9, {
   3.647256385298026*^9, 3.6472564144946966`*^9}, {3.647328714351227*^9, 
   3.647328729441248*^9}, 3.6482642322686477`*^9, 3.6482650492311945`*^9, 
   3.648350175524249*^9, 3.6490027429261074`*^9, 3.649172453956357*^9, 
   3.6492142975325904`*^9, 3.6492143324626393`*^9, 3.6799843424418406`*^9, 
   3.6975461845820875`*^9, 3.6975462345031586`*^9, 3.7282077891307077`*^9, 
   3.728208067918124*^9, 3.7282096363870444`*^9, 3.728209703183135*^9, 
   3.7287924329161325`*^9, {3.839150626107013*^9, 3.839150649686705*^9}, 
   3.8391507174633613`*^9, 3.8391507531004004`*^9, 3.8391509040449004`*^9, 
   3.8396764050044093`*^9, 3.839676446763956*^9, 3.840027641877675*^9, 
   3.840028375532195*^9, 3.8400290545368376`*^9, 3.8449217820576506`*^9, 
   3.8630804643416395`*^9, 3.863170698932492*^9, {3.958384237428219*^9, 
   3.9583842673811016`*^9}},
 CellLabel->
  "Out[373]=",ExpressionUUID->"88bc6879-5727-934c-8156-c33a224feda9"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowToolbars->"EditBar",
WindowSize->{882, 806.5},
WindowMargins->{{Automatic, 329}, {Automatic, 76.5}},
ShowSelection->True,
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]]}, Visible -> False, 
  FrontEndVersion -> "14.1 for Microsoft Windows (64-bit) (July 16, 2024)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"c5adeb32-f629-4144-be3c-a9e009712cec"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 543, 9, 96, "Title",ExpressionUUID->"6f880094-9dab-4837-94e7-8a6701328358"],
Cell[1113, 33, 496, 8, 52, "Subtitle",ExpressionUUID->"67ee7837-b726-4bc4-8ce6-9b89f5aa46fe"],
Cell[1612, 43, 1782, 29, 246, "Subsubtitle",ExpressionUUID->"98a13709-b737-4068-9b03-af4efdd40af7"],
Cell[3397, 74, 1101, 23, 99, "Text",ExpressionUUID->"4d5f45eb-afe2-46a9-84e1-d2d265874e55"],
Cell[CellGroupData[{
Cell[4523, 101, 205, 4, 28, "Input",ExpressionUUID->"72c1b1f7-df50-4873-bff6-f70f796b7795"],
Cell[4731, 107, 12474, 174, 32, "Output",ExpressionUUID->"1205e731-76d3-314a-aab2-b51e7533c863"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17242, 286, 4476, 65, 44, "Input",ExpressionUUID->"24adaa30-bb78-4a74-a433-410c0b6c0f3a",
 InitializationCell->True],
Cell[21721, 353, 876, 16, 32, "Output",ExpressionUUID->"6fe10e00-6afa-4e4a-94de-7a74887da5bd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22634, 374, 256, 7, 53, "Subsection",ExpressionUUID->"70826498-dcb5-4e71-b60e-47489e5eb564"],
Cell[22893, 383, 94, 0, 43, "Subsubsection",ExpressionUUID->"0886241c-cc9d-4feb-a35f-4dc3af1b9335"],
Cell[CellGroupData[{
Cell[23012, 387, 88, 0, 35, "Subsubsection",ExpressionUUID->"ce757d05-1fc4-4607-a839-20c8f5bb25b5"],
Cell[23103, 389, 3754, 75, 367, "Input",ExpressionUUID->"a58e9110-a380-4f7c-b4db-f3cefd868167",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[26894, 469, 97, 0, 35, "Subsubsection",ExpressionUUID->"09c196d2-58a9-42f0-9b79-138d532abf0d"],
Cell[26994, 471, 2243, 53, 482, "Input",ExpressionUUID->"30491853-cf28-49d3-9cc8-4e2d4f2beb4b",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[29274, 529, 97, 0, 35, "Subsubsection",ExpressionUUID->"0753a3b2-eb22-47c3-af26-0aa9348f4fea"],
Cell[29374, 531, 747, 16, 63, "Input",ExpressionUUID->"e8af212a-d1dd-4aaa-b934-abf8e2f2f59e",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[30146, 551, 202, 2, 28, "Input",ExpressionUUID->"3e51c4d6-39f3-4d8a-b882-cddba51a5ee2"],
Cell[30351, 555, 1107, 15, 70, "Output",ExpressionUUID->"e270f5fc-8710-3441-ad8b-9bab9abfb45e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31495, 575, 242, 3, 28, "Input",ExpressionUUID->"77cf01ec-34f5-426a-bad5-6c6380cf06b9"],
Cell[31740, 580, 1103, 15, 70, "Output",ExpressionUUID->"f2443ba3-6617-524e-958f-627c95a47c88"]
}, Open  ]],
Cell[32858, 598, 894, 32, 33, "Text",ExpressionUUID->"c35d76c3-fdf3-4ded-9669-169a5980ead1"],
Cell[CellGroupData[{
Cell[33777, 634, 1034, 18, 63, "Input",ExpressionUUID->"1a34fde2-1556-4922-b179-2fabba33b839",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[34836, 656, 916, 15, 70, "Print",ExpressionUUID->"cd3da268-46a6-9642-aac2-c14bba83537e"],
Cell[35755, 673, 1188, 23, 70, "Print",ExpressionUUID->"477ae80a-8bd6-4240-a3aa-100c3dbbb860"],
Cell[36946, 698, 937, 15, 70, "Print",ExpressionUUID->"e201a790-1885-2745-b371-3128c86ffdda"],
Cell[37886, 715, 896, 14, 70, "Print",ExpressionUUID->"6b93f7c7-3fdb-9f41-a0e6-ac9e7c1158e1"],
Cell[38785, 731, 877, 14, 70, "Print",ExpressionUUID->"f03aa23a-5387-8d43-bda4-bae7518039e1"],
Cell[39665, 747, 916, 15, 70, "Print",ExpressionUUID->"49cb9a10-a263-a946-99d8-0cf1fc48da9b"],
Cell[40584, 764, 1194, 23, 70, "Print",ExpressionUUID->"25e487df-05dc-774c-9345-40d48fc50517"],
Cell[41781, 789, 937, 15, 70, "Print",ExpressionUUID->"40952512-2255-6a48-8f9c-95e35aba4ea4"],
Cell[42721, 806, 914, 15, 70, "Print",ExpressionUUID->"78550b9a-6cdf-dc49-ac06-d78cd1c1328f"],
Cell[43638, 823, 1204, 23, 70, "Print",ExpressionUUID->"eb7f2cfb-f6d4-a848-9547-6251c578edbb"],
Cell[44845, 848, 941, 15, 70, "Print",ExpressionUUID->"3f8f7486-0111-3343-81e3-eea520b23fb0"],
Cell[45789, 865, 914, 15, 70, "Print",ExpressionUUID->"658e6cfb-06c0-fd49-9c70-857c42533e49"],
Cell[46706, 882, 1188, 23, 70, "Print",ExpressionUUID->"ded4c2e1-7208-814d-90e3-c4572f48c546"],
Cell[47897, 907, 984, 16, 70, "Print",ExpressionUUID->"95f6bac5-f0f8-4a4d-a711-72fa2a96e3fb"],
Cell[48884, 925, 912, 15, 70, "Print",ExpressionUUID->"bb302bf0-7e81-7f4f-9ded-d5f2b5d397e8"],
Cell[49799, 942, 1184, 23, 70, "Print",ExpressionUUID->"f33f45e1-c2ce-2b49-945f-1b61a85607b2"],
Cell[50986, 967, 951, 15, 70, "Print",ExpressionUUID->"9067087f-272f-b847-b0e3-e3b7214214da"],
Cell[51940, 984, 914, 15, 70, "Print",ExpressionUUID->"bc065bd6-aaa6-6d41-b067-65971d2f05b4"],
Cell[52857, 1001, 1190, 23, 70, "Print",ExpressionUUID->"45a2b2e7-567a-b340-bcd9-d25c623016f8"],
Cell[54050, 1026, 971, 15, 70, "Print",ExpressionUUID->"12c5d1b3-8a63-404b-a775-208879635102"],
Cell[55024, 1043, 912, 15, 70, "Print",ExpressionUUID->"e733a719-14f2-7543-bb28-bc41ce22c90f"],
Cell[55939, 1060, 1192, 23, 70, "Print",ExpressionUUID->"ad447df1-0b9a-9043-a2ad-fe97d29594c1"],
Cell[57134, 1085, 961, 15, 70, "Print",ExpressionUUID->"b7ed5d1d-40f0-4f4c-a96a-2d40046fd785"]
}, Open  ]],
Cell[58110, 1103, 1156, 16, 70, "Output",ExpressionUUID->"96488b75-8b7e-2242-a587-03b0292785fa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59303, 1124, 245, 3, 28, "Input",ExpressionUUID->"73bbe32e-571a-41c5-acc2-ab24303ceac0"],
Cell[59551, 1129, 1091, 15, 70, "Output",ExpressionUUID->"30808b50-0a08-b847-adc1-917935da8c7b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60679, 1149, 1258, 25, 101, "Input",ExpressionUUID->"ee2ea5ef-09fd-4b23-ab91-34301e2a0df5",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[61962, 1178, 12251, 170, 70, "Print",ExpressionUUID->"981b315a-0283-3946-8e25-c21f1023ae41"],
Cell[74216, 1350, 12522, 177, 70, "Print",ExpressionUUID->"d9f88489-0402-0740-9fbe-50d20da7d7ce"],
Cell[86741, 1529, 12295, 170, 70, "Print",ExpressionUUID->"69100a3b-827a-814a-8e45-82df9979169b"]
}, Open  ]]
}, Open  ]],
Cell[99063, 1703, 243, 4, 55, "Text",ExpressionUUID->"df7f7f02-31ed-4f7f-b6d1-daaea5984a1e"],
Cell[99309, 1709, 1878, 30, 405, "Input",ExpressionUUID->"c5505a26-6a6b-4094-b977-0a47d9c5af97",
 InitializationCell->True],
Cell[101190, 1741, 347, 10, 33, "Text",ExpressionUUID->"5c10de1c-a608-4908-b83b-7ebfc7bd5d06"],
Cell[CellGroupData[{
Cell[101562, 1755, 1183, 25, 177, "Input",ExpressionUUID->"d38dc3c0-7f34-45f6-96a7-ffb97dad0214",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[102770, 1784, 12267, 170, 70, "Print",ExpressionUUID->"dad14f96-fab4-064a-bf33-bf0e6ead647d"],
Cell[115040, 1956, 12422, 172, 70, "Print",ExpressionUUID->"5bdd1703-207e-5d40-9906-d72c0905960a"],
Cell[127465, 2130, 12267, 170, 70, "Print",ExpressionUUID->"c82b5d1f-5842-f247-950e-de739acdbbf3"]
}, Open  ]]
}, Open  ]],
Cell[139759, 2304, 196, 5, 33, "Text",ExpressionUUID->"91eb080c-735b-47e3-bd25-17300737abd3"],
Cell[CellGroupData[{
Cell[139980, 2313, 117, 1, 28, "Input",ExpressionUUID->"5e881a07-ebfb-47b4-8bf7-ed1fd724c51b"],
Cell[140100, 2316, 1435, 21, 70, "Output",ExpressionUUID->"4e47b0fb-6558-dc47-a4f3-cac3d96387bd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141572, 2342, 563, 10, 47, "Input",ExpressionUUID->"b77ec0a7-fb0c-4e48-8b53-7095892cffeb"],
Cell[142138, 2354, 1433, 21, 70, "Output",ExpressionUUID->"6d69cf9c-90a8-bd48-8679-3cd76efffd8a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143608, 2380, 113, 1, 28, "Input",ExpressionUUID->"95ca7771-6a5d-45f5-ae9a-4cce08f67426"],
Cell[143724, 2383, 1107, 15, 70, "Output",ExpressionUUID->"bf4b960e-9617-b344-900e-5bdbacef9d4b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144868, 2403, 243, 3, 28, "Input",ExpressionUUID->"ceb7d0ac-bc1e-451e-9799-6b52cf8b9585"],
Cell[145114, 2408, 1114, 15, 70, "Output",ExpressionUUID->"e60ddf31-be47-644b-b3bf-ce630ec2f0e7"]
}, Open  ]],
Cell[146243, 2426, 188, 3, 33, "Text",ExpressionUUID->"03c822ac-c3ea-4d53-bcdd-0718505a2fb5"],
Cell[CellGroupData[{
Cell[146456, 2433, 180, 2, 28, "Input",ExpressionUUID->"da86f24c-2580-435b-8b44-26ddf1e21aa1"],
Cell[146639, 2437, 12083, 166, 70, "Output",ExpressionUUID->"442fce38-7e22-fb4b-a8a6-1632449a4ea6"]
}, Open  ]]
}, Closed]],
Cell[158749, 2607, 176, 3, 35, "Subsubsection",ExpressionUUID->"ebd94145-228c-4b3b-b738-b17f8d86441b"],
Cell[CellGroupData[{
Cell[158950, 2614, 248, 5, 35, "Subsubsection",ExpressionUUID->"773287f2-a634-4944-90d5-cde852675271",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[159223, 2623, 22597, 430, 2460, "Input",ExpressionUUID->"1e43a7e6-2907-42db-aa08-1e97775a32aa",
 InitializationCell->True],
Cell[181823, 3055, 340, 4, 51, "Output",ExpressionUUID->"441ef8fc-1c54-6742-99e8-893943531d54"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[182212, 3065, 196, 4, 35, "Subsubsection",ExpressionUUID->"6183166b-1876-4f7c-a21c-368147392322"],
Cell[CellGroupData[{
Cell[182433, 3073, 180, 3, 44, "Input",ExpressionUUID->"52435f4b-6b87-4002-ac1d-2fe30a59a5f9",
 InitializationCell->True],
Cell[182616, 3078, 1163, 16, 32, "Output",ExpressionUUID->"f31b2d68-697b-5041-83b1-3baeababc11a"]
}, Open  ]],
Cell[183794, 3097, 525, 8, 33, "Text",ExpressionUUID->"0d8ccdfd-9ea1-4fd7-b800-87ce42c2190b"],
Cell[CellGroupData[{
Cell[184344, 3109, 403, 7, 28, "Input",ExpressionUUID->"8f0b1470-25b8-41e0-8cf4-1de02677fabf"],
Cell[184750, 3118, 13952, 196, 203, "Output",ExpressionUUID->"a1398ba5-6615-ec43-9d95-a1cd1eb696cc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198739, 3319, 138, 3, 28, "Input",ExpressionUUID->"9e795ee4-fa4a-40a8-82bf-00c6bfb6dc12"],
Cell[198880, 3324, 12078, 167, 32, "Output",ExpressionUUID->"235b86f8-f437-ed45-a7db-2e7cb5b68b29"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210995, 3496, 148, 3, 44, "Input",ExpressionUUID->"519f7bc8-9374-4a40-9f0f-c4c74682e61b",
 InitializationCell->True],
Cell[211146, 3501, 1476, 23, 51, "Output",ExpressionUUID->"e149e4eb-69e6-1446-8405-3ce497795bd5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[212659, 3529, 117, 2, 28, "Input",ExpressionUUID->"8dea597f-19e8-44bb-bea7-dd6dadc276c1"],
Cell[212779, 3533, 1115, 16, 32, "Output",ExpressionUUID->"e008f733-0ade-764f-ac80-8b6dcbdeb721"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[213955, 3556, 482, 8, 53, "Subsection",ExpressionUUID->"7312c92b-59fe-4b2a-8a1e-413b4393a5f0",
 InitializationCell->True],
Cell[214440, 3566, 780, 15, 143, "Text",ExpressionUUID->"b77f7a08-1380-48dd-a271-8a08f5280261"],
Cell[215223, 3583, 416, 9, 44, "Input",ExpressionUUID->"69e974ae-2675-4005-a07a-f65143949571",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[215676, 3597, 393, 7, 53, "Subsection",ExpressionUUID->"2c4e91b1-8ad7-428a-9d95-655419608b83",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[216094, 3608, 222, 4, 43, "Subsubsection",ExpressionUUID->"28ffa8e3-04f2-4eab-87b8-f23e5ce2a709"],
Cell[216319, 3614, 769, 20, 82, "Input",ExpressionUUID->"ddd7d09b-ed6a-4cd4-9469-912b5a389dcb",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[217125, 3639, 189, 3, 35, "Subsubsection",ExpressionUUID->"36327dc2-5fb5-46f0-82ce-61d26def5ffc"],
Cell[217317, 3644, 389, 10, 44, "Input",ExpressionUUID->"eb1a694d-b813-475f-b3f5-19845ed34250",
 InitializationCell->True],
Cell[217709, 3656, 611, 17, 82, "Input",ExpressionUUID->"eda632b9-f89e-4b8e-a781-3307159039eb",
 InitializationCell->True],
Cell[218323, 3675, 977, 25, 82, "Input",ExpressionUUID->"4f704b8e-62a3-48a2-8dba-2ea58bc64414",
 InitializationCell->True],
Cell[219303, 3702, 4055, 92, 253, "Input",ExpressionUUID->"075d1695-b66e-4c65-977b-804f8ad21895",
 InitializationCell->True],
Cell[223361, 3796, 233, 4, 33, "Text",ExpressionUUID->"8bb47fb2-b432-4837-ba6e-73d9397ee31b"],
Cell[223597, 3802, 5919, 147, 615, "Input",ExpressionUUID->"304c69d0-03bd-41ac-9cb3-370c76e1d6e9",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[229553, 3954, 256, 4, 35, "Subsubsection",ExpressionUUID->"4cdec2f0-04b6-4103-a111-83157f3a6f37"],
Cell[229812, 3960, 1224, 30, 82, "Input",ExpressionUUID->"46df5fd8-e65d-4be4-b045-7a3d8c678181",
 InitializationCell->True],
Cell[231039, 3992, 1837, 54, 139, "Input",ExpressionUUID->"3b1c74da-aa6e-46d6-a6c2-b8465996a782",
 InitializationCell->True],
Cell[232879, 4048, 779, 23, 63, "Input",ExpressionUUID->"9d63dc88-a343-4b77-ade3-9c51100b07bb",
 InitializationCell->True],
Cell[233661, 4073, 484, 12, 44, "Input",ExpressionUUID->"dd113303-f598-486f-9fea-715b5ffb5235",
 InitializationCell->True],
Cell[234148, 4087, 541, 14, 44, "Input",ExpressionUUID->"f284edf3-2592-42bc-948f-cf9ba51fde83",
 InitializationCell->True],
Cell[234692, 4103, 1487, 41, 120, "Input",ExpressionUUID->"485ce97e-22dd-44f2-b685-f9323163f15f",
 InitializationCell->True],
Cell[236182, 4146, 1615, 46, 139, "Input",ExpressionUUID->"6e3f1310-b5b8-42d5-a559-3d8cd2501b21",
 InitializationCell->True],
Cell[237800, 4194, 782, 18, 101, "Input",ExpressionUUID->"c0c537eb-3af4-4048-a919-37a6402b7e12",
 InitializationCell->True],
Cell[238585, 4214, 667, 16, 82, "Input",ExpressionUUID->"34184e2f-eea5-4c88-b77a-ba535334bbef",
 InitializationCell->True],
Cell[239255, 4232, 206, 6, 44, "Input",ExpressionUUID->"691f76bb-7c18-495b-b753-72a5abca7e4a",
 InitializationCell->True],
Cell[239464, 4240, 3763, 118, 272, "Input",ExpressionUUID->"92a12f91-ce2b-4f34-89cf-018b3e76d735",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[243264, 4363, 599, 9, 35, "Subsubsection",ExpressionUUID->"3e688684-cb10-4391-83d5-98ad70c62658"],
Cell[243866, 4374, 654, 19, 63, "Input",ExpressionUUID->"279edba8-7c24-4874-91ac-e3f568a9fe14",
 InitializationCell->True],
Cell[244523, 4395, 251, 7, 44, "Input",ExpressionUUID->"5b0e66bf-0455-473f-8112-729bcc490eb2",
 InitializationCell->True],
Cell[244777, 4404, 414, 12, 44, "Input",ExpressionUUID->"5e157419-a66a-4f46-a195-13a5ae13f4d2",
 InitializationCell->True],
Cell[245194, 4418, 931, 25, 82, "Input",ExpressionUUID->"72e4655a-e899-4b5c-bce4-c3327aa1fbbd",
 InitializationCell->True],
Cell[246128, 4445, 1988, 54, 120, "Input",ExpressionUUID->"9d102934-9801-4eb3-b5da-916893a458a6",
 InitializationCell->True],
Cell[248119, 4501, 1163, 33, 82, "Input",ExpressionUUID->"7910d4c0-4566-4cdb-98a9-f0b22ca8812e",
 InitializationCell->True],
Cell[249285, 4536, 1973, 60, 139, "Input",ExpressionUUID->"47849868-a21f-4a6b-899d-ff8affac9b40",
 InitializationCell->True],
Cell[251261, 4598, 229, 5, 33, "Text",ExpressionUUID->"a5b79cc8-90c5-49e3-a516-803d740a6bc5"],
Cell[251493, 4605, 899, 27, 63, "Input",ExpressionUUID->"0d8523dd-6ac4-4c9f-921d-5bac23f35ac3",
 InitializationCell->True],
Cell[252395, 4634, 454, 14, 63, "Input",ExpressionUUID->"cfb2ef23-47e1-483b-b4ca-c5e97d1b6068",
 InitializationCell->True],
Cell[252852, 4650, 706, 18, 82, "Input",ExpressionUUID->"13fc7bb0-da63-4000-aae0-3f54dfaea3e8",
 InitializationCell->True],
Cell[253561, 4670, 1977, 52, 101, "Input",ExpressionUUID->"0bcfb45c-deec-4845-a119-751af86d6654",
 InitializationCell->True],
Cell[255541, 4724, 2558, 68, 196, "Input",ExpressionUUID->"bf94af3d-0008-431e-827a-b78fb93cda5e",
 InitializationCell->True],
Cell[258102, 4794, 817, 19, 63, "Input",ExpressionUUID->"8fee5ed6-4814-455c-8177-d382c3a89147",
 InitializationCell->True],
Cell[258922, 4815, 873, 20, 63, "Input",ExpressionUUID->"9a5fa022-edc5-4042-ac4c-67afb8672d5c",
 InitializationCell->True],
Cell[259798, 4837, 1521, 40, 120, "Input",ExpressionUUID->"556782ae-2100-445c-a22f-8504f1c0f279",
 InitializationCell->True],
Cell[261322, 4879, 985, 20, 63, "Input",ExpressionUUID->"5b9f4b19-5e6f-4cc5-8fe3-e2dfead1e2d0",
 InitializationCell->True],
Cell[262310, 4901, 494, 12, 63, "Input",ExpressionUUID->"07755b8a-3448-41a3-ad66-13da90ce329f",
 InitializationCell->True],
Cell[262807, 4915, 394, 10, 44, "Input",ExpressionUUID->"75885b45-5ca1-46b7-90be-3cd560f9dc1b",
 InitializationCell->True],
Cell[263204, 4927, 650, 17, 63, "Input",ExpressionUUID->"92c2205e-29ff-4525-8565-10076100b3f4",
 InitializationCell->True],
Cell[263857, 4946, 1585, 45, 139, "Input",ExpressionUUID->"e6ee073d-b043-4dca-b9ad-1abb15be6dc3",
 InitializationCell->True],
Cell[265445, 4993, 855, 20, 82, "Input",ExpressionUUID->"05ec62d5-b588-449a-93f2-7ffb3e1210c4",
 InitializationCell->True],
Cell[266303, 5015, 773, 19, 63, "Input",ExpressionUUID->"e6c26a40-109e-4b74-8bd4-c52d5728f7ab",
 InitializationCell->True],
Cell[267079, 5036, 2539, 66, 177, "Input",ExpressionUUID->"29be9550-9471-411f-8674-e4857a6cd6eb",
 InitializationCell->True],
Cell[269621, 5104, 519, 13, 63, "Input",ExpressionUUID->"1488afce-5966-4acb-9e85-a1af97b8068f",
 InitializationCell->True],
Cell[270143, 5119, 284, 7, 50, "Code",ExpressionUUID->"307566e8-9efd-4379-9357-4ce030e4d900"],
Cell[270430, 5128, 694, 20, 63, "Input",ExpressionUUID->"a9f55ee2-864f-44da-b172-2008d4d2b254",
 InitializationCell->True],
Cell[271127, 5150, 459, 14, 63, "Input",ExpressionUUID->"1529ec42-8a6f-45f5-a3e3-35aff183824f",
 InitializationCell->True],
Cell[271589, 5166, 326, 8, 44, "Input",ExpressionUUID->"af385adc-76d4-48ca-a9e1-2e1181f2eca3",
 InitializationCell->True],
Cell[271918, 5176, 863, 25, 82, "Input",ExpressionUUID->"9ef1423f-11c0-45da-a66b-f00085213a01",
 InitializationCell->True],
Cell[272784, 5203, 1946, 49, 120, "Code",ExpressionUUID->"9dd9d863-b24e-49d7-a70b-1316e242f378"],
Cell[274733, 5254, 457, 11, 50, "Code",ExpressionUUID->"f405f76a-4799-4a4a-9519-5d0f8537b540"],
Cell[275193, 5267, 545, 14, 63, "Input",ExpressionUUID->"c285175e-e855-4c4b-9412-2d7560318e74",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[275775, 5286, 179, 3, 35, "Subsubsection",ExpressionUUID->"3fee42f7-364e-4c00-86c6-4b9e1bd97f95"],
Cell[275957, 5291, 327, 9, 44, "Input",ExpressionUUID->"2d475a87-baeb-46e4-816d-6bc2ab396c45",
 InitializationCell->True],
Cell[276287, 5302, 64292, 1616, 3069, "Input",ExpressionUUID->"39e3779e-28ae-441d-989f-36ea89cf2533",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[340616, 6923, 387, 6, 35, "Subsubsection",ExpressionUUID->"b1a19ce2-a611-4efa-b2e5-aa27e1415649"],
Cell[341006, 6931, 2564, 76, 158, "Input",ExpressionUUID->"0e1d9e8b-2714-42ea-8b64-307ac50d319c",
 InitializationCell->True],
Cell[343573, 7009, 555, 14, 63, "Input",ExpressionUUID->"2a2ed514-4a9a-4704-8fbf-dcd897f79059",
 InitializationCell->True],
Cell[344131, 7025, 1572, 44, 139, "Input",ExpressionUUID->"2594f83c-ad31-4b94-9f3b-ab87ca712557",
 InitializationCell->True],
Cell[345706, 7071, 558, 14, 67, "Code",ExpressionUUID->"981fdfe6-b197-4fd2-8afe-2d7446fcfc37"],
Cell[346267, 7087, 164, 3, 33, "Text",ExpressionUUID->"16d5e040-3480-43bf-9fc7-fcc74b1f12c6"],
Cell[346434, 7092, 504, 14, 28, "Input",ExpressionUUID->"6c23bbc9-c0ec-4b99-a84f-6536b59908a1"],
Cell[346941, 7108, 552, 15, 28, "Input",ExpressionUUID->"4facbb3a-353b-4c5b-8e22-3990a58e1234"],
Cell[347496, 7125, 846, 22, 47, "Input",ExpressionUUID->"fd2d6765-0b64-4c23-accf-a21c70840213"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[348391, 7153, 385, 7, 53, "Subsection",ExpressionUUID->"a31e7942-4b03-45c0-a46d-107de1aa0d96",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[348801, 7164, 223, 4, 43, "Subsubsection",ExpressionUUID->"95064bca-7106-4024-b5bc-7410b24d3e99"],
Cell[349027, 7170, 380, 10, 44, "Input",ExpressionUUID->"129a616e-035c-4908-889d-017686535231",
 InitializationCell->True],
Cell[349410, 7182, 426, 13, 44, "Input",ExpressionUUID->"0dfc518a-f3d9-44d1-af8a-ce3eeaa19002",
 InitializationCell->True],
Cell[349839, 7197, 2304, 61, 139, "Input",ExpressionUUID->"b29c1e8e-d94f-4bb6-9755-c34de81e5207",
 InitializationCell->True],
Cell[352146, 7260, 675, 18, 63, "Input",ExpressionUUID->"11f77082-1e45-477a-b27d-65fa173bc4d2",
 InitializationCell->True],
Cell[352824, 7280, 486, 12, 50, "Code",ExpressionUUID->"76da42cf-0f8f-9748-a1be-982af92f040d"],
Cell[353313, 7294, 4495, 112, 329, "Input",ExpressionUUID->"cdfd35b0-f73c-46dd-b0e5-aa06d768c5fd",
 InitializationCell->True],
Cell[357811, 7408, 2688, 71, 177, "Input",ExpressionUUID->"d83fe5de-3b65-4f7d-9f74-7f9ae75a8a8f",
 InitializationCell->True],
Cell[360502, 7481, 2392, 63, 142, "Input",ExpressionUUID->"cd8f99c4-7112-4e5d-9bec-223685fce152"],
Cell[362897, 7546, 1275, 37, 101, "Input",ExpressionUUID->"6a12aa5b-287a-4d07-a345-d99423192a0f",
 InitializationCell->True],
Cell[364175, 7585, 229, 5, 33, "Text",ExpressionUUID->"d3cc56a9-e7b6-4c84-927b-0ff6ba219d0c"],
Cell[364407, 7592, 3221, 95, 215, "Input",ExpressionUUID->"d9f85a39-3770-4935-a58b-e2071dd847af",
 InitializationCell->True],
Cell[367631, 7689, 817, 23, 63, "Input",ExpressionUUID->"a74746a4-4467-47a8-89fa-0e4fc032b474",
 InitializationCell->True],
Cell[368451, 7714, 939, 25, 82, "Input",ExpressionUUID->"1d07cc2c-ec7d-4e45-8b46-05fdbb47845c",
 InitializationCell->True],
Cell[369393, 7741, 751, 20, 82, "Input",ExpressionUUID->"ea271608-b3b2-4d80-9d59-e5658fe2734f",
 InitializationCell->True],
Cell[370147, 7763, 1699, 43, 158, "Input",ExpressionUUID->"c7e9fc76-3f85-4c82-b3c4-3a62a6b1292d",
 InitializationCell->True],
Cell[371849, 7808, 1395, 38, 120, "Input",ExpressionUUID->"81fdb2c7-0792-41c4-b07f-2463730ddb9d",
 InitializationCell->True],
Cell[373247, 7848, 829, 22, 82, "Input",ExpressionUUID->"eebfc304-a5e2-5445-b0ec-2a8f3ca59753",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[374113, 7875, 344, 5, 35, "Subsubsection",ExpressionUUID->"a78e59e2-886b-1b4e-9b75-5ddd1d6e1679"],
Cell[374460, 7882, 269, 6, 33, "Text",ExpressionUUID->"5ee804df-52ad-4f73-bbd0-448af8d2bf83"],
Cell[374732, 7890, 619, 18, 44, "Input",ExpressionUUID->"4bbb713c-4766-468b-b33a-c867c138b4ac",
 InitializationCell->True],
Cell[375354, 7910, 170, 3, 33, "Text",ExpressionUUID->"26f7e7c0-8a5d-498a-bf5f-5cf30ed287d0"],
Cell[375527, 7915, 32646, 850, 938, "Input",ExpressionUUID->"770d88fd-7d6d-46ce-9f03-9a749390ab9b",
 InitializationCell->True],
Cell[408176, 8767, 3094, 73, 120, "Input",ExpressionUUID->"90d6497c-2544-4a2c-bd65-cf23289014ca",
 InitializationCell->True],
Cell[411273, 8842, 392, 8, 55, "Text",ExpressionUUID->"7afa05fe-89c9-4f74-a672-2e6d267f8c65"],
Cell[411668, 8852, 1519, 40, 82, "Input",ExpressionUUID->"98585b23-580d-4bbe-ae4d-f9fcc7472ea0",
 InitializationCell->True],
Cell[413190, 8894, 5526, 147, 177, "Input",ExpressionUUID->"6cb47521-09f3-41a9-85ad-5af86e612e73",
 InitializationCell->True],
Cell[418719, 9043, 157, 3, 33, "Text",ExpressionUUID->"5cbefc96-09a2-2540-a4b8-abf0d952f845"],
Cell[418879, 9048, 13100, 352, 424, "Input",ExpressionUUID->"42d1367d-e892-f544-a74b-29bc857d84b9",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[432016, 9405, 283, 6, 35, "Subsubsection",ExpressionUUID->"c37dcb1b-5f9c-4031-bed4-d851dffe653b"],
Cell[432302, 9413, 6107, 153, 348, "Input",ExpressionUUID->"2883df3c-aa13-44ce-9ebe-9fe11b55dd2f",
 InitializationCell->True],
Cell[438412, 9568, 408, 10, 44, "Input",ExpressionUUID->"5993a9df-08d6-4520-89af-40ecbd54491d",
 InitializationCell->True],
Cell[438823, 9580, 34412, 851, 1052, "Input",ExpressionUUID->"a5fdbd71-0eca-4563-b385-0e5f84b9996b",
 InitializationCell->True],
Cell[473238, 10433, 2739, 78, 120, "Input",ExpressionUUID->"5745b62e-9bd2-477e-b47a-5dca8470a755",
 InitializationCell->True],
Cell[475980, 10513, 410, 10, 44, "Input",ExpressionUUID->"21ce6db1-cd18-4dd4-86da-a746c8d24d8c",
 InitializationCell->True],
Cell[476393, 10525, 3567, 90, 234, "Input",ExpressionUUID->"7fd1c544-e119-4fe2-98d2-acb5be41fe73",
 InitializationCell->True],
Cell[479963, 10617, 659, 19, 44, "Input",ExpressionUUID->"2cd0bd95-7955-4368-90a9-16f726e8410a",
 InitializationCell->True],
Cell[480625, 10638, 588, 15, 67, "Code",ExpressionUUID->"ffea4ddb-58ed-4845-b1c3-a17123f1f5a4"],
Cell[481216, 10655, 1848, 54, 63, "Input",ExpressionUUID->"44d37725-a70a-4e5e-a38a-9c156a87b58f",
 InitializationCell->True],
Cell[483067, 10711, 1855, 54, 63, "Input",ExpressionUUID->"34ad20b0-80cd-4b88-bb49-ee3722b51147",
 InitializationCell->True],
Cell[484925, 10767, 905, 25, 44, "Input",ExpressionUUID->"296d17e8-0c78-461f-afd6-3e0c2da54766",
 InitializationCell->True],
Cell[485833, 10794, 2768, 79, 101, "Input",ExpressionUUID->"baf7e029-da28-4c8f-8a29-d3e001524f4c",
 InitializationCell->True],
Cell[488604, 10875, 3749, 97, 291, "Input",ExpressionUUID->"d6658b17-f77d-4457-8dec-4ba6f4c5335c",
 InitializationCell->True],
Cell[492356, 10974, 8938, 223, 348, "Input",ExpressionUUID->"b37b9ed8-b374-45d3-9a63-9e5e75822388",
 InitializationCell->True],
Cell[501297, 11199, 599, 14, 50, "Code",ExpressionUUID->"7b8dc0fb-7054-4bba-b619-327e94278320"]
}, Closed]],
Cell[CellGroupData[{
Cell[501933, 11218, 281, 4, 35, "Subsubsection",ExpressionUUID->"a16cbeed-3503-434f-aed3-d4fa91c9f1c9"],
Cell[502217, 11224, 201, 4, 33, "Text",ExpressionUUID->"879831ce-0f5f-ce40-ab7d-0ef12fa806de"],
Cell[502421, 11230, 5104, 120, 500, "Input",ExpressionUUID->"c656688e-5b3b-fa46-a9fc-f05e1a334824",
 InitializationCell->True],
Cell[507528, 11352, 156, 3, 33, "Text",ExpressionUUID->"0b6cc421-d2e7-2346-a658-0e9794bf6d03"],
Cell[507687, 11357, 9261, 215, 386, "Input",ExpressionUUID->"70049b08-9591-8244-a0e9-6d76e82990c0",
 InitializationCell->True],
Cell[516951, 11574, 13396, 318, 462, "Input",ExpressionUUID->"75044a23-d9b1-e348-b63e-1c305b893f3a",
 InitializationCell->True],
Cell[530350, 11894, 11711, 272, 405, "Input",ExpressionUUID->"89946650-f9d9-d44c-819b-52b8572c1471",
 InitializationCell->True],
Cell[542064, 12168, 205, 4, 33, "Text",ExpressionUUID->"b694474c-ded1-534b-b5fe-aef6baca937f"],
Cell[542272, 12174, 17460, 411, 481, "Input",ExpressionUUID->"e632dd32-3bc1-e345-b519-278236a8af24",
 InitializationCell->True],
Cell[559735, 12587, 15526, 359, 462, "Input",ExpressionUUID->"c52facd9-9466-064b-8c7a-536323b563a4",
 InitializationCell->True],
Cell[575264, 12948, 15569, 360, 462, "Input",ExpressionUUID->"35ca8dc9-3176-9a41-94b1-1be11ded696c",
 InitializationCell->True],
Cell[590836, 13310, 13742, 312, 462, "Input",ExpressionUUID->"e8b5ff80-b298-8d49-8827-5ddcfc08e455",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[604615, 13627, 98, 0, 35, "Subsubsection",ExpressionUUID->"1967da8a-3dc9-4b1a-b85e-ce28ece19396"],
Cell[604716, 13629, 2931, 81, 177, "Input",ExpressionUUID->"1687fae9-f070-47b2-bc8e-9940bd111451",
 InitializationCell->True],
Cell[607650, 13712, 2395, 66, 158, "Input",ExpressionUUID->"291844db-2743-4b39-a352-37b35e5dbb72",
 InitializationCell->True],
Cell[610048, 13780, 347, 7, 55, "Text",ExpressionUUID->"39aff2ec-aa9f-4e06-9c6e-1dd61b5927c8"],
Cell[610398, 13789, 599, 18, 28, "Input",ExpressionUUID->"dff99eb0-a0ea-454c-b474-b05fcb475f42"],
Cell[611000, 13809, 11099, 270, 576, "Input",ExpressionUUID->"7eb921bb-d411-4112-8457-53870fb4dfbb",
 InitializationCell->True],
Cell[622102, 14081, 4302, 113, 253, "Input",ExpressionUUID->"33ed3a4e-61af-4962-a710-d9c36674f030",
 InitializationCell->True],
Cell[626407, 14196, 222, 5, 33, "Text",ExpressionUUID->"0cf773fb-cfd4-4b99-8305-f4a35eea62b9"],
Cell[626632, 14203, 2885, 74, 161, "Input",ExpressionUUID->"5ebb05f5-d3d2-49a7-9f1e-5574ef6faf34"],
Cell[629520, 14279, 3433, 83, 180, "Input",ExpressionUUID->"0a39a591-f0f2-4d64-bd8f-d3602e818f2b"]
}, Closed]],
Cell[CellGroupData[{
Cell[632990, 14367, 359, 6, 35, "Subsubsection",ExpressionUUID->"c831cb9a-b90b-4dfe-a973-92eb8883f25b"],
Cell[633352, 14375, 8861, 203, 310, "Input",ExpressionUUID->"528dc62e-6c84-4023-9ed1-8f5002384bad",
 InitializationCell->True],
Cell[642216, 14580, 201, 3, 33, "Text",ExpressionUUID->"0bb76bed-e137-4a09-9967-7d6a5757b826"],
Cell[642420, 14585, 1717, 47, 85, "Input",ExpressionUUID->"70b87309-ed89-40f7-8c95-339569af3322"],
Cell[644140, 14634, 172, 3, 33, "Text",ExpressionUUID->"ae650a1f-ac74-4497-ba1c-14c4629d94e8"],
Cell[644315, 14639, 624, 17, 50, "Code",ExpressionUUID->"f5e2c78b-0038-4da2-a311-52e399fda60b"],
Cell[644942, 14658, 227, 6, 33, "Text",ExpressionUUID->"d3392ac7-80eb-4474-a3e8-0a699ae35c2d"],
Cell[645172, 14666, 279, 7, 50, "Code",ExpressionUUID->"1d7a8f4d-73c3-4685-800a-7d5a83b5cfe0"],
Cell[645454, 14675, 2546, 74, 158, "Input",ExpressionUUID->"a16705cf-3329-4272-9313-b0e2b71fb7f3",
 InitializationCell->True],
Cell[648003, 14751, 810, 19, 44, "Input",ExpressionUUID->"819a7949-7aa3-420e-98c5-73b17e4424df",
 InitializationCell->True],
Cell[648816, 14772, 750, 19, 63, "Input",ExpressionUUID->"f386251e-e590-47e0-a0c1-a268ba45e1c0",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[649603, 14796, 183, 3, 35, "Subsubsection",ExpressionUUID->"1f9007b9-9c3f-400a-9035-0426c2b79ac8"],
Cell[649789, 14801, 2309, 47, 120, "Input",ExpressionUUID->"4a6164a3-2d6c-4952-b17c-f28f6d806f14",
 InitializationCell->True],
Cell[652101, 14850, 2333, 53, 177, "Input",ExpressionUUID->"9ad18cd0-131a-49ff-860d-71d188235228",
 InitializationCell->True],
Cell[654437, 14905, 497, 14, 63, "Input",ExpressionUUID->"b12d80fa-09e0-4c37-8e50-7f399a61188a",
 InitializationCell->True],
Cell[654937, 14921, 496, 9, 33, "Text",ExpressionUUID->"31288d3d-d5e9-4e7d-ae53-382139edad58"],
Cell[655436, 14932, 6281, 139, 367, "Input",ExpressionUUID->"2697fbf4-e3c5-4ea2-9d22-fe6083c835d0",
 InitializationCell->True],
Cell[661720, 15073, 252, 6, 33, "Text",ExpressionUUID->"1cba11fb-7c67-4068-a683-04bc1bdd299d"],
Cell[661975, 15081, 910, 26, 63, "Input",ExpressionUUID->"c244cc21-6855-43cd-a4bb-d35d62dfbc63",
 InitializationCell->True],
Cell[662888, 15109, 480, 12, 44, "Input",ExpressionUUID->"21c70763-0ad0-46e4-bcf4-e386c2b9983f",
 InitializationCell->True],
Cell[663371, 15123, 486, 12, 44, "Input",ExpressionUUID->"3fd64fa0-26ec-4394-aaf7-e7f64db79cc8",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[663906, 15141, 446, 7, 53, "Subsection",ExpressionUUID->"4b4c41ca-fe78-cd4f-9d7e-fac84ca0592c",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[664377, 15152, 257, 4, 43, "Subsubsection",ExpressionUUID->"4a06d9ab-fd04-3c44-a31e-1371eb716e17"],
Cell[664637, 15158, 194, 2, 33, "Text",ExpressionUUID->"b9756ec3-3d19-d946-8681-a68085b85a9d"],
Cell[664834, 15162, 28701, 718, 1376, "Input",ExpressionUUID->"1fbdce1b-7485-7643-b7d2-a4f6f096fc8c",
 InitializationCell->True],
Cell[693538, 15882, 2166, 58, 177, "Input",ExpressionUUID->"7222e7c3-17e4-2c4f-8c23-cef4179b901d",
 InitializationCell->True],
Cell[695707, 15942, 777, 22, 63, "Input",ExpressionUUID->"363c8fa5-7fdf-e140-95bd-7635a7946c45",
 InitializationCell->True],
Cell[696487, 15966, 274, 6, 44, "Input",ExpressionUUID->"a9910da1-44d4-3749-bcca-26d6c8e5a1af",
 InitializationCell->True],
Cell[696764, 15974, 593, 16, 44, "Input",ExpressionUUID->"d2e5e3ee-90c0-2841-87a5-fc37ebf05158",
 InitializationCell->True],
Cell[697360, 15992, 1003, 25, 50, "Code",ExpressionUUID->"6951f02f-3799-2143-9147-078e9013bd6d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[698412, 16023, 563, 8, 37, "Subsection",ExpressionUUID->"7317d895-0c99-431c-9ed0-13d5c04d009e"],
Cell[698978, 16033, 1100, 25, 82, "Input",ExpressionUUID->"2c23f1f0-2688-4b57-88b5-08701e047ba3",
 InitializationCell->True],
Cell[700081, 16060, 573, 12, 44, "Input",ExpressionUUID->"f894c297-49c3-4a42-8491-98cb3d05613b",
 InitializationCell->True],
Cell[700657, 16074, 472, 13, 44, "Input",ExpressionUUID->"c20e4803-1dd4-5041-8661-d045754d925a",
 InitializationCell->True],
Cell[701132, 16089, 726, 22, 63, "Input",ExpressionUUID->"321e5d7d-c79c-f247-a887-1ad40f39ebb3",
 InitializationCell->True],
Cell[701861, 16113, 451, 12, 63, "Input",ExpressionUUID->"1e32b5bf-4969-47e8-badb-431eeda110f6",
 InitializationCell->True],
Cell[702315, 16127, 503, 13, 44, "Input",ExpressionUUID->"68b1072a-f040-46dd-82c0-1d0c051e970e",
 InitializationCell->True],
Cell[702821, 16142, 1053, 21, 63, "Input",ExpressionUUID->"338bad9b-75c5-4ddf-9e47-79393f9db5f6",
 InitializationCell->True],
Cell[703877, 16165, 1304, 27, 82, "Input",ExpressionUUID->"c1772828-9da4-4c6a-8c05-c2f4bde10986",
 InitializationCell->True],
Cell[705184, 16194, 2006, 48, 139, "Input",ExpressionUUID->"dda2bca5-e0dc-b64d-bb36-9f7a62a6de23",
 InitializationCell->True],
Cell[707193, 16244, 2061, 48, 139, "Input",ExpressionUUID->"abe0fac3-5302-9d49-be95-d0663ca2ce4c",
 InitializationCell->True],
Cell[709257, 16294, 604, 16, 63, "Input",ExpressionUUID->"4b3965a9-3ecc-2f48-98d9-36ede3e80cfb",
 InitializationCell->True],
Cell[709864, 16312, 1223, 28, 63, "Input",ExpressionUUID->"6af69cf6-ca2b-4bae-894d-209ec82611ac",
 InitializationCell->True],
Cell[711090, 16342, 582, 12, 44, "Input",ExpressionUUID->"2db0804f-3bcd-426b-99cd-4c702ea8161e",
 InitializationCell->True],
Cell[711675, 16356, 562, 14, 44, "Input",ExpressionUUID->"49498c7a-7cea-4076-9e1e-a36e7e4450ee",
 InitializationCell->True],
Cell[712240, 16372, 2774, 63, 177, "Input",ExpressionUUID->"ccbb04c3-91a0-482d-8372-313661ffa445",
 InitializationCell->True],
Cell[715017, 16437, 1049, 27, 101, "Input",ExpressionUUID->"5ae8a992-7d5a-44f1-b6c0-85fd3262c582",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[716103, 16469, 380, 6, 37, "Subsection",ExpressionUUID->"516100c1-a781-47e2-925b-3bb6c6e6db1d"],
Cell[716486, 16477, 258, 7, 64, "Input",ExpressionUUID->"47e66c31-4cd8-4e6a-b1c7-6c555f676ff9",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[716781, 16489, 360, 6, 37, "Subsection",ExpressionUUID->"1ee655f3-96b5-4ac5-9270-72ad022cde2c"],
Cell[717144, 16497, 98, 0, 33, "Text",ExpressionUUID->"9057472d-8969-4492-885e-c6dfc06954c6"],
Cell[CellGroupData[{
Cell[717267, 16501, 202, 4, 28, "Input",ExpressionUUID->"9c10f20e-3afc-4278-816a-9c55805ce7cf"],
Cell[717472, 16507, 586, 11, 32, "Output",ExpressionUUID->"3d6d2cda-91fc-8741-bb3a-65917db7cbd5"]
}, Open  ]],
Cell[718073, 16521, 161, 3, 33, "Text",ExpressionUUID->"756fd65f-beef-4245-be76-76a4997eae5d"],
Cell[718237, 16526, 228, 5, 28, "Input",ExpressionUUID->"76df22be-696c-4138-bac1-8f3e000b4e11"],
Cell[718468, 16533, 163, 4, 28, "Input",ExpressionUUID->"29a56691-45ea-4a28-ab8a-9ccfc2a178b2"],
Cell[718634, 16539, 284, 7, 28, "Input",ExpressionUUID->"d11b8755-a3eb-4081-b0d8-96921aecd1a6"],
Cell[718921, 16548, 527, 11, 28, "Input",ExpressionUUID->"a51bf9c4-0355-4338-bb8c-c2b81b31638b"],
Cell[719451, 16561, 599, 16, 28, "Input",ExpressionUUID->"793821ec-f1d8-4a79-8a2e-5299122eb6b4"],
Cell[720053, 16579, 190, 4, 28, "Input",ExpressionUUID->"5e736c59-e989-46ea-b052-e2495fd034e5"],
Cell[CellGroupData[{
Cell[720268, 16587, 230, 5, 28, "Input",ExpressionUUID->"a59b6ac4-1a0b-41a2-bfd7-21a810cf0d70"],
Cell[720501, 16594, 2345, 36, 32, "Output",ExpressionUUID->"7df12220-cb22-5a43-8013-f2417cd4dd07"]
}, Open  ]],
Cell[722861, 16633, 593, 13, 47, "Input",ExpressionUUID->"17e9545f-fefb-4265-a82d-ef033551d268"],
Cell[723457, 16648, 249, 6, 33, "Text",ExpressionUUID->"79b2d79c-d253-43f3-8203-f96442e15933"],
Cell[723709, 16656, 248, 6, 28, "Input",ExpressionUUID->"eee67161-6851-4b25-a00d-cfbeba0fffda"],
Cell[723960, 16664, 538, 15, 28, "Input",ExpressionUUID->"0c9c389a-b75e-4d3d-ad39-b6d6bdc6b0c5"],
Cell[CellGroupData[{
Cell[724523, 16683, 327, 7, 28, "Input",ExpressionUUID->"e6c0e36c-3057-41e3-9049-6dae6a9050b7"],
Cell[724853, 16692, 2041, 31, 32, "Output",ExpressionUUID->"88bc6879-5727-934c-8156-c33a224feda9"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

