(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    817148,      19119]
NotebookOptionsPosition[    757119,      18129]
NotebookOutlinePosition[    757586,      18148]
CellTagsIndexPosition[    757543,      18145]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["TexAct", "Title",
 FontColor->RGBColor[
  1, 0, 0],ExpressionUUID->"e0881279-da07-4a4a-91d8-4d2999f73966"],

Cell[TextData[{
 "Tex code to format ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " expressions"
}], "Subtitle",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"0b8d0559-8138-4d1b-8b4c-9cdfdda986b9"],

Cell[TextData[{
 StyleBox["Thomas B\[ADoubleDot]ckdahl, Jos\[EAcute] M. Mart\[IAcute]n-Garc\
\[IAcute]a and Barry Wardell\n",
  FontSize->18],
 "(c) 2008-2025, under GPL\n\nthomas.backdahl@gmail.com, jose@xact.es, \
barry.wardell@gmail.com\nhttp://www.xact.es/\n\
http://groups.google.com/group/xact"
}], "Subsubtitle",
 CellChangeTimes->{{3.588319343807869*^9, 3.58831935009468*^9}, {
   3.646381931871279*^9, 3.6463819319412794`*^9}, {3.647256550656485*^9, 
   3.647256556748833*^9}, 3.679983896654022*^9, 3.697733188495449*^9, 
   3.727336133246937*^9, {3.77791423019656*^9, 3.777914230536333*^9}, {
   3.7910925405986204`*^9, 3.791092540824293*^9}, 3.82020407634068*^9, 
   3.8758617695521297`*^9, 3.921306269246395*^9, 
   3.958400038424698*^9},ExpressionUUID->"46f9f6ce-e596-4c28-8549-\
1d90f80a366a"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a function TeXForm but does not behave well with the indexed \
expressions of ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 ". We construct our own Tex function, which starts from the internal form, \
and not the box-form of the expression. The objective is building a ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"T", 
    AdjustmentBox["E",
     BoxBaselineShift->0.5,
     BoxMargins->{{-0.075, -0.085}, {0, 0}}], "X"}]]],ExpressionUUID->
  "9371fc27-9f0d-491b-95ce-82f8773f66a9"],
 " string from our expression.\n\nJose: This package has been excised from ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " in April 2012, to make it easier to maintain, and to acknowledge the \
essential contributions by Thomas and Barry."
}], "Text",
 CellChangeTimes->{
  3.6804992957846956`*^9},ExpressionUUID->"2e87b620-7419-4a9d-aab1-\
ee836d2456bb"],

Cell[CellGroupData[{

Cell["1. Info and copyright", "Section",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"e9eccd9b-f825-49d6-a634-9f0abf3e9ee2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "/@", 
  RowBox[{"Date", "[", "]"}]}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"cd96d29b-6f86-4aab-a8d0-9e2c278d5c17"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2025", ",", "8", ",", "9", ",", "14", ",", "30", ",", "9"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.679983965118544*^9, 3.679984664776645*^9, 3.697739181566177*^9, 
   3.6977392365282545`*^9, 3.697744209648284*^9, 3.697821963041871*^9, 
   3.7120458517577553`*^9, 3.715232888469063*^9, 3.715233059223997*^9, 
   3.715233740323533*^9, 3.7273348917328672`*^9, 3.727335231497588*^9, 
   3.727335320354054*^9, 3.727336132562036*^9, 3.7273362259298496`*^9, 
   3.727336456648901*^9, 3.727336726945344*^9, 3.727337048217281*^9, 
   3.727340508330866*^9, 3.7273406167572856`*^9, 3.727340733350174*^9, 
   3.727341326850096*^9, 3.727342068111561*^9, 3.727343580380019*^9, 
   3.72734366381102*^9, 3.727343743551278*^9, 3.727343851684284*^9, 
   3.727410641514442*^9, 3.7282772264382296`*^9, 3.728278157145792*^9, 
   3.728278481529539*^9, {3.72827860353168*^9, 3.728278622187568*^9}, 
   3.728280515786847*^9, 3.728280818825831*^9, 3.728280991172189*^9, 
   3.7284837618691487`*^9, 3.728551299422928*^9, 3.728551791054885*^9, 
   3.7288045667131577`*^9, 3.7288046895761843`*^9, 3.728808515558805*^9, 
   3.728808855164296*^9, 3.777914003179743*^9, 3.777914075083388*^9, 
   3.791092743553457*^9, 3.791093790474416*^9, 3.791093938498359*^9, 
   3.8202047417840147`*^9, 3.820207202541552*^9, 3.820207362333801*^9, 
   3.8427624576410093`*^9, 3.844389998775428*^9, 3.844390070561028*^9, 
   3.844390668491982*^9, 3.844391073042097*^9, 3.87589157189924*^9, 
   3.875891992402465*^9, 3.92130682796657*^9, 3.9213069027308292`*^9, 
   3.921306944085083*^9, 3.9583999882896595`*^9, 3.958400331593212*^9, 
   3.959657758304262*^9, 3.9635796753388615`*^9, 3.963731409936823*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"dc23b94e-6e36-7e4c-9f72-de8dbf2eced9"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xAct`TexAct`$Version", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<0.4.5\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2025", ",", "08", ",", "09"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"xAct`TexAct`$xTensorVersionExpected", "=", "\[NoBreak]", 
   RowBox[{"{", 
    RowBox[{"\"\<1.1.0\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2013", ",", "9", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.679982118513288*^9, 3.679982126333445*^9}, 
   3.680499287484779*^9, {3.683447254842873*^9, 3.683447257002895*^9}, 
   3.6836138893676248`*^9, {3.684599802345292*^9, 3.684599805801297*^9}, {
   3.697733192486455*^9, 3.697733200601467*^9}, 3.697744199626269*^9, {
   3.712045858713439*^9, 3.71204586639756*^9}, {3.715231373441044*^9, 
   3.7152313762297587`*^9}, {3.727333911514344*^9, 3.727333940745612*^9}, 
   3.72741062909772*^9, {3.728276348136449*^9, 3.728276348337128*^9}, {
   3.728479034710039*^9, 3.728479038773817*^9}, {3.728551278530159*^9, 
   3.728551278599271*^9}, {3.728800415196704*^9, 3.7288004156107273`*^9}, {
   3.7779132072715154`*^9, 3.777913216382004*^9}, {3.7785059143014593`*^9, 
   3.77850591588913*^9}, {3.781547352165153*^9, 3.781547354821426*^9}, {
   3.79109271466718*^9, 3.791092721539324*^9}, {3.816693832040143*^9, 
   3.816693834095647*^9}, {3.820204081045734*^9, 3.8202040861887264`*^9}, {
   3.8227448790827923`*^9, 3.82274488326553*^9}, {3.842761932703024*^9, 
   3.842761937566228*^9}, {3.8443896041857147`*^9, 3.844389604466018*^9}, 
   3.844390020306245*^9, {3.875861834065154*^9, 3.8758618543050623`*^9}, {
   3.921306276805956*^9, 3.9213062840705204`*^9}, {3.9583999689927864`*^9, 
   3.958399976920826*^9}, {3.959657753499113*^9, 3.9596577537913685`*^9}, {
   3.9635796689479504`*^9, 3.963579671084242*^9}, {3.9637313851531105`*^9, 
   3.9637314085126057`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"e3e58c99-fae0-43de-9df5-19758902ebd8"],

Cell[CellGroupData[{

Cell["1.0. TODO LIST", "Subsection",ExpressionUUID->"41c144d8-fd2c-4aa9-85e6-12503a2beb33"],

Cell["Fix SeriesData.", "Text",
 CellChangeTimes->{{3.6057872245735283`*^9, 
  3.605787252143567*^9}},ExpressionUUID->"24fb36e6-bfca-4b1b-ae7f-\
8c46fd106ecd"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1. GPL", "Subsection",ExpressionUUID->"38f7abb1-b4fd-4d1d-a999-f56042da9d2f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"TexAct", ",", " ", 
    RowBox[{
    "Tex", " ", "code", " ", "to", " ", "format", " ", "xAct", " ", 
     "expressions"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Copyright", " ", 
      RowBox[{"(", "C", ")"}], " ", "2008"}], "-", 
     RowBox[{"2025", " ", "Thomas", " ", "B\[ADoubleDot]ckdahl"}]}], ",", " ", 
    RowBox[{
     RowBox[{"Jose", " ", 
      RowBox[{"M", ".", " ", "Martin"}]}], "-", 
     RowBox[{"Garcia", " ", "and", " ", "Barry", " ", "Wardell"}]}]}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", "\[IndentingNewLine]", " ", 
      "it", " ", "under", " ", "the", " ", "terms", " ", "of", " ", "the", 
      " ", "GNU", " ", "General", " ", "Public", " ", "License", " ", "as", 
      " ", "published", "\[IndentingNewLine]", " ", "by", " ", "the", " ", 
      "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], 
     " ", "program", " ", "is", " ", "distributed", " ", "in", " ", "the", 
     " ", "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", 
     "useful"}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", " ", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", 
      "\[IndentingNewLine]", " ", "General", " ", "Public", " ", "License", 
      " ", "for", " ", "more", " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], 
      " ", "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ",
       "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", "\[IndentingNewLine]", " ", "along", " ", "with", " ", 
      "this", " ", "program"}], ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", 
     "\[IndentingNewLine]", " ", "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.5449471950564704`*^9, 3.582278943553317*^9, {3.6463819555013137`*^9, 
   3.646381955581312*^9}, {3.6799839087530546`*^9, 3.6799839096429834`*^9}, 
   3.7779132302945256`*^9, {3.875861867923824*^9, 3.875861868066398*^9}, 
   3.9584000173388557`*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"8130e9a2-ffb1-4f73-8459-58f61d561f54"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Info package", "Subsection",ExpressionUUID->"4393db84-b034-4142-974c-e10ab6afb6bb"],

Cell["\<\
(* :Title: TexAct *)

(* :Author: Thomas B\[ADoubleDot]ckdahl, Jose M. Martin-Garcia and Barry \
Wardell *)

(* :Summary: Tex code to format xAct expressions *)

(* :Brief Discussion:
*)
  
(* :Context: xAct`Texsor` *)

(* :Package Version: 0.4.5 *)

(* :Copyright: Thomas B\[ADoubleDot]ckdahl, Jose M. Martin-Garcia and Barry \
Wardell (2008-2019) *)

(* :History: see TexAct.History file *)

(* :Keywords: *)

(* :Source: Texsor.nb *)

(* :Warning: *)

(* :Mathematica Version: 9.0 and later *)

(* :Limitations: *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellChangeTimes->{{3.6799839204321203`*^9, 3.6799839303513265`*^9}, 
   3.697739204371209*^9, {3.7779132458905134`*^9, 3.777913288431517*^9}, 
   3.844390031306197*^9, 3.875861874548748*^9, 3.9583999970878277`*^9},
 CellLabel->"In[5]:=",ExpressionUUID->"cd3ddec4-24fe-473c-9d4e-c462fa26328f"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. BeginPackage", "Subsection",ExpressionUUID->"eb7c220d-7898-4a5b-a23a-e83788e84208"],

Cell["Last package read in a session:", "Text",ExpressionUUID->"460d065f-dbc0-4d06-9fec-bee0384939f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`TexAct`\>\""}]}], "]"}],
   ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[30]:=",ExpressionUUID->"9954ddef-8280-4a96-92a0-6a9836c765e4"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"6ae8e6b3-afc0-4767-a9bf-85a2b0294a5a"],

Cell[BoxData["\<\"xAct`TexAct`\"\>"], "Output",
 CellChangeTimes->{
  3.6799839652285357`*^9, 3.679984664876646*^9, 3.697739181626177*^9, 
   3.6977392365882545`*^9, 3.715232888697385*^9, 3.715233059342143*^9, 
   3.715233740525693*^9, 3.727334892011907*^9, 3.727335231639608*^9, 
   3.727335320458279*^9, 3.727336132677946*^9, 3.72733622604581*^9, 
   3.727336456779998*^9, 3.7273367270612555`*^9, 3.72733704835538*^9, 
   3.7273405086002812`*^9, 3.727340617007064*^9, 3.727340733634513*^9, 
   3.727341327084704*^9, 3.727342068311731*^9, 3.727343580680983*^9, 
   3.727343664095377*^9, 3.7273437438513985`*^9, 3.727343851953367*^9, 
   3.7274106417462807`*^9, 3.728277226607319*^9, 3.728278157214578*^9, 
   3.728278481592047*^9, {3.728278603585121*^9, 3.7282786222501063`*^9}, 
   3.7282805159775343`*^9, 3.7282808190105653`*^9, 3.728280991371251*^9, 
   3.728483762106634*^9, 3.728551299549861*^9, 3.728551791152948*^9, 
   3.728804566786161*^9, 3.728804689656189*^9, 3.728808515837121*^9, 
   3.728808855245109*^9, 3.777914003321707*^9, 3.7779140752330885`*^9, 
   3.79109379076272*^9, 3.7910939387080193`*^9, 3.8202047418588142`*^9, 
   3.820207202622307*^9, 3.820207362417846*^9, 3.842762457823522*^9, 
   3.8443899988921156`*^9, 3.844390070707636*^9, 3.844390668586755*^9, 
   3.844391073176775*^9, 3.8758915721266603`*^9, 3.87589199256805*^9, 
   3.921306828053337*^9, 3.921306902847515*^9, 3.92130694417185*^9, 
   3.9584003320921917`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"773fbbf0-739a-d342-b366-8eb72c317f01"]
}, Open  ]],

Cell[TextData[{
 "Explicit (not hidden) import of ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 ",  ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " and ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"b5b9d2aa-0d4a-4d23-9b11-84a7a9fd9b2d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`TexAct`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<xAct`xCore`\>\"", ",", "\"\<xAct`xPerm`\>\"", ",", 
     "\"\<xAct`xTensor`\>\""}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[32]:=",ExpressionUUID->"9c2ee48c-f31b-4511-abf9-709c9b2e57ac"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.7282786223499684`*^9, 3.728280516118658*^9, 3.728280819157816*^9, 
   3.7282809915196247`*^9, 3.7284837622689633`*^9, 3.728551299638508*^9, 
   3.728551791255249*^9, 3.728804566881167*^9, 3.7288046897581944`*^9, 
   3.728808515990408*^9, 3.728808855326697*^9, {3.77791399460096*^9, 
   3.777914003446715*^9}, 3.77791407535812*^9, 3.7910937909380407`*^9, 
   3.79109393886827*^9, 3.820204741954558*^9, 3.8202072027001796`*^9, 
   3.820207362492673*^9, 3.8427624578893733`*^9, 3.844389998958976*^9, 
   3.84439007078144*^9, 3.844390668668536*^9, 3.8443910732475777`*^9, 
   3.875891572231353*^9, 3.8758919926597767`*^9, 3.9213068281839867`*^9, 
   3.921306902950239*^9, 3.9213069442755737`*^9, 3.9584003323708115`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"729627bc-b88a-1f4e-b3d7-dba39a18e910"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7282786223499684`*^9, 3.728280516118658*^9, 3.728280819157816*^9, 
   3.7282809915196247`*^9, 3.7284837622689633`*^9, 3.728551299638508*^9, 
   3.728551791255249*^9, 3.728804566881167*^9, 3.7288046897581944`*^9, 
   3.728808515990408*^9, 3.728808855326697*^9, {3.77791399460096*^9, 
   3.777914003446715*^9}, 3.77791407535812*^9, 3.7910937909380407`*^9, 
   3.79109393886827*^9, 3.820204741954558*^9, 3.8202072027001796`*^9, 
   3.820207362492673*^9, 3.8427624578893733`*^9, 3.844389998958976*^9, 
   3.84439007078144*^9, 3.844390668668536*^9, 3.8443910732475777`*^9, 
   3.875891572231353*^9, 3.8758919926597767`*^9, 3.9213068281839867`*^9, 
   3.921306902950239*^9, 3.9213069442755737`*^9, 3.958400332372818*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"6b2c7d2f-569b-5b42-8ec9-a82f44106ec6"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.7282786223499684`*^9, 3.728280516118658*^9, 3.728280819157816*^9, 
   3.7282809915196247`*^9, 3.7284837622689633`*^9, 3.728551299638508*^9, 
   3.728551791255249*^9, 3.728804566881167*^9, 3.7288046897581944`*^9, 
   3.728808515990408*^9, 3.728808855326697*^9, {3.77791399460096*^9, 
   3.777914003446715*^9}, 3.77791407535812*^9, 3.7910937909380407`*^9, 
   3.79109393886827*^9, 3.820204741954558*^9, 3.8202072027001796`*^9, 
   3.820207362492673*^9, 3.8427624578893733`*^9, 3.844389998958976*^9, 
   3.84439007078144*^9, 3.844390668668536*^9, 3.8443910732475777`*^9, 
   3.875891572231353*^9, 3.8758919926597767`*^9, 3.9213068281839867`*^9, 
   3.921306902950239*^9, 3.9213069442755737`*^9, 3.958400332376835*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"76c8fcf6-6b25-674d-baa6-feaf88553b07"],

Cell[BoxData["\<\"Connecting to external MinGW executable...\"\>"], "Print",
 CellChangeTimes->{
  3.7282786223499684`*^9, 3.728280516118658*^9, 3.728280819157816*^9, 
   3.7282809915196247`*^9, 3.7284837622689633`*^9, 3.728551299638508*^9, 
   3.728551791255249*^9, 3.728804566881167*^9, 3.7288046897581944`*^9, 
   3.728808515990408*^9, 3.728808855326697*^9, {3.77791399460096*^9, 
   3.777914003446715*^9}, 3.77791407535812*^9, 3.7910937909380407`*^9, 
   3.79109393886827*^9, 3.820204741954558*^9, 3.8202072027001796`*^9, 
   3.820207362492673*^9, 3.8427624578893733`*^9, 3.844389998958976*^9, 
   3.84439007078144*^9, 3.844390668668536*^9, 3.8443910732475777`*^9, 
   3.875891572231353*^9, 3.8758919926597767`*^9, 3.9213068281839867`*^9, 
   3.921306902950239*^9, 3.9213069442755737`*^9, 3.958400332509144*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"eec7ede3-2fc3-814e-af5b-69421d51856d"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{
  3.7282786223499684`*^9, 3.728280516118658*^9, 3.728280819157816*^9, 
   3.7282809915196247`*^9, 3.7284837622689633`*^9, 3.728551299638508*^9, 
   3.728551791255249*^9, 3.728804566881167*^9, 3.7288046897581944`*^9, 
   3.728808515990408*^9, 3.728808855326697*^9, {3.77791399460096*^9, 
   3.777914003446715*^9}, 3.77791407535812*^9, 3.7910937909380407`*^9, 
   3.79109393886827*^9, 3.820204741954558*^9, 3.8202072027001796`*^9, 
   3.820207362492673*^9, 3.8427624578893733`*^9, 3.844389998958976*^9, 
   3.84439007078144*^9, 3.844390668668536*^9, 3.8443910732475777`*^9, 
   3.875891572231353*^9, 3.8758919926597767`*^9, 3.9213068281839867`*^9, 
   3.921306902950239*^9, 3.9213069442755737`*^9, 3.958400332617384*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"2a55a3b7-134a-8a41-ad9c-a97810998a16"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.7282786223499684`*^9, 3.728280516118658*^9, 3.728280819157816*^9, 
   3.7282809915196247`*^9, 3.7284837622689633`*^9, 3.728551299638508*^9, 
   3.728551791255249*^9, 3.728804566881167*^9, 3.7288046897581944`*^9, 
   3.728808515990408*^9, 3.728808855326697*^9, {3.77791399460096*^9, 
   3.777914003446715*^9}, 3.77791407535812*^9, 3.7910937909380407`*^9, 
   3.79109393886827*^9, 3.820204741954558*^9, 3.8202072027001796`*^9, 
   3.820207362492673*^9, 3.8427624578893733`*^9, 3.844389998958976*^9, 
   3.84439007078144*^9, 3.844390668668536*^9, 3.8443910732475777`*^9, 
   3.875891572231353*^9, 3.8758919926597767`*^9, 3.9213068281839867`*^9, 
   3.921306902950239*^9, 3.9213069442755737`*^9, 3.95840033272958*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"db7ae28a-d9a5-ac49-a7a6-4aca0f65b012"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7282786223499684`*^9, 3.728280516118658*^9, 3.728280819157816*^9, 
   3.7282809915196247`*^9, 3.7284837622689633`*^9, 3.728551299638508*^9, 
   3.728551791255249*^9, 3.728804566881167*^9, 3.7288046897581944`*^9, 
   3.728808515990408*^9, 3.728808855326697*^9, {3.77791399460096*^9, 
   3.777914003446715*^9}, 3.77791407535812*^9, 3.7910937909380407`*^9, 
   3.79109393886827*^9, 3.820204741954558*^9, 3.8202072027001796`*^9, 
   3.820207362492673*^9, 3.8427624578893733`*^9, 3.844389998958976*^9, 
   3.84439007078144*^9, 3.844390668668536*^9, 3.8443910732475777`*^9, 
   3.875891572231353*^9, 3.8758919926597767`*^9, 3.9213068281839867`*^9, 
   3.921306902950239*^9, 3.9213069442755737`*^9, 3.95840033272958*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"32e6d1e3-650e-1a40-8e1a-4653fb118907"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.7282786223499684`*^9, 3.728280516118658*^9, 3.728280819157816*^9, 
   3.7282809915196247`*^9, 3.7284837622689633`*^9, 3.728551299638508*^9, 
   3.728551791255249*^9, 3.728804566881167*^9, 3.7288046897581944`*^9, 
   3.728808515990408*^9, 3.728808855326697*^9, {3.77791399460096*^9, 
   3.777914003446715*^9}, 3.77791407535812*^9, 3.7910937909380407`*^9, 
   3.79109393886827*^9, 3.820204741954558*^9, 3.8202072027001796`*^9, 
   3.820207362492673*^9, 3.8427624578893733`*^9, 3.844389998958976*^9, 
   3.84439007078144*^9, 3.844390668668536*^9, 3.8443910732475777`*^9, 
   3.875891572231353*^9, 3.8758919926597767`*^9, 3.9213068281839867`*^9, 
   3.921306902950239*^9, 3.9213069442755737`*^9, 3.95840033272958*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"98d08456-81b4-fe47-926e-89ab158a4a7d"]
}, Open  ]],

Cell[BoxData["\<\"xAct`TexAct`\"\>"], "Output",
 CellChangeTimes->{
  3.679983965618504*^9, 3.679984665176649*^9, 3.697739181916178*^9, 
   3.697739236888255*^9, {3.715232885432781*^9, 3.71523288874574*^9}, {
   3.715233056200305*^9, 3.715233059385446*^9}, {3.715233737271584*^9, 
   3.715233740592348*^9}, 3.727334892449941*^9, 3.727335232094222*^9, 
   3.727335320812049*^9, 3.727336133046073*^9, 3.727336226399988*^9, 
   3.727336457149148*^9, 3.727336727446442*^9, 3.727337048718354*^9, 
   3.727340509178871*^9, 3.7273406174925146`*^9, 3.727340734103273*^9, 
   3.7273413275378246`*^9, 3.727342068775074*^9, 3.727343581181784*^9, 
   3.727343664549141*^9, 3.727343744320582*^9, 3.727343852431752*^9, 
   3.727410642215438*^9, 3.728277227123587*^9, 3.728278157598863*^9, 
   3.7282784819452257`*^9, {3.728278603585121*^9, 3.728278622587127*^9}, 
   3.728280516388048*^9, 3.7282808194580803`*^9, 3.728280991804801*^9, 
   3.728483762553743*^9, 3.72855129989191*^9, 3.7285517915086336`*^9, 
   3.728804567069177*^9, 3.7288046899512053`*^9, 3.728808516305994*^9, 
   3.7288088555800395`*^9, {3.777913994915767*^9, 3.777914003852839*^9}, 
   3.777914075772788*^9, 3.791093791492875*^9, 3.791093939339803*^9, 
   3.820204744976018*^9, 3.820207203000377*^9, 3.8202073627864733`*^9, 
   3.842762458213479*^9, 3.84438999924021*^9, 3.844390071068675*^9, 
   3.844390668949792*^9, 3.844391073530816*^9, 3.875891572566456*^9, 
   3.875891992951995*^9, 3.921306828527069*^9, 3.9213069032574196`*^9, 
   3.9213069445869236`*^9, 3.9584003329045887`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"3604b366-bad9-2947-9233-4ec0a8adfdc1"]
}, Open  ]],

Cell[TextData[{
 "Check version of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". We simply compare dates:"
}], "Text",ExpressionUUID->"270a4b92-8294-4842-a48a-d795a42e496e"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Not", "@", 
    RowBox[{"OrderedQ", "@", 
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"{", 
        RowBox[{
        "xAct`TexAct`$xTensorVersionExpected", ",", "xAct`xTensor`$Version"}],
         "}"}]}], "]"}]}]}], ",", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"General", "::", "versions"}], ",", "\"\<xTensor\>\"", ",", 
      "xAct`xTensor`$Version", ",", "xAct`TexAct`$xTensorVersionExpected"}], 
     "]"}]}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[33]:=",ExpressionUUID->"8b7a7e8f-21e0-44f4-b33e-d87debd1156a"],

Cell["Message:", "Text",ExpressionUUID->"2cdcf8f9-dad3-484e-9c18-ce3b9c87bc00"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`TexAct`  version \>\"", ",", 
    RowBox[{"xAct`TexAct`$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"xAct`TexAct`$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{"Print", "[", 
  "\"\<CopyRight (C) 2008-2021, Thomas B\[ADoubleDot]ckdahl, Jose M. \
Martin-Garcia and Barry Wardell, under the General Public License.\>\"", 
  "]"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.679983942480356*^9, 3.6977391900481887`*^9, 3.7273420753340883`*^9, {
   3.791093833313633*^9, 3.791093833545165*^9}, 3.820204754245689*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"3794754e-8740-4d2d-a65f-2c74d151e490"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.679983965638503*^9, 3.679984665196649*^9, 3.6977391819961786`*^9, 
   3.697739236958255*^9, {3.715232885509162*^9, 3.715232888829852*^9}, {
   3.715233056283901*^9, 3.715233059467525*^9}, {3.715233737340005*^9, 
   3.715233740691807*^9}, 3.727334892581595*^9, 3.72733523217838*^9, 
   3.727335326018838*^9, 3.727336133078332*^9, 3.727336226431271*^9, 
   3.727336457197068*^9, 3.7273367275154514`*^9, 3.727337052151863*^9, 
   3.727340509231097*^9, 3.727340617608196*^9, 3.727340734165779*^9, 
   3.7273413275776386`*^9, 3.727342068812104*^9, 3.727343581231613*^9, 
   3.727343664611662*^9, 3.727343744367438*^9, 3.727343852485147*^9, 
   3.7274106422466927`*^9, 3.728277227123587*^9, 3.728278157630163*^9, 
   3.7282784819452257`*^9, {3.728278603606365*^9, 3.728278622602783*^9}, 
   3.7282805164036756`*^9, 3.7282808194736757`*^9, 3.728280991836079*^9, 
   3.7284837625693684`*^9, 3.7285512999075384`*^9, 3.728551791539888*^9, 
   3.728804567090179*^9, 3.7288046899732065`*^9, 3.7288085163215885`*^9, 
   3.728808855595662*^9, {3.777913994962681*^9, 3.777914003899751*^9}, 
   3.777914075805994*^9, 3.7910937917556915`*^9, 3.791093939422947*^9, 
   3.8202047450817637`*^9, 3.820207203040318*^9, 3.820207362827362*^9, 
   3.842762458259356*^9, 3.844389999281101*^9, 3.8443900711005588`*^9, 
   3.8443906690016546`*^9, 3.844391073563701*^9, 3.875891572588425*^9, 
   3.8758919929749613`*^9, 3.921306828563999*^9, 3.9213069032923527`*^9, 
   3.921306944608864*^9, 3.9584003329682274`*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"a78aec27-0218-4741-9f10-c89a9b02bd1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`TexAct`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.4.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "6", ",", "8"}], "}"}]}],
  SequenceForm["Package xAct`TexAct`  version ", "0.4.5", ", ", {2025, 6, 8}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.679983965638503*^9, 3.679984665196649*^9, 3.6977391819961786`*^9, 
   3.697739236958255*^9, {3.715232885509162*^9, 3.715232888829852*^9}, {
   3.715233056283901*^9, 3.715233059467525*^9}, {3.715233737340005*^9, 
   3.715233740691807*^9}, 3.727334892581595*^9, 3.72733523217838*^9, 
   3.727335326018838*^9, 3.727336133078332*^9, 3.727336226431271*^9, 
   3.727336457197068*^9, 3.7273367275154514`*^9, 3.727337052151863*^9, 
   3.727340509231097*^9, 3.727340617608196*^9, 3.727340734165779*^9, 
   3.7273413275776386`*^9, 3.727342068812104*^9, 3.727343581231613*^9, 
   3.727343664611662*^9, 3.727343744367438*^9, 3.727343852485147*^9, 
   3.7274106422466927`*^9, 3.728277227123587*^9, 3.728278157630163*^9, 
   3.7282784819452257`*^9, {3.728278603606365*^9, 3.728278622602783*^9}, 
   3.7282805164036756`*^9, 3.7282808194736757`*^9, 3.728280991836079*^9, 
   3.7284837625693684`*^9, 3.7285512999075384`*^9, 3.728551791539888*^9, 
   3.728804567090179*^9, 3.7288046899732065`*^9, 3.7288085163215885`*^9, 
   3.728808855595662*^9, {3.777913994962681*^9, 3.777914003899751*^9}, 
   3.777914075805994*^9, 3.7910937917556915`*^9, 3.791093939422947*^9, 
   3.8202047450817637`*^9, 3.820207203040318*^9, 3.820207362827362*^9, 
   3.842762458259356*^9, 3.844389999281101*^9, 3.8443900711005588`*^9, 
   3.8443906690016546`*^9, 3.844391073563701*^9, 3.875891572588425*^9, 
   3.8758919929749613`*^9, 3.921306828563999*^9, 3.9213069032923527`*^9, 
   3.921306944608864*^9, 3.9584003329834213`*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"6b44a4a9-1fc7-2e4f-b361-cc995e758fe4"],

Cell[BoxData["\<\"CopyRight (C) 2008-2021, Thomas B\[ADoubleDot]ckdahl, Jose \
M. Martin-Garcia and Barry Wardell, under the General Public License.\"\>"], \
"Print",
 CellChangeTimes->{
  3.679983965638503*^9, 3.679984665196649*^9, 3.6977391819961786`*^9, 
   3.697739236958255*^9, {3.715232885509162*^9, 3.715232888829852*^9}, {
   3.715233056283901*^9, 3.715233059467525*^9}, {3.715233737340005*^9, 
   3.715233740691807*^9}, 3.727334892581595*^9, 3.72733523217838*^9, 
   3.727335326018838*^9, 3.727336133078332*^9, 3.727336226431271*^9, 
   3.727336457197068*^9, 3.7273367275154514`*^9, 3.727337052151863*^9, 
   3.727340509231097*^9, 3.727340617608196*^9, 3.727340734165779*^9, 
   3.7273413275776386`*^9, 3.727342068812104*^9, 3.727343581231613*^9, 
   3.727343664611662*^9, 3.727343744367438*^9, 3.727343852485147*^9, 
   3.7274106422466927`*^9, 3.728277227123587*^9, 3.728278157630163*^9, 
   3.7282784819452257`*^9, {3.728278603606365*^9, 3.728278622602783*^9}, 
   3.7282805164036756`*^9, 3.7282808194736757`*^9, 3.728280991836079*^9, 
   3.7284837625693684`*^9, 3.7285512999075384`*^9, 3.728551791539888*^9, 
   3.728804567090179*^9, 3.7288046899732065`*^9, 3.7288085163215885`*^9, 
   3.728808855595662*^9, {3.777913994962681*^9, 3.777914003899751*^9}, 
   3.777914075805994*^9, 3.7910937917556915`*^9, 3.791093939422947*^9, 
   3.8202047450817637`*^9, 3.820207203040318*^9, 3.820207362827362*^9, 
   3.842762458259356*^9, 3.844389999281101*^9, 3.8443900711005588`*^9, 
   3.8443906690016546`*^9, 3.844391073563701*^9, 3.875891572588425*^9, 
   3.8758919929749613`*^9, 3.921306828563999*^9, 3.9213069032923527`*^9, 
   3.921306944608864*^9, 3.9584003329834213`*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"e6d9df7d-17dc-834f-94a9-8265c36f3aa8"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We specify the context xAct`TexAct` to avoid overriding the Disclaimer of \
other packages. However we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"eda21b64-e275-42fc-b2c4-786afb37e5ef"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`TexAct`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", 
   "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[37]:=",ExpressionUUID->"e93e99a1-fcc8-43ec-a409-89f406e422b6"],

Cell["\<\
If TexAct is the last package begin read, print the GPL message:\
\>", "Text",ExpressionUUID->"a3830b80-712b-4639-ad55-94630fcffd26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`TexAct`\>\""}],
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Print", "[", 
     "\"\<These packages come with ABSOLUTELY NO WARRANTY; for details type \
Disclaimer[]. This is free software, and you are welcome to redistribute it \
under certain conditions. See the General Public License for details.\>\"", 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[40]:=",ExpressionUUID->"9268fe77-46cf-4d3d-b674-b2732878bb63"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.679983965658501*^9, 3.679984665216649*^9, 3.697739182016177*^9, 
   3.697739236988255*^9, {3.7152328857112722`*^9, 3.715232888930526*^9}, {
   3.715233056383543*^9, 3.715233059585043*^9}, {3.715233737479463*^9, 
   3.715233740808839*^9}, 3.727334892665762*^9, 3.727335232228342*^9, 
   3.727335326087869*^9, 3.727336137643837*^9, 3.727336229725772*^9, 
   3.727336460652606*^9, 3.727336730793577*^9, 3.72733705236493*^9, 
   3.7273405092946405`*^9, 3.7273406176999*^9, 3.727340734218893*^9, 
   3.727341327615945*^9, 3.7273420688589544`*^9, 3.7273435812825327`*^9, 
   3.727343664696329*^9, 3.727343744436482*^9, 3.727343852532002*^9, 
   3.727410642304436*^9, 3.728277227170436*^9, 3.7282781607788334`*^9, 
   3.728278482007733*^9, {3.7282786036315*^9, 3.728278622634008*^9}, 
   3.728280516434929*^9, 3.728280819511123*^9, 3.7282809918738575`*^9, 
   3.728483762607149*^9, 3.728551299954385*^9, 3.72855179584439*^9, 
   3.728804567126181*^9, 3.728804690011209*^9, 3.728808516358878*^9, 
   3.728808855649064*^9, {3.7779139950251837`*^9, 3.7779140039621797`*^9}, 
   3.777914075884121*^9, 3.791093791893803*^9, 3.791093939523279*^9, 
   3.820204745136589*^9, 3.820207203106067*^9, 3.820207362891193*^9, 
   3.842762458316204*^9, 3.8443900022710733`*^9, 3.844390071142446*^9, 
   3.844390671730316*^9, 3.844391073605589*^9, 3.875891572626326*^9, 
   3.875891993019842*^9, 3.9213068286058598`*^9, 3.9213069033332443`*^9, 
   3.9213069446367893`*^9, 3.958400333010372*^9},
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"dbc209c2-851c-504c-b56a-8d3cc1047ea0"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{
  3.679983965658501*^9, 3.679984665216649*^9, 3.697739182016177*^9, 
   3.697739236988255*^9, {3.7152328857112722`*^9, 3.715232888930526*^9}, {
   3.715233056383543*^9, 3.715233059585043*^9}, {3.715233737479463*^9, 
   3.715233740808839*^9}, 3.727334892665762*^9, 3.727335232228342*^9, 
   3.727335326087869*^9, 3.727336137643837*^9, 3.727336229725772*^9, 
   3.727336460652606*^9, 3.727336730793577*^9, 3.72733705236493*^9, 
   3.7273405092946405`*^9, 3.7273406176999*^9, 3.727340734218893*^9, 
   3.727341327615945*^9, 3.7273420688589544`*^9, 3.7273435812825327`*^9, 
   3.727343664696329*^9, 3.727343744436482*^9, 3.727343852532002*^9, 
   3.727410642304436*^9, 3.728277227170436*^9, 3.7282781607788334`*^9, 
   3.728278482007733*^9, {3.7282786036315*^9, 3.728278622634008*^9}, 
   3.728280516434929*^9, 3.728280819511123*^9, 3.7282809918738575`*^9, 
   3.728483762607149*^9, 3.728551299954385*^9, 3.72855179584439*^9, 
   3.728804567126181*^9, 3.728804690011209*^9, 3.728808516358878*^9, 
   3.728808855649064*^9, {3.7779139950251837`*^9, 3.7779140039621797`*^9}, 
   3.777914075884121*^9, 3.791093791893803*^9, 3.791093939523279*^9, 
   3.820204745136589*^9, 3.820207203106067*^9, 3.820207362891193*^9, 
   3.842762458316204*^9, 3.8443900022710733`*^9, 3.844390071142446*^9, 
   3.844390671730316*^9, 3.844391073605589*^9, 3.875891572626326*^9, 
   3.875891993019842*^9, 3.9213068286058598`*^9, 3.9213069033332443`*^9, 
   3.9213069446367893`*^9, 3.9584003330123806`*^9},
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"0991fa9e-b3f6-434f-b8b1-41173f74c816"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.679983965658501*^9, 3.679984665216649*^9, 3.697739182016177*^9, 
   3.697739236988255*^9, {3.7152328857112722`*^9, 3.715232888930526*^9}, {
   3.715233056383543*^9, 3.715233059585043*^9}, {3.715233737479463*^9, 
   3.715233740808839*^9}, 3.727334892665762*^9, 3.727335232228342*^9, 
   3.727335326087869*^9, 3.727336137643837*^9, 3.727336229725772*^9, 
   3.727336460652606*^9, 3.727336730793577*^9, 3.72733705236493*^9, 
   3.7273405092946405`*^9, 3.7273406176999*^9, 3.727340734218893*^9, 
   3.727341327615945*^9, 3.7273420688589544`*^9, 3.7273435812825327`*^9, 
   3.727343664696329*^9, 3.727343744436482*^9, 3.727343852532002*^9, 
   3.727410642304436*^9, 3.728277227170436*^9, 3.7282781607788334`*^9, 
   3.728278482007733*^9, {3.7282786036315*^9, 3.728278622634008*^9}, 
   3.728280516434929*^9, 3.728280819511123*^9, 3.7282809918738575`*^9, 
   3.728483762607149*^9, 3.728551299954385*^9, 3.72855179584439*^9, 
   3.728804567126181*^9, 3.728804690011209*^9, 3.728808516358878*^9, 
   3.728808855649064*^9, {3.7779139950251837`*^9, 3.7779140039621797`*^9}, 
   3.777914075884121*^9, 3.791093791893803*^9, 3.791093939523279*^9, 
   3.820204745136589*^9, 3.820207203106067*^9, 3.820207362891193*^9, 
   3.842762458316204*^9, 3.8443900022710733`*^9, 3.844390071142446*^9, 
   3.844390671730316*^9, 3.844391073605589*^9, 3.875891572626326*^9, 
   3.875891993019842*^9, 3.9213068286058598`*^9, 3.9213069033332443`*^9, 
   3.9213069446367893`*^9, 3.958400333015396*^9},
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"ba8a07ce-ff61-ec42-b9ae-3e365d80d592"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. Usage messages", "Subsection",ExpressionUUID->"1b0304e1-a9be-4b57-a339-23b1fe955c4e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "::", "usage"}], "=", 
   "\"\<Tex[expr] returns a string with the TeX formatting of the tensorial \
expression expr.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexPrint", "::", "usage"}], "=", 
   "\"\<TexPrint[expr] returns a string for screen printing of the TeX \
formatting of the tensorial expression expr. TexPrint[expr, n] starts using \
parenthesization of level n, instead of the Automatic level.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBreak", "::", "usage"}], "=", 
   "\"\<TexBreak[string] breaks the string (the output of TexPrint) into \
different lines of TeX code, always before a sum, approximately every 200 \
characters (or terms, using the option TexBreakBy) of the string. \
TexBreak[string, n] allows specifying the frequency of characters or terms. \
TexBreak[string, n, list] allows specifying different lengths for different \
lines. Other relevant options are TexBreakAt and TexBreakString.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBreakBy", "::", "usage"}], "=", 
   "\"\<TexBreakBy is an option for TexBreak specifying whether the string of \
TeX code must be broken by counting characters (value \\\"Character\\\") or \
by counting terms (value \\\"Term\\\").\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBreakAt", "::", "usage"}], "=", 
   "\"\<TexBreakAt is an option for TexBreak specifying where to break the \
string of TeX code.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBreakString", "::", "usage"}], "=", 
   "\"\<TexBreakString is an option for TexBreak specifying the string to be \
introduced at the breaking points.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexPrintInitialBracesQ", "::", "usage"}], "=", 
   "\"\<$TexPrintInitialBracesQ is a Boolean global variable, with default \
False. If set to True a tensor is formatted as T{}^{ab}{}_{cd}. If set to \
False the same tensor is formatted as T^{ab}{}_{cd}.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexScalarParentheses", "::", "usage"}], "=", 
   "\"\<$TexScalarParentheses is a Boolean global variable, with default \
True. If set to True the Scalar expressions are formatted with wrapping \
parentheses.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexFraction", "::", "usage"}], "=", 
   "\"\<$TexFraction is a global variable specifying the Tex command to be \
used to format fractions, with default \\\"\\\\frac\\\".\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexSmallFraction", "::", "usage"}], "=", 
   "\"\<$TexSmallFraction is a global variable specifying the Tex command to \
be use to format rational numbers, with default \\\"\\\\tfrac\\\".\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexSmallFractionExponent", "::", "usage"}], "=", 
   "\"\<$TexSmallFractionExponent is a global variable specifying the Tex \
command to be use to format rational numbers, with default False.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexFractionAsFraction", "::", "usage"}], "=", 
   "\"\<Option for TexPrint. If True, fractions are printed as fractions, \
otherwize they are printed as a product with negative exponents.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexParenthesisInitLevel", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexFixExtraRules", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexMatrix", "::", "usage"}], " ", "=", 
   "\"\<TexMatrix[M] produces TeX code for the matrix M, where all elements \
are typset by the function Tex. TexMatrix[M, F] uses the function F instead \
of Tex on the elements.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBMatrix", "::", "usage"}], "=", 
   "\"\<TexBMatrix[M] produces TeX code for the matrix M similar to \
TexMatrix, but with the {bmatrix} construction. Please make sure that \
appropriate packages are included in $TexInitLatexPackages\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexPMatrix", "::", "usage"}], "=", 
   "\"\<TexPMatrix[M] produces TeX code for the matrix M similar to \
TexMatrix, but with the {pmatrix} construction. Please make sure that \
appropriate packages are included in $TexInitLatexPackages\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexDet", "::", "usage"}], "=", 
   "\"\<TexDet[M] produces TeX code for the determinant of matrix M similar \
to TexMatrix, but with the {vmatrix} construction. Please make sure that \
appropriate packages are included in $TexInitLatexPackages\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexIndexForm", "::", "usage"}], " ", "=", 
   "\"\<Special formatting for indices.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexTmpDirectory", "::", "usage"}], " ", "=", 
   "\"\<Directory for placement of the TexActWidthTest.tex file for \
determining of widths for linebreaking.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexDirectory", "::", "usage"}], "=", 
   "\"\<Directory for placement of the output .tex file.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexInitLatexCode", "::", "usage"}], "=", 
   "\"\<A function that produces the initial lines of the TexActWidthTest.tex \
file for determining of widths for linebreaking. Observe that \
\\\\begin{document} should not be included. This is constructed from the \
string $TexInitLatexClassCode, and the lists $TexInitLatexPackages, \
$TexInitLatexExtraCode.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexInitLatexClassCode", "::", "usage"}], "=", 
   "\"\<The document class code for the LaTeX output.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexInitLatexPackages", "::", "usage"}], "=", 
   "\"\<A list of packages for the LaTeX output. This should be a list of \
strings, where each string has teh form {package}. This is then transformed \
to \\\\usepackage{package}\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexInitLatexExtraCode", "::", "usage"}], "=", 
   "\"\<Extra lines for definition of special LaTeX commands. This should be \
a list of strings.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexPrintAlignedEquations", "::", "usage"}], " ", "=", 
   "\"\<TexPrintAlignedEquations takes a list of equations and typesets them \
in an align environment with line breaking so the total length does not \
exceed $TexPrintPageWidth.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexPrintPageWidth", "::", "usage"}], " ", "=", " ", 
   "\"\<Parameter to adjust the line breaking for TexPrintAlignedEquations. \
This is measured in printer points. Observe that you can use the textwidth \
variable which is read from the latex environment.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"latextextwidth", "::", "usage"}], "=", 
   "\"\<A symbol representing the textwidth variable in the current latex \
environment.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FormatTexBasis", "::", "usage"}], " ", "=", 
   "\"\<FormatTexBasis works the same way as FormatBasis, but for the Tex \
output.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EquationMarks", "::", "usage"}], " ", "=", 
   "\"\<An option for TexBreak to include \\\\begin{equation} \
\\\\end{equation} or similar constructions. Default is False, but a standard \
value would be \\\"equation\\\". Warning, do not use this on TexPrint if the \
result is passed to TexBreak.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddEquationMarks", "::", "usage"}], "=", 
   "\"\<Adds \\\\begin{equation} \\\\end{equation} or similar constructions \
to a tex string. The default is Automatic which makes an educated \
guess.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexView", "::", "usage"}], "=", 
   "\"\<TexView is used to compile and view tex output. The first argument \
can be a tex string, a list of equations, a single equation or expression. A \
second optional argument can be given to set the file name without extension. \
The compiler is set by $LatexExecutable. The file extension of the file to \
view is set by $TexViewExt.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexPort", "::", "usage"}], "=", 
   "\"\<Does the same thing as TexView, but it does not open the file. A file \
name must be given as a second argument.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$LatexExecutable", "::", "usage"}], " ", "=", 
   "\"\<Command for compiling LaTeX. The default is pdflatex. Add the path to \
the file if the default value does not work.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexViewExt", "::", "usage"}], " ", "=", " ", 
   "\"\<The file extension for output file to view. The defailt is .pdf. If \
you want to open the .tex file in your default editor use .tex instead. \
Observe however that TexView overwrites files without asking so editing this \
file might not be a good idea.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexPrintAlignedExpressions", "::", "usage"}], "=", 
   "\"\<Takes a list of expressions, and typesets them in an aligned \
environment.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EnableTexColor", "::", "usage"}], "=", 
   "\"\<EnableTexColor[] enables the use of colors in the tex output.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DisableTexColor", "::", "usage"}], "=", 
   "\"\<DisableTexColor[] disables the use of colors in the tex \
output.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ParenthesisOldStyle", "::", "usage"}], "=", 
   "\"\<ParenthesisOldStyle can be given as a second argument to TexPrint to \
recover the old style of counting parenthesis levels.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexOverline", "::", "usage"}], "=", 
   "\"\<TexOverline[str] returns \\\\overline{str}.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexUnderline", "::", "usage"}], "=", 
   "\"\<TexUnderline[str] returns \\\\underline{str}\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBar", "::", "usage"}], "=", 
   "\"\<TexBar[str] returns \\\\bar{str}\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexTilde", "::", "usage"}], "=", 
   "\"\<TexTilde[str] returns \\\\tilde{str}\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexHat", "::", "usage"}], "=", 
   "\"\<TexHat[str] returns \\\\hat{str}\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexColor", "::", "usage"}], "=", 
   "\"\<TexColor[str, RGBColor[r, g, b]] adds Tex code to color the string \
str. Please use EnableTexColor first.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OrderedPlus", "::", "usage"}], "=", 
   "\"\<OrderedPlus can be used instead of Plus when printing if a different \
term ordering than the Standard Mathematica term ordering is required. \
Observe that OrderedPlus is intended for printing, not for \
calculations.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToOrderedPlus", "::", "usage"}], "=", 
   "\"\<ToOrderedPlus is a rule that transformes Plus expressions to an \
OrderedPlus with the terms sorted with the function \
$ToOrderedPlusSortFunc\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToOrderedPlusSortFunc", "::", "usage"}], "=", 
   "\"\<ToOrderedPlusSortFunc is a sorting function for ToOrderedPlus.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "$TexMatrixParen", "=", 
   "\"\<$TexMatrixParen sets the parenthesis type for matrices.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexLabelName", "::", "usage"}], " ", "=", 
   "\"\<TexLabelName[\\\"eqname\\\"] gives the tex label of the equation \
stored in the variable eqname.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBreakInParenthesis", "::", "usage"}], "=", 
   "\"\<TexBreakInParenthesis is an option for TexBreak. When set to False, \
no linebreaking is allowed within a parenthesis. If given a numerical value \
this limits the breaking to that parenthesis level.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexNoSumInNumerator", "::", "usage"}], " ", "=", " ", 
   "\"\<If $TexNoSumInNumerator is set to True, Tex will move all sums in \
numerators out of fractions.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexInitLatexInternalClassCode", "::", "usage"}], "=", 
   "\"\<The document class code for by TexView if \
$TexViewInternal==True.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexViewInternal", "::", "usage"}], "=", 
   "\"\<If $TexViewInternal==True, TexView will open the typset file in \
Mathematica instead of an external viewer. Observe that \
$TexInitLatexInternalClassCode will be used instead of $TexInitLatexClassCode \
in this case.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$TexViewResolution", "::", "usage"}], "=", 
   "\"\<If $TexViewInternal==True, TexView will open he typset file in \
Mathematica using the resolution $TexViewResolution.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "::", "usage"}], " ", "=", 
   "\"\<OpenParenthesis[level, char] determines how an opening parenthesis at \
level with default character char will be displayed. If one for instance \
wants brackets instead of round parenthesis at level 1, set \
OpenParenthesis[1,\\\"(\\\"]:=\\\"\\\\bigl [\\\"\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CloseParenthesis", "::", "usage"}], " ", "=", 
   "\"\<CloseParenthesis[level, char] determines how a closing parenthesis at \
level with default character char will be displayed. If one for instance \
wants brackets instead of round parenthesis at level 1, set \
CloseParenthesis[1,\\\")\\\"]:=\\\"\\\\bigl ]\\\"\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LastPunctuation", "::", "usage"}], "=", 
   "\"\<LastPunctuation is an option for TexPrintAlignedEquations indicting \
if the equation should end with a , or .\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBreakAvoidEnvs", "::", "usage"}], "=", 
   "\"\<TexBreakAvoidEnvs is an option for TexBreak. This should be a list of \
latex environments that we don't allow breaking inside.\>\""}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->CompressedData["
1:eJwd0GtIk3EYBfA1uzFMl4ZohbrSNWY5tZpmafybJaap1ZTUyhjZ3exCajEv
YWPlZUHNSjGlOastJy6tSCtTZ4YZrTGlXBcL6fK+k3W1RaK9xw8PP86Xc+Dh
yXK2ZLFZLNYq5uD0jLDqQAVFxpPGrkLC3qGBXEGZHo451RI+o3n7zzi4fBld
1HuJIvuyJGdgR/5M1xIDRXL7ts2Fspp7jTeaKTI8YOqAN72etOoY+U5JJ/Qd
GfLsZ1SFvFsC5TaFJek2RXYbgq3wZT39LJlx5byNz2H0FZ4FruEfscLPPuru
onam9272P2i2901CVdABVjGjdbZGf4/xZWKcEfYMT9yBa5X5ZriwkCe6z3jo
m1oMXSP/lEDfPxEVkMtOuAjNgllVUN9enyZ8QBHaaMyBrxI55+CKwYIaeILj
rYHSaXVaWOuzXgfnyKIa4ZWzhT3ww/ELfdC/jrUglNHdussPksCPQvhb5R0E
K8tjOqFYoDfBlqrcp/BL2NtB6F1cMwlD9lun1Et/WLK7KOLmKLNN2eozBvdw
eU74qTJmHArSu9wOM+ZvvuUHLwmU/vCxrzMALlXwA+HNcMnXcBtF2uTBDljk
ed2y+A3zl+drhmFAntfWkU/MbnZOBsz8Lec4vlMkbXu3KzSN/C2lhTQxHRjU
w9bYHcl7g2myboC1Fe7T9KRCdvK7vVCU5WFgH6TJ+dSdb+E2XtMMF8Yow2sO
TFFdlsMjkwkFcH5a2V3HUZpoN+i64e6E+NzoJpoIPSIKYOPQ4tPwjcWugOmc
9y1+vTQpn4h4BFNF/IwGxt7JvGOwzSgW8Z7S5FlFcSwsHJDGw3KpVjqV3Q5G
9wfaycc2901Q05DCzcu1k+prpYugcOEvIVS7+CyDT4zOUBjpqRTD5hcyS63W
TiyZq21weLr9ZEL4KDEHPFTCmF/t2a6Fo0Q+pDsF/wM6Od0E
  "],
 CellLabel->"In[41]:=",ExpressionUUID->"f680fbcd-75c0-48e6-905e-0393974f1e4c"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5. Begin private section", "Subsection",ExpressionUUID->"bc355029-52ca-4a2d-9c7a-3472eb7c75bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[100]:=",ExpressionUUID->"dcf3a5f4-7473-4a52-a72d-21a3b8feeea7"],

Cell[BoxData["\<\"xAct`TexAct`Private`\"\>"], "Output",
 CellChangeTimes->{
  3.6799839656884995`*^9, 3.6799846652466497`*^9, 3.6977391820471783`*^9, 
   3.697739237018255*^9, {3.715232885986195*^9, 3.7152328890302873`*^9}, {
   3.715233056499871*^9, 3.715233059750037*^9}, {3.715233737606416*^9, 
   3.715233740941792*^9}, 3.727334892735279*^9, 3.727335232293561*^9, 
   3.7273353261722326`*^9, 3.727336137712865*^9, 3.727336229943851*^9, 
   3.7273364607373*^9, 3.727336730862235*^9, 3.727337052446697*^9, 
   3.727340509363693*^9, 3.727340617792341*^9, 3.7273407343035803`*^9, 
   3.727341327653751*^9, 3.7273420689124203`*^9, 3.727343581351035*^9, 
   3.727343664780305*^9, 3.727343744520786*^9, 3.727343852600831*^9, 
   3.727410642366946*^9, 3.728277227198322*^9, 3.728278160963824*^9, 
   3.728278482061179*^9, {3.728278603663279*^9, 3.7282786226864977`*^9}, 
   3.72828051648822*^9, 3.728280819542403*^9, 3.7282809919051695`*^9, 
   3.728483762657572*^9, 3.728551299992142*^9, 3.7285517958820877`*^9, 
   3.7288045671631827`*^9, 3.7288046900552115`*^9, 3.7288085163902435`*^9, 
   3.728808855695975*^9, {3.777913995087641*^9, 3.777914004040304*^9}, 
   3.777914075962244*^9, 3.791093792980037*^9, 3.7910939396856728`*^9, 
   3.820204745193436*^9, 3.820207203173885*^9, 3.820207362937124*^9, 
   3.8427624583760443`*^9, 3.8443900023578415`*^9, 3.844390071181341*^9, 
   3.844390671783173*^9, 3.8443910736494718`*^9, 3.875891572655247*^9, 
   3.875891993063697*^9, 3.921306828640764*^9, 3.9213069033691196`*^9, 
   3.9213069475350075`*^9, 3.9584003330312233`*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"83e37303-2d6e-3844-8b86-1f07d5d4ac41"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Parentheses", "Section",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"d1b9726f-1155-4170-b8a2-2848a514dd15"],

Cell[CellGroupData[{

Cell["2.1. Open and close parentheses", "Subsection",ExpressionUUID->"8109d6e6-8186-421a-8b5c-0b98eb41363f"],

Cell["We define a hierarchy of parenthesis.", "Text",ExpressionUUID->"ac1a6da4-daab-4756-9df3-106b447760b8"],

Cell[TextData[{
 "There is a global variable ",
 StyleBox["level", "Input"],
 " that stores the parenthesization level at each particular time. There is \
also the global variable ",
 StyleBox["minlevel", "Input"],
 ". The idea is that each call to TexMaximumLevel has a Block with these two \
variables. This is not very elegant."
}], "Text",ExpressionUUID->"4073dc58-daa0-45bd-a344-8f8635d187fe"],

Cell[TextData[{
 "TB: A possible alternative would be to typeset once, and add a special \
\[OpenCurlyDoubleQuote]open\[CloseCurlyDoubleQuote] symbol and a \
\[OpenCurlyDoubleQuote]close\[CloseCurlyDoubleQuote] symbol. Another string \
",
 StyleBox["parenthesisstring",
  FontSlant->"Italic"],
 " can contain just the \[OpenCurlyDoubleQuote]open\[CloseCurlyDoubleQuote] \
and \[OpenCurlyDoubleQuote]close\[CloseCurlyDoubleQuote] symbols. This string \
can be built either from the Tex string. At the final pass the \
\[OpenCurlyDoubleQuote]open\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]close\[CloseCurlyDoubleQuote] symbols in the Tex \
string can be replaced by the correct Tex code with a level that can be \
computed by tracing backwards or forwards in ",
 StyleBox["parenthesisstring",
  FontSlant->"Italic"],
 " until the matching \[OpenCurlyDoubleQuote]open\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]close\[CloseCurlyDoubleQuote]  symbol is found."
}], "Text",
 CellChangeTimes->{{3.604591698637143*^9, 3.604591786197266*^9}, {
   3.604591882707401*^9, 3.60459191062744*^9}, {3.604591941357483*^9, 
   3.604592023687598*^9}, {3.604592102447708*^9, 3.6045922870160856`*^9}, {
   3.6045923314261475`*^9, 3.604592475236349*^9}, 3.60507753165971*^9, 
   3.6050775778197746`*^9, {3.605078218671672*^9, 3.605078269581743*^9}, {
   3.605079439943381*^9, 3.605079494813458*^9}, {3.605079540933523*^9, 
   3.6050795940535975`*^9}, {3.6050816576994886`*^9, 3.605081659789491*^9}, {
   3.6050817176395726`*^9, 
   3.605081736399598*^9}},ExpressionUUID->"aae7169c-fe09-49f9-98f9-\
40b86c14ce9b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexParenthesisNewstyle", "=", "False"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.605015956185479*^9, 3.605015980195513*^9}, {
  3.605016720586549*^9, 3.605016721236551*^9}, {3.605077330349428*^9, 
  3.6050773306494284`*^9}, {3.605081740789604*^9, 3.605081741209605*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"ca8bd73f-cc8f-4d97-980d-0d4dfd2327db"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$TexOpenParChar", "=", 
   RowBox[{"FromCharacterCode", "[", "23", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$TexDelimParChar", "=", 
   RowBox[{"FromCharacterCode", "[", "16", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$TexCloseParChar", "=", 
   RowBox[{"FromCharacterCode", "[", "25", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.605014267202114*^9, 3.60501427837213*^9}, {
   3.605014426872338*^9, 3.605014443612361*^9}, {3.7288016969670177`*^9, 
   3.72880170768563*^9}, 3.7288017663979893`*^9, {3.728801853570975*^9, 
   3.7288018539489956`*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"10654146-f54c-4397-8e79-be1f416e6530"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TexOpen", "[", "string_String", "]"}], ":=", 
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{
     RowBox[{"Decrement", "[", "level", "]"}], ",", "string"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexClose", "[", "string_String", "]"}], ":=", 
   RowBox[{"CloseParenthesis", "[", 
    RowBox[{
     RowBox[{"PreIncrement", "[", "level", "]"}], ",", "string"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.72880064434081*^9, 3.728800655772464*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"f91669ac-0b40-4345-98dc-481b5e94164a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Trick", " ", "to", " ", "count", " ", "maximum", " ", "depth"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"OpenParenthesis", "[", 
      RowBox[{
       RowBox[{"level_Integer", "?", "Negative"}], ",", "string_String"}], 
      "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{"$TexParenthesisNewstyle", ",", 
       RowBox[{"$TexOpenParChar", "<>", "string", "<>", "$TexDelimParChar"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"minlevel", "=", 
          RowBox[{"Min", "[", 
           RowBox[{"minlevel", ",", "level"}], "]"}]}], ";", "string"}], 
        ")"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CloseParenthesis", "[", 
      RowBox[{
       RowBox[{"level_Integer", "?", "Negative"}], ",", "string_String"}], 
      "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{"$TexParenthesisNewstyle", ",", 
       RowBox[{"$TexCloseParChar", "<>", "string", "<>", "$TexDelimParChar"}],
        ",", "\[IndentingNewLine]", "string"}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6050160602756243`*^9, 3.6050160851856594`*^9}, {
  3.6050161165457034`*^9, 3.605016168235776*^9}, {3.6050813979191236`*^9, 
  3.6050814211991568`*^9}, {3.728800597823149*^9, 3.7288006100458484`*^9}, {
  3.728800661337782*^9, 3.728800731309784*^9}, {3.7288017745574555`*^9, 
  3.728801777853644*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"9349a50a-4a21-4485-b8b5-fe77066874cf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{"0", ",", "str_"}], "]"}], ":=", "str"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CloseParenthesis", "[", 
     RowBox[{"0", ",", "str_"}], "]"}], ":=", "str"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{"1", ",", "str_"}], "]"}], ":=", 
   RowBox[{"\"\<\\\\bigl\>\"", "<>", "str"}]}], ";"}], "\[IndentingNewLine]", 

 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CloseParenthesis", "[", 
     RowBox[{"1", ",", "str_"}], "]"}], ":=", 
    RowBox[{"\"\<\\\\bigr\>\"", "<>", "str"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{"2", ",", " ", "str_"}], "]"}], ":=", 
   RowBox[{"\"\<\\\\Bigl\>\"", "<>", "str"}]}], ";"}], "\[IndentingNewLine]", 

 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CloseParenthesis", "[", 
     RowBox[{"2", ",", "str_"}], "]"}], ":=", 
    RowBox[{"\"\<\\\\Bigr\>\"", "<>", "str"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{"3", ",", "str_"}], "]"}], ":=", 
   RowBox[{"\"\<\\\\biggl\>\"", "<>", "str"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CloseParenthesis", "[", 
     RowBox[{"3", ",", "str_"}], "]"}], ":=", 
    RowBox[{"\"\<\\\\biggr\>\"", "<>", "str"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{"4", ",", "str_"}], "]"}], ":=", 
   RowBox[{"\"\<\\\\Biggl\>\"", "<>", "str"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CloseParenthesis", "[", 
     RowBox[{"4", ",", "str_"}], "]"}], ":=", 
    RowBox[{"\"\<\\\\Biggr\>\"", "<>", "str"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{
     RowBox[{"level_Integer", "?", "Positive"}], ",", "str_"}], "]"}], ":=", 
   RowBox[{"\"\<\\\\left\>\"", "<>", "str"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CloseParenthesis", "[", 
    RowBox[{
     RowBox[{"level_Integer", "?", "Positive"}], ",", "str_"}], "]"}], ":=", 
   RowBox[{"\"\<\\\\right\>\"", "<>", "str"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.605014998553138*^9, 3.605015004793147*^9}, {
  3.728800765449737*^9, 3.728800866113495*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"0f9115a4-615a-475f-8fb1-a2232303bcb8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Main", ".", " ", "Private"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"TexMaximumLevel", "[", "expr_", "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"level", "=", "0"}], ",", 
        RowBox[{"minlevel", "=", "0"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"Tex", "[", "expr", "]"}], ";", 
       RowBox[{"-", "minlevel"}]}]}], "]"}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[121]:=",ExpressionUUID->"dbf513dd-d1c0-423e-bf16-4fe42b26e16a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Safety", " ", "definitions", " ", "for", " ", "direct", " ", "examples", 
    " ", "with", " ", "Tex"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"level", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minlevel", "=", "0"}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[122]:=",ExpressionUUID->"83c5c553-48b6-4c7e-9f7a-c4efe900a3e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. Main function", "Subsection",ExpressionUUID->"cc430464-7283-4200-b40c-a9f452aeb9ac"],

Cell["\<\
The key idea here is that there are two calls to the function Tex. We first \
run through the whole expression with TexMaximumLevel, which uses Tex, to \
discover the number of parentheses needed. In this first run the resulting \
expression string  has wrong parentheses (actually no parentheses). Then we \
call Tex again, this time producing the correct parentheses. If we provide \
the second argument of TexParenthesis then we avoid the first run.\
\>", "Text",ExpressionUUID->"03a37158-9e9a-449a-97a7-c7d078428b2a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$VerboseParenthesizationLevel", "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexParenthesis", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"initlevel_", ":", "Automatic"}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"initlevel", "===", "Automatic"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"level", "=", 
          RowBox[{"-", "1"}]}], ",", 
         RowBox[{"$TexParenthesisNewstyle", "=", "True"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlaceParenthesis", "@", 
        RowBox[{"Tex", "[", "expr", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"level", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"initlevel", "===", "ParenthesisOldStyle"}], ",", 
           RowBox[{"TexMaximumLevel", "[", "expr", "]"}], ",", "initlevel"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{"$VerboseParenthesationLevel", ",", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Maximum parenthesization level: \>\"", ",", "level"}],
            "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Tex", "[", "expr", "]"}]}]}], "\[IndentingNewLine]", "]"}]}],
     "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6050161963058147`*^9, 3.605016291085948*^9}, {
  3.6050167868066416`*^9, 3.60501680711667*^9}, {3.605016868666757*^9, 
  3.605016910096814*^9}, {3.6050191844251165`*^9, 3.605019185115117*^9}, {
  3.605077783110061*^9, 3.605077790650072*^9}, {3.6050819010698285`*^9, 
  3.605081930509869*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"e1ae01c9-57d9-4ec0-8e54-869d79f58526"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PlaceParenthesis", "[", "texinstr_String", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"parchars", "=", 
        RowBox[{"StringCases", "[", 
         RowBox[{"texinstr", ",", 
          RowBox[{"Alternatives", "[", 
           RowBox[{"$TexOpenParChar", ",", "$TexCloseParChar"}], "]"}]}], 
         "]"}]}], ",", "substrings", ",", " ", "currentparchar", ",", 
       RowBox[{"texstring", "=", "\"\<\>\""}], ",", 
       RowBox[{"i", "=", "1"}], ",", "j", ",", "parlevel", ",", " ", 
       "maxparlevel"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"substrings", "=", 
       RowBox[{"StringSplit", "[", 
        RowBox[{"texinstr", ",", 
         RowBox[{"Alternatives", "[", 
          RowBox[{
          "$TexOpenParChar", ",", "$TexCloseParChar", ",", 
           "$TexDelimParChar"}], "]"}], ",", "All"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"texstring", "=", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"texstring", ",", 
         RowBox[{"First", "@", "substrings"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", "substrings"}], ">", "1"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"substrings", "=", 
          RowBox[{"Rest", "@", "substrings"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"currentparchar", "=", 
          RowBox[{"First", "@", "substrings"}]}], ";", "\[IndentingNewLine]", 
         
         RowBox[{"substrings", "=", 
          RowBox[{"Rest", "@", "substrings"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"i", "\[LessEqual]", " ", 
             RowBox[{"Length", "@", "parchars"}]}], "&&", 
            RowBox[{
             RowBox[{"parchars", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "===", "$TexOpenParChar"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"j", "=", 
             RowBox[{"i", "+", "1"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"parlevel", "=", "1"}], ";", "\[IndentingNewLine]", 
            RowBox[{"maxparlevel", "=", "1"}], ";", "\[IndentingNewLine]", 
            RowBox[{"While", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"j", "\[LessEqual]", " ", 
                RowBox[{"Length", "@", "parchars"}]}], "&&", 
               RowBox[{"parlevel", ">", "0"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"parchars", "[", 
                   RowBox[{"[", "j", "]"}], "]"}], "===", "$TexOpenParChar"}],
                  ",", 
                 RowBox[{"maxparlevel", "=", 
                  RowBox[{"Max", "[", 
                   RowBox[{"maxparlevel", ",", 
                    RowBox[{"++", "parlevel"}]}], "]"}]}], ",", 
                 RowBox[{"parlevel", "--"}]}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"j", "++"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"texstring", "=", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"texstring", ",", 
               RowBox[{"OpenParenthesis", "[", 
                RowBox[{
                 RowBox[{"maxparlevel", "-", "1"}], ",", "currentparchar"}], 
                "]"}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"i", "\[LessEqual]", " ", 
             RowBox[{"Length", "@", "parchars"}]}], "&&", 
            RowBox[{
             RowBox[{"parchars", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "===", "$TexCloseParChar"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"j", "=", 
             RowBox[{"i", "-", "1"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"parlevel", "=", "1"}], ";", "\[IndentingNewLine]", 
            RowBox[{"maxparlevel", "=", "1"}], ";", "\[IndentingNewLine]", 
            RowBox[{"While", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"j", "\[GreaterEqual]", " ", "1"}], "&&", 
               RowBox[{"parlevel", ">", "0"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"parchars", "[", 
                   RowBox[{"[", "j", "]"}], "]"}], "===", 
                  "$TexCloseParChar"}], ",", 
                 RowBox[{"maxparlevel", "=", 
                  RowBox[{"Max", "[", 
                   RowBox[{"maxparlevel", ",", 
                    RowBox[{"++", "parlevel"}]}], "]"}]}], ",", 
                 RowBox[{"parlevel", "--"}]}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"j", "--"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"texstring", "=", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"texstring", ",", 
               RowBox[{"CloseParenthesis", "[", 
                RowBox[{
                 RowBox[{"maxparlevel", "-", "1"}], ",", "currentparchar"}], 
                "]"}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"i", "++"}], ";", "\[IndentingNewLine]", 
         RowBox[{"texstring", "=", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"texstring", ",", 
            RowBox[{"First", "@", "substrings"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "texstring"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6050183452939415`*^9, 3.605018470384117*^9}, {
  3.605018580314271*^9, 3.605018691144426*^9}, {3.605018724634473*^9, 
  3.605018766794532*^9}, {3.605018796884574*^9, 3.605018842594638*^9}, {
  3.605018877054686*^9, 3.60501888002469*^9}, {3.605018934284766*^9, 
  3.60501905827494*^9}, {3.605019116255021*^9, 3.605019157695079*^9}, {
  3.605019193905129*^9, 3.605019228025178*^9}, {3.605076697588542*^9, 
  3.605076761878632*^9}, {3.6050793305232277`*^9, 3.6050793786932955`*^9}, {
  3.6050817692196436`*^9, 3.605081784199665*^9}, {3.605786520851544*^9, 
  3.605786521541544*^9}, {3.728801082375864*^9, 3.728801104662139*^9}, {
  3.728801286612546*^9, 3.728801298828244*^9}, {3.728803782074278*^9, 
  3.728803838528507*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"577b9972-74c7-4e0b-88ff-d46640381077"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3. Alternative code. Not used", "Subsection",ExpressionUUID->"9c261caa-46c6-46df-898a-808577c96786"],

Cell["\<\
This is some alternative code whose origin or purpose has been forgotten... \
It is not included in the package.\
\>", "Text",ExpressionUUID->"28d1afb5-6250-43d5-b0d9-9226c34ca9ab"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ZParenth", "[", 
     RowBox[{"ZParenth", "[", "expr_", "]"}], "]"}], ":=", 
    RowBox[{"ZParenth", "[", "expr", "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", "Atoms", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddParenth", "[", 
    RowBox[{"x", ":", 
     RowBox[{"(", 
      RowBox[{
      "_Symbol", "|", "_String", "|", "_Integer", "|", "_Rational", "|", 
       "_Real"}], ")"}]}], "]"}], ":=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AddParenth", "[", "x_Complex", "]"}], ":=", 
    RowBox[{"ZParenth", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Products", " ", "and", " ", "sums"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddParenth", "[", 
    RowBox[{"Times", "[", 
     RowBox[{"x_", ",", "y_Plus"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AddParenth", "[", "x", "]"}], 
    RowBox[{"ZParenth", "[", 
     RowBox[{"AddParenth", "[", "y", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddParenth", "[", "expr_Times", "]"}], ":=", 
   RowBox[{"AddParenth", "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AddParenth", "[", "expr_Plus", "]"}], ":=", 
    RowBox[{"AddParenth", "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", "Powers", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddParenth", "[", 
    RowBox[{"Power", "[", 
     RowBox[{
      RowBox[{"x", ":", 
       RowBox[{"(", 
        RowBox[{"_Symbol", "|", 
         RowBox[{
          RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}]}], ")"}]}], ",", 
      "n_"}], "]"}], "]"}], ":=", 
   RowBox[{"Power", "[", 
    RowBox[{
     RowBox[{"AddParenth", "[", "x", "]"}], ",", 
     RowBox[{"AddParenth", "[", "n", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AddParenth", "[", 
     RowBox[{"Power", "[", 
      RowBox[{"x_", ",", "n_"}], "]"}], "]"}], ":=", 
    RowBox[{"Power", "[", 
     RowBox[{
      RowBox[{"ZParenth", "[", 
       RowBox[{"AddParenth", "[", "x", "]"}], "]"}], ",", 
      RowBox[{"AddParenth", "[", "n", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", "Objects", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddParenth", "[", 
    RowBox[{"t", ":", 
     RowBox[{
      RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}]}], "]"}], ":=", "t"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddParenth", "[", 
    RowBox[{"c", ":", 
     RowBox[{
      RowBox[{
       RowBox[{"_Symbol", "?", "CovDQ"}], "[", "__", "]"}], "[", "_", "]"}]}],
     "]"}], ":=", "c"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AddParenth", "[", "c_CovD", "]"}], ":=", "c"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Scalar", " ", "functions", " ", "and", " ", "inert", " ", "heads"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddParenth", "[", 
    RowBox[{
     RowBox[{"f_", "?", "ScalarFunctionQ"}], "[", "exprs__", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AddParenth", "[", "f", "]"}], "[", 
    RowBox[{"AddParenth", "/@", 
     RowBox[{"OParenth", "[", "exprs", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AddParenth", "[", 
     RowBox[{
      RowBox[{"ih_Symbol", "?", "InertHeadQ"}], "[", 
      RowBox[{"expr_", ",", "z___"}], "]"}], "]"}], ":=", 
    RowBox[{"ih", "[", 
     RowBox[{
      RowBox[{"OParenth", "[", 
       RowBox[{"AddParenth", "[", "expr", "]"}], "]"}], ",", "z"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Parametric", " ", "derivatives"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddParenth", "[", 
    RowBox[{
     RowBox[{"ParamD", "[", "ps__", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"ParamD", "[", "ps", "]"}], "[", 
    RowBox[{"OParenth", "[", 
     RowBox[{"AddParenth", "[", "expr", "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AddParentheses", "[", "expr_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Pexpr", "=", 
       RowBox[{"AddParenth", "[", "expr", "]"}]}], ",", "pos"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pos", "=", 
      RowBox[{"Most", "/@", 
       RowBox[{"Position", "[", 
        RowBox[{"Pexpr", ",", "ZParenth", ",", 
         RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}]}], ";"}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.6165042940696087`*^9, 3.616504300589618*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"2de6adbe-1710-477c-995a-b6e5b738f7cd"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Type formatting", "Section",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"c134f083-93e5-4e8e-bd7c-f0a1dd86faff"],

Cell[CellGroupData[{

Cell["3.0. The Tex function", "Subsection",ExpressionUUID->"a9e39fd1-11a6-4f6b-a5aa-2180390641cd"],

Cell[TextData[{
 "The function Tex does most of the actual construction of the final string. \
It gets directly the ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " expressions and returns a string. The final result will be simply a \
concatenation of the individual strings, except for the parenthesization \
issues."
}], "Text",ExpressionUUID->"e54eb1b8-5fcb-4e0b-b056-f06fcbb085e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Just", " ", "in", " ", "case"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Tex", "[", "]"}], ":=", "\"\<\>\""}], ";"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[142]:=",ExpressionUUID->"2c125385-57f0-4ad1-84f3-850e67d67f67"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1. Fractions", "Subsection",ExpressionUUID->"be55406d-d073-4f39-a3eb-673c7361d305"],

Cell["\<\
Because some people might want to use the \"\\\\tfrac\" or \"\\\\dfrac\" \
commands of amsmath, we introduce these two variables:\
\>", "Text",ExpressionUUID->"8dd21851-7809-4a50-a2e6-a109002300aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "$TexFraction"}]], "Input",
 CellLabel->
  "In[143]:=",ExpressionUUID->"d8ec4062-9fd4-4b24-b7d4-ede3fcd0a8ee"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$TexFraction is a global variable specifying the \
Tex command to be used to format fractions, with default \
\\\"\\\\frac\\\".\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`TexAct`$TexFraction\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$TexFraction is a global variable specifying the \
Tex command to be used to format fractions, with default \
\\\"\\\\frac\\\".\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {2.93359375, 7.06640625}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {2.93359375, 7.06640625}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "$TexFraction is a global variable specifying the Tex command to be used \
to format fractions, with default \"\\frac\".", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`TexAct`$TexFraction"|>, False]]], "Output",
 CellChangeTimes->{3.7910937937655935`*^9, 3.7910939443302813`*^9, 
  3.820204745449241*^9, 3.820207204212864*^9, 3.820207363127122*^9, 
  3.8427624586503105`*^9, 3.844390002603184*^9, 3.844390071404775*^9, 
  3.8443906719716682`*^9, 3.844391073874892*^9, 3.87589157292752*^9, 
  3.8758919931854*^9, 3.921306828799341*^9, 3.9213069035107403`*^9, 
  3.9213069476576805`*^9, 3.9584003331738567`*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"5da3ca3f-35c5-034f-9cf9-514226889028"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "$TexSmallFraction"}]], "Input",
 CellLabel->
  "In[144]:=",ExpressionUUID->"c6b8fdb1-a4ab-4f18-a2a7-b0febaa451c4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$TexSmallFraction is a global variable specifying \
the Tex command to be use to format rational numbers, with default \
\\\"\\\\tfrac\\\".\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`TexAct`$TexSmallFraction\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$TexSmallFraction is a global variable specifying \
the Tex command to be use to format rational numbers, with default \
\\\"\\\\tfrac\\\".\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {2.93359375, 7.06640625}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {2.93359375, 7.06640625}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "$TexSmallFraction is a global variable specifying the Tex command to be \
use to format rational numbers, with default \"\\tfrac\".", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`TexAct`$TexSmallFraction"|>, False]]], "Output",
 CellChangeTimes->{3.7910937939859*^9, 3.791093944681297*^9, 
  3.820204745546981*^9, 3.820207204289595*^9, 3.820207363219846*^9, 
  3.84276245881088*^9, 3.844390002653051*^9, 3.844390071450649*^9, 
  3.8443906720245275`*^9, 3.8443910739217715`*^9, 3.875891573129977*^9, 
  3.875891993243217*^9, 3.9213068288741417`*^9, 3.9213069035885563`*^9, 
  3.9213069477335033`*^9, 3.9584003332214622`*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"7f372ac1-825f-0947-8c5e-53563c9a520b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$TexFraction", "=", "\"\<\\\\frac\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$TexSmallFraction", "=", "\"\<\\\\tfrac\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$TexSmallFractionExponent", "=", "False"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.580631092428563*^9, 3.5806311134729996`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"90fe1d75-9328-4542-a18f-5995304e5979"],

Cell["\<\
Code to avoid printing fractions as products. One can avoid all fractions \
except rationals and square roots by setting TexFractionAsFraction->False.\
\>", "Text",ExpressionUUID->"b14f01b9-9ae6-4bf5-b872-a2324d23ac80"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexFrac1", "[", 
    RowBox[{"numer_", ",", " ", "denom_", ",", "fracsymbol_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"fracsymbol", "===", "False"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"Tex", "[", "numer", "]"}], ",", "\"\</\>\"", ",", 
       RowBox[{"Tex", "[", "denom", "]"}]}], "]"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"fracsymbol", ",", "\"\<{\>\"", ",", 
       RowBox[{"Tex", "[", "numer", "]"}], ",", "\"\<}{\>\"", ",", 
       RowBox[{"Tex", "[", "denom", "]"}], ",", "\"\<}\>\""}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.544081263018608*^9, 3.544081269024619*^9}, {
   3.544081300926675*^9, 3.544081340160744*^9}, {3.5445960831255026`*^9, 
   3.544596103606674*^9}, {3.544601539731603*^9, 3.544601544964902*^9}, 
   3.544601622334328*^9, {3.544601670188064*^9, 3.5446016772024655`*^9}, 
   3.580631070323324*^9},
 CellLabel->
  "In[148]:=",ExpressionUUID->"bceae0a3-9cd6-4710-9a5e-170877d2c684"],

Cell["\<\
If the numerator has a factor which is a sum, move it out if \
$TexNoSumInNumerator==True. \
\>", "Text",
 CellChangeTimes->{{3.544601259023547*^9, 3.5446012927774787`*^9}, {
  3.5446014040348406`*^9, 3.544601416152535*^9}, {3.728276767764465*^9, 
  3.7282768656845927`*^9}},ExpressionUUID->"5e07f0c3-6e28-458d-a07a-\
90708d3c1e27"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$TexNoSumInNumerator", "=", "False"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TexFracExpression", "[", 
    RowBox[{"numer_", ",", " ", "denom_", ",", " ", "fracsymbol_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{"$TexNoSumInNumerator", ",", "\n", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"factorlist", "=", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Head", "[", "#", "]"}], "===", "Times"}], ",", 
               RowBox[{"List", "@@", "#"}], ",", 
               RowBox[{"{", "#", "}"}]}], "]"}], "&"}], "@", "numer"}], 
           ")"}]}], ",", "nosumfactors", ",", "sumfactors"}], "}"}], ",", 
       "\n", "  ", 
       RowBox[{
        RowBox[{"nosumfactors", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"factorlist", ",", 
           RowBox[{
            RowBox[{"Not", "@", 
             RowBox[{
              RowBox[{"MatchQ", "[", 
               RowBox[{"Plus", "|", "OrderedPlus"}], "]"}], "@", 
              RowBox[{"Head", "[", "#", "]"}]}]}], "&"}]}], "]"}]}], ";", 
        "\n", "  ", 
        RowBox[{"sumfactors", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"factorlist", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MatchQ", "[", 
              RowBox[{"Plus", "|", "OrderedPlus"}], "]"}], "@", 
             RowBox[{"Head", "[", "#", "]"}]}], "&"}]}], "]"}]}], ";", "\n", 
        "  ", 
        RowBox[{
         RowBox[{"TexFracExpression2", "[", 
          RowBox[{
           RowBox[{"Times", "@@", "nosumfactors"}], ",", " ", "denom", ",", 
           "fracsymbol"}], "]"}], "<>", 
         RowBox[{"TexOperator", "[", "Times", "]"}], "<>", 
         RowBox[{"TexFactor", "[", 
          RowBox[{"Times", "@@", "sumfactors"}], "]"}]}]}]}], "]"}], ",", 
     "\n", 
     RowBox[{"TexFracExpression2", "[", 
      RowBox[{"numer", ",", " ", "denom", ",", "fracsymbol"}], "]"}]}], 
    "]"}]}], ";"}]}], "Code",
 CellChangeTimes->{{3.728276729638881*^9, 3.728276736169013*^9}, {
   3.7282770175864344`*^9, 3.728277133457339*^9}, 3.7282773502025967`*^9, {
   3.7282775352002172`*^9, 3.7282775525147047`*^9}, {3.728277609977819*^9, 
   3.728277704024286*^9}, 3.728277892091427*^9, {3.728278024029795*^9, 
   3.728278101193147*^9}, {3.728278446736749*^9, 3.7282784549326982`*^9}, {
   3.728278584055101*^9, 3.728278584702806*^9}, {3.728280740214596*^9, 
   3.728280761116603*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"063e1fcf-68ef-49a1-85fa-16168535af69"],

Cell["If the numerator begins with a minus, we move the sign out. ", "Text",
 CellChangeTimes->{{3.544601259023547*^9, 3.5446012927774787`*^9}, {
  3.5446014040348406`*^9, 
  3.544601416152535*^9}},ExpressionUUID->"bad3f35d-a647-401a-b349-\
cd82e6b6dc6d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TexFracExpression2", "[", 
    RowBox[{"numer_OrderedPlus", ",", " ", "denom_", ",", "fracsymbol_"}], 
    "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"WithMinusQ", "[", "numer", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOperator", "[", "Minus", "]"}], ",", 
       RowBox[{"TexFrac1", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Times", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "#"}], "]"}], "&"}], "/@", "numer"}], 
         ",", "denom", ",", "fracsymbol"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"TexFrac1", "[", 
      RowBox[{"numer", ",", "denom", ",", "fracsymbol"}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexFracExpression2", "[", 
    RowBox[{"numer_", ",", " ", "denom_", ",", "fracsymbol_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"WithMinusQ", "[", "numer", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOperator", "[", "Minus", "]"}], ",", 
       RowBox[{"TexFrac1", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", "numer", ")"}]}], ",", "denom", ",", "fracsymbol"}], 
        "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"TexFrac1", "[", 
      RowBox[{"numer", ",", "denom", ",", "fracsymbol"}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.7282767412082295`*^9, {3.8427620483418694`*^9, 3.842762075992749*^9}},
 CellLabel->
  "In[151]:=",ExpressionUUID->"1c6acd26-42de-49b6-8eaa-3a2465fde7da"],

Cell["Detect the presence of a negative sign:", "Text",ExpressionUUID->"2d56a606-6efe-4121-ae16-4a7d3f52a19a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"WithMinusQ", "[", "expr_String", "]"}], ":=", 
   RowBox[{"SameQ", "[", 
    RowBox[{
     RowBox[{"StringTake", "[", 
      RowBox[{"expr", ",", "1"}], "]"}], ",", "\"\<-\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WithMinusQ", "[", "expr_", "]"}], ":=", 
   RowBox[{"WithMinusQ", "[", 
    RowBox[{"Tex", "[", "expr", "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[153]:=",ExpressionUUID->"816ff93a-13b5-4911-9341-b78e1a052a09"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. Numbers", "Subsection",ExpressionUUID->"a2920021-0310-4437-9b6a-142aa3cf10ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Numbers", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "x_Integer", "]"}], ":=", 
     RowBox[{"ToString", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "x_Real", "]"}], ":=", 
     RowBox[{"ToString", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "x_Rational", "]"}], ":=", 
     RowBox[{"TexFracExpression", "[", 
      RowBox[{
       RowBox[{"Numerator", "[", "x", "]"}], ",", 
       RowBox[{"Denominator", "[", "x", "]"}], ",", "$TexSmallFraction"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Complex", "[", 
       RowBox[{"0", ",", "1"}], "]"}], "]"}], "=", "\"\<i\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Complex", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}]}], "]"}], "]"}], "=", "\"\<-i\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Complex", "[", 
       RowBox[{"0", ",", "im_"}], "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"Tex", "[", "im", "]"}], ",", 
       RowBox[{"Tex", "[", "I", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Complex", "[", 
       RowBox[{"re_", ",", "im_"}], "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
       RowBox[{"Tex", "[", "re", "]"}], ",", "\"\<+\>\"", ",", 
       RowBox[{"Tex", "[", 
        RowBox[{"im", " ", "I"}], "]"}], ",", 
       RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[155]:=",ExpressionUUID->"9308bb6a-8391-47bc-b875-381b6d380fcc"],

Cell["Should we give definitions for other numeric objects here?", "Text",ExpressionUUID->"47758250-fa33-4c77-bb98-ae790243b978"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Numeric", " ", "expressions"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "E", "]"}], "=", "\"\<e\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Pi", "]"}], "=", "\"\<\\\\pi\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Infinity", "]"}], ":=", "\"\<\\\\infty \>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"-", "Infinity"}], "]"}], ":=", "\"\<-\\\\infty \>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9637314547848377`*^9, 3.96373146652837*^9}, {
  3.9637315625839825`*^9, 
  3.9637315636401825`*^9}},ExpressionUUID->"e2ec4615-70ff-4c9e-9a47-\
0159b263ec88"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. Strings and boxes", "Subsection",
 CellChangeTimes->{{3.646381433400581*^9, 3.646381438730589*^9}, {
  3.728800448727621*^9, 
  3.7288004501157007`*^9}},ExpressionUUID->"3f0da5d7-71f3-4a00-b1dc-\
f8069beb6b98"],

Cell["\<\
If we want pass a string straight through we can use this construction:\
\>", "Text",
 CellChangeTimes->{{3.583145079403295*^9, 3.583145103739338*^9}, {
  3.6165052685831175`*^9, 
  3.616505309323174*^9}},ExpressionUUID->"bb0be36a-1d66-4c2e-ae13-\
03ff34e8fa8a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"TexString", "[", "string_String", "]"}], "]"}], ":=", "string"}],
   ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6165053113631773`*^9, 3.616505339583216*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"19da7b3c-4ea6-4f5a-927e-22c44c11c61a"],

Cell["Special strings not properly handled by TeXForm", "Text",
 CellChangeTimes->{{3.583145079403295*^9, 
  3.583145103739338*^9}},ExpressionUUID->"4872346d-81ae-4839-b3e6-\
9791daac60e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\[Eth]\>\"", "]"}], "=", "\"\<\\\\eth \>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\\\"\>\"", "]"}], "=", "\"\<\\\"\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\\\\\>\"", "]"}], "=", "\"\<\\\\backslash\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\[GreaterTilde]\>\"", "]"}], "=", 
   "\"\<\\\\gtrsim\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.646374848325362*^9, {3.728544186773125*^9, 3.728544204848074*^9}, {
   3.72854709967225*^9, 3.7285471505048327`*^9}, {3.728563024314001*^9, 
   3.7285630513705487`*^9}, {3.9637314288561897`*^9, 
   3.9637314356799393`*^9}},ExpressionUUID->"7fa99e04-ebcc-4741-8537-\
4521ace5ff22"],

Cell["\<\
Special characters that requires the package textalpha or alphabeta. Make \
sure to add one of them to $TexInitLatexPackages before using.\
\>", "Text",
 CellChangeTimes->{{3.583145079403295*^9, 3.583145103739338*^9}, {
  3.8758908273257103`*^9, 
  3.8758909029334803`*^9}},ExpressionUUID->"198978a3-234f-4260-8121-\
c11017fa95af"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\[Koppa]\>\"", "]"}], "=", 
   "\"\<\\\\text{\\\\textqoppa}\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\[Sampi]\>\"", "]"}], "=", 
   "\"\<\\\\text{\\\\textsampi}\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\[CapitalKoppa]\>\"", "]"}], "=", 
   "\"\<\\\\text{\\\\textQoppa}\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\[CapitalSampi]\>\"", "]"}], "=", 
   "\"\<\\\\text{\\\\textSampi}\>\""}], ";"}]}], "Code",
 CellLabel->
  "In[169]:=",ExpressionUUID->"6a375090-6fd0-4aec-8bd7-e27e232787eb"],

Cell["\<\
Special characters that requires the package tipa. Make sure to add it to \
$TexInitLatexPackages before using.\
\>", "Text",
 CellChangeTimes->{{3.583145079403295*^9, 3.583145103739338*^9}, {
  3.8758908273257103`*^9, 3.8758909029334803`*^9}, {3.959658777985647*^9, 
  3.9596587885134907`*^9}},ExpressionUUID->"18533039-5cfb-cc4d-9dd0-\
a804366c9643"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\:0257\>\"", "]"}], ":=", 
   "\"\<\\\\text{\\\\texthtd}\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\:0188\>\"", "]"}], ":=", 
   "\"\<\\\\text{\\\\texthtc}\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\:01ad\>\"", "]"}], ":=", 
   "\"\<\\\\text{\\\\texthtt}\>\""}], ";"}]}], "Code",ExpressionUUID->\
"fadc5880-6e73-b44c-8446-f16a6de022dd"],

Cell["Other special strings", "Text",
 CellChangeTimes->{{3.583145079403295*^9, 3.583145103739338*^9}, {
  3.646374839245349*^9, 
  3.6463748445453577`*^9}},ExpressionUUID->"ee027e4e-71fe-4b63-bcf3-\
3d3b28b11d33"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "\"\<\[EmptyDownTriangle]\>\"", "]"}], ":=", 
   "\"\<\\\\nabla\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[173]:=",ExpressionUUID->"3920d4df-70f3-4a43-aa4b-83a68984fe33"],

Cell["Adding overline, underline, bar, tilde or hat:", "Text",
 CellChangeTimes->{{3.583145079403295*^9, 3.583145103739338*^9}, {
  3.646374839245349*^9, 3.6463748445453577`*^9}, {3.646375012546592*^9, 
  3.646375052626648*^9}, {3.6463800857176948`*^9, 
  3.646380102177717*^9}},ExpressionUUID->"e5c39014-20a8-45eb-9339-\
9cf37c5a65e3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"TexOverline", "[", "str_", "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<\\\\overline{\>\"", ",", "str", ",", "\"\<}\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TexUnderline", "[", "str_", "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<\\\\underline{\>\"", ",", "str", ",", "\"\<}\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TexBar", "[", "str_", "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<\\\\bar{\>\"", ",", "str", ",", "\"\<}\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TexTilde", "[", "str_", "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<\\\\tilde{\>\"", ",", "str", ",", "\"\<}\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TexHat", "[", "str_", "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<\\\\hat{\>\"", ",", "str", ",", "\"\<}\>\""}], 
   "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6463750640566635`*^9, 3.646375103506719*^9}, 
   3.646380077717684*^9},
 CellLabel->
  "In[174]:=",ExpressionUUID->"37281370-f6d0-4919-923b-e2074d3ecf73"],

Cell["\<\
New method in version 0.4.1. Strings containing \[OpenCurlyDoubleQuote]\\!\
\[CloseCurlyDoubleQuote] will be converted into boxes.\
\>", "Text",
 CellChangeTimes->{{3.728479150096363*^9, 
  3.728479223331083*^9}},ExpressionUUID->"bc8dcf51-1713-4e2d-a5cc-\
a92b59193b5c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StringToBox", "[", "str_", "]"}], ":=", 
   RowBox[{"RemoveQuote", "/@", 
    RowBox[{"(", 
     RowBox[{"First", "@", 
      RowBox[{"First", "@", 
       RowBox[{"FrontEndExecute", "[", 
        RowBox[{"FrontEnd`UndocumentedTestFEParserPacket", "[", 
         RowBox[{"str", ",", "False"}], "]"}], "]"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveQuote", "[", "str_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"And", "[", 
      RowBox[{
       RowBox[{"StringQ", "[", "str", "]"}], ",", 
       RowBox[{"StringMatchQ", "[", 
        RowBox[{"str", ",", 
         RowBox[{"(", 
          RowBox[{"\"\<\\\"\>\"", "~~", "___", "~~", "\"\<\\\"\>\""}], 
          ")"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"ToExpression", "[", 
      RowBox[{"str", ",", "StandardForm"}], "]"}], ",", "str"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.728483466812915*^9, 3.7284834675132627`*^9}, {
  3.72854370661716*^9, 3.728543759581272*^9}, {3.728544389635314*^9, 
  3.728544404933135*^9}, {3.7285446101858006`*^9, 3.728544637084699*^9}, {
  3.728545253108709*^9, 3.728545277133285*^9}, {3.728546748544945*^9, 
  3.728546763509491*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"95f06ef9-1d12-4d95-afca-ccc80b94ecea"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"str_String", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"StringContainsQ", "[", 
        RowBox[{"#", ",", "\"\<\\!\>\""}], "]"}], "&"}], ")"}]}], "]"}], ":=", 
   RowBox[{"Tex", "@", 
    RowBox[{"StringToBox", "[", "str", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"str_String", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"StringLength", "[", "#", "]"}], ">", "1"}], "&"}], ")"}]}], 
    "]"}], ":=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"(", 
     RowBox[{"Tex", "/@", 
      RowBox[{"Characters", "[", "str", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"str_String", "?", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"StringLength", "[", "#", "]"}], "==", "1"}], "&"}], ")"}]}], 
    "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"StringLength", "@", 
        RowBox[{"ToString", "[", 
         RowBox[{"FullForm", "@", "str"}], "]"}]}], ">", "3"}], ")"}], ",", 
     RowBox[{
      RowBox[{"ToString", "[", 
       RowBox[{"str", ",", "TeXForm"}], "]"}], "<>", "\"\< \>\""}], ",", 
     "str"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "str_String", "]"}], ":=", "str"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7284794099067526`*^9, 3.728479613505339*^9}, {
   3.7284796862087307`*^9, 3.728479729544526*^9}, {3.72847987244344*^9, 
   3.728479888373989*^9}, {3.728480508220316*^9, 3.728480516757509*^9}, 
   3.728480585919126*^9, {3.728543381883875*^9, 3.728543385722888*^9}},
 CellLabel->
  "In[181]:=",ExpressionUUID->"be90a0a1-80f5-4a9b-a2b4-c6f10cf83de9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"RowBox", "[", "l_List", "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"(", 
     RowBox[{"Tex", "/@", "l"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{"a_", ",", "\"\<^\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"TexHat", "[", 
    RowBox[{"Tex", "@", "a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{"a_", ",", "\"\<~\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"TexTilde", "[", 
    RowBox[{"Tex", "@", "a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{
      RowBox[{"a_String", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"StringLength", "[", "#", "]"}], "==", "1"}], "&"}], 
        ")"}]}], ",", "\"\<_\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"TexBar", "[", 
    RowBox[{"Tex", "@", "a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{"a_", ",", "\"\<_\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"TexOverline", "[", 
    RowBox[{"Tex", "@", "a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{"a_", ",", "\"\<.\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\dot{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{"a_", ",", "\"\<\[DoubleDot]\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\ddot{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{"a_", ",", "\"\<\[Hacek]\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\check{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{"a_", ",", "\"\<o\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\mathring{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{"a_", ",", 
      RowBox[{"OverscriptBox", "[", 
       RowBox[{"\"\<\[OverBrace]\>\"", ",", "b_"}], "]"}]}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\overbrace{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}^{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"UnderscriptBox", "[", 
     RowBox[{"a_", ",", "\"\<_\>\""}], "]"}], "]"}], ":=", 
   RowBox[{"TexUnderline", "[", 
    RowBox[{"Tex", "@", "a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"SubscriptBox", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"Tex", "@", "a"}], ",", "\"\<_{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}{}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverscriptBox", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\overset{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"UnderscriptBox", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\underset{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"UnderoverscriptBox", "[", 
     RowBox[{"\"\<\[Sum]\>\"", ",", "a_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\sum_{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}^{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"UnderoverscriptBox", "[", 
     RowBox[{"\"\<\[Product]\>\"", ",", "a_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\prod_{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}^{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"UnderoverscriptBox", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\underset{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}{\\\\overset{\>\"", ",", 
     RowBox[{"Tex", "@", "c"}], ",", "\"\<}{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"Tex", "@", "a"}], ",", "\"\<^{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}{}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"SubsuperscriptBox", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"Tex", "@", "a"}], ",", "\"\<_{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}^{\>\"", ",", 
     RowBox[{"Tex", "@", "c"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"FractionBox", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\frac{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}{\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"SqrtBox", "[", "a_", "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\sqrt{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"RadicalBox", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\sqrt[\>\"", ",", 
     RowBox[{"Tex", "@", "b"}], ",", "\"\<]{\>\"", ",", 
     RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"GridBox", "[", 
     RowBox[{"M_List", ",", "b___"}], "]"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"rows", "=", 
        RowBox[{"Length", "[", "M", "]"}]}], ",", 
       RowBox[{"cols", "=", 
        RowBox[{"Length", "@", 
         RowBox[{"First", "@", "M"}]}]}]}], "}"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<\\\\begin{array}{\>\"", ",", 
       RowBox[{"StringJoin", "@@", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"\"\<c\>\"", ",", 
          RowBox[{"{", "cols", "}"}]}], "]"}]}], ",", "\"\<}\\n\>\"", ",", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"Riffle", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{"Riffle", "[", 
              RowBox[{
               RowBox[{"Tex", "/@", "#"}], ",", "\"\< & \>\""}], "]"}], "]"}],
             "&"}], "/@", "M"}], ",", "\"\<\\\\\\\\\\n\>\""}], "]"}], "]"}], 
       ",", "\"\<\\n\\\\end{array}\>\""}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"FrameBox", "[", "a_", "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\fbox{\>\"", ",", 
     RowBox[{"Tex", "[", "a", "]"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"TagBox", "[", 
     RowBox[{"a_", ",", "b___"}], "]"}], "]"}], ":=", 
   RowBox[{"Tex", "[", "a", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"StyleBox", "[", "a__", "]"}], "]"}], ":=", 
   RowBox[{"TexStyleBox", "[", "a", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexStyleBox", "[", 
    RowBox[{"a_", ",", "___"}], "]"}], ":=", 
   RowBox[{"Tex", "@", "a"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"InterpretationBox", "[", 
     RowBox[{"a_", ",", "__"}], "]"}], "]"}], ":=", 
   RowBox[{"Tex", "[", "a", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->CompressedData["
1:eJwdzFsogwEABeBlGs0i95a0eHGJFYZspf7Ew3IJe5C21daIEoWwZsl+1/bi
8jChUYYhXiwPSBH2wMqEzMoWzZZt4kWaufznfzh9nU6dDGVXQ0sEg8HgUYGc
JL1DZ/UTrVcVLhgdueeDC/6xV1gURX7A4smnL0jaeupJSmNOrgR+CexNcGTw
TQqPPFoV7F4190GOYUsDvQXnWnq3TwzDgdvOUagVGmz0X+P9LbwsNESaKOXH
XBZsyxoIbVBeL8uYm+ifYyJoSXFXwYbmcA1smaqug5wSjxQuajpkMHbHoIAx
T942OC9Z6ofZ0hU1/GXIh+DLlXkUKlniGTheeTcL+fk2KzQeci9g+h7TDlXt
7Bs4whJ+w0P5yh88cZUkbFGKn3cTIZudyYO9ZaW05riQDv5YpvXQJyKnYTjP
S9vte9iv1QSI8NDjAZRtO8/gu+LUCpNrVXNGd4AwqTto5SLibY1SNJEaguVM
S9I6JT/NwYUCh0cXHA8S9854Ev4DeJQcOQ==
  "],ExpressionUUID->"fb1ca26a-671c-4a24-ac84-32c26089defc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"Subscript", "[", "expr___", "]"}], "]"}], ":=", 
   RowBox[{"Tex", "[", 
    RowBox[{"SubscriptBox", "[", "expr", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"Superscript", "[", "expr___", "]"}], "]"}], ":=", 
   RowBox[{"Tex", "[", 
    RowBox[{"SuperscriptBox", "[", "expr", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"Subsuperscript", "[", "expr___", "]"}], "]"}], ":=", 
   RowBox[{"Tex", "[", 
    RowBox[{"SubsuperscriptBox", "[", "expr", "]"}], "]"}]}], ";"}]}], "Input",\

 InitializationCell->True,
 CellLabel->
  "In[212]:=",ExpressionUUID->"5dffb62e-b79e-44a0-b3a5-cf71f960c45d"],

Cell["\<\
Overlaying a / or - can be handled with the slashed package. Make sure to add \
it to $TexInitLatexPackages before using.\
\>", "Text",
 CellChangeTimes->{{3.583145079403295*^9, 3.583145103739338*^9}, {
  3.646374839245349*^9, 3.6463748445453577`*^9}, {3.646375012546592*^9, 
  3.646375052626648*^9}, {3.6463800857176948`*^9, 3.646380102177717*^9}, {
  3.959657822250017*^9, 3.9596578895382442`*^9}, {3.9596579300619354`*^9, 
  3.95965795136994*^9}},ExpressionUUID->"63001d3c-e2d2-d344-86a7-\
2ca68aba38d8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverlayBox", "[", 
     RowBox[{"{", 
      RowBox[{"str_", ",", "\"\</\>\""}], "}"}], "]"}], "]"}], ":=", 
   RowBox[{"\"\<\\\\slashed{\>\"", "<>", 
    RowBox[{"Tex", "[", "str", "]"}], "<>", "\"\<}\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"OverlayBox", "[", 
     RowBox[{"{", 
      RowBox[{"str_", ",", "\"\<-\>\""}], "}"}], "]"}], "]"}], ":=", 
   RowBox[{"\"\<\\\\slashed{\>\"", "<>", 
    RowBox[{"Tex", "[", "str", "]"}], "<>", "\"\<}\>\""}]}], ";"}]}], "Input",\

 InitializationCell->
  True,ExpressionUUID->"2627ffa4-0ba5-4342-aa65-e0f7e2d68a5f"],

Cell["Older deactivated code :", "Text",
 CellChangeTimes->{{3.7284792318663273`*^9, 3.728479237030618*^9}, {
  3.728479288993756*^9, 
  3.728479299254712*^9}},ExpressionUUID->"cb1934dd-ec1b-4b40-a6fb-\
6e4468814c9d"],

Cell[TextData[{
 "With strings we call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s TeXForm, removing the frequent and annoying \\text{*} :"
}], "Text",ExpressionUUID->"712f79ee-8910-4512-9718-00cbdcdeb0a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Strings", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Removetext", "[", "string_String", "]"}], ":=", 
     RowBox[{
      RowBox[{"StringDrop", "[", 
       RowBox[{
        RowBox[{"StringDrop", "[", 
         RowBox[{"string", ",", "6"}], "]"}], ",", 
        RowBox[{"-", "1"}]}], "]"}], "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"string", ",", "\"\<\\\\text{*}\>\""}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Removetext", "[", "string_String", "]"}], ":=", "string"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "TeXForm", " ", "does", " ", "not", " ", "work", " ", "on", " ", 
     "StyleBoxes", " ", "so", " ", "we", " ", "remove", " ", "them", " ", 
     RowBox[{"first", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RemoveStyleBoxes", "[", "string_String", "]"}], ":=", 
    RowBox[{"StringReplace", "[", 
     RowBox[{"string", ",", 
      RowBox[{
       RowBox[{"StringExpression", "[", 
        RowBox[{
        "\"\<\\!\\(\\*StyleBox[\\\"\>\"", ",", "x___", ",", "\"\<\\\"\>\"", 
         ",", "y___", ",", "\"\<]\\)\>\""}], "]"}], "\[RuleDelayed]", "x"}]}],
      "]"}]}]}]}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.58313714685971*^9, 3.5831371700569515`*^9}, {
  3.5831373257764254`*^9, 3.583137358926484*^9}, {3.583138164839498*^9, 
  3.583138167007902*^9}, {3.64638014677778*^9, 3.646380167777809*^9}, {
  3.64638032541803*^9, 3.6463803263280315`*^9}, {3.646380370178093*^9, 
  3.646380370908094*^9}},ExpressionUUID->"1ce20ad8-c3e2-4225-9eb4-\
f11b9a7616dd"],

Cell["Older code for strings:", "Text",
 CellChangeTimes->{{3.646380335548044*^9, 3.646380367008088*^9}, {
  3.646380463618223*^9, 
  3.646380464078224*^9}},ExpressionUUID->"ddbd035a-0318-47a9-a668-\
1fe83b49a02a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "string_String", "]"}], ":=", 
   RowBox[{"Removetext", "@", 
    RowBox[{"ToString", "@", 
     RowBox[{"TeXForm", "@", 
      RowBox[{"RemoveStyleBoxes", "@", "string"}]}]}]}]}], ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"1ff53f55-7f9d-415f-9e91-e2892c322671"],

Cell["\<\
Newer code for strings. This can now handle nested hats and overlines etc. We \
do this by splitting and calling TexOrnament on every piece. TexOrnament \
turns special codes into held expressions which are then then interpreted by \
Tex. For other constructions TexOrnament calls TeXForm. See also section 8.1.\
\
\>", "Text",
 CellChangeTimes->{{3.646380335548044*^9, 3.646380367008088*^9}, {
  3.6463804671782284`*^9, 3.6463804974782705`*^9}, {3.646380531918319*^9, 
  3.6463805414983335`*^9}, {3.6463806014084177`*^9, 3.646380616308438*^9}, {
  3.6463808210487237`*^9, 3.646380879158805*^9}, {3.646380921258864*^9, 
  3.646381010008989*^9}, {3.64638155380075*^9, 3.646381560330759*^9}, {
  3.697820090806228*^9, 
  3.697820221074412*^9}},ExpressionUUID->"e77d8003-fef3-45c3-b432-\
5314961a6afe"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "str_String", "]"}], ":=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"(", 
     RowBox[{"TexOrnament", "/@", 
      RowBox[{"StringSplit", "[", 
       RowBox[{"str", ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"a", ":", 
            RowBox[{"StringExpression", "[", 
             RowBox[{"\"\<\\!\\(\>\"", ",", "x___", ",", "\"\<\\)\>\""}], 
             "]"}]}], "/;", 
           RowBox[{"StringFreeQ", "[", 
            RowBox[{
             RowBox[{"StringJoin", "[", 
              RowBox[{"{", "x", "}"}], "]"}], ",", "\"\<\\!\>\""}], "]"}]}], 
          "\[RuleDelayed]", "a"}], ")"}]}], "]"}]}], ")"}]}]}], 
  ";"}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.646380383638111*^9, 3.646380408118146*^9}, 
   3.647256285313308*^9, 3.697736922880531*^9, {3.697737103401785*^9, 
   3.697737103911786*^9}},ExpressionUUID->"a80991d2-e070-4404-be14-\
004873b8d95b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Subscript", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"Tex", "@", "a"}], ",", "\"\<_{\>\"", ",", 
    RowBox[{"Tex", "@", "b"}], ",", "\"\<}{}\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Overscript", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<\\\\overset{\>\"", ",", 
    RowBox[{"Tex", "@", "b"}], ",", "\"\<}{\>\"", ",", 
    RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Underscript", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<\\\\underset{\>\"", ",", 
    RowBox[{"Tex", "@", "b"}], ",", "\"\<}{\>\"", ",", 
    RowBox[{"Tex", "@", "a"}], ",", "\"\<}\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Superscript", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"Tex", "@", "a"}], ",", "\"\<^{\>\"", ",", 
    RowBox[{"Tex", "@", "b"}], ",", "\"\<}{}\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"OverBar", "[", "a_", "]"}], "]"}], ":=", 
  RowBox[{"TexOverline", "[", 
   RowBox[{"Tex", "@", "a"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"OverTilde", "[", "a_", "]"}], "]"}], ":=", 
  RowBox[{"TexTilde", "[", 
   RowBox[{"Tex", "@", "a"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"OverHat", "[", "a_", "]"}], "]"}], ":=", 
  RowBox[{"TexHat", "[", 
   RowBox[{"Tex", "@", "a"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"HoldForm", "[", "x_String", "]"}], "]"}], ":=", 
   RowBox[{"Tex", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"HoldForm", "[", 
     RowBox[{
     "x_Subscript", "|", "x_Overscript", "|", "x_Underscript", "|", 
      "x_Superscript", "|", "x_OverBar", "|", "x_OverTilde", "|", 
      "x_OverHat"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{"HoldForm", ",", 
      RowBox[{"Hold", "@", "x"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], "/.", 
    RowBox[{"Hold", "\[Rule]", "Tex"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"x", ":", 
     RowBox[{"HoldForm", "[", "___", "]"}]}], "]"}], ":=", 
   RowBox[{"xAct`TexAct`Private`Removetext", "@", 
    RowBox[{"ToString", "@", 
     RowBox[{"TeXForm", "@", "x"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexStyleBox", "[", 
    RowBox[{"a_", ",", "___"}], "]"}], ":=", 
   RowBox[{"Tex", "@", "a"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexOrnamentExpr", "[", "expr___", "]"}], ":=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"(", 
     RowBox[{"Tex", "/@", 
      RowBox[{"{", "expr", "}"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TexOrnament", "[", "str_String", "]"}], ":=", 
   RowBox[{
    RowBox[{"TexStyleBox", "@@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ToExpression", "[", 
         RowBox[{"#", ",", "StandardForm", ",", "HoldForm"}], "]"}], "&"}], "/@", 
       RowBox[{"StringSplit", "[", 
        RowBox[{
         RowBox[{"StringDrop", "[", 
          RowBox[{
           RowBox[{"StringDrop", "[", 
            RowBox[{"str", ",", "12"}], "]"}], ",", 
           RowBox[{"-", "2"}]}], "]"}], ",", "\"\<,\>\"", ",", "2"}], "]"}]}],
       ")"}]}], "/;", 
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"str", ",", 
      RowBox[{"StringExpression", "[", 
       RowBox[{
       "\"\<\\!\\(\\*StyleBox[\>\"", ",", "x___", ",", "\"\<]\\)\>\""}], 
       "]"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexOrnament", "[", "str_String", "]"}], ":=", 
   RowBox[{
    RowBox[{"TexOrnamentExpr", "@", 
     RowBox[{"ToExpression", "[", 
      RowBox[{"str", ",", "StandardForm", ",", "HoldForm"}], "]"}]}], "/;", 
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"str", ",", 
      RowBox[{"StringExpression", "[", 
       RowBox[{"\"\<\\!\\(\>\"", ",", "x___", ",", "\"\<\\)\>\""}], "]"}]}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexOrnament", "[", "str_String", "]"}], ":=", 
   RowBox[{"Removetext", "@", 
    RowBox[{"ToString", "@", 
     RowBox[{"TeXForm", "@", "str"}]}]}]}], ";"}]}], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.646380443538195*^9, 3.646380449078203*^9}, 
   3.6463809465688996`*^9, 3.697733563451986*^9, {3.697733663193126*^9, 
   3.6977336678041334`*^9}, {3.697733714325198*^9, 3.6977337279892187`*^9}, {
   3.697734736900443*^9, 3.697734795223526*^9}, {3.697734906866683*^9, 
   3.6977349131286917`*^9}, {3.6977353518773127`*^9, 
   3.6977353961573753`*^9}, {3.6977385861693373`*^9, 
   3.6977385864493375`*^9}, {3.6977386302283983`*^9, 
   3.6977386516734285`*^9}, {3.6977387013034997`*^9, 
   3.6977387098755116`*^9}, {3.697738790272625*^9, 3.697738811427655*^9}, {
   3.697738850005709*^9, 3.697738919629806*^9}, {3.697742867884384*^9, 
   3.69774292209446*^9}, {3.6977431804178305`*^9, 3.697743205512866*^9}, {
   3.697743305915008*^9, 3.697743311226015*^9}, {3.697743476019248*^9, 
   3.6977434765292487`*^9}, {3.697743611269439*^9, 3.6977436117594395`*^9}, {
   3.6978191618869147`*^9, 3.697819199433967*^9}, {3.697819928489999*^9, 
   3.697819953956035*^9}, {3.6978199871540813`*^9, 3.697819987424082*^9}, {
   3.697820331756568*^9, 3.6978203321565685`*^9}, 3.6978205885329313`*^9, {
   3.69782126064588*^9, 3.697821312067952*^9}, {3.697821346075*^9, 
   3.697821348895005*^9}, {3.697821736459551*^9, 
   3.697821736959552*^9}},ExpressionUUID->"035ba010-f12a-4a43-a39d-\
f18f53a76841"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4. Functions", "Subsection",ExpressionUUID->"3973b9e0-9e95-4479-aa8b-59ddf59fdc2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Functions", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Sin", "]"}], ":=", "\"\<\\\\sin\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Cos", "]"}], ":=", "\"\<\\\\cos\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Sec", "]"}], ":=", "\"\<\\\\sec\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Csc", "]"}], ":=", "\"\<\\\\csc\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Cot", "]"}], ":=", "\"\<\\\\cot\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Tan", "]"}], ":=", "\"\<\\\\tan\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Log", "]"}], ":=", "\"\<\\\\log\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Sinh", "]"}], ":=", "\"\<\\\\sinh\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Cosh", "]"}], ":=", "\"\<\\\\cosh\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Tanh", "]"}], ":=", "\"\<\\\\tanh\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "ArcSin", "]"}], ":=", "\"\<\\\\arcsin\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "ArcCos", "]"}], ":=", "\"\<\\\\arccos\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "ArcTan", "]"}], ":=", "\"\<\\\\arctan\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "ArcSinh", "]"}], ":=", "\"\<\\\\arcsinh\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "ArcCosh", "]"}], ":=", "\"\<\\\\arccosh\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "ArcTanh", "]"}], ":=", "\"\<\\\\arctanh\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6057869383231277`*^9, 3.60578694678314*^9}, {
  3.616396846940979*^9, 3.616396858730995*^9}, {3.616396899191052*^9, 
  3.6163969265510902`*^9}, {3.875861485005454*^9, 3.875861532601959*^9}},
 CellLabel->
  "In[215]:=",ExpressionUUID->"d249f157-8a0c-4e92-badf-9d2b35a24e1c"],

Cell["\<\
Special display for trig functions with a simple scalar field as argument.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.6190827784180603`*^9, 3.6190828130521564`*^9}, {
  3.619082885172258*^9, 3.619082902042281*^9}, {3.8758615929531507`*^9, 
  3.8758615941190577`*^9}},ExpressionUUID->"f170c925-019e-4261-b861-\
ccf141c13e68"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$TexTrigFuncs", "=", 
   RowBox[{"{", 
    RowBox[{
    "Sin", ",", "Cos", ",", "Tan", ",", "Cot", ",", "Sec", ",", "Csc", ",", 
     "Sinh", ",", "Cosh", ",", "Tanh"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"trig", ":", 
       RowBox[{"Alternatives", "@@", "$TexTrigFuncs"}]}], ")"}], "[", 
     RowBox[{
      RowBox[{"T_", "?", "xTensorQ"}], "[", "]"}], "]"}], "]"}], ":=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"Tex", "[", "trig", "]"}], ",", "\"\< \>\"", ",", 
       RowBox[{"Tex", "[", "T", "]"}]}], "]"}], ",", 
     RowBox[{"\"\< \\\\\>\"", "\[Rule]", "\"\<\\\\\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"Power", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"trig", ":", 
         RowBox[{"Alternatives", "@@", "$TexTrigFuncs"}]}], ")"}], "[", 
       RowBox[{
        RowBox[{"T_", "?", "xTensorQ"}], "[", "]"}], "]"}], ",", 
      "i_Integer"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"Tex", "[", "trig", "]"}], ",", "\"\<^\>\"", ",", 
      RowBox[{"Tex", "[", "i", "]"}], ",", 
      RowBox[{"Tex", "[", "T", "]"}]}], "]"}], "/;", 
    RowBox[{"And", "[", 
     RowBox[{
      RowBox[{"i", ">", "1"}], ",", 
      RowBox[{"i", "<", "10"}]}], "]"}]}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.619082734807999*^9, 3.6190827370680027`*^9}, {
  3.619082840072195*^9, 3.619082852032212*^9}, {3.619083177226715*^9, 
  3.619083356506966*^9}, {3.619083389908013*^9, 3.6190834138420944`*^9}, {
  3.619084145531215*^9, 3.619084154571228*^9}, {3.619084253091366*^9, 
  3.619084258991374*^9}, {3.619084366625573*^9, 3.619084367135574*^9}, {
  3.6190844220256505`*^9, 3.619084439515675*^9}},
 CellLabel->
  "In[231]:=",ExpressionUUID->"7904d897-0b18-44e9-a72a-40c54c31187e"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.5. Symbols", "Subsection",ExpressionUUID->"9c1d7be7-c3bf-46e3-bf3d-a32b43d500b7"],

Cell["Symbol formatting on the result of PrintAs:", "Text",ExpressionUUID->"761dcef7-0a70-455f-980d-fc39468cbb6a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Symbols", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"including", " ", "constant"}], "-", 
      RowBox[{"symbols", " ", "and", " ", "parameters"}]}], ")"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Tex", "[", "symbol_Symbol", "]"}], ":=", 
    RowBox[{"Tex", "@", 
     RowBox[{"PrintAs", "[", "symbol", "]"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.583136000553097*^9, 3.5831360129083195`*^9}, 
   3.6463746344950624`*^9, 3.646374706715164*^9},
 CellLabel->
  "In[234]:=",ExpressionUUID->"f3368a15-310a-4444-976c-a49524be9895"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.6. Indices", "Subsection",ExpressionUUID->"3bff6572-8474-47a4-b96d-89d32186e9c1"],

Cell["\<\
Add an extra space at the end of the string if we find a backslash. This is \
to avoid things like \[OpenCurlyDoubleQuote]\\alphab\[CloseCurlyDoubleQuote] \
instead of \[OpenCurlyDoubleQuote]\\alpha b\[CloseCurlyDoubleQuote] in the \
list of indices.\
\>", "Text",
 CellChangeTimes->{{3.5643839961071606`*^9, 
  3.5643840968521385`*^9}},ExpressionUUID->"a50bd4a9-5f2c-4b33-bc1b-\
c54097ca9d3f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExtraSpaceIfBackslash", "[", "str_String", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"StringFreeQ", "[", 
      RowBox[{"str", ",", "\"\<\\\\\>\""}], "]"}], ",", "str", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"str", ",", "\"\< \>\""}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[235]:=",ExpressionUUID->"84c63f21-15b6-4b70-bb16-c87432bac1f9"],

Cell["\<\
Those indices which are not recognized by neither UpIndexQ or DownIndexQ (for \
example patterns) are treated as symbols from the IndexForm:\
\>", "Text",
 CellChangeTimes->{{3.583137432465012*^9, 
  3.58313744851744*^9}},ExpressionUUID->"28956fc1-a9ea-4504-8e8c-\
848ba651b96e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexIndexForm", "[", "index_", "]"}], ":=", 
  RowBox[{"Tex", "[", 
   RowBox[{"IndexForm", "[", "index", "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.583137441294627*^9},
 CellLabel->
  "In[236]:=",ExpressionUUID->"358830e1-96da-4f41-968a-2a11a00e7961"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"One", " ", "index"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TexUpIndex", "[", "index_", "]"}], ":=", 
    RowBox[{"ExtraSpaceIfBackslash", "@", 
     RowBox[{"TexIndexForm", "@", "index"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.564384118161775*^9, 3.564384119160177*^9}, {
  3.5687125825738554`*^9, 3.568712608376301*^9}},
 CellLabel->
  "In[237]:=",ExpressionUUID->"b6f45586-45ae-4f42-bb55-c59c29c1eefb"],

Cell["Jose\[CloseCurlyQuote]s old code. Now deactivated.", "Text",ExpressionUUID->"1e03b6a7-4c6c-467e-a04c-cca5519c8d5d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Lists", " ", "of", " ", "indices"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TexIndex", "[", "list_IndexList", "]"}], ":=", 
     RowBox[{"Apply", "[", 
      RowBox[{"StringJoin", ",", 
       RowBox[{"TexIndex", "/@", "list"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TexIndex", "[", 
      RowBox[{"list_IndexList", ",", "der_String"}], "]"}], ":=", 
     "\"\<TODO\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexIndex", "[", 
      RowBox[{"IndexList", "[", "]"}], "]"}], ":=", 
     RowBox[{"Sequence", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Individual", " ", "index"}], ",", " ", 
     RowBox[{
     "with", " ", "or", " ", "without", " ", "a", " ", "derivative"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexIndex", "[", 
      RowBox[{"index_", "?", "UpIndexQ"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<{}^{\>\"", ",", 
       RowBox[{"TexUpIndex", "[", "index", "]"}], ",", "\"\<}\>\""}], "]"}]}],
     ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TexIndex", "[", 
      RowBox[{"index_", "?", "DownIndexQ"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<{}_{\>\"", ",", 
       RowBox[{"TexUpIndex", "[", 
        RowBox[{"ChangeIndex", "[", "index", "]"}], "]"}], ",", "\"\<}\>\""}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexIndex", "[", 
      RowBox[{
       RowBox[{"index_", "?", "UpIndexQ"}], ",", "der_String"}], "]"}], ":=", 
     
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<{}^{\>\"", ",", 
       RowBox[{"Tex", "@", "der"}], ",", 
       RowBox[{"TexUpIndex", "[", "index", "]"}], ",", "\"\<}\>\""}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexIndex", "[", 
      RowBox[{
       RowBox[{"index_", "?", "DownIndexQ"}], ",", "der_String"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<{}_{\>\"", ",", 
       RowBox[{"Tex", "@", "der"}], ",", 
       RowBox[{"TexUpIndex", "[", 
        RowBox[{"ChangeIndex", "[", "index", "]"}], "]"}], ",", "\"\<}\>\""}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexIndex", "[", "index_", "]"}], ":=", 
     RowBox[{"ToString", "[", "index", "]"}]}], ";"}]}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"ac005b47-5e56-489f-8b7e-575073df3674"],

Cell["Thomas\[CloseCurlyQuote] newer code. Highly recursive:", "Text",ExpressionUUID->"cda374a8-213f-4b2e-9579-54e82fb27947"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$TexPrintInitialBracesQ", "=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"initbraces", "[", "]"}], ":=", 
    RowBox[{"If", "[", 
     RowBox[{"$TexPrintInitialBracesQ", ",", "\"\<{}\>\"", ",", "\"\<\>\""}], 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", "Main", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexIndices", "[", "]"}], ":=", 
   RowBox[{"Sequence", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexIndices", "[", 
    RowBox[{
     RowBox[{"first_", "?", "UpIndexQ"}], ",", "more___"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"initbraces", "[", "]"}], ",", "\"\<^{\>\"", ",", 
     RowBox[{"TexUpIndex", "[", "first", "]"}], ",", 
     RowBox[{"TexIndicesFromUp", "[", "more", "]"}], ",", "\"\<}\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TexIndices", "[", 
     RowBox[{
      RowBox[{"first_", "?", "DownIndexQ"}], ",", "more___"}], "]"}], ":=", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"initbraces", "[", "]"}], ",", "\"\<_{\>\"", ",", 
      RowBox[{"TexUpIndex", "[", 
       RowBox[{"ChangeIndex", "@", "first"}], "]"}], ",", 
      RowBox[{"TexIndicesFromDown", "[", "more", "]"}], ",", "\"\<}\>\""}], 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Previous", " ", "index", " ", "was", " ", "up"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexIndicesFromUp", "[", "]"}], ":=", 
   RowBox[{"Sequence", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexIndicesFromUp", "[", 
    RowBox[{
     RowBox[{"first_", "?", "UpIndexQ"}], ",", "more___"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"TexUpIndex", "[", "first", "]"}], ",", 
     RowBox[{"TexIndicesFromUp", "[", "more", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TexIndicesFromUp", "[", 
     RowBox[{
      RowBox[{"first_", "?", "DownIndexQ"}], ",", "more___"}], "]"}], ":=", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<}{}_{\>\"", ",", 
      RowBox[{"TexUpIndex", "[", 
       RowBox[{"ChangeIndex", "@", "first"}], "]"}], ",", 
      RowBox[{"TexIndicesFromDown", "[", "more", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Previous", " ", "index", " ", "was", " ", "down"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexIndicesFromDown", "[", "]"}], ":=", 
   RowBox[{"Sequence", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexIndicesFromDown", "[", 
    RowBox[{
     RowBox[{"first_", "?", "DownIndexQ"}], ",", "more___"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"TexUpIndex", "[", 
      RowBox[{"ChangeIndex", "@", "first"}], "]"}], ",", 
     RowBox[{"TexIndicesFromDown", "[", "more", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TexIndicesFromDown", "[", 
     RowBox[{
      RowBox[{"first_", "?", "UpIndexQ"}], ",", "more___"}], "]"}], ":=", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<}{}^{\>\"", ",", 
      RowBox[{"TexUpIndex", "[", "first", "]"}], ",", 
      RowBox[{"TexIndicesFromUp", "[", "more", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "With", " ", "derivative", " ", "indices", " ", "in", " ", "postfix", " ", 
    "notation"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TexCovDIndices", "[", "post_", "]"}], "[", 
    RowBox[{
     RowBox[{"first_", "?", "UpIndexQ"}], ",", "more___"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<{}^{\>\"", ",", "post", ",", 
     RowBox[{"TexUpIndex", "[", "first", "]"}], ",", 
     RowBox[{"TexIndicesFromUp", "[", "more", "]"}], ",", "\"\<}\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TexCovDIndices", "[", "post_", "]"}], "[", 
    RowBox[{
     RowBox[{"first_", "?", "DownIndexQ"}], ",", "more___"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<{}_{\>\"", ",", "post", ",", 
     RowBox[{"TexUpIndex", "[", 
      RowBox[{"ChangeIndex", "@", "first"}], "]"}], ",", 
     RowBox[{"TexIndicesFromDown", "[", "more", "]"}], ",", "\"\<}\>\""}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[238]:=",ExpressionUUID->"04014627-75dd-4ec4-a518-e79327f5b716"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.7. Operators", "Subsection",ExpressionUUID->"fdc34e0e-f9ac-412e-a125-6079b5b3dbda"],

Cell[TextData[{
 "Note that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expands -(a+b) into -a-b, but not -2(a+b). We also include the former \
case, because we could be formatting a held expression, for instance. \nWe \
also introduce OrderedPlus which is supposed to do mean the same as Plus, but \
it will not reorder the elements, but it will remove zeros.\nToOrderedPlus \
can be used to transform Plus to OrderedPlus sorted with respect to \
ToOrderedPlusSortFunc."
}], "Text",
 CellChangeTimes->{{3.616503934745057*^9, 3.6165040014151506`*^9}, {
  3.6165040713952484`*^9, 3.616504080035261*^9}, {3.679984831916006*^9, 
  3.679984913585802*^9}},ExpressionUUID->"b6c92e07-86b4-4b8b-b025-\
aba50a20af36"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OrderedPlus", "[", 
    RowBox[{"0", ",", "terms__"}], "]"}], ":=", 
   RowBox[{"OrderedPlus", "[", "terms", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OrderedPlus", "[", 
    RowBox[{"terms1__", ",", "0", ",", "terms2___"}], "]"}], ":=", 
   RowBox[{"OrderedPlus", "[", 
    RowBox[{"terms1", ",", "terms2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OrderedPlus", "[", "term_", "]"}], ":=", "term"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MakeBoxes", "[", 
   RowBox[{
    RowBox[{"OrderedPlus", "[", "expr___", "]"}], ",", "StandardForm"}], 
   "]"}], ":=", 
  RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
   RowBox[{
    RowBox[{"OrderedPlus", "[", "expr", "]"}], ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{"xAct`xTensor`Private`MakeSequenceBox", "[", 
        RowBox[{
         RowBox[{"{", "expr", "}"}], ",", 
         RowBox[{"StyleBox", "[", 
          RowBox[{"\"\<+\>\"", ",", 
           RowBox[{"FontColor", "\[Rule]", "Blue"}]}], "]"}], ",", 
         "StandardForm"}], "]"}], "}"}], "]"}], "]"}]}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.61650400841516*^9, 3.6165041140753083`*^9}, {
  3.679982200745934*^9, 3.679982246876856*^9}},
 CellLabel->
  "In[251]:=",ExpressionUUID->"9df04169-d295-4134-ad05-f9f379038385"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ToOrderedPlusSortFunc", "[", "expr_", "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{"Plus", "@@", 
     RowBox[{"Exponent", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"Variables", "[", "expr", "]"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToOrderedPlus", "=", 
   RowBox[{"expr_Plus", "\[RuleDelayed]", 
    RowBox[{"SortBy", "[", 
     RowBox[{
      RowBox[{"OrderedPlus", "@@", "expr"}], ",", "ToOrderedPlusSortFunc"}], 
     "]"}]}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.679982808731947*^9, 3.679982821763468*^9}, {
   3.6799846370663676`*^9, 3.679984649876496*^9}, 3.680499270894944*^9},
 CellLabel->
  "In[255]:=",ExpressionUUID->"6e483e84-69b2-41e7-9c26-00f7fe80a549"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Unary", " ", "minus"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TexOperator", "[", "Minus", "]"}], "=", "\"\<- \>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "expr_Plus"}], "|", 
        RowBox[{"-", "expr_OrderedPlus"}]}], ")"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOperator", "[", "Minus", "]"}], ",", 
       RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
       RowBox[{"Tex", "[", "expr", "]"}], ",", 
       RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"-", "expr_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"TexOperator", "[", "Minus", "]"}], "<>", 
      RowBox[{"Tex", "[", "expr", "]"}]}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.616504128025328*^9, 3.6165041433953495`*^9}, {
  3.616505013008712*^9, 3.616505027528732*^9}},
 CellLabel->
  "In[257]:=",ExpressionUUID->"b83ae2b4-a767-4e0c-b41d-c19c68309c39"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Product", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TexOperator", "[", "Times", "]"}], ":=", "\"\< \>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexFactor", "[", "1", "]"}], ":=", "\"\<\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexFactor", "[", 
      RowBox[{"-", "1"}], "]"}], ":=", 
     RowBox[{"TexOperator", "[", "Minus", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexFactor", "[", 
      RowBox[{"(", 
       RowBox[{"expr_Plus", "|", "expr_OrderedPlus"}], ")"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
       RowBox[{"Tex", "[", "expr", "]"}], ",", 
       RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexFactor", "[", "expr_", "]"}], ":=", 
     RowBox[{"Tex", "[", "expr", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexOrdinaryTimes", "[", "expr_Times", "]"}], ":=", 
     RowBox[{"StringJoin", "@@", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"TexFactor", "/@", 
         RowBox[{"List", "@@", "expr"}]}], ",", 
        RowBox[{"TexOperator", "[", "Times", "]"}]}], "]"}]}]}], ";"}], "\n", 
   
   RowBox[{
    RowBox[{
     RowBox[{"TexOrdinaryTimes", "[", "expr_", "]"}], ":=", 
     RowBox[{"Tex", "@", "expr"}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.559468004655994*^9, 3.559468010740005*^9}, 
   3.559468052407678*^9, {3.616504166665382*^9, 3.616504173855392*^9}, {
   3.6165050438187547`*^9, 3.6165050480887604`*^9}},
 CellLabel->
  "In[260]:=",ExpressionUUID->"d614bfcf-f099-4b1e-9f15-9c9c55ce8cc2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexFractionAsFraction", "=", "True"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[267]:=",ExpressionUUID->"55bab7b3-5847-4ff0-8036-3193d11482d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", "expr_Times", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"numer", "=", 
        RowBox[{"Numerator", "[", "expr", "]"}]}], ",", 
       RowBox[{"denom", "=", 
        RowBox[{"Denominator", "[", "expr", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"And", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"NumberQ", "[", "denom", "]"}]}], ",", 
         "$TexFractionAsFraction"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"TexFracExpression", "[", 
        RowBox[{"numer", ",", "denom", ",", "$TexFraction"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"TexOrdinaryTimes", "[", "expr", "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[268]:=",ExpressionUUID->"983c113a-a894-49d0-a5b9-dc113fbd4f40"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Sum", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TexOperator", "[", "Plus", "]"}], ":=", "\"\< + \>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"(", 
       RowBox[{"expr_Plus", "|", "expr_OrderedPlus"}], ")"}], "]"}], ":=", 
     RowBox[{"StringJoin", "@@", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"Tex", "/@", 
         RowBox[{"List", "@@", "expr"}]}], ",", 
        RowBox[{"TexOperator", "[", "Plus", "]"}]}], "]"}]}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.616504204669483*^9, 3.616504241979536*^9}, {
  3.616505060588778*^9, 3.6165050651887836`*^9}},
 CellLabel->
  "In[269]:=",ExpressionUUID->"758940b9-9bb9-49f9-904c-3fd1936ef121"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Square", " ", "root", " ", "of", " ", "a", " ", "number"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"num_", "?", "NumberQ"}], "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<\\\\sqrt{\>\"", ",", 
       RowBox[{"Tex", "[", "num", "]"}], ",", "\"\<}\>\""}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Power", "[", 
       RowBox[{
        RowBox[{"num_", "?", "NumberQ"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"$TexSmallFraction", ",", "\"\<{1}{\\\\sqrt{\>\"", ",", 
       RowBox[{"Tex", "[", "num", "]"}], ",", "\"\<}}\>\""}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[271]:=",ExpressionUUID->"3a9bda42-7901-4199-9527-1e92b308df08"],

Cell["\<\
Special code to include square roots of numbers in the fractions.\
\>", "Text",ExpressionUUID->"08843d05-9bd7-476d-aafa-0a59d29ed0e4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExtractNumericalFactor", "[", "expr_Times", "]"}], ":=", 
   RowBox[{"Times", "@@", 
    RowBox[{"(", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"List", "@@", "expr"}], ",", "NumberQ"}], "]"}], ")"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtractNumericalFactor", "[", 
    RowBox[{"num_", "?", "NumberQ"}], "]"}], ":=", "num"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExtractNumericalFactor", "[", "___", "]"}], ":=", "1"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[273]:=",ExpressionUUID->"9ae5b557-ef7a-4552-8071-466ae4fa0ddb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Other", " ", "square", " ", "roots"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Tex", "[", 
     RowBox[{"expr", ":", 
      RowBox[{"Times", "[", 
       RowBox[{
        RowBox[{"Power", "[", 
         RowBox[{
          RowBox[{"num_", "?", "NumberQ"}], ",", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}]}], "]"}], ",", "___"}], "]"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"numfactor", "=", 
         RowBox[{"ExtractNumericalFactor", "[", 
          RowBox[{"expr", " ", 
           RowBox[{"Sqrt", "[", "num", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"numer", "=", 
         RowBox[{"Numerator", "[", 
          RowBox[{"expr", " ", 
           RowBox[{"Sqrt", "[", "num", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"denom1", "=", 
         RowBox[{"Denominator", "[", 
          RowBox[{"expr", " ", 
           RowBox[{"Sqrt", "[", "num", "]"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Or", "[", 
         RowBox[{
          RowBox[{"!", "$TexFractionAsFraction"}], ",", 
          RowBox[{"NumberQ", "[", "denom1", "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"TexFracExpression", "[", 
           RowBox[{
            RowBox[{"Numerator", "[", "numfactor", "]"}], ",", 
            RowBox[{
             RowBox[{"Denominator", "[", "numfactor", "]"}], 
             RowBox[{"Sqrt", "[", "num", "]"}]}], ",", "$TexSmallFraction"}], 
           "]"}], ",", 
          RowBox[{"TexFactor", "[", 
           RowBox[{"expr", " ", 
            RowBox[{
             RowBox[{"Sqrt", "[", "num", "]"}], "/", "numfactor"}]}], "]"}]}],
          "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"TexFracExpression", "[", 
         RowBox[{"numer", ",", 
          RowBox[{"denom1", " ", 
           RowBox[{"Sqrt", "[", "num", "]"}]}], ",", "$TexFraction"}], 
         "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[276]:=",ExpressionUUID->"d67e162d-f7c0-457d-9595-9254dac16c97"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Power", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TexOperator", "[", "Power", "]"}], ":=", "\"\<^\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexBase", "[", 
      RowBox[{"x_", "?", "IntegerQ"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "<", "0"}], ",", 
       RowBox[{"StringJoin", "[", 
        RowBox[{
         RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
         RowBox[{"Tex", "[", "x", "]"}], ",", 
         RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}], ",", 
       RowBox[{"Tex", "[", "x", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexBase", "[", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"x", ":", 
         RowBox[{"(", 
          RowBox[{"_Symbol", "|", 
           RowBox[{
            RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}]}], ")"}]}], 
        ")"}]}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
       RowBox[{"Tex", "[", 
        RowBox[{"-", "x"}], "]"}], ",", 
       RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexBase", "[", 
      RowBox[{"x", ":", 
       RowBox[{"Scalar", "[", "expr_", "]"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Tex", "[", "x", "]"}], "/;", "$TexScalarParentheses"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexBase", "[", 
      RowBox[{"(", 
       RowBox[{"x", ":", 
        RowBox[{"(", 
         RowBox[{"_Symbol", "|", 
          RowBox[{
           RowBox[{"_", "?", "xTensorQ"}], "[", "]"}]}], ")"}]}], ")"}], 
      "]"}], ":=", 
     RowBox[{"Tex", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexBase", "[", 
      RowBox[{"(", 
       RowBox[{"x", ":", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"_", "?", "xTensorQ"}], "[", "__", "]"}], ")"}]}], ")"}], 
      "]"}], ":=", 
     RowBox[{
      RowBox[{"Tex", "[", "x", "]"}], "<>", "\"\<{}\>\""}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexBase", "[", "x_", "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
       RowBox[{"Tex", "[", "x", "]"}], ",", 
       RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexExponent", "[", "x_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"$TexSmallFraction", "=", "$TexSmallFractionExponent"}], 
        "}"}], ",", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"tex", "=", 
           RowBox[{"Tex", "[", "x", "]"}]}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"StringLength", "[", "tex", "]"}], "===", "1"}], ",", 
           "tex", ",", 
           RowBox[{"StringJoin", "[", 
            RowBox[{"\"\<{\>\"", ",", "tex", ",", "\"\<}\>\""}], "]"}]}], 
          "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Tex", "[", 
       RowBox[{"Power", "[", 
        RowBox[{"x_", ",", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\\\frac{1}{\>\"", ",", 
         RowBox[{"Tex", "[", "x", "]"}], ",", "\"\<}\>\""}], "]"}], "/;", 
       RowBox[{
        RowBox[{"ByteCount", "[", "x", "]"}], "<", "200"}]}]}], ";"}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Power", "[", 
       RowBox[{"x_", ",", 
        RowBox[{"-", "1"}]}], "]"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"TexFracExpression", "[", 
       RowBox[{"1", ",", "x", ",", "$TexFraction"}], "]"}], "/;", 
      "$TexFractionAsFraction"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Power", "[", 
       RowBox[{"x_", ",", "n_"}], "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexBase", "[", "x", "]"}], ",", 
       RowBox[{"TexOperator", "[", "Power", "]"}], ",", 
       RowBox[{"TexExponent", "[", "n", "]"}]}], "]"}]}], ";"}]}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.580631017766832*^9, 3.580631044115278*^9}, {
   3.5831348611260962`*^9, 3.583134950935453*^9}, {3.5831349858639154`*^9, 
   3.583134996565533*^9}, {3.6057870236332474`*^9, 3.605787033513261*^9}, {
   3.6057870673133087`*^9, 3.605787117333379*^9}, 3.778504249681817*^9, {
   3.778505728989904*^9, 3.778505753170194*^9}, {3.778505789212916*^9, 
   3.778505851241425*^9}, {3.778506082091964*^9, 3.778506102076167*^9}},
 CellLabel->
  "In[277]:=",ExpressionUUID->"1b079d80-166f-4246-97b6-8b8beb7a56c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Abs", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Power", "[", 
       RowBox[{
        RowBox[{"Abs", "[", "x_", "]"}], ",", "n_"}], "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOpen", "[", "\"\<|\>\"", "]"}], ",", 
       RowBox[{"Tex", "[", "x", "]"}], ",", 
       RowBox[{"TexClose", "[", "\"\<|\>\"", "]"}], ",", 
       RowBox[{"TexOperator", "[", "Power", "]"}], ",", 
       RowBox[{"TexExponent", "[", "n", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Abs", "[", "x_", "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOpen", "[", "\"\<|\>\"", "]"}], ",", 
       RowBox[{"Tex", "[", "x", "]"}], ",", 
       RowBox[{"TexClose", "[", "\"\<|\>\"", "]"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.605787141133412*^9, 3.605787145143418*^9}},
 CellLabel->
  "In[287]:=",ExpressionUUID->"5f693c2e-c053-42cb-af53-4b15394dafe8"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.8. Basis objects", "Subsection",
 CellChangeTimes->{
  3.583148454082223*^9},ExpressionUUID->"ccb50393-d7fb-428d-a398-\
10db3c74e6d5"],

Cell[BoxData[
 RowBox[{"(*", " ", "Basis", " ", "*)"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[289]:=",ExpressionUUID->"1e7ced2b-fce5-4896-87f4-08cf5e16e5ca"],

Cell["\<\
This has to come before the general tensor code because we might want to \
change the typesetting for a basis object.\
\>", "Text",
 CellChangeTimes->{{3.583148658941783*^9, 
  3.5831487177070856`*^9}},ExpressionUUID->"acd0da8d-4b7c-4b39-8f8e-\
6faf901c33fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Basis", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], "]"}], ":=", 
  RowBox[{"TexBasis", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5831484888078837`*^9, 3.583148492271089*^9}, {
  3.5831485666052203`*^9, 3.583148598756877*^9}},
 CellLabel->
  "In[290]:=",ExpressionUUID->"a7d97eab-9e04-45f0-bf7f-ae5821ad29c8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexBasis", "[", "inds__", "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"Tex", "[", "Basis", "]"}], ",", 
     RowBox[{"TexIndices", "[", "inds", "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.583148604232487*^9, 3.5831486370861444`*^9}, {
  3.583148744726333*^9, 3.5831487495311418`*^9}},
 CellLabel->
  "In[291]:=",ExpressionUUID->"087ad6f0-0a0d-4df4-a6b2-4c71241d439a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FormatTexBasis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_Integer", ",", 
       RowBox[{"basis_", "?", "BasisQ"}]}], "}"}], ",", "texstring_String"}], 
    "]"}], ":=", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"TexBasis", "[", 
      RowBox[{"ind_", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "basis"}], "}"}]}], "]"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"texstring", ",", 
       RowBox[{"TexIndices", "[", "ind", "]"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FormatTexBasis", "[", 
    RowBox[{"{", 
     RowBox[{"i_Integer", ",", 
      RowBox[{"basis_", "?", "BasisQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Unset", "[", 
    RowBox[{"TexBasis", "[", 
     RowBox[{"ind_", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "basis"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FormatTexBasis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_Integer", ",", 
       RowBox[{"-", 
        RowBox[{"basis_", "?", "BasisQ"}]}]}], "}"}], ",", 
     "texstring_String"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"TexBasis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "basis"}]}], "}"}], ",", "ind_"}], "]"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"texstring", ",", 
       RowBox[{"TexIndices", "[", "ind", "]"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5831492595092382`*^9, 3.5831493793018484`*^9}, {
   3.583149424853928*^9, 3.58314948842404*^9}, 3.5831500002931395`*^9},
 CellLabel->
  "In[292]:=",ExpressionUUID->"ac8f0fc4-1b24-499a-8a81-902ffd2465ec"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FormatTexBasis", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"covd_Symbol", "?", "CovDQ"}], "[", 
      RowBox[{"{", 
       RowBox[{"i_Integer", ",", "basis_"}], "}"}], "]"}], ",", 
     "texstring_String"}], "]"}], ":=", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"TexCovDPrefix", "[", 
      RowBox[{"covd", ",", 
       RowBox[{"IndexList", "[", 
        RowBox[{"{", 
         RowBox[{"i", ",", "basis"}], "}"}], "]"}]}], "]"}], ",", 
     "texstring"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FormatTexBasis", "[", 
   RowBox[{
    RowBox[{"covd_Symbol", "?", "CovDQ"}], "[", 
    RowBox[{"{", 
     RowBox[{"i_Integer", ",", "basis_"}], "}"}], "]"}], "]"}], ":=", 
  RowBox[{"Unset", "[", 
   RowBox[{"TexCovDPrefix", "[", 
    RowBox[{"covd", ",", 
     RowBox[{"IndexList", "[", 
      RowBox[{"{", 
       RowBox[{"i", ",", "basis"}], "}"}], "]"}]}], "]"}], "]"}]}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.583149522728501*^9, 3.583149548796146*^9}},
 CellLabel->
  "In[295]:=",ExpressionUUID->"086ccb24-c9e6-4f59-a692-d2cec58d9712"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.9. Tensors", "Subsection",
 CellChangeTimes->{
  3.583148457373828*^9},ExpressionUUID->"b9c1bd29-032d-433e-9323-\
b16b38a4db32"],

Cell["Jose\[CloseCurlyQuote]s old code on tensors:", "Text",ExpressionUUID->"7ab4b7c3-4e82-44e1-90d8-1ce1d84d5269"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Tensors", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{
       RowBox[{"tensor_", "?", "xTensorQ"}], "[", "indices___", "]"}], "]"}], 
     ":=", 
     RowBox[{"TexTensorCombine", "[", 
      RowBox[{
       RowBox[{"Tex", "[", "tensor", "]"}], ",", 
       RowBox[{"TexIndex", "/@", 
        RowBox[{"IndexList", "[", "indices", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexTensorCombine", "[", 
      RowBox[{"tensor_", ",", 
       RowBox[{"IndexList", "[", "indices___", "]"}]}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"tensor", ",", "indices"}], "]"}]}], ";"}]}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"c0cdd6aa-0113-42f9-9692-0d21a597e2ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New symbol created: \"\>", 
   "\[InvisibleSpace]", "\<\"TexTensorCombine\"\>", 
   "\[InvisibleSpace]", "\<\", Context: \"\>", 
   "\[InvisibleSpace]", "\<\"xAct`xTensor`Private`\"\>"}],
  SequenceForm[
  "New symbol created: ", "TexTensorCombine", ", Context: ", 
   "xAct`xTensor`Private`"],
  Editable->False]], "Print",ExpressionUUID->"a0ca6f70-552d-418e-a550-\
0b6a2ef103fd"]
}, Open  ]],

Cell["Thomas\[CloseCurlyQuote] code, producing less parenthesization:", "Text",ExpressionUUID->"fdd7276f-7982-401c-ad70-c2769580659f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Tensors", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Tex", "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "xTensorQ"}], "[", "indices___", "]"}], "]"}], ":=", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"Tex", "[", "tensor", "]"}], ",", 
      RowBox[{"TexIndices", "[", "indices", "]"}]}], "]"}]}], 
   ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.619628741889248*^9, 3.619628743499249*^9}, {
  3.6196292342800336`*^9, 3.61962927462009*^9}, {3.619629363460214*^9, 
  3.619629364410215*^9}},
 CellLabel->
  "In[297]:=",ExpressionUUID->"693a37ae-7363-45e3-8bc8-4a91a74798b0"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.10. Scalar functions", "Subsection",
 CellChangeTimes->{{3.5831484590118313`*^9, 
  3.583148459526633*^9}},ExpressionUUID->"db4503e9-5519-442d-b601-\
6f012da8ea7e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Derivatives", " ", "of", " ", "scalar", " ", "functions"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"deriv", "[", 
      RowBox[{"var_", ",", "1"}], "]"}], ":=", 
     RowBox[{"\"\<\\\\partial \>\"", "<>", 
      RowBox[{"Tex", "[", "var", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"deriv", "[", 
      RowBox[{"var_", ",", "n_"}], "]"}], ":=", 
     RowBox[{"\"\<\\\\partial^{\>\"", "<>", 
      RowBox[{"Tex", "[", "n", "]"}], "<>", "\"\<}\>\"", "<>", 
      RowBox[{"Tex", "[", "var", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"withrespectto", "[", 
      RowBox[{"vars_List", ",", "ders_List"}], "]"}], ":=", 
     RowBox[{"Inner", "[", 
      RowBox[{"withrespectto", ",", "vars", ",", "ders", ",", "StringJoin"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"withrespectto", "[", 
      RowBox[{"var_", ",", "0"}], "]"}], ":=", "\"\<\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"withrespectto", "[", 
      RowBox[{"var_", ",", "1"}], "]"}], ":=", 
     RowBox[{"\"\<\\\\partial \>\"", "<>", 
      RowBox[{"Tex", "[", "var", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"withrespectto", "[", 
      RowBox[{"var_", ",", "n_"}], "]"}], ":=", 
     RowBox[{"\"\<\\\\partial \>\"", "<>", 
      RowBox[{"Tex", "[", "var", "]"}], "<>", "\"\<^{\>\"", "<>", 
      RowBox[{"Tex", "[", "n", "]"}], "<>", "\"\<}\>\""}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "ders__", "]"}], "[", 
        RowBox[{"f_", "?", "ScalarFunctionQ"}], "]"}], "[", "vars__", "]"}], 
      "]"}], ":=", 
     RowBox[{"\"\<\\\\frac{\>\"", "<>", 
      RowBox[{"deriv", "[", 
       RowBox[{
        RowBox[{"f", "[", "vars", "]"}], ",", 
        RowBox[{"Plus", "[", "ders", "]"}]}], "]"}], "<>", "\"\<}{\>\"", "<>", 
      RowBox[{"withrespectto", "[", 
       RowBox[{
        RowBox[{"{", "vars", "}"}], ",", 
        RowBox[{"{", "ders", "}"}]}], "]"}], "<>", "\"\<}\>\""}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[298]:=",ExpressionUUID->"1448c191-c1f1-4dff-bd34-d38579d904a3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Factorial", "[", "n_Symbol", "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"Tex", "[", "n", "]"}], ",", "\"\<!\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Factorial", "[", "n_", "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
    RowBox[{"Tex", "[", "n", "]"}], ",", 
    RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}], ",", "\"\<!\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Factorial2", "[", "n_Symbol", "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"Tex", "[", "n", "]"}], ",", "\"\<!!\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Factorial2", "[", "n_", "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
    RowBox[{"Tex", "[", "n", "]"}], ",", 
    RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}], ",", "\"\<!!\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{"n_", ",", "k_"}], "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
    RowBox[{"Tex", "[", "n", "]"}], ",", 
    RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}], ",", "\"\<_{\>\"", ",", 
    RowBox[{"Tex", "[", "k", "]"}], ",", "\"\<}\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Binomial", "[", 
    RowBox[{"n_", ",", "k_"}], "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"\"\<\\\\binom{\>\"", ",", 
    RowBox[{"Tex", "[", "n", "]"}], ",", "\"\<}{\>\"", ",", 
    RowBox[{"Tex", "[", "k", "]"}], ",", "\"\<}\>\""}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.595431076189289*^9, 3.595431081729297*^9}, {
  3.595431388709728*^9, 3.5954314408708*^9}, {3.595577988449433*^9, 
  3.595578109859602*^9}, {3.595578219019755*^9, 3.5955782280997677`*^9}},
 CellLabel->
  "In[305]:=",ExpressionUUID->"864e8efd-8eee-411b-8e17-4d270306936d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Other", " ", "scalar", " ", "functions"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{
       RowBox[{"f_", "?", "ScalarFunctionQ"}], "[", "args__", "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"Tex", "[", "f", "]"}], ",", 
       RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
       RowBox[{"Sequence", "@@", 
        RowBox[{"InsertComma", "[", 
         RowBox[{"Tex", "/@", 
          RowBox[{"{", "args", "}"}]}], "]"}]}], ",", 
       RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InsertComma", "[", "arguments_List", "]"}], ":=", 
     RowBox[{"Insert", "[", 
      RowBox[{"arguments", ",", "\"\<, \>\"", ",", 
       RowBox[{"List", "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"2", ",", 
          RowBox[{"Length", "[", "arguments", "]"}]}], "]"}]}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[311]:=",ExpressionUUID->"06199b68-0459-47a0-89a0-d09fda83c9fc"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.11. Inert heads", "Subsection",
 CellChangeTimes->{
  3.583148461710636*^9},ExpressionUUID->"a1dc0b28-d5eb-46cf-aad2-\
71a49a8a2f53"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Innert", " ", "heads"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Tex", "[", 
     RowBox[{
      RowBox[{"ih_", "?", "InertHeadQ"}], "[", 
      RowBox[{"expr_", ",", "z___"}], "]"}], "]"}], ":=", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"Tex", "[", "ih", "]"}], ",", 
      RowBox[{"TexOpen", "[", "\"\<[\>\"", "]"}], ",", 
      RowBox[{"Tex", "[", "expr", "]"}], ",", 
      RowBox[{"TexClose", "[", "\"\<]\>\"", "]"}]}], "]"}]}], 
   ";"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[313]:=",ExpressionUUID->"93ee7daf-57f5-404d-9090-1842282b7ecb"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.12. Scalar expressions", "Subsection",
 CellChangeTimes->{
  3.583148463192639*^9},ExpressionUUID->"e8d5844b-cb51-4d9f-a413-\
8e5497b77f1f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Remove", " ", "the", " ", "Scalar", " ", "head"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"$TexScalarParentheses", "=", "True"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Scalar", "[", "expr_", "]"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{"$TexScalarParentheses", ",", "\[IndentingNewLine]", 
       RowBox[{"StringJoin", "[", 
        RowBox[{
         RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
         RowBox[{"Tex", "[", "expr", "]"}], ",", 
         RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Tex", "[", "expr", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[314]:=",ExpressionUUID->"d95c42cb-715e-41dd-8763-5b8adf2eb385"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.13. Covariant derivatives", "Subsection",
 CellChangeTimes->{
  3.583148465033442*^9},ExpressionUUID->"608a8787-fec7-49bf-9558-\
db6e01a084c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Covariant", " ", "derivatives"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"covd_Symbol", "?", "CovDQ"}], "[", "inds__", "]"}], "[", 
       "expr_", "]"}], "]"}], ":=", 
     RowBox[{"TexCovDCombine", "[", 
      RowBox[{"covd", ",", 
       RowBox[{"Tex", "[", "expr", "]"}], ",", 
       RowBox[{"IndexList", "[", "inds", "]"}], ",", "$CovDFormat"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexCovDCombine", "[", 
      RowBox[{
      "covd_", ",", "exprstring_String", ",", "list_IndexList", ",", 
       "\"\<Prefix\>\""}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexCovDPrefix", "[", 
        RowBox[{"covd", ",", "list"}], "]"}], ",", "exprstring"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexCovDPrefix", "[", 
      RowBox[{"covd_", ",", "list_IndexList"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"Last", "@", 
        RowBox[{"TexCovD", "[", "covd", "]"}]}], ",", 
       RowBox[{"TexIndices", "@@", "list"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexCovDCombine", "[", 
      RowBox[{
      "covd_", ",", "exprstring_String", ",", "list_IndexList", ",", 
       "\"\<Postfix\>\""}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"exprstring", ",", 
       RowBox[{
        RowBox[{"TexCovDIndices", "[", 
         RowBox[{"First", "@", 
          RowBox[{"TexCovD", "@", "covd"}]}], "]"}], "@@", "list"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "If", " ", "the", " ", "$CovDFormat", " ", "only", " ", "gives", " ", 
      "one", " ", "string"}], ",", " ", 
     RowBox[{"use", " ", "it", " ", "for", " ", "both", " ", 
      RowBox[{"cases", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexCovD", "[", "covd_", "]"}], ":=", 
     RowBox[{"Tex", "/@", 
      RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.583135020589576*^9, 3.5831350985585136`*^9}, {
   3.583135714339394*^9, 3.583135719565403*^9}, 3.583136176427806*^9, {
   3.583146255318761*^9, 3.583146301775643*^9}, {3.5831463427725153`*^9, 
   3.583146423175055*^9}, 3.583146610375385*^9, {3.583146716502371*^9, 
   3.5831467772644787`*^9}, {3.58314680738813*^9, 3.583146811990138*^9}, {
   3.583147184504193*^9, 3.583147288415975*^9}},
 CellLabel->
  "In[316]:=",ExpressionUUID->"af38f09b-6f3b-4c1c-aa48-059e1bb554b6"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"TexCovDCombine", "[", 
     RowBox[{
      RowBox[{"{", "a_", "}"}], ",", "b___"}], "]"}], ":=", 
    RowBox[{"TexCovDCombine", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "a"}], "}"}], ",", "b"}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tex", "[", 
     RowBox[{"CovD", "[", 
      RowBox[{"expr_", ",", "ders___", ",", 
       RowBox[{
        RowBox[{"der_Symbol", "?", "CovDQ"}], "[", "inds__", "]"}]}], "]"}], 
     "]"}], ":=", 
    RowBox[{"TexCovDCombine", "[", 
     RowBox[{
      RowBox[{"TexCovD", "[", "der", "]"}], ",", 
      RowBox[{"Tex", "[", "expr", "]"}], ",", 
      RowBox[{"IndexList", "[", "inds", "]"}], ",", "$CovDFormat"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.5831462782664022`*^9, 3.5831462978288355`*^9}},
 CellLabel->
  "In[321]:=",ExpressionUUID->"e5b05be7-c00e-4f9a-a0e7-023628513ff2"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.14. Lie derivatives and brackets", "Subsection",
 CellChangeTimes->{
  3.583148466609045*^9, {3.6205422433640704`*^9, 
   3.620542247474077*^9}},ExpressionUUID->"e4652de8-278d-4d22-81f6-\
1fc50c10b296"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Lie", " ", "derivatives"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Tex", "[", 
     RowBox[{
      RowBox[{"LieD", "[", 
       RowBox[{"n_Symbol", "[", "_", "]"}], "]"}], "[", "expr_", "]"}], "]"}],
     ":=", 
    RowBox[{"\"\<\\\\mathcal{L}_\>\"", "<>", 
     RowBox[{"Tex", "[", "n", "]"}], "<>", "\"\< \>\"", "<>", 
     RowBox[{"Tex", "[", "expr", "]"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6407639077970552`*^9, 3.640763911047058*^9}},
 CellLabel->
  "In[322]:=",ExpressionUUID->"bda37ad5-b0c0-4deb-bfac-8d39b54cc112"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Brackets", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Tex", "[", 
     RowBox[{"Bracket", "[", 
      RowBox[{"expr1_", ",", "expr2_"}], "]"}], "]"}], ":=", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"TexOpen", "[", "\"\<[\>\"", "]"}], ",", 
      RowBox[{"Tex", "[", "expr1", "]"}], ",", "\"\<, \>\"", ",", " ", 
      RowBox[{"Tex", "[", "expr2", "]"}], ",", 
      RowBox[{"TexClose", "[", "\"\<]\>\"", "]"}]}], "]"}]}], 
   ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.620542260424094*^9, 3.620542377444258*^9}},
 CellLabel->
  "In[323]:=",ExpressionUUID->"32aa9a74-bc5c-42f2-9b89-e3bec221d2c1"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.15. Parametric derivatives", "Subsection",
 CellChangeTimes->{
  3.583148468949049*^9},ExpressionUUID->"7f6b9329-1025-4dca-9e01-\
95b276471b25"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Parametric", " ", "derivative"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TexParamD", "[", 
      RowBox[{"{", "ps_", "}"}], "]"}], ":=", 
     RowBox[{"\"\<\\\\partial_\>\"", "<>", 
      RowBox[{"Tex", "[", "ps", "]"}], "<>", "\"\< \>\""}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TexParamD", "[", 
      RowBox[{"ps", ":", 
       RowBox[{"{", "__", "}"}]}], "]"}], ":=", 
     RowBox[{"\"\<\\\\partial_\>\"", "<>", 
      RowBox[{"Tex", "[", 
       RowBox[{"First", "[", "ps", "]"}], "]"}], "<>", "\"\<^{\>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"Length", "[", "ps", "]"}], "]"}], "<>", "\"\<} \>\""}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{
       RowBox[{"ParamD", "[", "ps__", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"$ParamDFormat", "==", "\"\<Postfix\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"StringJoin", "[", 
        RowBox[{
         RowBox[{"Tex", "[", "expr", "]"}], ",", "\"\<{}_{,\>\"", ",", 
         RowBox[{"Sequence", "@@", 
          RowBox[{"(", 
           RowBox[{"Tex", "/@", 
            RowBox[{"{", "ps", "}"}]}], ")"}]}], ",", "\"\<}\>\""}], "]"}], 
       ",", 
       RowBox[{
        RowBox[{"Apply", "[", 
         RowBox[{"StringJoin", ",", 
          RowBox[{"TexParamD", "/@", 
           RowBox[{"Split", "@", 
            RowBox[{"Sort", "[", 
             RowBox[{"{", "ps", "}"}], "]"}]}]}]}], "]"}], "<>", 
        RowBox[{"Tex", "[", "expr", "]"}]}]}], "\[IndentingNewLine]", "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Tex", "[", 
       RowBox[{
        RowBox[{"ParamD", "[", "ps__", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Apply", "[", 
        RowBox[{"StringJoin", ",", 
         RowBox[{"TexParamD", "/@", 
          RowBox[{"Split", "@", 
           RowBox[{"Sort", "[", "ps", "]"}]}]}]}], "]"}], "<>", 
       RowBox[{"TexOpen", "[", "\"\<[\>\"", "]"}], "<>", 
       RowBox[{"Tex", "[", "expr", "]"}], "<>", 
       RowBox[{"TexClose", "[", "\"\<]\>\"", "]"}]}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[324]:=",ExpressionUUID->"6d9c445a-b1e5-4641-83fe-ede0c88499bb"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.16. Equalities and inequalities", "Subsection",
 CellChangeTimes->{
  3.583148470883453*^9, {3.5955814809293222`*^9, 3.5955814858993287`*^9}, {
   3.595581619059515*^9, 
   3.5955816199895167`*^9}},ExpressionUUID->"e302008e-6ac4-4e41-9709-\
84f682f298a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Equal", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "expr_Equal", "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"Tex", "/@", 
         RowBox[{"List", "@@", "expr"}]}], ",", "\"\< = \>\""}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Equal", "]"}], ":=", "\"\< = \>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.595581498739347*^9, 3.595581503419354*^9}, {
  3.6045951807047195`*^9, 3.6045952122747636`*^9}, {3.6799834197272587`*^9, 
  3.6799834394271293`*^9}, {3.679983474347828*^9, 3.6799834762078657`*^9}},
 CellLabel->
  "In[327]:=",ExpressionUUID->"62d27083-30cc-43bc-bea9-70f27b2911a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Less", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "expr_Less", "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"Tex", "/@", 
         RowBox[{"List", "@@", "expr"}]}], ",", "\"\< < \>\""}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Less", "]"}], ":=", "\"\< < \>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.595581498739347*^9, 3.595581516679372*^9}, {
  3.60459521669477*^9, 3.6045952291947875`*^9}, {3.679983496158264*^9, 
  3.679983504568433*^9}},
 CellLabel->
  "In[329]:=",ExpressionUUID->"ef0aeec3-a116-4956-8855-2f14318ac1f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "LessEqual", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "expr_LessEqual", "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"Tex", "/@", 
         RowBox[{"List", "@@", "expr"}]}], ",", "\"\< \\\\leq \>\""}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "LessEqual", "]"}], ":=", "\"\< \\\\leq \>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.595581498739347*^9, 3.595581516679372*^9}, {
  3.595581555479427*^9, 3.595581563029437*^9}, {3.6045952337547936`*^9, 
  3.604595255244824*^9}, {3.679983506798477*^9, 3.679983519378729*^9}},
 CellLabel->
  "In[331]:=",ExpressionUUID->"b10ae447-219e-445c-894c-43bb5691445b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Less", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "expr_Greater", "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"Tex", "/@", 
         RowBox[{"List", "@@", "expr"}]}], ",", "\"\< > \>\""}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Greater", "]"}], ":=", "\"\< > \>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.595581498739347*^9, 3.595581516679372*^9}, {
  3.595581585799469*^9, 3.595581591359476*^9}, {3.604595259934831*^9, 
  3.6045952743748507`*^9}, {3.67998352093876*^9, 3.6799835348190374`*^9}},
 CellLabel->
  "In[333]:=",ExpressionUUID->"1081df14-4808-46f5-abb8-4ffeb2a5d0a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "LessEqual", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "expr_GreaterEqual", "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"Tex", "/@", 
         RowBox[{"List", "@@", "expr"}]}], ",", "\"\< \\\\geq \>\""}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "GreaterEqual", "]"}], ":=", "\"\< \\\\geq \>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.595581498739347*^9, 3.595581516679372*^9}, {
  3.595581555479427*^9, 3.595581563029437*^9}, {3.595581595839483*^9, 
  3.595581606679498*^9}, {3.604595277994856*^9, 3.6045952966048813`*^9}, {
  3.679983537089083*^9, 3.679983556549472*^9}},
 CellLabel->
  "In[335]:=",ExpressionUUID->"c98a1307-09f9-4431-9c1c-88390a39e499"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Unequal", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "expr_Unequal", "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"Tex", "/@", 
         RowBox[{"List", "@@", "expr"}]}], ",", "\"\< \\\\neq \>\""}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "Unequal", "]"}], ":=", "\"\< \\\\neq \>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8166937905136733`*^9, 3.816693798503827*^9}},
 CellLabel->
  "In[337]:=",ExpressionUUID->"f8b2ac60-5992-4240-b6a5-5317848d33d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"Rule", "[", 
    RowBox[{"a_", ",", " ", "b_"}], "]"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Tex", "[", "a", "]"}], " ", "<>", " ", "\"\<\\\\rightarrow \>\"", 
   " ", "<>", " ", 
   RowBox[{"Tex", "[", "b", "]"}]}]}]], "Code",
 CellChangeTimes->{{3.875861740951536*^9, 3.875861743172599*^9}},
 CellLabel->
  "In[339]:=",ExpressionUUID->"d4fcf8d3-1e1b-4fbc-9a53-408842e9b161"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.17. The TexPrint function", "Subsection",ExpressionUUID->"e2b7e8ac-5584-426a-80b5-4a9dab921c4f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexFixExtraRules", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[340]:=",ExpressionUUID->"1d830e06-524f-4287-b6a0-4696ceb9db6b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Note", " ", "that", " ", "we", " ", "remove", " ", "the", " ", 
    RowBox[{"dollars", "!"}], " ", "This", " ", "is", " ", "because", " ", 
    "\[Mu]3", " ", "is", " ", "converted", " ", "into", " ", 
    RowBox[{"$", "\\", "mu$3"}], " ", "for", " ", "instance"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TexFix", "[", "string_String", "]"}], ":=", 
    RowBox[{"StringReplace", "[", 
     RowBox[{
      RowBox[{"StringReplace", "[", 
       RowBox[{"string", ",", 
        RowBox[{"\"\<$\>\"", "->", "\"\<\>\""}]}], "]"}], ",", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<+-\>\"", "\[Rule]", "\"\<-\>\""}], ",", 
          RowBox[{"\"\<+ -\>\"", "\[Rule]", "\"\<- \>\""}], ",", 
          RowBox[{"\"\< _\>\"", "->", "\"\<_\>\""}], ",", 
          RowBox[{"\"\< ^\>\"", "->", "\"\<^\>\""}], ",", 
          RowBox[{"\"\<  \>\"", "->", "\"\< \>\""}], ",", 
          RowBox[{"\"\<   \>\"", "->", "\"\< \>\""}], ",", " ", 
          RowBox[{"\"\< }\>\"", "\[Rule]", "\"\<}\>\""}], ",", " ", 
          RowBox[{"\"\<  }\>\"", "\[Rule]", "\"\<}\>\""}], ",", " ", 
          RowBox[{"\"\< )\>\"", "\[Rule]", "\"\<)\>\""}], ",", " ", 
          RowBox[{"\"\<  )\>\"", "\[Rule]", "\"\<)\>\""}]}], "}"}], ",", 
        "$TexFixExtraRules"}], "]"}]}], "]"}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.564383847298499*^9, 3.564383856596116*^9}, {
  3.5643843380753617`*^9, 3.564384342989372*^9}, {3.564385030171577*^9, 
  3.5643850442116017`*^9}, {3.728803899813012*^9, 3.728803934133975*^9}},
 CellLabel->
  "In[341]:=",ExpressionUUID->"7aa86cf1-727d-4a96-9e49-8a568d5abea1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Main", ".", " ", "Public"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TexPrint", "[", 
     RowBox[{"expr_", ",", 
      RowBox[{"initlevel_", ":", "Automatic"}]}], "]"}], ":=", 
    RowBox[{"TexFix", "@", 
     RowBox[{"TexParenthesis", "[", 
      RowBox[{
       RowBox[{"ScreenDollarIndices", "[", "expr", "]"}], ",", "initlevel"}], 
      "]"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[342]:=",ExpressionUUID->"a8ed8c09-28cb-4c6f-9561-c81be43c5ff7"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.18. Matrices", "Subsection",
 CellChangeTimes->{{3.559468159345866*^9, 3.5594681704062843`*^9}, 
   3.559468557988966*^9},ExpressionUUID->"09942665-d371-47be-bfd7-\
761cc84c136e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$TexMatrixParen", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<(\>\"", ",", "\"\<)\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TexMatrix", "[", 
   RowBox[{
    RowBox[{"M_", "?", "MatrixQ"}], ",", 
    RowBox[{"F_", ":", " ", "Tex"}], ",", " ", 
    RowBox[{"righthandcols_", ":", "0"}]}], "]"}], ":=", 
  RowBox[{"TexFix", "@", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"rows", "=", 
        RowBox[{"Length", "[", "M", "]"}]}], ",", 
       RowBox[{"cols", "=", 
        RowBox[{"Length", "@", 
         RowBox[{"First", "@", "M"}]}]}]}], "}"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<\\\\left\>\"", ",", 
       RowBox[{"$TexMatrixParen", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<\\\\begin{array}{\>\"", ",", 
       RowBox[{"StringJoin", "@@", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"\"\<c\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"cols", "-", " ", "righthandcols"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"If", "[", " ", 
        RowBox[{
         RowBox[{"righthandcols", ">", "0"}], ",", 
         RowBox[{"\"\<|\>\"", "<>", 
          RowBox[{"StringJoin", "@@", 
           RowBox[{"ConstantArray", "[", 
            RowBox[{"\"\<c\>\"", ",", 
             RowBox[{"{", " ", "righthandcols", "}"}]}], "]"}]}]}], ",", 
         "\"\<\>\""}], "]"}], ",", "\"\<}\\n\>\"", ",", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"Riffle", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{"Riffle", "[", 
              RowBox[{
               RowBox[{"F", "/@", "#"}], ",", "\"\< & \>\""}], "]"}], "]"}], 
            "&"}], "/@", "M"}], ",", "\"\<\\\\\\\\\\n\>\""}], "]"}], "]"}], 
       ",", "\"\<\\n\\\\end{array}\\\\right\>\"", ",", 
       RowBox[{"$TexMatrixParen", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}]}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.559468186645914*^9, 3.559468186645914*^9}, {
   3.5594686726803675`*^9, 3.55946867445877*^9}, {3.5594688200392256`*^9, 
   3.5594688221920304`*^9}, {3.55946886799371*^9, 3.559468877540928*^9}, 
   3.559469566843738*^9, {3.640763927597082*^9, 3.640763931237087*^9}, {
   3.679983584730036*^9, 3.679983647151284*^9}, {3.820204465972487*^9, 
   3.8202045222925177`*^9}, {3.820204554660147*^9, 3.8202046012936945`*^9}},
 CellLabel->
  "In[343]:=",ExpressionUUID->"851ad325-571f-413e-91be-b287fc062478"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexBMatrix", "[", 
   RowBox[{
    RowBox[{"M_", "?", "MatrixQ"}], ",", 
    RowBox[{"F_", ":", "Tex"}]}], "]"}], ":=", 
  RowBox[{"TexFix", "[", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"rows", "=", 
        RowBox[{"Length", "[", "M", "]"}]}], ",", 
       RowBox[{"cols", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"First", "[", "M", "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"\"\<\\\\begin{bmatrix}\\n\>\"", "<>", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"Riffle", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{"Riffle", "[", 
              RowBox[{
               RowBox[{"F", "/@", "#1"}], ",", "\"\< & \>\""}], "]"}], "]"}], 
            "&"}], ")"}], "/@", "M"}], ",", "\"\<\\\\\\\\\\n\>\""}], "]"}], 
       "]"}], "<>", "\"\<\\n\\\\end{bmatrix}\>\""}]}], "]"}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.8166968308061676`*^9},
 CellLabel->
  "In[345]:=",ExpressionUUID->"dceaefea-ba09-42fe-a4c1-4f2682d793cf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexPMatrix", "[", 
   RowBox[{
    RowBox[{"M_", "?", "MatrixQ"}], ",", 
    RowBox[{"F_", ":", "Tex"}]}], "]"}], ":=", 
  RowBox[{"TexFix", "[", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"rows", "=", 
        RowBox[{"Length", "[", "M", "]"}]}], ",", 
       RowBox[{"cols", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"First", "[", "M", "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"\"\<\\\\begin{pmatrix}\\n\>\"", "<>", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"Riffle", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{"Riffle", "[", 
              RowBox[{
               RowBox[{"F", "/@", "#1"}], ",", "\"\< & \>\""}], "]"}], "]"}], 
            "&"}], ")"}], "/@", "M"}], ",", "\"\<\\\\\\\\\\n\>\""}], "]"}], 
       "]"}], "<>", "\"\<\\n\\\\end{pmatrix}\>\""}]}], "]"}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.816696834178193*^9},
 CellLabel->
  "In[346]:=",ExpressionUUID->"9b7c2081-55a6-4270-835a-9273f1f4bb94"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexDet", "[", 
   RowBox[{
    RowBox[{"M_", "?", "MatrixQ"}], ",", 
    RowBox[{"F_", ":", "Tex"}]}], "]"}], ":=", 
  RowBox[{"TexFix", "[", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"rows", "=", 
        RowBox[{"Length", "[", "M", "]"}]}], ",", 
       RowBox[{"cols", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"First", "[", "M", "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"\"\<\\\\begin{vmatrix}\\n\>\"", "<>", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"Riffle", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{"Riffle", "[", 
              RowBox[{
               RowBox[{"F", "/@", "#1"}], ",", "\"\< & \>\""}], "]"}], "]"}], 
            "&"}], ")"}], "/@", "M"}], ",", "\"\<\\\\\\\\\\n\>\""}], "]"}], 
       "]"}], "<>", "\"\<\\n\\\\end{vmatrix}\>\""}]}], "]"}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.816696837534177*^9},
 CellLabel->
  "In[347]:=",ExpressionUUID->"5aedbe8c-d51c-44b2-b98b-789e9ece7960"],

Cell["TexMatrix is the default.", "Text",
 CellChangeTimes->{{3.820204976429621*^9, 
  3.820204997886953*^9}},ExpressionUUID->"db779c52-ab5a-480d-b394-\
6399a97eccd2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"M_", "?", "MatrixQ"}], "]"}], " ", ":=", " ", 
   RowBox[{"TexMatrix", "[", "M", "]"}]}], ";"}]], "Code",
 CellChangeTimes->{{3.8202043486881647`*^9, 3.820204383003578*^9}},
 CellLabel->
  "In[348]:=",ExpressionUUID->"9ce7b9d3-9771-4df8-ac12-347e126f5370"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.19. Hold", "Subsection",
 CellChangeTimes->{{3.5915971338389783`*^9, 
  3.591597147628998*^9}},ExpressionUUID->"188cac56-ec18-434b-a469-\
b04c4d614c83"],

Cell["\<\
Hold can be used to stop a derivative to use the Leibniz rule, and it can \
also stop other automatic rules to be applied. Therefore, it might be a \
useful tool for typesetting too. We just typeset it as a parentesis.\
\>", "Text",
 CellChangeTimes->{{3.591597295079204*^9, 3.591597376519318*^9}, {
  3.591597408584703*^9, 3.591597518031554*^9}, {3.591597585772648*^9, 
  3.591597611092684*^9}},ExpressionUUID->"01451bb6-586e-4343-a90b-\
b12d1a6a825a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"Hold", "[", "expr_", "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
     RowBox[{"Tex", "[", "expr", "]"}], ",", 
     RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.591597237279124*^9, 3.591597252769145*^9}},
 CellLabel->
  "In[349]:=",ExpressionUUID->"e1bd6282-181f-48f3-a974-a2c5566e6f3e"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.20. SeriesData", "Subsection",
 CellChangeTimes->{{3.5915971338389783`*^9, 3.591597147628998*^9}, {
  3.6045914295767665`*^9, 
  3.604591433776773*^9}},ExpressionUUID->"a989b3bd-be46-4d84-bb90-\
9d7f95f83612"],

Cell["Older (deactivated)", "Text",
 CellChangeTimes->{{3.616502316647503*^9, 3.616502319947507*^9}, {
  3.616502444221729*^9, 
  3.6165024483217354`*^9}},ExpressionUUID->"f890ad87-18d8-4b13-bd48-\
7e877b18bf52"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"sdata", ":", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"SeriesData", "[", 
      RowBox[{"x_", ",", 
       RowBox[{"DirectedInfinity", "[", "1", "]"}], ",", 
       RowBox[{"{", "coeffs___", "}"}], ",", "nmin_Integer", ",", 
       "nmax_Integer", ",", "den_"}], "]"}], "]"}]}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"Tex", "[", 
     RowBox[{"Normal", "@", "sdata"}], "]"}], ",", 
    "\"\< + \\\\mathcal{O}\>\"", ",", 
    RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
    RowBox[{"Tex", "[", 
     RowBox[{
      RowBox[{"(", "x", ")"}], "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "nmax"}], "/", "den"}], ")"}]}], "]"}], ",", 
    RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.616396030386691*^9, 3.616396039056703*^9}, {
  3.6163967364108243`*^9, 3.616396741800832*^9}},
 CellLabel->
  "In[350]:=",ExpressionUUID->"907983a4-fde5-48f9-9a57-f97e0ba5ccce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"sdata", ":", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"SeriesData", "[", 
      RowBox[{"x_", ",", "x0_", ",", 
       RowBox[{"{", "coeffs___", "}"}], ",", "nmin_Integer", ",", 
       "nmax_Integer", ",", "den_"}], "]"}], "]"}]}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{
    RowBox[{"Tex", "[", 
     RowBox[{"Normal", "@", "sdata"}], "]"}], ",", 
    "\"\< + \\\\mathcal{O}\>\"", ",", 
    RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
    RowBox[{"Tex", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"nmax", "/", "den"}], ")"}]}], "]"}], ",", 
    RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6045915248269*^9, 3.6045915353569155`*^9}, {
  3.604595837233989*^9, 3.604595839003991*^9}, {3.6163960149566693`*^9, 
  3.616396018356674*^9}},
 CellLabel->
  "In[351]:=",ExpressionUUID->"de26f310-2738-477b-90fe-38aa27661665"],

Cell["New 2014-08-08", "Text",
 CellChangeTimes->{{3.616502311437495*^9, 3.616502313807499*^9}, {
  3.6165060253073215`*^9, 
  3.6165060294573274`*^9}},ExpressionUUID->"b65befdb-6ea0-4107-8334-\
2172b837acbb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"sd", ":", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"SeriesData", "[", 
      RowBox[{"x_", ",", 
       RowBox[{"DirectedInfinity", "[", "1", "]"}], ",", "coefflist_List", 
       ",", "nmin_", ",", "nmax_", ",", "den_"}], "]"}], "]"}]}], "]"}], ":=", 
  RowBox[{"Tex", "[", 
   RowBox[{"OrderedPlus", "@@", 
    RowBox[{"Append", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"coefflist", "[", 
            RowBox[{"[", "#", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"#", "-", "1", "+", "nmin"}], ")"}]}], "/", "den"}], 
             ")"}]}]}], ")"}], "&"}], "/@", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", "coefflist"}]}]}], ")"}], ",", 
      RowBox[{"TexString", "@", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\\\mathcal{O}\>\"", ",", 
         RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
         RowBox[{"Tex", "[", 
          RowBox[{
           RowBox[{"(", "x", ")"}], "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "nmax"}], "/", "den"}], ")"}]}], "]"}], ",", 
         RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}]}], "]"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.616502205667347*^9, 3.616502249337408*^9}, 
   3.616502482691783*^9, {3.6165026768620553`*^9, 3.616502686904095*^9}, {
   3.616502840146332*^9, 3.616502850846347*^9}, {3.616503202940888*^9, 
   3.616503203500889*^9}, {3.616503253810959*^9, 3.616503263850973*^9}, {
   3.6165035310363955`*^9, 3.616503539396407*^9}, {3.616504403049761*^9, 
   3.616504464159846*^9}, {3.616504519883973*^9, 3.6165045272239833`*^9}, {
   3.616504599444084*^9, 3.616504715704247*^9}, {3.616505358883244*^9, 
   3.6165053659932537`*^9}},
 CellLabel->
  "In[352]:=",ExpressionUUID->"55209a21-8d86-4930-83b2-b998c6fc6556"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"sd", ":", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"SeriesData", "[", 
      RowBox[{
      "x_", ",", "x0_", ",", "coefflist_List", ",", "nmin_", ",", "nmax_", 
       ",", "den_"}], "]"}], "]"}]}], "]"}], ":=", 
  RowBox[{"Tex", "[", 
   RowBox[{"OrderedPlus", "@@", 
    RowBox[{"Append", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"coefflist", "[", 
            RowBox[{"[", "#", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"OrderedPlus", "[", 
             RowBox[{"x", ",", 
              RowBox[{"-", "x0"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"#", "-", "1", "+", "nmin"}], ")"}], "/", "den"}], 
             ")"}]}]}], ")"}], "&"}], "/@", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", "coefflist"}]}]}], ")"}], ",", 
      RowBox[{"TexString", "@", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\\\mathcal{O}\>\"", ",", 
         RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
         RowBox[{"Tex", "[", 
          RowBox[{
           RowBox[{"OrderedPlus", "[", 
            RowBox[{"x", ",", 
             RowBox[{"-", "x0"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"nmax", "/", "den"}], ")"}]}], "]"}], ",", 
         RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}]}], "]"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.616502453411742*^9, 3.616502497621804*^9}, 
   3.616502694996129*^9, {3.616502855546354*^9, 3.6165028664163685`*^9}, {
   3.616502995080597*^9, 3.6165030008406053`*^9}, {3.6165032672009788`*^9, 
   3.6165032740109873`*^9}, {3.6165035465964184`*^9, 3.616503559076435*^9}, {
   3.6165037092706933`*^9, 3.616503711640697*^9}, {3.616504486249878*^9, 
   3.6165045399640007`*^9}, {3.616504738284279*^9, 3.6165047490942936`*^9}, {
   3.616505369343258*^9, 3.6165054214573793`*^9}, {3.6165055076675005`*^9, 
   3.616505535647539*^9}},
 CellLabel->
  "In[353]:=",ExpressionUUID->"ba16ed4f-1e42-405e-bceb-6a2150713db4"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. SymManipulator", "Section",
 CellChangeTimes->{{3.5450150224250093`*^9, 3.5450150283062196`*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"0ecfef3e-3925-45d6-b79f-a1c01de56073"],

Cell[CellGroupData[{

Cell["4.1. Tex for SymH and CovarD", "Subsection",ExpressionUUID->"3b36fc65-7f7c-41ac-904d-dc84f36233b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"xAct`SymManipulator`SymH", "[", 
      RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "?", 
     "xTensorQ"}], "[", "inds___", "]"}], "]"}], ":=", 
  RowBox[{"TexSymH", "[", 
   RowBox[{
    RowBox[{"xAct`SymManipulator`SymH", "[", 
     RowBox[{"headlist", ",", "sym", ",", "label"}], "]"}], "[", "inds", 
    "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.511599597135436*^9, 3.511599619022236*^9}, {
   3.5446721379221973`*^9, 3.5446721417574177`*^9}, 3.544947656489681*^9, {
   3.545015129643997*^9, 3.545015158831649*^9}},
 CellLabel->
  "In[354]:=",ExpressionUUID->"2ff84bf6-cf61-4ed1-b67a-075cfd980fca"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"xAct`SymManipulator`CovarD", "[", 
     RowBox[{
      RowBox[{"D1_", "?", "CovDQ"}], ",", 
      RowBox[{"T_", "?", "xTensorQ"}], ",", "list_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"Last", "@", 
       RowBox[{"SymbolOfCovD", "[", "D1", "]"}]}], "]"}], ",", 
     RowBox[{"Tex", "[", "T", "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5160825913697968`*^9, 3.516082637225419*^9}, 
   3.5449476584396844`*^9, 3.544949066577158*^9, 3.5449491358880787`*^9, {
   3.545015164697259*^9, 3.5450151839008927`*^9}, 3.545015926524597*^9},
 CellLabel->
  "In[355]:=",ExpressionUUID->"369ff1f9-3994-4c65-aaa1-e32fb49cb95f"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.2. TexSymH", "Subsection",ExpressionUUID->"0864d58f-4ccf-46fb-b738-810bdec0e64d"],

Cell["\<\
This is a new code that can handle all cases that are possible to write in a \
nice way. The symmetries that are accepted are disjoint unions of symmetric \
and antisymmetric groups. The indices belonging to one such disjoint subgroup \
have to be all up or all down. If two disjoint subgroups are both acting on \
up or down indices, they have to act on disjoint ranges of indices. If any of \
these criteria fails, messages are printed, and the output is similar to the \
display form. \
\>", "Text",
 CellChangeTimes->{{3.545110811684252*^9, 3.545110856643531*^9}, {
  3.5451108948479986`*^9, 3.545111079318322*^9}, {3.545111127616007*^9, 
  3.5451112038533406`*^9}, {3.5451112426662097`*^9, 
  3.545111294770301*^9}},ExpressionUUID->"dc562e28-2586-4a41-b105-\
cbf14acec1d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexGroupSymbols", "[", 
    RowBox[{"points_", ",", "sym_"}], "]"}], ":=", 
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{"xAct`SymManipulator`SubgroupQ", "[", 
      RowBox[{
       RowBox[{"Symmetric", "[", "points", "]"}], ",", "sym"}], "]"}], ",", 
     RowBox[{"(*", " ", "Symmetric", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<(\>\"", ",", "\"\<)\>\""}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"xAct`SymManipulator`SubgroupQ", "[", 
      RowBox[{
       RowBox[{"Antisymmetric", "[", "points", "]"}], ",", "sym"}], "]"}], 
     ",", 
     RowBox[{"(*", " ", "Antisymmetric", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<[\>\"", ",", "\"\<]\>\""}], "}"}], ",", 
     "\[IndentingNewLine]", "True", ",", 
     RowBox[{"(*", " ", 
      RowBox[{"Everything", " ", "else"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<Unkown\>\"", ",", "\"\<Unkown\>\""}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.545065641562063*^9, 3.5450657173469973`*^9}, {
  3.5450728757790265`*^9, 3.545072878477831*^9}, {3.545108184021636*^9, 
  3.545108255376161*^9}},
 CellLabel->
  "In[356]:=",ExpressionUUID->"eb6a1b8e-5dd6-4399-a5a6-95bd2db2659d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexSymH", "[", 
   RowBox[{"x", ":", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"xAct`SymManipulator`SymH", "[", 
       RowBox[{"headlist_", ",", "sym_", ",", "label_"}], "]"}], "[", 
      "inds___", "]"}], ")"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"texfail", "=", "False"}], ",", 
      RowBox[{"n", "=", 
       RowBox[{"Length", "@", 
        RowBox[{"List", "[", "inds", "]"}]}]}], ",", 
      RowBox[{"indlist", "=", 
       RowBox[{"List", "@", "inds"}]}], ",", "longorbits", ",", 
      "orbitgroupsymbols", ",", "orbitondowninds", ",", "orbitonupinds", ",", 
      "downsymorbits", ",", "upsymorbits", ",", "excludesymdowninds", ",", 
      "splitdowninds", ",", "splitupinds", ",", "downorbitranges", ",", 
      "uporbitranges", ",", "excludesymupinds", ",", "downindexslots", ",", 
      "beginsym", ",", "endsym", ",", "beginexclude", ",", "endexclude", ",", 
      "preindexsymbolrules", ",", "postindexsymbolrules"}], "}"}], ",", 
    RowBox[{
     RowBox[{"longorbits", "=", 
      RowBox[{"Sort", "/@", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"Orbits", "[", 
          RowBox[{"sym", ",", "n"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "#", "]"}], ">", "1"}], "&"}]}], "]"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"orbitgroupsymbols", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"TexGroupSymbols", "[", 
         RowBox[{"#", ",", "sym"}], "]"}], "&"}], "/@", "longorbits"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", 
         RowBox[{"Select", "[", 
          RowBox[{"orbitgroupsymbols", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"First", "[", "#", "]"}], "===", "\"\<Unkown\>\""}], 
            "&"}]}], "]"}]}], ">", "0"}], ",", 
       RowBox[{
        RowBox[{"texfail", "=", "True"}], ";", "\[IndentingNewLine]", 
        RowBox[{
        "Print", "[", 
         "\"\<Not a disjoint union of symmetric and antisymmetric \
groups.\>\"", "]"}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"downindexslots", "=", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{"1", ",", 
          RowBox[{"Length", "@", "indlist"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{"DownIndexQ", "[", 
          RowBox[{"indlist", "[", 
           RowBox[{"[", "#", "]"}], "]"}], "]"}], "&"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"orbitondowninds", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"xAct`SymManipulator`Private`subsetQ", "[", 
         RowBox[{"#", ",", "downindexslots"}], "]"}], "&"}], "/@", 
       "longorbits"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"orbitonupinds", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"Intersection", "[", 
           RowBox[{"#", ",", "downindexslots"}], "]"}], "]"}], "\[Equal]", 
         "0"}], "&"}], "/@", "longorbits"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{"And", "@@", 
         RowBox[{"MapThread", "[", 
          RowBox[{"Or", ",", 
           RowBox[{"{", 
            RowBox[{"orbitondowninds", ",", "orbitonupinds"}], "}"}]}], 
          "]"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{"texfail", "=", "True"}], ";", "\[IndentingNewLine]", 
        RowBox[{
        "Print", "[", "\"\<Not all indices are in good positions.\>\"", 
         "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"downsymorbits", "=", 
      RowBox[{"Pick", "[", 
       RowBox[{"longorbits", ",", "orbitondowninds"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"upsymorbits", "=", 
      RowBox[{"Pick", "[", 
       RowBox[{"longorbits", ",", "orbitonupinds"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Not", "@", 
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{"OrderedQ", "[", 
           RowBox[{"Join", "@@", "downsymorbits"}], "]"}], ",", 
          RowBox[{"OrderedQ", "[", 
           RowBox[{"Join", "@@", "upsymorbits"}], "]"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"texfail", "=", "True"}], ";", "\[IndentingNewLine]", 
        RowBox[{
        "Print", "[", "\"\<The symmetries are overlapping.\>\"", "]"}]}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"downorbitranges", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Intersection", "[", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"First", "@", "#"}], ",", 
            RowBox[{"Last", "@", "#"}]}], "]"}], ",", "downindexslots"}], 
         "]"}], "&"}], "/@", "downsymorbits"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"uporbitranges", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Intersection", "[", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"First", "@", "#"}], ",", 
            RowBox[{"Last", "@", "#"}]}], "]"}], ",", 
          RowBox[{"Complement", "[", 
           RowBox[{
            RowBox[{"Range", "@", "n"}], ",", "downindexslots"}], "]"}]}], 
         "]"}], "&"}], "/@", "upsymorbits"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"splitdowninds", "=", 
      RowBox[{"Sequence", "@@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"SplitBy", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"downorbitranges", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Evaluate", "[", 
               RowBox[{"downsymorbits", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "#"}], "]"}], 
            "&"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", "downsymorbits"}]}], "}"}]}], "]"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"splitupinds", "=", 
      RowBox[{"Sequence", "@@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"SplitBy", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"uporbitranges", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Evaluate", "[", 
               RowBox[{"upsymorbits", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "#"}], "]"}], 
            "&"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "@", "upsymorbits"}]}], "}"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"excludesymdowninds", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"splitdowninds", ",", 
        RowBox[{
         RowBox[{"Not", "@", 
          RowBox[{"IntersectingQ", "[", 
           RowBox[{
            RowBox[{"Sequence", "@@@", "downsymorbits"}], ",", "#"}], "]"}]}],
          "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"excludesymupinds", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"splitupinds", ",", 
        RowBox[{
         RowBox[{"Not", "@", 
          RowBox[{"IntersectingQ", "[", 
           RowBox[{
            RowBox[{"Sequence", "@@@", "upsymorbits"}], ",", "#"}], "]"}]}], 
         "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"beginsym", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"First", "/@", "downsymorbits"}], ",", 
        RowBox[{"First", "/@", "upsymorbits"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"endsym", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Last", "/@", "downsymorbits"}], ",", 
        RowBox[{"Last", "/@", "upsymorbits"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"beginexclude", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"First", "/@", 
         RowBox[{"Select", "[", 
          RowBox[{"excludesymdowninds", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Length", "@", "#"}], ">", "0"}], ")"}], "&"}]}], 
          "]"}]}], ",", 
        RowBox[{"First", "/@", 
         RowBox[{"Select", "[", 
          RowBox[{"excludesymupinds", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Length", "@", "#"}], ">", "0"}], ")"}], "&"}]}], 
          "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"endexclude", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Last", "/@", 
         RowBox[{"Select", "[", 
          RowBox[{"excludesymdowninds", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Length", "@", "#"}], ">", "0"}], ")"}], "&"}]}], 
          "]"}]}], ",", 
        RowBox[{"Last", "/@", 
         RowBox[{"Select", "[", 
          RowBox[{"excludesymupinds", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Length", "@", "#"}], ">", "0"}], ")"}], "&"}]}], 
          "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"preindexsymbolrules", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Rule", "[", 
         RowBox[{"#", ",", 
          RowBox[{"orbitgroupsymbols", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "@", 
              RowBox[{"First", "@", 
               RowBox[{"Position", "[", 
                RowBox[{"longorbits", ",", "#", ",", "2", ",", "1"}], 
                "]"}]}]}], ",", "1"}], "]"}], "]"}]}], "]"}], "&"}], "/@", 
       "beginsym"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"postindexsymbolrules", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Rule", "[", 
         RowBox[{"#", ",", 
          RowBox[{"orbitgroupsymbols", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "@", 
              RowBox[{"First", "@", 
               RowBox[{"Position", "[", 
                RowBox[{"longorbits", ",", "#", ",", "2", ",", "1"}], 
                "]"}]}]}], ",", "2"}], "]"}], "]"}]}], "]"}], "&"}], "/@", 
       "endsym"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"preindexsymbolrules", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"preindexsymbolrules", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Rule", "[", 
           RowBox[{"#", ",", "\"\<|\>\""}], "]"}], "&"}], "/@", 
         "beginexclude"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"postindexsymbolrules", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"postindexsymbolrules", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Rule", "[", 
           RowBox[{"#", ",", "\"\<|\>\""}], "]"}], "&"}], "/@", 
         "endexclude"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"preindexsymbolrules", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Rule", "[", 
         RowBox[{"#", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#", "/.", "preindexsymbolrules"}], ")"}], "/.", 
           RowBox[{"Rule", "[", 
            RowBox[{"#", ",", "\"\<\>\""}], "]"}]}]}], "]"}], "&"}], "/@", 
       RowBox[{"Range", "[", "n", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"postindexsymbolrules", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Rule", "[", 
         RowBox[{"#", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#", "/.", "postindexsymbolrules"}], ")"}], "/.", 
           RowBox[{"Rule", "[", 
            RowBox[{"#", ",", "\"\<\>\""}], "]"}]}]}], "]"}], "&"}], "/@", 
       RowBox[{"Range", "[", "n", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"texfail", ",", 
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<Could not typset the SymH object nicely.\>\"", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
         "\"\<\\\\underset{\>\"", ",", "label", ",", "\"\<}{Sym}(\>\"", ",", 
          RowBox[{"TexPrint", "@", 
           RowBox[{"xAct`SymManipulator`RemoveSym", "@", "x"}]}], ",", 
          "\"\<)\>\""}], "]"}]}], ",", 
       RowBox[{"TexKnownSymH", "[", 
        RowBox[{
        "headlist", ",", "n", ",", "indlist", ",", "preindexsymbolrules", ",",
          "postindexsymbolrules"}], "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5450651934356747`*^9, 3.5450652115785074`*^9}, {
   3.545065288876643*^9, 3.545065305085071*^9}, {3.545065442256113*^9, 
   3.545065443145314*^9}, {3.54506547492257*^9, 3.545065490428997*^9}, {
   3.5450656072264028`*^9, 3.545065626398836*^9}, {3.545065732042221*^9, 
   3.545065745380245*^9}, {3.545065776736301*^9, 3.545065894407307*^9}, {
   3.545066040361163*^9, 3.5450661377521343`*^9}, {3.545066516794286*^9, 
   3.5450665343443165`*^9}, {3.545066668480598*^9, 3.545066685578228*^9}, {
   3.5450671261509275`*^9, 3.545067294132023*^9}, {3.545067354847329*^9, 
   3.5450674561539073`*^9}, {3.545067618097792*^9, 3.54506769144912*^9}, {
   3.545067882487056*^9, 3.545068098158435*^9}, {3.545068181462581*^9, 
   3.5450681835061836`*^9}, {3.5450682713499393`*^9, 
   3.5450682790251527`*^9}, {3.545068322252828*^9, 3.5450683956353574`*^9}, {
   3.545068453480259*^9, 3.545068468783886*^9}, {3.5450687045938993`*^9, 
   3.54506872183193*^9}, {3.5450687614872*^9, 3.545068787554846*^9}, {
   3.5450688792674065`*^9, 3.5450688926834307`*^9}, {3.545068928891094*^9, 
   3.5450689894816*^9}, {3.545069029636071*^9, 3.545069047716503*^9}, {
   3.5450690916149797`*^9, 3.545069126403041*^9}, {3.545069711015068*^9, 
   3.545069745179128*^9}, {3.545069822258863*^9, 3.545069851306114*^9}, {
   3.5450700025795803`*^9, 3.545070205114735*^9}, {3.545070379195441*^9, 
   3.5450704071818905`*^9}, {3.545070638031096*^9, 3.545070703598011*^9}, 
   3.545070845964861*^9, {3.54507088493373*^9, 3.545070939393425*^9}, {
   3.545070988673912*^9, 3.5450710955340996`*^9}, {3.5450712856048336`*^9, 
   3.5450714319486904`*^9}, {3.545071526968457*^9, 3.545071605171395*^9}, {
   3.545071635263847*^9, 3.545071635981449*^9}, {3.5450717176475935`*^9, 
   3.545071720159197*^9}, {3.545071913271936*^9, 3.545071951523203*^9}, {
   3.54507249047395*^9, 3.545072495216358*^9}, {3.545072649469429*^9, 
   3.545072703164723*^9}, {3.545072741899592*^9, 3.545072751384408*^9}, {
   3.545106624579497*^9, 3.545107008246571*^9}, {3.545107060506663*^9, 
   3.545107089787915*^9}, {3.5451072151819353`*^9, 3.545107217553139*^9}, {
   3.545107276770843*^9, 3.545107280468049*^9}, {3.5451075095388513`*^9, 
   3.545107509913252*^9}, 3.545107817374192*^9, {3.545107853893856*^9, 
   3.545107925045581*^9}, {3.545108164209601*^9, 3.5451081809796305`*^9}, {
   3.5451082669201813`*^9, 3.545108359662345*^9}, 3.5451083990212135`*^9, {
   3.5451084967875853`*^9, 3.545108574553722*^9}, {3.545108625846612*^9, 
   3.545108627999416*^9}, {3.545108679120705*^9, 3.5451087744992733`*^9}, {
   3.5451088554946156`*^9, 3.5451088715782433`*^9}, {3.545109087482623*^9, 
   3.545109206978833*^9}, 3.545110335002214*^9, {3.54511044654241*^9, 
   3.545110449210015*^9}, {3.6151291771285443`*^9, 3.6151291774585447`*^9}, 
   3.615129585339116*^9, {3.640592971100967*^9, 3.640593024161041*^9}},
 CellLabel->
  "In[357]:=",ExpressionUUID->"831f57a0-c756-44f2-b2f0-a61359382151"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexKnownSymH", "[", 
   RowBox[{
   "headlist_", ",", "n_", ",", " ", "indlist_", ",", "preindexsymbolrules_", 
    ",", " ", "postindexsymbolrules_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"numindices", "=", 
       RowBox[{"Length", "/@", 
        RowBox[{"SlotsOfTensor", "/@", "headlist"}]}]}], ",", 
      "partitionedslots", ",", "internalexpr", ",", " ", "indicesoftensor", 
      ",", " ", 
      RowBox[{"texstring", "=", "\"\<\>\""}], ",", "  ", 
      RowBox[{"texstringtensor", "=", "\"\<\>\""}], ",", " ", 
      RowBox[{"i", "=", "1"}], ",", " ", "CovarDs", ",", " ", 
      RowBox[{"newheadlist", "=", "headlist"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"CovarDs", "=", 
      RowBox[{"First", "/@", 
       RowBox[{"Position", "[", 
        RowBox[{"newheadlist", ",", "xAct`SymManipulator`CovarD", ",", "2"}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", "CovarDs"}], ">", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"numindices", "=", 
         RowBox[{"ReplacePart", "[", 
          RowBox[{"numindices", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"#", "\[Rule]", 
               RowBox[{"Sequence", "[", 
                RowBox[{
                 RowBox[{"Length", "@", 
                  RowBox[{"newheadlist", "[", 
                   RowBox[{"[", 
                    RowBox[{"#", ",", "3"}], "]"}], "]"}]}], ",", 
                 RowBox[{
                  RowBox[{"numindices", "[", 
                   RowBox[{"[", "#", "]"}], "]"}], "-", 
                  RowBox[{"Length", "@", 
                   RowBox[{"newheadlist", "[", 
                    RowBox[{"[", 
                    RowBox[{"#", ",", "3"}], "]"}], "]"}]}]}]}], "]"}]}], 
              ")"}], "&"}], "/@", "CovarDs"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"newheadlist", "=", 
         RowBox[{"ReplacePart", "[", 
          RowBox[{"newheadlist", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"#", "\[Rule]", 
               RowBox[{"Sequence", "[", 
                RowBox[{
                 RowBox[{"Last", "@", 
                  RowBox[{"SymbolOfCovD", "@", 
                   RowBox[{"newheadlist", "[", 
                    RowBox[{"[", 
                    RowBox[{"#", ",", "1"}], "]"}], "]"}]}]}], ",", 
                 RowBox[{"newheadlist", "[", 
                  RowBox[{"[", 
                   RowBox[{"#", ",", "2"}], "]"}], "]"}]}], "]"}]}], ")"}], 
             "&"}], "/@", "CovarDs"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"CovarDs", "=", 
         RowBox[{"First", "/@", 
          RowBox[{"Position", "[", 
           RowBox[{
           "newheadlist", ",", "xAct`SymManipulator`CovarD", ",", "2"}], 
           "]"}]}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Extract", " ", "indices", " ", "belonging", " ", "to", " ", "the", " ",
        "different", " ", 
       RowBox[{"tensors", ".", " ", "Can"}], " ", "this", " ", "be", " ", 
       "done", " ", "in", " ", "a", " ", "simpler", " ", 
       RowBox[{"way", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"partitionedslots", "=", 
      RowBox[{"Last", "/@", 
       RowBox[{"Rest", "@", 
        RowBox[{"FoldList", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Drop", "[", 
              RowBox[{
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}], ",", 
             RowBox[{"Take", "[", 
              RowBox[{
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}]}], "}"}], 
           "&"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Range", "[", "n", "]"}], ",", 
            RowBox[{"{", "}"}]}], "}"}], ",", "numindices"}], "]"}]}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"indicesoftensor", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"indlist", "[", 
         RowBox[{"[", "#", "]"}], "]"}], "&"}], "/@", "partitionedslots"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"Length", "@", "newheadlist"}]}], ",", "\[IndentingNewLine]", 
       
       RowBox[{
        RowBox[{"texstringtensor", "=", " ", 
         RowBox[{"TexTensorWithSym", "[", 
          RowBox[{
           RowBox[{"newheadlist", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"indicesoftensor", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"partitionedslots", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", ",", "preindexsymbolrules", 
           ",", " ", "postindexsymbolrules"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"texstring", "=", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"texstring", ",", "texstringtensor"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"i", "=", 
         RowBox[{"i", "+", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     "texstring"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.545106618542286*^9, 3.5451066187138863`*^9}, {
   3.545107332681341*^9, 3.545107380043024*^9}, 3.545107426546705*^9, {
   3.545107520833271*^9, 3.545107613076233*^9}, {3.545108364747954*^9, 
   3.5451083699739623`*^9}, {3.545109264901735*^9, 3.545109299315395*^9}, 
   3.545109504970557*^9, {3.5451104526732206`*^9, 3.545110467352846*^9}},
 CellLabel->
  "In[358]:=",ExpressionUUID->"c84bfc37-09f4-4daa-aeca-4a0c6b02f540"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexTensorWithSym", "[", 
   RowBox[{
   "head_", ",", "inds_", ",", "slots_", ",", "preindexsymbolrules_", ",", 
    " ", "postindexsymbolrules_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"texstring", "=", 
       RowBox[{"Tex", "@", "head"}]}], ",", " ", 
      RowBox[{"i", "=", "1"}], ",", " ", "fromdown", ",", 
      RowBox[{"postindexsymbol", "=", "\"\<\>\""}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"Length", "[", "inds", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"texstring", "=", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"texstring", ",", 
           RowBox[{"TexSymIndex", "[", 
            RowBox[{
             RowBox[{"inds", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"i", "\[Equal]", "1"}], ",", "fromdown", ",", 
             RowBox[{
              RowBox[{"slots", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "/.", 
              "preindexsymbolrules"}]}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"fromdown", "=", 
         RowBox[{"DownIndexQ", "[", 
          RowBox[{"inds", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"postindexsymbol", "=", 
         RowBox[{
          RowBox[{"slots", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/.", "postindexsymbolrules"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"texstring", "=", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"texstring", ",", "postindexsymbol"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"i", "=", 
         RowBox[{"i", "+", "1"}]}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", "inds"}], ">", "0"}], ",", " ", 
       RowBox[{"texstring", "=", 
        RowBox[{"StringJoin", "[", 
         RowBox[{"texstring", ",", "\"\<}\>\""}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", "texstring"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5451095741566772`*^9, 3.545109627508771*^9}, {
   3.545109710438517*^9, 3.545109724150941*^9}, 3.545109841931148*^9, {
   3.5451098829602203`*^9, 3.545109886782227*^9}, {3.5451099471075335`*^9, 
   3.5451100710029516`*^9}, {3.545110470730053*^9, 3.545110482773274*^9}},
 CellLabel->
  "In[359]:=",ExpressionUUID->"a79f595c-d32d-44f9-b2fd-a51140fe9593"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexSymIndex", "[", 
   RowBox[{
   "index_", ",", "firstindexQ_", ",", "fromdownQ_", ",", "preindexsymbol_"}],
    "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "indexstring", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"indexstring", "=", 
      RowBox[{"Which", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"firstindexQ", "&&", 
         RowBox[{"DownIndexQ", "[", "index", "]"}], "&&", 
         RowBox[{"Not", "[", "$TexPrintInitialBracesQ", "]"}]}], ",", 
        "\"\<_{\>\"", ",", "\[IndentingNewLine]", 
        RowBox[{"firstindexQ", "&&", 
         RowBox[{"DownIndexQ", "[", "index", "]"}], "&&", 
         "$TexPrintInitialBracesQ"}], ",", "\"\<{}_{\>\"", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"firstindexQ", "&&", 
         RowBox[{"Not", "[", "$TexPrintInitialBracesQ", "]"}]}], ",", 
        "\"\<^{\>\"", ",", "\[IndentingNewLine]", 
        RowBox[{"firstindexQ", "&&", "$TexPrintInitialBracesQ"}], ",", 
        "\"\<{}^{\>\"", ",", "\[IndentingNewLine]", 
        RowBox[{"fromdownQ", "&&", 
         RowBox[{"DownIndexQ", "[", "index", "]"}]}], ",", "\"\<\>\"", ",", 
        "\[IndentingNewLine]", "fromdownQ", ",", "\"\<}{}^{\>\"", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"DownIndexQ", "[", "index", "]"}], ",", "\"\<}{}_{\>\"", ",", 
        "\[IndentingNewLine]", "True", ",", "\"\<\>\""}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"indexstring", ",", "preindexsymbol", ",", 
       RowBox[{"TexUpIndex", "[", 
        RowBox[{"UpIndex", " ", "@", "index"}], "]"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.511582382228205*^9, 3.5115823970638046`*^9}, {
   3.511582758734205*^9, 3.511582853036205*^9}, 3.511582920069405*^9, {
   3.5115829515502057`*^9, 3.511583079189405*^9}, {3.5115832595456057`*^9, 
   3.511583299356806*^9}, {3.5115833884796057`*^9, 3.511583452548805*^9}, {
   3.5115834884132047`*^9, 3.5115837453452053`*^9}, {3.511583789196806*^9, 
   3.511583805249205*^9}, {3.5115838378064055`*^9, 3.511583941998805*^9}, {
   3.511583995210405*^9, 3.511584020217205*^9}, {3.5115842219876056`*^9, 
   3.5115842652308054`*^9}, {3.5115872711526055`*^9, 
   3.5115872738826056`*^9}, {3.511588381794605*^9, 3.511588404040206*^9}, {
   3.511594716331606*^9, 3.5115947536000056`*^9}, {3.5121019416140003`*^9, 
   3.5121020010968*^9}, {3.544949169693339*^9, 3.544949175168948*^9}, 
   3.5449504778034368`*^9, {3.544951562774544*^9, 3.544951565145748*^9}, {
   3.545015319964331*^9, 3.5450153479195805`*^9}},
 CellLabel->
  "In[360]:=",ExpressionUUID->"35ff1138-6882-4b2c-85c0-1f4c56e86d93"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5. xTerior", "Section",
 CellChangeTimes->{{3.5450150224250093`*^9, 3.5450150283062196`*^9}, 
   3.61908490820138*^9, {3.61908519325185*^9, 3.619085196821855*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"9a8428fe-356a-40a2-97ae-550cc6b3c1d9"],

Cell[CellGroupData[{

Cell["5.1. Tex for the structures in xTerior", "Subsection",
 CellChangeTimes->{
  3.61908519985186*^9, {3.6190852364659595`*^9, 
   3.619085245815973*^9}},ExpressionUUID->"380127a2-c8c1-49c3-b899-\
71410cee71f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Wedge", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TexOperator", "[", "Wedge", "]"}], ":=", 
     "\"\< \\\\wedge \>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", "expr_Wedge", "]"}], ":=", 
     RowBox[{"StringJoin", "@@", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"TexFactor", "/@", 
         RowBox[{"List", "@@", "expr"}]}], ",", 
        RowBox[{"TexOperator", "[", "Wedge", "]"}]}], "]"}]}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.616504204669483*^9, 3.616504241979536*^9}, {
  3.616505060588778*^9, 3.6165050651887836`*^9}, {3.6190853996861873`*^9, 
  3.61908543028623*^9}},
 CellLabel->
  "In[361]:=",ExpressionUUID->"ac9c839f-5380-48b8-a1e5-fb9ca9b4ba83"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Exterior", " ", "derivative"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TexOperator", "[", "xAct`xTerior`Diff", "]"}], ":=", 
     "\"\< d \>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"HoldPattern", "[", 
       RowBox[{"xAct`xTerior`Diff", "[", 
        RowBox[{
         RowBox[{"expr_Wedge", "|", "expr_Plus", "|", "expr_Times"}], ",", 
         "covd___"}], "]"}], "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOperator", "[", "xAct`xTerior`Diff", "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"covd", "===", "PD"}], ",", "\"\<\>\"", ",", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"\"\<^{\>\"", ",", 
           RowBox[{"Tex", "[", 
            RowBox[{
             RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\"\<}\>\""}], 
          "]"}]}], "]"}], ",", 
       RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
       RowBox[{"Tex", "[", "expr", "]"}], ",", 
       RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"HoldPattern", "[", 
       RowBox[{"xAct`xTerior`Diff", "[", 
        RowBox[{"expr_", ",", "covd___"}], "]"}], "]"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"TexOperator", "[", "xAct`xTerior`Diff", "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"covd", "===", "PD"}], ",", "\"\<\>\"", ",", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"\"\<^{\>\"", ",", 
           RowBox[{"Tex", "[", 
            RowBox[{
             RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\"\<}\>\""}], 
          "]"}]}], "]"}], ",", 
       RowBox[{"Tex", "[", "expr", "]"}]}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.619086500403921*^9, 3.619086525503957*^9}, 
   3.6190868000693893`*^9, {3.619086841799448*^9, 3.619086883479506*^9}, {
   3.6190869945696607`*^9, 3.6190870213296995`*^9}, 3.619087316774161*^9, {
   3.6190885228670425`*^9, 3.619088524007044*^9}, {3.619626126464985*^9, 
   3.619626186589117*^9}, {3.619626781260213*^9, 3.6196268378602924`*^9}, {
   3.619626905370387*^9, 3.6196269112303953`*^9}, {3.6196269727404814`*^9, 
   3.619627009340533*^9}},
 CellLabel->
  "In[363]:=",ExpressionUUID->"fe9f0035-6650-48bd-895b-2acf5cf2aa28"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Coframe", " ", "and", " ", "dx"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"xAct`xTerior`Coframe", "[", "man_", "]"}], "]"}], ":=", 
     "\"\<\\\\theta\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"xAct`xTerior`dx", "[", "man_", "]"}], "]"}], ":=", 
     "\"\<dx\>\""}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.619087320064165*^9, 3.619087345478249*^9}, {
  3.619087459418409*^9, 3.6190875205584946`*^9}},
 CellLabel->
  "In[366]:=",ExpressionUUID->"a6825211-ee25-46fe-b3dc-a7c4694d3ece"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"xAct`xTerior`Hodge", "[", "met_", "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<{*}_{\>\"", ",", 
     RowBox[{"Tex", "[", "met", "]"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{
     RowBox[{"xAct`xTerior`Hodge", "[", "met_", "]"}], "[", 
     RowBox[{"expr_Wedge", "|", "expr_Plus", "|", "expr_Times"}], "]"}], 
    "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"xAct`xTerior`Hodge", "[", "met", "]"}], "]"}], ",", 
     RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
     RowBox[{"Tex", "[", "expr", "]"}], ",", 
     RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{
     RowBox[{"xAct`xTerior`Hodge", "[", "met_", "]"}], "[", "expr_", "]"}], 
    "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"xAct`xTerior`Hodge", "[", "met", "]"}], "]"}], ",", 
     RowBox[{"Tex", "[", "expr", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"xAct`xTerior`Codiff", "[", "met_", "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\delta_{\>\"", ",", 
     RowBox[{"Tex", "[", "met", "]"}], ",", "\"\<}\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{
     RowBox[{"xAct`xTerior`Codiff", "[", "met_", "]"}], "[", 
     RowBox[{"expr_Wedge", "|", "expr_Plus", "|", "expr_Times"}], "]"}], 
    "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"xAct`xTerior`Codiff", "[", "met", "]"}], "]"}], ",", 
     RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
     RowBox[{"Tex", "[", "expr", "]"}], ",", 
     RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{
     RowBox[{"xAct`xTerior`Codiff", "[", "met_", "]"}], "[", "expr_", "]"}], 
    "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
     RowBox[{"Tex", "[", 
      RowBox[{"xAct`xTerior`Codiff", "[", "met", "]"}], "]"}], ",", 
     RowBox[{"Tex", "[", "expr", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{
     RowBox[{"xAct`xTerior`CartanD", "[", 
      RowBox[{
       RowBox[{"v_", "?", "xTensorQ"}], "[", "a_", "]"}], "]"}], "[", 
     RowBox[{
      RowBox[{"expr_Wedge", "|", "expr_Plus", "|", "expr_Times"}], ",", 
      "covd_"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\mathcal{L}\>\"", ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", 
           RowBox[{"{", "covd", "}"}]}], "\[Equal]", "0"}], ",", 
         RowBox[{"covd", "===", "xAct`xTensor`PD"}]}], "]"}], ",", "\"\<\>\"",
        ",", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<^{\>\"", ",", 
         RowBox[{"Tex", "@", 
          RowBox[{"Last", "@", 
           RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}]}], ",", 
         "\"\<}{}\>\""}], "]"}]}], "]"}], ",", "\"\<_{\>\"", ",", 
     RowBox[{"Tex", "[", "v", "]"}], ",", "\"\<}\>\"", ",", 
     RowBox[{"TexOpen", "[", "\"\<(\>\"", "]"}], ",", 
     RowBox[{"Tex", "[", "expr", "]"}], ",", 
     RowBox[{"TexClose", "[", "\"\<)\>\"", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{
     RowBox[{"xAct`xTerior`CartanD", "[", 
      RowBox[{
       RowBox[{"v_", "?", "xTensorQ"}], "[", "a_", "]"}], "]"}], "[", 
     RowBox[{"expr_", ",", "covd___"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\mathcal{L}\>\"", ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", 
           RowBox[{"{", "covd", "}"}]}], "\[Equal]", "0"}], ",", 
         RowBox[{"covd", "===", "xAct`xTensor`PD"}]}], "]"}], ",", "\"\<\>\"",
        ",", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<^{\>\"", ",", 
         RowBox[{"Tex", "@", 
          RowBox[{"Last", "@", 
           RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}]}], ",", 
         "\"\<}{}\>\""}], "]"}]}], "]"}], ",", "\"\<_{\>\"", ",", 
     RowBox[{"Tex", "[", "v", "]"}], ",", "\"\<}\>\"", ",", 
     RowBox[{"Tex", "[", "expr", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{
      RowBox[{"xAct`xTerior`Int", "[", 
       RowBox[{
        RowBox[{"v_", "?", "xTensorQ"}], "[", "a_", "]"}], "]"}], "[", 
      "expr_", "]"}], "]"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\\\iota_{\>\"", ",", 
     RowBox[{"Tex", "[", "v", "]"}], ",", "\"\<}\>\"", ",", 
     RowBox[{"Tex", "[", "expr", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"form", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
        "xAct`xTerior`ChristoffelForm", "|", "xAct`xTerior`ConnectionForm", 
         "|", "xAct`xTerior`RiemannForm", "|", "xAct`xTerior`CurvatureForm", 
         "|", "xAct`xTerior`TorsionForm"}], ")"}], "[", 
       RowBox[{"covd_", ",", "vb___"}], "]"}]}], "]"}], "]"}], ":=", 
   RowBox[{"Tex", "@", 
    RowBox[{"PrintAs", "@", "form"}]}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.619087910233088*^9, 3.6190879910582485`*^9}, {
   3.619088043698323*^9, 3.61908810550841*^9}, {3.619088208078554*^9, 
   3.619088221208572*^9}, {3.619088387636853*^9, 3.619088448486939*^9}, {
   3.619088534881107*^9, 3.6190885491311274`*^9}, {3.61962582570852*^9, 
   3.619625860694613*^9}, {3.619625906234677*^9, 3.619626075764914*^9}, {
   3.619626452575705*^9, 3.619626454055707*^9}, {3.619627358469118*^9, 
   3.619627400499177*^9}, {3.619627446249241*^9, 3.619627484469294*^9}, 
   3.619627526469353*^9, {3.619627558259398*^9, 3.61962760280046*^9}, {
   3.619627707374655*^9, 3.6196278023157873`*^9}, {3.619627999620112*^9, 
   3.619628009610126*^9}, {3.6196282626845284`*^9, 3.61962832829462*^9}, 
   3.619629504994461*^9, {3.619629735354783*^9, 3.619629743714795*^9}, {
   3.6196297824688973`*^9, 3.619629789628907*^9}, {3.619629844548984*^9, 
   3.619629911699078*^9}, {3.619630059453333*^9, 3.6196300705833488`*^9}, {
   3.620540927590987*^9, 3.620540944251011*^9}, {3.620541180365389*^9, 
   3.620541205365424*^9}, {3.620541255826495*^9, 3.62054136081069*^9}, {
   3.620541613791044*^9, 3.620541665195165*^9}, {3.620541915875516*^9, 
   3.620541937519594*^9}, {3.620541974739646*^9, 3.620542069879779*^9}},
 CellLabel->
  "In[368]:=",ExpressionUUID->"29de0b5e-79a1-4688-bf37-6a03e23194a0"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6. TexBreak", "Section",
 CellChangeTimes->{3.545015046527052*^9, 3.6190852024718637`*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"f9e1ffe1-b04a-4846-bc74-a884a6711de2"],

Cell[CellGroupData[{

Cell["6.1. TexBreak function", "Subsection",
 CellChangeTimes->{
  3.619085204661866*^9},ExpressionUUID->"b17aac68-8a64-4a5b-8a0f-\
1d350d75b43e"],

Cell["\<\
We need the internal function PartitionRagged. For old versions of \
Mathematica, we need to supply an implementation.\
\>", "Text",
 CellChangeTimes->{{3.727410552715109*^9, 
  3.727410560170476*^9}},ExpressionUUID->"fcd66f28-69e4-4b14-a530-\
7c2a438a50b8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"oldPartitionRagged", "[", 
    RowBox[{"l_", ",", "p_"}], "]"}], ":=", 
   RowBox[{"Last", "/@", 
    RowBox[{"Rest", "@", 
     RowBox[{"FoldList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Drop", "[", 
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}], ",", 
          RowBox[{"Take", "[", 
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "#2"}], "]"}]}], "}"}], 
        "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", "p"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"System`$VersionNumber", "<", "8."}], ",", 
    RowBox[{"partitionRagged", "=", "oldPartitionRagged"}], ",", 
    RowBox[{"partitionRagged", "=", "Internal`PartitionRagged"}]}], "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.727410556466342*^9},
 CellLabel->
  "In[377]:=",ExpressionUUID->"01a699ef-d89d-4698-80d7-5652a8b555ad"],

Cell["Jose\[CloseCurlyQuote]s old code for TexBreak:", "Text",ExpressionUUID->"b5e18e40-23d4-4255-8ec2-202f208781a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexBreak", "[", 
    RowBox[{"string_String", ",", "n_Integer"}], "]"}], ":=", 
   RowBox[{"StringInsert", "[", 
    RowBox[{"string", ",", "\"\< \\\\nonumber \\\\\\\\ \\n\>\"", ",", 
     RowBox[{"Last", "/@", 
      RowBox[{"Split", "[", 
       RowBox[{
        RowBox[{"First", "/@", 
         RowBox[{"StringPosition", "[", 
          RowBox[{"string", ",", 
           RowBox[{"\"\< + \>\"", "|", "\"\< - \>\""}]}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"IntegerPart", "[", 
           RowBox[{"#1", "/", "n"}], "]"}], "===", 
          RowBox[{"IntegerPart", "[", 
           RowBox[{"#2", "/", "n"}], "]"}]}], "&"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.588328778432424*^9, 
  3.5883287990868607`*^9}},ExpressionUUID->"8b74c26b-5efb-4a25-898a-\
b815dffb2866"],

Cell["\<\
Barry\[CloseCurlyQuote]s new code with the TexBreakBy option \
\[OpenCurlyDoubleQuote]TexPoint\[CloseCurlyDoubleQuote] added by Thomas:
We need to add code that avoids breaking inside a \
\\begin{something}\\end{something} environment.\
\>", "Text",
 CellChangeTimes->{{3.9583946886445045`*^9, 
  3.9583947369841537`*^9}},ExpressionUUID->"5e8dd041-e4ed-4a52-a90f-\
a1366d3d94fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "TexBreak", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TexBreakBy", "\[Rule]", "\"\<Character\>\""}], ",", 
     RowBox[{"TexBreakAt", "\[Rule]", 
      RowBox[{"\"\< + \>\"", "|", "\"\< - \>\""}]}], ",", 
     RowBox[{
     "TexBreakString", "\[Rule]", "\"\< \\\\nonumber \\\\\\\\ \\n&&\>\""}], 
     ",", 
     RowBox[{"EquationMarks", "\[Rule]", "False"}], ",", 
     RowBox[{"TexBreakInParenthesis", "\[Rule]", "False"}], ",", 
     RowBox[{"TexBreakAvoidEnvs", "->", 
      RowBox[{"{", 
       RowBox[{
       "\"\<cases\>\"", ",", "\"\<bmatrix\>\"", ",", "\"\<pmatrix\>\"", ",", 
        "\"\<vmatrix\>\""}], "}"}]}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588078862582654*^9, 3.5880789023627243`*^9}, {
  3.715232437717578*^9, 3.715232491701953*^9}, {3.958399834040367*^9, 
  3.9583998342780685`*^9}},
 CellLabel->
  "In[379]:=",ExpressionUUID->"913da0af-5240-46db-b40b-92e6080ccc25"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BreakingFunction", "[", 
    RowBox[{"rulelist_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"best", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"rulelist", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "n"}], "&"}]}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", "best"}], "\[Equal]", "0"}], ",", 
       RowBox[{"Last", "@", 
        RowBox[{"First", "[", "rulelist", "]"}]}], ",", 
       RowBox[{"Last", "@", 
        RowBox[{"Last", "@", "best"}]}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SplittingFunction", "[", 
   RowBox[{"string_String", ",", "breakat_", ",", "breakinparenthesis_"}], 
   "]"}], ":=", 
  RowBox[{"SplittingFunction", "[", 
   RowBox[{"string", ",", "breakat", ",", "breakinparenthesis", ",", 
    RowBox[{"{", "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SplittingFunction", "[", 
    RowBox[{
    "string_String", ",", "breakat_", ",", "breakinparenthesis_", ",", 
     "avoidenvs_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "splittablePositions", ",", "splitstructure", ",", "breakdepth", ",", 
       " ", 
       RowBox[{"envstartstop", "=", 
        RowBox[{"{", "}"}]}], ",", "envinfo", ",", "splitstructureenv"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Count", " ", "the", " ", "bracket", " ", "level", " ", "and", " ", 
       "split", " ", "only", " ", "when", " ", "breakat", " ", "appears", " ",
        "at", " ", "bracket", " ", "level", " ", "0."}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "At", " ", "which", " ", "position", " ", "do", " ", "we", " ", "find", 
       " ", "breakat", " ", "or", " ", 
       RowBox[{"brackets", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"breakinparenthesis", "===", "True"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"splittablePositions", "=", 
         RowBox[{"First", "/@", 
          RowBox[{"StringPosition", "[", 
           RowBox[{"string", ",", 
            RowBox[{"breakat", "|", "\"\<{\>\"", "|", "\"\<}\>\""}]}], 
           "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"splittablePositions", "=", 
         RowBox[{"First", "/@", 
          RowBox[{"StringPosition", "[", 
           RowBox[{"string", ",", 
            RowBox[{
            "breakat", "|", "\"\<{\>\"", "|", "\"\<}\>\"", "|", "\"\<(\>\"", 
             "|", "\"\<)\>\""}]}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"splittablePositions", "=", 
       RowBox[{"Complement", "[", 
        RowBox[{"splittablePositions", ",", 
         RowBox[{"Last", "/@", 
          RowBox[{"StringPosition", "[", 
           RowBox[{"string", ",", 
            RowBox[{"\"\<\\{\>\"", "|", "\"\<\\}\>\""}]}], "]"}]}]}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Check", " ", 
         RowBox[{"the", " ", "\\", "begin"}], 
         RowBox[{"{", "env", "}"}]}], ",", " ", 
        RowBox[{
         RowBox[{"\\", "end"}], 
         RowBox[{"{", "env", "}"}], " ", "and", " ", "avoid", " ", "breaking",
          " ", "if", " ", "it", " ", "is", " ", "listed", " ", "in", " ", 
         "avoidenvs"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", "avoidenvs"}], ">", "0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"envstartstop", "=", 
         RowBox[{"StringPosition", "[", 
          RowBox[{"string", ",", 
           RowBox[{
            RowBox[{"Shortest", "[", 
             RowBox[{"\"\<\\\\begin{\>\"", "~~", "__", "~~", "\"\<}\>\""}], 
             "]"}], "|", 
            RowBox[{"Shortest", "[", 
             RowBox[{"\"\<\\\\end{\>\"", "~~", "__", "~~", "\"\<}\>\""}], 
             "]"}]}]}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"IntegerQ", "[", "breakinparenthesis", "]"}], ",", 
        RowBox[{"breakdepth", "=", "breakinparenthesis"}], ",", 
        RowBox[{"breakdepth", "=", "0"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "Construct", " ", "a", " ", "structure", " ", "of", " ", "the", " ", 
         "kind", " ", 
         RowBox[{"{", 
          RowBox[{
          "pos", ",", " ", "n", ",", " ", "m", ",", " ", "notbracketQ"}], 
          "}"}]}], ",", " ", 
        RowBox[{
        "where", " ", "pos", " ", "is", " ", "the", " ", "position", " ", 
         "of", " ", "the", " ", "character"}], ",", " ", 
        RowBox[{
        "n", " ", "is", " ", "1", " ", "for", " ", "opening", " ", 
         "brackets"}], ",", " ", 
        RowBox[{
         RowBox[{"-", "1"}], " ", "for", " ", "closing", " ", "brackets", " ",
          "and", " ", "0", " ", "for", " ", "everything", " ", 
         RowBox[{"else", ".", " ", "m"}], " ", "is", " ", "the", " ", "same", 
         " ", "thing", " ", "for", " ", 
         RowBox[{"parenthesis", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"splitstructure", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Switch", "[", 
          RowBox[{
           RowBox[{"StringTake", "[", 
            RowBox[{"string", ",", 
             RowBox[{"{", "#", "}"}]}], "]"}], ",", "\"\<{\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"#", ",", "1", ",", "0", ",", "False"}], "}"}], ",", 
           "\"\<(\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"#", ",", "0", ",", "1", ",", "False"}], "}"}], ",", 
           "\"\<}\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"#", ",", 
             RowBox[{"-", "1"}], ",", "0", ",", "False"}], "}"}], ",", 
           "\"\<)\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"#", ",", "0", ",", 
             RowBox[{"-", "1"}], ",", "False"}], "}"}], ",", "_", ",", 
           RowBox[{"{", 
            RowBox[{"#", ",", "0", ",", "0", ",", "True"}], "}"}]}], "]"}], 
         "&"}], "/@", "splittablePositions"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Extract", " ", "the", " ", "same", " ", "thing", " ", "for", " ", 
        "the", " ", "enviornments", " ", "we", " ", "want", " ", "to", " ", 
        RowBox[{"avoid", ".", " ", "Count"}], " ", "them", " ", "as", " ", 
        "a", " ", "pair", " ", "of", " ", 
        RowBox[{"brackets", "."}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", "avoidenvs"}], ">", "0"}], ",", 
        RowBox[{
         RowBox[{"splitstructureenv", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"Switch", "[", 
              RowBox[{
               RowBox[{"StringTake", "[", 
                RowBox[{"string", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", "5"}]}], "}"}]}], 
                "]"}], ",", "\"\<\\\\begin\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "1", ",", 
                 RowBox[{"StringTake", "[", 
                  RowBox[{"string", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", "7"}], ",", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "-", "1"}]}], "}"}]}], 
                  "]"}]}], "}"}], ",", "_", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{"StringTake", "[", 
                  RowBox[{"string", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", "5"}], ",", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "-", "1"}]}], "}"}]}], 
                  "]"}]}], "}"}]}], "]"}], ")"}], "&"}], "/@", 
           "envstartstop"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"splitstructureenv", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "0", ",", "False"}], 
             "}"}], "&"}], "/@", 
           RowBox[{"Cases", "[", 
            RowBox[{"splitstructureenv", ",", 
             RowBox[{"{", 
              RowBox[{"_", ",", "_", ",", 
               RowBox[{"Alternatives", "@@", "avoidenvs"}]}], "}"}]}], 
            "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Join", " ", "with", " ", "the", " ", "previous", " ", 
           "splitstructure"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"splitstructure", "=", 
          RowBox[{"SortBy", "[", 
           RowBox[{
            RowBox[{"Join", "[", 
             RowBox[{"splitstructure", ",", "splitstructureenv"}], "]"}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "Compute", " ", "the", " ", "bracket", " ", "level", " ", "by", " ", 
         "accumulating", " ", "the", " ", 
         RowBox[{"n", "'"}], 
         RowBox[{"s", ".", " ", "Return"}], " ", "a", " ", "structure", " ", 
         RowBox[{"{", 
          RowBox[{"pos", ",", " ", "possiblebreakQ"}], "}"}]}], ",", " ", 
        RowBox[{
        "and", " ", "extract", " ", "the", " ", "possible", " ", "breaking", 
         " ", 
         RowBox[{"positions", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"splitstructure", "=", 
       RowBox[{"MapThread", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"#2", "\[Equal]", "0"}], ",", 
              RowBox[{"#3", "<=", "breakdepth"}], ",", 
              RowBox[{"#1", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], "}"}], "&"}], ",", 
         RowBox[{"{", 
          RowBox[{"splitstructure", ",", 
           RowBox[{"Accumulate", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", 
             "splitstructure"}], "]"}], ",", 
           RowBox[{"Accumulate", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "&"}], "/@", 
             "splitstructure"}], "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"splittablePositions", "=", 
       RowBox[{"First", "/@", 
        RowBox[{"Select", "[", 
         RowBox[{"splitstructure", ",", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}]}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588080124533271*^9, 3.5880801251104717`*^9}, {
   3.727334497617021*^9, 3.727334607583501*^9}, {3.7273346542153454`*^9, 
   3.727334657903822*^9}, {3.727334690616264*^9, 3.727334694963759*^9}, {
   3.7273357508958087`*^9, 3.727335802552883*^9}, {3.727335844738163*^9, 
   3.727335912898426*^9}, {3.727335964193879*^9, 3.727335983455639*^9}, {
   3.727336157344606*^9, 3.727336192104974*^9}, {3.727336326590088*^9, 
   3.7273363979414806`*^9}, {3.727336664948242*^9, 3.7273366664340935`*^9}, {
   3.7273369140587006`*^9, 3.727336986543435*^9}, {3.7273404705537233`*^9, 
   3.727340471023249*^9}, {3.72734057921856*^9, 3.727340579788499*^9}, 
   3.777913928761294*^9, {3.7779140521993823`*^9, 3.777914060034573*^9}, {
   3.84276153061651*^9, 3.842761530928651*^9}, {3.958400071248047*^9, 
   3.958400140038292*^9}},
 CellLabel->
  "In[380]:=",ExpressionUUID->"d47f80bc-04b1-4f80-9770-b13526e2c306"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PointBreakingFunction", "[", 
    RowBox[{
    "perLinein_", ",", "n_", ",", "texedwidthin_", ",", "pagewidth_", ",", 
     "splittablePositionsin_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nearestTerm", ",", 
       RowBox[{"positions", "=", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"perLine", "=", "perLinein"}], ",", 
       RowBox[{"texedwidth", "=", "texedwidthin"}], ",", 
       RowBox[{"splittablePositions", "=", "splittablePositionsin"}]}], "}"}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Split", " ", "parts", " ", "where", " ", "lengths", " ", "are", " ", 
       "given", " ", "explicitly"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "perLine"}], ">", "0"}], ",", 
          RowBox[{
           RowBox[{"Length", "@", "splittablePositions"}], ">", "0"}]}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"nearestTerm", "=", 
          RowBox[{"BreakingFunction", "[", 
           RowBox[{
            RowBox[{"Thread", "@", 
             RowBox[{"Rule", "[", 
              RowBox[{
               RowBox[{"Accumulate", "@", "texedwidth"}], ",", " ", 
               RowBox[{"Range", "@", 
                RowBox[{"Length", "@", "texedwidth"}]}]}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"perLine", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "/.", 
             RowBox[{"latextextwidth", "->", "pagewidth"}]}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"perLine", "=", 
          RowBox[{"Rest", "@", 
           RowBox[{"Normal", "@", "perLine"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"nearestTerm", "\[LessEqual]", 
            RowBox[{"Length", "@", "splittablePositions"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"AppendTo", "[", 
             RowBox[{"positions", ",", 
              RowBox[{"splittablePositions", "[", 
               RowBox[{"[", "nearestTerm", "]"}], "]"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"splittablePositions", "=", 
             RowBox[{"Drop", "[", 
              RowBox[{"splittablePositions", ",", "nearestTerm"}], "]"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"texedwidth", "=", 
             RowBox[{"Drop", "[", 
              RowBox[{"texedwidth", ",", "nearestTerm"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"splittablePositions", "=", 
             RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"texedwidth", "=", 
             RowBox[{"{", "}"}]}], ";"}]}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{" ", 
        RowBox[{
        "Split", " ", "remainder", " ", "into", " ", "strings", " ", "of", 
         " ", 
         RowBox[{"length", "~", "n"}]}], ")"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", "splittablePositions"}], ">", "0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"nearestTerm", "=", 
          RowBox[{"BreakingFunction", "[", 
           RowBox[{
            RowBox[{"Thread", "@", 
             RowBox[{"Rule", "[", 
              RowBox[{
               RowBox[{"Accumulate", "@", "texedwidth"}], ",", " ", 
               RowBox[{"Range", "@", 
                RowBox[{"Length", "@", "texedwidth"}]}]}], "]"}]}], ",", 
            RowBox[{"n", "/.", 
             RowBox[{"latextextwidth", "->", "pagewidth"}]}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"nearestTerm", "\[LessEqual]", 
            RowBox[{"Length", "@", "splittablePositions"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"AppendTo", "[", 
             RowBox[{"positions", ",", 
              RowBox[{"splittablePositions", "[", 
               RowBox[{"[", "nearestTerm", "]"}], "]"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"splittablePositions", "=", 
             RowBox[{"Drop", "[", 
              RowBox[{"splittablePositions", ",", "nearestTerm"}], "]"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"texedwidth", "=", 
             RowBox[{"Drop", "[", 
              RowBox[{"texedwidth", ",", "nearestTerm"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"splittablePositions", "=", 
             RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"texedwidth", "=", 
             RowBox[{"{", "}"}]}], ";"}]}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "positions"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[383]:=",ExpressionUUID->"d9d8fb35-391e-574d-80a8-dd5f1c0c8ef3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TexBreak", "[", 
     RowBox[{"string_String", ",", "n_", ",", "l_List", ",", "options___"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "splittablePositions", ",", "breakat", ",", "breakby", ",", 
        "breakstring", ",", "splitat", ",", "positions", ",", "perLine", ",", 
        "splitted", ",", "texedwidth", ",", "mark", ",", "pagewidth", ",", 
        "tmpselect", ",", "breakinparenthesis", ",", "avoidenvs"}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "breakat", ",", "breakby", ",", "breakstring", ",", "mark", ",", 
          "breakinparenthesis", ",", "avoidenvs"}], "}"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "TexBreakAt", ",", "TexBreakBy", ",", "TexBreakString", ",", " ", 
            "EquationMarks", ",", "TexBreakInParenthesis", ",", 
            "TexBreakAvoidEnvs"}], "}"}], "/.", 
          RowBox[{"CheckOptions", "[", "options", "]"}]}], "/.", 
         RowBox[{"Options", "[", "TexBreak", "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Positions", " ", "where", " ", "the", " ", "string", " ", "can", " ",
          "be", " ", 
         RowBox[{"split", ":", " ", 
          RowBox[{"wherever", " ", "+", " ", "or", " ", "-", " ", 
           RowBox[{"is", " ", "encountered"}]}]}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"Older", " ", 
           RowBox[{"code", ":", " ", "splittablePositions"}]}], "=", 
          RowBox[{"First", "/@", 
           RowBox[{"StringPosition", "[", 
            RowBox[{"string", ",", "breakat"}], "]"}]}]}], ";"}], " ", "*)"}],
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"splittablePositions", "=", 
        RowBox[{"SplittingFunction", "[", 
         RowBox[{
         "string", ",", "breakat", ",", "breakinparenthesis", ",", 
          "avoidenvs"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"The", " ", 
         RowBox[{"terms", "/", "characters"}], " ", "per", " ", "line", " ", 
         "that", " ", "the", " ", "user", " ", "specified"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"l", "\[NotEqual]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"perLine", "=", 
          RowBox[{"SparseArray", "[", 
           RowBox[{"l", ",", "Automatic", ",", "n"}], "]"}]}], ",", 
         RowBox[{"perLine", "=", 
          RowBox[{"{", "n", "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Positions", " ", "at", " ", "which", " ", "the", " ", "string", " ", 
         "will", " ", "be", " ", "split"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "breakby", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         "\"\<Character\>\"", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"positions", "=", 
           RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"iter", ",", 
              RowBox[{"currentPosition", "=", "0"}], ",", "nearestPosition", 
              ",", 
              RowBox[{"strlen", "=", 
               RowBox[{"StringLength", "[", "string", "]"}]}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "Split", " ", "parts", " ", "where", " ", "lengths", " ", "are", 
              " ", "given", " ", "explicitly"}], " ", "*)"}], 
            RowBox[{
             RowBox[{"For", "[", 
              RowBox[{
               RowBox[{"iter", "=", "1"}], ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"iter", "\[LessEqual]", 
                  RowBox[{"Length", "[", "perLine", "]"}]}], ")"}], "&&", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"currentPosition", "+", 
                   RowBox[{"perLine", "[", 
                    RowBox[{"[", "iter", "]"}], "]"}]}], "<", "strlen"}], 
                 ")"}]}], ",", 
               RowBox[{"iter", "++"}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"tmpselect", "=", 
                 RowBox[{"Select", "[", 
                  RowBox[{
                   RowBox[{"splittablePositions", "-", "currentPosition"}], 
                   ",", "Positive"}], "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"nearestPosition", "=", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "tmpselect", "]"}], ">", "0"}], 
                   ",", 
                   RowBox[{"Nearest", "[", 
                    RowBox[{"tmpselect", ",", 
                    RowBox[{"perLine", "[", 
                    RowBox[{"[", "iter", "]"}], "]"}]}], "]"}], ",", 
                   RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"nearestPosition", "\[NotEqual]", 
                   RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"currentPosition", "+=", 
                    RowBox[{"First", "@", "nearestPosition"}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"AppendTo", "[", 
                    RowBox[{"positions", ",", "currentPosition"}], "]"}]}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"currentPosition", "=", "strlen"}]}], 
                 "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]",
               "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{" ", 
               RowBox[{
               "Split", " ", "remainder", " ", "into", " ", "strings", " ", 
                "of", " ", 
                RowBox[{"length", "~", "n"}]}], ")"}], " ", "*)"}], 
             RowBox[{"While", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"currentPosition", "+", "n"}], "<", "strlen"}], 
                ")"}], ",", 
               RowBox[{
                RowBox[{"nearestPosition", "=", 
                 RowBox[{"Nearest", "[", 
                  RowBox[{
                   RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"splittablePositions", "-", "currentPosition"}], 
                    ",", "Positive"}], "]"}], ",", "n"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"nearestPosition", "\[NotEqual]", 
                   RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"currentPosition", "+=", 
                    RowBox[{"First", "@", "nearestPosition"}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"AppendTo", "[", 
                    RowBox[{"positions", ",", "currentPosition"}], "]"}]}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"currentPosition", "=", "strlen"}]}], 
                 "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]",
               "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", "\"\<Term\>\"", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "The", " ", "terms", " ", "at", " ", "which", " ", "we", " ", 
           "want", " ", "to", " ", "split"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"splitat", "=", 
           RowBox[{"Accumulate", "[", "perLine", "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Pad", " ", "out", " ", "every", " ", "n", " ", "terms"}], 
           " ", "*)"}], 
          RowBox[{"splitat", "=", 
           RowBox[{"Flatten", "[", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"splitat", ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"Last", "[", "splitat", "]"}], "+", "n"}], ",", 
                RowBox[{"Length", "[", "splittablePositions", "]"}], ",", 
                "n"}], "]"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Remove", " ", "split", " ", "points", " ", "which", " ", "are", 
            " ", "past", " ", "the", " ", "end", " ", "of", " ", "the", " ", 
            "string"}], " ", "*)"}], 
          RowBox[{"splitat", "=", 
           RowBox[{"Select", "[", 
            RowBox[{"splitat", ",", 
             RowBox[{
              RowBox[{"#", "\[LessEqual]", 
               RowBox[{"Length", "[", "splittablePositions", "]"}]}], "&"}]}],
             "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "The", " ", "positions", " ", "in", " ", "the", " ", "string", " ",
             "to", " ", "split", " ", "at"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"positions", "=", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Part", "[", 
               RowBox[{"splittablePositions", ",", "#"}], "]"}], "&"}], ",", 
             "splitat"}], "]"}]}], ";"}], ",", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", "\"\<TexPoint\>\"", ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"splitted", "=", 
           RowBox[{"StringTake", "[", 
            RowBox[{"string", ",", 
             RowBox[{"Thread", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Prepend", "[", 
                 RowBox[{"splittablePositions", ",", "1"}], "]"}], ",", 
                RowBox[{"Append", "[", 
                 RowBox[{
                  RowBox[{"splittablePositions", "-", "1"}], ",", 
                  RowBox[{"StringLength", "@", "string"}]}], "]"}]}], "}"}], 
              "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"texedwidth", "=", 
           RowBox[{"TexWidths", "@@", "splitted"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"pagewidth", "=", 
           RowBox[{"First", "@", "texedwidth"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"texedwidth", "=", 
           RowBox[{"Rest", "@", "texedwidth"}]}], ";", "\[IndentingNewLine]", 
          
          RowBox[{"positions", "=", 
           RowBox[{"PointBreakingFunction", "[", 
            RowBox[{
            "perLine", ",", "n", ",", "texedwidth", ",", "pagewidth", ",", 
             "splittablePositions"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         ",", "\[IndentingNewLine]", "\[IndentingNewLine]", "_", ",", 
         "\[IndentingNewLine]", 
         RowBox[{
         "Throw", "[", "\"\<Invalid value for option TexBreakBy.\>\"", 
          "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Split", " ", "string"}], " ", "*)"}], "\[IndentingNewLine]", 
       
       RowBox[{"AddEquationMarks", "[", 
        RowBox[{
         RowBox[{"StringInsert", "[", 
          RowBox[{"string", ",", "breakstring", ",", "positions"}], "]"}], 
         ",", "mark"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Shortcuts", " ", "and", " ", "defaults"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBreak", "[", 
    RowBox[{"string_String", ",", "n_", ",", "options___"}], "]"}], ":=", 
   RowBox[{"TexBreak", "[", 
    RowBox[{"string", ",", "n", ",", 
     RowBox[{"{", "}"}], ",", "options"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexBreak", "[", 
    RowBox[{"string_String", ",", "options___"}], "]"}], ":=", 
   RowBox[{"TexBreak", "[", 
    RowBox[{"string", ",", "200", ",", 
     RowBox[{"{", "}"}], ",", "options"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5831323117520185`*^9, 3.583132742843175*^9}, {
   3.583132791920861*^9, 3.5831329161906796`*^9}, {3.583132950073939*^9, 
   3.583132981741994*^9}, {3.583133165261717*^9, 3.5831331697857246`*^9}, {
   3.5880795204826097`*^9, 3.588079567235892*^9}, 3.588079916538105*^9, 
   3.588080053147545*^9, {3.588328195833801*^9, 3.5883282750819407`*^9}, {
   3.588328812284484*^9, 3.5883288702395854`*^9}, {3.588329263578676*^9, 
   3.588329306260351*^9}, {3.58832949913909*^9, 3.588329507438305*^9}, {
   3.683447928320627*^9, 3.683447939200736*^9}, {3.715232198553116*^9, 
   3.715232281697308*^9}, {3.71523250604329*^9, 3.715232542108581*^9}, {
   3.715232634500255*^9, 3.715232649700454*^9}, {3.715233224131973*^9, 
   3.71523327585917*^9}, {3.715233332647464*^9, 3.7152333948521976`*^9}, {
   3.715233545992714*^9, 3.715233554390091*^9}, {3.727334650613534*^9, 
   3.7273347179158177`*^9}, 3.727335796619299*^9, {3.72733594472457*^9, 
   3.727335945694734*^9}, {3.727336021069646*^9, 3.7273360819039397`*^9}, {
   3.72733668999757*^9, 3.727336690413052*^9}, {3.842760298537687*^9, 
   3.84276030564196*^9}, {3.958400167559574*^9, 3.9584002172616615`*^9}},
 CellLabel->
  "In[384]:=",ExpressionUUID->"3740ff6f-cc36-415f-a05f-bc96c7e9937a"]
}, Closed]],

Cell[CellGroupData[{

Cell["6.2. TexWidths", "Subsection",
 CellChangeTimes->{{3.5822792082243814`*^9, 3.5822792262580137`*^9}, 
   3.61908520690187*^9},ExpressionUUID->"45c97c55-4664-4e85-a0d8-\
6e850f0de568"],

Cell["\<\
Thomas\[CloseCurlyQuote] code for determining the widths of a sequence of tex \
expressions measured in printer points. 
A file TexActWidthTest.tex is written and passed to the inline latex command. \
The widths are then extracted from the output.The first output is the latex \
textwidth environment variable.\
\>", "Text",
 CellChangeTimes->{{3.582279240532039*^9, 3.5822794098547363`*^9}, {
  3.582279477122054*^9, 3.582279533204152*^9}, {3.582281862071843*^9, 
  3.582281863101445*^9}, {3.588330204478729*^9, 
  3.588330241778395*^9}},ExpressionUUID->"55d3c8e1-2164-4245-b475-\
dc7cb4fe0832"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "latextextwidth", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588329526017937*^9, 3.58832953339675*^9}},
 CellLabel->
  "In[387]:=",ExpressionUUID->"58c837f0-a0e1-4542-a14b-0f7e01875738"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$TexDirectory", "=", "$TemporaryDirectory"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$TexTmpDirectory", "=", "$TemporaryDirectory"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588081997148167*^9, 3.5880820029981775`*^9}, {
  3.5883139972465973`*^9, 3.588314003549008*^9}, {3.6410294708241997`*^9, 
  3.6410294711542*^9}},
 CellLabel->
  "In[388]:=",ExpressionUUID->"f6cf244a-5510-4475-8ce0-6bc765a061c7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"Or", 
     StyleBox["[", "Code"], 
     RowBox[{
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"System`$Version", ",", "\"\<*Linux*\>\""}], "]"}], ",", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"System`$Version", ",", "\"\<*Mac OS*\>\""}], "]"}]}], 
     StyleBox["]", "Input"]}], ",", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "latexlist", "}"}], ",", 
      RowBox[{
       RowBox[{"latexlist", "=", 
        RowBox[{"ReadList", "[", 
         RowBox[{"\"\<!$SHELL -l -c 'which pdflatex'\>\"", ",", "String"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", "latexlist"}], ">", "0"}], ",", 
         RowBox[{"$LatexExecutable", "=", 
          RowBox[{"StringJoin", "[", 
           RowBox[{
            RowBox[{"Last", "@", "latexlist"}], ",", 
            "\"\< -interaction nonstopmode -halt-on-error\>\""}], "]"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{
         "$LatexExecutable", ":=", 
          "\"\<pdflatex -interaction nonstopmode -halt-on-error\>\""}]}], 
        "]"}], ";"}]}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
     "$LatexExecutable", ":=", 
      "\"\<pdflatex -interaction nonstopmode -halt-on-error\>\""}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"System`$Version", ",", "\"\<*Linux*\>\""}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"$LinusStdLib", "=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Environment", "[", "\"\<LD_LIBRARY_PATH\>\"", "]"}], "/.", 
       RowBox[{"$Failed", "\[Rule]", "False"}]}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"$LinuxStdLib", "=", "False"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.64103091763655*^9, 3.712045805944728*^9, {3.778504309677374*^9, 
   3.778504310347468*^9}, {3.791093114575318*^9, 3.7910932216144276`*^9}, {
   3.7910933236227303`*^9, 3.791093326970896*^9}, 3.791093862507215*^9, 
   3.791113204862705*^9},
 CellLabel->
  "In[390]:=",ExpressionUUID->"98e9d480-e40e-4b75-9011-98416395b963"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "$TexInitLatexClassCode", "=", 
   "\"\<\\\\documentclass[10pt,a4paper]{article}\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "$TexInitLatexInternalClassCode", "=", 
   "\"\<\\\\documentclass[border=2pt,varwidth]{standalone}\>\""}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.58796424998662*^9, 3.587964277099468*^9}, {
  3.728550561197211*^9, 3.728550583104693*^9}},
 CellLabel->
  "In[392]:=",ExpressionUUID->"6adfeaf7-650d-4cf4-9d44-562b09e2e070"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexInitLatexPackages", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<{amssymb}\>\"", ",", " ", "\"\<{amsmath}\>\"", ",", " ", 
     "\"\<{amsthm}\>\"", ",", " ", "\"\<{latexsym}\>\""}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5879639239928474`*^9, 3.587964043301857*^9}},
 CellLabel->
  "In[394]:=",ExpressionUUID->"0c03530b-eb8a-468c-9981-de34a13cfdfb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexInitLatexExtraCode", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.587964316895138*^9, 3.587964324117951*^9}},
 CellLabel->
  "In[395]:=",ExpressionUUID->"4b02e3b5-ac61-4f81-b922-ee3aebfcd944"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexInitLatexCode", "[", "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"$TexInitLatexClassCode", ",", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\\\usepackage\>\"", ",", "#", ",", "\"\<\\n\>\""}], 
        "]"}], "&"}], "/@", "$TexInitLatexPackages"}], "]"}], ",", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{"#", ",", "\"\<\\n\>\""}], "]"}], "&"}], "/@", 
      "$TexInitLatexExtraCode"}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.587964060383888*^9, 3.58796406202189*^9}, {
  3.587964133782016*^9, 3.5879641970401278`*^9}, {3.587964283292679*^9, 
  3.587964294696299*^9}, {3.587964338048775*^9, 3.5879643663784246`*^9}},
 CellLabel->
  "In[396]:=",ExpressionUUID->"2a3f0903-70fd-4b2f-977b-5520b7ece475"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexWidthsWriteFile", "[", "strs___", "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmpfile", "=", 
       RowBox[{"OpenWrite", "[", "\"\<TexActWidthTest.tex\>\"", "]"}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"WriteString", "[", 
       RowBox[{"tmpfile", ",", 
        RowBox[{"TexInitLatexCode", "[", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "tmpfile", ",", 
        "\"\<\\\\newlength{\\\\widthofexpr}\n\
\\\\newcommand{\\\\testwidth}[1]{\\\\settowidth{\\\\widthofexpr}{\\\\hbox{$\\\
\\displaystyle{}#1$}}}\n\
\\\\newcommand{\\\\writewidth}[1]{\\\\settowidth{\\\\widthofexpr}{\\\\hbox{$\\\
\\displaystyle{}#1$}}\n\\\\immediate\\\\write0{\\\\the\\\\widthofexpr}}\n\
\\\\begin{document}\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"tmpfile", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<\\\\testwidth{\>\"", ",", "#", ",", "\"\<}\\n\>\""}], 
           "]"}]}], "]"}], "&"}], "/@", 
       RowBox[{"{", "strs", "}"}]}], ";", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "tmpfile", ",", "\"\<\\\\immediate\\\\write0{xActWidthStart}\\n\>\""}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "tmpfile", ",", 
        "\"\<\\\\immediate\\\\write0{\\\\the\\\\textwidth}\\n\>\""}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"tmpfile", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<\\\\writewidth{\>\"", ",", "#", ",", "\"\<}\\n\>\""}],
            "]"}]}], "]"}], "&"}], "/@", 
       RowBox[{"{", "strs", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "tmpfile", ",", 
        "\"\<\\\\immediate\\\\write0{xActWidthEnd}\n\\\\end{document}\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "tmpfile", "]"}], ";"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.566736866504864*^9, 3.566737158694377*^9}, {
   3.566737532902636*^9, 3.566737560343084*^9}, {3.5667384453678555`*^9, 
   3.566738466973893*^9}, {3.56673869190849*^9, 3.566738694217294*^9}, {
   3.566738914280682*^9, 3.566738924295899*^9}, {3.566738957477158*^9, 
   3.566739032123289*^9}, {3.5668338784885716`*^9, 3.5668338942445993`*^9}, {
   3.5668379798323755`*^9, 3.566837984652784*^9}, {3.582277943697157*^9, 
   3.582277947628364*^9}, {3.582278714357714*^9, 3.582278725792535*^9}, 
   3.582278792919452*^9, {3.587964407921297*^9, 3.5879644092784996`*^9}, {
   3.588082594863217*^9, 3.5880825961736193`*^9}, {3.588328100892034*^9, 
   3.588328139143301*^9}, 3.5883285196747694`*^9, {3.61639822081534*^9, 
   3.616398229822855*^9}},
 CellLabel->
  "In[397]:=",ExpressionUUID->"f25e918e-27af-4d1c-a3b1-8ad2608da85d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtractTexWidths", "[", "str1_List", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"str2", "=", 
      RowBox[{"Drop", "[", 
       RowBox[{"str1", ",", 
        RowBox[{"First", "@", 
         RowBox[{"First", "@", 
          RowBox[{"Position", "[", 
           RowBox[{
           "str1", ",", "\"\<xActWidthStart\>\"", ",", "1", ",", "1"}], 
           "]"}]}]}]}], "]"}]}], "}"}], ",", 
    RowBox[{"ToExpression", "/@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"StringReplace", "[", 
         RowBox[{"#", ",", 
          RowBox[{"\"\<pt\>\"", "\[Rule]", "\"\<\>\""}]}], "]"}], "&"}], "/@", 
       RowBox[{"Take", "[", 
        RowBox[{"str2", ",", 
         RowBox[{
          RowBox[{"First", "@", 
           RowBox[{"First", "@", 
            RowBox[{"Position", "[", 
             RowBox[{
             "str2", ",", "\"\<xActWidthEnd\>\"", ",", "1", ",", "1"}], 
             "]"}]}]}], "-", "1"}]}], "]"}]}], ")"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.566739238683253*^9, 3.566739265406099*^9}, {
  3.5822788277387133`*^9, 3.582278828222314*^9}},
 CellLabel->
  "In[398]:=",ExpressionUUID->"cad804dc-1c05-4f23-b227-27c04690fc77"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexWidths", "[", "strs___", "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"TexOut", ",", "errorpos"}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<TexWidth call with list length \>\"", ",", " ", 
         RowBox[{"Length", "@", 
          RowBox[{"{", "strs", "}"}]}]}], "]"}], ";"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SetDirectory", "[", "$TexTmpDirectory", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TexWidthsWriteFile", "[", "strs", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TexOut", "=", 
       RowBox[{"ReadList", "[", 
        RowBox[{
         RowBox[{
         "\"\<!\>\"", "<>", "$LatexExecutable", "<>", 
          "\"\< TexActWidthTest.tex\>\""}], ",", "String"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "TexOut"}], "\[Equal]", "0"}], ",", 
          RowBox[{"$LinuxStdLib", "=!=", "False"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{"SetEnvironment", "[", 
          RowBox[{"\"\<LD_LIBRARY_PATH\>\"", "\[Rule]", "\"\<\>\""}], "]"}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"TexOut", "=", 
          RowBox[{"ReadList", "[", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{
             "\"\<!\>\"", "<>", "$LatexExecutable", "<>", 
              "\"\< TexActWidthTest.tex\>\""}], "]"}], ",", "String"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"SetEnvironment", "[", 
          RowBox[{"\"\<LD_LIBRARY_PATH\>\"", "\[Rule]", "$LinuxStdLib"}], 
          "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", "TexOut"}], "\[Equal]", "0"}], ",", 
        "\"\<Could not find Latex. Check if $LatexExecutable contains the \
correct name and path.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"errorpos", "=", 
       RowBox[{"DeleteFile", "[", 
        RowBox[{"{", 
         RowBox[{
         "\"\<TexActWidthTest.tex\>\"", ",", "\"\<TexActWidthTest.log\>\"", 
          ",", "\"\<TexActWidthTest.aux\>\""}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"errorpos", "=!=", "Null"}], ",", 
        RowBox[{
        "Print", "[", "\"\<Tex Error: could not delete temporary files\>\"", 
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ResetDirectory", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", 
          RowBox[{"Position", "[", 
           RowBox[{
           "TexOut", ",", "\"\<xActWidthEnd\>\"", ",", "1", ",", "1"}], 
           "]"}]}], "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ExtractTexWidths", "@", "TexOut"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"errorpos", "=", 
          RowBox[{"Position", "[", 
           RowBox[{"TexOut", ",", 
            RowBox[{"str_String", "?", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"StringMatchQ", "[", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "StartOfString", " ", "~~", " ", "\"\<!\>\"", "~~", 
                  "___"}]}], "]"}], "&"}], ")"}]}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "@", "errorpos"}], ">", "0"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Tex Error:\\n\>\"", ",", 
             RowBox[{"Sequence", "@@", 
              RowBox[{"Drop", "[", 
               RowBox[{"TexOut", ",", 
                RowBox[{
                 RowBox[{"First", "@", 
                  RowBox[{"First", "@", "errorpos"}]}], "-", "1"}]}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<Tex Error:\\n\>\"", ",", 
              RowBox[{"Sequence", "@@", "TexOut"}]}], "]"}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Throw", "[", "\"\<Tex Error\>\"", "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588082015134999*^9, 3.5880820156497993`*^9}, {
   3.5880826026164308`*^9, 3.588082604082833*^9}, {3.588314020662237*^9, 
   3.58831404499828*^9}, {3.6834481355226994`*^9, 3.683448136062705*^9}, {
   3.68344817159406*^9, 3.6834482209445534`*^9}, {3.683448267245017*^9, 
   3.6834483233455777`*^9}, {3.727335121912364*^9, 3.72733517111191*^9}, {
   3.727335283437677*^9, 3.727335285754858*^9}, {3.727340688164119*^9, 
   3.727340692198415*^9}, {3.7910934389857225`*^9, 3.791093568714069*^9}, 
   3.791093682290113*^9, {3.79111320487833*^9, 3.79111320487833*^9}},
 CellLabel->
  "In[399]:=",ExpressionUUID->"831d8051-a733-4652-864c-bb8024710593"]
}, Closed]],

Cell[CellGroupData[{

Cell["6.2. TexPrintAlignedEquations", "Subsection",
 CellChangeTimes->{{3.5822792082243814`*^9, 3.5822792262580137`*^9}, 
   3.582353429263704*^9, 
   3.619085208791873*^9},ExpressionUUID->"24183a8c-ad83-4120-aa8a-\
d70bf89d9e26"],

Cell["\<\
Thomas\[CloseCurlyQuote] code for typesetting a list of equations in an \
aligned environment. Use $TexprintPageWidth to adjust the linebreaking.\
\>", "Text",
 CellChangeTimes->{{3.582279240532039*^9, 3.5822794098547363`*^9}, {
  3.582279477122054*^9, 3.582279533204152*^9}, {3.582281862071843*^9, 
  3.582281863101445*^9}, {3.582353436985718*^9, 3.582353490993013*^9}, {
  3.5823535218186665`*^9, 
  3.582353528604679*^9}},ExpressionUUID->"a283ceba-2dc7-416d-b3e1-\
d9d5183a30fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexPrintPageWidth", "=", "latextextwidth"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.582353308535093*^9, 3.582353340218748*^9, 
  3.588329644078945*^9},
 CellLabel->
  "In[400]:=",ExpressionUUID->"a454ed16-81b7-4a28-848a-967a9420c5c3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TexPrintAlignedEquations", "[", 
    RowBox[{"eq_Equal", ",", "x___"}], "]"}], ":=", 
   RowBox[{"TexPrintAlignedEquations", "[", 
    RowBox[{
     RowBox[{"{", "eq", "}"}], ",", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TexPrintAlignedEquations", "[", 
    RowBox[{"eq_", ",", "x___"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"TexPrintAlignedEquations", "[", 
     RowBox[{
      RowBox[{"{", "eq", "}"}], ",", "x"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"Head", "[", "eq", "]"}], "==", "Equal"}]}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.582352460861911*^9, 3.582352487896758*^9}, {
  3.683451011064648*^9, 3.683451023207648*^9}, {3.6836137413956747`*^9, 
  3.6836137425557213`*^9}, {3.684599819839319*^9, 3.68459981996932*^9}, {
  3.6845998668553915`*^9, 3.6845998695613956`*^9}},
 CellLabel->
  "In[401]:=",ExpressionUUID->"3fb90955-d9a0-4d4d-9e02-005de5df5566"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LHSpart", "[", 
   RowBox[{"a_", "\[Equal]", "b_"}], "]"}], ":=", "a"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588316016438143*^9, 3.588316054003009*^9}},
 CellLabel->
  "In[403]:=",ExpressionUUID->"c1f0ab1b-879a-4526-a6b3-80dbac744417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RHSpart", "[", 
   RowBox[{"a_", "\[Equal]", "b_"}], "]"}], ":=", "b"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.58831606028982*^9, 3.588316062224223*^9}},
 CellLabel->
  "In[404]:=",ExpressionUUID->"ea597879-63fe-4d41-a8b7-454216a6691e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LHSpart", "[", "b_", "]"}], ":=", "\"\<\>\""}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588316088354269*^9, 3.588316097449085*^9}},
 CellLabel->
  "In[405]:=",ExpressionUUID->"6df28451-7490-4c72-9600-83884d04b49a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RHSpart", "[", "b_", "]"}], ":=", "b"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5883161074331026`*^9, 3.5883161092427053`*^9}},
 CellLabel->
  "In[406]:=",ExpressionUUID->"0f3336f6-a0a8-4f13-812a-6827d68d656c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"TexPrintAlignedEquations", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "TexPrintAlignedEquations", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Labels", "\[Rule]", "False"}], ",", 
     RowBox[{"LastPunctuation", "\[Rule]", "\"\<.\>\""}]}], "}"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.68344728563318*^9, 3.68344728653319*^9}, {
  3.844389686859434*^9, 3.844389687170601*^9}},
 CellLabel->
  "In[407]:=",ExpressionUUID->"bc434725-184f-4283-8393-406d3c6f392a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexLabelName", "[", "str_String", "]"}], ":=", 
   RowBox[{"\"\<eq:\>\"", "<>", 
    RowBox[{"StringReplace", "[", 
     RowBox[{
      RowBox[{"ToString", "[", 
       RowBox[{"str", ",", 
        RowBox[{"CharacterEncoding", "\[Rule]", "\"\<ASCII\>\""}]}], "]"}], 
      ",", 
      RowBox[{
       RowBox[{"\"\<\\\\[\>\"", "~~", 
        RowBox[{"a", ":", 
         RowBox[{"ShortestMatch", "[", "___", "]"}]}], "~~", "\"\<]\>\""}], 
       "\[RuleDelayed]", "a"}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6836140818020997`*^9, 3.683614097792898*^9}, {
  3.683614245541402*^9, 3.683614248881569*^9}, {3.7273434195629854`*^9, 
  3.727343428639646*^9}, {3.7273434732750053`*^9, 3.7273435231662397`*^9}, {
  3.727343632982836*^9, 3.7273436413121166`*^9}, {3.7273438014484267`*^9, 
  3.727343812404924*^9}},
 CellLabel->
  "In[409]:=",ExpressionUUID->"630e0550-8ab1-4abc-83aa-25b2794471b7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexPrintAlignedEquations2", "[", 
   RowBox[{
    RowBox[{"eqlist", ":", 
     RowBox[{"{", "eqs___", "}"}]}], ",", "uselabelsq_", ",", 
    "lastPunctuation_", ",", "labellist_"}], " ", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TexLHS", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"TexPrint", "[", 
          RowBox[{"LHSpart", "@", "#"}], "]"}], "&"}], "/@", "eqlist"}]}], 
      ",", 
      RowBox[{"TexRHS", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"TexPrint", "[", 
          RowBox[{"RHSpart", "@", "#"}], "]"}], "&"}], "/@", "eqlist"}]}], 
      ",", "splittableRHSPositions", ",", "splittedRHS", ",", "AllWidths", 
      ",", "LHSWidths", ",", "RHSWidths", ",", "MaxRHSWidth", ",", 
      "pagewidth", ",", "RHSBreakPositions"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"TexLHS", "=", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"StringJoin", "[", 
          RowBox[{"#", ",", "\"\<={}\>\""}], "]"}], "&"}], "/@", "TexLHS"}], 
       ")"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"TexRHS", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"TexBreak", "[", 
         RowBox[{"#", ",", "1", ",", 
          RowBox[{"TexBreakBy", "\[Rule]", "\"\<Term\>\""}], ",", 
          RowBox[{"TexBreakString", "\[Rule]", "\"\<\\n\>\""}]}], "]"}], 
        "&"}], "/@", "TexRHS"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"splittableRHSPositions", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"SplittingFunction", "[", 
         RowBox[{"#", ",", 
          RowBox[{"TexBreakAt", "/.", 
           RowBox[{"Options", "[", "TexBreak", "]"}]}], ",", 
          RowBox[{"TexBreakInParenthesis", "/.", 
           RowBox[{"Options", "[", "TexBreak", "]"}]}], ",", 
          RowBox[{"TexBreakAvoidEnvs", "/.", 
           RowBox[{"Options", "[", "TexBreak", "]"}]}]}], "]"}], "&"}], "/@", 
       "TexRHS"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"splittedRHS", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"StringTake", "[", 
         RowBox[{"#1", ",", 
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Prepend", "[", 
              RowBox[{"#2", ",", "1"}], "]"}], ",", 
             RowBox[{"Append", "[", 
              RowBox[{
               RowBox[{"#2", "-", "1"}], ",", 
               RowBox[{"StringLength", "@", "#1"}]}], "]"}]}], "}"}], "]"}]}],
          "]"}], "&"}], "@@@", 
       RowBox[{"(", 
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{"TexRHS", ",", "splittableRHSPositions"}], "}"}], "]"}], 
        ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"AllWidths", "=", 
      RowBox[{"TexWidths", "@@", 
       RowBox[{"Join", "[", 
        RowBox[{"TexLHS", ",", 
         RowBox[{"Join", "@@", "splittedRHS"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"pagewidth", "=", 
      RowBox[{"First", "@", "AllWidths"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"LHSWidths", "=", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{"Rest", "@", "AllWidths"}], ",", 
        RowBox[{"Length", "@", "TexLHS"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"RHSWidths", "=", 
      RowBox[{"partitionRagged", "[", 
       RowBox[{
        RowBox[{"Drop", "[", 
         RowBox[{"AllWidths", ",", 
          RowBox[{"1", "+", 
           RowBox[{"Length", "@", "TexLHS"}]}]}], "]"}], ",", 
        RowBox[{"Length", "/@", "splittedRHS"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"MaxRHSWidth", "=", 
      RowBox[{"Round", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"$TexPrintPageWidth", "/.", 
          RowBox[{"latextextwidth", "\[Rule]", "pagewidth"}]}], ")"}], "-", 
        RowBox[{"Max", "@", "LHSWidths"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"RHSBreakPositions", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"PointBreakingFunction", "[", 
         RowBox[{
          RowBox[{"{", "MaxRHSWidth", "}"}], ",", "MaxRHSWidth", ",", "#1", 
          ",", "pagewidth", ",", "#2"}], "]"}], "&"}], "@@@", 
       RowBox[{"(", 
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{"RHSWidths", ",", "splittableRHSPositions"}], "}"}], "]"}], 
        ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"TexRHS", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"StringInsert", "[", 
         RowBox[{"#1", ",", "\"\<\\\\nonumber\\\\\\\\\\n&\>\"", ",", "#2"}], 
         "]"}], "&"}], "@@@", 
       RowBox[{"(", 
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{"TexRHS", ",", "RHSBreakPositions"}], "}"}], "]"}], 
        ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"TexRHS", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"StringReplace", "[", 
         RowBox[{"#", ",", 
          RowBox[{
          "\"\<\\n\\\\nonumber\>\"", "\[Rule]", "\"\<\\\\nonumber\>\""}]}], 
         "]"}], "&"}], "/@", "TexRHS"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<\\\\begin{align}\\n\>\"", ",", 
       RowBox[{"StringReplace", "[", 
        RowBox[{
         RowBox[{"StringJoin", "[", 
          RowBox[{"Riffle", "[", 
           RowBox[{
            RowBox[{"MapThread", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"StringJoin", "[", 
                RowBox[{"#1", ",", "\"\<&\>\"", ",", "#2", ",", " ", 
                 RowBox[{"If", "[", 
                  RowBox[{"uselabelsq", ",", 
                   RowBox[{"StringJoin", "[", 
                    RowBox[{
                    "\"\< \\\\label{\>\"", ",", "#3", ",", "\"\<}\>\""}], 
                    "]"}], ",", "\"\<\>\""}], "]"}]}], "]"}], "&"}], ",", 
              RowBox[{"{", 
               RowBox[{"TexLHS", ",", "TexRHS", ",", "labellist"}], "}"}]}], 
             "]"}], ",", "\"\<,\\\\\\\\\\n\>\""}], "]"}], "]"}], ",", 
         RowBox[{
         "\"\<,\\\\\\\\\\n=\>\"", "\[Rule]", " ", "\"\<\\\\\\\\\\n=\>\""}]}], 
        "]"}], ",", 
       RowBox[{"lastPunctuation", "<>", "\"\<\\n\\\\end{align}\>\""}]}], 
      "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.582350630150895*^9, 3.5823507144690437`*^9}, {
   3.582350768772739*^9, 3.582350874228924*^9}, {3.582350904492977*^9, 
   3.5823511035961266`*^9}, {3.5823511561536193`*^9, 3.582351343977949*^9}, {
   3.5823514728497753`*^9, 3.5823515379642897`*^9}, {3.582351571114348*^9, 
   3.58235158382837*^9}, 3.582351806643562*^9, {3.582351844926029*^9, 
   3.582351871711276*^9}, {3.582352037945168*^9, 3.5823521056024866`*^9}, {
   3.582352163135388*^9, 3.582352266875571*^9}, {3.582352317653659*^9, 
   3.582352410723423*^9}, {3.588316124624333*^9, 3.58831615733759*^9}, 
   3.588319134767502*^9, {3.5883257446774964`*^9, 3.588325789246774*^9}, {
   3.588328364626097*^9, 3.588328420739396*^9}, {3.588329357584441*^9, 
   3.5883293619992495`*^9}, {3.5883295612428*^9, 3.588329586967244*^9}, 
   3.6834472988633137`*^9, 3.683448598531354*^9, {3.683614113003659*^9, 
   3.683614118243921*^9}, {3.684599879838411*^9, 3.684599903538447*^9}, {
   3.727341154613081*^9, 3.727341179464419*^9}, {3.727343461136676*^9, 
   3.72734346932593*^9}, {3.727343507919178*^9, 3.72734351806316*^9}, {
   3.7273436312192554`*^9, 3.7273436454137177`*^9}, {3.727343821508219*^9, 
   3.727343830582049*^9}, 3.72741060361784*^9, {3.844389719027777*^9, 
   3.844389721650758*^9}, 3.844389914884183*^9, {3.84439061349655*^9, 
   3.844390636232737*^9}, 3.8443908419060545`*^9, {3.9584002484235954`*^9, 
   3.9584002659976807`*^9}, {3.9584020510343037`*^9, 
   3.9584020586510715`*^9}},ExpressionUUID->"efd33116-231f-4517-86d5-\
3e578a3238cf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexPrintAlignedEquations", "[", 
   RowBox[{
    RowBox[{"eqlist", ":", 
     RowBox[{"{", "eqs___", "}"}]}], ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"eqnames", "=", 
       RowBox[{"{", 
        RowBox[{"ReleaseHold", "[", 
         RowBox[{"ToString", "/@", 
          RowBox[{"HoldForm", "/@", 
           RowBox[{"Hold", "[", "eqs", "]"}]}]}], "]"}], "}"}]}], ",", 
      "labellist"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"labellist", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "Labels", "]"}], ",", 
            RowBox[{"NameQ", "[", "#", "]"}]}], "]"}], ",", 
          RowBox[{"TexLabelName", "[", "#", "]"}], ",", "\"\<\>\""}], "]"}], 
        "&"}], "/@", "eqnames"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"TexPrintAlignedEquations2", "[", 
      RowBox[{"eqlist", ",", 
       RowBox[{"OptionValue", "[", "Labels", "]"}], ",", 
       RowBox[{"OptionValue", "[", "LastPunctuation", "]"}], ",", 
       "labellist"}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8262783274556227`*^9, 3.826278378636742*^9}, {
   3.826278459549693*^9, 3.826278522542357*^9}, 3.8262785548068686`*^9, {
   3.8262785939265337`*^9, 3.826278643123434*^9}, {3.826278675812653*^9, 
   3.8262786801350927`*^9}, {3.826279259782008*^9, 3.826279260396365*^9}, {
   3.826279471765589*^9, 3.826279472195442*^9}, {3.828329975413991*^9, 
   3.82832998244544*^9}, 3.828330036583957*^9},
 CellLabel->
  "In[411]:=",ExpressionUUID->"d21afdad-7e12-41f0-8929-8b49fb12508c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexPrintAlignedEquations", "[", 
   RowBox[{"eqlist_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"eqlistname", "=", 
        RowBox[{"TexLabelName", "@", 
         RowBox[{"ToString", "@", 
          RowBox[{"HoldForm", "[", "eqlist", "]"}]}]}]}], ",", "labellist"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"labellist", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"StringJoin", "[", 
          RowBox[{"eqlistname", ",", 
           RowBox[{"ToString", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"Length", "[", "eqlist", "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TexPrintAlignedEquations2", "[", 
       RowBox[{"eqlist", ",", 
        RowBox[{"OptionValue", "[", "Labels", "]"}], ",", 
        RowBox[{"OptionValue", "[", "LastPunctuation", "]"}], ",", 
        "labellist"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], "/;", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"NameQ", "@", 
      RowBox[{"ToString", "@", 
       RowBox[{"HoldForm", "[", "eqlist", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Head", "[", "eqlist", "]"}], "\[Equal]", "List"}]}], 
    "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.826278742409008*^9, 3.826278852414661*^9}, {
   3.826278967342661*^9, 3.826279070987414*^9}, {3.826279134812251*^9, 
   3.826279255731281*^9}, {3.826279475593549*^9, 3.826279476051297*^9}, {
   3.828330041757757*^9, 3.8283300430798483`*^9}, 3.828330075686081*^9},
 CellLabel->
  "In[412]:=",ExpressionUUID->"796aa706-d58d-4fa5-8eee-e244a0779c46"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexPrintAlignedEquations", "[", 
   RowBox[{"other_", ",", "x___"}], "]"}], ":=", 
  RowBox[{"TexPrintAlignedEquations", "[", 
   RowBox[{
    RowBox[{"Evaluate", "@", "other"}], ",", "x"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[413]:=",ExpressionUUID->"dda21b0f-b50c-49f6-a91b-5e134cbfe784"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TexPrintAlignedExpressions", "[", "list_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Texed", "=", 
      RowBox[{"TexPrint", "/@", "list"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Texed", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"TexBreak", "[", 
         RowBox[{"#", ",", "1", ",", 
          RowBox[{"TexBreakBy", "\[Rule]", "\"\<Term\>\""}], ",", 
          RowBox[{"TexBreakString", "\[Rule]", "\"\<\\n\>\""}]}], "]"}], 
        "&"}], "/@", "Texed"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Texed", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"TexBreak", "[", 
         RowBox[{"#", ",", "$TexPrintPageWidth", ",", 
          RowBox[{"TexBreakBy", "\[Rule]", "\"\<TexPoint\>\""}], ",", 
          RowBox[{
          "TexBreakString", "\[Rule]", "\"\<\\\\nonumber\\\\\\\\\\n&\>\""}]}],
          "]"}], "&"}], "/@", "Texed"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Texed", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"StringReplace", "[", 
         RowBox[{"#", ",", 
          RowBox[{
          "\"\<\\n\\\\nonumber\>\"", "\[Rule]", "\"\<\\\\nonumber\>\""}]}], 
         "]"}], "&"}], "/@", "Texed"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<\\\\begin{align}\\n&\>\"", ",", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"Riffle", "[", 
         RowBox[{"Texed", ",", "\"\<,\\\\\\\\\\n&\>\""}], "]"}], "]"}], ",", 
       "\"\<.\\n\\\\end{align}\>\""}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588327304915236*^9, 3.5883273473629117`*^9}, {
   3.588327400059803*^9, 3.5883275744057097`*^9}, {3.588327891149666*^9, 
   3.588327901586084*^9}, 3.5883279884314375`*^9, {3.5883296105544853`*^9, 
   3.588329629134118*^9}},
 CellLabel->
  "In[414]:=",ExpressionUUID->"e0fa29d1-8496-4198-b947-d25ba142b1d4"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["7. TexView", "Section",
 CellChangeTimes->{
  3.54501505147226*^9, {3.58807874622205*^9, 3.588078782258113*^9}, {
   3.5880831976346755`*^9, 3.588083198352277*^9}, 3.6190852110618753`*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"211a0c3e-6043-415b-9795-81a106a8c667"],

Cell[CellGroupData[{

Cell["7.1. TexView", "Subsection",
 CellChangeTimes->{{3.5880787928973327`*^9, 3.588078796485338*^9}, {
   3.588082648402511*^9, 3.588082648964112*^9}, 
   3.619085213011894*^9},ExpressionUUID->"78944756-5d81-434f-996b-\
b18d162abb2c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexViewExt", "=", "\"\<.pdf\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588314511329899*^9, 3.58831451722671*^9}},
 CellLabel->
  "In[415]:=",ExpressionUUID->"b233e755-e197-4d30-bb48-a9199877c4db"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AddEquationMarks", "[", 
    RowBox[{"string_", ",", 
     RowBox[{"mark_", ":", "Automatic"}]}], "]"}], ":=", 
   RowBox[{"Switch", "[", 
    RowBox[{
    "mark", ",", "\[IndentingNewLine]", "False", ",", " ", "string", ",", 
     "\[IndentingNewLine]", "Automatic", ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringTake", "[", 
         RowBox[{"string", ",", "6"}], "]"}], "===", "\"\<\\\\begin\>\""}], 
       ",", "string", ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Not", "@", 
          RowBox[{"StringMatchQ", "[", 
           RowBox[{"string", ",", 
            RowBox[{"___", "~~", " ", "\"\<\\\\\\\\\>\"", "~~", "___"}]}], 
           "]"}]}], ",", 
         RowBox[{"AddEquationMarks", "[", 
          RowBox[{"string", ",", "\"\<equation\>\""}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"firstlinebreak", "=", 
             RowBox[{"Last", "@", 
              RowBox[{"First", "@", 
               RowBox[{"StringPosition", "[", 
                RowBox[{"string", ",", " ", "\"\<\\\\\\\\\>\"", ",", "1"}], 
                "]"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"StringMatchQ", "[", 
              RowBox[{
               RowBox[{"StringTake", "[", 
                RowBox[{"string", ",", "firstlinebreak"}], "]"}], ",", 
               RowBox[{"___", "~~", "\"\<&\>\"", "~~", "___"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"AddEquationMarks", "[", 
              RowBox[{"string", ",", "\"\<eqnarray\>\""}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"StringMatchQ", "[", 
                RowBox[{
                 RowBox[{"StringTake", "[", 
                  RowBox[{"string", ",", "firstlinebreak"}], "]"}], ",", 
                 RowBox[{"___", "~~", "\"\<=\>\"", "~~", "___"}]}], "]"}], 
               ",", "\[IndentingNewLine]", 
               RowBox[{"AddEquationMarks", "[", 
                RowBox[{
                 RowBox[{"StringReplace", "[", 
                  RowBox[{"string", ",", 
                   RowBox[{"\"\<=\>\"", "\[Rule]", "\"\<&=&\>\""}], ",", 
                   "1"}], "]"}], ",", "\"\<eqnarray\>\""}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"AddEquationMarks", "[", 
                RowBox[{
                 RowBox[{"StringJoin", "[", 
                  RowBox[{"\"\<&&\>\"", ",", "string"}], "]"}], ",", 
                 "\"\<eqnarray\>\""}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}], ",", "\[IndentingNewLine]", "_", ",", " ", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
      "\"\<\\\\begin{\>\"", ",", "mark", ",", "\"\<}\\n\>\"", ",", " ", 
       "string", ",", " ", "\"\<\\n\\\\end{\>\"", ",", "mark", ",", 
       "\"\<}\\n\>\""}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588079319554257*^9, 3.5880794857725487`*^9}, 
   3.588080037765919*^9, {3.5880802053570137`*^9, 3.588080209896621*^9}, 
   3.588314579814019*^9, {3.5883146261461005`*^9, 3.588314628486105*^9}, {
   3.588314720042666*^9, 3.5883147229130716`*^9}, {3.58831480802682*^9, 
   3.5883148370272717`*^9}, {3.588315361547994*^9, 3.5883154354609222`*^9}, {
   3.588315498625433*^9, 3.588315526721083*^9}, {3.588315569075157*^9, 
   3.588315592178798*^9}, {3.588315699241785*^9, 3.588315702985792*^9}, {
   3.58831574744587*^9, 3.588315870779687*^9}, 3.588315905208947*^9, 
   3.58831879765091*^9, {3.588318912669912*^9, 3.5883189764428234`*^9}},
 CellLabel->
  "In[416]:=",ExpressionUUID->"207d5836-2b69-4498-b7a0-ab50a8bacb73"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexWriteFile", "[", 
    RowBox[{"str_String", ",", "file_String"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"outfile", "=", 
       RowBox[{"OpenWrite", "[", "file", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"WriteString", "[", 
       RowBox[{"outfile", ",", 
        RowBox[{"TexInitLatexCode", "[", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"outfile", ",", "\"\<\\\\begin{document}\\n\>\""}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"outfile", ",", "str"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "outfile", ",", 
        "\"\<\\n\\\\immediate\\\\write0{TexActFinished}\n\
\\\\end{document}\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "outfile", "]"}], ";"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.566736866504864*^9, 3.566737158694377*^9}, {
   3.566737532902636*^9, 3.566737560343084*^9}, {3.5667384453678555`*^9, 
   3.566738466973893*^9}, {3.56673869190849*^9, 3.566738694217294*^9}, {
   3.566738914280682*^9, 3.566738924295899*^9}, {3.566738957477158*^9, 
   3.566739032123289*^9}, {3.5668338784885716`*^9, 3.5668338942445993`*^9}, {
   3.5668379798323755`*^9, 3.566837984652784*^9}, {3.582277943697157*^9, 
   3.582277947628364*^9}, {3.582278714357714*^9, 3.582278725792535*^9}, 
   3.582278792919452*^9, {3.587964407921297*^9, 3.5879644092784996`*^9}, {
   3.588080454005849*^9, 3.5880805702260547`*^9}, {3.588080629708958*^9, 
   3.588080630457759*^9}, {3.58808074505556*^9, 3.588080797300053*^9}, {
   3.588080836892922*^9, 3.58808084734494*^9}, {3.591597829332989*^9, 
   3.59159783035299*^9}},
 CellLabel->
  "In[417]:=",ExpressionUUID->"470e9cb7-d2a1-4ed0-a120-a1422819a844"],

Cell["\<\
TexView can open the pdf file in Mathematica if $TexViewInternal==True. \
Thanks Leo Stein for the suggestion and code.\
\>", "Text",
 CellChangeTimes->{{3.728550450010699*^9, 
  3.7285505342129*^9}},ExpressionUUID->"bb55281a-ba18-449a-8a9b-2dad59a77e4d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$TexViewInternal", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$TexViewResolution", " ", "=", "400"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.728550317799204*^9, 3.728550329777499*^9}, {
   3.728550371746644*^9, 3.728550374961692*^9}, {3.72855042863092*^9, 
   3.7285504354939013`*^9}, {3.9213065306696873`*^9, 3.921306540442583*^9}, 
   3.921306764824421*^9, 3.921306879437542*^9},
 CellLabel->
  "In[418]:=",ExpressionUUID->"8d6ad377-bffd-466d-8846-6c76c6bc2c95"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexView", "[", 
    RowBox[{"texstr_String", ",", 
     RowBox[{"file_String", ":", "\"\<TexActView\>\""}], ",", 
     RowBox[{"openfileq_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"TexOut", ",", "errorpos"}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"SetDirectory", "[", "$TexDirectory", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"$TexViewInternal", ",", "\[IndentingNewLine]", 
        RowBox[{"Block", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "$TexInitLatexClassCode", "=", "$TexInitLatexInternalClassCode"}], 
           "}"}], ",", 
          RowBox[{"TexWriteFile", "[", 
           RowBox[{"texstr", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"file", ",", "\"\<.tex\>\""}], "]"}]}], "]"}]}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"TexWriteFile", "[", 
          RowBox[{"texstr", ",", 
           RowBox[{"StringJoin", "[", 
            RowBox[{"file", ",", "\"\<.tex\>\""}], "]"}]}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"TexOut", "=", 
       RowBox[{"ReadList", "[", 
        RowBox[{
         RowBox[{"StringJoin", "[", 
          RowBox[{
           RowBox[{"\"\<!\>\"", "<>", "$LatexExecutable", "<>", "\"\< \>\""}],
            ",", "file", ",", "\"\<.tex\>\""}], "]"}], ",", "String"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", "TexOut"}], "\[Equal]", "0"}], ",", 
          RowBox[{"$LinuxStdLib", "=!=", "False"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{"SetEnvironment", "[", 
          RowBox[{"\"\<LD_LIBRARY_PATH\>\"", "\[Rule]", "\"\<\>\""}], "]"}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"TexOut", "=", 
          RowBox[{"ReadList", "[", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{
              RowBox[{
              "\"\<!\>\"", "<>", "$LatexExecutable", "<>", "\"\< \>\""}], ",",
               "file", ",", "\"\<.tex\>\""}], "]"}], ",", "String"}], "]"}]}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"SetEnvironment", "[", 
          RowBox[{"\"\<LD_LIBRARY_PATH\>\"", "\[Rule]", "$LinuxStdLib"}], 
          "]"}]}]}], "]"}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", "TexOut"}], "\[Equal]", "0"}], ",", 
        "\"\<Could not find Latex. Check if $LatexExecutable contains the \
correct name and path.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ResetDirectory", "[", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", 
          RowBox[{"Position", "[", 
           RowBox[{
           "TexOut", ",", "\"\<TexActFinished\>\"", ",", "1", ",", "1"}], 
           "]"}]}], "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SetDirectory", "[", "$TexDirectory", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", "\"\<Typesetting OK.\>\"", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"openfileq", ",", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{"$TexViewInternal", ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<Importing file: \>\"", ",", " ", "file", ",", 
                "$TexViewExt"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"Module", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"result", "=", 
                  RowBox[{"Import", "[", 
                   RowBox[{
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"file", ",", "$TexViewExt"}], "]"}], ",", " ", 
                    RowBox[{"ImageResolution", "->", "$TexViewResolution"}]}],
                    "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"ResetDirectory", "[", "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"result", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<Opening file: \>\"", ",", " ", "file", ",", 
                "$TexViewExt"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"SystemOpen", "[", 
               RowBox[{"StringJoin", "[", 
                RowBox[{"file", ",", "$TexViewExt"}], "]"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ResetDirectory", "[", "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"errorpos", "=", 
          RowBox[{"Position", "[", 
           RowBox[{"TexOut", ",", 
            RowBox[{"str_String", "?", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"StringMatchQ", "[", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "StartOfString", " ", "~~", " ", "\"\<!\>\"", "~~", 
                  "___"}]}], "]"}], "&"}], ")"}]}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "@", "errorpos"}], ">", "0"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Tex Error:\\n\>\"", ",", 
             RowBox[{"Sequence", "@@", 
              RowBox[{"Drop", "[", 
               RowBox[{"TexOut", ",", 
                RowBox[{
                 RowBox[{"First", "@", 
                  RowBox[{"First", "@", "errorpos"}]}], "-", "1"}]}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<Tex Error:\\n\>\"", ",", 
              RowBox[{"Sequence", "@@", "TexOut"}]}], "]"}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Throw", "[", "\"\<Tex Error\>\"", "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5880808916022186`*^9, 3.58808102911646*^9}, {
   3.588081061408516*^9, 3.5880810645285215`*^9}, {3.588081134354244*^9, 
   3.588081162028693*^9}, 3.588081480739253*^9, {3.588081758357342*^9, 
   3.5880818022090187`*^9}, {3.5880818778703585`*^9, 3.588081878135558*^9}, {
   3.5880821751912794`*^9, 3.5880821842704954`*^9}, 3.588082344030376*^9, {
   3.588082396228068*^9, 3.588082490779834*^9}, {3.5880826813965683`*^9, 
   3.588082687152979*^9}, {3.588083021619567*^9, 3.588083082818474*^9}, {
   3.588314071331126*^9, 3.588314080067142*^9}, {3.588314536321143*^9, 
   3.588314539581549*^9}, {3.610714560731741*^9, 3.610714612601814*^9}, {
   3.6834483651559954`*^9, 3.683448365525999*^9}, {3.728550896238967*^9, 
   3.728551237345513*^9}, {3.728551516568971*^9, 3.728551547832655*^9}, {
   3.7910937104680185`*^9, 3.791093725395951*^9}, {3.791113204909616*^9, 
   3.791113204916161*^9}, {3.9213067066494007`*^9, 3.9213067474627953`*^9}},
 CellLabel->
  "In[420]:=",ExpressionUUID->"7fe7dddf-03ee-480c-aa20-6553d33ff139"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"TexView", "[", 
   RowBox[{
    RowBox[{"eqlist", ":", 
     RowBox[{"{", 
      RowBox[{"eq_Equal", ",", "eqs___"}], " ", "}"}]}], ",", "opt___"}], 
   "]"}], ":=", 
  RowBox[{"TexView", "[", 
   RowBox[{
    RowBox[{"TexPrintAlignedEquations", "[", "eqlist", "]"}], ",", "opt"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TexView", "[", 
   RowBox[{"list_List", ",", "opt___"}], "]"}], ":=", 
  RowBox[{"TexView", "[", 
   RowBox[{
    RowBox[{"TexPrintAlignedExpressions", "[", "list", "]"}], ",", "opt"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TexView", "[", 
   RowBox[{"eq_Equal", ",", "opt___"}], "]"}], ":=", 
  RowBox[{"TexView", "[", 
   RowBox[{
    RowBox[{"TexPrintAlignedEquations", "[", "eq", "]"}], ",", "opt"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TexView", "[", 
   RowBox[{"expr_", ",", "opt___"}], "]"}], ":=", 
  RowBox[{"TexView", "[", 
   RowBox[{
    RowBox[{"AddEquationMarks", "[", 
     RowBox[{
      RowBox[{"TexPrint", "[", "expr", "]"}], ",", "Automatic"}], "]"}], ",", 
    "opt"}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.588082251163413*^9, 3.5880823173075294`*^9}, {
   3.588083110336922*^9, 3.58808318304865*^9}, {3.588314611279275*^9, 
   3.588314613244878*^9}, 3.588325925294613*^9, {3.5883260153379717`*^9, 
   3.588326016102372*^9}, {3.588326121418157*^9, 3.5883261307625747`*^9}, {
   3.588326438925515*^9, 3.588326735857436*^9}, {3.588327792401492*^9, 
   3.588327811885927*^9}, {3.591597869353045*^9, 3.5915978798330593`*^9}, {
   3.591597921613118*^9, 3.591597967563183*^9}},
 CellLabel->
  "In[421]:=",ExpressionUUID->"17dd8740-381a-4d90-8503-e6b6edc4df5c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TexPort", "[", 
    RowBox[{"expr_", ",", " ", "file_String"}], "]"}], ":=", 
   RowBox[{"TexView", "[", 
    RowBox[{"expr", ",", "file", ",", "False"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.61071469566193*^9, 3.6107147418119955`*^9}},
 CellLabel->
  "In[425]:=",ExpressionUUID->"35a177e7-b492-4b07-99e2-deda31264352"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["8. Color support", "Section",
 CellChangeTimes->{
  3.54501505147226*^9, {3.58807874622205*^9, 3.588078782258113*^9}, {
   3.5880831976346755`*^9, 3.588083198352277*^9}, {3.604593894578455*^9, 
   3.6045939032884674`*^9}, 3.619085217945934*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"c83f706e-9f0e-49b0-aa24-ab6d1cb6b55e"],

Cell[CellGroupData[{

Cell["8.1. EnableTexColor", "Subsection",
 CellChangeTimes->{{3.5880787928973327`*^9, 3.588078796485338*^9}, {
  3.588082648402511*^9, 3.588082648964112*^9}, {3.6045939062184715`*^9, 
  3.604593914038482*^9}, {3.646381545520738*^9, 
  3.646381545820739*^9}},ExpressionUUID->"5007de29-5958-4638-848c-\
c37120e2bec3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EnableTexColor", "[", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"TexColor", "[", 
       RowBox[{"str_", ",", "col_RGBColor"}], "]"}], ":=", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"\"\<\\\\textcolor[rgb]\>\"", ",", 
        RowBox[{"ToString", "[", 
         RowBox[{"List", "@@", 
          RowBox[{"(", "col", ")"}]}], "]"}], ",", "\"\<{\>\"", ",", "str", 
        ",", "\"\<}\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TexColor", "[", 
       RowBox[{"str_", ",", 
        RowBox[{
         RowBox[{"RGBColor", "[", 
          RowBox[{"1.`", ",", "0.`", ",", "0.`"}], "]"}], "|", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"1", ",", "0", ",", "0"}], "]"}]}]}], "]"}], ":=", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"\"\<\\\\red{\>\"", ",", "str", ",", "\"\<}\>\""}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TexColor", "[", 
       RowBox[{"str_", ",", 
        RowBox[{
         RowBox[{"RGBColor", "[", 
          RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "]"}], "|", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"0", ",", "1", ",", "0"}], "]"}]}]}], "]"}], ":=", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"\"\<\\\\green{\>\"", ",", "str", ",", "\"\<}\>\""}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TexColor", "[", 
       RowBox[{"str_", ",", 
        RowBox[{
         RowBox[{"RGBColor", "[", 
          RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "]"}], "|", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], "]"}], ":=", 
      RowBox[{"StringJoin", "[", 
       RowBox[{"\"\<\\\\blue{\>\"", ",", "str", ",", "\"\<}\>\""}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TexStyleBox", "[", 
       RowBox[{"str_", ",", "rules__"}], "]"}], ":=", 
      RowBox[{"TexColor", "[", 
       RowBox[{
        RowBox[{"Tex", "@", "str"}], ",", 
        RowBox[{"FontColor", "/.", 
         RowBox[{"{", "rules", "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"$TexInitLatexPackages", "=", 
      RowBox[{"DeleteDuplicates", "[", 
       RowBox[{"Append", "[", 
        RowBox[{"$TexInitLatexPackages", ",", "\"\<{color}\>\""}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"$TexInitLatexExtraCode", "=", 
      RowBox[{"DeleteDuplicates", "[", 
       RowBox[{"Join", "[", 
        RowBox[{"$TexInitLatexExtraCode", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\\\\newcommand{\\\\red}[1]{\\\\textcolor{red}{#1}}\>\"", ",", 
           "\"\<\\\\newcommand{\\\\green}[1]{\\\\textcolor{green}{#1}}\>\"", 
           ",", "\"\<\\\\newcommand{\\\\blue}[1]{\\\\textcolor{blue}{#1}}\>\"\
"}], "}"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", ")"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6006237472958574`*^9, 3.600623848865999*^9}, {
   3.600623905156078*^9, 3.600623908666083*^9}, {3.6045942175880237`*^9, 
   3.60459422245803*^9}, {3.646381579690786*^9, 3.646381581250788*^9}, {
   3.648207765247387*^9, 3.6482078106374516`*^9}, {3.648207861517522*^9, 
   3.648207870807535*^9}, {3.648208106887865*^9, 3.648208132097901*^9}, {
   3.697739021209951*^9, 3.697739034682969*^9}, {3.697821646749425*^9, 
   3.697821657161439*^9}, 3.697821761574587*^9, {3.7284817321414995`*^9, 
   3.728481842592291*^9}},
 CellLabel->
  "In[426]:=",ExpressionUUID->"4d278347-1d42-4be5-9493-ba483c1b313c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DisableTexColor", "[", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"TexStyleBox", "[", 
       RowBox[{"str_", ",", "rules__"}], "]"}], "=."}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"$TexInitLatexPackages", "=", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{"$TexInitLatexPackages", ",", "\"\<{color}\>\""}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"$TexInitLatexExtraCode", "=", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{"$TexInitLatexExtraCode", ",", 
        RowBox[{"Alternatives", "[", 
         RowBox[{
         "\"\<\\\\newcommand{\\\\red}[1]{\\\\textcolor{red}{#1}}\>\"", ",", 
          "\"\<\\\\newcommand{\\\\green}[1]{\\\\textcolor{green}{#1}}\>\"", 
          ",", "\"\<\\\\newcommand{\\\\blue}[1]{\\\\textcolor{blue}{#1}}\>\""}\
], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.6006237472958574`*^9, 3.600623848865999*^9}, {
   3.600623905156078*^9, 3.600623908666083*^9}, {3.604594118417884*^9, 
   3.604594150917929*^9}, {3.6045942288780394`*^9, 3.604594299628138*^9}, {
   3.6463815881707993`*^9, 3.6463815900408*^9}, {3.697739044784984*^9, 
   3.6977390499269915`*^9}, 3.697821856482721*^9, {3.728481858872007*^9, 
   3.728481862344906*^9}},
 CellLabel->
  "In[427]:=",ExpressionUUID->"0a4b9d9f-470d-4dd3-922c-85114e88ca12"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["9. EndPackage", "Section",
 CellChangeTimes->{3.54501505147226*^9, 3.5880787289840198`*^9, 
  3.604593933347625*^9, 3.6190852199059362`*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"f02c611a-d82e-4ed9-9f6f-aa6c0dce7f33"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"End", "[", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[428]:=",ExpressionUUID->"956c3d57-f836-45f7-a2ce-e62890309034"],

Cell[BoxData["\<\"xAct`TexAct`Private`\"\>"], "Output",
 CellChangeTimes->{
  3.6799839681683006`*^9, 3.679984667796675*^9, 3.6977391834071794`*^9, 
   3.697739238389258*^9, {3.715232888374369*^9, 3.715232891704328*^9}, {
   3.715233059117428*^9, 3.715233062992593*^9}, {3.715233740241826*^9, 
   3.715233743615815*^9}, 3.7273348968562636`*^9, 3.727335237071974*^9, 
   3.72733532950172*^9, 3.7273361416973667`*^9, 3.7273362334662733`*^9, 
   3.727336464254633*^9, 3.7273367344645777`*^9, 3.727337056479758*^9, 
   3.727340513282559*^9, 3.7273406215269175`*^9, 3.727340738142802*^9, 
   3.727341330540524*^9, 3.727342071499084*^9, 3.727343585178087*^9, 
   3.727343668321538*^9, 3.72734374810056*^9, 3.727343856288004*^9, 
   3.7274106447509785`*^9, 3.728277228608509*^9, 3.7282781621672497`*^9, 
   3.728278486650801*^9, {3.7282786046700754`*^9, 3.7282786270509453`*^9}, 
   3.728280517743761*^9, 3.728280821075986*^9, 3.7282809934057813`*^9, 
   3.728483764086788*^9, 3.728551303111999*^9, 3.728551797607067*^9, 
   3.72880456851626*^9, 3.72880469143029*^9, 3.728808517891513*^9, 
   3.7288088601602273`*^9, 3.777914010853797*^9, 3.7779140823067985`*^9, 
   3.791093796581772*^9, 3.791093947061208*^9, 3.820204746334073*^9, 
   3.8202072054641027`*^9, 3.820207363755953*^9, 3.842762463057044*^9, 
   3.844390003828904*^9, 3.844390075201609*^9, 3.8443906730697308`*^9, 
   3.8443910779599433`*^9, 3.875891573594741*^9, 3.8758919936681075`*^9, 
   3.921306829398737*^9, 3.921306904047333*^9, 3.9213069481513596`*^9, 
   3.9584003336742935`*^9},
 CellLabel->
  "Out[428]=",ExpressionUUID->"3ba72f90-f3aa-3140-86cd-4028297b2240"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"EndPackage", "[", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[429]:=",ExpressionUUID->"f8aa1644-62a2-47dc-88fc-e03f6c1b3121"]
}, Closed]],

Cell[CellGroupData[{

Cell["10. Examples", "Section",
 CellChangeTimes->{
  3.545015052985463*^9, 3.5880787314956236`*^9, 3.604593935877629*^9, {
   3.619085221365938*^9, 3.6190852216659384`*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"90b4b878-6f88-437a-ae3f-a22f6f598e1a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`xCoba`"}]], "Input",
 CellChangeTimes->{{3.583148963735118*^9, 3.5831489733759346`*^9}},
 CellLabel->
  "In[430]:=",ExpressionUUID->"c78137c7-ea58-4f47-9149-1d5b42229e0a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.583148973906336*^9, 3.5831499337590227`*^9, 3.583150018935172*^9, 
   3.5831501722990417`*^9, 3.583150223217531*^9, 3.583150271640016*^9, {
   3.5879651830710588`*^9, 3.587965203600695*^9}, 3.5880798723588276`*^9, 
   3.588079954820573*^9, 3.588080094737219*^9, 3.5880801467321095`*^9, 
   3.588080257835505*^9, 3.588082912762575*^9, 3.588083240550351*^9, 
   3.588083664995897*^9, 3.5883166146590753`*^9, 3.5883188320021696`*^9, 
   3.588319019311699*^9, 3.588319157496742*^9, 3.58832582664004*^9, 
   3.58832595771147*^9, 3.5883269163029547`*^9, 3.58832785960641*^9, 
   3.588327928901732*^9, 3.58832801880469*^9, 3.588328473171088*^9, 
   3.588328557333236*^9, 3.58832939672491*^9, {3.588329680099408*^9, 
   3.588329703561849*^9}, 3.588329911930414*^9, 3.6151308256568584`*^9, 
   3.6151310078864846`*^9, 3.6190891657500873`*^9, 3.619626214959157*^9, 
   3.6205425712485776`*^9, 3.646381709370968*^9, 3.6799839682582936`*^9, 
   3.679984667886676*^9, 3.6977391834971795`*^9, 3.697739238469258*^9, 
   3.715232891862967*^9, 3.715233063105138*^9, 3.715233743753194*^9, 
   3.727334897039752*^9, 3.7273352372191095`*^9, 3.72733532967316*^9, 
   3.727336141866218*^9, 3.727336233621789*^9, 3.727336464408347*^9, 
   3.727336734627359*^9, 3.7273370566486993`*^9, 3.727340513451593*^9, 
   3.727340621711337*^9, 3.7273407383091936`*^9, 3.7273413307937994`*^9, 
   3.7273420716612177`*^9, 3.727343585340404*^9, 3.7273436685160036`*^9, 
   3.7273437482567515`*^9, 3.727343856456883*^9, 3.727410644904662*^9, 
   3.7282772288249497`*^9, 3.72827816231894*^9, 3.728278486797973*^9, {
   3.728278604733077*^9, 3.7282786271775017`*^9}, 3.728280517868267*^9, 
   3.7282808212130456`*^9, 3.728280993552605*^9, 3.728483764308557*^9, 
   3.728551303233506*^9, 3.7285517977617207`*^9, 3.728804568621266*^9, 
   3.7288046915142946`*^9, 3.7288085181077847`*^9, 3.728808860313767*^9, 
   3.77791401113504*^9, 3.777914082509924*^9, 3.791093796934308*^9, 
   3.791093947300762*^9, 3.820204746426831*^9, 3.8202072055478554`*^9, 
   3.8202073638197775`*^9, 3.8427624631517887`*^9, 3.844390003925645*^9, 
   3.844390075289376*^9, 3.8443906731754475`*^9, 3.84439107805372*^9, 
   3.8758915737443075`*^9, 3.875891993742882*^9, 3.9213068295084457`*^9, 
   3.9213069041330757`*^9, 3.921306948278019*^9, 3.958400333841488*^9},
 CellLabel->
  "During evaluation of \
In[430]:=",ExpressionUUID->"3b91f2c7-12b6-614f-985a-04c3a23d992d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.6", ", ", {2021, 2, 28}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583148973906336*^9, 3.5831499337590227`*^9, 3.583150018935172*^9, 
   3.5831501722990417`*^9, 3.583150223217531*^9, 3.583150271640016*^9, {
   3.5879651830710588`*^9, 3.587965203600695*^9}, 3.5880798723588276`*^9, 
   3.588079954820573*^9, 3.588080094737219*^9, 3.5880801467321095`*^9, 
   3.588080257835505*^9, 3.588082912762575*^9, 3.588083240550351*^9, 
   3.588083664995897*^9, 3.5883166146590753`*^9, 3.5883188320021696`*^9, 
   3.588319019311699*^9, 3.588319157496742*^9, 3.58832582664004*^9, 
   3.58832595771147*^9, 3.5883269163029547`*^9, 3.58832785960641*^9, 
   3.588327928901732*^9, 3.58832801880469*^9, 3.588328473171088*^9, 
   3.588328557333236*^9, 3.58832939672491*^9, {3.588329680099408*^9, 
   3.588329703561849*^9}, 3.588329911930414*^9, 3.6151308256568584`*^9, 
   3.6151310078864846`*^9, 3.6190891657500873`*^9, 3.619626214959157*^9, 
   3.6205425712485776`*^9, 3.646381709370968*^9, 3.6799839682582936`*^9, 
   3.679984667886676*^9, 3.6977391834971795`*^9, 3.697739238469258*^9, 
   3.715232891862967*^9, 3.715233063105138*^9, 3.715233743753194*^9, 
   3.727334897039752*^9, 3.7273352372191095`*^9, 3.72733532967316*^9, 
   3.727336141866218*^9, 3.727336233621789*^9, 3.727336464408347*^9, 
   3.727336734627359*^9, 3.7273370566486993`*^9, 3.727340513451593*^9, 
   3.727340621711337*^9, 3.7273407383091936`*^9, 3.7273413307937994`*^9, 
   3.7273420716612177`*^9, 3.727343585340404*^9, 3.7273436685160036`*^9, 
   3.7273437482567515`*^9, 3.727343856456883*^9, 3.727410644904662*^9, 
   3.7282772288249497`*^9, 3.72827816231894*^9, 3.728278486797973*^9, {
   3.728278604733077*^9, 3.7282786271775017`*^9}, 3.728280517868267*^9, 
   3.7282808212130456`*^9, 3.728280993552605*^9, 3.728483764308557*^9, 
   3.728551303233506*^9, 3.7285517977617207`*^9, 3.728804568621266*^9, 
   3.7288046915142946`*^9, 3.7288085181077847`*^9, 3.728808860313767*^9, 
   3.77791401113504*^9, 3.777914082509924*^9, 3.791093796934308*^9, 
   3.791093947300762*^9, 3.820204746426831*^9, 3.8202072055478554`*^9, 
   3.8202073638197775`*^9, 3.8427624631517887`*^9, 3.844390003925645*^9, 
   3.844390075289376*^9, 3.8443906731754475`*^9, 3.84439107805372*^9, 
   3.8758915737443075`*^9, 3.875891993742882*^9, 3.9213068295084457`*^9, 
   3.9213069041330757`*^9, 3.921306948278019*^9, 3.958400333841488*^9},
 CellLabel->
  "During evaluation of \
In[430]:=",ExpressionUUID->"3fd6df29-38e2-2e41-9088-4f5626fa9166"],

Cell[BoxData["\<\"CopyRight (C) 2005-2021, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.583148973906336*^9, 3.5831499337590227`*^9, 3.583150018935172*^9, 
   3.5831501722990417`*^9, 3.583150223217531*^9, 3.583150271640016*^9, {
   3.5879651830710588`*^9, 3.587965203600695*^9}, 3.5880798723588276`*^9, 
   3.588079954820573*^9, 3.588080094737219*^9, 3.5880801467321095`*^9, 
   3.588080257835505*^9, 3.588082912762575*^9, 3.588083240550351*^9, 
   3.588083664995897*^9, 3.5883166146590753`*^9, 3.5883188320021696`*^9, 
   3.588319019311699*^9, 3.588319157496742*^9, 3.58832582664004*^9, 
   3.58832595771147*^9, 3.5883269163029547`*^9, 3.58832785960641*^9, 
   3.588327928901732*^9, 3.58832801880469*^9, 3.588328473171088*^9, 
   3.588328557333236*^9, 3.58832939672491*^9, {3.588329680099408*^9, 
   3.588329703561849*^9}, 3.588329911930414*^9, 3.6151308256568584`*^9, 
   3.6151310078864846`*^9, 3.6190891657500873`*^9, 3.619626214959157*^9, 
   3.6205425712485776`*^9, 3.646381709370968*^9, 3.6799839682582936`*^9, 
   3.679984667886676*^9, 3.6977391834971795`*^9, 3.697739238469258*^9, 
   3.715232891862967*^9, 3.715233063105138*^9, 3.715233743753194*^9, 
   3.727334897039752*^9, 3.7273352372191095`*^9, 3.72733532967316*^9, 
   3.727336141866218*^9, 3.727336233621789*^9, 3.727336464408347*^9, 
   3.727336734627359*^9, 3.7273370566486993`*^9, 3.727340513451593*^9, 
   3.727340621711337*^9, 3.7273407383091936`*^9, 3.7273413307937994`*^9, 
   3.7273420716612177`*^9, 3.727343585340404*^9, 3.7273436685160036`*^9, 
   3.7273437482567515`*^9, 3.727343856456883*^9, 3.727410644904662*^9, 
   3.7282772288249497`*^9, 3.72827816231894*^9, 3.728278486797973*^9, {
   3.728278604733077*^9, 3.7282786271775017`*^9}, 3.728280517868267*^9, 
   3.7282808212130456`*^9, 3.728280993552605*^9, 3.728483764308557*^9, 
   3.728551303233506*^9, 3.7285517977617207`*^9, 3.728804568621266*^9, 
   3.7288046915142946`*^9, 3.7288085181077847`*^9, 3.728808860313767*^9, 
   3.77791401113504*^9, 3.777914082509924*^9, 3.791093796934308*^9, 
   3.791093947300762*^9, 3.820204746426831*^9, 3.8202072055478554`*^9, 
   3.8202073638197775`*^9, 3.8427624631517887`*^9, 3.844390003925645*^9, 
   3.844390075289376*^9, 3.8443906731754475`*^9, 3.84439107805372*^9, 
   3.8758915737443075`*^9, 3.875891993742882*^9, 3.9213068295084457`*^9, 
   3.9213069041330757`*^9, 3.921306948278019*^9, 3.958400333857601*^9},
 CellLabel->
  "During evaluation of \
In[430]:=",ExpressionUUID->"ee715bd7-c332-5740-aa44-b2bdc7ac8834"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.583148973906336*^9, 3.5831499337590227`*^9, 3.583150018935172*^9, 
   3.5831501722990417`*^9, 3.583150223217531*^9, 3.583150271640016*^9, {
   3.5879651830710588`*^9, 3.587965203600695*^9}, 3.5880798723588276`*^9, 
   3.588079954820573*^9, 3.588080094737219*^9, 3.5880801467321095`*^9, 
   3.588080257835505*^9, 3.588082912762575*^9, 3.588083240550351*^9, 
   3.588083664995897*^9, 3.5883166146590753`*^9, 3.5883188320021696`*^9, 
   3.588319019311699*^9, 3.588319157496742*^9, 3.58832582664004*^9, 
   3.58832595771147*^9, 3.5883269163029547`*^9, 3.58832785960641*^9, 
   3.588327928901732*^9, 3.58832801880469*^9, 3.588328473171088*^9, 
   3.588328557333236*^9, 3.58832939672491*^9, {3.588329680099408*^9, 
   3.588329703561849*^9}, 3.588329911930414*^9, 3.6151308256568584`*^9, 
   3.6151310078864846`*^9, 3.6190891657500873`*^9, 3.619626214959157*^9, 
   3.6205425712485776`*^9, 3.646381709370968*^9, 3.6799839682582936`*^9, 
   3.679984667886676*^9, 3.6977391834971795`*^9, 3.697739238469258*^9, 
   3.715232891862967*^9, 3.715233063105138*^9, 3.715233743753194*^9, 
   3.727334897039752*^9, 3.7273352372191095`*^9, 3.72733532967316*^9, 
   3.727336141866218*^9, 3.727336233621789*^9, 3.727336464408347*^9, 
   3.727336734627359*^9, 3.7273370566486993`*^9, 3.727340513451593*^9, 
   3.727340621711337*^9, 3.7273407383091936`*^9, 3.7273413307937994`*^9, 
   3.7273420716612177`*^9, 3.727343585340404*^9, 3.7273436685160036`*^9, 
   3.7273437482567515`*^9, 3.727343856456883*^9, 3.727410644904662*^9, 
   3.7282772288249497`*^9, 3.72827816231894*^9, 3.728278486797973*^9, {
   3.728278604733077*^9, 3.7282786271775017`*^9}, 3.728280517868267*^9, 
   3.7282808212130456`*^9, 3.728280993552605*^9, 3.728483764308557*^9, 
   3.728551303233506*^9, 3.7285517977617207`*^9, 3.728804568621266*^9, 
   3.7288046915142946`*^9, 3.7288085181077847`*^9, 3.728808860313767*^9, 
   3.77791401113504*^9, 3.777914082509924*^9, 3.791093796934308*^9, 
   3.791093947300762*^9, 3.820204746426831*^9, 3.8202072055478554`*^9, 
   3.8202073638197775`*^9, 3.8427624631517887`*^9, 3.844390003925645*^9, 
   3.844390075289376*^9, 3.8443906731754475`*^9, 3.84439107805372*^9, 
   3.8758915737443075`*^9, 3.875891993742882*^9, 3.9213068295084457`*^9, 
   3.9213069041330757`*^9, 3.921306948278019*^9, 3.9584003338732624`*^9},
 CellLabel->
  "During evaluation of \
In[430]:=",ExpressionUUID->"e9a82743-c2e2-294b-9c42-cca6770f942b"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{
  3.583148973906336*^9, 3.5831499337590227`*^9, 3.583150018935172*^9, 
   3.5831501722990417`*^9, 3.583150223217531*^9, 3.583150271640016*^9, {
   3.5879651830710588`*^9, 3.587965203600695*^9}, 3.5880798723588276`*^9, 
   3.588079954820573*^9, 3.588080094737219*^9, 3.5880801467321095`*^9, 
   3.588080257835505*^9, 3.588082912762575*^9, 3.588083240550351*^9, 
   3.588083664995897*^9, 3.5883166146590753`*^9, 3.5883188320021696`*^9, 
   3.588319019311699*^9, 3.588319157496742*^9, 3.58832582664004*^9, 
   3.58832595771147*^9, 3.5883269163029547`*^9, 3.58832785960641*^9, 
   3.588327928901732*^9, 3.58832801880469*^9, 3.588328473171088*^9, 
   3.588328557333236*^9, 3.58832939672491*^9, {3.588329680099408*^9, 
   3.588329703561849*^9}, 3.588329911930414*^9, 3.6151308256568584`*^9, 
   3.6151310078864846`*^9, 3.6190891657500873`*^9, 3.619626214959157*^9, 
   3.6205425712485776`*^9, 3.646381709370968*^9, 3.6799839682582936`*^9, 
   3.679984667886676*^9, 3.6977391834971795`*^9, 3.697739238469258*^9, 
   3.715232891862967*^9, 3.715233063105138*^9, 3.715233743753194*^9, 
   3.727334897039752*^9, 3.7273352372191095`*^9, 3.72733532967316*^9, 
   3.727336141866218*^9, 3.727336233621789*^9, 3.727336464408347*^9, 
   3.727336734627359*^9, 3.7273370566486993`*^9, 3.727340513451593*^9, 
   3.727340621711337*^9, 3.7273407383091936`*^9, 3.7273413307937994`*^9, 
   3.7273420716612177`*^9, 3.727343585340404*^9, 3.7273436685160036`*^9, 
   3.7273437482567515`*^9, 3.727343856456883*^9, 3.727410644904662*^9, 
   3.7282772288249497`*^9, 3.72827816231894*^9, 3.728278486797973*^9, {
   3.728278604733077*^9, 3.7282786271775017`*^9}, 3.728280517868267*^9, 
   3.7282808212130456`*^9, 3.728280993552605*^9, 3.728483764308557*^9, 
   3.728551303233506*^9, 3.7285517977617207`*^9, 3.728804568621266*^9, 
   3.7288046915142946`*^9, 3.7288085181077847`*^9, 3.728808860313767*^9, 
   3.77791401113504*^9, 3.777914082509924*^9, 3.791093796934308*^9, 
   3.791093947300762*^9, 3.820204746426831*^9, 3.8202072055478554`*^9, 
   3.8202073638197775`*^9, 3.8427624631517887`*^9, 3.844390003925645*^9, 
   3.844390075289376*^9, 3.8443906731754475`*^9, 3.84439107805372*^9, 
   3.8758915737443075`*^9, 3.875891993742882*^9, 3.9213068295084457`*^9, 
   3.9213069041330757`*^9, 3.921306948278019*^9, 3.9584003338732624`*^9},
 CellLabel->
  "During evaluation of \
In[430]:=",ExpressionUUID->"5b544673-686d-ba41-8604-9397652ea05a"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.583148973906336*^9, 3.5831499337590227`*^9, 3.583150018935172*^9, 
   3.5831501722990417`*^9, 3.583150223217531*^9, 3.583150271640016*^9, {
   3.5879651830710588`*^9, 3.587965203600695*^9}, 3.5880798723588276`*^9, 
   3.588079954820573*^9, 3.588080094737219*^9, 3.5880801467321095`*^9, 
   3.588080257835505*^9, 3.588082912762575*^9, 3.588083240550351*^9, 
   3.588083664995897*^9, 3.5883166146590753`*^9, 3.5883188320021696`*^9, 
   3.588319019311699*^9, 3.588319157496742*^9, 3.58832582664004*^9, 
   3.58832595771147*^9, 3.5883269163029547`*^9, 3.58832785960641*^9, 
   3.588327928901732*^9, 3.58832801880469*^9, 3.588328473171088*^9, 
   3.588328557333236*^9, 3.58832939672491*^9, {3.588329680099408*^9, 
   3.588329703561849*^9}, 3.588329911930414*^9, 3.6151308256568584`*^9, 
   3.6151310078864846`*^9, 3.6190891657500873`*^9, 3.619626214959157*^9, 
   3.6205425712485776`*^9, 3.646381709370968*^9, 3.6799839682582936`*^9, 
   3.679984667886676*^9, 3.6977391834971795`*^9, 3.697739238469258*^9, 
   3.715232891862967*^9, 3.715233063105138*^9, 3.715233743753194*^9, 
   3.727334897039752*^9, 3.7273352372191095`*^9, 3.72733532967316*^9, 
   3.727336141866218*^9, 3.727336233621789*^9, 3.727336464408347*^9, 
   3.727336734627359*^9, 3.7273370566486993`*^9, 3.727340513451593*^9, 
   3.727340621711337*^9, 3.7273407383091936`*^9, 3.7273413307937994`*^9, 
   3.7273420716612177`*^9, 3.727343585340404*^9, 3.7273436685160036`*^9, 
   3.7273437482567515`*^9, 3.727343856456883*^9, 3.727410644904662*^9, 
   3.7282772288249497`*^9, 3.72827816231894*^9, 3.728278486797973*^9, {
   3.728278604733077*^9, 3.7282786271775017`*^9}, 3.728280517868267*^9, 
   3.7282808212130456`*^9, 3.728280993552605*^9, 3.728483764308557*^9, 
   3.728551303233506*^9, 3.7285517977617207`*^9, 3.728804568621266*^9, 
   3.7288046915142946`*^9, 3.7288085181077847`*^9, 3.728808860313767*^9, 
   3.77791401113504*^9, 3.777914082509924*^9, 3.791093796934308*^9, 
   3.791093947300762*^9, 3.820204746426831*^9, 3.8202072055478554`*^9, 
   3.8202073638197775`*^9, 3.8427624631517887`*^9, 3.844390003925645*^9, 
   3.844390075289376*^9, 3.8443906731754475`*^9, 3.84439107805372*^9, 
   3.8758915737443075`*^9, 3.875891993742882*^9, 3.9213068295084457`*^9, 
   3.9213069041330757`*^9, 3.921306948278019*^9, 3.9584003338732624`*^9},
 CellLabel->
  "During evaluation of \
In[430]:=",ExpressionUUID->"89188b92-a11a-bc4f-9846-7239c60917d6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M4", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[431]:=",ExpressionUUID->"c7dc0213-a85d-438d-9425-2b9e8e705088"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M4, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627431072*^9, 3.728280559973854*^9, 
  3.728280821428749*^9, 3.7282809937530413`*^9, 3.728483764655834*^9, 
  3.728551303581435*^9, 3.72855179806244*^9, 3.728804568922283*^9, 
  3.7288046917163076`*^9, 3.72880851835988*^9, 3.728808860545308*^9, 
  3.7779140121922836`*^9, 3.7779140829616976`*^9, 3.791093797736255*^9, 
  3.791093948016263*^9, 3.8202047468038216`*^9, 3.820207205801937*^9, 
  3.820207296642863*^9, 3.820207364032209*^9, 3.842762463455974*^9, 
  3.844390004256788*^9, 3.844390075603538*^9, 3.844390673466668*^9, 
  3.8443910783180118`*^9, 3.875891574899248*^9, 3.8758919941757503`*^9, 
  3.9213068321154995`*^9, 3.921306906317232*^9, 3.9213069493511486`*^9, 
  3.9584003366489105`*^9},
 CellLabel->
  "During evaluation of \
In[431]:=",ExpressionUUID->"ccac885d-afb6-1547-9975-0600c6588373"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM4, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627431072*^9, 3.728280559973854*^9, 
  3.728280821428749*^9, 3.7282809937530413`*^9, 3.728483764655834*^9, 
  3.728551303581435*^9, 3.72855179806244*^9, 3.728804568922283*^9, 
  3.7288046917163076`*^9, 3.72880851835988*^9, 3.728808860545308*^9, 
  3.7779140121922836`*^9, 3.7779140829616976`*^9, 3.791093797736255*^9, 
  3.791093948016263*^9, 3.8202047468038216`*^9, 3.820207205801937*^9, 
  3.820207296642863*^9, 3.820207364032209*^9, 3.842762463455974*^9, 
  3.844390004256788*^9, 3.844390075603538*^9, 3.844390673466668*^9, 
  3.8443910783180118`*^9, 3.875891574899248*^9, 3.8758919941757503`*^9, 
  3.9213068321154995`*^9, 3.921306906317232*^9, 3.9213069493511486`*^9, 
  3.9584003366489105`*^9},
 CellLabel->
  "During evaluation of \
In[431]:=",ExpressionUUID->"a6d687c5-4e78-824a-97d9-71f024235ffc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "M4", ",", 
   RowBox[{"PrintAs", "->", "\"\<\[Tau]\>\""}]}], "]"}]], "Input",
 CellLabel->
  "In[432]:=",ExpressionUUID->"96088e1c-a166-4560-88bb-a2afb78ed650"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[$CellContext`a, $CellContext`b, $CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7282786274467*^9, 3.728280560010155*^9, 
  3.72828082144393*^9, 3.7282809937776065`*^9, 3.728483764671459*^9, 
  3.728551303597429*^9, 3.728551798084587*^9, 3.728804568936284*^9, 
  3.728804691735308*^9, 3.7288085183756213`*^9, 3.728808860560909*^9, 
  3.7779140122573247`*^9, 3.777914082992988*^9, 3.791093797836091*^9, 
  3.79109394811785*^9, 3.8202047468437552`*^9, 3.8202072058487825`*^9, 
  3.820207296691759*^9, 3.820207364064129*^9, 3.8427624634968376`*^9, 
  3.8443900043046308`*^9, 3.844390075643401*^9, 3.8443906735105515`*^9, 
  3.844391078353887*^9, 3.875891574930137*^9, 3.875891994196701*^9, 
  3.9213068321473827`*^9, 3.921306906354189*^9, 3.921306949391041*^9, 
  3.958400336680464*^9},
 CellLabel->
  "During evaluation of \
In[432]:=",ExpressionUUID->"a8296c56-e35d-924c-9b1f-a547cd5b05cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], 
    RowBox[{"T", "[", 
     RowBox[{"a", ",", 
      RowBox[{"-", "b"}], ",", "c"}], "]"}]}], "+", 
   RowBox[{"7", 
    RowBox[{"T", "[", 
     RowBox[{"d", ",", "f"}], "]"}]}], "+", 
   RowBox[{"Pi", " ", 
    RowBox[{"T", "[", 
     RowBox[{"g", ",", "f"}], "]"}]}], "-", "5"}]}]], "Input",
 CellChangeTimes->{{3.588080595061298*^9, 3.588080596200099*^9}},
 CellLabel->
  "In[433]:=",ExpressionUUID->"2e6dbc83-b7e0-418a-9d37-64e5e2d14dde"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "5"}], "+", 
  RowBox[{"7", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"d", "f"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[$CellContext`d, $CellContext`f],
    Editable->False]}], "+", 
  RowBox[{"\[Pi]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"g", "f"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[$CellContext`g, $CellContext`f],
    Editable->False]}], "-", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"a", " ", "c"},
           {" ", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[$CellContext`a, -$CellContext`b, $CellContext`c],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.582347795935917*^9, 3.582353854395651*^9, 3.582353967264056*^9, 
   3.583130720657423*^9, 3.5831330405696983`*^9, 3.583133120675839*^9, 
   3.58313319535417*^9, 3.583133302276758*^9, 3.583133334288014*^9, 
   3.583135199022689*^9, 3.5831353246185093`*^9, 3.583138083516556*^9, 
   3.5831382086609764`*^9, 3.58314655103288*^9, 3.583146622371805*^9, 
   3.583146828198567*^9, {3.583147370035319*^9, 3.583147396414965*^9}, 
   3.583148786565607*^9, 3.5831499339462223`*^9, 3.583150019028773*^9, 
   3.583150172392641*^9, 3.583150223357931*^9, 3.583150271733616*^9, {
   3.587965183258259*^9, 3.587965203709895*^9}, 3.588079872468028*^9, 
   3.588079955397774*^9, 3.5880800109338713`*^9, 3.588080094830818*^9, 
   3.588080169991751*^9, 3.588080257975905*^9, 3.5880805969489*^9, 
   3.588082936037816*^9, 3.588083240690751*^9, 3.5880836884271383`*^9, 
   3.588316614799475*^9, 3.58831884318739*^9, 3.588319019420899*^9, 
   3.5883191688067617`*^9, 3.5883258267180395`*^9, 3.58832595800787*^9, 
   3.588326916396554*^9, 3.58832785976241*^9, 3.588327928948532*^9, 
   3.5883280188982897`*^9, 3.588328473264688*^9, 3.588328557426836*^9, 
   3.588329396771711*^9, {3.588329680271008*^9, 3.588329703655449*^9}, 
   3.588329912024014*^9, 3.615130825796859*^9, 3.615131007964484*^9, 
   3.6190891658300877`*^9, 3.6196262152591577`*^9, 3.620542571418578*^9, 
   3.6463817095709686`*^9, 3.6799839684882755`*^9, 3.679984668106678*^9, 
   3.69773918367718*^9, 3.697739238719258*^9, 3.715232892131934*^9, 
   3.715233063570777*^9, 3.715233744047858*^9, 3.727334897409481*^9, 
   3.7273352375199776`*^9, 3.7273353299404783`*^9, 3.7273361421822643`*^9, 
   3.727336233919769*^9, 3.727336464708406*^9, 3.7273367349282694`*^9, 
   3.727337056926493*^9, 3.727340513811468*^9, 3.727340622081101*^9, 
   3.72734073865704*^9, 3.72734133142532*^9, 3.727342071956558*^9, 
   3.727343585657004*^9, 3.727343668800858*^9, 3.7273437485728703`*^9, 
   3.7273438567567234`*^9, 3.727410645204775*^9, 3.728277229094133*^9, 
   3.728278162581413*^9, 3.7282784870672245`*^9, {3.7282786048705244`*^9, 
   3.728278627481431*^9}, 3.728280560010155*^9, 3.728280821459583*^9, 
   3.728280993809001*^9, 3.728483764687113*^9, 3.728551303644307*^9, 
   3.728551798100217*^9, 3.728804568949285*^9, 3.72880469177031*^9, 
   3.728808518391254*^9, 3.728808860576535*^9, 3.7779140123979616`*^9, 
   3.7779140830398192`*^9, 3.791093797967651*^9, 3.791093948201014*^9, 
   3.820204746885635*^9, 3.820207205901114*^9, 3.820207296734617*^9, 
   3.8202073640970354`*^9, 3.8427624635247626`*^9, 3.8443900043385677`*^9, 
   3.844390075680303*^9, 3.844390673522519*^9, 3.8443910783897934`*^9, 
   3.8758915749520793`*^9, 3.875891994212653*^9, 3.9213068321733437`*^9, 
   3.9213069063851624`*^9, 3.9213069494110165`*^9, 3.9584003366961365`*^9},
 CellLabel->
  "Out[433]=",ExpressionUUID->"6206b129-07c4-544e-a3a6-f4458f6badb3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tex", "[", "expr1", "]"}]], "Input",
 CellChangeTimes->{3.588080601706909*^9},
 CellLabel->
  "In[434]:=",ExpressionUUID->"609c8ba4-39a5-46fd-8c20-ff398264d12c"],

Cell[BoxData["\<\"-5 + 7 \\\\tau ^{df} + \\\\pi \\\\tau ^{gf} + -3 \\\\tau \
^{a}{}_{b}{}^{c}\"\>"], "Output",
 CellChangeTimes->{
  3.5823477959983172`*^9, 3.582353854442451*^9, 3.582353967310857*^9, 
   3.5831307207042236`*^9, 3.5831330407412987`*^9, 3.583133120722638*^9, 
   3.58313319540097*^9, 3.583133302339157*^9, 3.5831333343348136`*^9, 
   3.583135199163089*^9, 3.58313532466531*^9, 3.583138083734956*^9, 
   3.583138208707775*^9, 3.583146551079681*^9, 3.583146622418606*^9, 
   3.583146828245367*^9, {3.583147370050919*^9, 3.583147396446165*^9}, 
   3.5831487866124077`*^9, 3.583149933993023*^9, 3.583150019075572*^9, 
   3.583150172455042*^9, 3.583150223404731*^9, 3.583150271780416*^9, {
   3.5879651833050594`*^9, 3.5879652037566957`*^9}, 3.588079872530428*^9, 
   3.588079955990575*^9, 3.588080014007077*^9, 3.588080094877619*^9, 
   3.5880801700385504`*^9, 3.588080258022705*^9, 3.58808060209691*^9, 
   3.5880829360846157`*^9, 3.588083240753151*^9, 3.588083688489538*^9, 
   3.5883166148618755`*^9, 3.5883188432497897`*^9, 3.5883190194832993`*^9, 
   3.5883191688691616`*^9, 3.5883258267648396`*^9, 3.588325958054671*^9, 
   3.5883269164433546`*^9, 3.588327859809211*^9, 3.588327928995332*^9, 
   3.5883280189450912`*^9, 3.588328473311488*^9, 3.588328557473636*^9, 
   3.58832939681851*^9, {3.588329680286608*^9, 3.5883297037022495`*^9}, 
   3.5883299120864153`*^9, 3.615130825816859*^9, 3.6151310079956846`*^9, 
   3.6190891658600874`*^9, 3.619626215279157*^9, 3.620542571438578*^9, 
   3.646381709600968*^9, 3.679983968538271*^9, 3.6799846681366796`*^9, 
   3.69773918370718*^9, 3.697739238749258*^9, 3.7152328921935062`*^9, 
   3.715233063620468*^9, 3.715233744112026*^9, 3.727334897478544*^9, 
   3.7273352375577335`*^9, 3.727335330077028*^9, 3.727336142220005*^9, 
   3.727336233982275*^9, 3.7273364647925596`*^9, 3.727336734981727*^9, 
   3.727337056995055*^9, 3.727340513859456*^9, 3.727340622145376*^9, 
   3.727340738710466*^9, 3.7273413317096577`*^9, 3.7273420720149946`*^9, 
   3.72734358574118*^9, 3.7273436688386374`*^9, 3.727343748641381*^9, 
   3.727343856834857*^9, 3.727410645236029*^9, 3.728277229125388*^9, 
   3.7282781626191273`*^9, 3.7282784870984745`*^9, {3.728278604886177*^9, 
   3.7282786275157385`*^9}, 3.7282805600449476`*^9, 3.728280821497406*^9, 
   3.72828099384028*^9, 3.728483764708734*^9, 3.728551303682081*^9, 
   3.728551798147122*^9, 3.728804568973286*^9, 3.728804691790311*^9, 
   3.728808518411573*^9, 3.728808860614311*^9, 3.7779140124760723`*^9, 
   3.777914083102323*^9, 3.791093798136495*^9, 3.791093948316966*^9, 
   3.820204746925576*^9, 3.8202072059499817`*^9, 3.820207296770548*^9, 
   3.820207364127988*^9, 3.8427624635497227`*^9, 3.844390004372477*^9, 
   3.8443900757132144`*^9, 3.844390673550468*^9, 3.844391078421706*^9, 
   3.8758915749740477`*^9, 3.87589199422861*^9, 3.921306832207222*^9, 
   3.9213069064180737`*^9, 3.921306949427973*^9, 3.958400336743273*^9},
 CellLabel->
  "Out[434]=",ExpressionUUID->"989851ad-fc43-5c44-b9ca-bf531ec9e284"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "[", "expr1", "]"}]], "Input",
 CellChangeTimes->{3.588080603656912*^9},
 CellLabel->
  "In[435]:=",ExpressionUUID->"4dbd6ef9-b536-470c-832d-852de568924b"],

Cell[BoxData["\<\"-5 + 7 \\\\tau^{df} + \\\\pi \\\\tau^{gf} - 3 \
\\\\tau^{a}{}_{b}{}^{c}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796029517*^9, 3.582353854473651*^9, 3.582353967326456*^9, 
   3.583130720735423*^9, 3.583133040772498*^9, 3.583133120738239*^9, 
   3.58313319546337*^9, 3.5831333023547583`*^9, 3.583133334366014*^9, 
   3.583135199178689*^9, 3.5831353246809096`*^9, 3.583138083906556*^9, 
   3.5831382087233763`*^9, 3.58314655109528*^9, 3.583146622434205*^9, 
   3.583146828260968*^9, {3.583147370066519*^9, 3.583147396477366*^9}, 
   3.583148786628007*^9, 3.583149934008623*^9, 3.583150019106773*^9, 
   3.5831501724706416`*^9, 3.583150223435931*^9, 3.5831502717960167`*^9, {
   3.5879651833362594`*^9, 3.587965203772295*^9}, 3.588079872546028*^9, 
   3.5880799560529757`*^9, 3.588080017907084*^9, 3.588080094908818*^9, 
   3.5880801700541506`*^9, 3.588080258053906*^9, {3.5880806040001125`*^9, 
   3.588080614311731*^9}, 3.588082936100216*^9, 3.588083240768751*^9, 
   3.588083688520738*^9, 3.588316614877476*^9, 3.5883188432653894`*^9, 
   3.588319019498899*^9, 3.588319168900362*^9, 3.58832582679604*^9, 
   3.588325958070271*^9, 3.588326916458954*^9, 3.588327859824811*^9, 
   3.588327929010932*^9, 3.58832801897629*^9, 3.588328473342688*^9, 
   3.588328557489236*^9, 3.588329396849711*^9, {3.588329680302208*^9, 
   3.5883297037178497`*^9}, 3.588329912102015*^9, 3.6151308258268585`*^9, 
   3.615131008011284*^9, 3.619089165870087*^9, 3.619626215289158*^9, 
   3.620542571448578*^9, 3.646381709610968*^9, 3.67998396854827*^9, 
   3.6799846681566796`*^9, 3.69773918371718*^9, 3.697739238759258*^9, 
   3.715232892228618*^9, 3.71523306367207*^9, 3.715233744178113*^9, 
   3.727334897541051*^9, 3.727335237588994*^9, 3.727335330141044*^9, 
   3.7273361422668867`*^9, 3.727336234035709*^9, 3.727336464823847*^9, 
   3.727336735015167*^9, 3.727337057010683*^9, 3.727340513895255*^9, 
   3.727340622181261*^9, 3.7273407387260985`*^9, 3.7273413317419586`*^9, 
   3.7273420720306206`*^9, 3.727343585756807*^9, 3.727343668869911*^9, 
   3.727343748672635*^9, 3.727343856919572*^9, 3.7274106452516756`*^9, 
   3.728277229141034*^9, 3.72827816265038*^9, 3.728278487131236*^9, {
   3.7282786049017787`*^9, 3.728278627546993*^9}, 3.728280560060599*^9, 
   3.728280821513037*^9, 3.7282809938559065`*^9, 3.728483764708734*^9, 
   3.728551303697711*^9, 3.7285517981627436`*^9, 3.7288045689842873`*^9, 
   3.728804691806312*^9, 3.72880851842723*^9, 3.7288088606299515`*^9, 
   3.777914012538605*^9, 3.777914083274195*^9, 3.791093798221165*^9, 
   3.791093948394723*^9, 3.820204746970408*^9, 3.82020720599187*^9, 
   3.82020729680842*^9, 3.820207364158901*^9, 3.842762463578619*^9, 
   3.844390004403394*^9, 3.844390075724185*^9, 3.844390673580365*^9, 
   3.8443910784566145`*^9, 3.875891574994964*^9, 3.875891994243542*^9, 
   3.921306832231159*^9, 3.921306906447994*^9, 3.9213069494458942`*^9, 
   3.9584003367592735`*^9},
 CellLabel->
  "Out[435]=",ExpressionUUID->"34a6e24a-ff86-584a-87dc-11a41f64ffc7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddEquationMarks", "[", 
  RowBox[{"%", ",", "\"\<equation*\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.5880800203406878`*^9, 3.5880800338503118`*^9}, {
   3.5880801756857605`*^9, 3.5880801890705843`*^9}, {3.588080606589717*^9, 
   3.588080613048129*^9}, 3.58808289876935*^9},
 CellLabel->
  "In[436]:=",ExpressionUUID->"4788f72c-1008-427a-a7c3-423661efdafa"],

Cell[BoxData["\<\"\\\\begin{equation*}\\n-5 + 7 \\\\tau^{df} + \\\\pi \
\\\\tau^{gf} - 3 \\\\tau^{a}{}_{b}{}^{c}\\n\\\\end{equation*}\\n\"\>"], \
"Output",
 CellChangeTimes->{
  3.588080190084586*^9, 3.588080258069505*^9, {3.588080607229319*^9, 
   3.5880806149201317`*^9}, 3.588082938128219*^9, 3.588083257585581*^9, 
   3.588083688583138*^9, 3.588316614893076*^9, 3.5883188432809896`*^9, 
   3.588319019514499*^9, 3.5883191689159617`*^9, 3.58832582679604*^9, 
   3.588325958085871*^9, 3.588326916474554*^9, 3.5883278598404117`*^9, 
   3.588327929026532*^9, 3.58832801897629*^9, 3.588328473342688*^9, 
   3.588328557504836*^9, 3.588329396849711*^9, {3.588329680317808*^9, 
   3.588329703733449*^9}, 3.5883299121176157`*^9, 3.615130825836859*^9, 
   3.615131008011284*^9, 3.619089165870087*^9, 3.619626215289158*^9, 
   3.620542571458578*^9, 3.646381709630968*^9, 3.679983968558269*^9, 
   3.679984668166679*^9, 3.69773918372718*^9, 3.697739238769258*^9, 
   3.7152328922831907`*^9, 3.715233063721329*^9, 3.715233744247978*^9, 
   3.7273348975632*^9, 3.727335237620246*^9, 3.7273353301723*^9, 
   3.727336142314272*^9, 3.7273362340513115`*^9, 3.72733646483947*^9, 
   3.727336735047454*^9, 3.727337057048157*^9, 3.727340513920922*^9, 
   3.727340622212541*^9, 3.727340738765404*^9, 3.727341331757613*^9, 
   3.727342072046248*^9, 3.727343585794441*^9, 3.727343668885517*^9, 
   3.727343748756818*^9, 3.727343856935163*^9, 3.727410645286395*^9, 
   3.728277229141034*^9, 3.72827816266603*^9, 3.7282784871362505`*^9, {
   3.7282786049174438`*^9, 3.728278627546993*^9}, 3.728280560082527*^9, 
   3.728280821513037*^9, 3.7282809938735466`*^9, 3.728483764724371*^9, 
   3.728551303713337*^9, 3.728551798181888*^9, 3.728804568995287*^9, 
   3.7288046918213134`*^9, 3.7288085184428244`*^9, 3.728808860645568*^9, 
   3.777914012554199*^9, 3.777914083305447*^9, 3.7910937983227334`*^9, 
   3.791093948470254*^9, 3.8202047470113297`*^9, 3.820207206036751*^9, 
   3.8202072968184195`*^9, 3.820207364188821*^9, 3.842762463601587*^9, 
   3.8443900044133677`*^9, 3.844390075760089*^9, 3.8443906736082892`*^9, 
   3.8443910784885287`*^9, 3.875891575000965*^9, 3.875891994251549*^9, 
   3.9213068322371426`*^9, 3.921306906454975*^9, 3.9213069494509087`*^9, 
   3.9584003367838135`*^9},
 CellLabel->
  "Out[436]=",ExpressionUUID->"d403fdf1-bfff-3f46-8876-38b3c511f400"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CovDFormat", "=", "\"\<Prefix\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CovDQ", "[", "CD", "]"}], "^=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymbolOfCovD", "[", "CD", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<D\>\""}], "}"}]}], ";"}]}], "Input",
 CellLabel->
  "In[437]:=",ExpressionUUID->"3770b8ba-e8f9-4cb0-b4da-1e8713cbf2de"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "[", 
   RowBox[{"T", "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "c"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[440]:=",ExpressionUUID->"04113740-a633-42e4-94fc-f180a550d3a4"],

Cell[BoxData["\<\"D_{a}\\\\tau^{b}{}_{c}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796045118*^9, 3.5823538545048513`*^9, 3.582353967357657*^9, 
   3.5831307207510242`*^9, 3.5831330407880993`*^9, 3.5831331207538385`*^9, 
   3.58313319557257*^9, 3.5831333023703585`*^9, 3.5831333343816147`*^9, 
   3.583135199209889*^9, 3.5831353247121096`*^9, 3.583138084093757*^9, 
   3.5831382087389765`*^9, 3.583146551110881*^9, 3.5831466224654055`*^9, 
   3.583146828276568*^9, {3.5831473700977197`*^9, 3.583147396492965*^9}, 
   3.583148786643607*^9, 3.583149934039822*^9, 3.583150019122372*^9, 
   3.5831501724862413`*^9, 3.583150223451532*^9, 3.583150271827216*^9, {
   3.58796518341426*^9, 3.5879652038034954`*^9}, 3.588079872577228*^9, 
   3.588079956084175*^9, 3.5880832905172386`*^9, 3.588083688754738*^9, 
   3.5883166149086757`*^9, 3.5883188433121896`*^9, 3.588319019545699*^9, 
   3.588319168947162*^9, 3.58832582682724*^9, 3.5883259581014714`*^9, 
   3.588326916490154*^9, 3.588327859856011*^9, 3.588327929042133*^9, 
   3.58832801900749*^9, 3.588328473373888*^9, 3.5883285575204377`*^9, 
   3.5883293968809114`*^9, {3.588329680333409*^9, 3.5883297038894496`*^9}, 
   3.5883299121332145`*^9, 3.615130825846859*^9, 3.615131008026884*^9, 
   3.619089165880088*^9, 3.6196262152991576`*^9, 3.620542571468579*^9, 
   3.646381709650968*^9, 3.679983968578268*^9, 3.679984668186679*^9, 
   3.69773918374718*^9, 3.697739238799258*^9, 3.715232892365497*^9, 
   3.715233063805167*^9, 3.715233744343841*^9, 3.727334897641361*^9, 
   3.727335237655017*^9, 3.7273353302035527`*^9, 3.727336142351571*^9, 
   3.727336234098215*^9, 3.727336464892902*^9, 3.7273367351129303`*^9, 
   3.727337057132846*^9, 3.727340513967769*^9, 3.7273406222811217`*^9, 
   3.727340738845543*^9, 3.727341331788835*^9, 3.727342072099653*^9, 
   3.72734358585695*^9, 3.727343668938918*^9, 3.727343748794125*^9, 
   3.727343857027216*^9, 3.7274106453050337`*^9, 3.72827722915664*^9, 
   3.728278162681633*^9, 3.7282784871518784`*^9, {3.728278604933031*^9, 
   3.728278627578246*^9}, 3.728280560083042*^9, 3.728280821544288*^9, 
   3.728280993890439*^9, 3.728483764739998*^9, 3.728551303728965*^9, 
   3.728551798203964*^9, 3.7288045690132885`*^9, 3.728804691842314*^9, 
   3.728808518459958*^9, 3.7288088606611958`*^9, 3.7779140126166935`*^9, 
   3.7779140833523197`*^9, 3.7910937984371676`*^9, 3.7910939485719557`*^9, 
   3.82020474709111*^9, 3.8202072061295037`*^9, 3.820207296858314*^9, 
   3.8202073648330183`*^9, 3.842762463639487*^9, 3.8443900044602146`*^9, 
   3.844390075794995*^9, 3.8443906736511745`*^9, 3.844391078531413*^9, 
   3.8758915750239143`*^9, 3.8758919942655163`*^9, 3.921306832263073*^9, 
   3.9213069064918766`*^9, 3.9213069494748173`*^9, 3.9584003367910976`*^9},
 CellLabel->
  "Out[440]=",ExpressionUUID->"4bd185c4-c01f-b947-9ddd-5c43a07e9804"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CovDFormat", "=", "\"\<Postfix\>\""}], ";"}]], "Input",
 CellLabel->
  "In[441]:=",ExpressionUUID->"082f6c60-0f64-4ff5-a5d5-54ed5baf9f2d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "[", 
   RowBox[{"T", "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "c"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[442]:=",ExpressionUUID->"2efbcf0c-18fc-4c45-ab60-20d8c6e80320"],

Cell[BoxData["\<\"\\\\tau^{b}{}_{c}{}_{;a}\"\>"], "Output",
 CellChangeTimes->{
  3.5823477960763183`*^9, 3.5823538545204515`*^9, 3.5823539673888564`*^9, 
   3.583130720766623*^9, 3.583133040803698*^9, 3.583133120785039*^9, 
   3.58313319571297*^9, 3.583133302385959*^9, 3.583133334397214*^9, 
   3.583135199225489*^9, 3.58313532472771*^9, 3.583138084280957*^9, 
   3.583138208754576*^9, 3.583146551438481*^9, 3.583146622481006*^9, 
   3.583146828307767*^9, {3.583147370113319*^9, 3.583147396508565*^9}, 
   3.583148786659207*^9, 3.583149934055423*^9, 3.583150019137972*^9, 
   3.583150172517442*^9, 3.583150223482731*^9, 3.5831502718428173`*^9, {
   3.587965183429859*^9, 3.5879652038190956`*^9}, 3.588079872608428*^9, 
   3.588079956099775*^9, 3.5880832919056416`*^9, 3.588083688785939*^9, 
   3.588316614939875*^9, 3.5883188433277893`*^9, 3.5883190195768995`*^9, 
   3.588319168993962*^9, 3.58832582684284*^9, 3.58832595811707*^9, 
   3.588326916505754*^9, 3.588327859887211*^9, 3.588327929057732*^9, 
   3.5883280190230904`*^9, 3.588328473389488*^9, 3.588328557536036*^9, 
   3.58832939689651*^9, {3.5883296803490086`*^9, 3.58832970390505*^9}, 
   3.588329912148814*^9, 3.615130825856859*^9, 3.615131008042484*^9, 
   3.6190891659000874`*^9, 3.6196262153091574`*^9, 3.620542571478578*^9, 
   3.6463817096809688`*^9, 3.6799839685982666`*^9, 3.679984668196679*^9, 
   3.69773918376718*^9, 3.6977392388192587`*^9, 3.715232892448994*^9, 
   3.715233063888508*^9, 3.715233744490143*^9, 3.727334897726*^9, 
   3.727335237673651*^9, 3.727335330254859*^9, 3.727336142398425*^9, 
   3.727336234136012*^9, 3.727336464924191*^9, 3.727336735150653*^9, 
   3.7273370571797395`*^9, 3.727340514034581*^9, 3.727340622365776*^9, 
   3.72734073889824*^9, 3.7273413318266535`*^9, 3.727342072146535*^9, 
   3.727343585911243*^9, 3.7273436690392017`*^9, 3.727343748841162*^9, 
   3.7273438570888205`*^9, 3.727410645351912*^9, 3.728277229172267*^9, 
   3.728278162703307*^9, 3.728278487167505*^9, {3.728278604948665*^9, 
   3.7282786275998893`*^9}, 3.728280560125226*^9, 3.728280821559938*^9, 
   3.728280993921708*^9, 3.728483764755624*^9, 3.728551303744591*^9, 
   3.7285517982195635`*^9, 3.728804569031289*^9, 3.728804691859315*^9, 
   3.728808518475978*^9, 3.72880886067682*^9, 3.777914012679194*^9, 
   3.7779140834148192`*^9, 3.791093798570724*^9, 3.791093948670768*^9, 
   3.8202047471377335`*^9, 3.820207206177374*^9, 3.8202072968992047`*^9, 
   3.820207364867925*^9, 3.842762463679377*^9, 3.8443900045131*^9, 
   3.844390075829901*^9, 3.844390673739937*^9, 3.8443910785812807`*^9, 
   3.875891575046857*^9, 3.875891994293409*^9, 3.9213068322909985`*^9, 
   3.9213069065277805`*^9, 3.9213069494947643`*^9, 3.9584003368110332`*^9},
 CellLabel->
  "Out[442]=",ExpressionUUID->"c7762a1c-205b-5743-8b54-caf2855b1f35"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CovDFormat", "=", "\"\<Prefix\>\""}], ";"}]], "Input",
 CellLabel->
  "In[443]:=",ExpressionUUID->"bd2e272b-9a30-4fdb-b805-9fad1f6b3587"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"B4", ",", "TangentM4", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.583148956403105*^9, 3.583148998601179*^9}},
 CellLabel->
  "In[444]:=",ExpressionUUID->"f08065bc-0b43-43ab-80d3-108971481e1c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "B4", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`B4, ". ", 
   ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627615841*^9, 3.728280560128235*^9, 
  3.728280821593689*^9, 3.728280993937317*^9, 3.7284837647712655`*^9, 
  3.728551303780863*^9, 3.7285517982351933`*^9, 3.72880456905029*^9, 
  3.728804691877316*^9, 3.728808518491604*^9, 3.728808860710094*^9, 
  3.777914012757321*^9, 3.777914083461696*^9, 3.7910937988219657`*^9, 
  3.791093948764416*^9, 3.820204747183611*^9, 3.820207206230233*^9, 
  3.820207296946053*^9, 3.8202073649068193`*^9, 3.842762463725227*^9, 
  3.84439000456197*^9, 3.8443900758668337`*^9, 3.844390673773845*^9, 
  3.844391078694005*^9, 3.875891575075775*^9, 3.875891994313387*^9, 
  3.9213068322999744`*^9, 3.9213069065636826`*^9, 3.921306949523716*^9, 
  3.9584003368387566`*^9},
 CellLabel->
  "During evaluation of \
In[444]:=",ExpressionUUID->"bb3bd174-4534-3c47-9d34-36288baf09f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDB4", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDB4[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627615841*^9, 3.728280560128235*^9, 
  3.728280821593689*^9, 3.728280993937317*^9, 3.7284837647712655`*^9, 
  3.728551303780863*^9, 3.7285517982351933`*^9, 3.72880456905029*^9, 
  3.728804691877316*^9, 3.728808518491604*^9, 3.728808860710094*^9, 
  3.777914012757321*^9, 3.777914083461696*^9, 3.7910937988219657`*^9, 
  3.791093948764416*^9, 3.820204747183611*^9, 3.820207206230233*^9, 
  3.820207296946053*^9, 3.8202073649068193`*^9, 3.842762463725227*^9, 
  3.84439000456197*^9, 3.8443900758668337`*^9, 3.844390673773845*^9, 
  3.844391078694005*^9, 3.875891575075775*^9, 3.875891994313387*^9, 
  3.9213068322999744`*^9, 3.9213069065636826`*^9, 3.921306949523716*^9, 
  3.9584003368387566`*^9},
 CellLabel->
  "During evaluation of \
In[444]:=",ExpressionUUID->"790de371-c7e0-9240-9aa7-bca6210a4b06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDB4", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDB4[$CellContext`a, -$CellContext`b, -$CellContext`c],
    ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627615841*^9, 3.728280560128235*^9, 
  3.728280821593689*^9, 3.728280993937317*^9, 3.7284837647712655`*^9, 
  3.728551303780863*^9, 3.7285517982351933`*^9, 3.72880456905029*^9, 
  3.728804691877316*^9, 3.728808518491604*^9, 3.728808860710094*^9, 
  3.777914012757321*^9, 3.777914083461696*^9, 3.7910937988219657`*^9, 
  3.791093948764416*^9, 3.820204747183611*^9, 3.820207206230233*^9, 
  3.820207296946053*^9, 3.8202073649068193`*^9, 3.842762463725227*^9, 
  3.84439000456197*^9, 3.8443900758668337`*^9, 3.844390673773845*^9, 
  3.844391078694005*^9, 3.875891575075775*^9, 3.875891994313387*^9, 
  3.9213068322999744`*^9, 3.9213069065636826`*^9, 3.921306949523716*^9, 
  3.9584003368387566`*^9},
 CellLabel->
  "During evaluation of \
In[444]:=",ExpressionUUID->"54d6f538-f166-044c-a338-479cd5119ba6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDB4", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDB4[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627615841*^9, 3.728280560128235*^9, 
  3.728280821593689*^9, 3.728280993937317*^9, 3.7284837647712655`*^9, 
  3.728551303780863*^9, 3.7285517982351933`*^9, 3.72880456905029*^9, 
  3.728804691877316*^9, 3.728808518491604*^9, 3.728808860710094*^9, 
  3.777914012757321*^9, 3.777914083461696*^9, 3.7910937988219657`*^9, 
  3.791093948764416*^9, 3.820204747183611*^9, 3.820207206230233*^9, 
  3.820207296946053*^9, 3.8202073649068193`*^9, 3.842762463725227*^9, 
  3.84439000456197*^9, 3.8443900758668337`*^9, 3.844390673773845*^9, 
  3.844391078694005*^9, 3.875891575075775*^9, 3.875891994313387*^9, 
  3.9213068322999744`*^9, 3.9213069065636826`*^9, 3.921306949523716*^9, 
  3.9584003368387566`*^9},
 CellLabel->
  "During evaluation of \
In[444]:=",ExpressionUUID->"c26b9787-2d5b-bc4b-874e-08fcaa19ed3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDB4", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDB4[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627615841*^9, 3.728280560128235*^9, 
  3.728280821593689*^9, 3.728280993937317*^9, 3.7284837647712655`*^9, 
  3.728551303780863*^9, 3.7285517982351933`*^9, 3.72880456905029*^9, 
  3.728804691877316*^9, 3.728808518491604*^9, 3.728808860710094*^9, 
  3.777914012757321*^9, 3.777914083461696*^9, 3.7910937988219657`*^9, 
  3.791093948764416*^9, 3.820204747183611*^9, 3.820207206230233*^9, 
  3.820207296946053*^9, 3.8202073649068193`*^9, 3.842762463725227*^9, 
  3.84439000456197*^9, 3.8443900758668337`*^9, 3.844390673773845*^9, 
  3.844391078694005*^9, 3.875891575075775*^9, 3.875891994313387*^9, 
  3.9213068322999744`*^9, 3.9213069065636826`*^9, 3.921306949523716*^9, 
  3.9584003368387566`*^9},
 CellLabel->
  "During evaluation of \
In[444]:=",ExpressionUUID->"dc84234d-2c99-a348-8d9c-9937a0d3548a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDB4", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDB4[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627615841*^9, 3.728280560128235*^9, 
  3.728280821593689*^9, 3.728280993937317*^9, 3.7284837647712655`*^9, 
  3.728551303780863*^9, 3.7285517982351933`*^9, 3.72880456905029*^9, 
  3.728804691877316*^9, 3.728808518491604*^9, 3.728808860710094*^9, 
  3.777914012757321*^9, 3.777914083461696*^9, 3.7910937988219657`*^9, 
  3.791093948764416*^9, 3.820204747183611*^9, 3.820207206230233*^9, 
  3.820207296946053*^9, 3.8202073649068193`*^9, 3.842762463725227*^9, 
  3.84439000456197*^9, 3.8443900758668337`*^9, 3.844390673773845*^9, 
  3.844391078694005*^9, 3.875891575075775*^9, 3.875891994313387*^9, 
  3.9213068322999744`*^9, 3.9213069065636826`*^9, 3.921306949523716*^9, 
  3.9584003368387566`*^9},
 CellLabel->
  "During evaluation of \
In[444]:=",ExpressionUUID->"5add75c5-5c44-7046-94d9-c299f65adecb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpB4", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpB4[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627615841*^9, 3.728280560128235*^9, 
  3.728280821593689*^9, 3.728280993937317*^9, 3.7284837647712655`*^9, 
  3.728551303780863*^9, 3.7285517982351933`*^9, 3.72880456905029*^9, 
  3.728804691877316*^9, 3.728808518491604*^9, 3.728808860710094*^9, 
  3.777914012757321*^9, 3.777914083461696*^9, 3.7910937988219657`*^9, 
  3.791093948764416*^9, 3.820204747183611*^9, 3.820207206230233*^9, 
  3.820207296946053*^9, 3.8202073649068193`*^9, 3.842762463725227*^9, 
  3.84439000456197*^9, 3.8443900758668337`*^9, 3.844390673773845*^9, 
  3.844391078694005*^9, 3.875891575075775*^9, 3.875891994313387*^9, 
  3.9213068322999744`*^9, 3.9213069065636826`*^9, 3.921306949523716*^9, 
  3.9584003368544216`*^9},
 CellLabel->
  "During evaluation of \
In[444]:=",ExpressionUUID->"5f10fcd1-74cd-5c45-91f4-800bbd3127d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownB4", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownB4[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728278627615841*^9, 3.728280560128235*^9, 
  3.728280821593689*^9, 3.728280993937317*^9, 3.7284837647712655`*^9, 
  3.728551303780863*^9, 3.7285517982351933`*^9, 3.72880456905029*^9, 
  3.728804691877316*^9, 3.728808518491604*^9, 3.728808860710094*^9, 
  3.777914012757321*^9, 3.777914083461696*^9, 3.7910937988219657`*^9, 
  3.791093948764416*^9, 3.820204747183611*^9, 3.820207206230233*^9, 
  3.820207296946053*^9, 3.8202073649068193`*^9, 3.842762463725227*^9, 
  3.84439000456197*^9, 3.8443900758668337`*^9, 3.844390673773845*^9, 
  3.844391078694005*^9, 3.875891575075775*^9, 3.875891994313387*^9, 
  3.9213068322999744`*^9, 3.9213069065636826`*^9, 3.921306949523716*^9, 
  3.9584003368544216`*^9},
 CellLabel->
  "During evaluation of \
In[444]:=",ExpressionUUID->"656d80ac-6d4c-a247-ab0f-ab7ddb174296"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDBasisExpr", "=", 
  RowBox[{
   RowBox[{"PDB4", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "B4"}]}], "}"}], "]"}], "[", 
   RowBox[{"T", "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "c"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.583149800144788*^9, 3.583149807367601*^9}, {
  3.583150130444167*^9, 3.583150136309778*^9}},
 CellLabel->
  "In[445]:=",ExpressionUUID->"2d6b85a5-2de1-44d4-8dbb-c43dec7d6679"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox[
     StyleBox["\[ScriptCapitalD]",
      FontColor->RGBColor[1., 0., 0.]], 
     StyleBox["1",
      FontColor->RGBColor[1., 0., 0.]]], GridBox[{
      {"\[Tau]", 
       StyleBox[GridBox[{
          {"b", " "},
          {" ", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`PDB4[{1, -$CellContext`B4}][
   $CellContext`T[$CellContext`b, -$CellContext`c]],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.583149012142003*^9, 3.5831499341022224`*^9, 3.5831500191847725`*^9, 
   3.58315013749538*^9, 3.5831501725642414`*^9, 3.583150223545131*^9, 
   3.583150271889616*^9, {3.587965183461059*^9, 3.587965203881496*^9}, 
   3.5880798726708283`*^9, 3.588079956146575*^9, 3.588083294105244*^9, 
   3.588083688863939*^9, 3.5883166149866757`*^9, 3.588318843390189*^9, 
   3.5883190196392994`*^9, 3.588319169071962*^9, 3.58832582688964*^9, 
   3.58832595817947*^9, 3.588326916552554*^9, 3.588327859934011*^9, 
   3.5883279291045322`*^9, 3.5883280190698905`*^9, 3.5883284734362884`*^9, 
   3.588328557582836*^9, 3.588329396943311*^9, {3.588329680395808*^9, 
   3.58832970395185*^9}, 3.588329912211214*^9, 3.615130825896859*^9, 
   3.615131008058084*^9, 3.619089165930087*^9, 3.6196262153491573`*^9, 
   3.620542571508579*^9, 3.646381709750968*^9, 3.67998396866826*^9, 
   3.67998466826668*^9, 3.69773918381718*^9, 3.697739238889258*^9, 
   3.715232892731924*^9, 3.715233064088521*^9, 3.715233744693921*^9, 
   3.727334897964122*^9, 3.7273352377739353`*^9, 3.727335330393079*^9, 
   3.727336142536268*^9, 3.727336234249961*^9, 3.727336465040047*^9, 
   3.72733673525054*^9, 3.7273370573799357`*^9, 3.727340514205021*^9, 
   3.727340622498078*^9, 3.727340739049927*^9, 3.727341331923425*^9, 
   3.727342072283199*^9, 3.727343586014445*^9, 3.727343669139365*^9, 
   3.7273437489496346`*^9, 3.727343857233184*^9, 3.727410645436149*^9, 
   3.7282772292409396`*^9, 3.728278162769864*^9, 3.728278487236448*^9, {
   3.728278605001507*^9, 3.7282786276471243`*^9}, 3.728280560161478*^9, 
   3.7282808216335716`*^9, 3.728280993984304*^9, 3.728483764810058*^9, 
   3.728551303833338*^9, 3.728551798295767*^9, 3.728804569085293*^9, 
   3.7288046919253197`*^9, 3.728808518538483*^9, 3.7288088607587223`*^9, 
   3.777914012929193*^9, 3.7779140836492014`*^9, 3.791093798953231*^9, 
   3.7910939489024887`*^9, 3.820204747237438*^9, 3.820207206296057*^9, 
   3.820207296997913*^9, 3.820207364952697*^9, 3.842762463781078*^9, 
   3.8443900046257715`*^9, 3.844390075927668*^9, 3.844390673824738*^9, 
   3.844391078755841*^9, 3.875891575127638*^9, 3.875891994350258*^9, 
   3.9213068323468494`*^9, 3.921306906625519*^9, 3.9213069495755463`*^9, 
   3.9584003368829765`*^9},
 CellLabel->
  "Out[445]=",ExpressionUUID->"2d1ec798-0e92-4f45-9c33-ad8813c68341"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.583147037051734*^9, 3.583147040015739*^9}, 
   3.5831488906021895`*^9, {3.5831490114244018`*^9, 3.583149013343205*^9}},
 CellLabel->
  "In[446]:=",ExpressionUUID->"e36b0683-774c-4ad2-8c5b-bc6af7fb9704"],

Cell[BoxData["\<\"\\\\mathcal{D}_{1}\\\\tau^{b}{}_{c}\"\>"], "Output",
 CellChangeTimes->{{3.583147040202939*^9, 3.583147066332985*^9}, {
   3.583147370128919*^9, 3.583147424807015*^9}, 3.583147462262681*^9, 
   3.583148892739393*^9, 3.583149013592806*^9, 3.583149934117822*^9, 
   3.5831500192003736`*^9, 3.583150139304983*^9, 3.583150172595442*^9, 
   3.583150223560731*^9, 3.5831502719208174`*^9, {3.587965183492259*^9, 
   3.587965203897096*^9}, 3.5880798727020288`*^9, 3.588079956162175*^9, 
   3.588083295025646*^9, 3.588083688895139*^9, 3.5883166150022755`*^9, 
   3.58831884340579*^9, 3.588319019654899*^9, 3.588319169103162*^9, 
   3.58832582690524*^9, 3.588325958195071*^9, 3.588326916568154*^9, 
   3.5883278599496117`*^9, 3.588327929120133*^9, 3.58832801908549*^9, 
   3.588328473451888*^9, 3.5883285575984373`*^9, 3.588329396958911*^9, {
   3.588329680411409*^9, 3.5883297039674506`*^9}, 3.5883299122268147`*^9, 
   3.6151308259068594`*^9, 3.615131008073684*^9, 3.6190891659400873`*^9, 
   3.6196262153591576`*^9, 3.620542571508579*^9, 3.646381709770968*^9, 
   3.679983968688259*^9, 3.6799846684566817`*^9, 3.69773918382718*^9, 
   3.697739238909258*^9, 3.715232892781382*^9, 3.715233064142349*^9, 
   3.715233744744538*^9, 3.7273348980422564`*^9, 3.727335237820815*^9, 
   3.7273353304087257`*^9, 3.727336142583146*^9, 3.727336234281211*^9, 
   3.7273364650713015`*^9, 3.727336735297448*^9, 3.7273370573955626`*^9, 
   3.7273405142521276`*^9, 3.727340622544964*^9, 3.727340739101771*^9, 
   3.72734133194258*^9, 3.727342072315465*^9, 3.727343586045693*^9, 
   3.7273436691550198`*^9, 3.727343748994428*^9, 3.7273438572573824`*^9, 
   3.727410645451776*^9, 3.728277229256566*^9, 3.728278162785844*^9, 
   3.728278487252076*^9, {3.7282786050197167`*^9, 3.7282786276471243`*^9}, 
   3.7282805601837687`*^9, 3.7282808216517577`*^9, 3.728280993999934*^9, 
   3.7284837648257136`*^9, 3.728551303881731*^9, 3.728551798311395*^9, 
   3.728804569098294*^9, 3.72880469194332*^9, 3.728808518560698*^9, 
   3.728808860778289*^9, 3.777914013007318*^9, 3.777914083805447*^9, 
   3.791093799084781*^9, 3.791093948987154*^9, 3.820204747293288*^9, 
   3.820207206339938*^9, 3.820207297047779*^9, 3.820207364985609*^9, 
   3.842762463814987*^9, 3.8443900046596813`*^9, 3.844390075961581*^9, 
   3.8443906738636065`*^9, 3.844391078790719*^9, 3.8758915751505823`*^9, 
   3.875891994378206*^9, 3.921306832374775*^9, 3.9213069066534443`*^9, 
   3.921306949602476*^9, 3.95840033691115*^9},
 CellLabel->
  "Out[446]=",ExpressionUUID->"c6e5c3e6-ecef-8543-a542-42802867b214"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"FormatTexBasis", "[", 
  RowBox[{
   RowBox[{"PDB4", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "B4"}]}], "}"}], "]"}], ",", "\"\<\\\\partial_r\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5831488113384504`*^9, 3.58314882837368*^9}, {
   3.58314886270934*^9, 3.58314887952617*^9}, 3.58314981838122*^9, {
   3.5831500264543858`*^9, 3.583150032756796*^9}, {3.583150146948997*^9, 
   3.583150147900599*^9}},
 CellLabel->
  "In[447]:=",ExpressionUUID->"8c26d6c0-faeb-4044-9a22-99c157e19c0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "PDBasisExpr"}]], "Input",
 CellChangeTimes->{{3.583147037051734*^9, 3.583147040015739*^9}, 
   3.5831488906021895`*^9, {3.5831490114244018`*^9, 3.583149013343205*^9}, 
   3.583149815682415*^9, 3.5831502599399962`*^9},
 CellLabel->
  "In[448]:=",ExpressionUUID->"1c18372a-47bd-439e-bba4-48f22cc8cafe"],

Cell[BoxData["\<\"\\\\partial_r\\\\tau^{b}{}_{c}\"\>"], "Output",
 CellChangeTimes->{{3.583147040202939*^9, 3.583147066332985*^9}, {
   3.583147370128919*^9, 3.583147424807015*^9}, 3.583147462262681*^9, 
   3.583148892739393*^9, 3.583149013592806*^9, 3.583149934133423*^9, {
   3.583150019215973*^9, 3.583150037811205*^9}, {3.583150151332605*^9, 
   3.583150172611042*^9}, 3.583150223576331*^9, 3.583150271936416*^9, {
   3.5879651835078597`*^9, 3.587965203912696*^9}, 3.588079872717629*^9, 
   3.588079956193375*^9, 3.58808329650765*^9, 3.588083688926338*^9, 
   3.588316615017876*^9, 3.58831884343699*^9, 3.588319019686099*^9, 
   3.588319169134362*^9, 3.5883258269208403`*^9, 3.588325958210671*^9, 
   3.5883269165837536`*^9, 3.588327859965211*^9, 3.588327929135733*^9, 
   3.588328019101091*^9, 3.5883284734674883`*^9, 3.588328557614036*^9, 
   3.58832939697451*^9, {3.5883296804270086`*^9, 3.58832970398305*^9}, 
   3.5883299122424154`*^9, 3.615130825926859*^9, 3.615131008073684*^9, 
   3.619089165950087*^9, 3.619626215369158*^9, 3.620542571518578*^9, 
   3.646381709890969*^9, 3.6799839686982584`*^9, 3.679984668476682*^9, 
   3.69773918384718*^9, 3.697739238969259*^9, 3.715232892915614*^9, 
   3.71523306422133*^9, 3.715233744826704*^9, 3.727334898080035*^9, 
   3.727335237878676*^9, 3.727335330441528*^9, 3.727336142698789*^9, 
   3.727336234320592*^9, 3.727336465124601*^9, 3.7273367353498716`*^9, 
   3.727337057449366*^9, 3.727340514305098*^9, 3.7273406226408095`*^9, 
   3.7273407391660438`*^9, 3.727341331989444*^9, 3.727342072346686*^9, 
   3.727343586125983*^9, 3.72734366921753*^9, 3.7273437490725636`*^9, 
   3.727343857304755*^9, 3.727410645489087*^9, 3.728277229272214*^9, 
   3.728278162803959*^9, 3.7282784872677035`*^9, {3.728278605035348*^9, 
   3.728278627672915*^9}, 3.7282805601998076`*^9, 3.728280821684921*^9, 
   3.72828099401556*^9, 3.728483764856938*^9, 3.7285513039058*^9, 
   3.7285517983426757`*^9, 3.728804569123295*^9, 3.728804691963321*^9, 
   3.728808518576326*^9, 3.728808860800335*^9, 3.777914013210445*^9, 
   3.777914083867947*^9, 3.791093799207056*^9, 3.7910939491200504`*^9, 
   3.820204747340191*^9, 3.820207206382824*^9, 3.8202072970905647`*^9, 
   3.820207365758242*^9, 3.842762463855878*^9, 3.844390004696617*^9, 
   3.844390076004463*^9, 3.844390673896518*^9, 3.844391078829642*^9, 
   3.8758915751775045`*^9, 3.8758919943941393`*^9, 3.921306832399708*^9, 
   3.9213069067023144`*^9, 3.9213069496304264`*^9, 3.958400336918089*^9},
 CellLabel->
  "Out[448]=",ExpressionUUID->"b4169b83-221e-394a-b670-8fd25bfb9c73"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"FormatTexBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "B4"}]}], "}"}], ",", "\"\<\\\\partial_r\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.583149876631722*^9, 3.58314988677174*^9}, {
  3.5831500420232134`*^9, 3.583150081382082*^9}},
 CellLabel->
  "In[449]:=",ExpressionUUID->"fdeafb00-3204-40a6-9167-e4cae12e5603"],

Cell[BoxData[
 RowBox[{"FormatTexBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "B4"}], "}"}], ",", "\"\<dr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.583149876631722*^9, 3.58314988677174*^9}, {
  3.5831500420232134`*^9, 3.583150065126853*^9}},
 CellLabel->
  "In[450]:=",ExpressionUUID->"7d7d95db-9a2f-4053-a033-6fd18a572b20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "B4"}]}], "}"}], ",", "a"}], "]"}]], "Input",
 CellChangeTimes->{{3.5831489205230412`*^9, 3.583148935405468*^9}, {
  3.583149840704859*^9, 3.5831498672717056`*^9}},
 CellLabel->
  "In[451]:=",ExpressionUUID->"0b91854a-b241-40a1-8c7d-0f2c99fbd8fd"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", "a"},
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{1, -$CellContext`B4}, $CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{{3.583149846086869*^9, 3.5831498676149073`*^9}, 
   3.583149954678659*^9, 3.583150019231572*^9, 3.5831500502288265`*^9, 
   3.583150084408487*^9, 3.583150172626642*^9, 3.583150223591932*^9, 
   3.583150271952018*^9, {3.587965183523459*^9, 3.5879652039438953`*^9}, 
   3.5880798728580284`*^9, 3.588079956208975*^9, 3.588083301484058*^9, 
   3.588083688957539*^9, 3.5883166150490756`*^9, 3.58831884345259*^9, 
   3.5883190197016997`*^9, 3.5883191691655617`*^9, 3.58832582693644*^9, 
   3.5883259582262716`*^9, 3.588326916599354*^9, 3.588327859980811*^9, 
   3.5883279291513333`*^9, 3.5883280191166906`*^9, 3.588328473483088*^9, 
   3.5883285576296372`*^9, 3.588329397005711*^9, {3.588329680458208*^9, 
   3.5883297039986496`*^9}, 3.588329912258015*^9, 3.615130825936859*^9, 
   3.615131008089284*^9, 3.619089165960088*^9, 3.619626215379158*^9, 
   3.620542571628578*^9, 3.6463817099309688`*^9, 3.6799839687382555`*^9, 
   3.679984668506682*^9, 3.69773918387718*^9, 3.6977392390092583`*^9, 
   3.715232893033594*^9, 3.7152330643381033`*^9, 3.715233744943577*^9, 
   3.7273348981646914`*^9, 3.727335237942346*^9, 3.727335330504037*^9, 
   3.727336142783471*^9, 3.7273362344021945`*^9, 3.727336465193127*^9, 
   3.727336735428166*^9, 3.7273370575119047`*^9, 3.727340514405676*^9, 
   3.727340622745675*^9, 3.727340739273337*^9, 3.727341332058475*^9, 
   3.72734207239912*^9, 3.7273435861946*^9, 3.7273436693173633`*^9, 
   3.727343749141601*^9, 3.727343857404894*^9, 3.7274106455314612`*^9, 
   3.7282772292938633`*^9, 3.728278162882095*^9, 3.728278487336733*^9, {
   3.728278605068673*^9, 3.7282786277001076`*^9}, 3.7282805602264657`*^9, 
   3.728280821713169*^9, 3.728280994046814*^9, 3.728483764888191*^9, 
   3.728551303921426*^9, 3.728551798376413*^9, 3.728804569150296*^9, 
   3.7288046919883227`*^9, 3.7288085185919533`*^9, 3.728808860814905*^9, 
   3.777914013241689*^9, 3.777914083961703*^9, 3.7910937993386407`*^9, 
   3.791093949234415*^9, 3.820204747388065*^9, 3.820207206431693*^9, 
   3.820207297137445*^9, 3.820207365807112*^9, 3.8427624639027777`*^9, 
   3.844390004740492*^9, 3.84439007613708*^9, 3.8443906739633393`*^9, 
   3.844391078884468*^9, 3.875891575201441*^9, 3.875891994412116*^9, 
   3.9213068324276333`*^9, 3.9213069067362213`*^9, 3.921306949653366*^9, 
   3.958400336933939*^9},
 CellLabel->
  "Out[451]=",ExpressionUUID->"30567796-fe0f-6848-b4bc-ce2dbfd5c952"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.58314893649747*^9, 3.583148938104273*^9}},
 CellLabel->
  "In[452]:=",ExpressionUUID->"d4351566-4e7b-4315-9aa2-0773741d08cd"],

Cell[BoxData["\<\"\\\\partial_r^{a}\"\>"], "Output",
 CellChangeTimes->{
  3.583148938275873*^9, 3.5831490201448174`*^9, 3.583149139578626*^9, 
   3.583149868160907*^9, 3.583149955786261*^9, 3.583150019247173*^9, 
   3.583150050681228*^9, 3.583150085001288*^9, 3.583150172657842*^9, 
   3.583150223607532*^9, 3.583150271967616*^9, {3.587965183539059*^9, 
   3.5879652039594955`*^9}, 3.5880798728736286`*^9, 3.588079956224575*^9, 
   3.588083301515258*^9, 3.588083688988738*^9, 3.5883166150490756`*^9, 
   3.58831884346819*^9, 3.5883190197329*^9, 3.588319169196762*^9, 
   3.58832582695204*^9, 3.588325958241871*^9, 3.588326916614954*^9, 
   3.588327859996411*^9, 3.588327929166932*^9, 3.588328019132291*^9, 
   3.588328473498688*^9, 3.5883285576452374`*^9, 3.588329397005711*^9, {
   3.588329680458208*^9, 3.58832970401425*^9}, 3.588329912273615*^9, 
   3.6151308259468594`*^9, 3.615131008089284*^9, 3.619089165970087*^9, 
   3.619626215379158*^9, 3.620542571628578*^9, 3.646381709940969*^9, 
   3.6799839687482543`*^9, 3.679984668526683*^9, 3.6977391838871803`*^9, 
   3.697739239019258*^9, 3.715232893100418*^9, 3.715233064420528*^9, 
   3.715233744993189*^9, 3.7273348981959496`*^9, 3.7273352379629006`*^9, 
   3.72733533054131*^9, 3.727336142820799*^9, 3.727336234420401*^9, 
   3.727336465224646*^9, 3.7273367354503145`*^9, 3.727337057534024*^9, 
   3.727340514452585*^9, 3.7273406227810135`*^9, 3.727340739294986*^9, 
   3.7273413320741014`*^9, 3.727342072414833*^9, 3.727343586210196*^9, 
   3.7273436693387203`*^9, 3.727343749157266*^9, 3.727343857457794*^9, 
   3.727410645562686*^9, 3.7282772292938633`*^9, 3.728278162898725*^9, 
   3.728278487354079*^9, {3.728278605070171*^9, 3.728278627715883*^9}, 
   3.728280560226966*^9, 3.728280821713169*^9, 3.7282809940649576`*^9, 
   3.728483764888191*^9, 3.7285513039526796`*^9, 3.7285517983849344`*^9, 
   3.728804569162297*^9, 3.728804692002323*^9, 3.7288085186075816`*^9, 
   3.728808860830533*^9, 3.7779140132573175`*^9, 3.777914084008601*^9, 
   3.79109379946332*^9, 3.791093949312426*^9, 3.820204747432479*^9, 
   3.8202072064755754`*^9, 3.8202072971783295`*^9, 3.8202073658998623`*^9, 
   3.84276246392871*^9, 3.844390004773376*^9, 3.844390076165005*^9, 
   3.844390673992261*^9, 3.844391078911395*^9, 3.875891575206431*^9, 
   3.875891994427079*^9, 3.921306832432619*^9, 3.9213069067621536`*^9, 
   3.9213069496703224`*^9, 3.9584003369499035`*^9},
 CellLabel->
  "Out[452]=",ExpressionUUID->"531aa1ff-8854-c346-ba7c-a638f503d96a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "B4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5831489205230412`*^9, 3.583148935405468*^9}, {
  3.583149840704859*^9, 3.5831498672717056`*^9}, {3.583150092692102*^9, 
  3.583150100180115*^9}},
 CellLabel->
  "In[453]:=",ExpressionUUID->"0d84594f-765f-4d65-a457-3f0bcec21513"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]]},
         {"a", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`B4}],
  Editable->False]], "Output",
 CellChangeTimes->{{3.583149846086869*^9, 3.5831498676149073`*^9}, 
   3.583149954678659*^9, 3.583150019231572*^9, 3.5831500502288265`*^9, {
   3.583150084408487*^9, 3.583150100414115*^9}, 3.583150172657842*^9, 
   3.5831502236231318`*^9, 3.583150271967616*^9, {3.58796518355466*^9, 
   3.587965203975096*^9}, 3.588079872889229*^9, 3.5880799562401752`*^9, 
   3.588083301530858*^9, 3.5880836890199385`*^9, 3.588316615064676*^9, 
   3.58831884348379*^9, 3.5883190197485*^9, 3.588319169227962*^9, 
   3.58832582696764*^9, 3.588325958241871*^9, 3.588326916614954*^9, 
   3.588327859996411*^9, 3.588327929166932*^9, 3.58832801914789*^9, 
   3.588328473498688*^9, 3.5883285576452374`*^9, 3.588329397021311*^9, {
   3.5883296804738083`*^9, 3.58832970402985*^9}, 3.5883299122892146`*^9, 
   3.615130825956859*^9, 3.615131008089284*^9, 3.6190891659800873`*^9, 
   3.619626215389158*^9, 3.6205425716385784`*^9, 3.646381709960969*^9, 
   3.67998396892824*^9, 3.679984668546683*^9, 3.69773918390718*^9, 
   3.697739239039258*^9, 3.715232893166218*^9, 3.715233064471372*^9, 
   3.715233745043276*^9, 3.727334898227202*^9, 3.727335237986965*^9, 
   3.727335330572564*^9, 3.727336142852357*^9, 3.727336234451647*^9, 
   3.727336465240274*^9, 3.727336735481596*^9, 3.727337057580932*^9, 
   3.72734051448384*^9, 3.727340622812267*^9, 3.727340739341894*^9, 
   3.727341332089729*^9, 3.7273420724460797`*^9, 3.72734358624145*^9, 
   3.727343669354771*^9, 3.727343749194723*^9, 3.72734385747393*^9, 
   3.727410645581915*^9, 3.7282772293098774`*^9, 3.728278162904241*^9, 
   3.728278487354079*^9, {3.7282786050862155`*^9, 3.728278627715883*^9}, 
   3.728280560242992*^9, 3.7282808217288046`*^9, 3.7282809940744753`*^9, 
   3.7284837649098406`*^9, 3.72855130397739*^9, 3.728551798400867*^9, 
   3.728804569174298*^9, 3.728804692019324*^9, 3.728808518623237*^9, 
   3.7288088608930664`*^9, 3.777914013272941*^9, 3.7779140840398235`*^9, 
   3.791093799585719*^9, 3.791093949387941*^9, 3.820204747442425*^9, 
   3.820207206534418*^9, 3.820207297222185*^9, 3.820207365940754*^9, 
   3.842762463953643*^9, 3.844390004804294*^9, 3.844390076191933*^9, 
   3.844390674026171*^9, 3.844391078939322*^9, 3.875891575226374*^9, 
   3.8758919944799104`*^9, 3.9213068324386024`*^9, 3.921306906790077*^9, 
   3.921306949689245*^9, 3.9584003369499035`*^9},
 CellLabel->
  "Out[453]=",ExpressionUUID->"493472b8-5d64-2c43-a1fa-24aba44805e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.58314893649747*^9, 3.583148938104273*^9}},
 CellLabel->
  "In[454]:=",ExpressionUUID->"de2d002d-1aca-4480-9915-698938e44599"],

Cell[BoxData["\<\"dr_{a}\"\>"], "Output",
 CellChangeTimes->{
  3.583148938275873*^9, 3.5831490201448174`*^9, 3.583149139578626*^9, 
   3.583149868160907*^9, 3.583149955786261*^9, 3.583150019247173*^9, 
   3.583150050681228*^9, {3.583150085001288*^9, 3.583150101396917*^9}, 
   3.583150172673442*^9, 3.5831502236387315`*^9, 3.5831502719832172`*^9, {
   3.58796518355466*^9, 3.587965203990696*^9}, 3.588079872904829*^9, 
   3.5880799562401752`*^9, 3.5880833015464587`*^9, 3.588083689035539*^9, 
   3.5883166150802755`*^9, 3.58831884351499*^9, 3.5883190197640996`*^9, 
   3.5883191692435617`*^9, 3.58832582696764*^9, 3.5883259582574716`*^9, 
   3.588326916630554*^9, 3.5883278600120115`*^9, 3.5883279291825333`*^9, 
   3.58832801914789*^9, 3.588328473514288*^9, 3.588328557660836*^9, 
   3.588329397036911*^9, {3.5883296804894085`*^9, 3.58832970402985*^9}, 
   3.5883299122892146`*^9, 3.615130825956859*^9, 3.615131008104884*^9, 
   3.619089165990087*^9, 3.6196262153991575`*^9, 3.620542571648578*^9, 
   3.646381709980969*^9, 3.679983968938239*^9, 3.679984668556683*^9, 
   3.69773918391718*^9, 3.697739239049258*^9, 3.715232893221253*^9, 
   3.715233064521391*^9, 3.715233745095068*^9, 3.7273348982428293`*^9, 
   3.727335238014628*^9, 3.727335330603818*^9, 3.727336142883606*^9, 
   3.727336234463813*^9, 3.7273364652715545`*^9, 3.727336735497222*^9, 
   3.727337057612158*^9, 3.727340514521596*^9, 3.727340622827899*^9, 
   3.727340739373122*^9, 3.727341332127001*^9, 3.727342072461739*^9, 
   3.72734358627872*^9, 3.7273436693860245`*^9, 3.7273437492103524`*^9, 
   3.727343857489549*^9, 3.7274106455899134`*^9, 3.728277229325505*^9, 
   3.728278162904241*^9, 3.728278487369707*^9, {3.7282786050862155`*^9, 
   3.728278627739029*^9}, 3.728280560242992*^9, 3.728280821744431*^9, 
   3.7282809940744753`*^9, 3.72848376492547*^9, 3.728551303998072*^9, 
   3.7285517984164925`*^9, 3.728804569184298*^9, 3.7288046920343246`*^9, 
   3.728808518623237*^9, 3.7288088609147143`*^9, 3.777914013288565*^9, 
   3.777914084086697*^9, 3.791093799707989*^9, 3.791093949473876*^9, 
   3.820204747486307*^9, 3.8202072065744514`*^9, 3.820207297260083*^9, 
   3.820207365981643*^9, 3.8427624639785767`*^9, 3.844390004834241*^9, 
   3.844390076220856*^9, 3.8443906740351477`*^9, 3.8443910789682436`*^9, 
   3.87589157524732*^9, 3.875891994484929*^9, 3.9213068324625397`*^9, 
   3.9213069067960625`*^9, 3.9213069497062263`*^9, 3.9584003369655895`*^9},
 CellLabel->
  "Out[454]=",ExpressionUUID->"813e465e-38fd-6646-9ed3-57fb81e05bef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"\[Lambda]", "[", "]"}], ",", "M4"}], "]"}]], "Input",
 CellChangeTimes->{{3.5446036610339346`*^9, 3.544603664497133*^9}},
 CellLabel->
  "In[455]:=",ExpressionUUID->"6724f6b6-547b-45be-9f28-bf3a72dfe44b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Lambda]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Lambda][], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7282786277395353`*^9, 3.728280560258587*^9, 
  3.728280821760049*^9, 3.728280994090107*^9, 3.72848376492547*^9, 
  3.7285513040137053`*^9, 3.7285517984164925`*^9, 3.7288045691962986`*^9, 
  3.728804692050326*^9, 3.728808518638861*^9, 3.7288088609147143`*^9, 
  3.77791401333544*^9, 3.777914084117948*^9, 3.7910937998551674`*^9, 
  3.791093949561418*^9, 3.820204747526232*^9, 3.820207206584398*^9, 
  3.820207297271077*^9, 3.820207365993613*^9, 3.842762464004507*^9, 
  3.844390004866158*^9, 3.844390076249779*^9, 3.844390674066092*^9, 
  3.844391078996168*^9, 3.875891575253301*^9, 3.87589199449789*^9, 
  3.921306832468523*^9, 3.9213069068229904`*^9, 3.9213069497221546`*^9, 
  3.958400336981327*^9},
 CellLabel->
  "During evaluation of \
In[455]:=",ExpressionUUID->"c2780940-bfaf-3048-ade5-696e1395e233"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[456]:=",ExpressionUUID->"617d821a-b093-45ab-8284-e023079fb3db"],

Cell[BoxData[
 FractionBox[
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Tau]", 
       StyleBox[GridBox[{
          {" ", " ", " "},
          {"a", "b", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`c],
   Editable->False], 
  SqrtBox["2"]]], "Output",
 CellChangeTimes->{
  3.5823477961075177`*^9, 3.582353854567251*^9, 3.582353967420057*^9, 
   3.5831307207822237`*^9, 3.583133040834898*^9, 3.583133120800638*^9, 
   3.583133195759771*^9, 3.5831333024171586`*^9, 3.583133334428414*^9, 
   3.583135199241089*^9, 3.58313532475891*^9, 3.583138084358957*^9, 
   3.583138208785775*^9, 3.583146622496606*^9, 3.583150172704643*^9, 
   3.583150223669932*^9, 3.583150272014418*^9, {3.58796518358586*^9, 
   3.587965204006296*^9}, 3.588079872936029*^9, 3.588079956271375*^9, 
   3.5880833290493064`*^9, 3.588083689082339*^9, 3.588316615111476*^9, 
   3.5883188435461907`*^9, 3.5883190197952995`*^9, 3.588319169290362*^9, 
   3.5883258269988403`*^9, 3.588325958288671*^9, 3.5883269166617546`*^9, 
   3.588327860043211*^9, 3.588327929213733*^9, 3.5883280191790905`*^9, 
   3.588328473529888*^9, 3.588328557676438*^9, 3.5883293970525117`*^9, {
   3.5883296805362086`*^9, 3.58832970406105*^9}, 3.588329912320415*^9, 
   3.615130825976859*^9, 3.615131008104884*^9, 3.6190891660000877`*^9, 
   3.619626215419158*^9, 3.620542571698579*^9, 3.646381710020969*^9, 
   3.679983968968237*^9, 3.679984668586683*^9, 3.6977391839471803`*^9, 
   3.697739239079258*^9, 3.71523289338242*^9, 3.7152330646208277`*^9, 
   3.715233745212273*^9, 3.727334898296237*^9, 3.727335238099282*^9, 
   3.727335330672849*^9, 3.727336142936777*^9, 3.72733623450554*^9, 
   3.727336465324957*^9, 3.72733673555028*^9, 3.727337057696822*^9, 
   3.727340514606243*^9, 3.7273406228964477`*^9, 3.7273407394417295`*^9, 
   3.727341332158758*^9, 3.727342072530735*^9, 3.7273435863417335`*^9, 
   3.727343669439453*^9, 3.727343749272861*^9, 3.7273438575525613`*^9, 
   3.727410645668075*^9, 3.7282772293411436`*^9, 3.72827816293594*^9, {
   3.728278352050003*^9, 3.728278361473991*^9}, {3.728278487385334*^9, 
   3.728278492963563*^9}, {3.728278605133098*^9, 3.728278627755503*^9}, 
   3.728280560258587*^9, 3.728280821775715*^9, 3.728280994105734*^9, 
   3.728483764941113*^9, 3.728551304029297*^9, 3.7285517984321194`*^9, 
   3.728804569208299*^9, 3.728804692066326*^9, 3.728808518660032*^9, 
   3.728808860930342*^9, 3.777914013351065*^9, 3.777914084289821*^9, 
   3.791093799971643*^9, 3.791093949629409*^9, 3.8202047475371714`*^9, 
   3.820207206624291*^9, 3.820207297308869*^9, 3.820207366033513*^9, 
   3.842762464030411*^9, 3.8443900048990397`*^9, 3.844390076277728*^9, 
   3.844390674094017*^9, 3.844391079008169*^9, 3.875891575274247*^9, 
   3.875891994522797*^9, 3.9213068324964504`*^9, 3.921306906830969*^9, 
   3.9213069497311306`*^9, 3.958400336981327*^9},
 CellLabel->
  "Out[456]=",ExpressionUUID->"8638032a-3f7a-534c-b9f5-22e125db4185"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.544603693677801*^9, 3.544603695958932*^9}},
 CellLabel->
  "In[457]:=",ExpressionUUID->"65aa5c4a-9d51-4aac-a9b7-c166eb381bcf"],

Cell[BoxData["\<\"\\\\tfrac{1}{\\\\sqrt{2}}\\\\tau_{abc}\"\>"], "Output",
 CellChangeTimes->{
  3.5823477961231174`*^9, 3.5823538545828514`*^9, 3.582353967435657*^9, 
   3.583130720797823*^9, 3.583133040850498*^9, 3.583133120816239*^9, 
   3.58313319577537*^9, 3.5831333024327583`*^9, 3.583133334444014*^9, 
   3.5831351992722893`*^9, 3.5831353247745094`*^9, 3.5831380845305576`*^9, 
   3.5831382088013763`*^9, 3.5831466225122056`*^9, 3.583150172720242*^9, 
   3.5831502236855316`*^9, 3.5831502720300174`*^9, {3.58796518360146*^9, 
   3.5879652040218954`*^9}, 3.588079872951629*^9, 3.588079956286975*^9, 
   3.5880833290805063`*^9, 3.588083689285139*^9, 3.588316615127076*^9, 
   3.58831884356179*^9, 3.5883190198108997`*^9, 3.588319169321563*^9, 
   3.58832582701444*^9, 3.588325958304271*^9, 3.5883269166617546`*^9, 
   3.588327860058811*^9, 3.588327929229333*^9, 3.5883280191946907`*^9, 
   3.5883284735454884`*^9, 3.5883285576920376`*^9, 3.588329397068111*^9, {
   3.5883296805518084`*^9, 3.58832970407665*^9}, 3.5883299123360157`*^9, 
   3.6151308259868593`*^9, 3.615131008120485*^9, 3.619089166010087*^9, 
   3.619626215419158*^9, 3.620542571698579*^9, 3.6463817100309696`*^9, 
   3.679983968978236*^9, 3.679984668596683*^9, 3.6977391840171804`*^9, 
   3.697739239099258*^9, 3.715232893436672*^9, 3.715233064672379*^9, 
   3.715233745277897*^9, 3.7273348983274903`*^9, 3.727335238146163*^9, 
   3.727335330704103*^9, 3.727336142952404*^9, 3.7273362345524235`*^9, 
   3.727336465356214*^9, 3.7273367355815334`*^9, 3.727337057737104*^9, 
   3.727340514651596*^9, 3.7273406229526997`*^9, 3.727340739491123*^9, 
   3.727341332174392*^9, 3.727342072562007*^9, 3.727343586378821*^9, 
   3.727343669486362*^9, 3.727343749310163*^9, 3.727343857589807*^9, 
   3.7274106456892676`*^9, 3.728277229541215*^9, 3.7282781630045233`*^9, {
   3.7282784874245515`*^9, 3.728278493779832*^9}, {3.728278605133098*^9, 
   3.7282786277711215`*^9}, 3.728280821793378*^9, 3.728280994121361*^9, 
   3.728483764956723*^9, 3.728551304056968*^9, 3.7285517984477797`*^9, 
   3.7288045692183*^9, 3.728804692084328*^9, 3.7288085186605315`*^9, 
   3.728808860945968*^9, 3.7779140133979406`*^9, 3.777914084321074*^9, 
   3.7910938001308417`*^9, 3.7910939496971955`*^9, 3.820204747574101*^9, 
   3.8202072066652083`*^9, 3.820207297346798*^9, 3.8202073660734053`*^9, 
   3.842762464054346*^9, 3.8443900049309897`*^9, 3.84439007630665*^9, 
   3.8443906741269298`*^9, 3.84439107903709*^9, 3.875891575295162*^9, 
   3.875891994541774*^9, 3.921306832502434*^9, 3.921306906859892*^9, 
   3.92130694975008*^9, 3.9584003369974174`*^9},
 CellLabel->
  "Out[457]=",ExpressionUUID->"b3ec095e-4be1-5b47-a11a-e5c9f0ee997a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "3"}], 
  RowBox[{"Sqrt", "[", "2", "]"}], 
  RowBox[{"\[Lambda]", "[", "]"}]}]], "Input",
 CellLabel->
  "In[458]:=",ExpressionUUID->"ced8519e-c6aa-4245-b24e-1553ae26ed91"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["2"], " ", 
   InterpretationBox[
    StyleBox["\[Lambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Lambda][],
    Editable->False]}], "3"]], "Output",
 CellChangeTimes->{
  3.582347796169918*^9, 3.582353854598451*^9, 3.582353967451257*^9, 
   3.583130720813423*^9, 3.583133040866098*^9, 3.583133120831839*^9, 
   3.58313319577537*^9, 3.5831333024483585`*^9, 3.583133334459614*^9, 
   3.5831351992722893`*^9, 3.5831353247901096`*^9, 3.583138084546157*^9, 
   3.5831382088169765`*^9, 3.5831466225278053`*^9, 3.5831501727358418`*^9, 
   3.5831502236855316`*^9, 3.583150272045616*^9, {3.58796518360146*^9, 
   3.587965204037496*^9}, 3.588079872951629*^9, 3.588079956302575*^9, 
   3.5880833291117067`*^9, 3.5880836893163395`*^9, 3.5883166151426773`*^9, 
   3.58831884357739*^9, 3.5883190198421*^9, 3.588319169352762*^9, 
   3.58832582701444*^9, 3.588325958304271*^9, 3.588326916677354*^9, 
   3.588327860058811*^9, 3.588327929229333*^9, 3.5883280191946907`*^9, 
   3.588328473561088*^9, 3.588328557707638*^9, 3.588329397083711*^9, {
   3.588329680567409*^9, 3.58832970407665*^9}, 3.588329912351615*^9, 
   3.6151308259968596`*^9, 3.615131008120485*^9, 3.619089166010087*^9, 
   3.6196262154291577`*^9, 3.620542571708578*^9, 3.646381710050968*^9, 
   3.6799839689882355`*^9, 3.6799846686066837`*^9, 3.697739184027181*^9, 
   3.697739239109258*^9, 3.7152328935000763`*^9, 3.715233064721341*^9, 
   3.715233745331883*^9, 3.727334898343116*^9, 3.72733523816179*^9, 
   3.7273353307197285`*^9, 3.7273361429836574`*^9, 3.727336234568048*^9, 
   3.7273364653904743`*^9, 3.7273367356127877`*^9, 3.727337057757248*^9, 
   3.727340514674815*^9, 3.727340623012118*^9, 3.727340739510734*^9, 
   3.72734133222177*^9, 3.727342072598812*^9, 3.7273435864103847`*^9, 
   3.727343669517588*^9, 3.727343749357044*^9, 3.7273438576054344`*^9, 
   3.727410645705132*^9, 3.728277229610283*^9, 3.7282784974988446`*^9, {
   3.728278605148722*^9, 3.728278627789765*^9}, 3.7282808217978573`*^9, 
   3.728280994121361*^9, 3.728483765025754*^9, 3.728551304074233*^9, 
   3.728551798463372*^9, 3.728804569229301*^9, 3.728804692100329*^9, 
   3.728808518676167*^9, 3.728808860961596*^9, 3.777914013431656*^9, 
   3.7779140843523626`*^9, 3.791093800252801*^9, 3.791093949788337*^9, 
   3.82020474761995*^9, 3.82020720670308*^9, 3.820207297390313*^9, 
   3.820207366109309*^9, 3.842762464079307*^9, 3.8443900049419537`*^9, 
   3.844390076316629*^9, 3.844390674154826*^9, 3.84439107906698*^9, 
   3.875891575301146*^9, 3.875891994557727*^9, 3.921306832531355*^9, 
   3.9213069068848515`*^9, 3.921306949770029*^9, 3.95840033701532*^9},
 CellLabel->
  "Out[458]=",ExpressionUUID->"e5d62371-dd94-804f-bdd0-7a973e1c94cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"\[Lambda]", "[", "]"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"\[Lambda]", "[", "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.544608577367132*^9, 3.544608608952939*^9}},
 CellLabel->
  "In[459]:=",ExpressionUUID->"97ee2517-3cfa-4dcc-a7f7-89e7418d950f"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "+", 
   InterpretationBox[
    StyleBox["\[Lambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Lambda][],
    Editable->False]}], 
  RowBox[{"1", "+", 
   InterpretationBox[
    StyleBox["\[Lambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Lambda][],
    Editable->False]}]]], "Output",
 CellChangeTimes->{
  3.582347796185518*^9, 3.582353854614051*^9, 3.582353967466857*^9, 
   3.5831307208290243`*^9, 3.583133040881699*^9, 3.583133120831839*^9, 
   3.58313319579097*^9, 3.583133302463958*^9, 3.583133334475214*^9, 
   3.583135199303489*^9, 3.58313532480571*^9, 3.583138084561757*^9, 
   3.5831382088169765`*^9, 3.5831466225434055`*^9, 3.583150172751442*^9, 
   3.583150223701132*^9, 3.583150272045616*^9, {3.5879651836170597`*^9, 
   3.587965204053096*^9}, 3.588079872967229*^9, 3.588079956302575*^9, 
   3.588083329142906*^9, 3.588083689331939*^9, 3.588316615158276*^9, 
   3.58831884359299*^9, 3.5883190198577*^9, 3.588319169368363*^9, 
   3.58832582703004*^9, 3.588325958319871*^9, 3.588326916692954*^9, 
   3.5883278600744123`*^9, 3.588327929244932*^9, 3.588328019210291*^9, 
   3.588328473561088*^9, 3.588328557723236*^9, 3.588329397099311*^9, {
   3.588329680567409*^9, 3.58832970409225*^9}, 3.588329912351615*^9, 
   3.6151308259968596`*^9, 3.615131008120485*^9, 3.619089166010087*^9, 
   3.619626215439158*^9, 3.620542571708578*^9, 3.646381710060969*^9, 
   3.679983968998235*^9, 3.679984668616683*^9, 3.6977391840371804`*^9, 
   3.697739239119258*^9, 3.7152328935504417`*^9, 3.715233064771413*^9, 
   3.715233745395102*^9, 3.727334898380853*^9, 3.727335238199564*^9, 
   3.727335330741879*^9, 3.7273361430209312`*^9, 3.727336234605319*^9, 
   3.727336465424752*^9, 3.727336735649586*^9, 3.7273370577728724`*^9, 
   3.727340514752996*^9, 3.727340623060057*^9, 3.727340739592592*^9, 
   3.7273413322431808`*^9, 3.727342072615001*^9, 3.7273435864260187`*^9, 
   3.727343669554926*^9, 3.727343749394789*^9, 3.7273438576366887`*^9, 
   3.72741064572073*^9, 3.728277368456182*^9, 3.7282784975351353`*^9, 
   3.728278529396969*^9, 3.7282786356719666`*^9, 3.728280821813508*^9, 
   3.728280994136987*^9, 3.728483765025754*^9, 3.728551304082256*^9, 
   3.728551798485552*^9, 3.728804569241302*^9, 3.7288046921153297`*^9, 
   3.728808518691805*^9, 3.7288088609772215`*^9, 3.777914013447217*^9, 
   3.777914084383575*^9, 3.791093800390737*^9, 3.791093949857384*^9, 
   3.820204747630946*^9, 3.820207206745966*^9, 3.820207297433169*^9, 
   3.820207366148737*^9, 3.842762464104242*^9, 3.844390004974866*^9, 
   3.844390076347517*^9, 3.844390674182752*^9, 3.844391079093908*^9, 
   3.8758915753261104`*^9, 3.8758919945637107`*^9, 3.921306832558283*^9, 
   3.9213069068918056`*^9, 3.9213069497750416`*^9, 3.95840033701532*^9},
 CellLabel->
  "Out[459]=",ExpressionUUID->"93c32313-f460-7d48-8ec2-0c72836d5513"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellLabel->
  "In[460]:=",ExpressionUUID->"70cde074-7478-40f1-82cb-252982955b79"],

Cell[BoxData["\<\"\\\\frac{2 + \\\\lambda}{1 + \\\\lambda}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796201118*^9, 3.582353854676452*^9, 3.582353967498057*^9, 
   3.5831307208290243`*^9, 3.583133040897298*^9, 3.583133120847439*^9, 
   3.58313319580657*^9, 3.5831333024795585`*^9, 3.583133334490814*^9, 
   3.583135199319089*^9, 3.58313532482131*^9, 3.583138084951758*^9, 
   3.583138208848175*^9, 3.5831466225590057`*^9, 3.583150172767042*^9, 
   3.5831502237167315`*^9, 3.5831502720612173`*^9, {3.58796518363266*^9, 
   3.587965204068696*^9}, 3.588079872982829*^9, 3.5880799563181753`*^9, 
   3.588083329174106*^9, 3.588083689394339*^9, 3.588316615158276*^9, 
   3.58831884360859*^9, 3.588319019873299*^9, 3.588319169399563*^9, 
   3.58832582704564*^9, 3.588325958335471*^9, 3.5883269167085547`*^9, 
   3.588327860090011*^9, 3.588327929260533*^9, 3.58832801922589*^9, 
   3.588328473576689*^9, 3.5883285577388372`*^9, 3.588329397114911*^9, {
   3.588329680583009*^9, 3.58832970410785*^9}, 3.588329912367215*^9, 
   3.6151308260068593`*^9, 3.615131008136084*^9, 3.6190891660200877`*^9, 
   3.6196262154491577`*^9, 3.620542571718579*^9, 3.646381710080969*^9, 
   3.679983969008233*^9, 3.679984668626683*^9, 3.69773918404718*^9, 
   3.697739239129258*^9, 3.71523289359881*^9, 3.715233064821391*^9, 
   3.7152337454953966`*^9, 3.727334898396479*^9, 3.7273352382464495`*^9, 
   3.7273353307575207`*^9, 3.727336143052455*^9, 3.7273362346369243`*^9, 
   3.727336465456006*^9, 3.727336735680956*^9, 3.7273370578041496`*^9, 
   3.7273405147842803`*^9, 3.727340623080729*^9, 3.727340739625924*^9, 
   3.727341332258814*^9, 3.727342072630602*^9, 3.7273435864528437`*^9, 
   3.727343669586206*^9, 3.7273437494104185`*^9, 3.727343857658845*^9, 
   3.727410645751994*^9, 3.7282785304182367`*^9, 3.728278636472137*^9, 
   3.728280821813508*^9, 3.728280994152623*^9, 3.72848376504138*^9, 
   3.728551304107215*^9, 3.728551798501213*^9, 3.728804569251302*^9, 
   3.7288046921323314`*^9, 3.728808518691805*^9, 3.7288088609772215`*^9, 
   3.7779140134941015`*^9, 3.777914084430446*^9, 3.791093800522272*^9, 
   3.7910939499411*^9, 3.820204747666849*^9, 3.8202072067579746`*^9, 
   3.820207297445136*^9, 3.8202073661906004`*^9, 3.842762464127179*^9, 
   3.844390005003795*^9, 3.844390076375442*^9, 3.844390674191728*^9, 
   3.844391079121832*^9, 3.8758915753320904`*^9, 3.875891994583657*^9, 
   3.9213068325632706`*^9, 3.92130690691477*^9, 3.921306949781996*^9, 
   3.9584003370316887`*^9},
 CellLabel->
  "Out[460]=",ExpressionUUID->"cfd57677-e61c-6b4b-81d5-dc4b6711f9f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$TexFractionAsFraction", "=", "False"}], "}"}], ",", 
   RowBox[{"TexPrint", "[", "%%", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[461]:=",ExpressionUUID->"96d06764-6c54-46d8-a435-5632ea98909e"],

Cell[BoxData["\<\"(1 + \\\\lambda)^{-1} (2 + \\\\lambda)\"\>"], "Output",
 CellChangeTimes->{
  3.582347796232318*^9, 3.582353854692052*^9, 3.5823539675136566`*^9, 
   3.583130720844623*^9, 3.583133040912898*^9, 3.583133120863039*^9, 
   3.583133195822171*^9, 3.5831333024951587`*^9, 3.583133334506414*^9, 
   3.583135199334689*^9, 3.58313532485251*^9, 3.583138085123358*^9, 
   3.583138208848175*^9, 3.5831466225590057`*^9, 3.583150172782642*^9, 
   3.583150223732332*^9, 3.5831502720768175`*^9, {3.58796518364826*^9, 
   3.5879652040842957`*^9}, 3.588079872998429*^9, 3.5880799563337755`*^9, 
   3.5880833292053065`*^9, 3.588083689425539*^9, 3.588316615173876*^9, 
   3.588318843624191*^9, 3.5883190198889*^9, 3.588319169430763*^9, 
   3.58832582706124*^9, 3.588325958351071*^9, 3.5883269167085547`*^9, 
   3.588327860105611*^9, 3.588327929260533*^9, 3.588328019241491*^9, 
   3.588328473592288*^9, 3.5883285577388372`*^9, 3.588329397114911*^9, {
   3.588329680598609*^9, 3.58832970410785*^9}, 3.588329912382815*^9, 
   3.615130826016859*^9, 3.615131008136084*^9, 3.6190891660200877`*^9, 
   3.6196262154491577`*^9, 3.6205425717285786`*^9, 3.646381710090968*^9, 
   3.679983969018233*^9, 3.679984668646684*^9, 3.6977391840571804`*^9, 
   3.697739239149258*^9, 3.715232893684214*^9, 3.715233064871404*^9, 
   3.715233745560649*^9, 3.727334898427734*^9, 3.7273352382777033`*^9, 
   3.7273353307887607`*^9, 3.7273361430993357`*^9, 3.7273362346838036`*^9, 
   3.7273364654716334`*^9, 3.727336735696556*^9, 3.727337057850422*^9, 
   3.727340514806438*^9, 3.727340623127613*^9, 3.727340739657153*^9, 
   3.727341332274434*^9, 3.727342072646222*^9, 3.727343586478972*^9, 
   3.727343669617462*^9, 3.727343749426045*^9, 3.727343857674474*^9, 
   3.727410645767638*^9, 3.728278638327311*^9, 3.7282808218313274`*^9, 
   3.728280994173257*^9, 3.728483765057009*^9, 3.728551304148507*^9, 
   3.728551798516827*^9, 3.7288045692623034`*^9, 3.728804692145331*^9, 
   3.72880851870744*^9, 3.728808860992875*^9, 3.777914013541012*^9, 
   3.7779140844617047`*^9, 3.791093800638195*^9, 3.7910939500017614`*^9, 
   3.820204747677796*^9, 3.820207206795832*^9, 3.820207297479045*^9, 
   3.82020736623009*^9, 3.842762464150135*^9, 3.844390005034706*^9, 
   3.8443900764043646`*^9, 3.844390674223667*^9, 3.844391079150756*^9, 
   3.87589157535201*^9, 3.8758919946056023`*^9, 3.9213068325921936`*^9, 
   3.9213069069197617`*^9, 3.921306949797985*^9, 3.9584003370500183`*^9},
 CellLabel->
  "Out[461]=",ExpressionUUID->"25db6ccb-cfba-3144-9674-1971cfded583"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fracexpr", "=", 
  RowBox[{
   RowBox[{"2", "/", "3"}], 
   RowBox[{
    RowBox[{"\[Lambda]", "[", "]"}], "^", "2"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"\[Lambda]", "[", "]"}], "+", 
      RowBox[{
       RowBox[{"\[Lambda]", "[", "]"}], "^", "2"}], "-", 
      RowBox[{"3", 
       RowBox[{
        RowBox[{"\[Lambda]", "[", "]"}], "^", "3"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"\[Lambda]", "[", "]"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7282777655075054`*^9, 3.728277774819925*^9}, {
   3.7282778081040797`*^9, 3.7282778161890798`*^9}, 3.7282779032592297`*^9, {
   3.728278120608246*^9, 3.7282781387606697`*^9}, {3.728280948837469*^9, 
   3.728280959446595*^9}},
 CellLabel->
  "In[462]:=",ExpressionUUID->"bacfa753-c77f-4a20-a9f4-1ce880b89132"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["\[Lambda]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Lambda][],
     Editable->False], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     InterpretationBox[
      StyleBox["\[Lambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Lambda][],
      Editable->False], "+", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["\[Lambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Lambda][],
       Editable->False], "2"], "-", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["\[Lambda]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Lambda][],
        Editable->False], "3"]}]}], ")"}]}], 
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     InterpretationBox[
      StyleBox["\[Lambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Lambda][],
      Editable->False]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.72827777545163*^9, 3.728277817527781*^9, 3.728277903943857*^9, 
   3.728278497549936*^9, 3.728278642030345*^9, {3.728280551018088*^9, 
   3.728280563761489*^9}, 3.7282808218313274`*^9, 3.728280960966877*^9, 
   3.728280994174761*^9, 3.728483765057009*^9, 3.728551304158069*^9, 
   3.728551798516827*^9, 3.728804569274304*^9, 3.728804692159332*^9, 
   3.728808518723038*^9, 3.728808861013002*^9, 3.777914013587848*^9, 
   3.777914084508587*^9, 3.791093800760631*^9, 3.7910939501202145`*^9, 
   3.820204747717689*^9, 3.8202072068347273`*^9, 3.8202072975209336`*^9, 
   3.8202073662410283`*^9, 3.8427624641780386`*^9, 3.8443900050656214`*^9, 
   3.84439007643229*^9, 3.844390674251592*^9, 3.8443910791846647`*^9, 
   3.875891575375973*^9, 3.875891994624552*^9, 3.921306832618124*^9, 
   3.921306906945694*^9, 3.9213069498169346`*^9, 3.9584003370500183`*^9},
 CellLabel->
  "Out[462]=",ExpressionUUID->"a7399d14-7036-c644-a12a-9fe54abf0d26"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "fracexpr"}]], "Input",
 CellChangeTimes->{3.7282809653556895`*^9},
 CellLabel->
  "In[463]:=",ExpressionUUID->"5d90c74a-5cc3-451d-be3b-4c3ec35dd83c"],

Cell[BoxData["\<\"\\\\frac{2 \\\\lambda^2 (2 + \\\\lambda + \\\\lambda^2 - 3 \
\\\\lambda^3)}{3 (1 + \\\\lambda)}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796201118*^9, 3.582353854676452*^9, 3.582353967498057*^9, 
   3.5831307208290243`*^9, 3.583133040897298*^9, 3.583133120847439*^9, 
   3.58313319580657*^9, 3.5831333024795585`*^9, 3.583133334490814*^9, 
   3.583135199319089*^9, 3.58313532482131*^9, 3.583138084951758*^9, 
   3.583138208848175*^9, 3.5831466225590057`*^9, 3.583150172767042*^9, 
   3.5831502237167315`*^9, 3.5831502720612173`*^9, {3.58796518363266*^9, 
   3.587965204068696*^9}, 3.588079872982829*^9, 3.5880799563181753`*^9, 
   3.588083329174106*^9, 3.588083689394339*^9, 3.588316615158276*^9, 
   3.58831884360859*^9, 3.588319019873299*^9, 3.588319169399563*^9, 
   3.58832582704564*^9, 3.588325958335471*^9, 3.5883269167085547`*^9, 
   3.588327860090011*^9, 3.588327929260533*^9, 3.58832801922589*^9, 
   3.588328473576689*^9, 3.5883285577388372`*^9, 3.588329397114911*^9, {
   3.588329680583009*^9, 3.58832970410785*^9}, 3.588329912367215*^9, 
   3.6151308260068593`*^9, 3.615131008136084*^9, 3.6190891660200877`*^9, 
   3.6196262154491577`*^9, 3.620542571718579*^9, 3.646381710080969*^9, 
   3.679983969008233*^9, 3.679984668626683*^9, 3.69773918404718*^9, 
   3.697739239129258*^9, 3.71523289359881*^9, 3.715233064821391*^9, 
   3.7152337454953966`*^9, 3.727334898396479*^9, 3.7273352382464495`*^9, 
   3.7273353307575207`*^9, 3.727336143052455*^9, 3.7273362346369243`*^9, 
   3.727336465456006*^9, 3.727336735680956*^9, 3.7273370578041496`*^9, 
   3.7273405147842803`*^9, 3.727340623080729*^9, 3.727340739625924*^9, 
   3.727341332258814*^9, 3.727342072630602*^9, 3.7273435864528437`*^9, 
   3.727343669586206*^9, 3.7273437494104185`*^9, 3.727343857658845*^9, 
   3.727410645751994*^9, 3.7282785304182367`*^9, {3.728278636472137*^9, 
   3.7282786480180426`*^9}, 3.728280821846989*^9, 3.728280994190406*^9, 
   3.7284837650882616`*^9, 3.728551304182241*^9, 3.7285517985324316`*^9, 
   3.728804569285304*^9, 3.7288046921713333`*^9, 3.728808518723038*^9, 
   3.728808861015007*^9, 3.777914013634751*^9, 3.777914084555448*^9, 
   3.791093800943954*^9, 3.791093950189237*^9, 3.820204747758607*^9, 
   3.820207206872627*^9, 3.820207297557864*^9, 3.8202073662799244`*^9, 
   3.8427624642019787`*^9, 3.844390005098536*^9, 3.844390076442294*^9, 
   3.844390674279518*^9, 3.844391079217577*^9, 3.875891575396918*^9, 
   3.875891994641507*^9, 3.921306832643057*^9, 3.9213069069705944`*^9, 
   3.9213069498338585`*^9, 3.9584003370736732`*^9},
 CellLabel->
  "Out[463]=",ExpressionUUID->"2ef7cb35-3cb4-834a-a147-d77efb73ac92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$TexNoSumInNumerator", "=", "True"}], "}"}], ",", 
   RowBox[{"TexPrint", "[", "fracexpr", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7282786562580566`*^9, 3.728278660593625*^9}, 
   3.7282809674891*^9},
 CellLabel->
  "In[464]:=",ExpressionUUID->"11ab5431-f903-4920-9bda-4f565105fe7c"],

Cell[BoxData["\<\"\\\\frac{2 \\\\lambda^2}{3 (1 + \\\\lambda)} (2 + \
\\\\lambda + \\\\lambda^2 - 3 \\\\lambda^3)\"\>"], "Output",
 CellChangeTimes->{
  3.582347796232318*^9, 3.582353854692052*^9, 3.5823539675136566`*^9, 
   3.583130720844623*^9, 3.583133040912898*^9, 3.583133120863039*^9, 
   3.583133195822171*^9, 3.5831333024951587`*^9, 3.583133334506414*^9, 
   3.583135199334689*^9, 3.58313532485251*^9, 3.583138085123358*^9, 
   3.583138208848175*^9, 3.5831466225590057`*^9, 3.583150172782642*^9, 
   3.583150223732332*^9, 3.5831502720768175`*^9, {3.58796518364826*^9, 
   3.5879652040842957`*^9}, 3.588079872998429*^9, 3.5880799563337755`*^9, 
   3.5880833292053065`*^9, 3.588083689425539*^9, 3.588316615173876*^9, 
   3.588318843624191*^9, 3.5883190198889*^9, 3.588319169430763*^9, 
   3.58832582706124*^9, 3.588325958351071*^9, 3.5883269167085547`*^9, 
   3.588327860105611*^9, 3.588327929260533*^9, 3.588328019241491*^9, 
   3.588328473592288*^9, 3.5883285577388372`*^9, 3.588329397114911*^9, {
   3.588329680598609*^9, 3.58832970410785*^9}, 3.588329912382815*^9, 
   3.615130826016859*^9, 3.615131008136084*^9, 3.6190891660200877`*^9, 
   3.6196262154491577`*^9, 3.6205425717285786`*^9, 3.646381710090968*^9, 
   3.679983969018233*^9, 3.679984668646684*^9, 3.6977391840571804`*^9, 
   3.697739239149258*^9, 3.715232893684214*^9, 3.715233064871404*^9, 
   3.715233745560649*^9, 3.727334898427734*^9, 3.7273352382777033`*^9, 
   3.7273353307887607`*^9, 3.7273361430993357`*^9, 3.7273362346838036`*^9, 
   3.7273364654716334`*^9, 3.727336735696556*^9, 3.727337057850422*^9, 
   3.727340514806438*^9, 3.727340623127613*^9, 3.727340739657153*^9, 
   3.727341332274434*^9, 3.727342072646222*^9, 3.727343586478972*^9, 
   3.727343669617462*^9, 3.727343749426045*^9, 3.727343857674474*^9, 
   3.727410645767638*^9, {3.728278638327311*^9, 3.728278661694792*^9}, 
   3.728280821862613*^9, 3.728280994206033*^9, 3.728483765126038*^9, 
   3.728551304213499*^9, 3.728551798548064*^9, 3.728804569295305*^9, 
   3.728804692182333*^9, 3.728808518738694*^9, 3.728808861030636*^9, 
   3.7779140136757197`*^9, 3.777914084680453*^9, 3.791093801064026*^9, 
   3.791093950261901*^9, 3.8202047477735667`*^9, 3.820207206915512*^9, 
   3.8202072975698023`*^9, 3.820207366322837*^9, 3.84276246422791*^9, 
   3.844390005132444*^9, 3.844390076472211*^9, 3.844390674288497*^9, 
   3.8443910792455015`*^9, 3.8758915754178343`*^9, 3.875891994658461*^9, 
   3.9213068326659946`*^9, 3.9213069069925632`*^9, 3.9213069498518105`*^9, 
   3.958400337091755*^9},
 CellLabel->
  "Out[464]=",ExpressionUUID->"ebb1e5c1-b90d-0f45-b2c1-6fd54dfb89cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$TexNoSumInNumerator", "=", "True"}], "}"}], ",", 
   RowBox[{"TexPrint", "[", 
    RowBox[{"fracexpr", "//.", "ToOrderedPlus"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{3.728280918128976*^9, 3.728280970091775*^9},
 CellLabel->
  "In[465]:=",ExpressionUUID->"7bf38c93-d315-442b-8905-d6893a24cfae"],

Cell[BoxData["\<\"\\\\frac{2 \\\\lambda^2}{3 (\\\\lambda + 1)} (-3 \
\\\\lambda^3 + \\\\lambda^2 + \\\\lambda + 2)\"\>"], "Output",
 CellChangeTimes->{3.7282809206596274`*^9, 3.728280994221659*^9, 
  3.728483765141671*^9, 3.728551304229131*^9, 3.728551798563713*^9, 
  3.728804569309305*^9, 3.728804692194334*^9, 3.728808518738694*^9, 
  3.7288088610462666`*^9, 3.777914013722559*^9, 3.777914084711704*^9, 
  3.791093801179738*^9, 3.791093950324403*^9, 3.820204747812434*^9, 
  3.820207206925513*^9, 3.820207297604709*^9, 3.820207366360708*^9, 
  3.8427624642518444`*^9, 3.844390005165328*^9, 3.844390076505096*^9, 
  3.844390674316394*^9, 3.844391079257497*^9, 3.87589157542584*^9, 
  3.875891994670401*^9, 3.92130683269392*^9, 3.9213069070165005`*^9, 
  3.921306949868763*^9, 3.9584003371077576`*^9},
 CellLabel->
  "Out[465]=",ExpressionUUID->"af949d5e-6f97-ac48-a0ad-ed26e2950103"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "/", "3"}], "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "*", 
  RowBox[{"\[Lambda]", "[", "]"}]}]], "Input",
 CellChangeTimes->{3.544608362872864*^9},
 CellLabel->
  "In[466]:=",ExpressionUUID->"3037f38c-99ee-4786-81b4-16f0b519a3ed"],

Cell[BoxData[
 FractionBox[
  InterpretationBox[
   StyleBox["\[Lambda]",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Lambda][],
   Editable->False], 
  RowBox[{"3", " ", 
   SqrtBox["2"]}]]], "Output",
 CellChangeTimes->{
  3.5823477962479186`*^9, 3.5823538547076516`*^9, 3.582353967529257*^9, 
   3.5831307208602242`*^9, 3.583133040928499*^9, 3.5831331208786387`*^9, 
   3.583133195822171*^9, 3.5831333025107584`*^9, 3.583133334506414*^9, 
   3.5831351993502893`*^9, 3.58313532485251*^9, 3.583138085138958*^9, 
   3.583138208863776*^9, 3.583146622574606*^9, 3.583150172782642*^9, 
   3.583150223747932*^9, 3.5831502720924177`*^9, {3.58796518366386*^9, 
   3.587965204099896*^9}, 3.588079873014028*^9, 3.5880799563493752`*^9, 
   3.5880833292365065`*^9, 3.5880836894567394`*^9, 3.588316615189476*^9, 
   3.5883188436397905`*^9, 3.5883190199045*^9, 3.588319169446363*^9, 
   3.58832582706124*^9, 3.588325958351071*^9, 3.588326916724154*^9, 
   3.588327860105611*^9, 3.588327929276133*^9, 3.588328019241491*^9, 
   3.5883284736078887`*^9, 3.5883285577544374`*^9, 3.588329397130511*^9, {
   3.5883296806142087`*^9, 3.5883297041234508`*^9}, 3.588329912398415*^9, 
   3.615130826016859*^9, 3.615131008136084*^9, 3.619089166090088*^9, 
   3.619626215459158*^9, 3.6205425717285786`*^9, 3.646381710110969*^9, 
   3.679983969028232*^9, 3.679984668656684*^9, 3.6977391840671806`*^9, 
   3.697739239159258*^9, 3.715232893733381*^9, 3.715233064921574*^9, 
   3.715233745611472*^9, 3.727334898458988*^9, 3.727335238315482*^9, 
   3.727335330804387*^9, 3.727336143137138*^9, 3.7273362347059517`*^9, 
   3.727336465494235*^9, 3.727336735733149*^9, 3.727337057897302*^9, 
   3.727340514837723*^9, 3.727340623165388*^9, 3.727340739694427*^9, 
   3.72734133229006*^9, 3.72734207266185*^9, 3.727343586494999*^9, 
   3.727343669639134*^9, 3.7273437494573307`*^9, 3.727343857705728*^9, 
   3.7274106457882843`*^9, 3.728278672461294*^9, 3.728280994237285*^9, 
   3.7284837651572943`*^9, 3.728551304244748*^9, 3.728551798585399*^9, 
   3.728804569320306*^9, 3.728804692206334*^9, 3.728808518807256*^9, 
   3.7288088610618906`*^9, 3.7779140137381835`*^9, 3.7779140847429914`*^9, 
   3.791093801286701*^9, 3.791093950404555*^9, 3.820204747854125*^9, 
   3.8202072069614167`*^9, 3.820207297616677*^9, 3.8202073663956428`*^9, 
   3.8427624642767873`*^9, 3.8443900051992617`*^9, 3.844390076535015*^9, 
   3.844390674346316*^9, 3.844391079286392*^9, 3.875891575447791*^9, 
   3.8758919946764154`*^9, 3.921306832698908*^9, 3.9213069070394115`*^9, 
   3.9213069498737507`*^9, 3.9584003371196156`*^9},
 CellLabel->
  "Out[466]=",ExpressionUUID->"41fc8242-e96a-d34a-956e-663b0ec838d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellLabel->
  "In[467]:=",ExpressionUUID->"65a4252c-ec4f-46ce-be7f-4db6838b8407"],

Cell[BoxData["\<\"\\\\tfrac{1}{3 \\\\sqrt{2}}\\\\lambda \"\>"], "Output",
 CellChangeTimes->{
  3.582347796263518*^9, 3.5823538547232513`*^9, 3.582353967544857*^9, 
   3.583130720875823*^9, 3.5831330409440994`*^9, 3.583133120894239*^9, 
   3.583133195837771*^9, 3.583133302526359*^9, 3.5831333345220146`*^9, 
   3.583135199365889*^9, 3.58313532488371*^9, 3.583138085310559*^9, 
   3.5831382088793764`*^9, 3.583146622590206*^9, 3.583150172798242*^9, 
   3.583150223779132*^9, 3.5831502721080174`*^9, {3.58796518366386*^9, 
   3.587965204115496*^9}, 3.588079873014028*^9, 3.588079956364975*^9, 
   3.588083329267707*^9, 3.58808368948794*^9, 3.588316615205076*^9, 
   3.588318843655391*^9, 3.5883190199201*^9, 3.588319169477563*^9, 
   3.5883258270768404`*^9, 3.588325958366671*^9, 3.588326916739754*^9, 
   3.588327860121211*^9, 3.588327929291733*^9, 3.5883280192570906`*^9, 
   3.5883284736078887`*^9, 3.588328557770038*^9, 3.588329397146111*^9, {
   3.5883296806142087`*^9, 3.58832970413905*^9}, 3.588329912398415*^9, 
   3.6151308260268598`*^9, 3.615131008136084*^9, 3.619089166100088*^9, 
   3.619626215469158*^9, 3.620542571738579*^9, 3.646381710120969*^9, 
   3.679983969038231*^9, 3.679984668666684*^9, 3.6977391840771804`*^9, 
   3.697739239169258*^9, 3.715232893788941*^9, 3.715233064975356*^9, 
   3.7152337456614537`*^9, 3.727334898527866*^9, 3.727335238346737*^9, 
   3.727335330842164*^9, 3.727336143152738*^9, 3.72733623472158*^9, 
   3.727336465509897*^9, 3.727336735765995*^9, 3.7273370579350805`*^9, 
   3.727340514853339*^9, 3.7273406231942673`*^9, 3.727340739725817*^9, 
   3.727341332305687*^9, 3.727342072697646*^9, 3.727343586526257*^9, 
   3.7273436696547613`*^9, 3.727343749491602*^9, 3.727343857736981*^9, 
   3.727410645803917*^9, 3.728278672561734*^9, 3.7282809942907104`*^9, 
   3.728483765226329*^9, 3.728551304313531*^9, 3.728551798601046*^9, 
   3.7288045693313074`*^9, 3.728804692218335*^9, 3.7288085188755097`*^9, 
   3.7288088610775146`*^9, 3.7779140137850866`*^9, 3.777914084789821*^9, 
   3.7910938013788013`*^9, 3.791093950474923*^9, 3.82020474786512*^9, 
   3.820207206972388*^9, 3.8202072976546035`*^9, 3.820207366430549*^9, 
   3.842762464290714*^9, 3.844390005209238*^9, 3.844390076564935*^9, 
   3.844390674374264*^9, 3.8443910793173113`*^9, 3.875891575466733*^9, 
   3.8758919946893787`*^9, 3.9213068327038937`*^9, 3.9213069070454197`*^9, 
   3.9213069498907375`*^9, 3.95840033712842*^9},
 CellLabel->
  "Out[467]=",ExpressionUUID->"14db9aa8-ad65-e544-9410-62311c2e737a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
   RowBox[{"\[Lambda]", "[", "]"}]}], "/", "3"}]], "Input",
 CellChangeTimes->{{3.54460372932484*^9, 3.544603734308125*^9}, {
   3.544603775909505*^9, 3.5446037779386206`*^9}, {3.544603901778704*^9, 
   3.54460393876782*^9}, 3.544605084612358*^9},
 CellLabel->
  "In[468]:=",ExpressionUUID->"94967384-f559-4a0b-91a3-a1b15d50bebd"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SqrtBox["2"], 
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox["\[Lambda]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Lambda][],
     Editable->False]}]]}]], "Output",
 CellChangeTimes->{
  3.5823477962791176`*^9, 3.582353854738851*^9, 3.582353967560457*^9, 
   3.583130720875823*^9, 3.583133040959698*^9, 3.583133120894239*^9, 
   3.5831331958533716`*^9, 3.583133302541958*^9, 3.583133334537614*^9, 
   3.5831351993814898`*^9, 3.58313532489931*^9, 3.583138085372958*^9, 
   3.5831382088949766`*^9, 3.583146622605806*^9, 3.583150172813842*^9, 
   3.5831502237947316`*^9, 3.5831502721236176`*^9, {3.58796518367946*^9, 
   3.587965204131096*^9}, 3.5880798730296288`*^9, 3.588079956364975*^9, 
   3.588083329298907*^9, 3.588083689503539*^9, 3.588316615220676*^9, 
   3.58831884368659*^9, 3.5883190199356995`*^9, 3.5883191695087624`*^9, 
   3.58832582709244*^9, 3.588325958382271*^9, 3.588326916739754*^9, 
   3.588327860136812*^9, 3.588327929307333*^9, 3.588328019272691*^9, 
   3.588328473623489*^9, 3.588328557770038*^9, 3.588329397161711*^9, {
   3.588329680629809*^9, 3.58832970413905*^9}, 3.588329912414015*^9, 
   3.6151308260368595`*^9, 3.615131008151684*^9, 3.619089166100088*^9, 
   3.619626215479158*^9, 3.620542571738579*^9, 3.646381710140969*^9, 
   3.67998396904823*^9, 3.679984668676684*^9, 3.6977391840971804`*^9, 
   3.6977392391792583`*^9, 3.7152328938509903`*^9, 3.715233065021638*^9, 
   3.7152337457121286`*^9, 3.7273348985812216`*^9, 3.727335238377988*^9, 
   3.72733533087342*^9, 3.7273361431839895`*^9, 3.7273362347372074`*^9, 
   3.7273364655411496`*^9, 3.727336735781618*^9, 3.727337057966335*^9, 
   3.7273405148846035`*^9, 3.727340623225527*^9, 3.727340739757046*^9, 
   3.727341332327976*^9, 3.72734207271433*^9, 3.72734358657815*^9, 
   3.727343669670415*^9, 3.72734374951669*^9, 3.727343857774514*^9, 
   3.7274106458195686`*^9, 3.72827867506173*^9, 3.728280994306338*^9, 
   3.7284837652419567`*^9, 3.728551304329158*^9, 3.728551798616679*^9, 
   3.728804569343308*^9, 3.728804692231336*^9, 3.728808518891155*^9, 
   3.728808861093146*^9, 3.7779140138320312`*^9, 3.7779140849304533`*^9, 
   3.791093801477597*^9, 3.791093950542492*^9, 3.820204747902025*^9, 
   3.820207207010889*^9, 3.820207297691504*^9, 3.820207366441517*^9, 
   3.8427624643176427`*^9, 3.844390005298998*^9, 3.84439007659286*^9, 
   3.844390674402165*^9, 3.844391079346233*^9, 3.8758915754727144`*^9, 
   3.875891994703342*^9, 3.921306832729824*^9, 3.9213069070683327`*^9, 
   3.921306949906662*^9, 3.9584003371381702`*^9},
 CellLabel->
  "Out[468]=",ExpressionUUID->"ef37a296-5a47-ad4b-ac4e-b17de306df51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellLabel->
  "In[469]:=",ExpressionUUID->"e7fdb2a4-953c-43cd-92b7-673965dc1231"],

Cell[BoxData["\<\"- \\\\frac{\\\\sqrt{2}}{3 \\\\lambda}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796294718*^9, 3.582353854754452*^9, 3.582353967622857*^9, 
   3.583130720891423*^9, 3.5831330409752994`*^9, 3.583133120909839*^9, 
   3.5831331958533716`*^9, 3.583133302557558*^9, 3.583133334553214*^9, 
   3.5831351993970895`*^9, 3.583135324914911*^9, 3.583138085528959*^9, 
   3.5831382088949766`*^9, 3.583146622605806*^9, 3.583150172845042*^9, 
   3.583150223810332*^9, 3.5831502721236176`*^9, {3.58796518369506*^9, 
   3.587965204146696*^9}, 3.588079873045229*^9, 3.588079956380575*^9, 
   3.5880833293301067`*^9, 3.588083689534739*^9, 3.588316615236276*^9, 
   3.588318843702191*^9, 3.5883190199513*^9, 3.588319169524363*^9, 
   3.58832582709244*^9, 3.588325958397871*^9, 3.588326916755354*^9, 
   3.5883278601524124`*^9, 3.588327929307333*^9, 3.588328019272691*^9, 
   3.588328473623489*^9, 3.5883285577856374`*^9, 3.588329397177311*^9, {
   3.5883296806454086`*^9, 3.58832970415465*^9}, 3.588329912429615*^9, 
   3.6151308260368595`*^9, 3.615131008151684*^9, 3.619089166110088*^9, 
   3.6196262154891577`*^9, 3.620542571748578*^9, 3.646381710150969*^9, 
   3.679983969058229*^9, 3.6799846686866846`*^9, 3.6977391841071806`*^9, 
   3.697739239199258*^9, 3.715232893917233*^9, 3.715233065071251*^9, 
   3.715233745761226*^9, 3.727334898612468*^9, 3.727335238400137*^9, 
   3.727335330904673*^9, 3.727336143221025*^9, 3.72733623476846*^9, 
   3.7273364655567536`*^9, 3.727336735812872*^9, 3.727337057997589*^9, 
   3.727340514921881*^9, 3.72734062326522*^9, 3.7273407397948513`*^9, 
   3.727341332343602*^9, 3.727342072745584*^9, 3.727343586657796*^9, 
   3.72734366970167*^9, 3.7273437495479445`*^9, 3.727343857821368*^9, 
   3.727410645835171*^9, 3.728278675108674*^9, 3.7282809943219647`*^9, 
   3.728483765257586*^9, 3.7285513043447866`*^9, 3.728551798629403*^9, 
   3.728804569353308*^9, 3.728804692244337*^9, 3.728808518906767*^9, 
   3.728808861093146*^9, 3.777914013863182*^9, 3.777914085055471*^9, 
   3.79109380157112*^9, 3.791093950620631*^9, 3.8202047479119954`*^9, 
   3.820207207020861*^9, 3.8202072977343616`*^9, 3.8202073664764*^9, 
   3.842762464345567*^9, 3.844390005331909*^9, 3.844390076623778*^9, 
   3.8443906744331064`*^9, 3.8443910793771486`*^9, 3.875891575491637*^9, 
   3.875891994708327*^9, 3.9213068327358093`*^9, 3.9213069070743446`*^9, 
   3.9213069499236183`*^9, 3.958400337148226*^9},
 CellLabel->
  "Out[469]=",ExpressionUUID->"ebe46b2e-70d2-0548-a230-edd090dc7062"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$TexFractionAsFraction", "=", "False"}], "}"}], ",", 
   RowBox[{"TexPrint", "[", "%%", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[470]:=",ExpressionUUID->"8de0f30e-bf4f-4302-b045-d577cfd94958"],

Cell[BoxData["\<\"- \\\\tfrac{1}{3} \\\\sqrt{2} \\\\lambda^{-1}\"\>"], \
"Output",
 CellChangeTimes->{
  3.582347796310318*^9, 3.582353854770052*^9, 3.582353967638457*^9, 
   3.5831307209070244`*^9, 3.583133040990898*^9, 3.583133120925439*^9, 
   3.583133195868971*^9, 3.583133302573158*^9, 3.5831333345688148`*^9, 
   3.5831351994126897`*^9, 3.58313532493051*^9, 3.583138085700559*^9, 
   3.583138208910576*^9, 3.583146622621406*^9, 3.583150172860643*^9, 
   3.583150223825932*^9, 3.5831502721392174`*^9, {3.58796518371066*^9, 
   3.587965204162297*^9}, 3.588079873060829*^9, 3.5880799563961754`*^9, 
   3.588083329376907*^9, 3.58808368955034*^9, 3.588316615251876*^9, 
   3.588318843717791*^9, 3.5883190199825*^9, 3.588319169555563*^9, 
   3.58832582710804*^9, 3.588325958397871*^9, 3.588326916770954*^9, 
   3.5883278601524124`*^9, 3.5883279293229337`*^9, 3.588328019288291*^9, 
   3.588328473639088*^9, 3.588328557801236*^9, 3.588329397177311*^9, {
   3.588329680661009*^9, 3.58832970417025*^9}, 3.588329912445215*^9, 
   3.6151308260468597`*^9, 3.615131008151684*^9, 3.619089166110088*^9, 
   3.6196262154891577`*^9, 3.620542571748578*^9, 3.646381710170969*^9, 
   3.6799839690682282`*^9, 3.679984668696684*^9, 3.6977391841171803`*^9, 
   3.697739239209258*^9, 3.715232894016815*^9, 3.715233065121436*^9, 
   3.715233745811483*^9, 3.7273348986281185`*^9, 3.7273352384470215`*^9, 
   3.7273353309424486`*^9, 3.727336143282252*^9, 3.727336234784086*^9, 
   3.727336465594071*^9, 3.727336735846162*^9, 3.727337058013231*^9, 
   3.727340514953133*^9, 3.7273406232967186`*^9, 3.727340739825158*^9, 
   3.727341332674656*^9, 3.727342072787929*^9, 3.727343586695624*^9, 
   3.727343669754573*^9, 3.727343749588223*^9, 3.72734385785864*^9, 
   3.727410645850828*^9, 3.728278675108674*^9, 3.7282809943375897`*^9, 
   3.7284837652732096`*^9, 3.728551304360444*^9, 3.728551798629403*^9, 
   3.728804569365309*^9, 3.728804692256337*^9, 3.728808518922392*^9, 
   3.7288088611153655`*^9, 3.7779140139100933`*^9, 3.777914085086702*^9, 
   3.7910938016310616`*^9, 3.791093950705328*^9, 3.820204747951891*^9, 
   3.8202072070567603`*^9, 3.820207297768298*^9, 3.820207366513301*^9, 
   3.8427624643705006`*^9, 3.844390005364835*^9, 3.8443900766507053`*^9, 
   3.844390674442058*^9, 3.844391079404077*^9, 3.875891575511613*^9, 
   3.875891994722263*^9, 3.9213068327617397`*^9, 3.9213069070793324`*^9, 
   3.921306949939602*^9, 3.95840033715431*^9},
 CellLabel->
  "Out[470]=",ExpressionUUID->"734ca6f7-68ed-d94a-992d-673f4419b26b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"\[Lambda]", "[", "]"}]}], "/", "3"}]], "Input",
 CellChangeTimes->{3.5446044193493075`*^9},
 CellLabel->
  "In[471]:=",ExpressionUUID->"ad1f19b8-270c-489b-bf11-b9aa728aa3bd"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox["\[Lambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Lambda][],
    Editable->False]}]]], "Output",
 CellChangeTimes->{
  3.582347796325918*^9, 3.5823538548012514`*^9, 3.5823539676540565`*^9, 
   3.583130720922623*^9, 3.5831330410065*^9, 3.583133120941039*^9, 
   3.58313319588457*^9, 3.583133302573158*^9, 3.583133334584414*^9, 
   3.583135199428289*^9, 3.58313532494611*^9, 3.583138085716159*^9, 
   3.583138208926176*^9, 3.583146622637006*^9, 3.583150172860643*^9, 
   3.583150223825932*^9, 3.583150272154817*^9, {3.58796518371066*^9, 
   3.587965204162297*^9}, 3.588079873076429*^9, 3.5880799564117756`*^9, 
   3.588083329408107*^9, 3.58808368956594*^9, 3.588316615267476*^9, 
   3.588318843733391*^9, 3.5883190199981003`*^9, 3.588319169586763*^9, 
   3.58832582712364*^9, 3.5883259584134717`*^9, 3.588326916770954*^9, 
   3.588327860168011*^9, 3.588327929338533*^9, 3.5883280193038907`*^9, 
   3.588328473654689*^9, 3.588328557801236*^9, 3.588329397192911*^9, {
   3.588329680661009*^9, 3.58832970418585*^9}, 3.588329912445215*^9, 
   3.615130826056859*^9, 3.615131008151684*^9, 3.619089166120087*^9, 
   3.619626215499158*^9, 3.620542571758579*^9, 3.646381710190969*^9, 
   3.679983969078228*^9, 3.679984668706684*^9, 3.69773918412718*^9, 
   3.6977392392192583`*^9, 3.7152328941827106`*^9, 3.7152330651724796`*^9, 
   3.715233745860709*^9, 3.727334898665941*^9, 3.727335238494908*^9, 
   3.727335330958077*^9, 3.727336143336668*^9, 3.727336234821656*^9, 
   3.7273364656096992`*^9, 3.7273367359469604`*^9, 3.727337058035363*^9, 
   3.727340515000521*^9, 3.727340623346492*^9, 3.7273407398473396`*^9, 
   3.727341332690284*^9, 3.727342072814724*^9, 3.7273435867164335`*^9, 
   3.727343669785854*^9, 3.7273437496259985`*^9, 3.727343857874586*^9, 
   3.72741064588205*^9, 3.72827868545411*^9, 3.7282809943375897`*^9, 
   3.7284837652732096`*^9, 3.7285513043770437`*^9, 3.728551798645034*^9, 
   3.72880456937631*^9, 3.7288046922693386`*^9, 3.72880851893802*^9, 
   3.728808861130994*^9, 3.777914013925681*^9, 3.777914085133571*^9, 
   3.7910938016936007`*^9, 3.791093950789981*^9, 3.820204747992755*^9, 
   3.820207207104252*^9, 3.820207297801183*^9, 3.8202073665492315`*^9, 
   3.842762464400421*^9, 3.844390005398743*^9, 3.84439007668165*^9, 
   3.844390674474*^9, 3.844391079433998*^9, 3.875891575517579*^9, 
   3.8758919947362533`*^9, 3.9213068327667255`*^9, 3.921306907103279*^9, 
   3.921306949956558*^9, 3.958400337170124*^9},
 CellLabel->
  "Out[471]=",ExpressionUUID->"a3adb552-9364-8d4e-8f00-fccdf7cfaf68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellLabel->
  "In[472]:=",ExpressionUUID->"9ada53dd-6e81-4803-ae49-525518d85913"],

Cell[BoxData["\<\"\\\\frac{1}{3 \\\\lambda}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796341518*^9, 3.5823538548168516`*^9, 3.582353967685257*^9, 
   3.583130720922623*^9, 3.5831330410220995`*^9, 3.583133120941039*^9, 
   3.58313319588457*^9, 3.583133302588758*^9, 3.583133334584414*^9, 
   3.583135199443889*^9, 3.58313532496171*^9, 3.583138085887759*^9, 
   3.5831382089417763`*^9, 3.583146622652606*^9, 3.583150172876243*^9, 
   3.583150223841532*^9, 3.583150272170417*^9, {3.58796518372626*^9, 
   3.587965204177896*^9}, 3.588079873076429*^9, 3.588079956427376*^9, 
   3.588083329439307*^9, 3.5880836895971394`*^9, 3.588316615267476*^9, 
   3.58831884374899*^9, 3.5883190200137*^9, 3.588319169617963*^9, 
   3.58832582712364*^9, 3.588325958429071*^9, 3.588326916786555*^9, 
   3.588327860183611*^9, 3.588327929338533*^9, 3.5883280193038907`*^9, 
   3.588328473654689*^9, 3.5883285578168373`*^9, 3.588329397208511*^9, {
   3.588329680676609*^9, 3.58832970418585*^9}, 3.588329912460815*^9, 
   3.615130826056859*^9, 3.615131008167284*^9, 3.619089166120087*^9, 
   3.619626215509158*^9, 3.6205425717685785`*^9, 3.6463817102009697`*^9, 
   3.679983969088227*^9, 3.679984668716685*^9, 3.6977391841371803`*^9, 
   3.6977392392392583`*^9, 3.715232894299636*^9, 3.715233065222458*^9, 
   3.715233745913964*^9, 3.7273348986815724`*^9, 3.72733523854306*^9, 
   3.7273353310427337`*^9, 3.727336143383549*^9, 3.727336234852909*^9, 
   3.7273364657091255`*^9, 3.727336735966139*^9, 3.727337058066619*^9, 
   3.727340515023903*^9, 3.727340623365705*^9, 3.727340739890628*^9, 
   3.727341332705907*^9, 3.72734207283037*^9, 3.727343586747687*^9, 
   3.727343669834741*^9, 3.7273437496572514`*^9, 3.7273438579214945`*^9, 
   3.727410645889574*^9, 3.728278685485833*^9, 3.7282809943532343`*^9, 
   3.7284837652888355`*^9, 3.728551304382086*^9, 3.72855179866066*^9, 
   3.7288045693883095`*^9, 3.7288046922813396`*^9, 3.7288085189581614`*^9, 
   3.728808861146619*^9, 3.7779140139569416`*^9, 3.7779140851960735`*^9, 
   3.791093801762588*^9, 3.7910939508585744`*^9, 3.820204748037634*^9, 
   3.82020720714215*^9, 3.820207297837087*^9, 3.820207366584138*^9, 
   3.842762464427349*^9, 3.844390005429655*^9, 3.8443900766916246`*^9, 
   3.844390674506885*^9, 3.844391079462949*^9, 3.875891575541504*^9, 
   3.87589199474124*^9, 3.9213068327916584`*^9, 3.9213069071421623`*^9, 
   3.921306949962513*^9, 3.958400337170124*^9},
 CellLabel->
  "Out[472]=",ExpressionUUID->"713626d3-d59d-3c46-a783-f48999278ab3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"\[Lambda]", "[", "]"}]}], "/", "3"}], "/", 
  RowBox[{"Sqrt", "[", "2", "]"}]}]], "Input",
 CellChangeTimes->{
  3.5446044193493075`*^9, {3.544604931472599*^9, 3.544604933370707*^9}},
 CellLabel->
  "In[473]:=",ExpressionUUID->"34617b48-81a8-49ee-a907-86394b072f33"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"3", " ", 
   SqrtBox["2"], " ", 
   InterpretationBox[
    StyleBox["\[Lambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Lambda][],
    Editable->False]}]]], "Output",
 CellChangeTimes->{
  3.5823477963571186`*^9, 3.5823538548480515`*^9, 3.582353967700857*^9, 
   3.583130720938223*^9, 3.5831330410377*^9, 3.583133120956639*^9, 
   3.583133195900171*^9, 3.583133302604359*^9, 3.5831333346000147`*^9, 
   3.58313519945949*^9, 3.58313532497731*^9, 3.58313808590336*^9, 
   3.5831382089417763`*^9, 3.583146622652606*^9, 3.583150172891843*^9, 
   3.583150223857132*^9, 3.583150272186017*^9, {3.58796518374186*^9, 
   3.5879652041934958`*^9}, 3.588079873092029*^9, 3.588079956427376*^9, 
   3.588083329470507*^9, 3.5880836896127396`*^9, 3.588316615283077*^9, 
   3.5883188437645907`*^9, 3.5883190200292997`*^9, 3.588319169633563*^9, 
   3.5883258271392403`*^9, 3.588325958429071*^9, 3.588326916802155*^9, 
   3.588327860183611*^9, 3.588327929354133*^9, 3.588328019319491*^9, 
   3.588328473670289*^9, 3.588328557832438*^9, 3.588329397224111*^9, {
   3.588329680692209*^9, 3.5883297042014513`*^9}, 3.5883299124764156`*^9, 
   3.6151308260668592`*^9, 3.615131008167284*^9, 3.619089166130088*^9, 
   3.619626215509158*^9, 3.6205425717685785`*^9, 3.6463817102209697`*^9, 
   3.679983969098226*^9, 3.679984668726685*^9, 3.6977391841471806`*^9, 
   3.6977392392492585`*^9, 3.7152328943669233`*^9, 3.715233065272752*^9, 
   3.71523374596457*^9, 3.727334898712847*^9, 3.727335238589685*^9, 
   3.727335331074906*^9, 3.727336143437454*^9, 3.72733623496873*^9, 
   3.7273364657403784`*^9, 3.7273367359974017`*^9, 3.7273370581135306`*^9, 
   3.727340515063688*^9, 3.7273406233969855`*^9, 3.727340739918343*^9, 
   3.727341332728057*^9, 3.7273420728459783`*^9, 3.727343586763351*^9, 
   3.727343669854938*^9, 3.727343749691029*^9, 3.727343857959281*^9, 
   3.7274106459053335`*^9, 3.728278685501493*^9, 3.728280994373528*^9, 
   3.72848376530898*^9, 3.728551304402973*^9, 3.728551798684842*^9, 
   3.72880456939931*^9, 3.72880469229334*^9, 3.728808518966762*^9, 
   3.728808861146619*^9, 3.777914013972558*^9, 3.777914085242982*^9, 
   3.7910938018313785`*^9, 3.7910939509432125`*^9, 3.820204748083334*^9, 
   3.820207207182016*^9, 3.820207297871024*^9, 3.82020736661802*^9, 
   3.842762464494198*^9, 3.844390005462557*^9, 3.844390076722529*^9, 
   3.844390674540822*^9, 3.844391079474918*^9, 3.8758915755485125`*^9, 
   3.875891994755202*^9, 3.9213068327976437`*^9, 3.9213069071641045`*^9, 
   3.921306949968523*^9, 3.9584003371860676`*^9},
 CellLabel->
  "Out[473]=",ExpressionUUID->"8ab0832e-a89d-ec4e-84ee-8133e23467c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellLabel->
  "In[474]:=",ExpressionUUID->"f7582ecb-44d3-4a21-8363-98c190925f47"],

Cell[BoxData["\<\"\\\\frac{1}{3 \\\\sqrt{2} \\\\lambda}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796372718*^9, 3.5823538548636518`*^9, 3.582353967716457*^9, 
   3.583130720953823*^9, 3.583133041053299*^9, 3.583133120972239*^9, 
   3.583133195915771*^9, 3.583133302619958*^9, 3.583133334615614*^9, 
   3.5831351995998893`*^9, 3.58313532499291*^9, 3.58313808607496*^9, 
   3.5831382089573765`*^9, 3.583146622668206*^9, 3.583150172907442*^9, 
   3.583150223872732*^9, 3.583150272186017*^9, {3.58796518375746*^9, 
   3.587965204209096*^9}, 3.588079873107629*^9, 3.588079956442975*^9, 
   3.588083329501707*^9, 3.58808368962834*^9, 3.588316615298677*^9, 
   3.588318843780191*^9, 3.5883190200449*^9, 3.588319169680363*^9, 
   3.5883258271548405`*^9, 3.5883259584446716`*^9, 3.588326916817755*^9, 
   3.588327860199211*^9, 3.588327929369733*^9, 3.5883280193350906`*^9, 
   3.588328473685889*^9, 3.588328557832438*^9, 3.588329397239711*^9, {
   3.5883296807078085`*^9, 3.588329704217051*^9}, 3.5883299124764156`*^9, 
   3.6151308260768595`*^9, 3.615131008167284*^9, 3.619089166130088*^9, 
   3.619626215519158*^9, 3.6205425717785788`*^9, 3.6463817102409697`*^9, 
   3.679983969108226*^9, 3.679984668746684*^9, 3.6977391841571803`*^9, 
   3.6977392392592587`*^9, 3.715232894439502*^9, 3.715233065322654*^9, 
   3.715233746013919*^9, 3.727334898744102*^9, 3.727335238615753*^9, 
   3.7273353310905533`*^9, 3.72733614345308*^9, 3.727336234984357*^9, 
   3.727336465771603*^9, 3.727336736013023*^9, 3.727337058151276*^9, 
   3.7273405151059313`*^9, 3.727340623428213*^9, 3.72734073996443*^9, 
   3.727341332743691*^9, 3.727342072877231*^9, 3.727343586795211*^9, 
   3.727343669886195*^9, 3.727343749757326*^9, 3.72734385799054*^9, 
   3.727410645920947*^9, 3.7282786904913406`*^9, 3.728280994374499*^9, 
   3.728483765310485*^9, 3.728551304408989*^9, 3.728551798684842*^9, 
   3.728804569411311*^9, 3.72880469230634*^9, 3.728808518966762*^9, 
   3.728808861162248*^9, 3.777914014019433*^9, 3.7779140852742214`*^9, 
   3.7910938019160438`*^9, 3.7910939510213532`*^9, 3.820204748123228*^9, 
   3.820207207190024*^9, 3.820207297878999*^9, 3.820207366629018*^9, 
   3.842762464522095*^9, 3.844390005491455*^9, 3.844390076756423*^9, 
   3.844390674574725*^9, 3.8443910795038376`*^9, 3.8758915755714226`*^9, 
   3.875891994769165*^9, 3.9213068328255672`*^9, 3.9213069071700897`*^9, 
   3.9213069499834576`*^9, 3.9584003371860676`*^9},
 CellLabel->
  "Out[474]=",ExpressionUUID->"050c7bd0-b739-a74a-8887-a0572ffec0a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "3"}], "/", 
  RowBox[{"Sqrt", "[", "2", "]"}]}]], "Input",
 CellChangeTimes->{{3.5446049498616514`*^9, 3.544604950404682*^9}},
 CellLabel->
  "In[475]:=",ExpressionUUID->"80b37900-1aea-4146-aab3-b4bba4fec08a"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"3", " ", 
   SqrtBox["2"]}]]], "Output",
 CellChangeTimes->{
  3.582347796388318*^9, 3.5823538548792515`*^9, 3.582353967732057*^9, 
   3.583130720953823*^9, 3.583133041068898*^9, 3.583133120972239*^9, 
   3.5831331959313717`*^9, 3.583133302635558*^9, 3.583133334631214*^9, 
   3.58313519961549*^9, 3.58313532500851*^9, 3.58313808609056*^9, 
   3.5831382089573765`*^9, 3.583146622683806*^9, 3.583150172923043*^9, 
   3.583150223966332*^9, 3.583150272201617*^9, {3.58796518375746*^9, 
   3.587965204224696*^9}, 3.588079873123229*^9, 3.5880799564585752`*^9, 
   3.588083329532908*^9, 3.5880836896439395`*^9, 3.588316615314276*^9, 
   3.588318843795791*^9, 3.5883190200605*^9, 3.5883191697427626`*^9, 
   3.5883258271548405`*^9, 3.588325958460271*^9, 3.588326916817755*^9, 
   3.588327860214812*^9, 3.588327929385333*^9, 3.5883280193350906`*^9, 
   3.5883284737014885`*^9, 3.588328557848037*^9, 3.588329397239711*^9, {
   3.5883296807078085`*^9, 3.588329704217051*^9}, 3.588329912492015*^9, 
   3.615130826086859*^9, 3.615131008167284*^9, 3.619089166140088*^9, 
   3.619626215519158*^9, 3.6205425717785788`*^9, 3.646381710250969*^9, 
   3.679983969118225*^9, 3.679984668756685*^9, 3.69773918416718*^9, 
   3.6977392392692585`*^9, 3.715232894501178*^9, 3.7152330654056277`*^9, 
   3.715233746063064*^9, 3.7273348987608643`*^9, 3.727335238640821*^9, 
   3.727335331121818*^9, 3.727336143484334*^9, 3.727336235006504*^9, 
   3.727336465809472*^9, 3.727336736028647*^9, 3.727337058189988*^9, 
   3.7273405151216807`*^9, 3.7273406234641314`*^9, 3.7273407400102797`*^9, 
   3.727341332759325*^9, 3.72734207289917*^9, 3.727343586810843*^9, 
   3.7273436699037004`*^9, 3.7273437497895846`*^9, 3.7273438580217934`*^9, 
   3.727410645936554*^9, 3.728278690522594*^9, 3.72828099439054*^9, 
   3.728483765326508*^9, 3.728551304424619*^9, 3.7285517987006044`*^9, 
   3.728804569422312*^9, 3.728804692318341*^9, 3.72880851898244*^9, 
   3.7288088611778746`*^9, 3.777914014035062*^9, 3.777914085305448*^9, 
   3.7910938019785604`*^9, 3.791093951090422*^9, 3.8202047481671114`*^9, 
   3.82020720722493*^9, 3.820207297911915*^9, 3.820207366658944*^9, 
   3.8427624645460563`*^9, 3.844390005523397*^9, 3.844390076783375*^9, 
   3.844390674600658*^9, 3.844391079533759*^9, 3.875891575591399*^9, 
   3.8758919947811327`*^9, 3.921306832850502*^9, 3.9213069071910324`*^9, 
   3.921306950000412*^9, 3.9584003372114334`*^9},
 CellLabel->
  "Out[475]=",ExpressionUUID->"0088ddfb-2019-7f44-ab36-7e5a8a2f25f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellLabel->
  "In[476]:=",ExpressionUUID->"2a9b5f60-529c-4d1c-8cee-ef0d72e0bc1a"],

Cell[BoxData["\<\"\\\\tfrac{1}{3 \\\\sqrt{2}}\"\>"], "Output",
 CellChangeTimes->{
  3.5823477964039187`*^9, 3.5823538548948517`*^9, 3.582353967747658*^9, 
   3.5831307209694242`*^9, 3.5831330410844994`*^9, 3.583133120987839*^9, 
   3.5831331959313717`*^9, 3.583133302635558*^9, 3.583133334646815*^9, 
   3.58313519963109*^9, 3.58313532502411*^9, 3.58313808610616*^9, 
   3.583138208988576*^9, 3.583146622683806*^9, 3.583150172923043*^9, 
   3.583150223981932*^9, 3.5831502722172174`*^9, {3.58796518377306*^9, 
   3.587965204240296*^9}, 3.588079873123229*^9, 3.5880799564585752`*^9, 
   3.588083329564107*^9, 3.5880836896595397`*^9, 3.588316615314276*^9, 
   3.588318843811391*^9, 3.588319020076101*^9, 3.588319169773963*^9, 
   3.588325827170441*^9, 3.588325958475871*^9, 3.588326916833355*^9, 
   3.588327860214812*^9, 3.588327929385333*^9, 3.588328019350691*^9, 
   3.5883284737014885`*^9, 3.588328557863637*^9, 3.588329397255311*^9, {
   3.588329680723409*^9, 3.588329704232651*^9}, 3.588329912507615*^9, 
   3.615130826086859*^9, 3.615131008167284*^9, 3.619089166140088*^9, 
   3.619626215529158*^9, 3.6205425717885785`*^9, 3.646381710270969*^9, 
   3.679983969128224*^9, 3.679984668766685*^9, 3.6977391841871805`*^9, 
   3.6977392392792587`*^9, 3.715232894616435*^9, 3.7152330654892197`*^9, 
   3.7152337461127996`*^9, 3.7273348988126187`*^9, 3.7273352386564493`*^9, 
   3.727335331142967*^9, 3.7273361435216074`*^9, 3.727336235022133*^9, 
   3.7273364658563604`*^9, 3.727336736050767*^9, 3.727337058235785*^9, 
   3.727340515180308*^9, 3.727340623496866*^9, 3.727340740041558*^9, 
   3.727341332774941*^9, 3.727342072905208*^9, 3.727343586857686*^9, 
   3.727343669936015*^9, 3.727343749826389*^9, 3.7273438580595922`*^9, 
   3.727410645952207*^9, 3.72827869053822*^9, 3.7282809944061494`*^9, 
   3.728483765341688*^9, 3.728551304440265*^9, 3.728551798716241*^9, 
   3.7288045694333134`*^9, 3.728804692330342*^9, 3.728808518998067*^9, 
   3.7288088611935005`*^9, 3.777914014066367*^9, 3.777914085336695*^9, 
   3.791093802047692*^9, 3.791093951190768*^9, 3.8202047481780815`*^9, 
   3.8202072072588453`*^9, 3.820207297946847*^9, 3.8202073666928606`*^9, 
   3.842762464571987*^9, 3.844390005553316*^9, 3.844390076811297*^9, 
   3.8443906746295843`*^9, 3.84439107956365*^9, 3.875891575597381*^9, 
   3.8758919947881145`*^9, 3.921306832855488*^9, 3.921306907196989*^9, 
   3.921306950015396*^9, 3.958400337217539*^9},
 CellLabel->
  "Out[476]=",ExpressionUUID->"4e330787-ff74-bf44-9b90-32198a9627d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Lambda]", "[", "]"}], "-", "3"}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"1", "-", "\[Lambda]"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.544604963424427*^9, 3.544605003711731*^9}},
 CellLabel->
  "In[477]:=",ExpressionUUID->"7b3675ef-a93a-4d07-9618-d5f29c190b8d"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "3"}], "+", 
   InterpretationBox[
    StyleBox["\[Lambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Lambda][],
    Editable->False]}], 
  RowBox[{"1", "-", "\[Lambda]"}]]], "Output",
 CellChangeTimes->{
  3.582347796435118*^9, 3.582353854910452*^9, 3.582353967763257*^9, 
   3.5831307209850245`*^9, 3.5831330411000996`*^9, 3.583133121003439*^9, 
   3.5831331959469714`*^9, 3.5831333026511593`*^9, 3.583133334662415*^9, 
   3.58313519963109*^9, 3.58313532503971*^9, 3.58313808612176*^9, 
   3.583138209019776*^9, 3.583146622699406*^9, 3.583150173032243*^9, 
   3.583150223997532*^9, 3.583150272232818*^9, {3.58796518378866*^9, 
   3.587965204255896*^9}, 3.588079873138829*^9, 3.5880799564741755`*^9, 
   3.588083329595308*^9, 3.5880836896751394`*^9, 3.588316615329876*^9, 
   3.58831884382699*^9, 3.5883190200917*^9, 3.588319169789563*^9, 
   3.588325827186041*^9, 3.588325958475871*^9, 3.588326916848954*^9, 
   3.5883278602304125`*^9, 3.588327929400933*^9, 3.588328019366291*^9, 
   3.5883284737170887`*^9, 3.588328557863637*^9, 3.588329397270911*^9, {
   3.588329680739009*^9, 3.58832970424825*^9}, 3.588329912507615*^9, 
   3.615130826096859*^9, 3.615131008182884*^9, 3.6190891661500883`*^9, 
   3.619626215539158*^9, 3.6205425717885785`*^9, 3.646381710290969*^9, 
   3.679983969138223*^9, 3.679984668776685*^9, 3.6977391841971807`*^9, 
   3.697739239299258*^9, 3.715232894921464*^9, 3.7152330655383677`*^9, 
   3.715233746162463*^9, 3.72733489882827*^9, 3.7273352386896987`*^9, 
   3.7273353311586246`*^9, 3.727336143558474*^9, 3.727336235037766*^9, 
   3.727336465894106*^9, 3.7273367360820484`*^9, 3.727337058251416*^9, 
   3.7273405152064986`*^9, 3.727340623543715*^9, 3.727340740072817*^9, 
   3.727341332790568*^9, 3.727342072936491*^9, 3.727343586895543*^9, 
   3.727343669955184*^9, 3.7273437498576155`*^9, 3.7273438580908756`*^9, 
   3.72741064598346*^9, 3.7282786905559654`*^9, 3.7282809944218087`*^9, 
   3.728483765357316*^9, 3.728551304455873*^9, 3.7285517987318554`*^9, 
   3.728804569444313*^9, 3.728804692343343*^9, 3.728808518998067*^9, 
   3.7288088612121706`*^9, 3.777914014113182*^9, 3.777914085367948*^9, 
   3.7910938021323195`*^9, 3.7910939512750854`*^9, 3.820204748216007*^9, 
   3.820207207267814*^9, 3.82020729795577*^9, 3.8202073667307515`*^9, 
   3.8427624645959263`*^9, 3.844390005583209*^9, 3.844390076840199*^9, 
   3.844390674657512*^9, 3.8443910795936*^9, 3.8758915756173286`*^9, 
   3.875891994801085*^9, 3.921306832882416*^9, 3.9213069072020035`*^9, 
   3.921306950031328*^9, 3.958400337217539*^9},
 CellLabel->
  "Out[477]=",ExpressionUUID->"19f64fc4-8cd0-ce4a-ab65-b32b5ad4b741"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.544604994392198*^9, 3.544604996902342*^9}},
 CellLabel->
  "In[478]:=",ExpressionUUID->"96637fc0-5078-4619-b647-c973b2b5b817"],

Cell[BoxData["\<\"- \\\\frac{3 -  \\\\lambda}{1 -  \\\\lambda}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796450718*^9, 3.582353854926052*^9, 3.582353967778857*^9, 
   3.5831307210006247`*^9, 3.5831330411156993`*^9, 3.583133121019039*^9, 
   3.58313319596257*^9, 3.583133302682358*^9, 3.5831333346780148`*^9, 
   3.58313519964669*^9, 3.5831353250553107`*^9, 3.583138086496161*^9, 
   3.583138209035376*^9, 3.583146622715006*^9, 3.5831501730478425`*^9, 
   3.583150224013132*^9, 3.583150272248417*^9, {3.58796518380426*^9, 
   3.5879652042714972`*^9}, 3.5880798731544294`*^9, 3.5880799564897757`*^9, 
   3.5880833296265078`*^9, 3.588083689690739*^9, 3.588316615345476*^9, 
   3.588318843842591*^9, 3.5883190201073*^9, 3.588319169820763*^9, 
   3.58832582720164*^9, 3.5883259584914722`*^9, 3.588326916848954*^9, 
   3.5883278602460127`*^9, 3.588327929416533*^9, 3.588328019366291*^9, 
   3.588328473732689*^9, 3.5883285578792377`*^9, 3.588329397286512*^9, {
   3.588329680754609*^9, 3.58832970424825*^9}, 3.588329912523216*^9, 
   3.615130826106859*^9, 3.615131008182884*^9, 3.6190891661500883`*^9, 
   3.619626215539158*^9, 3.6205425717985787`*^9, 3.646381710300969*^9, 
   3.679983969148222*^9, 3.679984668786685*^9, 3.6977391842071805`*^9, 
   3.6977392393092585`*^9, 3.7152328949669447`*^9, 3.715233065593569*^9, 
   3.715233746212915*^9, 3.7273348988439035`*^9, 3.727335238705325*^9, 
   3.727335331174221*^9, 3.727336143589748*^9, 3.727336235069014*^9, 
   3.7273364659097695`*^9, 3.727336736113273*^9, 3.7273370582752604`*^9, 
   3.727340515233965*^9, 3.727340623581493*^9, 3.727340740094932*^9, 
   3.7273413328061943`*^9, 3.727342072952091*^9, 3.7273435869267917`*^9, 
   3.727343669999233*^9, 3.727343749911042*^9, 3.727343858137728*^9, 
   3.727410645989479*^9, 3.7282786914765453`*^9, 3.728280994437427*^9, 
   3.728483765357316*^9, 3.728551304482561*^9, 3.72855179874748*^9, 
   3.7288045694553146`*^9, 3.728804692356344*^9, 3.728808519013665*^9, 
   3.728808861219174*^9, 3.777914014160063*^9, 3.777914085399196*^9, 
   3.791093802216952*^9, 3.791093951344094*^9, 3.820204748225989*^9, 
   3.8202072072738013`*^9, 3.820207297990677*^9, 3.820207366740692*^9, 
   3.8427624646208572`*^9, 3.8443900056151595`*^9, 3.844390076849213*^9, 
   3.844390674690422*^9, 3.8443910796204996`*^9, 3.875891575623312*^9, 
   3.875891994814048*^9, 3.921306832888399*^9, 3.9213069072239437`*^9, 
   3.9213069500462875`*^9, 3.958400337233471*^9},
 CellLabel->
  "Out[478]=",ExpressionUUID->"3340beef-4c9e-1047-b0a5-85170508f7a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$TexFractionAsFraction", "=", "False"}], "}"}], ",", 
   RowBox[{"TexPrint", "[", "%%", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[479]:=",ExpressionUUID->"93f0e119-a363-4b7f-abc2-cef7b7da4258"],

Cell[BoxData["\<\"(1 -  \\\\lambda)^{-1} (-3 + \\\\lambda)\"\>"], "Output",
 CellChangeTimes->{
  3.582347796466318*^9, 3.582353854941653*^9, 3.582353967794458*^9, 
   3.5831307210006247`*^9, 3.583133041131298*^9, 3.583133121034639*^9, 
   3.583133195978171*^9, 3.583133302682358*^9, 3.583133334693614*^9, 
   3.58313519966229*^9, 3.58313532508651*^9, 3.583138086683361*^9, 
   3.583138209050976*^9, 3.583146622730606*^9, 3.583150173063443*^9, 
   3.583150224028733*^9, 3.583150272264017*^9, {3.58796518381986*^9, 
   3.587965204287096*^9}, 3.588079873170029*^9, 3.588079956505376*^9, 
   3.588083329657707*^9, 3.58808368970634*^9, 3.588316615361077*^9, 
   3.5883188438581905`*^9, 3.5883190201385*^9, 3.588319169836364*^9, 
   3.58832582720164*^9, 3.588325958507071*^9, 3.588326916864555*^9, 
   3.5883278602616124`*^9, 3.588327929416533*^9, 3.588328019381891*^9, 
   3.588328473732689*^9, 3.588328557894837*^9, 3.588329397286512*^9, {
   3.588329680754609*^9, 3.58832970426385*^9}, 3.588329912538815*^9, 
   3.615130826106859*^9, 3.615131008182884*^9, 3.619089166160088*^9, 
   3.619626215549158*^9, 3.6205425718085785`*^9, 3.646381710320969*^9, 
   3.6799839691582203`*^9, 3.679984668796685*^9, 3.6977391842171807`*^9, 
   3.697739239319259*^9, 3.715232895023275*^9, 3.715233065639599*^9, 
   3.7152337462801733`*^9, 3.727334898866048*^9, 3.727335238741093*^9, 
   3.727335331205482*^9, 3.727336143621507*^9, 3.72733623508464*^9, 
   3.7273364659410152`*^9, 3.727336736150921*^9, 3.727337058306716*^9, 
   3.727340515265247*^9, 3.727340623628373*^9, 3.727340740126189*^9, 
   3.72734133282784*^9, 3.727342072983343*^9, 3.7273435869771833`*^9, 
   3.727343670039535*^9, 3.727343749942295*^9, 3.7273438581594057`*^9, 
   3.72741064600528*^9, 3.728278692340071*^9, 3.728280994437427*^9, 
   3.728483765372943*^9, 3.728551304498226*^9, 3.728551798763107*^9, 
   3.7288045694663153`*^9, 3.728804692369344*^9, 3.728808519029293*^9, 
   3.728808861219174*^9, 3.777914014175682*^9, 3.777914085430445*^9, 
   3.791093802312061*^9, 3.791093951406608*^9, 3.820204748263878*^9, 
   3.820207207310672*^9, 3.8202072980255837`*^9, 3.8202073667756257`*^9, 
   3.842762464645764*^9, 3.844390005650061*^9, 3.8443900768810887`*^9, 
   3.844390674717349*^9, 3.844391079668397*^9, 3.875891575630265*^9, 
   3.87589199482798*^9, 3.9213068329163265`*^9, 3.9213069072309284`*^9, 
   3.921306950062275*^9, 3.958400337248192*^9},
 CellLabel->
  "Out[479]=",ExpressionUUID->"1ba0b646-2bb2-434e-9da8-99328cbae99c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "*", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"\[Lambda]", "[", "]"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.54460502974422*^9, 3.544605035485548*^9}},
 CellLabel->
  "In[480]:=",ExpressionUUID->"e4779d76-3fea-4352-aa11-c9657fed34a5"],

Cell[BoxData[
 FractionBox[
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Tau]", 
       StyleBox[GridBox[{
          {" ", " ", " "},
          {"a", "b", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`c],
   Editable->False], 
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     InterpretationBox[
      StyleBox["\[Lambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Lambda][],
      Editable->False]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.582347796481919*^9, 3.582353854957252*^9, 3.582353967810057*^9, 
   3.5831307210162244`*^9, 3.583133041146899*^9, 3.583133121034639*^9, 
   3.583133195978171*^9, 3.583133302697958*^9, 3.583133334693614*^9, 
   3.58313519966229*^9, 3.58313532510211*^9, 3.583138086698961*^9, 
   3.583138209050976*^9, 3.5831466227462068`*^9, 3.5831501730790424`*^9, 
   3.583150224044332*^9, 3.583150272264017*^9, {3.5879651838354607`*^9, 
   3.587965204302696*^9}, 3.588079873185629*^9, 3.5880799565209756`*^9, 
   3.5880833296889076`*^9, 3.58808368992474*^9, 3.588316615376677*^9, 
   3.5883188438737907`*^9, 3.5883190201697*^9, 3.5883191698675632`*^9, 
   3.588325827217241*^9, 3.5883259585226717`*^9, 3.5883269168801546`*^9, 
   3.5883278602616124`*^9, 3.5883279294321337`*^9, 3.588328019397491*^9, 
   3.588328473748289*^9, 3.588328557894837*^9, 3.588329397302111*^9, {
   3.5883296807702093`*^9, 3.588329704279451*^9}, 3.588329912554415*^9, 
   3.6151308261168594`*^9, 3.615131008182884*^9, 3.619089166160088*^9, 
   3.6196262155591583`*^9, 3.6205425718085785`*^9, 3.646381710340969*^9, 
   3.67998396917822*^9, 3.679984668816685*^9, 3.6977391842271805`*^9, 
   3.6977392393292584`*^9, 3.715232895084682*^9, 3.715233065689577*^9, 
   3.7152337463954782`*^9, 3.727334898897336*^9, 3.727335238772347*^9, 
   3.727335331221132*^9, 3.727336143684085*^9, 3.727336235121993*^9, 
   3.7273364659934196`*^9, 3.727336736197801*^9, 3.727337058398388*^9, 
   3.727340515298997*^9, 3.727340623665907*^9, 3.727340740157468*^9, 
   3.7273413328437886`*^9, 3.727342073026035*^9, 3.727343586995344*^9, 
   3.7273436700544777`*^9, 3.727343749973549*^9, 3.727343858175071*^9, 
   3.727410646036532*^9, 3.7282786933775234`*^9, 3.7282809944530306`*^9, 
   3.728483765388569*^9, 3.7285513045294695`*^9, 3.7285517987832375`*^9, 
   3.728804569478315*^9, 3.7288046923823447`*^9, 3.728808519029293*^9, 
   3.728808861234804*^9, 3.777914014222559*^9, 3.7779140854616957`*^9, 
   3.791093802395201*^9, 3.7910939514912786`*^9, 3.820204748303746*^9, 
   3.82020720731968*^9, 3.820207298035557*^9, 3.820207366814497*^9, 
   3.842762464670726*^9, 3.844390005661001*^9, 3.8443900769090466`*^9, 
   3.844390674764198*^9, 3.8443910797022796`*^9, 3.8758915756512113`*^9, 
   3.875891994833992*^9, 3.9213068329233074`*^9, 3.921306907236883*^9, 
   3.921306950081196*^9, 3.9584003372492256`*^9},
 CellLabel->
  "Out[480]=",ExpressionUUID->"0ae42497-6cc1-9540-90c3-467cb4742efc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5446050369326315`*^9, 3.544605041393886*^9}},
 CellLabel->
  "In[481]:=",ExpressionUUID->"db18d7c8-0751-48a8-85e1-83a670e53379"],

Cell[BoxData["\<\"\\\\frac{\\\\tau_{abc}}{\\\\sqrt{2} (1 + \
\\\\lambda)}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796497519*^9, 3.5823538549728518`*^9, 3.582353967841257*^9, 
   3.583130721031823*^9, 3.5831330411625*^9, 3.5831331210502386`*^9, 
   3.5831331959937706`*^9, 3.583133302729158*^9, 3.583133334724815*^9, 
   3.58313519969349*^9, 3.58313532511771*^9, 3.5831380870889616`*^9, 
   3.583138209082176*^9, 3.583146622761806*^9, 3.5831501730946426`*^9, 
   3.583150224059932*^9, 3.583150272310817*^9, {3.5879651838510604`*^9, 
   3.5879652043182964`*^9}, 3.588079873201229*^9, 3.588079956536576*^9, 
   3.5880833297357073`*^9, 3.5880836902679405`*^9, 3.588316615392277*^9, 
   3.588318843904991*^9, 3.5883190202321005`*^9, 3.588319169898763*^9, 
   3.5883258272328405`*^9, 3.588325958538271*^9, 3.588326916895755*^9, 
   3.588327860277211*^9, 3.588327929447733*^9, 3.5883280194130907`*^9, 
   3.588328473763889*^9, 3.588328557926037*^9, 3.588329397317711*^9, {
   3.5883296808014092`*^9, 3.588329704295051*^9}, 3.588329912570015*^9, 
   3.61513082612686*^9, 3.615131008198484*^9, 3.619089166170088*^9, 
   3.619626215569158*^9, 3.620542571818579*^9, 3.646381710350969*^9, 
   3.6799839691982183`*^9, 3.679984668826685*^9, 3.697739184237181*^9, 
   3.6977392393492584`*^9, 3.715232895134481*^9, 3.71523306573987*^9, 
   3.71523374665761*^9, 3.727334898912965*^9, 3.7273352388192286`*^9, 
   3.727335331274525*^9, 3.727336143737002*^9, 3.727336235168846*^9, 
   3.727336466025126*^9, 3.727336736229082*^9, 3.7273370584356947`*^9, 
   3.727340515322132*^9, 3.7273406236972084`*^9, 3.7273407402262197`*^9, 
   3.727341332875042*^9, 3.727342073057338*^9, 3.7273435870109787`*^9, 
   3.727343670085981*^9, 3.727343749994767*^9, 3.7273438582062883`*^9, 
   3.727410646050182*^9, 3.728278701184308*^9, 3.728280994474681*^9, 
   3.728483765410719*^9, 3.72855130458209*^9, 3.72855179878528*^9, 
   3.728804569489316*^9, 3.7288046924013457`*^9, 3.728808519056485*^9, 
   3.728808861250433*^9, 3.77791401426943*^9, 3.777914085492957*^9, 
   3.791093802464228*^9, 3.7910939515755515`*^9, 3.820204748339677*^9, 
   3.8202072073535814`*^9, 3.820207298068497*^9, 3.820207366856383*^9, 
   3.8427624646946826`*^9, 3.844390005691947*^9, 3.844390076938959*^9, 
   3.8443906747981057`*^9, 3.844391079735192*^9, 3.875891575658214*^9, 
   3.875891994846957*^9, 3.921306832964199*^9, 3.921306907259821*^9, 
   3.9213069500961857`*^9, 3.958400337264942*^9},
 CellLabel->
  "Out[481]=",ExpressionUUID->"d1026a51-e875-b247-a12a-518c97928e92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$TexFractionAsFraction", "=", "False"}], "}"}], ",", 
   RowBox[{"TexPrint", "[", "%%", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[482]:=",ExpressionUUID->"ffd81ff1-6fb8-4dff-a6aa-d9db4cc34235"],

Cell[BoxData["\<\"\\\\tfrac{1}{\\\\sqrt{2}}\\\\tau_{abc} (1 + \
\\\\lambda)^{-1}\"\>"], "Output",
 CellChangeTimes->{
  3.5823477965131187`*^9, 3.582353855004052*^9, 3.582353967856858*^9, 
   3.5831330411780996`*^9, 3.583133121065839*^9, 3.583133196009371*^9, 
   3.5831333027447586`*^9, 3.583133334740415*^9, 3.58313519970909*^9, 
   3.583135325133311*^9, 3.583138087276162*^9, 3.583138209097776*^9, 
   3.583146622777406*^9, 3.583150173110243*^9, 3.583150224075532*^9, 
   3.583150272326417*^9, {3.58796518386666*^9, 3.5879652043338966`*^9}, 
   3.5880798732324295`*^9, 3.5880799565521755`*^9, 3.588083329766908*^9, 
   3.588083690299141*^9, 3.588316615407877*^9, 3.588318843920591*^9, 
   3.588319020247701*^9, 3.588319169914363*^9, 3.58832582727964*^9, 
   3.588325958553871*^9, 3.588326916911354*^9, 3.5883278602928123`*^9, 
   3.588327929463333*^9, 3.588328019428691*^9, 3.588328473779489*^9, 
   3.588328557941637*^9, 3.588329397333311*^9, {3.588329680817009*^9, 
   3.588329704310651*^9}, 3.588329912585615*^9, 3.6151308261368594`*^9, 
   3.6151310082140846`*^9, 3.619089166220088*^9, 3.619626215579158*^9, 
   3.6205425718285785`*^9, 3.646381710370969*^9, 3.679983969218217*^9, 
   3.679984668836685*^9, 3.697739184247181*^9, 3.697739239359259*^9, 
   3.715232895185156*^9, 3.7152330657935457`*^9, 3.7152337468125477`*^9, 
   3.7273348989442086`*^9, 3.7273352388393736`*^9, 3.7273353312901773`*^9, 
   3.727336143768258*^9, 3.7273362352031116`*^9, 3.72733646604078*^9, 
   3.7273367362512007`*^9, 3.727337058467409*^9, 3.727340515353399*^9, 
   3.7273406237284603`*^9, 3.727340740257448*^9, 3.727341332906295*^9, 
   3.7273420730729933`*^9, 3.727343587042235*^9, 3.727343670101618*^9, 
   3.727343750026142*^9, 3.727343858237541*^9, 3.727410646072006*^9, 
   3.7282787012328377`*^9, 3.72828099449043*^9, 3.7284837654264555`*^9, 
   3.728551304600911*^9, 3.7285517988009443`*^9, 3.7288045695003166`*^9, 
   3.7288046924143476`*^9, 3.7288085190621643`*^9, 3.728808861266059*^9, 
   3.77791401430068*^9, 3.777914085524234*^9, 3.79109380254888*^9, 
   3.791093951660148*^9, 3.820204748347658*^9, 3.8202072073635306`*^9, 
   3.820207298104373*^9, 3.820207366897274*^9, 3.842762464719594*^9, 
   3.8443900057218657`*^9, 3.844390076967857*^9, 3.844390674826059*^9, 
   3.844391079769101*^9, 3.8758915756781387`*^9, 3.875891994862914*^9, 
   3.9213068329701805`*^9, 3.9213069072668266`*^9, 3.9213069501031666`*^9, 
   3.958400337280966*^9},
 CellLabel->
  "Out[482]=",ExpressionUUID->"157c5538-bc76-d645-833a-8fe051e9f267"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Lambda]", "[", "]"}], "-", "3"}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Lambda]"}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"1", "/", "3"}], "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "-", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"\[Lambda]", "[", "]"}]}], "/", "3"}], "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "+", 
  RowBox[{"2", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Lambda]", "[", "]"}], "-", "3"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.58313075313668*^9, 3.583130763994299*^9}, {
   3.588318871485839*^9, 3.5883188733734426`*^9}, 3.588319050324554*^9, {
   3.715233414975192*^9, 3.715233434709676*^9}, {3.715233467496589*^9, 
   3.715233471158084*^9}},
 CellLabel->
  "In[483]:=",ExpressionUUID->"58add8ee-189d-4b5b-aea3-615d6ad42101"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"3", " ", 
    SqrtBox["2"]}]], "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     InterpretationBox[
      StyleBox["\[Lambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Lambda][],
      Editable->False]}], ")"}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    InterpretationBox[
     StyleBox["\[Lambda]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Lambda][],
     Editable->False]}], 
   RowBox[{"1", "-", "\[Lambda]"}]], "-", 
  FractionBox["1", 
   RowBox[{"3", " ", 
    SqrtBox["2"], " ", 
    InterpretationBox[
     StyleBox["\[Lambda]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Lambda][],
     Editable->False]}]]}]], "Output",
 CellChangeTimes->{
  3.5831307644311*^9, {3.583130800888364*^9, 3.583130805521572*^9}, 
   3.583130978713076*^9, 3.583131014452739*^9, 3.583133041193699*^9, 
   3.583133121081439*^9, 3.583133196024971*^9, 3.583133302760358*^9, 
   3.583133334756015*^9, 3.58313519970909*^9, 3.583135325148911*^9, 
   3.5831380872917633`*^9, 3.583138209097776*^9, 3.583146622777406*^9, 
   3.583150173125843*^9, 3.583150224091132*^9, 3.583150272342017*^9, {
   3.5879651838822603`*^9, 3.587965204349497*^9}, 3.588079873279229*^9, 
   3.588079956567776*^9, 3.588083329798107*^9, 3.5880836903459406`*^9, 
   3.588316615423476*^9, {3.588316820002236*^9, 3.58831683945547*^9}, 
   3.5883188439361906`*^9, 3.588318873997444*^9, 3.5883190202633004`*^9, 
   3.588319050698954*^9, 3.588319169945564*^9, 3.5883258272952404`*^9, 
   3.588325958553871*^9, 3.588326916926955*^9, 3.588327860308412*^9, 
   3.588327929478934*^9, 3.588328019444291*^9, 3.588328473795089*^9, 
   3.588328557941637*^9, 3.588329397348912*^9, {3.588329680817009*^9, 
   3.58832970432625*^9}, 3.588329912601216*^9, 3.6151308261368594`*^9, 
   3.6151310082140846`*^9, 3.619089166220088*^9, 3.619626215579158*^9, 
   3.6205425718285785`*^9, 3.6463817103909698`*^9, 3.679983969228216*^9, 
   3.6799846688566856`*^9, 3.697739184257181*^9, 3.6977392393692584`*^9, 
   3.71523289526647*^9, {3.715233065840113*^9, 3.715233075468667*^9}, 
   3.715233286390826*^9, {3.715233403817861*^9, 3.7152334354202423`*^9}, 
   3.715233471569055*^9, 3.71523351519829*^9, 3.715233746994154*^9, 
   3.727334898966259*^9, 3.7273352388570085`*^9, 3.72733533132144*^9, 
   3.727336143783881*^9, 3.727336235237941*^9, 3.7273364660720363`*^9, 
   3.7273367362824845`*^9, 3.7273370584830065`*^9, 3.7273405154012346`*^9, 
   3.7273406237659316`*^9, 3.727340740294803*^9, 3.727341332944076*^9, 
   3.7273420731157637`*^9, 3.727343587057824*^9, 3.727343670135419*^9, 
   3.727343750041768*^9, 3.727343858290962*^9, 3.727410646089665*^9, 
   3.728278702785118*^9, 3.728280994506056*^9, 3.728483765437579*^9, 
   3.728551304616538*^9, 3.728551798816573*^9, 3.728804569512318*^9, 
   3.728804692426348*^9, 3.7288085190621643`*^9, 3.728808861281685*^9, 
   3.777914014347592*^9, 3.7779140855398226`*^9, 3.7910938026177654`*^9, 
   3.791093951757013*^9, 3.820204748381563*^9, 3.820207207400395*^9, 
   3.8202072981133485`*^9, 3.820207366932181*^9, 3.8427624647445*^9, 
   3.8443900057527556`*^9, 3.84439007699678*^9, 3.844390674835007*^9, 
   3.844391079801016*^9, 3.87589157569911*^9, 3.8758919948758793`*^9, 
   3.9213068329971085`*^9, 3.9213069072927704`*^9, 3.921306950109148*^9, 
   3.9584003373061943`*^9},
 CellLabel->
  "Out[483]=",ExpressionUUID->"2329180a-0d8b-8549-90b6-72b8f513b357"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.583133108117816*^9, 3.58313311023942*^9}},
 CellLabel->
  "In[484]:=",ExpressionUUID->"a585b4da-2bc0-48bc-bffa-9de197589f85"],

Cell[BoxData["\<\"\\\\tfrac{1}{3 \\\\sqrt{2}} + 2 (-3 + \\\\lambda) -  \
\\\\frac{3 -  \\\\lambda}{1 -  \\\\lambda} -  \\\\frac{1}{3 \\\\sqrt{2} \
\\\\lambda}\"\>"], "Output",
 CellChangeTimes->{
  3.583133121097039*^9, 3.5831331960405717`*^9, 3.583133302775958*^9, 
   3.583133334771614*^9, 3.58313519972469*^9, 3.583135325164511*^9, 
   3.5831380876817636`*^9, 3.583138209113376*^9, 3.583146622793006*^9, 
   3.583150173141443*^9, 3.583150224106733*^9, 3.583150272357617*^9, {
   3.58796518389786*^9, 3.587965204380697*^9}, 3.588079873294829*^9, 
   3.588079956583376*^9, 3.5880833298449078`*^9, 3.5880836904707413`*^9, 
   3.588316615439077*^9, {3.588316820563837*^9, 3.588316839985871*^9}, 
   3.588318843951791*^9, 3.588318875385846*^9, 3.5883190202945004`*^9, 
   3.588319051244955*^9, 3.5883191699611635`*^9, 3.5883258273108406`*^9, 
   3.588325958569472*^9, 3.588326916942555*^9, 3.588327860324012*^9, 
   3.588327929494533*^9, 3.588328019444291*^9, 3.588328473810689*^9, 
   3.588328557957237*^9, 3.588329397364512*^9, {3.588329680832609*^9, 
   3.588329704373051*^9}, 3.588329912616815*^9, 3.615130826146859*^9, 
   3.6151310082140846`*^9, 3.619089166230088*^9, 3.619626215589158*^9, 
   3.620542571838578*^9, 3.646381710400969*^9, 3.679983969238215*^9, 
   3.679984668866686*^9, 3.6977391842671804`*^9, 3.6977392393892584`*^9, 
   3.7152328953178*^9, {3.715233065889476*^9, 3.715233076219883*^9}, 
   3.715233287153335*^9, {3.715233404384762*^9, 3.715233436660891*^9}, 
   3.7152334727122793`*^9, 3.715233516182179*^9, 3.7152337470368237`*^9, 
   3.727334898997541*^9, 3.727335238872633*^9, 3.7273353313620234`*^9, 
   3.7273361438216834`*^9, 3.727336235253568*^9, 3.727336466094194*^9, 
   3.72733673629811*^9, 3.7273370585142903`*^9, 3.7273405154219437`*^9, 
   3.727340623800393*^9, 3.727340740326083*^9, 3.7273413329597006`*^9, 
   3.7273420731313896`*^9, 3.727343587094936*^9, 3.7273436701550446`*^9, 
   3.727343750073022*^9, 3.72734385832176*^9, 3.727410646105448*^9, 
   3.72827870605142*^9, 3.728280994521702*^9, 3.728483765484481*^9, 
   3.7285513046321716`*^9, 3.728551798832162*^9, 3.7288045695233183`*^9, 
   3.728804692439348*^9, 3.728808519077793*^9, 3.7288088612973137`*^9, 
   3.777914014394433*^9, 3.7779140855710793`*^9, 3.79109380268028*^9, 
   3.791093951827957*^9, 3.8202047484174414`*^9, 3.820207207408346*^9, 
   3.820207298148286*^9, 3.8202073669401894`*^9, 3.84276246476846*^9, 
   3.844390005782676*^9, 3.844390077006784*^9, 3.844390674864955*^9, 
   3.844391079834925*^9, 3.8758915757070885`*^9, 3.875891994891838*^9, 
   3.9213068330240383`*^9, 3.9213069073176937`*^9, 3.921306950124111*^9, 
   3.958400337312742*^9},
 CellLabel->
  "Out[484]=",ExpressionUUID->"c9cad1a3-d86b-4c4f-a748-23ace3313f48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexBreak", "[", 
  RowBox[{"%", ",", "1", ",", 
   RowBox[{"TexBreakBy", "\[Rule]", "\"\<Term\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5831307663187037`*^9, 3.583130799281561*^9}, {
   3.588316834775462*^9, 3.588316836647465*^9}, 3.588318814436539*^9},
 CellLabel->
  "In[485]:=",ExpressionUUID->"6f45fcdc-d1ff-404b-a2b4-e73184990b2c"],

Cell[BoxData["\<\"\\\\tfrac{1}{3 \\\\sqrt{2}} \\\\nonumber \\\\\\\\ \\n&& + 2 \
(-3 + \\\\lambda) \\\\nonumber \\\\\\\\ \\n&& -  \\\\frac{3 -  \\\\lambda}{1 \
-  \\\\lambda} \\\\nonumber \\\\\\\\ \\n&& -  \\\\frac{1}{3 \\\\sqrt{2} \
\\\\lambda}\"\>"], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAeLz36cftFv32rHDct55EG104tVlEB380uEGiN7wbOdd
EK0nm/wLRNtLJ+8LPvraccmbOy9AdPHU3C8gep3378gQIG0zNyMVRK9ldm0C
0WZ7uJeA6HNagWdA9OzTeTVhQPr5nF+dIHpPefcMEP3YdP4jEJ2yRdU+HEgf
4kz5A6Kdvh1liwDSG7oPC4DoSY3eciBa5MHhXRVA2qPXdZrC8deO9wwDtygC
af07G7a1AOl9VqIblwJpXsXb70C0yjvDaMUTrx0tJvVlgehF6556KANpFYlV
xSDaYP65yWdU3ziauW2eA6KDfoWzfrB74/hD/a84iOaa2xtZVvbGkU3+XU85
kF70xHUGiGZ1v7cARK/LlrxTs/CNo7fkrr7pS9448tgunA6iZ86KeQSiy+f8
FpkBpI9Zf9db++CN44FNMckg+sNXhVk+5m8dM4KzFoNog+ojK0C0SqvWKp66
t44A0xDhCQ==
  "],
 CellLabel->
  "Out[485]=",ExpressionUUID->"6a866cfd-b441-0947-9b10-c37b2a823bb7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexBreak", "[", 
  RowBox[{"%%", ",", "1", ",", 
   RowBox[{"TexBreakBy", "\[Rule]", "\"\<Term\>\""}], ",", 
   RowBox[{"TexBreakInParenthesis", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.715233586584267*^9, 3.71523358956816*^9}},
 CellLabel->
  "In[486]:=",ExpressionUUID->"45da9f5b-a2f2-4ae4-8105-6fda9c8ee828"],

Cell[BoxData["\<\"\\\\tfrac{1}{3 \\\\sqrt{2}} \\\\nonumber \\\\\\\\ \\n&& + 2 \
(-3 \\\\nonumber \\\\\\\\ \\n&& + \\\\lambda) \\\\nonumber \\\\\\\\ \\n&& -  \
\\\\frac{3 -  \\\\lambda}{1 -  \\\\lambda} \\\\nonumber \\\\\\\\ \\n&& -  \
\\\\frac{1}{3 \\\\sqrt{2} \\\\lambda}\"\>"], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQB+I6y9RfduteOzrPTt4XfPS146qcuy9A9By9vC8geor3
n8gQIH1sc2YqiLbncWsC0aU2PEtAtKpz0BkQfV21oCYMSGds/N0JoqXSe2aA
aKtdCx6B6Fsv1ezDgfSfXal/QLTHt2NsEUB6V/cRARB9jNFXDkRrnT6yqwJI
B0WVTVM4/trxnmHgFkUgbRKzcVsLkE6+LLpxKZCOW3j7HYh28jCKVjzx2vGB
bn8WiK6QfuahDKRzZ6wqBtGF8hcnn1F942jitmUOiH6iH8X6we6NY9jd/+Jg
+nRfZFnZG8cbDu97yoG0uZrbDBCtZHN/AYg+oi91p2bhG0dR/d1905e8cdyn
uGg6iBZYEPsIRKd1/hGZAaRTvn/XW/vgjWOobmwyiDY4pDjLx/ytY0FL1mIQ
/eLvkRUgWqVVaxVP3VtHAJUNyFU=
  "],
 CellLabel->
  "Out[486]=",ExpressionUUID->"7ba52f09-ee3d-764c-9d1b-63797b07bdc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Scalar", "[", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], 
    RowBox[{"T", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], "^", 
  RowBox[{"(", "2", ")"}]}]], "Input",
 CellChangeTimes->{{3.5831351756382475`*^9, 3.583135185045064*^9}},
 CellLabel->
  "In[487]:=",ExpressionUUID->"48a65cea-c1be-45ea-9383-fba51f500ea0"],

Cell[BoxData[
 SuperscriptBox[
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {" ", " ", " "},
              {"a", "b", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"a", "b", "c"},
              {" ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[$CellContext`a, $CellContext`b, $CellContext`c],
       Editable->False]}], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[$CellContext`T[-$CellContext`a, -$CellContext`b, \
-$CellContext`c] $CellContext`T[$CellContext`a, $CellContext`b, \
$CellContext`c]],
   Editable->False], "2"]], "Output",
 CellChangeTimes->{
  3.58313519975589*^9, {3.5831352534823856`*^9, 3.58313532519571*^9}, 
   3.583138087853363*^9, 3.583138209144576*^9, 3.5831466229178066`*^9, 
   3.583150173172643*^9, 3.5831502241223335`*^9, 3.583150272466817*^9, {
   3.5879651839134607`*^9, 3.587965204411897*^9}, 3.588079873497629*^9, 
   3.588079956598976*^9, 3.5880833299073076`*^9, 3.588083690845142*^9, 
   3.588319064068177*^9, 3.5883191700235634`*^9, 3.588325827342041*^9, 
   3.588325958600672*^9, 3.5883269169737544`*^9, 3.588327860355212*^9, 
   3.588327929525733*^9, 3.588328019475491*^9, 3.588328473873089*^9, 
   3.5883285579884377`*^9, 3.588329397395711*^9, {3.588329680863809*^9, 
   3.58832970440425*^9}, 3.588329912648015*^9, 3.6151308261668596`*^9, 
   3.615131008245284*^9, 3.619089166260088*^9, 3.619626215619158*^9, 
   3.620542571858579*^9, 3.6463817104509697`*^9, 3.679983969278212*^9, 
   3.679984668906686*^9, 3.6977391843171806`*^9, 3.697739239419258*^9, 
   3.715232895650969*^9, 3.7152337473154*^9, 3.7273348991439247`*^9, 
   3.72733523894116*^9, 3.727335331474476*^9, 3.7273361439215226`*^9, 
   3.7273362353223515`*^9, 3.727336466209875*^9, 3.727336736413634*^9, 
   3.727337058607791*^9, 3.727340515534221*^9, 3.727340623912501*^9, 
   3.727340740414274*^9, 3.727341333044395*^9, 3.7273420732316732`*^9, 
   3.727343587210859*^9, 3.7273436702709737`*^9, 3.72734375019496*^9, 
   3.727343858422102*^9, 3.7274106461654553`*^9, 3.72827871104016*^9, 
   3.728280994552922*^9, 3.728483765558129*^9, 3.728551304697933*^9, 
   3.728551798883053*^9, 3.728804569584321*^9, 3.7288046924873514`*^9, 
   3.728808519222137*^9, 3.728808861346704*^9, 3.777914014582016*^9, 
   3.777914085664821*^9, 3.791093802880863*^9, 3.791093952096062*^9, 
   3.820204748471298*^9, 3.820207207512535*^9, 3.820207298225049*^9, 
   3.8202073670089746`*^9, 3.842762464847251*^9, 3.844390005883433*^9, 
   3.84439007709554*^9, 3.844390674960698*^9, 3.844391079920722*^9, 
   3.8758915757569556`*^9, 3.875891994926744*^9, 3.921306833062933*^9, 
   3.921306907354595*^9, 3.921306950175972*^9, 3.9584003373601513`*^9},
 CellLabel->
  "Out[487]=",ExpressionUUID->"a605e825-ef82-8340-a900-077aeef16df0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.583135209833508*^9, 3.583135212329512*^9}},
 CellLabel->
  "In[488]:=",ExpressionUUID->"933f705b-0917-43be-8aa0-6a2f0c3b63f4"],

Cell[BoxData["\<\"(\\\\tau_{abc} \\\\tau^{abc})^2\"\>"], "Output",
 CellChangeTimes->{
  3.5831352135463147`*^9, {3.583135254199986*^9, 3.583135325226911*^9}, 
   3.5831380880249643`*^9, 3.583138209160177*^9, 3.583146622933407*^9, 
   3.583150173188243*^9, 3.583150224262733*^9, 3.5831502724980183`*^9, {
   3.58796518394466*^9, 3.587965204443096*^9}, 3.58807987351323*^9, 
   3.5880799566301756`*^9, 3.588083329954108*^9, 3.588083690985543*^9, 
   3.588319064099378*^9, 3.588319170054764*^9, 3.588325827357641*^9, 
   3.588325958631871*^9, 3.588326916989355*^9, 3.588327860370812*^9, 
   3.588327929541333*^9, 3.588328019506691*^9, 3.588328473888689*^9, 
   3.588328558004037*^9, 3.588329397411311*^9, {3.58832968087941*^9, 
   3.588329704419851*^9}, 3.588329912663615*^9, 3.6151308261768594`*^9, 
   3.615131008260885*^9, 3.619089166270088*^9, 3.619626215629158*^9, 
   3.620542571858579*^9, 3.646381710470969*^9, 3.679983969288211*^9, 
   3.679984668916686*^9, 3.697739184327181*^9, 3.6977392394292583`*^9, 
   3.715232895738216*^9, 3.7152337473803873`*^9, 3.7273348991660085`*^9, 
   3.7273352389728146`*^9, 3.7273353315591254`*^9, 3.727336143968403*^9, 
   3.7273362353379993`*^9, 3.727336466256712*^9, 3.7273367364514422`*^9, 
   3.72733705863649*^9, 3.7273405155655007`*^9, 3.727340623943753*^9, 
   3.727340740445529*^9, 3.727341333075633*^9, 3.727342073278552*^9, 
   3.7273435872421317`*^9, 3.727343670302255*^9, 3.727343750226495*^9, 
   3.727343858459515*^9, 3.727410646187605*^9, 3.728278711077496*^9, 
   3.7282809945750675`*^9, 3.728483765558129*^9, 3.728551304713565*^9, 
   3.728551798888563*^9, 3.728804569603322*^9, 3.728804692507352*^9, 
   3.728808519237772*^9, 3.728808861346704*^9, 3.77791401462881*^9, 
   3.777914085680464*^9, 3.791093802982417*^9, 3.791093952189833*^9, 
   3.820204748505206*^9, 3.820207207521512*^9, 3.820207298258994*^9, 
   3.8202073670408893`*^9, 3.8427624648711605`*^9, 3.844390005915361*^9, 
   3.844390077141394*^9, 3.844390674992615*^9, 3.844391079959624*^9, 
   3.875891575779866*^9, 3.875891994940679*^9, 3.9213068330888634`*^9, 
   3.921306907380497*^9, 3.9213069501938953`*^9, 3.9584003373761578`*^9},
 CellLabel->
  "Out[488]=",ExpressionUUID->"84bbaf5b-66ce-7144-a880-0ac2be16f413"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scalar", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5831351756382475`*^9, 3.583135185045064*^9}, {
  3.5831352273211393`*^9, 3.58313522777354*^9}},
 CellLabel->
  "In[489]:=",ExpressionUUID->"e1829cf4-b836-48ef-b063-28957e141cce"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["(",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", " ", " "},
             {"a", "b", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[-$CellContext`a, -$CellContext`b, -$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"a", "b", "c"},
             {" ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[$CellContext`a, $CellContext`b, $CellContext`c],
      Editable->False]}], 
    StyleBox[")",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Scalar[$CellContext`T[-$CellContext`a, -$CellContext`b, \
-$CellContext`c] $CellContext`T[$CellContext`a, $CellContext`b, \
$CellContext`c]],
  Editable->False]], "Output",
 CellChangeTimes->{{3.58313519975589*^9, 3.583135325226911*^9}, 
   3.5831380880561643`*^9, 3.583138209160177*^9, 3.583146622949006*^9, 
   3.583150173203843*^9, 3.5831502242783337`*^9, 3.583150272513618*^9, {
   3.58796518394466*^9, 3.587965204458697*^9}, 3.5880798735288286`*^9, 
   3.5880799566301756`*^9, 3.588083329985308*^9, 3.5880836912195425`*^9, 
   3.588319064114978*^9, 3.588319170070364*^9, 3.5883258273732405`*^9, 
   3.588325958631871*^9, 3.588326916989355*^9, 3.5883278603864126`*^9, 
   3.5883279295569344`*^9, 3.588328019506691*^9, 3.5883284739042883`*^9, 
   3.588328558019637*^9, 3.5883293974269123`*^9, {3.588329680895009*^9, 
   3.588329704435451*^9}, 3.5883299126792154`*^9, 3.615130826186859*^9, 
   3.615131008260885*^9, 3.619089166280088*^9, 3.619626215639158*^9, 
   3.6205425718685784`*^9, 3.646381710490969*^9, 3.679983969308209*^9, 
   3.679984668936687*^9, 3.697739184347181*^9, 3.6977392394492583`*^9, 
   3.715232895784321*^9, 3.715233747497055*^9, 3.727334899181936*^9, 
   3.727335238988439*^9, 3.7273353315903797`*^9, 3.727336143984063*^9, 
   3.727336235369252*^9, 3.727336466291046*^9, 3.727336736487352*^9, 
   3.7273370586833982`*^9, 3.7273405156224394`*^9, 3.7273406239815288`*^9, 
   3.7273407404949164`*^9, 3.727341333091259*^9, 3.7273420733007*^9, 
   3.727343587279428*^9, 3.7273436703178816`*^9, 3.7273437502421236`*^9, 
   3.727343858475168*^9, 3.727410646205538*^9, 3.728278711093201*^9, 
   3.728280994590697*^9, 3.7284837655737557`*^9, 3.728551304737141*^9, 
   3.728551798904196*^9, 3.728804569616323*^9, 3.7288046925213532`*^9, 
   3.728808519237772*^9, 3.728808861362358*^9, 3.777914014675693*^9, 
   3.777914085711694*^9, 3.791093803049968*^9, 3.791093952312314*^9, 
   3.8202047485415297`*^9, 3.820207207555421*^9, 3.820207298299849*^9, 
   3.8202073670518885`*^9, 3.842762464897093*^9, 3.8443900059282866`*^9, 
   3.84439007717231*^9, 3.84439067502652*^9, 3.844391079988542*^9, 
   3.875891575787869*^9, 3.875891994956664*^9, 3.9213068330958443`*^9, 
   3.9213069073875065`*^9, 3.921306950230795*^9, 3.9584003373918343`*^9},
 CellLabel->
  "Out[489]=",ExpressionUUID->"b3995855-ded4-144d-9366-5ad7bd226fdc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.583135209833508*^9, 3.583135212329512*^9}},
 CellLabel->
  "In[490]:=",ExpressionUUID->"1fad9ad4-a3ae-4362-9eae-d4ca8afa3c6e"],

Cell[BoxData["\<\"(\\\\tau_{abc} \\\\tau^{abc})\"\>"], "Output",
 CellChangeTimes->{{3.5831352135463147`*^9, 3.5831353252425113`*^9}, 
   3.5831380882277646`*^9, 3.5831382091913767`*^9, 3.583146622964607*^9, 
   3.583150173219443*^9, 3.583150224293933*^9, 3.5831502725292177`*^9, {
   3.58796518397586*^9, 3.5879652044742966`*^9}, 3.58807987354443*^9, 
   3.588079956645776*^9, 3.588083330063308*^9, 3.588083691281943*^9, 
   3.588319064130577*^9, 3.588319170101564*^9, 3.5883258273888407`*^9, 
   3.5883259586474724`*^9, 3.588326917020555*^9, 3.588327860402012*^9, 
   3.588327929572533*^9, 3.588328019522291*^9, 3.588328473919889*^9, 
   3.5883285580352383`*^9, 3.588329397442512*^9, {3.5883296809106092`*^9, 
   3.5883297044510517`*^9}, 3.588329912694815*^9, 3.6151308261968594`*^9, 
   3.615131008276485*^9, 3.6190891662900877`*^9, 3.6196262156491585`*^9, 
   3.620542571878579*^9, 3.646381710500969*^9, 3.679983969318208*^9, 
   3.679984668956687*^9, 3.6977391843571806`*^9, 3.697739239459258*^9, 
   3.715232895816421*^9, 3.715233747546292*^9, 3.727334899213188*^9, 
   3.727335239011732*^9, 3.727335331643332*^9, 3.727336144016054*^9, 
   3.727336235400481*^9, 3.72733646632581*^9, 3.7273367365186043`*^9, 
   3.727337058714655*^9, 3.727340515653721*^9, 3.7273406240727015`*^9, 
   3.7273407405417995`*^9, 3.727341333106886*^9, 3.7273420733368917`*^9, 
   3.727343587295055*^9, 3.727343670355198*^9, 3.727343750273376*^9, 
   3.727343858517559*^9, 3.7274106462211533`*^9, 3.728278711124455*^9, 
   3.728280994590697*^9, 3.728483765589389*^9, 3.728551304752767*^9, 
   3.728551798925461*^9, 3.728804569634324*^9, 3.728804692533353*^9, 
   3.7288085192598243`*^9, 3.7288088613779583`*^9, 3.777914014722579*^9, 
   3.7779140857429466`*^9, 3.791093803136555*^9, 3.791093952396932*^9, 
   3.820204748551502*^9, 3.820207207592346*^9, 3.820207298336751*^9, 
   3.8202073670817795`*^9, 3.8427624649200583`*^9, 3.844390005959203*^9, 
   3.844390077200234*^9, 3.8443906750365*^9, 3.844391080018433*^9, 
   3.875891575836743*^9, 3.875891994969629*^9, 3.921306833118784*^9, 
   3.92130690740942*^9, 3.9213069502457848`*^9, 3.9584003374078217`*^9},
 CellLabel->
  "Out[490]=",ExpressionUUID->"dcebf6f8-17fb-a741-9158-c0770d1ab305"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefScalarFunction", "[", 
  RowBox[{"FF", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<F\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.605014846342925*^9, 3.605014870792959*^9}},
 CellLabel->
  "In[491]:=",ExpressionUUID->"5666f535-c1f4-4a97-af98-acd8ef34a1d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefScalarFunction", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"scalar function \"\>", "\[InvisibleSpace]", "FF",
    "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefScalarFunction, ": Defining ", 
   "scalar function ", $CellContext`FF, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.8202073671137257`*^9, 3.842762464944965*^9, 
  3.844390005988126*^9, 3.844390077230182*^9, 3.844390675066388*^9, 
  3.844391080045361*^9, 3.875891575857685*^9, 3.875891994974615*^9, 
  3.9213068331247673`*^9, 3.921306907431362*^9, 3.92130695025177*^9, 
  3.958400337414835*^9},
 CellLabel->
  "During evaluation of \
In[491]:=",ExpressionUUID->"1d2c52ec-9520-2d41-b64e-8dcca622d58d"]
}, Open  ]],

Cell["The different styles for parenthesis handling", "Text",
 CellChangeTimes->{{3.728808354322192*^9, 
  3.728808375357793*^9}},ExpressionUUID->"5e7efc3e-fd0e-4c29-8555-\
5a316a9c04da"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"FF", "[", 
     RowBox[{"\[Lambda]", "[", "]"}], "]"}], "]"}], "+", 
   RowBox[{"FF", "[", 
    RowBox[{"\[Lambda]", "[", "]"}], "]"}], "+", 
   RowBox[{"Cos", "[", 
    RowBox[{
     RowBox[{"FF", "[", 
      RowBox[{"\[Lambda]", "[", "]"}], "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"FF", "[", 
       RowBox[{"\[Lambda]", "[", "]"}], "]"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.605014889862986*^9, 3.605014899993*^9}, {
  3.605016312925979*^9, 3.6050163139259796`*^9}, {3.6050169587968826`*^9, 
  3.605016964186889*^9}, {3.605078430281968*^9, 3.605078472342027*^9}, {
  3.7288081524812593`*^9, 3.728808159754377*^9}},
 CellLabel->
  "In[492]:=",ExpressionUUID->"8324d686-471d-4df7-90be-55c5772158a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox["Cos",
     ShowAutoStyles->False,
     AutoSpacing->False],
    Cos,
    Editable->False], "[", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`FF,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[Lambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Lambda][],
      Editable->False], "]"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     RowBox[{
      InterpretationBox[
       StyleBox["F",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`FF,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[Lambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Lambda][],
       Editable->False], "]"}], "]"}]}], "]"}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox["F",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`FF,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox["\[Lambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Lambda][],
    Editable->False], "]"}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox["Sin",
     ShowAutoStyles->False,
     AutoSpacing->False],
    Sin,
    Editable->False], "[", 
   RowBox[{
    InterpretationBox[
     StyleBox["F",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`FF,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox["\[Lambda]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Lambda][],
     Editable->False], "]"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.605014901033002*^9, 3.60501519260341*^9, 3.605015351403632*^9, 
   3.605015381913675*^9, {3.605015425023735*^9, 3.605015431823745*^9}, {
   3.605015560623925*^9, 3.6050155650239315`*^9}, {3.605016311855977*^9, 
   3.6050163142459803`*^9}, 3.605016576106347*^9, 3.60501684231672*^9, {
   3.605016900686801*^9, 3.605016922926832*^9}, 3.6050169647668905`*^9, 
   3.605017696882034*^9, 3.6050180122024755`*^9, 3.605019245875202*^9, 
   3.605076358908068*^9, 3.605076798658684*^9, 3.6050778258501215`*^9, 
   3.605078007681377*^9, {3.6050784549020023`*^9, 3.605078472812028*^9}, 
   3.605079756055825*^9, 3.605081848379755*^9, 3.605081961229913*^9, 
   3.728801231120372*^9, 3.728801317307302*^9, 3.728801868796845*^9, 
   3.728802910013399*^9, 3.7288039903101883`*^9, 3.72880473390372*^9, 
   3.728808519275453*^9, 3.72880886139359*^9, 3.777914014800681*^9, 
   3.777914085805249*^9, 3.7910938032656417`*^9, 3.7910939525753946`*^9, 
   3.8202047486243076`*^9, 3.8202072076372027`*^9, 3.82020729838562*^9, 
   3.820207367146197*^9, 3.842762464968927*^9, 3.844390006019044*^9, 
   3.844390077241153*^9, 3.844390675094341*^9, 3.844391080077276*^9, 
   3.8758915758646393`*^9, 3.8758919949895763`*^9, 3.9213068331497*^9, 
   3.921306907438343*^9, 3.9213069502676964`*^9, 3.9584003374373074`*^9},
 CellLabel->
  "Out[492]=",ExpressionUUID->"639cfd67-14cd-014b-9c08-79a10473b9b9"]
}, Open  ]],

Cell["Same size everywhere.", "Text",
 CellChangeTimes->{{3.728808354322192*^9, 
  3.7288084074980307`*^9}},ExpressionUUID->"f8536740-6359-450c-9e08-\
7f44bc0db7a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tex", "@", "expr"}]], "Input",
 CellChangeTimes->{{3.605016644376443*^9, 3.605016646136445*^9}},
 CellLabel->
  "In[493]:=",ExpressionUUID->"5a2a83bd-2a9a-4485-a143-6c010d3c4903"],

Cell[BoxData["\<\"\\\\cos(F(\\\\lambda ) \\\\sin(F(\\\\lambda ))) + \
F(\\\\lambda ) + \\\\sin(F(\\\\lambda ))\"\>"], "Output",
 CellChangeTimes->{
  3.605016646596445*^9, 3.60501684238672*^9, {3.605016900756801*^9, 
   3.605016922996833*^9}, 3.6050169672068944`*^9, 3.605017696952034*^9, 
   3.6050180122724752`*^9, 3.6050192496452074`*^9, 3.605076358988068*^9, 
   3.605076801288687*^9, 3.605077825920122*^9, 3.605078007741377*^9, 
   3.60507848172204*^9, 3.605079757475827*^9, 3.605081848429755*^9, 
   3.605081961279913*^9, 3.7288012354336185`*^9, 3.728801317335303*^9, 
   3.728801868816846*^9, 3.7288029100394*^9, 3.728803990334189*^9, 
   3.7288047339267206`*^9, 3.728808519275453*^9, 3.7288088614147725`*^9, 
   3.777914014847565*^9, 3.777914085820879*^9, 3.791093803319031*^9, 
   3.7910939526600533`*^9, 3.820204748662207*^9, 3.8202072076472096`*^9, 
   3.820207298394596*^9, 3.820207367179081*^9, 3.842762465006799*^9, 
   3.844390006048998*^9, 3.844390077271058*^9, 3.844390675126253*^9, 
   3.8443910801052017`*^9, 3.875891575887578*^9, 3.875891995002514*^9, 
   3.9213068331556854`*^9, 3.921306907460312*^9, 3.921306950283697*^9, 
   3.9584003374393425`*^9},
 CellLabel->
  "Out[493]=",ExpressionUUID->"83b1fc73-5290-6d4c-a3db-18e5b6a87774"]
}, Open  ]],

Cell["Old code counts maximum parenthesis level.", "Text",
 CellChangeTimes->{{3.728808354322192*^9, 
  3.7288084509270053`*^9}},ExpressionUUID->"5497f1f6-3bf4-43b4-8ab9-\
279d7af834a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "[", 
  RowBox[{"expr", ",", "ParenthesisOldStyle"}], "]"}]], "Input",
 CellLabel->
  "In[494]:=",ExpressionUUID->"a77dc2fa-8db7-4083-8d9b-56a3838ff1a1"],

Cell[BoxData["\<\"\\\\cos\\\\Bigl(F\\\\bigl(\\\\lambda \\\\bigr) \
\\\\sin\\\\bigl(F(\\\\lambda)\\\\bigr)\\\\Bigr) + F\\\\Bigl(\\\\lambda \
\\\\Bigr) + \\\\sin\\\\Bigl(F\\\\bigl(\\\\lambda \\\\bigr)\\\\Bigr)\"\>"], \
"Output",
 CellChangeTimes->{3.728808519291112*^9, 3.728808861430697*^9, 
  3.77791401491006*^9, 3.777914085852129*^9, 3.791093803382907*^9, 
  3.791093952744712*^9, 3.820204748697113*^9, 3.8202072076831093`*^9, 
  3.820207298428533*^9, 3.820207367210025*^9, 3.842762465039711*^9, 
  3.844390006081875*^9, 3.844390077300965*^9, 3.844390675158173*^9, 
  3.8443910801351213`*^9, 3.875891576038175*^9, 3.875891995014509*^9, 
  3.9213068331796207`*^9, 3.9213069074852448`*^9, 3.921306950299612*^9, 
  3.9584003374572887`*^9},
 CellLabel->
  "Out[494]=",ExpressionUUID->"67e7163f-1841-2c4f-9ba9-011375b9a4aa"]
}, Open  ]],

Cell["New code counts depth for each case.", "Text",
 CellChangeTimes->{{3.728808354322192*^9, 
  3.7288084894472*^9}},ExpressionUUID->"58a4190f-c674-4cf8-9bb3-1d5b8c1765aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[495]:=",ExpressionUUID->"8e9f5254-b6a9-4d0d-b486-814cdcb2c75d"],

Cell[BoxData["\<\"\\\\cos\\\\Bigl(F(\\\\lambda) \\\\sin\\\\bigl(F(\\\\lambda)\
\\\\bigr)\\\\Bigr) + F(\\\\lambda) + \\\\sin\\\\bigl(F(\\\\lambda)\\\\bigr)\"\
\>"], "Output",
 CellChangeTimes->{
  3.7288029278024173`*^9, 3.72880303224539*^9, 3.7288031447138233`*^9, 
   3.7288032031311646`*^9, {3.728803267804864*^9, 3.728803278787492*^9}, {
   3.7288034853053036`*^9, 3.72880351513301*^9}, 3.728803643750366*^9, {
   3.728803717388578*^9, 3.728803738857806*^9}, 3.728803992921338*^9, {
   3.7288040472224445`*^9, 3.728804073601953*^9}, 3.7288047339367213`*^9, 
   3.728808519306733*^9, 3.728808861430697*^9, 3.777914014941313*^9, 
   3.777914085867751*^9, 3.791093803450453*^9, 3.791093952829372*^9, 
   3.820204748705092*^9, 3.820207207690086*^9, 3.820207298464437*^9, 
   3.820207367241937*^9, 3.842762465063647*^9, 3.844390006112819*^9, 
   3.844390077327894*^9, 3.844390675185098*^9, 3.844391080147088*^9, 
   3.8758915760670986`*^9, 3.8758919950274754`*^9, 3.9213068331866016`*^9, 
   3.9213069075101795`*^9, 3.921306950315569*^9, 3.9584003374710674`*^9},
 CellLabel->
  "Out[495]=",ExpressionUUID->"75315735-bd95-af45-b6ae-2941b21e43c1"]
}, Open  ]],

Cell["\<\
If one wants other brackets at different levels, one can set this with \
OpenParenthesis and CloseParenthesis for each level.\
\>", "Text",
 CellChangeTimes->{{3.728808354322192*^9, 3.7288084894472*^9}, {
  3.72880860221092*^9, 
  3.7288086709517593`*^9}},ExpressionUUID->"fe71540a-feb3-445f-8f2b-\
8004518ff38d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{"1", ",", "\"\<(\>\""}], "]"}], ":=", "\"\<\\\\bigl [\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CloseParenthesis", "[", 
    RowBox[{"1", ",", "\"\<)\>\""}], "]"}], ":=", "\"\<\\\\bigl ]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{"2", ",", "\"\<(\>\""}], "]"}], ":=", "\"\<\\\\bigl \\\\{\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CloseParenthesis", "[", 
    RowBox[{"2", ",", "\"\<)\>\""}], "]"}], ":=", "\"\<\\\\bigl \\\\}\>\""}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.728808561211624*^9, 3.7288085946371665`*^9}, {
  3.728808675416741*^9, 3.72880871091463*^9}, {3.7288087559218755`*^9, 
  3.728808757484271*^9}},
 CellLabel->
  "In[496]:=",ExpressionUUID->"614f73da-cc38-4f61-ba73-541508e33524"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[500]:=",ExpressionUUID->"5be57966-a086-46d1-8206-44b5d1003e96"],

Cell[BoxData["\<\"\\\\cos\\\\bigl \\\\{F(\\\\lambda) \\\\sin\\\\bigl \
[F(\\\\lambda)\\\\bigl ]\\\\bigl \\\\} + F(\\\\lambda) + \\\\sin\\\\bigl \
[F(\\\\lambda)\\\\bigl ]\"\>"], "Output",
 CellChangeTimes->{3.7288087196939926`*^9, 3.728808759353778*^9, 
  3.728808861451401*^9, 3.777914015003808*^9, 3.777914085914631*^9, 
  3.791093803534883*^9, 3.791093952961198*^9, 3.820204748747977*^9, 
  3.820207207728984*^9, 3.820207298505329*^9, 3.820207367279396*^9, 
  3.8427624651005483`*^9, 3.844390006149721*^9, 3.844390077363825*^9, 
  3.8443906752179832`*^9, 3.8443910801889777`*^9, 3.8758915761010075`*^9, 
  3.875891995042434*^9, 3.921306833212532*^9, 3.9213069075350857`*^9, 
  3.921306950335516*^9, 3.9584003374871597`*^9},
 CellLabel->
  "Out[500]=",ExpressionUUID->"0bb8ba38-cf7e-2445-ab0d-8ef5d038be75"]
}, Open  ]],

Cell["Reset to default.", "Text",
 CellChangeTimes->{{3.728808354322192*^9, 3.7288084894472*^9}, {
  3.72880860221092*^9, 3.7288086709517593`*^9}, {3.7288087836428623`*^9, 
  3.728808807225651*^9}},ExpressionUUID->"fd8422bf-8c1f-41a1-b641-\
380a16e2406b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{"1", ",", "\"\<(\>\""}], "]"}], "=."}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CloseParenthesis", "[", 
    RowBox[{"1", ",", "\"\<)\>\""}], "]"}], "=."}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OpenParenthesis", "[", 
    RowBox[{"2", ",", "\"\<(\>\""}], "]"}], "=."}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CloseParenthesis", "[", 
    RowBox[{"2", ",", "\"\<)\>\""}], "]"}], "=."}], ";"}]}], "Input",
 CellChangeTimes->{{3.728808795249406*^9, 3.728808823292862*^9}},
 CellLabel->
  "In[501]:=",ExpressionUUID->"8d28192e-8a61-48c0-aa04-b2c1fb455db4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefBasis", "[", "B4", "]"}]], "Input",
 CellChangeTimes->{{3.583150206338301*^9, 3.583150210581509*^9}},
 CellLabel->
  "In[505]:=",ExpressionUUID->"92971777-e85b-4977-8097-6fbf3fa26d42"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelPDB4"}],
  
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDB4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583150224309533*^9, 3.5831502725292177`*^9, {3.58796518397586*^9, 
   3.587965204489897*^9}, 3.58807987357563*^9, 3.588079956770576*^9, 
   3.588083330094508*^9, 3.588083691500343*^9, 3.588319071618591*^9, 
   3.588319170132764*^9, 3.588325827404441*^9, 3.588325958663071*^9, 
   3.588326917051755*^9, 3.588327860417612*^9, 3.588327929588133*^9, 
   3.5883280195378914`*^9, 3.588328473935489*^9, 3.588328558082037*^9, 
   3.588329397458112*^9, {3.5883296809262094`*^9, 3.5883297044510517`*^9}, 
   3.588329912710415*^9, 3.6151308262068596`*^9, 3.615131008276485*^9, 
   3.6190891662900877`*^9, 3.6196262156491585`*^9, 3.6205425718885784`*^9, 
   3.64638171052097*^9, 3.679983969338207*^9, 3.6799846689666877`*^9, 
   3.697739184367181*^9, 3.6977392394692583`*^9, 3.715232895868195*^9, 
   3.715233747598928*^9, 3.727334899244442*^9, 3.727335239040399*^9, 
   3.7273353316746254`*^9, 3.7273361440215993`*^9, 3.727336235422183*^9, 
   3.727336466357097*^9, 3.727336736550864*^9, 3.7273370587418604`*^9, 
   3.727340515684977*^9, 3.727340624103954*^9, 3.727340740610755*^9, 
   3.7273413331286936`*^9, 3.727342073368117*^9, 3.727343587326342*^9, 
   3.727343670370824*^9, 3.727343750295529*^9, 3.727343858558897*^9, 
   3.727410646236786*^9, 3.7282787166823406`*^9, 3.7282809946063232`*^9, 
   3.728483765605542*^9, 3.728551304782439*^9, 3.728551798941096*^9, 
   3.728804569646324*^9, 3.7288046925473547`*^9, 3.7288088614638243`*^9, 
   3.777914015050721*^9, 3.777914085977126*^9, 3.791093803619147*^9, 
   3.791093953061379*^9, 3.820204748794852*^9, 3.8202072077688503`*^9, 
   3.8202072985452228`*^9, 3.8202073673153*^9, 3.842762465141465*^9, 
   3.844390006190584*^9, 3.844390077401723*^9, 3.844390675257899*^9, 
   3.84439108022591*^9, 3.875891576130955*^9, 3.875891995050413*^9, 
   3.921306833221508*^9, 3.921306907562048*^9, 3.921306950344492*^9, 
   3.958400337503193*^9},
 CellLabel->
  "During evaluation of \
In[505]:=",ExpressionUUID->"57b19b07-06d3-f74c-84b5-f6d41e40ffe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDB4"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDB4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583150224309533*^9, 3.5831502725292177`*^9, {3.58796518397586*^9, 
   3.587965204489897*^9}, 3.58807987357563*^9, 3.588079956770576*^9, 
   3.588083330094508*^9, 3.588083691500343*^9, 3.588319071618591*^9, 
   3.588319170132764*^9, 3.588325827404441*^9, 3.588325958663071*^9, 
   3.588326917051755*^9, 3.588327860417612*^9, 3.588327929588133*^9, 
   3.5883280195378914`*^9, 3.588328473935489*^9, 3.588328558082037*^9, 
   3.588329397458112*^9, {3.5883296809262094`*^9, 3.5883297044510517`*^9}, 
   3.588329912710415*^9, 3.6151308262068596`*^9, 3.615131008276485*^9, 
   3.6190891662900877`*^9, 3.6196262156491585`*^9, 3.6205425718885784`*^9, 
   3.64638171052097*^9, 3.679983969338207*^9, 3.6799846689666877`*^9, 
   3.697739184367181*^9, 3.6977392394692583`*^9, 3.715232895868195*^9, 
   3.715233747598928*^9, 3.727334899244442*^9, 3.727335239040399*^9, 
   3.7273353316746254`*^9, 3.7273361440215993`*^9, 3.727336235422183*^9, 
   3.727336466357097*^9, 3.727336736550864*^9, 3.7273370587418604`*^9, 
   3.727340515684977*^9, 3.727340624103954*^9, 3.727340740610755*^9, 
   3.7273413331286936`*^9, 3.727342073368117*^9, 3.727343587326342*^9, 
   3.727343670370824*^9, 3.727343750295529*^9, 3.727343858558897*^9, 
   3.727410646236786*^9, 3.7282787166823406`*^9, 3.7282809946063232`*^9, 
   3.728483765605542*^9, 3.728551304782439*^9, 3.728551798941096*^9, 
   3.728804569646324*^9, 3.7288046925473547`*^9, 3.7288088614638243`*^9, 
   3.777914015050721*^9, 3.777914085977126*^9, 3.791093803619147*^9, 
   3.791093953061379*^9, 3.820204748794852*^9, 3.8202072077688503`*^9, 
   3.8202072985452228`*^9, 3.8202073673153*^9, 3.842762465141465*^9, 
   3.844390006190584*^9, 3.844390077401723*^9, 3.844390675257899*^9, 
   3.84439108022591*^9, 3.875891576130955*^9, 3.875891995050413*^9, 
   3.921306833221508*^9, 3.921306907562048*^9, 3.921306950344492*^9, 
   3.958400337503193*^9},
 CellLabel->
  "During evaluation of \
In[505]:=",ExpressionUUID->"fad1990f-2d83-d045-879e-184db0841995"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDB4"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDB4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583150224309533*^9, 3.5831502725292177`*^9, {3.58796518397586*^9, 
   3.587965204489897*^9}, 3.58807987357563*^9, 3.588079956770576*^9, 
   3.588083330094508*^9, 3.588083691500343*^9, 3.588319071618591*^9, 
   3.588319170132764*^9, 3.588325827404441*^9, 3.588325958663071*^9, 
   3.588326917051755*^9, 3.588327860417612*^9, 3.588327929588133*^9, 
   3.5883280195378914`*^9, 3.588328473935489*^9, 3.588328558082037*^9, 
   3.588329397458112*^9, {3.5883296809262094`*^9, 3.5883297044510517`*^9}, 
   3.588329912710415*^9, 3.6151308262068596`*^9, 3.615131008276485*^9, 
   3.6190891662900877`*^9, 3.6196262156491585`*^9, 3.6205425718885784`*^9, 
   3.64638171052097*^9, 3.679983969338207*^9, 3.6799846689666877`*^9, 
   3.697739184367181*^9, 3.6977392394692583`*^9, 3.715232895868195*^9, 
   3.715233747598928*^9, 3.727334899244442*^9, 3.727335239040399*^9, 
   3.7273353316746254`*^9, 3.7273361440215993`*^9, 3.727336235422183*^9, 
   3.727336466357097*^9, 3.727336736550864*^9, 3.7273370587418604`*^9, 
   3.727340515684977*^9, 3.727340624103954*^9, 3.727340740610755*^9, 
   3.7273413331286936`*^9, 3.727342073368117*^9, 3.727343587326342*^9, 
   3.727343670370824*^9, 3.727343750295529*^9, 3.727343858558897*^9, 
   3.727410646236786*^9, 3.7282787166823406`*^9, 3.7282809946063232`*^9, 
   3.728483765605542*^9, 3.728551304782439*^9, 3.728551798941096*^9, 
   3.728804569646324*^9, 3.7288046925473547`*^9, 3.7288088614638243`*^9, 
   3.777914015050721*^9, 3.777914085977126*^9, 3.791093803619147*^9, 
   3.791093953061379*^9, 3.820204748794852*^9, 3.8202072077688503`*^9, 
   3.8202072985452228`*^9, 3.8202073673153*^9, 3.842762465141465*^9, 
   3.844390006190584*^9, 3.844390077401723*^9, 3.844390675257899*^9, 
   3.84439108022591*^9, 3.875891576130955*^9, 3.875891995050413*^9, 
   3.921306833221508*^9, 3.921306907562048*^9, 3.921306950344492*^9, 
   3.958400337503193*^9},
 CellLabel->
  "During evaluation of \
In[505]:=",ExpressionUUID->"42f28118-0afd-2f4a-8ac0-8a81d6be8454"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDB4"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDB4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583150224309533*^9, 3.5831502725292177`*^9, {3.58796518397586*^9, 
   3.587965204489897*^9}, 3.58807987357563*^9, 3.588079956770576*^9, 
   3.588083330094508*^9, 3.588083691500343*^9, 3.588319071618591*^9, 
   3.588319170132764*^9, 3.588325827404441*^9, 3.588325958663071*^9, 
   3.588326917051755*^9, 3.588327860417612*^9, 3.588327929588133*^9, 
   3.5883280195378914`*^9, 3.588328473935489*^9, 3.588328558082037*^9, 
   3.588329397458112*^9, {3.5883296809262094`*^9, 3.5883297044510517`*^9}, 
   3.588329912710415*^9, 3.6151308262068596`*^9, 3.615131008276485*^9, 
   3.6190891662900877`*^9, 3.6196262156491585`*^9, 3.6205425718885784`*^9, 
   3.64638171052097*^9, 3.679983969338207*^9, 3.6799846689666877`*^9, 
   3.697739184367181*^9, 3.6977392394692583`*^9, 3.715232895868195*^9, 
   3.715233747598928*^9, 3.727334899244442*^9, 3.727335239040399*^9, 
   3.7273353316746254`*^9, 3.7273361440215993`*^9, 3.727336235422183*^9, 
   3.727336466357097*^9, 3.727336736550864*^9, 3.7273370587418604`*^9, 
   3.727340515684977*^9, 3.727340624103954*^9, 3.727340740610755*^9, 
   3.7273413331286936`*^9, 3.727342073368117*^9, 3.727343587326342*^9, 
   3.727343670370824*^9, 3.727343750295529*^9, 3.727343858558897*^9, 
   3.727410646236786*^9, 3.7282787166823406`*^9, 3.7282809946063232`*^9, 
   3.728483765605542*^9, 3.728551304782439*^9, 3.728551798941096*^9, 
   3.728804569646324*^9, 3.7288046925473547`*^9, 3.7288088614638243`*^9, 
   3.777914015050721*^9, 3.777914085977126*^9, 3.791093803619147*^9, 
   3.791093953061379*^9, 3.820204748794852*^9, 3.8202072077688503`*^9, 
   3.8202072985452228`*^9, 3.8202073673153*^9, 3.842762465141465*^9, 
   3.844390006190584*^9, 3.844390077401723*^9, 3.844390675257899*^9, 
   3.84439108022591*^9, 3.875891576130955*^9, 3.875891995050413*^9, 
   3.921306833221508*^9, 3.921306907562048*^9, 3.921306950344492*^9, 
   3.9584003375122375`*^9},
 CellLabel->
  "During evaluation of \
In[505]:=",ExpressionUUID->"b323d73b-bc38-6b4c-82e8-52eca8923bc2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDB4"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDB4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583150224309533*^9, 3.5831502725292177`*^9, {3.58796518397586*^9, 
   3.587965204489897*^9}, 3.58807987357563*^9, 3.588079956770576*^9, 
   3.588083330094508*^9, 3.588083691500343*^9, 3.588319071618591*^9, 
   3.588319170132764*^9, 3.588325827404441*^9, 3.588325958663071*^9, 
   3.588326917051755*^9, 3.588327860417612*^9, 3.588327929588133*^9, 
   3.5883280195378914`*^9, 3.588328473935489*^9, 3.588328558082037*^9, 
   3.588329397458112*^9, {3.5883296809262094`*^9, 3.5883297044510517`*^9}, 
   3.588329912710415*^9, 3.6151308262068596`*^9, 3.615131008276485*^9, 
   3.6190891662900877`*^9, 3.6196262156491585`*^9, 3.6205425718885784`*^9, 
   3.64638171052097*^9, 3.679983969338207*^9, 3.6799846689666877`*^9, 
   3.697739184367181*^9, 3.6977392394692583`*^9, 3.715232895868195*^9, 
   3.715233747598928*^9, 3.727334899244442*^9, 3.727335239040399*^9, 
   3.7273353316746254`*^9, 3.7273361440215993`*^9, 3.727336235422183*^9, 
   3.727336466357097*^9, 3.727336736550864*^9, 3.7273370587418604`*^9, 
   3.727340515684977*^9, 3.727340624103954*^9, 3.727340740610755*^9, 
   3.7273413331286936`*^9, 3.727342073368117*^9, 3.727343587326342*^9, 
   3.727343670370824*^9, 3.727343750295529*^9, 3.727343858558897*^9, 
   3.727410646236786*^9, 3.7282787166823406`*^9, 3.7282809946063232`*^9, 
   3.728483765605542*^9, 3.728551304782439*^9, 3.728551798941096*^9, 
   3.728804569646324*^9, 3.7288046925473547`*^9, 3.7288088614638243`*^9, 
   3.777914015050721*^9, 3.777914085977126*^9, 3.791093803619147*^9, 
   3.791093953061379*^9, 3.820204748794852*^9, 3.8202072077688503`*^9, 
   3.8202072985452228`*^9, 3.8202073673153*^9, 3.842762465141465*^9, 
   3.844390006190584*^9, 3.844390077401723*^9, 3.844390675257899*^9, 
   3.84439108022591*^9, 3.875891576130955*^9, 3.875891995050413*^9, 
   3.921306833221508*^9, 3.921306907562048*^9, 3.921306950344492*^9, 
   3.9584003375122375`*^9},
 CellLabel->
  "During evaluation of \
In[505]:=",ExpressionUUID->"be70f273-9564-5146-9686-5781723c4a6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaUpB4"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric +1 density",
    " ", $CellContext`etaUpB4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583150224309533*^9, 3.5831502725292177`*^9, {3.58796518397586*^9, 
   3.587965204489897*^9}, 3.58807987357563*^9, 3.588079956770576*^9, 
   3.588083330094508*^9, 3.588083691500343*^9, 3.588319071618591*^9, 
   3.588319170132764*^9, 3.588325827404441*^9, 3.588325958663071*^9, 
   3.588326917051755*^9, 3.588327860417612*^9, 3.588327929588133*^9, 
   3.5883280195378914`*^9, 3.588328473935489*^9, 3.588328558082037*^9, 
   3.588329397458112*^9, {3.5883296809262094`*^9, 3.5883297044510517`*^9}, 
   3.588329912710415*^9, 3.6151308262068596`*^9, 3.615131008276485*^9, 
   3.6190891662900877`*^9, 3.6196262156491585`*^9, 3.6205425718885784`*^9, 
   3.64638171052097*^9, 3.679983969338207*^9, 3.6799846689666877`*^9, 
   3.697739184367181*^9, 3.6977392394692583`*^9, 3.715232895868195*^9, 
   3.715233747598928*^9, 3.727334899244442*^9, 3.727335239040399*^9, 
   3.7273353316746254`*^9, 3.7273361440215993`*^9, 3.727336235422183*^9, 
   3.727336466357097*^9, 3.727336736550864*^9, 3.7273370587418604`*^9, 
   3.727340515684977*^9, 3.727340624103954*^9, 3.727340740610755*^9, 
   3.7273413331286936`*^9, 3.727342073368117*^9, 3.727343587326342*^9, 
   3.727343670370824*^9, 3.727343750295529*^9, 3.727343858558897*^9, 
   3.727410646236786*^9, 3.7282787166823406`*^9, 3.7282809946063232`*^9, 
   3.728483765605542*^9, 3.728551304782439*^9, 3.728551798941096*^9, 
   3.728804569646324*^9, 3.7288046925473547`*^9, 3.7288088614638243`*^9, 
   3.777914015050721*^9, 3.777914085977126*^9, 3.791093803619147*^9, 
   3.791093953061379*^9, 3.820204748794852*^9, 3.8202072077688503`*^9, 
   3.8202072985452228`*^9, 3.8202073673153*^9, 3.842762465141465*^9, 
   3.844390006190584*^9, 3.844390077401723*^9, 3.844390675257899*^9, 
   3.84439108022591*^9, 3.875891576130955*^9, 3.875891995050413*^9, 
   3.921306833221508*^9, 3.921306907562048*^9, 3.921306950344492*^9, 
   3.9584003375122375`*^9},
 CellLabel->
  "During evaluation of \
In[505]:=",ExpressionUUID->"d02d8ee9-e76d-1341-8624-4a85bf95edc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "etaDownB4"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric -1 density",
    " ", $CellContext`etaDownB4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583150224309533*^9, 3.5831502725292177`*^9, {3.58796518397586*^9, 
   3.587965204489897*^9}, 3.58807987357563*^9, 3.588079956770576*^9, 
   3.588083330094508*^9, 3.588083691500343*^9, 3.588319071618591*^9, 
   3.588319170132764*^9, 3.588325827404441*^9, 3.588325958663071*^9, 
   3.588326917051755*^9, 3.588327860417612*^9, 3.588327929588133*^9, 
   3.5883280195378914`*^9, 3.588328473935489*^9, 3.588328558082037*^9, 
   3.588329397458112*^9, {3.5883296809262094`*^9, 3.5883297044510517`*^9}, 
   3.588329912710415*^9, 3.6151308262068596`*^9, 3.615131008276485*^9, 
   3.6190891662900877`*^9, 3.6196262156491585`*^9, 3.6205425718885784`*^9, 
   3.64638171052097*^9, 3.679983969338207*^9, 3.6799846689666877`*^9, 
   3.697739184367181*^9, 3.6977392394692583`*^9, 3.715232895868195*^9, 
   3.715233747598928*^9, 3.727334899244442*^9, 3.727335239040399*^9, 
   3.7273353316746254`*^9, 3.7273361440215993`*^9, 3.727336235422183*^9, 
   3.727336466357097*^9, 3.727336736550864*^9, 3.7273370587418604`*^9, 
   3.727340515684977*^9, 3.727340624103954*^9, 3.727340740610755*^9, 
   3.7273413331286936`*^9, 3.727342073368117*^9, 3.727343587326342*^9, 
   3.727343670370824*^9, 3.727343750295529*^9, 3.727343858558897*^9, 
   3.727410646236786*^9, 3.7282787166823406`*^9, 3.7282809946063232`*^9, 
   3.728483765605542*^9, 3.728551304782439*^9, 3.728551798941096*^9, 
   3.728804569646324*^9, 3.7288046925473547`*^9, 3.7288088614638243`*^9, 
   3.777914015050721*^9, 3.777914085977126*^9, 3.791093803619147*^9, 
   3.791093953061379*^9, 3.820204748794852*^9, 3.8202072077688503`*^9, 
   3.8202072985452228`*^9, 3.8202073673153*^9, 3.842762465141465*^9, 
   3.844390006190584*^9, 3.844390077401723*^9, 3.844390675257899*^9, 
   3.84439108022591*^9, 3.875891576130955*^9, 3.875891995050413*^9, 
   3.921306833221508*^9, 3.921306907562048*^9, 3.921306950344492*^9, 
   3.9584003375188713`*^9},
 CellLabel->
  "During evaluation of \
In[505]:=",ExpressionUUID->"7ab7bd63-9246-8c41-a94e-b659d8e0f038"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "B4"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", " ", $CellContext`B4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.583150224309533*^9, 3.5831502725292177`*^9, {3.58796518397586*^9, 
   3.587965204489897*^9}, 3.58807987357563*^9, 3.588079956770576*^9, 
   3.588083330094508*^9, 3.588083691500343*^9, 3.588319071618591*^9, 
   3.588319170132764*^9, 3.588325827404441*^9, 3.588325958663071*^9, 
   3.588326917051755*^9, 3.588327860417612*^9, 3.588327929588133*^9, 
   3.5883280195378914`*^9, 3.588328473935489*^9, 3.588328558082037*^9, 
   3.588329397458112*^9, {3.5883296809262094`*^9, 3.5883297044510517`*^9}, 
   3.588329912710415*^9, 3.6151308262068596`*^9, 3.615131008276485*^9, 
   3.6190891662900877`*^9, 3.6196262156491585`*^9, 3.6205425718885784`*^9, 
   3.64638171052097*^9, 3.679983969338207*^9, 3.6799846689666877`*^9, 
   3.697739184367181*^9, 3.6977392394692583`*^9, 3.715232895868195*^9, 
   3.715233747598928*^9, 3.727334899244442*^9, 3.727335239040399*^9, 
   3.7273353316746254`*^9, 3.7273361440215993`*^9, 3.727336235422183*^9, 
   3.727336466357097*^9, 3.727336736550864*^9, 3.7273370587418604`*^9, 
   3.727340515684977*^9, 3.727340624103954*^9, 3.727340740610755*^9, 
   3.7273413331286936`*^9, 3.727342073368117*^9, 3.727343587326342*^9, 
   3.727343670370824*^9, 3.727343750295529*^9, 3.727343858558897*^9, 
   3.727410646236786*^9, 3.7282787166823406`*^9, 3.7282809946063232`*^9, 
   3.728483765605542*^9, 3.728551304782439*^9, 3.728551798941096*^9, 
   3.728804569646324*^9, 3.7288046925473547`*^9, 3.7288088614638243`*^9, 
   3.777914015050721*^9, 3.777914085977126*^9, 3.791093803619147*^9, 
   3.791093953061379*^9, 3.820204748794852*^9, 3.8202072077688503`*^9, 
   3.8202072985452228`*^9, 3.8202073673153*^9, 3.842762465141465*^9, 
   3.844390006190584*^9, 3.844390077401723*^9, 3.844390675257899*^9, 
   3.84439108022591*^9, 3.875891576130955*^9, 3.875891995050413*^9, 
   3.921306833221508*^9, 3.921306907562048*^9, 3.921306950344492*^9, 
   3.9584003375188713`*^9},
 CellLabel->
  "During evaluation of \
In[505]:=",ExpressionUUID->"9d7d7a5a-319b-7b4d-9aba-b9c91b331246"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "/@", "$Tensors"}]], "Input",
 CellLabel->
  "In[506]:=",ExpressionUUID->"e8a948e3-dd67-44b0-b2f7-d7f9f6137486"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.582347796528718*^9, 3.582353855019652*^9, 3.582353967872458*^9, 
   3.583133041224899*^9, 3.5831332610926857`*^9, 3.5831333028071594`*^9, 
   3.5831333347872148`*^9, 3.58313532525811*^9, 3.5831380882433643`*^9, 
   3.5831382091913767`*^9, 3.5831466229802065`*^9, 3.5831501732350426`*^9, 
   3.583150224340733*^9, 3.583150272560417*^9, {3.587965184100661*^9, 
   3.587965204583497*^9}, 3.58807987359123*^9, 3.588079956817376*^9, 
   3.588083330141309*^9, 3.588083691827944*^9, 3.5883190716809916`*^9, 
   3.588319170163964*^9, 3.588325827420041*^9, 3.588325958694271*^9, 
   3.588326917082955*^9, 3.588327860448812*^9, 3.588327929603733*^9, 
   3.588328019584691*^9, 3.588328473951089*^9, 3.588328558097637*^9, 
   3.588329397504912*^9, {3.588329680941809*^9, 3.5883297044822516`*^9}, 
   3.588329912726015*^9, 3.61513082621686*^9, 3.6151310082920856`*^9, 
   3.619089166310088*^9, 3.619626215669158*^9, 3.6205425718985786`*^9, 
   3.646381710550969*^9, 3.679983969358206*^9, 3.679984668996687*^9, 
   3.697739184407181*^9, 3.6977392394992585`*^9, 3.715232895968338*^9, 
   3.7152337477146196`*^9, 3.727334899291646*^9, 3.727335239104045*^9, 
   3.7273353317214975`*^9, 3.727336144081936*^9, 3.7273362355011234`*^9, 
   3.727336466415086*^9, 3.7273367365999584`*^9, 3.7273370587986407`*^9, 
   3.727340515800863*^9, 3.727340624166091*^9, 3.727340740664285*^9, 
   3.727341333175574*^9, 3.727342073423877*^9, 3.727343587378785*^9, 
   3.7273436704393816`*^9, 3.7273437503492618`*^9, 3.727343858621587*^9, 
   3.727410646289556*^9, 3.728278716746658*^9, 3.728280994647394*^9, 
   3.728483765626748*^9, 3.728551304817994*^9, 3.728551798985386*^9, 
   3.728804569683327*^9, 3.7288046925873575`*^9, 3.728808861514694*^9, 
   3.777914015097559*^9, 3.777914086024008*^9, 3.791093803719097*^9, 
   3.7910939531928988`*^9, 3.820204748843738*^9, 3.820207207815752*^9, 
   3.820207298591127*^9, 3.8202073673566403`*^9, 3.8427624651933*^9, 
   3.844390006243442*^9, 3.8443900774515634`*^9, 3.844390675306779*^9, 
   3.844391080271755*^9, 3.8758915761838107`*^9, 3.8758919950813313`*^9, 
   3.921306833264393*^9, 3.9213069076069164`*^9, 3.921306950382389*^9, 
   3.958400337566803*^9},
 CellLabel->
  "During evaluation of \
In[506]:=",ExpressionUUID->"79c7bc82-c3ad-c244-8f48-a022c638c448"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[Lambda]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[Lambda]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.582347796528718*^9, 3.582353855019652*^9, 3.582353967872458*^9, 
   3.583133041224899*^9, 3.5831332610926857`*^9, 3.5831333028071594`*^9, 
   3.5831333347872148`*^9, 3.58313532525811*^9, 3.5831380882433643`*^9, 
   3.5831382091913767`*^9, 3.5831466229802065`*^9, 3.5831501732350426`*^9, 
   3.583150224340733*^9, 3.583150272560417*^9, {3.587965184100661*^9, 
   3.587965204583497*^9}, 3.58807987359123*^9, 3.588079956817376*^9, 
   3.588083330141309*^9, 3.588083691827944*^9, 3.5883190716809916`*^9, 
   3.588319170163964*^9, 3.588325827420041*^9, 3.588325958694271*^9, 
   3.588326917082955*^9, 3.588327860448812*^9, 3.588327929603733*^9, 
   3.588328019584691*^9, 3.588328473951089*^9, 3.588328558097637*^9, 
   3.588329397504912*^9, {3.588329680941809*^9, 3.5883297044822516`*^9}, 
   3.588329912726015*^9, 3.61513082621686*^9, 3.6151310082920856`*^9, 
   3.619089166310088*^9, 3.619626215669158*^9, 3.6205425718985786`*^9, 
   3.646381710550969*^9, 3.679983969358206*^9, 3.679984668996687*^9, 
   3.697739184407181*^9, 3.6977392394992585`*^9, 3.715232895968338*^9, 
   3.7152337477146196`*^9, 3.727334899291646*^9, 3.727335239104045*^9, 
   3.7273353317214975`*^9, 3.727336144081936*^9, 3.7273362355011234`*^9, 
   3.727336466415086*^9, 3.7273367365999584`*^9, 3.7273370587986407`*^9, 
   3.727340515800863*^9, 3.727340624166091*^9, 3.727340740664285*^9, 
   3.727341333175574*^9, 3.727342073423877*^9, 3.727343587378785*^9, 
   3.7273436704393816`*^9, 3.7273437503492618`*^9, 3.727343858621587*^9, 
   3.727410646289556*^9, 3.728278716746658*^9, 3.728280994647394*^9, 
   3.728483765626748*^9, 3.728551304817994*^9, 3.728551798985386*^9, 
   3.728804569683327*^9, 3.7288046925873575`*^9, 3.728808861514694*^9, 
   3.777914015097559*^9, 3.777914086024008*^9, 3.791093803719097*^9, 
   3.7910939531928988`*^9, 3.820204748843738*^9, 3.820207207815752*^9, 
   3.820207298591127*^9, 3.8202073673566403`*^9, 3.8427624651933*^9, 
   3.844390006243442*^9, 3.8443900774515634`*^9, 3.844390675306779*^9, 
   3.844391080271755*^9, 3.8758915761838107`*^9, 3.8758919950813313`*^9, 
   3.921306833264393*^9, 3.9213069076069164`*^9, 3.921306950382389*^9, 
   3.9584003375829163`*^9},
 CellLabel->
  "During evaluation of \
In[506]:=",ExpressionUUID->"cb8d1686-c61e-294e-a013-29c18123adca"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{
  3.582347796528718*^9, 3.582353855019652*^9, 3.582353967872458*^9, 
   3.5831330412404995`*^9, 3.5831332610926857`*^9, 3.5831333028071594`*^9, 
   3.5831333347872148`*^9, 3.5831353252737107`*^9, 3.5831380882433643`*^9, 
   3.583138209206976*^9, 3.5831466229802065`*^9, 3.5831501733598433`*^9, 
   3.583150224340733*^9, 3.5831502725760183`*^9, {3.587965184459461*^9, 
   3.587965204583497*^9}, 3.588079873606829*^9, 3.588079956817376*^9, 
   3.588083330141309*^9, 3.5880836918435435`*^9, 3.588319071696591*^9, 
   3.588319170163964*^9, 3.588325827420041*^9, 3.588325958694271*^9, 
   3.588326917082955*^9, 3.588327860448812*^9, 3.588327929603733*^9, 
   3.5883280196002913`*^9, 3.588328473951089*^9, 3.588328558113238*^9, 
   3.588329397520512*^9, {3.588329680957409*^9, 3.5883297044822516`*^9}, 
   3.588329912741616*^9, 3.6151308262268596`*^9, 3.6151310082920856`*^9, 
   3.619089166310088*^9, 3.619626215669158*^9, 3.6205425718985786`*^9, 
   3.646381710550969*^9, 3.679983969368205*^9, 3.679984669006687*^9, 
   3.697739184407181*^9, 3.6977392395092587`*^9, 3.715232895983317*^9, 
   3.7152337477307577`*^9, 3.727334899308959*^9, 3.727335239119651*^9, 
   3.7273353317436476`*^9, 3.727336144097563*^9, 3.727336235506667*^9, 
   3.727336466415086*^9, 3.7273367366155853`*^9, 3.7273370588142667`*^9, 
   3.727340515808023*^9, 3.727340624166091*^9, 3.727340740682928*^9, 
   3.727341333191202*^9, 3.727342073439503*^9, 3.727343587394599*^9, 
   3.7273436704550095`*^9, 3.727343750364888*^9, 3.727343858628254*^9, 
   3.727410646289556*^9, 3.7282787167622848`*^9, 3.728280994668674*^9, 
   3.7284837656423917`*^9, 3.728551304833597*^9, 3.728551798985386*^9, 
   3.7288045696903276`*^9, 3.728804692592358*^9, 3.728808861514694*^9, 
   3.7779140151131845`*^9, 3.777914086039626*^9, 3.791093803734742*^9, 
   3.7910939532085257`*^9, 3.820204748849732*^9, 3.820207207821741*^9, 
   3.820207298598109*^9, 3.8202073673656435`*^9, 3.842762465203303*^9, 
   3.844390006254441*^9, 3.844390077459569*^9, 3.8443906753157477`*^9, 
   3.8443910802797685`*^9, 3.8758915761967754`*^9, 3.8758919950903063`*^9, 
   3.921306833275364*^9, 3.921306907616867*^9, 3.9213069503923607`*^9, 
   3.9584003375829163`*^9},
 CellLabel->
  "Out[506]=",ExpressionUUID->"8e036ae7-9f7c-c44a-83ec-78d2dbac4f80"]
}, Open  ]],

Cell["Matrices can be typeset in different ways.", "Text",
 CellChangeTimes->{{3.820204009654864*^9, 3.820204030236835*^9}, 
   3.820204683965661*^9},ExpressionUUID->"f624c000-eb4b-4b86-9c43-\
eb4a6fb55efa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mat", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8202046889014573`*^9, 3.82020470719684*^9}},
 CellLabel->
  "In[507]:=",ExpressionUUID->"c0ae74d9-9233-4283-ac22-34721b4e6c18"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.820204748888628*^9, 3.8202072078596377`*^9, 
  3.820207298631002*^9, 3.820207367394566*^9, 3.842762465228213*^9, 
  3.84439000630029*^9, 3.844390077490485*^9, 3.844390675348673*^9, 
  3.844391080308657*^9, 3.8758915762276955`*^9, 3.875891995105266*^9, 
  3.921306833302292*^9, 3.9213069076427975`*^9, 3.921306950411312*^9, 
  3.9584003375990276`*^9},
 CellLabel->
  "Out[507]=",ExpressionUUID->"940d5272-9683-9540-91fb-55bec2c5ae0a"]
}, Open  ]],

Cell["The default is round parenthesis with an array construction.", "Text",
 CellChangeTimes->{{3.820204899749301*^9, 3.820204904863718*^9}, {
  3.820205021252951*^9, 
  3.8202050482464695`*^9}},ExpressionUUID->"5d588f32-830a-4e43-8f2d-\
e47fc7d06da3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tex", "[", "Mat", "]"}]], "Input",
 CellChangeTimes->{{3.82020505663953*^9, 3.820205060451205*^9}},
 CellLabel->
  "In[508]:=",ExpressionUUID->"458d7bda-284e-40f1-96a4-f6ce645c0d39"],

Cell[BoxData["\<\"\\\\left(\\\\begin{array}{ccc}\\n1 & 2 & 3\\\\\\\\\\n4 & 5 \
& 6\\n\\\\end{array}\\\\right)\"\>"], "Output",
 CellChangeTimes->{
  3.820205060937904*^9, {3.820205113912134*^9, 3.8202051269286547`*^9}, 
   3.820207207866625*^9, 3.8202072986659*^9, 3.8202073674264836`*^9, 
   3.842762465253172*^9, 3.8443900063312078`*^9, 3.8443900775213766`*^9, 
   3.8443906753755918`*^9, 3.844391080320652*^9, 3.875891576233677*^9, 
   3.875891995110253*^9, 3.921306833308277*^9, 3.9213069076667595`*^9, 
   3.921306950418293*^9, 3.9584003375990276`*^9},
 CellLabel->
  "Out[508]=",ExpressionUUID->"2709fb9a-82de-4345-bdeb-61b1ef9b2d37"]
}, Open  ]],

Cell["One can change to brackets with", "Text",
 CellChangeTimes->{{3.820205086924479*^9, 
  3.820205101759771*^9}},ExpressionUUID->"0fe22465-0571-4a1d-98cc-\
05c1b215cc46"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexMatrixParen", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<[\>\"", ",", "\"\<]\>\""}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.820205064773653*^9, 3.8202050844517965`*^9}},
 CellLabel->
  "In[509]:=",ExpressionUUID->"f457300d-d300-463d-9dd6-9a2cd0a40b2b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tex", "[", "Mat", "]"}]], "Input",
 CellLabel->
  "In[510]:=",ExpressionUUID->"ffa15e17-404a-4478-80a1-3adddcdb9c61"],

Cell[BoxData["\<\"\\\\left[\\\\begin{array}{ccc}\\n1 & 2 & 3\\\\\\\\\\n4 & 5 \
& 6\\n\\\\end{array}\\\\right]\"\>"], "Output",
 CellChangeTimes->{{3.820205108733885*^9, 3.820205129600134*^9}, 
   3.820207207907558*^9, 3.8202072986788993`*^9, 3.820207367461417*^9, 
   3.842762465288073*^9, 3.844390006371101*^9, 3.8443900775582776`*^9, 
   3.844390675414483*^9, 3.844391080358527*^9, 3.875891576261603*^9, 
   3.875891995126211*^9, 3.9213068333142605`*^9, 3.9213069076737404`*^9, 
   3.9213069504372425`*^9, 3.958400337614767*^9},
 CellLabel->
  "Out[510]=",ExpressionUUID->"992f5c70-0a78-334f-8ad8-20828440b37b"]
}, Open  ]],

Cell["\<\
By default TexMatrix is called internally. 
One can directly call it. An optional second argument tells which function \
should be used to typeset each element.\[LineSeparator]If you want advanced \
parenthesis treatment TexPrint can be used as the second argument.\
\>", "Text",
 CellChangeTimes->{{3.820205385060327*^9, 3.820205427045938*^9}, {
   3.820205487179433*^9, 3.820205610106671*^9}, 3.82020573590084*^9, {
   3.820205807138853*^9, 3.820205900109147*^9}, {3.8202059342595773`*^9, 
   3.820205934554788*^9}},ExpressionUUID->"d5c4ab45-1e03-4b09-9406-\
a2f2f72b4344"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexMatrix", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"4", "-", "a"}], ")"}], "2"}], "+", "b"}], ")"}], "3"}], 
      ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.820205770943308*^9, 3.820205789227409*^9}, 
   3.8202058625717525`*^9, {3.820205902875609*^9, 3.82020592117577*^9}},
 CellLabel->
  "In[511]:=",ExpressionUUID->"38aab7cd-e721-41f2-a586-af6e7f9d03d3"],

Cell[BoxData["\<\"\\\\left[\\\\begin{array}{ccc}\\n1 & 2 & 3\\\\\\\\\\n3 (2 \
(4 -  a) + b) & 5 & 6\\n\\\\end{array}\\\\right]\"\>"], "Output",
 CellChangeTimes->{{3.8202057712233057`*^9, 3.820205789626376*^9}, 
   3.820205862866964*^9, {3.820205909832241*^9, 3.820205936816759*^9}, 
   3.820207207945389*^9, 3.820207298711808*^9, 3.8202073674923353`*^9, 
   3.842762465309988*^9, 3.844390006401021*^9, 3.8443900775902205`*^9, 
   3.844390675444376*^9, 3.844391080388444*^9, 3.8758915762685595`*^9, 
   3.8758919951312013`*^9, 3.9213068333381977`*^9, 3.9213069076976776`*^9, 
   3.921306950453228*^9, 3.958400337614767*^9},
 CellLabel->
  "Out[511]=",ExpressionUUID->"06947027-e70f-1b44-b7fe-98605ab51523"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"4", "-", "a"}], ")"}], "2"}], "+", "b"}], ")"}], "3"}], 
       ",", "5", ",", "6"}], "}"}]}], "}"}], ",", "TexPrint"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.820205508765374*^9, 3.8202055116668763`*^9}, {
   3.820205631614756*^9, 3.820205636923741*^9}, {3.820205753092055*^9, 
   3.8202057608699875`*^9}, 3.820205797058683*^9},
 CellLabel->
  "In[512]:=",ExpressionUUID->"f4e3edfb-8777-42ce-8822-1faf7f54b014"],

Cell[BoxData["\<\"\\\\left[\\\\begin{array}{ccc}\\n1 & 2 & 3\\\\\\\\\\n3 \
\\\\bigl(2 (4 - a) + b\\\\bigr) & 5 & 6\\n\\\\end{array}\\\\right]\"\>"], \
"Output",
 CellChangeTimes->{
  3.8202055128257413`*^9, 3.8202056385072*^9, {3.820205761241257*^9, 
   3.82020579773288*^9}, 3.820205863544538*^9, 3.820205937568055*^9, 
   3.8202072079802847`*^9, 3.8202072987636986`*^9, 3.820207367524249*^9, 
   3.8427624653329268`*^9, 3.844390006411022*^9, 3.844390077599195*^9, 
   3.84439067547632*^9, 3.8443910804163966`*^9, 3.875891576295515*^9, 
   3.875891995145163*^9, 3.921306833344181*^9, 3.9213069077046566`*^9, 
   3.9213069504691563`*^9, 3.9584003376406536`*^9},
 CellLabel->
  "Out[512]=",ExpressionUUID->"869caa05-168a-024e-b81b-77f0ec2e737e"]
}, Open  ]],

Cell["\<\
Systems of equations are often written in matrix form with a line between \
left and right hand side. The number of right hand sides can be specified \
with a third argument.\
\>", "Text",
 CellChangeTimes->{{3.820205980070481*^9, 
  3.820206063514825*^9}},ExpressionUUID->"ffd66583-8c9a-4280-9425-\
6c2636539168"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexMatrix", "[", 
  RowBox[{"Mat", ",", "Tex", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.8202054356943393`*^9, 3.8202054742118645`*^9}},
 CellLabel->
  "In[513]:=",ExpressionUUID->"c49f3039-eef1-434d-847b-112ecd03d01c"],

Cell[BoxData["\<\"\\\\left[\\\\begin{array}{cc|c}\\n1 & 2 & 3\\\\\\\\\\n4 & 5 \
& 6\\n\\\\end{array}\\\\right]\"\>"], "Output",
 CellChangeTimes->{3.820204890190976*^9, 3.820205435964617*^9, 
  3.820206067159814*^9, 3.8202072079892607`*^9, 3.8202072987982683`*^9, 
  3.820207367534221*^9, 3.842762465357887*^9, 3.8443900064409146`*^9, 
  3.84439007763111*^9, 3.844390675508233*^9, 3.844391080428366*^9, 
  3.875891576301472*^9, 3.875891995159123*^9, 3.9213068333681164`*^9, 
  3.9213069077285957`*^9, 3.921306950485115*^9, 3.9584003376464653`*^9},
 CellLabel->
  "Out[513]=",ExpressionUUID->"24acaecd-acd8-c74f-b933-0b210a8b6f0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", "Tex",
    ",", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.8202060802269945`*^9, 3.820206103890888*^9}},
 CellLabel->
  "In[514]:=",ExpressionUUID->"3d887a85-aa96-4131-ba2a-bc7ffde4750e"],

Cell[BoxData["\<\"\\\\left[\\\\begin{array}{cc|cc}\\n1 & 2 & 1 & \
0\\\\\\\\\\n3 & 4 & 0 & 1\\n\\\\end{array}\\\\right]\"\>"], "Output",
 CellChangeTimes->{3.820206104204117*^9, 3.820207208024237*^9, 
  3.8202072988341784`*^9, 3.820207367564145*^9, 3.842762465380828*^9, 
  3.844390006469864*^9, 3.8443900776600046`*^9, 3.844390675517213*^9, 
  3.844391080461249*^9, 3.875891576324411*^9, 3.875891995172086*^9, 
  3.9213068333741016`*^9, 3.9213069077335815`*^9, 3.921306950501072*^9, 
  3.9584003376464653`*^9},
 CellLabel->
  "Out[514]=",ExpressionUUID->"49441c09-9854-f740-8e98-dbb25ae2ff6d"]
}, Open  ]],

Cell["\<\
As an alternative to the {array} construction, one can also use the {pmatrix} \
or {bmatrix} construction, or {vmatrix} for determinants.\
\>", "Text",
 CellChangeTimes->{{3.82020672919524*^9, 
  3.8202068224505477`*^9}},ExpressionUUID->"a39cdd9b-a86c-4690-9ab5-\
7bdc8956fb67"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"TexPMatrix", "[", "Mat", "]"}], "\[IndentingNewLine]", 
 RowBox[{"TexBMatrix", "[", "Mat", "]"}], "\[IndentingNewLine]", 
 RowBox[{"TexDet", "[", "Mat", "]"}]}], "Input",
 CellChangeTimes->{{3.820206554172312*^9, 3.8202065714382725`*^9}},
 CellLabel->
  "In[515]:=",ExpressionUUID->"8c4cf33f-3d87-4bf3-86b9-ac662de912dc"],

Cell[BoxData["\<\"\\\\begin{pmatrix}\\n1 & 2 & 3\\\\\\\\\\n4 & 5 & \
6\\n\\\\end{pmatrix}\"\>"], "Output",
 CellChangeTimes->{3.82020720803217*^9, 3.820207298869051*^9, 
  3.820207367597028*^9, 3.842762465404762*^9, 3.844390006501752*^9, 
  3.844390077689924*^9, 3.844390675548126*^9, 3.844391080489174*^9, 
  3.875891576331419*^9, 3.875891995178071*^9, 3.921306833396042*^9, 
  3.921306907758486*^9, 3.9213069505160313`*^9, 3.958400337662113*^9},
 CellLabel->
  "Out[515]=",ExpressionUUID->"11044c1e-9cc5-684f-ba43-e9b9a535bce6"],

Cell[BoxData["\<\"\\\\begin{bmatrix}\\n1 & 2 & 3\\\\\\\\\\n4 & 5 & \
6\\n\\\\end{bmatrix}\"\>"], "Output",
 CellChangeTimes->{3.82020720803217*^9, 3.820207298869051*^9, 
  3.820207367597028*^9, 3.842762465404762*^9, 3.844390006501752*^9, 
  3.844390077689924*^9, 3.844390675548126*^9, 3.844391080489174*^9, 
  3.875891576331419*^9, 3.875891995178071*^9, 3.921306833396042*^9, 
  3.921306907758486*^9, 3.9213069505160313`*^9, 3.958400337662113*^9},
 CellLabel->
  "Out[516]=",ExpressionUUID->"f51a803c-77d1-6b49-ba31-a0581932bbf3"],

Cell[BoxData["\<\"\\\\begin{vmatrix}\\n1 & 2 & 3\\\\\\\\\\n4 & 5 & \
6\\n\\\\end{vmatrix}\"\>"], "Output",
 CellChangeTimes->{3.82020720803217*^9, 3.820207298869051*^9, 
  3.820207367597028*^9, 3.842762465404762*^9, 3.844390006501752*^9, 
  3.844390077689924*^9, 3.844390675548126*^9, 3.844391080489174*^9, 
  3.875891576331419*^9, 3.875891995178071*^9, 3.921306833396042*^9, 
  3.921306907758486*^9, 3.9213069505160313`*^9, 3.9584003376778126`*^9},
 CellLabel->
  "Out[517]=",ExpressionUUID->"63d135df-2423-2448-bdb1-c1862e5285cb"]
}, Open  ]],

Cell["\<\
The default can be changed to use one of these constructions instead .\
\>", "Text",
 CellChangeTimes->{{3.8202066581478276`*^9, 
  3.820206688411023*^9}},ExpressionUUID->"3bf3f7bf-e748-4769-a3c3-\
449d70b7eb7a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"M_", "?", "MatrixQ"}], "]"}], " ", ":=", " ", 
   RowBox[{"TexPMatrix", "[", "M", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{3.820206610981583*^9},
 CellLabel->
  "In[518]:=",ExpressionUUID->"ed7ede59-c6e7-4615-bea8-884274f39735"],

Cell["Reset the default setup.", "Text",
 CellChangeTimes->{{3.820206624651898*^9, 3.820206632955121*^9}, {
  3.8202066967004194`*^9, 
  3.82020671268173*^9}},ExpressionUUID->"f07c497c-54fb-4a87-bfaa-\
1c146159ed6f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tex", "[", 
    RowBox[{"M_", "?", "MatrixQ"}], "]"}], " ", ":=", " ", 
   RowBox[{"TexMatrix", "[", "M", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$TexMatrixParen", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<(\>\"", ",", "\"\<)\>\""}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8202066364416904`*^9, 3.820206650966078*^9}},
 CellLabel->
  "In[519]:=",ExpressionUUID->"e94e63f5-67af-41e9-9d5f-235382b157cc"],

Cell["\<\
One can always change or define the Tex output of any expression by telling \
how Tex should act on the expression.
For instance:\
\>", "Text",
 CellChangeTimes->{{3.820206857107177*^9, 3.820206918091815*^9}, {
  3.8202069514095535`*^9, 3.8202070066446714`*^9}, {3.820207067970292*^9, 
  3.820207091659635*^9}},ExpressionUUID->"1699582e-e5bf-4e13-8638-\
d22140dd5150"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tex", "[", 
   RowBox[{"MyOperator", "[", "expr_", "]"}], "]"}], "^:=", 
  RowBox[{"\"\<\\\\mytexoperator{\>\"", "<>", 
   RowBox[{"Tex", "[", "expr", "]"}], "<>", "\"\<}\>\""}]}]], "Input",
 CellChangeTimes->{{3.820207011292549*^9, 3.820207097858098*^9}},
 CellLabel->
  "In[521]:=",ExpressionUUID->"45d56c09-1a59-48f8-a34e-d89b3f2f57a4"],

Cell["\<\
Don\[CloseCurlyQuote]t forget to add the tex definition of \\myoperator to \
$TexInitLatexExtraCode.\
\>", "Text",
 CellChangeTimes->{{3.820207105455208*^9, 
  3.820207185363698*^9}},ExpressionUUID->"fed98989-fc69-463f-929f-\
4c07a22b9be8"],

Cell["TexAct interacts well with SymManipulator.", "Text",
 CellChangeTimes->{{3.820204009654864*^9, 3.820204030236835*^9}, {
  3.820204663919325*^9, 
  3.820204682123644*^9}},ExpressionUUID->"ef00231c-efcf-4f13-831c-\
dcc584179a95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`SymManipulator`"}]], "Input",
 CellChangeTimes->{{3.545110575141037*^9, 3.5451106065594916`*^9}},
 CellLabel->
  "In[522]:=",ExpressionUUID->"5923ae44-e29f-4388-8888-8e1646cb68ef"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.582347796544318*^9, 3.582353855035252*^9, 3.582353967888057*^9, 
   3.5831330412561*^9, 3.583133261155085*^9, 3.583133302822758*^9, 
   3.583133334802815*^9, 3.583135325289311*^9, 3.583138088274564*^9, 
   3.583138209222576*^9, 3.583146622995807*^9, 3.5831501733754435`*^9, 
   3.583150224356333*^9, 3.5831502725916185`*^9, {3.587965184521861*^9, 
   3.587965204614697*^9}, 3.58807987362243*^9, 3.5880799568329773`*^9, 
   3.588083330188108*^9, 3.588083692732745*^9, 3.588319071712191*^9, 
   3.588319170195164*^9, 3.588325827435641*^9, 3.588325958709872*^9, 
   3.5883269170985546`*^9, 3.5883278604644127`*^9, 3.588327929619334*^9, 
   3.5883280196158915`*^9, 3.588328473966689*^9, 3.588328558128837*^9, 
   3.588329397536112*^9, {3.588329680973009*^9, 3.588329704497851*^9}, 
   3.588329912788416*^9, 3.6151308262268596`*^9, 3.615131008307685*^9, 
   3.619089166320088*^9, 3.619626215679158*^9, 3.620542571908579*^9, 
   3.646381710570969*^9, 3.679983969378204*^9, 3.6799846690166874`*^9, 
   3.697739184417181*^9, 3.6977392395192585`*^9, 3.715232896067165*^9, 
   3.715233747880127*^9, 3.727334899382243*^9, 3.727335239141827*^9, 
   3.727335331806181*^9, 3.7273361441374097`*^9, 3.727336235584829*^9, 
   3.7273364664601536`*^9, 3.727336736631211*^9, 3.727337058836443*^9, 
   3.727340515824005*^9, 3.727340624197387*^9, 3.7273407407110596`*^9, 
   3.7273413332068653`*^9, 3.727342073489397*^9, 3.727343587425861*^9, 
   3.7273436705018888`*^9, 3.727343750395143*^9, 3.72734385865885*^9, 
   3.727410646305289*^9, 3.728278716829423*^9, 3.7282809946751947`*^9, 
   3.728483765657995*^9, 3.72855130484922*^9, 3.7285517990010147`*^9, 
   3.72880456972733*^9, 3.728804692605357*^9, 3.728808861592928*^9, 
   3.7779140152069745`*^9, 3.777914086070878*^9, 3.7910938038193555`*^9, 
   3.791093953330948*^9, 3.820207208133902*^9, 3.82020729896038*^9, 
   3.820207367645943*^9, 3.84276246548754*^9, 3.844390006559597*^9, 
   3.844390077749795*^9, 3.844390675597993*^9, 3.844391080550011*^9, 
   3.875891576387274*^9, 3.875891995208962*^9, 3.9213068334568806`*^9, 
   3.921306907799406*^9, 3.921306950548971*^9, 3.958400337757351*^9},
 CellLabel->
  "During evaluation of \
In[522]:=",ExpressionUUID->"8bef30a8-2075-b241-a1c5-f6c89a83a351"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SymManipulator`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.9.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2024", ",", "4", ",", "30"}], "}"}]}],
  SequenceForm[
  "Package xAct`SymManipulator`  version ", "0.9.6", ", ", {2024, 4, 30}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.582347796544318*^9, 3.582353855035252*^9, 3.582353967888057*^9, 
   3.5831330412561*^9, 3.583133261155085*^9, 3.583133302822758*^9, 
   3.583133334802815*^9, 3.583135325289311*^9, 3.583138088274564*^9, 
   3.583138209222576*^9, 3.583146622995807*^9, 3.5831501733754435`*^9, 
   3.583150224356333*^9, 3.5831502725916185`*^9, {3.587965184521861*^9, 
   3.587965204614697*^9}, 3.58807987362243*^9, 3.5880799568329773`*^9, 
   3.588083330188108*^9, 3.588083692732745*^9, 3.588319071712191*^9, 
   3.588319170195164*^9, 3.588325827435641*^9, 3.588325958709872*^9, 
   3.5883269170985546`*^9, 3.5883278604644127`*^9, 3.588327929619334*^9, 
   3.5883280196158915`*^9, 3.588328473966689*^9, 3.588328558128837*^9, 
   3.588329397536112*^9, {3.588329680973009*^9, 3.588329704497851*^9}, 
   3.588329912788416*^9, 3.6151308262268596`*^9, 3.615131008307685*^9, 
   3.619089166320088*^9, 3.619626215679158*^9, 3.620542571908579*^9, 
   3.646381710570969*^9, 3.679983969378204*^9, 3.6799846690166874`*^9, 
   3.697739184417181*^9, 3.6977392395192585`*^9, 3.715232896067165*^9, 
   3.715233747880127*^9, 3.727334899382243*^9, 3.727335239141827*^9, 
   3.727335331806181*^9, 3.7273361441374097`*^9, 3.727336235584829*^9, 
   3.7273364664601536`*^9, 3.727336736631211*^9, 3.727337058836443*^9, 
   3.727340515824005*^9, 3.727340624197387*^9, 3.7273407407110596`*^9, 
   3.7273413332068653`*^9, 3.727342073489397*^9, 3.727343587425861*^9, 
   3.7273436705018888`*^9, 3.727343750395143*^9, 3.72734385865885*^9, 
   3.727410646305289*^9, 3.728278716829423*^9, 3.7282809946751947`*^9, 
   3.728483765657995*^9, 3.72855130484922*^9, 3.7285517990010147`*^9, 
   3.72880456972733*^9, 3.728804692605357*^9, 3.728808861592928*^9, 
   3.7779140152069745`*^9, 3.777914086070878*^9, 3.7910938038193555`*^9, 
   3.791093953330948*^9, 3.820207208133902*^9, 3.82020729896038*^9, 
   3.820207367645943*^9, 3.84276246548754*^9, 3.844390006559597*^9, 
   3.844390077749795*^9, 3.844390675597993*^9, 3.844391080550011*^9, 
   3.875891576387274*^9, 3.875891995208962*^9, 3.9213068334568806`*^9, 
   3.921306907799406*^9, 3.921306950548971*^9, 3.9584003377775383`*^9},
 CellLabel->
  "During evaluation of \
In[522]:=",ExpressionUUID->"e5e64be6-0b3d-1c42-bf9f-d9c80d517694"],

Cell[BoxData["\<\"CopyRight (C) 2011-2021, Thomas B\[ADoubleDot]ckdahl, under \
the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.582347796544318*^9, 3.582353855035252*^9, 3.582353967888057*^9, 
   3.5831330412561*^9, 3.583133261155085*^9, 3.583133302822758*^9, 
   3.583133334802815*^9, 3.583135325289311*^9, 3.583138088274564*^9, 
   3.583138209222576*^9, 3.583146622995807*^9, 3.5831501733754435`*^9, 
   3.583150224356333*^9, 3.5831502725916185`*^9, {3.587965184521861*^9, 
   3.587965204614697*^9}, 3.58807987362243*^9, 3.5880799568329773`*^9, 
   3.588083330188108*^9, 3.588083692732745*^9, 3.588319071712191*^9, 
   3.588319170195164*^9, 3.588325827435641*^9, 3.588325958709872*^9, 
   3.5883269170985546`*^9, 3.5883278604644127`*^9, 3.588327929619334*^9, 
   3.5883280196158915`*^9, 3.588328473966689*^9, 3.588328558128837*^9, 
   3.588329397536112*^9, {3.588329680973009*^9, 3.588329704497851*^9}, 
   3.588329912788416*^9, 3.6151308262268596`*^9, 3.615131008307685*^9, 
   3.619089166320088*^9, 3.619626215679158*^9, 3.620542571908579*^9, 
   3.646381710570969*^9, 3.679983969378204*^9, 3.6799846690166874`*^9, 
   3.697739184417181*^9, 3.6977392395192585`*^9, 3.715232896067165*^9, 
   3.715233747880127*^9, 3.727334899382243*^9, 3.727335239141827*^9, 
   3.727335331806181*^9, 3.7273361441374097`*^9, 3.727336235584829*^9, 
   3.7273364664601536`*^9, 3.727336736631211*^9, 3.727337058836443*^9, 
   3.727340515824005*^9, 3.727340624197387*^9, 3.7273407407110596`*^9, 
   3.7273413332068653`*^9, 3.727342073489397*^9, 3.727343587425861*^9, 
   3.7273436705018888`*^9, 3.727343750395143*^9, 3.72734385865885*^9, 
   3.727410646305289*^9, 3.728278716829423*^9, 3.7282809946751947`*^9, 
   3.728483765657995*^9, 3.72855130484922*^9, 3.7285517990010147`*^9, 
   3.72880456972733*^9, 3.728804692605357*^9, 3.728808861592928*^9, 
   3.7779140152069745`*^9, 3.777914086070878*^9, 3.7910938038193555`*^9, 
   3.791093953330948*^9, 3.820207208133902*^9, 3.82020729896038*^9, 
   3.820207367645943*^9, 3.84276246548754*^9, 3.844390006559597*^9, 
   3.844390077749795*^9, 3.844390675597993*^9, 3.844391080550011*^9, 
   3.875891576387274*^9, 3.875891995208962*^9, 3.9213068334568806`*^9, 
   3.921306907799406*^9, 3.921306950548971*^9, 3.9584003377775383`*^9},
 CellLabel->
  "During evaluation of \
In[522]:=",ExpressionUUID->"c9976a32-2dfe-9b47-bd1f-bd9386685aab"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.582347796544318*^9, 3.582353855035252*^9, 3.582353967888057*^9, 
   3.5831330412561*^9, 3.583133261155085*^9, 3.583133302822758*^9, 
   3.583133334802815*^9, 3.583135325289311*^9, 3.583138088274564*^9, 
   3.583138209222576*^9, 3.583146622995807*^9, 3.5831501733754435`*^9, 
   3.583150224356333*^9, 3.5831502725916185`*^9, {3.587965184521861*^9, 
   3.587965204614697*^9}, 3.58807987362243*^9, 3.5880799568329773`*^9, 
   3.588083330188108*^9, 3.588083692732745*^9, 3.588319071712191*^9, 
   3.588319170195164*^9, 3.588325827435641*^9, 3.588325958709872*^9, 
   3.5883269170985546`*^9, 3.5883278604644127`*^9, 3.588327929619334*^9, 
   3.5883280196158915`*^9, 3.588328473966689*^9, 3.588328558128837*^9, 
   3.588329397536112*^9, {3.588329680973009*^9, 3.588329704497851*^9}, 
   3.588329912788416*^9, 3.6151308262268596`*^9, 3.615131008307685*^9, 
   3.619089166320088*^9, 3.619626215679158*^9, 3.620542571908579*^9, 
   3.646381710570969*^9, 3.679983969378204*^9, 3.6799846690166874`*^9, 
   3.697739184417181*^9, 3.6977392395192585`*^9, 3.715232896067165*^9, 
   3.715233747880127*^9, 3.727334899382243*^9, 3.727335239141827*^9, 
   3.727335331806181*^9, 3.7273361441374097`*^9, 3.727336235584829*^9, 
   3.7273364664601536`*^9, 3.727336736631211*^9, 3.727337058836443*^9, 
   3.727340515824005*^9, 3.727340624197387*^9, 3.7273407407110596`*^9, 
   3.7273413332068653`*^9, 3.727342073489397*^9, 3.727343587425861*^9, 
   3.7273436705018888`*^9, 3.727343750395143*^9, 3.72734385865885*^9, 
   3.727410646305289*^9, 3.728278716829423*^9, 3.7282809946751947`*^9, 
   3.728483765657995*^9, 3.72855130484922*^9, 3.7285517990010147`*^9, 
   3.72880456972733*^9, 3.728804692605357*^9, 3.728808861592928*^9, 
   3.7779140152069745`*^9, 3.777914086070878*^9, 3.7910938038193555`*^9, 
   3.791093953330948*^9, 3.820207208133902*^9, 3.82020729896038*^9, 
   3.820207367645943*^9, 3.84276246548754*^9, 3.844390006559597*^9, 
   3.844390077749795*^9, 3.844390675597993*^9, 3.844391080550011*^9, 
   3.875891576387274*^9, 3.875891995208962*^9, 3.9213068334568806`*^9, 
   3.921306907799406*^9, 3.921306950548971*^9, 3.9584003377893944`*^9},
 CellLabel->
  "During evaluation of \
In[522]:=",ExpressionUUID->"2ab0b558-9ec9-9543-8719-38503386903e"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{
  3.582347796544318*^9, 3.582353855035252*^9, 3.582353967888057*^9, 
   3.5831330412561*^9, 3.583133261155085*^9, 3.583133302822758*^9, 
   3.583133334802815*^9, 3.583135325289311*^9, 3.583138088274564*^9, 
   3.583138209222576*^9, 3.583146622995807*^9, 3.5831501733754435`*^9, 
   3.583150224356333*^9, 3.5831502725916185`*^9, {3.587965184521861*^9, 
   3.587965204614697*^9}, 3.58807987362243*^9, 3.5880799568329773`*^9, 
   3.588083330188108*^9, 3.588083692732745*^9, 3.588319071712191*^9, 
   3.588319170195164*^9, 3.588325827435641*^9, 3.588325958709872*^9, 
   3.5883269170985546`*^9, 3.5883278604644127`*^9, 3.588327929619334*^9, 
   3.5883280196158915`*^9, 3.588328473966689*^9, 3.588328558128837*^9, 
   3.588329397536112*^9, {3.588329680973009*^9, 3.588329704497851*^9}, 
   3.588329912788416*^9, 3.6151308262268596`*^9, 3.615131008307685*^9, 
   3.619089166320088*^9, 3.619626215679158*^9, 3.620542571908579*^9, 
   3.646381710570969*^9, 3.679983969378204*^9, 3.6799846690166874`*^9, 
   3.697739184417181*^9, 3.6977392395192585`*^9, 3.715232896067165*^9, 
   3.715233747880127*^9, 3.727334899382243*^9, 3.727335239141827*^9, 
   3.727335331806181*^9, 3.7273361441374097`*^9, 3.727336235584829*^9, 
   3.7273364664601536`*^9, 3.727336736631211*^9, 3.727337058836443*^9, 
   3.727340515824005*^9, 3.727340624197387*^9, 3.7273407407110596`*^9, 
   3.7273413332068653`*^9, 3.727342073489397*^9, 3.727343587425861*^9, 
   3.7273436705018888`*^9, 3.727343750395143*^9, 3.72734385865885*^9, 
   3.727410646305289*^9, 3.728278716829423*^9, 3.7282809946751947`*^9, 
   3.728483765657995*^9, 3.72855130484922*^9, 3.7285517990010147`*^9, 
   3.72880456972733*^9, 3.728804692605357*^9, 3.728808861592928*^9, 
   3.7779140152069745`*^9, 3.777914086070878*^9, 3.7910938038193555`*^9, 
   3.791093953330948*^9, 3.820207208133902*^9, 3.82020729896038*^9, 
   3.820207367645943*^9, 3.84276246548754*^9, 3.844390006559597*^9, 
   3.844390077749795*^9, 3.844390675597993*^9, 3.844391080550011*^9, 
   3.875891576387274*^9, 3.875891995208962*^9, 3.9213068334568806`*^9, 
   3.921306907799406*^9, 3.921306950548971*^9, 3.9584003377893944`*^9},
 CellLabel->
  "During evaluation of \
In[522]:=",ExpressionUUID->"99b71458-1458-5c4d-8825-4229750da646"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.582347796544318*^9, 3.582353855035252*^9, 3.582353967888057*^9, 
   3.5831330412561*^9, 3.583133261155085*^9, 3.583133302822758*^9, 
   3.583133334802815*^9, 3.583135325289311*^9, 3.583138088274564*^9, 
   3.583138209222576*^9, 3.583146622995807*^9, 3.5831501733754435`*^9, 
   3.583150224356333*^9, 3.5831502725916185`*^9, {3.587965184521861*^9, 
   3.587965204614697*^9}, 3.58807987362243*^9, 3.5880799568329773`*^9, 
   3.588083330188108*^9, 3.588083692732745*^9, 3.588319071712191*^9, 
   3.588319170195164*^9, 3.588325827435641*^9, 3.588325958709872*^9, 
   3.5883269170985546`*^9, 3.5883278604644127`*^9, 3.588327929619334*^9, 
   3.5883280196158915`*^9, 3.588328473966689*^9, 3.588328558128837*^9, 
   3.588329397536112*^9, {3.588329680973009*^9, 3.588329704497851*^9}, 
   3.588329912788416*^9, 3.6151308262268596`*^9, 3.615131008307685*^9, 
   3.619089166320088*^9, 3.619626215679158*^9, 3.620542571908579*^9, 
   3.646381710570969*^9, 3.679983969378204*^9, 3.6799846690166874`*^9, 
   3.697739184417181*^9, 3.6977392395192585`*^9, 3.715232896067165*^9, 
   3.715233747880127*^9, 3.727334899382243*^9, 3.727335239141827*^9, 
   3.727335331806181*^9, 3.7273361441374097`*^9, 3.727336235584829*^9, 
   3.7273364664601536`*^9, 3.727336736631211*^9, 3.727337058836443*^9, 
   3.727340515824005*^9, 3.727340624197387*^9, 3.7273407407110596`*^9, 
   3.7273413332068653`*^9, 3.727342073489397*^9, 3.727343587425861*^9, 
   3.7273436705018888`*^9, 3.727343750395143*^9, 3.72734385865885*^9, 
   3.727410646305289*^9, 3.728278716829423*^9, 3.7282809946751947`*^9, 
   3.728483765657995*^9, 3.72855130484922*^9, 3.7285517990010147`*^9, 
   3.72880456972733*^9, 3.728804692605357*^9, 3.728808861592928*^9, 
   3.7779140152069745`*^9, 3.777914086070878*^9, 3.7910938038193555`*^9, 
   3.791093953330948*^9, 3.820207208133902*^9, 3.82020729896038*^9, 
   3.820207367645943*^9, 3.84276246548754*^9, 3.844390006559597*^9, 
   3.844390077749795*^9, 3.844390675597993*^9, 3.844391080550011*^9, 
   3.875891576387274*^9, 3.875891995208962*^9, 3.9213068334568806`*^9, 
   3.921306907799406*^9, 3.921306950548971*^9, 3.9584003377893944`*^9},
 CellLabel->
  "During evaluation of \
In[522]:=",ExpressionUUID->"ba7bd577-d2bb-224c-bd5b-741a9a16b1b9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T4", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<T\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.545064970589284*^9, 3.545064989699318*^9}, {
  3.5451107209700933`*^9, 3.545110726352103*^9}},
 CellLabel->
  "In[523]:=",ExpressionUUID->"b6ee0839-2597-462a-930b-16cd3fb3e58b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T4", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T4[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAWKDeW5Hg4++dnTrev4CRIfVV38B0XOk2aNCgPQbg5JU
EP0hKLAJRKtHiC8B0Q2VcWdAtAl7XU0YkH7VwtkFopeVzJwBop0O7n0Eoq+t
NrQPB9ICYYV/QPSxA5fYIoB0XdwFARC92T1CDkT7nDqzqwJIr3acO13h+GvH
9qSILYpAeo3z9m0tQJrZSm7jUiBtuufpOxDtIGkZrXjitSNr9NQsEF3nv7VY
GUibzX85+YzqG8c3R47PAdEiH+pZP9i9cZx+RlcCRL86wdpbXvbG8cnehBkg
uuL5twUgOi/Z8E7NwjeOESpX+qYveeP44/zO6SC6Lqz0EYjuKxYWnQGkd/rx
6a998MZxQ2dGMoj2mWkwy8f8rWPL9OrFIFpgzuUVIDohzmoVT91bRwA1iLu1

  "],
 CellLabel->
  "During evaluation of \
In[523]:=",ExpressionUUID->"778cf7c4-8bf6-7b49-b4cf-038f38fcdba3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"\[CapitalSigma]2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<\[CapitalSigma]\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.545064970589284*^9, 3.545064989699318*^9}, {
  3.545110131281456*^9, 3.545110135789864*^9}, {3.5451107284113064`*^9, 
  3.545110733044514*^9}, {3.582282687352809*^9, 3.582282694638022*^9}},
 CellLabel->
  "In[524]:=",ExpressionUUID->"e8580a22-4b4d-46ca-a0c1-7f1491e02261"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[CapitalSigma]2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[CapitalSigma]2[-$CellContext`a, -$CellContext`b], ". ", ""],
  
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAeKonYlHg4++dvyz//kLEJ1UX/MFRK+azR4VAqRNNpak
guifQUFNILqeU2IJiA74GXcGRIew19eEAekLLVxdIPpNyawZIDrAcd8jED1r
tZF9OJCOCiv6A6J7D1xmiwDSZfcuCIDoulMRciD6/a0zuyqA9MuDc6crHH/t
uGRHxBZFIB1yZPu2FiDNsUtu41KQ+Men70D0hGrLaMUTrx1ddk7PAtELzm8t
VgbS5fNfTT6j+sbx0JETc0D0rQ+NrB/s3jhuOqMvAaJVzrH1lpe9cXS/kzgD
RPNpfl8AooPVje7ULATqS7raN33JG0fus7umg+hW77JHIPpagYjoDCA9RYhf
f+2DN44KXzKSQXRPquEsH/O3jjHBNYtB9Am5KytANIuv9SqeureOAFSswJw=

  "],
 CellLabel->
  "During evaluation of \
In[524]:=",ExpressionUUID->"ae8098c2-cb99-854d-8e63-089e06562a76"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImposeSym", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalSigma]2", "[", 
     RowBox[{"d", ",", 
      RowBox[{"-", "f"}]}], "]"}], 
    RowBox[{"T4", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "g"}], "]"}]}], ",", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "f"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "d", ",", "g"}], "]"}], ",", 
   RowBox[{"JoinSGS", "[", 
    RowBox[{
     RowBox[{"Symmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Antisymmetric", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[525]:=",ExpressionUUID->"98c16c9c-0d34-4925-8867-6d739390065f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       UnderscriptBox["Sym", 
        StyleBox[
         RowBox[{
          RowBox[{"(", "36", ")"}], "[", "45", "]"}],
         FontSize->Tiny]], "[", "T", "\[CapitalSigma]", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", "g", "d", " "},
         {"c", "a", "b", " ", " ", "f"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SymManipulator`SymH[{$CellContext`T4, $CellContext`\[CapitalSigma]2}, 
   xAct`xPerm`StrongGenSet[{3, 4, 5, 6}, 
    xAct`xPerm`GenSet[-xAct`xPerm`Cycles[{4, 5}], 
     xAct`xPerm`Cycles[{3, 6}]]], 
   "(36)[45]"][-$CellContext`c, -$CellContext`a, -$CellContext`b, \
$CellContext`g, $CellContext`d, -$CellContext`f],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.582347796622319*^9, 3.582353855113252*^9, 3.582353967950458*^9, 
   3.5831330413184996`*^9, 3.583133261233085*^9, 3.5831333029007597`*^9, 
   3.583133334865215*^9, 3.583135325351711*^9, 3.5831380883369646`*^9, 
   3.583138209300576*^9, 3.5831466230426064`*^9, 3.5831501734378433`*^9, 
   3.5831502244187326`*^9, 3.5831502726540184`*^9, {3.5879651862534647`*^9, 
   3.587965204677097*^9}, 3.588079873684829*^9, 3.588079956879776*^9, 
   3.588083330312908*^9, 3.588083693419146*^9, 3.588319071805791*^9, 
   3.588319170288764*^9, 3.588325827498041*^9, 3.588325958756672*^9, 
   3.588326917160955*^9, 3.588327860526812*^9, 3.588327929712934*^9, 
   3.588328019662691*^9, 3.588328474029089*^9, 3.5883285581756377`*^9, 
   3.588329397614112*^9, {3.5883296811446095`*^9, 3.588329704560251*^9}, 
   3.588329912850816*^9, 3.61513082629686*^9, 3.615131008370085*^9, 
   3.619089166390088*^9, 3.619626215759158*^9, 3.6205425719785786`*^9, 
   3.6463817106409698`*^9, 3.679983969478196*^9, 3.6799846691266885`*^9, 
   3.697739184517181*^9, 3.697739239609259*^9, 3.715232896319101*^9, 
   3.715233748115182*^9, 3.72733489954537*^9, 3.7273349564711547`*^9, 
   3.727335200022626*^9, 3.727335239289067*^9, 3.7273353319752*^9, 
   3.727336144284627*^9, 3.7273362357383018`*^9, 3.72733646662587*^9, 
   3.7273367368140783`*^9, 3.727337059036955*^9, 3.727340516006939*^9, 
   3.727340624366492*^9, 3.727340740858005*^9, 3.7273413343446407`*^9, 
   3.727342073647997*^9, 3.727343587631012*^9, 3.727343670655062*^9, 
   3.7273437505961537`*^9, 3.7273438588216314`*^9, 3.727410646448702*^9, 
   3.728278716980959*^9, 3.728280994805992*^9, 3.7284837657583437`*^9, 
   3.728551304997988*^9, 3.728551799263884*^9, 3.7288045698223352`*^9, 
   3.728804692780368*^9, 3.728808861746588*^9, 3.7779140153944335`*^9, 
   3.777914086305251*^9, 3.791093804120035*^9, 3.791093953547146*^9, 
   3.820207208252557*^9, 3.8202072991019697`*^9, 3.820207367755687*^9, 
   3.842762465594228*^9, 3.844390006701245*^9, 3.844390077871439*^9, 
   3.844390675710694*^9, 3.844391080764464*^9, 3.875891576494954*^9, 
   3.875891995295758*^9, 3.921306833569578*^9, 3.9213069079121017`*^9, 
   3.9213069506487064`*^9, 3.9584003378689747`*^9},
 CellLabel->
  "Out[525]=",ExpressionUUID->"1d18bbce-4e15-cf45-a2ec-aff30d5ce400"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellLabel->
  "In[526]:=",ExpressionUUID->"833a35bd-159a-4f2b-b298-fe257bf0abfc"],

Cell[BoxData["\<\"T_{ca(b}{}^{[g}\\\\Sigma^{d]}{}_{f)}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796653519*^9, 3.582353855144452*^9, 3.582353968012858*^9, 
   3.583133041349699*^9, 3.583133261264285*^9, 3.583133302931958*^9, 
   3.5831333348808146`*^9, 3.5831353253829117`*^9, 3.5831380885553646`*^9, 
   3.5831382093161774`*^9, 3.583146623073807*^9, 3.5831501734690433`*^9, 
   3.583150224449933*^9, 3.583150272685218*^9, {3.587965186315864*^9, 
   3.587965204708297*^9}, 3.588079873731631*^9, 3.5880799569109774`*^9, 
   3.588083330359709*^9, 3.5880836934503465`*^9, 3.588319071852591*^9, 
   3.588319170319964*^9, 3.588325827529241*^9, 3.588325958787872*^9, 
   3.5883269171765556`*^9, 3.588327860542412*^9, 3.588327929744134*^9, 
   3.588328019709492*^9, 3.588328474044689*^9, 3.588328558206837*^9, 
   3.5883293976297116`*^9, {3.58832968117581*^9, 3.588329704575851*^9}, 
   3.5883299128820167`*^9, 3.61513082635686*^9, 3.615131008432485*^9, 
   3.6190891664400883`*^9, 3.6196262158091583`*^9, 3.6205425720185785`*^9, 
   3.64638171069097*^9, 3.67998396954819*^9, 3.679984669186689*^9, 
   3.697739184577181*^9, 3.697739239669259*^9, 3.71523289636823*^9, 
   3.715233748163933*^9, 3.727334899614431*^9, 3.727334959088991*^9, 
   3.727335200755847*^9, 3.7273352393203206`*^9, 3.7273353320909*^9, 
   3.727336144321928*^9, 3.727336235825609*^9, 3.7273364666727514`*^9, 
   3.727336736882936*^9, 3.7273370590526123`*^9, 3.727340516043603*^9, 
   3.7273406244133716`*^9, 3.727340740895483*^9, 3.7273413343759336`*^9, 
   3.727342073698807*^9, 3.727343587779256*^9, 3.727343670701984*^9, 
   3.727343750611807*^9, 3.7273438588589134`*^9, 3.7274106465372458`*^9, 
   3.72827871701773*^9, 3.728280994837231*^9, 3.7284837658421736`*^9, 
   3.728551305013612*^9, 3.728551799282525*^9, 3.7288045698803387`*^9, 
   3.72880469283337*^9, 3.7288088617934675`*^9, 3.777914015450863*^9, 
   3.777914086336502*^9, 3.791093804182607*^9, 3.791093953609641*^9, 
   3.8202072082874913`*^9, 3.820207299134909*^9, 3.820207367787591*^9, 
   3.842762465619192*^9, 3.844390006732164*^9, 3.84439007790036*^9, 
   3.8443906757386203`*^9, 3.844391080793384*^9, 3.875891576520913*^9, 
   3.8758919953137217`*^9, 3.9213068335935135`*^9, 3.921306907936041*^9, 
   3.921306950664633*^9, 3.9584003378849487`*^9},
 CellLabel->
  "Out[526]=",ExpressionUUID->"aab62410-1415-3a4e-b3c0-bd4069bfe03c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "@", 
  RowBox[{"Antisymmetrize", "[", 
   RowBox[{
    RowBox[{"T4", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5822821755699935`*^9, 3.582282204586045*^9}},
 CellLabel->
  "In[527]:=",ExpressionUUID->"56070e95-de71-4aac-8ad0-a5fa0e469b7d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "c", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`c, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "c", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`c, -$CellContext`d, \
-$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "d", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "d", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "a", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, -$CellContext`a, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "a", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "c", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, -$CellContext`c, -$CellContext`a, \
-$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "c", "d", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, -$CellContext`c, -$CellContext`d, \
-$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "d", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, -$CellContext`d, -$CellContext`a, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "d", "c", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, -$CellContext`d, -$CellContext`c, \
-$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "a", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "a", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "b", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`b, -$CellContext`a, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "b", "d", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`b, -$CellContext`d, \
-$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "d", "a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`d, -$CellContext`a, \
-$CellContext`b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "d", "b", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
-$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "a", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "a", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`a, -$CellContext`c, \
-$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "b", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`b, -$CellContext`a, \
-$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "b", "c", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`b, -$CellContext`c, \
-$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "c", "a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`c, -$CellContext`a, \
-$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "c", "b", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`c, -$CellContext`b, \
-$CellContext`a],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.582347796684718*^9, 3.582353855175653*^9, 3.5823539680284576`*^9, 
   3.583133041380899*^9, 3.583133271965904*^9, 3.583133302963159*^9, 
   3.583133334912015*^9, 3.583135325414111*^9, 3.583138088586564*^9, 
   3.583138209347378*^9, 3.5831466231050067`*^9, 3.583150173500243*^9, 
   3.583150224481133*^9, 3.5831502727164187`*^9, {3.587965186347065*^9, 
   3.587965204739497*^9}, 3.5880798737628307`*^9, 3.5880799569421773`*^9, 
   3.588083330422109*^9, 3.588083693840348*^9, 3.588319071883791*^9, 
   3.588319170366764*^9, 3.588325827560441*^9, 3.588325958819072*^9, 
   3.588326917207755*^9, 3.588327860573612*^9, 3.588327929775334*^9, 
   3.588328019740692*^9, 3.588328474075889*^9, 3.588328558238037*^9, 
   3.588329397660912*^9, {3.58832968120701*^9, 3.588329704622651*^9}, 
   3.5883299129132156`*^9, 3.61513082638686*^9, 3.615131008448085*^9, 
   3.619089166470088*^9, 3.6196262158491583`*^9, 3.6205425720585785`*^9, 
   3.646381710720969*^9, 3.679983969618185*^9, 3.67998466924669*^9, 
   3.697739184627181*^9, 3.697739239709259*^9, 3.7152328964203043`*^9, 
   3.71523374964909*^9, 3.727334899698621*^9, 3.727335201425273*^9, 
   3.72733523938942*^9, 3.727335332207045*^9, 3.727336144369256*^9, 
   3.727336235907281*^9, 3.727336466794305*^9, 3.727336737029887*^9, 
   3.7273370591684937`*^9, 3.727340516138154*^9, 3.727340624513683*^9, 
   3.727340741010957*^9, 3.727341335210547*^9, 3.7273420737636795`*^9, 
   3.727343587879535*^9, 3.727343670785867*^9, 3.727343750727748*^9, 
   3.727343858921839*^9, 3.727410646653165*^9, 3.728278717082778*^9, 
   3.728280994890016*^9, 3.7284837658890557`*^9, 3.728551305082699*^9, 
   3.728551799386318*^9, 3.728804570049348*^9, 3.728804692880373*^9, 
   3.7288088618937817`*^9, 3.777914015528987*^9, 3.777914086445879*^9, 
   3.791093804298523*^9, 3.791093953709928*^9, 3.8202072083373575`*^9, 
   3.820207299198738*^9, 3.820207367832004*^9, 3.8427624656880035`*^9, 
   3.844390006778013*^9, 3.844390077941282*^9, 3.844390675864252*^9, 
   3.844391080900106*^9, 3.8758915765578136`*^9, 3.875891995346621*^9, 
   3.9213068336314125`*^9, 3.9213069079729443`*^9, 3.921306950695574*^9, 
   3.958400337916544*^9},
 CellLabel->
  "Out[527]=",ExpressionUUID->"3010cafb-3ae1-5840-9564-979ba18acbd4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr2", "=", 
  RowBox[{"%", "/.", 
   RowBox[{
    RowBox[{"T4", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", "c_", ",", "d_", ",", "a_"}], "]"}], 
    "\[RightTeeArrow]", 
    RowBox[{
     RowBox[{"T4", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "f", ",", "d", ",", "a"}], "]"}], 
     RowBox[{"\[CapitalSigma]2", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "f"}]}], "]"}], 
     RowBox[{"\[CapitalSigma]2", "[", 
      RowBox[{"c", ",", 
       RowBox[{"-", "g"}]}], "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.582282481806848*^9, 3.5822826115678763`*^9}, {
  3.582282713061654*^9, 3.582282758301734*^9}, {3.5823537640402927`*^9, 
  3.582353766130697*^9}},
 CellLabel->
  "In[528]:=",ExpressionUUID->"7c455e37-60c4-46ae-b69b-98640dbf1e4e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "b", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "c", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`c, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "c", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`c, -$CellContext`d, \
-$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "d", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "d", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "a", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "a", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "b", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`b, -$CellContext`a, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "b", "d", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`b, -$CellContext`d, \
-$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "d", "a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`d, -$CellContext`a, \
-$CellContext`b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"c", "d", "b", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
-$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "a", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "a", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`a, -$CellContext`c, \
-$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "b", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`b, -$CellContext`a, \
-$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "b", "c", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`b, -$CellContext`c, \
-$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "c", "a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`c, -$CellContext`a, \
-$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"d", "c", "b", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`d, -$CellContext`c, -$CellContext`b, \
-$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", "e", " ", " "},
           {"b", " ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[-$CellContext`a, -$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {"f", " "},
           {" ", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", "e", " ", " "},
           {"b", " ", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`d, \
-$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[-$CellContext`a, -$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {"f", " "},
           {" ", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", "e", " ", " "},
           {"b", " ", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`a, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[-$CellContext`c, -$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {"f", " "},
           {" ", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", "e", " ", " "},
           {"b", " ", "d", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`d, \
-$CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[-$CellContext`c, -$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {"f", " "},
           {" ", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", "e", " ", " "},
           {"b", " ", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`a, \
-$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[-$CellContext`d, -$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {"f", " "},
           {" ", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "24"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", "e", " ", " "},
           {"b", " ", "c", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`c, \
-$CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[-$CellContext`d, -$CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {"f", " "},
           {" ", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.582347796715919*^9, 3.582353855206853*^9, 3.5823539680596576`*^9, 
   3.583133041427699*^9, 3.583133272012704*^9, 3.583133302994358*^9, 
   3.583133334943215*^9, 3.583135325445311*^9, 3.583138088633364*^9, 
   3.583138209394177*^9, 3.5831466235262074`*^9, 3.5831501735314436`*^9, 
   3.583150224527933*^9, 3.583150272747619*^9, {3.587965186581065*^9, 
   3.587965204786297*^9}, 3.5880798738096304`*^9, 3.588079956973377*^9, 
   3.588083330468909*^9, 3.5880836960555506`*^9, 3.588319071930591*^9, 
   3.5883191704135637`*^9, 3.5883258275916414`*^9, 3.588325958850272*^9, 
   3.588326917238955*^9, 3.588327860604812*^9, 3.588327929806534*^9, 
   3.5883280197718916`*^9, 3.588328474122689*^9, 3.588328558269238*^9, 
   3.588329397692112*^9, {3.5883296812382097`*^9, 3.5883297046538506`*^9}, 
   3.588329912944416*^9, 3.6151308264168596`*^9, 3.615131008479285*^9, 
   3.6190891665000887`*^9, 3.6196262159091587`*^9, 3.620542572108579*^9, 
   3.64638171076097*^9, 3.679983969718177*^9, 3.6799846693366904`*^9, 
   3.697739184677181*^9, 3.697739239749259*^9, 3.715232896513731*^9, 
   3.7152337497894173`*^9, 3.727334899783676*^9, 3.727335202042033*^9, 
   3.727335239442529*^9, 3.72733533230681*^9, 3.727336144438073*^9, 
   3.72733623606979*^9, 3.727336466872579*^9, 3.7273367371297207`*^9, 
   3.727337059268811*^9, 3.72734051622283*^9, 3.727340624598422*^9, 
   3.727340741095152*^9, 3.727341336231727*^9, 3.727342073863968*^9, 
   3.727343588010697*^9, 3.7273436708856916`*^9, 3.727343750896615*^9, 
   3.727343859037781*^9, 3.727410646806941*^9, 3.728278717160944*^9, 
   3.728280994974227*^9, 3.728483765973783*^9, 3.728551305160866*^9, 
   3.728551799486605*^9, 3.728804570104351*^9, 3.7288046929373775`*^9, 
   3.728808862094323*^9, 3.7779140156539855`*^9, 3.777914086602137*^9, 
   3.7910938044243097`*^9, 3.7910939538190336`*^9, 3.820207208389219*^9, 
   3.8202072992555857`*^9, 3.8202073678818693`*^9, 3.842762465761807*^9, 
   3.844390006827903*^9, 3.8443900779971333`*^9, 3.844390676003906*^9, 
   3.844391081045713*^9, 3.875891576602666*^9, 3.875891995389507*^9, 
   3.9213068336733*^9, 3.9213069080158215`*^9, 3.9213069507314835`*^9, 
   3.9584003379641705`*^9},
 CellLabel->
  "Out[528]=",ExpressionUUID->"2e0fbbeb-7139-4d4e-a720-b6814db24500"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexPrintPageWidth", "=", "latextextwidth"}], ";"}]], "Input",
 CellChangeTimes->{{3.588329844241895*^9, 3.588329854725114*^9}},
 CellLabel->
  "In[529]:=",ExpressionUUID->"67cd4b78-fd4f-479b-addd-4edae3611155"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "expr2"}]], "Input",
 CellChangeTimes->{{3.582282422651544*^9, 3.5822824256467485`*^9}, 
   3.588083416003859*^9},
 CellLabel->
  "In[530]:=",ExpressionUUID->"18bf4a10-de5a-4424-bc1c-3624d08751fb"],

Cell[BoxData["\<\"\\\\tfrac{1}{24} T_{abcd} -  \\\\tfrac{1}{24} T_{abdc} -  \
\\\\tfrac{1}{24} T_{acbd} + \\\\tfrac{1}{24} T_{acdb} + \\\\tfrac{1}{24} \
T_{adbc} -  \\\\tfrac{1}{24} T_{adcb} + \\\\tfrac{1}{24} T_{cabd} -  \
\\\\tfrac{1}{24} T_{cadb} -  \\\\tfrac{1}{24} T_{cbad} + \\\\tfrac{1}{24} \
T_{cbda} + \\\\tfrac{1}{24} T_{cdab} -  \\\\tfrac{1}{24} T_{cdba} -  \
\\\\tfrac{1}{24} T_{dabc} + \\\\tfrac{1}{24} T_{dacb} + \\\\tfrac{1}{24} \
T_{dbac} -  \\\\tfrac{1}{24} T_{dbca} -  \\\\tfrac{1}{24} T_{dcab} + \
\\\\tfrac{1}{24} T_{dcba} -  \\\\tfrac{1}{24} T_{b}{}^{e}{}_{cd} \
\\\\Sigma_{af} \\\\Sigma^{f}{}_{e} + \\\\tfrac{1}{24} T_{b}{}^{e}{}_{dc} \
\\\\Sigma_{af} \\\\Sigma^{f}{}_{e} + \\\\tfrac{1}{24} T_{b}{}^{e}{}_{ad} \
\\\\Sigma_{cf} \\\\Sigma^{f}{}_{e} -  \\\\tfrac{1}{24} T_{b}{}^{e}{}_{da} \
\\\\Sigma_{cf} \\\\Sigma^{f}{}_{e} -  \\\\tfrac{1}{24} T_{b}{}^{e}{}_{ac} \
\\\\Sigma_{df} \\\\Sigma^{f}{}_{e} + \\\\tfrac{1}{24} T_{b}{}^{e}{}_{ca} \
\\\\Sigma_{df} \\\\Sigma^{f}{}_{e}\"\>"], "Output",
 CellChangeTimes->{
  3.582347796903119*^9, 3.582353855378453*^9, 3.582353968262458*^9, 
   3.5831330415993*^9, 3.5831332721999054`*^9, 3.583133303197159*^9, 
   3.583133335114815*^9, 3.5831353256637115`*^9, 3.583138088914165*^9, 
   3.583138209643777*^9, 3.5831466237290077`*^9, 3.583150173703044*^9, 
   3.583150224699534*^9, 3.583150272919218*^9, {3.5879651867994657`*^9, 
   3.587965204957897*^9}, 3.588079873996831*^9, 3.588079957144977*^9, 
   3.588083330671709*^9, 3.58808341653426*^9, 3.588083457453132*^9, 
   3.5880836966951528`*^9, 3.5883190721177926`*^9, 3.5883191706007643`*^9, 
   3.5883258277632413`*^9, 3.588325959037472*^9, 3.588326917410555*^9, 
   3.588327860792012*^9, 3.588327929978134*^9, 3.588328019943492*^9, 
   3.58832847429429*^9, 3.588328558440838*^9, 3.588329429110567*^9, {
   3.5883296831102138`*^9, 3.588329721954281*^9}, 3.588329819999453*^9, 
   3.5883298577671194`*^9, 3.588329913131616*^9, 3.615130840986881*^9, 
   3.615131008557285*^9, 3.619089166580088*^9, 3.619626215989158*^9, 
   3.6205425721785793`*^9, 3.64638171085097*^9, 3.679983969808169*^9, 
   3.6799846696266932`*^9, 3.697739184757181*^9, 3.697739239839259*^9, 
   3.715232896651345*^9, 3.715233749931891*^9, 3.727334899930889*^9, {
   3.727335187158909*^9, 3.72733520338353*^9}, 3.727335239542367*^9, 
   3.727335332407151*^9, 3.727336144538436*^9, 3.727336236169359*^9, 
   3.7273364669895535`*^9, 3.7273367372303257`*^9, 3.727337059369089*^9, 
   3.727340516338765*^9, 3.727340624714355*^9, 3.7273407412106314`*^9, 
   3.727341336860941*^9, 3.727342074001119*^9, 3.72734358811104*^9, 
   3.727343670986025*^9, 3.727343751012554*^9, 3.727343859175837*^9, 
   3.727410646891625*^9, 3.728278717245335*^9, 3.7282809950525875`*^9, 
   3.7284837660428343`*^9, 3.728551305214264*^9, 3.728551799588398*^9, 
   3.728804570139353*^9, 3.7288046929713793`*^9, 3.728808862163355*^9, 
   3.777914015716446*^9, 3.777914086664632*^9, 3.7910938045212493`*^9, 
   3.7910939539323277`*^9, 3.8202072084380603`*^9, 3.820207299304427*^9, 
   3.820207367950659*^9, 3.8427624658046923`*^9, 3.8443900068867497`*^9, 
   3.844390078043002*^9, 3.844390676061724*^9, 3.844391081083611*^9, 
   3.8758915766435843`*^9, 3.875891995419427*^9, 3.9213068337121964`*^9, 
   3.921306908051731*^9, 3.9213069507624016`*^9, 3.9584003379960327`*^9},
 CellLabel->
  "Out[530]=",ExpressionUUID->"7aa1b62a-4eba-fb48-b391-6b32cd1da0dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexBreak", "[", 
  RowBox[{"%", ",", "210", ",", " ", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"TexBreakBy", "\[Rule]", "\"\<TexPoint\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.588083333604514*^9, 3.588083408983847*^9}, 
   3.588083454551527*^9},
 CellLabel->
  "In[531]:=",ExpressionUUID->"3b4c853b-86db-4e37-85f1-60f6f8b12a42"],

Cell[BoxData["\<\"\\\\tfrac{1}{24} T_{abcd} -  \\\\tfrac{1}{24} T_{abdc} -  \
\\\\tfrac{1}{24} T_{acbd} + \\\\tfrac{1}{24} T_{acdb} \\\\nonumber \\\\\\\\ \
\\n&& + \\\\tfrac{1}{24} T_{adbc} -  \\\\tfrac{1}{24} T_{adcb} + \
\\\\tfrac{1}{24} T_{cabd} -  \\\\tfrac{1}{24} T_{cadb} \\\\nonumber \\\\\\\\ \
\\n&& -  \\\\tfrac{1}{24} T_{cbad} + \\\\tfrac{1}{24} T_{cbda} + \
\\\\tfrac{1}{24} T_{cdab} -  \\\\tfrac{1}{24} T_{cdba} \\\\nonumber \\\\\\\\ \
\\n&& -  \\\\tfrac{1}{24} T_{dabc} + \\\\tfrac{1}{24} T_{dacb} + \
\\\\tfrac{1}{24} T_{dbac} -  \\\\tfrac{1}{24} T_{dbca} \\\\nonumber \\\\\\\\ \
\\n&& -  \\\\tfrac{1}{24} T_{dcab} + \\\\tfrac{1}{24} T_{dcba} -  \
\\\\tfrac{1}{24} T_{b}{}^{e}{}_{cd} \\\\Sigma_{af} \\\\Sigma^{f}{}_{e} \
\\\\nonumber \\\\\\\\ \\n&& + \\\\tfrac{1}{24} T_{b}{}^{e}{}_{dc} \
\\\\Sigma_{af} \\\\Sigma^{f}{}_{e} + \\\\tfrac{1}{24} T_{b}{}^{e}{}_{ad} \
\\\\Sigma_{cf} \\\\Sigma^{f}{}_{e} \\\\nonumber \\\\\\\\ \\n&& -  \
\\\\tfrac{1}{24} T_{b}{}^{e}{}_{da} \\\\Sigma_{cf} \\\\Sigma^{f}{}_{e} -  \
\\\\tfrac{1}{24} T_{b}{}^{e}{}_{ac} \\\\Sigma_{df} \\\\Sigma^{f}{}_{e} \
\\\\nonumber \\\\\\\\ \\n&& + \\\\tfrac{1}{24} T_{b}{}^{e}{}_{ca} \
\\\\Sigma_{df} \\\\Sigma^{f}{}_{e}\"\>"], "Output",
 CellChangeTimes->{
  3.582347797199519*^9, 3.582353855518853*^9, 3.582353968371659*^9, 
   3.583133042519701*^9, 3.583133272309105*^9, 3.583133303353159*^9, 
   3.583133335224015*^9, 3.583135325772911*^9, 3.583138089054565*^9, 
   3.583138209752977*^9, 3.583146624446609*^9, 3.583150173827844*^9, 
   3.583150224808734*^9, 3.5831502730440187`*^9, {3.5879651868150654`*^9, 
   3.587965205160698*^9}, 3.588079874714432*^9, 3.588079957285377*^9, {
   3.588083390997015*^9, 3.5880834173922615`*^9}, 3.588083458014733*^9, 
   3.588083696866753*^9, 3.588319072242592*^9, 3.588319170725565*^9, 
   3.5883258278880415`*^9, 3.588325959177872*^9, 3.588326917535356*^9, 
   3.588327860932414*^9, 3.5883279300873346`*^9, 3.588328020052692*^9, 
   3.58832847443469*^9, 3.5883285585500393`*^9, 3.588329431122971*^9, 
   3.588329683250613*^9, 3.588329723545484*^9, 3.588329821013455*^9, 
   3.588329858297521*^9, 3.588329913240816*^9, 3.6151308421968827`*^9, 
   3.6151310124260926`*^9, 3.619089166700088*^9, 3.6196262161991587`*^9, 
   3.62054257246858*^9, 3.6463817113209715`*^9, 3.679983970478116*^9, 
   3.679984669916697*^9, 3.6977391850271816`*^9, 3.69773924010926*^9, 
   3.7152328969536667`*^9, 3.715233750106992*^9, 3.727334900384019*^9, 
   3.727335205369749*^9, 3.727335240120679*^9, 3.7273353327449393`*^9, 
   3.727336144954065*^9, 3.727336249235536*^9, 3.7273364897719593`*^9, 
   3.727336744629236*^9, 3.727337059785839*^9, 3.727340516706287*^9, 
   3.727340625068385*^9, 3.727340741595168*^9, 3.7273413372483273`*^9, 
   3.72734207443272*^9, 3.727343588479553*^9, 3.727343671501767*^9, 
   3.7273437513117085`*^9, 3.7273438596604357`*^9, 3.7274106472922983`*^9, 
   3.7282787199478707`*^9, 3.728280995421846*^9, 3.7284837665115633`*^9, 
   3.7285513055841255`*^9, 3.72855180003358*^9, 3.728804570406369*^9, 
   3.7288046932493944`*^9, 3.7288088625644937`*^9, 3.7779140162916193`*^9, 
   3.777914087237894*^9, 3.791093805586645*^9, 3.791093954780492*^9, 
   3.820207208911266*^9, 3.8202072997841525`*^9, 3.820207368423394*^9, 
   3.842762466224568*^9, 3.844390008014703*^9, 3.8443900784379473`*^9, 
   3.844390676452702*^9, 3.844391081577262*^9, 3.875891577055457*^9, 
   3.8758919958253136`*^9, 3.9213068341111298`*^9, 3.921306908414732*^9, 
   3.9213069511254025`*^9, 3.958400341903799*^9},
 CellLabel->
  "Out[531]=",ExpressionUUID->"b74d69c3-2fdc-ba4d-9372-b4cfa3a568a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FirstEq", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalSigma]2", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], 
    RowBox[{"\[CapitalSigma]2", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], "==", "expr2"}]}]], "Input",
 CellChangeTimes->{{3.727340897421804*^9, 3.7273408985064964`*^9}, {
  3.7273412627690945`*^9, 3.727341281846455*^9}},
 CellLabel->
  "In[532]:=",ExpressionUUID->"f192b880-0574-43c1-8bef-180897e9cde4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[CapitalSigma]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalSigma]2[-$CellContext`c, -$CellContext`d],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "b", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`a, -$CellContext`c, -$CellContext`b, \
-$CellContext`d],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "c", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`a, -$CellContext`c, -$CellContext`d, \
-$CellContext`b],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`c],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"a", "d", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`a, -$CellContext`d, -$CellContext`c, \
-$CellContext`b],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`c, -$CellContext`a, -$CellContext`b, \
-$CellContext`d],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "a", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`c, -$CellContext`a, -$CellContext`d, \
-$CellContext`b],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`c, -$CellContext`b, -$CellContext`a, \
-$CellContext`d],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "b", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`c, -$CellContext`b, -$CellContext`d, \
-$CellContext`a],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`c, -$CellContext`d, -$CellContext`a, \
-$CellContext`b],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"c", "d", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
-$CellContext`a],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "b", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`d, -$CellContext`a, -$CellContext`b, \
-$CellContext`c],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "a", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`d, -$CellContext`a, -$CellContext`c, \
-$CellContext`b],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`d, -$CellContext`b, -$CellContext`a, \
-$CellContext`c],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "b", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`d, -$CellContext`b, -$CellContext`c, \
-$CellContext`a],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`d, -$CellContext`c, -$CellContext`a, \
-$CellContext`b],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " ", " ", " "},
            {"d", "c", "b", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`d, -$CellContext`c, -$CellContext`b, \
-$CellContext`a],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", "e", " ", " "},
            {"b", " ", "c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`c, \
-$CellContext`d],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"a", "f"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[-$CellContext`a, -$CellContext`f],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {"f", " "},
            {" ", "e"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", "e", " ", " "},
            {"b", " ", "d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`d, \
-$CellContext`c],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"a", "f"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[-$CellContext`a, -$CellContext`f],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {"f", " "},
            {" ", "e"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", "e", " ", " "},
            {"b", " ", "a", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`a, \
-$CellContext`d],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"c", "f"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[-$CellContext`c, -$CellContext`f],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {"f", " "},
            {" ", "e"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", "e", " ", " "},
            {"b", " ", "d", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`d, \
-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"c", "f"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[-$CellContext`c, -$CellContext`f],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {"f", " "},
            {" ", "e"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
     Editable->False]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", "e", " ", " "},
            {"b", " ", "a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`a, \
-$CellContext`c],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"d", "f"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[-$CellContext`d, -$CellContext`f],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {"f", " "},
            {" ", "e"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
     Editable->False]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", "e", " ", " "},
            {"b", " ", "c", "a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T4[-$CellContext`b, $CellContext`e, -$CellContext`c, \
-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"d", "f"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[-$CellContext`d, -$CellContext`f],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[CapitalSigma]", 
         StyleBox[GridBox[{
            {"f", " "},
            {" ", "e"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalSigma]2[$CellContext`f, -$CellContext`e],
     Editable->False]}]}]}]], "Output",
 CellChangeTimes->{3.727340899970408*^9, 3.727341337748904*^9, 
  3.7273420745486383`*^9, 3.727343588576888*^9, 3.727343671670708*^9, 
  3.7273437514116826`*^9, 3.727343859775907*^9, 3.727410647354839*^9, 
  3.728278726267133*^9, 3.7282809956371408`*^9, 3.728483766566903*^9, 
  3.728551305715669*^9, 3.728551800172448*^9, 3.728804570464371*^9, 
  3.728804693317398*^9, 3.728808862664321*^9, 3.777914016432288*^9, 
  3.7779140874423127`*^9, 3.791093805802894*^9, 3.7910939549342594`*^9, 
  3.820207208964151*^9, 3.8202072998679333`*^9, 3.8202073684742584`*^9, 
  3.842762466269446*^9, 3.844390008343879*^9, 3.844390078540679*^9, 
  3.844390676498582*^9, 3.844391081625161*^9, 3.875891577149235*^9, 
  3.875891995934052*^9, 3.9213068341719933`*^9, 3.921306908472603*^9, 
  3.921306951162327*^9, 3.958400341982296*^9},
 CellLabel->
  "Out[532]=",ExpressionUUID->"90aa5142-8ab7-d445-b6eb-0b87b53dbb85"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Second\[CapitalSigma]Eq", "=", 
  RowBox[{
   RowBox[{"\[CapitalSigma]2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[Equal]", "0"}]}]], "Input",
 CellChangeTimes->{{3.7273407985019236`*^9, 3.7273408011731853`*^9}, {
  3.727340895636191*^9, 3.727340907925694*^9}, {3.727341269973216*^9, 
  3.72734127846086*^9}, {3.7273435449279604`*^9, 3.7273435512877836`*^9}, {
  3.7273437044880958`*^9, 3.727343710822482*^9}},
 CellLabel->
  "In[533]:=",ExpressionUUID->"ec4bc28f-c577-4940-9b26-c351272a9613"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[CapitalSigma]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[CapitalSigma]2[-$CellContext`a, -$CellContext`b],
   Editable->False], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{3.727340805159457*^9, 3.727340909157426*^9, 
  3.727341337780184*^9, 3.727342074564234*^9, 3.727343588595185*^9, 
  3.727343671686334*^9, 3.727343751442935*^9, 3.727343859807128*^9, 
  3.727410647370432*^9, 3.728278726304875*^9, 3.7282809956527386`*^9, 
  3.728483766582505*^9, 3.728551305731295*^9, 3.728551800249908*^9, 
  3.728804570478372*^9, 3.728804693332399*^9, 3.728808862664321*^9, 
  3.777914016494755*^9, 3.777914087470876*^9, 3.7910938058876143`*^9, 
  3.791093954996773*^9, 3.820207209004044*^9, 3.820207299906387*^9, 
  3.8202073685081673`*^9, 3.842762466299365*^9, 3.844390008379755*^9, 
  3.8443900785745583`*^9, 3.844390676531494*^9, 3.844391081656051*^9, 
  3.875891577176162*^9, 3.8758919959520035`*^9, 3.9213068341968994`*^9, 
  3.921306908498535*^9, 3.9213069511802807`*^9, 3.958400342013338*^9},
 CellLabel->
  "Out[533]=",ExpressionUUID->"2816d334-b7b8-ff4a-b66e-7f4c2a9f6236"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThirdEq", "=", 
  RowBox[{
   RowBox[{"T4", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "==", 
   RowBox[{
    RowBox[{"T4", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], "-", 
    RowBox[{"T4", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.727340911426629*^9, 3.7273409145433054`*^9}, {
  3.727341286063808*^9, 3.727341288582317*^9}},
 CellLabel->
  "In[534]:=",ExpressionUUID->"f62b2cf9-6b5c-4f09-8fb7-ffeb5afed077"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "d", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T4[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
   Editable->False], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"a", "d", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`a, -$CellContext`d, -$CellContext`b, \
-$CellContext`c],
    Editable->False], "-", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"b", "a", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T4[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
-$CellContext`c],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.727340914879465*^9, 3.727341338011067*^9, 
  3.7273420746176615`*^9, 3.72734358869497*^9, 3.7273436717175636`*^9, 
  3.727343751474188*^9, 3.7273438598761587`*^9, 3.727410647407884*^9, 
  3.728278726336128*^9, 3.728280995721905*^9, 3.728483766603714*^9, 
  3.728551305762548*^9, 3.7285518002861037`*^9, 3.7288045705063744`*^9, 
  3.7288046933504*^9, 3.728808862679973*^9, 3.777914016541668*^9, 
  3.777914087502123*^9, 3.791093805987504*^9, 3.791093955081431*^9, 
  3.820207209049919*^9, 3.820207299954259*^9, 3.8202073685450687`*^9, 
  3.8427624663272667`*^9, 3.8443900084186506`*^9, 3.8443900786054754`*^9, 
  3.8443906765623846`*^9, 3.8443910817109323`*^9, 3.8758915772011013`*^9, 
  3.875891995973917*^9, 3.92130683422283*^9, 3.921306908523468*^9, 
  3.9213069512031937`*^9, 3.958400342029068*^9},
 CellLabel->
  "Out[534]=",ExpressionUUID->"657a7a70-4966-274e-8bb5-a43bc0b75b2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"texcode", "=", 
  RowBox[{"TexPrintAlignedEquations", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"FirstEq", ",", "Second\[CapitalSigma]Eq", ",", "ThirdEq"}], 
     "}"}], ",", 
    RowBox[{"Labels", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7273408406275434`*^9, 3.7273408577566385`*^9}, {
   3.7273409184137306`*^9, 3.7273409514388003`*^9}, 3.7273412961683407`*^9, {
   3.727341365964566*^9, 3.7273413794956946`*^9}, {3.72734369196481*^9, 
   3.727343717094249*^9}, {3.728551736001363*^9, 3.728551738485718*^9}},
 CellLabel->
  "In[535]:=",ExpressionUUID->"642607af-3fbd-4ae4-8a71-5411b09aa2af"],

Cell[BoxData["\<\"\\\\begin{align}\\n\\\\Sigma_{ab} \
\\\\Sigma_{cd}={}&\\\\tfrac{1}{24} T_{abcd}\\n -  \\\\tfrac{1}{24} \
T_{abdc}\\n -  \\\\tfrac{1}{24} T_{acbd}\\n + \\\\tfrac{1}{24} T_{acdb}\\n + \
\\\\tfrac{1}{24} T_{adbc}\\n -  \\\\tfrac{1}{24} T_{adcb}\\n + \
\\\\tfrac{1}{24} T_{cabd}\\\\nonumber\\\\\\\\\\n& -  \\\\tfrac{1}{24} \
T_{cadb}\\n -  \\\\tfrac{1}{24} T_{cbad}\\n + \\\\tfrac{1}{24} T_{cbda}\\n + \
\\\\tfrac{1}{24} T_{cdab}\\n -  \\\\tfrac{1}{24} T_{cdba}\\n -  \
\\\\tfrac{1}{24} T_{dabc}\\\\nonumber\\\\\\\\\\n& + \\\\tfrac{1}{24} T_{dacb}\
\\n + \\\\tfrac{1}{24} T_{dbac}\\n -  \\\\tfrac{1}{24} T_{dbca}\\n -  \
\\\\tfrac{1}{24} T_{dcab}\\n + \\\\tfrac{1}{24} \
T_{dcba}\\\\nonumber\\\\\\\\\\n& -  \\\\tfrac{1}{24} T_{b}{}^{e}{}_{cd} \
\\\\Sigma_{af} \\\\Sigma^{f}{}_{e}\\n + \\\\tfrac{1}{24} T_{b}{}^{e}{}_{dc} \
\\\\Sigma_{af} \\\\Sigma^{f}{}_{e}\\n + \\\\tfrac{1}{24} T_{b}{}^{e}{}_{ad} \
\\\\Sigma_{cf} \\\\Sigma^{f}{}_{e}\\\\nonumber\\\\\\\\\\n& -  \
\\\\tfrac{1}{24} T_{b}{}^{e}{}_{da} \\\\Sigma_{cf} \\\\Sigma^{f}{}_{e}\\n -  \
\\\\tfrac{1}{24} T_{b}{}^{e}{}_{ac} \\\\Sigma_{df} \\\\Sigma^{f}{}_{e}\\n + \
\\\\tfrac{1}{24} T_{b}{}^{e}{}_{ca} \\\\Sigma_{df} \\\\Sigma^{f}{}_{e} \
\\\\label{eq:FirstEq},\\\\\\\\\\n\\\\Sigma_{ab}={}&0 \
\\\\label{eq:SecondCapitalSigmaEq},\\\\\\\\\\nT_{abdc}={}&T_{adbc}\\n -  \
T_{badc} \\\\label{eq:ThirdEq}.\\n\\\\end{align}\"\>"], "Output",
 CellChangeTimes->{{3.727340837478153*^9, 3.727340860094448*^9}, {
   3.7273409281820145`*^9, 3.727340952554411*^9}, 3.727341078371787*^9, 
   3.7273413384654145`*^9, 3.727342074965447*^9, 3.727343589280498*^9, 
   3.727343672117412*^9, 3.727343751959584*^9, 3.7273438604083*^9, 
   3.7274106479394746`*^9, 3.7282787268052683`*^9, 3.728280996190355*^9, 
   3.728483767059442*^9, 3.7285513062477007`*^9, 3.7285518007169247`*^9, 
   3.72880457079239*^9, 3.728804693661418*^9, 3.728808863033373*^9, 
   3.777914017204751*^9, 3.77791408801902*^9, 3.791093806591762*^9, 
   3.791093955667214*^9, 3.8202072095156574`*^9, 3.8202073004103622`*^9, 
   3.820207368997114*^9, 3.8427624667312107`*^9, 3.8443900088415194`*^9, 
   3.844390079012386*^9, 3.844390676994402*^9, 3.84439108222852*^9, 
   3.875891577625932*^9, 3.8758919963967867`*^9, 3.9213068346058044`*^9, 
   3.92130690889744*^9, 3.921306951605116*^9, 3.9584003426816616`*^9},
 CellLabel->
  "Out[535]=",ExpressionUUID->"1fe49694-1451-8c43-944f-888c2d340750"]
}, Open  ]],

Cell["\<\
Observe that $TexViewInternal=True; only works on some versions of \
Mathematica. How well this works can also depend on your OS and latex \
version. Adding  \[OpenCurlyDoubleQuote]\\\\pdfminorversion=3\
\[CloseCurlyDoubleQuote] to the list $TexInitLatexExtraCode can help in some \
cases. The default $TexViewInternal=False; should work on most machines \
though.\
\>", "Text",
 CellChangeTimes->{{3.728559855809773*^9, 3.7285600314788203`*^9}, 
   3.728804592409627*^9, {3.728808040251742*^9, 
   3.7288080405307484`*^9}},ExpressionUUID->"c46eb656-4bcb-4dcc-8f68-\
b10882cd05ff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TexViewInternal", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{
  3.728551774371186*^9, {3.7288045982779627`*^9, 3.7288045997890487`*^9}, {
   3.820207302191681*^9, 3.8202073247537313`*^9}, {3.921306789703535*^9, 
   3.9213067903577843`*^9}, {3.921306917077553*^9, 3.921306917740778*^9}},
 CellLabel->
  "In[536]:=",ExpressionUUID->"fe764cd0-1244-4ef7-a787-a40f165d80af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexView", "[", "texcode", "]"}]], "Input",
 CellChangeTimes->{{3.728551755501939*^9, 3.7285517584176426`*^9}},
 CellLabel->
  "In[537]:=",ExpressionUUID->"a1336673-3b81-4592-b353-6c23f540347e"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Typesetting OK.\"\>"], "Print",
 CellChangeTimes->{
  3.728551801167562*^9, 3.728804571158411*^9, 3.7288046940084376`*^9, 
   3.728808863680546*^9, 3.777914018032892*^9, 3.7779140887954035`*^9, 
   3.791093807505283*^9, 3.7910939564376698`*^9, 3.820207210045453*^9, {
   3.820207306092151*^9, 3.820207330007614*^9}, 3.8202073694969883`*^9, 
   3.842762467215889*^9, 3.8443900092773533`*^9, 3.8443900794611855`*^9, 
   3.844390677577812*^9, 3.844391082658393*^9, 3.875891578202397*^9, 
   3.8758919968645353`*^9, {3.92130683513838*^9, 3.921306850519228*^9}, {
   3.921306909366186*^9, 3.921306952026989*^9}, 3.9584003436198654`*^9},
 CellLabel->
  "During evaluation of \
In[537]:=",ExpressionUUID->"f517bea6-a3cc-d44f-885e-58d07892ddd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Opening file: \"\>", "\[InvisibleSpace]", "\<\"TexActView\"\>",
    "\[InvisibleSpace]", "\<\".pdf\"\>"}],
  SequenceForm["Opening file: ", "TexActView", ".pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.728551801167562*^9, 3.728804571158411*^9, 3.7288046940084376`*^9, 
   3.728808863680546*^9, 3.777914018032892*^9, 3.7779140887954035`*^9, 
   3.791093807505283*^9, 3.7910939564376698`*^9, 3.820207210045453*^9, {
   3.820207306092151*^9, 3.820207330007614*^9}, 3.8202073694969883`*^9, 
   3.842762467215889*^9, 3.8443900092773533`*^9, 3.8443900794611855`*^9, 
   3.844390677577812*^9, 3.844391082658393*^9, 3.875891578202397*^9, 
   3.8758919968645353`*^9, {3.92130683513838*^9, 3.921306850519228*^9}, {
   3.921306909366186*^9, 3.921306952026989*^9}, 3.9584003436229*^9},
 CellLabel->
  "During evaluation of \
In[537]:=",ExpressionUUID->"aaa0bf04-79f3-a948-b9f6-5a07bb941127"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "/@", "$Tensors"}]], "Input",
 CellLabel->
  "In[538]:=",ExpressionUUID->"1dcdbf46-b62e-4943-9012-18778ad9a8dd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "T4"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T4],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwBGKJeVuUGna/cpRynaCwA0iLyGzXAtFTOq5/2Qmk/4uV
/wPR1/TMzI32vHJkuXRoc8D7V4513x4k3v32ylHjgvDcx99fOdZWzuZd/POV
44yKrxdfa712vM6XqsOc/dpRdPL1ZhDNMN1824Oe146/L0jvBdFK6uYT7Na9
dgx+cekXiJ6msmpf8NHXjo9qwx+HAemPKfH24UBa4dfKPyBa6SMLewSQ3veK
QRBEm+7vkwPR147+31UBpDelRs9UOP7acdb0ti2KQPpX2qNtLUBaJ9dj41Ig
7X1E5z2IntlUFq144rWjWdGhLBDN5/6tWBlI5/Q6Tzmj+sbRNkBmLojWnPaV
9YPdG8eArZMkQHTKbqfe8rI3jqxyhgtB9Jq76XdqFr5xXMyn1T99yRtH34Iv
00G029fNj0B028ww0RlAevFLd/21D9449iyfkwyi97RtX+xj/tbxyCPGlSDa
4PrXVTx1bx0BuKvWKg==
  "],
 CellLabel->
  "During evaluation of \
In[538]:=",ExpressionUUID->"8ff311c3-91d0-3345-a6c3-bbc32ddb6a2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\[CapitalSigma]2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`\[CapitalSigma]2],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwBGKJeVuUGna/cpRynaCwA0iLyGzXAtFTOq5/2Qmk/4uV
/wPR1/TMzI32vHJkuXRoc8D7V4513x4k3v32ylHjgvDcx99fOdZWzuZd/POV
44yKrxdfa712vM6XqsOc/dpRdPL1ZhDNMN1824Oe146/L0jvBdFK6uYT7Na9
dgx+cekXiJ6msmpf8NHXjo9qwx+HAemPKfH24UBa4dfKPyBa6SMLewSQ3veK
QRBEm+7vkwPR147+31UBpDelRs9UOP7acdb0ti2KQPpX2qNtLUBaJ9dj41Ig
7X1E5z2IntlUFq144rWjWdGhLBDN5/6tWBlI5/Q6Tzmj+sbRNkBmLojWnPaV
9YPdG8eArZMkQHTKbqfe8rI3jqxyhgtB9Jq76XdqFr5xXMyn1T99yRtH34Iv
00G029fNj0B028ww0RlAevFLd/21D9449iyfkwyi97RtX+xj/tbxyCPGlSA6
JevbKp66t44At1bV8g==
  "],
 CellLabel->
  "During evaluation of \
In[538]:=",ExpressionUUID->"1da9fc9b-0ebf-8f4a-bd7f-94fbaacb3da5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwBGKJeVuUGna/cpRynaCwA0iLyGzXAtEJHDe+7ATS/8XK
/4Hoa3pm5kZ7XjmyXDq0OeD9K8dMj4eJd7+9ctS4IDz38fdXjrWVs3kX/3zl
2HLq68XXWq8dDyak6jBnv3ZkeHq9GUxPN9/2oOe14zMlmb0g2mqq+QS7da8d
3ZIv/wLR01RW7Qs++tpR71/44zAg/TEl3j4cSCv8WvkHRCsVsrJHAOl9rxgE
QbSQQ78ciL529P+uCiDNdyZ6psLx146zprdtUQTSv5492tYCpHVyPTYuBdLe
R3Teg+hPu8uiFU+8djyw+VAWiF57+VuxMpDO43WZckb1jaNVgOxcEG047Rvr
B7s3jgGmkyVAtJuoc2952RtHnQmGC0H0vISMOzUL3zjKRWj1T1/yxpHt85fp
INovfMsjEG31Okx0BpC2j/HQX/vgjaPTzznJIHqB4I7FPuZvHae4MK0E0TP2
fFvFU/fWEQAbEtHp
  "],
 CellLabel->
  "Out[538]=",ExpressionUUID->"3ce7b7b7-8583-7040-9b21-b40a68d9a387"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "M4", "]"}]], "Input",
 CellLabel->
  "In[539]:=",ExpressionUUID->"36c4714e-d3a2-44b8-95c5-20a4e81b66cf"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M4",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM4,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM4],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwBuIP4QZCgZteOc57YCIBooVktys17H7luPrwZIUdQJpv
9k4tED2l/u2XnUD6mGjVPxB9Ya2FudGeV47/Ao5uDnj/yvFW6+PEu99eOc7g
FZv7+Psrx3fb5vIu/vnK8UHkj4uvtV47nnuaocOc/dpRKet2M4g2OWW17UHP
a8dPP+X3gugLMxwn2K177bj1za1fIFotat2+4KOvHZc0xj0OA9LnGtPsw4H0
jqcb/4DokDvc7BFAOvQSuyCI3rJ6qhyI3qbJtrsCSE8ISJqpcBxo3/+eLYpA
esKul9tagHRtiM/GpUBaVMP4PYh+klgVrXjitWPO4mNZIFpL/H+xMpAu5/Wb
ckb1jaN/gPpcEL34DQPbB7s3jmXXZ0uA6Hms7r3lZW8cv1mbLgTRPJez79Qs
fOMYoKPXP33JG8eS2B/TQTS/zY5HIDpCMFp0BpB+ctpHf+2DN47ywQuSQXSG
+p7FPuZvHR90sK8E0So//q3iqXvrCAA8R94M
  "],
 CellLabel->
  "During evaluation of \
In[539]:=",ExpressionUUID->"ecb62e5e-4cd5-3245-8484-ae51dfb0b51f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M4"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M4],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwBuIP4QZCgZteOc57YCIBooVktys17H7luPrwZIUdQJpv
9k4tED2l/u2XnUD6mGjVPxB9Ya2FudGeV47/Ao5uDnj/yvFW6+PEu99eOc7g
FZv7+Psrx3fb5vIu/vnK8UHkj4uvtV47nnuaocOc/dpRKet2M4g2OWW17UHP
a8dPP+X3gugLMxwn2K177bj1za1fIFotat2+4KOvHZc0xj0OA9LnGtPsw4H0
jqcb/4DokDvc7BFAOvQSuyCI3rJ6qhyI3qbJtrsCSE8ISJqpcBxo3/+eLYpA
esKul9tagHRtiM/GpUBaVMP4PYh+klgVrXjitWPO4mNZIFpL/H+xMpAu5/Wb
ckb1jaN/gPpcEL34DQPbB7s3jmXXZ0uA6Hms7r3lZW8cv1mbLgTRPJez79Qs
fOMYoKPXP33JG8eS2B/TQTS/zY5HIDpCMFp0BpB+ctpHf+2DN47ywQuSQXSG
+p7FPuZvHR90sK8E0So//q3iqXvrCAA8R94M
  "],
 CellLabel->
  "During evaluation of \
In[539]:=",ExpressionUUID->"ab1b1195-60f5-6240-8bee-3e5372bee67e"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{949, 461},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
DockedCells->{},
ShowSelection->True,
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"12471620-93bd-4828-ae6e-38dc3e33b564"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 112, 2, 96, "Title",ExpressionUUID->"e0881279-da07-4a4a-91d8-4d2999f73966"],
Cell[694, 26, 202, 7, 52, "Subtitle",ExpressionUUID->"0b8d0559-8138-4d1b-8b4c-9cdfdda986b9"],
Cell[899, 35, 807, 15, 138, "Subsubtitle",ExpressionUUID->"46f9f6ce-e596-4c28-8549-1d90f80a366a"],
Cell[1709, 52, 911, 24, 143, "Text",ExpressionUUID->"2e87b620-7419-4a9d-aab1-ee836d2456bb"],
Cell[CellGroupData[{
Cell[2645, 80, 129, 2, 66, "Section",ExpressionUUID->"e9eccd9b-f825-49d6-a634-9f0abf3e9ee2"],
Cell[CellGroupData[{
Cell[2799, 86, 165, 3, 28, "Input",ExpressionUUID->"cd96d29b-6f86-4aab-a8d0-9e2c278d5c17"],
Cell[2967, 91, 1785, 27, 32, "Output",ExpressionUUID->"dc23b94e-6e36-7e4c-9f72-de8dbf2eced9"]
}, Open  ]],
Cell[4767, 121, 1978, 35, 63, "Input",ExpressionUUID->"e3e58c99-fae0-43de-9df5-19758902ebd8",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[6770, 160, 91, 0, 53, "Subsection",ExpressionUUID->"41c144d8-fd2c-4aa9-85e6-12503a2beb33"],
Cell[6864, 162, 159, 3, 33, "Text",ExpressionUUID->"24fb36e6-bfca-4b1b-ae7f-8c46fd106ecd"]
}, Closed]],
Cell[CellGroupData[{
Cell[7060, 170, 85, 0, 37, "Subsection",ExpressionUUID->"38f7abb1-b4fd-4d1d-a999-f56042da9d2f"],
Cell[7148, 172, 3629, 76, 386, "Input",ExpressionUUID->"8130e9a2-ffb1-4f73-8459-58f61d561f54",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[10814, 253, 94, 0, 37, "Subsection",ExpressionUUID->"4393db84-b034-4142-974c-e10ab6afb6bb"],
Cell[10911, 255, 939, 36, 449, "Input",ExpressionUUID->"cd3ddec4-24fe-473c-9d4e-c462fa26328f",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[11887, 296, 94, 0, 37, "Subsection",ExpressionUUID->"eb7c220d-7898-4a5b-a23a-e83788e84208"],
Cell[11984, 298, 102, 0, 33, "Text",ExpressionUUID->"460d065f-dbc0-4d06-9fec-bee0384939f2"],
Cell[12089, 300, 419, 11, 63, "Input",ExpressionUUID->"9954ddef-8280-4a96-92a0-6a9836c765e4",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[12533, 315, 136, 1, 28, "Input",ExpressionUUID->"6ae8e6b3-afc0-4767-a9bf-85a2b0294a5a"],
Cell[12672, 318, 1528, 22, 70, "Output",ExpressionUUID->"773fbbf0-739a-d342-b366-8eb72c317f01"]
}, Open  ]],
Cell[14215, 343, 273, 11, 33, "Text",ExpressionUUID->"b5b9d2aa-0d4a-4d23-9b11-84a7a9fd9b2d"],
Cell[CellGroupData[{
Cell[14513, 358, 339, 8, 44, "Input",ExpressionUUID->"9c2ee48c-f31b-4511-abf9-709c9b2e57ac",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[14877, 370, 942, 15, 70, "Print",ExpressionUUID->"729627bc-b88a-1f4e-b3d7-dba39a18e910"],
Cell[15822, 387, 1212, 23, 70, "Print",ExpressionUUID->"6b2c7d2f-569b-5b42-8ec9-a82f44106ec6"],
Cell[17037, 412, 961, 15, 70, "Print",ExpressionUUID->"76c8fcf6-6b25-674d-baa6-feaf88553b07"],
Cell[18001, 429, 920, 14, 70, "Print",ExpressionUUID->"eec7ede3-2fc3-814e-af5b-69421d51856d"],
Cell[18924, 445, 901, 14, 70, "Print",ExpressionUUID->"2a55a3b7-134a-8a41-ad9c-a97810998a16"],
Cell[19828, 461, 939, 15, 70, "Print",ExpressionUUID->"db7ae28a-d9a5-ac49-a7a6-4aca0f65b012"],
Cell[20770, 478, 1217, 23, 70, "Print",ExpressionUUID->"32e6d1e3-650e-1a40-8e1a-4653fb118907"],
Cell[21990, 503, 960, 15, 70, "Print",ExpressionUUID->"98d08456-81b4-fe47-926e-89ab158a4a7d"]
}, Open  ]],
Cell[22965, 521, 1622, 23, 70, "Output",ExpressionUUID->"3604b366-bad9-2947-9233-4ec0a8adfdc1"]
}, Open  ]],
Cell[24602, 547, 179, 5, 33, "Text",ExpressionUUID->"270a4b92-8294-4842-a48a-d795a42e496e"],
Cell[24784, 554, 666, 18, 63, "Input",ExpressionUUID->"8b7a7e8f-21e0-44f4-b33e-d87debd1156a",
 InitializationCell->True],
Cell[25453, 574, 79, 0, 33, "Text",ExpressionUUID->"2cdcf8f9-dad3-484e-9c18-ce3b9c87bc00"],
Cell[CellGroupData[{
Cell[25557, 578, 876, 19, 120, "Input",ExpressionUUID->"3794754e-8740-4d2d-a65f-2c74d151e490",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[26458, 601, 1713, 26, 70, "Print",ExpressionUUID->"a78aec27-0218-4741-9f10-c89a9b02bd1d"],
Cell[28174, 629, 1985, 34, 70, "Print",ExpressionUUID->"6b44a4a9-1fc7-2e4f-b361-cc995e758fe4"],
Cell[30162, 665, 1783, 27, 70, "Print",ExpressionUUID->"e6d9df7d-17dc-834f-94a9-8265c36f3aa8"]
}, Open  ]]
}, Open  ]],
Cell[31972, 696, 238, 4, 55, "Text",ExpressionUUID->"eda21b64-e275-42fc-b2c4-786afb37e5ef"],
Cell[32213, 702, 1735, 28, 367, "Input",ExpressionUUID->"e93e99a1-fcc8-43ec-a409-89f406e422b6",
 InitializationCell->True],
Cell[33951, 732, 143, 2, 33, "Text",ExpressionUUID->"a3830b80-712b-4639-ad55-94630fcffd26"],
Cell[CellGroupData[{
Cell[34119, 738, 861, 19, 177, "Input",ExpressionUUID->"9268fe77-46cf-4d3d-b674-b2732878bb63",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[35005, 761, 1696, 26, 70, "Print",ExpressionUUID->"dbc209c2-851c-504c-b56a-8d3cc1047ea0"],
Cell[36704, 789, 1853, 28, 70, "Print",ExpressionUUID->"0991fa9e-b3f6-434f-b8b1-41173f74c816"],
Cell[38560, 819, 1696, 26, 70, "Print",ExpressionUUID->"ba8a07ce-ff61-ec42-b9ae-3e365d80d592"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40317, 852, 96, 0, 37, "Subsection",ExpressionUUID->"1b0304e1-a9be-4b57-a339-23b1fe955c4e"],
Cell[40416, 854, 16295, 366, 2803, "Input",ExpressionUUID->"f680fbcd-75c0-48e6-905e-0393974f1e4c",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[56748, 1225, 103, 0, 37, "Subsection",ExpressionUUID->"bc355029-52ca-4a2d-9c7a-3472eb7c75bc"],
Cell[CellGroupData[{
Cell[56876, 1229, 184, 4, 44, "Input",ExpressionUUID->"dcf3a5f4-7473-4a52-a72d-21a3b8feeea7",
 InitializationCell->True],
Cell[57063, 1235, 1652, 24, 70, "Output",ExpressionUUID->"83e37303-2d6e-3844-8b86-1f07d5d4ac41"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58776, 1266, 122, 2, 66, "Section",ExpressionUUID->"d1b9726f-1155-4170-b8a2-2848a514dd15"],
Cell[CellGroupData[{
Cell[58923, 1272, 108, 0, 53, "Subsection",ExpressionUUID->"8109d6e6-8186-421a-8b5c-0b98eb41363f"],
Cell[59034, 1274, 108, 0, 33, "Text",ExpressionUUID->"ac1a6da4-daab-4756-9df3-106b447760b8"],
Cell[59145, 1276, 398, 8, 77, "Text",ExpressionUUID->"4073dc58-daa0-45bd-a344-8f8635d187fe"],
Cell[59546, 1286, 1611, 28, 121, "Text",ExpressionUUID->"aae7169c-fe09-49f9-98f9-40b86c14ce9b"],
Cell[61160, 1316, 415, 8, 44, "Input",ExpressionUUID->"ca8bd73f-cc8f-4d97-980d-0d4dfd2327db",
 InitializationCell->True],
Cell[61578, 1326, 745, 18, 82, "Input",ExpressionUUID->"10654146-f54c-4397-8e79-be1f416e6530",
 InitializationCell->True],
Cell[62326, 1346, 651, 18, 63, "Input",ExpressionUUID->"f91669ac-0b40-4345-98dc-481b5e94164a",
 InitializationCell->True],
Cell[62980, 1366, 1606, 39, 158, "Input",ExpressionUUID->"9349a50a-4a21-4485-b8b5-fe77066874cf",
 InitializationCell->True],
Cell[64589, 1407, 2658, 79, 348, "Input",ExpressionUUID->"0f9115a4-615a-475f-8fb1-a2232303bcb8",
 InitializationCell->True],
Cell[67250, 1488, 623, 19, 82, "Input",ExpressionUUID->"dbf513dd-d1c0-423e-bf16-4fe42b26e16a",
 InitializationCell->True],
Cell[67876, 1509, 469, 13, 82, "Input",ExpressionUUID->"83c5c553-48b6-4c7e-9f7a-c4efe900a3e1",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[68382, 1527, 95, 0, 37, "Subsection",ExpressionUUID->"cc430464-7283-4200-b40c-a9f452aeb9ac"],
Cell[68480, 1529, 531, 7, 121, "Text",ExpressionUUID->"03a37158-9e9a-449a-97a7-c7d078428b2a"],
Cell[69014, 1538, 1916, 48, 215, "Input",ExpressionUUID->"e1ae01c9-57d9-4ec0-8e54-869d79f58526",
 InitializationCell->True],
Cell[70933, 1588, 6720, 147, 729, "Input",ExpressionUUID->"577b9972-74c7-4e0b-88ff-d46640381077",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[77690, 1740, 108, 0, 37, "Subsection",ExpressionUUID->"9c261caa-46c6-46df-898a-808577c96786"],
Cell[77801, 1742, 191, 3, 55, "Text",ExpressionUUID->"28d1afb5-6250-43d5-b0d9-9226c34ca9ab"],
Cell[77995, 1747, 4997, 150, 465, "Input",ExpressionUUID->"2de6adbe-1710-477c-995a-b6e5b738f7cd"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83041, 1903, 126, 2, 66, "Section",ExpressionUUID->"c134f083-93e5-4e8e-bd7c-f0a1dd86faff"],
Cell[CellGroupData[{
Cell[83192, 1909, 98, 0, 53, "Subsection",ExpressionUUID->"a9e39fd1-11a6-4f6b-a5aa-2180390641cd"],
Cell[83293, 1911, 384, 8, 15776, "Text",ExpressionUUID->"e54eb1b8-5fcb-4e0b-b056-f06fcbb085e6"],
Cell[83680, 1921, 333, 10, 16905, "Input",ExpressionUUID->"2c125385-57f0-4ad1-84f3-850e67d67f67",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[84050, 1936, 91, 0, 37, "Subsection",ExpressionUUID->"be55406d-d073-4f39-a3eb-673c7361d305"],
Cell[84144, 1938, 208, 3, 34, "Text",ExpressionUUID->"8dd21851-7809-4a50-a2e6-a109002300aa"],
Cell[CellGroupData[{
Cell[84377, 1945, 138, 3, 28, "Input",ExpressionUUID->"d8ec4062-9fd4-4b24-b7d4-ede3fcd0a8ee"],
Cell[84518, 1950, 9381, 232, 70, "Output",ExpressionUUID->"5da3ca3f-35c5-034f-9cf9-514226889028"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93936, 2187, 143, 3, 28, "Input",ExpressionUUID->"c6b8fdb1-a4ab-4f18-a2a7-b0febaa451c4"],
Cell[94082, 2192, 9425, 232, 70, "Output",ExpressionUUID->"7f372ac1-825f-0947-8c5e-53563c9a520b"]
}, Open  ]],
Cell[103522, 2427, 475, 12, 82, "Input",ExpressionUUID->"90fe1d75-9328-4542-a18f-5995304e5979",
 InitializationCell->True],
Cell[104000, 2441, 229, 3, 57, "Text",ExpressionUUID->"b14f01b9-9ae6-4bf5-b872-a2324d23ac80"],
Cell[104232, 2446, 1081, 24, 82, "Input",ExpressionUUID->"bceae0a3-9cd6-4710-9a5e-170877d2c684",
 InitializationCell->True],
Cell[105316, 2472, 342, 7, 34, "Text",ExpressionUUID->"5e07f0c3-6e28-458d-a07a-90708d3c1e27"],
Cell[105661, 2481, 2674, 65, 157, "Code",ExpressionUUID->"063e1fcf-68ef-49a1-85fa-16168535af69"],
Cell[108338, 2548, 255, 4, 34, "Text",ExpressionUUID->"bad3f35d-a647-401a-b349-cd82e6b6dc6d"],
Cell[108596, 2554, 1783, 46, 177, "Input",ExpressionUUID->"1c6acd26-42de-49b6-8eaa-3a2465fde7da",
 InitializationCell->True],
Cell[110382, 2602, 110, 0, 34, "Text",ExpressionUUID->"2d56a606-6efe-4121-ae16-4a7d3f52a19a"],
Cell[110495, 2604, 551, 16, 64, "Input",ExpressionUUID->"816ff93a-13b5-4911-9341-b78e1a052a09",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[111083, 2625, 89, 0, 37, "Subsection",ExpressionUUID->"a2920021-0310-4437-9b6a-142aa3cf10ba"],
Cell[111175, 2627, 1999, 58, 177, "Input",ExpressionUUID->"9308bb6a-8391-47bc-b875-381b6d380fcc",
 InitializationCell->True],
Cell[113177, 2687, 129, 0, 33, "Text",ExpressionUUID->"47758250-fa33-4c77-bb98-ae790243b978"],
Cell[113309, 2689, 870, 27, 120, "Input",ExpressionUUID->"e2ec4615-70ff-4c9e-9a47-0159b263ec88",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[114216, 2721, 221, 4, 37, "Subsection",ExpressionUUID->"3f0da5d7-71f3-4a00-b1dc-f8069beb6b98"],
Cell[114440, 2727, 272, 6, 33, "Text",ExpressionUUID->"bb0be36a-1d66-4c2e-ae13-03ff34e8fa8a"],
Cell[114715, 2735, 335, 9, 44, "Input",ExpressionUUID->"19da7b3c-4ea6-4f5a-927e-22c44c11c61a",
 InitializationCell->True],
Cell[115053, 2746, 189, 3, 33, "Text",ExpressionUUID->"4872346d-81ae-4839-b3e6-9791daac60e6"],
Cell[115245, 2751, 862, 23, 101, "Input",ExpressionUUID->"7fa99e04-ebcc-4741-8537-4521ace5ff22",
 InitializationCell->True],
Cell[116110, 2776, 341, 7, 55, "Text",ExpressionUUID->"198978a3-234f-4260-8121-c11017fa95af"],
Cell[116454, 2785, 689, 18, 102, "Code",ExpressionUUID->"6a375090-6fd0-4aec-8bd7-e27e232787eb"],
Cell[117146, 2805, 362, 7, 33, "Text",ExpressionUUID->"18533039-5cfb-cc4d-9dd0-a804366c9643"],
Cell[117511, 2814, 492, 13, 85, "Code",ExpressionUUID->"fadc5880-6e73-b44c-8446-f16a6de022dd"],
Cell[118006, 2829, 214, 4, 33, "Text",ExpressionUUID->"ee027e4e-71fe-4b63-bcf3-3d3b28b11d33"],
Cell[118223, 2835, 256, 7, 44, "Input",ExpressionUUID->"3920d4df-70f3-4a43-aa4b-83a68984fe33",
 InitializationCell->True],
Cell[118482, 2844, 336, 5, 33, "Text",ExpressionUUID->"e5c39014-20a8-45eb-9339-9cf37c5a65e3"],
Cell[118821, 2851, 1166, 30, 120, "Input",ExpressionUUID->"37281370-f6d0-4919-923b-e2074d3ecf73",
 InitializationCell->True],
Cell[119990, 2883, 280, 6, 33, "Text",ExpressionUUID->"bc8dcf51-1713-4e2d-a5cc-a92b59193b5c"],
Cell[120273, 2891, 1359, 35, 101, "Input",ExpressionUUID->"95f06ef9-1d12-4d95-afca-ccc80b94ecea",
 InitializationCell->True],
Cell[121635, 2928, 1858, 55, 120, "Input",ExpressionUUID->"be90a0a1-80f5-4a9b-a2b4-c6f10cf83de9",
 InitializationCell->True],
Cell[123496, 2985, 10081, 280, 615, "Input",ExpressionUUID->"fb1ca26a-671c-4a24-ac84-32c26089defc",
 InitializationCell->True],
Cell[133580, 3267, 790, 24, 82, "Input",ExpressionUUID->"5dffb62e-b79e-44a0-b3a5-cf71f960c45d",
 InitializationCell->True],
Cell[134373, 3293, 517, 9, 33, "Text",ExpressionUUID->"63001d3c-e2d2-d344-86a7-2ca68aba38d8"],
Cell[134893, 3304, 691, 20, 63, "Input",ExpressionUUID->"2627ffa4-0ba5-4342-aa65-e0f7e2d68a5f",
 InitializationCell->True],
Cell[135587, 3326, 217, 4, 33, "Text",ExpressionUUID->"cb1934dd-ec1b-4b40-a6fb-6e4468814c9d"],
Cell[135807, 3332, 219, 5, 33, "Text",ExpressionUUID->"712f79ee-8910-4512-9718-00cbdcdeb0a8"],
Cell[136029, 3339, 1699, 41, 123, "Input",ExpressionUUID->"1ce20ad8-c3e2-4225-9eb4-f11b9a7616dd",
 Evaluatable->False],
Cell[137731, 3382, 214, 4, 33, "Text",ExpressionUUID->"ddbd035a-0318-47a9-a668-1fe83b49a02a"],
Cell[137948, 3388, 331, 8, 28, "Input",ExpressionUUID->"1ff53f55-7f9d-415f-9e91-e2892c322671",
 Evaluatable->False],
Cell[138282, 3398, 809, 14, 77, "Text",ExpressionUUID->"e77d8003-fef3-45c3-b432-5314961a6afe"],
Cell[139094, 3414, 978, 26, 85, "Input",ExpressionUUID->"a80991d2-e070-4404-be14-004873b8d95b",
 Evaluatable->False],
Cell[140075, 3442, 6002, 153, 389, "Input",ExpressionUUID->"035ba010-f12a-4a43-a39d-f18f53a76841",
 Evaluatable->False]
}, Closed]],
Cell[CellGroupData[{
Cell[146114, 3600, 91, 0, 37, "Subsection",ExpressionUUID->"3973b9e0-9e95-4479-aa8b-59ddf59fdc2b"],
Cell[146208, 3602, 2485, 73, 348, "Input",ExpressionUUID->"d249f157-8a0c-4e92-badf-9d2b35a24e1c",
 InitializationCell->True],
Cell[148696, 3677, 354, 7, 34, "Text",ExpressionUUID->"f170c925-019e-4261-b861-ccf141c13e68",
 InitializationCell->True],
Cell[149053, 3686, 2057, 55, 120, "Input",ExpressionUUID->"7904d897-0b18-44e9-a72a-40c54c31187e",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[151147, 3746, 89, 0, 37, "Subsection",ExpressionUUID->"9c1d7be7-c3bf-46e3-bf3d-a32b43d500b7"],
Cell[151239, 3748, 114, 0, 33, "Text",ExpressionUUID->"761dcef7-0a70-455f-980d-fc39468cbb6a"],
Cell[151356, 3750, 667, 18, 63, "Input",ExpressionUUID->"f3368a15-310a-4444-976c-a49524be9895",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[152060, 3773, 89, 0, 37, "Subsection",ExpressionUUID->"3bff6572-8474-47a4-b96d-89d32186e9c1"],
Cell[152152, 3775, 404, 8, 213, "Text",ExpressionUUID->"a50bd4a9-5f2c-4b33-bc1b-c54097ca9d3f"],
Cell[152559, 3785, 461, 12, 164, "Input",ExpressionUUID->"84c63f21-15b6-4b70-bb16-c87432bac1f9",
 InitializationCell->True],
Cell[153023, 3799, 289, 6, 213, "Text",ExpressionUUID->"28956fc1-a9ea-4504-8e8c-848ba651b96e"],
Cell[153315, 3807, 317, 8, 164, "Input",ExpressionUUID->"358830e1-96da-4f41-968a-2a11a00e7961",
 InitializationCell->True],
Cell[153635, 3817, 532, 13, 243, "Input",ExpressionUUID->"b6f45586-45ae-4f42-bb55-c59c29c1eefb",
 InitializationCell->True],
Cell[154170, 3832, 121, 0, 129, "Text",ExpressionUUID->"1e03b6a7-4c6c-467e-a04c-cca5519c8d5d"],
Cell[154294, 3834, 2592, 71, 840, "Input",ExpressionUUID->"ac005b47-5e56-489f-8b7e-575073df3674",
 Evaluatable->False],
Cell[156889, 3907, 125, 0, 129, "Text",ExpressionUUID->"cda374a8-213f-4b2e-9579-54e82fb27947"],
Cell[157017, 3909, 4650, 126, 1854, "Input",ExpressionUUID->"04014627-75dd-4ec4-a518-e79327f5b716",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[161704, 4040, 91, 0, 37, "Subsection",ExpressionUUID->"fdc34e0e-f9ac-412e-a125-6079b5b3dbda"],
Cell[161798, 4042, 719, 14, 126, "Text",ExpressionUUID->"b6c92e07-86b4-4b8b-b025-aba50a20af36"],
Cell[162520, 4058, 1451, 39, 177, "Input",ExpressionUUID->"9df04169-d295-4134-ad05-f9f379038385",
 InitializationCell->True],
Cell[163974, 4099, 789, 21, 64, "Input",ExpressionUUID->"6e483e84-69b2-41e7-9c26-00f7fe80a549",
 InitializationCell->True],
Cell[164766, 4122, 1221, 34, 121, "Input",ExpressionUUID->"b83ae2b4-a767-4e0c-b41d-c19c68309c39",
 InitializationCell->True],
Cell[165990, 4158, 1880, 52, 178, "Input",ExpressionUUID->"d614bfcf-f099-4b1e-9f15-9c9c55ce8cc2",
 InitializationCell->True],
Cell[167873, 4212, 201, 5, 44, "Input",ExpressionUUID->"55bab7b3-5847-4ff0-8036-3193d11482d5",
 InitializationCell->True],
Cell[168077, 4219, 1018, 28, 140, "Input",ExpressionUUID->"983c113a-a894-49d0-a5b9-dc113fbd4f40",
 InitializationCell->True],
Cell[169098, 4249, 853, 24, 83, "Input",ExpressionUUID->"758940b9-9bb9-49f9-904c-3fd1936ef121",
 InitializationCell->True],
Cell[169954, 4275, 1025, 29, 82, "Input",ExpressionUUID->"3a9bda42-7901-4199-9527-1e92b308df08",
 InitializationCell->True],
Cell[170982, 4306, 144, 2, 34, "Text",ExpressionUUID->"08843d05-9bd7-476d-aafa-0a59d29ed0e4"],
Cell[171129, 4310, 645, 20, 82, "Input",ExpressionUUID->"9ae5b557-ef7a-4552-8071-466ae4fa0ddb",
 InitializationCell->True],
Cell[171777, 4332, 2400, 64, 235, "Input",ExpressionUUID->"d67e162d-f7c0-457d-9595-9254dac16c97",
 InitializationCell->True],
Cell[174180, 4398, 5069, 144, 274, "Input",ExpressionUUID->"1b079d80-166f-4246-97b6-8b8beb7a56c3",
 InitializationCell->True],
Cell[179252, 4544, 1147, 31, 101, "Input",ExpressionUUID->"5f693c2e-c053-42cb-af53-4b15394dafe8",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[180436, 4580, 142, 3, 37, "Subsection",ExpressionUUID->"ccb50393-d7fb-428d-a398-10db3c74e6d5"],
Cell[180581, 4585, 175, 4, 9629, "Input",ExpressionUUID->"1e7ced2b-fce5-4896-87f4-08cf5e16e5ca",
 InitializationCell->True],
Cell[180759, 4591, 269, 6, 9393, "Text",ExpressionUUID->"acd0da8d-4b7c-4b39-8f8e-6faf901c33fa"],
Cell[181031, 4599, 428, 11, 9629, "Input",ExpressionUUID->"a7d97eab-9e04-45f0-bf7f-ae5821ad29c8",
 InitializationCell->True],
Cell[181462, 4612, 481, 12, 9629, "Input",ExpressionUUID->"087ad6f0-0a0d-4df4-a6b2-4c71241d439a",
 InitializationCell->True],
Cell[181946, 4626, 1833, 55, 36731, "Input",ExpressionUUID->"ac8f0fc4-1b24-499a-8a81-902ffd2465ec",
 InitializationCell->True],
Cell[183782, 4683, 1153, 34, 23508, "Input",ExpressionUUID->"086ccb24-c9e6-4f59-a692-d2cec58d9712",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[184972, 4722, 136, 3, 37, "Subsection",ExpressionUUID->"b9c1bd29-032d-433e-9323-b16b38a4db32"],
Cell[185111, 4727, 115, 0, 129, "Text",ExpressionUUID->"7ab4b7c3-4e82-44e1-90d8-1ce1d84d5269"],
Cell[CellGroupData[{
Cell[185251, 4731, 844, 23, 254, "Input",ExpressionUUID->"c0cdd6aa-0113-42f9-9692-0d21a597e2ca",
 Evaluatable->False],
Cell[186098, 4756, 430, 10, 83, "Print",ExpressionUUID->"a0ca6f70-552d-418e-a550-0b6a2ef103fd"]
}, Open  ]],
Cell[186543, 4769, 134, 0, 129, "Text",ExpressionUUID->"fdd7276f-7982-401c-ad70-c2769580659f"],
Cell[186680, 4771, 693, 18, 243, "Input",ExpressionUUID->"693a37ae-7363-45e3-8bc8-4a91a74798b0",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[187410, 4794, 172, 3, 37, "Subsection",ExpressionUUID->"db4503e9-5519-442d-b601-6f012da8ea7e"],
Cell[187585, 4799, 2402, 65, 196, "Input",ExpressionUUID->"1448c191-c1f1-4dff-bd34-d38579d904a3",
 InitializationCell->True],
Cell[189990, 4866, 2205, 57, 140, "Input",ExpressionUUID->"864e8efd-8eee-411b-8e17-4d270306936d",
 InitializationCell->True],
Cell[192198, 4925, 1176, 33, 101, "Input",ExpressionUUID->"06199b68-0459-47a0-89a0-d09fda83c9fc",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[193411, 4963, 141, 3, 37, "Subsection",ExpressionUUID->"a1dc0b28-d5eb-46cf-aad2-71a49a8a2f53"],
Cell[193555, 4968, 677, 19, 64, "Input",ExpressionUUID->"93ee7daf-57f5-404d-9090-1842282b7ecb",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[194269, 4992, 148, 3, 37, "Subsection",ExpressionUUID->"e8d5844b-cb51-4d9f-a413-8e5497b77f1f"],
Cell[194420, 4997, 934, 25, 43316, "Input",ExpressionUUID->"d95c42cb-715e-41dd-8763-5b8adf2eb385",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[195391, 5027, 151, 3, 37, "Subsection",ExpressionUUID->"608a8787-fec7-49bf-9558-db6e01a084c3"],
Cell[195545, 5032, 2758, 72, 63233, "Input",ExpressionUUID->"af38f09b-6f3b-4c1c-aa48-059e1bb554b6",
 InitializationCell->True],
Cell[198306, 5106, 978, 27, 29909, "Input",ExpressionUUID->"e5b05be7-c00e-4f9a-a0e7-023628513ff2"]
}, Closed]],
Cell[CellGroupData[{
Cell[199321, 5138, 210, 4, 37, "Subsection",ExpressionUUID->"e4652de8-278d-4d22-81f6-1fc50c10b296"],
Cell[199534, 5144, 653, 17, 16905, "Input",ExpressionUUID->"bda37ad5-b0c0-4deb-bfac-8d39b54cc112",
 InitializationCell->True],
Cell[200190, 5163, 716, 18, 16905, "Input",ExpressionUUID->"32aa9a74-bc5c-42f2-9b89-e3bec221d2c1",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[200943, 5186, 152, 3, 37, "Subsection",ExpressionUUID->"7f6b9329-1025-4dca-9e01-95b276471b25"],
Cell[201098, 5191, 2506, 68, 76378, "Input",ExpressionUUID->"6d9c445a-b1e5-4641-83fe-ede0c88499bb",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[203641, 5264, 263, 5, 37, "Subsection",ExpressionUUID->"e302008e-6ac4-4e41-9709-84f682f298a5"],
Cell[203907, 5271, 852, 22, 82, "Input",ExpressionUUID->"62d27083-30cc-43bc-bea9-70f27b2911a8",
 InitializationCell->True],
Cell[204762, 5295, 794, 22, 82, "Input",ExpressionUUID->"ef0aeec3-a116-4956-8855-2f14318ac1f7",
 InitializationCell->True],
Cell[205559, 5319, 868, 22, 82, "Input",ExpressionUUID->"b10ae447-219e-445c-894c-43bb5691445b",
 InitializationCell->True],
Cell[206430, 5343, 848, 22, 82, "Input",ExpressionUUID->"1081df14-4808-46f5-abb8-4ffeb2a5d0a9",
 InitializationCell->True],
Cell[207281, 5367, 923, 23, 82, "Input",ExpressionUUID->"c98a1307-09f9-4431-9c1c-88390a39e499",
 InitializationCell->True],
Cell[208207, 5392, 718, 20, 82, "Input",ExpressionUUID->"f8b2ac60-5992-4240-b6a5-5317848d33d4",
 InitializationCell->True],
Cell[208928, 5414, 445, 11, 50, "Code",ExpressionUUID->"d4fcf8d3-1e1b-4fbc-9a53-408842e9b161"]
}, Closed]],
Cell[CellGroupData[{
Cell[209410, 5430, 104, 0, 37, "Subsection",ExpressionUUID->"e2b7e8ac-5584-426a-80b5-4a9dab921c4f"],
Cell[209517, 5432, 212, 6, 44, "Input",ExpressionUUID->"1d830e06-524f-4287-b6a0-4696ceb9db6b",
 InitializationCell->True],
Cell[209732, 5440, 1755, 36, 101, "Input",ExpressionUUID->"7aa86cf1-727d-4a96-9e49-8a568d5abea1",
 InitializationCell->True],
Cell[211490, 5478, 573, 16, 64, "Input",ExpressionUUID->"a8ed8c09-28cb-4c6f-9561-c81be43c5ff7",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[212100, 5499, 187, 3, 37, "Subsection",ExpressionUUID->"09942665-d371-47be-bfd7-761cc84c136e"],
Cell[212290, 5504, 2554, 61, 177, "Input",ExpressionUUID->"851ad325-571f-413e-91be-b287fc062478",
 InitializationCell->True],
Cell[214847, 5567, 1155, 33, 101, "Input",ExpressionUUID->"dceaefea-ba09-42fe-a4c1-4f2682d793cf",
 InitializationCell->True],
Cell[216005, 5602, 1153, 33, 101, "Input",ExpressionUUID->"9b7c2081-55a6-4270-835a-9273f1f4bb94",
 InitializationCell->True],
Cell[217161, 5637, 1149, 33, 101, "Input",ExpressionUUID->"5aedbe8c-d51c-44b2-b98b-789e9ece7960",
 InitializationCell->True],
Cell[218313, 5672, 167, 3, 33, "Text",ExpressionUUID->"db779c52-ab5a-480d-b394-6399a97eccd2"],
Cell[218483, 5677, 328, 8, 50, "Code",ExpressionUUID->"9ce7b9d3-9771-4df8-ac12-347e126f5370"]
}, Closed]],
Cell[CellGroupData[{
Cell[218848, 5690, 160, 3, 37, "Subsection",ExpressionUUID->"188cac56-ec18-434b-a469-b04c4d614c83"],
Cell[219011, 5695, 463, 8, 15776, "Text",ExpressionUUID->"01451bb6-586e-4343-a90b-b12d1a6a825a"],
Cell[219477, 5705, 512, 13, 9629, "Input",ExpressionUUID->"e1bd6282-181f-48f3-a974-a2c5566e6f3e",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[220026, 5723, 217, 4, 37, "Subsection",ExpressionUUID->"a989b3bd-be46-4d84-bb90-9d7f95f83612"],
Cell[220246, 5729, 212, 4, 9393, "Text",ExpressionUUID->"f890ad87-18d8-4b13-bd48-7e877b18bf52"],
Cell[220461, 5735, 1018, 26, 16028, "Input",ExpressionUUID->"907983a4-fde5-48f9-9a57-f97e0ba5ccce"],
Cell[221482, 5763, 1026, 26, 16028, "Input",ExpressionUUID->"de26f310-2738-477b-90fe-38aa27661665"],
Cell[222511, 5791, 209, 4, 9393, "Text",ExpressionUUID->"b65befdb-6ea0-4107-8334-2172b837acbb"],
Cell[222723, 5797, 2082, 51, 27723, "Input",ExpressionUUID->"55209a21-8d86-4930-83b2-b998c6fc6556",
 InitializationCell->True],
Cell[224808, 5850, 2185, 54, 27723, "Input",ExpressionUUID->"ba16ed4f-1e42-405e-bceb-6a2150713db4",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[227042, 5910, 195, 3, 66, "Section",ExpressionUUID->"0ecfef3e-3925-45d6-b79f-a1c01de56073"],
Cell[CellGroupData[{
Cell[227262, 5917, 105, 0, 53, "Subsection",ExpressionUUID->"3b36fc65-7f7c-41ac-904d-dc84f36233b1"],
Cell[227370, 5919, 735, 18, 16905, "Input",ExpressionUUID->"2ff84bf6-cf61-4ed1-b67a-075cfd980fca",
 InitializationCell->True],
Cell[228108, 5939, 792, 19, 16905, "Input",ExpressionUUID->"369ff1f9-3994-4c65-aaa1-e32fb49cb95f",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[228937, 5963, 89, 0, 37, "Subsection",ExpressionUUID->"0864d58f-4ccf-46fb-b738-810bdec0e64d"],
Cell[229029, 5965, 788, 13, 1016, "Text",ExpressionUUID->"dc562e28-2586-4a41-b105-cbf14acec1d5"],
Cell[229820, 5980, 1337, 32, 2056, "Input",ExpressionUUID->"eb6a1b8e-5dd6-4399-a5a6-95bd2db2659d",
 InitializationCell->True],
Cell[231160, 6014, 15628, 374, 10996, "Input",ExpressionUUID->"831f57a0-c756-44f2-b2f0-a61359382151",
 InitializationCell->True],
Cell[246791, 6390, 5955, 146, 5696, "Input",ExpressionUUID->"c84bfc37-09f4-4daa-aeca-4a0c6b02f540",
 InitializationCell->True],
Cell[252749, 6538, 2645, 65, 3178, "Input",ExpressionUUID->"a79f595c-d32d-44f9-b2fd-a51140fe9593",
 InitializationCell->True],
Cell[255397, 6605, 2752, 53, 3736, "Input",ExpressionUUID->"35ff1138-6882-4b2c-85c0-1f4c56e86d93",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[258198, 6664, 258, 4, 66, "Section",ExpressionUUID->"9a8428fe-356a-40a2-97ae-550cc6b3c1d9"],
Cell[CellGroupData[{
Cell[258481, 6672, 213, 4, 53, "Subsection",ExpressionUUID->"380127a2-c8c1-49c3-b899-71410cee71f0"],
Cell[258697, 6678, 854, 23, 23508, "Input",ExpressionUUID->"ac9c839f-5380-48b8-a1e5-fb9ca9b4ba83",
 InitializationCell->True],
Cell[259554, 6703, 2653, 64, 63233, "Input",ExpressionUUID->"fe9f0035-6650-48bd-895b-2acf5cf2aa28",
 InitializationCell->True],
Cell[262210, 6769, 712, 20, 23508, "Input",ExpressionUUID->"a6825211-ee25-46fe-b3dc-a7c4694d3ece",
 InitializationCell->True],
Cell[262925, 6791, 6977, 176, 135704, "Input",ExpressionUUID->"29de0b5e-79a1-4688-bf37-6a03e23194a0",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[269951, 6973, 185, 3, 66, "Section",ExpressionUUID->"f9e1ffe1-b04a-4846-bc74-a884a6711de2"],
Cell[CellGroupData[{
Cell[270161, 6980, 146, 3, 53, "Subsection",ExpressionUUID->"b17aac68-8a64-4a5b-8a0f-1d350d75b43e"],
Cell[270310, 6985, 268, 6, 33, "Text",ExpressionUUID->"fcd66f28-69e4-4b14-a530-7c2a438a50b8"],
Cell[270581, 6993, 1147, 34, 63, "Input",ExpressionUUID->"01a699ef-d89d-4698-80d7-5652a8b555ad",
 InitializationCell->True],
Cell[271731, 7029, 117, 0, 33, "Text",ExpressionUUID->"b5e18e40-23d4-4255-8ec2-202f208781a7"],
Cell[271851, 7031, 892, 24, 66, "Input",ExpressionUUID->"8b74c26b-5efb-4a25-898a-b815dffb2866",
 Evaluatable->False],
Cell[272746, 7057, 389, 8, 55, "Text",ExpressionUUID->"5e8dd041-e4ed-4a52-a90f-a1366d3d94fb"],
Cell[273138, 7067, 1006, 24, 82, "Input",ExpressionUUID->"913da0af-5240-46db-b40b-92e6080ccc25",
 InitializationCell->True],
Cell[274147, 7093, 13103, 313, 729, "Input",ExpressionUUID->"d47f80bc-04b1-4f80-9770-b13526e2c306",
 InitializationCell->True],
Cell[287253, 7408, 5283, 127, 538, "Input",ExpressionUUID->"d9d8fb35-391e-574d-80a8-dd5f1c0c8ef3",
 InitializationCell->True],
Cell[292539, 7537, 14034, 306, 1490, "Input",ExpressionUUID->"3740ff6f-cc36-415f-a05f-bc96c7e9937a",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[306610, 7848, 188, 3, 37, "Subsection",ExpressionUUID->"45c97c55-4664-4e85-a0d8-6e850f0de568"],
Cell[306801, 7853, 606, 11, 77, "Text",ExpressionUUID->"55d3c8e1-2164-4245-b475-dc7cb4fe0832"],
Cell[307410, 7866, 266, 6, 44, "Input",ExpressionUUID->"58c837f0-a0e1-4542-a14b-0f7e01875738",
 InitializationCell->True],
Cell[307679, 7874, 481, 11, 63, "Input",ExpressionUUID->"f6cf244a-5510-4475-8ce0-6bc765a061c7",
 InitializationCell->True],
Cell[308163, 7887, 2313, 59, 253, "Input",ExpressionUUID->"98e9d480-e40e-4b75-9011-98416395b963",
 InitializationCell->True],
Cell[310479, 7948, 535, 15, 64, "Input",ExpressionUUID->"6adfeaf7-650d-4cf4-9d44-562b09e2e070",
 InitializationCell->True],
Cell[311017, 7965, 427, 11, 44, "Input",ExpressionUUID->"0c03530b-eb8a-468c-9981-de34a13cfdfb",
 InitializationCell->True],
Cell[311447, 7978, 283, 7, 44, "Input",ExpressionUUID->"4b02e3b5-ac61-4f81-b922-ee3aebfcd944",
 InitializationCell->True],
Cell[311733, 7987, 929, 22, 82, "Input",ExpressionUUID->"2a3f0903-70fd-4b2f-977b-5520b7ece475",
 InitializationCell->True],
Cell[312665, 8011, 3096, 70, 311, "Input",ExpressionUUID->"f25e918e-27af-4d1c-a3b1-8ad2608da85d",
 InitializationCell->True],
Cell[315764, 8083, 1274, 35, 101, "Input",ExpressionUUID->"cad804dc-1c05-4f23-b227-27c04690fc77",
 InitializationCell->True],
Cell[317041, 8120, 5316, 125, 482, "Input",ExpressionUUID->"831d8051-a733-4652-864c-bb8024710593",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[322394, 8250, 230, 4, 37, "Subsection",ExpressionUUID->"24183a8c-ad83-4120-aa8a-d70bf89d9e26"],
Cell[322627, 8256, 492, 9, 33, "Text",ExpressionUUID->"a283ceba-2dc7-416d-b3e1-d9d5183a30fa"],
Cell[323122, 8267, 296, 7, 44, "Input",ExpressionUUID->"a454ed16-81b7-4a28-848a-967a9420c5c3",
 InitializationCell->True],
Cell[323421, 8276, 988, 25, 63, "Input",ExpressionUUID->"3fb90955-d9a0-4d4d-9e02-005de5df5566",
 InitializationCell->True],
Cell[324412, 8303, 293, 7, 44, "Input",ExpressionUUID->"c1f0ab1b-879a-4526-a6b3-80dbac744417",
 InitializationCell->True],
Cell[324708, 8312, 292, 7, 44, "Input",ExpressionUUID->"ea597879-63fe-4d41-a8b7-454216a6691e",
 InitializationCell->True],
Cell[325003, 8321, 268, 6, 44, "Input",ExpressionUUID->"6df28451-7490-4c72-9600-83884d04b49a",
 InitializationCell->True],
Cell[325274, 8329, 265, 6, 44, "Input",ExpressionUUID->"0f3336f6-a0a8-4f13-812a-6827d68d656c",
 InitializationCell->True],
Cell[325542, 8337, 640, 17, 63, "Input",ExpressionUUID->"bc434725-184f-4283-8393-406d3c6f392a",
 InitializationCell->True],
Cell[326185, 8356, 975, 23, 63, "Input",ExpressionUUID->"630e0550-8ab1-4abc-83aa-25b2794471b7",
 InitializationCell->True],
Cell[327163, 8381, 7815, 184, 481, "Input",ExpressionUUID->"efd33116-231f-4517-86d5-3e578a3238cf",
 InitializationCell->True],
Cell[334981, 8567, 1787, 43, 101, "Input",ExpressionUUID->"d21afdad-7e12-41f0-8929-8b49fb12508c",
 InitializationCell->True],
Cell[336771, 8612, 1758, 44, 120, "Input",ExpressionUUID->"796aa706-d58d-4fa5-8eee-e244a0779c46",
 InitializationCell->True],
Cell[338532, 8658, 354, 9, 44, "Input",ExpressionUUID->"dda21b0f-b50c-49f6-a91b-5e134cbfe784",
 InitializationCell->True],
Cell[338889, 8669, 1944, 46, 139, "Input",ExpressionUUID->"e0fa29d1-8496-4198-b947-d25ba142b1d4",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[340882, 8721, 283, 5, 66, "Section",ExpressionUUID->"211a0c3e-6043-415b-9795-81a106a8c667"],
Cell[CellGroupData[{
Cell[341190, 8730, 235, 4, 53, "Subsection",ExpressionUUID->"78944756-5d81-434f-996b-b18d162abb2c"],
Cell[341428, 8736, 263, 6, 44, "Input",ExpressionUUID->"b233e755-e197-4d30-bb48-a9199877c4db",
 InitializationCell->True],
Cell[341694, 8744, 3890, 83, 234, "Input",ExpressionUUID->"207d5836-2b69-4498-b7a0-ab50a8bacb73",
 InitializationCell->True],
Cell[345587, 8829, 1988, 43, 177, "Input",ExpressionUUID->"470e9cb7-d2a1-4ed0-a120-a1422819a844",
 InitializationCell->True],
Cell[347578, 8874, 265, 5, 34, "Text",ExpressionUUID->"bb55281a-ba18-449a-8a9b-2dad59a77e4d"],
Cell[347846, 8881, 553, 11, 64, "Input",ExpressionUUID->"8d6ad377-bffd-466d-8846-6c76c6bc2c95",
 InitializationCell->True],
Cell[348402, 8894, 7668, 172, 710, "Input",ExpressionUUID->"7fe7dddf-03ee-480c-aa20-6553d33ff139",
 InitializationCell->True],
Cell[356073, 9068, 1725, 44, 101, "Input",ExpressionUUID->"17dd8740-381a-4d90-8503-e6b6edc4df5c",
 InitializationCell->True],
Cell[357801, 9114, 404, 10, 44, "Input",ExpressionUUID->"35a177e7-b492-4b07-99e2-deda31264352",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[358254, 9130, 339, 6, 66, "Section",ExpressionUUID->"c83f706e-9f0e-49b0-aa24-ab6d1cb6b55e"],
Cell[CellGroupData[{
Cell[358618, 9140, 315, 5, 53, "Subsection",ExpressionUUID->"5007de29-5958-4638-848c-c37120e2bec3"],
Cell[358936, 9147, 3582, 82, 253, "Input",ExpressionUUID->"4d278347-1d42-4be5-9493-ba483c1b313c",
 InitializationCell->True],
Cell[362521, 9231, 1459, 31, 158, "Input",ExpressionUUID->"0a4b9d9f-470d-4dd3-922c-85114e88ca12",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[364029, 9268, 235, 4, 66, "Section",ExpressionUUID->"f02c611a-d82e-4ed9-9f6f-aa6c0dce7f33"],
Cell[CellGroupData[{
Cell[364289, 9276, 161, 4, 651, "Input",ExpressionUUID->"956c3d57-f836-45f7-a2ce-e62890309034",
 InitializationCell->True],
Cell[364453, 9282, 1627, 24, 70, "Output",ExpressionUUID->"3ba72f90-f3aa-3140-86cd-4028297b2240"]
}, Open  ]],
Cell[366095, 9309, 168, 4, 651, "Input",ExpressionUUID->"f8aa1644-62a2-47dc-88fc-e03f6c1b3121",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[366300, 9318, 263, 5, 52, "Section",ExpressionUUID->"90b4b878-6f88-437a-ae3f-a22f6f598e1a"],
Cell[CellGroupData[{
Cell[366588, 9327, 206, 4, 28, "Input",ExpressionUUID->"c78137c7-ea58-4f47-9149-1d5b42229e0a"],
Cell[CellGroupData[{
Cell[366819, 9335, 2526, 37, 22, "Print",ExpressionUUID->"3b91f2c7-12b6-614f-985a-04c3a23d992d"],
Cell[369348, 9374, 2798, 45, 22, "Print",ExpressionUUID->"3fd6df29-38e2-2e41-9088-4f5626fa9166"],
Cell[372149, 9421, 2565, 37, 22, "Print",ExpressionUUID->"ee715bd7-c332-5740-aa44-b2bdc7ac8834"],
Cell[374717, 9460, 2528, 37, 22, "Print",ExpressionUUID->"e9a82743-c2e2-294b-9c42-cca6770f942b"],
Cell[377248, 9499, 2683, 39, 39, "Print",ExpressionUUID->"5b544673-686d-ba41-8604-9397652ea05a"],
Cell[379934, 9540, 2528, 37, 22, "Print",ExpressionUUID->"89188b92-a11a-bc4f-9846-7239c60917d6"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[382511, 9583, 285, 7, 28, "Input",ExpressionUUID->"c7dc0213-a85d-438d-9425-2b9e8e705088"],
Cell[CellGroupData[{
Cell[382821, 9594, 1264, 23, 22, "Print",ExpressionUUID->"ccac885d-afb6-1547-9975-0600c6588373"],
Cell[384088, 9619, 1274, 23, 22, "Print",ExpressionUUID->"a6d687c5-4e78-824a-97d9-71f024235ffc"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[385411, 9648, 287, 7, 28, "Input",ExpressionUUID->"96088e1c-a166-4560-88bb-a2afb78ed650"],
Cell[385701, 9657, 1359, 24, 22, "Print",ExpressionUUID->"a8296c56-e35d-924c-9b1f-a547cd5b05cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[387097, 9686, 528, 16, 28, "Input",ExpressionUUID->"2e6dbc83-b7e0-418a-9d37-64e5e2d14dde"],
Cell[387628, 9704, 5592, 125, 34, "Output",ExpressionUUID->"6206b129-07c4-544e-a3a6-f4458f6badb3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[393257, 9834, 185, 4, 28, "Input",ExpressionUUID->"609c8ba4-39a5-46fd-8c20-ff398264d12c"],
Cell[393445, 9840, 3016, 43, 32, "Output",ExpressionUUID->"989851ad-fc43-5c44-b9ca-bf531ec9e284"]
}, Open  ]],
Cell[CellGroupData[{
Cell[396498, 9888, 190, 4, 28, "Input",ExpressionUUID->"4dbd6ef9-b536-470c-832d-852de568924b"],
Cell[396691, 9894, 3015, 44, 32, "Output",ExpressionUUID->"34a6e24a-ff86-584a-87dc-11a41f64ffc7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[399743, 9943, 386, 7, 28, "Input",ExpressionUUID->"4788f72c-1008-427a-a7c3-423661efdafa"],
Cell[400132, 9952, 2352, 35, 89, "Output",ExpressionUUID->"d403fdf1-bfff-3f46-8876-38b3c511f400"]
}, Open  ]],
Cell[402499, 9990, 462, 14, 66, "Input",ExpressionUUID->"3770b8ba-e8f9-4cb0-b4da-1e8713cbf2de"],
Cell[CellGroupData[{
Cell[402986, 10008, 297, 9, 28, "Input",ExpressionUUID->"04113740-a633-42e4-94fc-f180a550d3a4"],
Cell[403286, 10019, 2831, 40, 32, "Output",ExpressionUUID->"4bd185c4-c01f-b947-9ddd-5c43a07e9804"]
}, Open  ]],
Cell[406132, 10062, 174, 4, 28, "Input",ExpressionUUID->"082f6c60-0f64-4ff5-a5d5-54ed5baf9f2d"],
Cell[CellGroupData[{
Cell[406331, 10070, 297, 9, 28, "Input",ExpressionUUID->"2efbcf0c-18fc-4c45-ab60-20d8c6e80320"],
Cell[406631, 10081, 2803, 40, 32, "Output",ExpressionUUID->"c7762a1c-205b-5743-8b54-caf2855b1f35"]
}, Open  ]],
Cell[409449, 10124, 173, 4, 28, "Input",ExpressionUUID->"bd2e272b-9a30-4fdb-b805-9fad1f6b3587"],
Cell[CellGroupData[{
Cell[409647, 10132, 321, 7, 28, "Input",ExpressionUUID->"f08065bc-0b43-43ab-80d3-108971481e1c"],
Cell[CellGroupData[{
Cell[409993, 10143, 1246, 23, 22, "Print",ExpressionUUID->"bb3bd174-4534-3c47-9d34-36288baf09f7"],
Cell[411242, 10168, 1344, 25, 22, "Print",ExpressionUUID->"790de371-c7e0-9240-9aa7-bca6210a4b06"],
Cell[412589, 10195, 1446, 28, 22, "Print",ExpressionUUID->"54d6f538-f166-044c-a338-479cd5119ba6"],
Cell[414038, 10225, 1496, 30, 22, "Print",ExpressionUUID->"c26b9787-2d5b-bc4b-874e-08fcaa19ed3b"],
Cell[415537, 10257, 1516, 30, 22, "Print",ExpressionUUID->"dc84234d-2c99-a348-8d9c-9937a0d3548a"],
Cell[417056, 10289, 1432, 28, 22, "Print",ExpressionUUID->"5add75c5-5c44-7046-94d9-c299f65adecb"],
Cell[418491, 10319, 1442, 27, 22, "Print",ExpressionUUID->"5f10fcd1-74cd-5c45-91f4-800bbd3127d6"],
Cell[419936, 10348, 1534, 31, 22, "Print",ExpressionUUID->"656d80ac-6d4c-a247-ab0f-ab7ddb174296"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[421519, 10385, 466, 13, 28, "Input",ExpressionUUID->"2d6b85a5-2de1-44d4-8dbb-c43dec7d6679"],
Cell[421988, 10400, 3393, 68, 34, "Output",ExpressionUUID->"2d1ec798-0e92-4f45-9c33-ad8813c68341"]
}, Open  ]],
Cell[CellGroupData[{
Cell[425418, 10473, 281, 5, 28, "Input",ExpressionUUID->"e36b0683-774c-4ad2-8c5b-bc6af7fb9704"],
Cell[425702, 10480, 2564, 36, 32, "Output",ExpressionUUID->"c6e5c3e6-ecef-8543-a542-42802867b214"]
}, Open  ]],
Cell[428281, 10519, 540, 13, 28, "Input",ExpressionUUID->"8c26d6c0-faeb-4044-9a22-99c157e19c0d"],
Cell[CellGroupData[{
Cell[428846, 10536, 341, 6, 28, "Input",ExpressionUUID->"1c18372a-47bd-439e-bba4-48f22cc8cafe"],
Cell[429190, 10544, 2566, 36, 32, "Output",ExpressionUUID->"b4169b83-221e-394a-b670-8fd25bfb9c73"]
}, Open  ]],
Cell[431771, 10583, 383, 10, 28, "Input",ExpressionUUID->"fdeafb00-3204-40a6-9167-e4cae12e5603"],
Cell[432157, 10595, 348, 8, 28, "Input",ExpressionUUID->"7d7d95db-9a2f-4053-a033-6fd18a572b20"],
Cell[CellGroupData[{
Cell[432530, 10607, 354, 9, 28, "Input",ExpressionUUID->"0b91854a-b241-40a1-8c7d-0f2c99fbd8fd"],
Cell[432887, 10618, 3290, 63, 34, "Output",ExpressionUUID->"30567796-fe0f-6848-b4bc-ce2dbfd5c952"]
}, Open  ]],
Cell[CellGroupData[{
Cell[436214, 10686, 204, 4, 28, "Input",ExpressionUUID->"d4351566-4e7b-4315-9aa2-0773741d08cd"],
Cell[436421, 10692, 2492, 36, 32, "Output",ExpressionUUID->"531aa1ff-8854-c346-ba7c-a638f503d96a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[438950, 10733, 401, 10, 28, "Input",ExpressionUUID->"0d84594f-765f-4d65-a457-3f0bcec21513"],
Cell[439354, 10745, 3288, 63, 34, "Output",ExpressionUUID->"493472b8-5d64-2c43-a1fa-24aba44805e0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[442679, 10813, 204, 4, 28, "Input",ExpressionUUID->"de2d002d-1aca-4480-9915-698938e44599"],
Cell[442886, 10819, 2516, 36, 32, "Output",ExpressionUUID->"813e465e-38fd-6646-9ed3-57fb81e05bef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[445439, 10860, 269, 6, 28, "Input",ExpressionUUID->"6724f6b6-547b-45be-9f28-bf3a72dfe44b"],
Cell[445711, 10868, 1288, 23, 22, "Print",ExpressionUUID->"c2780940-bfaf-3048-ade5-696e1395e233"]
}, Open  ]],
Cell[CellGroupData[{
Cell[447036, 10896, 304, 10, 28, "Input",ExpressionUUID->"617d821a-b093-45ab-8284-e023079fb3db"],
Cell[447343, 10908, 3551, 67, 55, "Output",ExpressionUUID->"8638032a-3f7a-534c-b9f5-22e125db4185"]
}, Open  ]],
Cell[CellGroupData[{
Cell[450931, 10980, 205, 4, 28, "Input",ExpressionUUID->"65aa5c4a-9d51-4aac-a9b7-c166eb381bcf"],
Cell[451139, 10986, 2681, 38, 32, "Output",ExpressionUUID->"b3ec095e-4be1-5b47-a11a-e5c9f0ee997a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[453857, 11029, 217, 6, 28, "Input",ExpressionUUID->"ced8519e-c6aa-4245-b24e-1553ae26ed91"],
Cell[454077, 11037, 2763, 46, 50, "Output",ExpressionUUID->"e5d62371-dd94-804f-bdd0-7a973e1c94cc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[456877, 11088, 358, 10, 28, "Input",ExpressionUUID->"97ee2517-3cfa-4dcc-a7f7-89e7418d950f"],
Cell[457238, 11100, 2913, 52, 46, "Output",ExpressionUUID->"93c32313-f460-7d48-8ec2-0c72836d5513"]
}, Open  ]],
Cell[CellGroupData[{
Cell[460188, 11157, 139, 3, 28, "Input",ExpressionUUID->"70cde074-7478-40f1-82cb-252982955b79"],
Cell[460330, 11162, 2560, 37, 32, "Output",ExpressionUUID->"cfd57677-e61c-6b4b-81d5-dc4b6711f9f2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[462927, 11204, 275, 7, 28, "Input",ExpressionUUID->"96d06764-6c54-46d8-a435-5632ea98909e"],
Cell[463205, 11213, 2534, 36, 32, "Output",ExpressionUUID->"25db6ccb-cfba-3144-9674-1971cfded583"]
}, Open  ]],
Cell[CellGroupData[{
Cell[465776, 11254, 857, 23, 28, "Input",ExpressionUUID->"bacfa753-c77f-4a20-a9f4-1ce880b89132"],
Cell[466636, 11279, 2112, 56, 53, "Output",ExpressionUUID->"a7399d14-7036-c644-a12a-9fe54abf0d26"]
}, Open  ]],
Cell[CellGroupData[{
Cell[468785, 11340, 190, 4, 28, "Input",ExpressionUUID->"5d90c74a-5cc3-451d-be3b-4c3ec35dd83c"],
Cell[468978, 11346, 2645, 38, 32, "Output",ExpressionUUID->"2ef7cb35-3cb4-834a-a147-d77efb73ac92"]
}, Open  ]],
Cell[CellGroupData[{
Cell[471660, 11389, 370, 9, 28, "Input",ExpressionUUID->"11ab5431-f903-4920-9bda-4f565105fe7c"],
Cell[472033, 11400, 2619, 38, 32, "Output",ExpressionUUID->"ebb1e5c1-b90d-0f45-b2c1-6fd54dfb89cc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[474689, 11443, 381, 9, 28, "Input",ExpressionUUID->"7bf38c93-d315-442b-8905-d6893a24cfae"],
Cell[475073, 11454, 885, 13, 32, "Output",ExpressionUUID->"af949d5e-6f97-ac48-a0ad-ed26e2950103"]
}, Open  ]],
Cell[CellGroupData[{
Cell[475995, 11472, 284, 8, 28, "Input",ExpressionUUID->"3037f38c-99ee-4786-81b4-16f0b519a3ed"],
Cell[476282, 11482, 2679, 45, 49, "Output",ExpressionUUID->"41fc8242-e96a-d34a-956e-663b0ec838d8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[478998, 11532, 139, 3, 28, "Input",ExpressionUUID->"65a4252c-ec4f-46ce-be7f-4db6838b8407"],
Cell[479140, 11537, 2512, 36, 32, "Output",ExpressionUUID->"14db9aa8-ad65-e544-9410-62311c2e737a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[481689, 11578, 427, 10, 28, "Input",ExpressionUUID->"94967384-f559-4a0b-91a3-a1b15d50bebd"],
Cell[482119, 11590, 2695, 46, 50, "Output",ExpressionUUID->"ef37a296-5a47-ad4b-ac4e-b17de306df51"]
}, Open  ]],
Cell[CellGroupData[{
Cell[484851, 11641, 139, 3, 28, "Input",ExpressionUUID->"e7fdb2a4-953c-43cd-92b7-673965dc1231"],
Cell[484993, 11646, 2505, 36, 32, "Output",ExpressionUUID->"ebe46b2e-70d2-0548-a230-edd090dc7062"]
}, Open  ]],
Cell[CellGroupData[{
Cell[487535, 11687, 275, 7, 28, "Input",ExpressionUUID->"8de0f30e-bf4f-4302-b045-d577cfd94958"],
Cell[487813, 11696, 2517, 37, 32, "Output",ExpressionUUID->"734ca6f7-68ed-d94a-992d-673f4419b26b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[490367, 11738, 231, 6, 28, "Input",ExpressionUUID->"ad1f19b8-270c-489b-bf11-b9aa728aa3bd"],
Cell[490601, 11746, 2642, 44, 46, "Output",ExpressionUUID->"a3adb552-9364-8d4e-8f00-fccdf7cfaf68"]
}, Open  ]],
Cell[CellGroupData[{
Cell[493280, 11795, 139, 3, 28, "Input",ExpressionUUID->"9ada53dd-6e81-4803-ae49-525518d85913"],
Cell[493422, 11800, 2493, 36, 32, "Output",ExpressionUUID->"713626d3-d59d-3c46-a783-f48999278ab3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[495952, 11841, 336, 9, 28, "Input",ExpressionUUID->"34617b48-81a8-49ee-a907-86394b072f33"],
Cell[496291, 11852, 2684, 45, 50, "Output",ExpressionUUID->"8ab0832e-a89d-ec4e-84ee-8133e23467c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[499012, 11902, 139, 3, 28, "Input",ExpressionUUID->"f7582ecb-44d3-4a21-8363-98c190925f47"],
Cell[499154, 11907, 2506, 36, 32, "Output",ExpressionUUID->"050c7bd0-b739-a74a-8887-a0572ffec0a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[501697, 11948, 254, 6, 28, "Input",ExpressionUUID->"80b37900-1aea-4146-aab3-b4bba4fec08a"],
Cell[501954, 11956, 2523, 39, 50, "Output",ExpressionUUID->"0088ddfb-2019-7f44-ab36-7e5a8a2f25f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[504514, 12000, 139, 3, 28, "Input",ExpressionUUID->"2a9b5f60-529c-4d1c-8cee-ef0d72e0bc1a"],
Cell[504656, 12005, 2504, 36, 32, "Output",ExpressionUUID->"4e330787-ff74-bf44-9b90-32198a9627d3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[507197, 12046, 333, 9, 28, "Input",ExpressionUUID->"7b3675ef-a93a-4d07-9618-d5f29c190b8d"],
Cell[507533, 12057, 2708, 46, 46, "Output",ExpressionUUID->"19f64fc4-8cd0-ce4a-ab65-b32b5ad4b741"]
}, Open  ]],
Cell[CellGroupData[{
Cell[510278, 12108, 205, 4, 28, "Input",ExpressionUUID->"96637fc0-5078-4619-b647-c973b2b5b817"],
Cell[510486, 12114, 2525, 36, 32, "Output",ExpressionUUID->"3340beef-4c9e-1047-b0a5-85170508f7a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[513048, 12155, 275, 7, 28, "Input",ExpressionUUID->"93f0e119-a363-4b7f-abc2-cef7b7da4258"],
Cell[513326, 12164, 2489, 36, 32, "Output",ExpressionUUID->"1ba0b646-2bb2-434e-9da8-99328cbae99c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[515852, 12205, 485, 15, 28, "Input",ExpressionUUID->"e4779d76-3fea-4352-aa11-c9657fed34a5"],
Cell[516340, 12222, 3590, 73, 56, "Output",ExpressionUUID->"0ae42497-6cc1-9540-90c3-467cb4742efc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[519967, 12300, 207, 4, 28, "Input",ExpressionUUID->"db18d7c8-0751-48a8-85e1-83a670e53379"],
Cell[520177, 12306, 2528, 37, 32, "Output",ExpressionUUID->"d1026a51-e875-b247-a12a-518c97928e92"]
}, Open  ]],
Cell[CellGroupData[{
Cell[522742, 12348, 275, 7, 28, "Input",ExpressionUUID->"ffd81ff1-6fb8-4dff-a6aa-d9db4cc34235"],
Cell[523020, 12357, 2524, 37, 32, "Output",ExpressionUUID->"157c5538-bc76-d645-833a-8fe051e9f267"]
}, Open  ]],
Cell[CellGroupData[{
Cell[525581, 12399, 872, 25, 28, "Input",ExpressionUUID->"58add8ee-189d-4b5b-aea3-615d6ad42101"],
Cell[526456, 12426, 3568, 73, 50, "Output",ExpressionUUID->"2329180a-0d8b-8549-90b6-72b8f513b357"]
}, Open  ]],
Cell[CellGroupData[{
Cell[530061, 12504, 204, 4, 28, "Input",ExpressionUUID->"a585b4da-2bc0-48bc-bffa-9de197589f85"],
Cell[530268, 12510, 2740, 40, 32, "Output",ExpressionUUID->"c9cad1a3-d86b-4c4f-a748-23ace3313f48"]
}, Open  ]],
Cell[CellGroupData[{
Cell[533045, 12555, 367, 7, 28, "Input",ExpressionUUID->"6f45fcdc-d1ff-404b-a2b4-e73184990b2c"],
Cell[533415, 12564, 888, 16, 89, "Output",ExpressionUUID->"6a866cfd-b441-0947-9b10-c37b2a823bb7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[534340, 12585, 356, 7, 28, "Input",ExpressionUUID->"45da9f5b-a2f2-4ae4-8105-6fda9c8ee828"],
Cell[534699, 12594, 871, 15, 108, "Output",ExpressionUUID->"7ba52f09-ee3d-764c-9d1b-63797b07bdc0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[535607, 12614, 473, 14, 28, "Input",ExpressionUUID->"48a65cea-c1be-45ea-9383-fba51f500ea0"],
Cell[536083, 12630, 4527, 99, 34, "Output",ExpressionUUID->"a605e825-ef82-8340-a900-077aeef16df0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[540647, 12734, 205, 4, 28, "Input",ExpressionUUID->"933f705b-0917-43be-8aa0-6a2f0c3b63f4"],
Cell[540855, 12740, 2239, 32, 32, "Output",ExpressionUUID->"84bbaf5b-66ce-7144-a880-0ac2be16f413"]
}, Open  ]],
Cell[CellGroupData[{
Cell[543131, 12777, 469, 13, 28, "Input",ExpressionUUID->"e1829cf4-b836-48ef-b063-28957e141cce"],
Cell[543603, 12792, 4432, 97, 34, "Output",ExpressionUUID->"b3995855-ded4-144d-9366-5ad7bd226fdc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[548072, 12894, 205, 4, 28, "Input",ExpressionUUID->"1fad9ad4-a3ae-4362-9eae-d4ca8afa3c6e"],
Cell[548280, 12900, 2225, 31, 32, "Output",ExpressionUUID->"dcebf6f8-17fb-a741-9158-c0770d1ab305"]
}, Open  ]],
Cell[CellGroupData[{
Cell[550542, 12936, 287, 6, 28, "Input",ExpressionUUID->"5666f535-c1f4-4a97-af98-acd8ef34a1d2"],
Cell[550832, 12944, 861, 17, 22, "Print",ExpressionUUID->"1d2c52ec-9520-2d41-b64e-8dcca622d58d"]
}, Open  ]],
Cell[551708, 12964, 187, 3, 33, "Text",ExpressionUUID->"5e7efc3e-fd0e-4c29-8555-5a316a9c04da"],
Cell[CellGroupData[{
Cell[551920, 12971, 809, 20, 28, "Input",ExpressionUUID->"8324d686-471d-4df7-90be-55c5772158a6"],
Cell[552732, 12993, 3268, 96, 32, "Output",ExpressionUUID->"639cfd67-14cd-014b-9c08-79a10473b9b9"]
}, Open  ]],
Cell[556015, 13092, 165, 3, 33, "Text",ExpressionUUID->"f8536740-6359-450c-9e08-7f44bc0db7a2"],
Cell[CellGroupData[{
Cell[556205, 13099, 203, 4, 28, "Input",ExpressionUUID->"5a2a83bd-2a9a-4485-a143-6c010d3c4903"],
Cell[556411, 13105, 1255, 19, 32, "Output",ExpressionUUID->"83b1fc73-5290-6d4c-a3db-18e5b6a87774"]
}, Open  ]],
Cell[557681, 13127, 186, 3, 33, "Text",ExpressionUUID->"5497f1f6-3bf4-43b4-8ab9-279d7af834a7"],
Cell[CellGroupData[{
Cell[557892, 13134, 188, 4, 28, "Input",ExpressionUUID->"a77dc2fa-8db7-4083-8d9b-56a3838ff1a1"],
Cell[558083, 13140, 821, 13, 51, "Output",ExpressionUUID->"67e7163f-1841-2c4f-9ba9-011375b9a4aa"]
}, Open  ]],
Cell[558919, 13156, 174, 2, 33, "Text",ExpressionUUID->"58a4190f-c674-4cf8-9bb3-1d5b8c1765aa"],
Cell[CellGroupData[{
Cell[559118, 13162, 147, 3, 28, "Input",ExpressionUUID->"8e9f5254-b6a9-4d0d-b486-814cdcb2c75d"],
Cell[559268, 13167, 1143, 17, 32, "Output",ExpressionUUID->"75315735-bd95-af45-b6ae-2941b21e43c1"]
}, Open  ]],
Cell[560426, 13187, 323, 7, 33, "Text",ExpressionUUID->"fe71540a-feb3-445f-8f2b-8004518ff38d"],
Cell[560752, 13196, 921, 25, 85, "Input",ExpressionUUID->"614f73da-cc38-4f61-ba73-541508e33524"],
Cell[CellGroupData[{
Cell[561698, 13225, 147, 3, 28, "Input",ExpressionUUID->"5be57966-a086-46d1-8206-44b5d1003e96"],
Cell[561848, 13230, 809, 12, 32, "Output",ExpressionUUID->"0bb8ba38-cf7e-2445-ab0d-8ef5d038be75"]
}, Open  ]],
Cell[562672, 13245, 255, 4, 33, "Text",ExpressionUUID->"fd8422bf-8c1f-41a1-b641-380a16e2406b"],
Cell[562930, 13251, 721, 22, 85, "Input",ExpressionUUID->"8d28192e-8a61-48c0-aa04-b2c1fb455db4"],
Cell[CellGroupData[{
Cell[563676, 13277, 213, 4, 28, "Input",ExpressionUUID->"92971777-e85b-4977-8097-6fbf3fa26d42"],
Cell[CellGroupData[{
Cell[563914, 13285, 2477, 41, 22, "Print",ExpressionUUID->"57b19b07-06d3-f74c-84b5-f6d41e40ffe8"],
Cell[566394, 13328, 2422, 40, 22, "Print",ExpressionUUID->"fad1990f-2d83-d045-879e-184db0841995"],
Cell[568819, 13370, 2430, 40, 22, "Print",ExpressionUUID->"42f28118-0afd-2f4a-8ac0-8a81d6be8454"],
Cell[571252, 13412, 2432, 40, 22, "Print",ExpressionUUID->"b323d73b-bc38-6b4c-82e8-52eca8923bc2"],
Cell[573687, 13454, 2424, 40, 22, "Print",ExpressionUUID->"be70f273-9564-5146-9686-5781723c4a6f"],
Cell[576114, 13496, 2444, 40, 22, "Print",ExpressionUUID->"d02d8ee9-e76d-1341-8624-4a85bf95edc6"],
Cell[578561, 13538, 2448, 40, 22, "Print",ExpressionUUID->"7ab7bd63-9246-8c41-a94e-b659d8e0f038"],
Cell[581012, 13580, 2388, 39, 22, "Print",ExpressionUUID->"9d7d7a5a-319b-7b4d-9aba-b9c91b331246"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[583449, 13625, 150, 3, 28, "Input",ExpressionUUID->"e8a948e3-dd67-44b0-b2f7-d7f9f6137486"],
Cell[CellGroupData[{
Cell[583624, 13632, 2687, 44, 22, "Print",ExpressionUUID->"79c7bc82-c3ad-c244-8f48-a022c638c448"],
Cell[586314, 13678, 2705, 44, 22, "Print",ExpressionUUID->"cb8d1686-c61e-294e-a013-29c18123adca"]
}, Open  ]],
Cell[589034, 13725, 2377, 36, 32, "Output",ExpressionUUID->"8e036ae7-9f7c-c44a-83ec-78d2dbac4f80"]
}, Open  ]],
Cell[591426, 13764, 207, 3, 33, "Text",ExpressionUUID->"f624c000-eb4b-4b86-9c43-eb4a6fb55efa"],
Cell[CellGroupData[{
Cell[591658, 13771, 370, 10, 28, "Input",ExpressionUUID->"c0ae74d9-9233-4283-ac22-34721b4e6c18"],
Cell[592031, 13783, 646, 14, 32, "Output",ExpressionUUID->"940d5272-9683-9540-91fb-55bec2c5ae0a"]
}, Open  ]],
Cell[592692, 13800, 253, 4, 33, "Text",ExpressionUUID->"5d588f32-830a-4e43-8f2d-e47fc7d06da3"],
Cell[CellGroupData[{
Cell[592970, 13808, 206, 4, 28, "Input",ExpressionUUID->"458d7bda-284e-40f1-96a4-f6ce645c0d39"],
Cell[593179, 13814, 640, 10, 89, "Output",ExpressionUUID->"2709fb9a-82de-4345-bdeb-61b1ef9b2d37"]
}, Open  ]],
Cell[593834, 13827, 173, 3, 33, "Text",ExpressionUUID->"0fe22465-0571-4a1d-98cc-05c1b215cc46"],
Cell[594010, 13832, 297, 7, 28, "Input",ExpressionUUID->"f457300d-d300-463d-9dd6-9a2cd0a40b2b"],
Cell[CellGroupData[{
Cell[594332, 13843, 141, 3, 28, "Input",ExpressionUUID->"ffa15e17-404a-4478-80a1-3adddcdb9c61"],
Cell[594476, 13848, 613, 9, 89, "Output",ExpressionUUID->"992f5c70-0a78-334f-8ad8-20828440b37b"]
}, Open  ]],
Cell[595104, 13860, 585, 10, 77, "Text",ExpressionUUID->"d5c4ab45-1e03-4b09-9406-a2f2f72b4344"],
Cell[CellGroupData[{
Cell[595714, 13874, 627, 18, 28, "Input",ExpressionUUID->"38aab7cd-e721-41f2-a586-af6e7f9d03d3"],
Cell[596344, 13894, 706, 10, 89, "Output",ExpressionUUID->"06947027-e70f-1b44-b7fe-98605ab51523"]
}, Open  ]],
Cell[CellGroupData[{
Cell[597087, 13909, 726, 21, 28, "Input",ExpressionUUID->"f4e3edfb-8777-42ce-8822-1faf7f54b014"],
Cell[597816, 13932, 744, 12, 89, "Output",ExpressionUUID->"869caa05-168a-024e-b81b-77f0ec2e737e"]
}, Open  ]],
Cell[598575, 13947, 324, 7, 55, "Text",ExpressionUUID->"ffd66583-8c9a-4280-9425-6c2636539168"],
Cell[CellGroupData[{
Cell[598924, 13958, 252, 5, 28, "Input",ExpressionUUID->"c49f3039-eef1-434d-847b-112ecd03d01c"],
Cell[599179, 13965, 630, 9, 89, "Output",ExpressionUUID->"24acaecd-acd8-c74f-b933-0b210a8b6f0a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[599846, 13979, 447, 12, 28, "Input",ExpressionUUID->"3d887a85-aa96-4131-ba2a-bc7ffde4750e"],
Cell[600296, 13993, 594, 9, 89, "Output",ExpressionUUID->"49441c09-9854-f740-8e98-dbb25ae2ff6d"]
}, Open  ]],
Cell[600905, 14005, 288, 6, 33, "Text",ExpressionUUID->"a39cdd9b-a86c-4690-9ab5-7bdc8956fb67"],
Cell[CellGroupData[{
Cell[601218, 14015, 346, 6, 66, "Input",ExpressionUUID->"8c4cf33f-3d87-4bf3-86b9-ac662de912dc"],
Cell[601567, 14023, 530, 8, 89, "Output",ExpressionUUID->"11044c1e-9cc5-684f-ba43-e9b9a535bce6"],
Cell[602100, 14033, 530, 8, 89, "Output",ExpressionUUID->"f51a803c-77d1-6b49-ba31-a0581932bbf3"],
Cell[602633, 14043, 532, 8, 89, "Output",ExpressionUUID->"63d135df-2423-2448-bdb1-c1862e5285cb"]
}, Open  ]],
Cell[603180, 14054, 222, 5, 33, "Text",ExpressionUUID->"3bf3f7bf-e748-4769-a3c3-449d70b7eb7a"],
Cell[603405, 14061, 304, 8, 28, "Input",ExpressionUUID->"ed7ede59-c6e7-4615-bea8-884274f39735"],
Cell[603712, 14071, 216, 4, 33, "Text",ExpressionUUID->"f07c497c-54fb-4a87-bfaa-1c146159ed6f"],
Cell[603931, 14077, 478, 12, 47, "Input",ExpressionUUID->"e94e63f5-67af-41e9-9d5f-235382b157cc"],
Cell[604412, 14091, 378, 8, 55, "Text",ExpressionUUID->"1699582e-e5bf-4e13-8638-d22140dd5150"],
Cell[604793, 14101, 374, 8, 28, "Input",ExpressionUUID->"45d56c09-1a59-48f8-a34e-d89b3f2f57a4"],
Cell[605170, 14111, 250, 6, 33, "Text",ExpressionUUID->"fed98989-fc69-463f-929f-4c07a22b9be8"],
Cell[605423, 14119, 233, 4, 33, "Text",ExpressionUUID->"ef00231c-efcf-4f13-831c-dcc584179a95"],
Cell[CellGroupData[{
Cell[605681, 14127, 215, 4, 28, "Input",ExpressionUUID->"5923ae44-e29f-4388-8888-8e1646cb68ef"],
Cell[CellGroupData[{
Cell[605921, 14135, 2355, 35, 22, "Print",ExpressionUUID->"8bef30a8-2075-b241-a1c5-f6c89a83a351"],
Cell[608279, 14172, 2647, 43, 22, "Print",ExpressionUUID->"e5e64be6-0b3d-1c42-bf9f-d9c80d517694"],
Cell[610929, 14217, 2384, 35, 22, "Print",ExpressionUUID->"c9976a32-2dfe-9b47-bd1f-bd9386685aab"],
Cell[613316, 14254, 2357, 35, 22, "Print",ExpressionUUID->"2ab0b558-9ec9-9543-8719-38503386903e"],
Cell[615676, 14291, 2512, 37, 39, "Print",ExpressionUUID->"99b71458-1458-5c4d-8825-4229750da646"],
Cell[618191, 14330, 2357, 35, 22, "Print",ExpressionUUID->"ba7bd577-d2bb-224c-bd5b-741a9a16b1b9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[620597, 14371, 499, 13, 28, "Input",ExpressionUUID->"b6ee0839-2597-462a-930b-16cd3fb3e58b"],
Cell[621099, 14386, 1224, 28, 22, "Print",ExpressionUUID->"778cf7c4-8bf6-7b49-b4cf-038f38fcdba3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[622360, 14419, 563, 13, 28, "Input",ExpressionUUID->"e8580a22-4b4d-46ca-a0c1-7f1491e02261"],
Cell[622926, 14434, 1157, 26, 22, "Print",ExpressionUUID->"ae8098c2-cb99-854d-8e63-089e06562a76"]
}, Open  ]],
Cell[CellGroupData[{
Cell[624120, 14465, 840, 26, 47, "Input",ExpressionUUID->"98c16c9c-0d34-4925-8867-6d739390065f"],
Cell[624963, 14493, 3617, 71, 37, "Output",ExpressionUUID->"1d18bbce-4e15-cf45-a2ec-aff30d5ce400"]
}, Open  ]],
Cell[CellGroupData[{
Cell[628617, 14569, 139, 3, 28, "Input",ExpressionUUID->"833a35bd-159a-4f2b-b298-fe257bf0abfc"],
Cell[628759, 14574, 2371, 34, 32, "Output",ExpressionUUID->"aab62410-1415-3a4e-b3c0-bd4069bfe03c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[631167, 14613, 594, 18, 28, "Input",ExpressionUUID->"56070e95-de71-4aac-8ad0-a5fa0e469b7d"],
Cell[631764, 14633, 25021, 731, 118, "Output",ExpressionUUID->"3010cafb-3ae1-5840-9564-979ba18acbd4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[656822, 15369, 793, 22, 28, "Input",ExpressionUUID->"7c455e37-60c4-46ae-b69b-98640dbf1e4e"],
Cell[657618, 15393, 35502, 1043, 118, "Output",ExpressionUUID->"2e0fbbeb-7139-4d4e-a720-b6814db24500"]
}, Open  ]],
Cell[693135, 16439, 246, 5, 28, "Input",ExpressionUUID->"67cd4b78-fd4f-479b-addd-4edae3611155"],
Cell[CellGroupData[{
Cell[693406, 16448, 237, 5, 28, "Input",ExpressionUUID->"18bf4a10-de5a-4424-bc1c-3624d08751fb"],
Cell[693646, 16455, 3407, 48, 184, "Output",ExpressionUUID->"7aa1b62a-4eba-fb48-b391-6b32cd1da0dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[697090, 16508, 359, 8, 28, "Input",ExpressionUUID->"3b4c853b-86db-4e37-85f1-60f6f8b12a42"],
Cell[697452, 16518, 3591, 51, 298, "Output",ExpressionUUID->"b74d69c3-2fdc-ba4d-9372-b4cfa3a568a1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[701080, 16574, 534, 15, 28, "Input",ExpressionUUID->"f192b880-0574-43c1-8bef-180897e9cde4"],
Cell[701617, 16591, 36885, 1077, 118, "Output",ExpressionUUID->"90aa5142-8ab7-d445-b6eb-0b87b53dbb85"]
}, Open  ]],
Cell[CellGroupData[{
Cell[738539, 17673, 563, 12, 28, "Input",ExpressionUUID->"ec4bc28f-c577-4940-9b26-c351272a9613"],
Cell[739105, 17687, 1814, 41, 34, "Output",ExpressionUUID->"2816d334-b7b8-ff4a-b66e-7f4c2a9f6236"]
}, Open  ]],
Cell[CellGroupData[{
Cell[740956, 17733, 792, 25, 28, "Input",ExpressionUUID->"f62b2cf9-6b5c-4f09-8fb7-ffeb5afed077"],
Cell[741751, 17760, 3633, 97, 34, "Output",ExpressionUUID->"657a7a70-4966-274e-8bb5-a43bc0b75b2a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[745421, 17862, 648, 13, 28, "Input",ExpressionUUID->"642607af-3fbd-4ae4-8a71-5411b09aa2af"],
Cell[746072, 17877, 2415, 34, 564, "Output",ExpressionUUID->"1fe49694-1451-8c43-944f-888c2d340750"]
}, Open  ]],
Cell[748502, 17914, 591, 11, 77, "Text",ExpressionUUID->"c46eb656-4bcb-4dcc-8f68-b10882cd05ff"],
Cell[749096, 17927, 414, 8, 28, "Input",ExpressionUUID->"fe764cd0-1244-4ef7-a787-a40f165d80af"],
Cell[CellGroupData[{
Cell[749535, 17939, 217, 4, 28, "Input",ExpressionUUID->"a1336673-3b81-4592-b353-6c23f540347e"],
Cell[CellGroupData[{
Cell[749777, 17947, 755, 12, 22, "Print",ExpressionUUID->"f517bea6-a3cc-d44f-885e-58d07892ddd3"],
Cell[750535, 17961, 943, 17, 22, "Print",ExpressionUUID->"aaa0bf04-79f3-a948-b9f6-5a07bb941127"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[751527, 17984, 150, 3, 28, "Input",ExpressionUUID->"1dcdbf46-b62e-4943-9012-18778ad9a8dd"],
Cell[CellGroupData[{
Cell[751702, 17991, 1045, 23, 22, "Print",ExpressionUUID->"8ff311c3-91d0-3345-a6c3-bbc32ddb6a2f"],
Cell[752750, 18016, 1073, 23, 22, "Print",ExpressionUUID->"1da9fc9b-0ebf-8f4a-bd7f-94fbaacb3da5"]
}, Open  ]],
Cell[753838, 18042, 710, 15, 32, "Output",ExpressionUUID->"3ce7b7b7-8583-7040-9b21-b40a68d9a387"]
}, Open  ]],
Cell[CellGroupData[{
Cell[754585, 18062, 150, 3, 28, "Input",ExpressionUUID->"36c4714e-d3a2-44b8-95c5-20a4e81b66cf"],
Cell[CellGroupData[{
Cell[754760, 18069, 1235, 29, 22, "Print",ExpressionUUID->"ecb62e5e-4cd5-3245-8484-ae51dfb0b51f"],
Cell[755998, 18100, 1069, 23, 22, "Print",ExpressionUUID->"ab1b1195-60f5-6240-8bee-3e5372bee67e"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

