(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1363866,      31447]
NotebookOptionsPosition[   1315279,      30627]
NotebookOutlinePosition[   1315788,      30646]
CellTagsIndexPosition[   1315745,      30643]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xCPS",
 FontWeight->"Bold",
 FontSlant->"Italic",
 FontColor->RGBColor[1, 0, 0]]], "Title",
 CellChangeTimes->{{3.950963190781385*^9, 3.950963191242895*^9}},
 FontFamily->
  "Source Sans Pro",ExpressionUUID->"8cd5ccbd-a0eb-7d4a-b6fb-200b5409202f"],

Cell[TextData[{
 StyleBox["Covariant Phase Space Formalism for ",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["xAct",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]]
}], "Subtitle",
 CellChangeTimes->{{3.9509632131664257`*^9, 3.9509632280634594`*^9}, {
  3.955681464626131*^9, 3.9556814658351336`*^9}},
 FontFamily->
  "Source Sans Pro",ExpressionUUID->"7b1bfc00-ed37-4149-a29f-ad997cb03627"],

Cell[TextData[StyleBox["Juan Margalef-Bentabol",
 FontSize->18]], "Author",
 CellChangeTimes->{{3.950963234083061*^9, 3.950963359964699*^9}, {
   3.950963818523828*^9, 3.950963821058983*^9}, 
   3.958056238894573*^9},ExpressionUUID->"634006a4-421b-3242-9bc7-\
a214b3f82c91"],

Cell[TextData[StyleBox["juan.margalef@umontreal.ca\nUniversit\[EAcute] de \
Montr\[EAcute]al, Canada",
 FontSize->14]], "Affiliation",
 CellChangeTimes->{{3.950963234083061*^9, 3.950963359964699*^9}, {
   3.950963818523828*^9, 3.950963821058983*^9}, {3.9580562416863174`*^9, 
   3.9580562420701847`*^9}, {3.9580562723956356`*^9, 
   3.9580562740222015`*^9}, {3.963744142320965*^9, 3.963744146692007*^9}, 
   3.96374435421883*^9},ExpressionUUID->"ea7f75d6-7124-0640-8320-\
618ba052b9ba"],

Cell[TextData[StyleBox["Laura S\[AAcute]nchez Cotta",
 FontSize->18]], "Author",
 CellChangeTimes->{{3.950963234083061*^9, 3.950963359964699*^9}, {
  3.950963818523828*^9, 3.950963821058983*^9}, {3.958056238894573*^9, 
  3.9580562683016167`*^9}},ExpressionUUID->"6e2b47c9-9cae-024b-88eb-\
f19d3af35760"],

Cell[TextData[StyleBox["100527266@alumnos.uc3m.es\nUniversidad Carlos III de \
Madrid, Spain",
 FontSize->14]], "Affiliation",
 CellChangeTimes->{{3.950963234083061*^9, 3.950963359964699*^9}, {
  3.950963818523828*^9, 3.950963821058983*^9}, {3.9580562416863174`*^9, 
  3.9580562598141727`*^9}, {3.9594016145020447`*^9, 
  3.9594016167047596`*^9}},ExpressionUUID->"7a6a626c-a3ce-c541-8442-\
0c18dcdb2345"],

Cell[TextData[{
 StyleBox["(c) 2025, under GPL\n\nhttp://www.xAct.es/\n\
http://groups.google.com/group/xAct\n",
  FontSize->14],
 StyleBox["https://github.com/juanmargalef/xCPS",
  FontFamily->"Bitstream Vera Sans",
  FontSize->14]
}], "Author",
 CellChangeTimes->{{3.950963234083061*^9, 3.950963359964699*^9}, {
   3.950963818523828*^9, 3.950963821058983*^9}, {3.958056281213213*^9, 
   3.958056285310196*^9}, {3.9760268318729267`*^9, 3.976026839926512*^9}, 
   3.976028726528225*^9},ExpressionUUID->"e9a9b5af-a97b-b84e-9cbc-\
e80b77ccc384"],

Cell[TextData[{
 StyleBox["xCPS",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is a Covariant Phase Space package in ",
 StyleBox["xAct",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ".\n\n",
 StyleBox["xCPS",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is distributed under the GNU General Public License, and runs on top of ",
 StyleBox["xTensor",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " which is a free package for fast manipulation of abstract tensor \
expressions that can be downloaded from ",
 ButtonBox["http://www.xact.es",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.xact.es"], None},
  ButtonNote->"http://www.xact.es"]
}], "Abstract",
 CellChangeTimes->{{3.9509633915790024`*^9, 3.9509634197361374`*^9}, {
  3.950977953418976*^9, 3.950977957923462*^9}, {3.9580405388255463`*^9, 
  3.958040554630615*^9}, {3.9580607112262344`*^9, 
  3.9580607173234673`*^9}},ExpressionUUID->"d1621c9f-5d05-df43-882f-\
7dbe7fd0f81b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "]"}]], "Input",
 CellLabel->
  "In[237]:=",ExpressionUUID->"08d2d7d0-7e9c-7149-b216-ba5641de6af0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2026", ",", "1", ",", "2", ",", "4", ",", "29", ",", 
   "30.3477448`9.234701330675946"}], "}"}]], "Output",
 CellChangeTimes->{3.958562742587227*^9, 3.959749781251631*^9, 
  3.960656335960903*^9, 3.9640038020912437`*^9, 3.976313370457678*^9},
 CellLabel->
  "Out[237]=",ExpressionUUID->"64dc0eae-0d30-4141-8589-a1ddb6d666ed"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xAct`xCPS`$Version", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.0.1\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2025", ",", "31", ",", "12"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xCPS`$xTensorVersionExpected", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.1.4\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2020", ",", "2", ",", "16"}], "}"}]}], "}"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9513401182222366`*^9, 3.951340142419182*^9}, 
   3.951394698792647*^9, {3.951932361310911*^9, 3.951932362345705*^9}, {
   3.9580753973262863`*^9, 3.9580754052542057`*^9}, {3.9581261412783146`*^9, 
   3.958126141335722*^9}, {3.976026526714321*^9, 3.976026529845892*^9}, {
   3.976300131114599*^9, 
   3.9763001359986687`*^9}},ExpressionUUID->"a5f34c87-5a02-3a49-90af-\
b3c337c22cd7"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ". Initialization "
}], "Chapter",
 CellChangeTimes->{{3.9325304550267477`*^9, 3.9325304581711454`*^9}, {
  3.9483906491034417`*^9, 3.948390651877199*^9}, {3.948390723648257*^9, 
  3.948390730701321*^9}, {3.95088245840399*^9, 3.950882460201969*^9}, {
  3.951340369228016*^9, 
  3.951340379852621*^9}},ExpressionUUID->"98cd9018-beda-42e2-87cb-\
70aba51f95a8"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". GPL"
}], "Section",
 CellChangeTimes->{{3.94839074009263*^9, 3.948390775864776*^9}, {
   3.9508824524753246`*^9, 3.9508824716066723`*^9}, 3.9513403180810184`*^9, {
   3.951340420803343*^9, 
   3.9513404209898663`*^9}},ExpressionUUID->"7f19603d-d957-bf4a-a0b5-\
5e95c432582d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xCPS", ":", " ", 
    RowBox[{
    "Covariant", " ", "Phase", " ", "Space", " ", "Formalism", " ", "in", " ",
      "Field", " ", "Theories"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Copyright", " ", "2025", " ", 
      RowBox[{"(", "C", ")"}], " ", "Juan", " ", "Margalef"}], "-", 
     "Bentabol"}], ",", " ", 
    RowBox[{"Laura", " ", "S\[AAcute]nchez", " ", "Cotta"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", " ", "it", " ", "under", " ",
       "the", " ", "terms", " ", "of", " ", "the", " ", "GNU", " ", "General",
       " ", "Public", " ", "License", " ", "as", "\[IndentingNewLine]", " ", 
      "published", " ", "by", " ", "the", " ", "Free", " ", "Software", " ", 
      "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", " ", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], " ",
      "program", " ", "is", " ", "distributed", " ", "in", " ", "the", " ", 
     "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", "useful"}], 
    ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", " ", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", " ", 
      "General", " ", "Public", " ", "License", " ", "for", " ", "more", " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], " ",
       "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ", 
      "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", " ", "along", " ", "with", " ", "this", " ", "program"}], ";",
      " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", "\[IndentingNewLine]",
      " ", "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", " ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.951340426193586*^9, 3.951340531460813*^9}, {
  3.951340587493879*^9, 3.9513405920185223`*^9}, {3.9763006300221825`*^9, 
  3.976300634734623*^9}},ExpressionUUID->"5830a22a-75af-eb4b-9675-\
347984286d35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Info package"
}], "Section",
 CellChangeTimes->{{3.94839074009263*^9, 3.948390775864776*^9}, {
   3.9508824524753246`*^9, 3.9508824716066723`*^9}, 3.9513403180810184`*^9, {
   3.951340545183876*^9, 3.9513405476384335`*^9}, 
   3.958648056814741*^9},ExpressionUUID->"92916eb4-a41b-bb4a-8b55-\
2889e045f34a"],

Cell["\<\
(* :Title: xCPS *)

(* :Author: Juan Margalef-Bentabol and Laura S\[AAcute]nchez Cotta *)

(* :Summary: Covariant Phase Space formalism in Field Theories *)

(* :Brief Discussion:
   - xCPS extends xAct to work with vertical differentiable forms \
(differential forms in the space of fields).
   - Introduces the vertical exterior algebra and variational vector fields.
   - Computes the symplectic form of a field theory through variational \
calculus.
   - Computes the Noether currents of Noether symmetries.
   
*)
  
(* :Context: xAct`xCPS` *)

(* :Package Version: 1 *)

(* :Copyright: Juan Margalef-Bentabol and Laura S\[AAcute]nchez Cotta (2025) *)

(* :History: See xCPS.History *)

(* :Keywords: *)

(* :Source: xCPS.nb *)

(* :Warning: *)

(* :Mathematica Version: 9.0 and later *)

(* :Limitations: None *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellChangeTimes->{{3.951340559976808*^9, 3.951340691672617*^9}, {
   3.951340757405733*^9, 3.9513407759390945`*^9}, {3.976033504885887*^9, 
   3.9760335285789833`*^9}, 
   3.976301677700205*^9},ExpressionUUID->"b77105db-556f-f842-8955-\
0a25b975facb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Begin package"
}], "Section",
 CellChangeTimes->{{3.94839074009263*^9, 3.948390775864776*^9}, {
   3.9508824524753246`*^9, 3.9508824716066723`*^9}, 3.9513403180810184`*^9, {
   3.9513408574079247`*^9, 3.951340858956333*^9}, 
   3.9586480546372013`*^9},ExpressionUUID->"de04e03c-4c84-154b-9524-\
8006257131e8"],

Cell["Protect against multiple loading of the package:", "Text",ExpressionUUID->"db608bc0-fd4b-e848-b328-67ad75282d3b"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xAct`xCPS`Private`xCPSSymbols", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Names", "[", "\"\<xAct`xCPS`*\>\"", "]"}], ",", 
         RowBox[{"Names", "[", "\"\<xAct`xCPS`Private`*\>\"", "]"}]}], "]"}], 
       ",", 
       RowBox[{"\"\<$Version\>\"", "|", "\"\<xAct`xCPS`$Version\>\"", 
        "|", "\"\<$xTensorVersionExpected\>\"", 
        "|", "\"\<xAct`xCPS`$xTensorVersionExpected\>\""}]}], "]"}]}], "}"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "/@", "xAct`xCPS`Private`xCPSSymbols"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Clear", "/@", "xAct`xCPS`Private`xCPSSymbols"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[39]:=",ExpressionUUID->"3bb9d505-e7a7-764b-a3b5-fdf0d859aa09"],

Cell["Decide which is the last package being read:", "Text",ExpressionUUID->"091f7e1b-6efc-aa49-a83c-6e225a6a563d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{"xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`xCPS`\>\""}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[40]:=",ExpressionUUID->"7a86e1a6-d3d9-d846-9693-7c89b9c1fb10"],

Cell["Explicit (not hidden) import of other packages.", "Text",
 CellChangeTimes->{{3.951394637740473*^9, 
  3.951394638132759*^9}},ExpressionUUID->"1bc55883-d092-6f44-acd1-\
9c50e4b6eb8f"],

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`xCPS`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", 
     ",", "\"\<xAct`xCore`\>\""}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9513409660921345`*^9, 3.9513409672795067`*^9}, {
  3.9513946249825935`*^9, 3.95139464137364*^9}, {3.951396703812596*^9, 
  3.951396721380007*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"75f34c33-2b1f-ea44-84d3-8aece645a3f5"],

Cell[TextData[{
 "Check version of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". We simply compare dates:"
}], "Text",ExpressionUUID->"33d3fc49-81d4-4e49-b51f-b77425ea6be8"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Not", "@", 
    RowBox[{"OrderedQ", "@", 
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"{", 
        RowBox[{
        "xAct`xCPS`$xTensorVersionExpected", ",", "xAct`xTensor`$Version"}], 
        "}"}]}], "]"}]}]}], ",", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"General", "::", "versions"}], ",", "\"\<xTensor\>\"", ",", 
      "xAct`xTensor`$Version", ",", "xAct`xCPS`$xTensorVersionExpected"}], 
     "]"}]}]}], "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.951341015174366*^9, 3.951341015327207*^9}, {
  3.951341138819879*^9, 3.951341172336199*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"5a9a3b20-e56d-2a4f-8ace-da3e9700531c"],

Cell["Welcome message:", "Text",ExpressionUUID->"10d40889-ff64-6c4d-af35-992a1ea949a1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`xCPS` version \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", "\"\<CopyRight (C) 2025, Juan Margalef-Bentabol and Laura S\
\[AAcute]nchez Cotta, under the General Public License.\>\"", "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.951341295294279*^9, 3.951341307383747*^9}, 
   3.9595782357632103`*^9, {3.976301722863146*^9, 
   3.976301728041151*^9}},ExpressionUUID->"414ce9cf-a3d5-d34b-87a8-\
f132a9f81ab5"],

Cell["\<\
We specify the context xAct`xCPS` to avoid overriding the Disclaimer of the \
other packages. However we need to turn off the message General:shdw \
temporarily:\
\>", "Text",
 CellChangeTimes->{
  3.9513410410665665`*^9},ExpressionUUID->"fe4ac1b3-e356-4c4e-ba2e-\
654a8d909499"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xCPS`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[46]:=",ExpressionUUID->"c3d09511-81f6-3a41-be6c-f55149422449"],

Cell["If this is the last package show the GPL short disclaimer:", "Text",ExpressionUUID->"f90a99f6-4a71-4447-bf6f-6ad2a90c414c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`xCPS`\>\""}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", "\"\<These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\>\"", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[49]:=",ExpressionUUID->"347344c1-5ea7-d043-82b1-4dca5df473db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Usage messages"
}], "Section",
 CellChangeTimes->{{3.94839074009263*^9, 3.948390775864776*^9}, {
   3.9508824524753246`*^9, 3.9508824716066723`*^9}, 
   3.9513403180810184`*^9},ExpressionUUID->"61689c9d-ff04-2c42-b4e2-\
653cd4654e70"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Functions"
}], "Subsection",
 CellChangeTimes->{3.9323871707782125`*^9, 3.9483909834395266`*^9, 
  3.949497793904171*^9, 
  3.951340316310261*^9},ExpressionUUID->"7f093681-b3d4-2b4a-8173-\
f90813da79d3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AddVariationalRelation", "::", "usage"}], 
    "=", "\"\<AddVariationalRelation[masterTensor -> dependentTensor] adds a \
variational dependency to the global $VariationalGraph.\>\""}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CoefficientsOfVVF", "::", "usage"}], 
    "=", "\"\<CoefficientsOfVVF[VVF] returns the coefficients associated with \
the variational vector field (VVF), extracted from InfoFromVVF.\>\""}], ";"}],
   "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ComponentsOfGeneralizedVVF", "::", "usage"}], 
    "=", "\"\<ComponentsOfGeneralizedVVF[GVVF] returns the list of components \
of the generalized variational vector field 'GVVF' (the 'directions' of \
'GVVF' in the space of fields).\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ComponentsOfVVF", "::", "usage"}], 
    "=", "\"\<ComponentsOfVVF[VVF] returns the list of components of the \
generalized variational vector field 'VVF' (the 'directions' of 'VVF' in the \
space of tensors).\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CovDOfNormal", "::", "usage"}], 
    "=", "\"\<CovDOfNormal[n] returns the covariant derivative associated \
with the normal vector 'n'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CovDOfTotalDerivative", "::", "usage"}], 
    "=", "\"\<CovDOfTotalDerivative[TotD] returns the covariant derivative \
operator associated with the total derivative 'TotD'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CovDToTotalDerivative", "::", "usage"}], 
    "=", "\"\<CovDToTotalDerivative[expr] rewrites covariant derivatives \
(with the argument kept with Keep[]) in 'expr' using the corresponding head \
TotalDerivative[der].\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CurrentFromVector", "::", "usage"}], 
    "=", "\"\<CurrentFromVector[vector][tensors, der][Lagrangian] is a \
function that computes the current associated with a given vector field. For \
a given Lagrangian (defined as a top-form), the current is given by \
\\!\\(\\*SubscriptBox[\\(Q\\), \\(v\\)]\\)=\\!\\(\\*SubscriptBox[\\(i\\), \
\\(v\\)]\\)L-\\!\\(\\*SubscriptBox[\\(\[ImaginaryI]\\), \
\\(\\(VVFFromLieD[v]\\)[tensors]\\)]\\)\[CapitalTheta] where \[CapitalTheta] \
is the SymplecticPotential. There is an overall sign controlled by \
$NoetherCurrentSign.\n- 'tensors' is optional. It is a list of heads of \
tensors to be considered as dynamic. If not specified, it considers all the \
tensors present in 'Lagrangian'.\n- 'der' is optional. If not specified, it \
finds the only CovD present (if several are present, an error is \
thrown).\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DefGeneralizedVVF", "::", "usage"}], 
    "=", "\"\<DefGeneralizedVVF[name, options][pairs] defines a generalized \
variational vector field (GVVF) as a list of replacements for \
k-vertical-forms.\n- Options:\n  * VanishOverOtherForms->True\>\""}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DefPartialPartial", "::", "usage"}], 
    "=", "\"\<DefPartialPartial[function, list_of_tensors] defines a tensor \
representing the n-th partial derivative of 'function' with respect to the \
'list_of_tensors'. The resulting tensor has the indices with opposite \
character to the corresponding 'list_of_tensors' (with the same \
symmetries).\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DependenciesOfScalar", "::", "usage"}], 
    "=", "\"\<DependenciesOfScalar[scalar] returns the list of tensors on \
which the scalar has been declared to depend as an option of \
DefScalarFunction.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DiscardTotalDerivative", "::", "usage"}], 
    "=", "\"\<DiscardTotalDerivative[expr] removes all total derivative terms \
from 'expr'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DivergenceQ", "::", "usage"}], 
    "=", "\"\<DivergenceQ[{metric, LC}, der, options][expr, \
optionalfunctions] checks whether the scalar expression 'expr' is a total \
divergence with respect to 'der'. 'metric' is an auxiliary metric and LC its \
associated Levi-Civitta connection (possibly extended to act over the same \
bundles as 'der').\n- 'LC' is optional. If not included, DivergenceQ[metric, \
der, options][expr, optionalfunctions], LC=CovDOfMetric[metric].\n- \
'optionalfunctions' are functions that are applied in the intermediate steps \
to simplify the expressions.\n- Options:\n  * CheckZero->False: If True, \
DivergenceQ uses === instead of == to check if the expressions vanish.\>\""}],
    ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"dlLagrangianQ", "::", "usage"}], 
    "=", "\"\<It verifies whether 'expr' is a scalar with VertDeg[expr]=1 and \
one exact vertical form per summand.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"dlNormalOfCovDQ", "::", "usage"}], 
    "=", "\"\<dlNormalOfCovDQ[n] returns True if 'n' is the vertical \
differential of a fiducial normal vector.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"dlNormalOfCovDToCovD", "::", "usage"}], 
    "=", "\"\<dlNormalOfCovDToCovD[expr] rewrites expressions involving the \
vertical differential of a fiducial normal vector in terms of its covariant \
derivative.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EnergyMomentum", "::", "usage"}], 
    "=", "\"\<EnergyMomentum[Lagrangian] computes the energy-momentum tensor \
associated with the given 'Lagrangian' (proportional to the EOM with respect \
to the metric).\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EOM", "::", "usage"}], 
    "=", "\"\<EOM[tensor, der][Lagrangian] is equivalent to \
EOMOf1Form[tensor, der][VertDiff@Lagrangian].\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EOMOf1Form", "::", "usage"}], 
    "=", "\"\<EOMOf1Form[HeadOfTensor, der][dlLagrangian] extracts the \
equations of motion from the variation of a Lagrangian with respect to \
HeadOfTensor using der to 'integrate by parts' (Leibniz rule).\n- 'der' is \
optional. If not specified, it finds the only CovD present (if several are \
present, an error is thrown).\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertDiff", "::", "usage"}], 
    "=", "\"\<ExpandVertDiff[options][expr] expands the vertical exterior \
derivatives appearing in 'expr'.\n- Options:\n  * SeparateMetric->True\n  * \
Explode->True\n  * ExpandVertDiffCovD->True\n  * ExpandVertDiffLieD->True\n  \
* ExpandVertDiffBracket->True\n  * ExpandVertDiffTotalDerivative\[Rule]True\n \
 * ExpandVertDiffScalarFunction->True\n  * ConstantTensors->{}\n  * \
NonConstantTensors->{}\n  * HoldExpandVertDiff->None\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertInt", "::", "usage"}], 
    "=", "\"\<ExpandVertInt[options][expr] expands the vertical interior \
products appearing in 'expr'.\n- Options:\n  * Same options as ExpandVertDiff\
\n  * ExpandVertIntCovD->True\n  * ExpandVertIntLieD->True\n  * \
ExpandVertIntBracket->True\n  * ExpandVertIntTotalDerivative->True\n  * \
HoldExpandVertInt->None.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FindCyclicVariationalRelations", "::", "usage"}], 
    "=", "\"\<FindCyclicVariationalRelations[graph, option] returns a list of \
cyclic variational relations in the given graph and prints the cycles.\n- \
Option:\n  * ShowGraph\[Rule]True\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FindPotentialDivergence", "::", "usage"}], 
    "=", "\"\<FindPotentialDivergence[der, iteration][expr, \
optionalfunctions] looks for 'potential' such that potential \
expr=der[ind][potential].\\n\nFindPotentialDivergence[metric, \
iteration][expr, \
optionalfunctions]=FindPotentialDivergence[CovDOfMetric[metric], \
iteration][expr, optionalfunctions].\n- 'iteration' is an optional positive \
integer that limits the amount of iteration in order to obtain the middle \
steps.\n- 'optionalfunctions' are functions that are applied in the \
intermediate steps to simplify the expressions.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FirstVariation", "::", "usage"}], 
    "=", "\"\<FirstVariation[tensors, der, options][Lagrangian] is equivalent \
to FirstVariationOf1Form[tensors, der, options][VertDiff@Lagrangian].\>\""}], 
   ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FirstVariationOf1Form", "::", "usage"}], 
    "=", "\"\<FirstVariationOf1Form[tensors, der, options][dlLagrangian] \
computes the first variation of a dlLagrangian with respect to tensors using \
der to 'integrate by parts' (Leibniz rule) y keeping the total derivative \
term TotalDerivative[der][\[CapitalTheta]].\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfPartialPartial", "::", "usage"}], 
    "=", "\"\<FunctionOfPartialPartial[PartialPartialTensor] returns the \
scalar function associated with 'PartialPartialTensor'.\>\""}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"GeneralizedVVFQ", "::", "usage"}], 
    "=", "\"\<GeneralizedVVFQ[GVVF] checks if 'GVVF' has been defined as a \
generalized variational vector field.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"GenerateExpandVertDiffRule", "::", "usage"}], 
    "=", "\"\<GenerateExpandVertDiffRule[{dltensor, expansion}, options] \
generates the expansion rule dltensor->expansion dos 'dltensor' to be used by \
ExpandVertDiff. It checks if VertDeg match and if the indices are in the \
natural position before creating the rule (it can be deactivated with the \
option CheckGenerateExpandVertDiffRule->False).\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"KretschmannToRiemann", "::", "usage"}], " ", "=", 
    " ", "\"\<KretschmannToRiemann[expr] substitutes the Krestchmann tensors \
for the 'square' of the Riemann tensor.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LagrangianQ", "::", "usage"}], 
    "=", "\"\<LagrangianQ[expr] verifies whether 'expr' is a scalar with zero \
vertical degree.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ListOfVariationalConstantsOf", "::", "usage"}], 
    "=", "\"\<ListOfVariationalConstantsOf[constantTensors] returns the list \
of tensors influenced by the given constant tensors.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ListVariationalRelationsOf", "::", "usage"}], 
    "=", "\"\<ListVariationalRelationsOf[tensor, options] returns the list of \
tensors variationally related to 'tensor'.\n- Options:\n  * Directed -> \
'direction': only the outward/inward/both vertices of the seed tensors are \
included ('direction' can be 'in', 'out' or 'both').\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MakeVertRule", "::", "usage"}], 
    "=", "\"\<MakeVertRule[{lhs, rhs}, opts] calls MakeRule twice: one for \
{'lhs' \[RightArrow] 'rhs'} and the other for \
{ExpandVertDiff[options][VertDiff[lhs]] \[RightArrow] \
ExpandVertDiff[options][VertDiff[rhs]]}. It accepts the options of both \
MakeRule and ExpandVertDiff.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NoetherCurrent", "::", "usage"}], 
    "=", "\"\<NoetherCurrent[vvf][der, iteration][Lagrangian, \
optionalfunctions] computes the Noether current associated with a given \
vector field and Lagrangian. It is given by \
NoetherPotential[vvf][der][Lagrangian]-VertInt[vvf][\[CapitalTheta]] where \
\[CapitalTheta] is the SymplecticPotential. There is an overall sign \
controlled by $NoetherCurrentSign.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NoetherPotential", "::", "usage"}], 
    "=", "\"\<NoetherPotential[vvf][der][Lagrangian] computes the Noether \
potential associated with the Lagrangian.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NoetherSymmetryQ", "::", "usage"}], 
    "=", "\"\<NoetherSymmetryQ[vvf][tensors, der][Lagrangian] checks whether \
the variational vector field vvf is a Noether symmetry of the \
Lagrangian.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NonZeroVertDegQ", "::", "usage"}], " ", "=", 
    " ", "\"\<NonZeroVertDegQ[expr] returns True if the vertical degree of \
'expr' is nonzero and False otherwise.\>\""}], ";"}], " ", "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NormalOfCovD", "::", "usage"}], 
    "=", "\"\<NormalOfCovD[expr] replaces the fiducial normal vector by its \
corresponding vertical differential representation. It uses $NormalOfCovD to \
perform the replacements.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NormalOfCovDQ", "::", "usage"}], 
    "=", "\"\<NormalOfCovDQ[expr] returns True if 'expr' contains the \
fiducial normal vector.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NormalOfCovDToCovD", "::", "usage"}], 
    "=", "\"\<NormalOfCovDToCovD[expr] rewrites expressions containing the \
fiducial normal vector into covariant derivatives.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NormalOfManifold", "::", "usage"}], 
    "=", "\"\<NormalOfManifold[manifold] returns the normal vector field \
associated with the given 'manifold'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NormalOfTotalDerivative", "::", "usage"}], 
    "=", "\"\<NormalOfTotalDerivative[expr] rewrites total derivatives into \
expressions containing the fiducial normal vector.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OnlyTotalDerivative", "::", "usage"}], 
    "=", "\"\<OnlyTotalDerivative[expr] extracts the total derivative terms \
from 'expr'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"OrderOfPartialPartial", "::", "usage"}], 
    "=", "\"\<OrderOfPartialPartial[PartialPartialTensor] returns the order \
of the derivative associated with 'PartialPartialTensor'.\>\""}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PartialPartial", "::", "usage"}], 
    "=", "\"\<PartialPartial[function, {list_of_tensors}] represents the n-th \
partial derivative of 'function' with respect to 'list_of_tensors'.\>\""}], 
   ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PartialPartialQ", "::", "usage"}], 
    "=", "\"\<PartialPartialQ[expr] returns True if 'expr' is a \
PartialPartial tensor.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PartialPartialsOfFunction", "::", "usage"}], 
    "=", "\"\<PartialPartialsOfFunction[function] returns the list of \
PartialPartial tensors associated with 'function'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PartialPartialsOfTensor", "::", "usage"}], 
    "=", "\"\<PartialPartialsOfTensor[tensor] returns the list of \
PartialPartial tensors associated with 'tensor'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RemoveExpandVertDiffRule", "::", "usage"}], 
    "=", "\"\<RemoveExpandVertDiffRule[pattern] removes all the expansion \
rules associated with 'pattern'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RemoveVariationalRelation", "::", "usage"}], 
    "=", "\"\<RemoveVariationalRelation[masterTensor -> dependentTensor] \
removes a variational dependency from the global $VariationalGraph.\>\""}], 
   ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ResetSession", "::", "usage"}], 
    "=", "\"\<ResetSession[] resets the session, clearing all definitions and \
variables.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RulesOfGeneralizedVVFQ", "::", "usage"}], 
    "=", "\"\<RulesOfGeneralizedVVFQ[GVVF] returns the replacement rules used \
to define the generalized variational vector field 'GVVF'.\>\""}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetSigns", "::", "usage"}], 
    "=", "\"\<SetSigns[signs] sets the global signs used in the calculations.\
\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SortVertOperators", "::", "usage"}], 
    "=", "\"\<SortVertOperators[expr] sorts the vertical operators appearing \
in 'expr' into a standard order.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymplecticCurrent", "::", "usage"}], 
    "=", "\"\<SymplecticCurrent[der][Lagrangian] is equivalent to \
SymplecticCurrentOf1Form[der][VertDiff@Lagrangian].\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymplecticCurrentOf1Form", "::", "usage"}], 
    "=", "\"\<SymplecticCurrentOf1Form[der][dlLagrangian] computes the \
symplectic current associated with a dlLagrangian.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymplecticPotential", "::", "usage"}], 
    "=", "\"\<SymplecticPotential[der][Lagrangian] is equivalent to \
SymplecticPotentialOf1Form[der][VertDiff@Lagrangian].\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymplecticPotentialOf1Form", "::", "usage"}], 
    "=", "\"\<SymplecticPotentialOf1Form[der][dlLagrangian] computes the \
symplectic potential associated with a dlLagrangian.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TensorWithIndices", "::", "usage"}], 
    "=", "\"\<TensorWithIndices[tensor, indices] returns the tensor 'tensor' \
with the given 'indices'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TensorsOfPartialPartial", "::", "usage"}], 
    "=", "\"\<TensorsOfPartialPartial[PartialPartialTensor] returns the list \
of tensors with respect to which 'PartialPartialTensor' is defined.\>\""}], 
   ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TotalDerivativeDivergenceQ", "::", "usage"}], 
    "=", "\"\<TotalDerivativeDivergenceQ[der][expr] checks whether 'expr' is \
a total derivative divergence with respect to 'der'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TotalDerivativeOfCovD", "::", "usage"}], 
    "=", "\"\<TotalDerivativeOfCovD[expr] rewrites covariant derivatives into \
total derivatives.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TotalDerivativeOfManifold", "::", "usage"}], 
    "=", "\"\<TotalDerivativeOfManifold[manifold] returns the total \
derivative operator associated with 'manifold'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TotalDerivativeOfNormal", "::", "usage"}], 
    "=", "\"\<TotalDerivativeOfNormal[expr] rewrites expressions containing \
the fiducial normal vector into total derivatives.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TotalDerivativePotential", "::", "usage"}], 
    "=", "\"\<TotalDerivativePotential[der, iteration][expr] attempts to find \
a potential for the total derivative 'expr'.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TotalDerivativeQ", "::", "usage"}], 
    "=", "\"\<TotalDerivativeQ[expr] returns True if 'expr' is a total \
derivative.\>\""}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TotalDerivativeToCovD", "::", "usage"}], 
    "=", "\"\<TotalDerivativeToCovD[expr] rewrites total derivatives into \
covariant derivatives.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UndefGeneralizedVVF", "::", "usage"}], 
    "=", "\"\<UndefGeneralizedVVF[name] removes the definition of the \
generalized variational vector field 'name'.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UnprotectVertDiffRule", "::", "usage"}], " ", "=", 
    " ", "\"\<UnprotectVertDiffRule[dltensor] unprotects the VertDiffRules of \
'dltensor' to allow GenerateExpandVertDiffRule and RemoveExpandVertDiffRule \
for 'dltensor'.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VariationalRelationsOf", "::", "usage"}], 
    "=", "\"\<VariationalRelationsOf[tensor, options] returns the list of \
tensors variationally related to 'tensor'.\n- Options:\n  * Directed -> \
'direction': only the outward/inward/both vertices of the seed tensors are \
included ('direction' can be 'in', 'out' or 'both').\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VariationalVector", "::", "usage"}], 
    "=", "\"\<VariationalVector[tensor] returns the variational vector \
associated with 'tensor'.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VariationalVectorQ", "::", "usage"}], 
    "=", "\"\<VariationalVectorQ[expr] returns True if 'expr' is a \
variational vector.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VariationallyConstantQ", "::", "usage"}], 
    "=", "\"\<VariationallyConstantQ[tensor] returns True if 'tensor' is \
variationally constant.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertBracket", "::", "usage"}], 
    "=", "\"\<VertBracket[vvf1, vvf2] computes the vertical bracket of two \
variational vector fields.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertBracketToVertLie", "::", "usage"}], 
    "=", "\"\<VertBracketToVertLie[expr] rewrites vertical brackets as \
vertical Lie derivatives.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertCartanMagicFormula", "::", "usage"}], 
    "=", "\"\<VertCartanMagicFormula[vvf][expr] applies the vertical Cartan \
magic formula to 'expr'.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDeg", "::", "usage"}], 
    "=", "\"\<VertDeg[expr] returns the vertical degree of 'expr'.\>\""}], 
   ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDiff", "::", "usage"}], 
    "=", "\"\<VertDiff[expr] computes the vertical exterior derivative of \
'expr'.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertExactHeadQ", "::", "usage"}], 
    "=", "\"\<VertExactHeadQ[expr] returns True if 'expr' has VertExact as \
head.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertExactQ", "::", "usage"}], 
    "=", "\"\<VertExactQ[expr] returns True if 'expr' is vertically \
exact.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertInt", "::", "usage"}], 
    "=", "\"\<VertInt[vvf][expr] computes the vertical interior product of \
'vvf' acting on 'expr'.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertLie", "::", "usage"}], 
    "=", "\"\<VertLie[vvf][expr] computes the vertical Lie derivative of \
'vvf' acting on 'expr'.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VVFFromLieD", "::", "usage"}], 
    "=", "\"\<VVFFromLieD[vector][tensors] computes the variational vector \
field associated with the Lie derivative of 'vector' acting on \
'tensors'.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VVFFromList", "::", "usage"}], 
    "=", "\"\<VVFFromList[replacementRules] constructs a variational vector \
field from a list of replacement rules.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VVFQ", "::", "usage"}], 
    "=", "\"\<VVFQ[expr] returns True if 'expr' is a variational vector \
field.\>\""}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"WWedge", "::", "usage"}], 
   "=", "\"\<WWedge[a, b] returns the wedge product of two forms 'a' and 'b'.\
\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\:2a55", "::", "usage"}], 
    "=", "\"\<\:2a55[a, b] or a\:2a55b returns the wedge product of two forms \
'a' and 'b'.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ZeroVertDegQ", "::", "usage"}], " ", "=", 
   " ", "\"\<ZeroVertDegQ[expr] returns True if the vertical degree of 'expr' \
is zero and False otherwise.\>\""}], ";"}]}], "Code",
 CellChangeTimes->{{3.958609682492627*^9, 3.958609682492627*^9}, {
  3.958647951306759*^9, 3.9586479514834538`*^9}, {3.958648015004507*^9, 
  3.9586480281637897`*^9}, {3.9588721091291943`*^9, 3.958872156406557*^9}, {
  3.958875736615984*^9, 3.9588757383079033`*^9}, {3.959506527048828*^9, 
  3.959506543212494*^9}, {3.9595081274527607`*^9, 3.9595081332583027`*^9}, {
  3.959513354402931*^9, 3.959513397947323*^9}, {3.963940802860239*^9, 
  3.9639408151803493`*^9}},ExpressionUUID->"76234f23-4c45-4f45-aa92-\
fce33888b01c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Constants"
}], "Subsection",
 CellChangeTimes->{
  3.9323871707782125`*^9, 3.9483909834395266`*^9, 3.949497793904171*^9, {
   3.951340316310261*^9, 
   3.9513403493165016`*^9}},ExpressionUUID->"fc048aea-2467-9844-bbd0-\
9b04f9c6d238"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$dlTensors", "::", "usage"}], " ", "=", 
    " ", "\"\<$dlTensors=$VertExactForms\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$GeneralizedVVF", "::", "usage"}], " ", "=", 
    " ", "\"\<$GeneralizedVVF is the list of generalized variational vector \
fields (GVVF) defined within the session.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$MasterTensors", "::", "usage"}], " ", "=", 
    " ", "\"\<$MasterTensors returns the list of defined tensors in the \
session that are neither exact vertical forms nor variational vector \
fields.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$NameVerticalExteriorDerivative", "::", "usage"}], " ", "=", 
    " ", "\"\<$NameVerticalExteriorDerivative is a string representing the \
name of the vertical exterior derivative, by default 'dl' (to remind both the \
symbols \[DifferentialD] and \[Delta]).\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$NamesOfSigns", "::", "usage"}], " ", "=", 
    " ", "\"\<$NamesOfSigns returns the symbols of $ConstantSymbols whose \
names begins with '$' and ends in 'Sign'.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$NoetherCurrentSign", "::", "usage"}], " ", "=", 
    " ", "\"\<$NoetherCurrentSign is a constant that controls the sign of the \
Noether current.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$NormalsOfCovD", "::", "usage"}], " ", "=", 
    " ", "\"\<$NormalsOfCovD is the list of fiducial normals associated with \
all the defined covariant derivatives.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$NormalsOfPD", "::", "usage"}], " ", "=", 
    " ", "\"\<$NormalsOfPD is the sublist of $NormalsOfCovD formed by \
fiducial normals defined from partial derivatives (PD). There is one for each \
defined manifold.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$PartialPartialTensors", "::", "usage"}], " ", "=", 
    " ", "\"\<$PartialPartialTensors is a global variable that stores all \
tensors defined as partial derivatives of scalar functions with respect to \
other tensors, i.e. those created via DefPartialPartial.\>\""}], ";"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$RemoveParenthesesPrintAs", "::", "usage"}], " ", "=", 
    " ", "\"\<$RemoveParenthesesPrintAs is a global variable that controls \
the behavior of the private function RemoveOuterParanthesis (used to set the \
PrintAs of the associated tensors VertDiff[tensor] and \
VariationalVector[tensor]). If set to True, the function removes enclosing \
parentheses from strings when present; if False, the strings are returned \
unchanged.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$SortVertOperatorsOrder", "::", "usage"}], " ", "=", 
    " ", "\"\<$SortVertOperatorsOrder is a global variable which encodes the \
default ordering of the vertical operators used in SortVertOperators. This \
ordering determines how expressions with multiple vertical operators are \
sorted.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$SymbolVerticalExteriorDerivative", "::", "usage"}], " ", "=", 
    " ", "\"\<$SymbolVerticalExteriorDerivative is the symbol representing \
the vertical exterior derivative, typically denoted as \[DifferentialD] or \
\[Delta].\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$SymplecticCurrentSign", "::", "usage"}], " ", "=", 
    " ", "\"\<$SymplecticCurrentSign is a constant that controls the sign of \
the symplectic current.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$TotalDerivatives", "::", "usage"}], " ", "=", 
    " ", "\"\<$TotalDerivatives is the list of total derivatives associated \
with all the defined covariant derivatives.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$UseInverseMetric", "::", "usage"}], " ", "=", 
    " ", "\"\<$UseInverseMetric is a boolean flag indicating whether the \
inverse metric is used as the fundamental field instead of the metric. This \
constant should be fixed at the beginning, and posterior changes might \
produce unexpected results.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$VariationalGraph", "::", "usage"}], " ", "=", 
    " ", "\"\<$VariationalGraph is a directed graph that encodes the \
variational dependency relations among tensors within the session.\>\""}], 
   ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$VariationalVectors", "::", "usage"}], " ", "=", 
    " ", "\"\<$VariationalVectors is the list of tensors defined in the \
session as variational vectors.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"$ValuesOfSigns", "::", "usage"}], " ", "=", 
    " ", "\"\<$ValuesOfSigns returns the list of current values of the \
symbols in $NamesOfSigns.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"$VertExactForms", "::", "usage"}], " ", "=", 
   " ", "\"\<$VertExactForms returns the list of tensors defined in the \
session as vertically exact forms.\>\""}], ";"}]}], "Code",
 CellChangeTimes->{{3.958609742917167*^9, 3.9586097511299953`*^9}, 
   3.958872103574093*^9, {3.9595061104136143`*^9, 3.9595061128019447`*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"d596c086-c254-7246-9f2c-3e8daa58797a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Options"
}], "Subsection",
 CellChangeTimes->{
  3.9323871707782125`*^9, 3.9483909834395266`*^9, 3.949497793904171*^9, {
   3.951340316310261*^9, 
   3.9513403562335033`*^9}},ExpressionUUID->"6215ff60-137f-4f4d-9637-\
be07ffea62ea"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Both", "::", "usage"}], " ", "=", 
    " ", "\"\<Both is a possible value for the Directed option in \
VariationalRelationsOf. It specifies that both inward and outward variational \
dependencies should be considered.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CheckGenerateExpandVertDiffRule", "::", "usage"}], " ", "=", 
    " ", "\"\<CheckGenerateExpandVertDiffRule is an option for \
GenerateExpandVertDiffRule. If True, the vertical degree and index positions \
are validated; if False, the rule is generated without checks.\>\""}], ";"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CheckZero", "::", "usage"}], " ", "=", 
    " ", "\"\<CheckZero is an option for DivergenceQ. When set to True, SameQ \
(===) is used to check if the equations of motion vanish (hence returnin \
either True or False); when False, Equal (==) is used possibly returning some \
unevaluated boolean conditions.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConstantTensors", "::", "usage"}], " ", "=", 
    " ", "\"\<ConstantTensors is an option for ExpandVertDiff and related \
functions. It lists tensors to be treated as variationally constant, meaning \
their vertical exterior derivative (VertDiff) is assumed to vanish.\>\""}], 
   ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Directed", "::", "usage"}], " ", "=", 
    " ", "\"\<Directed is an option for SubGraphRelations and \
VariationalRelationsOf. It specifies whether to consider Inward, Outward, or \
both types of variational dependencies.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertDiffBracket", "::", "usage"}], " ", "=", 
    " ", "\"\<ExpandVertDiffBracket is an option for ExpandVertDiff. If True, \
terms with VertDiff@Bracket are expanded.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertDiffCovD", "::", "usage"}], " ", "=", 
    " ", "\"\<ExpandVertDiffCovD is an option for ExpandVertDiff and \
ExpandVertDiffRules. If True, terms with VertDiff@der are expanded.\>\""}], 
   ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertDiffLieD", "::", "usage"}], " ", "=", 
    " ", "\"\<ExpandVertDiffLieD is an option for ExpandVertDiff. If True, \
terms with VertDiff@LieD are expanded.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertDiffScalarFunction", "::", "usage"}], " ", "=", 
    " ", "\"\<ExpandVertDiffScalarFunction is an option for ExpandVertDiff \
and related functions. If True, scalar functions depending on tensor fields \
are expanded using the chain rule (some tensors representing partial \
derivatives might be defined on the fly).\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertDiffTotalDerivative", "::", "usage"}], " ", "=", 
    " ", "\"\<ExpandVertDiffTotalDerivative is an option for ExpandVertDiff \
and ExpandVertDiffRules. When True, VertDiff and TotalDerivativeOfCovD[der] \
commute.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertIntBracket", "::", "usage"}], " ", "=", 
    " ", "\"\<ExpandVertIntBracket is an option for ExpandVertInt. If True, \
terms with VertInt[vvf]@LieD are expanded according to the rules provided by \
'vvf'.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertIntCovD", "::", "usage"}], " ", "=", 
    " ", "\"\<ExpandVertIntCovD is an option for ExpandVertInt. If True, \
terms with VertInt[vvf]@der are expanded according to the rules provided by \
'vvf'.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertIntLieD", "::", "usage"}], " ", "=", 
    " ", "\"\<ExpandVertIntLieD is an option for ExpandVertInt. If True, Lie \
derivatives inside a vertical integral (VertInt) are explicitly \
expanded.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertIntTotalDerivative", "::", "usage"}], " ", "=", 
    " ", "\"\<ExpandVertIntTotalDerivative is an option for ExpandVertInt. If \
True, terms with VertInt[vvf]@TotalDerivative are expanded according to the \
rules provided by 'vvf'.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HideTrivialRelations", "::", "usage"}], " ", "=", 
    " ", "\"\<HideTrivialRelations is an option for VariationalRelationsOf. \
When True, it removes the trivial relations that link any 'tensor' to \
VertDiff[tensor] and VariationalVector[tensor].\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HoldExpandVertDiff", "::", "usage"}], " ", "=", 
    " ", "\"\<HoldExpandVertDiff is an option for ExpandVertDiff and related \
functions. It specifies tensors whose vertical exterior derivative (VertDiff) \
should not be expanded.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HoldExpandVertInt", "::", "usage"}], " ", "=", 
    " ", "\"\<HoldExpandVertInt is an option for ExpandVertInt. It prevents \
the application of the replacement rules given by a variational vector field \
during the expansion.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NonConstantTensors", "::", "usage"}], " ", "=", 
    " ", "\"\<NonConstantTensors is an option for ExpandVertDiff and related \
functions. It lists tensors to be treated as variationally non-constant. All \
other tensors are treated as variationally constant, meaning their vertical \
exterior derivative (VertDiff) is assumed to vanish.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ShowGraph", "::", "usage"}], " ", "=", 
    " ", "\"\<ShowGraph is an option for FindCyclicVariationalRelations. When \
True, it displays the variational graph and highlights detected \
cycles.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Signs", "::", "usage"}], " ", "=", 
    " ", "\"\<Signs is an option for ResetSession. It determines the sign \
convention to be used when redefining constants. It admits the numerical \
values 1 or -1. If the option 0 is chosen, the numerical values are removed \
leaving the symbolic signs.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"UndefInfo", "::", "usage"}], " ", "=", 
    " ", "\"\<UndefInfo is an option for ResetSession. When True, \
ResetSession displays information about undefined objects.\>\""}], ";"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VanishOverOtherForms", "::", "usage"}], " ", "=", 
   " ", "\"\<VanishOverOtherForms is an option for DefGeneralizedVVF. If \
True, the generalized vector field 'GVVF' is assumed to vanish over \
k-vertical-forms not explicitly included in its definition. This behaviour \
appears when using ExpandVertInt.\>\""}], ";"}]}], "Code",
 CellChangeTimes->{
  3.9586097889921875`*^9, 3.958647980572035*^9, {3.958872081870636*^9, 
   3.958872100590914*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"1e25bffe-9bf3-4e48-afc3-0264175cba00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Filter types"
}], "Subsection",
 CellChangeTimes->{
  3.9323871707782125`*^9, 3.9483909834395266`*^9, 3.949497793904171*^9, {
   3.951340316310261*^9, 3.9513403562335033`*^9}, {3.9530615936335278`*^9, 
   3.95306159528388*^9}, {3.9586480445401897`*^9, 
   3.9586480449202843`*^9}},ExpressionUUID->"e7b7ef8c-0b82-5140-b3de-\
a8a04c3edbd1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NonZeroVertDeg", "::", "usage"}], " ", "=", 
    " ", "\"\<NonZeroVertDeg is a type that represents tensors with nonzero \
vertical degree. It can be used with FindAllOfType to extract such tensors \
from expressions.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NormalOfPD", "::", "usage"}], " ", "=", 
    " ", "\"\<NormalOfPD is a type that represents fiducial normals defined \
from partial derivatives (PD). It can be used with FindAllOfType to extract \
such fiducial normals from expressions.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDiffExact", "::", "usage"}], " ", "=", 
    " ", "\"\<VertDiffExact is a type that represents tensors which are exact \
under vertical differentiation. It is used with FindAllOfType to locate \
vertically exact tensors in expressions.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ZeroVertDeg", "::", "usage"}], " ", "=", 
   " ", "\"\<ZeroVertDeg is a type that represents tensors with vertical \
degree equal to zero. It can be used with FindAllOfType to extract them from \
expressions.\>\""}], ";"}]}], "Code",
 CellChangeTimes->{3.9586098529264736`*^9},
 CellLabel->
  "In[178]:=",ExpressionUUID->"ce40d530-2f00-ab4f-97e7-0ee63aae52bf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Begin private"
}], "Section",
 CellChangeTimes->{{3.94839074009263*^9, 3.948390775864776*^9}, {
   3.950882452475324*^9, 3.9508824716066723`*^9}, 3.9513403180810184`*^9, {
   3.951341374078848*^9, 3.951341376989252*^9}, 
   3.9586480660726585`*^9},ExpressionUUID->"20a793a8-ffd8-3f40-969a-\
b9d0b828fcde"],

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<xAct`xCPS`Private`\>\"", "]"}]], "Code",
 CellChangeTimes->{{3.95134141025686*^9, 3.95134141048246*^9}, 
   3.951396243407498*^9, 3.951396287128542*^9, 3.9514136468996983`*^9, 
   3.951418157958233*^9},
 CellLabel->
  "In[182]:=",ExpressionUUID->"6faa2ce8-4dd1-134c-9e07-c3e07b719dd7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ". Initial definitions"
}], "Chapter",
 CellChangeTimes->{{3.931835183304838*^9, 3.931835198995372*^9}, {
  3.9325459631466427`*^9, 3.932545965865753*^9}, {3.948390678027392*^9, 
  3.948390678992587*^9}, {3.948390810409868*^9, 
  3.948390819256956*^9}},ExpressionUUID->"b3d81604-4a66-504d-804b-\
3580e2fc6d6c"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Constants"
}], "Section",
 CellChangeTimes->{{3.931835183304838*^9, 3.931835198995372*^9}, {
   3.9325459631466427`*^9, 3.932545965865753*^9}, {3.933773439964964*^9, 
   3.933773442705488*^9}, 3.948390796182618*^9, {3.9483908730317745`*^9, 
   3.948390897462549*^9}, 
   3.9587535423657455`*^9},ExpressionUUID->"ea3dceee-5d96-4044-9aee-\
c3f921ca5228"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Constants", " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"$SymbolDoubleWedge", "=", "\"\<\:2a55\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
    "$SymbolVerticalExteriorDerivative", "=", "\"\<\[DifferentialD]\>\""}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"$NameVerticalExteriorDerivative", "=", "\"\<dl\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$SymbolVertInt", "=", "\"\<\[ImaginaryI]\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$SymbolVertLie", "=", "\"\<\[DoubleStruckCapitalL]\>\""}], ";"}],
    "\n", "\n", 
   RowBox[{
    RowBox[{"$MasterTensors", ":=", 
     RowBox[{"Complement", "[", 
      RowBox[{"$Tensors", ",", 
       RowBox[{"Select", "[", 
        RowBox[{"$Tensors", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"VertExactHeadQ", "[", "#", "]"}], "||", 
           RowBox[{"VariationalVectorQ", "[", "#", "]"}]}], "&"}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$VertExactForms", ":=", 
     RowBox[{"Select", "[", 
      RowBox[{"$Tensors", ",", "VertExactHeadQ"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$VariationalVectors", ":=", 
     RowBox[{"Select", "[", 
      RowBox[{"$Tensors", ",", "VariationalVectorQ"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$dlTensors", ":=", 
     RowBox[{"Select", "[", 
      RowBox[{"$Tensors", ",", "VertExactHeadQ"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$NormalsOfCovD", ":=", 
     RowBox[{"Select", "[", 
      RowBox[{"$Tensors", ",", "NormalOfCovDQ"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$NormalsOfPD", ":=", 
     RowBox[{"Select", "[", 
      RowBox[{"$Tensors", ",", "NormalOfPDQ"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$PartialPartialTensors", ":=", 
     RowBox[{"Select", "[", 
      RowBox[{"$Tensors", ",", "PartialPartialQ"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$GeneralizedVVF", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$TotalDerivatives", ":=", 
     RowBox[{"TotalDerivativeOfNormal", "/@", "$NormalsOfCovD"}]}], ";"}], 
   "\n", "\n", 
   RowBox[{
    RowBox[{"$UseInverseMetric", "=", "False"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$printAddVariationalRelation", "=", "True"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$VerticalOperators", "=", 
     RowBox[{"{", 
      RowBox[{"VertLie", ",", "VertInt", ",", "VertDiff"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$SortVertOperatorsOrder", "=", "$VerticalOperators"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$AddVariationalRelationDagger", "=", "True"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$RemoveVariationalRelation", "=", "True"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"$GenerateExpandVertDiffRuleDagger", "=", "True"}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`DefSign", "[", 
     RowBox[{
     "$SymplecticCurrentSign", 
      ",", "\"\<\!\(\*SubscriptBox[\(s\), \(symp\)]\)\>\"", ",", "1"}], "]"}],
     ";"}], "\n", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`DefSign", "[", 
     RowBox[{
     "$NoetherCurrentSign", 
      ",", "\"\<\!\(\*SubscriptBox[\(s\), \(Noet\)]\)\>\"", ",", "1"}], "]"}],
     ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"$VariationalGraph", "=", 
     RowBox[{"Graph", "[", 
      RowBox[{
       RowBox[{"{", "Zero", "}"}], ",", " ", 
       RowBox[{"{", "}"}]}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Added", " ", "the", " ", "Zero", " ", "tensor", " ", "because", " ", 
     "an", " ", "empty", " ", "graph", " ", "gives", " ", "problems", " ", 
     "that", " ", "apparently", " ", "are", " ", "bugs", " ", "of", " ", 
     "Mathematica"}], " ", "*)"}]}]}]], "Code",
 CellChangeTimes->{
  3.931835173888859*^9, 3.932016618763871*^9, 3.932017098103591*^9, {
   3.932029445447276*^9, 3.9320294574447227`*^9}, {3.93238709703994*^9, 
   3.932387100607395*^9}, {3.932522442601102*^9, 3.932522444363252*^9}, {
   3.932545695348079*^9, 3.932545698941757*^9}, 3.932545892810255*^9, {
   3.932545937123399*^9, 3.93254596031668*^9}, {3.932814526085003*^9, 
   3.932814526294352*^9}, {3.932816153426747*^9, 3.9328161608275924`*^9}, {
   3.93281919724494*^9, 3.932819197842278*^9}, {3.932822868379238*^9, 
   3.9328228689019203`*^9}, {3.932823453082737*^9, 3.932823454538526*^9}, {
   3.93282351089822*^9, 3.932823515194364*^9}, {3.93282366187314*^9, 
   3.93282369412822*^9}, {3.932824458748579*^9, 3.932824470275997*^9}, 
   3.9328245353761177`*^9, {3.932824573348662*^9, 3.932824576857395*^9}, 
   3.9328810784109645`*^9, {3.9329744812434525`*^9, 3.932974495693836*^9}, {
   3.9330286158870926`*^9, 3.933028618313769*^9}, {3.933074787322033*^9, 
   3.933074787893648*^9}, {3.9331601875907044`*^9, 3.933160191815829*^9}, {
   3.933181870206425*^9, 3.93318187802559*^9}, {3.933330283112919*^9, 
   3.933330330359473*^9}, {3.933402177356253*^9, 3.933402184774551*^9}, {
   3.933402316910454*^9, 3.933402336868727*^9}, {3.933753184973898*^9, 
   3.933753186028893*^9}, {3.9337750669225955`*^9, 3.933775082686982*^9}, {
   3.9337933606058645`*^9, 3.933793364809681*^9}, {3.948556649548764*^9, 
   3.948556652203093*^9}, 3.948568366386123*^9, {3.9485684919961977`*^9, 
   3.948568517571271*^9}, {3.948569086965111*^9, 3.948569101522869*^9}, {
   3.948569176978547*^9, 3.9485691832120733`*^9}, {3.949065188543496*^9, 
   3.949065189994975*^9}, {3.9490652913005867`*^9, 3.94906529141403*^9}, {
   3.949323478965964*^9, 3.949323479629685*^9}, 3.949346039642125*^9, {
   3.949503785122399*^9, 3.9495038383610916`*^9}, {3.949688903262474*^9, 
   3.949688908630066*^9}, {3.949688982043565*^9, 3.949688983783121*^9}, {
   3.949689014398489*^9, 3.9496890517861595`*^9}, 3.949689181735777*^9, {
   3.9499223430407143`*^9, 3.949922347678334*^9}, {3.950013187149435*^9, 
   3.950013192528478*^9}, {3.950106649299848*^9, 3.9501066527194214`*^9}, {
   3.950114235196184*^9, 3.950114237816429*^9}, {3.950123959501705*^9, 
   3.950123962126236*^9}, {3.9505587528805676`*^9, 3.950558755441254*^9}, {
   3.950981125994001*^9, 3.950981131727873*^9}, {3.9510512504168434`*^9, 
   3.951051255775011*^9}, {3.951057434021066*^9, 3.9510574487902775`*^9}, {
   3.951081792802704*^9, 3.951081795230341*^9}, {3.951340268144665*^9, 
   3.9513402695728226`*^9}, 3.9518546096476173`*^9, 3.9518606205540466`*^9, {
   3.9519260309800377`*^9, 3.9519260355071545`*^9}, {3.951926231027031*^9, 
   3.951926269462929*^9}, {3.9521984949877815`*^9, 3.952198502541767*^9}, {
   3.9522647007890244`*^9, 3.9522647354438877`*^9}, {3.952269330221195*^9, 
   3.9522693939097157`*^9}, 3.9530549055935707`*^9, {3.953729862122244*^9, 
   3.953729870600073*^9}, {3.954856908894953*^9, 3.954856909036789*^9}, {
   3.955124960120489*^9, 3.9551249812783375`*^9}, 3.955720336286627*^9, {
   3.9563388754292755`*^9, 3.9563388793381767`*^9}, {3.9563442227436237`*^9, 
   3.956344225024908*^9}, {3.956344891805622*^9, 3.9563448978165054`*^9}, {
   3.956422388802288*^9, 3.956422405093813*^9}, 3.9573253901350536`*^9, 
   3.957354294919935*^9, {3.957623226570175*^9, 3.9576232367244854`*^9}, {
   3.957623287362755*^9, 3.9576233183157005`*^9}, {3.957624014932068*^9, 
   3.9576240253290215`*^9}, {3.9583126678348446`*^9, 3.958312668688837*^9}, {
   3.9583943660107384`*^9, 3.9583943895729847`*^9}, {3.9584361737239685`*^9, 
   3.958436187188305*^9}, {3.960368396560364*^9, 3.960368397057741*^9}, {
   3.960439049284067*^9, 3.96043905333218*^9}, {3.9604643622271194`*^9, 
   3.960464365581295*^9}, {3.96393390530542*^9, 3.9639339197617207`*^9}, {
   3.9639536560118923`*^9, 
   3.963953660485203*^9}},ExpressionUUID->"cad32fb8-4864-9946-ab11-\
dedc0c41a548"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InstallInputAlias", "[", 
     RowBox[{"name_String", ",", "alias_String"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "cur", "}"}], ",", "\n", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Head", "[", "$FrontEnd", "]"}], "===", "FrontEndObject"}], ",", 
        RowBox[{
         RowBox[{"cur", "=", 
          RowBox[{"CurrentValue", "[", 
           RowBox[{"$FrontEnd", ",", "InputAliases"}], "]"}]}], ";", "\n", 
         "\t", 
         RowBox[{"(", "\n", "\t", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"ListQ", "[", "cur", "]"}]}], ",", 
             RowBox[{"cur", "=", 
              RowBox[{"{", "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", "\t", 
           RowBox[{"cur", "=", 
            RowBox[{"DeleteCases", "[", 
             RowBox[{"cur", ",", 
              RowBox[{"(", 
               RowBox[{"name", "->", "_"}], ")"}]}], "]"}]}], ";", "\n", "\t", 
           RowBox[{
            RowBox[{"CurrentValue", "[", 
             RowBox[{"$FrontEnd", ",", "InputAliases"}], "]"}], "=", 
            RowBox[{"Append", "[", 
             RowBox[{"cur", ",", 
              RowBox[{"name", "->", "alias"}]}], "]"}]}], ";"}], "\n", "\t", 
          ")"}]}], ",", "\n", "\t", "Null"}], "]"}]}], "\n", "]"}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"InstallInputAlias", "[", 
   RowBox[{"\"\<ww\>\"", ",", " ", "\"\<\:2a55\>\""}], "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.9639535693418217`*^9, 
  3.96395366641321*^9}},ExpressionUUID->"ff1edf6c-f98d-2648-8a43-\
e0909e841c9c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". WWedge product"
}], "Section",
 CellChangeTimes->{{3.9318352080868235`*^9, 3.931835216020525*^9}, {
  3.948390952164976*^9, 
  3.948390967433253*^9}},ExpressionUUID->"73cc8540-843d-3048-ab21-\
9a002639aa2e"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Definition"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, {
   3.948390974972585*^9, 
   3.9483909758336053`*^9}},ExpressionUUID->"d5883fbd-7585-1b4a-b752-\
fd1cc2a2b527"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Definition", " ", "of", " ", "WWedge", " ", "as", " ", "a", " ", 
    "DefProduct"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"DefProduct", "[", 
     RowBox[{"WWedge", ",", "\[IndentingNewLine]", "\t", 
      RowBox[{"AssociativeProductQ", "\[Rule]", "True"}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
      "CommutativityOfProduct", "\[Rule]", "\"\<SuperCommutative\>\""}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"GradedProductQ", "\[Rule]", "True"}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"IdentityElementOfProduct", "\[Rule]", "1"}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"ScalarsOfProduct", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"SameQ", "[", 
          RowBox[{
           RowBox[{"Grade", "[", 
            RowBox[{
             RowBox[{"#", "//", "ReleaseHold"}], ",", "WWedge"}], "]"}], ",", 
           "0"}], "]"}], "&"}], ")"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"ReleaseHold", " ", "prevents", " ", 
        RowBox[{"Grade", "[", 
         RowBox[{"HoldForm", "[", "expr", "]"}], "]"}], " ", "to", " ", "be", 
        " ", "evaluated", " ", "as", " ", "zero", " ", "removing", " ", "the",
         " ", "WWedge"}], " ", "*)"}], " ", "\n", "\t", 
      RowBox[{"PrintAs", "\[Rule]", "$SymbolDoubleWedge"}], ",", " ", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",",
       "\[IndentingNewLine]", "\t", 
      RowBox[{"DefInfo", "\[Rule]", "Null"}]}], "\[IndentingNewLine]", "]"}], 
    ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"MakeExpression", "[", 
     RowBox[{
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"x_", ",", "\"\<\:2a55\>\"", ",", "y__"}], "}"}], "]"}], ",", 
      "StandardForm"}], "]"}], ":=", 
    RowBox[{"MakeExpression", "[", 
     RowBox[{
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<WWedge\>\"", ",", "\"\<[\>\"", ",", "x", ",", "\"\<,\>\"",
          ",", 
         RowBox[{"Sequence", "@@", 
          RowBox[{"Riffle", "[", 
           RowBox[{
            RowBox[{"DeleteCases", "[", 
             RowBox[{
              RowBox[{"{", "y", "}"}], ",", "\"\<\:2a55\>\""}], "]"}], ",", 
            " ", "\"\<,\>\""}], "]"}]}], ",", "\"\<]\>\""}], "}"}], "]"}], ",",
       "StandardForm"}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"\:2a55", "[", "x__", "]"}], ":=", 
    RowBox[{"WWedge", "[", "x", "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Relation", " ", "between", " ", "Wedge", " ", "and", " ", 
     RowBox[{"Times", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"WWedge", "/:", 
     RowBox[{"GradeOfProduct", "[", 
      RowBox[{"Times", ",", "WWedge"}], "]"}], "=", "0"}], ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "forces", " ", "Leibniz", " ", "for", " ", "PD", " ", "and", 
     " ", 
     RowBox[{"LieD", ".", " ", "This"}], " ", "condition", " ", "is", " ", 
     "later", " ", "imposed", " ", "on", " ", "every", " ", "newly", " ", 
     "defined", " ", "covariant", " ", "derivative"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"Unprotect", "[", 
     RowBox[{"PD", ",", "LieD"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"PD", "[", "a_", "]"}], "[", "expr_WWedge", "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"MapAt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"PD", "[", "a", "]"}], "[", "#", "]"}], "&"}], ",", "expr",
          ",", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";"}], " ",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"LieD", "[", "a_", "]"}], "[", "expr_WWedge", "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"MapAt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"LieD", "[", "a", "]"}], "[", "#", "]"}], "&"}], ",", 
         "expr", ",", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";"}], " ",
    "\n", 
   RowBox[{
    RowBox[{"Protect", "[", 
     RowBox[{"PD", ",", "LieD"}], "]"}], ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Behavior", " ", "of", " ", "the", " ", "WWedge", " ", "product", " ", 
     "with", " ", "respect", " ", "to", " ", "Dagger"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"Unprotect", "@", "Dagger"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Dagger", "@", "expr_WWedge"}], ":=", 
    RowBox[{"Dagger", "/@", "expr"}]}], "\n", 
   RowBox[{
    RowBox[{"Protect", "@", "Dagger"}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "WWedge", "]"}], ";"}]}]}]], "Code",
 CellChangeTimes->{{3.931835244608453*^9, 3.931835262815845*^9}, {
   3.932094551481159*^9, 3.932094561197484*^9}, 3.932387121194266*^9, 
   3.932522465367861*^9, {3.932711179759234*^9, 3.932711187099431*^9}, {
   3.932974504757917*^9, 3.932974559023611*^9}, {3.932974616421824*^9, 
   3.932974631900066*^9}, {3.932974682114941*^9, 3.932974693780903*^9}, {
   3.932974751923594*^9, 3.93297490342438*^9}, {3.9329749609361277`*^9, 
   3.9329749613175044`*^9}, {3.932975100159003*^9, 3.932975102348543*^9}, {
   3.932975133541734*^9, 3.932975135059211*^9}, {3.932975177804269*^9, 
   3.9329752523152704`*^9}, 3.933159142189101*^9, {3.933181760193035*^9, 
   3.933181776167663*^9}, {3.9334023407442374`*^9, 3.9334023604094305`*^9}, {
   3.948540822207954*^9, 3.94854084619448*^9}, {3.948568478042529*^9, 
   3.948568486410521*^9}, 3.948569106896649*^9, {3.949766473419626*^9, 
   3.949766481437725*^9}, {3.95121819542246*^9, 3.951218212325302*^9}, {
   3.9512182532735367`*^9, 3.951218254189655*^9}, {3.952274089773533*^9, 
   3.952274107231203*^9}, {3.9549462177327595`*^9, 3.954946237318491*^9}, 
   3.9585813416606426`*^9, {3.958868298420292*^9, 3.958868364254236*^9}, {
   3.963935243099924*^9, 3.9639352745656624`*^9}, {3.9639355938595924`*^9, 
   3.9639356078501415`*^9}, {3.9639407786077614`*^9, 3.963940783864006*^9}, {
   3.9639409551228294`*^9, 3.9639409987958794`*^9}, {3.9639411120278683`*^9, 
   3.963941123569042*^9}, {3.963941342629816*^9, 3.9639413524618816`*^9}, {
   3.9639415848938637`*^9, 3.963941585052973*^9}, {3.9639418695396194`*^9, 
   3.9639418755610256`*^9}, {3.963942168863907*^9, 3.9639421694079876`*^9}, {
   3.9639426561968346`*^9, 3.963942672303997*^9}, {3.963942807393013*^9, 
   3.963942837459049*^9}, {3.963942888046959*^9, 3.963942888808056*^9}, {
   3.963942937166258*^9, 3.9639429399524345`*^9}, 3.963943001085474*^9, 
   3.9639430533312016`*^9, {3.963943211166815*^9, 3.963943238861723*^9}, {
   3.9639436476691055`*^9, 3.9639436626913757`*^9}, 3.9639437134527817`*^9, {
   3.963943765492199*^9, 3.9639437984561443`*^9}, {3.9639439209603424`*^9, 
   3.9639439670966473`*^9}, {3.963943998229355*^9, 3.96394400313365*^9}, {
   3.963944062311533*^9, 3.9639440804101734`*^9}, {3.9639442725246143`*^9, 
   3.963944276813278*^9}, {3.963948976231575*^9, 3.9639490260358734`*^9}, {
   3.963949128699812*^9, 3.963949198234207*^9}, {3.9639493074716988`*^9, 
   3.96394931224922*^9}, {3.9639494079898205`*^9, 3.9639494158617287`*^9}, {
   3.9639494848938675`*^9, 3.96394950038945*^9}, {3.963949588966667*^9, 
   3.9639496929205513`*^9}, {3.9639498178018303`*^9, 
   3.9639498440213413`*^9}, {3.9639499266646423`*^9, 3.963949953623371*^9}, {
   3.963950004632353*^9, 3.9639500301406174`*^9}, {3.9639500851614265`*^9, 
   3.9639501212793465`*^9}, {3.963950181678734*^9, 3.963950181867504*^9}, {
   3.9639502356708393`*^9, 3.9639502580081882`*^9}, {3.9639503319098816`*^9, 
   3.963950342050501*^9}, {3.963950522643078*^9, 3.963950537621464*^9}, {
   3.9639505896749268`*^9, 3.9639505905188656`*^9}, {3.9639506502411976`*^9, 
   3.9639507992914925`*^9}, {3.9639508811178665`*^9, 
   3.9639509035397644`*^9}, {3.963950988450056*^9, 3.963951036985918*^9}, {
   3.9639511265589066`*^9, 3.963951164346859*^9}, {3.963951266332897*^9, 
   3.963951340505274*^9}, {3.963951382277708*^9, 3.9639513976632442`*^9}, {
   3.9639515318292522`*^9, 3.9639515409793434`*^9}, {3.963951628381178*^9, 
   3.963951682589857*^9}, {3.9639517737018585`*^9, 3.963951779063383*^9}, {
   3.963951829707327*^9, 3.963951880549301*^9}, {3.9639519763105526`*^9, 
   3.963951979813423*^9}, {3.9639520641203175`*^9, 3.963952084519064*^9}, {
   3.9639521891212006`*^9, 3.9639522058692245`*^9}, {3.963952252970501*^9, 
   3.9639522547731743`*^9}, {3.963952342354723*^9, 3.9639523578418694`*^9}, 
   3.96395243457967*^9, 3.9639525323304157`*^9, {3.963952617088606*^9, 
   3.963952618960823*^9}, 3.9639526614578285`*^9, {3.963952877154211*^9, 
   3.963952902943308*^9}},ExpressionUUID->"7db193a4-e397-b14d-8f1e-\
371ae8a45729"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Vertical degree"
}], "Subsection",
 CellChangeTimes->{{3.931835288077461*^9, 3.931835292068521*^9}, 
   3.9483909812988634`*^9},ExpressionUUID->"d9a3d784-a66b-7d4b-9110-\
7377c12b54f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "prevents", " ", "to", " ", "assign", " ", "Zero", " ", "to", 
    " ", 
    RowBox[{"HoldForm", "[", "tensor", "]"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"VertDeg", "[", "x_HoldForm", "]"}], ":=", 
    RowBox[{"HoldForm", "[", 
     RowBox[{"VertDeg", "@@", "x"}], "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "It", " ", "returns", " ", "the", " ", "VertDeg", " ", "of", " ", "a", " ",
      "tensor", " ", 
     RowBox[{"(", 
      RowBox[{"without", " ", "indices"}], ")"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"VertDeg", "[", "delta", "]"}], ":=", "0"}], "\n", 
   RowBox[{
    RowBox[{"VertDeg", "[", 
     RowBox[{"tensor_", "?", "xTensorQ"}], "]"}], ":=", 
    RowBox[{"VertDeg", "[", 
     RowBox[{"TensorWithIndices", "[", "tensor", "]"}], "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "It", " ", "returns", " ", "the", " ", "VertDeg", " ", "of", " ", "a", " ",
      "an", " ", "expression", " ", "with", " ", "indices"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"VertDeg", "[", "expr_", "]"}], ":=", 
    RowBox[{"Grade", "[", 
     RowBox[{"expr", ",", "WWedge"}], "]"}]}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"VertDeg", "[", 
     RowBox[{"expr_", "?", "TotalDerivativeQ"}], "]"}], ":=", 
    RowBox[{"VertDeg", "@@", "expr"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"VertDeg", "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"der_", "?", "CovDQ"}], "[", "ind_", "]"}], "[", 
       RowBox[{"Keep", "[", "expr_", "]"}], "]"}], "]"}], "]"}], ":=", 
    RowBox[{"VertDeg", "[", "expr", "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.9318353040553637`*^9, 3.932387131839949*^9, {3.932522475852194*^9, 
   3.932522480129876*^9}, {3.9326168286018*^9, 3.932616848108547*^9}, 
   3.9326532868955*^9, {3.932716604188452*^9, 3.93271660618724*^9}, {
   3.93299999803564*^9, 3.933000004743068*^9}, {3.933159994900171*^9, 
   3.933160004693248*^9}, {3.948568248735626*^9, 3.9485682490098753`*^9}, {
   3.948573388248979*^9, 3.9485734394277687`*^9}, {3.949000212477062*^9, 
   3.949000224549877*^9}, 3.94900029804652*^9, {3.9497665304201107`*^9, 
   3.949766533048828*^9}, {3.9522145866199055`*^9, 3.9522145992054253`*^9}, {
   3.9522148313278694`*^9, 3.9522148389033012`*^9}, {3.9548516486118393`*^9, 
   3.954851653738573*^9}, {3.95485212677017*^9, 3.954852130250551*^9}, {
   3.9548522695260487`*^9, 3.9548522719966583`*^9}},
 CellLabel->
  "In[216]:=",ExpressionUUID->"10718a48-c83b-3d45-9924-f522e5346f9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ZeroVertDegQ and NonZeroVertDegQ"
}], "Subsection",
 CellChangeTimes->{
  3.9323871707782125`*^9, 3.9483909834395266`*^9, {3.951218315123022*^9, 
   3.951218315731592*^9}},ExpressionUUID->"704126bf-7ce3-da48-9046-\
2990c5b3b2ea"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ZeroVertDegQ", "[", "x_HoldForm", "]"}], ":=", 
  RowBox[{"HoldForm", "[", 
   RowBox[{"ZeroVertDegQ", "@@", "x"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ZeroVertDegQ", "[", "expr_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"VertDeg", "[", "expr", "]"}], "==", "0"}], ")"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"NonZeroVertDegQ", "[", "expr_", "]"}], ":=", 
   RowBox[{"!", 
    RowBox[{"ZeroVertDegQ", "[", "expr", "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"ZeroVertDegQ", ",", "NonZeroVertDegQ"}], "]"}], ";"}]}], "Code",
 CellChangeTimes->{
  3.932387178717807*^9, 3.93252248945565*^9, 3.9326532861918*^9, {
   3.93271657285375*^9, 3.932716594941289*^9}, {3.9329749737864747`*^9, 
   3.932974988471778*^9}, {3.932975359678242*^9, 3.932975365238288*^9}, {
   3.932999980392417*^9, 3.932999987635385*^9}, 3.9331599893670464`*^9, {
   3.933232878017504*^9, 3.93323289139299*^9}, {3.933232930400992*^9, 
   3.933232933686694*^9}, 3.94976654256222*^9, {3.954852254554743*^9, 
   3.954852261303999*^9}},
 CellLabel->
  "In[222]:=",ExpressionUUID->"75d6e9b1-008b-2349-85ca-7327af9c61cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VertExactHeadQ"
}], "Subsection",
 CellChangeTimes->{3.9323871707782125`*^9, 3.9483909834395266`*^9, 
  3.949497793904171*^9},ExpressionUUID->"b065038a-a15e-5f41-a8e9-\
455c8b921aa9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertExactHeadQ", "[", "_", "]"}], ":=", "False"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "It", " ", "will", " ", "be", " ", "set", " ", "true", " ", "for", " ", 
    "specific", " ", "cases"}], " ", "*)"}]}]], "Code",
 CellChangeTimes->{{3.949497785982139*^9, 3.949497804164236*^9}},
 CellLabel->
  "In[226]:=",ExpressionUUID->"82e9e54c-f332-fa4a-8650-35d47d535715"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VertExactHeadQ"
}], "Subsection",
 CellChangeTimes->{3.9323871707782125`*^9, 3.9483909834395266`*^9, 
  3.949497793904171*^9},ExpressionUUID->"d599768e-dc36-a743-a975-\
97f514e0c587"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertExactQ", "[", 
      RowBox[{
       RowBox[{"tensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], 
      "]"}], "/;", 
     RowBox[{
      RowBox[{"SlotsOfTensor", "[", "tensor", "]"}], "===", 
      RowBox[{"xAct`xTensor`Private`SignedVBundleOfIndex", "/@", 
       RowBox[{"{", "inds", "}"}]}]}]}], ":=", "True"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "A", " ", "tensor", " ", "defined", " ", "as", " ", "VertExact", " ", 
    "with", " ", "the", " ", "right", " ", "indices"}], " ", "*)"}]}]], "Code",
 CellChangeTimes->{{3.949497785982139*^9, 3.949497804164236*^9}, {
   3.957318225444437*^9, 3.95731825156814*^9}, {3.9573183304186745`*^9, 
   3.957318358139969*^9}, 3.957319492313469*^9},
 CellLabel->
  "In[227]:=",ExpressionUUID->"c5d2476a-f319-564a-9c36-6133ccf09593"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". CTensors and xCoba (not fully tested, to be tested for future versions)"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, {3.9548532814390984`*^9, 
   3.954853282270151*^9}, {3.954945085062256*^9, 3.954945088341896*^9}, {
   3.9572763108875027`*^9, 
   3.957276314849594*^9}},ExpressionUUID->"9a38a59b-aab9-5747-a619-\
7535861c8383"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "In", " ", "this", " ", "section", " ", "we", " ", "implement", " ", "the",
     " ", "WWedge", " ", "product", " ", "of", " ", "CTensor", " ", 
    RowBox[{"objects", ".", " ", "This"}], " ", "code", " ", "has", " ", 
    "been", " ", "supplied", " ", "by", " ", "Jos\[EAcute]", " ", 
    "Mart\[IAcute]n"}], "-", 
   RowBox[{"Garc\[IAcute]a", " ", "for", " ", "the", " ", "xTerior", " ", 
    RowBox[{"package", ".", " ", "This"}], " ", "part", " ", "has", " ", 
    "not", " ", "been", " ", "tested", " ", "and", " ", "will", " ", "be", " ",
     "included", " ", "with", " ", "more", " ", "care", " ", "in", " ", "the",
     " ", 
    RowBox[{"future", "."}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.9549452242081203`*^9, 3.954945250633251*^9}, {
   3.954945350392439*^9, 3.9549453632153225`*^9}, {3.9550950216295757`*^9, 
   3.9550950225723*^9}, 
   3.9572763178223133`*^9},ExpressionUUID->"49966b45-5abe-634f-88d8-\
86109d35d3dc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "[", "WWedge", "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Contracted", " ", "wedge", " ", "product", " ", "of", " ", "CTensor", " ",
     "objects"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"WWedge", "[", 
     RowBox[{
      RowBox[{"ctensor1_CTensor", "[", 
       RowBox[{"left1___", ",", "a_", ",", "right1___"}], "]"}], ",", 
      RowBox[{"ctensor2_CTensor", "[", 
       RowBox[{"left2___", ",", 
        RowBox[{"-", "a_"}], ",", "right2___"}], "]"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"n1", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"{", 
           RowBox[{"left1", ",", "a"}], "}"}], "]"}]}], ",", 
        RowBox[{"n2", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"{", 
           RowBox[{"left2", ",", 
            RowBox[{"-", "a"}]}], "}"}], "]"}]}], ",", "res"}], "}"}], ",", 
      RowBox[{
       RowBox[{"res", "=", 
        RowBox[{"xAct`xCoba`Private`CTensorContract", "[", 
         RowBox[{"ctensor1", ",", "ctensor2", ",", 
          RowBox[{"{", 
           RowBox[{"n1", ",", "n2"}], "}"}], ",", "WWedge"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"res", "[", 
         RowBox[{"left1", ",", "right1", ",", "left2", ",", "right2"}], "]"}],
         "/;", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"res", ",", "$Failed"}], "]"}]}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WWedge", "[", 
    RowBox[{
     RowBox[{"ctensor1_CTensor", "[", 
      RowBox[{"left1___", ",", 
       RowBox[{"-", "a_"}], ",", "right1___"}], "]"}], ",", 
     RowBox[{"ctensor2_CTensor", "[", 
      RowBox[{"left2___", ",", "a_", ",", "right2___"}], "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n1", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"{", 
          RowBox[{"left1", ",", "a"}], "}"}], "]"}]}], ",", 
       RowBox[{"n2", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"{", 
          RowBox[{"left2", ",", 
           RowBox[{"-", "a"}]}], "}"}], "]"}]}], ",", "res"}], "}"}], ",", 
     RowBox[{
      RowBox[{"res", "=", 
       RowBox[{"xAct`xCoba`Private`CTensorContract", "[", 
        RowBox[{"ctensor1", ",", "ctensor2", ",", 
         RowBox[{"{", 
          RowBox[{"n1", ",", "n2"}], "}"}], ",", "WWedge"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"res", "[", 
        RowBox[{"left1", ",", "right1", ",", "left2", ",", "right2"}], "]"}], 
       "/;", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"res", ",", "$Failed"}], "]"}]}]}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9549450960200977`*^9, 3.9549451214904976`*^9}, {
  3.9549462454551277`*^9, 3.954946248617346*^9}},
 CellLabel->
  "In[228]:=",ExpressionUUID->"7e680b59-4081-494d-a98a-a2d9fabec142"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Modifications and extensions to important xAct functions"
}], "Section",
 CellChangeTimes->{{3.931835183304838*^9, 3.931835198995372*^9}, {
   3.9325459631466427`*^9, 3.932545965865753*^9}, {3.933773439964964*^9, 
   3.933773442705488*^9}, 3.948390796182618*^9, {3.9483908730317745`*^9, 
   3.948390881268111*^9}, {3.948391597434294*^9, 3.948391606030911*^9}, {
   3.9548530091896133`*^9, 3.954853011776613*^9}, {3.9548530967425175`*^9, 
   3.9548530968911877`*^9}},ExpressionUUID->"383370d6-0bec-6249-8ed2-\
2a1a5ab07d02"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Extend FindAllOfType"
}], "Subsection",
 CellChangeTimes->{{3.931835183304838*^9, 3.931835198995372*^9}, {
  3.932545952684699*^9, 3.9325459539172482`*^9}, {3.948390905755037*^9, 
  3.9483909157224455`*^9}},ExpressionUUID->"519472fd-e8a8-2749-8a6c-\
ea7ba1d14593"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "FindAllOfType", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FindAllOfType", "[", 
   RowBox[{"expr_", ",", "VertDiffExact"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"expr", "//", "Evaluate"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}], "?", "VertExactQ"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"dltensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}]}], 
     ":>", 
     RowBox[{"dltensor", "[", "inds", "]"}]}], "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FindAllOfType", "[", 
   RowBox[{"expr_", ",", "ZeroVertDeg"}], "]"}], ":=", 
  RowBox[{"Cases", "[", 
   RowBox[{"expr", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}], "?", 
     "ZeroVertDegQ"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      InterpretationBox["\[Infinity]",
       DirectedInfinity[1]]}], "}"}], ",", 
    RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FindAllOfType", "[", 
   RowBox[{"expr_", ",", "NonZeroVertDeg"}], "]"}], ":=", 
  RowBox[{"Cases", "[", 
   RowBox[{"expr", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}], "?", 
     "NonZeroVertDegQ"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      InterpretationBox["\[Infinity]",
       DirectedInfinity[1]]}], "}"}], ",", 
    RowBox[{"Heads", "->", "True"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"FindAllOfType", "[", 
   RowBox[{"expr_", ",", "VariationalVector"}], "]"}], " ", ":=", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", " ", 
     RowBox[{
      RowBox[{"_", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"xTensorQ", "[", "#", "]"}], "&&", 
          RowBox[{"VariationalVectorQ", "[", "#", "]"}]}], "&"}], ")"}]}], "[",
       "___", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
     RowBox[{"Heads", " ", "->", " ", "True"}]}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"vv_", "?", "VariationalVectorQ"}], "[", "inds___", "]"}]}], ":>", 
     RowBox[{"vv", "[", "inds", "]"}]}], "}"}]}]}], "\n", 
 RowBox[{
  RowBox[{"FindAllOfType", "[", 
   RowBox[{"expr_", ",", "NormalOfCovD"}], "]"}], " ", ":=", 
  RowBox[{"Cases", "[", 
   RowBox[{"expr", ",", " ", 
    RowBox[{
     RowBox[{"_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"xTensorQ", "[", "#", "]"}], "&&", 
         RowBox[{"NormalOfCovDQ", "[", "#", "]"}]}], "&"}], ")"}]}], "[", 
     "___", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
    RowBox[{"Heads", " ", "->", " ", "True"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"FindAllOfType", "[", 
   RowBox[{"expr_", ",", "NormalOfPD"}], "]"}], " ", ":=", 
  RowBox[{"Cases", "[", 
   RowBox[{"expr", ",", " ", 
    RowBox[{
     RowBox[{"_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"xTensorQ", "[", "#", "]"}], "&&", 
         RowBox[{"NormalOfPDQ", "[", "#", "]"}]}], "&"}], ")"}]}], "[", "___",
      "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
    RowBox[{"Heads", " ", "->", " ", "True"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"FindAllOfType", "[", 
   RowBox[{"expr_", ",", "PartialPartial"}], "]"}], " ", ":=", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", " ", 
     RowBox[{
      RowBox[{"_", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"xTensorQ", "[", "#", "]"}], "&&", 
          RowBox[{"PartialPartialQ", "[", "#", "]"}]}], "&"}], ")"}]}], "[", 
      "___", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
     RowBox[{"Heads", " ", "->", " ", "True"}]}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"pp_", "?", "PartialPartialQ"}], "[", "inds___", "]"}]}], ":>", 
     RowBox[{"pp", "[", "inds", "]"}]}], "}"}]}]}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "FindAllOfType", "]"}], ";"}]}], "Code",
 CellChangeTimes->{
  3.931835173888859*^9, 3.932016618763871*^9, 3.932017098103591*^9, {
   3.932029445447276*^9, 3.9320294574447227`*^9}, {3.93238709703994*^9, 
   3.932387100607395*^9}, {3.932522442601102*^9, 3.932522444363252*^9}, {
   3.932545695348079*^9, 3.932545698941757*^9}, 3.932545892810255*^9, {
   3.932545937123399*^9, 3.932545968076569*^9}, {3.9332328999575434`*^9, 
   3.9332329180940666`*^9}, 3.933232973673506*^9, {3.933328184566281*^9, 
   3.933328198323458*^9}, {3.933406085505473*^9, 3.933406085785859*^9}, {
   3.93859430834272*^9, 3.938594323448241*^9}, {3.93859467909415*^9, 
   3.9385946797400894`*^9}, {3.949173445648691*^9, 3.949173445813621*^9}, {
   3.949173577156468*^9, 3.9491736262244625`*^9}, {3.9491736955966663`*^9, 
   3.949173711339041*^9}, {3.9491737791396084`*^9, 3.949173788393097*^9}, 
   3.94917383894631*^9, {3.94917387918828*^9, 3.949173887493431*^9}, 
   3.949174059314368*^9, {3.949174812784334*^9, 3.949174840632721*^9}, {
   3.950298253376395*^9, 3.9502982573545685`*^9}, {3.950299004031847*^9, 
   3.9502990045220184`*^9}, {3.9518501284049416`*^9, 
   3.9518501288723392`*^9}, {3.9537274151398945`*^9, 3.953727415379078*^9}, {
   3.9537282893089123`*^9, 3.9537282985497932`*^9}, {3.9537288966860485`*^9, 
   3.953728904931204*^9}, {3.9564255326758327`*^9, 3.956425542700756*^9}, {
   3.9596628038326073`*^9, 3.9596628434421005`*^9}},
 CellLabel->
  "In[231]:=",ExpressionUUID->"9ab8f331-09b6-7946-ae75-6f36f1b1315d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification to SeparateDir"
}], "Subsection",
 CellChangeTimes->{{3.931835183304838*^9, 3.931835198995372*^9}, {
   3.932545952684699*^9, 3.9325459539172482`*^9}, {3.933773395538263*^9, 
   3.93377340300153*^9}, 3.948390918907123*^9, 3.9538210138236046`*^9, {
   3.9548530819135017`*^9, 
   3.954853093259304*^9}},ExpressionUUID->"608c134e-3939-6e40-bc71-\
409f6c0715ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"We", " ", "change", " ", "Times", " ", "for", " ", "WWedge"}], 
   " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"xAct`xTensor`Private`separateDir", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"Dir", "[", "v_", "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\n", "\t", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ultraindex", "=", 
        RowBox[{"xAct`xTensor`Private`UltraindexOf", "[", "v", "]"}]}], ",", 
       "dummy"}], "}"}], ",", "\n", "\t", 
     RowBox[{
      RowBox[{"dummy", "=", 
       RowBox[{"DummyAs", "[", "ultraindex", "]"}]}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"ReplaceIndex", "[", 
        RowBox[{"v", ",", 
         RowBox[{"ultraindex", "\[Rule]", "dummy"}]}], "]"}], "~", "WWedge", "~", 
       RowBox[{"xAct`xTensor`Private`changeDir", "[", 
        RowBox[{"expr", ",", 
         RowBox[{"-", "dummy"}]}], "]"}]}]}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.9337728002511544`*^9, {3.9337729077728024`*^9, 3.9337729474237776`*^9}, {
   3.933773008599867*^9, 3.933773027709434*^9}, {3.933773142875366*^9, 
   3.9337733334916167`*^9}, {3.933789880444741*^9, 3.933789883090141*^9}, {
   3.933790859190401*^9, 3.933790946310397*^9}, {3.933791007045933*^9, 
   3.9337911754966106`*^9}, {3.933791208027354*^9, 3.933791215794925*^9}, 
   3.933791263416277*^9, {3.948544602966425*^9, 3.948544616403118*^9}, {
   3.9496947512912216`*^9, 3.949694819744192*^9}, {3.9497664113087177`*^9, 
   3.9497664517578316`*^9}, {3.9501001910079613`*^9, 3.950100207822241*^9}, {
   3.951218336483438*^9, 3.951218354611109*^9}, 3.95122460001625*^9, {
   3.951319393139808*^9, 3.951319405265249*^9}, 3.951339809136204*^9, {
   3.9533188656485653`*^9, 3.9533188792952137`*^9}, 3.953319953362335*^9, {
   3.953320085416912*^9, 3.9533201093141785`*^9}, {3.953320150009737*^9, 
   3.9533201658492527`*^9}, {3.953320211369938*^9, 3.953320220237505*^9}, {
   3.9533210496825027`*^9, 3.9533210544856815`*^9}, {3.953321151292383*^9, 
   3.953321152646736*^9}, {3.953820988992325*^9, 3.9538210059378567`*^9}, {
   3.957275459305212*^9, 3.9572754597949543`*^9}},
 CellLabel->
  "In[240]:=",ExpressionUUID->"a0991fb5-5a55-ea44-aaa5-fedaa290d9a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modifications to LieD and LieDToCovD"
}], "Subsection",
 CellChangeTimes->{{3.931835183304838*^9, 3.931835198995372*^9}, {
   3.932545952684699*^9, 3.9325459539172482`*^9}, {3.933773395538263*^9, 
   3.93377340300153*^9}, 3.948390918907123*^9, {3.954852888189472*^9, 
   3.954852889316883*^9}, {3.954853085802801*^9, 
   3.954853089885809*^9}},ExpressionUUID->"1d27531a-e2f6-fc47-9e49-\
287a4a9ea634"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "[", "LieD", "]"}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"LieD", 
     RowBox[{
      RowBox[{"\.08", "[", "v", "]"}], "[", "v", "]"}], " ", "is", " ", "not",
      " ", "necessarily", " ", "zero"}], ",", " ", 
    RowBox[{"only", " ", "for", " ", "Even", " ", "VertDeg"}]}], " ", 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"Quiet", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"LieD", "[", 
      RowBox[{
       RowBox[{"xAct`xTensor`Private`v_", "?", "xTensorQ"}], "[", "_Symbol", 
       "]"}], "]"}], "[", 
     RowBox[{
      RowBox[{"(", "xAct`xTensor`Private`v_", ")"}], "[", "_Symbol", "]"}], 
     "]"}], "=."}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"LieD", "[", 
       RowBox[{
        RowBox[{"v_", "?", "xTensorQ"}], "[", "_Symbol", "]"}], "]"}], "[", 
      RowBox[{"v_", "[", "_Symbol", "]"}], "]"}], "/;", 
     RowBox[{"EvenQ", "[", 
      RowBox[{"VertDeg", "[", "v", "]"}], "]"}]}], ":=", " ", "0"}], ";"}], 
  "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"We", " ", "change", " ", "Times", " ", "for", " ", "WWedge"}], 
   " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Private`lieDcovDdiff", "[", 
    RowBox[{
    "expr_", ",", "vector_", ",", "covd_", ",", "vb_", ",", "tmpchrhead_"}], 
    "]"}], ":=", 
   RowBox[{"With", "[", "\n", "\t", 
    RowBox[{
     RowBox[{"{", "\n", "\t", 
      RowBox[{
       RowBox[{"indv", "=", 
        RowBox[{"xAct`xTensor`Private`UltraindexOf", "[", "vector", "]"}]}], ",",
        "\n", "\t", 
       RowBox[{"vbQ", "=", 
        RowBox[{"xAct`xTensor`Private`VBundleIndexQ", "[", "vb", "]"}]}], ",",
        "\n", "\t", 
       RowBox[{"inds", "=", 
        RowBox[{"FindFreeIndices", "[", "expr", "]"}]}], ",", "\n", "\t", 
       RowBox[{"dummy", "=", 
        RowBox[{"DummyIn", "[", "vb", "]"}]}], ",", "\n", "\t", 
       RowBox[{"dummy2", "=", 
        RowBox[{"DummyIn", "[", "vb", "]"}]}]}], "\n", "\t", "}"}], ",", "\n",
      "\t", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"CovDQ", "[", "covd", "]"}]}], ",", 
        RowBox[{"Throw", "[", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            StyleBox[
             RowBox[{"LieD", "::", "unknown"}], "MessageName"], 
            ",", "\"\<derivative\>\"", ",", "covd"}], "]"}], ";", 
          RowBox[{
           StyleBox["ERROR",
            FontColor->Hue[0.]], 
           StyleBox["[",
            FontColor->Hue[0.]], 
           RowBox[{
            RowBox[{"LieD", "[", 
             RowBox[{"vector", ",", "covd"}], "]"}], "[", "expr", "]"}], 
           "]"}]}], "]"}]}], "]"}], ";", "\n", "\t", 
      RowBox[{"xAct`xTensor`Private`ValidateDir", "[", 
       RowBox[{"Dir", "[", "vector", "]"}], "]"}], ";", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"covd", "=!=", "PD"}], "&&", 
         RowBox[{
          RowBox[{"ManifoldOfCovD", "[", "covd", "]"}], "=!=", 
          RowBox[{"BaseOfVBundle", "[", "vb", "]"}]}]}], ",", 
        RowBox[{"Throw", "[", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            StyleBox[
             RowBox[{"LieD", "::", "error"}], "MessageName"], 
            ",", "\"\<Invalid derivative in Lie Derivative.\>\""}], "]"}], ";", 
          RowBox[{
           StyleBox["ERROR",
            FontColor->Hue[0.]], "[", 
           RowBox[{
            RowBox[{"LieD", "[", 
             RowBox[{"vector", ",", "covd"}], "]"}], "[", "expr", "]"}], 
           "]"}]}], "]"}]}], "]"}], ";", "\n", "\t", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", "\n", "\t\t  ", 
         RowBox[{
          RowBox[{"torsion", "=", 
           RowBox[{"Torsion", "[", "covd", "]"}]}], ",", "\n", "\t\t  ", 
          RowBox[{"newv", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"TorsionQ", "[", "covd", "]"}], ",", 
             RowBox[{"ReplaceIndex", "[", 
              RowBox[{"vector", ",", 
               RowBox[{"indv", "\[Rule]", "dummy2"}]}], "]"}], ",", "0"}], 
            "]"}]}]}], "\n", "\t\t  ", "}"}], ",", "\n", "\t\t  ", 
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{"Plus", "@@", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"tmpchrhead", "[", 
                  RowBox[{
                   RowBox[{"covd", "[", 
                    RowBox[{"-", "#1"}], "]"}], "[", 
                   RowBox[{"ReplaceIndex", "[", 
                    RowBox[{"vector", ",", 
                    RowBox[{"indv", "\[Rule]", "dummy"}]}], "]"}], "]"}], 
                  "]"}], "\n", "\t\t  ", "+", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox[
                    SubscriptBox["s", "T"],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   xAct`xTensor`$TorsionSign,
                   Editable->False], " ", "newv", " ", 
                  RowBox[{"torsion", "[", 
                   RowBox[{"dummy", ",", 
                    RowBox[{"-", "dummy2"}], ",", 
                    RowBox[{"-", "#1"}]}], "]"}]}]}], ")"}], "~", "WWedge", "~", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{
                  RowBox[{"-", "#1"}], "\[Rule]", 
                  RowBox[{"-", "dummy"}]}]}], "]"}]}], "&"}], ")"}], "/@", 
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"ChangeIndex", "/@", "inds"}], ",", "vbQ"}], "]"}]}]}], 
          "-", 
          RowBox[{"Plus", "@@", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"tmpchrhead", "[", 
                  RowBox[{
                   RowBox[{"covd", "[", 
                    RowBox[{"-", "dummy"}], "]"}], "[", 
                   RowBox[{"ReplaceIndex", "[", 
                    RowBox[{"vector", ",", 
                    RowBox[{"indv", "\[Rule]", "#1"}]}], "]"}], "]"}], "]"}], 
                 "\n", "\t\t  ", "+", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox[
                    SubscriptBox["s", "T"],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   xAct`xTensor`$TorsionSign,
                   Editable->False], " ", "newv", " ", 
                  RowBox[{"torsion", "[", 
                   RowBox[{"#1", ",", 
                    RowBox[{"-", "dummy2"}], ",", 
                    RowBox[{"-", "dummy"}]}], "]"}]}]}], ")"}], "~", "WWedge",
                "~", 
               RowBox[{"ReplaceIndex", "[", 
                RowBox[{"expr", ",", 
                 RowBox[{"#1", "\[Rule]", "dummy"}]}], "]"}]}], "&"}], ")"}], 
            "/@", 
            RowBox[{"Select", "[", 
             RowBox[{"inds", ",", "vbQ"}], "]"}]}]}], "+", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"xAct`xTensor`Private`WeightedCovDQ", "[", "covd", "]"}], 
            ",", 
            RowBox[{"With", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"weight", "=", 
                RowBox[{"WeightOf", "[", 
                 RowBox[{"expr", ",", 
                  RowBox[{"WeightedWithBasis", "[", "covd", "]"}]}], "]"}]}], 
               "}"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"weight", "=!=", "0"}], ",", 
                RowBox[{"weight", " ", 
                 RowBox[{"expr", " ", "~", "WWedge", "~", " ", 
                  RowBox[{
                   RowBox[{"covd", "[", 
                    RowBox[{"-", "indv"}], "]"}], "[", "vector", "]"}]}]}], ",",
                 "0"}], "]"}]}], "]"}], ",", "0"}], "]"}]}], "]"}]}], "\n", 
       "\t\t", "]"}]}]}], "\n", "\t", "]"}]}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "LieD", "]"}], ";"}]}], "Code",
 CellChangeTimes->{
  3.9337728002511544`*^9, {3.9337729077728024`*^9, 3.9337729474237776`*^9}, {
   3.933773008599867*^9, 3.933773027709434*^9}, {3.933773142875366*^9, 
   3.9337733334916167`*^9}, {3.933789880444741*^9, 3.933789883090141*^9}, {
   3.933790859190401*^9, 3.933790946310397*^9}, {3.933791007045933*^9, 
   3.9337911754966106`*^9}, {3.933791208027354*^9, 3.933791215794925*^9}, 
   3.933791263416277*^9, {3.948544602966425*^9, 3.948544616403118*^9}, {
   3.9496947512912216`*^9, 3.949694819744192*^9}, {3.9497664113087177`*^9, 
   3.9497664517578316`*^9}, {3.9501001910079613`*^9, 3.950100207822241*^9}, {
   3.951218336483438*^9, 3.951218354611109*^9}, 3.95122460001625*^9, {
   3.951319393139808*^9, 3.951319405265249*^9}, 3.951339809136204*^9, {
   3.9533188656485653`*^9, 3.9533188792952137`*^9}, 3.953319953362335*^9, {
   3.953320085416912*^9, 3.9533201093141785`*^9}, {3.953320150009737*^9, 
   3.9533201658492527`*^9}, {3.953320211369938*^9, 3.953320220237505*^9}, {
   3.9533210496825027`*^9, 3.9533210544856815`*^9}, {3.953321151292383*^9, 
   3.953321152646736*^9}, {3.953820995303591*^9, 3.953821020755455*^9}, 
   3.957275520629446*^9, {3.9583126370752506`*^9, 3.9583126493343945`*^9}, {
   3.9639403241182575`*^9, 
   3.9639403257831707`*^9}},ExpressionUUID->"0b0ba89a-e2aa-254b-b34e-\
85bbe4252c00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification to Bracket and BracketToCovD"
}], "Subsection",
 CellChangeTimes->{{3.931835183304838*^9, 3.931835198995372*^9}, {
   3.932545952684699*^9, 3.9325459539172482`*^9}, {3.933773395538263*^9, 
   3.93377340300153*^9}, {3.933793008540386*^9, 3.933793012910167*^9}, 
   3.948390923726533*^9, {3.9548531057490807`*^9, 
   3.9548531071818695`*^9}},ExpressionUUID->"6c6ba394-1c13-c44c-9980-\
d88b0e2bd916"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"\.08", "[", 
      RowBox[{"v", ",", "v"}], "]"}], " ", "is", " ", "not", " ", 
     "necessarily", " ", "zero"}], ",", " ", 
    RowBox[{"only", " ", "for", " ", "Even", " ", "VertDeg"}]}], " ", "*)"}], 
  "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "[", 
     RowBox[{
      RowBox[{"Bracket", "[", 
       RowBox[{"v_", ",", "v_"}], "]"}], "=."}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Bracket", "[", 
     RowBox[{"v_", ",", "v_"}], "]"}], ":=", 
    RowBox[{"Zero", "/;", 
     RowBox[{"EvenQ", "[", 
      RowBox[{"VertDeg", "[", "v", "]"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"We", " ", "change", " ", "Times", " ", "for", " ", "WWedge"}], 
    " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Bracket", "[", 
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{"WWedge", "[", 
          RowBox[{"x___", ",", 
           RowBox[{"s_", "?", "ScalarQ"}], ",", "y___"}], "]"}], "]"}], ",", 
        "v2_"}], "]"}], "[", "a_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v1", ",", 
         RowBox[{"rs", "=", 
          RowBox[{"ReplaceDummies", "[", "s", "]"}]}]}], "}"}], ",", "\n", 
       "\t", 
       RowBox[{
        RowBox[{"v1", "=", 
         RowBox[{"WWedge", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], ";", " ", "\n", "\t", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"VertDeg", "[", "s", "]"}], " ", 
            RowBox[{"Total", "[", 
             RowBox[{"VertDeg", "/@", 
              RowBox[{"{", "x", "}"}]}], "]"}]}], ")"}]}], 
         RowBox[{"(", "\[IndentingNewLine]", "\t", 
          RowBox[{
           RowBox[{"rs", "~", "WWedge", "~", " ", 
            RowBox[{
             RowBox[{"Bracket", "[", 
              RowBox[{"v1", ",", "v2"}], "]"}], "[", "a", "]"}]}], "-", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{
              RowBox[{"VertDeg", "[", "v2", "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"VertDeg", "[", "rs", "]"}], "+", 
                RowBox[{"VertDeg", "[", "v1", "]"}]}], ")"}]}]], 
            RowBox[{
             RowBox[{
              RowBox[{"PD", "[", 
               RowBox[{"Dir", "[", "v2", "]"}], "]"}], "[", "rs", "]"}], "~", 
             "WWedge", "~", 
             RowBox[{"ReplaceIndex", "[", 
              RowBox[{"v1", ",", 
               RowBox[{
                RowBox[{"UltraindexOf", "[", "v1", "]"}], "\[Rule]", "a"}]}], 
              "]"}]}]}]}], ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Bracket", "[", 
       RowBox[{"w1_", ",", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{"WWedge", "[", 
          RowBox[{"x___", ",", 
           RowBox[{"s_", "?", "ScalarQ"}], ",", "y___"}], "]"}], "]"}]}], 
       "]"}], "[", "a_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v1", ",", 
         RowBox[{"v2", "=", "w1"}], ",", 
         RowBox[{"rs", "=", 
          RowBox[{"ReplaceDummies", "[", "s", "]"}]}]}], "}"}], ",", "\n", 
       "\t", 
       RowBox[{
        RowBox[{"v1", "=", 
         RowBox[{"WWedge", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], ";", "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"VertDeg", "[", "v1", "]"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Total", "[", 
                RowBox[{"VertDeg", "/@", 
                 RowBox[{"{", "x", "}"}]}], "]"}], "+", 
               RowBox[{"VertDeg", "[", "s", "]"}], "+", 
               RowBox[{"Total", "[", 
                RowBox[{"VertDeg", "/@", 
                 RowBox[{"{", "y", "}"}]}], "]"}]}], ")"}]}], ")"}]}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"VertDeg", "/@", 
              RowBox[{"{", "x", "}"}]}], "]"}], 
            RowBox[{"VertDeg", "[", "s", "]"}]}], ")"}]}], "\n", "\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"rs", "~", "WWedge", "~", " ", 
            RowBox[{
             RowBox[{"Bracket", "[", 
              RowBox[{"v1", ",", "v2"}], "]"}], "[", "a", "]"}]}], "-", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{
              RowBox[{"VertDeg", "[", "v2", "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"VertDeg", "[", "rs", "]"}], "+", 
                RowBox[{"VertDeg", "[", "v1", "]"}]}], ")"}]}]], 
            RowBox[{
             RowBox[{
              RowBox[{"PD", "[", 
               RowBox[{"Dir", "[", "v2", "]"}], "]"}], "[", "rs", "]"}], "~", 
             "WWedge", "~", 
             RowBox[{"ReplaceIndex", "[", 
              RowBox[{"v1", ",", 
               RowBox[{
                RowBox[{"UltraindexOf", "[", "v1", "]"}], "\[Rule]", "a"}]}], 
              "]"}]}]}]}], ")"}]}]}]}], "\n", "]"}]}], ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "We", " ", "stablish", " ", "an", " ", "order", " ", "that", " ", 
     "depends", " ", "on", " ", "the", " ", "VertDeg"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SubValues", "[", "Bracket", "]"}], "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"SubValues", "[", "Bracket", "]"}], ",", 
       RowBox[{
        RowBox[{"f_", "[", 
         RowBox[{
          RowBox[{"Bracket", "[", 
           RowBox[{
           "xAct`xTensor`Private`expr1_", ",", 
            "xAct`xTensor`Private`expr2_"}], "]"}], "[", 
          "xAct`xTensor`Private`i_", "]"}], "]"}], ":>", 
        RowBox[{
         RowBox[{"h_", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             RowBox[{"Bracket", "[", 
              RowBox[{
              "xAct`xTensor`Private`expr2", ",", 
               "xAct`xTensor`Private`expr1"}], "]"}], "[", 
             "xAct`xTensor`Private`i", "]"}]}], ",", 
           RowBox[{"OrderedQ", "[", 
            RowBox[{"{", 
             RowBox[{
             "xAct`xTensor`Private`expr2", ",", 
              "xAct`xTensor`Private`expr1"}], "}"}], "]"}]}], "]"}], "/;", 
         RowBox[{"h", "===", "Condition"}]}]}]}], "]"}]}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Bracket", "[", 
        RowBox[{"expr1_", ",", "expr2_"}], "]"}], "[", "b_", "]"}], "/;", 
      RowBox[{"(", 
       RowBox[{"!", 
        RowBox[{"OrderedQ", "[", 
         RowBox[{"{", 
          RowBox[{"expr1", ",", "expr2"}], "}"}], "]"}]}], ")"}]}], ":=", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{
         RowBox[{"VertDeg", "[", "expr1", "]"}], 
         RowBox[{"VertDeg", "[", "expr2", "]"}]}]]}], 
      RowBox[{
       RowBox[{"Bracket", "[", 
        RowBox[{"expr2", ",", "expr1"}], "]"}], "[", "b", "]"}]}]}], ";"}], 
   "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Protect", "[", "Bracket", "]"}], ";", " ", 
     RowBox[{
     "Bracket", " ", "is", " ", "not", " ", "protected", " ", "on", " ", 
      "xTensor"}]}], " ", "*)"}]}]}]], "Code",
 CellChangeTimes->{{3.933782621287345*^9, 3.933782631148126*^9}, {
   3.933789674739147*^9, 3.933789781957074*^9}, {3.93378986107464*^9, 
   3.933789906307438*^9}, {3.9337901602987204`*^9, 3.9337901628510895`*^9}, {
   3.933790559736733*^9, 3.933790563231511*^9}, {3.933790670077667*^9, 
   3.9337907055264*^9}, {3.933790782916018*^9, 3.933790783980038*^9}, {
   3.933791805076659*^9, 3.933791959002778*^9}, 3.9337920242283955`*^9, {
   3.933792618634813*^9, 3.933792623083254*^9}, {3.94951101167622*^9, 
   3.949511093910483*^9}, {3.9495140820467396`*^9, 3.949514082699599*^9}, 
   3.9495142345207005`*^9, {3.949514296907049*^9, 3.949514482661515*^9}, {
   3.949514538202137*^9, 3.949514570225916*^9}, 3.949514718137232*^9, {
   3.949514752498595*^9, 3.949514803171713*^9}, {3.949514838687332*^9, 
   3.949514859931917*^9}, {3.94951489241556*^9, 3.9495150059291115`*^9}, {
   3.949515134154152*^9, 3.949515134978878*^9}, {3.949515198449415*^9, 
   3.9495152241606617`*^9}, 3.949515282608288*^9, {3.949515350203987*^9, 
   3.949515366525812*^9}, {3.94951543159548*^9, 3.949515448526177*^9}, {
   3.949515483666506*^9, 3.949515483836168*^9}, {3.9497665937895966`*^9, 
   3.949766658920889*^9}, {3.950100167895048*^9, 3.950100173720707*^9}, {
   3.950282609167961*^9, 3.950282612685568*^9}, {3.950611535566698*^9, 
   3.950611540259861*^9}, {3.951218395456615*^9, 3.951218401730514*^9}, {
   3.9513398270437927`*^9, 3.951339828401392*^9}, {3.951339910814739*^9, 
   3.951339912962986*^9}, {3.951847559866867*^9, 3.951847567764797*^9}, {
   3.952087739880804*^9, 3.9520877433096466`*^9}, {3.952088129232809*^9, 
   3.952088130775715*^9}, {3.9521174411054745`*^9, 3.952117441320692*^9}, {
   3.9521191527803116`*^9, 3.952119190539465*^9}, {3.9521192713863716`*^9, 
   3.952119310842537*^9}, {3.9521195169614124`*^9, 3.9521195179536552`*^9}, {
   3.9521196007796535`*^9, 3.9521196197138424`*^9}, {3.952119686657713*^9, 
   3.952119695860489*^9}, {3.952119754558958*^9, 3.952119792862961*^9}, {
   3.9521198303602276`*^9, 3.9521198623086376`*^9}, {3.9521219356204357`*^9, 
   3.952121964280592*^9}, {3.952122057118471*^9, 3.952122059005846*^9}, {
   3.952204990818369*^9, 3.9522050367433968`*^9}, {3.952206137319357*^9, 
   3.9522061410912724`*^9}, 3.952209128466282*^9, {3.952213362463152*^9, 
   3.952213364951126*^9}, 3.9538536371916294`*^9, {3.9572754697878857`*^9, 
   3.957275472246559*^9}, {3.958225641678669*^9, 3.958225643469677*^9}, {
   3.9582276144333*^9, 3.958227619732374*^9}, {3.9582279190164757`*^9, 
   3.9582279367280426`*^9}, {3.9582280537630405`*^9, 
   3.9582280566691456`*^9}, {3.9582289851006126`*^9, 3.958229005452841*^9}, {
   3.95822909296344*^9, 3.9582291085295753`*^9}, {3.958229198745657*^9, 
   3.958229208487791*^9}, {3.958229449685486*^9, 3.9582294711037865`*^9}, {
   3.9582301602766304`*^9, 3.958230175162243*^9}, {3.9582305364418964`*^9, 
   3.9582305597364235`*^9}, {3.9582317940472984`*^9, 
   3.9582317957424545`*^9}, {3.9583126133938866`*^9, 3.958312617073967*^9}, {
   3.962540246989355*^9, 3.962540270602646*^9}, {3.963940375061098*^9, 
   3.9639403802831497`*^9}},ExpressionUUID->"a506be45-6c5e-c544-8f7d-\
3c8a5b590d7a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "We", " ", "change", " ", "the", " ", "Times", " ", "for", " ", "WWedge"}],
    " ", "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{"BracketToCovD", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"covd_", ":", "PD"}]}], "]"}], ":=", "\n", 
   RowBox[{"expr", "/.", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Bracket", "[", 
       RowBox[{"v1_", ",", "v2_"}], "]"}], "[", "a_", "]"}], "\[RuleDelayed]", 
     RowBox[{"With", "[", "\n", "\t", 
      RowBox[{
       RowBox[{"{", "\n", "\t", 
        RowBox[{
         RowBox[{"u1", "=", 
          RowBox[{"xAct`xTensor`Private`UltraindexOf", "[", "v1", "]"}]}], ",",
          "\n", "\t", 
         RowBox[{"u2", "=", 
          RowBox[{"xAct`xTensor`Private`UltraindexOf", "[", "v2", "]"}]}]}], 
        "\n", "\t", "}"}], ",", "\n", "\t", 
       RowBox[{"With", "[", "\n", "\t\t", 
        RowBox[{
         RowBox[{"{", "\n", "\t\t", 
          RowBox[{
           RowBox[{"b", "=", 
            RowBox[{"DummyAs", "[", "u1", "]"}]}], ",", 
           RowBox[{"c", "=", 
            RowBox[{"DummyAs", "[", "u2", "]"}]}], ",", "\n", "\t\t", 
           RowBox[{"rv1", "=", 
            RowBox[{"ReplaceDummies", "[", "v1", "]"}]}], ",", 
           RowBox[{"rv2", "=", 
            RowBox[{"ReplaceDummies", "[", "v2", "]"}]}]}], "\n", "\t\t", 
          "}"}], ",", "\n", "\t\t", 
         RowBox[{
          RowBox[{
           RowBox[{"ReplaceIndex", "[", 
            RowBox[{"rv1", ",", 
             RowBox[{"u1", "\[Rule]", "b"}]}], "]"}], "~", "WWedge", "~", 
           RowBox[{
            RowBox[{"covd", "[", 
             RowBox[{"-", "b"}], "]"}], "[", 
            RowBox[{"ReplaceIndex", "[", 
             RowBox[{"rv2", ",", 
              RowBox[{"u2", "\[Rule]", "a"}]}], "]"}], "]"}]}], "-", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"covd", "[", 
             RowBox[{"-", "b"}], "]"}], "[", 
            RowBox[{"ReplaceIndex", "[", 
             RowBox[{"rv1", ",", 
              RowBox[{"u1", "\[Rule]", "a"}]}], "]"}], "]"}], "~", "WWedge", "~", 
           RowBox[{"ReplaceIndex", "[", 
            RowBox[{"rv2", ",", 
             RowBox[{"u2", "\[Rule]", "b"}]}], "]"}]}], "-", 
          RowBox[{"$TorsionSign", " ", 
           RowBox[{
            RowBox[{"Torsion", "[", "covd", "]"}], "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "b"}], ",", 
             RowBox[{"-", "c"}]}], "]"}], " ", 
           RowBox[{
            RowBox[{"ReplaceIndex", "[", 
             RowBox[{"rv1", ",", 
              RowBox[{"u1", "\[Rule]", "b"}]}], "]"}], "~", "WWedge", "~", 
            " ", 
            RowBox[{"ReplaceIndex", "[", 
             RowBox[{"rv2", ",", 
              RowBox[{"u2", "\[Rule]", "c"}]}], "]"}]}]}]}]}], "\n", "\t\t", 
        "]"}]}], "\n", "\t", "]"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.952206146562723*^9, 3.952206148739271*^9}, {
  3.9582229651466427`*^9, 3.958222986370247*^9}, {3.95822323099061*^9, 
  3.958223233045597*^9}, {3.9582255709234085`*^9, 3.958225585615204*^9}, {
  3.9582280586297703`*^9, 3.958228108629286*^9}},
 CellLabel->
  "In[254]:=",ExpressionUUID->"80985367-8760-6d4c-8cb0-f14518b3ca47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Extension to Validate"
}], "Subsection",
 CellChangeTimes->{{3.931835183304838*^9, 3.931835198995372*^9}, {
  3.932545952684699*^9, 3.9325459539172482`*^9}, {3.933233930229124*^9, 
  3.933233933700033*^9}, {3.948390929261885*^9, 3.948390932158208*^9}, {
  3.954853113130287*^9, 
  3.954853115966007*^9}},ExpressionUUID->"ad6d18d7-c966-3340-ac3f-\
2567d8d30d5b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "[", "xAct`xTensor`Private`UncatchedValidate", "]"}], 
   ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Validate", "::", "invprod"}], 
    "=", "\"\<Times is not a valid product for vertical forms, use WWedge \
instead.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Private`UncatchedValidate", "[", 
    RowBox[{"Times", "[", 
     RowBox[{"expr1_", ",", "expr2_"}], "]"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"VertDeg", "[", "expr1", "]"}], 
         RowBox[{"VertDeg", "[", "expr2", "]"}]}], ">", "0"}], ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{"Validate", "::", "invprod"}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"FindIndices", "[", 
      RowBox[{"expr1", " ", "expr2"}], "]"}], ";", "\n", "\t", 
     RowBox[{"xAct`xTensor`Private`UncatchedValidate", "/@", 
      RowBox[{"Unevaluated", "[", 
       RowBox[{"expr1", " ", "expr2"}], "]"}]}]}], ")"}]}], "\n", "\t"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "xAct`xTensor`Private`UncatchedValidate", "]"}], 
  ";"}]}], "Code",
 CellChangeTimes->{{3.933233917766615*^9, 3.933233920537439*^9}, {
   3.933325688989771*^9, 3.933325693291643*^9}, {3.933325736690265*^9, 
   3.9333257511396885`*^9}, {3.933325819957802*^9, 3.933325918742042*^9}, {
   3.9333281675885153`*^9, 3.9333281741151867`*^9}, {3.9334023753702574`*^9, 
   3.933402393265273*^9}, {3.933771382367004*^9, 3.933771390175711*^9}, {
   3.9337718963678055`*^9, 3.933771903538869*^9}, {3.948541090187906*^9, 
   3.948541100225441*^9}, {3.951224616427983*^9, 3.951224648944851*^9}, {
   3.9518451484915066`*^9, 3.9518451486789017`*^9}, {3.956084530124281*^9, 
   3.9560845372299786`*^9}, {3.957190988852316*^9, 3.957190989435631*^9}, 
   3.958312597596075*^9},
 CellLabel->
  "In[255]:=",ExpressionUUID->"198f3fe0-199f-324d-a7fa-2c3319427871"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification to ContractMetric"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.954853117804035*^9},ExpressionUUID->"4d810c09-58b0-a946-9408-\
b9f8ff546abc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Private`differentexpressionsQ", "[", 
    RowBox[{"expr1_WWedge", ",", "expr2_List"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`differentexpressionsQ", "[", 
    RowBox[{
     RowBox[{"List", "@@", "expr1"}], ",", "expr2"}], "]"}]}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "We", " ", "change", " ", "the", " ", "Times", " ", "for", " ", "WWedge"}],
    " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"CM", ":", 
      RowBox[{"xAct`xTensor`Private`ContractMetric1", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"od_", ",", "aud_"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"metric_", ",", "nv_"}], "}"}]}], "]"}]}], ")"}], "[", 
    RowBox[{"rest_.", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{"WWedge", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"der_", "?", "FirstDerQ"}], "[", "expr1_", "]"}], ",", 
        "expr2__"}], "]"}], "]"}], 
     RowBox[{"met", ":", 
      RowBox[{"metric_", "[", 
       RowBox[{"b_", ",", "c_"}], "]"}]}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"dm", "=", 
         RowBox[{"der", "[", "met", "]"}]}], ",", "result"}], "}"}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"od", "||", 
           RowBox[{"dm", "===", "0"}]}], ")"}], "&&", 
         RowBox[{"xAct`xTensor`Private`differentexpressionsQ", "[", 
          RowBox[{
           RowBox[{"result", "=", 
            RowBox[{"CM", "[", 
             RowBox[{"expr1", " ", "met"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"expr1", ",", "met"}], "}"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{"rest", " ", 
          RowBox[{"WWedge", "[", 
           RowBox[{
            RowBox[{"CM", "[", 
             RowBox[{"der", "[", "result", "]"}], "]"}], ",", "expr2"}], 
           "]"}]}], "-", 
         RowBox[{"rest", " ", 
          RowBox[{"WWedge", "[", 
           RowBox[{
            RowBox[{"CM", "[", 
             RowBox[{"dm", " ", "expr1"}], "]"}], ",", "expr2"}], "]"}]}]}], ",", 
        RowBox[{"rest", " ", 
         RowBox[{"WWedge", "[", 
          RowBox[{
           RowBox[{"CM", "[", 
            RowBox[{"met", " ", 
             RowBox[{"der", "[", "expr1", "]"}]}], "]"}], ",", "expr2"}], 
          "]"}]}]}], "\[IndentingNewLine]", "\t", "]"}]}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"FindFreeIndices", "[", "expr1", "]"}], ",", 
        RowBox[{
         RowBox[{"ChangeIndex", "[", "c", "]"}], "|", 
         RowBox[{"ChangeIndex", "[", "b", "]"}]}]}], "]"}], "&&", 
      RowBox[{
       RowBox[{"Head", "[", "expr1", "]"}], "=!=", "metric"}]}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"CM", ":", 
     RowBox[{"xAct`xTensor`Private`ContractMetric1", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"od_", ",", "aud_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"metric_", ",", "nv_"}], "}"}]}], "]"}]}], ")"}], "[", 
   RowBox[{"rest_.", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"WWedge", "[", 
      RowBox[{"expr2__", ",", 
       RowBox[{
        RowBox[{"der_", "?", "FirstDerQ"}], "[", "expr1_", "]"}]}], "]"}], 
     "]"}], 
    RowBox[{"met", ":", 
     RowBox[{"metric_", "[", 
      RowBox[{"b_", ",", "c_"}], "]"}]}]}], "]"}], ":=", 
  "\[IndentingNewLine]", "\t", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dm", "=", 
        RowBox[{"der", "[", "met", "]"}]}], ",", "result"}], "}"}], ",", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"od", "||", 
          RowBox[{"dm", "===", "0"}]}], ")"}], "&&", 
        RowBox[{"xAct`xTensor`Private`differentexpressionsQ", "[", 
         RowBox[{
          RowBox[{"result", "=", 
           RowBox[{"CM", "[", 
            RowBox[{"expr1", " ", "met"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"expr1", ",", "met"}], "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{"rest", " ", 
         RowBox[{"WWedge", "[", 
          RowBox[{"expr2", ",", 
           RowBox[{"CM", "[", 
            RowBox[{"der", "[", "result", "]"}], "]"}]}], "]"}]}], "-", 
        RowBox[{"rest", " ", 
         RowBox[{"WWedge", "[", 
          RowBox[{"expr2", ",", 
           RowBox[{"CM", "[", 
            RowBox[{"dm", " ", "expr1"}], "]"}]}], "]"}]}]}], ",", 
       RowBox[{"rest", " ", 
        RowBox[{"WWedge", "[", 
         RowBox[{"CM", "[", 
          RowBox[{"expr2", ",", 
           RowBox[{"met", " ", 
            RowBox[{"der", "[", "expr1", "]"}]}]}], "]"}], "]"}]}]}], 
      "\[IndentingNewLine]", "\t", "]"}]}], "]"}], "/;", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"FindFreeIndices", "[", "expr1", "]"}], ",", 
       RowBox[{
        RowBox[{"ChangeIndex", "[", "c", "]"}], "|", 
        RowBox[{"ChangeIndex", "[", "b", "]"}]}]}], "]"}], "&&", 
     RowBox[{
      RowBox[{"Head", "[", "expr1", "]"}], "=!=", "metric"}]}], 
    ")"}]}]}]}], "Code",
 CellChangeTimes->{{3.9330639780990515`*^9, 3.93306397917618*^9}, {
  3.933404081604292*^9, 3.9334040830190125`*^9}, {3.9497666729608345`*^9, 
  3.949766676261528*^9}, {3.950282620533287*^9, 3.950282637182405*^9}, {
  3.9513194362821903`*^9, 3.9513194463222485`*^9}, {3.9538198514471416`*^9, 
  3.953819858843645*^9}},
 CellLabel->
  "In[259]:=",ExpressionUUID->"226e9070-bf6d-4249-bc27-144a43116f7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification to ContractDir"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, {
   3.953820789431364*^9, 3.9538207896689415`*^9}, 
   3.9548531248284836`*^9},ExpressionUUID->"68f43ebe-90d9-5d46-818b-\
def67d24dbc2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"CM", ":", 
     RowBox[{"xAct`xTensor`Private`ContractDir1", "[", 
      RowBox[{"vector_", ",", "od_"}], "]"}]}], ")"}], "[", 
   RowBox[{"rest1_.", " ", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"WWedge", "[", 
      RowBox[{"rest2___", ",", 
       RowBox[{"vector_", "[", "a_", "]"}], ",", "rest3___", ",", 
       RowBox[{
        RowBox[{"tensor_", "?", "xTensorQ"}], "[", 
        RowBox[{"indsL___", ",", "b_", ",", "indsR___"}], "]"}], ",", 
       "rest4___"}], "]"}], "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"VertDeg", "[", 
       RowBox[{"vector", "[", "a", "]"}], "]"}], 
      RowBox[{"VertDeg", "[", "rest3", "]"}]}]], 
    RowBox[{"CM", "[", 
     RowBox[{"rest1", " ", 
      RowBox[{"WWedge", "[", 
       RowBox[{"rest2", ",", "rest3", ",", 
        RowBox[{"tensor", "[", 
         RowBox[{"indsL", ",", 
          RowBox[{"Dir", "[", 
           RowBox[{"vector", "[", "a", "]"}], "]"}], ",", "indsR"}], "]"}], ",",
         "rest4"}], "]"}]}], "]"}]}], "/;", 
   RowBox[{"PairQ", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"CM", ":", 
     RowBox[{"xAct`xTensor`Private`ContractDir1", "[", 
      RowBox[{"vector_", ",", "od_"}], "]"}]}], ")"}], "[", 
   RowBox[{"rest1_.", " ", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"WWedge", "[", 
      RowBox[{"rest2___", ",", 
       RowBox[{
        RowBox[{"tensor_", "?", "xTensorQ"}], "[", 
        RowBox[{"indsL___", ",", "b_", ",", "indsR___"}], "]"}], ",", 
       "rest3___", ",", 
       RowBox[{"vector_", "[", "a_", "]"}], ",", "rest4___"}], "]"}], "]"}]}],
    "]"}], ":=", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"VertDeg", "[", 
       RowBox[{"vector", "[", "a", "]"}], "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"VertDeg", "[", "rest3", "]"}], "+", 
        RowBox[{"VertDeg", "[", "tensor", "]"}]}], ")"}]}]], 
    RowBox[{"CM", "[", 
     RowBox[{"rest1", " ", 
      RowBox[{"WWedge", "[", 
       RowBox[{"rest2", ",", 
        RowBox[{"tensor", "[", 
         RowBox[{"indsL", ",", 
          RowBox[{"Dir", "[", 
           RowBox[{"vector", "[", "a", "]"}], "]"}], ",", "indsR"}], "]"}], ",",
         "rest3", ",", "rest4"}], "]"}]}], "]"}]}], "/;", 
   RowBox[{"PairQ", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"CM", ":", 
      RowBox[{"xAct`xTensor`Private`ContractDir1", "[", 
       RowBox[{"vector_", ",", "od_"}], "]"}]}], ")"}], "[", 
    RowBox[{"rest1_.", " ", 
     RowBox[{"vector_", "[", "a_", "]"}], 
     RowBox[{"HoldPattern", "[", 
      RowBox[{"WWedge", "[", 
       RowBox[{"rest2___", ",", 
        RowBox[{
         RowBox[{"tensor_", "?", "xTensorQ"}], "[", 
         RowBox[{"indsL___", ",", "b_", ",", "indsR___"}], "]"}], ",", 
        "rest3___"}], "]"}], "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CM", "[", 
     RowBox[{"rest1", " ", 
      RowBox[{"WWedge", "[", 
       RowBox[{"rest2", ",", 
        RowBox[{"tensor", "[", 
         RowBox[{"indsL", ",", 
          RowBox[{"Dir", "[", 
           RowBox[{"vector", "[", "a", "]"}], "]"}], ",", "indsR"}], "]"}], ",",
         "rest3"}], "]"}]}], "]"}], "/;", 
    RowBox[{"PairQ", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"CM", ":", 
     RowBox[{"xAct`xTensor`Private`ContractDir1", "[", 
      RowBox[{"vector_", ",", "od_"}], "]"}]}], ")"}], "[", 
   RowBox[{"rest1_.", " ", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"WWedge", "[", 
      RowBox[{"rest2___", ",", 
       RowBox[{"vector_", "[", "a_", "]"}], ",", "rest3___", ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"covd_", "?", "CovDQ"}], "[", 
         RowBox[{"indsL___", ",", "b_", ",", "indsR___"}], "]"}], "[", 
        "expr1_", "]"}], ",", "rest4___"}], "]"}], "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"VertDeg", "[", 
       RowBox[{"vector", "[", "a", "]"}], "]"}], 
      RowBox[{"VertDeg", "[", "rest3", "]"}]}]], 
    RowBox[{"CM", "[", 
     RowBox[{"rest1", " ", 
      RowBox[{"WWedge", "[", 
       RowBox[{"rest2", ",", "rest3", ",", 
        RowBox[{
         RowBox[{"covd", "[", 
          RowBox[{"indsL", ",", 
           RowBox[{"Dir", "[", 
            RowBox[{"vector", "[", "a", "]"}], "]"}], ",", "indsR"}], "]"}], "[",
          "expr1", "]"}], ",", "rest4"}], "]"}]}], "]"}]}], "/;", 
   RowBox[{"PairQ", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"CM", ":", 
     RowBox[{"xAct`xTensor`Private`ContractDir1", "[", 
      RowBox[{"vector_", ",", "od_"}], "]"}]}], ")"}], "[", 
   RowBox[{"rest1_.", " ", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"WWedge", "[", 
      RowBox[{"rest2___", ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"covd_", "?", "CovDQ"}], "[", 
         RowBox[{"indsL___", ",", "b_", ",", "indsR___"}], "]"}], "[", 
        "expr1_", "]"}], ",", "rest3___", ",", 
       RowBox[{"vector_", "[", "a_", "]"}], ",", "rest4___"}], "]"}], "]"}]}],
    "]"}], ":=", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"VertDeg", "[", 
       RowBox[{"vector", "[", "a", "]"}], "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"VertDeg", "[", "rest3", "]"}], "+", 
        RowBox[{"VertDeg", "[", 
         RowBox[{
          RowBox[{"covd", "[", 
           RowBox[{"indsL", ",", "b", ",", "indsR"}], "]"}], "[", "expr1", 
          "]"}], "]"}]}], ")"}]}]], 
    RowBox[{"CM", "[", 
     RowBox[{"rest1", " ", 
      RowBox[{"WWedge", "[", 
       RowBox[{"rest2", ",", 
        RowBox[{
         RowBox[{"covd", "[", 
          RowBox[{"indsL", ",", 
           RowBox[{"Dir", "[", 
            RowBox[{"vector", "[", "a", "]"}], "]"}], ",", "indsR"}], "]"}], "[",
          "expr1", "]"}], ",", "rest3", ",", "rest4"}], "]"}]}], "]"}]}], "/;", 
   RowBox[{"PairQ", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"CM", ":", 
      RowBox[{"xAct`xTensor`Private`ContractDir1", "[", 
       RowBox[{"vector_", ",", "od_"}], "]"}]}], ")"}], "[", 
    RowBox[{"rest1_.", " ", 
     RowBox[{"vector_", "[", "a_", "]"}], 
     RowBox[{"HoldPattern", "[", 
      RowBox[{"WWedge", "[", 
       RowBox[{"rest2___", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"covd_", "?", "CovDQ"}], "[", 
          RowBox[{"indsL___", ",", "b_", ",", "indsR___"}], "]"}], "[", 
         "expr1_", "]"}], ",", "rest3___"}], "]"}], "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CM", "[", 
     RowBox[{"rest1", " ", 
      RowBox[{"WWedge", "[", 
       RowBox[{"rest2", ",", 
        RowBox[{
         RowBox[{"covd", "[", 
          RowBox[{"indsL", ",", 
           RowBox[{"Dir", "[", 
            RowBox[{"vector", "[", "a", "]"}], "]"}], ",", "indsR"}], "]"}], "[",
          "expr1", "]"}], ",", "rest3"}], "]"}]}], "]"}], "/;", 
    RowBox[{"PairQ", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"CM", ":", 
     RowBox[{"xAct`xTensor`Private`ContractDir1", "[", 
      RowBox[{"vector_", ",", "od_"}], "]"}]}], ")"}], "[", 
   RowBox[{"rest1_.", " ", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"WWedge", "[", 
      RowBox[{"rest2___", ",", 
       RowBox[{"vector_", "[", "a_", "]"}], ",", "rest3___", ",", " ", 
       RowBox[{
        RowBox[{"der_", "?", "FirstDerQ"}], "[", "expr_", "]"}], ",", 
       "rest4___"}], "]"}], "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dv", "=", 
        RowBox[{"der", "[", 
         RowBox[{"vector", "[", "a", "]"}], "]"}]}], ",", "result"}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"dv", "===", "0"}], "||", "od"}], ")"}], "&&", 
        RowBox[{"xAct`xTensor`Private`differentexpressionsQ", "[", 
         RowBox[{
          RowBox[{"result", "=", 
           RowBox[{"CM", "[", 
            RowBox[{
             RowBox[{"vector", "[", "a", "]"}], "~", "WWedge", "~", "expr"}], 
            " ", "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"expr", ",", 
            RowBox[{"vector", "[", "a", "]"}]}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"VertDeg", "[", 
           RowBox[{"vector", "[", "a", "]"}], "]"}], 
          RowBox[{"VertDeg", "[", "rest3", "]"}]}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"CM", "[", 
           RowBox[{"rest1", " ", 
            RowBox[{"WWedge", "[", 
             RowBox[{"rest2", ",", "rest3", ",", 
              RowBox[{"der", "[", "result", "]"}], ",", "rest4"}], "]"}]}], 
           "]"}], "-", 
          RowBox[{"CM", "[", 
           RowBox[{"rest1", " ", 
            RowBox[{"WWedge", "[", 
             RowBox[{
             "rest2", ",", "rest3", ",", "dv", ",", "expr", ",", "rest4"}], 
             "]"}]}], "]"}]}], ")"}]}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"VertDeg", "[", 
           RowBox[{"der", "[", "expr", "]"}], "]"}], 
          RowBox[{"VertDeg", "[", "rest4", "]"}]}]], 
        RowBox[{
         RowBox[{"CM", "[", 
          RowBox[{"rest1", " ", 
           RowBox[{"WWedge", "[", 
            RowBox[{"rest2", ",", 
             RowBox[{"vector", "[", "a", "]"}], ",", "rest3", ",", "rest4"}], 
            "]"}]}], "]"}], "~", "WWedge", "~", " ", 
         RowBox[{"der", "[", "expr", "]"}]}]}]}], "]"}]}], "]"}], "/;", 
   RowBox[{
    RowBox[{"IsIndexOf", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"-", "a"}]}], "]"}], "&&", 
    RowBox[{
     RowBox[{"Head", "[", "expr", "]"}], "=!=", "vector"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"CM", ":", 
     RowBox[{"xAct`xTensor`Private`ContractDir1", "[", 
      RowBox[{"vector_", ",", "od_"}], "]"}]}], ")"}], "[", 
   RowBox[{"rest1_.", " ", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"WWedge", "[", 
      RowBox[{"rest2___", ",", 
       RowBox[{
        RowBox[{"der_", "?", "FirstDerQ"}], "[", "expr_", "]"}], ",", 
       "rest3___", ",", 
       RowBox[{"vector_", "[", "a_", "]"}], ",", "rest4___"}], "]"}], "]"}]}],
    "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dv", "=", 
        RowBox[{"der", "[", 
         RowBox[{"vector", "[", "a", "]"}], "]"}]}], ",", "result"}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"dv", "===", "0"}], "||", "od"}], ")"}], "&&", 
        RowBox[{"xAct`xTensor`Private`differentexpressionsQ", "[", 
         RowBox[{
          RowBox[{"result", "=", 
           RowBox[{"CM", "[", 
            RowBox[{
             RowBox[{"vector", "[", "a", "]"}], "~", "WWedge", "~", "expr"}], 
            " ", "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"expr", ",", 
            RowBox[{"vector", "[", "a", "]"}]}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"VertDeg", "[", 
           RowBox[{"vector", "[", "a", "]"}], "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"VertDeg", "[", "rest3", "]"}], "+", 
            RowBox[{"VertDeg", "[", 
             RowBox[{"der", "[", "expr", "]"}], "]"}]}], ")"}]}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"CM", "[", 
           RowBox[{"rest1", " ", 
            RowBox[{"WWedge", "[", 
             RowBox[{"rest2", ",", 
              RowBox[{"der", "[", "result", "]"}], ",", "rest3", ",", 
              "rest4"}], "]"}]}], "]"}], "-", 
          RowBox[{"CM", "[", 
           RowBox[{"rest1", " ", 
            RowBox[{"WWedge", "[", 
             RowBox[{
             "rest2", ",", "dv", ",", "expr", ",", "rest3", ",", "rest4"}], 
             "]"}]}], "]"}]}], ")"}]}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"VertDeg", "[", 
           RowBox[{"der", "[", "expr", "]"}], "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"VertDeg", "[", "rest3", "]"}], "+", 
            RowBox[{"VertDeg", "[", 
             RowBox[{"vector", "[", "a", "]"}], "]"}], "+", 
            RowBox[{"VertDeg", "[", "rest4", "]"}]}], ")"}]}]], 
        RowBox[{
         RowBox[{"CM", "[", 
          RowBox[{"rest1", " ", 
           RowBox[{"WWedge", "[", 
            RowBox[{"rest2", ",", 
             RowBox[{"vector", "[", "a", "]"}], ",", "rest3", ",", "rest4"}], 
            "]"}]}], "]"}], "~", "WWedge", "~", " ", 
         RowBox[{"der", "[", "expr", "]"}]}]}]}], "]"}]}], "]"}], "/;", 
   RowBox[{
    RowBox[{"IsIndexOf", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"-", "a"}]}], "]"}], "&&", 
    RowBox[{
     RowBox[{"Head", "[", "expr", "]"}], "=!=", "vector"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.9538175793270016`*^9, 3.9538176106571712`*^9}, {
  3.953819752159664*^9, 3.953819811431555*^9}, {3.9538208374229603`*^9, 
  3.9538208767818947`*^9}, {3.9538210323799114`*^9, 3.953821039518648*^9}},
 CellLabel->
  "In[262]:=",ExpressionUUID->"9f393a0d-6436-f248-9f3a-9be8b9ab1714"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification to SeparateMetric"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.951319326679081*^9, {3.9548531593889103`*^9, 
   3.9548531596074905`*^9}},ExpressionUUID->"f5e81531-1094-f549-84f1-\
fec3d30ec7ea"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SubValues", "[", "SeparateMetric", "]"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"SeparateMetric", "[", "args___", "]"}], "[", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{
          RowBox[{"VertInt", "[", "arg1_", "]"}], "[", "arg2_", "]"}], "]"}], 
        "]"}], "]"}], ":>", 
      RowBox[{
       RowBox[{"VertInt", "[", "arg1", "]"}], "[", 
       RowBox[{
        RowBox[{"SeparateMetric", "[", "args", "]"}], "[", "arg2", "]"}], 
       "]"}]}], "}"}], "~", "Join", "~", 
    RowBox[{"(", 
     RowBox[{"SubValues", "@", "SeparateMetric"}], ")"}]}]}], ";"}]], "Code",
 CellChangeTimes->{{3.951318701328945*^9, 3.951318829741949*^9}, {
   3.951319164559057*^9, 3.9513192043286953`*^9}, {3.951319472136957*^9, 
   3.951319683936765*^9}, {3.951319747316798*^9, 3.9513197739557705`*^9}, 
   3.951320239278822*^9, {3.951338786730557*^9, 3.95133880149609*^9}, 
   3.951474591366438*^9, {3.9521859441555977`*^9, 3.952186055516176*^9}, {
   3.9521861853278217`*^9, 3.952186195389929*^9}, {3.9521885438625736`*^9, 
   3.952188587817539*^9}},
 CellLabel->
  "In[270]:=",ExpressionUUID->"e597e02f-f368-2940-af14-185c7387bec9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification to WeightOf"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, 
   3.954853174772009*^9},ExpressionUUID->"d0f17f67-061c-8f43-a9d6-\
2eb0863a1030"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "[", "WeightOf", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"WeightOf", "[", 
   RowBox[{
    RowBox[{"ih_", "?", "InertHeadQ"}], "[", "__", "]"}], "]"}], "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WeightOf", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"VertInt", "[", "v_", "]"}], "[", "expr_", "]"}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"WeightOf", "[", "v", "]"}], "+", 
   RowBox[{"WeightOf", "[", "expr", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WeightOf", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"VertLie", "[", "v_", "]"}], "[", "expr_", "]"}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"WeightOf", "[", "v", "]"}], "+", 
   RowBox[{"WeightOf", "[", "expr", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WeightOf", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"VertDiff", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
  RowBox[{"WeightOf", "[", "expr", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WeightOf", "[", 
    RowBox[{
     RowBox[{"ih_", "?", "InertHeadQ"}], "[", "__", "]"}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      StyleBox[
       RowBox[{"WeightOf", "::", "error"}], "MessageName"], 
      ",", "\"\<WeightOf is generically undefined on inert heads.\>\""}], 
     "]"}], "]"}]}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "WeightOf", "]"}], ";"}]}], "Code",
 CellChangeTimes->{
  3.949058393141022*^9, {3.951319522332463*^9, 3.9513195258533554`*^9}, {
   3.9513196027036057`*^9, 3.951319619324568*^9}, {3.95530793160116*^9, 
   3.955308008532587*^9}, {3.955359304949005*^9, 3.9553593737480717`*^9}, {
   3.9553596896579*^9, 3.955359733119829*^9}, {3.955360216384617*^9, 
   3.9553602604137897`*^9}, {3.955361052592903*^9, 3.955361053048254*^9}, {
   3.9572755091024265`*^9, 3.9572755099411182`*^9}, {3.9606312564202557`*^9, 
   3.960631258617941*^9}},
 CellLabel->
  "In[271]:=",ExpressionUUID->"01295426-30db-5c42-a20c-3a07ee88b453"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification to MakeDaggerSymbol"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, 3.954853174772009*^9, 
   3.958419569885479*^9},ExpressionUUID->"d1e1fa5d-ca64-8d4a-9ded-\
0e7af9a6ff60"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "MakeDaggerSymbol", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeDaggerSymbol", "[", "symbol_Symbol", "]"}], "/;", 
   RowBox[{"PartialPartialQ", "[", "symbol", "]"}]}], ":=", 
  RowBox[{"NameOfDaggerPartialPartial", "[", "symbol", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "MakeDaggerSymbol", "]"}], ";"}]}], "Code",
 CellChangeTimes->{
  3.949058393141022*^9, {3.951319522332463*^9, 3.9513195258533554`*^9}, {
   3.9513196027036057`*^9, 3.951319619324568*^9}, {3.95530793160116*^9, 
   3.955308008532587*^9}, {3.955359304949005*^9, 3.9553593737480717`*^9}, {
   3.9553596896579*^9, 3.955359733119829*^9}, {3.955360216384617*^9, 
   3.9553602604137897`*^9}, {3.955361052592903*^9, 3.955361053048254*^9}, {
   3.9572755091024265`*^9, 3.9572755099411182`*^9}, {3.958419581301409*^9, 
   3.9584195858410263`*^9}, {3.9584274511628284`*^9, 3.958427482518036*^9}, {
   3.958433327039446*^9, 3.958433327704443*^9}, {3.9584361341907997`*^9, 
   3.9584361410026703`*^9}},
 CellLabel->
  "In[278]:=",ExpressionUUID->"55239ae2-53c3-3c45-96c9-e1e3902cb967"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modifications to IndexCoefficient"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, {3.9548532814390984`*^9, 
   3.954853282270151*^9}},ExpressionUUID->"61f4f68f-9910-1847-a250-\
4e99828c4e02"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "[", "IndexCoefficient", "]"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{
    "IndexCoefficient", ",", "xAct`xTensor`Private`IndexCoefficient1", ",", 
     "xAct`xTensor`Private`IndexCoefficient2"}], "]"}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"New", " ", "ones", " ", "to", " ", "handle", " ", "constants"}], 
   " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"IndexCoefficient", "[", 
   RowBox[{"0", ",", "form_"}], "]"}], ":=", "0"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IndexCoefficient", "[", 
     RowBox[{"expr_", ",", 
      RowBox[{
       RowBox[{"number_", "?", "RealValuedNumericQ"}], " ", "form_"}]}], 
     "]"}], "/;", 
    RowBox[{"number", "!=", "0"}]}], " ", ":=", 
   RowBox[{
    FractionBox["1", "number"], 
    RowBox[{"IndexCoefficient", "[", 
     RowBox[{"expr", ",", "form"}], "]"}]}]}], "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "New", " ", "one", " ", "to", " ", "expand", " ", "the", " ", 
    "expresion"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IndexCoefficient", "[", 
     RowBox[{"expr_", ",", "coeff_"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"Expand", "[", "expr", "]"}], "=!=", "expr"}]}], ":=", 
   RowBox[{"IndexCoefficient", "[", 
    RowBox[{
     RowBox[{"Expand", "[", "expr", "]"}], ",", "coeff"}], "]"}]}], "\n", 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "New", " ", "one", " ", "to", " ", "handle", " ", "WWedge", " ", "in", " ",
     "the", " ", "coefficient"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IndexCoefficient", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{"WWedge", "[", 
       RowBox[{"form1_", ",", "form2_"}], "]"}], "]"}]}], "]"}], ":=", 
   RowBox[{"IndexCoefficient", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{"IndexCoefficient", "[", 
       RowBox[{"expr", ",", "form1"}], "]"}], "]"}], ",", "form2"}], "]"}]}], 
  "\n", "\n", 
  RowBox[{"(*", " ", "Unchanged", " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"IndexCoefficient", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"form1_", " ", "form2_"}]}], "]"}], ":=", 
  RowBox[{"IndexCoefficient", "[", 
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"IndexCoefficient", "[", 
      RowBox[{"expr", ",", "form1"}], "]"}], "]"}], ",", "form2"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"IndexCoefficient", "[", 
   RowBox[{"expr_", ",", "form_"}], "]"}], ":=", 
  RowBox[{"xAct`xTensor`Private`average", "[", 
   RowBox[{"xAct`xTensor`Private`SymmetryIndexCoefficient", "[", 
    RowBox[{
     RowBox[{"ReplaceDummies", "[", "expr", "]"}], ",", 
     RowBox[{
     "xAct`xTensor`Private`SymmetryEquivalentsOf", "[", "form", "]"}]}], 
    "]"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"IndexCoefficient", "[", "_", "]"}], ":=", 
  RowBox[{"Message", "[", 
   RowBox[{
    StyleBox[
     RowBox[{"IndexCoefficient", "::", "argr"}], "MessageName"], ",", 
    "IndexCoefficient", ",", "2"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"IndexCoefficient", "[", 
   RowBox[{"_", ",", "_", ",", "xAct`xCore`Private`x__"}], "]"}], ":=", 
  RowBox[{"Message", "[", 
   RowBox[{
    StyleBox[
     RowBox[{"IndexCoefficient", "::", "argrx"}], "MessageName"], ",", 
    "IndexCoefficient", ",", 
    RowBox[{"2", "+", 
     RowBox[{"Length", "[", 
      RowBox[{"{", "xAct`xCore`Private`x", "}"}], "]"}]}], ",", "2"}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IndexCoefficient", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"form_", "?", "xAct`xTensor`Private`NonIndexedScalarQ"}]}], 
    "]"}], ":=", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"expr", ",", "form"}], "]"}]}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Changed", " ", "division", " ", "by", " ", "DivisionWWedge", " ", "and", " ",
     "List", " ", "by", " ", "splitFactors"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"xAct`xTensor`Private`IndexCoefficient1", "[", 
   RowBox[{"expr_Plus", ",", "form_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"xAct`xTensor`Private`IndexCoefficient1", "[", 
      RowBox[{"#1", ",", "form"}], "]"}], "&"}], ")"}], "/@", "expr"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Private`IndexCoefficient1", "[", 
    RowBox[{"expr_", ",", "form_"}], "]"}], ":=", "\n", 
   RowBox[{"xAct`xTensor`Private`average", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"xAct`xTensor`Private`IndexCoefficient2", "[", 
        RowBox[{
         RowBox[{"DivisionWWedge", "[", 
          RowBox[{"expr", ",", "#1", ",", 
           RowBox[{"ReturnZeroOrError", "->", "Zero"}]}], "]"}], ",", "#1", ",",
          "form"}], "]"}], "&"}], ")"}], "/@", 
     RowBox[{"splitFactors", "@", "expr"}]}], "]"}]}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Changed", " ", "Times", " ", "by", " ", "WWedge"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xTensor`Private`IndexCoefficient2", "[", 
   RowBox[{"rest_", ",", "expr_", ",", 
    RowBox[{"-", "form_"}]}], "]"}], ":=", 
  RowBox[{"-", 
   RowBox[{"xAct`xTensor`Private`IndexCoefficient2", "[", 
    RowBox[{"rest", ",", "expr", ",", "form"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xTensor`Private`IndexCoefficient2", "[", 
   RowBox[{"rest_", ",", "expr_", ",", "form_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"WWedge", "[", 
    RowBox[{"rest", " ", ",", 
     RowBox[{"xAct`xTensor`Private`IndexCoefficient3", "[", 
      RowBox[{
       RowBox[{"FindIndices", "[", "expr", "]"}], ",", 
       RowBox[{"FindIndices", "[", "form", "]"}]}], "]"}]}], "]"}], "/;", 
   RowBox[{"xAct`xTensor`Private`SameExpressionsQ", "[", 
    RowBox[{"expr", ",", "form"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Private`IndexCoefficient2", "[", 
    RowBox[{"rest_", ",", "expr_", ",", "form_"}], "]"}], ":=", "0"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "IndexCoefficient", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.950302335742937*^9, 3.95030233603438*^9}, {
   3.950302372650324*^9, 3.9503024401786823`*^9}, {3.950302482742836*^9, 
   3.95030248306983*^9}, {3.9503025900763607`*^9, 3.950302594764118*^9}, {
   3.9503081589012585`*^9, 3.9503081616960793`*^9}, {3.950308295590824*^9, 
   3.9503083050287724`*^9}, {3.950308355646269*^9, 3.950308386049633*^9}, 
   3.950308498366621*^9, {3.9503085560139294`*^9, 3.950308574673242*^9}, {
   3.9503086775809975`*^9, 3.950308681200848*^9}, {3.950375404930263*^9, 
   3.950375410246723*^9}, {3.9503754481400776`*^9, 3.950375474856464*^9}, {
   3.950376917889019*^9, 3.9503769189801884`*^9}, {3.9503769695360203`*^9, 
   3.950377012947209*^9}, {3.950377078829592*^9, 3.950377124367031*^9}, {
   3.950377273440506*^9, 3.950377321911066*^9}, 3.950377381884695*^9, {
   3.950377557164952*^9, 3.950377635651785*^9}, {3.950452220067316*^9, 
   3.950452229653296*^9}, {3.95053428341465*^9, 3.950534316836193*^9}, {
   3.950539783631054*^9, 3.950539798833334*^9}, 3.950611580120949*^9, {
   3.951050043107218*^9, 3.951050083224623*^9}, 3.9510503394478836`*^9, {
   3.951050622687996*^9, 3.95105062395822*^9}, {3.9510508563317566`*^9, 
   3.9510508726035366`*^9}, 3.9510569512363987`*^9, {3.95105706423801*^9, 
   3.951057113265764*^9}, 3.9510571497339973`*^9, {3.951218553127498*^9, 
   3.951218566456753*^9}, {3.9512486365877056`*^9, 3.95124863771085*^9}, 
   3.9572760782376423`*^9},
 CellLabel->
  "In[281]:=",ExpressionUUID->"4ab1fac3-1166-f243-9c24-9d3356703cad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modifications to Explode"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, 3.9513399965763073`*^9, {
   3.954853260008972*^9, 3.954853261047636*^9}, {3.9578148760932865`*^9, 
   3.9578148767612953`*^9}},ExpressionUUID->"982a8959-278a-1047-b2a3-\
fab3f8454af2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Explode", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Explode", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"tensor_", "?", "xTensorQ"}]}], "]"}], "=."}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Explode", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"tensor_", "?", "xTensorQ"}]}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"tensor", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], ":>", 
       RowBox[{"VertDiff", "[", 
        RowBox[{"xAct`xTensor`Private`ExplodeTensor", "[", 
         RowBox[{
          RowBox[{"MasterOfCPSTensor", "[", "tensor", "]"}], "[", "inds", 
          "]"}], "]"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"tensor", "?", "VariationalVectorQ"}], "[", "inds___", "]"}], 
       ":>", 
       RowBox[{"tensor", "[", "inds", "]"}]}], ",", 
      RowBox[{
       RowBox[{"tensor", "[", "inds___", "]"}], "\[RuleDelayed]", 
       RowBox[{"xAct`xTensor`Private`ExplodeTensor", "[", 
        RowBox[{"tensor", "[", "inds", "]"}], "]"}]}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "Explode", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.951339998310353*^9, 3.9513400026183796`*^9}, {
   3.9549529871728134`*^9, 3.954953025867182*^9}, 3.9549532960047607`*^9, 
   3.9549536926380024`*^9, 3.954953780821192*^9, {3.956408309120949*^9, 
   3.956408309869894*^9}, {3.9578148808068314`*^9, 3.957814883851959*^9}, 
   3.9578150301074085`*^9, {3.9578152220459557`*^9, 3.957815309576906*^9}, {
   3.9578153968179474`*^9, 3.9578154152775784`*^9}, {3.957815450919449*^9, 
   3.9578154605368843`*^9}, {3.957815671511629*^9, 3.9578156801963825`*^9}},
 CellLabel->
  "In[298]:=",ExpressionUUID->"18ccd491-d8af-1a4f-bc53-a430a4c8b8d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modifications to Implode"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, 3.9513399965763073`*^9, {
   3.954853260008972*^9, 3.954853261047636*^9}, {3.9578148760932865`*^9, 
   3.9578148767612953`*^9}, {3.9583106623357353`*^9, 
   3.958310663416765*^9}},ExpressionUUID->"2805c135-9774-6940-b737-\
25246afd2070"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Implode", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Implode", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"OverDot", "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], 
     "]"}], "]"}], "]"}], ":=", 
  RowBox[{"VertDiff", "[", 
   RowBox[{"Implode", "[", 
    RowBox[{"OverDot", "[", 
     RowBox[{
      RowBox[{"MasterOfCPSTensor", "[", "tensor", "]"}], "[", "inds", "]"}], 
     "]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Implode", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"ParamD", "[", "param__", "]"}], "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], 
     "]"}], "]"}], "]"}], ":=", 
  RowBox[{"VertDiff", "[", 
   RowBox[{"Implode", "[", 
    RowBox[{
     RowBox[{"ParamD", "[", "param", "]"}], "[", 
     RowBox[{
      RowBox[{"MasterOfCPSTensor", "[", "tensor", "]"}], "[", "inds", "]"}], 
     "]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Implode", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.9583106594409904`*^9, 3.958310681327572*^9}},
 CellLabel->
  "In[302]:=",ExpressionUUID->"624f9410-ecc9-1a4b-8bb7-c31dcbcdb3cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modifications to BreakChristoffel (makeChristoffelRule)"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, 3.9513399965763073`*^9, {
   3.954853260008972*^9, 3.954853261047636*^9}, {3.9578148760932865`*^9, 
   3.9578148767612953`*^9}, {3.9583106623357353`*^9, 3.958310663416765*^9}, {
   3.958572964293707*^9, 
   3.958572978603342*^9}},ExpressionUUID->"89dd55c7-02ce-d247-9116-\
fab80e2590db"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ChristoffelAUX", "[", "PD", "]"}], ":=", "Zero"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AChristoffelAUX", "[", "PD", "]"}], ":=", "Zero"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"ChristoffelAUX", "[", 
   RowBox[{"PD", ",", "PD"}], "]"}], ":=", "Zero"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AChristoffelAUX", "[", 
    RowBox[{"PD", ",", "PD"}], "]"}], ":=", "Zero"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"ChristoffelAUX", "[", 
   RowBox[{
    RowBox[{"covd_", "?", "CovDQ"}], ",", 
    RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], ":=", "Zero"}], "\n", 
 RowBox[{
  RowBox[{"AChristoffelAUX", "[", 
   RowBox[{
    RowBox[{"covd_", "?", "CovDQ"}], ",", 
    RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], ":=", "Zero"}]}], "Code",
 CellChangeTimes->{
  3.9588683713322887`*^9, {3.958868881720375*^9, 3.958868910242426*^9}, {
   3.958877549886183*^9, 3.9588775648511524`*^9}},
 CellLabel->
  "In[306]:=",ExpressionUUID->"9d37b62f-7468-7f41-8eaf-c39e88c0ac9c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "@", "xAct`xTensor`Private`makeChristoffelRule"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xAct`xTensor`Private`makeChristoffelRule", "[", "PD", "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"chrname_", ",", 
      RowBox[{"{", 
       RowBox[{"_", ",", "covd1_", ",", "covd2_"}], "}"}], ",", "_"}], "}"}], 
    "]"}], ":=", "\[IndentingNewLine]", "\t", 
   RowBox[{"Sequence", "[", "\[IndentingNewLine]", "\t\t", 
    RowBox[{
     RowBox[{
      RowBox[{"chrname", "[", "inds__", "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"xAct`xTensor`Private`breakChristoffel", "[", 
        RowBox[{"covd1", ",", "covd2", ",", "PD"}], "]"}], "[", "inds", 
       "]"}]}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"Same", " ", "definition"}], " ", "*)"}], "\[IndentingNewLine]",
      "\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"VertDiff", "[", "chrname", "]"}], "[", "inds__", "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"breakdlChristoffel", "[", 
        RowBox[{"covd1", ",", "covd2", ",", "PD"}], "]"}], "[", "inds", 
       "]"}]}]}], " ", 
    RowBox[{"(*", " ", 
     RowBox[{"New", " ", "definition"}], " ", "*)"}], "\[IndentingNewLine]", 
    "\t", "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Private`makeChristoffelRule", "[", "covd_", "]"}], "[", 
   RowBox[{"{", 
    RowBox[{"chrname_", ",", 
     RowBox[{"{", 
      RowBox[{"_", ",", "covd1_", ",", "covd2_"}], "}"}], ",", "_"}], "}"}], 
   "]"}], ":=", "\n", "\t", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"xAct`xTensor`Private`CompatibleCovDsQ", "[", 
      RowBox[{"covd", ",", "covd1"}], "]"}], "&&", 
     RowBox[{"xAct`xTensor`Private`CompatibleCovDsQ", "[", 
      RowBox[{"covd", ",", "covd2"}], "]"}]}], ",", "\[IndentingNewLine]", 
    "\t", 
    RowBox[{"Sequence", "@@", 
     RowBox[{"{", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{
        RowBox[{"chrname", "[", "inds__", "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"xAct`xTensor`Private`breakChristoffel", "[", 
          RowBox[{"covd1", ",", "covd2", ",", "covd"}], "]"}], "[", "inds", 
         "]"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{"Same", " ", "definition"}], " ", "*)"}], "\n", "\t", 
       RowBox[{
        RowBox[{
         RowBox[{"VertDiff", "[", "chrname", "]"}], "[", "inds__", "]"}], ":>", 
        RowBox[{
         RowBox[{"breakdlChristoffel", "[", 
          RowBox[{"covd1", ",", "covd2", ",", "covd"}], "]"}], "[", "inds", 
         "]"}]}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"New", " ", "definition"}], " ", "*)"}], "\[IndentingNewLine]",
       "\t", "}"}]}], ",", "\[IndentingNewLine]", "\t", 
    RowBox[{"{", "}"}]}], "]"}]}]}], "Code",
 CellChangeTimes->{{3.9585712675304737`*^9, 3.958571318168644*^9}, {
   3.9585714278374043`*^9, 3.958571445890335*^9}, {3.958571490966099*^9, 
   3.9585715251223354`*^9}, {3.9585716138875237`*^9, 
   3.9585716290489197`*^9}, {3.958571873832905*^9, 3.9585718865685368`*^9}, {
   3.9585719319494247`*^9, 3.958571946544489*^9}, {3.958572384162245*^9, 
   3.9585724071615276`*^9}, {3.9585727872724457`*^9, 
   3.9585727876129208`*^9}, {3.958572984118593*^9, 3.958573078811289*^9}, {
   3.95857469879146*^9, 3.9585747251140633`*^9}, {3.9585865827209873`*^9, 
   3.958586590043028*^9}, {3.9585868095973206`*^9, 3.9585868201677723`*^9}, {
   3.95858697879142*^9, 3.9585869884850006`*^9}, {3.95858707310474*^9, 
   3.9585870753837833`*^9}, {3.9585871662878723`*^9, 
   3.9585871684842567`*^9}, {3.9585885279799595`*^9, 3.958588528198038*^9}, 
   3.9585890712113266`*^9, {3.958589168575016*^9, 3.958589204335232*^9}, {
   3.9585892999476547`*^9, 3.958589320611946*^9}, {3.9585895333696823`*^9, 
   3.9585895441704903`*^9}, {3.9585896203821087`*^9, 
   3.9585896536444397`*^9}, {3.958589710407057*^9, 3.9585897166282787`*^9}, {
   3.9585898303245983`*^9, 3.9585898343977966`*^9}, {3.958589939711767*^9, 
   3.958589946137535*^9}, {3.9585899981721497`*^9, 3.958590005170719*^9}, {
   3.958600470575676*^9, 3.958600594285841*^9}, {3.958600743816286*^9, 
   3.9586007455872955`*^9}, {3.9586021350790424`*^9, 3.95860213600651*^9}, {
   3.958867864453539*^9, 3.9588678651748943`*^9}},
 CellLabel->
  "In[312]:=",ExpressionUUID->"35ce0391-bae6-fd4c-b5ef-8401626620fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"breakdlChristoffel", "[", 
    RowBox[{"covd1_", ",", "covd2_", ",", "covd_"}], "]"}], "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "@", 
      RowBox[{"DeleteDuplicates", "[", 
       RowBox[{"VBundleOfIndex", "/@", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], "===", "1"}], ",",
     "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"VertDiff", "[", 
       RowBox[{"ChristoffelAUX", "[", 
        RowBox[{"covd1", ",", "covd"}], "]"}], "]"}], "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], "-", 
     RowBox[{
      RowBox[{"VertDiff", "[", 
       RowBox[{"ChristoffelAUX", "[", 
        RowBox[{"covd2", ",", "covd"}], "]"}], "]"}], "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], ",", 
    RowBox[{"(*", " ", 
     RowBox[{"New", " ", "definition"}], " ", "*)"}], "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"VertDiff", "[", 
       RowBox[{"AChristoffelAUX", "[", 
        RowBox[{"covd1", ",", "covd"}], "]"}], "]"}], "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], "-", 
     RowBox[{
      RowBox[{"VertDiff", "[", 
       RowBox[{"AChristoffelAUX", "[", 
        RowBox[{"covd2", ",", "covd"}], "]"}], "]"}], "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]}], 
   RowBox[{"(*", " ", 
    RowBox[{"New", " ", "definition"}], " ", "*)"}], "\n", "\t", 
   "]"}]}]], "Code",
 CellChangeTimes->{{3.9585712675304737`*^9, 3.958571318168644*^9}, {
   3.9585714278374043`*^9, 3.958571445890335*^9}, {3.958571490966099*^9, 
   3.9585715251223354`*^9}, {3.9585716138875237`*^9, 
   3.9585716290489197`*^9}, {3.958571873832905*^9, 3.9585718865685368`*^9}, {
   3.9585719319494247`*^9, 3.958571946544489*^9}, {3.958572384162245*^9, 
   3.9585724071615276`*^9}, {3.9585727872724457`*^9, 
   3.9585727876129208`*^9}, {3.958572984118593*^9, 3.9585730769862595`*^9}, {
   3.9585731519065666`*^9, 3.9585731559631786`*^9}, 3.958574685669916*^9, {
   3.9585747392316303`*^9, 3.9585747432724285`*^9}, {3.9585865946262646`*^9, 
   3.958586600639124*^9}, {3.9585870844989414`*^9, 3.958587092961281*^9}, {
   3.958587172977165*^9, 3.958587193511442*^9}, {3.9585890738328953`*^9, 
   3.95858908434894*^9}, {3.958589200926466*^9, 3.9585892019253902`*^9}, {
   3.9585897456960697`*^9, 3.958589754004984*^9}, {3.9588773512030277`*^9, 
   3.9588774181815414`*^9}, {3.9588775942033005`*^9, 3.9588776027896786`*^9}},
 CellLabel->
  "In[315]:=",ExpressionUUID->"051370dc-180a-124a-96ef-bc13af04c164"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modifications to ChangeTorsion"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, 3.9513399965763073`*^9, {
   3.954853260008972*^9, 3.954853261047636*^9}, {3.9578148760932865`*^9, 
   3.9578148767612953`*^9}, {3.9583106623357353`*^9, 3.958310663416765*^9}, {
   3.958572964293707*^9, 3.958572978603342*^9}, 
   3.9585730969542465`*^9},ExpressionUUID->"fdf0227d-899d-ef44-a135-\
005ccfb0824f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Private`makeChangeTorsionRule", "[", "covd2_", "]"}],
    "[", "covd1_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"TorsionQ", "[", "covd1", "]"}], "&&", 
     RowBox[{"xAct`xTensor`Private`CompatibleCovDsQ", "[", 
      RowBox[{"covd1", ",", "covd2"}], "]"}]}], ",", "\[IndentingNewLine]", 
    "\t", 
    RowBox[{"{", "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Torsion", "[", "covd1", "]"}], "[", "inds__", "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"xAct`xTensor`Private`changeTorsion", "[", 
         RowBox[{"covd1", ",", "covd2"}], "]"}], "[", "inds", "]"}]}], ",", 
      " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Same", " ", "definition"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{
        RowBox[{"VertDiff", "[", 
         RowBox[{"Torsion", "[", "covd1", "]"}], "]"}], "[", "inds2__", "]"}],
        ":>", 
       RowBox[{
        RowBox[{"changedlTorsion", "[", 
         RowBox[{"covd1", ",", "covd2"}], "]"}], "[", "inds2", "]"}]}]}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"New", " ", "definition"}], " ", "*)"}], "\[IndentingNewLine]", 
     "\t", "}"}], ",", "\[IndentingNewLine]", "\t", 
    RowBox[{"{", "}"}]}], "\n", "\t", "]"}]}]], "Code",
 CellChangeTimes->{{3.958574614858528*^9, 3.9585746795140953`*^9}, {
  3.9585747833949833`*^9, 3.9585747839651985`*^9}, {3.9585748199811687`*^9, 
  3.958575074448263*^9}, {3.958575209990423*^9, 3.9585752160370655`*^9}, {
  3.9586014435065823`*^9, 3.9586015297987843`*^9}, {3.958602098073597*^9, 
  3.9586021098760757`*^9}},
 CellLabel->
  "In[316]:=",ExpressionUUID->"00f5386b-43b0-4445-82af-e327d252cc9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"changedlTorsion", "[", 
    RowBox[{"covd1_", ",", "covd2_"}], "]"}], "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"chr", "=", 
      RowBox[{"HeadOfTensor", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Christoffel", "[", 
          RowBox[{"covd1", ",", "covd2"}], "]"}], "[", 
         RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"VertDiff", "[", 
       RowBox[{"Torsion", "[", "covd2", "]"}], "]"}], "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["s", "T"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`$TorsionSign,
       Editable->False], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"VertDiff", "[", "chr", "]"}], "[", 
         RowBox[{"a", ",", "b", ",", "c"}], "]"}], "-", 
        RowBox[{
         RowBox[{"VertDiff", "[", "chr", "]"}], "[", 
         RowBox[{"a", ",", "c", ",", "b"}], "]"}]}], ")"}]}]}]}], 
   "]"}]}]], "Code",
 CellChangeTimes->{{3.958574614858528*^9, 3.9585746795140953`*^9}, {
   3.9585747833949833`*^9, 3.9585747839651985`*^9}, {3.9585748199811687`*^9, 
   3.958575074448263*^9}, {3.958575209990423*^9, 3.9585752160370655`*^9}, {
   3.9586014435065823`*^9, 3.9586015297987843`*^9}, {3.95860209072764*^9, 
   3.9586020938255367`*^9}, 3.9586023801284904`*^9},
 CellLabel->
  "In[317]:=",ExpressionUUID->"f2f155d4-408f-9843-b75b-837b862e5148"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modifications to ChangeCurvature"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, 3.9513399965763073`*^9, {
   3.954853260008972*^9, 3.954853261047636*^9}, {3.9578148760932865`*^9, 
   3.9578148767612953`*^9}, {3.9583106623357353`*^9, 3.958310663416765*^9}, {
   3.958572964293707*^9, 3.958572978603342*^9}, {3.9585730969542465`*^9, 
   3.9585731081919823`*^9}},ExpressionUUID->"905f8eb4-72fd-024f-a380-\
d25893259b5c"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Riemann"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.958063506353161*^9, {
   3.9589598675159206`*^9, 3.958959873456915*^9}, {3.9589599120820255`*^9, 
   3.9589599130205994`*^9}, {3.9589603724042835`*^9, 
   3.9589603936173687`*^9}, {3.9589609421120377`*^9, 
   3.9589609428392105`*^9}, {3.9606558124982414`*^9, 
   3.9606558148794155`*^9}},ExpressionUUID->"0adbb1e7-bad1-3d43-b2cc-\
f8bc84779674"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"With", " ", "no", " ", "need", " ", "of", " ", "a", " ", 
     RowBox[{"metric", ".", " ", "riemann"}], " ", "can", " ", "be", " ", 
     "either", " ", "Riemann", " ", "or", " ", 
     RowBox[{"FRiemann", ".", " ", "We"}], " ", "have", " ", "to", " ", "be", 
     " ", "careful", " ", "since", " ", 
     RowBox[{"dlRiemann", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}]}], "=!=", 
    RowBox[{"VertDiff", "[", 
     RowBox[{"Riemann", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "]"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"changedlRiemann", "[", 
       RowBox[{"covd1_", ",", "covd2_", ",", 
        RowBox[{"{", 
         RowBox[{"_", ",", "_", ",", "_"}], "}"}], ",", "riemann_"}], "]"}], "[", 
      RowBox[{
       RowBox[{"-", "c_Symbol"}], ",", 
       RowBox[{"-", "d_Symbol"}], ",", 
       RowBox[{"-", "b_Symbol"}], ",", "a_Symbol"}], "]"}], "/;", 
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{
        RowBox[{"SymmetryGroupOfTensor", "[", 
         RowBox[{"Riemann", "@", "covd1"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "===", "1"}]}], ":=", "\n", 
    RowBox[{"Module", "[", "\n", "\t", 
     RowBox[{
      RowBox[{"{", "\n", "\t", 
       RowBox[{
        RowBox[{"chr", "=", 
         RowBox[{"HeadOfTensor", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Christoffel", "[", 
             RowBox[{"covd1", ",", "covd2"}], "]"}], "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "b"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "b"}]}], "}"}]}], "]"}]}], ",", "dlchr", ",", "\n", 
        "\t", 
        RowBox[{"chr2", "=", 
         RowBox[{"HeadOfTensor", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Christoffel", "[", "covd2", "]"}], "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "b"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "b"}]}], "}"}]}], "]"}]}], ",", "dlchr2", ",", "\n",
         "\t", 
        RowBox[{"e", "=", 
         RowBox[{"DummyAs", "[", "a", "]"}]}]}], "\n", "\t", "}"}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"dlchr", "=", 
        RowBox[{"VertDiff", "@", "chr"}]}], ";", "\n", "\t", 
       RowBox[{"dlchr2", "=", 
        RowBox[{"VertDiff", "@", "chr2"}]}], ";", "\n", "\t", 
       RowBox[{
        RowBox[{"VertDiff", "[", 
         RowBox[{
          RowBox[{"riemann", "[", "covd2", "]"}], "[", 
          RowBox[{
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "+", 
        RowBox[{"$RiemannSign", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             RowBox[{"covd2", "[", 
              RowBox[{"-", "c"}], "]"}], "[", 
             RowBox[{"dlchr", "[", 
              RowBox[{"a", ",", 
               RowBox[{"-", "d"}], ",", 
               RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"covd2", "[", 
             RowBox[{"-", "d"}], "]"}], "[", 
            RowBox[{"dlchr", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"chr", "[", 
             RowBox[{"e", ",", 
              RowBox[{"-", "d"}], ",", 
              RowBox[{"-", "b"}]}], "]"}], 
            RowBox[{"dlchr", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "e"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"chr", "[", 
             RowBox[{"e", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "b"}]}], "]"}], 
            RowBox[{"dlchr", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "d"}], ",", 
              RowBox[{"-", "e"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"chr", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "e"}]}], "]"}], 
            RowBox[{"dlchr", "[", 
             RowBox[{"e", ",", 
              RowBox[{"-", "d"}], ",", 
              RowBox[{"-", "b"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"chr", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "d"}], ",", 
              RowBox[{"-", "e"}]}], "]"}], 
            RowBox[{"dlchr", "[", 
             RowBox[{"e", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "b"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"chr", "[", 
             RowBox[{"e", ",", 
              RowBox[{"-", "d"}], ",", 
              RowBox[{"-", "b"}]}], "]"}], 
            RowBox[{"dlchr2", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "e"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"chr", "[", 
             RowBox[{"e", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "b"}]}], "]"}], 
            RowBox[{"dlchr2", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "d"}], ",", 
              RowBox[{"-", "e"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"chr", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "e"}]}], "]"}], 
            RowBox[{"dlchr2", "[", 
             RowBox[{"e", ",", 
              RowBox[{"-", "d"}], ",", 
              RowBox[{"-", "b"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"chr", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "d"}], ",", 
              RowBox[{"-", "e"}]}], "]"}], 
            RowBox[{"dlchr2", "[", 
             RowBox[{"e", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "b"}]}], "]"}]}], "+", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"riemann", "===", "Riemann"}], ",", 
             RowBox[{
              RowBox[{"-", "$TorsionSign"}], " ", 
              RowBox[{
               RowBox[{"Torsion", "[", "covd2", "]"}], "[", 
               RowBox[{"e", ",", 
                RowBox[{"-", "c"}], ",", 
                RowBox[{"-", "d"}]}], "]"}], 
              RowBox[{"dlchr", "[", 
               RowBox[{"a", ",", 
                RowBox[{"-", "e"}], ",", 
                RowBox[{"-", "b"}]}], "]"}]}], ",", 
             RowBox[{"With", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"f", "=", 
                 RowBox[{"DummyAs", "[", "c", "]"}]}], "}"}], ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"VertDiff", "[", 
                    RowBox[{"ChristoffelAUX", "[", "covd2", "]"}], "]"}], "[", 
                   RowBox[{"f", ",", 
                    RowBox[{"-", "c"}], ",", 
                    RowBox[{"-", "d"}]}], "]"}], "-", 
                  RowBox[{
                   RowBox[{"VertDiff", "[", 
                    RowBox[{"ChristoffelAUX", "[", "covd2", "]"}], "]"}], "[", 
                   RowBox[{"f", ",", 
                    RowBox[{"-", "d"}], ",", 
                    RowBox[{"-", "c"}]}], "]"}]}], ")"}], 
                RowBox[{"chr", "[", 
                 RowBox[{"a", ",", 
                  RowBox[{"-", "f"}], ",", 
                  RowBox[{"-", "b"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
          ")"}]}]}]}]}], "\n", "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"changedlRiemann", "[", 
      RowBox[{"covd1_", ",", "covd2_", ",", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", "_"}], "}"}], ",", "riemann_"}], "]"}], "[", 
     RowBox[{"1", ",", "inds__"}], "]"}], ":=", "\n", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"chr", "=", 
         RowBox[{"ChristoffelAUX", "[", 
          RowBox[{"covd1", ",", "covd2"}], "]"}]}], ",", "dlchr", ",", 
        RowBox[{"chr2", "=", 
         RowBox[{"ChristoffelAUX", "[", "covd2", "]"}]}], ",", "dlchr2"}], 
       "}"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"No", " ", "FRiemann", " ", "possible"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"dlchr", "=", 
        RowBox[{"VertDiff", "@", "chr"}]}], ";", "\n", "\t", 
       RowBox[{"dlchr2", "=", 
        RowBox[{"VertDiff", "@", "chr2"}]}], ";", "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{"VertDiff", "[", 
         RowBox[{"ChangeCurvature", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Riemann", "[", "covd1", "]"}], "[", "inds", "]"}], ",", 
           "covd1", ",", "covd2"}], "]"}], "]"}], "//", 
        RowBox[{"ExpandVertDiff", "[", 
         RowBox[{"HoldExpandVertDiff", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Riemann", "[", "covd2", "]"}], ",", 
            RowBox[{"ChristoffelAUX", "[", 
             RowBox[{"covd1", ",", "covd2"}], "]"}], ",", 
            RowBox[{"ChristoffelAUX", "[", "covd2", "]"}]}], "}"}]}], 
         "]"}]}]}]}], "\n", "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"All", " ", "other", " ", "cases"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"changedlRiemann", "[", 
      RowBox[{"covd1_", ",", "covd2_", ",", 
       RowBox[{"{", 
        RowBox[{"tmetric_", ",", "vmetric_", ",", "vdagmetric_"}], "}"}], ",",
        "riemann_"}], "]"}], "[", 
     RowBox[{"c_", ",", "d_", ",", "b_", ",", "a_"}], "]"}], ":=", 
    RowBox[{"With", "[", "\n", "\t", 
     RowBox[{
      RowBox[{"{", "\n", "\t", 
       RowBox[{
        RowBox[{"vbundle", "=", 
         RowBox[{"VBundleOfIndex", "[", "a", "]"}]}], ",", "\n", "\t", 
        RowBox[{"tbundle", "=", 
         RowBox[{"VBundleOfIndex", "[", "c", "]"}]}], ",", "\n", "\t", 
        RowBox[{"vdmetric", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"riemann", "===", "FRiemann"}], "&&", 
            RowBox[{"HasDaggerCharacterQ", "[", "riemann", "]"}]}], ",", 
           "vdagmetric", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"riemann", "===", "FRiemann"}], ",", "vmetric", ",", 
             "tmetric"}], "]"}]}], "]"}]}]}], "\n", "\t", "}"}], ",", "\n", 
      "\t", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"c1", "=", 
           RowBox[{"DummyIn", "[", "tbundle", "]"}]}], ",", 
          RowBox[{"d1", "=", 
           RowBox[{"DummyIn", "[", "tbundle", "]"}]}], ",", 
          RowBox[{"b1", "=", 
           RowBox[{"DummyIn", "[", "vbundle", "]"}]}], ",", 
          RowBox[{"a1", "=", 
           RowBox[{"DummyIn", "[", "vbundle", "]"}]}]}], "}"}], ",", "\n", 
        "\t\t", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{
             RowBox[{"SymmetryGroupOfTensor", "[", 
              RowBox[{"Riemann", "@", "covd1"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}], "===", "1"}], ",", "\n", 
          "\t\t\t", 
          RowBox[{
           RowBox[{"tmetric", "[", 
            RowBox[{"c", ",", "c1"}], "]"}], 
           RowBox[{"tmetric", "[", 
            RowBox[{"d", ",", "d1"}], "]"}], 
           RowBox[{"vdmetric", "[", 
            RowBox[{"b", ",", "b1"}], "]"}], 
           RowBox[{"vdmetric", "[", 
            RowBox[{"a", ",", "a1"}], "]"}], 
           RowBox[{
            RowBox[{"changedlRiemann", "[", 
             RowBox[{"covd1", ",", "covd2", ",", 
              RowBox[{"{", 
               RowBox[{"delta", ",", "delta", ",", "delta"}], "}"}], ",", 
              "riemann"}], "]"}], "[", 
            RowBox[{
             RowBox[{"-", "c1"}], ",", 
             RowBox[{"-", "d1"}], ",", 
             RowBox[{"-", "b1"}], ",", "a1"}], "]"}]}], ",", "\n", "\t\t\t", 
          RowBox[{
           RowBox[{"tmetric", "[", 
            RowBox[{"c", ",", "c1"}], "]"}], 
           RowBox[{"tmetric", "[", 
            RowBox[{"d", ",", "d1"}], "]"}], 
           RowBox[{"vdmetric", "[", 
            RowBox[{"b", ",", "b1"}], "]"}], 
           RowBox[{"vdmetric", "[", 
            RowBox[{"a", ",", "a1"}], "]"}], 
           RowBox[{
            RowBox[{"changedlRiemann", "[", 
             RowBox[{"covd1", ",", "covd2", ",", 
              RowBox[{"{", 
               RowBox[{"delta", ",", "delta", ",", "delta"}], "}"}], ",", 
              "riemann"}], "]"}], "[", 
            RowBox[{"1", ",", 
             RowBox[{"-", "c1"}], ",", 
             RowBox[{"-", "d1"}], ",", 
             RowBox[{"-", "b1"}], ",", 
             RowBox[{"-", "a1"}]}], "]"}]}]}], "\n", "\t\t", "]"}]}], "\n", 
       "\t", "]"}]}], "\n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.9588755873075294`*^9, 3.958875592991167*^9}, {
   3.9588770679460335`*^9, 3.958877092185362*^9}, {3.958878451783495*^9, 
   3.9588784535808296`*^9}, {3.9588785063791733`*^9, 
   3.9588785535975285`*^9}, {3.9588788027568703`*^9, 3.958878803173258*^9}, {
   3.9588789453834305`*^9, 3.9588789695619793`*^9}, {3.9588791653081207`*^9, 
   3.958879212492502*^9}, {3.958879358790642*^9, 3.9588793778915825`*^9}, {
   3.9588794917137737`*^9, 3.9588795244168816`*^9}, {3.958879595290573*^9, 
   3.958879601022873*^9}, {3.9588797427305126`*^9, 3.9588797472278194`*^9}, {
   3.958879781133108*^9, 3.958879784492655*^9}, 3.9588798473395367`*^9, {
   3.9588799579402065`*^9, 3.9588799811839447`*^9}, {3.958880181324486*^9, 
   3.9588802040047455`*^9}, {3.958880258296278*^9, 3.9588802674796467`*^9}, {
   3.958880559533945*^9, 3.9588805956330795`*^9}, {3.958880701151869*^9, 
   3.9588807033104076`*^9}, {3.9588808205170536`*^9, 
   3.9588808645634556`*^9}, {3.958880911421856*^9, 3.958880946145529*^9}, 
   3.9588810782151566`*^9, 3.9588885918565865`*^9, {3.9589663243825417`*^9, 
   3.958966358288231*^9}, {3.9589676158722057`*^9, 3.958967711145918*^9}, {
   3.9589679802727165`*^9, 3.9589679808416786`*^9}, {3.9589683323712215`*^9, 
   3.9589683677195683`*^9}, {3.95896846621332*^9, 3.9589684721787663`*^9}, {
   3.9589686263263435`*^9, 3.9589686751136837`*^9}, {3.9589687417445717`*^9, 
   3.9589687823521366`*^9}, {3.9589690202206345`*^9, 3.958969020439745*^9}, {
   3.9589691962930145`*^9, 3.9589691997116795`*^9}, {3.958969243162096*^9, 
   3.958969304528347*^9}, 3.9589696681753006`*^9, {3.9589698412160473`*^9, 
   3.9589698809951534`*^9}, {3.958970046429825*^9, 3.9589700767143726`*^9}, {
   3.9589701304133873`*^9, 3.9589701684578075`*^9}, {3.9589702595595703`*^9, 
   3.958970295523325*^9}, {3.958970646162134*^9, 3.9589707061844425`*^9}, 
   3.958971416355734*^9, {3.9589719550007515`*^9, 3.9589719630082264`*^9}, {
   3.9589720037761097`*^9, 3.958972029730509*^9}, {3.9589720661340027`*^9, 
   3.958972070244564*^9}, {3.9589721198254776`*^9, 3.9589721555206413`*^9}, {
   3.958972488567461*^9, 3.9589725027816734`*^9}, {3.958972745333109*^9, 
   3.958972752366781*^9}, {3.958973804308567*^9, 3.9589738416091366`*^9}, {
   3.958974024684347*^9, 3.958974042473545*^9}, {3.9589741870307217`*^9, 
   3.95897422211302*^9}, {3.9589743114436646`*^9, 3.95897431449889*^9}, {
   3.958974424833273*^9, 3.958974444883568*^9}, 3.958974486353737*^9, 
   3.958974969772499*^9, {3.9589751824670143`*^9, 3.958975189704483*^9}, {
   3.958975253959612*^9, 3.9589752627974033`*^9}, {3.9589755837477036`*^9, 
   3.9589756355235233`*^9}, 3.9589756884380264`*^9, {3.9589761103904095`*^9, 
   3.9589761135911674`*^9}, {3.9589761537746296`*^9, 
   3.9589761656252766`*^9}, {3.9589763537293205`*^9, 3.958976390740587*^9}, {
   3.9589765974016056`*^9, 3.9589766241935787`*^9}, {3.9590086097879257`*^9, 
   3.9590086520280476`*^9}, {3.9590086990518684`*^9, 3.959008709672907*^9}, {
   3.959008827110548*^9, 3.959008843311016*^9}, {3.9591744514627743`*^9, 
   3.9591744564871044`*^9}, {3.9591748535740166`*^9, 
   3.9591748564004173`*^9}, {3.9591749237877884`*^9, 3.959174946900385*^9}, {
   3.9591749836724777`*^9, 3.9591749942743835`*^9}, {3.959175055326441*^9, 
   3.959175102662451*^9}, {3.9591754518069305`*^9, 3.9591754591565495`*^9}, {
   3.959175493583914*^9, 3.9591754971068153`*^9}, {3.959175714124792*^9, 
   3.9591757192370834`*^9}, {3.959178466936617*^9, 3.9591784715547104`*^9}, {
   3.959178904577057*^9, 3.9591789121060295`*^9}, {3.9591789468770256`*^9, 
   3.9591790201621113`*^9}, {3.9591790522248745`*^9, 
   3.9591791781245575`*^9}, {3.9591797625597343`*^9, 3.959179839878401*^9}, {
   3.9591806457390327`*^9, 3.959180648535244*^9}, {3.9591815869325256`*^9, 
   3.959181598100033*^9}, 3.959181750773329*^9, {3.9591819803533*^9, 
   3.9591819949205647`*^9}, {3.959406620051264*^9, 3.959406620615383*^9}, {
   3.9594933002588024`*^9, 3.959493344332304*^9}, 3.959578215477335*^9, 
   3.9595785049824867`*^9},
 CellLabel->
  "In[318]:=",ExpressionUUID->"c0407f90-e628-5341-b941-5c9e53cd3448"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Private`makeChangeRiemannRule", "[", 
    RowBox[{"covd2_", ",", 
     RowBox[{"{", 
      RowBox[{"tmetric_", ",", "vmetric_", ",", "vdagmetric_"}], "}"}], ",", 
     "riemann_"}], "]"}], "[", "covd1_", "]"}], ":=", 
  RowBox[{"With", "[", "\n", "\t", 
   RowBox[{
    RowBox[{"{", "\n", "\t", 
     RowBox[{
      RowBox[{"riemann1", "=", 
       RowBox[{"riemann", "@", "covd1"}]}], ",", "\n", "\t", 
      RowBox[{"dlriemann1", "=", 
       RowBox[{"VertDiff", "@", 
        RowBox[{"riemann", "@", "covd1"}]}]}]}], "\n", "\t", "}"}], ",", "\n",
     "\t", 
    RowBox[{"{", "\n", "\t", 
     RowBox[{
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{"riemann1", "[", 
         RowBox[{"c_", ",", "d_", ",", "b_", ",", "a_"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"xAct`xTensor`Private`changeRiemann", "[", 
         RowBox[{"covd1", ",", "covd2", ",", 
          RowBox[{"{", 
           RowBox[{"tmetric", ",", "vmetric", ",", "vdagmetric"}], "}"}], ",",
           "riemann"}], "]"}], "[", 
        RowBox[{"c", ",", "d", ",", "b", ",", "a"}], "]"}]}], ",", "\n", "\t", 
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{"dlriemann1", "[", 
         RowBox[{"c_", ",", "d_", ",", "b_", ",", "a_"}], "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"changedlRiemann", "[", 
         RowBox[{"covd1", ",", "covd2", ",", 
          RowBox[{"{", 
           RowBox[{"tmetric", ",", "vmetric", ",", "vdagmetric"}], "}"}], ",",
           "riemann"}], "]"}], "[", 
        RowBox[{"c", ",", "d", ",", "b", ",", "a"}], "]"}]}]}], "\n", "\t", 
     "}"}]}], "\n", "]"}]}]], "Code",
 CellChangeTimes->{{3.9588756007368813`*^9, 3.958875600935013*^9}, {
  3.958889169107073*^9, 3.958889205139801*^9}, {3.958973981054865*^9, 
  3.958973983550707*^9}},
 CellLabel->
  "In[321]:=",ExpressionUUID->"71b573d1-c607-ad4b-b88b-e90dd3b5073b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Ricci"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.958063506353161*^9, {
   3.9589598675159206`*^9, 3.958959873456915*^9}, {3.9589599120820255`*^9, 
   3.9589599130205994`*^9}, {3.9589603724042835`*^9, 
   3.9589603936173687`*^9}, {3.9589609421120377`*^9, 3.958960949591818*^9}, 
   3.9606558189810085`*^9},ExpressionUUID->"35bc4a5d-947b-6340-b520-\
dd775ab4c489"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"changedlRicci", "[", 
     RowBox[{"covd1_", ",", "covd2_", ",", "_"}], "]"}], "[", 
    RowBox[{
     RowBox[{"-", "c_Symbol"}], ",", 
     RowBox[{"-", "b_Symbol"}]}], "]"}], ":=", "\n", 
   RowBox[{"Module", "[", "\n", "\t", 
    RowBox[{
     RowBox[{"{", "\n", "\t", 
      RowBox[{
       RowBox[{"a", "=", 
        RowBox[{"DummyAs", "[", "c", "]"}]}], ",", 
       RowBox[{"e", "=", 
        RowBox[{"DummyAs", "[", "b", "]"}]}], ",", "\n", "\t", "chr", ",", 
       "dlchr", ",", "\n", "\t", "chr2", ",", "dlchr2"}], "\n", "\t", "}"}], ",",
      "\n", "\t", 
     RowBox[{
      RowBox[{"chr", "=", 
       RowBox[{"HeadOfTensor", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Christoffel", "[", 
           RowBox[{"covd1", ",", "covd2"}], "]"}], "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "}"}]}], "]"}]}], ";", "\n", "\t", 
      RowBox[{"chr2", "=", 
       RowBox[{"HeadOfTensor", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Christoffel", "[", "covd2", "]"}], "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
       "\t", 
      RowBox[{"dlchr", "=", 
       RowBox[{"VertDiff", "@", "chr"}]}], ";", " ", 
      RowBox[{"dlchr2", "=", 
       RowBox[{"VertDiff", "@", "chr2"}]}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"VertDiff", "[", 
        RowBox[{
         RowBox[{"Ricci", "[", "covd2", "]"}], "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
       RowBox[{"$RiemannSign", " ", "$RicciSign", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"covd2", "[", 
             RowBox[{"-", "c"}], "]"}], "[", 
            RowBox[{"dlchr", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "a"}], ",", 
              RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"covd2", "[", 
            RowBox[{"-", "a"}], "]"}], "[", 
           RowBox[{"dlchr", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{"chr", "[", 
            RowBox[{"e", ",", 
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}]}], "]"}], 
           RowBox[{"dlchr", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "e"}]}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"chr", "[", 
            RowBox[{"e", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "b"}]}], "]"}], 
           RowBox[{"dlchr", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "e"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"chr", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "e"}]}], "]"}], 
           RowBox[{"dlchr", "[", 
            RowBox[{"e", ",", 
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"chr", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "e"}]}], "]"}], 
           RowBox[{"dlchr", "[", 
            RowBox[{"e", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"chr", "[", 
            RowBox[{"e", ",", 
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}]}], "]"}], 
           RowBox[{"dlchr2", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "e"}]}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"chr", "[", 
            RowBox[{"e", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "b"}]}], "]"}], 
           RowBox[{"dlchr2", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "e"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"chr", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "e"}]}], "]"}], 
           RowBox[{"dlchr2", "[", 
            RowBox[{"e", ",", 
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"chr", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "e"}]}], "]"}], 
           RowBox[{"dlchr2", "[", 
            RowBox[{"e", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], "-", 
          RowBox[{"$TorsionSign", " ", 
           RowBox[{
            RowBox[{"Torsion", "[", "covd2", "]"}], "[", 
            RowBox[{"e", ",", 
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "a"}]}], "]"}], 
           RowBox[{"dlchr", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "e"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}]}], ")"}]}]}]}]}], "\n", "]"}]}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"changedlRicci", "[", 
    RowBox[{"covd1_", ",", "covd2_", ",", "tmetric_"}], "]"}], "[", 
   RowBox[{"c_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"vbundle", "=", 
      RowBox[{"VBundleOfIndex", "[", "c", "]"}]}], "}"}], ",", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"c1", "=", 
         RowBox[{"DummyIn", "[", "vbundle", "]"}]}], ",", 
        RowBox[{"b1", "=", 
         RowBox[{"DummyIn", "[", "vbundle", "]"}]}]}], "}"}], ",", "\n", 
      RowBox[{
       RowBox[{"tmetric", "[", 
        RowBox[{"c", ",", "c1"}], "]"}], 
       RowBox[{"tmetric", "[", 
        RowBox[{"b", ",", "b1"}], "]"}], 
       RowBox[{
        RowBox[{"changedlRicci", "[", 
         RowBox[{"covd1", ",", "covd2", ",", "HELLO"}], "]"}], "[", 
        RowBox[{
         RowBox[{"-", "c1"}], ",", 
         RowBox[{"-", "b1"}]}], "]"}]}]}], "]"}]}], "]"}]}]}], "Code",
 CellChangeTimes->{{3.9589609540463066`*^9, 3.9589609954672775`*^9}, 
   3.9589688398263874`*^9, {3.9589732266461887`*^9, 3.958973311662071*^9}, {
   3.958973343971752*^9, 3.958973346066492*^9}, 3.9589746809005527`*^9, {
   3.959182677244343*^9, 3.95918270752862*^9}, {3.9591829201453075`*^9, 
   3.959182920795643*^9}, {3.95940665823794*^9, 3.959406821321409*^9}, {
   3.959406876301676*^9, 3.9594068767338924`*^9}, {3.9594069121138325`*^9, 
   3.9594069355410633`*^9}, 3.9594941690442104`*^9, {3.959578192978039*^9, 
   3.959578194414175*^9}},
 CellLabel->
  "In[322]:=",ExpressionUUID->"4989b6d0-5da0-a84a-a126-94013b62af89"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xAct`xTensor`Private`makeChangeRicciRule", "[", 
     RowBox[{"covd2_", ",", "metric_"}], "]"}], "[", "covd1_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ricci", "=", 
        RowBox[{"Ricci", "[", "covd1", "]"}]}], ",", 
       RowBox[{"dlricci", "=", 
        RowBox[{"VertDiff", "@", 
         RowBox[{"Ricci", "@", "covd1"}]}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"{", "\n", "\t", 
      RowBox[{
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{"ricci", "[", "inds__", "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"xAct`xTensor`Private`changeRicci", "[", 
          RowBox[{"covd1", ",", "covd2", ",", "metric"}], "]"}], "[", "inds", 
         "]"}]}], ",", "\n", "\t", 
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{"dlricci", "[", "inds__", "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"changedlRicci", "[", 
          RowBox[{"covd1", ",", "covd2", ",", "metric"}], "]"}], "[", "inds", 
         "]"}]}]}], "\n", "\t", "}"}]}], "\n", "\t", "]"}]}], ";"}]], "Code",
 CellChangeTimes->{{3.9589610086529045`*^9, 3.9589610094100647`*^9}, {
  3.9589688492656803`*^9, 3.9589688572826157`*^9}},
 CellLabel->
  "In[324]:=",ExpressionUUID->"b7e1b557-56bd-9e48-9827-a826cd6798a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". RicciScalar"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.958063506353161*^9, {
   3.9589598675159206`*^9, 3.958959873456915*^9}, {3.9589599120820255`*^9, 
   3.9589599130205994`*^9}, {3.9589603724042835`*^9, 
   3.9589603936173687`*^9}, {3.9589609421120377`*^9, 3.958960949591818*^9}, {
   3.9589611612107086`*^9, 3.9589611618375683`*^9}, 
   3.9606558225967464`*^9},ExpressionUUID->"7039df52-5bac-2d4b-b323-\
5382fc5d20fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"changedlRicciScalar", "[", 
     RowBox[{"covd1_", ",", "covd2_", ",", "metricofcovd1_"}], "]"}], "[", 
    "]"}], ":=", 
   RowBox[{"Module", "[", "\n", "\t", 
    RowBox[{
     RowBox[{"{", "\n", "\t", 
      RowBox[{
       RowBox[{"a", "=", 
        RowBox[{"DummyIn", "[", 
         RowBox[{
         "xAct`xTensor`Private`TangentBundleOfCovD", "[", "covd1", "]"}], 
         "]"}]}], ",", "\n", "\t", 
       RowBox[{"b", "=", 
        RowBox[{"DummyIn", "[", 
         RowBox[{
         "xAct`xTensor`Private`TangentBundleOfCovD", "[", "covd1", "]"}], 
         "]"}]}]}], "\n", "\t", "}"}], ",", "\n", "\t", 
     RowBox[{
      RowBox[{"Scalar", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"VertDiff", "[", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<Inv\>\"", "<>", 
            RowBox[{"ToString", "[", "metricofcovd1", "]"}]}], "]"}], "]"}], "[", 
         RowBox[{"a", ",", "b"}], "]"}], 
        RowBox[{
         RowBox[{"xAct`xTensor`Private`changeRicci", "[", 
          RowBox[{"covd1", ",", "covd2", ",", "HELLO"}], "]"}], "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "b"}]}], "]"}]}], "]"}], "+", 
      RowBox[{"Scalar", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Inv", "[", "metricofcovd1", "]"}], "[", 
         RowBox[{"a", ",", "b"}], "]"}], 
        RowBox[{
         RowBox[{"changedlRicci", "[", 
          RowBox[{"covd1", ",", "covd2", ",", "HELLO"}], "]"}], "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "b"}]}], "]"}]}], "]"}]}]}], "\n", "]"}]}], 
  ";"}]], "Code",
 CellChangeTimes->{{3.958961812953209*^9, 3.9589619115980797`*^9}, {
   3.958962252745405*^9, 3.958962268267004*^9}, {3.9589639266146736`*^9, 
   3.95896396642655*^9}, 3.9589640628427086`*^9, {3.9589640931931496`*^9, 
   3.9589640973580284`*^9}, {3.958964672136074*^9, 3.9589646989086227`*^9}, {
   3.9589648815927258`*^9, 3.958964895151312*^9}, {3.9589688666296673`*^9, 
   3.9589688815179596`*^9}, {3.959406652393465*^9, 3.9594066525743713`*^9}},
 CellLabel->
  "In[325]:=",ExpressionUUID->"ca0516c5-c786-d445-ae88-042e352751d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xAct`xTensor`Private`makeChangeRicciScalarRule", "[", 
     RowBox[{"covd2_", ",", "metricofcovd1_"}], "]"}], "[", "covd1_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ricciscalar", "=", 
        RowBox[{"RicciScalar", "[", "covd1", "]"}]}], ",", 
       RowBox[{"dlricciscalar", "=", 
        RowBox[{"VertDiff", "@", 
         RowBox[{"RicciScalar", "@", "covd1"}]}]}]}], "}"}], ",", "\n", "\t", 
     RowBox[{"{", "\n", "\t", 
      RowBox[{
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{"ricciscalar", "[", "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"xAct`xTensor`Private`changeRicciScalar", "[", 
          RowBox[{"covd1", ",", "covd2", ",", "metricofcovd1"}], "]"}], "[", 
         "]"}]}], ",", "\n", "\t", 
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{"dlricciscalar", "[", "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"changedlRicciScalar", "[", 
          RowBox[{"covd1", ",", "covd2", ",", "metricofcovd1"}], "]"}], "[", 
         "]"}]}]}], "\n", "\t", "}"}]}], "\n", "]"}]}], ";"}]], "Code",
 CellChangeTimes->{{3.9589619137806168`*^9, 3.9589619800127106`*^9}, {
  3.958968890263109*^9, 3.958968898106409*^9}},
 CellLabel->
  "In[326]:=",ExpressionUUID->"49480f81-4922-b34f-bacf-d587d64c7dd8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modifications to Keep (ToCanonical and FindIndices)"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.9483962010397806`*^9, 
   3.9483962052575536`*^9}, {3.9485440862188888`*^9, 3.948544094933917*^9}, {
   3.951240076883114*^9, 3.9512400771890736`*^9}, {3.9513388116487045`*^9, 
   3.951338818143345*^9}},ExpressionUUID->"bbaef46c-5e46-6d4b-bb38-\
342535a59926"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"TODO", ":", " ", 
    RowBox[{"Is", " ", "this", " ", "a", " ", "good", " ", 
     RowBox[{"idea", "?", " ", "It"}], " ", "allows", " ", "to", " ", 
     "handle", " ", "Keep", " ", "betten", " ", "within", " ", "xAct"}]}], 
   " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"Unprotect", "[", 
     RowBox[{
     "ToCanonical", ",", "Keep", ",", "FindIndices", ",", "SymmetryOf"}], 
     "]"}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FindIndices", "[", 
     RowBox[{"Keep", "[", "expr_", "]"}], "]"}], ":=", 
    RowBox[{"FindIndices", "[", "expr", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ToCanonical", "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{"Keep", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
    RowBox[{"Keep", "[", 
     RowBox[{"ToCanonical", "[", "expr", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ToCanonical", "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"der_", "?", "CovDQ"}], "[", "ind_", "]"}], "[", "expr_Keep", 
       "]"}], "]"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"der", "[", "ind", "]"}], "[", 
     RowBox[{"Keep", "[", 
      RowBox[{"ToCanonical", "[", "expr", "]"}], "]"}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"SymmetryOf", "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{"Keep", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
    RowBox[{"SymmetryOf", "[", "expr", "]"}]}], "\n", 
   RowBox[{
    RowBox[{"Keep", "[", "0", "]"}], ":=", "0"}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", 
     RowBox[{
     "ToCanonical", ",", "Keep", ",", "FindIndices", ",", "SymmetryOf"}], 
     "]"}], ";"}]}]}]], "Code",
 CellChangeTimes->{{3.948544073068562*^9, 3.948544077530258*^9}, {
   3.950615287657852*^9, 3.950615289351183*^9}, {3.950809025843826*^9, 
   3.950809026354866*^9}, {3.950820355613949*^9, 3.950820355766403*^9}, 
   3.950820485851517*^9, {3.9512399988519993`*^9, 3.951240006113128*^9}, {
   3.951240066810953*^9, 3.951240070037161*^9}, {3.951243339888844*^9, 
   3.951243340331545*^9}, {3.951338667798853*^9, 3.95133869414957*^9}, 
   3.9513388336053524`*^9, 3.9513388748294983`*^9, {3.951338967235264*^9, 
   3.951338975898864*^9}, {3.951339008351334*^9, 3.951339059126438*^9}, {
   3.95133924603188*^9, 3.951339259036854*^9}, {3.951339340721939*^9, 
   3.951339420450149*^9}, 3.9513395220683002`*^9, 3.951339575877121*^9, {
   3.951339610589823*^9, 3.951339623104803*^9}, {3.95147463959321*^9, 
   3.951474639853321*^9}, {3.9538336181176224`*^9, 3.953833620134678*^9}, {
   3.9588888841660748`*^9, 3.9588888953347607`*^9}},
 CellLabel->
  "In[328]:=",ExpressionUUID->"8c643fe2-d344-0946-a1e6-c03860f7495d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification to Grade (for InertHeads)"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, 
   3.9548531945746136`*^9},ExpressionUUID->"1d7c4fee-4b1c-4648-a591-\
605ce13823a1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "[", "Grade", "]"}], ";"}], "\[IndentingNewLine]", 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Grade", "[", 
     RowBox[{"xAct`xTensor`Private`TMPChristoffel", "[", "expr", "]"}], "]"}],
     " ", "gives", " ", "an", " ", "error"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Grade", "[", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`ih", ":", 
     RowBox[{
      RowBox[{"_", "?", "InertHeadQ"}], "[", "__", "]"}]}], ",", 
    RowBox[{"xAct`xTensor`Private`prod_", "?", "GradedProductQ"}]}], "]"}], 
  "=."}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Grade", "[", 
    RowBox[{"xAct`xTensor`Private`expr_", ",", 
     RowBox[{"xAct`xTensor`Private`prod_", "?", "ProductQ"}]}], "]"}], "=."}],
   "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Grade", "/:", 
   RowBox[{"Grade", "[", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"xAct`xTensor`Private`TMPChristoffel", "[", "expr_", "]"}], 
      "]"}], ",", "WWedge"}], "]"}], ":=", 
   RowBox[{"VertDeg", "[", "expr", "]"}]}], " ", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Grade", "[", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`ih", ":", 
     RowBox[{
      RowBox[{"_", "?", "InertHeadQ"}], "[", "__", "]"}]}], ",", 
    RowBox[{"xAct`xTensor`Private`prod_", "?", "GradedProductQ"}]}], "]"}], ":=", 
  RowBox[{"Throw", "[", 
   RowBox[{"Message", "[", 
    RowBox[{
     StyleBox[
      RowBox[{"Grade", "::", "unknown"}], "MessageName"], 
     ",", "\"\<grade of inert-head expression\>\"", ",", 
     "xAct`xTensor`Private`ih"}], "]"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Grade", "[", 
    RowBox[{"xAct`xTensor`Private`expr_", ",", 
     RowBox[{"xAct`xTensor`Private`prod_", "?", "ProductQ"}]}], "]"}], ":=", 
   "0"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", 
   RowBox[{"\.08", "[", "Grade", "]"}]}], ";"}]}], "Code",
 CellChangeTimes->{{3.949766687709888*^9, 3.949766701205967*^9}, {
  3.95147462404035*^9, 3.9514746292472534`*^9}, {3.9557160757854557`*^9, 
  3.955716082136732*^9}, {3.957386231951769*^9, 3.957386232077446*^9}, {
  3.9589699161449203`*^9, 3.958969933877062*^9}},
 CellLabel->
  "In[335]:=",ExpressionUUID->"56e8bba1-0dfc-8c42-a6ff-83ec45e1dc0a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Vertical operators"
}], "Section",
 CellChangeTimes->{{3.9318353438923273`*^9, 3.93183534696952*^9}, {
  3.948390990670926*^9, 3.948391013264657*^9}, {3.9483916221127553`*^9, 
  3.948391623023337*^9}},ExpressionUUID->"e4866151-ccbd-2a43-868f-\
b25b443599c5"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Graded derivative"
}], "Subsection",
 CellChangeTimes->{
  3.9323871707782125`*^9, 3.9329753373789573`*^9, {3.948390984477461*^9, 
   3.948391007409444*^9}, 
   3.958648102566723*^9},ExpressionUUID->"ee0f5dd5-f6be-bd49-ba8d-\
0d74583ca0a8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GradeOfDer", "[", 
    RowBox[{
     RowBox[{"head_", "[", 
      RowBox[{"v_", ",", "rest___"}], "]"}], ",", "WWedge"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"GradeOfDer", "[", 
     RowBox[{"head", ",", "WWedge"}], "]"}], "+", 
    RowBox[{"VertDeg", "[", "v", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GradeOfDer", "[", 
    RowBox[{
     RowBox[{"head_", "[", 
      RowBox[{"v_", ",", "rest___"}], "]"}], ",", "prod_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"GradeOfDer", "[", 
     RowBox[{"head", ",", "prod"}], "]"}], "+", 
    RowBox[{"Grade", "[", 
     RowBox[{"v", ",", "prod"}], "]"}]}]}], ";"}]}], "Code",
 CellChangeTimes->{{3.958648547932392*^9, 3.9586485500581303`*^9}},
 CellLabel->
  "In[348]:=",ExpressionUUID->"13167322-9289-ad4d-8104-ee12f396ff76"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "DefGradedDer", " ", "and", " ", "MakeDerivation", " ", "are", " ", 
    "based", " ", "on", " ", "xTerior"}], " ", "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "DefGradedDer", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{"PrintAs", "\[Rule]", "Identity"}], "}"}]}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DefGradedDer", "[", 
      RowBox[{"der_", ",", 
       RowBox[{"prod_", "?", "ProductQ"}], ",", 
       RowBox[{"dergrade_", ":", "0"}], ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"head", "=", 
         RowBox[{"SubHead", "[", "der", "]"}]}], "}"}], ",", "\n", "\t", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "pa", "}"}], ",", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", "\t\t", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"{", "pa", "}"}], "=", 
             RowBox[{"OptionValue", "[", 
              RowBox[{"{", "PrintAs", "}"}], "]"}]}], ";"}], " ", 
           RowBox[{"(*", " ", 
            RowBox[{"The", " ", "brackets", " ", "are", " ", "important"}], 
            " ", "*)"}], "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
           "\t\t", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{
             "DefInertHead", " ", "will", " ", "take", " ", "care", " ", "of",
               " ", "scalar"}], "-", 
             RowBox[{"homogeneity", " ", "and", " ", "linearity"}]}], " ", 
            "*)"}], "\[IndentingNewLine]", "\t\t", 
           RowBox[{"DefInertHead", "[", 
            RowBox[{"der", ",", 
             RowBox[{"LinearQ", "\[Rule]", "True"}], ",", 
             RowBox[{"ContractThrough", "\[Rule]", 
              RowBox[{"{", "delta", "}"}]}], ",", 
             RowBox[{"PrintAs", "\[Rule]", "pa"}], ",", 
             RowBox[{"DefInfo", "\[Rule]", "Null"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\t\t", "\[IndentingNewLine]", "\t\t", 
          RowBox[{"(*", " ", 
           RowBox[{"Nonatomic", " ", "derivation"}], " ", "*)"}], " ", 
          "\[IndentingNewLine]", "\t\t", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"der", "=!=", "head"}], ",", "\[IndentingNewLine]", 
            "\t\t\t", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"head", "[", "0", "]"}], "[", "__", "]"}], ":=", "0"}],
              ";", "\[IndentingNewLine]", "\t\t\t", 
             RowBox[{
              RowBox[{
               RowBox[{"head", "[", "v_Plus", "]"}], "[", "args__", "]"}], ":=", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"head", "[", "#", "]"}], "[", "args", "]"}], "&"}], "/@",
                "v"}]}], ";", "\[IndentingNewLine]", "\t\t", 
             "\[IndentingNewLine]", "\t\t\t", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Subscript", " ", "vector", " ", "argument", " ", "for", " ", 
               "formatting"}], " ", "*)"}], "\[IndentingNewLine]", "\t\t\t", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"pa", "===", "Identity"}], ",", 
               RowBox[{"pa", "=", 
                RowBox[{"PrintAs", "[", "head", "]"}]}]}], "]"}], ";", 
             "\[IndentingNewLine]", "\t\t\t", 
             RowBox[{"head", "/:", 
              RowBox[{"MakeBoxes", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"head", "[", "v_", "]"}], "[", "form_", "]"}], ",", 
                "StandardForm"}], "]"}], ":=", 
              RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"head", "[", "v", "]"}], "[", "form", "]"}], ",", 
                RowBox[{"RowBox", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"SubscriptBox", "[", 
                    RowBox[{"pa", ",", 
                    RowBox[{"MakeBoxes", "[", 
                    RowBox[{"v", ",", "StandardForm"}], "]"}]}], "]"}], 
                   ",", "\"\<[\>\"", ",", 
                   RowBox[{"MakeBoxes", "[", 
                    RowBox[{"form", ",", "StandardForm"}], "]"}], 
                   ",", "\"\<]\>\""}], "}"}], "]"}]}], "]"}]}], ";"}]}], 
           "\[IndentingNewLine]", "\t\t", "]"}], ";", "\n", "\t\t", 
          "\[IndentingNewLine]", "\t\t", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Other", " ", "properties", " ", "of", " ", "a", " ", 
            "derivation"}], " ", "*)"}], "\n", "\t\t", 
          RowBox[{"MakeDerivation", "[", 
           RowBox[{"head", ",", "der", ",", 
            RowBox[{"NoPattern", "[", "der", "]"}], ",", "prod", ",", 
            "dergrade"}], "]"}], ";"}]}], "\[IndentingNewLine]", "\t", 
        "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\n"}]}]], "Code",
 CellChangeTimes->{
  3.931835372916299*^9, {3.932387185729431*^9, 3.932387193462603*^9}, {
   3.93252250538302*^9, 3.9325225070492535`*^9}, {3.932711206407941*^9, 
   3.932711209556363*^9}, 3.932718426750767*^9, {3.9333261266655197`*^9, 
   3.9333261329918365`*^9}, {3.948541749305247*^9, 3.948541775317428*^9}, 
   3.948542220460404*^9, {3.948566984793229*^9, 3.948566989461704*^9}, {
   3.948569307146552*^9, 3.948569322622099*^9}, {3.948571160516743*^9, 
   3.9485711667927012`*^9}, {3.948571312276739*^9, 3.948571336050551*^9}, {
   3.948571777486777*^9, 3.9485718168331785`*^9}, {3.948573057374231*^9, 
   3.948573091016321*^9}, {3.9485736026688957`*^9, 3.9485736147190657`*^9}, {
   3.948573749847437*^9, 3.948573763672159*^9}, {3.9486632944334364`*^9, 
   3.948663313480654*^9}, {3.948663408836893*^9, 3.9486635897369184`*^9}, {
   3.948663803308764*^9, 3.948663818629936*^9}, {3.9486639104503837`*^9, 
   3.948663932223798*^9}, 3.948664056798455*^9, {3.94866410209179*^9, 
   3.948664139090905*^9}, {3.948664556446454*^9, 3.948664576710037*^9}, {
   3.948665111685443*^9, 3.9486651135173*^9}, {3.949330398172826*^9, 
   3.949330423874981*^9}, {3.949330507405087*^9, 3.949330560176222*^9}, {
   3.949330781220215*^9, 3.9493308397492394`*^9}, {3.949330895499647*^9, 
   3.9493309230360823`*^9}, {3.949331028182238*^9, 3.949331037450409*^9}, {
   3.949335347538092*^9, 3.949335353434855*^9}, {3.949345185879895*^9, 
   3.949345196765242*^9}, {3.9493457693343105`*^9, 3.949345771390513*^9}, {
   3.9493458611301146`*^9, 3.949345873019699*^9}, {3.949345924661089*^9, 
   3.949345926312169*^9}, {3.9497667089085655`*^9, 3.949766746970703*^9}, {
   3.950207496886856*^9, 3.9502074978953457`*^9}, {3.951224691202423*^9, 
   3.9512246914810905`*^9}, {3.951312238040123*^9, 3.951312238220494*^9}, {
   3.951396447136999*^9, 3.951396466182281*^9}, 3.951396817166485*^9, 
   3.9548534698050137`*^9, {3.955200504901388*^9, 3.955200507651657*^9}, {
   3.955291039210335*^9, 3.955291095781063*^9}, {3.955291159380802*^9, 
   3.955291166945162*^9}, 3.9552915192318325`*^9, {3.9552915695241547`*^9, 
   3.9552915720973625`*^9}, {3.9552917033412457`*^9, 3.955291716066183*^9}, 
   3.955291893591463*^9, {3.955291972983904*^9, 3.955292006910963*^9}, {
   3.9582319258663044`*^9, 3.958232013188545*^9}, {3.958232342492237*^9, 
   3.958232377354368*^9}, {3.9582324354432793`*^9, 3.95823243995784*^9}, {
   3.958232553505617*^9, 3.9582326350267544`*^9}, {3.958232753911854*^9, 
   3.9582328642860794`*^9}, {3.9586485253045692`*^9, 3.9586485406359005`*^9}},
 CellLabel->
  "In[350]:=",ExpressionUUID->"b2dd14ce-8ef2-9742-ab81-332cd756406a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "part", " ", "is", " ", "separated", " ", "in", " ", "order", 
    " ", "to", " ", "avoid", " ", "renaming", " ", "confusion", " ", 
    "between", " ", "derL", " ", "and", " ", 
    RowBox[{"derR", ":"}]}], "*)"}], "\n", 
  RowBox[{
   RowBox[{"MakeDerivation", "[", 
    RowBox[{
    "head_", ",", "derL_", ",", "derR_", ",", "prod_", ",", "dergrade_"}], 
    "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\n", "\t", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Addition", " ", "of", " ", "grades", " ", "in", " ", "algebra"}], " ", 
     "*)"}], "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"head", "/:", 
      RowBox[{"GradeOfDer", "[", 
       RowBox[{"head", ",", "prod"}], "]"}], ":=", "dergrade"}], ";", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"head", "/:", 
      RowBox[{"Grade", "[", 
       RowBox[{
        RowBox[{"derL", "[", 
         RowBox[{"expr_", ",", "___"}], "]"}], ",", "prod"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Grade", "[", 
        RowBox[{"expr", ",", "prod"}], "]"}], "+", 
       RowBox[{"GradeOfDer", "[", 
        RowBox[{"derR", ",", "prod"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     "\t", "\n", "\t", 
     RowBox[{"(*", " ", 
      RowBox[{"The", " ", 
       RowBox[{"(", "graded", ")"}], " ", "Leibniz", " ", "rule"}], " ", 
      "*)"}], "\n", "\t", 
     RowBox[{
      RowBox[{"derL", "[", 
       RowBox[{"expr_prod", ",", "rest___"}], "]"}], ":=", 
      RowBox[{"With", "[", "\n", "\t\t", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"sumgrades", "=", 
          RowBox[{"FoldList", "[", 
           RowBox[{"Plus", ",", "0", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"Grade", "[", 
               RowBox[{"#", ",", "WWedge"}], "]"}], "&"}], "/@", 
             RowBox[{"List", "@@", "expr"}]}]}], "]"}]}], "}"}], ",", "\n", 
        "\t\t", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"GradeOfDer", "[", 
               RowBox[{"derR", ",", "prod"}], "]"}], " ", "*", " ", 
              RowBox[{"sumgrades", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], " ", ")"}]}], 
           RowBox[{"MapAt", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"derR", "[", 
               RowBox[{"#", ",", "rest"}], "]"}], "&"}], ",", "expr", ",", 
             "i"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], "\n", 
       "\t\t", "]"}]}], ";", "\n", "\t", "\[IndentingNewLine]", "\t", 
     RowBox[{"(*", " ", 
      RowBox[{"Chain", " ", "rule"}], " ", "*)"}], "\n", "\t", 
     RowBox[{
      RowBox[{"derL", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"func_", "?", "ScalarFunctionButNotDefinedQ"}], "[", 
         "args__", "]"}], ",", "rest___"}], "]"}], ":=", 
      RowBox[{"xAct`xTensor`Private`multiD", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"derR", "[", 
          RowBox[{"#", ",", "rest"}], "]"}], "&"}], ",", 
        RowBox[{"func", "[", "args", "]"}]}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "This", " ", "works", " ", "for", " ", "functions", " ", "like", " ", 
        SqrtBox["x"], " ", "and", " ", "others", " ", "but", " ", "not", " ", 
        "with", " ", "DefScalarFunctions"}], ",", " ", 
       RowBox[{
       "that", " ", "is", " ", "handled", " ", "better", " ", "with", " ", 
        "ExpandVertDiff", " ", "below"}]}], " ", "*)"}], "\n", "\t", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"(*", " ", "Dependencies", " ", "*)"}], "\[IndentingNewLine]", 
     "\t", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"AtomQ", "[", "derR", "]"}]}], ",", 
       RowBox[{"head", "/:", 
        RowBox[{"DependenciesOfInertHead", "[", "derL", "]"}], ":=", 
        RowBox[{"DependenciesOf", "[", 
         RowBox[{"First", "[", "derR", "]"}], "]"}]}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", ")"}]}]}]], "Code",
 CellChangeTimes->{3.95864853563101*^9},
 CellLabel->
  "In[352]:=",ExpressionUUID->"e4ca74d1-17d7-b947-8ed8-b770425cdf2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Definition vertical exterior derivative (VertDiff)"
}], "Subsection",
 CellChangeTimes->{{3.931835380138414*^9, 3.931835391164802*^9}, {
   3.948391019673935*^9, 3.948391031437001*^9}, {3.948391640357171*^9, 
   3.948391647296105*^9}, 
   3.958648106541069*^9},ExpressionUUID->"659d8d6f-112b-864f-be1c-\
347a5a3f5640"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefGradedDer", "[", 
   RowBox[{"VertDiff", ",", "WWedge", ",", 
    RowBox[{"+", "1"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "$SymbolVerticalExteriorDerivative"}]}], 
   "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDeg", "[", "VertDiff", "]"}], ":=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"VertDiff", ",", "1"}], "]"}], "\n"}], "\n", 
 RowBox[{"VertDiff", "/:", 
  RowBox[{"MakeBoxes", "[", 
   RowBox[{
    RowBox[{"VertDiff", "[", "form_", "]"}], ",", "StandardForm"}], "]"}], ":=", 
  RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
   RowBox[{
    RowBox[{"VertDiff", "[", "form", "]"}], ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PrintAs", "[", "VertDiff", "]"}], ",", "\"\<[\>\"", ",", 
       RowBox[{"MakeBoxes", "[", 
        RowBox[{"form", ",", "StandardForm"}], "]"}], ",", "\"\<]\>\""}], 
      "}"}], "]"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"VertDiff", "[", 
   RowBox[{"expr_", "?", "ArrayQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"VertDiff", "[", "#", "]"}], "&"}], "/@", "expr"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff", "[", "expr_Equal", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"VertDiff", "[", "#", "]"}], "&"}], "/@", "expr"}]}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    SuperscriptBox["\[DifferentialD]", "2"], 
    RowBox[{"=", "0"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff", "[", "expr_VertDiff", "]"}], ":=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDiff", "[", 
     RowBox[{"tensor_", "[", "inds___", "]"}], "]"}], "/;", 
    RowBox[{"VertExactQ", "[", 
     RowBox[{"tensor", "[", "inds", "]"}], "]"}]}], ":=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDiff", "[", 
     RowBox[{"tensor_", "?", "VertExactHeadQ"}], "]"}], ":=", "Zero"}], ";"}],
   "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"\[DifferentialD]", 
     RowBox[{"(", "constant", ")"}]}], "=", "0"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff", "[", 
    RowBox[{"x_", "?", "ConstantQ"}], "]"}], ":=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDiff", "[", "Zero", "]"}], ":=", "Zero"}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Dagger", "@", "\[DifferentialD]"}], "=", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"@", "Dagger"}]}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff", "/:", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"Dagger", "[", 
      RowBox[{"VertDiff", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
    RowBox[{"VertDiff", "[", 
     RowBox[{"Dagger", "[", "expr", "]"}], "]"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"\[DifferentialD]", " ", "commutes"}], " ", "with", " ", "PD"}], 
   " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff", "[", 
    RowBox[{
     RowBox[{"PD", "[", "a_", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"PD", "[", "a", "]"}], "@", 
    RowBox[{"VertDiff", "[", "expr", "]"}]}]}], " ", "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"dl", " ", "commutes", " ", "with", " ", "MultiplyHead"}], " ", 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff", "[", 
    RowBox[{"MultiplyHead", "[", 
     RowBox[{"integer_", ",", "tensor_"}], "]"}], "]"}], ":=", 
   RowBox[{"MultiplyHead", "[", 
    RowBox[{"integer", ",", 
     RowBox[{"VertDiff", "[", "tensor", "]"}]}], "]"}]}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "delta", " ", "does", " ", "not", " ", "depend", " ", "on", " ", "any", " ",
     "field"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff", "[", 
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"-", "a_"}], ",", "b_"}], "]"}], "]"}], ":=", "0"}], " "}], "\n", 
 RowBox[{
  RowBox[{"VertDiff", "[", 
   RowBox[{"Gdelta", "[", "inds___", "]"}], "]"}], ":=", 
  RowBox[{"0", "/;", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"allInds", "=", 
       RowBox[{"{", "inds", "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"EvenQ", "[", 
       RowBox[{"Length", "[", "allInds", "]"}], "]"}], "&&", 
      RowBox[{"AllTrue", "[", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"allInds", ",", 
          RowBox[{
           RowBox[{"Length", "[", "allInds", "]"}], "/", "2"}]}], "]"}], ",", 
        "DownIndexQ"}], "]"}], "&&", 
      RowBox[{"AllTrue", "[", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"allInds", ",", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Length", "[", "allInds", "]"}]}], "/", "2"}]}], "]"}], ",",
         "UpIndexQ"}], "]"}]}]}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff", "[", "delta", "]"}], "[", "inds__", "]"}], ":=", 
  RowBox[{"VertDiff", "[", 
   RowBox[{"delta", "[", "inds", "]"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDiff", "[", "Gdelta", "]"}], "[", "inds__", "]"}], ":=", 
   RowBox[{"VertDiff", "[", 
    RowBox[{"Gdelta", "[", "inds", "]"}], "]"}]}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "produces", " ", "expanded", " ", "expressions", " ", "and", " ",
     "is", " ", "much", " ", "faster", " ", "when", " ", "there", " ", "are", 
    " ", "many", " ", "scalars"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDiff", "[", "expr_Times", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"grades", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Grade", "[", 
            RowBox[{"#", ",", "WWedge"}], "]"}], "&"}], "/@", 
          RowBox[{"List", "@@", "expr"}]}]}], ",", "pos", ",", "scalar", ",", 
        "form"}], "}"}], ",", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"pos", "=", 
        RowBox[{"Position", "[", 
         RowBox[{"grades", ",", 
          RowBox[{"_", "?", "Positive"}], ",", "1", ",", 
          RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"Which", "[", "\[IndentingNewLine]", "\t\t", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "pos", "]"}], ">", "1"}], ",", 
         "\[IndentingNewLine]", "\t\t\t", 
         RowBox[{"Throw", "[", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"VertDiff", "::", "error1"}], 
            ",", "\"\<Found Times product of forms with VertDeg>0. Use WWedge \
instead.\>\"", ",", "expr"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         "\t\t", 
         RowBox[{
          RowBox[{"Length", "[", "pos", "]"}], "===", "1"}], ",", 
         "\[IndentingNewLine]", "\t\t\t", 
         RowBox[{
          RowBox[{"pos", "=", 
           RowBox[{"pos", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\t\t\t", 
          RowBox[{"scalar", "=", 
           RowBox[{"Delete", "[", 
            RowBox[{"expr", ",", 
             RowBox[{"{", "pos", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
           "\t\t\t", 
          RowBox[{"form", "=", 
           RowBox[{"expr", "[", 
            RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\t\t\t", 
          RowBox[{
           RowBox[{"scalar", " ", 
            RowBox[{"VertDiff", "[", "form", "]"}]}], "+", 
           RowBox[{"VertDiff0", "[", 
            RowBox[{"scalar", ",", "form"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", "\t\t", 
         RowBox[{
          RowBox[{"Length", "[", "pos", "]"}], "===", "0"}], ",", 
         "\[IndentingNewLine]", "\t\t\t", 
         RowBox[{"VertDiff0", "[", "expr", "]"}]}], "\[IndentingNewLine]", 
        "\t", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Only", " ", "scalars"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff0", "[", "scalar_Times", "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"MapAt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"VertDiff", "[", "#", "]"}], "&"}], ",", "scalar", ",", "i"}],
       "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "scalar", "]"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDiff0", "[", "scalar_", "]"}], ":=", 
    RowBox[{"VertDiff", "[", "scalar", "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Scalars", " ", "and", " ", "a", " ", "form"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff0", "[", 
    RowBox[{"scalar_Times", ",", "form_"}], "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"MapAt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"VertDiff0", "[", 
         RowBox[{"#", ",", "form"}], "]"}], "&"}], ",", "scalar", ",", "i"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "scalar", "]"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDiff0", "[", 
     RowBox[{"scalar_", ",", "form_"}], "]"}], ":=", 
    RowBox[{"WWedge", "[", 
     RowBox[{
      RowBox[{"VertDiff", "[", "scalar", "]"}], ",", "form"}], "]"}]}], ";"}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "VertDiff", "]"}], ";"}]}], "Code",
 CellChangeTimes->{
  3.931835422093461*^9, {3.9323872009398623`*^9, 3.932387213039808*^9}, 
   3.932522526097593*^9, {3.932616929042975*^9, 3.932616939817093*^9}, {
   3.932653293431164*^9, 3.932653294792463*^9}, 3.932653366656897*^9, {
   3.932717273229444*^9, 3.932717292556115*^9}, {3.932717945994499*^9, 
   3.932717950234897*^9}, {3.932735219830828*^9, 3.932735250099445*^9}, 
   3.9327352871319847`*^9, {3.9327354521076126`*^9, 3.932735454018618*^9}, 
   3.932758026001348*^9, {3.932758086832486*^9, 3.932758094662327*^9}, {
   3.9328241455879087`*^9, 3.9328241459058533`*^9}, {3.933160267070787*^9, 
   3.933160302877418*^9}, {3.933160433585058*^9, 3.933160494618527*^9}, 
   3.933403367850312*^9, {3.933767450446342*^9, 3.933767451706968*^9}, 
   3.948541205829256*^9, {3.948541782704216*^9, 3.948541802725889*^9}, 
   3.948542225606039*^9, {3.948543117441551*^9, 3.9485431369439373`*^9}, {
   3.948543630351748*^9, 3.9485436312937937`*^9}, {3.9489924217256947`*^9, 
   3.948992424941386*^9}, {3.949000318421273*^9, 3.949000324296744*^9}, {
   3.9490652994039507`*^9, 3.949065314867405*^9}, {3.9497670992052326`*^9, 
   3.949767116139223*^9}, {3.950270392789837*^9, 3.950270395886881*^9}, 
   3.950270461070371*^9, {3.9512186643315163`*^9, 3.951218668025707*^9}, {
   3.9512246985911865`*^9, 3.951224698747492*^9}, {3.9514114954589863`*^9, 
   3.9514114958268185`*^9}, 3.9548534782937126`*^9, {3.9573177474208603`*^9, 
   3.957317749315096*^9}, {3.95731936123205*^9, 3.957319385358349*^9}, {
   3.957328301893116*^9, 3.957328316169916*^9}, {3.957328613726013*^9, 
   3.9573286621036167`*^9}, {3.9582177964371796`*^9, 
   3.9582178253734264`*^9}, {3.9583055017881317`*^9, 
   3.9583055074558506`*^9}, {3.9585883799099464`*^9, 
   3.9585883935851707`*^9}, {3.958881612515604*^9, 3.9588816768704376`*^9}},
 CellLabel->
  "In[353]:=",ExpressionUUID->"2483833c-a843-6a40-90bd-cb8181a5c10e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Definition vertical Interior derivative (VertInt)"
}], "Subsection",
 CellChangeTimes->{{3.931835380138414*^9, 3.931835391164802*^9}, {
  3.933063617233096*^9, 3.933063622331755*^9}, {3.933063676978015*^9, 
  3.933063686506387*^9}, {3.948391632649092*^9, 3.948391650596641*^9}, {
  3.9586481092215595`*^9, 
  3.958648111937361*^9}},ExpressionUUID->"a1dd08a0-495e-9e41-a83c-\
6e7ac8dc83db"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefGradedDer", "[", 
    RowBox[{
     RowBox[{"VertInt", "[", "v_", "]"}], ",", "WWedge", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"PrintAs", "->", "$SymbolVertInt"}]}], "]"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"VertDeg", "[", "VertInt", "]"}], ":=", 
  RowBox[{"-", "1"}]}], "\n", 
 RowBox[{
  RowBox[{"VertDeg", "[", 
   RowBox[{
    RowBox[{"VertInt", "[", "v_", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"VertDeg", "[", "expr", "]"}], "-", "1", "+", 
   RowBox[{"VertDeg", "[", "v", "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDeg", "[", 
    RowBox[{"VertInt", "[", "v_", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"VertDeg", "[", "v", "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertInt", "[", "v_", "]"}], "[", 
   RowBox[{"expr_", "?", "ArrayQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertInt", "[", "v", "]"}], "[", "#", "]"}], "&"}], "/@", 
   "expr"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VertInt", "[", "v_", "]"}], "[", "expr_Equal", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertInt", "[", "v", "]"}], "[", "#", "]"}], "&"}], "/@", 
   "expr"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertInt", "[", 
     RowBox[{
      RowBox[{"integer_", "?", "IntegerQ"}], " ", "v_"}], "]"}], "[", "expr_",
     "]"}], ":=", 
   RowBox[{"integer", " ", 
    RowBox[{
     RowBox[{"VertInt", "[", "v", "]"}], "[", "expr", "]"}]}]}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"VertInt", "[", "vvf", "]"}], " ", "vanishes", " ", "over", " ", 
     "zero"}], "-", 
    RowBox[{"VertDeg", " ", "elements"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertInt", "[", "vvf_", "]"}], "[", 
    RowBox[{"tensor_", "?", "ZeroVertDegQ"}], "]"}], " ", ":=", " ", "0"}], 
  "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"VertInt", "[", "vvf1", "]"}], "@", 
    RowBox[{"VertInt", "[", "vvf2", "]"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{
      RowBox[{"VertInt", "[", "vvf_", "]"}], "[", 
      RowBox[{
       RowBox[{"VertInt", "[", "vvf_", "]"}], "[", "_", "]"}], "]"}], "]"}], "/;", 
    RowBox[{"OddQ", "[", 
     RowBox[{"VertDeg", "[", 
      RowBox[{"VertInt", "[", "vvf", "]"}], "]"}], "]"}]}], ":=", "0"}], "\n",
   "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "produces", " ", "expanded", " ", "expressions", " ", "and", " ",
     "is", " ", "much", " ", "faster", " ", "when", " ", "there", " ", "are", 
    " ", "many", " ", "scalars"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertInt", "[", "v_", "]"}], "[", "expr_Times", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"grades", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Grade", "[", 
            RowBox[{"#", ",", "WWedge"}], "]"}], "&"}], "/@", 
          RowBox[{"List", "@@", "expr"}]}]}], ",", "pos", ",", "scalar", ",", 
        "form"}], "}"}], ",", "\n", "\t", 
      RowBox[{
       RowBox[{"pos", "=", 
        RowBox[{"Position", "[", 
         RowBox[{"grades", ",", 
          RowBox[{"_", "?", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "=!=", "0"}], "&"}], ")"}]}], ",", "1", ",", 
          RowBox[{"Heads", "->", "False"}]}], "]"}]}], ";", "\n", "\t", 
       RowBox[{"Which", "[", "\n", "\t\t", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "pos", "]"}], ">", "1"}], ",", "\n", 
         "\t\t\t", 
         RowBox[{"Throw", "[", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"VertInt", "::", "error1"}], 
            ",", "\"\<Found Times product of forms with VertDeg>0. Use WWedge \
instead.\>\"", ",", "expr"}], "]"}], "]"}], ",", "\n", "\t\t", 
         RowBox[{
          RowBox[{"Length", "[", "pos", "]"}], "===", "1"}], ",", "\n", 
         "\t\t\t", 
         RowBox[{
          RowBox[{"pos", "=", 
           RowBox[{"pos", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\n", "\t\t\t", 
          RowBox[{"scalar", "=", 
           RowBox[{"Delete", "[", 
            RowBox[{"expr", ",", 
             RowBox[{"{", "pos", "}"}]}], "]"}]}], ";", "\n", "\t\t\t", 
          RowBox[{"form", "=", 
           RowBox[{"expr", "[", 
            RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\n", "\t\t\t", 
          RowBox[{
           RowBox[{"scalar", " ", 
            RowBox[{
             RowBox[{"VertInt", "[", "v", "]"}], "[", "form", "]"}]}], "+", 
           RowBox[{
            RowBox[{"VertInt0", "[", "v", "]"}], "[", 
            RowBox[{"scalar", ",", "form"}], "]"}]}]}], ",", "\n", "\t\t", 
         RowBox[{
          RowBox[{"Length", "[", "pos", "]"}], "===", "0"}], ",", "\n", 
         "\t\t\t", 
         RowBox[{
          RowBox[{"VertInt0", "[", "v", "]"}], "[", "expr", "]"}]}], "\n", 
        "\t", "]"}]}]}], "\n", "]"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Only", " ", "scalars"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertInt0", "[", "v_", "]"}], "[", "expr_Times", "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"MapAt", "[", 
      RowBox[{
       RowBox[{"VertInt", "[", "v", "]"}], ",", "expr", ",", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertInt0", "[", "v_", "]"}], "[", "expr_", "]"}], ":=", " ", 
    RowBox[{
     RowBox[{"VertInt", "[", "v", "]"}], "[", "expr", "]"}]}], ";"}], "\n", 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Scalars", " ", "and", " ", "a", " ", "form"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertInt0", "[", "v_", "]"}], "[", 
    RowBox[{"expr_Times", ",", "form_"}], "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"MapAt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"VertInt0", "[", "v", "]"}], "[", 
         RowBox[{"#", ",", "form"}], "]"}], "&"}], ",", "expr", ",", "i"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertInt0", "[", "v_", "]"}], "[", 
     RowBox[{"expr_", ",", "form_"}], "]"}], ":=", 
    RowBox[{"WWedge", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"VertInt", "[", "v", "]"}], "[", "expr", "]"}], ",", "form"}], 
     "]"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "makes", " ", "sure", " ", "that", " ", "the", " ", "indices",
     " ", "in", " ", "the", " ", "argument", " ", "are", " ", "alwasys", " ", 
    "screened"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VertInt", "[", 
    RowBox[{"vvf_", " ", "/;", " ", 
     RowBox[{"!", 
      RowBox[{"TrueQ", "[", 
       RowBox[{"vvf", " ", "===", " ", 
        RowBox[{"(", 
         RowBox[{"vvf", " ", "//", " ", "ScreenDollarIndices"}], ")"}]}], 
       "]"}]}]}], "]"}], "[", "expr_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"VertInt", "[", "vvf", "]"}], "[", 
   RowBox[{"expr", "//", " ", "ScreenDollarIndices"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VertInt", "[", 
    RowBox[{"vvf_", " ", "/;", " ", 
     RowBox[{"!", 
      RowBox[{"TrueQ", "[", 
       RowBox[{"vvf", " ", "===", " ", 
        RowBox[{"(", 
         RowBox[{"vvf", " ", "//", " ", "ScreenDollarIndices"}], ")"}]}], 
       "]"}]}]}], "]"}], " ", ":=", " ", 
   RowBox[{"VertInt", "[", 
    RowBox[{"vvf", "//", " ", "ScreenDollarIndices"}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "VertInt", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.931839592681284*^9, 3.931839636255503*^9}, {
   3.9318440065558777`*^9, 3.931844006585657*^9}, {3.931847219888982*^9, 
   3.931847219888982*^9}, {3.9318857513979855`*^9, 3.9318857600843873`*^9}, {
   3.931929985930422*^9, 3.9319299869421883`*^9}, {3.9323948862071905`*^9, 
   3.932394928344292*^9}, {3.932394971321621*^9, 3.9323949726931934`*^9}, {
   3.932395995741394*^9, 3.932396003706586*^9}, {3.932396340826001*^9, 
   3.932396342760623*^9}, {3.932397080831817*^9, 3.93239711352009*^9}, {
   3.9323971693626194`*^9, 3.93239717077242*^9}, {3.93241600602896*^9, 
   3.9324160174497128`*^9}, {3.932419798819072*^9, 3.932419801939115*^9}, {
   3.9330628479551687`*^9, 3.933062895125427*^9}, {3.933062974726667*^9, 
   3.933062975759292*^9}, {3.9330635928681793`*^9, 3.933063593213846*^9}, {
   3.933160511928209*^9, 3.933160513171374*^9}, {3.93318216983384*^9, 
   3.933182180177809*^9}, {3.9331822126741457`*^9, 3.933182212780589*^9}, {
   3.933326150184693*^9, 3.933326158071944*^9}, {3.9334057388174*^9, 
   3.933405739168349*^9}, {3.933405882396958*^9, 3.9334058827702*^9}, {
   3.933754847904489*^9, 3.933754851775992*^9}, {3.933755009091755*^9, 
   3.933755011375725*^9}, {3.933767563435448*^9, 3.9337675644120626`*^9}, {
   3.933789468255148*^9, 3.933789496581523*^9}, {3.933790720397559*^9, 
   3.93379072445692*^9}, {3.937304257062374*^9, 3.937304261267056*^9}, {
   3.938622824382575*^9, 3.93862282536138*^9}, 3.9416290707207437`*^9, {
   3.948541231938052*^9, 3.948541233905221*^9}, {3.948541438419206*^9, 
   3.948541500232432*^9}, 3.948541580412496*^9, {3.948541809548457*^9, 
   3.9485418151701536`*^9}, 3.948542229203647*^9, {3.9485431289778905`*^9, 
   3.948543149850712*^9}, {3.948566328085018*^9, 3.9485663331271987`*^9}, {
   3.948566402644213*^9, 3.948566405092789*^9}, 3.94856759532765*^9, {
   3.948567636844077*^9, 3.948567637025982*^9}, {3.948567759881108*^9, 
   3.948567801067215*^9}, {3.948567868654575*^9, 3.9485679099340734`*^9}, {
   3.948568189416129*^9, 3.948568192939261*^9}, 3.948568303922353*^9, {
   3.948568432099561*^9, 3.9485684326934743`*^9}, {3.948570392087198*^9, 
   3.948570397143179*^9}, 3.948570447262279*^9, {3.948573323824318*^9, 
   3.94857332641951*^9}, {3.948664287656863*^9, 3.948664287879936*^9}, 
   3.948992326250315*^9, {3.948992361793705*^9, 3.948992385628819*^9}, {
   3.9489924285368004`*^9, 3.948992449396315*^9}, {3.948999041994364*^9, 
   3.9489990514548683`*^9}, {3.948999096981122*^9, 3.948999111721954*^9}, 
   3.948999151618478*^9, 3.948999497441592*^9, {3.948999578502329*^9, 
   3.9489995821434116`*^9}, {3.949000331376479*^9, 3.9490003379308233`*^9}, 
   3.949000397954522*^9, {3.949000736960288*^9, 3.949000771453062*^9}, {
   3.9490653396560373`*^9, 3.949065340166253*^9}, {3.9493272040767045`*^9, 
   3.94932729797152*^9}, {3.94932739691348*^9, 3.949327398163304*^9}, {
   3.949327507196997*^9, 3.949327532512401*^9}, {3.949327740801329*^9, 
   3.94932774694664*^9}, {3.949327886617704*^9, 3.9493279220380793`*^9}, {
   3.949329521615523*^9, 3.9493295310570755`*^9}, {3.9493299256385417`*^9, 
   3.949329952241028*^9}, {3.94933000772114*^9, 3.9493300091448417`*^9}, {
   3.949345154539055*^9, 3.949345163837632*^9}, {3.949345939659742*^9, 
   3.9493459424741535`*^9}, {3.9493461063439765`*^9, 3.949346108731721*^9}, {
   3.94949826538586*^9, 3.949498329086849*^9}, 3.9494984462383175`*^9, 
   3.9495032645518246`*^9, {3.9495033419968414`*^9, 3.94950335365638*^9}, {
   3.949516621713713*^9, 3.949516626173464*^9}, {3.949516802322475*^9, 
   3.949516831383316*^9}, {3.949517290897032*^9, 3.94951731908803*^9}, {
   3.949517357752783*^9, 3.949517436871378*^9}, {3.949517627223957*^9, 
   3.9495176282837543`*^9}, {3.949767275028183*^9, 3.9497672841342545`*^9}, {
   3.949775919583254*^9, 3.949775932326481*^9}, {3.949877878625435*^9, 
   3.949877888747404*^9}, {3.950611723616213*^9, 3.9506117435490265`*^9}, {
   3.950611867181036*^9, 3.950611894339151*^9}, {3.951218747485634*^9, 
   3.951218787168028*^9}, 3.951218881277033*^9, {3.951224702719261*^9, 
   3.951224702848554*^9}, {3.9514115011379585`*^9, 3.9514115012988415`*^9}, {
   3.957396081774336*^9, 3.957396099852888*^9}, {3.958127863417742*^9, 
   3.958127865534649*^9}, {3.958129238347563*^9, 3.9581292659232254`*^9}, {
   3.9595077448523655`*^9, 3.95950776822596*^9}, 3.959507826532873*^9},
 CellLabel->
  "In[377]:=",ExpressionUUID->"3842a0a0-2074-864a-8ef0-1dc7ae653cee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Definition vertical Lie derivative (VertLie)"
}], "Subsection",
 CellChangeTimes->{{3.931835380138414*^9, 3.931835391164802*^9}, {
   3.933063617233096*^9, 3.933063633229442*^9}, 3.948391654191436*^9, {
   3.958648115057476*^9, 
   3.9586481160725975`*^9}},ExpressionUUID->"2cf521d5-f53f-af4c-91b9-\
df554293689f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefGradedDer", "[", 
    RowBox[{
     RowBox[{"VertLie", "[", "v_", "]"}], ",", "WWedge", ",", "0", ",", 
     RowBox[{"PrintAs", "->", "$SymbolVertLie"}]}], "]"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDeg", "[", 
    RowBox[{
     RowBox[{"VertLie", "[", "v_", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"VertDeg", "[", "expr", "]"}], "+", 
    RowBox[{"VertDeg", "[", "v", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertDeg", "[", 
     RowBox[{"VertLie", "[", "v_", "]"}], "]"}], ":=", 
    RowBox[{"VertDeg", "[", "v", "]"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "produces", " ", "expanded", " ", "expressions", " ", "and", " ",
     "is", " ", "much", " ", "faster", " ", "when", " ", "there", " ", "are", 
    " ", "many", " ", "scalars"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertLie", "[", "v_", "]"}], "[", "expr_Times", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"grades", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Grade", "[", 
            RowBox[{"#", ",", "WWedge"}], "]"}], "&"}], "/@", 
          RowBox[{"List", "@@", "expr"}]}]}], ",", "pos", ",", "scalar", ",", 
        "form"}], "}"}], ",", "\n", "\t", 
      RowBox[{
       RowBox[{"pos", "=", 
        RowBox[{"Position", "[", 
         RowBox[{"grades", ",", 
          RowBox[{"_", "?", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "=!=", "0"}], "&"}], ")"}]}], ",", "1", ",", 
          RowBox[{"Heads", "->", "False"}]}], "]"}]}], ";", "\n", "\t", 
       RowBox[{"Which", "[", "\n", "\t\t", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "pos", "]"}], ">", "1"}], ",", "\n", 
         "\t\t\t", 
         RowBox[{"Throw", "[", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"VertLie", "::", "error1"}], 
            ",", "\"\<Found Times product of forms with VertDeg>0. Use WWedge \
instead.\>\"", ",", "expr"}], "]"}], "]"}], ",", "\n", "\t\t", 
         RowBox[{
          RowBox[{"Length", "[", "pos", "]"}], "===", "1"}], ",", "\n", 
         "\t\t\t", 
         RowBox[{
          RowBox[{"pos", "=", 
           RowBox[{"pos", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\n", "\t\t\t", 
          RowBox[{"scalar", "=", 
           RowBox[{"Delete", "[", 
            RowBox[{"expr", ",", 
             RowBox[{"{", "pos", "}"}]}], "]"}]}], ";", "\n", "\t\t\t", 
          RowBox[{"form", "=", 
           RowBox[{"expr", "[", 
            RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\n", "\t\t\t", 
          RowBox[{
           RowBox[{"scalar", " ", 
            RowBox[{
             RowBox[{"VertLie", "[", "v", "]"}], "[", "form", "]"}]}], "+", 
           RowBox[{
            RowBox[{"VertLie0", "[", "v", "]"}], "[", 
            RowBox[{"scalar", ",", "form"}], "]"}]}]}], ",", "\n", "\t\t", 
         RowBox[{
          RowBox[{"Length", "[", "pos", "]"}], "===", "0"}], ",", "\n", 
         "\t\t\t", 
         RowBox[{
          RowBox[{"VertLie0", "[", "v", "]"}], "[", "expr", "]"}]}], "\n", 
        "\t", "]"}]}]}], "\n", "]"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Only", " ", "scalars"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertLie0", "[", "v_", "]"}], "[", "expr_Times", "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"MapAt", "[", 
      RowBox[{
       RowBox[{"VertLie", "[", "v", "]"}], ",", "expr", ",", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertLie0", "[", "v_", "]"}], "[", "expr_", "]"}], ":=", " ", 
    RowBox[{
     RowBox[{"VertLie", "[", "v", "]"}], "[", "expr", "]"}]}], ";"}], "\n", 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Scalars", " ", "and", " ", "a", " ", "form"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertLie0", "[", "v_", "]"}], "[", 
    RowBox[{"expr_Times", ",", "form_"}], "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"MapAt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"VertLie0", "[", "v", "]"}], "[", 
         RowBox[{"#", ",", "form"}], "]"}], "&"}], ",", "expr", ",", "i"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertLie0", "[", "v_", "]"}], "[", 
     RowBox[{"expr_", ",", "form_"}], "]"}], ":=", 
    RowBox[{"WWedge", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"VertLie", "[", "v", "]"}], "[", "expr", "]"}], ",", "form"}], 
     "]"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertLie", "[", "v_", "]"}], "[", 
     RowBox[{"expr_", "?", "ConstantQ"}], "]"}], ":=", "0"}], ";"}], "\n", 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "delta", " ", "does", " ", "not", " ", "depend", " ", "on", " ", "any", " ",
     "field"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertLie", "[", "v_", "]"}], "[", 
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"-", "a_"}], ",", "b_"}], "]"}], "]"}], ":=", "0"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertLie", "[", "v_", "]"}], "[", 
   RowBox[{"Gdelta", "[", "inds___", "]"}], "]"}], ":=", 
  RowBox[{"0", "/;", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"allInds", "=", 
       RowBox[{"{", "inds", "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"EvenQ", "[", 
       RowBox[{"Length", "[", "allInds", "]"}], "]"}], "&&", 
      RowBox[{"AllTrue", "[", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"allInds", ",", 
          RowBox[{
           RowBox[{"Length", "[", "allInds", "]"}], "/", "2"}]}], "]"}], ",", 
        "DownIndexQ"}], "]"}], "&&", 
      RowBox[{"AllTrue", "[", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"allInds", ",", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Length", "[", "allInds", "]"}]}], "/", "2"}]}], "]"}], ",",
         "UpIndexQ"}], "]"}]}]}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertLie", "[", 
    RowBox[{
     RowBox[{"c_", "?", "ConstantQ"}], " ", "vvf1_"}], "]"}], "[", "expr_", 
   "]"}], ":=", 
  RowBox[{"c", " ", 
   RowBox[{
    RowBox[{"VertLie", "[", "vvf1", "]"}], "[", "expr", "]"}]}]}]}], "Code",
 CellChangeTimes->{{3.931839592681284*^9, 3.931839636255503*^9}, {
   3.9318440065558777`*^9, 3.931844006585657*^9}, {3.931847219888982*^9, 
   3.931847219888982*^9}, {3.9318857513979855`*^9, 3.9318857600843873`*^9}, {
   3.931929985930422*^9, 3.9319299869421883`*^9}, {3.9323948862071905`*^9, 
   3.932394928344292*^9}, {3.932394971321621*^9, 3.9323949726931934`*^9}, {
   3.932395995741394*^9, 3.932396003706586*^9}, {3.932396340826001*^9, 
   3.932396342760623*^9}, {3.932397080831817*^9, 3.93239711352009*^9}, {
   3.9323971693626194`*^9, 3.93239717077242*^9}, {3.93241600602896*^9, 
   3.9324160174497128`*^9}, {3.932419798819072*^9, 3.932419801939115*^9}, {
   3.9330628479551687`*^9, 3.933062895125427*^9}, {3.933062974726667*^9, 
   3.933062975759292*^9}, {3.9330635928681793`*^9, 3.933063593213846*^9}, {
   3.9330636408492136`*^9, 3.9330636423921*^9}, 3.933074807664212*^9, {
   3.9330750852743073`*^9, 3.9330751123228827`*^9}, {3.9331605186646605`*^9, 
   3.933160524323565*^9}, 3.933181847166265*^9, 3.93340599233657*^9, {
   3.933755081719663*^9, 3.933755088097827*^9}, {3.948541237282398*^9, 
   3.948541239717557*^9}, {3.94854152556768*^9, 3.9485415283676686`*^9}, {
   3.948541615997721*^9, 3.948541616425332*^9}, {3.948541819124253*^9, 
   3.94854183015298*^9}, 3.948542231882347*^9, 3.9485431534986*^9, 
   3.948568198175889*^9, 3.948568987078954*^9, {3.9489923936226087`*^9, 
   3.948992402179495*^9}, 3.9489924366763372`*^9, {3.9490003804692593`*^9, 
   3.949000381568285*^9}, {3.949065392246788*^9, 3.949065392830477*^9}, {
   3.9493274237891135`*^9, 3.9493274296109257`*^9}, {3.94932793231292*^9, 
   3.949327935251448*^9}, {3.949329546856563*^9, 3.949329555492588*^9}, {
   3.949345976025058*^9, 3.949345976627992*^9}, {3.949517609310494*^9, 
   3.949517616126084*^9}, {3.949767295697678*^9, 3.949767340049525*^9}, {
   3.949877537348503*^9, 3.949877588432507*^9}, {3.949877895364435*^9, 
   3.949878072214304*^9}, {3.949878181903847*^9, 3.949878198457346*^9}, {
   3.949878324978489*^9, 3.949878395069292*^9}, {3.9500181557579*^9, 
   3.950018185948574*^9}, {3.950100296186938*^9, 3.9501002977438984`*^9}, {
   3.951218883187679*^9, 3.951218909964697*^9}, {3.951411505183378*^9, 
   3.9514115053543835`*^9}, {3.956351782973612*^9, 3.9563518077489376`*^9}, {
   3.9581278572547665`*^9, 3.95812785788575*^9}},
 CellLabel->
  "In[394]:=",ExpressionUUID->"ee69c30e-0b06-3d46-a29d-9b028527c0c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Definition vertical Lie bracket (VertBracket)"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400376854912*^9, 3.9484004026179485`*^9}, {3.9484004775551186`*^9, 
   3.9484004916331587`*^9}, 3.9491676219251976`*^9, {3.94917039448497*^9, 
   3.9491703947414055`*^9}, {3.9563277286308975`*^9, 3.9563277295097847`*^9}, 
   3.9563381391421623`*^9, {3.956339715490185*^9, 3.956339723280262*^9}, {
   3.9586481236428375`*^9, 3.9586481247115097`*^9}, {3.976319841410263*^9, 
   3.9763198415324497`*^9}},ExpressionUUID->"ebfdde41-22f0-3c49-a7a2-\
b79c4f8158df"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VertDeg", "[", 
    RowBox[{"VertBracket", "[", 
     RowBox[{"vvf1_", ",", "vvf2_"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"VertDeg", "[", "vvf1", "]"}], "+", 
    RowBox[{"VertDeg", "[", "vvf2", "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertBracket", "[", 
     RowBox[{"vvf1_", ",", "vvf2_"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"vvf1", ",", 
          RowBox[{"_", "?", "xTensorQ"}]}], "]"}]}], "&&", 
       RowBox[{"!", 
        RowBox[{"VVFQ", "[", "vvf1", "]"}]}], "&&", 
       RowBox[{"!", 
        RowBox[{"GeneralizedVVFQ", "[", "vvf1", "]"}]}]}], ")"}], "||", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"vvf2", ",", 
          RowBox[{"_", "?", "xTensorQ"}]}], "]"}]}], "&&", 
       RowBox[{"!", 
        RowBox[{"VVFQ", "[", "vvf2", "]"}]}], "&&", 
       RowBox[{"!", 
        RowBox[{"GeneralizedVVFQ", "[", "vvf2", "]"}]}]}], ")"}]}]}], ":=", 
   "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VertBracket", "[", 
   RowBox[{"vvf1_Plus", ",", "vvf2_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"VertBracket", "[", 
     RowBox[{"#", ",", "vvf2"}], "]"}], "&"}], "/@", "vvf1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VertBracket", "[", 
   RowBox[{"vvf1_", ",", "vvf2_Plus"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"VertBracket", "[", 
     RowBox[{"vvf1", ",", "#"}], "]"}], "&"}], "/@", "vvf2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VertBracket", "[", 
   RowBox[{"vvf1_SeriesData", ",", "vvf2_"}], "]"}], ":=", 
  RowBox[{"SeriesDataMap", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"VertBracket", "[", 
      RowBox[{"#", ",", "vvf2"}], "]"}], "&"}], ",", "vvf1"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VertBracket", "[", 
    RowBox[{"vvf1_", ",", "vvf2_SeriesData"}], "]"}], ":=", 
   RowBox[{"SeriesDataMap", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"VertBracket", "[", 
       RowBox[{"vvf1", ",", "#"}], "]"}], "&"}], ",", "vvf2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VertBracket", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c_", "?", "ConstantQ"}], " ", "vvf1_"}], ",", "vvf2_"}], "]"}],
    ":=", 
   RowBox[{"c", " ", 
    RowBox[{"VertBracket", "[", 
     RowBox[{"vvf1", ",", "vvf2"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertBracket", "[", 
     RowBox[{"vvf1_", ",", 
      RowBox[{
       RowBox[{"c_", "?", "ConstantQ"}], " ", "vvf2_"}]}], "]"}], ":=", 
    RowBox[{"c", " ", 
     RowBox[{"VertBracket", "[", 
      RowBox[{"vvf1", ",", "vvf2"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VertBracket", "[", 
   RowBox[{"vvf2_", ",", "vvf1_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{
       RowBox[{"VertDeg", "[", "vvf2", "]"}], 
       RowBox[{"VertDeg", "[", "vvf1", "]"}]}]]}], 
    RowBox[{"VertBracket", "[", 
     RowBox[{"vvf1", ",", "vvf2"}], "]"}]}], "/;", 
   RowBox[{"!", 
    RowBox[{"OrderedQ", "[", 
     RowBox[{"{", 
      RowBox[{"vvf2", ",", "vvf1"}], "}"}], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertBracket", "[", 
     RowBox[{"vvf_", ",", "vvf_"}], "]"}], "/;", 
    RowBox[{"EvenQ", "[", 
     RowBox[{"VertDeg", "[", "vvf", "]"}], "]"}]}], ":=", "0"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VVFQ", "[", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"VertBracket", "[", 
      RowBox[{
       RowBox[{"vvf1_", "?", "VVFQ"}], ",", 
       RowBox[{"vvf2_", "?", "VVFQ"}]}], "]"}], "]"}], "]"}], ":=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VertBracket", "/:", 
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{"VertBracket", "[", 
      RowBox[{"vvf1_", ",", "vvf2_"}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<\[LeftDoubleBracket]\>\"", ",", 
      RowBox[{"xAct`xTensor`Private`boxof", "@", 
       RowBox[{"MakeBoxes", "[", 
        RowBox[{"vvf1", ",", "StandardForm"}], "]"}]}], ",", "\"\<,\>\"", ",", 
      RowBox[{"xAct`xTensor`Private`boxof", "@", 
       RowBox[{"MakeBoxes", "[", 
        RowBox[{"vvf2", ",", "StandardForm"}], "]"}]}], 
      ",", "\"\<\[RightDoubleBracket]\>\""}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"VertBracket", "[", 
     RowBox[{"vvf1__", ",", "vvf2__"}], "]"}], "]"}], "^:=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$WarningFrom", "=", "\"\<Bracket Formatting\>\""}], "}"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\[LeftDoubleBracket]\>\"", ",", 
        RowBox[{"xAct`xTensor`Private`boxof", "@", 
         RowBox[{"MakeBoxes", "[", 
          RowBox[{"vvf1", ",", "StandardForm"}], "]"}]}], ",", "\"\<,\>\"", ",", 
        RowBox[{"xAct`xTensor`Private`boxof", "@", 
         RowBox[{"MakeBoxes", "[", 
          RowBox[{"vvf2", ",", "StandardForm"}], "]"}]}], 
        ",", "\"\<\[RightDoubleBracket]\>\""}], "}"}], "]"}]}], "]"}]}], 
  ";"}]}], "Code",
 CellChangeTimes->{{3.9563277877237854`*^9, 3.956327928698984*^9}, {
   3.9563281111781025`*^9, 3.956328150084814*^9}, {3.9563281832964*^9, 
   3.9563282082366085`*^9}, {3.956328363030905*^9, 3.956328383419157*^9}, {
   3.9563284244115715`*^9, 3.956328441835287*^9}, {3.956328489559288*^9, 
   3.9563285432988777`*^9}, {3.9563286152746143`*^9, 3.956328634133501*^9}, {
   3.9563288793602467`*^9, 3.956328975021414*^9}, {3.956334507365469*^9, 
   3.956334706844513*^9}, {3.9563347388232574`*^9, 3.9563348142209606`*^9}, {
   3.9563348726277637`*^9, 3.956334913426897*^9}, {3.9563360507806797`*^9, 
   3.9563360573629723`*^9}, {3.9563361869987144`*^9, 3.956336199384487*^9}, {
   3.956336273854519*^9, 3.9563363058884144`*^9}, 3.956336475541294*^9, {
   3.9563377282714043`*^9, 3.956337782950197*^9}, {3.9563378233344097`*^9, 
   3.9563378338248024`*^9}, {3.9563379249314804`*^9, 3.956338109130663*^9}, {
   3.956339166766575*^9, 3.9563391705722427`*^9}, {3.9563392625470905`*^9, 
   3.9563393037508774`*^9}, {3.956339557292305*^9, 3.956339603018463*^9}, {
   3.9563445848204536`*^9, 3.956344609852413*^9}, {3.956429746135227*^9, 
   3.9564297580722694`*^9}, {3.9573954644216576`*^9, 
   3.9573954690027847`*^9}, {3.9573956392396584`*^9, 
   3.9573956435430355`*^9}, {3.9573960067343483`*^9, 3.9573960233289146`*^9}},
 CellLabel->
  "In[406]:=",ExpressionUUID->"7caae9bb-88df-0347-bc2d-af1d1a397943"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Vertical operators and CTensors (not fully tested, to be tested for \
future versions)"
}], "Subsection",
 CellChangeTimes->{{3.931835380138414*^9, 3.931835391164802*^9}, {
   3.933063617233096*^9, 3.933063633229442*^9}, 3.948391654191436*^9, {
   3.9549455298833637`*^9, 3.9549455425507317`*^9}, {3.9572762828236675`*^9, 
   3.957276297318613*^9}},ExpressionUUID->"17b24960-ef45-0946-9062-\
7d30b09c8049"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "[", 
    RowBox[{"VertDiff", ",", "VertInt", ",", "VertLie"}], "]"}], ";"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VertDiff", "[", 
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{"array_", ",", "bases_List", ",", "weight_"}], "]"}], "[", 
     "inds__", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"VertDiff", "[", "array", "]"}], ",", "bases", ",", "weight"}], 
     "]"}], "[", "inds", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VertInt", "[", "v_", "]"}], "[", 
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{"array_", ",", "bases_List", ",", "weight_"}], "]"}], "[", 
     "inds__", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"VertInt", "[", "v", "]"}], "[", "array", "]"}], ",", "bases", 
      ",", "weight"}], "]"}], "[", "inds", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertLie", "[", "v_", "]"}], "[", 
     RowBox[{
      RowBox[{"CTensor", "[", 
       RowBox[{"array_", ",", "bases_List", ",", "weight_"}], "]"}], "[", 
      "inds__", "]"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"VertLie", "[", "v", "]"}], "[", "array", "]"}], ",", "bases",
        ",", "weight"}], "]"}], "[", "inds", "]"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"VertDiff", ",", "VertInt", ",", "VertLie", ",", "VertBracket"}], 
   "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.95494544981695*^9, 3.954945475638567*^9}, {
   3.954945696479248*^9, 3.9549457118704987`*^9}, {3.9549462937319965`*^9, 
   3.9549463258572006`*^9}, 3.957276301058668*^9, {3.9573959102736435`*^9, 
   3.9573959121570415`*^9}},
 CellLabel->
  "In[419]:=",ExpressionUUID->"5191e051-84b7-8a49-aaa0-2c55f40441b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Relations between vertical operators"
}], "Subsection",
 CellChangeTimes->{{3.931835380138414*^9, 3.931835391164802*^9}, {
  3.933063617233096*^9, 3.933063622331755*^9}, {3.933063676978015*^9, 
  3.933063686506387*^9}, {3.948391632649092*^9, 3.948391650596641*^9}, {
  3.954853712530472*^9, 
  3.954853718108185*^9}},ExpressionUUID->"9620da7d-2ca8-394d-bef3-\
000229f018a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Cartan", " ", 
    RowBox[{"identity", ":"}]}], "*)"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Careful", ":", " ", 
     RowBox[{"Not", " ", "always", " ", 
      RowBox[{"true", ".", " ", "As"}], " ", "far", " ", "as", " ", "I", " ", 
      "know"}]}], ",", " ", 
    RowBox[{
    "there", " ", "is", " ", "no", " ", "way", " ", "to", " ", "check", " ", 
     "within", " ", "xAct"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"VertCartanMagicFormula", "[", "expr_", "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{
         RowBox[{"VertLie", "[", "vvf_", "]"}], "[", "expr1_", "]"}], "]"}], "/;", 
       RowBox[{
        RowBox[{"Length", "@", 
         RowBox[{"FindAllOfType", "[", 
          RowBox[{"expr1", ",", "VariationalVector"}], "]"}]}], "==", "0"}]}],
       ":>", 
      RowBox[{
       RowBox[{"VertDiff", "@", 
        RowBox[{
         RowBox[{"VertInt", "[", "vvf", "]"}], "@", "expr1"}]}], "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"VertDeg", "[", "VertDiff", "]"}], 
          RowBox[{"VertDeg", "[", 
           RowBox[{"VertInt", "[", "vvf", "]"}], "]"}]}]], 
        RowBox[{
         RowBox[{"VertInt", "[", "vvf", "]"}], "@", 
         RowBox[{"VertDiff", "@", "expr1"}]}]}]}]}], "}"}]}]}]}]], "Code",
 CellChangeTimes->{{3.950111811388016*^9, 3.950111879104943*^9}, {
   3.9503666722526474`*^9, 3.9503666793009357`*^9}, {3.9512189048906727`*^9, 
   3.9512189084994793`*^9}, {3.951224707192496*^9, 3.9512247073630905`*^9}, {
   3.9521914910333233`*^9, 3.952191753824337*^9}, {3.9521918515938015`*^9, 
   3.9521919873995323`*^9}, {3.9521921164566097`*^9, 3.952192117787529*^9}, {
   3.9521921510047665`*^9, 3.952192179570879*^9}, {3.9521925706702633`*^9, 
   3.9521926146331196`*^9}, {3.952192944051985*^9, 3.9521929481219826`*^9}, 
   3.9563435340529194`*^9, {3.956349523262886*^9, 3.956349548323284*^9}, {
   3.9564870719001637`*^9, 3.956487092364891*^9}},
 CellLabel->
  "In[424]:=",ExpressionUUID->"1bdb77d7-7f81-0b4b-8d2c-ff41c96a8c47"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "I", " ", "am", " ", "unsure", " ", "of", " ", "this", " ", "kind", " ", 
     "of", " ", "notation"}], ",", " ", 
    RowBox[{
    "but", " ", "I", " ", "think", " ", "that", " ", "this", " ", "is", " ", 
     "what", " ", "people", " ", "mean"}]}], " ", "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{"VertBracketToVertLie", "[", "expr_", "]"}], ":=", " ", 
   RowBox[{"expr", "//.", "\n", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"VertBracket", "[", 
        RowBox[{
         RowBox[{"vvf1_", "?", "VVFQ"}], ",", 
         RowBox[{"vvf2_", "?", "VVFQ"}]}], "]"}], "/;", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"vvf1", ",", "Plus"}], "]"}], "&&", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"vvf2", ",", "Plus"}], "]"}]}]}], ":>", "\n", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"info1", "=", 
           RowBox[{
            RowBox[{"CoefficientsOfVVF", "[", 
             RowBox[{"ReplaceDummies", "[", "vvf1", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"info2", "=", 
           RowBox[{
            RowBox[{"CoefficientsOfVVF", "[", 
             RowBox[{"ReplaceDummies", "[", "vvf2", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"VertLie", "[", "vvf1", "]"}], "[", 
           RowBox[{"info2", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "~", "WWedge", "~", 
          RowBox[{"info2", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{
            RowBox[{"VertDeg", "@", "vvf1"}], " ", 
            RowBox[{"VertDeg", "@", "vvf2"}]}]], 
          RowBox[{
           RowBox[{
            RowBox[{"VertLie", "[", "vvf2", "]"}], "[", 
            RowBox[{"info1", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}], "~", "WWedge", "~", 
           RowBox[{"info1", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}]}]}], "]"}]}], 
     "}"}]}]}]}]], "Code",
 CellChangeTimes->{{3.956338116009598*^9, 3.956338131133877*^9}, 
   3.9563389097263927`*^9, {3.95642891550062*^9, 3.956428918724581*^9}, {
   3.956429890687044*^9, 3.956429928670931*^9}, {3.95642997224498*^9, 
   3.9564300051712856`*^9}, {3.957276985665783*^9, 3.9572769866836166`*^9}},
 CellLabel->
  "In[425]:=",ExpressionUUID->"43ccb982-3ed4-1847-a4aa-30d6774504e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Based", " ", "on", " ", "the", " ", "xTerior", " ", "package"}], 
   " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Careful", ":", " ", 
     RowBox[{"These", " ", "rules", " ", "are", " ", "not", " ", "always", " ", 
      RowBox[{"true", ".", " ", "As"}], " ", "far", " ", "as", " ", "I", " ", 
      "know"}]}], ",", " ", 
    RowBox[{
    "there", " ", "is", " ", "no", " ", "way", " ", "to", " ", "check", " ", 
     "it", " ", "within", " ", "xAct"}]}], " ", "*)"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperatorsRule", "[", 
      RowBox[{"VertDiff", ",", "VertDiff"}], "]"}], "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperatorsRule", "[", 
      RowBox[{"VertInt", ",", "VertInt"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{
          RowBox[{"VertInt", "[", "vvf2_", "]"}], "@", 
          RowBox[{
           RowBox[{"VertInt", "[", "vvf1_", "]"}], "@", "expr_"}]}], "]"}], "/;", 
        RowBox[{"!", 
         RowBox[{"OrderedQ", "[", 
          RowBox[{"{", 
           RowBox[{"vvf2", ",", "vvf1"}], "}"}], "]"}]}]}], "\[RuleDelayed]", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"VertDeg", "[", 
           RowBox[{"VertInt", "[", "vvf2", "]"}], "]"}], 
          RowBox[{"VertDeg", "[", 
           RowBox[{"VertInt", "[", "vvf1", "]"}], "]"}]}]], 
        RowBox[{
         RowBox[{"VertInt", "[", "vvf1", "]"}], "@", 
         RowBox[{
          RowBox[{"VertInt", "[", "vvf2", "]"}], "@", "expr"}]}]}]}], "}"}]}],
     ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperatorsRule", "[", 
      RowBox[{"VertLie", ",", "VertLie"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{
          RowBox[{"VertLie", "[", "vvf2_", "]"}], "@", 
          RowBox[{
           RowBox[{"VertLie", "[", "vvf1_", "]"}], "@", "expr_"}]}], "]"}], "/;", 
        RowBox[{"!", 
         RowBox[{"OrderedQ", "[", 
          RowBox[{"{", 
           RowBox[{"vvf2", ",", "vvf1"}], "}"}], "]"}]}]}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{
         RowBox[{"VertLie", "[", "vvf1", "]"}], "@", 
         RowBox[{
          RowBox[{"VertLie", "[", "vvf2", "]"}], "@", "expr"}]}], "-", 
        RowBox[{
         RowBox[{"VertLie", "[", 
          RowBox[{"VertBracket", "[", 
           RowBox[{"vvf1", ",", "vvf2"}], "]"}], "]"}], "@", "expr"}]}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperatorsRule", "[", 
      RowBox[{"VertInt", ",", "VertDiff"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{"VertDiff", "@", 
         RowBox[{
          RowBox[{"VertInt", "[", "vvf_", "]"}], "@", "expr_"}]}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{
         RowBox[{"VertLie", "[", "vvf", "]"}], "@", "expr"}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{
           RowBox[{"VertDeg", "[", "VertDiff", "]"}], 
           RowBox[{"VertDeg", "[", 
            RowBox[{"VertInt", "[", "vvf", "]"}], "]"}]}]], 
         RowBox[{
          RowBox[{"VertInt", "[", "vvf", "]"}], "@", 
          RowBox[{"VertDiff", "[", "expr", "]"}]}]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperatorsRule", "[", 
      RowBox[{"VertDiff", ",", "VertInt"}], "]"}], "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{
          RowBox[{"VertInt", "[", "vvf_", "]"}], "@", 
          RowBox[{"VertDiff", "[", "expr_", "]"}]}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{
            RowBox[{"VertDeg", "[", "VertDiff", "]"}], 
            RowBox[{"VertDeg", "[", 
             RowBox[{"VertInt", "[", "vvf", "]"}], "]"}]}]]}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"VertLie", "[", "vvf", "]"}], "@", "expr"}], "-", 
           RowBox[{"VertDiff", "@", 
            RowBox[{
             RowBox[{"VertInt", "[", "vvf", "]"}], "@", "expr"}]}]}], 
          ")"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{
          RowBox[{"VertInt", "[", "vvf_", "]"}], "[", 
          RowBox[{
           RowBox[{"dltensor_", "?", "VertExactHeadQ"}], "[", "inds___", 
           "]"}], "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{
            RowBox[{"VertDeg", "[", "VertDiff", "]"}], 
            RowBox[{"VertDeg", "[", 
             RowBox[{"VertInt", "[", "vvf", "]"}], "]"}]}]]}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"VertLie", "[", "vvf", "]"}], "[", 
            RowBox[{
             RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}], "[", "inds",
              "]"}], "]"}], "-", 
           RowBox[{"VertDiff", "[", 
            RowBox[{
             RowBox[{"VertInt", "[", "vvf", "]"}], "[", 
             RowBox[{
              RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}], "[", 
              "inds", "]"}], "]"}], "]"}]}], ")"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperatorsRule", "[", 
      RowBox[{"VertLie", ",", "VertDiff"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{"VertDiff", "@", 
         RowBox[{
          RowBox[{"VertLie", "[", "vvf_", "]"}], "@", "expr_"}]}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"VertDeg", "[", "VertDiff", "]"}], 
          RowBox[{"VertDeg", "[", 
           RowBox[{"VertLie", "[", "vvf", "]"}], "]"}]}]], 
        RowBox[{
         RowBox[{"VertLie", "[", "vvf", "]"}], "@", 
         RowBox[{"VertDiff", "@", "expr"}]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperatorsRule", "[", 
      RowBox[{"VertDiff", ",", "VertLie"}], "]"}], "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{
          RowBox[{"VertLie", "[", "v_", "]"}], "@", 
          RowBox[{"VertDiff", "[", "expr_", "]"}]}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{
           RowBox[{"VertDeg", "[", "VertDiff", "]"}], 
           RowBox[{"VertDeg", "[", 
            RowBox[{"VertLie", "[", "vvf", "]"}], "]"}]}]], 
         RowBox[{"VertDiff", "@", 
          RowBox[{
           RowBox[{"VertLie", "[", "v", "]"}], "@", "expr"}]}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{
          RowBox[{"VertLie", "[", "vvf_", "]"}], "[", 
          RowBox[{
           RowBox[{"dltensor_", "?", "VertExactHeadQ"}], "[", "inds___", 
           "]"}], "]"}], "]"}], ":>", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{
           RowBox[{"VertDeg", "[", "VertDiff", "]"}], 
           RowBox[{"VertDeg", "[", 
            RowBox[{"VertLie", "[", "vvf", "]"}], "]"}]}]], 
         RowBox[{"VertDiff", "[", 
          RowBox[{
           RowBox[{"VertLie", "[", "vvf", "]"}], "[", 
           RowBox[{
            RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}], "[", "inds", 
            "]"}], "]"}], "]"}]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperatorsRule", "[", 
      RowBox[{"VertInt", ",", "VertLie"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{
         RowBox[{"VertLie", "[", "vvf1_", "]"}], "@", 
         RowBox[{
          RowBox[{"VertInt", "[", "vvf2_", "]"}], "@", "expr_"}]}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{
         RowBox[{"VertInt", "[", "vvf2", "]"}], "@", 
         RowBox[{
          RowBox[{"VertLie", "[", "vvf1", "]"}], "@", "expr"}]}], "+", 
        RowBox[{
         RowBox[{"VertInt", "[", 
          RowBox[{"VertBracket", "[", 
           RowBox[{"vvf1", ",", "vvf2"}], "]"}], "]"}], "@", "expr"}]}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperatorsRule", "[", 
      RowBox[{"VertLie", ",", "VertInt"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{
         RowBox[{"VertInt", "[", "vvf1_", "]"}], "@", 
         RowBox[{
          RowBox[{"VertLie", "[", "vvf2_", "]"}], "@", "expr_"}]}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{
         RowBox[{"VertLie", "[", "vvf2", "]"}], "@", 
         RowBox[{
          RowBox[{"VertInt", "[", "vvf1", "]"}], "@", "expr"}]}], "+", 
        RowBox[{
         RowBox[{"VertInt", "[", 
          RowBox[{"VertBracket", "[", 
           RowBox[{"vvf1", ",", "vvf2"}], "]"}], "]"}], "@", "expr"}]}]}], 
      "}"}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956339984399208*^9, 3.956339988643549*^9}, {
   3.956341240006691*^9, 3.9563413582063255`*^9}, {3.9563435344836903`*^9, 
   3.956343535507946*^9}, {3.956344064065382*^9, 3.956344114897169*^9}, {
   3.9563455103385735`*^9, 3.95634551233543*^9}, {3.956347973532995*^9, 
   3.9563479980089436`*^9}, {3.9563480339053783`*^9, 3.9563480423286514`*^9}, 
   3.9563482033301945`*^9, {3.9563486340871925`*^9, 3.956348670368723*^9}, {
   3.956348771021879*^9, 3.956348773751459*^9}, {3.956349576601713*^9, 
   3.956349581302229*^9}, {3.956351734143963*^9, 3.956351735165392*^9}, {
   3.9563518498235474`*^9, 3.9563518506261997`*^9}, {3.95727700039114*^9, 
   3.9572770015362415`*^9}, {3.957396029716385*^9, 3.957396039214882*^9}, 
   3.957396229017702*^9, {3.958129272753603*^9, 3.958129273284149*^9}, {
   3.958130079804985*^9, 3.958130104996729*^9}, 3.9581319680954456`*^9},
 CellLabel->
  "In[426]:=",ExpressionUUID->"92fe7130-8d38-5c4c-be5e-2baa3457d2f9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SortVertOperators", "[", "]"}], "[", "expr_", "]"}], ":=", 
  RowBox[{
   RowBox[{"SortVertOperators", "[", "$SortVertOperatorsOrder", "]"}], "[", 
   "expr", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SortVertOperators", "[", "orderlist_List", "]"}], "[", "expr_", 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"order", "=", 
        RowBox[{"Join", "[", 
         RowBox[{"orderlist", ",", 
          RowBox[{"Complement", "[", 
           RowBox[{"$VerticalOperators", ",", "orderlist"}], "]"}]}], "]"}]}],
        "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Make", " ", "sure", " ", "that", " ", "order", " ", "is", " ", "some",
         " ", "permutation", " ", "of", " ", "$VerticalOperators"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Sort", "@", "order"}], "=!=", 
          RowBox[{"Sort", "@", "$VerticalOperators"}]}], ",", 
         RowBox[{
          RowBox[{"Throw", "@", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"SortVertOperators", "::", "invalid"}], 
             ",", "\"\<order\>\"", ",", "order"}], "]"}]}], ";"}]}], "]"}], ";",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"expr", "//.", 
         RowBox[{"Join", "@@", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Join", "@@", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"SortVertOperatorsRule", "[", 
                 RowBox[{
                  RowBox[{"order", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
               RowBox[{"Drop", "[", 
                RowBox[{"order", ",", "i"}], "]"}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", 
              RowBox[{
               RowBox[{"Length", "@", "order"}], "-", "1"}]}], "}"}]}], 
           "]"}]}]}], "//.", 
        RowBox[{"Join", "@@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"SortVertOperatorsRule", "[", 
             RowBox[{"#", ",", "#"}], "]"}], "&"}], "/@", "order"}], 
          ")"}]}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", 
    RowBox[{
    "SortVertOperators", ",", "VertBracketToVertLie", ",", 
     "VertCartanMagicFormula"}], "]"}], ";"}], " "}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.95634499724889*^9, 3.95634501113307*^9}, {
   3.956345134277994*^9, 3.9563451458392315`*^9}, {3.9563454678082237`*^9, 
   3.956345480910431*^9}, {3.9563467003018284`*^9, 3.956346708364233*^9}, {
   3.9563467448521595`*^9, 3.956346762504408*^9}, {3.9563468678966255`*^9, 
   3.9563468728587017`*^9}, {3.956347038812706*^9, 3.956347047084423*^9}, 
   3.956347088671364*^9, 3.9563493772754993`*^9, {3.9563495522489395`*^9, 
   3.956349564107483*^9}},
 CellLabel->
  "In[435]:=",ExpressionUUID->"ec1407f2-9ff3-794e-b8f7-809600ecedba"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Auxiliary functions"
}], "Section",
 CellChangeTimes->{{3.94839178561905*^9, 
  3.9483917905739202`*^9}},ExpressionUUID->"d37deb55-c3a2-3247-aa2d-\
fe0001566142"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". SetSigns"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, 3.954518473034981*^9, 
   3.9576431237058163`*^9},ExpressionUUID->"dfc6bd3a-ac8c-e342-b071-\
bc2a5e649674"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"symbolNames", "=", 
   RowBox[{"Replace", "[", 
    RowBox[{
     RowBox[{"First", "@", 
      RowBox[{"OwnValues", "[", "$ConstantSymbols", "]"}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"_", ":>", "list_"}], "]"}], ":>", 
      RowBox[{"Map", "[", 
       RowBox[{"HoldForm", ",", 
        RowBox[{"Unevaluated", "[", "list", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stringNames", "=", 
   RowBox[{"StringDrop", "[", 
    RowBox[{
     RowBox[{"StringDrop", "[", 
      RowBox[{
       RowBox[{"StringReplace", "[", 
        RowBox[{
         RowBox[{"ToString", "[", 
          RowBox[{"symbolNames", ",", "InputForm"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\< $\>\"", "->", "\"\<$\>\""}], ",", 
           RowBox[{"\"\<, \>\"", "->", "\"\<,\>\""}], ",", 
           RowBox[{"\"\<HoldForm[\>\"", "->", "\"\<\>\""}], ",", 
           RowBox[{"\"\<],\>\"", "->", "\"\<,\>\""}]}], "}"}]}], "]"}], ",", 
       RowBox[{"-", "2"}]}], "]"}], ",", "1"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"$NamesOfSigns", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"StringSplit", "[", 
      RowBox[{"stringNames", ",", "\"\<, \>\""}], "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{
        RowBox[{"StringTrim", "[", "s", "]"}], ",", "\"\<$*Sign\>\""}], 
       "]"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"$ValuesOfSigns", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"ToExpression", "[", 
       RowBox[{"#", ",", "InputForm"}], "]"}], "&"}], "/@", 
     "$NamesOfSigns"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SetSigns", "[", "x_", "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\n", "\t", 
      RowBox[{
       RowBox[{"Which", "[", "\n", "\t\t", 
        RowBox[{
         RowBox[{"x", "===", "1"}], ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"SetDelayed", "[", 
              RowBox[{"#", ",", "1"}], "]"}], "&"}], "/@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"ToExpression", "[", 
                RowBox[{"#", ",", "InputForm", ",", "Unevaluated"}], "]"}], 
               "&"}], "/@", "$NamesOfSigns"}], ")"}]}], ";", 
           RowBox[{"If", "[", 
            RowBox[{"$DefInfoQ", ",", 
             RowBox[{
             "Print", "[", "\"\<** SetSigns: All constant signs set to 1.\>\"",
               "]"}]}], "]"}], ";"}], ")"}], ",", "\n", "\t\t", 
         RowBox[{"x", "===", 
          RowBox[{"-", "1"}]}], ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"SetDelayed", "[", 
              RowBox[{"#", ",", 
               RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"ToExpression", "[", 
                RowBox[{"#", ",", "InputForm", ",", "Unevaluated"}], "]"}], 
               "&"}], "/@", "$NamesOfSigns"}], ")"}]}], ";", 
           RowBox[{"If", "[", 
            RowBox[{"$DefInfoQ", ",", 
             RowBox[{
             "Print", 
              "[", "\"\<** SetSigns: All constant signs set to -1.\>\"", 
              "]"}]}], "]"}], ";"}], ")"}], ",", "\n", "\t\t", 
         RowBox[{"x", "===", "0"}], ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Unset", "/@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"ToExpression", "[", 
                RowBox[{"#", ",", "InputForm", ",", "Unevaluated"}], "]"}], 
               "&"}], "/@", "$NamesOfSigns"}], ")"}]}], ";", 
           RowBox[{"If", "[", 
            RowBox[{"$DefInfoQ", ",", 
             RowBox[{
             "Print", "[", "\"\<** SetSigns: All constant signs unset.\>\"", 
              "]"}]}], "]"}], ";"}], ")"}], ",", "\n", "\t\t", 
         RowBox[{"!", 
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "x"}], "]"}]}], ",", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"SetSigns", "::", "invalid"}], ",", "x", 
            ",", "\"\<argument. SetSigns only accepts 1/0/-1 argument\>\""}], 
           "]"}]}]}], "\n", "\t", "]"}], ";"}]}], "\n", "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"SetSigns", ",", "$NamesOfSigns", ",", "$ValuesOfSigns"}], "]"}], 
  ";"}]}], "Code",
 CellChangeTimes->{{3.951854003212641*^9, 3.9518540434222755`*^9}, {
   3.951854407607256*^9, 3.9518544079962215`*^9}, {3.9518551744015636`*^9, 
   3.951855177039274*^9}, {3.951859586036133*^9, 3.951859632133009*^9}, {
   3.9518596966046066`*^9, 3.9518597076485767`*^9}, {3.9518597598444824`*^9, 
   3.9518597695737*^9}, 3.951859961301525*^9, {3.9518603956265736`*^9, 
   3.9518604139354076`*^9}, 3.951861965341223*^9, {3.9518620140270042`*^9, 
   3.9518620301785126`*^9}, {3.951927177125393*^9, 3.9519271775865383`*^9}, {
   3.9533923475199413`*^9, 3.953392350742031*^9}, {3.954514663631027*^9, 
   3.954514780682354*^9}, {3.954515029837227*^9, 3.954515038381651*^9}, {
   3.954515099403469*^9, 3.954515237867693*^9}, {3.9545152790787067`*^9, 
   3.9545153929500313`*^9}, {3.954518664560684*^9, 3.954518675077835*^9}, 
   3.954518787814556*^9, {3.9545189922401695`*^9, 3.9545190580784435`*^9}, 
   3.9545191248047104`*^9, 3.9545194993934727`*^9, {3.954519578695154*^9, 
   3.954519590017864*^9}, {3.954853388785324*^9, 3.954853422872299*^9}, {
   3.9553900226222153`*^9, 3.955390032818432*^9}, {3.955825669217203*^9, 
   3.955825707736597*^9}, {3.9558259489776764`*^9, 3.9558259833486404`*^9}, {
   3.955826034680666*^9, 3.9558260352704487`*^9}, {3.957210538327921*^9, 
   3.9572105387657833`*^9}, {3.957210599213686*^9, 3.957210619171444*^9}, {
   3.957210650072872*^9, 3.9572106643199406`*^9}, {3.957210858870617*^9, 
   3.957210870830406*^9}, {3.957283659429611*^9, 3.957283688299864*^9}, {
   3.957283792682888*^9, 3.957283830679743*^9}, {3.957283876189108*^9, 
   3.957283967843975*^9}, {3.9572840820087967`*^9, 3.957284088690916*^9}, 
   3.957284228107399*^9, {3.9572851491517353`*^9, 3.957285150036787*^9}, {
   3.957285293221794*^9, 3.9572852994925156`*^9}, {3.957285746785385*^9, 
   3.9572857510310497`*^9}, {3.9572857923832455`*^9, 3.95728579591255*^9}, {
   3.957285835972601*^9, 3.957285839690027*^9}, {3.957286267953991*^9, 
   3.9572862987507343`*^9}, {3.9573289889415417`*^9, 
   3.9573290002922554`*^9}, {3.9573290768498135`*^9, 3.957329082465246*^9}, {
   3.9573291242642975`*^9, 3.9573291778569336`*^9}, {3.9573659025913258`*^9, 
   3.9573659364524174`*^9}, {3.957365978753662*^9, 3.957366008409603*^9}, {
   3.957550692267645*^9, 3.957550765260252*^9}, {3.9576163994195023`*^9, 
   3.9576164571579895`*^9}, {3.957616684801613*^9, 3.9576166927578583`*^9}, 
   3.9576167737853184`*^9, {3.9576175055838966`*^9, 3.95761754768182*^9}, {
   3.9576177185036793`*^9, 3.9576177295528355`*^9}, {3.957618533688711*^9, 
   3.957618545304554*^9}, {3.9576198643264446`*^9, 3.9576198894467983`*^9}, {
   3.9576199253614655`*^9, 3.95761992717198*^9}, {3.957620113245037*^9, 
   3.957620129730549*^9}, {3.957620189586172*^9, 3.957620243775957*^9}, {
   3.9576206171968117`*^9, 3.957620652227627*^9}, {3.9576236363755226`*^9, 
   3.9576237119564095`*^9}, {3.95762390264822*^9, 3.9576239877379646`*^9}, {
   3.957624225853876*^9, 3.957624259922886*^9}, {3.9576243765355377`*^9, 
   3.957624570388653*^9}, {3.957624623795847*^9, 3.95762463339822*^9}, {
   3.9576371057663193`*^9, 3.957637120244116*^9}, {3.9576374803557663`*^9, 
   3.9576375236722393`*^9}, {3.957637607099476*^9, 3.957637644496464*^9}, {
   3.9576377071747684`*^9, 3.957637772505228*^9}, {3.957637921442976*^9, 
   3.957637940920351*^9}, {3.9576379824842415`*^9, 3.957638055730839*^9}, {
   3.9576382903494816`*^9, 3.957638400221113*^9}, {3.957638435016144*^9, 
   3.9576385057094345`*^9}, {3.9576385757739544`*^9, 
   3.9576386046210403`*^9}, {3.9576386718068485`*^9, 
   3.9576386778279877`*^9}, {3.957638757377819*^9, 3.957638813230255*^9}, {
   3.9576388966985207`*^9, 3.957638897633974*^9}, {3.9576389800419254`*^9, 
   3.9576391093289375`*^9}, {3.9576391409938717`*^9, 3.957639141165228*^9}, 
   3.9576391952535515`*^9, {3.9576392421474457`*^9, 3.957639282402893*^9}, {
   3.9576393170737743`*^9, 3.957639317620102*^9}, {3.9576393645753384`*^9, 
   3.9576394054811497`*^9}, {3.9576394936542244`*^9, 
   3.9576394980152874`*^9}, {3.9576395364080105`*^9, 3.957639544452091*^9}, {
   3.9576396330006676`*^9, 3.9576396365370197`*^9}, {3.957639908400532*^9, 
   3.957639923052698*^9}, {3.957639987130089*^9, 3.9576399908374443`*^9}, {
   3.957640309433031*^9, 3.957640324947342*^9}, {3.957640669003748*^9, 
   3.9576406818869705`*^9}, {3.957641150694168*^9, 3.9576411654226665`*^9}, {
   3.9576412054209175`*^9, 3.95764125922093*^9}, {3.9576413907079277`*^9, 
   3.957641391346613*^9}, {3.957641613804249*^9, 3.957641678867239*^9}, {
   3.9576418410595837`*^9, 3.957641857546503*^9}, {3.9576421471430187`*^9, 
   3.957642184397539*^9}, {3.9576424369277554`*^9, 3.957642437951603*^9}, {
   3.957642532383749*^9, 3.9576425724051647`*^9}, {3.9576426431213894`*^9, 
   3.9576426575289135`*^9}, {3.957643082226591*^9, 3.957643108553608*^9}, {
   3.9576431394568577`*^9, 3.957643141123968*^9}, {3.957644279771414*^9, 
   3.957644300593624*^9}, {3.9576444538630714`*^9, 3.957644468172943*^9}, {
   3.957644577152691*^9, 3.9576445925144176`*^9}, {3.9576458075891914`*^9, 
   3.9576458085489483`*^9}, {3.9588728827827396`*^9, 
   3.9588729429855804`*^9}, {3.9588729810519733`*^9, 3.958872981303831*^9}},
 CellLabel->
  "In[438]:=",ExpressionUUID->"c09d02da-8b48-4745-8642-7ebf30658a8d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". UnDefConstantsExceptSigns"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, 3.954518473034981*^9, {
   3.9576431237058163`*^9, 
   3.957643148617237*^9}},ExpressionUUID->"1e13f2fc-1870-7e42-9cdd-\
6ae6d4381bc5"],

Cell[BoxData[
 RowBox[{"UnDefConstantsExceptSigns", ":=", 
  RowBox[{"Catch", "@", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "symbolNames", ",", "stringNames", ",", "ListOfOtherConstants"}], "}"}],
      ",", "\n", "\t", 
     RowBox[{
      RowBox[{"symbolNames", "=", 
       RowBox[{"Replace", "[", 
        RowBox[{
         RowBox[{"First", "@", 
          RowBox[{"OwnValues", "[", "$ConstantSymbols", "]"}]}], ",", 
         RowBox[{
          RowBox[{"HoldPattern", "[", 
           RowBox[{"_", ":>", "list_"}], "]"}], ":>", 
          RowBox[{"Map", "[", 
           RowBox[{"HoldForm", ",", 
            RowBox[{"Unevaluated", "[", "list", "]"}]}], "]"}]}]}], "]"}]}], ";",
       "\[IndentingNewLine]", "\t", 
      RowBox[{"stringNames", "=", 
       RowBox[{"StringSplit", "[", 
        RowBox[{
         RowBox[{"StringDrop", "[", 
          RowBox[{
           RowBox[{"StringDrop", "[", 
            RowBox[{
             RowBox[{"StringReplace", "[", 
              RowBox[{
               RowBox[{"ToString", "[", 
                RowBox[{"symbolNames", ",", "InputForm"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\"\< $\>\"", "->", "\"\<$\>\""}], ",", 
                 RowBox[{"\"\<, \>\"", "->", "\"\<,\>\""}], ",", 
                 RowBox[{"\"\<HoldForm[\>\"", "->", "\"\<\>\""}], ",", 
                 RowBox[{"\"\<],\>\"", "->", "\"\<,\>\""}]}], "}"}]}], "]"}], 
             ",", 
             RowBox[{"-", "2"}]}], "]"}], ",", "1"}], "]"}], 
         ",", "\"\<, \>\""}], "]"}]}], ";", "\n", "\t", 
      RowBox[{"ListOfOtherConstants", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{"stringNames", ",", 
           RowBox[{"Length", "@", "$ValuesOfSigns"}]}], "]"}], ",", 
         RowBox[{"s_String", "/;", 
          RowBox[{"StringMatchQ", "[", 
           RowBox[{
            RowBox[{"StringTrim", "[", "s", "]"}], ",", "\"\<$*Sign\>\""}], 
           "]"}]}]}], "]"}]}], ";", "\n", "\n", "\t", 
      RowBox[{"Unset", "/@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"#", ",", "InputForm", ",", "Unevaluated"}], "]"}], "&"}], 
         "/@", "ListOfOtherConstants"}], ")"}]}], ";", "\n", "\t", 
      RowBox[{"UndefConstantSymbol", "/@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"#", ",", "InputForm", ",", "Unevaluated"}], "]"}], "&"}], 
         "/@", "ListOfOtherConstants"}], ")"}]}], ";", "\n", "\t", "\n", "\t", 
      RowBox[{"symbolNames", "=", 
       RowBox[{"Replace", "[", 
        RowBox[{
         RowBox[{"First", "@", 
          RowBox[{"OwnValues", "[", "$ConstantSymbols", "]"}]}], ",", 
         RowBox[{
          RowBox[{"HoldPattern", "[", 
           RowBox[{"_", ":>", "list_"}], "]"}], ":>", 
          RowBox[{"Map", "[", 
           RowBox[{"HoldForm", ",", 
            RowBox[{"Unevaluated", "[", "list", "]"}]}], "]"}]}]}], "]"}]}], ";",
       "\n", "\t", 
      RowBox[{"stringNames", "=", 
       RowBox[{"StringSplit", "[", 
        RowBox[{
         RowBox[{"StringDrop", "[", 
          RowBox[{
           RowBox[{"StringDrop", "[", 
            RowBox[{
             RowBox[{"StringReplace", "[", 
              RowBox[{
               RowBox[{"ToString", "[", 
                RowBox[{"symbolNames", ",", "InputForm"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\"\< $\>\"", "->", "\"\<$\>\""}], ",", 
                 RowBox[{"\"\<, \>\"", "->", "\"\<,\>\""}], ",", 
                 RowBox[{"\"\<HoldForm[\>\"", "->", "\"\<\>\""}], ",", 
                 RowBox[{"\"\<],\>\"", "->", "\"\<,\>\""}]}], "}"}]}], "]"}], 
             ",", 
             RowBox[{"-", "2"}]}], "]"}], ",", "1"}], "]"}], 
         ",", "\"\<, \>\""}], "]"}]}], ";", "\n", "\t", 
      RowBox[{"ListOfOtherConstants", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{"stringNames", ",", 
           RowBox[{"Length", "@", "$ValuesOfSigns"}]}], "]"}], ",", 
         RowBox[{"s_String", "/;", 
          RowBox[{"StringMatchQ", "[", 
           RowBox[{
            RowBox[{"StringTrim", "[", "s", "]"}], ",", "\"\<$*Sign\>\""}], 
           "]"}]}]}], "]"}]}], ";", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", "ListOfOtherConstants"}], ">", "1"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some constants could not be undefined: \
\>\"", ",", "ListOfOtherConstants", 
          ",", "\"\<. Try running ResetSession again\\ \>\""}], "]"}]}], 
       "]"}], ";"}]}], "\t", "\n", "\t", "]"}]}]}]], "Code",
 CellChangeTimes->{{3.951854003212641*^9, 3.9518540434222755`*^9}, {
   3.951854407607256*^9, 3.9518544079962215`*^9}, {3.9518551744015636`*^9, 
   3.951855177039274*^9}, {3.951859586036133*^9, 3.951859632133009*^9}, {
   3.9518596966046066`*^9, 3.9518597076485767`*^9}, {3.9518597598444824`*^9, 
   3.9518597695737*^9}, 3.951859961301525*^9, {3.9518603956265736`*^9, 
   3.9518604139354076`*^9}, 3.951861965341223*^9, {3.9518620140270042`*^9, 
   3.9518620301785126`*^9}, {3.951927177125393*^9, 3.9519271775865383`*^9}, {
   3.9533923475199413`*^9, 3.953392350742031*^9}, {3.954514663631027*^9, 
   3.954514780682354*^9}, {3.954515029837227*^9, 3.954515038381651*^9}, {
   3.954515099403469*^9, 3.954515237867693*^9}, {3.9545152790787067`*^9, 
   3.9545153929500313`*^9}, {3.954518664560684*^9, 3.954518675077835*^9}, 
   3.954518787814556*^9, {3.9545189922401695`*^9, 3.9545190580784435`*^9}, 
   3.9545191248047104`*^9, 3.9545194993934727`*^9, {3.954519578695154*^9, 
   3.954519590017864*^9}, {3.954853388785324*^9, 3.954853422872299*^9}, {
   3.9553900226222153`*^9, 3.955390032818432*^9}, {3.955825669217203*^9, 
   3.955825707736597*^9}, {3.9558259489776764`*^9, 3.9558259833486404`*^9}, {
   3.955826034680666*^9, 3.9558260352704487`*^9}, {3.957210538327921*^9, 
   3.9572105387657833`*^9}, {3.957210599213686*^9, 3.957210619171444*^9}, {
   3.957210650072872*^9, 3.9572106643199406`*^9}, {3.957210858870617*^9, 
   3.957210870830406*^9}, {3.957283659429611*^9, 3.957283688299864*^9}, {
   3.957283792682888*^9, 3.957283830679743*^9}, {3.957283876189108*^9, 
   3.957283967843975*^9}, {3.9572840820087967`*^9, 3.957284088690916*^9}, 
   3.957284228107399*^9, {3.9572851491517353`*^9, 3.957285150036787*^9}, {
   3.957285293221794*^9, 3.9572852994925156`*^9}, {3.957285746785385*^9, 
   3.9572857510310497`*^9}, {3.9572857923832455`*^9, 3.95728579591255*^9}, {
   3.957285835972601*^9, 3.957285839690027*^9}, {3.957286267953991*^9, 
   3.9572862987507343`*^9}, {3.9573289889415417`*^9, 
   3.9573290002922554`*^9}, {3.9573290768498135`*^9, 3.957329082465246*^9}, {
   3.9573291242642975`*^9, 3.9573291778569336`*^9}, {3.9573659025913258`*^9, 
   3.9573659364524174`*^9}, {3.957365978753662*^9, 3.957366008409603*^9}, {
   3.957550692267645*^9, 3.957550765260252*^9}, {3.9576163994195023`*^9, 
   3.9576164571579895`*^9}, {3.957616684801613*^9, 3.9576166927578583`*^9}, 
   3.9576167737853184`*^9, {3.9576175055838966`*^9, 3.95761754768182*^9}, {
   3.9576177185036793`*^9, 3.9576177295528355`*^9}, {3.957618533688711*^9, 
   3.957618545304554*^9}, {3.9576198643264446`*^9, 3.9576198894467983`*^9}, {
   3.9576199253614655`*^9, 3.95761992717198*^9}, {3.957620113245037*^9, 
   3.957620129730549*^9}, {3.957620189586172*^9, 3.957620243775957*^9}, {
   3.9576206171968117`*^9, 3.957620652227627*^9}, {3.9576236363755226`*^9, 
   3.9576237119564095`*^9}, {3.95762390264822*^9, 3.9576239877379646`*^9}, {
   3.957624225853876*^9, 3.957624259922886*^9}, {3.9576243765355377`*^9, 
   3.957624570388653*^9}, {3.957624623795847*^9, 3.95762463339822*^9}, {
   3.9576371057663193`*^9, 3.957637120244116*^9}, {3.9576374803557663`*^9, 
   3.9576375236722393`*^9}, {3.957637607099476*^9, 3.957637644496464*^9}, {
   3.9576377071747684`*^9, 3.957637772505228*^9}, {3.957637921442976*^9, 
   3.957637940920351*^9}, {3.9576379824842415`*^9, 3.957638055730839*^9}, {
   3.9576382903494816`*^9, 3.957638400221113*^9}, {3.957638435016144*^9, 
   3.9576385057094345`*^9}, {3.9576385757739544`*^9, 
   3.9576386046210403`*^9}, {3.9576386718068485`*^9, 
   3.9576386778279877`*^9}, {3.957638757377819*^9, 3.957638813230255*^9}, {
   3.9576388966985207`*^9, 3.957638897633974*^9}, {3.9576389800419254`*^9, 
   3.9576391093289375`*^9}, {3.9576391409938717`*^9, 3.957639141165228*^9}, 
   3.9576391952535515`*^9, {3.9576392421474457`*^9, 3.957639282402893*^9}, {
   3.9576393170737743`*^9, 3.957639317620102*^9}, {3.9576393645753384`*^9, 
   3.9576394054811497`*^9}, {3.9576394936542244`*^9, 
   3.9576394980152874`*^9}, {3.9576395364080105`*^9, 3.957639544452091*^9}, {
   3.9576396330006676`*^9, 3.9576396365370197`*^9}, {3.957639908400532*^9, 
   3.957639923052698*^9}, {3.957639987130089*^9, 3.9576399908374443`*^9}, {
   3.957640309433031*^9, 3.957640324947342*^9}, {3.957640669003748*^9, 
   3.9576406818869705`*^9}, {3.957641150694168*^9, 3.9576411654226665`*^9}, {
   3.9576412054209175`*^9, 3.95764125922093*^9}, {3.9576413907079277`*^9, 
   3.957641391346613*^9}, {3.957641613804249*^9, 3.957641678867239*^9}, {
   3.9576418410595837`*^9, 3.957641857546503*^9}, {3.9576421471430187`*^9, 
   3.957642184397539*^9}, {3.9576424369277554`*^9, 3.957642437951603*^9}, {
   3.957642532383749*^9, 3.9576425724051647`*^9}, {3.9576426431213894`*^9, 
   3.9576426575289135`*^9}, {3.957643082226591*^9, 3.957643108553608*^9}, {
   3.957643146373083*^9, 3.9576431929760227`*^9}, {3.9576441037638664`*^9, 
   3.9576441330853558`*^9}, {3.9576441788385544`*^9, 
   3.9576441930718346`*^9}, {3.957644697012741*^9, 3.9576447183658504`*^9}, {
   3.9576447664640713`*^9, 3.957644770419758*^9}, {3.95764482588468*^9, 
   3.9576448325918636`*^9}, {3.957644876638582*^9, 3.9576449441902866`*^9}, {
   3.9576458183044834`*^9, 3.9576458193736*^9}, 3.9582331475913334`*^9},
 CellLabel->
  "In[444]:=",ExpressionUUID->"6f696bd7-c676-624d-b733-f2589d8a5be0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". xActQ"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, 3.954518473034981*^9, {
   3.9576431237058163`*^9, 3.957643148617237*^9}, 
   3.960486076253496*^9},ExpressionUUID->"d9f01f7a-5f11-024a-a3d9-\
0ebe482e11df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xActQ", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"ConstantSymbolQ", "[", "x", "]"}], "||", 
   RowBox[{"CovDQ", "[", "x", "]"}], "||", 
   RowBox[{"InertHeadQ", "[", "x", "]"}], "||", 
   RowBox[{"ManifoldQ", "[", "x", "]"}], "||", 
   RowBox[{"MappingQ", "[", "x", "]"}], "||", 
   RowBox[{"ParameterQ", "[", "x", "]"}], "||", 
   RowBox[{"ScalarFunctionQ", "[", "x", "]"}], "||", 
   RowBox[{"VBundleQ", "[", "x", "]"}], "||", 
   RowBox[{"xTensorQ", "[", "x", "]"}], "||", 
   RowBox[{"AbstractIndexQ", "[", "x", "]"}]}]}]], "Code",
 CellChangeTimes->{{3.9604861673873672`*^9, 3.9604861987214947`*^9}, 
   3.9604864471721287`*^9, 3.960486589457527*^9, 3.960486649445801*^9, 
   3.960486708602556*^9, {3.9604867711205673`*^9, 
   3.9604867927555695`*^9}},ExpressionUUID->"edfe324e-a490-1e4d-b412-\
6d9a604313cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ResetSession"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, {
   3.933027138211732*^9, 3.933027142387632*^9}, 3.948390934180411*^9, 
   3.949058388120071*^9, {3.949437661060505*^9, 3.9494376656908264`*^9}, {
   3.950299479271055*^9, 3.950299480035549*^9}, 
   3.954518473034981*^9},ExpressionUUID->"2118e15c-6ecf-d745-a9a7-\
ff47a0d60e46"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "ResetSession", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"UndefInfo", "->", "False"}], ",", 
      RowBox[{"Signs", "->", "1"}]}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "I", " ", "am", " ", "sure", " ", "that", " ", "there", " ", "are", " ", 
    "much", " ", "better", " ", "ways", " ", "to", " ", "define", " ", "this",
     " ", 
    RowBox[{"function", ".", " ", "ResetSession"}], " ", "undefines", " ", 
    "everything", " ", "with", " ", "some", " ", "order", " ", "but", " ", 
    "not", " ", 
    RowBox[{"much", ".", " ", "Quiet"}], " ", "is", " ", "used", " ", "to", " ",
     "avoid", " ", "the", " ", "error", " ", "messages"}], " ", "*)"}], " ", 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ResetSession", "[", 
    RowBox[{"opt", ":", 
     RowBox[{"OptionsPattern", "[", 
      RowBox[{"Options", "[", "ResetSession", "]"}], "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"originalUndefInfo", "=", "$UndefInfoQ"}], ",", "symbolNames", 
       ",", "stringNames", ",", "ListOfOtherConstants", ",", 
       "listOfNonxActSymbols", ",", "listOfNonxActSymbolsWithOwnValues", ",", 
       "brokenSymbols"}], "}"}], ",", "\[IndentingNewLine]", "\t", "\n", "\t", 
     RowBox[{
      RowBox[{"listOfNonxActSymbols", "=", 
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], ",", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"xActQ", "[", 
             RowBox[{"ToExpression", "@", "#"}], "]"}]}], "&"}]}], "]"}], "//",
         "Quiet"}]}], ";", "\n", "\t", 
      RowBox[{"listOfNonxActSymbolsWithOwnValues", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"listOfNonxActSymbols", ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"OwnValues", "[", "#", "]"}], "=!=", 
            RowBox[{"{", "}"}]}], "&&", 
           RowBox[{"!", 
            RowBox[{"ConstantQ", "[", 
             RowBox[{"ToExpression", "[", "#", "]"}], "]"}]}]}], "&"}]}], 
        "]"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "ConstantSymbols", " ", "can", " ", "have", " ", "a", " ", "value"}], 
        ",", " ", 
        RowBox[{
        "but", " ", "they", " ", "are", " ", "handled", " ", "separately"}]}],
        " ", "*)"}], "\n", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"$UndefInfoQ", "=", 
       RowBox[{"OptionValue", "[", "UndefInfo", "]"}]}], ";", "\n", "\t", 
      "\n", "\t", 
      RowBox[{"UnDefConstantsExceptSigns", "//", "Quiet"}], ";", " ", "\n", 
      "\t", 
      RowBox[{
       RowBox[{"UndefCovD", "/@", 
        RowBox[{"Select", "[", 
         RowBox[{"$CovDs", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"!", 
             RowBox[{"MetricQ", "@", 
              RowBox[{"MetricOfCovD", "[", "#", "]"}]}]}], "&&", 
            RowBox[{"#", "=!=", "PD"}]}], " ", "&"}]}], "]"}]}], "//", 
       "Quiet"}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefMetric", "/@", "$Metrics"}], "//", "Quiet"}], ";", "\n", 
      "\t", 
      RowBox[{
       RowBox[{"UndefScalarFunction", "/@", "$ScalarFunctions"}], "//", 
       "Quiet"}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefParameter", "/@", "$Parameters"}], "//", "Quiet"}], ";", 
      "\n", "\t", 
      RowBox[{
       RowBox[{"UndefTensor", "/@", "$MasterTensors"}], "//", "Quiet"}], ";", 
      "\n", "\t", 
      RowBox[{
       RowBox[{"UndefParameter", "/@", "$Parameters"}], "//", "Quiet"}], ";", 
      "\n", "\t", 
      RowBox[{
       RowBox[{"UndefGeneralizedVVF", "/@", "$GeneralizedVVF"}], "//", 
       "Quiet"}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefMapping", "/@", "$Mappings"}], "//", "Quiet"}], ";", 
      "\n", "\t", 
      RowBox[{
       RowBox[{"UndefVBundle", "/@", 
        RowBox[{"Select", "[", 
         RowBox[{"$VBundles", ",", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"TangentBundleQ", "[", "#", "]"}]}], "&"}]}], "]"}]}], "//",
        "Quiet"}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefManifold", "/@", "$Manifolds"}], "//", "Quiet"}], ";", 
      "\n", "\t", "\n", "\t", 
      RowBox[{"UnDefConstantsExceptSigns", "//", "Quiet"}], ";", "\n", "\t", 
      "UnDefConstantsExceptSigns", ";", "\n", "\t", 
      RowBox[{"SetSigns", "[", 
       RowBox[{"OptionValue", "[", "Signs", "]"}], "]"}], ";", "\n", "\t", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"UndefCovD", "/@", 
        RowBox[{"Select", "[", 
         RowBox[{"$CovDs", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"!", 
             RowBox[{"MetricQ", "@", 
              RowBox[{"MetricOfCovD", "[", "#", "]"}]}]}], "&&", 
            RowBox[{"#", "=!=", "PD"}]}], " ", "&"}]}], "]"}]}], "//", 
       "Quiet"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Due", " ", "to", " ", "some", " ", "dependencies", " ", 
         RowBox[{"(", 
          RowBox[{"like", " ", "ExtendedFrom"}], ")"}]}], ",", " ", 
        RowBox[{
        "some", " ", "CovDs", " ", "might", " ", "be", " ", "removed", " ", 
         "twice", " ", "and", " ", "an", " ", "error", " ", "is", " ", 
         RowBox[{"thrown", ".", " ", "Thus"}], " ", "the", " ", "first", " ", 
         "time", " ", "we", " ", "make", " ", "it", " ", "quiet", " ", "and", 
         " ", "we", " ", "try", " ", "to", " ", "remove", " ", "them", " ", 
         "all", " ", 
         RowBox[{"again", ".", " ", "If"}], " ", "a", " ", "problem", " ", 
         "persists"}], ",", " ", 
        RowBox[{"it", " ", "will", " ", "show", " ", "up"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"UndefCovD", "/@", 
       RowBox[{"Select", "[", 
        RowBox[{"$CovDs", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"!", 
            RowBox[{"MetricQ", "@", 
             RowBox[{"MetricOfCovD", "[", "#", "]"}]}]}], "&&", 
           RowBox[{"#", "=!=", "PD"}]}], " ", "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"Select", "[", 
           RowBox[{"$CovDs", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"!", 
               RowBox[{"MetricQ", "@", 
                RowBox[{"MetricOfCovD", "[", "#", "]"}]}]}], "&&", 
              RowBox[{"#", "=!=", "PD"}]}], " ", "&"}]}], "]"}], "]"}], ">", 
         "1"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some CovDs could not be undefined: \
\>\"", ",", 
          RowBox[{"Select", "[", 
           RowBox[{"$CovDs", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"!", 
               RowBox[{"MetricQ", "@", 
                RowBox[{"MetricOfCovD", "[", "#", "]"}]}]}], "&&", 
              RowBox[{"#", "=!=", "PD"}]}], " ", "&"}]}], "]"}], 
          ",", "\"\<. Try running ResetSession again.\\ \>\""}], "]"}]}], 
       "]"}], ";", "\n", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefMetric", "/@", "$Metrics"}], "//", "Quiet"}], ";", "\n", 
      "\t", 
      RowBox[{"UndefMetric", "/@", "$Metrics"}], ";", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "$Metrics", "]"}], ">", "0"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some metrics could not be undefined: \
\>\"", ",", "$Metrics", ",", "\"\<. Try running ResetSession again.\\ \>\""}],
          "]"}]}], "]"}], ";", "\n", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefScalarFunction", "/@", "$ScalarFunctions"}], "//", 
       "Quiet"}], ";", "\n", "\t", 
      RowBox[{"UndefScalarFunction", "/@", "$ScalarFunctions"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "$ScalarFunctions", "]"}], ">", "0"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some scalar functions could not be \
undefined: \>\"", ",", "$ScalarFunctions", 
          ",", "\"\<. Try running ResetSession again.\\ \>\""}], "]"}]}], 
       "]"}], ";", "\n", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefTensor", "/@", "$MasterTensors"}], "//", "Quiet"}], ";", 
      "\n", "\t", 
      RowBox[{"UndefCovD", "/@", 
       RowBox[{"Select", "[", 
        RowBox[{"$CovDs", ",", 
         RowBox[{
          RowBox[{"#", "=!=", "PD"}], " ", "&"}]}], "]"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "This", " ", "is", " ", "needed", " ", "for", " ", "the", " ", 
        "imploded", " ", "tensors"}], " ", "*)"}], "\n", "\t", 
      RowBox[{"UndefTensor", "/@", "$MasterTensors"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "$MasterTensors", "]"}], ">", "0"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some vertical forms could not be \
undefined:\>\"", ",", " ", "$MasterTensors", 
          ",", "\"\<. Try running ResetSession again.\\ \>\""}], "]"}]}], 
       "]"}], ";", "\n", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefParameter", "/@", "$Parameters"}], "//", "Quiet"}], ";", 
      "\n", "\t", 
      RowBox[{"UndefParameter", "/@", "$Parameters"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "$Parameters", "]"}], ">", "0"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some parameters could not be \
undefined: \>\"", ",", "$Parameters", 
          ",", "\"\<. Try running ResetSession again.\\ \>\""}], "]"}]}], 
       "]"}], ";", "\n", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefGeneralizedVVF", "/@", "$GeneralizedVVF"}], "//", 
       "Quiet"}], ";", "\n", "\t", 
      RowBox[{"UndefGeneralizedVVF", "/@", "$GeneralizedVVF"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "$GeneralizedVVF", "]"}], ">", "0"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some generalized vector fields could \
not be undefined: \>\"", ",", "$GeneralizedVVF", 
          ",", "\"\<. Try running ResetSession again.\\ \>\""}], "]"}]}], 
       "]"}], ";", "\n", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefMapping", "/@", "$Mappings"}], "//", "Quiet"}], ";", 
      "\n", "\t", 
      RowBox[{"UndefMapping", "/@", "$Mappings"}], ";", "\[IndentingNewLine]",
       "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "$Mappings", "]"}], ">", "0"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some mappings could not be undefined: \
\>\"", ",", "$Mappings", 
          ",", "\"\<. Try running ResetSession again.\\ \>\""}], "]"}]}], 
       "]"}], ";", "\n", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"UndefVBundle", "/@", 
        RowBox[{"Select", "[", 
         RowBox[{"$VBundles", ",", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"TangentBundleQ", "[", "#", "]"}]}], "&"}]}], "]"}]}], "//",
        "Quiet"}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"UndefVBundle", "/@", 
       RowBox[{"Select", "[", 
        RowBox[{"$VBundles", ",", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"TangentBundleQ", "[", "#", "]"}]}], "&"}]}], "]"}]}], ";",
       "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"Select", "[", 
           RowBox[{"$VBundles", ",", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"TangentBundleQ", "[", "#", "]"}]}], "&"}]}], "]"}], 
          "]"}], ">", "0"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some vector bundles could not be \
undefined: \>\"", ",", 
          RowBox[{"Select", "[", 
           RowBox[{"$VBundles", ",", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"TangentBundleQ", "[", "#", "]"}]}], "&"}]}], "]"}], 
          ",", "\"\<. Try running ResetSession again.\\ \>\""}], "]"}]}], 
       "]"}], ";", "\n", "\n", "\t", 
      RowBox[{
       RowBox[{"UndefManifold", "/@", "$Manifolds"}], "//", "Quiet"}], ";", 
      "\n", "\t", 
      RowBox[{"UndefManifold", "/@", "$Manifolds"}], ";", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "$Manifolds", "]"}], ">", "0"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** ResetSession: Some manifolds could not be undefined: \
\>\"", ",", "$Manifolds", 
          ",", "\"\<. Try running ResetSession again.\\ \>\""}], "]"}]}], 
       "]"}], ";", "\n", "\n", "\t", 
      RowBox[{"listOfNonxActSymbolsWithOwnValues", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"listOfNonxActSymbolsWithOwnValues", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"OwnValues", "[", "#", "]"}], "=!=", 
           RowBox[{"{", "}"}]}], "&"}]}], "]"}]}], ";", "\n", "\t", 
      RowBox[{"brokenSymbols", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"listOfNonxActSymbolsWithOwnValues", ",", 
         RowBox[{
          RowBox[{"StringContainsQ", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"OwnValues", "[", "#", "]"}], "]"}], 
            ",", "\"\<Removed[\>\""}], "]"}], "&"}]}], "]"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Remove", " ", "objects", " ", "defined", " ", "in", " ", "terms", " ",
         "of", " ", "undefined", " ", "elements"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"Remove", "@@", "brokenSymbols"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"$UndefInfoQ", "=", "originalUndefInfo"}], ";"}]}], "\n", 
    "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "ResetSession", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.951854003212641*^9, 3.9518540434222755`*^9}, {
   3.951854407607256*^9, 3.9518544079962215`*^9}, {3.9518551744015636`*^9, 
   3.951855177039274*^9}, {3.951859586036133*^9, 3.951859632133009*^9}, {
   3.9518596966046066`*^9, 3.9518597076485767`*^9}, {3.9518597598444824`*^9, 
   3.9518597695737*^9}, 3.951859961301525*^9, {3.9518603956265736`*^9, 
   3.9518604139354076`*^9}, 3.951861965341223*^9, {3.9518620140270042`*^9, 
   3.9518620301785126`*^9}, {3.951927177125393*^9, 3.9519271775865383`*^9}, {
   3.9533923475199413`*^9, 3.953392350742031*^9}, {3.954514663631027*^9, 
   3.954514780682354*^9}, {3.954515029837227*^9, 3.954515038381651*^9}, {
   3.954515099403469*^9, 3.954515237867693*^9}, {3.9545152790787067`*^9, 
   3.9545153929500313`*^9}, {3.954518664560684*^9, 3.954518675077835*^9}, 
   3.954518787814556*^9, {3.9545189922401695`*^9, 3.9545190580784435`*^9}, 
   3.9545191248047104`*^9, 3.9545194993934727`*^9, {3.954519578695154*^9, 
   3.954519590017864*^9}, {3.954853388785324*^9, 3.954853422872299*^9}, {
   3.9553900226222153`*^9, 3.955390032818432*^9}, {3.955825669217203*^9, 
   3.955825707736597*^9}, {3.9558259489776764`*^9, 3.9558259833486404`*^9}, {
   3.955826034680666*^9, 3.9558260352704487`*^9}, {3.957210538327921*^9, 
   3.9572105387657833`*^9}, {3.957210599213686*^9, 3.957210619171444*^9}, {
   3.957210650072872*^9, 3.9572106643199406`*^9}, {3.957210858870617*^9, 
   3.957210870830406*^9}, {3.957283659429611*^9, 3.957283688299864*^9}, {
   3.957283792682888*^9, 3.957283830679743*^9}, {3.957283876189108*^9, 
   3.957283967843975*^9}, {3.9572840820087967`*^9, 3.957284088690916*^9}, 
   3.957284228107399*^9, {3.9572851491517353`*^9, 3.957285150036787*^9}, {
   3.957285293221794*^9, 3.9572852994925156`*^9}, {3.957285746785385*^9, 
   3.9572857510310497`*^9}, {3.9572857923832455`*^9, 3.95728579591255*^9}, {
   3.957285835972601*^9, 3.957285839690027*^9}, {3.957286267953991*^9, 
   3.9572862987507343`*^9}, {3.9573289889415417`*^9, 
   3.9573290002922554`*^9}, {3.9573290768498135`*^9, 3.957329082465246*^9}, {
   3.9573291242642975`*^9, 3.9573291778569336`*^9}, {3.9573659025913258`*^9, 
   3.9573659364524174`*^9}, {3.957365978753662*^9, 3.957366008409603*^9}, {
   3.957550692267645*^9, 3.957550765260252*^9}, {3.9576163994195023`*^9, 
   3.9576164571579895`*^9}, {3.957616684801613*^9, 3.9576166927578583`*^9}, 
   3.9576167737853184`*^9, {3.9576175055838966`*^9, 3.95761754768182*^9}, {
   3.9576177185036793`*^9, 3.9576177295528355`*^9}, {3.957618533688711*^9, 
   3.957618545304554*^9}, {3.9576198643264446`*^9, 3.9576198894467983`*^9}, {
   3.9576199253614655`*^9, 3.95761992717198*^9}, {3.957620113245037*^9, 
   3.957620129730549*^9}, {3.957620189586172*^9, 3.957620243775957*^9}, {
   3.9576206171968117`*^9, 3.957620652227627*^9}, {3.9576236363755226`*^9, 
   3.9576237119564095`*^9}, {3.95762390264822*^9, 3.9576239877379646`*^9}, {
   3.957624225853876*^9, 3.957624259922886*^9}, {3.9576243765355377`*^9, 
   3.957624570388653*^9}, {3.957624623795847*^9, 3.95762463339822*^9}, {
   3.957637124632025*^9, 3.957637149937235*^9}, 3.9576374433235703`*^9, 
   3.9576381056127796`*^9, {3.9576391539858227`*^9, 3.957639187021015*^9}, 
   3.9576392438481255`*^9, {3.957639616150339*^9, 3.9576396235367546`*^9}, {
   3.957639721231268*^9, 3.957639723083956*^9}, {3.9576398059739895`*^9, 
   3.957639848557192*^9}, {3.957640662355461*^9, 3.9576407143625507`*^9}, {
   3.9576407926445637`*^9, 3.9576408097979507`*^9}, {3.9576408611168575`*^9, 
   3.9576408993279953`*^9}, 3.957640938290785*^9, {3.957641009830532*^9, 
   3.957641020451124*^9}, {3.957641109484274*^9, 3.957641110775717*^9}, {
   3.957641178825224*^9, 3.957641201991329*^9}, {3.9576412986912155`*^9, 
   3.95764131120278*^9}, 3.9576413556828003`*^9, {3.957642227059988*^9, 
   3.9576422293901825`*^9}, 3.9576458242527103`*^9, {3.95790312712434*^9, 
   3.957903127793768*^9}, {3.9579031701524944`*^9, 3.9579031717750587`*^9}, {
   3.9579032390915356`*^9, 3.9579032432518597`*^9}, {3.9579034396367874`*^9, 
   3.9579034398323116`*^9}, {3.9579070385566025`*^9, 
   3.9579070534201183`*^9}, {3.957907195411598*^9, 3.957907199512024*^9}, {
   3.957907265953993*^9, 3.957907272093151*^9}, {3.9581344533791256`*^9, 
   3.9581344771835423`*^9}, {3.9581345227648125`*^9, 3.958134537029257*^9}, {
   3.9582330443561687`*^9, 3.958233138567415*^9}, {3.9583146103030014`*^9, 
   3.958314627381201*^9}, {3.958314670222187*^9, 3.9583148114179*^9}, {
   3.960486113491556*^9, 3.960486127067732*^9}, {3.9604861681919594`*^9, 
   3.9604862468848877`*^9}, {3.9604863151908607`*^9, 3.960486340505497*^9}, {
   3.9604863803342075`*^9, 3.960486396837673*^9}, {3.960486434360283*^9, 
   3.960486449471855*^9}, {3.9604865141865387`*^9, 3.9604865235024376`*^9}, {
   3.960486947602684*^9, 3.9604869624230824`*^9}, {3.960487346772545*^9, 
   3.960487366449108*^9}, {3.960555449997612*^9, 3.960555514439045*^9}, {
   3.960555590308548*^9, 3.960555617210823*^9}, {3.9606128114694176`*^9, 
   3.960612818990223*^9}, {3.9606128605649757`*^9, 3.9606128718449554`*^9}, 
   3.9606129079999657`*^9, {3.9606129907027664`*^9, 3.9606130078380947`*^9}, {
   3.9606130615578213`*^9, 3.9606130824288826`*^9}, {3.960613121774143*^9, 
   3.9606131470209503`*^9}, {3.9606132465080223`*^9, 3.960613291381071*^9}, {
   3.9606133298180313`*^9, 3.9606133613820744`*^9}, 3.9606134325721493`*^9, {
   3.9606134802006397`*^9, 3.96061357454998*^9}, {3.9606143806063385`*^9, 
   3.960614387476244*^9}, 
   3.9639359962908516`*^9},ExpressionUUID->"a574a1e4-87bd-8240-ac08-\
9b9db08d97a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". MakePattern"
}], "Subsection",
 CellChangeTimes->{3.932387283337832*^9, 3.932717004562273*^9, 
  3.932999924456765*^9, 3.948391795728576*^9, 3.948727109141032*^9, 
  3.949767387606846*^9},ExpressionUUID->"8bf97148-4881-2f42-9091-\
edf6d1c0d0e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "make", " ", "patterns", " ", "for", " ", 
    "symbol", " ", "matching"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"RuleDelayed", "::", "rhs"}], "]"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"MakePattern", "[", "a_Symbol", "]"}], " ", ":=", " ", 
     "a_Symbol"}], ";"}], "       ", 
   RowBox[{"(*", " ", 
    RowBox[{"Match", " ", "a", " ", "positive", " ", "symbol"}], " ", "*)"}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"MakePattern", "[", 
      RowBox[{"-", "a_Symbol"}], "]"}], " ", ":=", " ", 
     RowBox[{"-", "a_Symbol"}]}], ";"}], "     ", 
   RowBox[{"(*", " ", 
    RowBox[{"Match", " ", "a", " ", "negative", " ", "symbol"}], " ", "*)"}], 
   "\n", 
   RowBox[{"On", "[", 
    RowBox[{"RuleDelayed", "::", "rhs"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.948727110409928*^9, 3.94872711287775*^9}, {
  3.9497673876208515`*^9, 3.949767387629853*^9}, {3.950268950588098*^9, 
  3.9502690038579273`*^9}, {3.950271185171865*^9, 3.950271188961195*^9}},
 CellLabel->
  "In[448]:=",ExpressionUUID->"fab4c4e1-b269-9644-92c7-7be1eade5431"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". TensorWithIndices"
}], "Subsection",
 CellChangeTimes->{3.932387283337832*^9, 3.932717004562273*^9, 
  3.932999924456765*^9, 
  3.948391795728576*^9},ExpressionUUID->"6a20bd0a-de81-0645-b791-\
da8f563fefbf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ChristoffelAUX", "[", "PD", "]"}], ":=", "Zero"}], "\n", 
 RowBox[{
  RowBox[{"ChristoffelAUX", "[", 
   RowBox[{"PD", ",", "PD"}], "]"}], ":=", "Zero"}], "\n", 
 RowBox[{
  RowBox[{"AChristoffelAUX", "[", "PD", "]"}], ":=", "Zero"}], "\n", 
 RowBox[{
  RowBox[{"AChristoffelAUX", "[", 
   RowBox[{"PD", ",", "PD"}], "]"}], ":=", "Zero"}]}], "Code",
 CellChangeTimes->{{3.9585813825797977`*^9, 3.958581386835085*^9}, {
  3.958581666667488*^9, 3.9585816747767067`*^9}},
 CellLabel->
  "In[452]:=",ExpressionUUID->"01850350-ea82-ae48-9597-47eda7caedca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Fills", " ", "the", " ", "slots", " ", "of", " ", "tensors", " ", "with", 
    " ", "the", " ", "correct", " ", "indices"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Attributes", "[", "TensorWithIndices", "]"}], "=", 
     RowBox[{"{", "HoldFirst", "}"}]}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorWithIndices", "::", "errorUnkown"}], 
     "=", "\"\<No indices can be placed on `1`.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorWithIndices", "::", "errorCovds"}], 
     "=", "\"\<`1` and `2` are not compatible CovDs.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorWithIndices", "::", "errordelta"}], 
     "=", "\"\<No indices can be placed on \[Delta] as it is defined on every \
bundle (identity morphism).\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorWithIndices", "::", "errorGdelta"}], 
     "=", "\"\<No indices can be placed on G\[Delta] as it is defined on \
every bundle.\>\""}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", "delta", "]"}], ":=", 
    RowBox[{"Throw", "@", 
     RowBox[{"Message", "[", 
      RowBox[{"TensorWithIndices", "::", "errordelta"}], "]"}]}]}], "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", "Gdelta", "]"}], ":=", 
    RowBox[{"Throw", "@", 
     RowBox[{"Message", "[", 
      RowBox[{"TensorWithIndices", "::", "errorGdelta"}], "]"}]}]}], "\n", 
   "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Christoffel", " ", "and", " ", "AChristoffel", " ", "are", " ", "not", " ",
      "evaluated", " ", "unless", " ", "some", " ", "indices", " ", "are", " ",
      "included"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"Christoffel", "[", 
      RowBox[{
       RowBox[{"der1_", "?", "CovDQ"}], ",", "PD"}], "]"}], "]"}], ":=", 
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"ChristoffelAUX", "[", "der1", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"AChristoffel", "[", 
      RowBox[{
       RowBox[{"der1_", "?", "CovDQ"}], ",", "PD"}], "]"}], "]"}], ":=", 
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"AChristoffelAUX", "[", "der1", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"Christoffel", "[", 
      RowBox[{"PD", ",", 
       RowBox[{"der2_", "?", "CovDQ"}]}], "]"}], "]"}], ":=", 
    RowBox[{"-", 
     RowBox[{"TensorWithIndices", "[", 
      RowBox[{"ChristoffelAUX", "[", "der2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"AChristoffel", "[", 
      RowBox[{"PD", ",", 
       RowBox[{"der2_", "?", "CovDQ"}]}], "]"}], "]"}], ":=", 
    RowBox[{"-", 
     RowBox[{"TensorWithIndices", "[", 
      RowBox[{"AChristoffelAUX", "[", "der2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"Christoffel", "[", 
      RowBox[{"der_", ",", 
       RowBox[{"der_", "?", "CovDQ"}]}], "]"}], "]"}], ":=", "0"}], "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"AChristoffel", "[", 
      RowBox[{"der_", ",", 
       RowBox[{"der_", "?", "CovDQ"}]}], "]"}], "]"}], ":=", "0"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"Christoffel", "[", 
      RowBox[{"der_", "?", "CovDQ"}], "]"}], "]"}], ":=", 
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"ToExpression", "[", 
      RowBox[{"\"\<Christoffel\>\"", "<>", 
       RowBox[{"ToString", "[", "der", "]"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"AChristoffel", "[", 
      RowBox[{"der_", "?", "CovDQ"}], "]"}], "]"}], ":=", 
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"ToExpression", "[", 
      RowBox[{"\"\<AChristoffel\>\"", "<>", 
       RowBox[{"ToString", "[", "der", "]"}]}], "]"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"Christoffel", "[", 
      RowBox[{
       RowBox[{"der1_", "?", "CovDQ"}], ",", 
       RowBox[{"der2_", "?", "CovDQ"}]}], "]"}], "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"expr", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Christoffel\>\"", "<>", 
          RowBox[{"ToString", "[", "der1", "]"}], "<>", 
          RowBox[{"ToString", "[", "der2", "]"}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xTensorQ", "[", "expr", "]"}], ",", "\[IndentingNewLine]", 
        "        ", 
        RowBox[{"TensorWithIndices", "@", "expr"}], ",", 
        "\[IndentingNewLine]", "\t    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"xAct`xTensor`Private`CompatibleCovDsQ", "[", 
           RowBox[{"der1", ",", "der2"}], "]"}], ",", "\[IndentingNewLine]", 
          "           ", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"inds", "=", 
              RowBox[{"GetIndicesOfVBundle", "[", 
               RowBox[{
                RowBox[{"Tangent", "@", 
                 RowBox[{"ManifoldOfCovD", "@", "der1"}]}], ",", "3"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{
             RowBox[{"Christoffel", "[", 
              RowBox[{"der1", ",", "der2"}], "]"}], "[", 
             RowBox[{
              RowBox[{"inds", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"inds", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{"-", 
               RowBox[{"inds", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\t\t   ", 
          RowBox[{"Throw", "@", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"TensorWithIndices", "::", "errorCovds"}], ",", "der1", ",",
              "der2"}], "]"}]}]}], "\[IndentingNewLine]", "        ", "]"}]}],
        "\[IndentingNewLine]", "    ", "]"}]}], "\n", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"AChristoffel", "[", 
      RowBox[{
       RowBox[{"der1_", "?", "CovDQ"}], ",", 
       RowBox[{"der2_", "?", "CovDQ"}]}], "]"}], "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"expr", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<AChristoffel\>\"", "<>", 
          RowBox[{"ToString", "[", "der1", "]"}], "<>", 
          RowBox[{"ToString", "[", "der2", "]"}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xTensorQ", "[", "expr", "]"}], ",", "\[IndentingNewLine]", 
        "          ", 
        RowBox[{"TensorWithIndices", "@", "expr"}], ",", 
        "\[IndentingNewLine]", "\t\t  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"xAct`xTensor`Private`CompatibleCovDsQ", "[", 
           RowBox[{"der1", ",", "der2"}], "]"}], ",", "\[IndentingNewLine]", 
          "             ", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "=", 
               RowBox[{
                RowBox[{"GetIndicesOfVBundle", "[", 
                 RowBox[{
                  RowBox[{"Tangent", "@", 
                   RowBox[{"ManifoldOfCovD", "@", "der1"}]}], ",", "1"}], 
                 "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              "\t\t\t\t ", 
              RowBox[{"inds", "=", 
               RowBox[{"GetIndicesOfVBundle", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"VBundlesOfCovD", "[", "der1", "]"}], "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ",", "2"}], "]"}]}]}], 
             "}"}], ",", "\n", "\t\t\t\t ", 
            RowBox[{
             RowBox[{"AChristoffel", "[", 
              RowBox[{"der1", ",", "der2"}], "]"}], "[", 
             RowBox[{
              RowBox[{"inds", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"-", "ind"}], ",", 
              RowBox[{"-", 
               RowBox[{"inds", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\t\t     ", 
          RowBox[{"Throw", "@", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"TensorWithIndices", "::", "errorCovds"}], ",", "der1", ",",
              "der2"}], "]"}]}]}], "\[IndentingNewLine]", "          ", 
         "]"}]}], "\[IndentingNewLine]", "    ", "]"}]}], "\n", "]"}]}], "\n",
    "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", "Zero", "]"}], ":=", "0"}], "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"metric_Inv", "?", "MetricQ"}], "]"}], ":=", 
    RowBox[{"metric", "@@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "*", 
       RowBox[{"(", 
        RowBox[{"DummyIn", "/@", 
         RowBox[{"SlotsOfTensor", "[", "metric", "]"}]}], ")"}]}], ")"}]}]}], 
   "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"tensor_", "?", "xTensorQ"}], "]"}], ":=", 
    RowBox[{"tensor", "@@", 
     RowBox[{"(", 
      RowBox[{"DummyIn", "/@", 
       RowBox[{"SlotsOfTensor", "[", "tensor", "]"}]}], ")"}]}]}], "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], ":=", 
    RowBox[{"TensorWithIndices", "[", "tensor", "]"}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"If", " ", "the", " ", "tensor", " ", "has", " ", "indices"}], ",",
      " ", 
     RowBox[{
     "TensorWithIndices", " ", "removes", " ", "them", " ", "and", " ", 
      "puts", " ", "new", " ", "one", " ", 
      RowBox[{"(", 
       RowBox[{
       "in", " ", "case", " ", "they", " ", "were", " ", "not", " ", "in", " ",
         "the", " ", "right", " ", "place"}], ")"}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", "None", "]"}], ":=", 
    RowBox[{"{", "}"}]}], " ", "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", 
     RowBox[{"{", "}"}], "]"}], ":=", 
    RowBox[{"{", "}"}]}], " ", "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Separate", " ", "definition", " ", "that", " ", "forces", " ", 
     "evaluation", " ", "for", " ", "MultiplyHead"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"TensorWithIndices", "[", "expr_", "]"}], ":=", 
    RowBox[{"Catch", "@", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"evaluated", "=", "expr"}], "}"}], ",", "\n", 
       "\t\t\t\t\t\t\t", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatchQ", "[", 
          RowBox[{"evaluated", ",", 
           RowBox[{"MultiplyHead", "[", 
            RowBox[{"integer_", ",", "tensor_"}], "]"}]}], "]"}], ",", "\n", 
         "\t\t\t\t\t\t\t\t", 
         RowBox[{
          RowBox[{"evaluated", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "*", 
          RowBox[{"TensorWithIndices", "[", 
           RowBox[{"evaluated", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", 
         "\t\t\t\t\t\t\t\t", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"TensorWithIndices", "::", "errorUnkown"}], ",", 
            "evaluated"}], "]"}]}]}], "]"}]}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "TensorWithIndices", "]"}], ";"}]}]}]], "Code",
 CellChangeTimes->{{3.9327170064095755`*^9, 3.932717031247394*^9}, {
   3.9327170809691987`*^9, 3.932717132640498*^9}, {3.932717199366937*^9, 
   3.932717244834992*^9}, {3.932717564636577*^9, 3.932717582096564*^9}, {
   3.932728485879007*^9, 3.932728489012789*^9}, {3.932728527244299*^9, 
   3.93272853032378*^9}, {3.932728593129099*^9, 3.932728593347297*^9}, 
   3.932999931037304*^9, {3.941650502707303*^9, 3.941650519481675*^9}, {
   3.9416508368855877`*^9, 3.941650842292811*^9}, {3.941650874983679*^9, 
   3.941650889611691*^9}, {3.948541666514636*^9, 3.948541703899901*^9}, 
   3.948542234861886*^9, {3.9492469978966184`*^9, 3.9492470047728233`*^9}, {
   3.9492484410863433`*^9, 3.949248466470368*^9}, {3.949248651253233*^9, 
   3.949248669729675*^9}, {3.949248748084072*^9, 3.949248802635072*^9}, {
   3.949248959094895*^9, 3.9492489858632*^9}, 3.949249590179043*^9, {
   3.94976740577993*^9, 3.949767406745817*^9}, {3.950287813588487*^9, 
   3.950287863501316*^9}, 3.9502879604477425`*^9, {3.950288225896837*^9, 
   3.950288243513063*^9}, {3.9503667204971848`*^9, 3.950366741742546*^9}, {
   3.951082234136317*^9, 3.951082270379896*^9}, {3.951218921866543*^9, 
   3.951218922891365*^9}, {3.951218953462816*^9, 3.9512189687069607`*^9}, {
   3.9512193097475147`*^9, 3.951219316968214*^9}, {3.9548539420318394`*^9, 
   3.9548539532160225`*^9}, 3.95485403373864*^9, {3.9548543081003933`*^9, 
   3.954854321535797*^9}, {3.954866921538994*^9, 3.9548669577937145`*^9}, {
   3.9550979787593994`*^9, 3.9550980088682156`*^9}, {3.9550980388813896`*^9, 
   3.955098068317274*^9}, {3.9557473793299885`*^9, 3.955747381907255*^9}, {
   3.9557480037955227`*^9, 3.9557480538107243`*^9}, {3.955748222614359*^9, 
   3.955748232270643*^9}, {3.9557482789801254`*^9, 3.9557482874073315`*^9}, {
   3.9560853570418167`*^9, 3.95608538627899*^9}, {3.9571926728325996`*^9, 
   3.957192675131674*^9}, {3.95848554240843*^9, 3.9584855727340946`*^9}, {
   3.9584862208173504`*^9, 3.958486222712343*^9}, {3.958486349546774*^9, 
   3.9584863525216484`*^9}, {3.9584865320494537`*^9, 
   3.9584865704356823`*^9}, {3.9584866259755096`*^9, 
   3.9584866490021076`*^9}, {3.9584869291264057`*^9, 3.95848697075181*^9}, {
   3.9584871230555286`*^9, 3.9584871419619045`*^9}, {3.958487481474472*^9, 
   3.9584875129288063`*^9}, {3.958487668534027*^9, 3.958487702357147*^9}, {
   3.9584878372491226`*^9, 3.95848784296673*^9}, {3.9584879510116405`*^9, 
   3.958487952240267*^9}, {3.958497228688326*^9, 3.958497232927307*^9}, {
   3.9585814366417828`*^9, 3.95858145665057*^9}, 3.9585816783051815`*^9, {
   3.958753565376503*^9, 3.958753641337225*^9}, {3.9587538094970646`*^9, 
   3.9587538202259464`*^9}, {3.958753886191017*^9, 3.95875389221422*^9}, {
   3.9587539241825657`*^9, 3.958754001319193*^9}, {3.9587540319681396`*^9, 
   3.9587540371988716`*^9}, {3.9587549205947742`*^9, 3.958754943121977*^9}, {
   3.958755147121231*^9, 3.9587551683874855`*^9}, {3.9587554122669735`*^9, 
   3.9587554222921352`*^9}, {3.958755505759466*^9, 3.9587555289952393`*^9}, {
   3.9587556535965614`*^9, 3.9587556614663353`*^9}, {3.9587557607188797`*^9, 
   3.9587557811614094`*^9}, {3.9587559240480423`*^9, 
   3.9587559757684956`*^9}, {3.95887764607094*^9, 3.9588776928670387`*^9}, {
   3.960457203833143*^9, 
   3.9604572054588223`*^9}},ExpressionUUID->"2ad26772-65c7-b544-a506-\
a223e02a2296"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". DeleteDuplicatesTensors"
}], "Subsection",
 CellChangeTimes->{3.932387283337832*^9, 3.932717004562273*^9, 
  3.932999924456765*^9, 3.948391795728576*^9, 
  3.949238444330619*^9},ExpressionUUID->"54d08ae0-264b-5b40-a42d-\
6fc4d24aec8d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "function", " ", "checks", " ", "the", " ", "Heads", " ", 
    "and", " ", "removes", " ", "repeated", " ", "ones", " ", 
    RowBox[{"(", 
     RowBox[{"regardless", " ", "of", " ", "the", " ", "indices"}], " "}]}], 
   "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"DeleteDuplicatesTensors", "[", "list_List", "]"}], ":=", 
    RowBox[{"DeleteDuplicates", "[", 
     RowBox[{"list", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Head", "[", "#1", "]"}], "===", 
        RowBox[{"Head", "[", "#2", "]"}]}], "&"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "DeleteDuplicatesTensors", "]"}], 
    ";"}]}]}]], "Code",
 CellChangeTimes->{{3.9497674453212204`*^9, 3.949767465803667*^9}, {
  3.951219004792255*^9, 3.95121900877644*^9}},
 CellLabel->
  "In[481]:=",ExpressionUUID->"cace8558-d9fc-7b44-ae70-3c952c95beb1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". HeadOfTensor2"
}], "Subsection",
 CellChangeTimes->{3.932387283337832*^9, 3.932717004562273*^9, 
  3.948391796726907*^9},ExpressionUUID->"0e3d669c-272a-7a4f-8a9b-\
32662fdf2ad4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Extracts", " ", "the", " ", "head", " ", "of", " ", "a", " ", "tensor", " ",
     "even", " ", "if", " ", "it", " ", "is", " ", "zero"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"HeadOfTensor2", "[", "0", "]"}], ":=", "0"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"HeadOfTensor2", "[", "Zero", "]"}], ":=", "Zero"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"HeadOfTensor2", "[", 
     RowBox[{"tensor_", "?", "xTensorQ"}], "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t", "=", 
        RowBox[{"TensorWithIndices", "[", "tensor", "]"}]}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"t", "===", "0"}], ",", "Zero", ",", 
        RowBox[{"HeadOfTensor", "[", 
         RowBox[{"t", ",", 
          RowBox[{"List", "@@", "t"}]}], "]"}]}], "]"}]}], "]"}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "forces", " ", "the", " ", "evaluation", " ", "of", " ", 
     "certain", " ", "expressions", " ", "that", " ", "are", " ", "only", " ",
      "evaluated", " ", "with", " ", "indices", " ", "like", " ", 
     RowBox[{"Inv", "[", "frozenmetric", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"HeadOfTensor2", "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "xTensorQ"}], "[", "indices___", "]"}], "]"}], ":=", 
    RowBox[{"HeadOfTensor2", "[", "tensor", "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "HeadOfTensor2", "]"}], ";"}]}]}]], "Code",
 CellChangeTimes->{{3.9327170064095755`*^9, 3.932717031247394*^9}, {
   3.9327170809691987`*^9, 3.932717132640498*^9}, {3.932717199366937*^9, 
   3.932717244834992*^9}, {3.932717564636577*^9, 3.932717582096564*^9}, {
   3.932728485879007*^9, 3.932728489012789*^9}, {3.932728527244299*^9, 
   3.93272853032378*^9}, {3.932728593129099*^9, 3.932728593347297*^9}, {
   3.933771471119006*^9, 3.933771501685498*^9}, {3.941616162973581*^9, 
   3.941616170243588*^9}, {3.948541840877927*^9, 3.948541844433974*^9}, 
   3.94854223382326*^9, {3.951219064604515*^9, 3.951219066083259*^9}, {
   3.9512193776416397`*^9, 3.951219415725218*^9}, 3.9512194883073807`*^9, {
   3.951232242039633*^9, 3.951232246908377*^9}, {3.9512518297970524`*^9, 
   3.9512518621833572`*^9}, {3.95130925991778*^9, 3.951309271679468*^9}, 
   3.9548540184456177`*^9},
 CellLabel->
  "In[483]:=",ExpressionUUID->"a3e72c13-a7ec-b943-92b4-a88abb32eeed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". CountCovD"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.948391796726907*^9, {
   3.950018782486656*^9, 
   3.950018784068161*^9}},ExpressionUUID->"2c8cbd76-7055-834d-a913-\
e026730e14ae"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Counts", " ", "the", " ", "highest", " ", "number", " ", "of", " ", 
    "nested", " ", "derivatives", " ", "in", " ", "a", " ", "monomial"}], " ",
    "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CountCovD", "[", 
       RowBox[{"der_", "?", "CovDQ"}], "]"}], "[", 
      RowBox[{
       RowBox[{"der_", "[", "a_", "]"}], "[", "rest_", "]"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"CountCovD", "[", "der", "]"}], "[", "rest", "]"}], "+", 
      "1"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CountCovD", "[", 
       RowBox[{"der_", "?", "CovDQ"}], "]"}], "[", 
      RowBox[{"HoldPattern", "[", 
       RowBox[{"WWedge", "[", 
        RowBox[{"expr1_", ",", "expr2_"}], "]"}], "]"}], "]"}], ":=", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"CountCovD", "[", "der", "]"}], "[", "expr1", "]"}], ",", 
       RowBox[{
        RowBox[{"CountCovD", "[", "der", "]"}], "[", "expr2", "]"}]}], 
      "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CountCovD", "[", 
       RowBox[{"der_", "?", "CovDQ"}], "]"}], "[", 
      RowBox[{"expr1_", " ", "expr2_"}], "]"}], ":=", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"CountCovD", "[", "der", "]"}], "[", "expr1", "]"}], ",", 
       RowBox[{
        RowBox[{"CountCovD", "[", "der", "]"}], "[", "expr2", "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CountCovD", "[", 
       RowBox[{"der_", "?", "CovDQ"}], "]"}], "[", "expr_", "]"}], "/;", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"expr", ",", "Plus"}], "]"}]}], ":=", "0"}]}]}]], "Code",
 CellChangeTimes->{{3.949262525087421*^9, 3.9492626220066633`*^9}, {
  3.9492649885921946`*^9, 3.9492650005171633`*^9}, {3.950611948801989*^9, 
  3.950611964713764*^9}, {3.9506120645722103`*^9, 3.95061209532082*^9}, {
  3.95061215368297*^9, 3.950612263432813*^9}, {3.950612343848841*^9, 
  3.9506123453120003`*^9}, {3.950612432475572*^9, 3.950612433102896*^9}, {
  3.950612547614378*^9, 3.950612552021824*^9}, {3.950623951053437*^9, 
  3.950623956453218*^9}, {3.950897512227543*^9, 3.9508975258913097`*^9}},
 CellLabel->
  "In[488]:=",ExpressionUUID->"a2bf5d1a-1b91-4743-b898-c979a125b268"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". splitList"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.948391796726907*^9, {
   3.950018782486656*^9, 3.950018784068161*^9}, 
   3.950033273709875*^9},ExpressionUUID->"f2cda20d-72f9-8f4a-a1c5-\
99bd65d0c99b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "splitList", " ", "takes", " ", "the", " ", "list", " ", "LIST", " ", 
     "of", " ", "elements", " ", "and", " ", "a", " ", "list", " ", "of", " ",
      "orders", " ", "ORDERS", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
       "one", " ", "for", " ", "each", " ", "element", " ", "of", " ", "the", 
        " ", "list"}], ",", " ", 
       RowBox[{"they", " ", "can", " ", "mean", " ", "anything"}]}], ")"}]}], 
    ",", " ", 
    RowBox[{
    "and", " ", "reorders", " ", "LIST", " ", "such", " ", "that", " ", "the",
      " ", "factor", " ", "with", " ", "the", " ", "highest", " ", "order", " ",
      "appears", " ", 
     RowBox[{"last", ".", "\n", "   ", "Everytime"}], " ", "two", " ", 
     "elements", " ", "are", " ", "exchanged", " ", "in", " ", "the", " ", 
     "list"}], ",", " ", 
    RowBox[{"they", " ", 
     RowBox[{"supercommute", ".", " ", "splitList"}], " ", "Adjusts", " ", 
     "the", " ", "overall", " ", "sign", " ", "according", " ", "to", " ", 
     "the", " ", "vertical", " ", "degree", " ", "of", " ", 
     RowBox[{"factors", "."}]}]}], " ", "*)"}], "\n", "   ", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "all", " ", "the", " ", "orders", " ", "are", " ", "zero", " ",
      "and", " ", "ReturnZeroOrError", " ", "is", " ", "set", " ", "to", " ", 
     "Zero"}], ",", " ", 
    RowBox[{"it", " ", "returns", " ", "zero"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"splitList", "[", 
     RowBox[{"list_List", ",", 
      RowBox[{"{", 
       RowBox[{"0", ".."}], "}"}], ",", 
      RowBox[{"ReturnZeroOrError", "->", "Zero"}]}], "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"splitList", "[", 
     RowBox[{"list_List", ",", "orders_List", ",", 
      RowBox[{"option", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"Options", "[", "DivisionWWedge", "]"}], "]"}]}]}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"{", "\n", "\t", 
       RowBox[{
        RowBox[{"currentList", "=", "list"}], ",", "\[IndentingNewLine]", 
        "\t", 
        RowBox[{"sign", "=", "1"}], ",", "\[IndentingNewLine]", "\t", 
        RowBox[{"n", "=", 
         RowBox[{"Length", "[", "list", "]"}]}], ",", "\n", "\t", 
        RowBox[{"maxIndex", "=", 
         RowBox[{"First", "@", 
          RowBox[{"Ordering", "[", 
           RowBox[{"orders", ",", 
            RowBox[{"-", "1"}]}], "]"}]}]}], ",", "\[IndentingNewLine]", "\t",
         "targetElement", ",", "\[IndentingNewLine]", "\t", "currentPos"}], 
       "\n", "\t", "}"}], ",", "\n", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"targetElement", "=", 
        RowBox[{"list", "[", 
         RowBox[{"[", "maxIndex", "]"}], "]"}]}], ";", "\n", "\t", "\n", "\t", 
       RowBox[{"(*", 
        RowBox[{
        "Move", " ", "the", " ", "element", " ", "to", " ", "the", " ", 
         "end"}], "*)"}], "\[IndentingNewLine]", "\t", 
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Position", "[", 
             RowBox[{"currentList", ",", "targetElement", ",", "1"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], "<", "n"}], ")"}], ",", 
         "\[IndentingNewLine]", "\t\t", 
         RowBox[{"(*", 
          RowBox[{"Current", " ", 
           RowBox[{"element", "'"}], "s", " ", "position"}], "*)"}], 
         "\[IndentingNewLine]", "\t\t", 
         RowBox[{
          RowBox[{"currentPos", "=", 
           RowBox[{
            RowBox[{"Position", "[", 
             RowBox[{"currentList", ",", "targetElement", ",", "1"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\t\t", 
          RowBox[{"(*", 
           RowBox[{
           "Swap", " ", "with", " ", "the", " ", "next", " ", "element"}], 
           "*)"}], "\[IndentingNewLine]", "\t\t", 
          RowBox[{"With", "[", "\n", "\t\t\t", 
           RowBox[{
            RowBox[{"{", "\n", "\t\t\t", 
             RowBox[{
              RowBox[{"nextPos", "=", 
               RowBox[{"currentPos", "+", "1"}]}], ",", "\n", "\t\t\t", 
              RowBox[{"swapped1", "=", 
               RowBox[{"currentList", "[", 
                RowBox[{"[", "currentPos", "]"}], "]"}]}], ",", "\n", 
              "\t\t\t", 
              RowBox[{"swapped2", "=", 
               RowBox[{"currentList", "[", 
                RowBox[{"[", 
                 RowBox[{"currentPos", "+", "1"}], "]"}], "]"}]}]}], "\n", 
             "\t\t\t", "}"}], ",", "\n", "\t\t\t", 
            RowBox[{"(*", 
             RowBox[{
             "Update", " ", "sign", " ", "using", " ", "the", " ", "given", " ",
               "rule"}], "*)"}], "\[IndentingNewLine]", "\t\t\t", 
            RowBox[{
             RowBox[{"sign", "*=", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"VertDeg", "[", "swapped1", "]"}], "*", 
                 RowBox[{"VertDeg", "[", "swapped2", "]"}]}], ")"}]}]}], ";", 
             "\[IndentingNewLine]", "\t\t\t", "\n", "\t\t\t", 
             RowBox[{"(*", 
              RowBox[{"Swap", " ", "elements"}], "*)"}], 
             "\[IndentingNewLine]", "\t\t\t", 
             RowBox[{"currentList", "=", 
              RowBox[{"ReplacePart", "[", 
               RowBox[{"currentList", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"currentPos", "->", "swapped2"}], ",", 
                  RowBox[{"nextPos", "->", "swapped1"}]}], "}"}]}], 
               "]"}]}]}]}], "\n", "\t\t", "]"}], ";"}]}], "\n", "\t", "]"}], ";",
        "\[IndentingNewLine]", "\t\t", "\n", "\t", 
       RowBox[{"(*", 
        RowBox[{
        "Return", " ", "the", " ", "modified", " ", "list", " ", "and", " ", 
         "the", " ", "sign"}], "*)"}], "\[IndentingNewLine]", "\t", 
       RowBox[{"{", 
        RowBox[{"orders", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sign", "*", 
            RowBox[{"WWedge", "@@", 
             RowBox[{"Most", "@", "currentList"}]}]}], ",", 
           RowBox[{"list", "[", 
            RowBox[{"[", "maxIndex", "]"}], "]"}]}], "}"}]}], "}"}]}]}], "\n",
      "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.942209175278662*^9, 3.942209186265266*^9}, {
   3.942209488625333*^9, 3.9422095788392158`*^9}, {3.9422096887461977`*^9, 
   3.942209701600259*^9}, {3.9422097982181225`*^9, 3.942209811067749*^9}, {
   3.9422098912261677`*^9, 3.942209905521355*^9}, {3.9422100046121435`*^9, 
   3.942210008546499*^9}, {3.942210385726369*^9, 3.94221043016887*^9}, {
   3.942210860512658*^9, 3.9422109492400837`*^9}, {3.94221098155021*^9, 
   3.94221099027374*^9}, {3.942211034134286*^9, 3.942211086338979*^9}, {
   3.942211252481491*^9, 3.94221133304053*^9}, {3.9422114692769785`*^9, 
   3.942211496937498*^9}, {3.942211668015452*^9, 3.942211690583094*^9}, 
   3.942211732414748*^9, {3.942212096712245*^9, 3.942212097976885*^9}, {
   3.9422128780451574`*^9, 3.942212887332204*^9}, {3.942212961216691*^9, 
   3.942213039002178*^9}, {3.942213082819887*^9, 3.942213115526841*^9}, 
   3.9422131644710865`*^9, {3.942213518620435*^9, 3.94221352080386*^9}, 
   3.9492785574099846`*^9, {3.9492786021503706`*^9, 3.9492786526453795`*^9}, {
   3.9492787344190903`*^9, 3.949278739795149*^9}, 3.949278814567842*^9, {
   3.9492789714879217`*^9, 3.9492789737577324`*^9}, {3.949280845667725*^9, 
   3.949280854241607*^9}, {3.949280902304617*^9, 3.949280964412464*^9}, {
   3.950028993490206*^9, 3.950029064076554*^9}, 3.950282685733587*^9, {
   3.950304083688421*^9, 3.9503040881130905`*^9}, {3.9503041325983047`*^9, 
   3.9503041373337135`*^9}, 3.950304443409046*^9, {3.9503044974448166`*^9, 
   3.950304502045578*^9}, {3.950304533959345*^9, 3.950304542854716*^9}, {
   3.950304609441696*^9, 3.950304620704746*^9}, {3.950304669524898*^9, 
   3.950304706796438*^9}, {3.950304851435416*^9, 3.950304921060772*^9}, {
   3.9503049699760513`*^9, 3.950305033338567*^9}, {3.950305112638283*^9, 
   3.9503051265764027`*^9}, {3.9503051720921288`*^9, 3.950305179024877*^9}, {
   3.950305240494919*^9, 3.950305242394419*^9}, {3.950305578388248*^9, 
   3.950305607262636*^9}, {3.9503086382997723`*^9, 3.9503086386376953`*^9}, {
   3.950612574528339*^9, 3.9506125748355637`*^9}, {3.950612604926884*^9, 
   3.950612622361372*^9}, {3.950622185190819*^9, 3.950622197181278*^9}, {
   3.950622299181612*^9, 3.950622354969187*^9}, 3.950897929662737*^9, {
   3.950898089812498*^9, 3.950898090935543*^9}, {3.950898192900243*^9, 
   3.9508981930744*^9}, {3.951219578269379*^9, 3.951219578657057*^9}, {
   3.951219781902916*^9, 3.9512198091379433`*^9}, {3.951220295248394*^9, 
   3.951220298359148*^9}, {3.951222422766083*^9, 3.951222422893182*^9}},
 CellLabel->
  "In[492]:=",ExpressionUUID->"93ab0f2f-9e00-2849-b211-3060767fb01a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". splitFactors"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.948391796726907*^9, {
   3.950018782486656*^9, 3.950018784068161*^9}, {3.950033273709875*^9, 
   3.950033279970419*^9}},ExpressionUUID->"39975e23-9bc0-6448-b0ac-\
4a2430b73756"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Converts", " ", "a", " ", "product", " ", "of", " ", "WWedge", " ", "and",
     " ", "Times", " ", "into", " ", "a", " ", "list"}], " ", "*)"}], " ", 
  "\n", 
  RowBox[{
   RowBox[{"splitFactors", "[", "expr_", "]"}], ":=", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Head", "[", "expr", "]"}], "===", "WWedge"}], "||", 
       RowBox[{
        RowBox[{"Head", "[", "expr", "]"}], "===", "Times"}]}], ",", 
      RowBox[{"splitFactors", "/@", 
       RowBox[{"List", "@@", "expr"}]}], ",", 
      RowBox[{"{", "expr", "}"}]}], "]"}], "//", "Flatten"}]}]}]], "Code",
 CellChangeTimes->{{3.949267297586529*^9, 3.949267328373677*^9}, 
   3.9492673753054657`*^9, {3.949270428020359*^9, 3.9492704420844593`*^9}, {
   3.9492706762880225`*^9, 3.949270678316321*^9}, {3.949270736679161*^9, 
   3.949270750937032*^9}, {3.950029082021307*^9, 3.9500290958386383`*^9}, {
   3.9512202889284115`*^9, 3.9512202917672997`*^9}, {3.951222420581693*^9, 
   3.951222420758136*^9}},
 CellLabel->
  "In[494]:=",ExpressionUUID->"ea0fda6d-a5dd-0a4f-84be-17d483aa17e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". PositionOfElement"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.948391796726907*^9, {
   3.950018782486656*^9, 3.950018784068161*^9}, {3.950033273709875*^9, 
   3.9500333047137814`*^9}},ExpressionUUID->"700dbbfd-84af-0a4d-a36b-\
f8c54db1eac2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PositionOfElement", "::", "WrongDivision"}], 
    "=", "\"\<Wrong WWedge division\>\""}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"position", " ", "takes", " ", "a", " ", "list"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["elem", "1"], ",", 
         SubscriptBox["elem", "2"], ",", 
         RowBox[{
          SubscriptBox["elem", "3"], "..."}]}], "}"}], " ", "and", " ", "an", 
       " ", "elem", " ", "and", " ", "returns", " ", "a", " ", "list", " ", 
       "of", " ", 
       RowBox[{"0", "'"}], "s", " ", "and", " ", 
       RowBox[{"1", "'"}], "s", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", 
          RowBox[{"0", ".."}]}], "}"}], ".", " ", "The"}], " ", "1", " ", 
       "is", " ", "placed", " ", "in", " ", "the", " ", "j"}], "-", 
      RowBox[{"th", " ", "position"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"where", " ", 
      SubscriptBox["elem", "j"]}], "=", 
     RowBox[{"elem", " ", 
      RowBox[{"(", 
       RowBox[{"equality", " ", "with", " ", "indices", " ", "included"}], 
       ")"}]}]}]}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"PositionOfElement", "[", 
   RowBox[{"list_List", ",", "elem_", ",", 
    RowBox[{"option", ":", 
     RowBox[{"OptionsPattern", "[", 
      RowBox[{"Options", "[", "DivisionWWedge", "]"}], "]"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"positionvector", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Boole", "[", 
          RowBox[{"#", "===", "elem"}], "]"}], "&"}], ",", "list"}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Total", "@", "positionvector"}], "=!=", "1"}], "&&", 
        RowBox[{
         RowBox[{"OptionValue", "[", "ReturnZeroOrError", "]"}], "===", 
         "Error"}]}], ",", 
       RowBox[{"Throw", "[", 
        RowBox[{"Message", "[", 
         RowBox[{
          StyleBox[
           RowBox[{"PositionOfElement", "::", "WrongDivision"}], 
           "MessageName"], ",", "\"\<Wrong WWedge division\>\""}], "]"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", "\t", 
     "positionvector"}]}], "]"}]}]}], "Code",
 CellChangeTimes->{
  3.950029441428425*^9, {3.9500295197793713`*^9, 3.9500295202332764`*^9}, {
   3.95002955181832*^9, 3.950029651253708*^9}, {3.950031147488676*^9, 
   3.950031160227099*^9}, {3.9500330732713146`*^9, 3.950033091626402*^9}, {
   3.950033145861353*^9, 3.950033147452416*^9}, {3.95062191290256*^9, 
   3.9506219183233776`*^9}, {3.950622000821337*^9, 3.950622082406439*^9}, 
   3.950622131740742*^9, 3.950622599095686*^9, {3.951220284201898*^9, 
   3.9512202862072906`*^9}, {3.951220342889923*^9, 3.951220352118492*^9}, {
   3.9512224188774433`*^9, 3.951222419036939*^9}, {3.953055084430887*^9, 
   3.953055104790495*^9}, {3.953055442983635*^9, 3.953055469336195*^9}, 
   3.9557165762224007`*^9, 3.955716641054247*^9, 3.9557167915061455`*^9, {
   3.9571927703923035`*^9, 3.957192794363001*^9}, 3.9572770652207813`*^9, 
   3.957277219732115*^9, 3.9583128420602016`*^9},
 CellLabel->
  "In[495]:=",ExpressionUUID->"87ad89b5-0bcd-1d4c-b6e5-aaed5816470e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". adding"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.948391796726907*^9, {
   3.950018782486656*^9, 3.950018784068161*^9}, {3.950033273709875*^9, 
   3.950033302541086*^9}},ExpressionUUID->"95b0dbfe-3a68-4041-9613-\
31e7bfb7425c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Allows", " ", "to", " ", "sum", " ", "the", " ", "elements", " ", "of", " ",
      "a", " ", 
     RowBox[{"list", ".", " ", "If"}], " ", "the", " ", "expression", " ", 
     "is", " ", "not", " ", "a", " ", "list", " ", "but", " ", "a", " ", 
     "single", " ", "element"}], ",", " ", 
    RowBox[{"it", " ", "returns", " ", "the", " ", 
     RowBox[{"element", ".", " ", "Notice"}], " ", "that", " ", 
     RowBox[{"Total", "[", 
      RowBox[{"v1", "[", 
       RowBox[{"a", ",", "b"}], "]"}], "]"}], " ", 
     RowBox[{"doesn", "'"}], "t", " ", "work", " ", "as", " ", 
     RowBox[{"expected", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"adding", "[", "x_List", "]"}], ":=", 
   RowBox[{"Total", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"{", "x", "}"}], "]"}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.949270803108255*^9, {3.9500293519005604`*^9, 3.950029378905415*^9}, {
   3.951220276363222*^9, 3.951220280962143*^9}, {3.951220917104925*^9, 
   3.951220925570669*^9}, 3.9512212383244762`*^9, {3.951222417083862*^9, 
   3.951222417226639*^9}},
 CellLabel->
  "In[497]:=",ExpressionUUID->"7aebcd7f-7270-784e-8c6c-ae0a32370782"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". SumToList"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.948391796726907*^9, {
   3.950018782486656*^9, 3.950018784068161*^9}, {3.950033273709875*^9, 
   3.9500333009196377`*^9}},ExpressionUUID->"25bc6ee8-2107-e145-b843-\
19e1e7dbbfe6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Converts", " ", "a", " ", "sum", " ", "into", " ", "a", " ", "list", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
      "if", " ", "there", " ", "is", " ", "only", " ", "one", " ", "term"}], ",",
       " ", 
      RowBox[{
      "it", " ", "turns", " ", "it", " ", "into", " ", "a", " ", "list", " ", 
       "as", " ", "well"}]}], ")"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"SumToList", "[", "x_Plus", "]"}], ":=", 
    RowBox[{"List", "@@", "x"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SumToList", "[", "x_", "]"}], ":=", 
    RowBox[{"Flatten", "[", 
     RowBox[{"{", "x", "}"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.950031159326706*^9, 3.950031159501316*^9}, {
  3.9512202713207035`*^9, 3.9512202746894493`*^9}, {3.951221035796779*^9, 
  3.951221068809513*^9}, {3.951222415554743*^9, 3.951222415827299*^9}},
 CellLabel->
  "In[498]:=",ExpressionUUID->"b8f8e88b-a69f-0b49-980b-f8f81fffabec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". DivisionWWedge"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.948391796726907*^9, {
   3.950018782486656*^9, 3.950018784068161*^9}, {3.950033273709875*^9, 
   3.9500332995144596`*^9}},ExpressionUUID->"72fdf639-6378-b548-8869-\
b10200dc98b3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "DivisionWWedge", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{"ReturnZeroOrError", "->", "Error"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"This", " ", "is", " ", "the", " ", "normal", " ", "division", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"used", " ", "in", " ", "IndexCoefficient"}], ")"}], ".", " ", 
     "elem"}], " ", "must", " ", "be", " ", "an", " ", "element", " ", "of", " ",
     "expr", " ", 
    RowBox[{"(", 
     RowBox[{"with", " ", "the", " ", "same", " ", 
      RowBox[{"indices", "!"}]}], ")"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DivisionWWedge", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"elem_", "?", "ZeroVertDegQ"}]}], "]"}], ":=", 
   FractionBox["expr", "elem"]}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "is", " ", "the", " ", "division", " ", "whenever", " ", 
     "elem", " ", "is", " ", "inside", " ", "a", " ", "WWedge", " ", "within",
      " ", 
     RowBox[{"expr", ".", " ", "DivisionWWedge"}], " ", "first", " ", "turn", 
     " ", "the", " ", "product", " ", "into", " ", "a", " ", "list"}], ",", 
    " ", 
    RowBox[{
    "then", " ", "moves", " ", "elem", " ", "to", " ", "the", " ", "end", " ",
      "of", " ", "the", " ", "list", " ", 
     RowBox[{"(", 
      RowBox[{"division", " ", "by", " ", "the", " ", "right"}], ")"}]}], ",",
     " ", 
    RowBox[{"and", " ", "then", " ", "removes", " ", "it"}]}], " ", "*)"}], 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "the", " ", "element", " ", "is", " ", "not", " ", "there"}], ",",
     " ", 
    RowBox[{
     RowBox[{
     "it", " ", "returns", " ", "an", " ", "error", " ", "unless", " ", 
      "ReturnZeroOrError"}], "->", "Zero"}], ",", " ", 
    RowBox[{"which", " ", "returns", " ", "0"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"DivisionWWedge", "[", 
   RowBox[{"expr_", ",", "elem_", ",", 
    RowBox[{"option", ":", 
     RowBox[{"OptionsPattern", "[", 
      RowBox[{"Options", "[", "DivisionWWedge", "]"}], "]"}]}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"list", "=", 
      RowBox[{"splitFactors", "[", "expr", "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"splitList", "[", 
       RowBox[{"list", ",", 
        RowBox[{"PositionOfElement", "[", 
         RowBox[{"list", ",", "elem", ",", "option"}], "]"}], ",", "option"}],
        "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "Code",
 CellChangeTimes->{{3.9500311580356655`*^9, 3.950031158776507*^9}, 
   3.950033092803007*^9, 3.950033148311419*^9, 3.950282718945378*^9, {
   3.950308620263038*^9, 3.9503086639749317`*^9}, {3.9506126525066566`*^9, 
   3.950612757663414*^9}, {3.950621163410269*^9, 3.9506212094688663`*^9}, {
   3.950621326325168*^9, 3.9506213706182423`*^9}, {3.9506219026741085`*^9, 
   3.950621902826073*^9}, 3.950622167263574*^9, {3.950622507135231*^9, 
   3.9506225084490604`*^9}, {3.950622543437702*^9, 3.9506225533160954`*^9}, {
   3.9512202652940598`*^9, 3.951220269072737*^9}, {3.951221085418714*^9, 
   3.951221130121143*^9}, 3.9512224116919785`*^9, {3.9514115100553074`*^9, 
   3.951411510602457*^9}},
 CellLabel->
  "In[500]:=",ExpressionUUID->"ff6238cc-cb49-4d40-a2bf-cd6127a5c161"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Generate tensors\[CloseCurlyQuote] names"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.948391826208047*^9, 3.9500107741427097`*^9, {
   3.955364014781782*^9, 3.9553640197713604`*^9}, {3.958648148425495*^9, 
   3.958648149862936*^9}, 3.958648182021654*^9, {3.9586482518186436`*^9, 
   3.958648259903532*^9}},ExpressionUUID->"e640fac5-55ba-994d-aa47-\
100892ccfe65"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". GenerateDiffName"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084732501661*^9, {
   3.950018330882505*^9, 3.950018335540764*^9}, {3.950018415709163*^9, 
   3.950018426310283*^9}, {3.95001850630357*^9, 3.950018512721945*^9}, 
   3.950123083040518*^9, {3.9501232955061016`*^9, 3.950123309954813*^9}, {
   3.9501235754431705`*^9, 3.950123578180691*^9}, 3.9573682621193047`*^9, 
   3.9586405627881794`*^9, 3.9586482324140377`*^9, 
   3.9606563052764244`*^9},ExpressionUUID->"c01c20e6-379f-bc47-af87-\
8c831d04790c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "function", " ", "generates", " ", "the", " ", "names", " ", 
    "and", " ", "PrintAs", " ", "of", " ", "dltensors"}], " ", "*)"}], " ", 
  "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "GenerateDiffName", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PrintAs", "->", "None"}], ",", 
       RowBox[{"PrintInverse", "->", "False"}]}], "}"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GenerateDiffName", "[", 
      RowBox[{"form_", ",", 
       RowBox[{"opts", ":", 
        RowBox[{"OptionsPattern", "[", 
         RowBox[{"Options", "[", "GenerateDiffName", "]"}], "]"}]}]}], "]"}], 
     ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"TensorName", ",", "prefix", ",", "printName", ",", "print"}],
         "}"}], ",", "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{"TensorName", "=", 
         RowBox[{"ToString", "[", 
          RowBox[{"form", ",", "InputForm"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\t", 
        RowBox[{"printName", "=", 
         RowBox[{"RemoveOuterParanthesis", "[", 
          RowBox[{
           RowBox[{"OptionValue", "[", "PrintAs", "]"}], "/.", " ", 
           RowBox[{"{", 
            RowBox[{"None", "->", "TensorName"}], "}"}]}], "]"}]}], ";", "\n",
         "\t", "\[IndentingNewLine]", "\t", 
        RowBox[{"(*", 
         RowBox[{
         "Adjust", " ", "the", " ", "prefix", " ", "for", " ", "the", " ", 
          "inverse", " ", "case", " ", "if", " ", "not", " ", "overridden"}], 
         "*)"}], "\[IndentingNewLine]", "\t", 
        RowBox[{"prefix", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OptionValue", "[", "PrintInverse", "]"}], ",", 
           RowBox[{"$NameVerticalExteriorDerivative", "<>", "\"\<Inv\>\""}], ",",
            "$NameVerticalExteriorDerivative"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", "\t", 
        RowBox[{"print", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OptionValue", "[", "PrintInverse", "]"}], ",", "\n", 
           "\t        ", 
           RowBox[{"StringJoin", "[", 
            RowBox[{"$SymbolVerticalExteriorDerivative", ",", "\"\<(\>\"", ",", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"Superscript", "[", 
                RowBox[{"printName", ",", "\"\<-1\>\""}], "]"}], ",", 
               "StandardForm"}], "]"}], ",", "\"\<)\>\""}], "]"}], ",", "\n", 
           "\t\t\t", 
           RowBox[{"StringJoin", "[", 
            
            RowBox[{"\"\<(\>\"", ",", "$SymbolVerticalExteriorDerivative", ",",
              "printName", ",", "\"\<)\>\""}], "]"}]}], "\n", "\t\t\t", 
          "]"}]}], ";", "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", 
        "\t", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"StringJoin", "[", 
            RowBox[{"prefix", ",", "TensorName"}], "]"}], "]"}], ",", 
          "print"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}]}]}]], "Code",
 CellChangeTimes->{
  3.9323872937478504`*^9, 3.932522556825685*^9, {3.932550068578199*^9, 
   3.932550076042243*^9}, {3.93263699495908*^9, 3.932636995965446*^9}, {
   3.93271127160318*^9, 3.932711378426875*^9}, {3.932718317703639*^9, 
   3.932718336831459*^9}, {3.949687993027954*^9, 3.949687996349277*^9}, 
   3.9496880405718136`*^9, {3.950010756156599*^9, 3.95001075648272*^9}, {
   3.9500112916713295`*^9, 3.950011304010219*^9}, {3.950288450699659*^9, 
   3.9502884525470314`*^9}, {3.950288484266525*^9, 3.95028851394515*^9}, {
   3.9502885558231773`*^9, 3.950288684217151*^9}, {3.9502887227644196`*^9, 
   3.950288798834001*^9}, {3.950288872103061*^9, 3.9502889253817177`*^9}, {
   3.9506127687151546`*^9, 3.950612801787809*^9}, 3.951218991676023*^9, 
   3.951222407336361*^9, 3.9514115151108093`*^9, {3.955203577280756*^9, 
   3.9552036152831173`*^9}, {3.9552038069921436`*^9, 3.955203880039833*^9}, {
   3.955204058550192*^9, 3.9552040796910095`*^9}, {3.9552045410066204`*^9, 
   3.9552045412067356`*^9}, {3.9552046097124424`*^9, 
   3.9552046566135406`*^9}, {3.9552075863460045`*^9, 
   3.9552077200570297`*^9}, {3.955207923740156*^9, 3.9552079238667946`*^9}, {
   3.955207974885025*^9, 3.955207982775423*^9}, {3.955478162332161*^9, 
   3.955478173420759*^9}, {3.955485899800417*^9, 3.9554859397793217`*^9}, {
   3.9555566545442486`*^9, 3.95555671880768*^9}, {3.955556894721081*^9, 
   3.9555570436916504`*^9}, {3.9557087846478233`*^9, 
   3.9557088122408333`*^9}, {3.9572044895820065`*^9, 3.957204506129328*^9}, {
   3.9572049396638565`*^9, 3.9572049712083817`*^9}, {3.957205026398382*^9, 
   3.957205028110937*^9}, {3.9572052017902126`*^9, 3.9572052237956486`*^9}, {
   3.9572052637481766`*^9, 3.957205290061886*^9}, {3.9572053269164944`*^9, 
   3.957205329347328*^9}, {3.9572054063098145`*^9, 3.957205408383915*^9}, {
   3.9572054438941326`*^9, 3.9572054684412804`*^9}, {3.9572097264011097`*^9, 
   3.957209737471588*^9}, {3.9573258499137974`*^9, 3.957325851433113*^9}, {
   3.960553124650297*^9, 
   3.960553141656023*^9}},ExpressionUUID->"f7055bc3-cd60-4245-a0ee-\
2d4939e02937"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". GenerateVariationalName"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084732501661*^9, {
   3.950018330882505*^9, 3.950018335540764*^9}, {3.950018415709163*^9, 
   3.950018426310283*^9}, {3.95001850630357*^9, 3.950018512721945*^9}, 
   3.950123083040518*^9, {3.9501232955061016`*^9, 3.950123309954813*^9}, {
   3.9501235754431705`*^9, 3.950123578180691*^9}, 3.9573682621193047`*^9, 
   3.9586405627881794`*^9, {3.9586482324140377`*^9, 3.9586482369859753`*^9}, 
   3.9606563032383423`*^9},ExpressionUUID->"84b61e5e-8524-3d4a-8ad4-\
ef74616bc47d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"$RemoveParenthesesPrintAs", ":=", "True"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RemoveOuterParanthesis", "[", "string_", "]"}], "/;", 
    "$RemoveParenthesesPrintAs"}], ":=", 
   RowBox[{"Module", "[", "\n", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", "=", 
       RowBox[{"StringReplace", "[", 
        RowBox[{
         RowBox[{"StringReplace", "[", 
          RowBox[{"string", ",", "  ", 
           
           RowBox[{"\"\<TeXAssistantTemplate\\\"]\\))\>\"", " ", ":>", 
            " ", "\"\<TeXAssistantTemplate\\\"]\\)\>\""}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"StartOfString", " ", "~~", " ", "\"\<\\!\\((\>\""}], " ", ":>",
           " ", "\"\<\\!\\(\>\""}]}], "]"}]}], "}"}], ",", "\n", "\t", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"StringMatchQ", "[", 
        RowBox[{"s", ",", 
         RowBox[{"\"\<(\>\"", "~~", "___", "~~", "\"\<)\>\""}]}], "]"}], ",", 
       RowBox[{"StringTake", "[", 
        RowBox[{"s", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "2"}]}], "}"}]}], "]"}], ",", "\n", "\t", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s", "=", 
          RowBox[{"StringReplace", "[", 
           RowBox[{"s", ",", 
            RowBox[{
             RowBox[{"StartOfString", "~~", "\"\<(\>\""}], 
             ":>", "\"\<\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", "\t", 
         RowBox[{"s", "=", 
          RowBox[{"StringReplace", "[", 
           RowBox[{"s", ",", 
            RowBox[{
             RowBox[{"\"\<)\>\"", "~~", "EndOfString"}], ":>", "\"\<\>\""}]}],
            "]"}]}], ";", "\[IndentingNewLine]", "\t", "s"}], ")"}]}], 
      "]"}]}], "\n", "]"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveOuterParanthesis", "[", "string_", "]"}], "/;", 
   RowBox[{"!", "$RemoveParenthesesPrintAs"}]}], ":=", "string"}]}], "Code",
 CellChangeTimes->{{3.9572041326813927`*^9, 3.9572042984518414`*^9}, {
   3.957204399811037*^9, 3.9572044770610485`*^9}, {3.9572046800184727`*^9, 
   3.957204695639765*^9}, {3.957205100286333*^9, 3.957205102944828*^9}, {
   3.957205520354393*^9, 3.9572055337116375`*^9}, {3.957205577581972*^9, 
   3.957205585931576*^9}, {3.9572056698741226`*^9, 3.9572056850576878`*^9}, {
   3.9572057704007397`*^9, 3.9572058350997295`*^9}, {3.9572085249910507`*^9, 
   3.9572085537223797`*^9}, {3.9572086001770115`*^9, 
   3.9572086003330727`*^9}, {3.957209236119631*^9, 3.957209241263788*^9}, {
   3.9572095348871136`*^9, 3.9572095543076115`*^9}, {3.957209584876421*^9, 
   3.957209598075411*^9}, 3.9572096613416615`*^9, 3.957209804740473*^9, {
   3.9572772157197495`*^9, 3.957277217466137*^9}, {3.957362088966961*^9, 
   3.957362120640421*^9}, {3.9573623095724545`*^9, 3.9573623101101627`*^9}, {
   3.957363564717926*^9, 3.9573635781650486`*^9}},
 CellLabel->
  "In[505]:=",ExpressionUUID->"244a4091-706d-a145-8965-daa967b505d0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "GenerateVariationalName", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PrintAs", "->", "None"}], ",", 
      RowBox[{"PrintInverse", "->", "False"}]}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "function", " ", "generates", " ", "the", " ", "names", " ", 
    "and", " ", "PrintAs", " ", "of", " ", "VariationalVectortensors"}], " ", 
   "*)"}], " "}], "\n", 
 RowBox[{
  RowBox[{"GenerateVariationalName", "[", 
   RowBox[{"tensor_", ",", 
    RowBox[{"opts", ":", 
     RowBox[{"OptionsPattern", "[", 
      RowBox[{"Options", "[", "GenerateVariationalName", "]"}], "]"}]}]}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"TensorName", ",", "printName"}], "}"}], ",", "\n", "\n", "    ", 
    RowBox[{
     RowBox[{"TensorName", " ", "=", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"OptionValue", "[", "PrintInverse", "]"}], ",", 
        RowBox[{"\"\<VariationalVectorInv\>\"", " ", "<>", " ", 
         RowBox[{"ToString", "@", "tensor"}]}], ",", 
        RowBox[{"\"\<VariationalVector\>\"", " ", "<>", " ", 
         RowBox[{"ToString", "@", "tensor"}]}]}], "]"}]}], ";", "\n", "    ", 
     RowBox[{"printName", " ", "=", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"OptionValue", "[", "PrintInverse", "]"}], ",", 
        RowBox[{"\"\<(\\!\\(\\*FractionBox[\\(\[Delta]\\), \\(\[Delta]\>\"", 
         " ", "<>", " ", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"Superscript", "[", 
            RowBox[{
             RowBox[{"RemoveOuterParanthesis", "@", 
              RowBox[{"PrintAs", "@", "tensor"}]}], ",", "\"\<-1\>\""}], 
            "]"}], ",", "StandardForm"}], "]"}], " ", "<>", 
         " ", "\"\<\\)]\\))\>\""}], ",", 
        RowBox[{"\"\<(\\!\\(\\*FractionBox[\\(\[Delta]\\), \\(\[Delta]\>\"", 
         " ", "<>", " ", 
         RowBox[{"RemoveOuterParanthesis", "@", 
          RowBox[{"PrintAs", "@", "tensor"}]}], " ", "<>", 
         " ", "\"\<\\)]\\))\>\""}]}], "]"}]}], ";", "\n", "\t", "\n", "\t", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ToExpression", "[", "TensorName", "]"}], ",", "printName"}], 
      "}"}]}]}], "\n", "]"}]}]}], "Code",
 CellChangeTimes->{{3.9557088182286167`*^9, 3.9557088277906*^9}, {
  3.957204517084238*^9, 3.9572045400368347`*^9}, {3.9572045741315193`*^9, 
  3.9572045971958504`*^9}},
 CellLabel->
  "In[508]:=",ExpressionUUID->"f5e10156-c8da-7e41-a8eb-8e6297b42a13"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". GeneratePartialPartialName"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084732501661*^9, {
   3.950018330882505*^9, 3.950018335540764*^9}, {3.950018415709163*^9, 
   3.950018426310283*^9}, {3.95001850630357*^9, 3.950018512721945*^9}, 
   3.950123083040518*^9, {3.9501232955061016`*^9, 3.950123309954813*^9}, {
   3.9501235754431705`*^9, 3.950123578180691*^9}, 3.9573682621193047`*^9, 
   3.9586405627881794`*^9, {3.9586482324140377`*^9, 3.9586482443894978`*^9}, 
   3.9606563016653976`*^9},ExpressionUUID->"f4d96826-1083-714c-ba1d-\
ab2c89706585"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConsecutiveCounts", "[", "list_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"Length", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Split", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"{", "list", "}"}], "]"}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"SuperScriptPartial", "[", "1", "]"}], 
  ":=", "\"\<\[PartialD]\>\""}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SuperScriptPartial", "[", 
   RowBox[{"n_", "?", "IntegerQ"}], "]"}], ":=", 
  RowBox[{"ToString", "[", 
   RowBox[{
    RowBox[{"Superscript", "[", 
     RowBox[{"\"\<\[PartialD]\>\"", ",", 
      RowBox[{"ToString", "@", "n"}]}], "]"}], ",", "StandardForm"}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"RepeatedPartial", "[", "1", "]"}], ":=", "\"\<\>\""}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RepeatedPartial", "[", 
    RowBox[{"n_", "?", "IntegerQ"}], "]"}], ":=", 
   RowBox[{"ToString", "[", "n", "]"}]}], "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "function", " ", "generates", " ", "the", " ", "names", " ", 
    "and", " ", "PrintAs", " ", "of", " ", "PartialPartial"}], " ", "*)"}], 
  " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "GeneratePartialPartialName", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PrintAs", "->", "None"}], ",", 
      RowBox[{"PrintInverse", "->", "False"}]}], "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"InvName", "[", 
   RowBox[{"tensor_", ",", 
    RowBox[{"opts", ":", 
     RowBox[{"OptionsPattern", "[", 
      RowBox[{"Options", "[", "GeneratePartialPartialName", "]"}], "]"}]}]}], 
   "]"}], ":=", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"OptionValue", "[", "PrintInverse", "]"}], "&&", 
      RowBox[{"MetricQ", "[", "tensor", "]"}]}], ",", " ", "\"\<Inv\>\"", 
     "  ", ",", "\"\<\>\""}], "]"}], "<>", 
   RowBox[{"ToString", "[", 
    RowBox[{"tensor", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MultiplyHead", "[", 
        RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}], 
    "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ConcatenatePartialTensorsName", "[", 
    RowBox[{"list_", ",", 
     RowBox[{"opts", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"Options", "[", "GeneratePartialPartialName", "]"}], "]"}]}]}],
     "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"StringJoin", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"\"\<Partial\>\"", " ", "<>", " ", 
          RowBox[{"RepeatedPartial", "[", 
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", " ", 
          RowBox[{"InvName", "[", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "opts"}], "]"}]}], "&"}], "/@", 
        RowBox[{"ConsecutiveCounts", "[", "list", "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"StringJoin", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"SuperScriptPartial", "[", 
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "  ", "<>", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"OptionValue", "[", "PrintInverse", "]"}], "&&", 
             RowBox[{"MetricQ", "[", 
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", " ", 
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Superscript", "[", 
               RowBox[{
                RowBox[{"RemoveOuterParanthesis", "[", 
                 RowBox[{"PrintAs", "[", 
                  RowBox[{"Evaluate", "[", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "]"}], 
                ",", "\"\<-1\>\""}], "]"}], ",", "StandardForm"}], "]"}], " ",
             ",", " ", 
            RowBox[{"RemoveOuterParanthesis", "@", 
             RowBox[{"PrintAs", "[", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "//", "Evaluate"}], "]"}]}]}],
            " ", "]"}]}], "&"}], "/@", 
        RowBox[{"ConsecutiveCounts", "[", "list", "]"}]}], ")"}]}]}], "}"}]}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{"GeneratePartialPartialName", "[", 
   RowBox[{"function_", ",", "tensors_", ",", 
    RowBox[{"opts", ":", 
     RowBox[{"OptionsPattern", "[", 
      RowBox[{"Options", "[", "GeneratePartialPartialName", "]"}], "]"}]}]}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"aux", ",", "length", ",", "TensorName", ",", "printName"}], 
     "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"length", "=", 
      RowBox[{"Length", "@", "tensors"}]}], ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"aux", "=", 
      RowBox[{"ConcatenatePartialTensorsName", "[", 
       RowBox[{"tensors", ",", "opts"}], "]"}]}], ";", "\n", "    ", 
     RowBox[{"TensorName", " ", "=", " ", 
      RowBox[{"\"\<Partial\>\"", " ", "<>", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"length", ">", "1"}], ",", 
         RowBox[{"ToString", "@", "length"}], ",", "\"\<\>\""}], "]"}], " ", "<>",
        " ", 
       RowBox[{"ToString", "@", "function"}], " ", "<>", "  ", 
       RowBox[{"aux", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}]}], ";", "\n", "    ", 
     RowBox[{"printName", " ", "=", " ", 
      RowBox[{"\"\<(\\!\\(\\*FractionBox[\\(\>\"", "<>", " ", 
       RowBox[{"SuperScriptPartial", "[", "length", "]"}], 
       "<>", "\"\<\\!\\(\\*StyleBox[\\\"\[NegativeVeryThinSpace]\\\", \
\\\"Text\\\"]\\)\>\"", "<>", 
       RowBox[{"PrintAs", "@", "function"}], "<>", "\"\<\\), \\(\>\"", " ", "<>",
        " ", 
       RowBox[{"aux", "[", 
        RowBox[{"[", "2", "]"}], "]"}], " ", "<>", 
       " ", "\"\<\\)]\\))\>\""}]}], ";", "\n", "    ", "\n", "\t", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ToExpression", "[", "TensorName", "]"}], ",", "printName"}], 
      "}"}]}]}], "\n", "]"}]}]}], "Code",
 CellChangeTimes->{{3.9557088358669243`*^9, 3.9557088453897305`*^9}, {
   3.955709848691925*^9, 3.95570986766453*^9}, {3.9557098998773537`*^9, 
   3.9557099181451416`*^9}, {3.9557280721683197`*^9, 3.95572820875642*^9}, {
   3.955729666716818*^9, 3.955729702341547*^9}, {3.95572978209671*^9, 
   3.9557299192889423`*^9}, {3.9557367221960297`*^9, 3.955736743740408*^9}, {
   3.9557367846857567`*^9, 3.9557367942393303`*^9}, {3.9557368470586433`*^9, 
   3.955736847240679*^9}, {3.9557369354483337`*^9, 3.9557369366305294`*^9}, {
   3.957204566323532*^9, 3.9572045678774815`*^9}, {3.957204650355913*^9, 
   3.957204651704727*^9}, {3.957204823147562*^9, 3.957204832050867*^9}, {
   3.9584139576844673`*^9, 3.9584139772548695`*^9}, {3.958414330549265*^9, 
   3.9584143602283363`*^9}, {3.9584144378274727`*^9, 
   3.9584144695966873`*^9}, {3.95841488299823*^9, 3.9584148832228603`*^9}, {
   3.958415092329878*^9, 3.958415125073801*^9}, {3.958415278548258*^9, 
   3.958415284504013*^9}, {3.9584166966554756`*^9, 3.9584167142774525`*^9}, {
   3.958436693203266*^9, 3.958436749454708*^9}, 3.958438002062525*^9, {
   3.960547021169548*^9, 
   3.960547022459961*^9}},ExpressionUUID->"5a63fd31-468c-f847-8851-\
659a2582cb9a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". MakeVertRule"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400376854912*^9, 3.9484004026179485`*^9}, 
   3.948400497927945*^9},ExpressionUUID->"80ea767e-d6a4-424e-8fe8-\
97c1b42c35ff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "function", " ", "creates", " ", "a", " ", "rule", " ", "and",
     " ", "the", " ", "corresponding", " ", "rule", " ", "for", " ", "their", 
    " ", "dltensors", " ", 
    RowBox[{"(", 
     RowBox[{"linearized", " ", "rule"}], ")"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "MakeVertRule", "]"}], ":=", 
     RowBox[{
      RowBox[{"Options", "[", "MakeRule", "]"}], "~", "Join", "~", 
      RowBox[{"Options", "[", "ExpandVertDiff", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MakeVertRule", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lhs_", ",", "rhs_"}], "}"}], ",", 
      RowBox[{"opts", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"Options", "[", "MakeVertRule", "]"}], "]"}]}]}], "]"}], ":=", 
    RowBox[{"With", "[", "\n", "\t", 
     RowBox[{
      RowBox[{"{", "\n", "\t", 
       RowBox[{
        RowBox[{"opts1", "=", 
         RowBox[{"FilterRules", "[", 
          RowBox[{
           RowBox[{"{", "opts", "}"}], ",", 
           RowBox[{"Options", "[", "MakeRule", "]"}]}], "]"}]}], ",", "\n", 
        "\t", 
        RowBox[{"opts2", "=", 
         RowBox[{"FilterRules", "[", 
          RowBox[{
           RowBox[{"{", "opts", "}"}], ",", 
           RowBox[{"Options", "[", "ExpandVertDiff", "]"}]}], "]"}]}]}], "\n",
        "\t", "}"}], ",", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"MakeRule", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lhs", ",", "rhs"}], "}"}], ",", "opts1"}], "]"}], "~", 
       "Join", "~", 
       RowBox[{"MakeRule", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"VertDiff", "[", "lhs", "]"}], "]"}], ",", 
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"VertDiff", "[", "rhs", "]"}], "//", 
             RowBox[{"ExpandVertDiff", "[", "opts2", "]"}]}], "]"}]}], "}"}], 
         ",", "opts1"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "MakeVertRule", "]"}], ";"}]}]}]], "Code",
 CellChangeTimes->{{3.9331813645117855`*^9, 3.933181373654087*^9}, {
   3.933234170684932*^9, 3.933234262396476*^9}, 3.9337933895192714`*^9, {
   3.9485456117739353`*^9, 3.9485456166933413`*^9}, {3.948843069844717*^9, 
   3.948843094605401*^9}, {3.948843425777331*^9, 3.948843496341481*^9}, {
   3.9488435710325875`*^9, 3.948843598749011*^9}, {3.948843636468603*^9, 
   3.94884363796281*^9}, {3.948843726050099*^9, 3.948843755582483*^9}, {
   3.9488438102020907`*^9, 3.9488438119228506`*^9}, {3.948843845807927*^9, 
   3.948843853044667*^9}, {3.948843900911821*^9, 3.948843925137062*^9}, 
   3.9488509581920404`*^9, 3.949687739350674*^9, 3.949688014589046*^9, {
   3.950612807714725*^9, 3.950612828188682*^9}, {3.9530610492836857`*^9, 
   3.953061098722252*^9}, 3.958086062910391*^9},
 CellLabel->
  "In[519]:=",ExpressionUUID->"b6be3213-55d3-b44e-9bd2-03211b301c2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". FilterVertExpand"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636662700937*^9}, 
   3.948396783782827*^9},ExpressionUUID->"30b6640c-0944-a94b-ba36-\
96f5a4930378"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"FilterVertExpand", " ", "takes", " ", "a", " ", "dltensor"}], ",",
     " ", 
    RowBox[{
    "the", " ", "formula", " ", "to", " ", "expand", " ", "dltensor", " ", 
     "and", " ", "some", " ", "options", " ", "that", " ", "indicates", " ", 
     "if", " ", "it", " ", "should", " ", "expand", " ", "it"}], ",", " ", 
    RowBox[{"leave", " ", "it", " ", "as", " ", "is"}], ",", " ", 
    RowBox[{"or", " ", "set", " ", "to", " ", "zero"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "no", " ", "expanded", " ", "formula", " ", "is", " ", 
     "provided"}], ",", " ", 
    RowBox[{
    "then", " ", "the", " ", "expanded", " ", "formula", " ", "is", " ", 
     "set", " ", "to", " ", "be", " ", "dltensor", " ", "itself"}]}], " ", 
   "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FilterVertExpand", "[", 
       RowBox[{"dltensor_", ",", "options___"}], "]"}], "[", "]"}], ":=", 
     RowBox[{
      RowBox[{"FilterVertExpand", "[", 
       RowBox[{"dltensor", ",", "options"}], "]"}], "[", "dltensor", "]"}]}], 
    ";"}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Trivial", " ", "case"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FilterVertExpand", "[", 
       RowBox[{"0", ",", "___"}], "]"}], "[", "___", "]"}], ":=", "0"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "function", " ", "parses", " ", "the", " ", "options", " ", 
     "to", " ", "FilterVertExpandParsedOptions", " ", "as", " ", 
     RowBox[{"variables", ".", " ", "FilterVertExpandParsedOptions"}], " ", 
     "decides", " ", "the", " ", "result", " ", "based", " ", "on", " ", 
     "the", " ", "options"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FilterVertExpand", "[", 
       RowBox[{"dltensor_", ",", 
        RowBox[{"options", ":", 
         RowBox[{"OptionsPattern", "[", 
          RowBox[{"Options", "[", "ExpandVertDiff", "]"}], "]"}]}]}], "]"}], "[",
       "expandedformula_", "]"}], ":=", "\n", "\t", 
     RowBox[{
      RowBox[{
      "FilterVertExpandParsedOptions", "[", "\[IndentingNewLine]", "\t\t", 
       RowBox[{"dltensor", ",", "\[IndentingNewLine]", "\t\t", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"OptionValue", "[", "HoldExpandVertDiff", "]"}], "/.", 
            " ", 
            RowBox[{"CheckOptions", "[", "options", "]"}]}], " ", "/.", " ", 
           RowBox[{"Options", "[", "ExpandVertDiff", "]"}]}], "}"}], "]"}], ",",
         " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "To", " ", "allow", " ", "to", " ", "input", " ", "lists", " ", "or",
           " ", "single", " ", "elements"}], " ", "*)"}], 
        "\[IndentingNewLine]", "\t\t", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"OptionValue", "[", "ConstantTensors", "]"}], "/.", " ", 
            RowBox[{"CheckOptions", "[", "options", "]"}]}], " ", "/.", " ", 
           RowBox[{"Options", "[", "ExpandVertDiff", "]"}]}], "}"}], "]"}], ",",
         "\[IndentingNewLine]", "\t\t", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"OptionValue", "[", "NonConstantTensors", "]"}], "/.", 
            " ", 
            RowBox[{"CheckOptions", "[", "options", "]"}]}], " ", "/.", " ", 
           RowBox[{"Options", "[", "ExpandVertDiff", "]"}]}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "\t", "]"}], "[", "expandedformula", "]"}]}], 
    ";"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "If", " ", "tensor", " ", "is", " ", "defined", " ", "as", " ", 
      "constant"}], ",", " ", 
     RowBox[{"then", " ", "it", " ", "returns", " ", "0"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FilterVertExpandParsedOptions", "[", 
        RowBox[{
         RowBox[{"dltensor_", "[", "inds___", "]"}], ",", 
         "HoldExpandVertDiff_", ",", "constantList_", ",", 
         "nonConstantList_"}], "]"}], "[", "___", "]"}], "/;", 
      RowBox[{
       RowBox[{"VariationallyConstantQ", "[", 
        RowBox[{"constantList", ",", "nonConstantList"}], "]"}], "[", 
       RowBox[{"dltensor", "[", "inds", "]"}], "]"}]}], ":=", "0"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "If", " ", "tensor", " ", "is", " ", "not", " ", "defined", " ", "as", " ",
       "constant", " ", "but", " ", "it", " ", "is", " ", "required", " ", 
      "to", " ", "be", " ", "held"}], ",", " ", 
     RowBox[{"then", " ", "it", " ", "returns", " ", 
      RowBox[{"dltensor", "[", "inds", "]"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FilterVertExpandParsedOptions", "[", 
        RowBox[{
         RowBox[{"dltensor_", "[", "inds___", "]"}], ",", 
         "HoldExpandVertDiff_", ",", "constantList_", ",", 
         "nonConstantList_"}], "]"}], "[", "___", "]"}], "/;", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{
          RowBox[{"VariationallyConstantQ", "[", 
           RowBox[{"constantList", ",", "nonConstantList"}], "]"}], "[", 
          RowBox[{"dltensor", "[", "inds", "]"}], "]"}]}], "&&", 
        RowBox[{
         RowBox[{"VertDiffOfTensorToHoldQ", "[", "HoldExpandVertDiff", "]"}], 
         "[", 
         RowBox[{"dltensor", "[", "inds", "]"}], "]"}]}], ")"}]}], ":=", 
     RowBox[{"dltensor", "[", "inds", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "If", " ", "tensor", " ", "is", " ", "not", " ", "defined", " ", "as", " ",
       "constant", " ", "and", " ", "it", " ", "is", " ", "not", " ", 
      "required", " ", "to", " ", "be", " ", "held"}], ",", " ", 
     RowBox[{
     "then", " ", "it", " ", "returns", " ", "the", " ", "expanded", " ", 
      "function"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FilterVertExpandParsedOptions", "[", 
       RowBox[{
        RowBox[{"dltensor_", "[", "inds___", "]"}], ",", "Holdlist_", ",", 
        "constantList_", ",", "nonConstantList_"}], "]"}], "[", 
      RowBox[{"dltensor_", "[", "inds___", "]"}], "]"}], "/;", 
     "              ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Case", " ", 
        RowBox[{"base", ":", " ", "expandedformula"}]}], "=", 
       RowBox[{"dltensor", "[", "inds", "]"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{
         RowBox[{"VariationallyConstantQ", "[", 
          RowBox[{"constantList", ",", "nonConstantList"}], "]"}], "[", 
         RowBox[{"dltensor", "[", "inds", "]"}], "]"}]}], "&&", 
       RowBox[{"!", 
        RowBox[{
         RowBox[{"VertDiffOfTensorToHoldQ", "[", "Holdlist", "]"}], "[", 
         RowBox[{"dltensor", "[", "inds", "]"}], "]"}]}]}], ")"}]}], ":=", 
    RowBox[{"dltensor", "[", "inds", "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FilterVertExpandParsedOptions", "[", 
        RowBox[{
         RowBox[{"dltensor_", "[", "inds___", "]"}], ",", "Holdlist_", ",", 
         "constantList_", ",", "nonConstantList_"}], "]"}], "[", 
       "expandedformula_", "]"}], "/;", "             ", 
      RowBox[{"(*", " ", 
       RowBox[{"We", " ", "reexpand"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{
          RowBox[{"VariationallyConstantQ", "[", 
           RowBox[{"constantList", ",", "nonConstantList"}], "]"}], "[", 
          RowBox[{"dltensor", "[", "inds", "]"}], "]"}]}], "&&", 
        RowBox[{"!", 
         RowBox[{
          RowBox[{"VertDiffOfTensorToHoldQ", "[", "Holdlist", "]"}], "[", 
          RowBox[{"dltensor", "[", "inds", "]"}], "]"}]}]}], ")"}]}], ":=", 
     RowBox[{"(", 
      RowBox[{"expandedformula", "//", 
       RowBox[{"ExpandVertDiff", "[", 
        RowBox[{
         RowBox[{"HoldExpandVertDiff", "->", "Holdlist"}], ",", 
         RowBox[{"ConstantTensors", "->", "constantList"}], ",", 
         RowBox[{"NonConstantTensors", "->", "nonConstantList"}]}], "]"}]}], 
      ")"}]}], ";"}]}]}]], "Code",
 CellChangeTimes->{{3.9326366659919157`*^9, 3.9326367070313272`*^9}, {
   3.9326369287460203`*^9, 3.932637043583611*^9}, {3.932637153420887*^9, 
   3.932637252602699*^9}, {3.9326535682026978`*^9, 3.9326536052825165`*^9}, {
   3.93265368073119*^9, 3.932653748723852*^9}, {3.9326538067121735`*^9, 
   3.9326538070443907`*^9}, {3.932653890866842*^9, 3.93265400720423*^9}, {
   3.932654093054396*^9, 3.932654116247964*^9}, {3.932654537775093*^9, 
   3.9326545758215313`*^9}, {3.932654657909984*^9, 3.932654660166586*^9}, {
   3.932654826444298*^9, 3.932654867104507*^9}, {3.932655185942478*^9, 
   3.93265522070465*^9}, {3.932656077307808*^9, 3.932656081202783*^9}, {
   3.9327114182472258`*^9, 3.932711434198161*^9}, {3.9327180704795427`*^9, 
   3.9327180819202323`*^9}, {3.932718112095915*^9, 3.932718135277366*^9}, {
   3.932880414696526*^9, 3.932880419742851*^9}, {3.932912994413637*^9, 
   3.93291301134385*^9}, {3.9329839960745325`*^9, 3.93298400299024*^9}, {
   3.932984111795201*^9, 3.93298411291288*^9}, {3.93298416878319*^9, 
   3.932984260105494*^9}, {3.932984312094749*^9, 3.932984320523665*^9}, {
   3.9329843810866156`*^9, 3.932984431328797*^9}, {3.9485418585679*^9, 
   3.948541865811404*^9}, 3.948543157392021*^9, {3.948670522688698*^9, 
   3.9486705241316233`*^9}, 3.948671969901455*^9, {3.9486720607731633`*^9, 
   3.9486721309365788`*^9}, {3.948672194191943*^9, 3.948672206155205*^9}, {
   3.948672253336205*^9, 3.9486723007361703`*^9}, {3.948672466441469*^9, 
   3.9486724686430593`*^9}, {3.9486725420958295`*^9, 3.948672609168322*^9}, {
   3.948672691606509*^9, 3.94867270569495*^9}, {3.949065429734196*^9, 
   3.949065430240001*^9}, {3.951079866713011*^9, 3.951079876022307*^9}, {
   3.951221716700765*^9, 3.9512217307146873`*^9}, {3.951221824693411*^9, 
   3.951221830554428*^9}, {3.951222099729114*^9, 3.951222107948744*^9}, {
   3.951222389566276*^9, 3.951222389946318*^9}, {3.9514000059658947`*^9, 
   3.951400008437411*^9}, {3.951411302407135*^9, 3.9514113966291866`*^9}, {
   3.9514115192862473`*^9, 3.95141151944648*^9}, 3.9514117629582863`*^9, 
   3.9514128339755173`*^9, {3.951413026999193*^9, 3.951413060194769*^9}},
 CellLabel->
  "In[522]:=",ExpressionUUID->"37cbb76c-8ab3-e24c-ac93-2cb628dffd6a"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ". Variational relations"
}], "Chapter",
 CellChangeTimes->{{3.9318353438923273`*^9, 3.93183534696952*^9}, {
   3.932636606099285*^9, 3.9326366080589304`*^9}, {3.948391736052903*^9, 
   3.9483917549598455`*^9}, {3.948392906134357*^9, 3.948392912502523*^9}, 
   3.958648266888479*^9},ExpressionUUID->"858eeec9-c611-a543-9aa1-\
de55ec5548fe"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Initial graph functions (independent of xAct)"
}], "Section",
 CellChangeTimes->{{3.9318353438923273`*^9, 3.93183534696952*^9}, {
   3.932636606099285*^9, 3.9326366080589304`*^9}, 3.9483926696884317`*^9, 
   3.948393232507859*^9, {3.948393327008556*^9, 3.948393327771261*^9}, {
   3.9483933790300665`*^9, 3.948393383495205*^9}, 
   3.9586482680769672`*^9},ExpressionUUID->"1f9af581-3968-b441-96f4-\
cc1c96e9105d"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". nonConstantVertexQ"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.932774505338171*^9, {
   3.9328192180586023`*^9, 3.93281921984965*^9}, {3.948392890338228*^9, 
   3.948392903459043*^9}, 
   3.9483932354438725`*^9},ExpressionUUID->"c99e988f-57de-4d4e-b521-\
f06d9b6dcdbc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Given", " ", "a", " ", "graph", " ", "and", " ", "edges"}], ",", 
    " ", 
    RowBox[{
    "it", " ", "checks", " ", "if", " ", "any", " ", "of", " ", "the", " ", 
     "edges", " ", "is", " ", "not", " ", "in", " ", "the", " ", "graph"}]}], 
   " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"The", " ", "use", " ", "of", " ", "this", " ", "function", " ", 
     RowBox[{"is", ":", " ", 
      RowBox[{
       RowBox[{"provided", " ", "a", " ", "subgraph"}], " ", "\[Subset]", " ", 
       RowBox[{"graph", " ", "and", " ", "a", " ", "list", " ", 
        RowBox[{"{", "edges", "}"}]}], " ", "\[Subset]", " ", 
       RowBox[{
       "graph", " ", "that", " ", "are", " ", "incoming", " ", "to", " ", "a",
         " ", "vertex"}], " ", "\[Element]", " ", "subgraph"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"check", " ", "if", " ", 
      RowBox[{"{", "edges", "}"}]}], "\[Subset]", " ", "subgraph"}]}], " ", 
   "*)"}], "   ", "\n", 
  RowBox[{
   RowBox[{"nonConstantVertexQ", "[", 
    RowBox[{"subgraph_", ",", "IncomingEdges_"}], "]"}], ":=", 
   RowBox[{"AnyTrue", "[", 
    RowBox[{"IncomingEdges", ",", 
     RowBox[{
      RowBox[{"!", 
       RowBox[{"EdgeQ", "[", 
        RowBox[{"subgraph", ",", "#"}], "]"}]}], "&"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.948541882724078*^9, 3.948541886951603*^9}, 
   3.9485420759106374`*^9, 3.948542242987647*^9, {3.9502827596814613`*^9, 
   3.950282760102547*^9}, {3.951224759070153*^9, 3.951224759478697*^9}},
 CellLabel->
  "In[529]:=",ExpressionUUID->"ca8d65c1-19bc-6a4c-ab77-0f08280aada9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Propagation of constant through the graph"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.932774505338171*^9, {
   3.9328192180586023`*^9, 3.93281921984965*^9}, {3.948392890338228*^9, 
   3.948392903459043*^9}, {3.9483932354438725`*^9, 
   3.948393248706154*^9}},ExpressionUUID->"2b68bac2-ec57-b441-b8ea-\
75996756f577"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". GenerateConstantGraph"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.950282864936672*^9, 
   3.950284408196478*^9, 
   3.960656289778572*^9},ExpressionUUID->"8c596526-2ae6-234f-ab81-\
cacaef6b9b12"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "function", " ", "creates", " ", "the", " ", "graph", " ", 
    "formed", " ", "by", " ", "constant", " ", "nodes", " ", "and", " ", 
    "edges", " ", "from", "  ", "the", " ", "constant", " ", "relation", " ", 
    RowBox[{"(", 
     RowBox[{
     "unless", " ", "the", " ", "constantedges", " ", "are", " ", "not", " ", 
      "in", " ", "graph"}], ")"}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"VertexOutComponentGraph", "[", 
     RowBox[{"graph", ",", "listOfInitialConstantVertices"}], "]"}], " ", 
    "generates", " ", "the", " ", "subgraph", " ", "of", " ", "all", " ", 
    "the", " ", "vertices", " ", "affected", " ", "by", " ", "the", " ", 
    "initial", " ", "constant", " ", "vertices"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"GenerateConstantGraph", "[", 
    RowBox[{"graph_", ",", " ", "listOfInitialConstantVertices_List"}], "]"}],
    " ", ":=", " ", "\n", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"validVertices", "=", 
       RowBox[{"Intersection", "[", 
        RowBox[{
         RowBox[{"VertexList", "[", "graph", "]"}], ",", " ", 
         "listOfInitialConstantVertices"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"validVertices", " ", "===", " ", 
        RowBox[{"{", "}"}]}], ",", "\n", "   ", 
       RowBox[{"Graph", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", "\n", "   ", 
       RowBox[{"BackwardDiscardConstants", "[", 
        RowBox[{"graph", ",", " ", 
         RowBox[{"VertexOutComponentGraph", "[", 
          RowBox[{"graph", ",", " ", "validVertices"}], "]"}], ",", " ", 
         "validVertices", ",", " ", 
         RowBox[{"{", "}"}]}], "]"}]}], "\n", "  ", "]"}]}], "\n", " ", 
    "]"}]}]}]], "Code",
 CellChangeTimes->{3.957277161552019*^9},
 CellLabel->
  "In[530]:=",ExpressionUUID->"94fecb8e-a067-5b47-aec2-4814b63e8446"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". BackwardDiscardConstants"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.950282864936672*^9, 
   3.9502844101700344`*^9, 
   3.9606562884570694`*^9},ExpressionUUID->"28d30eb0-112f-3c4c-a4c3-\
ab2efc338806"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "function", " ", "propagates", " ", "the", " ", "constant", " ",
     "relations", " ", "to", " ", "the", " ", "graph"}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "The", " ", "idea", " ", "is", " ", "to", " ", "assume", " ", "that", " ",
       "the", " ", "contant", " ", "vertices", " ", "forward"}], "-", 
     RowBox[{"propagate", " ", "to", " ", "all", " ", "edges", " ", "and", " ", 
      RowBox[{"vertices", ".", " ", "This"}], " ", "represents", " ", "the", " ",
       "largest", " ", "possible", " ", "set", " ", "of", " ", 
      RowBox[{"constants", ".", " ", "However"}]}]}], ",", " ", 
    RowBox[{
    "some", " ", "of", " ", "them", " ", "might", " ", "not", " ", "be", " ", 
     "truly", " ", 
     RowBox[{"constant", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "We", " ", "find", " ", "those", " ", "which", " ", "are", " ", "fake"}],
      "-", 
     RowBox[{"constant", " ", 
      RowBox[{"i", ".", "e", "."}]}]}], ",", " ", 
    RowBox[{
    "those", " ", "with", " ", "incoming", " ", "edges", " ", "which", " ", 
     "are", " ", "not", " ", 
     RowBox[{"constant", ".", " ", "We"}], " ", "remove", " ", 
     RowBox[{"those", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Since", " ", "new", " ", "non"}], "-", 
     RowBox[{"constant", " ", "edges", " ", "are", " ", "created"}]}], ",", 
    " ", 
    RowBox[{
    "we", " ", "check", " ", "recursively", " ", "until", " ", "no", " ", 
     "vertices", " ", "are", " ", 
     RowBox[{"removed", "."}]}]}], " ", "*)"}], "\n", " ", "\n", 
  RowBox[{
   RowBox[{"BackwardDiscardConstants", "[", 
    RowBox[{
    "graph_", ",", "OldCandidateToConstantSubgraph_", ",", 
     "listOfInitialConstantVertices_", ",", "OldDiscardedVertices_"}], "]"}], 
   ":=", 
   RowBox[{"Module", "[", "\n", "\t", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "newConstantVertices", ",", "incomingEdgesOfNewConstantVertices", ",", 
       "NonConstantVertices", ",", "NewCandidateToConstantSubgraph", ",", 
       "NewDiscardedVertices"}], "}"}], ",", "\n", "\t", "\n", "\t", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Finds", " ", "the", " ", "vertices", " ", "of", " ", "the", " ", 
       "OldCandidateToConstantSubgraph", " ", "removing", " ", "the", " ", 
       "listOfInitialConstantVertices", " ", "and", " ", "the", " ", 
       "OldDiscardedVertices"}], " ", "*)"}], "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"newConstantVertices", "=", 
       RowBox[{"Complement", "[", 
        RowBox[{
         RowBox[{"VertexList", "[", "OldCandidateToConstantSubgraph", "]"}], ",", 
         RowBox[{
         "listOfInitialConstantVertices", "~", "Join", "~", 
          "OldDiscardedVertices"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", 
       RowBox[{" ", 
        RowBox[{
         RowBox[{
          RowBox[{
          "Generates", " ", "a", " ", "list", " ", "of", " ", "edges", " ", 
           "for", " ", "each", " ", "vertex"}], "\[Element]", 
          RowBox[{"newConstantVertices", " ", "to", " ", 
           RowBox[{"generate", ":", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["x", "11"], "->", 
                SubscriptBox["v", "1"]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["x", "12"], "->", 
                SubscriptBox["v", "1"]}], "}"}], ",", 
              RowBox[{"..", 
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["x", 
                  RowBox[{"1", 
                   SubscriptBox["n", "1"]}]], "->", 
                 SubscriptBox["v", "1"]}], "}"}]}]}], "}"}]}]}]}], ",", "..", 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox["x", "m1"], "->", 
             SubscriptBox["v", "m"]}], "}"}], ",", "..", ",", 
           RowBox[{"{", 
            RowBox[{
             SubscriptBox["x", 
              SubscriptBox["mn", "m"]], "->", 
             SubscriptBox["v", "m"]}], "}"}]}], "}"}]}], "}"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"incomingEdgesOfNewConstantVertices", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"EdgeList", "[", 
          RowBox[{"graph", ",", 
           RowBox[{"_", "\[DirectedEdge]", "#"}]}], "]"}], "&"}], "/@", 
        "newConstantVertices"}]}], ";", "\[IndentingNewLine]", "\t", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
       "We", " ", "select", " ", "the", " ", "vertices", " ", "of", " ", 
        "newConstantVertices", " ", "that", " ", "are", " ", "not", " ", 
        "trule", " ", "constant", " ", "becuase", " ", "they", " ", "have", " ",
         "an", " ", "incoming", " ", "edge", " ", "not", " ", "contained", " ",
         "in", " ", 
        RowBox[{"OldCandidateToConstantSubgraph", "."}]}], " ", "*)"}], 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Last", "/@", 
         RowBox[{"Last", "/@", " ", "extracts"}]}], " ", "the", " ", 
        RowBox[{"vertices", "."}]}], " ", "*)"}], "\n", "\t", 
      RowBox[{"NonConstantVertices", "=", 
       RowBox[{"Last", "/@", 
        RowBox[{"Last", "/@", 
         RowBox[{"Select", "[", 
          RowBox[{"incomingEdgesOfNewConstantVertices", ",", 
           RowBox[{
            RowBox[{"nonConstantVertexQ", "[", 
             RowBox[{"OldCandidateToConstantSubgraph", ",", "#"}], "]"}], 
            "&"}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", "\t", "\n", 
      "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
       "We", " ", "update", " ", "the", " ", "discarded", " ", "vertices"}], 
       " ", "*)"}], "\[IndentingNewLine]", "\t", 
      RowBox[{"NewDiscardedVertices", "=", 
       RowBox[{
       "OldDiscardedVertices", "~", "Join", "~", "NonConstantVertices"}]}], ";",
       "\[IndentingNewLine]", "\t", "\n", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "If", " ", "no", " ", "vertices", " ", "have", " ", "been", " ", 
         "discarded"}], ",", " ", 
        RowBox[{"we", " ", "are", " ", 
         RowBox[{"done", ".", " ", "Otherwise"}]}], ",", " ", 
        RowBox[{
        "we", " ", "have", " ", "to", " ", "proceed", " ", "recursively"}]}], 
       " ", "*)"}], "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"NonConstantVertices", "==", 
         RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", "\t\t", 
        "OldCandidateToConstantSubgraph", ",", "\[IndentingNewLine]", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{"(*", " ", 
          RowBox[{
          "We", " ", "forward", " ", "propagate", " ", "the", " ", "initial", 
           " ", "constant", " ", "in", " ", "the", " ", "initial", " ", 
           "graph", " ", "minus", " ", "the", " ", "discarded", " ", 
           "vertices"}], " ", "*)"}], "\[IndentingNewLine]", "\t\t", 
         RowBox[{
          RowBox[{"NewCandidateToConstantSubgraph", "=", 
           RowBox[{"VertexOutComponentGraph", "[", 
            RowBox[{
             RowBox[{"VertexDelete", "[", 
              RowBox[{"graph", ",", "NewDiscardedVertices"}], "]"}], ",", 
             "listOfInitialConstantVertices"}], "]"}]}], ";", "\n", "\t\t", 
          "\n", "\t\t", 
          RowBox[{"(*", " ", 
           RowBox[{
           "We", " ", "backwards", " ", "check", " ", "that", " ", "in", " ", 
            "the", " ", "new", " ", "graph", " ", "all", " ", "the", " ", 
            "vertices", " ", "are", " ", "indeed", " ", "constant"}], " ", 
           "*)"}], "\[IndentingNewLine]", "\t\t", 
          RowBox[{"NewCandidateToConstantSubgraph", "=", 
           RowBox[{"BackwardDiscardConstants", "[", 
            RowBox[{
            "graph", ",", "NewCandidateToConstantSubgraph", ",", 
             "listOfInitialConstantVertices", ",", "NewDiscardedVertices"}], 
            "]"}]}], ";", "\[IndentingNewLine]", "\t\t", 
          "NewCandidateToConstantSubgraph"}], "\[IndentingNewLine]", "\t\t", 
         ")"}]}], "\[IndentingNewLine]", "\t", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}]}]], "Code",
 CellChangeTimes->{{3.932807196761603*^9, 3.932807234960794*^9}, 
   3.932810960444406*^9, 3.932811029720578*^9, {3.9328111144774714`*^9, 
   3.932811147840813*^9}, {3.9328112489635315`*^9, 3.932811278932735*^9}, 
   3.932811507499199*^9, {3.932811551479232*^9, 3.932811646805954*^9}, {
   3.932811686753798*^9, 3.9328117135113454`*^9}, {3.932811800801735*^9, 
   3.932811820568371*^9}, {3.932811877445201*^9, 3.9328119025834265`*^9}, {
   3.932812164150653*^9, 3.932812171760139*^9}, {3.932812223271979*^9, 
   3.932812272585481*^9}, 3.9328127563516264`*^9, {3.932812862677183*^9, 
   3.9328128826966147`*^9}, {3.932812922274792*^9, 3.9328130387275224`*^9}, {
   3.932813077429776*^9, 3.932813133649664*^9}, {3.932813280317443*^9, 
   3.9328132803214364`*^9}, {3.932813421853089*^9, 3.93281348311994*^9}, {
   3.932813663589653*^9, 3.93281367767226*^9}, {3.93281371514994*^9, 
   3.932813798429539*^9}, {3.9328140444763136`*^9, 3.93281434442032*^9}, {
   3.932815349988523*^9, 3.932815362776323*^9}, {3.932819565402567*^9, 
   3.932819717761365*^9}, 3.932821424159199*^9, {3.932822651310738*^9, 
   3.932822666576314*^9}, {3.9328237749442587`*^9, 3.932823822830255*^9}, {
   3.932823896396949*^9, 3.9328239415394225`*^9}, {3.9328760112529073`*^9, 
   3.932876017227626*^9}, {3.932876088142454*^9, 3.932876117417941*^9}, {
   3.932876210930729*^9, 3.932876212123331*^9}, {3.932876797774754*^9, 
   3.932876812456932*^9}, {3.932876891070691*^9, 3.932877037347083*^9}, {
   3.9328774577624693`*^9, 3.932877516360265*^9}, {3.932877595846489*^9, 
   3.9328776376115704`*^9}, {3.9328776989370017`*^9, 3.932877706718583*^9}, {
   3.932877745461395*^9, 3.932877829223362*^9}, {3.932877873188237*^9, 
   3.932877884043172*^9}, {3.932877918823249*^9, 3.932877951020137*^9}, {
   3.93287810369216*^9, 3.932878123451643*^9}, {3.932878169111047*^9, 
   3.932878209472447*^9}, {3.932878758219108*^9, 3.932878831244954*^9}, {
   3.932879005151154*^9, 3.932879030187695*^9}, {3.932879121826985*^9, 
   3.932879127068289*^9}, 3.932879208763574*^9, {3.932879320132653*^9, 
   3.9328793494705143`*^9}, {3.932879379507611*^9, 3.932879399694896*^9}, 
   3.932879443933688*^9, {3.932879815579013*^9, 3.93287986294978*^9}, {
   3.9328810533947363`*^9, 3.932881057926379*^9}, {3.932881757781062*^9, 
   3.9328818508044586`*^9}, {3.932882117133953*^9, 3.9328822441869297`*^9}, {
   3.9328822977413735`*^9, 3.932882392739098*^9}, {3.9328844039319973`*^9, 
   3.932884407811161*^9}, {3.932884639836643*^9, 3.932884643947582*^9}, {
   3.932884842792871*^9, 3.932884867967678*^9}, {3.932885052869727*^9, 
   3.932885124290344*^9}, {3.932885162415767*^9, 3.932885189542774*^9}, {
   3.932886766074551*^9, 3.9328867818616743`*^9}, {3.932887129678455*^9, 
   3.932887146494315*^9}, 3.932887427363613*^9, {3.932887465607795*^9, 
   3.932887503877946*^9}, 3.932887873559919*^9, {3.932901767319395*^9, 
   3.932901841759487*^9}, {3.9329018950847197`*^9, 3.9329019095066867`*^9}, {
   3.932902001459163*^9, 3.932902012746128*^9}, {3.932902940339544*^9, 
   3.9329029442200365`*^9}, {3.932903148513601*^9, 3.932903175639192*^9}, {
   3.932903344487881*^9, 3.932903361511026*^9}, {3.932903437092184*^9, 
   3.932903532148167*^9}, {3.932904461533559*^9, 3.932904462980092*^9}, 
   3.932904548062008*^9, {3.932905958416627*^9, 3.932905998929974*^9}, {
   3.932906155851968*^9, 3.9329063007603874`*^9}, {3.932906355160838*^9, 
   3.932906379147991*^9}, {3.9329065281055584`*^9, 3.932906530494378*^9}, {
   3.932914708177972*^9, 3.9329147232640877`*^9}, {3.93291479310633*^9, 
   3.932914826938509*^9}, {3.93291486469569*^9, 3.932914867761201*^9}, {
   3.9331685856767025`*^9, 3.9331686276401978`*^9}, {3.933173934439657*^9, 
   3.933173944413546*^9}, {3.933175292747163*^9, 3.933175358936909*^9}, {
   3.933175401128688*^9, 3.933175733419146*^9}, {3.933175786956925*^9, 
   3.9331757996331797`*^9}, {3.933175849358585*^9, 3.933175850203669*^9}, {
   3.9331759045303154`*^9, 3.933176013714763*^9}, {3.933177099489459*^9, 
   3.933177141492017*^9}, {3.933177340493295*^9, 3.933177346642685*^9}, {
   3.9331774284336834`*^9, 3.9331776220227013`*^9}, {3.933326205062508*^9, 
   3.933326352504156*^9}, {3.933326386331468*^9, 3.933326641090358*^9}, {
   3.933326772918468*^9, 3.9333268002249956`*^9}, {3.933327062885338*^9, 
   3.9333271343404922`*^9}, {3.9337593730460973`*^9, 3.933759400605974*^9}, {
   3.933759608986372*^9, 3.933759609010983*^9}, 3.948393170290885*^9, {
   3.948393207535112*^9, 3.948393221547446*^9}, {3.948541891844632*^9, 
   3.948541903138223*^9}, 3.948542078147332*^9, 3.948542246729923*^9, {
   3.948562666844078*^9, 3.948562731219144*^9}, {3.950284387512783*^9, 
   3.9502843946758137`*^9}, 3.951224768520026*^9},
 CellLabel->
  "In[531]:=",ExpressionUUID->"7468d236-028d-3742-be89-0c9c97378fff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Highlight of constant through the graph"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.932774505338171*^9, {
   3.9328192180586023`*^9, 3.93281921984965*^9}, {3.948392890338228*^9, 
   3.948392903459043*^9}, {3.9483932354438725`*^9, 
   3.948393262070874*^9}},ExpressionUUID->"4c576004-e60b-1b46-a94e-\
fec2d49fd442"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "function", " ", "shows", " ", "the", " ", "graph", " ", 
    "with", " ", "the", " ", "constant", " ", "edges", " ", "and", " ", 
    "nodes", " ", "derived", " ", "from", " ", "initialConstantVertices"}], 
   " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{"HighlightConstantRelations", "[", 
    RowBox[{"graph_", ",", "initialConstantVertices_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"ConstantGraph", "=", 
        RowBox[{"GenerateConstantGraph", "[", 
         RowBox[{"$VariationalGraph", ",", "initialConstantVertices"}], 
         "]"}]}], ",", "\[IndentingNewLine]", "\t", 
       RowBox[{"allVertices", "=", 
        RowBox[{"VertexList", "[", "graph", "]"}]}], ",", 
       "\[IndentingNewLine]", "\t", "NewConstantVertices", ",", 
       "nonConstantVertices", ",", "ConstantEdges", ",", "highlightedGraph"}],
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", "\t", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Get", " ", "Constant", " ", "nodes", " ", "and", " ", "edges", " ", 
       "from", " ", "the", " ", "Constant", " ", "subgraph"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"NewConstantVertices", "=", 
       RowBox[{"Complement", "[", 
        RowBox[{
         RowBox[{"VertexList", "[", "ConstantGraph", "]"}], ",", 
         "initialConstantVertices"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\t", 
      RowBox[{"ConstantEdges", "=", 
       RowBox[{"EdgeList", "[", "ConstantGraph", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Get", " ", "non"}], "-", 
        RowBox[{"constant", " ", "nodes"}]}], "*)"}], "\[IndentingNewLine]", 
      "\t", 
      RowBox[{"nonConstantVertices", "=", 
       RowBox[{"Complement", "[", 
        RowBox[{"allVertices", ",", 
         RowBox[{
         "initialConstantVertices", "~", "Join", "~", 
          "NewConstantVertices"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", 
       RowBox[{"Create", " ", "the", " ", "highlighted", " ", "graph"}], 
       "*)"}], "\n", "\t", 
      RowBox[{"highlightedGraph", "=", 
       RowBox[{"Graph", "[", 
        RowBox[{"graph", ",", "\n", "\t\t\t\t\t\t\t", 
         RowBox[{"VertexStyle", "->", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "->", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"nonConstantVertices", ",", "#"}], "]"}], ",", 
                "Blue", ",", "Red"}], "]"}]}], "&"}], "/@", "allVertices"}], 
           ")"}]}], ",", "\n", "\t\t\t\t\t\t\t", 
         RowBox[{"VertexShapeFunction", "->", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "->", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"nonConstantVertices", ",", "#"}], "]"}], 
                ",", "\"\<Circle\>\"", ",", "\"\<Square\>\""}], "]"}]}], 
             "&"}], "/@", "allVertices"}], ")"}]}], ",", "\n", 
         "\t\t\t\t\t\t\t", 
         RowBox[{"EdgeStyle", "->", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "->", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"ConstantEdges", ",", "#"}], "]"}], ",", "Red", ",", 
                "Gray"}], "]"}]}], "&"}], "/@", 
            RowBox[{"EdgeList", "[", "graph", "]"}]}], ")"}]}], ",", "\n", 
         "\t\t\t\t\t\t\t", 
         RowBox[{"VertexLabels", "->", "\"\<Name\>\""}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\t", "highlightedGraph"}]}], "\n", 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.94854209156892*^9, 3.948542093570217*^9}, 
   3.948542248460475*^9, {3.950122718160633*^9, 3.950122742162695*^9}, {
   3.950282778004431*^9, 3.950282778359427*^9}, 3.951224788955923*^9, 
   3.9585009683117237`*^9},
 CellLabel->
  "In[532]:=",ExpressionUUID->"735119ec-f8e8-3440-9a52-708fc887dc3a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Subgraphs"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.932774505338171*^9, {
   3.9328192180586023`*^9, 3.93281921984965*^9}, {3.948392890338228*^9, 
   3.948392903459043*^9}, {3.9483932354438725`*^9, 
   3.948393289201146*^9}},ExpressionUUID->"8c92df96-6f1a-8240-a005-\
c99c2330d937"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SubGraphRelations", "::", "missing"}], "=", 
    " ", "\"\<One of the tensors in `1` is not included in the Variational \
Graph `2`.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"ListOut", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Up\>\"", ",", "\"\<up\>\"", ",", "\"\<In\>\"", 
     ",", "\"\<in\>\"", ",", "\"\<Inward\>\"", ",", "\"\<inward\>\"", 
     ",", "\"\<Inwards\>\"", ",", "\"\<inwards\>\""}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ListIn", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Down\>\"", ",", "\"\<down\>\"", ",", "\"\<Out\>\"", 
     ",", "\"\<out\>\"", ",", "\"\<Outward\>\"", ",", "\"\<outward\>\"", 
     ",", "\"\<Outwards\>\"", ",", "\"\<Outwards\>\""}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ListBoth", "=", 
    RowBox[{"{", 
     RowBox[{"\"\<Both\>\"", ",", "\"\<both\>\"", 
      ",", "\"\<xAct`xCPS`Private`Both\>\""}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Creates", " ", "the", " ", "subgraph", " ", "of", " ", "influence", " ", 
    "of", " ", "a", " ", "vertex"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"SubGraphRelations", "[", 
   RowBox[{"graph_", ",", "vertices_List"}], "]"}], ":=", 
  RowBox[{"SubGraphRelations", "[", 
   RowBox[{"graph", ",", "vertices", ",", "\"\<Both\>\""}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SubGraphRelations", "[", 
    RowBox[{"graph_", ",", 
     RowBox[{"{", "All", "}"}], ",", "_"}], "]"}], ":=", "graph"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SubGraphRelations", "[", 
   RowBox[{"graph_", ",", "vertices_List", ",", "direction_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", "\t", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"incomingVertices", ",", "outgoingVertices"}], "}"}], ",", "\n", 
    "\t", "\n", "\t", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"AnyTrue", "[", 
        RowBox[{"vertices", ",", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"VertexQ", "[", 
            RowBox[{"graph", ",", "#"}], "]"}]}], "&"}]}], "]"}], ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"SubGraphRelations", "::", "missing"}], ",", "vertices", ",",
           "graph"}], "]"}]}]}], "]"}], ";", "\n", "\t", "\n", "\t", 
     RowBox[{"incomingVertices", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"ListOut", "~", "Join", "~", "ListBoth"}], ",", 
          "direction"}], "]"}], ",", 
        RowBox[{"VertexInComponent", "[", 
         RowBox[{"graph", ",", "vertices"}], "]"}], ",", 
        RowBox[{"{", "}"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Vertices", " ", "that", " ", "influence", " ", "the", " ", 
       "vertices"}], " ", "*)"}], "\n", "\t", 
     RowBox[{"outgoingVertices", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"ListIn", "~", "Join", "~", "ListBoth"}], ",", 
          "direction"}], "]"}], ",", 
        RowBox[{"VertexOutComponent", "[", 
         RowBox[{"graph", ",", "vertices"}], "]"}], ",", 
        RowBox[{"{", "}"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Vertices", " ", "influenced", " ", "by", " ", "the", " ", "vertices"}],
       "*)"}], "\n", "\t", "\[IndentingNewLine]", "\t", 
     RowBox[{"Subgraph", "[", 
      RowBox[{"graph", ",", 
       RowBox[{"Union", "[", 
        RowBox[{"incomingVertices", ",", "outgoingVertices"}], "]"}]}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Code",
 CellChangeTimes->{{3.948542097925745*^9, 3.948542104801089*^9}, 
   3.948542249739023*^9, {3.9502827809589825`*^9, 3.950282781286373*^9}, 
   3.951224794631697*^9, {3.9530551356724033`*^9, 3.953055158737812*^9}, 
   3.953055305272297*^9, {3.9530607067590275`*^9, 3.953060723331417*^9}, {
   3.9548572037223015`*^9, 3.954857295610031*^9}, {3.95485737145228*^9, 
   3.9548573976694527`*^9}, {3.9548575685697746`*^9, 
   3.9548575935956573`*^9}, {3.9553628002279625`*^9, 3.9553628071409607`*^9}, 
   3.9583128549496136`*^9, 3.9603681903991127`*^9},
 CellLabel->
  "In[533]:=",ExpressionUUID->"6c1b131f-01bd-3640-ba3f-b53c6b17e41f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". AddRelationToGraph"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.932774505338171*^9, {
   3.9328192180586023`*^9, 3.93281921984965*^9}, {3.948392890338228*^9, 
   3.948392903459043*^9}, {3.9483932354438725`*^9, 3.948393262070874*^9}, 
   3.948393302521194*^9},ExpressionUUID->"d57a66a7-4182-5047-b473-\
297b0c9cd904"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Add", " ", "dependency", " ", "to", " ", "graph"}], " ", "*)"}], 
  "\n", 
  RowBox[{
   RowBox[{"AddRelationToGraph", "[", 
    RowBox[{
     RowBox[{"master_", "->", "dependent_"}], ",", "graph_"}], "]"}], ":=", 
   RowBox[{"Graph", "[", 
    RowBox[{
     RowBox[{"VertexList", "[", "graph", "]"}], ",", 
     RowBox[{
      RowBox[{"EdgeList", "[", "graph", "]"}], "~", "Join", "~", 
      RowBox[{"{", 
       RowBox[{"master", "->", "dependent"}], "}"}]}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.948393182623841*^9, 3.948393182979955*^9}, {
   3.948393272699154*^9, 3.94839330735883*^9}, {3.948542108429197*^9, 
   3.9485421119295087`*^9}, 3.948542252141946*^9, {3.950282783441557*^9, 
   3.9502827837665424`*^9}, {3.951224804079582*^9, 3.951224804259884*^9}},
 CellLabel->
  "In[540]:=",ExpressionUUID->"dbe8a40b-5557-d34a-90a5-f70ff6ebe936"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". FindCyclicVariationalRelations"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.932774505338171*^9, {
   3.9328192180586023`*^9, 3.93281921984965*^9}, {3.948392890338228*^9, 
   3.948392903459043*^9}, {3.9483932354438725`*^9, 3.948393262070874*^9}, {
   3.948393302521194*^9, 
   3.94839331777527*^9}},ExpressionUUID->"f56b6af9-6df4-0147-885f-\
897c423457af"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "FindCyclicVariationalRelations", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{"ShowGraph", "->", "True"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Returns", " ", "cyclic", " ", "variational", " ", "relations", " ", 
    RowBox[{"(", 
     RowBox[{"and", " ", "prints", " ", "them"}], ")"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FindCyclicVariationalRelations", "[", 
    RowBox[{"graph_", ",", 
     RowBox[{"option", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"Options", "[", "FindCyclicVariationalRelations", "]"}], 
       "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "possiblecycles", "}"}], ",", "\n", "\n", "\t", 
     RowBox[{
      RowBox[{"possiblecycles", "=", 
       RowBox[{"FindCycle", "[", 
        RowBox[{"graph", ",", "Infinity", ",", "All"}], "]"}]}], ";", "\n", 
      "\t", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", "possiblecycles"}], ">", "0"}], "&&", 
         RowBox[{"OptionValue", "[", "ShowGraph", "]"}]}], ",", "\n", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{
          "Print", 
           "[", "\"\<** FindCyclicVariationalRelations: Some cyclic relations \
found:\>\"", "]"}], ";", "\n", "\t\t", 
          RowBox[{"Print", "[", 
           RowBox[{"Annotate", "[", 
            RowBox[{
             RowBox[{"HighlightGraph", "[", 
              RowBox[{"graph", ",", "possiblecycles"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"VertexLabels", "->", "\"\<Name\>\""}], "}"}]}], "]"}], 
           "]"}], ";"}], "\n", "\t\t", ")"}], ",", "\n", "\t\t", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OptionValue", "[", "ShowGraph", "]"}], ",", 
           RowBox[{
           "Print", 
            "[", "\"\<** FindCyclicVariationalRelations: No cyclic relations \
found\>\"", "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "\t", "]"}], ";", 
      "\n", "\t", "possiblecycles"}]}], "\[IndentingNewLine]", "]"}]}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "FindCyclicVariationalRelations", "]"}], 
  ";"}]}], "Code",
 CellChangeTimes->{{3.9485421156423235`*^9, 3.948542119762041*^9}, 
   3.9485422535699043`*^9, {3.9502827860948143`*^9, 3.950282786435604*^9}, {
   3.950306133193207*^9, 3.950306138916014*^9}, {3.950810138889372*^9, 
   3.950810142978037*^9}, {3.950810598093761*^9, 3.9508106044210224`*^9}, {
   3.9518696657572823`*^9, 3.951869718302868*^9}, {3.9518698505916786`*^9, 
   3.951869871367632*^9}, {3.951869975468561*^9, 3.9518699996437607`*^9}},
 CellLabel->
  "In[541]:=",ExpressionUUID->"04dd01b4-9fbd-1640-8992-b82c41b7750b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Variational relations (xAct related)"
}], "Section",
 CellChangeTimes->{{3.9318353438923273`*^9, 3.93183534696952*^9}, {
   3.932636606099285*^9, 3.9326366080589304`*^9}, 3.9483926696884317`*^9, 
   3.948393232507859*^9, {3.948393327008556*^9, 3.9483933600168486`*^9}, {
   3.948460631750603*^9, 3.948460635241664*^9}, 
   3.958648275206547*^9},ExpressionUUID->"52176b98-1cb6-5545-b26b-\
3c98d6e9fceb"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Handle VariationalRelations (vertices)"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.932774505338171*^9, {
   3.9328200872568564`*^9, 3.932820087837497*^9}, {3.932880982219888*^9, 
   3.932880983419696*^9}, 3.948393369481866*^9, {3.948393421892624*^9, 
   3.9483934249140277`*^9}},ExpressionUUID->"c85380cd-5fee-4e44-a4ed-\
e3514bf337b0"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". AddVariationalRelation"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.950282864936672*^9, 
   3.9606562637049675`*^9},ExpressionUUID->"7d0c6fa2-11eb-9441-884e-\
bc2aaed649a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Adds", " ", "variational", " ", "dependencies", " ", "to", " ", 
    "$VariationalGraph"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"AddVariationalRelation", "::", "zerotensor"}], "=", 
     " ", "\"\<`1` cannot depend variationally on the Zero tensor.\>\""}], 
    ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"AddVariationalRelation", "[", 
     RowBox[{
      RowBox[{"masterTensor_", "?", "xTensorQ"}], "->", 
      "dependentTensorList_List"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"AddVariationalRelation", "[", 
       RowBox[{"masterTensor", "->", "#"}], "]"}], "&"}], "/@", 
     "dependentTensorList"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"AddVariationalRelation", "[", 
     RowBox[{"masterTensorList_List", "->", 
      RowBox[{"dependentTensor_", "?", "xTensorQ"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"AddVariationalRelation", "[", 
       RowBox[{"#", "->", "dependentTensor"}], "]"}], "&"}], "/@", 
     "masterTensorList"}]}], "\n", 
   RowBox[{
    RowBox[{"AddVariationalRelation", "[", 
     RowBox[{"_", "->", "Zero"}], "]"}], ":=", "Null"}], "\n", 
   RowBox[{
    RowBox[{"AddVariationalRelation", "[", 
     RowBox[{"Zero", "->", "dependentTensor_"}], "]"}], ":=", 
    RowBox[{"Throw", "@", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"AddVariationalRelation", "::", "zerotensor"}], ",", 
       "dependentTensor"}], "]"}]}]}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Adds", " ", "a", " ", "variational", " ", "relation"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"AddVariationalRelation", "[", 
     RowBox[{
      RowBox[{"mastertensor_", "?", "xTensorQ"}], "->", 
      RowBox[{"dependentTensor_", "?", "xTensorQ"}]}], "]"}], ":=", "\n", 
    "\t", 
    RowBox[{"(", "\n", "\t", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"EdgeQ", "[", 
          RowBox[{"$VariationalGraph", ",", 
           RowBox[{"mastertensor", "->", "dependentTensor"}]}], "]"}]}], ",", 
        "\n", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"$VariationalGraph", "=", 
           RowBox[{"AddRelationToGraph", "[", 
            RowBox[{
             RowBox[{"mastertensor", "->", "dependentTensor"}], ",", 
             "$VariationalGraph"}], "]"}]}], ";", "\n", "\t\t", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"$printAddVariationalRelation", "&&", "$DefInfoQ"}], ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<** AddVariationalRelation: Variational relation \
created \>\"", ",", "mastertensor", ",", "\"\<\[Rule]\>\"", ",", 
              "dependentTensor", ",", "\"\<.\>\""}], "]"}]}], "]"}], ";"}], 
         "\n", "\t\t", ")"}]}], "\n", "\t", "]"}], ";", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Dagger", "[", "mastertensor", "]"}], "=!=", 
            "mastertensor"}], "||", 
           RowBox[{
            RowBox[{"Dagger", "[", "dependentTensor", "]"}], "=!=", 
            "dependentTensor"}]}], ")"}], "&&", 
         "$AddVariationalRelationDagger"}], ",", "\n", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"$AddVariationalRelationDagger", "=", "False"}], ";", "\n", 
          "\t\t", 
          RowBox[{"AddVariationalRelation", "[", 
           RowBox[{
            RowBox[{"Dagger", "[", "mastertensor", "]"}], "->", 
            RowBox[{"Dagger", "[", "dependentTensor", "]"}]}], "]"}], ";", 
          "\n", "\t\t", 
          RowBox[{"$AddVariationalRelationDagger", "=", "True"}], ";"}], "\n",
          "\t\t", ")"}]}], "\n", "\t", "]"}], ";"}], "\n", "\t", ")"}]}], 
   "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Recursive", " ", 
     RowBox[{"case", ":", " ", 
      RowBox[{"multiple", " ", "chained", " ", "tensors"}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"AddVariationalRelation", "[", 
     RowBox[{
      RowBox[{"mastertensor_", "?", "xTensorQ"}], " ", "->", " ", 
      RowBox[{
       RowBox[{"dependentTensor_", "?", "xTensorQ"}], " ", "->", " ", 
       "rest___"}]}], "]"}], " ", ":=", " ", "\n", "  ", 
    RowBox[{"(", "\n", "    ", 
     RowBox[{
      RowBox[{"AddVariationalRelation", "[", 
       RowBox[{"mastertensor", " ", "->", " ", "dependentTensor"}], "]"}], ";",
       "\n", "    ", 
      RowBox[{"AddVariationalRelation", "[", 
       RowBox[{"dependentTensor", " ", "->", " ", "rest"}], "]"}]}], "\n", 
     "  ", ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.932774392333725*^9, 3.9327743960659*^9}, {
   3.932774444669112*^9, 3.932774484885167*^9}, {3.932774537253993*^9, 
   3.932774599442746*^9}, {3.9327746811889043`*^9, 3.932774684089215*^9}, {
   3.932774742067433*^9, 3.932774745093777*^9}, {3.932774829004839*^9, 
   3.9327748293484764`*^9}, {3.93277512155735*^9, 3.932775124451803*^9}, {
   3.932776135103267*^9, 3.932776136124018*^9}, {3.932776310803188*^9, 
   3.932776311493453*^9}, {3.9327763415271206`*^9, 3.932776348759003*^9}, {
   3.9327764810914536`*^9, 3.93277648372372*^9}, {3.9328197653060303`*^9, 
   3.932819765646977*^9}, {3.9328200771799035`*^9, 3.932820116211658*^9}, {
   3.932820835311812*^9, 3.932820898182993*^9}, {3.9328209410679035`*^9, 
   3.932820998519014*^9}, {3.9328230127203045`*^9, 3.9328230307213335`*^9}, {
   3.9328230849459524`*^9, 3.932823092219338*^9}, 3.932823265969888*^9, {
   3.932824163164074*^9, 3.932824174244188*^9}, {3.9328242127992926`*^9, 
   3.9328242182146597`*^9}, {3.932824680499835*^9, 3.932824765424075*^9}, 
   3.932824857094393*^9, {3.932824915648275*^9, 3.932824941155781*^9}, {
   3.932825036273577*^9, 3.932825052338524*^9}, {3.932825093587968*^9, 
   3.932825100200824*^9}, {3.932825131819773*^9, 3.93282513511572*^9}, {
   3.932825204450677*^9, 3.932825226643609*^9}, {3.932875478168986*^9, 
   3.932875497573188*^9}, {3.932875566307336*^9, 3.932875648933294*^9}, {
   3.932875708622024*^9, 3.932875709296713*^9}, {3.932875791655513*^9, 
   3.932875802320182*^9}, {3.932875873688204*^9, 3.932875898431157*^9}, {
   3.932876131974157*^9, 3.932876133107621*^9}, 3.932876195712588*^9, {
   3.9328762282014155`*^9, 3.932876308641124*^9}, {3.932877051800764*^9, 
   3.932877139204611*^9}, {3.932877177953394*^9, 3.932877187591587*^9}, {
   3.9328773092443523`*^9, 3.932877344119446*^9}, {3.932877471321923*^9, 
   3.932877471324922*^9}, {3.932877544839086*^9, 3.9328775793078*^9}, {
   3.9328779627913184`*^9, 3.932877964902289*^9}, {3.932877998103246*^9, 
   3.9328779986676307`*^9}, {3.932878297721789*^9, 3.932878319399688*^9}, {
   3.93287837147388*^9, 3.932878382522461*^9}, 3.932878436802714*^9, {
   3.9328785512735977`*^9, 3.932878567055267*^9}, {3.932878865618409*^9, 
   3.932878935873887*^9}, {3.932878971591713*^9, 3.932878979839748*^9}, {
   3.93287903844674*^9, 3.93287907336763*^9}, 3.932879133268968*^9, {
   3.932879221567525*^9, 3.932879243544515*^9}, {3.932879421235222*^9, 
   3.932879424831088*^9}, 3.932879625409682*^9, {3.932879670826375*^9, 
   3.932879672614262*^9}, {3.932879927852725*^9, 3.9328799597028*^9}, 
   3.932880286320902*^9, {3.932880327664816*^9, 3.932880371832651*^9}, {
   3.9328805288415575`*^9, 3.9328805337429943`*^9}, {3.9328806671264668`*^9, 
   3.932880754827923*^9}, {3.9328808317019186`*^9, 3.932880881606207*^9}, {
   3.932880992520574*^9, 3.932881135223155*^9}, {3.932882667864603*^9, 
   3.9328827727920403`*^9}, {3.932882859387788*^9, 3.932882875652064*^9}, {
   3.932882911523596*^9, 3.932883004949714*^9}, {3.9328835807553577`*^9, 
   3.932883649084082*^9}, {3.932883748471214*^9, 3.932883748689277*^9}, {
   3.9328839177506*^9, 3.932883926642871*^9}, {3.932884164391743*^9, 
   3.9328841761379766`*^9}, {3.932884207973332*^9, 3.9328842219684467`*^9}, {
   3.9328842554210024`*^9, 3.93288426269364*^9}, {3.932902015036389*^9, 
   3.932902027019211*^9}, {3.932902829288499*^9, 3.9329028310673447`*^9}, {
   3.93290911310822*^9, 3.932909138110684*^9}, {3.932909343278717*^9, 
   3.932909349891528*^9}, {3.932911619864629*^9, 3.9329116200016184`*^9}, {
   3.932911688464877*^9, 3.9329117196927433`*^9}, {3.932911761410077*^9, 
   3.9329117661837873`*^9}, {3.932982330036018*^9, 3.932982358762262*^9}, {
   3.93298241499078*^9, 3.9329824507972727`*^9}, {3.932982565638188*^9, 
   3.93298259925175*^9}, {3.932982632405789*^9, 3.932982655608004*^9}, 
   3.932982694545095*^9, {3.932982831354247*^9, 3.93298283463855*^9}, {
   3.933028456601035*^9, 3.93302846015568*^9}, {3.93302849993044*^9, 
   3.9330285138176613`*^9}, {3.9330285477970695`*^9, 
   3.9330286024470453`*^9}, {3.933028634451692*^9, 3.933028637094385*^9}, {
   3.933327147662936*^9, 3.93332720791558*^9}, {3.933759768889597*^9, 
   3.93375976978004*^9}, {3.948392735269702*^9, 3.9483927887782817`*^9}, 
   3.948393408426474*^9, {3.9485421295955563`*^9, 3.9485421524728966`*^9}, 
   3.948542256163239*^9, {3.950116964896164*^9, 3.950117046824061*^9}, {
   3.950117086431379*^9, 3.95011708715242*^9}, {3.950117117766037*^9, 
   3.950117131126587*^9}, {3.9501239063319836`*^9, 3.9501239354327087`*^9}, {
   3.950207651998661*^9, 3.950207653405109*^9}, {3.950282789709484*^9, 
   3.950282800905521*^9}, {3.950810169500791*^9, 3.9508101700669174`*^9}, {
   3.960368023645458*^9, 3.9603680666863785`*^9}, {3.960368138272129*^9, 
   3.960368139312212*^9}, {3.96036820379521*^9, 3.960368224466316*^9}, 
   3.960368261215927*^9, {3.9604387723219624`*^9, 3.960438797385252*^9}, {
   3.9604388919544373`*^9, 3.960438948015318*^9}, {3.9604616547962513`*^9, 
   3.9604616571180305`*^9}},ExpressionUUID->"90ffa799-ca12-2740-9789-\
5073b0f39528"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". RemoveVariationalRelation"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.950282867069502*^9, 
   3.960656265809843*^9},ExpressionUUID->"32f79c2c-9fab-7642-a299-\
2a726e780f28"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Removes", " ", "a", " ", "variational", " ", "relation"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"RemoveVariationalRelation", "[", 
    RowBox[{
     RowBox[{"mastertensor_", "?", "xTensorQ"}], "->", 
     RowBox[{"dependentTensor_", "?", "xTensorQ"}]}], "]"}], ":=", "\n", "\t", 
   RowBox[{"(", "\n", "\t", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EdgeQ", "[", 
        RowBox[{"$VariationalGraph", ",", 
         RowBox[{"mastertensor", "->", "dependentTensor"}]}], "]"}], ",", 
       "\n", "\t\t", 
       RowBox[{"(", "\n", "\t\t", 
        RowBox[{
         RowBox[{"$VariationalGraph", "=", 
          RowBox[{"EdgeDelete", "[", 
           RowBox[{"$VariationalGraph", ",", 
            RowBox[{"mastertensor", "->", "dependentTensor"}]}], "]"}]}], ";",
          "\n", "\t\t", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"$printAddVariationalRelation", "&&", "$UndefInfoQ"}], ",", 
           RowBox[{"Print", "[", 
            
            RowBox[{"\"\<** RemoveVariationalRelation: Variational relation \
removed \>\"", ",", "mastertensor", ",", "\"\<\[Rule]\>\"", ",", 
             "dependentTensor"}], "]"}]}], "]"}], ";"}], "\n", "\t\t", 
        ")"}]}], "\n", "\t", "]"}], ";", "\n", "\t", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Dagger", "[", "mastertensor", "]"}], "=!=", 
           "mastertensor"}], "||", 
          RowBox[{
           RowBox[{"Dagger", "[", "dependentTensor", "]"}], "=!=", 
           "dependentTensor"}]}], ")"}], "&&", "$RemoveVariationalRelation"}],
        ",", "\n", "\t\t", 
       RowBox[{"(", "\n", "\t\t", 
        RowBox[{
         RowBox[{"$RemoveVariationalRelation", "=", "False"}], ";", "\n", 
         "\t\t", 
         RowBox[{"RemoveVariationalRelation", "[", 
          RowBox[{
           RowBox[{"Dagger", "[", "mastertensor", "]"}], "->", 
           RowBox[{"Dagger", "[", "dependentTensor", "]"}]}], "]"}], ";", 
         "\n", "\t\t", 
         RowBox[{"$RemoveVariationalRelation", "=", "True"}], ";"}], "\n", 
        "\t\t", ")"}]}], "\n", "\t", "]"}], ";"}], "\n", "\t", 
    ")"}]}]}]], "Code",
 CellChangeTimes->{{3.950282808767006*^9, 3.950282815196205*^9}, {
   3.9508101879461346`*^9, 3.9508101885999603`*^9}, 3.9551126259018536`*^9, {
   3.9597498152468357`*^9, 3.9597498160477886`*^9}, {3.9604389869339466`*^9, 
   3.960439021742605*^9}, {3.960461563821165*^9, 3.960461591062002*^9}, {
   3.9604616352915974`*^9, 
   3.960461635415657*^9}},ExpressionUUID->"12a9d045-a33b-da42-bd19-\
ce590bc914c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". VertexDeleteAndUpdate"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.950282868626148*^9, 
   3.9606562677218723`*^9},ExpressionUUID->"ccd52743-1214-4f4e-bad1-\
9378d0c0cac5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"VertexDeleteAndUpdate", "[", "tensor_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"VertexQ", "[", 
       RowBox[{"$VariationalGraph", ",", "tensor"}], "]"}], ",", 
      RowBox[{"$VariationalGraph", "=", 
       RowBox[{"VertexDelete", "[", 
        RowBox[{"$VariationalGraph", ",", "tensor"}], "]"}]}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\t\t\t\t\t\t\t\t\t", "$VariationalGraph"}], 
   ")"}]}]], "Code",
 CellChangeTimes->{{3.950282817986183*^9, 3.950282826720436*^9}},
 CellLabel->
  "In[552]:=",ExpressionUUID->"444e6b8f-80d3-9d48-b3cd-53cdceafd7ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". VertexAddAndUpdate"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.9502828714470825`*^9, 
   3.9606562686840305`*^9},ExpressionUUID->"ae51d779-94d0-6d40-aa2d-\
c52566a6dc29"],

Cell[BoxData[
 RowBox[{
  RowBox[{"VertexAddAndUpdate", "[", "tensor_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"$VariationalGraph", "=", 
     RowBox[{"VertexAdd", "[", 
      RowBox[{"$VariationalGraph", ",", "tensor"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\t\t\t\t\t\t\t  ", "$VariationalGraph"}], 
   ")"}]}]], "Code",
 CellChangeTimes->{{3.950282828981146*^9, 3.9502828293415184`*^9}, {
  3.951224816881903*^9, 3.951224818889412*^9}},
 CellLabel->
  "In[553]:=",ExpressionUUID->"6357016a-c2db-1f4a-8c29-045b6b43cc18"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Extract variational relations"
}], "Subsection",
 CellChangeTimes->{
  3.932387283337832*^9, 3.932717004562273*^9, 3.932774505338171*^9, {
   3.9328200872568564`*^9, 3.932820087837497*^9}, {3.932880982219888*^9, 
   3.932880983419696*^9}, 3.948393369481866*^9, {3.9483934332128*^9, 
   3.9483934367039156`*^9}},ExpressionUUID->"bc981321-0f01-9a4c-b17d-\
eaadca97ef4a"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". VariationalRelationsOf"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, {3.9502828714470825`*^9, 
   3.9502828793912487`*^9}, 
   3.9606562702817287`*^9},ExpressionUUID->"853080af-1e04-c648-9946-\
b2a2f938a404"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Shows", " ", "all", " ", "variational", " ", "relations"}], " ", 
   "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "VariationalRelationsOf", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ConstantTensors", "->", "None"}], ",", 
       RowBox[{"Directed", "->", "Both"}], ",", 
       RowBox[{"HideTrivialRelations", " ", "->", " ", "True"}]}], "}"}]}], 
    ";"}], " ", "\n", "\n", 
   RowBox[{
    RowBox[{"VariationalRelationsOf", "[", 
     RowBox[{"tensors_", ",", " ", 
      RowBox[{"opts", " ", ":", " ", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"Options", "[", "VariationalRelationsOf", "]"}], "]"}]}]}], 
     "]"}], " ", ":=", " ", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"graph", ",", " ", "verticesToRemove"}], "}"}], ",", "\n", 
      "    ", 
      RowBox[{
       RowBox[{"graph", " ", "=", " ", 
        RowBox[{"HighlightConstantRelations", "[", "\n", "              ", 
         RowBox[{
          RowBox[{"SubGraphRelations", "[", 
           RowBox[{"$VariationalGraph", ",", " ", 
            RowBox[{"Flatten", "@", 
             RowBox[{"{", "tensors", "}"}]}], ",", " ", 
            RowBox[{"ToString", "@", 
             RowBox[{"OptionValue", "@", "Directed"}]}]}], "]"}], ",", "\n", 
          "              ", 
          RowBox[{"Flatten", "@", 
           RowBox[{"{", 
            RowBox[{"OptionValue", "@", "ConstantTensors"}], "}"}]}]}], "\n", 
         "    ", "]"}]}], ";", "\n", "    ", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"OptionValue", "[", "HideTrivialRelations", "]"}], ",", " ", 
         RowBox[{
          RowBox[{"graph", " ", "=", " ", 
           RowBox[{"VertexDelete", "[", 
            RowBox[{"graph", ",", " ", 
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"VertexList", "[", "graph", "]"}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"VertExactHeadQ", "[", "#", "]"}], "||", 
                 RowBox[{"VariationalVectorQ", "[", "#", "]"}]}], "&"}]}], 
              "]"}]}], "]"}]}], ";"}]}], " ", "]"}], ";", "\n", "    ", "\n", 
       "    ", 
       RowBox[{"Annotate", "[", 
        RowBox[{"graph", ",", "\n", "      ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"VertexStyle", " ", "->", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Alternatives", " ", "@@", " ", 
               RowBox[{"Flatten", "[", 
                RowBox[{"{", "tensors", "}"}], "]"}]}], " ", "->", " ", 
              "Green"}], "}"}]}], ",", " ", "\n", "       ", 
           RowBox[{"VertexShapeFunction", " ", "->", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Alternatives", " ", "@@", " ", 
               RowBox[{"Flatten", "[", 
                RowBox[{"{", "tensors", "}"}], "]"}]}], " ", "->", 
              " ", "\"\<Triangle\>\""}], "}"}]}]}], "}"}]}], "\n", "    ", 
        "]"}]}]}], "\n", "  ", "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.9483934162700634`*^9, {3.948542162708292*^9, 3.94854219749562*^9}, 
   3.9485422614110656`*^9, {3.950282880483818*^9, 3.950282885020315*^9}, {
   3.953060631862629*^9, 3.9530606368504105`*^9}, {3.9548568682294235`*^9, 
   3.9548568715833855`*^9}, {3.954856913505972*^9, 3.9548569140314655`*^9}, {
   3.9548574339717636`*^9, 3.954857456240204*^9}, 3.954858684458025*^9, {
   3.9548588420679226`*^9, 3.9548588444516983`*^9}, {3.9550953644569016`*^9, 
   3.955095388918659*^9}, {3.9558262693320274`*^9, 3.9558262697139034`*^9}, {
   3.95816134692293*^9, 3.9581613486977863`*^9}, {3.958161714273262*^9, 
   3.9581617158702526`*^9}, {3.958571129790739*^9, 3.9585711464393063`*^9}},
 CellLabel->
  "In[554]:=",ExpressionUUID->"61df0558-8c41-364c-8c4c-df9ab33692e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". ListVariationalRelationsOf"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, {3.9502828714470825`*^9, 
   3.950282901851982*^9}, 3.9502829399021664`*^9, {3.954857729988901*^9, 
   3.9548577337927837`*^9}, 3.9548582144583645`*^9, 3.954858355437044*^9, 
   3.9606562718662567`*^9},ExpressionUUID->"75f7417f-47c9-a54a-bd59-\
280fe6f333d1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ListVariationalRelationsOf", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Directed", "\[Rule]", "Both"}], ",", 
     RowBox[{"HideTrivialRelations", "\[Rule]", "False"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListVariationalRelationsOf", "[", 
   RowBox[{
    RowBox[{"tensor_", "?", "xTensorQ"}], ",", 
    RowBox[{"opt", " ", ":", " ", 
     RowBox[{"OptionsPattern", "[", 
      RowBox[{"Options", "[", "ListVariationalRelationsOf", "]"}], "]"}]}]}], 
   "]"}], ":=", 
  RowBox[{"VertexList", "[", 
   RowBox[{"VariationalRelationsOf", "[", 
    RowBox[{"tensor", ",", 
     RowBox[{"Directed", "->", 
      RowBox[{"OptionValue", "[", "Directed", "]"}]}], ",", 
     RowBox[{"HideTrivialRelations", "->", 
      RowBox[{"OptionValue", "[", "HideTrivialRelations", "]"}]}]}], "]"}], 
   "]"}]}]}], "Code",
 CellChangeTimes->{{3.954857416744196*^9, 3.954857462012682*^9}, {
   3.9548574992110806`*^9, 3.9548575349172554`*^9}, {3.954857622878542*^9, 
   3.954857734435831*^9}, 3.9548586831204453`*^9, {3.9548588497698193`*^9, 
   3.954858851891165*^9}, 3.9548589637326584`*^9, {3.954859037695038*^9, 
   3.954859051531481*^9}, {3.95485916078343*^9, 3.954859204802801*^9}, {
   3.954859317133154*^9, 3.954859318691744*^9}, {3.9548603290746613`*^9, 
   3.954860332386364*^9}, {3.958562638611431*^9, 3.9585626586821976`*^9}, {
   3.9585708309171066`*^9, 3.9585708544448376`*^9}, 3.9585711094362755`*^9, {
   3.958571144953556*^9, 3.9585711532420216`*^9}, 
   3.960536762866232*^9},ExpressionUUID->"fcdfcdeb-cff8-0844-9c28-\
da34f0242677"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". ListOfVariationalConstantsOf"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, {3.9502828714470825`*^9, 
   3.950282901851982*^9}, {3.9502829432819767`*^9, 3.9502829533763294`*^9}, 
   3.958499076464962*^9, 
   3.960656273249428*^9},ExpressionUUID->"c47a3d63-2d8f-5d4d-a29b-\
ccbdc4e7906f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ListOfVariationalConstantsOf", "[", "tensor_", "]"}], ":=", 
   RowBox[{"VertexOutComponent", "[", 
    RowBox[{
     RowBox[{"GenerateConstantGraph", "[", 
      RowBox[{"$VariationalGraph", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", "tensor", "}"}], "]"}]}], "]"}], ",", "tensor"}], 
    "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{
   "VariationalRelationsOf", ",", "ListVariationalRelationsOf", ",", 
    "ListOfVariationalConstantsOf"}], "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.950282923886774*^9, 3.950282927487053*^9}, {
   3.950284352165232*^9, 3.9502843524408417`*^9}, {3.9548570382873116`*^9, 
   3.9548570696527653`*^9}, {3.95485776319751*^9, 3.954857763357361*^9}, {
   3.954857867309143*^9, 3.9548578674269714`*^9}, 3.9564080942337933`*^9, {
   3.958161329527607*^9, 3.95816133542597*^9}, {3.9581617249885025`*^9, 
   3.958161774231062*^9}, {3.958162036963896*^9, 3.9581620383002415`*^9}, {
   3.958162075588848*^9, 3.958162081167631*^9}, {3.958162116032778*^9, 
   3.9581621279007263`*^9}, {3.9581621833389893`*^9, 3.958162249321274*^9}, {
   3.9584988295747414`*^9, 3.958498830506132*^9}, 3.9584989026598415`*^9},
 CellLabel->
  "In[558]:=",ExpressionUUID->"f766eee0-d333-234f-a2d2-ffc93cdba9a4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VariationallyConstantQ"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636654570007*^9}, {
   3.932912994384631*^9, 3.932913011303837*^9}, 3.948393449188588*^9, {
   3.950284481452938*^9, 
   3.950284481663761*^9}},ExpressionUUID->"cd6c82d2-b8ab-824a-b64d-\
d01d4d97a002"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "VariationallyConstantQ", " ", "takes", " ", "a", " ", 
     "ListConstantFields"}], ",", " ", 
    RowBox[{"a", " ", "ListNonConstantFields"}], ",", " ", 
    RowBox[{"and", " ", "a", " ", "tensor"}], ",", " ", 
    RowBox[{
     RowBox[{"and", " ", "checks", " ", "if", " ", "tensor"}], " ", "\[Element]",
      " ", 
     RowBox[{
      RowBox[{"VertDiff", "[", "ListConstantFields", "]"}], " ", "or", " ", 
      "tensor"}], " ", "\[NotElement]", " ", 
     RowBox[{"VertDiff", "[", "ListNonConstantFields", "]"}]}]}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VariationallyConstantQ", "[", 
      RowBox[{"ListConstantFields_", ",", "ListNonConstantFields_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"VariationallyConstantQ", "[", 
      RowBox[{"ListConstantFields", ",", "ListNonConstantFields"}], "]"}], "[",
      "tensor", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VariationallyConstantQ", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "]"}], "[", "tensor_", "]"}], ":=", "False"}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VariationallyConstantQ", "[", 
      RowBox[{"ListConstantFields_", ",", 
       RowBox[{"{", "}"}]}], "]"}], "[", "tensor_", "]"}], ":=", 
    RowBox[{"With", "[", "\n", "\t\t", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"list", "=", 
        RowBox[{"ListOfVariationalConstantsOf", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", "ListConstantFields", "}"}], "~", "Join", "~", 
           RowBox[{"{", 
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"MasterOf", "/@", "ListConstantFields"}], ",", 
              "xTensorQ"}], "]"}], "}"}]}], "//", "Flatten"}], "]"}]}], "}"}],
       ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "We", " ", "create", " ", "the", " ", "list", " ", "of", " ", 
        "tensors", " ", "that", " ", "are", " ", "related", " ", "to", " ", 
        "the", " ", 
        RowBox[{"constants", ".", " ", "Those"}], " ", "are", " ", "the", " ",
         "only", " ", "ones", " ", "that", " ", "are", " ", "not", " ", 
        "constant", " ", 
        RowBox[{"(", 
         RowBox[{
         "we", " ", "have", " ", "to", " ", "add", " ", "their", " ", 
          "VertDiff"}], ")"}]}], " ", "*)"}], "\n", "\t\t", 
      RowBox[{"MemberQ", "[", 
       RowBox[{"list", ",", "tensor"}], "]"}]}], "\n", "\t\t", "]"}]}], " ", 
   "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"VariationallyConstantQ", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "ListNonConstantFields_"}], "]"}], "[", 
     "tensor_", "]"}], ":=", 
    RowBox[{"With", "[", "\n", "\t\t", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"list", "=", 
        RowBox[{
         RowBox[{"ListVariationalRelationsOf", "/@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "ListNonConstantFields", "}"}], "~", "Join", "~", 
             RowBox[{"{", 
              RowBox[{"Select", "[", 
               RowBox[{
                RowBox[{"MasterOf", "/@", "ListNonConstantFields"}], ",", 
                "xTensorQ"}], "]"}], "}"}]}], "//", "Flatten"}], ")"}]}], "//",
          "Flatten"}]}], "}"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "We", " ", "create", " ", "the", " ", "list", " ", "of", " ", 
        "tensors", " ", "that", " ", "are", " ", "related", " ", "to", " ", 
        "the", " ", 
        RowBox[{"constants", ".", " ", "Those"}], " ", "are", " ", "the", " ",
         "only", " ", "ones", " ", "that", " ", "are", " ", "not", " ", 
        "constant", " ", 
        RowBox[{"(", 
         RowBox[{
         "we", " ", "have", " ", "to", " ", "add", " ", "their", " ", 
          "VertDiff"}], ")"}]}], " ", "*)"}], "\n", "\t\t", 
      RowBox[{"!", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"list", "~", "Join", "~", 
           RowBox[{"DeleteElements", "[", 
            RowBox[{
             RowBox[{"VertDiff", "/@", "list"}], "\[InvisibleSpace]", ",", 
             RowBox[{"{", "Zero", "}"}]}], "]"}]}], "//", 
          "DeleteDuplicates"}], ",", "tensor"}], "]"}]}]}], "\n", "\t\t", 
     "]"}]}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandVertDiff", "::", "unknown"}], 
     "=", "\"\<The options ConstantTensors and NonConstantTensors are \
incompatible.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"VariationallyConstantQ", "[", 
       RowBox[{"ListConstantFields_", ",", "ListNonConstantFields_"}], "]"}], 
      "[", "tensor_", "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{"ExpandVertDiff", "::", "unknown"}], "]"}]}]}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "VariationallyConstantQ", "]"}], 
    ";"}]}]}]], "Code",
 CellChangeTimes->{{3.932619075650244*^9, 3.932619080001449*^9}, {
   3.932619145291339*^9, 3.932619191649563*^9}, 3.932619532009255*^9, {
   3.932619919486396*^9, 3.932619948123744*^9}, {3.932620118912886*^9, 
   3.932620127476369*^9}, {3.932620262498209*^9, 3.932620331839549*^9}, {
   3.93262046686193*^9, 3.932620469633525*^9}, {3.9326205988866987`*^9, 
   3.932620619013636*^9}, {3.9326207179440427`*^9, 3.9326207578048534`*^9}, {
   3.932620880929153*^9, 3.932620884393224*^9}, {3.932621235719223*^9, 
   3.9326212449234*^9}, {3.932621604138775*^9, 3.932621604212204*^9}, {
   3.9326216746293983`*^9, 3.932621675848107*^9}, {3.932621708037769*^9, 
   3.932621708405396*^9}, {3.9326218346621447`*^9, 3.932621841756865*^9}, {
   3.9326218740871725`*^9, 3.932621899758004*^9}, {3.932621932821681*^9, 
   3.9326219664123745`*^9}, {3.932622008121103*^9, 3.932622060023746*^9}, {
   3.932622123545478*^9, 3.932622125812146*^9}, {3.932622394849876*^9, 
   3.932622395808299*^9}, {3.932622428068828*^9, 3.932622599910934*^9}, {
   3.932622631655539*^9, 3.932622700963664*^9}, {3.932622816588758*^9, 
   3.932622859705844*^9}, {3.9326228955119357`*^9, 3.932622950976273*^9}, {
   3.932623023526114*^9, 3.932623049144687*^9}, {3.932627486367681*^9, 
   3.9326274912653427`*^9}, {3.93262755097435*^9, 3.932627552498367*^9}, {
   3.9326360659779835`*^9, 3.932636146045581*^9}, {3.932636258833288*^9, 
   3.932636294555435*^9}, {3.932636470791577*^9, 3.932636562602659*^9}, {
   3.932637002346007*^9, 3.932637010945378*^9}, 3.9326370456318097`*^9, {
   3.932646566900793*^9, 3.932646572401173*^9}, {3.932651275772865*^9, 
   3.932651331853497*^9}, {3.932653022080964*^9, 3.93265308870323*^9}, {
   3.932653123294137*^9, 3.932653170314725*^9}, {3.932653209365907*^9, 
   3.932653239313118*^9}, {3.932653383477103*^9, 3.932653383755189*^9}, {
   3.932653470813143*^9, 3.932653500266369*^9}, {3.932654743263907*^9, 
   3.932654765792222*^9}, {3.932654809045422*^9, 3.932654810430428*^9}, {
   3.932654942807619*^9, 3.9326549437313337`*^9}, {3.932654999760071*^9, 
   3.932655063055512*^9}, {3.932655105817607*^9, 3.932655108953068*^9}, {
   3.932655141616947*^9, 3.9326551417824283`*^9}, {3.932655964147455*^9, 
   3.932655988527237*^9}, {3.93280249182657*^9, 3.9328025504400983`*^9}, {
   3.932802655951404*^9, 3.932802664921091*^9}, {3.932880402214791*^9, 
   3.932880404358198*^9}, {3.9328812049054003`*^9, 3.932881206579859*^9}, {
   3.932883041856253*^9, 3.932883083356242*^9}, {3.932883618274258*^9, 
   3.93288361828395*^9}, {3.932888383534926*^9, 3.932888385638922*^9}, {
   3.932912994390632*^9, 3.9329130113258343`*^9}, {3.932982801633052*^9, 
   3.932982808530206*^9}, 3.9329828669694757`*^9, {3.932982904270522*^9, 
   3.932982921789264*^9}, {3.932982985444713*^9, 3.932983068853789*^9}, {
   3.932983137954879*^9, 3.9329831670879354`*^9}, {3.9329833104300165`*^9, 
   3.93298337852334*^9}, 3.9329835237029905`*^9, {3.932983622587528*^9, 
   3.9329837023241687`*^9}, {3.948542265713837*^9, 3.948542278294015*^9}, {
   3.9502844668156643`*^9, 3.95028446821904*^9}, {3.951080448517191*^9, 
   3.9510804601727924`*^9}, {3.951080501365291*^9, 3.951080579658455*^9}, {
   3.951080619365761*^9, 3.9510806782636337`*^9}, {3.9510807105590897`*^9, 
   3.9510807498082714`*^9}, {3.951080826800197*^9, 3.951081015454172*^9}, {
   3.9520901931688156`*^9, 3.952090195848034*^9}, {3.9545777283931656`*^9, 
   3.954577741295149*^9}, {3.9560846349527283`*^9, 3.956084657387192*^9}, {
   3.957368673504162*^9, 3.957368798019779*^9}, {3.957369085345766*^9, 
   3.957369087006445*^9}, 3.958312868855461*^9},
 CellLabel->
  "In[560]:=",ExpressionUUID->"d77382ec-9598-f245-949c-99599d4df8b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VertDiffOfTensorToHoldQ"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636654570007*^9}, {
   3.932912994384631*^9, 3.932913011303837*^9}, 3.948393449188588*^9, {
   3.950284483262636*^9, 
   3.9502844843702583`*^9}},ExpressionUUID->"cd493a00-ac96-5d4c-b725-\
3b67c6fbeadb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "VertDiffOfTensorToHoldQ", " ", "takes", " ", "a", " ", 
     "ListTensorsToHold", " ", "and", " ", "checks", " ", "if", " ", 
     "dltensor"}], " ", "\[Element]", " ", 
    RowBox[{"ListConstantFields", " ", "or", " ", "dltensor"}], " ", "\[Element]",
     " ", 
    RowBox[{"VertDiff", "[", "ListNonConstantFields", "]"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VertDiffOfTensorToHoldQ", "[", 
      RowBox[{"{", "}"}], "]"}], "[", "dltensor_", "]"}], ":=", "False"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"VertDiffOfTensorToHoldQ", "[", "ListTensorsToHold_", "]"}], "[", 
     RowBox[{"dltensor_", "[", "inds___", "]"}], "]"}], ":=", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"ListTensorsToHold", ",", " ", 
         RowBox[{"VertDiff", " ", "/@", " ", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", "ListTensorsToHold", "}"}], "]"}]}]}], "}"}], "]"}], ",",
       " ", "dltensor"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.951080473003668*^9, 3.951080473436268*^9}, {
  3.957368777580557*^9, 3.9573687821514893`*^9}},
 CellLabel->
  "In[567]:=",ExpressionUUID->"9e625bb5-9620-334a-86a3-d2ded33cd184"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Imploded tensors"
}], "Section",
 CellChangeTimes->{{3.9318354624722424`*^9, 3.931835484129775*^9}, 
   3.9320167269954023`*^9, {3.932387378458019*^9, 3.932387379158229*^9}, 
   3.948395593868109*^9, 3.948396744952749*^9, {3.9583017866073914`*^9, 
   3.958301790159588*^9}, 
   3.9586482839484615`*^9},ExpressionUUID->"32fafa74-df4b-7c4f-b843-\
c7eae3dd35dc"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VariationalRelationsOfImploded"
}], "Subsection",
 CellChangeTimes->{
  3.932387422333253*^9, {3.932636645953134*^9, 3.932636654570007*^9}, {
   3.932912994384631*^9, 3.932913011303837*^9}, 3.948393449188588*^9, {
   3.950284483262636*^9, 3.9502844843702583`*^9}, {3.9583017950066414`*^9, 
   3.9583018001596565`*^9}, 
   3.9583023054675426`*^9},ExpressionUUID->"1333ba40-c840-084b-aafb-\
8302c9854c1a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VariationalRelationsOfImploded", "[", "tensor_Symbol", "]"}], ":=", 
   RowBox[{"DeleteDuplicates", "[", 
    RowBox[{"VariationalRelationsOfImploded", "[", 
     RowBox[{"tensor", ",", 
      RowBox[{"TensorID", "[", "tensor", "]"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "it", " ", "is", " ", "not", " ", "der", " ", "of", " ", "a", " ",
      "scalar"}], ",", " ", 
    RowBox[{
    "it", " ", "must", " ", "depend", " ", "on", " ", "the", " ", 
     "christoffels", " ", "and", " ", "the", " ", 
     "VariationalDependendiesOfImploded", " ", "of", " ", "its", " ", 
     RowBox[{"master", "."}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VariationalRelationsOfImploded", "[", 
    RowBox[{"tensor_", ",", 
     RowBox[{"{", 
      RowBox[{"CovD", ",", "covd_", ",", "linds_Integer", ",", "intensor_"}], 
      "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", "\n", "\t", 
    RowBox[{
     RowBox[{"{", "\n", "\t", 
      RowBox[{
       RowBox[{"tangentIndicesQ", "=", 
        RowBox[{
         RowBox[{"Length", "@", 
          RowBox[{"Select", "[", 
           RowBox[{
            RowBox[{"HostsOf", "@", "intensor"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"VBundleQ", "[", "#", "]"}], "&&", 
              RowBox[{
               RowBox[{"Tangent", "@", 
                RowBox[{"BaseOfVBundle", "[", "#", "]"}]}], "===", "#"}]}], 
             "&"}]}], "]"}]}], ">", "0"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"HostsOf", "@", "Scalar"}], "=", 
          RowBox[{"{", "manifold", "}"}]}], ",", " ", 
         RowBox[{
          RowBox[{"HostsOf", "@", "Tensor"}], "=", 
          RowBox[{"{", 
           RowBox[{"manifold", ",", 
            RowBox[{
            "all", " ", "VBundles", " ", "it", " ", "has", " ", "indices", " ",
              "on"}]}], " "}]}]}], "*)"}], "\n", "\t", 
       RowBox[{"innerVBindicesQ", "=", 
        RowBox[{
         RowBox[{"Length", "@", 
          RowBox[{"Select", "[", 
           RowBox[{
            RowBox[{"HostsOf", "@", "intensor"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"VBundleQ", "[", "#", "]"}], "&&", 
              RowBox[{
               RowBox[{"Tangent", "@", 
                RowBox[{"BaseOfVBundle", "[", "#", "]"}]}], "=!=", "#"}]}], 
             "&"}]}], "]"}]}], ">", "0"}]}], ",", "\n", "\t", 
       "listOfChristoffels"}], "\n", "\t", "}"}], ",", "\n", "\t", 
     RowBox[{
      RowBox[{"listOfChristoffels", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"tangentIndicesQ", ",", 
           RowBox[{"ChristoffelAUX", "@", "covd"}], ",", 
           RowBox[{"{", "}"}]}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{"innerVBindicesQ", ",", 
           RowBox[{"AChristoffelAUX", "@", "covd"}], ",", 
           RowBox[{"{", "}"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
       "\t", 
      RowBox[{"Join", "[", 
       RowBox[{"listOfChristoffels", ",", 
        RowBox[{"VariationalRelationsOfImploded", "@", "intensor"}]}], 
       "]"}]}]}], "\n", "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"This", " ", "are", " ", "simply", " ", "PD"}], ",", " ", 
    RowBox[{
    "so", " ", "it", " ", "only", " ", "depends", " ", "on", " ", "the", " ", 
     "VariationalDependendiesOfImploded", " ", "of", " ", "its", " ", 
     "master"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VariationalRelationsOfImploded", "[", 
    RowBox[{"tensor_", ",", 
     RowBox[{"{", 
      RowBox[{"ParamD", ",", "ps__", ",", "intensor_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"VariationalRelationsOfImploded", "@", "intensor"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VariationalRelationsOfImploded", "[", 
     RowBox[{"tensor_", ",", 
      RowBox[{"{", 
       RowBox[{"OverDot", ",", "intensor_"}], "}"}]}], "]"}], ":=", 
    RowBox[{"VariationalRelationsOfImploded", "@", "intensor"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "LieD", " ", "depends", " ", "on", " ", "the", " ", "vector", " ", "and", " ",
     "the", " ", "VariationalDependendiesOfImploded", " ", "of", " ", "its", " ",
     "master"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VariationalRelationsOfImploded", "[", 
     RowBox[{"tensor_", ",", 
      RowBox[{"{", 
       RowBox[{"LieD", ",", "v_", ",", "intensor_"}], "}"}]}], "]"}], ":=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "v", "}"}], ",", 
      RowBox[{"VariationalRelationsOfImploded", "@", "intensor"}]}], "]"}]}], 
   ";"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Case", " ", "base"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VariationalRelationsOfImploded", "[", 
   RowBox[{
    RowBox[{"tensor_", "?", "xTensorQ"}], ",", "_"}], "]"}], ":=", 
  RowBox[{"{", "tensor", "}"}]}]}], "Code",
 CellChangeTimes->{{3.9583018048799133`*^9, 3.9583019430459576`*^9}, {
   3.958302299440441*^9, 3.9583023140489006`*^9}, 3.9588711451334343`*^9, {
   3.9594030684030895`*^9, 3.9594030933742485`*^9}, {3.9594031507110004`*^9, 
   3.959403228155451*^9}, {3.9594035379885044`*^9, 3.959403611270727*^9}, {
   3.9594036797701607`*^9, 3.959403802196953*^9}},
 CellLabel->
  "In[569]:=",ExpressionUUID->"287419fc-7aff-6a4c-836e-d5bc44d54b3e"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ". Definition of vertical forms and how to expand them"
}], "Chapter",
 CellChangeTimes->{{3.9318353438923273`*^9, 3.93183534696952*^9}, {
  3.932636606099285*^9, 3.9326366080589304`*^9}, {3.948391736052903*^9, 
  3.9483917549598455`*^9}, {3.948392906134357*^9, 3.948392912502523*^9}, {
  3.9483954133854113`*^9, 3.948395418517416*^9}, {3.9483967382665772`*^9, 
  3.948396741045464*^9}, {3.9586482879320164`*^9, 
  3.958648289398945*^9}},ExpressionUUID->"66580573-b17b-de41-b812-\
171b950ce052"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Vertical forms"
}], "Section",
 CellChangeTimes->{{3.9318354624722424`*^9, 3.931835484129775*^9}, 
   3.9320167269954023`*^9, {3.932387378458019*^9, 3.932387379158229*^9}, 
   3.948395593868109*^9, 3.948396744952749*^9, 
   3.9586482933601646`*^9},ExpressionUUID->"996fd119-a6f0-d44b-b211-\
7f190d912352"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification DefTensor"
}], "Subsection",
 CellChangeTimes->{3.932387355586685*^9, 
  3.948396702920955*^9},ExpressionUUID->"4d7b55a4-c6e5-e143-8808-\
3406b09dd06c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"DefTensor", " ", "defines"}], ",", " ", 
    RowBox[{"apart", " ", "from", " ", "the", " ", "tensor"}], ",", " ", 
    RowBox[{
    "its", " ", "vertical", " ", "exterior", " ", "derivative", " ", "and", " ",
      "its", " ", "variational", " ", "vector"}]}], " ", "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"Unprotect", "[", "DefTensor", "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "DefTensor", "]"}], "=", 
     RowBox[{
      RowBox[{"Options", "[", "DefTensor", "]"}], "~", "Join", "~", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DefineExactFormAfterDefTensor", "->", "True"}], ",", 
        RowBox[{"DefineVariationalVectorAfterDefTensor", "->", "True"}], ",", 
        RowBox[{"VariationallyConstantQ", "->", "False"}], ",", 
        RowBox[{"VertDeg", "->", "0"}]}], "}"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "DefAdditionalTensors", "]"}], "=", 
     RowBox[{
      RowBox[{"Options", "[", "DefTensor", "]"}], "~", "Join", "~", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DefInverseMetric", "->", "False"}], ",", 
        RowBox[{"PrintInverse", "->", "False"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "DefTensor", "]"}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"xTension", "[", 
     RowBox[{"\"\<xAct`xTensor`\>\"", ",", " ", "DefTensor", ",", 
      " ", "\"\<End\>\""}], "]"}], ":=", "DefAdditionalTensors"}], "\n", "\n", 
   RowBox[{
    RowBox[{"OptionsToBeRemoved", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GradeOfTensor", "->", "_"}], ",", 
       RowBox[{"DefInfo", "->", "_"}], ",", 
       RowBox[{"DefInfo", ":>", "_"}], ",", 
       RowBox[{"Master", "->", "_"}], ",", 
       RowBox[{"PrintAs", "\[Rule]", "_"}], ",", 
       RowBox[{"FrobeniusQ", "\[Rule]", "_"}], ",", 
       RowBox[{"OrthogonalTo", "->", "_"}], ",", 
       RowBox[{"OrthogonalTo", ":>", "_"}], ",", 
       RowBox[{"ProjectedWith", "\[Rule]", "_"}], ",", 
       RowBox[{"ProjectedWith", ":>", "_"}], ",", 
       RowBox[{"ProtectNewSymbol", "->", "_"}], ",", 
       RowBox[{"TensorID", "\[Rule]", "_"}], ",", 
       RowBox[{"VariationallyConstantQ", "->", "_"}], ",", 
       RowBox[{"WeightOfTensor", "->", "_"}], ",", 
       RowBox[{"DefineExactFormAfterDefTensor", "->", "_"}], ",", 
       RowBox[{"DefineVariationalVectorAfterDefTensor", "->", "_"}]}], 
      "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"DefAdditionalTensors", "[", 
     RowBox[{
      RowBox[{"tensor_", "[", "indices___", "]"}], ",", "dependencies_", ",", 
      "sym_", ",", 
      RowBox[{"options", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"Options", "[", "DefAdditionalTensors", "]"}], "]"}]}]}], 
     "]"}], ":=", "\n", "\t", 
    RowBox[{"(", "\n", "\t", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"OptionValue", "[", "VertDeg", "]"}], "=!=", "0"}], ",", 
        RowBox[{"tensor", "/:", 
         RowBox[{"GradeOfTensor", "[", 
          RowBox[{"tensor", ",", "WWedge"}], "]"}], ":=", 
         RowBox[{"OptionValue", "[", "VertDeg", "]"}]}]}], "]"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "This", " ", "allows", " ", "the", " ", "option", " ", 
         "GradeOfTensor"}], "->", 
        RowBox[{"{", 
         RowBox[{"WWedge", "->", "integer"}], "}"}]}], " ", "*)"}], "\n", 
      "\t", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"OptionValue", "[", "DefInverseMetric", "]"}]}], ",", "\n", 
        "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"VertexAddAndUpdate", "[", "tensor", "]"}], ";", "\n", 
          "\t\t", 
          RowBox[{
           RowBox[{"PartialPartialsOfTensor", "[", "tensor", "]"}], "^=", 
           RowBox[{"{", "}"}]}], ";"}], "\n", "\t\t", ")"}]}], "\n", "\t", 
       "]"}], ";", "\n", "\t", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"OptionValue", "[", "DefineExactFormAfterDefTensor", "]"}], ",", 
        RowBox[{"DefExactVerticalForm", "[", 
         RowBox[{
          RowBox[{"tensor", "[", "indices", "]"}], ",", "dependencies", ",", 
          "sym", ",", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Flatten", "[", 
              RowBox[{"{", "options", "}"}], "]"}], "/.", " ", 
             RowBox[{"{", 
              RowBox[{
              "VariationallyConstantQ", " ", "->", " ", "VanishingQ"}], 
              "}"}]}], ",", 
            RowBox[{"Alternatives", "@@", "OptionsToBeRemoved"}], ",", "2"}], 
           "]"}]}], "]"}]}], "]"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "We", " ", "remove", " ", "the", " ", "PrintAs", " ", "of", " ", "the",
         " ", "tensor", " ", 
        RowBox[{"(", 
         RowBox[{"not", " ", "of", " ", "the", " ", "dltensor"}], ")"}], " ", 
        "and", " ", "change", " ", "VariationallyConstantQ", " ", "with", " ",
         "VanishingQ"}], " ", "*)"}], "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
        "OptionValue", "[", "DefineVariationalVectorAfterDefTensor", "]"}], ",", 
        RowBox[{"DefVariationalVector", "[", 
         RowBox[{
          RowBox[{"tensor", "[", "indices", "]"}], ",", "dependencies", ",", 
          RowBox[{"SymmetryGroupOfTensor", "[", "tensor", "]"}], ",", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{
            RowBox[{"Flatten", "[", 
             RowBox[{"{", "options", "}"}], "]"}], ",", 
            RowBox[{"Alternatives", "@@", "OptionsToBeRemoved"}], ",", "2"}], 
           "]"}]}], "]"}]}], "]"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "We", " ", "remove", " ", "the", " ", "PrintAs", " ", "of", " ", "the",
         " ", "tensor", " ", 
        RowBox[{"(", 
         RowBox[{"not", " ", "of", " ", "the", " ", "VariationalVector"}], 
         ")"}], " ", "and", " ", "VariationallyConstantQ"}], " ", "*)"}], 
      "\n", "\n", "    ", 
      RowBox[{"(*", 
       RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
       "******)"}], "\n", "    ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"**", "**", " ", "COMPLEX"}], " ", "TENSORS"}], " ", 
       "*****)"}], "\n", "    ", 
      RowBox[{"(*", 
       RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
       "******)"}], "\n", "\n", "    ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Complex", " ", "tensor", " ", "with", " ", "dagger", " ", "in", " ", 
        "its", " ", "name", " ", 
        RowBox[{"(", 
         RowBox[{"to", " ", "avoid", " ", "doing", " ", "it", " ", "twice"}], 
         ")"}]}], " ", "*)"}], "\t", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"HasDaggerCharacterQ", "[", "tensor", "]"}], ",", "\n", 
        "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"$printAddVariationalRelation", "=", "False"}], ";", "\n", 
          "\t\t", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"!", 
              RowBox[{"VertExactHeadQ", "[", "tensor", "]"}]}], "&&", 
             RowBox[{"!", 
              RowBox[{"VariationalVectorQ", "[", "tensor", "]"}]}]}], ",", 
            "\n", "\t\t\t", 
            RowBox[{
             RowBox[{"AddVariationalRelation", "[", 
              RowBox[{"tensor", "->", 
               RowBox[{
                RowBox[{"Dagger", "@", "tensor"}], "->", "tensor"}]}], "]"}], 
             ";"}]}], " ", 
           RowBox[{"(*", " ", 
            RowBox[{
            "Only", " ", "the", " ", "master", " ", "tensors", " ", "are", " ",
              "variationally", " ", "related", " ", "to", " ", "avoid", " ", 
             "cluttering", " ", "too", " ", "much", " ", "the", " ", "graph", 
             " ", 
             RowBox[{"(", 
              RowBox[{
              "the", " ", "dl", " ", "tensors", " ", "and", " ", 
               "variational", " ", "vectors", " ", "are", " ", "effectively", 
               " ", "related", " ", "through", " ", "their", " ", "masters"}],
               " "}]}], "*)"}], " ", "\n", "\t\t", "]"}], ";", "\n", "\t\t", 
          "\n", "\t    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"VertExactHeadQ", "[", "tensor", "]"}], ",", " ", 
            RowBox[{"(*", " ", 
             RowBox[{"Complex", " ", "dltensor"}], " ", "*)"}], "\n", 
            "\t\t\t", 
            RowBox[{"(", "\n", "\t\t\t", 
             RowBox[{
              RowBox[{
               RowBox[{"PrintAs", "[", 
                RowBox[{"Evaluate", "[", "tensor", "]"}], "]"}], "^=", 
               RowBox[{"Evaluate", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"GenerateDiffName", "[", 
                   RowBox[{
                    RowBox[{"MasterOfCPSTensor", "@", "tensor"}], ",", 
                    RowBox[{"PrintAs", "->", 
                    RowBox[{"PrintAs", "[", 
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"MasterOfCPSTensor", "@", "tensor"}], "]"}], 
                    "]"}]}]}], "]"}], ")"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", 
              RowBox[{"(*", " ", 
               RowBox[{
               "This", " ", "improves", " ", "the", " ", "PrintAs", " ", "of",
                 " ", 
                RowBox[{"Dagger", "@", "VertDiff"}]}], " ", "*)"}], "\n", 
              "\t\t\t", 
              RowBox[{"AddVariationalRelation", "[", 
               RowBox[{
                RowBox[{"MasterOfCPSTensor", "@", "tensor"}], "->", 
                "tensor"}], "]"}], ";"}], "\n", "\t\t\t", ")"}]}], "\n", 
           "\t\t", "]"}], ";", "\n", "\n", "\t\t", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"VariationalVectorQ", "[", "tensor", "]"}], ",", " ", 
            RowBox[{"(*", " ", 
             RowBox[{"Complex", " ", "VariationalVectortensor"}], " ", "*)"}],
             "\t", "\n", "\t\t\t", 
            RowBox[{"(", "\n", "\t\t\t", 
             RowBox[{
              RowBox[{
               RowBox[{"PrintAs", "[", 
                RowBox[{"Evaluate", "[", "tensor", "]"}], "]"}], "^=", 
               RowBox[{"Evaluate", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"GenerateVariationalName", "[", 
                   RowBox[{
                    RowBox[{"MasterOfCPSTensor", "@", "tensor"}], ",", 
                    RowBox[{"PrintAs", "->", 
                    RowBox[{"PrintAs", "[", 
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"MasterOfCPSTensor", "@", "tensor"}], "]"}], 
                    "]"}]}]}], "]"}], ")"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", 
              RowBox[{"(*", " ", 
               RowBox[{
               "This", " ", "improves", " ", "the", " ", "PrintAs", " ", "of",
                 " ", 
                RowBox[{"Dagger", "@", "VariationalVector"}]}], " ", "*)"}], 
              "\n", "\t\t\t", 
              RowBox[{"AddVariationalRelation", "[", 
               RowBox[{
                RowBox[{"MasterOfCPSTensor", "@", "tensor"}], "->", 
                "tensor"}], "]"}], ";", "\n", "            ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"$DefInfoQ", "&&", 
                 RowBox[{"!", 
                  RowBox[{"CovDQ", "[", 
                   RowBox[{"MasterOf", "@", 
                    RowBox[{"MasterOfCPSTensor", "@", 
                    RowBox[{"Dagger", "@", "tensor"}]}]}], "]"}]}]}], ",", 
                RowBox[{
                "Print", 
                 "[", "\"\<** AddVariationalRelation: Variational relations \
created for conjugated tensors\>\"", "]"}]}], "]"}], ";"}], " ", 
             RowBox[{"(*", " ", 
              RowBox[{
              "This", " ", "is", " ", "printed", " ", "at", " ", "the", " ", 
               "end"}], " ", "*)"}], "\n", "\t\t\t", ")"}]}], "\n", "\t\t", 
           "]"}], ";", "\n", "\t\t ", "\n", "\t\t", 
          RowBox[{"$printAddVariationalRelation", "=", "True"}], ";"}], "\n", 
         "\t\t", ")"}]}], "\n", "\t", "]"}], ";", "\n", "\t", "\n", "    ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], "*"}],
        "******)"}], "\n", "    ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"**", "**", " ", "IMPLODED"}], " ", "TENSORS"}], " ", 
       "*****)"}], "\n", "    ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], "*"}],
        "******)"}], "\n", "\t", "\n", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "When", " ", "dealing", " ", "with", " ", "Imploded", " ", 
         "tensors"}], ",", " ", 
        RowBox[{
        "we", " ", "only", " ", "want", " ", "to", " ", "create", " ", "the", 
         " ", "variational", " ", "relations", " ", "of", " ", "the", " ", 
         "Master", " ", 
         RowBox[{"(", 
          RowBox[{
          "not", " ", "the", " ", "VertDiff", " ", "or", " ", 
           "VariationalVector"}], ")"}]}]}], " ", "*)"}], "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"OptionValue", "[", "DefineExactFormAfterDefTensor", "]"}], "&&", 
         RowBox[{
         "OptionValue", "[", "DefineVariationalVectorAfterDefTensor", "]"}], "&&", 
         RowBox[{"xAct`xTensor`Private`ImplodedQ", "[", "tensor", "]"}]}], ",",
         "\n", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"$printAddVariationalRelation", "=", "$ImplodeInfoQ"}], ";",
           "\n", "\t\t", 
          RowBox[{
           RowBox[{
            RowBox[{"AddVariationalRelation", "[", 
             RowBox[{"#", "->", "tensor"}], "]"}], "&"}], "/@", 
           RowBox[{"DeleteElements", "[", 
            RowBox[{
             RowBox[{"VariationalRelationsOfImploded", "[", "tensor", "]"}], ",", 
             RowBox[{"{", "Zero", "}"}]}], "]"}]}], ";", "\n", "\t\t", 
          RowBox[{"$printAddVariationalRelation", "=", "True"}], ";"}], "\n", 
         "\t\t", ")"}]}], "\n", "\t", "]"}], ";", "\n", "\t", "\n", "    ", 
      RowBox[{"(*", 
       RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
       "*********)"}], "\n", "    ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"**", "**", " ", "DOUBLE"}], " ", "CHRISTOFFEL"}], " ", 
       "*****)"}], "\n", "    ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**"}], "*", 
        "**"}], "******)"}], "\n", "    ", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", 
           RowBox[{"TensorID", "@", "tensor"}]}], "===", "3"}], "&&", 
         RowBox[{
          RowBox[{
           RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "===", "Christoffel"}], "&&", 
         RowBox[{"CovDQ", "[", 
          RowBox[{
           RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], "&&", 
         RowBox[{"CovDQ", "[", 
          RowBox[{
           RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "]"}], "&&", 
         RowBox[{
          RowBox[{
           RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "=!=", "PD"}]}], ",", "\n", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{
           RowBox[{"ChristoffelAUX", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "=", "tensor"}], ";", 
          " ", 
          RowBox[{"(*", " ", 
           RowBox[{"For", " ", "TensorWithIndices"}], " ", "*)"}], "\n", 
          "\t\t", 
          RowBox[{
           RowBox[{"ChristoffelAUX", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "=", 
           RowBox[{"MultiplyHead", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "tensor"}], "]"}]}], ";", " ", 
          RowBox[{"(*", " ", 
           RowBox[{"For", " ", "TensorWithIndices"}], " ", "*)"}], "\n", 
          "\t\t", 
          RowBox[{"Unprotect", "[", 
           RowBox[{"VertDiff", ",", "Christoffel"}], "]"}], ";", "\n", "\t\t", 
          RowBox[{"Christoffel", "/:", " ", 
           RowBox[{"VertDiff", "[", 
            RowBox[{"Christoffel", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}], "=", 
           RowBox[{"VertDiff", "@", "tensor"}]}], ";", "\n", "\t\t", 
          RowBox[{"Christoffel", "/:", " ", 
           RowBox[{"VertDiff", "[", 
            RowBox[{"Christoffel", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], "=", 
           RowBox[{"MultiplyHead", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", 
             RowBox[{"VertDiff", "@", "tensor"}]}], "]"}]}], ";", "\n", 
          "\t\t", 
          RowBox[{"Protect", "[", 
           RowBox[{"VertDiff", ",", "Christoffel"}], "]"}], ";", "\n", "\t\t", 
          RowBox[{"AddVariationalRelation", "[", 
           RowBox[{
            RowBox[{"HeadOfTensor2", "@", 
             RowBox[{"TensorWithIndices", "@", 
              RowBox[{"Christoffel", "[", 
               RowBox[{
                RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "->", "tensor"}], 
           "]"}], ";", "\n", "\t\t", 
          RowBox[{"AddVariationalRelation", "[", 
           RowBox[{
            RowBox[{"HeadOfTensor2", "@", 
             RowBox[{"TensorWithIndices", "@", 
              RowBox[{"Christoffel", "[", 
               RowBox[{
                RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
                RowBox[{"[", "3", "]"}], "]"}], "]"}]}]}], "->", "tensor"}], 
           "]"}], ";", "\n", "\t\t", 
          RowBox[{"GenerateExpandVertDiffRule", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"VertDiff", "[", 
              RowBox[{"tensor", "[", "indices", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"VertDiff", "[", 
               RowBox[{
                RowBox[{"Christoffel", "[", 
                 RowBox[{
                  RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], "[", "indices", 
                "]"}], "]"}], "-", 
              RowBox[{"VertDiff", "[", 
               RowBox[{
                RowBox[{"Christoffel", "[", 
                 RowBox[{
                  RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
                  RowBox[{"[", "3", "]"}], "]"}], "]"}], "[", "indices", 
                "]"}], "]"}]}]}], "}"}], "]"}], ";", "\n", "\t\t", 
          RowBox[{"ProtectVertDiffRule", "[", 
           RowBox[{"VertDiff", "[", "tensor", "]"}], "]"}], ";"}], "\n", 
         "\t\t", ")"}]}], "]"}], ";", "\n", "\t\t", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", 
           RowBox[{"TensorID", "@", "tensor"}]}], "===", "3"}], "&&", 
         RowBox[{
          RowBox[{
           RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "===", "AChristoffel"}], "&&", 
         RowBox[{"CovDQ", "[", 
          RowBox[{
           RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], "&&", 
         RowBox[{"CovDQ", "[", 
          RowBox[{
           RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "]"}], "&&", 
         RowBox[{
          RowBox[{
           RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], "=!=", "PD"}], "&&", 
         RowBox[{"(", 
          RowBox[{"!", 
           RowBox[{"HasDaggerCharacterQ", "[", "tensor", "]"}]}], ")"}]}], ",",
         "\n", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{
           RowBox[{"AChristoffelAUX", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "=", "tensor"}], ";", 
          " ", 
          RowBox[{"(*", " ", 
           RowBox[{"For", " ", "TensorWithIndices"}], " ", "*)"}], "\n", 
          "\t\t", 
          RowBox[{
           RowBox[{"AChristoffelAUX", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "=", 
           RowBox[{"MultiplyHead", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "tensor"}], "]"}]}], ";", " ", 
          RowBox[{"(*", " ", 
           RowBox[{"For", " ", "TensorWithIndices"}], " ", "*)"}], "\n", 
          "\t\t", 
          RowBox[{"Unprotect", "[", "VertDiff", "]"}], ";", "\n", "\t\t", 
          RowBox[{"Unprotect", "[", 
           RowBox[{"VertDiff", ",", "AChristoffel"}], "]"}], ";", "\n", 
          "\t\t", 
          RowBox[{"AChristoffel", "/:", " ", 
           RowBox[{"VertDiff", "[", 
            RowBox[{"AChristoffel", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}], "=", 
           RowBox[{"VertDiff", "@", "tensor"}]}], ";", "\n", "\t\t", 
          RowBox[{"AChristoffel", "/:", " ", 
           RowBox[{"VertDiff", "[", 
            RowBox[{"AChristoffel", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], "=", 
           RowBox[{"MultiplyHead", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", 
             RowBox[{"VertDiff", "@", "tensor"}]}], "]"}]}], ";", "\n", 
          "\t\t", 
          RowBox[{"Protect", "[", 
           RowBox[{"VertDiff", ",", "Christoffel"}], "]"}], ";", "\n", "\t\t", 
          RowBox[{"AddVariationalRelation", "[", 
           RowBox[{
            RowBox[{"HeadOfTensor2", "@", 
             RowBox[{"TensorWithIndices", "@", 
              RowBox[{"AChristoffel", "[", 
               RowBox[{
                RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "->", "tensor"}], 
           "]"}], ";", "\n", "\t\t", 
          RowBox[{"AddVariationalRelation", "[", 
           RowBox[{
            RowBox[{"HeadOfTensor2", "@", 
             RowBox[{"TensorWithIndices", "@", 
              RowBox[{"AChristoffel", "[", 
               RowBox[{
                RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
                RowBox[{"[", "3", "]"}], "]"}], "]"}]}]}], "->", "tensor"}], 
           "]"}], ";", "\n", "\t\t", 
          RowBox[{"GenerateExpandVertDiffRule", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"VertDiff", "[", 
              RowBox[{"tensor", "[", "indices", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"VertDiff", "[", 
               RowBox[{
                RowBox[{"AChristoffel", "[", 
                 RowBox[{
                  RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], "[", "indices", 
                "]"}], "]"}], "-", 
              RowBox[{"VertDiff", "[", 
               RowBox[{
                RowBox[{"AChristoffel", "[", 
                 RowBox[{
                  RowBox[{"TensorID", "[", "tensor", "]"}], "[", 
                  RowBox[{"[", "3", "]"}], "]"}], "]"}], "[", "indices", 
                "]"}], "]"}]}]}], "}"}], "]"}], ";", "\n", "\t\t", 
          RowBox[{"ProtectVertDiffRule", "[", 
           RowBox[{"VertDiff", "[", "tensor", "]"}], "]"}], ";"}], "\n", 
         "\t\t", ")"}]}], "\n", "\t", "]"}], ";"}], "\t", "\n", "\t", 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.932387366167954*^9, 3.9325225685744405`*^9, 3.9326170583818893`*^9, {
   3.932730981730678*^9, 3.9327309867183275`*^9}, {3.932731241277*^9, 
   3.932731246828788*^9}, {3.932775932626921*^9, 3.932775941780136*^9}, 
   3.932814621379652*^9, {3.932821076048417*^9, 3.932821127011778*^9}, 
   3.932881078444671*^9, {3.9328972693067017`*^9, 3.9328973120766463`*^9}, {
   3.932897557437971*^9, 3.9328975585051994`*^9}, {3.93289768000074*^9, 
   3.932897699268108*^9}, {3.9328978092265587`*^9, 3.9328978325144424`*^9}, 
   3.9328979774019876`*^9, 3.932898118458033*^9, {3.932898174360553*^9, 
   3.932898227266611*^9}, {3.932898285404573*^9, 3.932898375932563*^9}, {
   3.932898406094754*^9, 3.932898415275345*^9}, {3.932898469669577*^9, 
   3.932898471681577*^9}, 3.932898547042818*^9, 3.9328985821443033`*^9, 
   3.932898822581629*^9, 3.9328988878199663`*^9, 3.93289892611115*^9, 
   3.932898969528245*^9, {3.932899057535576*^9, 3.932899065123104*^9}, {
   3.932899155939819*^9, 3.932899161842201*^9}, {3.9329018628953414`*^9, 
   3.9329018857840347`*^9}, {3.932901995068299*^9, 3.932901996919579*^9}, {
   3.93290431172817*^9, 3.9329043267062607`*^9}, {3.932904622446886*^9, 
   3.932904624412003*^9}, {3.932904675820486*^9, 3.932904685254873*^9}, {
   3.932904802531246*^9, 3.932904812735438*^9}, {3.932904868374873*^9, 
   3.932904891828287*^9}, {3.9329051513509064`*^9, 3.932905242884761*^9}, 
   3.94854264173246*^9, {3.9485427507463846`*^9, 3.948542794865437*^9}, {
   3.950012098103899*^9, 3.950012098302286*^9}, {3.9500121717695637`*^9, 
   3.9500121766909657`*^9}, {3.951222871631819*^9, 3.9512228867678623`*^9}, 
   3.954864245979397*^9, 3.9548652807056103`*^9, {3.9549412229514256`*^9, 
   3.9549412498477306`*^9}, {3.9549468953800774`*^9, 3.954946929027817*^9}, {
   3.954946995751217*^9, 3.954947001377594*^9}, {3.9549470830517464`*^9, 
   3.95494710630686*^9}, {3.9551249983196373`*^9, 3.95512501045553*^9}, {
   3.955125373489607*^9, 3.9551253835863285`*^9}, {3.9552031450203133`*^9, 
   3.955203189414009*^9}, {3.955203355818779*^9, 3.9552033773927574`*^9}, {
   3.955203420642353*^9, 3.955203424102701*^9}, {3.955203519826767*^9, 
   3.9552035618262424`*^9}, {3.955204168928505*^9, 3.955204184366688*^9}, {
   3.955204302336096*^9, 3.9552043162142906`*^9}, {3.9552047340459633`*^9, 
   3.955204735605709*^9}, {3.955205532552086*^9, 3.9552056238927307`*^9}, 
   3.955205684938135*^9, {3.955205726984724*^9, 3.9552057271674805`*^9}, {
   3.9553651072093334`*^9, 3.955365120248724*^9}, {3.9553652332765045`*^9, 
   3.9553652467354355`*^9}, {3.955365521909193*^9, 3.9553655443484325`*^9}, {
   3.955365948388094*^9, 3.955365956345251*^9}, {3.956422900527754*^9, 
   3.95642294243754*^9}, {3.9564245401996765`*^9, 3.9564246072267456`*^9}, {
   3.956424960971119*^9, 3.9564249722577667`*^9}, {3.9564250411038094`*^9, 
   3.9564251144174786`*^9}, {3.9564254653924026`*^9, 
   3.9564254689656105`*^9}, {3.956509234944153*^9, 3.9565092712677097`*^9}, {
   3.9565094482517033`*^9, 3.95650947636351*^9}, 3.956509813634926*^9, {
   3.9572682176254387`*^9, 3.957268222696804*^9}, {3.95726840063241*^9, 
   3.957268406573704*^9}, {3.957268548067066*^9, 3.9572685539087257`*^9}, {
   3.9572689250314217`*^9, 3.957268943985853*^9}, {3.957269023055805*^9, 
   3.957269031674114*^9}, {3.95726985491634*^9, 3.95726989504677*^9}, {
   3.9572699434249077`*^9, 3.957269944524206*^9}, {3.957270008708435*^9, 
   3.9572700914892883`*^9}, {3.9572702302457886`*^9, 
   3.9572702533366394`*^9}, {3.957270459960123*^9, 3.9572704871296215`*^9}, {
   3.9572705708527527`*^9, 3.9572705832518005`*^9}, 3.957270677909788*^9, {
   3.95727110214859*^9, 3.9572711215618134`*^9}, {3.9572712642439003`*^9, 
   3.957271300731373*^9}, {3.95727134643161*^9, 3.957271376814972*^9}, {
   3.957271429404625*^9, 3.9572714587409477`*^9}, {3.9572715121607647`*^9, 
   3.957271528479912*^9}, 3.9572715628589783`*^9, {3.957271600234539*^9, 
   3.9572716153867416`*^9}, {3.957271663794632*^9, 3.957271678412428*^9}, {
   3.9572717257542267`*^9, 3.9572717380286503`*^9}, {3.957271853219101*^9, 
   3.9572718619085865`*^9}, {3.9572720116527596`*^9, 3.957272016374035*^9}, {
   3.9572720989736443`*^9, 3.957272107796362*^9}, {3.957272361762911*^9, 
   3.9572723740328903`*^9}, {3.9572726213931713`*^9, 3.957272666791788*^9}, {
   3.9572731500765495`*^9, 3.957273167147402*^9}, {3.957275269610815*^9, 
   3.9572753060692825`*^9}, 3.957275365738001*^9, {3.9572781977248154`*^9, 
   3.957278230028681*^9}, {3.957278270730955*^9, 3.957278296855236*^9}, 
   3.957279460230112*^9, {3.9572798789292355`*^9, 3.957279903863573*^9}, {
   3.957279948832775*^9, 3.957279956101473*^9}, {3.9572803781149464`*^9, 
   3.9572804042547817`*^9}, {3.9572804433531647`*^9, 3.957280532499094*^9}, {
   3.9572805865075855`*^9, 3.9572805933852596`*^9}, {3.957280694026024*^9, 
   3.9572807638892365`*^9}, {3.9572808181054*^9, 3.957280842719105*^9}, {
   3.957282465604969*^9, 3.9572824923282223`*^9}, 3.9572827989777946`*^9, {
   3.9572829783488827`*^9, 3.9572830104751453`*^9}, {3.9572888318446827`*^9, 
   3.957288832239153*^9}, {3.9572888652560253`*^9, 3.957288874042881*^9}, {
   3.9572890920973854`*^9, 3.957289093119713*^9}, {3.9572892270034904`*^9, 
   3.9572892279656925`*^9}, {3.957289486380905*^9, 3.9572895589575424`*^9}, {
   3.957291412590809*^9, 3.957291434569639*^9}, {3.957292212110281*^9, 
   3.9572922502671623`*^9}, {3.957292475659971*^9, 3.957292476990158*^9}, 
   3.9572990260921383`*^9, {3.9572991820499535`*^9, 3.9572992181836834`*^9}, {
   3.9572992746677227`*^9, 3.957299300199106*^9}, {3.957299389697792*^9, 
   3.957299393846428*^9}, {3.9572995648059998`*^9, 3.957299568121193*^9}, {
   3.957313471958351*^9, 3.957313472059168*^9}, {3.9573141159630966`*^9, 
   3.9573141169086647`*^9}, {3.9573144061695385`*^9, 
   3.9573144264924603`*^9}, {3.9573144594063606`*^9, 3.957314469481579*^9}, {
   3.9573148643220787`*^9, 3.9573148994041977`*^9}, {3.957314935001564*^9, 
   3.9573149662060223`*^9}, {3.957315049361191*^9, 3.9573151159636574`*^9}, {
   3.9573151666791058`*^9, 3.957315186098463*^9}, {3.9573154421547527`*^9, 
   3.9573154623736935`*^9}, {3.9573156493876038`*^9, 
   3.9573156877521305`*^9}, {3.9573157254160194`*^9, 3.957315734365841*^9}, {
   3.9573157700925827`*^9, 3.9573157768441257`*^9}, {3.957315819840233*^9, 
   3.957315825737236*^9}, {3.9573160271403694`*^9, 3.9573160367021694`*^9}, 
   3.957316109731903*^9, 3.957316191077444*^9, {3.957316793571171*^9, 
   3.957316820211092*^9}, {3.9573184352617474`*^9, 3.9573184429289017`*^9}, {
   3.9573198387056046`*^9, 3.95731984276799*^9}, {3.957321430936447*^9, 
   3.9573214407494564`*^9}, {3.957322583612299*^9, 3.95732260091733*^9}, {
   3.9573226731772423`*^9, 3.957322688111044*^9}, {3.9573227602517414`*^9, 
   3.9573227772884636`*^9}, {3.957322995919693*^9, 3.9573230108739605`*^9}, {
   3.957323095827385*^9, 3.9573231093514023`*^9}, {3.957323433232418*^9, 
   3.957323542499817*^9}, 3.9573236052824116`*^9, {3.957323683937767*^9, 
   3.9573237077921505`*^9}, {3.9573237574130936`*^9, 
   3.9573237873115864`*^9}, {3.957323886586849*^9, 3.9573239056844997`*^9}, {
   3.9573240285536823`*^9, 3.9573240318971615`*^9}, {3.957324101460062*^9, 
   3.9573241046991577`*^9}, {3.957324168499504*^9, 3.9573242185631065`*^9}, {
   3.9573242947790985`*^9, 3.9573243509551163`*^9}, {3.957324393263548*^9, 
   3.957324426068945*^9}, {3.957324476848175*^9, 3.95732450207041*^9}, {
   3.957324595135908*^9, 3.9573246020726357`*^9}, 3.9573246326074505`*^9, {
   3.9573246726742*^9, 3.9573246742093754`*^9}, {3.9573247361517143`*^9, 
   3.9573247554869576`*^9}, {3.957324814980652*^9, 3.9573248766330776`*^9}, {
   3.957324919423464*^9, 3.957324954646307*^9}, {3.957325054248436*^9, 
   3.957325120292919*^9}, {3.9573251598293495`*^9, 3.9573251745447445`*^9}, {
   3.9573252266406612`*^9, 3.9573252703548775`*^9}, {3.9573253167674484`*^9, 
   3.957325331877632*^9}, {3.9573254531451645`*^9, 3.9573254609863358`*^9}, {
   3.9573255272066975`*^9, 3.957325566441908*^9}, {3.957325609308737*^9, 
   3.957325636443962*^9}, {3.957325675055746*^9, 3.957325728260042*^9}, {
   3.9573258735079117`*^9, 3.9573258758819065`*^9}, {3.95732591944022*^9, 
   3.957325941137089*^9}, {3.9573260023663006`*^9, 3.9573260035496063`*^9}, {
   3.9573260337975655`*^9, 3.957326074654001*^9}, {3.9573261551910515`*^9, 
   3.957326171482525*^9}, {3.9573263084761353`*^9, 3.9573263529702377`*^9}, {
   3.9573264206500225`*^9, 3.9573264382674274`*^9}, {3.9573265299601784`*^9, 
   3.957326554677944*^9}, {3.9573265988274403`*^9, 3.957326622906271*^9}, {
   3.9573266852815666`*^9, 3.957326760672573*^9}, {3.9573278260753803`*^9, 
   3.957327886767641*^9}, {3.9573279347467346`*^9, 3.9573279508715343`*^9}, 
   3.95732804265506*^9, 3.9573292900533237`*^9, {3.9573295289317513`*^9, 
   3.9573295315831947`*^9}, {3.9573876254651146`*^9, 3.957387627373741*^9}, 
   3.9573879109891224`*^9, {3.957388104033184*^9, 3.9573881490398064`*^9}, {
   3.95738998836467*^9, 3.95739001266728*^9}, {3.9573900729835186`*^9, 
   3.9573901197710495`*^9}, {3.957390188114292*^9, 3.9573901896830807`*^9}, {
   3.957390294269005*^9, 3.9573902964315777`*^9}, {3.957390367183628*^9, 
   3.957390378024086*^9}, 3.9575435672744217`*^9, 3.957543671650114*^9, {
   3.9579652190248013`*^9, 3.9579652235216446`*^9}, 3.957965265082241*^9, {
   3.957965300462223*^9, 3.95796530069458*^9}, {3.957965422719837*^9, 
   3.9579654458771954`*^9}, 3.957965626523737*^9, {3.9579657276369076`*^9, 
   3.957965775074009*^9}, {3.9579662303000946`*^9, 3.9579662861898975`*^9}, {
   3.95796735681769*^9, 3.9579673574272976`*^9}, {3.9579678952528915`*^9, 
   3.9579679254445744`*^9}, 3.957968060780184*^9, {3.957968165827257*^9, 
   3.957968189768772*^9}, {3.957968456874428*^9, 3.957968496951767*^9}, {
   3.9579685684183273`*^9, 3.9579685830028915`*^9}, {3.9579694313925686`*^9, 
   3.957969440720316*^9}, {3.957969576914053*^9, 3.957969626686838*^9}, {
   3.9579698065829144`*^9, 3.957969872824047*^9}, {3.957970671883417*^9, 
   3.9579707313324184`*^9}, {3.958254376686207*^9, 3.958254432585312*^9}, {
   3.95825458376643*^9, 3.9582546304231243`*^9}, {3.958254915889433*^9, 
   3.958254943186201*^9}, {3.958255027309744*^9, 3.9582550519477024`*^9}, {
   3.9582551394046364`*^9, 3.9582552472435703`*^9}, {3.9583022364981384`*^9, 
   3.9583022719624805`*^9}, {3.9583023248754807`*^9, 3.95830233161059*^9}, {
   3.958302523554964*^9, 3.958302528803957*^9}, {3.9583028244030037`*^9, 
   3.9583028518247204`*^9}, 3.958304110121935*^9, {3.9583042070002327`*^9, 
   3.958304219811285*^9}, {3.9583044841749*^9, 3.9583044938872757`*^9}, {
   3.9583045713108864`*^9, 3.9583046472491093`*^9}, {3.9583151481937103`*^9, 
   3.95831521336998*^9}, {3.9583155038466988`*^9, 3.958315541114744*^9}, {
   3.9583156361287975`*^9, 3.9583156865492153`*^9}, {3.958317417957918*^9, 
   3.958317448180538*^9}, {3.9583175617280617`*^9, 3.9583175676930313`*^9}, 
   3.9583189819636326`*^9, 3.9583935446391525`*^9, {3.958394126689207*^9, 
   3.9583941333227577`*^9}, {3.9583945842700768`*^9, 
   3.9583946109892273`*^9}, {3.9583946726210594`*^9, 
   3.9583946788908195`*^9}, {3.9584159194166985`*^9, 3.9584159381517105`*^9}, 
   3.958436159620222*^9, {3.958496469551897*^9, 3.9584964780806007`*^9}, {
   3.958496525152767*^9, 3.958496571894287*^9}, {3.9584966060037136`*^9, 
   3.958496628346384*^9}, {3.958496699275511*^9, 3.958496711294777*^9}, {
   3.958496835975683*^9, 3.9584968755172024`*^9}, {3.95849704753528*^9, 
   3.958497214176012*^9}, {3.9584978473626957`*^9, 3.9584978475452766`*^9}, {
   3.9585629939274807`*^9, 3.958562999459772*^9}, {3.958563430227207*^9, 
   3.9585635144484005`*^9}, {3.9585652973743515`*^9, 
   3.9585653081733036`*^9}, {3.958565502500519*^9, 3.9585655065915775`*^9}, {
   3.958565726262764*^9, 3.95856576736734*^9}, {3.9585659182271957`*^9, 
   3.9585660628074627`*^9}, {3.958566159905403*^9, 3.9585661804151554`*^9}, {
   3.95856622683885*^9, 3.958566247793541*^9}, {3.958566279554678*^9, 
   3.9585664537230988`*^9}, {3.958566620609396*^9, 3.9585666497387867`*^9}, {
   3.9585671250592213`*^9, 3.9585672098962746`*^9}, {3.9585684368582497`*^9, 
   3.958568542195814*^9}, {3.958568985839033*^9, 3.958569007554735*^9}, {
   3.9585690560117435`*^9, 3.9585690880332623`*^9}, {3.958569274198984*^9, 
   3.958569292553919*^9}, {3.958569636824085*^9, 3.9585698930722427`*^9}, {
   3.9585701067597427`*^9, 3.9585701151803646`*^9}, {3.9585701528272953`*^9, 
   3.958570176171192*^9}, {3.95857033432242*^9, 3.9585703688857975`*^9}, {
   3.9585728215909767`*^9, 3.9585728653572636`*^9}, {3.958572905146805*^9, 
   3.9585729092981567`*^9}, {3.958586078791353*^9, 3.958586090049629*^9}, {
   3.9585861215448437`*^9, 3.9585861343138237`*^9}, 3.958586191446455*^9, {
   3.9586008933139267`*^9, 3.9586009567758865`*^9}, {3.9586010464851685`*^9, 
   3.9586010962135983`*^9}, 3.958601375781719*^9, 3.958753385158474*^9, {
   3.9587534222400208`*^9, 3.9587535321230526`*^9}, {3.958756038361044*^9, 
   3.9587560505361214`*^9}, {3.9587566005688896`*^9, 3.95875660596525*^9}, {
   3.9587571770251465`*^9, 3.958757195519911*^9}, {3.958877747516323*^9, 
   3.9588777739234905`*^9}, {3.9594017917706375`*^9, 3.959401797498808*^9}, {
   3.959401992829876*^9, 3.9594020337648983`*^9}, {3.9594020695903893`*^9, 
   3.959402163746977*^9}, {3.9594046020609207`*^9, 3.95940463850399*^9}, {
   3.9603581823769913`*^9, 3.9603581986766834`*^9}, {3.960358243940506*^9, 
   3.9603582698583107`*^9}, {3.9603584537052135`*^9, 
   3.9603584690074005`*^9}, {3.9603585745757446`*^9, 3.960358604580633*^9}, {
   3.960358641415663*^9, 3.9603586663011913`*^9}, {3.9603587309356117`*^9, 
   3.9603588112652836`*^9}, {3.9603590093571796`*^9, 3.960359092917202*^9}, {
   3.9603591512097683`*^9, 3.9603591541826496`*^9}, {3.960359374826391*^9, 
   3.9603593752055626`*^9}, {3.9603595260659122`*^9, 3.960359532942465*^9}, {
   3.960364763217926*^9, 3.960364784272354*^9}, {3.96036488290753*^9, 
   3.960364950330862*^9}, {3.960365043351654*^9, 3.960365115956564*^9}, {
   3.960365937579714*^9, 3.9603659461482735`*^9}, {3.9603660090551224`*^9, 
   3.9603660091884747`*^9}, {3.960366078959568*^9, 3.9603660945751095`*^9}, {
   3.9603661510485992`*^9, 3.9603661605816803`*^9}, {3.960366245114519*^9, 
   3.9603662588942757`*^9}, {3.960366339497761*^9, 3.9603663721589584`*^9}, 
   3.9603664604216957`*^9, {3.9603665167707424`*^9, 3.9603665218042793`*^9}, {
   3.960366908255863*^9, 3.9603669177718735`*^9}, {3.960367064264982*^9, 
   3.9603670989539223`*^9}, {3.9603672596791725`*^9, 
   3.9603672612588043`*^9}, {3.960367308287779*^9, 3.960367320691593*^9}, {
   3.960367707100008*^9, 3.96036770890444*^9}, {3.9603678289398823`*^9, 
   3.960367832001068*^9}, {3.960368343193672*^9, 3.9603683499550056`*^9}, {
   3.9603684856563225`*^9, 3.960368487566061*^9}, 3.9604640002320194`*^9, {
   3.960466168919367*^9, 3.960466216669113*^9}, {3.9604665771059284`*^9, 
   3.9604665841544666`*^9}, {3.960528773928114*^9, 3.9605288086177807`*^9}, {
   3.960528861223377*^9, 3.9605289079927063`*^9}, {3.960528972586399*^9, 
   3.960528981022114*^9}, {3.960529073101368*^9, 3.960529073725214*^9}, {
   3.960530427953308*^9, 3.9605304545560646`*^9}, {3.9605304873495045`*^9, 
   3.960530514843975*^9}, {3.9605308339660683`*^9, 3.9605308341278152`*^9}, {
   3.960530957320627*^9, 3.9605309605840435`*^9}, {3.9605334772949123`*^9, 
   3.9605334873152504`*^9}, {3.960533567382128*^9, 3.960533568883812*^9}, {
   3.976317281494732*^9, 3.9763172962474422`*^9}, {3.976317390902439*^9, 
   3.9763173981029053`*^9}},ExpressionUUID->"b0ca1cb0-6448-4249-be82-\
bb7591ad7472"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MasterOfCPSTensor", "[", 
    RowBox[{"tensor_", "?", "HasDaggerCharacterQ"}], "]"}], "/;", 
   RowBox[{"!", 
    RowBox[{"PartialPartialQ", "[", "tensor", "]"}]}]}], ":=", 
  RowBox[{"Dagger", "@", 
   RowBox[{"MasterOfCPSTensor", "[", 
    RowBox[{
     RowBox[{"Dagger", "@", "tensor"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MultiplyHead", "[", 
        RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.9585669540515976`*^9, {3.95856708769199*^9, 3.95856709926157*^9}, {
   3.9585685791843033`*^9, 3.9585685800688553`*^9}, {3.9606105780765495`*^9, 
   3.960610588199953*^9}, {3.9606111195306168`*^9, 
   3.960611127254387*^9}},ExpressionUUID->"70082d1e-875c-0c4c-81fb-\
7c0f51819af4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Modification UndefTensor"
}], "Subsection",
 CellChangeTimes->{3.932387355586685*^9, 3.948396702920955*^9, 
  3.9585685712214737`*^9},ExpressionUUID->"001407d7-78eb-c845-97af-\
a12653a32faf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTension", "[", 
    RowBox[{"\"\<xAct`xTensor`\>\"", ",", " ", "UndefTensor", ",", 
     " ", "\"\<Beginning\>\""}], "]"}], " ", ":=", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"dagger", "=", 
        RowBox[{
         RowBox[{"Dagger", "@", "#"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"MultiplyHead", "[", 
            RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}]}], 
       "}"}], ",", "\n", "\t", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"DaggerQ", "[", "#", "]"}], "&&", 
          RowBox[{"!", 
           RowBox[{"xTensorQ", "[", 
            RowBox[{"MasterOfCPSTensor", "[", "#", "]"}], "]"}]}], "&&", 
          RowBox[{"!", 
           RowBox[{"HasDaggerCharacterQ", "[", "#", "]"}]}], "&&", 
          RowBox[{"dagger", "=!=", "#"}]}], ",", 
         RowBox[{
          RowBox[{"ServantsOf", "[", "dagger", "]"}], "^=", 
          RowBox[{"{", "}"}]}]}], "]"}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "This", " ", "is", " ", "needed", " ", "to", " ", "avoid", " ", 
         "double", " ", "Undef", " ", "of", " ", "some", " ", "tensors"}], 
        " ", "*)"}], "\n", "\t", 
       RowBox[{"VertexDeleteAndUpdate", "[", "#", "]"}], ";", "\n", "\t", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PartialPartialQ", "[", "#", "]"}], ",", 
         RowBox[{"RemovePartialPartialUpvalues", "[", "#", "]"}]}], "]"}], ";",
        "\t", "\n", "\t", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"!", 
           RowBox[{"PartialPartialQ", "[", "#", "]"}]}], "&&", 
          RowBox[{"!", 
           RowBox[{"VariationalVectorQ", "[", "#", "]"}]}], "&&", 
          RowBox[{"!", 
           RowBox[{"VertExactHeadQ", "[", "#", "]"}]}]}], ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"UndefTensor", "/@", 
            RowBox[{"removeDaggerPairs", "[", 
             RowBox[{"PartialPartialsOfTensor", "[", "#", "]"}], "]"}]}], 
           ";"}], ")"}]}], "]"}], ";"}]}], "\n", "\t", "]"}], "&"}]}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"RemovePartialPartialUpvalues", "[", 
   RowBox[{"PPtensor_", "?", "PartialPartialQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", "\t", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"tensors", "=", 
       RowBox[{"DeleteDuplicates", "@", 
        RowBox[{"TensorsOfPartialPartial", "@", "PPtensor"}]}]}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"function", "=", 
       RowBox[{"FunctionOfPartialPartial", "@", "PPtensor"}]}]}], 
     "\[IndentingNewLine]", "\t", "}"}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"PartialPartialsOfTensor", "[", "#", "]"}], " ", "^=", " ", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{
            RowBox[{"PartialPartialsOfTensor", "[", "#", "]"}], ",", 
            "PPtensor"}], "]"}]}], ")"}], " ", "&"}], ",", " ", "tensors"}], 
      "]"}], ";", "\n", "\t", 
     RowBox[{
      RowBox[{"PartialPartialsOfFunction", "[", "function", "]"}], "^=", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"PartialPartialsOfFunction", "[", "function", "]"}], ",", 
        "PPtensor"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
   "]"}]}]}], "Code",
 CellChangeTimes->{{3.9585685563541336`*^9, 3.9585685571675835`*^9}, {
   3.960534772200777*^9, 3.960534783800949*^9}, {3.9605383532471447`*^9, 
   3.9605383675973186`*^9}, {3.960540475877081*^9, 3.9605404977130833`*^9}, {
   3.9605405602530003`*^9, 3.960540591680113*^9}, {3.960540670990164*^9, 
   3.960540741822647*^9}, {3.960540781789341*^9, 3.96054078564192*^9}, {
   3.9605413022865734`*^9, 3.9605413203891163`*^9}, 3.9605413729054623`*^9, {
   3.9605418648252983`*^9, 3.9605418769082336`*^9}, {3.960541915428484*^9, 
   3.9605419447254696`*^9}, {3.9605419836414223`*^9, 3.960541992313574*^9}, {
   3.9605420329337273`*^9, 3.960542040810398*^9}, {3.9605421077788696`*^9, 
   3.9605421301375217`*^9}, {3.960542228017147*^9, 3.9605422572993393`*^9}, 
   3.960542414394348*^9, {3.9605425853548546`*^9, 3.9605426359959927`*^9}, {
   3.9605426731923103`*^9, 3.9605427219372826`*^9}, 3.9605431937855396`*^9, {
   3.960543230450472*^9, 3.960543238258337*^9}, {3.9605432792760544`*^9, 
   3.9605432953327713`*^9}, {3.9605433343267746`*^9, 3.960543364104475*^9}, {
   3.9605434060368347`*^9, 3.9605434223593616`*^9}, 3.960543459803789*^9, {
   3.9605435040937386`*^9, 3.9605435536282673`*^9}, {3.9605437208069363`*^9, 
   3.960543794387907*^9}, {3.960544410350027*^9, 3.960544411876503*^9}, {
   3.9606082241550045`*^9, 3.9606082308042774`*^9}, {3.9606083171858807`*^9, 
   3.960608329736183*^9}, {3.960608408025404*^9, 3.960608416370941*^9}, {
   3.9606084671997433`*^9, 3.960608488820154*^9}, {3.9606086384005127`*^9, 
   3.9606086604513245`*^9}, {3.9606087034249554`*^9, 3.960608726481388*^9}, {
   3.9606088131092205`*^9, 3.960608815490484*^9}, {3.9606088656861973`*^9, 
   3.9606088898565826`*^9}, {3.9606090187327976`*^9, 
   3.9606090366783676`*^9}, {3.9606091085678425`*^9, 3.960609167053793*^9}, {
   3.9606092595508366`*^9, 3.9606092672065277`*^9}, {3.9606100882061863`*^9, 
   3.960610099017481*^9}, {3.9606101590986824`*^9, 3.9606101867549763`*^9}, {
   3.960610289268404*^9, 3.9606102942824097`*^9}, {3.960610421873913*^9, 
   3.9606104264846745`*^9}, {3.9606106593055935`*^9, 
   3.9606106647781696`*^9}, {3.960610712128397*^9, 3.960610743321018*^9}, {
   3.960610797087322*^9, 3.9606107978691044`*^9}, {3.960610846754097*^9, 
   3.9606108597477226`*^9}, {3.9606109312848797`*^9, 
   3.9606109732029076`*^9}, {3.9606110178777637`*^9, 
   3.9606110204780445`*^9}, {3.9606111424989834`*^9, 
   3.9606111685319386`*^9}},ExpressionUUID->"91295e63-6147-8c46-a7bf-\
7fc3dba01780"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". DefExactVerticalForm"
}], "Subsection",
 CellChangeTimes->{{3.931835609998289*^9, 3.931835613091166*^9}, {
   3.9323873852521105`*^9, 3.932387386189842*^9}, 
   3.948396705616133*^9},ExpressionUUID->"7f032b03-8559-9945-957f-\
addbc68ad542"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PartialPartialsOfTensor", "[", "_", "]"}], ":=", 
   RowBox[{"{", "}"}]}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "is", " ", "necessary", " ", "for", " ", "some", " ", 
    "tensor", " ", "that", " ", "are", " ", "defined", " ", "as", " ", 
    "vanishing"}], "*)"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefExactVerticalForm", "]"}], ":=", 
   RowBox[{"Options", "[", "DefAdditionalTensors", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"DefExactVerticalForm", "::", "unknown"}], 
    "=", "\"\<VertDiff[`1`] is already defined as `2`.\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefExactVerticalForm", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"tensor_Symbol", "?", "xTensorQ"}], "[", "inds___", "]"}], ",", 
     "dependencies_", ",", "sym_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"Options", "[", "DefExactVerticalForm", "]"}], "]"}]}]}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", "\n", "\t", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"diffForm", "=", 
        RowBox[{"GenerateDiffName", "[", 
         RowBox[{"tensor", ",", 
          RowBox[{"PrintAs", "->", 
           RowBox[{"PrintAs", "[", "tensor", "]"}]}], ",", 
          RowBox[{"FilterRules", "[", 
           RowBox[{
            RowBox[{"{", "options", "}"}], ",", 
            RowBox[{"Options", "[", "GenerateDiffName", "]"}]}], "]"}]}], 
         "]"}]}], ",", "prot", ",", 
       RowBox[{"pinds", "=", 
        RowBox[{"MakePattern", "/@", 
         RowBox[{"{", "inds", "}"}]}]}], ",", "opts", ",", "dltensor"}], 
      "}"}], ",", "\n", "\t", "\n", "\t", 
     RowBox[{
      RowBox[{"MakexTensions", "[", 
       RowBox[{"DefExactVerticalForm", ",", "\"\<Beginning\>\"", ",", 
        RowBox[{"tensor", "[", "inds", "]"}], ",", "dependencies", ",", "sym",
         ",", "options"}], "]"}], ";", "\[IndentingNewLine]", "\t", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"xTensorQ", "[", 
          RowBox[{
           RowBox[{"VertDiff", "[", 
            RowBox[{"tensor", "[", "inds", "]"}], "]"}], "//", "Head"}], 
          "]"}], "&&", 
         RowBox[{"!", 
          RowBox[{"OptionValue", "[", "PrintInverse", "]"}]}]}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"DefExactVerticalForm", "::", "unknown"}], ",", "tensor", ",", 
           RowBox[{"VertDiff", "[", "tensor", "]"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"opts", "=", 
       RowBox[{"FilterRules", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"WeightOfTensor", "->", 
             RowBox[{"WeightOfTensor", "[", "tensor", "]"}]}], ",", 
            RowBox[{"VertDeg", "->", 
             RowBox[{
              RowBox[{"VertDeg", "[", 
               RowBox[{"tensor", "[", "inds", "]"}], "]"}], " ", "+", " ", 
              "1"}]}]}], "}"}], "~", "Join", "~", 
          RowBox[{"{", "options", "}"}]}], ",", 
         RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Remove", " ", "the", " ", "old", " ", "GradeOfTensor", " ", "and", " ",
         "add", " ", "the", " ", "new", " ", "one"}], " ", "*)"}], "\n", "\t", 
      RowBox[{"opts", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"xAct`xTensor`Private`ImplodedQ", "[", "tensor", "]"}], ",", 
         RowBox[{"opts", "~", "Join", "~", 
          RowBox[{"{", 
           RowBox[{"DefInfo", "\[RuleDelayed]", 
            RowBox[{"If", "[", 
             RowBox[{"$ImplodeInfoQ", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<tensor\>\"", ",", "\"\<\>\""}], "}"}], ",", 
              "False"}], "]"}]}], "}"}]}], ",", "opts"}], "]"}]}], ";", "\n", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"dltensor", "=", 
       RowBox[{"Evaluate", "[", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"Evaluate", "[", 
          RowBox[{"diffForm", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"VertExactHeadQ", "[", "dltensor", "]"}], "^=", "True"}], ";", 
      "\n", "\t", 
      RowBox[{
       RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}], "^=", "tensor"}], 
      ";", "\n", "\t", "\n", "\t", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "Define", " ", "the", " ", "exact", " ", "tensor", " ", "with", " ", 
         "the", " ", "given", " ", "indices"}], ",", "symmetries", ",", " ", 
        "options", ",", " ", 
        RowBox[{"and", " ", 
         RowBox[{"arguments", ".", " ", "Its"}], " ", "VertDeg", " ", "is", " ",
          "one", " ", "more", " ", "than", " ", "the", " ", 
         RowBox[{"tensor", "."}]}]}], "*)"}], "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"StringEndsQ", "[", 
          RowBox[{
           RowBox[{"ToString", "@", "tensor"}], ",", "\"\<\[Dagger]\>\""}], 
          "]"}]}], ",", 
        RowBox[{"DefTensor", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"diffForm", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "[", "inds", "]"}], ",", 
          "dependencies", ",", "sym", ",", 
          RowBox[{"PrintAs", "->", 
           RowBox[{"diffForm", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", "opts", ",", 
          RowBox[{"DefineExactFormAfterDefTensor", "->", "False"}], ",", 
          RowBox[{"DefineVariationalVectorAfterDefTensor", "->", "False"}]}], 
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", "\t", 
      "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Establish", " ", "relationships", " ", "between", " ", "the", " ", 
        "exact", " ", "tensor", " ", "and", " ", "the", " ", "original", " ", 
        "tensor"}], " ", "*)"}], "\n", "\t", 
      RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
       RowBox[{"dltensor", ",", "tensor", ",", 
        RowBox[{"{", "tensor", "}"}]}], "]"}], ";", "\n", "\t", 
      RowBox[{"$printAddVariationalRelation", "=", "False"}], ";", "\n", "\t", 
      RowBox[{"AddVariationalRelation", "[", 
       RowBox[{"tensor", "->", "dltensor"}], "]"}], ";", "\n", "\t", 
      RowBox[{"$printAddVariationalRelation", "=", "True"}], ";", 
      "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", 
       RowBox[{
       "Define", " ", "the", " ", "vertical", " ", "derivative", " ", "of", " ",
         "the", " ", "tensor", " ", "to", " ", "be", " ", "the", " ", "exact",
         " ", "tensor"}], "*)"}], "\[IndentingNewLine]", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"OptionValue", "[", "PrintInverse", "]"}], ",", "\n", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{
           RowBox[{"VertDiff", "[", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<Inv\>\"", "<>", 
              RowBox[{"ToString", "[", "tensor", "]"}]}], "]"}], "]"}], "=", 
           "dltensor"}], ";", "\n", "\t\t", 
          RowBox[{
           RowBox[{"dlInvMetricQ", "[", "dltensor", "]"}], "^=", "True"}], ";",
           "\n", "\t\t", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"DaggerQ", "[", "dltensor", "]"}], ",", "\n", "\t\t\t", 
            RowBox[{
             RowBox[{
              RowBox[{"VertDiff", "[", 
               RowBox[{"ToExpression", "[", 
                RowBox[{"\"\<Inv\>\"", "<>", 
                 RowBox[{"ToString", "[", "tensor", "]"}], 
                 "<>", "\"\<\[Dagger]\>\""}], "]"}], "]"}], "=", 
              RowBox[{"Dagger", "@", "dltensor"}]}], ";", "\n", "\t\t\t", 
             RowBox[{
              RowBox[{"dlInvMetricQ", "[", 
               RowBox[{"Dagger", "@", "dltensor"}], "]"}], "^=", "True"}], ";",
              "\n", "\t\t\t", 
             RowBox[{
              RowBox[{"VertExactHeadQ", "[", 
               RowBox[{"Dagger", "@", "dltensor"}], "]"}], "^=", "True"}]}]}],
            "\n", "\t\t", "]"}], ";"}], "\n", "\t\t", ")"}], ",", "\n", 
        "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"tensor", "/:", 
           RowBox[{"VertDiff", "[", "tensor", "]"}], "=", "dltensor"}], ";", 
          "\n", "\t\t", 
          RowBox[{
           RowBox[{"PrintAs", "[", 
            RowBox[{"Evaluate", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"VertDiff", "[", "tensor", "]"}], "]"}], "]"}], "]"}], "^=", 
           RowBox[{"diffForm", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";"}], 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
           "This", " ", "prevents", " ", "the", " ", "densities", " ", "to", " ",
             "have", " ", "two", " ", "sets", " ", "of", " ", "tildes"}], ",", 
           RowBox[{
           "only", " ", "the", " ", "ones", " ", "coming", " ", "from", " ", 
            "the", " ", "tensor", " ", "remained"}]}], "*)"}], "\n", "\t\t", 
         ")"}]}], "\n", "\t", "]"}], ";", "\n", "\t", "\n", "\t", 
      RowBox[{"tensor", " ", "/:", " ", 
       RowBox[{"VertDiff", "[", 
        RowBox[{"tensor", " ", "@@", " ", "pinds"}], "]"}], ":=", " ", 
       RowBox[{"dltensor", "[", "inds", "]"}]}], ";", "\[IndentingNewLine]", 
      "\t", "\n", "\t", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Define", " ", "rules", " ", "for", " ", 
         RowBox[{"ExpandVertDiffRules", ".", "This"}], " ", "is", " ", "the", 
         " ", "base", " ", "case"}], ",", 
        RowBox[{
        "that", " ", "it", " ", "leaves", " ", "it", " ", "as", " ", "it", " ",
          "is"}]}], "*)"}], "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"ExpandVertDiffRules", "[", 
        RowBox[{
         RowBox[{"dltensor", "@@", 
          RowBox[{"(", 
           RowBox[{"MakePattern", "/@", 
            RowBox[{"{", "inds", "}"}]}], ")"}]}], ",", 
         RowBox[{"opts", ":", 
          RowBox[{"OptionsPattern", "[", 
           RowBox[{"Options", "[", "ExpandVertDiff", "]"}], "]"}]}]}], "]"}], 
       ":=", 
       RowBox[{
        RowBox[{"FilterVertExpand", "[", 
         RowBox[{
          RowBox[{"dltensor", "[", "inds", "]"}], ",", "opts"}], "]"}], "[", 
        "]"}]}], ";", "\[IndentingNewLine]", "\t\t", "\[IndentingNewLine]", 
      "\t", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{"DefExactVerticalForm", ",", "\"\<End\>\"", ",", 
        RowBox[{"tensor", "[", "inds", "]"}], ",", "dependencies", ",", "sym",
         ",", "options"}], "]"}], ";"}]}], "\n", "]"}]}], ";"}]}], "Code",
 CellChangeTimes->{{3.931835626152677*^9, 3.931835643541817*^9}, {
   3.93195421390512*^9, 3.9319542298194923`*^9}, {3.932029829301226*^9, 
   3.932029831144297*^9}, 3.9323874012572126`*^9, 3.932522587857272*^9, {
   3.932617086173935*^9, 3.9326171161660223`*^9}, 3.9326378615600643`*^9, {
   3.9327115171464415`*^9, 3.932711541660965*^9}, 3.932712065704625*^9, {
   3.932715785481305*^9, 3.932715787627955*^9}, 3.932717309644032*^9, 
   3.932717600665197*^9, {3.9327178989284477`*^9, 3.932717900807263*^9}, {
   3.932731000428909*^9, 3.932731012090898*^9}, {3.9327310617007976`*^9, 
   3.932731064991257*^9}, {3.932731295917475*^9, 3.93273131589209*^9}, {
   3.932731425118903*^9, 3.932731443796722*^9}, {3.932733953270402*^9, 
   3.9327339556365113`*^9}, {3.93273413338224*^9, 3.932734157077153*^9}, {
   3.932734187823758*^9, 3.9327342019987893`*^9}, {3.9327345318872232`*^9, 
   3.932734534226828*^9}, {3.9327643473134956`*^9, 3.932764347317499*^9}, {
   3.932775916438998*^9, 3.932775917652211*^9}, {3.932776536886913*^9, 
   3.9327765370628223`*^9}, 3.932814628527704*^9, {3.932821084293169*^9, 
   3.93282109222215*^9}, {3.932823046565334*^9, 3.932823070966161*^9}, {
   3.9328805119906125`*^9, 3.9328805146624804`*^9}, 3.932881006311828*^9, {
   3.932904214728734*^9, 3.932904223685215*^9}, {3.932904587029439*^9, 
   3.932904587956889*^9}, {3.93333013123074*^9, 3.9333301319852824`*^9}, {
   3.94854271779132*^9, 3.948542724249313*^9}, {3.948543646649355*^9, 
   3.948543652108857*^9}, {3.948727088479106*^9, 3.948727091267401*^9}, 
   3.949082260987345*^9, {3.949489960374264*^9, 3.9494899687660084`*^9}, {
   3.949497653068205*^9, 3.949497655665886*^9}, {3.949688679512853*^9, 
   3.949688692294325*^9}, 3.949688920301927*^9, 3.9497673876580677`*^9, {
   3.950123978682118*^9, 3.950123988477907*^9}, {3.950291258406739*^9, 
   3.950291285588873*^9}, {3.950291537808241*^9, 3.95029157053458*^9}, {
   3.950291674514038*^9, 3.950291694215431*^9}, {3.950292090616548*^9, 
   3.950292117772558*^9}, {3.9502922026898518`*^9, 3.9502922224340897`*^9}, {
   3.950292528355182*^9, 3.950292542073126*^9}, {3.950292631589061*^9, 
   3.950292644435152*^9}, {3.9502927046667213`*^9, 3.950292742552006*^9}, 
   3.950292895235449*^9, {3.9502930010098114`*^9, 3.950293004505802*^9}, {
   3.950293347306549*^9, 3.950293351697445*^9}, {3.950297304624777*^9, 
   3.950297353318079*^9}, {3.9502975797422485`*^9, 3.9502975849702225`*^9}, {
   3.9512226693875847`*^9, 3.951222692548094*^9}, {3.9512235472029886`*^9, 
   3.951223551566445*^9}, {3.951309198207596*^9, 3.9513091987251873`*^9}, {
   3.951474836903919*^9, 3.951474884504463*^9}, {3.9515813716534977`*^9, 
   3.9515814435984116`*^9}, {3.9518473082935696`*^9, 3.951847309277048*^9}, {
   3.954512777933777*^9, 3.954512809555767*^9}, {3.9548642706425514`*^9, 
   3.954864275663025*^9}, {3.9548659134781094`*^9, 3.954865926605938*^9}, {
   3.956084724565668*^9, 3.956084806312044*^9}, {3.95608551163826*^9, 
   3.9560855186475716`*^9}, {3.9564210473867035`*^9, 3.956421079511652*^9}, {
   3.956509575382143*^9, 3.9565096607950153`*^9}, {3.956509774802864*^9, 
   3.9565098056462555`*^9}, {3.957267302559204*^9, 3.9572673087757473`*^9}, {
   3.9572674120996704`*^9, 3.9572674345877743`*^9}, {3.9572675182785606`*^9, 
   3.957267527451067*^9}, 3.957267563272703*^9, {3.9572676979232464`*^9, 
   3.957267720454199*^9}, {3.9572678231833153`*^9, 3.9572678289002533`*^9}, {
   3.957267875967119*^9, 3.9572678922960377`*^9}, 3.9572691833921967`*^9, {
   3.957269239771166*^9, 3.957269240650326*^9}, {3.957271986945553*^9, 
   3.9572719917020836`*^9}, {3.9572728007939644`*^9, 3.957272816139124*^9}, {
   3.95727284847752*^9, 3.957272867734289*^9}, {3.9572729722361336`*^9, 
   3.9572729736646976`*^9}, {3.9572734752361965`*^9, 
   3.9572734934231453`*^9}, {3.957275321376545*^9, 3.957275356866701*^9}, {
   3.9572785279208164`*^9, 3.9572785420119*^9}, {3.9572800233789463`*^9, 
   3.9572800420300713`*^9}, {3.957280084923586*^9, 3.957280110408619*^9}, {
   3.9572802793590794`*^9, 3.9572802882375507`*^9}, {3.9572826843738213`*^9, 
   3.9572826848002434`*^9}, 3.9572827905307293`*^9, {3.957286680742525*^9, 
   3.9572867009179783`*^9}, {3.957286734075138*^9, 3.957286774801548*^9}, {
   3.9572898298582344`*^9, 3.9572898308266106`*^9}, 3.9572900245354233`*^9, {
   3.9572903566281853`*^9, 3.9572903710979156`*^9}, {3.9572907860843525`*^9, 
   3.9572908225110455`*^9}, {3.9572909095118217`*^9, 3.957290955627529*^9}, 
   3.957290990805088*^9, {3.957291109820612*^9, 3.9572911348765163`*^9}, 
   3.957291225622837*^9, {3.957314166141203*^9, 3.9573141705476017`*^9}, {
   3.957314248509506*^9, 3.9573142572476254`*^9}, {3.95731449365168*^9, 
   3.957314494514593*^9}, {3.9573152723316135`*^9, 3.957315450694668*^9}, {
   3.9573160238526306`*^9, 3.9573160253828087`*^9}, {3.957316167053137*^9, 
   3.957316181781185*^9}, {3.9573162657671337`*^9, 3.957316272090973*^9}, {
   3.957316508915861*^9, 3.957316534873516*^9}, {3.9573165652640476`*^9, 
   3.957316577010853*^9}, {3.9573166128167686`*^9, 3.9573166198185673`*^9}, {
   3.9573169032842827`*^9, 3.957316971971298*^9}, {3.9573171205010853`*^9, 
   3.9573171373528957`*^9}, {3.9573171921399384`*^9, 
   3.9573172053968506`*^9}, {3.957317259232689*^9, 3.957317315887226*^9}, {
   3.9573174538783607`*^9, 3.9573174597924175`*^9}, {3.9573175964385777`*^9, 
   3.957317599181366*^9}, {3.9573176366927395`*^9, 3.9573176445450134`*^9}, {
   3.9573178163148727`*^9, 3.9573178297948112`*^9}, {3.9573179701002445`*^9, 
   3.957318023596298*^9}, 3.9573183699784737`*^9, {3.957318451910057*^9, 
   3.957318464706997*^9}, {3.957318497637043*^9, 3.9573185047549057`*^9}, {
   3.957318586305977*^9, 3.957318738341593*^9}, 3.9573188534397964`*^9, {
   3.957318976696602*^9, 3.957318981431387*^9}, {3.95731908701256*^9, 
   3.9573190994812946`*^9}, 3.9573192298474674`*^9, 3.957319259971592*^9, 
   3.9573194052631645`*^9, {3.957319530040205*^9, 3.957319560627323*^9}, {
   3.957319633714735*^9, 3.9573196504270782`*^9}, 3.9573197389156*^9, 
   3.9573197767597885`*^9, {3.9573198333301754`*^9, 3.9573198593798313`*^9}, {
   3.957319959253107*^9, 3.9573200428531036`*^9}, {3.9573201625875416`*^9, 
   3.957320193044712*^9}, {3.957320400032076*^9, 3.957320429682396*^9}, {
   3.957320520625189*^9, 3.957320532452215*^9}, {3.9573206494344635`*^9, 
   3.9573206625416355`*^9}, 3.9573211700579185`*^9, {3.9573212151657944`*^9, 
   3.957321218509577*^9}, {3.957321293060753*^9, 3.9573212957964745`*^9}, {
   3.957321331999193*^9, 3.957321355469923*^9}, {3.957321420909092*^9, 
   3.9573214257681046`*^9}, {3.9573214618688583`*^9, 
   3.9573214678560905`*^9}, {3.957322182927101*^9, 3.9573221917315445`*^9}, {
   3.957324109340399*^9, 3.957324111133831*^9}, {3.957325860920143*^9, 
   3.957325861233116*^9}, {3.95732705429558*^9, 3.957327055119543*^9}, {
   3.9573285010941505`*^9, 3.957328505251421*^9}, 3.957352886294092*^9, {
   3.9573530301809273`*^9, 3.957353030830244*^9}, {3.957353139049177*^9, 
   3.957353155850256*^9}, {3.9573534087686596`*^9, 3.957353420932394*^9}, {
   3.957353641422537*^9, 3.957353648240183*^9}, {3.9573542504546757`*^9, 
   3.9573542546455536`*^9}, {3.9573545805085144`*^9, 
   3.9573545805734787`*^9}, {3.9573562169539223`*^9, 3.957356218666355*^9}, {
   3.957356837820854*^9, 3.9573568476196537`*^9}, 3.957359583602333*^9, {
   3.9573597557066326`*^9, 3.9573597677067223`*^9}, {3.9573600663766766`*^9, 
   3.9573600698106346`*^9}, {3.9573601309592457`*^9, 3.95736013925655*^9}, {
   3.9573601870554104`*^9, 3.9573602214704227`*^9}, 3.957360704474022*^9, {
   3.9573607884947815`*^9, 3.9573607903095036`*^9}, {3.9573881681262207`*^9, 
   3.957388172828575*^9}, {3.957389904747368*^9, 3.957389907135021*^9}, {
   3.957390382885317*^9, 3.957390383897011*^9}, {3.957543604829008*^9, 
   3.9575436267303467`*^9}, {3.957907492835842*^9, 3.957907554366646*^9}, {
   3.957909397933464*^9, 3.957909400262148*^9}, {3.957909552893017*^9, 
   3.957909588670355*^9}, {3.9579112153175163`*^9, 3.9579112418722878`*^9}, {
   3.957969469935299*^9, 3.9579694763528347`*^9}, {3.9579701161058884`*^9, 
   3.95797012213398*^9}, {3.957970217751957*^9, 3.957970248441578*^9}, {
   3.957970334585657*^9, 3.957970409978943*^9}, {3.957970467680794*^9, 
   3.9579704719516525`*^9}, {3.957970536816679*^9, 3.9579705509865036`*^9}, {
   3.957970600624172*^9, 3.9579706011372566`*^9}, {3.958312881085079*^9, 
   3.9583128816953526`*^9}, {3.958497783203804*^9, 3.9584977965075626`*^9}, {
   3.9585631052847805`*^9, 3.9585631072951927`*^9}, 3.9585664744030247`*^9, {
   3.958566718216749*^9, 3.9585667261838512`*^9}, {3.9605300901012135`*^9, 
   3.960530093126095*^9}, {3.9605301242934265`*^9, 3.960530143924616*^9}, {
   3.960530820985031*^9, 3.9605308415355663`*^9}, {3.9605324284808083`*^9, 
   3.9605324829548206`*^9}, {3.9605326336621*^9, 3.9605326369642506`*^9}, 
   3.9605341854785595`*^9},ExpressionUUID->"3e6e84a1-bcf0-4043-a216-\
6606e712a565"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". GenerateExpandVertDiffRule and RemoveExpandVertDiffRule - Customizable \
rules for the user"
}], "Subsection",
 CellChangeTimes->{{3.931835609998289*^9, 3.931835613091166*^9}, {
  3.9323873852521105`*^9, 3.932387386189842*^9}, {3.9326378739017925`*^9, 
  3.932637889680304*^9}, {3.948396796248351*^9, 3.948396799953541*^9}, {
  3.948543296522365*^9, 3.948543312018568*^9}, {3.9538126569526615`*^9, 
  3.953812664747444*^9}},ExpressionUUID->"a5392a4c-0dbb-3d4e-92e2-\
c2db99db5bf1"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"RuleDelayed", "::", "rhs"}], "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "GenerateExpandVertDiffRule", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"CheckGenerateExpandVertDiffRule", "->", "True"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GenerateExpandVertDiffRule", "::", "missmatch"}], 
   "=", "\"\<VertDeg missmatch: the VertDeg of `1` is `2`\.08, which does not \
match the VertDeg of the expansion.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"GenerateExpandVertDiffRule", "::", "wrongindices"}], 
    "=", "\"\<The indices of `1` are not the natural ones.\>\""}], ";"}], 
  "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "for", " ", "the", " ", "user", " ", "to", " ", 
    "generate", " ", "their", " ", "own", " ", "expansion", " ", "rules"}], 
   " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GenerateExpandVertDiffRule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"dltensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], ",",
        "expansion_"}], "}"}], ",", 
     RowBox[{"option", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"Options", "[", "GenerateExpandVertDiffRule", "]"}], "]"}]}]}],
     "]"}], ":=", 
   RowBox[{"GenerateExpandVertDiffRuleAUX", "[", 
    RowBox[{
     RowBox[{"dltensor", "[", "inds", "]"}], ",", "expansion", ",", 
     "option"}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GenerateExpandVertDiffRuleAUX", "[", 
    RowBox[{
     RowBox[{"dltensor_", "[", "inds___", "]"}], ",", "expansion_", ",", 
     RowBox[{"option", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"Options", "[", "GenerateExpandVertDiffRule", "]"}], "]"}]}]}],
     "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "rule", ",", "oldexpansion", ",", "redefinitionQ", ",", "removalQ", ",",
        "newdefinitionQ"}], "}"}], ",", "\n", "  ", "\n", "   ", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"OptionValue", "[", "CheckGenerateExpandVertDiffRule", "]"}],
          "&&", 
         RowBox[{"!", 
          RowBox[{
           RowBox[{"VertDeg", "[", "dltensor", "]"}], "===", 
           RowBox[{"VertDeg", "[", "expansion", "]"}]}]}]}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"GenerateExpandVertDiffRule", "::", "missmatch"}], ",", 
           "dltensor", ",", 
           RowBox[{"VertDeg", "[", "dltensor", "]"}]}], "]"}]}]}], "]"}], ";",
       "\n", "   ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"OptionValue", "[", "CheckGenerateExpandVertDiffRule", "]"}],
          "&&", 
         RowBox[{"!", 
          RowBox[{
           RowBox[{"SlotsOfTensor", "[", "dltensor", "]"}], "===", 
           RowBox[{"xAct`xTensor`Private`SignedVBundleOfIndex", "/@", 
            RowBox[{"{", "inds", "}"}]}]}]}]}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"GenerateExpandVertDiffRule", "::", "wrongindices"}], ",", 
           "dltensor"}], "]"}]}]}], "]"}], ";", "\n", "\n", "   ", 
      RowBox[{"rule", "=", 
       RowBox[{"MakeRule", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"dltensor", "[", "inds", "]"}], ",", "expansion"}], "}"}], 
        "]"}]}], ";", "\n", "   ", 
      RowBox[{"oldexpansion", "=", 
       RowBox[{
        RowBox[{"dltensor", "[", "inds", "]"}], "//", 
        RowBox[{"ExpandVertDiff", "[", 
         RowBox[{"HoldExpandVertDiff", "->", 
          RowBox[{"DeleteElements", "[", 
           RowBox[{
            RowBox[{"ListVariationalRelationsOf", "[", 
             RowBox[{"dltensor", ",", 
              RowBox[{"Directed", "->", "In"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"dltensor", ",", 
              RowBox[{"MasterOf", "@", "dltensor"}]}], "}"}]}], "]"}]}], 
         "]"}]}]}], ";", "\n", "\n", "   ", 
      RowBox[{"newdefinitionQ", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"dltensor", "[", "inds", "]"}], "=!=", "expansion"}], "&&", 
        RowBox[{
         RowBox[{"ToCanonical", "[", 
          RowBox[{
           RowBox[{"expansion", "-", "oldexpansion"}], "//", 
           RowBox[{"ExpandVertDiff", "[", "]"}]}], "]"}], "=!=", "0"}]}]}], ";",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "It", " ", "has", " ", "a", " ", "rule", " ", "now", " ", "and", " ", 
        "is", " ", "different", " ", "from", " ", "the", " ", "previous", " ",
         "one"}], " ", "*)"}], "\n", "   ", 
      RowBox[{"redefinitionQ", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"dltensor", "[", "inds", "]"}], "=!=", "oldexpansion"}], "&&", 
        RowBox[{
         RowBox[{"ToCanonical", "[", 
          RowBox[{
           RowBox[{"expansion", "-", "oldexpansion"}], "//", 
           RowBox[{"ExpandVertDiff", "[", "]"}]}], "]"}], "=!=", "0"}]}]}], ";",
       "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "It", " ", "had", " ", "a", " ", "rule", " ", "before", " ", "and", " ",
         "now", " ", "it", " ", "has", " ", "a", " ", "new", " ", "one"}], 
       " ", "*)"}], "\n", "   ", 
      RowBox[{"removalQ", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"dltensor", "[", "inds", "]"}], "=!=", "oldexpansion"}], "&&", 
        RowBox[{
         RowBox[{"dltensor", "[", "inds", "]"}], "===", "expansion"}]}]}], ";",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "It", " ", "had", " ", "an", " ", "old", " ", "rule", " ", "and", " ", 
        "now", " ", "it", " ", "does", " ", "not"}], " ", "*)"}], "\n", 
      "     ", "\n", "   ", 
      RowBox[{"If", "[", 
       RowBox[{"redefinitionQ", ",", 
        RowBox[{"RemoveExpandVertDiffRule", "[", 
         RowBox[{"dltensor", "[", "inds", "]"}], "]"}]}], "]"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "If", " ", "the", " ", "expansion", " ", "is", " ", "not", " ", "the",
          " ", "same", " ", "as", " ", "before"}], ",", " ", 
        RowBox[{
        "we", " ", "first", " ", "remove", " ", "the", " ", "previous", " ", 
         "Variational", " ", "Relations"}]}], " ", "*)"}], "\n", "   ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"removalQ", "&&", "$UndefInfoQ"}], ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Print", "[", 
           
           RowBox[{"\"\<** RemoveExpandVertDiffRule: Expansion formula \
removed for \>\"", ",", "dltensor", ",", "\"\<.\>\""}], "]"}], ";", " ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Dagger", "@", "dltensor"}], "=!=", "dltensor"}], ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<** RemoveExpandVertDiffRule: Expansion formula \
removed for \>\"", ",", 
              RowBox[{"Dagger", "@", "dltensor"}], ",", "\"\<.\>\""}], 
             "]"}]}], "]"}], ";"}], ")"}]}], "]"}], ";", "\n", "   ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"newdefinitionQ", "&&", "$DefInfoQ"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** GenerateExpandVertDiffRule: Expansion formula \
generated for \>\"", ",", "dltensor", ",", "\"\<.\>\""}], "]"}]}], "]"}], ";",
       "\n", " ", "\n", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Add", " ", "variational", " ", "relations"}], " ", "*)"}], 
      "\n", "   ", 
      RowBox[{"If", "[", 
       RowBox[{"newdefinitionQ", ",", "\n", "      ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"VertDeg", "[", "dltensor", "]"}], "==", "1"}], "&&", 
           RowBox[{"BasicVertical1FormQ", "[", "expansion", "]"}]}], ",", 
          "\n", "         ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"fieldsToAdd", "=", 
               RowBox[{"DeleteDuplicates", "[", 
                RowBox[{"MasterOfCPSTensor", "/@", 
                 RowBox[{"HeadOfTensor2", "/@", 
                  RowBox[{"FindAllOfType", "[", 
                   RowBox[{"expansion", ",", "VertDiffExact"}], "]"}]}]}], 
                "]"}]}], ",", "fieldsToRemove"}], "}"}], ",", "\n", 
            "             ", 
            RowBox[{
             RowBox[{"fieldsToRemove", "=", 
              RowBox[{"Complement", "[", 
               RowBox[{
                RowBox[{"VertexInComponent", "[", 
                 RowBox[{"$VariationalGraph", ",", 
                  RowBox[{"MasterOfCPSTensor", "@", "dltensor"}], ",", 
                  RowBox[{"{", "1", "}"}]}], "]"}], ",", 
                RowBox[{"fieldsToAdd", "~", "Join", "~", 
                 RowBox[{"{", 
                  RowBox[{"Dagger", "@", 
                   RowBox[{"MasterOfCPSTensor", "@", "dltensor"}]}], 
                  "}"}]}]}], "]"}]}], ";", "             ", "\n", 
             "             ", 
             RowBox[{
              RowBox[{
               RowBox[{"RemoveVariationalRelation", "[", 
                RowBox[{"#", "->", 
                 RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}]}], "]"}],
                "&"}], "/@", "fieldsToRemove"}], ";", "\n", "             ", 
             RowBox[{
              RowBox[{
               RowBox[{"AddVariationalRelation", "[", 
                RowBox[{"#", "->", 
                 RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}]}], "]"}],
                "&"}], "/@", "fieldsToAdd"}], ";"}]}], "\n", "         ", 
           "]"}], ",", "\n", "         ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"VertDeg", "[", "dltensor", "]"}], "=!=", "1"}], ",", 
            "\n", "            ", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<** GenerateExpandVertDiffRule: No variational \
relation added because \>\"", ",", "dltensor", 
              ",", "\"\< has VertDeg\[NotEqual]1. If necessary, they can be \
added manually using AddVariationalRelation.\>\""}], "]"}], ",", "\n", 
            "            ", 
            RowBox[{
            "Print", 
             "[", "\"\<** GenerateExpandVertDiffRule: No variational relation \
added because the RHS has non-exact terms of VertDeg=1. If necessary, they \
can be added manually using AddVariationalRelation.\>\"", "]"}]}], "\n", 
           "\t     ", "]"}]}], "\n", "\t  ", "]"}]}], "\n", "\t", "]"}], ";", 
      "\n", "\t", "\n", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Remove", " ", "variational", " ", "relations"}], " ", "*)"}], 
      "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{"removalQ", ",", "\n", "      ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"VertDeg", "[", "dltensor", "]"}], "==", "1"}], "&&", 
           RowBox[{"BasicVertical1FormQ", "[", "expansion", "]"}]}], ",", 
          "\n", "         ", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"fields", "=", 
              RowBox[{"DeleteDuplicates", "[", 
               RowBox[{"MasterOf", "/@", 
                RowBox[{"HeadOfTensor2", "/@", 
                 RowBox[{"FindAllOfType", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"dltensor", "[", "inds", "]"}], "//", 
                    RowBox[{"ExpandVertDiff", "[", 
                    RowBox[{"HoldExpandVertDiff", "->", 
                    RowBox[{"DeleteElements", "[", 
                    RowBox[{
                    RowBox[{"ListVariationalRelationsOf", "[", 
                    RowBox[{"dltensor", ",", 
                    RowBox[{"Directed", "->", "In"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"dltensor", ",", 
                    RowBox[{"MasterOf", "@", "dltensor"}]}], "}"}]}], "]"}]}],
                     "]"}]}], ",", "VertDiffExact"}], "]"}]}]}], "]"}]}], 
             "}"}], ",", "\n", "         ", 
            RowBox[{
             RowBox[{
              RowBox[{"RemoveVariationalRelation", "[", 
               RowBox[{"#", "->", 
                RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}]}], "]"}], 
              "&"}], "/@", "fields"}]}], "]"}]}], "\n", "\t  ", "]"}]}], "\n",
        "   ", "]"}], ";", " ", "\n", "\n", "   ", 
      RowBox[{
       RowBox[{"ExpandVertDiffRules", "[", 
        RowBox[{
         RowBox[{"dltensor", "@@", 
          RowBox[{"(", 
           RowBox[{"MakePattern", " ", "/@", " ", 
            RowBox[{"{", "inds", "}"}]}], ")"}]}], ",", 
         RowBox[{"options", ":", 
          RowBox[{"OptionsPattern", "[", 
           RowBox[{"Options", "[", "ExpandVertDiff", "]"}], "]"}]}]}], "]"}], 
       ":=", 
       RowBox[{
        RowBox[{"FilterVertExpand", "[", 
         RowBox[{
          RowBox[{"dltensor", "[", "inds", "]"}], ",", "options"}], "]"}], "[", 
        RowBox[{
         RowBox[{"dltensor", "[", "inds", "]"}], "/.", "rule"}], "]"}]}], ";",
       "\n", "   ", "\n", "   ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Dagger", "@", "dltensor"}], "=!=", "dltensor"}], "&&", 
         "$GenerateExpandVertDiffRuleDagger"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "To", " ", "generate", " ", "the", " ", "Dagger", " ", "version", " ",
           "of", " ", "the", " ", 
          RowBox[{"rule", ".", " ", "Notice"}], " ", "that", " ", "no", " ", 
          "check", " ", "is", " ", "performed", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"e", ".", "g", ".", " ", "if"}], " ", "dltensor", " ", 
            "is", " ", "real", " ", "and", " ", "the", " ", "expansion", " ", 
            "is", " ", "not", " ", "or", " ", "the", " ", "opposite"}], 
           ")"}]}], " ", "*)"}], "\n", "      ", 
        RowBox[{"(", "\n", "      ", 
         RowBox[{
          RowBox[{"$GenerateExpandVertDiffRuleDagger", "=", "False"}], ";", 
          "\n", "      ", 
          RowBox[{"GenerateExpandVertDiffRule", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Dagger", "[", 
               RowBox[{"dltensor", "[", "inds", "]"}], "]"}], ",", 
              RowBox[{"Dagger", "[", "expansion", "]"}]}], "}"}], ",", 
            "option"}], "]"}], ";", "\n", "      ", 
          RowBox[{"$GenerateExpandVertDiffRuleDagger", "=", "True"}], ";"}], 
         "\n", "      ", ")"}]}], "\n", "   ", "]"}], ";"}]}], "\n", "]"}]}], 
  "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"To", " ", "remove", " ", "the", " ", "rule"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"RemoveExpandVertDiffRule", "[", 
   RowBox[{"dltensor_", "?", "VertExactHeadQ"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dltensorwithindices", "=", 
      RowBox[{"TensorWithIndices", "[", "dltensor", "]"}]}], "}"}], ",", 
    RowBox[{"GenerateExpandVertDiffRule", "[", 
     RowBox[{"{", 
      RowBox[{"dltensorwithindices", ",", "dltensorwithindices"}], "}"}], 
     "]"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveExpandVertDiffRule", "[", 
    RowBox[{
     RowBox[{"dltensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], 
    "]"}], ":=", 
   RowBox[{"RemoveExpandVertDiffRule", "[", "dltensor", "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", 
    RowBox[{"GenerateExpandVertDiffRule", ",", "RemoveExpandVertDiffRule"}], 
    "]"}], ";"}], "\n"}], "\n", 
 RowBox[{"On", "[", 
  RowBox[{"RuleDelayed", "::", "rhs"}], "]"}]}], "Code",
 CellChangeTimes->{{3.948543417426765*^9, 3.9485435138146744`*^9}, {
   3.948556796121597*^9, 3.948556803327899*^9}, {3.94867067988781*^9, 
   3.9486706802081428`*^9}, {3.948671570603197*^9, 3.9486715718277645`*^9}, {
   3.948720272955421*^9, 3.948720372536055*^9}, {3.948720511926487*^9, 
   3.948720551004337*^9}, {3.948720590685325*^9, 3.948720616235202*^9}, {
   3.948720657865517*^9, 3.948720681392479*^9}, {3.948720766229675*^9, 
   3.948720820572781*^9}, 3.948720895934909*^9, {3.948721451186627*^9, 
   3.948721499167163*^9}, {3.948721550242681*^9, 3.948721556959101*^9}, {
   3.948721608850696*^9, 3.948721673118537*^9}, {3.948721770401565*^9, 
   3.948721771940707*^9}, {3.948721991831943*^9, 3.948722069318209*^9}, {
   3.948722358769448*^9, 3.94872240673374*^9}, 3.948722462601724*^9, {
   3.948722515814275*^9, 3.948722517291419*^9}, {3.948722577875179*^9, 
   3.9487226258043876`*^9}, {3.948722843136578*^9, 3.948722873809964*^9}, {
   3.948723391296804*^9, 3.9487233934668226`*^9}, 3.9487234761642823`*^9, {
   3.948723591139141*^9, 3.948723594144512*^9}, 3.9490822610036535`*^9, {
   3.949689476789591*^9, 3.949689489533718*^9}, {3.94969132069149*^9, 
   3.94969133021368*^9}, {3.949691629050464*^9, 3.949691631636772*^9}, 
   3.949767387713337*^9, {3.950207663670002*^9, 3.950207667507995*^9}, 
   3.950292850468664*^9, 3.9505294184528866`*^9, {3.9506137152918987`*^9, 
   3.9506137164659405`*^9}, {3.9508102038363647`*^9, 
   3.9508102069955997`*^9}, {3.951399969886162*^9, 3.9513999859072266`*^9}, {
   3.951408117601856*^9, 3.951408119924566*^9}, {3.951409502070772*^9, 
   3.9514095789686985`*^9}, 3.9514112268872375`*^9, {3.9514123926277485`*^9, 
   3.951412395737913*^9}, {3.951412580597349*^9, 3.9514126510558777`*^9}, 
   3.951412763418909*^9, 3.951412921248537*^9, 3.951413259839407*^9, {
   3.9514133372467346`*^9, 3.951413364918442*^9}, {3.951413507907955*^9, 
   3.951413525625759*^9}, {3.9514136177414265`*^9, 3.9514136214765415`*^9}, {
   3.9514136570317917`*^9, 3.951413700566513*^9}, {3.951413764268879*^9, 
   3.9514137695610714`*^9}, {3.95141407455657*^9, 3.9514141157978935`*^9}, {
   3.951414165549225*^9, 3.951414194176443*^9}, {3.951414270733284*^9, 
   3.9514143671941814`*^9}, {3.9514144221274776`*^9, 
   3.9514144765187225`*^9}, {3.951414547893696*^9, 3.95141456042037*^9}, {
   3.951415028783848*^9, 3.951415100922289*^9}, {3.9514152015426464`*^9, 
   3.9514152821114216`*^9}, {3.9514153153719654`*^9, 3.951415363245863*^9}, {
   3.951415532822239*^9, 3.9514155347749825`*^9}, {3.9514155831498947`*^9, 
   3.951415659650591*^9}, {3.9514157429182262`*^9, 3.951415746586508*^9}, {
   3.9514158166831894`*^9, 3.951415824121166*^9}, {3.9514158594885864`*^9, 
   3.951415861157181*^9}, {3.9514159689814034`*^9, 3.951416037138651*^9}, {
   3.9514160677878723`*^9, 3.9514161228792458`*^9}, 3.951416202014986*^9, {
   3.9514163850194206`*^9, 3.951416429218441*^9}, 3.9514165196606846`*^9, 
   3.9514176007616024`*^9, 3.951417677742588*^9, 3.9514750935297985`*^9, 
   3.9514849200527115`*^9, {3.952174777579899*^9, 3.9521748876979313`*^9}, 
   3.9521898185597305`*^9, {3.952189880683277*^9, 3.952189926359188*^9}, {
   3.9530551757115135`*^9, 3.9530552516813736`*^9}, {3.9538126955185165`*^9, 
   3.953812715595379*^9}, {3.9538129177606583`*^9, 3.9538129724994965`*^9}, {
   3.953813004355135*^9, 3.9538130935345783`*^9}, {3.9538131354199333`*^9, 
   3.953813218874935*^9}, {3.953814046219219*^9, 3.9538140627641163`*^9}, {
   3.9538141834442863`*^9, 3.9538141850042286`*^9}, {3.95381563722456*^9, 
   3.953815691057825*^9}, {3.9538158308122025`*^9, 3.95381585235845*^9}, {
   3.953853666683859*^9, 3.9538536676820793`*^9}, {3.955103475872961*^9, 
   3.9551035259725895`*^9}, {3.9551035810268745`*^9, 
   3.9551035816971016`*^9}, {3.9551036409795246`*^9, 
   3.9551036665379353`*^9}, {3.955103734586687*^9, 3.955103746396469*^9}, {
   3.9551037870514717`*^9, 3.9551037950900745`*^9}, {3.955103854034725*^9, 
   3.955103858766775*^9}, {3.9551038938745785`*^9, 3.9551039622556915`*^9}, {
   3.9551047059948597`*^9, 3.9551048018422375`*^9}, {3.9551049233577366`*^9, 
   3.955104974394182*^9}, {3.9551108933314037`*^9, 3.9551109713665543`*^9}, {
   3.9551111453403606`*^9, 3.9551111819002953`*^9}, {3.9551112621890755`*^9, 
   3.955111281101265*^9}, {3.9551113500790367`*^9, 3.95511135056283*^9}, {
   3.9551113856215763`*^9, 3.9551114650597973`*^9}, {3.9551116395822697`*^9, 
   3.955111641274988*^9}, {3.955111693693844*^9, 3.955111700728895*^9}, {
   3.955112253665661*^9, 3.95511227196694*^9}, {3.955112583903425*^9, 
   3.955112584869217*^9}, {3.9553893252283115`*^9, 3.955389337944542*^9}, 
   3.9564254815893497`*^9, 3.9571928745191097`*^9, {3.9581323754867096`*^9, 
   3.958132389570406*^9}, {3.9581597264831104`*^9, 3.958159731338993*^9}, {
   3.958160051102911*^9, 3.9581600753302593`*^9}, {3.9581602485626583`*^9, 
   3.958160256408039*^9}, {3.958162703681818*^9, 3.958162758387766*^9}, {
   3.958162909526287*^9, 3.958162945512615*^9}, {3.958163040384159*^9, 
   3.958163067023712*^9}, {3.9581634795489273`*^9, 3.958163499910946*^9}, {
   3.958163746421049*^9, 3.958163846632612*^9}, {3.958163930695051*^9, 
   3.9581639536273613`*^9}, {3.9581640312717953`*^9, 3.958164056807108*^9}, {
   3.958164086824438*^9, 3.9581641231847343`*^9}, {3.958164351058075*^9, 
   3.9581644017291946`*^9}, {3.958164702055599*^9, 3.9581647479120064`*^9}, {
   3.9581650487524834`*^9, 3.9581650660195026`*^9}, {3.9581650965100594`*^9, 
   3.9581651176344147`*^9}, {3.958165218405052*^9, 3.958165230147772*^9}, {
   3.9581652713303013`*^9, 3.9581653084265156`*^9}, {3.958165402153101*^9, 
   3.9581654036583443`*^9}, 3.9581654444877853`*^9, {3.9581655723597527`*^9, 
   3.958165635005188*^9}, {3.958165675873169*^9, 3.958165788379986*^9}, {
   3.9581658505075474`*^9, 3.9581658871537952`*^9}, {3.9581659670811005`*^9, 
   3.9581659751111584`*^9}, {3.958166014989605*^9, 3.9581661419532776`*^9}, {
   3.958166325379196*^9, 3.958166343492508*^9}, {3.9581665002386227`*^9, 
   3.9581665229604473`*^9}, {3.958166554081314*^9, 3.958166574328167*^9}, {
   3.958166834424364*^9, 3.958166855458605*^9}, {3.9581669061506615`*^9, 
   3.9581669472264996`*^9}, {3.958167000472887*^9, 3.9581670500798798`*^9}, {
   3.958167160570101*^9, 3.958167192900181*^9}, {3.958167258671852*^9, 
   3.9581672863521385`*^9}, {3.958167353333357*^9, 3.9581673921864357`*^9}, {
   3.9581734563039513`*^9, 3.9581734768438454`*^9}, {3.958176975535801*^9, 
   3.958177010084093*^9}, {3.9581772052161617`*^9, 3.958177266280611*^9}, {
   3.9581773991411*^9, 3.958177516343748*^9}, {3.958177628326666*^9, 
   3.9581776321532936`*^9}, {3.9581778260704117`*^9, 
   3.9581779941275997`*^9}, {3.9581780953815975`*^9, 
   3.9581781482370625`*^9}, {3.958178243823059*^9, 3.9581783452198563`*^9}, {
   3.958178551866352*^9, 3.9581785527901535`*^9}, {3.9602968131057377`*^9, 
   3.960296945970829*^9}, {3.9602970037160683`*^9, 3.9602970414182053`*^9}, {
   3.9602972554784775`*^9, 3.960297275739023*^9}, 3.960298250348486*^9, {
   3.960359609853386*^9, 3.960359626678583*^9}, {3.9603598256844425`*^9, 
   3.9603598965851574`*^9}, {3.9603609535321083`*^9, 
   3.9603609722557507`*^9}, {3.9603611221021595`*^9, 
   3.9603611315733433`*^9}, {3.9603646269324265`*^9, 
   3.9603646479438477`*^9}, {3.960366470005972*^9, 3.960366471244419*^9}, {
   3.9603673741362953`*^9, 3.9603673863037224`*^9}, {3.960367426679802*^9, 
   3.9603674397736206`*^9}, {3.960367472694866*^9, 3.960367490285179*^9}, {
   3.9603675506494694`*^9, 3.96036755841716*^9}, {3.9603676664262066`*^9, 
   3.96036766884091*^9}, {3.9603678367802906`*^9, 3.9603678522555027`*^9}, {
   3.9604640526739044`*^9, 3.96046419510108*^9}, {3.960464337660263*^9, 
   3.9604643428807163`*^9}, {3.9604666145809193`*^9, 
   3.9604666276979256`*^9}, {3.9763161593406696`*^9, 3.9763161647482834`*^9}, 
   3.97631625339406*^9, 3.976316448752865*^9, {3.9763164902443943`*^9, 
   3.9763165040308285`*^9}, {3.9763166222489986`*^9, 3.976316664556942*^9}, {
   3.9763167938465652`*^9, 3.9763168351304073`*^9}, {3.976317009876335*^9, 
   3.9763170794224167`*^9}, 
   3.976317194794859*^9},ExpressionUUID->"adbe99f5-f535-9f4a-bf8a-\
f6eb46839302"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Rules on how to expand the VertDiff of differential operators"
}], "Section",
 CellChangeTimes->{{3.931835656965879*^9, 3.931835659984695*^9}, 
   3.9483956005265245`*^9, {3.948397001532031*^9, 3.948397010340268*^9}, {
   3.948460740154368*^9, 3.948460747179065*^9}, {3.958648307448704*^9, 
   3.9586483097964077`*^9}},ExpressionUUID->"66734454-f69f-064e-a69b-\
8e7486b676f7"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertDiff"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, 
   3.948396999574721*^9},ExpressionUUID->"1894d690-c8a3-784f-8b49-\
d548e027d00d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "ExpandVertDiff", "]"}], " ", ":=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SeparateMetric", "->", "True"}], ",", 
      RowBox[{"Explode", "->", "True"}], ",", 
      RowBox[{"ExpandVertDiffCovD", "->", "True"}], ",", 
      RowBox[{"ExpandVertDiffLieD", "->", "True"}], ",", 
      RowBox[{"ExpandVertDiffBracket", "->", "True"}], ",", 
      RowBox[{"ExpandVertDiffTotalDerivative", "->", "True"}], ",", 
      RowBox[{"ExpandVertDiffScalarFunction", "->", "True"}], ",", 
      RowBox[{"ConstantTensors", "->", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"NonConstantTensors", "->", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"HoldExpandVertDiff", "->", "None"}]}], "}"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ExpandVertDiffRules", "]"}], ":=", 
   RowBox[{"Options", "[", "ExpandVertDiff", "]"}]}], " ", "\n", " ", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "ExpandVertDiff", " ", "applies", " ", "ExpandVertDiffRules", " ", "to", " ",
     "all", " ", "the", " ", "terms", " ", "with", " ", "the", " ", "head", " ",
     "VertDiff", " ", "or", " ", "all", " ", "the", " ", "terms", " ", "that",
     " ", "are", " ", "exact", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
      "they", " ", "always", " ", "have", " ", "a", " ", "rule", " ", "for", " ",
        "ExpandVertDiffRules"}], ")"}], "."}]}], " ", "*)"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertDiff", "[", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"Options", "[", "ExpandVertDiff", "]"}], "]"}]}], "]"}], "[", 
    "expr_", "]"}], " ", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "tmp", "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"tmp", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"OptionValue", "[", "SeparateMetric", "]"}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"expr", "//", 
               RowBox[{"SeparateMetric", "[", "]"}]}], "//", 
              RowBox[{"SeparateMetric", "[", "]"}]}], ")"}], "=!=", "expr"}], 
           ",", 
           RowBox[{
            RowBox[{"ExpandVertDiff", "[", "options", "]"}], "[", 
            RowBox[{
             RowBox[{"expr", "//", 
              RowBox[{"SeparateMetric", "[", "]"}]}], "//", 
             RowBox[{"SeparateMetric", "[", "]"}]}], "]"}], ",", 
           RowBox[{"expr", "//", 
            RowBox[{"SeparateMetric", "[", "]"}]}]}], "]"}], ",", "\n", 
         "    ", "expr"}], "]"}]}], ";", "\n", "    ", "\n", "  ", 
      RowBox[{"tmp", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"OptionValue", "[", "Explode", "]"}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"tmp", "//", "Explode"}], ")"}], "=!=", "tmp"}], ",", 
           RowBox[{
            RowBox[{"ExpandVertDiff", "[", "options", "]"}], "[", 
            RowBox[{"tmp", "//", "Explode"}], "]"}], ",", "tmp"}], "]"}], ",",
          "\n", "    ", "tmp"}], "]"}]}], ";", "\n", "    ", "\n", "  ", 
      RowBox[{"tmp", " ", "/.", " ", 
       RowBox[{"{", "\n", "    ", 
        RowBox[{
         RowBox[{"expr1_VertDiff", " ", ":>", " ", 
          RowBox[{"ExpandVertDiffRules", "[", 
           RowBox[{"expr1", ",", " ", "options"}], "]"}]}], ",", " ", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "This", " ", "expands", " ", "Covariant", " ", "Derivaties"}], ",",
            " ", 
           RowBox[{"Lie", " ", "Derivatives"}], ",", " ", 
           RowBox[{"and", " ", "Lie", " ", 
            RowBox[{"Brackets", "."}]}]}], " ", "*)"}], "\n", "    ", 
         RowBox[{
          RowBox[{"expr2_", "?", "VertExactQ"}], " ", ":>", " ", 
          RowBox[{"ExpandVertDiffRules", "[", 
           RowBox[{"expr2", ",", " ", "options"}], "]"}]}]}], " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "This", " ", "expands", " ", "vertical", " ", "exact", " ", 
          "tensors", " ", "in", " ", "terms", " ", "of", " ", "formulas", " ",
           "previously", " ", "defined"}], " ", "*)"}], "\n", "  ", 
        "}"}]}]}]}], "\n", "]"}]}], "\n", "  "}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "ExpandVertDiff", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.931835669708132*^9, 3.931835680642259*^9}, {
   3.932029687818178*^9, 3.932029687835061*^9}, {3.93218149037718*^9, 
   3.9321814909922576`*^9}, 3.9323874442279005`*^9, 3.932522643075829*^9, {
   3.932560546502189*^9, 3.932560551651831*^9}, {3.9326277030576277`*^9, 
   3.932627717501683*^9}, {3.932637821624402*^9, 3.93263782248192*^9}, 
   3.933793347185272*^9, {3.9485428319269447`*^9, 3.9485428439809875`*^9}, {
   3.948542874252353*^9, 3.9485428743944073`*^9}, {3.948557075938025*^9, 
   3.948557138626516*^9}, {3.948671264220461*^9, 3.948671310173008*^9}, {
   3.948671510359893*^9, 3.948671521702838*^9}, {3.948724397734978*^9, 
   3.948724402565755*^9}, {3.949082261007653*^9, 3.949082261020654*^9}, {
   3.9508218656087017`*^9, 3.950821869330494*^9}, {3.950821901049181*^9, 
   3.9508219842217064`*^9}, {3.950822147931814*^9, 3.950822295030691*^9}, {
   3.950822412788818*^9, 3.950822439082722*^9}, {3.950822499185623*^9, 
   3.950822540751463*^9}, {3.950822631694677*^9, 3.950822650717697*^9}, {
   3.9508226874379654`*^9, 3.950822721567865*^9}, {3.9510783798632727`*^9, 
   3.951078383800831*^9}, {3.951078536659063*^9, 3.951078545275307*^9}, 
   3.951223881997837*^9, {3.951312812021677*^9, 3.951312843181843*^9}, 
   3.9513133590505505`*^9, {3.951313700763134*^9, 3.951313773049349*^9}, {
   3.951313816005762*^9, 3.951313854002999*^9}, 3.95131395278574*^9, 
   3.9513141542989464`*^9, {3.951320596496516*^9, 3.951320600832695*^9}, {
   3.951408990268503*^9, 3.951408996518856*^9}, 3.9514091878316364`*^9, 
   3.951413075981661*^9, {3.9514164885106716`*^9, 3.951416489039732*^9}, {
   3.951416832757349*^9, 3.951416834505274*^9}, {3.951417161612734*^9, 
   3.9514171623784313`*^9}, {3.9514751410390415`*^9, 
   3.9514751450101814`*^9}, {3.9514751790401764`*^9, 3.9514751914669037`*^9}, 
   3.9514756282208595`*^9, 3.951477560432251*^9, {3.9552112905483913`*^9, 
   3.9552112928825645`*^9}, {3.9573745715840034`*^9, 3.957374574664879*^9}, {
   3.9577027959845734`*^9, 3.957702801346775*^9}, {3.9578142701264286`*^9, 
   3.95781427228841*^9}, {3.9578145100472393`*^9, 3.9578145988813744`*^9}, 
   3.9578147094780884`*^9, {3.957816204261738*^9, 3.957816219476755*^9}, {
   3.957816334845785*^9, 3.95781639165868*^9}, {3.9578176310994873`*^9, 
   3.9578176848930664`*^9}, {3.957817766520439*^9, 3.9578177694307976`*^9}, {
   3.960366716294958*^9, 3.9603667331919136`*^9}, 3.9603667785214024`*^9},
 CellLabel->
  "In[598]:=",ExpressionUUID->"c0cad6d2-d456-9c49-9fe1-bdee9ded6b79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertDiffRules"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, 
   3.949082261033181*^9},ExpressionUUID->"2b35d032-db3a-e243-a785-\
5bc466586b8b"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "ExpandVertDiffRules", " ", "does", " ", "the", " ", "heavy", " ", "lift", 
    " ", "and", " ", "is", " ", "based", " ", "on", " ", "ExpandPerturbation",
     " ", "of", " ", "xPert"}], " ", "*)"}], "\n", " ", "\[IndentingNewLine]",
   " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Handles", " ", "scalar", " ", "expressions"}], " ", "*)"}], "\n", 
  " ", 
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertDiffRules", "[", 
     RowBox[{
      RowBox[{"VertDiff", "[", "expr_Scalar", "]"}], ",", "options___"}], 
     "]"}], ":=", 
    RowBox[{"Scalar", "[", 
     RowBox[{
      RowBox[{"ExpandVertDiff", "[", "options", "]"}], "[", 
      RowBox[{"VertDiff", "[", 
       RowBox[{"expr", "//", "NoScalar"}], "]"}], "]"}], "]"}]}], " ", "\n", 
   " ", "\n", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandVertDiffRules", "[", 
      RowBox[{
       RowBox[{"VertDiff", "[", "expr_", "]"}], ",", " ", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", 
         RowBox[{"Options", "[", "ExpandVertDiff", "]"}], "]"}]}]}], "]"}], 
     " ", ":=", " ", "\n", "  ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "sepmetric", ",", " ", "expcov", ",", "expLie", ",", "expBracket", ",",
          "expScalar", ",", "exptotder", ",", "tmp", ",", "totderterms"}], 
        "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "sepmetric", ",", "expcov", ",", "expLie", ",", "expBracket", ",", 
           "expScalar", ",", "exptotder"}], "}"}], " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "SeparateMetric", ",", "ExpandVertDiffCovD", ",", 
             "ExpandVertDiffLieD", ",", "ExpandVertDiffBracket", ",", 
             "ExpandVertDiffScalarFunction", ",", 
             "ExpandVertDiffTotalDerivative"}], "}"}], " ", "/.", " ", 
           RowBox[{"CheckOptions", "[", "options", "]"}]}], " ", "/.", " ", 
          RowBox[{"Options", "[", "ExpandVertDiff", "]"}]}]}], ";", "\n", 
        "   ", "\n", "   ", 
        RowBox[{"tmp", " ", "=", " ", 
         RowBox[{"VertDiff", "[", 
          RowBox[{"If", "[", 
           RowBox[{"sepmetric", ",", " ", 
            RowBox[{
             RowBox[{"SeparateMetric", "[", "]"}], "[", "expr", "]"}], ",", 
            " ", "expr"}], "]"}], "]"}]}], ";", "\n", "   ", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"Expanding", " ", "covd", " ", "is", " ", "optional"}], " ", 
         "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expcov", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{"VertDiff", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"_Symbol", "?", "CovDQ"}], "[", "_", "]"}], "[", 
                 "_", "]"}], "]"}], "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertDiffCovDFunction", "[", "expr1", "]"}]}]}]}]}], "]"}],
         ";", "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expcov", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{"VertDiff", "[", 
                RowBox[{
                 RowBox[{"ParamD", "[", "__", "]"}], "[", "_", "]"}], "]"}], 
               "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertDiffParamDFunction", "[", "expr1", "]"}]}]}]}]}], 
         "]"}], ";", "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expcov", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{"VertDiff", "[", 
                RowBox[{"OverDot", "[", "_", "]"}], "]"}], "]"}]}], " ", ":>",
              " ", 
             RowBox[{
             "ExpandVertDiffOverDotFunction", "[", "expr1", "]"}]}]}]}]}], 
         "]"}], ";", "\n", "      ", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"Expanding", " ", "Lie", " ", "is", " ", "optional"}], " ", 
         "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expLie", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{"VertDiff", "[", 
                RowBox[{
                 RowBox[{"LieD", "[", "_", "]"}], "[", "_", "]"}], "]"}], 
               "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertDiffLieDFunction", "[", "expr1", "]"}]}]}]}]}], "]"}],
         ";", "\n", "   ", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"Expanding", " ", "Bracket", " ", "is", " ", "optional"}], 
         " ", "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expBracket", ",", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{"VertDiff", "[", 
                RowBox[{
                 RowBox[{"Bracket", "[", 
                  RowBox[{"_", ",", " ", "_"}], "]"}], "[", "_", "]"}], "]"}],
                "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertDiffBracketFunction", "[", "expr1", "]"}]}]}]}]}], 
         "]"}], ";", "\n", "   ", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Expanding", " ", "TotalDerivative", " ", "is", " ", "optional"}], 
         " ", "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"exptotder", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{"VertDiff", "[", 
                RowBox[{"expr2_", "?", "TotalDerivativeDivergenceQ"}], "]"}], 
               "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertDiffTotalDerivativeFunction", "[", "expr1", 
              "]"}]}]}]}]}], "]"}], ";", "\n", "   ", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Expanding", " ", "scalar", " ", "functions", " ", "is", " ", 
          "optional"}], " ", "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expScalar", ",", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{"VertDiff", "[", 
                RowBox[{
                 RowBox[{"function_", "?", "ScalarFunctionDefinedQ"}], "[", 
                 "__", "]"}], "]"}], "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertDiffScalarFunctionFunction", "[", "expr1", 
              "]"}]}]}]}]}], "]"}], ";", "\n", "   ", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Expanding", " ", "scalar", " ", "functions", " ", "is", " ", 
          "optional"}], " ", "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expScalar", ",", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{"VertDiff", "[", 
                RowBox[{
                 RowBox[{"partialpartial_", "?", "PartialPartialQ"}], "[", 
                 "___", "]"}], "]"}], "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertDiffScalarFunctionFunction", "[", "expr1", 
              "]"}]}]}]}]}], "]"}], ";", "\n", "\n", "   ", 
        RowBox[{"(*", " ", "Reexpand", " ", "*)"}], "\n", "   ", "\n", "   ", 
        RowBox[{"totderterms", "=", 
         RowBox[{"OnlyTotalDerivative", "[", "tmp", "]"}]}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "To", " ", "prevent", " ", "loops", " ", "with", " ", 
          "TotalDerivative", " ", "terms"}], " ", "*)"}], "\n", "   ", 
        RowBox[{"tmp", "=", 
         RowBox[{"DiscardTotalDerivative", "[", "tmp", "]"}]}], ";", "\n", 
        "   ", "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"tmp", " ", "=!=", " ", 
           RowBox[{"VertDiff", "[", "expr", "]"}]}], ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{
            RowBox[{"ExpandVertDiff", "[", "options", "]"}], "[", "tmp", 
            "]"}]}]}], "]"}], ";", "\n", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{"Return", " ", "result"}], " ", "*)"}], "\n", "   ", 
        RowBox[{"tmp", "+", "totderterms"}]}]}], "\n", "   ", "]"}]}], 
    ";"}]}]}]], "Code",
 CellChangeTimes->{
  3.931835702226453*^9, {3.9318755442475977`*^9, 3.9318755544973893`*^9}, {
   3.931875587332176*^9, 3.931875623465564*^9}, {3.932029687850279*^9, 
   3.932029687850279*^9}, {3.932181521026951*^9, 3.9321815274716444`*^9}, 
   3.9323874642779408`*^9, 3.932522663088516*^9, {3.932560882157784*^9, 
   3.93256089477088*^9}, {3.932577770872837*^9, 3.932577803075491*^9}, {
   3.932637989858222*^9, 3.93263799066193*^9}, {3.932638557054892*^9, 
   3.9326385682973475`*^9}, 3.932645176202622*^9, {3.932976661685524*^9, 
   3.9329766663029575`*^9}, {3.932976725543041*^9, 3.932976734199843*^9}, {
   3.932976769666577*^9, 3.932976773774558*^9}, {3.9329768154854193`*^9, 
   3.932976815750227*^9}, {3.932976853375573*^9, 3.932976860231135*^9}, {
   3.933774664402955*^9, 3.933774671683688*^9}, {3.9337747055338554`*^9, 
   3.933774706735383*^9}, {3.933776494508347*^9, 3.933776508081063*^9}, {
   3.933776770581898*^9, 3.933776772903998*^9}, {3.933778942728173*^9, 
   3.9337789443271403`*^9}, 3.933781685461453*^9, {3.9485428926807575`*^9, 
   3.948542897628765*^9}, {3.948546268212111*^9, 3.9485462957815666`*^9}, 
   3.9486716046327047`*^9, {3.9486716506059456`*^9, 3.948671652489944*^9}, {
   3.94871946023356*^9, 3.94871946144321*^9}, {3.948719985689726*^9, 
   3.948719986534224*^9}, {3.948724346915429*^9, 3.948724391738924*^9}, {
   3.949000962182347*^9, 3.949000962749795*^9}, {3.9490010335463905`*^9, 
   3.9490010341523514`*^9}, {3.949056431778073*^9, 3.9490564341350327`*^9}, {
   3.94908226103718*^9, 3.949082261049814*^9}, {3.949174154765597*^9, 
   3.949174155319557*^9}, {3.950613652030487*^9, 3.950613655871937*^9}, {
   3.950613725093851*^9, 3.95061373506414*^9}, {3.950821529869255*^9, 
   3.950821689818458*^9}, {3.9508217251374702`*^9, 3.950821733139181*^9}, {
   3.950821788764696*^9, 3.950821801552977*^9}, {3.9508227103927784`*^9, 
   3.950822717159033*^9}, 3.951078390469183*^9, {3.95107843132533*^9, 
   3.951078471964071*^9}, 3.95107850351033*^9, {3.9510811083933277`*^9, 
   3.951081109783018*^9}, {3.951223928790478*^9, 3.951223941777605*^9}, {
   3.9512241594577217`*^9, 3.951224178343244*^9}, 3.9514115317669983`*^9, {
   3.955211216960058*^9, 3.955211279995491*^9}, 3.9552113179990444`*^9, 
   3.955290908029093*^9, {3.955823112583954*^9, 3.955823135466364*^9}, {
   3.957374531050806*^9, 3.9573745651509323`*^9}, {3.9573746104816303`*^9, 
   3.957374612102188*^9}, 3.9573749196555595`*^9, {3.957375085603895*^9, 
   3.957375112848503*^9}, 3.957375156645172*^9, 3.957381219843132*^9, {
   3.9573814496911545`*^9, 3.957381450412031*^9}, {3.957381569780962*^9, 
   3.957381581951273*^9}, {3.9573817751967983`*^9, 3.957381852235937*^9}, {
   3.9577069454496784`*^9, 3.9577069957753983`*^9}, {3.9578143123895416`*^9, 
   3.9578143851463947`*^9}, {3.957814462637789*^9, 3.957814507084669*^9}, {
   3.9583055331029873`*^9, 3.958305575732006*^9}, 3.9588835729099007`*^9, {
   3.9588852845859947`*^9, 3.958885324359833*^9}},
 CellLabel->
  "In[602]:=",ExpressionUUID->"2cf9fb93-68c0-da49-95b6-6a90a0eaa03c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertDiffCovDFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, {3.948396898860741*^9, 
   3.9483969152348957`*^9}, {3.948460712445939*^9, 3.948460713995473*^9}, 
   3.9581280925706196`*^9, 
   3.958305765714199*^9},ExpressionUUID->"b7571325-6e63-754c-83bd-\
4076885fa7b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Auxiliary", " ", "function", " ", "extractIndices"}], " ", "*)"}],
   "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"extractIndices", "[", "expr_", "]"}], " ", ":=", " ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"Identity", " ", "@@", " ", "\n", "    ", 
       RowBox[{"xAct`xTensor`Private`selecton", "[", 
        RowBox[{
         RowBox[{"IndexList", "@", "#"}], ",", " ", 
         RowBox[{"VBundleOfIndex", "[", "#", "]"}]}], "]"}]}], " ", "&"}], 
     " ", "/@", "\n", "    ", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"FindFreeIndices", "[", "expr", "]"}], ",", " ", "AIndexQ"}], 
      "]"}]}]}], ";"}]}]], "Code",
 CellLabel->
  "In[604]:=",ExpressionUUID->"0eeb5f12-8bb2-b740-a191-7e103fba8857"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ExpandVertDiffDer", " ", "uses", " ", "the", " ", "formula", " ", 
     RowBox[{"\[DifferentialD]", 
      RowBox[{
       SubscriptBox["\[Del]", "a"], 
       SubscriptBox[
        SuperscriptBox["T", "b"], "c"]}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Del]", "a"], 
      RowBox[{"\[DifferentialD]", 
       SubscriptBox[
        SuperscriptBox["T", "b"], "c"]}]}], "+", 
     RowBox[{
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "b"], "ad"], 
      SubscriptBox[
       SuperscriptBox["T", "d"], "c"]}], "-", 
     RowBox[{
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "d"], "ac"], 
      SubscriptBox[
       SuperscriptBox["T", "b"], "d"]}], "+", 
     RowBox[{"weight", " ", 
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "d"], "ad"], 
      SubscriptBox[
       SuperscriptBox["T", "b"], "c"]}]}]}], "  ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "ExpandVertDiffDer", " ", "is", " ", "a", " ", "faster", " ", "version",
        " ", 
       RowBox[{"of", ":", " ", "tensor"}]}], " ", "->", " ", 
      RowBox[{
       RowBox[{"ChangeCovD", "[", 
        RowBox[{"tensor", ",", "cd", ",", "PD"}], "]"}], " ", "->", " ", 
       RowBox[{"VertDiff", "[", "%", "]"}]}]}], " ", "//", " ", 
     RowBox[{
      RowBox[{"ChangeCovd", "[", 
       RowBox[{"%", ",", "PD", ",", "cd"}], "]"}], " ", "because", " ", 
      RowBox[{"\[DifferentialD]", 
       RowBox[{"@", "PD"}]}]}]}], "=", 
    RowBox[{"PD", "@", "\[DifferentialD]"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"ExpandVertDiffCovDFunction", "[", 
    RowBox[{"VertDiff", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"cd_Symbol", "?", "CovDQ"}], "[", 
       RowBox[{"-", "a_"}], "]"}], "[", "expr_", "]"}], "]"}], "]"}], " ", ":=", 
   RowBox[{"Module", "[", "\n", "\t", 
    RowBox[{
     RowBox[{"{", "\n", "\t", 
      RowBox[{
       RowBox[{"freeindices", "=", " ", 
        RowBox[{"extractIndices", "[", "expr", "]"}]}], ",", "\n", "\t", 
       "result"}], "\n", "\t", "}"}], ",", " ", "\n", "\t", 
     RowBox[{
      RowBox[{"result", " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"cd", "[", 
          RowBox[{"-", "a"}], "]"}], "[", 
         RowBox[{"VertDiff", "[", "expr", "]"}], "]"}], " ", "+", " ", 
        RowBox[{"Plus", " ", "@@", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{"xAct`xTensor`Private`addChristoffel", "[", 
              RowBox[{"expr", ",", " ", 
               RowBox[{"-", "a"}]}], "]"}], ",", " ", "freeindices"}], "]"}], 
           " ", "/.", " ", 
           RowBox[{
            RowBox[{"expr1_", " ", 
             RowBox[{"xAct`xTensor`Private`CHR", "[", "indices__", "]"}]}], 
            " ", ":>", "  ", 
            RowBox[{"WWedge", "[", 
             RowBox[{
              RowBox[{"VertDiff", "[", 
               RowBox[{
                RowBox[{"Christoffel", "[", "cd", "]"}], "[", "indices", 
                "]"}], "]"}], ",", "expr1"}], "]"}]}]}], ")"}]}]}]}], ";", 
      "\n", "\t  ", "\n", "\t", 
      RowBox[{"result", " ", "+", " ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"basis", " ", "=", " ", 
            RowBox[{"WeightedWithBasis", "[", "cd", "]"}]}], ",", " ", 
           RowBox[{"dummy", " ", "=", " ", 
            RowBox[{"DummyIn", "@", 
             RowBox[{"VBundleOfIndex", "[", "a", "]"}]}]}], ",", " ", 
           "weight"}], "}"}], ",", " ", "\n", "\t    ", 
         RowBox[{
          RowBox[{"weight", " ", "=", " ", 
           RowBox[{"WeightOf", "[", 
            RowBox[{"expr", ",", " ", "basis"}], "]"}]}], ";", "\n", "\t    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"weight", " ", "===", " ", "0"}], ",", " ", "\n", 
            "\t       ", "0", ",", " ", "\n", "\t       ", 
            RowBox[{"weight", " ", 
             RowBox[{"With", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"chr", " ", "=", " ", 
                 RowBox[{
                  RowBox[{"Christoffel", "[", 
                   RowBox[{"cd", ",", " ", 
                    RowBox[{"xAct`xCoba`PDOfBasis", "[", "basis", "]"}]}], 
                   "]"}], "[", 
                  RowBox[{"dummy", ",", " ", 
                   RowBox[{"-", "a"}], ",", " ", 
                   RowBox[{"-", "dummy"}]}], "]"}]}], "}"}], ",", " ", "\n", 
               "\t        ", 
               RowBox[{"-", 
                RowBox[{"WWedge", "[", 
                 RowBox[{
                  RowBox[{"VertDiff", "[", "chr", "]"}], ",", "expr"}], 
                 "]"}]}]}], " ", "\n", "\t      ", "]"}]}]}], "\n", "\t    ", 
           "]"}]}]}], "\n", "\t  ", "]"}]}]}]}], "\n", "\t", 
    "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.931835728973033*^9, 3.932387486329762*^9, 3.932522676264061*^9, {
   3.932626019999331*^9, 3.932626034738581*^9}, {3.932626081377493*^9, 
   3.932626082267186*^9}, {3.932638893821111*^9, 3.932638895463776*^9}, {
   3.932645138613037*^9, 3.932645138803996*^9}, {3.933685015119207*^9, 
   3.933685227805232*^9}, {3.9485429407857647`*^9, 3.948542962095869*^9}, {
   3.949056428138026*^9, 3.949056429550332*^9}, {3.95061350663122*^9, 
   3.9506135155239124`*^9}, {3.951053331741808*^9, 3.951053333096228*^9}, 
   3.951224192513855*^9, {3.9577070006423836`*^9, 3.9577070015660725`*^9}},
 CellLabel->
  "In[605]:=",ExpressionUUID->"8ccffda2-99ac-da43-8d63-8504d59adb7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertDiffParamDFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, {3.948396898860741*^9, 
   3.9483969152348957`*^9}, {3.948460712445939*^9, 3.948460713995473*^9}, {
   3.94900519978151*^9, 3.9490052019592524`*^9}, 3.949058682950047*^9, 
   3.958127971917761*^9, 3.9582232638179874`*^9, {3.958305659986908*^9, 
   3.9583056726743584`*^9}, 
   3.958305713858261*^9},ExpressionUUID->"f20a56cb-d98c-f94a-9daf-\
d6de88487839"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertDiffParamDFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"VertDiff", "[", 
     RowBox[{
      RowBox[{"ParamD", "[", "parameter__", "]"}], "[", "expr_", "]"}], "]"}],
     "]"}], "]"}], " ", ":=", 
  RowBox[{
   RowBox[{"ParamD", "[", "parameter", "]"}], "[", 
   RowBox[{"VertDiff", "[", "expr", "]"}], "]"}]}]], "Code",
 CellChangeTimes->{
  3.931835728973033*^9, 3.932387486329762*^9, 3.932522676264061*^9, {
   3.932626019999331*^9, 3.932626034738581*^9}, {3.932626081377493*^9, 
   3.932626082267186*^9}, {3.932638893821111*^9, 3.932638895463776*^9}, {
   3.932645138613037*^9, 3.932645138803996*^9}, {3.933685015119207*^9, 
   3.933685227805232*^9}, {3.9485429407857647`*^9, 3.948542962095869*^9}, 
   3.9490052132375417`*^9, {3.949005311233761*^9, 3.9490053494023*^9}, {
   3.949005395898487*^9, 3.949005397457689*^9}, 3.9490055422463646`*^9, {
   3.949055658689997*^9, 3.949055665412817*^9}, {3.9490560934569*^9, 
   3.9490561069699545`*^9}, {3.9490569435439568`*^9, 3.949056947994599*^9}, {
   3.949090085437219*^9, 3.949090085678877*^9}, {3.9512242588862896`*^9, 
   3.95122426841786*^9}, {3.9577070375084724`*^9, 3.957707038593519*^9}, {
   3.958128000645235*^9, 3.958128032259676*^9}, 3.9583056217860107`*^9, {
   3.9583056753953648`*^9, 3.9583056868366737`*^9}, 3.958305728050194*^9},
 CellLabel->
  "In[606]:=",ExpressionUUID->"72336a15-3dd3-0d42-be2c-0fff4b9f1c95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertDiffOverDotFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, {3.948396898860741*^9, 
   3.9483969152348957`*^9}, {3.948460712445939*^9, 3.948460713995473*^9}, {
   3.94900519978151*^9, 3.9490052019592524`*^9}, 3.949058682950047*^9, 
   3.958127971917761*^9, 3.958223262293335*^9, {3.95830570468194*^9, 
   3.958305711296898*^9}},ExpressionUUID->"8f814d0d-b142-4d44-a9c7-\
8573f3cab3fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertDiffOverDotFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"VertDiff", "[", 
     RowBox[{"OverDot", "[", "expr_", "]"}], "]"}], "]"}], "]"}], " ", ":=", 
  RowBox[{"OverDot", "[", 
   RowBox[{"VertDiff", "[", "expr", "]"}], "]"}]}]], "Code",
 CellChangeTimes->{
  3.931835728973033*^9, 3.932387486329762*^9, 3.932522676264061*^9, {
   3.932626019999331*^9, 3.932626034738581*^9}, {3.932626081377493*^9, 
   3.932626082267186*^9}, {3.932638893821111*^9, 3.932638895463776*^9}, {
   3.932645138613037*^9, 3.932645138803996*^9}, {3.933685015119207*^9, 
   3.933685227805232*^9}, {3.9485429407857647`*^9, 3.948542962095869*^9}, 
   3.9490052132375417`*^9, {3.949005311233761*^9, 3.9490053494023*^9}, {
   3.949005395898487*^9, 3.949005397457689*^9}, 3.9490055422463646`*^9, {
   3.949055658689997*^9, 3.949055665412817*^9}, {3.9490560934569*^9, 
   3.9490561069699545`*^9}, {3.9490569435439568`*^9, 3.949056947994599*^9}, {
   3.949090085437219*^9, 3.949090085678877*^9}, {3.9512242588862896`*^9, 
   3.95122426841786*^9}, {3.9577070375084724`*^9, 3.957707038593519*^9}, 
   3.958128004322769*^9, {3.9581280402051067`*^9, 3.9581280465995293`*^9}, {
   3.958305695718853*^9, 3.9583057084198093`*^9}},
 CellLabel->
  "In[607]:=",ExpressionUUID->"ea58a250-ca42-c54d-9035-792e697500d4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertDiffLieDFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835737378836*^9, 3.931835742082288*^9}, 
   3.948396833112151*^9, {3.948396920059084*^9, 3.948396931515546*^9}, {
   3.94839697117202*^9, 3.948396972112565*^9}, {3.948460721196004*^9, 
   3.9484607226915436`*^9}, 3.9581280830200977`*^9, 
   3.958305756834482*^9},ExpressionUUID->"b8255258-b9ee-e640-921b-\
6124b55c4b0c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"\[DifferentialD]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["L", "V"], 
       RowBox[{"(", "exp", ")"}]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["L", 
       RowBox[{"\[DifferentialD]", "V"}]], 
      RowBox[{"(", "expr", ")"}]}], "+", 
     RowBox[{"L", 
      RowBox[{"(", 
       RowBox[{"\[DifferentialD]", "expr"}], ")"}]}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ExpandVertDiffLieDFunction", "[", 
    RowBox[{"VertDiff", "[", 
     RowBox[{
      RowBox[{"LieD", "[", "v_", "]"}], "[", "expr_", "]"}], "]"}], "]"}], 
   " ", ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"LieD", "[", 
      RowBox[{"VertDiff", "@", "v"}], "]"}], "[", "expr", "]"}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"VertDeg", "[", "v", "]"}]], 
     RowBox[{
      RowBox[{"LieD", "[", "v", "]"}], "[", 
      RowBox[{"VertDiff", "@", "expr"}], "]"}]}]}]}]}]], "Code",
 CellChangeTimes->{
  3.9318357523003016`*^9, {3.932387499770298*^9, 3.932387502330002*^9}, 
   3.932522685898901*^9, {3.933774154898095*^9, 3.933774172848715*^9}, {
   3.933776429007101*^9, 3.933776436728996*^9}, {3.933776541520671*^9, 
   3.933776544776167*^9}, {3.933776786037992*^9, 3.9337768139746933`*^9}, {
   3.933779129553838*^9, 3.933779138100461*^9}, {3.948542955317256*^9, 
   3.948542963057881*^9}, 3.9490564125223293`*^9, {3.951224197548954*^9, 
   3.9512241977093353`*^9}, {3.9577070048213596`*^9, 3.957707005208172*^9}},
 CellLabel->
  "In[608]:=",ExpressionUUID->"a0542d28-85b3-9444-89a2-621f192f61af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertDiffBracketFunction"
}], "Subsection",
 CellChangeTimes->{
  3.932387523129629*^9, 3.9483968319197803`*^9, {3.948396940397819*^9, 
   3.9483969677986946`*^9}, {3.9484607232970066`*^9, 3.9484607235127125`*^9}, 
   3.958128079049164*^9, 
   3.958305758171358*^9},ExpressionUUID->"cec1c59e-3177-6a47-99dd-\
4d0a1f923434"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertDiffBracketFunction", "[", 
   RowBox[{"VertDiff", "[", 
    RowBox[{
     RowBox[{"Bracket", "[", 
      RowBox[{"v1_", ",", " ", "v2_"}], "]"}], "[", "a_Symbol", "]"}], "]"}], 
   "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Bracket", "[", 
     RowBox[{
      RowBox[{"VertDiff", "@", "v1"}], ",", " ", "v2"}], "]"}], "[", "a", 
    "]"}], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"VertDeg", "[", "v1", "]"}]], 
    RowBox[{
     RowBox[{"Bracket", "[", 
      RowBox[{"v1", ",", 
       RowBox[{"VertDiff", "@", "v2"}]}], "]"}], "[", "a", 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.9323875312001467`*^9, 3.932522696837884*^9, {3.933779360578002*^9, 
   3.933779395704607*^9}, {3.9337794445101647`*^9, 3.933779453582934*^9}, 
   3.933781502500701*^9, {3.948542979647881*^9, 3.948542987320108*^9}, {
   3.949056414313175*^9, 3.949056416453219*^9}, {3.951224199159758*^9, 
   3.9512241993079166`*^9}, 3.9577070078041687`*^9},
 CellLabel->
  "In[609]:=",ExpressionUUID->"cfce4159-f1a7-c349-b4bc-38345664757e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertDiffTotalDerivativeFunction"
}], "Subsection",
 CellChangeTimes->{
  3.932387523129629*^9, 3.9483968319197803`*^9, {3.948396940397819*^9, 
   3.9483969677986946`*^9}, {3.9484607232970066`*^9, 
   3.9484607235127125`*^9}, {3.957379264649002*^9, 3.9573792711020756`*^9}, 
   3.9581280671883354`*^9, 
   3.958305759718113*^9},ExpressionUUID->"a0952160-98fe-7149-bb0d-\
502ffc1c9fac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertDiffTotalDerivativeFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"VertDiff", "[", 
     RowBox[{"expr_", "?", "TotalDerivativeDivergenceQ"}], "]"}], "]"}], 
   "]"}], " ", ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"info", "=", 
       RowBox[{"TotalDerivativeDivergenceInfo", "[", "expr", "]"}]}], ",", 
      "freeindex"}], "}"}], ",", 
    RowBox[{
     RowBox[{"freeindex", "=", 
      RowBox[{
       RowBox[{"-", "1"}], "*", 
       RowBox[{"List", "@@", 
        RowBox[{"FindFreeIndices", "[", 
         RowBox[{"Evaluate", "[", 
          RowBox[{"info", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "]"}], "]"}]}]}]}], ";", 
     RowBox[{
      RowBox[{"info", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"info", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "@@", "freeindex"}], 
       RowBox[{"(", 
        RowBox[{"VertDiff", "[", " ", 
         RowBox[{"info", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "]"}], ")"}]}], "]"}]}]}], 
   "]"}]}]], "Code",
 CellChangeTimes->{
  3.9323875312001467`*^9, 3.932522696837884*^9, {3.933779360578002*^9, 
   3.933779395704607*^9}, {3.9337794445101647`*^9, 3.933779453582934*^9}, 
   3.933781502500701*^9, {3.948542979647881*^9, 3.948542987320108*^9}, {
   3.949056414313175*^9, 3.949056416453219*^9}, {3.951224199159758*^9, 
   3.9512241993079166`*^9}, {3.9573746302781277`*^9, 3.957374768734537*^9}, {
   3.9573749925675354`*^9, 3.9573750077475853`*^9}, {3.9573752103514175`*^9, 
   3.9573752162189045`*^9}, {3.9573792915409565`*^9, 3.957379292409231*^9}, {
   3.957379930083521*^9, 3.9573799699689693`*^9}, 3.957707009168028*^9},
 CellLabel->
  "In[610]:=",ExpressionUUID->"6eceeeec-2b58-254f-8ded-9f5aff481fc1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertDiffScalarFunction"
}], "Subsection",
 CellChangeTimes->{
  3.932387523129629*^9, 3.9483968319197803`*^9, {3.948396940397819*^9, 
   3.9483969677986946`*^9}, {3.9484607232970066`*^9, 
   3.9484607235127125`*^9}, {3.9552111874320984`*^9, 3.955211197041422*^9}, 
   3.9583057625059433`*^9},ExpressionUUID->"05e65713-ec34-fa43-833b-\
56cbb222f36e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertDiffScalarFunctionFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"VertDiff", "[", 
     RowBox[{
      RowBox[{"f_", "?", "ScalarFunctionDefinedQ"}], "[", "fields__", "]"}], 
     "]"}], "]"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\n", "\t", 
   RowBox[{
    RowBox[{"{", "ListOfSummands", "}"}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "This", " ", "ensures", " ", "that", " ", "the", " ", "argument", " ", 
      "can", " ", "be", " ", "also", " ", 
      RowBox[{"PD", "@", "tensor"}]}], " ", "*)"}], "\n", "\t", "\n", "\t", 
    RowBox[{"(*", " ", 
     RowBox[{"This", " ", "ensures", " ", "that", " ", "the", " ", 
      RowBox[{"PartialPartial", "[", 
       RowBox[{"function", ",", "tensor"}], "]"}], " ", "is", " ", 
      "defined"}], " ", "*)"}], "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"PartialPartialQ", "[", 
            RowBox[{
             RowBox[{"PartialPartial", "[", "f", "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"HeadOfTensor2", "@", "#"}], "}"}], "]"}], 
            "\[InvisibleSpace]", "]"}]}], ",", 
          RowBox[{"DefPartialPartial", "[", 
           RowBox[{"f", ",", 
            RowBox[{"{", 
             RowBox[{"HeadOfTensor2", "@", "#"}], "}"}]}], "]"}]}], "]"}], 
        "&"}], ")"}], "/@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", "fields", "}"}], "]"}]}], ";", "\n", "\t", "\n", "\t", 
     RowBox[{"ListOfSummands", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"TensorWithIndices", "/@", 
         RowBox[{"DeleteDuplicates", "@", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", "fields", "}"}], "]"}]}]}], ")"}], " ", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"head_", "?", "xTensorQ"}], "[", "inds___", "]"}], ":>", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"PartialPartial", "[", "f", "]"}], "[", "head", "]"}], 
             "\[InvisibleSpace]", "@@", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Times", "[", 
                 RowBox[{"#", ",", 
                  RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", 
               RowBox[{"IndexList", "[", "inds", "]"}]}], ")"}]}], ")"}], "~",
            "WWedge", "~", 
           RowBox[{"VertDiff", "[", 
            RowBox[{"head", "[", "inds", "]"}], "]"}]}], "}"}]}], "}"}]}]}], ";",
      "\n", "\t", 
     RowBox[{
      RowBox[{"ListOfSummands", "//", "Flatten"}], "//", "adding"}]}]}], "\n",
    "]"}]}]], "Code",
 CellChangeTimes->{{3.955210458895344*^9, 3.955210470804966*^9}, {
   3.955210623402094*^9, 3.955210682258623*^9}, {3.955210760656704*^9, 
   3.955210794149803*^9}, {3.955211071926998*^9, 3.9552110905460854`*^9}, 
   3.9552111996718407`*^9, {3.9552112518652096`*^9, 3.955211254212534*^9}, {
   3.9552113325349407`*^9, 3.955211362882725*^9}, {3.9553667517544327`*^9, 
   3.9553667564232883`*^9}, {3.955367056084194*^9, 3.955367086219631*^9}, {
   3.9553671996940956`*^9, 3.9553672027796288`*^9}, {3.9553673717609673`*^9, 
   3.95536737768231*^9}, {3.9553674441205845`*^9, 3.9553674508147755`*^9}, {
   3.955478123765024*^9, 3.955478139383381*^9}, {3.955486099561346*^9, 
   3.955486099847185*^9}, 3.955488964671932*^9, 3.9554890135568695`*^9, {
   3.9554890510189285`*^9, 3.955489052742508*^9}, 3.9554900019543095`*^9, 
   3.955732500851738*^9, {3.9557326297119713`*^9, 3.9557326517650185`*^9}, {
   3.955733358256153*^9, 3.955733358325327*^9}, {3.955733435702961*^9, 
   3.955733435773735*^9}, {3.955734073948084*^9, 3.9557341040262547`*^9}, {
   3.9557351703489017`*^9, 3.9557351715100727`*^9}, {3.955741471555479*^9, 
   3.955741472417227*^9}, {3.955741920181637*^9, 3.9557419259339924`*^9}, 
   3.957707011860367*^9, {3.958336366842409*^9, 3.9583363713604584`*^9}, {
   3.958336427117872*^9, 3.9583364420226345`*^9}, 3.958336732501213*^9},
 CellLabel->
  "In[611]:=",ExpressionUUID->"f6fd4f11-0531-9a4d-bff2-4bc2e6239c57"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OrderOfPartialPartial", "[", "_", "]"}], ":=", "0"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"ExpandVertDiffScalarFunctionFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"VertDiff", "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "PartialPartialQ"}], "[", "indices___", "]"}], 
     "]"}], "]"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", "\t", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"order", "=", 
       RowBox[{"OrderOfPartialPartial", "[", "tensor", "]"}]}], ",", 
      "\[IndentingNewLine]", "\t", "list", ",", "\[IndentingNewLine]", "\t", 
      RowBox[{"function", "=", 
       RowBox[{"FunctionOfPartialPartial", "[", "tensor", "]"}]}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"tensors", "=", 
       RowBox[{"TensorsOfPartialPartial", "[", "tensor", "]"}]}], ",", 
      "\[IndentingNewLine]", "\t", "dependenciesofscalar", ",", 
      "\[IndentingNewLine]", "\t", "ListOfSummands"}], "\[IndentingNewLine]", 
     "\t", "}"}], ",", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"dependenciesofscalar", "=", 
      RowBox[{"DependenciesOfScalar", "[", "function", "]"}]}], ";", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"dependenciesofscalar", "=", 
      RowBox[{"Union", "[", 
       RowBox[{"tensors", "~", "Join", "~", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ListQ", "[", "dependenciesofscalar", "]"}], ",", 
          "dependenciesofscalar", ",", 
          RowBox[{"{", "}"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\t", 
     RowBox[{"list", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"{", "tensors", "}"}], ",", "#"}], "]"}], "&"}], "/@", 
       "dependenciesofscalar"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "list", " ", "of", " ", "tensors", " ", "wrt", " ", "which", " ", "we", 
       " ", "take", " ", "the", " ", "partial", " ", "derivative", " ", "of", 
       " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "If", " ", "the", " ", "required", " ", "tensors", " ", "are", " ", 
        "not", " ", "defined"}], ",", " ", 
       RowBox[{"we", " ", "define", " ", "them", " ", "here"}]}], " ", "*)"}],
      "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"PartialPartialQ", "[", 
            RowBox[{
             RowBox[{"PartialPartial", "[", "function", "]"}], "[", 
             RowBox[{"Flatten", "[", 
              RowBox[{"{", 
               RowBox[{"HeadOfTensor2", "/@", 
                RowBox[{"Flatten", "[", "#", "]"}]}], "}"}], "]"}], "]"}], 
            "\[InvisibleSpace]", "]"}]}], ",", 
          RowBox[{"DefPartialPartial", "[", 
           RowBox[{"function", ",", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"HeadOfTensor2", "/@", 
               RowBox[{"Flatten", "[", "#", "]"}]}], "}"}], "]"}]}], "]"}]}], 
         "]"}], "&"}], ")"}], "/@", "list"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"ListOfSummands", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"TensorWithIndices", "/@", "dependenciesofscalar"}], ")"}], 
       " ", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"head_", "?", "xTensorQ"}], "[", "inds___", "]"}], ":>", 
         "\[IndentingNewLine]", "\t\t\t", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "partialtensor", ",", "extendedindices", ",", "position"}], "}"}],
            ",", "\n", "\t\t\t", "\[IndentingNewLine]", "\t\t\t\t", 
           RowBox[{
            RowBox[{"partialtensor", "=", 
             RowBox[{
              RowBox[{"PartialPartial", "[", "function", "]"}], "[", 
              RowBox[{"Flatten", "[", 
               RowBox[{"{", 
                RowBox[{"head", ",", "tensors"}], "}"}], "]"}], "]"}]}], ";", 
            "\n", "\t\t\t\t", "\[IndentingNewLine]", "\t\t\t\t ", 
            RowBox[{"(*", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "tensors", " ", "appearing", " ", "in", " ", "the", " ", 
                "denominator", " ", "of", " ", "the", " ", "new", " ", 
                "tensor"}], " ", ",", " ", 
               RowBox[{
               "Placement", " ", "of", " ", "the", " ", "contracted", " ", 
                "indices"}]}], " ", "}"}], " ", "*)"}], "\[IndentingNewLine]",
             "\t\t\t\t", 
            RowBox[{"position", "=", 
             RowBox[{"Transpose", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                "TensorsOfPartialPartial", "[", "partialtensor", "]"}], ",", 
                RowBox[{"PlacementOfIndices", "[", "partialtensor", "]"}]}], 
               "}"}], "]"}]}], ";", "\n", "\t\t\t\t", "\[IndentingNewLine]", 
            "\t\t\t\t", 
            RowBox[{"extendedindices", "=", 
             RowBox[{
              RowBox[{"Insert", "[", 
               RowBox[{
                RowBox[{"{", "indices", "}"}], ",", 
                RowBox[{
                 RowBox[{"-", "1"}], "*", 
                 RowBox[{"{", "inds", "}"}]}], ",", 
                RowBox[{"Last", "@", 
                 RowBox[{"SelectFirst", "[", 
                  RowBox[{"position", ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "===", "head"}], " ", 
                    "&"}]}], "]"}]}]}], "]"}], "//", "Flatten"}]}], ";", "\n",
             "\t\t\t\t", "\[IndentingNewLine]", "\t\t\t\t", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"partialtensor", "@@", "extendedindices"}], ")"}], "~",
               "WWedge", "~", 
              RowBox[{"VertDiff", "[", 
               RowBox[{"head", "[", "inds", "]"}], "]"}]}], "}"}]}]}], "\n", 
          "\t\t\t", "]"}]}], "\n", "\t\t", "}"}]}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"Chain", " ", "rule"}], " ", "*)"}], "\n", "\t\t", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"ListOfSummands", "//", "Flatten"}], "//", "adding"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Code",
 CellChangeTimes->{{3.955822977271591*^9, 3.955823018527258*^9}, {
   3.956354491296543*^9, 3.956354494450861*^9}, {3.957278339347784*^9, 
   3.957278476776531*^9}, {3.9577068779141273`*^9, 3.957706878325617*^9}, 
   3.9577070148543396`*^9},
 CellLabel->
  "In[612]:=",ExpressionUUID->"84173968-06ce-684a-a98c-56e2c5f4a3a7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Rules on how to expand the VertInt of differential operators"
}], "Section",
 CellChangeTimes->{{3.931835656965879*^9, 3.931835659984695*^9}, 
   3.9483956005265245`*^9, {3.948397001532031*^9, 3.948397010340268*^9}, {
   3.948460740154368*^9, 3.948460747179065*^9}, {3.949082169785667*^9, 
   3.94908217007623*^9}, {3.958648320941885*^9, 
   3.9586483220562744`*^9}},ExpressionUUID->"860ca378-0700-0c4a-835f-\
409be8c9b4d8"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertInt"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, 3.948396999574721*^9, 
   3.949082184752295*^9, 
   3.9577028847737064`*^9},ExpressionUUID->"8f791b7b-4011-e243-a386-\
0b531f71e27f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Similar", " ", "to", " ", "ExpandVertDiff", " ", "but", " ", "it", " ", 
     "expands", " ", 
     RowBox[{"VertInt", ".", " ", "Some"}], " ", "formulas", " ", "are", " ", 
     "similar"}], ",", " ", 
    RowBox[{
    "but", " ", "then", " ", "we", " ", "have", " ", "the", " ", "specific", " ",
      "values", " ", "defined", " ", "by", " ", "vvf"}]}], " ", "*)"}], "\n", 
  "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "ExpandVertInt", "]"}], " ", ":=", 
     RowBox[{
      RowBox[{"Options", "[", "ExpandVertDiff", "]"}], "~", "Join", "~", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ExpandVertIntCovD", "\[Rule]", "True"}], ",", 
        RowBox[{"ExpandVertIntLieD", "\[Rule]", "True"}], ",", 
        RowBox[{"ExpandVertIntBracket", "\[Rule]", "True"}], ",", 
        RowBox[{"ExpandVertIntTotalDerivative", "\[Rule]", "True"}], ",", 
        RowBox[{"HoldExpandVertInt", "->", "None"}]}], "}"}]}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Options", "[", "ExpandVertDiffRules", "]"}], ":=", 
    RowBox[{"Options", "[", "ExpandVertInt", "]"}]}], " ", "\n", "\n", 
   RowBox[{
    RowBox[{"ExtractComponentsVertInt", "[", "expr_", "]"}], ":=", 
    RowBox[{
     RowBox[{"Join", "[", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"ComponentsOfVVF", "/@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"VertInt", "[", 
             RowBox[{"_", "?", "VVFQ"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              InterpretationBox["\[Infinity]",
               DirectedInfinity[1]]}], "}"}], ",", 
            RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"VertInt", "[", "vvf_", "]"}], ":>", "vvf"}], "}"}]}], 
         ")"}]}], ",", "\[IndentingNewLine]", "\t", 
       RowBox[{"ComponentsOfGeneralizedVVF", "/@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cases", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"VertInt", "[", 
             RowBox[{"_", "?", "GeneralizedVVFQ"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              InterpretationBox["\[Infinity]",
               DirectedInfinity[1]]}], "}"}], ",", 
            RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"VertInt", "[", "vvf_", "]"}], ":>", "vvf"}], "}"}]}], 
         ")"}]}]}], "\[IndentingNewLine]", "\t", "]"}], "//", "Flatten"}]}], 
   "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandVertInt", "[", 
      RowBox[{"options", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"Options", "[", "ExpandVertInt", "]"}], "]"}]}], "]"}], "[", 
     "expr_", "]"}], " ", ":=", 
    RowBox[{"Module", "[", "\n", "    ", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{"components", "=", 
         RowBox[{"ExtractComponentsVertInt", "[", "expr", "]"}]}], ",", 
        "\[IndentingNewLine]", "\t", "HoldExpand", ",", "opts"}], "\n", "\t", 
       "}"}], ",", "\n", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"HoldExpand", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"OptionValue", "[", "HoldExpandVertDiff", "]"}], "}"}], "~",
           "Join", "~", "components"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\t", 
       RowBox[{"opts", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"DeleteCases", "[", 
           RowBox[{
            RowBox[{"FilterRules", "[", 
             RowBox[{
              RowBox[{"{", "options", "}"}], ",", 
              RowBox[{"Options", "[", "ExpandVertInt", "]"}]}], "]"}], ",", 
            RowBox[{"HoldExpandVertDiff", "->", "_"}]}], "]"}], "~", "Join", "~", 
          RowBox[{"{", 
           RowBox[{"HoldExpandVertDiff", "->", "HoldExpand"}], "}"}]}], "//", 
         "Flatten"}]}], ";", "\n", "\t", "\n", "\t", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"expr", "//", 
           RowBox[{"ExpandVertDiff", "[", 
            RowBox[{"FilterRules", "[", 
             RowBox[{
              RowBox[{"{", "opts", "}"}], ",", 
              RowBox[{"Options", "[", "ExpandVertDiff", "]"}]}], "]"}], 
            "]"}]}], "//", "ExpandAll"}], ")"}], " ", "/.", " ", 
        RowBox[{"{", "\n", "\t\t", 
         RowBox[{
          RowBox[{
           RowBox[{"expr1", ":", " ", 
            RowBox[{"HoldPattern", "[", 
             RowBox[{
              RowBox[{"VertInt", "[", "vvf1_", "]"}], "[", 
              RowBox[{"arg1_Bracket", "[", "inds1__", "]"}], "]"}], "]"}]}], 
           " ", ":>", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ExpandVertIntRules", "@@", "opts"}], ")"}], "[", 
            RowBox[{
             RowBox[{"VertInt", "[", "vvf1", "]"}], "[", 
             RowBox[{"arg1", "[", "inds1", "]"}], "]"}], "]"}]}], ",", "\n", 
          "\t\t", 
          RowBox[{
           RowBox[{"expr2", ":", " ", 
            RowBox[{"HoldPattern", "[", 
             RowBox[{
              RowBox[{"VertInt", "[", "vvf2_", "]"}], "[", 
              RowBox[{
               RowBox[{"arg2_", "?", "xTensorQ"}], "[", "inds2___", "]"}], 
              "]"}], "]"}]}], " ", ":>", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ExpandVertIntReplace", "@@", "opts"}], ")"}], "[", 
            RowBox[{
             RowBox[{"VertInt", "[", "vvf2", "]"}], "[", 
             RowBox[{"arg2", "[", "inds2", "]"}], "]"}], "]"}]}], ",", "\n", 
          "\t\t", 
          RowBox[{
           RowBox[{"expr3", ":", " ", 
            RowBox[{"HoldPattern", "[", 
             RowBox[{
              RowBox[{"VertInt", "[", "vvf3_", "]"}], "[", "arg3_", "]"}], 
             "]"}]}], " ", ":>", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ExpandVertIntRules", "@@", "opts"}], ")"}], "[", 
            RowBox[{
             RowBox[{"VertInt", "[", "vvf3", "]"}], "[", "arg3", "]"}], 
            "]"}]}]}], "\n", "\t\t", "}"}]}]}]}], "\n", "\t", "]"}]}], "\n", 
   " ", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "ExpandVertInt", "]"}], ";"}]}]}]], "Code",
 CellChangeTimes->{{3.931835669708132*^9, 3.931835680642259*^9}, {
   3.932029687818178*^9, 3.932029687835061*^9}, {3.93218149037718*^9, 
   3.9321814909922576`*^9}, 3.9323874442279005`*^9, 3.932522643075829*^9, {
   3.932560546502189*^9, 3.932560551651831*^9}, {3.9326277030576277`*^9, 
   3.932627717501683*^9}, {3.932637821624402*^9, 3.93263782248192*^9}, 
   3.933793347185272*^9, {3.9485428319269447`*^9, 3.9485428439809875`*^9}, {
   3.948542874252353*^9, 3.9485428743944073`*^9}, {3.948557075938025*^9, 
   3.948557138626516*^9}, {3.948671264220461*^9, 3.948671310173008*^9}, {
   3.948671510359893*^9, 3.948671521702838*^9}, {3.948724397734978*^9, 
   3.948724402565755*^9}, {3.948993225054828*^9, 3.948993252631163*^9}, {
   3.948999913949314*^9, 3.948999915672375*^9}, {3.9490008257655487`*^9, 
   3.949000828393922*^9}, {3.949000914950649*^9, 3.949000939761642*^9}, {
   3.949001103172849*^9, 3.9490011416297913`*^9}, {3.9490048749412985`*^9, 
   3.9490048795858545`*^9}, {3.94900492001504*^9, 3.94900512268126*^9}, {
   3.949007145378352*^9, 3.9490071461139755`*^9}, {3.949007199626081*^9, 
   3.949007203548125*^9}, 3.949007238207711*^9, {3.949007292655461*^9, 
   3.9490073219120245`*^9}, {3.949007365846991*^9, 3.949007376903574*^9}, {
   3.9490547775232863`*^9, 3.949054789097717*^9}, {3.949054856539694*^9, 
   3.9490548980340204`*^9}, 3.9490551964543333`*^9, {3.949055267724799*^9, 
   3.949055277662934*^9}, {3.94905533181983*^9, 3.9490553424494677`*^9}, 
   3.9490554215914974`*^9, {3.9490555218652368`*^9, 3.949055535862229*^9}, {
   3.949055986419592*^9, 3.9490559886730137`*^9}, {3.9490565759076395`*^9, 
   3.949056577731551*^9}, 3.9490822610528154`*^9, {3.949090255202348*^9, 
   3.949090258223453*^9}, {3.9490903072856255`*^9, 3.949090368632649*^9}, {
   3.949092049987244*^9, 3.9490920511175814`*^9}, {3.949092277891329*^9, 
   3.949092284311725*^9}, {3.949326542333927*^9, 3.949326560112216*^9}, {
   3.949326592419952*^9, 3.949326609348781*^9}, {3.949326667732843*^9, 
   3.949326692503617*^9}, 3.949348083365592*^9, {3.9493484863578525`*^9, 
   3.949348529605135*^9}, {3.9494331841773415`*^9, 3.949433186936413*^9}, {
   3.949433251626326*^9, 3.949433257902775*^9}, {3.949437936397404*^9, 
   3.94943794110208*^9}, {3.949437994520864*^9, 3.9494380156110497`*^9}, {
   3.949438077329975*^9, 3.949438103900474*^9}, 3.949438328725834*^9, 
   3.9494385177551613`*^9, {3.9495044787509956`*^9, 3.949504481051985*^9}, {
   3.949504689445862*^9, 3.949504689773651*^9}, {3.94951778788428*^9, 
   3.949517790288544*^9}, {3.94951786999835*^9, 3.949517917042267*^9}, {
   3.949518015500824*^9, 3.949518030604896*^9}, 3.949518119552967*^9, {
   3.9496036186620407`*^9, 3.949603631441608*^9}, {3.949693185051277*^9, 
   3.9496932034510975`*^9}, {3.9496933171540985`*^9, 
   3.9496933181515656`*^9}, {3.9496935684639015`*^9, 
   3.9496936596247177`*^9}, {3.949693716667218*^9, 3.949693734815518*^9}, {
   3.9502183589301186`*^9, 3.950218392675352*^9}, {3.950218522966696*^9, 
   3.950218571414339*^9}, {3.950306927272529*^9, 3.950306957921639*^9}, 
   3.950307062534045*^9, {3.950307133625791*^9, 3.9503071370814114`*^9}, {
   3.950307276597103*^9, 3.950307321264391*^9}, 3.950307796913557*^9, {
   3.9503079533217506`*^9, 3.9503079572999496`*^9}, 3.950308756143467*^9, {
   3.9503090975587063`*^9, 3.95030911156172*^9}, {3.950613586663172*^9, 
   3.950613630085716*^9}, {3.9508934417282467`*^9, 3.9508934632739525`*^9}, 
   3.951224936210846*^9, {3.9513122530977383`*^9, 3.951312332508262*^9}, 
   3.95131237290518*^9, {3.9513210050470295`*^9, 3.951321013869028*^9}, {
   3.952257711206604*^9, 3.9522577191395493`*^9}, {3.9533916778474903`*^9, 
   3.953391768839426*^9}, {3.9533918102074776`*^9, 3.953391813156204*^9}, {
   3.954577775599266*^9, 3.9545777770051746`*^9}, {3.9563386483799706`*^9, 
   3.9563386567978*^9}, 3.9572784846853333`*^9, {3.9573542908223705`*^9, 
   3.9573542910021*^9}, 3.9573723878337555`*^9, {3.957372486081318*^9, 
   3.9573725009497776`*^9}, {3.957702895797106*^9, 3.9577028979343777`*^9}, {
   3.958155245154152*^9, 3.9581552900049744`*^9}, {3.9581554303591003`*^9, 
   3.9581554865458946`*^9}, {3.9581555447238617`*^9, 3.9581555530247097`*^9}},
 CellLabel->
  "In[614]:=",ExpressionUUID->"5dab21f2-3385-fa47-a45e-b2cf95e98091"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntRules"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, {3.949082261033181*^9, 
   3.949082285859445*^9}},ExpressionUUID->"dee3e33e-1136-9946-b595-\
3d0b76b784ea"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"(*", " ", 
   RowBox[{"ExpandVertDiffRules", " ", "does", " ", "the", " ", "heavy", " ", 
    RowBox[{"lift", ".", " ", "Similar"}], " ", "to", " ", 
    "ExpandVertDiffRules"}], " ", "*)"}], "\n", " ", "\n", " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Handles", " ", "scalar", " ", "expressions"}], " ", "*)"}], 
  "\[IndentingNewLine]", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ExpandVertIntRules", "[", 
      RowBox[{"options", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"Options", "[", "ExpandVertInt", "]"}], "]"}]}], "]"}], "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{"VertInt", "[", "v_", "]"}], "[", "expr_Scalar", "]"}], "]"}], 
     "]"}], ":=", 
    RowBox[{"Scalar", "[", 
     RowBox[{
      RowBox[{"ExpandVertInt", "[", "options", "]"}], "[", 
      RowBox[{
       RowBox[{"VertInt", "[", "v", "]"}], "[", 
       RowBox[{"expr", "//", "NoScalar"}], "]"}], "]"}], "]"}]}], " ", "\n", "\n",
    " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ExpandVertIntRules", "[", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", 
         RowBox[{"Options", "[", "ExpandVertInt", "]"}], "]"}]}], "]"}], "[", 
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"VertInt", "[", "v_", "]"}], "[", "expr_", "]"}], "]"}], 
      "]"}], " ", ":=", " ", "\n", "  ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "sepmetric", ",", " ", "expcov", ",", "exptotder", ",", "expLie", ",",
          "expBracket", ",", "tmp"}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "sepmetric", ",", "expcov", ",", "exptotder", ",", "expLie", ",", 
           "expBracket"}], "}"}], " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "SeparateMetric", ",", "ExpandVertIntCovD", ",", 
             "ExpandVertIntTotalDerivative", ",", "ExpandVertIntLieD", ",", 
             "ExpandVertIntBracket"}], "}"}], " ", "/.", " ", 
           RowBox[{"CheckOptions", "[", "options", "]"}]}], " ", "/.", " ", 
          RowBox[{"Options", "[", "ExpandVertInt", "]"}]}]}], ";", "\n", "  ", 
        RowBox[{"tmp", " ", "=", " ", 
         RowBox[{
          RowBox[{"VertInt", "[", "v", "]"}], "[", 
          RowBox[{"If", "[", 
           RowBox[{"sepmetric", ",", " ", 
            RowBox[{
             RowBox[{"SeparateMetric", "[", "]"}], "[", "expr", "]"}], ",", 
            " ", "expr"}], "]"}], "]"}]}], ";", "\n", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"Expanding", " ", "covd", " ", "is", " ", "optional"}], " ", 
         "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expcov", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{
                RowBox[{"VertInt", "[", "_", "]"}], "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"_Symbol", "?", "CovDQ"}], "[", "_", "]"}], "[", 
                 "_", "]"}], "]"}], "]"}]}], " ", ":>", " ", 
             RowBox[{"ExpandVertIntCovDFunction", "[", "expr1", "]"}]}]}]}]}],
          "]"}], ";", "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expcov", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{
                RowBox[{"VertInt", "[", "_", "]"}], "[", 
                RowBox[{
                 RowBox[{"ParamD", "[", "__", "]"}], "[", "_", "]"}], "]"}], 
               "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertIntParamDFunction", "[", "expr1", "]"}]}]}]}]}], 
         "]"}], ";", "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expcov", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{
                RowBox[{"VertInt", "[", "_", "]"}], "[", 
                RowBox[{"OverDot", "[", "_", "]"}], "]"}], "]"}]}], " ", ":>",
              " ", 
             RowBox[{
             "ExpandVertIntOverDotFunction", "[", "expr1", "]"}]}]}]}]}], 
         "]"}], ";", "\n", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Expanding", " ", "TotalDerivative", " ", "is", " ", "optional"}], 
         " ", "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"exptotder", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{
                RowBox[{"VertInt", "[", "_", "]"}], "[", 
                RowBox[{
                 RowBox[{"_Symbol", "?", "TotalDerivativeQ"}], "[", "_", 
                 "]"}], "]"}], "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertIntTotalDerivativeFunction", "[", "expr1", 
              "]"}]}]}]}]}], "]"}], ";", "\n", "   ", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"Expanding", " ", "Lie", " ", "is", " ", "optional"}], " ", 
         "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expLie", ",", " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{
                RowBox[{"VertInt", "[", "_", "]"}], "[", 
                RowBox[{
                 RowBox[{"LieD", "[", "_", "]"}], "[", "_", "]"}], "]"}], 
               "]"}]}], " ", ":>", " ", 
             RowBox[{"ExpandVertIntLieDFunction", "[", "expr1", "]"}]}]}]}]}],
          "]"}], ";", "\n", "   ", "\n", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"Expanding", " ", "Bracket", " ", "is", " ", "optional"}], 
         " ", "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{"expBracket", ",", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{"tmp", " ", "/.", " ", 
            RowBox[{
             RowBox[{"expr1", " ", ":", " ", 
              RowBox[{"HoldPattern", "[", 
               RowBox[{
                RowBox[{"VertInt", "[", "_", "]"}], "[", 
                RowBox[{
                 RowBox[{"Bracket", "[", 
                  RowBox[{"_", ",", " ", "_"}], "]"}], "[", "_", "]"}], "]"}],
                "]"}]}], " ", ":>", " ", 
             RowBox[{
             "ExpandVertIntBracketFunction", "[", "expr1", "]"}]}]}]}]}], 
         "]"}], ";", "\n", "      ", "\n", "   ", 
        RowBox[{"(*", " ", "Reexpand", " ", "*)"}], "\n", "   ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"tmp", " ", "=!=", " ", 
           RowBox[{
            RowBox[{"VertInt", "[", "v", "]"}], "[", "expr", "]"}]}], ",", 
          " ", 
          RowBox[{"tmp", " ", "=", " ", 
           RowBox[{
            RowBox[{"ExpandVertInt", "[", "options", "]"}], "[", "tmp", 
            "]"}]}]}], "]"}], ";", "\n", "  ", "\n", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{"Return", " ", "result"}], " ", "*)"}], "\n", "   ", 
        "tmp"}]}], "\n", "   ", "]"}]}], ";"}]}]}]], "Code",
 CellChangeTimes->{
  3.931835702226453*^9, {3.9318755442475977`*^9, 3.9318755544973893`*^9}, {
   3.931875587332176*^9, 3.931875623465564*^9}, {3.932029687850279*^9, 
   3.932029687850279*^9}, {3.932181521026951*^9, 3.9321815274716444`*^9}, 
   3.9323874642779408`*^9, 3.932522663088516*^9, {3.932560882157784*^9, 
   3.93256089477088*^9}, {3.932577770872837*^9, 3.932577803075491*^9}, {
   3.932637989858222*^9, 3.93263799066193*^9}, {3.932638557054892*^9, 
   3.9326385682973475`*^9}, 3.932645176202622*^9, {3.932976661685524*^9, 
   3.9329766663029575`*^9}, {3.932976725543041*^9, 3.932976734199843*^9}, {
   3.932976769666577*^9, 3.932976773774558*^9}, {3.9329768154854193`*^9, 
   3.932976815750227*^9}, {3.932976853375573*^9, 3.932976860231135*^9}, {
   3.933774664402955*^9, 3.933774671683688*^9}, {3.9337747055338554`*^9, 
   3.933774706735383*^9}, {3.933776494508347*^9, 3.933776508081063*^9}, {
   3.933776770581898*^9, 3.933776772903998*^9}, {3.933778942728173*^9, 
   3.9337789443271403`*^9}, 3.933781685461453*^9, {3.9485428926807575`*^9, 
   3.948542897628765*^9}, {3.948546268212111*^9, 3.9485462957815666`*^9}, 
   3.9486716046327047`*^9, {3.9486716506059456`*^9, 3.948671652489944*^9}, {
   3.94871946023356*^9, 3.94871946144321*^9}, {3.948719985689726*^9, 
   3.948719986534224*^9}, {3.948724346915429*^9, 3.948724391738924*^9}, {
   3.949000955413167*^9, 3.9490010156907635`*^9}, {3.949001051899358*^9, 
   3.949001071751538*^9}, 3.94900115382967*^9, {3.9490018850055094`*^9, 
   3.949001908920563*^9}, 3.949001949749459*^9, {3.94900199555526*^9, 
   3.9490020036716223`*^9}, {3.949005143543458*^9, 3.949005154095714*^9}, {
   3.94900526004282*^9, 3.9490052614708934`*^9}, {3.949055183414955*^9, 
   3.949055188016138*^9}, {3.949055391096299*^9, 3.949055401485659*^9}, {
   3.949055466542739*^9, 3.949055469899725*^9}, {3.949055551521436*^9, 
   3.949055566659238*^9}, {3.949055686936748*^9, 3.949055693027818*^9}, {
   3.949055997065069*^9, 3.949056051931466*^9}, {3.949056272626148*^9, 
   3.9490562951905603`*^9}, {3.949056570841809*^9, 3.9490565735177383`*^9}, {
   3.949082261056815*^9, 3.949082261058815*^9}, {3.949090090418703*^9, 
   3.949090092889121*^9}, {3.949090137961089*^9, 3.949090143868288*^9}, {
   3.949174148792066*^9, 3.949174148952029*^9}, {3.949504614285803*^9, 
   3.949504627940945*^9}, {3.94950472017499*^9, 3.949504723647608*^9}, 
   3.949693172836584*^9, {3.949693255178673*^9, 3.949693277516291*^9}, 
   3.949693691204132*^9, {3.9496937389230022`*^9, 3.949693782266882*^9}, 
   3.949693828053868*^9, {3.9502184019311523`*^9, 3.9502184379754143`*^9}, 
   3.950218480768095*^9, 3.9502714069327736`*^9, {3.950613636176012*^9, 
   3.950613645154148*^9}, {3.951224240702894*^9, 3.951224267540924*^9}, {
   3.952257664247038*^9, 3.9522576775145397`*^9}, {3.952257725754734*^9, 
   3.952257779832348*^9}, {3.956338632290308*^9, 3.956338632990547*^9}, {
   3.956338672656866*^9, 3.956338839179291*^9}, {3.957371005437172*^9, 
   3.95737101005546*^9}, {3.9573710833222103`*^9, 3.95737110510824*^9}, {
   3.957374788960882*^9, 3.9573747902847843`*^9}, {3.957707024352888*^9, 
   3.9577070339756775`*^9}, {3.958127891273571*^9, 3.9581279503777256`*^9}, 
   3.958305618967655*^9, 3.958305780242304*^9},
 CellLabel->
  "In[619]:=",ExpressionUUID->"81a81be2-14d1-be47-966d-ee5157547879"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntCovDFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, {3.948396898860741*^9, 
   3.9483969152348957`*^9}, {3.948460712445939*^9, 3.948460713995473*^9}, {
   3.94900519978151*^9, 3.9490052019592524`*^9}, 3.949058682950047*^9, 
   3.958127971917761*^9},ExpressionUUID->"0164748f-7f68-fe4f-8ae2-\
26b5bf9ac26d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertIntCovDFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"VertInt", "[", "vv_", "]"}], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"cd_Symbol", "?", "CovDQ"}], "[", 
       RowBox[{"-", "a_"}], "]"}], "[", "expr_", "]"}], "]"}], "]"}], "]"}], 
  " ", ":=", 
  RowBox[{
   RowBox[{"cd", "[", 
    RowBox[{"-", "a"}], "]"}], "[", 
   RowBox[{
    RowBox[{"VertInt", "[", "vv", "]"}], "[", "expr", "]"}], "]"}]}]], "Code",
 CellChangeTimes->{
  3.931835728973033*^9, 3.932387486329762*^9, 3.932522676264061*^9, {
   3.932626019999331*^9, 3.932626034738581*^9}, {3.932626081377493*^9, 
   3.932626082267186*^9}, {3.932638893821111*^9, 3.932638895463776*^9}, {
   3.932645138613037*^9, 3.932645138803996*^9}, {3.933685015119207*^9, 
   3.933685227805232*^9}, {3.9485429407857647`*^9, 3.948542962095869*^9}, 
   3.9490052132375417`*^9, {3.949005311233761*^9, 3.9490053494023*^9}, {
   3.949005395898487*^9, 3.949005397457689*^9}, 3.9490055422463646`*^9, {
   3.949055658689997*^9, 3.949055665412817*^9}, {3.9490560934569*^9, 
   3.9490561069699545`*^9}, {3.9490569435439568`*^9, 3.949056947994599*^9}, {
   3.949090085437219*^9, 3.949090085678877*^9}, {3.9512242588862896`*^9, 
   3.95122426841786*^9}, {3.9577070375084724`*^9, 3.957707038593519*^9}, 
   3.9581279879257565`*^9},
 CellLabel->
  "In[621]:=",ExpressionUUID->"b2a3e915-b2bd-094a-ad6f-0618a543609b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntParamDFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, {3.948396898860741*^9, 
   3.9483969152348957`*^9}, {3.948460712445939*^9, 3.948460713995473*^9}, {
   3.94900519978151*^9, 3.9490052019592524`*^9}, 3.949058682950047*^9, 
   3.958127971917761*^9, 3.9582232638179874`*^9, 
   3.958305659986908*^9},ExpressionUUID->"68e0552a-ae58-dd40-9af0-\
6a8797b22f0d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertIntParamDFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"VertInt", "[", "vv_", "]"}], "[", 
     RowBox[{
      RowBox[{"ParamD", "[", "parameter__", "]"}], "[", "expr_", "]"}], "]"}],
     "]"}], "]"}], " ", ":=", 
  RowBox[{
   RowBox[{"ParamD", "[", "parameter", "]"}], "[", 
   RowBox[{
    RowBox[{"VertInt", "[", "vv", "]"}], "[", "expr", "]"}], "]"}]}]], "Code",
 CellChangeTimes->{
  3.931835728973033*^9, 3.932387486329762*^9, 3.932522676264061*^9, {
   3.932626019999331*^9, 3.932626034738581*^9}, {3.932626081377493*^9, 
   3.932626082267186*^9}, {3.932638893821111*^9, 3.932638895463776*^9}, {
   3.932645138613037*^9, 3.932645138803996*^9}, {3.933685015119207*^9, 
   3.933685227805232*^9}, {3.9485429407857647`*^9, 3.948542962095869*^9}, 
   3.9490052132375417`*^9, {3.949005311233761*^9, 3.9490053494023*^9}, {
   3.949005395898487*^9, 3.949005397457689*^9}, 3.9490055422463646`*^9, {
   3.949055658689997*^9, 3.949055665412817*^9}, {3.9490560934569*^9, 
   3.9490561069699545`*^9}, {3.9490569435439568`*^9, 3.949056947994599*^9}, {
   3.949090085437219*^9, 3.949090085678877*^9}, {3.9512242588862896`*^9, 
   3.95122426841786*^9}, {3.9577070375084724`*^9, 3.957707038593519*^9}, {
   3.958128000645235*^9, 3.958128032259676*^9}, 3.9583056217860107`*^9, 
   3.958305784441105*^9},
 CellLabel->
  "In[622]:=",ExpressionUUID->"067f4aeb-01b2-1249-8669-57c8866bfbd0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntOverDotFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, {3.948396898860741*^9, 
   3.9483969152348957`*^9}, {3.948460712445939*^9, 3.948460713995473*^9}, {
   3.94900519978151*^9, 3.9490052019592524`*^9}, 3.949058682950047*^9, 
   3.958127971917761*^9, 
   3.958223262293335*^9},ExpressionUUID->"fbeb989f-093a-074b-af7f-\
c6077c0c0f63"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertIntOverDotFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"VertInt", "[", "vv_", "]"}], "[", 
     RowBox[{"OverDot", "[", "expr_", "]"}], "]"}], "]"}], "]"}], " ", ":=", 
  RowBox[{"OverDot", "[", 
   RowBox[{
    RowBox[{"VertInt", "[", "vv", "]"}], "[", "expr", "]"}], "]"}]}]], "Code",
 CellChangeTimes->{
  3.931835728973033*^9, 3.932387486329762*^9, 3.932522676264061*^9, {
   3.932626019999331*^9, 3.932626034738581*^9}, {3.932626081377493*^9, 
   3.932626082267186*^9}, {3.932638893821111*^9, 3.932638895463776*^9}, {
   3.932645138613037*^9, 3.932645138803996*^9}, {3.933685015119207*^9, 
   3.933685227805232*^9}, {3.9485429407857647`*^9, 3.948542962095869*^9}, 
   3.9490052132375417`*^9, {3.949005311233761*^9, 3.9490053494023*^9}, {
   3.949005395898487*^9, 3.949005397457689*^9}, 3.9490055422463646`*^9, {
   3.949055658689997*^9, 3.949055665412817*^9}, {3.9490560934569*^9, 
   3.9490561069699545`*^9}, {3.9490569435439568`*^9, 3.949056947994599*^9}, {
   3.949090085437219*^9, 3.949090085678877*^9}, {3.9512242588862896`*^9, 
   3.95122426841786*^9}, {3.9577070375084724`*^9, 3.957707038593519*^9}, 
   3.958128004322769*^9, {3.9581280402051067`*^9, 3.9581280465995293`*^9}},
 CellLabel->
  "In[623]:=",ExpressionUUID->"edf978ca-823c-4f4d-a178-3ff4f10f885e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntTotalDerivativeFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835685932725*^9, 3.9318356898394737`*^9}, 
   3.932029687835061*^9, 3.9483968358051414`*^9, {3.948396898860741*^9, 
   3.9483969152348957`*^9}, {3.948460712445939*^9, 3.948460713995473*^9}, {
   3.94900519978151*^9, 3.9490052019592524`*^9}, 3.949058682950047*^9, 
   3.952257792427206*^9, 
   3.9581279746952744`*^9},ExpressionUUID->"a8528822-ba34-f644-a5d2-\
52caa67c895d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertIntTotalDerivativeFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"VertInt", "[", "vv_", "]"}], "[", 
     RowBox[{
      RowBox[{"totder_Symbol", "?", "TotalDerivativeQ"}], "[", "expr_", "]"}],
      "]"}], "]"}], "]"}], " ", ":=", 
  RowBox[{"totder", "[", 
   RowBox[{
    RowBox[{"VertInt", "[", "vv", "]"}], "[", "expr", "]"}], "]"}]}]], "Code",
 CellChangeTimes->{
  3.931835728973033*^9, 3.932387486329762*^9, 3.932522676264061*^9, {
   3.932626019999331*^9, 3.932626034738581*^9}, {3.932626081377493*^9, 
   3.932626082267186*^9}, {3.932638893821111*^9, 3.932638895463776*^9}, {
   3.932645138613037*^9, 3.932645138803996*^9}, {3.933685015119207*^9, 
   3.933685227805232*^9}, {3.9485429407857647`*^9, 3.948542962095869*^9}, 
   3.9490052132375417`*^9, {3.949005311233761*^9, 3.9490053494023*^9}, {
   3.949005395898487*^9, 3.949005397457689*^9}, 3.9490055422463646`*^9, {
   3.949055658689997*^9, 3.949055665412817*^9}, {3.9490560934569*^9, 
   3.9490561069699545`*^9}, {3.9490569435439568`*^9, 3.949056947994599*^9}, {
   3.949090085437219*^9, 3.949090085678877*^9}, {3.9512242588862896`*^9, 
   3.95122426841786*^9}, {3.9522577975545845`*^9, 3.9522578131325035`*^9}, 
   3.9534852061344624`*^9, 3.9577070407522755`*^9},
 CellLabel->
  "In[624]:=",ExpressionUUID->"d782a7be-55d7-d643-a258-6c513500ae3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntLieDFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835737378836*^9, 3.931835742082288*^9}, 
   3.948396833112151*^9, {3.948396920059084*^9, 3.948396931515546*^9}, {
   3.94839697117202*^9, 3.948396972112565*^9}, {3.948460721196004*^9, 
   3.9484607226915436`*^9}, {3.94905867840796*^9, 3.949058681063563*^9}, 
   3.9581279762243195`*^9},ExpressionUUID->"38820cc3-2652-5a48-9906-\
099f84b82701"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"\[DifferentialD]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["L", "V"], 
       RowBox[{"(", "exp", ")"}]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["L", 
       RowBox[{"\[DifferentialD]", "V"}]], 
      RowBox[{"(", "expr", ")"}]}], "+", 
     RowBox[{"L", 
      RowBox[{"(", 
       RowBox[{"\[DifferentialD]", "expr"}], ")"}]}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ExpandVertIntLieDFunction", "[", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{
      RowBox[{"VertInt", "[", "vv_", "]"}], "[", 
      RowBox[{
       RowBox[{"LieD", "[", "v_", "]"}], "[", "expr_", "]"}], "]"}], "]"}], 
    "]"}], " ", ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"LieD", "[", 
      RowBox[{
       RowBox[{"VertInt", "[", "vv", "]"}], "[", "v", "]"}], "]"}], "[", 
     "expr", "]"}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{
       RowBox[{"VertDeg", "[", 
        RowBox[{"VertInt", "[", "vv", "]"}], "]"}], 
       RowBox[{"VertDeg", "[", "v", "]"}]}]], 
     RowBox[{
      RowBox[{"LieD", "[", "v", "]"}], "[", 
      RowBox[{
       RowBox[{"VertInt", "[", "vv", "]"}], "[", "expr", "]"}], 
      "]"}]}]}]}]}]], "Code",
 CellChangeTimes->{
  3.9318357523003016`*^9, {3.932387499770298*^9, 3.932387502330002*^9}, 
   3.932522685898901*^9, {3.933774154898095*^9, 3.933774172848715*^9}, {
   3.933776429007101*^9, 3.933776436728996*^9}, {3.933776541520671*^9, 
   3.933776544776167*^9}, {3.933776786037992*^9, 3.9337768139746933`*^9}, {
   3.933779129553838*^9, 3.933779138100461*^9}, {3.948542955317256*^9, 
   3.948542963057881*^9}, {3.94900538278878*^9, 3.949005407216568*^9}, {
   3.949005526630316*^9, 3.949005591545766*^9}, {3.949007088150144*^9, 
   3.94900709491545*^9}, {3.94905617794096*^9, 3.949056179868331*^9}, {
   3.949090079311208*^9, 3.949090079684065*^9}, {3.951224269672102*^9, 
   3.951224269863346*^9}, 3.9577070423047256`*^9, 3.9577070762217026`*^9},
 CellLabel->
  "In[625]:=",ExpressionUUID->"dc30a4e9-937f-ab47-8127-af84643ce927"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntBracketFunction"
}], "Subsection",
 CellChangeTimes->{
  3.932387523129629*^9, 3.9483968319197803`*^9, {3.948396940397819*^9, 
   3.9483969677986946`*^9}, {3.9484607232970066`*^9, 
   3.9484607235127125`*^9}, {3.949058685030353*^9, 3.949058692129163*^9}, 
   3.9581279786782856`*^9},ExpressionUUID->"d411859c-601e-fd4c-8e20-\
a422db594c31"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandVertIntBracketFunction", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"VertInt", "[", "vv_", "]"}], "[", 
     RowBox[{
      RowBox[{"Bracket", "[", 
       RowBox[{"v1_", ",", " ", "v2_"}], "]"}], "[", "a_Symbol", "]"}], "]"}],
     "]"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Bracket", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"VertInt", "[", "vv", "]"}], "[", "v1", "]"}], ",", " ", 
      "v2"}], "]"}], "[", "a", "]"}], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"VertDeg", "[", 
       RowBox[{"VertInt", "[", "vv", "]"}], "]"}], 
      RowBox[{"VertDeg", "[", "v1", "]"}]}]], 
    RowBox[{
     RowBox[{"Bracket", "[", 
      RowBox[{"v1", ",", 
       RowBox[{
        RowBox[{"VertInt", "[", "vv", "]"}], "[", "v2", "]"}]}], "]"}], "[", 
     "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.9323875312001467`*^9, 3.932522696837884*^9, {3.933779360578002*^9, 
   3.933779395704607*^9}, {3.9337794445101647`*^9, 3.933779453582934*^9}, 
   3.933781502500701*^9, {3.948542979647881*^9, 3.948542987320108*^9}, {
   3.949005608148914*^9, 3.949005626655111*^9}, {3.949007091950952*^9, 
   3.949007105391709*^9}, {3.9490561813099184`*^9, 3.9490561902363234`*^9}, {
   3.949090082854098*^9, 3.949090083073985*^9}, {3.951224272801817*^9, 
   3.951224273312168*^9}, 3.957707078059622*^9, {3.958223253687889*^9, 
   3.958223255596237*^9}, {3.958223293870775*^9, 3.958223294071417*^9}, 
   3.958225428749424*^9, {3.958225615480404*^9, 3.9582256157617702`*^9}},
 CellLabel->
  "In[626]:=",ExpressionUUID->"d45af39f-45d5-ce46-a119-f9bbc428bb80"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ". Definition of variational vectors and variational vector fields (VVF)"
}], "Chapter",
 CellChangeTimes->{{3.9318353438923273`*^9, 3.93183534696952*^9}, {
  3.932636606099285*^9, 3.9326366080589304`*^9}, {3.948391736052903*^9, 
  3.9483917549598455`*^9}, {3.948392906134357*^9, 3.948392912502523*^9}, {
  3.9483954133854113`*^9, 3.948395418517416*^9}, {3.9483967382665772`*^9, 
  3.948396741045464*^9}, {3.949170308237555*^9, 3.949170324394554*^9}, {
  3.958648327697529*^9, 
  3.958648333804659*^9}},ExpressionUUID->"ea84133b-86aa-c84e-bfe8-\
1175ac52cfae"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Variational vector"
}], "Section",
 CellChangeTimes->{{3.931836256197623*^9, 3.931836260320031*^9}, {
   3.932387704652485*^9, 3.932387709519918*^9}, {3.9324705520206637`*^9, 
   3.9324705540925975`*^9}, {3.94839469638155*^9, 3.948394698688428*^9}, 
   3.9483961146362505`*^9, {3.948396210011439*^9, 3.948396217394292*^9}, {
   3.948396353046953*^9, 3.948396358876449*^9}, 3.948399643842359*^9, {
   3.949170328989889*^9, 3.9491703291660004`*^9}, 
   3.958648336917717*^9},ExpressionUUID->"ef0a4458-c520-2944-9d34-\
fd782ac9bf33"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VariationalVector Head"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400382213518*^9, 3.948400392834514*^9}, {3.9484640611681385`*^9, 
   3.948464062217304*^9}, {3.948911736577532*^9, 
   3.948911738678692*^9}},ExpressionUUID->"2adc56b3-a43f-e649-a191-\
ba29ea3d7493"],

Cell[BoxData[
 RowBox[{"DefInertHead", "[", 
  RowBox[{"VariationalVector", ",", 
   RowBox[{"LinearQ", "\[Rule]", "True"}], ",", 
   RowBox[{"ContractThrough", "\[Rule]", 
    RowBox[{"{", "delta", "}"}]}], ",", 
   RowBox[{
   "PrintAs", 
    "\[Rule]", "\"\<(\\!\\(\\*FractionBox[\\(\[Delta]\\), \\(\[Delta](\
\[CenterDot])\\)]\\))\>\""}], ",", 
   RowBox[{"DefInfo", "\[Rule]", "Null"}]}], "]"}]], "Code",
 CellChangeTimes->{{3.948910550541355*^9, 3.9489106159987335`*^9}, {
   3.948911983172207*^9, 3.9489120035243473`*^9}, {3.948912044738226*^9, 
   3.948912092601572*^9}, {3.9489123310209904`*^9, 3.948912353632733*^9}, 
   3.9489124965075817`*^9, {3.948912597119482*^9, 3.948912597540638*^9}},
 CellLabel->
  "In[627]:=",ExpressionUUID->"b2905fa4-2d15-f147-9311-eb6a515dd577"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VariationalVectorQ"
}], "Subsection",
 CellChangeTimes->{
  3.9323871707782125`*^9, 3.9329753373789573`*^9, 3.948390984477461*^9, {
   3.948913579151207*^9, 3.948913585489023*^9}, {3.948913623036436*^9, 
   3.9489136250133305`*^9}, 
   3.948913798301104*^9},ExpressionUUID->"69f6fde4-0eac-a644-bd78-\
0feaf777673d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "If", " ", "a", " ", "tensor", " ", "has", " ", "been", " ", "defined", " ",
     "as", " ", "a", " ", "variational", " ", "vector", " ", "and", " ", 
    "has", " ", "the", " ", "right", " ", "indices"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"VariationalVectorQ", "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "VariationalVectorQ"}], "[", "inds___", "]"}], 
     "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"SlotsOfTensor", "[", "tensor", "]"}], "===", 
      RowBox[{"xAct`xTensor`Private`SignedVBundleOfIndex", "/@", 
       RowBox[{"{", "inds", "}"}]}]}], ")"}]}], "\n", 
   RowBox[{
    RowBox[{"VariationalVectorQ", "[", "_", "]"}], ":=", "False"}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "VariationalVectorQ", "]"}], ";"}]}]}]], "Code",
 CellChangeTimes->{
  3.932387178717807*^9, 3.93252248945565*^9, 3.9326532861918*^9, {
   3.93271657285375*^9, 3.932716594941289*^9}, {3.9329749737864747`*^9, 
   3.932974988471778*^9}, {3.9329753763199363`*^9, 3.932975397705443*^9}, {
   3.93297544031653*^9, 3.932975444146983*^9}, {3.932999971260049*^9, 
   3.932999976850028*^9}, {3.948540937851342*^9, 3.9485409894160204`*^9}, {
   3.948541040139284*^9, 3.948541046845537*^9}, {3.948913590227448*^9, 
   3.948913644709268*^9}, {3.948913793988708*^9, 3.94891381695699*^9}, {
   3.948913919289385*^9, 3.948913927365095*^9}, {3.9489142198185196`*^9, 
   3.948914252581661*^9}, 3.950529421992937*^9, 3.9512249411640873`*^9, 
   3.957914476501381*^9},
 CellLabel->
  "In[628]:=",ExpressionUUID->"dc922cda-adfc-4e4f-9857-cc0bdab6110d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Definition of variational vector"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400382213518*^9, 3.948400392834514*^9}, {3.9484640611681385`*^9, 
   3.948464062217304*^9}, {3.9491703391567097`*^9, 
   3.949170339367491*^9}},ExpressionUUID->"6ea80b32-d434-1046-a54e-\
369e49a24176"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"DefVariationalVector", "[", "tensor", "]"}], " ", "defines", " ",
     "a", " ", "tensor", " ", "with", " ", "the", " ", "opposite", " ", 
    "indices", " ", "of", " ", "the", " ", 
    RowBox[{"tensor", ".", " ", "The"}], " ", "metric", " ", "is", " ", 
    "handled", " ", "separtely", " ", "as", " ", "the", " ", 
    "VariationalVector", " ", "of", " ", "the", " ", "inverse", " ", "needs", 
    " ", "to", " ", "be", " ", "defined"}], " ", "*)"}], " ", "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "DefVariationalVector", "]"}], ":=", " ", 
    RowBox[{"Options", "[", "DefExactVerticalForm", "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"DefVariationalVector", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"tensor_Symbol", "?", "xTensorQ"}], "[", "inds___", "]"}], ",",
       "dependencies_", ",", "sym_", ",", 
      RowBox[{"options", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"Options", "[", "DefVariationalVector", "]"}], "]"}]}]}], 
     "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", "\n", "\t", 
     RowBox[{
      RowBox[{"{", "\n", "\t", 
       RowBox[{
        RowBox[{"opts", "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"WeightOfTensor", "->", 
             RowBox[{"-", 
              RowBox[{"WeightOfTensor", "[", "tensor", "]"}]}]}], ",", 
            RowBox[{"VertDeg", "->", 
             RowBox[{"-", 
              RowBox[{"VertDeg", "[", 
               RowBox[{"tensor", "[", "inds", "]"}], "]"}]}]}]}], "}"}], "~", 
          "Join", "~", 
          RowBox[{"{", "options", "}"}]}]}], ",", "\n", "\t", 
        RowBox[{"nameVar", "=", 
         RowBox[{"GenerateVariationalName", "[", 
          RowBox[{"tensor", ",", 
           RowBox[{"FilterRules", "[", 
            RowBox[{
             RowBox[{"{", "options", "}"}], ",", 
             RowBox[{"Options", "[", "GenerateDiffName", "]"}]}], "]"}]}], 
          "]"}]}], ",", "\n", "    ", 
        RowBox[{"flippedindices", " ", "=", " ", 
         RowBox[{
          RowBox[{"-", "1"}], "*", 
          RowBox[{"{", "inds", "}"}]}]}]}], "\n", "    ", "}"}], ",", "\n", 
      "        ", "\n", "    ", 
      RowBox[{
       RowBox[{"MakexTensions", "[", 
        RowBox[{"DefVariationalVector", ",", "\"\<Beginning\>\"", ",", 
         RowBox[{"tensor", "[", "inds", "]"}], ",", "dependencies", ",", 
         "sym", ",", "options"}], "]"}], ";", " ", "\n", "\t", 
       RowBox[{"opts", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"xAct`xTensor`Private`ImplodedQ", "[", "tensor", "]"}], ",", 
          RowBox[{"opts", "~", "Join", "~", 
           RowBox[{"{", 
            RowBox[{"DefInfo", "\[RuleDelayed]", 
             RowBox[{"If", "[", 
              RowBox[{"$ImplodeInfoQ", ",", 
               RowBox[{"{", 
                RowBox[{"\"\<tensor\>\"", ",", "\"\<\>\""}], "}"}], ",", 
               "False"}], "]"}]}], "}"}]}], ",", "opts"}], "]"}]}], ";", "\n",
        "    ", "\n", "    ", 
       RowBox[{"Unprotect", "[", "VariationalVector", "]"}], ";", "\n", 
       "    ", "\n", "    ", 
       RowBox[{
        RowBox[{"VariationalVectorQ", "[", 
         RowBox[{"ToExpression", "[", 
          RowBox[{"nameVar", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
        "True"}], ";", "\n", "    ", 
       RowBox[{
        RowBox[{"MasterOfCPSTensor", "[", 
         RowBox[{"ToExpression", "[", 
          RowBox[{"nameVar", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "^=", "tensor"}], ";",
        "\n", "       ", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"StringEndsQ", "[", 
           RowBox[{
            RowBox[{"ToString", "@", "tensor"}], ",", "\"\<\[Dagger]\>\""}], 
           "]"}]}], ",", "\n", "        ", 
         RowBox[{
          RowBox[{"DefTensor", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"nameVar", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "@@", " ", 
             "flippedindices"}], ",", " ", "dependencies", ",", " ", "sym", ",",
             " ", 
            RowBox[{"PrintAs", " ", "->", " ", 
             RowBox[{"nameVar", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{"FilterRules", "[", 
             RowBox[{"opts", ",", 
              RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", 
            RowBox[{
            "DefineExactFormAfterDefTensor", " ", "->", " ", "False"}], ",", 
            RowBox[{
            "DefineVariationalVectorAfterDefTensor", "->", "False"}]}], "]"}],
           ";"}]}], "\n", "        ", "]"}], ";", "\n", "        ", "\n", 
       "\t", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"OptionValue", "[", "PrintInverse", "]"}], ",", "\n", 
         "\t    ", 
         RowBox[{"(", "\n", "\t    ", 
          RowBox[{
           RowBox[{
            RowBox[{"VariationalVector", "[", 
             RowBox[{"ToExpression", "[", 
              RowBox[{"\"\<Inv\>\"", "<>", 
               RowBox[{"ToString", "[", "tensor", "]"}]}], "]"}], "]"}], "=", 
            " ", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"nameVar", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", "\t    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"DaggerQ", "[", "tensor", "]"}], ",", "\n", "\t\t\t", 
             RowBox[{
              RowBox[{
               RowBox[{"VariationalVector", "[", 
                RowBox[{"ToExpression", "[", 
                 RowBox[{"\"\<Inv\>\"", "<>", 
                  RowBox[{"ToString", "[", "tensor", "]"}], 
                  "<>", "\"\<\[Dagger]\>\""}], "]"}], "]"}], "=", 
               RowBox[{"Dagger", "@", 
                RowBox[{"ToExpression", "[", 
                 RowBox[{"nameVar", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ";", "\n", 
              "\t\t\t", 
              RowBox[{
               RowBox[{"VariationalVectorQ", "[", 
                RowBox[{"Dagger", "@", 
                 RowBox[{"ToExpression", "[", 
                  RowBox[{"nameVar", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}], "^=", 
               "True"}], ";"}]}], "\n", "\t\t", "]"}], ";"}], "\n", "\t    ", 
          ")"}], ",", "\n", "\t\t", 
         RowBox[{"(", "\n", "\t\t", 
          RowBox[{
           RowBox[{
            RowBox[{"VariationalVector", "[", "tensor", "]"}], " ", "^=", " ", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"nameVar", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", "\t\t", 
           RowBox[{
            RowBox[{"PrintAs", "[", 
             RowBox[{"Evaluate", "[", 
              RowBox[{"ToExpression", "[", 
               RowBox[{"VariationalVector", "[", "tensor", "]"}], "]"}], 
              "]"}], "]"}], "^=", 
            RowBox[{"nameVar", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";"}], 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
            "This", " ", "prevents", " ", "the", " ", "densities", " ", "to", 
             " ", "have", " ", "two", " ", "sets", " ", "of", " ", "tildes"}],
             ",", " ", 
            RowBox[{
            "only", " ", "the", " ", "ones", " ", "coming", " ", "from", " ", 
             "the", " ", "tensor", " ", "remained"}]}], " ", "*)"}], " ", 
          "\n", "\t\t", ")"}]}], "\n", "    ", "]"}], ";", "\n", "\n", 
       "          ", "\n", "    ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Establish", " ", "relationships", " ", "between", " ", "the", " ", 
         "exact", " ", "tensor", " ", "and", " ", "the", " ", "original", " ",
          "tensor"}], " ", "*)"}], "\n", "    ", 
       RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
        RowBox[{
         RowBox[{"ToExpression", "[", 
          RowBox[{"nameVar", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "tensor", ",", 
         RowBox[{"{", "tensor", "}"}]}], "]"}], ";", "\n", "\t", "\n", "    ", 
       RowBox[{"$printAddVariationalRelation", "=", "False"}], ";", "\n", 
       "    ", 
       RowBox[{"AddVariationalRelation", "[", 
        RowBox[{"tensor", " ", "->", " ", 
         RowBox[{"ToExpression", "[", 
          RowBox[{"nameVar", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}], ";", "\n", "    ", 
       RowBox[{"$printAddVariationalRelation", "=", "True"}], ";", "\n", 
       "    ", "\n", "    ", 
       RowBox[{"Protect", "[", "VariationalVector", "]"}], ";", "\n", "    ", 
       "\n", "    ", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{"DefVariationalVector", ",", "\"\<End\>\"", ",", 
         RowBox[{"tensor", "[", "inds", "]"}], ",", "dependencies", ",", 
         "sym", ",", "options"}], "]"}], ";"}]}], "\n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.933406921174345*^9, 3.933407006640181*^9}, {
   3.93340771717714*^9, 3.933407771524101*^9}, {3.933407842889041*^9, 
   3.93340784593215*^9}, {3.9334078825734615`*^9, 3.9334079049310675`*^9}, {
   3.9334080926353464`*^9, 3.933408122023637*^9}, {3.933408160283249*^9, 
   3.9334081613326297`*^9}, {3.933408447319936*^9, 3.93340851503378*^9}, {
   3.933408882271353*^9, 3.933408956675268*^9}, {3.933408995312349*^9, 
   3.9334091265815077`*^9}, {3.933409440623533*^9, 3.933409490059602*^9}, {
   3.933409545667935*^9, 3.933409559526745*^9}, {3.933409624818842*^9, 
   3.93340968019966*^9}, {3.933409723362918*^9, 3.933409797572757*^9}, {
   3.933409841995154*^9, 3.933409903386168*^9}, {3.933410016236034*^9, 
   3.9334100170103254`*^9}, {3.9334100531015844`*^9, 
   3.9334101535947943`*^9}, {3.933410213453788*^9, 3.9334102938915176`*^9}, {
   3.933410670619817*^9, 3.933410671122767*^9}, {3.933411456200949*^9, 
   3.933411475574125*^9}, {3.9373053795156136`*^9, 3.9373053795797997`*^9}, {
   3.937306157878441*^9, 3.937306158292214*^9}, {3.937306269018829*^9, 
   3.937306280620297*^9}, {3.937362968152558*^9, 3.937363066875798*^9}, {
   3.9373635762592773`*^9, 3.9373635793472366`*^9}, {3.9373637019161606`*^9, 
   3.9373637019948044`*^9}, {3.937364029159052*^9, 3.937364074760332*^9}, {
   3.937364160565178*^9, 3.9373642237654514`*^9}, {3.937364626859802*^9, 
   3.9373646290816097`*^9}, {3.937364804658905*^9, 3.9373648143460846`*^9}, 
   3.9373650753211765`*^9, {3.937365160977658*^9, 3.937365161177868*^9}, {
   3.93736524282288*^9, 3.9373652518743896`*^9}, 3.937366133935508*^9, {
   3.937366464171404*^9, 3.937366465559313*^9}, {3.937366714972174*^9, 
   3.93736683314686*^9}, {3.9373668696511135`*^9, 3.9373668738567257`*^9}, 
   3.937367152464058*^9, {3.937381458278471*^9, 3.937381460322121*^9}, {
   3.937382179729217*^9, 3.9373821871093655`*^9}, {3.937382272833767*^9, 
   3.93738227918374*^9}, {3.9373829827542133`*^9, 3.9373830044843655`*^9}, {
   3.937383112477118*^9, 3.937383128406254*^9}, {3.937383895232533*^9, 
   3.937383895848821*^9}, {3.937383979975384*^9, 3.937383992360611*^9}, {
   3.937384052760938*^9, 3.93738405848674*^9}, {3.937384221115248*^9, 
   3.937384260528507*^9}, {3.937384391670376*^9, 3.937384404020799*^9}, {
   3.937384497745165*^9, 3.937384501494868*^9}, {3.93738464225375*^9, 
   3.937384650017959*^9}, 3.938528850420394*^9, {3.938529030271578*^9, 
   3.938529042232601*^9}, {3.93852907865707*^9, 3.938529094223398*^9}, {
   3.938529145716605*^9, 3.9385291704070425`*^9}, {3.938529256747004*^9, 
   3.938529280811816*^9}, {3.938529321822528*^9, 3.9385294680946264`*^9}, {
   3.938529564637632*^9, 3.9385296067599936`*^9}, {3.938529850742167*^9, 
   3.9385298660436287`*^9}, {3.938582918775227*^9, 3.938582930285669*^9}, {
   3.938594715950249*^9, 3.938594736281033*^9}, {3.938594788648814*^9, 
   3.938594789458813*^9}, {3.938596500086594*^9, 3.938596500091591*^9}, 
   3.938679596908964*^9, {3.9386796499477134`*^9, 3.938679660829779*^9}, {
   3.9386797045233345`*^9, 3.938679842763437*^9}, {3.938679924888153*^9, 
   3.938679932976369*^9}, {3.93867997252408*^9, 3.938680058911319*^9}, {
   3.938680098264307*^9, 3.938680121079299*^9}, {3.9386801709920273`*^9, 
   3.938680199147262*^9}, {3.941629361792519*^9, 3.941629382579403*^9}, {
   3.941631155549241*^9, 3.941631168407516*^9}, {3.941631294551567*^9, 
   3.941631296763277*^9}, {3.9416340220557013`*^9, 3.9416340268606615`*^9}, {
   3.941634115960855*^9, 3.941634150923091*^9}, {3.941649990721203*^9, 
   3.9416500070426826`*^9}, {3.944276817550635*^9, 3.944276863982127*^9}, {
   3.944277097594197*^9, 3.944277099630007*^9}, {3.944277131777954*^9, 
   3.944277136002495*^9}, {3.9442779222103453`*^9, 3.944277926011027*^9}, {
   3.948400213696924*^9, 3.9484002389988995`*^9}, {3.948544995822412*^9, 
   3.9485450766366043`*^9}, {3.948545415731119*^9, 3.948545436275989*^9}, {
   3.948561574418477*^9, 3.94856157551278*^9}, {3.948911702624031*^9, 
   3.9489117054498653`*^9}, {3.9489128784257298`*^9, 3.948912895855831*^9}, {
   3.9489131642818203`*^9, 3.948913167584549*^9}, 3.948913791353824*^9, {
   3.948914236124546*^9, 3.94891423626228*^9}, {3.949167742007576*^9, 
   3.949167752060467*^9}, {3.949167831067356*^9, 3.9491678315811596`*^9}, {
   3.949168415701826*^9, 3.949168486193968*^9}, {3.949168601901099*^9, 
   3.9491686080862904`*^9}, {3.9491731744043674`*^9, 3.949173174656637*^9}, {
   3.949173318272003*^9, 3.9491733881202736`*^9}, 3.9493481088564305`*^9, {
   3.949515733119776*^9, 3.9495157375996857`*^9}, {3.950124003524918*^9, 
   3.950124017730396*^9}, {3.950284700456896*^9, 3.950284756956906*^9}, {
   3.950284825621414*^9, 3.95028484735746*^9}, {3.950284905158785*^9, 
   3.950284942963383*^9}, {3.9502849842260075`*^9, 3.950285035620806*^9}, {
   3.950285125301064*^9, 3.950285148418938*^9}, {3.950285187538789*^9, 
   3.950285254179893*^9}, {3.950285310329048*^9, 3.9502854090233727`*^9}, {
   3.950285496855503*^9, 3.950285523088554*^9}, {3.9502855999913673`*^9, 
   3.950285613742403*^9}, {3.950285645467645*^9, 3.95028567834717*^9}, {
   3.950285956496371*^9, 3.950285987080471*^9}, 3.9502860301665325`*^9, {
   3.9502863444280663`*^9, 3.9502863724001083`*^9}, {3.950286446430664*^9, 
   3.9502865157236023`*^9}, {3.9502865772245274`*^9, 3.950286585334236*^9}, {
   3.950286718679405*^9, 3.950286755746117*^9}, 3.950287008544659*^9, {
   3.95028716376013*^9, 3.950287166501812*^9}, {3.950287233027176*^9, 
   3.950287234361564*^9}, {3.9502873280139465`*^9, 3.9502873290926304`*^9}, 
   3.950287359280592*^9, 3.9502874261965637`*^9, {3.950287734161017*^9, 
   3.950287764207033*^9}, {3.950288274908495*^9, 3.950288308699247*^9}, {
   3.950288387475679*^9, 3.95028839619329*^9}, {3.950289092322672*^9, 
   3.9502892219454*^9}, 3.950289259735361*^9, {3.9502893150156517`*^9, 
   3.9502893265394726`*^9}, {3.950289356657509*^9, 3.9502894130269127`*^9}, {
   3.950289599208252*^9, 3.9502896641101303`*^9}, 3.950289787356674*^9, {
   3.950290059341688*^9, 3.950290120317436*^9}, {3.950294685128439*^9, 
   3.95029472592894*^9}, {3.950294832495619*^9, 3.950294862585589*^9}, {
   3.950294938361325*^9, 3.950294945539091*^9}, {3.9502950702265224`*^9, 
   3.9502950784210835`*^9}, {3.950295285259487*^9, 3.950295287827811*^9}, 
   3.950295339321804*^9, {3.950295371230142*^9, 3.9502954311813335`*^9}, 
   3.950295494745037*^9, {3.950295615632918*^9, 3.950295624959718*^9}, {
   3.950297386075203*^9, 3.950297436332136*^9}, {3.950297477358675*^9, 
   3.9502975636404247`*^9}, {3.9502976564101357`*^9, 3.950297662636419*^9}, 
   3.9502991139286327`*^9, {3.951224293688961*^9, 3.951224397669229*^9}, {
   3.951309164139301*^9, 3.95130919024996*^9}, {3.954941273808172*^9, 
   3.9549412992345657`*^9}, {3.9549424878882523`*^9, 3.954942502495722*^9}, {
   3.9550955241050587`*^9, 3.955095530906025*^9}, {3.9551202951840153`*^9, 
   3.9551202991293755`*^9}, 3.9551231099541664`*^9, {3.9551250698491783`*^9, 
   3.9551250836562157`*^9}, {3.9551251910534573`*^9, 3.955125227344343*^9}, {
   3.9551252606372185`*^9, 3.9551252951318665`*^9}, {3.955125566306019*^9, 
   3.9551255666478024`*^9}, {3.955125785153406*^9, 3.9551257934579144`*^9}, {
   3.9552023640702686`*^9, 3.955202386378977*^9}, {3.9552025605017834`*^9, 
   3.9552025734718857`*^9}, {3.9552027516272717`*^9, 3.955202775688017*^9}, {
   3.9552046813476276`*^9, 3.9552047270457134`*^9}, {3.9552048725942726`*^9, 
   3.955204874098255*^9}, {3.9552049812753735`*^9, 3.955204999850292*^9}, {
   3.955205118923311*^9, 3.955205128322521*^9}, 3.9552054090935993`*^9, {
   3.9552057368385506`*^9, 3.9552057791278057`*^9}, {3.9552058467302513`*^9, 
   3.9552058563251095`*^9}, {3.9552059176741447`*^9, 
   3.9552059289503098`*^9}, {3.95520598966263*^9, 3.95520602547036*^9}, {
   3.9552060871630955`*^9, 3.95520608899139*^9}, {3.9552061416724854`*^9, 
   3.9552061464953384`*^9}, 3.955206182573513*^9, {3.9552063767825165`*^9, 
   3.955206398877365*^9}, {3.955206468638525*^9, 3.9552064740265102`*^9}, {
   3.9552066515653954`*^9, 3.9552066614091816`*^9}, {3.955207153359255*^9, 
   3.9552071658046494`*^9}, {3.955207339828703*^9, 3.9552073797555065`*^9}, {
   3.9552075048559456`*^9, 3.955207545604061*^9}, {3.9553641785464153`*^9, 
   3.9553642240436134`*^9}, {3.955365053876444*^9, 3.9553650652663517`*^9}, {
   3.9553654816019154`*^9, 3.955365484129984*^9}, {3.9553656401296024`*^9, 
   3.955365647007347*^9}, {3.9553656893396854`*^9, 3.9553657426784325`*^9}, {
   3.9553657974486485`*^9, 3.955365822720995*^9}, {3.955365893627527*^9, 
   3.9553659368148346`*^9}, {3.9572707229489307`*^9, 3.95727072586969*^9}, {
   3.957270825288248*^9, 3.9572708336709175`*^9}, {3.9572710839707947`*^9, 
   3.957271085882904*^9}, {3.957273278302223*^9, 3.957273279896574*^9}, {
   3.957274230024744*^9, 3.957274232254547*^9}, {3.9572750382281857`*^9, 
   3.9572751228681545`*^9}, {3.9572753714637833`*^9, 
   3.9572753882269783`*^9}, {3.957278559066141*^9, 3.9572785706557655`*^9}, {
   3.957279523255663*^9, 3.957279563502611*^9}, {3.9572795990920486`*^9, 
   3.95727959995063*^9}, {3.9572895943400726`*^9, 3.9572896055514565`*^9}, 
   3.957289735213743*^9, {3.95729131317618*^9, 3.957291323968788*^9}, {
   3.9572914003940105`*^9, 3.957291401559084*^9}, {3.9572919509209824`*^9, 
   3.957291960398878*^9}, 3.957292035514124*^9, {3.957292331593878*^9, 
   3.9572923413760967`*^9}, {3.9572924814530697`*^9, 
   3.9572924823801346`*^9}, {3.957293328816393*^9, 3.9572933842872715`*^9}, {
   3.9572956663808136`*^9, 3.9572956744941635`*^9}, {3.9572959414587*^9, 
   3.9572959947751102`*^9}, 3.957296032947542*^9, {3.95729610890551*^9, 
   3.9572961497080975`*^9}, {3.957296230985756*^9, 3.9572962317729263`*^9}, {
   3.957296279484064*^9, 3.9572962813294334`*^9}, {3.9572963252500305`*^9, 
   3.957296348245571*^9}, {3.957296411841503*^9, 3.95729641199255*^9}, {
   3.957296512027937*^9, 3.957296528441334*^9}, {3.957296711661886*^9, 
   3.957296756945692*^9}, {3.9572968213072624`*^9, 3.9572968367610073`*^9}, {
   3.9572968963255672`*^9, 3.9572969617140293`*^9}, {3.957297289936407*^9, 
   3.9572972934500217`*^9}, {3.957297347917858*^9, 3.957297367102377*^9}, {
   3.957297439571808*^9, 3.9572974769009476`*^9}, {3.957298621146021*^9, 
   3.957298641236416*^9}, {3.957298983912489*^9, 3.9572990108841953`*^9}, {
   3.957299233802397*^9, 3.957299263656744*^9}, {3.9572995152834015`*^9, 
   3.9572995157361317`*^9}, {3.9573136817173824`*^9, 
   3.9573137277981033`*^9}, {3.9573138076110916`*^9, 
   3.9573138163961697`*^9}, {3.9573139433743553`*^9, 
   3.9573139799411964`*^9}, {3.9573140249844875`*^9, 
   3.9573140542303696`*^9}, {3.9573155452465*^9, 3.9573155877887783`*^9}, {
   3.9573272080717926`*^9, 3.957327222653549*^9}, {3.9573293005746193`*^9, 
   3.9573293055702057`*^9}, {3.9573293493659916`*^9, 
   3.9573293569366016`*^9}, {3.9573295918822155`*^9, 3.957329593080124*^9}, {
   3.9573881904271183`*^9, 3.9573881912939816`*^9}, {3.957389869154297*^9, 
   3.95738988895203*^9}, 3.9573903876529255`*^9, {3.9575436908401737`*^9, 
   3.957543760584757*^9}, {3.957909610005848*^9, 3.957909620988735*^9}, 
   3.9579112506300507`*^9, {3.957969502570755*^9, 3.9579695122067165`*^9}, {
   3.9579706185822678`*^9, 3.9579706256692944`*^9}, {3.958563126882105*^9, 
   3.958563170597193*^9}, {3.9585664990124054`*^9, 3.958566516402746*^9}, {
   3.958566735538624*^9, 3.9585667364068985`*^9}, {3.9605325482611485`*^9, 
   3.960532605916157*^9}, {3.960547142200323*^9, 
   3.9605471565777836`*^9}},ExpressionUUID->"998ff26a-31b3-bc47-8d7c-\
6dfb8ec0a2d4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". PartialPartialQ"
}], "Subsection",
 CellChangeTimes->{
  3.9323871707782125`*^9, 3.9329753373789573`*^9, 3.948390984477461*^9, {
   3.948913579151207*^9, 3.948913585489023*^9}, {3.948913623036436*^9, 
   3.9489136250133305`*^9}, 3.948913798301104*^9, {3.95520988059758*^9, 
   3.955209900252735*^9}},ExpressionUUID->"462cdc57-fe33-2249-b784-\
3c71ccbeccff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "If", " ", "a", " ", "tensor", " ", "has", " ", "been", " ", "defined", " ",
     "as", " ", "a", " ", "variational", " ", "vector", " ", "and", " ", 
    "has", " ", "the", " ", "right", " ", "indices"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"PartialPartialQ", "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "PartialPartialQ"}], "[", "inds___", "]"}], 
     "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"SlotsOfTensor", "[", "tensor", "]"}], "===", 
      RowBox[{"xAct`xTensor`Private`SignedVBundleOfIndex", "/@", 
       RowBox[{"{", "inds", "}"}]}]}], ")"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PartialPartialQ", "[", "_", "]"}], ":=", "False"}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "PartialPartialQ", "]"}], ";"}]}]}]], "Code",
 CellChangeTimes->{
  3.932387178717807*^9, 3.93252248945565*^9, 3.9326532861918*^9, {
   3.93271657285375*^9, 3.932716594941289*^9}, {3.9329749737864747`*^9, 
   3.932974988471778*^9}, {3.9329753763199363`*^9, 3.932975397705443*^9}, {
   3.93297544031653*^9, 3.932975444146983*^9}, {3.932999971260049*^9, 
   3.932999976850028*^9}, {3.948540937851342*^9, 3.9485409894160204`*^9}, {
   3.948541040139284*^9, 3.948541046845537*^9}, {3.948913590227448*^9, 
   3.948913644709268*^9}, {3.948913793988708*^9, 3.94891381695699*^9}, {
   3.948913919289385*^9, 3.948913927365095*^9}, {3.9489142198185196`*^9, 
   3.948914252581661*^9}, 3.950529421992937*^9, 3.9512249411640873`*^9, {
   3.9552099057622147`*^9, 3.95520991189637*^9}, 3.9557086975182667`*^9},
 CellLabel->
  "In[633]:=",ExpressionUUID->"35a8430f-fa4d-ff40-997c-7d8ba03b6cb3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Definition of PartialPartial"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400382213518*^9, 3.948400392834514*^9}, {3.9484640611681385`*^9, 
   3.948464062217304*^9}, {3.9491703391567097`*^9, 3.949170339367491*^9}, {
   3.9552081378514423`*^9, 3.955208140137203*^9}, {3.955209890081299*^9, 
   3.955209895800684*^9}},ExpressionUUID->"dd45d412-7154-5540-b721-\
e99ea5698bc7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"DefPartialPartial", "[", "tensor", "]"}], " ", "defines", " ", 
    "a", " ", "tensor", " ", "with", " ", "the", " ", "opposite", " ", 
    "indices", " ", "of", " ", "the", " ", 
    RowBox[{"tensor", ".", " ", "The"}], " ", "metric", " ", "is", " ", 
    "handled", " ", "separtely", " ", "as", " ", "the", " ", "PartialPartial",
     " ", "of", " ", "the", " ", "inverse", " ", "needs", " ", "to", " ", 
    "be", " ", "defined"}], " ", "*)"}], " ", "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"IndexRanges", "[", 
     RowBox[{"list", ":", 
      RowBox[{"{", 
       RowBox[{"_List", ".."}], "}"}]}], "]"}], ":=", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "pair", "}"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"pair", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"pair", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"pair", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "-", "1"}]}], "]"}]}], "]"}], ",",
       "list"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"applyShifts", "[", 
     RowBox[{"zs_List", ",", "shifts_List"}], "]"}], ":=", 
    RowBox[{"MapThread", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"x_", "?", "IntegerQ"}], "/;", 
           RowBox[{"x", ">", "0"}]}], ":>", 
          RowBox[{"x", "+", "#2"}]}], "}"}]}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"zs", ",", "shifts"}], "}"}]}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"JoinGenSet", "[", "list_", "]"}], ":=", 
    RowBox[{
     RowBox[{"list", "/.", 
      RowBox[{"{", 
       RowBox[{"GenSet", "->", "List"}], "}"}]}], "//", "Flatten"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"GenerateCycles", "[", 
     RowBox[{"{", 
      RowBox[{"firstlist_List", ",", "rest__"}], "}"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"Inner", "[", 
       RowBox[{"List", ",", "firstlist", ",", "#", ",", "Cycles"}], "]"}], 
      "&"}], "/@", 
     RowBox[{"{", "rest", "}"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.933406921174345*^9, 3.933407006640181*^9}, {
   3.93340771717714*^9, 3.933407771524101*^9}, {3.933407842889041*^9, 
   3.93340784593215*^9}, {3.9334078825734615`*^9, 3.9334079049310675`*^9}, {
   3.9334080926353464`*^9, 3.933408122023637*^9}, {3.933408160283249*^9, 
   3.9334081613326297`*^9}, {3.933408447319936*^9, 3.93340851503378*^9}, {
   3.933408882271353*^9, 3.933408956675268*^9}, {3.933408995312349*^9, 
   3.9334091265815077`*^9}, {3.933409440623533*^9, 3.933409490059602*^9}, {
   3.933409545667935*^9, 3.933409559526745*^9}, {3.933409624818842*^9, 
   3.93340968019966*^9}, {3.933409723362918*^9, 3.933409797572757*^9}, {
   3.933409841995154*^9, 3.933409903386168*^9}, {3.933410016236034*^9, 
   3.9334100170103254`*^9}, {3.9334100531015844`*^9, 
   3.9334101535947943`*^9}, {3.933410213453788*^9, 3.9334102938915176`*^9}, {
   3.933410670619817*^9, 3.933410671122767*^9}, {3.933411456200949*^9, 
   3.933411475574125*^9}, {3.9373053795156136`*^9, 3.9373053795797997`*^9}, {
   3.937306157878441*^9, 3.937306158292214*^9}, {3.937306269018829*^9, 
   3.937306280620297*^9}, {3.937362968152558*^9, 3.937363066875798*^9}, {
   3.9373635762592773`*^9, 3.9373635793472366`*^9}, {3.9373637019161606`*^9, 
   3.9373637019948044`*^9}, {3.937364029159052*^9, 3.937364074760332*^9}, {
   3.937364160565178*^9, 3.9373642237654514`*^9}, {3.937364626859802*^9, 
   3.9373646290816097`*^9}, {3.937364804658905*^9, 3.9373648143460846`*^9}, 
   3.9373650753211765`*^9, {3.937365160977658*^9, 3.937365161177868*^9}, {
   3.93736524282288*^9, 3.9373652518743896`*^9}, 3.937366133935508*^9, {
   3.937366464171404*^9, 3.937366465559313*^9}, {3.937366714972174*^9, 
   3.93736683314686*^9}, {3.9373668696511135`*^9, 3.9373668738567257`*^9}, 
   3.937367152464058*^9, {3.937381458278471*^9, 3.937381460322121*^9}, {
   3.937382179729217*^9, 3.9373821871093655`*^9}, {3.937382272833767*^9, 
   3.93738227918374*^9}, {3.9373829827542133`*^9, 3.9373830044843655`*^9}, {
   3.937383112477118*^9, 3.937383128406254*^9}, {3.937383895232533*^9, 
   3.937383895848821*^9}, {3.937383979975384*^9, 3.937383992360611*^9}, {
   3.937384052760938*^9, 3.93738405848674*^9}, {3.937384221115248*^9, 
   3.937384260528507*^9}, {3.937384391670376*^9, 3.937384404020799*^9}, {
   3.937384497745165*^9, 3.937384501494868*^9}, {3.93738464225375*^9, 
   3.937384650017959*^9}, 3.938528850420394*^9, {3.938529030271578*^9, 
   3.938529042232601*^9}, {3.93852907865707*^9, 3.938529094223398*^9}, {
   3.938529145716605*^9, 3.9385291704070425`*^9}, {3.938529256747004*^9, 
   3.938529280811816*^9}, {3.938529321822528*^9, 3.9385294680946264`*^9}, {
   3.938529564637632*^9, 3.9385296067599936`*^9}, {3.938529850742167*^9, 
   3.9385298660436287`*^9}, {3.938582918775227*^9, 3.938582930285669*^9}, {
   3.938594715950249*^9, 3.938594736281033*^9}, {3.938594788648814*^9, 
   3.938594789458813*^9}, {3.938596500086594*^9, 3.938596500091591*^9}, 
   3.938679596908964*^9, {3.9386796499477134`*^9, 3.938679660829779*^9}, {
   3.9386797045233345`*^9, 3.938679842763437*^9}, {3.938679924888153*^9, 
   3.938679932976369*^9}, {3.93867997252408*^9, 3.938680058911319*^9}, {
   3.938680098264307*^9, 3.938680121079299*^9}, {3.9386801709920273`*^9, 
   3.938680199147262*^9}, {3.941629361792519*^9, 3.941629382579403*^9}, {
   3.941631155549241*^9, 3.941631168407516*^9}, {3.941631294551567*^9, 
   3.941631296763277*^9}, {3.9416340220557013`*^9, 3.9416340268606615`*^9}, {
   3.941634115960855*^9, 3.941634150923091*^9}, {3.941649990721203*^9, 
   3.9416500070426826`*^9}, {3.944276817550635*^9, 3.944276863982127*^9}, {
   3.944277097594197*^9, 3.944277099630007*^9}, {3.944277131777954*^9, 
   3.944277136002495*^9}, {3.9442779222103453`*^9, 3.944277926011027*^9}, {
   3.948400213696924*^9, 3.9484002389988995`*^9}, {3.948544995822412*^9, 
   3.9485450766366043`*^9}, {3.948545415731119*^9, 3.948545436275989*^9}, {
   3.948561574418477*^9, 3.94856157551278*^9}, {3.948911702624031*^9, 
   3.9489117054498653`*^9}, {3.9489128784257298`*^9, 3.948912895855831*^9}, {
   3.9489131642818203`*^9, 3.948913167584549*^9}, 3.948913791353824*^9, {
   3.948914236124546*^9, 3.94891423626228*^9}, {3.949167742007576*^9, 
   3.949167752060467*^9}, {3.949167831067356*^9, 3.9491678315811596`*^9}, {
   3.949168415701826*^9, 3.949168486193968*^9}, {3.949168601901099*^9, 
   3.9491686080862904`*^9}, {3.9491731744043674`*^9, 3.949173174656637*^9}, {
   3.949173318272003*^9, 3.9491733881202736`*^9}, 3.9493481088564305`*^9, {
   3.949515733119776*^9, 3.9495157375996857`*^9}, {3.950124003524918*^9, 
   3.950124017730396*^9}, {3.950284700456896*^9, 3.950284756956906*^9}, {
   3.950284825621414*^9, 3.95028484735746*^9}, {3.950284905158785*^9, 
   3.950284942963383*^9}, {3.9502849842260075`*^9, 3.950285035620806*^9}, {
   3.950285125301064*^9, 3.950285148418938*^9}, {3.950285187538789*^9, 
   3.950285254179893*^9}, {3.950285310329048*^9, 3.9502854090233727`*^9}, {
   3.950285496855503*^9, 3.950285523088554*^9}, {3.9502855999913673`*^9, 
   3.950285613742403*^9}, {3.950285645467645*^9, 3.95028567834717*^9}, {
   3.950285956496371*^9, 3.950285987080471*^9}, 3.9502860301665325`*^9, {
   3.9502863444280663`*^9, 3.9502863724001083`*^9}, {3.950286446430664*^9, 
   3.9502865157236023`*^9}, {3.9502865772245274`*^9, 3.950286585334236*^9}, {
   3.950286718679405*^9, 3.950286755746117*^9}, 3.950287008544659*^9, {
   3.95028716376013*^9, 3.950287166501812*^9}, {3.950287233027176*^9, 
   3.950287234361564*^9}, {3.9502873280139465`*^9, 3.9502873290926304`*^9}, 
   3.950287359280592*^9, 3.9502874261965637`*^9, {3.950287734161017*^9, 
   3.950287764207033*^9}, {3.950288274908495*^9, 3.950288308699247*^9}, {
   3.950288387475679*^9, 3.95028839619329*^9}, {3.950289092322672*^9, 
   3.9502892219454*^9}, 3.950289259735361*^9, {3.9502893150156517`*^9, 
   3.9502893265394726`*^9}, {3.950289356657509*^9, 3.9502894130269127`*^9}, {
   3.950289599208252*^9, 3.9502896641101303`*^9}, 3.950289787356674*^9, {
   3.950290059341688*^9, 3.950290120317436*^9}, {3.950294685128439*^9, 
   3.95029472592894*^9}, {3.950294832495619*^9, 3.950294862585589*^9}, {
   3.950294938361325*^9, 3.950294945539091*^9}, {3.9502950702265224`*^9, 
   3.9502950784210835`*^9}, {3.950295285259487*^9, 3.950295287827811*^9}, 
   3.950295339321804*^9, {3.950295371230142*^9, 3.9502954311813335`*^9}, 
   3.950295494745037*^9, {3.950295615632918*^9, 3.950295624959718*^9}, {
   3.950297386075203*^9, 3.950297436332136*^9}, {3.950297477358675*^9, 
   3.9502975636404247`*^9}, {3.9502976564101357`*^9, 3.950297662636419*^9}, 
   3.9502991139286327`*^9, {3.951224293688961*^9, 3.951224397669229*^9}, {
   3.951309164139301*^9, 3.95130919024996*^9}, {3.954941273808172*^9, 
   3.9549412992345657`*^9}, {3.9549424878882523`*^9, 3.954942502495722*^9}, {
   3.9550955241050587`*^9, 3.955095530906025*^9}, {3.9551202951840153`*^9, 
   3.9551202991293755`*^9}, 3.9551231099541664`*^9, {3.9551250698491783`*^9, 
   3.9551250836562157`*^9}, {3.9551251910534573`*^9, 3.955125227344343*^9}, {
   3.9551252606372185`*^9, 3.9551252951318665`*^9}, {3.955125566306019*^9, 
   3.9551255666478024`*^9}, {3.955125785153406*^9, 3.9551257934579144`*^9}, {
   3.9552023640702686`*^9, 3.955202386378977*^9}, {3.9552025605017834`*^9, 
   3.9552025734718857`*^9}, {3.9552027516272717`*^9, 3.955202775688017*^9}, {
   3.9552046813476276`*^9, 3.9552047270457134`*^9}, {3.9552048725942726`*^9, 
   3.955204874098255*^9}, {3.9552049812753735`*^9, 3.955204999850292*^9}, {
   3.955205118923311*^9, 3.955205128322521*^9}, 3.9552054090935993`*^9, {
   3.9552057368385506`*^9, 3.9552057791278057`*^9}, {3.9552058467302513`*^9, 
   3.9552058563251095`*^9}, {3.9552059176741447`*^9, 
   3.9552059289503098`*^9}, {3.95520598966263*^9, 3.95520602547036*^9}, {
   3.9552060871630955`*^9, 3.95520608899139*^9}, {3.9552061416724854`*^9, 
   3.9552061464953384`*^9}, 3.955206182573513*^9, {3.9552063767825165`*^9, 
   3.955206398877365*^9}, {3.955206468638525*^9, 3.9552064740265102`*^9}, {
   3.9552066515653954`*^9, 3.9552066614091816`*^9}, {3.955207153359255*^9, 
   3.9552071658046494`*^9}, {3.955207339828703*^9, 3.9552073797555065`*^9}, {
   3.9552075048559456`*^9, 3.955207545604061*^9}, {3.9552081450733585`*^9, 
   3.955208280976879*^9}, {3.955208357635412*^9, 3.9552083578315735`*^9}, {
   3.955208598169855*^9, 3.955208716401058*^9}, 3.955208751221863*^9, {
   3.955210748676075*^9, 3.9552107507517014`*^9}, {3.9553649785342712`*^9, 
   3.9553649919565887`*^9}, {3.955486120855219*^9, 3.9554861549895687`*^9}, {
   3.9554862045438232`*^9, 3.955486234456749*^9}, {3.955486271628105*^9, 
   3.955486478564436*^9}, {3.955486526046612*^9, 3.955486608531473*^9}, {
   3.9554868455198803`*^9, 3.955486861767929*^9}, {3.9554873595415993`*^9, 
   3.9554874030025043`*^9}, {3.955487456025692*^9, 3.955487457281658*^9}, {
   3.9554900726422577`*^9, 3.9554900887700977`*^9}, {3.955490373310919*^9, 
   3.9554904099387817`*^9}, {3.9557087181133633`*^9, 3.955708721104252*^9}, {
   3.955709935947584*^9, 3.955710004383169*^9}, {3.9557105873033237`*^9, 
   3.9557107877115154`*^9}, {3.955711240785671*^9, 3.955711312822052*^9}, {
   3.955711366477255*^9, 3.9557113707785454`*^9}, {3.9557225663015976`*^9, 
   3.9557226058054657`*^9}, {3.9557232066888657`*^9, 
   3.9557232384447556`*^9}, {3.9557233407322063`*^9, 3.955723393406267*^9}, {
   3.9557260084051876`*^9, 3.9557260106718426`*^9}, {3.955726269361183*^9, 
   3.955726276837961*^9}, {3.955726674548918*^9, 3.955726676229044*^9}, {
   3.9557283464677067`*^9, 3.955728358497925*^9}, {3.9557284021227417`*^9, 
   3.9557284026307583`*^9}, {3.9557285336268005`*^9, 3.955728545648876*^9}, {
   3.955728586647661*^9, 3.9557285876822357`*^9}, {3.955728623034319*^9, 
   3.955728755191721*^9}, {3.955728787645729*^9, 3.955728814741436*^9}, {
   3.9557288655618534`*^9, 3.9557288983048744`*^9}, {3.9557289578842583`*^9, 
   3.955728958580055*^9}, {3.955729175761841*^9, 3.955729206234621*^9}, {
   3.955729239767454*^9, 3.95572925370459*^9}, {3.955729502709879*^9, 
   3.9557295068638077`*^9}, 3.9557295702078896`*^9, {3.9557301156950054`*^9, 
   3.955730161714983*^9}, {3.9557302077822704`*^9, 3.955730343359766*^9}, {
   3.9557303839690304`*^9, 3.9557304182352524`*^9}, {3.9557305095942287`*^9, 
   3.9557305127982826`*^9}, {3.9557305479677086`*^9, 3.955730556374346*^9}, {
   3.955730684664364*^9, 3.9557306919220905`*^9}, {3.955730759716194*^9, 
   3.955730766879648*^9}, {3.9557323252475357`*^9, 3.955732410310137*^9}, {
   3.9557324581919327`*^9, 3.955732470599989*^9}, {3.955732548287533*^9, 
   3.955732578902458*^9}, {3.9557327115089607`*^9, 3.955732796811426*^9}, {
   3.9557329676551495`*^9, 3.955733004854233*^9}, 3.9557330493763447`*^9, {
   3.9557331019930935`*^9, 3.955733109255745*^9}, {3.9557331881572533`*^9, 
   3.9557331884496937`*^9}, {3.95573324900634*^9, 3.955733252470108*^9}, 
   3.9557334740970497`*^9, {3.955733598989912*^9, 3.955733661061657*^9}, {
   3.955733747803993*^9, 3.9557337848683643`*^9}, {3.9557338461929207`*^9, 
   3.955733875547636*^9}, {3.955733909693365*^9, 3.9557339596249866`*^9}, {
   3.955734729447075*^9, 3.955734737158537*^9}, {3.9557347942684727`*^9, 
   3.9557348037076244`*^9}, {3.9557348602975845`*^9, 3.955734872929369*^9}, {
   3.9557349044307537`*^9, 3.9557350391438503`*^9}, {3.9557351470838795`*^9, 
   3.9557351575934067`*^9}, {3.955735227215435*^9, 3.955735232237259*^9}, {
   3.9557352905283737`*^9, 3.955735384052183*^9}, {3.955735424405361*^9, 
   3.9557354282494392`*^9}, {3.95573548353224*^9, 3.95573549951334*^9}, 
   3.9557355323072643`*^9, {3.955735587142748*^9, 3.955735591697075*^9}, {
   3.95573582909309*^9, 3.955735903784092*^9}, {3.9557359765729713`*^9, 
   3.955736062900154*^9}, {3.955736630135189*^9, 3.9557366424506397`*^9}, {
   3.9557369531787186`*^9, 3.9557370067165775`*^9}, {3.9557370516172447`*^9, 
   3.955737054113695*^9}, {3.9557371895146065`*^9, 3.955737222925417*^9}, {
   3.9557372799151764`*^9, 3.9557372877894993`*^9}, {3.9557373245643063`*^9, 
   3.9557373278771114`*^9}, {3.955737380691475*^9, 3.9557373935084496`*^9}, {
   3.95573743143256*^9, 3.9557374830409565`*^9}, 3.955737602886736*^9, {
   3.9557376633275223`*^9, 3.9557376693174057`*^9}, {3.9557377170668507`*^9, 
   3.9557377653897495`*^9}, 3.9557378397218666`*^9, {3.9557379218511047`*^9, 
   3.955737974116625*^9}, {3.955738041039379*^9, 3.9557380993551636`*^9}, {
   3.9557382385549736`*^9, 3.9557383094195175`*^9}, {3.9557386507080345`*^9, 
   3.9557386791675644`*^9}, {3.9557399490018044`*^9, 3.955739996163601*^9}, {
   3.9557400272892284`*^9, 3.9557400347480392`*^9}, {3.955740907043537*^9, 
   3.955740930405205*^9}, {3.955741010122961*^9, 3.955741012375967*^9}, {
   3.9557411958340473`*^9, 3.9557411979832497`*^9}, 3.9557418779329987`*^9, {
   3.9557445506033688`*^9, 3.955744561330147*^9}, {3.9557450020946007`*^9, 
   3.955745005004635*^9}, {3.955745045936535*^9, 3.955745060101776*^9}, {
   3.955745208943289*^9, 3.955745264484741*^9}, {3.955746914273817*^9, 
   3.9557469166988354`*^9}, {3.9557480870234814`*^9, 3.955748103305029*^9}, {
   3.95574818812138*^9, 3.9557481943742504`*^9}, {3.955748945524435*^9, 
   3.9557489663354206`*^9}, {3.955749002818165*^9, 3.955749019834467*^9}, {
   3.9557491274726048`*^9, 3.955749147639477*^9}, {3.9557491966182747`*^9, 
   3.955749214615715*^9}, {3.9557493146959496`*^9, 3.9557493310136375`*^9}, {
   3.9557504917649097`*^9, 3.9557505012806873`*^9}, {3.9557513764351406`*^9, 
   3.955751397971775*^9}, 3.955794950499161*^9, {3.9557950275848904`*^9, 
   3.95579506527598*^9}, {3.9558005131548996`*^9, 3.955800629156908*^9}, {
   3.9558006702263737`*^9, 3.9558007313219185`*^9}, {3.9558010945614033`*^9, 
   3.9558011487779865`*^9}, {3.955801609793604*^9, 3.9558016295523014`*^9}, 
   3.955802060725424*^9, {3.95580216971023*^9, 3.9558021706597767`*^9}, {
   3.9558205398323784`*^9, 3.9558205506273746`*^9}, {3.955820585788954*^9, 
   3.9558205862434235`*^9}, {3.9558224959054413`*^9, 
   3.9558224960233555`*^9}, {3.9558237433220196`*^9, 
   3.9558237492612686`*^9}, {3.9564114610322857`*^9, 3.956411498967573*^9}, {
   3.9564116192608376`*^9, 3.956411672805937*^9}, {3.956419780634617*^9, 
   3.956419786599554*^9}, {3.9564212312897224`*^9, 3.956421256978323*^9}, 
   3.957268255321184*^9, {3.9572785805999374`*^9, 3.957278605397476*^9}, {
   3.957325351214628*^9, 3.9573253826951923`*^9}, {3.9573272691485977`*^9, 
   3.9573273003522625`*^9}, {3.957327399850071*^9, 3.9573274034850082`*^9}, {
   3.9573275052893906`*^9, 3.957327507421837*^9}, {3.9573275780369053`*^9, 
   3.957327600583479*^9}, {3.957327636267252*^9, 3.957327725673252*^9}, 
   3.957352230377947*^9, {3.957398330714018*^9, 3.957398337077276*^9}, {
   3.9577041180296307`*^9, 3.957704120051716*^9}, {3.958128147081459*^9, 
   3.9581281523586617`*^9}, {3.9581506604001827`*^9, 
   3.9581506633785305`*^9}, {3.958315980961958*^9, 3.958315989770405*^9}, {
   3.9583160213566093`*^9, 3.958316022100807*^9}, {3.95831606888863*^9, 
   3.958316380714737*^9}, {3.958316732680231*^9, 3.9583167819046135`*^9}, {
   3.958318946258505*^9, 3.958318948601156*^9}, {3.9583943153155975`*^9, 
   3.958394344050541*^9}, {3.958415391243946*^9, 3.9584154070442867`*^9}, {
   3.958415468400074*^9, 3.9584154940833282`*^9}, 3.9584156157352104`*^9, {
   3.9584157873401527`*^9, 3.9584157931732273`*^9}, 3.9584158236131287`*^9, {
   3.958416745579174*^9, 3.95841675316971*^9}, {3.9584272607013226`*^9, 
   3.958427353615492*^9}, {3.958427647034157*^9, 3.958427649223566*^9}, {
   3.95842783929908*^9, 3.958427942843256*^9}, {3.9584280718630257`*^9, 
   3.9584281592222195`*^9}, {3.958428251906065*^9, 3.9584282520743656`*^9}, {
   3.9584331512381954`*^9, 3.9584332790165424`*^9}, {3.9584357838023434`*^9, 
   3.9584357876933517`*^9}, {3.958436034373455*^9, 3.9584360351176567`*^9}, {
   3.958436113242544*^9, 3.958436124199812*^9}, 3.9584362000517197`*^9, {
   3.9584362737513237`*^9, 3.9584363214584904`*^9}, {3.958436446197359*^9, 
   3.958436517930664*^9}, {3.958436652395134*^9, 3.9584366554363384`*^9}, {
   3.958436992806946*^9, 3.958436996322834*^9}, 3.9584371531061*^9, {
   3.958437260119711*^9, 3.9584372664429264`*^9}, {3.958438143709322*^9, 
   3.958438197215584*^9}, {3.9584382356475525`*^9, 3.958438346427021*^9}, {
   3.958477002573921*^9, 3.9584770124160976`*^9}, {3.958477054973629*^9, 
   3.9584770970087624`*^9}, {3.9584771323318367`*^9, 3.95847715256921*^9}, {
   3.958478351968439*^9, 3.958478413068918*^9}, {3.9584807914639015`*^9, 
   3.958480793080839*^9}, {3.958480928388031*^9, 3.95848094677182*^9}, {
   3.9584814782182007`*^9, 3.9584814793747215`*^9}, {3.9584815388035107`*^9, 
   3.958481541745514*^9}, {3.958481857159748*^9, 3.958481864466013*^9}, {
   3.958484270681423*^9, 3.958484381011467*^9}, {3.9584844958108673`*^9, 
   3.9584845037131176`*^9}, {3.958484606903326*^9, 3.9584846590196705`*^9}, {
   3.958484750524849*^9, 3.9584848951672516`*^9}, 3.9584850383455353`*^9, {
   3.9584855980300407`*^9, 3.9584857571681767`*^9}, {3.9585631972348843`*^9, 
   3.958563270175228*^9}, {3.9586483549988766`*^9, 3.958648360729645*^9}},
 CellLabel->
  "In[636]:=",ExpressionUUID->"fa78f9f8-f49c-a740-8038-3ad8a681ac74"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefPartialPartial", "[", 
    RowBox[{
     RowBox[{"function_", "?", "ScalarFunctionQ"}], ",", "fields__"}], "]"}], 
   ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "partialinvMetric", ",", "partialMetric", ",", "booleanlist", ",", 
       "tensors", ",", "sign", ",", "flippedindices", ",", 
       "daggerpartialinvMetric", ",", "daggerpartialMetric", ",", "fullList", 
       ",", "numberOfImaginaryTensors", ",", "numberOfComplex", ",", 
       "numberOfHermitian", ",", "numberOfAntihermitian", ",", "dag"}], "}"}],
      ",", " ", "\n", "\n", "    ", 
     RowBox[{
      RowBox[{"MakexTensions", "[", 
       RowBox[{
       "DefPartialPartial", ",", "\"\<Beginning\>\"", ",", "function", ",", 
        "fields"}], "]"}], ";", " ", "\n", "    ", "\n", "    ", 
      RowBox[{"tensors", "=", 
       RowBox[{"Sort", "@", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", "fields", "}"}], "]"}]}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "fields", " ", "sorted", " ", "by", " ", "alphabetical", " ", 
        "order"}], " ", "*)"}], "\n", "    ", 
      RowBox[{"fullList", "=", 
       RowBox[{"tensors", "~", "Join", "~", 
        RowBox[{"{", "function", "}"}]}]}], ";", "\n", "    ", "\n", "    ", 
      RowBox[{"numberOfImaginaryTensors", "=", 
       RowBox[{"Count", "[", 
        RowBox[{
         RowBox[{"Dagger", "/@", "fullList"}], ",", 
         RowBox[{"MultiplyHead", "[", 
          RowBox[{"_", ",", "_"}], "]"}]}], "]"}]}], ";", "\n", "    ", 
      RowBox[{"numberOfComplex", "=", 
       RowBox[{"Count", "[", 
        RowBox[{"fullList", ",", 
         RowBox[{"_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Dagger", "[", "#", "]"}], "/.", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"MultiplyHead", "[", 
                  RowBox[{"_", ",", "tensor_"}], "]"}], ":>", "tensor"}], 
                "}"}]}], ")"}], "=!=", "#"}], "&"}], ")"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"numberOfHermitian", "=", 
       RowBox[{"Count", "[", 
        RowBox[{"tensors", ",", 
         RowBox[{"_", "?", "HermitianQ"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"numberOfAntihermitian", "=", 
       RowBox[{"Count", "[", 
        RowBox[{"tensors", ",", 
         RowBox[{"_", "?", "AntihermitianQ"}]}], "]"}]}], ";", "\n", "\t", 
      "\n", "\t", 
      RowBox[{"dag", " ", "=", " ", 
       RowBox[{"Which", "[", "\n", "\t\t  ", 
        RowBox[{
         RowBox[{
          RowBox[{"numberOfComplex", " ", "==", " ", "0"}], " ", "&&", " ", 
          RowBox[{"numberOfImaginaryTensors", " ", "==", " ", "0"}]}], ",", 
         " ", "Real", ",", "\n", "\t\t  ", 
         RowBox[{
          RowBox[{"numberOfComplex", " ", "==", " ", "0"}], " ", "&&", " ", 
          RowBox[{"EvenQ", "[", "numberOfImaginaryTensors", "]"}]}], ",", 
         "Real", ",", "\n", "\t\t  ", 
         RowBox[{
          RowBox[{"numberOfComplex", " ", "==", " ", "0"}], " ", "&&", " ", 
          RowBox[{"OddQ", "[", "numberOfImaginaryTensors", "]"}]}], ",", 
         "Imaginary", ",", "\n", "\t\t  ", 
         RowBox[{
          RowBox[{"numberOfComplex", " ", "=!=", " ", "0"}], " ", "&&", " ", 
          RowBox[{"numberOfComplex", " ", "=!=", " ", 
           RowBox[{
           "numberOfHermitian", " ", "+", " ", "numberOfAntihermitian"}]}]}], 
         ",", "Complex", ",", "\n", "\t\t  ", 
         RowBox[{
          RowBox[{"numberOfComplex", " ", "=!=", " ", "0"}], " ", "&&", " ", 
          RowBox[{"numberOfComplex", " ", "===", " ", 
           RowBox[{
           "numberOfHermitian", " ", "+", " ", "numberOfAntihermitian"}]}], 
          " ", "&&", " ", 
          RowBox[{"EvenQ", "[", "numberOfAntihermitian", "]"}]}], ",", 
         "Hermitian", ",", "\n", "\t\t  ", 
         RowBox[{
          RowBox[{"numberOfComplex", " ", "=!=", " ", "0"}], " ", "&&", " ", 
          RowBox[{"numberOfComplex", " ", "===", " ", 
           RowBox[{
           "numberOfHermitian", " ", "+", " ", "numberOfAntihermitian"}]}], 
          " ", "&&", " ", 
          RowBox[{"OddQ", "[", "numberOfAntihermitian", "]"}]}], ",", 
         "Antihermitian"}], "\n", "\t", "]"}]}], ";", "\n", "\t", "\n", "\t", 
      RowBox[{"booleanlist", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"MetricQ", "[", "#", "]"}], "&&", 
           RowBox[{
            RowBox[{"Inv", "[", "#", "]"}], "===", "#"}]}], ")"}], "&"}], "/@",
         "tensors"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Some", " ", "main", " ", "metric"}], " ", "*)"}], "\n", "\t", 
      RowBox[{"flippedindices", "=", 
       RowBox[{"DummyIn", "/@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "*", 
            RowBox[{"SlotsOfTensor", "/@", "tensors"}]}], ")"}], "//", 
          "Flatten"}], ")"}]}]}], ";", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"Or", "@@", "booleanlist"}]}], ",", "\n", "\t\t", 
        RowBox[{"DefPartialPartialAUX", "[", 
         RowBox[{"function", ",", "flippedindices", ",", "tensors", ",", 
          RowBox[{"PrintInverse", " ", "->", " ", "False"}], ",", 
          RowBox[{"Dagger", "->", "dag"}]}], "]"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"No", " ", "main", " ", "metric", " ", "involved"}], " ", 
         "*)"}], " ", "\n", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"sign", "=", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{"booleanlist", ",", " ", 
                RowBox[{
                 RowBox[{"#", " ", "==", " ", "True"}], " ", "&"}]}], "]"}], 
              " ", "//", " ", "Length"}], ")"}]}]}], ";", "\n", "\t\t", 
          RowBox[{"DefPartialPartialAUX", "[", 
           RowBox[{"function", ",", "flippedindices", ",", "tensors", ",", 
            RowBox[{"PrintInverse", " ", "->", " ", "False"}], ",", 
            RowBox[{"Dagger", "->", "dag"}]}], "]"}], ";", "\n", "\t\t", "\n",
           "\t\t", 
          RowBox[{"flippedindices", "=", 
           RowBox[{"DummyIn", "/@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"MetricQ", "[", "#", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Inv", "[", "#", "]"}], "===", "#"}]}], ",", "1", 
                    ",", 
                    RowBox[{"-", "1"}]}], "]"}], "*", 
                  RowBox[{"SlotsOfTensor", "[", "#", "]"}]}], "&"}], "/@", 
                "tensors"}], ")"}], "//", "Flatten"}], ")"}]}]}], ";", " ", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Flips", " ", "all", " ", "indices", " ", "except", " ", "the", " ",
             "corresponding", " ", "to", " ", "main", " ", "metrics", " ", 
            RowBox[{"(", 
             RowBox[{
             "equivalent", " ", "to", " ", "flipping", " ", "the", " ", 
              "indices", " ", "of", " ", "the", " ", "INVERSE", " ", 
              "metric"}], ")"}]}], " ", "*)"}], " ", "\n", "\t\t", 
          RowBox[{"DefPartialPartialAUX", "[", 
           RowBox[{"function", ",", "flippedindices", ",", "tensors", ",", 
            RowBox[{"PrintInverse", " ", "->", " ", "True"}], ",", 
            RowBox[{"Dagger", "->", "dag"}]}], "]"}], ";", "\n", "\t\t", "\n",
           "\t\t", 
          RowBox[{"partialinvMetric", "=", 
           RowBox[{
            RowBox[{"PartialPartial", "[", "function", "]"}], "[", 
            RowBox[{"ToExpression", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"InvName", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"PrintInverse", " ", "->", " ", "True"}]}], "]"}], 
               "&"}], "/@", "tensors"}], "]"}], "]"}]}], ";", "\n", "\t\t", 
          RowBox[{"partialMetric", "=", 
           RowBox[{
            RowBox[{"PartialPartial", "[", "function", "]"}], "[", "tensors", 
            "]"}]}], ";", "\n", "\t\t", 
          RowBox[{"daggerpartialinvMetric", "=", 
           RowBox[{
            RowBox[{"PartialPartial", "[", 
             RowBox[{
              RowBox[{"Dagger", "@", "function"}], "/.", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"MultiplyHead", "[", 
                 RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}], 
             "]"}], "[", 
            RowBox[{
             RowBox[{"Dagger", "/@", 
              RowBox[{"ToExpression", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"InvName", "[", 
                  RowBox[{"#", ",", 
                   RowBox[{"PrintInverse", " ", "->", " ", "True"}]}], "]"}], 
                 "&"}], "/@", "tensors"}], "]"}]}], "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"MultiplyHead", "[", 
                RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}], 
            "]"}]}], ";", "\n", "\t\t", 
          RowBox[{"daggerpartialMetric", "=", 
           RowBox[{
            RowBox[{"PartialPartial", "[", 
             RowBox[{
              RowBox[{"Dagger", "@", "function"}], "/.", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"MultiplyHead", "[", 
                 RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}], 
             "]"}], "[", 
            RowBox[{
             RowBox[{"Dagger", "/@", "tensors"}], "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"MultiplyHead", "[", 
                RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", "\n", "\t\t", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Generate", " ", "automatic", " ", "rules", " ", "to", " ", "turn",
             " ", "PartialFunctionPartialInvg", " ", "into", "  ", 
            "PartialFunctionPartialg", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"or", " ", "vice"}], "-", "versa"}], ")"}]}], " ", 
           "*)"}], "\n", "\t\t", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
              "partialinvMetricSym", " ", "=", " ", "partialinvMetric"}], ",",
               " ", 
              RowBox[{"partialMetricSym", " ", "=", " ", "partialMetric"}], ",", 
              RowBox[{
              "daggerpartialinvMetricSym", "=", "daggerpartialinvMetric"}], ",", 
              RowBox[{
              "daggerpartialMetricSym", " ", "=", " ", 
               "daggerpartialMetric"}]}], "}"}], ",", "\n", "\t\t\t", 
            RowBox[{
             RowBox[{"partialinvMetricSym", "/:", " ", 
              RowBox[{
               RowBox[{"partialinvMetricSym", "[", "inds___", "]"}], " ", "/;",
                " ", 
               RowBox[{"$UseInverseMetric", " ", "==", " ", "False"}]}], " ", 
              ":=", 
              RowBox[{"sign", " ", 
               RowBox[{"partialMetricSym", "[", "inds", "]"}]}]}], ";", "\n", 
             "\t\t\t", 
             RowBox[{"partialMetricSym", "/:", " ", 
              RowBox[{
               RowBox[{"partialMetricSym", "[", "inds___", "]"}], " ", "/;", 
               " ", 
               RowBox[{"$UseInverseMetric", " ", "==", " ", "True"}]}], " ", ":=", 
              RowBox[{"sign", " ", 
               RowBox[{"partialinvMetricSym", "[", "inds", "]"}]}]}], ";", 
             "\n", "\t\t\t", 
             RowBox[{"daggerpartialinvMetricSym", "/:", " ", 
              RowBox[{
               RowBox[{"daggerpartialinvMetricSym", "[", "inds___", "]"}], 
               " ", "/;", " ", 
               RowBox[{"$UseInverseMetric", " ", "==", " ", "False"}]}], " ", 
              ":=", 
              RowBox[{"sign", " ", 
               RowBox[{"daggerpartialMetricSym", "[", "inds", "]"}]}]}], ";", 
             "\n", "\t\t\t", 
             RowBox[{"daggerpartialMetricSym", "/:", " ", 
              RowBox[{
               RowBox[{"daggerpartialMetricSym", "[", "inds___", "]"}], " ", "/;",
                " ", 
               RowBox[{"$UseInverseMetric", " ", "==", " ", "True"}]}], " ", ":=", 
              RowBox[{"sign", " ", 
               RowBox[{"daggerpartialinvMetricSym", "[", "inds", "]"}]}]}], 
             ";"}]}], "\n", "\t\t", "]"}], ";"}], "\n", "\t\t", "\n", "\n", 
         "\t\t", ")"}]}], "\n", "\t", "]"}], ";", "\n", "\t\t", "\n", "\t", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"tensorsdependencies", "=", 
          RowBox[{"TensorsOfPartialPartial", "[", 
           RowBox[{
            RowBox[{"PartialPartial", "[", "function", "]"}], "[", "fields", 
            "]"}], "]"}]}], "}"}], ",", "\n", "\n", "\t\t", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"numberofcomplex", "===", 
            RowBox[{"numberofhermitian", "+", "numberofantihermitian"}]}], "&&", 
           RowBox[{"EvenQ", "[", "numberofantihermitian", "]"}]}], ",", "\n", 
          "\t\t\t", 
          RowBox[{"HermitianQ", "[", "]"}]}], "]"}]}], "\n", "\t", "]"}], ";",
       "\n", "\t", "\n", "    ", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{
       "DefPartialPartial", ",", "\"\<End\>\"", ",", "function", ",", 
        "fields"}], "]"}], ";"}]}], " ", "\n", "\t", "\n", "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "DefPartialPartial", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.933406921174345*^9, 3.933407006640181*^9}, {
   3.93340771717714*^9, 3.933407771524101*^9}, {3.933407842889041*^9, 
   3.93340784593215*^9}, {3.9334078825734615`*^9, 3.9334079049310675`*^9}, {
   3.9334080926353464`*^9, 3.933408122023637*^9}, {3.933408160283249*^9, 
   3.9334081613326297`*^9}, {3.933408447319936*^9, 3.93340851503378*^9}, {
   3.933408882271353*^9, 3.933408956675268*^9}, {3.933408995312349*^9, 
   3.9334091265815077`*^9}, {3.933409440623533*^9, 3.933409490059602*^9}, {
   3.933409545667935*^9, 3.933409559526745*^9}, {3.933409624818842*^9, 
   3.93340968019966*^9}, {3.933409723362918*^9, 3.933409797572757*^9}, {
   3.933409841995154*^9, 3.933409903386168*^9}, {3.933410016236034*^9, 
   3.9334100170103254`*^9}, {3.9334100531015844`*^9, 
   3.9334101535947943`*^9}, {3.933410213453788*^9, 3.9334102938915176`*^9}, {
   3.933410670619817*^9, 3.933410671122767*^9}, {3.933411456200949*^9, 
   3.933411475574125*^9}, {3.9373053795156136`*^9, 3.9373053795797997`*^9}, {
   3.937306157878441*^9, 3.937306158292214*^9}, {3.937306269018829*^9, 
   3.937306280620297*^9}, {3.937362968152558*^9, 3.937363066875798*^9}, {
   3.9373635762592773`*^9, 3.9373635793472366`*^9}, {3.9373637019161606`*^9, 
   3.9373637019948044`*^9}, {3.937364029159052*^9, 3.937364074760332*^9}, {
   3.937364160565178*^9, 3.9373642237654514`*^9}, {3.937364626859802*^9, 
   3.9373646290816097`*^9}, {3.937364804658905*^9, 3.9373648143460846`*^9}, 
   3.9373650753211765`*^9, {3.937365160977658*^9, 3.937365161177868*^9}, {
   3.93736524282288*^9, 3.9373652518743896`*^9}, 3.937366133935508*^9, {
   3.937366464171404*^9, 3.937366465559313*^9}, {3.937366714972174*^9, 
   3.93736683314686*^9}, {3.9373668696511135`*^9, 3.9373668738567257`*^9}, 
   3.937367152464058*^9, {3.937381458278471*^9, 3.937381460322121*^9}, {
   3.937382179729217*^9, 3.9373821871093655`*^9}, {3.937382272833767*^9, 
   3.93738227918374*^9}, {3.9373829827542133`*^9, 3.9373830044843655`*^9}, {
   3.937383112477118*^9, 3.937383128406254*^9}, {3.937383895232533*^9, 
   3.937383895848821*^9}, {3.937383979975384*^9, 3.937383992360611*^9}, {
   3.937384052760938*^9, 3.93738405848674*^9}, {3.937384221115248*^9, 
   3.937384260528507*^9}, {3.937384391670376*^9, 3.937384404020799*^9}, {
   3.937384497745165*^9, 3.937384501494868*^9}, {3.93738464225375*^9, 
   3.937384650017959*^9}, 3.938528850420394*^9, {3.938529030271578*^9, 
   3.938529042232601*^9}, {3.93852907865707*^9, 3.938529094223398*^9}, {
   3.938529145716605*^9, 3.9385291704070425`*^9}, {3.938529256747004*^9, 
   3.938529280811816*^9}, {3.938529321822528*^9, 3.9385294680946264`*^9}, {
   3.938529564637632*^9, 3.9385296067599936`*^9}, {3.938529850742167*^9, 
   3.9385298660436287`*^9}, {3.938582918775227*^9, 3.938582930285669*^9}, {
   3.938594715950249*^9, 3.938594736281033*^9}, {3.938594788648814*^9, 
   3.938594789458813*^9}, {3.938596500086594*^9, 3.938596500091591*^9}, 
   3.938679596908964*^9, {3.9386796499477134`*^9, 3.938679660829779*^9}, {
   3.9386797045233345`*^9, 3.938679842763437*^9}, {3.938679924888153*^9, 
   3.938679932976369*^9}, {3.93867997252408*^9, 3.938680058911319*^9}, {
   3.938680098264307*^9, 3.938680121079299*^9}, {3.9386801709920273`*^9, 
   3.938680199147262*^9}, {3.941629361792519*^9, 3.941629382579403*^9}, {
   3.941631155549241*^9, 3.941631168407516*^9}, {3.941631294551567*^9, 
   3.941631296763277*^9}, {3.9416340220557013`*^9, 3.9416340268606615`*^9}, {
   3.941634115960855*^9, 3.941634150923091*^9}, {3.941649990721203*^9, 
   3.9416500070426826`*^9}, {3.944276817550635*^9, 3.944276863982127*^9}, {
   3.944277097594197*^9, 3.944277099630007*^9}, {3.944277131777954*^9, 
   3.944277136002495*^9}, {3.9442779222103453`*^9, 3.944277926011027*^9}, {
   3.948400213696924*^9, 3.9484002389988995`*^9}, {3.948544995822412*^9, 
   3.9485450766366043`*^9}, {3.948545415731119*^9, 3.948545436275989*^9}, {
   3.948561574418477*^9, 3.94856157551278*^9}, {3.948911702624031*^9, 
   3.9489117054498653`*^9}, {3.9489128784257298`*^9, 3.948912895855831*^9}, {
   3.9489131642818203`*^9, 3.948913167584549*^9}, 3.948913791353824*^9, {
   3.948914236124546*^9, 3.94891423626228*^9}, {3.949167742007576*^9, 
   3.949167752060467*^9}, {3.949167831067356*^9, 3.9491678315811596`*^9}, {
   3.949168415701826*^9, 3.949168486193968*^9}, {3.949168601901099*^9, 
   3.9491686080862904`*^9}, {3.9491731744043674`*^9, 3.949173174656637*^9}, {
   3.949173318272003*^9, 3.9491733881202736`*^9}, 3.9493481088564305`*^9, {
   3.949515733119776*^9, 3.9495157375996857`*^9}, {3.950124003524918*^9, 
   3.950124017730396*^9}, {3.950284700456896*^9, 3.950284756956906*^9}, {
   3.950284825621414*^9, 3.95028484735746*^9}, {3.950284905158785*^9, 
   3.950284942963383*^9}, {3.9502849842260075`*^9, 3.950285035620806*^9}, {
   3.950285125301064*^9, 3.950285148418938*^9}, {3.950285187538789*^9, 
   3.950285254179893*^9}, {3.950285310329048*^9, 3.9502854090233727`*^9}, {
   3.950285496855503*^9, 3.950285523088554*^9}, {3.9502855999913673`*^9, 
   3.950285613742403*^9}, {3.950285645467645*^9, 3.95028567834717*^9}, {
   3.950285956496371*^9, 3.950285987080471*^9}, 3.9502860301665325`*^9, {
   3.9502863444280663`*^9, 3.9502863724001083`*^9}, {3.950286446430664*^9, 
   3.9502865157236023`*^9}, {3.9502865772245274`*^9, 3.950286585334236*^9}, {
   3.950286718679405*^9, 3.950286755746117*^9}, 3.950287008544659*^9, {
   3.95028716376013*^9, 3.950287166501812*^9}, {3.950287233027176*^9, 
   3.950287234361564*^9}, {3.9502873280139465`*^9, 3.9502873290926304`*^9}, 
   3.950287359280592*^9, 3.9502874261965637`*^9, {3.950287734161017*^9, 
   3.950287764207033*^9}, {3.950288274908495*^9, 3.950288308699247*^9}, {
   3.950288387475679*^9, 3.95028839619329*^9}, {3.950289092322672*^9, 
   3.9502892219454*^9}, 3.950289259735361*^9, {3.9502893150156517`*^9, 
   3.9502893265394726`*^9}, {3.950289356657509*^9, 3.9502894130269127`*^9}, {
   3.950289599208252*^9, 3.9502896641101303`*^9}, 3.950289787356674*^9, {
   3.950290059341688*^9, 3.950290120317436*^9}, {3.950294685128439*^9, 
   3.95029472592894*^9}, {3.950294832495619*^9, 3.950294862585589*^9}, {
   3.950294938361325*^9, 3.950294945539091*^9}, {3.9502950702265224`*^9, 
   3.9502950784210835`*^9}, {3.950295285259487*^9, 3.950295287827811*^9}, 
   3.950295339321804*^9, {3.950295371230142*^9, 3.9502954311813335`*^9}, 
   3.950295494745037*^9, {3.950295615632918*^9, 3.950295624959718*^9}, {
   3.950297386075203*^9, 3.950297436332136*^9}, {3.950297477358675*^9, 
   3.9502975636404247`*^9}, {3.9502976564101357`*^9, 3.950297662636419*^9}, 
   3.9502991139286327`*^9, {3.951224293688961*^9, 3.951224397669229*^9}, {
   3.951309164139301*^9, 3.95130919024996*^9}, {3.954941273808172*^9, 
   3.9549412992345657`*^9}, {3.9549424878882523`*^9, 3.954942502495722*^9}, {
   3.9550955241050587`*^9, 3.955095530906025*^9}, {3.9551202951840153`*^9, 
   3.9551202991293755`*^9}, 3.9551231099541664`*^9, {3.9551250698491783`*^9, 
   3.9551250836562157`*^9}, {3.9551251910534573`*^9, 3.955125227344343*^9}, {
   3.9551252606372185`*^9, 3.9551252951318665`*^9}, {3.955125566306019*^9, 
   3.9551255666478024`*^9}, {3.955125785153406*^9, 3.9551257934579144`*^9}, {
   3.9552023640702686`*^9, 3.955202386378977*^9}, {3.9552025605017834`*^9, 
   3.9552025734718857`*^9}, {3.9552027516272717`*^9, 3.955202775688017*^9}, {
   3.9552046813476276`*^9, 3.9552047270457134`*^9}, {3.9552048725942726`*^9, 
   3.955204874098255*^9}, {3.9552049812753735`*^9, 3.955204999850292*^9}, {
   3.955205118923311*^9, 3.955205128322521*^9}, 3.9552054090935993`*^9, {
   3.9552057368385506`*^9, 3.9552057791278057`*^9}, {3.9552058467302513`*^9, 
   3.9552058563251095`*^9}, {3.9552059176741447`*^9, 
   3.9552059289503098`*^9}, {3.95520598966263*^9, 3.95520602547036*^9}, {
   3.9552060871630955`*^9, 3.95520608899139*^9}, {3.9552061416724854`*^9, 
   3.9552061464953384`*^9}, 3.955206182573513*^9, {3.9552063767825165`*^9, 
   3.955206398877365*^9}, {3.955206468638525*^9, 3.9552064740265102`*^9}, {
   3.9552066515653954`*^9, 3.9552066614091816`*^9}, {3.955207153359255*^9, 
   3.9552071658046494`*^9}, {3.955207339828703*^9, 3.9552073797555065`*^9}, {
   3.9552075048559456`*^9, 3.955207545604061*^9}, {3.9552081450733585`*^9, 
   3.955208280976879*^9}, {3.955208357635412*^9, 3.9552083578315735`*^9}, {
   3.955208598169855*^9, 3.955208716401058*^9}, 3.955208751221863*^9, {
   3.955210748676075*^9, 3.9552107507517014`*^9}, {3.9553649785342712`*^9, 
   3.9553649919565887`*^9}, {3.955486120855219*^9, 3.9554861549895687`*^9}, {
   3.9554862045438232`*^9, 3.955486234456749*^9}, {3.955486271628105*^9, 
   3.955486478564436*^9}, {3.955486526046612*^9, 3.955486608531473*^9}, {
   3.9554868455198803`*^9, 3.955486861767929*^9}, {3.9554873595415993`*^9, 
   3.9554874030025043`*^9}, {3.955487456025692*^9, 3.955487457281658*^9}, {
   3.9554900726422577`*^9, 3.9554900887700977`*^9}, {3.955490373310919*^9, 
   3.9554904099387817`*^9}, {3.9557087181133633`*^9, 3.955708721104252*^9}, {
   3.955709935947584*^9, 3.955710004383169*^9}, {3.9557105873033237`*^9, 
   3.9557107877115154`*^9}, {3.955711240785671*^9, 3.955711312822052*^9}, {
   3.955711366477255*^9, 3.9557113707785454`*^9}, {3.9557225663015976`*^9, 
   3.9557226058054657`*^9}, {3.9557232066888657`*^9, 
   3.9557232384447556`*^9}, {3.9557233407322063`*^9, 3.955723393406267*^9}, {
   3.9557260084051876`*^9, 3.9557260106718426`*^9}, {3.955726269361183*^9, 
   3.955726276837961*^9}, {3.955726674548918*^9, 3.955726676229044*^9}, {
   3.9557283464677067`*^9, 3.955728358497925*^9}, {3.9557284021227417`*^9, 
   3.9557284026307583`*^9}, {3.9557285336268005`*^9, 3.955728545648876*^9}, {
   3.955728586647661*^9, 3.9557285876822357`*^9}, {3.955728623034319*^9, 
   3.955728755191721*^9}, {3.955728787645729*^9, 3.955728814741436*^9}, {
   3.9557288655618534`*^9, 3.9557288983048744`*^9}, {3.9557289578842583`*^9, 
   3.955728958580055*^9}, {3.955729175761841*^9, 3.955729206234621*^9}, {
   3.955729239767454*^9, 3.95572925370459*^9}, {3.955729502709879*^9, 
   3.9557295068638077`*^9}, 3.9557295702078896`*^9, {3.9557301156950054`*^9, 
   3.955730161714983*^9}, {3.9557302077822704`*^9, 3.955730343359766*^9}, {
   3.9557303839690304`*^9, 3.9557304182352524`*^9}, {3.9557305095942287`*^9, 
   3.9557305127982826`*^9}, {3.9557305479677086`*^9, 3.955730556374346*^9}, {
   3.955730684664364*^9, 3.9557306919220905`*^9}, {3.955730759716194*^9, 
   3.955730766879648*^9}, {3.9557323252475357`*^9, 3.955732410310137*^9}, {
   3.9557324581919327`*^9, 3.955732470599989*^9}, {3.955732548287533*^9, 
   3.955732578902458*^9}, {3.9557327115089607`*^9, 3.955732796811426*^9}, {
   3.9557329676551495`*^9, 3.955733004854233*^9}, 3.9557330493763447`*^9, {
   3.9557331019930935`*^9, 3.955733109255745*^9}, {3.9557331881572533`*^9, 
   3.9557331884496937`*^9}, {3.95573324900634*^9, 3.955733252470108*^9}, 
   3.9557334740970497`*^9, {3.955733598989912*^9, 3.955733661061657*^9}, {
   3.955733747803993*^9, 3.9557337848683643`*^9}, {3.9557338461929207`*^9, 
   3.955733875547636*^9}, {3.955733909693365*^9, 3.9557339596249866`*^9}, {
   3.955734729447075*^9, 3.955734737158537*^9}, {3.9557347942684727`*^9, 
   3.9557348037076244`*^9}, {3.9557348602975845`*^9, 3.955734872929369*^9}, {
   3.9557349044307537`*^9, 3.9557350391438503`*^9}, {3.9557351470838795`*^9, 
   3.9557351575934067`*^9}, {3.955735227215435*^9, 3.955735232237259*^9}, {
   3.9557352905283737`*^9, 3.955735384052183*^9}, {3.955735424405361*^9, 
   3.9557354282494392`*^9}, {3.95573548353224*^9, 3.95573549951334*^9}, 
   3.9557355323072643`*^9, {3.955735587142748*^9, 3.955735591697075*^9}, {
   3.95573582909309*^9, 3.955735903784092*^9}, {3.9557359765729713`*^9, 
   3.955736062900154*^9}, {3.955736630135189*^9, 3.9557366424506397`*^9}, {
   3.9557369531787186`*^9, 3.9557370067165775`*^9}, {3.9557370516172447`*^9, 
   3.955737054113695*^9}, {3.9557371895146065`*^9, 3.955737222925417*^9}, {
   3.9557372799151764`*^9, 3.9557372877894993`*^9}, {3.9557373245643063`*^9, 
   3.9557373278771114`*^9}, {3.955737380691475*^9, 3.9557373935084496`*^9}, {
   3.95573743143256*^9, 3.9557374830409565`*^9}, 3.955737602886736*^9, {
   3.9557376633275223`*^9, 3.9557376693174057`*^9}, {3.9557377170668507`*^9, 
   3.9557377653897495`*^9}, 3.9557378397218666`*^9, {3.9557379218511047`*^9, 
   3.955737974116625*^9}, {3.955738041039379*^9, 3.9557380993551636`*^9}, {
   3.9557382385549736`*^9, 3.9557383094195175`*^9}, {3.9557386507080345`*^9, 
   3.9557386791675644`*^9}, {3.9557399490018044`*^9, 3.955739996163601*^9}, {
   3.9557400272892284`*^9, 3.9557400347480392`*^9}, {3.955740907043537*^9, 
   3.955740930405205*^9}, {3.955741010122961*^9, 3.955741012375967*^9}, {
   3.9557411958340473`*^9, 3.9557411979832497`*^9}, 3.9557418779329987`*^9, {
   3.9557445506033688`*^9, 3.955744561330147*^9}, {3.9557450020946007`*^9, 
   3.955745005004635*^9}, {3.955745045936535*^9, 3.955745060101776*^9}, {
   3.955745208943289*^9, 3.955745264484741*^9}, {3.955746914273817*^9, 
   3.9557469166988354`*^9}, {3.9557480870234814`*^9, 3.955748103305029*^9}, {
   3.95574818812138*^9, 3.9557481943742504`*^9}, {3.955748945524435*^9, 
   3.9557489663354206`*^9}, {3.955749002818165*^9, 3.955749019834467*^9}, {
   3.9557491274726048`*^9, 3.955749147639477*^9}, {3.9557491966182747`*^9, 
   3.955749214615715*^9}, {3.9557493146959496`*^9, 3.9557493310136375`*^9}, {
   3.9557504917649097`*^9, 3.9557505012806873`*^9}, {3.9557513764351406`*^9, 
   3.955751397971775*^9}, 3.955794950499161*^9, {3.9557950275848904`*^9, 
   3.95579506527598*^9}, {3.9558005131548996`*^9, 3.955800629156908*^9}, {
   3.9558006702263737`*^9, 3.9558007313219185`*^9}, {3.9558010945614033`*^9, 
   3.9558011487779865`*^9}, {3.955801609793604*^9, 3.9558016295523014`*^9}, 
   3.955802060725424*^9, {3.95580216971023*^9, 3.9558021706597767`*^9}, {
   3.9558205398323784`*^9, 3.9558205506273746`*^9}, {3.955820585788954*^9, 
   3.9558205862434235`*^9}, {3.9558224959054413`*^9, 
   3.9558224960233555`*^9}, {3.9558237433220196`*^9, 
   3.9558237492612686`*^9}, {3.9564114610322857`*^9, 3.956411498967573*^9}, {
   3.9564116192608376`*^9, 3.956411672805937*^9}, {3.956419780634617*^9, 
   3.956419786599554*^9}, {3.9564212312897224`*^9, 3.956421256978323*^9}, 
   3.957268255321184*^9, {3.9572785805999374`*^9, 3.957278605397476*^9}, {
   3.957325351214628*^9, 3.9573253826951923`*^9}, {3.9573272691485977`*^9, 
   3.9573273003522625`*^9}, {3.957327399850071*^9, 3.9573274034850082`*^9}, {
   3.9573275052893906`*^9, 3.957327507421837*^9}, {3.9573275780369053`*^9, 
   3.957327600583479*^9}, {3.957327636267252*^9, 3.957327725673252*^9}, 
   3.957352230377947*^9, {3.957398330714018*^9, 3.957398337077276*^9}, {
   3.9577041180296307`*^9, 3.957704120051716*^9}, {3.958128147081459*^9, 
   3.9581281523586617`*^9}, {3.9581506604001827`*^9, 
   3.9581506633785305`*^9}, {3.958315980961958*^9, 3.958315989770405*^9}, {
   3.9583160213566093`*^9, 3.958316022100807*^9}, {3.95831606888863*^9, 
   3.958316380714737*^9}, {3.958316732680231*^9, 3.9583167819046135`*^9}, {
   3.958318946258505*^9, 3.958318948601156*^9}, {3.9583943153155975`*^9, 
   3.958394344050541*^9}, {3.958415391243946*^9, 3.9584154070442867`*^9}, {
   3.958415468400074*^9, 3.9584154940833282`*^9}, 3.9584156157352104`*^9, {
   3.9584157873401527`*^9, 3.9584157931732273`*^9}, 3.9584158236131287`*^9, {
   3.958416745579174*^9, 3.95841675316971*^9}, {3.9584272607013226`*^9, 
   3.958427353615492*^9}, {3.958427647034157*^9, 3.958427649223566*^9}, {
   3.95842783929908*^9, 3.958427942843256*^9}, {3.9584280718630257`*^9, 
   3.9584281592222195`*^9}, {3.958428251906065*^9, 3.9584282520743656`*^9}, {
   3.9584331512381954`*^9, 3.9584332790165424`*^9}, {3.9584357838023434`*^9, 
   3.9584357876933517`*^9}, {3.958436034373455*^9, 3.9584360351176567`*^9}, {
   3.958436113242544*^9, 3.958436124199812*^9}, 3.9584362000517197`*^9, {
   3.9584362737513237`*^9, 3.9584363214584904`*^9}, {3.958436446197359*^9, 
   3.958436517930664*^9}, {3.958436652395134*^9, 3.9584366554363384`*^9}, {
   3.958436992806946*^9, 3.958436996322834*^9}, 3.9584371531061*^9, {
   3.958437260119711*^9, 3.9584372664429264`*^9}, {3.958438143709322*^9, 
   3.958438197215584*^9}, {3.9584382356475525`*^9, 3.958438346427021*^9}, {
   3.958477002573921*^9, 3.9584770124160976`*^9}, {3.958477054973629*^9, 
   3.9584770970087624`*^9}, {3.9584771323318367`*^9, 3.95847715256921*^9}, {
   3.958478351968439*^9, 3.958478413068918*^9}, {3.9584807914639015`*^9, 
   3.958480793080839*^9}, {3.958480928388031*^9, 3.95848094677182*^9}, {
   3.9584814782182007`*^9, 3.9584814793747215`*^9}, {3.9584815388035107`*^9, 
   3.958481541745514*^9}, {3.958481857159748*^9, 3.958481864466013*^9}, {
   3.958484270681423*^9, 3.958484381011467*^9}, {3.9584844958108673`*^9, 
   3.9584845037131176`*^9}, {3.958484606903326*^9, 3.9584846590196705`*^9}, {
   3.958484750524849*^9, 3.9584848951672516`*^9}, 3.9584850383455353`*^9, {
   3.9584855980300407`*^9, 3.9584857571681767`*^9}, {3.9585631972348843`*^9, 
   3.958563270175228*^9}, {3.9586483651775208`*^9, 3.9586483839486504`*^9}, {
   3.9606184828761806`*^9, 3.9606184830357056`*^9}, {3.960618520853962*^9, 
   3.960618566087036*^9}, {3.96061917260322*^9, 3.960619179558695*^9}, {
   3.96062418676515*^9, 3.9606242260129642`*^9}, {3.9606242996336327`*^9, 
   3.9606244039201603`*^9}, {3.9606244451670628`*^9, 
   3.9606244605017242`*^9}, {3.960624571240589*^9, 3.9606247244777203`*^9}, {
   3.9606248395292587`*^9, 3.960624907388809*^9}, {3.960625017973652*^9, 
   3.9606251332359047`*^9}, {3.9606251942788773`*^9, 
   3.9606252659249496`*^9}, {3.96062530083716*^9, 3.9606253855435944`*^9}, {
   3.9606271550153275`*^9, 
   3.9606271555855236`*^9}},ExpressionUUID->"21114629-264b-e440-bf4b-\
78fe291e6328"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefPartialPartialAUX", "]"}], ":=", " ", 
   RowBox[{
    RowBox[{"Options", "[", "DefTensor", "]"}], "~", "Join", "~", 
    RowBox[{"{", 
     RowBox[{"PrintInverse", " ", "->", " ", "False"}], "}"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"DefPartialPartialAUX", "[", 
   RowBox[{
    RowBox[{"function_", "?", "ScalarFunctionQ"}], ",", "flippedindices_", ",",
     "fields_List", ",", 
    RowBox[{"options", ":", 
     RowBox[{"OptionsPattern", "[", 
      RowBox[{"Options", "[", "DefPartialPartialAUX", "]"}], "]"}]}]}], "]"}],
   " ", ":=", " ", 
  RowBox[{"Module", "[", "\n", "\t", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "finaltensor", ",", "daggerfinaltensor", ",", "daggerfunction", ",", 
      "daggerfields", ",", "NameVar", ",", "NameVarDagger", ",", 
      "Dependencies", ",", "Grade", ",", "Weight", ",", "NumberOfIndices", ",",
       "NumberOfAccumulatedIndices", ",", "symmetries", ",", "tensorindices", 
      ",", "aux", ",", "repeatedtensorswithindices", ",", "exchangerepeated", 
      ",", "NumberOfImaginaryTensors"}], "}"}], ",", "     ", "\n", "    ", 
    "\n", "    ", 
    RowBox[{
     RowBox[{"MakexTensions", "[", 
      RowBox[{
      "DefPartialPartialAUX", ",", "\"\<Beginning\>\"", ",", "function", ",", 
       "fields", ",", "options"}], "]"}], ";", " ", "\n", "    ", "\n", 
     "    ", 
     RowBox[{"daggerfunction", "=", 
      RowBox[{
       RowBox[{"Dagger", "@", "function"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"MultiplyHead", "[", 
          RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}]}], ";", 
     "\n", "    ", 
     RowBox[{"daggerfields", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{
        RowBox[{"Dagger", "/@", "fields"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"MultiplyHead", "[", 
           RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}], 
       "]"}]}], ";", "\n", "\t", 
     RowBox[{"NameVar", "=", 
      RowBox[{"GeneratePartialPartialName", "[", 
       RowBox[{"function", ",", "fields", ",", 
        RowBox[{"FilterRules", "[", 
         RowBox[{
          RowBox[{"{", "options", "}"}], ",", 
          RowBox[{"Options", "[", "GeneratePartialPartialName", "]"}]}], 
         "]"}]}], "]"}]}], ";", "\n", "\t", 
     RowBox[{"NameVarDagger", "=", 
      RowBox[{"GeneratePartialPartialName", "[", 
       RowBox[{"daggerfunction", ",", "daggerfields", ",", 
        RowBox[{"FilterRules", "[", 
         RowBox[{
          RowBox[{"{", "options", "}"}], ",", 
          RowBox[{"Options", "[", "GeneratePartialPartialName", "]"}]}], 
         "]"}]}], "]"}]}], ";", "\n", "\t", "\n", "\t", 
     RowBox[{"Dependencies", "=", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"DependenciesOfTensor", "/@", "fields"}], "]"}], "//", 
       "DeleteDuplicates"}]}], ";", "\n", "\t", 
     RowBox[{"Grade", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"VertDeg", "[", "function", "]"}], "-", 
        RowBox[{"VertDeg", "/@", "fields"}]}], " ", "//", " ", "adding"}]}], ";",
      "\n", "\t", 
     RowBox[{"Weight", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"WeightOf", "[", "function", "]"}], "-", 
        RowBox[{"WeightOfTensor", "/@", "fields"}]}], " ", "//", " ", 
       "adding"}]}], ";", "\n", "\t", "\n", "\t", 
     RowBox[{"NumberOfIndices", "=", 
      RowBox[{"Length", "/@", 
       RowBox[{"SlotsOfTensor", "/@", "fields"}]}]}], ";", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"NumberOfAccumulatedIndices", "=", 
      RowBox[{"Most", "@", 
       RowBox[{"FoldList", "[", 
        RowBox[{"Plus", ",", "0", ",", "NumberOfIndices"}], "]"}]}]}], ";", 
     "\n", "\t", "\n", "\t", 
     RowBox[{"repeatedtensorswithindices", "=", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"NumberOfAccumulatedIndices", "+", "1"}], ",", 
           "NumberOfIndices", ",", "fields"}], "}"}], "]"}], ",", "Last"}], 
       "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "We", " ", "keep", " ", "track", " ", "of", " ", "repeated", " ", 
        "tensors", " ", "since", " ", "they", " ", "can", " ", "be", " ", 
        "exchanged"}], ",", " ", 
       RowBox[{
       "notice", " ", "that", " ", "they", " ", "are", " ", "always", " ", 
        "consecutive", " ", "sin", " ", "fields", " ", "is", " ", 
        "ordered"}]}], " ", "*)"}], "\n", "\t", 
     RowBox[{"repeatedtensorswithindices", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Most", " ", "/@", " ", "#"}], " ", "&"}], ",", " ", 
        "repeatedtensorswithindices"}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "We", " ", "remove", " ", "the", " ", "tensor", " ", "that", " ", "is", 
       " ", "stored", " ", "in", " ", "the", " ", "last", " ", "coordinate"}],
       " ", "*)"}], "\n", "    ", 
     RowBox[{"repeatedtensorswithindices", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"repeatedtensorswithindices", ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "#", "]"}], ">", "1"}], "&&", 
          RowBox[{
           RowBox[{
            RowBox[{"First", "[", "#", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], ">", "0"}]}], "&"}]}], "]"}]}], ";",
      "\n", "    ", 
     RowBox[{"exchangerepeated", "=", 
      RowBox[{
       RowBox[{"GenerateCycles", "/@", 
        RowBox[{"IndexRanges", "/@", "repeatedtensorswithindices"}]}], "//", 
       "Flatten"}]}], ";", "\n", "     ", "\[IndentingNewLine]", "\t", 
     RowBox[{"symmetries", "=", 
      RowBox[{"GenSet", "@@", 
       RowBox[{"(", 
        RowBox[{"exchangerepeated", "~", "Join", "~", 
         RowBox[{"JoinGenSet", "@", 
          RowBox[{"applyShifts", "[", 
           RowBox[{
            RowBox[{"SymmetryGroupOfTensor", "/@", "fields"}], ",", 
            "NumberOfAccumulatedIndices"}], "]"}]}]}], ")"}]}]}], ";", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "We", " ", "add", " ", "the", " ", "symmetries", " ", "of", " ", "each",
        " ", "tensor", " ", "and", " ", "also", " ", "the", " ", "exchange", " ",
        "of", " ", "repeated", " ", "tensors"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"symmetries", "=", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{
        RowBox[{"Array", "[", 
         RowBox[{"Identity", ",", 
          RowBox[{
           RowBox[{"Last", "@", "NumberOfAccumulatedIndices"}], "+", 
           RowBox[{"Length", "@", 
            RowBox[{"SlotsOfTensor", "@", 
             RowBox[{"Last", "@", "fields"}]}]}]}]}], "]"}], ",", 
        "symmetries"}], "]"}]}], ";", "\n", "\t\t", "\n", "       ", "\n", 
     "   ", 
     RowBox[{
      RowBox[{"xTensorQ", "[", "aux", "]"}], "^=", "True"}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Little", " ", "trick", " ", "to", " ", "force", " ", "nice", " ", 
       "indices", " ", "in", " ", 
       RowBox[{"DefInfoQ", ".", " ", "I"}], " ", "am", " ", "sure", " ", 
       "there", " ", "must", " ", "be", " ", "a", " ", "better", " ", "way"}],
       " ", "*)"}], "\n", "   ", 
     RowBox[{
      RowBox[{"SlotsOfTensor", "[", "aux", "]"}], "^=", 
      RowBox[{"VBundleOfIndex", "/@", "flippedindices"}]}], ";", "\n", "   ", 
     RowBox[{"tensorindices", "=", 
      RowBox[{
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVar", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "@@", 
       RowBox[{"(", " ", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{"aux", " ", "@@", " ", 
            RowBox[{"(", "flippedindices", ")"}]}], "//", 
           "ScreenDollarIndices"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{"aux", "->", "IndexList"}], "}"}]}], ")"}]}]}], ";", "\n", 
     "   ", 
     RowBox[{"Clear", "[", "aux", "]"}], ";", "\n", "   ", "\n", "\t", "\n", 
     "   ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"OptionValue", "[", "PrintInverse", "]"}], ",", "\n", "\t ", 
       RowBox[{"(", "\n", "\t ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"PartialPartial", "[", "function", "]"}], "[", 
           RowBox[{"ToExpression", "/@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"InvName", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"PrintInverse", " ", "->", " ", "True"}]}], "]"}], 
               "&"}], "/@", "fields"}], ")"}]}], "]"}], "=", " ", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"NameVar", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", "\t ", 
         RowBox[{
          RowBox[{
           RowBox[{"PartialPartial", "[", "daggerfunction", "]"}], "[", 
           RowBox[{"ToExpression", "/@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"InvName", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"PrintInverse", " ", "->", " ", "True"}]}], "]"}], 
               "&"}], "/@", "daggerfields"}], ")"}]}], "]"}], "=", " ", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"NameVarDagger", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\n", "\t ", 
        ")"}], ",", "\n", "\t ", 
       RowBox[{"(", "\n", "\t ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"PartialPartial", "[", "function", "]"}], "[", "fields", 
           "]"}], "=", " ", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"NameVar", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", "\t ", 
         RowBox[{
          RowBox[{
           RowBox[{"PartialPartial", "[", "daggerfunction", "]"}], "[", 
           "daggerfields", "]"}], "=", " ", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"NameVarDagger", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\n", "\t ", 
        ")"}]}], "\n", "   ", "]"}], ";", "\n", "   ", "\n", "   ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "These", " ", "two", " ", "definitions", " ", "are", " ", "needed", " ",
        "before", " ", "DefTensor", " ", "for", " ", "Complex", " ", 
       "tensors"}], " ", "*)"}], "\n", "   ", 
     RowBox[{
      RowBox[{"NameOfDaggerPartialPartial", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVar", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"NameVarDagger", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", "   ", 
     RowBox[{
      RowBox[{"PartialPartialQ", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVar", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      "True"}], ";", "\n", "   ", 
     RowBox[{
      RowBox[{"PartialPartialQ", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVarDagger", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      "True"}], ";", "\n", "\n", "   ", 
     RowBox[{"DefTensor", "[", 
      RowBox[{"tensorindices", ",", "Dependencies", ",", "symmetries", ",", 
       RowBox[{"FilterRules", "[", 
        RowBox[{
         RowBox[{"{", "options", "}"}], ",", 
         RowBox[{"Options", "[", "DefTensor", "]"}]}], "]"}], ",", " ", 
       RowBox[{"PrintAs", " ", "->", " ", 
        RowBox[{"NameVar", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
       RowBox[{"VertDeg", " ", "->", " ", "Grade"}], ",", " ", 
       RowBox[{"WeightOfTensor", " ", "->", " ", "Weight"}], ",", 
       RowBox[{"DefineExactFormAfterDefTensor", "->", "False"}], ",", 
       RowBox[{"DefineVariationalVectorAfterDefTensor", "->", "False"}]}], 
      "]"}], ";", "\n", "\n", "   ", 
     RowBox[{"NumberOfImaginaryTensors", "=", 
      RowBox[{"Count", "[", 
       RowBox[{
        RowBox[{"Dagger", "/@", 
         RowBox[{"Join", "[", 
          RowBox[{"fields", ",", 
           RowBox[{"{", "function", "}"}]}], "]"}]}], ",", 
        RowBox[{"MultiplyHead", "[", 
         RowBox[{"_", ",", "_"}], "]"}]}], "]"}]}], ";", "\n", "   ", 
     RowBox[{
      RowBox[{"NumberOfImaginaryOfPartialPartial", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVar", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      "NumberOfImaginaryTensors"}], ";", "\n", "   ", 
     RowBox[{
      RowBox[{"NumberOfImaginaryOfPartialPartial", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVarDagger", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      "NumberOfImaginaryTensors"}], ";", "\n", "      ", "\n", "   ", 
     RowBox[{
      RowBox[{"OrderOfPartialPartial", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVar", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      RowBox[{"Length", "@", "fields"}]}], ";", "\n", "   ", 
     RowBox[{
      RowBox[{"OrderOfPartialPartial", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVarDagger", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      RowBox[{"Length", "@", "fields"}]}], ";", "\n", "      ", "\n", "   ", 
     RowBox[{
      RowBox[{"FunctionOfPartialPartial", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVar", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      "function"}], ";", "\n", "   ", 
     RowBox[{
      RowBox[{"FunctionOfPartialPartial", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVarDagger", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      "daggerfunction"}], ";", "\n", "      ", "\n", "   ", 
     RowBox[{
      RowBox[{"PartialPartialsOfFunction", "[", "function", "]"}], "^=", 
      RowBox[{
       RowBox[{"PartialPartialsOfFunction", "[", "function", "]"}], "~", 
       "Union", "~", 
       RowBox[{"{", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"NameVar", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], "}"}]}]}], ";", "\n", "   ", 
     RowBox[{
      RowBox[{"PartialPartialsOfFunction", "[", "daggerfunction", "]"}], "^=", 
      RowBox[{
       RowBox[{"PartialPartialsOfFunction", "[", "daggerfunction", "]"}], "~",
        "Union", "~", 
       RowBox[{"{", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"NameVarDagger", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], "}"}]}]}], ";", "\n", 
     "      ", "\n", "   ", 
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"PartialPartialsOfTensor", "[", "#", "]"}], " ", "^=", " ", 
          RowBox[{
           RowBox[{"PartialPartialsOfTensor", "[", "#", "]"}], "~", "Union", "~", 
           RowBox[{"{", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"NameVar", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "}"}]}]}], ")"}], " ", 
        "&"}], ",", " ", "fields"}], "]"}], ";", "\n", "   ", 
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"PartialPartialsOfTensor", "[", "#", "]"}], " ", "^=", " ", 
          RowBox[{
           RowBox[{"PartialPartialsOfTensor", "[", "#", "]"}], "~", "Union", "~", 
           RowBox[{"{", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"NameVarDagger", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "}"}]}]}], ")"}], " ", 
        "&"}], ",", " ", "daggerfields"}], "]"}], ";", "\n", "      ", "\n", 
     "   ", 
     RowBox[{
      RowBox[{"PlacementOfIndices", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVar", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      RowBox[{"NumberOfAccumulatedIndices", "+", "1"}]}], ";", "\n", "   ", 
     RowBox[{
      RowBox[{"PlacementOfIndices", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVarDagger", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      RowBox[{"NumberOfAccumulatedIndices", "+", "1"}]}], ";", "\n", "      ",
      "\n", "   ", 
     RowBox[{
      RowBox[{"TensorsOfPartialPartial", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVar", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      "fields"}], ";", "\n", "   ", 
     RowBox[{
      RowBox[{"TensorsOfPartialPartial", "[", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"NameVarDagger", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "^=", " ", 
      "daggerfields"}], ";", "\n", "      ", "\n", "   ", 
     RowBox[{
      RowBox[{"PrintAs", "[", 
       RowBox[{"Evaluate", "[", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"NameVar", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "]"}], "^=", 
      RowBox[{"NameVar", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "This", " ", "prevents", " ", "the", " ", "densities", " ", "to", " ", 
        "have", " ", "two", " ", "sets", " ", "of", " ", "tildes"}], ",", " ", 
       RowBox[{
       "only", " ", "the", " ", "ones", " ", "coming", " ", "from", " ", 
        "the", " ", "tensor", " ", "remained"}]}], " ", "*)"}], " ", "\n", 
     "   ", 
     RowBox[{
      RowBox[{"PrintAs", "[", 
       RowBox[{"Evaluate", "[", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"NameVarDagger", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "]"}], "^=", 
      RowBox[{"NameVarDagger", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "This", " ", "prevents", " ", "the", " ", "densities", " ", "to", " ", 
        "have", " ", "two", " ", "sets", " ", "of", " ", "tildes"}], ",", " ", 
       RowBox[{
       "only", " ", "the", " ", "ones", " ", "coming", " ", "from", " ", 
        "the", " ", "tensor", " ", "remained"}]}], " ", "*)"}], " ", "\n", 
     "      ", "\n", "   ", 
     RowBox[{"finaltensor", "=", 
      RowBox[{
       RowBox[{"PartialPartial", "[", "function", "]"}], "[", "fields", 
       "]"}]}], ";", "\n", "   ", 
     RowBox[{"daggerfinaltensor", "=", 
      RowBox[{
       RowBox[{"PartialPartial", "[", "daggerfunction", "]"}], "[", 
       "daggerfields", "]"}]}], ";", "\n", "   ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"OddQ", "[", "NumberOfImaginaryTensors", "]"}], ",", "\n", 
       "      ", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"finaltensorSym", " ", "=", " ", "finaltensor"}], ",", " ", 
           RowBox[{
           "daggerfinaltensorSym", " ", "=", " ", "daggerfinaltensor"}]}], 
          "}"}], ",", "\n", "\t    ", 
         RowBox[{
          RowBox[{"finaltensorSym", "/:", " ", 
           RowBox[{"Dagger", "[", "finaltensorSym", "]"}], " ", ":=", 
           RowBox[{"MultiplyHead", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "daggerfinaltensorSym"}], "]"}]}], ";", 
          "\n", "\t    ", 
          RowBox[{"daggerfinaltensorSym", "/:", " ", 
           RowBox[{"Dagger", "[", "daggerfinaltensorSym", "]"}], " ", ":=", 
           RowBox[{"MultiplyHead", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "finaltensorSym"}], "]"}]}], ";"}]}], 
        "\n", "\t  ", "]"}]}], "\n", "    ", "]"}], ";", "\n", "       ", 
     "\n", "    ", 
     RowBox[{"MakexTensions", "[", 
      RowBox[{
      "DefPartialPartialAUX", ",", "\"\<End\>\"", ",", "function", ",", 
       "fields", ",", "options"}], "]"}], ";"}]}], " ", "\n", 
   "]"}]}]}], "Code",
 CellChangeTimes->{{3.933406921174345*^9, 3.933407006640181*^9}, {
   3.93340771717714*^9, 3.933407771524101*^9}, {3.933407842889041*^9, 
   3.93340784593215*^9}, {3.9334078825734615`*^9, 3.9334079049310675`*^9}, {
   3.9334080926353464`*^9, 3.933408122023637*^9}, {3.933408160283249*^9, 
   3.9334081613326297`*^9}, {3.933408447319936*^9, 3.93340851503378*^9}, {
   3.933408882271353*^9, 3.933408956675268*^9}, {3.933408995312349*^9, 
   3.9334091265815077`*^9}, {3.933409440623533*^9, 3.933409490059602*^9}, {
   3.933409545667935*^9, 3.933409559526745*^9}, {3.933409624818842*^9, 
   3.93340968019966*^9}, {3.933409723362918*^9, 3.933409797572757*^9}, {
   3.933409841995154*^9, 3.933409903386168*^9}, {3.933410016236034*^9, 
   3.9334100170103254`*^9}, {3.9334100531015844`*^9, 
   3.9334101535947943`*^9}, {3.933410213453788*^9, 3.9334102938915176`*^9}, {
   3.933410670619817*^9, 3.933410671122767*^9}, {3.933411456200949*^9, 
   3.933411475574125*^9}, {3.9373053795156136`*^9, 3.9373053795797997`*^9}, {
   3.937306157878441*^9, 3.937306158292214*^9}, {3.937306269018829*^9, 
   3.937306280620297*^9}, {3.937362968152558*^9, 3.937363066875798*^9}, {
   3.9373635762592773`*^9, 3.9373635793472366`*^9}, {3.9373637019161606`*^9, 
   3.9373637019948044`*^9}, {3.937364029159052*^9, 3.937364074760332*^9}, {
   3.937364160565178*^9, 3.9373642237654514`*^9}, {3.937364626859802*^9, 
   3.9373646290816097`*^9}, {3.937364804658905*^9, 3.9373648143460846`*^9}, 
   3.9373650753211765`*^9, {3.937365160977658*^9, 3.937365161177868*^9}, {
   3.93736524282288*^9, 3.9373652518743896`*^9}, 3.937366133935508*^9, {
   3.937366464171404*^9, 3.937366465559313*^9}, {3.937366714972174*^9, 
   3.93736683314686*^9}, {3.9373668696511135`*^9, 3.9373668738567257`*^9}, 
   3.937367152464058*^9, {3.937381458278471*^9, 3.937381460322121*^9}, {
   3.937382179729217*^9, 3.9373821871093655`*^9}, {3.937382272833767*^9, 
   3.93738227918374*^9}, {3.9373829827542133`*^9, 3.9373830044843655`*^9}, {
   3.937383112477118*^9, 3.937383128406254*^9}, {3.937383895232533*^9, 
   3.937383895848821*^9}, {3.937383979975384*^9, 3.937383992360611*^9}, {
   3.937384052760938*^9, 3.93738405848674*^9}, {3.937384221115248*^9, 
   3.937384260528507*^9}, {3.937384391670376*^9, 3.937384404020799*^9}, {
   3.937384497745165*^9, 3.937384501494868*^9}, {3.93738464225375*^9, 
   3.937384650017959*^9}, 3.938528850420394*^9, {3.938529030271578*^9, 
   3.938529042232601*^9}, {3.93852907865707*^9, 3.938529094223398*^9}, {
   3.938529145716605*^9, 3.9385291704070425`*^9}, {3.938529256747004*^9, 
   3.938529280811816*^9}, {3.938529321822528*^9, 3.9385294680946264`*^9}, {
   3.938529564637632*^9, 3.9385296067599936`*^9}, {3.938529850742167*^9, 
   3.9385298660436287`*^9}, {3.938582918775227*^9, 3.938582930285669*^9}, {
   3.938594715950249*^9, 3.938594736281033*^9}, {3.938594788648814*^9, 
   3.938594789458813*^9}, {3.938596500086594*^9, 3.938596500091591*^9}, 
   3.938679596908964*^9, {3.9386796499477134`*^9, 3.938679660829779*^9}, {
   3.9386797045233345`*^9, 3.938679842763437*^9}, {3.938679924888153*^9, 
   3.938679932976369*^9}, {3.93867997252408*^9, 3.938680058911319*^9}, {
   3.938680098264307*^9, 3.938680121079299*^9}, {3.9386801709920273`*^9, 
   3.938680199147262*^9}, {3.941629361792519*^9, 3.941629382579403*^9}, {
   3.941631155549241*^9, 3.941631168407516*^9}, {3.941631294551567*^9, 
   3.941631296763277*^9}, {3.9416340220557013`*^9, 3.9416340268606615`*^9}, {
   3.941634115960855*^9, 3.941634150923091*^9}, {3.941649990721203*^9, 
   3.9416500070426826`*^9}, {3.944276817550635*^9, 3.944276863982127*^9}, {
   3.944277097594197*^9, 3.944277099630007*^9}, {3.944277131777954*^9, 
   3.944277136002495*^9}, {3.9442779222103453`*^9, 3.944277926011027*^9}, {
   3.948400213696924*^9, 3.9484002389988995`*^9}, {3.948544995822412*^9, 
   3.9485450766366043`*^9}, {3.948545415731119*^9, 3.948545436275989*^9}, {
   3.948561574418477*^9, 3.94856157551278*^9}, {3.948911702624031*^9, 
   3.9489117054498653`*^9}, {3.9489128784257298`*^9, 3.948912895855831*^9}, {
   3.9489131642818203`*^9, 3.948913167584549*^9}, 3.948913791353824*^9, {
   3.948914236124546*^9, 3.94891423626228*^9}, {3.949167742007576*^9, 
   3.949167752060467*^9}, {3.949167831067356*^9, 3.9491678315811596`*^9}, {
   3.949168415701826*^9, 3.949168486193968*^9}, {3.949168601901099*^9, 
   3.9491686080862904`*^9}, {3.9491731744043674`*^9, 3.949173174656637*^9}, {
   3.949173318272003*^9, 3.9491733881202736`*^9}, 3.9493481088564305`*^9, {
   3.949515733119776*^9, 3.9495157375996857`*^9}, {3.950124003524918*^9, 
   3.950124017730396*^9}, {3.950284700456896*^9, 3.950284756956906*^9}, {
   3.950284825621414*^9, 3.95028484735746*^9}, {3.950284905158785*^9, 
   3.950284942963383*^9}, {3.9502849842260075`*^9, 3.950285035620806*^9}, {
   3.950285125301064*^9, 3.950285148418938*^9}, {3.950285187538789*^9, 
   3.950285254179893*^9}, {3.950285310329048*^9, 3.9502854090233727`*^9}, {
   3.950285496855503*^9, 3.950285523088554*^9}, {3.9502855999913673`*^9, 
   3.950285613742403*^9}, {3.950285645467645*^9, 3.95028567834717*^9}, {
   3.950285956496371*^9, 3.950285987080471*^9}, 3.9502860301665325`*^9, {
   3.9502863444280663`*^9, 3.9502863724001083`*^9}, {3.950286446430664*^9, 
   3.9502865157236023`*^9}, {3.9502865772245274`*^9, 3.950286585334236*^9}, {
   3.950286718679405*^9, 3.950286755746117*^9}, 3.950287008544659*^9, {
   3.95028716376013*^9, 3.950287166501812*^9}, {3.950287233027176*^9, 
   3.950287234361564*^9}, {3.9502873280139465`*^9, 3.9502873290926304`*^9}, 
   3.950287359280592*^9, 3.9502874261965637`*^9, {3.950287734161017*^9, 
   3.950287764207033*^9}, {3.950288274908495*^9, 3.950288308699247*^9}, {
   3.950288387475679*^9, 3.95028839619329*^9}, {3.950289092322672*^9, 
   3.9502892219454*^9}, 3.950289259735361*^9, {3.9502893150156517`*^9, 
   3.9502893265394726`*^9}, {3.950289356657509*^9, 3.9502894130269127`*^9}, {
   3.950289599208252*^9, 3.9502896641101303`*^9}, 3.950289787356674*^9, {
   3.950290059341688*^9, 3.950290120317436*^9}, {3.950294685128439*^9, 
   3.95029472592894*^9}, {3.950294832495619*^9, 3.950294862585589*^9}, {
   3.950294938361325*^9, 3.950294945539091*^9}, {3.9502950702265224`*^9, 
   3.9502950784210835`*^9}, {3.950295285259487*^9, 3.950295287827811*^9}, 
   3.950295339321804*^9, {3.950295371230142*^9, 3.9502954311813335`*^9}, 
   3.950295494745037*^9, {3.950295615632918*^9, 3.950295624959718*^9}, {
   3.950297386075203*^9, 3.950297436332136*^9}, {3.950297477358675*^9, 
   3.9502975636404247`*^9}, {3.9502976564101357`*^9, 3.950297662636419*^9}, 
   3.9502991139286327`*^9, {3.951224293688961*^9, 3.951224397669229*^9}, {
   3.951309164139301*^9, 3.95130919024996*^9}, {3.954941273808172*^9, 
   3.9549412992345657`*^9}, {3.9549424878882523`*^9, 3.954942502495722*^9}, {
   3.9550955241050587`*^9, 3.955095530906025*^9}, {3.9551202951840153`*^9, 
   3.9551202991293755`*^9}, 3.9551231099541664`*^9, {3.9551250698491783`*^9, 
   3.9551250836562157`*^9}, {3.9551251910534573`*^9, 3.955125227344343*^9}, {
   3.9551252606372185`*^9, 3.9551252951318665`*^9}, {3.955125566306019*^9, 
   3.9551255666478024`*^9}, {3.955125785153406*^9, 3.9551257934579144`*^9}, {
   3.9552023640702686`*^9, 3.955202386378977*^9}, {3.9552025605017834`*^9, 
   3.9552025734718857`*^9}, {3.9552027516272717`*^9, 3.955202775688017*^9}, {
   3.9552046813476276`*^9, 3.9552047270457134`*^9}, {3.9552048725942726`*^9, 
   3.955204874098255*^9}, {3.9552049812753735`*^9, 3.955204999850292*^9}, {
   3.955205118923311*^9, 3.955205128322521*^9}, 3.9552054090935993`*^9, {
   3.9552057368385506`*^9, 3.9552057791278057`*^9}, {3.9552058467302513`*^9, 
   3.9552058563251095`*^9}, {3.9552059176741447`*^9, 
   3.9552059289503098`*^9}, {3.95520598966263*^9, 3.95520602547036*^9}, {
   3.9552060871630955`*^9, 3.95520608899139*^9}, {3.9552061416724854`*^9, 
   3.9552061464953384`*^9}, 3.955206182573513*^9, {3.9552063767825165`*^9, 
   3.955206398877365*^9}, {3.955206468638525*^9, 3.9552064740265102`*^9}, {
   3.9552066515653954`*^9, 3.9552066614091816`*^9}, {3.955207153359255*^9, 
   3.9552071658046494`*^9}, {3.955207339828703*^9, 3.9552073797555065`*^9}, {
   3.9552075048559456`*^9, 3.955207545604061*^9}, {3.9552081450733585`*^9, 
   3.955208280976879*^9}, {3.955208357635412*^9, 3.9552083578315735`*^9}, {
   3.955208598169855*^9, 3.955208716401058*^9}, 3.955208751221863*^9, {
   3.955210748676075*^9, 3.9552107507517014`*^9}, {3.9553649785342712`*^9, 
   3.9553649919565887`*^9}, {3.955486120855219*^9, 3.9554861549895687`*^9}, {
   3.9554862045438232`*^9, 3.955486234456749*^9}, {3.955486271628105*^9, 
   3.955486478564436*^9}, {3.955486526046612*^9, 3.955486608531473*^9}, {
   3.9554868455198803`*^9, 3.955486861767929*^9}, {3.9554873595415993`*^9, 
   3.9554874030025043`*^9}, {3.955487456025692*^9, 3.955487457281658*^9}, {
   3.9554900726422577`*^9, 3.9554900887700977`*^9}, {3.955490373310919*^9, 
   3.9554904099387817`*^9}, {3.9557087181133633`*^9, 3.955708721104252*^9}, {
   3.955709935947584*^9, 3.955710004383169*^9}, {3.9557105873033237`*^9, 
   3.9557107877115154`*^9}, {3.955711240785671*^9, 3.955711312822052*^9}, {
   3.955711366477255*^9, 3.9557113707785454`*^9}, {3.9557225663015976`*^9, 
   3.9557226058054657`*^9}, {3.9557232066888657`*^9, 
   3.9557232384447556`*^9}, {3.9557233407322063`*^9, 3.955723393406267*^9}, {
   3.9557260084051876`*^9, 3.9557260106718426`*^9}, {3.955726269361183*^9, 
   3.955726276837961*^9}, {3.955726674548918*^9, 3.955726676229044*^9}, {
   3.9557283464677067`*^9, 3.955728358497925*^9}, {3.9557284021227417`*^9, 
   3.9557284026307583`*^9}, {3.9557285336268005`*^9, 3.955728545648876*^9}, {
   3.955728586647661*^9, 3.9557285876822357`*^9}, {3.955728623034319*^9, 
   3.955728755191721*^9}, {3.955728787645729*^9, 3.955728814741436*^9}, {
   3.9557288655618534`*^9, 3.9557288983048744`*^9}, {3.9557289578842583`*^9, 
   3.955728958580055*^9}, {3.955729175761841*^9, 3.955729206234621*^9}, {
   3.955729239767454*^9, 3.95572925370459*^9}, {3.955729502709879*^9, 
   3.9557295068638077`*^9}, 3.9557295702078896`*^9, {3.9557301156950054`*^9, 
   3.955730161714983*^9}, {3.9557302077822704`*^9, 3.955730343359766*^9}, {
   3.9557303839690304`*^9, 3.9557304182352524`*^9}, {3.9557305095942287`*^9, 
   3.9557305127982826`*^9}, {3.9557305479677086`*^9, 3.955730556374346*^9}, {
   3.955730684664364*^9, 3.9557306919220905`*^9}, {3.955730759716194*^9, 
   3.955730766879648*^9}, {3.9557323252475357`*^9, 3.955732410310137*^9}, {
   3.9557324581919327`*^9, 3.955732470599989*^9}, {3.955732548287533*^9, 
   3.955732578902458*^9}, {3.9557327115089607`*^9, 3.955732796811426*^9}, {
   3.9557329676551495`*^9, 3.955733004854233*^9}, 3.9557330493763447`*^9, {
   3.9557331019930935`*^9, 3.955733109255745*^9}, {3.9557331881572533`*^9, 
   3.9557331884496937`*^9}, {3.95573324900634*^9, 3.955733252470108*^9}, 
   3.9557334740970497`*^9, {3.955733598989912*^9, 3.955733661061657*^9}, {
   3.955733747803993*^9, 3.9557337848683643`*^9}, {3.9557338461929207`*^9, 
   3.955733875547636*^9}, {3.955733909693365*^9, 3.9557339596249866`*^9}, {
   3.955734729447075*^9, 3.955734737158537*^9}, {3.9557347942684727`*^9, 
   3.9557348037076244`*^9}, {3.9557348602975845`*^9, 3.955734872929369*^9}, {
   3.9557349044307537`*^9, 3.9557350391438503`*^9}, {3.9557351470838795`*^9, 
   3.9557351575934067`*^9}, {3.955735227215435*^9, 3.955735232237259*^9}, {
   3.9557352905283737`*^9, 3.955735384052183*^9}, {3.955735424405361*^9, 
   3.9557354282494392`*^9}, {3.95573548353224*^9, 3.95573549951334*^9}, 
   3.9557355323072643`*^9, {3.955735587142748*^9, 3.955735591697075*^9}, {
   3.95573582909309*^9, 3.955735903784092*^9}, {3.9557359765729713`*^9, 
   3.955736062900154*^9}, {3.955736630135189*^9, 3.9557366424506397`*^9}, {
   3.9557369531787186`*^9, 3.9557370067165775`*^9}, {3.9557370516172447`*^9, 
   3.955737054113695*^9}, {3.9557371895146065`*^9, 3.955737222925417*^9}, {
   3.9557372799151764`*^9, 3.9557372877894993`*^9}, {3.9557373245643063`*^9, 
   3.9557373278771114`*^9}, {3.955737380691475*^9, 3.9557373935084496`*^9}, {
   3.95573743143256*^9, 3.9557374830409565`*^9}, 3.955737602886736*^9, {
   3.9557376633275223`*^9, 3.9557376693174057`*^9}, {3.9557377170668507`*^9, 
   3.9557377653897495`*^9}, 3.9557378397218666`*^9, {3.9557379218511047`*^9, 
   3.955737974116625*^9}, {3.955738041039379*^9, 3.9557380993551636`*^9}, {
   3.9557382385549736`*^9, 3.9557383094195175`*^9}, {3.9557386507080345`*^9, 
   3.9557386791675644`*^9}, {3.9557399490018044`*^9, 3.955739996163601*^9}, {
   3.9557400272892284`*^9, 3.9557400347480392`*^9}, {3.955740907043537*^9, 
   3.955740930405205*^9}, {3.955741010122961*^9, 3.955741012375967*^9}, {
   3.9557411958340473`*^9, 3.9557411979832497`*^9}, 3.9557418779329987`*^9, {
   3.9557445506033688`*^9, 3.955744561330147*^9}, {3.9557450020946007`*^9, 
   3.955745005004635*^9}, {3.955745045936535*^9, 3.955745060101776*^9}, {
   3.955745208943289*^9, 3.955745264484741*^9}, {3.955746914273817*^9, 
   3.9557469166988354`*^9}, {3.9557480870234814`*^9, 3.955748103305029*^9}, {
   3.95574818812138*^9, 3.9557481943742504`*^9}, {3.955748945524435*^9, 
   3.9557489663354206`*^9}, {3.955749002818165*^9, 3.955749019834467*^9}, {
   3.9557491274726048`*^9, 3.955749147639477*^9}, {3.9557491966182747`*^9, 
   3.955749214615715*^9}, {3.9557493146959496`*^9, 3.9557493310136375`*^9}, {
   3.9557504917649097`*^9, 3.9557505012806873`*^9}, {3.9557513764351406`*^9, 
   3.955751397971775*^9}, 3.955794950499161*^9, {3.9557950275848904`*^9, 
   3.95579506527598*^9}, {3.9558005131548996`*^9, 3.955800629156908*^9}, {
   3.9558006702263737`*^9, 3.9558007313219185`*^9}, {3.9558010945614033`*^9, 
   3.9558011487779865`*^9}, {3.955801609793604*^9, 3.9558016295523014`*^9}, 
   3.955802060725424*^9, {3.95580216971023*^9, 3.9558021706597767`*^9}, {
   3.9558205398323784`*^9, 3.9558205506273746`*^9}, {3.955820585788954*^9, 
   3.9558205862434235`*^9}, {3.9558224959054413`*^9, 
   3.9558224960233555`*^9}, {3.9558237433220196`*^9, 
   3.9558237492612686`*^9}, {3.9564114610322857`*^9, 3.956411498967573*^9}, {
   3.9564116192608376`*^9, 3.956411672805937*^9}, {3.956419780634617*^9, 
   3.956419786599554*^9}, {3.9564212312897224`*^9, 3.956421256978323*^9}, 
   3.957268255321184*^9, {3.9572785805999374`*^9, 3.957278605397476*^9}, {
   3.957325351214628*^9, 3.9573253826951923`*^9}, {3.9573272691485977`*^9, 
   3.9573273003522625`*^9}, {3.957327399850071*^9, 3.9573274034850082`*^9}, {
   3.9573275052893906`*^9, 3.957327507421837*^9}, {3.9573275780369053`*^9, 
   3.957327600583479*^9}, {3.957327636267252*^9, 3.957327725673252*^9}, 
   3.957352230377947*^9, {3.957398330714018*^9, 3.957398337077276*^9}, {
   3.9577041180296307`*^9, 3.957704120051716*^9}, {3.958128147081459*^9, 
   3.9581281523586617`*^9}, {3.9581506604001827`*^9, 
   3.9581506633785305`*^9}, {3.958315980961958*^9, 3.958315989770405*^9}, {
   3.9583160213566093`*^9, 3.958316022100807*^9}, {3.95831606888863*^9, 
   3.958316380714737*^9}, {3.958316732680231*^9, 3.9583167819046135`*^9}, {
   3.958318946258505*^9, 3.958318948601156*^9}, {3.9583943153155975`*^9, 
   3.958394344050541*^9}, {3.958415391243946*^9, 3.9584154070442867`*^9}, {
   3.958415468400074*^9, 3.9584154940833282`*^9}, 3.9584156157352104`*^9, {
   3.9584157873401527`*^9, 3.9584157931732273`*^9}, 3.9584158236131287`*^9, {
   3.958416745579174*^9, 3.95841675316971*^9}, {3.9584272607013226`*^9, 
   3.958427353615492*^9}, {3.958427647034157*^9, 3.958427649223566*^9}, {
   3.95842783929908*^9, 3.958427942843256*^9}, {3.9584280718630257`*^9, 
   3.9584281592222195`*^9}, {3.958428251906065*^9, 3.9584282520743656`*^9}, {
   3.9584331512381954`*^9, 3.9584332790165424`*^9}, {3.9584357838023434`*^9, 
   3.9584357876933517`*^9}, {3.958436034373455*^9, 3.9584360351176567`*^9}, {
   3.958436113242544*^9, 3.958436124199812*^9}, 3.9584362000517197`*^9, {
   3.9584362737513237`*^9, 3.9584363214584904`*^9}, {3.958436446197359*^9, 
   3.958436517930664*^9}, {3.958436652395134*^9, 3.9584366554363384`*^9}, {
   3.958436992806946*^9, 3.958436996322834*^9}, 3.9584371531061*^9, {
   3.958437260119711*^9, 3.9584372664429264`*^9}, {3.958438143709322*^9, 
   3.958438197215584*^9}, {3.9584382356475525`*^9, 3.958438346427021*^9}, {
   3.958477002573921*^9, 3.9584770124160976`*^9}, {3.958477054973629*^9, 
   3.9584770970087624`*^9}, {3.9584771323318367`*^9, 3.95847715256921*^9}, {
   3.958478351968439*^9, 3.958478413068918*^9}, {3.9584807914639015`*^9, 
   3.958480793080839*^9}, {3.958480928388031*^9, 3.95848094677182*^9}, {
   3.9584814782182007`*^9, 3.9584814793747215`*^9}, {3.9584815388035107`*^9, 
   3.958481541745514*^9}, {3.958481857159748*^9, 3.958481864466013*^9}, {
   3.958484270681423*^9, 3.958484381011467*^9}, {3.9584844958108673`*^9, 
   3.9584845037131176`*^9}, {3.958484606903326*^9, 3.9584846590196705`*^9}, {
   3.958484750524849*^9, 3.9584848951672516`*^9}, 3.9584850383455353`*^9, {
   3.9584855980300407`*^9, 3.9584857571681767`*^9}, {3.9585631972348843`*^9, 
   3.958563270175228*^9}, {3.9586483651775208`*^9, 3.9586483998520203`*^9}, {
   3.9606253997207203`*^9, 3.9606254020087776`*^9}, {3.960625458192257*^9, 
   3.9606254705141563`*^9}, {3.960625503481909*^9, 3.9606255036066456`*^9}, {
   3.9606255779881096`*^9, 3.9606256019472885`*^9}, {3.9606257546584377`*^9, 
   3.9606257646599255`*^9}},ExpressionUUID->"a71709b8-d082-9140-922f-\
9dace84145f2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PartialPartial", "[", "function_", "]"}], "[", "fields__", "]"}],
    "/;", 
   RowBox[{"!", 
    RowBox[{"(", 
     RowBox[{"fields", "===", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", "fields", "}"}], "]"}]}], ")"}]}]}], ":=", 
  RowBox[{
   RowBox[{"PartialPartial", "[", "function", "]"}], "[", 
   RowBox[{"Sort", "[", 
    RowBox[{"{", "fields", "}"}], "]"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PartialPartial", "[", "function_", "]"}], "[", "fields_List", 
    "]"}], "/;", 
   RowBox[{
    RowBox[{"Sort", "[", "fields", "]"}], "=!=", "fields"}]}], ":=", 
  RowBox[{
   RowBox[{"PartialPartial", "[", "function", "]"}], "[", 
   RowBox[{"Sort", "[", "fields", "]"}], "]"}]}]}], "Code",
 CellChangeTimes->{{3.9557260438625984`*^9, 3.955726147566633*^9}, {
   3.9557261815227222`*^9, 3.95572619735886*^9}, {3.9557266440223446`*^9, 
   3.9557266462015915`*^9}, {3.9557331273173256`*^9, 
   3.9557331823446407`*^9}, {3.9557337251532135`*^9, 
   3.9557337274783115`*^9}, {3.9557341886267242`*^9, 3.955734209680208*^9}, {
   3.9557346601280823`*^9, 3.9557346677435513`*^9}, {3.9557405448599663`*^9, 
   3.9557405581141796`*^9}, {3.95574080777804*^9, 3.9557408137902985`*^9}, {
   3.955740878591915*^9, 3.9557408995691376`*^9}, {3.9557409371888885`*^9, 
   3.955740938435093*^9}, {3.955741275384388*^9, 3.9557412779118233`*^9}, 
   3.955741364773348*^9, {3.955741581500635*^9, 3.9557415977356815`*^9}, 
   3.955741795493326*^9, {3.958315847367855*^9, 3.958315933238117*^9}, {
   3.958316708922785*^9, 3.9583167147482185`*^9}, {3.958317132963825*^9, 
   3.9583171370286903`*^9}},
 CellLabel->
  "In[644]:=",ExpressionUUID->"c5879fe4-f44a-1a4f-a751-5c690ddb2356"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Variational vector fields (VVF)"
}], "Section",
 CellChangeTimes->{{3.931836256197623*^9, 3.931836260320031*^9}, {
   3.932387704652485*^9, 3.932387709519918*^9}, {3.9324705520206637`*^9, 
   3.9324705540925975`*^9}, {3.94839469638155*^9, 3.948394698688428*^9}, 
   3.9483961146362505`*^9, {3.948396210011439*^9, 3.948396217394292*^9}, {
   3.948396353046953*^9, 3.948396358876449*^9}, 3.948399643842359*^9, {
   3.949170328989889*^9, 3.949170348726712*^9}, {3.958648406023773*^9, 
   3.9586484070894737`*^9}},ExpressionUUID->"fe924205-091a-b04d-bd2e-\
ba37c439d08e"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VVFQ"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400382213518*^9, 3.948400392834514*^9}, {3.9484640611681385`*^9, 
   3.948464062217304*^9}, 3.94891399176828*^9, 
   3.949170359188783*^9},ExpressionUUID->"7ca9284c-235e-0c4e-91e7-\
bd0615dfa349"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VVFQ", "[", "expr_", "]"}], ":=", 
   RowBox[{"VVFQaux", "[", 
    RowBox[{"expr", "//", "ExpandAll"}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"VVFQaux", "[", "expr_Scalar", "]"}], ":=", 
  RowBox[{"VVFQaux", "[", 
   RowBox[{"NoScalar", "[", "expr", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VVFQaux", "[", "expr_", "]"}], "/;", " ", 
   RowBox[{"!", 
    RowBox[{"ScalarQ", "[", "expr", "]"}]}]}], " ", ":=", "False"}], "\n", 
 RowBox[{
  RowBox[{"VVFQaux", "[", "expr_Plus", "]"}], ":=", 
  RowBox[{"And", "@@", 
   RowBox[{"(", 
    RowBox[{"VVFQaux", "/@", 
     RowBox[{"List", "@@", "expr"}]}], ")"}]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VVFQaux", "[", "summand_", "]"}], " ", "/;", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "@", 
       RowBox[{"FindAllOfType", "[", 
        RowBox[{"summand", ",", " ", "VariationalVector"}], "]"}]}], " ", "===",
       " ", "1"}], " ", "&&", "\n", "  ", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"summand", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"CovD", "[", "_", "]"}], "[", 
          RowBox[{"x_", "?", "VariationalVectorQ"}], "]"}], "|", 
         RowBox[{
          RowBox[{"LieD", "[", "_", "]"}], "[", 
          RowBox[{"x_", "?", "VariationalVectorQ"}], "]"}], "|", 
         RowBox[{"VertDiff", "[", 
          RowBox[{"x_", "?", "VariationalVectorQ"}], "]"}], "|", 
         RowBox[{
          RowBox[{"VertInt", "[", "_", "]"}], "[", 
          RowBox[{"x_", "?", "VariationalVectorQ"}], "]"}], "|", 
         RowBox[{
          RowBox[{"VertLie", "[", "_", "]"}], "[", 
          RowBox[{"x_", "?", "VariationalVectorQ"}], "]"}], "|", 
         RowBox[{"InertHead", "[", 
          RowBox[{"x_", "?", "VariationalVectorQ"}], "]"}]}], ")"}]}], 
      "]"}]}], ")"}]}], " ", ":=", " ", "True"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VVFQaux", "[", "_", "]"}], ":=", "False"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "VVFQ", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.9385299922742553`*^9, 3.938529995687413*^9}, {
   3.9385315468204*^9, 3.938531551320829*^9}, {3.938531646575979*^9, 
   3.938531667534199*^9}, {3.93853170407034*^9, 3.938531714172796*^9}, {
   3.938531810203761*^9, 3.938531816217135*^9}, 3.9385318796634254`*^9, {
   3.938531924587549*^9, 3.938531927082631*^9}, {3.9385320200329485`*^9, 
   3.938532021464568*^9}, {3.938532162358789*^9, 3.9385321816854906`*^9}, {
   3.9385322466183*^9, 3.938532265005619*^9}, {3.938532581798551*^9, 
   3.938532584527341*^9}, {3.938575443095409*^9, 3.938575446876423*^9}, {
   3.938583004925453*^9, 3.938583020407956*^9}, {3.938583058266345*^9, 
   3.938583062517909*^9}, 3.9386825547663946`*^9, {3.9386827521503215`*^9, 
   3.9386827601653476`*^9}, {3.948545438748131*^9, 3.94854544504393*^9}, {
   3.948915694975394*^9, 3.948915778736513*^9}, {3.9489158194977875`*^9, 
   3.948915819825518*^9}, {3.949170359200079*^9, 3.9491703592549515`*^9}, {
   3.949172798278975*^9, 3.949172805901104*^9}, {3.9491739240964317`*^9, 
   3.949173977211071*^9}, {3.949174100557358*^9, 3.949174101124151*^9}, {
   3.9493256322471685`*^9, 3.949325695339563*^9}, {3.949325757958619*^9, 
   3.9493258217744093`*^9}, {3.9499229159227257`*^9, 3.949922931818201*^9}, {
   3.9499229736968517`*^9, 3.949922994509746*^9}, {3.949923203285044*^9, 
   3.949923219461638*^9}, 3.94992339046488*^9, {3.9499234918475285`*^9, 
   3.949923515084781*^9}, 3.9499239945310917`*^9, 3.950613791855017*^9, {
   3.951224401792721*^9, 3.9512244019895573`*^9}, {3.9513103914389477`*^9, 
   3.9513103918045673`*^9}, 3.951411671402807*^9},
 CellLabel->
  "In[646]:=",ExpressionUUID->"4933e61e-23c8-5545-8077-8d9934628324"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". InfoFromVVF"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400382213518*^9, 3.948400392834514*^9}, {3.9484640611681385`*^9, 
   3.948464062217304*^9}, 3.94891399176828*^9, 3.9489787835196924`*^9, 
   3.9491629748854218`*^9},ExpressionUUID->"dd5c3e88-1c20-3d49-a4d6-\
792572e8ede6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Turns", " ", "a", " ", "VariationalVectorField", " ", "into", " ", 
    "three", " ", 
    RowBox[{"lists", ":", "\n", "\t", 
     RowBox[{
      RowBox[{"-", " ", "the"}], " ", "first", " ", "one", " ", "gathers", " ",
       "the", " ", "components", " ", "of", " ", "VVF", " ", "written", " ", 
      "as", "  ", "pairs"}], ":", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["VariationalVectorTensor", "1"], "[", 
           SubscriptBox["inds", "1"], "]"}], ",", 
          RowBox[{
           SubscriptBox["Coefficient", "1"], "[", 
           RowBox[{"-", 
            SubscriptBox["inds", "1"]}], "]"}]}], "}"}], ",", "...", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox["VariationalVectorTensor", "k"], "[", 
           SubscriptBox["inds", "k"], "]"}], ",", 
          RowBox[{
           SubscriptBox["Coefficient", "k"], "[", 
           RowBox[{"-", 
            SubscriptBox["inds", "k"]}], "]"}]}], "}"}]}], "}"}], "\n", "\t", 
      "-", " ", 
      RowBox[{
      "the", " ", "second", " ", "one", " ", "is", " ", "the", " ", "same", " ",
        "but", " ", "exchanging", " ", 
       SubscriptBox["VariationalVectorTensor", "i"], " ", "by", " ", 
       RowBox[{
        SubscriptBox["dlTensor", "i"], ":", " ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              SubscriptBox["dlTensor", "1"], "[", 
              SubscriptBox["inds", "1"], "]"}], ",", 
             RowBox[{
              SubscriptBox["Coefficient", "1"], "[", 
              RowBox[{"-", 
               SubscriptBox["inds", "1"]}], "]"}]}], "}"}], ",", "...", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              SubscriptBox["dlTensor", "k"], "[", 
              SubscriptBox["inds", "k"], "]"}], ",", 
             RowBox[{
              SubscriptBox["Coefficient", "k"], "[", 
              RowBox[{"-", 
               SubscriptBox["inds", "k"]}], "]"}]}], "}"}]}], "}"}], "\n", 
         "    ", "-", " ", 
         RowBox[{
         "the", " ", "third", " ", "one", " ", "gathers", " ", "the", " ", 
          "Heads", " ", "of", " ", "the", " ", "components"}]}], ":", " ", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["Tensor", "1"], ",", "...", ",", 
          SubscriptBox["Tensor", "k"]}], "}"}]}]}]}]}]}], " ", "*)"}], "\n", 
  "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"InfoFromVVF", "::", "unknown"}], 
     "=", "\"\<`1` is not a variational vector field.\>\""}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"InfoFromVVF", "[", "vvf_", "]"}], "/;", 
     RowBox[{"!", 
      RowBox[{"VVFQ", "[", "vvf", "]"}]}]}], ":=", 
    RowBox[{"Throw", "@", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"InfoFromVVF", "::", "unknown"}], ",", "vvf"}], "]"}]}]}], 
   "\n", "\n", 
   RowBox[{
    RowBox[{"InfoFromVVF", "[", 
     RowBox[{"vvf_", "?", "VVFQ"}], "]"}], ":=", 
    RowBox[{"Module", "[", "\n", "\t", 
     RowBox[{
      RowBox[{"{", "\n", "\t", 
       RowBox[{
        RowBox[{"listcomponents", "=", 
         RowBox[{"FindAllOfType", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"vvf", "//", 
             RowBox[{
              RowBox[{"ToCanonical", "[", 
               RowBox[{"#", ",", 
                RowBox[{"UseMetricOnVBundle", "->", "None"}]}], "]"}], 
              "&"}]}], "//", "Simplify"}], ",", "VariationalVector"}], 
          "]"}]}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "ToCanonical", " ", "is", " ", "included", " ", "to", " ", "quickly",
           " ", "check", " ", "if", " ", "some", " ", "of", " ", "the", " ", 
          "components", " ", "actually", " ", "vanished"}], " ", "*)"}], "\n",
         "\t", "listcomponentsNoDuplicate", ",", "\n", "\t", 
        "listofcoefficients", ",", "\n", "\t", "listwithvariationalvectors", ",",
         "\n", "\t", "listtensors", ",", "\n", "\t", "listwithdltensors"}], 
       "\n", "\t", "}"}], ",", "\n", "\t", 
      RowBox[{
       RowBox[{"listcomponentsNoDuplicate", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"TensorWithIndices", "/@", 
           RowBox[{"Head", "/@", 
            RowBox[{
            "DeleteDuplicatesTensors", "[", "listcomponents", "]"}]}]}], 
          ")"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             RowBox[{"vv_", "?", "VariationalVectorQ"}], "[", "inds___", 
             "]"}]}], ":>", 
           RowBox[{"vv", "[", "inds", "]"}]}], "}"}]}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{"To", " ", "handle", " ", "$UseInverseMetric"}], " ", "*)"}], 
       RowBox[{"(*", " ", 
        RowBox[{
        "To", " ", "ensure", " ", "the", " ", "correct", " ", "position", " ",
          "of", " ", "indices"}], " ", "*)"}], "\n", "\t", 
       RowBox[{"listofcoefficients", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"IndexCoefficient", "[", 
            RowBox[{"vvf", ",", "#"}], "]"}], "&"}], ")"}], "/@", 
         "listcomponentsNoDuplicate"}]}], ";", " ", "\n", "\t", 
       RowBox[{"listtensors", "=", 
        RowBox[{"MasterOf", "/@", 
         RowBox[{"Head", "/@", "listcomponentsNoDuplicate"}]}]}], ";", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"listwithvariationalvectors", "=", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"listcomponentsNoDuplicate", ",", "listofcoefficients"}], 
          "}"}], "]"}]}], ";", "\n", "\t", 
       RowBox[{"listwithdltensors", "=", 
        RowBox[{
         RowBox[{"listwithvariationalvectors", "/.", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"head_", "?", "VariationalVectorQ"}], "[", "inds___", 
            "]"}], ":>", 
           RowBox[{"(", 
            RowBox[{"VertDiff", "[", 
             RowBox[{
              RowBox[{"MasterOfCPSTensor", "[", "head", "]"}], "@@", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Times", "[", 
                  RowBox[{"#", ",", " ", 
                   RowBox[{"-", "1"}]}], "]"}], " ", "&"}], " ", "/@", 
                RowBox[{"{", " ", "inds", "}"}]}], ")"}]}], "]"}], ")"}]}]}], 
         "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             RowBox[{"vv_", "?", "VertExactHeadQ"}], "[", "indices___", 
             "]"}]}], ":>", 
           RowBox[{"vv", "[", "indices", "]"}]}], "}"}]}]}], 
       RowBox[{"(*", " ", 
        RowBox[{"To", " ", "handle", " ", "$UseInverseMetric"}], " ", "*)"}], 
       ";", "\n", "\t", 
       RowBox[{"{", 
        RowBox[{
        "listwithvariationalvectors", ",", "listwithdltensors", ",", 
         "listtensors"}], "}"}]}]}], "\n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.948978792584624*^9, 3.948978876433749*^9}, {
   3.9489796976378098`*^9, 3.9489797172768054`*^9}, {3.948979984819947*^9, 
   3.9489799929012685`*^9}, {3.948984604530613*^9, 3.948984761420542*^9}, {
   3.948984853669546*^9, 3.948984900666701*^9}, {3.9489850657274694`*^9, 
   3.9489851216049824`*^9}, {3.9489851587192955`*^9, 3.948985164606781*^9}, {
   3.948986227313412*^9, 3.948986404960029*^9}, 3.948986607244971*^9, {
   3.948986661646929*^9, 3.948986667171416*^9}, {3.9489927255762243`*^9, 
   3.9489927257682505`*^9}, {3.948992764767246*^9, 3.948992764913312*^9}, {
   3.949088109692938*^9, 3.949088137768508*^9}, {3.949088209495437*^9, 
   3.94908828298396*^9}, {3.949088322821805*^9, 3.949088329877804*^9}, {
   3.949088364851261*^9, 3.949088446111794*^9}, {3.949088494374286*^9, 
   3.949088495699561*^9}, {3.94916297489612*^9, 3.949162974948711*^9}, {
   3.9491630065958595`*^9, 3.9491630821396084`*^9}, {3.94916456249631*^9, 
   3.949164562504318*^9}, {3.9491698037829456`*^9, 3.949169860354336*^9}, {
   3.949170359261946*^9, 3.949170373929043*^9}, {3.949170980501356*^9, 
   3.9491710249348774`*^9}, {3.949171327000063*^9, 3.9491713306662045`*^9}, {
   3.9491741765892982`*^9, 3.949174176730856*^9}, 3.949174379235873*^9, {
   3.949174497672833*^9, 3.949174548543202*^9}, {3.9491746840300198`*^9, 
   3.949174748690378*^9}, 3.9491748942142754`*^9, {3.949174931508108*^9, 
   3.949174951059595*^9}, {3.949238455257928*^9, 3.9492384601253233`*^9}, {
   3.950274720150858*^9, 3.950274721875799*^9}, {3.950274757208914*^9, 
   3.950274787995249*^9}, {3.9502748337277527`*^9, 3.950274835531231*^9}, {
   3.950274918450922*^9, 3.950274924887593*^9}, {3.9502845172976456`*^9, 
   3.950284541815821*^9}, {3.950295981519752*^9, 3.950295995134626*^9}, {
   3.950296081684744*^9, 3.950296110057024*^9}, {3.9502962531501102`*^9, 
   3.9502962715027885`*^9}, {3.950296303683054*^9, 3.9502963446649685`*^9}, 
   3.950296377167313*^9, 3.950296488927143*^9, {3.950296619459961*^9, 
   3.950296621179596*^9}, {3.9502992386680336`*^9, 3.950299261346485*^9}, {
   3.950300278184103*^9, 3.950300300371968*^9}, {3.950300352317484*^9, 
   3.950300352588644*^9}, {3.950306010193105*^9, 3.950306011558573*^9}, 
   3.9503081018124905`*^9, {3.950354500976027*^9, 3.9503545228044605`*^9}, {
   3.950354597486132*^9, 3.950354615910538*^9}, 3.950354760822372*^9, {
   3.950613820810566*^9, 3.950613824908878*^9}, {3.950614118682417*^9, 
   3.950614310844177*^9}, {3.95305526691078*^9, 3.953055301159546*^9}, 
   3.953853681135046*^9, {3.95965882809898*^9, 3.959658842801468*^9}, 
   3.9596589860002823`*^9, {3.9596596943357086`*^9, 3.959659772971201*^9}, {
   3.95966125590839*^9, 3.9596612592358*^9}},
 CellLabel->
  "In[653]:=",ExpressionUUID->"aaeaf85d-3cd5-3640-8906-e595c327b945"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CoefficientsOfVVF", "::", "unknown"}], 
   "=", "\"\< `1`is not a variational vector field.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ComponentsOfVVF", "::", "unknown"}], 
    "=", "\"\<`1` is not a variational vector field.\>\""}], ";"}], "\n", 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "CoefficientsOfVVF", " ", "extracts", " ", "the", " ", "first", " ", 
    "list", " ", "of", " ", 
    RowBox[{"InfoFromVVF", ".", " ", "ComponentsOfVVF"}], " ", "extracts", " ",
     "the", " ", "last", " ", "list", " ", "of", " ", 
    RowBox[{"InfoFromVVF", "."}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"CoefficientsOfVVF", "[", 
   RowBox[{"vvf_", "?", "VVFQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"InfoFromVVF", "[", "vvf", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ComponentsOfVVF", "[", 
    RowBox[{"vvf_", "?", "VVFQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"InfoFromVVF", "[", "vvf", "]"}], "[", 
    RowBox[{"[", "3", "]"}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CoefficientsOfVVF", "[", "vvf_", "]"}], "/;", 
   RowBox[{"!", 
    RowBox[{"VVFQ", "[", "vvf", "]"}]}]}], ":=", 
  RowBox[{"Throw", "@", 
   RowBox[{"Message", "[", 
    RowBox[{
     RowBox[{"CoefficientsOfVVF", "::", "unknown"}], ",", "vvf"}], 
    "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ComponentsOfVVF", "[", "vvf_", "]"}], "/;", 
    RowBox[{"!", 
     RowBox[{"VVFQ", "[", "vvf", "]"}]}]}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"ComponentsOfVVF", "::", "unknown"}], ",", "vvf"}], "]"}]}]}], 
  "\n", " "}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"CoefficientsOfVVF", ",", "ComponentsOfVVF"}], "]"}], 
  ";"}]}], "Code",
 CellChangeTimes->{{3.950284538158621*^9, 3.950284542591408*^9}, 
   3.950366759605829*^9, {3.9506143222824*^9, 3.950614345866305*^9}, 
   3.9512249712071*^9, {3.9514115382259827`*^9, 3.951411539231966*^9}, {
   3.9530553247726917`*^9, 3.9530553710252533`*^9}, {3.953853678919859*^9, 
   3.953853679736088*^9}, {3.9563283416567287`*^9, 3.9563283418487167`*^9}},
 CellLabel->
  "In[656]:=",ExpressionUUID->"de0b1edc-0355-054d-b21b-bc96a6c21c97"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VVFFromList"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400222135519*^9, 3.9484002241152477`*^9}, 
   3.949164533170397*^9, 3.9503744799753017`*^9, 3.950614380853035*^9, 
   3.9518607459417114`*^9},ExpressionUUID->"ab9facdb-a419-d946-b18d-\
f8bef516f93e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VVFFromList", "::", "notvvf"}], 
    "=", "\"\<The list does not generate a variational vector field\>\""}], 
   ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "VVFFromList", " ", "is", " ", "the", " ", "\"\<Inverse\>\"", " ", "of", " ", 
     RowBox[{"CoefficientsOfVVF", ".", " ", "It"}], " ", "generates", " ", 
     "the", " ", "VVF", " ", "from", " ", "a", " ", "list", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["VariationalVectorTensor", "1"], "[", 
        SubscriptBox["inds", "1"], "]"}], ",", 
       RowBox[{
        SubscriptBox["Coefficient", "1"], "[", 
        RowBox[{"-", 
         SubscriptBox["inds", "1"]}], "]"}]}], "}"}]}], ",", "...", ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["VariationalVectorTensor", "k"], "[", 
        SubscriptBox["inds", "k"], "]"}], ",", 
       RowBox[{
        SubscriptBox["Coefficient", "k"], "[", 
        RowBox[{"-", 
         SubscriptBox["inds", "k"]}], "]"}]}], "}"}], " ", "by", " ", 
     "WWedge", " ", "multiplying", " ", "each", " ", "pair", " ", "and", " ", 
     "adding", " ", "them", " ", "all"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"VVFFromList", "[", "list_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vvf", "=", 
       RowBox[{"Total", "[", 
        RowBox[{"WWedge", "@@@", "list"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"VVFQ", "[", "vvf", "]"}], ",", "vvf", ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{"VVFFromList", "::", "notvvf"}], "]"}]}]}], "]"}]}], "]"}]}],
   "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "VVFFromList", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.949164408576601*^9, 3.949164412537676*^9}, 
   3.949164534093132*^9, {3.949167590472035*^9, 3.949167598122561*^9}, 
   3.949170359291207*^9, {3.949325240328405*^9, 3.949325247663462*^9}, 
   3.949325596636048*^9, {3.9503744799922943`*^9, 3.950374480008295*^9}, {
   3.950614384913271*^9, 3.9506144409001827`*^9}, {3.9571929553687477`*^9, 
   3.9571929704817257`*^9}, 3.9583129051630535`*^9},
 CellLabel->
  "In[663]:=",ExpressionUUID->"7bcc94a8-b17b-c34c-ae16-3efeb601e301"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Definition of a concrete VVF (the one given by the Lie derivative of a \
fixed vector field)"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400376854912*^9, 3.9484004026179485`*^9}, {3.9484004775551186`*^9, 
   3.9484004916331587`*^9}, 3.9491676219251976`*^9, {3.94917039448497*^9, 
   3.9491703947414055`*^9}},ExpressionUUID->"b08bbc4f-190e-f744-8932-\
fcac97b2c6d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{" ", 
          RowBox[{
           RowBox[{
            RowBox[{"VVFFromLieD", "[", "vector", "]"}], "[", "list", "]"}], " ",
            "defines", " ", "the", " ", "VVF", " ", 
           SubscriptBox["L", 
            RowBox[{"vector", "[", "ind", "]"}]], 
           RowBox[{
            SubscriptBox["Tensor", "1"], "[", 
            SubscriptBox["inds", "1"], "]"}]}], "}"}], "~", "WWedge", "~", 
         RowBox[{
          SubscriptBox["VariationalVectorTensor", "1"], "[", 
          RowBox[{"-", 
           SubscriptBox["inds", "1"]}], "]"}]}], "+"}], "..."}], "+", 
      RowBox[{
       SubscriptBox["L", 
        RowBox[{"vector", "[", "ind", "]"}]], 
       RowBox[{
        SubscriptBox["Tensor", "k"], "[", 
        SubscriptBox["inds", "k"], "]"}]}]}], "}"}], "~", "WWedge", "~", 
    RowBox[{
     SubscriptBox["VariationalVectorTensor", "k"], "[", 
     RowBox[{"-", 
      SubscriptBox["inds", "k"]}], "]"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VVFFromLieD", "[", 
      RowBox[{"v_", "?", "xTensorQ"}], "]"}], "[", "wrt__", "]"}], ":=", 
    RowBox[{
     RowBox[{"VVFFromLieD", "[", 
      RowBox[{"TensorWithIndices", "@", "v"}], "]"}], "[", "wrt", "]"}]}], 
   "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"VVFFromLieD", "[", "vector_", "]"}], "[", "wrt__", "]"}], ":=", 
    RowBox[{"Module", "[", "\n", "\t", 
     RowBox[{
      RowBox[{"{", "\n", "\t", 
       RowBox[{
        RowBox[{"fields", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", "wrt", "}"}], "]"}]}], ",", "\n", "\t", 
        "ListOfSummands"}], "\n", "\t", "}"}], ",", "\n", "\t", "\n", "\t", 
      RowBox[{
       RowBox[{"ListOfSummands", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"TensorWithIndices", "/@", "fields"}], ")"}], " ", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"head_", "?", "xTensorQ"}], "[", "inds___", "]"}], ":>", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"LieD", "[", "vector", "]"}], "[", 
              RowBox[{"head", "[", "inds", "]"}], "]"}], "~", "WWedge", "~", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"VariationalVector", "[", "head", "]"}], "@@", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Times", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "&"}], "/@", 
                 RowBox[{"IndexList", "[", "inds", "]"}]}], ")"}]}], ")"}]}], 
            "}"}]}], "}"}]}]}], ";", "\n", "\t", 
       RowBox[{
        RowBox[{"ListOfSummands", "//", "Flatten"}], "//", "adding"}]}]}], 
     "\n", "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "VVFFromLieD", "]"}], ";"}]}]}]], "Code",
 CellChangeTimes->{{3.949167506859114*^9, 3.9491675704367256`*^9}, {
   3.949167604526188*^9, 3.949167605488199*^9}, {3.9491676366052647`*^9, 
   3.9491676735888577`*^9}, {3.949167710341992*^9, 3.949167711883168*^9}, {
   3.9491679154580173`*^9, 3.9491680257953396`*^9}, {3.9491680686695385`*^9, 
   3.949168264372446*^9}, {3.9491683558794556`*^9, 3.949168358329346*^9}, 
   3.949168972712929*^9, {3.9491690491756306`*^9, 3.949169131922724*^9}, {
   3.9491693210149994`*^9, 3.9491694095326157`*^9}, {3.94923870548353*^9, 
   3.949238718574082*^9}, {3.949527128948035*^9, 3.949527129065668*^9}, {
   3.949532331739004*^9, 3.949532417508415*^9}, {3.949532467702392*^9, 
   3.94953255962426*^9}, {3.949532601004505*^9, 3.949532883007717*^9}, {
   3.949533005854784*^9, 3.949533015234646*^9}, {3.9503810220307217`*^9, 
   3.950381059129215*^9}, {3.950614448460394*^9, 3.95061459866556*^9}, {
   3.9506296240723114`*^9, 3.950629660079677*^9}, {3.950977697999237*^9, 
   3.950977698032215*^9}, {3.9512249755621147`*^9, 3.951224976545908*^9}, 
   3.9534887882577267`*^9, 3.953490088608452*^9, {3.9552088871179676`*^9, 
   3.9552088922833214`*^9}, {3.957289726161415*^9, 3.957289726848879*^9}},
 CellLabel->
  "In[666]:=",ExpressionUUID->"3b793efd-f8fd-644f-b3a3-4e545b85c599"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Generalized variational vector fields (GVVF)"
}], "Section",
 CellChangeTimes->{{3.931836256197623*^9, 3.931836260320031*^9}, {
   3.932387704652485*^9, 3.932387709519918*^9}, {3.9324705520206637`*^9, 
   3.9324705540925975`*^9}, {3.94839469638155*^9, 3.948394698688428*^9}, 
   3.9483961146362505`*^9, {3.948396210011439*^9, 3.948396217394292*^9}, {
   3.948396353046953*^9, 3.948396358876449*^9}, 3.948399643842359*^9, {
   3.949170328989889*^9, 3.949170348726712*^9}, {3.949696250543211*^9, 
   3.949696254403988*^9}, {3.9586484105576115`*^9, 
   3.9586484135039444`*^9}},ExpressionUUID->"310009b9-07c8-f949-8e3f-\
8e4c14706a76"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PossibleRuleQ", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"tensor1_", "?", "xTensorQ"}], "[", "inds___", "]"}], ",", 
     "expr_"}], "}"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"List", "@@", 
    RowBox[{"xAct`xTensor`Private`TakeEIndices", "[", 
     RowBox[{"FindFreeIndices", "[", 
      RowBox[{"tensor1", "[", "inds", "]"}], "]"}], "]"}]}], "===", 
   RowBox[{"List", "@@", 
    RowBox[{"xAct`xTensor`Private`TakeEIndices", "[", 
     RowBox[{"FindFreeIndices", "[", "expr", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.949696263424618*^9},
 CellLabel->
  "In[669]:=",ExpressionUUID->"08e0919a-7f94-5b44-aae7-ccf27f66280c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "DefGeneralizedVVF", " ", "creates", " ", "a", " ", "VVF", " ", "as", " ",
      "a", " ", "list", " ", "of", " ", "replacements", " ", "for", " ", 
     "k"}], "-", "vertical", "-", "forms"}], " ", "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "DefGeneralizedVVF", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"VanishOverOtherForms", "->", "True"}], ",", 
       RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
       RowBox[{"DefInfo", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<the generalized vector field\>\"", ",", "\"\<\>\""}], 
         "}"}]}], ",", 
       RowBox[{"Validate", "\[Rule]", "True"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DefGeneralizedVVF", "::", "badinput"}], " ", "=", 
     " ", "\"\<Each element must be a two-element pair: `1`.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DefGeneralizedVVF", "::", "ZeroVertDeg"}], " ", "=", 
     " ", "\"\<No VertInt rule can be defined on forms with ZeroVertDeg: `1`.\
\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DefGeneralizedVVF", "::", "IndicesMissmatch"}], " ", "=", 
     " ", "\"\<Indices missmatch: `1`.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DefGeneralizedVVF", "::", "RepeatedElements"}], " ", "=", 
     " ", "\"\<Repeated elements: `1`.\>\""}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DefGeneralizedVVF", "[", 
      RowBox[{"name_Symbol", ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", 
         RowBox[{"Options", "[", "DefGeneralizedVVF", "]"}], "]"}]}]}], "]"}],
      "[", 
     RowBox[{"pairs_List", "?", "MatrixQ"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"DefGeneralizedVVF", "[", 
      RowBox[{"name", ",", "options"}], "]"}], "@@", "pairs"}]}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DefGeneralizedVVF", "[", 
      RowBox[{"name_Symbol", ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", 
         RowBox[{"Options", "[", "DefGeneralizedVVF", "]"}], "]"}]}]}], "]"}],
      "[", "pairs__", "]"}], ":=", 
    RowBox[{"Catch", "@", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"failed1", ",", "failed2", ",", "failed3", ",", "failed4", ",", 
         RowBox[{"list", "=", 
          RowBox[{"{", "pairs", "}"}]}], ",", "intersection", ",", "pns", ",",
          "val", ",", "info"}], "}"}], ",", "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"pns", ",", "info", ",", "val"}], "}"}], "=", 
         RowBox[{"OptionValue", "[", 
          RowBox[{"{", 
           RowBox[{"ProtectNewSymbol", ",", "DefInfo", ",", "Validate"}], 
           "}"}], "]"}]}], ";", "\[IndentingNewLine]", "\t", "\n", "    ", 
        RowBox[{"MakexTensions", "[", 
         RowBox[{
         "DefGeneralizedVVF", ",", "\"\<Beginning\>\"", ",", "name", ",", 
          "pairs", ",", "options"}], "]"}], ";", " ", "\n", "\t", 
        RowBox[{"If", "[", 
         RowBox[{"val", ",", "\[IndentingNewLine]", "\t\t", 
          RowBox[{
           RowBox[{"ValidateSymbol", "[", "name", "]"}], ";", 
           "\[IndentingNewLine]", "\t\t", 
           RowBox[{"ValidateSymbolInSession", "[", "name", "]"}]}]}], "\n", 
         "\t", "]"}], ";", "\n", "\t", "\n", "\t", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"And", "@@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"ListQ", "[", "#", "]"}], "&&", 
                RowBox[{
                 RowBox[{"Length", "[", "#", "]"}], "===", "2"}]}], "&"}], "/@",
               "list"}], ")"}]}]}], ",", 
          RowBox[{"Throw", "@", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"DefGeneralizedVVF", "::", "badinput"}], ",", "list"}], 
            "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", "\t", 
        "\[IndentingNewLine]", "\t", 
        RowBox[{"failed2", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"list", ",", 
           RowBox[{
            RowBox[{"ZeroVertDegQ", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "&"}]}], "]"}]}], ";", 
        " ", "\[IndentingNewLine]", "\t", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"failed2", "=!=", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{
           RowBox[{"Throw", "[", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"DefGeneralizedVVF", "::", "ZeroVertDeg"}], ",", 
              "failed2"}], "]"}], "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", "\t", 
        RowBox[{"failed3", "=", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"GatherBy", "[", 
            RowBox[{"list", ",", 
             RowBox[{
              RowBox[{"Head", "@", 
               RowBox[{"First", "[", "#", "]"}]}], "&"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "#", "]"}], ">", "1"}], "&"}]}], "]"}]}], 
        ";", " ", "\[IndentingNewLine]", "\t", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"failed3", "=!=", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{
           RowBox[{"Throw", "[", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"DefGeneralizedVVF", "::", "RepeatedElements"}], ",", 
              "failed3"}], "]"}], "]"}], ";"}]}], "]"}], ";", "\n", "\t", 
        "\[IndentingNewLine]", "\t", 
        RowBox[{"failed1", "=", 
         RowBox[{"Select", "[", 
          RowBox[{"list", ",", 
           RowBox[{
            RowBox[{"Not", "[", 
             RowBox[{"PossibleRuleQ", "[", "#", "]"}], "]"}], "&"}]}], 
          "]"}]}], ";", " ", "\[IndentingNewLine]", "\t", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"failed1", "=!=", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{
           RowBox[{"Throw", "[", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"DefGeneralizedVVF", "::", "IndicesMissmatch"}], ",", 
              RowBox[{"failed1", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], ";"}]}], "]"}],
         ";", "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{"GeneralizedVVFQ", "[", "name", "]"}], "^=", "True"}], ";", 
        "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{"ComponentsOfGeneralizedVVF", "[", "name", "]"}], "^=", 
         RowBox[{"Head", "/@", 
          RowBox[{"First", "/@", "list"}]}]}], ";", "\[IndentingNewLine]", 
        "\t", 
        RowBox[{
         RowBox[{"RulesOfGeneralizedVVFQ", "[", "name", "]"}], "^=", 
         RowBox[{"MakeRule", "/@", "list"}]}], ";", "\n", "\t", 
        RowBox[{
         RowBox[{"VanishOverOtherForms", "[", "name", "]"}], "^=", 
         RowBox[{"OptionValue", "[", "VanishOverOtherForms", "]"}]}], ";", 
        "\n", "\t", 
        RowBox[{
         RowBox[{"DefInfo", "[", "name", "]"}], "^=", "info"}], ";", "\n", 
        "\t", 
        RowBox[{"AppendToUnevaluated", "[", 
         RowBox[{"$GeneralizedVVF", ",", "name"}], "]"}], ";", "\n", "\t", 
        "\[IndentingNewLine]", "\t", 
        RowBox[{"xAct`xTensor`Private`MakeDefInfo", "[", 
         RowBox[{"DefGeneralizedVVF", ",", "name", ",", "info"}], "]"}], ";", 
        "\n", "\t", "\n", "\t", 
        RowBox[{"intersection", "=", 
         RowBox[{
          RowBox[{"ComponentsOfGeneralizedVVF", "[", "name", "]"}], "\[Intersection]", 
          RowBox[{"(", 
           RowBox[{"VertDiff", "/@", 
            RowBox[{"ComponentsOfGeneralizedVVF", "[", "name", "]"}]}], 
           ")"}]}]}], ";", "\n", "\t", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"intersection", "=!=", 
           RowBox[{"{", "}"}]}], ",", 
          RowBox[{"Print", "[", 
           
           RowBox[{"\"\<** DefGeneralizedVVF: \>\"", ",", "name", 
            ",", "\"\< defined for \>\"", ",", 
            RowBox[{"MasterOf", "/@", "intersection"}], ",", "\"\< and \>\"", 
            ",", "intersection", 
            ",", "\"\<. Make sure the definitions are compatible.\>\""}], 
           "]"}]}], "]"}], ";", "\n", "\t", 
        RowBox[{"If", "[", 
         RowBox[{"pns", ",", 
          RowBox[{"Protect", "[", "name", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "    ", 
        RowBox[{"MakexTensions", "[", 
         RowBox[{
         "DefGeneralizedVVF", ",", "\"\<End\>\"", ",", "name", ",", "pairs", ",",
           "options"}], "]"}], ";"}]}], " ", "\[IndentingNewLine]", "]"}]}]}],
    "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ComponentsOfGeneralizedVVF", "[", "expr_", "]"}], "/;", 
     RowBox[{"!", 
      RowBox[{"GeneralizedVVFQ", "[", "expr", "]"}]}]}], ":=", 
    RowBox[{"Throw", "@", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"ComponentsOfGeneralizedVVF", "::", "invalid"}], ",", "expr"}],
       "]"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.9495341831607075`*^9, 3.9495341831607075`*^9}, 
   3.949534316973891*^9, {3.9495343566747456`*^9, 3.949534378778025*^9}, {
   3.9495368906587105`*^9, 3.949536894654604*^9}, {3.9495374937634487`*^9, 
   3.9495375045776615`*^9}, {3.949600242746071*^9, 3.9496002867195683`*^9}, {
   3.949600326209934*^9, 3.9496004296160507`*^9}, {3.949600882822594*^9, 
   3.949600886790903*^9}, {3.949600934829778*^9, 3.9496009493174114`*^9}, {
   3.9496014968370247`*^9, 3.949601501499237*^9}, {3.9496016250228043`*^9, 
   3.949601727080775*^9}, {3.949601798621584*^9, 3.949601881676367*^9}, {
   3.949601977399589*^9, 3.949602143535887*^9}, {3.9496021887092934`*^9, 
   3.949602209403873*^9}, {3.949602258392809*^9, 3.94960226696043*^9}, {
   3.949602399473156*^9, 3.949602416686994*^9}, {3.949602491497753*^9, 
   3.949602492404213*^9}, {3.949602607038286*^9, 3.949602631192833*^9}, {
   3.949602671777046*^9, 3.949602820743915*^9}, {3.949602908094663*^9, 
   3.949603003577141*^9}, {3.9496030554137726`*^9, 3.9496030565989914`*^9}, {
   3.9496039821435623`*^9, 3.949604146652357*^9}, {3.949604191698189*^9, 
   3.949604196228199*^9}, {3.949604239910879*^9, 3.949604297628973*^9}, {
   3.949604407886629*^9, 3.949604413945059*^9}, {3.949604503981993*^9, 
   3.949604529088323*^9}, {3.949604689354179*^9, 3.949604703712126*^9}, {
   3.94960474351289*^9, 3.9496047857740154`*^9}, {3.949604826461441*^9, 
   3.9496049155974045`*^9}, {3.9496846167333584`*^9, 3.949684702551686*^9}, {
   3.949684753297079*^9, 3.94968477150936*^9}, {3.949684817497483*^9, 
   3.949684873329407*^9}, {3.9496849110874805`*^9, 3.949684930361576*^9}, {
   3.949684979676584*^9, 3.9496849798284874`*^9}, {3.9496850221140194`*^9, 
   3.949685025343357*^9}, {3.949685131411243*^9, 3.9496851373099365`*^9}, {
   3.949685287719118*^9, 3.949685290431351*^9}, {3.949685351000372*^9, 
   3.949685439892545*^9}, {3.9496862641018353`*^9, 3.949686273847862*^9}, 
   3.949686339913452*^9, {3.949687158587919*^9, 3.9496871852863426`*^9}, {
   3.949687871406889*^9, 3.9496879355199833`*^9}, {3.949695255269633*^9, 
   3.949695305515859*^9}, {3.949695477958601*^9, 3.949695497878263*^9}, {
   3.949695552069908*^9, 3.9496955557160034`*^9}, {3.949695632553703*^9, 
   3.949695637796553*^9}, {3.949696122448799*^9, 3.949696123355877*^9}, {
   3.949696258918659*^9, 3.94969627242704*^9}, 3.950207676062834*^9, {
   3.950614610161433*^9, 3.950614637853107*^9}, {3.9508090672326794`*^9, 
   3.950809070933143*^9}, {3.950810039441213*^9, 3.95081009940501*^9}, {
   3.9521942034377155`*^9, 3.952194203636711*^9}, {3.95219430851169*^9, 
   3.9521944784776096`*^9}, {3.9521948554308567`*^9, 
   3.9521948577502937`*^9}, {3.952195017607113*^9, 3.9521950912396564`*^9}, {
   3.952195149817116*^9, 3.952195150885584*^9}, {3.952195181738491*^9, 
   3.9521951828141766`*^9}, {3.9521953633215637`*^9, 3.952195388209364*^9}, {
   3.952195476277151*^9, 3.952195477407612*^9}, {3.952195537879757*^9, 
   3.952195543550646*^9}, 3.952195701351902*^9, {3.952195857348295*^9, 
   3.9521958674163113`*^9}, {3.952196036724556*^9, 3.9521960639101143`*^9}, {
   3.95219614535446*^9, 3.9521961467511196`*^9}, {3.952196510967415*^9, 
   3.952196521468012*^9}, {3.9521965524610577`*^9, 3.952196553076355*^9}, 
   3.9521968255950737`*^9, {3.952197640568653*^9, 3.952197680832529*^9}, {
   3.9521977140886917`*^9, 3.9521977788547325`*^9}, {3.9521978257021217`*^9, 
   3.9521979046113434`*^9}, {3.9521981656767197`*^9, 3.952198174671797*^9}, {
   3.95219821959013*^9, 3.952198233278528*^9}, 3.9545778598487225`*^9, {
   3.954942559310446*^9, 3.954942573638916*^9}, {3.9560848705833416`*^9, 
   3.9560848937200184`*^9}, {3.9564881948973045`*^9, 3.956488280398735*^9}, {
   3.95719307500906*^9, 3.9571931019735756`*^9}, {3.9571934057411175`*^9, 
   3.9571934998301983`*^9}, {3.957193785276474*^9, 3.957193799160681*^9}, {
   3.957193830732437*^9, 3.957193832984682*^9}, {3.9572786160738907`*^9, 
   3.957278669935087*^9}},
 CellLabel->
  "In[670]:=",ExpressionUUID->"d8de787b-44e7-c443-a1f0-360e47f91288"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Undef", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Undef", "[", 
   RowBox[{"symbol_Symbol", "?", "GeneralizedVVFQ"}], "]"}], ":=", 
  RowBox[{"UndefGeneralizedVVF", "[", "symbol", "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "Undef", "]"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefGeneralizedVVF", "[", 
    RowBox[{"list", ":", 
     RowBox[{"{", 
      RowBox[{"___", "?", "GeneralizedVVFQ"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Scan", "[", 
    RowBox[{"UndefGeneralizedVVF", ",", "list"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefGeneralizedVVF", "[", "gvvf_", "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"servants", "=", 
        RowBox[{"ServantsOf", "[", "gvvf", "]"}]}], "}"}], ",", "\n", "\t", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"GeneralizedVVFQ", "[", "gvvf", "]"}]}], ",", 
         RowBox[{"Throw", "[", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"UndefGeneralizedVVF", "::", "unknown"}], 
            ",", "\"\<generalized variational vector field\>\"", ",", 
            "gvvf"}], "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", "\t", 
       RowBox[{"xAct`xTensor`Private`CheckRemoveSymbol", "[", "gvvf", "]"}], ";",
        "\n", "\t", "\[IndentingNewLine]", "\t", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{
        "UndefGeneralizedVVF", ",", "\"\<Beginning\>\"", ",", "gvvf"}], "]"}],
        ";", "\[IndentingNewLine]", "\t", 
       RowBox[{"xUpSet", "[", 
        RowBox[{
         RowBox[{"ServantsOf", "[", "gvvf", "]"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", "\t", 
       RowBox[{"xAct`xTensor`Private`DropFromHosts", "[", "gvvf", "]"}], ";", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"Undef", "/@", 
        RowBox[{"Reverse", "[", "servants", "]"}]}], ";", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"$GeneralizedVVF", "=", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{"$GeneralizedVVF", ",", "gvvf"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{"UndefGeneralizedVVF", ",", "\"\<End\>\"", ",", "gvvf"}], 
        "]"}], ";", "\n", "\t", "\[IndentingNewLine]", "\t", 
       RowBox[{"xAct`xTensor`Private`MakeUndefInfo", "[", 
        RowBox[{"UndefGeneralizedVVF", ",", "gvvf"}], "]"}], ";", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"xAct`xTensor`Private`RemoveSymbol", "[", "gvvf", "]"}], 
       ";"}]}], "\[IndentingNewLine]", "]"}]}]}], ";"}]}], "Code",
 CellChangeTimes->{{3.949696280330971*^9, 3.949696280684078*^9}, {
  3.949696768850712*^9, 3.949696786866081*^9}, {3.9496969636012325`*^9, 
  3.949696964867239*^9}, {3.9496971025814342`*^9, 3.949697114226888*^9}, {
  3.950810025360468*^9, 3.95081003351197*^9}, {3.951861349366583*^9, 
  3.95186135902034*^9}, {3.952197127213354*^9, 3.9521971369788284`*^9}, {
  3.9521971840997887`*^9, 3.9521971900357037`*^9}, {3.9521973360917835`*^9, 
  3.9521973367781677`*^9}, {3.9521982567845364`*^9, 3.952198261999077*^9}, {
  3.9521982982112255`*^9, 3.952198393783304*^9}, {3.952198435609604*^9, 
  3.952198462996847*^9}, {3.952198727224077*^9, 3.9521987307289257`*^9}, {
  3.9521987940528984`*^9, 3.9521988198100605`*^9}, {3.952198959330225*^9, 
  3.9521989680455475`*^9}, {3.9571949315204887`*^9, 3.95719493215703*^9}},
 CellLabel->
  "In[678]:=",ExpressionUUID->"0e531def-3132-284c-bc58-17318c0cc96d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"Equal", ",", "SameQ"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gvvf1_", "?", "GeneralizedVVFQ"}], "==", 
   RowBox[{"gvvf2_", "?", "GeneralizedVVFQ"}]}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sort", "@", 
      RowBox[{"RulesOfGeneralizedVVFQ", "[", "gvvf1", "]"}]}], "==", 
     RowBox[{"Sort", "@", 
      RowBox[{"RulesOfGeneralizedVVFQ", "[", "gvvf2", "]"}]}]}], ")"}], "&&", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"VanishOverOtherForms", "[", "gvvf1", "]"}], "==", 
     RowBox[{"VanishOverOtherForms", "[", "gvvf2", "]"}]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gvvf1_", "?", "GeneralizedVVFQ"}], "===", 
   RowBox[{"gvvf2_", "?", "GeneralizedVVFQ"}]}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sort", "[", 
      RowBox[{"RulesOfGeneralizedVVFQ", "[", "gvvf1", "]"}], "]"}], "===", 
     RowBox[{"Sort", "[", 
      RowBox[{"RulesOfGeneralizedVVFQ", "[", "gvvf2", "]"}], "]"}]}], ")"}], "&&", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"VanishOverOtherForms", "[", "gvvf1", "]"}], "===", 
     RowBox[{"VanishOverOtherForms", "[", "gvvf2", "]"}]}], ")"}]}]}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{
   "Equal", ",", "SameQ", ",", "DefGeneralizedVVF", ",", 
    "UndefGeneralizedVVF"}], "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.949696276086212*^9, 3.949696298498175*^9}, {
  3.949696791319918*^9, 3.949696809173815*^9}, {3.952198825389248*^9, 
  3.9521988255645733`*^9}},
 CellLabel->
  "In[683]:=",ExpressionUUID->"1e256d84-cf52-094e-a914-ce7e509f95c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". ExpandVertIntReplace"
}], "Section",
 CellChangeTimes->{{3.931836256197623*^9, 3.931836260320031*^9}, {
   3.932387704652485*^9, 3.932387709519918*^9}, {3.9324705520206637`*^9, 
   3.9324705540925975`*^9}, {3.94839469638155*^9, 3.948394698688428*^9}, 
   3.9483961146362505`*^9, {3.948396210011439*^9, 3.948396217394292*^9}, {
   3.948396353046953*^9, 3.948396358876449*^9}, 3.948399643842359*^9, {
   3.949170328989889*^9, 3.949170348726712*^9}, {3.949170418524175*^9, 
   3.9491704215487*^9}, 3.9491724522460346`*^9, {3.94969634760487*^9, 
   3.949696358377613*^9}},ExpressionUUID->"8510184b-49e7-de4c-abab-\
ffb3c091abf1"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntReplace of VVF"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400376854912*^9, 3.9484004026179485`*^9}, {3.948400505811919*^9, 
   3.948400527306937*^9}, {3.948979009722978*^9, 3.9489790170032864`*^9}, 
   3.949090062316096*^9, 3.949091439646503*^9, 3.9491724484764156`*^9, 
   3.9496963588724804`*^9},ExpressionUUID->"bc18e8d1-ecab-674a-b258-\
d497703e7452"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CheckHoldExpandVertInt", "[", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"Options", "[", "ExpandVertInt", "]"}], "]"}]}], "]"}], "[", 
    "dltensor_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"listtohold", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{"OptionValue", "[", "HoldExpandVertInt", "]"}], "}"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{"listtohold", ",", 
         RowBox[{"VertDiff", "/@", "listtohold"}]}], "]"}], ",", "dltensor"}],
       "]"}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertIntReplace", "[", "options___", "]"}], "[", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{
      RowBox[{"VertInt", "[", 
       RowBox[{"vvf_", "?", "VVFQ"}], "]"}], "[", 
      RowBox[{
       RowBox[{"dltensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], 
      "]"}], "]"}], "]"}], "/;", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"vvf", ",", "Plus"}], "]"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"ComponentsOfVVF", "[", "vvf", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "=!=", 
     RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}]}]}]}], ":=", "0"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ExpandVertIntReplace", "[", 
      RowBox[{"options", ":", 
       RowBox[{"OptionsPattern", "[", 
        RowBox[{"Options", "[", "ExpandVertInt", "]"}], "]"}]}], "]"}], "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{"VertInt", "[", 
        RowBox[{"vvf_", "?", "VVFQ"}], "]"}], "[", 
       RowBox[{
        RowBox[{"dltensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], 
       "]"}], "]"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"vvf", ",", "Plus"}], "]"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"ComponentsOfVVF", "[", "vvf", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "===", 
      RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}]}], "&&", 
     RowBox[{
      RowBox[{"CheckHoldExpandVertInt", "[", "options", "]"}], "[", 
      "dltensor", "]"}]}]}], ":=", 
   RowBox[{
    RowBox[{"VertInt", "[", "vvf", "]"}], "[", 
    RowBox[{"dltensor", "[", "inds", "]"}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ExpandVertIntReplace", "[", "options___", "]"}], "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{"VertInt", "[", 
        RowBox[{"vvf_", "?", "VVFQ"}], "]"}], "[", 
       RowBox[{
        RowBox[{"dltensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], 
       "]"}], "]"}], "]"}], "/;", 
    RowBox[{"FreeQ", "[", 
     RowBox[{"vvf", ",", "Plus"}], "]"}]}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"vvfSeparateInfo", "=", 
        RowBox[{"InfoFromVVF", "[", "vvf", "]"}]}], ",", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"headtensor", "=", 
        RowBox[{"MasterOfCPSTensor", "[", "dltensor", "]"}]}], ",", 
       "\[IndentingNewLine]", "\t", "position", ",", "\n", "\t", "rule", ",", 
       "\n", "\t", "result"}], "\[IndentingNewLine]", "\t", "}"}], ",", "\n", 
     "\t", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Check", " ", "if", " ", "the", " ", "headtensor", " ", "is", " ", 
       "part", " ", "of", " ", "the", " ", "components", " ", "of", " ", 
       "vvf"}], " ", "*)"}], "\t", "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"position", "=", 
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"vvfSeparateInfo", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", "headtensor", ",", "1"}], 
        "]"}]}], ";", "\n", "\t", "\n", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"This", " ", "is", " ", "a", " ", "safety", " ", 
         RowBox[{"measure", ".", " ", "If"}], " ", "headtensor", " ", "is", " ",
          "not", " ", "part", " ", "of", " ", "the", " ", "components", " ", 
         "of", " ", "vvf"}], ",", " ", 
        RowBox[{"returns", " ", "0"}], ",", " ", 
        RowBox[{
        "otherwise", " ", "we", " ", "create", " ", "a", " ", "rule", " ", 
         "where", " ", "dltensor", " ", "is", " ", "replaced", " ", "by", " ",
          "the", " ", "coefficient", " ", "of", " ", "vvf", " ", "associated",
          " ", "to", " ", "headtensor"}]}], "*)"}], "\[IndentingNewLine]", 
      "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"position", "===", 
         RowBox[{"{", "}"}]}], ",", "\n", "\t\t", 
        RowBox[{"result", "=", "0"}], ",", "\n", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"MetricQ", "[", "headtensor", "]"}], "&&", 
             RowBox[{"headtensor", "==", 
              RowBox[{"Inv", "[", "headtensor", "]"}]}]}], ",", "\n", 
            "\t\t\t\t", 
            RowBox[{"rule", "=", 
             RowBox[{"MakeRule", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"vvfSeparateInfo", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", 
                    RowBox[{"position", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], "//",
                    "Simplification"}], "//", "Expand"}], "//", 
                 "ContractMetric"}], "//", "Evaluate"}], ",", 
               RowBox[{"MetricOn", "->", "All"}]}], "]"}]}], ",", "\n", 
            "\t\t\t\t", 
            RowBox[{"rule", "=", 
             RowBox[{"MakeRule", "[", 
              RowBox[{
               RowBox[{"vvfSeparateInfo", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", 
                  RowBox[{"position", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], "//",
                "Evaluate"}], "]"}]}]}], "\n", "\t\t\t\t", "]"}], ";", "\n", 
          "\t \t", 
          RowBox[{"result", "=", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"dltensor", "[", "inds", "]"}], "//", 
               RowBox[{"SeparateMetric", "[", "]"}]}], ")"}], "/.", "rule"}], 
            ")"}]}], ";"}], "\n", "\t \t", ")"}]}], "\n", "\t", "]"}], ";", 
      "\n", "\t", "\n", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"This", " ", "is", " ", "a", " ", "safety", " ", 
         RowBox[{"measure", ".", " ", "It"}], " ", "checks", " ", "if", " ", 
         "the", " ", "rule", " ", "has", " ", "been", " ", "applied"}], ",", 
        " ", 
        RowBox[{
        "otherwise", " ", "it", " ", "leaves", " ", "the", " ", "expression", 
         " ", 
         RowBox[{
          RowBox[{"VertInt", "[", "vvf", "]"}], "[", 
          RowBox[{"dltensor", "[", "inds", "]"}], "]"}], " ", "unchanged"}]}],
        " ", "*)"}], "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"result", "===", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"dltensor", "[", "inds", "]"}], "//", 
           RowBox[{"SeparateMetric", "[", "]"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"VertInt", "[", "vvf", "]"}], "[", 
         RowBox[{"dltensor", "[", "inds", "]"}], "]"}], ",", "result"}], 
       "]"}]}]}], "\n", "]"}]}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "It", " ", "vanishes", " ", "over", " ", "other", " ", "vertical", " ", 
    "forms"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertIntReplace", "[", "options___", "]"}], "[", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{
      RowBox[{"VertInt", "[", 
       RowBox[{"vvf_", "?", "VVFQ"}], "]"}], "[", "tensor_", "]"}], "]"}], 
    "]"}], ":=", "0"}], ";"}]}], "Code",
 CellChangeTimes->{{3.9490914391390424`*^9, 3.949091459509416*^9}, {
   3.949091571403574*^9, 3.949091606378479*^9}, {3.9490920247009954`*^9, 
   3.949092024967874*^9}, {3.9490920643182073`*^9, 3.949092070405137*^9}, {
   3.949092228523529*^9, 3.9490922464088726`*^9}, 3.949162974958713*^9, 
   3.949164562513352*^9, {3.949170429857497*^9, 3.949170438079176*^9}, {
   3.949322322564699*^9, 3.949322352252675*^9}, {3.949326378292108*^9, 
   3.949326436013954*^9}, {3.949434369274803*^9, 3.949434555786875*^9}, {
   3.949434607047875*^9, 3.949434714306196*^9}, 3.949435052044918*^9, {
   3.9495180865236187`*^9, 3.9495181042941227`*^9}, {3.94951819090967*^9, 
   3.949518312499941*^9}, {3.949518389849306*^9, 3.949518404056009*^9}, {
   3.9495189168672733`*^9, 3.949518933046507*^9}, 3.9495190446357555`*^9, {
   3.949603651126572*^9, 3.949603697636553*^9}, 3.949603737376257*^9, {
   3.949603860221091*^9, 3.949603917923866*^9}, 3.949603948928255*^9, {
   3.949686559142998*^9, 3.949686680074674*^9}, {3.9496867199750385`*^9, 
   3.949686734392626*^9}, {3.9496867645583057`*^9, 3.949686865473575*^9}, {
   3.949690446736388*^9, 3.949690457539295*^9}, {3.9496963157510986`*^9, 
   3.9496963347852583`*^9}, {3.9502185914825897`*^9, 3.950218596211084*^9}, {
   3.9503061683647385`*^9, 3.9503062123995132`*^9}, {3.9503066265304146`*^9, 
   3.9503066277493*^9}, {3.95030669513431*^9, 3.9503067378131065`*^9}, {
   3.950306770857926*^9, 3.950306863013357*^9}, {3.950306905054964*^9, 
   3.950306913350408*^9}, {3.9503070927878456`*^9, 3.9503071028595047`*^9}, {
   3.950309124133822*^9, 3.950309146822474*^9}, {3.9503151650441933`*^9, 
   3.950315203922039*^9}, {3.95035167700675*^9, 3.9503518044855576`*^9}, {
   3.950351847365904*^9, 3.950351887810177*^9}, {3.950351921447241*^9, 
   3.9503520017010555`*^9}, {3.9503520736800137`*^9, 3.950352362216116*^9}, {
   3.95035296941522*^9, 3.950352999551863*^9}, {3.9503530439303474`*^9, 
   3.95035306551198*^9}, {3.950353114720257*^9, 3.950353129544403*^9}, {
   3.9503531611851463`*^9, 3.9503531633850174`*^9}, {3.950353254767933*^9, 
   3.950353275908167*^9}, {3.950353306035888*^9, 3.950353313789692*^9}, {
   3.950353373076048*^9, 3.9503534989825935`*^9}, {3.950353546814895*^9, 
   3.9503536047889557`*^9}, {3.950353663113989*^9, 3.950353699554813*^9}, {
   3.9503537837233715`*^9, 3.950353825144514*^9}, {3.950354247677244*^9, 
   3.9503542477902*^9}, {3.950354284768975*^9, 3.9503542983516235`*^9}, {
   3.9503544089344807`*^9, 3.950354428715313*^9}, {3.950354904520048*^9, 
   3.950354955436203*^9}, 3.9503566174601173`*^9, {3.950893488091315*^9, 
   3.950893830883383*^9}, {3.9508952457050953`*^9, 3.9508952614233494`*^9}, 
   3.950895445865364*^9, {3.9522579129877396`*^9, 3.952257927344076*^9}, {
   3.957204844806978*^9, 3.9572048465484695`*^9}, {3.958150700467964*^9, 
   3.958150740977808*^9}, {3.958152881948017*^9, 3.95815289042824*^9}},
 CellLabel->
  "In[687]:=",ExpressionUUID->"4061d110-1f58-e340-ab40-5bfd721299b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntReplace of GVVF"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400376854912*^9, 3.9484004026179485`*^9}, {3.948400505811919*^9, 
   3.948400527306937*^9}, {3.948979009722978*^9, 3.9489790170032864`*^9}, 
   3.949090062316096*^9, 3.949091439646503*^9, 3.9491724484764156`*^9, {
   3.9496963588724804`*^9, 
   3.949696364096567*^9}},ExpressionUUID->"c8a68f68-4e06-5c4d-b75b-\
a38d01b8f187"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExpandVertIntReplace", "[", "options___", "]"}], "[", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{
      RowBox[{"VertInt", "[", 
       RowBox[{"gvvf_", "?", "GeneralizedVVFQ"}], "]"}], "[", 
      RowBox[{
       RowBox[{"tensor_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], 
     "]"}], "]"}], "/;", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"gvvf", ",", "Plus"}], "]"}], "&&", 
    RowBox[{"!", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ComponentsOfGeneralizedVVF", "[", "gvvf", "]"}], "~", "Join",
         "~", 
        RowBox[{"(", 
         RowBox[{"VertDiff", "/@", 
          RowBox[{"ComponentsOfGeneralizedVVF", "[", "gvvf", "]"}]}], ")"}]}],
        ",", "tensor"}], "]"}]}], "&&", 
    RowBox[{"VanishOverOtherForms", "[", "gvvf", "]"}]}]}], ":=", "0"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ExpandVertIntReplace", "[", "options___", "]"}], "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{"VertInt", "[", 
        RowBox[{"gvvf_", "?", "GeneralizedVVFQ"}], "]"}], "[", 
       RowBox[{
        RowBox[{"tensor_", "?", "VertExactHeadQ"}], "[", "inds___", "]"}], 
       "]"}], "]"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"gvvf", ",", "Plus"}], "]"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"VertDiff", "/@", 
        RowBox[{"ComponentsOfGeneralizedVVF", "[", "gvvf", "]"}]}], ",", 
       "tensor"}], "]"}], "&&", 
     RowBox[{"!", 
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"ComponentsOfGeneralizedVVF", "[", "gvvf", "]"}], ",", 
        "tensor"}], "]"}]}], "&&", 
     RowBox[{"VanishOverOtherForms", "[", "gvvf", "]"}]}]}], ":=", 
   RowBox[{
    RowBox[{"VertInt", "[", "gvvf", "]"}], "[", 
    RowBox[{"tensor", "[", "inds", "]"}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandVertIntReplace", "[", "options___", "]"}], "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"VertInt", "[", 
      RowBox[{"gvvf_", "?", "GeneralizedVVFQ"}], "]"}], "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], 
    "]"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", "\t", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"position", "=", 
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"ComponentsOfGeneralizedVVF", "[", "gvvf", "]"}], ",", 
         "tensor", ",", "1"}], "]"}]}], ",", "result"}], "}"}], ",", "\n", 
    "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"result", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"position", "===", 
         RowBox[{"{", "}"}]}], ",", "\n", "\t\t\t\t", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"VanishOverOtherForms", "[", "gvvf", "]"}], ",", "0", ",", 
          RowBox[{
           RowBox[{"VertInt", "[", "gvvf", "]"}], "[", 
           RowBox[{"tensor", "[", "inds", "]"}], "]"}]}], "]"}], ",", "\n", 
        "\t\t\t\t", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"tensor", "[", "inds", "]"}], "//", 
           RowBox[{"SeparateMetric", "[", "]"}]}], ")"}], "/.", 
         RowBox[{
          RowBox[{"RulesOfGeneralizedVVFQ", "[", "gvvf", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"position", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}], "\n", 
       "\t\t\t", "]"}]}], ";", "\n", "\t\t", "\n", "\t", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"This", " ", "is", " ", "a", " ", "safety", " ", 
        RowBox[{"measure", ".", " ", "It"}], " ", "checks", " ", "if", " ", 
        "the", " ", "rule", " ", "has", " ", "been", " ", "applied"}], ",", 
       " ", 
       RowBox[{
       "otherwise", " ", "it", " ", "leaves", " ", "the", " ", "expression", " ", 
        RowBox[{
         RowBox[{"VertInt", "[", "vvf", "]"}], "[", 
         RowBox[{"dltensor", "[", "inds", "]"}], "]"}], " ", "unchanged"}]}], 
      " ", "*)"}], "\n", "\t", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"result", "===", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"tensor", "[", "inds", "]"}], "//", 
          RowBox[{"SeparateMetric", "[", "]"}]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"VertInt", "[", "gvvf", "]"}], "[", 
        RowBox[{"tensor", "[", "inds", "]"}], "]"}], ",", "result"}], 
      "]"}]}]}], "\n", "]"}]}]}], "Code",
 CellChangeTimes->{{3.9496963664494953`*^9, 3.949696366800793*^9}, {
   3.949696413992693*^9, 3.949696484756628*^9}, {3.950356664662227*^9, 
   3.9503567079145145`*^9}, {3.95035674847782*^9, 3.9503568101483517`*^9}, {
   3.950356846462523*^9, 3.9503569051384583`*^9}, {3.950357054632557*^9, 
   3.950357208187203*^9}, 3.95035736925622*^9, {3.950357478733015*^9, 
   3.950357558632571*^9}, {3.950357657409539*^9, 3.950357658119683*^9}, {
   3.9503577133017273`*^9, 3.950357728732668*^9}, {3.9503577592827816`*^9, 
   3.950357762185744*^9}, {3.950357901848728*^9, 3.9503579182287407`*^9}, {
   3.9521938720107193`*^9, 3.952193908640253*^9}, {3.952193942427086*^9, 
   3.9521939493119144`*^9}, {3.9521939840479145`*^9, 3.952194001993824*^9}, {
   3.9521940575485897`*^9, 3.952194070987425*^9}, 3.952196266799059*^9, {
   3.9521963294391003`*^9, 3.9521963786607304`*^9}, {3.952196658421423*^9, 
   3.9521966729483967`*^9}},
 CellLabel->
  "In[692]:=",ExpressionUUID->"f5e47de4-79ce-6142-8588-88b5dc05f7d4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ExpandVertIntReplace of abstract VVF"
}], "Subsection",
 CellChangeTimes->{{3.931835958102619*^9, 3.9318359646049037`*^9}, 
   3.9320296879290123`*^9, 3.9483957143538713`*^9, {3.948395888791578*^9, 
   3.9483959070831566`*^9}, {3.9483963801596594`*^9, 
   3.9483963846167235`*^9}, {3.948400229115434*^9, 3.9484002370003414`*^9}, {
   3.948400376854912*^9, 3.9484004026179485`*^9}, {3.948400505811919*^9, 
   3.948400527306937*^9}, {3.948979009722978*^9, 3.9489790170032864`*^9}, 
   3.949090062316096*^9, 3.949091439646503*^9, 3.9491724484764156`*^9, {
   3.9496963588724804`*^9, 3.949696364096567*^9}, {3.9496964068475876`*^9, 
   3.9496964108045254`*^9}},ExpressionUUID->"ad6d4925-b0a9-0243-8e1b-\
288bdf0b6a9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Case", " ", "base"}], ",", " ", 
    RowBox[{
    "it", " ", "leaves", " ", "the", " ", "expression", " ", "as", " ", 
     "is"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ExpandVertIntReplace", "[", "options___", "]"}], "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{"VertInt", "[", "vvf_", "]"}], "[", "tensor_", "]"}], "]"}], 
     "]"}], ":=", 
    RowBox[{
     RowBox[{"VertInt", "[", "vvf", "]"}], "[", "tensor", "]"}]}], 
   ";"}]}]], "Code",
 CellChangeTimes->{
  3.949696419250122*^9, {3.950218609919279*^9, 3.950218611804586*^9}, {
   3.950356913698955*^9, 3.950356927597407*^9}, {3.950357024578205*^9, 
   3.950357026072241*^9}, 3.950614035016634*^9, 3.9510513476733017`*^9, {
   3.9512250105121365`*^9, 3.95122501072921*^9}},
 CellLabel->
  "In[695]:=",ExpressionUUID->"100c76b7-463d-0a4d-8e08-b3a7a8fcfb4e"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ". Modifications to other definitions"
}], "Chapter",
 CellChangeTimes->{{3.9318353438923273`*^9, 3.93183534696952*^9}, {
   3.932636606099285*^9, 3.9326366080589304`*^9}, {3.948391736052903*^9, 
   3.9483917549598455`*^9}, {3.948392906134357*^9, 3.948392912502523*^9}, {
   3.948395495884749*^9, 3.9483955295933666`*^9}, {3.948395616901968*^9, 
   3.9483956198607283`*^9}, 
   3.9586484234388885`*^9},ExpressionUUID->"a8af6594-e324-4c4d-952a-\
97ab6e75d252"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Auxiliary functions"
}], "Section",
 CellChangeTimes->{
  3.932387546357408*^9, {3.94839560822535*^9, 3.948395622914029*^9}, {
   3.954866244864443*^9, 
   3.954866247578129*^9}},ExpressionUUID->"ef4b102c-8be0-7b4f-adb4-\
109480cb88ee"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". DefTotalDerivative for PD"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, 
   3.9512432813843536`*^9, {3.9550956545635853`*^9, 
   3.9550956553613186`*^9}},ExpressionUUID->"2526715d-9142-b14f-8988-\
01db3ebdc3cd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"TotalDerivativeQ", "[", "_", "]"}], ":=", "False"}], "\n", 
 RowBox[{
  RowBox[{"NormalOfCovDQ", "[", "_", "]"}], ":=", "False"}], "\n", 
 RowBox[{
  RowBox[{"dlNormalOfCovDQ", "[", "_", "]"}], ":=", "False"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"NormalOfCovDQ", "[", 
    RowBox[{
     RowBox[{"tensor_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], ":=", 
   RowBox[{"NormalOfCovDQ", "[", "tensor", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"dlNormalOfCovDQ", "[", 
     RowBox[{
      RowBox[{"tensor_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], ":=", 
    RowBox[{"dlNormalOfCovDQ", "[", "tensor", "]"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "DefTotalDerivative", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
     "ProtectNewSymbol", " ", "\[RightArrow]", " ", "$ProtectNewSymbols"}], 
     "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DefTotalDerivative", "[", 
    RowBox[{"PD", ",", 
     RowBox[{"manifold_", "?", "ManifoldQ"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"head", "=", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<TotalDerivativeOfPDOf\>\"", "<>", 
         RowBox[{"ToString", "[", "manifold", "]"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "    ", "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"MakexTensions", "[", 
       RowBox[{
       "DefTotalDerivative", ",", "\"\<Beginning\>\"", ",", "manifold"}], 
       "]"}], ";", "\n", "\t", "\n", "\t", 
      RowBox[{"DefInertHead", "[", 
       RowBox[{"head", ",", 
        RowBox[{"LinearQ", "->", "False"}], ",", 
        RowBox[{"ContractThrough", "\[Rule]", 
         RowBox[{"{", "delta", "}"}]}]}], "]"}], ";", "\n", "\t", 
      RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
       RowBox[{"head", ",", "manifold", ",", 
        RowBox[{"{", "manifold", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      "\t\t", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"head", "[", "0", "]"}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"head", "/:", " ", 
       RowBox[{
        RowBox[{"head", "[", "a_", "]"}], "+", 
        RowBox[{"head", "[", "b_", "]"}]}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"a", "+", "b"}], "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"head", "/:", " ", 
       RowBox[{"Times", "[", 
        RowBox[{
         RowBox[{"a_", "?", "ConstantQ"}], ",", 
         RowBox[{"head", "[", "b_", "]"}]}], "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"Times", "[", 
         RowBox[{"a", ",", "b"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"Unprotect", "[", 
       RowBox[{"WeightOf", ",", "ToCanonical", ",", "Simplification"}], "]"}],
       ";", "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"TotalDerivativeQ", "[", "head", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"TotalDerivativeQ", "[", 
        RowBox[{"head", "[", "_", "]"}], "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"TotalDerivativeOfManifold", "[", "manifold", "]"}], "^=", 
       "head"}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"CovDOfTotalDerivative", "[", "head", "]"}], "^=", "PD"}], ";",
       "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"CovDOfTotalDerivative", "[", 
        RowBox[{"head", "[", "_", "]"}], "]"}], "^=", "PD"}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"NormalOfTotalDerivative", "[", "head", "]"}], "^=", 
       RowBox[{"NormalOfManifold", "[", "manifold", "]"}]}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"NormalOfTotalDerivative", "[", 
        RowBox[{"head", "[", "_", "]"}], "]"}], "^=", 
       RowBox[{"NormalOfManifold", "[", "manifold", "]"}]}], ";", "\n", 
      RowBox[{"(*", "\t", 
       RowBox[{
        RowBox[{
         RowBox[{"TotalDerivativeOfCovD", "[", "PD", "]"}], "^:=", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
           "Print", "[", "\"\<TotalDerivativeOfCovD[PD] has been used.\>\"", 
            "]"}], ";", 
           RowBox[{"{", "}"}]}], ")"}]}], ";"}], "*)"}], "\n", "\t", "\n", 
      "\t", 
      RowBox[{
       RowBox[{"ToCanonical", "[", "expr_head", "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"ToCanonical", "@@", "expr"}], "]"}]}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"ToCanonical", "[", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{"head", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"ToCanonical", "[", "expr", "]"}], "]"}]}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"Simplification", "[", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{"head", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"Simplification", "[", "expr", "]"}], "]"}]}], ";", "\n", 
      "\t", 
      RowBox[{
       RowBox[{
        RowBox[{"xAct`xTensor`Private`ContractMetric0", "[", "args__", "]"}], 
        "[", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{"head", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{
         RowBox[{"xAct`xTensor`Private`ContractMetric0", "[", "args", "]"}], "[",
          "expr", "]"}], "]"}]}], ";", "\[IndentingNewLine]", "\t    ", "\n", 
      "    ", 
      RowBox[{
       RowBox[{"WeightOf", "[", 
        RowBox[{
         RowBox[{"ih_", "?", "InertHeadQ"}], "[", "__", "]"}], "]"}], "=."}], 
      ";", "\n", "    ", 
      RowBox[{
       RowBox[{"WeightOf", "[", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{"head", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
       RowBox[{"WeightOf", "[", "expr", "]"}]}], ";", "\n", "    ", 
      RowBox[{
       RowBox[{"WeightOf", "[", 
        RowBox[{
         RowBox[{"ih_", "?", "InertHeadQ"}], "[", "__", "]"}], "]"}], ":=", 
       RowBox[{"Throw", "[", 
        RowBox[{"Message", "[", 
         RowBox[{
          StyleBox[
           RowBox[{"WeightOf", "::", "error"}], "MessageName"], 
          ",", "\"\<WeightOf is generically undefined on inert heads.\>\""}], 
         "]"}], "]"}]}], ";", "\n", "     ", "\n", "\t", 
      RowBox[{"Protect", "[", 
       RowBox[{"WeightOf", ",", "ToCanonical", ",", "Simplification"}], "]"}],
       ";", "\n", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{"DefTotalDerivative", ",", "\"\<End\>\"", ",", "manifold"}], 
       "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Code",
 CellChangeTimes->{{3.951236122922409*^9, 3.951236163568041*^9}, {
   3.9512362845745544`*^9, 3.951236366147751*^9}, 3.9512365609076595`*^9, {
   3.951236614188221*^9, 3.951236636963022*^9}, {3.95123667524412*^9, 
   3.9512368832924404`*^9}, {3.951236915294754*^9, 3.951236917069918*^9}, {
   3.951236955266109*^9, 3.951237252424486*^9}, {3.951237290050108*^9, 
   3.951237334109112*^9}, {3.951237383271255*^9, 3.9512374538623962`*^9}, {
   3.9512375143744583`*^9, 3.951237584885195*^9}, {3.951237696262829*^9, 
   3.951237702191948*^9}, {3.951237780451599*^9, 3.951237781742699*^9}, {
   3.951237830106905*^9, 3.951237917350708*^9}, {3.951238380053295*^9, 
   3.951238646599262*^9}, {3.9512386900895*^9, 3.951238737770984*^9}, {
   3.951238854796791*^9, 3.951238861469061*^9}, {3.951238928492399*^9, 
   3.951239085142296*^9}, {3.95123914640813*^9, 3.9512392473072796`*^9}, {
   3.951239325083441*^9, 3.951239340137127*^9}, {3.951239443897812*^9, 
   3.951239489474178*^9}, {3.9512395720160255`*^9, 3.951239683662409*^9}, {
   3.9512399336982937`*^9, 3.951239953336315*^9}, {3.9512402976977*^9, 
   3.951240300751905*^9}, {3.951240477880766*^9, 3.951240504723301*^9}, {
   3.951242975776562*^9, 3.951242976856607*^9}, {3.951243198521587*^9, 
   3.951243198943205*^9}, {3.951308971553873*^9, 3.951309000258081*^9}, {
   3.951309181258539*^9, 3.9513091823222504`*^9}, {3.951309555120283*^9, 
   3.9513097143736725`*^9}, 3.9513102135357647`*^9, {3.951329017211754*^9, 
   3.951329018880621*^9}, {3.9513387134225006`*^9, 3.95133871655241*^9}, {
   3.9514854708496*^9, 3.951485473062767*^9}, {3.9522144586079197`*^9, 
   3.952214460766388*^9}, 3.952214524873356*^9, {3.952257515647537*^9, 
   3.9522575835391693`*^9}, {3.952267097321947*^9, 3.95226711548094*^9}, {
   3.952267150820818*^9, 3.9522671692356224`*^9}, {3.952267207917494*^9, 
   3.952267362602827*^9}, {3.9522677712836246`*^9, 3.952267811900097*^9}, {
   3.952268006073002*^9, 3.9522680140466003`*^9}, {3.9522687577990856`*^9, 
   3.952268760804449*^9}, {3.952280375797785*^9, 3.9522803858451576`*^9}, 
   3.9522805090599537`*^9, {3.953298456314945*^9, 3.953298459349348*^9}, {
   3.953316977965847*^9, 3.9533169872869434`*^9}, {3.953317078853283*^9, 
   3.9533170812193394`*^9}, {3.953486161618946*^9, 3.953486258767784*^9}, {
   3.9538335259595947`*^9, 3.953833529361492*^9}, {3.954517440459116*^9, 
   3.954517449041191*^9}, {3.954517574182207*^9, 3.9545175768798466`*^9}, {
   3.9545179953885403`*^9, 3.9545179967345085`*^9}, {3.955719920085312*^9, 
   3.9557199335966263`*^9}, {3.955720057833912*^9, 3.9557201202556896`*^9}, {
   3.957211732047922*^9, 3.9572118060181847`*^9}, {3.957211876624729*^9, 
   3.957211888848503*^9}, {3.957227927558378*^9, 3.957227929542284*^9}, 
   3.958312926989401*^9, {3.9626350330425854`*^9, 3.962635036024683*^9}, {
   3.96393915141094*^9, 3.963939166359741*^9}, {3.9639392864982433`*^9, 
   3.9639393453966312`*^9}, {3.9639395194098434`*^9, 
   3.9639395265194855`*^9}, {3.9639401932019424`*^9, 
   3.963940194760662*^9}},ExpressionUUID->"e21e479a-bdd7-e34e-9c56-\
1f2e5e6bbc53"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". DefTotalDerivative for generic CovD"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, 
   3.9512432813843536`*^9, {3.954866288423559*^9, 3.954866289428175*^9}, {
   3.955095625407736*^9, 3.9550956259037952`*^9}, {3.9550956586262627`*^9, 
   3.955095659357897*^9}},ExpressionUUID->"29b7a4dc-3392-e248-bc1c-\
aa04f063e763"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefTotalDerivative", "[", 
    RowBox[{"der_", "?", "CovDQ"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"head", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<TotalDerivativeOf\>\"", "<>", 
          RowBox[{"ToString", "[", "der", "]"}]}], "]"}]}], ",", 
       RowBox[{"metric", "=", 
        RowBox[{"MetricOfCovD", "[", "der", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{"MakexTensions", "[", 
       RowBox[{"DefTotalDerivative", ",", "\"\<Beginning\>\"", ",", "der"}], 
       "]"}], ";", "\n", "\t", "\n", "\t", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"xTensorQ", "[", "metric", "]"}], ",", " ", 
        RowBox[{"(*", "  ", 
         RowBox[{
          RowBox[{
          "Unless", " ", "I", " ", "am", " ", "missing", " ", "something"}], ",",
           " ", 
          RowBox[{
           RowBox[{
           "it", " ", "only", " ", "makes", " ", "sense", " ", "for", " ", 
            RowBox[{"metrics", ".", " ", "But"}], " ", "I", " ", "allow", " ",
             "for", " ", "non"}], "-", 
           RowBox[{"metrics", " ", "just", " ", "in", " ", 
            RowBox[{"case", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
        "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"DefInertHead", "[", 
           RowBox[{"head", ",", 
            RowBox[{"LinearQ", "->", "False"}], ",", 
            RowBox[{"ContractThrough", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"delta", ",", "metric"}], "}"}]}]}], "]"}], ";", "\n", 
          "\t\t", 
          RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
           RowBox[{"head", ",", "metric", ",", 
            RowBox[{"{", "metric", "}"}]}], "]"}], ";"}], "\n", "\t\t", ")"}],
         ",", "\[IndentingNewLine]", "\t\t", 
        RowBox[{"(", "\n", "\t\t", 
         RowBox[{
          RowBox[{"DefInertHead", "[", 
           RowBox[{"head", ",", 
            RowBox[{"LinearQ", "->", "False"}], ",", 
            RowBox[{"ContractThrough", "\[Rule]", 
             RowBox[{"{", "delta", "}"}]}]}], "]"}], ";", "\n", "\t\t", 
          RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
           RowBox[{"head", ",", "der", ",", 
            RowBox[{"{", "der", "}"}]}], "]"}], ";"}], 
         RowBox[{"(*", " ", 
          RowBox[{
          "I", " ", "expected", " ", "this", " ", "to", " ", "work", " ", 
           "for", " ", "both", " ", "but", " ", "it", " ", 
           RowBox[{"doesn", "'"}], 
           RowBox[{"t", "."}]}], " ", "*)"}], "\n", "\t\t", ")"}]}], 
       "\[IndentingNewLine]", "\t", "]"}], ";", "\[IndentingNewLine]", "\t\t",
       "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"head", "[", "0", "]"}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{"head", "/:", " ", 
       RowBox[{
        RowBox[{"head", "[", "a_", "]"}], "+", 
        RowBox[{"head", "[", "b_", "]"}]}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"a", "+", "b"}], "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"head", "/:", " ", 
       RowBox[{"Times", "[", 
        RowBox[{
         RowBox[{"a_", "?", "ConstantQ"}], ",", 
         RowBox[{"head", "[", "b_", "]"}]}], "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"Times", "[", 
         RowBox[{"a", ",", "b"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"Unprotect", "[", 
       RowBox[{"WeightOf", ",", "ToCanonical", ",", "Simplification"}], "]"}],
       ";", "\[IndentingNewLine]", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"TotalDerivativeQ", "[", "head", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"TotalDerivativeQ", "[", 
        RowBox[{"head", "[", "_", "]"}], "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"TotalDerivativeOfCovD", "[", "der", "]"}], "^=", "head"}], ";",
       "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"CovDOfTotalDerivative", "[", "head", "]"}], "^=", "der"}], ";",
       "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"CovDOfTotalDerivative", "[", 
        RowBox[{"head", "[", "_", "]"}], "]"}], "^=", "der"}], ";", "\n", 
      "\t", 
      RowBox[{
       RowBox[{"NormalOfTotalDerivative", "[", "head", "]"}], "^=", 
       RowBox[{"NormalOfCovD", "[", "der", "]"}]}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"NormalOfTotalDerivative", "[", 
        RowBox[{"head", "[", "_", "]"}], "]"}], "^=", 
       RowBox[{"NormalOfCovD", "[", "der", "]"}]}], ";", "\n", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"ToCanonical", "[", "expr_head", "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"ToCanonical", "@@", "expr"}], "]"}]}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"ToCanonical", "[", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{"head", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"ToCanonical", "[", "expr", "]"}], "]"}]}], ";", "\n", "\t", 
      RowBox[{
       RowBox[{"Simplification", "[", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{"head", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{"Simplification", "[", "expr", "]"}], "]"}]}], ";", "\n", 
      "\t", 
      RowBox[{
       RowBox[{
        RowBox[{"xAct`xTensor`Private`ContractMetric0", "[", "args__", "]"}], 
        "[", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{"head", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
       RowBox[{"head", "[", 
        RowBox[{
         RowBox[{"xAct`xTensor`Private`ContractMetric0", "[", "args", "]"}], "[",
          "expr", "]"}], "]"}]}], ";", "\[IndentingNewLine]", "        ", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{
       RowBox[{"WeightOf", "[", 
        RowBox[{
         RowBox[{"ih_", "?", "InertHeadQ"}], "[", "__", "]"}], "]"}], "=."}], 
      ";", "\n", "    ", 
      RowBox[{
       RowBox[{"WeightOf", "[", 
        RowBox[{"HoldPattern", "[", 
         RowBox[{"head", "[", "expr_", "]"}], "]"}], "]"}], ":=", 
       RowBox[{"WeightOf", "[", "expr", "]"}]}], ";", "\n", "    ", 
      RowBox[{
       RowBox[{"WeightOf", "[", 
        RowBox[{
         RowBox[{"ih_", "?", "InertHeadQ"}], "[", "__", "]"}], "]"}], ":=", 
       RowBox[{"Throw", "[", 
        RowBox[{"Message", "[", 
         RowBox[{
          StyleBox[
           RowBox[{"WeightOf", "::", "error"}], "MessageName"], 
          ",", "\"\<WeightOf is generically undefined on inert heads.\>\""}], 
         "]"}], "]"}]}], ";", "\n", "     ", "\n", "\t", 
      RowBox[{"Protect", "[", 
       RowBox[{"WeightOf", ",", "ToCanonical", ",", "Simplification"}], "]"}],
       ";", "\n", "\t", "\[IndentingNewLine]", "\t", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{"DefTotalDerivative", ",", "\"\<End\>\"", ",", "der"}], "]"}], 
      ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Code",
 CellChangeTimes->{{3.951236122922409*^9, 3.951236163568041*^9}, {
   3.9512362845745544`*^9, 3.951236366147751*^9}, 3.9512365609076595`*^9, {
   3.951236614188221*^9, 3.951236636963022*^9}, {3.95123667524412*^9, 
   3.9512368832924404`*^9}, {3.951236915294754*^9, 3.951236917069918*^9}, {
   3.951236955266109*^9, 3.951237252424486*^9}, {3.951237290050108*^9, 
   3.951237334109112*^9}, {3.951237383271255*^9, 3.9512374538623962`*^9}, {
   3.9512375143744583`*^9, 3.951237584885195*^9}, {3.951237696262829*^9, 
   3.951237702191948*^9}, {3.951237780451599*^9, 3.951237781742699*^9}, {
   3.951237830106905*^9, 3.951237917350708*^9}, {3.951238380053295*^9, 
   3.951238646599262*^9}, {3.9512386900895*^9, 3.951238737770984*^9}, {
   3.951238854796791*^9, 3.951238861469061*^9}, {3.951238928492399*^9, 
   3.951239085142296*^9}, {3.95123914640813*^9, 3.9512392473072796`*^9}, {
   3.951239325083441*^9, 3.951239340137127*^9}, {3.951239443897812*^9, 
   3.951239489474178*^9}, {3.9512395720160255`*^9, 3.951239683662409*^9}, {
   3.9512399336982937`*^9, 3.951239953336315*^9}, {3.9512402976977*^9, 
   3.951240300751905*^9}, {3.951240477880766*^9, 3.951240504723301*^9}, {
   3.951242975776562*^9, 3.951242976856607*^9}, {3.951243198521587*^9, 
   3.951243198943205*^9}, {3.951308971553873*^9, 3.951309000258081*^9}, {
   3.951309181258539*^9, 3.9513091823222504`*^9}, {3.951309555120283*^9, 
   3.9513097143736725`*^9}, 3.9513102135357647`*^9, {3.951329017211754*^9, 
   3.951329018880621*^9}, {3.9513387134225006`*^9, 3.95133871655241*^9}, {
   3.9514854708496*^9, 3.951485473062767*^9}, {3.9522144586079197`*^9, 
   3.952214460766388*^9}, 3.952214524873356*^9, {3.952257515647537*^9, 
   3.9522575835391693`*^9}, {3.952267097321947*^9, 3.95226711548094*^9}, {
   3.952267150820818*^9, 3.9522671692356224`*^9}, {3.952267207917494*^9, 
   3.952267221483431*^9}, {3.9522676144957485`*^9, 3.952267630154665*^9}, 
   3.9522686951678333`*^9, 3.952268775285349*^9, {3.952279450600849*^9, 
   3.95227947188307*^9}, {3.9522803585479774`*^9, 3.9522803786930695`*^9}, {
   3.9523092080179157`*^9, 3.95230921013266*^9}, {3.953298466540333*^9, 
   3.9532984685782223`*^9}, {3.953485499703373*^9, 3.953485501307562*^9}, {
   3.953486240450882*^9, 3.9534862731117783`*^9}, {3.9557201267133865`*^9, 
   3.9557201682765255`*^9}, {3.957227967135168*^9, 3.9572279673409176`*^9}},
 CellLabel->
  "In[703]:=",ExpressionUUID->"f492522d-460b-714b-ae1d-15366e3b5859"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". DefNormalOfCovD for PD"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, 
   3.9512432813843536`*^9, 3.9522685784660645`*^9, {3.9548662784906654`*^9, 
   3.9548662794032936`*^9}},ExpressionUUID->"7ad0d673-33c4-4143-8bc4-\
268f3cc0ab5e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "DefNormalOfCovD", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
     "ProtectNewSymbol", " ", "\[RightArrow]", " ", "$ProtectNewSymbols"}], 
     "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"DefNormalOfCovD", "[", 
   RowBox[{"PD", ",", "ind_", ",", 
    RowBox[{"manifold_", "?", "ManifoldQ"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", "\n", "\t", 
   RowBox[{
    RowBox[{"{", "\n", "\t", 
     RowBox[{
      RowBox[{"nameNormal", "=", 
       RowBox[{"ToExpression", "@", 
        RowBox[{"StringJoin", "[", 
         RowBox[{"\"\<NormalOfPDOf\>\"", ",", 
          RowBox[{"ToString", "[", "manifold", "]"}]}], "]"}]}]}], ",", "\n", 
      "\t", 
      RowBox[{"printAs", "=", 
       RowBox[{"\"\<(\\*SubscriptBox[n,\\(\>\"", "<>", 
        RowBox[{"ToString", "@", 
         RowBox[{"PrintAs", "@", "manifold"}]}], "<>", "\"\<\\)])\>\""}]}]}], 
     "\n", "\t", "}"}], ",", "\n", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"MakexTensions", "[", 
      RowBox[{
      "DefNormalOfCovD", ",", "\"\<Beginning\>\"", ",", "ind", ",", 
       "manifold"}], "]"}], ";", "\n", "\t", "\n", "\t", 
     RowBox[{"DefTensor", "[", 
      RowBox[{
       RowBox[{"nameNormal", "[", 
        RowBox[{"-", "ind"}], "]"}], ",", "manifold", ",", 
       RowBox[{"PrintAs", "->", "printAs"}], ",", 
       RowBox[{"VariationallyConstantQ", "->", "True"}]}], "]"}], ";", "\n", 
     "\t\t\t", "\n", "    ", 
     RowBox[{
      RowBox[{"NormalOfManifold", "[", "manifold", "]"}], "^=", 
      "nameNormal"}], ";", "\n", "\t", 
     RowBox[{
      RowBox[{"CovDOfNormal", "[", "nameNormal", "]"}], "^=", "PD"}], ";", 
     "\n", "\t", 
     RowBox[{
      RowBox[{"TotalDerivativeOfNormal", "[", "nameNormal", "]"}], "^=", 
      RowBox[{"TotalDerivativeOfManifold", "[", "manifold", "]"}]}], ";", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{
      RowBox[{"NormalOfCovDQ", "[", "nameNormal", "]"}], "^=", "True"}], ";", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{
      RowBox[{"NormalOfPDQ", "[", "nameNormal", "]"}], "^=", "True"}], ";", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{
      RowBox[{"dlNormalOfCovDQ", "[", 
       RowBox[{"VertDiff", "@", "nameNormal"}], "]"}], "^=", "True"}], ";", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{
      RowBox[{"dlNormalOfPDQ", "[", 
       RowBox[{"VertDiff", "@", "nameNormal"}], "]"}], "^=", "True"}], ";", 
     "\[IndentingNewLine]", "    ", "\n", "\t", 
     RowBox[{"MakexTensions", "[", 
      RowBox[{
      "DefNormalOfCovD", ",", "\"\<End\>\"", ",", "ind", ",", "manifold"}], 
      "]"}], ";"}]}], "\n", "]"}]}]}], "Code",
 CellChangeTimes->{{3.952264377158701*^9, 3.952264477612545*^9}, {
   3.952264525487728*^9, 3.9522646048387775`*^9}, {3.9522649304508877`*^9, 
   3.952264931906534*^9}, 3.9522650112977886`*^9, {3.952265091642496*^9, 
   3.952265135302431*^9}, {3.952265293903713*^9, 3.9522653021285686`*^9}, {
   3.9522654259347973`*^9, 3.952265442827263*^9}, {3.9522655078673363`*^9, 
   3.952265509713381*^9}, 3.9522657113358536`*^9, {3.952266464320942*^9, 
   3.9522664885042877`*^9}, {3.952267996674492*^9, 3.952268000725855*^9}, 
   3.95226919498522*^9, {3.9522692360304527`*^9, 3.952269238046278*^9}, 
   3.952272181405142*^9, {3.9522723208182487`*^9, 3.9522723284736404`*^9}, {
   3.9522724773091908`*^9, 3.9522724777296867`*^9}, {3.952280316831087*^9, 
   3.9522803333455143`*^9}, {3.9522806003139515`*^9, 3.952280602814108*^9}, {
   3.9533171203379803`*^9, 3.953317122491001*^9}, {3.953728666802437*^9, 
   3.953728677938875*^9}, {3.9537288729264145`*^9, 3.953728874308777*^9}, {
   3.9538143610093155`*^9, 3.953814393498518*^9}, {3.9538147598961277`*^9, 
   3.953814805213333*^9}, {3.9538334903204937`*^9, 3.953833502454008*^9}, {
   3.953833539528988*^9, 3.953833544022173*^9}, {3.9545135206667576`*^9, 
   3.9545135234197617`*^9}, {3.9545171500641823`*^9, 
   3.9545171521688633`*^9}, {3.95451760397377*^9, 3.954517607739609*^9}, {
   3.9547762966569557`*^9, 3.954776318347471*^9}, {3.954867128443926*^9, 
   3.954867163649517*^9}, {3.954946442671089*^9, 3.9549464813331413`*^9}, {
   3.9551906879864655`*^9, 3.955190715738762*^9}, {3.955720175130089*^9, 
   3.9557202171302757`*^9}, {3.9565211249142857`*^9, 3.956521128699234*^9}, {
   3.957208153970522*^9, 3.9572082021143513`*^9}, {3.9572787093328743`*^9, 
   3.9572787489256725`*^9}, {3.9573163661616344`*^9, 3.957316375855961*^9}, {
   3.9573164143075924`*^9, 3.957316416321913*^9}, {3.9573174350661545`*^9, 
   3.9573174385771656`*^9}, 3.958312936741665*^9, {3.9626342173877773`*^9, 
   3.9626342183798447`*^9}, {3.9626348635922565`*^9, 
   3.9626348693001137`*^9}, {3.962635213755724*^9, 3.962635248610771*^9}, {
   3.962635383026985*^9, 3.9626353854874344`*^9}, {3.9626355062048035`*^9, 
   3.9626355075419693`*^9}, {3.9626357480532646`*^9, 3.962635755669447*^9}, {
   3.9626362083535233`*^9, 3.9626362130823574`*^9}, {3.9626373684837475`*^9, 
   3.962637371855629*^9}, {3.9626377523836136`*^9, 3.9626377538796673`*^9}, {
   3.962637993445961*^9, 3.9626379977993927`*^9}, 3.9626380767722626`*^9, 
   3.9639385100460796`*^9, 3.9639387405149765`*^9, {3.96393903912685*^9, 
   3.96393914183304*^9}, {3.9639393502338333`*^9, 3.9639393625190926`*^9}, {
   3.963939437617567*^9, 3.9639394387507553`*^9}, {3.963939510660061*^9, 
   3.963939511160406*^9}, 
   3.9639401849535465`*^9},ExpressionUUID->"2dc20998-dbc0-bc4d-bc52-\
9bb592524212"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". DefNormalOfCovD for generic CovD"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, 
   3.9512432813843536`*^9, 3.9522685784660645`*^9, {3.9550956431457767`*^9, 
   3.9550956470000286`*^9}},ExpressionUUID->"86257332-4dba-e646-bb3d-\
30931f4a9dac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefNormalOfCovD", "[", 
   RowBox[{"covd_", ",", "ind_", ",", 
    RowBox[{"manifold_", "?", "ManifoldQ"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", "\n", "\t", 
   RowBox[{
    RowBox[{"{", "\n", "\t", 
     RowBox[{
      RowBox[{"nameNormal", "=", 
       RowBox[{"ToExpression", "@", 
        RowBox[{"StringJoin", "[", 
         RowBox[{"\"\<NormalOf\>\"", ",", 
          RowBox[{"ToString", "[", "covd", "]"}]}], "]"}]}]}], ",", "\n", 
      "\t", 
      RowBox[{"printAs", "=", 
       RowBox[{"\"\<(\\*SubscriptBox[n,\\(\>\"", "<>", 
        RowBox[{
         RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\)])\>\""}]}], ",", "\n",
       "\t", 
      RowBox[{"christoffel", "=", 
       RowBox[{"Christoffel", "[", "covd", "]"}]}], ",", "\n", "\t", 
      RowBox[{"inds", "=", 
       RowBox[{"GetIndicesOfVBundle", "[", 
        RowBox[{
         RowBox[{"Tangent", "[", "manifold", "]"}], ",", "3"}], "]"}]}]}], 
     "\n", "\t", "}"}], ",", "\n", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"MakexTensions", "[", 
      RowBox[{
      "DefTotalDerivative", ",", "\"\<Beginning\>\"", ",", "covd", ",", "ind",
        ",", "manifold"}], "]"}], ";", "\n", "\t", "\n", "\t", 
     RowBox[{"christoffel", "=", 
      RowBox[{"HeadOfTensor2", "[", 
       RowBox[{"christoffel", "[", 
        RowBox[{
         RowBox[{"inds", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"inds", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"inds", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], "]"}]}], ";", "\n", 
     "\t", 
     RowBox[{"DefTensor", "[", 
      RowBox[{
       RowBox[{"nameNormal", "[", 
        RowBox[{"-", "ind"}], "]"}], ",", "manifold", ",", 
       RowBox[{"PrintAs", "->", "printAs"}]}], "]"}], ";", "\t\t", "\n", 
     "    ", 
     RowBox[{"$printAddVariationalRelation", "=", "False"}], ";", "\n", "\t", 
     RowBox[{"AddVariationalRelation", "[", 
      RowBox[{"christoffel", "->", "nameNormal"}], "]"}], ";", "\t\t", "\n", 
     "    ", 
     RowBox[{"$printAddVariationalRelation", "=", "True"}], ";", "\n", "\n", 
     "\t", 
     RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
      RowBox[{"nameNormal", ",", "covd", ",", 
       RowBox[{"{", "covd", "}"}]}], "]"}], ";", "\n", "\t\t", "\n", "\t", 
     RowBox[{
      RowBox[{"NormalOfCovD", "[", "covd", "]"}], "^=", "nameNormal"}], ";", 
     "\n", "\t", 
     RowBox[{
      RowBox[{"CovDOfNormal", "[", "nameNormal", "]"}], "^=", "covd"}], ";", 
     "\n", "\t", 
     RowBox[{
      RowBox[{"TotalDerivativeOfNormal", "[", "nameNormal", "]"}], "^=", 
      RowBox[{"TotalDerivativeOfCovD", "[", "covd", "]"}]}], ";", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{
      RowBox[{"NormalOfCovDQ", "[", "nameNormal", "]"}], "^=", "True"}], ";", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{
      RowBox[{"dlNormalOfCovDQ", "[", 
       RowBox[{"VertDiff", "@", "nameNormal"}], "]"}], "^=", "True"}], ";", 
     "\[IndentingNewLine]", "    ", "\n", "\t", 
     RowBox[{"MakexTensions", "[", 
      RowBox[{
      "DefTotalDerivative", ",", "\"\<End\>\"", ",", "covd", ",", "ind", ",", 
       "manifold"}], "]"}], ";"}]}], "\n", "]"}]}]], "Code",
 CellChangeTimes->{{3.9522587287247505`*^9, 3.9522587696489983`*^9}, {
   3.9522588305177975`*^9, 3.9522588879742374`*^9}, {3.9522590401722584`*^9, 
   3.9522590528392544`*^9}, {3.952259191354254*^9, 3.9522592018104153`*^9}, {
   3.952260053106861*^9, 3.9522600587598114`*^9}, {3.952261623488985*^9, 
   3.952261637896145*^9}, 3.9522628224999504`*^9, {3.9522629867485657`*^9, 
   3.952262999499113*^9}, {3.952264141097679*^9, 3.952264155873825*^9}, 
   3.9522641910682125`*^9, {3.9522643332471867`*^9, 3.952264353742832*^9}, {
   3.9522648999692745`*^9, 3.952264923891798*^9}, {3.952265059249466*^9, 
   3.9522650618392906`*^9}, 3.952266493314886*^9, 3.952268634347172*^9, {
   3.9522686999054832`*^9, 3.952268715142559*^9}, 3.952268781694212*^9, {
   3.952269192254099*^9, 3.952269192716463*^9}, {3.952272110586336*^9, 
   3.952272135954317*^9}, 3.952272177822294*^9, 3.952272318404701*^9, 
   3.95227248198287*^9, {3.952279478593992*^9, 3.952279600837549*^9}, {
   3.9522803407542953`*^9, 3.952280348057274*^9}, {3.9523085768575*^9, 
   3.9523086109463634`*^9}, {3.952308686777973*^9, 3.952308700039404*^9}, {
   3.952308755617613*^9, 3.9523088562865257`*^9}, 3.952308907589329*^9, 
   3.952308941785347*^9, 3.9523089892314434`*^9, {3.9523100299986706`*^9, 
   3.9523100329484997`*^9}, {3.9538145941703167`*^9, 3.953814724436075*^9}, {
   3.953833550785721*^9, 3.9538335648418713`*^9}, {3.9538343535667725`*^9, 
   3.953834379805565*^9}, {3.9545180215920677`*^9, 3.9545180320611515`*^9}, {
   3.954581589015177*^9, 3.954581590971821*^9}, 3.95458195930562*^9, {
   3.954582153891712*^9, 3.954582216819786*^9}, {3.9545825062012444`*^9, 
   3.954582521587015*^9}, {3.9545881483214283`*^9, 3.954588232121418*^9}, {
   3.9545882667330933`*^9, 3.954588279682459*^9}, {3.954588342677334*^9, 
   3.9545883488916607`*^9}, {3.954774423614828*^9, 3.9547744321799107`*^9}, {
   3.955190697356369*^9, 3.9551907085250893`*^9}, {3.9557202297505665`*^9, 
   3.955720240499342*^9}, {3.9565200599543705`*^9, 3.9565200611942635`*^9}, {
   3.9572082174383087`*^9, 3.9572082316328297`*^9}, {3.957208969235916*^9, 
   3.9572089725544014`*^9}, {3.957228003877884*^9, 3.957228009652666*^9}, {
   3.9572787205053616`*^9, 3.9572787268891296`*^9}, 
   3.96263490149699*^9},ExpressionUUID->"9e425044-d14e-ef42-b7fd-\
1dd1786e96f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". NormalOfCovD and TotalDerivative for PD"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, 
   3.9512432813843536`*^9, 3.9522685784660645`*^9, {3.952268913327406*^9, 
   3.952268918580475*^9}},ExpressionUUID->"f25e13a1-0118-d040-8202-\
4e663cecbc5c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NormalOfCovD", "[", "PD", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "@", "$Manifolds"}], ">", "1"}], ",", 
    RowBox[{"Catch", "@", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"NormalOfCovD", "::", "error"}], 
        ",", "\"\<PD is defined over every manifold. Use NormalOfCovD[PD, \
manifold] or NormalOfCovD[PD, index] instead.\>\""}], "]"}]}]}], ",", 
    RowBox[{"NormalOfManifold", "[", 
     RowBox[{"$Manifolds", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"NormalOfCovD", "[", 
   RowBox[{"PD", ",", 
    RowBox[{"ind_", "?", "AIndexQ"}]}], "]"}], ":=", 
  RowBox[{"NormalOfManifold", "[", 
   RowBox[{"BaseOfVBundle", "@", 
    RowBox[{"VBundleOfIndex", "@", "ind"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"NormalOfCovD", "[", 
   RowBox[{"PD", ",", 
    RowBox[{"manifold_", "?", "ManifoldQ"}]}], "]"}], ":=", 
  RowBox[{"NormalOfManifold", "[", "manifold", "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NormalOfCovD", "[", 
     RowBox[{"der_", ",", "ind_"}], "]"}], "/;", 
    RowBox[{"der", "=!=", "PD"}]}], " ", ":=", 
   RowBox[{"NormalOfCovD", "[", "der", "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"TotalDerivativeOfCovD", "[", "PD", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "@", "$Manifolds"}], ">", "1"}], ",", 
    RowBox[{"Catch", "@", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"TotalDerivativeOfCovD", "::", "error"}], 
        ",", "\"\<PD is defined over every manifold. Use \
TotalDerivativeOfCovD[PD, manifold] or TotalDerivativeOfCovD[PD, index] \
instead.\>\""}], "]"}]}]}], ",", 
    RowBox[{"TotalDerivativeOfManifold", "[", 
     RowBox[{"$Manifolds", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"TotalDerivativeOfCovD", "[", 
   RowBox[{"PD", ",", 
    RowBox[{"ind_", "?", "AIndexQ"}]}], "]"}], ":=", 
  RowBox[{"TotalDerivativeOfManifold", "[", 
   RowBox[{"BaseOfVBundle", "@", 
    RowBox[{"VBundleOfIndex", "@", "ind"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"TotalDerivativeOfCovD", "[", 
   RowBox[{"PD", ",", 
    RowBox[{"manifold_", "?", "ManifoldQ"}]}], "]"}], ":=", 
  RowBox[{"TotalDerivativeOfManifold", "[", "manifold", "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TotalDerivativeOfCovD", "[", 
    RowBox[{"der_", ",", "ind_"}], "]"}], "/;", 
   RowBox[{"der", "=!=", "PD"}]}], " ", ":=", 
  RowBox[{"TotalDerivativeOfCovD", "[", "der", "]"}]}]}], "Code",
 CellChangeTimes->{{3.952264585817011*^9, 3.9522646062147655`*^9}, 
   3.9522646668136864`*^9, {3.9522651933432827`*^9, 3.9522652265303936`*^9}, {
   3.9522678272084255`*^9, 3.9522678802438316`*^9}, {3.952268786592718*^9, 
   3.9522687952355785`*^9}, {3.952269023856844*^9, 3.952269024743614*^9}, {
   3.9565197897512264`*^9, 3.956519880623766*^9}, {3.956519983159935*^9, 
   3.9565199879085445`*^9}, {3.957534703811657*^9, 3.9575347040522327`*^9}, {
   3.9575353560798855`*^9, 3.9575353881065884`*^9}, {3.957535527650818*^9, 
   3.957535535841667*^9}, 3.9575483454724293`*^9, {3.957548388595604*^9, 
   3.9575484158141594`*^9}, {3.958340561207838*^9, 3.9583405851782627`*^9}},
 CellLabel->
  "In[707]:=",ExpressionUUID->"bcb25226-7fc7-684e-8bc6-32af763c50b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". TotalDerivativeDivergenceQ and TotalDerivativeDivergenceInfo"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, 
   3.9512432813843536`*^9, 3.9522685784660645`*^9, {3.952268913327406*^9, 
   3.952268918580475*^9}, {3.9573808018278217`*^9, 
   3.957380805910372*^9}},ExpressionUUID->"e7b0b020-2230-c14d-90de-\
beec44c21a11"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"TotalDerivativeDivergenceQ", "[", "_", "]"}], ":=", "False"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TotalDerivativeDivergenceQ", "[", 
    RowBox[{"expr_", "?", "TotalDerivativeQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"TotalDerivativeDivergenceInfo", "[", "expr", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TotalDerivativeDivergenceInfo", "[", "expr_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"TotalDerivativeQ", "[", "expr", "]"}], ",", 
     RowBox[{"expr", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"HoldPattern", "[", 
         RowBox[{
          RowBox[{"totder_", "?", "TotalDerivativeQ"}], "[", "pot_", "]"}], 
         "]"}], ":>", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"covd", "=", 
             RowBox[{"CovDOfTotalDerivative", "[", "totder", "]"}]}], ",", 
            RowBox[{"normals", "=", 
             RowBox[{"FindAllOfType", "[", 
              RowBox[{"pot", ",", "NormalOfCovD"}], "]"}]}], ",", "boolean", ",", 
            RowBox[{"coeff", "=", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
          "\t", 
          RowBox[{
           RowBox[{"boolean", "=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Length", "@", "normals"}], "==", "1"}], ")"}], "&&", 
             RowBox[{
              RowBox[{"CovDOfNormal", "[", 
               RowBox[{"HeadOfTensor2", "[", 
                RowBox[{"normals", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "===", 
              "covd"}], "&&", 
             RowBox[{"ScalarQ", "[", "pot", "]"}], "&&", 
             RowBox[{
              RowBox[{
               RowBox[{"WeightOf", "[", "pot", "]"}], "/", "AIndex"}], "==", 
              "1"}]}]}], ";", "\[IndentingNewLine]", "\t", 
           RowBox[{"If", "[", 
            RowBox[{"boolean", ",", 
             RowBox[{"coeff", "=", 
              RowBox[{"IndexCoefficient", "[", 
               RowBox[{"pot", ",", 
                RowBox[{"normals", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "]"}], ";", 
           "\[IndentingNewLine]", "\t", 
           RowBox[{"{", 
            RowBox[{"boolean", ",", 
             RowBox[{"HeadOfTensor2", "[", 
              RowBox[{"normals", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "totder", ",", 
             "coeff"}], "}"}]}]}], "]"}]}], "}"}]}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "TotalDerivativeDivergenceQ", "]"}], ";"}]}], "Code",
 CellChangeTimes->{{3.957379996370308*^9, 3.9573799995174484`*^9}, 
   3.957380324989092*^9, {3.9573803569191017`*^9, 3.957380366714655*^9}, {
   3.957380415284727*^9, 3.9573804215728245`*^9}, {3.95738050489633*^9, 
   3.9573805050833225`*^9}, {3.957380696125887*^9, 3.957380725663328*^9}, {
   3.9573807647240086`*^9, 3.957380780329935*^9}, {3.957380849341318*^9, 
   3.957380878193983*^9}, {3.957380913270458*^9, 3.9573809388893147`*^9}, {
   3.9573809885428696`*^9, 3.957381002345396*^9}, {3.957381038640236*^9, 
   3.957381082703724*^9}},
 CellLabel->
  "In[715]:=",ExpressionUUID->"4af022ac-1170-9d49-86ba-6647440cd1f9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Modifications of DefScalarFunction"
}], "Section",
 CellChangeTimes->{
  3.932387546357408*^9, {3.94839560822535*^9, 3.948395622914029*^9}, {
   3.948485401422694*^9, 3.948485402617173*^9}, {3.95529057349214*^9, 
   3.955290577830038*^9}},ExpressionUUID->"062f10c4-961d-504a-bd0e-\
36ffd7991230"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Auxiliary functions"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, {
   3.948485423717643*^9, 3.948485425691584*^9}, {3.955290583822386*^9, 
   3.955290584551861*^9}, 3.9606077546848183`*^9, {3.960607887972412*^9, 
   3.960607890158249*^9}},ExpressionUUID->"9eb3cc02-1e1c-9944-b7f4-\
1cdb79c4f94f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "function", " ", "prints", " ", "the", " ", "dependence", " ",
     "of", " ", "a", " ", "scalar", " ", "function", " ", "after", " ", 
    "definition"}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FieldsToText", "[", "list_List", "]"}], ":=", 
    RowBox[{"FieldsToText", "[", 
     RowBox[{"list", ",", 
      RowBox[{"Length", "@", "list"}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FieldsToText", "[", 
     RowBox[{"list_List", ",", "n_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"ToString", "[", 
      RowBox[{"list", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\<, \>\"", "<>", 
     RowBox[{"FieldsToText", "[", 
      RowBox[{
       RowBox[{"Drop", "[", 
        RowBox[{"list", ",", "1"}], "]"}], ",", 
       RowBox[{"n", "-", "1"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FieldsToText", "[", 
     RowBox[{"list_List", ",", "2"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"ToString", "[", 
      RowBox[{"list", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\< and \>\"", "<>", 
     RowBox[{"FieldsToText", "[", 
      RowBox[{
       RowBox[{"Drop", "[", 
        RowBox[{"list", ",", "1"}], "]"}], ",", "1"}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FieldsToText", "[", 
     RowBox[{"list_List", ",", "1"}], "]"}], ":=", 
    RowBox[{"ToString", "[", 
     RowBox[{"list", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.932387555239217*^9, 3.9323875576898904`*^9}, 
   3.932522709814841*^9, {3.932725317402521*^9, 3.932725419188156*^9}, 
   3.932726199764701*^9, {3.9327267522414646`*^9, 3.9327267636360755`*^9}, {
   3.932726923636614*^9, 3.932726932036145*^9}, 3.932727090921422*^9, {
   3.93272738523921*^9, 3.932727410229966*^9}, {3.9327274675350866`*^9, 
   3.932727470494899*^9}, 3.93272750453743*^9, {3.932727681509223*^9, 
   3.932727699877744*^9}, {3.932727736807254*^9, 3.932727751686956*^9}, {
   3.9327277897757683`*^9, 3.932727797356645*^9}, 3.932727834948765*^9, 
   3.932727880728885*^9, {3.932731158141575*^9, 3.9327311587758093`*^9}, {
   3.933075387834605*^9, 3.933075387836604*^9}, {3.933075462107393*^9, 
   3.933075462109279*^9}, {3.948485429129331*^9, 3.948485438999566*^9}, {
   3.9545158133512135`*^9, 3.954515818058819*^9}, {3.954515882260063*^9, 
   3.954515896823929*^9}, 3.9545171592705936`*^9, {3.955290687612995*^9, 
   3.955290695936571*^9}, {3.9563549775317287`*^9, 3.9563550188883095`*^9}, {
   3.956355054541424*^9, 3.956355098478035*^9}, {3.9564081779147415`*^9, 
   3.9564081889714355`*^9}, 3.9564207789266224`*^9, {3.956424754255827*^9, 
   3.956424779879099*^9}, {3.957818356710741*^9, 3.9578183806454773`*^9}, {
   3.9583328182907047`*^9, 3.958332883509123*^9}, {3.9583330210484314`*^9, 
   3.958333142174366*^9}, {3.958333204244192*^9, 3.9583333237957096`*^9}, {
   3.95833358152964*^9, 3.958333633928499*^9}, {3.95833406860503*^9, 
   3.9583340711151237`*^9}, {3.9583341056012306`*^9, 3.958334112015051*^9}, {
   3.9583344444170284`*^9, 3.9583344498366184`*^9}, {3.9583345203217335`*^9, 
   3.958334545642559*^9}, {3.958334650755848*^9, 3.958334679848503*^9}, {
   3.9583349291963043`*^9, 3.958334954898918*^9}, {3.958335051710575*^9, 
   3.958335189696417*^9}, {3.958335253304512*^9, 3.958335263760599*^9}, {
   3.9583352982377834`*^9, 3.9583353569314823`*^9}, {3.9583354632764263`*^9, 
   3.95833554275902*^9}, {3.95833558040226*^9, 3.958335582825094*^9}, {
   3.9583356204230156`*^9, 3.958335685907543*^9}, {3.9583357633252068`*^9, 
   3.9583357673276615`*^9}, {3.958335876873356*^9, 3.9583359005745316`*^9}, {
   3.958335933128153*^9, 3.958335970849287*^9}, {3.958336021949585*^9, 
   3.958336069248457*^9}, {3.958336483570921*^9, 3.958336513560995*^9}, {
   3.9583377619013996`*^9, 3.9583377633605766`*^9}, {3.9584170397680283`*^9, 
   3.958417167765209*^9}, 3.958419945731348*^9, {3.958420157856577*^9, 
   3.958420173585228*^9}, 3.9584204268142757`*^9, 3.958420467874586*^9, {
   3.9584708696526604`*^9, 3.9584709231100883`*^9}, {3.958471044691105*^9, 
   3.958471053144535*^9}, 3.9584711015021343`*^9, {3.9584711751214294`*^9, 
   3.95847118048929*^9}, {3.9584712420137577`*^9, 3.958471281580694*^9}, {
   3.958471353938032*^9, 3.958471359366049*^9}, {3.958471425566435*^9, 
   3.958471472526392*^9}, {3.958472199546877*^9, 3.9584722682014656`*^9}, {
   3.9584724114075737`*^9, 3.9584724450126705`*^9}, {3.9584726770564137`*^9, 
   3.958472709884001*^9}, {3.958472796367092*^9, 3.958472796937168*^9}, {
   3.958474084360235*^9, 3.958474109227907*^9}, {3.960608124393423*^9, 
   3.9606081467789783`*^9}},ExpressionUUID->"d575c16a-0692-0646-88a2-\
8576ff32b0b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"These", " ", "Q"}], "-", 
    RowBox[{
    "functions", " ", "distinguish", " ", "between", " ", "xAct", " ", 
     "scalar", " ", "functions", " ", "and", " ", "functions", " ", "like", " ", 
     SqrtBox["x"]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ScalarFunctionDefinedQ", "[", "_", "]"}], ":=", "False"}], "\n", 
   RowBox[{
    RowBox[{"ScalarFunctionButNotDefinedQ", "[", "x_", "]"}], ":=", 
    RowBox[{
     RowBox[{"ScalarFunctionQ", "[", "x", "]"}], "&&", 
     RowBox[{"!", 
      RowBox[{"ScalarFunctionDefinedQ", "[", "x", "]"}]}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.9606078866172333`*^9, 3.960607916942093*^9}, {
  3.9606081498468037`*^9, 
  3.960608162987116*^9}},ExpressionUUID->"298c8504-8707-a043-9bf1-\
430268393594"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". DefScalarFunction"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, {
   3.948485423717643*^9, 3.948485425691584*^9}, {3.955290583822386*^9, 
   3.955290584551861*^9}, {3.9606077546848183`*^9, 3.960607758995537*^9}, 
   3.9606078687636185`*^9},ExpressionUUID->"5ff16134-9e2e-3949-891a-\
14829c3c959d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Unprotect", "@", "DefScalarFunction"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DefScalarFunction", "[", 
    RowBox[{"sf_", ",", "tensor_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"Options", "[", "DefScalarFunction", "]"}], "]"}]}]}], "]"}], ":=", 
   RowBox[{"DefScalarFunction", "[", 
    RowBox[{"sf", ",", 
     RowBox[{"{", "tensor", "}"}], ",", "options"}], "]"}]}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"With", " ", "two", " ", "arguments"}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DefScalarFunction", "[", 
    RowBox[{"sf_", ",", 
     RowBox[{"tensors_", "?", "ListQ"}], ",", 
     RowBox[{"opts", ":", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"Options", "[", "DefScalarFunction", "]"}], "]"}]}]}], "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fields", "=", 
         RowBox[{"Sort", "@", 
          RowBox[{"DeleteDuplicates", "@", "tensors"}]}]}], ",", 
        RowBox[{"options", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{
           RowBox[{"Flatten", "[", 
            RowBox[{"{", "opts", "}"}], "]"}], ",", 
           RowBox[{"Dagger", "->", "_"}]}], "]"}]}]}], "}"}], ",", "\n", "\n",
       "\t", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"xTensorQ", "[", "#", "]"}]}], ",", 
           RowBox[{"Throw", "@", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"DefScalarFunction", "::", "unknown"}], 
              ",", "\"\<tensor\>\"", ",", "#"}], "]"}]}]}], "]"}], "&"}], "/@",
         "fields"}], ";", "\n", "\t", "\n", "\t", 
       RowBox[{"DefScalarFunction", "[", 
        RowBox[{"sf", ",", 
         RowBox[{"DefInfo", "->", 
          RowBox[{"{", 
           RowBox[{"\"\<scalar function\>\"", ",", 
            RowBox[{"\"\<It depends on \>\"", "<>", 
             RowBox[{"FieldsToText", "@", "fields"}]}]}], "}"}]}], ",", 
         "options"}], "]"}], ";", "\n", "\t", "\n", "\t", 
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"OptionValue", "[", "Dagger", "]"}], ",", 
         "\[IndentingNewLine]", "\t\t", "Complex", ",", 
         RowBox[{
          RowBox[{"xAct`xTensor`Private`SetDaggerPair", "[", 
           RowBox[{"sf", ",", 
            RowBox[{"MakeDaggerSymbol", "[", "sf", "]"}]}], "]"}], ";", 
          RowBox[{"DefScalarFunction", "[", 
           RowBox[{
            RowBox[{"Dagger", "[", "sf", "]"}], ",", 
            RowBox[{
             RowBox[{"Dagger", "/@", "tensors"}], "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"MultiplyHead", "[", 
                RowBox[{"_", ",", "name_"}], "]"}], ":>", "name"}], "}"}]}], ",", 
            RowBox[{"Dagger", "\[Rule]", "Conjugate"}], ",", 
            RowBox[{"Master", "\[Rule]", "sf"}], ",", "options"}], "]"}]}], ",",
          "\[IndentingNewLine]", "\t\t", "Conjugate", ",", 
         RowBox[{"xAct`xTensor`Private`SetPrintAs", "[", 
          RowBox[{"sf", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"OptionValue", "[", "PrintAs", "]"}], "===", 
              "Identity"}], ",", 
             RowBox[{"PrintAs", "[", "sf", "]"}], ",", 
             RowBox[{
              RowBox[{"OptionValue", "[", "PrintAs", "]"}], 
              "<>", "\"\<\\!\\(\\*StyleBox[\\\"\[NegativeVeryThinSpace]\\\", \
\\\"Text\\\"]\\)\>\"", "<>", "$DaggerCharacter"}]}], "]"}]}], "]"}], ",", " ", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "This", " ", "is", " ", "needed", " ", "because", " ", "the", " ", 
            "second", " ", "call", " ", "to", " ", "DefScalarFunction", " ", 
            "has", " ", "dagger", " ", "in", " ", "the", " ", "name"}], ",", 
           " ", 
           RowBox[{
           "which", " ", "is", " ", "then", " ", "removed", " ", "for", " ", 
            "the", " ", "PrintAs", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
              "usually", " ", "it", " ", "is", " ", "added", " ", "because", " ",
                "there", " ", "is", " ", "none"}], ")"}], ".", " ", 
             "Also"}]}], ",", " ", 
           RowBox[{
           "this", " ", "seems", " ", "better", " ", "than", " ", 
            "AddDaggerCharacter", " ", "since", " ", "it", " ", "leaves", " ",
             "a", " ", "gigantic", " ", "space"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", "\t\t", "Imaginary", ",", 
         RowBox[{
          RowBox[{"Dagger", "[", "sf", "]"}], "^=", 
          RowBox[{"MultiplyHead", "[", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "sf"}], "]"}]}], ",", 
         "\[IndentingNewLine]", "\t\t", "Real", ",", 
         RowBox[{
          RowBox[{"Dagger", "[", "sf", "]"}], "^=", "sf"}], ",", 
         "\[IndentingNewLine]", "\t\t", "_", ",", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"DefScalarFunction", "::", "unknown"}], 
            ",", "\"\<Dagger value\>\"", ",", 
            RowBox[{"OptionValue", "[", "Dagger", "]"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "\t\t", "]"}], ";", "\n", "\n", "\t", 
       RowBox[{
        RowBox[{"DependenciesOfScalar", "[", "sf", "]"}], "^=", "fields"}], 
       ";"}]}], "\n", "\t", "]"}]}]}], "\n", "\t"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "@", "DefScalarFunction"}], ";"}]}], "Code",
 CellChangeTimes->{{3.932387555239217*^9, 3.9323875576898904`*^9}, 
   3.932522709814841*^9, {3.932725317402521*^9, 3.932725419188156*^9}, 
   3.932726199764701*^9, {3.9327267522414646`*^9, 3.9327267636360755`*^9}, {
   3.932726923636614*^9, 3.932726932036145*^9}, 3.932727090921422*^9, {
   3.93272738523921*^9, 3.932727410229966*^9}, {3.9327274675350866`*^9, 
   3.932727470494899*^9}, 3.93272750453743*^9, {3.932727681509223*^9, 
   3.932727699877744*^9}, {3.932727736807254*^9, 3.932727751686956*^9}, {
   3.9327277897757683`*^9, 3.932727797356645*^9}, 3.932727834948765*^9, 
   3.932727880728885*^9, {3.932731158141575*^9, 3.9327311587758093`*^9}, {
   3.933075387834605*^9, 3.933075387836604*^9}, {3.933075462107393*^9, 
   3.933075462109279*^9}, {3.948485429129331*^9, 3.948485438999566*^9}, {
   3.9545158133512135`*^9, 3.954515818058819*^9}, {3.954515882260063*^9, 
   3.954515896823929*^9}, 3.9545171592705936`*^9, {3.955290687612995*^9, 
   3.955290695936571*^9}, {3.9563549775317287`*^9, 3.9563550188883095`*^9}, {
   3.956355054541424*^9, 3.956355098478035*^9}, {3.9564081779147415`*^9, 
   3.9564081889714355`*^9}, 3.9564207789266224`*^9, {3.956424754255827*^9, 
   3.956424779879099*^9}, {3.957818356710741*^9, 3.9578183806454773`*^9}, {
   3.9583328182907047`*^9, 3.958332883509123*^9}, {3.9583330210484314`*^9, 
   3.958333142174366*^9}, {3.958333204244192*^9, 3.9583333237957096`*^9}, {
   3.95833358152964*^9, 3.958333633928499*^9}, {3.95833406860503*^9, 
   3.9583340711151237`*^9}, {3.9583341056012306`*^9, 3.958334112015051*^9}, {
   3.9583344444170284`*^9, 3.9583344498366184`*^9}, {3.9583345203217335`*^9, 
   3.958334545642559*^9}, {3.958334650755848*^9, 3.958334679848503*^9}, {
   3.9583349291963043`*^9, 3.958334954898918*^9}, {3.958335051710575*^9, 
   3.958335189696417*^9}, {3.958335253304512*^9, 3.958335263760599*^9}, {
   3.9583352982377834`*^9, 3.9583353569314823`*^9}, {3.9583354632764263`*^9, 
   3.95833554275902*^9}, {3.95833558040226*^9, 3.958335582825094*^9}, {
   3.9583356204230156`*^9, 3.958335685907543*^9}, {3.9583357633252068`*^9, 
   3.9583357673276615`*^9}, {3.958335876873356*^9, 3.9583359005745316`*^9}, {
   3.958335933128153*^9, 3.958335970849287*^9}, {3.958336021949585*^9, 
   3.958336069248457*^9}, {3.958336483570921*^9, 3.958336513560995*^9}, {
   3.9583377619013996`*^9, 3.9583377633605766`*^9}, {3.9584170397680283`*^9, 
   3.958417167765209*^9}, 3.958419945731348*^9, {3.958420157856577*^9, 
   3.958420173585228*^9}, 3.9584204268142757`*^9, 3.958420467874586*^9, {
   3.9584708696526604`*^9, 3.9584709231100883`*^9}, {3.958471044691105*^9, 
   3.958471053144535*^9}, 3.9584711015021343`*^9, {3.9584711751214294`*^9, 
   3.95847118048929*^9}, {3.9584712420137577`*^9, 3.958471281580694*^9}, {
   3.958471353938032*^9, 3.958471359366049*^9}, {3.958471425566435*^9, 
   3.958471482248554*^9}, 3.958471533083479*^9, {3.9584736597928905`*^9, 
   3.958473669695282*^9}, {3.958473701271923*^9, 3.9584737879279957`*^9}, {
   3.958473841800663*^9, 3.958473867701084*^9}, {3.958474073069195*^9, 
   3.9584740763443737`*^9}, {3.9584741184343605`*^9, 
   3.9584741207518215`*^9}, {3.9584742261518993`*^9, 3.9584742324903717`*^9}, 
   3.9584742896053696`*^9, {3.958474375222351*^9, 3.9584743799683113`*^9}, {
   3.9584744844991493`*^9, 3.9584744993156013`*^9}, {3.958474677454748*^9, 
   3.9584747006643753`*^9}, 3.960556146373228*^9, 3.960556184141321*^9, {
   3.9605563126190357`*^9, 3.9605563243059998`*^9}, {3.960607694107254*^9, 
   3.960607731201042*^9}, {3.9606077798942394`*^9, 3.960607810002304*^9}, {
   3.9606078576273403`*^9, 3.96060786309128*^9}, {3.96062892253627*^9, 
   3.960628976951708*^9}, {3.9606294932816105`*^9, 3.960629499101513*^9}, {
   3.960630090503853*^9, 3.9606301176358566`*^9}, {3.960630156232479*^9, 
   3.960630164305256*^9}, {3.9606303875314617`*^9, 3.960630411038765*^9}, {
   3.960630631233135*^9, 3.9606306617521515`*^9}, {3.9606307445233326`*^9, 
   3.9606307469538937`*^9}, {3.9606308835590267`*^9, 3.960630911063818*^9}, {
   3.9606310087626686`*^9, 3.960631052604227*^9}, {3.9606317501983814`*^9, 
   3.960631803329035*^9}, 3.960631918259632*^9, {3.960631992867012*^9, 
   3.9606320281200066`*^9}, {3.9606321148979816`*^9, 
   3.9606321280194263`*^9}, {3.9606375564298553`*^9, 
   3.9606375737019157`*^9}, {3.960637607241541*^9, 3.9606376074506855`*^9}, {
   3.960638728162264*^9, 3.960638734137905*^9}, {3.960639567231123*^9, 
   3.9606396016707077`*^9}, {3.960640201910639*^9, 3.960640248169945*^9}, {
   3.960640454467407*^9, 3.960640456329817*^9}, 3.960640506053692*^9, {
   3.960640652000532*^9, 3.9606406545845013`*^9}, {3.960640709954365*^9, 
   3.960640710402809*^9}, {3.9606407704009495`*^9, 3.9606408066852818`*^9}, 
   3.9606410668187847`*^9},ExpressionUUID->"7b6b8ad7-6ba1-f341-8397-\
c10891ba3e0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ScalarModificationsCPSEnd"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, {
   3.948485423717643*^9, 3.948485425691584*^9}, {3.955290583822386*^9, 
   3.955290584551861*^9}, {3.9606077546848183`*^9, 
   3.960607758995537*^9}},ExpressionUUID->"16afd210-0bdc-834c-9973-\
33d1ba6b7a72"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "ScalarModificationsCPSEnd", "]"}], ":=", 
    RowBox[{"Options", "[", "DefScalarFunction", "]"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xTension", "[", 
     RowBox[{"\"\<xAct`xTensor`\>\"", ",", "DefScalarFunction", ",", 
      " ", "\"\<End\>\""}], "]"}], " ", ":=", " ", 
    "ScalarModificationsCPSEnd"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"ScalarModificationsCPSEnd", "[", 
   RowBox[{"sf_", ",", 
    RowBox[{"options", ":", 
     RowBox[{"OptionsPattern", "[", "DefScalarFunction", "]"}]}]}], "]"}], ":=", 
  RowBox[{"(", "\n", "\t", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarFunctionDefinedQ", "[", "sf", "]"}], "^=", "True"}], ";", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
      "This", " ", "is", " ", "used", " ", "to", " ", "handle", " ", "these", 
       " ", "functions", " ", "differently", " ", "than"}], ",", " ", 
      RowBox[{"for", " ", "instance"}], ",", " ", 
      RowBox[{
       SqrtBox["x"], " ", "when", " ", "handling", " ", "VertDiff", " ", 
       "and", " ", "ExpandVertDiff"}]}], " ", "*)"}], "\n", "\t", 
    RowBox[{"Unprotect", "[", "WeightOf", "]"}], ";", "\n", "\t", "\n", "\t", 
    RowBox[{"sf", "/:", " ", 
     RowBox[{"WeightOf", "[", "sf", "]"}], "=", "0"}], ";", "\n", "\t", 
    RowBox[{"sf", "/:", " ", 
     RowBox[{"WeightOf", "[", 
      RowBox[{"sf", "[", "___", "]"}], "]"}], ":=", "0"}], ";", "\n", "\t", 
    RowBox[{
     RowBox[{"PartialPartialsOfFunction", "[", "sf", "]"}], "^=", 
     RowBox[{"{", "}"}]}], ";", "\n", "\t", 
    RowBox[{
     RowBox[{"DependenciesOfScalar", "[", "sf", "]"}], "^=", 
     RowBox[{"{", "}"}]}], ";", "\n", "\t", "\n", "\t", 
    RowBox[{"Protect", "[", "WeightOf", "]"}], ";"}], "\n", "\t", 
   ")"}]}]}], "Code",
 CellChangeTimes->{
  3.9318358672655144`*^9, {3.9319194752551565`*^9, 3.931919480313019*^9}, {
   3.931945690159758*^9, 3.931945750505718*^9}, {3.931945788468634*^9, 
   3.931945859096271*^9}, {3.931945905554218*^9, 3.931945908726142*^9}, {
   3.93200636393322*^9, 3.93200639336861*^9}, {3.932006592789816*^9, 
   3.932006596511231*^9}, {3.932006627253218*^9, 3.932006631599211*^9}, {
   3.93200672176855*^9, 3.9320068172438*^9}, 3.932017632298293*^9, {
   3.93201767434369*^9, 3.932017680483576*^9}, 3.932029687850279*^9, 
   3.932037359152578*^9, {3.932038249311191*^9, 3.932038398366421*^9}, {
   3.932038429343839*^9, 3.93203843235063*^9}, {3.932038469605623*^9, 
   3.932038470090982*^9}, {3.932039557285334*^9, 3.932039652897715*^9}, {
   3.93204220487163*^9, 3.932042228042278*^9}, {3.93204289925137*^9, 
   3.932042937231559*^9}, {3.932093647516043*^9, 3.932093654110863*^9}, {
   3.932129284870198*^9, 3.932129378324875*^9}, {3.9321301769811535`*^9, 
   3.9321301843566313`*^9}, {3.9321804454893217`*^9, 
   3.9321804529106803`*^9}, {3.93227136630357*^9, 3.9322713853653593`*^9}, {
   3.932271877222102*^9, 3.932271915038328*^9}, {3.932297411217804*^9, 
   3.932297432904259*^9}, {3.932359525380924*^9, 3.9323595272161584`*^9}, 
   3.932387570859874*^9, 3.932522728808476*^9, 3.932637740261566*^9, {
   3.932639434344436*^9, 3.932639434536236*^9}, {3.932640077379796*^9, 
   3.932640103310054*^9}, {3.9327119977475657`*^9, 3.932712010905471*^9}, {
   3.932712134406143*^9, 3.9327121376665597`*^9}, {3.932715684669766*^9, 
   3.932715718148159*^9}, {3.932715799218834*^9, 3.9327158059956837`*^9}, {
   3.932715868455219*^9, 3.93271587819848*^9}, {3.932716278184285*^9, 
   3.932716305373096*^9}, {3.9327179131183167`*^9, 3.932717921565514*^9}, {
   3.932717969865563*^9, 3.9327179874757175`*^9}, {3.932718990347639*^9, 
   3.932719023139507*^9}, {3.932719226453256*^9, 3.932719316868399*^9}, {
   3.932720273305619*^9, 3.932720301461312*^9}, {3.9327203914383326`*^9, 
   3.9327204043120003`*^9}, {3.932725166039882*^9, 3.932725169107888*^9}, {
   3.932725279585589*^9, 3.9327252877772226`*^9}, {3.932725423741296*^9, 
   3.93272544200097*^9}, {3.9327260498229856`*^9, 3.932726066258298*^9}, {
   3.9327262128984385`*^9, 3.932726320796633*^9}, {3.932726459765882*^9, 
   3.932726474211896*^9}, 3.9327265107534013`*^9, 3.9327267810550346`*^9, {
   3.932726882499129*^9, 3.932726887070405*^9}, {3.93272749402417*^9, 
   3.9327275006187*^9}, 3.9327275312965617`*^9, {3.932727588939194*^9, 
   3.932727615167998*^9}, {3.932727826705191*^9, 3.932727826974474*^9}, {
   3.932727916522539*^9, 3.932727916951887*^9}, {3.93272807129533*^9, 
   3.932728243464301*^9}, {3.932728276103613*^9, 3.93272845168796*^9}, {
   3.9327286036166067`*^9, 3.932728610260255*^9}, 3.932728653828579*^9, {
   3.9327288785966935`*^9, 3.9327289499635377`*^9}, 3.932728998014388*^9, {
   3.93273937315425*^9, 3.932739426821949*^9}, {3.9327643473292427`*^9, 
   3.932764347349535*^9}, {3.932774773006706*^9, 3.932774795977462*^9}, 
   3.932774937880096*^9, {3.9327752598559637`*^9, 3.932775262861019*^9}, {
   3.93277530763462*^9, 3.932775408588372*^9}, {3.932776272103023*^9, 
   3.9327762800779448`*^9}, 3.932776410599324*^9, 3.932820175516779*^9, 
   3.932820208717606*^9, 3.932880542951945*^9, {3.932881006318826*^9, 
   3.932881006328828*^9}, {3.932903748248298*^9, 3.932903756512472*^9}, {
   3.9329813397479835`*^9, 3.932981358476002*^9}, {3.932983739539635*^9, 
   3.932983741365227*^9}, 3.932984836918935*^9, {3.932985083663152*^9, 
   3.932985129999656*^9}, {3.932985217409866*^9, 3.9329852374569144`*^9}, {
   3.932985291701445*^9, 3.932985302912773*^9}, {3.932985361754807*^9, 
   3.9329853642433167`*^9}, {3.932985441552809*^9, 3.932985445556642*^9}, {
   3.9329855334024334`*^9, 3.9329855528263893`*^9}, {3.9329855862373457`*^9, 
   3.932985592477603*^9}, {3.9329856747801523`*^9, 3.932985704948316*^9}, {
   3.932985764638028*^9, 3.9329857753399305`*^9}, {3.932985932400576*^9, 
   3.932985983764256*^9}, {3.9329860448818207`*^9, 3.9329861544165277`*^9}, {
   3.932986196130132*^9, 3.932986201120463*^9}, {3.932986265764025*^9, 
   3.932986317103728*^9}, {3.932986475786107*^9, 3.932986523539381*^9}, {
   3.933075387853604*^9, 3.933075387870605*^9}, {3.9330754621215687`*^9, 
   3.9330754621399403`*^9}, {3.9332333328844705`*^9, 3.933233366102533*^9}, 
   3.93333005641338*^9, {3.933406054595725*^9, 3.933406058436807*^9}, {
   3.933406105003892*^9, 3.933406107373477*^9}, {3.933747349674017*^9, 
   3.933747351763543*^9}, {3.9484854474201307`*^9, 3.948485538322059*^9}, {
   3.948485588872399*^9, 3.948485627125429*^9}, {3.94848566665324*^9, 
   3.9484857441668634`*^9}, {3.948485783854486*^9, 3.948485841614177*^9}, {
   3.948485884829794*^9, 3.948486033362832*^9}, {3.948486178345046*^9, 
   3.948486230175677*^9}, {3.948486268199595*^9, 3.948486270450405*^9}, 
   3.948486328294918*^9, {3.948486398330817*^9, 3.948486415416915*^9}, {
   3.948543000678113*^9, 3.948543021056011*^9}, {3.950614667777214*^9, 
   3.950614680935854*^9}, {3.950968957785204*^9, 3.950969162822334*^9}, {
   3.950969205039017*^9, 3.950969436707239*^9}, {3.950969619092399*^9, 
   3.95096964069582*^9}, {3.9509732246227207`*^9, 3.950973267629078*^9}, {
   3.950973333150186*^9, 3.9509733593977394`*^9}, {3.9509774035583534`*^9, 
   3.950977436615492*^9}, {3.951045497199572*^9, 3.9510455174114227`*^9}, {
   3.951045718482435*^9, 3.951045719627861*^9}, {3.951225017138056*^9, 
   3.951225019178219*^9}, {3.951247803384519*^9, 3.951247821444692*^9}, {
   3.952264636617092*^9, 3.9522646527295322`*^9}, {3.952264869013361*^9, 
   3.952264886015646*^9}, {3.9522649439990826`*^9, 3.952264954724861*^9}, {
   3.9522655177910995`*^9, 3.952265551887169*^9}, {3.9522656004366856`*^9, 
   3.952265626674324*^9}, {3.9522656903075447`*^9, 3.9522657045699196`*^9}, {
   3.9522658571670322`*^9, 3.952265892967594*^9}, {3.952266173980015*^9, 
   3.9522661835490856`*^9}, {3.9522662643154087`*^9, 3.9522663110589848`*^9}, 
   3.9522663509536896`*^9, 3.952266410803007*^9, {3.952268304098633*^9, 
   3.952268341704811*^9}, {3.9545158232531815`*^9, 3.954515823526869*^9}, {
   3.954515935500513*^9, 3.954515940507471*^9}, {3.9545159899268093`*^9, 
   3.9545160520313015`*^9}, {3.9545165769896545`*^9, 
   3.9545165788775024`*^9}, {3.954516832780304*^9, 3.9545168389390354`*^9}, 
   3.955190724457041*^9, {3.955290712647272*^9, 3.955290829295967*^9}, {
   3.9552911225409126`*^9, 3.955291142539011*^9}, {3.955291826884207*^9, 
   3.955291859177084*^9}, {3.955292204716938*^9, 3.955292286243273*^9}, {
   3.955307429895912*^9, 3.9553074431934834`*^9}, {3.9553610669126434`*^9, 
   3.9553610818418655`*^9}, {3.955361243684511*^9, 3.9553612447132664`*^9}, 
   3.955361356625391*^9, 3.955361463604355*^9, {3.955361563433687*^9, 
   3.9553615723293266`*^9}, {3.955361623751257*^9, 3.9553616358089657`*^9}, {
   3.95641976272558*^9, 3.956419768722719*^9}, {3.9564208444383736`*^9, 
   3.9564208502070274`*^9}, 3.958471457459774*^9, {3.95847185073752*^9, 
   3.9584718559973106`*^9}, {3.9606078594511623`*^9, 
   3.9606078958863754`*^9}},ExpressionUUID->"3d4c2f56-1475-9e4e-9cd9-\
c45a4fb5a58d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Modifications of UndefScalarFunction"
}], "Section",
 CellChangeTimes->{
  3.932387546357408*^9, {3.94839560822535*^9, 3.948395622914029*^9}, {
   3.948485401422694*^9, 3.948485402617173*^9}, {3.95529057349214*^9, 
   3.955290577830038*^9}, {3.960607767063427*^9, 
   3.9606077702317543`*^9}},ExpressionUUID->"e52459cb-c068-904c-a48f-\
d2663b0ad416"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "functions", " ", "removes", " ", "one", " ", "element", " ",
       "from", " ", "a", " ", "pair", " ", 
      RowBox[{"(", 
       RowBox[{"a", ",", "b"}], ")"}], " ", "such", " ", "that", " ", 
      RowBox[{"Dagger", "@", "a"}]}], "=", 
     RowBox[{"b", ".", " ", "Thus"}]}], ",", "  ", 
    RowBox[{
     RowBox[{"Intersection", "[", 
      RowBox[{"list", ",", 
       RowBox[{"removeDaggerPairs", "@", "list"}]}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", "}"}], ".", " ", "This"}], " ", "avoids", " ", "repeated",
       " ", "undefinition"}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"removeDaggerPairs", "[", "list_List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"seen", "=", 
        RowBox[{"<|", "|>"}]}], ",", 
       RowBox[{"result", "=", 
        RowBox[{"{", "}"}]}]}], "}"}], ",", "\n", "\t", 
     RowBox[{
      RowBox[{"Do", "[", "\n", "\t\t", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"!", 
            RowBox[{"KeyExistsQ", "[", 
             RowBox[{"seen", ",", 
              RowBox[{
               RowBox[{"Dagger", "[", "elem", "]"}], "/.", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"MultiplyHead", "[", 
                  RowBox[{"_", ",", "tensor_"}], "]"}], ":>", "tensor"}], 
                "}"}]}]}], "]"}]}], "&&", 
           RowBox[{"!", 
            RowBox[{"KeyExistsQ", "[", 
             RowBox[{"seen", ",", "elem"}], "]"}]}]}], ",", "\n", "\t\t\t", 
          RowBox[{
           RowBox[{"AppendTo", "[", 
            RowBox[{"result", ",", "elem"}], "]"}], ";", 
           "\[IndentingNewLine]", "\t\t\t", 
           RowBox[{
            RowBox[{"seen", "[", "elem", "]"}], "=", "True"}], ";"}]}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"elem", ",", "list"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\t\t\t", "result"}]}], "\n", "\t", 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.9606076183592777`*^9, 3.9606076860914745`*^9}, {
  3.9606100086005383`*^9, 
  3.960610021747053*^9}},ExpressionUUID->"fabbd460-9810-a446-8b31-\
29803e9b0f8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xTension", "[", 
   RowBox[{"\"\<xAct`xTensor`\>\"", ",", "UndefScalarFunction", ",", 
    " ", "\"\<Beginning\>\""}], "]"}], " ", ":=", "  ", 
  RowBox[{
   RowBox[{"UndefTensor", "/@", 
    RowBox[{"removeDaggerPairs", "[", 
     RowBox[{"PartialPartialsOfFunction", "[", "#", "]"}], "]"}]}], " ", 
   "&"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "To", " ", "avoid", " ", "the", " ", "repeated", " ", "undefinitions"}], 
   " ", "*)"}], " "}]], "Code",
 CellChangeTimes->{
  3.9606078281681156`*^9, 3.9606079510982666`*^9, {3.960608384729637*^9, 
   3.960608386003563*^9}},ExpressionUUID->"6403d823-9016-1d4e-9105-\
a8d69cdf6e6b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Modifications of DefManifold"
}], "Section",
 CellChangeTimes->{
  3.932387546357408*^9, {3.94839560822535*^9, 3.948395622914029*^9}, {
   3.948485401422694*^9, 
   3.948485402617173*^9}},ExpressionUUID->"d4797eb7-9ff5-4041-92c5-\
290cbfc78b15"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". ManifoldModificationsCPS"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 3.948395661080009*^9}, {
   3.948485423717643*^9, 
   3.948485425691584*^9}},ExpressionUUID->"fec36475-41ce-4e4a-9d1e-\
242bb9233e4b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ManifoldModificationsCPS", "]"}], ":=", 
   RowBox[{"Options", "[", "DefManifold", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xTension", "[", 
     RowBox[{"\"\<xAct`xTensor`\>\"", ",", "DefManifold", ",", 
      " ", "\"\<End\>\""}], "]"}], " ", ":=", " ", 
    "DefManifoldModificationsCPS"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xTension", "[", 
    RowBox[{"\"\<xAct`xTensor`\>\"", ",", "UndefManifold", ",", 
     " ", "\"\<Beginning\>\""}], "]"}], " ", ":=", " ", 
   "UndefManifoldModificationsCPS"}], ";"}]}], "Code",
 CellChangeTimes->{{3.932387555239217*^9, 3.9323875576898904`*^9}, 
   3.932522709814841*^9, {3.932725317402521*^9, 3.932725419188156*^9}, 
   3.932726199764701*^9, {3.9327267522414646`*^9, 3.9327267636360755`*^9}, {
   3.932726923636614*^9, 3.932726932036145*^9}, 3.932727090921422*^9, {
   3.93272738523921*^9, 3.932727410229966*^9}, {3.9327274675350866`*^9, 
   3.932727470494899*^9}, 3.93272750453743*^9, {3.932727681509223*^9, 
   3.932727699877744*^9}, {3.932727736807254*^9, 3.932727751686956*^9}, {
   3.9327277897757683`*^9, 3.932727797356645*^9}, 3.932727834948765*^9, 
   3.932727880728885*^9, {3.932731158141575*^9, 3.9327311587758093`*^9}, {
   3.933075387834605*^9, 3.933075387836604*^9}, {3.933075462107393*^9, 
   3.933075462109279*^9}, {3.948485429129331*^9, 3.948485438999566*^9}, {
   3.9545158133512135`*^9, 3.954515818058819*^9}, {3.954515882260063*^9, 
   3.954515896823929*^9}, 3.9545171592705936`*^9, {3.962634453124258*^9, 
   3.9626344765478745`*^9}, {3.9626381019996586`*^9, 3.96263810232724*^9}, 
   3.9639369589551907`*^9, {3.963937032769785*^9, 3.9639370545592766`*^9}, 
   3.963937102523834*^9, {3.963938185734043*^9, 3.9639382219361496`*^9}, {
   3.963938558556862*^9, 3.9639385628063164`*^9}, {3.9639399423884735`*^9, 
   3.963939943973194*^9}, {3.9639402187659607`*^9, 
   3.963940220115555*^9}},ExpressionUUID->"c7f10499-4614-314a-8302-\
8d647a52c43f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Creates", " ", "a", " ", "FiducialNormal", " ", "associated", " ", "with",
     " ", "the", " ", "manifold"}], " ", "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"DefManifoldModificationsCPS", "[", 
     RowBox[{
     "manifold_", ",", "dim_", ",", "indices_List", ",", "options___"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "dlnormal", "}"}], ",", "\n", "\t", 
      RowBox[{
       RowBox[{"Unprotect", "[", "PD", "]"}], ";", "\n", "\t", "\n", "\t", 
       RowBox[{"DefNormalOfCovD", "[", 
        RowBox[{"PD", ",", 
         RowBox[{"indices", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "manifold"}], "]"}], ";", "\t",
        "\n", "\t", 
       RowBox[{"DefTotalDerivative", "[", 
        RowBox[{"PD", ",", "manifold"}], "]"}], ";", "\n", "\t\t", "\n", "\t", 
       RowBox[{"Protect", "[", "PD", "]"}], ";"}]}], "\n", "]"}]}], "\n", 
   "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Removes", " ", "the", " ", "FiducialNormal", " ", "associated", " ", 
     "with", " ", "the", " ", "manifold"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefManifoldModificationsCPS", "[", "manifold_", "]"}], ":=", 
     RowBox[{"UndefTensor", "[", 
      RowBox[{"NormalOfManifold", "[", "manifold", "]"}], "]"}]}], 
    ";"}]}]}]], "Code",
 CellChangeTimes->{
  3.9318358672655144`*^9, {3.9319194752551565`*^9, 3.931919480313019*^9}, {
   3.931945690159758*^9, 3.931945750505718*^9}, {3.931945788468634*^9, 
   3.931945859096271*^9}, {3.931945905554218*^9, 3.931945908726142*^9}, {
   3.93200636393322*^9, 3.93200639336861*^9}, {3.932006592789816*^9, 
   3.932006596511231*^9}, {3.932006627253218*^9, 3.932006631599211*^9}, {
   3.93200672176855*^9, 3.9320068172438*^9}, 3.932017632298293*^9, {
   3.93201767434369*^9, 3.932017680483576*^9}, 3.932029687850279*^9, 
   3.932037359152578*^9, {3.932038249311191*^9, 3.932038398366421*^9}, {
   3.932038429343839*^9, 3.93203843235063*^9}, {3.932038469605623*^9, 
   3.932038470090982*^9}, {3.932039557285334*^9, 3.932039652897715*^9}, {
   3.93204220487163*^9, 3.932042228042278*^9}, {3.93204289925137*^9, 
   3.932042937231559*^9}, {3.932093647516043*^9, 3.932093654110863*^9}, {
   3.932129284870198*^9, 3.932129378324875*^9}, {3.9321301769811535`*^9, 
   3.9321301843566313`*^9}, {3.9321804454893217`*^9, 
   3.9321804529106803`*^9}, {3.93227136630357*^9, 3.9322713853653593`*^9}, {
   3.932271877222102*^9, 3.932271915038328*^9}, {3.932297411217804*^9, 
   3.932297432904259*^9}, {3.932359525380924*^9, 3.9323595272161584`*^9}, 
   3.932387570859874*^9, 3.932522728808476*^9, 3.932637740261566*^9, {
   3.932639434344436*^9, 3.932639434536236*^9}, {3.932640077379796*^9, 
   3.932640103310054*^9}, {3.9327119977475657`*^9, 3.932712010905471*^9}, {
   3.932712134406143*^9, 3.9327121376665597`*^9}, {3.932715684669766*^9, 
   3.932715718148159*^9}, {3.932715799218834*^9, 3.9327158059956837`*^9}, {
   3.932715868455219*^9, 3.93271587819848*^9}, {3.932716278184285*^9, 
   3.932716305373096*^9}, {3.9327179131183167`*^9, 3.932717921565514*^9}, {
   3.932717969865563*^9, 3.9327179874757175`*^9}, {3.932718990347639*^9, 
   3.932719023139507*^9}, {3.932719226453256*^9, 3.932719316868399*^9}, {
   3.932720273305619*^9, 3.932720301461312*^9}, {3.9327203914383326`*^9, 
   3.9327204043120003`*^9}, {3.932725166039882*^9, 3.932725169107888*^9}, {
   3.932725279585589*^9, 3.9327252877772226`*^9}, {3.932725423741296*^9, 
   3.93272544200097*^9}, {3.9327260498229856`*^9, 3.932726066258298*^9}, {
   3.9327262128984385`*^9, 3.932726320796633*^9}, {3.932726459765882*^9, 
   3.932726474211896*^9}, 3.9327265107534013`*^9, 3.9327267810550346`*^9, {
   3.932726882499129*^9, 3.932726887070405*^9}, {3.93272749402417*^9, 
   3.9327275006187*^9}, 3.9327275312965617`*^9, {3.932727588939194*^9, 
   3.932727615167998*^9}, {3.932727826705191*^9, 3.932727826974474*^9}, {
   3.932727916522539*^9, 3.932727916951887*^9}, {3.93272807129533*^9, 
   3.932728243464301*^9}, {3.932728276103613*^9, 3.93272845168796*^9}, {
   3.9327286036166067`*^9, 3.932728610260255*^9}, 3.932728653828579*^9, {
   3.9327288785966935`*^9, 3.9327289499635377`*^9}, 3.932728998014388*^9, {
   3.93273937315425*^9, 3.932739426821949*^9}, {3.9327643473292427`*^9, 
   3.932764347349535*^9}, {3.932774773006706*^9, 3.932774795977462*^9}, 
   3.932774937880096*^9, {3.9327752598559637`*^9, 3.932775262861019*^9}, {
   3.93277530763462*^9, 3.932775408588372*^9}, {3.932776272103023*^9, 
   3.9327762800779448`*^9}, 3.932776410599324*^9, 3.932820175516779*^9, 
   3.932820208717606*^9, 3.932880542951945*^9, {3.932881006318826*^9, 
   3.932881006328828*^9}, {3.932903748248298*^9, 3.932903756512472*^9}, {
   3.9329813397479835`*^9, 3.932981358476002*^9}, {3.932983739539635*^9, 
   3.932983741365227*^9}, 3.932984836918935*^9, {3.932985083663152*^9, 
   3.932985129999656*^9}, {3.932985217409866*^9, 3.9329852374569144`*^9}, {
   3.932985291701445*^9, 3.932985302912773*^9}, {3.932985361754807*^9, 
   3.9329853642433167`*^9}, {3.932985441552809*^9, 3.932985445556642*^9}, {
   3.9329855334024334`*^9, 3.9329855528263893`*^9}, {3.9329855862373457`*^9, 
   3.932985592477603*^9}, {3.9329856747801523`*^9, 3.932985704948316*^9}, {
   3.932985764638028*^9, 3.9329857753399305`*^9}, {3.932985932400576*^9, 
   3.932985983764256*^9}, {3.9329860448818207`*^9, 3.9329861544165277`*^9}, {
   3.932986196130132*^9, 3.932986201120463*^9}, {3.932986265764025*^9, 
   3.932986317103728*^9}, {3.932986475786107*^9, 3.932986523539381*^9}, {
   3.933075387853604*^9, 3.933075387870605*^9}, {3.9330754621215687`*^9, 
   3.9330754621399403`*^9}, {3.9332333328844705`*^9, 3.933233366102533*^9}, 
   3.93333005641338*^9, {3.933406054595725*^9, 3.933406058436807*^9}, {
   3.933406105003892*^9, 3.933406107373477*^9}, {3.933747349674017*^9, 
   3.933747351763543*^9}, {3.9484854474201307`*^9, 3.948485538322059*^9}, {
   3.948485588872399*^9, 3.948485627125429*^9}, {3.94848566665324*^9, 
   3.9484857441668634`*^9}, {3.948485783854486*^9, 3.948485841614177*^9}, {
   3.948485884829794*^9, 3.948486033362832*^9}, {3.948486178345046*^9, 
   3.948486230175677*^9}, {3.948486268199595*^9, 3.948486270450405*^9}, 
   3.948486328294918*^9, {3.948486398330817*^9, 3.948486415416915*^9}, {
   3.948543000678113*^9, 3.948543021056011*^9}, {3.950614667777214*^9, 
   3.950614680935854*^9}, {3.950968957785204*^9, 3.950969162822334*^9}, {
   3.950969205039017*^9, 3.950969436707239*^9}, {3.950969619092399*^9, 
   3.95096964069582*^9}, {3.9509732246227207`*^9, 3.950973267629078*^9}, {
   3.950973333150186*^9, 3.9509733593977394`*^9}, {3.9509774035583534`*^9, 
   3.950977436615492*^9}, {3.951045497199572*^9, 3.9510455174114227`*^9}, {
   3.951045718482435*^9, 3.951045719627861*^9}, {3.951225017138056*^9, 
   3.951225019178219*^9}, {3.951247803384519*^9, 3.951247821444692*^9}, {
   3.952264636617092*^9, 3.9522646527295322`*^9}, {3.952264869013361*^9, 
   3.952264886015646*^9}, {3.9522649439990826`*^9, 3.952264954724861*^9}, {
   3.9522655177910995`*^9, 3.952265551887169*^9}, {3.9522656004366856`*^9, 
   3.952265626674324*^9}, {3.9522656903075447`*^9, 3.9522657045699196`*^9}, {
   3.9522658571670322`*^9, 3.952265892967594*^9}, {3.952266173980015*^9, 
   3.9522661835490856`*^9}, {3.9522662643154087`*^9, 3.9522663110589848`*^9}, 
   3.9522663509536896`*^9, 3.952266410803007*^9, {3.952268304098633*^9, 
   3.952268341704811*^9}, {3.9545158232531815`*^9, 3.954515823526869*^9}, {
   3.954515935500513*^9, 3.954515940507471*^9}, {3.9545159899268093`*^9, 
   3.9545160520313015`*^9}, {3.9545165769896545`*^9, 
   3.9545165788775024`*^9}, {3.954516832780304*^9, 3.9545168389390354`*^9}, 
   3.955190724457041*^9, 3.9572932973052235`*^9, {3.962634354859371*^9, 
   3.9626343630788536`*^9}, 3.962634482482834*^9, {3.962634758508068*^9, 
   3.962634760367899*^9}, {3.962634800562145*^9, 3.9626348006335106`*^9}, {
   3.962637093167286*^9, 3.9626371022477818`*^9}, {3.9626381055732937`*^9, 
   3.962638105849039*^9}, {3.9639366755396214`*^9, 3.963936675720661*^9}, {
   3.9639368128650017`*^9, 3.963936813651884*^9}, {3.9639368679412823`*^9, 
   3.9639368745547085`*^9}, {3.9639369224504967`*^9, 3.963936939432232*^9}, {
   3.9639369760099144`*^9, 3.9639369794827194`*^9}, {3.963937103663225*^9, 
   3.9639371071066055`*^9}, {3.963937303787817*^9, 3.963937305136404*^9}, {
   3.963938225177021*^9, 3.9639382399282856`*^9}, {3.963938321217882*^9, 
   3.963938324797283*^9}, {3.9639386127620983`*^9, 3.9639386197375774`*^9}, {
   3.963940207424761*^9, 
   3.9639402081525345`*^9}},ExpressionUUID->"eb24b9cd-5936-3e40-8df6-\
d636034afd16"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Modifications of DefCovD"
}], "Section",
 CellChangeTimes->{
  3.932387546357408*^9, {3.94839560822535*^9, 
   3.948395622914029*^9}},ExpressionUUID->"0b30a9d6-e968-3745-b0e0-\
3318d4a50260"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". CovDModificationsCPS"
}], "Subsection",
 CellChangeTimes->{{3.931835764106406*^9, 3.931835766467467*^9}, {
   3.931835825864336*^9, 3.931835830999406*^9}, 3.933075387846597*^9, 
   3.933075462115573*^9, {3.948395642046063*^9, 
   3.948395661080009*^9}},ExpressionUUID->"ef3a62e0-cf64-274a-830b-\
4b7be3628466"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "CovDModificationsCPS", "]"}], ":=", 
   RowBox[{"Options", "[", "DefCovD", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"xTension", "[", 
    RowBox[{"\"\<xAct`xTensor`\>\"", ",", " ", "DefCovD", ",", 
     " ", "\"\<End\>\""}], "]"}], " ", ":=", " ", "CovDModificationsCPS"}], 
  ";"}]}], "Code",
 CellChangeTimes->{{3.932387555239217*^9, 3.9323875576898904`*^9}, 
   3.932522709814841*^9, {3.932725317402521*^9, 3.932725419188156*^9}, 
   3.932726199764701*^9, {3.9327267522414646`*^9, 3.9327267636360755`*^9}, {
   3.932726923636614*^9, 3.932726932036145*^9}, 3.932727090921422*^9, {
   3.93272738523921*^9, 3.932727410229966*^9}, {3.9327274675350866`*^9, 
   3.932727470494899*^9}, 3.93272750453743*^9, {3.932727681509223*^9, 
   3.932727699877744*^9}, {3.932727736807254*^9, 3.932727751686956*^9}, {
   3.9327277897757683`*^9, 3.932727797356645*^9}, 3.932727834948765*^9, 
   3.932727880728885*^9, {3.932731158141575*^9, 3.9327311587758093`*^9}, {
   3.933075387834605*^9, 3.933075387836604*^9}, {3.933075462107393*^9, 
   3.933075462109279*^9}},
 CellLabel->
  "In[737]:=",ExpressionUUID->"5ab62a43-1b18-274f-b157-8b937c35d307"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Additional", " ", "changes", " ", "to", " ", "addapt", " ", "CovD", " ", 
     "to", " ", "the", " ", 
     RowBox[{"WWedge", ".", " ", "It"}], " ", "defines", " ", "the", " ", 
     "rules", " ", "to", " ", "expand", " ", "the", " ", "Riemann"}], ",", 
    " ", 
    RowBox[{"Torsion", " ", "and", " ", "Ricci"}]}], " ", "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"RuleDelayed", "::", "rhs"}], "]"}], "\n", "\n", 
   RowBox[{
    RowBox[{"CovDModificationsCPS", "[", 
     RowBox[{
      RowBox[{"covd_", "[", "ind_", "]"}], ",", "vbundle_", ",", 
      "additionalvariables___"}], "]"}], ":=", 
    RowBox[{"Module", "[", "\n", "\t", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "tangentbundle", ",", "manifold", ",", "indices", ",", "innerindices", 
        ",", "christoffel", ",", "dlChristoffel", ",", "Achristoffel", ",", 
        "dlAChristoffel", ",", "riemann", ",", "dlriemann", ",", "Friemann", ",",
         "ricci", ",", "torsion", ",", "normal"}], "}"}], ",", "\n", "\t\t\t",
       "\n", "\t", 
      RowBox[{
       RowBox[{"tangentbundle", "=", 
        RowBox[{"VBundleOfIndex", "[", "ind", "]"}]}], ";", "  ", "\n", "\t", 
       RowBox[{"manifold", "=", 
        RowBox[{"BaseOfVBundle", "[", "tangentbundle", "]"}]}], ";", "\n", 
       "\t", 
       RowBox[{"indices", "=", 
        RowBox[{"GetIndicesOfVBundle", "[", 
         RowBox[{"tangentbundle", ",", "4"}], "]"}]}], ";", "\n", "\t", "\n", 
       "\t", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Impose", " ", "WWedge"}], "-", 
         RowBox[{
         "Leibniz", " ", "rule", " ", "of", " ", "the", " ", "covariant", " ",
           "derivative"}]}], " ", "*)"}], "\n", "\t", 
       RowBox[{
        RowBox[{
         RowBox[{"covd", "[", 
          RowBox[{"MakePattern", "[", 
           RowBox[{"-", "ind"}], "]"}], "]"}], "[", "expr_WWedge", "]"}], ":=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"MapAt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"covd", "[", 
               RowBox[{"-", "ind"}], "]"}], "[", "#", "]"}], "&"}], ",", 
            "expr", ",", "i"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";", 
       "\n", "\t", 
       RowBox[{
        RowBox[{
         RowBox[{"covd", "[", 
          RowBox[{"MakePattern", "[", "ind", "]"}], "]"}], "[", "expr_WWedge",
          "]"}], ":=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"MapAt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"covd", "[", "ind", "]"}], "[", "#", "]"}], "&"}], ",", 
            "expr", ",", "i"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";", 
       "\n", "\t\t", "\n", "\t", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Definition", " ", "of", " ", "tensors", " ", "to", " ", "be", " ", 
         "used", " ", "below"}], " ", "*)"}], "\n", "\t", 
       RowBox[{"christoffel", "=", 
        RowBox[{"HeadOfTensor", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Christoffel", "[", "covd", "]"}], "[", 
           RowBox[{
            RowBox[{"indices", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"indices", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"indices", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"indices", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"indices", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"indices", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}]}], "]"}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"Christoffel", "[", "covd", "]"}], " ", "remains", " ", 
          "unevaluated"}], ",", " ", 
         RowBox[{
         "hence", " ", "we", " ", "need", " ", "to", " ", "include", " ", 
          "the", " ", "indices"}]}], "  ", "*)"}], "\n", "\t", 
       RowBox[{
        RowBox[{"ChristoffelAUX", "[", "covd", "]"}], "=", "christoffel"}], ";",
        "\n", "\t", 
       RowBox[{
        RowBox[{"ChristoffelAUX", "[", 
         RowBox[{"covd", ",", "PD"}], "]"}], "=", "christoffel"}], ";", "\n", 
       "\t", 
       RowBox[{
        RowBox[{"ChristoffelAUX", "[", 
         RowBox[{"PD", ",", "covd"}], "]"}], "=", 
        RowBox[{"MultiplyHead", "[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "christoffel"}], "]"}]}], ";", "\n", "\t", 
       RowBox[{"dlChristoffel", "=", 
        RowBox[{"VertDiff", "[", "christoffel", "]"}]}], ";", "\n", "\t", 
       RowBox[{"torsion", "=", 
        RowBox[{"HeadOfTensor2", "[", 
         RowBox[{"Torsion", "[", "covd", "]"}], "]"}]}], ";", "\n", "\t", 
       RowBox[{"riemann", "=", 
        RowBox[{"HeadOfTensor2", "[", 
         RowBox[{"Riemann", "[", "covd", "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"ricci", "=", 
        RowBox[{"HeadOfTensor2", "[", 
         RowBox[{"Ricci", "[", "covd", "]"}], "]"}]}], ";", " ", "\n", "\t", 
       "\n", "\t", 
       RowBox[{"(*", " ", 
        RowBox[{"Create", " ", "variational", " ", "relations"}], " ", "*)"}],
        "\t\t", "\n", "    ", 
       RowBox[{"$printAddVariationalRelation", "=", "False"}], ";", "\t", 
       "\n", "\t", 
       RowBox[{"AddVariationalRelation", "[", 
        RowBox[{"christoffel", "->", 
         RowBox[{"riemann", "->", "ricci"}]}], "]"}], ";", "\n", "\t", 
       RowBox[{"AddVariationalRelation", "[", 
        RowBox[{"christoffel", "->", "torsion"}], "]"}], ";", "\n", "\t", 
       "\n", "\t", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Definition", " ", "of", " ", "tensors", " ", "to", " ", "be", " ", 
         "used", " ", "below", " ", "if", " ", "there", " ", "are", " ", 
         "inner", " ", "indices"}], " ", "*)"}], "\n", "\t", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"tangentbundle", "=!=", "vbundle"}], ",", "\n", "\t\t", 
         RowBox[{"(", "\n", "\t\t", 
          RowBox[{
           RowBox[{"innerindices", "=", 
            RowBox[{"GetIndicesOfVBundle", "[", 
             RowBox[{"vbundle", ",", "4"}], "]"}]}], ";", " ", "\n", "\t\t", 
           RowBox[{"Achristoffel", "=", 
            RowBox[{"HeadOfTensor", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"AChristoffel", "[", "covd", "]"}], "[", 
               RowBox[{
                RowBox[{"innerindices", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"-", 
                 RowBox[{"indices", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                RowBox[{"-", 
                 RowBox[{"innerindices", "[", 
                  RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"innerindices", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"-", 
                 RowBox[{"indices", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                RowBox[{"-", 
                 RowBox[{"innerindices", "[", 
                  RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}]}], "]"}]}], ";", 
           " ", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{
              RowBox[{"AChristoffel", "[", "covd", "]"}], " ", "remains", " ",
               "unevaluated"}], ",", " ", 
             RowBox[{
             "hence", " ", "we", " ", "need", " ", "to", " ", "include", " ", 
              "the", " ", "indices"}]}], "  ", "*)"}], "\n", "\t\t", 
           RowBox[{
            RowBox[{"AChristoffelAUX", "[", "covd", "]"}], "=", 
            "Achristoffel"}], ";", "\n", "\t\t", 
           RowBox[{
            RowBox[{"AChristoffelAUX", "[", 
             RowBox[{"covd", ",", "PD"}], "]"}], "=", "Achristoffel"}], ";", 
           "\n", "\t    ", 
           RowBox[{
            RowBox[{"AChristoffelAUX", "[", 
             RowBox[{"PD", ",", "covd"}], "]"}], "=", 
            RowBox[{"MultiplyHead", "[", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "Achristoffel"}], "]"}]}], ";", "\n", 
           "\t\t", 
           RowBox[{"dlAChristoffel", "=", 
            RowBox[{"VertDiff", "[", "Achristoffel", "]"}]}], ";", "\n", 
           "\t\t", "\n", "\t\t", 
           RowBox[{"Unprotect", "[", 
            RowBox[{"VertDiff", ",", "AChristoffel"}], "]"}], ";", "\n", 
           "\t\t", 
           RowBox[{
            RowBox[{"VertDiff", "[", 
             RowBox[{"AChristoffel", "[", "covd", "]"}], "]"}], "^=", 
            RowBox[{"Head", "@", 
             RowBox[{"dlAChristoffel", "[", 
              RowBox[{
               RowBox[{"indices", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"-", 
                RowBox[{"indices", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", 
               RowBox[{"-", 
                RowBox[{"indices", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}]}], ";", "\n", 
           "\t\t", 
           RowBox[{
            RowBox[{"VertDiff", "[", 
             RowBox[{"AChristoffel", "[", 
              RowBox[{"covd", ",", "PD"}], "]"}], "]"}], "^=", 
            RowBox[{"Head", "@", 
             RowBox[{"dlAChristoffel", "[", 
              RowBox[{
               RowBox[{"indices", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"-", 
                RowBox[{"indices", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", 
               RowBox[{"-", 
                RowBox[{"indices", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}]}], ";", "\n", 
           "\t\t", 
           RowBox[{
            RowBox[{"VertDiff", "[", 
             RowBox[{"AChristoffel", "[", 
              RowBox[{"PD", ",", "covd"}], "]"}], "]"}], "^=", 
            RowBox[{"MultiplyHead", "[", 
             RowBox[{
              RowBox[{"-", "1"}], ",", 
              RowBox[{"Head", "@", 
               RowBox[{"dlAChristoffel", "[", 
                RowBox[{
                 RowBox[{"indices", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"-", 
                  RowBox[{"indices", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                 RowBox[{"-", 
                  RowBox[{"indices", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}]}], "]"}]}], ";",
            "\[IndentingNewLine]", "\t\t", 
           RowBox[{"Protect", "[", 
            RowBox[{"VertDiff", ",", "AChristoffel"}], "]"}], ";", "\n", "\t",
            "\n", "\t\t", 
           RowBox[{"Friemann", "=", 
            RowBox[{"HeadOfTensor2", "[", 
             RowBox[{"FRiemann", "[", "covd", "]"}], "]"}]}], ";", "\n", 
           "\t\t", 
           RowBox[{"AddVariationalRelation", "[", 
            RowBox[{"Achristoffel", "->", "Friemann"}], "]"}], ";", "\n", 
           "\t\t", 
           RowBox[{"AddVariationalRelation", "[", 
            RowBox[{
             RowBox[{"Dagger", "@", "Achristoffel"}], "->", 
             RowBox[{"Dagger", "@", "Friemann"}]}], "]"}], ";", 
           "\[IndentingNewLine]", "\t\t", 
           RowBox[{"GenerateExpandVertDiffRuleRiemann", "[", 
            RowBox[{"covd", ",", "Achristoffel", ",", "dlAChristoffel", ",", 
             RowBox[{"Friemann", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"indices", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], ",", 
               RowBox[{"-", 
                RowBox[{"indices", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", 
               RowBox[{"-", 
                RowBox[{"innerindices", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}], ",", 
               RowBox[{"innerindices", "[", 
                RowBox[{"[", "4", "]"}], "]"}]}], "]"}], ",", 
             RowBox[{"VertDiff", "[", "Friemann", "]"}], ",", "torsion"}], 
            "]"}], ";"}], "\n", "\t\t", ")"}], ",", "\n", "\t\t", 
         RowBox[{"(", "\n", "\t\t", 
          RowBox[{
           RowBox[{
            RowBox[{"AChristoffelAUX", "[", "covd", "]"}], "=", "Zero"}], 
           ";"}], "\n", "\t\t", ")"}]}], "\n", "\t", "]"}], ";", "\n", "\t", 
       "\n", "\t", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Define", " ", "rules", " ", "for", " ", "ExpandVertDiffRules"}], " ",
         "*)"}], "\n", "\t", 
       RowBox[{"Unprotect", "[", 
        RowBox[{"VertDiff", ",", "Christoffel"}], "]"}], ";", "\n", "\t", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"GenerateExpandVertDiffRuleRiemann", "[", 
        RowBox[{"covd", ",", "christoffel", ",", "dlChristoffel", ",", 
         RowBox[{"riemann", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"VertDiff", "[", "riemann", "]"}], ",", "torsion"}], "]"}], ";",
        "\[IndentingNewLine]", "\t", 
       RowBox[{"GenerateExpandVertDiffRuleTorsion", "[", 
        RowBox[{"dlChristoffel", ",", 
         RowBox[{"torsion", "[", 
          RowBox[{
           RowBox[{"indices", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"VertDiff", "[", "torsion", "]"}]}], "]"}], ";", " ", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"GenerateExpandVertDiffRuleRicci", "[", 
        RowBox[{
         RowBox[{"ricci", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", 
         RowBox[{"VertDiff", "[", "ricci", "]"}], ",", "riemann"}], "]"}], ";",
        "\n", "\t\t", "\n", "\t", 
       RowBox[{
        RowBox[{"VertDiff", "[", 
         RowBox[{"Christoffel", "[", "covd", "]"}], "]"}], "^=", 
        RowBox[{"Head", "@", 
         RowBox[{"dlChristoffel", "[", 
          RowBox[{
           RowBox[{"indices", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}]}], ";", "\n", "\t", 
       RowBox[{
        RowBox[{"VertDiff", "[", 
         RowBox[{"Christoffel", "[", 
          RowBox[{"covd", ",", "PD"}], "]"}], "]"}], "^=", 
        RowBox[{"Head", "@", 
         RowBox[{"dlChristoffel", "[", 
          RowBox[{
           RowBox[{"indices", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{"-", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}]}], ";", "\n", "\t", 
       RowBox[{
        RowBox[{"VertDiff", "[", 
         RowBox[{"Christoffel", "[", 
          RowBox[{"PD", ",", "covd"}], "]"}], "]"}], "^=", 
        RowBox[{"MultiplyHead", "[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"Head", "@", 
           RowBox[{"dlChristoffel", "[", 
            RowBox[{
             RowBox[{"indices", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"-", 
              RowBox[{"indices", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ",", 
             RowBox[{"-", 
              RowBox[{"indices", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{"Protect", "[", 
        RowBox[{"VertDiff", ",", "Christoffel"}], "]"}], ";", "\n", "\t", 
       "\n", "\t", 
       RowBox[{"DefTotalDerivative", "[", "covd", "]"}], ";", "\n", "\t", 
       RowBox[{"DefNormalOfCovD", "[", 
        RowBox[{"covd", ",", 
         RowBox[{"indices", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "manifold"}], "]"}], ";", "\n",
        "\t", "\n", "\t", 
       RowBox[{"If", "[", 
        RowBox[{"$DefInfoQ", ",", 
         RowBox[{"Print", "[", 
          
          RowBox[{"\"\<** AddVariationalRelation: Variational relations \
created for \>\"", ",", "covd", ",", "\"\<.\>\""}], "]"}]}], "]"}], ";", "\n",
        "    ", 
       RowBox[{"$printAddVariationalRelation", "=", "True"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.9318358672655144`*^9, {3.9319194752551565`*^9, 3.931919480313019*^9}, {
   3.931945690159758*^9, 3.931945750505718*^9}, {3.931945788468634*^9, 
   3.931945859096271*^9}, {3.931945905554218*^9, 3.931945908726142*^9}, {
   3.93200636393322*^9, 3.93200639336861*^9}, {3.932006592789816*^9, 
   3.932006596511231*^9}, {3.932006627253218*^9, 3.932006631599211*^9}, {
   3.93200672176855*^9, 3.9320068172438*^9}, 3.932017632298293*^9, {
   3.93201767434369*^9, 3.932017680483576*^9}, 3.932029687850279*^9, 
   3.932037359152578*^9, {3.932038249311191*^9, 3.932038398366421*^9}, {
   3.932038429343839*^9, 3.93203843235063*^9}, {3.932038469605623*^9, 
   3.932038470090982*^9}, {3.932039557285334*^9, 3.932039652897715*^9}, {
   3.93204220487163*^9, 3.932042228042278*^9}, {3.93204289925137*^9, 
   3.932042937231559*^9}, {3.932093647516043*^9, 3.932093654110863*^9}, {
   3.932129284870198*^9, 3.932129378324875*^9}, {3.9321301769811535`*^9, 
   3.9321301843566313`*^9}, {3.9321804454893217`*^9, 
   3.9321804529106803`*^9}, {3.93227136630357*^9, 3.9322713853653593`*^9}, {
   3.932271877222102*^9, 3.932271915038328*^9}, {3.932297411217804*^9, 
   3.932297432904259*^9}, {3.932359525380924*^9, 3.9323595272161584`*^9}, 
   3.932387570859874*^9, 3.932522728808476*^9, 3.932637740261566*^9, {
   3.932639434344436*^9, 3.932639434536236*^9}, {3.932640077379796*^9, 
   3.932640103310054*^9}, {3.9327119977475657`*^9, 3.932712010905471*^9}, {
   3.932712134406143*^9, 3.9327121376665597`*^9}, {3.932715684669766*^9, 
   3.932715718148159*^9}, {3.932715799218834*^9, 3.9327158059956837`*^9}, {
   3.932715868455219*^9, 3.93271587819848*^9}, {3.932716278184285*^9, 
   3.932716305373096*^9}, {3.9327179131183167`*^9, 3.932717921565514*^9}, {
   3.932717969865563*^9, 3.9327179874757175`*^9}, {3.932718990347639*^9, 
   3.932719023139507*^9}, {3.932719226453256*^9, 3.932719316868399*^9}, {
   3.932720273305619*^9, 3.932720301461312*^9}, {3.9327203914383326`*^9, 
   3.9327204043120003`*^9}, {3.932725166039882*^9, 3.932725169107888*^9}, {
   3.932725279585589*^9, 3.9327252877772226`*^9}, {3.932725423741296*^9, 
   3.93272544200097*^9}, {3.9327260498229856`*^9, 3.932726066258298*^9}, {
   3.9327262128984385`*^9, 3.932726320796633*^9}, {3.932726459765882*^9, 
   3.932726474211896*^9}, 3.9327265107534013`*^9, 3.9327267810550346`*^9, {
   3.932726882499129*^9, 3.932726887070405*^9}, {3.93272749402417*^9, 
   3.9327275006187*^9}, 3.9327275312965617`*^9, {3.932727588939194*^9, 
   3.932727615167998*^9}, {3.932727826705191*^9, 3.932727826974474*^9}, {
   3.932727916522539*^9, 3.932727916951887*^9}, {3.93272807129533*^9, 
   3.932728243464301*^9}, {3.932728276103613*^9, 3.93272845168796*^9}, {
   3.9327286036166067`*^9, 3.932728610260255*^9}, 3.932728653828579*^9, {
   3.9327288785966935`*^9, 3.9327289499635377`*^9}, 3.932728998014388*^9, {
   3.93273937315425*^9, 3.932739426821949*^9}, {3.9327643473292427`*^9, 
   3.932764347349535*^9}, {3.932774773006706*^9, 3.932774795977462*^9}, 
   3.932774937880096*^9, {3.9327752598559637`*^9, 3.932775262861019*^9}, {
   3.93277530763462*^9, 3.932775408588372*^9}, {3.932776272103023*^9, 
   3.9327762800779448`*^9}, 3.932776410599324*^9, 3.932820175516779*^9, 
   3.932820208717606*^9, 3.932880542951945*^9, {3.932881006318826*^9, 
   3.932881006328828*^9}, {3.932903748248298*^9, 3.932903756512472*^9}, {
   3.9329813397479835`*^9, 3.932981358476002*^9}, {3.932983739539635*^9, 
   3.932983741365227*^9}, 3.932984836918935*^9, {3.932985083663152*^9, 
   3.932985129999656*^9}, {3.932985217409866*^9, 3.9329852374569144`*^9}, {
   3.932985291701445*^9, 3.932985302912773*^9}, {3.932985361754807*^9, 
   3.9329853642433167`*^9}, {3.932985441552809*^9, 3.932985445556642*^9}, {
   3.9329855334024334`*^9, 3.9329855528263893`*^9}, {3.9329855862373457`*^9, 
   3.932985592477603*^9}, {3.9329856747801523`*^9, 3.932985704948316*^9}, {
   3.932985764638028*^9, 3.9329857753399305`*^9}, {3.932985932400576*^9, 
   3.932985983764256*^9}, {3.9329860448818207`*^9, 3.9329861544165277`*^9}, {
   3.932986196130132*^9, 3.932986201120463*^9}, {3.932986265764025*^9, 
   3.932986317103728*^9}, {3.932986475786107*^9, 3.932986523539381*^9}, {
   3.933075387853604*^9, 3.933075387870605*^9}, {3.9330754621215687`*^9, 
   3.9330754621399403`*^9}, {3.9332333328844705`*^9, 3.933233366102533*^9}, 
   3.93333005641338*^9, {3.933406054595725*^9, 3.933406058436807*^9}, {
   3.933406105003892*^9, 3.933406107373477*^9}, {3.933747349674017*^9, 
   3.933747351763543*^9}, 3.949082261063815*^9, 3.949767387742749*^9, {
   3.9501240283038025`*^9, 3.9501240358197536`*^9}, {3.950207482354854*^9, 
   3.950207490114262*^9}, {3.950207520356003*^9, 3.950207566159504*^9}, 
   3.95020768378562*^9, {3.950268903007747*^9, 3.950268906456554*^9}, {
   3.950548476020649*^9, 3.950548494699751*^9}, {3.95054857266683*^9, 
   3.950548591206783*^9}, {3.9505486514547367`*^9, 3.95054865382031*^9}, {
   3.950548719208738*^9, 3.9505487202909966`*^9}, {3.95054879405722*^9, 
   3.9505488509104424`*^9}, {3.950548910456003*^9, 3.9505489543728123`*^9}, {
   3.950614695341425*^9, 3.950614737121575*^9}, {3.950810009106476*^9, 
   3.950810012037174*^9}, {3.9509733863866158`*^9, 3.950973473430784*^9}, {
   3.9509774437313843`*^9, 3.9509774874260826`*^9}, {3.951045024417312*^9, 
   3.951045115523554*^9}, {3.951045387122692*^9, 3.951045401874336*^9}, 
   3.951045465309498*^9, {3.9512250246203*^9, 3.951225024795626*^9}, {
   3.951243296587631*^9, 3.951243301640609*^9}, {3.9512478267060947`*^9, 
   3.951247835270798*^9}, {3.9513291109273586`*^9, 3.951329114844438*^9}, {
   3.9522616512615795`*^9, 3.9522616638139*^9}, {3.9522617227144413`*^9, 
   3.952261784539768*^9}, {3.9522618768441353`*^9, 3.9522618803670883`*^9}, {
   3.9522631920660496`*^9, 3.952263197836561*^9}, 3.9522632428628216`*^9, {
   3.952263476059126*^9, 3.952263495925621*^9}, {3.95226364209478*^9, 
   3.9522636706771336`*^9}, {3.952268610597063*^9, 3.9522686128784523`*^9}, {
   3.952272196185484*^9, 3.952272211710457*^9}, {3.952272257119114*^9, 
   3.9522722717245636`*^9}, {3.952272311129793*^9, 3.9522723133450756`*^9}, {
   3.952272425251871*^9, 3.9522724319640713`*^9}, 3.952272488102194*^9, {
   3.952272550513811*^9, 3.952272586771242*^9}, {3.952272626072109*^9, 
   3.9522726381928234`*^9}, 3.9522726797007656`*^9, {3.9522741288552265`*^9, 
   3.952274136521721*^9}, {3.9522742093356075`*^9, 3.9522742115826283`*^9}, {
   3.9538376789220314`*^9, 3.953837740901495*^9}, {3.9538379665366898`*^9, 
   3.9538380026015034`*^9}, {3.953838753021946*^9, 3.953838757036543*^9}, {
   3.9538393805816517`*^9, 3.9538393930263844`*^9}, {3.954180138269636*^9, 
   3.9541801409474316`*^9}, 3.954864318032427*^9, {3.954864415930561*^9, 
   3.954864422140051*^9}, {3.954866420062765*^9, 3.9548664262127495`*^9}, {
   3.958568594514927*^9, 3.95856860177236*^9}, 3.9585699035689926`*^9, {
   3.958580957735077*^9, 3.9585810034429073`*^9}, {3.958581058651497*^9, 
   3.958581136777603*^9}, {3.9585816266799965`*^9, 3.9585816536566257`*^9}, {
   3.958869164469307*^9, 3.9588691873395424`*^9}, {3.9606144510603466`*^9, 
   3.960614466649309*^9}},ExpressionUUID->"1699cb01-5f79-7b44-8a81-\
81c585cf8759"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Rules for ExpandVertDiffRules"
}], "Subsection",
 CellChangeTimes->{{3.931835873541321*^9, 3.931835879691138*^9}, 
   3.932029687865285*^9, 3.9483956722001066`*^9, 
   3.949082261070824*^9},ExpressionUUID->"a0c3c117-4449-1e4e-89c2-\
903d793cd4e3"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "I", " ", "am", " ", "pretty", " ", "sure", " ", "that", " ", "I", " ", 
    "could", " ", "simply", " ", "use", " ", "ExpandVertDiffRules"}], ",", 
   " ", 
   RowBox[{
   "but", " ", "that", " ", "function", " ", "was", " ", "added", " ", 
    "later", " ", "and", " ", "it", " ", "will", " ", "require", " ", "some", 
    " ", "work", " ", "and", " ", "it", " ", "just", " ", "works", " ", 
    "fine", " ", "like", " ", "that"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.9581644852724285`*^9, 3.958164599078573*^9}, {
  3.958869194384203*^9, 
  3.958869211559128*^9}},ExpressionUUID->"f0a483b7-0aa4-1b42-bfb7-\
1aa6db37142c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RemoveExpandVertDiffRule", "::", "ProtectedRules1"}], " ", "=", 
   " ", "\"\<`1` has predefined rules and cannot be removed. Use MakeVertRule \
instead.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"GenerateExpandVertDiffRule", "::", "ProtectedRules2"}], " ", "=",
     " ", "\"\<`1` has predefined rules and cannot be overridden. Use \
MakeVertRule instead.\>\""}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"ProtectVertDiffRule", "[", "dltensor_", "]"}], ":=", 
  RowBox[{"(", "\n", "    ", 
   RowBox[{
    RowBox[{
     RowBox[{"ProtectedVertDiffRuleQ", "[", "dltensor", "]"}], "^=", "True"}],
     ";", "\n", "\t", 
    RowBox[{"dltensor", " ", "/:", " ", 
     RowBox[{"RemoveExpandVertDiffRule", "[", "dltensor", "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"RemoveExpandVertDiffRule", "::", "ProtectedRules1"}], ",", 
        "dltensor"}], "]"}]}]}], ";", "\n", "\t", 
    RowBox[{"dltensor", " ", "/:", " ", 
     RowBox[{"GenerateExpandVertDiffRuleAUX", "[", 
      RowBox[{
       RowBox[{"dltensor", "[", "indices___", "]"}], ",", "_"}], "]"}], " ", ":=", 
     RowBox[{"Throw", "[", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"GenerateExpandVertDiffRule", "::", "ProtectedRules2"}], ",", 
        "dltensor"}], "]"}], "]"}]}], ";"}], ")"}]}]}], "Code",
 CellChangeTimes->{{3.949692768895493*^9, 3.949692799457756*^9}, {
   3.949692866756077*^9, 3.9496928677838345`*^9}, {3.952090090774948*^9, 
   3.95209009304191*^9}, 3.9520918617878895`*^9, {3.952174953392103*^9, 
   3.9521749536531353`*^9}, {3.9571941420686245`*^9, 3.957194142694044*^9}, {
   3.957194174210932*^9, 3.9571942672988224`*^9}, {3.958869313350687*^9, 
   3.958869343338192*^9}},
 CellLabel->
  "In[741]:=",ExpressionUUID->"2da60dfc-1349-cc4e-8bd6-e5965f911acc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnprotectVertDiffRule", "[", "dltensor_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ProtectedVertDiffRuleQ", "[", "dltensor", "]"}], ",", 
    "\[IndentingNewLine]", "\t", 
    RowBox[{"(", "\n", "\t", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{"$DefInfoQ", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** UnprotectVertDiffRule: VertDiffRule for \>\"", ",", 
          "dltensor", ",", "\"\< has been unprotected.\>\""}], "]"}]}], "]"}],
       ";", "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{"ProtectedVertDiffRuleQ", "[", "dltensor", "]"}], "^=", 
       "False"}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"dltensor", " ", "/:", " ", 
       RowBox[{
        RowBox[{"RemoveExpandVertDiffRule", "[", "dltensor", "]"}], "=."}]}], 
      ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"dltensor", " ", "/:", " ", 
       RowBox[{
        RowBox[{"GenerateExpandVertDiffRuleAUX", "[", 
         RowBox[{
          RowBox[{"dltensor", "[", "indices___", "]"}], ",", "_"}], "]"}], 
        "=."}]}], ";"}], ")"}]}], "]"}]}]], "Code",
 CellChangeTimes->{{3.9588692233138695`*^9, 3.9588692337049923`*^9}, {
   3.9588692836100025`*^9, 3.958869295167679*^9}, {3.95886935083654*^9, 
   3.958869371429371*^9}, 3.9588694161649*^9, {3.9588722037568283`*^9, 
   3.958872267703665*^9}, {3.9588759980836544`*^9, 3.958876009037794*^9}},
 CellLabel->
  "In[744]:=",ExpressionUUID->"6000fbcf-2729-d445-8a1f-4c21fbc051d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenerateExpandVertDiffRuleRiemann", "[", 
    RowBox[{"covd_", ",", "Chris_", ",", " ", "dlChris_", ",", " ", 
     RowBox[{"riemann_", "[", 
      RowBox[{
       RowBox[{"-", "a_"}], ",", " ", 
       RowBox[{"-", "b_"}], ",", " ", 
       RowBox[{"-", "c_"}], ",", " ", "d_"}], "]"}], ",", " ", "dlRiemann_", ",",
      " ", "torsion_"}], "]"}], ":=", 
   RowBox[{"(", "\n", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"ExpandVertDiffRules", "[", 
       RowBox[{
        RowBox[{"dlRiemann", "[", 
         RowBox[{
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}], ",", 
          RowBox[{"-", "c_Symbol"}], ",", "b_Symbol"}], "]"}], ",", 
        RowBox[{"options", ":", 
         RowBox[{"OptionsPattern", "[", 
          RowBox[{"Options", "[", "ExpandVertDiff", "]"}], "]"}]}]}], "]"}], ":=",
       "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"FilterVertExpand", "[", 
        RowBox[{
         RowBox[{"dlRiemann", "[", 
          RowBox[{
           RowBox[{"-", "a"}], ",", " ", 
           RowBox[{"-", "b"}], ",", " ", 
           RowBox[{"-", "c"}], ",", " ", "b"}], "]"}], ",", "options"}], 
        "]"}], "[", 
       RowBox[{"VertDiff", "[", 
        RowBox[{"$RicciSign", " ", 
         RowBox[{
          RowBox[{"Ricci", "[", "covd", "]"}], "[", 
          RowBox[{
           RowBox[{"-", "a"}], ",", 
           RowBox[{"-", "c"}]}], "]"}]}], "]"}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "This", " ", "definitions", " ", "allow", " ", "to", " ", "use", " ", 
       "HoldExpandVertDiff"}], " ", "*)"}], "\n", "\t\t", "\n", "\t", 
     RowBox[{
      RowBox[{"ExpandVertDiffRules", "[", 
       RowBox[{
        RowBox[{"dlRiemann", "[", 
         RowBox[{
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}], ",", 
          RowBox[{"-", "c_Symbol"}], ",", "a_Symbol"}], "]"}], ",", 
        RowBox[{"options", ":", 
         RowBox[{"OptionsPattern", "[", 
          RowBox[{"Options", "[", "ExpandVertDiff", "]"}], "]"}]}]}], "]"}], ":=",
       "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"FilterVertExpand", "[", 
        RowBox[{
         RowBox[{"dlRiemann", "[", 
          RowBox[{
           RowBox[{"-", "a"}], ",", " ", 
           RowBox[{"-", "b"}], ",", " ", 
           RowBox[{"-", "c"}], ",", " ", "a"}], "]"}], ",", "options"}], 
        "]"}], "[", 
       RowBox[{"VertDiff", "[", 
        RowBox[{
         RowBox[{"-", "$RicciSign"}], " ", 
         RowBox[{
          RowBox[{"Ricci", "[", "covd", "]"}], "[", 
          RowBox[{
           RowBox[{"-", "b"}], ",", 
           RowBox[{"-", "c"}]}], "]"}]}], "]"}], "]"}]}], ";", "\n", "\t\t", 
     "\n", "\t", 
     RowBox[{
      RowBox[{"ExpandVertDiffRules", "[", 
       RowBox[{
        RowBox[{"dlRiemann", "[", 
         RowBox[{
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}], ",", 
          RowBox[{"-", "c_Symbol"}], ",", "d_Symbol"}], "]"}], ",", 
        RowBox[{"options", ":", 
         RowBox[{"OptionsPattern", "[", 
          RowBox[{"Options", "[", "ExpandVertDiff", "]"}], "]"}]}]}], "]"}], ":=",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "c", " ", "and", " ", "d", " ", "might", " ", "be", " ", "internal", " ",
         "indices"}], " ", "*)"}], "\n", "\t\t", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"dummy", "=", 
          RowBox[{"DummyAs", "[", "a", "]"}]}], "}"}], ",", "\n", "\t\t\t", 
        RowBox[{
         RowBox[{"FilterVertExpand", "[", 
          RowBox[{
           RowBox[{"dlRiemann", "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", " ", 
             RowBox[{"-", "b"}], ",", " ", 
             RowBox[{"-", "c"}], ",", " ", "d"}], "]"}], ",", "options"}], 
          "]"}], "\n", "\t\t\t\t\t\t\t", "[", 
         RowBox[{
          RowBox[{"-", "$RiemannSign"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"covd", "[", 
              RowBox[{"-", "a"}], "]"}], "[", 
             RowBox[{"dlChris", "[", 
              RowBox[{"d", ",", " ", 
               RowBox[{"-", "b"}], ",", " ", 
               RowBox[{"-", "c"}]}], "]"}], "]"}], " ", "-", " ", 
            RowBox[{
             RowBox[{"covd", "[", 
              RowBox[{"-", "b"}], "]"}], "[", 
             RowBox[{"dlChris", "[", 
              RowBox[{"d", ",", " ", 
               RowBox[{"-", "a"}], ",", " ", 
               RowBox[{"-", "c"}]}], "]"}], "]"}], " ", "+", " ", 
            RowBox[{"$TorsionSign", "  ", 
             RowBox[{"torsion", "[", 
              RowBox[{"dummy", ",", " ", 
               RowBox[{"-", "a"}], ",", " ", 
               RowBox[{"-", "b"}]}], "]"}], "  ", 
             RowBox[{"dlChris", "[", 
              RowBox[{"d", ",", " ", 
               RowBox[{"-", "dummy"}], ",", " ", 
               RowBox[{"-", "c"}]}], "]"}]}]}], ")"}]}], "]"}]}], "\n", 
       "\t\t", "]"}]}], ";", "\n", "  ", "\n", "\t", 
     RowBox[{"ProtectVertDiffRule", "[", "dlRiemann", "]"}], ";"}], "\n", 
    ")"}]}], ";"}]], "Code",
 CellChangeTimes->{{3.9320937220312943`*^9, 3.932093749188789*^9}, {
   3.932127367728925*^9, 3.9321274367834024`*^9}, {3.932129435606868*^9, 
   3.932129530564783*^9}, 3.9321295685598145`*^9, 3.932129712640498*^9, 
   3.932130019582179*^9, {3.932130198614907*^9, 3.9321302083642435`*^9}, {
   3.932180427669254*^9, 3.932180438204599*^9}, 3.932271940902336*^9, {
   3.932297539174375*^9, 3.932297543188429*^9}, {3.932297578401431*^9, 
   3.932297618545781*^9}, {3.932298069468219*^9, 3.9322980708564*^9}, {
   3.9