(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[  10483924,     274517]
NotebookOptionsPosition[   9981599,     267137]
NotebookOutlinePosition[  10002079,     267490]
CellTagsIndexPosition[   9997736,     267403]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xCPS",
 FontWeight->"Bold",
 FontSlant->"Italic",
 FontColor->RGBColor[1, 0, 0]]], "Title",
 CellChangeTimes->{{3.950963190781385*^9, 3.950963191242895*^9}, 
   3.9586399833910904`*^9, 3.9586401311957417`*^9},
 FontFamily->
  "Source Sans Pro",ExpressionUUID->"bfaf6fa6-98b1-704c-94d2-e9520730b1c9"],

Cell[TextData[{
 StyleBox["Covariant Phase Space Formalism for ",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["xAct",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]]
}], "Subtitle",
 CellChangeTimes->{{3.9509632131664257`*^9, 3.9509632280634594`*^9}, {
  3.955681464626131*^9, 3.9556814658351336`*^9}},
 FontFamily->
  "Source Sans Pro",ExpressionUUID->"ea98ad66-0922-a944-a945-c25657dce876"],

Cell[TextData[StyleBox["Juan Margalef-Bentabol",
 FontSize->18]], "Author",
 CellChangeTimes->{{3.950963234083061*^9, 3.950963359964699*^9}, {
   3.950963818523828*^9, 3.950963821058983*^9}, 
   3.958056238894573*^9},ExpressionUUID->"ede403b1-7ee4-8744-ae8d-\
e757061a2ab4"],

Cell[TextData[StyleBox["juan.margalef@umontreal.ca\nUniversit\[EAcute] de \
Montr\[EAcute]al, Canada",
 FontSize->14]], "Affiliation",
 CellChangeTimes->{{3.950963234083061*^9, 3.950963359964699*^9}, {
  3.950963818523828*^9, 3.950963821058983*^9}, {3.9580562416863174`*^9, 
  3.9580562420701847`*^9}, {3.9580562723956356`*^9, 3.9580562740222015`*^9}, {
  3.963744318258642*^9, 
  3.9637443449382153`*^9}},ExpressionUUID->"a3175092-1322-7344-9680-\
409b568cbb91"],

Cell[TextData[StyleBox["Laura S\[AAcute]nchez Cotta",
 FontSize->18]], "Author",
 CellChangeTimes->{{3.950963234083061*^9, 3.950963359964699*^9}, {
  3.950963818523828*^9, 3.950963821058983*^9}, {3.958056238894573*^9, 
  3.9580562683016167`*^9}},ExpressionUUID->"75b5456e-fe07-5e49-9b41-\
2a9299de228e"],

Cell[TextData[StyleBox["100527266@alumnos.uc3m.es\nUniversidad Carlos III de \
Madrid, Spain",
 FontSize->14]], "Affiliation",
 CellChangeTimes->{{3.950963234083061*^9, 3.950963359964699*^9}, {
  3.950963818523828*^9, 3.950963821058983*^9}, {3.9580562416863174`*^9, 
  3.9580562598141727`*^9}},ExpressionUUID->"da79bfa9-72a8-f146-8c45-\
08d93a372c8a"],

Cell[TextData[{
 StyleBox["xCPS",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is a package to work within the Covariant Phase Space formalism. It is \
built on top of ",
 StyleBox["xAct",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", a free package for fast manipulation of abstract tensor expressions that \
can be downloaded from ",
 ButtonBox["http://www.xact.es",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.xact.es"], None},
  ButtonNote->"http://www.xact.es"],
 ". \n\nThe latest version of ",
 StyleBox["xCPS",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is available at: ",
 StyleBox["https://github.com/juanmargalef/xCPS",
  FontFamily->"Bitstream Vera Sans"],
 "\n\n",
 StyleBox["xCPS",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is distributed under the GNU General Public License (\[Copyright] 2025). \n\
\nFor further resources, user discussions, and additional contributed \
packages, see:\n- ",
 StyleBox["xAct",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " forum: http://groups.google.com/group/xAct\n- ",
 StyleBox["xAct",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " contributions: https://contrib.xact.es"
}], "Abstract",
 CellChangeTimes->{{3.9509633915790024`*^9, 3.9509634197361374`*^9}, {
  3.950977953418976*^9, 3.950977957923462*^9}, {3.9580405388255463`*^9, 
  3.958040554630615*^9}, {3.9580607112262344`*^9, 3.9580607173234673`*^9}, {
  3.976318949210018*^9, 3.9763190192513084`*^9}, {3.976319144351074*^9, 
  3.9763191745550117`*^9}, {3.9763192092799606`*^9, 3.9763192694289856`*^9}, {
  3.976319300039177*^9, 3.976319392264744*^9}, {3.9763194816762295`*^9, 
  3.9763194823942146`*^9}},ExpressionUUID->"e5392fa4-d75e-2447-9ade-\
9439520f1bc2"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ". Introduction"
}], "Chapter",
 CellChangeTimes->{{3.948474197281039*^9, 3.9484742191832757`*^9}, 
   3.948667339091866*^9, 3.951846391086569*^9, {3.9559389347591114`*^9, 
   3.955938939703206*^9}, {3.9576005867518435`*^9, 3.957600587400074*^9}},
 FontFamily->
  "Source Sans Pro",ExpressionUUID->"4689898b-bcc4-8d47-b73f-5dda26517944"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " in a nutshell"
}], "Section",
 CellChangeTimes->{{3.931836256197623*^9, 3.931836260320031*^9}, {
   3.932387704652485*^9, 3.932387709519918*^9}, {3.9324705520206637`*^9, 
   3.9324705540925975`*^9}, 3.948667313368092*^9, {3.9486673534793873`*^9, 
   3.9486673857120647`*^9}, {3.9488291406004486`*^9, 3.94882914092434*^9}, {
   3.9488293650752673`*^9, 3.948829366346679*^9}, {3.949770379934799*^9, 
   3.9497703829308033`*^9}, {3.9580710119607334`*^9, 
   3.9580710168895817`*^9}},ExpressionUUID->"7bd53d03-38c7-804d-add4-\
9bae71865db4"],

Cell[TextData[{
 "The package ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " deals with the Covariant Phase Space (CPS) formalism for field theories. ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " allows, among other things, to obtain from a given Lagrangian:\n  - the \
Equations of Motion (EOM)\n  - the canonical symplectic form\n  - check if a \
transformation is a symmetry \n  - find the Noether charge associated with a \
symmetry\n\nIt is worth noting that it can handles generic Lagrangians of the \
type L(tensors) such as f(Riem) theories.\n\n",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " implements two functionalities that might be of interest to a broader \
audience: \n  - checking if an expression is a divergence ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         SubscriptBox["\[Del]", 
          StyleBox["a", "TI"]], 
         SuperscriptBox[
          StyleBox["V", "TI"], 
          StyleBox["a", "TI"]]}], TraditionalForm], "errors" -> {}, "input" -> 
     "\\nabla_a V^a", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "531a4a36-e231-8f4e-a006-059d4ddb7bd1"],
 " \n  - obtain the \[OpenCurlyDoubleQuote]potential\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["T", "bc"], TraditionalForm]],ExpressionUUID->
  "a51af03a-1d01-c340-a125-2b4700c64057"],
 " of a gradient like ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Del]", "a"], 
    SuperscriptBox["T", "bc"]}], TraditionalForm]],ExpressionUUID->
  "33ab5efe-8f27-744d-ba8f-e0666aff8595"],
 "\n\nIf you found this package useful in one of your papers, please consider \
citing the companion papers:"
}], "Text",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
   3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
   3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
   3.949770545895968*^9, 3.949770826314764*^9}, {3.951846955332569*^9, 
   3.9518470362061768`*^9}, {3.9559388238406096`*^9, 
   3.9559388280772963`*^9}, {3.9564079601487474`*^9, 3.956407972157197*^9}, {
   3.9578196037398777`*^9, 3.957819611325901*^9}, {3.9578834648009677`*^9, 
   3.957883466160672*^9}, {3.9580406627768764`*^9, 3.958040683146511*^9}, {
   3.958060753671585*^9, 3.958060846736908*^9}, {3.958062657571989*^9, 
   3.9580626575729904`*^9}, {3.958062709571144*^9, 3.9580627206231194`*^9}, {
   3.95806333564719*^9, 3.9580633833561935`*^9}, {3.959499031523855*^9, 
   3.9594990452733383`*^9}, {3.959499077207979*^9, 3.959499094314167*^9}, {
   3.959499227916111*^9, 3.9594992511931305`*^9}, {3.959571553072998*^9, 
   3.9595715680803127`*^9}, 3.9760268709229984`*^9},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"279213df-4609-434d-a521-4d60c7f3b367"],

Cell[TextData[{
 StyleBox["xCPS: an xAct package for covariant phase space, Noether \
symmetries and Noether charges\n",
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],
 StyleBox["Juan Margalef-Bentabol ",
  FontColor->GrayLevel[0]],
 "\[LineSeparator]",
 ButtonBox["To appear soon on arXiv",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.arxiv.org"], None},
  ButtonNote->"https://www.arxiv.org"],
 " (see https://arxiv.org/a/margalefbentabol_j_1.html for updates)"
}], "Item",
 CellChangeTimes->{{3.9594991295151234`*^9, 3.9594991321088524`*^9}, {
  3.959499164145012*^9, 3.959499220725189*^9}, {3.959499271623537*^9, 
  3.9594993364453335`*^9}, {3.9606422218604584`*^9, 3.96064223524876*^9}, {
  3.9649575174734764`*^9, 3.964957522610153*^9}, {3.9760268796703815`*^9, 
  3.976026879677332*^9}, {3.9760294861578426`*^9, 3.976029505115181*^9}, {
  3.9763018327742577`*^9, 3.976301862059658*^9}, {3.9763187587538414`*^9, 
  3.976318762658388*^9}, {3.9763188031835365`*^9, 
  3.976318812120041*^9}},ExpressionUUID->"0ef9b99c-4f54-d24e-9f22-\
4038b103ee1d"],

Cell[TextData[{
 StyleBox["Geometric formulation of the covariant phase space methods with \
boundaries",
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],
 "\[LineSeparator]Juan Margalef-Bentabol and Eduardo J.\[ThinSpace]S. Villase\
\[NTilde]or\n",
 ButtonBox["Phys. Rev. D 103 (2021) 025011",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.1103/PhysRevD.103.025011"], None},
  ButtonNote->"https://doi.org/10.1103/PhysRevD.103.025011"],
 " [arXiv: ",
 ButtonBox["2008.01842",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://arxiv.org/abs/2008.01842"], None},
  ButtonNote->"http://arxiv.org/abs/2008.01842"],
 "]"
}], "Item",
 CellChangeTimes->{{3.9594991295151234`*^9, 3.9594991321088524`*^9}, {
   3.959499164145012*^9, 3.959499220725189*^9}, {3.959499271623537*^9, 
   3.9594993364453335`*^9}, {3.9606422218604584`*^9, 3.96064223524876*^9}, {
   3.9649575174734764`*^9, 3.964957522610153*^9}, 
   3.9760268801441517`*^9},ExpressionUUID->"875ba6dd-d42a-e740-8908-\
1ab487011c3f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Theoretical framework"
}], "Section",
 CellChangeTimes->{{3.931836256197623*^9, 3.931836260320031*^9}, {
   3.932387704652485*^9, 3.932387709519918*^9}, {3.9324705520206637`*^9, 
   3.9324705540925975`*^9}, 3.948667313368092*^9, {3.9486673534793873`*^9, 
   3.9486673857120647`*^9}, {3.9488291406004486`*^9, 3.94882914092434*^9}, {
   3.9488293650752673`*^9, 3.948829366346679*^9}, {3.949770379934799*^9, 
   3.9497703829308033`*^9}},ExpressionUUID->"ab17feac-a13f-6d40-aa81-\
b49db7f542fa"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Main references"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, {3.952090578281065*^9, 
   3.952090583466406*^9}, {3.952179421157341*^9, 3.952179421561249*^9}, {
   3.958070957622633*^9, 3.9580709602439976`*^9}, {3.9581441444114494`*^9, 
   3.958144179810545*^9}, {3.9581442154136086`*^9, 3.958144216506544*^9}, {
   3.9581442780629425`*^9, 
   3.95814427979212*^9}},ExpressionUUID->"7dd1459b-8528-874c-8fec-\
cf72581325e8"],

Cell[TextData[{
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " is mostly based in the theoretical work of one of the authors of the \
package:"
}], "Text",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
   3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
   3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
   3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
   3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, 
   3.9509775192205505`*^9, 3.958062689591984*^9, {3.9594990604666004`*^9, 
   3.9594990606475925`*^9}},ExpressionUUID->"b4eda17f-07cd-9a4f-a0c2-\
8dc13b1decb0"],

Cell[TextData[{
 StyleBox["Geometric formulation of the covariant phase space methods with \
boundaries",
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],
 "\[LineSeparator]Juan Margalef-Bentabol and Eduardo J.\[ThinSpace]S. Villase\
\[NTilde]or\n",
 ButtonBox["Phys. Rev. D 103 (2021) 025011",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.1103/PhysRevD.103.025011"], None},
  ButtonNote->"https://doi.org/10.1103/PhysRevD.103.025011"],
 " [arXiv: ",
 ButtonBox["2008.01842",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://arxiv.org/abs/2008.01842"], None},
  ButtonNote->"http://arxiv.org/abs/2008.01842"],
 "]"
}], "ItemNumbered",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
   3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
   3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
   3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
   3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
   3.950977521924591*^9, 3.9509775237641716`*^9}, 3.950978081507929*^9, {
   3.953990066254692*^9, 3.9539900710295143`*^9}},
 CellTags->
  "bibliography CPS \
JMB-EJSV",ExpressionUUID->"495c0799-ddde-aa47-99b7-971605993853"],

Cell["\<\
The underlying mathematical formalism of this paper is heavily influenced by \
\>", "Text",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
  3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
  3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
  3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
  3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
  3.950977526690504*^9, 3.9509775284765377`*^9}, {3.953989729642103*^9, 
  3.953989738993061*^9}, {3.958063399639223*^9, 
  3.958063402629835*^9}},ExpressionUUID->"489f6d49-a337-b748-be7e-\
c4a38d09dbd5"],

Cell[TextData[{
 StyleBox["The variational bicomplex",
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],
 "\nIan M. Anderson \n",
 ButtonBox["Utah State Technical Report (1989)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://ncatlab.org/nlab/files/AndersonVariationalBicomplex.pdf"], 
    None},
  ButtonNote->
   "https://ncatlab.org/nlab/files/AndersonVariationalBicomplex.pdf"]
}], "ItemNumbered",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
   3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
   3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
   3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
   3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
   3.950977530627178*^9, 3.9509775337548714`*^9}, {3.950978189782812*^9, 
   3.950978190409609*^9}, {3.9539900775896626`*^9, 3.9539900794279385`*^9}, {
   3.9539901997417545`*^9, 3.9539902106376686`*^9}, 3.954075381297758*^9},
 CellTags->
  "bibliography \
Anderson",ExpressionUUID->"a17b8aef-49c5-2e4a-bb09-c61a0f5c1b2e"],

Cell["\<\
We refer the reader to these two references and references therein for \
further mathematical details.\
\>", "Text",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
   3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
   3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
   3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
   3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
   3.950977537792919*^9, 3.95097755151503*^9}, {3.951847067043844*^9, 
   3.951847089289196*^9}, 3.9540755931707764`*^9, {3.9581443003586235`*^9, 
   3.9581443007442665`*^9}, {3.959499389981251*^9, 
   3.9594993989566994`*^9}},ExpressionUUID->"3aa52a10-e7d2-0845-9478-\
62dde0a115f0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Additional references"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, {3.952090578281065*^9, 
   3.952090583466406*^9}, {3.952179421157341*^9, 3.952179421561249*^9}, {
   3.958070957622633*^9, 3.9580709602439976`*^9}, {3.9581441444114494`*^9, 
   3.958144179810545*^9}, {3.9581442154136086`*^9, 3.958144216506544*^9}, {
   3.9581442780629425`*^9, 
   3.9581442976252995`*^9}},ExpressionUUID->"f5edd74b-8046-054e-85c9-\
c1bddecb9696"],

Cell["\<\
For additional context and examples, we suggest the following references:\
\>", "Text",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
   3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
   3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
   3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
   3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
   3.950977537792919*^9, 3.95097755151503*^9}, {3.951847067043844*^9, 
   3.951847089289196*^9}, 3.9540755931707764`*^9, 
   3.958144292216213*^9},ExpressionUUID->"eea57408-f238-ec4e-bcc8-\
fd1cb21fac5f"],

Cell[TextData[{
 StyleBox["Action principles and global geometry",
  FontWeight->"Bold"],
 "\[LineSeparator]Gregg J. Zuckerman\[LineSeparator]",
 ButtonBox["Mathematical aspects of string theory (1987) 259-284",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.1142/9789812798411_0013"], None},
  ButtonNote->"https://doi.org/10.1142/9789812798411_0013"]
}], "ItemNumbered",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
  3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
  3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
  3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
  3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
  3.950977537792919*^9, 3.950977557738796*^9}, {3.9539899390013523`*^9, 
  3.9539899595512543`*^9}, {3.9539900862122765`*^9, 3.9539900917314987`*^9}, {
  3.9539901257632504`*^9, 3.9539901257672386`*^9}},
 CounterAssignments->{{"ItemNumbered", 2}},
 CellTags->
  "bibliography \
Witten",ExpressionUUID->"a02ec1e0-767f-9848-93d4-7c823cca2111"],

Cell[TextData[{
 StyleBox["Covariant description of canonical formalism in geometrical \
theories\[LineSeparator]",
  FontWeight->"Bold"],
 "Cedomir Crnkovic and Edward Witten\[LineSeparator]",
 ButtonBox["Three hundred years of gravitation (1987) 676-684",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.ias.edu/sites/default/files/sns/files/CovariantPaper-\
1987.pdf"], None},
  ButtonNote->
   "https://www.ias.edu/sites/default/files/sns/files/CovariantPaper-1987.pdf"]
}], "ItemNumbered",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
  3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
  3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
  3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
  3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
  3.950977537792919*^9, 3.950977562962084*^9}, {3.953990157909912*^9, 
  3.953990215372757*^9}, {3.953990438058687*^9, 3.953990438063051*^9}},
 CellTags->
  "bibliography \
Zuckerberg",ExpressionUUID->"df972c59-05da-dc4a-8b8c-6820eeba80eb"],

Cell[TextData[{
 StyleBox["Proof of the equivalence of the symplectic forms derived from the \
canonical and the covariant phase space formalisms\n",
  FontWeight->"Bold"],
 "Juan Margalef-Bentabol and Eduardo J.S. Villase\[NTilde]or\n",
 ButtonBox["Phys. Rev. D Letters 106 (2022) 025011",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.1103/PhysRevD.105.L101701"], None},
  ButtonNote->"https://doi.org/10.1103/PhysRevD.105.L101701"],
 " [arXiv: ",
 ButtonBox["2204.06383",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://arxiv.org/abs/2204.06383"], None},
  ButtonNote->"http://arxiv.org/abs/2204.06383"],
 "]"
}], "ItemNumbered",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
  3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
  3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
  3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
  3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
  3.950977537792919*^9, 3.9509775965642242`*^9}, {3.9539905834653206`*^9, 
  3.953990612171673*^9}, {3.9539906499685974`*^9, 3.9539906873013077`*^9}, {
  3.9539908628455048`*^9, 3.9539908628499546`*^9}},
 CellTags->
  "bibliography juan Margalef and Eduardo J.S. \
Villase\[NTilde]or",ExpressionUUID->"be7e4d54-dceb-5446-9e3c-0466f839793d"],

Cell[TextData[{
 StyleBox["On the on-shell equivalence of general relativity and Holst \
theories with nonmetricity, torsion, and boundaries\n",
  FontWeight->"Bold"],
 "J. Fernando Barbero G., Juan Margalef-Bentabol, Valle Varo, and Eduardo \
J.S. Villase\[NTilde]or\n",
 ButtonBox["Phys. Rev. D 105 (2022) 064066",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.1103/PhysRevD.105.064066"], None},
  ButtonNote->"https://doi.org/10.1103/PhysRevD.105.064066"],
 " [arXiv: ",
 ButtonBox["2201.12141",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://arxiv.org/abs/2201.12141"], None},
  ButtonNote->"https://arxiv.org/abs/2201.12141"],
 "]"
}], "ItemNumbered",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
  3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
  3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
  3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
  3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
  3.950977537792919*^9, 3.9509775965642242`*^9}, {3.9539905834653206`*^9, 
  3.9539905931946335`*^9}, {3.9539906237886353`*^9, 3.953990630555748*^9}, {
  3.9539907009619293`*^9, 3.9539907482545433`*^9}, {3.9539908875606155`*^9, 
  3.953990903293932*^9}},ExpressionUUID->"bcbe0387-c99d-6e4a-a5bd-\
3031bc35941e"],

Cell[TextData[{
 StyleBox["Palatini gravity with nonmetricity, torsion, and boundaries in \
metric and connection variables\n",
  FontWeight->"Bold"],
 "Fernando Barbero G., Juan Margalef-Bentabol, Valle Varo, and Eduardo J.S. \
Villase\[NTilde]or\n",
 ButtonBox["Phys. Rev. D 104 (2021) 044046",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.1103/PhysRevD.104.044046"], None},
  ButtonNote->"https://doi.org/10.1103/PhysRevD.104.044046"],
 " [arXiv: ",
 ButtonBox["2105.07053",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://arxiv.org/abs/2105.07053"], None},
  ButtonNote->"http://arxiv.org/abs/2105.07053"],
 "]"
}], "ItemNumbered",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
  3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
  3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
  3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
  3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
  3.950977537792919*^9, 3.9509775965642242`*^9}, {3.9539905834653206`*^9, 
  3.953990594888029*^9}, {3.9539906288435097`*^9, 3.953990629057625*^9}, {
  3.953990932809305*^9, 
  3.953990961117708*^9}},ExpressionUUID->"b1893621-8bd4-9c40-a20e-\
f636e19c4b43"],

Cell[TextData[{
 StyleBox["Covariant phase space for gravity with boundaries: metric vs \
tetrad formulations\n",
  FontWeight->"Bold"],
 "J. Fernando Barbero G., Juan Margalef-Bentabol, Valle Varo, and Eduardo \
J.S. Villase\[NTilde]or\n",
 ButtonBox["Phys. Rev. D 104 (2021) 044048",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.1103/PhysRevD.104.044048"], None},
  ButtonNote->"https://doi.org/10.1103/PhysRevD.104.044048"],
 " [arXiv: ",
 ButtonBox["2103.06362",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://arxiv.org/abs/2103.06362"], None},
  ButtonNote->"http://arxiv.org/abs/2103.06362"],
 "]"
}], "ItemNumbered",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
  3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
  3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
  3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
  3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
  3.950977537792919*^9, 3.9509775965642242`*^9}, {3.9539905834653206`*^9, 
  3.9539905911754665`*^9}, {3.9539906327024593`*^9, 3.9539906329088326`*^9}, {
  3.9539909738601*^9, 3.953991004470892*^9}, {3.953991041861017*^9, 
  3.95399106638122*^9}},
 CellTags->
  "bibliography Covariant Phase space for gravity with \
boundaries...",ExpressionUUID->"09aa4411-8f6c-c544-be38-a98d967fccce"],

Cell[TextData[{
 StyleBox["Some Properties of Noether Charge and a Proposal for Dynamical \
Black Hole Entropy\n",
  FontWeight->"Bold"],
 "Vivek Iyer and Robert M. Wald\[LineSeparator]",
 ButtonBox["Phys. Rev. D 50 (1994) 846",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://doi.org/10.1103/PhysRevD.50.846"], None},
  ButtonNote->"https://doi.org/10.1103/PhysRevD.50.846"],
 " \.08[arXiv: ",
 ButtonBox["gr-qc/9403028",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://arxiv.org/abs/gr-qc/9403028"], None},
  ButtonNote->"https://arxiv.org/abs/gr-qc/9403028"],
 "]"
}], "ItemNumbered",
 CellChangeTimes->{{3.94977007838846*^9, 3.94977011388816*^9}, {
  3.949770161720898*^9, 3.949770327832867*^9}, {3.949770358527151*^9, 
  3.949770358531155*^9}, {3.949770449247404*^9, 3.949770460193348*^9}, {
  3.949770545895968*^9, 3.949770858289337*^9}, {3.950048829650112*^9, 
  3.950048833547798*^9}, {3.9509695035527534`*^9, 3.950969513713772*^9}, {
  3.950977537792919*^9, 3.9509776030184536`*^9}, {3.9539904413439884`*^9, 
  3.953990441597561*^9}, {3.9539910913535767`*^9, 3.9539911600100136`*^9}},
 CellTags->
  "bibliography Wald",ExpressionUUID->"3e13442a-adeb-4745-80ad-901f0428fc13"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Implementation in Mathematica"
}], "Section",
 CellChangeTimes->{{3.931836256197623*^9, 3.931836260320031*^9}, {
   3.932387704652485*^9, 3.932387709519918*^9}, {3.9324705520206637`*^9, 
   3.9324705540925975`*^9}, 3.948667313368092*^9, {3.9486673534793873`*^9, 
   3.9486673857120647`*^9}, {3.9488291406004486`*^9, 3.94882914092434*^9}, {
   3.9488293650752673`*^9, 3.948829366346679*^9}, {3.949770379934799*^9, 
   3.949770395385687*^9}},ExpressionUUID->"b1ee5d29-19c8-854d-806b-\
da9fd4a6b804"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Motivation of ",
 StyleBox["xCPS ",
  FontWeight->"Bold"],
 "and how to read this notebook"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, {3.952090578281065*^9, 
   3.952090583466406*^9}, {3.952179421157341*^9, 3.952179421561249*^9}, {
   3.958070957622633*^9, 3.9580709602439976`*^9}, {3.9581441444114494`*^9, 
   3.958144179810545*^9}, {3.9581442154136086`*^9, 3.9581442415185814`*^9}, {
   3.9649603188320007`*^9, 
   3.9649603224967327`*^9}},ExpressionUUID->"cd0b2032-86ad-5f4f-88b4-\
b2331c553e42"],

Cell[TextData[{
 "This package originated with the idea of using ",
 StyleBox["xPert",
  FontWeight->"Bold"],
 " to implement the Covariant Phase Space formalism. However, the need to \
include a super-commutative product made necessary further adaptations \
similar to the ones introduced in ",
 StyleBox["xTerior",
  FontWeight->"Bold"],
 ". Thus, some of the core parts of ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " owe much to ",
 StyleBox["xTerior",
  FontWeight->"Bold"],
 " and ",
 StyleBox["xPert",
  FontWeight->"Bold"],
 ".\n\nWe recommend to those readers only interested in the field theory \
examples to check the following Chapters:"
}], "Text",
 CellChangeTimes->{{3.94977039822262*^9, 3.9497704447218*^9}, {
   3.949770477761797*^9, 3.9497705355045776`*^9}, {3.949770870290058*^9, 
   3.949770916985428*^9}, 3.9544803104668655`*^9, 3.9553442911510286`*^9, {
   3.95593886040711*^9, 3.9559388790127935`*^9}, {3.95671954402781*^9, 
   3.956719547367021*^9}, {3.9575868785559826`*^9, 3.957586917657096*^9}, {
   3.957604707741473*^9, 3.9576047488416595`*^9}, {3.957887032224831*^9, 
   3.957887034651368*^9}, {3.9579549890855427`*^9, 3.957954989969658*^9}, 
   3.957955031320382*^9, {3.957955118761829*^9, 3.9579551412870665`*^9}, 
   3.958040698444664*^9, 3.9580605956336136`*^9, {3.958060646861353*^9, 
   3.9580606687441864`*^9}, {3.9580627707509594`*^9, 3.958062833093012*^9}, {
   3.9580628752938538`*^9, 3.9580628752998486`*^9}, 3.9580634282222576`*^9, {
   3.9581442238515644`*^9, 3.958144224322977*^9}, {3.9592274220633965`*^9, 
   3.9592274225274563`*^9}, {3.959499515153063*^9, 
   3.959499515633381*^9}},ExpressionUUID->"f298f387-c7de-2644-b0d9-\
2f8fd3e16e95"],

Cell[TextData[{
 "Chapter ",
 StyleBox[
 CounterBox["Chapter", "Chapter Initial examples out of the box"],
  FontColor->RGBColor[0., 0., 1.]],
 ": a quick study of the scalar field and General Relativity (GR) "
}], "Item",
 CellChangeTimes->{{3.953086561057642*^9, 3.953086565607498*^9}, {
   3.9574432082120237`*^9, 3.9574432088121257`*^9}, {3.9578201109097633`*^9, 
   3.9578201141454716`*^9}, {3.9580813691748486`*^9, 3.95808148667029*^9}, {
   3.9580815199095306`*^9, 3.9580815203896103`*^9}, {3.958081556604355*^9, 
   3.9580817892528934`*^9}, {3.9580820108644924`*^9, 3.958082069636711*^9}, {
   3.9580821231512012`*^9, 3.9580821304782104`*^9}, {3.9580821632480793`*^9, 
   3.958082177820572*^9}, 3.958082242876047*^9, {3.95808231128553*^9, 
   3.9580824072027016`*^9}, 3.9592274291864414`*^9, {3.959228462715294*^9, 
   3.959228465496395*^9}, 3.959228545258934*^9, {3.959228621148407*^9, 
   3.959228673819666*^9}, {3.9592287802658157`*^9, 3.959228781533886*^9}, 
   3.959501060765211*^9},ExpressionUUID->"f9714716-741d-3d4d-b574-\
47210cddff34"],

Cell[TextData[{
 "Chapter ",
 StyleBox[
 CounterBox["Chapter", "Chapter scalar field"],
  FontColor->RGBColor[0., 0., 1.]],
 ": a detail study of the scalar field"
}], "Item",
 CellChangeTimes->{{3.953086561057642*^9, 3.953086565607498*^9}, {
   3.9574432082120237`*^9, 3.9574432088121257`*^9}, {3.9578201109097633`*^9, 
   3.9578201141454716`*^9}, {3.9580813691748486`*^9, 3.95808148667029*^9}, {
   3.9580815199095306`*^9, 3.9580815203896103`*^9}, {3.958081556604355*^9, 
   3.9580817892528934`*^9}, {3.9580820108644924`*^9, 3.958082069636711*^9}, {
   3.9580821231512012`*^9, 3.9580821304782104`*^9}, {3.9580821632480793`*^9, 
   3.958082177820572*^9}, 3.958082242876047*^9, {3.95808231128553*^9, 
   3.9580824072027016`*^9}, 3.9592274291864414`*^9, {3.959228462715294*^9, 
   3.959228465496395*^9}, 
   3.959501065805422*^9},ExpressionUUID->"385c7b1a-5174-8547-9648-\
d7d20fd18f29"],

Cell[TextData[{
 "Chapter ",
 StyleBox[
 CounterBox["Chapter", "Chapter Electromag"],
  FontColor->RGBColor[0., 0., 1.]],
 ": a detail study of the electromagnetic theory"
}], "Item",
 CellChangeTimes->{{3.953086561057642*^9, 3.953086565607498*^9}, {
   3.9574432082120237`*^9, 3.9574432088121257`*^9}, {3.9578201109097633`*^9, 
   3.9578201141454716`*^9}, {3.9580813691748486`*^9, 3.95808148667029*^9}, {
   3.9580815199095306`*^9, 3.9580815203896103`*^9}, {3.958081556604355*^9, 
   3.9580817892528934`*^9}, {3.9580820108644924`*^9, 3.958082069636711*^9}, {
   3.9580821231512012`*^9, 3.9580821304782104`*^9}, {3.9580821632480793`*^9, 
   3.958082177820572*^9}, 3.958082242876047*^9, {3.95808231128553*^9, 
   3.95808240639612*^9}, {3.9592284694192104`*^9, 3.959228478313486*^9}, 
   3.9595010695999603`*^9},ExpressionUUID->"a7ff9f1b-76fe-3c4a-a2e1-\
8df9718cf7ca"],

Cell[TextData[{
 "Chapter ",
 StyleBox[
 CounterBox["Chapter", "Chapter GR"],
  FontColor->RGBColor[0., 0., 1.]],
 ": a detail study of GR"
}], "Item",
 CellChangeTimes->{{3.953086561057642*^9, 3.953086565607498*^9}, {
   3.9574432082120237`*^9, 3.9574432088121257`*^9}, {3.9578201109097633`*^9, 
   3.9578201141454716`*^9}, {3.9580813691748486`*^9, 3.95808148667029*^9}, {
   3.9580815199095306`*^9, 3.9580815203896103`*^9}, {3.958081556604355*^9, 
   3.9580817892528934`*^9}, {3.9580820108644924`*^9, 3.958082069636711*^9}, {
   3.9580821231512012`*^9, 3.9580821304782104`*^9}, {3.9580821632480793`*^9, 
   3.958082177820572*^9}, 3.958082242876047*^9, {3.95808231128553*^9, 
   3.9580824055321217`*^9}, {3.959228482474329*^9, 3.9592284894880466`*^9}, {
   3.959228785358118*^9, 3.9592287854363365`*^9}, 
   3.9595010742378807`*^9},ExpressionUUID->"f1724989-1d87-1141-9b5f-\
a6c975f75481"],

Cell[TextData[{
 "Chapter ",
 StyleBox[
 CounterBox["Chapter", "Chapter generic lagrangians"],
  FontColor->RGBColor[0., 0., 1.]],
 ": a detail study of generic f(Riem), f(Ric), and f(R) theories"
}], "Item",
 CellChangeTimes->{{3.953086561057642*^9, 3.953086565607498*^9}, {
   3.9574432082120237`*^9, 3.9574432088121257`*^9}, {3.9578201109097633`*^9, 
   3.9578201141454716`*^9}, {3.9580813691748486`*^9, 3.95808148667029*^9}, {
   3.9580815199095306`*^9, 3.9580815203896103`*^9}, {3.958081556604355*^9, 
   3.9580817892528934`*^9}, {3.9580820108644924`*^9, 3.958082069636711*^9}, {
   3.9580821231512012`*^9, 3.9580821304782104`*^9}, {3.9580821632480793`*^9, 
   3.958082177820572*^9}, 3.958082242876047*^9, {3.95808231128553*^9, 
   3.9580824032199306`*^9}, {3.959227348997877*^9, 3.9592273613409843`*^9}, {
   3.9592284951845684`*^9, 3.959228496722103*^9}, 
   3.9595010785182037`*^9},ExpressionUUID->"cafa4376-e98b-2743-a2d0-\
a4e8a44a9cb3"],

Cell[TextData[{
 "Additionally, Chapter ",
 StyleBox[
 CounterBox["Chapter", "chapter basic definitions"],
  FontColor->RGBColor[0., 0., 1.]],
 " provides an introduction to some of the basic commands of the package.\n\n\
Chapters ",
 StyleBox[
 CounterBox["Chapter", "Chapter xCPS covd and metrics"],
  FontColor->RGBColor[0., 0., 1.]],
 "-",
 StyleBox[
 CounterBox["Chapter", "Chapter variational relation"],
  FontColor->RGBColor[0., 0., 1.]],
 ", together with the Appendix, contain more technical details. These \
sections are intended for readers who wish to explore the finer aspects of \
the package or apply it to more involved examples."
}], "Text",
 CellChangeTimes->{{3.94977039822262*^9, 3.9497704447218*^9}, {
   3.949770477761797*^9, 3.9497705355045776`*^9}, {3.949770870290058*^9, 
   3.949770916985428*^9}, 3.9544803104668655`*^9, 3.9553442911510286`*^9, {
   3.95593886040711*^9, 3.9559388790127935`*^9}, {3.95671954402781*^9, 
   3.956719547367021*^9}, {3.9575868785559826`*^9, 3.957586917657096*^9}, {
   3.957604707741473*^9, 3.9576047488416595`*^9}, {3.957887032224831*^9, 
   3.957887034651368*^9}, {3.9579549890855427`*^9, 3.957954989969658*^9}, 
   3.957955031320382*^9, {3.957955118761829*^9, 3.9579551412870665`*^9}, 
   3.958040698444664*^9, 3.9580605956336136`*^9, {3.958060646861353*^9, 
   3.9580606687441864`*^9}, {3.9580627707509594`*^9, 3.958062833093012*^9}, {
   3.9580628752938538`*^9, 3.9580628752998486`*^9}, 3.9580634282222576`*^9, {
   3.9581442238515644`*^9, 3.958144224322977*^9}, {3.9592274220633965`*^9, 
   3.9592274225274563`*^9}, {3.959499515153063*^9, 3.959499515633381*^9}, {
   3.9649575625344334`*^9, 3.9649575658047447`*^9}, {3.9649576543119183`*^9, 
   3.9649576646964684`*^9}, {3.9649603387553654`*^9, 
   3.9649603710263424`*^9}, {3.9649604321387577`*^9, 
   3.9649604334458523`*^9}, {3.964960471123068*^9, 
   3.96496057425494*^9}},ExpressionUUID->"4f15372d-4ccf-a44a-b82c-\
c84e37625be3"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Installing ",
 StyleBox["xCPS",
  FontWeight->"Bold"]
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, {3.952090578281065*^9, 
   3.952090583466406*^9}, {3.952179421157341*^9, 3.952179421561249*^9}, {
   3.958070957622633*^9, 3.9580709602439976`*^9}, {3.9581441444114494`*^9, 
   3.958144179810545*^9}, {3.9581442154136086`*^9, 
   3.958144216506544*^9}},ExpressionUUID->"8d8aeb79-7e4a-0f4e-8896-\
959e3b14e8af"],

Cell[TextData[{
 "For instructions on how to install ",
 StyleBox["xAct",
  FontWeight->"Bold"],
 " and ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 ", see Appendix ",
 StyleBox[ButtonBox["A.",
  BaseStyle->"Hyperlink",
  ButtonData->"Section Ap How to Install xCPS"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Section Ap How to Install xCPS"],
  FontColor->RGBColor[0., 0., 1.]],
 "."
}], "Text",
 CellChangeTimes->{{3.94977039822262*^9, 3.9497704447218*^9}, {
   3.949770477761797*^9, 3.9497705355045776`*^9}, {3.949770870290058*^9, 
   3.949770916985428*^9}, 3.9544803104668655`*^9, 3.9553442911510286`*^9, {
   3.95593886040711*^9, 3.9559388790127935`*^9}, {3.95671954402781*^9, 
   3.956719547367021*^9}, {3.9575868785559826`*^9, 3.957586917657096*^9}, {
   3.957604707741473*^9, 3.9576047488416595`*^9}, {3.957887032224831*^9, 
   3.957887034651368*^9}, {3.9579549890855427`*^9, 3.957954989969658*^9}, 
   3.957955031320382*^9, {3.957955118761829*^9, 3.9579551412870665`*^9}, 
   3.958040698444664*^9, 3.9580605956336136`*^9, {3.958060646861353*^9, 
   3.9580606687441864`*^9}, {3.9580627707509594`*^9, 3.958062833093012*^9}, {
   3.9580628752938538`*^9, 3.9580628752998486`*^9}, 3.9580634282222576`*^9, {
   3.9581442214629955`*^9, 3.9581442219087524`*^9}, {3.959501047581814*^9, 
   3.95950105629068*^9}},ExpressionUUID->"bbdd0ea1-f5d0-6f44-8e60-\
fbd1d343e0a7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Loading ",
 StyleBox["xCPS",
  FontWeight->"Bold"]
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, {3.952090578281065*^9, 
   3.952090583466406*^9}, {3.952179421157341*^9, 3.952179421561249*^9}, {
   3.958070957622633*^9, 3.9580709602439976`*^9}, {3.9581441444114494`*^9, 
   3.958144179810545*^9}},ExpressionUUID->"9f012273-d8c9-c143-b35b-\
0b4dac42fda6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n"}], "\n", 
 RowBox[{"<<", "xAct`xCPS`"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], ";"}], "\n", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "options", " ", "for", " ", "ContractMetric"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ContractMetric", ",", 
    RowBox[{"AllowUpperDerivatives", " ", "->", " ", "True"}]}], "]"}], 
  ";"}]}], "Code",
 CellChangeTimes->{{3.951846403762476*^9, 3.9518464085877724`*^9}, {
   3.951846444411316*^9, 3.951846457731598*^9}, {3.95184652648419*^9, 
   3.9518465266634197`*^9}, {3.9518471012644463`*^9, 
   3.9518471156435394`*^9}, {3.9518497734808083`*^9, 
   3.9518497742960434`*^9}, {3.9518537008889065`*^9, 
   3.9518537123368473`*^9}, {3.9518542670810184`*^9, 
   3.9518542731546555`*^9}, {3.951860138714121*^9, 3.951860139336275*^9}, {
   3.9518601914163857`*^9, 3.9518601916021557`*^9}, {3.9521193812897434`*^9, 
   3.952119381951744*^9}, {3.952119442730276*^9, 3.9521194429973354`*^9}, {
   3.9522050913946075`*^9, 3.952205092730978*^9}, {3.952205198990635*^9, 
   3.952205199489151*^9}, {3.953834144818712*^9, 3.953834146440634*^9}, {
   3.9540026417098637`*^9, 3.954002642446699*^9}, 3.955191545632015*^9, {
   3.963934161302376*^9, 3.9639341782221794`*^9}, {3.9639342266359367`*^9, 
   3.9639342289986286`*^9}, {3.963934634216177*^9, 3.963934653331564*^9}, {
   3.96393469320343*^9, 3.9639347136442394`*^9}, {3.9639347477696495`*^9, 
   3.9639348018179684`*^9}, 3.976300371860409*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"ffa41724-5d8b-2842-a2b0-feda490acee2"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.976301788361601*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7f9fcf1d-1b78-1846-9f3a-4e99af050018"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.4", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.976301788382597*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3c26d04e-aef1-6f44-9422-7a09bc6ac466"],

Cell[BoxData["\<\"CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.9763017884046*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"2dfb8b52-f5c8-dc4e-a1f5-c4343efd9792"],

Cell[BoxData["\<\"Connecting to external MinGW executable...\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.9763017886094704`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"633a72b4-493a-764d-bf51-f0968c17852c"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.976301788820614*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ad237df1-c70d-8c44-b026-c07af148c9cd"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.9763017888491726`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"fa7e1474-37ef-1d4c-af10-7af6667a8b02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor` version \"\>", 
   "\[InvisibleSpace]", "\<\"1.3.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor` version ", "1.3.0", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.976301788890415*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"cd0ca7fb-adba-3742-91b8-957c11b32cbb"],

Cell[BoxData["\<\"CopyRight (C) 2002-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.9763017889154205`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6e9cf254-deb8-344d-9259-43574355837c"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.9763017892009144`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3bad6ffd-3ada-674e-887a-54d1dcd71940"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCPS` version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "31", ",", "12"}], "}"}]}],
  SequenceForm["Package xAct`xCPS` version ", "1.0.1", ", ", {2025, 31, 12}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.9763017892219048`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"79728e15-b0b7-5540-a968-99766fea8364"],

Cell[BoxData["\<\"CopyRight (C) 2025, Juan Margalef-Bentabol and Laura S\
\[AAcute]nchez Cotta, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.976301789241907*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"4b3e1712-0b52-064c-90bf-6bb9a904a964"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.9763017892624645`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0368101c-cddd-9349-8b9d-c33ea0b81180"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.97630178928146*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"99947787-a699-b746-a4f0-789d9188ef15"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.9602929636241817`*^9, 3.960296431103174*^9, 3.9602970676550846`*^9, 
   3.9602979885883656`*^9, 3.960298026626154*^9, 3.9603002991630096`*^9, 
   3.9603530337141685`*^9, 3.9603532044170113`*^9, 3.9603534000571575`*^9, 
   3.960358222227892*^9, 3.9603583285608845`*^9, 3.9603585065547104`*^9, 
   3.9603586911198044`*^9, 3.9603588695508823`*^9, 3.960359121717327*^9, 
   3.960359175894676*^9, 3.9603593970207806`*^9, 3.960359656825865*^9, 
   3.9603609037561817`*^9, 3.9603609930816727`*^9, 3.9603611564842567`*^9, 
   3.960364674353039*^9, 3.96036480929204*^9, 3.9603659734223995`*^9, 
   3.960366031580427*^9, 3.9603661115251656`*^9, 3.9603661831295624`*^9, 
   3.9603662818491898`*^9, 3.960366414948366*^9, 3.9603664937912045`*^9, 
   3.9603665438633423`*^9, 3.9603669402924576`*^9, 3.960367137194807*^9, 
   3.9603672783020344`*^9, 3.960367413040846*^9, 3.9603674609606247`*^9, 
   3.9603675113365116`*^9, 3.960367577652487*^9, 3.9603677373185463`*^9, 
   3.9603678790806274`*^9, 3.96036808932983*^9, 3.9603681559035416`*^9, 
   3.960368277417244*^9, 3.960368548103611*^9, 3.960378112076433*^9, 
   3.960467959886009*^9, 3.960468006368679*^9, 3.9604685861250916`*^9, 
   3.960482573135397*^9, 3.9604834699485817`*^9, 3.96048360681522*^9, 
   3.9604837047450485`*^9, 3.9604837378624363`*^9, 3.9604844288039684`*^9, 
   3.960485287667206*^9, 3.9604855282155647`*^9, 3.9604860225341835`*^9, 
   3.960486280921999*^9, 3.9604863580611057`*^9, 3.9604864121046085`*^9, 
   3.9604864700337715`*^9, 3.9604865472640343`*^9, {3.9604866057175636`*^9, 
   3.96048663526511*^9}, 3.960486690106415*^9, 3.9604867381592045`*^9, 
   3.9604868230034866`*^9, 3.9604869798739624`*^9, 3.9604873273031025`*^9, 
   3.960487421592661*^9, 3.960487472237509*^9, 3.9605215184465523`*^9, 
   3.960521707353409*^9, 3.960521758285902*^9, 3.960521905427372*^9, 
   3.9605228639621334`*^9, 3.960522981710842*^9, 3.960524551233202*^9, 
   3.9605248425313473`*^9, 3.960524949326584*^9, 3.9605250857044106`*^9, 
   3.960525142579321*^9, 3.960525205836241*^9, 3.9605252626781654`*^9, 
   3.9605258696233253`*^9, 3.960526038282593*^9, 3.9605261329547997`*^9, 
   3.9605262152991753`*^9, 3.960526427280697*^9, 3.960526563952482*^9, 
   3.960527345022154*^9, 3.9605283744119453`*^9, 3.9605284395784264`*^9, 
   3.960528831510729*^9, 3.960528930516163*^9, 3.9605290237767467`*^9, 
   3.9605296011158104`*^9, 3.960529863926544*^9, 3.9605299334679127`*^9, 
   3.9605301716208076`*^9, 3.960531006405546*^9, 3.9605312016035404`*^9, 
   3.960531706995178*^9, 3.9605322937305756`*^9, 3.9605327856630344`*^9, 
   3.960533676530464*^9, 3.960533750334463*^9, 3.960534162975399*^9, 
   3.96053446632489*^9, 3.960538005732233*^9, 3.9605402991480484`*^9, 
   3.960540520813223*^9, 3.960540618072872*^9, {3.960540773932934*^9, 
   3.960540801939518*^9}, 3.960541343614998*^9, 3.9605413952550526`*^9, 
   3.9605417986242313`*^9, 3.960541961099249*^9, 3.9605420076043777`*^9, 
   3.960542055110998*^9, 3.960542143802353*^9, {3.960542281057419*^9, 
   3.960542299423897*^9}, {3.960542745791601*^9, 3.9605427744660435`*^9}, 
   3.9605431349924107`*^9, 3.9605432559423294`*^9, 3.960543309715372*^9, 
   3.9605433825967903`*^9, 3.9605434406539*^9, 3.960543476078167*^9, 
   3.960543568328972*^9, 3.960543811304268*^9, 3.9605442057403107`*^9, 
   3.960546549864376*^9, 3.9605467338270473`*^9, 3.9605471756311607`*^9, 
   3.9605473343450565`*^9, 3.9605474600731907`*^9, 3.960555206437372*^9, 
   3.9605555476446323`*^9, 3.960555635838995*^9, 3.960556092868046*^9, 
   3.9605563501046467`*^9, 3.96055646702149*^9, 3.9605568125974503`*^9, 
   3.9606074094756413`*^9, 3.9606079812848263`*^9, 3.960608258747923*^9, 
   3.9606084431297665`*^9, 3.960608520900917*^9, 3.9606087575953026`*^9, 
   3.960608838401392*^9, 3.960608909491804*^9, 3.960608990023794*^9, 
   3.9606090768301735`*^9, 3.9606091853830376`*^9, 3.960609949956793*^9, 
   3.960610040477291*^9, 3.9606101354094067`*^9, 3.9606102077847843`*^9, 
   3.96061031450679*^9, 3.9606103578659554`*^9, 3.960610464968689*^9, 
   3.9606106880494976`*^9, 3.960610737953972*^9, 3.9606107694621353`*^9, 
   3.960610828077734*^9, 3.9606109065838776`*^9, 3.960610994303028*^9, 
   3.9606110429123077`*^9, 3.960611191313402*^9, {3.9606124751381836`*^9, 
   3.960612494317871*^9}, 3.9606128383701096`*^9, 3.960612887756735*^9, 
   3.960612948569132*^9, 3.9606130379027653`*^9, 3.960613100645666*^9, 
   3.960613161642622*^9, 3.960613275417095*^9, 3.96061335288463*^9, {
   3.960613384671604*^9, 3.960613413666172*^9}, 3.960613450039358*^9, 
   3.960613498510027*^9, 3.9606136004441986`*^9, 3.9606178060746746`*^9, 
   3.9606187083837223`*^9, 3.9606187588271523`*^9, 3.960619085747761*^9, 
   3.9606192004579105`*^9, 3.960626795912739*^9, 3.9606272826687737`*^9, 
   3.960627516201437*^9, 3.960628098400202*^9, 3.9606291911518116`*^9, 
   3.960629560566883*^9, 3.960629989565878*^9, 3.9606301811426544`*^9, 
   3.960630430343853*^9, {3.9606306785868835`*^9, 3.9606307081087666`*^9}, 
   3.960630768642681*^9, 3.9606310686895638`*^9, 3.960631832371319*^9, 
   3.960631976718546*^9, 3.9606320817312336`*^9, 3.960633772697796*^9, 
   3.9606384708562927`*^9, 3.9606415921113567`*^9, 3.96064285289686*^9, 
   3.9639340017717094`*^9, 3.9639340331974144`*^9, 3.9639342475368443`*^9, 
   3.963934707333599*^9, {3.9639347396480103`*^9, 3.9639347436643353`*^9}, 
   3.9639347754710903`*^9, 3.963934825707594*^9, 3.9639356955884457`*^9, 
   3.963936183081789*^9, 3.9639367010279217`*^9, 3.963937342061695*^9, 
   3.963939995998417*^9, 3.9639400633763103`*^9, 3.963940250168783*^9, 
   3.963940442484232*^9, 3.96394086075823*^9, 3.963941182806633*^9, 
   3.9639414040700855`*^9, 3.963942045950796*^9, 3.9639421670144844`*^9, 
   3.963942573159191*^9, 3.963942615895462*^9, 3.963942721675659*^9, 
   3.963942868237652*^9, 3.963942918946665*^9, 3.9639430515455894`*^9, 
   3.963943697445921*^9, 3.9639437476213627`*^9, 3.963943835663908*^9, 
   3.9639441128156757`*^9, 3.9639490836081467`*^9, 3.963949229981531*^9, 
   3.963949337388933*^9, 3.9639494478112717`*^9, 3.9639495339913635`*^9, 
   3.96394972571706*^9, 3.963949871823267*^9, 3.963949985032528*^9, 
   3.963950068768383*^9, 3.963950144000473*^9, 3.9639502875100193`*^9, 
   3.9639503864294376`*^9, 3.9639508439965916`*^9, 3.963950958852024*^9, 
   3.9639510908925*^9, 3.963951214901249*^9, 3.963951369382084*^9, 
   3.9639517176161175`*^9, 3.9639518094850903`*^9, 3.963951917506033*^9, 
   3.963952011931841*^9, 3.9639521167452087`*^9, 3.963952240416416*^9, 
   3.963952285290951*^9, 3.9639523989287148`*^9, 3.9639525662153816`*^9, 
   3.963952648831316*^9, 3.9639527001503887`*^9, 3.9639531269882145`*^9, 
   3.9639532244851055`*^9, 3.963953342403536*^9, 3.9639534312943935`*^9, 
   3.963953702305193*^9, 3.9639537503079033`*^9, 3.963954465142338*^9, 
   3.9639574486632767`*^9, 3.9639576898767548`*^9, 3.976300703123205*^9, 
   3.9763017216286583`*^9, 3.9763017893045444`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"001ed8e3-4282-4a4b-bd69-4a6d7e7d20e4"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Lists of ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " commands"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, {3.952090578281065*^9, 
   3.952090583466406*^9}, {3.952179421157341*^9, 3.952179421561249*^9}, {
   3.958070957622633*^9, 3.9580709602439976`*^9}, {3.9581441444114494`*^9, 
   3.9581441474684715`*^9}, {3.9581442011305065`*^9, 
   3.9581442060348377`*^9}},ExpressionUUID->"36c978fe-d78e-b443-a63c-\
e6955bb29cb6"],

Cell[TextData[{
 "The functions defined by ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " are the following:"
}], "Text",
 CellChangeTimes->{{3.94977039822262*^9, 3.9497704447218*^9}, {
   3.949770477761797*^9, 3.9497705355045776`*^9}, {3.949770870290058*^9, 
   3.949770916985428*^9}, {3.9575460539729958`*^9, 3.95754612509478*^9}, 
   3.9575868459507303`*^9, {3.9580629842288074`*^9, 3.9580629871463814`*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"adff1229-5665-5443-bc1c-285ae1d6ea18"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "xAct`xCPS`Private`FunctionsxCPS", 
  "]"}]], "Input",
 CellChangeTimes->{{3.956489740919052*^9, 3.956489756818516*^9}, 
   3.956489913121231*^9, 3.9564910220520935`*^9, {3.956491210149376*^9, 
   3.9564912134568005`*^9}, {3.9564942805660763`*^9, 3.9564942817764072`*^9}},
 FontFamily->"Consolas",
 CellLabel->"In[6]:=",ExpressionUUID->"b5b39043-2fbb-e34e-8386-a4b905e15266"],

Cell[BoxData[
 StyleBox[
  FrameBox[GridBox[{
     {
      DynamicModuleBox[{Typeset`open$$ = True}, 
       PaneSelectorBox[{False->
        ButtonBox[
         RowBox[{
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "RightPointerOpener"]], " ", 
          StyleBox["xAct`xCPS`", "InformationGridGroupHeader"]}],
         Appearance->None,
         BaseStyle->"InformationGridLink",
         ButtonFunction:>FEPrivate`Set[Typeset`open$$, True],
         Evaluator->Automatic,
         Method->"Preemptive"], True->
        PaneBox[GridBox[{
           {
            ButtonBox[
             RowBox[{
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {2.134033203125, 7.865966796875}}], " ", 
              StyleBox["xAct`xCPS`", "InformationGridGroupHeader"]}],
             Appearance->None,
             BaseStyle->"InformationGridLink",
             ButtonFunction:>FEPrivate`Set[Typeset`open$$, False],
             Evaluator->Automatic,
             Method->"Preemptive"]},
           {
            PaneBox[GridBox[{
               {
                ButtonBox[
                 StyleBox["\:2a55", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "\:2a55", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["EOM", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "EOM", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NoetherSymmetryQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "NoetherSymmetryQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SortVertOperators", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "SortVertOperators", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VariationalVector", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VariationalVector", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["AddVariationalRelation", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "AddVariationalRelation", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["EOMOf1Form", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "EOMOf1Form", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NonZeroVertDegQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "NonZeroVertDegQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SymplecticCurrent", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "SymplecticCurrent", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VariationalVectorQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VariationalVectorQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CoefficientsOfVVF", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "CoefficientsOfVVF", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ExpandVertDiff", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "ExpandVertDiff", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NormalOfCovD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "NormalOfCovD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SymplecticCurrentOf1Form", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "SymplecticCurrentOf1Form", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertBracket", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VertBracket", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 
                 StyleBox["ComponentsOfGeneralizedVVF", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "ComponentsOfGeneralizedVVF", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ExpandVertInt", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "ExpandVertInt", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NormalOfCovDQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "NormalOfCovDQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SymplecticPotential", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "SymplecticPotential", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertBracketToVertLie", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VertBracketToVertLie", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["ComponentsOfVVF", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "ComponentsOfVVF", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["FindCyclicVariationalRelations", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "FindCyclicVariationalRelations", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NormalOfCovDToCovD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "NormalOfCovDToCovD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["SymplecticPotentialOf1Form", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "SymplecticPotentialOf1Form", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertCartanMagicFormula", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VertCartanMagicFormula", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CovDOfNormal", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "CovDOfNormal", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["FindPotentialDivergence", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "FindPotentialDivergence", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NormalOfManifold", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "NormalOfManifold", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TensorsOfPartialPartial", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "TensorsOfPartialPartial", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertDeg", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VertDeg", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CovDOfTotalDerivative", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "CovDOfTotalDerivative", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["FirstVariation", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "FirstVariation", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NormalOfTotalDerivative", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "NormalOfTotalDerivative", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TensorWithIndices", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "TensorWithIndices", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertDiff", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VertDiff", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CovDToTotalDerivative", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "CovDToTotalDerivative", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["FirstVariationOf1Form", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "FirstVariationOf1Form", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["OnlyTotalDerivative", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "OnlyTotalDerivative", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["TotalDerivativeDivergenceQ", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "TotalDerivativeDivergenceQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertExactHeadQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VertExactHeadQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CurrentFromVector", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "CurrentFromVector", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["FunctionOfPartialPartial", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "FunctionOfPartialPartial", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["OrderOfPartialPartial", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "OrderOfPartialPartial", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TotalDerivativeOfCovD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "TotalDerivativeOfCovD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertExactQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VertExactQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["DefGeneralizedVVF", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "DefGeneralizedVVF", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GeneralizedVVFQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "GeneralizedVVFQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["PartialPartial", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "PartialPartial", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["TotalDerivativeOfManifold", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "TotalDerivativeOfManifold", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertInt", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VertInt", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["DefPartialPartial", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "DefPartialPartial", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["GenerateExpandVertDiffRule", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "GenerateExpandVertDiffRule", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["PartialPartialQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "PartialPartialQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TotalDerivativeOfNormal", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "TotalDerivativeOfNormal", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertLie", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VertLie", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["DependenciesOfScalar", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "DependenciesOfScalar", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["KretschmannToRiemann", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "KretschmannToRiemann", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["PartialPartialsOfFunction", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "PartialPartialsOfFunction", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TotalDerivativePotential", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "TotalDerivativePotential", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VVFFromLieD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VVFFromLieD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["DiscardTotalDerivative", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "DiscardTotalDerivative", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["LagrangianQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "LagrangianQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["PartialPartialsOfTensor", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "PartialPartialsOfTensor", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TotalDerivativeQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "TotalDerivativeQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VVFFromList", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VVFFromList", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["DivergenceQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "DivergenceQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["ListOfVariationalConstantsOf", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "ListOfVariationalConstantsOf", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["RemoveExpandVertDiffRule", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "RemoveExpandVertDiffRule", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TotalDerivativeToCovD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "TotalDerivativeToCovD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VVFQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VVFQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["dlLagrangianQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "dlLagrangianQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["ListVariationalRelationsOf", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "ListVariationalRelationsOf", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["RemoveVariationalRelation", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "RemoveVariationalRelation", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["UndefGeneralizedVVF", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "UndefGeneralizedVVF", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["WWedge", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "WWedge", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["dlNormalOfCovDQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "dlNormalOfCovDQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["MakeVertRule", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "MakeVertRule", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ResetSession", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "ResetSession", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["UnprotectVertDiffRule", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "UnprotectVertDiffRule", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ZeroVertDegQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "ZeroVertDegQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["dlNormalOfCovDToCovD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "dlNormalOfCovDToCovD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NoetherCurrent", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "NoetherCurrent", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["RulesOfGeneralizedVVFQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "RulesOfGeneralizedVVFQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VariationallyConstantQ", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VariationallyConstantQ", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], ""},
               {
                ButtonBox[
                 StyleBox["EnergyMomentum", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "EnergyMomentum", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NoetherPotential", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "NoetherPotential", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SetSigns", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "SetSigns", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VariationalRelationsOf", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-3694c90b-a688-4c65-b374-0f48392575fc", {
                   "VariationalRelationsOf", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], ""}
              },
              DefaultBaseStyle->"Text",
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{
                   Scaled[0.19]}}}],
             ImageMargins->{{10, 0}, {0, 2}},
             ScrollPosition->{0., 0.}]}
          },
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
         FrameMargins->{{0, 0}, {8, 0}},
         ScrollPosition->{0., 0.}]}, Dynamic[Typeset`open$$],
        ImageSize->Automatic]]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"ColumnsIndexed" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.8]}, 
        Offset[0.2]}}],
   BaseStyle->"InformationTitleFrame"], "InformationGridPlain"]], "Output",
 CellChangeTimes->{3.958063079671894*^9, 3.958064373756504*^9, 
  3.9581263129513187`*^9, 3.9581303477446766`*^9, 3.9595009262805977`*^9, 
  3.9606415928113117`*^9, 3.963953130018196*^9, 3.9639532273422394`*^9, 
  3.9639533449551353`*^9, 3.9639544672258873`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"85ad0547-4879-e744-b6ae-661655487d05"]
}, Open  ]],

Cell[TextData[{
 "The constants defined by ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " are the following:"
}], "Text",
 CellChangeTimes->{{3.94977039822262*^9, 3.9497704447218*^9}, {
   3.949770477761797*^9, 3.9497705355045776`*^9}, {3.949770870290058*^9, 
   3.949770916985428*^9}, {3.9575460539729958`*^9, 3.957546122855236*^9}, 
   3.9575868492276025`*^9, {3.9580644154037*^9, 3.958064425467779*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"fc45cd2a-9a93-8043-82bb-e70ddf4597b2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "xAct`xCPS`Private`ConstantsxCPS", 
  "]"}]], "Input",
 CellChangeTimes->{{3.956493342306614*^9, 3.9564933631885376`*^9}, {
   3.9564934634198055`*^9, 3.9564934745271053`*^9}, 3.9564939435394135`*^9, 
   3.9564942290839634`*^9, {3.956494285667694*^9, 3.9564942864626446`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"406b28b1-aaf0-3b44-9354-b0f6fff451ae"],

Cell[BoxData[
 StyleBox[
  FrameBox[GridBox[{
     {
      DynamicModuleBox[{Typeset`open$$ = True}, 
       PaneSelectorBox[{False->
        ButtonBox[
         RowBox[{
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "RightPointerOpener"]], " ", 
          StyleBox["xAct`xCPS`", "InformationGridGroupHeader"]}],
         Appearance->None,
         BaseStyle->"InformationGridLink",
         ButtonFunction:>FEPrivate`Set[Typeset`open$$, True],
         Evaluator->Automatic,
         Method->"Preemptive"], True->
        PaneBox[GridBox[{
           {
            ButtonBox[
             RowBox[{
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {2.134033203125, 7.865966796875}}], " ", 
              StyleBox["xAct`xCPS`", "InformationGridGroupHeader"]}],
             Appearance->None,
             BaseStyle->"InformationGridLink",
             ButtonFunction:>FEPrivate`Set[Typeset`open$$, False],
             Evaluator->Automatic,
             Method->"Preemptive"]},
           {
            PaneBox[GridBox[{
               {
                ButtonBox[
                 StyleBox["$dlTensors", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$dlTensors", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["$NameVerticalExteriorDerivative", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$NameVerticalExteriorDerivative", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$PartialPartialTensors", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$PartialPartialTensors", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$SymplecticCurrentSign", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$SymplecticCurrentSign", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$VariationalGraph", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$VariationalGraph", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["$GeneralizedVVF", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$GeneralizedVVF", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$NoetherCurrentSign", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$NoetherCurrentSign", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["$RemoveParenthesesPrintAs", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$RemoveParenthesesPrintAs", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$TotalDerivatives", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$TotalDerivatives", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$VariationalVectors", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$VariationalVectors", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["$MasterTensors", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$MasterTensors", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$NormalsOfCovD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$NormalsOfCovD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$SortVertOperatorsOrder", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$SortVertOperatorsOrder", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$UseInverseMetric", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$UseInverseMetric", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$VertExactForms", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$VertExactForms", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["$NamesOfSigns", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$NamesOfSigns", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$NormalsOfPD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$NormalsOfPD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["$SymbolVerticalExteriorDerivative", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$SymbolVerticalExteriorDerivative", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$ValuesOfSigns", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-8d98cc4f-ab11-482a-9bb1-ee326f7103d5", {
                   "$ValuesOfSigns", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], ""}
              },
              DefaultBaseStyle->"Text",
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{
                   Scaled[0.19]}}}],
             ImageMargins->{{10, 0}, {0, 2}},
             ScrollPosition->{0., 0.}]}
          },
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
         FrameMargins->{{0, 0}, {8, 0}},
         ScrollPosition->{0., 0.}]}, Dynamic[Typeset`open$$],
        ImageSize->Automatic]]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"ColumnsIndexed" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.8]}, 
        Offset[0.2]}}],
   BaseStyle->"InformationTitleFrame"], "InformationGridPlain"]], "Output",
 CellChangeTimes->{3.958063091498543*^9, 3.9580643960800705`*^9, 
  3.958081271084524*^9, 3.958126322070545*^9, 3.9595009304299984`*^9, 
  3.9606415929541454`*^9, 3.963954478649927*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"7c1a3690-99ba-e34e-b635-21d7047a86de"]
}, Open  ]],

Cell[TextData[{
 "The options and types defined by ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " are the following:"
}], "Text",
 CellChangeTimes->{{3.94977039822262*^9, 3.9497704447218*^9}, {
   3.949770477761797*^9, 3.9497705355045776`*^9}, {3.949770870290058*^9, 
   3.949770916985428*^9}, {3.9575460539729958`*^9, 3.957546140534546*^9}, 
   3.957586852893689*^9, 3.958064499973543*^9},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"c79f02e5-c9f8-7142-bed4-651b0798894a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "xAct`xCPS`Private`RestxCPS", "]"}]], "Input",
 CellChangeTimes->{
  3.9564900108746853`*^9, {3.956491269668398*^9, 3.9564912709862976`*^9}, {
   3.956494289186981*^9, 3.9564942898505306`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"c93be06c-1dad-5e4b-839a-24f49956d8d7"],

Cell[BoxData[
 StyleBox[
  FrameBox[GridBox[{
     {
      DynamicModuleBox[{Typeset`open$$ = True}, 
       PaneSelectorBox[{False->
        ButtonBox[
         RowBox[{
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "RightPointerOpener"]], " ", 
          StyleBox["xAct`xCPS`", "InformationGridGroupHeader"]}],
         Appearance->None,
         BaseStyle->"InformationGridLink",
         ButtonFunction:>FEPrivate`Set[Typeset`open$$, True],
         Evaluator->Automatic,
         Method->"Preemptive"], True->
        PaneBox[GridBox[{
           {
            ButtonBox[
             RowBox[{
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {2.134033203125, 7.865966796875}}], " ", 
              StyleBox["xAct`xCPS`", "InformationGridGroupHeader"]}],
             Appearance->None,
             BaseStyle->"InformationGridLink",
             ButtonFunction:>FEPrivate`Set[Typeset`open$$, False],
             Evaluator->Automatic,
             Method->"Preemptive"]},
           {
            PaneBox[GridBox[{
               {
                ButtonBox[
                 StyleBox["Both", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "Both", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ExpandVertDiffCovD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ExpandVertDiffCovD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ExpandVertIntLieD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ExpandVertIntLieD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NonZeroVertDeg", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "NonZeroVertDeg", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VertDiffExact", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "VertDiffExact", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 
                 StyleBox["CheckGenerateExpandVertDiffRule", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "CheckGenerateExpandVertDiffRule", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ExpandVertDiffLieD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ExpandVertDiffLieD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["ExpandVertIntTotalDerivative", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ExpandVertIntTotalDerivative", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NormalOfPD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "NormalOfPD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ZeroVertDeg", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ZeroVertDeg", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CheckZero", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "CheckZero", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["ExpandVertDiffScalarFunction", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ExpandVertDiffScalarFunction", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["HideTrivialRelations", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "HideTrivialRelations", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ShowGraph", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ShowGraph", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], ""},
               {
                ButtonBox[
                 StyleBox["ConstantTensors", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ConstantTensors", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["ExpandVertDiffTotalDerivative", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ExpandVertDiffTotalDerivative", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["HoldExpandVertDiff", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "HoldExpandVertDiff", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["Signs", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "Signs", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], ""},
               {
                ButtonBox[
                 StyleBox["Directed", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "Directed", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ExpandVertIntBracket", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ExpandVertIntBracket", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["HoldExpandVertInt", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "HoldExpandVertInt", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["UndefInfo", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "UndefInfo", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], ""},
               {
                ButtonBox[
                 StyleBox["ExpandVertDiffBracket", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ExpandVertDiffBracket", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ExpandVertIntCovD", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "ExpandVertIntCovD", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NonConstantTensors", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "NonConstantTensors", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VanishOverOtherForms", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-86be27c2-68bb-42c5-8c56-f3d4dcfef7d8", {
                   "VanishOverOtherForms", "xAct`xCPS`"}, True},
                 ButtonNote->"xAct`xCPS`",
                 Evaluator->Automatic], ""}
              },
              DefaultBaseStyle->"Text",
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{
                   Scaled[0.19]}}}],
             ImageMargins->{{10, 0}, {0, 2}},
             ScrollPosition->{0., 0.}]}
          },
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
         FrameMargins->{{0, 0}, {8, 0}},
         ScrollPosition->{0., 0.}]}, Dynamic[Typeset`open$$],
        ImageSize->Automatic]]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"ColumnsIndexed" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.8]}, 
        Offset[0.2]}}],
   BaseStyle->"InformationTitleFrame"], "InformationGridPlain"]], "Output",
 CellChangeTimes->{3.958063099690628*^9, 3.958064403193548*^9, 
  3.958126323632683*^9, 3.959500932891865*^9, 3.960641593097145*^9, 
  3.9639544819171944`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"1ee2bbc5-3bae-0e40-b32f-7790ca9823cc"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ". Initial examples out of the box"
}], "Chapter",
 CellChangeTimes->{{3.948474197281039*^9, 3.9484742191832757`*^9}, 
   3.948667339091866*^9, 3.951846391086569*^9, 3.951859448704548*^9, {
   3.952091037855297*^9, 3.95209104012545*^9}, {3.9523420356036234`*^9, 
   3.9523420751405277`*^9}, {3.9555238743326044`*^9, 
   3.9555238874801702`*^9}, {3.9559419187455225`*^9, 
   3.9559419190980425`*^9}, {3.9576082482191815`*^9, 
   3.9576082487044797`*^9}, {3.958640103450163*^9, 3.958640129219656*^9}},
 CellTags->
  "Chapter Initial examples out of the \
box",ExpressionUUID->"369cdb89-393d-9748-81be-49c4bd6ebd26"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Field theory examples"
}], "Section",
 CellChangeTimes->{{3.931836256197623*^9, 3.931836260320031*^9}, {
   3.932387704652485*^9, 3.932387709519918*^9}, {3.9324705520206637`*^9, 
   3.9324705540925975`*^9}, 3.948667313368092*^9, {3.9486673534793873`*^9, 
   3.9486673857120647`*^9}, {3.9488291406004486`*^9, 3.94882914092434*^9}, {
   3.9488293650752673`*^9, 3.948829366346679*^9}, {3.949770379934799*^9, 
   3.949770395385687*^9}, {3.950372576010416*^9, 3.9503725795857544`*^9}, {
   3.952090322054014*^9, 3.9520903263590717`*^9}, {3.9520905741025143`*^9, 
   3.9520905765631676`*^9}, {3.952090630580883*^9, 3.9520906346640015`*^9}, 
   3.9520907037586575`*^9},
 CellTags->
  "Section Field \
theory",ExpressionUUID->"41f13cc3-9404-1d45-a88e-f802bafa8e66"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Initial definitions"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, {3.952090578281065*^9, 
   3.952090583466406*^9}, {3.952179421157341*^9, 3.952179421561249*^9}, {
   3.958070957622633*^9, 
   3.9580709602439976`*^9}},ExpressionUUID->"5ba432d7-76b2-0046-8162-\
fcb7ad695417"],

Cell[TextData[{
 "In this Chapter, we hope to showcase how accessible ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " is: with just a handful of commands and no required knowledge of the inner \
workings, we will show all the physical information that can be extracted for \
two relevant examples, the scalar field theory and General Relativity (GR). \
In this Chapter we will only scratch the surface of ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 "\[CloseCurlyQuote]s capabilities",
 StyleBox[" ",
  FontWeight->"Bold"],
 "and we will revisit both examples in Chapters ",
 StyleBox[
 CounterBox["Chapter", "Chapter scalar field"],
  FontColor->RGBColor[0., 0., 1.]],
 " and ",
 StyleBox[
 CounterBox["Chapter", "Chapter GR"],
  FontColor->RGBColor[0., 0., 1.]],
 " where we will use the full power of the package. Although we encourage \
everyone to read the full documentation thoroughly, for those only interested \
in the field theory examples, we recommend to read, apart from the \
aforementioned Chapters, also Chapter ",
 StyleBox[
 CounterBox["Chapter", "Chapter Electromag"],
  FontColor->RGBColor[0., 0., 1.]],
 " (electromagnetism) and Chapter ",
 StyleBox[
 CounterBox["Chapter", "Chapter generic lagrangians"],
  FontColor->RGBColor[0., 0., 1.]],
 " (generic f(Riem), f(Ric) and f(R) theories).\n\nWe start by defining the \
manifold we are going to work on, as well as the metrics and tensors we will \
use."
}], "Text",
 CellChangeTimes->{{3.953086561057642*^9, 3.953086565607498*^9}, {
   3.9574432082120237`*^9, 3.9574432088121257`*^9}, {3.9578201109097633`*^9, 
   3.9578201141454716`*^9}, {3.9580813691748486`*^9, 3.95808148667029*^9}, {
   3.9580815199095306`*^9, 3.9580815203896103`*^9}, {3.958081556604355*^9, 
   3.9580817892528934`*^9}, {3.9580820108644924`*^9, 3.958082069636711*^9}, {
   3.9580821231512012`*^9, 3.9580821304782104`*^9}, {3.9580821632480793`*^9, 
   3.958082177820572*^9}, 3.958082242876047*^9, {3.95808231128553*^9, 
   3.9580823797564487`*^9}, {3.9582145282970295`*^9, 
   3.9582145479563484`*^9}, {3.9592272457403927`*^9, 3.9592273369395847`*^9}, 
   3.959227381914322*^9, {3.9592274406547184`*^9, 3.9592276409551125`*^9}, {
   3.9592278031303787`*^9, 3.959228174673153*^9}, {3.9592282190037746`*^9, 
   3.959228329654064*^9}, {3.9592283632152615`*^9, 3.9592283978513145`*^9}, {
   3.9592284293331184`*^9, 3.959228446484789*^9}, {3.9595009574639244`*^9, 
   3.9595009575481815`*^9}, {3.95950108790436*^9, 3.959501149286606*^9}, {
   3.959509517871063*^9, 3.9595095300542717`*^9}, 
   3.9595786942129498`*^9},ExpressionUUID->"59a875a3-d19e-d445-8e0d-\
b106d1982f32"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Set", " ", "to", " ", "False", " ", "for", " ", "the", " ", "initial", " ",
      "examples"}], ",", " ", 
    RowBox[{
    "we", " ", "will", " ", "set", " ", "it", " ", "to", " ", "True", " ", 
     "later", " ", "and", " ", "explain", " ", "all", " ", "the", " ", "new", 
     " ", "messages"}]}], " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"DefConstantSymbol", "[", "dimen", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "dimen", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "h", ",", "i",
      ",", "j", ",", "k", ",", "l"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"phi", "[", "]"}], ",", "M", ",", 
   RowBox[{"PrintAs", "->", "\"\<\[Phi]\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefMetric", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], ",", "LCDer", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[Del]\>\""}], "}"}]}], "]"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"xi", "[", "a", "]"}], ",", "M", ",", 
   RowBox[{"PrintAs", "->", "\"\<\[Xi]\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.949697206012522*^9, 3.949697230083042*^9}, {
   3.949697328689947*^9, 3.949697330959711*^9}, {3.950056751372174*^9, 
   3.9500567540883904`*^9}, {3.95020846316062*^9, 3.9502085489900055`*^9}, {
   3.950547831787689*^9, 3.9505478329146824`*^9}, {3.950547886525408*^9, 
   3.950547951902087*^9}, {3.9505573068108425`*^9, 3.950557307080578*^9}, {
   3.950557660373731*^9, 3.9505576644130535`*^9}, 3.9513066700263805`*^9, 
   3.9518464232753277`*^9, 3.951846465295122*^9, {3.9518471452352448`*^9, 
   3.9518471458009415`*^9}, 3.9522652639016037`*^9, 3.9522664794722023`*^9, {
   3.9536620810657444`*^9, 3.953662082079769*^9}, {3.953834151295143*^9, 
   3.9538341528132515`*^9}, {3.954946758494669*^9, 3.95494679490135*^9}, 
   3.955122254029743*^9, {3.9551230640846786`*^9, 3.95512306859601*^9}, 
   3.9551254174914665`*^9, {3.955125866404701*^9, 3.9551258679719524`*^9}, {
   3.955203636599325*^9, 3.9552036366997337`*^9}, 3.9552085376314926`*^9, 
   3.9552100434434605`*^9, {3.9555239187870836`*^9, 3.9555239200553875`*^9}, {
   3.955938995011919*^9, 3.955938996304452*^9}, {3.956408055688677*^9, 
   3.9564080572392063`*^9}, {3.957820107316519*^9, 3.957820107673031*^9}, {
   3.959500983767561*^9, 3.9595010163533115`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"f4880c7c-2d23-a64d-a6ee-8a7706b524d7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Lagrangians"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, {3.952090578281065*^9, 
   3.952090583466406*^9}, {3.952179421157341*^9, 
   3.952179421561249*^9}},ExpressionUUID->"1bb5dac8-5b69-3446-b8a7-\
0a1511ab4326"],

Cell["\<\
We consider the Lagrangian densities for the scalar field and for General \
Relativity (GR):\
\>", "Text",
 CellChangeTimes->{{3.9502087727396717`*^9, 3.950208808099556*^9}, {
  3.951847151824463*^9, 3.951847167780554*^9}, {3.952437079774438*^9, 
  3.9524370846392865`*^9}, {3.9559390348971953`*^9, 3.9559390373041296`*^9}, {
  3.959501163444706*^9, 
  3.9595011645812263`*^9}},ExpressionUUID->"6a6682cb-14b6-a248-a395-\
59b5b556b862"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Lscalar", "=", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b"}], "]"}], 
   RowBox[{
    RowBox[{"LCDer", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{"phi", "[", "]"}]}], 
   RowBox[{
    RowBox[{"LCDer", "[", 
     RowBox[{"-", "b"}], "]"}], "@", 
    RowBox[{"phi", "[", "]"}]}], 
   SqrtBox[
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Determinant", "[", "g", "]"}], "[", "]"}]}]]}]}], "\[IndentingNewLine]", 
 RowBox[{"LGR", "=", 
  RowBox[{
   RowBox[{"RicciScalarLCDer", "[", "]"}], 
   SqrtBox[
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Determinant", "[", "g", "]"}], "[", "]"}]}]]}]}]}], "Input",
 CellChangeTimes->{{3.9502085923014755`*^9, 3.950208633785212*^9}, {
  3.950208766152668*^9, 3.950208793224685*^9}, {3.9502088371622467`*^9, 
  3.950208854425119*^9}, {3.950358138858175*^9, 3.950358139994633*^9}, {
  3.9513209719512806`*^9, 3.951320972931427*^9}, {3.9536673206828957`*^9, 
  3.953667322369917*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"f00458eb-c372-b248-acac-eceb12eca7d2"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`a, $CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "a"], "\[Phi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LCDer[-$CellContext`a][
    $CellContext`phi[]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "b"], "\[Phi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LCDer[-$CellContext`b][
    $CellContext`phi[]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.957341554736822*^9, 3.9577633914906416`*^9, 
  3.9577859445192623`*^9, 3.9577875531654787`*^9, 3.9577894995948024`*^9, 
  3.9578202352381077`*^9, 3.958064570845188*^9, 3.958126335700121*^9, 
  3.9582145852553577`*^9, 3.959501158442583*^9, 3.9606415950254307`*^9, 
  3.9606428542735367`*^9, 3.9639348517942104`*^9, 3.9639357104140873`*^9, 
  3.9639545521324463`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"4a107e27-1cc3-b146-ac4d-80ab9b9893d5"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{"R", "[", "\[Del]", "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciScalarLCDer[],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.957341554736822*^9, 3.9577633914906416`*^9, 
  3.9577859445192623`*^9, 3.9577875531654787`*^9, 3.9577894995948024`*^9, 
  3.9578202352381077`*^9, 3.958064570845188*^9, 3.958126335700121*^9, 
  3.9582145852553577`*^9, 3.959501158442583*^9, 3.9606415950254307`*^9, 
  3.9606428542735367`*^9, 3.9639348517942104`*^9, 3.9639357104140873`*^9, 
  3.963954552155657*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"c2c9a848-8dca-ca4c-b68e-59f29d7b01e2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Equations of motion (EOM)"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.95020899049176*^9, 3.9502090017014527`*^9}, 3.9581318082682304`*^9},
 CellTags->"Sub EOM",ExpressionUUID->"34a9f596-cb8a-a946-af99-6317449bbb40"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"EOM", "[", 
     RowBox[{"field", ",", " ", "der"}], "]"}], "[", "Lagrangian", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",
  FontColor->RGBColor[0., 0., 0.],ExpressionUUID->
  "d3f20688-4d0d-af4b-bcec-7415f478eb0f"],
 StyleBox["\n",
  FontSize->3],
 "It returns the Equations of Motion of ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"Lagrangian", "'"}]}]], "InlineCode",ExpressionUUID->
  "101b53f8-e14e-0141-865f-d21cb7b69f08"],
 " with respect to ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"field", "'"}]}]], "InlineCode",ExpressionUUID->
  "67d097dc-047d-a941-b328-812b9f091733"],
 "."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952437183018958*^9, 3.9524372085839415`*^9}, {
   3.9524372818303075`*^9, 3.952437400808908*^9}, 3.9526904491775203`*^9, {
   3.953086717072216*^9, 3.953086744422722*^9}, 3.9544805056591763`*^9, {
   3.954505009170573*^9, 3.954505022966942*^9}, 3.9546637639121637`*^9, {
   3.955939045058775*^9, 3.955939045058775*^9}, {3.9570722568934555`*^9, 
   3.957072292075221*^9}, {3.9570723423488145`*^9, 3.9570723776496735`*^9}, {
   3.9570726999231286`*^9, 3.9570727096387663`*^9}, 3.9574432368590584`*^9, {
   3.957820158250927*^9, 3.9578202101682873`*^9}, {3.958064580274872*^9, 
   3.9580645859023705`*^9}, {3.9580660266942616`*^9, 3.958066027979929*^9}, 
   3.958066315380844*^9, 3.9580808287111816`*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"29f4edd6-f2cc-5945-9b97-2f46b22741a7"],

Cell[TextData[{
 "The argument ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"der", "'"}]}]], "InlineCode",ExpressionUUID->
  "120a7b12-8d7d-e94b-b55b-83b38e493145"],
 " is optional. If not specified, it finds the only ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"ca120887-71b3-e347-bc74-4eea1ef33c72"],
 " present. If more than one is present, we have to specify which one should \
be used to perform \[OpenCurlyDoubleQuote]integration by parts\
\[CloseCurlyDoubleQuote] (Leibniz rule).\n\nIn this case we obtain the wave \
equation for ",
 Cell[BoxData[
  FormBox[
  Cell["Lscalar", "InlineCode",ExpressionUUID->
    "dabfcbaa-b533-3549-97b2-839c5e3b7279"], TraditionalForm]],ExpressionUUID->
  "bc0662f0-f32e-5a48-bc03-eaea49f0e239"],
 " and the Einsteins equation for ",
 Cell[BoxData[
  FormBox["LGR", TraditionalForm]],ExpressionUUID->
  "55362776-10dd-4545-88a0-11a73179dbd9"],
 "."
}], "Text",
 CellChangeTimes->{{3.950208703034897*^9, 3.9502087465035553`*^9}, {
   3.950208904463533*^9, 3.950209052851946*^9}, {3.9509785651127033`*^9, 
   3.950978638537178*^9}, 3.951847716820959*^9, {3.952184876549637*^9, 
   3.9521849229863873`*^9}, 3.952342303483673*^9, 3.9523423542436237`*^9, {
   3.9524371238422184`*^9, 3.9524371550391045`*^9}, {3.952437406797867*^9, 
   3.9524374090789013`*^9}, {3.9546637666789975`*^9, 
   3.9546637682509775`*^9}, {3.955523991889969*^9, 3.9555240129361944`*^9}, 
   3.9559391656903563`*^9, {3.957820196531605*^9, 3.9578202297547836`*^9}, {
   3.959501176773033*^9, 
   3.9595011844058437`*^9}},ExpressionUUID->"4973c88d-b868-6847-9b11-\
20fa7099b783"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"WaveEq", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"EOM", "[", "phi", "]"}], "[", "Lscalar", "]"}], "//", 
   "ContractMetric"}]}], "\[IndentingNewLine]", 
 RowBox[{"EinsteinEq", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"EOM", "[", "g", "]"}], "[", "LGR", "]"}], "//", 
    "ContractMetric"}], "//", "Simplification"}]}]}], "Input",
 CellChangeTimes->{{3.9502086402305794`*^9, 3.950208676277626*^9}, {
   3.9502088117222824`*^9, 3.950208830953522*^9}, {3.95020888619449*^9, 
   3.9502088879601135`*^9}, {3.9502090572689877`*^9, 
   3.9502090627887077`*^9}, {3.950374480288973*^9, 3.950374480302977*^9}, {
   3.950375094029884*^9, 3.9503751466917458`*^9}, {3.950808099609304*^9, 
   3.950808099615345*^9}, {3.950964113818867*^9, 3.950964134833051*^9}, {
   3.950966312574377*^9, 3.95096632465419*^9}, 3.951306703765396*^9, {
   3.9519250955745754`*^9, 3.951925120131281*^9}, {3.9521794364597225`*^9, 
   3.95217944134993*^9}, {3.952184926873396*^9, 3.952184927301733*^9}, 
   3.9537302072571945`*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"24495e2a-7676-b04c-bd95-ca6777eb9446"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]}]]}], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "a"], 
     SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LCDer[-$CellContext`a][
    $CellContext`LCDer[$CellContext`a][
     $CellContext`phi[]]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.95734157558867*^9, 3.9577633915393305`*^9, 
  3.9577859446222715`*^9, 3.9577875532285423`*^9, 3.9577894996332817`*^9, 
  3.957820236935898*^9, 3.95806462632255*^9, 3.9581263396003056`*^9, 
  3.958214591554619*^9, 3.9595011892264633`*^9, 3.9606415951562233`*^9, 
  3.9606428555607395`*^9, 3.963935716484007*^9, 3.9639545564650536`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"c06ea76c-5bcd-5e47-914b-3e59ec362fc2"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[Del]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciLCDer[$CellContext`a, $CellContext`b],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`a, $CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarLCDer[],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.95734157558867*^9, 3.9577633915393305`*^9, 
  3.9577859446222715`*^9, 3.9577875532285423`*^9, 3.9577894996332817`*^9, 
  3.957820236935898*^9, 3.95806462632255*^9, 3.9581263396003056`*^9, 
  3.958214591554619*^9, 3.9595011892264633`*^9, 3.9606415951562233`*^9, 
  3.9606428555607395`*^9, 3.963935716484007*^9, 3.9639545573261585`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"7aa76f25-daa7-d341-be6a-0486b867b114"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Energy momentum-tensor"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.95020899049176*^9, 3.9502090017014527`*^9}, {3.95020908165974*^9, 
   3.9502090848109665`*^9}},
 CellTags->
  "Sub Energy \
momentum",ExpressionUUID->"fa7f0e83-9e1f-c542-a0b2-17abb8953173"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"EnergyMomentum", "[", "Lagrangian", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"398bf441-03ab-654a-8491-8bea1fa9a1ea"],
 StyleBox["\n",
  FontSize->3],
 "It returns the Energy Momentum tensor of ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"Lagrangian", "'"}]}]], "InlineCode",ExpressionUUID->
  "e9942dba-3176-0d45-91d6-c57998ef9cac"],
 "."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.9502155149933624`*^9, 3.9502155782185097`*^9}, {
   3.9502164760909195`*^9, 3.950216477241432*^9}, {3.9509786493299274`*^9, 
   3.9509786522981224`*^9}, 3.952346948877325*^9, {3.952347014057169*^9, 
   3.9523470159555025`*^9}, {3.9530868319896903`*^9, 3.9530868403956947`*^9}, 
   3.954480697675039*^9, {3.9544808284332237`*^9, 3.954480840969305*^9}, 
   3.9546638151986723`*^9, {3.9559392608485403`*^9, 3.955939277974368*^9}, 
   3.9567198235755234`*^9, {3.9567199176510983`*^9, 3.956719926151351*^9}, {
   3.9570725057915797`*^9, 3.957072513762759*^9}, {3.957072561817318*^9, 
   3.9570725944662447`*^9}, {3.957820243327572*^9, 3.9578202692505493`*^9}, {
   3.958066022430025*^9, 3.9580660395578003`*^9}, {3.9580663121074047`*^9, 
   3.958066331832695*^9}, 3.9580704827827415`*^9, 3.9580808257763557`*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"9b29f381-0cd9-714a-af60-15b6ca587bbc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EnergyMomentumScalar", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"EnergyMomentum", "[", "Lscalar", " ", "]"}], "//", 
    "ContractMetric"}], "//", "Simplification"}]}]], "Input",
 CellChangeTimes->{{3.950209088796829*^9, 3.9502091555329285`*^9}, 
   3.950209802433092*^9, {3.950215609769041*^9, 3.950215631020658*^9}, {
   3.950217827692333*^9, 3.950217831368875*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"67db5503-c587-9246-82d6-95429b5ad48d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[$CellContext`a][
     $CellContext`phi[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[$CellContext`b][
     $CellContext`phi[]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "c"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[-$CellContext`c][
     $CellContext`phi[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "c"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[$CellContext`c][
     $CellContext`phi[]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.9573415902278614`*^9, 3.9577633918080015`*^9, 
  3.9577859449467497`*^9, 3.9577875535072603`*^9, 3.9577895001919174`*^9, 
  3.957820454664957*^9, 3.958064651317211*^9, 3.958126345024908*^9, 
  3.9582145964640656`*^9, 3.9595012008009605`*^9, 3.9606415965309105`*^9, 
  3.960642856508396*^9, 3.963935721905958*^9, 3.9639545950975647`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"a1fabb98-a896-9346-932c-1f8f9297f8c0"]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to the ",
 Cell[BoxData[
 "EOM"], "InlineCode",ExpressionUUID->"6a7f2145-6867-6443-aebb-bcc31907b243"],
 " with respect to the main non-frozen metric multiplied by ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"-", "2"}], 
    SqrtBox[
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["g", 
         OverscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Detg[],
       Editable->False]}]]], TraditionalForm]],ExpressionUUID->
  "1fa655ef-f562-c246-a02f-7e21d396cc85"],
 " (with a \[OpenCurlyDoubleQuote]plus\[CloseCurlyDoubleQuote] if we take the \
variation with respect to the inverse metric, which will be explained in \
Subsubsection",
 StyleBox[" ",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Chapter", 
  "Subsub Raising and Lowering indices do not commute with VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->
   "Subsub Raising and Lowering indices do not commute with VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", 
  "Subsub Raising and Lowering indices do not commute with VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->
   "Subsub Raising and Lowering indices do not commute with VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsection", 
  "Subsub Raising and Lowering indices do not commute with VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->
   "Subsub Raising and Lowering indices do not commute with VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsubsection", 
  "Subsub Raising and Lowering indices do not commute with VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 ")."
}], "Text",
 CellChangeTimes->{{3.950209804728134*^9, 3.9502098139922333`*^9}, {
   3.9503802872515087`*^9, 3.9503803043862534`*^9}, {3.9503808973484516`*^9, 
   3.9503809257612133`*^9}, {3.956140379390721*^9, 3.956140390587243*^9}, {
   3.956408105454451*^9, 3.9564081096249084`*^9}, {3.9570726077749186`*^9, 
   3.9570726133765297`*^9}, {3.9578830925148582`*^9, 
   3.9578830967056513`*^9}, {3.957883455159895*^9, 3.9578834591560445`*^9}, 
   3.958053590744829*^9, {3.959501208997017*^9, 3.959501209604969*^9}, {
   3.959501249038521*^9, 3.9595012576941357`*^9}, 3.9595715796997166`*^9, 
   3.9595787467072353`*^9, {3.9595787824106045`*^9, 
   3.9595788088183155`*^9}},ExpressionUUID->"e3df58dd-6c95-1047-95c7-\
03e97e9ce2a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"-", "2"}], 
     SqrtBox[
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         OverscriptBox["g", 
          OverscriptBox[
           StyleBox["~",
            FontColor->RGBColor[0, 0, 0]], 
           StyleBox["~",
            FontColor->RGBColor[0, 0, 0]]]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Detg[],
        Editable->False]}]]], 
    RowBox[{
     RowBox[{"EOM", "[", "g", "]"}], "[", "Lscalar", "]"}]}], "//", 
   "ContractMetric"}], "//", "Simplification"}]], "Input",
 CellChangeTimes->{{3.9502098168105965`*^9, 3.9502098182032433`*^9}, 
   3.9503744803290176`*^9, 3.950379283024311*^9, {3.950380272821926*^9, 
   3.950380279798092*^9}, 3.950380861868117*^9, 3.950808099621332*^9, {
   3.9522088928180695`*^9, 3.952208915293684*^9}, 3.953397695588999*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"331d7cc3-0265-1847-8bad-ab7a3dd56096"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[$CellContext`a][
     $CellContext`phi[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[$CellContext`b][
     $CellContext`phi[]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "c"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[-$CellContext`c][
     $CellContext`phi[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[Del]", "c"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[$CellContext`c][
     $CellContext`phi[]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.957341580948083*^9, 3.957763391878329*^9, 
  3.957785945026129*^9, 3.9577875535930767`*^9, 3.957789500328303*^9, 
  3.9578204638381824`*^9, 3.9580646978793945`*^9, 3.9581263474717255`*^9, 
  3.9582145979485283`*^9, 3.959501277592167*^9, 3.9606415968285236`*^9, 
  3.960642856674431*^9, 3.963935723733652*^9, 3.9639545972570343`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"b3f1e7c8-91ae-044f-80cf-df7bdd2ca699"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Symplectic potential"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.95020899049176*^9, 3.9502090017014527`*^9}, {3.95020908165974*^9, 
   3.9502090848109665`*^9}, {3.950209898836437*^9, 3.950209900451885*^9}, {
   3.950209943107773*^9, 3.95020994397941*^9}, 3.9581318053845215`*^9},
 CellTags->
  "Sub symplectic \
Potential",ExpressionUUID->"5eb4d021-33ba-7a43-a648-d94cfa79165e"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"SymplecticPotential", "[", 
     RowBox[{"tensors", ",", " ", "der"}], "]"}], "[", "Lagrangian", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"bd980577-5fac-2c4c-b0eb-7ba13d996d98"],
 StyleBox["\n",
  FontSize->3],
 "It computes the symplectic potential from the ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"Lagrangian", "'"}]}]], "InlineCode",ExpressionUUID->
  "7c6db5f9-c87c-fa4a-94c1-c74cd6deb054"],
 "."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952437747850528*^9, 3.9524378098615108`*^9}, 
   3.9544808866622133`*^9, {3.955939346006485*^9, 3.955939358253787*^9}, {
   3.9559394330629263`*^9, 3.9559394332882147`*^9}, {3.956719974236329*^9, 
   3.9567199768844748`*^9}, 3.956720055374608*^9, {3.9578834813089237`*^9, 
   3.957883499378339*^9}, {3.957884862637577*^9, 3.957884865232568*^9}, {
   3.9580660200370007`*^9, 3.958066042484413*^9}, {3.9580663069437695`*^9, 
   3.9580663341798477`*^9}, 3.958070486155815*^9, 3.9580808227921696`*^9, {
   3.958389191803644*^9, 3.958389192496128*^9}},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"c54cb69d-da9e-234e-9123-c1a2ecea02c3"],

Cell[TextData[{
 "When considering the variation of a Lagrangian that depends on ",
 Cell[BoxData[
  FormBox["N", TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "ca2e27fe-6550-1e48-b018-d6e3508ce9e3"],
 " different tensor fields ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"{", 
     SuperscriptBox["\[Phi]", "i"], "}"}], 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", "...", ",", "N"}]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "efc9e6cc-c625-5049-8221-a42658759f37"],
 ", if we perform the Leibniz rule in the variation of the fields (\
\[OpenCurlyDoubleQuote]integration by parts\[CloseCurlyDoubleQuote]), we \
obtain one of the most relevant equations for ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " (see [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography CPS JMB-EJSV"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 ",",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography Anderson"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 "])"
}], "Text",
 CellChangeTimes->{{3.952437458796793*^9, 3.952437536564994*^9}, {
   3.953087216073867*^9, 3.953087216073867*^9}, {3.953087253432725*^9, 
   3.9530872534483786`*^9}, 3.955939383062138*^9, {3.957397339866452*^9, 
   3.957397340426619*^9}, {3.957397506323078*^9, 3.95739750701866*^9}, 
   3.9578830985626082`*^9, 3.957883453036395*^9, {3.958064721420414*^9, 
   3.9580647243916435`*^9}, 3.958064945580784*^9, {3.9595016051997566`*^9, 
   3.959501608439396*^9}, 3.963935736318735*^9, {3.9639358072469273`*^9, 
   3.963935811482582*^9}, 3.964955951854521*^9, {3.964955983473196*^9, 
   3.964956023781555*^9}},ExpressionUUID->"00d775b0-0991-2f46-8333-\
739312f57c60"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[DifferentialD]", "L"}], "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["EOM", "i"], 
    RowBox[{"\[DifferentialD]", 
     SuperscriptBox["\[Phi]", "i"]}]}], "+", 
   "d\[CapitalTheta]"}]}]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.950558777787306*^9, 3.950558913121212*^9}, {
   3.950965093094467*^9, 3.9509651190081415`*^9}, 3.950965161268156*^9, 
   3.950965291073814*^9, {3.964955917702259*^9, 3.96495593225494*^9}, 
   3.96495604427092*^9},
 TextAlignment->Center,
 CellTags->
  "eq: dlL=EOM+dTheta",ExpressionUUID->"35381f76-0041-d94a-8a8a-98701a716af0"],

Cell[TextData[{
 "where:\n\[Bullet] ",
 Cell[BoxData["\[DifferentialD]"],
  CellChangeTimes->{{3.950558777787306*^9, 3.950558913121212*^9}, {
   3.950965093094467*^9, 3.95096512287224*^9}, {3.950965435496889*^9, 
   3.950965469681305*^9}, {3.950978792297262*^9, 3.950978828737831*^9}, {
   3.95178934857366*^9, 3.951789390661476*^9}, {3.9523430217973757`*^9, 
   3.9523430542658587`*^9}, {3.9523430944954386`*^9, 3.9523431673285823`*^9}},
  ExpressionUUID->"4ff711d8-972b-8a4c-bec1-4b280b767bd0"],
 ", sometimes denoted \[Delta] in the physics literature, is the exterior \
derivative in the space of fields and can also be understood as the \
variational operator (see Section ",
 StyleBox[
 CounterBox["Chapter", "Section VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Section VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Section VertDiff"],
  FontColor->RGBColor[0., 0., 1.]],
 " ",
 StyleBox["for further details).",
  FontColor->GrayLevel[0]],
 "\n\[Bullet] ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox["EOM", "i"],
   FontWeight->"Bold"]],
  CellChangeTimes->{{3.950558777787306*^9, 3.950558913121212*^9}, {
   3.950965093094467*^9, 3.95096512287224*^9}, {3.950965435496889*^9, 
   3.950965469681305*^9}, {3.950978792297262*^9, 3.950978828737831*^9}, {
   3.95178934857366*^9, 3.951789390661476*^9}, {3.9523430217973757`*^9, 
   3.9523430542658587`*^9}, {3.9523430944954386`*^9, 3.9523431673285823`*^9}},
  ExpressionUUID->"894b21cb-06e9-4747-b59b-23258e402db0"],
 ", sometimes denoted ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       FractionBox[
        RowBox[{"\[Delta] ", "\[NegativeThinSpace]", 
          StyleBox["L", "TI"]}], 
        SuperscriptBox["\[Delta]\[Phi]", 
         StyleBox["i", "TI"]]], TraditionalForm], "errors" -> {}, "input" -> 
     "\\frac{\\delta\\,\\!L}{\\delta\\phi^i}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "f835ec23-4fc2-f54e-8dcc-a202ffb9dd6c"],
 " in the physics literature, is the Equation of Motion with respect to the \
tensor field ",
 Cell[BoxData[
  SuperscriptBox["\[Phi]", "i"]],
  CellChangeTimes->{{3.950558777787306*^9, 3.950558913121212*^9}, {
   3.950965093094467*^9, 3.95096512287224*^9}, {3.950965435496889*^9, 
   3.950965469681305*^9}, {3.950978792297262*^9, 3.950978828737831*^9}, {
   3.95178934857366*^9, 3.951789390661476*^9}, {3.9523430217973757`*^9, 
   3.9523430542658587`*^9}, {3.9523430944954386`*^9, 3.9523431673285823`*^9}},
  ExpressionUUID->"c717e5ae-3f65-1742-a7ad-d221546b5609"],
 ".\n\[Bullet] ",
 StyleBox["\[CapitalTheta]",
  FontWeight->"Bold"],
 " the ",
 StyleBox["symplectic potential",
  FontSlant->"Italic"],
 " of the Lagrangian which is only defined up to a total derivative (it is \
well defined upon integration on a manifold with no boundary).\n\nThe term ",
 StyleBox["d\[CapitalTheta]",
  FontWeight->"Bold"],
 " (which can also be written as a divergence) is sometimes called the \
boundary term since, when integrating, it goes to the boundary."
}], "Text",
 CellChangeTimes->{{3.9524375720261602`*^9, 3.9524377038186483`*^9}, {
   3.957443332002407*^9, 3.9574433329683285`*^9}, {3.957600689033552*^9, 
   3.9576006906280165`*^9}, {3.957820482810581*^9, 3.9578205386269608`*^9}, 
   3.957883100577282*^9, 3.957883451377553*^9, 3.9580408961654797`*^9, 
   3.9580535921524677`*^9, {3.958064974101347*^9, 3.958065043633774*^9}, {
   3.9595766537213383`*^9, 3.9595766553100777`*^9}, {3.9649559093603897`*^9, 
   3.9649559146587315`*^9}, {3.9649559728677826`*^9, 
   3.9649559734486237`*^9}, {3.964956106498869*^9, 3.96495615903944*^9}, {
   3.964956215133465*^9, 
   3.964956289507681*^9}},ExpressionUUID->"f716452d-2bcd-b443-9217-\
66c37d4c54ec"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymplecticPotential", "[", "]"}], "[", "Lscalar", "]"}], "//", 
   "ContractMetric"}], "//", "Simplification"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymplecticPotential", "[", "]"}], "[", "LGR", "]"}], "//", 
   "ContractMetric"}], "//", "Simplification", " "}]}], "Input",
 CellChangeTimes->{{3.950209088796829*^9, 3.9502091555329285`*^9}, 
   3.950209802433092*^9, {3.950209859773899*^9, 3.950209934286932*^9}, {
   3.950374480340004*^9, 3.950374480347523*^9}, {3.9503792919421215`*^9, 
   3.9503793537110558`*^9}, {3.950808099628332*^9, 3.950808099633346*^9}, {
   3.952188836618765*^9, 3.952188846990843*^9}, {3.9533284505958366`*^9, 
   3.9533284544758263`*^9}, {3.9537302528080063`*^9, 3.953730256991129*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"97bec84c-4c2e-6c4e-984f-8b867b3a846c"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{"(", 
     RowBox[{"\[DifferentialD]", "\[Phi]"}], ")"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`dlphi[],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "a"], "\[Phi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LCDer[-$CellContext`a][
    $CellContext`phi[]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.957341614750599*^9, 3.9577633919181833`*^9, 
  3.957785945087633*^9, 3.9577875536707344`*^9, 3.957789500430929*^9, 
  3.957820582914358*^9, 3.9580650480983467`*^9, 3.9581263530637703`*^9, 
  3.958214607917782*^9, 3.9595013277927265`*^9, 3.960641597155119*^9, 
  3.9606428569404736`*^9, 3.9639358274094048`*^9, 3.963954602877043*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"a49a662a-60e0-d040-9830-f7dc15dbdce3"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], GridBox[{
          {
           RowBox[{"(", 
            RowBox[{"\[DifferentialD]", "g"}], ")"}], 
           StyleBox[GridBox[{
              {"b", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`dlg[$CellContext`b, -$CellContext`b]],
      Editable->False]}], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], GridBox[{
         {
          RowBox[{"(", 
           RowBox[{"\[DifferentialD]", "g"}], ")"}], 
          StyleBox[GridBox[{
             {" ", "b"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`dlg[-$CellContext`a, $CellContext`b]],
     Editable->False]}], ")"}]}]], "Output",
 CellChangeTimes->{3.957341614750599*^9, 3.9577633919181833`*^9, 
  3.957785945087633*^9, 3.9577875536707344`*^9, 3.957789500430929*^9, 
  3.957820582914358*^9, 3.9580650480983467`*^9, 3.9581263530637703`*^9, 
  3.958214607917782*^9, 3.9595013277927265`*^9, 3.960641597155119*^9, 
  3.9606428569404736`*^9, 3.9639358274094048`*^9, 3.963954603766115*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"4a6f7bd8-26ee-be4c-ab6f-59dfa64c0bf4"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Remark:",
  FontWeight->"Bold"],
 StyleBox[" The tensor ",
  FontWeight->"Plain"],
 Cell[BoxData[GridBox[{
    {
     RowBox[{"(", 
      SubscriptBox["n", "\[Del]"], ")"}], 
     StyleBox[GridBox[{
        {"a"},
        {" "}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.], {
            Offset[0.034999999999999996`]}, 
           Offset[0.]}, "Rows" -> {{
            Offset[0.]}}}],
      FontSize->Rational[39, 4]]}
   },
   GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.034999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}]],
  CellChangeTimes->{3.957341614750599*^9, 3.9577633919181833`*^9, 
   3.957785945087633*^9, 3.9577875536707344`*^9, 3.957789500430929*^9, 
   3.957820582914358*^9, 3.9580650480983467`*^9, 3.9581263530637703`*^9, 
   3.958214607917782*^9, 3.9595013277927265`*^9, 3.960641597155119*^9, 
   3.9606428569404736`*^9, 3.9639358274094048`*^9, 3.963954603766115*^9},
  ExpressionUUID->"8cf1f450-5e8f-8848-93dd-408fa6f693fe"],
 StyleBox[" is multipurpose and admits several interpretations. AA more \
detailed account will be given in Subsection ",
  FontWeight->"Plain"],
 StyleBox[
 CounterBox["Chapter", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub FindPotentialDivergence"],
  FontWeight->"Plain",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub FindPotentialDivergence"],
  FontWeight->"Plain",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsection", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 ", but let us outline a few key points here. ",
 StyleBox["First, it can be used to contract the free index, yielding a \
scalar expression that is more convenient to work with. Second, when the \
pullback of ",
  FontWeight->"Plain"],
 StyleBox["\[CapitalTheta]",
  FontWeight->"Bold"],
 StyleBox[" is integrated over a Cauchy surface, ",
  FontWeight->"Plain"],
 Cell[BoxData[GridBox[{
    {
     RowBox[{"(", 
      SubscriptBox["n", "\[Del]"], ")"}], 
     StyleBox[GridBox[{
        {"a"},
        {" "}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.], {
            Offset[0.034999999999999996`]}, 
           Offset[0.]}, "Rows" -> {{
            Offset[0.]}}}],
      FontSize->Rational[39, 4]]}
   },
   GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.034999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}]],
  CellChangeTimes->{3.957341614750599*^9, 3.9577633919181833`*^9, 
   3.957785945087633*^9, 3.9577875536707344`*^9, 3.957789500430929*^9, 
   3.957820582914358*^9, 3.9580650480983467`*^9, 3.9581263530637703`*^9, 
   3.958214607917782*^9, 3.9595013277927265`*^9, 3.960641597155119*^9, 
   3.9606428569404736`*^9, 3.9639358274094048`*^9, 3.963954603766115*^9},
  ExpressionUUID->"655b3058-7814-e04d-a723-036403529524"],
 StyleBox[" represents the normal to that hypersurface. Finally, it may also \
be interpreted as a covariant derivative, although this interpretation is \
more subtle and will be addressed in detail in Subsection ",
  FontWeight->"Plain"],
 StyleBox[
 CounterBox["Chapter", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub FindPotentialDivergence"],
  FontWeight->"Plain",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub FindPotentialDivergence"],
  FontWeight->"Plain",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsection", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[" and Subsubsection ",
  FontWeight->"Plain"],
 StyleBox[
 CounterBox["Chapter", "SubsubTotalDerivativeOfCovD and NormalOfCovD"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"SubsubTotalDerivativeOfCovD and NormalOfCovD"],
  FontWeight->"Plain",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "SubsubTotalDerivativeOfCovD and NormalOfCovD"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"SubsubTotalDerivativeOfCovD and NormalOfCovD"],
  FontWeight->"Plain",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsection", "SubsubTotalDerivativeOfCovD and NormalOfCovD"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"SubsubTotalDerivativeOfCovD and NormalOfCovD"],
  FontWeight->"Plain",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsubsection", "SubsubTotalDerivativeOfCovD and NormalOfCovD"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[". ",
  FontWeight->"Plain"]
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.959573346626133*^9, 3.9595733471500225`*^9}, {
   3.959574094991453*^9, 3.9595741072339973`*^9}, {3.9649565547085915`*^9, 
   3.964956679467291*^9}, {3.9649569798154297`*^9, 3.9649570666433372`*^9}, {
   3.964957327310089*^9, 3.9649573559635887`*^9}, {3.9649573862057953`*^9, 
   3.9649573990606823`*^9}, {3.964960749695593*^9, 3.9649608134729786`*^9}, {
   3.9649608607603893`*^9, 3.9649609273217144`*^9}, {3.9649609644205437`*^9, 
   3.964960992369276*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"30e4b880-6258-4447-9b39-e35d2d969f34"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Symplectic current"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.95020899049176*^9, 3.9502090017014527`*^9}, {3.95020908165974*^9, 
   3.9502090848109665`*^9}, {3.950209898836437*^9, 3.950209900451885*^9}, {
   3.9502099457479115`*^9, 3.9502099463939137`*^9}, 3.958131802665636*^9},
 CellTags->
  "Sub Symplectic \
Current",ExpressionUUID->"6cdbba85-ca7e-bc47-a415-85e150373cb9"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"SymplecticCurrent", "[", 
     RowBox[{"tensors", ",", " ", "der"}], "]"}], "[", "Lagrangian", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"5e639556-de8a-7542-bfa1-0b23657c9d72"],
 StyleBox["\n",
  FontSize->3],
 "It computes the symplectic current associated to the given ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"Lagrangian", "'"}]}]], "InlineCode",ExpressionUUID->
  "6dea7ff1-4992-7b44-acd3-87321550a173"],
 "."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952437867524809*^9, 3.9524378774013205`*^9}, {
   3.953087305389626*^9, 3.9530873445165377`*^9}, 3.954480967702871*^9, {
   3.955939476203476*^9, 3.9559394785618296`*^9}, {3.9567201414209175`*^9, 
   3.9567201435123315`*^9}, 3.9567201906195354`*^9, {3.956720310900824*^9, 
   3.956720318114909*^9}, {3.957883502725177*^9, 3.957883504327809*^9}, {
   3.9578848715647726`*^9, 3.957884873936947*^9}, {3.9580660162609367`*^9, 
   3.958066044156481*^9}, 3.958066258305046*^9, 3.9580663033965435`*^9, 
   3.9580663366121674`*^9, 3.958070488878067*^9, 3.958080812513817*^9, {
   3.958389202301464*^9, 3.9583892041949368`*^9}},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"45886c2f-7855-354c-ba3b-034650a675ef"],

Cell["\<\
Taking the exterior derivative (variation) of the symplectic potential, we \
obtain the symplectic current (defined up to a total derivative):\
\>", "Text",
 CellChangeTimes->{{3.950558921339657*^9, 3.950559000453705*^9}, {
  3.9509654881714153`*^9, 3.950965488354101*^9}, {3.951789374131607*^9, 
  3.9517893838838444`*^9}},ExpressionUUID->"d4d8ea4b-f976-e74f-8d75-\
fb8478db1d22"],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Omega]", "=", 
   RowBox[{"\[DifferentialD]", "\[CapitalTheta]"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.950558921339657*^9, 3.950559000453705*^9}, {
   3.950965490387897*^9, 3.9509655029790154`*^9}, 3.9510502167988987`*^9},
 TextAlignment->Center,
 CellTags->
  "eq: symplecticform=dlTheta",ExpressionUUID->"81cc2110-c0d6-5947-9476-\
77dbcc9d9e5f"],

Cell[TextData[{
 "There is an overall sign ",
 Cell[BoxData[
 "$SymplecticCurrentSign"], "InlineCode",ExpressionUUID->
  "3df74e18-177a-fa47-8373-fc7d2432cfd7"],
 " that is taken by default =1."
}], "Text",
 CellChangeTimes->{{3.950558921339657*^9, 3.950559000453705*^9}, 
   3.950965496114532*^9, {3.950978949224764*^9, 3.950978953849434*^9}, {
   3.9510502092542305`*^9, 3.951050220247656*^9}, {3.952343215723983*^9, 
   3.952343228479887*^9}, {3.95593999846037*^9, 3.955940005771566*^9}, {
   3.9567202837406807`*^9, 3.956720290641964*^9}, 3.9578831024110436`*^9, 
   3.9578834485926647`*^9},ExpressionUUID->"1b925239-3cd8-6c49-99ba-\
d2499a0ef5ea"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["$SymplecticCurrentSign",
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"9e5012c6-114e-3547-9c48-742ef8fe5745"],
 StyleBox["\n",
  FontSize->3],
 "It defines the global sign of the symplectic current."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952437867524809*^9, 3.9524378774013205`*^9}, {
   3.953087305389626*^9, 3.9530873445165377`*^9}, 3.954480967702871*^9, {
   3.955939476203476*^9, 3.9559394785618296`*^9}, {3.9567201414209175`*^9, 
   3.9567201435123315`*^9}, 3.9567201906195354`*^9, {3.956720310900824*^9, 
   3.9567203440153913`*^9}, {3.956720379872291*^9, 3.956720382879834*^9}, {
   3.95788350714209*^9, 3.9578835096333847`*^9}, {3.958065086679657*^9, 
   3.958065088239023*^9}, {3.9580660134111824`*^9, 3.9580660141711597`*^9}, 
   3.9580660457646904`*^9, 3.9580662590168114`*^9, 3.9580663013022842`*^9, 
   3.958066338398327*^9, {3.958067052234024*^9, 3.9580670584572906`*^9}, 
   3.958070491583288*^9, 3.958080813592016*^9},
 Background->GrayLevel[
  0.909804],ExpressionUUID->"7339a7b8-097d-7244-bf16-d03f58958161"],

Cell[CellGroupData[{

Cell[BoxData["$SymplecticCurrentSign"], "Input",
 CellChangeTimes->{{3.9580650725186157`*^9, 3.958065073884905*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"7c541eb9-09fc-0446-be31-9d73f3359612"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.9580650742936363`*^9, 3.9582146154848537`*^9, 
  3.9595014248429832`*^9, 3.9606415977749195`*^9, 3.960642858099102*^9, 
  3.96393583425539*^9, 3.9639546076663074`*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"70e01a6f-fe7c-c641-b436-f575fbc3825c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymplecticCurrent", "[", "]"}], "[", "Lscalar", "]"}], "//", 
   "ContractMetric"}], "//", "Simplification"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymplecticCurrent", "[", "]"}], "[", "LGR", "]"}], "//", 
   "ContractMetric"}], "//", "Simplification", " "}]}], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"71732535-0856-dd40-9c8c-7863dbf7977e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"(", 
            RowBox[{"\[DifferentialD]", "\[Phi]"}], ")"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`dlphi[],
          Editable->False], "\:2a55", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "a"], 
            RowBox[{"(", 
             RowBox[{"\[DifferentialD]", "\[Phi]"}], ")"}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`LCDer[-$CellContext`a][
           $CellContext`dlphi[]],
          Editable->False]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xCPS`WWedge[
        $CellContext`dlphi[], 
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`dlphi[]]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"(", 
            RowBox[{"\[DifferentialD]", "\[Phi]"}], ")"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`dlphi[],
          Editable->False], "\:2a55", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"(", 
               RowBox[{"\[DifferentialD]", "g"}], ")"}], 
              StyleBox[GridBox[{
                 {"b", " "},
                 {" ", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`dlg[$CellContext`b, -$CellContext`b],
          Editable->False]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xCPS`WWedge[
        $CellContext`dlphi[], 
        $CellContext`dlg[$CellContext`b, -$CellContext`b]],
       Editable->False], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`phi[]],
      Editable->False]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"(", 
            RowBox[{"\[DifferentialD]", "\[Phi]"}], ")"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`dlphi[],
          Editable->False], "\:2a55", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"(", 
               RowBox[{"\[DifferentialD]", "g"}], ")"}], 
              StyleBox[GridBox[{
                 {" ", " "},
                 {"a", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`dlg[-$CellContext`a, -$CellContext`b],
          Editable->False]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xCPS`WWedge[
        $CellContext`dlphi[], 
        $CellContext`dlg[-$CellContext`a, -$CellContext`b]],
       Editable->False], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`b][
       $CellContext`phi[]],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.963934862468485*^9, 3.9639358358593197`*^9, 
  3.9639546098846245`*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"739a11c3-f4a4-8b4d-93a9-028922e47324"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"(", 
             RowBox[{"\[DifferentialD]", "g"}], ")"}], 
            StyleBox[GridBox[{
               {" ", "b"},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dlg[-$CellContext`a, $CellContext`b],
        Editable->False], "\:2a55", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "b"], GridBox[{
            {
             RowBox[{"(", 
              RowBox[{"\[DifferentialD]", "g"}], ")"}], 
             StyleBox[GridBox[{
                {"c", " "},
                {" ", "c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`b][
         $CellContext`dlg[$CellContext`c, -$CellContext`c]],
        Editable->False]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xCPS`WWedge[
      $CellContext`dlg[-$CellContext`a, $CellContext`b], 
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`dlg[$CellContext`c, -$CellContext`c]]],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"(", 
             RowBox[{"\[DifferentialD]", "g"}], ")"}], 
            StyleBox[GridBox[{
               {"b", " "},
               {" ", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dlg[$CellContext`b, -$CellContext`b],
        Editable->False], "\:2a55", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "a"], GridBox[{
            {
             RowBox[{"(", 
              RowBox[{"\[DifferentialD]", "g"}], ")"}], 
             StyleBox[GridBox[{
                {"c", " "},
                {" ", "c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`dlg[$CellContext`c, -$CellContext`c]],
        Editable->False]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xCPS`WWedge[
      $CellContext`dlg[$CellContext`b, -$CellContext`b], 
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`dlg[$CellContext`c, -$CellContext`c]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"(", 
             RowBox[{"\[DifferentialD]", "g"}], ")"}], 
            StyleBox[GridBox[{
               {"b", " "},
               {" ", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dlg[$CellContext`b, -$CellContext`b],
        Editable->False], "\:2a55", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "c"], GridBox[{
            {
             RowBox[{"(", 
              RowBox[{"\[DifferentialD]", "g"}], ")"}], 
             StyleBox[GridBox[{
                {" ", "c"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`c][
         $CellContext`dlg[-$CellContext`a, $CellContext`c]],
        Editable->False]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xCPS`WWedge[
      $CellContext`dlg[$CellContext`b, -$CellContext`b], 
      $CellContext`LCDer[-$CellContext`c][
       $CellContext`dlg[-$CellContext`a, $CellContext`c]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"(", 
             RowBox[{"\[DifferentialD]", "g"}], ")"}], 
            StyleBox[GridBox[{
               {"b", "c"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`dlg[$CellContext`b, $CellContext`c],
        Editable->False], "\:2a55", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "a"], GridBox[{
            {
             RowBox[{"(", 
              RowBox[{"\[DifferentialD]", "g"}], ")"}], 
             StyleBox[GridBox[{
                {" ", " "},
                {"b", "c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`dlg[-$CellContext`b, -$CellContext`c]],
        Editable->False]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xCPS`WWedge[
      $CellContext`dlg[$CellContext`b, $CellContext`c], 
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`dlg[-$CellContext`b, -$CellContext`c]]],
     Editable->False], "-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"(", 
               RowBox[{"\[DifferentialD]", "g"}], ")"}], 
              StyleBox[GridBox[{
                 {"b", "c"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`dlg[$CellContext`b, $CellContext`c],
          Editable->False], "\:2a55", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "c"], GridBox[{
              {
               RowBox[{"(", 
                RowBox[{"\[DifferentialD]", "g"}], ")"}], 
               StyleBox[GridBox[{
                  {" ", " "},
                  {"a", "b"}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`LCDer[-$CellContext`c][
           $CellContext`dlg[-$CellContext`a, -$CellContext`b]],
          Editable->False]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xCPS`WWedge[
        $CellContext`dlg[$CellContext`b, $CellContext`c], 
        $CellContext`LCDer[-$CellContext`c][
         $CellContext`dlg[-$CellContext`a, -$CellContext`b]]],
       Editable->False], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.963934862468485*^9, 3.9639358358593197`*^9, 
  3.963954611885044*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"1293a3a4-8b84-9a46-9cf5-45867d74e748"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Remark:",
  FontWeight->"Bold"],
 StyleBox[" The symbol \:2a55 denotes the wedge operation in the space of \
fields, i.e., the antisymmetrized tensor product in the infinite-dimensional \
space of fields. A detailed explanation will be provided in Section ",
  FontWeight->"Plain"],
 StyleBox[
 CounterBox["Chapter", "Section DefTensor"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Section DefTensor"],
  FontWeight->"Plain",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Section DefTensor"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[".",
  FontWeight->"Plain"]
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.959573346626133*^9, 3.9595733471500225`*^9}, {
   3.959574094991453*^9, 3.9595741072339973`*^9}, {3.9649565547085915`*^9, 
   3.964956679467291*^9}, {3.9649569798154297`*^9, 3.964957284088295*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"daf78eac-b4fa-5d43-bb77-0e0c936d1ca9"],

Cell["\<\
If we want to indicate that the only variable field is \[Phi] (thus \
\[DifferentialD]g=0):\
\>", "Text",
 CellChangeTimes->{{3.950558921339657*^9, 3.950559000453705*^9}, 
   3.950965496114532*^9, {3.950978949224764*^9, 3.950978953849434*^9}, {
   3.9510502092542305`*^9, 3.951050220247656*^9}, {3.953730289748001*^9, 
   3.9537303053820915`*^9}, {3.9580409317692604`*^9, 
   3.9580409339365635`*^9}},ExpressionUUID->"b24d02aa-de41-e645-b15b-\
b019664ab6a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymplecticCurrent", "[", "phi", "]"}], "[", "Lscalar", "]"}], "//",
    "ContractMetric"}], "//", "Simplification"}]], "Input",
 CellChangeTimes->{{3.953730307830801*^9, 3.953730308212656*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"dfbfe68f-1440-574a-bf2b-63aed2975436"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]}]]}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"(", 
         RowBox[{"\[DifferentialD]", "\[Phi]"}], ")"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`dlphi[],
       Editable->False], "\:2a55", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "a"], 
         RowBox[{"(", 
          RowBox[{"\[DifferentialD]", "\[Phi]"}], ")"}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`a][
        $CellContext`dlphi[]],
       Editable->False]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xCPS`WWedge[
     $CellContext`dlphi[], 
     $CellContext`LCDer[-$CellContext`a][
      $CellContext`dlphi[]]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{3.957341641684513*^9, 3.9577633934132404`*^9, 
  3.957785946754429*^9, 3.9577875553074026`*^9, 3.95778950275281*^9, 
  3.9580651003382072`*^9, 3.9581263666937904`*^9, 3.9582146263685913`*^9, 
  3.9595014339435215`*^9, 3.960641599671564*^9, 3.9606428603014374`*^9, 
  3.963934907801771*^9, 3.9639358395054264`*^9, 3.963954615104927*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"de5d1fff-2701-2140-bf0e-b81cd9055aba"]
}, Open  ]],

Cell[TextData[{
 "which is (up to some technicalities ",
 StyleBox["[",
  FontColor->RGBColor[0., 0., 0.],
  Background->RGBColor[1., 1., 1.]],
 StyleBox[
 CounterBox["ItemNumbered", 
  "bibliography juan Margalef and Eduardo J.S. Villase\[NTilde]or"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 StyleBox["]",
  FontColor->RGBColor[0., 0., 0.],
  Background->RGBColor[1., 1., 1.]],
 ") the canonical symplectic structure (position times momenta)."
}], "Text",
 CellChangeTimes->{{3.950558921339657*^9, 3.950559000453705*^9}, 
   3.950965496114532*^9, {3.950978949224764*^9, 3.950978953849434*^9}, {
   3.9510502092542305`*^9, 3.951050220247656*^9}, {3.953730289748001*^9, 
   3.953730365890667*^9}, {3.957820716108282*^9, 3.9578207179538975`*^9}, {
   3.957887843117309*^9, 3.957887844525053*^9}, 3.9578879067029247`*^9, {
   3.9579551693280296`*^9, 3.9579551981382227`*^9}, {3.958040949114891*^9, 
   3.958040949649748*^9}, 
   3.959501618775902*^9},ExpressionUUID->"27b7e5b6-0cd4-c049-845b-\
69b752cd413f"],

Cell[TextData[{
 StyleBox["Warning:",
  FontWeight->"Bold"],
 " One has to be careful when comparing formulas from books and articles, \
first because of the sign convention ",
 Cell[BoxData[
 Cell[TextData[Cell[BoxData[
  "$SymplecticCurrentSign"], "InlineCode",ExpressionUUID->
   "a0745047-2dde-2044-b78a-e9d59c8dd6ce"]], "InlineCode",ExpressionUUID->
   "fa092c03-4291-cf4d-93f5-91348bbb4975"]], "InlineCode",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "6e877a08-d0da-5e49-bf38-bba29335a072"],
 ", and second because the integration introduces a minus sign due to the \
orientations."
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"2c43473c-47ee-b34f-8e34-c2dc7dbec72a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Wald\[CloseCurlyQuote]s entropy"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.95020899049176*^9, 3.9502090017014527`*^9}, {3.95020908165974*^9, 
   3.9502090848109665`*^9}, {3.950209898836437*^9, 3.950209900451885*^9}, {
   3.9502099457479115`*^9, 3.9502099463939137`*^9}, {3.951856111929512*^9, 
   3.9518561337222595`*^9}, {3.9555241733477097`*^9, 3.955524174433041*^9}, 
   3.958131801629034*^9, {3.959501456077713*^9, 
   3.959501456462221*^9}},ExpressionUUID->"6588c3dc-5bd6-de4c-a85b-\
5c264fb783d1"],

Cell[TextData[{
 "We can easily compute some terms appearing in the computation of the Wald\
\[CloseCurlyQuote]s entropy [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography Wald"],
  FontColor->RGBColor[1., 0., 0.]],
 "]:"
}], "Text",
 CellChangeTimes->{{3.950558921339657*^9, 3.950559000453705*^9}, 
   3.950965496114532*^9, {3.950978949224764*^9, 3.950978953849434*^9}, {
   3.9510502092542305`*^9, 3.951050220247656*^9}, {3.953730289748001*^9, 
   3.953730365890667*^9}, {3.95782069766605*^9, 3.957820744586897*^9}, 
   3.9582146461066265`*^9, {3.9582148854159756`*^9, 3.9582149040815067`*^9}, 
   3.9595016287752*^9, {3.9595739641909447`*^9, 
   3.9595739642639694`*^9}},ExpressionUUID->"92cd129b-126f-9348-8dd8-\
08594363657a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EOM", "[", "RiemannLCDer", "]"}], "[", "LGR", "]"}], "//", 
   "ContractMetric"}], "//", "Simplification"}]], "Input",
 CellChangeTimes->{{3.9518560939736576`*^9, 3.9518560950619354`*^9}, {
  3.9518561709429493`*^9, 3.9518561857084427`*^9}, {3.952188891593937*^9, 
  3.95218889177207*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"2a1c4d39-27e7-7441-b507-412de9d0c3ee"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"a", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`a, $CellContext`d],
       Editable->False]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`c],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`a, $CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "d"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`d],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.9573416737803574`*^9, 3.9577633935175953`*^9, 
  3.9577859468798265`*^9, 3.9577875554358244`*^9, 3.9577895029337006`*^9, 
  3.9581263735039005`*^9, 3.9582146405936317`*^9, 3.9595014517234077`*^9, 
  3.9606415999089375`*^9, 3.960642860489889*^9, 3.9639546288597507`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"4470e521-cf25-dd43-9f3e-3575ccea48c9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Noether symmetries"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823495343562*^9}, {
   3.948823721434247*^9, 3.9488237235375814`*^9}, {3.9502102197680397`*^9, 
   3.950210221038788*^9}, {3.958241349727337*^9, 3.95824135259857*^9}, 
   3.9595800449566402`*^9},
 CellTags->
  "Sub Symmetries",ExpressionUUID->"c9d01500-199c-594e-a2e8-f6c0129f0c4e"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Variational Vector Fields (VVF)"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.9505417846854916`*^9, 
   3.9505420882956924`*^9, 3.954947256376705*^9, 3.960656604652746*^9},
 CellTags->
  "Subsub VVF",ExpressionUUID->"ef31c193-cea2-5a4b-8745-c5ddf31a8de4"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"VVFFromLieD", "[", "vector", "]"}], "[", "tensors", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"94a7bf21-e889-bc4e-967d-0b85e9ca9ed9"],
 "\nIt defines the variational vector field\n",
 StyleBox["\n",
  FontSize->4],
 "    ",
 Cell[BoxData[
  FormBox[
   TemplateBox[<|"boxes" -> FormBox[
       UnderscriptBox["\[Sum]", 
        RowBox[{"tensor", "\[Element]", 
          RowBox[{"{", "tensors", "}"}]}], LimitsPositioning -> True], 
       TraditionalForm], "errors" -> {}, "input" -> 
     "\\sum_{\\text{tensor}\\in\\{\\text{tensors}\\}}", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"], TraditionalForm]],ExpressionUUID->
  "819b67a0-4fb7-4d4e-a812-0e3c1e6b2e93"],
 Cell[BoxData[
  RowBox[{
   RowBox[{"LieD", "[", "vector", "]"}], "[", "tensor", "]"}]], "InlineCode",
  ExpressionUUID->"5a50888e-6abd-624c-9d86-d0449dd37c8c"],
 "\:2a55",
 Cell[BoxData[
  RowBox[{"VariationalVector", "[", "tensor", "]"}]], "InlineCode",
  ExpressionUUID->"ab2521ed-70e9-9647-a61b-3f08fbe7d51f"],
 "\n",
 StyleBox["\n",
  FontSize->4],
 " with the appropriate contracted indices."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952437183018958*^9, 3.9524372085839415`*^9}, {
   3.9524372818303075`*^9, 3.952437400808908*^9}, 3.9526904491775203`*^9, {
   3.953086717072216*^9, 3.953086744422722*^9}, 3.9544805056591763`*^9, {
   3.954505009170573*^9, 3.954505022966942*^9}, {3.954649773421836*^9, 
   3.9546497859023123`*^9}, {3.95465114842006*^9, 3.954651157760322*^9}, 
   3.9546666442743835`*^9, {3.9546666763861275`*^9, 3.9546666786754775`*^9}, 
   3.954667050909913*^9, {3.954758506050603*^9, 3.954758518361339*^9}, 
   3.9547589238892612`*^9, {3.954760260542954*^9, 3.954760291523525*^9}, {
   3.9559658879315796`*^9, 3.955965914857905*^9}, {3.955965948742859*^9, 
   3.955966006791397*^9}, {3.9576150349415607`*^9, 3.9576150691213374`*^9}, {
   3.9578839520223207`*^9, 3.957883954618168*^9}, {3.9578859718781395`*^9, 
   3.957885976777418*^9}, {3.957958196054119*^9, 3.9579582118136787`*^9}, {
   3.9581426813137074`*^9, 3.9581427178968983`*^9}, {3.9581427550899506`*^9, 
   3.958142799207258*^9}, {3.958244950627363*^9, 3.9582449512913246`*^9}, 
   3.9639546460204296`*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"a231df93-4875-5447-8e78-7e451d6a7a8b"],

Cell[TextData[{
 "We call variational vector fields (",
 Cell[BoxData[
 "VVF"], "InlineCode",ExpressionUUID->"965044b1-ae18-074d-8a86-f53ad5a991b3"],
 ") to the vector fields over the space of fields. ",
 Cell[BoxData[
 "VVFs"], "InlineCode",ExpressionUUID->"0ec2620b-81a5-b549-9771-5510fd019499"],
 " together with the corresponding commands, will be explained in detail on \
Section",
 StyleBox[" ",
  FontColor->RGBColor[0., 0., 0.]],
 StyleBox[
 CounterBox["Chapter", 
  "Section Variational Vectors and Variational vector fields"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Section Variational Vectors and Variational vector fields"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", 
  "Section Variational Vectors and Variational vector fields"],
  FontColor->RGBColor[0., 0., 1.]],
 ", but roughly speaking, they describe the infinitesimal transformation \
(first order perturbation) in the space of fields. On ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " they are defined as scalar where each monomial has a variational vector \
(with no ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"8a2fb313-829d-cd48-98cc-73e847fb42f5"],
 ", ",
 Cell[BoxData[
 "LieD"], "InlineCode",ExpressionUUID->"02a687aa-ee46-fe47-a006-84593c184143"],
 "... in front of it). For instance: "
}], "Text",
 CellChangeTimes->{{3.950890725771528*^9, 3.950890813166151*^9}, {
   3.950891151895956*^9, 3.950891192876438*^9}, 3.950979235843897*^9, {
   3.951847841185192*^9, 3.9518478714378815`*^9}, 3.95243801098977*^9, 
   3.9559404534959836`*^9, 3.9564081505958815`*^9, {3.9578207963643456`*^9, 
   3.9578207981901684`*^9}, {3.9578208292051067`*^9, 3.957820857130728*^9}, 
   3.9578880466625032`*^9, 3.957888141854601*^9, {3.9580409740145416`*^9, 
   3.958040998214014*^9}, {3.958065229770586*^9, 3.9580652889278393`*^9}, {
   3.958066181890003*^9, 3.958066182497841*^9}, {3.9580871215641327`*^9, 
   3.958087126335018*^9}, 3.9581426563216743`*^9, {3.958608738137022*^9, 
   3.9586087381431446`*^9}, {3.958608776553914*^9, 3.958608779162945*^9}, 
   3.9586088269726906`*^9, {3.958610849811759*^9, 3.958610849811759*^9}, {
   3.959501476577183*^9, 3.9595015062408504`*^9}, 3.959501562233099*^9, {
   3.959657754029436*^9, 
   3.959657754960079*^9}},ExpressionUUID->"ad4b32e1-efce-cc44-9838-\
00b4c79d3110"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vvf1", "=", 
  RowBox[{
   RowBox[{"VVFFromLieD", "[", "xi", "]"}], "[", "phi", "]"}]}]], "Input",
 CellChangeTimes->{{3.950381286141217*^9, 3.950381286416438*^9}, {
   3.950541881494766*^9, 3.950541882099037*^9}, 3.950542074827032*^9, {
   3.950811124075039*^9, 3.9508111289426136`*^9}, {3.9508112154569817`*^9, 
   3.950811230980673*^9}, {3.9508906994310703`*^9, 3.950890710000309*^9}, {
   3.9508908211433544`*^9, 3.950890836617323*^9}, {3.950890945906481*^9, 
   3.950890946874714*^9}, 3.950967663256911*^9, {3.953664827228071*^9, 
   3.953664827923744*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"1479bc16-a7bf-9247-8f3a-2b034dfb4a29"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{"(", 
     FractionBox["\[Delta]", "\[Delta]\[Phi]"], ")"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`VariationalVectorphi[],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`LieD[
     $CellContext`xi[$CellContext`a]][
     $CellContext`phi[]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{3.957341696830438*^9, 3.9577633935455327`*^9, 
  3.9577859468956103`*^9, 3.957787555469059*^9, 3.9577895029620924`*^9, 
  3.9578208601594276`*^9, 3.9580658119961605`*^9, 3.9581263776866436`*^9, 
  3.958214922502735*^9, 3.959501512770529*^9, 3.9606415999407215`*^9, 
  3.9606428605374584`*^9, 3.9639358563686504`*^9, 3.9639546577658424`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"174aff49-682f-c049-97c4-936394d62cf8"]
}, Open  ]],

Cell[TextData[{
 "describes the infinitesimal transformation (see [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography CPS JMB-EJSV"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 ",",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography Anderson"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 "]) given by the Lie Derivative:",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{"\[Phi]", "->", 
    RowBox[{"\[Phi]", "+", 
     RowBox[{
      SubscriptBox["\[Epsilon]\[ScriptCapitalL]", "\[Xi]"], "\[Phi]"}]}]}]}]],
  ExpressionUUID->"7f73f3bc-9676-8a45-9bfa-f4d36ff63e17"],
 "."
}], "Text",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
   3.950891068130377*^9, 3.950891115738426*^9}, 3.950965573694145*^9, {
   3.9509676118564453`*^9, 3.950967618841339*^9}, {3.9519256042299004`*^9, 
   3.9519256218631096`*^9}, {3.953698925117547*^9, 3.9536989307336264`*^9}, {
   3.957443532232484*^9, 3.9574435347121444`*^9}, 3.9577634245879755`*^9, {
   3.957883104174959*^9, 3.957883104174959*^9}, {3.9578834416070175`*^9, 
   3.9578834416070175`*^9}, {3.958065310639015*^9, 3.9580653108613605`*^9}, {
   3.9595015210725365`*^9, 3.959501521385687*^9}, {3.9595015765754013`*^9, 
   3.9595015845696716`*^9}, {3.9595740913493824`*^9, 
   3.9595740927790413`*^9}},ExpressionUUID->"c0f301ad-00bb-b74e-b2b0-\
babb20f06687"],

Cell[TextData[{
 StyleBox["Remark:",
  FontWeight->"Bold"],
 StyleBox[" In the physics literature a formal integral is usually added:",
  FontWeight->"Plain"]
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.959573346626133*^9, 3.9595733471500225`*^9}, {
   3.959574094991453*^9, 3.9595741072339973`*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"c01d3e42-dd20-e34a-9bd8-c4ef62040fd9"],

Cell[BoxData[
 RowBox[{"vvf1", "=", 
  RowBox[{"\[Integral]", " ", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`LieD[
       $CellContext`xi[$CellContext`a]][
       $CellContext`phi[]],
      Editable->False], ")"}], 
    InterpretationBox[
     StyleBox[
      RowBox[{"(", 
       FractionBox["\[Delta]", "\[Delta]\[Phi]"], ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VariationalVectorphi[],
     Editable->False], " "}]}]}]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
   3.950891068130377*^9, 3.950891115738426*^9}, {3.9509655767745647`*^9, 
   3.950965590180704*^9}, {3.950965892261614*^9, 3.950965893117519*^9}, 
   3.951847905478216*^9, 3.9573417025645223`*^9, {3.9595015317419815`*^9, 
   3.9595015323601704`*^9}},
 TextAlignment->Center,
 CellTags->
  "eq: exampleVVFLieD",ExpressionUUID->"eb02a151-66dd-874d-8cfa-a9a6d21e22ea"],

Cell[TextData[{
 "But from an operational point of view, it plays no role and, in order to \
take advantage of the ",
 StyleBox["xAct",
  FontWeight->"Bold"],
 " framework, we will simply consider the scalar integrand."
}], "Text",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
   3.950891068130377*^9, 3.950891115738426*^9}, 3.9509655826310997`*^9, {
   3.9518479101821384`*^9, 3.951847920280018*^9}, 3.955940589213022*^9, {
   3.957820876248888*^9, 3.9578208848184566`*^9}, {3.958065324598648*^9, 
   3.9580653290452156`*^9}},ExpressionUUID->"3b633e56-b790-9148-b99b-\
782fb06beadc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". NoetherSymmetryQ"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.9505417846854916`*^9, 
   3.9505420882956924`*^9, 3.9606566076011505`*^9},
 CellTags->
  "Subsub NoetherSymmetryQ",ExpressionUUID->"0e84cfda-96f9-3046-ab6a-\
3da3713affa2"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"NoetherSymmetryQ", "[", "vvf", "]"}], "[", "metric", "]"}], "[", 
    RowBox[{"Lagrangian", ",", " ", "options"}], "]"}],
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",
  FontWeight->"Bold",ExpressionUUID->"9c19c313-88aa-0147-a821-3e06bcb24254"],
 StyleBox["\n",
  FontSize->5],
 "It tests if the vector field ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"vvf", "'"}]}]], "InlineCode",ExpressionUUID->
  "85af4fcb-8187-6943-ab43-49335e7a1b69"],
 " is a Noether symmetry of ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"Lagrangian", "'"}]}]], "InlineCode",ExpressionUUID->
  "db060c24-00b0-ea49-9a89-be0ebf279511"],
 " using ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"metric", "'"}]}]], "InlineCode",ExpressionUUID->
  "f7e2a4d4-1256-1543-9cab-c40701c85029"],
 ".\n",
 StyleBox["\n",
  FontSize->3],
 "- ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"optionalfunctions", "'"}]}]], "InlineCode",ExpressionUUID->
  "4afc7bb1-d9e6-8649-b27f-30ef5863dd2f"],
 ": Optional functions to be applied in the middle steps of the algorithm.",
 StyleBox["\n",
  FontSize->3],
 "- Option:\n  \:2217 ",
 Cell[BoxData[
  RowBox[{"CheckZero", "\[RightArrow]", "True"}]], "InlineCode",
  ExpressionUUID->"5e727327-e8db-c248-a2a2-ed50219c1f98"],
 " uses === instead of == to test if EOMs vanish."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.950539089543873*^9, 3.9505391249603176`*^9}, {
   3.95055977813818*^9, 3.9505597970005913`*^9}, {3.950890426844431*^9, 
   3.950890568838234*^9}, {3.950891597580612*^9, 3.9508916236827087`*^9}, {
   3.950979002120119*^9, 3.950979037848913*^9}, {3.951928621803108*^9, 
   3.9519286950922184`*^9}, {3.95234349307422*^9, 3.952343501753726*^9}, 
   3.9523435333980665`*^9, {3.9523469244048376`*^9, 3.9523469266879983`*^9}, {
   3.952690609500397*^9, 3.952690624218032*^9}, {3.952690656003931*^9, 
   3.9526906720767503`*^9}, 3.952690724032263*^9, 3.9526907814870386`*^9, {
   3.953087739126498*^9, 3.9530877650352526`*^9}, 3.9544812109777718`*^9, {
   3.955940731709494*^9, 3.9559407382767196`*^9}, {3.9559412544381933`*^9, 
   3.9559412738348007`*^9}, {3.9567208197408233`*^9, 
   3.9567209622650814`*^9}, {3.957073707820486*^9, 3.957073726238696*^9}, {
   3.9576139765093627`*^9, 3.957613976875535*^9}, {3.957820905070303*^9, 
   3.957820941368284*^9}, {3.9578209744424*^9, 3.957821000834921*^9}, {
   3.958065339717169*^9, 3.958065371269455*^9}, {3.958065997990139*^9, 
   3.958066001962103*^9}, 3.958066049989231*^9, 3.958066263833351*^9, 
   3.9580663522734795`*^9, 3.9580666042648735`*^9, {3.9580705016459007`*^9, 
   3.95807051447093*^9}, 3.958080861356016*^9, {3.958146478174059*^9, 
   3.9581464915659714`*^9}, {3.9582443994402695`*^9, 3.958244411589409*^9}, 
   3.9595769412322254`*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"4f8da5f3-e9f2-004f-b2c5-9074aefc7837"],

Cell[TextData[{
 "This function checks if the transformation ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"VertLie", "[", "vvf", "]"}], "[", "Lagrangian", "]"}],
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "538b0775-a778-b24f-b47d-0fe50b594984"],
 " is a total divergence using an auxiliary metric (see [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography CPS JMB-EJSV"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 "] and Section ",
 StyleBox[
 CounterBox["Chapter", "section VertLie"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"section VertLie"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "section VertLie"],
  FontColor->RGBColor[0., 0., 1.]],
 " for further details). The way to check if the expression is a total \
divergence is through ",
 Cell[BoxData[
  StyleBox["DivergenceQ",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "63ef6687-d98a-3b44-8e2c-53ec6ee20a56"],
 " (explained below in Subsection",
 ButtonBox[" ",
  BaseStyle->"Hyperlink",
  ButtonData->"2.2.1 DivergenceQ"],
 StyleBox[
 CounterBox["Chapter", "Sub DivergenceQ"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub DivergenceQ"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Sub DivergenceQ"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub DivergenceQ"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsection", "Sub DivergenceQ"],
  FontColor->RGBColor[0., 0., 1.]],
 "), which makes sure that the EOMs with respect to each field appearing in \
the expression are zero."
}], "Text",
 CellChangeTimes->{
  3.9559412558734083`*^9, {3.955941341266941*^9, 3.955941352041628*^9}, {
   3.956140584950467*^9, 3.9561405898509407`*^9}, {3.957396422652643*^9, 
   3.957396427416212*^9}, {3.9573973252996264`*^9, 3.9573973262469416`*^9}, {
   3.9573976867668233`*^9, 3.9573977053847923`*^9}, {3.957443566004008*^9, 
   3.9574435696023097`*^9}, {3.957821152198822*^9, 3.957821180243801*^9}, 
   3.9578879788846035`*^9, {3.957955328435647*^9, 3.957955335576867*^9}, {
   3.9579553663267975`*^9, 3.9579554369394236`*^9}, {3.9579565323808966`*^9, 
   3.95795654247974*^9}, {3.9580411294042797`*^9, 3.958041146772434*^9}, {
   3.9580654685291443`*^9, 3.9580655990806637`*^9}, {3.958065763048317*^9, 
   3.9580657801590843`*^9}, {3.9580660979098473`*^9, 3.9580661021223354`*^9}, 
   3.9580663575732136`*^9, {3.958244199134548*^9, 3.958244205853815*^9}, 
   3.958244619747898*^9, {3.9583927820323524`*^9, 3.958392782330429*^9}, {
   3.9586109047890377`*^9, 3.958610917004362*^9}, {3.959501639843096*^9, 
   3.9595016701749744`*^9}, 3.959501713377676*^9, {3.9595018405154552`*^9, 
   3.9595018435560036`*^9}, {3.95950187868293*^9, 3.9595019180635223`*^9}, 
   3.9595787467938194`*^9, 
   3.9595788604818287`*^9},ExpressionUUID->"5a066462-dfd2-c649-b045-\
610d86424a41"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Remark: ",
  FontWeight->"Bold"],
 "If no EOMs are present, that actually means that the term is topological. \
This is equivalent to be a divergence if we assume that the vector bundle is \
contractible (see [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography CPS JMB-EJSV"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 "] for further detail). There are of course topological Lagrangians that are \
not global divergences (just pointwise) like the Gauss-Bonnet term in \
dimension\[LessEqual]4 or Einstein-Hilbert Lagrangian in dimension=2 (see \
also [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography Anderson"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 ", Example 5.10 on page 207] for an interesting example of a non-exact \
Lagrangian with no EOM)."
}], "Item",
 CellChangeTimes->{
  3.9576104325492887`*^9, {3.957826897006893*^9, 3.9578269198545933`*^9}, {
   3.9580664561762886`*^9, 3.958066473862076*^9}, {3.95824462306336*^9, 
   3.9582446488133335`*^9}, {3.9582446798232136`*^9, 
   3.9582446972454815`*^9}, {3.95950169412018*^9, 3.959501717235277*^9}, 
   3.95957158978541*^9, 3.9639357943542767`*^9},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"fd808861-9c44-5445-a2f1-f214ba373122"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NoetherSymmetryQ", "[", "vvf1", "]"}], "[", "g", "]"}], "[", 
  "Lscalar", "]"}]], "Input",
 CellChangeTimes->{3.950890693913173*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"f4b1ed34-f5ae-6143-abc5-665b83e827f6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`phi[]],
      Editable->False]}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[$CellContext`b][
       $CellContext`phi[]]],
     Editable->False]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`a]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], 
        SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`LCDer[$CellContext`b][
        $CellContext`phi[]]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`a][
       $CellContext`phi[]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], 
        SuperscriptBox["\[Del]", "b"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {" "},
              {"a"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`LCDer[$CellContext`b][
        $CellContext`xi[-$CellContext`a]]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`a],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "a"], 
          SubscriptBox["\[Del]", "b"], 
          SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`LCDer[-$CellContext`b][
          $CellContext`LCDer[$CellContext`b][
           $CellContext`phi[]]]],
        Editable->False], "-", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "b"], 
          SuperscriptBox["\[Del]", "b"], 
          SubscriptBox["\[Del]", "a"], "\[Phi]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`b][
         $CellContext`LCDer[$CellContext`b][
          $CellContext`LCDer[-$CellContext`a][
           $CellContext`phi[]]]],
        Editable->False]}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], 
        SubscriptBox["\[Del]", "a"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`LCDer[-$CellContext`a][
        $CellContext`phi[]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "b"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`b][
       $CellContext`xi[$CellContext`a]],
      Editable->False]}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SuperscriptBox["\[Del]", "c"], "\[Phi]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`LCDer[$CellContext`c][
          $CellContext`phi[]],
         Editable->False]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "a"], GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {" "},
                   {"c"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`a][
            $CellContext`xi[-$CellContext`c]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`b][
            $CellContext`phi[]],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`a][
            $CellContext`phi[]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "b"], GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {" "},
                   {"c"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`b][
            $CellContext`xi[-$CellContext`c]],
           Editable->False]}], "-", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"g", 
               StyleBox[GridBox[{
                  {"a", "b"},
                  {" ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`g[$CellContext`a, $CellContext`b],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "d"], GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {" "},
                   {"c"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`d][
            $CellContext`xi[-$CellContext`c]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "d"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`d][
            $CellContext`phi[]],
           Editable->False]}]}], ")"}]}], "-", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`c],
        Editable->False], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`b][
            $CellContext`phi[]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "c"], 
             SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`c][
            $CellContext`LCDer[$CellContext`a][
             $CellContext`phi[]]],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`a][
            $CellContext`phi[]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "c"], 
             SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`c][
            $CellContext`LCDer[$CellContext`b][
             $CellContext`phi[]]],
           Editable->False]}], "-", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"g", 
               StyleBox[GridBox[{
                  {"a", "b"},
                  {" ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`g[$CellContext`a, $CellContext`b],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "d"], 
             SubscriptBox["\[Del]", "c"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`d][
            $CellContext`LCDer[-$CellContext`c][
             $CellContext`phi[]]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "d"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`d][
            $CellContext`phi[]],
           Editable->False]}]}], ")"}]}]}], ")"}]}], "\[Equal]", 
   "0"}]}]], "Output",
 CellChangeTimes->{3.9573417266917562`*^9, 3.957763394274375*^9, 
  3.957785947738306*^9, 3.957787556260854*^9, 3.957789504160511*^9, 
  3.9580657841407986`*^9, 3.958065816243738*^9, 3.958126384973646*^9, 
  3.958215043524233*^9, 3.959501708286188*^9, 3.9606416011787224`*^9, 
  3.9606428616884155`*^9, 3.9639358630724964`*^9, 3.963954671466711*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"b287811c-a1f6-1440-b1f6-a677a55439b6"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "If the expressions are not immediately zero, the function does not return ",
 Cell[BoxData[
 "False"], "InlineCode",ExpressionUUID->
  "1e381c14-cae5-9f40-8851-9ede76e2ee83"],
 " because in some cases certain functions/rules might render such expression \
zero. Since in general we have several conditions (joined by AND), we cannot \
apply at the end some functions to simplify the expression. However, we can \
apply the functions within ",
 Cell[BoxData[
 "NoetherSymmetryQ"], "InlineCode",ExpressionUUID->
  "e4e5db32-23f0-784a-ad14-b97cb85e61fd"],
 " as optional arguments:"
}], "Text",
 CellChangeTimes->{{3.9505391305734158`*^9, 3.950539155610319*^9}, {
   3.9505392215851345`*^9, 3.9505392881745834`*^9}, {3.950560166861574*^9, 
   3.950560183008606*^9}, {3.9506281158827686`*^9, 3.950628135187172*^9}, {
   3.9508847334243546`*^9, 3.950884776842243*^9}, {3.950884842574505*^9, 
   3.950884903675745*^9}, {3.950884968636492*^9, 3.9508850148463497`*^9}, {
   3.950890586619335*^9, 3.950890661124151*^9}, 3.952343595707365*^9, {
   3.952343799196994*^9, 3.9523438057149343`*^9}, 3.9524380487627926`*^9, 
   3.954664165492217*^9, 3.9574435598190103`*^9, {3.958244799235737*^9, 
   3.9582448173705864`*^9}},ExpressionUUID->"0877336a-09e4-d046-ad2c-\
11896464a8fd"],

Cell[TextData[Cell[BoxData[Cell[TextData[Cell[BoxData[
 Cell[TextData[Cell[BoxData[
   RowBox[{
    RowBox[{
     RowBox[{"NoetherSymmetryQ", "[", "vvf", "]"}], "[", "metric", "]"}], "[", 
    RowBox[{"Lagrangian", ",", 
     SubscriptBox["function", "1"], ",", 
     SubscriptBox["function", "2"], ",", "...", ",", 
     SubscriptBox["function", "k"]}], "]"}]], "InlineCode",ExpressionUUID->
   "e9ed260e-ec56-1344-b4b6-13ad5ab95dc8"]], "InlineCode",ExpressionUUID->
   "43cd122b-7b31-d14b-9913-3dc55cd7c528"]], "InlineCode",ExpressionUUID->
  "7ddbf1b1-8bc5-0d49-8b7c-fb4013754358"]], "InlineCode",ExpressionUUID->
  "c469aee4-3b4f-1e41-958a-1c139043aa24"]], \
"InlineCode",ExpressionUUID->"bdfc7115-ffe3-6946-bcf0-624bbe18727d"]], "Text",
 CellChangeTimes->{{3.9523438107249174`*^9, 3.9523438262532105`*^9}, {
  3.9578212932627583`*^9, 3.9578212979350014`*^9}, {3.9578898235788665`*^9, 
  3.9578898281811*^9}, {3.958041053110283*^9, 3.95804105927948*^9}},
 TextAlignment->Center,
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"65827814-d2cc-8d49-b495-58e546511e78"],

Cell[TextData[{
 "The functions are applied in order of appearance: ",
 Cell[BoxData[
 Cell[TextData[Cell[BoxData[
  Cell[TextData[Cell[BoxData[Cell[TextData[Cell[BoxData[Cell[TextData[{
      Cell[BoxData[
       RowBox[{"//", 
        SubscriptBox["function", "1"]}]],ExpressionUUID->
       "338114cb-1bbf-3445-b5ea-ffbcd2d81fbb"],
      "//",
      Cell[BoxData[
       SubscriptBox["function", "2"]],ExpressionUUID->
       "837564e9-856e-4b48-983f-961641357ac6"],
      "//\[CenterDot]\[CenterDot]\[CenterDot]//",
      Cell[BoxData[
       SubscriptBox["function", "k"]],ExpressionUUID->
       "309d5452-0777-594f-b48b-4410aa18642e"]
     }], "InlineCode",ExpressionUUID->
      "b594e497-3a87-a34d-85cb-e67419b53491"]], "InlineCode",ExpressionUUID->
     "7099189b-6cb6-6d48-8405-5c30d6353bce"]], "InlineCode",ExpressionUUID->
     "bb17afd0-0602-524a-b562-5a085656a3bd"]], "InlineCode",ExpressionUUID->
    "3aa703d8-7150-fb4a-ae4f-776971e39e1c"]], "InlineCode",ExpressionUUID->
    "fdd71434-7040-494d-873d-d6e571ae6d63"]], "InlineCode",ExpressionUUID->
   "b96ea20b-9305-344f-8b29-3ac2f762f98e"]], "InlineCode",ExpressionUUID->
   "2759d94b-0026-df42-9f02-586076e1da71"]], "InlineCode",ExpressionUUID->
  "be4cfe1d-86ce-124f-a9a7-08a5b21beb68"]
}], "Text",
 CellChangeTimes->{
  3.9523438194045515`*^9, 3.9524381085173283`*^9, 3.9546641999193363`*^9, {
   3.957073820783974*^9, 3.9570738547174654`*^9}, {3.9580410662485695`*^9, 
   3.9580411105385265`*^9}, {3.9580658062962437`*^9, 
   3.9580658064853115`*^9}},ExpressionUUID->"ac2c838c-7cd9-b843-9ca4-\
75018117640e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NoetherSymmetryQ", "[", "vvf1", "]"}], "[", "g", "]"}], "[", 
  RowBox[{"Lscalar", ",", "SortCovDs"}], "]"}]], "Input",
 CellChangeTimes->{{3.950811264469317*^9, 3.950811313714216*^9}, {
   3.950882770269766*^9, 3.950882793385252*^9}, 3.950884934888357*^9, 
   3.9508852851484165`*^9, 3.950890695675173*^9, {3.9512328524662857`*^9, 
   3.951232868443262*^9}, {3.951244910881197*^9, 3.951244967058239*^9}, {
   3.951247375197088*^9, 3.951247380408787*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"9d727d1b-4c88-2142-9aee-d5cfe1c35aad"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`phi[]],
      Editable->False]}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[$CellContext`b][
       $CellContext`phi[]]],
     Editable->False]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`a]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], 
        SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`LCDer[$CellContext`b][
        $CellContext`phi[]]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`a][
       $CellContext`phi[]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], 
        SuperscriptBox["\[Del]", "b"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {" "},
              {"a"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`LCDer[$CellContext`b][
        $CellContext`xi[-$CellContext`a]]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[Del]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciLCDer[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`b][
       $CellContext`phi[]],
      Editable->False]}], "-", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], 
        SubscriptBox["\[Del]", "a"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`LCDer[-$CellContext`a][
        $CellContext`phi[]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "b"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`b][
       $CellContext`xi[$CellContext`a]],
      Editable->False]}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SuperscriptBox["\[Del]", "c"], "\[Phi]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`LCDer[$CellContext`c][
          $CellContext`phi[]],
         Editable->False]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "a"], GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {" "},
                   {"c"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`a][
            $CellContext`xi[-$CellContext`c]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`b][
            $CellContext`phi[]],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`a][
            $CellContext`phi[]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "b"], GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {" "},
                   {"c"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`b][
            $CellContext`xi[-$CellContext`c]],
           Editable->False]}], "-", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"g", 
               StyleBox[GridBox[{
                  {"a", "b"},
                  {" ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`g[$CellContext`a, $CellContext`b],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "d"], GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {" "},
                   {"c"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`d][
            $CellContext`xi[-$CellContext`c]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "d"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`d][
            $CellContext`phi[]],
           Editable->False]}]}], ")"}]}], "-", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`c],
        Editable->False], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`b][
            $CellContext`phi[]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "c"], 
             SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`c][
            $CellContext`LCDer[$CellContext`a][
             $CellContext`phi[]]],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`a][
            $CellContext`phi[]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "c"], 
             SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`c][
            $CellContext`LCDer[$CellContext`b][
             $CellContext`phi[]]],
           Editable->False]}], "-", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"g", 
               StyleBox[GridBox[{
                  {"a", "b"},
                  {" ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`g[$CellContext`a, $CellContext`b],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "d"], 
             SubscriptBox["\[Del]", "c"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`d][
            $CellContext`LCDer[-$CellContext`c][
             $CellContext`phi[]]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SuperscriptBox["\[Del]", "d"], "\[Phi]"}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[$CellContext`d][
            $CellContext`phi[]],
           Editable->False]}]}], ")"}]}]}], ")"}]}], "\[Equal]", 
   "0"}]}]], "Output",
 CellChangeTimes->{3.957341735244346*^9, 3.957763395017709*^9, 
  3.9577859485616817`*^9, 3.957787557079999*^9, 3.9577895052490654`*^9, 
  3.9580658200150013`*^9, 3.9581263951779156`*^9, 3.9582150400725765`*^9, 
  3.959501752783558*^9, 3.9606416023384285`*^9, 3.9606428629231834`*^9, 
  3.963954673923401*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"6d5d89e7-04e6-c547-b219-270f0038a843"]
}, Open  ]],

Cell[TextData[{
 "If one is convinced that this is not zero (as it is the case), one can add \
the option ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"CheckZero", "\[RightArrow]", "True"}],
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "5095a331-6019-b841-9d58-2c960a6948f0"],
 " which uses ",
 Cell[BoxData[
  StyleBox["===",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",
  FontColor->RGBColor[0., 0., 0.],ExpressionUUID->
  "619c0c87-3d6f-dd49-9f59-3294d0a28dae"],
 StyleBox[" ",
  FontColor->RGBColor[0., 0., 0.]],
 "instead of ",
 Cell[BoxData[
  StyleBox["==",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",
  FontColor->RGBColor[0., 0., 0.],ExpressionUUID->
  "cf18e30f-5b89-4146-9369-de988e5d17ec"],
 "."
}], "Text",
 CellChangeTimes->{{3.950885196445139*^9, 3.950885234479927*^9}, {
   3.9508852661100254`*^9, 3.9508852731914883`*^9}, {3.952343848658758*^9, 
   3.9523438670946245`*^9}, 3.9524381021736145`*^9, {3.9580658328574104`*^9, 
   3.9580658335573044`*^9}, {3.959501756241911*^9, 
   3.959501756903879*^9}},ExpressionUUID->"d9459a26-4059-644d-9b8e-\
801844f1d17e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NoetherSymmetryQ", "[", "vvf1", "]"}], "[", 
   RowBox[{"g", ",", 
    RowBox[{"CheckZero", "->", "True"}]}], "]"}], "[", "Lscalar", 
  "]"}]], "Input",
 CellChangeTimes->{{3.950885077561229*^9, 3.950885086039264*^9}, {
   3.95088517941617*^9, 3.950885186827196*^9}, {3.950885281206467*^9, 
   3.950885289409176*^9}, {3.950885335684652*^9, 3.9508853389116287`*^9}, 
   3.950886914228855*^9, 3.950890697258671*^9},
 CellLabel->"In[31]:=",ExpressionUUID->"671ad5db-d980-3b42-9cef-dfc1117d14d6"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9573417406134987`*^9, 3.9577633957444196`*^9, 
  3.9577859493838453`*^9, 3.9577875578988996`*^9, 3.9577895064483905`*^9, 
  3.958065841768156*^9, 3.959501930569853*^9, 3.96064160351256*^9, 
  3.9606428641753025`*^9, 3.9639546761840725`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"34dc4150-f325-7b4a-b3b1-d7f815adfbfc"]
}, Open  ]],

Cell["We can consider another transformation like:", "Text",
 CellChangeTimes->{{3.9508909107977753`*^9, 3.9508909312335186`*^9}, 
   3.9508909660505314`*^9, 3.952438105474371*^9, 
   3.958041888190035*^9},ExpressionUUID->"2f4c9b09-7219-c642-98ab-\
ad8ec9b9af23"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vvf2", "=", 
  RowBox[{
   RowBox[{"VVFFromLieD", "[", "xi", "]"}], "[", 
   RowBox[{"g", ",", "phi"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.950890934462894*^9, 3.9508909577137165`*^9}, 
   3.9509676515607433`*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"cea843fc-8332-244b-8b96-d243f351fb28"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"(", 
         FractionBox["\[Delta]", "\[Delta]g"], ")"}], 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`VariationalVectorg[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`LieD[
      $CellContext`xi[$CellContext`a]][
      $CellContext`g[-$CellContext`a, -$CellContext`b]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"(", 
      FractionBox["\[Delta]", "\[Delta]\[Phi]"], ")"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`VariationalVectorphi[],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], "\[Phi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`LieD[
      $CellContext`xi[$CellContext`a]][
      $CellContext`phi[]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{3.9573417452185135`*^9, 3.9577633957688403`*^9, 
  3.9577859494474645`*^9, 3.957787557953499*^9, 3.9577895064750195`*^9, 
  3.9580658462541256`*^9, 3.958215021096287*^9, 3.95950193585165*^9, 
  3.9606416035762444`*^9, 3.9606428642378426`*^9, 3.9639546764056644`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"456be524-fba6-9641-9ebc-bc3b660eb582"]
}, Open  ]],

Cell[TextData[{
 "which describes the infinitesimal transformation:",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{"\[Phi]", "->", 
    RowBox[{"\[Phi]", "+", 
     RowBox[{
      SubscriptBox["\[Epsilon]\[ScriptCapitalL]", "\[Xi]"], "\[Phi]"}]}]}]}]],
  ExpressionUUID->"73ab498d-5bf6-a647-957a-34c863faafbb"],
 " and ",
 Cell[BoxData[
  RowBox[{"g", "->", 
   RowBox[{"g", "+", 
    RowBox[{
     SubscriptBox["\[Epsilon]\[ScriptCapitalL]", "\[Xi]"], "g"}]}]}]],
  ExpressionUUID->"530b37e7-48d0-9f4b-a716-27fd31928bf9"],
 " (",
 Cell[BoxData[
  RowBox[{" ", "VVF2"}]],ExpressionUUID->
  "9506606d-7b99-6c45-a4c3-6b1f15552a52"],
 " is sometimes denoted ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Delta]", "\[Xi]"], TraditionalForm]],ExpressionUUID->
  "3085aacd-eeb3-f742-adae-d4b8affe48ec"],
 " in the physics literature). This means that ",
 StyleBox["all",
  FontWeight->"Bold"],
 " fields appearing in the Lagrangian are transformed using the Lie \
derivative (no background objects are present, see [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography CPS JMB-EJSV"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 "]). In fact, whenever ",
 Cell[BoxData[
 "VVF"], "InlineCode",ExpressionUUID->"4b149eaf-6a5c-5842-af6a-dff2043d20c5"],
 " is a ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"VVFFromLieD", "[", "xi", "]"}],
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "02ae1bcd-ba1b-9045-ad3f-8cb6dcfc1118"],
 ", we always have "
}], "Text",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
   3.950891068130377*^9, 3.950891115738426*^9}, {3.95089122726511*^9, 
   3.950891365153498*^9}, {3.950891433390114*^9, 3.950891434360166*^9}, {
   3.950891512424155*^9, 3.95089152052244*^9}, {3.9509790738750134`*^9, 
   3.9509790744247723`*^9}, {3.950979116644966*^9, 3.950979217711254*^9}, 
   3.950979290222557*^9, {3.951925491527746*^9, 3.951925541648817*^9}, {
   3.9519255926911545`*^9, 3.951925595736742*^9}, {3.9523441405416765`*^9, 
   3.952344149215748*^9}, {3.952438113089548*^9, 3.952438141228546*^9}, {
   3.9580412593178596`*^9, 3.958041275360235*^9}, {3.95804190645125*^9, 
   3.9580419236235447`*^9}, {3.958065854197212*^9, 3.9580658543352566`*^9}, {
   3.9582149794717884`*^9, 
   3.958215011738039*^9}},ExpressionUUID->"6ca1dcb1-be58-d645-bef8-\
7634f1a6a099"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[DoubleStruckCapitalL]", 
    RowBox[{"VVFFromLieD", "[", "\[Xi]", "]"}]], "[", "Lagrangian", "]"}], "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["L", "\[Xi]"], "[", "Lagrangian", "]"}], "=", 
   RowBox[{"d", 
    RowBox[{"(", 
     RowBox[{
      FormBox[
       SubscriptBox["i", "\[Xi]"],
       TraditionalForm], "Lagrangian"}], 
     ")"}]}]}]}]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
   3.950891068130377*^9, 3.950891115738426*^9}, {3.95089122726511*^9, 
   3.950891365153498*^9}, {3.950891433390114*^9, 3.950891434360166*^9}, {
   3.9508915124241548`*^9, 3.95089152052244*^9}, {3.9509790738750134`*^9, 
   3.9509790744247723`*^9}, {3.950979116644966*^9, 3.950979203385887*^9}, {
   3.9509792887190247`*^9, 3.950979311838291*^9}, {3.950979353872219*^9, 
   3.950979394865408*^9}, 3.9580412904599094`*^9, {3.958041967039255*^9, 
   3.9580419695485687`*^9}},
 TextAlignment->Center,
 CellTags->
  "eq: LL_{XX_xi}L=L_xiL",ExpressionUUID->"7a774b47-03b4-a34f-8b8e-\
1309aee7af29"],

Cell["which is exact (a divergence).", "Text",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
  3.950891068130377*^9, 3.950891115738426*^9}, {3.95089122726511*^9, 
  3.950891365153498*^9}, {3.950891433390114*^9, 3.950891434360166*^9}, {
  3.9508915124241548`*^9, 3.95089152052244*^9}, {3.9509790738750134`*^9, 
  3.9509790744247723`*^9}, {3.950979116644966*^9, 3.950979203385887*^9}, {
  3.9509793029535847`*^9, 3.950979305238199*^9}, {3.9509794059595566`*^9, 
  3.9509794061979904`*^9}},ExpressionUUID->"be33dd97-6955-974e-bcf0-\
9b33f5ea1dcd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NoetherSymmetryQ", "[", "vvf2", "]"}], "[", "g", "]"}], "[", 
  "Lscalar", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NoetherSymmetryQ", "[", "vvf2", "]"}], "[", 
    RowBox[{"g", ",", 
     RowBox[{"CheckZero", "->", "True"}]}], "]"}], "[", "Lscalar", "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Notice", " ", "how", " ", "in", " ", "this", " ", "case", " ", "this", " ",
      "is", " ", "incorrect"}], ",", " ", 
    RowBox[{
    "so", " ", "this", " ", "option", " ", "must", " ", "be", " ", "used", " ",
      "with", " ", "caution"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NoetherSymmetryQ", "[", "vvf2", "]"}], "[", "g", "]"}], "[", 
  RowBox[{
  "Lscalar", ",", "SortCovDs", ",", "ContractMetric", ",", "SortCovDs"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9508853453820343`*^9, 3.9508853770553665`*^9}, 
   3.950887615944494*^9, {3.950891370628542*^9, 3.950891392764801*^9}, {
   3.950895353894119*^9, 3.950895357182421*^9}, {3.9509642594397526`*^9, 
   3.9509642758598976`*^9}, {3.951244569887928*^9, 3.9512445700670376`*^9}, {
   3.951244878322588*^9, 3.951244890094347*^9}, {3.9580658732031384`*^9, 
   3.9580659128855705`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"1f131a81-271b-be40-b45d-2e96c6c265fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "a"], "\[Phi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[$CellContext`a][
      $CellContext`phi[]],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "a"], 
          SubscriptBox["\[Del]", "b"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`LCDer[-$CellContext`b][
          $CellContext`xi[$CellContext`b]]],
        Editable->False]}], "+", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "b"], 
         SubscriptBox["\[Del]", "a"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`b][
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`xi[$CellContext`b]]],
       Editable->False]}], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "a"], 
         SubscriptBox["\[Del]", "b"], 
         SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`a][
        $CellContext`LCDer[-$CellContext`b][
         $CellContext`LCDer[$CellContext`b][
          $CellContext`phi[]]]],
       Editable->False], "-", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "b"], 
         SuperscriptBox["\[Del]", "b"], 
         SubscriptBox["\[Del]", "a"], "\[Phi]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`b][
        $CellContext`LCDer[$CellContext`b][
         $CellContext`LCDer[-$CellContext`a][
          $CellContext`phi[]]]],
       Editable->False]}], ")"}]}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{3.9573417607429967`*^9, 3.957763396690097*^9, 
  3.9577859504875517`*^9, 3.9577875589704103`*^9, 3.9577895082116075`*^9, 
  3.958065917506424*^9, 3.95821496019001*^9, 3.9582150246944504`*^9, 
  3.9595019603478985`*^9, 3.960641605261284*^9, 3.9606428657059135`*^9, 
  3.9639546816087914`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"bf36d396-bc30-b24c-b5f2-443de70b1602"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9573417607429967`*^9, 3.957763396690097*^9, 
  3.9577859504875517`*^9, 3.9577875589704103`*^9, 3.9577895082116075`*^9, 
  3.958065917506424*^9, 3.95821496019001*^9, 3.9582150246944504`*^9, 
  3.9595019603478985`*^9, 3.960641605261284*^9, 3.9606428657059135`*^9, 
  3.9639546842502937`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"76e2cc42-45a6-ef4a-8d1f-0926019eed29"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9573417607429967`*^9, 3.957763396690097*^9, 
  3.9577859504875517`*^9, 3.9577875589704103`*^9, 3.9577895082116075`*^9, 
  3.958065917506424*^9, 3.95821496019001*^9, 3.9582150246944504`*^9, 
  3.9595019603478985`*^9, 3.960641605261284*^9, 3.9606428657059135`*^9, 
  3.96395468675239*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"3811afbb-6835-4a42-b410-049fa9828f43"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Remark: ",
  FontWeight->"Bold"],
 StyleBox["Incidentally, this proves that ",
  FontWeight->"Plain"],
 Cell[BoxData[
  RowBox[{"VVF1", "=", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"(", 
       FractionBox["\[Delta]", "\[Delta]\[Phi]"], ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`VariationalVectorphi[],
     Editable->False], 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`LieD[
       $CellContext`xi[$CellContext`a]][
       $CellContext`phi[]],
      Editable->False], ")"}]}]}]], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"e5051427-8c17-584d-94eb-51b56fc83c6c"],
 StyleBox[" for a given g-Killing vector field \[Xi] is also a Noether \
Symmetry of ",
  FontWeight->"Plain"],
 Cell[BoxData["Lscalar"], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"70b3355f-011f-e047-abbc-8594f0f5d0a3"],
 StyleBox[" since in that case ",
  FontWeight->"Plain"],
 Cell[BoxData[
  RowBox[{"VVF1", "=", "VVF2"}]], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"7097b7f3-7bb2-fe48-ad1e-17759c04a7da"],
 StyleBox[".",
  FontWeight->"Plain"]
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.959573346626133*^9, 3.9595733471500225`*^9}, {
   3.9595741212794*^9, 3.959574128230999*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"348612af-c0b5-6d4e-8950-727357aee611"],

Cell[TextData[{
 "Let us finally check that this type of transformations are also Noether \
symmetries of ",
 Cell[BoxData[
 "LGR"], "InlineCode",ExpressionUUID->"4ab93815-ed68-5946-a457-a77325a636fa"],
 ":"
}], "Text",
 CellChangeTimes->{{3.950891409040239*^9, 3.9508915259195194`*^9}, {
   3.950979417638857*^9, 3.950979418230118*^9}, 3.952344183559984*^9, 
   3.952344359854931*^9, 3.9564081829948263`*^9, 3.9567214781620035`*^9, {
   3.958041307093899*^9, 3.9580413169685802`*^9}, {3.959501972475628*^9, 
   3.9595019734484386`*^9}, {3.959574120327648*^9, 
   3.959574132177099*^9}},ExpressionUUID->"48d377c1-3b66-f44f-8cc2-\
358cf22543d2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vvf3", "=", 
  RowBox[{
   RowBox[{"VVFFromLieD", "[", "xi", "]"}], "[", "g", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NoetherSymmetryQ", "[", "vvf3", "]"}], "[", "g", "]"}], "[", 
  "LGR", "]"}]}], "Input",
 CellChangeTimes->{{3.9508909284084473`*^9, 3.9508909529757195`*^9}, {
   3.950891468449793*^9, 3.9508914733724823`*^9}, {3.950891530417509*^9, 
   3.9508915329733257`*^9}, 3.95096765157427*^9},
 CellLabel->"In[36]:=",ExpressionUUID->"3791257c-2c98-df41-817f-4bdda60239c6"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        FractionBox["\[Delta]", "\[Delta]g"], ")"}], 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`VariationalVectorg[$CellContext`a, $CellContext`b],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`LieD[
     $CellContext`xi[$CellContext`a]][
     $CellContext`g[-$CellContext`a, -$CellContext`b]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{3.9573417681420975`*^9, 3.957763398416114*^9, 
  3.957785952322323*^9, 3.9577875609679914`*^9, 3.957789511109068*^9, 
  3.9580659318834953`*^9, 3.958215059699606*^9, 3.9595019826222324`*^9, 
  3.960641608220804*^9, 3.9606428685224743`*^9, 3.9639358800032215`*^9, 
  3.963954686931286*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"bd67fd34-a679-f240-b0f8-5cd27b873ed1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], 
        RowBox[{"R", "[", "\[Del]", "]"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`RicciScalarLCDer[]],
      Editable->False]}], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], GridBox[{
          {
           RowBox[{"R", "[", "\[Del]", "]"}], 
           StyleBox[GridBox[{
              {" ", "b"},
              {"a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`RicciLCDer[-$CellContext`a, $CellContext`b]],
      Editable->False]}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SuperscriptBox["\[Del]", "a"], 
          SubscriptBox["\[Del]", "c"], 
          SuperscriptBox["\[Del]", "b"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[$CellContext`a][
         $CellContext`LCDer[-$CellContext`c][
          $CellContext`LCDer[$CellContext`b][
           $CellContext`xi[$CellContext`c]]]],
        Editable->False]}], "+", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SuperscriptBox["\[Del]", "b"], 
          SuperscriptBox["\[Del]", "a"], 
          SubscriptBox["\[Del]", "c"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[$CellContext`b][
         $CellContext`LCDer[$CellContext`a][
          $CellContext`LCDer[-$CellContext`c][
           $CellContext`xi[$CellContext`c]]]],
        Editable->False]}], "-", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SuperscriptBox["\[Del]", "b"], 
          SubscriptBox["\[Del]", "c"], 
          SuperscriptBox["\[Del]", "a"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[$CellContext`b][
         $CellContext`LCDer[-$CellContext`c][
          $CellContext`LCDer[$CellContext`a][
           $CellContext`xi[$CellContext`c]]]],
        Editable->False]}], "+", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "c"], GridBox[{
            {
             RowBox[{"R", "[", "\[Del]", "]"}], 
             StyleBox[GridBox[{
                {"a", "b"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`c][
         $CellContext`RicciLCDer[$CellContext`a, $CellContext`b]],
        Editable->False]}], "-", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"g", 
            StyleBox[GridBox[{
               {"a", "b"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`g[$CellContext`a, $CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "c"], 
          RowBox[{"R", "[", "\[Del]", "]"}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`c][
         $CellContext`RicciScalarLCDer[]],
        Editable->False]}], "+", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "c"], 
         SuperscriptBox["\[Del]", "a"], 
         SuperscriptBox["\[Del]", "b"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`c][
        $CellContext`LCDer[$CellContext`a][
         $CellContext`LCDer[$CellContext`b][
          $CellContext`xi[$CellContext`c]]]],
       Editable->False], "-", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "c"], 
         SuperscriptBox["\[Del]", "a"], 
         SuperscriptBox["\[Del]", "c"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`c][
        $CellContext`LCDer[$CellContext`a][
         $CellContext`LCDer[$CellContext`c][
          $CellContext`xi[$CellContext`b]]]],
       Editable->False], "+", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "c"], 
         SuperscriptBox["\[Del]", "b"], 
         SuperscriptBox["\[Del]", "a"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`c][
        $CellContext`LCDer[$CellContext`b][
         $CellContext`LCDer[$CellContext`a][
          $CellContext`xi[$CellContext`c]]]],
       Editable->False], "-", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "c"], 
         SuperscriptBox["\[Del]", "b"], 
         SuperscriptBox["\[Del]", "c"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`c][
        $CellContext`LCDer[$CellContext`b][
         $CellContext`LCDer[$CellContext`c][
          $CellContext`xi[$CellContext`a]]]],
       Editable->False], "+", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "c"], 
         SuperscriptBox["\[Del]", "c"], 
         SuperscriptBox["\[Del]", "a"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`c][
        $CellContext`LCDer[$CellContext`c][
         $CellContext`LCDer[$CellContext`a][
          $CellContext`xi[$CellContext`b]]]],
       Editable->False], "+", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "c"], 
         SuperscriptBox["\[Del]", "c"], 
         SuperscriptBox["\[Del]", "b"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`c][
        $CellContext`LCDer[$CellContext`c][
         $CellContext`LCDer[$CellContext`b][
          $CellContext`xi[$CellContext`a]]]],
       Editable->False], "+", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"g", 
            StyleBox[GridBox[{
               {"a", "b"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`g[$CellContext`a, $CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "d"], 
          SubscriptBox["\[Del]", "c"], 
          SuperscriptBox["\[Del]", "d"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`d][
         $CellContext`LCDer[-$CellContext`c][
          $CellContext`LCDer[$CellContext`d][
           $CellContext`xi[$CellContext`c]]]],
        Editable->False]}], "-", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"g", 
            StyleBox[GridBox[{
               {"a", "b"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`g[$CellContext`a, $CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "d"], 
          SuperscriptBox["\[Del]", "d"], 
          SubscriptBox["\[Del]", "c"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`d][
         $CellContext`LCDer[$CellContext`d][
          $CellContext`LCDer[-$CellContext`c][
           $CellContext`xi[$CellContext`c]]]],
        Editable->False]}], "-", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"g", 
            StyleBox[GridBox[{
               {"a", "b"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`g[$CellContext`a, $CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"R", "[", "\[Del]", "]"}], 
            StyleBox[GridBox[{
               {" ", " "},
               {"c", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciLCDer[-$CellContext`c, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SuperscriptBox["\[Del]", "d"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[$CellContext`d][
         $CellContext`xi[$CellContext`c]],
        Editable->False]}], "+", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"R", "[", "\[Del]", "]"}], 
            StyleBox[GridBox[{
               {"a", " ", "b", " "},
               {" ", "c", " ", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannLCDer[$CellContext`a, -$CellContext`c, \
$CellContext`b, -$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SuperscriptBox["\[Del]", "d"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[$CellContext`d][
         $CellContext`xi[$CellContext`c]],
        Editable->False]}], "+", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"R", "[", "\[Del]", "]"}], 
            StyleBox[GridBox[{
               {"a", " ", "b", " "},
               {" ", "d", " ", "c"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RiemannLCDer[$CellContext`a, -$CellContext`d, \
$CellContext`b, -$CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SuperscriptBox["\[Del]", "d"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[$CellContext`d][
         $CellContext`xi[$CellContext`c]],
        Editable->False]}]}], ")"}]}], "\[Equal]", "0"}]}]], "Output",
 CellChangeTimes->{3.9573417681420975`*^9, 3.957763398416114*^9, 
  3.957785952322323*^9, 3.9577875609679914`*^9, 3.957789511109068*^9, 
  3.9580659318834953`*^9, 3.958215059699606*^9, 3.9595019826222324`*^9, 
  3.960641608220804*^9, 3.9606428685224743`*^9, 3.9639358800032215`*^9, 
  3.9639546935566654`*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"f637452e-cadb-c049-a268-98f1dad57a55"]
}, Open  ]],

Cell[TextData[{
 "Here we need to apply the Bianchi identities. This can be done with other \
packages (like ",
 StyleBox["TInvar",
  FontWeight->"Bold"],
 " or ",
 StyleBox["xTras",
  FontWeight->"Bold"],
 ") but to make this notebook self-contained, we define ",
 Cell[BoxData[
  StyleBox["ApplyContractedBianchi",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",
  FontColor->RGBColor[0., 0., 1.],ExpressionUUID->
  "89a4d803-c83b-f34c-a45b-be0118464924"],
 StyleBox[":",
  FontColor->RGBColor[0., 0., 0.]]
}], "Text",
 CellChangeTimes->{{3.950884789162279*^9, 3.950884811936074*^9}, {
   3.950891554263384*^9, 3.9508915554541874`*^9}, {3.951245973060213*^9, 
   3.95124598459073*^9}, {3.951247202935972*^9, 3.9512472071753654`*^9}, 
   3.952344220674676*^9, {3.9546642560987206`*^9, 3.9546642611099405`*^9}, 
   3.9580413337448425`*^9, {3.9580659376978874`*^9, 
   3.9580659538133087`*^9}},ExpressionUUID->"fc5c6e41-1b14-204b-8a7c-\
387b219f9706"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"BianchiContracted1", "=", 
   RowBox[{"MakeRule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"LCDer", "[", 
         RowBox[{"-", "e"}], "]"}], "@", 
        RowBox[{"RiemannLCDer", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}], ",", "e"}], "]"}]}], ",", 
       RowBox[{"$RicciSign", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"LCDer", "[", 
            RowBox[{"-", "c"}], "]"}], "@", 
           RowBox[{"RicciLCDer", "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "d"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"LCDer", "[", 
            RowBox[{"-", "a"}], "]"}], "@", 
           RowBox[{"RicciLCDer", "[", 
            RowBox[{
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "d"}]}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"MetricOn", "->", "All"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BianchiContracted2", "=", 
    RowBox[{"MakeRule", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"LCDer", "[", 
          RowBox[{"-", "b"}], "]"}], "@", 
         RowBox[{"RicciScalarLCDer", "[", "]"}]}], ",", 
        RowBox[{"2", 
         RowBox[{
          RowBox[{"LCDer", "[", 
           RowBox[{"-", "a"}], "]"}], "[", 
          RowBox[{"RicciLCDer", "[", 
           RowBox[{"a", ",", 
            RowBox[{"-", "b"}]}], "]"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"MetricOn", "->", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ApplyContractedBianchi", "[", "expr_", "]"}], ":=", 
   RowBox[{
    RowBox[{"expr", "//.", "BianchiContracted1"}], "//.", 
    "BianchiContracted2"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NoetherSymmetryQ", "[", "vvf3", "]"}], "[", "g", "]"}], "[", 
  RowBox[{
  "LGR", ",", "SortCovDs", ",", "ApplyContractedBianchi", ",", 
   "ContractMetric", ",", "Simplification", ",", "SortCovDs"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NoetherSymmetryQ", "[", "vvf3", "]"}], "[", "g", "]"}], "[", 
  RowBox[{
  "LGR", ",", "SortCovDs", ",", "ApplyContractedBianchi", ",", 
   "ContractMetric", ",", "Simplification", ",", "SortCovDs", ",", 
   "ApplyContractedBianchi"}], "]"}]}], "Input",
 CellChangeTimes->{{3.951245413882637*^9, 3.951245593141796*^9}, {
  3.951245644453808*^9, 3.95124565167798*^9}, {3.951245700703939*^9, 
  3.9512457170842*^9}, {3.951245760377083*^9, 3.951245903267948*^9}, {
  3.951245959761373*^9, 3.9512459664714565`*^9}, {3.951246892349497*^9, 
  3.951246894456312*^9}, {3.95124692814265*^9, 3.951246947027231*^9}, {
  3.9512469945299635`*^9, 3.951247116267774*^9}, {3.951247174491735*^9, 
  3.9512472103840632`*^9}, {3.951247404383463*^9, 3.951247416905571*^9}, {
  3.9513068411691647`*^9, 3.9513068427980175`*^9}, {3.951925650204401*^9, 
  3.951925654050062*^9}, {3.959502100028578*^9, 3.959502119674267*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"2d50cee1-5287-d742-ba8d-63cef662340f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Xi]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`xi[$CellContext`a],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[Del]", "]"}], 
            StyleBox[GridBox[{
               {"c", "d"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`a][
        $CellContext`RicciLCDer[$CellContext`c, $CellContext`d]],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], GridBox[{
          {
           RowBox[{"R", "[", "\[Del]", "]"}], 
           StyleBox[GridBox[{
              {"c", " ", "d", "b"},
              {" ", "a", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`RiemannLCDer[$CellContext`c, -$CellContext`a, \
$CellContext`d, $CellContext`b]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], GridBox[{
          {
           RowBox[{"R", "[", "\[Del]", "]"}], 
           StyleBox[GridBox[{
              {"c", "b", "d", " "},
              {" ", " ", " ", "a"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`RiemannLCDer[$CellContext`c, $CellContext`b, \
$CellContext`d, -$CellContext`a]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "c"], GridBox[{
          {
           RowBox[{"R", "[", "\[Del]", "]"}], 
           StyleBox[GridBox[{
              {"d", " "},
              {" ", "a"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`c][
       $CellContext`RicciLCDer[$CellContext`d, -$CellContext`a]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "d"], GridBox[{
          {
           RowBox[{"R", "[", "\[Del]", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "a"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`d][
       $CellContext`RicciLCDer[$CellContext`c, -$CellContext`a]],
      Editable->False]}], ")"}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{
  3.9573417826080756`*^9, 3.95776340382331*^9, 3.957785957956079*^9, 
   3.9577875774812193`*^9, 3.9577895343251047`*^9, 3.9580659680559177`*^9, 
   3.958215313597471*^9, 3.959502000853298*^9, {3.9595021081103745`*^9, 
   3.9595021265786743`*^9}, 3.9606416179137974`*^9, 3.9606428765603886`*^9, 
   3.9639358944690323`*^9, 3.963954700947588*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"b3611397-93c1-e442-934a-974dff993c68"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9573417826080756`*^9, 3.95776340382331*^9, 3.957785957956079*^9, 
   3.9577875774812193`*^9, 3.9577895343251047`*^9, 3.9580659680559177`*^9, 
   3.958215313597471*^9, 3.959502000853298*^9, {3.9595021081103745`*^9, 
   3.9595021265786743`*^9}, 3.9606416179137974`*^9, 3.9606428765603886`*^9, 
   3.9639358944690323`*^9, 3.963954707634426*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"501d46f2-80e9-3c47-8c39-305e7519daa5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". NoetherPotential"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.9505417846854916`*^9, 
   3.9505420882956924`*^9, {3.9508916518632965`*^9, 3.950891654204216*^9}, 
   3.9509643327422943`*^9, 3.950980089868351*^9, 3.9606566128232956`*^9},
 CellTags->
  "Subsub NoetherPotential",ExpressionUUID->"8e37c52a-d38b-1743-bf35-\
dfcaaf4eab28"],

Cell[TextData[{
 "We have seen that ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"NoetherSymmetryQ", "[", "vvf", "]"}], "[", "metric", "]"}], "[",
     "Lagrangian", "]"}],
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "ee05ee9b-bcf2-144b-a66c-ed65b32f63c3"],
 " checks if "
}], "Text",
 CellChangeTimes->{{3.950884789162279*^9, 3.950884811936074*^9}, {
   3.950891554263384*^9, 3.9508915554541874`*^9}, {3.950964371067505*^9, 
   3.9509644859104424`*^9}, {3.9509646909419193`*^9, 3.950964696957897*^9}, {
   3.950965728054905*^9, 3.9509657281878376`*^9}, 3.952344258345049*^9, {
   3.9564104147088566`*^9, 3.9564104165328207`*^9}, {3.956410456218171*^9, 
   3.9564104987477617`*^9}},ExpressionUUID->"50c35b0d-2ca3-134d-a958-\
ba72f4fe90a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[DoubleStruckCapitalL]", "vvf"], "[", "Lagrangian", "]"}], "=", 
  RowBox[{"div", 
   RowBox[{"(", 
    SubscriptBox["S", "vvf"], ")"}]}]}]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.950884789162279*^9, 3.950884811936074*^9}, {
   3.950891554263384*^9, 3.9508915554541874`*^9}, {3.950964371067505*^9, 
   3.9509644859104424`*^9}, {3.95096469094192*^9, 3.950964696957897*^9}, {
   3.9509657314270916`*^9, 3.950965757035551*^9}, {3.950965836091146*^9, 
   3.950965836094154*^9}, {3.950966054139509*^9, 3.950966055230406*^9}, 
   3.9580413455458393`*^9, {3.9582154054237614`*^9, 3.9582154281527367`*^9}},
 TextAlignment->Center,
 CellTags->
  "eq: LL_vvfL=dS",ExpressionUUID->"af1354b6-df1c-d04c-a479-39adb67a9a74"],

Cell[TextData[{
 "for some \[OpenCurlyDoubleQuote]potential\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox["S", "VVF"], ")"}], "a"], TraditionalForm]],ExpressionUUID->
  "1a691b88-3901-0947-934e-3e77497976bb"],
 ". "
}], "Text",
 CellChangeTimes->{{3.950884789162279*^9, 3.950884811936074*^9}, {
   3.950891554263384*^9, 3.9508915554541874`*^9}, {3.950964371067505*^9, 
   3.9509644859104424`*^9}, {3.95096469094192*^9, 3.950964696957897*^9}, {
   3.950965753340114*^9, 3.950965787723268*^9}, {3.950966059198431*^9, 
   3.9509660623130417`*^9}, {3.9509674775724697`*^9, 3.950967517442677*^9}, {
   3.9509794651666183`*^9, 3.950979465421524*^9}, 3.950980089893841*^9, 
   3.9524381940153894`*^9},ExpressionUUID->"ada9079e-96e8-0343-90dc-\
b6e08291c19d"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"NoetherPotential", "[", 
      RowBox[{"vvf", ",", " ", "iteration"}], "]"}], "[", "der", "]"}], "[", 
    RowBox[{"Lagrangian", ",", " ", "optionalfunctions"}], "]"}],
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",
  FontWeight->"Bold",ExpressionUUID->"4a8b524b-1a0a-e046-a406-e59f09eabccb"],
 StyleBox["\n",
  FontSize->3],
 "It computes the potential associated with a Noether symmetry ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"vvf", "'"}]}]], "InlineCode",ExpressionUUID->
  "8ca12bed-4de3-0648-80b1-c19250c1e63f"],
 ". It is given by a vector ",
 Cell[BoxData[
  SuperscriptBox["S", "a"]],
  CellChangeTimes->{
   3.9528612923407087`*^9, {3.9530463840793705`*^9, 3.953046417247267*^9}, {
    3.9530464656579494`*^9, 3.9530469658168297`*^9}, {3.953047003114004*^9, 
    3.9530471139988575`*^9}, {3.95304717305118*^9, 3.953047633976343*^9}, {
    3.953047675900173*^9, 3.953047838226431*^9}, {3.953047874449215*^9, 
    3.9530479568815975`*^9}, {3.9530479931132812`*^9, 3.953048381412983*^9}, {
    3.9530484261085167`*^9, 3.9530485092813873`*^9}, {3.9530549891711254`*^9, 
    3.9530550419651623`*^9}, {3.953055493308323*^9, 3.9530554948226585`*^9}, {
    3.953060414927849*^9, 3.9530604603123703`*^9}, 3.9530606428554077`*^9, {
    3.953060828027918*^9, 3.9530609674490223`*^9}, {3.9530611217899685`*^9, 
    3.953061169637972*^9}, {3.95306145855962*^9, 3.953061514219095*^9}, 
    3.953315985722332*^9, {3.9533172687463627`*^9, 3.9533172846479244`*^9}, 
    3.953320457244425*^9, 3.953320519496685*^9, 3.9533205511040916`*^9, {
    3.953320599871628*^9, 3.9533206024921417`*^9}, 3.953320646375412*^9, {
    3.95332070628084*^9, 3.9533207727766685`*^9}, {3.9533208059551334`*^9, 
    3.9533208222767925`*^9}, {3.9533208539390984`*^9, 3.953320868011757*^9}, {
    3.9533208993171024`*^9, 3.953320950496462*^9}, {3.95332099463953*^9, 
    3.9533210130029945`*^9}, {3.9533303152328796`*^9, 
    3.9533303271370525`*^9}, {3.9548570753644924`*^9, 
    3.9548570763137417`*^9}, {3.954857752163885*^9, 3.9548577532798424`*^9}, 
    3.9551255578720264`*^9, {3.9563163003436337`*^9, 3.956316407661049*^9}, 
    3.9563164701166744`*^9, {3.956316534438925*^9, 3.95631653471455*^9}, {
    3.9563166096611977`*^9, 3.956316681999241*^9}, {3.956316715089451*^9, 
    3.956316770322426*^9}, {3.956316804863121*^9, 3.9563170705665436`*^9}, {
    3.956317188029072*^9, 3.956317282388052*^9}, {3.9563174189041176`*^9, 
    3.9563174728688545`*^9}, {3.9563175474887066`*^9, 3.956317596378807*^9}, {
    3.9563176348612423`*^9, 3.9563176700602036`*^9}, {3.9563179597317047`*^9, 
    3.9563180112802124`*^9}, {3.9563180521163864`*^9, 3.956318162163805*^9}, {
    3.9563181990604305`*^9, 3.95631822712842*^9}, {3.9563184145924263`*^9, 
    3.9563185096205025`*^9}, {3.956318582042082*^9, 3.9563186433849525`*^9}, {
    3.956318687959217*^9, 3.9563187192092857`*^9}, {3.9563193376627045`*^9, 
    3.9563195605722427`*^9}, 3.956319615666563*^9, {3.9563198589350777`*^9, 
    3.9563198601739216`*^9}, 3.9563199026692276`*^9, {3.956319955901041*^9, 
    3.956320172612013*^9}, {3.956322216323349*^9, 3.9563222207255993`*^9}, {
    3.956322261966234*^9, 3.9563222976270084`*^9}, {3.9563223279752407`*^9, 
    3.956322506270193*^9}, {3.956322542437462*^9, 3.956322551647373*^9}, {
    3.9563227857299767`*^9, 3.9563227867510185`*^9}, {3.95632287188698*^9, 
    3.9563229058911343`*^9}, {3.9563253084942265`*^9, 
    3.9563254124977207`*^9}, {3.956325474688154*^9, 3.956325624197916*^9}, {
    3.956325671303583*^9, 3.956325833513712*^9}, {3.956325871683794*^9, 
    3.9563258945014477`*^9}, {3.9563259276884594`*^9, 3.956325942026209*^9}, {
    3.9563260165525246`*^9, 3.956326046816242*^9}, {3.9563261039174347`*^9, 
    3.9563261238158627`*^9}, {3.9563272033392353`*^9, 3.9563272038011494`*^9},
     3.9563390342186127`*^9, {3.956349485853964*^9, 3.9563495066374855`*^9}, {
    3.9563520801059017`*^9, 3.9563522156779175`*^9}, {3.9563522575017986`*^9, 
    3.9563523863963985`*^9}, {3.9563524639998035`*^9, 
    3.9563525882821255`*^9}, {3.956352621095846*^9, 3.956352861511904*^9}, {
    3.956352918143635*^9, 3.9563529517723045`*^9}, {3.956352981862404*^9, 
    3.95635298260367*^9}, {3.956353036470278*^9, 3.9563531125158863`*^9}, {
    3.956354402353588*^9, 3.9563544029226856`*^9}, {3.957188841936941*^9, 
    3.957188850816931*^9}, {3.9571888914954853`*^9, 3.957188919348295*^9}, {
    3.9571889496231823`*^9, 3.957188960381836*^9}, {3.9571890684017906`*^9, 
    3.9571890737612057`*^9}, {3.957189110766165*^9, 3.9571891463616695`*^9}, {
    3.957189177209551*^9, 3.957189242971344*^9}, {3.95718927885606*^9, 
    3.957189511380596*^9}, {3.9571895451387787`*^9, 3.9571897872520466`*^9}, {
    3.9571898716464233`*^9, 3.9571898729079113`*^9}, {3.957190312497761*^9, 
    3.9571903316251907`*^9}, {3.95719585215016*^9, 3.957195928511383*^9}, {
    3.957195968062895*^9, 3.957195987452099*^9}, 3.9572086123849297`*^9, {
    3.9572235081830893`*^9, 3.9572235547705545`*^9}, {3.95722372785059*^9, 
    3.957223729770196*^9}, 3.9572238023707075`*^9, 3.957223850712164*^9, {
    3.9572239104959545`*^9, 3.957223911597126*^9}, {3.9572239495777264`*^9, 
    3.9572239506254015`*^9}, 3.9572240214231677`*^9, 3.9572242983735743`*^9, {
    3.9573535742819223`*^9, 3.957353577039909*^9}, {3.9573536241339025`*^9, 
    3.957353624892392*^9}, {3.957357239063778*^9, 3.957357251084618*^9}, {
    3.9573572918358445`*^9, 3.9573575978751707`*^9}, {3.9573576902064505`*^9, 
    3.957357794447317*^9}, {3.9573581333231487`*^9, 3.957358136066495*^9}, {
    3.9573582241250057`*^9, 3.957358237234251*^9}, 3.957358442760108*^9, {
    3.957358669865229*^9, 3.9573586881796002`*^9}, {3.9573587222436686`*^9, 
    3.957358744030595*^9}, {3.957387014845293*^9, 3.957387096566799*^9}, {
    3.957387183148695*^9, 3.9573872152440643`*^9}, {3.9573874059859047`*^9, 
    3.9573874066135445`*^9}, {3.9573904513165245`*^9, 3.95739047328953*^9}, {
    3.957536085021799*^9, 3.9575361331106663`*^9}, 3.9575362359872265`*^9, {
    3.9575439752038727`*^9, 3.9575439910492764`*^9}, {3.957549536163948*^9, 
    3.957549574380745*^9}, {3.9575992356957655`*^9, 3.957599295584903*^9}, {
    3.9575995195756264`*^9, 3.957599544489135*^9}, {3.957599575255509*^9, 
    3.9575995963368316`*^9}, {3.9575996357355785`*^9, 
    3.9575996560269933`*^9}, {3.957599718211052*^9, 3.9575998059047017`*^9}, {
    3.9575999051922426`*^9, 3.9575999171193466`*^9}, {3.9576111763013544`*^9, 
    3.957611206039695*^9}, {3.9576118008498707`*^9, 3.9576118033018775`*^9}, {
    3.9576118730598183`*^9, 3.9576118761300707`*^9}},ExpressionUUID->
  "31f0a7a4-4265-984c-8441-60d1667aab97"],
 " such that \n",
 StyleBox["\n",
  FontSize->3],
 StyleBox["\n",
  FontSize->0],
 "          ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"VertLie", "[", "vvf", "]"}], "@", "Lagrangian"}], "=", 
   RowBox[{
    RowBox[{"der", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"S", "[", "a", "]"}], "]"}]}]], "InlineCode",ExpressionUUID->
  "87d84f89-d8c3-b34f-8c05-6fbeafc3b9e0"],
 ".\n",
 StyleBox["\n",
  FontSize->3],
 "- ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"iteration", "'"}]}]], "InlineCode",ExpressionUUID->
  "a8ef887b-b753-0c42-8e9a-6d47a62dd75b"],
 " is an optional positive integer that limits the amount of iteration in \
order to obtain the middle steps.\n- ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"optionalfunctions", "'"}]}]], "InlineCode",ExpressionUUID->
  "0c35b960-b2d7-364c-a5d5-ecd5db570bfb"],
 " are functions that are applied in the intermediate steps to simplify the \
expressions."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952438211921932*^9, 3.952438315853633*^9}, 
   3.9544813934275265`*^9, {3.9567215392225*^9, 3.9567215437006655`*^9}, {
   3.9567463848147726`*^9, 3.956746394752328*^9}, {3.956746462345564*^9, 
   3.956746526633418*^9}, {3.956746559654766*^9, 3.9567466333946023`*^9}, {
   3.9570741095783377`*^9, 3.9570741100421915`*^9}, {3.957074165312693*^9, 
   3.9570741807078114`*^9}, {3.957074223709414*^9, 3.957074255144451*^9}, {
   3.9576135861187553`*^9, 3.957613740506631*^9}, 3.9576164449319315`*^9, {
   3.957826868311117*^9, 3.9578268775209236`*^9}, {3.957883520337617*^9, 
   3.9578835219267464`*^9}, {3.9578849357689543`*^9, 3.957884953458664*^9}, {
   3.957955494084194*^9, 3.9579555161494684`*^9}, 3.958046368460703*^9, {
   3.958065990084881*^9, 3.9580659907894897`*^9}, 3.9580660566154385`*^9, {
   3.958066364522833*^9, 3.958066367846319*^9}, 3.958066598456053*^9, {
   3.9580668237427673`*^9, 3.958066839167017*^9}, {3.958070530035885*^9, 
   3.958070532152569*^9}, {3.9582460079187946`*^9, 3.9582460092596893`*^9}, {
   3.958246585591484*^9, 3.9582465923053017`*^9}, {3.9582466297949734`*^9, 
   3.9582466574840946`*^9}},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"b4cb35d5-4e5c-d640-9fb6-e96433a68a1e"],

Cell[TextData[{
 "This command calls the more general command ",
 Cell[BoxData[
 "FindPotentialDivergence"], "InlineCode",ExpressionUUID->
  "e6859f2f-824f-f648-8590-a5b8dcd9ffda"],
 " (see Subsection ",
 StyleBox[
 CounterBox["Chapter", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsection", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 " below for further details), which attempts to find such vector (it is \
obviously defined up to an exact term i.e. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Del]", "b"], 
    SuperscriptBox["T", "ab"]}], TraditionalForm]],ExpressionUUID->
  "c6df016e-0812-3a4c-9a17-8576d603af4b"],
 " for some antisymmetric tensor ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["T", "ab"], TraditionalForm]],ExpressionUUID->
  "c233505e-d458-2640-8e07-165926e721c4"],
 "). \n\nThere is no guarantee that this algorithm will finalize:"
}], "Text",
 CellChangeTimes->{{3.9567464727200537`*^9, 3.956746481328648*^9}, {
   3.957443663102088*^9, 3.957443677163825*^9}, {3.9580660848982487`*^9, 
   3.9580660875059605`*^9}, {3.9581429411617317`*^9, 3.9581430197807198`*^9}, 
   3.9595021650823746`*^9, 3.9595787468744965`*^9, 
   3.9595788533821373`*^9},ExpressionUUID->"ab20fa1b-fbb1-7044-894b-\
76c25958de7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NoetherPotential", "[", "vvf3", "]"}], "[", "g", "]"}], "[", 
  "LGR", "]"}]], "Input",
 CellChangeTimes->{{3.950964686768411*^9, 3.9509646872624893`*^9}, 
   3.9509800899059067`*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"eade73e2-326a-e045-991e-121496249cb6"],

Cell[BoxData[
 TemplateBox[{
  "$RecursionLimit", "reclim", 
   "\"Recursion depth of \\!\\(\\*RowBox[{\\\"1024\\\"}]\\) exceeded.\"", 2, 
   39, 1, 32117902434791973236, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.957341811233322*^9, 3.957763412263564*^9, 
  3.9577859661446104`*^9, 3.95778760790932*^9, 3.9577895703906603`*^9, 
  3.958066403839674*^9, 3.960641630870432*^9, 3.960642887732876*^9},
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"533ada24-4038-9342-9c06-df5fb47574dd"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.95734181124424*^9, 3.957763412270966*^9, 
  3.957785966166505*^9, 3.9577876079730864`*^9, 3.957789570437728*^9, 
  3.9580664038798943`*^9, 3.96064163088636*^9, 3.960642887741909*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"052ae2d6-6eb7-ac4c-9203-edef13aba3c8"]
}, Open  ]],

Cell["\<\
In order to understand what is failing, we can limit the iterations performed \
by the algorithm:\
\>", "Text",
 CellChangeTimes->{{3.950884789162279*^9, 3.950884811936074*^9}, {
  3.950891554263384*^9, 3.9508915554541874`*^9}, {3.950964371067505*^9, 
  3.9509644859104424`*^9}, {3.9509646909419193`*^9, 
  3.950964726308975*^9}},ExpressionUUID->"4b862ea2-2ba0-bb4f-8ee8-\
38cf4f7a8392"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"NoetherPotential", "[", "vvf3", "]"}], "[", 
      RowBox[{"g", ",", "4"}], "]"}], "[", "LGR", "]"}], "//", "SortCovDs"}], 
   "//", "ContractMetric"}], "//", "Simplification"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"NoetherPotential", "[", "vvf3", "]"}], "[", 
      RowBox[{"g", ",", "5"}], "]"}], "[", "LGR", "]"}], "//", "SortCovDs"}], 
   "//", "ContractMetric"}], "//", "Simplification"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"NoetherPotential", "[", "vvf3", "]"}], "[", 
      RowBox[{"g", ",", "6"}], "]"}], "[", "LGR", "]"}], "//", "SortCovDs"}], 
   "//", "ContractMetric"}], "//", "Simplification"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"NoetherPotential", "[", "vvf3", "]"}], "[", 
      RowBox[{"g", ",", "7"}], "]"}], "[", "LGR", "]"}], "//", "SortCovDs"}], 
   "//", "ContractMetric"}], "//", "Simplification"}]}], "Input",
 CellChangeTimes->{{3.950964733574414*^9, 3.950964756213768*^9}, {
  3.9509800899164314`*^9, 3.9509800899284306`*^9}, {3.953664921162422*^9, 
  3.9536649515033684`*^9}, {3.953665021516653*^9, 3.9536650555699406`*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"c0bb4d12-131d-4f4b-b1c2-71032a89450a"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[Del]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciLCDer[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`b],
      Editable->False]}], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`b]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SuperscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[$CellContext`b][
       $CellContext`xi[-$CellContext`a]]],
     Editable->False]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.9573418172035933`*^9, 3.9577634129543333`*^9, 3.957785966941544*^9, 
   3.957787610291374*^9, 3.9577895731996613`*^9, 3.9580664054724255`*^9, 
   3.958215717412218*^9, 3.959502180654911*^9, 3.960641632145546*^9, 
   3.9606428888038387`*^9, {3.963935873744974*^9, 3.9639359031795387`*^9}, 
   3.9639547166343155`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"5e7aa091-1998-9543-beef-f0193786eacf"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarLCDer[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[-$CellContext`a],
      Editable->False]}], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[Del]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciLCDer[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`b],
      Editable->False]}], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`b]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SuperscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[$CellContext`b][
       $CellContext`xi[-$CellContext`a]]],
     Editable->False]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.9573418172035933`*^9, 3.9577634129543333`*^9, 3.957785966941544*^9, 
   3.957787610291374*^9, 3.9577895731996613`*^9, 3.9580664054724255`*^9, 
   3.958215717412218*^9, 3.959502180654911*^9, 3.960641632145546*^9, 
   3.9606428888038387`*^9, {3.963935873744974*^9, 3.9639359031795387`*^9}, 
   3.9639547186982117`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"abcfe5ad-b122-7548-9aeb-59df137f7fa4"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[Del]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciLCDer[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`b],
      Editable->False]}], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`b]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SuperscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[$CellContext`b][
       $CellContext`xi[-$CellContext`a]]],
     Editable->False]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.9573418172035933`*^9, 3.9577634129543333`*^9, 3.957785966941544*^9, 
   3.957787610291374*^9, 3.9577895731996613`*^9, 3.9580664054724255`*^9, 
   3.958215717412218*^9, 3.959502180654911*^9, 3.960641632145546*^9, 
   3.9606428888038387`*^9, {3.963935873744974*^9, 3.9639359031795387`*^9}, 
   3.963954720771555*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"5a3c0fe9-1446-3a4d-8d0b-8aa09b778e18"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarLCDer[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[-$CellContext`a],
      Editable->False]}], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[Del]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciLCDer[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`b],
      Editable->False]}], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`b]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SuperscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[$CellContext`b][
       $CellContext`xi[-$CellContext`a]]],
     Editable->False]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.9573418172035933`*^9, 3.9577634129543333`*^9, 3.957785966941544*^9, 
   3.957787610291374*^9, 3.9577895731996613`*^9, 3.9580664054724255`*^9, 
   3.958215717412218*^9, 3.959502180654911*^9, 3.960641632145546*^9, 
   3.9606428888038387`*^9, {3.963935873744974*^9, 3.9639359031795387`*^9}, 
   3.963954722335657*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"2761d5f8-4010-5546-a65d-60233350ae20"]
}, Open  ]],

Cell["\<\
We can see that the problem is that the algorithm jumps back and forth \
because the Contracted Bianchi formula is not applied. As before, we can \
force that:\
\>", "Text",
 CellChangeTimes->{{3.950884789162279*^9, 3.950884811936074*^9}, {
  3.950891554263384*^9, 3.9508915554541874`*^9}, {3.950964371067505*^9, 
  3.9509644859104424`*^9}, {3.95096469094192*^9, 3.950964726308975*^9}, {
  3.95096477509194*^9, 3.950964798296917*^9}, {3.950965660072151*^9, 
  3.950965673866478*^9}},ExpressionUUID->"57335351-3cc0-1a41-9f9a-\
e128ac45c843"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NoetherPotentialvvf3LGR1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"NoetherPotential", "[", "vvf3", "]"}], "[", "g", "]"}], "[", 
      RowBox[{"LGR", ",", "ApplyContractedBianchi"}], "]"}], "//", 
     "SortCovDs"}], "//", "ContractMetric"}], "//", 
   "Simplification"}]}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"8428fdd8-02dd-4544-a25a-496adbb8aa9d"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarLCDer[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[-$CellContext`a],
      Editable->False]}], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`b]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SuperscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[$CellContext`b][
       $CellContext`xi[-$CellContext`a]]],
     Editable->False]}], ")"}]}]], "Output",
 CellChangeTimes->{3.957763415465955*^9, 3.957785969665098*^9, 
  3.9577876194885063`*^9, 3.9577895840868254`*^9, 3.958066418659422*^9, 
  3.9582157233934135`*^9, 3.9595021900448895`*^9, 3.9606416377116127`*^9, 
  3.960642893113352*^9, 3.963954724110203*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"49e40595-a6eb-5e4c-ad04-6da06a44b4c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Remark:",
  FontWeight->"Bold"],
 " We have seen that if ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"vvf", "'"}]}]], "InlineCode",ExpressionUUID->
  "52f0366c-6c42-1a45-8ba9-89b4d986478d"],
 " is a Noether symmetry, then we have a Noether potential ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "VVF"], TraditionalForm]],ExpressionUUID->
  "bf79d7bb-d568-574e-a5d2-90521d898dbb"],
 " satisfying (",
 StyleBox[
 CounterBox["DisplayFormulaNumbered", "eq: LL_vvfL=dS"],
  FontColor->RGBColor[0, 0, 1]],
 "). Moreover, if ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"vvf", "'"}]}]], "InlineCode",ExpressionUUID->
  "c28fd9e6-d8d3-4246-896b-36977f9234b5"],
 " is defined through the Lie derivative (",
 Cell[BoxData[
 "VVFFromLieD"], "InlineCode",ExpressionUUID->
  "37e4295d-79f3-7c47-a8c5-ff17111963ad"],
 "), then according to (",
 StyleBox[
 CounterBox["DisplayFormulaNumbered", "eq: LL_{XX_xi}L=L_xiL"],
  FontColor->RGBColor[0, 0, 1]],
 "), we could have taken ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "VVF"], "=", 
    RowBox[{
     SubscriptBox["i", "\[Xi]"], "L"}]}], TraditionalForm]],ExpressionUUID->
  "d9a39efe-167c-744d-8397-6b8caebc47e8"],
 "."
}], "Item",
 CellChangeTimes->{
  3.9576104325492887`*^9, {3.957826897006893*^9, 3.9578269198545933`*^9}, {
   3.9580664561762886`*^9, 3.958066473862076*^9}, {3.958247576964487*^9, 
   3.9582475944306355`*^9}, {3.959502201337801*^9, 3.959502206635046*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"2cece13d-2b85-f14a-abe6-936dd7a6f49a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NoetherPotentialvvf3LGR2", " ", "=", 
  RowBox[{
   RowBox[{"NormalOfLCDer", "[", "a", "]"}], 
   RowBox[{"xi", "[", 
    RowBox[{"-", "a"}], "]"}], "LGR"}]}], "\[IndentingNewLine]", 
 RowBox[{"difference", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"NoetherPotentialvvf3LGR2", "-", "NoetherPotentialvvf3LGR1"}], "//",
     "SortCovDs"}], "//", "Simplification"}]}]}], "Input",
 CellChangeTimes->{{3.9509682449130573`*^9, 3.950968254780077*^9}, {
   3.950979529949566*^9, 3.9509795356550903`*^9}, {3.950979702339674*^9, 
   3.9509797275246143`*^9}, {3.950980080977135*^9, 3.9509800809961605`*^9}, {
   3.951306912843378*^9, 3.951306923045574*^9}, 3.952274515092037*^9},
 CellLabel->"In[48]:=",ExpressionUUID->"d0914573-ad97-934d-834b-487001790789"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{"R", "[", "\[Del]", "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciScalarLCDer[],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`xi[-$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.958066490362505*^9, 3.958215733141819*^9, 
  3.9595022163526554`*^9, 3.9606416377915*^9, 3.9606428931781616`*^9, 
  3.963954724259527*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"9e3a5bb9-30a4-4b47-a1dc-a25828b38508"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`b]]],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SuperscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[$CellContext`b][
       $CellContext`xi[-$CellContext`a]]],
     Editable->False]}], ")"}]}]], "Output",
 CellChangeTimes->{3.958066490362505*^9, 3.958215733141819*^9, 
  3.9595022163526554`*^9, 3.9606416377915*^9, 3.9606428931781616`*^9, 
  3.9639547243490734`*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"5a754c15-7679-cf43-8d40-afea10080856"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "We see that the Noether Potentials do not agree. However, they are equal up \
to a divergence/exact term, as expected for any potential (see Subsection ",
 StyleBox[
 CounterBox["Chapter", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsection", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 " for an explanation of ",
 Cell[BoxData[
 "NormalOfCovDToCovD"], "InlineCode",ExpressionUUID->
  "f146c1f0-3b2e-7941-ad83-b2949460acb1"],
 ")."
}], "Text",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
   3.950891068130377*^9, 3.950891115738426*^9}, {3.95089122726511*^9, 
   3.950891365153498*^9}, {3.950891433390114*^9, 3.950891434360166*^9}, {
   3.9508915124241548`*^9, 3.95089152052244*^9}, {3.9509790738750134`*^9, 
   3.9509790744247723`*^9}, {3.950979116644966*^9, 3.950979203385887*^9}, {
   3.9509793029535847`*^9, 3.950979305238199*^9}, {3.950979580752781*^9, 
   3.9509796923739433`*^9}, {3.9509797361276093`*^9, 3.950979758791523*^9}, {
   3.9509801617839794`*^9, 3.950980176823475*^9}, {3.957341882107416*^9, 
   3.9573419376974363`*^9}, {3.957341974879548*^9, 3.9573419748815465`*^9}, {
   3.95739648812343*^9, 3.957396490830431*^9}, {3.9573976370814657`*^9, 
   3.957397644134234*^9}, {3.95739778737214*^9, 3.957397803177784*^9}, {
   3.9579555834151983`*^9, 3.9579556431649275`*^9}, 3.958041400748249*^9, {
   3.9580665201884117`*^9, 3.958066520737728*^9}, {3.958611446428752*^9, 
   3.958611456758797*^9}, 3.959502221193552*^9, 3.9595787469482594`*^9, 
   3.9595788534558544`*^9},ExpressionUUID->"67ce113a-f1ec-0d4a-b4d6-\
e596a8861329"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"difference", "//", "NormalOfCovDToCovD"}], "//", "SortCovDs"}], "//",
    "Simplification"}], "//", "ContractMetric"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"d681d92f-3284-1546-81c4-854660dd82d1"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9577634154857216`*^9, 3.957785969696571*^9, 
  3.957787619616513*^9, 3.9577895841628313`*^9, 3.958066639546734*^9, 
  3.958066673900875*^9, 3.9582157514562817`*^9, 3.959502232256256*^9, 
  3.960641637949623*^9, 3.9606428932952175`*^9, 3.9639547255529118`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"49095595-5c4a-5a4d-b491-3c4386f292c3"]
}, Open  ]],

Cell["\<\
Applying some function in the middle steps of NoetherPotential, we can obtain \
different (but obviously equivalent) potentials:\
\>", "Text",
 CellChangeTimes->{{3.9555244388497753`*^9, 3.955524458408743*^9}, {
  3.9580666979653893`*^9, 3.9580667159976177`*^9}, {3.958066765154957*^9, 
  3.958066772652529*^9}},ExpressionUUID->"689de05e-fdae-9a41-a29d-\
b4ef119941ea"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"NoetherPotentialvvf3LGR3", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"NoetherPotential", "[", "vvf3", "]"}], "[", "g", "]"}], "[", 
      RowBox[{"LGR", ",", "SortCovDs", ",", "ApplyContractedBianchi"}], "]"}],
      "//", "SortCovDs"}], "//", "ContractMetric"}], "//", 
   "Simplification"}]}], "\[IndentingNewLine]", 
 RowBox[{"difference2", "=", 
  RowBox[{
  "NoetherPotentialvvf3LGR2", "-", "NoetherPotentialvvf3LGR3"}]}]}], "Input",
 CellChangeTimes->{{3.958066720774132*^9, 3.958066753967678*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"bb54edd4-5f70-1e41-9e62-3646949cfbd3"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{"R", "[", "\[Del]", "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciScalarLCDer[],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`xi[-$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.957763416213713*^9, 3.9577859705044527`*^9, 3.9577876224879074`*^9, 
   3.957789587498578*^9, 3.95806668042988*^9, {3.958066756388796*^9, 
   3.958066779390789*^9}, 3.95821575489542*^9, 3.959502241696659*^9, 
   3.9606416407254505`*^9, 3.9606428947980614`*^9, 3.9639547297533646`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"20fa1c6d-19b7-d94d-8661-76f8c6ceae2c"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.957763416213713*^9, 3.9577859705044527`*^9, 3.9577876224879074`*^9, 
   3.957789587498578*^9, 3.95806668042988*^9, {3.958066756388796*^9, 
   3.958066779390789*^9}, 3.95821575489542*^9, 3.959502241696659*^9, 
   3.9606416407254505`*^9, 3.9606428947980614`*^9, 3.96395472980262*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"fba8fd25-99b6-6c4f-a3d0-bb69e7b3dd98"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Noether current (Noether Charges)"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, 3.9505417846854916`*^9, 
   3.9505420882956924`*^9, {3.9508916518632965`*^9, 3.950891654204216*^9}, {
   3.9509650473181095`*^9, 3.9509650507001667`*^9}, {3.950967539233984*^9, 
   3.9509675430225353`*^9}, 3.9606566162644234`*^9},
 CellTags->
  "Subsub Noether \
current",ExpressionUUID->"03761519-6adb-1247-8e97-8469d651ed16"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"NoetherCurrent", "[", 
      RowBox[{"vvf", ",", "iteration"}], "]"}], "[", "der", "]"}], "[", 
    RowBox[{"Lagrangian", ",", " ", "optionalfunctions"}], "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"d0f0d396-373f-3346-932e-43fbbd476141"],
 StyleBox["\n",
  FontSize->3],
 "It computes the Noether current associated with the Noether symmetry ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"vvf", "'"}]}]], "InlineCode",ExpressionUUID->
  "9f4b9a39-c877-314f-9306-736eb62e7d9a"],
 "of",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"Lagrangian", "'"}]}]], "InlineCode",ExpressionUUID->
  "f5523433-8cad-0344-89a4-b117f723925a"],
 ".\n",
 StyleBox["\n",
  FontSize->3],
 "- ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"der", "'"}]}]], "InlineCode",ExpressionUUID->
  "f0f063f1-d679-b640-8e48-dc185888a1c0"],
 " is the ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"14622df1-d994-794c-abee-afb0e98e58b1"],
 " used by ",
 Cell[BoxData[
  StyleBox["SymplecticPotential",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "ed5cbbe2-22ee-a041-9efd-660ad4cbad4d"],
 ".\n- ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"iteration", "'"}]}]], "InlineCode",ExpressionUUID->
  "dec73fe7-f8d6-134b-806e-d298f476ed93"],
 " is an optional positive integer that limits the amount of iteration in \
order to obtain the middle steps.\n- ",
 Cell[BoxData[
  RowBox[{"'", "o"}]], "InlineCode",ExpressionUUID->
  "ba07ae88-dff1-df41-bc55-b0fb23ebdab4"],
 Cell[BoxData[
  RowBox[{"ptionalfunctions", "'"}]], "InlineCode",ExpressionUUID->
  "ac765d3d-c187-384d-9b34-013b0dc2c834"],
 " are functions that are applied in the intermediate steps to simplify the \
expressions."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.9530892446438684`*^9, 3.9530893226441154`*^9}, 
   3.9544814369332542`*^9, {3.956746269030998*^9, 3.956746335650981*^9}, {
   3.956746412212761*^9, 3.956746414229575*^9}, {3.957074375988205*^9, 
   3.957074400981818*^9}, {3.9576137679808083`*^9, 3.9576137866106253`*^9}, {
   3.957613817910742*^9, 3.9576138564709024`*^9}, 3.957616450267956*^9, 
   3.9578270290842*^9, {3.9578835265563407`*^9, 3.957883528687477*^9}, {
   3.9578849646309094`*^9, 3.957884990261099*^9}, {3.9578850626525345`*^9, 
   3.957885081250017*^9}, {3.9579556603907337`*^9, 3.957955672127365*^9}, {
   3.9580665886573677`*^9, 3.9580665894110394`*^9}, {3.9580667951167583`*^9, 
   3.9580667973652515`*^9}, {3.9580668903923798`*^9, 3.958066917451252*^9}, {
   3.9580705450819874`*^9, 3.958070547244301*^9}, {3.9582464161066017`*^9, 
   3.958246431550909*^9}, {3.9582465142762375`*^9, 3.958246575261469*^9}, {
   3.9582467267991753`*^9, 3.958246730440336*^9}, 3.9595715955894947`*^9, 
   3.9595766785956173`*^9, {3.9595767086069183`*^9, 3.9595767092270947`*^9}, {
   3.959576953134609*^9, 3.959576954208067*^9}},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"fd6b755e-c6fe-184f-96a6-c910aea9c24b"],

Cell[TextData[{
 "If we have a Noether Symmetry ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"vvf", "'"}]}]], "InlineCode",ExpressionUUID->
  "6d34635e-8938-544b-8a93-4cd0eff27d1f"],
 ", by Noether\[CloseCurlyQuote]s theorem, we have a conserved quantity \
(Noether charge). ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " allows us to build the Noether current (which upon integration over an \
(n-1)-Cauchy surface becomes a conserved Noether Charge):"
}], "Text",
 CellChangeTimes->{{3.950884789162279*^9, 3.950884811936074*^9}, {
   3.950891554263384*^9, 3.9508915554541874`*^9}, {3.950964371067505*^9, 
   3.9509644859104424`*^9}, {3.95096469094192*^9, 3.950964726308975*^9}, {
   3.95096477509194*^9, 3.950964798296917*^9}, {3.950965821955023*^9, 
   3.9509658229383774`*^9}, {3.950965980564823*^9, 3.950966021297865*^9}, {
   3.950966106334905*^9, 3.9509661496328773`*^9}, 3.950967560926356*^9, 
   3.9559413995904765`*^9, {3.958066940044321*^9, 
   3.9580669539037437`*^9}},ExpressionUUID->"16bbe844-8537-0c41-9c96-\
9ff7b2f4ed00"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["J", "vvf"], "=", 
   RowBox[{
    SubscriptBox["S", "vvf"], "-", 
    RowBox[{
     SubscriptBox["\[ImaginaryI]", "vvf"], "\[CapitalTheta]", "     ", 
     RowBox[{"(", 
      RowBox[{
      "where", " ", "vvf", " ", "is", " ", "a", " ", "Noether", " ", 
       "symmetry"}], ")"}]}]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.950884789162279*^9, 3.950884811936074*^9}, {
  3.950891554263384*^9, 3.9508915554541874`*^9}, {3.950964371067505*^9, 
  3.9509644859104424`*^9}, {3.95096469094192*^9, 3.950964726308975*^9}, {
  3.95096477509194*^9, 3.950964798296917*^9}, {3.950965821955023*^9, 
  3.9509658229383774`*^9}, {3.950965980564823*^9, 3.950966087284403*^9}, {
  3.9510501621019497`*^9, 3.9510501709290447`*^9}, {3.9545037710123043`*^9, 
  3.954503779439703*^9}, {3.9578831064948483`*^9, 3.9578831084528265`*^9}, {
  3.957883437425128*^9, 3.957883440399045*^9}, {3.958041412287754*^9, 
  3.9580414146923637`*^9}, {3.958066966063751*^9, 3.9580669712591515`*^9}},
 TextAlignment->Center,
 CellTags->
  "eq: Noether \
current",ExpressionUUID->"0cdb52f0-ac52-204e-99d5-d09b5be0d025"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "vvf"], TraditionalForm]],ExpressionUUID->
  "e306bf39-b17d-d148-99cb-82afb4f63ee4"],
 " is the Noether Potential given by Equation (",
 StyleBox[
 CounterBox["DisplayFormulaNumbered", "eq: LL_vvfL=dS"],
  FontColor->RGBColor[0., 0., 1.]],
 ") ",
 StyleBox["and \[CapitalTheta] is the symplectic potential given by Equation \
(",
  FontColor->RGBColor[0., 0., 0.]],
 StyleBox[
 CounterBox["DisplayFormulaNumbered", "eq: dlL=EOM+dTheta"],
  FontColor->RGBColor[0., 0., 1.]],
 "). There is an overall sign ",
 Cell[BoxData["$NoetherCurrentSign"], "InlineCode",
  FontColor->RGBColor[0., 0., 0.],ExpressionUUID->
  "a60c9fdc-bbde-7e4f-9113-82d09ae4e106"],
 " that is taken by default=1."
}], "Text",
 CellChangeTimes->{{3.950884789162279*^9, 3.950884811936074*^9}, {
   3.950891554263384*^9, 3.9508915554541874`*^9}, {3.950964371067505*^9, 
   3.9509644859104424`*^9}, {3.95096469094192*^9, 3.950964726308975*^9}, {
   3.95096477509194*^9, 3.950964798296917*^9}, {3.950965821955023*^9, 
   3.9509658229383774`*^9}, {3.950965980564823*^9, 3.950966021297865*^9}, {
   3.950966091072737*^9, 3.950966101960481*^9}, {3.950966155592001*^9, 
   3.950966203687733*^9}, {3.9509675724787197`*^9, 3.9509675759655538`*^9}, {
   3.950979941671953*^9, 3.950979969234667*^9}, {3.951050180721531*^9, 
   3.95105019102166*^9}, 3.9523444891950407`*^9, 3.954504344745999*^9, {
   3.955524498782873*^9, 3.955524510430892*^9}, {3.9555245714737263`*^9, 
   3.955524576142934*^9}, {3.9580669739197083`*^9, 3.9580669759148045`*^9}, {
   3.9582468705040455`*^9, 3.958246874150402*^9}, {3.9595022809237747`*^9, 
   3.9595022867638893`*^9}},ExpressionUUID->"ca874ba5-f34b-3e46-8a5b-\
0b9f069672bc"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["$NoetherCurrentSign",
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"90450106-067c-c844-81ad-4d9e98fabf84"],
 StyleBox["\n",
  FontSize->3],
 "It defines the global sign of the Noether current."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952437867524809*^9, 3.9524378774013205`*^9}, {
   3.953087305389626*^9, 3.9530873445165377`*^9}, 3.954480967702871*^9, {
   3.955939476203476*^9, 3.9559394785618296`*^9}, {3.9567201414209175`*^9, 
   3.9567201435123315`*^9}, 3.9567201906195354`*^9, {3.956720310900824*^9, 
   3.9567203440153913`*^9}, {3.956720379872291*^9, 3.956720382879834*^9}, {
   3.956723229434642*^9, 3.9567232794873457`*^9}, {3.956743396235732*^9, 
   3.9567434396150417`*^9}, {3.9567434890711126`*^9, 
   3.9567435142721543`*^9}, {3.9567435663608007`*^9, 
   3.9567435842662835`*^9}, {3.956743687294647*^9, 3.956743709995721*^9}, {
   3.956743749468743*^9, 3.9567437733356733`*^9}, {3.956743805608357*^9, 
   3.9567438235650253`*^9}, {3.9567438608251023`*^9, 3.956743887050991*^9}, {
   3.9580670086409245`*^9, 3.9580670204605694`*^9}, {3.958067071848406*^9, 
   3.9580670921723213`*^9}, 3.958070553912016*^9, 3.9582476438924274`*^9},
 Background->GrayLevel[
  0.909804],ExpressionUUID->"7fc76b02-162a-e44f-a477-81c1f89e5f9e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"NoetherCurrent", "[", "vvf3", "]"}], "[", "g", "]"}], "[", 
    RowBox[{"LGR", ",", "ApplyContractedBianchi"}], "]"}], "//", 
   "ContractMetric"}], "//", "Simplification"}], "\[IndentingNewLine]", 
 RowBox[{"NoetherCurrentvvf3LGR", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"LieDToCovD", "[", 
     RowBox[{"%", ",", "LCDer"}], "]"}], "//", "ContractMetric"}], "//", 
   "Simplification"}]}]}], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"0479ecb1-7432-554e-9abc-194e9c97d859"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarLCDer[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[-$CellContext`a],
      Editable->False]}], "-", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[Del]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciLCDer[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`b],
      Editable->False]}], "-", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], 
        SubscriptBox["\[Del]", "b"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`LCDer[-$CellContext`b][
        $CellContext`xi[$CellContext`b]]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], 
        SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {"b", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       xAct`xTensor`LieD[
        $CellContext`xi[$CellContext`a]][
        $CellContext`g[-$CellContext`b, -$CellContext`c]]],
      Editable->False]}], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`b]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], 
       SuperscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`LCDer[$CellContext`b][
       $CellContext`xi[-$CellContext`a]]],
     Editable->False], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "c"], 
        SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`c][
       xAct`xTensor`LieD[
        $CellContext`xi[$CellContext`a]][
        $CellContext`g[-$CellContext`a, -$CellContext`b]]],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.957763417338356*^9, 3.9577859717194877`*^9, 
  3.957787626503823*^9, 3.957789592281593*^9, 3.9580671002857895`*^9, 
  3.9582157720560646`*^9, 3.9595051815133343`*^9, 3.9606416447467785`*^9, 
  3.960642896891344*^9, 3.963954737455147*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"5bde456b-0864-b54e-aac6-44b8c7666b15"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarLCDer[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[-$CellContext`a],
      Editable->False]}], "-", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[Del]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciLCDer[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`b],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.957763417338356*^9, 3.9577859717194877`*^9, 
  3.957787626503823*^9, 3.957789592281593*^9, 3.9580671002857895`*^9, 
  3.9582157720560646`*^9, 3.9595051815133343`*^9, 3.9606416447467785`*^9, 
  3.960642896891344*^9, 3.9639547375536633`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"b2f62c96-22e6-644c-8312-6b9c492d1c1a"]
}, Open  ]],

Cell[TextData[{
 "which is equal, as expected in this case (see [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography CPS JMB-EJSV"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 "]), to 2 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["i", 
     SubscriptBox["n", "M"]], 
    SubscriptBox["i", "\[Xi]"], "EOM"}], TraditionalForm]],ExpressionUUID->
  "cbf8c8e2-0138-8141-890a-09b6d3629701"]
}], "Text",
 CellChangeTimes->{{3.950966277601967*^9, 3.9509662968321304`*^9}, {
   3.9509663779292293`*^9, 3.950966383800848*^9}, {3.950966553593668*^9, 
   3.950966556824524*^9}, 3.950967454246876*^9, {3.9509792428987827`*^9, 
   3.9509792436869698`*^9}, {3.9509799865102177`*^9, 3.950979994466921*^9}, {
   3.9518483269442024`*^9, 3.951848328032646*^9}, {3.9555245490668983`*^9, 
   3.955524549083644*^9}, {3.9555245942629695`*^9, 3.9555246326398916`*^9}, {
   3.957397309130699*^9, 
   3.957397309990791*^9}},ExpressionUUID->"05e4bf88-5256-194d-90f4-\
f04aecb5a29f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"inds", "=", 
       RowBox[{"FindFreeIndices", "[", 
        RowBox[{"EinsteinEq", "//", "Evaluate"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"2", " ", "EinsteinEq", " ", 
      RowBox[{"xi", "[", 
       RowBox[{"-", 
        RowBox[{"inds", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}], 
      RowBox[{"NormalOfLCDer", "[", 
       RowBox[{"-", 
        RowBox[{"inds", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "//", 
   "ContractMetric"}], "//", "Simplification"}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", "NoetherCurrentvvf3LGR"}]}], "Input",
 CellChangeTimes->{{3.958067114311157*^9, 3.9580671150792694`*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"91106348-3c2a-204b-90b3-a5afdcbe2ce8"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarLCDer[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[-$CellContext`a],
      Editable->False]}], "-", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[Del]", "]"}], 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciLCDer[-$CellContext`a, -$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`b],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.9577634174177523`*^9, 3.957785971782109*^9, 
  3.9577876268059144`*^9, 3.9577895924584923`*^9, 3.958067103123642*^9, 
  3.9582157821398697`*^9, 3.9595051873834724`*^9, 3.9606416448426437`*^9, 
  3.9606428970343895`*^9, 3.9639547377307034`*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"2cfad201-94d8-3345-9ed1-26b518fc928b"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9577634174177523`*^9, 3.957785971782109*^9, 
  3.9577876268059144`*^9, 3.9577895924584923`*^9, 3.958067103123642*^9, 
  3.9582157821398697`*^9, 3.9595051873834724`*^9, 3.9606416448426437`*^9, 
  3.9606428970343895`*^9, 3.9639547377497463`*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"d435011c-e223-544c-96f9-13a9ad52f276"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Non-Noether current (Non-Noether charges)"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823495343562*^9}, {
   3.948823721434247*^9, 3.9488237235375814`*^9}, {3.950891657859501*^9, 
   3.9508916604562645`*^9}, {3.95098153719162*^9, 3.950981546575815*^9}, 
   3.9581317990287895`*^9},
 CellTags->
  "Sub Non-Noether current \
(Charges)",ExpressionUUID->"a03a0572-8206-3446-9d76-38c7f2c1b49c"],

Cell[TextData[{
 "The Noether current given by ",
 StyleBox["Equation",
  FontColor->RGBColor[0., 0., 0.]],
 " (",
 StyleBox[
 CounterBox["DisplayFormulaNumbered", "eq: Noether current"],
  FontColor->RGBColor[0, 0, 1]],
 ") is only defined if ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"vvf", "'"}]}]], "InlineCode",ExpressionUUID->
  "dc4c0058-ddd3-b44a-ad70-6128fdd3d006"],
 " is a Noether symmetry. However, if ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"vvf", "'"}]}]], "InlineCode",ExpressionUUID->
  "93ee72dd-c873-774d-9a7b-2c1ed412ff5a"],
 " is given by ",
 Cell[BoxData[
  StyleBox["VVFFromLieD",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",
  FontColor->RGBColor[
   0.5019607843137255, 0.5019607843137255, 0.5019607843137255],ExpressionUUID->
  "26f622cf-1171-e948-943e-e9490e487992"],
 ", then according to ",
 StyleBox["Equation",
  FontColor->RGBColor[0., 0., 0.]],
 " (",
 StyleBox[
 CounterBox["DisplayFormulaNumbered", "eq: LL_{XX_xi}L=L_xiL"],
  FontColor->RGBColor[0, 0, 1]],
 "), we can choose ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "vvf"], "=", 
    RowBox[{
     SubscriptBox["i", "\[Xi]"], "L"}]}], TraditionalForm]],ExpressionUUID->
  "83a5c136-bfb4-b340-9e8d-60fbf5c848e6"],
 " and the Noether current reads:"
}], "Text",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
   3.950891068130377*^9, 3.950891115738426*^9}, {3.95089122726511*^9, 
   3.950891365153498*^9}, {3.950891433390114*^9, 3.950891434360166*^9}, {
   3.9508915124241548`*^9, 3.95089152052244*^9}, {3.9509790738750134`*^9, 
   3.9509790744247723`*^9}, {3.950979116644966*^9, 3.950979203385887*^9}, {
   3.9509793029535847`*^9, 3.950979305238199*^9}, {3.950979580752781*^9, 
   3.9509796923739433`*^9}, {3.9509800293032513`*^9, 3.950980060883007*^9}, {
   3.9509801829369354`*^9, 3.950980214488493*^9}, {3.950980293199459*^9, 
   3.9509803269339657`*^9}, {3.950980369791624*^9, 3.9509805801764774`*^9}, 
   3.952344525089732*^9, {3.956408239852625*^9, 3.9564082442675905`*^9}, 
   3.9578831105012255`*^9, 3.9578832438222113`*^9, {3.958067124176203*^9, 
   3.958067154379553*^9}, {3.958246879731077*^9, 3.9582468822959003`*^9}, 
   3.9595052183609104`*^9},ExpressionUUID->"06791ba3-f6a3-264d-ba87-\
8bda7bf4e3dc"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["J", "vvf"], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["i", "\[Xi]"], "L"}], "-", 
    RowBox[{
     SubscriptBox["\[ImaginaryI]", "vvf"], "\[CapitalTheta]", "     ", 
     RowBox[{"(", 
      RowBox[{"vvf", " ", "is", " ", "a", " ", "Noether", " ", "symmetry"}], 
      ")"}]}]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
   3.950891068130377*^9, 3.950891115738426*^9}, {3.95089122726511*^9, 
   3.950891365153498*^9}, {3.950891433390114*^9, 3.950891434360166*^9}, {
   3.9508915124241548`*^9, 3.95089152052244*^9}, {3.9509790738750134`*^9, 
   3.9509790744247723`*^9}, {3.950979116644966*^9, 3.950979203385887*^9}, {
   3.9509793029535847`*^9, 3.950979305238199*^9}, {3.950979580752781*^9, 
   3.9509796923739433`*^9}, {3.9509800293032513`*^9, 3.950980060883007*^9}, {
   3.9509801829369354`*^9, 3.950980214488493*^9}, {3.950980293199459*^9, 
   3.9509803269339657`*^9}, {3.950980369791624*^9, 3.9509806707157784`*^9}, 
   3.957883112217625*^9, 3.957883246119378*^9, 3.957883435922667*^9, {
   3.9580414304873867`*^9, 3.958041431221754*^9}, {3.9580671556384964`*^9, 
   3.95806715861878*^9}},
 TextAlignment->Center,ExpressionUUID->"3e2996ae-2be7-6e49-9970-ccafd865a490"],

Cell[TextData[{
 StyleBox["Important:",
  FontWeight->"Bold"],
 StyleBox[" This expression makes sense even if ",
  FontWeight->"Plain"],
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"vvf", "'"}]}]], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"973d093a-10fc-ef46-9f7b-ee67f8cf303c"],
 StyleBox[" is not a Noether symmetry! In that case, we obtain a Non-Noether \
current associated with a vector field of the manifold:",
  FontWeight->"Plain"]
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.959573346626133*^9, 3.9595733471500225`*^9}, {
   3.959574171132084*^9, 3.9595741748145027`*^9}, 3.9595796454104996`*^9},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"2e6be163-2a34-6748-b7ef-be2a79be792c"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["J", "\[Xi]"], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["i", "\[Xi]"], "L"}], "-", 
    RowBox[{
     SubscriptBox["\[ImaginaryI]", 
      StyleBox[
       RowBox[{"VVFFromLieD", "[", "\[Xi]", "]"}],
       FontColor->RGBColor[0., 0., 0.]]], "\[CapitalTheta]", "     ", 
     RowBox[{"(", 
      RowBox[{
      "vvf", " ", "not", " ", "necessarily", " ", "a", " ", "Noether", " ", 
       "symmetry"}], ")"}]}]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
   3.950891068130377*^9, 3.950891115738426*^9}, {3.95089122726511*^9, 
   3.950891365153498*^9}, {3.950891433390114*^9, 3.950891434360166*^9}, {
   3.9508915124241548`*^9, 3.95089152052244*^9}, {3.9509790738750134`*^9, 
   3.9509790744247723`*^9}, {3.950979116644966*^9, 3.950979203385887*^9}, {
   3.9509793029535847`*^9, 3.950979305238199*^9}, {3.950979580752781*^9, 
   3.9509796923739433`*^9}, {3.9509800293032513`*^9, 3.950980060883007*^9}, {
   3.9509801829369354`*^9, 3.950980214488493*^9}, {3.950980293199459*^9, 
   3.9509803269339657`*^9}, {3.950980369791624*^9, 3.9509806707157784`*^9}, {
   3.9509807185636787`*^9, 3.950980732002184*^9}, 3.9578831141717577`*^9, 
   3.9578832471837597`*^9, 3.9578834336551914`*^9, {3.958041433232355*^9, 
   3.9580414344453564`*^9}, {3.95806716107008*^9, 3.958067163384676*^9}, {
   3.9582482453425713`*^9, 3.9582482487922935`*^9}},
 TextAlignment->Center,ExpressionUUID->"72476a80-fb5c-2444-9832-f7d118856286"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"CurrentFromVector", "[", "vector", "]"}], "[", 
     RowBox[{"tensors", ",", " ", "der"}], "]"}], "[", "Lagrangian", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"fa9d0c43-7c17-b149-8b86-36ff709cb150"],
 StyleBox["\n",
  FontSize->5],
 "It is a function that computes the current associated with a given vector \
field ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"v", "'"}]}]], "InlineCode",ExpressionUUID->
  "813fd753-8fe0-454b-bbf1-884dbb706c5e"],
 " and a given ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"Lagrangian", "'"}]}]], "InlineCode",ExpressionUUID->
  "17638d69-f01e-6243-816c-ce8d668fd8da"],
 " given by the formula ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["Q", "v"], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Iota]", "v"], "L"}], "-", 
    RowBox[{
     SubscriptBox["\[ImaginaryI]", 
      RowBox[{
       RowBox[{"VVFFromLieD", "[", "v", "]"}], "[", "tensors", "]"}]], 
     "\[CapitalTheta]"}]}]}]], "InlineCode",ExpressionUUID->
  "946c3a1d-2f38-8346-9a21-e8504fb86823"],
 " where \[CapitalTheta] is the ",
 Cell[BoxData[
 "SymplecticPotential"], "InlineCode",ExpressionUUID->
  "55bb0e20-eaf9-874e-92e4-25cdf2b7b8ea"],
 " (here we understand the ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"Lagrangian", "'"}]}]], "InlineCode",ExpressionUUID->
  "c4094316-ae44-f549-9b06-30524a331294"],
 " as a top-form although ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 " treats them as densities). There is an overall sign controlled by ",
 Cell[BoxData[
 "$NoetherCurrentSign"], "InlineCode",ExpressionUUID->
  "836340f2-919c-c24d-b304-141fafcc8875"],
 ".\n",
 StyleBox["\n",
  FontSize->3],
 "- ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"tensors", "'"}]}]], "InlineCode",ExpressionUUID->
  "27aab9bb-2e25-b446-a583-23353d4ab172"],
 " is optional. It is a list of heads of tensors considered as dynamic. If \
not specified, it assumes all tensors present in ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"Lagrangian", "'"}]}]], "InlineCode",ExpressionUUID->
  "e3403b70-9461-d047-874a-c23df7ec0717"],
 " are dynamic.\n- ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"der", "'"}]}]], "InlineCode",ExpressionUUID->
  "94a3275f-597c-4041-8d01-74797a224b11"],
 " is optional. If not specified, it finds the only ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"e0c1dccd-e096-3b48-b386-5f846a8151a6"],
 " present (if several are present, an error is thrown)."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.9530899166937494`*^9, 3.9530899541857758`*^9}, {
   3.9530899843021374`*^9, 3.9530900568495407`*^9}, {3.953090108191616*^9, 
   3.953090114285734*^9}, 3.9544814771444683`*^9, {3.956905158399169*^9, 
   3.95690516614289*^9}, {3.9570745776038914`*^9, 3.9570745786584196`*^9}, {
   3.957074757325061*^9, 3.9570747635776143`*^9}, {3.9573420250055914`*^9, 
   3.9573420453369036`*^9}, {3.957614395471788*^9, 3.9576144549657974`*^9}, {
   3.957883532946025*^9, 3.957883533414729*^9}, {3.957885042559333*^9, 
   3.957885057093937*^9}, {3.9579557022426195`*^9, 3.957955703475788*^9}, {
   3.958066574723213*^9, 3.958066577409731*^9}, {3.958067189371126*^9, 
   3.9580671908332844`*^9}, {3.9580672592986584`*^9, 3.958067331450371*^9}, {
   3.958070557205288*^9, 3.958070559894472*^9}, {3.958215797322647*^9, 
   3.9582157975245304`*^9}, {3.958215918952265*^9, 3.958215926782282*^9}, {
   3.9595052642034264`*^9, 3.9595053317083817`*^9}, 3.959571603108156*^9, {
   3.9595767426047096`*^9, 3.959576745605118*^9}, 3.959576960847233*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"97ed0255-43f3-f643-b468-435a99a4b5e9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CurrentFromVector", "[", "xi", "]"}], "[", "LCDer", "]"}], "[", 
  "Lscalar", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CurrentFromVectorvvf3LGR", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"LieDToCovD", "[", 
     RowBox[{"%", ",", "LCDer"}], "]"}], "//", "ContractMetric"}], "//", 
   "Simplification"}]}]}], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"d05c4c1a-e424-7944-8af7-03693b12bbf7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"(", 
         SubscriptBox["n", "\[Del]"], ")"}], 
        StyleBox[GridBox[{
           {" "},
           {"c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`NormalOfLCDer[-$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Xi]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`xi[$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "a"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[-$CellContext`a][
     $CellContext`phi[]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "b"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[-$CellContext`b][
     $CellContext`phi[]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"(", 
         SubscriptBox["n", "\[Del]"], ")"}], 
        StyleBox[GridBox[{
           {" "},
           {"b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`NormalOfLCDer[-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "a"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[-$CellContext`a][
     $CellContext`phi[]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], "\[Phi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`LieD[
      $CellContext`xi[$CellContext`a]][
      $CellContext`phi[]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]}]], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"(", 
         SubscriptBox["n", "\[Del]"], ")"}], 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`NormalOfLCDer[-$CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "b"], "\[Phi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[-$CellContext`b][
     $CellContext`phi[]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[ScriptCapitalL]", "\[Xi]"], "\[Phi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`LieD[
      $CellContext`xi[$CellContext`a]][
      $CellContext`phi[]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{3.9577634175446587`*^9, 3.9577859719194794`*^9, 
  3.957787627380845*^9, 3.957789593109076*^9, 3.9580673421997986`*^9, 
  3.958126456490879*^9, 3.958215833076111*^9, 3.9595053370393753`*^9, 
  3.9606416451608887`*^9, 3.960642897327963*^9, 3.963954743492592*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"6e6ee047-4512-ab4d-b3fe-c5489e30a00f"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "b"], "\[Phi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LCDer[-$CellContext`b][
    $CellContext`phi[]],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`phi[]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[-$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`b][
       $CellContext`phi[]],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.9577634175446587`*^9, 3.9577859719194794`*^9, 
  3.957787627380845*^9, 3.957789593109076*^9, 3.9580673421997986`*^9, 
  3.958126456490879*^9, 3.958215833076111*^9, 3.9595053370393753`*^9, 
  3.9606416451608887`*^9, 3.960642897327963*^9, 3.963954743585289*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"9672fae9-65d2-5344-bd99-60f266b8cf45"]
}, Open  ]],

Cell[TextData[{
 "As expected in this case (see [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography CPS JMB-EJSV"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 "]), this is equal to -",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False]}]], TraditionalForm]],ExpressionUUID->
  "f876abe6-018f-b748-a2f5-0f8646208e4e"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["i", 
     SubscriptBox["n", "M"]], 
    SubscriptBox["i", "\[Xi]"], Cell[TextData[Cell[BoxData[
    "EnergyMomentumTensor"], "InlineCode",ExpressionUUID->
     "0c5ead15-0593-a440-a2cf-def93e87ac1c"]], "InlineCode",ExpressionUUID->
     "9cd2c106-2dc2-1e4b-a3d5-f2a2f0ee7351"]}], TraditionalForm]],
  ExpressionUUID->"6024502b-125f-fa43-9613-15b7d4f8674a"],
 "."
}], "Text",
 CellChangeTimes->{{3.950217644970909*^9, 3.950217651729204*^9}, {
   3.9502180067713356`*^9, 3.950218051273254*^9}, 3.9505568123146744`*^9, {
   3.950980848721264*^9, 3.9509808846417084`*^9}, {3.951307055768383*^9, 
   3.951307056295067*^9}, {3.9518483196741543`*^9, 3.9518483207292404`*^9}, 
   3.952344575685186*^9, {3.9530901787799788`*^9, 3.9530901787799788`*^9}, {
   3.954481510896968*^9, 3.9544815460809565`*^9}, {3.957342081885373*^9, 
   3.9573420858976355`*^9}, {3.9573973016847177`*^9, 3.957397302502861*^9}, {
   3.958067369561651*^9, 3.9580674018838215`*^9}, {3.9582479149626904`*^9, 
   3.9582479226575336`*^9}, {3.9582479609724617`*^9, 3.958247982116041*^9}, 
   3.9595053399324474`*^9},ExpressionUUID->"5611da1f-d661-a94c-84f8-\
8c29e58c2954"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"inds", "=", 
     RowBox[{"FindFreeIndices", "[", 
      RowBox[{"EnergyMomentumScalar", "//", "Evaluate"}], "]"}]}], "}"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SqrtBox[
        RowBox[{"-", 
         RowBox[{
          RowBox[{"Determinant", "[", "g", "]"}], "[", "]"}]}]]}], 
      "EnergyMomentumScalar", " ", 
      RowBox[{"xi", "[", 
       RowBox[{"-", 
        RowBox[{"inds", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}], 
      RowBox[{"NormalOfLCDer", "[", 
       RowBox[{"-", 
        RowBox[{"inds", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", "//",
      "ContractMetric"}], "//", "Simplification"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"%", "-", "CurrentFromVectorvvf3LGR"}], "//", "ContractMetric"}], "//",
   "Simplification"}]}], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"fb46406b-20c0-a54d-87c2-fc2a8e9940a2"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False]}]], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "b"], "\[Phi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LCDer[-$CellContext`b][
    $CellContext`phi[]],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`phi[]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[-$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[Del]", "b"], "\[Phi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[$CellContext`b][
       $CellContext`phi[]],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.957763417630118*^9, 3.9577859719804783`*^9, 
  3.957787627632961*^9, 3.957789593312091*^9, 3.9580673651246967`*^9, 
  3.9581264588203373`*^9, 3.958215837107956*^9, 3.959505348291645*^9, 
  3.960641645240244*^9, 3.960642897450346*^9, 3.9639547456197224`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"bda2c9e4-4290-bf4e-9ed4-0424d7b04330"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.957763417630118*^9, 3.9577859719804783`*^9, 
  3.957787627632961*^9, 3.957789593312091*^9, 3.9580673651246967`*^9, 
  3.9581264588203373`*^9, 3.958215837107956*^9, 3.959505348291645*^9, 
  3.960641645240244*^9, 3.960642897450346*^9, 3.963954745638714*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"0f43402b-12f4-e94a-81cc-747e9aef97a0"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Detect divergences and find potentials"
}], "Section",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, 3.950553673920715*^9, 
   3.950554040425461*^9, {3.9520906460728703`*^9, 3.952090682043001*^9}, 
   3.9581317951857433`*^9},
 CellTags->
  "Section Detect Divergences and find \
potentials",ExpressionUUID->"5531c51f-a230-9440-936e-b026754e57b6"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". DivergenceQ"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823495343562*^9}, {
   3.948823721434247*^9, 3.9488237235375814`*^9}, {3.9502102197680397`*^9, 
   3.950210221038788*^9}, 3.9520906702973843`*^9},
 CellTags->
  "Sub DivergenceQ",ExpressionUUID->"df200fc3-73f8-1b42-ad75-960d5b3d2813"],

Cell[TextData[{
 "We have talked about ",
 Cell[BoxData[
 "DivergenceQ"], "InlineCode",ExpressionUUID->
  "472b7412-f6a6-414e-8e59-b0cb9b38e6c3"],
 " to explain ",
 Cell[BoxData[
 "NoetherSymmetryQ"], "InlineCode",ExpressionUUID->
  "f752bb1d-ac96-df41-98f8-5795cedfa7c3"],
 ", but let us now explore it in detail."
}], "Text",
 CellChangeTimes->{{3.9544815669320593`*^9, 3.9544815960625086`*^9}, 
   3.956140917263512*^9, {3.9580674153216133`*^9, 
   3.958067453082163*^9}},ExpressionUUID->"53b5d848-bcec-f145-94cf-\
cf5027aa7db8"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"metric", ",", " ", "LC"}], "}"}], ",", " ", "der", ",", " ", 
      "options"}], "]"}], "[", 
    RowBox[{"expr", ",", " ", "optionalfunctions"}], "]"}],
   FontWeight->"Bold"]], "InlineCode",
  FontColor->RGBColor[
   0.5019607843137255, 0.5019607843137255, 0.5019607843137255],ExpressionUUID->
  "ed36f622-e647-1b41-8bc2-a9bb7aebb555"],
 StyleBox["\n",
  FontSize->3],
 "It checks whether ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"expr", "'"}]}]], "InlineCode",ExpressionUUID->
  "f5645d7b-df07-2144-96db-6acff0e17784"],
 " is a total divergence with respect to ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"der", "'"}]}]], "InlineCode",ExpressionUUID->
  "4f665e6e-79f7-334b-8abe-6a3ebeab2dfb"],
 " using ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"metric", "'"}]}]], "InlineCode",ExpressionUUID->
  "b6e5ecb1-7bcc-314b-b6ed-ee76c2aa8b92"],
 ".\n",
 StyleBox["\n",
  FontSize->3],
 "- Option:\n  \:2217 ",
 Cell[BoxData[
  RowBox[{"CheckZero", "\[RightArrow]", "True"}]], "InlineCode",
  ExpressionUUID->"8e535fec-7e44-e04f-8233-f6cdeeb8e2e3"],
 " uses === instead of == to test if EOMs vanish."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.9544816766425524`*^9, 3.9544817198538103`*^9}, {
   3.9546646477631454`*^9, 3.9546647052378983`*^9}, {3.9546652817220945`*^9, 
   3.9546652817220945`*^9}, {3.9559414714116154`*^9, 3.9559415024966145`*^9}, 
   3.9561409306622143`*^9, {3.956904627290557*^9, 3.956904629997997*^9}, {
   3.956904678350766*^9, 3.956904916968489*^9}, {3.957074799063777*^9, 
   3.9570748130708914`*^9}, {3.9570749993007665`*^9, 
   3.9570750017720623`*^9}, {3.9576143378437157`*^9, 
   3.9576143378437157`*^9}, {3.957827113168808*^9, 3.9578271142123623`*^9}, {
   3.9578835380459433`*^9, 3.9578835408547325`*^9}, {3.9578850956480618`*^9, 
   3.9578851100457616`*^9}, {3.957960964730399*^9, 3.9579609695504785`*^9}, 
   3.9580414528533993`*^9, {3.958067458377514*^9, 3.9580674805696926`*^9}, 
   3.9580705657171288`*^9, 3.9580807957126713`*^9, {3.9583892460430546`*^9, 
   3.9583892493300247`*^9}, 3.9595767533237915`*^9, 3.959576968374857*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"1a831a12-fc57-9d47-9764-d99a9398432c"],

Cell[TextData[{
 "Depending on the number of arguments, ",
 Cell[BoxData[
 "DivergenceQ"], "InlineCode",ExpressionUUID->
  "126a46f4-e0b4-4442-93cd-01fe0ce63168"],
 " has different uses and meanings:"
}], "Text",
 CellChangeTimes->{{3.954664713347853*^9, 3.95466475218629*^9}, 
   3.9578271298435783`*^9},ExpressionUUID->"4294c76e-1c82-044d-8bc6-\
a57622e23f73"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"DivergenceQ", "[", "metric", "]"}], "[", "expr", "]"}],
   FontWeight->"Bold"]], "InlineCode",ExpressionUUID->
  "d77eeaa6-ea4b-644d-bced-41acdc39a991"],
 " checks if ",
 Cell[BoxData[
 "expr"], "InlineCode",ExpressionUUID->"7d5f46de-e412-9e40-bdf9-6b33c74e648f"],
 "=",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Del]", "a"], 
   SuperscriptBox["V", "a"], " "}]],
  CellChangeTimes->{{3.9505417867096004`*^9, 3.950541874447735*^9}, 
    3.950554041325003*^9, 3.950979244868086*^9, {3.9513071053220825`*^9, 
    3.951307247170168*^9}, 3.953402194134821*^9},ExpressionUUID->
  "4dfe5c6e-875f-5a40-8e49-9dd0c8744792"],
 " for some vector ",
 Cell[BoxData[
  SuperscriptBox["V", "a"]],
  CellChangeTimes->{{3.9505417867096004`*^9, 3.950541874447735*^9}, 
    3.950554041325003*^9, 3.950979244868086*^9, {3.9513071053220825`*^9, 
    3.951307247170168*^9}, 3.953402194134821*^9},ExpressionUUID->
  "197e97e2-831c-944b-80aa-ba0aefceac99"],
 " where \[Del]=",
 Cell[BoxData[
  RowBox[{"CovDOfMetric", "[", "metric", "]"}]], "InlineCode",ExpressionUUID->
  "682ff181-52a9-3249-ab38-d473a011c4d0"],
 "."
}], "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellDingbat->"\[FilledSmallCircle]",
 CellChangeTimes->{{3.9546651991573334`*^9, 3.954665253880149*^9}, 
   3.9546653500681133`*^9, {3.957342242143306*^9, 
   3.957342247100218*^9}},ExpressionUUID->"4642b65f-049c-ee4d-a138-\
bcea0289c45d"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"metric", ",", " ", "der"}], "]"}], "[", "expr", "]"}],
   FontWeight->"Bold"]], "InlineCode",ExpressionUUID->
  "c3579f9e-1479-cc48-8877-8b7f2eaf4db8"],
 " checks if ",
 Cell[BoxData[
 "expr"], "InlineCode",ExpressionUUID->"6ff268dd-b149-6e49-b666-53a7920ddd31"],
 "=",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["D", "a"], 
   SuperscriptBox["V", "a"], " "}]],
  CellChangeTimes->{{3.9505417867096004`*^9, 3.950541874447735*^9}, 
    3.950554041325003*^9, 3.950979244868086*^9, {3.9513071053220825`*^9, 
    3.951307247170168*^9}, 3.953402194134821*^9},ExpressionUUID->
  "c67e89fa-52be-1848-b3db-30eeb03a708a"],
 "for some vector ",
 Cell[BoxData[
  RowBox[{" ", 
   SuperscriptBox["V", "a"]}]],
  CellChangeTimes->{{3.9505417867096004`*^9, 3.950541874447735*^9}, 
    3.950554041325003*^9, 3.950979244868086*^9, {3.9513071053220825`*^9, 
    3.951307247170168*^9}, 3.953402194134821*^9},ExpressionUUID->
  "7655611b-f087-df4e-8103-fac621c2e974"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"D", "=", "der"}], TraditionalForm]],ExpressionUUID->
  "b1e10465-34dc-584f-977d-02c8ed1dbe72"],
 " is a ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"19bf1615-5a22-164f-8a1d-82b0155a53f3"],
 " (not necessarily the Levi-Civita of metric). An auxiliary metric is \
required."
}], "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellDingbat->"\[FilledSmallCircle]",
 CellChangeTimes->{{3.95466526216337*^9, 3.9546653554428444`*^9}, 
   3.956408283585559*^9, 3.9573422533592978`*^9, {3.957827170541914*^9, 
   3.9578271885640755`*^9}, {3.9578272266618576`*^9, 3.957827232414444*^9}, {
   3.957827270413025*^9, 3.957827273491129*^9}, {3.9578273109222584`*^9, 
   3.957827314742733*^9}},ExpressionUUID->"777026e5-c137-6f44-8749-\
fae684bb1fdc"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"metric", ",", "LC"}], "}"}], ",", "der"}], "]"}], "[", "expr",
     "]"}],
   FontWeight->"Bold"]], "InlineCode",ExpressionUUID->
  "96c09e69-55ff-ec42-b97c-760231dc16d8"],
 " checks if ",
 Cell[BoxData[
 "expr"], "InlineCode",ExpressionUUID->"099c6970-8f95-184c-abd3-58d043bb0888"],
 "=",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["D", "a"], " ", 
   SuperscriptBox["V", "a"]}]],
  CellChangeTimes->{{3.9505417867096004`*^9, 3.950541874447735*^9}, 
    3.950554041325003*^9, 3.950979244868086*^9, {3.9513071053220825`*^9, 
    3.951307247170168*^9}, 3.953402194134821*^9},ExpressionUUID->
  "59a72b37-21f5-1946-afa8-94bfff2b107b"],
 " for some expression ",
 Cell[BoxData[
  SuperscriptBox["V", "a"]],
  CellChangeTimes->{{3.9505417867096004`*^9, 3.950541874447735*^9}, 
    3.950554041325003*^9, 3.950979244868086*^9, {3.9513071053220825`*^9, 
    3.951307247170168*^9}, 3.953402194134821*^9},ExpressionUUID->
  "5f57812b-af20-8740-97ed-9e1718c30ec3"],
 " defined over an inner bundle (it might have contracted inner indices) \
where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"D", "=", "der"}], TraditionalForm]],ExpressionUUID->
  "eabe457f-4bdd-c247-814c-6e4fa4cb1970"],
 " is a ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"368741fc-f3fc-d541-8f0e-24984d80e8d0"],
 " (not necessarily the Levi-Civita of metric). An auxiliary ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"metric", "'"}]}]], "InlineCode",ExpressionUUID->
  "51d8fa52-d86b-2d4e-bb89-e25f6dadbb68"],
 " and an extended CovD ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"LC", "'"}]}]], "InlineCode",ExpressionUUID->
  "f1cfa651-a42c-8842-850e-76daf720bf9f"],
 " are required."
}], "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellDingbat->"\[FilledSmallCircle]",
 CellChangeTimes->{{3.9546651991573334`*^9, 3.954665253880149*^9}, 
   3.9546653500681133`*^9, {3.957342242143306*^9, 3.957342247100218*^9}, {
   3.9578272455470695`*^9, 3.9578272505262623`*^9}, {3.9578272814909477`*^9, 
   3.957827330501417*^9}, {3.958067516104683*^9, 
   3.9580675949446583`*^9}},ExpressionUUID->"2850e01d-484f-5c4a-8414-\
bcd94f3a51e0"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". Metric CovD"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, {3.956515448806574*^9, 
   3.9565154514655113`*^9}, 
   3.9606566513555527`*^9},ExpressionUUID->"7d42ec57-63ca-d544-841e-\
7b919f12c90d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefTensor", "[", 
   RowBox[{
    RowBox[{"alpha", "[", 
     RowBox[{"-", "a"}], "]"}], ",", "M", ",", 
    RowBox[{"PrintAs", "->", "\"\<\[Alpha]\>\""}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"divergence1", "=", 
   RowBox[{
    RowBox[{"LCDer", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"xi", "[", "a", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"divergence2", "=", 
   RowBox[{
    RowBox[{"LCDer", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{
     RowBox[{"xi", "[", "a", "]"}], 
     RowBox[{
      RowBox[{"LCDer", "[", 
       RowBox[{"-", "b"}], "]"}], "@", 
      RowBox[{"xi", "[", "b", "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"divergence3", "=", 
    RowBox[{
     RowBox[{"LCDer", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{
      RowBox[{"xi", "[", "a", "]"}], 
      RowBox[{"alpha", "[", 
       RowBox[{"-", "b"}], "]"}], 
      RowBox[{"alpha", "[", "b", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<First expression: \>\"", ",", "divergence1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Second expression: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"LCDer", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"Keep", "[", 
      RowBox[{
       RowBox[{"xi", "[", "a", "]"}], 
       RowBox[{
        RowBox[{"LCDer", "[", 
         RowBox[{"-", "b"}], "]"}], "@", 
        RowBox[{"xi", "[", "b", "]"}]}]}], "]"}], "]"}], "==", 
    "divergence2"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Third expression: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"LCDer", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"Keep", "[", 
      RowBox[{
       RowBox[{"xi", "[", "a", "]"}], 
       RowBox[{"alpha", "[", 
        RowBox[{"-", "b"}], "]"}], 
       RowBox[{"alpha", "[", "b", "]"}]}], "]"}], "]"}], "==", 
    "divergence3"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"DivergenceQ", "[", "g", "]"}], "[", "divergence1", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", "g", "]"}], "[", "divergence2", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", "g", "]"}], "[", "divergence3", "]"}]}], 
  "}"}]}], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"c4fdf169-cf28-8a48-83fb-3e07225738d5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"First expression: \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "a"], GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[-$CellContext`a][
     $CellContext`xi[$CellContext`a]],
    Editable->False]}],
  SequenceForm["First expression: ", 
   $CellContext`LCDer[-$CellContext`a][
    $CellContext`xi[$CellContext`a]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763417674342*^9, 3.9577859783091288`*^9, 
  3.9577876278394356`*^9, 3.9577895934632683`*^9, 3.9580676101048317`*^9, 
  3.9582158517954445`*^9, 3.9595054047242336`*^9, 3.960641645376442*^9, 
  3.9639547586289845`*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"5412c594-6860-cb40-b491-b9899dbfa61e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Second expression: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "a"], "(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`xi[$CellContext`a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "b"], GridBox[{
             {"\[Xi]", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`LCDer[-$CellContext`b][
          $CellContext`xi[$CellContext`b]],
         Editable->False]}], ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`a][
      xAct`xTensor`Keep[$CellContext`xi[$CellContext`a] \
$CellContext`LCDer[-$CellContext`b][
         $CellContext`xi[$CellContext`b]]]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`xi[$CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "a"], 
         SubscriptBox["\[Del]", "b"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`a][
        $CellContext`LCDer[-$CellContext`b][
         $CellContext`xi[$CellContext`b]]],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "a"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`a][
        $CellContext`xi[$CellContext`a]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "b"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`b][
        $CellContext`xi[$CellContext`b]],
       Editable->False]}]}]}]}],
  SequenceForm["Second expression: ", $CellContext`LCDer[-$CellContext`a][
     xAct`xTensor`Keep[$CellContext`xi[$CellContext`a] \
$CellContext`LCDer[-$CellContext`b][
        $CellContext`xi[$CellContext`b]]]] == $CellContext`xi[$CellContext`a] \
$CellContext`LCDer[-$CellContext`a][
       $CellContext`LCDer[-$CellContext`b][
        $CellContext`xi[$CellContext`b]]] + \
$CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`a]] $CellContext`LCDer[-$CellContext`b][
       $CellContext`xi[$CellContext`b]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763417674342*^9, 3.9577859783091288`*^9, 
  3.9577876278394356`*^9, 3.9577895934632683`*^9, 3.9580676101048317`*^9, 
  3.9582158517954445`*^9, 3.9595054047242336`*^9, 3.960641645376442*^9, 
  3.963954758704006*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"e5694229-7efd-3347-a179-27f43efcaa4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Third expression: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "a"], "(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {" "},
                {"b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[-$CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[$CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`xi[$CellContext`a],
         Editable->False]}], ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`a][
      xAct`xTensor`Keep[$CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b] $CellContext`xi[$CellContext`a]]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Alpha]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`alpha[$CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`xi[$CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[Del]", "a"], GridBox[{
           {"\[Alpha]", 
            StyleBox[GridBox[{
               {" "},
               {"b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`LCDer[-$CellContext`a][
        $CellContext`alpha[-$CellContext`b]],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Alpha]", 
           StyleBox[GridBox[{
              {" "},
              {"b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`alpha[-$CellContext`b],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Xi]", 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`xi[$CellContext`a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "a"], GridBox[{
              {"\[Alpha]", 
               StyleBox[GridBox[{
                  {"b"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`LCDer[-$CellContext`a][
           $CellContext`alpha[$CellContext`b]],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Alpha]", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`alpha[$CellContext`b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "a"], GridBox[{
              {"\[Xi]", 
               StyleBox[GridBox[{
                  {"a"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`LCDer[-$CellContext`a][
           $CellContext`xi[$CellContext`a]],
          Editable->False]}]}], ")"}]}]}]}]}],
  SequenceForm["Third expression: ", $CellContext`LCDer[-$CellContext`a][
     xAct`xTensor`Keep[$CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b] $CellContext`xi[$CellContext`a]]] == \
$CellContext`alpha[$CellContext`b] $CellContext`xi[$CellContext`a] \
$CellContext`LCDer[-$CellContext`a][
       $CellContext`alpha[-$CellContext`b]] + \
$CellContext`alpha[-$CellContext`b] ($CellContext`xi[$CellContext`a] \
$CellContext`LCDer[-$CellContext`a][
         $CellContext`alpha[$CellContext`b]] + \
$CellContext`alpha[$CellContext`b] $CellContext`LCDer[-$CellContext`a][
         $CellContext`xi[$CellContext`a]])],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763417674342*^9, 3.9577859783091288`*^9, 
  3.9577876278394356`*^9, 3.9577895934632683`*^9, 3.9580676101048317`*^9, 
  3.9582158517954445`*^9, 3.9595054047242336`*^9, 3.960641645376442*^9, 
  3.9639547588066425`*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"d710059c-25e1-af4c-8a4e-0c8965ccce2b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.957763418699872*^9, 3.957785979340438*^9, 
  3.9577876315567255`*^9, 3.9577895978127747`*^9, 3.958067612655548*^9, 
  3.958215854364437*^9, 3.9595054075762978`*^9, 3.9606416471694965`*^9, 
  3.9639547617298203`*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"2d296917-6b7c-aa42-bb8c-f61e27936a14"]
}, Open  ]],

Cell["\<\
Instead of the metric, it is equivalent to use the Levi-Civita connection:\
\>", "Text",
 CellChangeTimes->{{3.95055400487894*^9, 3.950554032590912*^9}, {
  3.950554077952696*^9, 3.950554096230692*^9}, {3.950623878441056*^9, 
  3.950623884883335*^9}, {3.9565189110592804`*^9, 3.9565189287992744`*^9}, {
  3.956518995707695*^9, 
  3.956518995851166*^9}},ExpressionUUID->"3010c61d-2a37-a74c-9d3a-\
2899220c71e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"DivergenceQ", "[", "LCDer", "]"}], "[", "divergence1", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", "LCDer", "]"}], "[", "divergence2", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", "LCDer", "]"}], "[", "divergence3", "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[69]:=",ExpressionUUID->"497c773a-c6de-0c4a-b92a-a37624f3410f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.957763419697982*^9, 3.957785980417244*^9, 
  3.9577876351747913`*^9, 3.957789602167383*^9, 3.958067619437561*^9, 
  3.958215858321312*^9, 3.959505415503069*^9, 3.9606416488902493`*^9, 
  3.963954764826662*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"6e1aa137-7864-9d4f-ba90-b5e34ea297b7"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["DivergenceQ"], "InlineCode",
  FontColor->RGBColor[0., 0., 0.],ExpressionUUID->
  "4e3ed189-0a70-1b4e-8c24-cb316541a6f3"],
 " checks if certain expressions are zero (see ",
 StyleBox["Section",
  FontColor->RGBColor[0., 0., 0.]],
 StyleBox[" ",
  FontColor->RGBColor[0.25098039215686274`, 0., 0.5019607843137255]],
 StyleBox[
 CounterBox["Chapter", "Section First variation"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Section First variation"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Section First variation"],
  FontColor->RGBColor[0., 0., 1.]],
 "). If they are not, it does not return ",
 Cell[BoxData[
 "False"], "InlineCode",ExpressionUUID->
  "012be9ea-22ff-5144-893f-03e2f39cdd6f"],
 " since applying some nontrivial rules/functions might render that \
expression zero."
}], "Text",
 CellChangeTimes->{{3.95055400487894*^9, 3.950554032590912*^9}, {
   3.950554077952696*^9, 3.950554096230692*^9}, {3.950623878441056*^9, 
   3.950623884883335*^9}, 3.952346173532094*^9, 3.9559415261172743`*^9, {
   3.9566204976593504`*^9, 3.956620498017786*^9}, {3.956620602777526*^9, 
   3.956620641430608*^9}, {3.957396869091121*^9, 3.957396871925802*^9}, {
   3.957827344154892*^9, 3.9578273581676617`*^9}, {3.9579557689678273`*^9, 
   3.9579557700349483`*^9}, {3.9579558513952475`*^9, 
   3.9579558639146867`*^9}, {3.9579566629542685`*^9, 
   3.9579566915024137`*^9}, {3.9580417017338505`*^9, 3.958041702190796*^9}, {
   3.958611542414865*^9, 3.9586115424168725`*^9}, 
   3.959505420562601*^9},ExpressionUUID->"0516b156-5f4f-804e-8cb8-\
7b852bb17ae0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NonDivergence", "=", 
   RowBox[{
    RowBox[{"xi", "[", "a", "]"}], 
    RowBox[{
     RowBox[{"LCDer", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{
      RowBox[{"alpha", "[", 
       RowBox[{"-", "b"}], "]"}], 
      RowBox[{"alpha", "[", "b", "]"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Fourth expression: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"xi", "[", "a", "]"}], 
     RowBox[{
      RowBox[{"LCDer", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"Keep", "[", 
       RowBox[{
        RowBox[{"alpha", "[", 
         RowBox[{"-", "b"}], "]"}], 
        RowBox[{"alpha", "[", "b", "]"}]}], "]"}], "]"}]}], "==", 
    "NonDivergence"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DivergenceQ", "[", "g", "]"}], "[", "NonDivergence", 
  "]"}]}], "Input",
 CellLabel->"In[70]:=",ExpressionUUID->"170cc740-a237-994c-9d29-3c54096e6a54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Fourth expression: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], "(", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Alpha]", 
              StyleBox[GridBox[{
                 {" "},
                 {"b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`alpha[-$CellContext`b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Alpha]", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`alpha[$CellContext`b],
          Editable->False]}], ")"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       xAct`xTensor`Keep[$CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b]]],
      Editable->False]}], "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`a],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[$CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "a"], GridBox[{
             {"\[Alpha]", 
              StyleBox[GridBox[{
                 {" "},
                 {"b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`LCDer[-$CellContext`a][
          $CellContext`alpha[-$CellContext`b]],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {" "},
                {"b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[-$CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "a"], GridBox[{
             {"\[Alpha]", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`LCDer[-$CellContext`a][
          $CellContext`alpha[$CellContext`b]],
         Editable->False]}]}], ")"}]}]}]}],
  SequenceForm[
  "Fourth expression: ", $CellContext`xi[$CellContext`a] \
$CellContext`LCDer[-$CellContext`a][
      xAct`xTensor`Keep[$CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b]]] == $CellContext`xi[$CellContext`a] \
($CellContext`alpha[$CellContext`b] $CellContext`LCDer[-$CellContext`a][
        $CellContext`alpha[-$CellContext`b]] + \
$CellContext`alpha[-$CellContext`b] $CellContext`LCDer[-$CellContext`a][
        $CellContext`alpha[$CellContext`b]])],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763419729641*^9, 3.9577859804800234`*^9, 
  3.9577876353349915`*^9, 3.9577896023028727`*^9, 3.9580676469157963`*^9, 
  3.9582158591936607`*^9, 3.9595054274011555`*^9, 3.960641649100996*^9, 
  3.9639547650787506`*^9},
 CellLabel->
  "During evaluation of \
In[70]:=",ExpressionUUID->"65e6d783-c3a9-4a4e-8a0b-88b0941340ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`xi[$CellContext`b]],
     Editable->False]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {" "},
             {"b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`a][
      $CellContext`alpha[-$CellContext`b]],
     Editable->False]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "c"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`c][
       $CellContext`xi[$CellContext`c]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {"c"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`a, $CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"d"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "d"], GridBox[{
          {"\[Alpha]", 
           StyleBox[GridBox[{
              {" "},
              {"c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`d][
       $CellContext`alpha[-$CellContext`c]],
      Editable->False]}]}], "\[Equal]", "0"}]}]], "Output",
 CellChangeTimes->{3.957763420112176*^9, 3.9577859809170322`*^9, 
  3.957787636664181*^9, 3.9577896039038877`*^9, 3.95806764771471*^9, 
  3.9582158601258316`*^9, 3.959505428269182*^9, 3.96064164957559*^9, 
  3.9639547660562057`*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"2f4afb26-e280-b846-a9d3-a46482234d9f"]
}, Open  ]],

Cell[TextData[{
 "As we have mentioned before, we can try to make the expression zero \
applying functions that are included as arguments of ",
 Cell[BoxData[
  StyleBox["DivergenceQ",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "cd56c707-7fbd-2944-8f34-0706c7c53eea"],
 " :"
}], "Text",
 CellChangeTimes->{{3.950556604117647*^9, 3.950556630374668*^9}, {
   3.9512488900695667`*^9, 3.951248893628536*^9}, 3.952346207130851*^9, {
   3.9546653870122795`*^9, 3.9546653870122795`*^9}, {3.9564082928709965`*^9, 
   3.956408294229039*^9}, 3.957883116769986*^9, 
   3.9578832484583163`*^9},ExpressionUUID->"bceac7e0-5dfe-a74e-a5b1-\
3c18c3c70cab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DivergenceQ", "[", "g", "]"}], "[", 
   RowBox[{"NonDivergence", ",", "ContractMetric", ",", "Simplification"}], 
   "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "They", " ", "are", " ", "applied", " ", "in", " ", "the", " ", "order", 
      " ", "of", " ", 
      RowBox[{"appearence", ":"}]}], " ", "//", "ContractMetric"}], "//", 
    "Simplification"}], " ", "*)"}]}]], "Input",
 CellLabel->"In[73]:=",ExpressionUUID->"8f7be3bc-6868-6540-a11b-75d670633837"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`xi[$CellContext`b]],
     Editable->False]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {" "},
             {"b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`a][
      $CellContext`alpha[-$CellContext`b]],
     Editable->False]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "c"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`c][
       $CellContext`xi[$CellContext`c]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {"c"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`a, $CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"d"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "d"], GridBox[{
          {"\[Alpha]", 
           StyleBox[GridBox[{
              {" "},
              {"c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`d][
       $CellContext`alpha[-$CellContext`c]],
      Editable->False]}]}], "\[Equal]", "0"}]}]], "Output",
 CellChangeTimes->{3.957763420489983*^9, 3.957785981353893*^9, 
  3.9577876380662584`*^9, 3.957789605550312*^9, 3.9580676585978756`*^9, 
  3.958215863191473*^9, 3.9595054348422184`*^9, 3.9606416501812305`*^9, 
  3.9639547672119274`*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"9a94ead1-27fc-0948-8c7d-59d25d443403"]
}, Open  ]],

Cell[TextData[{
 "In this case, it is not zero but we will later see examples where a \
divergence requires some functions to be zero. In any case, we can set the \
option ",
 Cell[BoxData["CheckZero"], "InlineCode",
  FontColor->RGBColor[0., 0., 0.],ExpressionUUID->
  "8c0eee30-eb6c-8e46-9eed-9214f08c3652"],
 " to return ",
 Cell[BoxData[
 "False"], "InlineCode",ExpressionUUID->
  "13c890d3-7b5b-f646-9060-dda227e92b67"],
 " unless we get exactly zero ( use of ",
 Cell[BoxData[
  StyleBox["===",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"1dddf920-e025-df48-b473-35cb1664024f"],
 " instead of ",
 Cell[BoxData[
  StyleBox["==",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"d1e09ed8-1b19-124b-a96f-1844fa7828e5"],
 " ):"
}], "Text",
 CellChangeTimes->{
  3.95055621490802*^9, {3.9505566462672977`*^9, 3.9505566809402905`*^9}, {
   3.9506239034900036`*^9, 3.9506239087081776`*^9}, {3.952346222765386*^9, 
   3.952346245473257*^9}, {3.958067672794695*^9, 3.9580676747864227`*^9}, 
   3.9582376505322495`*^9, {3.9595054429778233`*^9, 
   3.959505444242176*^9}},ExpressionUUID->"0b759859-62d8-b742-893a-\
88aa0cf80e30"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DivergenceQ", "[", 
   RowBox[{"g", ",", 
    RowBox[{"CheckZero", "->", "True"}]}], "]"}], "[", "NonDivergence", 
  "]"}]], "Input",
 CellChangeTimes->{{3.9580676766999245`*^9, 3.9580676777229347`*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"a1e81192-a200-154c-9d15-06ba1aa45949"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9577634208896055`*^9, 3.9577859817751513`*^9, 
  3.957787639510127*^9, 3.957789607250758*^9, 3.958067679255028*^9, 
  3.9582158657285995`*^9, 3.9595054474798985`*^9, 3.9606416507841034`*^9, 
  3.963954769406063*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"3b20c7f6-b4bd-834a-8fab-55bb36c74c9f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". NonMetric CovD"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, {3.956515448806574*^9, 
   3.9565154641427784`*^9}, 
   3.960656654299122*^9},ExpressionUUID->"66deff6b-1cba-8946-bf46-\
44568d51e3a1"],

Cell[TextData[{
 "We can also check for a non-metric ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"18d19bb7-3a82-9940-880a-5cbbcb0748b6"],
 ". In that case, we still need an auxiliary metric to perform the \
computations."
}], "Text",
 CellChangeTimes->{{3.9505564366307163`*^9, 3.950556449160469*^9}, {
   3.95055670376528*^9, 3.9505567152804413`*^9}, {3.951307281688717*^9, 
   3.9513072826323566`*^9}, 3.9544817910399685`*^9, 
   3.9564083089823303`*^9},ExpressionUUID->"ba50d26b-d5be-7940-b094-\
d154f108069d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefCovD", "[", 
   RowBox[{
    RowBox[{"der", "[", 
     RowBox[{"-", "a"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<D\>\""}], "}"}], ",", 
    RowBox[{"Torsion", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"divergence4", "=", 
   RowBox[{
    RowBox[{"der", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"xi", "[", "a", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"divergence5", "=", 
   RowBox[{
    RowBox[{"der", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{
     RowBox[{"xi", "[", "a", "]"}], 
     RowBox[{
      RowBox[{"der", "[", 
       RowBox[{"-", "b"}], "]"}], "@", 
      RowBox[{"xi", "[", "b", "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"divergence6", "=", 
    RowBox[{
     RowBox[{"der", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{
      RowBox[{"xi", "[", "a", "]"}], 
      RowBox[{"alpha", "[", 
       RowBox[{"-", "b"}], "]"}], 
      RowBox[{"alpha", "[", "b", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<First expression: \>\"", ",", "divergence4"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Second expression: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"der", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"Keep", "[", 
      RowBox[{
       RowBox[{"xi", "[", "a", "]"}], 
       RowBox[{
        RowBox[{"der", "[", 
         RowBox[{"-", "b"}], "]"}], "@", 
        RowBox[{"xi", "[", "b", "]"}]}]}], "]"}], "]"}], "==", 
    "divergence5"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Third expression: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"der", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"Keep", "[", 
      RowBox[{
       RowBox[{"xi", "[", "a", "]"}], 
       RowBox[{"alpha", "[", 
        RowBox[{"-", "b"}], "]"}], 
       RowBox[{"alpha", "[", "b", "]"}]}], "]"}], "]"}], "==", 
    "divergence6"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"g", ",", "der"}], "]"}], "[", "divergence4", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"g", ",", "der"}], "]"}], "[", "divergence5", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"g", ",", "der"}], "]"}], "[", "divergence6", "]"}]}], 
  "}"}]}], "Input",
 CellLabel->"In[75]:=",ExpressionUUID->"793c612b-4932-0f4e-a79c-5d9d6b3a1a50"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"First expression: \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["D", "a"], GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`der[-$CellContext`a][
     $CellContext`xi[$CellContext`a]],
    Editable->False]}],
  SequenceForm["First expression: ", 
   $CellContext`der[-$CellContext`a][
    $CellContext`xi[$CellContext`a]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763420948757*^9, 3.95778598187737*^9, 
  3.957787639819307*^9, 3.9577896075614724`*^9, 3.9580676927586536`*^9, 
  3.95821586983947*^9, 3.959505452016735*^9, 3.960641650895281*^9, 
  3.9639547701073875`*^9},
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"152643be-2d56-3d49-aaaa-63d03dddcc0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Second expression: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["D", "a"], "(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`xi[$CellContext`a],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["D", "b"], GridBox[{
              {"\[Xi]", 
               StyleBox[GridBox[{
                  {"b"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`der[-$CellContext`b][
           $CellContext`xi[$CellContext`b]],
          Editable->False], ")"}]}], ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`der[-$CellContext`a][
      xAct`xTensor`Keep[$CellContext`xi[$CellContext`a] \
$CellContext`der[-$CellContext`b][
         $CellContext`xi[$CellContext`b]]]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`xi[$CellContext`a],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["D", "a"], 
          SubscriptBox["D", "b"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`der[-$CellContext`a][
         $CellContext`der[-$CellContext`b][
          $CellContext`xi[$CellContext`b]]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["D", "a"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`der[-$CellContext`a][
         $CellContext`xi[$CellContext`a]],
        Editable->False], ")"}], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["D", "b"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`der[-$CellContext`b][
         $CellContext`xi[$CellContext`b]],
        Editable->False], ")"}]}]}]}]}],
  SequenceForm["Second expression: ", $CellContext`der[-$CellContext`a][
     xAct`xTensor`Keep[$CellContext`xi[$CellContext`a] \
$CellContext`der[-$CellContext`b][
        $CellContext`xi[$CellContext`b]]]] == $CellContext`xi[$CellContext`a] \
$CellContext`der[-$CellContext`a][
       $CellContext`der[-$CellContext`b][
        $CellContext`xi[$CellContext`b]]] + $CellContext`der[-$CellContext`a][
       $CellContext`xi[$CellContext`a]] $CellContext`der[-$CellContext`b][
       $CellContext`xi[$CellContext`b]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763420948757*^9, 3.95778598187737*^9, 
  3.957787639819307*^9, 3.9577896075614724`*^9, 3.9580676927586536`*^9, 
  3.95821586983947*^9, 3.959505452016735*^9, 3.960641650895281*^9, 
  3.96395477020047*^9},
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"01b398ab-f1d9-3f4d-9d2b-b56e5383f282"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Third expression: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["D", "a"], "(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {" "},
                {"b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[-$CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[$CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`xi[$CellContext`a],
         Editable->False]}], ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`der[-$CellContext`a][
      xAct`xTensor`Keep[$CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b] $CellContext`xi[$CellContext`a]]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Alpha]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`alpha[$CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`xi[$CellContext`a],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["D", "a"], GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {" "},
                {"b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`der[-$CellContext`a][
         $CellContext`alpha[-$CellContext`b]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Alpha]", 
           StyleBox[GridBox[{
              {" "},
              {"b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`alpha[-$CellContext`b],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Xi]", 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`xi[$CellContext`a],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["D", "a"], GridBox[{
               {"\[Alpha]", 
                StyleBox[GridBox[{
                   {"b"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`der[-$CellContext`a][
            $CellContext`alpha[$CellContext`b]],
           Editable->False], ")"}]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Alpha]", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`alpha[$CellContext`b],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["D", "a"], GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {"a"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`der[-$CellContext`a][
            $CellContext`xi[$CellContext`a]],
           Editable->False], ")"}]}]}], ")"}]}]}]}]}],
  SequenceForm["Third expression: ", $CellContext`der[-$CellContext`a][
     xAct`xTensor`Keep[$CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b] $CellContext`xi[$CellContext`a]]] == \
$CellContext`alpha[$CellContext`b] $CellContext`xi[$CellContext`a] \
$CellContext`der[-$CellContext`a][
       $CellContext`alpha[-$CellContext`b]] + \
$CellContext`alpha[-$CellContext`b] ($CellContext`xi[$CellContext`a] \
$CellContext`der[-$CellContext`a][
         $CellContext`alpha[$CellContext`b]] + \
$CellContext`alpha[$CellContext`b] $CellContext`der[-$CellContext`a][
         $CellContext`xi[$CellContext`a]])],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763420948757*^9, 3.95778598187737*^9, 
  3.957787639819307*^9, 3.9577896075614724`*^9, 3.9580676927586536`*^9, 
  3.95821586983947*^9, 3.959505452016735*^9, 3.960641650895281*^9, 
  3.963954770311388*^9},
 CellLabel->
  "During evaluation of \
In[75]:=",ExpressionUUID->"6956779d-3831-8346-aea7-6661d5ec14fe"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.9577634218578353`*^9, 3.9577859828018017`*^9, 
  3.957787642872819*^9, 3.9577896111499844`*^9, 3.958067694790457*^9, 
  3.9582158718442173`*^9, 3.9595054542131824`*^9, 3.9606416522138786`*^9, 
  3.9639547727373943`*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"13a4ccaf-954e-8349-9da0-6d2878522e62"]
}, Open  ]],

Cell["\<\
As before, instead of the metric, it is equivalent to use the Levi-Civita \
connection:\
\>", "Text",
 CellChangeTimes->{{3.95055400487894*^9, 3.950554032590912*^9}, {
  3.950554077952696*^9, 3.950554096230692*^9}, {3.950623878441056*^9, 
  3.950623884883335*^9}, {3.9565189110592804`*^9, 3.9565189287992744`*^9}, {
  3.956518995707695*^9, 3.956518995851166*^9}, {3.9565190968078537`*^9, 
  3.956519101185793*^9}},ExpressionUUID->"1cd6b111-d6c2-3846-b41c-\
ef332defc9df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"LCDer", ",", "der"}], "]"}], "[", "divergence4", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"LCDer", ",", "der"}], "]"}], "[", "divergence5", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"LCDer", ",", "der"}], "]"}], "[", "divergence6", "]"}]}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.958067698163086*^9, 3.9580676991661396`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"521b5c9c-4d16-2d4a-b589-80bc4d75ce70"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.9577634226903915`*^9, 3.9577859836675425`*^9, 
  3.9577876459698267`*^9, 3.9577896147099237`*^9, 3.958067701509001*^9, 
  3.958215876113495*^9, 3.9595054637418823`*^9, 3.960641653502922*^9, 
  3.963954775349182*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"1a711907-96c6-0b4f-8757-0ca35dedebb2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ".",
 
 CounterBox["Subsubsection"],
 ". NonMetric CovD of an inner bundle"
}], "Subsubsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667720210234*^9}, {
   3.948667760620362*^9, 3.9486677778687887`*^9}, {3.948667881978399*^9, 
   3.9486679146819863`*^9}, {3.948813583792318*^9, 3.9488135843050904`*^9}, {
   3.948813911390482*^9, 3.94881402564082*^9}, {3.948814462357086*^9, 
   3.948814463767563*^9}, 3.949084608767392*^9, 3.949084795424305*^9, 
   3.9502710520458584`*^9, 3.9502711141810265`*^9, {3.9565154758685474`*^9, 
   3.95651548467449*^9}, 
   3.960656656049309*^9},ExpressionUUID->"3e27e52e-2c46-0848-87bc-\
4367b883b7b4"],

Cell[TextData[{
 "If we use a non-metric ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"2b2cf2a2-460f-d64e-ba32-f2c47e168850"],
 " that is defined over an inner manifold, we run into problems because the \
metric covariant derivative does not know how to act on indices of the inner \
bundle."
}], "Text",
 CellChangeTimes->{{3.9505564366307163`*^9, 3.950556449160469*^9}, {
   3.95055670376528*^9, 3.9505567152804413`*^9}, {3.951307281688717*^9, 
   3.9513072826323566`*^9}, {3.9565154909706707`*^9, 
   3.9565155164083233`*^9}, {3.956515550135069*^9, 3.956515570514412*^9}, 
   3.956620804149911*^9, 3.9570750771370907`*^9, {3.9595054727466984`*^9, 
   3.9595054760165577`*^9}},ExpressionUUID->"646d4551-f0e1-4843-84f6-\
534b0b928aad"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefVBundle", "[", 
  RowBox[{"inner", ",", "M", ",", "5", ",", 
   RowBox[{"{", 
    RowBox[{"J", ",", "L", ",", "P", ",", "Q"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefCovD", "[", 
  RowBox[{
   RowBox[{"der2", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "inner", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
StyleBox[\"D\", \"TI\"], TraditionalForm], \"errors\" -> {}, \"input\" -> \
\"\\\\mathcal{D}\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)\>\""}], "}"}], ",", 
   RowBox[{"Torsion", "->", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "J", ",", 
     RowBox[{"-", "L"}]}], "]"}], ",", "M"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"divergence7", "=", 
   RowBox[{
    RowBox[{"der2", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"T", "[", 
     RowBox[{"a", ",", "J", ",", 
      RowBox[{"-", "J"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"divergence8", "=", 
   RowBox[{
    RowBox[{"der2", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"a", ",", "J", ",", 
       RowBox[{"-", "L"}]}], "]"}], 
     RowBox[{
      RowBox[{"der2", "[", 
       RowBox[{"-", "b"}], "]"}], "@", 
      RowBox[{"T", "[", 
       RowBox[{"b", ",", "L", ",", 
        RowBox[{"-", "J"}]}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"divergence9", "=", 
    RowBox[{
     RowBox[{"der2", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"a", ",", "J", ",", 
        RowBox[{"-", "L"}]}], "]"}], 
      RowBox[{"T", "[", 
       RowBox[{"b", ",", "L", ",", 
        RowBox[{"-", "J"}]}], "]"}], 
      RowBox[{"alpha", "[", 
       RowBox[{"-", "b"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<First expression: \>\"", ",", "divergence7"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Second expression: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"der2", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"Keep", "[", 
      RowBox[{
       RowBox[{"xi", "[", "a", "]"}], 
       RowBox[{
        RowBox[{"der2", "[", 
         RowBox[{"-", "b"}], "]"}], "@", 
        RowBox[{"xi", "[", "b", "]"}]}]}], "]"}], "]"}], "==", 
    "divergence8"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Third expression: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"der2", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"Keep", "[", 
      RowBox[{
       RowBox[{"xi", "[", "a", "]"}], 
       RowBox[{"alpha", "[", 
        RowBox[{"-", "b"}], "]"}], 
       RowBox[{"alpha", "[", "b", "]"}]}], "]"}], "]"}], "==", 
    "divergence9"}]}], "]"}]}], "Input",
 CellLabel->"In[84]:=",ExpressionUUID->"7190ebf6-605e-4447-9f52-6d498c89cbee"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"First expression: \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox[
       TemplateBox[<|"boxes" -> FormBox[
           StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
         "\\mathcal{D}", "state" -> "Boxes"|>,
        "TeXAssistantTemplate"], "a"], GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {"a", "J", " "},
            {" ", " ", "J"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`der2[-$CellContext`a][
     $CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`J]],
    Editable->False]}],
  SequenceForm["First expression: ", 
   $CellContext`der2[-$CellContext`a][
    $CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`J]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763422848445*^9, 3.95778598390664*^9, 
  3.957787646464646*^9, 3.9577896151687193`*^9, 3.958067711694105*^9, 
  3.9582158775762444`*^9, 3.959505468935522*^9, 3.9606416537725143`*^9, 
  3.963954776057852*^9},
 CellLabel->
  "During evaluation of \
In[84]:=",ExpressionUUID->"c622535f-bec2-0b4a-9159-14585f46c3d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"Second expression: \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox[
        TemplateBox[<|"boxes" -> FormBox[
            StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
          "\\mathcal{D}", "state" -> "Boxes"|>,
         "TeXAssistantTemplate"], "a"], "(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`xi[$CellContext`a],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             TemplateBox[<|"boxes" -> FormBox[
                 StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, 
               "input" -> "\\mathcal{D}", "state" -> "Boxes"|>,
              "TeXAssistantTemplate"], "b"], GridBox[{
              {"\[Xi]", 
               StyleBox[GridBox[{
                  {"b"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`der2[-$CellContext`b][
           $CellContext`xi[$CellContext`b]],
          Editable->False], ")"}]}], ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`der2[-$CellContext`a][
      xAct`xTensor`Keep[$CellContext`xi[$CellContext`a] \
$CellContext`der2[-$CellContext`b][
         $CellContext`xi[$CellContext`b]]]],
     Editable->False]}], "\[Equal]", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"T", 
          StyleBox[GridBox[{
             {"a", "J", " "},
             {" ", " ", "L"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`L],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox[
          TemplateBox[<|"boxes" -> FormBox[
              StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
            "\\mathcal{D}", "state" -> "Boxes"|>,
           "TeXAssistantTemplate"], "a"], 
         SubscriptBox[
          TemplateBox[<|"boxes" -> FormBox[
              StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
            "\\mathcal{D}", "state" -> "Boxes"|>,
           "TeXAssistantTemplate"], "b"], GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {"b", "L", " "},
               {" ", " ", "J"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`der2[-$CellContext`a][
        $CellContext`der2[-$CellContext`b][
         $CellContext`T[$CellContext`b, $CellContext`L, -$CellContext`J]]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox[
          TemplateBox[<|"boxes" -> FormBox[
              StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
            "\\mathcal{D}", "state" -> "Boxes"|>,
           "TeXAssistantTemplate"], "a"], GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {"a", "J", " "},
               {" ", " ", "L"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`der2[-$CellContext`a][
        $CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`L]],
       Editable->False], ")"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox[
          TemplateBox[<|"boxes" -> FormBox[
              StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
            "\\mathcal{D}", "state" -> "Boxes"|>,
           "TeXAssistantTemplate"], "b"], GridBox[{
           {"T", 
            StyleBox[GridBox[{
               {"b", "L", " "},
               {" ", " ", "J"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`der2[-$CellContext`b][
        $CellContext`T[$CellContext`b, $CellContext`L, -$CellContext`J]],
       Editable->False], ")"}]}]}]}],
  SequenceForm["Second expression: ", $CellContext`der2[-$CellContext`a][
     xAct`xTensor`Keep[$CellContext`xi[$CellContext`a] \
$CellContext`der2[-$CellContext`b][
        $CellContext`xi[$CellContext`b]]]] == $CellContext`T[$CellContext`a, \
$CellContext`J, -$CellContext`L] $CellContext`der2[-$CellContext`a][
       $CellContext`der2[-$CellContext`b][
        $CellContext`T[$CellContext`b, $CellContext`L, -$CellContext`J]]] + \
$CellContext`der2[-$CellContext`a][
       $CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`L]] \
$CellContext`der2[-$CellContext`b][
       $CellContext`T[$CellContext`b, $CellContext`L, -$CellContext`J]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763422848445*^9, 3.95778598390664*^9, 
  3.957787646464646*^9, 3.9577896151687193`*^9, 3.958067711694105*^9, 
  3.9582158775762444`*^9, 3.959505468935522*^9, 3.9606416537725143`*^9, 
  3.963954776210884*^9},
 CellLabel->
  "During evaluation of \
In[84]:=",ExpressionUUID->"b80c159f-95e3-484e-a26d-943325e13249"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Third expression: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox[
        TemplateBox[<|"boxes" -> FormBox[
            StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
          "\\mathcal{D}", "state" -> "Boxes"|>,
         "TeXAssistantTemplate"], "a"], "(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {" "},
                {"b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[-$CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[$CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`xi[$CellContext`a],
         Editable->False]}], ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`der2[-$CellContext`a][
      xAct`xTensor`Keep[$CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b] $CellContext`xi[$CellContext`a]]],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {"a", "J", " "},
              {" ", " ", "L"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`L],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {"b", "L", " "},
              {" ", " ", "J"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[$CellContext`b, $CellContext`L, -$CellContext`J],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           TemplateBox[<|"boxes" -> FormBox[
               StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
             "\\mathcal{D}", "state" -> "Boxes"|>,
            "TeXAssistantTemplate"], "a"], GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {" "},
                {"b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`der2[-$CellContext`a][
         $CellContext`alpha[-$CellContext`b]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Alpha]", 
           StyleBox[GridBox[{
              {" "},
              {"b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`alpha[-$CellContext`b],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {"b", "L", " "},
                 {" ", " ", "J"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[$CellContext`b, $CellContext`L, -$CellContext`J],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox[
              TemplateBox[<|"boxes" -> FormBox[
                  StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, 
                "input" -> "\\mathcal{D}", "state" -> "Boxes"|>,
               "TeXAssistantTemplate"], "a"], GridBox[{
               {"T", 
                StyleBox[GridBox[{
                   {"a", "J", " "},
                   {" ", " ", "L"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`der2[-$CellContext`a][
            $CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`L]],
           Editable->False], ")"}]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"T", 
              StyleBox[GridBox[{
                 {"a", "J", " "},
                 {" ", " ", "L"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`L],
          Editable->False], " ", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox[
              TemplateBox[<|"boxes" -> FormBox[
                  StyleBox["D", "TI"], TraditionalForm], "errors" -> {}, 
                "input" -> "\\mathcal{D}", "state" -> "Boxes"|>,
               "TeXAssistantTemplate"], "a"], GridBox[{
               {"T", 
                StyleBox[GridBox[{
                   {"b", "L", " "},
                   {" ", " ", "J"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`der2[-$CellContext`a][
            $CellContext`T[$CellContext`b, $CellContext`L, -$CellContext`J]],
           Editable->False], ")"}]}]}], ")"}]}]}]}]}],
  SequenceForm["Third expression: ", $CellContext`der2[-$CellContext`a][
     xAct`xTensor`Keep[$CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b] $CellContext`xi[$CellContext`a]]] == \
$CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`L] \
$CellContext`T[$CellContext`b, $CellContext`L, -$CellContext`J] \
$CellContext`der2[-$CellContext`a][
       $CellContext`alpha[-$CellContext`b]] + \
$CellContext`alpha[-$CellContext`b] ($CellContext`T[$CellContext`b, \
$CellContext`L, -$CellContext`J] $CellContext`der2[-$CellContext`a][
         $CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`L]] + \
$CellContext`T[$CellContext`a, $CellContext`J, -$CellContext`L] \
$CellContext`der2[-$CellContext`a][
         $CellContext`T[$CellContext`b, $CellContext`L, -$CellContext`J]])],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763422848445*^9, 3.95778598390664*^9, 
  3.957787646464646*^9, 3.9577896151687193`*^9, 3.958067711694105*^9, 
  3.9582158775762444`*^9, 3.959505468935522*^9, 3.9606416537725143`*^9, 
  3.9639547763675194`*^9},
 CellLabel->
  "During evaluation of \
In[84]:=",ExpressionUUID->"89dbcecd-84e1-dd4b-9d19-b9a0d18c293b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DivergenceQ", "[", 
   RowBox[{"g", ",", "der2"}], "]"}], "[", "divergence8", "]"}]], "Input",
 CellLabel->"In[93]:=",ExpressionUUID->"4c41a9a5-2937-964c-8769-89ad41f65ff1"],

Cell[BoxData[
 TemplateBox[{
  "DivergenceQ", "invalidCovDs", 
   "\" \\!\\(\\*RowBox[{\\\"der2\\\"}]\\) is defined over \\!\\(\\*RowBox[{\\\
\"{\\\", RowBox[{InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]], \\\",\\\", InterpretationBox[StyleBox[\\\"inner\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], inner, Rule[Editable, \
False]]}], \\\"}\\\"}]\\) while \\!\\(\\*RowBox[{\\\"LCDer\\\"}]\\) is \
defined over \\!\\(\\*RowBox[{\\\"{\\\", InterpretationBox[StyleBox[\\\"\
\[DoubleStruckCapitalT]M\\\", Rule[AutoSpacing, False], Rule[ShowAutoStyles, \
False]], TangentM, Rule[Editable, False]], \\\"}\\\"}]\\). Define an \
auxiliary CovD over \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]], \\\",\\\", InterpretationBox[StyleBox[\\\"inner\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], inner, Rule[Editable, \
False]]}], \\\"}\\\"}]\\) with the option \
ExtendedFrom->\\!\\(\\*RowBox[{\\\"LCDer\\\"}]\\)\"", 2, 93, 1, 
   32877990643110882294, "Local", "xAct`xCPS`DivergenceQ"},
  "MessageTemplate2",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.9577634234318285`*^9, 3.9577859844215293`*^9, 
  3.957787647323168*^9, 3.957789615792597*^9, 3.9580677157672424`*^9, 
  3.9582158813498135`*^9, 3.9595054797032146`*^9, 3.9606416539159546`*^9, 
  3.9639547841299*^9},
 CellLabel->
  "During evaluation of \
In[93]:=",ExpressionUUID->"5d9769ff-5c78-4c4f-b45c-83ce0d525817"],

Cell[BoxData[
 TemplateBox[{
  "Throw", "nocatch", 
   "\"Uncaught \\!\\(\\*RowBox[{\\\"Throw\\\", \\\"[\\\", \\\"Null\\\", \\\"]\
\\\"}]\\) returned to top level.\"", 2, 93, 2, 32877990643110882294, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.9577634234318285`*^9, 3.9577859844215293`*^9, 
  3.957787647323168*^9, 3.957789615792597*^9, 3.9580677157672424`*^9, 
  3.9582158813498135`*^9, 3.9595054797032146`*^9, 3.9606416539159546`*^9, 
  3.9639547842071342`*^9},
 CellLabel->
  "During evaluation of \
In[93]:=",ExpressionUUID->"b13dbc66-f427-e444-8dc4-24e88f944f62"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Throw", "[", "Null", "]"}], "]"}]], "Output",
 CellChangeTimes->{3.9577634234687095`*^9, 3.9577859844709*^9, 
  3.9577876475051665`*^9, 3.9577896159038053`*^9, 3.9580677158202553`*^9, 
  3.9582158814544544`*^9, 3.9595054797691402`*^9, 3.9606416539634285`*^9, 
  3.963954784233137*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"090f701f-fff7-d44d-8d90-64c30e642ba1"]
}, Open  ]],

Cell[TextData[{
 "As the error message says, we need to extend the metric ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"2c8ddaeb-f03a-ba49-a7c4-1cc8887988e3"],
 " using ",
 Cell[BoxData[
 "ExtendedFrom"], "InlineCode",ExpressionUUID->
  "9e8abf17-7f24-ea43-94f9-200e4895452e"],
 "."
}], "Text",
 CellChangeTimes->{{3.9505564366307163`*^9, 3.950556449160469*^9}, {
  3.95055670376528*^9, 3.9505567152804413`*^9}, {3.951307281688717*^9, 
  3.9513072826323566`*^9}, {3.9565154909706707`*^9, 3.9565155164083233`*^9}, {
  3.956515550135069*^9, 3.9565156076793613`*^9}, {3.9565172515726223`*^9, 
  3.956517254868231*^9}, {3.956620840428711*^9, 
  3.956620844941196*^9}},ExpressionUUID->"6cd30e26-ab81-a349-972d-\
db2eec7d0e84"],

Cell[BoxData[
 RowBox[{"DefCovD", "[", 
  RowBox[{
   RowBox[{"derAUX", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "inner", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", 
     ",", "\"\<(\!\(\*SubscriptBox[TemplateBox[<|\"boxes\" -> FormBox[
StyleBox[\"D\", \"TI\"], TraditionalForm], \"errors\" -> {}, \"input\" -> \
\"\\\\mathcal{D}\", \"state\" -> \"Boxes\"|>,\"TeXAssistantTemplate\"], \"aux\
\"]\))\>\""}], "}"}], ",", 
   RowBox[{"Torsion", "->", "True"}], ",", 
   RowBox[{"ExtendedFrom", "->", "LCDer"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.956510439635296*^9, 3.9565104922116375`*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"606f16c1-3ab8-7c45-8ad6-d784cabaebca"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"g", ",", "derAUX"}], "}"}], ",", "der2"}], "]"}], "[", 
    "divergence7", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"g", ",", "derAUX"}], "}"}], ",", "der2"}], "]"}], "[", 
    "divergence8", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"g", ",", "derAUX"}], "}"}], ",", "der2"}], "]"}], "[", 
    "divergence9", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"derAUX", ",", "der2"}], "]"}], "[", "divergence7", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"derAUX", ",", "der2"}], "]"}], "[", "divergence8", "]"}], ",", 
   RowBox[{
    RowBox[{"DivergenceQ", "[", 
     RowBox[{"derAUX", ",", "der2"}], "]"}], "[", "divergence9", "]"}]}], 
  "}"}]}], "Input",
 CellLabel->"In[95]:=",ExpressionUUID->"67f1282b-7e1b-424e-a789-6af33242efff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.957763424377453*^9, 3.9577859854146194`*^9, 
  3.957787650757456*^9, 3.957789619825776*^9, 3.9580677330726395`*^9, 
  3.958215888062132*^9, 3.959505487432108*^9, 3.960641655505089*^9, 
  3.9639547902792606`*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"8cb901b8-28cb-df49-aa20-fbfc8478436b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.957763424377453*^9, 3.9577859854146194`*^9, 
  3.957787650757456*^9, 3.957789619825776*^9, 3.9580677330726395`*^9, 
  3.958215888062132*^9, 3.959505487432108*^9, 3.960641655505089*^9, 
  3.96395479257806*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"9b09a26e-eb68-0241-9c52-b456d9593b4d"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". FindPotentialDivergence"
}], "Subsection",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823479141981*^9}, {
   3.950208759856592*^9, 3.950208764266285*^9}, 3.950553673920715*^9, 
   3.950556427209017*^9},
 CellTags->
  "Sub FindPotentialDivergence",ExpressionUUID->"90c12cf2-b721-1d40-b33f-\
ae8e689e63a5"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"FindPotentialDivergence", "[", 
     RowBox[{"der", ",", " ", "iteration"}], "]"}], "[", 
    RowBox[{"expr", ",", " ", "optionalfunctions"}], "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"cf7c6ec2-eaa6-eb4e-a09b-665be0f77059"],
 "\n",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"FindPotentialDivergence", "[", 
     RowBox[{"metric", ",", " ", "iteration"}], "]"}], "[", 
    RowBox[{"expr", ",", " ", "optionalfunctions"}], "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"004d235a-df03-7d47-b555-40848f1e4f42"],
 StyleBox["\n",
  FontSize->5],
 "It looks for ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"potential", "'"}]}]], "InlineCode",ExpressionUUID->
  "6e23aef2-7ae7-fc40-b283-a4cea3f727d3"],
 " such that ",
 Cell[BoxData[
  RowBox[{"expr", "=", 
   RowBox[{
    RowBox[{"der", "[", "ind", "]"}], "[", "potential", "]"}]}]], 
  "InlineCode",ExpressionUUID->"a1c3abbc-48d8-c74d-8506-24ba4dc37fc7"],
 " (where ",
 Cell[BoxData[
  RowBox[{"der", "=", 
   RowBox[{"CovDOfMetric", "[", "metric", "]"}]}]], "InlineCode",
  ExpressionUUID->"3c430e64-fc28-974d-8e5c-6eb764ca2731"],
 " if the metric is provided instead of the ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"b5eb2991-0812-8145-8699-54b2ded7b80f"],
 ").\n",
 StyleBox["\n",
  FontSize->3],
 "- ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"iteration", "'"}]}]], "InlineCode",ExpressionUUID->
  "33d26b1a-e759-c342-aa6d-846b2cd83d71"],
 " is an optional positive integer that limits the amount of iteration in \
order to obtain the middle steps.\n- ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"optionalfunctions", "'"}]}]], "InlineCode",ExpressionUUID->
  "28bea3df-dd12-c844-aa35-117de3626670"],
 " are functions that are applied in the intermediate steps to simplify the \
expressions."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.9505567550869656`*^9, 3.9505567696356583`*^9}, {
   3.9513073840242844`*^9, 3.9513074830333385`*^9}, 3.9523462849691677`*^9, {
   3.9523464441680727`*^9, 3.9523464464962373`*^9}, {3.9525167635077343`*^9, 
   3.9525167952614264`*^9}, {3.9530949706827307`*^9, 3.9530949706827307`*^9}, 
   3.9544817966516504`*^9, {3.955941675478655*^9, 3.9559416970456023`*^9}, {
   3.9570752192438755`*^9, 3.957075224112359*^9}, {3.957075386054262*^9, 
   3.957075387593659*^9}, {3.957075428614583*^9, 3.9570754679091988`*^9}, {
   3.957600826623726*^9, 3.957600828691447*^9}, {3.957614050380802*^9, 
   3.957614173852262*^9}, 3.957616505181982*^9, {3.957827429128668*^9, 
   3.95782745568178*^9}, {3.957829121579281*^9, 3.9578292659388695`*^9}, {
   3.957883548378051*^9, 3.9578835510110354`*^9}, {3.9578851268289127`*^9, 
   3.957885178764411*^9}, {3.957955887912161*^9, 3.957955905135462*^9}, {
   3.957960983072116*^9, 3.957960988660322*^9}, 3.95804146673246*^9, {
   3.958067745944355*^9, 3.958067763044977*^9}, {3.958070571591589*^9, 
   3.958070573367317*^9}, {3.9580809077487392`*^9, 3.9580809098197136`*^9}, {
   3.9583892892631016`*^9, 3.9583893103792*^9}, 3.9595769741125927`*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"67faa3da-0f6f-794f-b0ef-e7b7bbe2d427"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["FindPotentialDivergence",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",
  FontColor->RGBColor[
   0.5019607843137255, 0.5019607843137255, 0.5019607843137255],ExpressionUUID->
  "4ec284d3-8121-5f46-b24d-c2a935fb0207"],
 " does not make use of ",
 Cell[BoxData[
 "DivergenceQ"], "InlineCode",ExpressionUUID->
  "c6649f07-95e7-3a41-8bc5-911bc06b1f88"],
 " because ",
 Cell[BoxData[
 "DivergenceQ"], "InlineCode",ExpressionUUID->
  "66f9185b-6e26-4243-90dc-eabd20ae5f23"],
 " only detects vector divergences ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Del]", "a"], 
   SuperscriptBox["V", "a"]}]],
  CellChangeTimes->{{3.9505417867096004`*^9, 3.950541874447735*^9}, 
    3.950554041325003*^9, 3.950979244868086*^9, {3.9513071053220825`*^9, 
    3.951307247170168*^9}},ExpressionUUID->
  "4e184787-6409-654c-937e-f75ce07d867c"],
 " (this functionality will be extended in future versions of ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 ") while ",
 Cell[BoxData[
  StyleBox["FindPotentialDivergence",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",
  FontColor->RGBColor[
   0.5019607843137255, 0.5019607843137255, 0.5019607843137255],ExpressionUUID->
  "6462468b-c8b6-3747-8b4b-81c0ddeca1a6"],
 StyleBox[" ",
  FontColor->RGBColor[
   0.5019607843137255, 0.5019607843137255, 0.5019607843137255]],
 "can find any tensorial gradient (e.g., ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Del]", "a"], 
   SuperscriptBox["T", "bc"]}]],
  CellChangeTimes->{{3.9505417867096004`*^9, 3.950541874447735*^9}, 
    3.950554041325003*^9, 3.950979244868086*^9, {3.9513071053220825`*^9, 
    3.951307247170168*^9}},ExpressionUUID->
  "c64b81f9-e673-0e41-ac19-6e453159f18f"],
 ")."
}], "Text",
 CellChangeTimes->{
  3.9525168010723104`*^9, {3.9574441511747985`*^9, 3.957444153504815*^9}, {
   3.958067798888752*^9, 3.9580678161392803`*^9}, {3.959505519307314*^9, 
   3.9595055234378967`*^9}, {3.95957336691251*^9, 
   3.959573367061157*^9}},ExpressionUUID->"5b5fc491-9a67-904f-b2bd-\
bc38bb454d66"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"potential1", "=", 
  RowBox[{
   RowBox[{"FindPotentialDivergence", "[", "LCDer", "]"}], "[", "divergence1",
    "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"potential2", "=", 
  RowBox[{
   RowBox[{"FindPotentialDivergence", "[", "LCDer", "]"}], "[", "divergence2",
    "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"potential3", "=", 
  RowBox[{
   RowBox[{"FindPotentialDivergence", "[", "LCDer", "]"}], "[", "divergence3",
    "]"}]}]}], "Input",
 CellLabel->"In[97]:=",ExpressionUUID->"d3e8ff77-36a8-d743-9f7a-f3b0da29f722"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[-$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`xi[$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.9577634252231073`*^9, 3.9577859863353615`*^9, 
  3.9577876538925767`*^9, 3.9577896233271065`*^9, 3.958067788317255*^9, 
  3.9582159836839275`*^9, 3.959505526824627*^9, 3.9606416572449474`*^9, 
  3.963954796789818*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"46b8379c-ea1a-c243-b92e-178be1b3ae7c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[-$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`xi[$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "b"], GridBox[{
       {"\[Xi]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LCDer[-$CellContext`b][
    $CellContext`xi[$CellContext`b]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.9577634252231073`*^9, 3.9577859863353615`*^9, 
  3.9577876538925767`*^9, 3.9577896233271065`*^9, 3.958067788317255*^9, 
  3.9582159836839275`*^9, 3.959505526824627*^9, 3.9606416572449474`*^9, 
  3.963954796873602*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"3c3347a3-5c8a-1441-a0e0-e1bd640609f7"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Alpha]", 
       StyleBox[GridBox[{
          {" "},
          {"b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`alpha[-$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Alpha]", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`alpha[$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"(", 
        SubscriptBox["n", "\[Del]"], ")"}], 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`NormalOfLCDer[-$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`xi[$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.9577634252231073`*^9, 3.9577859863353615`*^9, 
  3.9577876538925767`*^9, 3.9577896233271065`*^9, 3.958067788317255*^9, 
  3.9582159836839275`*^9, 3.959505526824627*^9, 3.9606416572449474`*^9, 
  3.9639547969485435`*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"5aa2a2b9-6427-6f45-9762-28a6f8b0a4b2"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
 "FindPotentialDivergence"], "InlineCode",ExpressionUUID->
  "9d21f49d-ad56-2143-9a69-ad23d941a83a"],
 " uses an auxiliary covector that is defined with D",
 Cell[BoxData[
 "efCovD"], "InlineCode",ExpressionUUID->
  "cc8fd43b-6431-db46-b1b4-79a1db9604f5"],
 ": ",
 Cell[BoxData[
  RowBox[{"NormalOfLCDer", "/", "NormalOfder"}]], "InlineCode",ExpressionUUID->
  "c5e76c90-d0a5-c24f-9962-e5ac700aa587"],
 ". This tensor is multipurpose, in this context it keeps track of the index \
of the ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"730e9ae1-a0df-5c4e-8e53-780f4f0ea207"],
 " (in the previous examples, there is only one free index, but there might \
be more as we will see below). Moreover, for metric ",
 Cell[BoxData[
 "CovDs"], "InlineCode",ExpressionUUID->
  "974a54f0-5131-7941-a9da-e1e532561459"],
 ", this tensor is the one appearing when applying Stokes\[CloseCurlyQuote] \
theorem:"
}], "Text",
 CellChangeTimes->{{3.9505567550869656`*^9, 3.9505567696356583`*^9}, {
  3.9513073840242844`*^9, 3.9513074830333385`*^9}, {3.956519339752102*^9, 
  3.9565195426810265`*^9}, {3.9565197245808525`*^9, 3.9565197262867317`*^9}, {
  3.956620941215602*^9, 3.956620987684851*^9}, {3.958067848006487*^9, 
  3.9580678715188293`*^9}, {3.959505543914076*^9, 
  3.959505546522484*^9}},ExpressionUUID->"8f30e6d3-c8d5-4a47-96d5-\
49ae35e9421c"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "M"], 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Del]", "a"], 
      SuperscriptBox["V", "a"]}], 
     SubscriptBox["vol", "g"]}]}], "=", 
   RowBox[{
    SubscriptBox["\[Integral]", 
     RowBox[{"\[PartialD]", "M"}]], 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{
           SubscriptBox[
            RowBox[{"(", "n"}], "\[Del]"], ")"}], 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`NormalOfLCDer[-$CellContext`a],
      Editable->False], 
     SuperscriptBox["V", "a"], 
     SubscriptBox["vol", 
      RowBox[{"\[PartialD]", "g"}]]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.950890985558349*^9, 3.950891036705971*^9}, {
  3.950891068130377*^9, 3.950891115738426*^9}, {3.95089122726511*^9, 
  3.950891365153498*^9}, {3.950891433390114*^9, 3.950891434360166*^9}, {
  3.9508915124241548`*^9, 3.95089152052244*^9}, {3.9509790738750134`*^9, 
  3.9509790744247723`*^9}, {3.950979116644966*^9, 3.950979203385887*^9}, {
  3.9509793029535847`*^9, 3.950979305238199*^9}, {3.950979580752781*^9, 
  3.9509796923739433`*^9}, {3.9509800293032513`*^9, 3.950980060883007*^9}, {
  3.9509801829369354`*^9, 3.950980214488493*^9}, {3.950980293199459*^9, 
  3.9509803269339657`*^9}, {3.950980369791624*^9, 3.9509806707157784`*^9}, {
  3.9565195580468693`*^9, 3.956519642236473*^9}},
 TextAlignment->Center,ExpressionUUID->"aa16d001-9558-5344-9ad5-c3801193f732"],

Cell[TextData[{
 "This tensor can be obtained with ",
 Cell[BoxData[
 "NormalOfCovD"], "InlineCode",ExpressionUUID->
  "cfc3e915-f61b-164c-ade8-a5fccfa572c2"],
 " (see Section ",
 StyleBox[ButtonBox["A.",
  BaseStyle->"Hyperlink",
  ButtonData->"Section Ap PD"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Section Ap PD"],
  FontColor->RGBColor[0., 0., 1.]],
 " of the Appendix for some further explanations about the particular case ",
 Cell[BoxData[
  RowBox[{"NormalOfCovD", "[", "PD", "]"}]], "InlineCode",ExpressionUUID->
  "c69a223b-377a-ea41-a49c-a17ec3878a8c"],
 "):"
}], "Text",
 CellChangeTimes->{{3.950557865892208*^9, 3.9505578916221294`*^9}, {
   3.951848419851282*^9, 3.9518484365511417`*^9}, {3.9522799011924915`*^9, 
   3.9522799036259403`*^9}, {3.9565196960492725`*^9, 3.9565197089116*^9}, {
   3.9565197457983074`*^9, 3.956519756110588*^9}, {3.9565199359944534`*^9, 
   3.956519939179123*^9}, {3.956620994069932*^9, 3.9566210256291733`*^9}, {
   3.9573978488691096`*^9, 3.9573978717158995`*^9}, 3.957444251182396*^9, {
   3.9576043794267783`*^9, 3.9576043841889067`*^9}, 3.957604437083487*^9, {
   3.9576048008616915`*^9, 3.957604807381448*^9}, {3.9576048390013266`*^9, 
   3.957604841234606*^9}, {3.95760495004494*^9, 3.9576049811616554`*^9}, 
   3.95760501501169*^9, {3.957955915111431*^9, 3.9579559160368853`*^9}, {
   3.957955950361382*^9, 3.9579559656000805`*^9}, {3.957956721437379*^9, 
   3.95795673055729*^9}, {3.958067881430937*^9, 3.958067885837799*^9}, {
   3.958067917467201*^9, 3.9580679609247837`*^9}, 
   3.9595055778875656`*^9},ExpressionUUID->"92ee4c0c-751b-4e4c-8c90-\
f17f60692fcf"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"HoldForm", "[", 
   RowBox[{"NormalOfCovD", "[", "LCDer", "]"}], "]"}], "==", 
  RowBox[{"NormalOfCovD", "[", "LCDer", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NormalOfCovD", "[", "LCDer", "]"}], "[", 
  RowBox[{"-", "a"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NormalOfLCDer", "[", 
  RowBox[{"-", "a"}], "]"}]}], "Input",
 CellLabel->
  "In[100]:=",ExpressionUUID->"7185eb80-0c35-4745-af3e-7dd6750d15d0"],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"NormalOfCovD", "[", "LCDer", "]"}],
   HoldForm], "\[Equal]", "NormalOfLCDer"}]], "Output",
 CellChangeTimes->{3.9577634252908244`*^9, 3.9577859864132643`*^9, 
  3.9577876542493305`*^9, 3.957789623572365*^9, 3.9580679654642906`*^9, 
  3.9582159879082584`*^9, 3.959505583766819*^9, 3.9606416573402843`*^9, 
  3.963954799845957*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"97ba916f-d8cf-294d-832f-da404538a76f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"(", 
       SubscriptBox["n", "\[Del]"], ")"}], 
      StyleBox[GridBox[{
         {" "},
         {"a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`NormalOfLCDer[-$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.9577634252908244`*^9, 3.9577859864132643`*^9, 
  3.9577876542493305`*^9, 3.957789623572365*^9, 3.9580679654642906`*^9, 
  3.9582159879082584`*^9, 3.959505583766819*^9, 3.9606416573402843`*^9, 
  3.9639547999039383`*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"1285505e-c7ed-d446-9958-b582539229d9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"(", 
       SubscriptBox["n", "\[Del]"], ")"}], 
      StyleBox[GridBox[{
         {" "},
         {"a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`NormalOfLCDer[-$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.9577634252908244`*^9, 3.9577859864132643`*^9, 
  3.9577876542493305`*^9, 3.957789623572365*^9, 3.9580679654642906`*^9, 
  3.9582159879082584`*^9, 3.959505583766819*^9, 3.9606416573402843`*^9, 
  3.963954799985729*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"d566a02c-ee99-b94e-b8f0-28ba839a85b7"]
}, Open  ]],

Cell["All the defined Normals are stored in:", "Text",
 CellChangeTimes->{{3.950557865892208*^9, 3.9505578916221294`*^9}, {
   3.951848419851282*^9, 3.9518484365511417`*^9}, {3.9522799011924915`*^9, 
   3.9522799036259403`*^9}, {3.9565196960492725`*^9, 3.9565197089116*^9}, {
   3.9565197457983074`*^9, 3.956519756110588*^9}, {3.9565199359944534`*^9, 
   3.956519939179123*^9}, {3.956521016288458*^9, 3.9565210596695576`*^9}, 
   3.9567436832503543`*^9},ExpressionUUID->"ea1d58f5-2831-f140-847f-\
41f794846fef"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["$NormalsOfCovD",
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"b2096c8b-ecbc-d64c-9a07-08eab23804c9"],
 StyleBox["\n",
  FontSize->3],
 "It is the list of fiducial normals associated with all the defined \
covariant derivatives."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952437867524809*^9, 3.9524378774013205`*^9}, {
   3.953087305389626*^9, 3.9530873445165377`*^9}, 3.954480967702871*^9, {
   3.955939476203476*^9, 3.9559394785618296`*^9}, {3.9567201414209175`*^9, 
   3.9567201435123315`*^9}, 3.9567201906195354`*^9, {3.956720310900824*^9, 
   3.9567203440153913`*^9}, {3.956720379872291*^9, 3.956720382879834*^9}, {
   3.956723229434642*^9, 3.9567232794873457`*^9}, {3.956743396235732*^9, 
   3.9567434396150417`*^9}, {3.9567434890711126`*^9, 
   3.9567435142721543`*^9}, {3.9567435663608007`*^9, 
   3.9567435842662835`*^9}, {3.956743687294647*^9, 3.956743709995721*^9}, {
   3.957883555203503*^9, 3.957883556159853*^9}, {3.9580693112321014`*^9, 
   3.958069313087635*^9}, 3.9580705796998997`*^9, 3.9580809227932777`*^9},
 Background->GrayLevel[
  0.909804],ExpressionUUID->"40cee752-4946-b34a-b1b1-64298fa921d6"],

Cell[CellGroupData[{

Cell[BoxData[{"$NormalsOfCovD", "\n", "$CovDs"}], "Input",
 CellLabel->
  "In[103]:=",ExpressionUUID->"aa93d532-dccb-2740-9c66-918a8809397b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "NormalOfPDOfM", ",", "NormalOfLCDer", ",", "NormalOfder", ",", 
   "NormalOfder2", ",", "NormalOfderAUX"}], "}"}]], "Output",
 CellChangeTimes->{3.9577634253409557`*^9, 3.9577859864588947`*^9, 
  3.957787654584487*^9, 3.957789623782356*^9, 3.9580679709511147`*^9, 
  3.95821599158062*^9, 3.9595055885536194`*^9, 3.960641657404606*^9, 
  3.96395480173267*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"91b6fe87-0eeb-814f-bc54-7f189eb1f2d2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PD", ",", "LCDer", ",", "der", ",", "der2", ",", "derAUX"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9577634253409557`*^9, 3.9577859864588947`*^9, 
  3.957787654584487*^9, 3.957789623782356*^9, 3.9580679709511147`*^9, 
  3.95821599158062*^9, 3.9595055885536194`*^9, 3.960641657404606*^9, 
  3.963954801756668*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"1a160006-ba2f-df48-8bfa-85839270dff9"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Warning:",
  FontWeight->"Bold"],
 " We are essentially changing the covariant derivative by a covector. This \
substitution ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Del]", "a"], "=", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SubscriptBox[
           RowBox[{"(", "n"}], "\[Del]"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfLCDer[-$CellContext`a],
     Editable->False]}], TraditionalForm]],ExpressionUUID->
  "661a097d-4588-3c46-bbe7-4dcca2c23ab9"],
 " works for a very specific context. Notice for instance that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Del]", "a"], 
    SubscriptBox["\[Del]", "b"]}], TraditionalForm]],ExpressionUUID->
  "3b24f826-78a2-e842-92f0-1fa475bad2e9"],
 " is in general different from ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Del]", "b"], 
   SubscriptBox["\[Del]", "a"]}]],ExpressionUUID->
  "9022b6c4-0f9c-7b42-ac3f-c49f0b6fd68f"],
 ". However, for ",
 StyleBox["xAct,",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{
           SubscriptBox[
            RowBox[{"(", "n"}], "\[Del]"], ")"}], 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`NormalOfLCDer[-$CellContext`a],
      Editable->False], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{
           SubscriptBox[
            RowBox[{"(", "n"}], "\[Del]"], ")"}], 
          StyleBox[GridBox[{
             {" "},
             {"b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`NormalOfLCDer[-$CellContext`b],
      Editable->False]}], "=", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{
           SubscriptBox[
            RowBox[{"(", "n"}], "\[Del]"], ")"}], 
          StyleBox[GridBox[{
             {" "},
             {"b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`NormalOfLCDer[-$CellContext`b],
      Editable->False], 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{
           SubscriptBox[
            RowBox[{"(", "n"}], "\[Del]"], ")"}], 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`NormalOfLCDer[-$CellContext`a],
      Editable->False]}]}], TraditionalForm]],ExpressionUUID->
  "52b8b848-f349-8f40-b656-da4d7e78a8ae"],
 ". Thus, some caution has to be exercised when dealing with this objects."
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.9580680018555717`*^9, 3.958068006152872*^9}, {
   3.9595056020029106`*^9, 3.9595056087064247`*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"c02074b2-b15f-1d49-8fb3-6469b633efc6"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"NormalOfCovDToCovD", "[", "expr", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"6cca2bb6-e5a5-d94c-ba98-7bb80a57ad1e"],
 StyleBox["\n",
  FontSize->3],
 "It replaces fiducial normals appearing on ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"expr", "'"}]}]], "InlineCode",ExpressionUUID->
  "bd88e8eb-4668-f94f-a88b-59843d0d55da"],
 " with their corresponding covariant derivatives."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.9505582615538483`*^9, 3.9505582934064617`*^9}, {
   3.9523464706475787`*^9, 3.9523464880812984`*^9}, {3.95448186009798*^9, 
   3.954481876497109*^9}, {3.954665555299899*^9, 3.9546655704097424`*^9}, {
   3.955941870405089*^9, 3.9559418892481613`*^9}, {3.9567455829724684`*^9, 
   3.956745589124617*^9}, {3.957883558453973*^9, 3.9578835597710357`*^9}, {
   3.957885187833141*^9, 3.9578851892865877`*^9}, {3.9580680795370846`*^9, 
   3.9580681009417496`*^9}, {3.9580692994359894`*^9, 3.958069319274719*^9}, 
   3.95807058162702*^9, 3.958080924695513*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"5b975021-06dc-0547-9d6d-7055116adf02"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"{", 
  RowBox[{"potential1", ",", 
   RowBox[{"NormalOfCovDToCovD", "[", "potential1", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NormalOfCovDToCovD", "[", "potential1", "]"}], "-", 
   "divergence1"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"potential2", ",", 
   RowBox[{"NormalOfCovDToCovD", "[", "potential2", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NormalOfCovDToCovD", "[", "potential2", "]"}], "-", 
   "divergence2"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"potential3", ",", 
   RowBox[{"NormalOfCovDToCovD", "[", "potential3", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NormalOfCovDToCovD", "[", "potential3", "]"}], "-", 
    "divergence3"}], "//", "ContractMetric"}], "//", 
  "Simplification"}]}], "Input",
 CellChangeTimes->{{3.9580681213211308`*^9, 3.9580681962571964`*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"fc8dc654-06cc-0244-9d5b-cae3f3629634"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"(", 
          SubscriptBox["n", "\[Del]"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfLCDer[-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False]}], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "a"], GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`LCDer[-$CellContext`a][
     $CellContext`xi[$CellContext`a]],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9577634253715873`*^9, 3.9577859864936056`*^9, 3.957787654752789*^9, 
   3.957789623897874*^9, 3.958068112717556*^9, {3.958068150556286*^9, 
   3.958068196513361*^9}, 3.958215995664446*^9, 3.9595056162467823`*^9, 
   3.960641657483841*^9, 3.9639548038846855`*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"46b81529-c627-b541-a513-d8397fa73ca4"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.9577634253715873`*^9, 3.9577859864936056`*^9, 3.957787654752789*^9, 
   3.957789623897874*^9, 3.958068112717556*^9, {3.958068150556286*^9, 
   3.958068196513361*^9}, 3.958215995664446*^9, 3.9595056162467823`*^9, 
   3.960641657483841*^9, 3.9639548039041767`*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"7b59aa03-41dc-3b42-be55-f040b4769e07"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"(", 
          SubscriptBox["n", "\[Del]"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfLCDer[-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`xi[$CellContext`b]],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], 
        SubscriptBox["\[Del]", "b"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`LCDer[-$CellContext`b][
        $CellContext`xi[$CellContext`b]]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`xi[$CellContext`a]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "b"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`b][
       $CellContext`xi[$CellContext`b]],
      Editable->False]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9577634253715873`*^9, 3.9577859864936056`*^9, 3.957787654752789*^9, 
   3.957789623897874*^9, 3.958068112717556*^9, {3.958068150556286*^9, 
   3.958068196513361*^9}, 3.958215995664446*^9, 3.9595056162467823`*^9, 
   3.960641657483841*^9, 3.9639548039996643`*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"c7b033fb-927b-a845-89bd-29e0510631c0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.9577634253715873`*^9, 3.9577859864936056`*^9, 3.957787654752789*^9, 
   3.957789623897874*^9, 3.958068112717556*^9, {3.958068150556286*^9, 
   3.958068196513361*^9}, 3.958215995664446*^9, 3.9595056162467823`*^9, 
   3.960641657483841*^9, 3.9639548040216637`*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"0f6ffb41-998d-f947-901c-3f612f2f8a37"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {" "},
            {"b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[-$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"(", 
          SubscriptBox["n", "\[Del]"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfLCDer[-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {" "},
             {"c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[-$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[Del]", "a"], GridBox[{
          {"\[Alpha]", 
           StyleBox[GridBox[{
              {" "},
              {"b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`LCDer[-$CellContext`a][
       $CellContext`alpha[-$CellContext`b]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {" "},
             {"b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[-$CellContext`b],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"b", "c"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`b, $CellContext`c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`xi[$CellContext`a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "a"], GridBox[{
             {"\[Alpha]", 
              StyleBox[GridBox[{
                 {" "},
                 {"c"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`LCDer[-$CellContext`a][
          $CellContext`alpha[-$CellContext`c]],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {" "},
                {"c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[-$CellContext`c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"b", "c"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`b, $CellContext`c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "a"], GridBox[{
             {"\[Xi]", 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`LCDer[-$CellContext`a][
          $CellContext`xi[$CellContext`a]],
         Editable->False]}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9577634253715873`*^9, 3.9577859864936056`*^9, 3.957787654752789*^9, 
   3.957789623897874*^9, 3.958068112717556*^9, {3.958068150556286*^9, 
   3.958068196513361*^9}, 3.958215995664446*^9, 3.9595056162467823`*^9, 
   3.960641657483841*^9, 3.963954804188442*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"cec36347-612c-7849-a0b5-8c9e97c16ee6"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.9577634253715873`*^9, 3.9577859864936056`*^9, 3.957787654752789*^9, 
   3.957789623897874*^9, 3.958068112717556*^9, {3.958068150556286*^9, 
   3.958068196513361*^9}, 3.958215995664446*^9, 3.9595056162467823`*^9, 
   3.960641657483841*^9, 3.963954804216076*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"6842b595-cfba-ab4f-857c-787762718a1e"]
}, Open  ]],

Cell[TextData[{
 "As before, it also works for non-metric ",
 Cell[BoxData[
 "CovD"], "InlineCode",ExpressionUUID->"6f96747e-f533-8a4d-ae25-4b315048a210"],
 ". In this case, we do not require an auxiliary metric."
}], "Text",
 CellChangeTimes->{{3.950558350523617*^9, 3.950558364871153*^9}, {
   3.9513073651212196`*^9, 3.9513073785852547`*^9}, 3.9566211565584803`*^9, 
   3.9570755388759456`*^9},ExpressionUUID->"248796a4-4e47-9d4d-9526-\
ba9ec7d16600"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"potential4", "=", 
   RowBox[{
    RowBox[{"FindPotentialDivergence", "[", "der", "]"}], "[", "divergence4", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"potential5", "=", 
   RowBox[{
    RowBox[{"FindPotentialDivergence", "[", "der", "]"}], "[", "divergence5", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"potential6", "=", 
    RowBox[{
     RowBox[{"FindPotentialDivergence", "[", "der", "]"}], "[", "divergence6",
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"potential4", ",", 
   RowBox[{"NormalOfCovDToCovD", "[", "potential4", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NormalOfCovDToCovD", "[", "potential4", "]"}], "-", 
   "divergence4"}], "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"potential5", ",", 
   RowBox[{"NormalOfCovDToCovD", "[", "potential5", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NormalOfCovDToCovD", "[", "potential5", "]"}], "-", 
   "divergence5"}], "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"potential6", ",", 
   RowBox[{"NormalOfCovDToCovD", "[", "potential6", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"ToCanonical", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"NormalOfCovDToCovD", "[", "potential6", "]"}], "-", 
     "divergence6"}], "//", 
    RowBox[{"SeparateMetric", "[", "]"}]}], ",", 
   RowBox[{"UseMetricOnVBundle", "->", "None"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.958068214590294*^9, 3.958068267879839*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"b4ae5b00-7e26-464b-a17d-90e4d26cd78c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"(", 
          SubscriptBox["n", "D"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfder[-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False]}], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["D", "a"], GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`der[-$CellContext`a][
     $CellContext`xi[$CellContext`a]],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.957763425488549*^9, 3.9577859866174955`*^9, 3.957787655343034*^9, 
   3.957789624275665*^9, {3.9580682578850536`*^9, 3.9580682681961193`*^9}, 
   3.958215998050537*^9, 3.959505621238041*^9, 3.960641657688917*^9, 
   3.9639548060025997`*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"e6ea2963-0017-7f43-b6dd-53060dd00a31"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.957763425488549*^9, 3.9577859866174955`*^9, 3.957787655343034*^9, 
   3.957789624275665*^9, {3.9580682578850536`*^9, 3.9580682681961193`*^9}, 
   3.958215998050537*^9, 3.959505621238041*^9, 3.960641657688917*^9, 
   3.963954806020548*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"8b6d3fa9-4059-494c-b001-4881e9c50db4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"(", 
          SubscriptBox["n", "D"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfder[-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["D", "b"], GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`der[-$CellContext`b][
       $CellContext`xi[$CellContext`b]],
      Editable->False], ")"}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`a],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["D", "a"], 
         SubscriptBox["D", "b"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`der[-$CellContext`a][
        $CellContext`der[-$CellContext`b][
         $CellContext`xi[$CellContext`b]]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["D", "a"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`der[-$CellContext`a][
        $CellContext`xi[$CellContext`a]],
       Editable->False], ")"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["D", "b"], GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`der[-$CellContext`b][
        $CellContext`xi[$CellContext`b]],
       Editable->False], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.957763425488549*^9, 3.9577859866174955`*^9, 3.957787655343034*^9, 
   3.957789624275665*^9, {3.9580682578850536`*^9, 3.9580682681961193`*^9}, 
   3.958215998050537*^9, 3.959505621238041*^9, 3.960641657688917*^9, 
   3.9639548061771965`*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"939fe9e1-91bf-bc40-8f98-edb392d0040f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.957763425488549*^9, 3.9577859866174955`*^9, 3.957787655343034*^9, 
   3.957789624275665*^9, {3.9580682578850536`*^9, 3.9580682681961193`*^9}, 
   3.958215998050537*^9, 3.959505621238041*^9, 3.960641657688917*^9, 
   3.963954806194208*^9},
 CellLabel->
  "Out[117]=",ExpressionUUID->"2f62990d-e5ed-da46-aec6-617e0ed2b144"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {" "},
            {"b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[-$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"(", 
          SubscriptBox["n", "D"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfder[-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {" "},
             {"c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[-$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`b, $CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`xi[$CellContext`a],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["D", "a"], GridBox[{
           {"\[Alpha]", 
            StyleBox[GridBox[{
               {" "},
               {"b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`der[-$CellContext`a][
        $CellContext`alpha[-$CellContext`b]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {" "},
             {"b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`alpha[-$CellContext`b],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"b", "c"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`b, $CellContext`c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`xi[$CellContext`a],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["D", "a"], GridBox[{
              {"\[Alpha]", 
               StyleBox[GridBox[{
                  {" "},
                  {"c"}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`der[-$CellContext`a][
           $CellContext`alpha[-$CellContext`c]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Alpha]", 
             StyleBox[GridBox[{
                {" "},
                {"c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`alpha[-$CellContext`c],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"g", 
                 StyleBox[GridBox[{
                    {"b", "d"},
                    {" ", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`g[$CellContext`b, $CellContext`d],
             Editable->False]}], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"g", 
                StyleBox[GridBox[{
                   {"c", "e"},
                   {" ", " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`g[$CellContext`c, $CellContext`e],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {"a"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`xi[$CellContext`a],
            Editable->False], " ", 
           RowBox[{"(", 
            InterpretationBox[
             StyleBox[
              RowBox[{
               SubscriptBox["D", "a"], GridBox[{
                 {"g", 
                  StyleBox[GridBox[{
                    {" ", " "},
                    {"d", "e"}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`der[-$CellContext`a][
              $CellContext`g[-$CellContext`d, -$CellContext`e]],
             Editable->False], ")"}]}], "+", 
          RowBox[{
           InterpretationBox[
            StyleBox[GridBox[{
               {"g", 
                StyleBox[GridBox[{
                   {"b", "c"},
                   {" ", " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`g[$CellContext`b, $CellContext`c],
            Editable->False], " ", 
           RowBox[{"(", 
            InterpretationBox[
             StyleBox[
              RowBox[{
               SubscriptBox["D", "a"], GridBox[{
                 {"\[Xi]", 
                  StyleBox[GridBox[{
                    {"a"},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`der[-$CellContext`a][
              $CellContext`xi[$CellContext`a]],
             Editable->False], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.957763425488549*^9, 3.9577859866174955`*^9, 3.957787655343034*^9, 
   3.957789624275665*^9, {3.9580682578850536`*^9, 3.9580682681961193`*^9}, 
   3.958215998050537*^9, 3.959505621238041*^9, 3.960641657688917*^9, 
   3.9639548063500824`*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"8772f2b2-921a-6d44-8390-7e120963fb1e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.957763425488549*^9, 3.9577859866174955`*^9, 3.957787655343034*^9, 
   3.957789624275665*^9, {3.9580682578850536`*^9, 3.9580682681961193`*^9}, 
   3.958215998050537*^9, 3.959505621238041*^9, 3.960641657688917*^9, 
   3.96395480637208*^9},
 CellLabel->
  "Out[119]=",ExpressionUUID->"50f6249c-401a-2845-b846-14615987679e"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["FindPotentialDivergence",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "49dccc93-6d78-ea4c-8699-4b2eac91211c"],
 " works also with more general tensor like ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Del]", "a"], 
    SuperscriptBox["T", "cd"]}], TraditionalForm]],ExpressionUUID->
  "33d975cc-d89b-e349-82b3-993bb4105e47"],
 ". In these cases, ",
 Cell[BoxData[
 "FiducialForm"], "InlineCode",ExpressionUUID->
  "cd6f1e23-a20a-8646-ae4f-567d0ec81065"],
 " is essential to know the index of the covariant derivative since the \
potential might have several Free Indices."
}], "Text",
 CellChangeTimes->{{3.9505584000767746`*^9, 3.9505584106040764`*^9}, {
   3.9505585014237175`*^9, 3.950558542702385*^9}, {3.950558584882288*^9, 
   3.9505586235333385`*^9}, 3.952346510624714*^9, 
   3.9546656934500256`*^9},ExpressionUUID->"60ffe5b9-c138-dd44-a56a-\
0de9802c72d9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"divergence7", "=", 
   RowBox[{
    RowBox[{"LCDer", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{
     RowBox[{"xi", "[", "b", "]"}], 
     RowBox[{"xi", "[", "c", "]"}], 
     RowBox[{"xi", "[", 
      RowBox[{"-", "c"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LCDer", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"Keep", "[", 
     RowBox[{
      RowBox[{"xi", "[", "b", "]"}], 
      RowBox[{"xi", "[", "c", "]"}], 
      RowBox[{"xi", "[", 
       RowBox[{"-", "c"}], "]"}]}], "]"}], "]"}], "==", "divergence7"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"potential7", "=", 
   RowBox[{
    RowBox[{"FindPotentialDivergence", "[", "LCDer", "]"}], "[", 
    "divergence7", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"potential7", ",", 
   RowBox[{"NormalOfCovDToCovD", "[", "potential7", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"NormalOfCovDToCovD", "[", "potential7", "]"}], "-", 
     "divergence7"}], "//", "ContractMetric"}], "//", "Simplification"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"divergence8", "=", 
   RowBox[{
    RowBox[{"LCDer", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{
     RowBox[{"alpha", "[", 
      RowBox[{"-", "b"}], "]"}], 
     RowBox[{"xi", "[", "a", "]"}], 
     RowBox[{"xi", "[", "d", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LCDer", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"Keep", "[", 
     RowBox[{
      RowBox[{"alpha", "[", 
       RowBox[{"-", "b"}], "]"}], 
      RowBox[{"xi", "[", "a", "]"}], 
      RowBox[{"xi", "[", "d", "]"}]}], "]"}], "]"}], "==", "divergence8"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"potential8", "=", 
   RowBox[{
    RowBox[{"FindPotentialDivergence", "[", "LCDer", "]"}], "[", 
    "divergence8", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"potential8", ",", 
    RowBox[{"NormalOfCovDToCovD", "[", "potential8", "]"}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NormalOfCovDToCovD", "[", "potential8", "]"}], "-", 
  "divergence8"}]}], "Input",
 CellChangeTimes->{{3.958068296024187*^9, 3.9580683468555164`*^9}},
 CellLabel->
  "In[120]:=",ExpressionUUID->"efc9d247-fb98-1348-ad99-2f33792111a9"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "a"], "(", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`xi[$CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {" "},
              {"c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`xi[-$CellContext`c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`xi[$CellContext`c],
       Editable->False]}], ")"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LCDer[-$CellContext`a][
    xAct`xTensor`Keep[$CellContext`xi[$CellContext`b] \
$CellContext`xi[-$CellContext`c] $CellContext`xi[$CellContext`c]]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {" "},
            {"c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[-$CellContext`c],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"c"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`c],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Xi]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`a][
      $CellContext`xi[$CellContext`b]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`b],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "a"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {" "},
                {"c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`xi[-$CellContext`c]],
        Editable->False]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {" "},
               {"c"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[-$CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "a"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`xi[$CellContext`c]],
        Editable->False]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.957763425721241*^9, 3.95778598678146*^9, 
  3.957787656352374*^9, 3.9577896248134794`*^9, 3.958068348592888*^9, 
  3.9582160011216393`*^9, 3.9595056317240047`*^9, 3.96064165789538*^9, 
  3.9639548090765305`*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"63cf0aef-606d-9043-8f1a-b4353217385c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"(", 
          SubscriptBox["n", "\[Del]"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfLCDer[-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {" "},
            {"c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[-$CellContext`c],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"c"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`c],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`d, -$CellContext`c],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"c"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`c],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"d"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "a"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`xi[$CellContext`b]],
        Editable->False]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`b],
        Editable->False], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Xi]", 
               StyleBox[GridBox[{
                  {"d"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`xi[$CellContext`d],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "a"], GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {"c"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`a][
            $CellContext`xi[$CellContext`c]],
           Editable->False]}], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Xi]", 
               StyleBox[GridBox[{
                  {"c"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`xi[$CellContext`c],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "a"], GridBox[{
               {"\[Xi]", 
                StyleBox[GridBox[{
                   {"d"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`a][
            $CellContext`xi[$CellContext`d]],
           Editable->False]}]}], ")"}]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.957763425721241*^9, 3.95778598678146*^9, 
  3.957787656352374*^9, 3.9577896248134794`*^9, 3.958068348592888*^9, 
  3.9582160011216393`*^9, 3.9595056317240047`*^9, 3.96064165789538*^9, 
  3.9639548092128506`*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"fe9a0c9c-a3ab-9446-8ef3-939529ee6f76"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.957763425721241*^9, 3.95778598678146*^9, 
  3.957787656352374*^9, 3.9577896248134794`*^9, 3.958068348592888*^9, 
  3.9582160011216393`*^9, 3.9595056317240047`*^9, 3.96064165789538*^9, 
  3.9639548092329693`*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"acedce49-b553-3f41-b300-530c62ab89c0"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "a"], "(", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Alpha]", 
           StyleBox[GridBox[{
              {" "},
              {"b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`alpha[-$CellContext`b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`xi[$CellContext`a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Xi]", 
           StyleBox[GridBox[{
              {"d"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`xi[$CellContext`d],
       Editable->False]}], ")"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`LCDer[-$CellContext`a][
    xAct`xTensor`Keep[$CellContext`alpha[-$CellContext`b] \
$CellContext`xi[$CellContext`a] $CellContext`xi[$CellContext`d]]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"d"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`d],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "a"], GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {" "},
             {"b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`a][
      $CellContext`alpha[-$CellContext`b]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {" "},
            {"b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[-$CellContext`b],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"d"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "a"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`xi[$CellContext`a]],
        Editable->False]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`a],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "a"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"d"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`a][
         $CellContext`xi[$CellContext`d]],
        Editable->False]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.957763425721241*^9, 3.95778598678146*^9, 
  3.957787656352374*^9, 3.9577896248134794`*^9, 3.958068348592888*^9, 
  3.9582160011216393`*^9, 3.9595056317240047`*^9, 3.96064165789538*^9, 
  3.96395480933729*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"8656baf8-9e4d-4947-a633-e90ffe0a33f1"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.957763425721241*^9, 3.95778598678146*^9, 
  3.957787656352374*^9, 3.9577896248134794`*^9, 3.958068348592888*^9, 
  3.9582160011216393`*^9, 3.9595056317240047`*^9, 3.96064165789538*^9, 
  3.9639548093582935`*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"74df581f-a947-5d48-9773-3e92833d96b7"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Important",
  FontWeight->"Bold"],
 ": ",
 Cell[BoxData[
  StyleBox["FindPotentialDivergence",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "429e97a7-f6b2-f648-8dca-332b51aa98fa"],
 " might not work even when the expression is a total divergence. Sometimes \
the expression needs to be worked out before trying",
 StyleBox[" ",
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox["FindPotentialDivergence",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "72446f6f-4f75-8b46-b977-73c73de7182b"],
 " either before or in the middle steps using ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"'", 
    RowBox[{"optionalfunctions", "'"}]}],
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "1682ee31-fa73-e347-b386-d42b333b739a"],
 " in the same way as we did for ",
 Cell[BoxData[
  StyleBox["DivergenceQ",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "25437dcb-9723-2f45-8918-1d49df31c74a"],
 "."
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.9580680018555717`*^9, 3.958068006152872*^9}, {
   3.9580683676709976`*^9, 3.9580684079196568`*^9}, {3.958069945944292*^9, 
   3.9580699568789177`*^9}, {3.959505671610653*^9, 3.959505733257168*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"f86dbff7-e344-bf48-9b83-0f5380d62662"],

Cell[TextData[{
 "As for ",
 Cell[BoxData[
  StyleBox["DivergenceQ",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "89a6d501-2a0c-f248-9cef-556756ef9522"],
 ", we can limit the amount of iterations:"
}], "Text",
 CellChangeTimes->{{3.950558545423132*^9, 3.9505585745672054`*^9}, 
   3.9505586100666904`*^9, {3.9506268793329487`*^9, 3.950626885885557*^9}, {
   3.9595057478182297`*^9, 
   3.9595057502658615`*^9}},ExpressionUUID->"a1db3aa9-6577-aa46-9881-\
719fe69d66ca"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"incompletepotential", "=", 
    RowBox[{
     RowBox[{"FindPotentialDivergence", "[", 
      RowBox[{"LCDer", ",", "n"}], "]"}], "[", "NonDivergence", "]"}]}], 
   ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Incomplete potential: \>\"", ",", "incompletepotential"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Difference: \>\"", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"NormalOfCovDToCovD", "[", "incompletepotential", "]"}], "-", 
      "NonDivergence"}], "//", "Simplification"}], ",", "\"\<\\n\>\""}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"incompletepotential", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"FindPotentialDivergence", "[", 
       RowBox[{"LCDer", ",", "n"}], "]"}], "[", "NonDivergence", "]"}], "//", 
     "ScreenDollarIndices"}]}], ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Incomplete potential: \>\"", ",", "incompletepotential"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Difference: \>\"", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"NormalOfCovDToCovD", "[", "incompletepotential", "]"}], "-", 
       "NonDivergence"}], "//", "Simplification"}], "//", 
     "ScreenDollarIndices"}], ",", "\"\<\\n\>\""}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"incompletepotential", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"FindPotentialDivergence", "[", 
       RowBox[{"LCDer", ",", "n"}], "]"}], "[", "NonDivergence", "]"}], "//", 
     "ScreenDollarIndices"}]}], ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Incomplete potential: \>\"", ",", "incompletepotential"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Difference: \>\"", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"NormalOfCovDToCovD", "[", "incompletepotential", "]"}], "-", 
       "NonDivergence"}], "//", "Simplification"}], "//", 
     "ScreenDollarIndices"}], ",", "\"\<\\n\>\""}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"incompletepotential", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"FindPotentialDivergence", "[", 
       RowBox[{"LCDer", ",", "n"}], "]"}], "[", "NonDivergence", "]"}], "//", 
     "ScreenDollarIndices"}]}], ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Incomplete potential: \>\"", ",", "incompletepotential"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Difference: \>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"NormalOfCovDToCovD", "[", "incompletepotential", "]"}], "-", 
      "NonDivergence"}], "//", "Simplification"}], "//", 
    "ScreenDollarIndices"}], ",", "\"\<\\n\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.957829411926737*^9, 3.9578294145044727`*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"a505f634-4880-bc44-abb3-5afc9c952b28"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Incomplete potential: \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["Incomplete potential: ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577634259071813`*^9, 3.9577859869060907`*^9, 
  3.9577876569526625`*^9, 3.9577896252154875`*^9, 3.958068416450094*^9, 
  3.958216005528475*^9, 3.959505640763485*^9, 3.9595057533725624`*^9, 
  3.9606416581011753`*^9, 3.963954811943159*^9},
 CellLabel->
  "During evaluation of \
In[130]:=",ExpressionUUID->"ef1d8e38-6063-9c45-8f9f-eb3891dcac8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Difference: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`alpha[-$CellContext`a]],
     Editable->False]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[
  "Difference: ", (-2) $CellContext`alpha[$CellContext`a] \
$CellContext`xi[$CellContext`b] $CellContext`LCDer[-$CellContext`b][
     $CellContext`alpha[-$CellContext`a]], "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577634259071813`*^9, 3.9577859869060907`*^9, 
  3.9577876569526625`*^9, 3.9577896252154875`*^9, 3.958068416450094*^9, 
  3.958216005528475*^9, 3.959505640763485*^9, 3.9595057533725624`*^9, 
  3.9606416581011753`*^9, 3.9639548120031834`*^9},
 CellLabel->
  "During evaluation of \
In[130]:=",ExpressionUUID->"1c202390-d222-fa44-814d-4a61ae4a6491"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Incomplete potential: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {" "},
            {"b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[-$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"(", 
          SubscriptBox["n", "\[Del]"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfLCDer[-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False]}]}],
  SequenceForm[
  "Incomplete potential: ", 
   Rational[1, 
     2] $CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b] \
$CellContext`NormalOfLCDer[-$CellContext`a] $CellContext`xi[$CellContext`a]],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577634259071813`*^9, 3.9577859869060907`*^9, 
  3.9577876569526625`*^9, 3.9577896252154875`*^9, 3.958068416450094*^9, 
  3.958216005528475*^9, 3.959505640763485*^9, 3.9595057533725624`*^9, 
  3.9606416581011753`*^9, 3.963954812071888*^9},
 CellLabel->
  "During evaluation of \
In[130]:=",ExpressionUUID->"0e7d7261-2395-b843-a619-92fa877f767f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Difference: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`a],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`b],
        Editable->False], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "b"], GridBox[{
               {"\[Alpha]", 
                StyleBox[GridBox[{
                   {" "},
                   {"a"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`b][
            $CellContext`alpha[-$CellContext`a]],
           Editable->False]}], "+", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"g", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {"a", "c"}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`g[-$CellContext`a, -$CellContext`c],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "b"], GridBox[{
               {"\[Alpha]", 
                StyleBox[GridBox[{
                   {"c"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`b][
            $CellContext`alpha[$CellContext`c]],
           Editable->False]}]}], ")"}]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Alpha]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`alpha[$CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"g", 
            StyleBox[GridBox[{
               {" ", " "},
               {"a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`g[-$CellContext`a, -$CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "c"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`c][
         $CellContext`xi[$CellContext`c]],
        Editable->False]}]}], ")"}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[
  "Difference: ", 
   Rational[1, 
     2] $CellContext`alpha[$CellContext`a] ($CellContext`xi[$CellContext`b] \
((-4) $CellContext`LCDer[-$CellContext`b][
         $CellContext`alpha[-$CellContext`a]] + 
      2 $CellContext`g[-$CellContext`a, -$CellContext`c] \
$CellContext`LCDer[-$CellContext`b][
         $CellContext`alpha[$CellContext`c]]) + \
$CellContext`alpha[$CellContext`b] $CellContext`g[-$CellContext`a, \
-$CellContext`b] $CellContext`LCDer[-$CellContext`c][
       $CellContext`xi[$CellContext`c]]), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577634259071813`*^9, 3.9577859869060907`*^9, 
  3.9577876569526625`*^9, 3.9577896252154875`*^9, 3.958068416450094*^9, 
  3.958216005528475*^9, 3.959505640763485*^9, 3.9595057533725624`*^9, 
  3.9606416581011753`*^9, 3.9639548121398277`*^9},
 CellLabel->
  "During evaluation of \
In[130]:=",ExpressionUUID->"3c037bdc-fcbe-ba46-b989-f654b8e1bc4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Incomplete potential: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {" "},
            {"b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[-$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"(", 
          SubscriptBox["n", "\[Del]"], ")"}], 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`NormalOfLCDer[-$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`a],
     Editable->False]}]}],
  SequenceForm[
  "Incomplete potential: ", $CellContext`alpha[-$CellContext`b] \
$CellContext`alpha[$CellContext`b] \
$CellContext`NormalOfLCDer[-$CellContext`a] $CellContext`xi[$CellContext`a]],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577634259071813`*^9, 3.9577859869060907`*^9, 
  3.9577876569526625`*^9, 3.9577896252154875`*^9, 3.958068416450094*^9, 
  3.958216005528475*^9, 3.959505640763485*^9, 3.9595057533725624`*^9, 
  3.9606416581011753`*^9, 3.963954812216177*^9},
 CellLabel->
  "During evaluation of \
In[130]:=",ExpressionUUID->"6ecadb9d-87d6-624e-bd65-5a0a47b8e471"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Difference: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`a],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Xi]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`xi[$CellContext`b],
        Editable->False], " ", 
       RowBox[{"(", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "b"], GridBox[{
              {"\[Alpha]", 
               StyleBox[GridBox[{
                  {" "},
                  {"a"}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`LCDer[-$CellContext`b][
           $CellContext`alpha[-$CellContext`a]],
          Editable->False], "-", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"g", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {"a", "c"}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`g[-$CellContext`a, -$CellContext`c],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[Del]", "b"], GridBox[{
               {"\[Alpha]", 
                StyleBox[GridBox[{
                   {"c"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`LCDer[-$CellContext`b][
            $CellContext`alpha[$CellContext`c]],
           Editable->False]}]}], ")"}]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Alpha]", 
            StyleBox[GridBox[{
               {"b"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`alpha[$CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"g", 
            StyleBox[GridBox[{
               {" ", " "},
               {"a", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`g[-$CellContext`a, -$CellContext`b],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[Del]", "c"], GridBox[{
            {"\[Xi]", 
             StyleBox[GridBox[{
                {"c"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`LCDer[-$CellContext`c][
         $CellContext`xi[$CellContext`c]],
        Editable->False]}]}], ")"}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[
  "Difference: ", $CellContext`alpha[$CellContext`a] ((-2) \
$CellContext`xi[$CellContext`b] ($CellContext`LCDer[-$CellContext`b][
        $CellContext`alpha[-$CellContext`a]] - \
$CellContext`g[-$CellContext`a, -$CellContext`c] \
$CellContext`LCDer[-$CellContext`b][
        $CellContext`alpha[$CellContext`c]]) + \
$CellContext`alpha[$CellContext`b] $CellContext`g[-$CellContext`a, \
-$CellContext`b] $CellContext`LCDer[-$CellContext`c][
       $CellContext`xi[$CellContext`c]]), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577634259071813`*^9, 3.9577859869060907`*^9, 
  3.9577876569526625`*^9, 3.9577896252154875`*^9, 3.958068416450094*^9, 
  3.958216005528475*^9, 3.959505640763485*^9, 3.9595057533725624`*^9, 
  3.9606416581011753`*^9, 3.9639548123006725`*^9},
 CellLabel->
  "During evaluation of \
In[130]:=",ExpressionUUID->"5a9b473e-ffa8-c24f-bdce-3531e9fe124a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Incomplete potential: \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["Incomplete potential: ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577634259071813`*^9, 3.9577859869060907`*^9, 
  3.9577876569526625`*^9, 3.9577896252154875`*^9, 3.958068416450094*^9, 
  3.958216005528475*^9, 3.959505640763485*^9, 3.9595057533725624`*^9, 
  3.9606416581011753`*^9, 3.9639548123598137`*^9},
 CellLabel->
  "During evaluation of \
In[130]:=",ExpressionUUID->"d4b75b6d-7b50-6243-983b-3427af8ab8dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Difference: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Alpha]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`alpha[$CellContext`a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`xi[$CellContext`b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "b"], GridBox[{
         {"\[Alpha]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`LCDer[-$CellContext`b][
      $CellContext`alpha[-$CellContext`a]],
     Editable->False]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[
  "Difference: ", (-2) $CellContext`alpha[$CellContext`a] \
$CellContext`xi[$CellContext`b] $CellContext`LCDer[-$CellContext`b][
     $CellContext`alpha[-$CellContext`a]], "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577634259071813`*^9, 3.9577859869060907`*^9, 
  3.9577876569526625`*^9, 3.9577896252154875`*^9, 3.958068416450094*^9, 
  3.958216005528475*^9, 3.959505640763485*^9, 3.9595057533725624`*^9, 
  3.9606416581011753`*^9, 3.9639548124177437`*^9},
 CellLabel->
  "During evaluation of \
In[130]:=",ExpressionUUID->"e9c3ba52-2dca-a54a-abc2-2045e544eb6c"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". Reset session"
}], "Section",
 CellChangeTimes->{{3.9324707187060614`*^9, 3.932470735348284*^9}, 
   3.948667428708285*^9, {3.948667658485*^9, 3.948667659305849*^9}, {
   3.948668095527338*^9, 3.948668098082294*^9}, {3.948823255409116*^9, 
   3.9488233458056254`*^9}, {3.9488233816031427`*^9, 3.94882338821742*^9}, 
   3.948823425127707*^9, {3.948823459423756*^9, 3.948823495343562*^9}, {
   3.948823721434247*^9, 3.9488237235375814`*^9}, {3.950891657859501*^9, 
   3.9508916604562645`*^9}, {3.95098153719162*^9, 3.950981546575815*^9}, {
   3.953841313209341*^9, 3.9538413134876842`*^9}, {3.954513337761366*^9, 
   3.9545133465768623`*^9}},ExpressionUUID->"37ea130e-bb94-3c4c-a9fe-\
e4328789cafc"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"ResetSession", "[", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"5e3275f9-a58d-c54d-9cda-048567c930ea"],
 StyleBox["\n",
  FontSize->3],
 "It resets the current ",
 StyleBox["xAct",
  FontWeight->"Bold"],
 " session by undefining all constant symbols, parameters, scalar functions, \
metrics, CovDs, tensors, mappings, generalized variational vector fields, \
manifolds, and vector bundles.\n",
 StyleBox["\n",
  FontSize->3],
 "- Options:\n  * ",
 Cell[BoxData[
  RowBox[{"UndefInfo", "\[RightArrow]", "False"}]], "InlineCode",
  ExpressionUUID->"48c0bd14-181a-1642-920e-86715861754e"],
 ": enables Undefined messages. \n  * ",
 Cell[BoxData[
  RowBox[{"Signs", "\[RightArrow]", "value"}]], "InlineCode",ExpressionUUID->
  "fe10a66a-c23b-e14c-84ae-ed5cbb332570"],
 ": sets all internal signs to ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"value", "'"}]}]], "InlineCode",ExpressionUUID->
  "bfeaa62c-ef10-d945-a6b9-f684d3af84a1"],
 " using ",
 Cell[BoxData[
  RowBox[{"SetSigns", "[", "value", "]"}]], "InlineCode",ExpressionUUID->
  "a3c3e679-850a-0347-9ede-073a48fac4c6"],
 " (it can be set to 1 (default), -1, or unset them with ",
 Cell[BoxData[
  RowBox[{"value", "=", "0"}]], "InlineCode",ExpressionUUID->
  "37319a28-5b84-b249-b3b0-b6086c91bc62"],
 ")."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.9505582615538483`*^9, 3.9505582934064617`*^9}, {
   3.9523464706475787`*^9, 3.9523464880812984`*^9}, {3.95448186009798*^9, 
   3.954481876497109*^9}, {3.954665555299899*^9, 3.9546655704097424`*^9}, {
   3.955941870405089*^9, 3.9559418892481613`*^9}, {3.9567455829724684`*^9, 
   3.956745589124617*^9}, {3.957883558453973*^9, 3.9578835597710357`*^9}, {
   3.957885187833141*^9, 3.9578851892865877`*^9}, {3.9580680795370846`*^9, 
   3.9580681009417496`*^9}, {3.9580692994359894`*^9, 3.958069319274719*^9}, 
   3.95807058162702*^9, 3.958080924695513*^9, {3.9583833542053285`*^9, 
   3.958383425004619*^9}, {3.958389358901821*^9, 3.9583893640077267`*^9}, {
   3.9583893999264317`*^9, 3.958389483577738*^9}, {3.958389581429678*^9, 
   3.9583895927980328`*^9}, {3.959505774058777*^9, 3.959505788264889*^9}, 
   3.9595769801691*^9, 3.963936223016844*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"500a4f57-0910-cb40-9e9c-f308d5f37e60"],

Cell[TextData[{
 "We reset everything defined within the session so far with the command ",
 Cell[BoxData[
 "ResetSession"], "InlineCode",ExpressionUUID->
  "cbdc32ee-5a05-3c49-9aff-db86c289f8d4"],
 ". See Section ",
 StyleBox[ButtonBox["A.",
  BaseStyle->"Hyperlink",
  ButtonData->"Section Ap Reset Session"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Section Ap Reset Session"],
  FontColor->RGBColor[0., 0., 1.]],
 " of the Appendix for further details."
}], "Text",
 CellChangeTimes->{{3.957615809886877*^9, 3.95761590423522*^9}, {
   3.957645004819525*^9, 3.95764501741308*^9}, {3.9576686705793133`*^9, 
   3.957668760134457*^9}, {3.9579559978254375`*^9, 3.957955998633423*^9}, {
   3.9579560773386917`*^9, 3.9579560851820383`*^9}, 3.9579561829585176`*^9, {
   3.9580684231716595`*^9, 3.958068455454195*^9}, 3.958137446642317*^9, {
   3.958389493461748*^9, 
   3.9583895046759815`*^9}},ExpressionUUID->"fc2fc033-e633-344e-bc7c-\
d9ae563d27dd"],

Cell[BoxData[
 RowBox[{"ResetSession", "[", "]"}]], "Input",
 CellChangeTimes->{{3.954518625436844*^9, 3.9545186345258293`*^9}, {
  3.9545188141398964`*^9, 3.954518828970495*^9}, {3.954518928311838*^9, 
  3.9545189284845905`*^9}, {3.9545198389462204`*^9, 3.954519865557417*^9}, {
  3.9639360002310257`*^9, 3.9639360135125504`*^9}, {3.9639360863183193`*^9, 
  3.963936087303524*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"a113598c-746f-9b4d-9fc6-8753e798fe01"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ". Basic definitions of ",
 StyleBox["xCPS",
  FontWeight->"Bold"]
}], "Chapter",
 CellChangeTimes->{{3.948474197281039*^9, 3.9484742191832757`*^9}, 
   3.948667339091866*^9, 3.951846391086569*^9, {3.951859448704548*^9, 
   3.951859475680393*^9}, {3.952090885777321*^9, 3.952090891625345*^9}, {
   3.9523466828709974`*^9, 3.95234672607745*^9}, {3.954932053198814*^9, 
   3.9549320575082026`*^9}, 3.955950168748005*^9, 3.9559504823605423`*^9, 
   3.9570756866261578`*^9, {3.957077311223068*^9, 3.9570773113573523`*^9}, 
   3.9574444601100044`*^9, 3.957608244113122*^9, {3.9578294344676266`*^9, 
   3.957829436243496*^9}, 3.958640164044222*^9, 3.9586402674123764`*^9},
 CellTags->
  "chapter basic \
definitions",ExpressionUUID->"14ea1c2a-b29b-c249-8266-38da87739877"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ". DefTensor and WWedge"
}], "Section",
 CellChangeTimes->{{3.931836256197623*^9, 3.931836260320031*^9}, {
   3.932387704652485*^9, 3.932387709519918*^9}, {3.9324705520206637`*^9, 
   3.9324705540925975`*^9}, 3.948667313368092*^9, {3.9486673534793873`*^9, 
   3.9486673857120647`*^9}, {3.9488291406004486`*^9, 3.94882914092434*^9}, {
   3.9488293650752673`*^9, 3.948829366346679*^9}, {3.9580424749230385`*^9, 
   3.9580424760107307`*^9}},
 CellTags->
  "Section DefTensor",ExpressionUUID->"f76be079-694b-1649-a6d1-35e992b6c18e"],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Initial definitions"
}], "Subsection",
 CellChangeTimes->{{3.932470580395163*^9, 3.932470584396078*^9}, 
   3.932572376406393*^9, 
   3.9486673234264975`*^9},ExpressionUUID->"7dc7b4f8-2d2b-bb48-99dd-\
258b547627d7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$UndefInfoQ", "=", "True"}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{"DefConstantSymbol", "[", "dimen", "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "dimen", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "h", ",", "i",
      ",", "j", ",", "k", ",", "l"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9595066229963303`*^9, 3.9595066239526424`*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"003192c6-e69d-2043-9fb8-21cc6a093cf8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "dimen", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`dimen, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.957763491147181*^9, 3.9577636831084414`*^9, 3.9577640340562077`*^9, 
   3.9577860008714466`*^9, 3.957787659890602*^9, 3.957789628033115*^9, 
   3.957829484004837*^9, 3.9580689494813385`*^9, 3.958080776248516*^9, 
   3.958085745901272*^9, 3.9580861193626823`*^9, 3.9581305314796505`*^9, 
   3.958133166825325*^9, 3.9582160742654076`*^9, 3.9582182933703003`*^9, 
   3.958219117905905*^9, 3.958223025140068*^9, 3.958224001929758*^9, 
   3.958225756175268*^9, 3.9582274392705173`*^9, 3.9582282843807316`*^9, 
   3.9588718652196407`*^9, 3.9588758560249805`*^9, 3.9595058141961384`*^9, 
   3.9595066292923336`*^9, 3.960641659499443*^9, 3.9606429595763187`*^9, {
   3.9639359484929504`*^9, 3.9639359614527855`*^9}, 3.9639360393410664`*^9, 
   3.963936197000761*^9, 3.963940512082548*^9, 3.9639408622946434`*^9, 
   3.9639411845060043`*^9, 3.963941405875551*^9, 3.9639420476013527`*^9, 
   3.963942168617386*^9, 3.963954825121229*^9},
 CellLabel->
  "During evaluation of \
In[147]:=",ExpressionUUID->"f391050f-9693-0742-ba4f-d06afb4ead57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.957763491147181*^9, 3.9577636831084414`*^9, 3.9577640340562077`*^9, 
   3.9577860008714466`*^9, 3.957787659890602*^9, 3.957789628033115*^9, 
   3.957829484004837*^9, 3.9580689494813385`*^9, 3.958080776248516*^9, 
   3.958085745901272*^9, 3.9580861193626823`*^9, 3.9581305314796505`*^9, 
   3.958133166825325*^9, 3.9582160742654076`*^9, 3.9582182933703003`*^9, 
   3.958219117905905*^9, 3.958223025140068*^9, 3.958224001929758*^9, 
   3.958225756175268*^9, 3.9582274392705173`*^9, 3.9582282843807316`*^9, 
   3.9588718652196407`*^9, 3.9588758560249805`*^9, 3.9595058141961384`*^9, 
   3.9595066292923336`*^9, 3.960641659499443*^9, 3.9606429595763187`*^9, {
   3.9639359484929504`*^9, 3.9639359614527855`*^9}, 3.9639360393410664`*^9, 
   3.963936197000761*^9, 3.963940512082548*^9, 3.9639408622946434`*^9, 
   3.9639411845060043`*^9, 3.963941405875551*^9, 3.9639420476013527`*^9, 
   3.963942168617386*^9, 3.9639548251480293`*^9},
 CellLabel->
  "During evaluation of \
In[147]:=",ExpressionUUID->"7a11b5f0-f967-1f45-8e38-cd2dcc8e1d64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.957763491147181*^9, 3.9577636831084414`*^9, 3.9577640340562077`*^9, 
   3.9577860008714466`*^9, 3.957787659890602*^9, 3.957789628033115*^9, 
   3.957829484004837*^9, 3.9580689494813385`*^9, 3.958080776248516*^9, 
   3.958085745901272*^9, 3.9580861193626823`*^9, 3.9581305314796505`*^9, 
   3.958133166825325*^9, 3.9582160742654076`*^9, 3.9582182933703003`*^9, 
   3.958219117905905*^9, 3.958223025140068*^9, 3.958224001929758*^9, 
   3.958225756175268*^9, 3.9582274392705173`*^9, 3.9582282843807316`*^9, 
   3.9588718652196407`*^9, 3.9588758560249805`*^9, 3.9595058141961384`*^9, 
   3.9595066292923336`*^9, 3.960641659499443*^9, 3.9606429595763187`*^9, {
   3.9639359484929504`*^9, 3.9639359614527855`*^9}, 3.9639360393410664`*^9, 
   3.963936197000761*^9, 3.963940512082548*^9, 3.9639408622946434`*^9, 
   3.9639411845060043`*^9, 3.963941405875551*^9, 3.9639420476013527`*^9, 
   3.963942168617386*^9, 3.9639548251711063`*^9},
 CellLabel->
  "During evaluation of \
In[147]:=",ExpressionUUID->"e8a12bf6-41e1-2d4b-a9f6-42a59175f349"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"NormalOfPDOfM", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`NormalOfPDOfM[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.957763491147181*^9, 3.9577636831084414`*^9, 3.9577640340562077`*^9, 
   3.9577860008714466`*^9, 3.957787659890602*^9, 3.957789628033115*^9, 
   3.957829484004837*^9, 3.9580689494813385`*^9, 3.958080776248516*^9, 
   3.958085745901272*^9, 3.9580861193626823`*^9, 3.9581305314796505`*^9, 
   3.958133166825325*^9, 3.9582160742654076`*^9, 3.9582182933703003`*^9, 
   3.958219117905905*^9, 3.958223025140068*^9, 3.958224001929758*^9, 
   3.958225756175268*^9, 3.9582274392705173`*^9, 3.9582282843807316`*^9, 
   3.9588718652196407`*^9, 3.9588758560249805`*^9, 3.9595058141961384`*^9, 
   3.9595066292923336`*^9, 3.960641659499443*^9, 3.9606429595763187`*^9, {
   3.9639359484929504`*^9, 3.9639359614527855`*^9}, 3.9639360393410664`*^9, 
   3.963936197000761*^9, 3.963940512082548*^9, 3.9639408622946434`*^9, 
   3.9639411845060043`*^9, 3.963941405875551*^9, 3.9639420476013527`*^9, 
   3.963942168617386*^9, 3.963954825190775*^9},
 CellLabel->
  "During evaluation of \
In[147]:=",ExpressionUUID->"19afc8c5-04e6-e04f-a749-cc3fbaf1bf44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlNormalOfPDOfM", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`dlNormalOfPDOfM[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.957763491147181*^9, 3.9577636831084414`*^9, 3.9577640340562077`*^9, 
   3.9577860008714466`*^9, 3.957787659890602*^9, 3.957789628033115*^9, 
   3.957829484004837*^9, 3.9580689494813385`*^9, 3.958080776248516*^9, 
   3.958085745901272*^9, 3.9580861193626823`*^9, 3.9581305314796505`*^9, 
   3.958133166825325*^9, 3.9582160742654076`*^9, 3.9582182933703003`*^9, 
   3.958219117905905*^9, 3.958223025140068*^9, 3.958224001929758*^9, 
   3.958225756175268*^9, 3.9582274392705173`*^9, 3.9582282843807316`*^9, 
   3.9588718652196407`*^9, 3.9588758560249805`*^9, 3.9595058141961384`*^9, 
   3.9595066292923336`*^9, 3.960641659499443*^9, 3.9606429595763187`*^9, {
   3.9639359484929504`*^9, 3.9639359614527855`*^9}, 3.9639360393410664`*^9, 
   3.963936197000761*^9, 3.963940512082548*^9, 3.9639408622946434`*^9, 
   3.9639411845060043`*^9, 3.963941405875551*^9, 3.9639420476013527`*^9, 
   3.963942168617386*^9, 3.963954825207304*^9},
 CellLabel->
  "During evaluation of \
In[147]:=",ExpressionUUID->"7405b4d0-6004-6b4e-91fc-ec7135ef0c8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectorNormalOfPDOfM", "[", "a", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectorNormalOfPDOfM[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.957763491147181*^9, 3.9577636831084414`*^9, 3.9577640340562077`*^9, 
   3.9577860008714466`*^9, 3.957787659890602*^9, 3.957789628033115*^9, 
   3.957829484004837*^9, 3.9580689494813385`*^9, 3.958080776248516*^9, 
   3.958085745901272*^9, 3.9580861193626823`*^9, 3.9581305314796505`*^9, 
   3.958133166825325*^9, 3.9582160742654076`*^9, 3.9582182933703003`*^9, 
   3.958219117905905*^9, 3.958223025140068*^9, 3.958224001929758*^9, 
   3.958225756175268*^9, 3.9582274392705173`*^9, 3.9582282843807316`*^9, 
   3.9588718652196407`*^9, 3.9588758560249805`*^9, 3.9595058141961384`*^9, 
   3.9595066292923336`*^9, 3.960641659499443*^9, 3.9606429595763187`*^9, {
   3.9639359484929504`*^9, 3.9639359614527855`*^9}, 3.9639360393410664`*^9, 
   3.963936197000761*^9, 3.963940512082548*^9, 3.9639408622946434`*^9, 
   3.9639411845060043`*^9, 3.963941405875551*^9, 3.9639420476013527`*^9, 
   3.963942168617386*^9, 3.963954825224306*^9},
 CellLabel->
  "During evaluation of \
In[147]:=",ExpressionUUID->"8ee4738b-d245-4244-b487-2a326de03603"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   "TotalDerivativeOfPDOfM", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefInertHead, ": Defining ", 
   "inert head ", $CellContext`TotalDerivativeOfPDOfM, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.957763491147181*^9, 3.9577636831084414`*^9, 3.9577640340562077`*^9, 
   3.9577860008714466`*^9, 3.957787659890602*^9, 3.957789628033115*^9, 
   3.957829484004837*^9, 3.9580689494813385`*^9, 3.958080776248516*^9, 
   3.958085745901272*^9, 3.9580861193626823`*^9, 3.9581305314796505`*^9, 
   3.958133166825325*^9, 3.9582160742654076`*^9, 3.9582182933703003`*^9, 
   3.958219117905905*^9, 3.958223025140068*^9, 3.958224001929758*^9, 
   3.958225756175268*^9, 3.9582274392705173`*^9, 3.9582282843807316`*^9, 
   3.9588718652196407`*^9, 3.9588758560249805`*^9, 3.9595058141961384`*^9, 
   3.9595066292923336`*^9, 3.960641659499443*^9, 3.9606429595763187`*^9, {
   3.9639359484929504`*^9, 3.9639359614527855`*^9}, 3.9639360393410664`*^9, 
   3.963936197000761*^9, 3.963940512082548*^9, 3.9639408622946434`*^9, 
   3.9639411845060043`*^9, 3.963941405875551*^9, 3.9639420476013527`*^9, 
   3.963942168617386*^9, 3.9639548252413044`*^9},
 CellLabel->
  "During evaluation of \
In[147]:=",ExpressionUUID->"b6c74aa6-e3d3-fc4c-91f3-24413d19fc6d"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["DefManifold"], "InlineCode",
  FontWeight->"Bold",
  FontVariations->{"Underline"->False},ExpressionUUID->
  "ff2cee7d-ce43-c34b-8cce-2905f168633c"],
 " has been modified to include three additional covectors ",
 Cell[BoxData[
 "NormalOfPDOfM"], "InlineCode",ExpressionUUID->
  "348ed952-abe4-5443-98c2-ffb5c7084e01"],
 " together with its vertical exterior derivative, ",
 Cell[BoxData[
 "dlNormalOfPDOfM"], "InlineCode",ExpressionUUID->
  "693d4615-5d75-f048-b11b-2ca1f8ff9fa1"],
 ", and its variational vector, ",
 Cell[BoxData[
 "VariationalVectorNormalOfPDOfM"], "InlineCode",ExpressionUUID->
  "d43865e2-34eb-aa49-b8ff-6fbbbd2a2fd2"],
 ". We will explain them further later but, in essence, ",
 Cell[BoxData[
 "NormalOfPDOfM"], "InlineCode",ExpressionUUID->
  "c8375260-0241-b24b-a006-c26c7889c073"],
 " is in most cases equal to ",
 Cell[BoxData[
  RowBox[{"NormalOfCovD", "[", "PD", "]"}]], "InlineCode",ExpressionUUID->
  "01ba6d0c-12ea-5f46-bd66-32ae0ec1dff3"],
 " (see Subsection",
 StyleBox[" ",
  FontColor->RGBColor[0.25098039215686274`, 0., 0.5019607843137255]],
 StyleBox[
 CounterBox["Chapter", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Section DefTensor"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[ButtonBox[".",
  BaseStyle->"Hyperlink",
  ButtonData->"Section DefTensor"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Subsection", "Sub FindPotentialDivergence"],
  FontColor->RGBColor[0., 0., 1.]],
 ")."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellDingbat->"\[FivePointedStar]",
 CellChangeTimes->{{3.949774179024399*^9, 3.949774230967118*^9}, {
   3.949776006619938*^9, 3.949776011645254*^9}, {3.950556812362524*^9, 
   3.9505568123682537`*^9}, 3.952346759269655*^9, {3.952347102125284*^9, 
   3.9523471112187686`*^9}, 3.9523471550424204`*^9, {3.954482182238866*^9, 
   3.9544821830794687`*^9}, {3.955365797009323*^9, 3.9553658145837283`*^9}, {
   3.955365853879527*^9, 3.955365890746702*^9}, 3.95552552128479*^9, {
   3.957075776241568*^9, 3.9570758025207744`*^9}, {3.957342655273328*^9, 
   3.957342726318339*^9}, 3.9573551875789523`*^9, {3.957355241236866*^9, 
   3.9573552670132446`*^9}, 3.9573553994871235`*^9, {3.957355440170689*^9, 
   3.957355516372707*^9}, {3.9573964993201714`*^9, 3.9573965054715347`*^9}, {
   3.957605253281783*^9, 3.9576052561221595`*^9}, {3.957829456005148*^9, 
   3.957829457174774*^9}, 3.957956786546767*^9, {3.9579569853195953`*^9, 
   3.957957008819309*^9}, 3.9580428728981247`*^9, {3.958069075715662*^9, 
   3.9580690861163673`*^9}, {3.958235525030905*^9, 3.958235526583233*^9}, {
   3.9586126269869895`*^9, 3.958612626997616*^9}, 3.9595058321572666`*^9, 
   3.9595787470648136`*^9, 3.9595788535646343`*^9},
 Background->GrayLevel[
  1],ExpressionUUID->"5d18baee-eab5-a641-a1b7-9b0b49754f41"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormalOfCovD", "[", "PD", "]"}]], "Input",
 CellChangeTimes->{3.957829505456545*^9},
 CellLabel->
  "In[151]:=",ExpressionUUID->"b304468c-d047-934c-8a51-f60f7ec0581a"],

Cell[BoxData["NormalOfPDOfM"], "Output",
 CellChangeTimes->{3.957829506231926*^9, 3.958069090148981*^9, 
  3.9581305384876823`*^9, 3.9581331671090927`*^9, 3.9582160773556976`*^9, 
  3.9595058372398567`*^9, 3.959506629749029*^9, 3.960641659594969*^9, 
  3.963940516322752*^9, 3.9639548279714184`*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"90b81e68-0d4a-ea4d-8db2-eca4dfd521f3"]
}, Open  ]],

Cell[TextData[{
 "However, one has to be careful if several manifolds are defined on the \
session since ",
 Cell[BoxData[
 "PD"], "InlineCode",ExpressionUUID->"53c5558c-b610-f549-add4-91dc9fb66007"],
 " is defined over all of them and more information has to be provided to \
uniquely determined the covector. We will discuss this and related commands \
on Section ",
 StyleBox[ButtonBox["A.",
  BaseStyle->"Hyperlink",
  ButtonData->"Section Ap PD"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Section Ap PD"],
  FontColor->RGBColor[0., 0., 1.]],
 " of the Appendix."
}], "Text",
 CellChangeTimes->{{3.9573450850143585`*^9, 3.957345088775659*^9}, {
   3.9575209657807436`*^9, 3.9575209681992016`*^9}, {3.957605319615303*^9, 
   3.957605339922123*^9}, {3.9579570174514723`*^9, 3.957957020077293*^9}, {
   3.9580691417319775`*^9, 3.9580691443429146`*^9}, 
   3.9595058459790993`*^9},ExpressionUUID->"0d44c370-f216-7a4a-9636-\
5877beae7a0c"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["DefTensor",
   FontWeight->"Bold"]], "InlineCode",ExpressionUUID->
  "59d9d530-2c54-154a-acf5-4dfc095e5558"],
 " has been modified to generate two additional tensors. We will explain the \
first one now and leave the second one for Section ",
 StyleBox[
 CounterBox["Chapter", 
  "Section Variational Vectors and Variational vector fields"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[".",
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", 
  "Section Variational Vectors and Variational vector fields"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[".",
  FontColor->RGBColor[0., 0., 0.]]
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellDingbat->"\[FivePointedStar]",
 CellChangeTimes->{{3.9523471694075623`*^9, 3.9523471786422334`*^9}, {
   3.955346271242563*^9, 3.9553462860396943`*^9}, 3.9553659017620225`*^9, {
   3.9573452274606323`*^9, 3.95734523629169*^9}, {3.9573547591399136`*^9, 
   3.9573547633821545`*^9}, {3.9575210224619417`*^9, 
   3.9575210453453693`*^9}, {3.957521152693198*^9, 3.957521172885765*^9}, {
   3.9578852370997257`*^9, 3.957885246012129*^9}, {3.958069155896681*^9, 
   3.958069156207155*^9}, {3.9595058626182213`*^9, 3.9595058743878117`*^9}},
 Background->GrayLevel[
  1],ExpressionUUID->"42f2212f-8f84-b84c-a307-971c28df2431"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v0", "[", "a", "]"}], ",", "M"}], "]"}]], "Input",
 CellLabel->
  "In[152]:=",ExpressionUUID->"817635e2-d8c2-c848-a942-b8cc0987a9f5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v0", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v0[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595058854185066`*^9, 3.9595066334987335`*^9, 
  3.960641659626423*^9, 3.963940518057129*^9, 3.963940862609028*^9, 
  3.963941419885332*^9, 3.9639420479363956`*^9, 3.9639421966603985`*^9, 
  3.963954832160818*^9},
 CellLabel->
  "During evaluation of \
In[152]:=",ExpressionUUID->"c3762a58-f355-8a40-a2ba-654c22deedee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlv0", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`dlv0[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595058854185066`*^9, 3.9595066334987335`*^9, 
  3.960641659626423*^9, 3.963940518057129*^9, 3.963940862609028*^9, 
  3.963941419885332*^9, 3.9639420479363956`*^9, 3.9639421966603985`*^9, 
  3.963954832217499*^9},
 CellLabel->
  "During evaluation of \
In[152]:=",ExpressionUUID->"655f0264-4080-334d-9c57-14c99d1df7dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectorv0", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectorv0[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595058854185066`*^9, 3.9595066334987335`*^9, 
  3.960641659626423*^9, 3.963940518057129*^9, 3.963940862609028*^9, 
  3.963941419885332*^9, 3.9639420479363956`*^9, 3.9639421966603985`*^9, 
  3.9639548322414455`*^9},
 CellLabel->
  "During evaluation of \
In[152]:=",ExpressionUUID->"1102c2f9-9562-2647-836b-95df2b4d3787"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Let us now focus on ",
 Cell[BoxData[
 "dlv0"], "InlineCode",ExpressionUUID->"65b742d6-00fb-254f-bb63-b4987d508197"],
 ", which represents the variation of ",
 Cell[BoxData[
 "v0"], "InlineCode",ExpressionUUID->"62240754-f065-604f-9dfe-bdf28e310272"],
 " (if ",
 Cell[BoxData[
  RowBox[{"v0", "\[Element]", 
   StyleBox["F",
    FontFamily->"MV Boli",
    FontWeight->"Normal",
    FontSlant->"Oblique",
    FontColor->RGBColor[0., 0., 0.]]}]], "InlineCode",ExpressionUUID->
  "42f7038d-6b30-904a-ad25-9a492c7c84c7"],
 ", i.e. if ",
 Cell[BoxData[
 "v0"], "InlineCode",ExpressionUUID->"f34595ed-7d65-1c4e-8c7a-93214eab6ab6"],
 " is an element of the space of fields ",
 Cell[BoxData[
  StyleBox["F",
   FontFamily->"MV Boli",
   FontWeight->"Normal",
   FontSlant->"Oblique",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "f4b096ef-18ae-2747-9ede-0defc07ea87f"],
 ", then ",
 Cell[BoxData[
  RowBox[{"dlv0", "\[Element]", 
   StyleBox[
    RowBox[{"T", 
     StyleBox["F",
      FontFamily->"MV Boli",
      FontWeight->"Normal",
      FontSlant->"Oblique",
      FontColor->RGBColor[0., 0., 0.]]}]]}]], "InlineCode",ExpressionUUID->
  "fd91c05a-3210-a44b-a7df-9eff7150fd9d"],
 ", see see [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography CPS JMB-EJSV"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 "] for further details) . It can also be understood as the vertical exterior \
derivative of ",
 Cell[BoxData[
 "v0"], "InlineCode",ExpressionUUID->"cf7ff1f0-5179-0046-8eb9-f01718cbb49b"],
 " (the standard exterior derivative, the one defined for instance in ",
 StyleBox["xTerior",
  FontWeight->"Bold"],
 ", is called horizontal and both fit within the bicomplex formalism [",
 StyleBox[
 CounterBox["ItemNumbered", "bibliography Anderson"],
  FontColor->RGBColor[1., 0.2901960784313726, 0.2901960784313726]],
 "])."
}], "Text",
 CellChangeTimes->{{3.9573450850143585`*^9, 3.957345088775659*^9}, {
   3.9575209657807436`*^9, 3.9575209681992016`*^9}, {3.957605319615303*^9, 
   3.957605339922123*^9}, {3.9579570174514723`*^9, 3.957957020077293*^9}, {
   3.9580691417319775`*^9, 3.9580691443429146`*^9}, {3.958069201005783*^9, 
   3.9580692098135414`*^9}, {3.9580694914906464`*^9, 3.958069561306164*^9}, {
   3.958069608056055*^9, 3.958069608056055*^9}, {3.9580696407817097`*^9, 
   3.958069661972183*^9}, {3.9580697015487003`*^9, 3.958069704841692*^9}, {
   3.9580701420668697`*^9, 3.958070266466345*^9}, {3.9595058957887497`*^9, 
   3.9595059238200855`*^9}, {3.9595066420220127`*^9, 3.9595066423076725`*^9}, 
   3.9595716323554*^9},ExpressionUUID->"56ef0d40-ced4-0f4e-94d7-6b0f75ef0293"],

Cell[CellGroupData[{

Cell[BoxData[{"dlv0", "\[IndentingNewLine]", 
 RowBox[{"dlv0", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MasterOf", "[", "dlv0", "]"}]}], "Input",
 CellLabel->
  "In[153]:=",ExpressionUUID->"f52b7e2a-0217-2747-a129-71b06b1c53c6"],

Cell[BoxData["dlv0"], "Output",
 CellChangeTimes->{3.957763491280094*^9, 3.957764044736997*^9, 
  3.957786000977919*^9, 3.95778766035235*^9, 3.957789628217666*^9, 
  3.957829511634819*^9, 3.9580691730926876`*^9, 3.9581305427936897`*^9, 
  3.9581331705352573`*^9, 3.9582161024651184`*^9, 3.9595059383258095`*^9, 
  3.959506634912056*^9, 3.960641659674036*^9, 3.9639405198826237`*^9, 
  3.963954833439232*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"1518b913-496d-724d-b7ac-d57a671706ef"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"(", 
       RowBox[{"\[DifferentialD]", "v0"}], ")"}], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`dlv0[$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.957763491280094*^9, 3.957764044736997*^9, 
  3.957786000977919*^9, 3.95778766035235*^9, 3.957789628217666*^9, 
  3.957829511634819*^9, 3.9580691730926876`*^9, 3.9581305427936897`*^9, 
  3.9581331705352573`*^9, 3.9582161024651184`*^9, 3.9595059383258095`*^9, 
  3.959506634912056*^9, 3.960641659674036*^9, 3.9639405198826237`*^9, 
  3.9639548335218983`*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"51dc261a-4e83-eb43-861a-f59504862a07"],

Cell[BoxData["v0"], "Output",
 CellChangeTimes->{3.957763491280094*^9, 3.957764044736997*^9, 
  3.957786000977919*^9, 3.95778766035235*^9, 3.957789628217666*^9, 
  3.957829511634819*^9, 3.9580691730926876`*^9, 3.9581305427936897`*^9, 
  3.9581331705352573`*^9, 3.9582161024651184`*^9, 3.9595059383258095`*^9, 
  3.959506634912056*^9, 3.960641659674036*^9, 3.9639405198826237`*^9, 
  3.9639548335468826`*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"a15eb299-a2d8-0745-bf84-dd1eb0f692a2"]
}, Open  ]],

Cell[TextData[{
 "The name of this new tensor is the same as its Master but with the prefix \
\[OpenCurlyDoubleQuote]dl\[CloseCurlyDoubleQuote] to remind both the prefix \
delta, \[Delta], and the \[OpenCurlyDoubleQuote]double d\
\[CloseCurlyDoubleQuote], \[DifferentialD], that are most common in the \
literature. More concretely, in the physics literature one can find both \
\[DifferentialD] and \[Delta], while in the mathematic literature one usually \
finds ",
 Cell[BoxData[
  SubscriptBox["d", "V"]],
  CellChangeTimes->{{3.949768918477066*^9, 3.9497689189530487`*^9}, {
   3.949769232032429*^9, 3.949769281829607*^9}, {3.949770952534083*^9, 
   3.949770993373991*^9}, {3.9538154858982697`*^9, 3.9538155030315247`*^9}, {
   3.9538155565803566`*^9, 3.953815567457308*^9}, {3.957361865872034*^9, 
   3.957361916076931*^9}},ExpressionUUID->
  "654fca28-af34-004b-aa19-36ef051e1562"],
 " (vertical exterior derivative). The ",
 Cell[BoxData[
 "PrintAs"], "InlineCode",ExpressionUUID->
  "370056fe-76ae-b64c-9ea8-96a34c6007a5"],
 " of the new tensor is modified to include the prefix \[DifferentialD]. This \
can be changed using the constants:"
}], "Text",
 CellChangeTimes->{{3.952347272354478*^9, 3.952347434004697*^9}, {
   3.954480399057805*^9, 3.9544804007276444`*^9}, 3.957397953860614*^9, {
   3.9575212024263706`*^9, 3.957521305775202*^9}, {3.957605370403364*^9, 
   3.9576053773662395`*^9}, {3.957829522794956*^9, 3.9578295548292065`*^9}, {
   3.958069217349518*^9, 3.9580692834662857`*^9}, {3.958069349932049*^9, 
   3.9580693502773952`*^9}},ExpressionUUID->"cd068fcb-0f37-e44a-a488-\
b8167449e47a"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["$NameVerticalExteriorDerivative",
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"0979e5ac-fd4a-7443-be11-e242fd257338"],
 StyleBox["\n",
  FontSize->3],
 "It is a string representing the name of the vertical exterior derivative, \
by default ",
 Cell[BoxData[
 "dl"], "InlineCode",ExpressionUUID->"0db5b112-0d09-0d41-8015-1672d1761db2"],
 " (to remind both the symbols \[DifferentialD] and \[Delta]).\n\n",
 Cell[BoxData[
  StyleBox["$SymbolVerticalExteriorDerivative",
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"41f03f10-7547-6848-8629-92cd273214b6"],
 StyleBox["\n",
  FontSize->3],
 "It is the symbol representing the vertical exterior derivative, typically \
denoted as \[DifferentialD] (\[EscapeKey]+dd+\[EscapeKey]) or \[Delta] (\
\[EscapeKey]+d+\[EscapeKey])."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952437867524809*^9, 3.9524378774013205`*^9}, {
   3.953087305389626*^9, 3.9530873445165377`*^9}, 3.954480967702871*^9, {
   3.955939476203476*^9, 3.9559394785618296`*^9}, {3.9567201414209175`*^9, 
   3.9567201435123315`*^9}, 3.9567201906195354`*^9, {3.956720310900824*^9, 
   3.9567203440153913`*^9}, {3.956720379872291*^9, 3.956720382879834*^9}, {
   3.956723229434642*^9, 3.9567232794873457`*^9}, {3.956743396235732*^9, 
   3.9567434396150417`*^9}, {3.9567434890711126`*^9, 
   3.9567435142721543`*^9}, {3.9567435663608007`*^9, 
   3.9567435842662835`*^9}, {3.956743687294647*^9, 3.956743709995721*^9}, {
   3.956743749468743*^9, 3.9567437733356733`*^9}, {3.956743805608357*^9, 
   3.9567438235650253`*^9}, {3.9567438608251023`*^9, 3.956743887050991*^9}, {
   3.956743944813861*^9, 3.956743970613556*^9}, {3.9567440378105135`*^9, 
   3.9567440414225626`*^9}, {3.9567441806787224`*^9, 
   3.9567441860774517`*^9}, {3.9567442440943637`*^9, 3.956744301767004*^9}, {
   3.9567443359415236`*^9, 3.956744392780037*^9}, {3.956744437265887*^9, 
   3.9567444509361777`*^9}, {3.956744486455978*^9, 3.9567445847598896`*^9}, 
   3.9574473710705423`*^9, {3.9578835713072915`*^9, 3.957883576924077*^9}, {
   3.958069325910225*^9, 3.958069330508869*^9}, {3.9580705929739933`*^9, 
   3.958070594660631*^9}, {3.9580807859435425`*^9, 3.9580807874812794`*^9}, {
   3.9581314189979687`*^9, 3.958131447917591*^9}},
 Background->GrayLevel[
  0.909804],ExpressionUUID->"5a6cc967-256e-184e-a70a-6cb702826b85"],

Cell[CellGroupData[{

Cell[BoxData[{"$NameVerticalExteriorDerivative", "\[IndentingNewLine]", \
"$SymbolVerticalExteriorDerivative"}], "Input",
 CellLabel->
  "In[156]:=",ExpressionUUID->"2fff90b8-848f-fc43-b2f0-7039ac811bdf"],

Cell[BoxData["\<\"dl\"\>"], "Output",
 CellChangeTimes->{3.9577634913009696`*^9, 3.957764047139453*^9, 
  3.9577860009994245`*^9, 3.9577876605015535`*^9, 3.957789628280506*^9, 
  3.958069344640003*^9, 3.9581305459653473`*^9, 3.958133173032013*^9, 
  3.9582161059385757`*^9, 3.9595059598109016`*^9, 3.9606416597380505`*^9, 
  3.9639405239378777`*^9, 3.963954835648752*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"5198a1be-1c6e-3c4f-b785-7556a582a28d"],

Cell[BoxData["\<\"\[DifferentialD]\"\>"], "Output",
 CellChangeTimes->{3.9577634913009696`*^9, 3.957764047139453*^9, 
  3.9577860009994245`*^9, 3.9577876605015535`*^9, 3.957789628280506*^9, 
  3.958069344640003*^9, 3.9581305459653473`*^9, 3.958133173032013*^9, 
  3.9582161059385757`*^9, 3.9595059598109016`*^9, 3.9606416597380505`*^9, 
  3.9639405239378777`*^9, 3.9639548356887035`*^9},
 CellLabel->
  "Out[157]=",ExpressionUUID->"5d0767a6-57a6-dc45-a348-2ee443bd16e7"]
}, Open  ]],

Cell[TextData[{
 "The options of tensor, such as ",
 Cell[BoxData[
 "SlotsOfTensor"], "InlineCode",ExpressionUUID->
  "b0f27ea4-6603-884f-8ddb-5ed39e11d155"],
 ", ",
 Cell[BoxData[
 "PrintAs"], "InlineCode",ExpressionUUID->
  "673513cd-bdaf-ba47-875a-a326402c9483"],
 ", ",
 Cell[BoxData[
 "Symmetries"], "InlineCode",ExpressionUUID->
  "404c3d66-28ee-f848-9a5a-937d6fa30c9f"],
 " and ",
 Cell[BoxData[
 "WeightOfTensor"], "InlineCode",ExpressionUUID->
  "f6f44ac0-7ba4-3345-96b6-236d62f65961"],
 ", are inherited by ",
 Cell[BoxData[
 "dltensor"], "InlineCode",ExpressionUUID->
  "3749ab65-d2bb-8f49-8e40-31bb8c36bdec"],
 "."
}], "Text",
 CellChangeTimes->{{3.952516919791658*^9, 3.9525169279991612`*^9}, {
   3.9544822664742217`*^9, 3.954482272600372*^9}, {3.955718990694721*^9, 
   3.9557189948839893`*^9}, 3.9567445977667184`*^9, {3.957829579356104*^9, 
   3.957829579912876*^9}, {3.9580693587667084`*^9, 
   3.958069374318922*^9}},ExpressionUUID->"d4e7a7ed-237b-714d-a6c5-\
597fd697242f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"tensor", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "M", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
   RowBox[{"PrintAs", "->", "\"\<(\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
StyleBox[\"T\", \"TI\"], TraditionalForm], \"errors\" -> {}, \"input\" -> \"T\
\", \"state\" -> \"Boxes\"|>,\"TeXAssistantTemplate\"]\))\>\""}], ",", 
   RowBox[{"WeightOfTensor", "->", 
    RowBox[{
     RowBox[{"-", "2"}], "AIndex"}]}]}], "]"}]], "Input",
 CellChangeTimes->{3.9575213358748627`*^9},
 CellLabel->
  "In[158]:=",ExpressionUUID->"10bf1e01-884f-4a4d-a310-a982ac1bcaf1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"tensor", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`tensor[$CellContext`a, $CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763491325283*^9, 3.9577640506603503`*^9, 
  3.9577860010528593`*^9, 3.957787660590472*^9, 3.9577896283731527`*^9, 
  3.9580693857026253`*^9, 3.9581305479084263`*^9, 3.9581331749606705`*^9, 
  3.9582161086006145`*^9, 3.9582230342072124`*^9, 3.959505967437483*^9, 
  3.959506646768568*^9, 3.9606416598174706`*^9, 3.9639405254365883`*^9, 
  3.9639408654122543`*^9, 3.9639548373391495`*^9},
 CellLabel->
  "During evaluation of \
In[158]:=",ExpressionUUID->"36a5d8d5-a3d0-fd4b-ba77-a00791f896a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dltensor", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`dltensor[$CellContext`a, $CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763491325283*^9, 3.9577640506603503`*^9, 
  3.9577860010528593`*^9, 3.957787660590472*^9, 3.9577896283731527`*^9, 
  3.9580693857026253`*^9, 3.9581305479084263`*^9, 3.9581331749606705`*^9, 
  3.9582161086006145`*^9, 3.9582230342072124`*^9, 3.959505967437483*^9, 
  3.959506646768568*^9, 3.9606416598174706`*^9, 3.9639405254365883`*^9, 
  3.9639408654122543`*^9, 3.9639548373601494`*^9},
 CellLabel->
  "During evaluation of \
In[158]:=",ExpressionUUID->"c9e01b96-2456-dd4c-99e9-05620ca0bbfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectortensor", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectortensor[-$CellContext`a, -$CellContext`b], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763491325283*^9, 3.9577640506603503`*^9, 
  3.9577860010528593`*^9, 3.957787660590472*^9, 3.9577896283731527`*^9, 
  3.9580693857026253`*^9, 3.9581305479084263`*^9, 3.9581331749606705`*^9, 
  3.9582161086006145`*^9, 3.9582230342072124`*^9, 3.959505967437483*^9, 
  3.959506646768568*^9, 3.9606416598174706`*^9, 3.9639405254365883`*^9, 
  3.9639408654122543`*^9, 3.9639548373811493`*^9},
 CellLabel->
  "During evaluation of \
In[158]:=",ExpressionUUID->"45f6d0d3-8064-e94d-a406-83f66e70356f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tensor", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"dltensor", "[", 
  RowBox[{"a", ",", "b"}], "]"}]}], "Input",
 CellLabel->
  "In[159]:=",ExpressionUUID->"e9e64ebb-7012-854a-b1f5-e6e45467f69d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      UnderscriptBox[
       RowBox[{"(", 
        TemplateBox[<|"boxes" -> FormBox[
            StyleBox["T", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
          "T", "state" -> "Boxes"|>,
         "TeXAssistantTemplate"], ")"}], 
       UnderscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]], 
      StyleBox[GridBox[{
         {"a", "b"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`tensor[$CellContext`a, $CellContext`b],
  Editable->False]], "Output",
 CellChangeTimes->{3.9577634914230995`*^9, 3.957764051994393*^9, 
  3.957786001089731*^9, 3.9577876608130217`*^9, 3.9577896284898305`*^9, 
  3.9581305489087143`*^9, 3.9581331765822544`*^9, 3.9582161101440105`*^9, 
  3.9595059689067364`*^9, 3.959506648214285*^9, 3.9606416598972836`*^9, 
  3.9639405285021973`*^9, 3.9639548386805534`*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"e999f353-889b-f645-a109-f2f594841cec"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"(", 
       RowBox[{"\[DifferentialD]", 
        UnderscriptBox[
         TemplateBox[<|"boxes" -> FormBox[
             StyleBox["T", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
           "T", "state" -> "Boxes"|>,
          "TeXAssistantTemplate"], 
         UnderscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]]}], ")"}], 
      StyleBox[GridBox[{
         {"a", "b"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`dltensor[$CellContext`a, $CellContext`b],
  Editable->False]], "Output",
 CellChangeTimes->{3.9577634914230995`*^9, 3.957764051994393*^9, 
  3.957786001089731*^9, 3.9577876608130217`*^9, 3.9577896284898305`*^9, 
  3.9581305489087143`*^9, 3.9581331765822544`*^9, 3.9582161101440105`*^9, 
  3.9595059689067364`*^9, 3.959506648214285*^9, 3.9606416598972836`*^9, 
  3.9639405285021973`*^9, 3.963954838723524*^9},
 CellLabel->
  "Out[160]=",ExpressionUUID->"500bc58e-5e8b-e847-a50a-d7443dd5922b"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Remark: ",
  FontWeight->"Bold"],
 Cell[BoxData["dltensor"], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"5915fb81-333e-964c-a164-db0e4c30cd0d"],
 StyleBox[" is surrounded by a parenthesis to make clear that the indices are \
attached to ",
  FontWeight->"Plain"],
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"dltensor", "'"}]}]], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"4a9144c5-00c5-5148-9c91-314e8bba5b43"],
 StyleBox[" and not to ",
  FontWeight->"Plain"],
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"tensor", "'"}]}]], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"26c2d64c-a4e9-ef4a-9ec5-ff32a87cf99d"],
 StyleBox[". If ",
  FontWeight->"Plain"],
 Cell[BoxData[
  RowBox[{"PrintAs", "[", "tensor", "]"}]], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"e2dd3b68-8461-0c41-b0cf-58f3370bc808"],
 StyleBox[" has parenthesis, ",
  FontWeight->"Plain"],
 Cell[BoxData[
  RowBox[{"PrintAs", "[", "dltensor", "]"}]], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"ae0fa265-581e-9743-8e11-660a87e8ca7d"],
 StyleBox[" removes them to avoid too many parentheses. This behaviour is \
controlled by the constant ",
  FontWeight->"Plain"],
 Cell[BoxData["$RemoveParenthesesPrintAs"], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"39c8f6d2-86b2-3045-8209-08670578df8a"],
 StyleBox[" (set ",
  FontWeight->"Plain"],
 Cell[BoxData["True"], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"76f8e9b5-d0db-e446-8cf0-a087f2d52434"],
 StyleBox[" by default). If set to ",
  FontWeight->"Plain"],
 Cell[BoxData["False"], "InlineCode",
  FontWeight->"Plain",ExpressionUUID->"f4d63f40-4238-794b-9cf9-797778b80df5"],
 StyleBox[", the outer-most parentheses are not removed.",
  FontWeight->"Plain"]
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.959573346626133*^9, 3.9595733471500225`*^9}, {
   3.95957423253627*^9, 3.959574239305065*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"5a8a406d-8e36-954d-9139-1f2c1e1bddf9"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["$RemoveParenthesesPrintAs",
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"b025a8a6-877b-5b4b-94f9-055408085646"],
 "\nIt is a global variable that controls the behavior of the private \
function ",
 Cell[BoxData[
 "RemoveOuterParanthesis"], "InlineCode",ExpressionUUID->
  "fde8dded-36be-974d-a54d-2c2bd57f17c9"],
 " (used to set the ",
 Cell[BoxData[
 "PrintAs"], "InlineCode",ExpressionUUID->
  "84f9a56a-7980-7c4e-84c3-f720f255fd7a"],
 " of the associated tensors ",
 Cell[BoxData[
  RowBox[{"VertDiff", "[", "tensor", "]"}]], "InlineCode",ExpressionUUID->
  "58152c79-1ada-1544-974c-fbb90a5add04"],
 " and ",
 Cell[BoxData[
  RowBox[{"VariationalVector", "[", "tensor", "]"}]], "InlineCode",
  ExpressionUUID->"ee558611-6015-754d-a20f-b4f1747c3381"],
 "). If set to ",
 Cell[BoxData[
 "True"], "InlineCode",ExpressionUUID->"7de5d084-2859-e347-84df-3eb2e3568961"],
 ", the function removes enclosing parentheses from strings when present."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.952437867524809*^9, 3.9524378774013205`*^9}, {
   3.953087305389626*^9, 3.9530873445165377`*^9}, 3.954480967702871*^9, {
   3.955939476203476*^9, 3.9559394785618296`*^9}, {3.9567201414209175`*^9, 
   3.9567201435123315`*^9}, 3.9567201906195354`*^9, {3.956720310900824*^9, 
   3.9567203440153913`*^9}, {3.956720379872291*^9, 3.956720382879834*^9}, {
   3.956723229434642*^9, 3.9567232794873457`*^9}, {3.956743396235732*^9, 
   3.9567434396150417`*^9}, {3.9567434890711126`*^9, 
   3.9567435142721543`*^9}, {3.9567435663608007`*^9, 
   3.9567435842662835`*^9}, {3.956743687294647*^9, 3.956743709995721*^9}, {
   3.956743749468743*^9, 3.9567437733356733`*^9}, {3.956743805608357*^9, 
   3.9567438235650253`*^9}, {3.9567438608251023`*^9, 3.956743887050991*^9}, {
   3.956743944813861*^9, 3.956743970613556*^9}, {3.9567440378105135`*^9, 
   3.9567440414225626`*^9}, {3.9567441806787224`*^9, 
   3.9567441860774517`*^9}, {3.9567442440943637`*^9, 3.956744301767004*^9}, {
   3.9567443359415236`*^9, 3.956744392780037*^9}, {3.956744437265887*^9, 
   3.9567444509361777`*^9}, {3.956744486455978*^9, 3.9567445847598896`*^9}, 
   3.9574473710705423`*^9, {3.9578835713072915`*^9, 3.957883576924077*^9}, {
   3.958069325910225*^9, 3.958069330508869*^9}, {3.9580705929739933`*^9, 
   3.958070594660631*^9}, {3.9580807859435425`*^9, 3.9580807874812794`*^9}, {
   3.9581314189979687`*^9, 3.958131447917591*^9}, {3.959506020572937*^9, 
   3.959506092649954*^9}, {3.959506140576868*^9, 3.9595061940341587`*^9}},
 Background->GrayLevel[
  0.909804],ExpressionUUID->"8e467fcd-98ff-404d-8e45-bd43b304d47a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tensor", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "-", 
   RowBox[{"tensor", "[", 
    RowBox[{"b", ",", "a"}], "]"}]}], "==", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"tensor", "[", 
      RowBox[{"a", ",", "b"}], "]"}], "-", 
     RowBox[{"tensor", "[", 
      RowBox[{"b", ",", "a"}], "]"}]}], "//", "Simplification"}], ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"dltensor", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "-", 
    RowBox[{"dltensor", "[", 
     RowBox[{"b", ",", "a"}], "]"}]}], "==", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"dltensor", "[", 
       RowBox[{"a", ",", "b"}], "]"}], "-", 
      RowBox[{"dltensor", "[", 
       RowBox[{"b", ",", "a"}], "]"}]}], "//", "Simplification"}], ")"}]}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Same", " ", "symmetries"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", "dltensor", "]"}], "==", 
   RowBox[{"SlotsOfTensor", "[", "tensor", "]"}]}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Same", " ", "Slots"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WeightOfTensor", "@", "tensor"}], "==", 
  RowBox[{"WeightOfTensor", "@", "dltensor", 
   RowBox[{"(*", " ", 
    RowBox[{"Same", " ", "Weights"}], " ", "*)"}]}]}]}], "Input",
 CellChangeTimes->{{3.9580694494847374`*^9, 3.958069464094244*^9}, 
   3.959506004853098*^9},
 CellLabel->
  "In[161]:=",ExpressionUUID->"a579a62d-9b0d-364e-b365-0b717802739c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        UnderscriptBox[
         RowBox[{"(", 
          TemplateBox[<|"boxes" -> FormBox[
              StyleBox["T", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
            "T", "state" -> "Boxes"|>,
           "TeXAssistantTemplate"], ")"}], 
         UnderscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]], 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`tensor[$CellContext`a, $CellContext`b],
    Editable->False], "-", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        UnderscriptBox[
         RowBox[{"(", 
          TemplateBox[<|"boxes" -> FormBox[
              StyleBox["T", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
            "T", "state" -> "Boxes"|>,
           "TeXAssistantTemplate"], ")"}], 
         UnderscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]], 
        StyleBox[GridBox[{
           {"b", "a"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`tensor[$CellContext`b, $CellContext`a],
    Editable->False]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{
  3.95776349147038*^9, 3.957786001121338*^9, 3.957787661135893*^9, 
   3.9577896285632153`*^9, {3.958069443095209*^9, 3.958069465069422*^9}, 
   3.958130550662405*^9, 3.9581331794171486`*^9, 3.958216113949749*^9, 
   3.9595061988651714`*^9, 3.9595066504477386`*^9, 3.96064166000778*^9, 
   3.963940543016859*^9, 3.9639548460049534`*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"48ee39a0-b54d-f54a-94b2-c8a8bec599b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"(", 
         RowBox[{"\[DifferentialD]", 
          UnderscriptBox[
           TemplateBox[<|"boxes" -> FormBox[
               StyleBox["T", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
             "T", "state" -> "Boxes"|>,
            "TeXAssistantTemplate"], 
           UnderscriptBox[
            StyleBox["~",
             FontColor->RGBColor[0, 0, 0]], 
            StyleBox["~",
             FontColor->RGBColor[0, 0, 0]]]]}], ")"}], 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dltensor[$CellContext`a, $CellContext`b],
    Editable->False], "-", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"(", 
         RowBox[{"\[DifferentialD]", 
          UnderscriptBox[
           TemplateBox[<|"boxes" -> FormBox[
               StyleBox["T", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
             "T", "state" -> "Boxes"|>,
            "TeXAssistantTemplate"], 
           UnderscriptBox[
            StyleBox["~",
             FontColor->RGBColor[0, 0, 0]], 
            StyleBox["~",
             FontColor->RGBColor[0, 0, 0]]]]}], ")"}], 
        StyleBox[GridBox[{
           {"b", "a"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`dltensor[$CellContext`b, $CellContext`a],
    Editable->False]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{
  3.95776349147038*^9, 3.957786001121338*^9, 3.957787661135893*^9, 
   3.9577896285632153`*^9, {3.958069443095209*^9, 3.958069465069422*^9}, 
   3.958130550662405*^9, 3.9581331794171486`*^9, 3.958216113949749*^9, 
   3.9595061988651714`*^9, 3.9595066504477386`*^9, 3.96064166000778*^9, 
   3.963940543016859*^9, 3.9639548460984573`*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"7e5d9d7d-9842-8040-a258-cac2af26d2f9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.95776349147038*^9, 3.957786001121338*^9, 3.957787661135893*^9, 
   3.9577896285632153`*^9, {3.958069443095209*^9, 3.958069465069422*^9}, 
   3.958130550662405*^9, 3.9581331794171486`*^9, 3.958216113949749*^9, 
   3.9595061988651714`*^9, 3.9595066504477386`*^9, 3.96064166000778*^9, 
   3.963940543016859*^9, 3.963954846115473*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"804a478a-16cc-1541-ba32-c142de14e067"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.95776349147038*^9, 3.957786001121338*^9, 3.957787661135893*^9, 
   3.9577896285632153`*^9, {3.958069443095209*^9, 3.958069465069422*^9}, 
   3.958130550662405*^9, 3.9581331794171486`*^9, 3.958216113949749*^9, 
   3.9595061988651714`*^9, 3.9595066504477386`*^9, 3.96064166000778*^9, 
   3.963940543016859*^9, 3.9639548461334743`*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"540d7a25-020c-b441-9308-e294ae890b84"]
}, Open  ]],

Cell["We can impose that a tensor is variationally constant:", "Text",
 CellChangeTimes->{{3.9573636337173786`*^9, 3.95736369487422*^9}, {
   3.957363735567251*^9, 3.957363829476774*^9}, {3.957549453171921*^9, 
   3.9575494684819393`*^9}, {3.957549682808279*^9, 3.9575496909279594`*^9}, 
   3.957549913018608*^9},ExpressionUUID->"d6edc2fd-0522-0f49-add4-\
c81f3ae11ae2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"vector", "[", "a", "]"}], ",", "M", ",", 
   RowBox[{"VariationallyConstantQ", "->", "True"}]}], "]"}]], "Input",
 CellFrame->{{0, 0}, {0, 0}},
 CellChangeTimes->{3.957763955427617*^9},
 Background->GrayLevel[1],
 CellLabel->
  "In[165]:=",ExpressionUUID->"1928b9fc-6f9b-4a40-ab45-308410e3f431"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"vector", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`vector[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577640547371187`*^9, 3.957786001169036*^9, 
  3.9577876617641115`*^9, 3.957789628745658*^9, 3.9580697273411407`*^9, 
  3.9580697600429516`*^9, 3.9580811016043243`*^9, 3.9581305636836815`*^9, 
  3.9581331814688473`*^9, 3.958216124824972*^9, 3.9595062065806084`*^9, 
  3.959506654341034*^9, 3.9606416601199036`*^9, 3.963940592152254*^9, 
  3.9639548522410336`*^9},
 CellLabel->
  "During evaluation of \
In[165]:=",ExpressionUUID->"9972b27d-3048-e841-9f9c-917b30d6253b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlvector", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`dlvector[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577640547371187`*^9, 3.957786001169036*^9, 
  3.9577876617641115`*^9, 3.957789628745658*^9, 3.9580697273411407`*^9, 
  3.9580697600429516`*^9, 3.9580811016043243`*^9, 3.9581305636836815`*^9, 
  3.9581331814688473`*^9, 3.958216124824972*^9, 3.9595062065806084`*^9, 
  3.959506654341034*^9, 3.9606416601199036`*^9, 3.963940592152254*^9, 
  3.9639548522592087`*^9},
 CellLabel->
  "During evaluation of \
In[165]:=",ExpressionUUID->"0b41a6e9-2807-cb41-9155-f5f1542f7d3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectorvector", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectorvector[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9577640547371187`*^9, 3.957786001169036*^9, 
  3.9577876617641115`*^9, 3.957789628745658*^9, 3.9580697273411407`*^9, 
  3.9580697600429516`*^9, 3.9580811016043243`*^9, 3.9581305636836815`*^9, 
  3.9581331814688473`*^9, 3.958216124824972*^9, 3.9595062065806084`*^9, 
  3.959506654341034*^9, 3.9606416601199036`*^9, 3.963940592152254*^9, 
  3.963954852279207*^9},
 CellLabel->
  "During evaluation of \
In[165]:=",ExpressionUUID->"9bf9c6c9-4cf9-594b-951c-bb1def509e76"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Which defines ",
 Cell[BoxData[
 "dlvector"], "InlineCode",ExpressionUUID->
  "adbe2b85-cf6d-0b41-b381-f49ff4841746"],
 " as vanishing:"
}], "Text",
 CellChangeTimes->{{3.9573636337173786`*^9, 3.95736369487422*^9}, {
  3.957363735567251*^9, 3.957363829476774*^9}, {3.957549453171921*^9, 
  3.9575494684819393`*^9}, {3.957549682808279*^9, 3.9575497300394096`*^9}, {
  3.957605444717455*^9, 
  3.957605449662014*^9}},ExpressionUUID->"fc704684-b682-f747-a345-\
979de4819364"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vector", "[", "a", "]"}], "\[IndentingNewLine]", "dlvector", "\[IndentingNewLine]", 
 RowBox[{"dlvector", "[", "a", "]"}]}], "Input",
 CellLabel->
  "In[166]:=",ExpressionUUID->"655bce7c-1ec6-3049-a001-9c9f65bfe50b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"vector", 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`vector[$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.957763491660448*^9, 3.9577860011850185`*^9, 
  3.957787661907856*^9, 3.9577896288152933`*^9, 3.9580697301999607`*^9, 
  3.9581305659898663`*^9, 3.95821612740991*^9, 3.9595062087394276`*^9, 
  3.959506655753418*^9, 3.960641660183956*^9, 3.9639405942407303`*^9, 
  3.9639548531944313`*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"ff5ae7fe-06f9-c04c-9f5b-09c8406e02d8"],

Cell[BoxData["dlvector"], "Output",
 CellChangeTimes->{3.957763491660448*^9, 3.9577860011850185`*^9, 
  3.957787661907856*^9, 3.9577896288152933`*^9, 3.9580697301999607`*^9, 
  3.9581305659898663`*^9, 3.95821612740991*^9, 3.9595062087394276`*^9, 
  3.959506655753418*^9, 3.960641660183956*^9, 3.9639405942407303`*^9, 
  3.9639548532173347`*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"adee3a7a-0954-4d4d-a618-231e5af36164"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.957763491660448*^9, 3.9577860011850185`*^9, 
  3.957787661907856*^9, 3.9577896288152933`*^9, 3.9580697301999607`*^9, 
  3.9581305659898663`*^9, 3.95821612740991*^9, 3.9595062087394276`*^9, 
  3.959506655753418*^9, 3.960641660183956*^9, 3.9639405942407303`*^9, 
  3.9639548532353344`*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"a76a2585-8423-5d42-ad7a-7932223eae3c"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
 "Undef"], "InlineCode",ExpressionUUID->
  "3a4680dd-dcc7-0844-95fd-b7689601ec4f"],
 " undefines both their servants."
}], "Text",
 CellChangeTimes->{{3.9525169578303523`*^9, 3.952516965945585*^9}, 
   3.95739850375507*^9, {3.957447327295978*^9, 3.957447329367752*^9}, 
   3.95805359481361*^9, {3.958069743885729*^9, 3.958069746618511*^9}, {
   3.9580697776679993`*^9, 
   3.958069780913559*^9}},ExpressionUUID->"da312a9a-d2b7-2f43-87a0-\
2b1a3a3a2eb6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ServantsOf", "[", "vector", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Undef", "[", "vector", "]"}]}], "Input",
 CellChangeTimes->{{3.9580697480086956`*^9, 3.958069782701296*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"0b1a3f34-e2c6-8849-a0a6-6f388c6cc20a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dlvector", ",", "VariationalVectorvector"}], "}"}]], "Output",
 CellChangeTimes->{3.958069753710409*^9, 3.958069785731167*^9, 
  3.9581305689662743`*^9, 3.95813318629146*^9, 3.9582161299459305`*^9, 
  3.9595062131577377`*^9, 3.95950665707576*^9, 3.960641660247349*^9, 
  3.9639405960699863`*^9, 3.963954855890253*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"31e50b10-a8cc-0449-a3c6-731cff2833e0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "VariationalVectorvector"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`VariationalVectorvector],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763491692347*^9, 3.9577860012009487`*^9, 
  3.957787662210165*^9, 3.957789628883088*^9, 3.958069753727915*^9, 
  3.9580697857482395`*^9, 3.958130568979233*^9, 3.9581331863105183`*^9, 
  3.958216129957945*^9, 3.9595062131797333`*^9, 3.9595066570997734`*^9, 
  3.960641660263386*^9, 3.9639405961086197`*^9, 3.9639548559259777`*^9},
 CellLabel->
  "During evaluation of \
In[169]:=",ExpressionUUID->"47347831-a4a8-534c-ad85-ddb4570f224b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "dlvector"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`dlvector],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763491692347*^9, 3.9577860012009487`*^9, 
  3.957787662210165*^9, 3.957789628883088*^9, 3.958069753727915*^9, 
  3.9580697857482395`*^9, 3.958130568979233*^9, 3.9581331863105183`*^9, 
  3.958216129957945*^9, 3.9595062131797333`*^9, 3.9595066570997734`*^9, 
  3.960641660263386*^9, 3.9639405961086197`*^9, 3.9639548559489822`*^9},
 CellLabel->
  "During evaluation of \
In[169]:=",ExpressionUUID->"3cad95fe-a31b-ce47-8cd6-a324dacab6e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "vector"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`vector],
  Editable->False]], "Print",
 CellChangeTimes->{3.957763491692347*^9, 3.9577860012009487`*^9, 
  3.957787662210165*^9, 3.957789628883088*^9, 3.958069753727915*^9, 
  3.9580697857482395`*^9, 3.958130568979233*^9, 3.9581331863105183`*^9, 
  3.958216129957945*^9, 3.9595062131797333`*^9, 3.9595066570997734`*^9, 
  3.960641660263386*^9, 3.9639405961086197`*^9, 3.9639548559723873`*^9},
 CellLabel->
  "During evaluation of \
In[169]:=",ExpressionUUID->"fff65903-0ecd-2747-a2f4-926a26f1b0b6"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Vertical forms and vertical degrees"
}], "Subsection",
 CellChangeTimes->{{3.932470606888551*^9, 3.932470617022765*^9}, {
   3.948667234179401*^9, 3.94866723434372*^9}, 3.9486673637970796`*^9, {
   3.9488291490634766`*^9, 3.9488291522954645`*^9}, {3.94882928717527*^9, 
   3.948829289098152*^9}, {3.9497712920349274`*^9, 3.9497713019472733`*^9}, {
   3.958131786770439*^9, 
   3.958131790115364*^9}},ExpressionUUID->"8dd0769e-7abc-fe4b-ac18-\
aecc45f277fe"],

Cell[TextData[{
 Cell[BoxData[
 "WWedge"], "InlineCode",ExpressionUUID->
  "2a2cb299-1d0e-9545-8f07-3ae99cfddad3"],
 ", printed as \:2a55, is the essence of this package. It is a \
super-commutative product, i.e., there exists a gradation, called ",
 Cell[BoxData[
 "VertDeg"], "InlineCode",ExpressionUUID->
  "e9679a5c-61a7-bf40-8a46-94b219946ff2"],
 ", such that ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],ExpressionUUID->
  "9ccbf692-8e3d-8d43-b864-f007dcd2f989"],
 "\:2a55",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{
       RowBox[{"VertDeg", "[", "a", "]"}], 
       RowBox[{"VertDeg", "[", "b", "]"}]}]], "a"}]}], TraditionalForm]],
  ExpressionUUID->"1106ca39-5326-2441-b3c5-805c2838d57b"],
 "\:2a55 ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]],ExpressionUUID->
  "e0cef940-e382-0c47-8b16-c733fe6af44f"],
 "."
}], "Text",
 CellChangeTimes->{{3.9525181391997986`*^9, 3.952518146369632*^9}, 
   3.9544826708401604`*^9, 3.954505140114246*^9, 3.9553660553214664`*^9, {
   3.9576055025720854`*^9, 3.957605511081726*^9}, {3.957829752306038*^9, 
   3.957829761058975*^9}, {3.9578297987032604`*^9, 3.957829809034033*^9}, {
   3.9578298526496353`*^9, 3.9578298572161026`*^9}, {3.95806983613727*^9, 
   3.958069859807192*^9}, {3.9581305842968807`*^9, 3.958130628799526*^9}, {
   3.9639406732575417`*^9, 3.9639407066779575`*^9}, 
   3.963954879832178*^9},ExpressionUUID->"71e11d4d-817f-464d-8563-\
811c4d3ad509"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"VertDeg", "[", "expr", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"21beaa2f-2b3b-7c4b-9797-850b4c8f478d"],
 StyleBox["\n",
  FontSize->3],
 "It returns the vertical degree of the tensor expression ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"expr", "'"}]}]], "InlineCode",ExpressionUUID->
  "57a906ba-d9e9-ef48-9d75-2cb2de5d692c"],
 "."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.949769632126438*^9, 3.949769671894057*^9}, {
   3.9497697189703918`*^9, 3.949769927284092*^9}, {3.94976997142445*^9, 
   3.949770051026247*^9}, {3.949771020626425*^9, 3.949771089222689*^9}, 
   3.949771319595646*^9, {3.9497723492928147`*^9, 3.9497723755001965`*^9}, {
   3.949838805371191*^9, 3.9498388918199673`*^9}, {3.95020712784894*^9, 
   3.950207202133442*^9}, {3.9509792473762646`*^9, 3.9509792498445854`*^9}, 
   3.9523476044741726`*^9, {3.952383926239854*^9, 3.952383939491896*^9}, {
   3.952383982087858*^9, 3.9523839844813347`*^9}, 3.952384116989569*^9, {
   3.952517402256072*^9, 3.9525174494808226`*^9}, {3.952517485337987*^9, 
   3.952517510762508*^9}, {3.9525175452247124`*^9, 3.9525175714361672`*^9}, {
   3.9525177969326777`*^9, 3.952517840169471*^9}, {3.952517962305614*^9, 
   3.9525179651041036`*^9}, {3.954482304139261*^9, 3.9544823379673543`*^9}, {
   3.9553660708609495`*^9, 3.9553660914585247`*^9}, {3.956743182509514*^9, 
   3.956743193929776*^9}, {3.957883581382972*^9, 3.9578835849979267`*^9}, {
   3.957885258113373*^9, 3.9578852637334423`*^9}, {3.9580698098975925`*^9, 
   3.958069813461836*^9}, {3.958069877530678*^9, 3.9580698904246845`*^9}, 
   3.958070601003834*^9, 3.9580809704749203`*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"457172b3-0a20-934a-9dab-599a419f6e73"],

Cell[TextData[{
 StyleBox["Remark:",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontWeight->"Plain"],
 Cell[BoxData[
 "VertDeg"], "InlineCode",ExpressionUUID->
  "43cf8ac6-1394-9441-a6bc-83d4401178c6"],
 StyleBox[" is well-defined over monomials, but over sums of monomials is \
only well defined if all the monomials have the same ",
  FontWeight->"Plain"],
 Cell[BoxData[
 "VertDeg"], "InlineCode",ExpressionUUID->
  "439314fe-3c28-9f4a-ae98-af96d54faed9"],
 StyleBox[" (notice that the sum of elements with different degrees is \
perfectly valid).",
  FontWeight->"Plain"]
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.959573346626133*^9, 3.9595733471500225`*^9}, {
   3.959574258231062*^9, 3.9595742681497707`*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"4e1e1cca-6ed1-de4c-8e8c-699ad36c74d8"],

Cell[TextData[{
 "Over elements with ",
 Cell[BoxData[
  RowBox[{"VertDeg", "=", "0"}]], "InlineCode",ExpressionUUID->
  "8378f790-f101-ba46-9eb1-11e2893ba716"],
 ", ",
 Cell[BoxData[
  RowBox[{"WWedge", "=", "Times"}]], "InlineCode",ExpressionUUID->
  "f0eb5cd5-96b8-4f4e-8746-6a818b431c19"],
 "."
}], "Text",
 CellChangeTimes->{
  3.955366102966565*^9, {3.9574473532646646`*^9, 3.957447353760544*^9}, {
   3.9576055214036603`*^9, 3.9576055411320095`*^9}, {3.9580698940126286`*^9, 
   3.9580699217833595`*^9}, {3.9595062373996525`*^9, 3.959506243844345*^9}, {
   3.959574257476118*^9, 
   3.95957426553644*^9}},ExpressionUUID->"e20261ce-8b6b-9040-86a7-\
f4864a3eca93"],

Cell[TextData[{
 StyleBox["Important",
  FontWeight->"Bold"],
 ": Several functions of ",
 StyleBox["xAct",
  FontWeight->"Bold"],
 " have been modified to account for the ",
 Cell[BoxData[
 "WWedge"], "InlineCode",ExpressionUUID->
  "510e7d61-1ec7-f841-908b-be281920dbd3"],
 " and the ",
 Cell[BoxData[
 "VertDeg"], "InlineCode",ExpressionUUID->
  "6f45a9d9-8449-ef4d-807a-58fe8e4dd2a3"],
 " (essentially changing ",
 Cell[BoxData[
 "Times"], "InlineCode",ExpressionUUID->
  "79e82fd2-43b9-b84b-b3d9-d60dad02a177"],
 " for ",
 Cell[BoxData[
 "WWedge"], "InlineCode",ExpressionUUID->
  "8e380a9e-f97e-ef49-8ff7-0e21e7d438bd"],
 " and being careful about the order), but not all so there is no guarantee \
that everything will work as expected, especially in interaction with other \
packages. If you find some that need modification, please let us know."
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.9580680018555717`*^9, 3.958068006152872*^9}, {
   3.9580683676709976`*^9, 3.9580684079196568`*^9}, {3.958069945944292*^9, 
   3.958070057956253*^9}, {3.959506273007324*^9, 3.9595063139521084`*^9}, 
   3.959573105101576*^9},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"b717881d-9050-b242-b845-8c18c66d73f8"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", " ", "M", ",", " ", 
     RowBox[{"VertDeg", "\[RightArrow]", "integer"}]}], "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
  "20832bf7-a267-6d45-8937-6662cf9e9c5a"],
 " defines the tensor T with certain ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"VertDeg", "[", "T", "]"}], "=", "integer"}]], "InlineCode",
  ExpressionUUID->"a8bb8e2e-04f8-9344-808b-c03ab2798a0f"],
 ", the tensor ",
 Cell[BoxData[
 "dlT"], "InlineCode",ExpressionUUID->"ff87e9c9-5779-0f4e-b58d-73009a0aa03e"],
 " with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"VertDeg", "[", "dlT", "]"}], "=", 
   RowBox[{
    RowBox[{"VertDeg", "[", "T", "]"}], "+", "1"}]}]], "InlineCode",
  ExpressionUUID->"50d6ea6f-9950-fc47-9f18-c8c1496c1b03"],
 " and VertDeg[VariationalVector[T]]=-VertDeg[T]. "
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellDingbat->"\[FivePointedStar]",
 CellChangeTimes->{
  3.952384292054433*^9, {3.952517132932423*^9, 3.9525171765981007`*^9}, {
   3.954482424300695*^9, 3.9544824382920666`*^9}, {3.957076338666704*^9, 
   3.957076346287155*^9}, {3.9580700668182297`*^9, 3.9580700668182297`*^9}, {
   3.9580702793079376`*^9, 3.9580703099303684`*^9}, {3.9580706200896835`*^9, 
   3.958070661329094*^9}, {3.959506348912859*^9, 3.9595064033149605`*^9}},
 Background->GrayLevel[
  1],ExpressionUUID->"8c3396c0-80e5-a846-afb4-5e0e6b27caaf"],

Cell[TextData[{
 StyleBox["Remark",
  FontWeight->"Bold"],
 ": Complex/imaginary and imploded tensors are also supported by ",
 StyleBox["xCPS",
  FontWeight->"Bold"],
 ", see Sections ",
 StyleBox[ButtonBox["A.",
  BaseStyle->"Hyperlink",
  ButtonData->"Section Ap Complex tensors"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Section Ap Complex tensors"],
  FontColor->RGBColor[0., 0., 1.]],
 " and ",
 StyleBox[ButtonBox["A.",
  BaseStyle->"Hyperlink",
  ButtonData->"Section Ap Imploded tensors"],
  FontColor->RGBColor[0., 0., 1.]],
 StyleBox[
 CounterBox["Section", "Section Ap Imploded tensors"],
  FontColor->RGBColor[0., 0., 1.]],
 " of the Appendix for further details."
}], "Item",
 CellChangeTimes->{
  3.9576107520129833`*^9, {3.9577868916370983`*^9, 3.9577868940430784`*^9}, {
   3.958040960033188*^9, 3.958040962208946*^9}, {3.9580651923392982`*^9, 
   3.9580651932995415`*^9}, {3.9580680018555717`*^9, 3.958068006152872*^9}, {
   3.9580683676709976`*^9, 3.9580684079196568`*^9}, {3.958069945944292*^9, 
   3.958070057956253*^9}, {3.9580703160820026`*^9, 3.958070421772503*^9}, {
   3.958070631753433*^9, 3.9580706332676697`*^9}, 3.958141590981163*^9, {
   3.959506409042246*^9, 3.959506429519863*^9}},
 FontWeight->"Normal",
 FontColor->RGBColor[
  0., 0., 0.],ExpressionUUID->"afb4a053-f6ef-f44d-8677-c92b5fde4534"],

Cell[TextData[{
 "In order to define tensors with non-zero vertical degree, we use the option \
",
 Cell[BoxData[
  RowBox[{"VertDeg", "\[RightArrow]", "Integer"}]], "InlineCode",
  ExpressionUUID->"375b4330-afa0-9c43-99dd-c1ff8984eb9b"],
 " (zero by default):"
}], "Text",
 CellChangeTimes->{
  3.957605669352374*^9, {3.958042957826622*^9, 3.95804296965979*^9}, {
   3.9580706890182877`*^9, 
   3.958070692514551*^9}},ExpressionUUID->"209c6291-0993-1e4a-ae82-\
0de05c8dc412"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"alpha0", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "M", ",", 
   RowBox[{"PrintAs", "->", "\"\<\[Alpha]0\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v1", "[", "a", "]"}], ",", "M", ",", 
   RowBox[{"VertDeg", "->", "1"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v2", "[", "a", "]"}], ",", "M", ",", 
   RowBox[{"VertDeg", "->", "2"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v3", "[", "a", "]"}], ",", "M", ",", 
   RowBox[{"VertDeg", "->", "3"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v4", "[", "a", "]"}], ",", "M", ",", 
   RowBox[{"VertDeg", "->", "4"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"alpha3", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "M", ",", 
   RowBox[{"VertDeg", "->", "3"}], ",", 
   RowBox[{"PrintAs", "->", "\"\<\[Alpha]3\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"f3", "[", "]"}], ",", "M", ",", 
   RowBox[{"VertDeg", "->", "3"}], ",", 
   RowBox[{"PrintAs", "->", "\"\<F\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.95760579459369*^9, {3.958042485566433*^9, 3.958042521667925*^9}, {
   3.9582224937446823`*^9, 3.9582224992221775`*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"02b5fa70-bb6e-614a-a726-29620c9f9580"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"alpha0", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`alpha0[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901260504*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"a7b14ec8-5ac5-af48-ba2f-7efd2265bc2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlalpha0", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`dlalpha0[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901283497*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"95439bc0-b2b5-fc43-94e4-30e0648ea881"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectoralpha0", "[", "a", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectoralpha0[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549013045025`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"eb69141c-4792-c847-b2d1-6cbcc04f27b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v1", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v1[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549013227406`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"3b38ae7f-ab95-c348-8053-5766618a53d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlv1", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`dlv1[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901344326*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"085cb84d-0f31-1f42-be1b-31bd75a5cb52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectorv1", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectorv1[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901366337*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"953f66a6-e907-c94f-b96e-0a736b7bbfdb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v2", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v2[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549013880825`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"5023d6f1-0b40-c046-9ad1-30748387e9ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlv2", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`dlv2[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549014117966`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"ee7ad270-2fdb-454c-befd-290b97bc31a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectorv2", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectorv2[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901435335*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"6d27d500-68f4-3d43-8bfd-251559c9e7ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v3", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v3[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901456333*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"9b6b5b0d-058b-754e-8cc9-b10d9b2d5533"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlv3", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`dlv3[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549014753304`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"28760360-7145-174e-a8d8-1dfd653c01a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectorv3", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectorv3[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549014923306`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"e417bfa2-79fc-e64c-8d75-4f0016f1576d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v4", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v4[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901509329*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"33be8de8-1d10-f14c-9de3-3f0f736fbd44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlv4", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`dlv4[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901526396*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"19febe5c-e98a-5a49-a8f2-6a97028788c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectorv4", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectorv4[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549015467396`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"22c89da2-85b4-954d-a3d5-7193f703b3bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"alpha3", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`alpha3[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901568733*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"f9ca7caa-6437-d448-b2e7-d80529b29406"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlalpha3", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`dlalpha3[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.963954901586092*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"f5f3bdfc-1878-8e43-a604-03a3497ef38e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectoralpha3", "[", "a", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectoralpha3[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549016119614`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"cc4f86ce-2daa-e247-b3e9-79372a42f57a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"f3", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`f3[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549016433735`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"4fef6959-9e98-c74e-9177-3a8714583cd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"dlf3", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`dlf3[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549016728687`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"9b18fe9f-542b-0741-bfe3-f3936e2bd7bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"VariationalVectorf3", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`VariationalVectorf3[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9595064387124023`*^9, 3.959506662005253*^9, 
  3.9606416605668926`*^9, 3.963940719607355*^9, 3.9639408814635925`*^9, 
  3.9639411848496246`*^9, 3.963941408676613*^9, 3.963942051008116*^9, 
  3.9639421855936527`*^9, 3.9639549016979465`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"783fe4b9-6c67-ea40-9608-bc116ef96672"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VertDeg", "[", "v0", "]"}], ",", 
   RowBox[{"VertDeg", "[", "dlv0", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VertDeg", "[", "alpha0", "]"}], ",", 
   RowBox[{"VertDeg", "[", "dlalpha0", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VertDeg", "[", "v1", "]"}], ",", 
   RowBox[{"VertDeg", "[", "dlv1", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VertDeg", "[", "v2", "]"}], ",", 
   RowBox[{"VertDeg", "[", "dlv2", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VertDeg", "[", "alpha3", "]"}], ",", 
   RowBox[{"VertDeg", "[", "dlalpha3", "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VertDeg", "[", "f3", "]"}], ",", 
   RowBox[{"VertDeg", "[", "dlf3", "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{3.9576058342779417`*^9},
 CellLabel->
  "In[178]:=",ExpressionUUID->"5ca2e0db-5c98-404f-9df4-66e64c7d9196"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.957763494346429*^9, 3.9577860012826557`*^9, 
  3.957787662980235*^9, 3.957789629449978*^9, 3.958070708714342*^9, 
  3.9581306433989773`*^9, 3.958216180754511*^9, 3.9595064463805866`*^9, 
  3.959506664721836*^9, 3.9606416608884926`*^9, 3.9639407224224873`*^9, 
  3.9639549041344757`*^9},
 CellLabel->
  "Out[178]=",ExpressionUUID->"9a7f92f4-087f-b546-ba75-1fabb910eaa8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.957763494346429*^9, 3.9577860012826557`*^9, 
  3.957787662980235*^9, 3.957789629449978*^9, 3.958070708714342*^9, 
  3.9581306433989773`*^9, 3.958216180754511*^9, 3.9595064463805866`*^9, 
  3.959506664721836*^9, 3.9606416608884926`*^9, 3.9639407224224873`*^9, 
  3.9639549041570435`*^9},
 CellLabel->
  "Out[179]=",ExpressionUUID->"90206ec7-86bf-7143-96a5-bf89c718521a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{3.957763494346429*^9, 3.9577860012826557`*^9, 
  3.957787662980235*^9, 3.957789629449978*^9, 3.958070708714342*^9, 
  3.9581306433989773`*^9, 3.958216180754511*^9, 3.9595064463805866`*^9, 
  3.959506664721836*^9, 3.9606416608884926`*^9, 3.9639407224224873`*^9, 
  3.9639549041780453`*^9},
 CellLabel->
  "Out[180]=",ExpressionUUID->"169ec3bb-4b35-8a4b-8b61-51dab5691621"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{3.957763494346429*^9, 3.9577860012826557`*^9, 
  3.957787662980235*^9, 3.957789629449978*^9, 3.958070708714342*^9, 
  3.9581306433989773`*^9, 3.958216180754511*^9, 3.9595064463805866`*^9, 
  3.959506664721836*^9, 3.9606416608884926`*^9, 3.9639407224224873`*^9, 
  3.9639549041990585`*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"44a3b061-aa0d-2b46-9009-461bf40c4894"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.957763494346429*^9, 3.9577860012826557`*^9, 
  3.957787662980235*^9, 3.957789629449978*^9, 3.958070708714342*^9, 
  3.9581306433989773`*^9, 3.958216180754511*^9, 3.9595064463805866`*^9, 
  3.959506664721836*^9, 3.9606416608884926`*^9, 3.9639407224224873`*^9, 
  3.963954904221094*^9},
 CellLabel->
  "Out[182]=",ExpressionUUID->"98b508cc-7889-4e44-9d76-712caf2921b0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.957763494346429*^9, 3.9577860012826557`*^9, 
  3.957787662980235*^9, 3.957789629449978*^9, 3.958070708714342*^9, 
  3.9581306433989773`*^9, 3.958216180754511*^9, 3.9595064463805866`*^9, 
  3.959506664721836*^9, 3.9606416608884926`*^9, 3.9639407224224873`*^9, 
  3.9639549042425575`*^9},
 CellLabel->
  "Out[183]=",ExpressionUUID->"d1786286-1a0c-2340-94fa-f8c0dcbe75af"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"ZeroVertDegQ", "[", "expr", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"dd961c80-5574-e14f-91e9-c0bdab1f4858"],
 StyleBox["\n",
  FontSize->3],
 "It returns ",
 Cell[BoxData[
 "True"], "InlineCode",ExpressionUUID->"086470ff-8bbc-4148-8190-8770ace4e0a1"],
 " if the vertical degree of ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"expr", "'"}]}]], "InlineCode",ExpressionUUID->
  "d166686d-7e13-7c46-9276-419167367589"],
 " is zero and ",
 Cell[BoxData[
 "False"], "InlineCode",ExpressionUUID->
  "6ce9e698-529f-264b-90af-e87e2a7cf613"],
 " otherwise.\n\n",
 Cell[BoxData[
  StyleBox[
   RowBox[{"NonZeroVertDegQ", "[", "expr", "]"}],
   FontWeight->"Bold",
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"b9970849-bafb-1f4f-bd13-a0768e4c21ba"],
 StyleBox["\n",
  FontSize->3],
 "It returns ",
 Cell[BoxData[
 "True"], "InlineCode",ExpressionUUID->"4c95c993-e2ac-7c4f-9a5d-566b9721e871"],
 " if the vertical degree of ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"expr", "'"}]}]], "InlineCode",ExpressionUUID->
  "1ff73e1d-1567-5e47-a6bf-867573f7d15f"],
 " is nonzero and ",
 Cell[BoxData[
 "False"], "InlineCode",ExpressionUUID->
  "cbf35d1d-bb7b-1240-8fb9-88ff3656d988"],
 " otherwise."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.9544825530653143`*^9, 3.9544826474431734`*^9}, {
  3.9567432343337803`*^9, 3.9567432870589724`*^9}, {3.957883602030074*^9, 
  3.9578836076113005`*^9}, {3.9578852915178194`*^9, 3.9578852969422646`*^9}, {
  3.9580707242670193`*^9, 3.9580707287252064`*^9}, {3.958080974300783*^9, 
  3.9580809751059303`*^9}},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"5d4bcfb5-894f-6043-8e61-cb5bbac28ecb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ZeroVertDegQ", "[", "3", "]"}], ",", 
   RowBox[{"ZeroVertDegQ", "[", "v0", "]"}], ",", 
   RowBox[{"NonZeroVertDegQ", "[", "3", "]"}], ",", 
   RowBox[{"NonZeroVertDegQ", "[", "v1", "]"}]}], "}"}]], "Input",
 CellLabel->
  "In[184]:=",ExpressionUUID->"37cae758-6877-3948-afc9-b389f560ec5b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.9577634943543997`*^9, 3.9577860013121233`*^9, 
  3.9577876633602924`*^9, 3.9577896295501657`*^9, 3.9580707471346664`*^9, 
  3.9581306458259544`*^9, 3.9582161834461365`*^9, 3.9595064492033386`*^9, 
  3.9595066669146347`*^9, 3.960641660983614*^9, 3.963940724607935*^9, 
  3.963954907344801*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"514eb121-2f10-414c-be6f-03854feee7a3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". VertExactHeadQ"
}], "Subsection",
 CellChangeTimes->{{3.932470606888551*^9, 3.932470617022765*^9}, {
   3.948667242696788*^9, 3.948667270545931*^9}, 3.948667366507654*^9, {
   3.9488313594522657`*^9, 3.948831367669508*^9}, {3.949497878899983*^9, 
   3.949497880025175*^9}, {3.9497762142304535`*^9, 3.9497762172243004`*^9}, 
   3.9497771466764545`*^9},ExpressionUUID->"20a6054e-324b-2049-8ea6-\
6fd3384aee5c"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{"VertExactHeadQ", 
    RowBox[{"\.08", "[", "HeadOfTensor", "]"}]}],
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",
  FontWeight->"Bold",ExpressionUUID->"4cf6f776-3675-c745-b962-13367742ce69"],
 StyleBox["\n",
  FontSize->3],
 "It returns ",
 Cell[BoxData[
 "True"], "InlineCode",ExpressionUUID->"33773493-81a7-d444-a7ba-fa910fa45bf1"],
 " if ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"HeadOfTensor", "'"}]}]], "InlineCode",ExpressionUUID->
  "afd6d86d-9282-c74e-a151-22914d98606d"],
 " has been defined as the exterior derivative of another tensor, and ",
 Cell[BoxData[
 "False"], "InlineCode",ExpressionUUID->
  "95d14c58-2af2-a14c-bac2-87eb0ce1b784"],
 " otherwise."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{{3.9523844153599873`*^9, 3.952384431093433*^9}, {
   3.9523844643921423`*^9, 3.9523844693956146`*^9}, 3.953090384833626*^9, 
   3.9545064311173787`*^9, {3.9553662251374736`*^9, 3.9553662362323823`*^9}, {
   3.9559486400725*^9, 3.955948667756747*^9}, {3.956916435922823*^9, 
   3.9569164668931227`*^9}, 3.9578831208929424`*^9, 3.9578832516189303`*^9, 
   3.9578836145083194`*^9, {3.9578853019204445`*^9, 3.957885305462203*^9}, {
   3.958070749624441*^9, 3.958070776621355*^9}, {3.95808097783374*^9, 
   3.9580809783637047`*^9}},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"bc53beef-c5fb-3f4c-ae52-d763bfba3c35"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"VertExactHeadQ", "[", "dlv1", "]"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VertExactHeadQ", "[", "v1", "]"}], " "}]}], "Input",
 CellChangeTimes->{3.9604401695500164`*^9},
 CellLabel->
  "In[185]:=",ExpressionUUID->"0a13d776-9b23-5241-826b-24f47bff0d83"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9577634960646324`*^9, 3.9577860013217697`*^9, 
  3.9577876634833183`*^9, 3.957789629590059*^9, 3.9580708136912136`*^9, 
  3.958130651403429*^9, 3.95821618937879*^9, 3.9595066719797554`*^9, 
  3.9606416610154305`*^9, 3.9639407278394947`*^9, 3.963954915272375*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"750716f3-f494-c042-9a01-cd0c85227e00"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9577634960646324`*^9, 3.9577860013217697`*^9, 
  3.9577876634833183`*^9, 3.957789629590059*^9, 3.9580708136912136`*^9, 
  3.958130651403429*^9, 3.95821618937879*^9, 3.9595066719797554`*^9, 
  3.9606416610154305`*^9, 3.9639407278394947`*^9, 3.9639549152979736`*^9},
 CellLabel->
  "Out[186]=",ExpressionUUID->"0b838793-392a-524d-be5d-24b95c5b0e92"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 
 CounterBox["Chapter"],
 ".",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["Subsection"],
 ". Tensors and WWedge"
}], "Subsection",
 CellChangeTimes->{{3.932470606888551*^9, 3.932470617022765*^9}, {
   3.948667234179401*^9, 3.94866723434372*^9}, 3.9486673637970796`*^9, {
   3.9488291490634766`*^9, 3.9488291522954645`*^9}, {3.94882928717527*^9, 
   3.948829289098152*^9}},ExpressionUUID->"2a36a80b-247c-7f4b-968f-\
daeb3dc1abdc"],

Cell[TextData[{
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   StyleBox[
    RowBox[{"WWedge", "[", 
     RowBox[{"expr1", ",", " ", "expr2"}], "]"}],
    FontWeight->"Bold",
    FontColor->RGBColor[
     0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
   "InlineCode",ExpressionUUID->"7659b466-6909-7140-b86e-3610ba81d08f"]], 
   "InlineCode",ExpressionUUID->"839387b5-2099-ea4a-989e-5a41b1cfc2d9"]], 
  "InlineCode",ExpressionUUID->"e48e5d36-0682-5240-99bb-9357e351c61d"],
 StyleBox["\n",
  FontSize->3],
 "This function represents the vertical exterior product between two elements \
",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"expr1", "'"}]}]], "InlineCode",ExpressionUUID->
  "00c1dabe-5999-cf48-bdfc-065151a17d48"],
 " and ",
 Cell[BoxData[
  RowBox[{"'", 
   RowBox[{"expr2", "'"}]}]], "InlineCode",ExpressionUUID->
  "0b4019da-df6c-eb41-99de-584647e80e4d"],
 "."
}], "Text",
 CellFrame->{{1, 1}, {1, 1}},
 CellChangeTimes->{
  3.952518011698474*^9, {3.9525181528501234`*^9, 3.9525181699010754`*^9}, 
   3.954506528836262*^9, {3.9546662262590413`*^9, 3.9546662608975797`*^9}, {
   3.9553662448783245`*^9, 3.9553662505117745`*^9}, {3.95674311669246*^9, 
   3.9567431235504074`*^9}, {3.95788531028329*^9, 3.9578853165715003`*^9}, {
   3.958070817122677*^9, 3.958070830394697*^9}, 3.9580809818988247`*^9},
 Background->RGBColor[
  1, 0.882353, 
   0.823529],ExpressionUUID->"71acb0ba-09af-e24b-91a6-f24199ef3076"],

Cell[TextData[{
 "For the ",
 Cell[BoxData[
 "WWedge"], "InlineCode",ExpressionUUID->
  "bf9c7bde-9738-3642-aed0-36cbe8fc3e10"],
 ", we can use the function ",
 Cell[BoxData[
  StyleBox[Cell[TextData[Cell[BoxData[Cell[TextData[Cell[BoxData[
     StyleBox[
      RowBox[{"WWedge", "[", 
       RowBox[{"expr1", ",", " ", "expr2"}], "]"}],
      FontColor->RGBColor[0., 0., 0.]]], "InlineCode",ExpressionUUID->
     "15c9e885-bed5-3744-a7fe-b59313ffb111"]], "InlineCode",ExpressionUUID->
     "2ae78fc5-9c88-4f45-ad41-5a6802971542"]], "InlineCode",ExpressionUUID->
    "0eea7d87-bdbc-3f4d-8087-439fd22b945f"]], "InlineCode",ExpressionUUID->
    "a546faa8-7cd3-704f-bf69-1a4a3b0a2ee3"],
   FontColor->RGBColor[
    0.5019607843137255, 0.5019607843137255, 0.5019607843137255]]], 
  "InlineCode",ExpressionUUID->"1580745c-72ae-c44a-bfe3-66bd7df24b28"],
 ", the inline notation ",
 Cell[BoxData[
  RowBox[{"expr1", "~", "WWedge", "~", "expr2"}]], "InlineCode",
  ExpressionUUID->"22b87dd6-253c-894d-a874-b846478c259b"],
 ", or infix symbol \:2a55 (Unicode symbol U+2A55, which can be obtained with \
\[EscapeKey]+ww+\[EscapeKey]). In all cases, the output shows the infix \
symbol \:2a55."
}], "Text",
 CellChangeTimes->{{3.952384546421236*^9, 3.952384620161078*^9}, {
  3.9525179166746073`*^9, 3.952517924412033*^9}, {3.955366261741904*^9, 
  3.9553662626697907`*^9}, {3.9578300028188953`*^9, 3.9578300207324066`*^9}, {
  3.9579610403403673`*^9, 3.957961062272654*^9}, {3.9580430222095337`*^9, 
  3.958043061855028*^9}, {3.958043118374052*^9, 3.9580431294458485`*^9}, {
  3.9580708506845703`*^9, 3.9580708506845703`*^9}, {3.9581306588158607`*^9, 
  3.958130660511957*^9}, {3.96393533513484*^9, 3.96393536666679*^9}, {
  3.963935416966223*^9, 3.9639354833661404`*^9}, {3.963954928722784*^9, 
  3.9639549700549736`*^9}},ExpressionUUID->"4ce3323e-884d-104a-bed1-\
2eea4ede1a3c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", "16^^2A55", "]"}]], "Input",
 CellChangeTimes->{{3.963935418045103*^9, 3.9639354180500603`*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"5909eea4-be7a-cd4c-b214-66dec88bad9c"],

Cell[BoxData["\<\"\:2a55\"\>"], "Output",
 CellChangeTimes->{3.963935420168951*^9, 3.9639407368045044`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"09580ae8-bea0-4744-9f70-dd4ee0543a4a"]
}, Open  ]],

Cell["\<\
When there is at most one non-zero-VertDeg tensor, it reduces to the usual \
product (Times)\
\>", "Text",
 CellChangeTimes->{{3.952384546421236*^9, 3.952384620161078*^9}, {
  3.9525179166746073`*^9, 3.952517924412033*^9}, {3.955366261741904*^9, 
  3.9553662626697907`*^9}, {3.9578300028188953`*^9, 3.9578300207324066`*^9}, {
  3.9579610403403673`*^9, 3.957961062272654*^9}, {3.9580430222095337`*^9, 
  3.958043061855028*^9}, {3.958043118374052*^9, 3.9580431294458485`*^9}, {
  3.9580708506845703`*^9, 3.9580708506845703`*^9}, {3.9581306588158607`*^9, 
  3.958130660511957*^9}, {3.96393533513484*^9, 3.96393536666679*^9}, {
  3.963935416966223*^9, 
  3.963935492282776*^9}},ExpressionUUID->"254d9774-8117-6d46-8a22-\
8db4011193e4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"2", " ", "\:2a55", " ", "3", "\:2a55", " ", "4"}], "\[IndentingNewLine]", 
 RowBox[{"2", "\:2a55", " ", "3", "\:2a55", " ", 
  RowBox[{"v0", "[", "a", "]"}], "\:2a55", 
  RowBox[{"(", 
   RowBox[{"-", "1"}], ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v0", "[", "a", "]"}], "\:2a55", " ", 
  RowBox[{"tensor", "[", 
   RowBox[{"b", ",", "c"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"2", 
  RowBox[{"v0", "[", "a", "]"}], "\:2a55", " ", 
  RowBox[{"v1", "[", "b", "]"}]}]}], "Input",
 CellChangeTimes->{{3.963935496652527*^9, 3.9639355112829723`*^9}, {
  3.9639407466796856`*^9, 3.963940748926571*^9}},
 CellLabel->
  "In[187]:=",ExpressionUUID->"915ca8fc-c1b5-fa41-9953-8e57475a1b9b"],

Cell[BoxData["24"], "Output",
 CellChangeTimes->{
  3.9577634982928123`*^9, 3.957786001337162*^9, 3.9577876636418233`*^9, 
   3.9577896296443424`*^9, 3.9580708639900208`*^9, 3.9581306680835266`*^9, 
   3.9582161938504353`*^9, 3.9595066864395256`*^9, 3.9606416610791225`*^9, 
   3.9639407386235065`*^9, {3.963940873810993*^9, 3.963940890586685*^9}, 
   3.963954990214716*^9},
 CellLabel->
  "Out[187]=",ExpressionUUID->"5306f847-8337-f841-877c-3a3d418799c7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "6"}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v0", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v0[$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.9577634982928123`*^9, 3.957786001337162*^9, 3.9577876636418233`*^9, 
   3.9577896296443424`*^9, 3.9580708639900208`*^9, 3.9581306680835266`*^9, 
   3.9582161938504353`*^9, 3.9595066864395256`*^9, 3.9606416610791225`*^9, 
   3.9639407386235065`*^9, {3.963940873810993*^9, 3.963940890586685*^9}, 
   3.9639549902957287`*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"07a567b5-2f84-744c-923e-73a2067e4213"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       UnderscriptBox[
        RowBox[{"(", 
         TemplateBox[<|"boxes" -> FormBox[
             StyleBox["T", "TI"], TraditionalForm], "errors" -> {}, "input" -> 
           "T", "state" -> "Boxes"|>,
          "TeXAssistantTemplate"], ")"}], 
        UnderscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]], 
       StyleBox[GridBox[{
          {"b", "c"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`tensor[$CellContext`b, $CellContext`c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v0", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v0[$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.9577634982928123`*^9, 3.957786001337162*^9, 3.9577876636418233`*^9, 
   3.9577896296443424`*^9, 3.9580708639900208`*^9, 3.9581306680835266`*^9, 
   3.9582161938504353`*^9, 3.9595066864395256`*^9, 3.9606416610791225`*^9, 
   3.9639407386235065`*^9, {3.963940873810993*^9, 3.963940890586685*^9}, 
   3.963954990381794*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"b39139bf-83fe-9548-bbd5-a6c55ae93e5f"],

Cell[BoxData[
 RowBox[{"2", " ", "\:2a55", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v0", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v0[$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v1", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v1[$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.9577634982928123`*^9, 3.957786001337162*^9, 3.9577876636418233`*^9, 
   3.9577896296443424`*^9, 3.9580708639900208`*^9, 3.9581306680835266`*^9, 
   3.9582161938504353`*^9, 3.9595066864395256`*^9, 3.9606416610791225`*^9, 
   3.9639407386235065`*^9, {3.963940873810993*^9, 3.963940890586685*^9}, 
   3.96395499045784*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"09f5f83f-9e43-8c4a-8d50-2e45fcddf46a"]
}, Open  ]],

Cell[TextData[{
 "while for several non-zero-",
 Cell[BoxData[
 "VertDeg"], "InlineCode",ExpressionUUID->
  "6225835e-caef-4443-aeb8-122ed751f713"],
 ":"
}], "Text",
 CellChangeTimes->{{3.952384636776558*^9, 3.9523846416583385`*^9}, 
   3.9573455521539774`*^9, {3.9580430845901127`*^9, 
   3.958043111015913*^9}},ExpressionUUID->"15256277-8179-1d40-a5c8-\
43e8ed3d1d70"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "[", "a", "]"}], "\:2a55", " ", 
  RowBox[{"v2", "[", "b", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v1", "[", "a", "]"}], "~", "WWedge", "~", 
  RowBox[{"f3", "[", "]"}]}]}], "Input",
 CellChangeTimes->{{3.958070872068571*^9, 3.958070873779917*^9}, {
  3.963935514890976*^9, 3.9639355157818146`*^9}},
 CellLabel->
  "In[191]:=",ExpressionUUID->"a7a79ec3-d9a0-7346-9ca7-670717f22d7b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"v1", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v1[$CellContext`a],
     Editable->False], "\:2a55", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v2", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v2[$CellContext`b],
     Editable->False]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCPS`WWedge[
   $CellContext`v1[$CellContext`a], 
   $CellContext`v2[$CellContext`b]],
  Editable->False]], "Output",
 CellChangeTimes->{3.957763498572065*^9, 3.957786001532665*^9, 
  3.9577876643416777`*^9, 3.957789629834139*^9, 3.9580708745058727`*^9, 
  3.9581306700106773`*^9, 3.9582161961347466`*^9, 3.9595066903587666`*^9, 
  3.9606416612385178`*^9, 3.9639408996465893`*^9, 3.963954997999895*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"211a0142-f7c7-f74f-b0c5-0465432ce91e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"v1", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v1[$CellContext`a],
     Editable->False], "\:2a55", 
    InterpretationBox[
     StyleBox["F",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`f3[],
     Editable->False]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCPS`WWedge[
   $CellContext`v1[$CellContext`a], 
   $CellContext`f3[]],
  Editable->False]], "Output",
 CellChangeTimes->{3.957763498572065*^9, 3.957786001532665*^9, 
  3.9577876643416777`*^9, 3.957789629834139*^9, 3.9580708745058727`*^9, 
  3.9581306700106773`*^9, 3.9582161961347466`*^9, 3.9595066903587666`*^9, 
  3.9606416612385178`*^9, 3.9639408996465893`*^9, 3.9639549980905685`*^9},
 CellLabel->
  "Out[192]=",ExpressionUUID->"e5924b2c-95a7-d04f-bf1d-b3930ef5090c"]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
 "WWedge"], "InlineCode",ExpressionUUID->
  "023ae13f-eff6-3445-82ad-116b4f3f8322"],
 " is necessary when multiplying two or more non-zero-",
 Cell[BoxData[
 "VertDeg"], "InlineCode",ExpressionUUID->
  "42ec30ac-5a5a-d544-a395-b8fe81c15374"],
 " expressions:"
}], "Text",
 CellChangeTimes->{
  3.932718933489032*^9, {3.9332338597703476`*^9, 3.933233861595203*^9}, {
   3.933233891692375*^9, 3.933233899119556*^9}, {3.933747727840595*^9, 
   3.933747753307183*^9}, {3.933747807774614*^9, 3.933747877454398*^9}, {
   3.948546391568434*^9, 3.948546414501686*^9}, {3.948727617314596*^9, 
   3.948727626248996*^9}, {3.949772190619917*^9, 3.9497722524752617`*^9}, 
   3.9497730843326473`*^9, {3.9