Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xCoba",
 FontColor->RGBColor[
  1, 0, 0]]], "Title",ExpressionUUID->"3ff08309-41be-43e1-b9d9-bdd096da153b"],

Cell[TextData[StyleBox["General tensor component computations",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subtitle",ExpressionUUID->"cc5ce1d9-da69-47d9-9bff-111efd556aa9"],

Cell[TextData[{
 StyleBox["David Yllanes, ",
  FontSize->18],
 "yllanes@xact.es",
 StyleBox["\n\nJos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a, ",
  FontSize->18],
 "jose@xact.es\n\n(c) 2005-2026, under GPL\n\nhttp://www.xact.es/\n\
http://groups.google.com/group/xAct\n\nWe thank Alfonso \
Garc\[IAcute]a-Parrado for much help."
}], "Subsubtitle",ExpressionUUID->"d96df424-b82e-43f7-ab94-7dec1f712f37"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["0. Info and copyright",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"93c7edf3-70d2-44d7-abf4-6618d4d7f446"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}],
    "*", " ", "0.", " ", "Info", " ", "and", " ", 
   RowBox[{"copyright", " ", "**", "**", "**"}]}], 
  "*****************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1faec8f3-04d9-44a7-a477-8dcb8f460dc0"],

Cell[CellGroupData[{

Cell[BoxData["Today"], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"b5ddec7a-64da-4aae-87c5-54bb12181e17"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Sun 28 Dec 2025\""}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{"2025", ",", "12", ",", "28"}], "}"}], ",", "\"Day\""}], 
     "]"}]},
  "DateObject",
  Editable->False]], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"446384c0-c799-495e-9b62-262532f8bf52"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xCoba`$Version", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<0.8.6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[2]:=",ExpressionUUID->"4dbbf8cd-f6fd-4fdf-a4bc-5eef29ee363a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0.8.6\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",ExpressionUUID->"14efa6de-4dab-4514-a845-4a858959e2c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xCoba`$xTensorVersionExpected", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<1.1.5\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[3]:=",ExpressionUUID->"b3101005-e247-4e8c-a534-803b3121a3cb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1.1.5\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",ExpressionUUID->"cf6faca0-948b-4951-943a-1e760d8936c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$SessionID"], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"1f38b915-a25c-433a-8158-664392b4b7c5"],

Cell[BoxData["23259881541463342481"], "Output",
 CellLabel->"Out[4]=",ExpressionUUID->"a5ed0736-8dda-47ed-804b-c636b18deade"]
}, Open  ]],

Cell[CellGroupData[{

Cell["0.0. Comments", \
"Subsection",ExpressionUUID->"8080b42e-c1d3-441b-826a-633fdb5fe1fc"],

Cell[CellGroupData[{

Cell["0.0.1. TODO list", \
"Subsubsection",ExpressionUUID->"70308add-20c5-470a-9455-33406336f807"],

Cell["\<\
Old list:
- When undefining a basis we are not removing the associated metric \
definitions. Is this still true?
- How do densities and weights behave under complex conjugation?
- All and IndexOnQ, etc.\
\>", "Text",ExpressionUUID->"e1181a9b-3839-49fc-9cd7-bb1dd10aaede"],

Cell["\<\
Future plans:

- Changes of chart. This needs a design for DefMapping-related functionality \
in xTensor, and analyzing how it relates to InChart.

- More metric-related functionality:
\t- Petrov/Segre report.
\t- Compute Killing fields.
\t- See other component packages to see what they can do.

- ConnectionCompute, like MetricCompute but for general connections.

- Handle induced metrics. No idea how yet.

- Generalize CTensor to contain tensor elements. This includes handling \
tensors by blocks, and is related to the Projector work with Guillaume in \
xTensor.

- Use of SymmetrizedArray as first argument of CTensor to handle symmetry \
more efficiently. In particular, this should be the way to work with \
differential forms by components.

- Can we do inner-vbundle computations? What about algebras? Can we link to \
the AVF functionality?

- How can CTensor be used by other packages? For example xPert.\
\>", "Text",ExpressionUUID->"ce5dd293-177d-4f19-880f-dc4d27821837"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.0.2. Abstract vs component computations", \
"Subsubsection",ExpressionUUID->"83582f78-636d-4d2d-988f-4ec5926ad3a9"],

Cell[TextData[{
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " is the ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " package for tensor component calculations. By this we mean anything which \
requires the use of a basis (or \[OpenCurlyDoubleQuote]frame\
\[CloseCurlyDoubleQuote]) of vector fields or a chart on a manifold. Those \
two concepts (basis and chart) are already present in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " as symbol types, but they get their actual mathematical meaning here. They \
are quite unrelated, although every chart has an associated (\
\[OpenCurlyDoubleQuote]coordinated\[CloseCurlyDoubleQuote]) basis (not \
viceversa), and hence ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " has two main parts dealing respectively with bases first and then charts.\n\
\nOur main objective is allowing simultaneous interaction of the user with ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " and ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ", explicitly avoiding an abrupt and irreversible change when passing from \
the abstract world of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " to the component world of ",
 Cell[BoxData[
  FormBox[
   StyleBox["xCoba",
    FontSlant->"Italic"], TraditionalForm]],ExpressionUUID->
  "d9e6199a-8f18-425f-84e8-46feff49a927"],
 ", as often happens in other tensor packages. This is achieved essentially \
through two ideas: first, the use of a different type of indices (",
 StyleBox["marked",
  FontSlant->"Italic"],
 " indices), and secondly a clean separation (already present at the level of \
",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", but most relevant here",
 StyleBox[") ",
  FontSlant->"Italic"],
 "of the concepts of scalar field and function of coordinates."
}], "Text",ExpressionUUID->"ce680711-1693-4a65-9606-851f18443c7e"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.0.3. Notations", \
"Subsubsection",ExpressionUUID->"bda2485d-009a-4834-902a-f7422ce95b95"],

Cell[TextData[{
 "The most difficult part of ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " is introducing a good notation. This is because we need to manipulate \
objects which are both components of a tensor in one or several bases and \
functions of the coordinates of a chart, and so we must store the information \
of the bases, component numbers, chart and coordinate names somewhere in the \
expression. Most other tensor component packages work under the assumption \
that there is a single chart and its associated basis, but we want to go much \
further than that. Hence, the notation must be flexible enough without \
getting too complicated.\n\nAnother complicated issue is how to store the \
information of the components. In ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " it is very natural to use a declarative approach that stores the \
information internally, using upvalues. We have tried to follow that approach \
as well in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ", but the results are not good, because users typically do not know how to \
manipulate the components, that they expect in the form of an array. In \
version 0.8.0 we have introduced a fully explicit approach, and we hope this \
will be easier to use."
}], "Text",ExpressionUUID->"6feb0296-dd49-46a8-942d-dd5ce09fc37d"],

Cell[TextData[{
 "In ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " we already need to handle the tensor heads T and the indexed tensor \
T[a,-b]. We can form linear combinations and products of indexed tensors, but \
there is not yet an index-free language allowing combinations of tensor \
heads. In ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " we still have the duality between tensor heads and indexed tensors, but \
now we need to associate component values to them in some bases. There are \
three possibilities:\n\n\t1) linear combinations (only possible in the \
indexed form): v[a] = 3 Basis[{1, -B}, a] -2 Basis[{2, -B}, a]\n\t\n\t2) \
implicit values: TensorValues[v, {B}] = {v[{1, B}] -> 3, v[{2, B}] -> -2}\n\t\
\n\t3) explicit values: v = CTensor[ { 3, -2 }, {B} ]\n\nWe need functions \
able to take indexed expressions and functions able to take index-free tensor \
heads. The must return the corresponding object in the same notation. For \
example suppose we have values for a metric g, in any of those three forms, \
and we want to compute the inverse metric.\n\n\t1) Computations in this \
notations are awkward because we need to provide indices for the result and \
the indices of the input are irrelevant (ultraindices). \n\n\t2) If g has \
implicit values then InverseMetric[g] should return the name of the inverse \
metric of g, and in the process discover that the components are known and \
hence compute (and store internally) the corresponding components of the new \
tensor.\n\t\n\t3) InverseMetric[ CTensor[garray, {-B, -B}] ] should return \
another CTensor object corresponding to the inverse of the metric given.\n\n\
Note that in 2) and 3) we necessarily have basis information with which to \
compute the components, but not necessarily in 1), which makes computations \
in 1) even more awkward. Therefore, for the moment we abandon the idea of \
getting 1) working soon, and focus on making 2) and 3) work."
}], "Text",ExpressionUUID->"ebe7a4f5-8c1b-467a-94ad-2c53e6c57914"],

Cell["\<\
In principle we shall use several coordinate systems (charts) and/or frames \
(bases). Our notation must be able to represent a given abstract expression \
in one of those frames, and we need a simple way to change the basis that we \
are using. Note that a change of coordinate system involves three different \
changes:
\t- we need to change the objects associated to the basis (parallel \
derivative, jacobians, densities, eta tensors),
\t- we need to change the components of the tensors,
\t- we need to change the values of the coordinates of the point where the \
expression is evaluated.\
\>", "Text",ExpressionUUID->"f4a5242a-119a-4894-8d52-880e945177d1"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.0.4. Types of computations", \
"Subsubsection",ExpressionUUID->"78bf9482-182f-4bac-b1b9-430ebdded5eb"],

Cell["\<\
Given a generic tensorial field expression, there are three basic different \
things that we usually want to do with it, in this order:

1. Decompose the tensorial field expression in a given basis of vector \
fields. We must supply a basis at this step. We get the same expression \
decomposed as a sum of basis vector/covector fields multiplied by scalar \
fields that we call components of the original expression in the given basis. \
Here we need four commands:
\t- ContractBasis[expr, indices], which explicitly multiply tensors by Basis \
objects removing dummy (either abstract or basis) indices. Basis objects \
dissapear.
\t- SeparateBasis[basis][expr, indices], an inverse of the latter, which \
separates the indices of a tensor into products of the tensor and the Basis \
objects. New dummy indices must be introduced (either abstract or basis) and \
Basis objects appear.
\t- TraceBasisDummy[expr, indices], which expands basis indices into ranges \
of component indices.
\t- ToBasis[basis][expr, indices], which converst the given indices of the \
expression in indices in the given basis (or AIndex).

2. Express all scalar fields as functions of coordinate fields. We must \
supply a chart at this step. It is very important to note the different \
meanings of a scalar field and the function (scalar function) that expresses \
it in a coordinate chart, and the difference between the differential \
operators acting on the scalars and the partial derivatives of those \
representation functions (`first fundamental confusion of calculus\.b4 of \
Woodhouse).
\t- InChart[scalar, chart], which represents a scalar-function and that can \
be defined in terms of other objects by the user. If there is no such \
definition, then InChart is more a data type than a command. InChart needs to \
know what to do with compound (sums or products) expressions. If InChart is \
applied on a non-scalar expression then SeparateBasis is first called with \
the basis associated to the chart, and then InChart is mapped onto the scalar \
components.

3. Restrict fields to points. Until now everything is a field on a manifold, \
or a function of a parameter. However we also need to restrict fields and \
parameter-functions to points.
\t- At[expr, point], a new field which represents expr restricted to the \
point. It is a projector operation. Currently this is not implemented, and \
actually we should be able to implement this also using InChart.\
\>", "Text",ExpressionUUID->"f6d2109e-0ab0-4b55-91bc-465f90ea30f2"],

Cell["\<\
Then, using those basic actions, the main thing we want to do is to compute \
tensors from other tensors, in particular all curvature tensors from the \
specification of a metric in a coordinate system.\
\>", "Text",ExpressionUUID->"723b75ef-a131-430f-9dd3-f4e292fdaa9c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "0.0.5. Another view on the relation of ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " with ",
 StyleBox["xTensor",
  FontSlant->"Italic"]
}], "Subsubsection",ExpressionUUID->"bd52f991-c2de-4857-ad89-2df651ca8034"],

Cell[TextData[{
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " reproduces the structures in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " in a form that makes it easier to compute with objects formed by \
combination of other objects. In xTensor every object has its own identity, \
say a tensor T[a, -b]. But in xCoba a tensor is a linear combination of the \
elements of a basis. So we need two steps: first we have a declarative step \
to define a basis in abstract form, DefBasis, and then we need to represent \
the tensor as a combination of its elements, CTensor. The C of CTensor stands \
for \[OpenCurlyDoubleQuote]Component\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]Combination\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]Change\[CloseCurlyDoubleQuote] (or \
\[OpenCurlyDoubleQuote]xCoba\[CloseCurlyDoubleQuote]).\n\nThe following table \
describes the correspondences:"
}], "Text",ExpressionUUID->"e28ba3b7-0333-472f-b9b7-94141af44eb8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<DefManifold\>\"", ",", "\"\<DefChart\>\"", ",", 
       " ", "\"\<(CChart)\>\""}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<DefVBundle\>\"", ",", "\"\<DefBasis\>\"", ",", 
       " ", "\"\<(CBasis)\>\""}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<DefTensor\>\"", ",", "\"\<TensorValues\>\"", 
       ",", "\"\<CTensor\>\""}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<DefCovD\>\"", ",", "\"\<-\>\"", ",", "\"\<CCovD\>\""}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<DefMapping\>\"", ",", "\"\<-\>\"", 
       ",", "\"\<CMapping\>\""}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Abstract xTensor\>\"", ",", "\"\<Abstract xCoba\>\"", ",",
         " ", "\"\<Component xCoba\>\""}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"78048a76-24d6-482c-8003-280d4a8e1011"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox["\<\"Abstract xTensor\"\>",
       HoldForm], 
      TagBox["\<\"Abstract xCoba\"\>",
       HoldForm], 
      TagBox["\<\"Component xCoba\"\>",
       HoldForm]},
     {"\<\"DefManifold\"\>", "\<\"DefChart\"\>", "\<\"(CChart)\"\>"},
     {"\<\"DefVBundle\"\>", "\<\"DefBasis\"\>", "\<\"(CBasis)\"\>"},
     {"\<\"DefTensor\"\>", "\<\"TensorValues\"\>", "\<\"CTensor\"\>"},
     {"\<\"DefCovD\"\>", "\<\"-\"\>", "\<\"CCovD\"\>"},
     {"\<\"DefMapping\"\>", "\<\"-\"\>", "\<\"CMapping\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {None, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     None, {"Abstract xTensor", "Abstract xCoba", "Component xCoba"}}, 
    TableAlignments -> 
    Center]]]], \
"Output",ExpressionUUID->"c0e9d975-b18d-465f-8612-0d5216731127"]
}, Open  ]],

Cell[TextData[{
 "*  Eventually it might make sense to have a CBasis[ basis, matrix ] or a \
CChart[ chart, transition ], but we do not need them currently.\n\n* \
TensorValues is an attempt to handle components trying to keep the use of \
abstract tensors, such that information of components is attached to the \
symbols of those abstract tensors. This has ended up being difficult to use, \
so there are no plans to extend it in the future. In particular we will not \
develop anything similar to TensorValues for covds and mappings.\n\n* Then \
there is DefMetric in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". It is actually a bad name, because it is really an interface to \
DefTensor/DefCovD, used to prepare a network of relations among many objects \
associated to the metric. Probably it should have been SetMetric. Its \
equivalent in xCoba is a combination of SetCMetric, MetricInBasis and \
MetricCompute.\n\n* The other types in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", namely constant-symbols, inert-heads, parameters and scalar-functions, do \
not need equivalent forms in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"58bc1f4d-cc85-4874-bf85-5f2507fe166c"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["0.1. GPL", \
"Subsection",ExpressionUUID->"f494a54d-9727-4b8c-90e5-080eb3758b0a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xCoba", ",", " ", 
    RowBox[{
    "a", " ", "free", " ", "package", " ", "for", " ", "tensor", " ", 
     "component", " ", "computations", " ", "in", " ", "Mathematica"}]}], " ",
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Copyright", " ", 
     RowBox[{"(", "C", ")"}], " ", "2005"}], "-", 
    RowBox[{"2026", " ", "David", " ", "Yllanes", " ", "and", " ", "Jose", " ", 
     RowBox[{"M", ".", " ", "Martin"}]}], "-", "Garcia"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", "\[IndentingNewLine]", " ", 
      "it", " ", "under", " ", "the", " ", "terms", " ", "of", " ", "the", " ",
       "GNU", " ", "General", " ", "Public", " ", "License", " ", "as", " ", 
      "published", "\[IndentingNewLine]", " ", "by", " ", "the", " ", "Free", 
      " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], " ",
      "program", " ", "is", " ", "distributed", " ", "in", " ", "the", " ", 
     "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", "useful"}], 
    ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", " ", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", "\[IndentingNewLine]",
       " ", "General", " ", "Public", " ", "License", " ", "for", " ", "more",
       " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], " ",
       "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ", 
      "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", "\[IndentingNewLine]", " ", "along", " ", "with", " ", 
      "this", " ", "program"}], ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", "\[IndentingNewLine]",
      " ", "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[5]:=",ExpressionUUID->"86123a35-e343-457c-912c-2033c287e0c0"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.2. Info package", \
"Subsection",ExpressionUUID->"efd65cb7-7b2c-40fb-b219-52233051f253"],

Cell["\<\
(* :Title: xCoba *)

(* :Author: David Yllanes and Jose M. Martin-Garcia *)

(* :Summary: Free package for tensor component computations *)

(* :Brief Discussion:
     - Component computations based on the abstract tools provided by \
xTensor.
     - Basis indices are denoted by {a, basis} or {-a, -basis}.
     - Component indices are denoted by {1, basis} or {1, -basis}.
     - The link between the abstract and the component world is given by
       Basis[a, {-b, -basis}], the basis vectors.
     - There are functions to manipulate Basis objects and the associated
       component scalars.
     - There are functions to store values for components.
     - There is limited support to work with charts.
*)
  
(* :Context: xAct`xCoba` *)

(* :Package Version: 0.8.6 *)

(* :Copyright: David Yllanes and Jose M. Martin-Garcia (2005-2026) *)

(* :History: see xCoba.History file *)

(* :Keywords: *)

(* :Source: xCoba.nb *)

(* :Warning: Still experimental! *)

(* :Mathematica Version: 6.0 and later *)

(* :Limitations: Not few *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->
  True,ExpressionUUID->"ebb23f24-c841-4c08-aaf0-05128f52507e"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1. Begin package",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"86ea31a4-ae15-4d8f-a574-1d17bea739b8"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}],
    "*", " ", "1.", " ", "Begin", " ", "package"}], " ", 
  "***********************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2ed65be9-a043-4df9-acaf-81ea66a28a7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"b649aa60-5373-403b-9b7f-ef054f8138be"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.799019`", ",", "41.169403`8.066119562808606", ",", 
   "0.06798856520286914`"}], "}"}]], "Output",
 CellLabel->"Out[6]=",ExpressionUUID->"1f5f61a7-e214-4e3a-9797-19e48a35587e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.1. BeginPackage", \
"Subsection",ExpressionUUID->"5538a8f8-44a6-43a7-9cad-023f7f97de05"],

Cell["Protect against multiple loading of the package:", \
"Text",ExpressionUUID->"18bc1c0a-8aa7-4e4d-8b3c-111ba6fff9d4"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xAct`xCoba`Private`xCobaSymbols", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Names", "[", "\"\<xAct`xCoba`*\>\"", "]"}], ",", 
         RowBox[{"Names", "[", "\"\<xAct`xCoba`Private`*\>\"", "]"}]}], "]"}],
        ",", 
       RowBox[{"\"\<$Version\>\"", "|", "\"\<xAct`xCoba`$Version\>\"", 
        "|", "\"\<$xTensorVersionExpected\>\"", 
        "|", "\"\<xAct`xCoba`$xTensorVersionExpected\>\""}]}], "]"}]}], "}"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "/@", "xAct`xCoba`Private`xCobaSymbols"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Clear", "/@", "xAct`xCoba`Private`xCobaSymbols"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[7]:=",ExpressionUUID->"21620263-aa07-491b-bd9a-da9ad1e03b64"],

Cell["Decide which package is the last being read:", \
"Text",ExpressionUUID->"26b0090a-d59f-498d-b0ea-757d4490f3ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{"xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`xCoba`\>\""}]}],
    "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[8]:=",ExpressionUUID->"e8c3ef25-e5f6-4970-8250-efdffacdf46d"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"c5c0a386-c5c7-46f6-992e-f74b144ecd28"],

Cell[BoxData["\<\"xAct`xCoba`\"\>"], "Output",
 CellLabel->"Out[9]=",ExpressionUUID->"8450087f-cb32-4b4e-a2da-583c551f2929"]
}, Open  ]],

Cell["Import other packages:", \
"Text",ExpressionUUID->"32b07c2b-3b1d-49fb-a53f-e0a2b2ae4c86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`xCoba`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", 
     ",", "\"\<xAct`xCore`\>\"", 
     ",", "\"\<xAct`ExpressionManipulation`\>\""}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[10]:=",ExpressionUUID->"3f82887b-1b54-400e-96e0-f593df06599f"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"7d0cb3eb-d4af-46f8-9ed2-53a54f4baf8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.4", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"a26311f7-8128-487e-b668-b10ff92b406f"],

Cell[BoxData["\<\"CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"eb957c8c-d3f8-4429-9b9a-9ad173cc0601"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"6934c4f4-0743-4bfb-9e6b-3f2ec62f1f4f"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"4c5f1efc-20b1-48a5-8af1-d244c017bc0c"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"6dbecc1f-a67c-402b-b3a9-26b7e22af699"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.3.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.3.0", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"110e1575-7096-40a2-804b-f0330e644134"],

Cell[BoxData["\<\"CopyRight (C) 2002-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"01c41b67-fc3d-4a0c-aa32-af3f4bbc57ae"]
}, Open  ]],

Cell[BoxData["\<\"xAct`xCoba`\"\>"], "Output",
 CellLabel->
  "Out[10]=",ExpressionUUID->"85084f8d-aabf-4ff0-ba5c-a665a050f0c9"]
}, Open  ]],

Cell[TextData[{
 "Check version of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"55fae883-ec7c-4c02-9dda-f21d37e518c7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"Not", "@", 
     RowBox[{"OrderedQ", "@", 
      RowBox[{"Map", "[", 
       RowBox[{"Last", ",", 
        RowBox[{"{", 
         RowBox[{"$xTensorVersionExpected", ",", "xAct`xTensor`$Version"}], 
         "}"}]}], "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"General", "::", "versions"}], ",", "\"\<xTensor\>\"", ",", 
       "xAct`xTensor`$Version", ",", "$xTensorVersionExpected"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[11]:=",ExpressionUUID->"65b0cb7f-2e87-4aac-b4bb-cbe711bd8593"],

Cell["Message:", \
"Text",ExpressionUUID->"f25fa8b6-3c91-47fd-8638-302be2c53e81"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`xCoba`  version \>\"", ",", 
    RowBox[{"xAct`xCoba`$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"xAct`xCoba`$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", "\"\<CopyRight (C) 2005-2026, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\>\"", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[12]:=",ExpressionUUID->"18486ea7-f128-4e96-b72a-38d74e3162b3"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"2763fc2d-0807-48de-bbf9-713fbeb4ff35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.6", ", ", {2021, 2, 28}],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"95b0ebb0-cf80-4d05-b887-1ceaecbc64fd"],

Cell[BoxData["\<\"CopyRight (C) 2005-2026, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[12]:=",ExpressionUUID->"126c2397-cecf-4243-9cad-e55c77d1e4b7"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "We specify the context xAct`xTensor` to avoid overriding the Disclaimer of ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 ",  ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " and ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". However we need to turn off the message General:shdw temporarily:"
}], "Text",ExpressionUUID->"53344ed6-c1a3-4024-9be3-c19bf9b10b67"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"General", "::", "shdw"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xCoba`Disclaimer", "[", "]"}], ":=", 
   RowBox[{
   "Print", "[", "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"On", "[", 
   RowBox[{"General", "::", "shdw"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[15]:=",ExpressionUUID->"f4f9af13-8961-42f9-ad77-ac6439af05d1"],

Cell["\<\
If xCoba is the last package read, then print the short GPL disclaimer:\
\>", "Text",ExpressionUUID->"74761a01-b5de-4b1f-bab0-e45cd4a33c33"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`xCoba`\>\""}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", "\"\<These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\>\"", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[18]:=",ExpressionUUID->"dd878f5e-273c-4f22-9f17-f8ce03dabf5b"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"b6aca330-329e-4d31-b9d9-47dfe6b96b8a"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"8ffa08b9-04fc-44b7-99c9-cfbf9ad0be12"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"e44f58c4-e324-44c4-bcf9-2210867bf02e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"a90e6b30-a3fc-4d66-960c-5fd604871de6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xCoba`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`ExpressionManipulation`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[19]=",ExpressionUUID->"652477e1-dddb-44ce-95ef-9566ead5b622"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Usage messages", \
"Subsection",ExpressionUUID->"d2de1e4c-e212-4154-aed4-638a0e236382"],

Cell[CellGroupData[{

Cell["1.2.1. Bases", \
"Subsubsection",ExpressionUUID->"9c7fc296-5f10-4bac-8558-f3cc31759f6e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Basis"}]], "Input",ExpressionUUID->"3c77f78a-2541-4601-a3e2-82c56f145c33"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Basis represents both the type and the tensor head \
for a basis vector/covector field.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"xTensorQ", "[", "Basis", "]"}], "^=", "True"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`Basis\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Basis represents both the type and the tensor head \
for a basis vector/covector field.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Basis represents both the type and the tensor head for a basis \
vector/covector field.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> 
    Information`InformationValueForm[
     UpValues, xAct`xTensor`Basis, {
      xAct`xTensor`xTensorQ[xAct`xTensor`Basis] -> True}], "DownValues" -> 
    None, "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "xAct`xTensor`Basis"|>, 
   False]]], "Output",ExpressionUUID->"a9cb4707-3e92-4819-baf8-782beba185a6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Definition", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefBasis", "::", "usage"}], 
     "=", "\"\<DefBasis[basis, vbundle, {c1, ..., cn}] defines a basis of \
vector fields with name basis on the given vbundle. Its dual -basis is also \
implicitly defined. The list of cnumbers {c1, ..., cn} denotes the integers \
identifying the element of the basis, and hence must have length equal to the \
dimension of the vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefBasis", "::", "usage"}], 
     "=", "\"\<UndefBasis[basis] undefines the basis.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$PDPrefixSymbol", "::", "usage"}], 
     "=", "\"\<$PDPrefixSymbol is a global variable giving the character used \
to represent the parallel derivatives in StandardForm in Prefix notation. The \
default value is \[ScriptCapitalD] (the capital script D).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$PDPostfixSymbol", "::", "usage"}], 
     "=", "\"\<$PDPostfixSymbol is a global variable giving the character \
used to represent the parallel derivatives in StandardForm in Postfix \
notation. The default value is \[Cedilla] (a cedilla).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BasisColor", "::", "usage"}], 
     "=", "\"\<BasisColor[basis] gives the color with which objects and \
indices associated to the given basis will be represented in StandardForm.\\n\
\\nBasisColor is also an option for DefBasis giving the color associated to \
the defined basis. The default value is red (RGBColor[1, 0, 0]).\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FormatBasis", "::", "usage"}], 
     "=", "\"\<FormatBasis[{i, -basis}, string] formats the basis vector \
Basis[{i, -basis}, a] as string[a], where i is one of the cnumbers compatible \
with basis. FormatBasis[{i, basis}, string] formats the basis covector \
Basis[-a, {i, basis}] as string[-a]. FormatBasis[CD[{i, -basis}], string] \
formats the given directional derivative as string. FormatBasis acting on \
only the first arguments of those cases removes the corresponding formatings.\
\\n\\nFormatBasis is also an option for DefBasis and DefChart specifying two \
lists of strings to format respectively the vectors and the covectors of the \
basis. For DefChart it is also possible to use \\\"Partials\\\" for vectors \
and/or \\\"Differentials\\\" for the covectors. The default value is \
Automatic.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"epsilonOrientationOfMetric", "::", "usage"}], 
     "=", "\"\<epsilonOrientationOfMetric is an option of DefBasis specifying \
a pair {metric, o} where o is the factor between the epsilon of the given \
metric and the eta tensors of the basis being defined. By default it takes \
the value {Null, 1}.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"etaOrientation", "::", "usage"}], 
     "=", "\"\<etaOrientation[basis] gives the orientation sign of the eta \
tensors of basis. It is computed as the Signature of the list of cnumbers of \
the basis at definition time.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BasisChange", "::", "usage"}], 
     "=", "\"\<BasisChange is an option of DefBasis specifying a 2-CTensor \
change from a previously defined basis. The CTensor object must use both \
bases, one covariant and the other contravariant. The default value is Null, \
meaning that the basis is defined without reference to any other basis. It is \
also possible to give a pair of CTensor objects, representing the direct and \
inverse basis changes.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetBasisChange", "::", "usage"}], 
     "=", "\"\<SetBasisChange[CTensor[matrix, {-downbasis, upbasis}]] stores, \
both using a CTensor and TensorValues, the change between the bases. Input \
can also be given as SetBasisChange[CTensor[Transpose[matrix], {upbasis, \
-downbasis}]]. SetBasisChange[{direct, inverse}] provides a pair of CTensor \
objects describing the direct and inverse basis changes.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2e36996e-636f-456d-a95e-97e6c95840a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Registering", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VBundleOfBasis", "::", "usage"}], 
     "=", "\"\<VBundleOfBasis[basis] gives the vbundle on which basis \
lives.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BasesOfVBundle", "::", "usage"}], 
     "=", "\"\<BasesOfVBundle[vb] gives the lists of bases registered on the \
vbunle vb.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PDOfBasis", "::", "usage"}], 
     "=", "\"\<PDOfBasis[basis] gives the parallel derivative associated to \
the given basis. If the basis is coordinated then (and only then) the \
derivative has no torsion and it can be called a partial derivative (ordinary \
derivative in Wald's book).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BasisOfCovD", "::", "usage"}], 
     "=", "\"\<BasisOfCovD[covd] for a basis-parallel derivative covd returns \
the basis to which covd is associated. If covd is not registered as parallel \
to a basis then it returns Null. \>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DependenciesOfBasis", "::", "usage"}], 
     "=", "\"\<DependenciesOf[basis] gives the list of dependencies \
(manifolds and/or parameters) of basis.\>\""}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"CNumbersOf", "::", "usage"}], 
     "=", "\"\<CNumbersOf[basis, svb] returns the sublist of integer cnumbers \
associated to basis on the subvbundle svb. CNumbersOf[basis] is converted \
into CNumbersOf[basis, VBundleOfBasis[basis]].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DaggerCIndex", "::", "usage"}], 
     "=", "\"\<DaggerCIndex[basis, cindex] returns the conjugated index to \
the cindex (assumed to belong to basis or -basis), in general a Dir \
expression. This function should be handled through upvalues for \
basis.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetDaggerMatrix", "::", "usage"}], 
     "=", "\"\<SetDaggerMatrix[basis, matrix] defines upvalues for \
DaggerCIndex of all c-indices of basis, its dual and their conjugates, based \
on the given conjugation matrix. This matrix gives the dagger of the basis \
up-vectors in terms of the vectors of its conjugate basis. When the basis is \
real the matrix must be unitary.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"41bbd27a-c312-48d1-9a9b-e1781041b0c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Densities", " ", "and", " ", "Jacobians"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"etaUp", "::", "usage"}], 
     "=", "\"\<etaUp is a reserved word in xCoba, used to denote the \
antisymmetric part of the product of vectors of a basis. It is a tensor \
density of weight +1 in basis.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"etaDown", "::", "usage"}], 
     "=", "\"\<etaDown is a reserved word in xCoba, used to construct the \
antisymmetric part of the product of covectors of a basis. It is a tensor \
density of weight -1 in basis.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"etaUpToepsilon", "::", "usage"}], 
     "=", "\"\<etaUpToepsilon[basis, metric] gives a rule transforming the \
etaUp tensor of basis into the epsilon tensor of metric.\>\""}], ";"}], "\n", 
   
   RowBox[{
    RowBox[{
     RowBox[{"etaDownToepsilon", "::", "usage"}], 
     "=", "\"\<etaDownToepsilon[basis, metric] gives a rule transforming the \
etaDown tensor of basis into the epsilon tensor of metric.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"epsilonToetaUp", "::", "usage"}], 
     "=", "\"\<epsilonToetaUp[metric, basis] gives a rule transforming the \
epsilon tensor of metric into the etaUp tensor of basis.\>\""}], ";"}], "\n", 
   
   RowBox[{
    RowBox[{
     RowBox[{"epsilonToetaDown", "::", "usage"}], 
     "=", "\"\<epsilonToetaDown[metric, basis] gives a rule transforming the \
epsilon tensor of metric into the etaDown tensor of basis.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Overload", " ", "Jacobian"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Jacobian", "::", "usage"}], "=", 
     RowBox[{
      RowBox[{"Jacobian", "::", "usage"}], 
      "<>", "\"\<\\n\\nJacobian[b1, b2][] returns the Jacobian of the \
transformation between bases b1 and b2. If b1 and b2 are not sorted \
lexicographically, then it returns 1/Jacobian[b2, b1][].\>\""}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ca04e553-f543-47e1-9725-21f76630413b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Values", " ", "for", " ", "the", " ", "metric", " ", "in", " ", "a", " ", 
    "basis"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MetricInBasis", "::", "usage"}], 
    "=", "\"\<MetricInBasis[metric, -basis, matrix] stores the values in \
matrix for the covariant components of metric in the given basis. \
MetricInBasis[metric, -basis, diagonal] stores the given values for the \
diagonal list of components, and zero everywhere else. MetricInBasis[metric, \
-basis, \\\"Orthonormal\\\"] takes diagonal values from \
SignatureOfMetric[metric] and zero everywhere else. MetricInBasis[metric, \
-basis, \\\"Orthogonal\\\"] stores zero off-diagonal values, but does not \
define values on the diagonal. MetricInBasis[metric, basis, values] stores \
values for the contravariant components of the inverse metric, where values \
is any of the previous possibilities. Finally, MetricInBasis[metric, basis, \
expr] computes the components from the abstract expression expr, using the \
given basis. In this case we check that the character of basis coincides with \
that of the two indices of expr.\\n\\nMetricInBasis is also an option for \
DefBasis and DefChart specifying that information at definition time, that is \
MetricInBasis->{metric, -basis, matrix}. Its default value is {}.\>\""}], 
   ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8ec04548-9491-4be6-92e4-77e61d473d39"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Contraction", " ", "and", " ", "separation", " ", "of", " ", "bases"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ContractBasis", "::", "usage"}], 
     "=", "\"\<ContractBasis[expr, indices] removes Basis objects from expr. \
The second argument identifies which Basis objects must be removed, and which \
indices must be eliminated. The possibilities are: IndicesOf[selectors], a \
list of g-indices with head IndexList or a single g-index. It is also \
possible to use the name of a vbundle or a basis as shortcuts for \
IndicesOf[vbundle] or IndicesOf[basis], respectively. See the documentation \
for IndicesOf for a complete list of possible selectors. See also the option \
OverDerivatives.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SeparateBasis", "::", "usage"}], 
     "=", "\"\<SeparateBasis[basis][expr, indices] expands indices of objects \
in expr into products of Basis objects and the original objects, using \
contractions of indices specified by basis. When basis is AIndex or is not \
given, abstract indices are used. The list of indices can be supplied in \
different ways, using IndicesOf[selectors], a list of g-indices with head \
IndexList or a single g-index. See the documentation for IndicesOf for a \
complete list of possible selectors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OverDerivatives", "::", "usage"}], 
     "=", "\"\<OverDerivatives is a Boolean option for ContractBasis \
specifying whether Basis objects must be contracted or not with objects \
inside derivatives. Its default value is False.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"FreeToBasis", "::", "usage"}], 
     "=", "\"\<FreeToBasis[basis][expr, finds] converts the given free \
indices finds (either abstract- or basis-) into free indices of the given \
basis. finds can be an IndicesOf[selectors] expression, or a list with head \
IndexList or a single g-index.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DummyToBasis", "::", "usage"}], 
     "=", "\"\<DummyToBasis[basis][expr, dinds] converts the given dummy \
indices dinds (either abstract- or basis-) into dummy indices of the given \
basis. dinds can be an IndicesOf[selectors] expression, or a list with head \
IndexList or a single g-index.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToBasis", "::", "usage"}], 
     "=", "\"\<ToBasis[basis][expr, inds] converts the given indices inds \
into the given basis. It first uses the function DummyToBasis with the same \
arguments and then FreeToBasis on the result. inds can be an \
IndicesOf[selectors] expression, or a list with head IndexList or a single \
g-index.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AutomaticBasisContractionStart", "::", "usage"}], 
     "=", "\"\<AutomaticBasisContractionStart[] turns on the automatic \
conversion of contracted products of two Basis objects into a single one, \
both if the contracted index is of abstract or basis type.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"AutomaticBasisContractionStop", "::", "usage"}], 
     "=", "\"\<AutomaticBasisContractionStop[] turns off the automatic \
conversion of contracted products of two Basis objects into a single \
one.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b8467ca1-1bc5-4cdd-87a1-419ac9f0ba34"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Ricci", " ", "rotation", " ", "coefficients"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"RicciRotation", "::", "usage"}], 
    "=", "\"\<RicciRotation[covd, basis] gives the Christoffel tensor of covd \
from the parallel derivative of basis.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9cb5d155-e01c-418f-bf05-260af781a3b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SplitBasis", "::", "usage"}], 
   "=", "\"\<SplitBasis[basis, {subv1->cnumbers1, subvb2->cnumbers2, ...}] \
declares how the given basis of a vbundle must be splitted among the \
subvbundles of that vbundle.\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7ef73415-c368-4a20-88cc-601c40d9f033"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Bases", " ", "and", " ", "mappings"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PrecomposeBasis", "::", "usage"}], 
    "=", "\"\<Precompose[basis, phi] represents the precomposition with the \
mapping phi of the (vectors of the) given basis.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"65d62c14-3930-4ea1-a94b-3cd41065986b"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.2. Abstract expressions", \
"Subsubsection",ExpressionUUID->"5d827c6f-298e-4239-a544-4070ba6d3b30"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"BasisArray", " ", "and", " ", "BasisCollect"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"BasisArray", "::", "usage"}], 
     "=", "\"\<BasisArray[basis1, basis2, ...][i1, i2, ...] generates the \
array of Basis objects with a-indices i1, i2, ... and the c-indices \
corresponding to the respective bases. The depth of the array is the number \
of a-indices. If all bases coincide then it is possible to write a single \
basis.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BasisCollect", "::", "usage"}], 
     "=", "\"\<BasisCollect[expr] collects all terms corresponding to the \
same component multiplying the same free basis vectors. BasisCollect[expr, f] \
maps the function f to those coefficients.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d9ece85f-b5d7-4494-b950-f136036182e8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Tracing", " ", "dummies"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TraceBasisDummy", "::", "usage"}], 
     "=", "\"\<TraceBasisDummy[expr, inds] expands the basis-dummies inds in \
expr to the corresponding ranges of c-numbers. inds can be a single b-index, \
an IndexList list of indices or an IndicesOf specfification of selectors. The \
name of a basis or a vbundle are also accepted. TraceBasisDummy[expr] expands \
all basis-dummies. TraceBasisDummy[expr, inds1, ..., inds2, ...] sequentially \
expands the indices of the different specifications.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BasisExpand", "::", "usage"}], 
     "=", "\"\<BasisExpand[expr, basis] converts the abstract-indexed \
expression expr into a linear combination of components multiplied by basis \
elements of the given basis.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Component", " ", "array", " ", "generation"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ComponentArray", "::", "usage"}], 
     "=", "\"\<ComponentArray[expr, bcinds] returns an array of components of \
expr obtained by expansion of the free b-indices in the list bcinds present \
in expr. bcinds can be an expression with head IndicesOf or a list of indices \
with head IndexList or a g-index. ComponentArray[expr] is equivalent to \
ComponentArray[expr, IndicesOf[Free,BIndex]].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TableOfComponents", "::", "usage"}], 
     "=", "\"\<TableOfComponents[expr, basis] returns a multidimensional \
table of all components (corresponding to the free-indices) of expr. \
TableOfComponents[expr, {A, basis}] gives the list of components of expr \
corresponding to the abstract index A expanded in basis or to the already \
present b-index {A, basis}. TableOfComponents[expr, a1, a2, ...] applies the \
options ai (either a basis or {A, basis}) sequentially.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Threading", " ", "over", " ", "arrays"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ThreadComponentArray", "::", "usage"}], 
     "=", "\"\<ThreadComponentArray[arrayL, arrayR, f] generates an array of \
expressions f[compL, compR] where compL and compR are corresponding elements \
of the arrays arrayL and arrayL of same dimensions and depth. The default \
value of f is Rule. If arrayL or arrayR are not arrays then ComponentArray is \
mapped on them first.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6ad40dd7-03eb-4854-8c9b-0a2132420d75"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.3. CTensor", \
"Subsubsection",ExpressionUUID->"470fa69e-5f22-486d-93e0-e52fc94fd12c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Explicit", " ", "representation", " ", "of", " ", "values"}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CTensor", "::", "usage"}], 
     "=", "\"\<CTensor[A, {B1, B2, ...}, w] represents an abstract tensor \
constructed from the array A of components in the bases Bi and with added \
density weight w.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ColorBasisForm", "::", "usage"}], 
     "=", "\"\<ColorBasisForm[array, colors] represents the array as \
MatrixForm would do, but coloring the lines around the array as given by the \
colors list.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CTensorRepresentation", "::", "usage"}], 
     "=", "\"\<$ColorCTensor is a global variable that determines how the \
CTensor objects are represented. The default value is \\\"ColorBasisForm\\\", \
that typesets the component arrays using colored frames with the colors of \
the respective bases. The alternative is \\\"MatrixForm\\\", which uses \
MatrixForm to typeset arrays.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$LargeComponentSize", "::", "usage"}], 
     "=", "\"\<$LargeComponentSize is a global variable containing the \
maximum ByteCount size of an expression that can be typeset as a component of \
a CTensor object. For larger expressions the string $LargeComponentString is \
shown. The default value is 1000.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$LargeComponentString", "::", "usage"}], 
     "=", "\"\<$LargeComponentString is a global variable containing the \
string to be displayed in a CTensor object instead of the large components \
(those whose ByteCount is beyond $LargeComponentSize). The default value is a \
grey circle \[GrayCircle]. A tooltip shows its actual contents.\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToCTensor", "::", "usage"}], 
     "=", "\"\<ToCTensor[T, bases] returns a CTensor expression equivalent to \
the tensor T whose first argument is an array of components of T in the given \
bases. This can be used to perform changes of bases in a CTensor expression. \
It also performs contractions with the first-metric if the up/down character \
of the slots is different. ToCTensor[T, bases, w] adds w to the weight of the \
resulting CTensor object.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToCTensorOneSlot", "::", "usage"}], 
     "=", "\"\<ToCTensorOneSlot[T, {n, change}] returns the result of \
changing the n-th slot of the CTensor object T multiplying with the second \
slot of the CTensor change.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToCCanonical", "::", "usage"}], 
     "=", "\"\<ToCCanonical[expr] sorts the indices of the CTensor objects, \
transposing their arrays of components and permuting their lists of bases \
such that the tensor remains the same.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$AutomaticCTensorMetricChange", "::", "usage"}], 
     "=", "\"\<$AutomaticCTensorMetricChange is a global variable stating \
whether CTensor objects will automatically get contracted with the \
first-metric when their indices are raised and lowered.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToBasisExpand", "::", "usage"}], 
     "=", "\"\<ToBasisExpand[expr] converts the CTensor objects in the \
expression expr into linear combinations of basis objects.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FromBasisExpand", "::", "usage"}], 
     "=", "\"\<FromBasisExpand[expr] converts Basis objects into CTensor \
objects.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Explicit", " ", "representation", " ", "of", " ", "covariant", " ", 
     "derivatives"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CCovD", "::", "usage"}], 
     "=", "\"\<CCovD[cd, chr] represents an abstract covariant derivative \
obtained by changing the covariant derivative cd as given by the Christoffel \
tensor chr. CCovD[cd, chr, metric] represents a connection deriving from the \
metric. When the covariant derivative is not associated to a metric field the \
third argument is automatically chosen to be Null.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToCCovD", "::", "usage"}], 
     "=", "\"\<ToCCovD[ccovd, pd] changes the CCovD covariante derivative \
ccovd to use the derivative pd in its first argument, modifying its \
Christoffel tensor as required. ToCCovD[ccovd, pd, bases] also changes the \
bases of the new Christoffel Tensor. ToCCovD[ccovd, pd, chrbases, metbases] \
changes the bases of both the Christoffel tensor and the associated metric \
tensor. \>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Explicit", " ", "representation", " ", "of", " ", "bases"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CBasis", "::", "usage"}], 
     "=", "\"\<CBasis[B, M] represents the new basis obtained by transforming \
the basis B using the matrix M. This is an experimental feature, only \
partially implemented.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"847f2a2b-b43d-49a8-ab56-69c1fff0638c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Duality", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Dual", "::", "usage"}], 
    "=", "\"\<Dual[cmatrix] computes the dual (inverse-transpose) of the \
CTensor matrix cmatrix.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"91b63e6c-4743-44f6-a231-08d1d07cc684"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xCoba", " ", "cache"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xCobaCache", "::", "usage"}], 
     "=", "\"\<xCobaCache[lhs, rhs] checks whether there is a value in the \
xCobaCacheTable assigned to lhs, and returns it if there is. Otherwise the \
value rhs is stored in the cache, assigned to lhs, and returned. \
xCobaCache[lhs, rhs, name] stores the pair {lhs, rhs} with the given name, \
with default being the head of the expresion lhs. xCoba[lhs, rhs, name, simp] \
uses the simplification function simp on the rhs expression before storing it \
in the cache table.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xCobaCacheTable", "::", "usage"}], 
     "=", "\"\<xCobaCacheTable[lhs, name] returns the expression associated \
to the key lhs and the given name, if it has been cached. Otherwise it stays \
unevaluated.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$xCobaCache", "::", "usage"}], 
     "=", "\"\<$xCobaCache is a boolean global variable specifying whether \
CTensor computations in xCoba should be cached. The default value is \
True.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$xCobaCacheVerbose", "::", "usage"}], 
     "=", "\"\<$xCobaCacheVerbose is a boolean global variable specifying \
whether caching and use of cache should be reported. The default value is \
False.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ClearxCobaCache", "::", "usage"}], 
     "=", "\"\<ClearxCobaCache[All] clears the cache table for CTensor \
computations. ClearxCobaCache[{pos}] or ClearxCobaCache[{{pos1}, {pos2}, \
...}] removes the values at positions posi (corresponding to the list of \
downvalues of xCobaCacheTable. ClearxCobaCache accepts input with Delete \
conventions.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintxCobaCache", "::", "usage"}], 
     "=", "\"\<PrintxCobaCache[] gives a tabular summary of the information \
stored in the xCobaCache table. The column on the left corresponds to the \
positions in the list of downvalues of xCobaCacheTable, and can be used to \
eliminate entries from the table using ClearxCobaCache[{pos}].\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"118bd0bc-0982-43a2-b4c0-dafc5fc1f0e5"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.4. Stored values", \
"Subsubsection",ExpressionUUID->"3f1e1c3d-f41c-42c4-bb37-1d16aa239f62"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Handling", " ", "list", " ", "of", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TensorValues", "::", "usage"}], 
     "=", "\"\<TensorValues[tensor, ders, {bases1, bases2, ...}] returns a \
FoldedRule structure with all components of tensor (or the ders derivatives \
of tensor) which have been computed until now with the configuration of \
indices specified by the symmetry-equivalent configurations bases1, bases2, \
...\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ValID", "::", "usage"}], 
     "=", "\"\<ValID[tensor, {{basis1, basis2, ...}}] identifies a set of \
values for the tensor with c-indices respectively in basis1, basis2, ... \
(with sign indicating character as usual; LI and -LI are accepted). For a \
tensor with symmetry, ValID[tensor, {bases1, bases2, ...}] identifies a set \
of values related by that symmetry, where each of the basesi is a list of \
possible reorderings of the bases of the c-indices. ValID[tensor, der1, der2, \
..., bases] identifies a set of values for the given derivatives of the \
tensor in Postfix order (in Prefix notation it would mean \
...[der2[der1[tensor]]), where bases is a list of lists as before.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorValIDs", "::", "usage"}], 
     "=", "\"\<TensorValIDs[tensor] gives the list ValID expressions of the \
sets of values for which at least one component has been already \
computed.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BasisValues", "::", "usage"}], 
     "=", "\"\<BasisValues[basis1, -basis2] and BasisValues[-basis2, basis1] \
give the list of component values for the matrix of change between those two \
bases. There is no automatic computation of the inverse matrix.\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DateOfValID", "::", "usage"}], 
     "=", "\"\<DateOfValID[valID] gives the date (format of Date[]) of the \
last modification of the values of the given valID.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DeleteTensorValues", "::", "usage"}], 
     "=", "\"\<DeleteTensorValues[tensor, ders, bases] removes the stored \
rules TensorValues[tensor, ders, bases]. DeleteTensorValues[tensor, ders] \
removes all such rules for tensor, for all bases configurations in \
TensorValIDs[tensor, ders].\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fa41ea78-75fe-4445-b0f4-a0518846105d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Storing", " ", "values"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ComponentValue", "::", "usage"}], 
     "=", "\"\<ComponentValue[expr], for a component tensor expression (a \
tensor or a derivative of a tensor), returns a value rule of the form expr -> \
canon where canon is the canonical form of expr under ToCanonical. This value \
rule is automatically stored in the TensorValues list of that tensor so that \
it can be used from that list without having to recompute it. \
ComponentValue[expr, value] returns a value rule expr -> value, and stores \
internally both the dependent rule expr -> canon and the independent rule \
canon -> value.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"HeldComponentValue", "::", "usage"}], 
     "=", "\"\<HeldComponentValue[expr] and HeldComponentValue[expr, value] \
perform the same tasks as ComponentValue, but not letting expr \
evaluate.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AllComponentValues", "::", "usage"}], 
     "=", "\"\<AllComponentValues[expr] returns an array of all value-rules \
of all possible symmetry-equivalent components of \
ComponentArray[expr].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CVVerbose", "::", "usage"}], 
     "=", "\"\<$CVVerbose is a Boolean global variable turning on/off verbose \
messages from ComponentValue. Its default value is True.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CVReplace", "::", "usage"}], 
     "=", "\"\<$CVReplace is a Boolean global variable specifying whether \
stored values must be replaced by new different values or not (a message \
would be sent then). Its default value is True.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CheckZeroValue", "::", "usage"}], 
     "=", "\"\<$CheckZeroValue is a Boolean global variable. If True, \
ComponentValue will check values for those components which are zero by \
symmetry, and will complain if they are not zero. The default is \
False.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CVSimplify", "::", "usage"}], 
     "=", "\"\<$CVSimplify is a global variable specifying a simplification \
function to be used by many xCoba functions. The default is Simplify.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RuleToSet", "::", "usage"}], 
     "=", "\"\<RuleToSet[valID] converts the stored rules of valID into \
static definitions, effectively replacing Rule by Set. RuleToSet[T, d1, ..., \
dn, blist] applies RuleToSet on the known valIDs for the given tensor T, \
first-derivatives d1, ..., dn and list of bases blist. It is also possible to \
use the syntax RuleToSet[T, d1, ..., dn] or even RuleToSet[T], which applies \
RuleToSet on all known valIDs for the given input.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetToRule", "::", "usage"}], 
     "=", "\"\<SetToRule[valID] transforms back the static definitions of \
valID into rules, effectively replacing Set by Rule. SetToRule[T, d1, ..., \
dn, blist] applies SetToRule on the known valIDs for the given tensor T, \
first-derivatives d1, ..., dn and list of bases blist. It is also possible to \
use the syntax SetToRule[T, d1, ..., dn] or even SetToRule[T], which applies \
SetToRule on all known valIDs for the given input.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToTensorRules", "::", "usage"}], 
     "=", "\"\<ToTensorRules[tensor, ctensor] constructs and stores the rules \
associated to the assigment of the ctensor to the tensor. This is basically a \
call to ComponentValue having the ComponentArray of tensor in the first \
argument and ctensor in the second argument.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2e8bd193-2d44-4492-8171-ca67229dea81"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Changing", " ", "components"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ChangeComponents", "::", "usage"}], 
     "=", "\"\<ChangeComponents[expr1, expr2] computes and stores values for \
the components of expr1 starting from expr2. Those expressions are assumed to \
be related by metric and Basis factors only.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$TUseValues", "::", "usage"}], 
     "=", "\"\<$TUseValues is a global variable specifying which rules must \
be used internally by ComponentValue for the tensor whose components are \
being changed. Possible values are None, All and ToCanonical. The latter \
means that only dependent (symmetry) rules will be used, and is the \
default.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$BMUseValues", "::", "usage"}], 
     "=", "\"\<$BMUseValues is a global variable specifying which rules for \
the metric or the Basis objects must be used internally by ComponentValue. \
Possible values are None, All and ToCanonical. The latter means that only \
dependent (symmetry) rules will be used, and is the default.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CCSimplify", "::", "usage"}], 
     "=", "\"\<$CCSimplify is a global variable storing a function to be used \
after each step of ChangeComponents. The default is Identity.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8a1dc27f-cdc7-48b5-8a0f-3545141d2cc2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Using", " ", "values"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ToValues", "::", "usage"}], "=", 
     "\[IndentingNewLine]", "\"\<ToValues[expr] returns expr after replacing \
all known tensor-values for the tensors in the expression. ToValues[expr, \
tensor] replaces only values for the given tensor. ToValues[expr, list] \
replaces values for the tensors in the list. ToValues[expr, list, f] applies \
the function f after replacement of each of the tensors in the list.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"WithSetValues", "::", "usage"}], 
     "=", "\"\<WithSetValues[expr, tensors] computes expr temporarily \
transforming to Set all Rule values for the given list of tensors. \
WithSetValues[expr] transforms to Set state temporarily all tensors present \
in expr.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b0b3b371-4791-4d93-91e9-2c47168e101d"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.5. Charts", \
"Subsubsection",ExpressionUUID->"042ba225-5bf7-4a39-ac8c-1ed2b478e79b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"The", " ", 
    RowBox[{"Reals", "[", "dim", "]"}], " ", "manifold"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TangentReals", "::", "usage"}], 
    "=", "\"\<TangentReals[dim] represents the tangent vbundle to the \
manifold Reals[dim].\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8817e886-951c-4859-8761-8b4f0ef8996d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Charts", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefChart", "::", "usage"}], 
     "=", "\"\<DefChart[chart, manifold, cnumbers, scalars] defines chart as \
a coordinate system on manifold, with coordinate fields given by the list \
scalars and the integer cnumbers identifying those coordinates and the \
associated vectors/covectors fields. \>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefChart", "::", "usage"}], 
     "=", "\"\<UndefChart[chart] undefines the chart, making it \
unusable.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChartColor", "::", "usage"}], 
     "=", "\"\<ChartColor[chart] returns the color used to represent the \
given chart in StandardForm. It equals BasisColor[chart].\\n\\nChartColor is \
also an option for DefChart specifying that color at definition time.\>\""}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ExtendedCoordinateDerivatives", "::", "usage"}], 
     "=", "\"\<ExtendedCoordinateDerivatives is a Boolean option for DefChart \
specifying that, if set to True, all covariant derivatives acting on the \
coordinate scalars are converted automatically into Basis objects. If set to \
False then only the parallel derivative of the declared chart acting on \
coordinate scalars will be converted. Note that this is decided at \
declaration time, and cannot be altered afterwards.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$IdentityScalarSymbol", "::", "usage"}], 
     "=", "\"\<$IdentityScalarSymbol is a global variable containing the \
symbol used to denote the natural scalar fields of the \
IdentityMapping[Reals[dim]] chart. The default value is the double-struck x. \
Hence those scalars are denoted as \[DoubleStruckX][dim, i][], where i is a \
positive integer between 1 and dim.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[DoubleStruckX]", "::", "usage"}], 
     "=", "\"\<\[DoubleStruckX] is the symbol used by default to denote the \
scalar fields of Reals[dim]. They are actually denoted as \
\[DoubleStruckX][dim, i][] with the integer i taking values from 1 to dim. \
The default symbol can be changed modifying the value of the variable \
$IdentityScalarSymbol.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChartOfScalar", "::", "usage"}], 
     "=", "\"\<ChartOfScalar[x[]] returns the chart to which the coordinate \
scalar x[] belongs, or Null otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarsOfChart", "::", "usage"}], 
     "=", "\"\<ScalarsOfChart[chart] gives the list of coordinate scalar \
fields of chart.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ManifoldOfChart", "::", "usage"}], 
     "=", "\"\<ManifoldOfChart[chart] gives the manifold on which the given \
chart has been defined.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ChartsOfManifold", "::", "usage"}], 
     "=", "\"\<ChartsOfManifold[manifold] gives the charts already defined on \
the manifold.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Coordinate", "::", "usage"}], 
     "=", "\"\<Coordinate[i, chart] returns the name of the coordinate field \
in the given chart identified by the cnumber i.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InChart", "::", "usage"}], 
     "=", "\"\<InChart[expr, chart][x1, x2, ...] is a scalar-function with \
arguments x1, x2, ... representing the tensorial expression expr in the given \
chart. That means that the arguments x1, x2, ... are taken to be values for \
the respective coordinate fields of the chart. InChart[_,_] is recognized as \
a scalar function by ScalarFunctionQ.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToInChart", "::", "usage"}], 
     "=", "\"\<ToInChart[chart][expr] converts scalar fields in expr into \
their corresponding InChart scalar functions. ToInChart[chart][expr] is \
converted into InChart[expr, chart][coords], where coords are the coordinate \
fields of the chart.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeChart", "::", "usage"}], 
     "=", "\"\<ChangeChart[expr, chart] changes the explicit InChart \
expressions in expr to the given chart, changing also their arguments so that \
the final function is equivalent to the initial one (passive change of \
coordinates).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CMapping", "::", "usage"}], 
     "=", "\"\<CMapping[domc[{x1,...}], imc[{y1,...}]] represents the mapping \
from a point in domain chart domc to a point in the image chart imc.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Transition", "::", "usage"}], 
     "=", "\"\<Transition[chart1, ichart2][{x1, x2, ...}] computes the list \
chart1[ichart2[{x1, x2, ...}]].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CurveTangent", "::", "usage"}], 
     "=", "\"\<CurveTangent[curve, t] gives the tangent field tangent to the \
curve, parametrized by t.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VectorD", "::", "usage"}], 
     "=", "\"\<VectorD[s, At[v, P]] computes the directional derivative of \
the scalar field in the direction of the vector v at the point P.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3e21ffde-26f6-4200-974b-2004487b42e0"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.6. Computations", \
"Subsubsection",ExpressionUUID->"c8bf60ca-5687-4270-9db7-0e701156e44b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Computations", " ", "from", " ", "a", " ", "metric", " ", "in", " ", "a", 
    " ", "coordinated", " ", "frame"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CVSimplify", "::", "usage"}], 
     "=", "\"\<CVSimplify is an option of various component functions which \
allows to insert a function in some key places. Standard choices are Together \
or Simplify.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MetricCompute", "::", "usage"}], 
     "=", "\"\<MetricCompute[g, ch, T] computes the components of the \
curvature tensor T associated to the metric g in the chart ch, where g and ch \
are symbols already known to xTensor and xCoba, respectively. The metric g is \
assummed to have been assigned values as explicit functions of the coordinate \
scalars. The notation for T is special and currently allows the 15 \
possibilities: \\\"Metric\\\"[-1, -1], \\\"Metric\\\"[1, 1], \
\\\"DetMetric\\\"[], \\\"DMetric\\\"[-1, -1, -1], \\\"DDMetric\\\"[-1, -1, \
-1, -1], \\\"Christoffel\\\"[-1, -1, -1], \\\"Christoffel\\\"[1, -1, -1], \
\\\"Riemann\\\"[-1, -1, -1, -1], \\\"Riemann\\\"[-1, -1, -1, 1], \
\\\"Riemann\\\"[-1, -1, 1, 1], \\\"Ricci\\\"[-1, -1], \\\"RicciScalar\\\"[], \
\\\"Weyl\\\"[-1, -1, -1, -1], \\\"Einstein\\\"[-1, -1], \
\\\"Kretschmann\\\"[], where -1 denotes a covariant component and 1 a \
contravariant component. This function computes in advance everything needed \
to know the required tensor T. It is possible to say All instead of a tensor \
T, and then those 14 tensors will be computed. There are options CVSimplify, \
to specify a function which is applied to each component after each tensor is \
computed (default is Together), and Verbose, to get info messages during the \
computation (default is True).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetCMetric", "::", "usage"}], 
     "=", "\"\<SetCMetric[met, ch] sets met, a CTensor[matrix, {-basis, \
-basis}] object, as metric for the vector bundle of the given basis. It is \
assumed to be a field on the coordinate chart ch. Some auxiliary objects, \
like metric derivatives and Christoffel values are precomputed. \
SetCMetric[met, tor, ch] adds the torsion tensor tor to the covariant \
derivative associated to the metric met. An option SignatureOfMetric -> {np, \
nn, nz} explicitly specifies the signature of the metric.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UnsetCMetric", "::", "usage"}], 
     "=", "\"\<UnsetCMetric[met] unsets the metric met, a CTensor \
object.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7072f8f1-e7b0-48a2-9cf5-6947daa66d6c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Older", " ", "functionality"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"InverseMetric", "::", "usage"}], 
     "=", "\"\<InverseMetric[g[-a, -b], B][c, d] returns the inverse of the \
metric g[-a, -b], expressed as an abstract tensor with upper indices c, d. \
The result is computed using the components of the metric g in the basis B.\>\
\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChristoffelFromMetric", "::", "usage"}], 
     "=", "\"\<ChristoffelFromMetric[g[-a, -b], B][c, -d, -e] returns the \
Christoffel tensor of the LeviCivita connection of the metric g[-a, -b] from \
the parallel derivative of the basis B, expressed as an abstract tensor with \
indices c, -d, -e.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannFromChristoffel", "::", "usage"}], 
     "=", "\"\<RiemannFromChristoffel[chr[a, -b, -c], B][-d, -e, -f, h] \
returns the Riemann tensor of the LeviCivita connection connected by the \
Christtofel tensor chr[a, -b, -c] from the parallel derivative of the basis \
B, expressed as an abstract tensor with indices -d, -e, -f, h.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"76468788-4e99-4246-9e6a-ea1d5591309e"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. Begin Private", \
"Subsection",ExpressionUUID->"57be88aa-192c-47ab-a526-31964a5e1e88"],

Cell["\<\
There are already six contexts in the $ContextPath. Note that none of them is \
Global`.\
\>", "Text",ExpressionUUID->"18faeeb5-3fcf-4ada-83b9-253cece63112"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], \
"Input",ExpressionUUID->"e97a6728-83ac-4659-8e1f-92839717b49d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xCoba`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`ExpressionManipulation`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"2160cf3c-4dc0-4ee2-b3b5-497a29e0891d"]
}, Open  ]],

Cell["and the current context is", \
"Text",ExpressionUUID->"05cb7466-1227-47aa-a922-ab9f1245b049"],

Cell[CellGroupData[{

Cell[BoxData["$Context"], \
"Input",ExpressionUUID->"cfbb1dfa-669b-4aed-9eea-264c57da9a6b"],

Cell[BoxData["\<\"xAct`xCoba`\"\>"], \
"Output",ExpressionUUID->"8b527546-ce79-4b7f-9216-2d286e6987bf"]
}, Open  ]],

Cell["Begin Private context:", \
"Text",ExpressionUUID->"0def8dac-8bab-4e3e-8bf8-371eff79d9da"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"cd878d6d-2180-4241-a9fe-e8498917cd47"],

Cell[BoxData["\<\"xAct`xCoba`Private`\"\>"], \
"Output",ExpressionUUID->"b8757eee-9366-48fe-8ad2-9a263a7d3c20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], \
"Input",ExpressionUUID->"2bc2bebd-a71f-4659-b6bb-2236de688280"],

Cell[BoxData["\<\"xAct`xCoba`Private`\"\>"], \
"Output",ExpressionUUID->"b5af0c7f-d7ee-4592-9b78-bd9cb3cb49e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], \
"Input",ExpressionUUID->"fef3801d-dd7e-4532-ab13-7b47ed7e4336"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xCoba`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`ExpressionManipulation`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"4a705b04-53e2-4d2c-9c79-0096369d4075"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$xCobaNames", "=", 
  RowBox[{"Names", "[", "\"\<xAct`xCoba`*\>\"", "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fae0ecce-af9e-40e9-bb5c-ab6912c1b3e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AllComponentValues\"\>", 
   ",", "\<\"AutomaticBasisContractionStart\"\>", 
   ",", "\<\"AutomaticBasisContractionStop\"\>", 
   ",", "\<\"BasesOfVBundle\"\>", ",", "\<\"BasisArray\"\>", 
   ",", "\<\"BasisChange\"\>", ",", "\<\"BasisCollect\"\>", 
   ",", "\<\"BasisColor\"\>", ",", "\<\"BasisExpand\"\>", 
   ",", "\<\"BasisOfCovD\"\>", ",", "\<\"BasisValues\"\>", 
   ",", "\<\"CBasis\"\>", ",", "\<\"CCovD\"\>", ",", "\<\"ChangeChart\"\>", 
   ",", "\<\"ChangeComponents\"\>", ",", "\<\"ChartColor\"\>", 
   ",", "\<\"ChartOfScalar\"\>", ",", "\<\"ChartsOfManifold\"\>", 
   ",", "\<\"ChristoffelFromMetric\"\>", ",", "\<\"ClearxCobaCache\"\>", 
   ",", "\<\"CMapping\"\>", ",", "\<\"CNumbersOf\"\>", 
   ",", "\<\"ColorBasisForm\"\>", ",", "\<\"ComponentArray\"\>", 
   ",", "\<\"ComponentValue\"\>", ",", "\<\"ContractBasis\"\>", 
   ",", "\<\"Coordinate\"\>", ",", "\<\"CTensor\"\>", 
   ",", "\<\"CurveTangent\"\>", ",", "\<\"CVSimplify\"\>", 
   ",", "\<\"DaggerCIndex\"\>", ",", "\<\"DateOfValID\"\>", 
   ",", "\<\"DefBasis\"\>", ",", "\<\"DefChart\"\>", 
   ",", "\<\"DeleteTensorValues\"\>", ",", "\<\"DependenciesOfBasis\"\>", 
   ",", "\<\"Disclaimer\"\>", ",", "\<\"Dual\"\>", 
   ",", "\<\"DummyToBasis\"\>", ",", "\<\"epsilonOrientationOfMetric\"\>", 
   ",", "\<\"epsilonToetaDown\"\>", ",", "\<\"epsilonToetaUp\"\>", 
   ",", "\<\"etaDown\"\>", ",", "\<\"etaDownToepsilon\"\>", 
   ",", "\<\"etaOrientation\"\>", ",", "\<\"etaUp\"\>", 
   ",", "\<\"etaUpToepsilon\"\>", 
   ",", "\<\"ExtendedCoordinateDerivatives\"\>", ",", "\<\"FormatBasis\"\>", 
   ",", "\<\"FreeToBasis\"\>", ",", "\<\"FromBasisExpand\"\>", 
   ",", "\<\"HeldComponentValue\"\>", ",", "\<\"InChart\"\>", 
   ",", "\<\"InverseMetric\"\>", ",", "\<\"ManifoldOfChart\"\>", 
   ",", "\<\"MetricCompute\"\>", ",", "\<\"MetricInBasis\"\>", 
   ",", "\<\"PDOfBasis\"\>", ",", "\<\"PrecomposeBasis\"\>", 
   ",", "\<\"PrintxCobaCache\"\>", ",", "\<\"RicciRotation\"\>", 
   ",", "\<\"RiemannFromChristoffel\"\>", ",", "\<\"RuleToSet\"\>", 
   ",", "\<\"ScalarsOfChart\"\>", ",", "\<\"SeparateBasis\"\>", 
   ",", "\<\"SetBasisChange\"\>", ",", "\<\"SetCMetric\"\>", 
   ",", "\<\"SetDaggerMatrix\"\>", ",", "\<\"SetToRule\"\>", 
   ",", "\<\"SplitBasis\"\>", ",", "\<\"TableOfComponents\"\>", 
   ",", "\<\"TangentReals\"\>", ",", "\<\"TensorValIDs\"\>", 
   ",", "\<\"TensorValues\"\>", ",", "\<\"ThreadComponentArray\"\>", 
   ",", "\<\"ToBasis\"\>", ",", "\<\"ToBasisExpand\"\>", 
   ",", "\<\"ToCCanonical\"\>", ",", "\<\"ToCCovD\"\>", 
   ",", "\<\"ToCTensor\"\>", ",", "\<\"ToCTensorOneSlot\"\>", 
   ",", "\<\"ToInChart\"\>", ",", "\<\"ToTensorRules\"\>", 
   ",", "\<\"ToValues\"\>", ",", "\<\"TraceBasisDummy\"\>", 
   ",", "\<\"Transition\"\>", ",", "\<\"UndefBasis\"\>", 
   ",", "\<\"UndefChart\"\>", ",", "\<\"UnsetCMetric\"\>", 
   ",", "\<\"ValID\"\>", ",", "\<\"VBundleOfBasis\"\>", 
   ",", "\<\"VectorD\"\>", ",", "\<\"WithSetValues\"\>", 
   ",", "\<\"xCobaCache\"\>", ",", "\<\"xCobaCacheTable\"\>", 
   ",", "\<\"\[DoubleStruckX]\"\>", 
   ",", "\<\"$AutomaticCTensorMetricChange\"\>", ",", "\<\"$BMUseValues\"\>", 
   ",", "\<\"$CCSimplify\"\>", ",", "\<\"$CheckZeroValue\"\>", 
   ",", "\<\"$CTensorRepresentation\"\>", ",", "\<\"$CVReplace\"\>", 
   ",", "\<\"$CVSimplify\"\>", ",", "\<\"$CVVerbose\"\>", 
   ",", "\<\"$IdentityScalarSymbol\"\>", ",", "\<\"$LargeComponentSize\"\>", 
   ",", "\<\"$LargeComponentString\"\>", ",", "\<\"$PDPostfixSymbol\"\>", 
   ",", "\<\"$PDPrefixSymbol\"\>", ",", "\<\"$TUseValues\"\>", 
   ",", "\<\"$Version\"\>", ",", "\<\"$xCobaCache\"\>", 
   ",", "\<\"$xCobaCacheVerbose\"\>", 
   ",", "\<\"$xTensorVersionExpected\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"bb00710f-4bf2-43ef-947b-9bf93cf61107"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "$xCobaNames", 
  "]"}]], "Input",ExpressionUUID->"e651da1e-7266-49ce-a9b8-29fc993fe73d"],

Cell[BoxData["114"], \
"Output",ExpressionUUID->"0e3bf05f-b237-4840-991a-62b3bd3c12be"]
}, Open  ]],

Cell["\<\
The Private` context is not added to the $ContextPath. However we can find \
symbols there. It is utterly confusing... In this notebook we shall follow \
this convention: examples are carried out in the Global` context, before \
ending the package, and therefore it is not possible to access \
xAct`xCoba`Private unless we append it to the $ContextPath:\
\>", "Text",ExpressionUUID->"49c54416-865e-436e-877c-fe251d0643a6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BeginExamples", "[", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Set", "[", 
     RowBox[{"$Context", ",", "\"\<Global`\>\""}], "]"}], ";", 
    RowBox[{"Global`symbols", "=", 
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}]}], ";", "Null"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Global`EndExamples", "[", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<There are new symbols in Global`:\>\"", ",", "#"}], 
         "]"}]}], "]"}], ";", 
      RowBox[{"Set", "[", 
       RowBox[{"$Context", ",", "\"\<xAct`xCoba`Private`\>\""}], "]"}], ";", 
      "Null"}], ")"}], "&"}], "@", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], ",", "Global`symbols"}],
     "]"}]}]}]}], \
"Input",ExpressionUUID->"9366e3fc-3371-499e-a95d-f8535b48faa1"],

Cell["\<\
The only problem is that writing xAct`xCoba`Private is rather long. We define:\
\>", "Text",ExpressionUUID->"3ad739fb-1de8-4f0e-ba0b-9dd97f775abd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$PreRead", "=", 
  RowBox[{
   RowBox[{"ReplaceAll", "[", 
    RowBox[{"#", ",", 
     RowBox[{"expr_String", "\[RuleDelayed]", 
      RowBox[{"StringReplace", "[", 
       RowBox[{"expr", ",", 
        RowBox[{"\"\<xACP\>\"", "\[Rule]", "\"\<xAct`xCoba`Private\>\""}]}], 
       "]"}]}]}], "]"}], 
   "&"}]}]], "Input",ExpressionUUID->"72eac2b1-f4ea-4928-840d-dc85b61eb070"],

Cell[BoxData[
 RowBox[{
  RowBox[{"#1", "/.", "\[VeryThinSpace]", 
   RowBox[{"expr_String", "\[RuleDelayed]", 
    RowBox[{"StringReplace", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"\<\"xACP\"\>", "\[Rule]", "\<\"xAct`xCoba`Private\"\>"}]}], 
     "]"}]}]}], 
  "&"}]], "Output",ExpressionUUID->"d925b31a-45ff-4d9c-b9b6-6d3451c5b440"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"c976aa31-85a9-4a2b-b249-3365f9623e6e"],

Cell["We define the manifold where the example objects will live:", \
"Text",ExpressionUUID->"951ca325-5f7c-43ed-b963-4cadc8b18756"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h",
      ",", "z"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"960aa124-71e0-42b2-b8a7-6252a32e9277"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"1fc4b661-d0f0-40c1-a7ff-c3b0f853be88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"1055f36c-e781-4958-86ec-66d2fdda5af7"]
}, Open  ]]
}, Open  ]],

Cell["and a complex vbundle:", \
"Text",ExpressionUUID->"8a41cb27-8e0a-4f1c-924c-67b1834337f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefVBundle", "[", 
  RowBox[{"InnerC", ",", "M", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "G", ",", "Z"}],
     "}"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], 
  "]"}]], "Input",ExpressionUUID->"501e8752-d3e0-4146-913e-eda784e77d26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "InnerC", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`InnerC, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"9fe3627e-041e-426c-828f-3a2381b5c2a3"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"C\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 170, 1, 19678524296362999459, "Local",
    "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"1007b9e2-7327-44b4-ad2d-a3f7e11610cf"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"D\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 170, 2, 19678524296362999459, "Local",
    "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"68c6d52d-d004-4e57-aaa2-824c90687a6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "InnerC\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between InnerC \
and InnerC\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`InnerC\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between InnerC and InnerC\[Dagger]"],
  Editable->
   False]], "Print",ExpressionUUID->"db742f57-5c9d-48d9-9e4d-98d59b797093"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaggerQ", "[", "InnerC", 
  "]"}]], "Input",ExpressionUUID->"b3ffbca5-c32d-441f-b8e3-039cb7e0ab9a"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"28c7f29d-5120-4b69-bfe6-a22ec2ad3b85"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "InnerC\[Dagger]"}]], \
"Input",ExpressionUUID->"1e155da4-fcc9-4362-82c0-a546b163d885"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Global`InnerC\[Dagger]\"\>", "InformationUsageText",
             
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`InnerC\[Dagger]],
                    Editable->False], "^=", 
                    InterpretationBox[
                    StyleBox["InnerC",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC,
                    Editable->False]}]},
                    {
                    RowBox[{
                    RowBox[{"VBundleQ", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"BaseOfVBundle", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", "M"}]},
                    {
                    RowBox[{
                    RowBox[{"MetricsOfVBundle", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"IndicesOfVBundle", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "A\[Dagger]", ",", "B\[Dagger]", ",", "C\[Dagger]", ",", 
                    "D\[Dagger]", ",", "F\[Dagger]", ",", "G\[Dagger]", ",", 
                    "Z\[Dagger]"}], "}"}], ",", 
                    RowBox[{"{", "}"}]}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"LastIndex", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"Z\[Dagger]", ",", "1"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DimOfVBundle", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", "3"}]},
                    {
                    RowBox[{
                    RowBox[{"SplittingsOfVBundle", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    
                    RowBox[{"\<\"conjugated vbundle\"\>", 
                    ",", "\<\"Assuming fixed anti-isomorphism between InnerC \
and InnerC\[Dagger]\"\>"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], 
                    "^=", "\<\"InnerC\[Dagger]\"\>"}]},
                    {
                    RowBox[{
                    RowBox[{"MasterOf", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", 
                    InterpretationBox[
                    StyleBox["InnerC",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC,
                    Editable->False]}]},
                    {
                    RowBox[{
                    RowBox[{"HostsOf", "[", 
                    InterpretationBox[
                    StyleBox["InnerC\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC\[Dagger],
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", "M", "}"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`InnerC\[Dagger]\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Global`InnerC\[Dagger]\"\>", "InformationUsageText",
             
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`InnerC\[Dagger]", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`InnerC\[Dagger], {
      xAct`xTensor`Dagger[$CellContext`InnerC\[Dagger]] -> \
$CellContext`InnerC, xAct`xTensor`VBundleQ[$CellContext`InnerC\[Dagger]] -> 
       True, xAct`xTensor`BaseOfVBundle[$CellContext`InnerC\[Dagger]] -> \
$CellContext`M, 
       xAct`xTensor`MetricsOfVBundle[$CellContext`InnerC\[Dagger]] -> {}, 
       xAct`xTensor`IndicesOfVBundle[$CellContext`InnerC\[Dagger]] -> \
{{$CellContext`A\[Dagger], $CellContext`B\[Dagger], $CellContext`C\[Dagger], \
$CellContext`D\[Dagger], $CellContext`F\[Dagger], $CellContext`G\[Dagger], \
$CellContext`Z\[Dagger]}, {}}, 
       xAct`xTensor`LastIndex[$CellContext`InnerC\[Dagger]] -> \
{$CellContext`Z\[Dagger], 1}, 
       xAct`xTensor`DimOfVBundle[$CellContext`InnerC\[Dagger]] -> 3, 
       xAct`xTensor`SplittingsOfVBundle[$CellContext`InnerC\[Dagger]] -> {}, 
       xAct`xTensor`DefInfo[$CellContext`InnerC\[Dagger]] -> {
        "conjugated vbundle", 
         "Assuming fixed anti-isomorphism between InnerC and \
InnerC\[Dagger]"}, xAct`xTensor`PrintAs[$CellContext`InnerC\[Dagger]] -> 
       "InnerC\[Dagger]", 
       xAct`xTensor`MasterOf[$CellContext`InnerC\[Dagger]] -> \
$CellContext`InnerC, 
       xAct`xTensor`HostsOf[$CellContext`InnerC\[Dagger]] -> \
{$CellContext`M}}], "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "Global`InnerC\[Dagger]"|>, 
   False]]], "Output",ExpressionUUID->"4fa1cc7a-7a78-4b31-9293-24000ac35d73"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"9742d7a9-b75f-484a-95c3-46e2cef48944"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are new symbols in Global`:\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"A\"\>", ",", "\<\"A\[Dagger]\"\>", 
     ",", "\<\"b\"\>", ",", "\<\"B\"\>", ",", "\<\"B\[Dagger]\"\>", 
     ",", "\<\"c\"\>", ",", "\<\"C\[Dagger]\"\>", ",", "\<\"d\"\>", 
     ",", "\<\"D\[Dagger]\"\>", ",", "\<\"e\"\>", ",", "\<\"f\"\>", 
     ",", "\<\"F\"\>", ",", "\<\"F\[Dagger]\"\>", ",", "\<\"g\"\>", 
     ",", "\<\"G\"\>", ",", "\<\"G\[Dagger]\"\>", ",", "\<\"h\"\>", 
     ",", "\<\"InnerC\"\>", ",", "\<\"InnerC\[Dagger]\"\>", ",", "\<\"M\"\>", 
     ",", "\<\"TangentM\"\>", ",", "\<\"z\"\>", ",", "\<\"Z\"\>", 
     ",", "\<\"Z\[Dagger]\"\>"}], "}"}]}],
  SequenceForm[
  "There are new symbols in Global`:", {
   "a", "A", "A\[Dagger]", "b", "B", "B\[Dagger]", "c", "C\[Dagger]", "d", 
    "D\[Dagger]", "e", "f", "F", "F\[Dagger]", "g", "G", "G\[Dagger]", "h", 
    "InnerC", "InnerC\[Dagger]", "M", "TangentM", "z", "Z", "Z\[Dagger]"}],
  Editable->
   False]], "Print",ExpressionUUID->"d79d99f4-3859-4e50-9692-f46b49859a3b"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2. Bases and their associated objects",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"a6078c15-ce8c-40dd-a340-15805fd65d68"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
    " ", "2."}], " ", "Bases"}], " ", "************************)"}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"f8fa39a5-b7ff-44ac-b8ab-31788b1b24d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"b9aae3d0-201d-453e-af75-34cf4dd30e44"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.493276`", ",", "4.938918`7.145176809201329", ",", 
   "0.5048262311784272`"}], 
  "}"}]], "Output",ExpressionUUID->"aaee1f54-39d8-4d8b-80c6-67557fb425c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.0. Comments", \
"Subsection",ExpressionUUID->"9c26317d-b2ad-4c9b-8278-13fe37da3d25"],

Cell[CellGroupData[{

Cell["2.0.1. General", \
"Subsubsection",ExpressionUUID->"bfef0ea7-067d-4557-8fb4-f58c17c3b7ce"],

Cell["\<\
\[Bullet] This section contains everything related to the Basis objects. Next \
section will deal with components of general tensor objects in those bases.\
\>", "Text",ExpressionUUID->"f73835f9-db5c-47ea-983f-961428488c1b"],

Cell[TextData[{
 "\[Bullet] The vector fields of a basis are abstract structures denoted as \
",
 StyleBox["Basis[{1, -polar}, a]", "InlineFormula"],
 ", which represents the first vector field of the basis polar. They act as \
bridges between the world of abstract indices (like a) and the world of \
component indices (like {1,-polar}). We use the notation of marked indices \
(i.e. including the name of the basis in the index) to simplify the operation \
of change of basis (we actually almost remove it!). Component indices are not \
abstract indices, in the sense that T[{1, -polar}] is a scalar field, equal \
to T[-a] Basis[{1,-polar}, a], and not a vector. The classical names \
\[OpenCurlyDoubleQuote]tensor component\[CloseCurlyDoubleQuote] or \
\"component of a tensor\" can be misleading, unless it is clearly understood \
that components of tensors are always scalars!"
}], "Text",ExpressionUUID->"dbe942e4-6f45-4d1b-a512-458dc225ef75"],

Cell["\<\
\[Bullet] Each basis has a dual basis, also represented with the head Basis \
and having the same name (but without the negative sign in front) and same \
component numbers, as in Basis[-a, {1,polar}].\
\>", "Text",ExpressionUUID->"41f781a5-53ef-48f0-8bfa-7c7d102d899a"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.0.2. Changes and additions", \
"Subsubsection",ExpressionUUID->"ace46735-f62e-4134-88e3-9b0787180369"],

Cell[TextData[{
 "\[Bullet] Version 0.6 of ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ": a new notation for bc-indices has been introduced. In versions 0.3 and \
0.4 we used b-indices like {a, polar}, {-a, polar} and c-indices like {1, \
polar} and {-1, polar}, which caused three important problems: \n\t1) the \
c-numbers had to be necessarily positive (in particular 0 could not be used);\
\n\t2) there was always a confusion between bases of a vbundle and bases of \
its dual because they shared the same name;\n\t3) there was an unconsistency \
in the fact that -a is obtained as the negative of a, but {-a, polar} is not \
the negative of {a, polar}.\nStarting version 0.6 we change notation using \
b-indices like {a, polar}, {-a, -polar} and c-indices like {1, polar} and {1, \
-polar}. This solves problems 1 and 2, and also problem 3 partially; not \
completely because we choose to have the same c-numbers for the elements of \
bases of a vbundle and its dual. Using the negatives would prevent us from \
using negative c-numbers on the original vbundle. This notational change IS \
NOT backwards compatible. We apologize to those users of ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " who now need to change lots of signs in previously developed notebooks, \
but we feel that the use of this new notation will pay off."
}], "Text",ExpressionUUID->"ee5ba82c-1b7d-44cc-9d90-38cd5d016c0f"],

Cell[TextData[{
 "\[Bullet] Version 0.7 of ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ": we have started introducing yet another notation for bc-indices, which \
coexists with the list-based notation. Now we can have basis indices like \
polar[a] and -polar[a] and component indices like polar[1] and -polar[1]. In \
this form the minus sign is always clearly detected. A given notebook must \
use only one notation. Unfortunately the new notation is not yet fully \
implemented. Each one has advantages. Most of the documentation and \
explanations uses the old notation, denoted as BASIS1. The new notation is \
called BASIS2."
}], "Text",ExpressionUUID->"fca92835-5e95-4a12-a107-d903ab370c4e"],

Cell[TextData[{
 "\[Bullet] Version 0.8 of ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " has added the CTensor[array, bases] notation for tensors, in an attempt to \
make computations simpler and faster."
}], "Text",ExpressionUUID->"376a5741-0140-41e3-bbd5-ba9692a13aa7"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.0.3. On the notation in Quantum Mechanics", \
"Subsubsection",ExpressionUUID->"5f3948aa-66ad-463f-93dc-0b2f51587c31"],

Cell[TextData[{
 "\[Bullet] The question is how much work is to introduce bra-ket notation \
for the computations. This is clearly nontrivial, and it would need special \
support from ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". The major issues are:"
}], "Text",ExpressionUUID->"6d89ad81-69e3-4113-a0e5-4b5986358f4b"],

Cell[TextData[{
 "\t- In ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ": index-free operator product. Suppose we use CenterDot for that (using Dot \
seems dangerous), perhaps NonCommutativeMultiply. We could implement a \
generic noncommutative \[OpenCurlyDoubleQuote]act on whatever is on the right\
\[CloseCurlyDoubleQuote] type action, like cadabra does, so that ToCanonical \
can handle anticommutative relations, etc. Can this be implemented using \
DefProduct?"
}], "Text",ExpressionUUID->"a02781c0-4b41-42be-9b31-666a3a180cde"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"CenterDot", ",", 
    RowBox[{"{", 
     RowBox[{"Flat", ",", "OneIdentity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Verbatim", "[", "CenterDot", "]"}], "[", "x_", "]"}], ":=", 
   "x"}], ";"}]}], \
"Input",ExpressionUUID->"ced434ef-b948-45ab-9753-485bf83997e7"],

Cell["\<\
\t- In xCoba: Bra and Ket are simply markers saying \
\[OpenCurlyDoubleQuote]this is a daggered covector\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]this is a vector\[CloseCurlyDoubleQuote] respectively. \
Very much like the overarrow for vectors. BraKet represents a scalar formed \
by product of a bra and a ket. We would need index-free notation for the \
basis vectors.\
\>", "Text",ExpressionUUID->"ce9613e0-553e-4016-977f-f4eb76ff49d3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Bra", "[", "\[Phi]", "]"}], ",", 
    RowBox[{"Ket", "[", "\[Psi]", "]"}], ",", 
    RowBox[{"BraKet", "[", 
     RowBox[{
      RowBox[{"{", "\[Phi]", "}"}], ",", 
      RowBox[{"{", "\[Psi]", "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"Bra", "[", "\[Phi]", "]"}], "\[CenterDot]", 
     RowBox[{"Ket", "[", "\[Psi]", "]"}]}], ",", 
    RowBox[{"Ket", "[", 
     RowBox[{"A", "\[CenterDot]", "\[Phi]"}], "]"}], ",", 
    RowBox[{
     RowBox[{"Bra", "[", 
      RowBox[{"\[Phi]", "\[CenterDot]", "A"}], "]"}], "\[CenterDot]", "B", "\[CenterDot]",
      "C", "\[CenterDot]", 
     RowBox[{"Ket", "[", 
      RowBox[{"D", "\[CenterDot]", "\[Psi]"}], "]"}]}]}], "}"}], "//", 
  "Column"}]], "Input",ExpressionUUID->"7af1a2a6-bde9-4ea2-a600-b72b5efc8cff"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{"\[Phi]"},
      "Bra"]},
    {
     TemplateBox[{"\[Psi]"},
      "Ket"]},
    {
     TemplateBox[{"\[Phi]", "\[Psi]"},
      "BraKet"]},
    {
     RowBox[{
      TemplateBox[{"\[Phi]"},
       "Bra"], "\[CenterDot]", 
      TemplateBox[{"\[Psi]"},
       "Ket"]}]},
    {
     TemplateBox[{
       RowBox[{"A", "\[CenterDot]", "\[Phi]"}]},
      "Ket"]},
    {
     RowBox[{
      TemplateBox[{
        RowBox[{"\[Phi]", "\[CenterDot]", "A"}]},
       "Bra"], "\[CenterDot]", "B", "\[CenterDot]", "C", "\[CenterDot]", 
      TemplateBox[{
        RowBox[{"D", "\[CenterDot]", "\[Psi]"}]},
       "Ket"]}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], \
"Output",ExpressionUUID->"a9f6005c-bc80-4043-b3d5-361c0c0d9d02"]
}, Open  ]],

Cell[TextData[{
 "\t- In QM we always deal with a complex vector space \[ScriptCapitalH] with \
a Hermitian metric g, meaning Dagger[ g[-a\[Dagger], -b] ] == g\[Dagger][-a, \
-b\[Dagger]] == g[-b\[Dagger], -a], or in matrix form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["g", "\[Dagger]tr"], "\[Equal]", "g"}], TraditionalForm]],
  ExpressionUUID->"5493b975-f1e8-4936-a1eb-dad00968c65d"],
 " (dagger for us is only complex conjugation). If v[a] and w[a] are vectors \
of \[ScriptCapitalH] then we can compute the sesquilinear inner product\n\n\t\
\[LeftAngleBracket]w\[VerticalSeparator]v\[RightAngleBracket] := \
g[-a\[Dagger], -b] Dagger[w[a]] v[b],\n\nwhich will be a complex number in \
general. The daggering is included so that \[LeftAngleBracket]v\
\[VerticalSeparator]v\[RightAngleBracket] is always a real number. Note that \
w in the bra is not represented with dagger or transposition.\n\n\t  \
Independently of the existence of a metric, we can always construct the dual \
space \[ScriptCapitalH]* of a vector space \[ScriptCapitalH]. The natural \
indexed notation for the elements of the dual is \[Omega][-a], such that \
\[Omega][-a] v[a] is a number, complex in general. The dual space is the \
space of linear operators on vectors (not antilinear!) The space \
\[ScriptCapitalH]* is also a complex space. There is no canonical isomorphism \
between the elements of \[ScriptCapitalH] and its dual \[ScriptCapitalH]*. In \
the braket notation there is no natural way to represent elements of the \
dual. This is not a problem because the following is used: the presence of a \
metric in \[ScriptCapitalH] induces a canonical isomorphism between the \
elements of \[ScriptCapitalH] and those of Dagger[\[ScriptCapitalH]*]. Given \
w[a] in \[ScriptCapitalH] construct \[Omega][-a\[Dagger]] = g[-a\[Dagger], \
-b] w[b]. Unfortunately this object is not in \[ScriptCapitalH]*, but in the \
complex conjugated of \[ScriptCapitalH]*, so now we need to choose another \
isomorphism between the space \[ScriptCapitalH]* and its conjugated Dagger[\
\[ScriptCapitalH]*]. This can be done choosing a basis in each space and \
assigning respective basis covectors, and extending by antilinearity. So now \
we have a canonical identification of w[a] with an element \[Omega][-a] of \
its dual. Hence define\n\n\t\[Omega][-b] v[b] := Dagger[ g[-b\[Dagger], -a] \
w[a] ] v[b] = g[-a\[Dagger], -b] Dagger[w[a]] v[b] = \[LeftAngleBracket]w\
\[VerticalSeparator]v\[RightAngleBracket] .\n\nSummarizing, we can write \
linear action of elements of \[ScriptCapitalH]* on elements of \
\[ScriptCapitalH] as a braket expression if we identify \[Omega] and w via \
the metric and complex isomorphisms, but remember that \[Omega] is a covector \
while w is a vector. We could have done the opposite: starting with the \
braket notation as linear action and writing the inner product through the \
isormorphisms.\n\t  This is the equivalent of \
\[OpenCurlyDoubleQuote]raising/lowering\[CloseCurlyDoubleQuote] indices in \
tensor calculus, but with a Dagger. In GR we write w[-a] v[a] both to \
represent linear action of w on v and to represent the inner product g[-a, \
-b] w[a] v[b]. In QM \[LeftAngleBracket]w\[VerticalSeparator]v\
\[RightAngleBracket] represents both linear action \[Omega][-a] v[a] and the \
inner product g[-a\[Dagger], -b] Dagger[w[a]] v[b], or the intermediate \
Dagger[g[-b\[Dagger], -a] w[a]] v[b].\n\t  In terms of matrix notation we \
have (note the two interpretations in the first line):\n\t  \n\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"w", "\[VerticalSeparator]", "v"}], "\[RightAngleBracket]"}], ":=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["w", "\[Dagger]tr"], ".", "g", ".", "v"}], "=", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"g", ".", "w"}], ")"}], "\[Dagger]tr"], ".", "v"}]}]}], 
   TraditionalForm]],ExpressionUUID->"58af8b7f-9c43-4722-8e4c-4a4d5956efb7"],
 "\n\nand for an operator A mapping \[ScriptCapitalH] to \[ScriptCapitalH]:\n\
\n\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"w", "\[VerticalSeparator]", "A", "\[VerticalSeparator]", "v"}], 
     "\[RightAngleBracket]"}], ":=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"w", "\[VerticalSeparator]", 
       RowBox[{"A", "\[CenterDot]", "v"}]}], "\[RightAngleBracket]"}], "=", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"g", ".", "w"}], ")"}], "\[Dagger]tr"], ".", "A", ".", "v"}],
       "=", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"g", ".", 
           SuperscriptBox["A", "H"], ".", "w"}], ")"}], "\[Dagger]tr"], ".", 
        "v"}], "=", 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["A", "H"], "\[CenterDot]", "w"}], "\[VerticalSeparator]",
          "v"}], "\[RightAngleBracket]"}]}]}]}]}], TraditionalForm]],
  ExpressionUUID->"d7194051-d98c-47fc-98d5-1c99858930a5"],
 "\n\nwith the Hermitian operator ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "H"], TraditionalForm]],ExpressionUUID->
  "4e298644-f7c9-4272-8ca9-82638f30badc"],
 "\n\n\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["A", "H"], ":=", 
    RowBox[{
     SuperscriptBox["g", 
      RowBox[{"-", "1"}]], ".", 
     SuperscriptBox["A", "\[Dagger]tr"], ".", "g"}]}], TraditionalForm]],
  ExpressionUUID->"7628822b-7793-4bbb-9a09-4cbab0c52def"],
 "\n\nwhich also maps \[ScriptCapitalH] to \[ScriptCapitalH]. In indices:\n\n\
\tAH[a, -b] = g[a, c\[Dagger]] A\[Dagger][-c\[Dagger], d\[Dagger]] g[-d\
\[Dagger], -b]\n\nFinal conclusion: probably the best interpretation of \
\[LeftAngleBracket]w| for a vector w[a] is that it represents the covector \
Dagger[ g\[CenterDot]w ] of \[ScriptCapitalH]* acting linearly on kets \
(vectors). The two isomorphisms involved (g and Dagger) are explicit."
}], "Text",ExpressionUUID->"c98233ce-1752-4b44-8c51-2f5793fd25bd"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1. Definition of a basis", \
"Subsection",ExpressionUUID->"c46146fd-4726-42a9-a2a6-890449292ce1"],

Cell[CellGroupData[{

Cell["2.1.0. Comments", \
"Subsubsection",ExpressionUUID->"7e9eca9a-b431-4def-9691-10d2e18083b4"],

Cell["\<\
This section defines the most basic properties of the concept of basis. Other \
sections will define additional functions to manipulate the objects \
associated to or depending on bases.\
\>", "Text",ExpressionUUID->"cddd913f-e0f1-4f6c-ba80-1776a553ef1b"],

Cell["\<\
This section is simple, except for the b-index notation choice.\
\>", "Text",ExpressionUUID->"8759a432-2995-4923-bd19-a35ce9a9912f"],

Cell["\<\
Properties as a basis:

\tBasisQ[basis]\t
\tBasisColor[basis]
\tCNumbersOf[basis, vb]
\tDependenciesOfBasis[basis]
\tetaOrientation[basis]
\tPDOfBasis[basis]
\tVBundleOfBasis[basis]

Generic properties:

\tDagger[basis]
\tPrintAs[basis]

Properties for a registered basis symbol:
\tDefInfo[basis]
\tHostsOf[basis]
\tServantsOf[basis]\t\
\>", "Text",ExpressionUUID->"0aeb0f67-1ddd-4bcc-b72e-834df8ddac28"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1.1. DefBasis", \
"Subsubsection",ExpressionUUID->"5140c6f1-d02a-4b14-867c-e28edc5d44e5"],

Cell["\<\
We start by defining a basis of vectors/covectors on a vbundle.

Associated to each basis there is its parallel covariant derivative such that \
the basis (co)vectors are constant along this derivative. This is true both \
for local bases on a tangent bundle or on an inner vbundle. This parallel \
derivative never has curvature, but when the basis is defined on a tangent \
bundle there are two cases: either the basis is not in involution, and then \
its parallel derivative has torsion, or it is in involution (a coordinated \
basis), and the the derivative is torsionless, an \"ordinary\" derivative (no \
curvature, no torsion) in Wald's terminology. The concept of torsion is not \
defined for inner derivatives.\
\>", "Text",ExpressionUUID->"6f44e3ce-2789-4d69-8102-8fc1da23d0e7"],

Cell[TextData[{
 StyleBox["DefBasis.",
  FontWeight->"Bold"],
 " The use of the word \"cnumber\" is a silly pun to mean either \
\"component-number\" or \"coordinate-number\", and there is no intended \
relation with the usual meaning of \"C-number\" in Quantum Mechanics. \
Cnumbers are integers to use the pattern _Integer for identification. We \
could also have strings for instance, but we don\[CloseCurlyQuote]t."
}], "Text",ExpressionUUID->"184bbac0-088d-4fcb-a90e-b80c1f36fe6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DefBasis"}]], \
"Input",ExpressionUUID->"92e8167e-8089-4495-808a-9716b501fb57"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefBasis[basis, vbundle, {c1, ..., cn}] defines a \
basis of vector fields with name basis on the given vbundle. Its dual -basis \
is also implicitly defined. The list of cnumbers {c1, ..., cn} denotes the \
integers identifying the element of the basis, and hence must have length \
equal to the dimension of the vbundle.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`DefBasis\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefBasis[basis, vbundle, {c1, ..., cn}] defines a \
basis of vector fields with name basis on the given vbundle. Its dual -basis \
is also implicitly defined. The list of cnumbers {c1, ..., cn} denotes the \
integers identifying the element of the basis, and hence must have length \
equal to the dimension of the vbundle.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DefBasis[basis, vbundle, {c1, ..., cn}] defines a basis of vector fields \
with name basis on the given vbundle. Its dual -basis is also implicitly \
defined. The list of cnumbers {c1, ..., cn} denotes the integers identifying \
the element of the basis, and hence must have length equal to the dimension \
of the vbundle.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xCoba`DefBasis"|>, 
   False]]], "Output",ExpressionUUID->"e4b8c854-cd71-4738-b4df-2d09540f08b3"]
}, Open  ]],

Cell[TextData[{
 "Comments:\n\t- Starting version 0.6.0 we also have an option Dagger (symbol \
defined in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ") to define the basis as complex (Dagger->Complex). The default is \
Dagger->Real, but when the underlying vbundle is complex a conjugated basis \
must be defined on the conjugated vbundle (that is, we check that the option \
is Dagger->Complex and throw an error if not).\n\t- We have introduced the \
option ExtendedFrom to extend the properties of the parallel derivative of a \
basis on a tangent vbundle to the parallel derivative of a basis on an inner \
vbundle. Note that in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " ExtendedFrom is used to extend covariant derivatives and ExtendedFrom \
gives a covariant derivative, but here it points to another basis. QUESTION: \
Why is that? We should use a derivative as well.\n\t- There could be other \
options being passed to the function MetricInBasis, defined below.\n\t- By \
default DependenciesOfBasis contains the base manifold of the vbundle of the \
basis, but it could also contain parameters (and perhaps even other manifolds \
on which the basis is a scalar field). This is already used in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"b36e0ca7-c040-48b8-bb67-5af56d662cea"],

Cell["\<\
These are the symbols for parallel derivatives, but not for the PD derivative \
itself. Perhaps we should use a different symbol for ordinary derivatives and \
generic parallel derivatives with torsion. These are global variables and \
therefore should not be protected:\
\>", "Text",ExpressionUUID->"32c2c77e-9b29-4027-97fd-1baa79db00a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "$PDPrefixSymbol"}]], \
"Input",ExpressionUUID->"89394c62-2d11-4969-8e37-1f59775e4453"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$PDPrefixSymbol is a global variable giving the \
character used to represent the parallel derivatives in StandardForm in \
Prefix notation. The default value is \[ScriptCapitalD] (the capital script \
D).\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`$PDPrefixSymbol\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$PDPrefixSymbol is a global variable giving the \
character used to represent the parallel derivatives in StandardForm in \
Prefix notation. The default value is \[ScriptCapitalD] (the capital script \
D).\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "$PDPrefixSymbol is a global variable giving the character used to \
represent the parallel derivatives in StandardForm in Prefix notation. The \
default value is \[ScriptCapitalD] (the capital script D).", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xCoba`$PDPrefixSymbol"|>, 
   False]]], "Output",ExpressionUUID->"70a3238a-f374-4425-8f31-9ae7ff3b2a88"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "$PDPostfixSymbol"}]], \
"Input",ExpressionUUID->"846b1fca-51a0-41dc-81c1-7094d2af71c8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$PDPostfixSymbol is a global variable giving the \
character used to represent the parallel derivatives in StandardForm in \
Postfix notation. The default value is \[Cedilla] (a cedilla).\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`$PDPostfixSymbol\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$PDPostfixSymbol is a global variable giving the \
character used to represent the parallel derivatives in StandardForm in \
Postfix notation. The default value is \[Cedilla] (a cedilla).\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "$PDPostfixSymbol is a global variable giving the character used to \
represent the parallel derivatives in StandardForm in Postfix notation. The \
default value is \[Cedilla] (a cedilla).", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xCoba`$PDPostfixSymbol"|>, 
   False]]], "Output",ExpressionUUID->"1e64e3bf-88f0-4901-b55a-98c8026e7bc5"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$PDPrefixSymbol", "=", "\"\<\[ScriptCapitalD]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$PDPostfixSymbol", "=", "\"\<\[Cedilla]\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"814eed7a-1ad2-497f-aa80-7af580db07dc"],

Cell["\<\
Main function. Though this is the definition of a basis there is nothing here \
concerning bc-indices.\
\>", "Text",ExpressionUUID->"47be1985-c200-43bd-b632-5e68cb6f48f5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefBasis", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"BasisColor", "\[Rule]", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FormatBasis", "\[Rule]", "Automatic"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"Dagger", "\[Rule]", "Real"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ExtendedFrom", "\[Rule]", "Null"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"MetricInBasis", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"BasisChange", "\[Rule]", "Null"}], ",", "\[IndentingNewLine]", 
     RowBox[{"epsilonOrientationOfMetric", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Null", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"DependenciesOfBasis", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"DefInfo", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<basis\>\"", ",", "\"\<\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Master", "\[Rule]", "Null"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"eeabba6b-7d48-4947-9d7f-02e8917f143c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Main", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"DefBasis", "[", 
     RowBox[{"basisname_", ",", "vbundle_", ",", "cnumbers_", ",", 
      RowBox[{"options", ":", 
       RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "bc", ",", "fb", ",", "pns", ",", "dag", ",", "ef", ",", "mb", ",", 
        "change", ",", "eoom", ",", "deps", ",", "mb3", ",", "dim", ",", 
        "tanb", ",", "covdef", ",", "info", ",", "master", ",", 
        RowBox[{"manifold", "=", 
         RowBox[{"BaseOfVBundle", "[", "vbundle", "]"}]}], ",", "tbundle", ",",
         "oldbasis", ",", "cbases"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "bc", ",", "fb", ",", "pns", ",", "dag", ",", "ef", ",", "mb", ",", 
          "change", ",", "eoom", ",", "deps", ",", "info", ",", "master"}], 
         "}"}], "=", 
        RowBox[{"OptionValue", "[", 
         RowBox[{"{", 
          RowBox[{
          "BasisColor", ",", "FormatBasis", ",", "ProtectNewSymbol", ",", 
           "Dagger", ",", "ExtendedFrom", ",", "MetricInBasis", ",", 
           "BasisChange", ",", "epsilonOrientationOfMetric", ",", 
           "DependenciesOfBasis", ",", "DefInfo", ",", "Master"}], "}"}], 
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"**", 
         RowBox[{"*", " ", "Checks"}]}], " ", "****)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Check", " ", "names"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"VBundleQ", "[", "vbundle", "]"}]}], ",", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"DefBasis", "::", "unknown"}], ",", "\"\<vbundle\>\"", ",",
             "vbundle"}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"dim", "=", 
        RowBox[{"DimOfVBundle", "[", "vbundle", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ChartQ", "[", "basisname", "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"BasisQ", "[", "basisname", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"The", " ", "basis", " ", "already", " ", 
             RowBox[{"exists", ".", " ", "This"}], " ", "is", " ", "a", " ", 
             "duplicated", " ", "name"}], " ", "*)"}], "\[IndentingNewLine]", 
           
           RowBox[{"Throw", "@", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"ValidateSymbol", "::", "used"}], ",", "basisname", 
              ",", "\"\<as a basis\>\""}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"Coordinate", " ", "basis", " ", "being", " ", 
             RowBox[{"defined", ".", " ", "Symbol"}], " ", "validation", " ", 
             "already", " ", 
             RowBox[{"performed", ".", " ", "Do"}], " ", "nothing"}], " ", 
            "*)"}], "\[IndentingNewLine]", "Null"}], "\[IndentingNewLine]", 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Noncoordinate", " ", 
           RowBox[{"basis", ".", " ", "Perform"}], " ", "symbol", " ", 
           "validation"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ValidateSymbol", "[", "basisname", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"ValidateSymbolInSession", "[", "basisname", "]"}]}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Check", " ", 
          RowBox[{"cnumbers", ":", " ", "heads"}]}], ",", " ", 
         RowBox[{"length", " ", "and", " ", "integer", " ", 
          RowBox[{"type", ".", " ", "Repeated"}], " ", "cnumbers", " ", "are",
           " ", "not", " ", "allowed"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Or", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Head", "[", "cnumbers", "]"}], "=!=", "List"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Union", "[", "cnumbers", "]"}], "=!=", 
            RowBox[{"Sort", "[", "cnumbers", "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Not", "[", 
            RowBox[{"And", "@@", 
             RowBox[{"(", 
              RowBox[{"IntegerQ", "/@", "cnumbers"}], ")"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Length", "[", "cnumbers", "]"}], "=!=", "dim"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"DefBasis", "::", "invalid"}], ",", "cnumbers", 
            ",", "\"\<list of cnumbers\>\""}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Check", " ", "complex", " ", "option"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Real", ",", "Complex", ",", "Conjugate"}], "}"}], ",", 
           "dag"}], "]"}], ",", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"DefBasis", "::", "invalid"}], ",", "dag", 
            ",", "\"\<value for option Dagger\>\""}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"DaggerQ", "[", "vbundle", "]"}], "&&", 
          RowBox[{"dag", "===", "Real"}]}], ",", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"DefBasis", "::", "error"}], 
            ",", "\"\<Cannot define a real basis on a complex \
manifold.\>\""}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Check", " ", "dependencies"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Not", "@", 
            RowBox[{"Or", "[", 
             RowBox[{
              RowBox[{"ManifoldQ", "[", "#", "]"}], ",", 
              RowBox[{"ParameterQ", "[", "#", "]"}]}], "]"}]}], ",", 
           RowBox[{"Throw", "@", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"DefBasis", "::", "invalid"}], ",", "#", 
              ",", "\"\<dependency\>\""}], "]"}]}]}], "]"}], "&"}], "/@", 
        "deps"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{"deps", ",", "manifold"}], "]"}], ",", 
         RowBox[{"deps", "=", 
          RowBox[{"Prepend", "[", 
           RowBox[{"deps", ",", "manifold"}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Check", " ", "extension", " ", "from", " ", "other", " ", "basis"}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"covdef", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ef", "=!=", "Null"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"BasisQ", "[", "ef", "]"}]}], ",", 
             RowBox[{"Throw", "@", 
              RowBox[{"Message", "[", 
               RowBox[{
                RowBox[{"DefBasis", "::", "unknown"}], ",", "\"\<basis\>\"", ",",
                 "ef"}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"tanb", "=", 
            RowBox[{"VBundleOfBasis", "[", "ef", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TangentBundleOfManifold", "@", 
               RowBox[{"BaseOfVBundle", "@", "tanb"}]}], "=!=", "tanb"}], ",", 
             RowBox[{"Throw", "@", 
              RowBox[{"Message", "[", 
               RowBox[{
                RowBox[{"DefBasis", "::", "invalid"}], ",", "ef", 
                ",", "\"\<basis to extend\>\""}], "]"}]}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"BaseOfVBundle", "@", "tanb"}], "=!=", "manifold"}], ",", 
             RowBox[{"Throw", "@", 
              RowBox[{"Message", "[", 
               RowBox[{
                RowBox[{"DefBasis", "::", "invalid"}], ",", "ef", 
                ",", "\"\<basis to extend\>\""}], "]"}]}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"PDOfBasis", "[", "ef", "]"}]}], ",", 
          "\[IndentingNewLine]", "Null"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Check", " ", "mb"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"mb", "=!=", 
          RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MatchQ", "[", 
            RowBox[{"mb", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"_", "?", "MetricQ"}], ",", 
               RowBox[{"basisname", "|", 
                RowBox[{"-", "basisname"}]}], ",", "_"}], "}"}]}], "]"}], ",",
            "\[IndentingNewLine]", 
           RowBox[{"Switch", "[", 
            RowBox[{
             RowBox[{"mb3", "=", 
              RowBox[{"mb", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"\"\<Orthogonal\>\"", "|", "\"\<Orthonormal\>\""}], ",", 
             "Null", ",", "\[IndentingNewLine]", "_List", ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Dimensions", "[", "mb3", "]"}], "=!=", 
                 RowBox[{"{", "dim", "}"}]}], "&&", 
                RowBox[{
                 RowBox[{"Dimensions", "[", "mb3", "]"}], "=!=", 
                 RowBox[{"{", 
                  RowBox[{"dim", ",", "dim"}], "}"}]}]}], ",", 
               RowBox[{"Throw", "@", 
                RowBox[{"Message", "[", 
                 RowBox[{
                  RowBox[{"DefBasis", "::", "invalid"}], ",", "mb3", 
                  ",", "\"\<array of metric values\>\""}], "]"}]}]}], "]"}], ",",
              "\[IndentingNewLine]", "_", ",", 
             RowBox[{"Throw", "@", 
              RowBox[{"Message", "[", 
               RowBox[{
                RowBox[{"DefBasis", "::", "invalid"}], ",", "mb3", 
                ",", "\"\<metric values specification\>\""}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Throw", "@", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"DefBasis", "::", "invalid"}], ",", "mb", 
              ",", "\"\<value for option MetricInBasis\>\""}], "]"}]}]}], 
          "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Check", " ", "change", " ", "and", " ", "compute", " ", "the", " ", 
         "other", " ", "basis", " ", "to", " ", "which", " ", "it", " ", 
         "relates"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"change", "=!=", "Null"}], ",", "\[IndentingNewLine]", 
         RowBox[{"oldbasis", "=", 
          RowBox[{"otherBasis", "[", 
           RowBox[{"change", ",", "basisname"}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Check", " ", "eoom"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Head", "[", "eoom", "]"}], "=!=", "List"}], "||", 
          RowBox[{
           RowBox[{"Length", "[", "eoom", "]"}], "=!=", "2"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Throw", "@", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"DefBasis", "::", "invalid"}], ",", "eoom", 
             ",", "\"\<value for option epsilonOrientationOfMetric\>\""}], 
            "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"eoom", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "=!=", "Null"}], "&&", 
          RowBox[{"!", 
           RowBox[{"MetricQ", "[", 
            RowBox[{"eoom", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Throw", "@", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"DefBasis", "::", "unknown"}], ",", "\"\<metric\>\"", ",", 
             RowBox[{"eoom", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"**", 
         RowBox[{"*", " ", "Define", " ", "basis"}]}], " ", "****)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"xAct`xTensor`Private`MakeDefInfo", "[", 
        RowBox[{"DefBasis", ",", "basisname", ",", "info"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{
        "DefBasis", ",", "\"\<Beginning\>\"", ",", "basisname", ",", 
         "vbundle", ",", "cnumbers", ",", "options"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Register", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"$Bases", ",", "basisname"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"BasisQ", "[", "basisname", "]"}], "^=", "True"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"BasisColor", "[", "basisname", "]"}], "^=", "bc"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"VBundleOfBasis", "[", "basisname", "]"}], "^=", "vbundle"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"basisname", "/:", 
        RowBox[{"CNumbersOf", "[", 
         RowBox[{"basisname", ",", "vbundle"}], "]"}], "=", 
        RowBox[{"Sort", "@", "cnumbers"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"etaOrientation", "[", "basisname", "]"}], "^=", 
        RowBox[{"Signature", "[", "cnumbers", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"eoom", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "=!=", "Null"}], ",", 
         RowBox[{"basisname", "/:", 
          RowBox[{"epsilonOrientation", "[", 
           RowBox[{
            RowBox[{"eoom", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "basisname"}], "]"}], "=", 
          RowBox[{"eoom", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"DependenciesOfBasis", "[", "basisname", "]"}], "^=", 
        "deps"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"DefInfo", "[", "basisname", "]"}], "^=", "info"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
        RowBox[{"basisname", ",", "master", ",", 
         RowBox[{"{", "vbundle", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "Define", " ", "associated", " ", "parallel", " ", "derivative"}], ",",
          " ", 
         RowBox[{"always", " ", "real"}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"tbundle", "=", 
        RowBox[{"TangentBundleOfManifold", "[", "manifold", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"With", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"indtng", "=", 
            RowBox[{"First", "@", 
             RowBox[{"GetIndicesOfVBundle", "[", 
              RowBox[{"tbundle", ",", "1"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"pdbasis", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"HasDaggerCharacterQ", "[", "basisname", "]"}], ",", 
              RowBox[{"PDOfBasis", "[", 
               RowBox[{"Dagger", "[", "basisname", "]"}], "]"}], ",", 
              RowBox[{"GiveSymbol", "[", 
               RowBox[{"PD", ",", "basisname"}], "]"}]}], "]"}]}]}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"PDOfBasis", "[", "basisname", "]"}], "^=", "pdbasis"}], ";",
           "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"dag", "=!=", "Conjugate"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"Quiet", " ", 
              RowBox[{"OptionValue", "::", "nodef"}], " ", "because", " ", 
              "we", " ", "are", " ", "passing", " ", 
              RowBox[{"DefBasis", "/", "DefChart"}], " ", "options"}], " ", 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Quiet", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"DefCovD", "[", 
                RowBox[{
                 RowBox[{"pdbasis", "[", 
                  RowBox[{"-", "indtng"}], "]"}], ",", "vbundle", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ColorString", "[", 
                    RowBox[{"$PDPostfixSymbol", ",", "bc"}], "]"}], ",", 
                   RowBox[{"ColorString", "[", 
                    RowBox[{"$PDPrefixSymbol", ",", "bc"}], "]"}]}], "}"}], ",", 
                 RowBox[{"Torsion", "\[RuleDelayed]", 
                  RowBox[{"Not", "@", 
                   RowBox[{"ChartQ", "[", "basisname", "]"}]}]}], ",", 
                 RowBox[{"Curvature", "\[Rule]", "False"}], ",", 
                 RowBox[{"Master", "\[Rule]", "basisname"}], ",", 
                 RowBox[{"ExtendedFrom", "\[Rule]", "covdef"}], ",", 
                 RowBox[{"DefInfo", "\[Rule]", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"info", "===", "False"}], ",", "False", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<parallel derivative\>\"", ",", "\"\<\>\""}], 
                    "}"}]}], "]"}]}], ",", "options"}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"OptionValue", "::", "nodef"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"Not", "@", 
                RowBox[{"ChartQ", "[", "basisname", "]"}]}], ",", 
               RowBox[{"With", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"torsion", "=", 
                   RowBox[{"Torsion", "[", "basisname", "]"}]}], "}"}], ",", 
                 RowBox[{"xAct`xTensor`Private`SetPrintAs", "[", 
                  RowBox[{"torsion", ",", 
                   RowBox[{"ColorString", "[", 
                    RowBox[{"\"\<T\>\"", ",", "bc"}], "]"}]}], "]"}]}], 
                "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"BasisOfCovD", "[", "pdbasis", "]"}], "^=", 
              "basisname"}], ";", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"dag", "===", "Complex"}], ",", 
               RowBox[{"Set", "[", 
                RowBox[{
                 RowBox[{"Evaluate", "[", 
                  RowBox[{"MakeDaggerSymbol", "[", "pdbasis", "]"}], "]"}], ",",
                  "pdbasis"}], "]"}]}], "]"}], " ", ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Parallel", " ", 
                RowBox[{"covd", "'"}], "s", " ", "can", " ", "become", " ", 
                "metric", " ", "covds", " ", "for", " ", "constant", " ", 
                "metrics"}], ",", " ", 
               RowBox[{
               "so", " ", "we", " ", "preemptively", " ", "set", " ", "these",
                 " ", "values"}]}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"RiemannDown", "[", "pdbasis", "]"}], "^=", "Zero"}], ";",
              "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Weyl", "[", "pdbasis", "]"}], "^=", "Zero"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Einstein", "[", "pdbasis", "]"}], "^=", "Zero"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"RicciScalar", "[", "pdbasis", "]"}], "^=", "Zero"}], 
             ";"}]}], "\[IndentingNewLine]", "]"}]}]}], " ", 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Store", " ", "positions", " ", "of", " ", "cnumbers"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"MapIndexed", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Set", "[", 
           RowBox[{
            RowBox[{"PNumber", "[", 
             RowBox[{"#1", ",", "basisname"}], "]"}], ",", 
            RowBox[{"First", "[", "#2", "]"}]}], "]"}], "&"}], ",", 
         RowBox[{"CNumbersOf", "[", 
          RowBox[{"basisname", ",", "vbundle"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MapIndexed", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Set", "[", 
           RowBox[{
            RowBox[{"PNumber", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"-", "basisname"}]}], "]"}], ",", 
            RowBox[{"First", "[", "#2", "]"}]}], "]"}], "&"}], ",", 
         RowBox[{"CNumbersOf", "[", 
          RowBox[{"basisname", ",", "vbundle"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Properties", " ", "of", " ", "basis", " ", "under", " ", "complex", " ",
          "conjugation"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Switch", "[", 
        RowBox[{"dag", ",", "\[IndentingNewLine]", "Real", ",", 
         RowBox[{
          RowBox[{"Dagger", "[", "basisname", "]"}], "^=", "basisname"}], ",",
          "\[IndentingNewLine]", "Conjugate", ",", "Null", ",", 
         "\[IndentingNewLine]", "Complex", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"xAct`xTensor`Private`SetDaggerPair", "[", 
           RowBox[{"basisname", ",", 
            RowBox[{"MakeDaggerSymbol", "[", "basisname", "]"}]}], "]"}], ";",
           "\[IndentingNewLine]", 
          RowBox[{"DefBasis", "[", 
           RowBox[{
            RowBox[{"Dagger", "[", "basisname", "]"}], ",", 
            RowBox[{"Dagger", "[", "vbundle", "]"}], ",", "cnumbers", ",", 
            RowBox[{"Dagger", "\[Rule]", "Conjugate"}], ",", 
            RowBox[{"Master", "\[Rule]", "basisname"}], ",", "options"}], 
           "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Register", " ", "change", " ", "of", " ", "basis"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"change", "=!=", "Null"}], ",", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ChartQ", "[", "oldbasis", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"SetBasisChange", "[", 
            RowBox[{"change", ",", "oldbasis"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"SetBasisChange", "[", "change", "]"}]}], 
          "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Store", " ", "values", " ", "of", " ", "components", " ", "of", " ", 
         "some", " ", "metric", " ", "in", " ", "this", " ", "basis"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"mb", "=!=", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"Apply", "[", 
          RowBox[{"MetricInBasis", ",", "mb"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Define", " ", "associated", " ", "eta", " ", "tensors"}], ",",
          " ", 
         RowBox[{"even", " ", "for", " ", "inner", " ", "vbundles"}]}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"defeta", "[", 
        RowBox[{"basisname", ",", "dag", ",", "info"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Format", " ", "bases", " ", "elements"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"fb", "=!=", "Automatic"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"!", 
             RowBox[{"MatchQ", "[", 
              RowBox[{"fb", ",", 
               RowBox[{"{", 
                RowBox[{"_List", ",", "_List"}], "}"}]}], "]"}]}], ",", 
            RowBox[{"Throw", "@", 
             RowBox[{"Message", "[", 
              RowBox[{
               RowBox[{"DefBasis", "::", "invalid"}], ",", "fb", 
               ",", "\"\<value for option FormatBasis\>\""}], "]"}]}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"FormatUpVectors", "[", 
           RowBox[{
            RowBox[{"fb", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"CIndicesOf", "[", 
             RowBox[{"-", "basisname"}], "]"}], ",", "scalars"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"FormatDownVectors", "[", 
           RowBox[{
            RowBox[{"fb", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"CIndicesOf", "[", "basisname", "]"}], ",", "scalars"}], 
           "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{
        "DefBasis", ",", "\"\<End\>\"", ",", "basisname", ",", "vbundle", ",",
          "cnumbers", ",", "options"}], "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"pns", ",", 
         RowBox[{"Protect", "[", "basisname", "]"}]}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1feb0124-e4fe-447e-a75d-83a93cea4bd9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefBasis", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DefBasis", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"9269265d-394f-47e5-8900-f18d909cebb2"],

Cell["\<\
Check the value of a basis change and return the \[OpenCurlyDoubleQuote]other \
basis\[CloseCurlyDoubleQuote]:\
\>", "Text",ExpressionUUID->"77d5bc16-ef74-487e-a264-aca2edff6df9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"otherBasis", "[", 
    RowBox[{"ctensor_CTensor", ",", "basis_"}], "]"}], ":=", 
   RowBox[{"If", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"CTensorQ", "[", 
      RowBox[{"ctensor", ",", "2", ",", "0"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"otherbasis", "[", 
      RowBox[{
       RowBox[{"CTensorBases", "[", "ctensor", "]"}], ",", "basis"}], "]"}], ",",
      "\[IndentingNewLine]", "$Failed"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"otherBasis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ctensor1_CTensor", ",", "ctensor2_CTensor"}], "}"}], ",", 
     "basis_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"obasis1", "=", 
        RowBox[{"otherBasis", "[", 
         RowBox[{"ctensor1", ",", "basis"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"obasis2", "=", 
        RowBox[{"otherBasis", "[", 
         RowBox[{"ctensor2", ",", "basis"}], "]"}]}]}], "\[IndentingNewLine]",
       "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"obasis1", "===", "obasis2"}], "&&", 
        RowBox[{"obasis1", "=!=", "$Failed"}], "&&", 
        RowBox[{
         RowBox[{"Reverse", "[", 
          RowBox[{"CTensorBases", "[", "ctensor1", "]"}], "]"}], "===", 
         RowBox[{"-", 
          RowBox[{"CTensorBases", "[", "ctensor2", "]"}]}]}]}], ",", 
       "\[IndentingNewLine]", "obasis1", ",", "\[IndentingNewLine]", 
       "$Failed"}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"otherBasis", "[", 
    RowBox[{"_", ",", "_"}], "]"}], ":=", "$Failed"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"bceda8b6-e649-4f32-91cd-ce112d6d9d28"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"otherbasis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "basis_"}], ",", 
       RowBox[{"b_", "?", "BasisQ"}]}], "}"}], ",", "basis_"}], "]"}], ":=", 
   "b"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"otherbasis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"basis_", ",", 
       RowBox[{"-", 
        RowBox[{"b_", "?", "BasisQ"}]}]}], "}"}], ",", "basis_"}], "]"}], ":=",
    "b"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"otherbasis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b_", "?", "BasisQ"}], ",", 
       RowBox[{"-", "basis_"}]}], "}"}], ",", "basis_"}], "]"}], ":=", "b"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"otherbasis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"b_", "?", "BasisQ"}]}], ",", "basis_"}], "}"}], ",", 
     "basis_"}], "]"}], ":=", "b"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"otherbasis", "[", 
    RowBox[{"_", ",", "_"}], "]"}], ":=", "False"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"798a430a-eb1c-41bf-b852-13aa2f277df4"],

Cell["Auxiliary:", \
"Text",ExpressionUUID->"3ae9f70f-7879-45d8-ab8e-e2a670da991d"],

Cell["1) Colors. The default value for colors is red:", \
"Text",ExpressionUUID->"60920964-a688-4bb0-b964-b787e6c30b60"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "BasisColor"}]], \
"Input",ExpressionUUID->"a831b66b-f401-4af7-b924-230f45da30a1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"BasisColor[basis] gives the color with which \
objects and indices associated to the given basis will be represented in \
StandardForm.\\n\\nBasisColor is also an option for DefBasis giving the color \
associated to the defined basis. The default value is red (RGBColor[1, 0, \
0]).\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`BasisColor\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"BasisColor[basis] gives the color with which \
objects and indices associated to the given basis will be represented in \
StandardForm.\\n\\nBasisColor is also an option for DefBasis giving the color \
associated to the defined basis. The default value is red (RGBColor[1, 0, \
0]).\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "BasisColor[basis] gives the color with which objects and indices \
associated to the given basis will be represented in StandardForm.\n\n\
BasisColor is also an option for DefBasis giving the color associated to the \
defined basis. The default value is red (RGBColor[1, 0, 0]).", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xCoba`BasisColor"|>, 
   False]]], "Output",ExpressionUUID->"989ffdc7-63e5-4b9e-a640-aed0235d765d"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasisColor", "[", "_", "]"}], ":=", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"BasisColor", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "BasisColor", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"971cba73-050d-4319-a9d2-d5188e22949d"],

Cell[TextData[{
 "BasisColor is a function which has been used in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", but even there already with xAct`xCoba` context:"
}], "Text",ExpressionUUID->"47f4bfd2-5eab-441e-aad1-7c14a3cb6c47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "BasisColor", 
  "]"}]], "Input",ExpressionUUID->"be6062d3-003b-4db5-a9cf-1dab29ba6670"],

Cell[BoxData["\<\"xAct`xCoba`\"\>"], \
"Output",ExpressionUUID->"6f43fae4-3431-4fa7-9834-41fdc3e3d229"]
}, Open  ]],

Cell["2) Parallel derivative of a basis:", \
"Text",ExpressionUUID->"47db2bba-8d0c-4886-aa51-c9c3502de1a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PDOfBasis"}]], \
"Input",ExpressionUUID->"f83f47cb-e96a-4b84-b68a-bfdda969065c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"PDOfBasis[basis] gives the parallel derivative \
associated to the given basis. If the basis is coordinated then (and only \
then) the derivative has no torsion and it can be called a partial derivative \
(ordinary derivative in Wald's book).\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`PDOfBasis\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"PDOfBasis[basis] gives the parallel derivative \
associated to the given basis. If the basis is coordinated then (and only \
then) the derivative has no torsion and it can be called a partial derivative \
(ordinary derivative in Wald's book).\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "PDOfBasis[basis] gives the parallel derivative associated to the given \
basis. If the basis is coordinated then (and only then) the derivative has no \
torsion and it can be called a partial derivative (ordinary derivative in \
Wald's book).", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xCoba`PDOfBasis"|>, 
   False]]], "Output",ExpressionUUID->"84a06274-619b-422e-8ae8-57455977316a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PDOfBasis", "[", 
    RowBox[{"-", "basis_"}], "]"}], ":=", 
   RowBox[{"PDOfBasis", "[", "basis", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PDOfBasis", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"PDOfBasis", "::", "unknown"}], ",", "\"\<basis\>\"", ",", 
      "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PDOfBasis", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PDOfBasis", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f8fb9ec5-d25d-44ea-a9aa-e2d534f2bbdb"],

Cell["3) Basis of a covd, if the covd is a parallel derivative:", \
"Text",ExpressionUUID->"f78baae0-90f0-4bff-8c24-14d679b42fe7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "BasisOfCovD"}]], \
"Input",ExpressionUUID->"5d9630bd-ca1c-40e4-9943-2e522fc74b37"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"BasisOfCovD[covd] for a basis-parallel derivative \
covd returns the basis to which covd is associated. If covd is not registered \
as parallel to a basis then it returns Null. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`BasisOfCovD\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"BasisOfCovD[covd] for a basis-parallel derivative \
covd returns the basis to which covd is associated. If covd is not registered \
as parallel to a basis then it returns Null. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "BasisOfCovD[covd] for a basis-parallel derivative covd returns the basis \
to which covd is associated. If covd is not registered as parallel to a basis \
then it returns Null. ", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xCoba`BasisOfCovD"|>, 
   False]]], "Output",ExpressionUUID->"fa154c08-2b3f-41c3-a0b8-b9aab5b7e418"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasisOfCovD", "[", "x_", "]"}], ":=", "Null"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"BasisOfCovD", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "BasisOfCovD", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a762f88b-cbbf-46f9-938c-78d4df0b27f0"],

Cell[TextData[{
 "4) Torsion of a basis. Note that what we call here Torsion[basis] is \
usually known as structure coefficients of the basis (with a minus sign). The \
definition for a coordinate basis must precede the definition for general \
bases. Recall that definitions for Torsion on covds have already been given \
in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"fd40384c-7707-49f9-b83d-5a4b5ffebbbe"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Torsion", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Torsion", "[", 
    RowBox[{"basis_", "?", "ChartQ"}], "]"}], ":=", "Zero"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Torsion", "[", 
    RowBox[{"basis_", "?", "BasisQ"}], "]"}], ":=", 
   RowBox[{"Torsion", "[", 
    RowBox[{"PDOfBasis", "[", "basis", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Torsion", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Torsion", "::", "error"}], ",", 
      RowBox[{"\"\<Cannot construct torsion tensor associated to \>\"", "<>", 
       
       RowBox[{"ToString", "[", "x", "]"}]}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Torsion", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Torsion", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3bd17edc-9c9c-48a8-a1cd-cca9c7d9b7c0"],

Cell["5) Bases in a vbundle:", \
"Text",ExpressionUUID->"1558675c-0f10-4a7c-ba1a-d1282170332d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasesOfVBundle", "[", "vb_", "]"}], ":=", 
   RowBox[{"Select", "[", 
    RowBox[{"$Bases", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"VBundleOfBasis", "[", "#", "]"}], "===", "vb"}], "&"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"BasesOfVBundle", ",", "1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "BasesOfVBundle", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"9ab83509-7f3d-4683-8bce-ff1d7d1ebf76"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1.2. UndefBasis", \
"Subsubsection",ExpressionUUID->"0fedd182-7f4c-4fdc-be22-c3f01db9de0b"],

Cell["\<\
Undefinition. There is an important problem here, and it is the fact the we \
should also undefine the definitions for the metric components in this basis. \
Those definitions are necessarily associated to the metric because they are \
too deep to be associated to the basis. However, it is not clear how to know \
which metric is being used for this. This is a case in which both metric and \
basis are required but both can exist without the other and so the \
host/visitor relation is not clear at all.\
\>", "Text",ExpressionUUID->"bf808b8e-abdd-412a-884a-8e46eb5900a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "UndefBasis"}]], \
"Input",ExpressionUUID->"dc1de58d-44a9-4e4c-840a-0d3574fa87e6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UndefBasis[basis] undefines the basis.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`UndefBasis\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"UndefBasis[basis] undefines the basis.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "UndefBasis[basis] undefines the basis.", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xCoba`UndefBasis"|>, 
   False]]], "Output",ExpressionUUID->"ef941f6d-b8c2-4914-b8e0-dd2abe6252c4"]
}, Open  ]],

Cell["\<\
Standard structure, with the single exception of the PDbasisdagger symbol (we \
use StringJoin instead of SymbolJoin to avoid evaluation of PDbasisdagger \
into PDbasis, which is not what we want to remove; similar thing happens with \
HasDaggerCharacterQ instead of DaggerQ).\
\>", "Text",ExpressionUUID->"925c0a21-78d5-40d3-bee3-d9fe7e8fefcc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UndefBasis", "[", "basis_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"servants", "=", 
       RowBox[{"ServantsOf", "[", "basis", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"BasisQ", "[", "basis", "]"}]}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"UndefBasis", "::", "unknown"}], ",", "\"\<basis\>\"", ",",
            "basis"}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`CheckRemoveSymbol", "[", "basis", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{"UndefBasis", ",", "\"\<Beginning\>\"", ",", "basis"}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"xUpSet", "[", 
       RowBox[{
        RowBox[{"ServantsOf", "[", "basis", "]"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`DropFromHosts", "[", "basis", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"$Bases", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"$Bases", ",", "basis"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Undef", "/@", "servants"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xUpDeleteCasesTo", "[", 
       RowBox[{
        RowBox[{"TensorValIDs", "[", "Basis", "]"}], ",", 
        RowBox[{"valid_", "/;", 
         RowBox[{"Not", "[", 
          RowBox[{"FreeQ", "[", 
           RowBox[{"valid", ",", "basis"}], "]"}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "For", " ", "complex", " ", "bases", " ", "we", " ", "need", " ", "to",
         " ", "remove", " ", "this", " ", "special", " ", 
        RowBox[{"definition", ".", " ", "This"}], " ", "is", " ", "ugly"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"HasDaggerCharacterQ", "[", "basis", "]"}], ",", 
        RowBox[{"xAct`xTensor`Private`RemoveSymbol", "[", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"\"\<PD\>\"", ",", 
           RowBox[{"ToString", "@", "basis"}]}], "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{"UndefBasis", ",", "\"\<End\>\"", ",", "basis"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`MakeUndefInfo", "[", 
       RowBox[{"UndefBasis", ",", "basis"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`RemoveSymbol", "[", "basis", "]"}], 
      ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"UndefBasis", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "UndefBasis", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"53fde826-a41a-409e-b732-065f1f5122e7"],

Cell["\<\
Note that UndefBasis automatically removes all Christoffel tensors in which \
the parallel derivative of the basis appears, but it does not remove the \
Jacobians, which must be undefined by hand before undefining the basis. The \
Christoffels are considered servants, but the Jacobians are considered \
visitors. QUESTION: Why is that?\
\>", "Text",ExpressionUUID->"33e2c060-c761-4eef-8695-91307e61acbd"]
}, Closed]],

Cell[CellGroupData[{

Cell["         Examples", \
"Subsubsection",ExpressionUUID->"3a9c602f-b9e9-4e1b-a031-93c08365ba67"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"89b8e834-de4c-4c2d-a1b8-08a63df1b638"],

Cell["Real basis:", \
"Text",ExpressionUUID->"195f8286-6790-4ce7-b37b-6c08281f05c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"cartesian", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"7a139b07-fece-417a-990d-2e54b9e13c31"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "cartesian", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`cartesian,
    ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"bea8cfde-b27f-412a-9336-b8868cd5891f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDcartesian", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDcartesian[-$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"ffaf584a-7e8a-43fe-bb2d-e543d9d20e73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDcartesian", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDcartesian[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"6d1279ad-1474-4697-a92f-b5ee6591e4bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcartesian", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDcartesian[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"4f19c94f-40fc-49ef-b194-a891bc76a361"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannPDcartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDcartesian[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"16c1f506-4ecf-41d6-8117-77f3d663c361"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciPDcartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDcartesian[-$CellContext`a, -$CellContext`b], ". ", ""],
  
  Editable->
   False]], "Print",ExpressionUUID->"5876ea05-d5b2-4280-927d-d591ab6fb3d1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefBasis", "[", "cartesian", 
  "]"}]], "Input",ExpressionUUID->"04223aaa-8199-4abd-a253-578137af4564"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", 
   " ", $CellContext`ChristoffelPDcartesian],
  Editable->
   False]], "Print",ExpressionUUID->"ac33f6fb-1021-4402-a40e-e0bb62b3625f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDcartesian],
  Editable->
   False]], "Print",ExpressionUUID->"beb520ab-13ff-4b3f-896e-b74e74bacfcc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "RiemannPDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDcartesian],
  Editable->
   False]], "Print",ExpressionUUID->"981de86f-bedb-4384-8848-413f1c0b58f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "TorsionPDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDcartesian],
  Editable->
   False]], "Print",ExpressionUUID->"42a72969-b16c-4d3f-9418-2716e9a4e79d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDcartesian"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDcartesian],
  Editable->
   False]], "Print",ExpressionUUID->"d4ea29e5-ac9d-458c-b74f-c857534ce189"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "cartesian"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`cartesian],
  Editable->
   False]], "Print",ExpressionUUID->"b2c22393-1658-4800-936f-786d05fb7555"]
}, Open  ]]
}, Open  ]],

Cell["Complex basis:", \
"Text",ExpressionUUID->"7765d585-7d3f-405f-89af-bf6f53246615"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"complex", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], 
  "]"}]], "Input",ExpressionUUID->"64fedd45-d03a-4031-8127-bfde0f50415d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "complex", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`complex, 
   ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"d51e28ef-ed5f-4e83-a098-1836aa911d42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDcomplex", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDcomplex[-$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"0704326d-44a6-4b35-9865-f49b50559615"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDcomplex", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDcomplex[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"27e67a11-71a0-4734-ab61-56e6eb6a49e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcomplex", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDcomplex[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"a56b2296-ac49-41fe-9cfc-d2aed505ef09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannPDcomplex", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDcomplex[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"125a2981-3863-49c9-a35a-c2ca409452df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciPDcomplex", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDcomplex[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e4c4ece8-7e39-48f6-ad14-2d1c0b84c817"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", 
   "complex\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", 
   "basis ", $CellContext`complex\[Dagger], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"28d42e0b-d6d2-4b61-a649-7b7aa87e1e34"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefBasis", "[", "complex", 
  "]"}]], "Input",ExpressionUUID->"09526b97-6890-4efc-a33b-6bc539782e03"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDcomplex],
  Editable->
   False]], "Print",ExpressionUUID->"24d08093-bfd2-4c15-9782-2315f9eec00d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDcomplex],
  Editable->
   False]], "Print",ExpressionUUID->"f003bc51-c8d4-468a-8f40-72667adf3c49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDcomplex],
  Editable->
   False]], "Print",ExpressionUUID->"e723570a-5524-468e-871d-a5dec28ffe89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDcomplex],
  Editable->
   False]], "Print",ExpressionUUID->"55ad8cbf-a78b-4548-98c3-a2ab7b50c498"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDcomplex"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDcomplex],
  Editable->
   False]], "Print",ExpressionUUID->"dbde864b-a2f6-462c-8fa8-e5b22f205fc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "complex\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`complex\[Dagger]],
  Editable->
   False]], "Print",ExpressionUUID->"39e9e91c-d7e6-426d-ac4e-3e4daa192fa0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "complex"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`complex],
  Editable->
   False]], "Print",ExpressionUUID->"c790ea77-790d-4466-a690-21fd6c8f2e0b"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"bd498d37-f8fc-4e3f-96b3-bc03d51e1683"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1.3. Bases and their duals", \
"Subsubsection",ExpressionUUID->"51d5c904-49de-4e36-9342-f1c98292daa0"],

Cell["\<\
1) Dependencies of a basis. These are handled through upvalues. Default \
definitions are given here:\
\>", "Text",ExpressionUUID->"305761fd-4389-4f83-80a7-c6b2aa3478dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DependenciesOfBasis"}]], \
"Input",ExpressionUUID->"6e67db65-9bd7-4268-8b17-ea15f08ebd44"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DependenciesOf[basis] gives the list of \
dependencies (manifolds and/or parameters) of basis.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`DependenciesOfBasis\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DependenciesOf[basis] gives the list of \
dependencies (manifolds and/or parameters) of basis.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DependenciesOf[basis] gives the list of dependencies (manifolds and/or \
parameters) of basis.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xCoba`DependenciesOfBasis"|>, 
   False]]], "Output",ExpressionUUID->"8cf21560-fff6-489a-aa3a-030fdb29da95"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfBasis", "[", 
    RowBox[{"-", "basis_"}], "]"}], ":=", 
   RowBox[{"DependenciesOfBasis", "[", "basis", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfBasis", "[", "basis_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"DependenciesOfBasis", "::", "unknown"}], ",", "\"\<basis\>\"", 
      ",", "basis"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DependenciesOfBasis", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DependenciesOfBasis", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cf2880f7-431a-4512-90f8-30b75181c86b"],

Cell["\<\
2) Very important definition. This is our choice of using the same cnumbers \
on the basis and its dual:\
\>", "Text",ExpressionUUID->"2414c092-e285-40ee-9f85-664d213e4cd3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "CNumbersOf"}]], \
"Input",ExpressionUUID->"f5469ab2-d756-4bf8-9eac-6999e49c71f6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"CNumbersOf[basis, svb] returns the sublist of \
integer cnumbers associated to basis on the subvbundle svb. CNumbersOf[basis] \
is converted into CNumbersOf[basis, VBundleOfBasis[basis]].\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`CNumbersOf\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"CNumbersOf[basis, svb] returns the sublist of \
integer cnumbers associated to basis on the subvbundle svb. CNumbersOf[basis] \
is converted into CNumbersOf[basis, VBundleOfBasis[basis]].\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "CNumbersOf[basis, svb] returns the sublist of integer cnumbers \
associated to basis on the subvbundle svb. CNumbersOf[basis] is converted \
into CNumbersOf[basis, VBundleOfBasis[basis]].", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xCoba`CNumbersOf"|>, 
   False]]], "Output",ExpressionUUID->"f102af9a-231c-45ee-b54d-c53e473e505d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Standard", " ", "use"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CNumbersOf", "[", "basis_", "]"}], ":=", 
     RowBox[{"CNumbersOf", "[", 
      RowBox[{"basis", ",", 
       RowBox[{"VBundleOfBasis", "[", "basis", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Extended", " ", "use", " ", "from", " ", "0.7", ".0"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CNumbersOf", "[", 
      RowBox[{
       RowBox[{"-", "basis_"}], ",", "vbundle_"}], "]"}], ":=", 
     RowBox[{"CNumbersOf", "[", 
      RowBox[{"basis", ",", "vbundle"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CNumbersOf", "[", 
      RowBox[{"basis_", ",", 
       RowBox[{"-", "vbundle_"}]}], "]"}], ":=", 
     RowBox[{"CNumbersOf", "[", 
      RowBox[{"basis", ",", "vbundle"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CNumbersOf", "[", 
      RowBox[{"basis_", ",", "vbundle_"}], "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"CNumbersOf", "::", "unknown"}], 
        ",", "\"\<cnumbers of basis\>\"", ",", "basis"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"CNumbersOf", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Protect", "[", "CNumbersOf", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e2f0c9ba-d188-44d2-81e9-b1c7f7e62375"],

Cell["\<\
Convert back from cnumbers to positions in the list of cnumbers:\
\>", "Text",ExpressionUUID->"d5b6e533-08e8-4aa6-9c1d-cc0fd61bafd2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PNumber", "[", 
    RowBox[{"cnumber_", ",", "basis_"}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"CNumbersOf", "::", "invalid"}], ",", "cnumber", ",", 
      RowBox[{"\"\<cnumber of basis \>\"", "<>", 
       RowBox[{"PrintAs", "[", "basis", "]"}]}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"19e8cec7-6127-4d2c-ab4d-1198ba3248c5"],

Cell["A simple but useful private function.", \
"Text",ExpressionUUID->"57dc565c-3b05-4fad-a15e-19aa30a1db53"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Standard", " ", "use"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CIndicesOf", "[", 
      RowBox[{"basis", ":", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"_", "?", "BasisQ"}], "|", 
         RowBox[{"-", 
          RowBox[{"_", "?", "BasisQ"}]}]}], ")"}]}], "]"}], ":=", 
     RowBox[{"Thread", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"CNumbersOf", "[", "basis", "]"}], ",", "basis"}], "}"}], 
      "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", "BASIS1", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Extended", " ", "use", " ", "from", " ", "0.7", ".0"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CIndicesOf", "[", 
      RowBox[{
       RowBox[{"basis", ":", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"_", "?", "BasisQ"}], "|", 
          RowBox[{"-", 
           RowBox[{"_", "?", "BasisQ"}]}]}], ")"}]}], ",", "vbundle_"}], 
      "]"}], ":=", 
     RowBox[{"Thread", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"CNumbersOf", "[", 
         RowBox[{"basis", ",", "vbundle"}], "]"}], ",", "basis"}], "}"}], 
      "]"}]}], ";"}], 
   RowBox[{"(*", " ", "BASIS1", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Sometimes", " ", "this", " ", "acts", " ", "on", " ", "label", " ", 
     RowBox[{"indices", ".", " ", "Then"}], " ", "we", " ", "need", " ", 
     "this", " ", "case"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CIndicesOf", "[", "expr_", "]"}], ":=", 
     RowBox[{"{", "expr", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CIndicesOf", "[", 
      RowBox[{"expr_", ",", "_"}], "]"}], ":=", 
     RowBox[{"{", "expr", "}"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c92dfdb5-1b83-4214-a07e-cd646b09beec"],

Cell[TextData[{
 "3) Another important definition. This, however, should have a minus sign on \
the RHS, but that interferes too much with the current design of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", mostly because we would need to implement the parallel change in \
VBundleOfIndex, and so we keep it like this for the moment, but probably will \
be changed in the future. This function cannot throw an error because it is \
used by BIndexQ, which must always return a Boolean."
}], "Text",ExpressionUUID->"6ffd3257-3fb2-48e4-9211-5c39f496aecc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "VBundleOfBasis"}]], \
"Input",ExpressionUUID->"af9dd71a-bd11-4cb1-841e-27969c537270"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"VBundleOfBasis[basis] gives the vbundle on which \
basis lives.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`VBundleOfBasis\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"VBundleOfBasis[basis] gives the vbundle on which \
basis lives.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "VBundleOfBasis[basis] gives the vbundle on which basis lives.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xCoba`VBundleOfBasis"|>, 
   False]]], "Output",ExpressionUUID->"cdd6ea54-cd72-4857-a87b-c3b1a0b78a06"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VBundleOfBasis", "[", 
    RowBox[{"-", "basis_"}], "]"}], ":=", 
   RowBox[{"VBundleOfBasis", "[", "basis", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"VBundleOfBasis", ",", "1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "VBundleOfBasis", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"36cb2557-8aa1-42c3-ab76-6e470a1f158f"],

Cell["Define the private version keeping signs:", \
"Text",ExpressionUUID->"ea06e712-b8cb-4d86-b173-0ad4711904d3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SignedVBundleOfBasis", "[", 
    RowBox[{"-", "basis_"}], "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{"VBundleOfBasis", "[", "basis", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SignedVBundleOfBasis", "[", "basis_", "]"}], ":=", 
   RowBox[{"VBundleOfBasis", "[", "basis", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"842df5e2-0d51-486c-a1f7-965f2eceeac6"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1.4. SplitBasis and CirclePlus", \
"Subsubsection",ExpressionUUID->"a352e139-8584-4780-a975-0010c1c8f7c8"],

Cell["\<\
Break a basis along a vbundle decomposition. We do not check that we are \
supplying consistent information, in the sense of providing cnumbers for all \
subvbundles, or disjoint lists of cnumbers.\
\>", "Text",ExpressionUUID->"58239d82-0218-41d7-9551-8bbbe0d08900"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SplitBasis", "[", 
    RowBox[{"basis_", ",", "vbrules_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"SplitBasis", "[", 
      RowBox[{"basis", ",", "#"}], "]"}], "&"}], "/@", "vbrules"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SplitBasis", "[", 
    RowBox[{"basis_", ",", 
     RowBox[{"vbundle_", "\[Rule]", "cnumbers_List"}]}], "]"}], ":=", 
   RowBox[{"TagSet", "[", 
    RowBox[{"basis", ",", 
     RowBox[{"CNumbersOf", "[", 
      RowBox[{"basis", ",", "vbundle"}], "]"}], ",", "cnumbers"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"SplitBasis", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "SplitBasis", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fe5fdb1e-d554-453c-8e95-14c64cffbc86"],

Cell["\<\
The CirclePlus basis. Note that CirclePlus[B1, B2] is a different basis from \
CirclePlus[B2, B1]. Note also that the vbundle of CirclePlus[B1, B2] is \
CirclePlus[vb1, vb2].\
\>", "Text",ExpressionUUID->"b1163c7a-adbd-4de8-81d7-84b28b348dbc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasisQ", "[", "basis_CirclePlus", "]"}], "^:=", 
   RowBox[{"And", "@@", 
    RowBox[{"(", 
     RowBox[{"BasisQ", "/@", 
      RowBox[{"List", "@@", "basis"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VBundleOfBasis", "[", "basis_CirclePlus", "]"}], "^:=", 
   RowBox[{"VBundleOfBasis", "/@", "basis"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfBasis", "[", "basis_CirclePlus", "]"}], "^:=", 
   RowBox[{"Union", "@@", 
    RowBox[{"(", 
     RowBox[{"DependenciesOfBasis", "/@", 
      RowBox[{"(", 
       RowBox[{"List", "@@", "basis"}], ")"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PDOfBasis", "[", "basis_CirclePlus", "]"}], "^:=", 
    RowBox[{"Throw", "@", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"PDOfBasis", "::", "error1"}], 
       ",", "\"\<Define the PD of the basis\>\"", ",", "basis"}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"TODO", ":", " ", 
    RowBox[{
    "do", " ", "something", " ", "better", " ", "than", " ", "just", " ", 
     "black"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BasisColor", "[", "basis_CirclePlus", "]"}], "^:=", 
    RowBox[{"GrayLevel", "[", "0", "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"TODO", ":", " ", 
    RowBox[{
    "this", " ", "is", " ", "problematic", " ", "if", " ", "cnumbers", " ", 
     "are", " ", "repeated"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CNumbersOf", "[", 
     RowBox[{"basis_CirclePlus", ",", "vb_"}], "]"}], "^:=", 
    RowBox[{"Join", "@@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"CNumbersOf", "[", 
         RowBox[{"#", ",", "vb"}], "]"}], "&"}], "/@", 
       RowBox[{"List", "@@", "basis"}]}], ")"}]}]}], ";"}], "  "}]}], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"9b649360-6aee-423b-9331-0a2e75fb4aac"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. The Basis tensor", \
"Subsection",ExpressionUUID->"517c7577-36d9-49da-bad9-634ced9fb08d"],

Cell[CellGroupData[{

Cell["2.2.1. Basic properties of Basis", \
"Subsubsection",ExpressionUUID->"4a95dd71-88f2-4330-bd97-20bc394ca015"],

Cell["\<\
Recall that Basis is formally equivalent to delta, and already defined as a \
tensor:\
\>", "Text",ExpressionUUID->"69af57f9-6cd9-45e0-8d26-1fb0e720b40c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "Basis"}]], "Input",ExpressionUUID->"62db09c3-fa39-472a-b165-1cc45c3ed8c4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Basis represents both the type and the tensor head \
for a basis vector/covector field.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"xTensorQ", "[", "Basis", "]"}], "^=", "True"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`Basis\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Basis represents both the type and the tensor head \
for a basis vector/covector field.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Basis represents both the type and the tensor head for a basis \
vector/covector field.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> 
    Information`InformationValueForm[
     UpValues, xAct`xTensor`Basis, {
      xAct`xTensor`xTensorQ[xAct`xTensor`Basis] -> True}], "DownValues" -> 
    None, "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "xAct`xTensor`Basis"|>, 
   True]]], "Output",ExpressionUUID->"c25f01db-2883-4753-82ae-9b65ad0c5bc8"]
}, Open  ]],

Cell[TextData[{
 "1) Main properties of Basis. It is considered in the system as a real \
tensor (even on complex vbundles because then the \"complexity\" is marked in \
the name of the basis). Starting version 0.7.0 we remove the old Orderless \
attribute. The dependencies of Basis are on its indices (and hence on the \
basisname through DependenciesOfBasis). SlotsOfTensor is not given; it is not \
used at all in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"d864c9ef-685c-4ccf-adcc-ed457a92b4c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "Basis", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"36630ff0-4192-4211-b16d-81065ffd2e2f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"xTensorQ", "[", "Basis", "]"}], " ", "is", " ", "already", " ", 
     "defined", " ", "in", " ", "xTensor"}], ",", " ", 
    RowBox[{"but", " ", "we", " ", "repeat", " ", "it", " ", "here"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xTensorQ", "[", "Basis", "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", "Basis", "]"}], "^=", "Basis"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAs", "[", "Basis", "]"}], "^=", "\"\<e\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DependenciesOfTensor", "[", "Basis", "]"}], "^:=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SlotsOfTensor", "[", "Basis", "]"}], "^:=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "All"}], ",", "All"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MasterOf", "[", "Basis", "]"}], "^=", "Symbol"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "symmetry", " ", "of", " ", "Basis", " ", "depends", " ", 
     "on", " ", "the", " ", "existence", " ", "and", " ", "properties", " ", 
     "of", " ", "a", " ", "metric"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SymmetryGroupOfTensor", "[", 
      RowBox[{"Basis", "[", 
       RowBox[{"a_", ",", "b_"}], "]"}], "]"}], "^:=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"metric", "=", 
         RowBox[{"xAct`xTensor`Private`FirstMetricOfVBundle", "[", 
          RowBox[{
           RowBox[{"VBundleOfIndex", "[", "a", "]"}], ",", "False"}], "]"}]}],
         "}"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"metric", "===", "Null"}], ",", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
         RowBox[{"SymmetryGroupOfTensor", "[", "metric", "]"}]}], "]"}]}], 
      "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"81978bbe-e7ae-4fa0-8517-defbd9204bd0"],

Cell["\<\
2) Brackets. The bracket of two Basis contravariant vector fields is \
automatically converted into a torsion tensor. Note the minus sign in front \
of the torsion tensor.\
\>", "Text",ExpressionUUID->"c9b9f81f-6d25-48e2-a560-33c4a5ecec4e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"BASIS1", " ", "and", " ", "BASIS2"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Bracket", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Basis", "[", 
        RowBox[{
         RowBox[{"i1", ":", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"_", ",", 
              RowBox[{"-", "basis_"}]}], "}"}], "|", 
            RowBox[{"-", 
             RowBox[{"basis_", "[", "_", "]"}]}]}], ")"}]}], ",", 
         "a_Symbol"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Basis", "[", 
        RowBox[{
         RowBox[{"i2", ":", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"_", ",", 
              RowBox[{"-", "basis_"}]}], "}"}], "|", 
            RowBox[{"-", 
             RowBox[{
              RowBox[{"basis_", "?", "BasisQ"}], "[", "_", "]"}]}]}], ")"}]}],
          ",", "b_Symbol"}], "]"}]}], "\[IndentingNewLine]", "]"}], "[", "i_",
      "]"}], ":=", 
    RowBox[{
     RowBox[{"-", "$TorsionSign"}], " ", 
     RowBox[{
      RowBox[{"Torsion", "[", "basis", "]"}], "[", 
      RowBox[{"i", ",", "i1", ",", "i2"}], "]"}]}]}], ";"}], " "}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e81ebf74-583c-40a7-865a-653cf1d58bc9"],

Cell["\<\
3) Conversion of Basis into other objects. As a two-abstract-indices tensor, \
Basis is automatically translated into the corresponding delta. There is no \
check of equality of vbundles of indices a, b.\
\>", "Text",ExpressionUUID->"19999643-c4ee-44d6-9e5f-4c60e794beba"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a_Symbol"}], ",", "b_Symbol"}], "]"}], ":=", 
   RowBox[{"delta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b5b73177-c526-4ba3-acdd-0902c40e30b8"],

Cell["\<\
Metric-inverted Basis. SymmetryOfIndex[a] gives a sign determined by the \
symmetry of the first metric of the vbundle of the index a. This now plays \
the role of the old Orderless attribute:\
\>", "Text",ExpressionUUID->"be1ac61c-732b-436b-a986-5bfd6c322a00"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{"a_Symbol", ",", 
     RowBox[{"b_", "?", "DownIndexQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`SymmetryOfIndex", "[", "a", "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"b", ",", "a"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"a", ":", 
      RowBox[{"{", 
       RowBox[{"_", ",", 
        RowBox[{"_", "?", "BasisQ"}]}], "}"}]}], ",", 
     RowBox[{"b_", "?", "DownIndexQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`SymmetryOfIndex", "[", "a", "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"b", ",", "a"}], "]"}]}]}], ";", 
  RowBox[{"(*", " ", "BASIS1", " ", "*)"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"a", ":", 
      RowBox[{
       RowBox[{"_", "?", "BasisQ"}], "[", "_", "]"}]}], ",", 
     RowBox[{"b_", "?", "DownIndexQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"xAct`xTensor`Private`SymmetryOfIndex", "[", "a", "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"b", ",", "a"}], "]"}]}]}], ";", 
  RowBox[{"(*", " ", "BASIS2", " ", "*)"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fb2ddfdf-f474-48e3-a41e-0393d333b452"],

Cell["\<\
With two upper or two lower indices Basis is converted into a metric object. \
Pattern-indices are not considered. Again, there is no consistency check on \
the vbundles of the indices:\
\>", "Text",ExpressionUUID->"d065fdda-67af-4522-a2bb-7ef56b3972eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "BASIS1", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"a", ":", 
        RowBox[{"(", 
         RowBox[{"_Symbol", "|", 
          RowBox[{"{", 
           RowBox[{"_", ",", 
            RowBox[{"_", "?", "BasisQ"}]}], "}"}]}], ")"}]}], ",", 
       RowBox[{"b", ":", 
        RowBox[{"(", 
         RowBox[{"_Symbol", "|", 
          RowBox[{"{", 
           RowBox[{"_", ",", 
            RowBox[{"_", "?", "BasisQ"}]}], "}"}]}], ")"}]}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"xAct`xTensor`Private`FirstMetricOfVBundle", "[", 
       RowBox[{
        RowBox[{"VBundleOfIndex", "[", "a", "]"}], ",", "True"}], "]"}], "[", 
      
      RowBox[{"a", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"a", ":", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "_Symbol"}], "|", 
          RowBox[{"{", 
           RowBox[{"_", ",", 
            RowBox[{"-", 
             RowBox[{"_", "?", "BasisQ"}]}]}], "}"}]}], ")"}]}], ",", 
       RowBox[{"b", ":", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "_Symbol"}], "|", 
          RowBox[{"{", 
           RowBox[{"_", ",", 
            RowBox[{"-", 
             RowBox[{"_", "?", "BasisQ"}]}]}], "}"}]}], ")"}]}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"xAct`xTensor`Private`FirstMetricOfVBundle", "[", 
       RowBox[{
        RowBox[{"VBundleOfIndex", "[", "a", "]"}], ",", "True"}], "]"}], "[", 
      
      RowBox[{"a", ",", "b"}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3900c00b-1f58-4620-bd56-0bd5b7af1f02"],

Cell["\<\
These checks are continually performed on all Basis objects. They are fast \
enough. At least they do not show up in Trace. The key point is that the \
pattern {_,_} is identifying the b-indices; with a notation like polar[a] \
that wouldn't be possible because we would need to separate LI[a], Dir[v], \
etc somehow.\
\>", "Text",ExpressionUUID->"2cc461ea-e696-4921-acc1-c79d63a90928"],

Cell["\<\
With two component-indices of the same basis, we have a Kronecker delta:\
\>", "Text",ExpressionUUID->"292cdded-db8a-4936-86e5-f007c7e4637b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_Integer", ",", 
       RowBox[{"-", "basis_"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j_Integer", ",", "basis_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"KroneckerDelta", "[", 
    RowBox[{"i", ",", "j"}], "]"}]}], ";", " ", 
  RowBox[{"(*", " ", "BASIS1", " ", "*)"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5d5f7e0e-11f4-4a6e-8760-e5e52728e80b"],

Cell["\<\
Tracing basis gives the dimension of the vbundle. Note that the dimension is \
computed at evaluation time, and so if we change it the results will be then \
consistent with the new choice of dimension. Note also that if we change the \
length of the list CNumbersOf[basis, vbundle] the dimension is not implicitly \
updated accordingly:\
\>", "Text",ExpressionUUID->"684fb2fc-e2a0-4ef5-b5a6-2b5c78cef562"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a_Symbol"}], ",", 
        RowBox[{"-", "basis_"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a_Symbol", ",", "basis_"}], "}"}]}], "]"}], ":=", 
    RowBox[{"DimOfVBundle", "@", 
     RowBox[{"VBundleOfIndex", "[", "a", "]"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", "BASIS1", " ", "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a6a4c0d5-7ee5-4e2c-a99e-f3d950809764"],

Cell["4) Automatic contraction of the formal Kronecker deltas.", \
"Text",ExpressionUUID->"9c345049-483b-4a30-bfa4-2f1763d6b6d0"],

Cell["Former code, now deactivated:", \
"Text",ExpressionUUID->"546abb9f-5985-4f9c-af4d-5d7b7695fecb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Basis", "/:", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a_Symbol"}], ",", 
        RowBox[{"-", "basis_"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b_Symbol", ",", "basis_"}], "}"}]}], "]"}], "expr_"}], ":=", 
   RowBox[{
    RowBox[{"ReplaceIndex", "[", 
     RowBox[{"expr", ",", 
      RowBox[{
       RowBox[{"-", "b"}], "\[Rule]", 
       RowBox[{"-", "a"}]}]}], "]"}], "/;", 
    RowBox[{"IsIndexOf", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "basis"}]}], "}"}], ",", "Basis"}], "]"}]}]}], ";"}], "\[LineSeparator]", 
 RowBox[{
  RowBox[{"Basis", "/:", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a_Symbol"}], ",", 
        RowBox[{"-", "basis_"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b_Symbol", ",", "basis_"}], "}"}]}], "]"}], "expr_"}], ":=", 
   RowBox[{
    RowBox[{"ReplaceIndex", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"a", "\[Rule]", "b"}]}], "]"}], "/;", 
    RowBox[{"IsIndexOf", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "basis"}], "}"}], ",", "Basis"}], "]"}]}]}], 
  ";"}]}], "Input",
 Evaluatable->False,ExpressionUUID->"1b20ef84-b47e-403a-89dc-15b4736d4224"],

Cell["\<\
New code, based on Michael Trott's suggestion of hiding attributes:\
\>", "Text",ExpressionUUID->"be6f96a0-fa2b-4ecd-a44f-bffbc5987c4f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Basis", "/:", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f_Symbol", "/;", 
      RowBox[{"f", "===", "Times"}]}], ")"}], "[", 
    RowBox[{"expr1___", ",", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "a_Symbol"}], ",", 
         RowBox[{"-", "basis_"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b_Symbol", ",", "basis_"}], "}"}]}], "]"}], ",", 
     "expr2___"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"ReplaceIndex", "[", 
     RowBox[{
      RowBox[{"expr1", " ", "expr2"}], ",", 
      RowBox[{
       RowBox[{"-", "b"}], "\[Rule]", 
       RowBox[{"-", "a"}]}]}], "]"}], "/;", 
    RowBox[{"IsIndexOf", "[", 
     RowBox[{
      RowBox[{"expr1", " ", "expr2"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "basis"}]}], "}"}], ",", "Basis"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Basis", "/:", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f_Symbol", "/;", 
      RowBox[{"f", "===", "Times"}]}], ")"}], "[", 
    RowBox[{"expr1___", ",", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "a_Symbol"}], ",", 
         RowBox[{"-", "basis_"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b_Symbol", ",", "basis_"}], "}"}]}], "]"}], ",", 
     "expr2___"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"ReplaceIndex", "[", 
     RowBox[{
      RowBox[{"expr1", " ", "expr2"}], ",", 
      RowBox[{"a", "\[Rule]", "b"}]}], "]"}], "/;", 
    RowBox[{"IsIndexOf", "[", 
     RowBox[{
      RowBox[{"expr1", " ", "expr2"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "basis"}], "}"}], ",", "Basis"}], "]"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0811989f-9756-493e-bc75-753d911ae9d1"],

Cell["\<\
We should not include these two definitions in \
AutomaticBasisContractionStart/Stop because the user always expects this \
behaviour, as well as that of delta.\
\>", "Text",ExpressionUUID->"3c7ecfb1-5a31-49ab-b8d3-f290ca62ea1a"],

Cell["\<\
5) Dir and Basis are sort of inverse to each other. LI is not possible in a \
Basis object (not checked). Note the presence of delta in next cell: it \
checks existence of a metric in case both i and -ui have the same character.\
\>", "Text",ExpressionUUID->"623125dc-db5b-4b7e-86e9-6f74603b770b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Dir", "[", 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "a_Symbol"}], ",", "i_List"}], "]"}], "]"}], ":=", "i"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Dir", "[", 
     RowBox[{"Basis", "[", 
      RowBox[{"i_List", ",", "a_Symbol"}], "]"}], "]"}], ":=", "i"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"QUESTION", ":", " ", 
    RowBox[{
    "How", " ", "do", " ", "we", " ", "include", " ", "the", " ", "symmetry", 
     " ", "of", " ", "Basis", " ", 
     RowBox[{"here", "?"}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{"i_", ",", 
     RowBox[{"Dir", "[", "expr_", "]"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ui", "=", 
       RowBox[{"xAct`xTensor`Private`UltraindexOf", "[", 
        RowBox[{"Dir", "[", "expr", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"delta", "[", 
       RowBox[{
        RowBox[{"-", "ui"}], ",", "i"}], "]"}], ";", 
      RowBox[{"ReplaceIndex", "[", 
       RowBox[{"expr", ",", 
        RowBox[{"ui", "\[Rule]", "i"}]}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"Dir", "[", "expr_", "]"}], ",", "i_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ui", "=", 
       RowBox[{"xAct`xTensor`Private`UltraindexOf", "[", 
        RowBox[{"Dir", "[", "expr", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"delta", "[", 
       RowBox[{
        RowBox[{"-", "ui"}], ",", "i"}], "]"}], ";", 
      RowBox[{"ReplaceIndex", "[", 
       RowBox[{"expr", ",", 
        RowBox[{"ui", "\[Rule]", "i"}]}], "]"}]}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"bfcf7a78-27b5-4267-bec4-22c4db4e9d53"],

Cell["Now we can protect Basis:", \
"Text",ExpressionUUID->"75444826-3b7e-4da1-b60e-0079459623a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "Basis", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a0962537-340b-4a11-92f3-0fb5ee1c83ac"],

Cell["Finally, this is all we have defined about Basis:", \
"Text",ExpressionUUID->"4ca34120-5a61-47eb-a12b-b88e31d41be3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UpValues", "[", "Basis", "]"}], "//", 
  "Column"}]], "Input",ExpressionUUID->"e38fe48b-27bc-4fc5-9b9a-1273a778be9c"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       InterpretationBox[
        StyleBox[
         RowBox[{"Dagger", "[", "Basis", "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Dagger[xAct`xTensor`Basis],
        Editable->False], "]"}], "\[RuleDelayed]", "Basis"}]},
    {
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"DependenciesOfTensor", "[", "Basis", "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"{", "}"}]}]},
    {
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"MasterOf", "[", "Basis", "]"}], "]"}], "\[RuleDelayed]", 
      "Symbol"}]},
    {
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"PrintAs", "[", "Basis", "]"}], "]"}], 
      "\[RuleDelayed]", "\<\"e\"\>"}]},
    {
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"SlotsOfTensor", "[", "Basis", "]"}], "]"}], "\[RuleDelayed]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "All"}], ",", "All"}], "}"}]}]},
    {
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"xTensorQ", "[", "Basis", "]"}], "]"}], "\[RuleDelayed]", 
      "True"}]},
    {
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"SymmetryGroupOfTensor", "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"e", 
             StyleBox[GridBox[{
                {
                 UnderscriptBox["a", "_"], 
                 UnderscriptBox["b", "_"]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`Basis[
          Pattern[xAct`xCoba`Private`a, 
           Blank[]], 
          Pattern[xAct`xCoba`Private`b, 
           Blank[]]],
         Editable->False], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"metric", "=", 
          RowBox[{"xAct`xTensor`Private`FirstMetricOfVBundle", "[", 
           RowBox[{
            RowBox[{"VBundleOfIndex", "[", "a", "]"}], ",", "False"}], 
           "]"}]}], "}"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"metric", "===", "Null"}], ",", 
          RowBox[{"StrongGenSet", "[", 
           RowBox[{
            RowBox[{"{", "}"}], ",", 
            RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
          RowBox[{"SymmetryGroupOfTensor", "[", "metric", "]"}]}], "]"}]}], 
       "]"}]}]},
    {
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"f_Symbol", "/;", 
          RowBox[{"f", "===", "Times"}]}], ")"}], "[", 
        RowBox[{"expr1___", ",", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", 
                  StyleBox[
                   UnderscriptBox["b", "_"],
                   FontColor->RGBColor[1., 0., 0.]]},
                 {
                  StyleBox[
                   UnderscriptBox["a", "_"],
                   FontColor->RGBColor[1., 0., 0.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Basis[{-Pattern[xAct`xCoba`Private`a, 
              Blank[Symbol]], -Pattern[xAct`xCoba`Private`basis, 
              Blank[]]}, {
            Pattern[xAct`xCoba`Private`b, 
             Blank[Symbol]], 
            Pattern[xAct`xCoba`Private`basis, 
             Blank[]]}],
          Editable->False], ",", "expr2___"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"ReplaceIndex", "[", 
        RowBox[{
         RowBox[{"expr1", " ", "expr2"}], ",", 
         RowBox[{
          RowBox[{"-", "b"}], "\[Rule]", 
          RowBox[{"-", "a"}]}]}], "]"}], "/;", 
       RowBox[{"IsIndexOf", "[", 
        RowBox[{
         RowBox[{"expr1", " ", "expr2"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "b"}], ",", 
           RowBox[{"-", "basis"}]}], "}"}], ",", "Basis"}], "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"f_Symbol", "/;", 
          RowBox[{"f", "===", "Times"}]}], ")"}], "[", 
        RowBox[{"expr1___", ",", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"e", 
              StyleBox[GridBox[{
                 {" ", 
                  StyleBox[
                   UnderscriptBox["b", "_"],
                   FontColor->RGBColor[1., 0., 0.]]},
                 {
                  StyleBox[
                   UnderscriptBox["a", "_"],
                   FontColor->RGBColor[1., 0., 0.]], " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Basis[{-Pattern[xAct`xCoba`Private`a, 
              Blank[Symbol]], -Pattern[xAct`xCoba`Private`basis, 
              Blank[]]}, {
            Pattern[xAct`xCoba`Private`b, 
             Blank[Symbol]], 
            Pattern[xAct`xCoba`Private`basis, 
             Blank[]]}],
          Editable->False], ",", "expr2___"}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"ReplaceIndex", "[", 
        RowBox[{
         RowBox[{"expr1", " ", "expr2"}], ",", 
         RowBox[{"a", "\[Rule]", "b"}]}], "]"}], "/;", 
       RowBox[{"IsIndexOf", "[", 
        RowBox[{
         RowBox[{"expr1", " ", "expr2"}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", "basis"}], "}"}], ",", "Basis"}], "]"}]}]}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], \
"Output",ExpressionUUID->"b7b44ce3-0e0f-4ee1-98a6-92e7e02d9496"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2.2. FormatBasis", \
"Subsubsection",ExpressionUUID->"a65dee5b-6e2d-4d6e-9b94-2b9faaca617f"],

Cell["\<\
This function allows us to give particular names to the members of a vector \
basis:\
\>", "Text",ExpressionUUID->"5dc707c5-7adf-40f9-8cad-e2fdcc1c9baa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "FormatBasis"}]], \
"Input",ExpressionUUID->"11e745c8-7a6d-42e2-9646-9dc474319b10"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"FormatBasis[{i, -basis}, string] formats the basis \
vector Basis[{i, -basis}, a] as string[a], where i is one of the cnumbers \
compatible with basis. FormatBasis[{i, basis}, string] formats the basis \
covector Basis[-a, {i, basis}] as string[-a]. FormatBasis[CD[{i, -basis}], \
string] formats the given directional derivative as string. FormatBasis \
acting on only the first arguments of those cases removes the corresponding \
formatings.\\n\\nFormatBasis is also an option for DefBasis and DefChart \
specifying two lists of strings to format respectively the vectors and the \
covectors of the basis. For DefChart it is also possible to use \
\\\"Partials\\\" for vectors and/or \\\"Differentials\\\" for the covectors. \
The default value is Automatic.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`FormatBasis\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"FormatBasis[{i, -basis}, string] formats the basis \
vector Basis[{i, -basis}, a] as string[a], where i is one of the cnumbers \
compatible with basis. FormatBasis[{i, basis}, string] formats the basis \
covector Basis[-a, {i, basis}] as string[-a]. FormatBasis[CD[{i, -basis}], \
string] formats the given directional derivative as string. FormatBasis \
acting on only the first arguments of those cases removes the corresponding \
formatings.\\n\\nFormatBasis is also an option for DefBasis and DefChart \
specifying two lists of strings to format respectively the vectors and the \
covectors of the basis. For DefChart it is also possible to use \
\\\"Partials\\\" for vectors and/or \\\"Differentials\\\" for the covectors. \
The default value is Automatic.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "FormatBasis[{i, -basis}, string] formats the basis vector Basis[{i, \
-basis}, a] as string[a], where i is one of the cnumbers compatible with \
basis. FormatBasis[{i, basis}, string] formats the basis covector Basis[-a, \
{i, basis}] as string[-a]. FormatBasis[CD[{i, -basis}], string] formats the \
given directional derivative as string. FormatBasis acting on only the first \
arguments of those cases removes the corresponding formatings.\n\nFormatBasis \
is also an option for DefBasis and DefChart specifying two lists of strings \
to format respectively the vectors and the covectors of the basis. For \
DefChart it is also possible to use \"Partials\" for vectors and/or \
\"Differentials\" for the covectors. The default value is Automatic.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xCoba`FormatBasis"|>, 
   False]]], "Output",ExpressionUUID->"b7127386-4612-4e11-a573-202bb702851f"]
}, Open  ]],

Cell["\<\
We need to pass the {i,basis} index through With because of the \
HoldAllComplete attribute of MakeBoxes. As suggested by Alfonso, we do not \
extend the name to the dual vector, as we were doing before. It can still be \
given the same name if necessary with an independent call to FormatBasis.\
\>", "Text",ExpressionUUID->"2deac927-8c02-4119-a614-ef8d6dea50de"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"For", " ", "tensors"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"FormatBasis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_Integer", ",", 
         RowBox[{"basis_", "?", "BasisQ"}]}], "}"}], ",", "name_String"}], 
      "]"}], ":=", 
     RowBox[{"SetDelayed", "[", 
      RowBox[{
       RowBox[{"xAct`xTensor`Private`xTensorBox", "[", 
        RowBox[{"Basis", ",", 
         RowBox[{"{", 
          RowBox[{"ind_", ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "basis"}], "}"}]}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
        "xAct`xTensor`Private`MakeTensorBoxes", "[", "$TensorBoxes", "]"}], "[", 
        RowBox[{"name", ",", 
         RowBox[{
          RowBox[{
          "xAct`xTensor`Private`IndexArray", "[", "$TensorBoxes", "]"}], "[", 
          
          RowBox[{"{", "ind", "}"}], "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FormatBasis", "[", 
      RowBox[{"{", 
       RowBox[{"i_Integer", ",", 
        RowBox[{"basis_", "?", "BasisQ"}]}], "}"}], "]"}], ":=", 
     RowBox[{"Unset", "[", 
      RowBox[{"xAct`xTensor`Private`xTensorBox", "[", 
       RowBox[{"Basis", ",", 
        RowBox[{"{", 
         RowBox[{"ind_", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "basis"}], "}"}]}], "}"}]}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FormatBasis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_Integer", ",", 
         RowBox[{"-", 
          RowBox[{"basis_", "?", "BasisQ"}]}]}], "}"}], ",", "name_String"}], 
      "]"}], ":=", 
     RowBox[{"SetDelayed", "[", 
      RowBox[{
       RowBox[{"xAct`xTensor`Private`xTensorBox", "[", 
        RowBox[{"Basis", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"-", "basis"}]}], "}"}], ",", "ind_"}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
        "xAct`xTensor`Private`MakeTensorBoxes", "[", "$TensorBoxes", "]"}], "[", 
        RowBox[{"name", ",", 
         RowBox[{
          RowBox[{
          "xAct`xTensor`Private`IndexArray", "[", "$TensorBoxes", "]"}], "[", 
          
          RowBox[{"{", "ind", "}"}], "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FormatBasis", "[", 
      RowBox[{"{", 
       RowBox[{"i_Integer", ",", 
        RowBox[{"-", 
         RowBox[{"basis_", "?", "BasisQ"}]}]}], "}"}], "]"}], ":=", 
     RowBox[{"Unset", "[", 
      RowBox[{"xAct`xTensor`Private`xTensorBox", "[", 
       RowBox[{"Basis", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"-", "basis"}]}], "}"}], ",", "ind_"}], "}"}]}], "]"}], 
      "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1dff0410-62f6-4c48-a909-b9fe4c2c46ca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"For", " ", "derivatives"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"FormatBasis", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"covd_Symbol", "?", "CovDQ"}], "[", 
        RowBox[{"{", 
         RowBox[{"i_Integer", ",", 
          RowBox[{"-", 
           RowBox[{"basis_", "?", "BasisQ"}]}]}], "}"}], "]"}], ",", 
       "name_String"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"pattern", "=", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"-", "basis"}]}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MakeBoxes", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"covd", "[", "pattern", "]"}], "[", "expr_", "]"}], ",", 
          "StandardForm"}], "]"}], ":=", 
        RowBox[{"Block", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"$WarningFrom", "=", "\"\<CovD Formatting\>\""}], "}"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"covd", "[", "pattern", "]"}], "[", "expr", "]"}], ",", 
            RowBox[{"xAct`xTensor`Private`FlattenRowBox", "@", 
             RowBox[{"RowBox", "[", 
              RowBox[{"{", 
               RowBox[{"name", ",", 
                RowBox[{"xAct`xTensor`Private`boxof", "@", 
                 RowBox[{"MakeBoxes", "[", 
                  RowBox[{"expr", ",", "StandardForm"}], "]"}]}]}], "}"}], 
              "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FormatBasis", "[", 
      RowBox[{
       RowBox[{"covd_Symbol", "?", "CovD"}], "[", 
       RowBox[{"{", 
        RowBox[{"i_Integer", ",", 
         RowBox[{"-", 
          RowBox[{"basis_", "?", "BasisQ"}]}]}], "}"}], "]"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"pattern", "=", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"-", "basis"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"Unset", "[", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"covd", "[", "pattern", "]"}], "[", "expr_", "]"}], ",", 
          "StandardForm"}], "]"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"FormatBasis", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Protect", "[", "FormatBasis", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"99f8361d-ebbb-4506-b52b-5ccaec23b4f3"],

Cell["\<\
Note: there is a stupid problem since Mathematica 6.0. The rules to reorder \
definitions have been changed and now the FormatBasis definitions for \
MakeBoxes do not get reordered before the default xTensorForm definitions. It \
is necessary to stop them before using FormatBasis and then restart them.\
\>", "Text",ExpressionUUID->"81cd2fb1-0881-47a5-a118-cdfe7951d0fc"]
}, Closed]],

Cell[CellGroupData[{

Cell["         Examples", \
"Subsubsection",ExpressionUUID->"c9b6b1a0-0160-4fc3-9e32-c0610f25fa49"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"119799df-756d-46e1-99bb-3cb8d498fa19"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasisQ", "[", "polar", "]"}], "^=", "True"}], 
  ";"}]], "Input",ExpressionUUID->"a344fe0a-0fb3-48e8-ad90-b0f710bd3c92"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasisQ", "[", "cartesian", "]"}], "^=", "True"}], 
  ";"}]], "Input",ExpressionUUID->"cbfb6551-d915-4dbc-b201-06f7125268fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasisColor", "[", "cartesian", "]"}], "^=", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"7e20d74c-26ff-48cd-8de5-05c52c75e6d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"51dd6cc1-7c14-4bf5-90ad-880c44e36450"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]]},
         {"a", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
  Editable->
   False]], "Output",ExpressionUUID->"f138713f-9ec9-4690-a3d4-e02457599103"]
}, Open  ]],

Cell["Format for one of the vectors:", \
"Text",ExpressionUUID->"e452ced9-0fa9-4280-8548-d9a29e6ca21e"],

Cell[BoxData[
 RowBox[{"FormatBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", "\"\<o\>\""}], 
  "]"}]], "Input",ExpressionUUID->"4b30c1c5-6014-4df1-a88b-8b7e1f62112e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"da7837df-0c92-47d1-8d80-d44d79f6e2e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"o", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"c92df1fe-553f-4a71-9ec8-be07547b6dde"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Basis", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"80f02dd6-ceb4-4dde-93d4-f7e85b122465"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"0912ed27-e208-4e8d-bb6a-8309b3411e4a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Basis", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"abfd6950-004e-474e-a441-6cd3309c98a6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
       1, $CellContext`polar}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
       2, $CellContext`polar}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
       1, $CellContext`polar}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
       2, $CellContext`polar}],
      Editable->False]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"eece5600-27c5-48a3-a747-7bac02a03c57"]
}, Open  ]],

Cell["Format for the other vector:", \
"Text",ExpressionUUID->"2db853ce-470d-409d-b6a1-f0c50fb3dc7a"],

Cell[BoxData[
 RowBox[{"FormatBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "polar"}], "}"}], ",", "\"\<i\>\""}], 
  "]"}]], "Input",ExpressionUUID->"726ebb64-2dd5-40a3-aead-3df78223fe74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"ffc2ac95-8066-4788-a39a-7ed2abeaf87d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"o", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"i", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"c8ceaff7-3102-4adb-ae43-cf3e347bf440"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Basis", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"45904f35-e725-4253-a9da-61f8873b2056"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"d81aedac-f69d-4d67-8747-0de09578bf8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Basis", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"b3396bc0-a4b4-475a-97dc-e8c361cad0aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
       1, $CellContext`polar}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"i", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {
       2, $CellContext`polar}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"o", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
       1, $CellContext`polar}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"i", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{2, -$CellContext`cartesian}, {
       2, $CellContext`polar}],
      Editable->False]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"f7a72962-3ec5-469e-97db-e59b4593e11f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Basis", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "cartesian"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "cartesian"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"290e0082-1b97-4e4d-9b27-ac02f81cd6bb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{1, -$CellContext`polar}, {
       1, $CellContext`cartesian}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]},
             {
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{1, -$CellContext`polar}, {
       2, $CellContext`cartesian}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{2, -$CellContext`polar}, {
       1, $CellContext`cartesian}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]]},
             {
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{2, -$CellContext`polar}, {
       2, $CellContext`cartesian}],
      Editable->False]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"d8ef1902-4ec9-4f6e-bd9c-7dbb222aed9a"]
}, Open  ]],

Cell["Format for the duals:", \
"Text",ExpressionUUID->"f26274b2-6a81-415e-8c38-0fdc4bb88bf0"],

Cell[BoxData[
 RowBox[{"FormatBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", "\"\<O\>\""}], 
  "]"}]], "Input",ExpressionUUID->"62ed8ca1-6996-4247-b2ba-ae5c9e62c7db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"459559ae-b913-486b-a739-7b505b9bf486"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"o", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"O", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"i", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"498daa04-f0c5-4e16-b882-7c0bb76548c6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"FormatBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", "\"\<I\>\""}], 
  "]"}]], "Input",ExpressionUUID->"f9055919-5341-44f2-80cc-e309388fff4a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"24677209-783b-4825-9829-da9bd6c2a367"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"o", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"O", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"i", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {2, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"I", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"db55f143-f12a-40d2-89da-9106a38900cb"]
}, Open  ]],

Cell["Remove formats:", \
"Text",ExpressionUUID->"cbb361cd-90ec-400c-890b-599716632585"],

Cell[BoxData[{
 RowBox[{"FormatBasis", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "polar"}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FormatBasis", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "polar"}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FormatBasis", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "polar"}]}], "}"}], "]"}], "\n", 
 RowBox[{"FormatBasis", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", 
    RowBox[{"-", "polar"}]}], "}"}], 
  "]"}]}], "Input",ExpressionUUID->"35419ebd-a489-4f18-ba0c-d540dc7b4be8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], ",", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "a"}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"53aac5af-53be-46cb-864e-1ec200a6e9ce"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"e52a10af-8010-47dd-b3e9-2a222205da68"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"cartesian", ",", "polar"}], 
  "]"}]], "Input",ExpressionUUID->"c7c22a22-181c-4e9c-9458-c2abdc5b66c2"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"738bd5dc-c8f6-46a4-8cc2-be6abe44ff7b"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2.3. BasisArray", \
"Subsubsection",ExpressionUUID->"09c3a697-10e3-4465-ab21-a1b7ea750c8a"],

Cell["\<\
This function generates the list of (covariant or contravariant) basis \
vectors of a given basis. In case we have several indices and several bases, \
the outer product of the corresponding lists is given. In particular the \
depth of the final result is equal to the number of indices. If a single \
basis is given for several indices, then the same basis is assummed for all \
indices.\
\>", "Text",ExpressionUUID->"50b37cb6-ce27-41ef-a71e-7b0a38bb0f5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "BasisArray"}]], \
"Input",ExpressionUUID->"0f80ef9b-7cf5-4f16-9e7d-ddf7dc8e4446"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"BasisArray[basis1, basis2, ...][i1, i2, ...] \
generates the array of Basis objects with a-indices i1, i2, ... and the \
c-indices corresponding to the respective bases. The depth of the array is \
the number of a-indices. If all bases coincide then it is possible to write a \
single basis.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`BasisArray\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"BasisArray[basis1, basis2, ...][i1, i2, ...] \
generates the array of Basis objects with a-indices i1, i2, ... and the \
c-indices corresponding to the respective bases. The depth of the array is \
the number of a-indices. If all bases coincide then it is possible to write a \
single basis.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "BasisArray[basis1, basis2, ...][i1, i2, ...] generates the array of \
Basis objects with a-indices i1, i2, ... and the c-indices corresponding to \
the respective bases. The depth of the array is the number of a-indices. If \
all bases coincide then it is possible to write a single basis.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xCoba`BasisArray"|>, 
   False]]], "Output",ExpressionUUID->"5839e0e8-670b-4477-a59b-9bdd91f05f94"]
}, Open  ]],

Cell["Here we could use CIndicesOf, but there is no clear gain:", \
"Text",ExpressionUUID->"2724c7d7-b0d5-4e5a-8ddb-c8dd499821c6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BasisArray", "[", "]"}], "[", "]"}], ":=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BasisArray", "[", "]"}], "[", "a_", "]"}], ":=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BasisArray", "[", 
     RowBox[{"-", 
      RowBox[{"basis_", "?", "BasisQ"}]}], "]"}], "[", "inds___", "]"}], ":=", 
   RowBox[{
    RowBox[{"BasisArray", "[", "basis", "]"}], "[", "inds", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BasisArray", "[", 
     RowBox[{"basis_", "?", "BasisQ"}], "]"}], "[", 
    RowBox[{"a_", "?", "UpIndexQ"}], "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Basis", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", 
          RowBox[{"-", "basis"}]}], "}"}], ",", "a"}], "]"}], "&"}], ",", 
     RowBox[{"CNumbersOf", "[", 
      RowBox[{"basis", ",", 
       RowBox[{"VBundleOfIndex", "[", "a", "]"}]}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BasisArray", "[", 
     RowBox[{"basis_", "?", "BasisQ"}], "]"}], "[", 
    RowBox[{"a_", "?", "DownIndexQ"}], "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Basis", "[", 
       RowBox[{"a", ",", 
        RowBox[{"{", 
         RowBox[{"#", ",", "basis"}], "}"}]}], "]"}], "&"}], ",", 
     RowBox[{"CNumbersOf", "[", 
      RowBox[{"basis", ",", 
       RowBox[{"VBundleOfIndex", "[", "a", "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BasisArray", "[", "bases__", "]"}], "[", "indices__", "]"}], ":=", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"{", "bases", "}"}], "]"}], "\[Equal]", 
      RowBox[{"Length", "[", 
       RowBox[{"{", "indices", "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Outer", "[", 
      RowBox[{"Times", ",", 
       RowBox[{"Inner", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"BasisArray", "[", "#1", "]"}], "[", "#2", "]"}], "&"}], ",", 
         RowBox[{"IndexList", "[", "bases", "]"}], ",", 
         RowBox[{"IndexList", "[", "indices", "]"}], ",", "Sequence"}], 
        "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"{", "bases", "}"}], "]"}], "\[Equal]", "1"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Apply", "[", 
       RowBox[{"BasisArray", ",", 
        RowBox[{"Table", "[", 
         RowBox[{"bases", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", 
            RowBox[{"{", "indices", "}"}], "]"}], "}"}]}], "]"}]}], "]"}], "[",
       "indices", "]"}], ",", "\[IndentingNewLine]", "True", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"BasisArray", "::", "error"}], 
        ",", "\"\<Inconsistent number of bases and indices.\>\""}], "]"}]}]}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "BasisArray", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a3776931-53d4-4cca-b339-45d0233c45d0"],

Cell["\<\
The notation BasisArray[polar,polar][-a,b] is not very nice, but the simpler \
notation BasisArray[{-a,-polar},{b,polar}] could be misleading, because it \
suggests that an object with basis indices will be produced, but the truth is \
that an object with abstract indices will be produced. The former allows the \
nice case BasisArray[polar][a,-b,c,d,e,f]. Note that the signs of bases are \
not relevant (any -basis is converted into basis), because the relevant \
information is in the indices; this is ugly but simple and practical.\
\>", "Text",ExpressionUUID->"fba4e102-5bd6-467a-83a7-71d65a4ee4d7"]
}, Closed]],

Cell[CellGroupData[{

Cell["         Examples", \
"Subsubsection",ExpressionUUID->"6466a7df-7c7b-427c-a1ee-ff7ee4f4d70f"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"9acf2ded-46e5-40ee-928d-5a75695ffa74"],

Cell["1) Definition of bases.", \
"Text",ExpressionUUID->"26f936a3-5bae-4910-b0e3-0d86674e0781"],

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"cartesian", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], ",", 
   RowBox[{"DefInfo", "\[Rule]", "False"}]}], 
  "]"}]], "Input",ExpressionUUID->"4d7e3c97-47df-4b53-9a52-a79285498f34"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"polar", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"1", ",", "0", ",", "0"}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"6ecdf4b6-eb06-424a-b613-aca09197c617"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "polar", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`polar, 
   ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"bf67f39b-d3d0-40b8-8daa-0719d1b974fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDpolar", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDpolar[-$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"0d1843f2-97a3-4c92-b1b8-1cc9d88798b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDpolar", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDpolar[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"d074db50-7b68-4aa3-bbd7-5dc58fd4dabc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDpolar", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDpolar[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"2d3accfc-8063-4a9c-a1b3-84e5314277ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannPDpolar", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDpolar[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"0db51c98-6087-4737-9d9f-252d9eaae910"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciPDpolar", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDpolar[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"9380f65f-c59c-40c9-ae53-474fedcec6ba"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", "b"}], 
  "]"}]], "Input",ExpressionUUID->"9e84713a-06e1-4833-861d-e2365f8c9b9a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Delta]", 
      StyleBox[GridBox[{
         {" ", "b"},
         {"a", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`delta[-$CellContext`a, $CellContext`b],
  Editable->
   False]], "Output",ExpressionUUID->"bde64ef7-2e48-403b-aeee-bc5795f9ddaf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "b"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"d1319d81-289b-4394-aedf-700ba89b1d49"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]]\\).\"", 2, 330, 3, 19678524296362999459, "Local", 
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"ea0606f3-4055-4ff8-9582-f20887565105"]
}, Open  ]],

Cell["\<\
Here there are two messages because VBundleOfIndex does not throw its message:\
\>", "Text",ExpressionUUID->"67f9b85f-a6af-4f8c-b8c0-9fba898a02a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{"u", ",", "v"}], 
   "]"}]}]], "Input",ExpressionUUID->"0557e316-e874-43a4-aa03-baa1a51933b3"],

Cell[BoxData[
 TemplateBox[{
  "VBundleOfIndex", "unknown", 
   "\"Unknown \\!\\(\\*RowBox[{\\\"\\\\\\\"index\\\\\\\"\\\"}]\\) \
\\!\\(\\*RowBox[{\\\"u\\\"}]\\).\"", 2, 331, 4, 19678524296362999459, "Local",
    "xAct`xTensor`VBundleOfIndex"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"709679e2-a9a6-49e5-ba10-e909fc647d42"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "unknown", 
   "\"Unknown \\!\\(\\*RowBox[{\\\"\\\\\\\"vbundle\\\\\\\"\\\"}]\\) \
\\!\\(\\*RowBox[{\\\"Null\\\"}]\\).\"", 2, 331, 5, 19678524296362999459, 
   "Local", "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"b86f14f9-c037-41b7-97db-ac2359331ac8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{"a", ",", "b"}], 
   "]"}]}]], "Input",ExpressionUUID->"8f6598ba-0412-4752-90b3-f31afa6a5c91"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]]\\).\"", 2, 332, 6, 19678524296362999459, "Local", 
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"aeabade0-dc69-4773-821c-8a2c64633879"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{"A", ",", "B"}], 
   "]"}]}]], "Input",ExpressionUUID->"ccb04c4f-4455-4965-a09e-7087ee027f89"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"InnerC\\\", Rule[AutoSpacing, False], \
Rule[ShowAutoStyles, False]], InnerC, Rule[Editable, False]]\\).\"", 2, 333, 
   7, 19678524296362999459, "Local", "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"1f85930f-1a86-4be1-917c-765053e99618"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "cartesian"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "cartesian"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"2d6eaa91-4f69-4295-b285-e97ca31413c3"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]]\\).\"", 2, 334, 8, 19678524296362999459, "Local", 
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"5c5c7612-df8f-4fa7-b06b-b451caecb123"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "cartesian"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "cartesian"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"0b27b547-4f1c-4228-a9b4-9d243509807b"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]]\\).\"", 2, 335, 9, 19678524296362999459, "Local", 
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"f69c1b17-bf13-4346-97d3-01b29cf68366"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "cartesian"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "cartesian"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"d5514748-adba-480b-8c1d-fce0ef5fc56c"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"29e98ce6-7e30-47d1-8ca6-47cb42edec63"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "cartesian"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "cartesian"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"23525b2a-099b-4a26-842a-dd6208f64fbd"],

Cell[BoxData["1"], \
"Output",ExpressionUUID->"2bda7b39-d039-4559-b0a5-e051ede8635a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "polar"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"666c1ba5-b4b1-428e-9e8b-65e65d85d48b"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"8ac0a28f-ef9b-4026-a765-cd87d1f6d27b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "cartesian"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "polar"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"1174f76a-8ae7-4b14-9347-0d2a143625d9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]]},
         {
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{1, -$CellContext`cartesian}, {2, $CellContext`polar}],
  Editable->
   False]], "Output",ExpressionUUID->"21d7840c-9ddc-4b99-ba5f-ae65998add5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "cartesian"}], "}"}]}], "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], ",", "c"}], 
   "]"}]}]], "Input",ExpressionUUID->"12f41333-dec7-481c-86f2-970622bc7dd9"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", 
           StyleBox["b",
            FontColor->RGBColor[0., 0., 1.]]},
          {"a", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[-$CellContext`a, {$CellContext`b, \
$CellContext`cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "c"},
          {
           StyleBox["b",
            FontColor->RGBColor[0., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{-$CellContext`b, -$CellContext`cartesian}, \
$CellContext`c],
   Editable->
    False]}]], "Output",ExpressionUUID->"32508a04-2290-4c0b-9791-4f2f95145faf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Dir", "[", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "cartesian"}], "}"}], ",", "b"}], "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"62a969cd-5dd1-4c59-9776-2d1ac4694368"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]]\\).\"", 2, 341, 10, 19678524296362999459, "Local", 
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"71c27bcf-49b0-4e4b-8ae0-e9d6e1fd3d02"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dir", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "cartesian"}], "}"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"23f2e630-5e59-46cb-9f78-3d24b9396027"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "cartesian"}], 
  "}"}]], "Output",ExpressionUUID->"923c7f2c-2552-45e4-9ee5-ea833ba29e21"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M"}], 
  "]"}]], "Input",ExpressionUUID->"ffad6532-a472-48f1-bdbe-90b4863c715c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"401f8d34-2225-4ac4-a650-fc7f5acd76cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "cartesian"}], "}"}], ",", 
    RowBox[{"Dir", "[", 
     RowBox[{"v", "[", "z", "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"57ca729d-8df3-4466-9902-794e949f68b2"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]]\\).\"", 2, 344, 11, 19678524296362999459, "Local", 
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"8e5c8fa4-7b1b-4a41-921c-90784281da20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"Dir", "[", 
    RowBox[{"v", "[", "z", "]"}], "]"}], ",", "a"}], 
  "]"}]], "Input",ExpressionUUID->"ba86dee0-51cf-4e29-9363-c2f16a41df47"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[$CellContext`a],
  Editable->
   False]], "Output",ExpressionUUID->"b5ecf9c3-89c9-4813-8bff-802a9639e21f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"Dir", "[", 
     RowBox[{"v", "[", 
      RowBox[{"-", "z"}], "]"}], "]"}], ",", "a"}], 
   "]"}]}]], "Input",ExpressionUUID->"e980fa9c-3e8b-452c-b6d7-67d071e5a588"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM, \
Rule[Editable, False]]\\).\"", 2, 346, 12, 19678524296362999459, "Local", 
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", \
"MSG",ExpressionUUID->"37dfb36f-c3a6-491c-a4d5-1289a23d3c92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], \
"Input",ExpressionUUID->"7873888a-2739-49c9-8b6f-94fa8f4b41b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"cartesian", ",", "polar"}], 
  "}"}]], "Output",ExpressionUUID->"e1fac6ae-b517-4a79-9874-38478b67967f"]
}, Open  ]],

Cell["\<\
Every Basis object is checked initially for possible conversions into metrics \
or deltas, but this does not appear in the trace:\
\>", "Text",ExpressionUUID->"8487f70f-3596-4e1d-85f1-8a30a689c49b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"87832856-158a-4ce1-b40f-164983742225"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]]},
         {"a", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
  Editable->
   False]], "Output",ExpressionUUID->"745e3288-22b0-425b-93b3-88fcfe0e9a13"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"c07cdfb6-cf32-4a4e-a960-d0a4654f319f"],

Cell[BoxData[
 RowBox[{"{", 
  "}"}]], "Output",ExpressionUUID->"0911185e-778f-4d3f-bbbf-7eddebe3b588"]
}, Open  ]],

Cell["\<\
With the previous code there was an explosion of checks with Kroneckers. Now \
there is no such explosion with Kroneckers, but we have introduced these \
checks, in number 2n+2 with n the number of factors in the product :\
\>", "Text",ExpressionUUID->"77ad4f56-9d07-4742-a763-036fe2590744"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "b"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "d"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "e"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "f"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "g"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "h"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "polar"}], "}"}]}], "]"}]}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"b792b8b5-8b4d-470f-86de-2b0904d6a0b1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]]},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`b, {2, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["3",
               FontColor->RGBColor[1., 0., 0.]]},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`c, {3, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["4",
               FontColor->RGBColor[1., 0., 0.]]},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`d, {4, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]]},
             {"e", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`e, {1, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]},
             {"f", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`f, {2, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["3",
               FontColor->RGBColor[1., 0., 0.]]},
             {"g", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`g, {3, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["4",
               FontColor->RGBColor[1., 0., 0.]]},
             {"h", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`h, {4, $CellContext`polar}],
      Editable->False]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]]},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`a, {1, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`b, {2, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["3",
               FontColor->RGBColor[1., 0., 0.]]},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`c, {3, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["4",
               FontColor->RGBColor[1., 0., 0.]]},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`d, {4, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["1",
               FontColor->RGBColor[1., 0., 0.]]},
             {"e", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`e, {1, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["2",
               FontColor->RGBColor[1., 0., 0.]]},
             {"f", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`f, {2, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["3",
               FontColor->RGBColor[1., 0., 0.]]},
             {"g", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`g, {3, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["4",
               FontColor->RGBColor[1., 0., 0.]]},
             {"h", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[-$CellContext`h, {4, $CellContext`polar}],
      Editable->False]}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"cdfdc77e-2900-43c1-b45e-a8ed329dd9f5"]
}, Open  ]],

Cell["\<\
With a single Basis and many tensors the length is independent of the number \
of tensors:\
\>", "Text",ExpressionUUID->"241c38b2-8c96-4996-afa4-bc362226bfe0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", "polar"}], "}"}], "]"}]}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"98c484dc-3a3b-4174-a832-b1ff7355c1d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["b",
                FontColor->RGBColor[1., 0., 0.]]},
              {
               StyleBox["a",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`polar}],
       Editable->False],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"BasisQ", "[", 
         RowBox[{"-", "polar"}], "]"}],
        HoldForm], ",", 
       TagBox["False",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"BasisQ", "[", 
         RowBox[{"-", "polar"}], "]"}],
        HoldForm], ",", 
       TagBox["False",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"BasisQ", "[", "polar", "]"}],
        HoldForm], ",", 
       TagBox["True",
        HoldForm]}], "}"}], ",", 
     TagBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["b",
                FontColor->RGBColor[1., 0., 0.]]},
              {
               StyleBox["a",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`polar}],
       Editable->False],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"3", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["b",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`c, $CellContext`polar}],
      Editable->False]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"IsIndexOf", "[", 
         RowBox[{
          RowBox[{"3", " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"IsIndexOf", "===", "Times"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"IsIndexOf", "===", "Times"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"IsIndexOf", "[", 
         RowBox[{
          RowBox[{"3", " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Or", "@@", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], "&"}],
            ")"}], "/@", 
          RowBox[{"Hold", "@@", 
           RowBox[{"Unevaluated", "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False]}], "]"}]}]}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"Hold", "@@", 
             RowBox[{"(", 
              RowBox[{"3", " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`c, $CellContext`polar}],
                Editable->False]}], ")"}]}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"Hold", "[", 
             RowBox[{"3", ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`c, $CellContext`polar}],
               Editable->False]}], "]"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "b"}], ",", 
                 RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "/@", 
           RowBox[{"Hold", "[", 
            RowBox[{"3", ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"Hold", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", "3", "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], "]"}]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"Or", "@@", 
         RowBox[{"Hold", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", "3", "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], "]"}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], "&"}],
            ")"}], "[", "3", "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], "&"}],
            ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`c, $CellContext`polar}],
           Editable->False], "]"}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "b"}], ",", 
                 RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", "3", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{"3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{"3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "b"}], ",", 
                 RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"c", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       TagBox["False",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"RuleCondition", "[", 
       RowBox[{
        RowBox[{"$ConditionHold", "[", 
         RowBox[{"$ConditionHold", "[", 
          RowBox[{"ReplaceIndex", "[", 
           RowBox[{
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False]}], ",", 
            RowBox[{
             RowBox[{"-", "b"}], "\[Rule]", 
             RowBox[{"-", "a"}]}]}], "]"}], "]"}], "]"}], ",", "False"}], 
       "]"}],
      HoldForm], ",", 
     TagBox["Fail",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"IsIndexOf", "[", 
         RowBox[{
          RowBox[{"3", " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False]}], ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"IsIndexOf", "===", "Times"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"IsIndexOf", "===", "Times"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"IsIndexOf", "[", 
         RowBox[{
          RowBox[{"3", " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False]}], ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Or", "@@", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
            "&"}], ")"}], "/@", 
          RowBox[{"Hold", "@@", 
           RowBox[{"Unevaluated", "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False]}], "]"}]}]}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"Hold", "@@", 
             RowBox[{"(", 
              RowBox[{"3", " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`c, $CellContext`polar}],
                Editable->False]}], ")"}]}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"Hold", "[", 
             RowBox[{"3", ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`c, $CellContext`polar}],
               Editable->False]}], "]"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "/@", 
           RowBox[{"Hold", "[", 
            RowBox[{"3", ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"Hold", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", "3", "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], "]"}]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"Or", "@@", 
         RowBox[{"Hold", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", "3", "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], "]"}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
            "&"}], ")"}], "[", "3", "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
            "&"}], ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`c, $CellContext`polar}],
           Editable->False], "]"}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", "3", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{"3", ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"c", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       TagBox["False",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"RuleCondition", "[", 
       RowBox[{
        RowBox[{"$ConditionHold", "[", 
         RowBox[{"$ConditionHold", "[", 
          RowBox[{"ReplaceIndex", "[", 
           RowBox[{
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False]}], ",", 
            RowBox[{"a", "\[Rule]", "b"}]}], "]"}], "]"}], "]"}], ",", 
        "False"}], "]"}],
      HoldForm], ",", 
     TagBox["Fail",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"3", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["b",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`c, $CellContext`polar}],
      Editable->False]}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"726d1c8f-c631-45c8-9de3-8c23e7da66f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", "polar"}], "}"}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"d", ",", "polar"}], "}"}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"e", ",", "polar"}], "}"}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"f", ",", "polar"}], "}"}], "]"}]}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"b2a131e4-f18f-4272-b6cb-c3809e3089ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["b",
                FontColor->RGBColor[1., 0., 0.]]},
              {
               StyleBox["a",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`polar}],
       Editable->False],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"BasisQ", "[", 
         RowBox[{"-", "polar"}], "]"}],
        HoldForm], ",", 
       TagBox["False",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"BasisQ", "[", 
         RowBox[{"-", "polar"}], "]"}],
        HoldForm], ",", 
       TagBox["False",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"BasisQ", "[", "polar", "]"}],
        HoldForm], ",", 
       TagBox["True",
        HoldForm]}], "}"}], ",", 
     TagBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {"e", 
           StyleBox[GridBox[{
              {" ", 
               StyleBox["b",
                FontColor->RGBColor[1., 0., 0.]]},
              {
               StyleBox["a",
                FontColor->RGBColor[1., 0., 0.]], " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`polar}],
       Editable->False],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"3", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["b",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`c, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["d",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`d, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["e",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`e, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["f",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`f, $CellContext`polar}],
      Editable->False]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"IsIndexOf", "[", 
         RowBox[{
          RowBox[{"3", " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`d, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`e, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`f, $CellContext`polar}],
            Editable->False]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"IsIndexOf", "===", "Times"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"IsIndexOf", "===", "Times"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"IsIndexOf", "[", 
         RowBox[{
          RowBox[{"3", " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`d, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`e, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`f, $CellContext`polar}],
            Editable->False]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Or", "@@", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], "&"}],
            ")"}], "/@", 
          RowBox[{"Hold", "@@", 
           RowBox[{"Unevaluated", "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`d, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`e, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`f, $CellContext`polar}],
              Editable->False]}], "]"}]}]}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"Hold", "@@", 
             RowBox[{"(", 
              RowBox[{"3", " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`c, $CellContext`polar}],
                Editable->False], " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`d, $CellContext`polar}],
                Editable->False], " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`e, $CellContext`polar}],
                Editable->False], " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`f, $CellContext`polar}],
                Editable->False]}], ")"}]}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"Hold", "[", 
             RowBox[{"3", ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`c, $CellContext`polar}],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`d, $CellContext`polar}],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`e, $CellContext`polar}],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`f, $CellContext`polar}],
               Editable->False]}], "]"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "b"}], ",", 
                 RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "/@", 
           RowBox[{"Hold", "[", 
            RowBox[{"3", ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`d, $CellContext`polar}],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`e, $CellContext`polar}],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`f, $CellContext`polar}],
              Editable->False]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"Hold", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", "3", "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`d, $CellContext`polar}],
              Editable->False], "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`e, $CellContext`polar}],
              Editable->False], "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`f, $CellContext`polar}],
              Editable->False], "]"}]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"Or", "@@", 
         RowBox[{"Hold", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", "3", "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`d, $CellContext`polar}],
             Editable->False], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`e, $CellContext`polar}],
             Editable->False], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`f, $CellContext`polar}],
             Editable->False], "]"}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], "&"}],
            ")"}], "[", "3", "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], "&"}],
            ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`c, $CellContext`polar}],
           Editable->False], "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], "&"}],
            ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`d, $CellContext`polar}],
           Editable->False], "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], "&"}],
            ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`e, $CellContext`polar}],
           Editable->False], "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], "&"}],
            ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`f, $CellContext`polar}],
           Editable->False], "]"}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "b"}], ",", 
                 RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", "3", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{"3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{"3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "b"}], ",", 
                 RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"c", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "b"}], ",", 
                 RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`d, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`d, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`d, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"d", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`d, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "b"}], ",", 
                 RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`e, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`e, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`e, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"e", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`e, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "b"}], ",", 
                 RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`f, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`f, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"IsIndexOf", "===", "Times"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`f, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"f", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`f, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "polar"}]}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       TagBox["False",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"RuleCondition", "[", 
       RowBox[{
        RowBox[{"$ConditionHold", "[", 
         RowBox[{"$ConditionHold", "[", 
          RowBox[{"ReplaceIndex", "[", 
           RowBox[{
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`d, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`e, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`f, $CellContext`polar}],
              Editable->False]}], ",", 
            RowBox[{
             RowBox[{"-", "b"}], "\[Rule]", 
             RowBox[{"-", "a"}]}]}], "]"}], "]"}], "]"}], ",", "False"}], 
       "]"}],
      HoldForm], ",", 
     TagBox["Fail",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Times", "===", "Times"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"IsIndexOf", "[", 
         RowBox[{
          RowBox[{"3", " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`d, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`e, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`f, $CellContext`polar}],
            Editable->False]}], ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"IsIndexOf", "===", "Times"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"IsIndexOf", "===", "Times"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"IsIndexOf", "[", 
         RowBox[{
          RowBox[{"3", " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`d, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`e, $CellContext`polar}],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`f, $CellContext`polar}],
            Editable->False]}], ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Or", "@@", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
            "&"}], ")"}], "/@", 
          RowBox[{"Hold", "@@", 
           RowBox[{"Unevaluated", "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`d, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`e, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`f, $CellContext`polar}],
              Editable->False]}], "]"}]}]}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"Hold", "@@", 
             RowBox[{"(", 
              RowBox[{"3", " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`c, $CellContext`polar}],
                Editable->False], " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`d, $CellContext`polar}],
                Editable->False], " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`e, $CellContext`polar}],
                Editable->False], " ", 
               InterpretationBox[
                StyleBox[GridBox[{
                   {"v", 
                    StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`v[{$CellContext`f, $CellContext`polar}],
                Editable->False]}], ")"}]}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"Hold", "[", 
             RowBox[{"3", ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`c, $CellContext`polar}],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`d, $CellContext`polar}],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`e, $CellContext`polar}],
               Editable->False], ",", 
              InterpretationBox[
               StyleBox[GridBox[{
                  {"v", 
                   StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`v[{$CellContext`f, $CellContext`polar}],
               Editable->False]}], "]"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "/@", 
           RowBox[{"Hold", "[", 
            RowBox[{"3", ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`d, $CellContext`polar}],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`e, $CellContext`polar}],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`f, $CellContext`polar}],
              Editable->False]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"Hold", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", "3", "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`d, $CellContext`polar}],
              Editable->False], "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`e, $CellContext`polar}],
              Editable->False], "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"IsIndexOf", "[", 
                RowBox[{"#1", ",", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
               "&"}], ")"}], "[", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`f, $CellContext`polar}],
              Editable->False], "]"}]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"Or", "@@", 
         RowBox[{"Hold", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", "3", "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`d, $CellContext`polar}],
             Editable->False], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`e, $CellContext`polar}],
             Editable->False], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"IsIndexOf", "[", 
               RowBox[{"#1", ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
              "&"}], ")"}], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`f, $CellContext`polar}],
             Editable->False], "]"}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
            "&"}], ")"}], "[", "3", "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
            "&"}], ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`c, $CellContext`polar}],
           Editable->False], "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
            "&"}], ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`d, $CellContext`polar}],
           Editable->False], "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
            "&"}], ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`e, $CellContext`polar}],
           Editable->False], "]"}], "||", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"IsIndexOf", "[", 
             RowBox[{"#1", ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
            "&"}], ")"}], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {
                   StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[{$CellContext`f, $CellContext`polar}],
           Editable->False], "]"}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", "3", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{"3", ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`c, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"c", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`c, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`d, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`d, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"d", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`d, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`e, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`e, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"e", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`e, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IsIndexOf", "[", 
              RowBox[{"#1", ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}], 
             "&"}], ")"}], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[{$CellContext`f, $CellContext`polar}],
            Editable->False], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"IsIndexOf", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[{$CellContext`f, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}], ",", "Basis"}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ProductQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["False",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xTensorQ", "[", "v", "]"}],
            HoldForm], ",", 
           TagBox["True",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"MemberQ", "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{"{", 
                RowBox[{"f", ",", "polar"}], "}"}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`IndexList[{$CellContext`f, $CellContext`polar}],
             Editable->False], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "polar"}], "}"}]}], "]"}],
          HoldForm], ",", 
         TagBox["False",
          HoldForm]}], "}"}], ",", 
       TagBox["False",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"RuleCondition", "[", 
       RowBox[{
        RowBox[{"$ConditionHold", "[", 
         RowBox[{"$ConditionHold", "[", 
          RowBox[{"ReplaceIndex", "[", 
           RowBox[{
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["c",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`c, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["d",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`d, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["e",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`e, $CellContext`polar}],
              Editable->False], " ", 
             InterpretationBox[
              StyleBox[GridBox[{
                 {"v", 
                  StyleBox[GridBox[{
                    {
                    StyleBox["f",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {" "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                   FontSize->Rational[39, 4]]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`v[{$CellContext`f, $CellContext`polar}],
              Editable->False]}], ",", 
            RowBox[{"a", "\[Rule]", "b"}]}], "]"}], "]"}], "]"}], ",", 
        "False"}], "]"}],
      HoldForm], ",", 
     TagBox["Fail",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"3", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"e", 
          StyleBox[GridBox[{
             {" ", 
              StyleBox["b",
               FontColor->RGBColor[1., 0., 0.]]},
             {
              StyleBox["a",
               FontColor->RGBColor[1., 0., 0.]], " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["c",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`c, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["d",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`d, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["e",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`e, $CellContext`polar}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {
              StyleBox["f",
               FontColor->RGBColor[1., 0., 0.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[{$CellContext`f, $CellContext`polar}],
      Editable->False]}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"3d16ffe0-3a47-4966-abba-79704dfd2823"]
}, Open  ]],

Cell["It is reasonably fast though:", \
"Text",ExpressionUUID->"d21f6ed9-5b94-47a6-8faa-a0b0196bf95f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"3", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "polar"}], "}"}]}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", "polar"}], "}"}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"d", ",", "polar"}], "}"}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"e", ",", "polar"}], "}"}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"{", 
     RowBox[{"f", ",", "polar"}], "}"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"f401cc84-f978-4dc8-9b13-3daee74ec7a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.000203`", ",", 
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"e", 
         StyleBox[GridBox[{
            {" ", 
             StyleBox["b",
              FontColor->RGBColor[1., 0., 0.]]},
            {
             StyleBox["a",
              FontColor->RGBColor[1., 0., 0.]], " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Basis[{-$CellContext`a, -$CellContext`polar}, \
{$CellContext`b, $CellContext`polar}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {
             StyleBox["c",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{$CellContext`c, $CellContext`polar}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {
             StyleBox["d",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{$CellContext`d, $CellContext`polar}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {
             StyleBox["e",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{$CellContext`e, $CellContext`polar}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {
             StyleBox["f",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`v[{$CellContext`f, $CellContext`polar}],
     Editable->False]}]}], 
  "}"}]], "Output",ExpressionUUID->"c28bf986-bb2f-4192-bde6-0b40780c9752"]
}, Open  ]],

Cell["Tests with indices:", \
"Text",ExpressionUUID->"a4b2d30f-57ee-437b-9868-64ba6ca96ba6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"exampleinds", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "cartesian"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "polar"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "pp"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "pp"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "polar"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",ExpressionUUID->"a6a45d34-68ec-4982-b9d5-aa4017b5aae6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GIndexQ", "/@", 
  "exampleinds"}]], \
"Input",ExpressionUUID->"7ecbd321-5883-4e2f-bd1b-19d82c55ad00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",",
    "False", ",", "False", ",", "True", ",", "True", ",", "False"}], 
  "}"}]], "Output",ExpressionUUID->"04a26736-63c3-45e1-bfbb-b5dd64d45273"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GIndexQ", "[", 
    RowBox[{"#", ",", "TangentM"}], "]"}], "&"}], "/@", 
  "exampleinds"}]], \
"Input",ExpressionUUID->"f56ff043-54c0-488c-9128-b28dd469bced"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",",
    "False", ",", "False", ",", "True", ",", "True", ",", "False"}], 
  "}"}]], "Output",ExpressionUUID->"6dd6224c-929e-43dd-922a-d690a1b308ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BCIndexQ", "/@", 
  "exampleinds"}]], \
"Input",ExpressionUUID->"9396b67a-3497-4635-af62-75aece55c63f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "True", ",", "True", ",", "True", ",", "True", ",",
    "False", ",", "False", ",", "True", ",", "True", ",", "False"}], 
  "}"}]], "Output",ExpressionUUID->"35cfcf88-3e59-4e96-b721-d807e4cd5518"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BCIndexQ", "[", 
    RowBox[{"#", ",", "polar"}], "]"}], "&"}], "/@", 
  "exampleinds"}]], \
"Input",ExpressionUUID->"b9b02903-857d-4638-9b13-9c9450550f05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "False", ",", "False", ",", "True", ",", "True",
    ",", "False", ",", "False", ",", "True", ",", "True", ",", "False"}], 
  "}"}]], "Output",ExpressionUUID->"38f19076-3647-43a7-9ff6-fdf09e7073cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BCIndexQ", "[", 
    RowBox[{"#", ",", "TangentM"}], "]"}], "&"}], "/@", 
  "exampleinds"}]], \
"Input",ExpressionUUID->"1b972312-15a4-4f0e-b48a-f1aefcd61720"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "True", ",", "True", ",", "True", ",", "True", ",",
    "False", ",", "False", ",", "True", ",", "True", ",", "False"}], 
  "}"}]], "Output",ExpressionUUID->"1733ff83-d67d-4b23-b8f2-8d3db2f81d66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AIndexQ", "/@", 
  "exampleinds"}]], \
"Input",ExpressionUUID->"3616f479-b8c3-4ae9-9b42-e4291a3285df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "False", ",", "False", ",", "False", ",", "False",
    ",", "False", ",", "False", ",", "False", ",", "False", ",", "False"}], 
  "}"}]], "Output",ExpressionUUID->"c435a5a7-44ba-4736-8774-5725004aac95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AIndexQ", "[", 
    RowBox[{"#", ",", "TangentM"}], "]"}], "&"}], "/@", 
  "exampleinds"}]], \
"Input",ExpressionUUID->"c19afa27-094c-4678-8247-9ded394ef310"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "False", ",", "False", ",", "False", ",", "False",
    ",", "False", ",", "False", ",", "False", ",", "False", ",", "False"}], 
  "}"}]], "Output",ExpressionUUID->"a124fc42-ac6a-4c9f-8682-78d63f32955c"]
}, Open  ]],

Cell["Torsion tensors are colored:", \
"Text",ExpressionUUID->"ce568977-879b-423c-9e5b-db485dc6de71"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TorsionPDpolar", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}]}], 
  "]"}]], "Input",ExpressionUUID->"f6aba23f-0860-4685-8f28-cd01e1937396"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox["T",
       FontColor->RGBColor[1., 0., 0.]], 
      StyleBox[GridBox[{
         {"a", " ", " "},
         {" ", "b", "c"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TorsionPDpolar[$CellContext`a, -$CellContext`b, \
-$CellContext`c],
  Editable->
   False]], "Output",ExpressionUUID->"6cc2a9a7-2cc2-48be-ad2d-90846ba7ac4d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TorsionPDcartesian", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}]}], 
  "]"}]], "Input",ExpressionUUID->"a68dbcfb-96f9-45bc-b313-dde5a621be68"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox["T",
       FontColor->RGBColor[0., 0., 1.]], 
      StyleBox[GridBox[{
         {"a", " ", " "},
         {" ", "b", "c"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TorsionPDcartesian[$CellContext`a, -$CellContext`b, \
-$CellContext`c],
  Editable->
   False]], "Output",ExpressionUUID->"726341ad-7060-42c2-8991-15120e337649"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UndefTensor", "[", "v", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Remove", "[", 
   RowBox[{"u", ",", "pp", ",", "exampleinds"}], "]"}], 
  ";"}]}], "Input",ExpressionUUID->"36ecea46-ec5a-49a9-bdba-f51f108a28ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "v"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`v],
  Editable->
   False]], "Print",ExpressionUUID->"5282bc6a-313f-40dd-8f5f-dad9b9e47c42"]
}, Open  ]],

Cell["2) Test of BasisArray.", \
"Text",ExpressionUUID->"06a12123-1ac9-4959-a2c9-4becbed3b079"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BasisArray", "[", "polar", "]"}], "[", "a", 
  "]"}]], "Input",ExpressionUUID->"fc2f940d-259f-45d7-a0ba-e425837e4290"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"198630fa-c9f3-414b-b96d-3c01f37bad4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"table", "=", 
    RowBox[{
     RowBox[{"BasisArray", "[", 
      RowBox[{"polar", ",", "cartesian", ",", "polar"}], "]"}], "[", 
     RowBox[{"a", ",", "b", ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], \
"Input",ExpressionUUID->"c0ad7d6f-06a2-41ea-89a4-13842bf8debf"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"0df85f84-8b0f-485d-80d4-24542e8aebb1"]
}, Open  ]],

Cell["\<\
We can compose BasisArray arrays using Outer[Times, array1, array2]:\
\>", "Text",ExpressionUUID->"40d779d1-2bdf-4950-a6c3-f313e8d95b49"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"table1", "=", 
    RowBox[{
     RowBox[{"BasisArray", "[", "polar", "]"}], "[", "a", "]"}]}], ")"}], "//",
   "MatrixForm"}]], \
"Input",ExpressionUUID->"e438aef8-bcbd-4055-aae6-0056fccee7b5"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
        Editable->False]},
      {
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "a"},
               {
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
        Editable->False]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"722a8a11-3617-4fda-94ca-ae399719893f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"table2", "=", 
    RowBox[{
     RowBox[{"BasisArray", "[", 
      RowBox[{"cartesian", ",", "polar"}], "]"}], "[", 
     RowBox[{"b", ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], \
"Input",ExpressionUUID->"32db7f75-83fa-45c5-81fb-a46a110ccfd4"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "b"},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
        Editable->False]}], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "b"},
               {
                StyleBox["1",
                 FontColor->RGBColor[0., 0., 1.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
        Editable->False]}]},
     {
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "b"},
               {
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
        Editable->False]}], 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"e", 
            StyleBox[GridBox[{
               {" ", "b"},
               {
                StyleBox["2",
                 FontColor->RGBColor[0., 0., 1.]], " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
        Editable->False]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"30a191af-8087-4167-ac77-9c7fac4293e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Times", ",", "table1", ",", "table2"}], "]"}], "//", 
  "MatrixForm"}]], \
"Input",ExpressionUUID->"c6056c82-bb01-4b1e-a979-c51d6a464c9a"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"86c599d3-b5c7-47b1-b0da-bc1872383ab0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"table", "===", 
  "%"}]], "Input",ExpressionUUID->"58466b33-e090-4c9b-933e-f4d54a8b6172"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"a98beb2c-5258-476e-9b95-8781575205af"]
}, Open  ]],

Cell["Outer products are not commutative:", \
"Text",ExpressionUUID->"83611b82-e086-40fd-a7d6-4d87998daf4d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Times", ",", "table2", ",", "table1"}], "]"}], "//", 
  "MatrixForm"}]], \
"Input",ExpressionUUID->"d89c140f-6ba1-4ce9-a0f8-f16067901471"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {1, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["1",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{1, -$CellContext`polar}, $CellContext`a],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False]}]},
          {
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", 
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]]},
                    {"c", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[-$CellContext`c, {2, $CellContext`polar}],
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "b"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[0., 0., 1.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`cartesian}, $CellContext`b],
             
             Editable->False], " ", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"e", 
                 StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["2",
                    FontColor->RGBColor[1., 0., 0.]], " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->Rational[39, 4]]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTensor`Basis[{2, -$CellContext`polar}, $CellContext`a],
             Editable->False]}]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"42d3aa61-2620-4bfd-b8cd-f1d822a6c775"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"table", "===", 
  "%"}]], "Input",ExpressionUUID->"85757980-b6c8-4896-b35a-f586755a5564"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"4234b86f-cf91-43b5-aaeb-767c5a669197"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"table", "===", 
  RowBox[{"Transpose", "[", 
   RowBox[{"%%", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"a6110ef5-5eaf-4c85-b2aa-1a34f1be5a12"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"d641b93c-e892-4fe2-96d2-96a9b0fb38c1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Remove", "[", 
   RowBox[{"table", ",", "table1", ",", "table2"}], "]"}], 
  ";"}]], "Input",ExpressionUUID->"35838ffe-3457-457c-81c8-26d5e32d789d"],

Cell["3) Canonicalization with b-indices and c-indices.", \
"Text",ExpressionUUID->"b32f0561-e4ed-457b-ab66-f22293f3c51e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], ",", "M", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"99786c2d-0d4c-4896-8d35-f3ab30885a33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d, $CellContext`e], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"c010aba0-1d91-4e6f-9214-7419810aed20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "IndexSort"}]], \
"Input",ExpressionUUID->"83b74a08-6654-44f3-a525-b7c98abb67b1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"IndexSort[list] sorts the elements of list (assumed \
to be g-indices) according to three priorities set up by \
SetIndexSortPriorities. Currently: first: free; second: lexicographic; third: \
up.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"IndexSort", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"{", "}"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False,
                    FontColor->RGBColor[0, 0, 1]],
                    xAct`xTensor`IndexList[],
                    Editable->False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"{", "}"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False,
                    FontColor->RGBColor[0, 0, 1]],
                    xAct`xTensor`IndexList[],
                    Editable->False]}]},
                    {
                    RowBox[{
                    RowBox[{"IndexSort", "[", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"IndexSort", "::", "argx"}], "MessageName"], ",", 
                    "IndexSort", ",", "0"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"IndexSort", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{",
                    FontColor->RGBColor[0, 0, 1]], 
                    "xAct`xTensor`Private`ind_", 
                    StyleBox["}",
                    FontColor->RGBColor[0, 0, 1]]}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`IndexList[
                    Pattern[xAct`xTensor`Private`ind, 
                    Blank[]]],
                    Editable->False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{",
                    FontColor->RGBColor[0, 0, 1]], "xAct`xTensor`Private`ind", 
                    StyleBox["}",
                    FontColor->RGBColor[0, 0, 1]]}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`IndexList[xAct`xTensor`Private`ind],
                    Editable->False]}]},
                    {
                    RowBox[{
                    RowBox[{
                    "IndexSort", "[", "xAct`xTensor`Private`list_List", "]"}],
                     ":=", 
                    RowBox[{"IndexSort", "[", 
                    RowBox[{"IndexList", "@@", "xAct`xTensor`Private`list"}], 
                    "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{
                    "IndexSort", "[", "xAct`xTensor`Private`list_IndexList", 
                    "]"}], ":=", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xTensor`Private`DummySorted", "=", 
                    RowBox[{"xAct`xTensor`Private`TakeEIndices", "[", 
                    RowBox[{"xAct`xTensor`Private`TakeEPairs", "[", 
                    "xAct`xTensor`Private`list", "]"}], "]"}]}], ",", 
                    RowBox[{"xAct`xTensor`Private`LexicSorted", "=", 
                    RowBox[{"Union", "[", 
                    RowBox[{"UpIndex", "/@", 
                    RowBox[{
                    "xAct`xTensor`Private`PatternToIndex", "/@", 
                    "xAct`xTensor`Private`list"}]}], "]"}]}]}], "}"}], ",", 
                    RowBox[{"Last", "/@", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"ReleaseHold", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xTensor`Private`Sort0", "[", "#1", "]"}], ",", 
                    RowBox[{"xAct`xTensor`Private`Sort1", "[", "#1", "]"}], ",", 
                    RowBox[{"xAct`xTensor`Private`Sort2", "[", "#1", "]"}], ",", 
                    RowBox[{"xAct`xTensor`Private`Sort3", "[", "#1", "]"}], ",",
                     "#1"}], "}"}], "&"}], ")"}], "/@", 
                    "xAct`xTensor`Private`list"}], "]"}], "]"}]}]}], 
                    "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"IndexSort", "[", 
                    RowBox[{"_", ",", "xAct`xCore`Private`x$__"}], "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"IndexSort", "::", "argx"}], "MessageName"], ",", 
                    "IndexSort", ",", 
                    RowBox[{"1", "+", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xCore`Private`x$", "}"}], "]"}]}]}], 
                    "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`IndexSort\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"IndexSort[list] sorts the elements of list (assumed \
to be g-indices) according to three priorities set up by \
SetIndexSortPriorities. Currently: first: free; second: lexicographic; third: \
up.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "IndexSort[list] sorts the elements of list (assumed to be g-indices) \
according to three priorities set up by SetIndexSortPriorities. Currently: \
first: free; second: lexicographic; third: up.", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xTensor`IndexSort, {xAct`xTensor`IndexSort[
         xAct`xTensor`IndexList[]] :> xAct`xTensor`IndexList[], 
       xAct`xTensor`IndexSort[] :> Message[
         MessageName[xAct`xTensor`IndexSort, "argx"], xAct`xTensor`IndexSort, 
         0], xAct`xTensor`IndexSort[
         xAct`xTensor`IndexList[
          Pattern[xAct`xTensor`Private`ind, 
           Blank[]]]] :> xAct`xTensor`IndexList[xAct`xTensor`Private`ind], 
       xAct`xTensor`IndexSort[
         Pattern[xAct`xTensor`Private`list, 
          Blank[List]]] :> xAct`xTensor`IndexSort[
         Apply[xAct`xTensor`IndexList, xAct`xTensor`Private`list]], 
       xAct`xTensor`IndexSort[
         Pattern[xAct`xTensor`Private`list, 
          Blank[xAct`xTensor`IndexList]]] :> 
       Block[{xAct`xTensor`Private`DummySorted = 
          xAct`xTensor`Private`TakeEIndices[
            xAct`xTensor`Private`TakeEPairs[xAct`xTensor`Private`list]], 
          xAct`xTensor`Private`LexicSorted = Union[
            Map[xAct`xTensor`UpIndex, 
             Map[
             xAct`xTensor`Private`PatternToIndex, 
              xAct`xTensor`Private`list]]]}, 
         Map[Last, 
          Sort[
           ReleaseHold[
            Map[{
              xAct`xTensor`Private`Sort0[#], 
              xAct`xTensor`Private`Sort1[#], 
              xAct`xTensor`Private`Sort2[#], 
              xAct`xTensor`Private`Sort3[#], #}& , 
             xAct`xTensor`Private`list]]]]], xAct`xTensor`IndexSort[
         Blank[], 
         Pattern[xAct`xCore`Private`x$, 
          BlankSequence[]]] :> Message[
         MessageName[xAct`xTensor`IndexSort, "argx"], xAct`xTensor`IndexSort, 
         1 + Length[{xAct`xCore`Private`x$}]]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "xAct`xTensor`IndexSort"|>, 
   False]]], "Output",ExpressionUUID->"5789a416-788b-45e2-99e7-6993b242e043"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "polar"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"2018ffe0-8055-4dbb-a427-c0cb9444f5f2"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"T", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["3",
           FontColor->RGBColor[1., 0., 0.]]},
         {
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]], " ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`T[{2, -$CellContext`polar}, {1, $CellContext`polar}, {
   1, $CellContext`polar}, {2, $CellContext`polar}, {3, $CellContext`polar}],
  Editable->
   False]], "Output",ExpressionUUID->"c786f939-78ac-4a79-9f8b-50b871153590"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonical", "[", 
   RowBox[{"%", ",", 
    RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"08ff6be1-0569-462d-8a7d-76782a835a57"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.004608`", ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " ", 
            StyleBox["3",
             FontColor->RGBColor[1., 0., 0.]]},
           {" ", " ", " ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{1, $CellContext`polar}, {1, $CellContext`polar}, {
     2, $CellContext`polar}, {2, -$CellContext`polar}, {
     3, $CellContext`polar}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"d73943c7-3c37-4de7-b10d-6037687de41c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonical", "[", 
   RowBox[{"%%", ",", 
    RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"5da1951b-b79a-481c-ada0-dd82cc28561f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.011418`", ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " ", 
            StyleBox["3",
             FontColor->RGBColor[1., 0., 0.]]},
           {" ", " ", " ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{1, $CellContext`polar}, {1, $CellContext`polar}, {
     2, $CellContext`polar}, {2, -$CellContext`polar}, {
     3, $CellContext`polar}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"70e7d2fd-dc82-4724-a6ce-07e69f2a58a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndexSort", "[", 
  RowBox[{"IndexList", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "polar"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "polar"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "polar"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "polar"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "polar"}], "}"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"f32552c4-03ae-4971-83eb-cb618dc21fca"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["{",
     FontColor->RGBColor[0, 0, 1]], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}], ",", "\[ThinSpace]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "polar"}], "}"}], ",", "\[ThinSpace]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "polar"}], "}"}], ",", "\[ThinSpace]", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "polar"}]}], "}"}], ",", "\[ThinSpace]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "polar"}], "}"}]}], 
    StyleBox["}",
     FontColor->RGBColor[0, 0, 1]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`IndexList[{1, $CellContext`polar}, {1, $CellContext`polar}, {
   2, $CellContext`polar}, {2, -$CellContext`polar}, {3, $CellContext`polar}],
  
  Editable->
   False]], "Output",ExpressionUUID->"57ec0aec-2b64-4857-a1b0-2391cdd0033a"]
}, Open  ]],

Cell["\<\
Canonicalization, however, is not simply sorting indices. There is the \
problem of detecting wheter the expression is compatible with zero:\
\>", "Text",ExpressionUUID->"bb491963-72ab-4746-8c73-375259610301"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], ",", "M", ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"531b26bf-76f8-4385-93de-b8f7919d50c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d, $CellContext`e], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"caa85644-94e6-48c6-8ca5-317bef0094c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "polar"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"7f2a3db6-e709-4897-ba55-42fffa7cb32a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["3",
           FontColor->RGBColor[1., 0., 0.]]},
         {
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]], " ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[{2, -$CellContext`polar}, {1, $CellContext`polar}, {
   1, $CellContext`polar}, {2, $CellContext`polar}, {3, $CellContext`polar}],
  Editable->
   False]], "Output",ExpressionUUID->"98f2d1af-f553-4c8c-a992-377d961d3aac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonical", "[", 
   RowBox[{"%", ",", 
    RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"2a9aab95-ae09-4721-a96c-3e0f270cd1b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.001417`", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"76fa1433-d2ba-4001-8b74-921f89f64efb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonical", "[", 
   RowBox[{"%%", ",", 
    RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"84d38d02-0aa6-46c5-842e-260fb6e22ce2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.004666`", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"0ee335b5-646e-4415-9624-3c3ec270e295"]
}, Open  ]],

Cell["\<\
There is an internal global variable controlling how repeated indices are \
handled:\
\>", "Text",ExpressionUUID->"795eb2b1-ab55-498b-8147-abcc9ee04463"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xTensor`Private`$RepeatedSingletonsQ"], \
"Input",ExpressionUUID->"352e47c4-205f-4900-91c0-afeaa82cdf02"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"42aa755f-1235-42b1-8e1f-651fcc1c5082"]
}, Open  ]],

Cell["\<\
With this new setting the repeated indices are pushed to the end. Timings are \
in general a bit faster, but the results are uglier:\
\>", "Text",ExpressionUUID->"5cb77ebc-c477-40b8-8da1-edadb5ca2210"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`xTensor`Private`$RepeatedSingletonsQ", "=", "False"}], 
  ";"}]], "Input",ExpressionUUID->"0ab8b43e-eb54-4c90-824d-d6f799e403a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "polar"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"aae06c4d-e70d-4f26-8c27-464f7a7317e6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"T", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["3",
           FontColor->RGBColor[1., 0., 0.]]},
         {
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]], " ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`T[{2, -$CellContext`polar}, {1, $CellContext`polar}, {
   1, $CellContext`polar}, {2, $CellContext`polar}, {3, $CellContext`polar}],
  Editable->
   False]], "Output",ExpressionUUID->"b3908362-3ad7-45ba-9bef-04f7614a0a8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonical", "[", 
   RowBox[{"%", ",", 
    RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"3215e304-95cb-4934-b0a6-4b87649ef517"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.001365`", ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " ", 
            StyleBox["3",
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{2, $CellContext`polar}, {2, -$CellContext`polar}, {
     3, $CellContext`polar}, {1, $CellContext`polar}, {1, $CellContext`polar}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"ee2a0c1b-b10d-4df6-a8f8-07b5671e2c2d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonical", "[", 
   RowBox[{"%%", ",", 
    RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"344f9023-128b-41ab-87f6-729d5259db92"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.007308`", ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " ", 
            StyleBox["3",
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]], 
            StyleBox["1",
             FontColor->RGBColor[1., 0., 0.]]},
           {" ", 
            StyleBox["2",
             FontColor->RGBColor[1., 0., 0.]], " ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[{2, $CellContext`polar}, {2, -$CellContext`polar}, {
     3, $CellContext`polar}, {1, $CellContext`polar}, {1, $CellContext`polar}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"4c4d1b9d-9610-4987-92db-13b776dde269"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "polar"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "polar"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "polar"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"6d6c576c-b1df-4a94-aad3-1f120420e5f9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]], 
          StyleBox["3",
           FontColor->RGBColor[1., 0., 0.]]},
         {
          StyleBox["2",
           FontColor->RGBColor[1., 0., 0.]], " ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[{2, -$CellContext`polar}, {1, $CellContext`polar}, {
   1, $CellContext`polar}, {2, $CellContext`polar}, {3, $CellContext`polar}],
  Editable->
   False]], "Output",ExpressionUUID->"0478be16-9032-4bb0-8750-26302c956b80"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonical", "[", 
   RowBox[{"%", ",", 
    RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"fb9dcf4b-d61d-45c7-ac1a-aef42f79c514"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.001379`", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"e23e290a-8b0b-43b3-ba7d-e8f54d365a3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToCanonical", "[", 
   RowBox[{"%%", ",", 
    RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"26350b62-4441-4b33-8844-5f86f72aaa36"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.006714`", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"b0aac61b-bb0a-4d5e-8c14-fafed71f81c4"]
}, Open  ]],

Cell["We return to the original setting:", \
"Text",ExpressionUUID->"9c7d9d68-196c-47cd-b508-feff00ce43fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`xTensor`Private`$RepeatedSingletonsQ", "=", "True"}], 
  ";"}]], "Input",ExpressionUUID->"3070dc84-5410-4bdb-ae92-6437c699beea"],

Cell["That variable should be better documented.", \
"Text",ExpressionUUID->"724057b5-8264-4d58-a111-3e1802b58c9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "T", 
  "]"}]], "Input",ExpressionUUID->"277e5035-7ff4-4345-a319-0b4217b9683a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "T"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T],
  Editable->
   False]], "Print",ExpressionUUID->"a8b5cdda-af0d-416a-bf49-b223461cd2d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "S", 
  "]"}]], "Input",ExpressionUUID->"58d3ec24-9984-4076-a3b4-c0838385df07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "S"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`S],
  Editable->
   False]], "Print",ExpressionUUID->"9ec32bb4-10a6-45ec-9184-a3f1a2debeaa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefBasis", "[", "polar", 
  "]"}]], "Input",ExpressionUUID->"7e3e13ad-5781-4239-a13c-6ee99bf879c8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "ChristoffelPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelPDpolar],
  Editable->
   False]], "Print",ExpressionUUID->"27d1c69c-6917-4fa5-b18c-9e76fc2ed534"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci tensor", 
   " ", $CellContext`RicciPDpolar],
  Editable->
   False]], "Print",ExpressionUUID->"7ff2e40e-2e6e-43e5-b5b9-814a92f0eda1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannPDpolar],
  Editable->
   False]], "Print",ExpressionUUID->"010ce7f3-02fb-47b5-abf1-68e3fc9b0891"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionPDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionPDpolar],
  Editable->
   False]], "Print",ExpressionUUID->"057ac931-d2b6-474f-a256-9b0e0ec70d8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "PDpolar"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "parallel derivative", 
   " ", $CellContext`PDpolar],
  Editable->
   False]], "Print",ExpressionUUID->"e5d2f268-1a79-48f8-ac4e-febe5006abdb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefBasis", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"basis\"\>", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "polar"}],
  SequenceForm[
  "** ", xAct`xCoba`UndefBasis, ": Undefined ", "basis", 
   " ", $CellContext`polar],
  Editable->
   False]], "Print",ExpressionUUID->"952f3fab-3a69-4497-b822-629867cbd359"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"UndefBasis", "[", "cartesian", 
  "]"}]], "Input",ExpressionUUID->"1eadad33-4af4-4d8b-86f1-bafe350c10e3"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"6d7c26a7-c046-435e-9128-cea45af6d50f"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2.4. BasisCollect", \
"Subsubsection",ExpressionUUID->"64093fec-bc0c-451d-a156-60dedd82b91a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BasisCollect", "[", "expr_", "]"}], ":=", 
   RowBox[{"Collect", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "a1_Basis", " ", "a2_Basis", " ", "a3_Basis", " ", "a4_Basis"}], ",", 
       RowBox[{"a1_Basis", " ", "a2_Basis", " ", "a3_Basis"}], ",", 
       RowBox[{"a1_Basis", " ", "a2_Basis"}], ",", "a1_Basis"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BasisCollect", "[", 
    RowBox[{"expr_", ",", "f_"}], "]"}], ":=", 
   RowBox[{"Collect", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "a1_Basis", " ", "a2_Basis", " ", "a3_Basis", " ", "a4_Basis"}], ",", 
       RowBox[{"a1_Basis", " ", "a2_Basis", " ", "a3_Basis"}], ",", 
       RowBox[{"a1_Basis", " ", "a2_Basis"}], ",", "a1_Basis"}], "}"}], ",", 
     "f"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"16e7ed25-4ec9-480d-b907-74e3140a8e72"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2.5. Conjugation", \
"Subsubsection",ExpressionUUID->"8f339b58-8fcc-4278-8344-476bdcfe943f"],

Cell[TextData[{
 "The *private* function DaggerBIndex gives the conjugate of b-indices. This \
function is directly called from ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", but with xAct`xCoba`Private` context",
 ". The first argument contains the basis as well, which is too deep in the \
b-index, because we want to load upvalues on it. Note that there is no check \
that a is an a-index."
}], "Text",ExpressionUUID->"780a5734-77bb-4a38-a903-028ed0d501fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"General", " ", "definition", " ", "for", " ", "b"}], "-", 
    "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DaggerBIndex", "[", 
      RowBox[{"_", ",", 
       RowBox[{"{", 
        RowBox[{"a_", ",", "basis_"}], "}"}]}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"DaggerIndex", "[", "a", "]"}], ",", 
       RowBox[{"Dagger", "[", "basis", "]"}]}], "}"}]}], ";"}], 
   RowBox[{"(*", " ", "BASIS1", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DaggerBIndex", "[", 
      RowBox[{"_", ",", 
       RowBox[{
        RowBox[{"basis_", "?", "BasisQ"}], "[", "a_", "]"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Dagger", "[", "basis", "]"}], "[", 
      RowBox[{"DaggerIndex", "[", "a", "]"}], "]"}]}], ";"}], 
   RowBox[{"(*", " ", "BASIS2", " ", "*)"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fa4d954d-30e1-4ce1-8a4e-9dcdec2dd37d"],

Cell[TextData[{
 "Conjugation of c-indices is controlled by the *public* function \
DaggerCIndex, also called from ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". By default, we assume that the Dagger of a basis vector shares its \
cnumber, but the user can overwrite this behaviour using upvalues for the \
basis on this function. Recall that we have defined Basis as a real tensor \
(with Dagger[Basis]^=Basis);"
}], "Text",ExpressionUUID->"39498e27-894e-46e4-83ff-42c19976cc98"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DaggerCIndex"}]], \
"Input",ExpressionUUID->"f8254fef-252d-424f-a804-3214ed11f542"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DaggerCIndex[basis, cindex] returns the conjugated \
index to the cindex (assumed to belong to basis or -basis), in general a Dir \
expression. This function should be handled through upvalues for basis.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`DaggerCIndex\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DaggerCIndex[basis, cindex] returns the conjugated \
index to the cindex (assumed to belong to basis or -basis), in general a Dir \
expression. This function should be handled through upvalues for basis.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DaggerCIndex[basis, cindex] returns the conjugated index to the cindex \
(assumed to belong to basis or -basis), in general a Dir expression. This \
function should be handled through upvalues for basis.", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xCoba`DaggerCIndex"|>, 
   False]]], "Output",ExpressionUUID->"9605e4c6-4142-45c1-97be-0e95e9680fe9"]
}, Open  ]],

Cell["\<\
In order to create upvalues for the basis we need to give the basis twice, \
the first without signs and the second possibly having a sign. That is ugly, \
but we don't see an alternative. Because this is a public function, we add \
the _Integer blank in a:\
\>", "Text",ExpressionUUID->"9aacf77e-5020-4666-ab12-111c4eb27714"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Default", " ", "definition", " ", "for", " ", "c"}], "-", 
    "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DaggerCIndex", "[", 
      RowBox[{
       RowBox[{"-", "basis_"}], ",", "cindex_"}], "]"}], ":=", 
     RowBox[{"DaggerCIndex", "[", 
      RowBox[{"basis", ",", "cindex"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DaggerCIndex", "[", 
      RowBox[{"_", ",", 
       RowBox[{"{", 
        RowBox[{"a_Integer", ",", "basis_"}], "}"}]}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"Dagger", "[", "basis", "]"}]}], "}"}]}], ";"}], 
   RowBox[{"(*", " ", "BASIS1", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DaggerCIndex", "[", 
      RowBox[{"_", ",", 
       RowBox[{
        RowBox[{"basis_", "?", "BasisQ"}], "[", "a_Integer", "]"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Dagger", "[", "basis", "]"}], "[", "a", "]"}]}], ";"}], 
   RowBox[{"(*", " ", "BASIS2", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"DaggerCIndex", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Protect", "[", "DaggerCIndex", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4aa5d1cb-32c9-4e13-abe0-323eff7c96ff"],

Cell["\<\
It is very important to note that, given the *complete* relation between a \
basis and its conjugate, then the opposite is also given, as well as the \
relations between their dual bases. Instead of checking the consistency of \
the definitions provided by the user, we define a simple way to define all \
relations from the first one:\
\>", "Text",ExpressionUUID->"35572b6e-50bd-4028-9b6a-746f3359b17c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SetDaggerMatrix"}]], \
"Input",ExpressionUUID->"5eaed32f-1a1d-4ca7-9c77-ba35a073f20f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"SetDaggerMatrix[basis, matrix] defines upvalues for \
DaggerCIndex of all c-indices of basis, its dual and their conjugates, based \
on the given conjugation matrix. This matrix gives the dagger of the basis \
up-vectors in terms of the vectors of its conjugate basis. When the basis is \
real the matrix must be unitary.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xCoba`SetDaggerMatrix\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"SetDaggerMatrix[basis, matrix] defines upvalues for \
DaggerCIndex of all c-indices of basis, its dual and their conjugates, based \
on the given conjugation matrix. This matrix gives the dagger of the basis \
up-vectors in terms of the vectors of its conjugate basis. When the basis is \
real the matrix must be unitary.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "SetDaggerMatrix[basis, matrix] defines upvalues for DaggerCIndex of all \
c-indices of basis, its dual and their conjugates, based on the given \
conjugation matrix. This matrix gives the dagger of the basis up-vectors in \
terms of the vectors of its conjugate basis. When the basis is real the \
matrix must be unitary.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xCoba`SetDaggerMatrix"|>, 
   False]]], "Output",ExpressionUUID->"7cebdb58-43ea-4fca-9563-616d92ed83d2"]
}, Open  ]],

Cell["\<\
Cryptic code follows, but seems to be working well... (for BASIS1 only). Note \
that CNumbersOf is used with only one argument:\
\>", "Text",ExpressionUUID->"c6ea88ed-e654-46a2-8d4c-bb52744b8906"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Consistent", " ", 
    RowBox[{"conjugation", ".", " ", "Internal"}], " ", "function"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"inner", "[", 
      RowBox[{
      "basis_", ",", "sbasis_", ",", "mat_", ",", "dbasis_", ",", "duind_"}], 
      "]"}], ":=", 
     RowBox[{"Inner", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"TagSet", "[", 
         RowBox[{"basis", ",", "##"}], "]"}], "&"}], ",", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Unevaluated", "[", 
           RowBox[{"DaggerCIndex", "[", 
            RowBox[{"basis", ",", 
             RowBox[{"{", 
              RowBox[{"#", ",", "sbasis"}], "}"}]}], "]"}], "]"}], "&"}], ",", 
         RowBox[{"IndexList", "@@", 
          RowBox[{"CNumbersOf", "[", "sbasis", "]"}]}]}], "]"}], ",", 
       RowBox[{"IndexList", "@@", 
        RowBox[{"Map", "[", 
         RowBox[{"Dir", ",", 
          RowBox[{"mat", ".", 
           RowBox[{
            RowBox[{"BasisArray", "[", "dbasis", "]"}], "[", "duind", 
            "]"}]}]}], "]"}]}], ",", "List"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"With", " ", "no", " ", "matrix"}], ",", " ", 
     RowBox[{"remove", " ", "DaggerCIndex", " ", "upvalues"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetDaggerMatrix", "[", "basis_", "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"dagbasis", "=", 
         RowBox[{"Dagger", "[", "basis", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"prot", "=", 
           RowBox[{"Unprotect", "[", 
            RowBox[{"basis", ",", "dagbasis"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"UpValues", "[", "basis", "]"}], "^=", 
           RowBox[{"DeleteCases", "[", 
            RowBox[{
             RowBox[{"UpValues", "[", "basis", "]"}], ",", 
             RowBox[{"_", "[", 
              RowBox[{
               RowBox[{"_", "[", 
                RowBox[{"DaggerCIndex", "[", 
                 RowBox[{"basis", ",", "_"}], "]"}], "]"}], ",", "_"}], 
              "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"DaggerQ", "[", "basis", "]"}], ",", 
            RowBox[{
             RowBox[{"UpValues", "[", "dagbasis", "]"}], "^=", 
             RowBox[{"DeleteCases", "[", 
              RowBox[{
               RowBox[{"UpValues", "[", "dagbasis", "]"}], ",", 
               RowBox[{"_", "[", 
                RowBox[{
                 RowBox[{"_", "[", 
                  RowBox[{"DaggerCIndex", "[", 
                   RowBox[{"dagbasis", ",", "_"}], "]"}], "]"}], ",", "_"}], 
                "]"}]}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Protect", "[", 
           RowBox[{"Evaluate", "[", "prot", "]"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "With", " ", "a", " ", "matrix", " ", "we", " ", "need", " ", "four", " ",
      "calls", " ", "to", " ", "inner"}], " ", "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"SetDaggerMatrix", "[", 
      RowBox[{"basis_", ",", "matrix_"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"inversematrix", "=", 
          RowBox[{"Inverse", "[", "matrix", "]"}]}], ",", 
         RowBox[{"uind", "=", 
          RowBox[{
           RowBox[{"IndicesOfVBundle", "[", 
            RowBox[{"VBundleOfBasis", "[", "basis", "]"}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
         RowBox[{"dagbasis", "=", 
          RowBox[{"Dagger", "[", "basis", "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"daguind", "=", 
            RowBox[{"DaggerIndex", "[", "uind", "]"}]}], ",", 
           RowBox[{"prot", "=", 
            RowBox[{"Unprotect", "[", 
             RowBox[{"basis", ",", "dagbasis"}], "]"}]}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"DaggerQ", "[", "basis", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"UpValues", "[", "dagbasis", "]"}], "^=", 
              RowBox[{"DeleteCases", "[", 
               RowBox[{
                RowBox[{"UpValues", "[", "dagbasis", "]"}], ",", 
                RowBox[{"_", "[", 
                 RowBox[{
                  RowBox[{"_", "[", 
                   RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"dagbasis", ",", "_"}], "]"}], "]"}], ",", "_"}], 
                 "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"inner", "[", 
              RowBox[{"dagbasis", ",", 
               RowBox[{"-", "dagbasis"}], ",", 
               RowBox[{"Dagger", "[", "inversematrix", "]"}], ",", "basis", ",",
                "uind"}], "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"inner", "[", 
              RowBox[{"dagbasis", ",", "dagbasis", ",", 
               RowBox[{"Dagger", "[", 
                RowBox[{"Transpose", "[", "matrix", "]"}], "]"}], ",", 
               "basis", ",", 
               RowBox[{"-", "uind"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"Check", " ", "unitarity", " ", "of", " ", "matrix"}], 
             " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Simplify", "[", 
                RowBox[{"matrix", ".", 
                 RowBox[{"Transpose", "[", 
                  RowBox[{"Dagger", "[", "matrix", "]"}], "]"}]}], "]"}], "=!=", 
               RowBox[{"IdentityMatrix", "[", 
                RowBox[{"Length", "[", "matrix", "]"}], "]"}]}], ",", 
              RowBox[{"Throw", "@", 
               RowBox[{"Message", "[", 
                RowBox[{
                 RowBox[{"SetDaggerMatrix", "::", "error"}], 
                 ",", "\"\<Complexification of a real basis requires a \
unitary matrix.\>\""}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "]"}], ";",
           "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"UpValues", "[", "basis", "]"}], "^=", 
           RowBox[{"DeleteCases", "[", 
            RowBox[{
             RowBox[{"UpValues", "[", "basis", "]"}], ",", 
             RowBox[{"_", "[", 
              RowBox[{
               RowBox[{"_", "[", 
                RowBox[{"DaggerCIndex", "[", 
                 RowBox[{"basis", ",", "_"}], "]"}], "]"}], ",", "_"}], 
              "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"inner", "[", 
           RowBox[{"basis", ",", 
            RowBox[{"-", "basis"}], ",", "matrix", ",", "dagbasis", ",", 
            "daguind"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"inner", "[", 
           RowBox[{"basis", ",", "basis", ",", 
            RowBox[{"Transpose", "[", "inversematrix", "]"}], ",", "dagbasis",
             ",", 
            RowBox[{"-", "daguind"}]}], "]"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"Protect", "[", 
           RowBox[{"Evaluate", "[", "prot", "]"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"SetDaggerMatrix", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Protect", "[", "SetDaggerMatrix", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f1f7484f-14ed-4567-9425-d3507a69c48d"]
}, Closed]],

Cell[CellGroupData[{

Cell["         Examples", \
"Subsubsection",ExpressionUUID->"1f9fff8d-ae5c-479f-a437-7ba927d563c1"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"fd2c1e3b-a0e9-4967-b54a-03639eb39e39"],

Cell["Define complex bases:", \
"Text",ExpressionUUID->"b7c6effe-d068-474d-b6dc-7a068bad50ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"complex", ",", "InnerC", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"8741c2a4-11e3-44d6-9006-27eff1f3abd5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "complex", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`complex, 
   ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"f82d4ef3-2887-412a-ba3b-ba931122b91a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDcomplex", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDcomplex[-$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"cf67ab0b-c29c-4f63-8956-b23bdd6dcef1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDcomplex", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDcomplex[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"b420e101-f43f-4bb9-85ef-231a4a4a584c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcomplex", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDcomplex[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"1d52aa1a-82ea-460c-95bf-15a929168e08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannPDcomplex", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDcomplex[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"94d94bf7-ab54-4bdb-a8cd-5e88138537af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciPDcomplex", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDcomplex[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"00e9cf0b-bc8a-4381-9038-7af3b9ede0ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDcomplex", "[", 
    RowBox[{"A", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDcomplex[$CellContext`A, -$CellContext`b, -C], 
   ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"5ecc8d77-6346-4f80-8861-a4c38b75ba26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"AChristoffelPDcomplex\[Dagger]", "[", 
    RowBox[{"A\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelPDcomplex\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"00220b04-2e74-4232-9105-8d8db22b8e00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDcomplex", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C"}], ",", "D"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDcomplex[-$CellContext`a, -$CellContext`b, -C, D], 
   ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"72f088d9-7ee2-494f-97ad-65e12e693b93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannPDcomplex\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "vanishing FRiemann tensor ", 
   $CellContext`FRiemannPDcomplex\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`C\[Dagger], $CellContext`D\[Dagger]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"635c904f-cd23-4076-9d41-3fdbd2ff9b6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", 
   "complex\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", 
   "basis ", $CellContext`complex\[Dagger], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"6e69393c-1986-4052-a14a-6d1eac588f80"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Conjugation is denoted in the index of the basis object because both bases \
complex and complex\[Dagger] are denoted with the same color:\
\>", "Text",ExpressionUUID->"05b4a4a5-20d4-46a6-a6a9-504784275409"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"-", "A"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "complex"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"de274d1c-9b08-41ab-84ce-9a7ee3513846"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]]},
         {"A", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[-$CellContext`A, {1, $CellContext`complex}],
  Editable->
   False]], "Output",ExpressionUUID->"44575288-338e-4467-85b2-aecb488afd54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"0d8ba042-1cde-4517-af82-e0b5a468e67c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", 
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]]},
         {"A\[Dagger]", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[-$CellContext`A\[Dagger], {
   1, $CellContext`complex\[Dagger]}],
  Editable->
   False]], "Output",ExpressionUUID->"c1316463-2f8f-4367-9db4-77d139f0b595"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "InputForm"}]], \
"Input",ExpressionUUID->"fa960d2f-6fc9-4785-b2c2-d6570faf64fe"],

Cell["Basis[-A\[Dagger], {1, complex\[Dagger]}]", \
"Output",ExpressionUUID->"466d42c5-853f-484f-a603-1523fd54c9a8"]
}, Open  ]],

Cell["\<\
The derivative of the conjugated basis is automatically converted into the \
original derivative:\
\>", "Text",ExpressionUUID->"74bdf000-d43d-41c3-8e9c-9d519a3d89f7"],

Cell[CellGroupData[{

Cell[BoxData["PDcomplex\[Dagger]"], \
"Input",ExpressionUUID->"dcf70fe7-6141-42ce-a76d-0fa8e7b93b9d"],

Cell[BoxData["PDcomplex"], \
"Output",ExpressionUUID->"b13903c5-26e6-4067-b8e8-181dd56e154a"]
}, Open  ]],

Cell["Associated tensors:", \
"Text",ExpressionUUID->"8083c326-35e6-406d-a656-4bc2edb832d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TorsionPDcomplex", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}]}], 
  "]"}]], "Input",ExpressionUUID->"f263b1b2-ba43-4355-b9a3-c3e276722bd8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox["T",
       FontColor->RGBColor[0., 0., 1.]], 
      StyleBox[GridBox[{
         {"a", " ", " "},
         {" ", "b", "c"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TorsionPDcomplex[$CellContext`a, -$CellContext`b, \
-$CellContext`c],
  Editable->
   False]], "Output",ExpressionUUID->"f69aead9-3d3d-42d4-879b-ddb6b2d69d30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannPDcomplex", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", "d"}], 
  "]"}]], "Input",ExpressionUUID->"c5a48c70-94be-4672-9525-a61c15977726"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"7e3bbb9e-9d66-42d3-86b7-fe61eb6225ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AChristoffelPDcomplex", "[", 
  RowBox[{"A", ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "C"}]}], 
  "]"}]], "Input",ExpressionUUID->"c9f7694d-0d42-426e-b5fd-13db99b3bc24"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"A", "[", 
       StyleBox["\[ScriptCapitalD]",
        FontColor->RGBColor[0., 0., 1.]], "]"}], 
      StyleBox[GridBox[{
         {"A", " ", " "},
         {" ", "b", "C"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`AChristoffelPDcomplex[$CellContext`A, -$CellContext`b, -C],
  Editable->
   False]], "Output",ExpressionUUID->"9b314737-ea4d-4ed6-8edd-0c6a899645c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"4ceb1601-87a7-437f-81f2-a019c80baa25"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       RowBox[{"A", "[", 
        StyleBox["\[ScriptCapitalD]",
         FontColor->RGBColor[0., 0., 1.]], "]"}], "\[Dagger]"}], 
      StyleBox[GridBox[{
         {"A\[Dagger]", " ", " "},
         {" ", "b", "C\[Dagger]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`AChristoffelPDcomplex\[Dagger][$CellContext`A\[Dagger], \
-$CellContext`b, -$CellContext`C\[Dagger]],
  Editable->
   False]], "Output",ExpressionUUID->"cd1481ce-b5e9-49a3-9a1e-81384bee726b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"b2f0a4c1-2b8a-4999-b97c-6073c93b0353"],

Cell["AChristoffelPDcomplex\[Dagger][A\[Dagger], -b, -C\[Dagger]]", \
"Output",ExpressionUUID->"5bc0c5f0-9b84-4e6d-8c56-65502d77d3fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FRiemannPDcomplex", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "C"}], ",", "D"}], 
  "]"}]], "Input",ExpressionUUID->"41bb0b79-26f0-4005-b33e-5f77993b6ca7"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"20843d98-2a82-4cf5-b44e-baab3fc27869"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FRiemannPDcomplex\[Dagger]", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "C\[Dagger]"}], ",", "D\[Dagger]"}], 
  "]"}]], "Input",ExpressionUUID->"76a519d8-7048-405d-aa33-67bb5dd26cba"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"bef05b75-d50e-4c08-a6a2-7e4367db7a59"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Bases"], \
"Input",ExpressionUUID->"cc7a40ef-be8f-49e4-a0a8-0bf37fc0037d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"complex", ",", "complex\[Dagger]"}], 
  "}"}]], "Output",ExpressionUUID->"5d0b3938-7cd8-4da8-b13e-fafa493e2f90"]
}, Open  ]],

Cell["We can also \"complexify\" a real basis:", \
"Text",ExpressionUUID->"ebe9d2b5-9c86-4bda-ba40-2586bb7bc6e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"test", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"BasisColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"1", ",", "0", ",", "1"}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"86808bba-3985-49d5-858f-1aa24c021a88"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "test", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`test, 
   ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"075e81c1-d598-4643-bbdf-5d1d0db7a3e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDtest", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDtest[-$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"0e719432-36f5-4cd8-94f2-d645f26148dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDtest", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDtest[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"1b426deb-f453-453a-ab41-c348601f9b86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDtest", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDtest[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e3e45e48-b3ac-4d71-9011-60b00cea9a2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannPDtest", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDtest[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, $CellContext`d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"fbef01c9-a306-4550-b221-c82268ad244a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciPDtest", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDtest[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"8dc7185c-b2e7-4c18-a999-2b5956b9e40b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DefTensor", 
  "]"}]], "Input",ExpressionUUID->"e4c25c4c-752d-4579-826f-0fd4d3ca084b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Dagger", "\[Rule]", "Real"}], ",", 
   RowBox[{"Master", "\[Rule]", "Null"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", 
   RowBox[{"VanishingQ", "\[Rule]", "False"}], ",", 
   RowBox[{"ForceSymmetries", "\[Rule]", "False"}], ",", 
   RowBox[{"WeightOfTensor", "\[Rule]", "0"}], ",", 
   RowBox[{"GradeOfTensor", "\[Rule]", "0"}], ",", 
   RowBox[{"FrobeniusQ", "\[Rule]", "False"}], ",", 
   RowBox[{"OrthogonalTo", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"ProjectedWith", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
   
   RowBox[{"DefInfo", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}], ",", 
   RowBox[{"TensorID", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"0ba4f7b2-eead-4be1-8607-886e8c8222c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "test"}]}], "}"}], ",", "a"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"22de3709-ab87-4dfb-a04d-b049c5fee8ad"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", "a"},
         {
          StyleBox["3",
           FontColor->RGBColor[1., 0., 1.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{3, -$CellContext`test}, $CellContext`a],
  Editable->
   False]], "Output",ExpressionUUID->"9057971a-06c1-4952-ab3e-7cb0cbe05633"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "test"}]}], "}"}], ",", "a"}], "]"}], "+", 
  RowBox[{"I", " ", 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "test"}]}], "}"}], ",", "a"}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"09dc5249-580a-4512-8af4-ad23be8c3721"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["2",
            FontColor->RGBColor[1., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{2, -$CellContext`test}, $CellContext`a],
   Editable->False], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["3",
             FontColor->RGBColor[1., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{3, -$CellContext`test}, $CellContext`a],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"0326832a-88d0-458e-9845-2116d80695e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"0f179b40-faf7-4b65-8918-e837faaf929b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["2",
            FontColor->RGBColor[1., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{2, -$CellContext`test}, $CellContext`a],
   Editable->False], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"e", 
        StyleBox[GridBox[{
           {" ", "a"},
           {
            StyleBox["3",
             FontColor->RGBColor[1., 0., 1.]], " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Basis[{3, -$CellContext`test}, $CellContext`a],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"16fd16e6-9b24-4fce-afa0-af2a2e8ca42c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "InputForm"}]], \
"Input",ExpressionUUID->"32bb670b-4510-46f1-bb6c-4fbd3321ce16"],

Cell["Basis[{2, -test}, a] - I*Basis[{3, -test}, a]", \
"Output",ExpressionUUID->"6f78f62a-4e83-4404-9478-e126e8357bfa"]
}, Open  ]],

Cell["\<\
We can make the vectors of the basis to be conjugate of each other (note that \
we need separate definitions for upper and lower indices):\
\>", "Text",ExpressionUUID->"c51cb02f-84ed-4cb4-80db-69000b5ee48b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "/:", 
  RowBox[{"DaggerIndex", "[", 
   RowBox[{"{", 
    RowBox[{"3", ",", "test"}], "}"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"4", ",", "test"}], 
   "}"}]}]], "Input",ExpressionUUID->"b95b5768-c2c3-4a1f-95f0-229cb3a58943"],

Cell[BoxData[
 TemplateBox[{
  "TagSet", "tagpos", 
   "\"Tag \\!\\(\\*RowBox[{\\\"test\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"DaggerIndex\\\", \\\"[\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"3\\\", \\\",\\\", \\\"test\\\"}], \\\"}\\\"}], \\\"]\\\"}]\\) is \
too deep for an assigned rule to be found.\"", 2, 436, 13, 
   19678524296362999459, "Local"},
  "MessageTemplate"]], "Message", \
"MSG",ExpressionUUID->"0c25422b-d522-4244-a8ae-696b58434501"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "test"}], 
  "}"}]], "Output",ExpressionUUID->"bf08152a-094f-42fa-8469-8ec343021230"]
}, Open  ]],

Cell["That doesn't work, so we need this:", \
"Text",ExpressionUUID->"74539546-a418-4dc2-a5b2-c011b1bcb832"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "test"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "test"}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "test"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "test"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "test"}]}], "}"}]}], 
  ";"}]}], "Input",ExpressionUUID->"689afe21-ab35-4b40-bea8-be30321171b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "test"}]}], "}"}], ",", "a"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"d3cd75d6-dcb3-4d64-9c7a-3ebb5d661274"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", "a"},
         {
          StyleBox["4",
           FontColor->RGBColor[1., 0., 1.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{4, -$CellContext`test}, $CellContext`a],
  Editable->
   False]], "Output",ExpressionUUID->"9a2881b5-0134-4b6b-8d43-d551ace32edc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", 
      RowBox[{"-", "test"}]}], "}"}], ",", "a"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"92afd790-3689-405f-9221-10edb2ab665b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", "a"},
         {
          StyleBox["3",
           FontColor->RGBColor[1., 0., 1.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{3, -$CellContext`test}, $CellContext`a],
  Editable->
   False]], "Output",ExpressionUUID->"16bb8bf6-b787-4f71-9e86-1abf5d73fd0f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], 
  "]"}]], "Input",ExpressionUUID->"19357406-de7b-4aaa-88f6-1976bc455634"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"4fc336c3-4152-4a94-be39-03c544fecf40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v\[Dagger]", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v\[Dagger][$CellContext`a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"9a764153-3c25-461d-800d-3867862721e0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "test"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"f64d4294-acf1-4867-85e2-d478097f5ea0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {
          StyleBox["3",
           FontColor->RGBColor[1., 0., 1.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{3, $CellContext`test}],
  Editable->
   False]], "Output",ExpressionUUID->"3cdf4b98-050d-4230-92fc-976791d8fdd0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"13cb91a3-a3d4-47b7-a2f9-b1677c220753"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v\[Dagger]", 
      StyleBox[GridBox[{
         {
          StyleBox["4",
           FontColor->RGBColor[1., 0., 1.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v\[Dagger][{4, $CellContext`test}],
  Editable->
   False]], "Output",ExpressionUUID->"d572e9d3-5353-4d33-af86-e7355569d548"]
}, Open  ]],

Cell["\<\
If we need a more complicated structure then we need to use Dir, with any \
possible expression inside:\
\>", "Text",ExpressionUUID->"da3fcac1-a0ac-4426-9330-f33cf67d74a3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
   RowBox[{"Dir", "[", 
    RowBox[{"2", "I", " ", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", 
         RowBox[{"-", "test"}]}], "}"}], ",", "a"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"test", "/:", 
   RowBox[{"DaggerCIndex", "[", 
    RowBox[{"test", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
   RowBox[{"Dir", "[", 
    RowBox[{
     RowBox[{"I", "/", "2"}], " ", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "test"}]}], "}"}], ",", "a"}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"6bf2e679-84c2-4a66-8eed-03e2a462fabc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "test"}]}], "}"}], ",", "a"}], 
  "]"}]], "Input",ExpressionUUID->"af0e2b69-3747-42bd-bcc8-32712e0cc0be"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", "a"},
         {
          StyleBox["4",
           FontColor->RGBColor[1., 0., 1.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{4, -$CellContext`test}, $CellContext`a],
  Editable->
   False]], "Output",ExpressionUUID->"7d5f3867-3d88-444f-9a7b-4b0ad42ed8af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"f12d6e41-3028-4443-96e4-298c30fea5df"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"e", 
       StyleBox[GridBox[{
          {" ", "a"},
          {
           StyleBox["3",
            FontColor->RGBColor[1., 0., 1.]], " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Basis[{3, -$CellContext`test}, $CellContext`a],
   Editable->
    False]}]], "Output",ExpressionUUID->"85370bf7-f917-4d22-ad71-420f05111fdc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"4d7c08ec-b58c-42f8-9e2f-2f586614331a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", "a"},
         {
          StyleBox["4",
           FontColor->RGBColor[1., 0., 1.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{4, -$CellContext`test}, $CellContext`a],
  Editable->
   False]], "Output",ExpressionUUID->"d16b0c87-6935-4ee5-8112-7740fc97d39e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "test"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"db7f5ce2-2de8-4d1b-a7a9-982e66b1c929"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {
          StyleBox["3",
           FontColor->RGBColor[1., 0., 1.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{3, $CellContext`test}],
  Editable->
   False]], "Output",ExpressionUUID->"096af4a9-c041-4a9c-8b23-55c8636ea86b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"40a65692-c3dc-4d7c-8505-3efa63287bd1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v\[Dagger]", 
      StyleBox[GridBox[{
         {
          StyleBox["4",
           FontColor->RGBColor[1., 0., 1.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v\[Dagger][{4, $CellContext`test}],
  Editable->
   False]], "Output",ExpressionUUID->"e5b5e0d4-98c2-4d84-beb9-8daab252fd98"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"e214db03-d0d1-4de7-8df6-9bf511deeb31"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {
          StyleBox["3",
           FontColor->RGBColor[1., 0., 1.]]},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[{3, $CellContext`test}],
  Editable->
   False]], "Output",ExpressionUUID->"89757483-2ae0-459d-aa3f-2ae7a38149dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "test"}]], "Input",ExpressionUUID->"634bdc22-7ecd-460b-a6f7-8cc01365e305"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`test\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"BasisQ", "[", "test", "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"BasisColor", "[", "test", "]"}], "^=", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"VBundleOfBasis", "[", "test", "]"}], "^=", 
                    InterpretationBox[
                    StyleBox["\[DoubleStruckCapitalT]M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`TangentM,
                    Editable->False]}]},
                    {
                    RowBox[{"test", "/:", 
                    RowBox[{"CNumbersOf", "[", 
                    RowBox[{"test", ",", 
                    InterpretationBox[
                    StyleBox["\[DoubleStruckCapitalT]M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`TangentM,
                    Editable->False]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"etaOrientation", "[", "test", "]"}], "^=", "1"}]},
                    {
                    RowBox[{
                    RowBox[{"DependenciesOfBasis", "[", "test", "]"}], "^=", 
                    RowBox[{"{", "M", "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", "test", "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"basis\"\>", ",", "\<\"\"\>"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"HostsOf", "[", "test", "]"}], "^=", 
                    RowBox[{"{", 
                    InterpretationBox[
                    StyleBox["\[DoubleStruckCapitalT]M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`TangentM,
                    Editable->False], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PDOfBasis", "[", "test", "]"}], "^=", "PDtest"}]},
                    {
                    RowBox[{
                    RowBox[{"ServantsOf", "[", "test", "]"}], "^=", 
                    RowBox[{"{", "PDtest", "}"}]}]},
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", "test", "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`test],
                    Editable->False], "^=", "test"}]},
                    {
                    RowBox[{"test", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"test", ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "test"}], "}"}]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "test"}], "}"}]}]},
                    {
                    RowBox[{"test", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"test", ",", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "test"}], "}"}]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "test"}], "}"}]}]},
                    {
                    RowBox[{"test", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"test", ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", 
                    RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
                    RowBox[{"Dir", "[", 
                    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
                    InterpretationBox[
                    StyleBox[GridBox[{
                    {"e", 
                    StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["4",
                    FontColor->RGBColor[1., 0., 1.]], " "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    
                    xAct`xTensor`Basis[{
                    4, -$CellContext`test}, $CellContext`a],
                    Editable->False]}], "]"}]}]},
                    {
                    RowBox[{"test", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"test", ",", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", 
                    RowBox[{"-", "test"}]}], "}"}]}], "]"}], "=", 
                    RowBox[{"Dir", "[", 
                    RowBox[{
                    FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
                    InterpretationBox[
                    StyleBox[GridBox[{
                    {"e", 
                    StyleBox[GridBox[{
                    {" ", "a"},
                    {
                    StyleBox["3",
                    FontColor->RGBColor[1., 0., 1.]], " "}
                    },
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                    FontSize->Rational[39, 4]]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {{Center}}, "Rows" -> {{Center}}},
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    
                    xAct`xTensor`Basis[{
                    3, -$CellContext`test}, $CellContext`a],
                    Editable->False]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`test\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`test\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`test", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`test, {
      xAct`xTensor`BasisQ[$CellContext`test] -> True, 
       xAct`xCoba`BasisColor[$CellContext`test] -> RGBColor[1, 0, 1], 
       xAct`xCoba`VBundleOfBasis[$CellContext`test] -> $CellContext`TangentM, 
       xAct`xCoba`CNumbersOf[$CellContext`test, $CellContext`TangentM] -> {3, 
        4}, xAct`xCoba`etaOrientation[$CellContext`test] -> 1, 
       xAct`xCoba`DependenciesOfBasis[$CellContext`test] -> {$CellContext`M}, 
       xAct`xTensor`DefInfo[$CellContext`test] -> {"basis", ""}, 
       xAct`xTensor`HostsOf[$CellContext`test] -> {$CellContext`TangentM}, 
       xAct`xCoba`PDOfBasis[$CellContext`test] -> $CellContext`PDtest, 
       xAct`xTensor`ServantsOf[$CellContext`test] -> {$CellContext`PDtest}, 
       xAct`xTensor`Dagger[$CellContext`test] -> $CellContext`test, 
       xAct`xCoba`DaggerCIndex[$CellContext`test, {3, $CellContext`test}] -> {
        4, $CellContext`test}, 
       xAct`xCoba`DaggerCIndex[$CellContext`test, {4, $CellContext`test}] -> {
        3, $CellContext`test}, 
       xAct`xCoba`DaggerCIndex[$CellContext`test, {3, -$CellContext`test}] -> 
       xAct`xTensor`Dir[
        Complex[0, 2] 
         xAct`xTensor`Basis[{4, -$CellContext`test}, $CellContext`a]], 
       xAct`xCoba`DaggerCIndex[$CellContext`test, {4, -$CellContext`test}] -> 
       xAct`xTensor`Dir[Complex[0, 
           Rational[1, 2]] 
         xAct`xTensor`Basis[{3, -$CellContext`test}, $CellContext`a]]}], 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "Global`test"|>, 
   False]]], "Output",ExpressionUUID->"27f75f9b-4079-4ba8-bfd0-7163b3d6a7e1"]
}, Open  ]],

Cell["\<\
In the most general case we can define a consistent conjugation structure \
using SetDaggerMatrix:\
\>", "Text",ExpressionUUID->"6144a64c-f03b-4b6c-aab2-ac322a259b27"],

Cell[BoxData[
 RowBox[{"SetDaggerMatrix", "[", 
  RowBox[{"complex", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "5"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", 
       RowBox[{"-", "9"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"b3e58ffe-3989-4d96-8b37-31d8a74b314b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "complex"}], "}"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "5"}], "}"}]}], 
   "}"}]}]], "Input",ExpressionUUID->"ef6d0168-9fae-48a9-90e4-707da69be69d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{3, $CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{4, $CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["5",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{5, $CellContext`complex}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"46a499a0-d317-45b9-9594-8460c26061c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"016ad394-0f75-48dc-808c-cf3049e2bd11"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {"v\[Dagger]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v\[Dagger][{3, $CellContext`complex\[Dagger]}],
       Editable->False], "120"]}], "+", 
    FractionBox[
     RowBox[{"13", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v\[Dagger]", 
           StyleBox[GridBox[{
              {
               StyleBox["4",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v\[Dagger][{4, $CellContext`complex\[Dagger]}],
       Editable->False]}], "60"], "+", 
    FractionBox[
     RowBox[{"67", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v\[Dagger]", 
           StyleBox[GridBox[{
              {
               StyleBox["5",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v\[Dagger][{5, $CellContext`complex\[Dagger]}],
       Editable->False]}], "360"]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"7", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v\[Dagger]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v\[Dagger][{3, $CellContext`complex\[Dagger]}],
       Editable->False]}], "60"], "-", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{4, $CellContext`complex\[Dagger]}],
      Editable->False], "30"], "+", 
    FractionBox[
     RowBox[{"11", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v\[Dagger]", 
           StyleBox[GridBox[{
              {
               StyleBox["5",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v\[Dagger][{5, $CellContext`complex\[Dagger]}],
       Editable->False]}], "180"]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v\[Dagger]", 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[0., 0., 1.]]},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v\[Dagger][{3, $CellContext`complex\[Dagger]}],
       Editable->False]}], "40"], "+", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{4, $CellContext`complex\[Dagger]}],
      Editable->False], "20"], "-", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {
              StyleBox["5",
               FontColor->RGBColor[0., 0., 1.]]},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{5, $CellContext`complex\[Dagger]}],
      Editable->False], "120"]}]}], 
  "}"}]], "Output",ExpressionUUID->"d3ad526f-7798-40d3-94d5-fb7c7b3c3d1e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", "%", "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"b70e8b6a-ae9d-4d72-b269-225dbd14a874"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{3, $CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{4, $CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["5",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{5, $CellContext`complex}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"6639eec8-c591-4e39-944d-d7f9d422e38d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "complex"}]}], "}"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], "\[Rule]", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], "\[Rule]", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], "\[Rule]", "5"}], "}"}]}], 
   "}"}]}]], "Input",ExpressionUUID->"e033fc0f-07ca-41c3-9e8b-6942c9af4ede"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{3, -$CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{4, -$CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["5",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{5, -$CellContext`complex}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"8a80d3c5-a993-434d-b651-30012f429b22"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"c9d8950f-28b4-43ab-9e58-e1a5472769c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{3, -$CellContext`complex\[Dagger]}],
      Editable->False]}], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{4, -$CellContext`complex\[Dagger]}],
      Editable->False]}], "+", 
    RowBox[{"3", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["5",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{5, -$CellContext`complex\[Dagger]}],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{"4", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{3, -$CellContext`complex\[Dagger]}],
      Editable->False]}], "-", 
    RowBox[{"5", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{4, -$CellContext`complex\[Dagger]}],
      Editable->False]}], "+", 
    RowBox[{"6", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["5",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{5, -$CellContext`complex\[Dagger]}],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{"7", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{3, -$CellContext`complex\[Dagger]}],
      Editable->False]}], "+", 
    RowBox[{"8", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["4",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{4, -$CellContext`complex\[Dagger]}],
      Editable->False]}], "-", 
    RowBox[{"9", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v\[Dagger]", 
          StyleBox[GridBox[{
             {" "},
             {
              StyleBox["5",
               FontColor->RGBColor[0., 0., 1.]]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v\[Dagger][{5, -$CellContext`complex\[Dagger]}],
      Editable->False]}]}]}], 
  "}"}]], "Output",ExpressionUUID->"131aea2a-f682-4ff8-bc83-35f9fcb2b005"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", "%", "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"93877927-554a-4e22-b70f-1c08e531fbb6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{3, -$CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{4, -$CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["5",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{5, -$CellContext`complex}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"5e94b689-afde-4f93-ae6b-297003d29cc6"]
}, Open  ]],

Cell["Trivial case:", \
"Text",ExpressionUUID->"062d04f1-4add-444e-bcf0-142ed7a0645d"],

Cell[BoxData[
 RowBox[{"SetDaggerMatrix", "[", 
  RowBox[{"complex", ",", 
   RowBox[{"IdentityMatrix", "[", "3", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"dfdff701-f9b7-456a-af4a-040d1f11bef0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "complex"}]], \
"Input",ExpressionUUID->"63ea3844-c54e-4724-b7ad-835db53d38ac"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`complex\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"BasisColor", "[", "complex", "]"}], "^:=", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"BasisQ", "[", "complex", "]"}], "^:=", 
                    "True"}]},
                    {
                    RowBox[{"complex", "/:", 
                    RowBox[{"CNumbersOf", "[", 
                    RowBox[{"complex", ",", 
                    InterpretationBox[
                    StyleBox["InnerC",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC,
                    Editable->False]}], "]"}], ":=", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}]},
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", "complex", "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`complex],
                    Editable->False], "^:=", "complex\[Dagger]"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", "complex", "]"}], "^:=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"basis\"\>", ",", "\<\"\"\>"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"DependenciesOfBasis", "[", "complex", "]"}], "^:=", 
                    RowBox[{"{", "M", "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"etaOrientation", "[", "complex", "]"}], "^:=", 
                    "1"}]},
                    {
                    RowBox[{
                    RowBox[{"HostsOf", "[", "complex", "]"}], "^:=", 
                    RowBox[{"{", 
                    InterpretationBox[
                    StyleBox["InnerC",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC,
                    Editable->False], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PDOfBasis", "[", "complex", "]"}], "^:=", 
                    "PDcomplex"}]},
                    {
                    RowBox[{
                    RowBox[{"ServantsOf", "[", "complex", "]"}], "^:=", 
                    RowBox[{"{", 
                    RowBox[{"PDcomplex", ",", "complex\[Dagger]"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"VBundleOfBasis", "[", "complex", "]"}], "^:=", 
                    InterpretationBox[
                    StyleBox["InnerC",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`InnerC,
                    Editable->False]}]},
                    {
                    RowBox[{"complex", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"complex", ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", 
                    RowBox[{"-", "complex"}]}], "}"}]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", 
                    RowBox[{"-", "complex\[Dagger]"}]}], "}"}]}]},
                    {
                    RowBox[{"complex", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"complex", ",", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", 
                    RowBox[{"-", "complex"}]}], "}"}]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", 
                    RowBox[{"-", "complex\[Dagger]"}]}], "}"}]}]},
                    {
                    RowBox[{"complex", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"complex", ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", 
                    RowBox[{"-", "complex"}]}], "}"}]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", 
                    RowBox[{"-", "complex\[Dagger]"}]}], "}"}]}]},
                    {
                    RowBox[{"complex", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"complex", ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "complex"}], "}"}]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "complex\[Dagger]"}], "}"}]}]},
                    {
                    RowBox[{"complex", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"complex", ",", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "complex"}], "}"}]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "complex\[Dagger]"}], "}"}]}]},
                    {
                    RowBox[{"complex", "/:", 
                    RowBox[{"DaggerCIndex", "[", 
                    RowBox[{"complex", ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "complex"}], "}"}]}], "]"}], "=", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "complex\[Dagger]"}], "}"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`complex\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`complex\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`complex", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`complex, {
      xAct`xCoba`BasisColor[$CellContext`complex] :> RGBColor[0, 0, 1], 
       xAct`xTensor`BasisQ[$CellContext`complex] :> True, 
       xAct`xCoba`CNumbersOf[$CellContext`complex, $CellContext`InnerC] :> {3,
         4, 5}, xAct`xTensor`Dagger[$CellContext`complex] :> \
$CellContext`complex\[Dagger], 
       xAct`xTensor`DefInfo[$CellContext`complex] :> {"basis", ""}, 
       xAct`xCoba`DependenciesOfBasis[$CellContext`complex] :> \
{$CellContext`M}, xAct`xCoba`etaOrientation[$CellContext`complex] :> 1, 
       xAct`xTensor`HostsOf[$CellContext`complex] :> {$CellContext`InnerC}, 
       xAct`xCoba`PDOfBasis[$CellContext`complex] :> $CellContext`PDcomplex, 
       xAct`xTensor`ServantsOf[$CellContext`complex] :> \
{$CellContext`PDcomplex, $CellContext`complex\[Dagger]}, 
       xAct`xCoba`VBundleOfBasis[$CellContext`complex] :> $CellContext`InnerC,
        xAct`xCoba`DaggerCIndex[$CellContext`complex, {
         3, -$CellContext`complex}] -> {3, -$CellContext`complex\[Dagger]}, 
       xAct`xCoba`DaggerCIndex[$CellContext`complex, {
         4, -$CellContext`complex}] -> {4, -$CellContext`complex\[Dagger]}, 
       xAct`xCoba`DaggerCIndex[$CellContext`complex, {
         5, -$CellContext`complex}] -> {5, -$CellContext`complex\[Dagger]}, 
       xAct`xCoba`DaggerCIndex[$CellContext`complex, {
         3, $CellContext`complex}] -> {3, $CellContext`complex\[Dagger]}, 
       xAct`xCoba`DaggerCIndex[$CellContext`complex, {
         4, $CellContext`complex}] -> {4, $CellContext`complex\[Dagger]}, 
       xAct`xCoba`DaggerCIndex[$CellContext`complex, {
         5, $CellContext`complex}] -> {5, $CellContext`complex\[Dagger]}}], 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "Global`complex"|>, 
   False]]], "Output",ExpressionUUID->"e5ae56aa-7bbc-479c-8ae3-10f2b0117be9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "complex"}], "}"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "5"}], "}"}]}], 
   "}"}]}]], "Input",ExpressionUUID->"178cfd50-5722-46b2-bd5f-389e3396789f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{3, $CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{4, $CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["5",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{5, $CellContext`complex}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"0f7a0f1d-f0fe-4f62-a8d6-a46b8d36737e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"06c34d1f-7093-452a-8b97-09fe3ea5f989"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v\[Dagger]", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v\[Dagger][{3, $CellContext`complex\[Dagger]}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v\[Dagger]", 
        StyleBox[GridBox[{
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v\[Dagger][{4, $CellContext`complex\[Dagger]}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v\[Dagger]", 
        StyleBox[GridBox[{
           {
            StyleBox["5",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v\[Dagger][{5, $CellContext`complex\[Dagger]}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"c65f884b-3458-4fec-947e-728e57804ef0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", "%", "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"a78425db-5fa8-4262-9443-6f928ff1b939"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{3, $CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{4, $CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {
            StyleBox["5",
             FontColor->RGBColor[0., 0., 1.]]},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{5, $CellContext`complex}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"eb7448c9-3146-45dd-b67c-a59ea9db3d53"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "complex"}]}], "}"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], "\[Rule]", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], "\[Rule]", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], "\[Rule]", "5"}], "}"}]}], 
   "}"}]}]], "Input",ExpressionUUID->"040a2a6c-9a01-48c5-8a4e-b076fa2519d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{3, -$CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{4, -$CellContext`complex}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["5",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[{5, -$CellContext`complex}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"c23ad155-2488-4204-b53e-835f79d7cb9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"f1de059e-17c1-4095-8412-d328de5d9f7f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v\[Dagger]", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v\[Dagger][{3, -$CellContext`complex\[Dagger]}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v\[Dagger]", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v\[Dagger][{4, -$CellContext`complex\[Dagger]}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v\[Dagger]", 
        StyleBox[GridBox[{
           {" "},
           {
            StyleBox["5",
             FontColor->RGBColor[0., 0., 1.]]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v\[Dagger][{5, -$CellContext`complex\[Dagger]}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"df0fcc46-2860-407d-b1ff-97396892e242"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Dagger", "[", "%", "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"ac9a438c-5cc6-4665-8c69-d564bb26e83f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
 