Notebook[{

Cell[CellGroupData[{
Cell["xCore", "Title",
 FontColor->RGBColor[
  1, 0, 0],ExpressionUUID->"7bdb491f-bf46-4814-87f2-fe3eb99a17e7"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[" tools for the ",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["xAct",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[" framework",
  FontColor->RGBColor[0, 0, 1]]
}], "Subtitle",ExpressionUUID->"d9e6bf74-bf2d-4dd5-a812-071b054aaddb"],

Cell[TextData[{
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a\n",
  FontSize->18],
 "jose@xact.es\n\n(c) 2007-2020, under GPL\n\nhttp://www.xact.es/\n\n\
http://groups.google.com/group/xAct"
}], "Subsubtitle",ExpressionUUID->"462da30e-1a99-458b-a541-68ff51690865"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["0. Info and copyright",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"9f86b6c0-c683-4ee6-88f0-b8dc3b0fa84d"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}],
    "*", " ", "0.", " ", "Info", " ", "and", " ", 
   RowBox[{"copyright", " ", "**", "**", "**"}]}], 
  "*****************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"91b10e02-5361-45e4-bd02-399794400807"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "/@", 
  RowBox[{
  "Date", "[", 
   "]"}]}]], "Input",ExpressionUUID->"daf495ba-4791-4de2-9d24-31b05a7afe3d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2018", ",", "3", ",", "2", ",", "23", ",", "59", ",", "6"}], 
  "}"}]], "Output",ExpressionUUID->"7770dc13-cfa2-410e-86a2-bd61a478c854"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xCore`$Version", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<0.6.10\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6bb6202d-e68a-4f7e-b291-fccad224d13d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0.6.10\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"62213d36-9dcd-4e9f-b362-fc3c1f134fe2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$SessionID"], \
"Input",ExpressionUUID->"c6e550a0-5085-4a8f-94cb-0dfbf2e433d5"],

Cell[BoxData["19253854462994522918"], \
"Output",ExpressionUUID->"6eaba8ee-bbdb-49ad-8ef4-38b7821db6a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["0.1. GPL", \
"Subsection",ExpressionUUID->"692c8449-1ed9-414e-a4eb-8cd3536aa992"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xCore", ",", " ", 
    RowBox[{
    "basic", " ", "functional", " ", "additions", " ", "to", " ", 
     "Mathematica"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Copyright", " ", 
     RowBox[{"(", "C", ")"}], " ", "2007"}], "-", 
    RowBox[{"2020", " ", "Jose", " ", 
     RowBox[{"M", ".", " ", "Martin"}]}], "-", "Garcia"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", "\[IndentingNewLine]", " ", 
      "it", " ", "under", " ", "the", " ", "terms", " ", "of", " ", "the", 
      " ", "GNU", " ", "General", " ", "Public", " ", "License", " ", "as", 
      " ", "published", "\[IndentingNewLine]", " ", "by", " ", "the", " ", 
      "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], 
     " ", "program", " ", "is", " ", "distributed", " ", "in", " ", "the", 
     " ", "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", 
     "useful"}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", " ", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", 
      "\[IndentingNewLine]", " ", "General", " ", "Public", " ", "License", 
      " ", "for", " ", "more", " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], 
      " ", "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ",
       "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", "\[IndentingNewLine]", " ", "along", " ", "with", " ", 
      "this", " ", "program"}], ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", 
     "\[IndentingNewLine]", " ", "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"10d221af-5382-48c1-b11c-734de4ebd8ee"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.2. Info package", \
"Subsection",ExpressionUUID->"31af6492-ad02-4ece-8023-ea55554142fe"],

Cell["\<\
(* :Title: xCore *)

(* :Author: Jose M. Martin-Garcia *)

(* :Summary: Programming tools for xAct *)

(* :Brief Discussion:
*)
  
(* :Context: xAct`xCore` *)

(* :Package Version: 0.6.9 *)

(* :Copyright: Jose M. Martin-Garcia 2007-2020 *)

(* :History: see xCore.History file *)

(* :Keywords: *)

(* :Source: xCore.nb *)

(* :Warning: Still experimental! *)

(* :Mathematica Version: 6.0 and later *)

(* :Limitations: unlimited limitations *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->
  True,ExpressionUUID->"291e1a4c-ab95-433c-b8e6-f8b52d22198a"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.3. TODO list", \
"Subsection",ExpressionUUID->"f6d5978f-94bb-4a09-905e-451ae2f164ff"],

Cell["\<\
- SetNumberOfArguments does not remove previous definitions. This is wrong \
when the second use of SetNumberOfArguments is less restrictive than its \
first use.
- TildeString and Underline do not detect blanks.\
\>", "Text",ExpressionUUID->"e1e81d80-e1ab-4b4c-b9e4-a9e37e5e8150"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1. Begin package",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"e5f49c33-c475-4c0d-b9dc-007f62b3bcf6"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}],
    "*", " ", "1.", " ", "Begin", " ", "package"}], " ", 
  "***********************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f0cd8180-6d8f-4423-9eb9-9886f4f33071"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"50ce1888-769b-4172-96f9-dbe647765913"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.97427`", ",", "1.594657`6.654212277110731", ",", "0.6109653828715982`"}],
   "}"}]], "Output",ExpressionUUID->"131759cf-514f-4888-b51d-856f08b04e50"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.1. BeginPackage", \
"Subsection",ExpressionUUID->"4dd570ba-13cc-428e-a1f2-37266aa472da"],

Cell["Protect against multiple loading of the package:", \
"Text",ExpressionUUID->"a8a97f59-160b-49a8-be5d-c341e22c611c"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xAct`xCore`Private`xCoreSymbols", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Names", "[", "\"\<xAct`xCore`*\>\"", "]"}], ",", 
         RowBox[{"Names", "[", "\"\<xAct`xCore`Private`*\>\"", "]"}]}], "]"}],
        ",", 
       RowBox[{
       "\"\<$Version\>\"", "|", "\"\<xAct`xCore`$Version\>\"", "|", 
        "\"\<xAct`xCore`Private`$LastPackage\>\""}]}], "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "/@", "xAct`xCore`Private`xCoreSymbols"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Clear", "/@", "xAct`xCore`Private`xCoreSymbols"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a24860a6-843a-4116-98ed-c5065fcbf0a4"],

Cell[TextData[{
 "The first action is detecting the directory in which ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " has been placed. See notebook Directories.nb for further help on the \
structure of relevant directories in ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"]
}], "Text",ExpressionUUID->"fadd5713-4a1e-4075-b38c-fc554c567f55"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"System`$VersionNumber", "<", "6.5"}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Old", " ", "definitions"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"xAct`xCore`$xActDirectory", "=", 
      RowBox[{"First", "@", 
       RowBox[{"FileNames", "[", 
        RowBox[{"\"\<xAct\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
          "$UserBaseDirectory", ",", "$BaseDirectory", ",", 
           "$InstallationDirectory"}], "}"}], ",", "Infinity"}], "]"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"xAct`xCore`$xActDocDirectory", "=", 
      RowBox[{"StringJoin", "[", 
       RowBox[{
       "xAct`xCore`$xActDirectory", ",", "\"\</Documentation/English\>\""}], 
       "]"}]}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "FindFile", " ", "will", " ", "find", " ", "the", " ", "package", " ", 
      "in", " ", "the", " ", "same", " ", "place", " ", "that", " ", "Get", 
      " ", "found", " ", 
      RowBox[{"it", ".", " ", "Thanks"}], " ", 
      RowBox[{"Teake", "!"}]}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"xAct`xCore`$xActDirectory", "=", 
      RowBox[{"DirectoryName", "[", 
       RowBox[{
        RowBox[{"FindFile", "[", "\"\<xAct`xPerm`\>\"", "]"}], ",", "3"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"xAct`xCore`$xActDocDirectory", "=", 
      RowBox[{"StringJoin", "[", 
       RowBox[{
       "xAct`xCore`$xActDirectory", ",", "\"\<Documentation/English\>\""}], 
       "]"}]}]}]}], "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6ad2aa3a-5487-4ae1-b82f-c8926b35511e"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`$xActDirectory"], \
"Input",ExpressionUUID->"2faf09b9-26e5-4a37-bccc-0f96350f20a6"],

Cell[BoxData["\<\"/Users/jose/Library/Mathematica/Applications/xAct/\"\>"], \
"Output",ExpressionUUID->"5eb09200-0b2e-47ab-b999-46eee9523b6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`$xActDocDirectory"], \
"Input",ExpressionUUID->"3c262103-658f-4c0e-9809-332abc309bc4"],

Cell[BoxData["\<\"/Users/jose/Library/Mathematica/Applications/xAct/\
Documentation/English\"\>"], \
"Output",ExpressionUUID->"c93a25ff-9baa-4025-8b1e-01b2059087d2"]
}, Open  ]],

Cell[TextData[{
 "Now we need to know which package is actually calling ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 ". This will be included in the variable $xAct`xCore`Private`$LastPackage:"
}], "Text",ExpressionUUID->"56dea6a3-bd73-445a-9911-8538dbdfe745"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{"xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`xCore`\>\""}]}],
    "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3c331e40-5540-46de-9f5a-def4989c8f48"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], \
"Input",ExpressionUUID->"b45ee183-6dea-429a-bc96-7d8ab1568d73"],

Cell[BoxData["\<\"xAct`xCore`\"\>"], \
"Output",ExpressionUUID->"f6b38675-c590-4a4d-ae1a-d62a24ff5398"]
}, Open  ]],

Cell[TextData[{
 "We use the external package ",
 StyleBox["ExpressionManipulation",
  FontSlant->"Italic"],
 ", developed by David J. M. Park and Ted Ersek. It is a great package! I \
don't have any idea about its version number. Deactivated in version 0.6.2. \
This is to avoid treating it as a xAct package; now the user needs to load it \
explicitly, as with ShowTime1."
}], "Text",ExpressionUUID->"d5b4a762-4253-4978-a25b-8effb977f077"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`xCore`\>\"", ",", 
   RowBox[{"{", "\"\<xAct`ExpressionManipulation\>\"", "}"}]}], 
  "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"27348be1-c27a-4524-995e-ad093c62e0ef"],

Cell[BoxData["\<\"xAct`xCore`\"\>"], \
"Output",ExpressionUUID->"8cda5b84-c738-4916-9704-54a7b467b7d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", "\"\<xAct`xCore`\>\"", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"81471861-379d-4d9e-bc3d-72543d2da8b6"],

Cell[BoxData["\<\"xAct`xCore`\"\>"], \
"Output",ExpressionUUID->"037c9d92-d4a0-46af-a95d-620507903d45"]
}, Open  ]],

Cell["Message:", \
"Text",ExpressionUUID->"82ba6a77-35b0-4085-a793-0d171e4e8ca5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xAct`xCore`Private`$barslength", "=", "60"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xCore`Private`bars", "=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<-\>\"", ",", 
      RowBox[{"{", "xAct`xCore`Private`$barslength", "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f9b20138-42d2-4824-9370-0edcafd17b83"],

Cell[BoxData[{
 RowBox[{"Print", "[", "xAct`xCore`Private`bars", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<Package ExpressionManipulation`\>\"", 
  "]"}], "\[LineSeparator]", 
 RowBox[{"Print", "[", 
  "\"\<CopyRight (C) 1999-2018, David J. M. Park and Ted Ersek\>\"", 
  "]"}]}], "Input",
 Evaluatable->False,ExpressionUUID->"a76c78c8-50de-4ad6-876f-3e2cbfe10eb7"],

Cell[TextData[{
 "If ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " is the last package being read, print the GPL message and unset \
$LastPackage (this is because if more ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " packages are loaded later then the GPL message must be printed again):"
}], "Text",ExpressionUUID->"afee25a8-3f7c-459b-be18-688f6aa027b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`xCore`\>\""}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Package xAct`xCore`  version \>\"", ",", 
       RowBox[{"xAct`xCore`$Version", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
       RowBox[{"xAct`xCore`$Version", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", 
      "\"\<CopyRight (C) 2007-2020, Jose M. Martin-Garcia, under the General \
Public License.\>\"", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", 
      "\"\<This package comes with ABSOLUTELY NO WARRANTY; for details type \
Disclaimer[]. This is free software, and you are welcome to redistribute it \
under certain conditions. See the General Public License for details.\>\"", 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bd4fa1f8-5ea7-4983-a61d-800bc55f9cb8"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"73f57efe-db75-47b6-9e20-59df07147069"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCore`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.6.10\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCore`  version ", "0.6.10", ", ", {2018, 2, 28}],
  Editable->
   False]], "Print",ExpressionUUID->"af08d9a3-04de-4e96-9393-e7ffc7a92269"],

Cell[BoxData["\<\"CopyRight (C) 2007-2018, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], \
"Print",ExpressionUUID->"964f62d6-cc5f-4aa4-b27f-2feb7ddbc2c1"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"c07abf5e-a3fc-4c01-b244-6a22e440f8a1"],

Cell[BoxData["\<\"This package comes with ABSOLUTELY NO WARRANTY; for details \
type Disclaimer[]. This is free software, and you are welcome to redistribute \
it under certain conditions. See the General Public License for \
details.\"\>"], \
"Print",ExpressionUUID->"6015b876-21bf-4c3f-9973-ec012e48a09b"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"f62e69d2-5f0b-4515-8c31-28455ceeace7"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "We specify the context xAct`xCore` to avoid overriding the Disclaimer of \
the other ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " packages. However we need to turn off the message General:shdw temporarily:"
}], "Text",ExpressionUUID->"f9759020-1e38-417f-82ff-4d33291cbff5"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xCore`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", 
   "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b92bdd70-7a03-408d-b382-771aa27ad193"],

Cell["\<\
Eliminate annoying spell messages (included in the package, though it is not \
really needed since version 6):\
\>", "Text",ExpressionUUID->"92be8d4c-524f-4f96-8cd5-c2aa8c68a73e"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell1"}], "]"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"244f0266-f2a8-4194-afc5-61962edf40b9"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], \
"Input",ExpressionUUID->"2227ad0d-3156-49be-a146-1cd63bf36db1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"aacb4ea2-1324-4b22-b039-a7098b1402e7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Usage messages", \
"Subsection",ExpressionUUID->"a2e2251c-493b-499e-be8d-16fda291f110"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Directories", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$xActDirectory", "::", "usage"}], "=", 
     "\"\<$xActDirectory is a global variable containing the directory where \
the xAct directory has been placed. The two recommended options are \
$UserBaseDirectory/Applications/xAct for a user-based installation or \
$BaseDirectory/Applications/xAct for a system-wide installation. The third \
possible place is $InstallationDirectory/AddOns/Applications/xAct, also for a \
system-wide installation.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$xActDocDirectory", "::", "usage"}], "=", 
     "\"\<$xActDocDirectory is a global variable containing the directory \
with the Documentation of xAct. It is the subdirectory Documentation/English \
of $xActDirectory.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ba44e7bb-01cb-470c-b8b4-89c7001d5728"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Warnings", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"$WarningFrom", "::", "usage"}], "=", 
    "\"\<$WarningFrom is a global variable which is set to different values \
in different parts of the code. It is used to get an idea of where the \
warning messages are coming from.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7af5ce33-b0dc-44e9-add2-6ef6e6d5dfa0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Replacements", ".", " ", "Not"}], " ", "in", " ", "the", " ", 
    "package"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ReplaceLast", "::", "usage"}], "=", 
    "\"\<ReplaceLast[expr, rules] maps ReplaceAll with the given rules onto \
the last element of expr.\>\""}], 
   ";"}]}]], "Input",ExpressionUUID->"0b036fc4-aa7f-466f-97ab-93ce9fad36ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Folded", " ", "rules"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"FoldedRule", "::", "usage"}], "=", 
     "\"\<FoldedRule[rules1, rules2, ...] contains a number of lists of rules \
which are applied sequentially (first rules1, then rules2, etc.) when called \
by ReplaceAll and ReplaceRepeated.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CollapseFoldedRule", "::", "usage"}], "=", 
     "\"\<CollapseFoldedRule[frule, {n, m}] converts the elements n to m of \
the foldedrule frule into a single list of replacements in terms of the \
independent objects at level m. The positional argument follows the notation \
of Take: both n, m or just m can be negative, counting from the end; a single \
positive integer m represents {1, m}; a single negative integer -n represents \
{-n, -1}. A third argument can be given specifying a function to be mapped on \
all rules after collapsing a new level. CollapseFoldedRule[frule] or \
CollapseFoldedRule[frule, All] are interpreted as collapse of all elements of \
frule.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9c880c05-d844-46ee-9df9-cf238917bde5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Dependent", " ", "and", " ", "independent", " ", "rules"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"IndependentRules", "::", "usage"}], "=", 
     "\"\<IndependentRules[rules] returns a list with the subset of rules of \
the form x->x. On a FoldedRule expression it returns a list with the last \
rules.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DependentRules", "::", "usage"}], "=", 
     "\"\<DependentRules[rules] return a list with the subset of rules not of \
the form x->x. On a FoldedRule expression ir returns the first list of rules.\
\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "AppendToUnevaluated", " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AppendToUnevaluated", "::", "usage"}], "=", 
     "\"\<AppendToUnevaluated[symbol, value] works like AppendTo[symbol, \
value] but none of the elements of the expression associated to symbol is \
evaluated.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"04974bfd-3734-482f-a8c7-2be3f9d3802a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Number", " ", "of", " ", "arguments"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xAct`xCore`Private`setargs", "::", "usage"}], "=", 
     "\"\<xAct`xCore`Private`setargs[head, found, expected] sets a definition \
for head[args] such that if the number of arguments found is not compatible \
with the number of arguments expected then an error message is sent (not \
thrown). Number found must be an integer or Infinity, whereas expected can be \
an integer or Infinity or a range indicated by a list of two integers {m, n} \
or an integer and Infinity {m, Infinity}.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetNumberOfArguments", "::", "usage"}], "=", 
     "\"\<SetNumberOfArguments[function, expected] sets several definitions \
for head[args] using the (private) function setargs for those cases which are \
incompatible with the expected number or range of arguments. The format for \
expected is explained in setargs.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a450b0fb-ca4c-41e2-b320-e34a16525d2e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Small", " ", "functions", " ", "for", " ", "lists"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"JustOne", "::", "usage"}], "=", 
     "\"\<JustOne[{expr}] gives expr, or an error otherwise.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MapIfPlus", "::", "usage"}], "=", 
     "\"\<MapIfPlus[f, expr] maps f on the elements of expr if expr has head \
Plus, or returns f[expr] otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"System`$VersionNumber", "<", "6.5"}], ",", 
      RowBox[{
       RowBox[{"DeleteDuplicates", "::", "usage"}], "=", 
       "\"\<DeleteDuplicates[list] gives the union of the elements of list, \
keeping the original order. The elements of list are evaluated before the \
union is taken. The expression list may have head other than List.\>\""}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"System`$VersionNumber", "<", "9.0"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"DuplicateFreeQ", "::", "usage"}], "=", 
       "\"\<DuplicateFreeQ[list] returns True if there are no identical \
elements in the list, and False otherwise.\>\""}]}], "\[IndentingNewLine]", 
     "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3eb098b8-1eae-49e7-9c40-8da17779810d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Combination", " ", "of", " ", "names"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SymbolJoin", "::", "usage"}], "=", 
    "\"\<SymbolJoin[s1, s2, ...] generates a new symbol joining together the \
symbols, numbers or strings si, after evaluating them.\>\""}], 
   ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"401c468b-9fd7-4d07-a392-daeeae6a8163"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Convert", " ", "named", " ", "patterns", " ", "into", " ", "their", " ", 
    "names"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"NoPattern", "::", "usage"}], "=", 
    "\"\<NoPattern[expr] converts the named patterns in expr into their \
names.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"896badaf-ee22-4e92-9014-b08056c2e7c7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"String", " ", "modification"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Underline", "::", "usage"}], "=", 
     "\"\<Underline[x] returns a string with x underlined. The string form of \
x must not contain blanks. Underline[x, color] prints colored underlines (but \
x is not colored).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Overline", "::", "usage"}], "=", 
     "\"\<Overline[x] returns a string with x overlined. The string form of x \
must not contain blanks. overline[x, color] prints colored overlines (but x \
is not colored).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TildeString", "::", "usage"}], "=", 
     "\"\<TildeString[x, n] returns a string with n tildes over x if n>0 and \
n tildes below x if n<0. When n is not an integer, n is replaced by 1. \
TildeString[x, n, color] prints colored tildes (but x is not colored).\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ColorString", "::", "usage"}], "=", 
     "\"\<ColorString[atom, color] returns a string with atom printed in \
color.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HatString", "::", "usage"}], "=", 
     "\"\<HatString[x, n] returns a string with n hats over x if n>0 and n \
hats below x if n<0. When n is not an integer, n is replaced by 1. \
HatString[x, n, color] prints colored hats (but x is not colored).\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2120aab8-25aa-4e18-8f39-03c68aac3e21"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Options", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CheckOptions", "::", "usage"}], "=", 
     "\"\<CheckOptions[options] checks that options have the right rule \
structure and that the tensor rank of {options} is either 1 or 2. If True, it \
returns Flatten[{options}, 1]. If False, it throws an error.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TrueOrFalse", "::", "usage"}], "=", 
     "\"\<TrueOrFalse[True] and TrueOrFalse[False] give True. Any other \
argument gives False.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"be89b39e-e75b-4fba-b6d8-a09fe2b87a72"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Array", " ", "manipulation"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ThreadArray", "::", "usage"}], "=", 
    "\"\<ThreadArray[head[array1, array2]] threads head over pairs of \
elements of the two arrays.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b3dd400c-3aa4-4c11-b4c7-2c7b1f0de0fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "xUpvalues", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xUpSet", "::", "usage"}], "=", 
     "\"\<xUpSet[f[x], rhs] sets an upvalue for x using UpSet[f[x], rhs] but \
first unprotects x and finally protects it if it was initially \
protected.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xUpSetDelayed", "::", "usage"}], "=", 
     "\"\<xUpSetDelayed[f[x], rhs] sets a delayed upvalue for x using \
UpSetDelayed[f[x], rhs] but first unprotects x and finally protects it if it \
was initially protected.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xUpAppendTo", "::", "usage"}], "=", 
     "\"\<xUpAppendTo[f[x], e] assumes that f[x] is a list of elements \
associated to x as an upvalue and appends the element e to it, resetting the \
association. If f[x] does not have a value, it is initialized in the first \
place to {}.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xUpDeleteCasesTo", "::", "usage"}], "=", 
     "\"\<xUpDeleteCasesTo[f[x], cases] assumes that f[x] is a list of \
elements associated to x as an upvalue and removes cases from the list, \
resetting the association.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xTagSet", "::", "usage"}], "=", 
     "\"\<xTagSet[{f, lhs}, rhs] assigns rhs to be the value of lhs, and \
associates the assignment with the symbol f. There are two differences with \
TagSet: 1) The symbol f is unprotected and later protected again if required; \
2) xTagSet evaluates rhs (consistently with all other Set functions), but \
TagSet does not evaluate it!\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xTagSetDelayed", "::", "usage"}], "=", 
     "\"\<xTagSetDelayed[{f, lhs}, rhs] assigns rhs to be the delayed value \
of lhs, and associates the assignment with the symbol f. The only difference \
with TagSetDelayed is that the symbol f is unprotected and later protected \
again if required.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SubHead", "::", "usage"}], "=", 
     "\"\<SubHead[expr] returns the atom obtained after nesting Head as many \
times as needed.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4c8deb5e-220d-452c-a1a8-0791eafd1015"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "MapRule", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"MapRuleR", "::", "usage"}], "=", 
     "\"\<MapRuleR[f, expr] maps f onto the second argument of all Rule or \
RuleDelayed expressions of expr.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MapRuleL", "::", "usage"}], "=", 
     "\"\<MapRuleL[f, expr] maps f onto the first argument of all Rule or \
RuleDelayed expressions of expr.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"efefe380-5911-466d-9478-677604465a00"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Linking", " ", "symbols"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$LinkCharacter", "::", "usage"}], "=", 
     "\"\<$LinkCharacter is a global variable containing a single character \
to be used in linking symbols to define a new symbol. By default we use the \
symbol \\\"\[UnderBracket]\\\" (under-bracket), imitating the package \
Notations.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LinkSymbols", "::", "usage"}], "=", 
     "\"\<LinkSymbols[{s1, s2, ...}] returns a single symbol formed by \
joining the symbols s1, s2, ... inserting the charcter $LinkCharacter in \
between any two of them.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UnlinkSymbol", "::", "usage"}], "=", 
     "\"\<UnlinkSymbol[symbol] returns a list of symbols obtained by breaking \
the given symbol at those points having the character $LinkCharacter.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"56d1fc5c-abdb-4102-bd78-5d280fd9dde5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Evaluation", " ", "functions"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xEvaluateAt", "::", "usage"}], "=", 
     "\"\<xEvaluateAt[expr, pos] forces evaluation of expr at the position \
indicated by pos. xEvaluateAt[expr, {pos1, pos2, ...}] forces evaluation at \
several positions.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xAct`xCore`Private`HoldMap", "::", "usage"}], "=", 
     "\"\<xAct`xCore`Private`HoldMap[f, expr] maps and evaluates f on the \
elements of expr without evaluating the whole expression, which is returned \
wrapped in xHold. xAct`xCore`Private`HoldMap[f, expr, g] returns the \
expression wrapped with the function g.\>\""}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"xHold", "::", "usage"}], "=", 
     "\"\<xHold reproduces the behaviour of HoldForm, but with much lower \
precedence. It is introduced to avoid conflicts with the use of HoldForm by \
the user.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bad9a24c-66f2-4c88-be06-17a6708700f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"DefType", " ", "command", " ", "xtension"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xTension", "::", "usage"}], "=", 
     "\"\<xTension[package, defcommand, moment]:=func declares func[args] to \
be executed at some moment during the execution of a defcommand \
(DefType[args] or UndefType[args]) in the xAct packages. This allows \
extensions of commands like DefMetric without actually modifying the code of \
xTensor. defcommand must be a symbol, like DefMetric or UndefMetric. package \
must be a string with the name of the package making the extension, and this \
is used to separate the extensions of different packages. Currently moment \
must be either \\\"Beginning\\\" or \\\"End\\\", representing whether the \
code is executed at the beginning or the end of the defcommand. The code is \
provided as a function func taking the same arguments args as \
defcommand[args].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakexTensions", "::", "usage"}], "=", 
     "\"\<MakexTensions[defcommand, moment, symbol] collects the xTension \
expressions defined for defcommand at the given moment (\\\"Beginning\\\" or \
\\\"End\\\") and applies them to the symbol being defined.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"53b16345-202c-4ebf-88ec-d81862c93caa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Change", " ", "configuration", " ", "variables"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ReportSet", "::", "usage"}], "=", 
     "\"\<ReportSet[var, val] sets assigns the value val to the variable var, \
reporting it if the variable had before a different value.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ReportSetOption", "::", "usage"}], "=", 
     "\"\<ReportSetOption[s, opt->val] sets the value val for the option opt \
of the symbol s, reporting it if the option had before a different \
value.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5d96a7d1-5c45-4800-900c-b0f8de4fa1d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Functions", " ", "for", " ", "previous", " ", "versions", " ", "of", " ", 
    "Mathematica"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"$VersionNumber", "<", "4.1"}], ",", 
     RowBox[{
      RowBox[{"Ordering", "::", "usage"}], "=", 
      "\"\<Ordering[{e1, e2, ...}] gives the permutation-list that brings the \
ei to the canonical order defined by OrderedQ.\>\""}]}], "]"}], 
   ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"64e72363-6bb1-49a9-8c2e-c855354304fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Tests", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xTest", "::", "usage"}], "=", 
     "\"\<xTest[s, expr, res, messQ] executes the expression expr and \
compares the result with the expected expression res, using SameQ. The \
argument messQ says whether we expect messages will be produced during the \
execution of expr. The checks yield a True/False answer that is stored as \
TestResult[s, c] where c is an integer that increases for each test performed \
for the symbol s.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TestCounter", "::", "usage"}], "=", 
     "\"\<TestCounter[s] stores the number of tests performed so far for the \
symbol s.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TestResult", "::", "usage"}], "=", 
     "\"\<TestResult[s, c] stores a True/False value reporting whether the \
test number c for the symbol s was successfull or not.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AllTests", "::", "usage"}], "=", 
     "\"\<AllTests[] return the list of all True/False values stored in \
TesteResult. AllTests[s] returns only those values associated to the tests \
for the symbol s.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CheckTests", "::", "usage"}], "=", 
     "\"\<CheckTests[] report whether all tests performed passed or failed. \
CheckTests[s] reports only on the tests for the symbol s.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2011d930-dc69-4b9e-a645-4c047694478e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Types", " ", "of", " ", "names"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$EMNames", "::", "usage"}], "=", 
     "\"\<$EMNames gives the list of all names of symbols defined by the \
package ExpressionManipulation.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$xPermNames", "::", "usage"}], "=", 
     "\"\<$xPermNames gives the list of all names of symbols defined by the \
package xPerm.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$xTensorNames", "::", "usage"}], "=", 
     "\"\<$xTensorNames gives the list of names of all symbols defined by the \
package xTensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$xCoreNames", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$xTableauNames", "::", "usage"}], "=", "\"\<\>\""}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$xCobaNames", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$InvarNames", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$xPertNames", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$HarmonicsNames", "::", "usage"}], "=", "\"\<\>\""}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$SpinorsNames", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$xActNames", "::", "usage"}], "=", "\"\<\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$SystemNames", "::", "usage"}], "=", 
     "\"\<$SystemNames gives the list of names of all built-in symbols in \
Mathematica.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$SpecialOutputNames", "::", "usage"}], "=", 
     "\"\<$SpecialOutputNames gives the list of names of Mathematica symbols \
in $SystemNames whose output differs from them.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindSymbols", "::", "usage"}], "=", 
     "\"\<FindSymbols[expr] gives the list of all symbols in expr, without \
evaluating expr. FindSymbols[expr, f] gives the list of all symbols in expr, \
each wrapped with the function f; if the function f has a Hold attribute then \
none of the symbols of expr is evaluated in the process.\>\""}], ";"}], "\n", 
   
   RowBox[{
    RowBox[{
     RowBox[{"ValidateSymbol", "::", "usage"}], "=", 
     "\"\<ValidateSymbol[symbol] throws an error if symbol: 1) has a value or \
numeric character, or is not atomic, 2) its name is locked, protected or \
readprotected, or 3) it is already used by Mathematica or any of the xAct \
packages already loaded. Otherwise it gives Null. (Read)Protection is not \
checked for the capitals C, D, K, N, O, used by Mathematica. Symbols E and I \
have numeric value.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"29bf4fc6-416b-49db-ab30-889f03ca313b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Other", ".", " ", "Private"}], " ", "in", " ", "the", " ", 
    "package"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"LockedQ", "::", "usage"}], "=", 
     "\"\<LockedQ[symbol] gives True if symbol has attribute Locked and False \
otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProtectedQ", "::", "usage"}], "=", 
     "\"\<ProtectedQ[symbol] gives True if symbol has attribute Protected and \
False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ReadProtectedQ", "::", "usage"}], "=", 
     "\"\<ReadProtectedQ[symbol] gives True if symbol has attribute \
ReadProtected and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HeldQ", "::", "usage"}], "=", 
     "\"\<HeldQ[symbol] gives True if symbol has an attribute of Hold-type: \
HoldAllComplete, HoldAll, HoldFirst, HoldRest, NHoldAll, NHoldFirst, \
NHoldRest, SequenceHold\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$LockedNames", "::", "usage"}], "=", 
     "\"\<$LockedNames gives the list of all Mathematica names in \
$SystemNames with attribute Locked. They cannot be used as names for objects \
in xAct.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ProtectedNames", "::", "usage"}], "=", 
     "\"\<$ProtectedNames gives the list of names of all Mathematica symbols \
in $SystemNames with attribute Protected. They can be used as names for \
objects in xAct if protection is removed by the user, but we advise against \
this use.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ReadProtectedNames", "::", "usage"}], "=", 
     "\"\<$ReadProtectedNames gives the list of names of all Mathematica \
symbols in $SystemNames with attribute ReadProtected. They can be used as \
names for objects in xAct if readprotection is removed by the user, but we \
advise against this use.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$HeldNames", "::", "usage"}], "=", 
     "\"\<$HeldNames gives the list of names in $SystemNames with an \
attribute of Hold-type: HoldAllComplete, HoldAll, HoldFirst, HoldRest, \
NHoldAll, NHoldFirst, NHoldRest, SequenceHold\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$LengthOneNames", "::", "usage"}], "=", 
     RowBox[{
     "\"\<$LengthOneNames gives the names of one-character Mathematica \
symbols: \>\"", "<>", 
      RowBox[{"ToString", "@", "$LengthOneNames"}], "<>", 
      "\"\<. They are accepted as indices (except E and I), but not as names \
of other objects.\>\""}]}], ";"}]}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"ab972c98-d38f-43e5-b661-da64830ffdc0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Dagger", " ", "character"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$DaggerCharacter", "::", "usage"}], "=", 
     "\"\<$DaggerCharacter gives the character string to be appended to a \
daggered symbol. By default it is the dagger symbol \[Dagger].\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HasDaggerCharacterQ", "::", "usage"}], "=", 
     "\"\<HasDaggerCharacterQ on symbol or -symbol returns True if symbol \
contains $DaggerCharacter as one of its characters, and False otherwise. On \
any other type of expression it throws an error.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeDaggerSymbol", "::", "usage"}], "=", 
     "\"\<MakeDaggerSymbol[symbol] returns a symbol with an added \
$DaggerCharacter if it does not already have it as last chracter, or it \
removes the $DaggerCharacter if symbol already has it. If the symbol contains \
a dollar, then the character is placed just before the first dollar. On \
nonsymbol expressions this function throws an error.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ebbddcdd-3b3f-48e6-88df-9eef63da985d"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. Begin Private", \
"Subsection",ExpressionUUID->"2411fd77-67c5-4312-84ea-933c77dc39a6"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], \
"Input",ExpressionUUID->"0d4d3733-2744-4f60-aa15-cb8eccebb94f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DocumentationSearch`\"\>", ",", "\<\"ResourceLocator`\"\>", 
   ",", "\<\"PacletManager`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"83e0ea8b-0893-4f75-bf95-4724221e0e46"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], \
"Input",ExpressionUUID->"47138936-591f-4c04-9b26-c89bd5c3be75"],

Cell[BoxData["\<\"xAct`xCore`\"\>"], \
"Output",ExpressionUUID->"56c759d9-d1ca-41d8-b319-d85fe0297456"]
}, Open  ]],

Cell["Begin Private context:", \
"Text",ExpressionUUID->"9f3be8bd-3aa5-45e6-9474-6be34c464c2f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d487745d-5062-4f8b-a8d5-8645acd4654a"],

Cell[BoxData["\<\"xAct`xCore`Private`\"\>"], \
"Output",ExpressionUUID->"caf198a4-1254-4479-9920-8eee46cba140"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], \
"Input",ExpressionUUID->"569b0119-d440-4807-a577-db281b3f86f8"],

Cell[BoxData["\<\"xAct`xCore`Private`\"\>"], \
"Output",ExpressionUUID->"ec6bc7e1-32ea-4633-88b8-114b10cb1fc1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], \
"Input",ExpressionUUID->"0165a882-55c2-4f40-9245-688999e903f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DocumentationSearch`\"\>", ",", "\<\"ResourceLocator`\"\>", 
   ",", "\<\"PacletManager`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"368769e5-1a3e-47a6-a385-01a9fb657ba1"]
}, Open  ]],

Cell["\<\
The Private` context is not added to the $ContextPath. However we can find \
symbols there. This is confusing... In this notebook we shall follow this \
convention: examples are carried out in the Global` context, before ending \
the package, and therefore it is not possible to access xAct`xCore`Private \
unless we append it to the $ContextPath:\
\>", "Text",ExpressionUUID->"07ba66ea-e253-46d5-aa51-6dee3f1b5449"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BeginExamples", "[", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Set", "[", 
     RowBox[{"$Context", ",", "\"\<Global`\>\""}], "]"}], ";", 
    RowBox[{"Global`symbols", "=", 
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}]}], ";", "Null"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Global`EndExamples", "[", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<There are new symbols in Global`:\>\"", ",", "#"}], 
         "]"}]}], "]"}], ";", 
      RowBox[{"Set", "[", 
       RowBox[{"$Context", ",", "\"\<xAct`xCore`Private`\>\""}], "]"}], ";", 
      "Null"}], ")"}], "&"}], "@", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], ",", "Global`symbols"}],
     "]"}]}]}]}], \
"Input",ExpressionUUID->"11fce741-949f-4a6e-aa6d-51653b540df3"],

Cell["\<\
The only problem is that writing xAct`xCore`Private is rather long. We define \
(not in the package):\
\>", "Text",ExpressionUUID->"bb81c437-7cd9-4e59-8108-6cb4784dd85b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$PreRead", "=", 
  RowBox[{
   RowBox[{"ReplaceAll", "[", 
    RowBox[{"#", ",", 
     RowBox[{"expr_String", "\[RuleDelayed]", 
      RowBox[{"StringReplace", "[", 
       RowBox[{"expr", ",", 
        RowBox[{"\"\<xACP\>\"", "\[Rule]", "\"\<xAct`xCore`Private\>\""}]}], 
       "]"}]}]}], "]"}], 
   "&"}]}]], "Input",ExpressionUUID->"b2b06df0-c7bb-4464-81d0-ae041cfa34aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"#1", "/.", "\[VeryThinSpace]", 
   RowBox[{"expr_String", "\[RuleDelayed]", 
    RowBox[{"StringReplace", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"\<\"xACP\"\>", "\[Rule]", "\<\"xAct`xCore`Private\"\>"}]}], 
     "]"}]}]}], 
  "&"}]], "Output",ExpressionUUID->"c2a1b12f-d3d4-4055-b9e3-d7335a2fe7dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`xCore`*\>\"", 
  "]"}]], "Input",ExpressionUUID->"8145dffb-f212-4f31-ac87-e6e5216b47cc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AllTests\"\>", ",", "\<\"AppendToUnevaluated\"\>", 
   ",", "\<\"CheckOptions\"\>", ",", "\<\"CheckTests\"\>", 
   ",", "\<\"CollapseFoldedRule\"\>", ",", "\<\"ColorString\"\>", 
   ",", "\<\"DependentRules\"\>", ",", "\<\"Disclaimer\"\>", 
   ",", "\<\"FindSymbols\"\>", ",", "\<\"FoldedRule\"\>", 
   ",", "\<\"HasDaggerCharacterQ\"\>", ",", "\<\"HatString\"\>", 
   ",", "\<\"IndependentRules\"\>", ",", "\<\"JustOne\"\>", 
   ",", "\<\"LinkSymbols\"\>", ",", "\<\"MakeDaggerSymbol\"\>", 
   ",", "\<\"MakexTensions\"\>", ",", "\<\"MapIfPlus\"\>", 
   ",", "\<\"MapRuleL\"\>", ",", "\<\"MapRuleR\"\>", ",", "\<\"NoPattern\"\>",
    ",", "\<\"Overline\"\>", ",", "\<\"ReplaceLast\"\>", 
   ",", "\<\"ReportSet\"\>", ",", "\<\"ReportSetOption\"\>", 
   ",", "\<\"SetNumberOfArguments\"\>", ",", "\<\"SubHead\"\>", 
   ",", "\<\"SymbolJoin\"\>", ",", "\<\"TestCounter\"\>", 
   ",", "\<\"TestResult\"\>", ",", "\<\"ThreadArray\"\>", 
   ",", "\<\"TildeString\"\>", ",", "\<\"TrueOrFalse\"\>", 
   ",", "\<\"Underline\"\>", ",", "\<\"UnlinkSymbol\"\>", 
   ",", "\<\"ValidateSymbol\"\>", ",", "\<\"xEvaluateAt\"\>", 
   ",", "\<\"xHold\"\>", ",", "\<\"xTagSet\"\>", 
   ",", "\<\"xTagSetDelayed\"\>", ",", "\<\"xTension\"\>", 
   ",", "\<\"xTest\"\>", ",", "\<\"xUpAppendTo\"\>", 
   ",", "\<\"xUpDeleteCasesTo\"\>", ",", "\<\"xUpSet\"\>", 
   ",", "\<\"xUpSetDelayed\"\>", ",", "\<\"$DaggerCharacter\"\>", 
   ",", "\<\"$EMNames\"\>", ",", "\<\"$HarmonicsNames\"\>", 
   ",", "\<\"$InvarNames\"\>", ",", "\<\"$LinkCharacter\"\>", 
   ",", "\<\"$SpecialOutputNames\"\>", ",", "\<\"$SpinorsNames\"\>", 
   ",", "\<\"$SystemNames\"\>", ",", "\<\"$Version\"\>", 
   ",", "\<\"$WarningFrom\"\>", ",", "\<\"$xActDirectory\"\>", 
   ",", "\<\"$xActDocDirectory\"\>", ",", "\<\"$xActNames\"\>", 
   ",", "\<\"$xCobaNames\"\>", ",", "\<\"$xCoreNames\"\>", 
   ",", "\<\"$xPermNames\"\>", ",", "\<\"$xPertNames\"\>", 
   ",", "\<\"$xTableauNames\"\>", ",", "\<\"$xTensorNames\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"e5deb082-3852-4b5d-933b-65a9f4214d47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"b17c36a2-c488-4a56-b6f7-88eddc2e78f8"],

Cell[BoxData["65"], \
"Output",ExpressionUUID->"c7814b07-db21-40f5-9243-cd470785c8f9"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2. Functions",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"f1ec028d-10a5-44fc-a1c8-328c40c38191"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**", " ", "2."}], 
   " ", "Functions"}], " ", "*******************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"69229717-f44f-47d3-b6be-80cf235c1ef4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"62b76e0f-a71f-4848-ac27-009dd5d74e7e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.499338`", ",", "7.544805`7.329193013151869", ",", 
   "0.33126905029416825`"}], 
  "}"}]], "Output",ExpressionUUID->"6ce2a710-d6e6-4f7a-bc49-59c7a6981c7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.0. New functions", \
"Subsection",ExpressionUUID->"effd8273-b3f6-4942-9ced-c7701ac15354"],

Cell[CellGroupData[{

Cell["2.0.1. Ordering (from 4.1)", \
"Subsubsection",ExpressionUUID->"b57a77fa-af0b-4e1f-8175-b0ffc108fcc0"],

Cell[TextData[{
 "This function is included in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.1 and later, but in previous versions it must be defined explicitly:"
}], "Text",ExpressionUUID->"7f91150e-f0a2-4ea4-8609-dfad74b1f247"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Ordering"}]], \
"Input",ExpressionUUID->"2a230cba-2af5-4e4f-812a-f37e4768b1f0"],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Ordering\\\", \\\"[\\\", \
StyleBox[\\\"list\\\", \\\"TI\\\"], \\\"]\\\"}]\) gives the positions in \!\(\
\*StyleBox[\\\"list\\\", \\\"TI\\\"]\) at which each successive element of \!\
\(\*RowBox[{\\\"Sort\\\", \\\"[\\\", StyleBox[\\\"list\\\", \\\"TI\\\"], \
\\\"]\\\"}]\) appears. \\n\!\(\*RowBox[{\\\"Ordering\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"list\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"n\\\", \\\
\"TI\\\"]}], \\\"]\\\"}]\) gives the positions in \
\!\(\*StyleBox[\\\"list\\\", \\\"TI\\\"]\) at which the first \!\(\*StyleBox[\
\\\"n\\\", \\\"TI\\\"]\) elements of \!\(\*RowBox[{\\\"Sort\\\", \\\"[\\\", \
StyleBox[\\\"list\\\", \\\"TI\\\"], \\\"]\\\"}]\) appear. \\n\!\(\*RowBox[{\\\
\"Ordering\\\", \\\"[\\\", RowBox[{StyleBox[\\\"list\\\", \\\"TI\\\"], \
\\\",\\\", RowBox[{\\\"-\\\", StyleBox[\\\"n\\\", \\\"TI\\\"]}]}], \
\\\"]\\\"}]\) gives the positions of the last \!\(\*StyleBox[\\\"n\\\", \
\\\"TI\\\"]\) elements of \!\(\*RowBox[{\\\"Sort\\\", \\\"[\\\", \
StyleBox[\\\"list\\\", \\\"TI\\\"], \\\"]\\\"}]\). \
\\n\!\(\*RowBox[{\\\"Ordering\\\", \\\"[\\\", RowBox[{StyleBox[\\\"list\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"n\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\
\\\"p\\\", \\\"TI\\\"]}], \\\"]\\\"}]\) uses \!\(\*RowBox[{\\\"Sort\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"list\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\
\"p\\\", \\\"TI\\\"]}], \\\"]\\\"}]\). \"\>", "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ordering"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974363-4493425",ExpressionUUID->"718983fd-c809-4460-b8b1-\
7f92a582016f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"System`$VersionNumber", "<", "4.1"}], ",", 
    RowBox[{
     RowBox[{"Ordering", "[", "list_List", "]"}], ":=", 
     RowBox[{"Last", "/@", 
      RowBox[{"Sort", "[", 
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{"list", ",", 
          RowBox[{"Range", "@", 
           RowBox[{"Length", "@", "list"}]}]}], "}"}], "]"}], "]"}]}]}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3434dc0a-7213-4d1a-98e4-ad69c10eb902"],

Cell["\<\
Note that we have  given only the main definition of Ordering.\
\>", "Text",ExpressionUUID->"1d3351fa-fa0b-4ccd-b2fa-e72f71178171"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.3. DeleteDuplicates (from 7.0)", \
"Subsubsection",ExpressionUUID->"d00c9fdf-8757-478c-a621-4ab820f03b09"],

Cell["\<\
This function is used in some places related to the index manipulation:\
\>", "Text",ExpressionUUID->"863aaaa7-3675-4a33-b974-ca59578a14ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "DeleteDuplicates"}]], \
"Input",ExpressionUUID->"37274be8-4370-442f-80d1-1536e1e6b825"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"DeleteDuplicates\\\", \\\"[\\\", \
StyleBox[\\\"list\\\", \\\"TI\\\"], \\\"]\\\"}]\) deletes all duplicates from \
\!\(\*StyleBox[\\\"list\\\", \
\\\"TI\\\"]\).\\n\!\(\*RowBox[{\\\"DeleteDuplicates\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"list\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"test\\\", \
\\\"TI\\\"]}], \\\"]\\\"}]\) applies \!\(\*StyleBox[\\\"test\\\", \\\"TI\\\"]\
\) to pairs of elements to determine whether they should be considered \
duplicates. \"\>", "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteDuplicates"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974371-4493425",ExpressionUUID->"bd610215-bb99-4932-810e-\
831fdf06ef65"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "DeleteDuplicates", "]"}], "=", 
      RowBox[{"{", "Protected", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[DeleteDuplicates],
  Editable->False]], "Print",
 CellTags->
  "Info3567974371-4493425",ExpressionUUID->"6fd59293-37da-43a8-99c3-\
17c8fa70956a"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "This has been copied from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (it was called UnsortedUnion). I have just added the Verbatim. The \
philosophy behind this construction is really clever! (note however that this \
is not the definition going into the package)"
}], "Text",ExpressionUUID->"ecedc235-a7ed-455a-ab85-d108d15ae9eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"System`$VersionNumber", "<", "7."}], ",", "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"DeleteDuplicates", "[", "list_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "x"}], "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"Verbatim", "[", "x", "]"}], "]"}], "=", 
            RowBox[{"Sequence", "[", "]"}]}], ";", "x"}], ")"}]}], ";", 
        RowBox[{"f", "/@", "list"}]}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"046a45b3-0929-4ca6-8e04-733bf9d73722"],

Cell["\<\
In versions 7 and 8 there is DeleteDuplicates in Mathematica, but as pointed \
out by Teake it only works on expressions with head List. In version 9 it \
works with any head, and we imitate that here:\
\>", "Text",ExpressionUUID->"34b50e89-ed4a-4b94-997a-9f92a8812670"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"6.5", "<", "System`$VersionNumber", "<", "8.5"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unprotect", "[", "DeleteDuplicates", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"DeleteDuplicates", "[", 
       RowBox[{
        RowBox[{"head_", "[", "elems___", "]"}], "/;", 
        RowBox[{"head", "=!=", "List"}]}], "]"}], ":=", 
      RowBox[{"head", "@@", 
       RowBox[{"DeleteDuplicates", "[", 
        RowBox[{"{", "elems", "}"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Protect", "[", "DeleteDuplicates", "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"de9026ef-88dc-4ecf-824c-834bfb876a61"],

Cell["Examples:", \
"Text",ExpressionUUID->"7c4e34d7-42b3-4847-9304-752c5dd8cdcf"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"12307107-28d9-4491-8bbc-0c42b777233b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"{", 
   RowBox[{"b", ",", "a", ",", "a", ",", "b"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"b79dd6e5-4a79-408b-830e-901c72992b96"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], 
  "}"}]], "Output",ExpressionUUID->"f8712a29-521a-4139-91af-17ad58d6adf3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteDuplicates", "[", 
  RowBox[{"{", 
   RowBox[{"b", ",", "a", ",", "a", ",", "b"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"957a58c6-f35b-438d-a8a7-a7eb41c2329d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "a"}], 
  "}"}]], "Output",ExpressionUUID->"3fd96f29-87e0-4e2b-948b-fb90ef06082f"]
}, Open  ]],

Cell["Elements are evaluated before the union is done:", \
"Text",ExpressionUUID->"c1c96fb1-cf5c-4ca2-b4c7-86175ac06fd9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "b"}], 
  ";"}]], "Input",ExpressionUUID->"8c8c5c01-f625-43c9-af5d-1a1fae08d690"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"{", 
   RowBox[{"b", ",", "a", ",", "a", ",", "b"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"1d1e0f29-a33f-49e6-92f5-f06489ea9b51"],

Cell[BoxData[
 RowBox[{"{", "b", 
  "}"}]], "Output",ExpressionUUID->"2547473f-b1ed-4f00-ad06-969b9823eaf2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteDuplicates", "[", 
  RowBox[{"{", 
   RowBox[{"b", ",", "a", ",", "a", ",", "b"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"902e05e4-587a-4c68-9b01-bf5fef425de1"],

Cell[BoxData[
 RowBox[{"{", "b", 
  "}"}]], "Output",ExpressionUUID->"8712712b-71d2-4a25-96c8-f20a2a5f16ac"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"a", 
  "=."}]], "Input",ExpressionUUID->"6e0b4019-79c9-4938-9b45-18e7fef2ecf0"],

Cell["\<\
Without the Verbatim, the function f would get confused with patterns. Slots \
are automatically numbered (even with a HoldComplete wrapper):\
\>", "Text",ExpressionUUID->"013c6b9d-36b5-4453-8fb7-b1db081ad9cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteDuplicates", "[", 
  RowBox[{"{", 
   RowBox[{
   "b", ",", "a_", ",", "a", ",", "a__", ",", "a___", ",", "b", ",", "#", ",",
     "#1", ",", "#", ",", "#2", ",", "##"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"1f7994e7-94dd-4cdc-ab5f-4b9fa15f9d8d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "b", ",", "a_", ",", "a", ",", "a__", ",", "a___", ",", "#1", ",", "#2", 
   ",", "##1"}], 
  "}"}]], "Output",ExpressionUUID->"1aac371e-f1a9-4669-b7c2-a81746a48d20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", "#", 
  "]"}]], "Input",ExpressionUUID->"e7b09209-9a28-4670-ab90-bcd6b593e70a"],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", "#1", 
  "]"}]], "Output",ExpressionUUID->"fd7084fc-9c1a-4cde-b430-043ee0182cfc"]
}, Open  ]],

Cell["An issue with the pre7 definition", "Text",
 FontWeight->"Bold",ExpressionUUID->"80406899-ff0b-470f-afa4-7ac4c23987f8"],

Cell["\<\
There is an annoying problem, already reported to Wolfram Support in version \
5.1, but not corrected in 5.2 or 6.0. If we have a list of 99 or less \
elements the temporary variable f$ behaves properly:\
\>", "Text",ExpressionUUID->"cc230257-b66b-4759-b02c-930b3be3b56f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", "99", "}"}]}], "]"}]}], ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"81b1e924-157d-4038-bf85-3da652c42511"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteDuplicates", "[", "list", "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"be884d12-bb59-43f7-90c5-57442508cbee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "1", ",", "6", ",", "0", ",", "7", ",", "2", ",", "9", ",", "5", 
   ",", "4", ",", "8"}], 
  "}"}]], "Output",ExpressionUUID->"d94ab531-6a3b-488e-a88f-35a3e00cfbca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "xACP`f$*"}]], "Input",
 Evaluatable->False,ExpressionUUID->"da99502c-5964-402a-bfa8-3ca4e439993c"],

Cell[CellGroupData[{

Cell["xAct`xCore`Private`f$", "Print", "PrintUsage",
 CellTags->
  "Info3567802348-9914377",ExpressionUUID->"b9d36afe-9c07-4a3f-9187-\
2054d39214ff"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "xAct`xCore`Private`f$", "]"}], "=", 
      RowBox[{"{", "Temporary", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[xAct`xCore`Private`f$],
  Editable->False]], "Print",
 CellTags->
  "Info3567802348-9914377",ExpressionUUID->"b5577038-ebb8-486b-b484-\
1de08c6c8589"]
}, Open  ]]
}, Open  ]],

Cell["But if we have 100 or more then it refuses to die!", \
"Text",ExpressionUUID->"7e254ea5-da09-4071-a9e6-7065ce595999"],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", "100", "}"}]}], "]"}]}], ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"bfe9731d-11fa-450a-b6d2-babdc698f6ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteDuplicates", "[", "list", "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"746db87b-6f7a-407a-9201-23eac708ca92"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9", ",", "1", ",", "4", ",", "6", ",", "5", ",", "2", ",", "3", ",", "7", 
   ",", "0", ",", "8"}], 
  "}"}]], "Output",ExpressionUUID->"5de201cb-52ea-48ab-971f-baa339a7bcf2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "xACP`f$*"}]], "Input",
 Evaluatable->False,ExpressionUUID->"7888a483-a33b-4d00-a862-591b2bf905cb"],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["xAct`xCore`Private`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["xAct`xCore`Private`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["f$",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3567802348-9914377", {"f$", "xAct`xCore`Private`"}},
          ButtonNote->"xAct`xCore`Private`"], 
         ButtonBox["f$14335",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3567802348-9914377", {"f$14335", "xAct`xCore`Private`"}},
          ButtonNote->"xAct`xCore`Private`"]}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.475]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->
    Automatic]]], "Print", \
"InfoCell",ExpressionUUID->"fc391028-ebd0-43c3-b1c3-93b4caedb528"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`xCore`Private`f$*\>\"", "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"33bb65a0-4977-4f53-a351-bb0c33845995"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xCore`Private`f$\"\>", 
   ",", "\<\"xAct`xCore`Private`f$14335\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"c0ec0ca5-a68c-4f30-b0e0-8cdc6c8bda1b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", 
  RowBox[{"Evaluate", "@", 
   RowBox[{"Last", "[", "%", "]"}]}], "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"a9725131-827b-4173-ae0e-b1c49970a9b6"],

Cell[CellGroupData[{

Cell["xAct`xCore`Private`f$14335", "Print", "PrintUsage",
 CellTags->
  "Info3567802349-9914377",ExpressionUUID->"adf7edc9-2c7a-4d7a-b43b-\
602c9605d4f4"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "xAct`xCore`Private`f$14335", "]"}], "=", 
      RowBox[{"{", "Temporary", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "0", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "1", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "2", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "3", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "4", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "5", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "6", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "7", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "8", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xAct`xCore`Private`f$14335", "[", 
          RowBox[{"Verbatim", "[", "9", "]"}], "]"}], "=", 
         RowBox[{"Sequence", "[", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{
         "xAct`xCore`Private`f$14335", "[", "xAct`xCore`Private`x$_", "]"}], ":=", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"xAct`xCore`Private`f$14335", "[", 
             RowBox[{"Verbatim", "[", "xAct`xCore`Private`x$", "]"}], "]"}], 
            "=", 
            RowBox[{"Sequence", "[", "]"}]}], ";", "xAct`xCore`Private`x$"}], 
          ")"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[xAct`xCore`Private`f$14335],
  Editable->False]], "Print",
 CellTags->
  "Info3567802349-9914377",ExpressionUUID->"828e8dc1-b114-4d6a-8ce0-\
8864d2ca9873"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Remove", "[", 
  RowBox[{"a", ",", "b", ",", "list"}], "]"}], "\n", 
 RowBox[{"EndExamples", "[", "]"}]}], "Input",
 Evaluatable->False,ExpressionUUID->"9f60e490-9385-4c99-8e1b-6db2920b00ae"],

Cell["That problem forces us to use the definition", \
"Text",ExpressionUUID->"9b2beb7a-3116-44d1-a37f-d30d1d6dd02c"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"System`$VersionNumber", "<", "6.5"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"DeleteDuplicates", "[", "list_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "x", ",", "r"}], "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"Verbatim", "[", "x", "]"}], "]"}], "=", 
            RowBox[{"Sequence", "[", "]"}]}], ";", "x"}], ")"}]}], ";", 
        RowBox[{"r", "=", 
         RowBox[{"f", "/@", "list"}]}], ";", 
        RowBox[{"Remove", "[", "f", "]"}], ";", "r"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"DeleteDuplicates", ",", "1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Protect", "[", "DeleteDuplicates", "]"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"887da51e-3525-47d5-ae7e-df5ba303f283"],

Cell["which explicitly removes the function f after using it.", \
"Text",ExpressionUUID->"3e643e7c-9448-485f-a1fb-66111c1c15cb"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.0.2. DuplicateFreeQ (from 9.0)", \
"Subsubsection",ExpressionUUID->"c2eec587-1809-4311-8f35-9dd72e2ae5d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"System`$VersionNumber", "<", "9.0"}], ",", 
    RowBox[{
     RowBox[{"DuplicateFreeQ", "[", "expr_", "]"}], ":=", 
     RowBox[{"SameQ", "[", 
      RowBox[{
       RowBox[{"DeleteDuplicates", "[", "expr", "]"}], ",", "expr"}], 
      "]"}]}]}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7ff70aac-242b-48ea-a3dc-6049e710d78d"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1. Errors and messages", \
"Subsection",ExpressionUUID->"2effa121-0ce1-498c-a51e-0dfeaf9030d3"],

Cell[TextData[{
 "We already define here the Validate::warning message. Note that it deals \
with warnings, and not with errors, which are always output. Note also that \
this message needs two strings and that it has different colors in diferent \
versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The global variable $WarningFrom gives an indication (through Block \
constructs) of where the warning was generated; the default value General \
gives no information whatsoever."
}], "Text",ExpressionUUID->"5e8aa100-320d-48eb-986f-41cbb9d0b6bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "$WarningFrom"}]], \
"Input",ExpressionUUID->"2db7229b-f87f-4b50-b8a6-ca6dcc006eab"],

Cell[BoxData[
 StyleBox["\<\"$WarningFrom is a global variable which is set to different \
values in different parts of the code. It is used to get an idea of where the \
warning messages are coming from.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974364-4493425",ExpressionUUID->"4a3e48ac-884f-4057-a439-\
874213ec116a"]
}, Open  ]],

Cell["\<\
Note that StyleBox expects a box-structure as first argument, which can be in \
particular a string:\
\>", "Text",ExpressionUUID->"3bffc659-d90d-4cd9-bf7a-9525fd75271f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$WarningFrom", "=", "General"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"General", "::", "warning"}], "=", 
  RowBox[{
   RowBox[{"Switch", "[", 
    RowBox[{"System`$VersionNumber", ",", "\[IndentingNewLine]", 
     RowBox[{"_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#", "\[GreaterEqual]", "5."}], "&"}], ")"}]}], ",", 
     "\"\<\\!\\(\\*StyleBox[`1`,FontColor->RGBColor[0,0,1]]\\)\>\"", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#", "<", "5."}], "&"}], ")"}]}], ",", 
     "\"\<\\!\\(\\*StyleBox[`1`,FontColor->RGBColor[1,0,0]]\\)\>\""}], "]"}], 
   "<>", "\"\< : From `2`.\>\""}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8a20ad7c-4001-4405-af31-7dd69299cc08"],

Cell[BoxData["\<\"\\!\\(\\*StyleBox[`1`,FontColor->RGBColor[0,0,1]]\\) : From \
`2`.\"\>"], "Output",ExpressionUUID->"57f0a7d9-be2b-423b-a0e1-883d81cbb3cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Message", "[", 
  RowBox[{
   RowBox[{"General", "::", "warning"}], ",", 
   RowBox[{"\"\<Example: \>\"", "<>", 
    RowBox[{"ToString", "[", "a", "]"}]}], ",", "$WarningFrom"}], 
  "]"}]], "Input",ExpressionUUID->"4731d976-cfbc-46a1-b70d-16f960e62ff7"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "warning"}], "MessageName"], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\[NoBreak]\\!\\(\\\"Example: \
a\\\"\\)\[NoBreak],FontColor->RGBColor[0,0,1]]\\) : From \
\[NoBreak]\\!\\(General\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"112044d8-583d-4724-9bac-eb4ce8b8d35d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "a", 
  "]"}]], "Input",ExpressionUUID->"52dcf906-f180-4495-9610-95a9ed7e5bf6"],

Cell["\<\
By default it is off, but here we keep it in order to check its behaviour:\
\>", "Text",ExpressionUUID->"12be3f68-de56-4c44-819f-2a444af59bab"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "warning"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bd252f98-4c45-498f-82de-712e8bf2e2ef"],

Cell[BoxData[
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "warning"}], 
  "]"}]], "Input",ExpressionUUID->"59726c1a-a5dc-459c-83c7-1ceb884fc860"],

Cell["\<\
We can also give information on any new symbol created. This is not \
equivalent to On[General::newsym] due to the treatment of contexts. In \
particular the latter does not report creation of Private symbols, and that \
is the main reason why we want to use $NewSymbol. Deactivated because there \
are commands generating long lists of internal symbols.\
\>", "Text",ExpressionUUID->"ad387c31-c980-42a1-947b-95d561bb3907"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$NewSymbol", "=", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<New symbol created: \>\"", ",", " ", "#1", ",", " ", 
     "\"\<, Context: \>\"", ",", "#2"}], "]"}], "&"}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"8e66023a-19ab-4c1d-a9bf-7e6e661f5378"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\<\"New symbol created: \"\>", ",", "#1", 
    ",", "\<\", Context: \"\>", ",", "#2"}], "]"}], 
  "&"}]], "Output",ExpressionUUID->"118033e3-02fa-46db-85e9-3776d664aa11"]
}, Open  ]],

Cell["These are very common messages that we associate to General:", \
"Text",ExpressionUUID->"ecaf9fe4-1af9-4393-a23a-ef9c4b1cebc4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"General", " ", "messages"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "versions"}], "=", 
     "\"\<Loaded `1` version `2` but expected version `3` at least.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "unknown"}], "=", "\"\<Unknown `1` `2`.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "invalid"}], "=", 
     "\"\<`1` is not a valid `2`.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "noundef"}], "=", 
     "\"\<`1` `2` cannot be undefined because `3`.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "nouse"}], "=", 
     "\"\<Attempting to apply `1` on `2`.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "empty"}], "=", 
     "\"\<Argument number `1` cannot be an empty list of `2`.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "notyet"}], "=", 
     "\"\<Sorry. Cannot work with `1` yet.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "missing"}], "=", 
     "\"\<There is no `1` in `2`.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "undef"}], "=", 
     "\"\<Undefined `1` of `2`.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "error"}], "=", "\"\<`1`\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "error1"}], "=", "\"\<`1` `2`\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "error2"}], "=", "\"\<`1` `2` `3`\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"General", "::", "error3"}], "=", "\"\<`1` `2` `3` `4`\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f9b3a01f-497a-4fbc-be3f-c459d6832fb9"],

Cell["\<\
Some packages modify global configuration variables. When that happens there \
is the following warning message:\
\>", "Text",ExpressionUUID->"65f61816-f019-416f-9895-241ef04dce0c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "nostdvar"}], "=", 
   "\"\<Nonstandard configuration: variable `1` now has value `2`.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "nostdopt"}], "=", 
   "\"\<Nonstandard configuration: option `1` of `2` now has value \
`3`.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f36ff166-4b14-4469-932a-7d17eeeca2e3"],

Cell["A message for self-checks:", \
"Text",ExpressionUUID->"6a9e1b1b-5378-408d-97ec-917bad6167eb"],

Cell[BoxData[
 RowBox[{"$ReportToJose", "=", 
  "\"\<Uhh. This was not expected (though there is nothing wrong). Please, \
report to jose@xact.es.\>\""}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9e38a298-6a59-4755-91f2-7a946deb7ca4"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. Option values", \
"Subsection",ExpressionUUID->"3d9894ce-7aba-4527-8227-bbbe7987d207"],

Cell["\<\
This function checks that the given options have the expected rule structure \
and depth (options must be a sequence of rules or a list of rules). We will \
not check that those options are actually options for a given function \
because it could happen that they are options for a function that is called \
internally by the first function. CheckOptions always return a list of rules. \
The issue of evaluation is not important here if we assume that rules are \
still rules even after evaluation:\
\>", "Text",ExpressionUUID->"749af2f8-4cd7-4c28-8e53-391bd58eb435"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "OptionQ"}]], \
"Input",ExpressionUUID->"fddf02c0-aa37-4d89-b38f-4a54a200d4c0"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"\!\(\*RowBox[{\\\"OptionQ\\\", \\\"[\\\", StyleBox[\\\"e\\\", \
\\\"TI\\\"], \\\"]\\\"}]\) returns True if \!\(\*StyleBox[\\\"e\\\", \\\"TI\\\
\"]\) can be considered an option or list of options, and False \
otherwise.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974364-4493425",ExpressionUUID->"3506ef86-3a56-43ae-943d-\
255b1d51a0bb"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "OptionQ", "]"}], "=", 
      RowBox[{"{", "Protected", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[OptionQ],
  Editable->False]], "Print",
 CellTags->
  "Info3567974364-4493425",ExpressionUUID->"103b06c8-fbcb-4367-9fdf-\
70cb82c24e17"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"af15264f-8a98-418c-a917-69089d54cad8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OptionQ", "[", 
  RowBox[{"a", "\[Rule]", "b"}], 
  "]"}]], "Input",ExpressionUUID->"0245c819-ac85-4516-97f4-66e139d5ecb7"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"88759c52-6457-4e95-8f86-8a800c15f656"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OptionQ", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}]}], 
  "]"}]], "Input",ExpressionUUID->"2199af52-3ad7-492d-b5b3-363e65cb5723"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"OptionQ", "::", "argx"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(OptionQ\\)\[NoBreak] called with \
\[NoBreak]\\!\\(2\\)\[NoBreak] arguments; 1 argument is expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argx\\\", \
ButtonNote -> \\\"OptionQ::argx\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"ebd40cd2-8fda-461f-ad89-3e523aef07bc"],

Cell[BoxData[
 RowBox[{"OptionQ", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}]}], 
  "]"}]], "Output",ExpressionUUID->"694fa0e7-6a1f-4ae1-8027-2108ebc0417a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OptionQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "b"}], ",", 
    RowBox[{"c", "\[Rule]", "d"}]}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"01d2855a-f5ee-460a-aa7a-250287e774f3"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"75053903-bc61-4ff9-9922-21262365a7bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OptionQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"c", "\[Rule]", "d"}], "}"}], "}"}]}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"53525cff-8daf-477e-940d-26defb5bfd9c"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"67eb912e-ad8e-4279-b272-cbb396f6164e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"e316b0cd-f5ff-4536-8fd8-83c43fd62b1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are new symbols in Global`:\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>"}], "}"}]}],
  SequenceForm["There are new symbols in Global`:", {"b", "c", "d"}],
  Editable->
   False]], "Print",ExpressionUUID->"55f97718-a13b-4ed2-8bc4-60366ddfd73c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "CheckOptions"}]], \
"Input",ExpressionUUID->"aa57a647-3a53-4745-a4d5-2ee983eb3970"],

Cell[BoxData[
 StyleBox["\<\"CheckOptions[options] checks that options have the right rule \
structure and that the tensor rank of {options} is either 1 or 2. If True, it \
returns Flatten[{options}, 1]. If False, it throws an error.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974365-4493425",ExpressionUUID->"e42206a4-e695-4c30-a98c-\
51b80e1cfd45"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CheckOptions", "[", "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CheckOptions", "[", "opts__", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"OptionQ", "[", 
       RowBox[{"{", "opts", "}"}], "]"}], "&&", 
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"ArrayDepth", "[", 
         RowBox[{"{", "opts", "}"}], "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"{", "opts", "}"}], ",", "1"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Throw", "[", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"CheckOptions", "::", "invalid"}], ",", "opts", ",", 
        "\"\<option or list of options\>\""}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "CheckOptions", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"961da287-371a-4ba4-903d-10343c7bb718"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"ff36fb25-5f75-48e4-aa1a-8a6ab8e846e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckOptions", "[", 
  RowBox[{"a", "\[Rule]", "b"}], 
  "]"}]], "Input",ExpressionUUID->"8b570caa-8223-425f-bb9c-3bb1d9959351"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", "\[Rule]", "b"}], 
  "}"}]], "Output",ExpressionUUID->"c0436013-6ad4-4ead-9a5f-225cdba4f57e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckOptions", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}]}], 
  "]"}]], "Input",ExpressionUUID->"cfd9a616-45ea-4b88-9527-581a2c3240cc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}]}], 
  "}"}]], "Output",ExpressionUUID->"122e0a0d-93ae-4212-b693-6e65a822b9a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckOptions", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "b"}], ",", 
    RowBox[{"c", "\[Rule]", "d"}]}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"ef4d9a6e-0d98-4abb-9e25-f9f30404230a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}]}], 
  "}"}]], "Output",ExpressionUUID->"30a3f225-e462-47e5-b717-1223ed166519"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"CheckOptions", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", "\[Rule]", "d"}], "}"}]}], "}"}], 
   "]"}]}]], "Input",ExpressionUUID->"4bba09dc-4e0c-4913-b47e-0e17d86d178a"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"CheckOptions", "::", "invalid"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(\\({a \[Rule] b}\\)\\), \\(\\({c \[Rule] \
d}\\)\\)}\\)\[NoBreak] is not a valid \[NoBreak]\\!\\(\\\"option or list of \
options\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"56c93f00-be08-43c9-9d56-2f83080711c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"CheckOptions", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"c", "\[Rule]", "d"}], "}"}], "}"}]}], "}"}], 
   "]"}]}]], "Input",ExpressionUUID->"daa703c5-0827-47aa-8df1-1b7d68bd5ae2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"CheckOptions", "::", "invalid"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(\\({a \[Rule] b}\\)\\), \\(\\({\\({c \[Rule] \
d}\\)}\\)\\)}\\)\[NoBreak] is not a valid \[NoBreak]\\!\\(\\\"option or list \
of options\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"0a99f5eb-dd76-43bd-92d5-65327d747c56"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], 
  "]"}]], "Input",ExpressionUUID->"c9eb0d89-cf44-40c4-adb1-5f8b49afba76"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"138436d0-26da-436f-9873-ecb8e5659f27"],

Cell["\<\
TrueOrFalse will be used to check the value of Boolean rules. Just a comment: \
this function evaluates its argument before checking it:\
\>", "Text",ExpressionUUID->"7d2b5c7d-17fc-467d-9e18-348c9c48c45c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "TrueOrFalse"}]], \
"Input",ExpressionUUID->"6655010d-f486-413e-a41e-9b956d48fd37"],

Cell[BoxData[
 StyleBox["\<\"TrueOrFalse[True] and TrueOrFalse[False] give True. Any other \
argument gives False.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974366-4493425",ExpressionUUID->"b2246843-c6d1-451d-9840-\
0c271bcc5fde"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TrueOrFalse", "[", 
    RowBox[{"True", "|", "False"}], "]"}], ":=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TrueOrFalse", "[", "_", "]"}], ":=", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"TrueOrFalse", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "TrueOrFalse", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"893a245c-c017-4f71-86c4-a18bfebf33f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"TrueOrFalse", "[", 
   RowBox[{"True", "&&", "False"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"67493da8-64f7-4d59-adaa-a2dcdd1ee55d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"True", "&&", "False"}],
      HoldForm], ",", 
     TagBox["False",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"TrueOrFalse", "[", "False", "]"}],
    HoldForm], ",", 
   TagBox["True",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"ff2948e1-9c36-470c-a0b7-1e38ede4dc11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"TrueOrFalse", "[", 
   RowBox[{"True", "||", "False"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"93621879-dde6-42b4-8b1a-1e69504cebcc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"True", "||", "False"}],
      HoldForm], ",", 
     TagBox["True",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"TrueOrFalse", "[", "True", "]"}],
    HoldForm], ",", 
   TagBox["True",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"e554a10f-23a2-4418-b1ba-8ebc0d9ed7da"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3. SetNumberOfArguments", \
"Subsection",ExpressionUUID->"af34c4c6-8745-4c99-ab1e-cdf3d408a4f6"],

Cell["\<\
There are five kinds of argument messages:
\t- n arguments are expected (argx, argr, argrx)
\t- n or more arguments are expected (argm, argmu)
\t- n or fewer arguments are expected (argf)
\t- n or m arguments are expected (argt, argtu)
\t- between n and m arguments are expected (argb, argbu)\
\>", "Text",ExpressionUUID->"63ed5af9-592f-4cd8-8444-413144ecea53"],

Cell["\<\
This function imposes one condition. Structure: setargs[function, found, \
expected]\
\>", "Text",ExpressionUUID->"92097059-866b-4766-b2ed-e59b07d89346"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "setargs"}]], \
"Input",ExpressionUUID->"4910819e-1ded-4913-8738-1b11a53fa446"],

Cell[BoxData[
 StyleBox["\<\"xAct`xCore`Private`setargs[head, found, expected] sets a \
definition for head[args] such that if the number of arguments found is not \
compatible with the number of arguments expected then an error message is \
sent (not thrown). Number found must be an integer or Infinity, whereas \
expected can be an integer or Infinity or a range indicated by a list of two \
integers {m, n} or an integer and Infinity {m, Infinity}.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974367-4493425",ExpressionUUID->"770457ab-b4a7-47f4-bb3d-\
8d9e66d5d2cd"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetAttributes", "[", 
    RowBox[{"setargs", ",", "HoldFirst"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "n_", ",", "n_"}], "]"}], ":=", "Null"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "Infinity", ",", "1"}], "]"}], ":=", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"_", ",", "x__"}], "]"}], ",", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"f", "::", "argx"}], ",", "f", ",", 
       RowBox[{"1", "+", 
        RowBox[{"Length", "[", 
         RowBox[{"{", "x", "}"}], "]"}]}]}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "Infinity", ",", "n_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"SetDelayed", "[", 
      RowBox[{
       RowBox[{"f", "[", "##", "]"}], ",", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"f", "::", "argrx"}], ",", "f", ",", 
         RowBox[{"n", "+", 
          RowBox[{"Length", "[", 
           RowBox[{"{", "x", "}"}], "]"}]}], ",", "n"}], "]"}]}], "]"}], 
     "&"}], "@@", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Blank", "[", "]"}], ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], "~", "Join", "~", 
     RowBox[{"{", 
      RowBox[{"Pattern", "[", 
       RowBox[{"x", ",", 
        RowBox[{"BlankSequence", "[", "]"}]}], "]"}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "1", ",", 
     RowBox[{"n_", "/;", 
      RowBox[{"n", "=!=", "1"}]}]}], "]"}], ":=", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"f", "[", "_", "]"}], ",", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"f", "::", "argr"}], ",", "f", ",", "n"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", 
     RowBox[{"i_", "/;", 
      RowBox[{"i", "=!=", "1"}]}], ",", "1"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"SetDelayed", "[", 
      RowBox[{
       RowBox[{"f", "[", "##", "]"}], ",", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"f", "::", "argx"}], ",", "f", ",", "i"}], "]"}]}], "]"}], 
     "&"}], "@@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Blank", "[", "]"}], ",", 
      RowBox[{"{", "i", "}"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"setargs", "[", 
     RowBox[{"f_", ",", "i_", ",", "n_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"SetDelayed", "[", 
       RowBox[{
        RowBox[{"f", "[", "##", "]"}], ",", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"f", "::", "argrx"}], ",", "f", ",", "i", ",", "n"}], 
         "]"}]}], "]"}], "&"}], "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Blank", "[", "]"}], ",", 
       RowBox[{"{", "i", "}"}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "n_", ",", 
     RowBox[{"{", 
      RowBox[{"n_", ",", "Infinity"}], "}"}]}], "]"}], ":=", "Null"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "Infinity", ",", 
     RowBox[{"{", 
      RowBox[{"n_", ",", "Infinity"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"SetDelayed", "[", 
      RowBox[{
       RowBox[{"f", "[", "##", "]"}], ",", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"f", "::", "argm"}], ",", "f", ",", 
         RowBox[{"n", "+", 
          RowBox[{"Length", "[", 
           RowBox[{"{", "x", "}"}], "]"}]}], ",", "n"}], "]"}]}], "]"}], 
     "&"}], "@@", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Blank", "[", "]"}], ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], "~", "Join", "~", 
     RowBox[{"{", 
      RowBox[{"Pattern", "[", 
       RowBox[{"x", ",", 
        RowBox[{"BlankSequence", "[", "]"}]}], "]"}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n_", "/;", 
        RowBox[{"n", "=!=", "1"}]}], ",", "Infinity"}], "}"}]}], "]"}], ":=", 
   
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"f", "[", "_", "]"}], ",", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"f", "::", "argmu"}], ",", "f", ",", "n"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"setargs", "[", 
     RowBox[{"f_", ",", "i_", ",", 
      RowBox[{"{", 
       RowBox[{"n_", ",", "Infinity"}], "}"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"SetDelayed", "[", 
       RowBox[{
        RowBox[{"f", "[", "##", "]"}], ",", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"f", "::", "argm"}], ",", "f", ",", "i", ",", "n"}], 
         "]"}]}], "]"}], "&"}], "@@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Blank", "[", "]"}], ",", 
       RowBox[{"{", "i", "}"}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "Infinity", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ":=", 
   RowBox[{"setargs", "[", 
    RowBox[{"f", ",", "Infinity", ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "Infinity", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "n_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"SetDelayed", "[", 
      RowBox[{
       RowBox[{"f", "[", "##", "]"}], ",", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"f", "::", "argf"}], ",", "f", ",", 
         RowBox[{"n", "+", 
          RowBox[{"Length", "[", 
           RowBox[{"{", "x", "}"}], "]"}]}], ",", "n"}], "]"}]}], "]"}], 
     "&"}], "@@", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Blank", "[", "]"}], ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], "~", "Join", "~", 
     RowBox[{"{", 
      RowBox[{"Pattern", "[", 
       RowBox[{"x", ",", 
        RowBox[{"BlankSequence", "[", "]"}]}], "]"}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "0", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ":=", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"f", "[", "]"}], ",", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"f", "::", "argt"}], ",", "f", ",", "0", ",", "1", ",", "2"}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "Infinity", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ":=", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"_", ",", "_", ",", "x__"}], "]"}], ",", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"f", "::", "argt"}], ",", "f", ",", 
       RowBox[{"2", "+", 
        RowBox[{"Length", "[", 
         RowBox[{"{", "x", "}"}], "]"}]}], ",", "1", ",", "2"}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "0", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ":=", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"f", "[", "]"}], ",", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"f", "::", "argt"}], ",", "f", ",", "0", ",", "2", ",", "3"}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ":=", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"f", "[", "_", "]"}], ",", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"f", "::", "argt"}], ",", "f", ",", "1", ",", "2", ",", "3"}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setargs", "[", 
    RowBox[{"f_", ",", "Infinity", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ":=", 
   RowBox[{"SetDelayed", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"_", ",", "_", ",", "_", ",", "x__"}], "]"}], ",", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"f", "::", "argt"}], ",", "f", ",", 
       RowBox[{"3", "+", 
        RowBox[{"Length", "[", 
         RowBox[{"{", "x", "}"}], "]"}]}], ",", "2", ",", "3"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c6f87a97-d557-40cb-a2e0-7568e474690b"],

Cell["SetNumberOfArguments imposes all conditions:", \
"Text",ExpressionUUID->"8b01bd57-6ad8-4ea7-be25-18daea95a790"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SetNumberOfArguments"}]], \
"Input",ExpressionUUID->"00ce52e1-7323-4790-9fd4-df5921b9b72a"],

Cell[BoxData[
 StyleBox["\<\"SetNumberOfArguments[function, expected] sets several \
definitions for head[args] using the (private) function setargs for those \
cases which are incompatible with the expected number or range of arguments. \
The format for expected is explained in setargs.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974367-4493425",ExpressionUUID->"077edc78-7dbb-46e3-9032-\
5e72d86a204a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetAttributes", "[", 
    RowBox[{"SetNumberOfArguments", ",", "HoldFirst"}], "]"}], ";"}], "\n", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "with", " ", "exactly", " ", "n", " ", "arguments"}], " ",
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"f_", ",", "n_Integer"}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"setargs", "[", 
         RowBox[{"f", ",", "i", ",", "n"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", 
          RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"setargs", "[", 
       RowBox[{"f", ",", "Infinity", ",", "n"}], "]"}], ";"}], 
     "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "with", " ", "n", " ", "or", " ", "more", " ", 
    "arguments"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"f_", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"n_Integer", "?", "Positive"}], ",", "Infinity"}], "}"}]}], 
     "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"setargs", "[", 
       RowBox[{"f", ",", "i", ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "Infinity"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "with", " ", "n", " ", "or", " ", "fewer", " ", 
    "arguments"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"f_", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"n_Integer", "?", "Positive"}]}], "}"}]}], "]"}], ":=", 
    RowBox[{"setargs", "[", 
     RowBox[{"f", ",", "Infinity", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "with", " ", "1", " ", "or", " ", "2", " ", "arguments"}],
    " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"f_", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"setargs", "[", 
       RowBox[{"f", ",", "0", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"setargs", "[", 
       RowBox[{"f", ",", "Infinity", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "with", " ", "2", " ", "or", " ", "3", " ", "arguments"}],
    " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetNumberOfArguments", "[", 
    RowBox[{"f_", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"setargs", "[", 
      RowBox[{"f", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"setargs", "[", 
      RowBox[{"f", ",", "1", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"setargs", "[", 
      RowBox[{"f", ",", "Infinity", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]",
     ")"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cabb3cdb-aa92-464e-a0c1-c23a36277e2d"],

Cell["\<\
It is important to note that these functions give messages but do not throw \
them.\
\>", "Text",ExpressionUUID->"9a7113ee-14f7-4bb7-a90e-7fac21516646"],

Cell["Examples:", \
"Text",ExpressionUUID->"86da6ad2-fab7-468a-8716-d9c983fafa24"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"3f3d515a-5852-4ead-b47c-32fd2feecbd4"],

Cell[BoxData[
 RowBox[{"SetNumberOfArguments", "[", 
  RowBox[{"function", ",", "2"}], 
  "]"}]], "Input",ExpressionUUID->"7cb33f1d-7e93-492e-873c-a4f125bc576d"],

Cell[BoxData[
 RowBox[{"SetNumberOfArguments", "[", 
  RowBox[{"function", ",", "2"}], 
  "]"}]], "Input",ExpressionUUID->"11fd01b8-450d-4911-8c81-b633208e8b48"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "function"}]], \
"Input",ExpressionUUID->"773b0137-6691-4107-ac2f-18f383462455"],

Cell[CellGroupData[{

Cell["Global`function", "Print", "PrintUsage",
 CellTags->
  "Info3567974368-4493425",ExpressionUUID->"0125eadb-61f2-4c2d-a73d-\
8bf337352243"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"function", "[", "]"}], ":=", 
         RowBox[{"Message", "[", 
          RowBox[{
           StyleBox[
            RowBox[{"function", "::", "argrx"}], "MessageName"], ",", 
           "function", ",", "0", ",", "2"}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"function", "[", "_", "]"}], ":=", 
         RowBox[{"Message", "[", 
          RowBox[{
           StyleBox[
            RowBox[{"function", "::", "argr"}], "MessageName"], ",", 
           "function", ",", "2"}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"function", "[", 
          RowBox[{"_", ",", "_", ",", "xAct`xCore`Private`x__"}], "]"}], ":=", 
         RowBox[{"Message", "[", 
          RowBox[{
           StyleBox[
            RowBox[{"function", "::", "argrx"}], "MessageName"], ",", 
           "function", ",", 
           RowBox[{"2", "+", 
            RowBox[{"Length", "[", 
             RowBox[{"{", "xAct`xCore`Private`x", "}"}], "]"}]}], ",", "2"}], 
          "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`function],
  Editable->False]], "Print",
 CellTags->
  "Info3567974368-4493425",ExpressionUUID->"176d5e32-3e2f-4348-bdf5-\
106eed2517c3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"function", "[", 
  "]"}]], "Input",ExpressionUUID->"17d38bd9-7368-47d1-a148-0a06609235f6"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"function", "::", "argrx"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(function\\)\[NoBreak] called with \
\[NoBreak]\\!\\(0\\)\[NoBreak] arguments; \[NoBreak]\\!\\(2\\)\[NoBreak] \
arguments are expected.\"\>"}]], "Message", \
"MSG",ExpressionUUID->"90e31f65-d87f-4d3a-8462-ed9e97961b31"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"function", "[", "1", 
  "]"}]], "Input",ExpressionUUID->"1e87ab43-2a1c-401f-aa1e-c9c40c262439"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"function", "::", "argr"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(function\\)\[NoBreak] called with 1 argument; \
\[NoBreak]\\!\\(2\\)\[NoBreak] arguments are expected.\"\>"}]], "Message", \
"MSG",ExpressionUUID->"c6a76f10-1f4f-4f6f-ab4d-68ed933aa862"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"function", "[", 
  RowBox[{"1", ",", "2"}], 
  "]"}]], "Input",ExpressionUUID->"3f8b0224-030c-445d-b2bf-31c8a0e3c1b3"],

Cell[BoxData[
 RowBox[{"function", "[", 
  RowBox[{"1", ",", "2"}], 
  "]"}]], "Output",ExpressionUUID->"13746a25-a3ed-4dbf-bed5-832620cddc56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"function", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], 
  "]"}]], "Input",ExpressionUUID->"342424e6-d70f-462e-841f-0ebd1e76dc01"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"function", "::", "argrx"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(function\\)\[NoBreak] called with \
\[NoBreak]\\!\\(3\\)\[NoBreak] arguments; \[NoBreak]\\!\\(2\\)\[NoBreak] \
arguments are expected.\"\>"}]], "Message", \
"MSG",ExpressionUUID->"6a84098e-cd2e-4d55-9019-f49604127c63"]
}, Open  ]],

Cell["\<\
We can change the definitions, but this is only really right if the new set \
of conditions is more restrictive than the previous one. Otherwise, the old \
definitions are still there. QUESTION: How can we solve this? It seems we \
have to remove previous definitions, but that seems dangerous.\
\>", "Text",ExpressionUUID->"22115104-3395-43c2-be62-61f5730ee296"],

Cell[BoxData[
 RowBox[{"SetNumberOfArguments", "[", 
  RowBox[{"function", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"49fa1c82-2c38-475e-bb5f-56aaf6dcbb63"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "function"}]], \
"Input",ExpressionUUID->"5e35dd43-a256-495b-8073-c76b4bb4d03b"],

Cell[CellGroupData[{

Cell["Global`function", "Print", "PrintUsage",
 CellTags->
  "Info3567974369-4493425",ExpressionUUID->"ccf50aed-a5bc-4a9c-a81d-\
6baf6272f951"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"function", "[", "]"}], ":=", 
         RowBox[{"Message", "[", 
          RowBox[{
           StyleBox[
            RowBox[{"function", "::", "argt"}], "MessageName"], ",", 
           "function", ",", "0", ",", "2", ",", "3"}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"function", "[", "_", "]"}], ":=", 
         RowBox[{"Message", "[", 
          RowBox[{
           StyleBox[
            RowBox[{"function", "::", "argr"}], "MessageName"], ",", 
           "function", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"function", "[", 
          RowBox[{"_", ",", "_", ",", "_", ",", "xAct`xCore`Private`x$__"}], 
          "]"}], ":=", 
         RowBox[{"Message", "[", 
          RowBox[{
           StyleBox[
            RowBox[{"function", "::", "argt"}], "MessageName"], ",", 
           "function", ",", 
           RowBox[{"3", "+", 
            RowBox[{"Length", "[", 
             RowBox[{"{", "xAct`xCore`Private`x$", "}"}], "]"}]}], ",", "2", 
           ",", "3"}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"function", "[", 
          RowBox[{"_", ",", "_", ",", "xAct`xCore`Private`x__"}], "]"}], ":=", 
         RowBox[{"Message", "[", 
          RowBox[{
           StyleBox[
            RowBox[{"function", "::", "argrx"}], "MessageName"], ",", 
           "function", ",", 
           RowBox[{"2", "+", 
            RowBox[{"Length", "[", 
             RowBox[{"{", "xAct`xCore`Private`x", "}"}], "]"}]}], ",", "2"}], 
          "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`function],
  Editable->False]], "Print",
 CellTags->
  "Info3567974369-4493425",ExpressionUUID->"d3fdb3a9-fdde-4eaa-9c22-\
ce381fa1f1ae"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"function", "[", 
  "]"}]], "Input",ExpressionUUID->"87883f80-129c-42b8-81fe-9a7159ccff70"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"function", "::", "argt"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(function\\)\[NoBreak] called with \
\[NoBreak]\\!\\(0\\)\[NoBreak] arguments; \[NoBreak]\\!\\(2\\)\[NoBreak] or \
\[NoBreak]\\!\\(3\\)\[NoBreak] arguments are expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argt\\\", \
ButtonNote -> \\\"Global`function::argt\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"8ae2e542-eebc-4576-b88b-385572c9a34c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"function", "[", "1", 
  "]"}]], "Input",ExpressionUUID->"0e99b9fe-933c-4e33-9f88-545d8c9c649c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"function", "::", "argr"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(function\\)\[NoBreak] called with 1 argument; \
\[NoBreak]\\!\\({2, 3}\\)\[NoBreak] arguments are expected.\"\>"}]], \
"Message", "MSG",ExpressionUUID->"2568c18a-f7f6-437d-8dc5-c567206263c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"function", "[", 
  RowBox[{"1", ",", "2"}], 
  "]"}]], "Input",ExpressionUUID->"a98f8050-f178-4dec-8bba-62b20f974072"],

Cell[BoxData[
 RowBox[{"function", "[", 
  RowBox[{"1", ",", "2"}], 
  "]"}]], "Output",ExpressionUUID->"89bbfad5-5036-4cdf-907b-82d7faec1ead"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"function", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], 
  "]"}]], "Input",ExpressionUUID->"272870bc-95c7-405a-9b96-10449a198798"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"function", "::", "argt"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(function\\)\[NoBreak] called with \
\[NoBreak]\\!\\(4\\)\[NoBreak] arguments; \[NoBreak]\\!\\(2\\)\[NoBreak] or \
\[NoBreak]\\!\\(3\\)\[NoBreak] arguments are expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argt\\\", \
ButtonNote -> \\\"Global`function::argt\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"a6cea5c0-24ab-4627-b0c0-340d6b89657c"]
}, Open  ]],

Cell["This definition is now wrong:", \
"Text",ExpressionUUID->"6281ed27-b7e7-4801-a2f1-a410aa58caf7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"function", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], 
  "]"}]], "Input",ExpressionUUID->"f32242e2-93cc-40b4-9a54-aef208967b4f"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"function", "::", "argrx"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(function\\)\[NoBreak] called with \
\[NoBreak]\\!\\(3\\)\[NoBreak] arguments; \[NoBreak]\\!\\(2\\)\[NoBreak] \
arguments are expected.\"\>"}]], "Message", \
"MSG",ExpressionUUID->"01f65c10-c221-4046-9757-b6e5ceddb72a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "function", 
  "]"}]], "Input",ExpressionUUID->"522394cd-1953-4093-bf80-a0f78e0a0841"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"943674d3-872b-4cfc-a963-e071eae5e5d1"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4. Lists", \
"Subsection",ExpressionUUID->"2c87dea4-22cf-4086-b646-9e549d170564"],

Cell["This subsection develops some small but useful functions:", \
"Text",ExpressionUUID->"b2c18267-cccd-4f9a-8c6c-fffb43466938"],

Cell[CellGroupData[{

Cell["2.4.1. JustOne", \
"Subsubsection",ExpressionUUID->"38cfa2a9-724a-4e7c-9b7f-6cd7b08ea3e8"],

Cell["\<\
This is a stupid, but terribly useful, function that checks that we have a \
list (head List) with only one element:\
\>", "Text",ExpressionUUID->"043cfff4-c496-4bf2-9d48-5ea251c07046"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "JustOne"}]], \
"Input",ExpressionUUID->"e0d4c774-6d27-472f-9e4c-f65a11f3f0fe"],

Cell[BoxData[
 StyleBox["\<\"JustOne[{expr}] gives expr, or an error otherwise.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974370-4493425",ExpressionUUID->"f456de6b-0dd1-4e5d-8d6c-\
8d5ac9cad2ad"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"JustOne", "::", "notone"}], "=", 
   "\"\<Expecting a list with one element, but got `1`.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"JustOne", "[", 
    RowBox[{"{", "expr_", "}"}], "]"}], ":=", "expr"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"JustOne", "[", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"JustOne", "::", "notone"}], ",", "\"\<nothing\>\""}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"JustOne", "[", "expr_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"JustOne", "::", "notone"}], ",", "expr"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"JustOne", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "JustOne", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fa9ad714-4a1d-45f5-a191-e0de26c3c47f"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.2. MapIfPlus", \
"Subsubsection",ExpressionUUID->"499a03e5-9ea4-4d7e-8bbb-110624e823d6"],

Cell["This is another simple function, used by ToCanonical:", \
"Text",ExpressionUUID->"5f552b11-4c64-4080-b6ab-55b0fbcdddfa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "MapIfPlus"}]], \
"Input",ExpressionUUID->"d4e3b2c7-70cd-4fcd-99b1-1fa71a5c1bd8"],

Cell[BoxData[
 StyleBox["\<\"MapIfPlus[f, expr] maps f on the elements of expr if expr has \
head Plus, or returns f[expr] otherwise.\"\>", "MSG"]], "Print", "PrintUsage",
 
 CellTags->
  "Info3567974371-4493425",ExpressionUUID->"5a768ecd-fcc5-4413-9332-\
42402d436855"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MapIfPlus", "[", 
    RowBox[{"f_", ",", "expr_Plus"}], "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{"f", ",", "expr"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MapIfPlus", "[", 
    RowBox[{"f_", ",", "expr_"}], "]"}], ":=", 
   RowBox[{"f", "[", "expr", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"MapIfPlus", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "MapIfPlus", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"687950c4-9246-4ab0-83c3-480a3f8734b9"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.3. ThreadArray", \
"Subsubsection",ExpressionUUID->"2a997a3d-2857-401e-85ec-9d45ffe43534"],

Cell[TextData[{
 "We construct a simple threading head for expressions with two arrays of the \
same dimensions (although we do not check that their dimensions are the \
same). This function is used in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"00318ff8-87a4-4e42-9667-b5ae083f0437"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ThreadArray"}]], \
"Input",ExpressionUUID->"84cd15b0-da25-4d72-941c-b4b6a9541692"],

Cell[BoxData[
 StyleBox["\<\"ThreadArray[head[array1, array2]] threads head over pairs of \
elements of the two arrays.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974372-4493425",ExpressionUUID->"7db1a415-11cc-4f9d-8785-\
c1e8eed14672"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ThreadArray", "[", 
    RowBox[{"head_", "[", 
     RowBox[{"arrayL_List", ",", "arrayR_List"}], "]"}], "]"}], ":=", 
   RowBox[{"MapThread", "[", 
    RowBox[{"head", ",", 
     RowBox[{"{", 
      RowBox[{"arrayL", ",", "arrayR"}], "}"}], ",", 
     RowBox[{"ArrayDepth", "[", "arrayL", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"ThreadArray", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ThreadArray", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"333bd3bf-fb0d-4c3b-ad4d-65d9975ac2fb"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.4. xThrough", \
"Subsubsection",ExpressionUUID->"44077ef6-a577-4349-86cd-043209e651d4"],

Cell[TextData[{
 "This function is not being used now in ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"5bc36e2e-3a7e-4999-b865-863fa3085c4f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xThrough", "[", 
    RowBox[{
     RowBox[{"List", "[", "args__", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
   RowBox[{"xThrough", "/@", 
    RowBox[{"Through", "[", 
     RowBox[{
      RowBox[{"List", "[", "args", "]"}], "[", "expr", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xThrough", "[", "expr_", "]"}], ":=", "expr"}], 
  ";"}]}], "Input",ExpressionUUID->"ef54b036-59fd-419d-997f-bc129218f714"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5. Evaluation", \
"Subsection",ExpressionUUID->"5c0fe8ec-9ac5-4e00-b84e-6544febdcdde"],

Cell[CellGroupData[{

Cell["2.5.1. xEvaluateAt", \
"Subsubsection",ExpressionUUID->"fb140c9c-000e-4122-9137-f7b9dc5e3527"],

Cell[TextData[{
 "The package ",
 StyleBox["ExpressionManipulation",
  FontSlant->"Italic"],
 " has a function EvaluateAt (there is no such built-in in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "), but it is rather complicated. Here we define two simplified versions. \
The functions are constructed using the functions ReplacePart and Extract, \
which themselve do not have holding attributes. Note that both latter \
functions (and MapAt) have been modified by the original form of ",
 StyleBox["ExpressionManipulation",
  FontSlant->"Italic"],
 ", but I have deactivated that creating three functions NewReplacePart, \
NewExtract and NewMapAt inside that package."
}], "Text",ExpressionUUID->"b2dd0612-f0f7-4a8a-9305-ed789c5afa67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "ReplacePart"}]], \
"Input",ExpressionUUID->"e0b6865a-6532-47af-a45c-0ca262b4e2d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"ReplacePart\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{StyleBox[\\\"i\
\\\", \\\"TI\\\"], \\\"->\\\", StyleBox[\\\"new\\\", \\\"TI\\\"]}]}], \\\"]\\\
\"}]\) yields an expression in which the \
\!\(\*StyleBox[RowBox[{StyleBox[\\\"i\\\", \\\"TI\\\"], \
\\\"\[Null]\\\"}]]\)\!\(\*SuperscriptBox[\\\"\[Null]\\\", \\\"th\\\"]\) part \
of \!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) is replaced by \
\!\(\*StyleBox[\\\"new\\\", \\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"ReplacePart\\\
\", \\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \
\\\"TI\\\"], StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\"->\\\", \
SubscriptBox[StyleBox[\\\"new\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]]}], \\\",\\\", RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \
\\\"TI\\\"], StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\"->\\\", \
SubscriptBox[StyleBox[\\\"new\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]]}], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\
\\\"}]}], \\\"]\\\"}]\) replaces parts at positions \
\!\(\*SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"n\\\", \
\\\"TI\\\"]]\) by \!\(\*SubscriptBox[StyleBox[\\\"new\\\", \\\"TI\\\"], \
StyleBox[\\\"n\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"ReplacePart\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"i\\\", \\\"TI\\\"], \
\\\",\\\", StyleBox[\\\"j\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}], \\\"->\\\", \
StyleBox[\\\"new\\\", \\\"TI\\\"]}]}], \\\"]\\\"}]\) replaces the part at \
position \!\(\*RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"i\\\", \\\"TI\\\"], \\\
\",\\\", StyleBox[\\\"j\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\
\\\", \\\"TR\\\"]}], \\\"}\\\"}]\). \\n\!\(\*RowBox[{\\\"ReplacePart\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{RowBox[{RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\"->\\\", SubscriptBox[StyleBox[\\\"new\\\", \
\\\"TI\\\"], StyleBox[\\\"1\\\", \\\"TR\\\"]]}], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) replaces parts \
at positions \!\(\*RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"n\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"n\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}]\) by \!\(\*SubscriptBox[StyleBox[\\\"new\\\", \\\"TI\
\\\"], StyleBox[\\\"n\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"ReplacePart\\\
\", \\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}], \\\"}\\\"}], \\\"->\\\", StyleBox[\\\"new\\\", \
\\\"TI\\\"]}]}], \\\"]\\\"}]\) replaces all parts at positions \!\(\*RowBox[{\
\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], \
StyleBox[\\\"n\\\", \\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \
\\\"TI\\\"], StyleBox[\\\"n\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]\) by \!\(\*StyleBox[\\\"new\\\", \
\\\"TI\\\"]\). \"\>", "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974373-4493425",ExpressionUUID->"741a6ad2-810b-4cf2-a40b-\
06993524df3c"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "ReplacePart", "]"}], "=", 
      RowBox[{"{", "Protected", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "ReplacePart", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"Heads", "\[Rule]", "Automatic"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[ReplacePart],
  Editable->False]], "Print",
 CellTags->
  "Info3567974373-4493425",ExpressionUUID->"553d8144-96f5-4cd5-8220-\
099085c1d2b6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "Extract"}]], \
"Input",ExpressionUUID->"8acebb87-ab31-455c-a7ef-a8c6bc6a8546"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Extract\\\", \\\"[\\\", RowBox[{StyleBox[\\\
\"expr\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"list\\\", \\\"TI\\\"]}], \
\\\"]\\\"}]\) extracts the part of \!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) \
at the position specified by \!\(\*StyleBox[\\\"list\\\", \\\"TI\\\"]\). \
\\n\!\(\*RowBox[{\\\"Extract\\\", \\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \
\\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) extracts a list of parts of \
\!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"Extract\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\
\"list\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"h\\\", \\\"TI\\\"]}], \
\\\"]\\\"}]\) extracts parts of \!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\), \
wrapping each of them with head \!\(\*StyleBox[\\\"h\\\", \\\"TI\\\"]\) \
before evaluation. \"\>", "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974373-4493425",ExpressionUUID->"f721e3cf-a59a-48d7-b50e-\
300c50c7fe1b"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Extract", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"NHoldRest", ",", "Protected"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Extract],
  Editable->False]], "Print",
 CellTags->
  "Info3567974373-4493425",ExpressionUUID->"54266256-0250-4e85-ab41-\
50fbcdd98a0a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "MapAt"}]], "Input",ExpressionUUID->"21285a8d-7b93-4665-bff6-e64a7cf06dfd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"MapAt\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"expr\\\", \\\
\"TI\\\"], \\\",\\\", StyleBox[\\\"n\\\", \\\"TI\\\"]}], \\\"]\\\"}]\) \
applies \!\(\*StyleBox[\\\"f\\\", \\\"TI\\\"]\) to the element at position \!\
\(\*StyleBox[\\\"n\\\", \\\"TI\\\"]\) in \!\(\*StyleBox[\\\"expr\\\", \
\\\"TI\\\"]\). If \!\(\*StyleBox[\\\"n\\\", \\\"TI\\\"]\) is negative, the \
position is counted from the end. \\n\!\(\*RowBox[{\\\"MapAt\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"expr\\\", \\\
\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"i\\\", \\\"TI\\\
\"], \\\",\\\", StyleBox[\\\"j\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) applies \
\!\(\*StyleBox[\\\"f\\\", \\\"TI\\\"]\) to the part of \
\!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) at position \
\!\(\*RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"i\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"j\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}], \\\"}\\\"}]\). \\n\!\(\*RowBox[{\\\"MapAt\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"expr\\\", \\\
\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) applies \!\(\*StyleBox[\\\"f\\\", \
\\\"TI\\\"]\) to parts of \!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) at \
several positions. \"\>", "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974374-4493425",ExpressionUUID->"5caa804c-d39d-4ad0-a372-\
facef66c2182"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "MapAt", "]"}], "=", 
      RowBox[{"{", "Protected", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[MapAt],
  Editable->False]], "Print",
 CellTags->
  "Info3567974374-4493425",ExpressionUUID->"7fe531b5-82b1-4e6b-825e-\
d47baa09cee3"]
}, Open  ]]
}, Open  ]],

Cell["\<\
This first function is used by ScreenDollarIndices and by DisplaceSlots. Note \
that xEvaluateAt does not have a holding attribute.\
\>", "Text",ExpressionUUID->"3f171305-6ab9-4ff1-9c41-1aec371a2a7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xEvaluateAt"}]], \
"Input",ExpressionUUID->"13b2a360-1d6f-4008-80fd-c6fb1198683b"],

Cell[BoxData[
 StyleBox["\<\"xEvaluateAt[expr, pos] forces evaluation of expr at the \
position indicated by pos. xEvaluateAt[expr, {pos1, pos2, ...}] forces \
evaluation at several positions.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974374-4493425",ExpressionUUID->"34e8d971-5431-42c5-8801-\
c0d98058307e"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xEvaluateAt", "[", 
    RowBox[{"expr_", ",", "positions_"}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ReplacePart", "[", 
       RowBox[{"#1", ",", 
        RowBox[{"Part", "[", 
         RowBox[{"#1", ",", 
          RowBox[{"Sequence", "@@", "#2"}]}], "]"}], ",", "#2"}], "]"}], 
      "&"}], ",", 
     RowBox[{"Unevaluated", "[", "expr", "]"}], ",", "positions"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xEvaluateAt", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "xEvaluateAt", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d095202e-ad88-42f1-b6ef-c2aaef1f65fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xEvaluateAt", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Hold", "[", 
      RowBox[{"1", "+", "1"}], "]"}], ",", 
     RowBox[{"Hold", "[", 
      RowBox[{"1", "+", "1"}], "]"}], ",", 
     RowBox[{"Hold", "[", 
      RowBox[{"1", "+", "1"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"7985ecbb-2d55-4d54-a223-bbb91104bb0b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", "2", "]"}], ",", 
   RowBox[{"Hold", "[", "2", "]"}], ",", 
   RowBox[{"Hold", "[", "2", "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"2edc0bcd-941f-44fa-b44a-5ee47e5841e8"]
}, Open  ]],

Cell["\<\
The following function assumes that expr does not evaluate by itself (i.e., \
assumes that expr has a holding wrapper). It is used in HoldMap. The mapped \
function can have holding attributes or not. It is not included in the \
package because HoldMap is not included in the package:\
\>", "Text",ExpressionUUID->"297c745d-ef62-4dab-b64a-0395b68e95f5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"A", " ", "single", " ", "position"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xEvaluateAt2", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"posn", ":", 
        RowBox[{"_Integer", "|", 
         RowBox[{"{", "___Integer", "}"}]}]}], ",", 
       RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
     RowBox[{"ReplacePart", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"Extract", "[", 
        RowBox[{"expr", ",", "posn", ",", "f"}], "]"}], ",", "posn"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"A", " ", "list", " ", "of", " ", "positions"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xEvaluateAt2", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"posn", ":", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "__Integer", "}"}], ".."}], "}"}]}], ",", 
       RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
     RowBox[{"Fold", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xEvaluateAt2", "[", 
         RowBox[{"#1", ",", "#2", ",", "f"}], "]"}], "&"}], ",", "expr", ",", 
       
       RowBox[{"Reverse", "[", 
        RowBox[{"Sort", "[", "posn", "]"}], "]"}]}], "]"}]}], 
    ";"}]}]}]], \
"Input",ExpressionUUID->"4dbac351-0468-43e0-a5ea-921bab3e749d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "1"}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{"1", "+", "1"}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{"1", "+", "1"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", "XX"}], 
  "]"}]], "Input",ExpressionUUID->"21421d29-87a9-4581-95ee-98a64452662a"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "1"}], ")"}], "+", 
   RowBox[{"XX", "[", "2", "]"}], "+", 
   RowBox[{"XX", "[", "2", "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"d6098826-56a1-4c40-9d57-a12b84b3344a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "[", "XX", "]"}], "=", 
  RowBox[{
  "{", "HoldFirst", 
   "}"}]}]], "Input",ExpressionUUID->"d56c9c2e-3547-4011-aaa5-99d0db9d21c0"],

Cell[BoxData[
 RowBox[{"{", "HoldFirst", 
  "}"}]], "Output",ExpressionUUID->"6d0f6bad-5fb5-48e9-86b2-b879a1228f34"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "1"}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{"1", "+", "1"}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{"1", "+", "1"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", "XX"}], 
  "]"}]], "Input",ExpressionUUID->"479d94db-3acc-485a-8a68-10b4fe680a84"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "1"}], ")"}], "+", 
   RowBox[{"XX", "[", 
    RowBox[{"1", "+", "1"}], "]"}], "+", 
   RowBox[{"XX", "[", 
    RowBox[{"1", "+", "1"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"3f897f6d-2f8a-4e12-aac0-ca18365246a4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "XX", 
  "]"}]], "Input",ExpressionUUID->"94940d39-a14c-40bd-9d96-f714590342a4"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5.2. xHold", \
"Subsubsection",ExpressionUUID->"3e507dda-82d7-48dd-95f7-af51f3ea603c"],

Cell["\<\
In several computations it is interesting to have an alternative function to \
HoldForm to avoid conflicts. It will be called xHold. Comments:
\t- We define xHold with attribute HoldAll instead of HoldAllComplete \
imitating Hold. The problem is that HoldAllComplete does not strip out \
Unevaluated or Sequence, and we usually want to do it.
\t- I have not been able to make PrecedenceForm to work because it evaluates \
its argument. We use the (undocumented in the Help) function Parenthesize, \
that requires the use of DisplayForm. It gives us, however, more control on \
the ouput.
\t- The precedence level 15 is chosen to be just above the precedence 10 of \
CompoundExpression:
\t- I'd like to have those parenthesis colored, but don't know how to do it.\
\>", "Text",ExpressionUUID->"fa28ad84-b0d8-40d1-a904-d7e5e9cc7416"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "PrecedenceForm", 
  "]"}]], "Input",ExpressionUUID->"802b521e-6e50-4f40-8ed9-c6bb3d3ce716"],

Cell[BoxData[
 RowBox[{"{", "Protected", 
  "}"}]], "Output",ExpressionUUID->"5c125ba8-17ec-428a-bbad-f72147cf317b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Parenthesize", 
  "]"}]], "Input",ExpressionUUID->"fe9651cf-7523-4ba7-91d4-7e1a45f4553f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAllComplete", ",", "Protected"}], 
  "}"}]], "Output",ExpressionUUID->"0e00b6af-db5d-427e-ad0c-630c5e53be05"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xHold"}]], "Input",ExpressionUUID->"065c0f31-eee3-49c2-a8ca-75473395f174"],

Cell[BoxData[
 StyleBox["\<\"xHold reproduces the behaviour of HoldForm, but with much \
lower precedence. It is introduced to avoid conflicts with the use of \
HoldForm by the user.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974375-4493425",ExpressionUUID->"7466f60f-3238-4a43-8c93-\
4c40b76eeb6f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"xHold", ",", "HoldAll"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{"xHold", "[", "expr_", "]"}], "]"}], ":=", 
   RowBox[{"DisplayForm", "@", 
    RowBox[{"Parenthesize", "[", 
     RowBox[{
     "expr", ",", " ", "StandardForm", ",", " ", "15", ",", " ", 
      "NonAssociative"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "xHold", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"035558c6-0b36-4f51-8a71-7963df54ec2e"],

Cell["Note that Format produces a MakeBoxes definition.", \
"Text",ExpressionUUID->"7ab975d7-d462-4749-b31e-3d100cf6f41a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "xHold"}]], "Input",ExpressionUUID->"44a1c0c7-2c0f-42f2-b023-765630e262c4"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"xHold reproduces the behaviour of HoldForm, but with much \
lower precedence. It is introduced to avoid conflicts with the use of \
HoldForm by the user.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974376-4493425",ExpressionUUID->"d9fe0e13-9ef4-43f3-9e9e-\
1c9661124fbc"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "xHold", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"MakeBoxes", "[", 
          RowBox[{
           RowBox[{"DisplayForm", "[", "\<\"expr_\"\>", "]"}], ",", 
           "FormatType_"}], "]"}], "^:=", 
         RowBox[{"\<\"Format\"\>", "[", 
          RowBox[{
           RowBox[{"DisplayForm", "[", 
            RowBox[{"Parenthesize", "[", 
             RowBox[{
             "expr", ",", "\<\"StandardForm\"\>", ",", "15", ",", 
              "NonAssociative"}], "]"}], "]"}], ",", "FormatType"}], 
          "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"\<\"Format\"\>", "[", 
          RowBox[{"DisplayForm", "[", "\<\"expr_\"\>", "]"}], "]"}], ":=", 
         RowBox[{"DisplayForm", "[", 
          RowBox[{"Parenthesize", "[", 
           RowBox[{
           "expr", ",", "\<\"StandardForm\"\>", ",", "15", ",", 
            "NonAssociative"}], "]"}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[xAct`xCore`xHold],
  Editable->False]], "Print",
 CellTags->
  "Info3567974376-4493425",ExpressionUUID->"641b4de4-4d48-4fd4-ac8f-\
7698c6c1970f"]
}, Open  ]]
}, Open  ]],

Cell["\<\
The parenthesis do not appear if the expression is at level 0:\
\>", "Text",ExpressionUUID->"bbcbbdb2-85b4-456d-bb79-259daf499cd4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xHold", "[", 
  RowBox[{"1", "+", "1"}], 
  "]"}]], "Input",ExpressionUUID->"04f7041f-6d22-4e2b-9b6b-0bdeafdcef1d"],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "1"}],
  DisplayForm]], \
"Output",ExpressionUUID->"6a694d1e-1290-4c3c-ac82-7ef1fdcb9d05"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "InputForm"}]], \
"Input",ExpressionUUID->"2e39201d-aa03-4a04-a8f1-c6f1b2e80196"],

Cell["xHold[1 + 1]", \
"Output",ExpressionUUID->"1d8d1305-d954-4c6d-b4a7-7a28b6ec5234"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"7", " ", "+", 
  RowBox[{"xHold", "[", 
   RowBox[{"1", "+", "1"}], 
   "]"}]}]], "Input",ExpressionUUID->"1a93b3ad-bd96-44c8-a6f5-68244c923635"],

Cell[BoxData[
 RowBox[{"7", "+", 
  RowBox[{"(", 
   TagBox[
    RowBox[{"1", "+", "1"}],
    DisplayForm], 
   ")"}]}]], "Output",ExpressionUUID->"e9b2d97c-40ea-4eb7-b23b-4560a0287db2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "InputForm"}]], \
"Input",ExpressionUUID->"69d0188f-a526-4ec5-86e3-c20d8344a61c"],

Cell["7 + xHold[1 + 1]", \
"Output",ExpressionUUID->"f21fa7ae-28d0-4f6d-bc93-ed7255ae04c0"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6. Held mappings", \
"Subsection",ExpressionUUID->"2e7290a8-1c78-49b1-bb7a-a65097ea5ab7"],

Cell[CellGroupData[{

Cell["2.6.1. The problem of evaluation. Preliminary comments", \
"Subsubsection",ExpressionUUID->"96652182-877b-40c3-bb60-fb24bb9da03e"],

Cell["Here we deal with the problem of evaluation.", \
"Text",ExpressionUUID->"e012f0b1-7121-4c31-a9b9-5d283b41c1bf"],

Cell[TextData[{
 "Cycle of evaluation of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], 
   StyleBox["[", "MR"], 
   RowBox[{
    FormBox[
     SubscriptBox[
      "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
      "1"],
     TraditionalForm], 
    StyleBox[",", "MR"], " ", 
    FormBox[
     SubscriptBox[
      "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
      "2"],
     TraditionalForm], 
    StyleBox[",", "MR"], "\[Ellipsis]"}], 
   StyleBox["]", "MR"]}]],ExpressionUUID->
  "522179ac-4a3f-48b6-bcdf-d206ea630ae4"],
 " (copied from the Reference Guide):\n\[FilledSmallSquare] If the expression \
is a raw object (e.g., ",
 "Integer",
 ", String, etc.), leave it unchanged.\n\[FilledSmallSquare] Evaluate the \
head h of the expression.\n\[FilledSmallSquare] Evaluate each element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
    "i"], TraditionalForm]],ExpressionUUID->
  "60dcd74b-c05a-4d30-bc8b-63121f47b445"],
 " of the expression in turn. If h is a symbol with attributes HoldFirst, \
HoldRest, HoldAll or HoldAllComplete, then skip evaluation of certain \
elements.\n\[FilledSmallSquare] Unless h has attribute HoldAllComplete strip \
the outermost of any Unevaluated wrappers that appear in the ",
 Cell[BoxData[
  FormBox[
   FormBox[
    SubscriptBox[
     "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
     "i"],
    TraditionalForm], TraditionalForm]],ExpressionUUID->
  "79066f9d-9f42-484e-bb79-b2d6d8fdb481"],
 ".\n\[FilledSmallSquare] Unless h has attribute SequenceHold, flatten out \
all Sequence objects that appear among the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
    "i"], TraditionalForm]],ExpressionUUID->
  "198b74b8-0df5-470d-8396-a5c79c0c0f67"],
 ".\n\[FilledSmallSquare] If h has attribute Flat, then flatten out all \
nested expressions with head h.\n\[FilledSmallSquare] If h has attribute \
Listable, then thread through any ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
    "i"], TraditionalForm]],ExpressionUUID->
  "d5eefc25-3a79-4d0b-9158-5ec5e3a1916a"],
 " that are lists.\n\[FilledSmallSquare] If h has attribute Orderless, then \
sort the ",
 Cell[BoxData[
  FormBox[
   FormBox[
    SubscriptBox[
     "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
     "i"],
    TraditionalForm], TraditionalForm]],ExpressionUUID->
  "468cd2f2-b805-4b63-8b39-1670a2f09543"],
 " into order.\n\[FilledSmallSquare] Unless h has attribute HoldAllComplete, \
use any applicable transformation rules associated with f that you have \
defined for objects of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], 
   StyleBox["[", "MR"], " ", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], 
     StyleBox["[", "MR"], 
     RowBox[{
      FormBox[
       SubscriptBox[
        "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"",
         "1"],
       TraditionalForm], 
      StyleBox[",", "MR"], "\[Ellipsis]"}], 
     StyleBox["]", "MR"]}], 
    StyleBox[",", "MR"], "\[Ellipsis]"}], 
   StyleBox["]", "MR"]}]],ExpressionUUID->
  "c6b7b05b-d088-4b3d-8962-f67b47702271"],
 ".\n\[FilledSmallSquare] Use any built-in transformation rules associated \
with f for objects of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], 
   StyleBox["[", "MR"], " ", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], 
     StyleBox["[", "MR"], 
     RowBox[{
      FormBox[
       SubscriptBox[
        "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"",
         "1"],
       TraditionalForm], 
      StyleBox[",", "MR"], "\[Ellipsis]"}], 
     StyleBox["]", "MR"]}], 
    StyleBox[",", "MR"], "\[Ellipsis]"}], 
   StyleBox["]", "MR"]}]],ExpressionUUID->
  "884ff917-d01a-4ac7-ac50-a669bd18ca0f"],
 ".\n\[FilledSmallSquare] Use any applicable transformation rules that you \
have defined for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], 
   StyleBox["[", "MR"], 
   RowBox[{
    FormBox[
     SubscriptBox[
      "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
      "1"],
     TraditionalForm], 
    StyleBox[",", "MR"], " ", 
    FormBox[
     SubscriptBox[
      "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
      "2"],
     TraditionalForm], 
    StyleBox[",", "MR"], "\[Ellipsis]"}], 
   StyleBox["]", "MR"]}]],ExpressionUUID->
  "6993929e-9c07-4b18-a450-1954fbca75f1"],
 " or for h[\[Ellipsis]][\[Ellipsis]].\n\[FilledSmallSquare] Use any built-in \
transformation rules for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], 
   StyleBox["[", "MR"], 
   RowBox[{
    FormBox[
     SubscriptBox[
      "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
      "1"],
     TraditionalForm], 
    StyleBox[",", "MR"], " ", 
    FormBox[
     SubscriptBox[
      "\"\<\\!\\(\\*StyleBox[\\\"\\\\\\\"e\\\\\\\"\\\", \\\"TI\\\"]\\)\>\"", 
      "2"],
     TraditionalForm], 
    StyleBox[",", "MR"], "\[Ellipsis]"}], 
   StyleBox["]", "MR"]}]],ExpressionUUID->
  "2b9eef51-9195-47c9-b250-c1cbe041ab16"],
 " or for h[\[Ellipsis]][\[Ellipsis]]."
}], "Text",ExpressionUUID->"29a18267-ab29-4792-9800-788963ad2817"],

Cell["\<\
To summarize. There are three groups of actions, in this order:
\t1.- Evaluate all parts of the expression: first the  head, then the elements.
\t2.- Worry, in this order, about Unevaluated, Sequence, Flat, Listable, \
Orderless. This part is not really clear to me.
\t3.- Use upvalues before downvalues, and user definitions before built-in \
definitions.\
\>", "Text",ExpressionUUID->"e6de371c-85a9-4317-93b8-00b0bb06716b"],

Cell["\<\
Unevaluated plays a very special role in Mathematica because it is very high \
up in the previous list. I find it the most confusing and difficult to \
understand or use. For example here the function Length behaves as I would \
expect:\
\>", "Text",ExpressionUUID->"f111d0b6-f44c-4734-a169-e4f6128db4b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"03c54c93-2e92-4d07-ac80-4a6aeb7b147b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"1", "+", "1"}],
      HoldForm], ",", 
     TagBox["2",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Length", "[", "2", "]"}],
    HoldForm], ",", 
   TagBox["0",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"b04957e2-dcfd-4728-bea8-ea1401cb335a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"1", "+", "1"}], "]"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"2f908052-73ad-4ee3-bdc9-8bd1b622c191"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"Length", "[", 
     RowBox[{"1", "+", "1"}], "]"}],
    HoldForm], ",", 
   TagBox["2",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"812da671-da3a-46c3-beb6-3c15cf2f9003"]
}, Open  ]],

Cell["\<\
However, a new function behaves very strangely because I guess that its \
argument is really evaluated, as shown in next line. So, why is not \
Unevaluated removed from the expression?\
\>", "Text",ExpressionUUID->"85744826-e0f3-468f-82a3-9be80dd7ede9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"length", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"4e815e81-266b-402a-8e85-843254d1c93d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"1", "+", "1"}],
      HoldForm], ",", 
     TagBox["2",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"length", "[", "2", "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"6da1c9d0-8ea4-4f8e-885f-f369e8e3a631"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"length", "[", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"1", "+", "1"}], "]"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"f2ce6b49-501c-44f0-b66d-2545cfc3714a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"length", "[", 
     RowBox[{"1", "+", "1"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"length", "[", 
     RowBox[{"Unevaluated", "[", 
      RowBox[{"1", "+", "1"}], "]"}], "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"50bef564-bad2-4fe7-9147-c52fd2a8fd1d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "length", 
  "]"}]], "Input",ExpressionUUID->"aca8a051-2147-4f1f-a52a-25a6cfdc62dd"],

Cell["\<\
Nothing for the rest of this section goes into the package. We just test \
different ideas:\
\>", "Text",ExpressionUUID->"fb7a16fb-af9c-4edd-af4e-cac3936800b5"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
2.6.2. The problem of evaluation. Use ReplacePart/Extract. HoldMap\
\>", "Subsubsection",ExpressionUUID->"f673e550-850b-43ad-b046-bf985c025af6"],

Cell["\<\
We want to map a function ff on the elements of an expression without \
evaluating the whole expression or any of its parts (nor at the beginning not \
at the end), but evaluating the function ff on each element throught \
downvalues of ff or upvalues for the elements of the expression. We also want \
to implement recursion in this function. There are two main options:
\t- We can avoid evaluation of the input wrapping it initially with xHold and \
then evaluate its parts using Extract and ReplacePart,
\t- or else we can just be extremely careful using the holding attributes and \
the head Unevaluated.
The first possibility is simpler, but then recursion becomes more complicated \
because the mapped head is inside a holding head and hence does not easily \
evaluate. The second possibility is easier from the recursion point of view, \
but it is also easy to let the arguments evaluate if we manipulate them \
carelessly.\
\>", "Text",ExpressionUUID->"ef819099-1142-40dc-93ea-2793388d4663"],

Cell["Let us first explore the first possibility:", \
"Text",ExpressionUUID->"6075dd00-5629-4653-bdc2-29695f199b90"],

Cell["This is a simple example:", \
"Text",ExpressionUUID->"00a09daf-0d14-4dd5-80b0-869501447bf9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"82553390-17e1-4ffb-9971-e8412f213854"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Output",ExpressionUUID->"81391a58-1300-4b0d-a868-e81e311bccdb"]
}, Open  ]],

Cell["We define downvalues for ff:", \
"Text",ExpressionUUID->"2377446f-772a-4d72-9e88-14fc3ffbd3cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", "k_Integer", "]"}], ":=", 
  RowBox[{
  "k", "^", 
   "2"}]}]], "Input",ExpressionUUID->"a47f407b-a392-4196-bc72-cb0b71d1a431"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "ff", 
  "]"}]], "Input",ExpressionUUID->"714cd374-3dc9-4bc8-8333-b172720b9c49"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"ff", "[", "k_Integer", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["k", "2"]}], 
  "}"}]], "Output",ExpressionUUID->"f7677dd3-2739-4693-bed7-217456c29261"]
}, Open  ]],

Cell["\<\
It is clear that we do not want ff to let evaluate its arguments. Therefore \
we must set a holding attribute. Note that this does not prevent the use of \
downvalues of ff, which is later in the evaluation cycle.\
\>", "Text",ExpressionUUID->"e0e2db63-aba0-424e-a7a7-507fd9c1d299"],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"ff", ",", "HoldFirst"}], 
  "]"}]], "Input",ExpressionUUID->"36d8b9ae-c88f-43ca-bc8c-7b77f16877ed"],

Cell["\<\
The example is that we want to convert all integers in the expression \
1+2+(3+4) into their squares, without doing any sum at any point.\
\>", "Text",ExpressionUUID->"90a88860-a09f-408b-9f23-f57230b4913f"],

Cell["Without a holding head, Map evaluates its arguments:", \
"Text",ExpressionUUID->"b2bbb7cf-4bfb-477d-9c12-225879473584"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"ff", ",", 
    RowBox[{"1", "+", "2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"f53dadce-d89f-42fd-a7b4-1e81d68236c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"3", "+", "4"}],
        HoldForm], ",", 
       TagBox["7",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"1", "+", "2", "+", "7"}],
      HoldForm], ",", 
     TagBox["10",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"ff", "/@", "10"}],
    HoldForm], ",", 
   TagBox["10",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"0f7baac5-75a2-45cd-b06d-4a6f894c143e"]
}, Open  ]],

Cell["\<\
We can add Unevaluated to avoid evaluation of the original expression, but \
then there cannot be recursion because the argument is evaluated before the \
call to ff. The expression is evaluated at the end too.\
\>", "Text",ExpressionUUID->"aa1b8b92-5932-4c8f-84b8-75a7589019b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"ff", ",", 
    RowBox[{"Unevaluated", "[", 
     RowBox[{"1", "+", "2"}], "]"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"40bc92f3-b402-4faa-af04-cd87a1eaf5d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "/@", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2"}], ")"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"ff", "[", "1", "]"}], "+", 
     RowBox[{"ff", "[", "2", "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", "1", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["1", "2"],
      HoldForm], ",", 
     TagBox["1",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["2", "2"],
      HoldForm], ",", 
     TagBox["4",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"1", "+", "4"}],
    HoldForm], ",", 
   TagBox["5",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"d7e63d11-f3b5-49d4-b588-497a1ee2bb69"]
}, Open  ]],

Cell["\<\
If we wrap the expression with Hold, then ff does not get evaluated:\
\>", "Text",ExpressionUUID->"078815d6-14c8-4d69-b607-5675cddd58a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"ff", ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"1", "+", "2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"99a74f00-bc6c-4f2b-ba03-c81d68d477c2"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"ff", "[", "1", "]"}], "+", 
   RowBox[{"ff", "[", "2", "]"}], "+", 
   RowBox[{"ff", "[", 
    RowBox[{"3", "+", "4"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"0d66fa6d-a24d-4c16-a929-d052bfa92bc0"]
}, Open  ]],

Cell["We have not implemented recursion yet:", \
"Text",ExpressionUUID->"5a5c0f33-4712-488d-a506-07bc0e54771f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"ff", ",", 
    RowBox[{"Unevaluated", "[", 
     RowBox[{"1", "+", "2", "+", 
      RowBox[{"(", 
       RowBox[{"3", "+", "4"}], ")"}]}], "]"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"375279c2-abaf-4d1f-911e-086c17accf2c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "/@", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2", "+", 
       RowBox[{"(", 
        RowBox[{"3", "+", "4"}], ")"}]}], ")"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"ff", "[", "1", "]"}], "+", 
     RowBox[{"ff", "[", "2", "]"}], "+", 
     RowBox[{"ff", "[", 
      RowBox[{"3", "+", "4"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", "1", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["1", "2"],
      HoldForm], ",", 
     TagBox["1",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["2", "2"],
      HoldForm], ",", 
     TagBox["4",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"1", "+", "4", "+", 
     RowBox[{"ff", "[", 
      RowBox[{"3", "+", "4"}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"5", "+", 
     RowBox[{"ff", "[", 
      RowBox[{"3", "+", "4"}], "]"}]}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"9440a763-a895-46c5-b9af-8b478b74128f"]
}, Open  ]],

Cell["\<\
Therefore we need to control the evaluation. A good option is xEvaluateAt2, \
constructed from Extract and ReplacePart:\
\>", "Text",ExpressionUUID->"ef7d503c-eb3f-4f7b-8d41-6b226d4d7e6f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xACP`xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"1", "+", "2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", "ff"}], 
  "]"}]], "Input",ExpressionUUID->"8dbae65f-08c7-4f39-904e-196119c3e353"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"1", "+", "2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"8457053b-a144-4b26-909a-c51add83289b"]
}, Open  ]],

Cell["\<\
A complete possibility in this case would be the following, but it is not \
recursive:\
\>", "Text",ExpressionUUID->"8f313f55-1a2e-44e3-b2b4-1586f859dc86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xACP`xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"1", "+", "2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2"}], "}"}]}], "}"}], ",", "ff"}], 
  "]"}]], "Input",ExpressionUUID->"562faa52-f7c7-46d9-a961-2a89ccb39574"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"1", "+", "2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2"}], "}"}]}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"59dc652f-0755-419c-ab1f-4484f5d15022"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"1f699705-cd19-4e84-9f70-152f398170e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are new symbols in Global`:\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"args\"\>", ",", "\<\"arrayL\"\>", 
     ",", "\<\"arrayR\"\>", ",", "\<\"b\"\>", ",", "\<\"BeginExamples\"\>", 
     ",", "\<\"expr\"\>", ",", "\<\"f\"\>", ",", "\<\"ff\"\>", 
     ",", "\<\"head\"\>", ",", "\<\"k\"\>", ",", "\<\"list\"\>", 
     ",", "\<\"positions\"\>", ",", "\<\"posn\"\>", ",", "\<\"r\"\>", 
     ",", "\<\"x\"\>", ",", "\<\"xEvaluateAt2\"\>", ",", "\<\"xThrough\"\>"}],
     "}"}]}],
  SequenceForm[
  "There are new symbols in Global`:", {
   "a", "args", "arrayL", "arrayR", "b", "BeginExamples", "expr", "f", "ff", 
    "head", "k", "list", "positions", "posn", "r", "x", "xEvaluateAt2", 
    "xThrough"}],
  Editable->
   False]], "Print",ExpressionUUID->"bddaa374-6e4b-405d-9290-ca9072f06eb9"]
}, Open  ]],

Cell["\<\
We can implement recursion as follows. The idea is that we must evaluate the \
mapped function, but without evaluating the expression. A possibility is \
given below, based on the fact that we enclose all substructures with the \
xHold function.\
\>", "Text",ExpressionUUID->"566875a6-56f4-4958-9fd6-0dabb45590ed"],

Cell["\<\
This is the final function. There is a third argument to choose the holding \
function. By default it is xHold. This function is not included in the \
package.\
\>", "Text",ExpressionUUID->"ae66becf-ad76-4402-ad5a-e50cc3c49236"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "HoldMap"}]], \
"Input",ExpressionUUID->"64199437-a1b9-4c5c-954f-f50868c57359"],

Cell[BoxData[
 StyleBox["\<\"xAct`xCore`Private`HoldMap[f, expr] maps and evaluates f on \
the elements of expr without evaluating the whole expression, which is \
returned wrapped in xHold. xAct`xCore`Private`HoldMap[f, expr, g] returns the \
expression wrapped with the function g.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974377-4493425",ExpressionUUID->"2df38b49-80b5-4143-9b7a-\
e3cc3e63a2ee"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"HoldMap", ",", "HoldAll"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HoldMap", "[", 
    RowBox[{"f_", ",", "expr_", ",", 
     RowBox[{"g_", ":", "xHold"}]}], "]"}], ":=", 
   RowBox[{"xEvaluateAt2", "[", 
    RowBox[{
     RowBox[{"g", "@", "expr"}], ",", 
     RowBox[{"Thread", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", 
          RowBox[{"Unevaluated", "@", "expr"}]}]}]}], "}"}], "]"}], ",", 
     "f"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"HoldMap", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "HoldMap", "]"}], 
  ";"}]}], "Input",ExpressionUUID->"b7e9e5f1-1952-4ff5-a927-e429b6fba6fd"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"23eb345e-5b00-455a-8897-0510b30d2106"],

Cell["\<\
We add recursion as follows. In this case recursion acts on every nonatomic \
expression:\
\>", "Text",ExpressionUUID->"a6ecbaf4-f7fd-443f-867b-1a3b98c1bddb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"k", ":", 
    RowBox[{"_", "[", "___", "]"}]}], "]"}], ":=", 
  RowBox[{"xACP`HoldMap", "[", 
   RowBox[{"ff", ",", "k"}], 
   "]"}]}]], "Input",ExpressionUUID->"685df6d1-5fbd-4fdb-9a8f-953b592ed7f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"4", "+", 
      RowBox[{"(", 
       RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"331d12e1-dd13-4da7-88eb-fd6a59e7fba8"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"(", 
         RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}],
    DisplayForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"824083c8-cd36-45d2-8c27-9a66422a9ffa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"5199dbbc-037d-4cf2-832f-98520eaad4b2"],

Cell["\<\
xAct`xCore`Private`xEvaluateAt2[xHold[1 + (2 + 3) :> Module[{}, 4 + (5 + \
6)]], {{1, 1}, {1, 2}}, ff]\
\>", "Output",ExpressionUUID->"a64455a7-75ac-427d-8be5-8cc57fa0d92c"]
}, Open  ]],

Cell["It also works well if the input has holding structures:", \
"Text",ExpressionUUID->"adca79d5-84b5-4f8d-b4ba-7842bfd8ca27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"(", 
        RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"4dfa5cc9-68dd-4d1e-90c6-1ca357e23478"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"(", 
         RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}],
    DisplayForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"cdbec0c2-cbf7-48bb-aec0-f42db74bd61d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"(", 
        RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"f6e82d2e-2b5a-439d-a53f-b860a6e67180"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   TagBox[
    RowBox[{"Hold", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"4", "+", 
         RowBox[{"(", 
          RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], "]"}],
    DisplayForm], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"4eabd727-a648-44b3-8890-2d14ddc13206"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Hold", "@", 
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"(", 
         RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"7f37badf-9cac-4118-8ede-cd94f5a4b024"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   TagBox[
    RowBox[{"Hold", "[", 
     RowBox[{"Hold", "[", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"(", 
         RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"4", "+", 
          RowBox[{"(", 
           RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], "]"}], "]"}],
    DisplayForm], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"186c0194-c02d-4d8d-93d9-f62399d7fcd8"]
}, Open  ]],

Cell["To eliminate the xHold wrappers we need a second function:", \
"Text",ExpressionUUID->"f95bfd8f-aed7-470b-8b53-5d99e71c769d"],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"MAINff", ",", "HoldFirst"}], 
  "]"}]], "Input",ExpressionUUID->"6a12a09d-d459-486b-af55-0d23681364f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MAINff", "[", "k_", "]"}], ":=", 
  RowBox[{
   RowBox[{"ff", "[", "k", "]"}], "//.", 
   RowBox[{
    RowBox[{"xHold", "[", "kk_", "]"}], "\[Rule]", 
    "kk"}]}]}]], \
"Input",ExpressionUUID->"d94b4553-6bfc-46dd-8094-acd1cb916dc9"],

Cell["It eliminates even the most external of the xHold's.", \
"Text",ExpressionUUID->"eb8f736c-876e-4bdd-9d4b-7152ffbb696e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"4", "+", 
      RowBox[{"(", 
       RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"25ae370e-abb6-48a4-bdc4-cedb12e41f3a"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"6", "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"(", 
        RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"791b3093-931c-4ab1-89fb-9c0952e7c68b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"8aa410d9-c43b-4cae-91fe-9d17d0d3636a"],

Cell["\<\
xAct`xCore`Private`xEvaluateAt2[6 :> Module[{}, 4 + (5 + 6)], {{1, 1}, {1, \
2}}, ff]\
\>", "Output",ExpressionUUID->"f249fd30-c885-4b19-955b-ac7271778e39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"Set", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"0a36ca13-f331-4bfe-9102-5a91b1626bb1"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "=", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"e952d6a4-9fdb-43f4-a61e-1486d7f609f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"5465e817-923e-405f-906d-b8114679372e"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"2bdd2eef-a797-4e16-91c4-9f0d1d6ba078"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{"Hold", "@", 
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"c30c71b0-7d51-494c-8ad1-2ac87c2959ee"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"Hold", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"(", 
        RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"bce944e5-3c29-4a3f-b33e-940e1dd03bd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"RuleDelayed", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"573584c9-b596-4a80-a9b3-469bb093425d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
      RowBox[{"3", "+", 
       RowBox[{"(", 
        RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"xAct`xCore`Private`HoldMap", "[", 
     RowBox[{"ff", ",", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"(", 
         RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
       RowBox[{"3", "+", 
        RowBox[{"(", 
         RowBox[{"4", "+", "5"}], ")"}]}]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
     RowBox[{
      TagBox[
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
        RowBox[{"3", "+", 
         RowBox[{"(", 
          RowBox[{"4", "+", "5"}], ")"}]}]}],
       DisplayForm], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"Range", "[", 
          RowBox[{"Length", "[", 
           RowBox[{"Unevaluated", "[", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{"(", 
               RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
             RowBox[{"3", "+", 
              RowBox[{"(", 
               RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "]"}]}], 
        "}"}], "]"}], ",", "ff"}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"Length", "[", 
             RowBox[{
              RowBox[{"1", "+", 
               RowBox[{"(", 
                RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
              RowBox[{"3", "+", 
               RowBox[{"(", 
                RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}],
            HoldForm], ",", 
           TagBox["2",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"Range", "[", "2", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
     RowBox[{
      TagBox[
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
        RowBox[{"3", "+", 
         RowBox[{"(", 
          RowBox[{"4", "+", "5"}], ")"}]}]}],
       DisplayForm], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "ff"}], "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"34a5043b-e021-4638-a189-9b6a9f3ce373"]
}, Open  ]],

Cell["It is however very slow:", \
"Text",ExpressionUUID->"a5091066-edc8-439d-9a4a-e1c7cdbf1285"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", "%", "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"e8e6f412-b8ca-4d3a-8fdf-c2bb2dc0f102"],

Cell[BoxData["11"], \
"Output",ExpressionUUID->"84c8a0d4-5328-420b-9931-f19783eb57b5"]
}, Open  ]],

Cell["Note however that recursion must be simple:", \
"Text",ExpressionUUID->"e5126962-ed7d-45c6-b521-4490a66b4738"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"k", ":", 
    RowBox[{"_", "[", "___", "]"}]}], "]"}], ":=", 
  RowBox[{"xACP`HoldMap", "[", 
   RowBox[{"ff", ",", "k"}], 
   "]"}]}]], "Input",ExpressionUUID->"6790fee9-d597-4b27-9c37-13025a1a35b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"4", "+", 
      RowBox[{"(", 
       RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"9dffbdbb-dca9-42aa-b121-16979895dffb"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"(", 
         RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}],
    DisplayForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "ff"}], 
  "]"}]], "Output",ExpressionUUID->"8d1ea100-8b4c-4da6-a190-d15b9f82c444"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"k", ":", 
    RowBox[{"_", "[", "___", "]"}]}], "]"}], ":=", 
  RowBox[{"xACP`HoldMap", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ff", "[", "#", "]"}], "&"}], ",", "k"}], 
   "]"}]}]], "Input",ExpressionUUID->"9841ca66-5c52-44f4-9f9e-0af2d6aacf12"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"4", "+", 
      RowBox[{"(", 
       RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"80176097-d173-4097-9726-4718f7f01069"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"(", 
         RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}],
    DisplayForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"ff", "[", "#1", "]"}], "&"}]}], 
  "]"}]], "Output",ExpressionUUID->"40b46722-7ade-4a44-9c27-4381cfedc916"]
}, Open  ]],

Cell["\<\
If a pure function is required,then we need to use the third argument of \
Function:\
\>", "Text",ExpressionUUID->"1e27dae0-ec77-4ad9-9a6c-e4be1e155de2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"k", ":", 
    RowBox[{"_", "[", "___", "]"}]}], "]"}], ":=", 
  RowBox[{"xACP`HoldMap", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "kk", "}"}], ",", 
      RowBox[{"ff", "[", "kk", "]"}], ",", 
      RowBox[{"{", "HoldAll", "}"}]}], "]"}], ",", "k"}], 
   "]"}]}]], "Input",ExpressionUUID->"70a38de4-e1f1-4aca-98d8-3b6ddff9121a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"4", "+", 
      RowBox[{"(", 
       RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"91053cf9-b473-43d3-8bfd-88ac7a54e576"],

Cell[BoxData[
 RowBox[{"xAct`xCore`Private`xEvaluateAt2", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"(", 
         RowBox[{"5", "+", "6"}], ")"}]}]}], "]"}]}],
    DisplayForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "kk", "}"}], ",", 
     RowBox[{"ff", "[", "kk", "]"}], ",", 
     RowBox[{"{", "HoldAll", "}"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"a623ac97-0692-416e-a5ab-eb55cad8fac2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"ff", ",", "MAINff", ",", "k", ",", "kk"}], 
  "]"}]], "Input",ExpressionUUID->"c8b43cc2-bfc5-4035-87a2-944af27f69b6"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"75b0fbe8-d109-46ae-be74-04cc83b0b67f"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6.3. The problem of evaluation. Use ReplacePart/Thread", \
"Subsubsection",ExpressionUUID->"99a979a2-f0fe-4905-8a31-dd2a849238c3"],

Cell["\<\
An alternative is this, which still uses ReplacePart, but now uses Thread \
instead of Extract. This is more complicated, but I think it is faster:\
\>", "Text",ExpressionUUID->"a44b3376-55a4-4227-ba59-76545f5e5945"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"6ebce1d0-d347-4547-ac3f-d3747bf4f64f"],

Cell[BoxData[{
 RowBox[{"SetAttributes", "[", 
  RowBox[{"ff", ",", "HoldFirst"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"ff", "[", "k_Integer", "]"}], ":=", 
  RowBox[{"k", "^", "2"}]}], "\n", 
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"head_", "[", "]"}], "]"}], ":=", 
  RowBox[{"xHold", "[", 
   RowBox[{"head", "[", "]"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"head_", "[", "elements__", "]"}], "]"}], ":=", 
  RowBox[{"ReplacePart", "[", 
   RowBox[{
    RowBox[{"xHold", "[", 
     RowBox[{"head", "[", "elements", "]"}], "]"}], ",", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "k", "}"}], ",", 
        RowBox[{"ff", "[", "k", "]"}], ",", 
        RowBox[{"{", "HoldAll", "}"}]}], "]"}], ",", 
      RowBox[{"Unevaluated", "[", 
       RowBox[{"List", "[", "elements", "]"}], "]"}]}], "]"}], ",", 
    RowBox[{"Thread", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"Range", "@", 
        RowBox[{"Length", "@", 
         RowBox[{"HoldComplete", "[", "elements", "]"}]}]}]}], "}"}], "]"}], 
    ",", 
    RowBox[{"Thread", "[", 
     RowBox[{"{", 
      RowBox[{"Range", "@", 
       RowBox[{"Length", "@", 
        RowBox[{"HoldComplete", "[", "elements", "]"}]}]}], "}"}], "]"}]}], 
   "]"}]}]}], "Input",ExpressionUUID->"dd6bc044-6b3e-4ea1-a94d-0e7f55e74f52"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"RuleDelayed", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"e1e5e062-b980-4b5f-8e05-71f9acdf04ca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
      RowBox[{"3", "+", 
       RowBox[{"(", 
        RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"ReplacePart", "[", 
     RowBox[{
      TagBox[
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
        RowBox[{"3", "+", 
         RowBox[{"(", 
          RowBox[{"4", "+", "5"}], ")"}]}]}],
       DisplayForm], ",", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
       RowBox[{"Unevaluated", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "+", 
           RowBox[{"(", 
            RowBox[{"2", "+", "3"}], ")"}]}], ",", 
          RowBox[{"3", "+", 
           RowBox[{"(", 
            RowBox[{"4", "+", "5"}], ")"}]}]}], "}"}], "]"}]}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"Range", "[", 
          RowBox[{"Length", "[", 
           RowBox[{"HoldComplete", "[", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{"(", 
               RowBox[{"2", "+", "3"}], ")"}]}], ",", 
             RowBox[{"3", "+", 
              RowBox[{"(", 
               RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "]"}]}], 
        "}"}], "]"}], ",", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"Range", "[", 
         RowBox[{"Length", "[", 
          RowBox[{"HoldComplete", "[", 
           RowBox[{
            RowBox[{"1", "+", 
             RowBox[{"(", 
              RowBox[{"2", "+", "3"}], ")"}]}], ",", 
            RowBox[{"3", "+", 
             RowBox[{"(", 
              RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "]"}], "}"}], 
       "]"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", "3"}], ")"}]}], ",", 
         RowBox[{"3", "+", 
          RowBox[{"(", 
           RowBox[{"4", "+", "5"}], ")"}]}]}], "}"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", "3"}], ")"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"3", "+", 
          RowBox[{"(", 
           RowBox[{"4", "+", "5"}], ")"}]}], "]"}]}], "}"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", "3"}], ")"}]}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ff", "[", 
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", "3"}], ")"}]}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ReplacePart", "[", 
         RowBox[{
          TagBox[
           RowBox[{"1", "+", 
            RowBox[{"(", 
             RowBox[{"2", "+", "3"}], ")"}]}],
           DisplayForm], ",", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
           RowBox[{"Unevaluated", "[", 
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"2", "+", "3"}]}], "}"}], "]"}]}], ",", 
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"Range", "[", 
              RowBox[{"Length", "[", 
               RowBox[{"HoldComplete", "[", 
                RowBox[{"1", ",", 
                 RowBox[{"2", "+", "3"}]}], "]"}], "]"}], "]"}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{"Range", "[", 
             RowBox[{"Length", "[", 
              RowBox[{"HoldComplete", "[", 
               RowBox[{"1", ",", 
                RowBox[{"2", "+", "3"}]}], "]"}], "]"}], "]"}], "}"}], 
           "]"}]}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"2", "+", "3"}]}], "}"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}], ",", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
             RowBox[{"2", "+", "3"}], "]"}]}], "}"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"ff", "[", "1", "]"}],
            HoldForm], ",", 
           TagBox[
            SuperscriptBox["1", "2"],
            HoldForm], ",", 
           TagBox["1",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
             RowBox[{"2", "+", "3"}], "]"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"ff", "[", 
             RowBox[{"2", "+", "3"}], "]"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"ReplacePart", "[", 
             RowBox[{
              TagBox[
               RowBox[{"2", "+", "3"}],
               DisplayForm], ",", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{
                 RowBox[{"{", "k", "}"}], ",", 
                 RowBox[{"ff", "[", "k", "]"}], ",", 
                 RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
               RowBox[{"Unevaluated", "[", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "3"}], "}"}], "]"}]}], ",", 
              RowBox[{"Thread", "[", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"Range", "[", 
                  RowBox[{"Length", "[", 
                   RowBox[{"HoldComplete", "[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}], "]"}]}], "}"}], 
               "]"}], ",", 
              RowBox[{"Thread", "[", 
               RowBox[{"{", 
                RowBox[{"Range", "[", 
                 RowBox[{"Length", "[", 
                  RowBox[{"HoldComplete", "[", 
                   RowBox[{"2", ",", "3"}], "]"}], "]"}], "]"}], "}"}], 
               "]"}]}], "]"}],
            HoldForm], ",", 
           RowBox[{"{", 
            RowBox[{
             TagBox[
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{
                 RowBox[{"{", "k", "}"}], ",", 
                 RowBox[{"ff", "[", "k", "]"}], ",", 
                 RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
               RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}]}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"{", "k", "}"}], ",", 
                   RowBox[{"ff", "[", "k", "]"}], ",", 
                   RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}], 
                ",", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"{", "k", "}"}], ",", 
                   RowBox[{"ff", "[", "k", "]"}], ",", 
                   RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}]}], 
               "}"}],
              HoldForm], ",", 
             RowBox[{"{", 
              RowBox[{
               TagBox[
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"{", "k", "}"}], ",", 
                   RowBox[{"ff", "[", "k", "]"}], ",", 
                   RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}],
                HoldForm], ",", 
               TagBox[
                RowBox[{"ff", "[", "2", "]"}],
                HoldForm], ",", 
               TagBox[
                SuperscriptBox["2", "2"],
                HoldForm], ",", 
               TagBox["4",
                HoldForm]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               TagBox[
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"{", "k", "}"}], ",", 
                   RowBox[{"ff", "[", "k", "]"}], ",", 
                   RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}],
                HoldForm], ",", 
               TagBox[
                RowBox[{"ff", "[", "3", "]"}],
                HoldForm], ",", 
               TagBox[
                SuperscriptBox["3", "2"],
                HoldForm], ",", 
               TagBox["9",
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{"4", ",", "9"}], "}"}],
              HoldForm]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   TagBox[
                    RowBox[{"Length", "[", 
                    RowBox[{"HoldComplete", "[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}],
                    HoldForm], ",", 
                   TagBox["2",
                    HoldForm]}], "}"}], ",", 
                 TagBox[
                  RowBox[{"Range", "[", "2", "]"}],
                  HoldForm], ",", 
                 TagBox[
                  RowBox[{"{", 
                   RowBox[{"1", ",", "2"}], "}"}],
                  HoldForm]}], "}"}], ",", 
               TagBox[
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"{", 
                   RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"Thread", "[", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
              HoldForm]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   TagBox[
                    RowBox[{"Length", "[", 
                    RowBox[{"HoldComplete", "[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}],
                    HoldForm], ",", 
                   TagBox["2",
                    HoldForm]}], "}"}], ",", 
                 TagBox[
                  RowBox[{"Range", "[", "2", "]"}],
                  HoldForm], ",", 
                 TagBox[
                  RowBox[{"{", 
                   RowBox[{"1", ",", "2"}], "}"}],
                  HoldForm]}], "}"}], ",", 
               TagBox[
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}], "}"}],
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"Thread", "[", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "1", "}"}], ",", 
                RowBox[{"{", "2", "}"}]}], "}"}],
              HoldForm]}], "}"}], ",", 
           TagBox[
            RowBox[{"ReplacePart", "[", 
             RowBox[{
              TagBox[
               RowBox[{"2", "+", "3"}],
               DisplayForm], ",", 
              RowBox[{"{", 
               RowBox[{"4", ",", "9"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "1", "}"}], ",", 
                RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}],
            HoldForm], ",", 
           TagBox[
            TagBox[
             RowBox[{"4", "+", "9"}],
             DisplayForm],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{"1", ",", 
            TagBox[
             RowBox[{"4", "+", "9"}],
             DisplayForm]}], "}"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               TagBox[
                RowBox[{"Length", "[", 
                 RowBox[{"HoldComplete", "[", 
                  RowBox[{"1", ",", 
                   RowBox[{"2", "+", "3"}]}], "]"}], "]"}],
                HoldForm], ",", 
               TagBox["2",
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"Range", "[", "2", "]"}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}],
              HoldForm]}], "}"}], ",", 
           TagBox[
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               TagBox[
                RowBox[{"Length", "[", 
                 RowBox[{"HoldComplete", "[", 
                  RowBox[{"1", ",", 
                   RowBox[{"2", "+", "3"}]}], "]"}], "]"}],
                HoldForm], ",", 
               TagBox["2",
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"Range", "[", "2", "]"}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}],
              HoldForm]}], "}"}], ",", 
           TagBox[
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "}"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", "1", "}"}], ",", 
            RowBox[{"{", "2", "}"}]}], "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"ReplacePart", "[", 
         RowBox[{
          TagBox[
           RowBox[{"1", "+", 
            RowBox[{"(", 
             RowBox[{"2", "+", "3"}], ")"}]}],
           DisplayForm], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            TagBox[
             RowBox[{"4", "+", "9"}],
             DisplayForm]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", "1", "}"}], ",", 
            RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}],
        HoldForm], ",", 
       TagBox[
        TagBox[
         RowBox[{"1", "+", 
          RowBox[{"(", 
           TagBox[
            RowBox[{"4", "+", "9"}],
            DisplayForm], ")"}]}],
         DisplayForm],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"3", "+", 
          RowBox[{"(", 
           RowBox[{"4", "+", "5"}], ")"}]}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ff", "[", 
         RowBox[{"3", "+", 
          RowBox[{"(", 
           RowBox[{"4", "+", "5"}], ")"}]}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ReplacePart", "[", 
         RowBox[{
          TagBox[
           RowBox[{"3", "+", 
            RowBox[{"(", 
             RowBox[{"4", "+", "5"}], ")"}]}],
           DisplayForm], ",", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
           RowBox[{"Unevaluated", "[", 
            RowBox[{"{", 
             RowBox[{"3", ",", 
              RowBox[{"4", "+", "5"}]}], "}"}], "]"}]}], ",", 
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"Range", "[", 
              RowBox[{"Length", "[", 
               RowBox[{"HoldComplete", "[", 
                RowBox[{"3", ",", 
                 RowBox[{"4", "+", "5"}]}], "]"}], "]"}], "]"}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{"Range", "[", 
             RowBox[{"Length", "[", 
              RowBox[{"HoldComplete", "[", 
               RowBox[{"3", ",", 
                RowBox[{"4", "+", "5"}]}], "]"}], "]"}], "]"}], "}"}], 
           "]"}]}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"4", "+", "5"}]}], "}"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}], ",", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
             RowBox[{"4", "+", "5"}], "]"}]}], "}"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"ff", "[", "3", "]"}],
            HoldForm], ",", 
           TagBox[
            SuperscriptBox["3", "2"],
            HoldForm], ",", 
           TagBox["9",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
             RowBox[{"4", "+", "5"}], "]"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"ff", "[", 
             RowBox[{"4", "+", "5"}], "]"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"ReplacePart", "[", 
             RowBox[{
              TagBox[
               RowBox[{"4", "+", "5"}],
               DisplayForm], ",", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{
                 RowBox[{"{", "k", "}"}], ",", 
                 RowBox[{"ff", "[", "k", "]"}], ",", 
                 RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
               RowBox[{"Unevaluated", "[", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5"}], "}"}], "]"}]}], ",", 
              RowBox[{"Thread", "[", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"Range", "[", 
                  RowBox[{"Length", "[", 
                   RowBox[{"HoldComplete", "[", 
                    RowBox[{"4", ",", "5"}], "]"}], "]"}], "]"}]}], "}"}], 
               "]"}], ",", 
              RowBox[{"Thread", "[", 
               RowBox[{"{", 
                RowBox[{"Range", "[", 
                 RowBox[{"Length", "[", 
                  RowBox[{"HoldComplete", "[", 
                   RowBox[{"4", ",", "5"}], "]"}], "]"}], "]"}], "}"}], 
               "]"}]}], "]"}],
            HoldForm], ",", 
           RowBox[{"{", 
            RowBox[{
             TagBox[
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{
                 RowBox[{"{", "k", "}"}], ",", 
                 RowBox[{"ff", "[", "k", "]"}], ",", 
                 RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
               RowBox[{"{", 
                RowBox[{"4", ",", "5"}], "}"}]}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"{", "k", "}"}], ",", 
                   RowBox[{"ff", "[", "k", "]"}], ",", 
                   RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "4", "]"}], 
                ",", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"{", "k", "}"}], ",", 
                   RowBox[{"ff", "[", "k", "]"}], ",", 
                   RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "5", "]"}]}], 
               "}"}],
              HoldForm], ",", 
             RowBox[{"{", 
              RowBox[{
               TagBox[
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"{", "k", "}"}], ",", 
                   RowBox[{"ff", "[", "k", "]"}], ",", 
                   RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "4", "]"}],
                HoldForm], ",", 
               TagBox[
                RowBox[{"ff", "[", "4", "]"}],
                HoldForm], ",", 
               TagBox[
                SuperscriptBox["4", "2"],
                HoldForm], ",", 
               TagBox["16",
                HoldForm]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               TagBox[
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"{", "k", "}"}], ",", 
                   RowBox[{"ff", "[", "k", "]"}], ",", 
                   RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "5", "]"}],
                HoldForm], ",", 
               TagBox[
                RowBox[{"ff", "[", "5", "]"}],
                HoldForm], ",", 
               TagBox[
                SuperscriptBox["5", "2"],
                HoldForm], ",", 
               TagBox["25",
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{"16", ",", "25"}], "}"}],
              HoldForm]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   TagBox[
                    RowBox[{"Length", "[", 
                    RowBox[{"HoldComplete", "[", 
                    RowBox[{"4", ",", "5"}], "]"}], "]"}],
                    HoldForm], ",", 
                   TagBox["2",
                    HoldForm]}], "}"}], ",", 
                 TagBox[
                  RowBox[{"Range", "[", "2", "]"}],
                  HoldForm], ",", 
                 TagBox[
                  RowBox[{"{", 
                   RowBox[{"1", ",", "2"}], "}"}],
                  HoldForm]}], "}"}], ",", 
               TagBox[
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"{", 
                   RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"Thread", "[", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
              HoldForm]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   TagBox[
                    RowBox[{"Length", "[", 
                    RowBox[{"HoldComplete", "[", 
                    RowBox[{"4", ",", "5"}], "]"}], "]"}],
                    HoldForm], ",", 
                   TagBox["2",
                    HoldForm]}], "}"}], ",", 
                 TagBox[
                  RowBox[{"Range", "[", "2", "]"}],
                  HoldForm], ",", 
                 TagBox[
                  RowBox[{"{", 
                   RowBox[{"1", ",", "2"}], "}"}],
                  HoldForm]}], "}"}], ",", 
               TagBox[
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}], "}"}],
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"Thread", "[", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "1", "}"}], ",", 
                RowBox[{"{", "2", "}"}]}], "}"}],
              HoldForm]}], "}"}], ",", 
           TagBox[
            RowBox[{"ReplacePart", "[", 
             RowBox[{
              TagBox[
               RowBox[{"4", "+", "5"}],
               DisplayForm], ",", 
              RowBox[{"{", 
               RowBox[{"16", ",", "25"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "1", "}"}], ",", 
                RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}],
            HoldForm], ",", 
           TagBox[
            TagBox[
             RowBox[{"16", "+", "25"}],
             DisplayForm],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{"9", ",", 
            TagBox[
             RowBox[{"16", "+", "25"}],
             DisplayForm]}], "}"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               TagBox[
                RowBox[{"Length", "[", 
                 RowBox[{"HoldComplete", "[", 
                  RowBox[{"3", ",", 
                   RowBox[{"4", "+", "5"}]}], "]"}], "]"}],
                HoldForm], ",", 
               TagBox["2",
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"Range", "[", "2", "]"}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}],
              HoldForm]}], "}"}], ",", 
           TagBox[
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               TagBox[
                RowBox[{"Length", "[", 
                 RowBox[{"HoldComplete", "[", 
                  RowBox[{"3", ",", 
                   RowBox[{"4", "+", "5"}]}], "]"}], "]"}],
                HoldForm], ",", 
               TagBox["2",
                HoldForm]}], "}"}], ",", 
             TagBox[
              RowBox[{"Range", "[", "2", "]"}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}],
              HoldForm]}], "}"}], ",", 
           TagBox[
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "}"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", "1", "}"}], ",", 
            RowBox[{"{", "2", "}"}]}], "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"ReplacePart", "[", 
         RowBox[{
          TagBox[
           RowBox[{"3", "+", 
            RowBox[{"(", 
             RowBox[{"4", "+", "5"}], ")"}]}],
           DisplayForm], ",", 
          RowBox[{"{", 
           RowBox[{"9", ",", 
            TagBox[
             RowBox[{"16", "+", "25"}],
             DisplayForm]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", "1", "}"}], ",", 
            RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}],
        HoldForm], ",", 
       TagBox[
        TagBox[
         RowBox[{"9", "+", 
          RowBox[{"(", 
           TagBox[
            RowBox[{"16", "+", "25"}],
            DisplayForm], ")"}]}],
         DisplayForm],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
        TagBox[
         RowBox[{"1", "+", 
          RowBox[{"(", 
           TagBox[
            RowBox[{"4", "+", "9"}],
            DisplayForm], ")"}]}],
         DisplayForm], ",", 
        TagBox[
         RowBox[{"9", "+", 
          RowBox[{"(", 
           TagBox[
            RowBox[{"16", "+", "25"}],
            DisplayForm], ")"}]}],
         DisplayForm]}], "}"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"Length", "[", 
             RowBox[{"HoldComplete", "[", 
              RowBox[{
               RowBox[{"1", "+", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "3"}], ")"}]}], ",", 
               RowBox[{"3", "+", 
                RowBox[{"(", 
                 RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}],
            HoldForm], ",", 
           TagBox["2",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"Range", "[", "2", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"Length", "[", 
             RowBox[{"HoldComplete", "[", 
              RowBox[{
               RowBox[{"1", "+", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "3"}], ")"}]}], ",", 
               RowBox[{"3", "+", 
                RowBox[{"(", 
                 RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}],
            HoldForm], ",", 
           TagBox["2",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"Range", "[", "2", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "}"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "2", "}"}]}], "}"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"ReplacePart", "[", 
     RowBox[{
      TagBox[
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
        RowBox[{"3", "+", 
         RowBox[{"(", 
          RowBox[{"4", "+", "5"}], ")"}]}]}],
       DisplayForm], ",", 
      RowBox[{"{", 
       RowBox[{
        TagBox[
         RowBox[{"1", "+", 
          RowBox[{"(", 
           TagBox[
            RowBox[{"4", "+", "9"}],
            DisplayForm], ")"}]}],
         DisplayForm], ",", 
        TagBox[
         RowBox[{"9", "+", 
          RowBox[{"(", 
           TagBox[
            RowBox[{"16", "+", "25"}],
            DisplayForm], ")"}]}],
         DisplayForm]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "2", "}"}]}], "}"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    TagBox[
     RowBox[{
      TagBox[
       RowBox[{"1", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"4", "+", "9"}],
          DisplayForm], ")"}]}],
       DisplayForm], "\[RuleDelayed]", 
      TagBox[
       RowBox[{"9", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"16", "+", "25"}],
          DisplayForm], ")"}]}],
       DisplayForm]}],
     DisplayForm],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"6c9b9fc7-b4e2-4dbf-bf47-efb40d0b47d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Flatten", "[", "%", "]"}], 
  "]"}]], "Input",ExpressionUUID->"83a8ecb0-fab2-4c8d-b75d-d9f85b3df7b6"],

Cell[BoxData["133"], \
"Output",ExpressionUUID->"84b91460-7b3a-4183-9f9a-d2d2a82e165a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"Set", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"001d8bb0-3f5b-482e-bce3-83f57c07872d"],

Cell[BoxData[
 TagBox[
  RowBox[{"Hold", "[", 
   TagBox[
    RowBox[{
     TagBox[
      RowBox[{"1", "+", 
       RowBox[{"(", 
        TagBox[
         RowBox[{"4", "+", "9"}],
         DisplayForm], ")"}]}],
      DisplayForm], "=", 
     TagBox[
      RowBox[{"9", "+", 
       RowBox[{"(", 
        TagBox[
         RowBox[{"16", "+", "25"}],
         DisplayForm], ")"}]}],
      DisplayForm]}],
    DisplayForm], "]"}],
  DisplayForm]], \
"Output",ExpressionUUID->"ba357acc-ad47-442a-9361-e279d4ca708d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//.", 
  RowBox[{
   RowBox[{"xHold", "[", "k_", "]"}], "\[Rule]", 
   "k"}]}]], "Input",ExpressionUUID->"c99fd122-0f6c-4326-86b6-82bcf4747913"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"4", "+", "9"}], ")"}]}], "=", 
   RowBox[{"9", "+", 
    RowBox[{"(", 
     RowBox[{"16", "+", "25"}], ")"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"e0839b5f-224b-49f3-b89c-79370708a757"]
}, Open  ]],

Cell["\<\
Again, we can implement the elimination of xHold using two functions:\
\>", "Text",ExpressionUUID->"29b3e413-33cf-4f2a-a58c-d12813d3867a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"MAINff", ",", "HoldFirst"}], "]"}], 
  ";"}]], "Input",ExpressionUUID->"84abc184-e9c6-46b6-a2f8-595a524d6926"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MAINff", "[", "k_", "]"}], ":=", 
  RowBox[{
   RowBox[{"ff", "[", "k", "]"}], "//.", 
   RowBox[{
    RowBox[{"xHold", "[", "kk_", "]"}], "\[Rule]", 
    "kk"}]}]}]], \
"Input",ExpressionUUID->"386f2dc5-5485-4751-8d63-1dad9a0c1926"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{"1", "+", 
   RowBox[{"(", 
    RowBox[{"2", "+", "3"}], ")"}]}], 
  "]"}]], "Input",ExpressionUUID->"f31b3e9c-1c3c-4521-b529-b8204741e3bd"],

Cell[BoxData["14"], \
"Output",ExpressionUUID->"7cbfe4dc-3715-4483-a32e-11b077b38cbe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"RuleDelayed", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"c6367c11-93aa-4450-a8f1-bfb07232638f"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"4", "+", "9"}],
       DisplayForm], ")"}]}],
    DisplayForm], "\[RuleDelayed]", 
   TagBox[
    RowBox[{"9", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"16", "+", "25"}],
       DisplayForm], ")"}]}],
    DisplayForm]}],
  DisplayForm]], \
"Output",ExpressionUUID->"3bbb04e9-0e7b-49dc-a9d2-ed52baec1965"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{"RuleDelayed", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"756ec81c-c457-4be1-b3e5-65ae399bcf8d"],

Cell[BoxData[
 RowBox[{"14", "\[RuleDelayed]", 
  RowBox[{"9", "+", 
   RowBox[{"(", 
    RowBox[{"16", "+", "25"}], 
    ")"}]}]}]], \
"Output",ExpressionUUID->"8b0c9946-38aa-4f36-a223-af0c645e4b15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"96508120-0421-4017-91e7-2d0f206793a2"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"4", "+", "9"}],
       DisplayForm], ")"}]}],
    DisplayForm], "\[Rule]", 
   TagBox[
    RowBox[{"9", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"16", "+", "25"}],
       DisplayForm], ")"}]}],
    DisplayForm]}],
  DisplayForm]], \
"Output",ExpressionUUID->"b4bc0880-7ac4-4949-b1d2-04771120557e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"363ad789-ad9d-4122-86c6-1cbdaf8afba3"],

Cell[BoxData[
 RowBox[{"14", "\[Rule]", 
  "50"}]], "Output",ExpressionUUID->"8caf9e21-6225-4041-8547-e5fdbb65edeb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"Rule", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"3df283a0-18fe-4f0a-920a-88f9ec290bc5"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"4", "+", "9"}], ")"}]}], "\[Rule]", 
   RowBox[{"9", "+", 
    RowBox[{"(", 
     RowBox[{"16", "+", "25"}], ")"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"b90b5f6f-5053-4d81-aa32-09d7074353ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"Hold", "[", 
    RowBox[{"Rule", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"(", 
        RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"05206809-41d4-4792-b99f-c85ccddb5bbc"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "9"}], ")"}]}], "\[Rule]", 
    RowBox[{"9", "+", 
     RowBox[{"(", 
      RowBox[{"16", "+", "25"}], ")"}]}]}], "]"}], 
  "]"}]], "Output",ExpressionUUID->"c7e539bb-75be-410f-8ee6-0f74417f1394"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], ":>", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"d3753ac5-390d-47cf-91fb-8eae9cc6e5a8"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"4", "+", "9"}],
       DisplayForm], ")"}]}],
    DisplayForm], "\[RuleDelayed]", 
   TagBox[
    RowBox[{"Module", "[", 
     RowBox[{
      TagBox[
       RowBox[{"{", "}"}],
       DisplayForm], ",", 
      TagBox[
       RowBox[{"9", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"16", "+", "25"}],
          DisplayForm], ")"}]}],
       DisplayForm]}], "]"}],
    DisplayForm]}],
  DisplayForm]], \
"Output",ExpressionUUID->"965a57f2-918c-4342-9227-b86a928239e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MAINff", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], ":>", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"4d842ee1-0ffa-423d-a8ea-8ef0c12197cf"],

Cell[BoxData[
 RowBox[{"14", "\[RuleDelayed]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"9", "+", 
     RowBox[{"(", 
      RowBox[{"16", "+", "25"}], ")"}]}]}], 
   "]"}]}]], "Output",ExpressionUUID->"a8286cf6-0630-4396-ba6d-3918846f4090"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "ff", ",", "k", ",", "kk", ",", "MAINff", ",", "head", ",", "elements"}], 
  "]"}]], "Input",ExpressionUUID->"960dbd31-7995-41a9-ad0f-cf38648c785d"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"7c522e9b-3137-4005-9f20-30005baf1128"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
2.6.4. The problem of evaluation. Use ReplacePart/Extract. HoldMap2\
\>", "Subsubsection",ExpressionUUID->"762a6d1e-23da-4e4e-8550-dce85b808bb4"],

Cell[TextData[{
 "Another alternative to define ff. Let us try using Extract and ReplacePart, \
imitating the examples given by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for ReplacePart in the Help. We define the function HoldMap2. It is \
similar to Map in spirit, but with three differences:\n\t- Assuming that the \
mapped function has a Hold attribute, HoldMap maps it on the expression and \
evaluates the elements, but not the head.\n\t- There is no choice of levels.\n\
\t- There is a third argument to give a wrapper that is placed after mapping \
and evaluation of the element, but before evalution of the head.\nAgain, it \
is not included in the package."
}], "Text",ExpressionUUID->"107178b4-f143-4c89-88b2-2e0895e1985e"],

Cell[BoxData[{
 RowBox[{"SetAttributes", "[", 
  RowBox[{"HoldMap2", ",", "HoldAll"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HoldMap2", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"expr", ":", 
     RowBox[{"_", "[", "___", "]"}]}], ",", 
    RowBox[{"g_", ":", "xHold"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"range", ",", "heldParts", ",", "newParts"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"range", "=", 
      RowBox[{"Range", "@", 
       RowBox[{"Length", "@", 
        RowBox[{"Unevaluated", "@", "expr"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"heldParts", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"Unevaluated", "@", "expr"}], ",", 
        RowBox[{"Thread", "@", 
         RowBox[{"{", "range", "}"}]}], ",", "HoldComplete"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newParts", "=", 
      RowBox[{"Apply", "[", 
       RowBox[{"f", ",", "heldParts", ",", 
        RowBox[{"{", "1", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ReplacePart", "[", 
      RowBox[{
       RowBox[{"Unevaluated", "@", 
        RowBox[{"g", "@", "expr"}]}], ",", "newParts", ",", 
       RowBox[{"Thread", "@", 
        RowBox[{"{", 
         RowBox[{"1", ",", "range"}], "}"}]}], ",", 
       RowBox[{"Thread", "@", 
        RowBox[{"{", "range", "}"}]}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]}], "Input",ExpressionUUID->"ff002beb-201f-412d-aaf0-d541f568f8de"],

Cell["\<\
Note that the key steps are: 1) the elements of the expression are each \
wrapped in HoldComplete and then stored as the list heldParts; 2) then each \
one is passed into the function f (without the HoldComplete) and f[element] \
is evaluated. The result is wrapped in xHold. The list of results is stored \
in newParts.\
\>", "Text",ExpressionUUID->"5f609a86-69a1-460a-8723-f4ef2a92da50"],

Cell["\<\
With HoldMap we have full control on the first level of the expression, but \
not below:\
\>", "Text",ExpressionUUID->"4a113361-19d4-475f-9b09-c9c90878457c"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"273b4733-3ba4-4b04-a08f-8641991577d0"],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"ff", ",", "HoldFirst"}], 
  "]"}]], "Input",ExpressionUUID->"6bedd49b-5098-41fe-b47e-3eb6115b4a63"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", "k_Integer", "]"}], ":=", 
  RowBox[{
  "k", "^", 
   "2"}]}]], "Input",ExpressionUUID->"5dbe0343-5fa4-4df9-963e-d8ab2a05367f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xACP`HoldMap2", "[", 
  RowBox[{"ff", ",", 
   RowBox[{"1", "+", "2", "+", "3", "+", "4"}], ",", "Identity"}], 
  "]"}]], "Input",ExpressionUUID->"3b2f88c6-c73d-4023-8e97-cc24767357b9"],

Cell[BoxData["30"], \
"Output",ExpressionUUID->"15c6aab9-18c1-4507-9ce1-59d9183ef6aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xACP`HoldMap2", "[", 
  RowBox[{"ff", ",", 
   RowBox[{"1", "+", "2", "+", "3", "+", "4"}]}], 
  "]"}]], "Input",ExpressionUUID->"ef73cc8a-ce93-46c4-b6db-e319e313fbd7"],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "4", "+", "9", "+", "16"}],
  DisplayForm]], \
"Output",ExpressionUUID->"6fc447ce-1a2d-49f7-9ee5-0e832badbddc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xACP`HoldMap2", "[", 
  RowBox[{"ff", ",", 
   RowBox[{"1", "+", "2", "+", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}], ")"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"fc1b185d-3047-491b-8840-c5d51ecc121c"],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "4", "+", 
   RowBox[{"ff", "[", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}], "]"}]}],
  DisplayForm]], \
"Output",ExpressionUUID->"7ef3409a-f2f0-4ee9-8d92-220ab52cf37b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xACP`HoldMap2", "[", 
   RowBox[{"ff", ",", 
    RowBox[{"Times", "[", 
     RowBox[{"1", ",", "2", ",", 
      RowBox[{"3", "+", "4"}]}], "]"}]}], "]"}], "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"c41ff345-f466-4894-83a4-91b7abc31b24"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"xHold", "[", 
    RowBox[{"Times", "[", 
     RowBox[{"1", ",", "4", ",", 
      RowBox[{"ff", "[", 
       RowBox[{"Plus", "[", 
        RowBox[{"3", ",", "4"}], "]"}], "]"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"06be63ff-c7dd-47f2-8df6-6e630376ce0f"]
}, Open  ]],

Cell["\<\
Now we can define a new function (which still has the HoldAll attribute):\
\>", "Text",ExpressionUUID->"0f4f955a-6c4d-4ee0-97ea-8429f856c24d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"k", ":", 
    RowBox[{"_", "[", "___", "]"}]}], "]"}], ":=", 
  RowBox[{"xACP`HoldMap2", "[", 
   RowBox[{"ff", ",", "k"}], 
   "]"}]}]], "Input",ExpressionUUID->"5a6374a7-b8c1-4edf-8c7a-37ceafd2dcfa"],

Cell["\<\
(We do not need to wrap head[elements] with Unevaluated because HoldMap2 has \
a HoldAll attribute.)\
\>", "Text",ExpressionUUID->"65ff571d-b657-441d-b1a8-9afcc745742d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"1", "+", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}], ")"}]}], 
  "]"}]], "Input",ExpressionUUID->"d4379e76-9ffc-4047-9bb9-9b2757f545fd"],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"4", "+", 
      RowBox[{"(", 
       TagBox[
        RowBox[{"9", "+", "16"}],
        DisplayForm], ")"}]}],
     DisplayForm], ")"}]}],
  DisplayForm]], \
"Output",ExpressionUUID->"36d64b9f-b2f6-4e27-9c10-c69188650c30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RuleDelayed", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], ",", 
   RowBox[{"3", "+", 
    RowBox[{"(", 
     RowBox[{"4", "+", "5"}], ")"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"e9990be5-7983-4cf9-aa53-622bcad08e82"],

Cell[BoxData[
 RowBox[{"6", "\[RuleDelayed]", 
  RowBox[{"3", "+", 
   RowBox[{"(", 
    RowBox[{"4", "+", "5"}], 
    ")"}]}]}]], \
"Output",ExpressionUUID->"da952173-9e0a-4b8d-b599-abcc0ba67391"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"RuleDelayed", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"b498db1a-1d6d-4d0b-8861-9a62777a158b"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"4", "+", "9"}],
       DisplayForm], ")"}]}],
    DisplayForm], "\[RuleDelayed]", 
   TagBox[
    RowBox[{"9", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"16", "+", "25"}],
       DisplayForm], ")"}]}],
    DisplayForm]}],
  DisplayForm]], \
"Output",ExpressionUUID->"94b0242b-e685-4a08-8732-09504fe3af1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "InputForm"}]], \
"Input",ExpressionUUID->"e70377dc-c29f-4280-ae0a-7a1137b299fd"],

Cell["xHold[xHold[1 + xHold[4 + 9]] :> xHold[9 + xHold[16 + 25]]]", \
"Output",ExpressionUUID->"57bfd98c-fba6-4ee3-9b8f-3f488269c6e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"Hold", "[", 
    RowBox[{"Set", "[", 
     RowBox[{
      RowBox[{"1", "+", "2"}], ",", 
      RowBox[{"3", "+", "4"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"ba8fec9d-a393-4e20-bc1a-fc375c379045"],

Cell[BoxData[
 TagBox[
  RowBox[{"Hold", "[", 
   TagBox[
    RowBox[{"Hold", "[", 
     TagBox[
      RowBox[{
       TagBox[
        RowBox[{"1", "+", "4"}],
        DisplayForm], "=", 
       TagBox[
        RowBox[{"9", "+", "16"}],
        DisplayForm]}],
      DisplayForm], "]"}],
    DisplayForm], "]"}],
  DisplayForm]], \
"Output",ExpressionUUID->"402afd23-0729-4f5c-b009-251c0a551fbb"]
}, Open  ]],

Cell["\<\
Again, if a pure function is required, then the third argument of Function \
must be used:\
\>", "Text",ExpressionUUID->"8a556df5-a95c-47e1-baba-04596ab36db3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"k", ":", 
    RowBox[{"_", "[", "___", "]"}]}], "]"}], ":=", 
  RowBox[{"xACP`HoldMap2", "[", 
   RowBox[{"ff", ",", "k"}], 
   "]"}]}]], "Input",ExpressionUUID->"ab09e5d2-4037-49d3-817c-eaf50352227f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"1", "+", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}], ")"}]}], 
  "]"}]], "Input",ExpressionUUID->"3822b4bf-938e-48a8-a8c2-d7a2e1958291"],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"4", "+", 
      RowBox[{"(", 
       TagBox[
        RowBox[{"9", "+", "16"}],
        DisplayForm], ")"}]}],
     DisplayForm], ")"}]}],
  DisplayForm]], \
"Output",ExpressionUUID->"dd25af68-c06e-46b4-816f-f9d6d44d2b46"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"k", ":", 
    RowBox[{"_", "[", "___", "]"}]}], "]"}], ":=", 
  RowBox[{"xACP`HoldMap2", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ff", "[", "#", "]"}], "&"}], ",", "k"}], 
   "]"}]}]], "Input",ExpressionUUID->"8435f43d-e84c-45c5-a78b-2d2966b10d02"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"1", "+", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}], ")"}]}], 
  "]"}]], "Input",ExpressionUUID->"ef487b25-634f-435b-9e36-5657a7f5d0ab"],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "81"}],
  DisplayForm]], \
"Output",ExpressionUUID->"fe727a48-702d-48d8-9302-d33985e2d796"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"k", ":", 
    RowBox[{"_", "[", "___", "]"}]}], "]"}], ":=", 
  RowBox[{"xACP`HoldMap2", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "kk", "}"}], ",", 
      RowBox[{"ff", "[", "kk", "]"}], ",", 
      RowBox[{"{", "HoldAll", "}"}]}], "]"}], ",", "k"}], 
   "]"}]}]], "Input",ExpressionUUID->"42d3ecbf-beb5-4455-aa89-f279fd877b4a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"1", "+", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"(", 
      RowBox[{"3", "+", "4"}], ")"}]}], ")"}]}], 
  "]"}]], "Input",ExpressionUUID->"b22a48c1-b4f2-41c4-a4cf-b978dae6aa06"],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", 
   RowBox[{"(", 
    TagBox[
     RowBox[{"4", "+", 
      RowBox[{"(", 
       TagBox[
        RowBox[{"9", "+", "16"}],
        DisplayForm], ")"}]}],
     DisplayForm], ")"}]}],
  DisplayForm]], \
"Output",ExpressionUUID->"992da789-2d8e-462c-aeee-3f83ca1550c2"]
}, Open  ]],

Cell["\<\
Again we would need a second function to eliminate the xHold's.\
\>", "Text",ExpressionUUID->"7db69809-a2a4-4edb-baee-8fd1425815b2"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"ff", ",", "k", ",", "kk"}], 
  "]"}]], "Input",ExpressionUUID->"a1d92308-90ba-428f-a06c-434507117c0a"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"7398ff34-7539-4c97-ada8-e7c4acefe1c8"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6.5. The problem of evaluation. Second option", \
"Subsubsection",ExpressionUUID->"58b82f46-794b-40f0-b294-8c1e5cb8c169"],

Cell["\<\
Start again: we would like to map a function over a expression without \
evaluating the expression or its elements, but allowing evaluation of the \
mapped function taking into account the properties of the elements, using \
ownvalues of the function of upvalues for the arguments. A simple example is \
this function, that must change any integer by its square\
\>", "Text",ExpressionUUID->"b40f7f1a-3066-4ac5-b665-6ca9703f2419"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"ca7d315b-9baf-4eb1-be2d-23dd534a8f1c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ff", ",", "HoldFirst"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ff", "[", "k_Integer", "]"}], ":=", 
  RowBox[{
  "k", "^", 
   "2"}]}]}], "Input",ExpressionUUID->"be9a9fe9-9d48-4d14-8234-46ee41412157"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", "5", 
  "]"}]], "Input",ExpressionUUID->"4bceb7c8-ee45-4d0a-8548-14ea33b76634"],

Cell[BoxData["25"], \
"Output",ExpressionUUID->"0c934868-e076-4d92-8a0e-382ee8b04ac6"]
}, Open  ]],

Cell["\<\
The HoldFirst attribute ensures that the function ff gets the original \
argument, not evaluated yet:\
\>", "Text",ExpressionUUID->"6b89f11d-2160-4051-a810-8e0143b24502"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"2", "+", "3"}], 
  "]"}]], "Input",ExpressionUUID->"69eec713-60e3-41f3-9278-b09520f78071"],

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"2", "+", "3"}], 
  "]"}]], "Output",ExpressionUUID->"ccbc6e43-c7bb-4fe3-a9be-ea507549e116"]
}, Open  ]],

Cell["\<\
The expression will be always assumed to be an expression with a head with a \
Hold attribute, or an expression which has been fed into the function ff \
using Unevaluated. In the former case the output will be wrapped in the same \
holding head; in the latter the expression will be returned and inmediately \
evaluated (unless we supply a holding function using a second argument to the \
function ff. The elements could be other expressions, not neccesarily the \
objects that we are seeking to change, and these other expressions need not \
be surrounded by a holding head, so that we must be careful not to evaluate \
them at any stage of the process.\
\>", "Text",ExpressionUUID->"aa43aed1-eb01-4492-92ab-bdea68723e07"],

Cell["\<\
1) A simple Map doesn't work. Here we should get 1+4+9, which is 14.\
\>", "Text",ExpressionUUID->"842138b9-9b04-4df6-b0b8-c9d332de1a9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"head_", "[", "elements___", "]"}], "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{"ff", ",", 
    RowBox[{"head", "[", "elements", "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"fc0255d4-834b-45c8-ab89-89b69a36b237"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"5997769d-c5b1-48ca-836b-d2ddb154f98c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"ff", "/@", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], ")"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"2", "+", "3"}],
        HoldForm], ",", 
       TagBox["5",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"1", "+", "5"}],
      HoldForm], ",", 
     TagBox["6",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"ff", "/@", "6"}],
    HoldForm], ",", 
   TagBox["6",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"f161cf64-b681-4d4f-87c6-92fe951376cc"]
}, Open  ]],

Cell["\<\
We see that the expression is evaluated before mapping the function (Map \
doesn't have a Hold attribute). We prevent this by using Unevaluated:\
\>", "Text",ExpressionUUID->"e54b20da-5c24-4d88-b7b3-483cca7158a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"head_", "[", "elements___", "]"}], "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{"ff", ",", 
    RowBox[{"Unevaluated", "[", 
     RowBox[{"head", "[", "elements", "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"3eca3103-43a7-4c7f-9a4c-82f5368dfeb0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"2e21fba0-20a9-4ed2-aa7b-87065f87e50e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"ff", "/@", 
     RowBox[{"Unevaluated", "[", 
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"ff", "/@", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], ")"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"ff", "[", "1", "]"}], "+", 
     RowBox[{"ff", "[", 
      RowBox[{"2", "+", "3"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", "1", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["1", "2"],
      HoldForm], ",", 
     TagBox["1",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", 
       RowBox[{"2", "+", "3"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "/@", 
       RowBox[{"Unevaluated", "[", 
        RowBox[{"2", "+", "3"}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "/@", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"ff", "[", "2", "]"}], "+", 
       RowBox[{"ff", "[", "3", "]"}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", "2", "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["2", "2"],
        HoldForm], ",", 
       TagBox["4",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", "3", "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["3", "2"],
        HoldForm], ",", 
       TagBox["9",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"4", "+", "9"}],
      HoldForm], ",", 
     TagBox["13",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"1", "+", "13"}],
    HoldForm], ",", 
   TagBox["14",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"83eb7deb-76fc-4914-bf2f-746a9cad8915"]
}, Open  ]],

Cell["\<\
2) Now it works. However, if we use a pure function instead of a simple head, \
recursion doesn't work:\
\>", "Text",ExpressionUUID->"3f14359c-9f1b-4a1a-a18a-a4b09e18bf6e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"head_", "[", "elements___", "]"}], "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ff", "[", "#", "]"}], "&"}], ",", 
    RowBox[{"Unevaluated", "[", 
     RowBox[{"head", "[", "elements", "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"745e6562-99ad-4bfb-8e1b-d17a94586ed3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"be3fa651-303e-4d5c-8771-274df6dc9e51"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "/@", 
     RowBox[{"Unevaluated", "[", 
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "/@", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], ")"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "1", "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", 
      RowBox[{"2", "+", "3"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "1", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "1", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["1", "2"],
      HoldForm], ",", 
     TagBox["1",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"2", "+", "3"}],
        HoldForm], ",", 
       TagBox["5",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "5", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "5", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["5", "2"],
      HoldForm], ",", 
     TagBox["25",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"1", "+", "25"}],
    HoldForm], ",", 
   TagBox["26",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"f0927d31-d62b-4596-9a02-ed6c56e31e5f"]
}, Open  ]],

Cell["\<\
It works only partially because even though ff has attribute HoldFirst we \
have that these two construction are very different:\
\>", "Text",ExpressionUUID->"e320d8c8-5d48-45f4-89a6-0d6fd68f3dcf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"2", "+", "3"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"2cd96fd0-e297-403c-a707-900ea88f5976"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{"2", "+", "3"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "/@", 
     RowBox[{"Unevaluated", "[", 
      RowBox[{"2", "+", "3"}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "/@", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "2", "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "3", "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["2", "2"],
      HoldForm], ",", 
     TagBox["4",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "3", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "3", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["3", "2"],
      HoldForm], ",", 
     TagBox["9",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"4", "+", "9"}],
    HoldForm], ",", 
   TagBox["13",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"c8b9bbec-3663-4ac4-8c81-9a43c3aabeb5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ff", "[", "#", "]"}], "&"}], ")"}], "[", 
   RowBox[{"2", "+", "3"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"fc324afe-9a3e-439f-8f7a-d524fbed617e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"2", "+", "3"}],
      HoldForm], ",", 
     TagBox["5",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "5", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"ff", "[", "5", "]"}],
    HoldForm], ",", 
   TagBox[
    SuperscriptBox["5", "2"],
    HoldForm], ",", 
   TagBox["25",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"c74114a9-81d0-4be0-8598-2535cc5c0193"]
}, Open  ]],

Cell["\<\
A possible solution is using a third argument of pure functions. Note the \
differences between the previous line and\
\>", "Text",ExpressionUUID->"bc5638d8-a389-4edc-9b43-6893efd06b42"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "k", "}"}], ",", 
     RowBox[{"ff", "[", "k", "]"}]}], "]"}], "[", 
   RowBox[{"2", "+", "3"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"8fe2098a-5107-417c-af52-6296ac09a192"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"2", "+", "3"}],
      HoldForm], ",", 
     TagBox["5",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "k", "}"}], ",", 
       RowBox[{"ff", "[", "k", "]"}]}], "]"}], "[", "5", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"ff", "[", "5", "]"}],
    HoldForm], ",", 
   TagBox[
    SuperscriptBox["5", "2"],
    HoldForm], ",", 
   TagBox["25",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"b6792326-fb65-4cd8-b065-f2443b9f4560"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "k", "}"}], ",", 
     RowBox[{"ff", "[", "k", "]"}], ",", 
     RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
   RowBox[{"2", "+", "3"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"e44c734d-9ddb-42ff-af4b-6231598e93e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "k", "}"}], ",", 
       RowBox[{"ff", "[", "k", "]"}], ",", 
       RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
     RowBox[{"2", "+", "3"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{"2", "+", "3"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "/@", 
     RowBox[{"Unevaluated", "[", 
      RowBox[{"2", "+", "3"}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "/@", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "2", "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "3", "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["2", "2"],
      HoldForm], ",", 
     TagBox["4",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ff", "[", "#1", "]"}], "&"}], ")"}], "[", "3", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "3", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["3", "2"],
      HoldForm], ",", 
     TagBox["9",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"4", "+", "9"}],
    HoldForm], ",", 
   TagBox["13",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"dba703de-019b-4db8-b62b-f8695dd47179"]
}, Open  ]],

Cell["Therefore we try:", \
"Text",ExpressionUUID->"3c59beac-185e-4be2-beaa-ce623176f734"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"head_", "[", "elements___", "]"}], "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "k", "}"}], ",", 
      RowBox[{"ff", "[", "k", "]"}], ",", 
      RowBox[{"{", "HoldAll", "}"}]}], "]"}], ",", 
    RowBox[{"Unevaluated", "[", 
     RowBox[{"head", "[", "elements", "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"ef442cf2-d319-4d7e-8919-1c03fd22ea9c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"2", "+", "3"}], ")"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"ebeb81c0-34ae-4cf9-af68-af3428c85dec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "k", "}"}], ",", 
       RowBox[{"ff", "[", "k", "]"}], ",", 
       RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
     RowBox[{"Unevaluated", "[", 
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "k", "}"}], ",", 
       RowBox[{"ff", "[", "k", "]"}], ",", 
       RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], ")"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "k", "}"}], ",", 
        RowBox[{"ff", "[", "k", "]"}], ",", 
        RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}], "+", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "k", "}"}], ",", 
        RowBox[{"ff", "[", "k", "]"}], ",", 
        RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
      RowBox[{"2", "+", "3"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "1", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["1", "2"],
      HoldForm], ",", 
     TagBox["1",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
       RowBox[{"2", "+", "3"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", 
       RowBox[{"2", "+", "3"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
       RowBox[{"Unevaluated", "[", 
        RowBox[{"2", "+", "3"}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", "k", "}"}], ",", 
          RowBox[{"ff", "[", "k", "]"}], ",", 
          RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}], "+", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", "k", "}"}], ",", 
          RowBox[{"ff", "[", "k", "]"}], ",", 
          RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ff", "[", "2", "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["2", "2"],
        HoldForm], ",", 
       TagBox["4",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ff", "[", "3", "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["3", "2"],
        HoldForm], ",", 
       TagBox["9",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"4", "+", "9"}],
      HoldForm], ",", 
     TagBox["13",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"1", "+", "13"}],
    HoldForm], ",", 
   TagBox["14",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"c5e465ec-2d63-49a3-a0f3-73aa7b5fa9ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"1", "+", "2", "+", "3"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"40b9f87a-5434-4ffb-844f-1eee4fa00f51"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{"1", "+", "2", "+", "3"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "k", "}"}], ",", 
       RowBox[{"ff", "[", "k", "]"}], ",", 
       RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
     RowBox[{"Unevaluated", "[", 
      RowBox[{"1", "+", "2", "+", "3"}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "k", "}"}], ",", 
       RowBox[{"ff", "[", "k", "]"}], ",", 
       RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2", "+", "3"}], ")"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "k", "}"}], ",", 
        RowBox[{"ff", "[", "k", "]"}], ",", 
        RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}], "+", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "k", "}"}], ",", 
        RowBox[{"ff", "[", "k", "]"}], ",", 
        RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}], "+", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "k", "}"}], ",", 
        RowBox[{"ff", "[", "k", "]"}], ",", 
        RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "1", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["1", "2"],
      HoldForm], ",", 
     TagBox["1",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["2", "2"],
      HoldForm], ",", 
     TagBox["4",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", "3", "]"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["3", "2"],
      HoldForm], ",", 
     TagBox["9",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"1", "+", "4", "+", "9"}],
    HoldForm], ",", 
   TagBox["14",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"44d95f3b-25a1-42d2-8de3-99552c920db3"]
}, Open  ]],

Cell["\<\
3) We have an additional problem with the heads with a Hold attribute:\
\>", "Text",ExpressionUUID->"310cf4bd-6758-43d5-af55-7a4fe8e943a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{"1", "+", "2"}], ",", 
    RowBox[{"3", "+", "4"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"692449de-e9e3-4c77-b745-b69f3d88ba43"],

Cell[BoxData[
 RowBox[{"5", "\[Rule]", 
  "25"}]], "Output",ExpressionUUID->"dc82f19b-c828-4640-a04a-8cd6a7a0bc35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"RuleDelayed", "[", 
   RowBox[{
    RowBox[{"1", "+", "2"}], ",", 
    RowBox[{"3", "+", "4"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"ae72ec7d-5114-4737-9e0d-4fd43a1e889f"],

Cell[BoxData[
 RowBox[{"5", "\[RuleDelayed]", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "k", "}"}], ",", 
     RowBox[{"ff", "[", "k", "]"}], ",", 
     RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
   RowBox[{"3", "+", "4"}], 
   "]"}]}]], "Output",ExpressionUUID->"173244b3-6ac7-4fc0-915e-f4c66d86479b"]
}, Open  ]],

Cell["We solve it by temporarily replacing that head:", \
"Text",ExpressionUUID->"6915dd32-ce0d-40f0-bce1-33cb868b9978"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"head_", "[", "elements___", "]"}], "]"}], ":=", 
  RowBox[{"Apply", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"xHold", "[", 
      RowBox[{"head", "[", "##", "]"}], "]"}], "&"}], ",", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "k", "}"}], ",", 
        RowBox[{"ff", "[", "k", "]"}], ",", 
        RowBox[{"{", "HoldAll", "}"}]}], "]"}], ",", 
      RowBox[{"HoldComplete", "[", "elements", "]"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"fc5b22ef-d474-4f06-ba51-441e7eceee83"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"RuleDelayed", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"58a7411b-966a-4a20-9f4c-6dd19a09fce5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
      RowBox[{"3", "+", 
       RowBox[{"(", 
        RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"RuleDelayed", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "@@", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "k", "}"}], ",", 
        RowBox[{"ff", "[", "k", "]"}], ",", 
        RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
      RowBox[{"HoldComplete", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", "3"}], ")"}]}], ",", 
        RowBox[{"3", "+", 
         RowBox[{"(", 
          RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}]}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
       RowBox[{"HoldComplete", "[", 
        RowBox[{
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", "3"}], ")"}]}], ",", 
         RowBox[{"3", "+", 
          RowBox[{"(", 
           RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"HoldComplete", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", "3"}], ")"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"3", "+", 
          RowBox[{"(", 
           RowBox[{"4", "+", "5"}], ")"}]}], "]"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"RuleDelayed", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "@@", 
     RowBox[{"HoldComplete", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", "k", "}"}], ",", 
          RowBox[{"ff", "[", "k", "]"}], ",", 
          RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", "3"}], ")"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", "k", "}"}], ",", 
          RowBox[{"ff", "[", "k", "]"}], ",", 
          RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
        RowBox[{"3", "+", 
         RowBox[{"(", 
          RowBox[{"4", "+", "5"}], ")"}]}], "]"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"RuleDelayed", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
       RowBox[{"1", "+", 
        RowBox[{"(", 
         RowBox[{"2", "+", "3"}], ")"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
       RowBox[{"3", "+", 
        RowBox[{"(", 
         RowBox[{"4", "+", "5"}], ")"}]}], "]"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
       RowBox[{"1", "+", 
        RowBox[{"(", 
         RowBox[{"2", "+", "3"}], ")"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", 
       RowBox[{"1", "+", 
        RowBox[{"(", 
         RowBox[{"2", "+", "3"}], ")"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", "k", "}"}], ",", 
          RowBox[{"ff", "[", "k", "]"}], ",", 
          RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
        RowBox[{"HoldComplete", "[", 
         RowBox[{"1", ",", 
          RowBox[{"2", "+", "3"}]}], "]"}]}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
         RowBox[{"HoldComplete", "[", 
          RowBox[{"1", ",", 
           RowBox[{"2", "+", "3"}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"HoldComplete", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}], ",", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
           RowBox[{"2", "+", "3"}], "]"}]}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"HoldComplete", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"{", "k", "}"}], ",", 
            RowBox[{"ff", "[", "k", "]"}], ",", 
            RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}], ",", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"{", "k", "}"}], ",", 
            RowBox[{"ff", "[", "k", "]"}], ",", 
            RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
          RowBox[{"2", "+", "3"}], "]"}]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}], ",", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"2", "+", "3"}], "]"}]}], "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "1", "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ff", "[", "1", "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["1", "2"],
        HoldForm], ",", 
       TagBox["1",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"2", "+", "3"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ff", "[", 
         RowBox[{"2", "+", "3"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"{", "k", "}"}], ",", 
            RowBox[{"ff", "[", "k", "]"}], ",", 
            RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
          RowBox[{"HoldComplete", "[", 
           RowBox[{"2", ",", "3"}], "]"}]}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
           RowBox[{"HoldComplete", "[", 
            RowBox[{"2", ",", "3"}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"HoldComplete", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}], ",", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}]}], 
           "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{"HoldComplete", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", "k", "}"}], ",", 
              RowBox[{"ff", "[", "k", "]"}], ",", 
              RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}], ",", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", "k", "}"}], ",", 
              RowBox[{"ff", "[", "k", "]"}], ",", 
              RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}]}], 
          "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}], ",", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}]}], "]"}],
        
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "2", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"ff", "[", "2", "]"}],
          HoldForm], ",", 
         TagBox[
          SuperscriptBox["2", "2"],
          HoldForm], ",", 
         TagBox["4",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"ff", "[", "3", "]"}],
          HoldForm], ",", 
         TagBox[
          SuperscriptBox["3", "2"],
          HoldForm], ",", 
         TagBox["9",
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{"4", ",", "9"}], "]"}],
        HoldForm], ",", 
       TagBox[
        TagBox[
         RowBox[{"4", "+", "9"}],
         DisplayForm],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{"1", ",", 
        TagBox[
         RowBox[{"4", "+", "9"}],
         DisplayForm]}], "]"}],
      HoldForm], ",", 
     TagBox[
      TagBox[
       RowBox[{"1", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"4", "+", "9"}],
          DisplayForm], ")"}]}],
       DisplayForm],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "k", "}"}], ",", 
         RowBox[{"ff", "[", "k", "]"}], ",", 
         RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
       RowBox[{"3", "+", 
        RowBox[{"(", 
         RowBox[{"4", "+", "5"}], ")"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"ff", "[", 
       RowBox[{"3", "+", 
        RowBox[{"(", 
         RowBox[{"4", "+", "5"}], ")"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", "k", "}"}], ",", 
          RowBox[{"ff", "[", "k", "]"}], ",", 
          RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
        RowBox[{"HoldComplete", "[", 
         RowBox[{"3", ",", 
          RowBox[{"4", "+", "5"}]}], "]"}]}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
         RowBox[{"HoldComplete", "[", 
          RowBox[{"3", ",", 
           RowBox[{"4", "+", "5"}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"HoldComplete", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}], ",", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
           RowBox[{"4", "+", "5"}], "]"}]}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"HoldComplete", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"{", "k", "}"}], ",", 
            RowBox[{"ff", "[", "k", "]"}], ",", 
            RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}], ",", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"{", "k", "}"}], ",", 
            RowBox[{"ff", "[", "k", "]"}], ",", 
            RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
          RowBox[{"4", "+", "5"}], "]"}]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}], ",", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"4", "+", "5"}], "]"}]}], "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "3", "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ff", "[", "3", "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["3", "2"],
        HoldForm], ",", 
       TagBox["9",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "k", "}"}], ",", 
           RowBox[{"ff", "[", "k", "]"}], ",", 
           RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
         RowBox[{"4", "+", "5"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"ff", "[", 
         RowBox[{"4", "+", "5"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"{", "k", "}"}], ",", 
            RowBox[{"ff", "[", "k", "]"}], ",", 
            RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
          RowBox[{"HoldComplete", "[", 
           RowBox[{"4", ",", "5"}], "]"}]}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "/@", 
           RowBox[{"HoldComplete", "[", 
            RowBox[{"4", ",", "5"}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"HoldComplete", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "4", "]"}], ",", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", "k", "}"}], ",", 
               RowBox[{"ff", "[", "k", "]"}], ",", 
               RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "5", "]"}]}], 
           "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{"HoldComplete", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", "k", "}"}], ",", 
              RowBox[{"ff", "[", "k", "]"}], ",", 
              RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "4", "]"}], ",", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", "k", "}"}], ",", 
              RowBox[{"ff", "[", "k", "]"}], ",", 
              RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "5", "]"}]}], 
          "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "4", "]"}], ",", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "5", "]"}]}], "]"}],
        
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "4", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"ff", "[", "4", "]"}],
          HoldForm], ",", 
         TagBox[
          SuperscriptBox["4", "2"],
          HoldForm], ",", 
         TagBox["16",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "k", "}"}], ",", 
             RowBox[{"ff", "[", "k", "]"}], ",", 
             RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", "5", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"ff", "[", "5", "]"}],
          HoldForm], ",", 
         TagBox[
          SuperscriptBox["5", "2"],
          HoldForm], ",", 
         TagBox["25",
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{"16", ",", "25"}], "]"}],
        HoldForm], ",", 
       TagBox[
        TagBox[
         RowBox[{"16", "+", "25"}],
         DisplayForm],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{"9", ",", 
        TagBox[
         RowBox[{"16", "+", "25"}],
         DisplayForm]}], "]"}],
      HoldForm], ",", 
     TagBox[
      TagBox[
       RowBox[{"9", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"16", "+", "25"}],
          DisplayForm], ")"}]}],
       DisplayForm],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"RuleDelayed", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "[", 
     RowBox[{
      TagBox[
       RowBox[{"1", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"4", "+", "9"}],
          DisplayForm], ")"}]}],
       DisplayForm], ",", 
      TagBox[
       RowBox[{"9", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"16", "+", "25"}],
          DisplayForm], ")"}]}],
       DisplayForm]}], "]"}],
    HoldForm], ",", 
   TagBox[
    TagBox[
     RowBox[{
      TagBox[
       RowBox[{"1", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"4", "+", "9"}],
          DisplayForm], ")"}]}],
       DisplayForm], "\[RuleDelayed]", 
      TagBox[
       RowBox[{"9", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"16", "+", "25"}],
          DisplayForm], ")"}]}],
       DisplayForm]}],
     DisplayForm],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"b7db47cc-2047-45a1-b9bc-5e94104abd8b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Flatten", "[", "%", "]"}], 
  "]"}]], "Input",ExpressionUUID->"95bc3d35-2164-4899-9f34-2b9f657ae1c3"],

Cell[BoxData["68"], \
"Output",ExpressionUUID->"9f041f13-3fdd-47c0-bca3-af8af42ec63e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"RuleDelayed", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"dec0eaf7-bfd9-4895-89c8-e8a83af3ce1d"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"4", "+", "9"}],
       DisplayForm], ")"}]}],
    DisplayForm], "\[RuleDelayed]", 
   TagBox[
    RowBox[{"9", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"16", "+", "25"}],
       DisplayForm], ")"}]}],
    DisplayForm]}],
  DisplayForm]], \
"Output",ExpressionUUID->"9f2b4e83-93ba-481d-b700-bcefe4191b78"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//.", 
  RowBox[{
   RowBox[{"xHold", "[", "k_", "]"}], "\[Rule]", 
   "k"}]}]], "Input",ExpressionUUID->"d84000e1-e969-4e50-ba74-de3b464d725c"],

Cell[BoxData[
 RowBox[{"14", "\[RuleDelayed]", 
  RowBox[{"9", "+", 
   RowBox[{"(", 
    RowBox[{"16", "+", "25"}], 
    ")"}]}]}]], \
"Output",ExpressionUUID->"f0783a46-7277-4597-93dd-c7f74dafa25f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"54257926-9dd3-46ac-b511-0f3937b061bc"],

Cell[BoxData[
 TagBox[
  RowBox[{"Hold", "[", 
   RowBox[{
    TagBox[
     RowBox[{"1", "+", 
      RowBox[{"(", 
       TagBox[
        RowBox[{"4", "+", "9"}],
        DisplayForm], ")"}]}],
     DisplayForm], ",", 
    TagBox[
     RowBox[{"9", "+", 
      RowBox[{"(", 
       TagBox[
        RowBox[{"16", "+", "25"}],
        DisplayForm], ")"}]}],
     DisplayForm]}], "]"}],
  DisplayForm]], \
"Output",ExpressionUUID->"0ecd1de0-2319-4d70-ae68-7bed9ff98d01"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//.", 
  RowBox[{
   RowBox[{"xHold", "[", "k_", "]"}], "\[Rule]", 
   "k"}]}]], "Input",ExpressionUUID->"ed1e5b65-3c03-4502-b369-b1b56d15e64e"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"4", "+", "9"}], ")"}]}], ",", 
   RowBox[{"9", "+", 
    RowBox[{"(", 
     RowBox[{"16", "+", "25"}], ")"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"6dbd0e4a-b691-4e39-b846-f35ee79eb22b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"Set", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"d166d438-603d-465a-863e-6e30f6f2cdaa"],

Cell[BoxData[
 TagBox[
  RowBox[{"Hold", "[", 
   TagBox[
    RowBox[{
     TagBox[
      RowBox[{"1", "+", 
       RowBox[{"(", 
        TagBox[
         RowBox[{"4", "+", "9"}],
         DisplayForm], ")"}]}],
      DisplayForm], "=", 
     TagBox[
      RowBox[{"9", "+", 
       RowBox[{"(", 
        TagBox[
         RowBox[{"16", "+", "25"}],
         DisplayForm], ")"}]}],
      DisplayForm]}],
    DisplayForm], "]"}],
  DisplayForm]], \
"Output",ExpressionUUID->"6930ecbe-264a-4781-b243-a710edd88d99"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"Hold", "[", 
    RowBox[{"Set", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"(", 
        RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"edb722de-50e8-4a04-823c-5fc4e823a431"],

Cell[BoxData[
 TagBox[
  RowBox[{"Hold", "[", 
   TagBox[
    RowBox[{"Hold", "[", 
     TagBox[
      RowBox[{
       TagBox[
        RowBox[{"1", "+", 
         RowBox[{"(", 
          TagBox[
           RowBox[{"4", "+", "9"}],
           DisplayForm], ")"}]}],
        DisplayForm], "=", 
       TagBox[
        RowBox[{"9", "+", 
         RowBox[{"(", 
          TagBox[
           RowBox[{"16", "+", "25"}],
           DisplayForm], ")"}]}],
        DisplayForm]}],
      DisplayForm], "]"}],
    DisplayForm], "]"}],
  DisplayForm]], \
"Output",ExpressionUUID->"edfa35fe-8549-49b1-8b52-130e3609e110"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//.", 
  RowBox[{
   RowBox[{"xHold", "[", "k_", "]"}], "\[Rule]", 
   "k"}]}]], "Input",ExpressionUUID->"c660d8e0-5d4a-4b61-afdb-287c6c2c8309"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "9"}], ")"}]}], "=", 
    RowBox[{"9", "+", 
     RowBox[{"(", 
      RowBox[{"16", "+", "25"}], ")"}]}]}], "]"}], 
  "]"}]], "Output",ExpressionUUID->"cb519ca2-40a7-4dde-b865-874eca8c4360"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"(", 
      RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"bb54ee63-a719-455e-81f0-7b52bcbf04d6"],

Cell[BoxData[
 TagBox[
  RowBox[{"Module", "[", 
   RowBox[{
    TagBox[
     RowBox[{"{", "}"}],
     DisplayForm], ",", 
    TagBox[
     RowBox[{"9", "+", 
      RowBox[{"(", 
       TagBox[
        RowBox[{"16", "+", "25"}],
        DisplayForm], ")"}]}],
     DisplayForm]}], "]"}],
  DisplayForm]], \
"Output",ExpressionUUID->"08fede17-1901-4a96-920c-5ddfc09bf821"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"ff", ",", "k", ",", "head", ",", "elements"}], 
  "]"}]], "Input",ExpressionUUID->"1312000c-1a11-4691-bb08-c440611ed416"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"0680c58b-c282-4eb3-b5e0-2cd5506ae47f"],

Cell["This looks better, but it is possible to do it even simpler.", \
"Text",ExpressionUUID->"a45f6c76-6db2-4de2-97b9-4c61cb74cce7"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6.6. The problem of evaluation. Second option. Simpler", \
"Subsubsection",ExpressionUUID->"dd4d869d-5c25-4529-a956-50167eee5d3e"],

Cell["\<\
Another idea, even simpler: everything is always wrapped in xHold. Note that \
ff does not need a holding attribute!\
\>", "Text",ExpressionUUID->"08292d4c-62a9-46f2-b500-e1446dbb7865"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"3b3ebf53-f02c-4d47-b999-87bd3c7265ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"xHold", "[", "k_Integer", "]"}], "]"}], ":=", 
  RowBox[{
  "k", "^", 
   "2"}]}]], "Input",ExpressionUUID->"94c63ce7-611a-4dad-9edb-f1ffba06f528"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"xHold", "[", 
    RowBox[{"head_", "[", "elements___", "]"}], "]"}], "]"}], ":=", 
  RowBox[{"Apply", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"xHold", "[", 
      RowBox[{"head", "[", "##", "]"}], "]"}], "&"}], ",", 
    RowBox[{"ff", "/@", 
     RowBox[{"xHold", "/@", 
      RowBox[{"xHold", "[", "elements", "]"}]}]}]}], 
   "]"}]}]], "Input",ExpressionUUID->"9663d945-79b3-4341-98a0-804410c57bd1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"xHold", "[", 
    RowBox[{"RuleDelayed", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"(", 
        RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"44be1569-61b5-455c-abbf-22d1da011c83"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     TagBox[
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"(", 
         RowBox[{"2", "+", "3"}], ")"}]}], "\[RuleDelayed]", 
       RowBox[{"3", "+", 
        RowBox[{"(", 
         RowBox[{"4", "+", "5"}], ")"}]}]}],
      DisplayForm], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"RuleDelayed", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "@@", 
     RowBox[{"ff", "/@", 
      RowBox[{"xHold", "/@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", "3"}], ")"}]}], ",", 
         RowBox[{"3", "+", 
          RowBox[{"(", 
           RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}]}]}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"xHold", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           RowBox[{"1", "+", 
            RowBox[{"(", 
             RowBox[{"2", "+", "3"}], ")"}]}], ",", 
           RowBox[{"3", "+", 
            RowBox[{"(", 
             RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"xHold", "[", 
         RowBox[{
          TagBox[
           RowBox[{"1", "+", 
            RowBox[{"(", 
             RowBox[{"2", "+", "3"}], ")"}]}],
           DisplayForm], ",", 
          TagBox[
           RowBox[{"3", "+", 
            RowBox[{"(", 
             RowBox[{"4", "+", "5"}], ")"}]}],
           DisplayForm]}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"ff", "/@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         TagBox[
          RowBox[{"1", "+", 
           RowBox[{"(", 
            RowBox[{"2", "+", "3"}], ")"}]}],
          DisplayForm], ",", 
         TagBox[
          RowBox[{"3", "+", 
           RowBox[{"(", 
            RowBox[{"4", "+", "5"}], ")"}]}],
          DisplayForm]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"xHold", "[", 
       RowBox[{
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"1", "+", 
           RowBox[{"(", 
            RowBox[{"2", "+", "3"}], ")"}]}],
          DisplayForm], "]"}], ",", 
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"3", "+", 
           RowBox[{"(", 
            RowBox[{"4", "+", "5"}], ")"}]}],
          DisplayForm], "]"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"RuleDelayed", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "@@", 
     RowBox[{"xHold", "[", 
      RowBox[{
       RowBox[{"ff", "[", 
        TagBox[
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", "3"}], ")"}]}],
         DisplayForm], "]"}], ",", 
       RowBox[{"ff", "[", 
        TagBox[
         RowBox[{"3", "+", 
          RowBox[{"(", 
           RowBox[{"4", "+", "5"}], ")"}]}],
         DisplayForm], "]"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"RuleDelayed", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "[", 
     RowBox[{
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", "3"}], ")"}]}],
        DisplayForm], "]"}], ",", 
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"3", "+", 
         RowBox[{"(", 
          RowBox[{"4", "+", "5"}], ")"}]}],
        DisplayForm], "]"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", "3"}], ")"}]}],
        DisplayForm], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"ff", "/@", 
        RowBox[{"xHold", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{"1", ",", 
           RowBox[{"2", "+", "3"}]}], "]"}]}]}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"xHold", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{"1", ",", 
             RowBox[{"2", "+", "3"}]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"xHold", "[", 
           RowBox[{
            TagBox["\<\"1\"\>",
             DisplayForm], ",", 
            TagBox[
             RowBox[{"2", "+", "3"}],
             DisplayForm]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"ff", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           TagBox["\<\"1\"\>",
            DisplayForm], ",", 
           TagBox[
            RowBox[{"2", "+", "3"}],
            DisplayForm]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"xHold", "[", 
         RowBox[{
          RowBox[{"ff", "[", 
           TagBox["\<\"1\"\>",
            DisplayForm], "]"}], ",", 
          RowBox[{"ff", "[", 
           TagBox[
            RowBox[{"2", "+", "3"}],
            DisplayForm], "]"}]}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         RowBox[{"ff", "[", 
          TagBox["\<\"1\"\>",
           DisplayForm], "]"}], ",", 
         RowBox[{"ff", "[", 
          TagBox[
           RowBox[{"2", "+", "3"}],
           DisplayForm], "]"}]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{
        RowBox[{"ff", "[", 
         TagBox["\<\"1\"\>",
          DisplayForm], "]"}], ",", 
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"2", "+", "3"}],
          DisplayForm], "]"}]}], "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", 
         TagBox["\<\"1\"\>",
          DisplayForm], "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["1", "2"],
        HoldForm], ",", 
       TagBox["1",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"2", "+", "3"}],
          DisplayForm], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{"ff", "/@", 
          RowBox[{"xHold", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{"2", ",", "3"}], "]"}]}]}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xHold", "/@", 
             RowBox[{"xHold", "[", 
              RowBox[{"2", ",", "3"}], "]"}]}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"xHold", "[", 
             RowBox[{
              TagBox["\<\"2\"\>",
               DisplayForm], ",", 
              TagBox["\<\"3\"\>",
               DisplayForm]}], "]"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"ff", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{
             TagBox["\<\"2\"\>",
              DisplayForm], ",", 
             TagBox["\<\"3\"\>",
              DisplayForm]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"xHold", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             TagBox["\<\"2\"\>",
              DisplayForm], "]"}], ",", 
            RowBox[{"ff", "[", 
             TagBox["\<\"3\"\>",
              DisplayForm], "]"}]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            TagBox["\<\"2\"\>",
             DisplayForm], "]"}], ",", 
           RowBox[{"ff", "[", 
            TagBox["\<\"3\"\>",
             DisplayForm], "]"}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{
          RowBox[{"ff", "[", 
           TagBox["\<\"2\"\>",
            DisplayForm], "]"}], ",", 
          RowBox[{"ff", "[", 
           TagBox["\<\"3\"\>",
            DisplayForm], "]"}]}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"ff", "[", 
           TagBox["\<\"2\"\>",
            DisplayForm], "]"}],
          HoldForm], ",", 
         TagBox[
          SuperscriptBox["2", "2"],
          HoldForm], ",", 
         TagBox["4",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"ff", "[", 
           TagBox["\<\"3\"\>",
            DisplayForm], "]"}],
          HoldForm], ",", 
         TagBox[
          SuperscriptBox["3", "2"],
          HoldForm], ",", 
         TagBox["9",
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{"4", ",", "9"}], "]"}],
        HoldForm], ",", 
       TagBox[
        TagBox[
         RowBox[{"4", "+", "9"}],
         DisplayForm],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{"1", ",", 
        TagBox[
         RowBox[{"4", "+", "9"}],
         DisplayForm]}], "]"}],
      HoldForm], ",", 
     TagBox[
      TagBox[
       RowBox[{"1", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"4", "+", "9"}],
          DisplayForm], ")"}]}],
       DisplayForm],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"3", "+", 
         RowBox[{"(", 
          RowBox[{"4", "+", "5"}], ")"}]}],
        DisplayForm], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"ff", "/@", 
        RowBox[{"xHold", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{"3", ",", 
           RowBox[{"4", "+", "5"}]}], "]"}]}]}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"xHold", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{"3", ",", 
             RowBox[{"4", "+", "5"}]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"xHold", "[", 
           RowBox[{
            TagBox["\<\"3\"\>",
             DisplayForm], ",", 
            TagBox[
             RowBox[{"4", "+", "5"}],
             DisplayForm]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"ff", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           TagBox["\<\"3\"\>",
            DisplayForm], ",", 
           TagBox[
            RowBox[{"4", "+", "5"}],
            DisplayForm]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"xHold", "[", 
         RowBox[{
          RowBox[{"ff", "[", 
           TagBox["\<\"3\"\>",
            DisplayForm], "]"}], ",", 
          RowBox[{"ff", "[", 
           TagBox[
            RowBox[{"4", "+", "5"}],
            DisplayForm], "]"}]}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         RowBox[{"ff", "[", 
          TagBox["\<\"3\"\>",
           DisplayForm], "]"}], ",", 
         RowBox[{"ff", "[", 
          TagBox[
           RowBox[{"4", "+", "5"}],
           DisplayForm], "]"}]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{
        RowBox[{"ff", "[", 
         TagBox["\<\"3\"\>",
          DisplayForm], "]"}], ",", 
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"4", "+", "5"}],
          DisplayForm], "]"}]}], "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", 
         TagBox["\<\"3\"\>",
          DisplayForm], "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["3", "2"],
        HoldForm], ",", 
       TagBox["9",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"4", "+", "5"}],
          DisplayForm], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{"ff", "/@", 
          RowBox[{"xHold", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{"4", ",", "5"}], "]"}]}]}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xHold", "/@", 
             RowBox[{"xHold", "[", 
              RowBox[{"4", ",", "5"}], "]"}]}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"xHold", "[", 
             RowBox[{
              TagBox["\<\"4\"\>",
               DisplayForm], ",", 
              TagBox["\<\"5\"\>",
               DisplayForm]}], "]"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"ff", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{
             TagBox["\<\"4\"\>",
              DisplayForm], ",", 
             TagBox["\<\"5\"\>",
              DisplayForm]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"xHold", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             TagBox["\<\"4\"\>",
              DisplayForm], "]"}], ",", 
            RowBox[{"ff", "[", 
             TagBox["\<\"5\"\>",
              DisplayForm], "]"}]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            TagBox["\<\"4\"\>",
             DisplayForm], "]"}], ",", 
           RowBox[{"ff", "[", 
            TagBox["\<\"5\"\>",
             DisplayForm], "]"}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{
          RowBox[{"ff", "[", 
           TagBox["\<\"4\"\>",
            DisplayForm], "]"}], ",", 
          RowBox[{"ff", "[", 
           TagBox["\<\"5\"\>",
            DisplayForm], "]"}]}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"ff", "[", 
           TagBox["\<\"4\"\>",
            DisplayForm], "]"}],
          HoldForm], ",", 
         TagBox[
          SuperscriptBox["4", "2"],
          HoldForm], ",", 
         TagBox["16",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"ff", "[", 
           TagBox["\<\"5\"\>",
            DisplayForm], "]"}],
          HoldForm], ",", 
         TagBox[
          SuperscriptBox["5", "2"],
          HoldForm], ",", 
         TagBox["25",
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{"16", ",", "25"}], "]"}],
        HoldForm], ",", 
       TagBox[
        TagBox[
         RowBox[{"16", "+", "25"}],
         DisplayForm],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{"9", ",", 
        TagBox[
         RowBox[{"16", "+", "25"}],
         DisplayForm]}], "]"}],
      HoldForm], ",", 
     TagBox[
      TagBox[
       RowBox[{"9", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"16", "+", "25"}],
          DisplayForm], ")"}]}],
       DisplayForm],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"RuleDelayed", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "[", 
     RowBox[{
      TagBox[
       RowBox[{"1", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"4", "+", "9"}],
          DisplayForm], ")"}]}],
       DisplayForm], ",", 
      TagBox[
       RowBox[{"9", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"16", "+", "25"}],
          DisplayForm], ")"}]}],
       DisplayForm]}], "]"}],
    HoldForm], ",", 
   TagBox[
    TagBox[
     RowBox[{
      TagBox[
       RowBox[{"1", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"4", "+", "9"}],
          DisplayForm], ")"}]}],
       DisplayForm], "\[RuleDelayed]", 
      TagBox[
       RowBox[{"9", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"16", "+", "25"}],
          DisplayForm], ")"}]}],
       DisplayForm]}],
     DisplayForm],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"e15a2392-b191-45a6-8c75-bc22228389ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Flatten", "[", "%", "]"}], 
  "]"}]], "Input",ExpressionUUID->"cf0c0ee7-8ccf-4b6c-8936-32b643ca72b3"],

Cell[BoxData["68"], \
"Output",ExpressionUUID->"15b1174d-6c88-4ef6-a635-7e1660fa4366"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"xHold", "[", 
   RowBox[{"RuleDelayed", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"(", 
       RowBox[{"2", "+", "3"}], ")"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"(", 
       RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"5d4ef3ba-ce75-4375-90a2-5a4ea3eb613f"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"1", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"4", "+", "9"}],
       DisplayForm], ")"}]}],
    DisplayForm], "\[RuleDelayed]", 
   TagBox[
    RowBox[{"9", "+", 
     RowBox[{"(", 
      TagBox[
       RowBox[{"16", "+", "25"}],
       DisplayForm], ")"}]}],
    DisplayForm]}],
  DisplayForm]], \
"Output",ExpressionUUID->"0a2a24ad-2e71-4769-bd64-f35337214a15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//.", 
  RowBox[{
   RowBox[{"xHold", "[", "k_", "]"}], "\[Rule]", 
   "k"}]}]], "Input",ExpressionUUID->"ac2ebd69-6386-4ca3-abe6-950c52e6020d"],

Cell[BoxData[
 RowBox[{"14", "\[RuleDelayed]", 
  RowBox[{"9", "+", 
   RowBox[{"(", 
    RowBox[{"16", "+", "25"}], 
    ")"}]}]}]], \
"Output",ExpressionUUID->"16793deb-fcdb-49cb-9cc1-0125760af048"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"xHold", "[", 
   RowBox[{"Hold", "[", 
    RowBox[{"RuleDelayed", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", "3"}], ")"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"(", 
        RowBox[{"4", "+", "5"}], ")"}]}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"c8b8618f-1c38-40e1-8f0c-8045cde1611a"],

Cell[BoxData[
 TagBox[
  RowBox[{"Hold", "[", 
   TagBox[
    RowBox[{
     TagBox[
      RowBox[{"1", "+", 
       RowBox[{"(", 
        TagBox[
         RowBox[{"4", "+", "9"}],
         DisplayForm], ")"}]}],
      DisplayForm], "\[RuleDelayed]", 
     TagBox[
      RowBox[{"9", "+", 
       RowBox[{"(", 
        TagBox[
         RowBox[{"16", "+", "25"}],
         DisplayForm], ")"}]}],
      DisplayForm]}],
    DisplayForm], "]"}],
  DisplayForm]], \
"Output",ExpressionUUID->"dae9724e-b2d0-48d7-8ea5-50d2c419971f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//.", 
  RowBox[{
   RowBox[{"xHold", "[", "k_", "]"}], "\[Rule]", 
   "k"}]}]], "Input",ExpressionUUID->"66b3a1db-306f-4486-9eea-37004ca890d5"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"(", 
     RowBox[{"4", "+", "9"}], ")"}]}], "\[RuleDelayed]", 
   RowBox[{"9", "+", 
    RowBox[{"(", 
     RowBox[{"16", "+", "25"}], ")"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"2adc40e2-bd08-48a3-adcb-7be95dc68800"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"xHold", "[", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", "4"}]}], ")"}]}]}], "]"}], "]"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"aa9b2860-0ec2-44c4-ac9d-c1506fcc8bf0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     TagBox[
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"3", " ", "4"}]}], ")"}]}]}], "]"}],
      DisplayForm], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"Module", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "@@", 
     RowBox[{"ff", "/@", 
      RowBox[{"xHold", "/@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"3", " ", "4"}]}], ")"}]}]}], "]"}]}]}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"xHold", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"1", "+", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"3", " ", "4"}]}], ")"}]}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"xHold", "[", 
         RowBox[{
          TagBox[
           RowBox[{"{", "}"}],
           DisplayForm], ",", 
          TagBox[
           RowBox[{"1", "+", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"3", " ", "4"}]}], ")"}]}],
           DisplayForm]}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"ff", "/@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         TagBox[
          RowBox[{"{", "}"}],
          DisplayForm], ",", 
         TagBox[
          RowBox[{"1", "+", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"3", " ", "4"}]}], ")"}]}],
          DisplayForm]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"xHold", "[", 
       RowBox[{
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"{", "}"}],
          DisplayForm], "]"}], ",", 
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"1", "+", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"3", " ", "4"}]}], ")"}]}],
          DisplayForm], "]"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"Module", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "@@", 
     RowBox[{"xHold", "[", 
      RowBox[{
       RowBox[{"ff", "[", 
        TagBox[
         RowBox[{"{", "}"}],
         DisplayForm], "]"}], ",", 
       RowBox[{"ff", "[", 
        TagBox[
         RowBox[{"1", "+", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"3", " ", "4"}]}], ")"}]}],
         DisplayForm], "]"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"Module", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "[", 
     RowBox[{
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"{", "}"}],
        DisplayForm], "]"}], ",", 
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"3", " ", "4"}]}], ")"}]}],
        DisplayForm], "]"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"{", "}"}],
        DisplayForm], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"{", "##1", "}"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"ff", "/@", 
        RowBox[{"xHold", "/@", 
         RowBox[{"xHold", "[", "]"}]}]}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"xHold", "/@", 
           RowBox[{"xHold", "[", "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"xHold", "[", "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"ff", "/@", 
         RowBox[{"xHold", "[", "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"xHold", "[", "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"{", "##1", "}"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"xHold", "[", "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"{", "##1", "}"}],
          DisplayForm], "&"}], ")"}], "[", "]"}],
      HoldForm], ",", 
     TagBox[
      TagBox[
       RowBox[{"{", "}"}],
       DisplayForm],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"1", "+", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"3", " ", "4"}]}], ")"}]}],
        DisplayForm], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"ff", "/@", 
        RowBox[{"xHold", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{"1", ",", 
           RowBox[{"2", "+", 
            RowBox[{"3", " ", "4"}]}]}], "]"}]}]}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"xHold", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{"1", ",", 
             RowBox[{"2", "+", 
              RowBox[{"3", " ", "4"}]}]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"xHold", "[", 
           RowBox[{
            TagBox["\<\"1\"\>",
             DisplayForm], ",", 
            TagBox[
             RowBox[{"2", "+", 
              RowBox[{"3", " ", "4"}]}],
             DisplayForm]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"ff", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           TagBox["\<\"1\"\>",
            DisplayForm], ",", 
           TagBox[
            RowBox[{"2", "+", 
             RowBox[{"3", " ", "4"}]}],
            DisplayForm]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"xHold", "[", 
         RowBox[{
          RowBox[{"ff", "[", 
           TagBox["\<\"1\"\>",
            DisplayForm], "]"}], ",", 
          RowBox[{"ff", "[", 
           TagBox[
            RowBox[{"2", "+", 
             RowBox[{"3", " ", "4"}]}],
            DisplayForm], "]"}]}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         RowBox[{"ff", "[", 
          TagBox["\<\"1\"\>",
           DisplayForm], "]"}], ",", 
         RowBox[{"ff", "[", 
          TagBox[
           RowBox[{"2", "+", 
            RowBox[{"3", " ", "4"}]}],
           DisplayForm], "]"}]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{
        RowBox[{"ff", "[", 
         TagBox["\<\"1\"\>",
          DisplayForm], "]"}], ",", 
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"2", "+", 
           RowBox[{"3", " ", "4"}]}],
          DisplayForm], "]"}]}], "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", 
         TagBox["\<\"1\"\>",
          DisplayForm], "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["1", "2"],
        HoldForm], ",", 
       TagBox["1",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"2", "+", 
           RowBox[{"3", " ", "4"}]}],
          DisplayForm], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{"ff", "/@", 
          RowBox[{"xHold", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{"2", ",", 
             RowBox[{"3", " ", "4"}]}], "]"}]}]}]}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xHold", "/@", 
             RowBox[{"xHold", "[", 
              RowBox[{"2", ",", 
               RowBox[{"3", " ", "4"}]}], "]"}]}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"xHold", "[", 
             RowBox[{
              TagBox["\<\"2\"\>",
               DisplayForm], ",", 
              TagBox[
               RowBox[{"3", " ", "4"}],
               DisplayForm]}], "]"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"ff", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{
             TagBox["\<\"2\"\>",
              DisplayForm], ",", 
             TagBox[
              RowBox[{"3", " ", "4"}],
              DisplayForm]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"xHold", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             TagBox["\<\"2\"\>",
              DisplayForm], "]"}], ",", 
            RowBox[{"ff", "[", 
             TagBox[
              RowBox[{"3", " ", "4"}],
              DisplayForm], "]"}]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "@@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            TagBox["\<\"2\"\>",
             DisplayForm], "]"}], ",", 
           RowBox[{"ff", "[", 
            TagBox[
             RowBox[{"3", " ", "4"}],
             DisplayForm], "]"}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{
          RowBox[{"ff", "[", 
           TagBox["\<\"2\"\>",
            DisplayForm], "]"}], ",", 
          RowBox[{"ff", "[", 
           TagBox[
            RowBox[{"3", " ", "4"}],
            DisplayForm], "]"}]}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"ff", "[", 
           TagBox["\<\"2\"\>",
            DisplayForm], "]"}],
          HoldForm], ",", 
         TagBox[
          SuperscriptBox["2", "2"],
          HoldForm], ",", 
         TagBox["4",
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"ff", "[", 
           TagBox[
            RowBox[{"3", " ", "4"}],
            DisplayForm], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             TagBox[
              RowBox[{"Times", "[", "##1", "]"}],
              DisplayForm], "&"}], ")"}], "@@", 
           RowBox[{"ff", "/@", 
            RowBox[{"xHold", "/@", 
             RowBox[{"xHold", "[", 
              RowBox[{"3", ",", "4"}], "]"}]}]}]}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             TagBox[
              RowBox[{"xHold", "/@", 
               RowBox[{"xHold", "[", 
                RowBox[{"3", ",", "4"}], "]"}]}],
              HoldForm], ",", 
             TagBox[
              RowBox[{"xHold", "[", 
               RowBox[{
                TagBox["\<\"3\"\>",
                 DisplayForm], ",", 
                TagBox["\<\"4\"\>",
                 DisplayForm]}], "]"}],
              HoldForm]}], "}"}], ",", 
           TagBox[
            RowBox[{"ff", "/@", 
             RowBox[{"xHold", "[", 
              RowBox[{
               TagBox["\<\"3\"\>",
                DisplayForm], ",", 
               TagBox["\<\"4\"\>",
                DisplayForm]}], "]"}]}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"xHold", "[", 
             RowBox[{
              RowBox[{"ff", "[", 
               TagBox["\<\"3\"\>",
                DisplayForm], "]"}], ",", 
              RowBox[{"ff", "[", 
               TagBox["\<\"4\"\>",
                DisplayForm], "]"}]}], "]"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             TagBox[
              RowBox[{"Times", "[", "##1", "]"}],
              DisplayForm], "&"}], ")"}], "@@", 
           RowBox[{"xHold", "[", 
            RowBox[{
             RowBox[{"ff", "[", 
              TagBox["\<\"3\"\>",
               DisplayForm], "]"}], ",", 
             RowBox[{"ff", "[", 
              TagBox["\<\"4\"\>",
               DisplayForm], "]"}]}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             TagBox[
              RowBox[{"Times", "[", "##1", "]"}],
              DisplayForm], "&"}], ")"}], "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             TagBox["\<\"3\"\>",
              DisplayForm], "]"}], ",", 
            RowBox[{"ff", "[", 
             TagBox["\<\"4\"\>",
              DisplayForm], "]"}]}], "]"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ff", "[", 
             TagBox["\<\"3\"\>",
              DisplayForm], "]"}],
            HoldForm], ",", 
           TagBox[
            SuperscriptBox["3", "2"],
            HoldForm], ",", 
           TagBox["9",
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"ff", "[", 
             TagBox["\<\"4\"\>",
              DisplayForm], "]"}],
            HoldForm], ",", 
           TagBox[
            SuperscriptBox["4", "2"],
            HoldForm], ",", 
           TagBox["16",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             TagBox[
              RowBox[{"Times", "[", "##1", "]"}],
              DisplayForm], "&"}], ")"}], "[", 
           RowBox[{"9", ",", "16"}], "]"}],
          HoldForm], ",", 
         TagBox[
          TagBox[
           RowBox[{"9", " ", "16"}],
           DisplayForm],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           TagBox[
            RowBox[{"+", "##1"}],
            DisplayForm], "&"}], ")"}], "[", 
         RowBox[{"4", ",", 
          TagBox[
           RowBox[{"9", " ", "16"}],
           DisplayForm]}], "]"}],
        HoldForm], ",", 
       TagBox[
        TagBox[
         RowBox[{"4", "+", 
          TagBox[
           RowBox[{"9", " ", "16"}],
           DisplayForm]}],
         DisplayForm],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{"1", ",", 
        TagBox[
         RowBox[{"4", "+", 
          TagBox[
           RowBox[{"9", " ", "16"}],
           DisplayForm]}],
         DisplayForm]}], "]"}],
      HoldForm], ",", 
     TagBox[
      TagBox[
       RowBox[{"1", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"4", "+", 
           TagBox[
            RowBox[{"9", " ", "16"}],
            DisplayForm]}],
          DisplayForm], ")"}]}],
       DisplayForm],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"Module", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "[", 
     RowBox[{
      TagBox[
       RowBox[{"{", "}"}],
       DisplayForm], ",", 
      TagBox[
       RowBox[{"1", "+", 
        RowBox[{"(", 
         TagBox[
          RowBox[{"4", "+", 
           TagBox[
            RowBox[{"9", " ", "16"}],
            DisplayForm]}],
          DisplayForm], ")"}]}],
       DisplayForm]}], "]"}],
    HoldForm], ",", 
   TagBox[
    TagBox[
     RowBox[{"Module", "[", 
      RowBox[{
       TagBox[
        RowBox[{"{", "}"}],
        DisplayForm], ",", 
       TagBox[
        RowBox[{"1", "+", 
         RowBox[{"(", 
          TagBox[
           RowBox[{"4", "+", 
            TagBox[
             RowBox[{"9", " ", "16"}],
             DisplayForm]}],
           DisplayForm], ")"}]}],
        DisplayForm]}], "]"}],
     DisplayForm],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"9b4fd713-b629-44ae-b3c1-cb4a717f1b69"]
}, Open  ]],

Cell["Note that Sequence heads are stripped out:", \
"Text",ExpressionUUID->"45edcd79-cecb-4cc7-9ee7-59cff891d4e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"xHold", "[", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"Sequence", "[", "2", "]"}]}]}], "]"}], "]"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"2b5490ad-cdbe-46f3-bb10-7cec491c4306"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"ff", "[", 
     TagBox[
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"1", "+", 
         RowBox[{"Sequence", "[", "2", "]"}]}]}], "]"}],
      DisplayForm], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"Module", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "@@", 
     RowBox[{"ff", "/@", 
      RowBox[{"xHold", "/@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"Sequence", "[", "2", "]"}]}]}], "]"}]}]}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"xHold", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"1", "+", 
            RowBox[{"Sequence", "[", "2", "]"}]}]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"xHold", "[", 
         RowBox[{
          TagBox[
           RowBox[{"{", "}"}],
           DisplayForm], ",", 
          TagBox[
           RowBox[{"1", "+", 
            RowBox[{"Sequence", "[", "2", "]"}]}],
           DisplayForm]}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"ff", "/@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         TagBox[
          RowBox[{"{", "}"}],
          DisplayForm], ",", 
         TagBox[
          RowBox[{"1", "+", 
           RowBox[{"Sequence", "[", "2", "]"}]}],
          DisplayForm]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"xHold", "[", 
       RowBox[{
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"{", "}"}],
          DisplayForm], "]"}], ",", 
        RowBox[{"ff", "[", 
         TagBox[
          RowBox[{"1", "+", 
           RowBox[{"Sequence", "[", "2", "]"}]}],
          DisplayForm], "]"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"Module", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "@@", 
     RowBox[{"xHold", "[", 
      RowBox[{
       RowBox[{"ff", "[", 
        TagBox[
         RowBox[{"{", "}"}],
         DisplayForm], "]"}], ",", 
       RowBox[{"ff", "[", 
        TagBox[
         RowBox[{"1", "+", 
          RowBox[{"Sequence", "[", "2", "]"}]}],
         DisplayForm], "]"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"Module", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "[", 
     RowBox[{
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"{", "}"}],
        DisplayForm], "]"}], ",", 
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"1", "+", 
         RowBox[{"Sequence", "[", "2", "]"}]}],
        DisplayForm], "]"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"{", "}"}],
        DisplayForm], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"{", "##1", "}"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"ff", "/@", 
        RowBox[{"xHold", "/@", 
         RowBox[{"xHold", "[", "]"}]}]}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"xHold", "/@", 
           RowBox[{"xHold", "[", "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"xHold", "[", "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"ff", "/@", 
         RowBox[{"xHold", "[", "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"xHold", "[", "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"{", "##1", "}"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"xHold", "[", "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"{", "##1", "}"}],
          DisplayForm], "&"}], ")"}], "[", "]"}],
      HoldForm], ",", 
     TagBox[
      TagBox[
       RowBox[{"{", "}"}],
       DisplayForm],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"ff", "[", 
       TagBox[
        RowBox[{"1", "+", 
         RowBox[{"Sequence", "[", "2", "]"}]}],
        DisplayForm], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"ff", "/@", 
        RowBox[{"xHold", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{"1", ",", 
           RowBox[{"Sequence", "[", "2", "]"}]}], "]"}]}]}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"xHold", "[", 
             RowBox[{"1", ",", 
              RowBox[{"Sequence", "[", "2", "]"}]}], "]"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"xHold", "[", 
             RowBox[{"1", ",", "2"}], "]"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"xHold", "/@", 
           RowBox[{"xHold", "[", 
            RowBox[{"1", ",", "2"}], "]"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"xHold", "[", 
           RowBox[{
            TagBox["\<\"1\"\>",
             DisplayForm], ",", 
            TagBox["\<\"2\"\>",
             DisplayForm]}], "]"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"ff", "/@", 
         RowBox[{"xHold", "[", 
          RowBox[{
           TagBox["\<\"1\"\>",
            DisplayForm], ",", 
           TagBox["\<\"2\"\>",
            DisplayForm]}], "]"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"xHold", "[", 
         RowBox[{
          RowBox[{"ff", "[", 
           TagBox["\<\"1\"\>",
            DisplayForm], "]"}], ",", 
          RowBox[{"ff", "[", 
           TagBox["\<\"2\"\>",
            DisplayForm], "]"}]}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "@@", 
       RowBox[{"xHold", "[", 
        RowBox[{
         RowBox[{"ff", "[", 
          TagBox["\<\"1\"\>",
           DisplayForm], "]"}], ",", 
         RowBox[{"ff", "[", 
          TagBox["\<\"2\"\>",
           DisplayForm], "]"}]}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{
        RowBox[{"ff", "[", 
         TagBox["\<\"1\"\>",
          DisplayForm], "]"}], ",", 
        RowBox[{"ff", "[", 
         TagBox["\<\"2\"\>",
          DisplayForm], "]"}]}], "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", 
         TagBox["\<\"1\"\>",
          DisplayForm], "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["1", "2"],
        HoldForm], ",", 
       TagBox["1",
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"ff", "[", 
         TagBox["\<\"2\"\>",
          DisplayForm], "]"}],
        HoldForm], ",", 
       TagBox[
        SuperscriptBox["2", "2"],
        HoldForm], ",", 
       TagBox["4",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{"+", "##1"}],
          DisplayForm], "&"}], ")"}], "[", 
       RowBox[{"1", ",", "4"}], "]"}],
      HoldForm], ",", 
     TagBox[
      TagBox[
       RowBox[{"1", "+", "4"}],
       DisplayForm],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{"Module", "[", "##1", "]"}],
        DisplayForm], "&"}], ")"}], "[", 
     RowBox[{
      TagBox[
       RowBox[{"{", "}"}],
       DisplayForm], ",", 
      TagBox[
       RowBox[{"1", "+", "4"}],
       DisplayForm]}], "]"}],
    HoldForm], ",", 
   TagBox[
    TagBox[
     RowBox[{"Module", "[", 
      RowBox[{
       TagBox[
        RowBox[{"{", "}"}],
        DisplayForm], ",", 
       TagBox[
        RowBox[{"1", "+", "4"}],
        DisplayForm]}], "]"}],
     DisplayForm],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"321b7a84-57f0-4c07-827e-93635b0c04ae"]
}, Open  ]],

Cell["\<\
because xHold has attribute HoldAll, and not HoldAllComplete:\
\>", "Text",ExpressionUUID->"3bc64706-a227-4405-b5bb-1f2097019b32"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xHold", "[", 
   RowBox[{"1", ",", 
    RowBox[{"Sequence", "[", "2", "]"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"6b39cdff-063b-43db-86db-01b141930d00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"xHold", "[", 
     RowBox[{"1", ",", 
      RowBox[{"Sequence", "[", "2", "]"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"xHold", "[", 
     RowBox[{"1", ",", "2"}], "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"69e5abc7-a7d8-4367-a895-3fc2b402714e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"1", ",", 
   RowBox[{"Sequence", "[", "2", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"8391e2a5-2620-4b2d-861d-8365ba948238"],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"1", ",", 
   RowBox[{"Sequence", "[", "2", "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"561562ed-3d7a-4ea5-9824-e9679ec71bc3"]
}, Open  ]],

Cell["The function fails when head is Slot or SlotSequence:", \
"Text",ExpressionUUID->"151eadf9-20ab-4cea-98aa-98492f550b6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"xHold", "[", 
   RowBox[{"Slot", "[", 
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"42174cdb-64c4-4df0-83ff-b255b1480a1c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Function", "::", "slot"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(Slot[##1]\\)\[NoBreak] (in \
\[NoBreak]\\!\\(\\(\\(Slot[##1]\\)\\) &\\)\[NoBreak]) should contain a \
non-negative integer. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Function/slot\\\", ButtonNote -> \
\\\"Function::slot\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"7689fbaf-09df-4e74-a114-89ee6a18a213"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Function", "::", "slot"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(Slot[##1]\\)\[NoBreak] (in \
\[NoBreak]\\!\\(\\(\\(Slot[##1]\\)\\) &\\)\[NoBreak]) should contain a \
non-negative integer. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Function/slot\\\", ButtonNote -> \
\\\"Function::slot\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"f2afaad5-f4e0-433e-8bc4-dfdf35367dbd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    TagBox[
     RowBox[{"Slot", "[", "##1", "]"}],
     DisplayForm], "&"}], ")"}], "[", 
  TagBox[
   RowBox[{"1", "+", 
    RowBox[{"(", 
     TagBox[
      RowBox[{"4", "+", "9"}],
      DisplayForm], ")"}]}],
   DisplayForm], 
  "]"}]], "Output",ExpressionUUID->"9417bf9e-e5c0-4fe5-bb11-ddca3c54c8d9"]
}, Open  ]],

Cell[TextData[{
 "We need an additional definition for those cases (In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 this new definition is placed last and the problem persists). We break \
recursion and do not look in the interior of the slots. QUESTION: Are these \
two the only functions with this problem?"
}], "Text",ExpressionUUID->"52f77d20-b8e3-4622-a6e0-35f5ad6ca279"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"xHold", "[", 
    RowBox[{"k", ":", 
     RowBox[{"(", 
      RowBox[{"_Slot", "|", "_SlotSequence"}], ")"}]}], "]"}], "]"}], ":=", 
  RowBox[{
  "xHold", "[", "k", 
   "]"}]}]], "Input",ExpressionUUID->"c9b59183-3348-4ec1-93c3-fd79f86ff3e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"xHold", "[", 
   RowBox[{"Slot", "[", 
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"d125313f-2699-4a78-9fbc-87a83b7cd284"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Function", "::", "slot"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(Slot[##1]\\)\[NoBreak] (in \
\[NoBreak]\\!\\(\\(\\(Slot[##1]\\)\\) &\\)\[NoBreak]) should contain a \
non-negative integer. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Function/slot\\\", ButtonNote -> \
\\\"Function::slot\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"ae6dff69-24d8-435a-865c-0a9af996557c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Function", "::", "slot"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(Slot[##1]\\)\[NoBreak] (in \
\[NoBreak]\\!\\(\\(\\(Slot[##1]\\)\\) &\\)\[NoBreak]) should contain a \
non-negative integer. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Function/slot\\\", ButtonNote -> \
\\\"Function::slot\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"f346ba2f-6204-49a0-ade4-f6ed60d50780"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    TagBox[
     RowBox[{"Slot", "[", "##1", "]"}],
     DisplayForm], "&"}], ")"}], "[", 
  TagBox[
   RowBox[{"1", "+", 
    RowBox[{"(", 
     TagBox[
      RowBox[{"4", "+", "9"}],
      DisplayForm], ")"}]}],
   DisplayForm], 
  "]"}]], "Output",ExpressionUUID->"65786904-0737-46e2-a174-0ec2fed5f915"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Remove", "[", 
  RowBox[{"ff", ",", "head", ",", "elements", ",", "k"}], "]"}], "\n", 
 RowBox[{"EndExamples", "[", 
  "]"}]}], "Input",ExpressionUUID->"6176a7a5-977a-45c7-af08-820de2d01d1c"],

Cell[TextData[{
 "This is finally the idea that will be used to construct ReplaceIndex in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"6182635a-78d2-445c-b5c5-bd61b8422ef1"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7. Formatting strings", \
"Subsection",ExpressionUUID->"f3f9f788-93db-4003-8c86-918de6937bcd"],

Cell[CellGroupData[{

Cell["2.7.0. On linear syntax", \
"Subsubsection",ExpressionUUID->"cbd5cbb7-20f2-47fc-a206-dac18dbb6cf8"],

Cell["\<\
See the tutorial/StringRepresentationOfBoxes for an introduction to this. \
Remember the correspondence:

\t\\^\tSuperscriptBox
\t\\_\tSubscriptBox
\t\\&\tOverscriptBox
\t\\+\tUnderscriptBox\
\>", "Text",ExpressionUUID->"67057a71-ec68-4a61-a6fc-fe4aa38505ee"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7.1. Underlining strings without blanks: Underline", \
"Subsubsection",ExpressionUUID->"d3b49268-9f83-4492-a091-fd36ab0e0fb0"],

Cell["\<\
We shall underline patterns in Output format. This function underlines any \
expression without blanks:\
\>", "Text",ExpressionUUID->"6c6c3e21-f2c3-4a59-84f6-6c4426440a67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Underline"}]], \
"Input",ExpressionUUID->"c60fb9dd-4698-43cd-9141-b06c2785ee9c"],

Cell[BoxData[
 StyleBox["\<\"Underline[x] returns a string with x underlined. The string \
form of x must not contain blanks. Underline[x, color] prints colored \
underlines (but x is not colored).\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974382-4493425",ExpressionUUID->"f3b35c9b-48f1-4be0-8460-\
5115a09ff021"]
}, Open  ]],

Cell["\<\
The kind of input used in the main definition here generates an Information \
message complaining about the double quotes and the notebook preferences \
options ShowStringCharacters\[Rule]False. We cannot turn it to True because \
then there would be quotes around the indices of the tensors in StandardForm. \
QUESTION: Can we detect blanks?\
\>", "Text",ExpressionUUID->"ead1e062-84b5-4973-81d3-476b7516a0cd"],

Cell["One argument:", \
"Text",ExpressionUUID->"f2dd7259-a5b4-497f-bf41-50bddae76f4b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Format", "::", "blank"}], "=", 
   "\"\<Empty string cannot be `1`.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Underline", "[", "\"\<\>\"", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Format", "::", "blank"}], ",", "\"\<underlined\>\""}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Underline", "[", "x_String", "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", "\"\<\\+_\\)\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Underline", "[", "x_", "]"}], ":=", 
   RowBox[{"Underline", "[", 
    RowBox[{"ToString", "[", "x", "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"4e41c845-c62e-42cf-8c9b-8d8323664c30"],

Cell["Two arguments (colored line):", \
"Text",ExpressionUUID->"932f9568-04df-431f-9448-ea323ac1b0af"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Underline", "[", 
    RowBox[{"\"\<\>\"", ",", "color_"}], "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Format", "::", "blank"}], ",", "\"\<underlined\>\""}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Underline", "[", 
    RowBox[{"x_String", ",", "color_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "\"\<\\!\\(\>\"", ",", "x", ",", 
     "\"\<\\+\\*StyleBox[\\(_\\),FontColor->\>\"", ",", 
     RowBox[{"ToString", "[", "color", "]"}], ",", "\"\<]\\)\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Underline", "[", 
    RowBox[{"x_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"Underline", "[", 
    RowBox[{
     RowBox[{"ToString", "[", "x", "]"}], ",", "color"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Underline", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Underline", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"df8602e6-cc97-44d2-8ffe-33907acf19de"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"3be09b9e-b427-43d7-8561-3274f96dabfb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underline", "[", "hello", 
  "]"}]], "Input",ExpressionUUID->"05511cd8-a609-408a-a808-5f20abc41ae7"],

Cell[BoxData["\<\"\\!\\(hello\\+_\\)\"\>"], \
"Output",ExpressionUUID->"aab23be9-fadd-478e-84ad-368ff2cb099c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underline", "[", "\"\<hello\>\"", 
  "]"}]], "Input",ExpressionUUID->"02a8db49-a2cd-4a08-97b3-19238f706b53"],

Cell[BoxData["\<\"\\!\\(hello\\+_\\)\"\>"], \
"Output",ExpressionUUID->"419b5da9-d8c4-4611-8921-62051cb865eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"fbe9fb2b-f0d7-4b88-8e78-1fcfe80a8619"],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(hello\\+_\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"26851e3c-36cd-4b8a-ab50-779747b84ca8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underline", "[", "\"\<ab\>\"", 
  "]"}]], "Input",ExpressionUUID->"091ecf2e-ed4f-4427-bc32-9d8dbe06c1ea"],

Cell[BoxData["\<\"\\!\\(ab\\+_\\)\"\>"], \
"Output",ExpressionUUID->"cb5cf15b-3e01-40ac-88ef-7fb1588e24d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"33521d57-cff7-4e65-b264-0e3a8f0becbf"],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(ab\\+_\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"c282d04c-0708-4578-82a1-e3ab36221442"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "Underline", "[", "\"\<\>\"", 
   "]"}]}]], "Input",ExpressionUUID->"f982d8cc-407b-4015-b144-ad3f7ea1d674"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Format", "::", "blank"}], "MessageName"], ":", 
  " ", "\<\"Empty string cannot be \[NoBreak]\\!\\(\\\"underlined\\\"\\)\
\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Format\\\", ButtonNote -> \
\\\"Format::blank\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"29db2cd8-6b29-4230-866e-e803e32d3c36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underline", "[", 
  RowBox[{"\"\<hello\>\"", ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"532140f8-52ba-4c0b-a1be-402157fdb2a9"],

Cell[BoxData["\<\"\\!\\(hello\\+\\*StyleBox[\\(_\\),FontColor->RGBColor[1, 0, \
0]]\\)\"\>"], \
"Output",ExpressionUUID->"7a1fb57d-da17-41e6-96e7-d92dca5f37d3"]
}, Open  ]],

Cell["\<\
The blank is not detected in the next three cases. This is odd, because \
Overline (having the same code) does not have this problem:\
\>", "Text",ExpressionUUID->"b5c01e8f-799c-4a56-8131-9d2d528d5cae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underline", "[", "\"\<a b\>\"", 
  "]"}]], "Input",ExpressionUUID->"3ed6a7cd-994e-4e9a-a627-1382be7aa828"],

Cell[BoxData["\<\"\\!\\(a b\\+_\\)\"\>"], \
"Output",ExpressionUUID->"9c808801-37d6-481a-a624-d3c24cef04c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underline", "[", 
  RowBox[{"a", " ", "b"}], 
  "]"}]], "Input",ExpressionUUID->"8bf1966f-6237-4c5a-85aa-5c5e8f3542b3"],

Cell[BoxData["\<\"\\!\\(a b\\+_\\)\"\>"], \
"Output",ExpressionUUID->"1e72d7f4-c6b5-42bd-af8c-4723a94a5325"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underline", "[", "\"\< \>\"", 
  "]"}]], "Input",ExpressionUUID->"8217c7c2-68e8-4daf-ad09-1c65a7d4e044"],

Cell[BoxData["\<\"\\!\\( \\+_\\)\"\>"], \
"Output",ExpressionUUID->"1df58dad-be0b-4320-9a51-5face8ba5d00"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"a", ",", "b", ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"c66f9d8b-3a1f-4729-8d7d-98c5f04028ec"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"14c92d18-0ae0-49d5-8e56-c9a4bbc55f08"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7.2. Tilding strings without blanks: TildeString", \
"Subsubsection",ExpressionUUID->"a10ecaa2-4e80-457d-a82e-e971b2541433"],

Cell["\<\
We shall use tildes to denote the weight of densities (Ashtekar notation)\
\>", "Text",ExpressionUUID->"92ff6a86-8fb0-4a77-a071-41e9bd75a2c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "TildeString"}]], \
"Input",ExpressionUUID->"b5745733-7a70-4f9a-bd47-9f648eced32a"],

Cell[BoxData[
 StyleBox["\<\"TildeString[x, n] returns a string with n tildes over x if n>0 \
and n tildes below x if n<0. When n is not an integer, n is replaced by 1. \
TildeString[x, n, color] prints colored tildes (but x is not colored).\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974383-4493425",ExpressionUUID->"8f787ecd-430a-48c0-a5fe-\
1970e6da8c7c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Format", "::", "ntilde"}], "=", 
   "\"\<Number of tildes `1` should be an integer. Replaced by 1.\>\""}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"382757f9-369b-4d3f-88eb-36a19cb8466f"],

Cell["One argument:", \
"Text",ExpressionUUID->"090ea5b5-01c2-48b7-bad7-3e7e38721feb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", "x_", "]"}], ":=", 
   RowBox[{"TildeString", "[", 
    RowBox[{"x", ",", "1"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"28adf43e-c6ea-4707-bba8-994855bb8425"],

Cell["Two arguments (uncolored tilde):", \
"Text",ExpressionUUID->"a36682e1-17ff-41e8-ad47-cc3d0fadcec0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"\"\<\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Format", "::", "blank"}], ",", "\"\<tilded\>\""}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_String", ",", "0"}], "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_String", ",", 
     RowBox[{"n_Integer", "?", "Positive"}]}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<\\&~\>\"", ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], ",", "\"\<\\)\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_String", ",", 
     RowBox[{"n_Integer", "?", "Negative"}]}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<\\+~\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"-", "n"}], "}"}]}], "]"}], ",", "\"\<\\)\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_String", ",", "n_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"Format", "::", "ntilde"}], ",", "n"}], "]"}], ";", 
     RowBox[{"TildeString", "[", 
      RowBox[{"x", ",", "1"}], "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"TildeString", "[", 
    RowBox[{
     RowBox[{"ToString", "[", "x", "]"}], ",", "n"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"6fae1ff1-d191-45d4-9d9f-7301fd63760f"],

Cell["Three arguments (colored tilde):", \
"Text",ExpressionUUID->"3782390b-0ccb-4b99-83c2-38a92869eb0e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"\"\<\>\"", ",", "n_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Format", "::", "blank"}], ",", "\"\<tilded\>\""}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_String", ",", "0", ",", "color_"}], "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_String", ",", 
     RowBox[{"n_Integer", "?", "Positive"}], ",", "color_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"colortilde", "=", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\&\\*StyleBox[\\\"~\\\",FontColor->\>\"", ",", 
         RowBox[{"ToString", "[", "color", "]"}], ",", "\"\<]\>\""}], "]"}]}],
       "}"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"colortilde", ",", 
         RowBox[{"{", "n", "}"}]}], "]"}], ",", "\"\<\\)\>\""}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_String", ",", 
     RowBox[{"n_Integer", "?", "Negative"}], ",", "color_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"colortilde", "=", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\+\\*StyleBox[\\\"~\\\",FontColor->\>\"", ",", 
         RowBox[{"ToString", "[", "color", "]"}], ",", "\"\<]\>\""}], "]"}]}],
       "}"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"colortilde", ",", 
         RowBox[{"{", 
          RowBox[{"-", "n"}], "}"}]}], "]"}], ",", "\"\<\\)\>\""}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_String", ",", "n_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"Format", "::", "ntilde"}], ",", "n"}], "]"}], ";", 
     RowBox[{"TildeString", "[", 
      RowBox[{"x", ",", "1", ",", "color"}], "]"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TildeString", "[", 
    RowBox[{"x_", ",", "n_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"TildeString", "[", 
    RowBox[{
     RowBox[{"ToString", "[", "x", "]"}], ",", "n", ",", "color"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"TildeString", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "TildeString", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7444b595-208b-4944-84f1-b33aece79da2"],

Cell["Examples:", \
"Text",ExpressionUUID->"e3788b16-3193-423b-b234-4ef8bec01396"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"1c49a4ac-823b-4f6a-a96c-bc3c03ee7a62"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TildeString", "[", 
  RowBox[{"x", ",", "3"}], 
  "]"}]], "Input",ExpressionUUID->"da24173b-cd7e-4ec7-a1ed-9c43ab51fd60"],

Cell[BoxData["\<\"\\!\\(x\\&~\\&~\\&~\\)\"\>"], \
"Output",ExpressionUUID->"086fba3c-13be-42ff-90c4-a78e673d4e05"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"bbab8c87-e2a4-4aa1-9e4b-379f3b5ef9c3"],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(x\\&~\\&~\\&~\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"c6b7060d-124e-48a6-a043-3c2776c96063"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TildeString", "[", 
  RowBox[{"x", ",", 
   RowBox[{"-", "3"}]}], 
  "]"}]], "Input",ExpressionUUID->"8ff6f36d-946a-426b-a7c8-5f1d3e9015d8"],

Cell[BoxData["\<\"\\!\\(x\\+~\\+~\\+~\\)\"\>"], \
"Output",ExpressionUUID->"8aa77e46-4628-4105-908a-59968eae924b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"4192e0d1-179a-4b8c-beb7-080718c3e8d9"],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(x\\+~\\+~\\+~\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"4479d881-ee51-4807-bde6-07e96dfb17ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<\\!\\(x\\+~\\%~\>\"", "<>", 
  "\"\<\\)\>\""}]], \
"Input",ExpressionUUID->"2d7b71d5-9cf2-40b7-a6c0-87badc1a8318"],

Cell[BoxData["\<\"\\!\\(x\\+~\\%~\\)\"\>"], \
"Output",ExpressionUUID->"88d7b1ce-24e5-4169-bfac-a100d07f8560"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TildeString", "[", 
  RowBox[{"x", ",", "3", ",", 
   RowBox[{"Hue", "[", "0", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"a7954d71-f978-47ae-a98e-01fe8016063a"],

Cell[BoxData["\<\"\\!\\(x\\&\\*StyleBox[\\\"~\\\",FontColor->Hue[0]]\\&\\*\
StyleBox[\\\"~\\\",FontColor->Hue[0]]\\&\\*StyleBox[\\\"~\\\",FontColor->Hue[\
0]]\\)\"\>"], \
"Output",ExpressionUUID->"ac1f40bc-89d6-494f-8393-eca1898cf1ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"bad003bd-b9ed-4d57-8590-e9fb4b676a19"],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(x\\&\\*StyleBox[\\\"~\\\",FontColor->Hue[0]]\\&\\*StyleBox[\\\"~\
\\\",FontColor->Hue[0]]\\&\\*StyleBox[\\\"~\\\",FontColor->Hue[0]]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"b0c96ba4-24c5-4c75-a6e3-68e7bc5ea32a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TildeString", "[", 
  RowBox[{"x", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"Hue", "[", "0", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"6b96bb7a-3ff9-4701-906c-a0da0c0550a9"],

Cell[BoxData["\<\"\\!\\(x\\+\\*StyleBox[\\\"~\\\",FontColor->Hue[0]]\\+\\*\
StyleBox[\\\"~\\\",FontColor->Hue[0]]\\+\\*StyleBox[\\\"~\\\",FontColor->Hue[\
0]]\\)\"\>"], \
"Output",ExpressionUUID->"7461a2f9-368a-4d40-ab34-e6df1c0f98e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"74726cb2-f09d-407a-8c0a-f8fe46b0aa87"],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(x\\+\\*StyleBox[\\\"~\\\",FontColor->Hue[0]]\\+\\*StyleBox[\\\"~\
\\\",FontColor->Hue[0]]\\+\\*StyleBox[\\\"~\\\",FontColor->Hue[0]]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"fa90fe14-7a6d-4c48-b020-6ed858164163"]
}, Open  ]],

Cell["Error messages:", \
"Text",ExpressionUUID->"0f1bc5e8-847a-4ea1-9bd2-b1237d682965"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TildeString", "[", 
  RowBox[{"x", ",", 
   RowBox[{"1", "/", "2"}]}], 
  "]"}]], "Input",ExpressionUUID->"31b4f573-effc-4e2a-9621-af8b257f7b12"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Format", "::", "ntilde"}], "MessageName"], ":", 
  " ", "\<\"Number of tildes \[NoBreak]\\!\\(1\\/2\\)\[NoBreak] should be an \
integer. Replaced by 1. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Format\\\", ButtonNote -> \
\\\"Format::ntilde\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"836ef423-da76-4896-9278-87f2e7f8a57b"],

Cell[BoxData["\<\"\\!\\(x\\&~\\)\"\>"], \
"Output",ExpressionUUID->"eb2c56b3-9066-4a20-bfd0-e111c6c1d10a"]
}, Open  ]],

Cell["Again, the blank is not detected:", \
"Text",ExpressionUUID->"499eab6c-b0d6-49ba-af5d-6902ec1836a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TildeString", "[", 
  RowBox[{
   RowBox[{"x", " ", "x"}], ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"2955134f-463f-4927-a3a7-538ea6069378"],

Cell[BoxData["\<\"\\!\\( 2\\nx\\&~\\)\"\>"], \
"Output",ExpressionUUID->"412a9278-1b2f-4363-8833-d6bdd4a2e2af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TildeString", "[", 
  RowBox[{"\"\<x x\>\"", ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"b82fe12b-4261-4f47-bbb3-14730c1af1c6"],

Cell[BoxData["\<\"\\!\\(x x\\&~\\)\"\>"], \
"Output",ExpressionUUID->"90d8ec1c-ab76-461b-9ba2-7b111d15a455"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "x", 
  "]"}]], "Input",ExpressionUUID->"d1e4de59-eddb-4cd8-a85c-521cb1751d41"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"2c5138f4-14c9-4929-b6af-a28cf6d55838"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7.3. Coloring strings: ColorString", \
"Subsubsection",ExpressionUUID->"7a118be1-c831-482d-993f-406f66e6eda7"],

Cell["\<\
We shall color the basis indices, and some other heads like ERROR.\
\>", "Text",ExpressionUUID->"2fd7fcc2-7657-4fa4-94ed-9abb2cf12547"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ColorString"}]], \
"Input",ExpressionUUID->"2c6f0553-a3c8-41bb-965f-2347021d60f0"],

Cell[BoxData[
 StyleBox["\<\"ColorString[atom, color] returns a string with atom printed in \
color.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974384-4493425",ExpressionUUID->"905b6ed7-105b-4eb8-b718-\
ea31f76b5572"]
}, Open  ]],

Cell["\<\
We need to map N on the color to convert rational numbers into real numbers. \
Otherwise ToString does stupid things... Thanks to Alessandro for reporting \
this problem.\
\>", "Text",ExpressionUUID->"ebacbec4-c526-4948-be4c-718c777d584f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"ColorString", "[", 
      RowBox[{"x_String", ",", "color_"}], "]"}], ":=", 
     RowBox[{
     "\"\<\\!\\(\\*StyleBox[\\\"\>\"", "<>", "x", "<>", 
      "\"\<\\\",FontColor->\>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"N", "/@", "color"}], "]"}], "<>", "\"\<]\\)\>\""}]}], ";"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Replaced", " ", "by", " ", "the", " ", "following", " ", "line"}], ",", 
    " ", 
    RowBox[{"as", " ", "suggested", " ", "by", " ", "Thomas"}], ",", " ", 
    RowBox[{
    "to", " ", "be", " ", "able", " ", "to", " ", "change", " ", "the", " ", 
     "color", " ", "of", " ", "an", " ", "already", " ", "colored", " ", 
     "string"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ColorString", "[", 
      RowBox[{"x_String", ",", "color_"}], "]"}], ":=", 
     RowBox[{"\"\<\\!\\(\\*StyleBox[\\\"\>\"", "<>", 
      RowBox[{"StringReplace", "[", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"StringExpression", "[", 
          RowBox[{
          "\"\<\\!\\(\\*StyleBox[\\\"\>\"", ",", "y___", ",", 
           "\"\<\\\",FontColor->\>\"", ",", "col__", ",", "\"\<]\\)\>\""}], 
          "]"}], "\[RuleDelayed]", "y"}]}], "]"}], "<>", 
      "\"\<\\\",FontColor->\>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"N", "/@", "color"}], "]"}], "<>", "\"\<]\\)\>\""}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ColorString", "[", 
      RowBox[{"x_Symbol", ",", "color_"}], "]"}], ":=", 
     RowBox[{"ColorString", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "x", "]"}], ",", "color"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ColorString", "[", 
      RowBox[{"x_Integer", ",", "color_"}], "]"}], ":=", 
     RowBox[{"ColorString", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "x", "]"}], ",", "color"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ColorString", "[", 
      RowBox[{"x_", ",", "_"}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"Format", "::", "nouse"}], ",", 
         "\"\<xTensor`Private`ColorString\>\"", ",", "x"}], "]"}], ";", "x"}],
       ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"ColorString", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "ColorString", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"49975df8-094a-45d0-ae49-e76da2f4aca7"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"29eff4c0-811d-4b96-9125-7206da95eba4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorString", "[", 
  RowBox[{
   RowBox[{"Underline", "[", "a", "]"}], ",", 
   RowBox[{"Hue", "[", "0", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"a0954fbe-e843-445a-a299-51749cbbb2c7"],

Cell[BoxData["\<\"\\!\\(\\*StyleBox[\\\"\\!\\(a\\+_\\)\\\",FontColor->Hue[0.]]\
\\)\"\>"], "Output",ExpressionUUID->"289a835f-8661-452b-85fa-623598597a51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underline", "[", 
  RowBox[{"ColorString", "[", 
   RowBox[{"a", ",", 
    RowBox[{"Hue", "[", "0", "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"0145e0ac-130b-4175-bbcf-88fe98b010c0"],

Cell[BoxData["\<\"\\!\\(\\!\\(\\*StyleBox[\\\"a\\\",FontColor->Hue[0.]]\\)\\+_\
\\)\"\>"], "Output",ExpressionUUID->"2b536efd-11cc-4a92-b945-9add1bf4e925"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorString", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"Hue", "[", "0", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"00a0f7d5-1780-4946-8ba6-9c66a763f297"],

Cell[BoxData["\<\"\\!\\(\\*StyleBox[\\\"-1\\\",FontColor->Hue[0.]]\\)\"\>"], \
"Output",ExpressionUUID->"6d952c4a-18b6-4e72-9a23-42adf698c8a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorString", "[", 
  RowBox[{"a", ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"157efe9c-9d09-4696-a4d1-a20a6202c0fa"],

Cell[BoxData["\<\"\\!\\(\\*StyleBox[\\\"a\\\",FontColor->RGBColor[0., 1., \
0.]]\\)\"\>"], "Output",ExpressionUUID->"fc907353-0330-43f2-9a30-67fb1338d4f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorString", "[", 
   RowBox[{"\"\<\[EmptyDownTriangle]\>\"", ",", 
    RowBox[{"Hue", "[", "0", "]"}]}], "]"}], "<>", 
  "\"\<Hello\>\""}]], \
"Input",ExpressionUUID->"e2994a87-e628-4c33-991e-2b5fa0fbfc26"],

Cell[BoxData["\<\"\\!\\(\\*StyleBox[\\\"\[EmptyDownTriangle]\\\",FontColor->\
Hue[0.]]\\)Hello\"\>"], \
"Output",ExpressionUUID->"9aac8b44-9f69-4bc5-ada3-e3bcf1e979a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"0d1ae015-2500-44f5-a42f-fad715354198"],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(\\*StyleBox[\\\"\\[EmptyDownTriangle]\\\",FontColor->Hue[0.]]\\)\
Hello\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"a5436c0c-bdb2-4e54-a231-542e3ccae9d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorString", "[", 
   RowBox[{"\"\<\[EmptyDownTriangle]\[EmptyDownTriangle]\>\"", ",", 
    RowBox[{"Hue", "[", "0", "]"}]}], "]"}], "<>", 
  "\"\<Hello\>\""}]], \
"Input",ExpressionUUID->"f8415cd5-f38f-4dde-a4f1-05788fec2ffa"],

Cell[BoxData["\<\"\\!\\(\\*StyleBox[\\\"\[EmptyDownTriangle]\
\[EmptyDownTriangle]\\\",FontColor->Hue[0.]]\\)Hello\"\>"], \
"Output",ExpressionUUID->"e861ab26-fba2-497b-b9fd-c8ba9220f358"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorString", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"1fb9a810-9fcf-49c1-b9ad-6c0cf51b244a"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Format", "::", "nouse"}], "MessageName"], ":", 
  " ", "\<\"Attempting to apply \
\[NoBreak]\\!\\(\\\"xTensor`Private`ColorString\\\"\\)\[NoBreak] on \
\[NoBreak]\\!\\(-a\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Format\\\", ButtonNote -> \
\\\"Format::nouse\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"6225dcaf-9ceb-48ba-847f-42ca9edab33b"],

Cell[BoxData[
 RowBox[{"-", 
  "a"}]], "Output",ExpressionUUID->"1c5250a8-ce86-4d52-894f-048e84ac3a25"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorString", "[", 
  RowBox[{
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"338e07a1-e7a2-4548-881a-c43541dc0a44"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Format", "::", "nouse"}], "MessageName"], ":", 
  " ", "\<\"Attempting to apply \
\[NoBreak]\\!\\(\\\"xTensor`Private`ColorString\\\"\\)\[NoBreak] on \
\[NoBreak]\\!\\(a + b\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Format\\\", ButtonNote -> \
\\\"Format::nouse\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"568c5684-ffc6-463f-b9d8-ac40a6265b53"],

Cell[BoxData[
 RowBox[{"a", "+", 
  "b"}]], "Output",ExpressionUUID->"29a36081-a274-4bd6-a236-fc4dded5b9b6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"a", ",", "b"}], 
  "]"}]], "Input",ExpressionUUID->"4770209a-1782-413d-ac14-9d81ebb44402"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"cd49b4bf-44f5-4f8f-afd1-e1eb29de01ea"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7.4. Overlining strings: Overline", \
"Subsubsection",ExpressionUUID->"ee6baffd-fcfe-4979-9901-21ce3e6ad544"],

Cell["We shall use overlining for some daggered expressions:", \
"Text",ExpressionUUID->"597b6e53-0ee3-4a42-ac7f-60f6fb57bcea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Overline"}]], \
"Input",ExpressionUUID->"7db10edf-c022-4bd0-957e-c580f662f496"],

Cell[BoxData[
 StyleBox["\<\"Underline[x] returns a string with x underlined. The string \
form of x must not contain blanks. Underline[x, color] prints colored \
underlines (but x is not colored).\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974382-4493425",ExpressionUUID->"16ac2ee3-5fd6-40e5-9fda-\
cb7da87331e0"]
}, Open  ]],

Cell["One argument:", \
"Text",ExpressionUUID->"63006a25-de99-4012-93ca-5eb21f8557be"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Format", "::", "blank"}], "=", 
   "\"\<Empty string cannot be `1`.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Overline", "[", "\"\<\>\"", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Format", "::", "blank"}], ",", "\"\<overlined\>\""}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Overline", "[", "x_String", "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", "\"\<\\&_\\)\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Overline", "[", "x_", "]"}], ":=", 
   RowBox[{"Overline", "[", 
    RowBox[{"ToString", "[", "x", "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"485c8eb3-b916-4cad-9d72-f7fd83e2f400"],

Cell["Two arguments (colored line):", \
"Text",ExpressionUUID->"98d60a55-bc68-4904-bc1c-2d24854a30a7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Overline", "[", 
    RowBox[{"\"\<\>\"", ",", "color_"}], "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Format", "::", "blank"}], ",", "\"\<overlined\>\""}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Overline", "[", 
    RowBox[{"x_String", ",", "color_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "\"\<\\!\\(\>\"", ",", "x", ",", 
     "\"\<\\&\\*StyleBox[\\(_\\),FontColor->\>\"", ",", 
     RowBox[{"ToString", "[", "color", "]"}], ",", "\"\<]\\)\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Overline", "[", 
    RowBox[{"x_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"Overline", "[", 
    RowBox[{
     RowBox[{"ToString", "[", "x", "]"}], ",", "color"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Overline", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unprotect", "[", "Overline", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"65f7b1f9-f9b1-4349-8c8c-9c2f5b80be92"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"90bf19cb-9fd8-45df-a3bb-1629906cc47c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Overline", "[", "hello", 
  "]"}]], "Input",ExpressionUUID->"08a8f5d2-0175-4063-a233-e76d7ee7835e"],

Cell[BoxData["\<\"\\!\\(\\*OverscriptBox[\\(hello\\),\\(_\\)]\\)\"\>"], \
"Output",ExpressionUUID->"fc9d4cb7-6b63-436e-8248-0b0f122be105"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Overline", "[", "\"\<hello\>\"", 
  "]"}]], "Input",ExpressionUUID->"62c0ac12-be1e-4eb6-a54f-6d5136cba5e0"],

Cell[BoxData["\<\"\\!\\(\\*OverscriptBox[\\(hello\\),\\(_\\)]\\)\"\>"], \
"Output",ExpressionUUID->"7482f6dc-41ec-45bb-9132-334bdbe2dbaa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"36ff014f-52a2-47ad-9657-7f140875e856"],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(\\*OverscriptBox[\\(hello\\),\\(_\\)]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"93342346-735e-45b9-a633-fb534cb3aa83"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Overline", "[", "\"\<ab\>\"", 
  "]"}]], "Input",ExpressionUUID->"63336d7a-0ff1-44c4-afc8-60b0a797d106"],

Cell[BoxData["\<\"\\!\\(\\*OverscriptBox[\\(ab\\),\\(_\\)]\\)\"\>"], \
"Output",ExpressionUUID->"4e1279cd-d218-4620-9586-de075a40c5e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"c772e1c0-a2aa-45e8-b085-2fe3d2c7eb7b"],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(\\*OverscriptBox[\\(ab\\),\\(_\\)]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"948f0c07-b5a6-4dd3-8152-454a4291f55d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "Overline", "[", "\"\<\>\"", 
   "]"}]}]], "Input",ExpressionUUID->"734d1c8d-ea39-4b1b-b361-c1b2bae83eb6"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Format", "::", "blank"}], "MessageName"], ":", 
  " ", "\<\"Empty string cannot be \[NoBreak]\\!\\(\\\"overlined\\\"\\)\
\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Format\\\", ButtonNote -> \
\\\"Format::blank\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"523a7fae-eb61-41f5-8169-91de8f8045b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Overline", "[", 
  RowBox[{"\"\<hello\>\"", ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"a1ac6975-3a39-4966-b124-917a89919dd2"],

Cell[BoxData["\<\"\\!\\(\\*OverscriptBox[\\(hello\\),\\(\\*StyleBox[\\(_\\),\
FontColor->RGBColor[1, 0, 0]]\\)],\\)\"\>"], \
"Output",ExpressionUUID->"9be8b0be-5601-4bb3-9f84-1a6f900ba8bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Overline", "[", "\"\<a b\>\"", 
  "]"}]], "Input",ExpressionUUID->"db961ea7-1783-4f74-b4cc-830a89e492de"],

Cell[BoxData["\<\"\\!\\(\\*OverscriptBox[\\(a b\\),\\(_\\)]\\)\"\>"], \
"Output",ExpressionUUID->"df2b0149-b668-4ed3-b178-07bfd7fc2a8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Overline", "[", 
  RowBox[{"a", " ", "b"}], 
  "]"}]], "Input",ExpressionUUID->"32fb0d38-796f-4bf1-a531-29f863594e92"],

Cell[BoxData["\<\"\\!\\(\\*OverscriptBox[\\(a b\\),\\(_\\)]\\)\"\>"], \
"Output",ExpressionUUID->"55ab2f4a-c595-4963-b5e4-0960a8c236c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Overline", "[", "\"\< \>\"", 
  "]"}]], "Input",ExpressionUUID->"92cccff8-b513-4b13-b24f-2f0906d3ce36"],

Cell[BoxData["\<\"\\!\\(\\*OverscriptBox[\\( \\),\\(_\\)]\\)\"\>"], \
"Output",ExpressionUUID->"f1b820a3-395c-4618-9eaf-94b3114f2b61"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"a", ",", "b", ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"b1554598-ba07-4c42-b4ab-ab242377270f"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"54448a6d-efb3-4350-9899-80be9cdec881"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7.5. Hatted strings without blanks: HatString", \
"Subsubsection",ExpressionUUID->"aa1cbe2d-ce43-419e-b120-193ccafc83e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "HatString"}]], \
"Input",ExpressionUUID->"ff819155-a248-43ee-aa0c-c49df7b7443d"],

Cell[BoxData[
 StyleBox["\<\"HatString[x, n] returns a string with n hats over x if n>0 and \
n hats below x if n<0. When n is not an integer, n is replaced by 1. \
HatString[x, n, color] prints colored hats (but x is not colored).\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3647792742-7076387",ExpressionUUID->"33b28604-3e18-4bbc-9b73-\
3955cab5e981"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Format", "::", "nhat"}], "=", 
   "\"\<Number of hats `1` should be an integer. Replaced by 1.\>\""}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3803ad36-2628-4549-bc31-707f2a81e2da"],

Cell["One argument:", \
"Text",ExpressionUUID->"ae6c79a8-c0cb-40df-acb5-edc0c9e5d8ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", "x_", "]"}], ":=", 
   RowBox[{"HatString", "[", 
    RowBox[{"x", ",", "1"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d3957c4b-a19d-4852-a2f5-17f50d990537"],

Cell["Two arguments (uncolored hat):", \
"Text",ExpressionUUID->"e05d0b6d-e686-4196-859f-230feaae50e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"\"\<\>\"", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Format", "::", "blank"}], ",", "\"\<hatted\>\""}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_String", ",", "0"}], "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_String", ",", 
     RowBox[{"n_Integer", "?", "Positive"}]}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<\\&^\>\"", ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], ",", "\"\<\\)\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_String", ",", 
     RowBox[{"n_Integer", "?", "Negative"}]}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<\\+^\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"-", "n"}], "}"}]}], "]"}], ",", "\"\<\\)\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_String", ",", "n_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"Format", "::", "nhat"}], ",", "n"}], "]"}], ";", 
     RowBox[{"HatString", "[", 
      RowBox[{"x", ",", "1"}], "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"HatString", "[", 
    RowBox[{
     RowBox[{"ToString", "[", "x", "]"}], ",", "n"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e0f57720-8aa0-437d-9c81-d7e296135621"],

Cell["Three arguments (colored hat):", \
"Text",ExpressionUUID->"c2f5c038-f520-4afe-9785-573e7ef57cc4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"\"\<\>\"", ",", "n_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Format", "::", "blank"}], ",", "\"\<hatted\>\""}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_String", ",", "0", ",", "color_"}], "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_String", ",", 
     RowBox[{"n_Integer", "?", "Positive"}], ",", "color_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"colorhat", "=", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\&\\*StyleBox[\\\"^\\\",FontColor->\>\"", ",", 
         RowBox[{"ToString", "[", "color", "]"}], ",", "\"\<]\>\""}], "]"}]}],
       "}"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"colorhat", ",", 
         RowBox[{"{", "n", "}"}]}], "]"}], ",", "\"\<\\)\>\""}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_String", ",", 
     RowBox[{"n_Integer", "?", "Negative"}], ",", "color_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"colorhat", "=", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\+\\*StyleBox[\\\"^\\\",FontColor->\>\"", ",", 
         RowBox[{"ToString", "[", "color", "]"}], ",", "\"\<]\>\""}], "]"}]}],
       "}"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<\\!\\(\>\"", ",", "x", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"colorhat", ",", 
         RowBox[{"{", 
          RowBox[{"-", "n"}], "}"}]}], "]"}], ",", "\"\<\\)\>\""}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_String", ",", "n_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"Format", "::", "nhat"}], ",", "n"}], "]"}], ";", 
     RowBox[{"TildeString", "[", 
      RowBox[{"x", ",", "1", ",", "color"}], "]"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HatString", "[", 
    RowBox[{"x_", ",", "n_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"HatString", "[", 
    RowBox[{
     RowBox[{"ToString", "[", "x", "]"}], ",", "n", ",", "color"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"HatString", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "HatString", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5159bd64-3ac7-49ef-89bb-66fa8770a43a"],

Cell["Examples:", \
"Text",ExpressionUUID->"36236ff3-5170-44b4-adc6-6c0eef3c3e13"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"64b1bceb-959a-48ae-83e5-f797e1625bc6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HatString", "[", 
  RowBox[{"x", ",", "3"}], 
  "]"}]], "Input",ExpressionUUID->"f181abf3-2fa1-4c0c-9250-72e5a63e1929"],

Cell[BoxData["\<\"\\!\\(x\\&^\\&^\\&^\\)\"\>"], \
"Output",ExpressionUUID->"44da11c5-bb61-47dd-99c6-905f2ca223c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"df62abb6-1ad7-435a-8858-210b8d592db2"],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(x\\&^\\&^\\&^\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"24214fd6-6bcb-47dc-8657-179e64131fb3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HatString", "[", 
  RowBox[{"x", ",", 
   RowBox[{"-", "3"}]}], 
  "]"}]], "Input",ExpressionUUID->"6b12cdf3-bf00-4965-8a79-b1eee39731ec"],

Cell[BoxData["\<\"\\!\\(x\\+^\\+^\\+^\\)\"\>"], \
"Output",ExpressionUUID->"43e5b1b4-ded5-4d8f-a5b8-de017e328ead"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"bbc53289-4a26-4fc1-bd26-9f22489087f7"],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(x\\+^\\+^\\+^\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"d4249496-8ee1-49af-ad5d-bb9051e7be85"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HatString", "[", 
  RowBox[{"x", ",", "3", ",", 
   RowBox[{"Hue", "[", "0", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"bd47aba6-b538-4559-a659-a3d25fa5757a"],

Cell[BoxData["\<\"\\!\\(x\\&\\*StyleBox[\\\"^\\\",FontColor->Hue[0]]\\&\\*\
StyleBox[\\\"^\\\",FontColor->Hue[0]]\\&\\*StyleBox[\\\"^\\\",FontColor->Hue[\
0]]\\)\"\>"], \
"Output",ExpressionUUID->"c96f04bc-d3e2-44c0-90a9-628199031134"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"2cf6ed3d-44c1-4c99-b82c-5a20c4e5f4b2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(x\\&\\*StyleBox[\\\"^\\\",FontColor->Hue[0]]\\&\\*StyleBox[\\\"^\
\\\",FontColor->Hue[0]]\\&\\*StyleBox[\\\"^\\\",FontColor->Hue[0]]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"6212e598-25f3-4f36-95a7-627362f3fcbb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HatString", "[", 
  RowBox[{"x", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"Hue", "[", "0", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"e79c758a-8e30-437f-9276-b73a42c018ea"],

Cell[BoxData["\<\"\\!\\(x\\+\\*StyleBox[\\\"^\\\",FontColor->Hue[0]]\\+\\*\
StyleBox[\\\"^\\\",FontColor->Hue[0]]\\+\\*StyleBox[\\\"^\\\",FontColor->Hue[\
0]]\\)\"\>"], \
"Output",ExpressionUUID->"98ce9f33-a42b-43b2-84f3-e1a1101ae9a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"887e1cf4-d0a8-435f-b4b0-03bc51e51e51"],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\"\<\\!\\(x\\+\\*StyleBox[\\\"^\\\",FontColor->Hue[0]]\\+\\*StyleBox[\\\"^\
\\\",FontColor->Hue[0]]\\+\\*StyleBox[\\\"^\\\",FontColor->Hue[0]]\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"22ca7d1f-984a-418c-98f6-7fb0d76f95b7"]
}, Open  ]],

Cell["Error messages:", \
"Text",ExpressionUUID->"38b97e1e-a20d-498a-949d-5892a1ee2978"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HatString", "[", 
  RowBox[{"x", ",", 
   RowBox[{"1", "/", "2"}]}], 
  "]"}]], "Input",ExpressionUUID->"63dfd972-d747-4a93-ac2f-d6db5806464c"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Format", "::", "nhat"}], "MessageName"], ":", 
  " ", "\<\"Number of hats \[NoBreak]\\!\\(1\\/2\\)\[NoBreak] should be an \
integer. Replaced by 1. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Format\\\", ButtonNote -> \\\"Format::nhat\\\"]\\)\
\"\>"}]], "Message", \
"MSG",ExpressionUUID->"5ea50f11-c1b1-4150-88c6-1eb64fd2dc01"],

Cell[BoxData["\<\"\\!\\(x\\&^\\)\"\>"], \
"Output",ExpressionUUID->"a44b8810-8fdc-4736-a0b1-a246e06cdba3"]
}, Open  ]],

Cell["Again, the blank is not detected:", \
"Text",ExpressionUUID->"02da6d8f-0a02-48fc-86e5-4f9db8bc5365"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HatString", "[", 
  RowBox[{
   RowBox[{"x", " ", "x"}], ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"8c1d1915-c1ed-4b5c-9ea7-7a1102754e3a"],

Cell[BoxData["\<\"\\!\\( 2\\nx\\&^\\)\"\>"], \
"Output",ExpressionUUID->"36d8ddbe-9c83-4f6e-8a62-3ab73c98fd16"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HatString", "[", 
  RowBox[{"\"\<x x\>\"", ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"aff31041-7cdd-43f3-b3cf-918a7047939a"],

Cell[BoxData["\<\"\\!\\(x x\\&^\\)\"\>"], \
"Output",ExpressionUUID->"e1a4bf29-28a4-4387-8f75-58c942764775"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "x", 
  "]"}]], "Input",ExpressionUUID->"9c5d3b2f-99c2-4854-bc7c-df0843559a1b"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"0609007c-0b1e-4029-bc17-d4ee851c9937"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.8. xUpvalues", \
"Subsection",ExpressionUUID->"594ceeae-76fd-471c-a696-68719e40a220"],

Cell[CellGroupData[{

Cell["xUpSet", \
"Subsubsection",ExpressionUUID->"2eeaa2a2-ad59-43e0-a0b5-f8efb3279db7"],

Cell["\<\
We introduce functions that generalize UpSet, UpSetDelayed, AppendTo and \
DeleteCases, dealing with the possibility of having protected symbols. Note \
that we evaluate rhs before the assignment and that xUpAppendTo initializes \
with {} the value of the expression if it does not have a value. Note also \
that xUpSet only accepts as first arguments expressions with a single \
argument, and not several as UpSet does.\
\>", "Text",ExpressionUUID->"b4db1556-ee2b-4037-9af9-88a4d54b4966"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "UpSet"}]], "Input",ExpressionUUID->"03ba0cc9-4dee-4ade-9d5a-b31f10b347e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{StyleBox[\\\"lhs\\\", \\\"TI\\\"], \\\"^=\\\", \
StyleBox[\\\"rhs\\\", \\\"TI\\\"]}]\) assigns \!\(\*StyleBox[\\\"rhs\\\", \
\\\"TI\\\"]\) to be the value of \!\(\*StyleBox[\\\"lhs\\\", \\\"TI\\\"]\), \
and associates the assignment with symbols that occur at level one in \
\!\(\*StyleBox[\\\"lhs\\\", \\\"TI\\\"]\). \"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpSet"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974385-4493425",ExpressionUUID->"0acd494d-2b28-4bfd-84e9-\
fbe4dbbc761b"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "UpSet", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldFirst", ",", "Protected", ",", "SequenceHold"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[UpSet],
  Editable->False]], "Print",
 CellTags->
  "Info3567974385-4493425",ExpressionUUID->"7bffca27-2cf8-4069-a8a2-\
030604779313"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xUpSet"}]], "Input",ExpressionUUID->"8fcafc2d-155e-4d3a-9339-30eb66f81a8d"],

Cell[BoxData[
 StyleBox["\<\"xUpSet[f[x], rhs] sets an upvalue for x using UpSet[f[x], rhs] \
but first unprotects x and finally protects it if it was initially protected.\
\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974386-4493425",ExpressionUUID->"23ac7a16-fefd-4490-855c-\
762dad3d9d42"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"xUpSet", ",", 
    RowBox[{"{", 
     RowBox[{"HoldFirst", ",", "SequenceHold"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xUpSet", "[", 
    RowBox[{
     RowBox[{"head_", "[", "symbol_", "]"}], ",", "rhs_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"protected", "=", 
       RowBox[{"Unprotect", "@@", 
        RowBox[{"{", 
         RowBox[{"SubHead", "[", "symbol", "]"}], "}"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"head", "[", "symbol", "]"}], "^=", "rhs"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "protected", "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"head", "[", "symbol", "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xUpSet", "[", 
    RowBox[{"head_", "[", "symbol_", "]"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"subhead", "=", 
        RowBox[{"SubHead", "[", "symbol", "]"}]}], ",", 
       RowBox[{"protected", "=", 
        RowBox[{"Unprotect", "@@", 
         RowBox[{"{", 
          RowBox[{"SubHead", "[", "symbol", "]"}], "}"}]}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TagUnset", "[", 
       RowBox[{"subhead", ",", 
        RowBox[{"head", "[", "symbol", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "protected", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xUpSet", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "xUpSet", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"536aa9b0-24c3-4e0b-a63e-92ca33a49e68"]
}, Closed]],

Cell[CellGroupData[{

Cell["xUpSetDelayed", \
"Subsubsection",ExpressionUUID->"53a4e85f-5333-4ec8-80b6-e0b60c326c61"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "UpSetDelayed"}]], \
"Input",ExpressionUUID->"20f83f9d-4cdf-40b6-992d-59d5753a364b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{StyleBox[\\\"lhs\\\", \\\"TI\\\"], \\\"^:=\\\", \
StyleBox[\\\"rhs\\\", \\\"TI\\\"]}]\) assigns \!\(\*StyleBox[\\\"rhs\\\", \
\\\"TI\\\"]\) to be the delayed value of \!\(\*StyleBox[\\\"lhs\\\", \\\"TI\\\
\"]\), and associates the assignment with symbols that occur at level one in \
\!\(\*StyleBox[\\\"lhs\\\", \\\"TI\\\"]\). \"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpSetDelayed"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3584645980-8211573",ExpressionUUID->"9d51abe6-cc21-4576-9bd7-\
f6e5bfd93385"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "UpSetDelayed", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected", ",", "SequenceHold"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[UpSetDelayed],
  Editable->False]], "Print",
 CellTags->
  "Info3584645980-8211573",ExpressionUUID->"98237c0a-1350-43c1-a399-\
cc8df5b17e6a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xUpSet"}]], "Input",ExpressionUUID->"3efd4af8-6340-4772-bc78-fea5a4bd47e9"],

Cell[BoxData[
 StyleBox["\<\"xUpSet[f[x], rhs] sets an upvalue for x using UpSet[f[x], rhs] \
but first unprotects x and finally protects it if it was initially protected.\
\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974386-4493425",ExpressionUUID->"77c6de12-7ee8-48a9-a3fa-\
ef01c40aad4a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"xUpSetDelayed", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "SequenceHold"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xUpSetDelayed", "[", 
    RowBox[{
     RowBox[{"head_", "[", "symbol_", "]"}], ",", "rhs_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"protected", "=", 
       RowBox[{"Unprotect", "@@", 
        RowBox[{"{", 
         RowBox[{"SubHead", "[", "symbol", "]"}], "}"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"head", "[", "symbol", "]"}], "^:=", "rhs"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "protected", "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"head", "[", "symbol", "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xUpSetDelayed", "[", 
    RowBox[{"head_", "[", "symbol_", "]"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"subhead", "=", 
        RowBox[{"SubHead", "[", "symbol", "]"}]}], ",", 
       RowBox[{"protected", "=", 
        RowBox[{"Unprotect", "@@", 
         RowBox[{"{", 
          RowBox[{"SubHead", "[", "symbol", "]"}], "}"}]}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TagUnset", "[", 
       RowBox[{"subhead", ",", 
        RowBox[{"head", "[", "symbol", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "protected", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xUpSetDelayed", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "xUpSetDelayed", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"82846b3a-ecf0-4986-ae5f-d36772637af0"]
}, Closed]],

Cell[CellGroupData[{

Cell["xUpAppendTo", \
"Subsubsection",ExpressionUUID->"ce9e00a9-61ef-4df3-afb0-4ad9d8dd9f9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "AppendTo"}]], \
"Input",ExpressionUUID->"3f27c4e5-1aa6-4162-ab65-51971cb7aec4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"AppendTo\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"s\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"elem\\\", \\\
\"TI\\\"]}], \\\"]\\\"}]\) appends \!\(\*StyleBox[\\\"elem\\\", \\\"TI\\\"]\) \
to the value of \!\(\*StyleBox[\\\"s\\\", \\\"TI\\\"]\), and resets \
\!\(\*StyleBox[\\\"s\\\", \\\"TI\\\"]\) to the result. \"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppendTo"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974386-4493425",ExpressionUUID->"daacb14b-c0f7-49dd-b33c-\
8f8b7573a89b"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "AppendTo", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldFirst", ",", "Protected"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[AppendTo],
  Editable->False]], "Print",
 CellTags->
  "Info3567974386-4493425",ExpressionUUID->"c4081c2f-076b-4479-805a-\
360bd4a91bb4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xUpAppendTo"}]], \
"Input",ExpressionUUID->"0d14f33c-79bc-4d2e-be94-a5cb3c6103e3"],

Cell[BoxData[
 StyleBox["\<\"xUpAppendTo[f[x], e] assumes that f[x] is a list of elements \
associated to x as an upvalue and appends the element e to it, resetting the \
association. If f[x] does not have a value, it is initialized in the first \
place to {}.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974387-4493425",ExpressionUUID->"a0ec08d9-6f91-49bf-8ed8-\
e16c76bf527b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"xUpAppendTo", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xUpAppendTo", "[", 
    RowBox[{
     RowBox[{"head_", "[", "symbol_", "]"}], ",", "element_"}], "]"}], ":=", 
   RowBox[{"xUpSet", "[", 
    RowBox[{
     RowBox[{"head", "[", "symbol", "]"}], ",", 
     RowBox[{"Append", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ValueQ", "[", 
          RowBox[{"head", "[", "symbol", "]"}], "]"}], ",", 
         RowBox[{"head", "[", "symbol", "]"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", "element"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xUpAppendTo", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "xUpAppendTo", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5c1f4019-f615-4628-8587-9502e0e94f25"]
}, Closed]],

Cell[CellGroupData[{

Cell["xUpDeleteCases", \
"Subsubsection",ExpressionUUID->"1ad40269-931b-4c41-92ba-b24f1cc42cb0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "DeleteCases"}]], \
"Input",ExpressionUUID->"71373781-2545-4601-873b-ca309acec9a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"DeleteCases\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"pattern\\\
\", \\\"TI\\\"]}], \\\"]\\\"}]\) removes all elements of \
\!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) that match \
\!\(\*StyleBox[\\\"pattern\\\", \\\"TI\\\"]\). \
\\n\!\(\*RowBox[{\\\"DeleteCases\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"pattern\\\
\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"levelspec\\\", \\\"TI\\\"]}], \
\\\"]\\\"}]\) removes all parts of \!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) \
on levels specified by \!\(\*StyleBox[\\\"levelspec\\\", \\\"TI\\\"]\) that \
match \!\(\*StyleBox[\\\"pattern\\\", \\\"TI\\\"]\). \
\\n\!\(\*RowBox[{\\\"DeleteCases\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"pattern\\\
\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"levelspec\\\", \\\"TI\\\"], \
\\\",\\\", StyleBox[\\\"n\\\", \\\"TI\\\"]}], \\\"]\\\"}]\) removes the first \
\!\(\*StyleBox[\\\"n\\\", \\\"TI\\\"]\) parts of \!\(\*StyleBox[\\\"expr\\\", \
\\\"TI\\\"]\) that match \!\(\*StyleBox[\\\"pattern\\\", \\\"TI\\\"]\). \"\>",
    "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteCases"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974387-4493425",ExpressionUUID->"a11537f0-8423-4e10-9ac4-\
a8bffa2f2c13"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "DeleteCases", "]"}], "=", 
      RowBox[{"{", "Protected", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "DeleteCases", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"Heads", "\[Rule]", "False"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[DeleteCases],
  Editable->False]], "Print",
 CellTags->
  "Info3567974387-4493425",ExpressionUUID->"364261a4-f12e-4075-9316-\
29f1d74e7358"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xUpDeleteCasesTo"}]], \
"Input",ExpressionUUID->"a44c899d-1b75-43cf-b954-4792d2c65f7e"],

Cell[BoxData[
 StyleBox["\<\"xUpDeleteCasesTo[f[x], cases] assumes that f[x] is a list of \
elements associated to x as an upvalue and removes cases from the list, \
resetting the association.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974388-4493425",ExpressionUUID->"50cbfc53-ea71-4463-a81c-\
61b6d952185f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"xUpDeleteCasesTo", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xUpDeleteCasesTo", "[", 
    RowBox[{
     RowBox[{"head_", "[", "symbol_", "]"}], ",", "cases_"}], "]"}], ":=", 
   RowBox[{"xUpSet", "[", 
    RowBox[{
     RowBox[{"head", "[", "symbol", "]"}], ",", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"head", "[", "symbol", "]"}], ",", "cases"}], "]"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xUpDeleteCasesTo", ",", "2"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "xUpDeleteCasesTo", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e1662da4-3a89-43d7-a9c7-6a45ab63587c"]
}, Closed]],

Cell[CellGroupData[{

Cell["xTagSet", \
"Subsubsection",ExpressionUUID->"f6539637-f381-4953-9b05-18dcf4cbf504"],

Cell["\<\
Now we do the same for the Tag functions. Note the following absurd point: \
All Set functions hold their first argument only, and the SetDelayed \
functions hold all arguments. However, both TagSet and TagSetDelayed hold all \
arguments. I do not want to do that, because then TagSet and TagSetDelayed \
are equivalent. Therefore we slightly modify the notation to pack together \
the arguments to be held:\
\>", "Text",ExpressionUUID->"a624a6d6-68b9-45c5-a1c4-21cde32f71a9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "TagSet"}]], "Input",ExpressionUUID->"f4143b73-fd56-4f58-a968-11c31d938e5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\"/:\\\", \
StyleBox[\\\"lhs\\\", \\\"TI\\\"], \\\"=\\\", StyleBox[\\\"rhs\\\", \
\\\"TI\\\"]}]\) assigns \!\(\*StyleBox[\\\"rhs\\\", \\\"TI\\\"]\) to be the \
value of \!\(\*StyleBox[\\\"lhs\\\", \\\"TI\\\"]\), and associates the \
assignment with the symbol \!\(\*StyleBox[\\\"f\\\", \\\"TI\\\"]\). \"\>", 
   "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974388-4493425",ExpressionUUID->"b44079b9-81ee-4ed6-8ec3-\
c80889dc3a10"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "TagSet", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected", ",", "SequenceHold"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[TagSet],
  Editable->False]], "Print",
 CellTags->
  "Info3567974388-4493425",ExpressionUUID->"520968b1-5206-47e2-bf9e-\
5a14c89782ad"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xTagSet"}]], \
"Input",ExpressionUUID->"4fe4417d-450c-43fe-979e-5ad969489859"],

Cell[BoxData[
 StyleBox["\<\"xTagSet[{f, lhs}, rhs] assigns rhs to be the value of lhs, and \
associates the assignment with the symbol f. There are two differences with \
TagSet: 1) The symbol f is unprotected and later protected again if required; \
2) xTagSet evaluates rhs (consistently with all other Set functions), but \
TagSet does not evaluate it!\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974389-4493425",ExpressionUUID->"4868e5df-27d3-48e9-8a38-\
42babfa8e55a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SubHead", "[", "symbol_Symbol", "]"}], ":=", "symbol"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SubHead", "[", "expr_", "]"}], ":=", 
   RowBox[{"NestWhile", "[", 
    RowBox[{"Head", ",", "expr", ",", 
     RowBox[{"Function", "[", 
      RowBox[{"!", 
       RowBox[{"AtomQ", "[", "#", "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"a6a8538e-4584-417d-9253-b93e8192510b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"xTagSet", ",", 
    RowBox[{"{", 
     RowBox[{"HoldFirst", ",", "SequenceHold"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTagSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"expr_", ",", "lhs_"}], "}"}], ",", "rhs_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"symbol", "=", 
       RowBox[{"SubHead", "[", "expr", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"protected", "=", 
         RowBox[{"Unprotect", "[", "symbol", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"TagSet", "[", 
         RowBox[{"symbol", ",", "lhs", ",", "rhs"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Protect", "[", "protected", "]"}], ";", 
        "\[IndentingNewLine]", "rhs"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xTagSet", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "xTagSet", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7df7c30a-290b-459f-b46c-15c0b90adc43"]
}, Closed]],

Cell[CellGroupData[{

Cell["xTagSetDelayed", \
"Subsubsection",ExpressionUUID->"e4a763ff-21c1-4edf-99c4-9823702fec14"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "TagSetDelayed"}]], \
"Input",ExpressionUUID->"b68b7579-fcb2-419f-a688-10f715de52b1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{StyleBox[\\\"f\\\", \\\"TI\\\"], \\\"/:\\\", \
StyleBox[\\\"lhs\\\", \\\"TI\\\"], \\\":=\\\", StyleBox[\\\"rhs\\\", \\\"TI\\\
\"]}]\) assigns \!\(\*StyleBox[\\\"rhs\\\", \\\"TI\\\"]\) to be the delayed \
value of \!\(\*StyleBox[\\\"lhs\\\", \\\"TI\\\"]\), and associates the \
assignment with the symbol \!\(\*StyleBox[\\\"f\\\", \\\"TI\\\"]\). \"\>", 
   "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSetDelayed"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974389-4493425",ExpressionUUID->"7db40a2b-90e2-4d85-93ab-\
432c4598b7f9"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "TagSetDelayed", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected", ",", "SequenceHold"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[TagSetDelayed],
  Editable->False]], "Print",
 CellTags->
  "Info3567974389-4493425",ExpressionUUID->"16c8486d-22a1-4e98-85e5-\
403eda83781b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xTagSetDelayed"}]], \
"Input",ExpressionUUID->"65172575-505a-4f31-9ae4-a7f827a4199d"],

Cell[BoxData[
 StyleBox["\<\"xTagSetDelayed[{f, lhs}, rhs] assigns rhs to be the delayed \
value of lhs, and associates the assignment with the symbol f. The only \
difference with TagSetDelayed is that the symbol f is unprotected and later \
protected again if required.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974390-4493425",ExpressionUUID->"e8112e88-e919-4598-b329-\
a9dc2945a96b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"xTagSetDelayed", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "SequenceHold"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTagSetDelayed", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"expr_", ",", "lhs_"}], "}"}], ",", "rhs_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"symbol", "=", 
       RowBox[{"SubHead", "[", "expr", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"protected", "=", 
         RowBox[{"Unprotect", "[", "symbol", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"TagSetDelayed", "[", 
         RowBox[{"symbol", ",", "lhs", ",", "rhs"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Protect", "[", "protected", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xTagSetDelayed", ",", "2"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "xTagSetDelayed", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e7455053-4f72-41e2-bf5d-997093c05e8a"]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", \
"Subsubsection",ExpressionUUID->"6d1ef68d-0aa3-4b0a-af0f-072a5c4e61c9"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"fd6f7184-9b03-40bf-80e0-6c1e04d928df"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"example", "[", "pp", "]"}], "^=", 
   RowBox[{"{", "hello1", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"example", ",", "pp"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"xUpAppendTo", "[", 
  RowBox[{
   RowBox[{"example", "[", "pp", "]"}], ",", "hello2"}], 
  "]"}]}], "Input",ExpressionUUID->"f6b6b20b-8670-4267-861d-3089dc35a3fa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"hello1", ",", "hello2"}], 
  "}"}]], "Output",ExpressionUUID->"2fd1adde-bb92-4519-bc44-48f8fe9dd560"]
}, Open  ]],

Cell["\<\
If the expression does not have a value, it is initialized to the empty list:\
\
\>", "Text",ExpressionUUID->"c1d33b40-10ac-4d3f-8542-0814b7bca16b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Protect", "[", "example2", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"xUpAppendTo", "[", 
  RowBox[{
   RowBox[{"example2", "[", "pp", "]"}], ",", "hello3"}], 
  "]"}]}], "Input",ExpressionUUID->"1c83e000-e677-4dc5-b9ae-0af6cb0690b9"],

Cell[BoxData[
 RowBox[{"{", "hello3", 
  "}"}]], "Output",ExpressionUUID->"c50ef35c-b437-4b04-b098-ae38c7169205"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "pp"}]], "Input",ExpressionUUID->"eefa5a35-ff48-4f09-b5f7-1ea757ff956d"],

Cell[CellGroupData[{

Cell["Global`pp", "Print", "PrintUsage",
 CellTags->
  "Info3567974390-4493425",ExpressionUUID->"1452de10-20ae-4433-8a28-\
3adc772aeb5f"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "pp", "]"}], "=", 
      RowBox[{"{", "Protected", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"example", "[", "pp", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"hello1", ",", "hello2"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"example2", "[", "pp", "]"}], "^=", 
         RowBox[{"{", "hello3", "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`pp],
  Editable->False]], "Print",
 CellTags->
  "Info3567974390-4493425",ExpressionUUID->"d57e6865-8bb8-4b72-8c17-\
d2b88b4f909d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xUpDeleteCasesTo", "[", 
  RowBox[{
   RowBox[{"example", "[", "pp", "]"}], ",", "hello1"}], 
  "]"}]], "Input",ExpressionUUID->"d248a840-4550-459b-98b5-7e4a79352633"],

Cell[BoxData[
 RowBox[{"{", "hello2", 
  "}"}]], "Output",ExpressionUUID->"8349f8cc-853d-4b32-85c9-451c3847ffa2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "pp"}]], "Input",ExpressionUUID->"0c1c0d48-e07f-4684-bbac-e6fbace40df7"],

Cell[CellGroupData[{

Cell["Global`pp", "Print", "PrintUsage",
 CellTags->
  "Info3567974391-4493425",ExpressionUUID->"1e0a9e9c-910e-42d9-9058-\
0543aff7d431"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "pp", "]"}], "=", 
      RowBox[{"{", "Protected", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"example", "[", "pp", "]"}], "^=", 
         RowBox[{"{", "hello2", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"example2", "[", "pp", "]"}], "^=", 
         RowBox[{"{", "hello3", "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`pp],
  Editable->False]], "Print",
 CellTags->
  "Info3567974391-4493425",ExpressionUUID->"97bdb305-0d2b-475c-98d4-\
c58ea102cf31"]
}, Open  ]]
}, Closed]],

Cell["If the expression does not have a value, nothing happens:", \
"Text",ExpressionUUID->"0d32ef0d-b115-495f-9abe-8ba87ecce458"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xUpDeleteCasesTo", "[", 
  RowBox[{
   RowBox[{"example3", "[", "pp", "]"}], ",", "hello4"}], 
  "]"}]], "Input",ExpressionUUID->"85784803-e7fc-45b7-89af-819c45be94aa"],

Cell[BoxData[
 RowBox[{"example3", "[", "pp", 
  "]"}]], "Output",ExpressionUUID->"decfe607-01b3-4826-8ee0-96223733801c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{"example", ",", "example2", ",", "pp"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Remove", "[", 
  RowBox[{
  "example", ",", "example2", ",", "example3", ",", "hello1", ",", "hello2", 
   ",", "hello3", ",", "hello4", ",", "pp"}], 
  "]"}]}], "Input",ExpressionUUID->"c824b89b-64d2-4d58-bf4a-fd0ff8bfc5c4"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"4183f8bf-c034-4651-9b04-0056087981c7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.9. On rules", \
"Subsection",ExpressionUUID->"ffa7d2eb-05be-4404-ba58-4f129e4a09ed"],

Cell[CellGroupData[{

Cell["2.9.1. ReplaceLast", \
"Subsubsection",ExpressionUUID->"b47053c0-09cb-4570-9dd9-65a041c52099"],

Cell["\<\
This function maps ReplaceAll with a given set of rules to the last element \
of an expression. It is very useful to replace rules in the rhs of other \
rules. It is not being used right now.\
\>", "Text",ExpressionUUID->"ca9b60d4-8ee9-4216-b19c-e1c4cd540e71"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ReplaceLast", "[", 
    RowBox[{"expr_", ",", "rules_"}], "]"}], ":=", 
   RowBox[{"ReplacePart", "[", 
    RowBox[{"expr", ",", 
     RowBox[{
      RowBox[{"Extract", "[", 
       RowBox[{"expr", ",", 
        RowBox[{"-", "1"}], ",", "Hold"}], "]"}], "/.", "rules"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"ReplaceLast", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ReplaceLast", "]"}], 
  ";"}]}], "Input",ExpressionUUID->"e076a6f7-544b-417f-8227-98b8f6804f79"],

Cell["We do not need to switch to the Global` context here:", \
"Text",ExpressionUUID->"c79b61ca-33f5-4bd0-90d1-6a3b14af5870"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceLast", "[", 
   RowBox[{
    RowBox[{"RuleDelayed", "[", 
     RowBox[{
      RowBox[{"1", "+", "1"}], ",", 
      RowBox[{"1", "+", "1"}]}], "]"}], ",", 
    RowBox[{"1", "\[Rule]", "2"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"b98128f7-b327-4180-8734-b69cb64b1ad6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"1", "+", "1"}],
        HoldForm], ",", 
       TagBox["2",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"2", "\[RuleDelayed]", 
       RowBox[{"1", "+", "1"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"2", "\[RuleDelayed]", 
       RowBox[{"1", "+", "1"}]}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"1", "\[Rule]", "2"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"1", "\[Rule]", "2"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"ReplaceLast", "[", 
     RowBox[{
      RowBox[{"2", "\[RuleDelayed]", 
       RowBox[{"1", "+", "1"}]}], ",", 
      RowBox[{"1", "\[Rule]", "2"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"ReplacePart", "[", 
     RowBox[{
      RowBox[{"2", "\[RuleDelayed]", 
       RowBox[{"1", "+", "1"}]}], ",", 
      RowBox[{
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"2", "\[RuleDelayed]", 
          RowBox[{"1", "+", "1"}]}], ",", 
         RowBox[{"-", "1"}], ",", "Hold"}], "]"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"1", "\[Rule]", "2"}]}], ",", 
      RowBox[{"-", "1"}], ",", "1"}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"Extract", "[", 
         RowBox[{
          RowBox[{"2", "\[RuleDelayed]", 
           RowBox[{"1", "+", "1"}]}], ",", 
          RowBox[{"-", "1"}], ",", "Hold"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Hold", "[", 
         RowBox[{"1", "+", "1"}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"Hold", "[", 
        RowBox[{"1", "+", "1"}], "]"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"1", "\[Rule]", "2"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"Hold", "[", 
       RowBox[{"2", "+", "2"}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"ReplacePart", "[", 
     RowBox[{
      RowBox[{"2", "\[RuleDelayed]", 
       RowBox[{"1", "+", "1"}]}], ",", 
      RowBox[{"Hold", "[", 
       RowBox[{"2", "+", "2"}], "]"}], ",", 
      RowBox[{"-", "1"}], ",", "1"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"2", "\[RuleDelayed]", 
     RowBox[{"2", "+", "2"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"2", "\[RuleDelayed]", 
     RowBox[{"2", "+", "2"}]}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"8b1b94fa-1386-49ed-b0f5-343e2533c4a5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.9.2. MapRule", \
"Subsubsection",ExpressionUUID->"91b348da-41e1-45dd-98cb-f91cc9c4618c"],

Cell["\<\
To act on the left of right hand sides of rules we introduce these two simple \
functions (not being used right now):\
\>", "Text",ExpressionUUID->"6bdbaaa7-ecaf-41e9-9960-0e329d15b27c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "MapRuleR"}]], \
"Input",ExpressionUUID->"ce9dbbba-d79d-4c2d-ab5f-28048f71d789"],

Cell[BoxData[
 StyleBox["\<\"MapRuleR[f, expr] maps f onto the second argument of all Rule \
or RuleDelayed expressions of expr.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974392-4493425",ExpressionUUID->"f57f029c-e0ee-4be0-bc88-\
2a63b45b523b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleR", "[", 
    RowBox[{"f_", ",", "list_List"}], "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MapRuleR", "[", 
       RowBox[{"f", ",", "#"}], "]"}], "&"}], ",", "list"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleR", "[", 
    RowBox[{"f_", ",", 
     RowBox[{"Rule", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"Rule", "[", 
    RowBox[{"x", ",", 
     RowBox[{"f", "[", "y", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleR", "[", 
    RowBox[{"f_", ",", 
     RowBox[{"RuleDelayed", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"RuleDelayed", "[", 
    RowBox[{"x", ",", 
     RowBox[{"f", "[", "y", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleR", "[", 
    RowBox[{"f_", ",", 
     RowBox[{"FoldedRule", "[", 
      RowBox[{"rules__", ",", "last_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"FoldedRule", "[", 
    RowBox[{"rules", ",", 
     RowBox[{"MapRuleR", "[", 
      RowBox[{"f", ",", "last"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleR", "[", 
    RowBox[{"f_", ",", "expr_"}], "]"}], ":=", "expr"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"MapRuleR", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "MapRuleR", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"9f6aecb5-2db5-40e2-b2ac-8a3b9fe73b1d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "MapRuleL"}]], \
"Input",ExpressionUUID->"5c5a9aba-40bc-444c-bad7-27687190b370"],

Cell[BoxData[
 StyleBox["\<\"MapRuleL[f, expr] maps f onto the first argument of all Rule \
or RuleDelayed expressions of expr.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974392-4493425",ExpressionUUID->"61717cb2-69a4-40a2-b6ff-\
e4a967751de2"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleL", "[", 
    RowBox[{"f_", ",", "list_List"}], "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MapRuleL", "[", 
       RowBox[{"f", ",", "#"}], "]"}], "&"}], ",", "list"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleL", "[", 
    RowBox[{"f_", ",", 
     RowBox[{"Rule", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"Rule", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleL", "[", 
    RowBox[{"f_", ",", 
     RowBox[{"RuleDelayed", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"RuleDelayed", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", "y"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleL", "[", 
    RowBox[{"f_", ",", 
     RowBox[{"FoldedRule", "[", 
      RowBox[{"rules__", ",", "last_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"FoldedRule", "[", 
    RowBox[{"rules", ",", 
     RowBox[{"MapRuleL", "[", 
      RowBox[{"f", ",", "last"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MapRuleL", "[", 
    RowBox[{"f_", ",", "expr_"}], "]"}], ":=", "expr"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"MapRuleL", ",", "2"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "MapRuleL", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f097ff4d-d06a-41e7-aa77-cdac193d22f2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.10. FoldedRule", \
"Subsection",ExpressionUUID->"3e76402a-20b1-407e-8355-2223bb450ee6"],

Cell[CellGroupData[{

Cell["2.10.1. Definition", \
"Subsubsection",ExpressionUUID->"e3ab94a5-9c18-42db-ae89-26f9cbfd9b16"],

Cell["\<\
We introduce the useful concept of folded-rules. Note that it can be used \
with both Rule and DelayedRule. These definitions instruct ReplaceAll and \
ReplaceRepeated (but not Replace or ReplaceList) on how to use it:\
\>", "Text",ExpressionUUID->"52f1ea3c-6202-4961-850d-a05ecee01b46"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "FoldedRule"}]], \
"Input",ExpressionUUID->"4ead8f31-ca38-45cf-aa73-9fb6ca6fe45f"],

Cell[BoxData[
 StyleBox["\<\"FoldedRule[rules1, rules2, ...] contains a number of lists of \
rules which are applied sequentially (first rules1, then rules2, etc.) when \
called by ReplaceAll and ReplaceRepeated.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974393-4493425",ExpressionUUID->"d135a8a2-2d35-4a77-82b6-\
072f199bed92"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "FoldedRule", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "OneIdentity"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FoldedRule", "/:", 
   RowBox[{"ReplaceAll", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"FoldedRule", "[", "rules___", "]"}]}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{"ReplaceAll", ",", "expr", ",", 
     RowBox[{"{", "rules", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FoldedRule", "/:", 
   RowBox[{"ReplaceRepeated", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"FoldedRule", "[", "rules___", "]"}]}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{"ReplaceRepeated", ",", "expr", ",", 
     RowBox[{"{", "rules", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "FoldedRule", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"678f4260-ae10-44a6-9ebd-4d70c5cf1b04"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"04ba002f-ae1d-49c4-a63f-b01cda3e287f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  "]"}]], "Input",ExpressionUUID->"c1b60e2f-5d52-4ca3-bf50-092d4fecb9e9"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  "]"}]], "Output",ExpressionUUID->"257f209a-075b-4a80-8797-21cd92985634"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "t"}], "/.", 
  RowBox[{"FoldedRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "y"}], ",", 
      RowBox[{"t", "\[Rule]", "x"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", "\[Rule]", "z"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"28820e77-6f38-4519-8c8c-e7d3ffe7c0a2"],

Cell[BoxData[
 RowBox[{"x", "+", 
  "z"}]], "Output",ExpressionUUID->"da3cceeb-7acc-4cc7-8a20-3e594de21b31"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "//.", 
   RowBox[{"FoldedRule", "[", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "y"}], ",", 
     RowBox[{"y", "\[Rule]", "z"}]}], "]"}]}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"090f9bb4-d543-49fc-84a8-574a57bced08"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"x", "\[Rule]", "y"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"x", "\[Rule]", "y"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"y", "\[Rule]", "z"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"y", "\[Rule]", "z"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"FoldedRule", "[", 
       RowBox[{
        RowBox[{"x", "\[Rule]", "y"}], ",", 
        RowBox[{"y", "\[Rule]", "z"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"x", "//.", "\[VeryThinSpace]", 
     RowBox[{"FoldedRule", "[", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "y"}], ",", 
       RowBox[{"y", "\[Rule]", "z"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Fold", "[", 
     RowBox[{"ReplaceRepeated", ",", "x", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "\[Rule]", "y"}], ",", 
        RowBox[{"y", "\[Rule]", "z"}]}], "}"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"x", "//.", "\[VeryThinSpace]", 
       RowBox[{"x", "\[Rule]", "y"}]}],
      HoldForm], ",", 
     TagBox["y",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"y", "//.", "\[VeryThinSpace]", 
       RowBox[{"y", "\[Rule]", "z"}]}],
      HoldForm], ",", 
     TagBox["z",
      HoldForm]}], "}"}], ",", 
   TagBox["z",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"243f1ecc-fc0a-445a-bffe-ecbc2818667d"]
}, Open  ]],

Cell["Note the Flat attribute:", \
"Text",ExpressionUUID->"d84fcf76-72e5-4235-9d73-967ac9f6706d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{"a", ",", "b", ",", 
   RowBox[{"FoldedRule", "[", 
    RowBox[{"c", ",", 
     RowBox[{"FoldedRule", "[", "d", "]"}]}], "]"}], ",", "e", ",", "f"}], 
  "]"}]], "Input",ExpressionUUID->"d214f0a0-b2b5-495c-ad89-b8feff415ed4"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
  "]"}]], "Output",ExpressionUUID->"176236e4-a471-42cc-80fc-9c99de040cca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "RuleDelayed", 
  "]"}]], "Input",ExpressionUUID->"15fc62be-4f32-4335-9f6e-37064e71f73f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldRest", ",", "Protected", ",", "SequenceHold"}], 
  "}"}]], "Output",ExpressionUUID->"3455d14f-1533-4042-bbfb-6afa06d540b0"]
}, Open  ]],

Cell["\<\
Note that the first 1+1 is not evaluated initially, but the second is, due to \
the HoldRest attribute of RuleDelayed:\
\>", "Text",ExpressionUUID->"3dc46ce3-31cf-4c95-ab19-0e14616a1044"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "+", "t"}], "/.", 
   RowBox[{"FoldedRule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "\[RuleDelayed]", 
       RowBox[{"1", "+", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "+", "1"}], "\[RuleDelayed]", "hello"}], "}"}]}], "]"}]}],
   "//", "Trace"}]], \
"Input",ExpressionUUID->"5470ba19-9ae5-41c8-8127-c5f4e70eec02"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"x", "+", "t"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"t", "+", "x"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"x", "\[RuleDelayed]", 
           RowBox[{"1", "+", "1"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"x", "\[RuleDelayed]", 
           RowBox[{"1", "+", "1"}]}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{"x", "\[RuleDelayed]", 
          RowBox[{"1", "+", "1"}]}], "}"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"1", "+", "1"}],
            HoldForm], ",", 
           TagBox["2",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"2", "\[RuleDelayed]", "hello"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"2", "\[RuleDelayed]", "hello"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{"2", "\[RuleDelayed]", "hello"}], "}"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"FoldedRule", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", "\[RuleDelayed]", 
          RowBox[{"1", "+", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", "\[RuleDelayed]", "hello"}], "}"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"t", "+", "x"}], "/.", "\[VeryThinSpace]", 
     RowBox[{"FoldedRule", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", "\[RuleDelayed]", 
         RowBox[{"1", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", "\[RuleDelayed]", "hello"}], "}"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Fold", "[", 
     RowBox[{"ReplaceAll", ",", 
      RowBox[{"t", "+", "x"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", "\[RuleDelayed]", 
          RowBox[{"1", "+", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", "\[RuleDelayed]", "hello"}], "}"}]}], "}"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"t", "+", "x"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"{", 
        RowBox[{"x", "\[RuleDelayed]", 
         RowBox[{"1", "+", "1"}]}], "}"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"t", "+", 
       RowBox[{"(", 
        RowBox[{"1", "+", "1"}], ")"}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"1", "+", "1"}],
        HoldForm], ",", 
       TagBox["2",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"t", "+", "2"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"2", "+", "t"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"2", "+", "t"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"{", 
        RowBox[{"2", "\[RuleDelayed]", "hello"}], "}"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"hello", "+", "t"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"hello", "+", "t"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"029cc9be-c411-48c9-a3a7-0167858968ff"]
}, Open  ]],

Cell["\<\
QUESTION: There is a problem with lists of rules, and I don't know how to \
solve it:\
\>", "Text",ExpressionUUID->"ea246eec-1a58-4ff9-9034-f09834898bcf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "a"}], ",", 
    RowBox[{"a", "\[Rule]", "b"}], ",", 
    RowBox[{"y", "\[Rule]", "c"}]}], 
   "}"}]}]], "Input",ExpressionUUID->"7d138920-ae9d-4d96-b589-9b0808be9d27"],

Cell[BoxData[
 RowBox[{"a", "+", 
  "c"}]], "Output",ExpressionUUID->"d30cb821-78dd-4828-8866-9d9698668c95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FoldedRule", "[", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "a"}], ",", 
      RowBox[{"a", "\[Rule]", "b"}]}], "]"}], ",", 
    RowBox[{"y", "\[Rule]", "c"}]}], 
   "}"}]}]], "Input",ExpressionUUID->"c60714f7-ca6b-4b89-ac97-26f787851776"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ReplaceAll", "::", "reps"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(\\(FoldedRule[\\(\\(\\(\\(x \[Rule] a\\)\\), \
\\(\\(a \[Rule] b\\)\\)\\)\\)]\\)\\), \\(\\(y \[Rule] c\\)\\)}\\)\[NoBreak] \
is neither a list of replacement rules nor a valid dispatch table, and so \
cannot be used for replacing. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ReplaceAll/reps\\\", ButtonNote -> \
\\\"ReplaceAll::reps\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"c54e64f9-0065-4ba1-956f-c3df15e54aca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "/.", "\[VeryThinSpace]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FoldedRule", "[", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "a"}], ",", 
      RowBox[{"a", "\[Rule]", "b"}]}], "]"}], ",", 
    RowBox[{"y", "\[Rule]", "c"}]}], 
   "}"}]}]], "Output",ExpressionUUID->"6609ebd3-38d9-4b4a-bcf1-64d6ad8c8650"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "hello", ",", 
   "t", ",", "x", ",", "y", ",", "z"}], 
  "]"}]], "Input",ExpressionUUID->"9d3fdc19-76fe-4841-aa7c-8b5fc312f02e"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"455d46ab-491a-4126-bd0f-8b056b566c6a"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.10.2. CollapseFoldedRule", \
"Subsubsection",ExpressionUUID->"d70dfb62-eda8-4ac0-8b24-8c8c38d2a81e"],

Cell["\<\
Sometimes we want to collapse the FoldedRule, obtaining a sequence of lists \
of rules directly in terms of the independent objects. We also introduce an \
intermediate function f which can be used to arrange or simplify intermediate \
steps of the computation. Note that the last set of rules of the FoldedRule \
(the \"independent\" rules) are not touched by this function f.\
\>", "Text",ExpressionUUID->"7aa4ed95-5347-4482-abe4-09d3480bbf7e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"maprule", "[", "f_", "]"}], "[", 
    RowBox[{"head_", "[", 
     RowBox[{"lhs_", ",", "rhs_"}], "]"}], "]"}], ":=", 
   RowBox[{"head", "[", 
    RowBox[{"lhs", ",", 
     RowBox[{"f", "[", "rhs", "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fc9dadc6-de2d-4a60-95c5-154c59788145"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"collapse1", "[", 
    RowBox[{
     RowBox[{"FoldedRuleTMP", "[", "rules_", "]"}], ",", "f_"}], "]"}], ":=", 
   
   RowBox[{"Flatten", "[", 
    RowBox[{"{", "rules", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"collapse1", "[", 
    RowBox[{
     RowBox[{"FoldedRuleTMP", "[", 
      RowBox[{"rules___", ",", "rulesm2_", ",", "rulesm1_"}], "]"}], ",", 
     "f_"}], "]"}], ":=", 
   RowBox[{"FoldedRuleTMP", "[", 
    RowBox[{"rules", ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"maprule", "[", "f", "]"}], ",", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{"rulesm2", "/.", "rulesm1"}], "}"}], "]"}], ",", 
          RowBox[{"{", "1", "}"}]}], "]"}], ",", "rulesm1"}], "}"}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"collapse", "[", 
    RowBox[{
     RowBox[{"FoldedRule", "[", "rules__", "]"}], ",", "f_"}], "]"}], ":=", 
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"collapse1", "[", 
       RowBox[{"#", ",", "f"}], "]"}], "&"}], ",", 
     RowBox[{"FoldedRuleTMP", "[", "rules", "]"}], ",", 
     RowBox[{"Length", "[", 
      RowBox[{"{", "rules", "}"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8b84a34e-3d74-4937-9b5a-2266f2ebc196"],

Cell["\<\
To increase flexibility we imitate the positional notation of Take, and so \
there are lots of different cases:\
\>", "Text",ExpressionUUID->"c2d934f1-7a18-403d-a2b7-96dd909bc0f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "CollapseFoldedRule"}]], \
"Input",ExpressionUUID->"15e7a9cb-1a4a-41b5-a6d6-97c302fb8fc0"],

Cell[BoxData[
 StyleBox["\<\"CollapseFoldedRule[frule, {n, m}] converts the elements n to m \
of the foldedrule frule into a single list of replacements in terms of the \
independent objects at level m. The positional argument follows the notation \
of Take: both n, m or just m can be negative, counting from the end; a single \
positive integer m represents {1, m}; a single negative integer -n represents \
{-n, -1}. A third argument can be given specifying a function to be mapped on \
all rules after collapsing a new level. CollapseFoldedRule[frule] or \
CollapseFoldedRule[frule, All] are interpreted as collapse of all elements of \
frule.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974394-4493425",ExpressionUUID->"3e3ea754-bd43-4ecf-9a52-\
0f862577826f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "::", "pos"}], "=", 
   "\"\<Cannot collapse positions `1`.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "[", "frule_", "]"}], ":=", 
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"Length", "[", "frule", "]"}]}], "}"}], ",", "Identity"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule_", ",", "All", ",", 
     RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"Length", "[", "frule", "]"}]}], "}"}], ",", "f"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule_", ",", 
     RowBox[{"0", "|", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", "frule"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule_", ",", 
     RowBox[{"n_Integer", "?", "Positive"}], ",", 
     RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "n"}], "}"}], ",", "f"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule_", ",", 
     RowBox[{"n_Integer", "?", "Negative"}], ",", 
     RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", "0"}], "}"}], "+", 
      RowBox[{"Length", "[", "frule", "]"}]}], ",", "f"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule_", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"first_Integer", "?", "Negative"}], ",", 
       RowBox[{"last_Integer", "?", "Negative"}]}], "}"}], ",", 
     RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"first", ",", "last"}], "}"}], "+", 
      RowBox[{"Length", "[", "frule", "]"}], "+", "1"}], ",", "f"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule_", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"first_Integer", "?", "Positive"}], ",", 
       RowBox[{"last_Integer", "?", "Negative"}]}], "}"}], ",", 
     RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule", ",", 
     RowBox[{"{", 
      RowBox[{"first", ",", 
       RowBox[{"last", "+", "1", "+", 
        RowBox[{"Length", "[", "frule", "]"}]}]}], "}"}], ",", "f"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule_", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"first_Integer", "?", "Positive"}], ",", 
        RowBox[{"last_Integer", "?", "Positive"}]}], "}"}], "/;", 
      RowBox[{"last", "\[GreaterEqual]", "first"}]}], ",", 
     RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
   RowBox[{"FoldedRule", "[", 
    RowBox[{
     RowBox[{"Take", "[", 
      RowBox[{"frule", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"first", "-", "1"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"collapse", "[", 
      RowBox[{
       RowBox[{"Take", "[", 
        RowBox[{"frule", ",", 
         RowBox[{"{", 
          RowBox[{"first", ",", "last"}], "}"}]}], "]"}], ",", "f"}], "]"}], 
     ",", 
     RowBox[{"Take", "[", 
      RowBox[{"frule", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"last", "+", "1"}], ",", 
         RowBox[{"Length", "[", "frule", "]"}]}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CollapseFoldedRule", "[", 
    RowBox[{"frule_", ",", "positions_", ",", 
     RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"CollapseFoldedRule", "::", "pos"}], ",", "positions"}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"CollapseFoldedRule", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "CollapseFoldedRule", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3a7c48bf-01fd-4c7b-b66d-35851bd547d8"],

Cell["Examples:", \
"Text",ExpressionUUID->"7ff24e4b-591d-4eda-b46e-4d6ddd4551fd"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"eab214d3-acc8-489e-851e-1f0a7313392c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FRule", "=", 
   RowBox[{"FoldedRule", "[", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "b"}], ",", 
     RowBox[{"b", "\[Rule]", "c"}], ",", 
     RowBox[{"c", "\[Rule]", "d"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[Rule]", "e"}], ",", 
       RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
     RowBox[{"e", "\[Rule]", "f"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"28d845c1-d024-41e5-b964-e6f467cd1cdb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}],
     "}"}], "/.", "FRule"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"2ae86411-3d03-4db5-9cfb-50dfe70d31b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox["FRule",
      HoldForm], ",", 
     TagBox[
      RowBox[{"FoldedRule", "[", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "d"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"d", "\[Rule]", "e"}], ",", 
          RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
        RowBox[{"e", "\[Rule]", "f"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
      "}"}], "/.", "\[VeryThinSpace]", 
     RowBox[{"FoldedRule", "[", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "b"}], ",", 
       RowBox[{"b", "\[Rule]", "c"}], ",", 
       RowBox[{"c", "\[Rule]", "d"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"d", "\[Rule]", "e"}], ",", 
         RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
       RowBox[{"e", "\[Rule]", "f"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Fold", "[", 
     RowBox[{"ReplaceAll", ",", 
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "b"}], ",", 
        RowBox[{"b", "\[Rule]", "c"}], ",", 
        RowBox[{"c", "\[Rule]", "d"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"d", "\[Rule]", "e"}], ",", 
          RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
        RowBox[{"e", "\[Rule]", "f"}]}], "}"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
        "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"a", "\[Rule]", "b"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
       "b", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
       "}"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "b", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
        "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"b", "\[Rule]", "c"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
       "c", ",", "c", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
       "}"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "c", ",", "c", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
        "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"c", "\[Rule]", "d"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
       "d", ",", "d", ",", "d", ",", "d", ",", "e", ",", "f", ",", "x"}], 
       "}"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "d", ",", "d", ",", "d", ",", "d", ",", "e", ",", "f", ",", "x"}], 
        "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"d", "\[Rule]", "e"}], ",", 
         RowBox[{"x", "\[Rule]", "e"}]}], "}"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
       "e", ",", "e", ",", "e", ",", "e", ",", "e", ",", "f", ",", "e"}], 
       "}"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "e", ",", "e", ",", "e", ",", "e", ",", "e", ",", "f", ",", "e"}], 
        "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"e", "\[Rule]", "f"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
       "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f"}], 
       "}"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
     "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f"}], "}"}],
    
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"364c03a6-e61b-4d24-867c-0906430410c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"collapsedFRule", "=", 
  RowBox[{
  "CollapseFoldedRule", "[", "FRule", 
   "]"}]}]], "Input",ExpressionUUID->"ecd3185a-6036-4be8-807e-b38a469d7000"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "f"}], ",", 
    RowBox[{"b", "\[Rule]", "f"}], ",", 
    RowBox[{"c", "\[Rule]", "f"}], ",", 
    RowBox[{"d", "\[Rule]", "f"}], ",", 
    RowBox[{"x", "\[Rule]", "f"}], ",", 
    RowBox[{"e", "\[Rule]", "f"}]}], "}"}], 
  "]"}]], "Output",ExpressionUUID->"e74a98bc-480c-4817-9444-0a824c009d28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}],
     "}"}], "/.", "collapsedFRule"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"d1e5642e-a78d-464f-aed0-66d4643f19b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox["collapsedFRule",
      HoldForm], ",", 
     TagBox[
      RowBox[{"FoldedRule", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "f"}], ",", 
         RowBox[{"b", "\[Rule]", "f"}], ",", 
         RowBox[{"c", "\[Rule]", "f"}], ",", 
         RowBox[{"d", "\[Rule]", "f"}], ",", 
         RowBox[{"x", "\[Rule]", "f"}], ",", 
         RowBox[{"e", "\[Rule]", "f"}]}], "}"}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
      "}"}], "/.", "\[VeryThinSpace]", 
     RowBox[{"FoldedRule", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "f"}], ",", 
        RowBox[{"b", "\[Rule]", "f"}], ",", 
        RowBox[{"c", "\[Rule]", "f"}], ",", 
        RowBox[{"d", "\[Rule]", "f"}], ",", 
        RowBox[{"x", "\[Rule]", "f"}], ",", 
        RowBox[{"e", "\[Rule]", "f"}]}], "}"}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Fold", "[", 
     RowBox[{"ReplaceAll", ",", 
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "f"}], ",", 
         RowBox[{"b", "\[Rule]", "f"}], ",", 
         RowBox[{"c", "\[Rule]", "f"}], ",", 
         RowBox[{"d", "\[Rule]", "f"}], ",", 
         RowBox[{"x", "\[Rule]", "f"}], ",", 
         RowBox[{"e", "\[Rule]", "f"}]}], "}"}], "}"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x"}], 
        "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "\[Rule]", "f"}], ",", 
         RowBox[{"b", "\[Rule]", "f"}], ",", 
         RowBox[{"c", "\[Rule]", "f"}], ",", 
         RowBox[{"d", "\[Rule]", "f"}], ",", 
         RowBox[{"x", "\[Rule]", "f"}], ",", 
         RowBox[{"e", "\[Rule]", "f"}]}], "}"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{
       "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f"}], 
       "}"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
     "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f"}], "}"}],
    
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"2146a985-e44b-4bda-950e-f0dc576f4080"]
}, Open  ]],

Cell["Positive arguments:", \
"Text",ExpressionUUID->"e1de82a6-0a80-468f-b61f-c1288d4251e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"e0ca4edb-95eb-4183-a6eb-8d1831e5bf0b"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "b"}], "}"}], ",", 
   RowBox[{"b", "\[Rule]", "c"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"e", "\[Rule]", "f"}]}], 
  "]"}]], "Output",ExpressionUUID->"2f8ea4e3-9d56-4c5b-bde7-55b3b3aaf484"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", "2"}], 
  "]"}]], "Input",ExpressionUUID->"a6897ff2-378d-43dc-93f2-ef6f599b7e23"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "c"}], ",", 
     RowBox[{"b", "\[Rule]", "c"}]}], "}"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"e", "\[Rule]", "f"}]}], 
  "]"}]], "Output",ExpressionUUID->"901ad5ac-68ae-497a-92d0-490b75567da5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", "3"}], 
  "]"}]], "Input",ExpressionUUID->"6fa332c8-a068-462b-ad30-0d7b9ff6206d"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "d"}], ",", 
     RowBox[{"b", "\[Rule]", "d"}], ",", 
     RowBox[{"c", "\[Rule]", "d"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"e", "\[Rule]", "f"}]}], 
  "]"}]], "Output",ExpressionUUID->"bded30c5-98ae-4175-8eb9-0282d022859f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", "4"}], 
  "]"}]], "Input",ExpressionUUID->"b05532d1-a76b-44fb-9277-e9dbf560af51"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "e"}], ",", 
     RowBox[{"b", "\[Rule]", "e"}], ",", 
     RowBox[{"c", "\[Rule]", "e"}], ",", 
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"e", "\[Rule]", "f"}]}], 
  "]"}]], "Output",ExpressionUUID->"e23b8ffc-957c-43f5-861b-1d9717358820"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", "5"}], 
  "]"}]], "Input",ExpressionUUID->"1c49ef9a-fe79-4bf5-9461-ec93c6a5b114"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "f"}], ",", 
    RowBox[{"b", "\[Rule]", "f"}], ",", 
    RowBox[{"c", "\[Rule]", "f"}], ",", 
    RowBox[{"d", "\[Rule]", "f"}], ",", 
    RowBox[{"x", "\[Rule]", "f"}], ",", 
    RowBox[{"e", "\[Rule]", "f"}]}], "}"}], 
  "]"}]], "Output",ExpressionUUID->"ea905115-3b5f-4486-92cc-e06139c9dc5d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", 
  "collapsedFRule"}]], \
"Input",ExpressionUUID->"3ab3acc0-4c51-46a1-9ddb-8eb352c4eef1"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"6ecc7d45-a5b3-4372-935d-05a5c75c61d0"]
}, Open  ]],

Cell["Negative arguments:", \
"Text",ExpressionUUID->"bad69da2-a5ce-4c6c-9205-d4501458d100"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"-", "1"}]}], 
  "]"}]], "Input",ExpressionUUID->"e266e401-b061-49e9-85cb-880cb4ddc59a"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"b", "\[Rule]", "c"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", "\[Rule]", "f"}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"a64af892-6db0-4397-9830-7d464296d07d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"-", "2"}]}], 
  "]"}]], "Input",ExpressionUUID->"5900fdb4-c93a-493f-8f6c-80b45b9e414f"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"b", "\[Rule]", "c"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", "f"}], ",", 
     RowBox[{"x", "\[Rule]", "f"}], ",", 
     RowBox[{"e", "\[Rule]", "f"}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"6a79059e-c4e0-4533-b529-f23845b693dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"-", "3"}]}], 
  "]"}]], "Input",ExpressionUUID->"d81fc98f-45ae-4588-9253-fab953e96120"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"b", "\[Rule]", "c"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[Rule]", "f"}], ",", 
     RowBox[{"d", "\[Rule]", "f"}], ",", 
     RowBox[{"x", "\[Rule]", "f"}], ",", 
     RowBox[{"e", "\[Rule]", "f"}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"c62d39d1-d887-40ed-b582-b446314cb540"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"-", "4"}]}], 
  "]"}]], "Input",ExpressionUUID->"28b718f0-827e-4342-8412-cfbc84f494dd"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", "f"}], ",", 
     RowBox[{"c", "\[Rule]", "f"}], ",", 
     RowBox[{"d", "\[Rule]", "f"}], ",", 
     RowBox[{"x", "\[Rule]", "f"}], ",", 
     RowBox[{"e", "\[Rule]", "f"}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"ceb7861d-b9c4-480a-b8cc-a0cdbfac0993"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"-", "5"}]}], 
  "]"}]], "Input",ExpressionUUID->"f8cddb01-b85a-4570-b5cd-65c13cf4013e"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "f"}], ",", 
    RowBox[{"b", "\[Rule]", "f"}], ",", 
    RowBox[{"c", "\[Rule]", "f"}], ",", 
    RowBox[{"d", "\[Rule]", "f"}], ",", 
    RowBox[{"x", "\[Rule]", "f"}], ",", 
    RowBox[{"e", "\[Rule]", "f"}]}], "}"}], 
  "]"}]], "Output",ExpressionUUID->"649da076-eeaf-464c-8c16-674a3e726a1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", 
  "collapsedFRule"}]], \
"Input",ExpressionUUID->"551e48bd-b900-454d-b62e-a6c92381293b"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"672883ee-f1a7-4120-be41-53cee77f2592"]
}, Open  ]],

Cell["Additional function:", \
"Text",ExpressionUUID->"e38488d1-fcf6-4ef6-a21e-52b49e8ad79b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"1e677e62-f8a1-4c32-b36c-0721624743be"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "b"}], "}"}], ",", 
   RowBox[{"b", "\[Rule]", "c"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"e", "\[Rule]", "f"}]}], 
  "]"}]], "Output",ExpressionUUID->"815f4bf7-69ee-4a24-bc1f-80f7d74a100f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"8282e154-0f5e-4d18-89f1-548a7ca0fc95"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"hello", "[", "c", "]"}]}], ",", 
     RowBox[{"b", "\[Rule]", "c"}]}], "}"}], ",", 
   RowBox[{"c", "\[Rule]", "d"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"e", "\[Rule]", "f"}]}], 
  "]"}]], "Output",ExpressionUUID->"f160b6dc-7945-46c4-a0f2-a3d67537d3c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"30fd0cba-ace6-4fe6-8b06-f8412b45b5bf"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"hello", "[", 
       RowBox[{"hello", "[", "d", "]"}], "]"}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"hello", "[", "d", "]"}]}], ",", 
     RowBox[{"c", "\[Rule]", "d"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"e", "\[Rule]", "f"}]}], 
  "]"}]], "Output",ExpressionUUID->"da742fd0-c7fa-4665-925a-37f44a432555"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"1e3c9642-928d-4edb-b5f7-24586facb0ae"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"hello", "[", 
       RowBox[{"hello", "[", 
        RowBox[{"hello", "[", "e", "]"}], "]"}], "]"}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"hello", "[", 
       RowBox[{"hello", "[", "e", "]"}], "]"}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{"hello", "[", "e", "]"}]}], ",", 
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"e", "\[Rule]", "f"}]}], 
  "]"}]], "Output",ExpressionUUID->"a205fc97-ccce-4540-98bf-628379cec763"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"9a2a935b-6617-4a62-87ef-6b03b83e04bc"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{"hello", "[", 
      RowBox[{"hello", "[", 
       RowBox[{"hello", "[", 
        RowBox[{"hello", "[", "f", "]"}], "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{"hello", "[", 
      RowBox[{"hello", "[", 
       RowBox[{"hello", "[", "f", "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"hello", "[", 
      RowBox[{"hello", "[", "f", "]"}], "]"}]}], ",", 
    RowBox[{"d", "\[Rule]", 
     RowBox[{"hello", "[", "f", "]"}]}], ",", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"hello", "[", "f", "]"}]}], ",", 
    RowBox[{"e", "\[Rule]", "f"}]}], "}"}], 
  "]"}]], "Output",ExpressionUUID->"9d66d3d8-818e-4ec0-aa26-00701966f62f"]
}, Open  ]],

Cell["Intermediate cases:", \
"Text",ExpressionUUID->"79827158-4d5a-4c41-af72-2095e8b23059"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"606deb6e-d42e-46d4-8c44-96787b4b8541"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", "e"}], ",", 
     RowBox[{"c", "\[Rule]", "e"}], ",", 
     RowBox[{"d", "\[Rule]", "e"}], ",", 
     RowBox[{"x", "\[Rule]", "e"}]}], "}"}], ",", 
   RowBox[{"e", "\[Rule]", "f"}]}], 
  "]"}]], "Output",ExpressionUUID->"7c60b9d6-f16f-4bca-9216-c0dd1edcb405"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CollapseFoldedRule", "[", 
  RowBox[{"FRule", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"6a9ec431-b3ff-4e57-987e-d63509a6d560"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "b"}], ",", 
   RowBox[{"b", "\[Rule]", "c"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[Rule]", "f"}], ",", 
     RowBox[{"d", "\[Rule]", "f"}], ",", 
     RowBox[{"x", "\[Rule]", "f"}], ",", 
     RowBox[{"e", "\[Rule]", "f"}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"974171c4-de87-47ab-ae73-aff7bf410005"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "x", ",", 
   "hello", ",", "FRule", ",", "collapsedFRule"}], 
  "]"}]], "Input",ExpressionUUID->"b84390b5-0443-4b02-aae0-50ba9e680a8a"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"c1e19468-3df8-4e9d-9a70-afca65a21113"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.10.3. Dependent and Independent", \
"Subsubsection",ExpressionUUID->"f9d74dc7-2584-43af-ba84-60085ea35f1d"],

Cell["\<\
Given a list or an array of rules we usually need to separate the \"dependent \
rules\", for which some components can be given in terms of other components, \
the \"independent components\". There are some List's and Flatten's to ensure \
that the output is always a list (not an array) of rules.\
\>", "Text",ExpressionUUID->"a2d8f0cc-0a58-4661-b953-909425e67021"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DependentRules"}]], \
"Input",ExpressionUUID->"a83fc9aa-0fbe-4d85-a14c-9d45eb3b793b"],

Cell[BoxData[
 StyleBox["\<\"DependentRules[rules] return a list with the subset of rules \
not of the form x->x. On a FoldedRule expression ir returns the first list of \
rules.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974396-4493425",ExpressionUUID->"cc6c0dbb-d356-46de-a883-\
6005c56061b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "IndependentRules"}]], \
"Input",ExpressionUUID->"f9e51533-f752-4980-9b0e-4629cfef96e8"],

Cell[BoxData[
 StyleBox["\<\"IndependentRules[rules] returns a list with the subset of \
rules of the form x->x. On a FoldedRule expression it returns a list with the \
last rules.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974396-4493425",ExpressionUUID->"359b162a-7c3d-4fc8-ba72-\
1bd621c09b59"]
}, Open  ]],

Cell["This is not being used now:", \
"Text",ExpressionUUID->"861d8cef-2658-4ca3-a9a4-e54b7e93f50a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DependentRules", "[", "list_", "]"}], ":=", 
   RowBox[{"List", "@@", 
    RowBox[{"DeleteCases", "[", 
     RowBox[{"list", ",", 
      RowBox[{"HoldPattern", "[", 
       RowBox[{"x_", "\[Rule]", "x_"}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependentRules", "[", "frule_FoldedRule", "]"}], ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "@@", 
     RowBox[{"Map", "[", 
      RowBox[{"List", ",", 
       RowBox[{"Drop", "[", 
        RowBox[{"frule", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IndependentRules", "[", "list_", "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"list", ",", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{"x_", "\[Rule]", "x_"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IndependentRules", "[", "frule_FoldedRule", "]"}], ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{"Last", "[", "frule", "]"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DependentRules", ",", "1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"IndependentRules", ",", "1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"DependentRules", ",", "IndependentRules"}], "]"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"60ae6102-128d-42bc-b4f5-0aca0f569fd7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.11. AppendToUnevaluated", \
"Subsection",ExpressionUUID->"766ecea4-4659-429a-b496-5ce11b2436bd"],

Cell["\<\
The builtin AppendTo has attribute HoldFirst, but actually evaluates its \
first argument:\
\>", "Text",ExpressionUUID->"ee4b1e21-0399-435b-8f1e-cf23143459fe"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"{", "a", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", "1"}], 
  ";"}]}], "Input",ExpressionUUID->"fcfb263a-1d19-48a2-b336-14c60a8dfb03"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"list", ",", "b"}], 
  "]"}]], "Input",ExpressionUUID->"3b80b558-f946-48fe-9d2f-bb1a18b5dac7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "b"}], 
  "}"}]], "Output",ExpressionUUID->"d39716b1-048e-4e49-a635-615f2ced3456"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"a", 
  "=."}]], "Input",ExpressionUUID->"f3b4dca3-1032-42f8-b86a-61091eeee2da"],

Cell[CellGroupData[{

Cell[BoxData["list"], \
"Input",ExpressionUUID->"5854c6eb-9f2f-493a-b456-fbd607c0ae21"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "b"}], 
  "}"}]], "Output",ExpressionUUID->"c9caf838-cccc-4941-a9a4-097e9b625761"]
}, Open  ]],

Cell["There is no way to get {a,b} back.", \
"Text",ExpressionUUID->"6b7124fd-1c02-4a1e-8229-657bc7b6ff25"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"AppendToUnevaluated", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"append", "[", 
    RowBox[{
     RowBox[{"Hold", "[", 
      RowBox[{"{", "values___", "}"}], "]"}], ",", "value_"}], "]"}], ":=", 
   RowBox[{"Hold", "[", 
    RowBox[{"{", 
     RowBox[{"values", ",", "value"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AppendToUnevaluated", "[", 
    RowBox[{"symbol_Symbol", ",", "value_"}], "]"}], ":=", 
   RowBox[{"Set", "[", 
    RowBox[{
     RowBox[{"OwnValues", "[", "symbol", "]"}], ",", 
     RowBox[{"ruledelayed", "[", 
      RowBox[{
       RowBox[{"HoldPattern", "[", "symbol", "]"}], ",", 
       RowBox[{"append", "[", 
        RowBox[{
         RowBox[{"Extract", "[", 
          RowBox[{
           RowBox[{"OwnValues", "[", "symbol", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], ",", "Hold"}], "]"}], ",", 
         "value"}], "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ruledelayed", "[", 
    RowBox[{"LHS_", ",", 
     RowBox[{"Hold", "[", "RHS_", "]"}]}], "]"}], ":=", 
   RowBox[{"RuleDelayed", "[", 
    RowBox[{"LHS", ",", "RHS"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "AppendToUnevaluated", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"43b0531a-1d50-400e-9a86-257d468dc6b5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"{", "a", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", "1"}], 
  ";"}]}], "Input",ExpressionUUID->"8819c877-315d-47cd-934d-8006a353bf32"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendToUnevaluated", "[", 
  RowBox[{"list", ",", "b"}], 
  "]"}]], "Input",ExpressionUUID->"539154f4-c23a-4e94-a862-dabe0ab83a24"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldPattern", "[", "list", "]"}], "\[RuleDelayed]", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], 
   "}"}]}]], "Output",ExpressionUUID->"1c21ff86-a288-4d07-a6ed-24fe8442ec8c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["list"], \
"Input",ExpressionUUID->"be8b0c5a-e313-44e6-b7ec-6e01aa2dca65"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "b"}], 
  "}"}]], "Output",ExpressionUUID->"fc3ae983-c674-4195-afb3-bcb91e7d6f86"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"a", 
  "=."}]], "Input",ExpressionUUID->"f48736fc-49cb-4009-b6df-a6191278e6eb"],

Cell[CellGroupData[{

Cell[BoxData["list"], \
"Input",ExpressionUUID->"60050569-622e-4b9a-9845-5fbf57bd0796"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], 
  "}"}]], "Output",ExpressionUUID->"e0b27905-2a96-4ec7-96bc-04b9873cdb0e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.12. xTension", \
"Subsection",ExpressionUUID->"d18e479b-e381-409a-afee-f499dbf0781b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakexTensions", "[", 
    RowBox[{"defcommand_Symbol", ",", "moment_String", ",", "args__"}], "]"}],
    ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ReleaseHold", "[", "#", "]"}], "[", "args", "]"}], "&"}], "/@", 
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"DownValues", "[", "xTension", "]"}], ",", 
      RowBox[{
       RowBox[{"rule_", "[", 
        RowBox[{
         RowBox[{"holdpattern_", "[", 
          RowBox[{"xTension", "[", 
           RowBox[{"package_", ",", "defcommand", ",", "moment", ",", "___"}],
            "]"}], "]"}], ",", "action_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"Hold", "[", "action", "]"}]}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"851e397f-18ca-4e38-aa13-618f4446cb8c"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.13. Changing configuration variables and options", \
"Subsection",ExpressionUUID->"d967d4b9-a48a-4e90-8ab4-76414c039cb2"],

Cell["Report changes in configuration variables:", \
"Text",ExpressionUUID->"48c5df54-808e-423c-a589-b5ca5dbe8f13"],

Cell[BoxData["Exit"], \
"Input",ExpressionUUID->"71b356a0-f2e0-44ea-827b-440fa2575769"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ValueQ", "[", "$PrePrint", 
  "]"}]], "Input",ExpressionUUID->"4bd2729a-26e2-43f6-8844-149322cc62bf"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"caaa79fd-abde-4100-ba57-c4722ee4b114"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ReportSet", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ReportSet", "[", 
    RowBox[{"var_", ",", "value_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"var", "=!=", "value"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ValueQ", "[", "var", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** Variable \>\"", ",", 
          RowBox[{"Unevaluated", "[", "var", "]"}], ",", 
          "\"\< changed from \>\"", ",", "var", ",", "\"\< to \>\"", ",", 
          "value"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<** Variable \>\"", ",", 
          RowBox[{"Unevaluated", "[", "var", "]"}], ",", 
          "\"\< assigned value \>\"", ",", "value"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Set", "[", 
       RowBox[{"var", ",", "value"}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "SetConfigurationVariable", "]"}], ";"}]}], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"28aee320-e2a3-4b1c-aac0-ab7b69c6f16c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ReportSetOption", "[", 
    RowBox[{"symbol_", ",", 
     RowBox[{"option_", "\[Rule]", "value_"}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"option", "/.", 
        RowBox[{"Options", "[", "symbol", "]"}]}], ")"}], "=!=", "value"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<** Option \>\"", ",", "option", ",", "\"\< of \>\"", ",", 
        "symbol", ",", "\"\< changed from \>\"", ",", 
        RowBox[{"option", "/.", 
         RowBox[{"Options", "[", "symbol", "]"}]}], ",", "\"\< to \>\"", ",", 
        "value"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"symbol", ",", 
        RowBox[{"option", "\[Rule]", "value"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ReportSetOption", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"2748fb9c-ecdf-43dc-b1e8-f08e396063aa"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.14. A tests system", \
"Subsection",ExpressionUUID->"581de359-335b-4892-bf73-1fe6bf2acedd"],

Cell["\<\
We use xTest instead of Test to avoid conflicts with the Test functionality \
of WorkBench.\
\>", "Text",ExpressionUUID->"ea3cebb5-1928-4275-a4d4-e88b0c9572a0"],

Cell["\<\
This is a simple way to perform a set of tests and report the results. Tests \
are associated to a given symbol and execute and expression. We compare the \
result with a prestored result and also check whether messages were produced:\
\
\>", "Text",ExpressionUUID->"79a9e325-b3dc-4516-8bac-4f123c7a2eee"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"xTest", ",", "TestResult", ",", "TestCounter", ",", "AllTests"}],
     "]"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"xTest", ",", "HoldAll"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetAttributes", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"TestResult", ",", "TestCounter", ",", "AllTests"}], "}"}], ",",
      "HoldFirst"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TestCounter", "[", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"TestCounter", "[", "]"}], "=", "0"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TestCounter", "[", "symbol_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"TestCounter", "[", "symbol", "]"}], "=", "0"}], ")"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTest", "[", 
    RowBox[{"symbol_", ",", "expr_", ",", "expected_", ",", 
     RowBox[{"messageQ_", ":", "False"}], ",", 
     RowBox[{"postprocess_", ":", "Null"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eval", ",", "result"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"TestCounter", "[", "]"}], "++"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"TestCounter", "[", "symbol", "]"}], "++"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"eval", "=", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"TestResult", "[", 
          RowBox[{"symbol", ",", 
           RowBox[{"TestCounter", "[", "symbol", "]"}]}], "]"}], "=", 
         "\[IndentingNewLine]", 
         RowBox[{"Check", "[", 
          RowBox[{
           RowBox[{"SameQ", "[", 
            RowBox[{
             RowBox[{"result", "=", 
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"res", "=", 
                  RowBox[{"Catch", "[", "expr", "]"}]}], "}"}], ",", 
                RowBox[{"Hold", "[", "res", "]"}]}], "]"}]}], ",", 
             RowBox[{"Hold", "[", "expected", "]"}]}], "]"}], ",", 
           "messageQ"}], "]"}]}], "\[IndentingNewLine]", ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", "eval"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Obtained instead: \>\"", ",", "result"}], "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "postprocess", ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"HoldForm", "[", "symbol", "]"}], ",", 
        RowBox[{"TestCounter", "[", "symbol", "]"}], ",", "eval"}], "}"}]}]}],
     "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fb963a08-c204-4c59-8fb7-8568ad5f0dba"],

Cell["\<\
This collects the results of all tests, or of all tests for a given symbol:\
\>", "Text",ExpressionUUID->"66872cf8-2533-4b1e-9acb-d728cafabd75"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AllTests", "[", "]"}], ":=", 
   RowBox[{"Last", "/@", 
    RowBox[{"DownValues", "[", "TestResult", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AllTests", "[", "symbol_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{"DownValues", "[", "TestResult", "]"}], ",", 
    RowBox[{
     RowBox[{"_", "[", 
      RowBox[{
       RowBox[{"_", "[", 
        RowBox[{"TestResult", "[", 
         RowBox[{"symbol", ",", "_"}], "]"}], "]"}], ",", "result_"}], "]"}], 
     "\[RuleDelayed]", "result"}]}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c08eb79b-1f2d-42e1-91ec-8a1f1efcd755"],

Cell["Check whether the tests passed or failed:", \
"Text",ExpressionUUID->"c4e9919b-76f8-4c1c-acd2-482547af4b3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CheckTests", "[", "symbol___", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"alltests", "=", 
       RowBox[{"AllTests", "[", "symbol", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"And", "@@", "alltests"}], " ", "&&", 
        RowBox[{
         RowBox[{"Length", "@", "alltests"}], "===", 
         RowBox[{"TestCounter", "[", "]"}]}]}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<All \>\"", ",", 
         RowBox[{"Length", "[", "alltests", "]"}], ",", 
         "\"\< tests passed\>\""}], "]"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<These tests failed: \>\"", "]"}], ";", 
        RowBox[{"Print", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"First", "/@", 
             RowBox[{
              RowBox[{"DownValues", "[", "TestResult", "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"Flatten", "@", 
                RowBox[{"Position", "[", 
                 RowBox[{"alltests", ",", "False"}], "]"}]}], "]"}], "]"}]}], 
            ")"}], "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"HoldPattern", "\[Rule]", "HoldForm"}], ",", 
             RowBox[{"TestResult", "\[Rule]", "List"}]}], "}"}]}], "//", 
          "Column"}], "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]",
       "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f1bcd7db-ef3f-4ab6-9f9a-68b62f8e24f3"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.15. Patterns", \
"Subsection",ExpressionUUID->"d0aa7c48-d772-4d0b-b592-08fb79c9c090"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NoPattern", "[", "x_PatternTest", "]"}], ":=", 
   RowBox[{"NoPattern", "[", 
    RowBox[{"First", "[", "x", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NoPattern", "[", "x_Pattern", "]"}], ":=", 
   RowBox[{"NoPattern", "[", 
    RowBox[{"First", "[", "x", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NoPattern", "[", "x_Blank", "]"}], ":=", 
   RowBox[{"NoPattern", "[", 
    RowBox[{"First", "[", "x", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NoPattern", "[", 
    RowBox[{"f_", "[", "args___", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"NoPattern", "[", "f", "]"}], "@@", 
    RowBox[{"(", 
     RowBox[{"NoPattern", "/@", 
      RowBox[{"{", "args", "}"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NoPattern", "[", "x_", "]"}], ":=", "x"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "NoPattern", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"42c85487-0af7-4887-a27c-e952b4824586"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3. Symbols and names",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"2bfc71d5-8761-4db5-bb00-55a5fe96a697"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**", " ", "3."}],
     " ", "Symbols"}], ",", " ", 
   RowBox[{"names", " ", "and", " ", "messages"}]}], " ", 
  "*******************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"92137e1a-2606-4b80-9e9a-51b1267cf80d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"bd975bc3-ef8c-4193-9a84-39ad692496bb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.7439219999999995`", ",", "41.381801`8.068354381404742", ",", 
   "0.1871343307999754`"}], 
  "}"}]], "Output",ExpressionUUID->"890f9bba-7e6a-4f52-93c8-4e842b29b030"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.0. Comments", \
"Subsection",ExpressionUUID->"4f74e105-2c66-4a50-88e5-045d43eafcfe"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"$ReadingVerbose", ",", 
   RowBox[{
   "Print", "[", "\"\<Reading section 1: Symbols, names and messages.\>\"", 
    "]"}], ",", "Null", ",", "Null"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"223fc457-5363-4438-8109-b4dc0e9557e2"],

Cell["\<\
Note the difference between symbols and names:names are always strings; \
symbols have names. From strings to symbols use Symbol:\
\>", "Text",ExpressionUUID->"3db4d412-9e7d-4d37-a03d-8e5049434d10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", "\"\<hello\>\"", 
  "]"}]], "Input",ExpressionUUID->"89e24399-e657-4ec6-93d1-77da454001ad"],

Cell[BoxData["hello"], \
"Output",ExpressionUUID->"f32bd603-5d14-49e4-8a6e-90e8b80574e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"567906ff-7196-4a05-bcef-d9f5b736eff7"],

Cell[BoxData["Symbol"], \
"Output",ExpressionUUID->"ece9a146-d35d-4789-8e64-4ba0313fe402"]
}, Open  ]],

Cell["\<\
or the more general ToExpression. From symbols to strings use SymbolName:\
\>", "Text",ExpressionUUID->"7dc8d3fc-f4ed-4729-b9e0-5d356c975633"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolName", "[", "%%", 
  "]"}]], "Input",ExpressionUUID->"e03f18af-5b1e-4935-ab33-fc30656028d4"],

Cell[BoxData["\<\"hello\"\>"], \
"Output",ExpressionUUID->"949b089c-5df8-410c-a2e6-d478d7e8a91e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"9d07ca99-3c91-4fab-93c3-08ded9f0aa7e"],

Cell[BoxData["String"], \
"Output",ExpressionUUID->"a93861a4-80a3-471d-be16-52ed2a5a034e"]
}, Open  ]],

Cell["or the more general ToString.", \
"Text",ExpressionUUID->"29e502d4-16a7-4ca5-a0bf-387e907c2e00"],

Cell[TextData[{
 "A first major decision in the design of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " is the following: all objects will be identified with symbols (not \
strings) in order to associate them the corresponding definitions (it is not \
possible to associate definitions to strings). This follows both the rule of \
simplicity and the rule of compliance with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s way. This decision has, however, several drawbacks:\n\t1) Many symbols \
are already used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", or by ",
 StyleBox["xTensor, ",
  FontSlant->"Italic"],
 " ",
 StyleBox["xPerm,  xCoba, xCore.",
  FontSlant->"Italic"],
 " Those symbols will not be allowed to represent  ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " objects. We shall define a set of functions that store the known symbols \
and analyze whether a candidate name for a new object is allowed or not. We \
will see that there are a few special cases.\n\t2) Defined symbols will have \
a \"type\". A symbol cannot have two types to avoid conflicting information. \
We could introduce contexts Tensor`, Spinor`, Form`, etc, but it is not clear \
what it would really improve. If a tensor M and a manifold M are needed then \
use symbols ManifoldM or TensorM instead of Manifold`M or Tensor`M.\n\t3) A \
symbol can have ownvalues. For example if T is a tensor we can also say T=1, \
which will generate all kinds of errors. This is normal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": if you have a function f[x] you can say f=1. A way of avoiding this could \
be protecting the symbol of any defined object, but this requires \
unprotecting symbols when you want to associate new definitions to them. We \
introduce the global variable $ProtectNewSymbols and the option \
ProtectNewSymbol to control this point, together with some ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " functions xUpSet and similar which are able to unprotect/reprotect symbols."
}], "Text",ExpressionUUID->"6d701cf7-4f81-4033-b4f5-ea4b84487c6f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
  "x", "^", 
   "2"}]}]], "Input",ExpressionUUID->"38a800f4-dcf1-4f88-8337-e2c77eac09b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "3", 
  "]"}]], "Input",ExpressionUUID->"4f91dded-ca51-4995-9ed8-e16e05cb03a9"],

Cell[BoxData["9"], \
"Output",ExpressionUUID->"da0ce6b5-d9e6-48b4-b7d2-d51b11ede3c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  "1"}]], "Input",ExpressionUUID->"d50d9cb6-2437-476b-a417-0f6f0153a05a"],

Cell[BoxData["1"], \
"Output",ExpressionUUID->"2efc94e3-2be8-46cd-ad9d-a1dde42757ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "f"}]], "Input",ExpressionUUID->"3a6f169b-ffbf-48cb-a489-cbf211eaced4"],

Cell[CellGroupData[{

Cell["xAct`xCore`Private`f", "Print", "PrintUsage",
 CellTags->
  "Info3567974397-4493425",ExpressionUUID->"165e0626-89b2-4394-83d1-\
51ee6230185c"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{"f", "=", "1"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[xAct`xCore`Private`f],
  Editable->False]], "Print",
 CellTags->
  "Info3567974397-4493425",ExpressionUUID->"d84e05c4-a6bf-4e6f-ac23-\
4dc31c9d8f8a"]
}, Open  ]]
}, Open  ]],

Cell["The ownvalue for f is used before its downvalue:", \
"Text",ExpressionUUID->"7507501e-6568-4145-b924-59c0c3674fa3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "3", 
  "]"}]], "Input",ExpressionUUID->"8ab3f058-29b4-4b33-b74b-195c840efc40"],

Cell[BoxData[
 RowBox[{"1", "[", "3", 
  "]"}]], "Output",ExpressionUUID->"e69c671f-996c-40e8-8201-b1a928599a3a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"f", ",", "x", ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"d7d3232c-8c94-4227-bb0d-59c52fd5e175"],

Cell[TextData[{
 "The basic use of symbols rather than strings can be compared to ",
 StyleBox["GRTensor",
  FontSlant->"Italic"],
 "'s input, based on strings. The strings give you more flexibility in the \
notations, but heavily rely on the parser. In other words, because the user \
cannot modify the parser, it is difficult for the user to use tricks of the \
system without changing the code of the package. Working with symbols has the \
problems referred to above and does not allow beautiful notations such that \
using parenthesis for symmetrization of indices. However it is much closer to \
",
 StyleBox["Mathematica'",
  FontSlant->"Italic"],
 "s spirit and allows the user to interact closely with the internals of the \
package because there is no parser acting as interface. There is an important \
comment here: if I had to write a system for other users I would write a \
parser; but because I am the the main user of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", I don't want to do it."
}], "Text",ExpressionUUID->"06ff69a7-70b0-4000-b4b5-eb9422dc27aa"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "3.1. Names in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Subsection",ExpressionUUID->"ef569144-1ae3-4d7d-b94a-0e3dbfb03f27"],

Cell[CellGroupData[{

Cell["3.1.0. Comments", \
"Subsubsection",ExpressionUUID->"1f7e9607-08f7-4c96-afa9-57188a5543c1"],

Cell[TextData[{
 "We will use symbols in ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " obeying these properties:\n\t- They have valid names in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". (Copied from Reference Guide A.2.4: Symbol names and contexts can contain \
any characters that are treated by ",
 StyleBox["Mathematica", "TI"],
 " as letters or letter\[Hyphen]like forms. They can contain digits but \
cannot start with them.)\n\t- Their names are not LockedNames or \
SpecialOutputNames (see below).\n\t- When trying to use a symbol which is \
protected or readprotected, we issue a warning and stop. The attribute must \
be removed (under responsibility of the user; we advise against this) before \
the object can be defined."
}], "Text",ExpressionUUID->"f8924cf0-da02-484a-8825-f8e8b0b43d4f"],

Cell[TextData[{
 "Classification of names (subcategories of SystemNames are overlapping)\n\n* \
Names:\n\t* PrivateNames\n\t* MathematicaNames",
 StyleBox[":",
  FontSlant->"Italic"],
 "\n\t\t* SystemNames:\n\t\t\t* SpecialOutputNames\n\t\t\t* LockedNames\n\t\t\
\t* ProtectedNames\n\t\t\t* ReadProtectedNames\n\t\t\t* LengthOneNames\n\t\t\t\
* other\n\t\t* ContextualNames\n\t* EMNames\n\t* xCoreNames\n\t* xPermNames\n\
\t* xTableauNames\n\t* xTensorNames\n\t* xCobaNames\n\t* InvarNames\n\t* \
HarmonicsNames\n\t* xPertNames\n\t* SpinorsNames\n\t\n\t* Objects: manifolds, \
vector bundles, abstract-indices, tensors, forms, covariant derivatives, \
constant symbols, scalar functions, inert heads, bases, charts"
}], "Text",ExpressionUUID->"30196543-8e4b-49ef-b800-b1d2f7d5c039"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.2. Names variables", \
"Subsubsection",ExpressionUUID->"33daf2c9-6d3a-49a5-ba2b-5249a5b2c54b"],

Cell[TextData[{
 "Note: the variable Verbose, already present as a SystemName, will be \
redefined by ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"19ced412-37cc-4224-a156-1f35514bfe67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "Verbose"}]], \
"Input",ExpressionUUID->"a0a19a6a-5b4a-4b88-9e5b-00736eed772f"],

Cell[CellGroupData[{

Cell["System`Verbose", "Print", "PrintUsage",
 CellTags->
  "Info3567974398-4493425",ExpressionUUID->"71d06709-5dcb-4902-9ede-\
0696b18085f7"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Verbose", "]"}], "=", 
      RowBox[{"{", "Protected", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Verbose],
  Editable->False]], "Print",
 CellTags->
  "Info3567974398-4493425",ExpressionUUID->"a6cdc0f5-dbaa-4617-a554-\
9ad18c390494"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Verbose"], \
"Input",ExpressionUUID->"fe5281ae-6882-428f-9a6e-69c3247ef9ea"],

Cell[BoxData["Verbose"], \
"Output",ExpressionUUID->"edd322a1-728b-41dc-9e7a-de18c20a85ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["xAct`xTensor`Verbose"], \
"Input",ExpressionUUID->"84ce41ee-f171-402b-a1e8-5fa4550a7ce1"],

Cell[BoxData["xAct`xTensor`Verbose"], \
"Output",ExpressionUUID->"b55c60da-a174-4496-bf45-6ea8db3cf56b"]
}, Open  ]],

Cell[TextData[{
 "We see that xAct`xTensor`Verbose will be found before System`Verbose. That \
means that everything defined before ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " is loaded will continue working, but everything we define now using the \
internal Verbose must be properly defined. I don't know what System`Verbose \
is, and so I guess this is not a problem."
}], "Text",ExpressionUUID->"9733d6f2-a036-4d9d-b88e-b915f234db9a"],

Cell[TextData[{
 "We can already define (For ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 8 we remove two symbols that are not supported under Unix/Linux):"
}], "Text",ExpressionUUID->"ff97f39f-4b70-4d1f-a6d7-fa5706a4f7de"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$EMNames", "=", 
   RowBox[{"Names", "[", "\"\<xAct`ExpressionManipulation`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$xCoreNames", "=", 
   RowBox[{"Names", "[", "\"\<xAct`xCore`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$SystemNames", "=", 
   RowBox[{"DeleteCases", "[", 
    RowBox[{
     RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}], ",", 
     RowBox[{
     "\"\<$DefaultImagingDevice\>\"", "|", "\"\<$ImagingDevices\>\""}]}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cc2a41b1-2ba3-46ca-9498-43c0e40615f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  RowBox[{"{", 
   RowBox[{"$EMNames", ",", "$xCoreNames", ",", "$SystemNames"}], 
   "}"}]}]], "Input",ExpressionUUID->"39b1e205-8b99-48c2-8bf1-8f3bb9585b2f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "54", ",", "4562"}], 
  "}"}]], "Output",ExpressionUUID->"8d9f1a3f-431e-4861-8ce9-310bd51c5ffd"]
}, Open  ]],

Cell["\<\
Other eight variables will be initialized when reading the corresponding \
packages:\
\>", "Text",ExpressionUUID->"dc99284b-3ce8-430a-b951-f505307f1eb1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$xPermNames", ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$xTableauNames", ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$xTensorNames", ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$xCobaNames", ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$InvarNames", ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HarmonicsNames", ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$xPertNames", ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$SpinorsNames", ":=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"bde270c4-b9eb-4275-b2f5-830834cbcec7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$xActNames", ":=", 
   RowBox[{"Join", "[", 
    RowBox[{
    "$EMNames", ",", "$xCoreNames", ",", "$xPermNames", ",", "$xTableauNames",
      ",", "$xTensorNames", ",", "$xCobaNames", ",", "$InvarNames", ",", 
     "$HarmonicsNames", ",", "$xPertNames", ",", "$SpinorNames"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f5286c9f-eda2-4755-a2ce-83ebb89eef24"],

Cell["\<\
Note that in total, including many other packages and their private symbols:\
\>", "Text",ExpressionUUID->"244278d7-d25d-42ef-aee6-959e22ab6a0a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Names", "[", "]"}], 
  "]"}]], "Input",ExpressionUUID->"31028ab6-28d8-43e2-aca3-b45a50824951"],

Cell[BoxData["19787"], \
"Output",ExpressionUUID->"f076d678-83ed-46b9-8a1a-6b09c05ca859"]
}, Open  ]],

Cell[TextData[{
 "Seven SystemNames, plus 113 global dollar-variables (plus 13 colors, \
starting 5.2) have special output and therefore are not valid as names in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " (to avoid interfeering with their Format definitions):"
}], "Text",ExpressionUUID->"9f480211-b450-4bf2-8b73-469a607c9af7"],

Cell[TextData[{
 "Note of October 2011: There is some bug in ",
 StyleBox["Mathematica 8",
  FontSlant->"Italic"],
 " that makes this line interfere with the syntax coloring routines. We \
deactivative this now:"
}], "Text",ExpressionUUID->"0be0c284-e4e2-4749-8ba4-30338da317ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$SpecialOutputNames", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"$SystemNames", ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", "=!=", 
       RowBox[{"ToString", "@", 
        RowBox[{"FullForm", "@", 
         RowBox[{"ToExpression", "@", "#"}]}]}]}], ")"}], "&"}]}], 
   "]"}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"f052189c-3de1-4342-946a-7c1ca681ad39"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Black\"\>", ",", "\<\"Blue\"\>", ",", "\<\"Brown\"\>", 
   ",", "\<\"ComplexInfinity\"\>", ",", "\<\"Cyan\"\>", 
   ",", "\<\"FileInformation\"\>", ",", "\<\"Gray\"\>", ",", "\<\"Green\"\>", 
   ",", "\<\"I\"\>", ",", "\<\"Infinity\"\>", ",", "\<\"Magenta\"\>", 
   ",", "\<\"NotebookInformation\"\>", ",", "\<\"Orange\"\>", 
   ",", "\<\"Pink\"\>", ",", "\<\"Purple\"\>", ",", "\<\"Red\"\>", 
   ",", "\<\"Space\"\>", ",", "\<\"Tab\"\>", ",", "\<\"White\"\>", 
   ",", "\<\"Yellow\"\>", ",", "\<\"$AddOnsDirectory\"\>", 
   ",", "\<\"$AnimationDisplayFunction\"\>", 
   ",", "\<\"$AnimationFunction\"\>", ",", "\<\"$Assumptions\"\>", 
   ",", "\<\"$BaseDirectory\"\>", ",", "\<\"$BatchInput\"\>", 
   ",", "\<\"$BatchOutput\"\>", ",", "\<\"$BoxForms\"\>", 
   ",", "\<\"$ByteOrdering\"\>", ",", "\<\"$CharacterEncoding\"\>", 
   ",", "\<\"$CommandLine\"\>", ",", "\<\"$Context\"\>", 
   ",", "\<\"$ContextPath\"\>", ",", "\<\"$CreationDate\"\>", 
   ",", "\<\"$DefaultFont\"\>", ",", "\<\"$DefaultPath\"\>", 
   ",", "\<\"$Display\"\>", ",", "\<\"$DisplayFunction\"\>", 
   ",", "\<\"$DumpDates\"\>", ",", "\<\"$DumpSupported\"\>", 
   ",", "\<\"$Echo\"\>", ",", "\<\"$Epilog\"\>", 
   ",", "\<\"$ExportEncodings\"\>", ",", "\<\"$ExportFormats\"\>", 
   ",", "\<\"$FormatType\"\>", ",", "\<\"$FrontEnd\"\>", 
   ",", "\<\"$HistoryLength\"\>", ",", "\<\"$HomeDirectory\"\>", 
   ",", "\<\"$IgnoreEOF\"\>", ",", "\<\"$ImportEncodings\"\>", 
   ",", "\<\"$ImportFormats\"\>", ",", "\<\"$InitialDirectory\"\>", 
   ",", "\<\"$Input\"\>", ",", "\<\"$Inspector\"\>", 
   ",", "\<\"$InstallationDate\"\>", ",", "\<\"$InstallationDirectory\"\>", 
   ",", "\<\"$InterfaceEnvironment\"\>", ",", "\<\"$IterationLimit\"\>", 
   ",", "\<\"$Language\"\>", ",", "\<\"$LaunchDirectory\"\>", 
   ",", "\<\"$LicenseExpirationDate\"\>", ",", "\<\"$LicenseID\"\>", 
   ",", "\<\"$LicenseProcesses\"\>", ",", "\<\"$LicenseServer\"\>", 
   ",", "\<\"$Line\"\>", ",", "\<\"$Linked\"\>", 
   ",", "\<\"$LinkSupported\"\>", ",", "\<\"$MachineDomain\"\>", 
   ",", "\<\"$MachineEpsilon\"\>", ",", "\<\"$MachineID\"\>", 
   ",", "\<\"$MachineName\"\>", ",", "\<\"$MachinePrecision\"\>", 
   ",", "\<\"$MachineType\"\>", ",", "\<\"$MaxExtraPrecision\"\>", 
   ",", "\<\"$MaxLicenseProcesses\"\>", ",", "\<\"$MaxMachineNumber\"\>", 
   ",", "\<\"$MaxNumber\"\>", ",", "\<\"$MaxPiecewiseCases\"\>", 
   ",", "\<\"$MaxPrecision\"\>", ",", "\<\"$MaxRootDegree\"\>", 
   ",", "\<\"$MessageList\"\>", ",", "\<\"$MessagePrePrint\"\>", 
   ",", "\<\"$Messages\"\>", ",", "\<\"$MinMachineNumber\"\>", 
   ",", "\<\"$MinNumber\"\>", ",", "\<\"$MinPrecision\"\>", 
   ",", "\<\"$ModuleNumber\"\>", ",", "\<\"$NetworkLicense\"\>", 
   ",", "\<\"$NewMessage\"\>", ",", "\<\"$Notebooks\"\>", 
   ",", "\<\"$NumberMarks\"\>", ",", "\<\"$OperatingSystem\"\>", 
   ",", "\<\"$Output\"\>", ",", "\<\"$OutputForms\"\>", 
   ",", "\<\"$Packages\"\>", ",", "\<\"$ParentLink\"\>", 
   ",", "\<\"$ParentProcessID\"\>", ",", "\<\"$PasswordFile\"\>", 
   ",", "\<\"$Path\"\>", ",", "\<\"$PathnameSeparator\"\>", 
   ",", "\<\"$PipeSupported\"\>", ",", "\<\"$PreferencesDirectory\"\>", 
   ",", "\<\"$PreRead\"\>", ",", "\<\"$PrintForms\"\>", 
   ",", "\<\"$ProcessID\"\>", ",", "\<\"$ProcessorType\"\>", 
   ",", "\<\"$ProductInformation\"\>", ",", "\<\"$ProgramName\"\>", 
   ",", "\<\"$PSDirectDisplay\"\>", ",", "\<\"$RandomState\"\>", 
   ",", "\<\"$RasterFunction\"\>", ",", "\<\"$RecursionLimit\"\>", 
   ",", "\<\"$ReleaseNumber\"\>", ",", "\<\"$RootDirectory\"\>", 
   ",", "\<\"$SessionID\"\>", ",", "\<\"$SoundDisplay\"\>", 
   ",", "\<\"$SoundDisplayFunction\"\>", 
   ",", "\<\"$SuppressInputFormHeads\"\>", ",", "\<\"$System\"\>", 
   ",", "\<\"$SystemCharacterEncoding\"\>", ",", "\<\"$SystemID\"\>", 
   ",", "\<\"$TemporaryPrefix\"\>", ",", "\<\"$TextStyle\"\>", 
   ",", "\<\"$TimeUnit\"\>", ",", "\<\"$TopDirectory\"\>", 
   ",", "\<\"$TraceOff\"\>", ",", "\<\"$TraceOn\"\>", 
   ",", "\<\"$TracePattern\"\>", ",", "\<\"$TracePostAction\"\>", 
   ",", "\<\"$TracePreAction\"\>", ",", "\<\"$Urgent\"\>", 
   ",", "\<\"$UserAddOnsDirectory\"\>", ",", "\<\"$UserBaseDirectory\"\>", 
   ",", "\<\"$UserName\"\>", ",", "\<\"System`$Version\"\>", 
   ",", "\<\"$VersionNumber\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"9f69d1d3-1e42-4502-a658-71f1545edc9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"ToExpression", "/@", 
   RowBox[{"$SpecialOutputNames", "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "7", "]"}], "]"}], "]"}]}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"fbdc07e1-f236-4b41-8e80-caaba182f835"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"GrayLevel", "[", "0", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "0", ",", "1"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.6`", ",", "0.4`", ",", "0.2`"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"DirectedInfinity", "[", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "1", ",", "1"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["Developer`FileInformation",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"GrayLevel", "[", "0.5`", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], 
  "}"}]], "Output",ExpressionUUID->"d4b9e7d9-d663-463b-9eb1-c140e21f08dd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$SpecialOutputNames", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c8ec24b7-415f-4c82-b7b3-e3ad8ac0d824"],

Cell["\<\
It is interesting (and confusing) to analyze the information on one of these \
objects:\
\>", "Text",ExpressionUUID->"bfdfd9c3-b030-4497-986d-dff0d5f4cc67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "DirectedInfinity", 
  "]"}]], "Input",ExpressionUUID->"571ecf82-6077-4541-8b79-524e415c3304"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "Protected", ",", "ReadProtected"}], 
  "}"}]], "Output",ExpressionUUID->"d23c6e91-162f-49ae-84a8-66de7cac1450"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unprotect", "[", "DirectedInfinity", 
  "]"}]], "Input",ExpressionUUID->"03459d78-bfa6-4861-a055-341ee0af8f63"],

Cell[BoxData[
 RowBox[{"{", "\<\"DirectedInfinity\"\>", 
  "}"}]], "Output",ExpressionUUID->"ec7def6a-f420-453c-ba52-34e7a57289ff"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ClearAttributes", "[", 
  RowBox[{"DirectedInfinity", ",", "ReadProtected"}], 
  "]"}]], "Input",ExpressionUUID->"075bb75d-2334-467e-aaf1-d84f290f5f94"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "DirectedInfinity"}]], \
"Input",ExpressionUUID->"bab246a4-fcf8-4344-b571-925e2706816f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"DirectedInfinity\\\", \\\"[\\\", \
\\\"]\\\"}]\) represents an infinite numerical quantity whose direction in \
the complex plane is unknown. \\n\!\(\*RowBox[{\\\"DirectedInfinity\\\", \
\\\"[\\\", StyleBox[\\\"z\\\", \\\"TI\\\"], \\\"]\\\"}]\) represents an \
infinite numerical quantity that is a positive real multiple of the complex \
number \!\(\*StyleBox[\\\"z\\\", \\\"TI\\\"]\). \"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedInfinity"]}]], "Print", "PrintUsage",
 CellTags->
  "Info3567974399-4493425",ExpressionUUID->"d08f8e98-b464-4f8e-b923-\
c772a6524274"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "DirectedInfinity", "]"}], "=", 
      RowBox[{"{", "Listable", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"\<\"Format\"\>", "[", "ComplexInfinity", "]"}], 
         "=", "\<\"ComplexInfinity\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"\<\"Format\"\>", "[", "\[Infinity]", "]"}], 
         ":=", "\<\"Infinity\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"\<\"Format\"\>", "[", 
          RowBox[{"HoldPattern", "[", "ComplexInfinity", "]"}], "]"}], 
         "=", "\<\"ComplexInfinity\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"\<\"Format\"\>", "[", 
          RowBox[{"DirectedInfinity", "[", "System`Dump`x_", "]"}], "]"}], ":=", 
         RowBox[{"\<\"PrecedenceForm\"\>", "[", 
          RowBox[{
           RowBox[{"System`Dump`x", " ", "\<\"Infinity\"\>"}], ",", 
           RowBox[{"Round", "[", 
            RowBox[{"Precedence", "[", "Times", "]"}], "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MakeBoxes", "[", 
          RowBox[{"ComplexInfinity", ",", "BoxForm`fmt_"}], "]"}], "^:=", 
         RowBox[{"MakeBoxes", "[", 
          RowBox[{"ComplexInfinity", ",", "BoxForm`fmt"}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MakeBoxes", "[", 
          RowBox[{"ComplexInfinity", ",", "BoxForm`fmt_"}], "]"}], "^:=", 
         RowBox[{"MakeBoxes", "[", 
          RowBox[{"ComplexInfinity", ",", "BoxForm`fmt"}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MakeBoxes", "[", 
          RowBox[{"\[Infinity]", ",", "BoxForm`fmt_"}], "]"}], "^:=", 
         RowBox[{"MakeBoxes", "[", 
          RowBox[{"\[Infinity]", ",", "BoxForm`fmt"}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MakeBoxes", "[", 
          RowBox[{
           RowBox[{"-", "\[Infinity]"}], ",", "BoxForm`fmt_"}], "]"}], "^:=", 
         
         RowBox[{"MakeBoxes", "[", 
          RowBox[{
           RowBox[{"-", "\[Infinity]"}], ",", "BoxForm`fmt"}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MakeBoxes", "[", 
          RowBox[{
           RowBox[{"DirectedInfinity", "[", 
            RowBox[{"BoxForm`z_", "?", "BoxForm`HeldNumberQ"}], "]"}], ",", 
           "BoxForm`fmt_"}], "]"}], "^:=", 
         RowBox[{"TagBox", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"RowBox", "[", 
               RowBox[{"{", 
                RowBox[{"#1", ",", "\<\" \"\>", ",", 
                 RowBox[{"MakeBoxes", "[", 
                  RowBox[{"\[Infinity]", ",", "BoxForm`fmt"}], "]"}]}], "}"}],
                "]"}], "&"}], ")"}], "[", 
            RowBox[{"TagBox", "[", 
             RowBox[{
              RowBox[{"Parenthesize", "[", 
               RowBox[{
               "BoxForm`z", ",", "BoxForm`fmt", ",", "Times", ",", "Left"}], 
               "]"}], ",", "\<\"DirectedInfinityCoefficient\"\>", ",", 
              RowBox[{"Editable", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
           "DirectedInfinity", ",", 
           RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[DirectedInfinity],
  Editable->False]], "Print",
 CellTags->
  "Info3567974399-4493425",ExpressionUUID->"8b893ddb-a048-415a-bcbd-\
18c258dd4ca9"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"DirectedInfinity", ",", 
   RowBox[{"{", 
    RowBox[{"Protected", ",", "ReadProtected"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"8bc2a50d-98f1-4790-8709-9960333c74cf"],

Cell["\<\
Nine SystemNames (and symbol I) are locked and therefore we cannot associate \
new values to them (note that Attributes accepts both symbols and their \
names):\
\>", "Text",ExpressionUUID->"cdc09bdb-abc8-4faf-aa59-d7ba5cfeb5e3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LockedQ", "[", "symbol_", "]"}], ":=", 
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"Attributes", "[", "symbol", "]"}], ",", "Locked"}], 
   "]"}]}], "\n", 
 RowBox[{"$LockedNames", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Complement", "[", 
     RowBox[{"$SystemNames", ",", "$SpecialOutputNames"}], "]"}], ",", 
    "LockedQ"}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0a673267-64e0-4ffc-9dea-af2c17f0ffa1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Fail\"\>", ",", "\<\"False\"\>", ",", "\<\"I\"\>", 
   ",", "\<\"List\"\>", ",", "\<\"Locked\"\>", ",", "\<\"Remove\"\>", 
   ",", "\<\"Removed\"\>", ",", "\<\"Symbol\"\>", 
   ",", "\<\"System`$Version\"\>", ",", "\<\"TooBig\"\>", ",", "\<\"True\"\>",
    ",", "\<\"$Aborted\"\>", ",", "\<\"$BatchOutput\"\>", 
   ",", "\<\"$CommandLine\"\>", ",", "\<\"$CreationDate\"\>", 
   ",", "\<\"$InitialDirectory\"\>", ",", "\<\"$Input\"\>", 
   ",", "\<\"$InputStreamMethods\"\>", ",", "\<\"$LinkSupported\"\>", 
   ",", "\<\"$MachineType\"\>", ",", "\<\"$MinorReleaseNumber\"\>", 
   ",", "\<\"$Off\"\>", ",", "\<\"$OperatingSystem\"\>", 
   ",", "\<\"$OutputStreamMethods\"\>", ",", "\<\"$PipeSupported\"\>", 
   ",", "\<\"$PrintForms\"\>", ",", "\<\"$PrintLiteral\"\>", 
   ",", "\<\"$ProcessorType\"\>", ",", "\<\"$ProductInformation\"\>", 
   ",", "\<\"$ReleaseNumber\"\>", ",", "\<\"$ScriptCommandLine\"\>", 
   ",", "\<\"$System\"\>", ",", "\<\"$SystemID\"\>", 
   ",", "\<\"$SystemWordLength\"\>", ",", "\<\"$TimeUnit\"\>", 
   ",", "\<\"$VersionNumber\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"38a668ad-5d72-4d11-a81c-4dc498ed50d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "TooBig"}]], "Input",ExpressionUUID->"73480bb9-4f4a-412a-a6d1-0417ee8d3d6e"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"TooBig is an internal symbol.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974399-4493425",ExpressionUUID->"29445c91-ee8e-4774-bebe-\
b82e8ca95b74"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "TooBig", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Locked", ",", "Protected"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[TooBig],
  Editable->False]], "Print",
 CellTags->
  "Info3567974399-4493425",ExpressionUUID->"f47d24d3-d2ce-4e67-a714-\
cbb443ce2e3b"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "but most SystemNames are just protected. We advise against their use in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", but it is possible to do it, under responsibility of the user, removing \
the protection."
}], "Text",ExpressionUUID->"66868965-ca52-4890-988c-19936d49cd02"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ProtectedQ", "[", "symbol_", "]"}], ":=", 
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"Attributes", "[", "symbol", "]"}], ",", "Protected"}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"$ProtectedNames", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Complement", "[", 
      RowBox[{
      "$SystemNames", ",", "$SpecialOutputNames", ",", "$LockedNames"}], 
      "]"}], ",", "ProtectedQ"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a6282bac-8783-4bb9-b552-b65bd4780d7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "$ProtectedNames", 
  "]"}]], "Input",ExpressionUUID->"ccee9e44-2f1a-42d3-9b0b-2d9c90c92e2a"],

Cell[BoxData["4127"], \
"Output",ExpressionUUID->"afa50320-8d07-48a8-84b5-517220894896"]
}, Open  ]],

Cell["We also have readprotected SystemNames:", \
"Text",ExpressionUUID->"11c69c32-1745-437f-a7dd-11f23d8f353f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ReadProtectedQ", "[", "symbol_", "]"}], ":=", 
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"Attributes", "[", "symbol", "]"}], ",", "ReadProtected"}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"$ReadProtectedNames", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Complement", "[", 
      RowBox[{"$SystemNames", ",", "$SpecialOutputNames"}], "]"}], ",", 
     "ReadProtectedQ"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e0bc11e6-a734-4909-a46b-055f3884b714"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "$ReadProtectedNames", 
  "]"}]], "Input",ExpressionUUID->"f062e946-955d-4e71-b5c8-d71734a3c952"],

Cell[BoxData["1828"], \
"Output",ExpressionUUID->"3d3706d3-77cb-44b7-af74-3edcd602c35e"]
}, Open  ]],

Cell["\<\
and interestingly, not all of them are protected. Note that most of them are \
related to I/O processes:\
\>", "Text",ExpressionUUID->"5ea5778f-3080-4641-8dab-85df78608dd4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{"$ReadProtectedNames", ",", "$ProtectedNames"}], 
  "]"}]], "Input",ExpressionUUID->"01bf95cc-ebc1-475c-9c1d-c955c2f270f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DefineExternal\"\>", ",", "\<\"Derivative\"\>", 
   ",", "\<\"ErrorPacket\"\>", ",", "\<\"ExternalCall\"\>", 
   ",", "\<\"FileName\"\>", ",", "\<\"FindLibrary\"\>", ",", "\<\"I\"\>", 
   ",", "\<\"Install\"\>", ",", "\<\"LinkPatterns\"\>", ",", "\<\"NCache\"\>",
    ",", "\<\"RawBoxes\"\>", ",", "\<\"Reinstall\"\>", 
   ",", "\<\"SelectionPlaceholder\"\>", ",", "\<\"Subsuperscript\"\>", 
   ",", "\<\"Superscript\"\>", ",", "\<\"ThisLink\"\>", 
   ",", "\<\"Uninstall\"\>", ",", "\<\"$BoxForms\"\>", 
   ",", "\<\"$CurrentLink\"\>", ",", "\<\"$DynamicEvaluation\"\>", 
   ",", "\<\"$InputStreamMethods\"\>", ",", "\<\"$LibraryPath\"\>", 
   ",", "\<\"$MessageGroups\"\>", ",", "\<\"$MessagePrePrint\"\>", 
   ",", "\<\"$OutputSizeLimit\"\>", ",", "\<\"$OutputStreamMethods\"\>", 
   ",", "\<\"$SynchronousEvaluation\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"2237f974-6d91-4e37-b636-ccb5d02e7466"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.3. Classification of $HeldNames", \
"Subsubsection",ExpressionUUID->"77a1ffb2-fb03-4d03-893f-0d9c3d486199"],

Cell["Nothing in this subsection goes into the package.", \
"Text",ExpressionUUID->"a4d52dd4-352c-4c70-98e0-bab4685b6f06"],

Cell["\<\
It is also interesting to know which symbols have Hold Attributes:\
\>", "Text",ExpressionUUID->"0fcd6ffc-814f-40dd-b948-baa365976696"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"HeldQ", "[", "symbol_", "]"}], ":=", 
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"Attributes", "[", "symbol", "]"}], ",", 
    RowBox[{
    "HoldAllComplete", "|", "HoldAll", "|", "HoldFirst", "|", "HoldRest", "|",
      "NHoldAll", "|", "NHoldFirst", "|", "NHoldRest", "|", 
     "SequenceHold"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"$HeldNames", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"$SystemNames", ",", "HeldQ"}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"ad34980a-cf4c-4dda-ae61-dfb3e4c32726"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "$HeldNames", 
  "]"}]], "Input",ExpressionUUID->"6628ddce-d0ba-45b5-a123-152b76b65419"],

Cell[BoxData["246"], \
"Output",ExpressionUUID->"9f94f097-1781-4f8a-89d7-a4226e628168"]
}, Open  ]],

Cell["\<\
It is important to study these names to get an idea of what situations need a \
Hold attribute:\
\>", "Text",ExpressionUUID->"9068116f-0cf6-47b3-8e79-ebb34b24d104"],

Cell["\<\
First we have assignment functions, which are all Protected. Important \
observations: 
\t1) They all hold the first argument at least.
\t2) Set functions have HoldFirst, whereas SetDelayed functions have HoldAll.
\t3) Functions like AddTo use HoldFirst.
\t4) Set, UpSet and TagSet (and their Delayed versions) use SequenceHold. \
QUESTION: Why?\
\>", "Text",ExpressionUUID->"e8d9251d-afb1-40ea-9d02-047f29e8686b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"assignment", "=", 
   RowBox[{"ToString", "/@", 
    RowBox[{"{", 
     RowBox[{
     "Set", ",", "UpSet", ",", "Unset", ",", "SetDelayed", ",", "TagSet", ",",
       "TagSetDelayed", ",", "TagUnset", ",", "UpSetDelayed", ",", "Clear", 
      ",", "Protect", ",", "Unprotect", ",", "UpValues", ",", "DownValues", 
      ",", "Attributes", ",", "ClearAttributes", ",", "SetAttributes", ",", 
      "DefaultValues", ",", "FormatValues", ",", "NValues", ",", "OwnValues", 
      ",", "ClearAll", ",", "Remove", ",", "SubValues", ",", "Alias", ",", 
      "UnAlias", ",", "EditDefinition", ",", "Increment", ",", "Decrement", 
      ",", "PreIncrement", ",", "PreDecrement", ",", "AddTo", ",", 
      "SubtractFrom", ",", "TimesBy", ",", "DivideBy", ",", "AppendTo", ",", 
      "PrependTo"}], "}"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"3ff5d098-8dde-4d4b-bd6e-f3a80e679ac7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"(", 
   RowBox[{"ProtectedQ", "/@", "assignment"}], 
   ")"}]}]], "Input",ExpressionUUID->"843693bc-9680-45be-b3fe-d3b66ee4da8a"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"cfb33157-7050-4bd3-b8a0-5a6466e8a764"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Attributes", "[", "#", "]"}], ",", "Protected"}], "]"}]}], 
     "}"}], "&"}], "/@", "assignment"}], "//", 
  "TableForm"}]], \
"Input",ExpressionUUID->"42e91662-1143-48ab-84f6-20653e2c9515"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"Set\"\>", GridBox[{
       {"HoldFirst"},
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"UpSet\"\>", GridBox[{
       {"HoldFirst"},
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Unset\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"SetDelayed\"\>", GridBox[{
       {"HoldAll"},
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TagSet\"\>", GridBox[{
       {"HoldAll"},
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TagSetDelayed\"\>", GridBox[{
       {"HoldAll"},
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TagUnset\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"UpSetDelayed\"\>", GridBox[{
       {"HoldAll"},
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Clear\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Protect\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Unprotect\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"UpValues\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DownValues\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Attributes\"\>", GridBox[{
       {"HoldAll"},
       {"Listable"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ClearAttributes\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"SetAttributes\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DefaultValues\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FormatValues\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"NValues\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"OwnValues\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ClearAll\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Remove\"\>", GridBox[{
       {"HoldAll"},
       {"Locked"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"SubValues\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Alias\"\>", 
     InterpretationBox["\<\"\"\>",
      {}]},
    {"\<\"UnAlias\"\>", 
     InterpretationBox["\<\"\"\>",
      {}]},
    {"\<\"EditDefinition\"\>", 
     InterpretationBox["\<\"\"\>",
      {}]},
    {"\<\"Increment\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Decrement\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PreIncrement\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PreDecrement\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"AddTo\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"SubtractFrom\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TimesBy\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DivideBy\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"AppendTo\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PrependTo\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{"Set", {HoldFirst, SequenceHold}}, {
    "UpSet", {HoldFirst, SequenceHold}}, {
    "Unset", {HoldFirst, ReadProtected}}, {
    "SetDelayed", {HoldAll, SequenceHold}}, {
    "TagSet", {HoldAll, SequenceHold}}, {
    "TagSetDelayed", {HoldAll, SequenceHold}}, {"TagUnset", {HoldAll}}, {
    "UpSetDelayed", {HoldAll, SequenceHold}}, {"Clear", {HoldAll}}, {
    "Protect", {HoldAll}}, {"Unprotect", {HoldAll}}, {
    "UpValues", {HoldAll}}, {"DownValues", {HoldAll}}, {
    "Attributes", {HoldAll, Listable}}, {"ClearAttributes", {HoldFirst}}, {
    "SetAttributes", {HoldFirst}}, {"DefaultValues", {HoldAll}}, {
    "FormatValues", {HoldAll}}, {"NValues", {HoldAll}}, {
    "OwnValues", {HoldAll}}, {"ClearAll", {HoldAll}}, {
    "Remove", {HoldAll, Locked}}, {"SubValues", {HoldAll}}, {"Alias", {}}, {
    "UnAlias", {}}, {"EditDefinition", {}}, {
    "Increment", {HoldFirst, ReadProtected}}, {
    "Decrement", {HoldFirst, ReadProtected}}, {
    "PreIncrement", {HoldFirst, ReadProtected}}, {
    "PreDecrement", {HoldFirst, ReadProtected}}, {"AddTo", {HoldFirst}}, {
    "SubtractFrom", {HoldFirst}}, {"TimesBy", {HoldFirst}}, {
    "DivideBy", {HoldFirst}}, {"AppendTo", {HoldFirst}}, {
    "PrependTo", {
     HoldFirst}}}]]], \
"Output",ExpressionUUID->"a9664ea4-e536-4f86-9aca-f948a16c480b"]
}, Open  ]],

Cell["\<\
Then we have functions that move around definitions and messages. Note that \
MakeBoxes and InterpretationBox have attribute HoldAllComplete.\
\>", "Text",ExpressionUUID->"2f8a27bd-7e66-4e27-a148-2cfa22b85b1a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"information", "=", 
   RowBox[{"ToString", "/@", 
    RowBox[{"{", 
     RowBox[{
     "Save", ",", "DumpSave", ",", "Definition", ",", "FullDefinition", ",", 
      "Information", ",", "Messages", ",", "On", ",", "Off", ",", "Message", 
      ",", "MessageName", ",", "MessagePacket", ",", "ConsoleMessage", ",", 
      "ConsolePrint", ",", "Catch", ",", "Check", ",", "CheckAbort", ",", 
      "CheckAll", ",", "AbortProtect", ",", "InterpretationBox", ",", 
      "MakeBoxes", ",", "Trace", ",", "TraceDialog", ",", "TracePrint", ",", 
      "TraceScan", ",", "Debug", ",", "Context"}], "}"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"a882d2e6-2d59-4471-8764-7df705c7b123"],

Cell["All but three are protected:", \
"Text",ExpressionUUID->"3b168709-370a-4058-a57f-33586c78d561"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"(", 
   RowBox[{"ProtectedQ", "/@", 
    RowBox[{"DeleteCases", "[", 
     RowBox[{"information", ",", 
      RowBox[{
      "\"\<ConsoleMessage\>\"", "|", "\"\<ConsolePrint\>\"", "|", 
       "\"\<MakeBoxes\>\""}]}], "]"}]}], 
   ")"}]}]], "Input",ExpressionUUID->"51cda409-a925-44e1-8acf-403b3efb6052"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"45a9f90c-deac-4c24-a570-1090e790c7f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Attributes", "[", "#", "]"}], ",", "Protected"}], "]"}]}], 
     "}"}], "&"}], "/@", "information"}], "//", 
  "TableForm"}]], \
"Input",ExpressionUUID->"29e604a5-7e3e-4f37-9281-fb874cbd89a1"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"Save\"\>", GridBox[{
       {"HoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DumpSave\"\>", GridBox[{
       {"HoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Definition\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FullDefinition\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Information\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Messages\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"On\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Off\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Message\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MessageName\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MessagePacket\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ConsoleMessage\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ConsolePrint\"\>", 
     InterpretationBox["\<\"\"\>",
      {}]},
    {"\<\"Catch\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Check\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"CheckAbort\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"CheckAll\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"AbortProtect\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"InterpretationBox\"\>", GridBox[{
       {"HoldAllComplete"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MakeBoxes\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Trace\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TraceDialog\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TracePrint\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TraceScan\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Debug\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Context\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{"Save", {HoldRest}}, {"DumpSave", {HoldRest}}, {
    "Definition", {HoldAll}}, {"FullDefinition", {HoldAll}}, {
    "Information", {HoldAll, ReadProtected}}, {"Messages", {HoldAll}}, {
    "On", {HoldAll}}, {"Off", {HoldAll}}, {"Message", {HoldFirst}}, {
    "MessageName", {HoldFirst, ReadProtected}}, {
    "MessagePacket", {HoldFirst, ReadProtected}}, {
    "ConsoleMessage", {HoldAll}}, {"ConsolePrint", {}}, {
    "Catch", {HoldFirst}}, {"Check", {HoldAll}}, {"CheckAbort", {HoldAll}}, {
    "CheckAll", {HoldAll}}, {"AbortProtect", {HoldAll}}, {
    "InterpretationBox", {HoldAllComplete, ReadProtected}}, {
    "MakeBoxes", {HoldAllComplete}}, {"Trace", {HoldAll}}, {
    "TraceDialog", {HoldAll}}, {"TracePrint", {HoldAll}}, {
    "TraceScan", {HoldAll}}, {"Debug", {HoldFirst}}, {
    "Context", {
     HoldFirst}}}]]], \
"Output",ExpressionUUID->"3131bb14-d7ab-474e-979a-ad7b6ed439d3"]
}, Open  ]],

Cell["\<\
Now rules and patterns. Comments:
\t1) Rule and RuleDelayed do not hold their first argument (compare with \
assignment functions). They also use SequenceHold.
\t2) Blank, Pattern, PatternTest and Condition are all different!\
\>", "Text",ExpressionUUID->"303b9266-1a70-4e0a-aeb4-adad8be4b483"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rulepatterns", "=", 
   RowBox[{"ToString", "/@", 
    RowBox[{"{", 
     RowBox[{
     "Rule", ",", "RuleDelayed", ",", "RuleCondition", ",", "Blank", ",", 
      "Pattern", ",", "PatternTest", ",", "Condition"}], "}"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"b733921e-bab3-478d-9538-c0a53097bc9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"(", 
   RowBox[{"ProtectedQ", "/@", "rulepatterns"}], 
   ")"}]}]], "Input",ExpressionUUID->"e6723c96-16bc-438f-8496-f0193ade8dc5"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"8e8ea652-ea44-4b41-90da-916e8d503cc6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Attributes", "[", "#", "]"}], ",", "Protected"}], "]"}]}], 
     "}"}], "&"}], "/@", "rulepatterns"}], "//", 
  "TableForm"}]], \
"Input",ExpressionUUID->"e571c83b-95d4-4751-ac41-b9ab0fca4d49"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"Rule\"\>", GridBox[{
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"RuleDelayed\"\>", GridBox[{
       {"HoldRest"},
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"RuleCondition\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Blank\"\>", 
     InterpretationBox["\<\"\"\>",
      {}]},
    {"\<\"Pattern\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PatternTest\"\>", GridBox[{
       {"HoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Condition\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{"Rule", {SequenceHold}}, {
    "RuleDelayed", {HoldRest, SequenceHold}}, {
    "RuleCondition", {HoldFirst}}, {"Blank", {}}, {"Pattern", {HoldFirst}}, {
    "PatternTest", {HoldRest}}, {
    "Condition", {
     HoldAll}}}]]], \
"Output",ExpressionUUID->"96efd750-5466-4d5f-bf61-192cda29c8a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"x_h", "?", "Q"}], 
  "]"}]], "Input",ExpressionUUID->"f8f32563-dec8-497a-bde2-d28b19094b35"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"PatternTest", "[", 
    RowBox[{
     RowBox[{"Pattern", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Blank", "[", "h", "]"}]}], "]"}], ",", "Q"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"60e8b918-3c4c-469c-a7c1-3af41a824867"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"x", ",", "h", ",", "Q"}], 
  "]"}]], "Input",ExpressionUUID->"52515a61-f9f4-4b93-b0f2-09949fee4da4"],

Cell["\<\
Actual operators and mathematical functions. Comments:
\t1) Those functions that have arguments pinpointing parts use NHoldRest on \
them so that they are not affected by N.
\t2) Mathematical functions with an Integer index use NHoldFirst for the same \
reason
\t3) Other heads have attribute HoldAll\
\>", "Text",ExpressionUUID->"a06d2a2d-2c6c-49e2-aa4f-f7ac9c75f42b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"operators", "=", 
   RowBox[{"ToString", "/@", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
     "Drop", ",", "Extract", ",", "HeldPart", ",", "Part", ",", "Take", ",", 
      "\[IndentingNewLine]", "Product", ",", "Sum", ",", "Root", ",", 
      "FindRoot", ",", "FindMinimum", ",", "NIntegrate", ",", "NProduct", ",",
       "NSum", ",", "\[IndentingNewLine]", "Plot", ",", "Plot3D", ",", 
      "ParametricPlot", ",", "ParametricPlot3D", ",", "DensityPlot", ",", 
      "ContourPlot", ",", "\[IndentingNewLine]", "MathieuC", ",", 
      "MathieuCharacteristicA", ",", "MathieuCharacteristicB", ",", 
      "MathieuCPrime", ",", "MathieuS", ",", "MathieuSPrime", ",", 
      "StieltjesGamma", ",", "PolyGamma", ",", "EllipticTheta", ",", 
      "EllipticThetaPrime"}], "}"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"7cebded8-deb3-4653-9ef6-40b2920ecc9c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"(", 
   RowBox[{"ProtectedQ", "/@", "operators"}], 
   ")"}]}]], "Input",ExpressionUUID->"e0cf0408-56bb-4908-aa65-6bd6bd0cf10b"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"bd46ad3b-1c40-4fd8-a6e5-65ff537a8ae3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Attributes", "[", "#", "]"}], ",", "Protected"}], "]"}]}], 
     "}"}], "&"}], "/@", "operators"}], "//", 
  "TableForm"}]], \
"Input",ExpressionUUID->"2c2404b9-191f-48d7-a5ab-ec6f197ef418"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"Drop\"\>", GridBox[{
       {"NHoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Extract\"\>", GridBox[{
       {"NHoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"HeldPart\"\>", GridBox[{
       {"NHoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Part\"\>", GridBox[{
       {"NHoldRest"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Take\"\>", GridBox[{
       {"NHoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Product\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Sum\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Root\"\>", GridBox[{
       {"NHoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FindRoot\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FindMinimum\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"NIntegrate\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"NProduct\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"NSum\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Plot\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Plot3D\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ParametricPlot\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ParametricPlot3D\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DensityPlot\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ContourPlot\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MathieuC\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MathieuCharacteristicA\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MathieuCharacteristicB\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MathieuCPrime\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MathieuS\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MathieuSPrime\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"StieltjesGamma\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PolyGamma\"\>", GridBox[{
       {"Listable"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"EllipticTheta\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"EllipticThetaPrime\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{"Drop", {NHoldRest}}, {"Extract", {NHoldRest}}, {
    "HeldPart", {NHoldRest}}, {"Part", {NHoldRest, ReadProtected}}, {
    "Take", {NHoldRest}}, {"Product", {HoldAll, ReadProtected}}, {
    "Sum", {HoldAll, ReadProtected}}, {"Root", {NHoldAll, ReadProtected}}, {
    "FindRoot", {HoldAll}}, {"FindMinimum", {HoldAll}}, {
    "NIntegrate", {HoldAll}}, {"NProduct", {HoldAll}}, {"NSum", {HoldAll}}, {
    "Plot", {HoldAll, ReadProtected}}, {"Plot3D", {HoldAll, ReadProtected}}, {
    "ParametricPlot", {HoldAll, ReadProtected}}, {
    "ParametricPlot3D", {HoldAll, ReadProtected}}, {
    "DensityPlot", {HoldAll, ReadProtected}}, {
    "ContourPlot", {HoldAll, ReadProtected}}, {
    "MathieuC", {Listable, NHoldFirst, NumericFunction}}, {
    "MathieuCharacteristicA", {Listable, NHoldFirst, NumericFunction}}, {
    "MathieuCharacteristicB", {Listable, NHoldFirst, NumericFunction}}, {
    "MathieuCPrime", {Listable, NHoldFirst, NumericFunction}}, {
    "MathieuS", {Listable, NHoldFirst, NumericFunction}}, {
    "MathieuSPrime", {Listable, NHoldFirst, NumericFunction}}, {
    "StieltjesGamma", {Listable, NHoldFirst, ReadProtected}}, {
    "PolyGamma", {Listable, NumericFunction}}, {
    "EllipticTheta", {Listable, NHoldFirst, NumericFunction}}, {
    "EllipticThetaPrime", {
     Listable, NHoldFirst, 
      NumericFunction}}}]]], \
"Output",ExpressionUUID->"6e73b560-ad4a-401e-b4ae-26d9a60a6146"]
}, Open  ]],

Cell["\<\
Functions that evaluate their arguments in special ways. QUESTION: Why \
Verbatim does not have a Hold attribute?\
\>", "Text",ExpressionUUID->"3c4057b5-2953-459c-9cf7-7ac022e752a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"evaluation", "=", 
   RowBox[{"ToString", "/@", 
    RowBox[{"{", 
     RowBox[{
     "Block", ",", "Module", ",", "With", ",", "Hold", ",", "HoldForm", ",", 
      "HoldPattern", ",", "Literal", ",", "Verbatim", ",", "HoldComplete", 
      ",", "Parenthesize", ",", "Unevaluated"}], "}"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"68ed91ab-65ea-4b5a-853f-3f3504c4f2fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"(", 
   RowBox[{"ProtectedQ", "/@", "evaluation"}], 
   ")"}]}]], "Input",ExpressionUUID->"b0b1622f-5fe6-4bdf-af44-3dd136b8657f"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"878f49b0-0d67-4c1c-b928-d7560d17c4e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Attributes", "[", "#", "]"}], ",", "Protected"}], "]"}]}], 
     "}"}], "&"}], "/@", "evaluation"}], "//", 
  "TableForm"}]], \
"Input",ExpressionUUID->"a8007794-437a-4271-9e6d-e178c62e4059"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"Block\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Module\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"With\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Hold\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"HoldForm\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"HoldPattern\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Literal\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Verbatim\"\>", 
     InterpretationBox["\<\"\"\>",
      {}]},
    {"\<\"HoldComplete\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Parenthesize\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Unevaluated\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{"Block", {HoldAll}}, {"Module", {HoldAll}}, {
    "With", {HoldAll}}, {"Hold", {HoldAll}}, {"HoldForm", {HoldAll}}, {
    "HoldPattern", {HoldAll}}, {"Literal", {HoldAll}}, {"Verbatim", {}}, {
    "HoldComplete", {HoldAllComplete}}, {"Parenthesize", {HoldAllComplete}}, {
    "Unevaluated", {
     HoldAllComplete}}}]]], \
"Output",ExpressionUUID->"164eaa42-ca48-4062-b0aa-8827deab012e"]
}, Open  ]],

Cell["\<\
And functions that control the flow of evaluation. Note that If and Switch \
evaluate their first argument.\
\>", "Text",ExpressionUUID->"e8be5aa0-ff70-4a61-b859-fa0d3dc29172"],

Cell[BoxData[
 RowBox[{
  RowBox[{"flow", "=", 
   RowBox[{"ToString", "/@", 
    RowBox[{"{", 
     RowBox[{
     "And", ",", "Or", ",", "For", ",", "ForAll", ",", "Exists", ",", 
      "CompoundExpression", ",", "Do", ",", "Which", ",", "While", ",", 
      "Table", ",", "If", ",", "Switch"}], "}"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"600148ff-b7f5-4a71-8076-e8394a06e486"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Attributes", "[", "#", "]"}], ",", "Protected"}], "]"}]}], 
     "}"}], "&"}], "/@", "flow"}], "//", 
  "TableForm"}]], \
"Input",ExpressionUUID->"57b28651-f194-45b3-b8fe-98623720984c"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"And\"\>", GridBox[{
       {"Flat"},
       {"HoldAll"},
       {"OneIdentity"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Or\"\>", GridBox[{
       {"Flat"},
       {"HoldAll"},
       {"OneIdentity"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"For\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ForAll\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Exists\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"CompoundExpression\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Do\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Which\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"While\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Table\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"If\"\>", GridBox[{
       {"HoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Switch\"\>", GridBox[{
       {"HoldRest"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{"And", {Flat, HoldAll, OneIdentity}}, {
    "Or", {Flat, HoldAll, OneIdentity}}, {"For", {HoldAll}}, {
    "ForAll", {HoldAll, ReadProtected}}, {
    "Exists", {HoldAll, ReadProtected}}, {
    "CompoundExpression", {HoldAll, ReadProtected}}, {"Do", {HoldAll}}, {
    "Which", {HoldAll}}, {"While", {HoldAll}}, {"Table", {HoldAll}}, {
    "If", {HoldRest}}, {
    "Switch", {
     HoldRest, 
      ReadProtected}}}]]], \
"Output",ExpressionUUID->"32e805ad-fee6-4311-9930-3be4d2e7fa63"]
}, Open  ]],

Cell["Other functions:", \
"Text",ExpressionUUID->"1c11887e-8660-4f9f-8f0a-a8f20e357495"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"other", "=", 
  RowBox[{"Complement", "[", 
   RowBox[{
   "$HeldNames", ",", "assignment", ",", "rulepatterns", ",", "operators", 
    ",", "evaluation", ",", "information", ",", "flow"}], 
   "]"}]}]], "Input",ExpressionUUID->"8fe6f588-96fe-4f71-9cda-4336a26392ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AbsoluteTiming\"\>", ",", "\<\"AlgebraicNumber\"\>", 
   ",", "\<\"Arrow3DBox\"\>", ",", "\<\"ArrowBox\"\>", ",", "\<\"Assert\"\>", 
   ",", "\<\"Assuming\"\>", ",", "\<\"BarabasiAlbertGraphDistribution\"\>", 
   ",", "\<\"BernoulliGraphDistribution\"\>", ",", "\<\"BezierCurve3DBox\"\>",
    ",", "\<\"BezierCurveBox\"\>", ",", "\<\"BlockRandom\"\>", 
   ",", "\<\"BSplineCurve3DBox\"\>", ",", "\<\"BSplineCurveBox\"\>", 
   ",", "\<\"BSplineSurface3DBox\"\>", ",", "\<\"Button\"\>", 
   ",", "\<\"C\"\>", ",", "\<\"CancelButton\"\>", 
   ",", "\<\"ChoiceButtons\"\>", ",", "\<\"CircleBox\"\>", 
   ",", "\<\"Compile\"\>", ",", "\<\"CompiledFunction\"\>", 
   ",", "\<\"ConeBox\"\>", ",", "\<\"ContinuedFractionK\"\>", 
   ",", "\<\"ControlActive\"\>", ",", "\<\"CreateScheduledTask\"\>", 
   ",", "\<\"CuboidBox\"\>", ",", "\<\"Cycles\"\>", 
   ",", "\<\"CylinderBox\"\>", ",", "\<\"DebugTag\"\>", 
   ",", "\<\"DefaultButton\"\>", ",", "\<\"DegreeGraphDistribution\"\>", 
   ",", "\<\"Derivative\"\>", ",", "\<\"Dialog\"\>", 
   ",", "\<\"DialogInput\"\>", ",", "\<\"DialogReturn\"\>", 
   ",", "\<\"DifferenceRoot\"\>", ",", "\<\"DifferentialRoot\"\>", 
   ",", "\<\"DiskBox\"\>", ",", "\<\"DisplayWith\"\>", 
   ",", "\<\"DisplayWithRef\"\>", ",", "\<\"DivisorSigma\"\>", 
   ",", "\<\"DivisorSum\"\>", ",", "\<\"Dynamic\"\>", 
   ",", "\<\"DynamicBox\"\>", ",", "\<\"DynamicModuleBox\"\>", 
   ",", "\<\"DynamicWrapperBox\"\>", ",", "\<\"FileName\"\>", 
   ",", "\<\"FilledCurveBox\"\>", ",", "\<\"FindArgMax\"\>", 
   ",", "\<\"FindArgMin\"\>", ",", "\<\"FindMaximum\"\>", 
   ",", "\<\"FindMaxValue\"\>", ",", "\<\"FindMinValue\"\>", 
   ",", "\<\"FrontEndValueCache\"\>", ",", "\<\"Function\"\>", 
   ",", "\<\"GeometricTransformation3DBox\"\>", 
   ",", "\<\"GeometricTransformationBox\"\>", ",", "\<\"Graph\"\>", 
   ",", "\<\"Graphics3DBox\"\>", ",", "\<\"GraphicsBox\"\>", 
   ",", "\<\"GraphicsComplex\"\>", ",", "\<\"GraphicsComplex3DBox\"\>", 
   ",", "\<\"GraphicsComplexBox\"\>", ",", "\<\"GraphicsGroup3DBox\"\>", 
   ",", "\<\"GraphicsGroupBox\"\>", ",", "\<\"GraphPropertyDistribution\"\>", 
   ",", "\<\"HexahedronBox\"\>", ",", "\<\"Inset3DBox\"\>", 
   ",", "\<\"InsetBox\"\>", ",", "\<\"InverseFunction\"\>", 
   ",", "\<\"JoinedCurveBox\"\>", ",", "\<\"LibraryFunction\"\>", 
   ",", "\<\"Line3DBox\"\>", ",", "\<\"LineBox\"\>", 
   ",", "\<\"MatchLocalNameQ\"\>", ",", "\<\"MaxMemoryUsed\"\>", 
   ",", "\<\"MemoryConstrained\"\>", ",", "\<\"MenuItem\"\>", 
   ",", "\<\"Monitor\"\>", ",", "\<\"Nand\"\>", ",", "\<\"NCache\"\>", 
   ",", "\<\"Nor\"\>", ",", "\<\"OptimumFlowData\"\>", 
   ",", "\<\"Overscript\"\>", ",", "\<\"ParametricFunction\"\>", 
   ",", "\<\"PathGraph\"\>", ",", "\<\"Piecewise\"\>", ",", "\<\"Play\"\>", 
   ",", "\<\"Point3DBox\"\>", ",", "\<\"PointBox\"\>", 
   ",", "\<\"Polygon3DBox\"\>", ",", "\<\"PolygonBox\"\>", 
   ",", "\<\"PreemptProtect\"\>", ",", "\<\"PriceGraphDistribution\"\>", 
   ",", "\<\"PrismBox\"\>", ",", "\<\"PyramidBox\"\>", 
   ",", "\<\"QPolyGamma\"\>", ",", "\<\"Quiet\"\>", 
   ",", "\<\"Raster3DBox\"\>", ",", "\<\"RasterBox\"\>", ",", "\<\"Reap\"\>", 
   ",", "\<\"RectangleBox\"\>", ",", "\<\"RefBox\"\>", ",", "\<\"Refresh\"\>",
    ",", "\<\"RunScheduledTask\"\>", ",", "\<\"SampledSoundFunction\"\>", 
   ",", "\<\"ScheduledTaskObject\"\>", ",", "\<\"ShortestPathFunction\"\>", 
   ",", "\<\"Slot\"\>", ",", "\<\"SlotSequence\"\>", 
   ",", "\<\"SpatialGraphDistribution\"\>", ",", "\<\"SphereBox\"\>", 
   ",", "\<\"Stack\"\>", ",", "\<\"StackBegin\"\>", 
   ",", "\<\"StackComplete\"\>", ",", "\<\"StackInhibit\"\>", 
   ",", "\<\"Subscript\"\>", ",", "\<\"Subsuperscript\"\>", 
   ",", "\<\"Superscript\"\>", ",", "\<\"SystemException\"\>", 
   ",", "\<\"TableViewBox\"\>", ",", "\<\"TetrahedronBox\"\>", 
   ",", "\<\"Text3DBox\"\>", ",", "\<\"TextBox\"\>", 
   ",", "\<\"TimeConstrained\"\>", ",", "\<\"Timing\"\>", 
   ",", "\<\"TreeGraph\"\>", ",", "\<\"TubeBezierCurveBox\"\>", 
   ",", "\<\"TubeBox\"\>", ",", "\<\"TubeBSplineCurveBox\"\>", 
   ",", "\<\"Underoverscript\"\>", ",", "\<\"Underscript\"\>", 
   ",", "\<\"UniformGraphDistribution\"\>", ",", "\<\"ValueQ\"\>", 
   ",", "\<\"WaitUntil\"\>", ",", "\<\"WattsStrogatzGraphDistribution\"\>", 
   ",", "\<\"WhenEvent\"\>", ",", "\<\"$ConditionHold\"\>", 
   ",", "\<\"$Failed\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"7071550a-12a9-4f2f-9f2d-fe68ab2503c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Attributes", "[", "#", "]"}], ",", "Protected"}], "]"}]}], 
     "}"}], "&"}], "/@", "other"}], "//", 
  "TableForm"}]], \
"Input",ExpressionUUID->"480109be-86c4-4757-ae90-73fe55a2bb3f"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"AbsoluteTiming\"\>", GridBox[{
       {"HoldAll"},
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"AlgebraicNumber\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Arrow3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ArrowBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Assert\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Assuming\"\>", GridBox[{
       {"HoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"BarabasiAlbertGraphDistribution\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"BernoulliGraphDistribution\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"BezierCurve3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"BezierCurveBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"BlockRandom\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"BSplineCurve3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"BSplineCurveBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"BSplineSurface3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Button\"\>", GridBox[{
       {"HoldRest"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"C\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"CancelButton\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ChoiceButtons\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"CircleBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Compile\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"CompiledFunction\"\>", GridBox[{
       {"HoldAll"},
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ConeBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ContinuedFractionK\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ControlActive\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"CreateScheduledTask\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"CuboidBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Cycles\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"CylinderBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DebugTag\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DefaultButton\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DegreeGraphDistribution\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Derivative\"\>", GridBox[{
       {"NHoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Dialog\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DialogInput\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DialogReturn\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DifferenceRoot\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DifferentialRoot\"\>", GridBox[{
       {"NHoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DiskBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DisplayWith\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DisplayWithRef\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DivisorSigma\"\>", GridBox[{
       {"Listable"},
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DivisorSum\"\>", GridBox[{
       {"NHoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Dynamic\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DynamicBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DynamicModuleBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"DynamicWrapperBox\"\>", GridBox[{
       {"HoldRest"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FileName\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FilledCurveBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FindArgMax\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FindArgMin\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FindMaximum\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FindMaxValue\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FindMinValue\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"FrontEndValueCache\"\>", GridBox[{
       {"NHoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Function\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"GeometricTransformation3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"GeometricTransformationBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Graph\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Graphics3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"GraphicsBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"GraphicsComplex\"\>", GridBox[{
       {"NHoldRest"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"GraphicsComplex3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"GraphicsComplexBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"GraphicsGroup3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"GraphicsGroupBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"GraphPropertyDistribution\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"HexahedronBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Inset3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"InsetBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"InverseFunction\"\>", GridBox[{
       {"NHoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"JoinedCurveBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"LibraryFunction\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Line3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"LineBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MatchLocalNameQ\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MaxMemoryUsed\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MemoryConstrained\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"MenuItem\"\>", GridBox[{
       {"HoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Monitor\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Nand\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"NCache\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Nor\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"OptimumFlowData\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Overscript\"\>", GridBox[{
       {"NHoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ParametricFunction\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PathGraph\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Piecewise\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Play\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Point3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PointBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Polygon3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PolygonBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PreemptProtect\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PriceGraphDistribution\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PrismBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"PyramidBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"QPolyGamma\"\>", GridBox[{
       {"Listable"},
       {"NHoldFirst"},
       {"NumericFunction"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Quiet\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Raster3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"RasterBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Reap\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"RectangleBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"RefBox\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Refresh\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"RunScheduledTask\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"SampledSoundFunction\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ScheduledTaskObject\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ShortestPathFunction\"\>", GridBox[{
       {"NHoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Slot\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"SlotSequence\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"SpatialGraphDistribution\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"SphereBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Stack\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"StackBegin\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"StackComplete\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"StackInhibit\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Subscript\"\>", GridBox[{
       {"NHoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Subsuperscript\"\>", GridBox[{
       {"NHoldRest"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Superscript\"\>", GridBox[{
       {"NHoldRest"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"SystemException\"\>", GridBox[{
       {"HoldAllComplete"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TableViewBox\"\>", GridBox[{
       {"HoldFirst"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TetrahedronBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Text3DBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TextBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TimeConstrained\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Timing\"\>", GridBox[{
       {"HoldAll"},
       {"SequenceHold"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TreeGraph\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TubeBezierCurveBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TubeBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"TubeBSplineCurveBox\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Underoverscript\"\>", GridBox[{
       {"NHoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"Underscript\"\>", GridBox[{
       {"NHoldRest"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"UniformGraphDistribution\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"ValueQ\"\>", GridBox[{
       {"HoldAll"},
       {"ReadProtected"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"WaitUntil\"\>", GridBox[{
       {"HoldFirst"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"WattsStrogatzGraphDistribution\"\>", GridBox[{
       {"NHoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"WhenEvent\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"$ConditionHold\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]},
    {"\<\"$Failed\"\>", GridBox[{
       {"HoldAll"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{"AbsoluteTiming", {HoldAll, SequenceHold}}, {
    "AlgebraicNumber", {NHoldAll}}, {
    "Arrow3DBox", {HoldAll, ReadProtected}}, {
    "ArrowBox", {HoldAll, ReadProtected}}, {"Assert", {HoldAllComplete}}, {
    "Assuming", {HoldRest}}, {
    "BarabasiAlbertGraphDistribution", {NHoldAll}}, {
    "BernoulliGraphDistribution", {NHoldAll}}, {
    "BezierCurve3DBox", {HoldAll, ReadProtected}}, {
    "BezierCurveBox", {HoldAll, ReadProtected}}, {"BlockRandom", {HoldAll}}, {
    "BSplineCurve3DBox", {HoldAll, ReadProtected}}, {
    "BSplineCurveBox", {HoldAll, ReadProtected}}, {
    "BSplineSurface3DBox", {HoldAll, ReadProtected}}, {
    "Button", {HoldRest, ReadProtected}}, {"C", {NHoldAll}}, {
    "CancelButton", {HoldAll, ReadProtected}}, {
    "ChoiceButtons", {HoldAll, ReadProtected}}, {
    "CircleBox", {HoldAll, ReadProtected}}, {"Compile", {HoldAll}}, {
    "CompiledFunction", {HoldAll, NHoldAll}}, {
    "ConeBox", {HoldAll, ReadProtected}}, {
    "ContinuedFractionK", {HoldAll, ReadProtected}}, {
    "ControlActive", {HoldAll, ReadProtected}}, {
    "CreateScheduledTask", {HoldFirst}}, {
    "CuboidBox", {HoldAll, ReadProtected}}, {"Cycles", {NHoldAll}}, {
    "CylinderBox", {HoldAll, ReadProtected}}, {
    "DebugTag", {HoldAllComplete}}, {
    "DefaultButton", {HoldAll, ReadProtected}}, {
    "DegreeGraphDistribution", {NHoldAll}}, {
    "Derivative", {NHoldAll, ReadProtected}}, {"Dialog", {HoldAll}}, {
    "DialogInput", {HoldAll, ReadProtected}}, {
    "DialogReturn", {HoldFirst, ReadProtected}}, {
    "DifferenceRoot", {NHoldAll}}, {
    "DifferentialRoot", {NHoldAll, ReadProtected}}, {
    "DiskBox", {HoldAll, ReadProtected}}, {
    "DisplayWith", {HoldAllComplete}}, {"DisplayWithRef", {HoldFirst}}, {
    "DivisorSigma", {Listable, NHoldAll}}, {
    "DivisorSum", {NHoldAll, ReadProtected}}, {
    "Dynamic", {HoldFirst, ReadProtected}}, {
    "DynamicBox", {HoldAll, ReadProtected}}, {
    "DynamicModuleBox", {HoldAll, ReadProtected}}, {
    "DynamicWrapperBox", {HoldRest, ReadProtected}}, {
    "FileName", {HoldAll, ReadProtected}}, {
    "FilledCurveBox", {HoldAll, ReadProtected}}, {"FindArgMax", {HoldAll}}, {
    "FindArgMin", {HoldAll}}, {"FindMaximum", {HoldAll}}, {
    "FindMaxValue", {HoldAll}}, {"FindMinValue", {HoldAll}}, {
    "FrontEndValueCache", {NHoldFirst}}, {"Function", {HoldAll}}, {
    "GeometricTransformation3DBox", {HoldAll, ReadProtected}}, {
    "GeometricTransformationBox", {HoldAll, ReadProtected}}, {
    "Graph", {NHoldAll}}, {"Graphics3DBox", {HoldAll, ReadProtected}}, {
    "GraphicsBox", {HoldAll, ReadProtected}}, {
    "GraphicsComplex", {NHoldRest, ReadProtected}}, {
    "GraphicsComplex3DBox", {HoldAll, ReadProtected}}, {
    "GraphicsComplexBox", {HoldAll, ReadProtected}}, {
    "GraphicsGroup3DBox", {HoldAll, ReadProtected}}, {
    "GraphicsGroupBox", {HoldAll, ReadProtected}}, {
    "GraphPropertyDistribution", {HoldAll, ReadProtected}}, {
    "HexahedronBox", {HoldAll, ReadProtected}}, {
    "Inset3DBox", {HoldAll, ReadProtected}}, {
    "InsetBox", {HoldAll, ReadProtected}}, {
    "InverseFunction", {NHoldAll, ReadProtected}}, {
    "JoinedCurveBox", {HoldAll, ReadProtected}}, {
    "LibraryFunction", {NHoldAll}}, {"Line3DBox", {HoldAll, ReadProtected}}, {
    "LineBox", {HoldAll, ReadProtected}}, {"MatchLocalNameQ", {HoldAll}}, {
    "MaxMemoryUsed", {HoldAll}}, {"MemoryConstrained", {HoldAll}}, {
    "MenuItem", {HoldRest}}, {"Monitor", {HoldAll, ReadProtected}}, {
    "Nand", {HoldAll}}, {"NCache", {HoldFirst, ReadProtected}}, {
    "Nor", {HoldAll}}, {"OptimumFlowData", {NHoldAll}}, {
    "Overscript", {NHoldRest}}, {"ParametricFunction", {HoldAllComplete}}, {
    "PathGraph", {NHoldAll}}, {"Piecewise", {HoldAll, ReadProtected}}, {
    "Play", {HoldAll}}, {"Point3DBox", {HoldAll, ReadProtected}}, {
    "PointBox", {HoldAll, ReadProtected}}, {
    "Polygon3DBox", {HoldAll, ReadProtected}}, {
    "PolygonBox", {HoldAll, ReadProtected}}, {
    "PreemptProtect", {HoldAllComplete}}, {
    "PriceGraphDistribution", {NHoldAll}}, {
    "PrismBox", {HoldAll, ReadProtected}}, {
    "PyramidBox", {HoldAll, ReadProtected}}, {
    "QPolyGamma", {Listable, NHoldFirst, NumericFunction}}, {
    "Quiet", {HoldAll}}, {"Raster3DBox", {HoldAll, ReadProtected}}, {
    "RasterBox", {HoldAll, ReadProtected}}, {"Reap", {HoldFirst}}, {
    "RectangleBox", {HoldAll, ReadProtected}}, {"RefBox", {HoldFirst}}, {
    "Refresh", {HoldFirst}}, {"RunScheduledTask", {HoldFirst}}, {
    "SampledSoundFunction", {HoldAll, ReadProtected}}, {
    "ScheduledTaskObject", {HoldAll}}, {
    "ShortestPathFunction", {NHoldAll, ReadProtected}}, {
    "Slot", {NHoldAll}}, {"SlotSequence", {NHoldAll}}, {
    "SpatialGraphDistribution", {NHoldAll}}, {
    "SphereBox", {HoldAll, ReadProtected}}, {"Stack", {HoldFirst}}, {
    "StackBegin", {HoldAll}}, {"StackComplete", {HoldAll}}, {
    "StackInhibit", {HoldAll}}, {"Subscript", {NHoldRest}}, {
    "Subsuperscript", {NHoldRest, ReadProtected}}, {
    "Superscript", {NHoldRest, ReadProtected}}, {
    "SystemException", {HoldAllComplete}}, {
    "TableViewBox", {HoldFirst, ReadProtected}}, {
    "TetrahedronBox", {HoldAll, ReadProtected}}, {
    "Text3DBox", {HoldAll, ReadProtected}}, {
    "TextBox", {HoldAll, ReadProtected}}, {"TimeConstrained", {HoldAll}}, {
    "Timing", {HoldAll, SequenceHold}}, {"TreeGraph", {NHoldAll}}, {
    "TubeBezierCurveBox", {HoldAll, ReadProtected}}, {
    "TubeBox", {HoldAll, ReadProtected}}, {
    "TubeBSplineCurveBox", {HoldAll, ReadProtected}}, {
    "Underoverscript", {NHoldRest}}, {"Underscript", {NHoldRest}}, {
    "UniformGraphDistribution", {NHoldAll}}, {
    "ValueQ", {HoldAll, ReadProtected}}, {"WaitUntil", {HoldFirst}}, {
    "WattsStrogatzGraphDistribution", {NHoldAll}}, {"WhenEvent", {HoldAll}}, {
    "$ConditionHold", {HoldAll}}, {
    "$Failed", {
     HoldAll}}}]]], \
"Output",ExpressionUUID->"d067e553-081f-46f9-8d52-de5e780aa5af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{"$HeldNames", ",", 
   RowBox[{"Join", "[", 
    RowBox[{
    "assignment", ",", "evaluation", ",", "flow", ",", "information", ",", 
     "operators", ",", "other", ",", "rulepatterns"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"bb08e72e-3a9a-44a6-8c95-b9c39893ac3c"],

Cell[BoxData[
 RowBox[{"{", 
  "}"}]], "Output",ExpressionUUID->"b6336dc3-cf20-499a-bb9e-51ee71282590"]
}, Open  ]],

Cell["\<\
I'm really surprised with these pattern heads. I would assume they need \
holding attributes:\
\>", "Text",ExpressionUUID->"a6e95457-8543-41c9-b958-825eaa519fe2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
    "assignment", ",", "evaluation", ",", "flow", ",", "information", ",", 
     "operators", ",", "other", ",", "rulepatterns"}], "]"}], ",", 
   "$HeldNames"}], 
  "]"}]], "Input",ExpressionUUID->"4995e8ed-b5f3-475b-ac05-fbce8f3c7519"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Alias\"\>", ",", "\<\"Blank\"\>", ",", "\<\"ConsolePrint\"\>", 
   ",", "\<\"ContourPlot\"\>", ",", "\<\"DensityPlot\"\>", 
   ",", "\<\"EditDefinition\"\>", ",", "\<\"ParametricPlot\"\>", 
   ",", "\<\"ParametricPlot3D\"\>", ",", "\<\"Plot\"\>", 
   ",", "\<\"Plot3D\"\>", ",", "\<\"PolyGamma\"\>", 
   ",", "\<\"StieltjesGamma\"\>", ",", "\<\"UnAlias\"\>", 
   ",", "\<\"Verbatim\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"f5854891-1e2a-4f75-9c4a-6c0643264f05"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "assignment", ",", "rulepatterns", ",", "operators", ",", "evaluation", ",",
    "information", ",", "flow", ",", "other"}], 
  "]"}]], "Input",ExpressionUUID->"f6ff1b4e-8e0f-4968-aa20-731bd5773f26"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.4. Capitals", \
"Subsubsection",ExpressionUUID->"73326f2b-724d-4b1b-bba1-f83bb52a31b7"],

Cell[TextData[{
 "There are several capital letters that could interfere with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"56cb967a-127c-4326-be78-53d63821c04a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"$SystemNames", ",", 
   RowBox[{"Alternatives", "@@", 
    RowBox[{"CharacterRange", "[", 
     RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"ed886c5d-d757-4ee4-b7d0-c78030351a82"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C\"\>", ",", "\<\"D\"\>", ",", "\<\"E\"\>", ",", "\<\"I\"\>", 
   ",", "\<\"K\"\>", ",", "\<\"N\"\>", ",", "\<\"O\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"06a691f6-afc7-4218-98da-d7dc483497b4"]
}, Open  ]],

Cell[TextData[{
 "They are actually the only names with length 1. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5 we also have $."
}], "Text",ExpressionUUID->"f17e193f-0489-44bd-90fa-e5ba50a7cf35"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$LengthOneNames", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"$SystemNames", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"StringLength", "[", "#", "]"}], "\[Equal]", "1"}], "&"}]}], 
   "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f01d7598-ae21-4ab0-82ff-65302c9f8f82"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[FormalA]\"\>", ",", "\<\"\[FormalB]\"\>", 
   ",", "\<\"\[FormalC]\"\>", ",", "\<\"\[FormalD]\"\>", 
   ",", "\<\"\[FormalE]\"\>", ",", "\<\"\[FormalF]\"\>", 
   ",", "\<\"\[FormalG]\"\>", ",", "\<\"\[FormalH]\"\>", 
   ",", "\<\"\[FormalI]\"\>", ",", "\<\"\[FormalJ]\"\>", 
   ",", "\<\"\[FormalK]\"\>", ",", "\<\"\[FormalL]\"\>", 
   ",", "\<\"\[FormalM]\"\>", ",", "\<\"\[FormalN]\"\>", 
   ",", "\<\"\[FormalO]\"\>", ",", "\<\"\[FormalP]\"\>", 
   ",", "\<\"\[FormalQ]\"\>", ",", "\<\"\[FormalR]\"\>", 
   ",", "\<\"\[FormalS]\"\>", ",", "\<\"\[FormalT]\"\>", 
   ",", "\<\"\[FormalU]\"\>", ",", "\<\"\[FormalV]\"\>", 
   ",", "\<\"\[FormalW]\"\>", ",", "\<\"\[FormalX]\"\>", 
   ",", "\<\"\[FormalY]\"\>", ",", "\<\"\[FormalZ]\"\>", 
   ",", "\<\"\[FormalCapitalA]\"\>", ",", "\<\"\[FormalCapitalB]\"\>", 
   ",", "\<\"\[FormalCapitalC]\"\>", ",", "\<\"\[FormalCapitalD]\"\>", 
   ",", "\<\"\[FormalCapitalE]\"\>", ",", "\<\"\[FormalCapitalF]\"\>", 
   ",", "\<\"\[FormalCapitalG]\"\>", ",", "\<\"\[FormalCapitalH]\"\>", 
   ",", "\<\"\[FormalCapitalI]\"\>", ",", "\<\"\[FormalCapitalJ]\"\>", 
   ",", "\<\"\[FormalCapitalK]\"\>", ",", "\<\"\[FormalCapitalL]\"\>", 
   ",", "\<\"\[FormalCapitalM]\"\>", ",", "\<\"\[FormalCapitalN]\"\>", 
   ",", "\<\"\[FormalCapitalO]\"\>", ",", "\<\"\[FormalCapitalP]\"\>", 
   ",", "\<\"\[FormalCapitalQ]\"\>", ",", "\<\"\[FormalCapitalR]\"\>", 
   ",", "\<\"\[FormalCapitalS]\"\>", ",", "\<\"\[FormalCapitalT]\"\>", 
   ",", "\<\"\[FormalCapitalU]\"\>", ",", "\<\"\[FormalCapitalV]\"\>", 
   ",", "\<\"\[FormalCapitalW]\"\>", ",", "\<\"\[FormalCapitalX]\"\>", 
   ",", "\<\"\[FormalCapitalY]\"\>", ",", "\<\"\[FormalCapitalZ]\"\>", 
   ",", "\<\"C\"\>", ",", "\<\"D\"\>", ",", "\<\"E\"\>", ",", "\<\"I\"\>", 
   ",", "\<\"K\"\>", ",", "\<\"N\"\>", ",", "\<\"O\"\>", 
   ",", "\<\"\[SystemsModelDelay]\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"463b5c42-e0e9-4b52-8ea6-d2c2c946e1f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "$"}]], "Input",ExpressionUUID->"823146c1-25f5-4d8c-a8eb-aa831da6996b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Information", "::", "notfound"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"$\\\"\\)\[NoBreak] not found. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/notfound\\\", \
ButtonNote -> \\\"Information::notfound\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"8d3ec9a5-2973-4534-ba8a-b9702aeda05c"]
}, Open  ]],

Cell["Two of them have special output:", \
"Text",ExpressionUUID->"271264c8-7f2f-4659-9440-5484b888a15f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"C", ",", "D", ",", "E", ",", "I", ",", "K", ",", "N", ",", "O"}], 
  "}"}]], "Input",ExpressionUUID->"b8f537f7-e021-40b9-b30b-720ca762dc08"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "C", ",", "D", ",", "\[ExponentialE]", ",", "\[ImaginaryI]", ",", "K", ",", 
   "N", ",", "O"}], 
  "}"}]], "Output",ExpressionUUID->"3880dc7a-25af-4468-9475-d251c20f758e"]
}, Open  ]],

Cell[TextData[{
 "but the default output for ",
 "E",
 " can be changed. In the past this was included in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " to allow ",
 "E",
 " to be an index. Now it is not allowed and the output is not modified by \
default."
}], "Text",ExpressionUUID->"5ccb23a9-42de-4400-a305-63d5439cbfd3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "E", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{"E", ",", "_"}], "]"}], "^=", "\"\<E\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "E", "]"}], ";"}]}], "Input",
 Evaluatable->False,ExpressionUUID->"a96a28cb-263a-4928-ae83-a74db13c81e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"C", ",", "D", ",", "E", ",", "I", ",", "K", ",", "N", ",", "O"}], 
  "}"}]], "Input",
 Evaluatable->False,ExpressionUUID->"6a1344a7-fdc8-4c4a-96da-5eab4a9cacf0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "C", ",", "D", ",", "E", ",", "\[ImaginaryI]", ",", "K", ",", "N", ",", 
   "O"}], "}"}]], \
"Output",ExpressionUUID->"7aea65bd-9982-463e-bbcc-a450cade67a7"]
}, Open  ]],

Cell["\<\
However I is locked. Then I cannot be registered as a tensor or an index (I \
would really prefer to be a tensor, really... ).\
\>", "Text",ExpressionUUID->"fc5a94e4-8a30-468c-a923-44e508f341c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "I", 
  "]"}]], "Input",ExpressionUUID->"e7a149bf-acdd-47d2-8e9c-b57232bf6b72"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Locked", ",", "Protected", ",", "ReadProtected"}], 
  "}"}]], "Output",ExpressionUUID->"0cd27cfa-b253-4f22-88ee-2e0f29479d47"]
}, Open  ]],

Cell["\<\
Problem: values for D, E, O are ReadProtected and have associated MakeBoxes \
definitions.\
\>", "Text",ExpressionUUID->"26dd4652-a54c-47d6-9efd-6e0baeaf52f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "/@", 
  RowBox[{"{", 
   RowBox[{"C", ",", "D", ",", "E", ",", "K", ",", "N", ",", "O"}], 
   "}"}]}]], "Input",ExpressionUUID->"32afcb34-2a85-47f5-b668-aee17e602b6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"NHoldAll", ",", "Protected"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Protected", ",", "ReadProtected"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Constant", ",", "Protected", ",", "ReadProtected"}], "}"}], ",", 
   
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "Protected", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Protected", ",", "ReadProtected"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"e29c7e76-f9fb-4513-aea1-ffbcb8fea971"]
}, Open  ]],

Cell["\<\
Is there any problem in removing readprotection for them? At the moment I do \
not do it.\
\>", "Text",ExpressionUUID->"17bccb29-904a-4227-8f9c-145edb2f0fbb"],

Cell[TextData[{
 "Another question is whether the declaration of C, D, K, N, O as indices \
might interfere with their ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " meanings. The answer depends on the context given to them. They have \
originally context System`. We have two options: using System`D as an index \
or using Global`D as an index, etc. The first option has the possible problem \
of interfeering definitions; the second option has the problem of requiring \
to write System`D when we want a derivative, etc. "
}], "Text",ExpressionUUID->"e5e25913-35d6-4e1a-990c-787b2d216de9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "/@", 
  "$LengthOneNames"}]], \
"Input",ExpressionUUID->"276e20aa-d137-4dd3-a33b-34d6237f974b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"345b5b96-baf7-4462-9e06-fee50ece17cb"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.5. Lengths", \
"Subsubsection",ExpressionUUID->"39039664-3594-4931-a5bb-fa6568651401"],

Cell[BoxData[
 RowBox[{
  RowBox[{"withlengths", "=", 
   RowBox[{"Split", "[", 
    RowBox[{
     RowBox[{"Sort", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"StringLength", "[", "#", "]"}], ",", "#"}], "}"}], "&"}], "/@",
        "$SystemNames"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"First", "[", "#1", "]"}], "===", 
       RowBox[{"First", "[", "#2", "]"}]}], "&"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"aaeab9ed-918f-4441-8c00-b60dfb5bcebf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "/@", 
  RowBox[{"withlengths", "[", 
   RowBox[{"[", "1", "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"d8547b8f-6adc-42bd-ba87-3ca2faa37fd2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[FormalA]\"\>", ",", "\<\"\[FormalB]\"\>", 
   ",", "\<\"\[FormalC]\"\>", ",", "\<\"\[FormalD]\"\>", 
   ",", "\<\"\[FormalE]\"\>", ",", "\<\"\[FormalF]\"\>", 
   ",", "\<\"\[FormalG]\"\>", ",", "\<\"\[FormalH]\"\>", 
   ",", "\<\"\[FormalI]\"\>", ",", "\<\"\[FormalJ]\"\>", 
   ",", "\<\"\[FormalK]\"\>", ",", "\<\"\[FormalL]\"\>", 
   ",", "\<\"\[FormalM]\"\>", ",", "\<\"\[FormalN]\"\>", 
   ",", "\<\"\[FormalO]\"\>", ",", "\<\"\[FormalP]\"\>", 
   ",", "\<\"\[FormalQ]\"\>", ",", "\<\"\[FormalR]\"\>", 
   ",", "\<\"\[FormalS]\"\>", ",", "\<\"\[FormalT]\"\>", 
   ",", "\<\"\[FormalU]\"\>", ",", "\<\"\[FormalV]\"\>", 
   ",", "\<\"\[FormalW]\"\>", ",", "\<\"\[FormalX]\"\>", 
   ",", "\<\"\[FormalY]\"\>", ",", "\<\"\[FormalZ]\"\>", 
   ",", "\<\"\[FormalCapitalA]\"\>", ",", "\<\"\[FormalCapitalB]\"\>", 
   ",", "\<\"\[FormalCapitalC]\"\>", ",", "\<\"\[FormalCapitalD]\"\>", 
   ",", "\<\"\[FormalCapitalE]\"\>", ",", "\<\"\[FormalCapitalF]\"\>", 
   ",", "\<\"\[FormalCapitalG]\"\>", ",", "\<\"\[FormalCapitalH]\"\>", 
   ",", "\<\"\[FormalCapitalI]\"\>", ",", "\<\"\[FormalCapitalJ]\"\>", 
   ",", "\<\"\[FormalCapitalK]\"\>", ",", "\<\"\[FormalCapitalL]\"\>", 
   ",", "\<\"\[FormalCapitalM]\"\>", ",", "\<\"\[FormalCapitalN]\"\>", 
   ",", "\<\"\[FormalCapitalO]\"\>", ",", "\<\"\[FormalCapitalP]\"\>", 
   ",", "\<\"\[FormalCapitalQ]\"\>", ",", "\<\"\[FormalCapitalR]\"\>", 
   ",", "\<\"\[FormalCapitalS]\"\>", ",", "\<\"\[FormalCapitalT]\"\>", 
   ",", "\<\"\[FormalCapitalU]\"\>", ",", "\<\"\[FormalCapitalV]\"\>", 
   ",", "\<\"\[FormalCapitalW]\"\>", ",", "\<\"\[FormalCapitalX]\"\>", 
   ",", "\<\"\[FormalCapitalY]\"\>", ",", "\<\"\[FormalCapitalZ]\"\>", 
   ",", "\<\"C\"\>", ",", "\<\"D\"\>", ",", "\<\"E\"\>", ",", "\<\"I\"\>", 
   ",", "\<\"K\"\>", ",", "\<\"N\"\>", ",", "\<\"O\"\>", 
   ",", "\<\"\[SystemsModelDelay]\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"1ac5279a-9964-46d2-8ad9-08c1ccb07ef0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "/@", 
  RowBox[{"withlengths", "[", 
   RowBox[{"[", "2", "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"addb0b36-0c4e-4f11-aa70-7a815b7b2b99"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Do\"\>", ",", "\<\"Dt\"\>", ",", "\<\"If\"\>", 
   ",", "\<\"Im\"\>", ",", "\<\"In\"\>", ",", "\<\"On\"\>", ",", "\<\"Or\"\>",
    ",", "\<\"Pi\"\>", ",", "\<\"Re\"\>", ",", "\<\"Tr\"\>", 
   ",", "\<\"Up\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"0edca018-5495-44f1-88c6-122f177c0d74"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "/@", 
  RowBox[{"withlengths", "[", 
   RowBox[{"[", "3", "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"9b3adec6-c2a6-4f04-b2fd-7ef77421946f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Abs\"\>", ",", "\<\"All\"\>", ",", "\<\"And\"\>", 
   ",", "\<\"Arg\"\>", ",", "\<\"Box\"\>", ",", "\<\"Bra\"\>", 
   ",", "\<\"Cap\"\>", ",", "\<\"CDF\"\>", ",", "\<\"Cos\"\>", 
   ",", "\<\"Cot\"\>", ",", "\<\"Csc\"\>", ",", "\<\"Cup\"\>", 
   ",", "\<\"Del\"\>", ",", "\<\"Det\"\>", ",", "\<\"Div\"\>", 
   ",", "\<\"Dot\"\>", ",", "\<\"End\"\>", ",", "\<\"Erf\"\>", 
   ",", "\<\"Exp\"\>", ",", "\<\"Fit\"\>", ",", "\<\"For\"\>", 
   ",", "\<\"GCD\"\>", ",", "\<\"Get\"\>", ",", "\<\"Hue\"\>", 
   ",", "\<\"Ket\"\>", ",", "\<\"LCM\"\>", ",", "\<\"Log\"\>", 
   ",", "\<\"Map\"\>", ",", "\<\"Max\"\>", ",", "\<\"Min\"\>", 
   ",", "\<\"Mod\"\>", ",", "\<\"Nor\"\>", ",", "\<\"Not\"\>", 
   ",", "\<\"Off\"\>", ",", "\<\"Out\"\>", ",", "\<\"PDF\"\>", 
   ",", "\<\"Put\"\>", ",", "\<\"Raw\"\>", ",", "\<\"Red\"\>", 
   ",", "\<\"Row\"\>", ",", "\<\"Run\"\>", ",", "\<\"Sec\"\>", 
   ",", "\<\"Set\"\>", ",", "\<\"Sin\"\>", ",", "\<\"Sow\"\>", 
   ",", "\<\"Sum\"\>", ",", "\<\"Tab\"\>", ",", "\<\"Tan\"\>", 
   ",", "\<\"Top\"\>", ",", "\<\"URL\"\>", ",", "\<\"Vee\"\>", 
   ",", "\<\"Xor\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"375428c6-2b1b-4dd0-9d6f-47573b0bb956"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"withlengths", "[", 
  RowBox[{"[", 
   RowBox[{"-", "3"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"3d2f362a-8821-46dd-8a04-83f2cc26a28d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"35", ",", "\<\"GeometricTransformation3DBoxOptions\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"35", ",", "\<\"WalleniusHypergeometricDistribution\"\>"}], 
    "}"}]}], "}"}]], \
"Output",ExpressionUUID->"d201c833-f663-4183-a6ce-b1de7446af91"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"withlengths", "[", 
  RowBox[{"[", 
   RowBox[{"-", "2"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"c41ae657-2ebd-4d5b-b104-7452dc57e80e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"36", ",", "\<\"NotebookSetupLayoutInformationPacket\"\>"}], "}"}],
   "}"}]], "Output",ExpressionUUID->"44f0591a-6d68-4e28-91ad-b2f7ec59c9f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"withlengths", "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"555e7296-07da-4196-af30-cd7213860dfe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"38", ",", "\<\"MultivariateHypergeometricDistribution\"\>"}], 
   "}"}], "}"}]], \
"Output",ExpressionUUID->"488fcb07-fdb2-47da-94f6-23d71231620b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{"First", "[", "#", "]"}], "]"}], ",", 
     RowBox[{"Length", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
  "withlengths"}]], \
"Input",ExpressionUUID->"f65e501b-72b3-409e-aeea-fc8a2912b3e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "60"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "52"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "109"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "130"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "147"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "194"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "267"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "300"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "311"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "334"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "323"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "292"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "316"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "285"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "260"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "230"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "163"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "127"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "125"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "111"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "81"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "85"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "63"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "46"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"35", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "1"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"f6dc00b2-c30c-4fa8-bf6f-96b75135ec1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0", "]"}], ",", 
      RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"9d6bd267-90e2-429f-b406-5f2b2ac1078a"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0, 1, 1], PointSize[0.02], PointBox[CompressedData["
1:eJxdkksOAUEQQDtWlhYWFhZMEBGR8f8zWEgsSISVhcmExEJifA4wR3IER3AE
R3AEpF5J6KTz8rqqujvVnfQO823IGJN+zw9lPPvCqcMCzMAwnMCI0FnhUdzF
Y0LXw+PEd3hCePVxS3g74Smhf/69x+OCZ4W2eo79tT7PflpfEN6PuE2+nl8k
f4+XuP8GLxNf4xXq1avEtR814gu8ji/xhjCY4U04hi3Yg23Y+aPmdaH1V0cf
TR/SB+NA+hqo865mAHn3QF3/xRDqvxl9/QUrXDOL
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 38.}, {0, 334.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0.76, 0.76}, {6.68, 
   6.68}}]], "Output",ExpressionUUID->"00f42c48-b29c-408c-bba7-a92fd775a972"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "withlengths", 
  "]"}]], "Input",ExpressionUUID->"183d7a77-f49f-42e1-a5b3-a345d58bc94b"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.6. FindSymbols", \
"Subsubsection",ExpressionUUID->"c4c70896-1ffe-4d9b-9cdd-b576c6835cfb"],

Cell["\<\
We can detect all symbols of an expression using FindSymbols. Strings and \
numeric quantities are removed. The function Hold in the definition holds the \
symbols found by Level; the function Cases evaluates the result by default, \
but if we use a function f that holds its arguments then the symbols are not \
evaluated. Note that repeated elements appear several times:\
\>", "Text",ExpressionUUID->"32f1f35e-41c2-4c7e-beff-e6c67764f85e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "FindSymbols"}]], \
"Input",ExpressionUUID->"8963a7d9-0941-44bb-9d07-5386bdb62532"],

Cell[BoxData[
 StyleBox["\<\"FindSymbols[expr] gives the list of all symbols in expr, \
without evaluating expr. FindSymbols[expr, f] gives the list of all symbols \
in expr, each wrapped with the function f; if the function f has a Hold \
attribute then none of the symbols of expr is evaluated in the process.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974404-4493425",ExpressionUUID->"d62c74bd-3ca4-405d-b63f-\
efd68429ba58"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"FindSymbols", ",", "HoldAllComplete"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindSymbols", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"f_", ":", "Identity"}]}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Level", "[", 
      RowBox[{
       RowBox[{"Unevaluated", "[", "expr", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
       RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"x_Symbol", "\[RuleDelayed]", 
      RowBox[{"f", "[", "x", "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindSymbols", "[", "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"FindSymbols", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "FindSymbols", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"11646ef6-2e1c-4843-97a3-1a1dac7082ab"],

Cell["It is only used by UnknownSymbols.", \
"Text",ExpressionUUID->"1e3163ac-9079-47bb-9fe0-67671a13d3d5"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"d850cfb4-3041-42c2-93a5-8987512c3b57"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{"a1", "+", 
   RowBox[{"a2", "[", "b", "]"}], "+", 
   RowBox[{
    RowBox[{"a3", "[", "c", "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"d", ",", 
      RowBox[{"1", "+", "2"}]}], "}"}], "]"}], "+", 
   RowBox[{
    RowBox[{"a4", "[", 
     RowBox[{"e", "[", 
      RowBox[{"f", "[", "g", "]"}], "]"}], "]"}], "[", 
    RowBox[{"h", " ", "i"}], "]"}], "+", 
   RowBox[{"f", "[", "\"\<Hello\>\"", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"d20c5dab-7157-4504-9add-7e1ab44e6a14"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Plus", ",", "a1", ",", "a2", ",", "b", ",", "a3", ",", "c", ",", "List", 
   ",", "d", ",", "Plus", ",", "a4", ",", "e", ",", "f", ",", "g", ",", 
   "Times", ",", "h", ",", "i", ",", "f"}], 
  "}"}]], "Output",ExpressionUUID->"b893fbf7-5839-4cc0-ab79-5956e68eb1bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{"3", "a"}], 
  "]"}]], "Input",ExpressionUUID->"c831165a-6ba7-4027-ae16-8ba5a66bdb01"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Times", ",", "a"}], 
  "}"}]], "Output",ExpressionUUID->"ee641449-6584-4aeb-8153-fd7d002d80e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", "a", 
  "]"}]], "Input",ExpressionUUID->"ab695e25-6e1e-4880-8637-445b23621610"],

Cell[BoxData[
 RowBox[{"{", "a", 
  "}"}]], "Output",ExpressionUUID->"5495413c-b2d3-4274-a05b-202660ea2bae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{"{", "}"}], 
  "]"}]], "Input",ExpressionUUID->"37fd6caa-116c-4e43-9c22-57d5f5d5f98b"],

Cell[BoxData[
 RowBox[{"{", "List", 
  "}"}]], "Output",ExpressionUUID->"540b1291-d505-4970-b71d-d6a0529005b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  "]"}]], "Input",ExpressionUUID->"04648951-2f1c-47aa-a1ef-3737134d98d1"],

Cell[BoxData[
 RowBox[{"{", 
  "}"}]], "Output",ExpressionUUID->"36a09198-c832-4d0f-a3a7-a5e726ed9836"]
}, Open  ]],

Cell["We can map the symbols with some head:", \
"Text",ExpressionUUID->"2f2f0982-f2a9-4cbe-a580-241e5ea9451f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{
   RowBox[{"3", "b"}], "+", "c"}], 
  "]"}]], "Input",ExpressionUUID->"b20641f3-73ef-475f-857e-356e6e47efd4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Plus", ",", "Times", ",", "b", ",", "c"}], 
  "}"}]], "Output",ExpressionUUID->"1dd9dd92-b17e-42fb-a136-824abd2d85fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "b"}], "+", "c"}], ",", "f"}], 
  "]"}]], "Input",ExpressionUUID->"15d8c579-97a2-438f-9f8b-29d172a13423"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "Plus", "]"}], ",", 
   RowBox[{"f", "[", "Times", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"8fe12054-69a8-4740-84ae-37cda04df322"]
}, Open  ]],

Cell["\<\
If a symbol can be evaluated, then it will be evaluated by default, but we \
can use a head with some Hold attribute to avoid it:\
\>", "Text",ExpressionUUID->"4095b4d6-189f-4e16-b426-0269eecfa9ff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "b"}], 
  ";"}]], "Input",ExpressionUUID->"b93ec891-2246-4247-a92c-99ac4ba9bf6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{
   RowBox[{"3", "a"}], "+", "c"}], 
  "]"}]], "Input",ExpressionUUID->"7f59e8e0-44ac-4f18-8bce-7e7a04b1866e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Plus", ",", "Times", ",", "b", ",", "c"}], 
  "}"}]], "Output",ExpressionUUID->"404f462e-efc8-4ba8-b574-9e0efeadd556"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"FindSymbols", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"3", "a"}], "+", "c"}], ",", "HoldForm"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"fac21935-e8e0-444a-9210-a5b7bb2e9e2f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"FindSymbols", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"3", " ", "a"}], "+", "c"}], ",", "HoldForm"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"Unevaluated", "[", 
         RowBox[{
          RowBox[{"3", " ", "a"}], "+", "c"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", "a"}], "+", "c"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"Hold", "[", 
       RowBox[{"Plus", ",", "Times", ",", "3", ",", "a", ",", "c"}], "]"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Hold", "[", 
       RowBox[{"Plus", ",", "Times", ",", "3", ",", "a", ",", "c"}], "]"}], 
      ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      TagBox["Plus",
       HoldForm], ",", 
      TagBox["Times",
       HoldForm], ",", 
      TagBox["a",
       HoldForm], ",", 
      TagBox["c",
       HoldForm]}], "}"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"0e8572e4-26c4-43c3-84c8-f319a1383bdb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{
    RowBox[{"3", "a"}], "+", "c"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"d7151728-987f-4120-840c-e880a77dd5dd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Hold", ",", "Plus", ",", "Times", ",", "b", ",", "c"}], 
  "}"}]], "Output",ExpressionUUID->"c8dbd1de-4e3b-496f-a46d-4db189ad1a70"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"FindSymbols", "[", 
   RowBox[{
    RowBox[{"FindSymbols", "[", 
     RowBox[{
      RowBox[{"a", "[", "b", "]"}], "+", "c"}], "]"}], ",", "Hold"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"ba7a6141-1691-43f2-921f-14be36a8e173"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"FindSymbols", "[", 
     RowBox[{
      RowBox[{"FindSymbols", "[", 
       RowBox[{
        RowBox[{"a", "[", "b", "]"}], "+", "c"}], "]"}], ",", "Hold"}], "]"}],
    
    HoldForm], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"Unevaluated", "[", 
         RowBox[{"FindSymbols", "[", 
          RowBox[{
           RowBox[{"a", "[", "b", "]"}], "+", "c"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       RowBox[{"Hold", "[", "xAct`xCore`Private`x$", "]"}]}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"FindSymbols", "[", 
         RowBox[{
          RowBox[{"a", "[", "b", "]"}], "+", "c"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"Hold", "[", 
       RowBox[{"FindSymbols", ",", "Plus", ",", "a", ",", "b", ",", "c"}], 
       "]"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       RowBox[{"Hold", "[", "xAct`xCore`Private`x$", "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       RowBox[{"Hold", "[", "xAct`xCore`Private`x$", "]"}]}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Hold", "[", 
       RowBox[{"FindSymbols", ",", "Plus", ",", "a", ",", "b", ",", "c"}], 
       "]"}], ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       RowBox[{"Hold", "[", "xAct`xCore`Private`x$", "]"}]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hold", "[", "FindSymbols", "]"}], ",", 
      RowBox[{"Hold", "[", "Plus", "]"}], ",", 
      RowBox[{"Hold", "[", "a", "]"}], ",", 
      RowBox[{"Hold", "[", "b", "]"}], ",", 
      RowBox[{"Hold", "[", "c", "]"}]}], "}"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"43a66126-de19-4417-bb23-d2f76bfd1eb3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"FindSymbols", "[", 
   RowBox[{
    RowBox[{"Sequence", "[", 
     RowBox[{"a", "+", "b"}], "]"}], ",", "HoldForm"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"c538e7f3-f698-467b-b2ae-3859128e1d18"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"FindSymbols", "[", 
     RowBox[{
      RowBox[{"Sequence", "[", 
       RowBox[{"a", "+", "b"}], "]"}], ",", "HoldForm"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"Unevaluated", "[", 
         RowBox[{"Sequence", "[", 
          RowBox[{"a", "+", "b"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"Sequence", "[", 
         RowBox[{"a", "+", "b"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"Hold", "[", 
       RowBox[{"Sequence", ",", "Plus", ",", "a", ",", "b"}], "]"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Hold", "[", 
       RowBox[{"Sequence", ",", "Plus", ",", "a", ",", "b"}], "]"}], ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      TagBox["Sequence",
       HoldForm], ",", 
      TagBox["Plus",
       HoldForm], ",", 
      TagBox["a",
       HoldForm], ",", 
      TagBox["b",
       HoldForm]}], "}"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"05b18d55-3349-4b12-80bf-ee7db12c2e7e"]
}, Open  ]],

Cell["\<\
Note that Evaluate does not really evaluate the symbol a in the next two \
examples. FindSymbols allows no evaluation at all due to its HoldAllComplete \
attribute\
\>", "Text",ExpressionUUID->"5dd28a2e-2724-43b5-a674-500d53dedad2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"FindSymbols", "[", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"a", "+", "b"}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"df0e65e0-2647-4751-b83e-8776e2a9771c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"FindSymbols", "[", 
     RowBox[{"Evaluate", "[", 
      RowBox[{"a", "+", "b"}], "]"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"Unevaluated", "[", 
         RowBox[{"Evaluate", "[", 
          RowBox[{"a", "+", "b"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       RowBox[{"Identity", "[", "xAct`xCore`Private`x$", "]"}]}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "+", "b"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"Hold", "[", 
       RowBox[{"Evaluate", ",", "Plus", ",", "a", ",", "b"}], "]"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       RowBox[{"Identity", "[", "xAct`xCore`Private`x$", "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       RowBox[{"Identity", "[", "xAct`xCore`Private`x$", "]"}]}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Hold", "[", 
       RowBox[{"Evaluate", ",", "Plus", ",", "a", ",", "b"}], "]"}], ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       RowBox[{"Identity", "[", "xAct`xCore`Private`x$", "]"}]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Identity", "[", "Evaluate", "]"}], ",", 
      RowBox[{"Identity", "[", "Plus", "]"}], ",", 
      RowBox[{"Identity", "[", "a", "]"}], ",", 
      RowBox[{"Identity", "[", "b", "]"}]}], "}"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Identity", "[", "Evaluate", "]"}],
      HoldForm], ",", 
     TagBox["Evaluate",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Identity", "[", "Plus", "]"}],
      HoldForm], ",", 
     TagBox["Plus",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox["a",
        HoldForm], ",", 
       TagBox["b",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Identity", "[", "b", "]"}],
      HoldForm], ",", 
     TagBox["b",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Identity", "[", "b", "]"}],
      HoldForm], ",", 
     TagBox["b",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{"Evaluate", ",", "Plus", ",", "b", ",", "b"}], "}"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"f5f05364-d4de-4e66-892e-474959725ef6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"FindSymbols", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"a", "+", "b"}], "]"}], ",", "HoldForm"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"95709b1f-2985-410b-848d-fabe7a236bb0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"FindSymbols", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"a", "+", "b"}], "]"}], ",", "HoldForm"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"Unevaluated", "[", 
         RowBox[{"Evaluate", "[", 
          RowBox[{"a", "+", "b"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Heads", "\[Rule]", "True"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "+", "b"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}], ",", "Hold", ",", 
        RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"Hold", "[", 
       RowBox[{"Evaluate", ",", "Plus", ",", "a", ",", "b"}], "]"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"Hold", "[", 
       RowBox[{"Evaluate", ",", "Plus", ",", "a", ",", "b"}], "]"}], ",", 
      RowBox[{"xAct`xCore`Private`x$_Symbol", "\[RuleDelayed]", 
       TagBox["xAct`xCore`Private`x$",
        HoldForm]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      TagBox["Evaluate",
       HoldForm], ",", 
      TagBox["Plus",
       HoldForm], ",", 
      TagBox["a",
       HoldForm], ",", 
      TagBox["b",
       HoldForm]}], "}"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"c7b48a77-c752-48ee-af47-1898e91d88fe"]
}, Open  ]],

Cell["Study these additional cases:", \
"Text",ExpressionUUID->"ce79e6dc-8408-4dc4-8c96-14341366468c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"a", "^", "2"}]}], "]"}], ",", "HoldForm"}], 
  "]"}]], "Input",ExpressionUUID->"d6d5dba4-1851-4ad8-b5bc-f7e694b113cb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Function",
    HoldForm], ",", 
   TagBox["List",
    HoldForm], ",", 
   TagBox["a",
    HoldForm], ",", 
   TagBox["Power",
    HoldForm], ",", 
   TagBox["a",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"37ea86ca-bdc3-4d1b-b65c-00d5369eeb7a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{"x", "^", "2"}], 
  "]"}]], "Input",ExpressionUUID->"08ec4565-0f29-489c-949e-0f7e190fb7fa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Power", ",", "x"}], 
  "}"}]], "Output",ExpressionUUID->"d46386cd-0628-47d5-bcb5-2deb52fce925"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSymbols", "[", 
  RowBox[{"#", "^", "2"}], 
  "]"}]], "Input",ExpressionUUID->"752acd99-bfb3-41b9-b114-194fcbfd2ccc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Power", ",", "Slot"}], 
  "}"}]], "Output",ExpressionUUID->"2dd61b13-c019-49bb-8e85-a81a9eefd64c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h", 
   ",", "i", ",", "a1", ",", "a2", ",", "a3", ",", "a4", ",", "x"}], 
  "]"}]], "Input",ExpressionUUID->"55b843d4-5d22-40b1-b256-c8186a1182c9"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"a148e63d-3111-4c1f-9403-124eba9f4157"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. ValidateSymbol", \
"Subsection",ExpressionUUID->"13ed8ff2-b5ea-4bf3-a1f5-ea60d5e4e62f"],

Cell["\<\
Detect whether a symbol (or character) is a capital in the System` context:\
\>", "Text",ExpressionUUID->"3a1ffdeb-a0b1-4123-a6bc-9ac833b3f950"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SystemCapitalQ", "[", "symbol_", "]"}], ":=", 
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{"$LengthOneNames", ",", 
       RowBox[{"ToString", "[", "symbol", "]"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"Context", "[", "symbol", "]"}], "===", "\"\<System`\>\""}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"314974d1-5f76-41f6-a798-8242551caac8"],

Cell[TextData[{
 "With this function we check that a symbol is valid and that it is not \
already in use by ",
 StyleBox["xCor",
  FontSlant->"Italic"],
 "e, ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 ", ",
 StyleBox["xTensor,",
  FontSlant->"Italic"],
 " ",
 StyleBox["ExpressionManipulation",
  FontSlant->"Italic"],
 " or ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The checks are performed in a slightly different order from that given in \
the usage message. As we said, this should be generalized to include other \
packages like ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"0fbaaffd-255f-452f-8ae4-d706f0fd0b8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ValidateSymbol"}]], \
"Input",ExpressionUUID->"88d62ae8-feab-48aa-8194-78c99bd965dd"],

Cell[BoxData[
 StyleBox["\<\"ValidateSymbol[symbol] throws an error if symbol: 1) has a \
value or numeric character, or is not atomic, 2) its name is locked, \
protected or readprotected, or 3) it is already used by Mathematica or any of \
the xAct packages already loaded. Otherwise it gives Null. (Read)Protection \
is not checked for the capitals C, D, K, N, O, used by Mathematica. Symbols E \
and I have numeric value.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567974405-4493425",ExpressionUUID->"6b422901-35d4-4b11-86a4-\
5d34f5b4d427"]
}, Open  ]],

Cell["\<\
We have separated invalid from protected messages due to the following \
reason: we can have indices which are protected symbols but not invalid \
symbols. The \"locked\" error has been moved to the first group because a \
locked symbol can never be used, even if it is one-character long.\
\>", "Text",ExpressionUUID->"c5ca495d-0d4c-4873-a64d-d013f52e3298"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ValidateSymbol", "::", "invalid"}], "=", 
   "\"\<Symbol `1` is invalid because it `2`.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ValidateSymbol", "::", "protected"}], "=", 
   "\"\<Symbol `1` is `2`.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ValidateSymbol", "::", "used"}], "=", 
   "\"\<Symbol `1` is already used `2`.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"ce4744c2-af53-4f03-af9a-62552f02bf2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{"$SystemNames", ",", "\"\<C\>\""}], 
  "]"}]], "Input",ExpressionUUID->"15239697-9105-4d51-b458-d872e139ee63"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"dcfa8aa1-fe8e-4ea4-a0f2-9a4c4acc9034"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"SetAttributes", "[", 
  RowBox[{"ValidateSymbol", ",", "HoldFirst"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ValidateSymbol", "[", "symbol_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"name", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "symbol", "]"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Which", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Errors", ":", " ", 
        RowBox[{"generic", " ", "problems"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"NumericQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "invalid"}], ",", "name", ",", 
          "\"\<has numeric value\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"ValueQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "invalid"}], ",", "name", ",", 
          "\"\<has an ownvalue\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"!", 
        RowBox[{"AtomQ", "[", "symbol", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "invalid"}], ",", "name", ",", 
          "\"\<is not atomic\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LockedQ", "[", 
        RowBox[{"Symbol", "[", "name", "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "protected"}], ",", "name", ",", 
          "\"\<is Locked\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Errors", ":", " ", 
         RowBox[{"xAct", " ", "problems"}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$EMNames", ",", "name"}], "]"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by ExpressionManipulation\>\""}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$xCoreNames", ",", "name"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by xCore\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$xPermNames", ",", "name"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by xPerm\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$xTableauNames", ",", "name"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by xTableau\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$xTensorNames", ",", "name"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by xTensor\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$xCobaNames", ",", "name"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by xCoba\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$InvarNames", ",", "name"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by Invar\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$HarmonicsNames", ",", "name"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by Harmonics\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$xPertNames", ",", "name"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by xPert\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"MemberQ", "[", 
        RowBox[{"$SpinorsNames", ",", "name"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by Spinors\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"SystemCapitalQ", "[", "symbol", "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "]"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Errors", ":", " ", 
         RowBox[{"Mathematica", " ", "problems"}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"ProtectedQ", "[", 
        RowBox[{"Symbol", "[", "name", "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "protected"}], ",", "name", ",", 
          "\"\<Protected\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ReadProtectedQ", "[", 
        RowBox[{"Symbol", "[", "name", "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "protected"}], ",", "name", ",", 
          "\"\<ReadProtected\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{"$SystemNames", ",", "name"}], "]"}], "&&", 
        RowBox[{
         RowBox[{"Context", "[", "name", "]"}], "==", "\"\<System`\>\""}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", ",", 
          "\"\<by Mathematica\>\""}], "]"}]}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"ValidateSymbol", ",", "1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ValidateSymbol", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"6a30b7e8-79a7-4338-a11c-b8da7e35aef7"],

Cell["Examples:", \
"Text",ExpressionUUID->"aabb00aa-0c0b-405e-a0ab-6b08b43a9b92"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"cc5d3f0d-087e-4a24-9431-9810e8f6c103"],

Cell["Checks of the number of arguments:", \
"Text",ExpressionUUID->"fc45b233-85e7-447a-ba1e-eb931da5dc22"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", 
   "]"}]}]], "Input",ExpressionUUID->"bdf678a6-b91e-41e4-a5cd-bfc3a35179a4"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "argx"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(ValidateSymbol\\)\[NoBreak] called with \
\[NoBreak]\\!\\(0\\)\[NoBreak] arguments; 1 argument is expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argx\\\", \
ButtonNote -> \\\"xAct`xCore`ValidateSymbol::argx\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"4523d099-6b6c-40d9-847c-244a0bad1e9d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"ValidateSymbol", "[", 
   RowBox[{"A", ",", "E"}], 
   "]"}]}]], "Input",ExpressionUUID->"1b53f0c2-6573-4929-a993-560e6a5e940e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "argx"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(ValidateSymbol\\)\[NoBreak] called with \
\[NoBreak]\\!\\(2\\)\[NoBreak] arguments; 1 argument is expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argx\\\", \
ButtonNote -> \\\"xAct`xCore`ValidateSymbol::argx\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"8aad8a27-a264-496b-ac88-2182ac39d5aa"]
}, Open  ]],

Cell["Checks of first group of problems:", \
"Text",ExpressionUUID->"93e9f895-a6ab-4ece-af9e-6e98ea41e667"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "E", 
   "]"}]}]], "Input",ExpressionUUID->"3df92478-09e7-44a0-9d3f-9063dab1685f"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "invalid"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"E\\\"\\)\[NoBreak] is invalid because \
it \[NoBreak]\\!\\(\\\"has numeric value\\\"\\)\[NoBreak].\"\>"}]], \
"Message", "MSG",ExpressionUUID->"c5d46942-d7f8-4215-8378-1fdffc8d2e9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "I", 
   "]"}]}]], "Input",ExpressionUUID->"50433832-aa3e-4196-9784-9730f08f6ded"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "invalid"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"I\\\"\\)\[NoBreak] is invalid because \
it \[NoBreak]\\!\\(\\\"has numeric value\\\"\\)\[NoBreak].\"\>"}]], \
"Message", "MSG",ExpressionUUID->"76fce8ac-aff4-40ee-a96f-aa5d3b15dd3f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", "B"}], 
  ";"}]], "Input",ExpressionUUID->"6bbbc3b0-4721-423c-9eef-ea9aaf05b251"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "A", 
   "]"}]}]], "Input",ExpressionUUID->"7cb41dec-144f-4e0c-a6f0-eef86b3339c6"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "invalid"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"A\\\"\\)\[NoBreak] is invalid because \
it \[NoBreak]\\!\\(\\\"has an ownvalue\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"820d12da-e377-44a0-86b6-9ce343688b1b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"A", 
  "=."}]], "Input",ExpressionUUID->"2601862f-355e-476c-9934-989ee913fe3a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "Space", 
   "]"}]}]], "Input",ExpressionUUID->"69038033-5166-43d9-b0f3-67cb89e87a27"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "invalid"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"Space\\\"\\)\[NoBreak] is invalid \
because it \[NoBreak]\\!\\(\\\"has an ownvalue\\\"\\)\[NoBreak].\"\>"}]], \
"Message", "MSG",ExpressionUUID->"b63c1221-2afd-4f38-a84f-2cbd84a831dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"ValidateSymbol", "[", 
   RowBox[{"{", 
    RowBox[{"A", ",", "E"}], "}"}], 
   "]"}]}]], "Input",ExpressionUUID->"0799ef1c-7451-4122-9504-5c773c7b2f30"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "invalid"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"{A, E}\\\"\\)\[NoBreak] is invalid \
because it \[NoBreak]\\!\\(\\\"is not atomic\\\"\\)\[NoBreak].\"\>"}]], \
"Message", "MSG",ExpressionUUID->"fa281d63-c319-4c3f-92d9-70fd39994a1b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"ValidateSymbol", "[", 
   RowBox[{"A", "+", "B"}], 
   "]"}]}]], "Input",ExpressionUUID->"702831bd-9eaa-4bd4-8aeb-012f3a6bf10b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "invalid"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"A + B\\\"\\)\[NoBreak] is invalid \
because it \[NoBreak]\\!\\(\\\"is not atomic\\\"\\)\[NoBreak].\"\>"}]], \
"Message", "MSG",ExpressionUUID->"9c4f2dd9-86de-4dc7-96c9-13f383c101eb"]
}, Open  ]],

Cell["Checks of second group of problems:", \
"Text",ExpressionUUID->"42f825f4-7cb9-4fcc-b3a6-d02d2503ceeb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "True", 
   "]"}]}]], "Input",ExpressionUUID->"2cbe87f7-4d86-4873-aec5-7570b8c92afa"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "protected"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"True\\\"\\)\[NoBreak] is \[NoBreak]\\!\
\\(\\\"is Locked\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"cfcd8d5d-b542-489e-8f0c-6e8bc410fbe1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "Hold", 
   "]"}]}]], "Input",ExpressionUUID->"678f88e3-4587-4c58-b559-f18e395b7b35"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "protected"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"Hold\\\"\\)\[NoBreak] is \[NoBreak]\\!\
\\(\\\"Protected\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"8ef408c7-c5cf-4332-8a7d-3667ddcf9fa4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "Install", 
   "]"}]}]], "Input",ExpressionUUID->"e68bbcf7-f548-42e8-b092-1eeaee08a6b6"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "protected"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"Install\\\"\\)\[NoBreak] is \[NoBreak]\
\\!\\(\\\"ReadProtected\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"7eb502bd-a561-4a72-bba4-fc4a9922c5cf"]
}, Open  ]],

Cell["Checks of third group of problems:", \
"Text",ExpressionUUID->"c47efccd-3120-40ca-a65b-7d3857c50985"],

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "eP", 
   "]"}]}]], "Input",ExpressionUUID->"19c10f23-b509-4b1e-8895-1b7b0db1c131"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "xUpSet", 
   "]"}]}]], "Input",ExpressionUUID->"47312f15-6178-42ca-af6c-6f6ad5520e21"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "used"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"xUpSet\\\"\\)\[NoBreak] is already \
used \[NoBreak]\\!\\(\\\"by xCore\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"0ec2d3ee-a8e3-49f0-8282-9430e55570e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "ValidateSymbol", "[", "Box", 
   "]"}]}]], "Input",ExpressionUUID->"0429491c-2b48-4613-a900-9fcadcffbd80"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "protected"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"Box\\\"\\)\[NoBreak] is \
\[NoBreak]\\!\\(\\\"Protected\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"27a4bbd3-8236-4b0a-bcaf-d27139ce2f01"]
}, Open  ]],

Cell[TextData[{
 "Capitals C,D,K,N,O are used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " but do not throw an error:"
}], "Text",ExpressionUUID->"d2a4568f-1811-4e70-ac63-7e0aaf87bb32"],

Cell[BoxData[
 RowBox[{"ValidateSymbol", "[", "C", 
  "]"}]], "Input",ExpressionUUID->"eff658d2-c648-49bb-b3c6-36892f704841"],

Cell["Other symbols are valid:", \
"Text",ExpressionUUID->"13ca1b82-2f6d-47a2-894a-9b9029c6edd5"],

Cell[BoxData[
 RowBox[{"ValidateSymbol", "[", "hello", 
  "]"}]], "Input",ExpressionUUID->"8034a2c6-499e-4987-b5ce-077ff4ea2366"],

Cell["\<\
Again, don't follow the Trace of ValidateSymbol because it works with huge \
lists of names...\
\>", "Text",ExpressionUUID->"7fd0651b-e2ae-4254-bab0-0467290186a3"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"A", ",", "B", ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"2ea81ee8-c649-44ed-b3f9-8e56a0f74049"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"796223ab-9d0c-476f-912e-6af928a5aa2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are new symbols in Global`:\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"eP\"\>", "}"}]}],
  SequenceForm["There are new symbols in Global`:", {"eP"}],
  Editable->
   False]], "Print",ExpressionUUID->"bdc20167-beba-4ebc-9c40-cf0b0cd57e02"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. Precedence of symbols", \
"Subsection",ExpressionUUID->"e77cea99-c37e-4bf2-b518-bd8901109e01"],

Cell["Nothing here goes into the package.", \
"Text",ExpressionUUID->"5c0a6eb2-4ac2-4d74-8b70-a09e780ea163"],

Cell["We can compute the precedence of all SystemNames:", \
"Text",ExpressionUUID->"526f4eea-8e35-42bb-b5a0-570543836af6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "$SystemNames", 
  "]"}]], "Input",ExpressionUUID->"32702f56-48c3-486d-8742-e4346d7b2d1b"],

Cell[BoxData["4562"], \
"Output",ExpressionUUID->"abcf929c-0848-4d64-bfc8-f0f12f4c142f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"precs", "=", 
   RowBox[{"Precedence", "/@", 
    RowBox[{"Symbol", "/@", "$SystemNames"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"e623f901-caa5-4875-8318-f6e0982b08ba"],

Cell[TextData[{
 "Most of them have precedence 680 in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4 or 670 in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5:"
}], "Text",ExpressionUUID->"25d860e7-6ef7-4899-9d56-a7595957fd10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"precMost", "=", 
  RowBox[{"Switch", "[", 
   RowBox[{
   "System`$VersionNumber", ",", "\[IndentingNewLine]", "4.", ",", "680.", 
    ",", "\[IndentingNewLine]", "5.", ",", "670.", ",", "\[IndentingNewLine]",
     "5.1", ",", "670.", ",", "\[IndentingNewLine]", "5.2", ",", "670."}], 
   "\[IndentingNewLine]", 
   "]"}]}]], "Input",ExpressionUUID->"ff9a0576-7745-410f-bb5f-b6fb3bdb0ad8"],

Cell[BoxData[
 RowBox[{"Switch", "[", 
  RowBox[{
  "9.`", ",", "\[IndentingNewLine]", "4.`", ",", "680.`", ",", 
   "\[IndentingNewLine]", "5.`", ",", "670.`", ",", "\[IndentingNewLine]", 
   "5.1`", ",", "670.`", ",", "\[IndentingNewLine]", "5.2`", ",", "670.`"}], 
  "]"}]], "Output",ExpressionUUID->"32476293-acd1-4790-a0f0-47f05f073b15"]
}, Open  ]],

Cell["Actually only these do not have it:", \
"Text",ExpressionUUID->"af9dc451-426f-4d06-b7f1-8679c2ae6854"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nonMostprecs", "=", 
   RowBox[{"Sort", "[", 
    RowBox[{"DeleteCases", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"precs", ",", "$SystemNames"}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"precMost", ",", "_"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"1b5a0eaf-d5f6-462b-b118-7e2998efec47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Range", "@", 
       RowBox[{"Length", "@", "nonMostprecs"}]}], "}"}], ",", 
     RowBox[{"Transpose", "[", "nonMostprecs", "]"}]}], "]"}], "]"}], "//", 
  "TableForm"}]], \
"Input",ExpressionUUID->"89ad4c05-3205-4875-84d8-7b19b7809a6b"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "0.`", "\<\"OverBar\"\>"},
    {"2", "0.`", "\<\"OverDot\"\>"},
    {"3", "0.`", "\<\"OverHat\"\>"},
    {"4", "0.`", "\<\"OverTilde\"\>"},
    {"5", "0.`", "\<\"OverVector\"\>"},
    {"6", "0.`", "\<\"SubMinus\"\>"},
    {"7", "0.`", "\<\"SubPlus\"\>"},
    {"8", "0.`", "\<\"SubStar\"\>"},
    {"9", "0.`", "\<\"SuperDagger\"\>"},
    {"10", "0.`", "\<\"SuperMinus\"\>"},
    {"11", "0.`", "\<\"SuperPlus\"\>"},
    {"12", "0.`", "\<\"SuperStar\"\>"},
    {"13", "0.`", "\<\"UnderBar\"\>"},
    {"14", "10.`", "\<\"CompoundExpression\"\>"},
    {"15", "20.`", "\<\"ColonForm\"\>"},
    {"16", "30.`", "\<\"Put\"\>"},
    {"17", "30.`", "\<\"PutAppend\"\>"},
    {"18", "40.`", "\<\"Set\"\>"},
    {"19", "40.`", "\<\"SetDelayed\"\>"},
    {"20", "40.`", "\<\"UpSet\"\>"},
    {"21", "40.`", "\<\"UpSetDelayed\"\>"},
    {"22", "50.`", "\<\"Because\"\>"},
    {"23", "50.`", "\<\"Therefore\"\>"},
    {"24", "60.`", "\<\"VerticalSeparator\"\>"},
    {"25", "70.`", "\<\"Postfix\"\>"},
    {"26", "80.`", "\<\"Colon\"\>"},
    {"27", "90.`", "\<\"Function\"\>"},
    {"28", "100.`", "\<\"AddTo\"\>"},
    {"29", "100.`", "\<\"DivideBy\"\>"},
    {"30", "100.`", "\<\"SubtractFrom\"\>"},
    {"31", "100.`", "\<\"TimesBy\"\>"},
    {"32", "110.`", "\<\"ReplaceAll\"\>"},
    {"33", "110.`", "\<\"ReplaceRepeated\"\>"},
    {"34", "120.`", "\<\"Rule\"\>"},
    {"35", "120.`", "\<\"RuleDelayed\"\>"},
    {"36", "130.`", "\<\"Condition\"\>"},
    {"37", "135.`", "\<\"StringExpression\"\>"},
    {"38", "140.`", "\<\"Optional\"\>"},
    {"39", "150.`", "\<\"Pattern\"\>"},
    {"40", "160.`", "\<\"Alternatives\"\>"},
    {"41", "170.`", "\<\"Repeated\"\>"},
    {"42", "170.`", "\<\"RepeatedNull\"\>"},
    {"43", "180.`", "\<\"SuchThat\"\>"},
    {"44", "190.`", "\<\"DoubleLeftTee\"\>"},
    {"45", "190.`", "\<\"DoubleRightTee\"\>"},
    {"46", "190.`", "\<\"DownTee\"\>"},
    {"47", "190.`", "\<\"LeftTee\"\>"},
    {"48", "190.`", "\<\"Perpendicular\"\>"},
    {"49", "190.`", "\<\"RightTee\"\>"},
    {"50", "190.`", "\<\"UpTee\"\>"},
    {"51", "195.`", "\<\"Conditioned\"\>"},
    {"52", "200.`", "\<\"Implies\"\>"},
    {"53", "205.`", "\<\"Equivalent\"\>"},
    {"54", "215.`", "\<\"And\"\>"},
    {"55", "215.`", "\<\"Nand\"\>"},
    {"56", "215.`", "\<\"Nor\"\>"},
    {"57", "215.`", "\<\"Or\"\>"},
    {"58", "215.`", "\<\"Xnor\"\>"},
    {"59", "215.`", "\<\"Xor\"\>"},
    {"60", "230.`", "\<\"Not\"\>"},
    {"61", "240.`", "\<\"Exists\"\>"},
    {"62", "240.`", "\<\"ForAll\"\>"},
    {"63", "240.`", "\<\"NotExists\"\>"},
    {"64", "240.`", "\<\"RoundImplies\"\>"},
    {"65", "250.`", "\<\"Distributed\"\>"},
    {"66", "250.`", "\<\"Element\"\>"},
    {"67", "250.`", "\<\"NotElement\"\>"},
    {"68", "250.`", "\<\"NotReverseElement\"\>"},
    {"69", "250.`", "\<\"NotSquareSubset\"\>"},
    {"70", "250.`", "\<\"NotSquareSubsetEqual\"\>"},
    {"71", "250.`", "\<\"NotSquareSuperset\"\>"},
    {"72", "250.`", "\<\"NotSquareSupersetEqual\"\>"},
    {"73", "250.`", "\<\"NotSubset\"\>"},
    {"74", "250.`", "\<\"NotSubsetEqual\"\>"},
    {"75", "250.`", "\<\"NotSuperset\"\>"},
    {"76", "250.`", "\<\"NotSupersetEqual\"\>"},
    {"77", "250.`", "\<\"ReverseElement\"\>"},
    {"78", "250.`", "\<\"SquareSubset\"\>"},
    {"79", "250.`", "\<\"SquareSubsetEqual\"\>"},
    {"80", "250.`", "\<\"SquareSuperset\"\>"},
    {"81", "250.`", "\<\"SquareSupersetEqual\"\>"},
    {"82", "250.`", "\<\"Subset\"\>"},
    {"83", "250.`", "\<\"SubsetEqual\"\>"},
    {"84", "250.`", "\<\"Superset\"\>"},
    {"85", "250.`", "\<\"SupersetEqual\"\>"},
    {"86", "270.`", "\<\"DoubleLeftArrow\"\>"},
    {"87", "270.`", "\<\"DoubleLeftRightArrow\"\>"},
    {"88", "270.`", "\<\"DoubleRightArrow\"\>"},
    {"89", "270.`", "\<\"DownLeftRightVector\"\>"},
    {"90", "270.`", "\<\"DownLeftTeeVector\"\>"},
    {"91", "270.`", "\<\"DownLeftVector\"\>"},
    {"92", "270.`", "\<\"DownLeftVectorBar\"\>"},
    {"93", "270.`", "\<\"DownRightTeeVector\"\>"},
    {"94", "270.`", "\<\"DownRightVector\"\>"},
    {"95", "270.`", "\<\"DownRightVectorBar\"\>"},
    {"96", "270.`", "\<\"LeftArrow\"\>"},
    {"97", "270.`", "\<\"LeftArrowBar\"\>"},
    {"98", "270.`", "\<\"LeftArrowRightArrow\"\>"},
    {"99", "270.`", "\<\"LeftRightArrow\"\>"},
    {"100", "270.`", "\<\"LeftRightVector\"\>"},
    {"101", "270.`", "\<\"LeftTeeArrow\"\>"},
    {"102", "270.`", "\<\"LeftTeeVector\"\>"},
    {"103", "270.`", "\<\"LeftVector\"\>"},
    {"104", "270.`", "\<\"LeftVectorBar\"\>"},
    {"105", "270.`", "\<\"LowerLeftArrow\"\>"},
    {"106", "270.`", "\<\"LowerRightArrow\"\>"},
    {"107", "270.`", "\<\"RightArrow\"\>"},
    {"108", "270.`", "\<\"RightArrowBar\"\>"},
    {"109", "270.`", "\<\"RightArrowLeftArrow\"\>"},
    {"110", "270.`", "\<\"RightTeeArrow\"\>"},
    {"111", "270.`", "\<\"RightTeeVector\"\>"},
    {"112", "270.`", "\<\"RightVector\"\>"},
    {"113", "270.`", "\<\"RightVectorBar\"\>"},
    {"114", "270.`", "\<\"ShortLeftArrow\"\>"},
    {"115", "270.`", "\<\"ShortRightArrow\"\>"},
    {"116", "270.`", "\<\"UpperLeftArrow\"\>"},
    {"117", "270.`", "\<\"UpperRightArrow\"\>"},
    {"118", "280.`", "\<\"DoubleVerticalBar\"\>"},
    {"119", "280.`", "\<\"NotDoubleVerticalBar\"\>"},
    {"120", "280.`", "\<\"NotVerticalBar\"\>"},
    {"121", "280.`", "\<\"VerticalBar\"\>"},
    {"122", "290.`", "\<\"Congruent\"\>"},
    {"123", "290.`", "\<\"CupCap\"\>"},
    {"124", "290.`", "\<\"DotEqual\"\>"},
    {"125", "290.`", "\<\"Equal\"\>"},
    {"126", "290.`", "\<\"EqualTilde\"\>"},
    {"127", "290.`", "\<\"Equilibrium\"\>"},
    {"128", "290.`", "\<\"Greater\"\>"},
    {"129", "290.`", "\<\"GreaterEqual\"\>"},
    {"130", "290.`", "\<\"GreaterEqualLess\"\>"},
    {"131", "290.`", "\<\"GreaterFullEqual\"\>"},
    {"132", "290.`", "\<\"GreaterGreater\"\>"},
    {"133", "290.`", "\<\"GreaterLess\"\>"},
    {"134", "290.`", "\<\"GreaterTilde\"\>"},
    {"135", "290.`", "\<\"HumpDownHump\"\>"},
    {"136", "290.`", "\<\"HumpEqual\"\>"},
    {"137", "290.`", "\<\"LeftTriangle\"\>"},
    {"138", "290.`", "\<\"LeftTriangleBar\"\>"},
    {"139", "290.`", "\<\"LeftTriangleEqual\"\>"},
    {"140", "290.`", "\<\"Less\"\>"},
    {"141", "290.`", "\<\"LessEqual\"\>"},
    {"142", "290.`", "\<\"LessEqualGreater\"\>"},
    {"143", "290.`", "\<\"LessFullEqual\"\>"},
    {"144", "290.`", "\<\"LessGreater\"\>"},
    {"145", "290.`", "\<\"LessLess\"\>"},
    {"146", "290.`", "\<\"LessTilde\"\>"},
    {"147", "290.`", "\<\"NestedGreaterGreater\"\>"},
    {"148", "290.`", "\<\"NestedLessLess\"\>"},
    {"149", "290.`", "\<\"NotCongruent\"\>"},
    {"150", "290.`", "\<\"NotCupCap\"\>"},
    {"151", "290.`", "\<\"NotEqualTilde\"\>"},
    {"152", "290.`", "\<\"NotGreater\"\>"},
    {"153", "290.`", "\<\"NotGreaterEqual\"\>"},
    {"154", "290.`", "\<\"NotGreaterFullEqual\"\>"},
    {"155", "290.`", "\<\"NotGreaterGreater\"\>"},
    {"156", "290.`", "\<\"NotGreaterLess\"\>"},
    {"157", "290.`", "\<\"NotGreaterSlantEqual\"\>"},
    {"158", "290.`", "\<\"NotGreaterTilde\"\>"},
    {"159", "290.`", "\<\"NotHumpDownHump\"\>"},
    {"160", "290.`", "\<\"NotHumpEqual\"\>"},
    {"161", "290.`", "\<\"NotLeftTriangle\"\>"},
    {"162", "290.`", "\<\"NotLeftTriangleBar\"\>"},
    {"163", "290.`", "\<\"NotLeftTriangleEqual\"\>"},
    {"164", "290.`", "\<\"NotLess\"\>"},
    {"165", "290.`", "\<\"NotLessEqual\"\>"},
    {"166", "290.`", "\<\"NotLessFullEqual\"\>"},
    {"167", "290.`", "\<\"NotLessGreater\"\>"},
    {"168", "290.`", "\<\"NotLessLess\"\>"},
    {"169", "290.`", "\<\"NotLessSlantEqual\"\>"},
    {"170", "290.`", "\<\"NotLessTilde\"\>"},
    {"171", "290.`", "\<\"NotNestedGreaterGreater\"\>"},
    {"172", "290.`", "\<\"NotNestedLessLess\"\>"},
    {"173", "290.`", "\<\"NotPrecedes\"\>"},
    {"174", "290.`", "\<\"NotPrecedesEqual\"\>"},
    {"175", "290.`", "\<\"NotPrecedesSlantEqual\"\>"},
    {"176", "290.`", "\<\"NotPrecedesTilde\"\>"},
    {"177", "290.`", "\<\"NotRightTriangle\"\>"},
    {"178", "290.`", "\<\"NotRightTriangleBar\"\>"},
    {"179", "290.`", "\<\"NotRightTriangleEqual\"\>"},
    {"180", "290.`", "\<\"NotSucceeds\"\>"},
    {"181", "290.`", "\<\"NotSucceedsEqual\"\>"},
    {"182", "290.`", "\<\"NotSucceedsSlantEqual\"\>"},
    {"183", "290.`", "\<\"NotSucceedsTilde\"\>"},
    {"184", "290.`", "\<\"NotTilde\"\>"},
    {"185", "290.`", "\<\"NotTildeEqual\"\>"},
    {"186", "290.`", "\<\"NotTildeFullEqual\"\>"},
    {"187", "290.`", "\<\"NotTildeTilde\"\>"},
    {"188", "290.`", "\<\"Precedes\"\>"},
    {"189", "290.`", "\<\"PrecedesEqual\"\>"},
    {"190", "290.`", "\<\"PrecedesSlantEqual\"\>"},
    {"191", "290.`", "\<\"PrecedesTilde\"\>"},
    {"192", "290.`", "\<\"Proportion\"\>"},
    {"193", "290.`", "\<\"Proportional\"\>"},
    {"194", "290.`", "\<\"ReverseEquilibrium\"\>"},
    {"195", "290.`", "\<\"RightTriangle\"\>"},
    {"196", "290.`", "\<\"RightTriangleBar\"\>"},
    {"197", "290.`", "\<\"RightTriangleEqual\"\>"},
    {"198", "290.`", "\<\"SameQ\"\>"},
    {"199", "290.`", "\<\"Succeeds\"\>"},
    {"200", "290.`", "\<\"SucceedsEqual\"\>"},
    {"201", "290.`", "\<\"SucceedsSlantEqual\"\>"},
    {"202", "290.`", "\<\"SucceedsTilde\"\>"},
    {"203", "290.`", "\<\"Tilde\"\>"},
    {"204", "290.`", "\<\"TildeEqual\"\>"},
    {"205", "290.`", "\<\"TildeFullEqual\"\>"},
    {"206", "290.`", "\<\"TildeTilde\"\>"},
    {"207", "290.`", "\<\"Unequal\"\>"},
    {"208", "290.`", "\<\"UnsameQ\"\>"},
    {"209", "295.`", "\<\"DirectedEdge\"\>"},
    {"210", "295.`", "\<\"UndirectedEdge\"\>"},
    {"211", "300.`", "\<\"IntervalIntersection\"\>"},
    {"212", "300.`", "\<\"IntervalUnion\"\>"},
    {"213", "300.`", "\<\"SquareUnion\"\>"},
    {"214", "300.`", "\<\"Union\"\>"},
    {"215", "300.`", "\<\"UnionPlus\"\>"},
    {"216", "305.`", "\<\"Intersection\"\>"},
    {"217", "305.`", "\<\"Span\"\>"},
    {"218", "305.`", "\<\"SquareIntersection\"\>"},
    {"219", "310.`", "\<\"Complex\"\>"},
    {"220", "310.`", "\<\"MinusPlus\"\>"},
    {"221", "310.`", "\<\"Plus\"\>"},
    {"222", "310.`", "\<\"PlusMinus\"\>"},
    {"223", "310.`", "\<\"Subtract\"\>"},
    {"224", "320.`", "\<\"Sum\"\>"},
    {"225", "325.`", "\<\"ExpectationE\"\>"},
    {"226", "325.`", "\<\"Integrate\"\>"},
    {"227", "325.`", "\<\"ProbabilityPr\"\>"},
    {"228", "330.`", "\<\"CircleMinus\"\>"},
    {"229", "330.`", "\<\"CirclePlus\"\>"},
    {"230", "340.`", "\<\"Cup\"\>"},
    {"231", "350.`", "\<\"Cap\"\>"},
    {"232", "360.`", "\<\"Coproduct\"\>"},
    {"233", "370.`", "\<\"VerticalTilde\"\>"},
    {"234", "380.`", "\<\"ContinuedFractionK\"\>"},
    {"235", "380.`", "\<\"Product\"\>"},
    {"236", "390.`", "\<\"Star\"\>"},
    {"237", "395.`", "\<\"Mod\"\>"},
    {"238", "400.`", "\<\"Times\"\>"},
    {"239", "410.`", "\<\"CenterDot\"\>"},
    {"240", "420.`", "\<\"CircleTimes\"\>"},
    {"241", "430.`", "\<\"Vee\"\>"},
    {"242", "440.`", "\<\"Wedge\"\>"},
    {"243", "450.`", "\<\"Diamond\"\>"},
    {"244", "460.`", "\<\"Backslash\"\>"},
    {"245", "470.`", "\<\"Divide\"\>"},
    {"246", "480.`", "\<\"Minus\"\>"},
    {"247", "480.`", "\<\"Piecewise\"\>"},
    {"248", "490.`", "\<\"Dot\"\>"},
    {"249", "495.`", "\<\"TensorProduct\"\>"},
    {"250", "500.`", "\<\"Cross\"\>"},
    {"251", "500.`", "\<\"TensorWedge\"\>"},
    {"252", "510.`", "\<\"NonCommutativeMultiply\"\>"},
    {"253", "520.`", "\<\"CircleDot\"\>"},
    {"254", "520.`", "\<\"PermutationProduct\"\>"},
    {"255", "530.`", "\<\"SmallCircle\"\>"},
    {"256", "540.`", "\<\"Square\"\>"},
    {"257", "550.`", "\<\"CapitalDifferentialD\"\>"},
    {"258", "550.`", "\<\"Curl\"\>"},
    {"259", "550.`", "\<\"D\"\>"},
    {"260", "550.`", "\<\"Del\"\>"},
    {"261", "550.`", "\<\"DifferenceDelta\"\>"},
    {"262", "550.`", "\<\"DifferentialD\"\>"},
    {"263", "550.`", "\<\"DiscreteRatio\"\>"},
    {"264", "550.`", "\<\"DiscreteShift\"\>"},
    {"265", "550.`", "\<\"Divergence\"\>"},
    {"266", "550.`", "\<\"Dt\"\>"},
    {"267", "550.`", "\<\"Gradient\"\>"},
    {"268", "550.`", "\<\"Laplacian\"\>"},
    {"269", "580.`", "\<\"DoubleDownArrow\"\>"},
    {"270", "580.`", "\<\"DoubleLongLeftArrow\"\>"},
    {"271", "580.`", "\<\"DoubleLongLeftRightArrow\"\>"},
    {"272", "580.`", "\<\"DoubleLongRightArrow\"\>"},
    {"273", "580.`", "\<\"DoubleUpArrow\"\>"},
    {"274", "580.`", "\<\"DoubleUpDownArrow\"\>"},
    {"275", "580.`", "\<\"DownArrow\"\>"},
    {"276", "580.`", "\<\"DownArrowBar\"\>"},
    {"277", "580.`", "\<\"DownArrowUpArrow\"\>"},
    {"278", "580.`", "\<\"DownTeeArrow\"\>"},
    {"279", "580.`", "\<\"LeftDownTeeVector\"\>"},
    {"280", "580.`", "\<\"LeftDownVector\"\>"},
    {"281", "580.`", "\<\"LeftDownVectorBar\"\>"},
    {"282", "580.`", "\<\"LeftUpDownVector\"\>"},
    {"283", "580.`", "\<\"LeftUpTeeVector\"\>"},
    {"284", "580.`", "\<\"LeftUpVector\"\>"},
    {"285", "580.`", "\<\"LeftUpVectorBar\"\>"},
    {"286", "580.`", "\<\"LongLeftArrow\"\>"},
    {"287", "580.`", "\<\"LongLeftRightArrow\"\>"},
    {"288", "580.`", "\<\"LongRightArrow\"\>"},
    {"289", "580.`", "\<\"ReverseUpEquilibrium\"\>"},
    {"290", "580.`", "\<\"RightDownTeeVector\"\>"},
    {"291", "580.`", "\<\"RightDownVector\"\>"},
    {"292", "580.`", "\<\"RightDownVectorBar\"\>"},
    {"293", "580.`", "\<\"RightUpDownVector\"\>"},
    {"294", "580.`", "\<\"RightUpTeeVector\"\>"},
    {"295", "580.`", "\<\"RightUpVector\"\>"},
    {"296", "580.`", "\<\"RightUpVectorBar\"\>"},
    {"297", "580.`", "\<\"ShortDownArrow\"\>"},
    {"298", "580.`", "\<\"ShortUpArrow\"\>"},
    {"299", "580.`", "\<\"UpArrow\"\>"},
    {"300", "580.`", "\<\"UpArrowBar\"\>"},
    {"301", "580.`", "\<\"UpArrowDownArrow\"\>"},
    {"302", "580.`", "\<\"UpDownArrow\"\>"},
    {"303", "580.`", "\<\"UpEquilibrium\"\>"},
    {"304", "580.`", "\<\"UpTeeArrow\"\>"},
    {"305", "590.`", "\<\"Power\"\>"},
    {"306", "590.`", "\<\"SuperscriptBox\"\>"},
    {"307", "600.`", "\<\"StringJoin\"\>"},
    {"308", "610.`", "\<\"Factorial\"\>"},
    {"309", "610.`", "\<\"Factorial2\"\>"},
    {"310", "620.`", "\<\"Apply\"\>"},
    {"311", "620.`", "\<\"Map\"\>"},
    {"312", "620.`", "\<\"MapAll\"\>"},
    {"313", "630.`", "\<\"Infix\"\>"},
    {"314", "640.`", "\<\"InvisibleApplication\"\>"},
    {"315", "640.`", "\<\"Prefix\"\>"},
    {"316", "660.`", "\<\"Decrement\"\>"},
    {"317", "660.`", "\<\"Increment\"\>"},
    {"318", "660.`", "\<\"PreDecrement\"\>"},
    {"319", "660.`", "\<\"PreIncrement\"\>"},
    {"320", "670.`", "\<\"\[FormalA]\"\>"},
    {"321", "670.`", "\<\"\[FormalB]\"\>"},
    {"322", "670.`", "\<\"\[FormalC]\"\>"},
    {"323", "670.`", "\<\"\[FormalD]\"\>"},
    {"324", "670.`", "\<\"\[FormalE]\"\>"},
    {"325", "670.`", "\<\"\[FormalF]\"\>"},
    {"326", "670.`", "\<\"\[FormalG]\"\>"},
    {"327", "670.`", "\<\"\[FormalH]\"\>"},
    {"328", "670.`", "\<\"\[FormalI]\"\>"},
    {"329", "670.`", "\<\"\[FormalJ]\"\>"},
    {"330", "670.`", "\<\"\[FormalK]\"\>"},
    {"331", "670.`", "\<\"\[FormalL]\"\>"},
    {"332", "670.`", "\<\"\[FormalM]\"\>"},
    {"333", "670.`", "\<\"\[FormalN]\"\>"},
    {"334", "670.`", "\<\"\[FormalO]\"\>"},
    {"335", "670.`", "\<\"\[FormalP]\"\>"},
    {"336", "670.`", "\<\"\[FormalQ]\"\>"},
    {"337", "670.`", "\<\"\[FormalR]\"\>"},
    {"338", "670.`", "\<\"\[FormalS]\"\>"},
    {"339", "670.`", "\<\"\[FormalT]\"\>"},
    {"340", "670.`", "\<\"\[FormalU]\"\>"},
    {"341", "670.`", "\<\"\[FormalV]\"\>"},
    {"342", "670.`", "\<\"\[FormalW]\"\>"},
    {"343", "670.`", "\<\"\[FormalX]\"\>"},
    {"344", "670.`", "\<\"\[FormalY]\"\>"},
    {"345", "670.`", "\<\"\[FormalZ]\"\>"},
    {"346", "670.`", "\<\"\[FormalCapitalA]\"\>"},
    {"347", "670.`", "\<\"\[FormalCapitalB]\"\>"},
    {"348", "670.`", "\<\"\[FormalCapitalC]\"\>"},
    {"349", "670.`", "\<\"\[FormalCapitalD]\"\>"},
    {"350", "670.`", "\<\"\[FormalCapitalE]\"\>"},
    {"351", "670.`", "\<\"\[FormalCapitalF]\"\>"},
    {"352", "670.`", "\<\"\[FormalCapitalG]\"\>"},
    {"353", "670.`", "\<\"\[FormalCapitalH]\"\>"},
    {"354", "670.`", "\<\"\[FormalCapitalI]\"\>"},
    {"355", "670.`", "\<\"\[FormalCapitalJ]\"\>"},
    {"356", "670.`", "\<\"\[FormalCapitalK]\"\>"},
    {"357", "670.`", "\<\"\[FormalCapitalL]\"\>"},
    {"358", "670.`", "\<\"\[FormalCapitalM]\"\>"},
    {"359", "670.`", "\<\"\[FormalCapitalN]\"\>"},
    {"360", "670.`", "\<\"\[FormalCapitalO]\"\>"},
    {"361", "670.`", "\<\"\[FormalCapitalP]\"\>"},
    {"362", "670.`", "\<\"\[FormalCapitalQ]\"\>"},
    {"363", "670.`", "\<\"\[FormalCapitalR]\"\>"},
    {"364", "670.`", "\<\"\[FormalCapitalS]\"\>"},
    {"365", "670.`", "\<\"\[FormalCapitalT]\"\>"},
    {"366", "670.`", "\<\"\[FormalCapitalU]\"\>"},
    {"367", "670.`", "\<\"\[FormalCapitalV]\"\>"},
    {"368", "670.`", "\<\"\[FormalCapitalW]\"\>"},
    {"369", "670.`", "\<\"\[FormalCapitalX]\"\>"},
    {"370", "670.`", "\<\"\[FormalCapitalY]\"\>"},
    {"371", "670.`", "\<\"\[FormalCapitalZ]\"\>"},
    {"372", "670.`", "\<\"AbelianGroup\"\>"},
    {"373", "670.`", "\<\"Abort\"\>"},
    {"374", "670.`", "\<\"AbortKernels\"\>"},
    {"375", "670.`", "\<\"AbortProtect\"\>"},
    {"376", "670.`", "\<\"Above\"\>"},
    {"377", "670.`", "\<\"Abs\"\>"},
    {"378", "670.`", "\<\"Absolute\"\>"},
    {"379", "670.`", "\<\"AbsoluteCorrelation\"\>"},
    {"380", "670.`", "\<\"AbsoluteCorrelationFunction\"\>"},
    {"381", "670.`", "\<\"AbsoluteCurrentValue\"\>"},
    {"382", "670.`", "\<\"AbsoluteDashing\"\>"},
    {"383", "670.`", "\<\"AbsoluteFileName\"\>"},
    {"384", "670.`", "\<\"AbsoluteOptions\"\>"},
    {"385", "670.`", "\<\"AbsolutePointSize\"\>"},
    {"386", "670.`", "\<\"AbsoluteThickness\"\>"},
    {"387", "670.`", "\<\"AbsoluteTime\"\>"},
    {"388", "670.`", "\<\"AbsoluteTiming\"\>"},
    {"389", "670.`", "\<\"AccountingForm\"\>"},
    {"390", "670.`", "\<\"Accumulate\"\>"},
    {"391", "670.`", "\<\"Accuracy\"\>"},
    {"392", "670.`", "\<\"AccuracyGoal\"\>"},
    {"393", "670.`", "\<\"ActionDelay\"\>"},
    {"394", "670.`", "\<\"ActionMenu\"\>"},
    {"395", "670.`", "\<\"ActionMenuBox\"\>"},
    {"396", "670.`", "\<\"ActionMenuBoxOptions\"\>"},
    {"397", "670.`", "\<\"Active\"\>"},
    {"398", "670.`", "\<\"ActiveItem\"\>"},
    {"399", "670.`", "\<\"ActiveStyle\"\>"},
    {"400", "670.`", "\<\"AcyclicGraphQ\"\>"},
    {"401", "670.`", "\<\"AddOnHelpPath\"\>"},
    {"402", "670.`", "\<\"AdjacencyGraph\"\>"},
    {"403", "670.`", "\<\"AdjacencyList\"\>"},
    {"404", "670.`", "\<\"AdjacencyMatrix\"\>"},
    {"405", "670.`", "\<\"AdjustmentBox\"\>"},
    {"406", "670.`", "\<\"AdjustmentBoxOptions\"\>"},
    {"407", "670.`", "\<\"AdjustTimeSeriesForecast\"\>"},
    {"408", "670.`", "\<\"AffineTransform\"\>"},
    {"409", "670.`", "\<\"After\"\>"},
    {"410", "670.`", "\<\"AiryAi\"\>"},
    {"411", "670.`", "\<\"AiryAiPrime\"\>"},
    {"412", "670.`", "\<\"AiryAiZero\"\>"},
    {"413", "670.`", "\<\"AiryBi\"\>"},
    {"414", "670.`", "\<\"AiryBiPrime\"\>"},
    {"415", "670.`", "\<\"AiryBiZero\"\>"},
    {"416", "670.`", "\<\"AlgebraicIntegerQ\"\>"},
    {"417", "670.`", "\<\"AlgebraicNumber\"\>"},
    {"418", "670.`", "\<\"AlgebraicNumberDenominator\"\>"},
    {"419", "670.`", "\<\"AlgebraicNumberNorm\"\>"},
    {"420", "670.`", "\<\"AlgebraicNumberPolynomial\"\>"},
    {"421", "670.`", "\<\"AlgebraicNumberTrace\"\>"},
    {"422", "670.`", "\<\"AlgebraicRules\"\>"},
    {"423", "670.`", "\<\"AlgebraicRulesData\"\>"},
    {"424", "670.`", "\<\"Algebraics\"\>"},
    {"425", "670.`", "\<\"AlgebraicUnitQ\"\>"},
    {"426", "670.`", "\<\"Alignment\"\>"},
    {"427", "670.`", "\<\"AlignmentMarker\"\>"},
    {"428", "670.`", "\<\"AlignmentPoint\"\>"},
    {"429", "670.`", "\<\"All\"\>"},
    {"430", "670.`", "\<\"AllowedDimensions\"\>"},
    {"431", "670.`", "\<\"AllowGroupClose\"\>"},
    {"432", "670.`", "\<\"AllowInlineCells\"\>"},
    {"433", "670.`", "\<\"AllowKernelInitialization\"\>"},
    {"434", "670.`", "\<\"AllowReverseGroupClose\"\>"},
    {"435", "670.`", "\<\"AllowScriptLevelChange\"\>"},
    {"436", "670.`", "\<\"AlphaChannel\"\>"},
    {"437", "670.`", "\<\"AlternatingGroup\"\>"},
    {"438", "670.`", "\<\"AlternativeHypothesis\"\>"},
    {"439", "670.`", "\<\"AmbientLight\"\>"},
    {"440", "670.`", "\<\"Analytic\"\>"},
    {"441", "670.`", "\<\"AnchoredSearch\"\>"},
    {"442", "670.`", "\<\"AndersonDarlingTest\"\>"},
    {"443", "670.`", "\<\"AngerJ\"\>"},
    {"444", "670.`", "\<\"AngleBracket\"\>"},
    {"445", "670.`", "\<\"AngularGauge\"\>"},
    {"446", "670.`", "\<\"Animate\"\>"},
    {"447", "670.`", "\<\"AnimationCycleOffset\"\>"},
    {"448", "670.`", "\<\"AnimationCycleRepetitions\"\>"},
    {"449", "670.`", "\<\"AnimationDirection\"\>"},
    {"450", "670.`", "\<\"AnimationDisplayTime\"\>"},
    {"451", "670.`", "\<\"AnimationRate\"\>"},
    {"452", "670.`", "\<\"AnimationRepetitions\"\>"},
    {"453", "670.`", "\<\"AnimationRunning\"\>"},
    {"454", "670.`", "\<\"Animator\"\>"},
    {"455", "670.`", "\<\"AnimatorBox\"\>"},
    {"456", "670.`", "\<\"AnimatorBoxOptions\"\>"},
    {"457", "670.`", "\<\"AnimatorElements\"\>"},
    {"458", "670.`", "\<\"Annotation\"\>"},
    {"459", "670.`", "\<\"Annuity\"\>"},
    {"460", "670.`", "\<\"AnnuityDue\"\>"},
    {"461", "670.`", "\<\"Antialiasing\"\>"},
    {"462", "670.`", "\<\"Antisymmetric\"\>"},
    {"463", "670.`", "\<\"Apart\"\>"},
    {"464", "670.`", "\<\"ApartSquareFree\"\>"},
    {"465", "670.`", "\<\"Appearance\"\>"},
    {"466", "670.`", "\<\"AppearanceElements\"\>"},
    {"467", "670.`", "\<\"AppellF1\"\>"},
    {"468", "670.`", "\<\"Append\"\>"},
    {"469", "670.`", "\<\"AppendTo\"\>"},
    {"470", "670.`", "\<\"ArcCos\"\>"},
    {"471", "670.`", "\<\"ArcCosh\"\>"},
    {"472", "670.`", "\<\"ArcCot\"\>"},
    {"473", "670.`", "\<\"ArcCoth\"\>"},
    {"474", "670.`", "\<\"ArcCsc\"\>"},
    {"475", "670.`", "\<\"ArcCsch\"\>"},
    {"476", "670.`", "\<\"ArcSec\"\>"},
    {"477", "670.`", "\<\"ArcSech\"\>"},
    {"478", "670.`", "\<\"ArcSin\"\>"},
    {"479", "670.`", "\<\"ArcSinDistribution\"\>"},
    {"480", "670.`", "\<\"ArcSinh\"\>"},
    {"481", "670.`", "\<\"ArcTan\"\>"},
    {"482", "670.`", "\<\"ArcTanh\"\>"},
    {"483", "670.`", "\<\"Arg\"\>"},
    {"484", "670.`", "\<\"ArgMax\"\>"},
    {"485", "670.`", "\<\"ArgMin\"\>"},
    {"486", "670.`", "\<\"ArgumentCountQ\"\>"},
    {"487", "670.`", "\<\"ARIMAProcess\"\>"},
    {"488", "670.`", "\<\"ArithmeticGeometricMean\"\>"},
    {"489", "670.`", "\<\"ARMAProcess\"\>"},
    {"490", "670.`", "\<\"ARProcess\"\>"},
    {"491", "670.`", "\<\"Array\"\>"},
    {"492", "670.`", "\<\"ArrayComponents\"\>"},
    {"493", "670.`", "\<\"ArrayDepth\"\>"},
    {"494", "670.`", "\<\"ArrayFlatten\"\>"},
    {"495", "670.`", "\<\"ArrayPad\"\>"},
    {"496", "670.`", "\<\"ArrayPlot\"\>"},
    {"497", "670.`", "\<\"ArrayQ\"\>"},
    {"498", "670.`", "\<\"ArrayReshape\"\>"},
    {"499", "670.`", "\<\"ArrayRules\"\>"},
    {"500", "670.`", "\<\"Arrays\"\>"},
    {"501", "670.`", "\<\"Arrow\"\>"},
    {"502", "670.`", "\<\"Arrow3DBox\"\>"},
    {"503", "670.`", "\<\"ArrowBox\"\>"},
    {"504", "670.`", "\<\"Arrowheads\"\>"},
    {"505", "670.`", "\<\"AspectRatio\"\>"},
    {"506", "670.`", "\<\"AspectRatioFixed\"\>"},
    {"507", "670.`", "\<\"Assert\"\>"},
    {"508", "670.`", "\<\"Assuming\"\>"},
    {"509", "670.`", "\<\"Assumptions\"\>"},
    {"510", "670.`", "\<\"AstronomicalData\"\>"},
    {"511", "670.`", "\<\"Asynchronous\"\>"},
    {"512", "670.`", "\<\"AsynchronousTaskObject\"\>"},
    {"513", "670.`", "\<\"AsynchronousTasks\"\>"},
    {"514", "670.`", "\<\"AtomQ\"\>"},
    {"515", "670.`", "\<\"Attributes\"\>"},
    {"516", "670.`", "\<\"AugmentedSymmetricPolynomial\"\>"},
    {"517", "670.`", "\<\"AutoAction\"\>"},
    {"518", "670.`", "\<\"AutoDelete\"\>"},
    {"519", "670.`", "\<\"AutoEvaluateEvents\"\>"},
    {"520", "670.`", "\<\"AutoGeneratedPackage\"\>"},
    {"521", "670.`", "\<\"AutoIndent\"\>"},
    {"522", "670.`", "\<\"AutoIndentSpacings\"\>"},
    {"523", "670.`", "\<\"AutoItalicWords\"\>"},
    {"524", "670.`", "\<\"AutoloadPath\"\>"},
    {"525", "670.`", "\<\"AutoMatch\"\>"},
    {"526", "670.`", "\<\"Automatic\"\>"},
    {"527", "670.`", "\<\"AutomaticImageSize\"\>"},
    {"528", "670.`", "\<\"AutoMultiplicationSymbol\"\>"},
    {"529", "670.`", "\<\"AutoNumberFormatting\"\>"},
    {"530", "670.`", "\<\"AutoOpenNotebooks\"\>"},
    {"531", "670.`", "\<\"AutoOpenPalettes\"\>"},
    {"532", "670.`", "\<\"AutorunSequencing\"\>"},
    {"533", "670.`", "\<\"AutoScaling\"\>"},
    {"534", "670.`", "\<\"AutoScroll\"\>"},
    {"535", "670.`", "\<\"AutoSpacing\"\>"},
    {"536", "670.`", "\<\"AutoStyleOptions\"\>"},
    {"537", "670.`", "\<\"AutoStyleWords\"\>"},
    {"538", "670.`", "\<\"Axes\"\>"},
    {"539", "670.`", "\<\"AxesEdge\"\>"},
    {"540", "670.`", "\<\"AxesLabel\"\>"},
    {"541", "670.`", "\<\"AxesOrigin\"\>"},
    {"542", "670.`", "\<\"AxesStyle\"\>"},
    {"543", "670.`", "\<\"Axis\"\>"},
    {"544", "670.`", "\<\"BabyMonsterGroupB\"\>"},
    {"545", "670.`", "\<\"Back\"\>"},
    {"546", "670.`", "\<\"Background\"\>"},
    {"547", "670.`", "\<\"BackgroundTasksSettings\"\>"},
    {"548", "670.`", "\<\"Backsubstitution\"\>"},
    {"549", "670.`", "\<\"Backward\"\>"},
    {"550", "670.`", "\<\"Band\"\>"},
    {"551", "670.`", "\<\"BandpassFilter\"\>"},
    {"552", "670.`", "\<\"BandstopFilter\"\>"},
    {"553", "670.`", "\<\"BarabasiAlbertGraphDistribution\"\>"},
    {"554", "670.`", "\<\"BarChart\"\>"},
    {"555", "670.`", "\<\"BarChart3D\"\>"},
    {"556", "670.`", "\<\"BarLegend\"\>"},
    {"557", "670.`", "\<\"BarlowProschanImportance\"\>"},
    {"558", "670.`", "\<\"BarnesG\"\>"},
    {"559", "670.`", "\<\"BarOrigin\"\>"},
    {"560", "670.`", "\<\"BarSpacing\"\>"},
    {"561", "670.`", "\<\"BartlettHannWindow\"\>"},
    {"562", "670.`", "\<\"BartlettWindow\"\>"},
    {"563", "670.`", "\<\"BaseForm\"\>"},
    {"564", "670.`", "\<\"Baseline\"\>"},
    {"565", "670.`", "\<\"BaselinePosition\"\>"},
    {"566", "670.`", "\<\"BaseStyle\"\>"},
    {"567", "670.`", "\<\"BatesDistribution\"\>"},
    {"568", "670.`", "\<\"BattleLemarieWavelet\"\>"},
    {"569", "670.`", "\<\"BeckmannDistribution\"\>"},
    {"570", "670.`", "\<\"Beep\"\>"},
    {"571", "670.`", "\<\"Before\"\>"},
    {"572", "670.`", "\<\"Begin\"\>"},
    {"573", "670.`", "\<\"BeginDialogPacket\"\>"},
    {"574", "670.`", "\<\"BeginFrontEndInteractionPacket\"\>"},
    {"575", "670.`", "\<\"BeginPackage\"\>"},
    {"576", "670.`", "\<\"BellB\"\>"},
    {"577", "670.`", "\<\"BellY\"\>"},
    {"578", "670.`", "\<\"Below\"\>"},
    {"579", "670.`", "\<\"BenfordDistribution\"\>"},
    {"580", "670.`", "\<\"BeniniDistribution\"\>"},
    {"581", "670.`", "\<\"BenktanderGibratDistribution\"\>"},
    {"582", "670.`", "\<\"BenktanderWeibullDistribution\"\>"},
    {"583", "670.`", "\<\"BernoulliB\"\>"},
    {"584", "670.`", "\<\"BernoulliDistribution\"\>"},
    {"585", "670.`", "\<\"BernoulliGraphDistribution\"\>"},
    {"586", "670.`", "\<\"BernoulliProcess\"\>"},
    {"587", "670.`", "\<\"BernsteinBasis\"\>"},
    {"588", "670.`", "\<\"BesselFilterModel\"\>"},
    {"589", "670.`", "\<\"BesselI\"\>"},
    {"590", "670.`", "\<\"BesselJ\"\>"},
    {"591", "670.`", "\<\"BesselJZero\"\>"},
    {"592", "670.`", "\<\"BesselK\"\>"},
    {"593", "670.`", "\<\"BesselY\"\>"},
    {"594", "670.`", "\<\"BesselYZero\"\>"},
    {"595", "670.`", "\<\"Beta\"\>"},
    {"596", "670.`", "\<\"BetaBinomialDistribution\"\>"},
    {"597", "670.`", "\<\"BetaDistribution\"\>"},
    {"598", "670.`", "\<\"BetaNegativeBinomialDistribution\"\>"},
    {"599", "670.`", "\<\"BetaPrimeDistribution\"\>"},
    {"600", "670.`", "\<\"BetaRegularized\"\>"},
    {"601", "670.`", "\<\"BetweennessCentrality\"\>"},
    {"602", "670.`", "\<\"BezierCurve\"\>"},
    {"603", "670.`", "\<\"BezierCurve3DBox\"\>"},
    {"604", "670.`", "\<\"BezierCurve3DBoxOptions\"\>"},
    {"605", "670.`", "\<\"BezierCurveBox\"\>"},
    {"606", "670.`", "\<\"BezierCurveBoxOptions\"\>"},
    {"607", "670.`", "\<\"BezierFunction\"\>"},
    {"608", "670.`", "\<\"BilateralFilter\"\>"},
    {"609", "670.`", "\<\"Binarize\"\>"},
    {"610", "670.`", "\<\"BinaryFormat\"\>"},
    {"611", "670.`", "\<\"BinaryImageQ\"\>"},
    {"612", "670.`", "\<\"BinaryRead\"\>"},
    {"613", "670.`", "\<\"BinaryReadList\"\>"},
    {"614", "670.`", "\<\"BinaryWrite\"\>"},
    {"615", "670.`", "\<\"BinCounts\"\>"},
    {"616", "670.`", "\<\"BinLists\"\>"},
    {"617", "670.`", "\<\"Binomial\"\>"},
    {"618", "670.`", "\<\"BinomialDistribution\"\>"},
    {"619", "670.`", "\<\"BinomialProcess\"\>"},
    {"620", "670.`", "\<\"BinormalDistribution\"\>"},
    {"621", "670.`", "\<\"BiorthogonalSplineWavelet\"\>"},
    {"622", "670.`", "\<\"BipartiteGraphQ\"\>"},
    {"623", "670.`", "\<\"BirnbaumImportance\"\>"},
    {"624", "670.`", "\<\"BirnbaumSaundersDistribution\"\>"},
    {"625", "670.`", "\<\"BitAnd\"\>"},
    {"626", "670.`", "\<\"BitClear\"\>"},
    {"627", "670.`", "\<\"BitGet\"\>"},
    {"628", "670.`", "\<\"BitLength\"\>"},
    {"629", "670.`", "\<\"BitNot\"\>"},
    {"630", "670.`", "\<\"BitOr\"\>"},
    {"631", "670.`", "\<\"BitSet\"\>"},
    {"632", "670.`", "\<\"BitShiftLeft\"\>"},
    {"633", "670.`", "\<\"BitShiftRight\"\>"},
    {"634", "670.`", "\<\"BitXor\"\>"},
    {"635", "670.`", "\<\"BlackmanHarrisWindow\"\>"},
    {"636", "670.`", "\<\"BlackmanNuttallWindow\"\>"},
    {"637", "670.`", "\<\"BlackmanWindow\"\>"},
    {"638", "670.`", "\<\"BlankForm\"\>"},
    {"639", "670.`", "\<\"Blend\"\>"},
    {"640", "670.`", "\<\"Block\"\>"},
    {"641", "670.`", "\<\"BlockRandom\"\>"},
    {"642", "670.`", "\<\"BlomqvistBeta\"\>"},
    {"643", "670.`", "\<\"BlomqvistBetaTest\"\>"},
    {"644", "670.`", "\<\"Blur\"\>"},
    {"645", "670.`", "\<\"BodePlot\"\>"},
    {"646", "670.`", "\<\"BohmanWindow\"\>"},
    {"647", "670.`", "\<\"Bold\"\>"},
    {"648", "670.`", "\<\"Bookmarks\"\>"},
    {"649", "670.`", "\<\"Boole\"\>"},
    {"650", "670.`", "\<\"BooleanConsecutiveFunction\"\>"},
    {"651", "670.`", "\<\"BooleanConvert\"\>"},
    {"652", "670.`", "\<\"BooleanCountingFunction\"\>"},
    {"653", "670.`", "\<\"BooleanFunction\"\>"},
    {"654", "670.`", "\<\"BooleanGraph\"\>"},
    {"655", "670.`", "\<\"BooleanMaxterms\"\>"},
    {"656", "670.`", "\<\"BooleanMinimize\"\>"},
    {"657", "670.`", "\<\"BooleanMinterms\"\>"},
    {"658", "670.`", "\<\"Booleans\"\>"},
    {"659", "670.`", "\<\"BooleanTable\"\>"},
    {"660", "670.`", "\<\"BooleanVariables\"\>"},
    {"661", "670.`", "\<\"BorderDimensions\"\>"},
    {"662", "670.`", "\<\"BorelTannerDistribution\"\>"},
    {"663", "670.`", "\<\"Bottom\"\>"},
    {"664", "670.`", "\<\"BottomHatTransform\"\>"},
    {"665", "670.`", "\<\"BoundaryStyle\"\>"},
    {"666", "670.`", "\<\"Bounds\"\>"},
    {"667", "670.`", "\<\"Box\"\>"},
    {"668", "670.`", "\<\"BoxBaselineShift\"\>"},
    {"669", "670.`", "\<\"BoxData\"\>"},
    {"670", "670.`", "\<\"BoxDimensions\"\>"},
    {"671", "670.`", "\<\"Boxed\"\>"},
    {"672", "670.`", "\<\"Boxes\"\>"},
    {"673", "670.`", "\<\"BoxForm\"\>"},
    {"674", "670.`", "\<\"BoxFormFormatTypes\"\>"},
    {"675", "670.`", "\<\"BoxFrame\"\>"},
    {"676", "670.`", "\<\"BoxID\"\>"},
    {"677", "670.`", "\<\"BoxMargins\"\>"},
    {"678", "670.`", "\<\"BoxMatrix\"\>"},
    {"679", "670.`", "\<\"BoxRatios\"\>"},
    {"680", "670.`", "\<\"BoxRotation\"\>"},
    {"681", "670.`", "\<\"BoxRotationPoint\"\>"},
    {"682", "670.`", "\<\"BoxStyle\"\>"},
    {"683", "670.`", "\<\"BoxWhiskerChart\"\>"},
    {"684", "670.`", "\<\"Bra\"\>"},
    {"685", "670.`", "\<\"BracketingBar\"\>"},
    {"686", "670.`", "\<\"BraKet\"\>"},
    {"687", "670.`", "\<\"BrayCurtisDistance\"\>"},
    {"688", "670.`", "\<\"BreadthFirstScan\"\>"},
    {"689", "670.`", "\<\"Break\"\>"},
    {"690", "670.`", "\<\"BrownForsytheTest\"\>"},
    {"691", "670.`", "\<\"BrownianBridgeProcess\"\>"},
    {"692", "670.`", "\<\"BrowserCategory\"\>"},
    {"693", "670.`", "\<\"BSplineBasis\"\>"},
    {"694", "670.`", "\<\"BSplineCurve\"\>"},
    {"695", "670.`", "\<\"BSplineCurve3DBox\"\>"},
    {"696", "670.`", "\<\"BSplineCurveBox\"\>"},
    {"697", "670.`", "\<\"BSplineCurveBoxOptions\"\>"},
    {"698", "670.`", "\<\"BSplineFunction\"\>"},
    {"699", "670.`", "\<\"BSplineSurface\"\>"},
    {"700", "670.`", "\<\"BSplineSurface3DBox\"\>"},
    {"701", "670.`", "\<\"BubbleChart\"\>"},
    {"702", "670.`", "\<\"BubbleChart3D\"\>"},
    {"703", "670.`", "\<\"BubbleScale\"\>"},
    {"704", "670.`", "\<\"BubbleSizes\"\>"},
    {"705", "670.`", "\<\"BulletGauge\"\>"},
    {"706", "670.`", "\<\"BusinessDayQ\"\>"},
    {"707", "670.`", "\<\"ButterflyGraph\"\>"},
    {"708", "670.`", "\<\"ButterworthFilterModel\"\>"},
    {"709", "670.`", "\<\"Button\"\>"},
    {"710", "670.`", "\<\"ButtonBar\"\>"},
    {"711", "670.`", "\<\"ButtonBox\"\>"},
    {"712", "670.`", "\<\"ButtonBoxOptions\"\>"},
    {"713", "670.`", "\<\"ButtonCell\"\>"},
    {"714", "670.`", "\<\"ButtonContents\"\>"},
    {"715", "670.`", "\<\"ButtonData\"\>"},
    {"716", "670.`", "\<\"ButtonEvaluator\"\>"},
    {"717", "670.`", "\<\"ButtonExpandable\"\>"},
    {"718", "670.`", "\<\"ButtonFrame\"\>"},
    {"719", "670.`", "\<\"ButtonFunction\"\>"},
    {"720", "670.`", "\<\"ButtonMargins\"\>"},
    {"721", "670.`", "\<\"ButtonMinHeight\"\>"},
    {"722", "670.`", "\<\"ButtonNote\"\>"},
    {"723", "670.`", "\<\"ButtonNotebook\"\>"},
    {"724", "670.`", "\<\"ButtonSource\"\>"},
    {"725", "670.`", "\<\"ButtonStyle\"\>"},
    {"726", "670.`", "\<\"ButtonStyleMenuListing\"\>"},
    {"727", "670.`", "\<\"Byte\"\>"},
    {"728", "670.`", "\<\"ByteCount\"\>"},
    {"729", "670.`", "\<\"ByteOrdering\"\>"},
    {"730", "670.`", "\<\"C\"\>"},
    {"731", "670.`", "\<\"CachedValue\"\>"},
    {"732", "670.`", "\<\"CacheGraphics\"\>"},
    {"733", "670.`", "\<\"CalendarData\"\>"},
    {"734", "670.`", "\<\"CalendarType\"\>"},
    {"735", "670.`", "\<\"CallPacket\"\>"},
    {"736", "670.`", "\<\"CanberraDistance\"\>"},
    {"737", "670.`", "\<\"Cancel\"\>"},
    {"738", "670.`", "\<\"CancelButton\"\>"},
    {"739", "670.`", "\<\"CandlestickChart\"\>"},
    {"740", "670.`", "\<\"CapForm\"\>"},
    {"741", "670.`", "\<\"CardinalBSplineBasis\"\>"},
    {"742", "670.`", "\<\"CarmichaelLambda\"\>"},
    {"743", "670.`", "\<\"Cases\"\>"},
    {"744", "670.`", "\<\"Cashflow\"\>"},
    {"745", "670.`", "\<\"Casoratian\"\>"},
    {"746", "670.`", "\<\"Catalan\"\>"},
    {"747", "670.`", "\<\"CatalanNumber\"\>"},
    {"748", "670.`", "\<\"Catch\"\>"},
    {"749", "670.`", "\<\"CauchyDistribution\"\>"},
    {"750", "670.`", "\<\"CauchyWindow\"\>"},
    {"751", "670.`", "\<\"CayleyGraph\"\>"},
    {"752", "670.`", "\<\"CDF\"\>"},
    {"753", "670.`", "\<\"CDFDeploy\"\>"},
    {"754", "670.`", "\<\"CDFInformation\"\>"},
    {"755", "670.`", "\<\"CDFWavelet\"\>"},
    {"756", "670.`", "\<\"Ceiling\"\>"},
    {"757", "670.`", "\<\"Cell\"\>"},
    {"758", "670.`", "\<\"CellAutoOverwrite\"\>"},
    {"759", "670.`", "\<\"CellBaseline\"\>"},
    {"760", "670.`", "\<\"CellBoundingBox\"\>"},
    {"761", "670.`", "\<\"CellBracketOptions\"\>"},
    {"762", "670.`", "\<\"CellChangeTimes\"\>"},
    {"763", "670.`", "\<\"CellContents\"\>"},
    {"764", "670.`", "\<\"CellContext\"\>"},
    {"765", "670.`", "\<\"CellDingbat\"\>"},
    {"766", "670.`", "\<\"CellDynamicExpression\"\>"},
    {"767", "670.`", "\<\"CellEditDuplicate\"\>"},
    {"768", "670.`", "\<\"CellElementsBoundingBox\"\>"},
    {"769", "670.`", "\<\"CellElementSpacings\"\>"},
    {"770", "670.`", "\<\"CellEpilog\"\>"},
    {"771", "670.`", "\<\"CellEvaluationDuplicate\"\>"},
    {"772", "670.`", "\<\"CellEvaluationFunction\"\>"},
    {"773", "670.`", "\<\"CellEventActions\"\>"},
    {"774", "670.`", "\<\"CellFrame\"\>"},
    {"775", "670.`", "\<\"CellFrameColor\"\>"},
    {"776", "670.`", "\<\"CellFrameLabelMargins\"\>"},
    {"777", "670.`", "\<\"CellFrameLabels\"\>"},
    {"778", "670.`", "\<\"CellFrameMargins\"\>"},
    {"779", "670.`", "\<\"CellGroup\"\>"},
    {"780", "670.`", "\<\"CellGroupData\"\>"},
    {"781", "670.`", "\<\"CellGrouping\"\>"},
    {"782", "670.`", "\<\"CellGroupingRules\"\>"},
    {"783", "670.`", "\<\"CellHorizontalScrolling\"\>"},
    {"784", "670.`", "\<\"CellID\"\>"},
    {"785", "670.`", "\<\"CellLabel\"\>"},
    {"786", "670.`", "\<\"CellLabelAutoDelete\"\>"},
    {"787", "670.`", "\<\"CellLabelMargins\"\>"},
    {"788", "670.`", "\<\"CellLabelPositioning\"\>"},
    {"789", "670.`", "\<\"CellMargins\"\>"},
    {"790", "670.`", "\<\"CellObject\"\>"},
    {"791", "670.`", "\<\"CellOpen\"\>"},
    {"792", "670.`", "\<\"CellPrint\"\>"},
    {"793", "670.`", "\<\"CellProlog\"\>"},
    {"794", "670.`", "\<\"Cells\"\>"},
    {"795", "670.`", "\<\"CellSize\"\>"},
    {"796", "670.`", "\<\"CellStyle\"\>"},
    {"797", "670.`", "\<\"CellTags\"\>"},
    {"798", "670.`", "\<\"CellularAutomaton\"\>"},
    {"799", "670.`", "\<\"CensoredDistribution\"\>"},
    {"800", "670.`", "\<\"Censoring\"\>"},
    {"801", "670.`", "\<\"Center\"\>"},
    {"802", "670.`", "\<\"CentralMoment\"\>"},
    {"803", "670.`", "\<\"CentralMomentGeneratingFunction\"\>"},
    {"804", "670.`", "\<\"CForm\"\>"},
    {"805", "670.`", "\<\"ChampernowneNumber\"\>"},
    {"806", "670.`", "\<\"ChanVeseBinarize\"\>"},
    {"807", "670.`", "\<\"Character\"\>"},
    {"808", "670.`", "\<\"CharacterEncoding\"\>"},
    {"809", "670.`", "\<\"CharacterEncodingsPath\"\>"},
    {"810", "670.`", "\<\"CharacteristicFunction\"\>"},
    {"811", "670.`", "\<\"CharacteristicPolynomial\"\>"},
    {"812", "670.`", "\<\"CharacterRange\"\>"},
    {"813", "670.`", "\<\"Characters\"\>"},
    {"814", "670.`", "\<\"ChartBaseStyle\"\>"},
    {"815", "670.`", "\<\"ChartElementData\"\>"},
    {"816", "670.`", "\<\"ChartElementDataFunction\"\>"},
    {"817", "670.`", "\<\"ChartElementFunction\"\>"},
    {"818", "670.`", "\<\"ChartElements\"\>"},
    {"819", "670.`", "\<\"ChartLabels\"\>"},
    {"820", "670.`", "\<\"ChartLayout\"\>"},
    {"821", "670.`", "\<\"ChartLegends\"\>"},
    {"822", "670.`", "\<\"ChartStyle\"\>"},
    {"823", "670.`", "\<\"Chebyshev1FilterModel\"\>"},
    {"824", "670.`", "\<\"Chebyshev2FilterModel\"\>"},
    {"825", "670.`", "\<\"ChebyshevDistance\"\>"},
    {"826", "670.`", "\<\"ChebyshevT\"\>"},
    {"827", "670.`", "\<\"ChebyshevU\"\>"},
    {"828", "670.`", "\<\"Check\"\>"},
    {"829", "670.`", "\<\"CheckAbort\"\>"},
    {"830", "670.`", "\<\"CheckAll\"\>"},
    {"831", "670.`", "\<\"Checkbox\"\>"},
    {"832", "670.`", "\<\"CheckboxBar\"\>"},
    {"833", "670.`", "\<\"CheckboxBox\"\>"},
    {"834", "670.`", "\<\"CheckboxBoxOptions\"\>"},
    {"835", "670.`", "\<\"ChemicalData\"\>"},
    {"836", "670.`", "\<\"ChessboardDistance\"\>"},
    {"837", "670.`", "\<\"ChiDistribution\"\>"},
    {"838", "670.`", "\<\"ChineseRemainder\"\>"},
    {"839", "670.`", "\<\"ChiSquareDistribution\"\>"},
    {"840", "670.`", "\<\"ChoiceButtons\"\>"},
    {"841", "670.`", "\<\"ChoiceDialog\"\>"},
    {"842", "670.`", "\<\"CholeskyDecomposition\"\>"},
    {"843", "670.`", "\<\"Chop\"\>"},
    {"844", "670.`", "\<\"Circle\"\>"},
    {"845", "670.`", "\<\"CircleBox\"\>"},
    {"846", "670.`", "\<\"CirculantGraph\"\>"},
    {"847", "670.`", "\<\"CityData\"\>"},
    {"848", "670.`", "\<\"Clear\"\>"},
    {"849", "670.`", "\<\"ClearAll\"\>"},
    {"850", "670.`", "\<\"ClearAttributes\"\>"},
    {"851", "670.`", "\<\"ClearSystemCache\"\>"},
    {"852", "670.`", "\<\"ClebschGordan\"\>"},
    {"853", "670.`", "\<\"ClickPane\"\>"},
    {"854", "670.`", "\<\"Clip\"\>"},
    {"855", "670.`", "\<\"ClipboardNotebook\"\>"},
    {"856", "670.`", "\<\"ClipFill\"\>"},
    {"857", "670.`", "\<\"ClippingStyle\"\>"},
    {"858", "670.`", "\<\"ClipPlanes\"\>"},
    {"859", "670.`", "\<\"ClipRange\"\>"},
    {"860", "670.`", "\<\"Clock\"\>"},
    {"861", "670.`", "\<\"ClockGauge\"\>"},
    {"862", "670.`", "\<\"ClockwiseContourIntegral\"\>"},
    {"863", "670.`", "\<\"Close\"\>"},
    {"864", "670.`", "\<\"Closed\"\>"},
    {"865", "670.`", "\<\"CloseKernels\"\>"},
    {"866", "670.`", "\<\"ClosenessCentrality\"\>"},
    {"867", "670.`", "\<\"Closing\"\>"},
    {"868", "670.`", "\<\"ClosingAutoSave\"\>"},
    {"869", "670.`", "\<\"ClosingEvent\"\>"},
    {"870", "670.`", "\<\"ClusteringComponents\"\>"},
    {"871", "670.`", "\<\"CMYKColor\"\>"},
    {"872", "670.`", "\<\"Coarse\"\>"},
    {"873", "670.`", "\<\"Coefficient\"\>"},
    {"874", "670.`", "\<\"CoefficientArrays\"\>"},
    {"875", "670.`", "\<\"CoefficientDomain\"\>"},
    {"876", "670.`", "\<\"CoefficientList\"\>"},
    {"877", "670.`", "\<\"CoefficientRules\"\>"},
    {"878", "670.`", "\<\"CoifletWavelet\"\>"},
    {"879", "670.`", "\<\"Collect\"\>"},
    {"880", "670.`", "\<\"ColorCombine\"\>"},
    {"881", "670.`", "\<\"ColorConvert\"\>"},
    {"882", "670.`", "\<\"ColorData\"\>"},
    {"883", "670.`", "\<\"ColorDataFunction\"\>"},
    {"884", "670.`", "\<\"ColorFunction\"\>"},
    {"885", "670.`", "\<\"ColorFunctionScaling\"\>"},
    {"886", "670.`", "\<\"Colorize\"\>"},
    {"887", "670.`", "\<\"ColorNegate\"\>"},
    {"888", "670.`", "\<\"ColorOutput\"\>"},
    {"889", "670.`", "\<\"ColorProfileData\"\>"},
    {"890", "670.`", "\<\"ColorQuantize\"\>"},
    {"891", "670.`", "\<\"ColorReplace\"\>"},
    {"892", "670.`", "\<\"ColorRules\"\>"},
    {"893", "670.`", "\<\"ColorSelectorSettings\"\>"},
    {"894", "670.`", "\<\"ColorSeparate\"\>"},
    {"895", "670.`", "\<\"ColorSetter\"\>"},
    {"896", "670.`", "\<\"ColorSetterBox\"\>"},
    {"897", "670.`", "\<\"ColorSetterBoxOptions\"\>"},
    {"898", "670.`", "\<\"ColorSlider\"\>"},
    {"899", "670.`", "\<\"ColorSpace\"\>"},
    {"900", "670.`", "\<\"Column\"\>"},
    {"901", "670.`", "\<\"ColumnAlignments\"\>"},
    {"902", "670.`", "\<\"ColumnBackgrounds\"\>"},
    {"903", "670.`", "\<\"ColumnForm\"\>"},
    {"904", "670.`", "\<\"ColumnLines\"\>"},
    {"905", "670.`", "\<\"ColumnsEqual\"\>"},
    {"906", "670.`", "\<\"ColumnSpacings\"\>"},
    {"907", "670.`", "\<\"ColumnWidths\"\>"},
    {"908", "670.`", "\<\"CommonDefaultFormatTypes\"\>"},
    {"909", "670.`", "\<\"Commonest\"\>"},
    {"910", "670.`", "\<\"CommonestFilter\"\>"},
    {"911", "670.`", "\<\"CommonUnits\"\>"},
    {"912", "670.`", "\<\"CommunityBoundaryStyle\"\>"},
    {"913", "670.`", "\<\"CommunityGraphPlot\"\>"},
    {"914", "670.`", "\<\"CommunityLabels\"\>"},
    {"915", "670.`", "\<\"CommunityRegionStyle\"\>"},
    {"916", "670.`", "\<\"CompatibleUnitQ\"\>"},
    {"917", "670.`", "\<\"CompilationOptions\"\>"},
    {"918", "670.`", "\<\"CompilationTarget\"\>"},
    {"919", "670.`", "\<\"Compile\"\>"},
    {"920", "670.`", "\<\"Compiled\"\>"},
    {"921", "670.`", "\<\"CompiledFunction\"\>"},
    {"922", "670.`", "\<\"Complement\"\>"},
    {"923", "670.`", "\<\"CompleteGraph\"\>"},
    {"924", "670.`", "\<\"CompleteGraphQ\"\>"},
    {"925", "670.`", "\<\"CompleteKaryTree\"\>"},
    {"926", "670.`", "\<\"CompletionsListPacket\"\>"},
    {"927", "670.`", "\<\"Complexes\"\>"},
    {"928", "670.`", "\<\"ComplexExpand\"\>"},
    {"929", "670.`", "\<\"ComplexityFunction\"\>"},
    {"930", "670.`", "\<\"ComponentMeasurements\"\>"},
    {"931", "670.`", "\<\"ComponentwiseContextMenu\"\>"},
    {"932", "670.`", "\<\"Compose\"\>"},
    {"933", "670.`", "\<\"ComposeList\"\>"},
    {"934", "670.`", "\<\"ComposeSeries\"\>"},
    {"935", "670.`", "\<\"Composition\"\>"},
    {"936", "670.`", "\<\"CompoundPoissonDistribution\"\>"},
    {"937", "670.`", "\<\"CompoundPoissonProcess\"\>"},
    {"938", "670.`", "\<\"CompoundRenewalProcess\"\>"},
    {"939", "670.`", "\<\"Compress\"\>"},
    {"940", "670.`", "\<\"CompressedData\"\>"},
    {"941", "670.`", "\<\"ConditionalExpression\"\>"},
    {"942", "670.`", "\<\"Cone\"\>"},
    {"943", "670.`", "\<\"ConeBox\"\>"},
    {"944", "670.`", "\<\"ConfidenceLevel\"\>"},
    {"945", "670.`", "\<\"ConfidenceRange\"\>"},
    {"946", "670.`", "\<\"ConfidenceTransform\"\>"},
    {"947", "670.`", "\<\"ConfigurationPath\"\>"},
    {"948", "670.`", "\<\"Conjugate\"\>"},
    {"949", "670.`", "\<\"ConjugateTranspose\"\>"},
    {"950", "670.`", "\<\"Conjunction\"\>"},
    {"951", "670.`", "\<\"Connect\"\>"},
    {"952", "670.`", "\<\"ConnectedComponents\"\>"},
    {"953", "670.`", "\<\"ConnectedGraphQ\"\>"},
    {"954", "670.`", "\<\"ConnesWindow\"\>"},
    {"955", "670.`", "\<\"ConoverTest\"\>"},
    {"956", "670.`", "\<\"ConsoleMessage\"\>"},
    {"957", "670.`", "\<\"ConsoleMessagePacket\"\>"},
    {"958", "670.`", "\<\"ConsolePrint\"\>"},
    {"959", "670.`", "\<\"Constant\"\>"},
    {"960", "670.`", "\<\"ConstantArray\"\>"},
    {"961", "670.`", "\<\"Constants\"\>"},
    {"962", "670.`", "\<\"ConstrainedMax\"\>"},
    {"963", "670.`", "\<\"ConstrainedMin\"\>"},
    {"964", "670.`", "\<\"ContentPadding\"\>"},
    {"965", "670.`", "\<\"ContentsBoundingBox\"\>"},
    {"966", "670.`", "\<\"ContentSelectable\"\>"},
    {"967", "670.`", "\<\"ContentSize\"\>"},
    {"968", "670.`", "\<\"Context\"\>"},
    {"969", "670.`", "\<\"ContextMenu\"\>"},
    {"970", "670.`", "\<\"Contexts\"\>"},
    {"971", "670.`", "\<\"ContextToFilename\"\>"},
    {"972", "670.`", "\<\"ContextToFileName\"\>"},
    {"973", "670.`", "\<\"Continuation\"\>"},
    {"974", "670.`", "\<\"Continue\"\>"},
    {"975", "670.`", "\<\"ContinuedFraction\"\>"},
    {"976", "670.`", "\<\"ContinuousAction\"\>"},
    {"977", "670.`", "\<\"ContinuousMarkovProcess\"\>"},
    {"978", "670.`", "\<\"ContinuousTimeModelQ\"\>"},
    {"979", "670.`", "\<\"ContinuousWaveletData\"\>"},
    {"980", "670.`", "\<\"ContinuousWaveletTransform\"\>"},
    {"981", "670.`", "\<\"ContourDetect\"\>"},
    {"982", "670.`", "\<\"ContourGraphics\"\>"},
    {"983", "670.`", "\<\"ContourIntegral\"\>"},
    {"984", "670.`", "\<\"ContourLabels\"\>"},
    {"985", "670.`", "\<\"ContourLines\"\>"},
    {"986", "670.`", "\<\"ContourPlot\"\>"},
    {"987", "670.`", "\<\"ContourPlot3D\"\>"},
    {"988", "670.`", "\<\"Contours\"\>"},
    {"989", "670.`", "\<\"ContourShading\"\>"},
    {"990", "670.`", "\<\"ContourSmoothing\"\>"},
    {"991", "670.`", "\<\"ContourStyle\"\>"},
    {"992", "670.`", "\<\"ContraharmonicMean\"\>"},
    {"993", "670.`", "\<\"Control\"\>"},
    {"994", "670.`", "\<\"ControlActive\"\>"},
    {"995", "670.`", "\<\"ControlAlignment\"\>"},
    {"996", "670.`", "\<\"ControllabilityGramian\"\>"},
    {"997", "670.`", "\<\"ControllabilityMatrix\"\>"},
    {"998", "670.`", "\<\"ControllableDecomposition\"\>"},
    {"999", "670.`", "\<\"ControllableModelQ\"\>"},
    {"1000", "670.`", "\<\"ControllerInformation\"\>"},
    {"1001", "670.`", "\<\"ControllerInformationData\"\>"},
    {"1002", "670.`", "\<\"ControllerLinking\"\>"},
    {"1003", "670.`", "\<\"ControllerManipulate\"\>"},
    {"1004", "670.`", "\<\"ControllerMethod\"\>"},
    {"1005", "670.`", "\<\"ControllerPath\"\>"},
    {"1006", "670.`", "\<\"ControllerState\"\>"},
    {"1007", "670.`", "\<\"ControlPlacement\"\>"},
    {"1008", "670.`", "\<\"ControlsRendering\"\>"},
    {"1009", "670.`", "\<\"ControlType\"\>"},
    {"1010", "670.`", "\<\"Convergents\"\>"},
    {"1011", "670.`", "\<\"ConversionOptions\"\>"},
    {"1012", "670.`", "\<\"ConversionRules\"\>"},
    {"1013", "670.`", "\<\"ConvertToBitmapPacket\"\>"},
    {"1014", "670.`", "\<\"ConvertToPostScript\"\>"},
    {"1015", "670.`", "\<\"ConvertToPostScriptPacket\"\>"},
    {"1016", "670.`", "\<\"Convolve\"\>"},
    {"1017", "670.`", "\<\"ConwayGroupCo1\"\>"},
    {"1018", "670.`", "\<\"ConwayGroupCo2\"\>"},
    {"1019", "670.`", "\<\"ConwayGroupCo3\"\>"},
    {"1020", "670.`", "\<\"CoordinateChartData\"\>"},
    {"1021", "670.`", "\<\"CoordinatesToolOptions\"\>"},
    {"1022", "670.`", "\<\"CoordinateTransform\"\>"},
    {"1023", "670.`", "\<\"CoordinateTransformData\"\>"},
    {"1024", "670.`", "\<\"CoprimeQ\"\>"},
    {"1025", "670.`", "\<\"CopulaDistribution\"\>"},
    {"1026", "670.`", "\<\"Copyable\"\>"},
    {"1027", "670.`", "\<\"CopyDirectory\"\>"},
    {"1028", "670.`", "\<\"CopyFile\"\>"},
    {"1029", "670.`", "\<\"CopyTag\"\>"},
    {"1030", "670.`", "\<\"CopyToClipboard\"\>"},
    {"1031", "670.`", "\<\"CornerFilter\"\>"},
    {"1032", "670.`", "\<\"CornerNeighbors\"\>"},
    {"1033", "670.`", "\<\"Correlation\"\>"},
    {"1034", "670.`", "\<\"CorrelationDistance\"\>"},
    {"1035", "670.`", "\<\"CorrelationFunction\"\>"},
    {"1036", "670.`", "\<\"CorrelationTest\"\>"},
    {"1037", "670.`", "\<\"Cos\"\>"},
    {"1038", "670.`", "\<\"Cosh\"\>"},
    {"1039", "670.`", "\<\"CoshIntegral\"\>"},
    {"1040", "670.`", "\<\"CosineDistance\"\>"},
    {"1041", "670.`", "\<\"CosineWindow\"\>"},
    {"1042", "670.`", "\<\"CosIntegral\"\>"},
    {"1043", "670.`", "\<\"Cot\"\>"},
    {"1044", "670.`", "\<\"Coth\"\>"},
    {"1045", "670.`", "\<\"Count\"\>"},
    {"1046", "670.`", "\<\"CounterAssignments\"\>"},
    {"1047", "670.`", "\<\"CounterBox\"\>"},
    {"1048", "670.`", "\<\"CounterBoxOptions\"\>"},
    {"1049", "670.`", "\<\"CounterClockwiseContourIntegral\"\>"},
    {"1050", "670.`", "\<\"CounterEvaluator\"\>"},
    {"1051", "670.`", "\<\"CounterFunction\"\>"},
    {"1052", "670.`", "\<\"CounterIncrements\"\>"},
    {"1053", "670.`", "\<\"CounterStyle\"\>"},
    {"1054", "670.`", "\<\"CounterStyleMenuListing\"\>"},
    {"1055", "670.`", "\<\"CountRoots\"\>"},
    {"1056", "670.`", "\<\"CountryData\"\>"},
    {"1057", "670.`", "\<\"Covariance\"\>"},
    {"1058", "670.`", "\<\"CovarianceEstimatorFunction\"\>"},
    {"1059", "670.`", "\<\"CovarianceFunction\"\>"},
    {"1060", "670.`", "\<\"CoxianDistribution\"\>"},
    {"1061", "670.`", "\<\"CoxIngersollRossProcess\"\>"},
    {"1062", "670.`", "\<\"CoxModel\"\>"},
    {"1063", "670.`", "\<\"CoxModelFit\"\>"},
    {"1064", "670.`", "\<\"CramerVonMisesTest\"\>"},
    {"1065", "670.`", "\<\"CreateArchive\"\>"},
    {"1066", "670.`", "\<\"CreateDialog\"\>"},
    {"1067", "670.`", "\<\"CreateDirectory\"\>"},
    {"1068", "670.`", "\<\"CreateDocument\"\>"},
    {"1069", "670.`", "\<\"CreateIntermediateDirectories\"\>"},
    {"1070", "670.`", "\<\"CreatePalette\"\>"},
    {"1071", "670.`", "\<\"CreatePalettePacket\"\>"},
    {"1072", "670.`", "\<\"CreateScheduledTask\"\>"},
    {"1073", "670.`", "\<\"CreateTemporary\"\>"},
    {"1074", "670.`", "\<\"CreateWindow\"\>"},
    {"1075", "670.`", "\<\"CriticalityFailureImportance\"\>"},
    {"1076", "670.`", "\<\"CriticalitySuccessImportance\"\>"},
    {"1077", "670.`", "\<\"CriticalSection\"\>"},
    {"1078", "670.`", "\<\"CrossingDetect\"\>"},
    {"1079", "670.`", "\<\"CrossMatrix\"\>"},
    {"1080", "670.`", "\<\"Csc\"\>"},
    {"1081", "670.`", "\<\"Csch\"\>"},
    {"1082", "670.`", "\<\"CubeRoot\"\>"},
    {"1083", "670.`", "\<\"Cubics\"\>"},
    {"1084", "670.`", "\<\"Cuboid\"\>"},
    {"1085", "670.`", "\<\"CuboidBox\"\>"},
    {"1086", "670.`", "\<\"Cumulant\"\>"},
    {"1087", "670.`", "\<\"CumulantGeneratingFunction\"\>"},
    {"1088", "670.`", "\<\"CurlyDoubleQuote\"\>"},
    {"1089", "670.`", "\<\"CurlyQuote\"\>"},
    {"1090", "670.`", "\<\"CurrentImage\"\>"},
    {"1091", "670.`", "\<\"CurrentlySpeakingPacket\"\>"},
    {"1092", "670.`", "\<\"CurrentValue\"\>"},
    {"1093", "670.`", "\<\"CurvatureFlowFilter\"\>"},
    {"1094", "670.`", "\<\"CurveClosed\"\>"},
    {"1095", "670.`", "\<\"CycleGraph\"\>"},
    {"1096", "670.`", "\<\"CycleIndexPolynomial\"\>"},
    {"1097", "670.`", "\<\"Cycles\"\>"},
    {"1098", "670.`", "\<\"CyclicGroup\"\>"},
    {"1099", "670.`", "\<\"Cyclotomic\"\>"},
    {"1100", "670.`", "\<\"Cylinder\"\>"},
    {"1101", "670.`", "\<\"CylinderBox\"\>"},
    {"1102", "670.`", "\<\"CylindricalDecomposition\"\>"},
    {"1103", "670.`", "\<\"DagumDistribution\"\>"},
    {"1104", "670.`", "\<\"DamerauLevenshteinDistance\"\>"},
    {"1105", "670.`", "\<\"DampingFactor\"\>"},
    {"1106", "670.`", "\<\"Darker\"\>"},
    {"1107", "670.`", "\<\"Dashing\"\>"},
    {"1108", "670.`", "\<\"DataCompression\"\>"},
    {"1109", "670.`", "\<\"DataDistribution\"\>"},
    {"1110", "670.`", "\<\"DataRange\"\>"},
    {"1111", "670.`", "\<\"DataReversed\"\>"},
    {"1112", "670.`", "\<\"Date\"\>"},
    {"1113", "670.`", "\<\"DateDelimiters\"\>"},
    {"1114", "670.`", "\<\"DateDifference\"\>"},
    {"1115", "670.`", "\<\"DateFunction\"\>"},
    {"1116", "670.`", "\<\"DateList\"\>"},
    {"1117", "670.`", "\<\"DateListLogPlot\"\>"},
    {"1118", "670.`", "\<\"DateListPlot\"\>"},
    {"1119", "670.`", "\<\"DatePattern\"\>"},
    {"1120", "670.`", "\<\"DatePlus\"\>"},
    {"1121", "670.`", "\<\"DateRange\"\>"},
    {"1122", "670.`", "\<\"DateString\"\>"},
    {"1123", "670.`", "\<\"DateTicksFormat\"\>"},
    {"1124", "670.`", "\<\"DaubechiesWavelet\"\>"},
    {"1125", "670.`", "\<\"DavisDistribution\"\>"},
    {"1126", "670.`", "\<\"DawsonF\"\>"},
    {"1127", "670.`", "\<\"DayCount\"\>"},
    {"1128", "670.`", "\<\"DayCountConvention\"\>"},
    {"1129", "670.`", "\<\"DayMatchQ\"\>"},
    {"1130", "670.`", "\<\"DayName\"\>"},
    {"1131", "670.`", "\<\"DayPlus\"\>"},
    {"1132", "670.`", "\<\"DayRange\"\>"},
    {"1133", "670.`", "\<\"DayRound\"\>"},
    {"1134", "670.`", "\<\"DeBruijnGraph\"\>"},
    {"1135", "670.`", "\<\"Debug\"\>"},
    {"1136", "670.`", "\<\"DebugTag\"\>"},
    {"1137", "670.`", "\<\"Decimal\"\>"},
    {"1138", "670.`", "\<\"DeclareKnownSymbols\"\>"},
    {"1139", "670.`", "\<\"DeclarePackage\"\>"},
    {"1140", "670.`", "\<\"Decompose\"\>"},
    {"1141", "670.`", "\<\"DedekindEta\"\>"},
    {"1142", "670.`", "\<\"Default\"\>"},
    {"1143", "670.`", "\<\"DefaultAxesStyle\"\>"},
    {"1144", "670.`", "\<\"DefaultBaseStyle\"\>"},
    {"1145", "670.`", "\<\"DefaultBoxStyle\"\>"},
    {"1146", "670.`", "\<\"DefaultButton\"\>"},
    {"1147", "670.`", "\<\"DefaultColor\"\>"},
    {"1148", "670.`", "\<\"DefaultControlPlacement\"\>"},
    {"1149", "670.`", "\<\"DefaultDuplicateCellStyle\"\>"},
    {"1150", "670.`", "\<\"DefaultDuration\"\>"},
    {"1151", "670.`", "\<\"DefaultElement\"\>"},
    {"1152", "670.`", "\<\"DefaultFaceGridsStyle\"\>"},
    {"1153", "670.`", "\<\"DefaultFieldHintStyle\"\>"},
    {"1154", "670.`", "\<\"DefaultFont\"\>"},
    {"1155", "670.`", "\<\"DefaultFontProperties\"\>"},
    {"1156", "670.`", "\<\"DefaultFormatType\"\>"},
    {"1157", "670.`", "\<\"DefaultFormatTypeForStyle\"\>"},
    {"1158", "670.`", "\<\"DefaultFrameStyle\"\>"},
    {"1159", "670.`", "\<\"DefaultFrameTicksStyle\"\>"},
    {"1160", "670.`", "\<\"DefaultGridLinesStyle\"\>"},
    {"1161", "670.`", "\<\"DefaultInlineFormatType\"\>"},
    {"1162", "670.`", "\<\"DefaultInputFormatType\"\>"},
    {"1163", "670.`", "\<\"DefaultLabelStyle\"\>"},
    {"1164", "670.`", "\<\"DefaultMenuStyle\"\>"},
    {"1165", "670.`", "\<\"DefaultNaturalLanguage\"\>"},
    {"1166", "670.`", "\<\"DefaultNewCellStyle\"\>"},
    {"1167", "670.`", "\<\"DefaultNewInlineCellStyle\"\>"},
    {"1168", "670.`", "\<\"DefaultNotebook\"\>"},
    {"1169", "670.`", "\<\"DefaultOptions\"\>"},
    {"1170", "670.`", "\<\"DefaultOutputFormatType\"\>"},
    {"1171", "670.`", "\<\"DefaultStyle\"\>"},
    {"1172", "670.`", "\<\"DefaultStyleDefinitions\"\>"},
    {"1173", "670.`", "\<\"DefaultTextFormatType\"\>"},
    {"1174", "670.`", "\<\"DefaultTextInlineFormatType\"\>"},
    {"1175", "670.`", "\<\"DefaultTicksStyle\"\>"},
    {"1176", "670.`", "\<\"DefaultTooltipStyle\"\>"},
    {"1177", "670.`", "\<\"DefaultValues\"\>"},
    {"1178", "670.`", "\<\"Defer\"\>"},
    {"1179", "670.`", "\<\"DefineExternal\"\>"},
    {"1180", "670.`", "\<\"DefineInputStreamMethod\"\>"},
    {"1181", "670.`", "\<\"DefineOutputStreamMethod\"\>"},
    {"1182", "670.`", "\<\"Definition\"\>"},
    {"1183", "670.`", "\<\"Degree\"\>"},
    {"1184", "670.`", "\<\"DegreeCentrality\"\>"},
    {"1185", "670.`", "\<\"DegreeGraphDistribution\"\>"},
    {"1186", "670.`", "\<\"DegreeLexicographic\"\>"},
    {"1187", "670.`", "\<\"DegreeReverseLexicographic\"\>"},
    {"1188", "670.`", "\<\"Deinitialization\"\>"},
    {"1189", "670.`", "\<\"Deletable\"\>"},
    {"1190", "670.`", "\<\"Delete\"\>"},
    {"1191", "670.`", "\<\"DeleteBorderComponents\"\>"},
    {"1192", "670.`", "\<\"DeleteCases\"\>"},
    {"1193", "670.`", "\<\"DeleteContents\"\>"},
    {"1194", "670.`", "\<\"DeleteDirectory\"\>"},
    {"1195", "670.`", "\<\"DeleteDuplicates\"\>"},
    {"1196", "670.`", "\<\"DeleteFile\"\>"},
    {"1197", "670.`", "\<\"DeleteSmallComponents\"\>"},
    {"1198", "670.`", "\<\"DeleteWithContents\"\>"},
    {"1199", "670.`", "\<\"DeletionWarning\"\>"},
    {"1200", "670.`", "\<\"Delimiter\"\>"},
    {"1201", "670.`", "\<\"DelimiterFlashTime\"\>"},
    {"1202", "670.`", "\<\"DelimiterMatching\"\>"},
    {"1203", "670.`", "\<\"Delimiters\"\>"},
    {"1204", "670.`", "\<\"Denominator\"\>"},
    {"1205", "670.`", "\<\"DensityGraphics\"\>"},
    {"1206", "670.`", "\<\"DensityHistogram\"\>"},
    {"1207", "670.`", "\<\"DensityPlot\"\>"},
    {"1208", "670.`", "\<\"DependentVariables\"\>"},
    {"1209", "670.`", "\<\"Deploy\"\>"},
    {"1210", "670.`", "\<\"Deployed\"\>"},
    {"1211", "670.`", "\<\"Depth\"\>"},
    {"1212", "670.`", "\<\"DepthFirstScan\"\>"},
    {"1213", "670.`", "\<\"Derivative\"\>"},
    {"1214", "670.`", "\<\"DerivativeFilter\"\>"},
    {"1215", "670.`", "\<\"DescriptorStateSpace\"\>"},
    {"1216", "670.`", "\<\"DesignMatrix\"\>"},
    {"1217", "670.`", "\<\"Det\"\>"},
    {"1218", "670.`", "\<\"DGaussianWavelet\"\>"},
    {"1219", "670.`", "\<\"DiacriticalPositioning\"\>"},
    {"1220", "670.`", "\<\"Diagonal\"\>"},
    {"1221", "670.`", "\<\"DiagonalMatrix\"\>"},
    {"1222", "670.`", "\<\"Dialog\"\>"},
    {"1223", "670.`", "\<\"DialogIndent\"\>"},
    {"1224", "670.`", "\<\"DialogInput\"\>"},
    {"1225", "670.`", "\<\"DialogLevel\"\>"},
    {"1226", "670.`", "\<\"DialogNotebook\"\>"},
    {"1227", "670.`", "\<\"DialogProlog\"\>"},
    {"1228", "670.`", "\<\"DialogReturn\"\>"},
    {"1229", "670.`", "\<\"DialogSymbols\"\>"},
    {"1230", "670.`", "\<\"DiamondMatrix\"\>"},
    {"1231", "670.`", "\<\"DiceDissimilarity\"\>"},
    {"1232", "670.`", "\<\"DictionaryLookup\"\>"},
    {"1233", "670.`", "\<\"DifferenceOrder\"\>"},
    {"1234", "670.`", "\<\"DifferenceRoot\"\>"},
    {"1235", "670.`", "\<\"DifferenceRootReduce\"\>"},
    {"1236", "670.`", "\<\"Differences\"\>"},
    {"1237", "670.`", "\<\"DifferentialRoot\"\>"},
    {"1238", "670.`", "\<\"DifferentialRootReduce\"\>"},
    {"1239", "670.`", "\<\"DifferentiatorFilter\"\>"},
    {"1240", "670.`", "\<\"DigitBlock\"\>"},
    {"1241", "670.`", "\<\"DigitBlockMinimum\"\>"},
    {"1242", "670.`", "\<\"DigitCharacter\"\>"},
    {"1243", "670.`", "\<\"DigitCount\"\>"},
    {"1244", "670.`", "\<\"DigitQ\"\>"},
    {"1245", "670.`", "\<\"DihedralGroup\"\>"},
    {"1246", "670.`", "\<\"Dilation\"\>"},
    {"1247", "670.`", "\<\"Dimensions\"\>"},
    {"1248", "670.`", "\<\"DiracComb\"\>"},
    {"1249", "670.`", "\<\"DiracDelta\"\>"},
    {"1250", "670.`", "\<\"DirectedEdges\"\>"},
    {"1251", "670.`", "\<\"DirectedGraph\"\>"},
    {"1252", "670.`", "\<\"DirectedGraphQ\"\>"},
    {"1253", "670.`", "\<\"DirectedInfinity\"\>"},
    {"1254", "670.`", "\<\"Direction\"\>"},
    {"1255", "670.`", "\<\"Directive\"\>"},
    {"1256", "670.`", "\<\"Directory\"\>"},
    {"1257", "670.`", "\<\"DirectoryName\"\>"},
    {"1258", "670.`", "\<\"DirectoryQ\"\>"},
    {"1259", "670.`", "\<\"DirectoryStack\"\>"},
    {"1260", "670.`", "\<\"DirichletCharacter\"\>"},
    {"1261", "670.`", "\<\"DirichletConvolve\"\>"},
    {"1262", "670.`", "\<\"DirichletDistribution\"\>"},
    {"1263", "670.`", "\<\"DirichletL\"\>"},
    {"1264", "670.`", "\<\"DirichletTransform\"\>"},
    {"1265", "670.`", "\<\"DirichletWindow\"\>"},
    {"1266", "670.`", "\<\"DisableConsolePrintPacket\"\>"},
    {"1267", "670.`", "\<\"DiscreteChirpZTransform\"\>"},
    {"1268", "670.`", "\<\"DiscreteConvolve\"\>"},
    {"1269", "670.`", "\<\"DiscreteDelta\"\>"},
    {"1270", "670.`", "\<\"DiscreteHadamardTransform\"\>"},
    {"1271", "670.`", "\<\"DiscreteIndicator\"\>"},
    {"1272", "670.`", "\<\"DiscreteLQEstimatorGains\"\>"},
    {"1273", "670.`", "\<\"DiscreteLQRegulatorGains\"\>"},
    {"1274", "670.`", "\<\"DiscreteLyapunovSolve\"\>"},
    {"1275", "670.`", "\<\"DiscreteMarkovProcess\"\>"},
    {"1276", "670.`", "\<\"DiscretePlot\"\>"},
    {"1277", "670.`", "\<\"DiscretePlot3D\"\>"},
    {"1278", "670.`", "\<\"DiscreteRiccatiSolve\"\>"},
    {"1279", "670.`", "\<\"DiscreteTimeModelQ\"\>"},
    {"1280", "670.`", "\<\"DiscreteUniformDistribution\"\>"},
    {"1281", "670.`", "\<\"DiscreteVariables\"\>"},
    {"1282", "670.`", "\<\"DiscreteWaveletData\"\>"},
    {"1283", "670.`", "\<\"DiscreteWaveletPacketTransform\"\>"},
    {"1284", "670.`", "\<\"DiscreteWaveletTransform\"\>"},
    {"1285", "670.`", "\<\"Discriminant\"\>"},
    {"1286", "670.`", "\<\"Disjunction\"\>"},
    {"1287", "670.`", "\<\"Disk\"\>"},
    {"1288", "670.`", "\<\"DiskBox\"\>"},
    {"1289", "670.`", "\<\"DiskMatrix\"\>"},
    {"1290", "670.`", "\<\"Dispatch\"\>"},
    {"1291", "670.`", "\<\"DispersionEstimatorFunction\"\>"},
    {"1292", "670.`", "\<\"Display\"\>"},
    {"1293", "670.`", "\<\"DisplayAllSteps\"\>"},
    {"1294", "670.`", "\<\"DisplayEndPacket\"\>"},
    {"1295", "670.`", "\<\"DisplayFlushImagePacket\"\>"},
    {"1296", "670.`", "\<\"DisplayForm\"\>"},
    {"1297", "670.`", "\<\"DisplayFunction\"\>"},
    {"1298", "670.`", "\<\"DisplayPacket\"\>"},
    {"1299", "670.`", "\<\"DisplayRules\"\>"},
    {"1300", "670.`", "\<\"DisplaySetSizePacket\"\>"},
    {"1301", "670.`", "\<\"DisplayString\"\>"},
    {"1302", "670.`", "\<\"DisplayTemporary\"\>"},
    {"1303", "670.`", "\<\"DisplayWith\"\>"},
    {"1304", "670.`", "\<\"DisplayWithRef\"\>"},
    {"1305", "670.`", "\<\"DisplayWithVariable\"\>"},
    {"1306", "670.`", "\<\"DistanceFunction\"\>"},
    {"1307", "670.`", "\<\"DistanceTransform\"\>"},
    {"1308", "670.`", "\<\"Distribute\"\>"},
    {"1309", "670.`", "\<\"DistributedContexts\"\>"},
    {"1310", "670.`", "\<\"DistributeDefinitions\"\>"},
    {"1311", "670.`", "\<\"DistributionChart\"\>"},
    {"1312", "670.`", "\<\"DistributionDomain\"\>"},
    {"1313", "670.`", "\<\"DistributionFitTest\"\>"},
    {"1314", "670.`", "\<\"DistributionParameterAssumptions\"\>"},
    {"1315", "670.`", "\<\"DistributionParameterQ\"\>"},
    {"1316", "670.`", "\<\"Dithering\"\>"},
    {"1317", "670.`", "\<\"Div\"\>"},
    {"1318", "670.`", "\<\"Dividers\"\>"},
    {"1319", "670.`", "\<\"Divisible\"\>"},
    {"1320", "670.`", "\<\"Divisors\"\>"},
    {"1321", "670.`", "\<\"DivisorSigma\"\>"},
    {"1322", "670.`", "\<\"DivisorSum\"\>"},
    {"1323", "670.`", "\<\"DMSList\"\>"},
    {"1324", "670.`", "\<\"DMSString\"\>"},
    {"1325", "670.`", "\<\"Do\"\>"},
    {"1326", "670.`", "\<\"DockedCells\"\>"},
    {"1327", "670.`", "\<\"DocumentNotebook\"\>"},
    {"1328", "670.`", "\<\"DominantColors\"\>"},
    {"1329", "670.`", "\<\"DOSTextFormat\"\>"},
    {"1330", "670.`", "\<\"DoubleBracketingBar\"\>"},
    {"1331", "670.`", "\<\"DoubleContourIntegral\"\>"},
    {"1332", "670.`", "\<\"DoublyInfinite\"\>"},
    {"1333", "670.`", "\<\"Down\"\>"},
    {"1334", "670.`", "\<\"Downsample\"\>"},
    {"1335", "670.`", "\<\"DownValues\"\>"},
    {"1336", "670.`", "\<\"DragAndDrop\"\>"},
    {"1337", "670.`", "\<\"DrawEdges\"\>"},
    {"1338", "670.`", "\<\"DrawFrontFaces\"\>"},
    {"1339", "670.`", "\<\"DrawHighlighted\"\>"},
    {"1340", "670.`", "\<\"Drop\"\>"},
    {"1341", "670.`", "\<\"DSolve\"\>"},
    {"1342", "670.`", "\<\"DualLinearProgramming\"\>"},
    {"1343", "670.`", "\<\"DualSystemsModel\"\>"},
    {"1344", "670.`", "\<\"DumpGet\"\>"},
    {"1345", "670.`", "\<\"DumpSave\"\>"},
    {"1346", "670.`", "\<\"DuplicateFreeQ\"\>"},
    {"1347", "670.`", "\<\"Dynamic\"\>"},
    {"1348", "670.`", "\<\"DynamicBox\"\>"},
    {"1349", "670.`", "\<\"DynamicBoxOptions\"\>"},
    {"1350", "670.`", "\<\"DynamicEvaluationTimeout\"\>"},
    {"1351", "670.`", "\<\"DynamicLocation\"\>"},
    {"1352", "670.`", "\<\"DynamicModule\"\>"},
    {"1353", "670.`", "\<\"DynamicModuleBox\"\>"},
    {"1354", "670.`", "\<\"DynamicModuleBoxOptions\"\>"},
    {"1355", "670.`", "\<\"DynamicModuleParent\"\>"},
    {"1356", "670.`", "\<\"DynamicModuleValues\"\>"},
    {"1357", "670.`", "\<\"DynamicName\"\>"},
    {"1358", "670.`", "\<\"DynamicNamespace\"\>"},
    {"1359", "670.`", "\<\"DynamicReference\"\>"},
    {"1360", "670.`", "\<\"DynamicSetting\"\>"},
    {"1361", "670.`", "\<\"DynamicUpdating\"\>"},
    {"1362", "670.`", "\<\"DynamicWrapper\"\>"},
    {"1363", "670.`", "\<\"DynamicWrapperBox\"\>"},
    {"1364", "670.`", "\<\"DynamicWrapperBoxOptions\"\>"},
    {"1365", "670.`", "\<\"E\"\>"},
    {"1366", "670.`", "\<\"EccentricityCentrality\"\>"},
    {"1367", "670.`", "\<\"EdgeAdd\"\>"},
    {"1368", "670.`", "\<\"EdgeBetweennessCentrality\"\>"},
    {"1369", "670.`", "\<\"EdgeCapacity\"\>"},
    {"1370", "670.`", "\<\"EdgeCapForm\"\>"},
    {"1371", "670.`", "\<\"EdgeColor\"\>"},
    {"1372", "670.`", "\<\"EdgeConnectivity\"\>"},
    {"1373", "670.`", "\<\"EdgeCost\"\>"},
    {"1374", "670.`", "\<\"EdgeCount\"\>"},
    {"1375", "670.`", "\<\"EdgeCoverQ\"\>"},
    {"1376", "670.`", "\<\"EdgeDashing\"\>"},
    {"1377", "670.`", "\<\"EdgeDelete\"\>"},
    {"1378", "670.`", "\<\"EdgeDetect\"\>"},
    {"1379", "670.`", "\<\"EdgeForm\"\>"},
    {"1380", "670.`", "\<\"EdgeIndex\"\>"},
    {"1381", "670.`", "\<\"EdgeJoinForm\"\>"},
    {"1382", "670.`", "\<\"EdgeLabeling\"\>"},
    {"1383", "670.`", "\<\"EdgeLabels\"\>"},
    {"1384", "670.`", "\<\"EdgeLabelStyle\"\>"},
    {"1385", "670.`", "\<\"EdgeList\"\>"},
    {"1386", "670.`", "\<\"EdgeOpacity\"\>"},
    {"1387", "670.`", "\<\"EdgeQ\"\>"},
    {"1388", "670.`", "\<\"EdgeRenderingFunction\"\>"},
    {"1389", "670.`", "\<\"EdgeRules\"\>"},
    {"1390", "670.`", "\<\"EdgeShapeFunction\"\>"},
    {"1391", "670.`", "\<\"EdgeStyle\"\>"},
    {"1392", "670.`", "\<\"EdgeThickness\"\>"},
    {"1393", "670.`", "\<\"EdgeWeight\"\>"},
    {"1394", "670.`", "\<\"Editable\"\>"},
    {"1395", "670.`", "\<\"EditButtonSettings\"\>"},
    {"1396", "670.`", "\<\"EditCellTagsSettings\"\>"},
    {"1397", "670.`", "\<\"EditDistance\"\>"},
    {"1398", "670.`", "\<\"EffectiveInterest\"\>"},
    {"1399", "670.`", "\<\"Eigensystem\"\>"},
    {"1400", "670.`", "\<\"Eigenvalues\"\>"},
    {"1401", "670.`", "\<\"EigenvectorCentrality\"\>"},
    {"1402", "670.`", "\<\"Eigenvectors\"\>"},
    {"1403", "670.`", "\<\"ElementData\"\>"},
    {"1404", "670.`", "\<\"Eliminate\"\>"},
    {"1405", "670.`", "\<\"EliminationOrder\"\>"},
    {"1406", "670.`", "\<\"EllipticE\"\>"},
    {"1407", "670.`", "\<\"EllipticExp\"\>"},
    {"1408", "670.`", "\<\"EllipticExpPrime\"\>"},
    {"1409", "670.`", "\<\"EllipticF\"\>"},
    {"1410", "670.`", "\<\"EllipticFilterModel\"\>"},
    {"1411", "670.`", "\<\"EllipticK\"\>"},
    {"1412", "670.`", "\<\"EllipticLog\"\>"},
    {"1413", "670.`", "\<\"EllipticNomeQ\"\>"},
    {"1414", "670.`", "\<\"EllipticPi\"\>"},
    {"1415", "670.`", "\<\"EllipticReducedHalfPeriods\"\>"},
    {"1416", "670.`", "\<\"EllipticTheta\"\>"},
    {"1417", "670.`", "\<\"EllipticThetaPrime\"\>"},
    {"1418", "670.`", "\<\"EmitSound\"\>"},
    {"1419", "670.`", "\<\"EmphasizeSyntaxErrors\"\>"},
    {"1420", "670.`", "\<\"EmpiricalDistribution\"\>"},
    {"1421", "670.`", "\<\"Empty\"\>"},
    {"1422", "670.`", "\<\"EmptyGraphQ\"\>"},
    {"1423", "670.`", "\<\"EnableConsolePrintPacket\"\>"},
    {"1424", "670.`", "\<\"Enabled\"\>"},
    {"1425", "670.`", "\<\"Encode\"\>"},
    {"1426", "670.`", "\<\"End\"\>"},
    {"1427", "670.`", "\<\"EndAdd\"\>"},
    {"1428", "670.`", "\<\"EndDialogPacket\"\>"},
    {"1429", "670.`", "\<\"EndFrontEndInteractionPacket\"\>"},
    {"1430", "670.`", "\<\"EndOfFile\"\>"},
    {"1431", "670.`", "\<\"EndOfLine\"\>"},
    {"1432", "670.`", "\<\"EndOfString\"\>"},
    {"1433", "670.`", "\<\"EndPackage\"\>"},
    {"1434", "670.`", "\<\"EngineeringForm\"\>"},
    {"1435", "670.`", "\<\"Enter\"\>"},
    {"1436", "670.`", "\<\"EnterExpressionPacket\"\>"},
    {"1437", "670.`", "\<\"EnterTextPacket\"\>"},
    {"1438", "670.`", "\<\"Entropy\"\>"},
    {"1439", "670.`", "\<\"EntropyFilter\"\>"},
    {"1440", "670.`", "\<\"Environment\"\>"},
    {"1441", "670.`", "\<\"Epilog\"\>"},
    {"1442", "670.`", "\<\"EqualColumns\"\>"},
    {"1443", "670.`", "\<\"EqualRows\"\>"},
    {"1444", "670.`", "\<\"EquatedTo\"\>"},
    {"1445", "670.`", "\<\"EquirippleFilterKernel\"\>"},
    {"1446", "670.`", "\<\"Erf\"\>"},
    {"1447", "670.`", "\<\"Erfc\"\>"},
    {"1448", "670.`", "\<\"Erfi\"\>"},
    {"1449", "670.`", "\<\"ErlangB\"\>"},
    {"1450", "670.`", "\<\"ErlangC\"\>"},
    {"1451", "670.`", "\<\"ErlangDistribution\"\>"},
    {"1452", "670.`", "\<\"Erosion\"\>"},
    {"1453", "670.`", "\<\"ErrorBox\"\>"},
    {"1454", "670.`", "\<\"ErrorBoxOptions\"\>"},
    {"1455", "670.`", "\<\"ErrorNorm\"\>"},
    {"1456", "670.`", "\<\"ErrorPacket\"\>"},
    {"1457", "670.`", "\<\"ErrorsDialogSettings\"\>"},
    {"1458", "670.`", "\<\"EstimatedDistribution\"\>"},
    {"1459", "670.`", "\<\"EstimatedProcess\"\>"},
    {"1460", "670.`", "\<\"EstimatorGains\"\>"},
    {"1461", "670.`", "\<\"EstimatorRegulator\"\>"},
    {"1462", "670.`", "\<\"EuclideanDistance\"\>"},
    {"1463", "670.`", "\<\"EulerE\"\>"},
    {"1464", "670.`", "\<\"EulerGamma\"\>"},
    {"1465", "670.`", "\<\"EulerianGraphQ\"\>"},
    {"1466", "670.`", "\<\"EulerPhi\"\>"},
    {"1467", "670.`", "\<\"Evaluatable\"\>"},
    {"1468", "670.`", "\<\"Evaluate\"\>"},
    {"1469", "670.`", "\<\"Evaluated\"\>"},
    {"1470", "670.`", "\<\"EvaluatePacket\"\>"},
    {"1471", "670.`", "\<\"EvaluationCell\"\>"},
    {"1472", "670.`", "\<\"EvaluationCompletionAction\"\>"},
    {"1473", "670.`", "\<\"EvaluationElements\"\>"},
    {"1474", "670.`", "\<\"EvaluationMode\"\>"},
    {"1475", "670.`", "\<\"EvaluationMonitor\"\>"},
    {"1476", "670.`", "\<\"EvaluationNotebook\"\>"},
    {"1477", "670.`", "\<\"EvaluationObject\"\>"},
    {"1478", "670.`", "\<\"EvaluationOrder\"\>"},
    {"1479", "670.`", "\<\"Evaluator\"\>"},
    {"1480", "670.`", "\<\"EvaluatorNames\"\>"},
    {"1481", "670.`", "\<\"EvenQ\"\>"},
    {"1482", "670.`", "\<\"EventData\"\>"},
    {"1483", "670.`", "\<\"EventEvaluator\"\>"},
    {"1484", "670.`", "\<\"EventHandler\"\>"},
    {"1485", "670.`", "\<\"EventHandlerTag\"\>"},
    {"1486", "670.`", "\<\"EventLabels\"\>"},
    {"1487", "670.`", "\<\"ExactBlackmanWindow\"\>"},
    {"1488", "670.`", "\<\"ExactNumberQ\"\>"},
    {"1489", "670.`", "\<\"ExactRootIsolation\"\>"},
    {"1490", "670.`", "\<\"ExampleData\"\>"},
    {"1491", "670.`", "\<\"Except\"\>"},
    {"1492", "670.`", "\<\"ExcludedForms\"\>"},
    {"1493", "670.`", "\<\"ExcludePods\"\>"},
    {"1494", "670.`", "\<\"Exclusions\"\>"},
    {"1495", "670.`", "\<\"ExclusionsStyle\"\>"},
    {"1496", "670.`", "\<\"Exit\"\>"},
    {"1497", "670.`", "\<\"ExitDialog\"\>"},
    {"1498", "670.`", "\<\"Exp\"\>"},
    {"1499", "670.`", "\<\"Expand\"\>"},
    {"1500", "670.`", "\<\"ExpandAll\"\>"},
    {"1501", "670.`", "\<\"ExpandDenominator\"\>"},
    {"1502", "670.`", "\<\"ExpandFileName\"\>"},
    {"1503", "670.`", "\<\"ExpandNumerator\"\>"},
    {"1504", "670.`", "\<\"Expectation\"\>"},
    {"1505", "670.`", "\<\"ExpectedValue\"\>"},
    {"1506", "670.`", "\<\"ExpGammaDistribution\"\>"},
    {"1507", "670.`", "\<\"ExpIntegralE\"\>"},
    {"1508", "670.`", "\<\"ExpIntegralEi\"\>"},
    {"1509", "670.`", "\<\"Exponent\"\>"},
    {"1510", "670.`", "\<\"ExponentFunction\"\>"},
    {"1511", "670.`", "\<\"ExponentialDistribution\"\>"},
    {"1512", "670.`", "\<\"ExponentialFamily\"\>"},
    {"1513", "670.`", "\<\"ExponentialGeneratingFunction\"\>"},
    {"1514", "670.`", "\<\"ExponentialMovingAverage\"\>"},
    {"1515", "670.`", "\<\"ExponentialPowerDistribution\"\>"},
    {"1516", "670.`", "\<\"ExponentPosition\"\>"},
    {"1517", "670.`", "\<\"ExponentStep\"\>"},
    {"1518", "670.`", "\<\"Export\"\>"},
    {"1519", "670.`", "\<\"ExportAutoReplacements\"\>"},
    {"1520", "670.`", "\<\"ExportPacket\"\>"},
    {"1521", "670.`", "\<\"ExportString\"\>"},
    {"1522", "670.`", "\<\"Expression\"\>"},
    {"1523", "670.`", "\<\"ExpressionCell\"\>"},
    {"1524", "670.`", "\<\"ExpressionPacket\"\>"},
    {"1525", "670.`", "\<\"ExpToTrig\"\>"},
    {"1526", "670.`", "\<\"ExtendedGCD\"\>"},
    {"1527", "670.`", "\<\"Extension\"\>"},
    {"1528", "670.`", "\<\"ExtentElementFunction\"\>"},
    {"1529", "670.`", "\<\"ExtentMarkers\"\>"},
    {"1530", "670.`", "\<\"ExtentSize\"\>"},
    {"1531", "670.`", "\<\"ExternalCall\"\>"},
    {"1532", "670.`", "\<\"ExternalDataCharacterEncoding\"\>"},
    {"1533", "670.`", "\<\"Extract\"\>"},
    {"1534", "670.`", "\<\"ExtractArchive\"\>"},
    {"1535", "670.`", "\<\"ExtremeValueDistribution\"\>"},
    {"1536", "670.`", "\<\"FaceForm\"\>"},
    {"1537", "670.`", "\<\"FaceGrids\"\>"},
    {"1538", "670.`", "\<\"FaceGridsStyle\"\>"},
    {"1539", "670.`", "\<\"Factor\"\>"},
    {"1540", "670.`", "\<\"FactorComplete\"\>"},
    {"1541", "670.`", "\<\"FactorialMoment\"\>"},
    {"1542", "670.`", "\<\"FactorialMomentGeneratingFunction\"\>"},
    {"1543", "670.`", "\<\"FactorialPower\"\>"},
    {"1544", "670.`", "\<\"FactorInteger\"\>"},
    {"1545", "670.`", "\<\"FactorList\"\>"},
    {"1546", "670.`", "\<\"FactorSquareFree\"\>"},
    {"1547", "670.`", "\<\"FactorSquareFreeList\"\>"},
    {"1548", "670.`", "\<\"FactorTerms\"\>"},
    {"1549", "670.`", "\<\"FactorTermsList\"\>"},
    {"1550", "670.`", "\<\"Fail\"\>"},
    {"1551", "670.`", "\<\"FailureDistribution\"\>"},
    {"1552", "670.`", "\<\"False\"\>"},
    {"1553", "670.`", "\<\"FARIMAProcess\"\>"},
    {"1554", "670.`", "\<\"FEDisableConsolePrintPacket\"\>"},
    {"1555", "670.`", "\<\"FeedbackSector\"\>"},
    {"1556", "670.`", "\<\"FeedbackSectorStyle\"\>"},
    {"1557", "670.`", "\<\"FeedbackType\"\>"},
    {"1558", "670.`", "\<\"FEEnableConsolePrintPacket\"\>"},
    {"1559", "670.`", "\<\"Fibonacci\"\>"},
    {"1560", "670.`", "\<\"FieldHint\"\>"},
    {"1561", "670.`", "\<\"FieldHintStyle\"\>"},
    {"1562", "670.`", "\<\"FieldMasked\"\>"},
    {"1563", "670.`", "\<\"FieldSize\"\>"},
    {"1564", "670.`", "\<\"File\"\>"},
    {"1565", "670.`", "\<\"FileBaseName\"\>"},
    {"1566", "670.`", "\<\"FileByteCount\"\>"},
    {"1567", "670.`", "\<\"FileDate\"\>"},
    {"1568", "670.`", "\<\"FileExistsQ\"\>"},
    {"1569", "670.`", "\<\"FileExtension\"\>"},
    {"1570", "670.`", "\<\"FileFormat\"\>"},
    {"1571", "670.`", "\<\"FileHash\"\>"},
    {"1572", "670.`", "\<\"FileInformation\"\>"},
    {"1573", "670.`", "\<\"FileName\"\>"},
    {"1574", "670.`", "\<\"FileNameDepth\"\>"},
    {"1575", "670.`", "\<\"FileNameDialogSettings\"\>"},
    {"1576", "670.`", "\<\"FileNameDrop\"\>"},
    {"1577", "670.`", "\<\"FileNameJoin\"\>"},
    {"1578", "670.`", "\<\"FileNames\"\>"},
    {"1579", "670.`", "\<\"FileNameSetter\"\>"},
    {"1580", "670.`", "\<\"FileNameSplit\"\>"},
    {"1581", "670.`", "\<\"FileNameTake\"\>"},
    {"1582", "670.`", "\<\"FilePrint\"\>"},
    {"1583", "670.`", "\<\"FileType\"\>"},
    {"1584", "670.`", "\<\"FilledCurve\"\>"},
    {"1585", "670.`", "\<\"FilledCurveBox\"\>"},
    {"1586", "670.`", "\<\"Filling\"\>"},
    {"1587", "670.`", "\<\"FillingStyle\"\>"},
    {"1588", "670.`", "\<\"FillingTransform\"\>"},
    {"1589", "670.`", "\<\"FilterRules\"\>"},
    {"1590", "670.`", "\<\"FinancialBond\"\>"},
    {"1591", "670.`", "\<\"FinancialData\"\>"},
    {"1592", "670.`", "\<\"FinancialDerivative\"\>"},
    {"1593", "670.`", "\<\"FinancialIndicator\"\>"},
    {"1594", "670.`", "\<\"Find\"\>"},
    {"1595", "670.`", "\<\"FindArgMax\"\>"},
    {"1596", "670.`", "\<\"FindArgMin\"\>"},
    {"1597", "670.`", "\<\"FindClique\"\>"},
    {"1598", "670.`", "\<\"FindClusters\"\>"},
    {"1599", "670.`", "\<\"FindCurvePath\"\>"},
    {"1600", "670.`", "\<\"FindDistributionParameters\"\>"},
    {"1601", "670.`", "\<\"FindDivisions\"\>"},
    {"1602", "670.`", "\<\"FindEdgeCover\"\>"},
    {"1603", "670.`", "\<\"FindEdgeCut\"\>"},
    {"1604", "670.`", "\<\"FindEulerianCycle\"\>"},
    {"1605", "670.`", "\<\"FindFaces\"\>"},
    {"1606", "670.`", "\<\"FindFile\"\>"},
    {"1607", "670.`", "\<\"FindFit\"\>"},
    {"1608", "670.`", "\<\"FindGeneratingFunction\"\>"},
    {"1609", "670.`", "\<\"FindGeoLocation\"\>"},
    {"1610", "670.`", "\<\"FindGeometricTransform\"\>"},
    {"1611", "670.`", "\<\"FindGraphCommunities\"\>"},
    {"1612", "670.`", "\<\"FindGraphIsomorphism\"\>"},
    {"1613", "670.`", "\<\"FindGraphPartition\"\>"},
    {"1614", "670.`", "\<\"FindHamiltonianCycle\"\>"},
    {"1615", "670.`", "\<\"FindIndependentEdgeSet\"\>"},
    {"1616", "670.`", "\<\"FindIndependentVertexSet\"\>"},
    {"1617", "670.`", "\<\"FindInstance\"\>"},
    {"1618", "670.`", "\<\"FindIntegerNullVector\"\>"},
    {"1619", "670.`", "\<\"FindKClan\"\>"},
    {"1620", "670.`", "\<\"FindKClique\"\>"},
    {"1621", "670.`", "\<\"FindKClub\"\>"},
    {"1622", "670.`", "\<\"FindKPlex\"\>"},
    {"1623", "670.`", "\<\"FindLibrary\"\>"},
    {"1624", "670.`", "\<\"FindLinearRecurrence\"\>"},
    {"1625", "670.`", "\<\"FindList\"\>"},
    {"1626", "670.`", "\<\"FindMaximum\"\>"},
    {"1627", "670.`", "\<\"FindMaximumFlow\"\>"},
    {"1628", "670.`", "\<\"FindMaxValue\"\>"},
    {"1629", "670.`", "\<\"FindMinimum\"\>"},
    {"1630", "670.`", "\<\"FindMinimumCostFlow\"\>"},
    {"1631", "670.`", "\<\"FindMinimumCut\"\>"},
    {"1632", "670.`", "\<\"FindMinValue\"\>"},
    {"1633", "670.`", "\<\"FindPermutation\"\>"},
    {"1634", "670.`", "\<\"FindPostmanTour\"\>"},
    {"1635", "670.`", "\<\"FindProcessParameters\"\>"},
    {"1636", "670.`", "\<\"FindRoot\"\>"},
    {"1637", "670.`", "\<\"FindSequenceFunction\"\>"},
    {"1638", "670.`", "\<\"FindSettings\"\>"},
    {"1639", "670.`", "\<\"FindShortestPath\"\>"},
    {"1640", "670.`", "\<\"FindShortestTour\"\>"},
    {"1641", "670.`", "\<\"FindThreshold\"\>"},
    {"1642", "670.`", "\<\"FindVertexCover\"\>"},
    {"1643", "670.`", "\<\"FindVertexCut\"\>"},
    {"1644", "670.`", "\<\"Fine\"\>"},
    {"1645", "670.`", "\<\"FinishDynamic\"\>"},
    {"1646", "670.`", "\<\"FiniteAbelianGroupCount\"\>"},
    {"1647", "670.`", "\<\"FiniteGroupCount\"\>"},
    {"1648", "670.`", "\<\"FiniteGroupData\"\>"},
    {"1649", "670.`", "\<\"First\"\>"},
    {"1650", "670.`", "\<\"FirstPassageTimeDistribution\"\>"},
    {"1651", "670.`", "\<\"FischerGroupFi22\"\>"},
    {"1652", "670.`", "\<\"FischerGroupFi23\"\>"},
    {"1653", "670.`", "\<\"FischerGroupFi24Prime\"\>"},
    {"1654", "670.`", "\<\"FisherHypergeometricDistribution\"\>"},
    {"1655", "670.`", "\<\"FisherRatioTest\"\>"},
    {"1656", "670.`", "\<\"FisherZDistribution\"\>"},
    {"1657", "670.`", "\<\"Fit\"\>"},
    {"1658", "670.`", "\<\"FitAll\"\>"},
    {"1659", "670.`", "\<\"FittedModel\"\>"},
    {"1660", "670.`", "\<\"FixedPoint\"\>"},
    {"1661", "670.`", "\<\"FixedPointList\"\>"},
    {"1662", "670.`", "\<\"FlashSelection\"\>"},
    {"1663", "670.`", "\<\"Flat\"\>"},
    {"1664", "670.`", "\<\"Flatten\"\>"},
    {"1665", "670.`", "\<\"FlattenAt\"\>"},
    {"1666", "670.`", "\<\"FlatTopWindow\"\>"},
    {"1667", "670.`", "\<\"FlipView\"\>"},
    {"1668", "670.`", "\<\"Floor\"\>"},
    {"1669", "670.`", "\<\"FlushPrintOutputPacket\"\>"},
    {"1670", "670.`", "\<\"Fold\"\>"},
    {"1671", "670.`", "\<\"FoldList\"\>"},
    {"1672", "670.`", "\<\"Font\"\>"},
    {"1673", "670.`", "\<\"FontColor\"\>"},
    {"1674", "670.`", "\<\"FontFamily\"\>"},
    {"1675", "670.`", "\<\"FontForm\"\>"},
    {"1676", "670.`", "\<\"FontName\"\>"},
    {"1677", "670.`", "\<\"FontOpacity\"\>"},
    {"1678", "670.`", "\<\"FontPostScriptName\"\>"},
    {"1679", "670.`", "\<\"FontProperties\"\>"},
    {"1680", "670.`", "\<\"FontReencoding\"\>"},
    {"1681", "670.`", "\<\"FontSize\"\>"},
    {"1682", "670.`", "\<\"FontSlant\"\>"},
    {"1683", "670.`", "\<\"FontSubstitutions\"\>"},
    {"1684", "670.`", "\<\"FontTracking\"\>"},
    {"1685", "670.`", "\<\"FontVariations\"\>"},
    {"1686", "670.`", "\<\"FontWeight\"\>"},
    {"1687", "670.`", "\<\"For\"\>"},
    {"1688", "670.`", "\<\"Format\"\>"},
    {"1689", "670.`", "\<\"FormatRules\"\>"},
    {"1690", "670.`", "\<\"FormatType\"\>"},
    {"1691", "670.`", "\<\"FormatTypeAutoConvert\"\>"},
    {"1692", "670.`", "\<\"FormatValues\"\>"},
    {"1693", "670.`", "\<\"FormBox\"\>"},
    {"1694", "670.`", "\<\"FormBoxOptions\"\>"},
    {"1695", "670.`", "\<\"FortranForm\"\>"},
    {"1696", "670.`", "\<\"Forward\"\>"},
    {"1697", "670.`", "\<\"ForwardBackward\"\>"},
    {"1698", "670.`", "\<\"Fourier\"\>"},
    {"1699", "670.`", "\<\"FourierCoefficient\"\>"},
    {"1700", "670.`", "\<\"FourierCosCoefficient\"\>"},
    {"1701", "670.`", "\<\"FourierCosSeries\"\>"},
    {"1702", "670.`", "\<\"FourierCosTransform\"\>"},
    {"1703", "670.`", "\<\"FourierDCT\"\>"},
    {"1704", "670.`", "\<\"FourierDCTFilter\"\>"},
    {"1705", "670.`", "\<\"FourierDCTMatrix\"\>"},
    {"1706", "670.`", "\<\"FourierDST\"\>"},
    {"1707", "670.`", "\<\"FourierDSTMatrix\"\>"},
    {"1708", "670.`", "\<\"FourierMatrix\"\>"},
    {"1709", "670.`", "\<\"FourierParameters\"\>"},
    {"1710", "670.`", "\<\"FourierSequenceTransform\"\>"},
    {"1711", "670.`", "\<\"FourierSeries\"\>"},
    {"1712", "670.`", "\<\"FourierSinCoefficient\"\>"},
    {"1713", "670.`", "\<\"FourierSinSeries\"\>"},
    {"1714", "670.`", "\<\"FourierSinTransform\"\>"},
    {"1715", "670.`", "\<\"FourierTransform\"\>"},
    {"1716", "670.`", "\<\"FourierTrigSeries\"\>"},
    {"1717", "670.`", "\<\"FractionalBrownianMotionProcess\"\>"},
    {"1718", "670.`", "\<\"FractionalPart\"\>"},
    {"1719", "670.`", "\<\"FractionBox\"\>"},
    {"1720", "670.`", "\<\"FractionBoxOptions\"\>"},
    {"1721", "670.`", "\<\"FractionLine\"\>"},
    {"1722", "670.`", "\<\"Frame\"\>"},
    {"1723", "670.`", "\<\"FrameBox\"\>"},
    {"1724", "670.`", "\<\"FrameBoxOptions\"\>"},
    {"1725", "670.`", "\<\"Framed\"\>"},
    {"1726", "670.`", "\<\"FrameInset\"\>"},
    {"1727", "670.`", "\<\"FrameLabel\"\>"},
    {"1728", "670.`", "\<\"Frameless\"\>"},
    {"1729", "670.`", "\<\"FrameMargins\"\>"},
    {"1730", "670.`", "\<\"FrameStyle\"\>"},
    {"1731", "670.`", "\<\"FrameTicks\"\>"},
    {"1732", "670.`", "\<\"FrameTicksStyle\"\>"},
    {"1733", "670.`", "\<\"FRatioDistribution\"\>"},
    {"1734", "670.`", "\<\"FrechetDistribution\"\>"},
    {"1735", "670.`", "\<\"FreeQ\"\>"},
    {"1736", "670.`", "\<\"FrequencySamplingFilterKernel\"\>"},
    {"1737", "670.`", "\<\"FresnelC\"\>"},
    {"1738", "670.`", "\<\"FresnelS\"\>"},
    {"1739", "670.`", "\<\"Friday\"\>"},
    {"1740", "670.`", "\<\"FrobeniusNumber\"\>"},
    {"1741", "670.`", "\<\"FrobeniusSolve\"\>"},
    {"1742", "670.`", "\<\"FromCharacterCode\"\>"},
    {"1743", "670.`", "\<\"FromCoefficientRules\"\>"},
    {"1744", "670.`", "\<\"FromContinuedFraction\"\>"},
    {"1745", "670.`", "\<\"FromDate\"\>"},
    {"1746", "670.`", "\<\"FromDigits\"\>"},
    {"1747", "670.`", "\<\"FromDMS\"\>"},
    {"1748", "670.`", "\<\"Front\"\>"},
    {"1749", "670.`", "\<\"FrontEndDynamicExpression\"\>"},
    {"1750", "670.`", "\<\"FrontEndEventActions\"\>"},
    {"1751", "670.`", "\<\"FrontEndExecute\"\>"},
    {"1752", "670.`", "\<\"FrontEndObject\"\>"},
    {"1753", "670.`", "\<\"FrontEndResource\"\>"},
    {"1754", "670.`", "\<\"FrontEndResourceString\"\>"},
    {"1755", "670.`", "\<\"FrontEndStackSize\"\>"},
    {"1756", "670.`", "\<\"FrontEndToken\"\>"},
    {"1757", "670.`", "\<\"FrontEndTokenExecute\"\>"},
    {"1758", "670.`", "\<\"FrontEndValueCache\"\>"},
    {"1759", "670.`", "\<\"FrontEndVersion\"\>"},
    {"1760", "670.`", "\<\"FrontFaceColor\"\>"},
    {"1761", "670.`", "\<\"FrontFaceOpacity\"\>"},
    {"1762", "670.`", "\<\"Full\"\>"},
    {"1763", "670.`", "\<\"FullAxes\"\>"},
    {"1764", "670.`", "\<\"FullDefinition\"\>"},
    {"1765", "670.`", "\<\"FullForm\"\>"},
    {"1766", "670.`", "\<\"FullGraphics\"\>"},
    {"1767", "670.`", "\<\"FullOptions\"\>"},
    {"1768", "670.`", "\<\"FullSimplify\"\>"},
    {"1769", "670.`", "\<\"FunctionExpand\"\>"},
    {"1770", "670.`", "\<\"FunctionInterpolation\"\>"},
    {"1771", "670.`", "\<\"FunctionSpace\"\>"},
    {"1772", "670.`", "\<\"FussellVeselyImportance\"\>"},
    {"1773", "670.`", "\<\"GaborFilter\"\>"},
    {"1774", "670.`", "\<\"GaborMatrix\"\>"},
    {"1775", "670.`", "\<\"GaborWavelet\"\>"},
    {"1776", "670.`", "\<\"GainMargins\"\>"},
    {"1777", "670.`", "\<\"GainPhaseMargins\"\>"},
    {"1778", "670.`", "\<\"Gamma\"\>"},
    {"1779", "670.`", "\<\"GammaDistribution\"\>"},
    {"1780", "670.`", "\<\"GammaRegularized\"\>"},
    {"1781", "670.`", "\<\"GapPenalty\"\>"},
    {"1782", "670.`", "\<\"Gather\"\>"},
    {"1783", "670.`", "\<\"GatherBy\"\>"},
    {"1784", "670.`", "\<\"GaugeFaceElementFunction\"\>"},
    {"1785", "670.`", "\<\"GaugeFaceStyle\"\>"},
    {"1786", "670.`", "\<\"GaugeFrameElementFunction\"\>"},
    {"1787", "670.`", "\<\"GaugeFrameSize\"\>"},
    {"1788", "670.`", "\<\"GaugeFrameStyle\"\>"},
    {"1789", "670.`", "\<\"GaugeLabels\"\>"},
    {"1790", "670.`", "\<\"GaugeMarkers\"\>"},
    {"1791", "670.`", "\<\"GaugeStyle\"\>"},
    {"1792", "670.`", "\<\"GaussianFilter\"\>"},
    {"1793", "670.`", "\<\"GaussianIntegers\"\>"},
    {"1794", "670.`", "\<\"GaussianMatrix\"\>"},
    {"1795", "670.`", "\<\"GaussianWindow\"\>"},
    {"1796", "670.`", "\<\"GCD\"\>"},
    {"1797", "670.`", "\<\"GegenbauerC\"\>"},
    {"1798", "670.`", "\<\"General\"\>"},
    {"1799", "670.`", "\<\"GeneralizedLinearModelFit\"\>"},
    {"1800", "670.`", "\<\"GenerateConditions\"\>"},
    {"1801", "670.`", "\<\"GeneratedCell\"\>"},
    {"1802", "670.`", "\<\"GeneratedParameters\"\>"},
    {"1803", "670.`", "\<\"GeneratingFunction\"\>"},
    {"1804", "670.`", "\<\"Generic\"\>"},
    {"1805", "670.`", "\<\"GenericCylindricalDecomposition\"\>"},
    {"1806", "670.`", "\<\"GenomeData\"\>"},
    {"1807", "670.`", "\<\"GenomeLookup\"\>"},
    {"1808", "670.`", "\<\"GeodesicClosing\"\>"},
    {"1809", "670.`", "\<\"GeodesicDilation\"\>"},
    {"1810", "670.`", "\<\"GeodesicErosion\"\>"},
    {"1811", "670.`", "\<\"GeodesicOpening\"\>"},
    {"1812", "670.`", "\<\"GeoDestination\"\>"},
    {"1813", "670.`", "\<\"GeodesyData\"\>"},
    {"1814", "670.`", "\<\"GeoDirection\"\>"},
    {"1815", "670.`", "\<\"GeoDistance\"\>"},
    {"1816", "670.`", "\<\"GeoGridPosition\"\>"},
    {"1817", "670.`", "\<\"GeometricBrownianMotionProcess\"\>"},
    {"1818", "670.`", "\<\"GeometricDistribution\"\>"},
    {"1819", "670.`", "\<\"GeometricMean\"\>"},
    {"1820", "670.`", "\<\"GeometricMeanFilter\"\>"},
    {"1821", "670.`", "\<\"GeometricTransformation\"\>"},
    {"1822", "670.`", "\<\"GeometricTransformation3DBox\"\>"},
    {"1823", "670.`", "\<\"GeometricTransformation3DBoxOptions\"\>"},
    {"1824", "670.`", "\<\"GeometricTransformationBox\"\>"},
    {"1825", "670.`", "\<\"GeometricTransformationBoxOptions\"\>"},
    {"1826", "670.`", "\<\"GeoPosition\"\>"},
    {"1827", "670.`", "\<\"GeoPositionENU\"\>"},
    {"1828", "670.`", "\<\"GeoPositionXYZ\"\>"},
    {"1829", "670.`", "\<\"GeoProjectionData\"\>"},
    {"1830", "670.`", "\<\"GestureHandler\"\>"},
    {"1831", "670.`", "\<\"GestureHandlerTag\"\>"},
    {"1832", "670.`", "\<\"GetBoundingBoxSizePacket\"\>"},
    {"1833", "670.`", "\<\"GetContext\"\>"},
    {"1834", "670.`", "\<\"GetEnvironment\"\>"},
    {"1835", "670.`", "\<\"GetFileName\"\>"},
    {"1836", "670.`", "\<\"GetFrontEndOptionsDataPacket\"\>"},
    {"1837", "670.`", "\<\"GetLinebreakInformationPacket\"\>"},
    {"1838", "670.`", "\<\"GetMenusPacket\"\>"},
    {"1839", "670.`", "\<\"GetPageBreakInformationPacket\"\>"},
    {"1840", "670.`", "\<\"Glaisher\"\>"},
    {"1841", "670.`", "\<\"GlobalClusteringCoefficient\"\>"},
    {"1842", "670.`", "\<\"GlobalPreferences\"\>"},
    {"1843", "670.`", "\<\"GlobalSession\"\>"},
    {"1844", "670.`", "\<\"Glow\"\>"},
    {"1845", "670.`", "\<\"GoldenRatio\"\>"},
    {"1846", "670.`", "\<\"GompertzMakehamDistribution\"\>"},
    {"1847", "670.`", "\<\"GoodmanKruskalGamma\"\>"},
    {"1848", "670.`", "\<\"GoodmanKruskalGammaTest\"\>"},
    {"1849", "670.`", "\<\"Goto\"\>"},
    {"1850", "670.`", "\<\"Grad\"\>"},
    {"1851", "670.`", "\<\"GradientFilter\"\>"},
    {"1852", "670.`", "\<\"GradientOrientationFilter\"\>"},
    {"1853", "670.`", "\<\"Graph\"\>"},
    {"1854", "670.`", "\<\"GraphAssortativity\"\>"},
    {"1855", "670.`", "\<\"GraphCenter\"\>"},
    {"1856", "670.`", "\<\"GraphComplement\"\>"},
    {"1857", "670.`", "\<\"GraphData\"\>"},
    {"1858", "670.`", "\<\"GraphDensity\"\>"},
    {"1859", "670.`", "\<\"GraphDiameter\"\>"},
    {"1860", "670.`", "\<\"GraphDifference\"\>"},
    {"1861", "670.`", "\<\"GraphDisjointUnion\"\>"},
    {"1862", "670.`", "\<\"GraphDistance\"\>"},
    {"1863", "670.`", "\<\"GraphDistanceMatrix\"\>"},
    {"1864", "670.`", "\<\"GraphElementData\"\>"},
    {"1865", "670.`", "\<\"GraphEmbedding\"\>"},
    {"1866", "670.`", "\<\"GraphHighlight\"\>"},
    {"1867", "670.`", "\<\"GraphHighlightStyle\"\>"},
    {"1868", "670.`", "\<\"GraphHub\"\>"},
    {"1869", "670.`", "\<\"Graphics\"\>"},
    {"1870", "670.`", "\<\"Graphics3D\"\>"},
    {"1871", "670.`", "\<\"Graphics3DBox\"\>"},
    {"1872", "670.`", "\<\"Graphics3DBoxOptions\"\>"},
    {"1873", "670.`", "\<\"GraphicsArray\"\>"},
    {"1874", "670.`", "\<\"GraphicsBaseline\"\>"},
    {"1875", "670.`", "\<\"GraphicsBox\"\>"},
    {"1876", "670.`", "\<\"GraphicsBoxOptions\"\>"},
    {"1877", "670.`", "\<\"GraphicsColor\"\>"},
    {"1878", "670.`", "\<\"GraphicsColumn\"\>"},
    {"1879", "670.`", "\<\"GraphicsComplex\"\>"},
    {"1880", "670.`", "\<\"GraphicsComplex3DBox\"\>"},
    {"1881", "670.`", "\<\"GraphicsComplex3DBoxOptions\"\>"},
    {"1882", "670.`", "\<\"GraphicsComplexBox\"\>"},
    {"1883", "670.`", "\<\"GraphicsComplexBoxOptions\"\>"},
    {"1884", "670.`", "\<\"GraphicsContents\"\>"},
    {"1885", "670.`", "\<\"GraphicsData\"\>"},
    {"1886", "670.`", "\<\"GraphicsGrid\"\>"},
    {"1887", "670.`", "\<\"GraphicsGridBox\"\>"},
    {"1888", "670.`", "\<\"GraphicsGroup\"\>"},
    {"1889", "670.`", "\<\"GraphicsGroup3DBox\"\>"},
    {"1890", "670.`", "\<\"GraphicsGroup3DBoxOptions\"\>"},
    {"1891", "670.`", "\<\"GraphicsGroupBox\"\>"},
    {"1892", "670.`", "\<\"GraphicsGroupBoxOptions\"\>"},
    {"1893", "670.`", "\<\"GraphicsGrouping\"\>"},
    {"1894", "670.`", "\<\"GraphicsHighlightColor\"\>"},
    {"1895", "670.`", "\<\"GraphicsRow\"\>"},
    {"1896", "670.`", "\<\"GraphicsSpacing\"\>"},
    {"1897", "670.`", "\<\"GraphicsStyle\"\>"},
    {"1898", "670.`", "\<\"GraphIntersection\"\>"},
    {"1899", "670.`", "\<\"GraphLayout\"\>"},
    {"1900", "670.`", "\<\"GraphLinkEfficiency\"\>"},
    {"1901", "670.`", "\<\"GraphPeriphery\"\>"},
    {"1902", "670.`", "\<\"GraphPlot\"\>"},
    {"1903", "670.`", "\<\"GraphPlot3D\"\>"},
    {"1904", "670.`", "\<\"GraphPower\"\>"},
    {"1905", "670.`", "\<\"GraphPropertyDistribution\"\>"},
    {"1906", "670.`", "\<\"GraphQ\"\>"},
    {"1907", "670.`", "\<\"GraphRadius\"\>"},
    {"1908", "670.`", "\<\"GraphReciprocity\"\>"},
    {"1909", "670.`", "\<\"GraphRoot\"\>"},
    {"1910", "670.`", "\<\"GraphStyle\"\>"},
    {"1911", "670.`", "\<\"GraphUnion\"\>"},
    {"1912", "670.`", "\<\"GrayLevel\"\>"},
    {"1913", "670.`", "\<\"GreatCircleDistance\"\>"},
    {"1914", "670.`", "\<\"GreaterSlantEqual\"\>"},
    {"1915", "670.`", "\<\"Grid\"\>"},
    {"1916", "670.`", "\<\"GridBaseline\"\>"},
    {"1917", "670.`", "\<\"GridBox\"\>"},
    {"1918", "670.`", "\<\"GridBoxAlignment\"\>"},
    {"1919", "670.`", "\<\"GridBoxBackground\"\>"},
    {"1920", "670.`", "\<\"GridBoxDividers\"\>"},
    {"1921", "670.`", "\<\"GridBoxFrame\"\>"},
    {"1922", "670.`", "\<\"GridBoxItemSize\"\>"},
    {"1923", "670.`", "\<\"GridBoxItemStyle\"\>"},
    {"1924", "670.`", "\<\"GridBoxOptions\"\>"},
    {"1925", "670.`", "\<\"GridBoxSpacings\"\>"},
    {"1926", "670.`", "\<\"GridCreationSettings\"\>"},
    {"1927", "670.`", "\<\"GridDefaultElement\"\>"},
    {"1928", "670.`", "\<\"GridElementStyleOptions\"\>"},
    {"1929", "670.`", "\<\"GridFrame\"\>"},
    {"1930", "670.`", "\<\"GridFrameMargins\"\>"},
    {"1931", "670.`", "\<\"GridGraph\"\>"},
    {"1932", "670.`", "\<\"GridLines\"\>"},
    {"1933", "670.`", "\<\"GridLinesStyle\"\>"},
    {"1934", "670.`", "\<\"GroebnerBasis\"\>"},
    {"1935", "670.`", "\<\"GroupActionBase\"\>"},
    {"1936", "670.`", "\<\"GroupCentralizer\"\>"},
    {"1937", "670.`", "\<\"GroupElementFromWord\"\>"},
    {"1938", "670.`", "\<\"GroupElementPosition\"\>"},
    {"1939", "670.`", "\<\"GroupElementQ\"\>"},
    {"1940", "670.`", "\<\"GroupElements\"\>"},
    {"1941", "670.`", "\<\"GroupElementToWord\"\>"},
    {"1942", "670.`", "\<\"GroupGenerators\"\>"},
    {"1943", "670.`", "\<\"GroupMultiplicationTable\"\>"},
    {"1944", "670.`", "\<\"GroupOrbits\"\>"},
    {"1945", "670.`", "\<\"GroupOrder\"\>"},
    {"1946", "670.`", "\<\"GroupPageBreakWithin\"\>"},
    {"1947", "670.`", "\<\"GroupSetwiseStabilizer\"\>"},
    {"1948", "670.`", "\<\"GroupStabilizer\"\>"},
    {"1949", "670.`", "\<\"GroupStabilizerChain\"\>"},
    {"1950", "670.`", "\<\"Gudermannian\"\>"},
    {"1951", "670.`", "\<\"GumbelDistribution\"\>"},
    {"1952", "670.`", "\<\"HaarWavelet\"\>"},
    {"1953", "670.`", "\<\"HadamardMatrix\"\>"},
    {"1954", "670.`", "\<\"HalfNormalDistribution\"\>"},
    {"1955", "670.`", "\<\"HamiltonianGraphQ\"\>"},
    {"1956", "670.`", "\<\"HammingDistance\"\>"},
    {"1957", "670.`", "\<\"HammingWindow\"\>"},
    {"1958", "670.`", "\<\"HankelH1\"\>"},
    {"1959", "670.`", "\<\"HankelH2\"\>"},
    {"1960", "670.`", "\<\"HankelMatrix\"\>"},
    {"1961", "670.`", "\<\"HannPoissonWindow\"\>"},
    {"1962", "670.`", "\<\"HannWindow\"\>"},
    {"1963", "670.`", "\<\"HaradaNortonGroupHN\"\>"},
    {"1964", "670.`", "\<\"HararyGraph\"\>"},
    {"1965", "670.`", "\<\"HarmonicMean\"\>"},
    {"1966", "670.`", "\<\"HarmonicMeanFilter\"\>"},
    {"1967", "670.`", "\<\"HarmonicNumber\"\>"},
    {"1968", "670.`", "\<\"Hash\"\>"},
    {"1969", "670.`", "\<\"HashTable\"\>"},
    {"1970", "670.`", "\<\"Haversine\"\>"},
    {"1971", "670.`", "\<\"HazardFunction\"\>"},
    {"1972", "670.`", "\<\"Head\"\>"},
    {"1973", "670.`", "\<\"HeadCompose\"\>"},
    {"1974", "670.`", "\<\"Heads\"\>"},
    {"1975", "670.`", "\<\"HeavisideLambda\"\>"},
    {"1976", "670.`", "\<\"HeavisidePi\"\>"},
    {"1977", "670.`", "\<\"HeavisideTheta\"\>"},
    {"1978", "670.`", "\<\"HeldGroupHe\"\>"},
    {"1979", "670.`", "\<\"HeldPart\"\>"},
    {"1980", "670.`", "\<\"HelpBrowserLookup\"\>"},
    {"1981", "670.`", "\<\"HelpBrowserNotebook\"\>"},
    {"1982", "670.`", "\<\"HelpBrowserSettings\"\>"},
    {"1983", "670.`", "\<\"HermiteDecomposition\"\>"},
    {"1984", "670.`", "\<\"HermiteH\"\>"},
    {"1985", "670.`", "\<\"HermitianMatrixQ\"\>"},
    {"1986", "670.`", "\<\"HessenbergDecomposition\"\>"},
    {"1987", "670.`", "\<\"Hessian\"\>"},
    {"1988", "670.`", "\<\"HexadecimalCharacter\"\>"},
    {"1989", "670.`", "\<\"Hexahedron\"\>"},
    {"1990", "670.`", "\<\"HexahedronBox\"\>"},
    {"1991", "670.`", "\<\"HexahedronBoxOptions\"\>"},
    {"1992", "670.`", "\<\"HiddenSurface\"\>"},
    {"1993", "670.`", "\<\"HighlightGraph\"\>"},
    {"1994", "670.`", "\<\"HighlightImage\"\>"},
    {"1995", "670.`", "\<\"HighpassFilter\"\>"},
    {"1996", "670.`", "\<\"HigmanSimsGroupHS\"\>"},
    {"1997", "670.`", "\<\"HilbertFilter\"\>"},
    {"1998", "670.`", "\<\"HilbertMatrix\"\>"},
    {"1999", "670.`", "\<\"Histogram\"\>"},
    {"2000", "670.`", "\<\"Histogram3D\"\>"},
    {"2001", "670.`", "\<\"HistogramDistribution\"\>"},
    {"2002", "670.`", "\<\"HistogramList\"\>"},
    {"2003", "670.`", "\<\"HistogramTransform\"\>"},
    {"2004", "670.`", "\<\"HistogramTransformInterpolation\"\>"},
    {"2005", "670.`", "\<\"HitMissTransform\"\>"},
    {"2006", "670.`", "\<\"HITSCentrality\"\>"},
    {"2007", "670.`", "\<\"HodgeDual\"\>"},
    {"2008", "670.`", "\<\"HoeffdingD\"\>"},
    {"2009", "670.`", "\<\"HoeffdingDTest\"\>"},
    {"2010", "670.`", "\<\"Hold\"\>"},
    {"2011", "670.`", "\<\"HoldAll\"\>"},
    {"2012", "670.`", "\<\"HoldAllComplete\"\>"},
    {"2013", "670.`", "\<\"HoldComplete\"\>"},
    {"2014", "670.`", "\<\"HoldFirst\"\>"},
    {"2015", "670.`", "\<\"HoldForm\"\>"},
    {"2016", "670.`", "\<\"HoldPattern\"\>"},
    {"2017", "670.`", "\<\"HoldRest\"\>"},
    {"2018", "670.`", "\<\"HolidayCalendar\"\>"},
    {"2019", "670.`", "\<\"HomeDirectory\"\>"},
    {"2020", "670.`", "\<\"HomePage\"\>"},
    {"2021", "670.`", "\<\"Horizontal\"\>"},
    {"2022", "670.`", "\<\"HorizontalForm\"\>"},
    {"2023", "670.`", "\<\"HorizontalGauge\"\>"},
    {"2024", "670.`", "\<\"HorizontalScrollPosition\"\>"},
    {"2025", "670.`", "\<\"HornerForm\"\>"},
    {"2026", "670.`", "\<\"HotellingTSquareDistribution\"\>"},
    {"2027", "670.`", "\<\"HoytDistribution\"\>"},
    {"2028", "670.`", "\<\"HTMLSave\"\>"},
    {"2029", "670.`", "\<\"Hue\"\>"},
    {"2030", "670.`", "\<\"HurwitzLerchPhi\"\>"},
    {"2031", "670.`", "\<\"HurwitzZeta\"\>"},
    {"2032", "670.`", "\<\"HyperbolicDistribution\"\>"},
    {"2033", "670.`", "\<\"HypercubeGraph\"\>"},
    {"2034", "670.`", "\<\"HyperexponentialDistribution\"\>"},
    {"2035", "670.`", "\<\"Hyperfactorial\"\>"},
    {"2036", "670.`", "\<\"Hypergeometric0F1\"\>"},
    {"2037", "670.`", "\<\"Hypergeometric0F1Regularized\"\>"},
    {"2038", "670.`", "\<\"Hypergeometric1F1\"\>"},
    {"2039", "670.`", "\<\"Hypergeometric1F1Regularized\"\>"},
    {"2040", "670.`", "\<\"Hypergeometric2F1\"\>"},
    {"2041", "670.`", "\<\"Hypergeometric2F1Regularized\"\>"},
    {"2042", "670.`", "\<\"HypergeometricDistribution\"\>"},
    {"2043", "670.`", "\<\"HypergeometricPFQ\"\>"},
    {"2044", "670.`", "\<\"HypergeometricPFQRegularized\"\>"},
    {"2045", "670.`", "\<\"HypergeometricU\"\>"},
    {"2046", "670.`", "\<\"Hyperlink\"\>"},
    {"2047", "670.`", "\<\"HyperlinkCreationSettings\"\>"},
    {"2048", "670.`", "\<\"Hyphenation\"\>"},
    {"2049", "670.`", "\<\"HyphenationOptions\"\>"},
    {"2050", "670.`", "\<\"HypoexponentialDistribution\"\>"},
    {"2051", "670.`", "\<\"HypothesisTestData\"\>"},
    {"2052", "670.`", "\<\"Identity\"\>"},
    {"2053", "670.`", "\<\"IdentityMatrix\"\>"},
    {"2054", "670.`", "\<\"If\"\>"},
    {"2055", "670.`", "\<\"IgnoreCase\"\>"},
    {"2056", "670.`", "\<\"Im\"\>"},
    {"2057", "670.`", "\<\"Image\"\>"},
    {"2058", "670.`", "\<\"Image3D\"\>"},
    {"2059", "670.`", "\<\"Image3DSlices\"\>"},
    {"2060", "670.`", "\<\"ImageAccumulate\"\>"},
    {"2061", "670.`", "\<\"ImageAdd\"\>"},
    {"2062", "670.`", "\<\"ImageAdjust\"\>"},
    {"2063", "670.`", "\<\"ImageAlign\"\>"},
    {"2064", "670.`", "\<\"ImageApply\"\>"},
    {"2065", "670.`", "\<\"ImageAspectRatio\"\>"},
    {"2066", "670.`", "\<\"ImageAssemble\"\>"},
    {"2067", "670.`", "\<\"ImageCache\"\>"},
    {"2068", "670.`", "\<\"ImageCacheValid\"\>"},
    {"2069", "670.`", "\<\"ImageCapture\"\>"},
    {"2070", "670.`", "\<\"ImageChannels\"\>"},
    {"2071", "670.`", "\<\"ImageClip\"\>"},
    {"2072", "670.`", "\<\"ImageColorSpace\"\>"},
    {"2073", "670.`", "\<\"ImageCompose\"\>"},
    {"2074", "670.`", "\<\"ImageConvolve\"\>"},
    {"2075", "670.`", "\<\"ImageCooccurrence\"\>"},
    {"2076", "670.`", "\<\"ImageCorners\"\>"},
    {"2077", "670.`", "\<\"ImageCorrelate\"\>"},
    {"2078", "670.`", "\<\"ImageCorrespondingPoints\"\>"},
    {"2079", "670.`", "\<\"ImageCrop\"\>"},
    {"2080", "670.`", "\<\"ImageData\"\>"},
    {"2081", "670.`", "\<\"ImageDeconvolve\"\>"},
    {"2082", "670.`", "\<\"ImageDemosaic\"\>"},
    {"2083", "670.`", "\<\"ImageDifference\"\>"},
    {"2084", "670.`", "\<\"ImageDimensions\"\>"},
    {"2085", "670.`", "\<\"ImageDistance\"\>"},
    {"2086", "670.`", "\<\"ImageEffect\"\>"},
    {"2087", "670.`", "\<\"ImageFeatureTrack\"\>"},
    {"2088", "670.`", "\<\"ImageFileApply\"\>"},
    {"2089", "670.`", "\<\"ImageFileFilter\"\>"},
    {"2090", "670.`", "\<\"ImageFileScan\"\>"},
    {"2091", "670.`", "\<\"ImageFilter\"\>"},
    {"2092", "670.`", "\<\"ImageForestingComponents\"\>"},
    {"2093", "670.`", "\<\"ImageForwardTransformation\"\>"},
    {"2094", "670.`", "\<\"ImageHistogram\"\>"},
    {"2095", "670.`", "\<\"ImageKeypoints\"\>"},
    {"2096", "670.`", "\<\"ImageLevels\"\>"},
    {"2097", "670.`", "\<\"ImageLines\"\>"},
    {"2098", "670.`", "\<\"ImageMargins\"\>"},
    {"2099", "670.`", "\<\"ImageMarkers\"\>"},
    {"2100", "670.`", "\<\"ImageMeasurements\"\>"},
    {"2101", "670.`", "\<\"ImageMultiply\"\>"},
    {"2102", "670.`", "\<\"ImageOffset\"\>"},
    {"2103", "670.`", "\<\"ImagePad\"\>"},
    {"2104", "670.`", "\<\"ImagePadding\"\>"},
    {"2105", "670.`", "\<\"ImagePartition\"\>"},
    {"2106", "670.`", "\<\"ImagePeriodogram\"\>"},
    {"2107", "670.`", "\<\"ImagePerspectiveTransformation\"\>"},
    {"2108", "670.`", "\<\"ImageQ\"\>"},
    {"2109", "670.`", "\<\"ImageRangeCache\"\>"},
    {"2110", "670.`", "\<\"ImageReflect\"\>"},
    {"2111", "670.`", "\<\"ImageRegion\"\>"},
    {"2112", "670.`", "\<\"ImageResize\"\>"},
    {"2113", "670.`", "\<\"ImageResolution\"\>"},
    {"2114", "670.`", "\<\"ImageRotate\"\>"},
    {"2115", "670.`", "\<\"ImageRotated\"\>"},
    {"2116", "670.`", "\<\"ImageScaled\"\>"},
    {"2117", "670.`", "\<\"ImageScan\"\>"},
    {"2118", "670.`", "\<\"ImageSize\"\>"},
    {"2119", "670.`", "\<\"ImageSizeAction\"\>"},
    {"2120", "670.`", "\<\"ImageSizeCache\"\>"},
    {"2121", "670.`", "\<\"ImageSizeMultipliers\"\>"},
    {"2122", "670.`", "\<\"ImageSizeRaw\"\>"},
    {"2123", "670.`", "\<\"ImageSubtract\"\>"},
    {"2124", "670.`", "\<\"ImageTake\"\>"},
    {"2125", "670.`", "\<\"ImageTransformation\"\>"},
    {"2126", "670.`", "\<\"ImageTrim\"\>"},
    {"2127", "670.`", "\<\"ImageType\"\>"},
    {"2128", "670.`", "\<\"ImageValue\"\>"},
    {"2129", "670.`", "\<\"ImageValuePositions\"\>"},
    {"2130", "670.`", "\<\"Import\"\>"},
    {"2131", "670.`", "\<\"ImportAutoReplacements\"\>"},
    {"2132", "670.`", "\<\"ImportString\"\>"},
    {"2133", "670.`", "\<\"ImprovementImportance\"\>"},
    {"2134", "670.`", "\<\"In\"\>"},
    {"2135", "670.`", "\<\"IncidenceGraph\"\>"},
    {"2136", "670.`", "\<\"IncidenceList\"\>"},
    {"2137", "670.`", "\<\"IncidenceMatrix\"\>"},
    {"2138", "670.`", "\<\"IncludeConstantBasis\"\>"},
    {"2139", "670.`", "\<\"IncludeFileExtension\"\>"},
    {"2140", "670.`", "\<\"IncludePods\"\>"},
    {"2141", "670.`", "\<\"IncludeSingularTerm\"\>"},
    {"2142", "670.`", "\<\"Indent\"\>"},
    {"2143", "670.`", "\<\"IndentingNewlineSpacings\"\>"},
    {"2144", "670.`", "\<\"IndentMaxFraction\"\>"},
    {"2145", "670.`", "\<\"IndependenceTest\"\>"},
    {"2146", "670.`", "\<\"IndependentEdgeSetQ\"\>"},
    {"2147", "670.`", "\<\"IndependentUnit\"\>"},
    {"2148", "670.`", "\<\"IndependentVertexSetQ\"\>"},
    {"2149", "670.`", "\<\"Indeterminate\"\>"},
    {"2150", "670.`", "\<\"IndexCreationOptions\"\>"},
    {"2151", "670.`", "\<\"Indexed\"\>"},
    {"2152", "670.`", "\<\"IndexGraph\"\>"},
    {"2153", "670.`", "\<\"IndexTag\"\>"},
    {"2154", "670.`", "\<\"Inequality\"\>"},
    {"2155", "670.`", "\<\"InexactNumberQ\"\>"},
    {"2156", "670.`", "\<\"InexactNumbers\"\>"},
    {"2157", "670.`", "\<\"Information\"\>"},
    {"2158", "670.`", "\<\"Inherited\"\>"},
    {"2159", "670.`", "\<\"InheritScope\"\>"},
    {"2160", "670.`", "\<\"Initialization\"\>"},
    {"2161", "670.`", "\<\"InitializationCell\"\>"},
    {"2162", "670.`", "\<\"InitializationCellEvaluation\"\>"},
    {"2163", "670.`", "\<\"InitializationCellWarning\"\>"},
    {"2164", "670.`", "\<\"InlineCounterAssignments\"\>"},
    {"2165", "670.`", "\<\"InlineCounterIncrements\"\>"},
    {"2166", "670.`", "\<\"InlineRules\"\>"},
    {"2167", "670.`", "\<\"Inner\"\>"},
    {"2168", "670.`", "\<\"Inpaint\"\>"},
    {"2169", "670.`", "\<\"Input\"\>"},
    {"2170", "670.`", "\<\"InputAliases\"\>"},
    {"2171", "670.`", "\<\"InputAssumptions\"\>"},
    {"2172", "670.`", "\<\"InputAutoReplacements\"\>"},
    {"2173", "670.`", "\<\"InputField\"\>"},
    {"2174", "670.`", "\<\"InputFieldBox\"\>"},
    {"2175", "670.`", "\<\"InputFieldBoxOptions\"\>"},
    {"2176", "670.`", "\<\"InputForm\"\>"},
    {"2177", "670.`", "\<\"InputGrouping\"\>"},
    {"2178", "670.`", "\<\"InputNamePacket\"\>"},
    {"2179", "670.`", "\<\"InputNotebook\"\>"},
    {"2180", "670.`", "\<\"InputPacket\"\>"},
    {"2181", "670.`", "\<\"InputSettings\"\>"},
    {"2182", "670.`", "\<\"InputStream\"\>"},
    {"2183", "670.`", "\<\"InputString\"\>"},
    {"2184", "670.`", "\<\"InputStringPacket\"\>"},
    {"2185", "670.`", "\<\"InputToBoxFormPacket\"\>"},
    {"2186", "670.`", "\<\"Insert\"\>"},
    {"2187", "670.`", "\<\"InsertionPointObject\"\>"},
    {"2188", "670.`", "\<\"InsertResults\"\>"},
    {"2189", "670.`", "\<\"Inset\"\>"},
    {"2190", "670.`", "\<\"Inset3DBox\"\>"},
    {"2191", "670.`", "\<\"Inset3DBoxOptions\"\>"},
    {"2192", "670.`", "\<\"InsetBox\"\>"},
    {"2193", "670.`", "\<\"InsetBoxOptions\"\>"},
    {"2194", "670.`", "\<\"Install\"\>"},
    {"2195", "670.`", "\<\"InstallService\"\>"},
    {"2196", "670.`", "\<\"InString\"\>"},
    {"2197", "670.`", "\<\"Integer\"\>"},
    {"2198", "670.`", "\<\"IntegerDigits\"\>"},
    {"2199", "670.`", "\<\"IntegerExponent\"\>"},
    {"2200", "670.`", "\<\"IntegerLength\"\>"},
    {"2201", "670.`", "\<\"IntegerPart\"\>"},
    {"2202", "670.`", "\<\"IntegerPartitions\"\>"},
    {"2203", "670.`", "\<\"IntegerQ\"\>"},
    {"2204", "670.`", "\<\"Integers\"\>"},
    {"2205", "670.`", "\<\"IntegerString\"\>"},
    {"2206", "670.`", "\<\"Integral\"\>"},
    {"2207", "670.`", "\<\"Interactive\"\>"},
    {"2208", "670.`", "\<\"InteractiveTradingChart\"\>"},
    {"2209", "670.`", "\<\"Interlaced\"\>"},
    {"2210", "670.`", "\<\"Interleaving\"\>"},
    {"2211", "670.`", "\<\"InternallyBalancedDecomposition\"\>"},
    {"2212", "670.`", "\<\"InterpolatingFunction\"\>"},
    {"2213", "670.`", "\<\"InterpolatingPolynomial\"\>"},
    {"2214", "670.`", "\<\"Interpolation\"\>"},
    {"2215", "670.`", "\<\"InterpolationOrder\"\>"},
    {"2216", "670.`", "\<\"InterpolationPoints\"\>"},
    {"2217", "670.`", "\<\"InterpolationPrecision\"\>"},
    {"2218", "670.`", "\<\"Interpretation\"\>"},
    {"2219", "670.`", "\<\"InterpretationBox\"\>"},
    {"2220", "670.`", "\<\"InterpretationBoxOptions\"\>"},
    {"2221", "670.`", "\<\"InterpretationFunction\"\>"},
    {"2222", "670.`", "\<\"InterpretTemplate\"\>"},
    {"2223", "670.`", "\<\"InterquartileRange\"\>"},
    {"2224", "670.`", "\<\"Interrupt\"\>"},
    {"2225", "670.`", "\<\"InterruptSettings\"\>"},
    {"2226", "670.`", "\<\"Interval\"\>"},
    {"2227", "670.`", "\<\"IntervalMemberQ\"\>"},
    {"2228", "670.`", "\<\"Inverse\"\>"},
    {"2229", "670.`", "\<\"InverseBetaRegularized\"\>"},
    {"2230", "670.`", "\<\"InverseCDF\"\>"},
    {"2231", "670.`", "\<\"InverseChiSquareDistribution\"\>"},
    {"2232", "670.`", "\<\"InverseContinuousWaveletTransform\"\>"},
    {"2233", "670.`", "\<\"InverseDistanceTransform\"\>"},
    {"2234", "670.`", "\<\"InverseEllipticNomeQ\"\>"},
    {"2235", "670.`", "\<\"InverseErf\"\>"},
    {"2236", "670.`", "\<\"InverseErfc\"\>"},
    {"2237", "670.`", "\<\"InverseFourier\"\>"},
    {"2238", "670.`", "\<\"InverseFourierCosTransform\"\>"},
    {"2239", "670.`", "\<\"InverseFourierSequenceTransform\"\>"},
    {"2240", "670.`", "\<\"InverseFourierSinTransform\"\>"},
    {"2241", "670.`", "\<\"InverseFourierTransform\"\>"},
    {"2242", "670.`", "\<\"InverseFunction\"\>"},
    {"2243", "670.`", "\<\"InverseFunctions\"\>"},
    {"2244", "670.`", "\<\"InverseGammaDistribution\"\>"},
    {"2245", "670.`", "\<\"InverseGammaRegularized\"\>"},
    {"2246", "670.`", "\<\"InverseGaussianDistribution\"\>"},
    {"2247", "670.`", "\<\"InverseGudermannian\"\>"},
    {"2248", "670.`", "\<\"InverseHaversine\"\>"},
    {"2249", "670.`", "\<\"InverseJacobiCD\"\>"},
    {"2250", "670.`", "\<\"InverseJacobiCN\"\>"},
    {"2251", "670.`", "\<\"InverseJacobiCS\"\>"},
    {"2252", "670.`", "\<\"InverseJacobiDC\"\>"},
    {"2253", "670.`", "\<\"InverseJacobiDN\"\>"},
    {"2254", "670.`", "\<\"InverseJacobiDS\"\>"},
    {"2255", "670.`", "\<\"InverseJacobiNC\"\>"},
    {"2256", "670.`", "\<\"InverseJacobiND\"\>"},
    {"2257", "670.`", "\<\"InverseJacobiNS\"\>"},
    {"2258", "670.`", "\<\"InverseJacobiSC\"\>"},
    {"2259", "670.`", "\<\"InverseJacobiSD\"\>"},
    {"2260", "670.`", "\<\"InverseJacobiSN\"\>"},
    {"2261", "670.`", "\<\"InverseLaplaceTransform\"\>"},
    {"2262", "670.`", "\<\"InversePermutation\"\>"},
    {"2263", "670.`", "\<\"InverseRadon\"\>"},
    {"2264", "670.`", "\<\"InverseSeries\"\>"},
    {"2265", "670.`", "\<\"InverseSurvivalFunction\"\>"},
    {"2266", "670.`", "\<\"InverseWaveletTransform\"\>"},
    {"2267", "670.`", "\<\"InverseWeierstrassP\"\>"},
    {"2268", "670.`", "\<\"InverseZTransform\"\>"},
    {"2269", "670.`", "\<\"Invisible\"\>"},
    {"2270", "670.`", "\<\"InvisibleTimes\"\>"},
    {"2271", "670.`", "\<\"IrreduciblePolynomialQ\"\>"},
    {"2272", "670.`", "\<\"IsolatingInterval\"\>"},
    {"2273", "670.`", "\<\"IsomorphicGraphQ\"\>"},
    {"2274", "670.`", "\<\"IsotopeData\"\>"},
    {"2275", "670.`", "\<\"Italic\"\>"},
    {"2276", "670.`", "\<\"Item\"\>"},
    {"2277", "670.`", "\<\"ItemBox\"\>"},
    {"2278", "670.`", "\<\"ItemBoxOptions\"\>"},
    {"2279", "670.`", "\<\"ItemSize\"\>"},
    {"2280", "670.`", "\<\"ItemStyle\"\>"},
    {"2281", "670.`", "\<\"ItoProcess\"\>"},
    {"2282", "670.`", "\<\"JaccardDissimilarity\"\>"},
    {"2283", "670.`", "\<\"JacobiAmplitude\"\>"},
    {"2284", "670.`", "\<\"Jacobian\"\>"},
    {"2285", "670.`", "\<\"JacobiCD\"\>"},
    {"2286", "670.`", "\<\"JacobiCN\"\>"},
    {"2287", "670.`", "\<\"JacobiCS\"\>"},
    {"2288", "670.`", "\<\"JacobiDC\"\>"},
    {"2289", "670.`", "\<\"JacobiDN\"\>"},
    {"2290", "670.`", "\<\"JacobiDS\"\>"},
    {"2291", "670.`", "\<\"JacobiNC\"\>"},
    {"2292", "670.`", "\<\"JacobiND\"\>"},
    {"2293", "670.`", "\<\"JacobiNS\"\>"},
    {"2294", "670.`", "\<\"JacobiP\"\>"},
    {"2295", "670.`", "\<\"JacobiSC\"\>"},
    {"2296", "670.`", "\<\"JacobiSD\"\>"},
    {"2297", "670.`", "\<\"JacobiSN\"\>"},
    {"2298", "670.`", "\<\"JacobiSymbol\"\>"},
    {"2299", "670.`", "\<\"JacobiZeta\"\>"},
    {"2300", "670.`", "\<\"JankoGroupJ1\"\>"},
    {"2301", "670.`", "\<\"JankoGroupJ2\"\>"},
    {"2302", "670.`", "\<\"JankoGroupJ3\"\>"},
    {"2303", "670.`", "\<\"JankoGroupJ4\"\>"},
    {"2304", "670.`", "\<\"JarqueBeraALMTest\"\>"},
    {"2305", "670.`", "\<\"JohnsonDistribution\"\>"},
    {"2306", "670.`", "\<\"Join\"\>"},
    {"2307", "670.`", "\<\"Joined\"\>"},
    {"2308", "670.`", "\<\"JoinedCurve\"\>"},
    {"2309", "670.`", "\<\"JoinedCurveBox\"\>"},
    {"2310", "670.`", "\<\"JoinForm\"\>"},
    {"2311", "670.`", "\<\"JordanDecomposition\"\>"},
    {"2312", "670.`", "\<\"JordanModelDecomposition\"\>"},
    {"2313", "670.`", "\<\"K\"\>"},
    {"2314", "670.`", "\<\"KagiChart\"\>"},
    {"2315", "670.`", "\<\"KaiserBesselWindow\"\>"},
    {"2316", "670.`", "\<\"KaiserWindow\"\>"},
    {"2317", "670.`", "\<\"KalmanEstimator\"\>"},
    {"2318", "670.`", "\<\"KalmanFilter\"\>"},
    {"2319", "670.`", "\<\"KarhunenLoeveDecomposition\"\>"},
    {"2320", "670.`", "\<\"KaryTree\"\>"},
    {"2321", "670.`", "\<\"KatzCentrality\"\>"},
    {"2322", "670.`", "\<\"KCoreComponents\"\>"},
    {"2323", "670.`", "\<\"KDistribution\"\>"},
    {"2324", "670.`", "\<\"KelvinBei\"\>"},
    {"2325", "670.`", "\<\"KelvinBer\"\>"},
    {"2326", "670.`", "\<\"KelvinKei\"\>"},
    {"2327", "670.`", "\<\"KelvinKer\"\>"},
    {"2328", "670.`", "\<\"KendallTau\"\>"},
    {"2329", "670.`", "\<\"KendallTauTest\"\>"},
    {"2330", "670.`", "\<\"KernelMixtureDistribution\"\>"},
    {"2331", "670.`", "\<\"KernelObject\"\>"},
    {"2332", "670.`", "\<\"Kernels\"\>"},
    {"2333", "670.`", "\<\"Ket\"\>"},
    {"2334", "670.`", "\<\"Khinchin\"\>"},
    {"2335", "670.`", "\<\"KirchhoffGraph\"\>"},
    {"2336", "670.`", "\<\"KirchhoffMatrix\"\>"},
    {"2337", "670.`", "\<\"KleinInvariantJ\"\>"},
    {"2338", "670.`", "\<\"KnightTourGraph\"\>"},
    {"2339", "670.`", "\<\"KnotData\"\>"},
    {"2340", "670.`", "\<\"KnownUnitQ\"\>"},
    {"2341", "670.`", "\<\"KolmogorovSmirnovTest\"\>"},
    {"2342", "670.`", "\<\"KroneckerDelta\"\>"},
    {"2343", "670.`", "\<\"KroneckerModelDecomposition\"\>"},
    {"2344", "670.`", "\<\"KroneckerProduct\"\>"},
    {"2345", "670.`", "\<\"KroneckerSymbol\"\>"},
    {"2346", "670.`", "\<\"KuiperTest\"\>"},
    {"2347", "670.`", "\<\"KumaraswamyDistribution\"\>"},
    {"2348", "670.`", "\<\"Kurtosis\"\>"},
    {"2349", "670.`", "\<\"KuwaharaFilter\"\>"},
    {"2350", "670.`", "\<\"Label\"\>"},
    {"2351", "670.`", "\<\"Labeled\"\>"},
    {"2352", "670.`", "\<\"LabeledSlider\"\>"},
    {"2353", "670.`", "\<\"LabelingFunction\"\>"},
    {"2354", "670.`", "\<\"LabelStyle\"\>"},
    {"2355", "670.`", "\<\"LaguerreL\"\>"},
    {"2356", "670.`", "\<\"LambdaComponents\"\>"},
    {"2357", "670.`", "\<\"LambertW\"\>"},
    {"2358", "670.`", "\<\"LanczosWindow\"\>"},
    {"2359", "670.`", "\<\"LandauDistribution\"\>"},
    {"2360", "670.`", "\<\"Language\"\>"},
    {"2361", "670.`", "\<\"LanguageCategory\"\>"},
    {"2362", "670.`", "\<\"LaplaceDistribution\"\>"},
    {"2363", "670.`", "\<\"LaplaceTransform\"\>"},
    {"2364", "670.`", "\<\"LaplacianFilter\"\>"},
    {"2365", "670.`", "\<\"LaplacianGaussianFilter\"\>"},
    {"2366", "670.`", "\<\"Large\"\>"},
    {"2367", "670.`", "\<\"Larger\"\>"},
    {"2368", "670.`", "\<\"Last\"\>"},
    {"2369", "670.`", "\<\"Latitude\"\>"},
    {"2370", "670.`", "\<\"LatitudeLongitude\"\>"},
    {"2371", "670.`", "\<\"LatticeData\"\>"},
    {"2372", "670.`", "\<\"LatticeReduce\"\>"},
    {"2373", "670.`", "\<\"Launch\"\>"},
    {"2374", "670.`", "\<\"LaunchKernels\"\>"},
    {"2375", "670.`", "\<\"LayeredGraphPlot\"\>"},
    {"2376", "670.`", "\<\"LayerSizeFunction\"\>"},
    {"2377", "670.`", "\<\"LayoutInformation\"\>"},
    {"2378", "670.`", "\<\"LCM\"\>"},
    {"2379", "670.`", "\<\"LeafCount\"\>"},
    {"2380", "670.`", "\<\"LeapYearQ\"\>"},
    {"2381", "670.`", "\<\"LeastSquares\"\>"},
    {"2382", "670.`", "\<\"LeastSquaresFilterKernel\"\>"},
    {"2383", "670.`", "\<\"Left\"\>"},
    {"2384", "670.`", "\<\"LegendAppearance\"\>"},
    {"2385", "670.`", "\<\"Legended\"\>"},
    {"2386", "670.`", "\<\"LegendFunction\"\>"},
    {"2387", "670.`", "\<\"LegendLabel\"\>"},
    {"2388", "670.`", "\<\"LegendLayout\"\>"},
    {"2389", "670.`", "\<\"LegendMargins\"\>"},
    {"2390", "670.`", "\<\"LegendMarkers\"\>"},
    {"2391", "670.`", "\<\"LegendMarkerSize\"\>"},
    {"2392", "670.`", "\<\"LegendreP\"\>"},
    {"2393", "670.`", "\<\"LegendreQ\"\>"},
    {"2394", "670.`", "\<\"LegendreType\"\>"},
    {"2395", "670.`", "\<\"Length\"\>"},
    {"2396", "670.`", "\<\"LengthWhile\"\>"},
    {"2397", "670.`", "\<\"LerchPhi\"\>"},
    {"2398", "670.`", "\<\"LessSlantEqual\"\>"},
    {"2399", "670.`", "\<\"LetterCharacter\"\>"},
    {"2400", "670.`", "\<\"LetterQ\"\>"},
    {"2401", "670.`", "\<\"Level\"\>"},
    {"2402", "670.`", "\<\"LeveneTest\"\>"},
    {"2403", "670.`", "\<\"LeviCivitaTensor\"\>"},
    {"2404", "670.`", "\<\"LevyDistribution\"\>"},
    {"2405", "670.`", "\<\"Lexicographic\"\>"},
    {"2406", "670.`", "\<\"LibraryFunction\"\>"},
    {"2407", "670.`", "\<\"LibraryFunctionError\"\>"},
    {"2408", "670.`", "\<\"LibraryFunctionInformation\"\>"},
    {"2409", "670.`", "\<\"LibraryFunctionLoad\"\>"},
    {"2410", "670.`", "\<\"LibraryFunctionUnload\"\>"},
    {"2411", "670.`", "\<\"LibraryLoad\"\>"},
    {"2412", "670.`", "\<\"LibraryUnload\"\>"},
    {"2413", "670.`", "\<\"LicenseID\"\>"},
    {"2414", "670.`", "\<\"LiftingFilterData\"\>"},
    {"2415", "670.`", "\<\"LiftingWaveletTransform\"\>"},
    {"2416", "670.`", "\<\"Lighter\"\>"},
    {"2417", "670.`", "\<\"Lighting\"\>"},
    {"2418", "670.`", "\<\"LightingAngle\"\>"},
    {"2419", "670.`", "\<\"LightSources\"\>"},
    {"2420", "670.`", "\<\"Likelihood\"\>"},
    {"2421", "670.`", "\<\"Limit\"\>"},
    {"2422", "670.`", "\<\"LimitsPositioning\"\>"},
    {"2423", "670.`", "\<\"LimitsPositioningTokens\"\>"},
    {"2424", "670.`", "\<\"LindleyDistribution\"\>"},
    {"2425", "670.`", "\<\"Line\"\>"},
    {"2426", "670.`", "\<\"Line3DBox\"\>"},
    {"2427", "670.`", "\<\"LinearFilter\"\>"},
    {"2428", "670.`", "\<\"LinearFractionalTransform\"\>"},
    {"2429", "670.`", "\<\"LinearModelFit\"\>"},
    {"2430", "670.`", "\<\"LinearOffsetFunction\"\>"},
    {"2431", "670.`", "\<\"LinearProgramming\"\>"},
    {"2432", "670.`", "\<\"LinearRecurrence\"\>"},
    {"2433", "670.`", "\<\"LinearSolve\"\>"},
    {"2434", "670.`", "\<\"LinearSolveFunction\"\>"},
    {"2435", "670.`", "\<\"LineBox\"\>"},
    {"2436", "670.`", "\<\"LineBreak\"\>"},
    {"2437", "670.`", "\<\"LinebreakAdjustments\"\>"},
    {"2438", "670.`", "\<\"LineBreakChart\"\>"},
    {"2439", "670.`", "\<\"LineBreakWithin\"\>"},
    {"2440", "670.`", "\<\"LineColor\"\>"},
    {"2441", "670.`", "\<\"LineForm\"\>"},
    {"2442", "670.`", "\<\"LineGraph\"\>"},
    {"2443", "670.`", "\<\"LineIndent\"\>"},
    {"2444", "670.`", "\<\"LineIndentMaxFraction\"\>"},
    {"2445", "670.`", "\<\"LineIntegralConvolutionPlot\"\>"},
    {"2446", "670.`", "\<\"LineIntegralConvolutionScale\"\>"},
    {"2447", "670.`", "\<\"LineLegend\"\>"},
    {"2448", "670.`", "\<\"LineOpacity\"\>"},
    {"2449", "670.`", "\<\"LineSpacing\"\>"},
    {"2450", "670.`", "\<\"LineWrapParts\"\>"},
    {"2451", "670.`", "\<\"LinkActivate\"\>"},
    {"2452", "670.`", "\<\"LinkClose\"\>"},
    {"2453", "670.`", "\<\"LinkConnect\"\>"},
    {"2454", "670.`", "\<\"LinkConnectedQ\"\>"},
    {"2455", "670.`", "\<\"LinkCreate\"\>"},
    {"2456", "670.`", "\<\"LinkError\"\>"},
    {"2457", "670.`", "\<\"LinkFlush\"\>"},
    {"2458", "670.`", "\<\"LinkFunction\"\>"},
    {"2459", "670.`", "\<\"LinkHost\"\>"},
    {"2460", "670.`", "\<\"LinkInterrupt\"\>"},
    {"2461", "670.`", "\<\"LinkLaunch\"\>"},
    {"2462", "670.`", "\<\"LinkMode\"\>"},
    {"2463", "670.`", "\<\"LinkObject\"\>"},
    {"2464", "670.`", "\<\"LinkOpen\"\>"},
    {"2465", "670.`", "\<\"LinkOptions\"\>"},
    {"2466", "670.`", "\<\"LinkPatterns\"\>"},
    {"2467", "670.`", "\<\"LinkProtocol\"\>"},
    {"2468", "670.`", "\<\"LinkRead\"\>"},
    {"2469", "670.`", "\<\"LinkReadHeld\"\>"},
    {"2470", "670.`", "\<\"LinkReadyQ\"\>"},
    {"2471", "670.`", "\<\"Links\"\>"},
    {"2472", "670.`", "\<\"LinkWrite\"\>"},
    {"2473", "670.`", "\<\"LinkWriteHeld\"\>"},
    {"2474", "670.`", "\<\"LiouvilleLambda\"\>"},
    {"2475", "670.`", "\<\"List\"\>"},
    {"2476", "670.`", "\<\"Listable\"\>"},
    {"2477", "670.`", "\<\"ListAnimate\"\>"},
    {"2478", "670.`", "\<\"ListContourPlot\"\>"},
    {"2479", "670.`", "\<\"ListContourPlot3D\"\>"},
    {"2480", "670.`", "\<\"ListConvolve\"\>"},
    {"2481", "670.`", "\<\"ListCorrelate\"\>"},
    {"2482", "670.`", "\<\"ListCurvePathPlot\"\>"},
    {"2483", "670.`", "\<\"ListDeconvolve\"\>"},
    {"2484", "670.`", "\<\"ListDensityPlot\"\>"},
    {"2485", "670.`", "\<\"Listen\"\>"},
    {"2486", "670.`", "\<\"ListFourierSequenceTransform\"\>"},
    {"2487", "670.`", "\<\"ListInterpolation\"\>"},
    {"2488", "670.`", "\<\"ListLineIntegralConvolutionPlot\"\>"},
    {"2489", "670.`", "\<\"ListLinePlot\"\>"},
    {"2490", "670.`", "\<\"ListLogLinearPlot\"\>"},
    {"2491", "670.`", "\<\"ListLogLogPlot\"\>"},
    {"2492", "670.`", "\<\"ListLogPlot\"\>"},
    {"2493", "670.`", "\<\"ListPicker\"\>"},
    {"2494", "670.`", "\<\"ListPickerBox\"\>"},
    {"2495", "670.`", "\<\"ListPickerBoxBackground\"\>"},
    {"2496", "670.`", "\<\"ListPickerBoxOptions\"\>"},
    {"2497", "670.`", "\<\"ListPlay\"\>"},
    {"2498", "670.`", "\<\"ListPlot\"\>"},
    {"2499", "670.`", "\<\"ListPlot3D\"\>"},
    {"2500", "670.`", "\<\"ListPointPlot3D\"\>"},
    {"2501", "670.`", "\<\"ListPolarPlot\"\>"},
    {"2502", "670.`", "\<\"ListQ\"\>"},
    {"2503", "670.`", "\<\"ListStreamDensityPlot\"\>"},
    {"2504", "670.`", "\<\"ListStreamPlot\"\>"},
    {"2505", "670.`", "\<\"ListSurfacePlot3D\"\>"},
    {"2506", "670.`", "\<\"ListVectorDensityPlot\"\>"},
    {"2507", "670.`", "\<\"ListVectorPlot\"\>"},
    {"2508", "670.`", "\<\"ListVectorPlot3D\"\>"},
    {"2509", "670.`", "\<\"ListZTransform\"\>"},
    {"2510", "670.`", "\<\"Literal\"\>"},
    {"2511", "670.`", "\<\"LiteralSearch\"\>"},
    {"2512", "670.`", "\<\"LocalClusteringCoefficient\"\>"},
    {"2513", "670.`", "\<\"LocalizeVariables\"\>"},
    {"2514", "670.`", "\<\"LocationEquivalenceTest\"\>"},
    {"2515", "670.`", "\<\"LocationTest\"\>"},
    {"2516", "670.`", "\<\"Locator\"\>"},
    {"2517", "670.`", "\<\"LocatorAutoCreate\"\>"},
    {"2518", "670.`", "\<\"LocatorBox\"\>"},
    {"2519", "670.`", "\<\"LocatorBoxOptions\"\>"},
    {"2520", "670.`", "\<\"LocatorCentering\"\>"},
    {"2521", "670.`", "\<\"LocatorPane\"\>"},
    {"2522", "670.`", "\<\"LocatorPaneBox\"\>"},
    {"2523", "670.`", "\<\"LocatorPaneBoxOptions\"\>"},
    {"2524", "670.`", "\<\"LocatorRegion\"\>"},
    {"2525", "670.`", "\<\"Locked\"\>"},
    {"2526", "670.`", "\<\"Log\"\>"},
    {"2527", "670.`", "\<\"Log10\"\>"},
    {"2528", "670.`", "\<\"Log2\"\>"},
    {"2529", "670.`", "\<\"LogBarnesG\"\>"},
    {"2530", "670.`", "\<\"LogGamma\"\>"},
    {"2531", "670.`", "\<\"LogGammaDistribution\"\>"},
    {"2532", "670.`", "\<\"LogicalExpand\"\>"},
    {"2533", "670.`", "\<\"LogIntegral\"\>"},
    {"2534", "670.`", "\<\"LogisticDistribution\"\>"},
    {"2535", "670.`", "\<\"LogitModelFit\"\>"},
    {"2536", "670.`", "\<\"LogLikelihood\"\>"},
    {"2537", "670.`", "\<\"LogLinearPlot\"\>"},
    {"2538", "670.`", "\<\"LogLogisticDistribution\"\>"},
    {"2539", "670.`", "\<\"LogLogPlot\"\>"},
    {"2540", "670.`", "\<\"LogMultinormalDistribution\"\>"},
    {"2541", "670.`", "\<\"LogNormalDistribution\"\>"},
    {"2542", "670.`", "\<\"LogPlot\"\>"},
    {"2543", "670.`", "\<\"LogRankTest\"\>"},
    {"2544", "670.`", "\<\"LogSeriesDistribution\"\>"},
    {"2545", "670.`", "\<\"LongEqual\"\>"},
    {"2546", "670.`", "\<\"Longest\"\>"},
    {"2547", "670.`", "\<\"LongestAscendingSequence\"\>"},
    {"2548", "670.`", "\<\"LongestCommonSequence\"\>"},
    {"2549", "670.`", "\<\"LongestCommonSequencePositions\"\>"},
    {"2550", "670.`", "\<\"LongestCommonSubsequence\"\>"},
    {"2551", "670.`", "\<\"LongestCommonSubsequencePositions\"\>"},
    {"2552", "670.`", "\<\"LongestMatch\"\>"},
    {"2553", "670.`", "\<\"LongForm\"\>"},
    {"2554", "670.`", "\<\"Longitude\"\>"},
    {"2555", "670.`", "\<\"Loopback\"\>"},
    {"2556", "670.`", "\<\"LoopFreeGraphQ\"\>"},
    {"2557", "670.`", "\<\"LowerCaseQ\"\>"},
    {"2558", "670.`", "\<\"LowerTriangularize\"\>"},
    {"2559", "670.`", "\<\"LowpassFilter\"\>"},
    {"2560", "670.`", "\<\"LQEstimatorGains\"\>"},
    {"2561", "670.`", "\<\"LQGRegulator\"\>"},
    {"2562", "670.`", "\<\"LQOutputRegulatorGains\"\>"},
    {"2563", "670.`", "\<\"LQRegulatorGains\"\>"},
    {"2564", "670.`", "\<\"LUBackSubstitution\"\>"},
    {"2565", "670.`", "\<\"LucasL\"\>"},
    {"2566", "670.`", "\<\"LuccioSamiComponents\"\>"},
    {"2567", "670.`", "\<\"LUDecomposition\"\>"},
    {"2568", "670.`", "\<\"LyapunovSolve\"\>"},
    {"2569", "670.`", "\<\"LyonsGroupLy\"\>"},
    {"2570", "670.`", "\<\"MachineID\"\>"},
    {"2571", "670.`", "\<\"MachineName\"\>"},
    {"2572", "670.`", "\<\"MachineNumberQ\"\>"},
    {"2573", "670.`", "\<\"MachinePrecision\"\>"},
    {"2574", "670.`", "\<\"MacintoshSystemPageSetup\"\>"},
    {"2575", "670.`", "\<\"Magnification\"\>"},
    {"2576", "670.`", "\<\"Magnify\"\>"},
    {"2577", "670.`", "\<\"MainSolve\"\>"},
    {"2578", "670.`", "\<\"MaintainDynamicCaches\"\>"},
    {"2579", "670.`", "\<\"Majority\"\>"},
    {"2580", "670.`", "\<\"MakeBoxes\"\>"},
    {"2581", "670.`", "\<\"MakeExpression\"\>"},
    {"2582", "670.`", "\<\"MakeRules\"\>"},
    {"2583", "670.`", "\<\"MangoldtLambda\"\>"},
    {"2584", "670.`", "\<\"ManhattanDistance\"\>"},
    {"2585", "670.`", "\<\"Manipulate\"\>"},
    {"2586", "670.`", "\<\"Manipulator\"\>"},
    {"2587", "670.`", "\<\"MannWhitneyTest\"\>"},
    {"2588", "670.`", "\<\"MantissaExponent\"\>"},
    {"2589", "670.`", "\<\"Manual\"\>"},
    {"2590", "670.`", "\<\"MapAt\"\>"},
    {"2591", "670.`", "\<\"MapIndexed\"\>"},
    {"2592", "670.`", "\<\"MAProcess\"\>"},
    {"2593", "670.`", "\<\"MapThread\"\>"},
    {"2594", "670.`", "\<\"MarcumQ\"\>"},
    {"2595", "670.`", "\<\"MardiaCombinedTest\"\>"},
    {"2596", "670.`", "\<\"MardiaKurtosisTest\"\>"},
    {"2597", "670.`", "\<\"MardiaSkewnessTest\"\>"},
    {"2598", "670.`", "\<\"MarginalDistribution\"\>"},
    {"2599", "670.`", "\<\"MarkovProcessProperties\"\>"},
    {"2600", "670.`", "\<\"Masking\"\>"},
    {"2601", "670.`", "\<\"MatchingDissimilarity\"\>"},
    {"2602", "670.`", "\<\"MatchLocalNameQ\"\>"},
    {"2603", "670.`", "\<\"MatchLocalNames\"\>"},
    {"2604", "670.`", "\<\"MatchQ\"\>"},
    {"2605", "670.`", "\<\"Material\"\>"},
    {"2606", "670.`", "\<\"MathematicaNotation\"\>"},
    {"2607", "670.`", "\<\"MathieuC\"\>"},
    {"2608", "670.`", "\<\"MathieuCharacteristicA\"\>"},
    {"2609", "670.`", "\<\"MathieuCharacteristicB\"\>"},
    {"2610", "670.`", "\<\"MathieuCharacteristicExponent\"\>"},
    {"2611", "670.`", "\<\"MathieuCPrime\"\>"},
    {"2612", "670.`", "\<\"MathieuGroupM11\"\>"},
    {"2613", "670.`", "\<\"MathieuGroupM12\"\>"},
    {"2614", "670.`", "\<\"MathieuGroupM22\"\>"},
    {"2615", "670.`", "\<\"MathieuGroupM23\"\>"},
    {"2616", "670.`", "\<\"MathieuGroupM24\"\>"},
    {"2617", "670.`", "\<\"MathieuS\"\>"},
    {"2618", "670.`", "\<\"MathieuSPrime\"\>"},
    {"2619", "670.`", "\<\"MathMLForm\"\>"},
    {"2620", "670.`", "\<\"MathMLText\"\>"},
    {"2621", "670.`", "\<\"Matrices\"\>"},
    {"2622", "670.`", "\<\"MatrixExp\"\>"},
    {"2623", "670.`", "\<\"MatrixForm\"\>"},
    {"2624", "670.`", "\<\"MatrixFunction\"\>"},
    {"2625", "670.`", "\<\"MatrixLog\"\>"},
    {"2626", "670.`", "\<\"MatrixPlot\"\>"},
    {"2627", "670.`", "\<\"MatrixPower\"\>"},
    {"2628", "670.`", "\<\"MatrixQ\"\>"},
    {"2629", "670.`", "\<\"MatrixRank\"\>"},
    {"2630", "670.`", "\<\"Max\"\>"},
    {"2631", "670.`", "\<\"MaxBend\"\>"},
    {"2632", "670.`", "\<\"MaxDetect\"\>"},
    {"2633", "670.`", "\<\"MaxExtraBandwidths\"\>"},
    {"2634", "670.`", "\<\"MaxExtraConditions\"\>"},
    {"2635", "670.`", "\<\"MaxFeatures\"\>"},
    {"2636", "670.`", "\<\"MaxFilter\"\>"},
    {"2637", "670.`", "\<\"Maximize\"\>"},
    {"2638", "670.`", "\<\"MaxIterations\"\>"},
    {"2639", "670.`", "\<\"MaxMemoryUsed\"\>"},
    {"2640", "670.`", "\<\"MaxMixtureKernels\"\>"},
    {"2641", "670.`", "\<\"MaxPlotPoints\"\>"},
    {"2642", "670.`", "\<\"MaxPoints\"\>"},
    {"2643", "670.`", "\<\"MaxRecursion\"\>"},
    {"2644", "670.`", "\<\"MaxStableDistribution\"\>"},
    {"2645", "670.`", "\<\"MaxStepFraction\"\>"},
    {"2646", "670.`", "\<\"MaxSteps\"\>"},
    {"2647", "670.`", "\<\"MaxStepSize\"\>"},
    {"2648", "670.`", "\<\"MaxValue\"\>"},
    {"2649", "670.`", "\<\"MaxwellDistribution\"\>"},
    {"2650", "670.`", "\<\"McLaughlinGroupMcL\"\>"},
    {"2651", "670.`", "\<\"Mean\"\>"},
    {"2652", "670.`", "\<\"MeanClusteringCoefficient\"\>"},
    {"2653", "670.`", "\<\"MeanDegreeConnectivity\"\>"},
    {"2654", "670.`", "\<\"MeanDeviation\"\>"},
    {"2655", "670.`", "\<\"MeanFilter\"\>"},
    {"2656", "670.`", "\<\"MeanGraphDistance\"\>"},
    {"2657", "670.`", "\<\"MeanNeighborDegree\"\>"},
    {"2658", "670.`", "\<\"MeanShift\"\>"},
    {"2659", "670.`", "\<\"MeanShiftFilter\"\>"},
    {"2660", "670.`", "\<\"Median\"\>"},
    {"2661", "670.`", "\<\"MedianDeviation\"\>"},
    {"2662", "670.`", "\<\"MedianFilter\"\>"},
    {"2663", "670.`", "\<\"Medium\"\>"},
    {"2664", "670.`", "\<\"MeijerG\"\>"},
    {"2665", "670.`", "\<\"MeixnerDistribution\"\>"},
    {"2666", "670.`", "\<\"MemberQ\"\>"},
    {"2667", "670.`", "\<\"MemoryConstrained\"\>"},
    {"2668", "670.`", "\<\"MemoryInUse\"\>"},
    {"2669", "670.`", "\<\"Menu\"\>"},
    {"2670", "670.`", "\<\"MenuAppearance\"\>"},
    {"2671", "670.`", "\<\"MenuCommandKey\"\>"},
    {"2672", "670.`", "\<\"MenuItem\"\>"},
    {"2673", "670.`", "\<\"MenuPacket\"\>"},
    {"2674", "670.`", "\<\"MenuSortingValue\"\>"},
    {"2675", "670.`", "\<\"MenuStyle\"\>"},
    {"2676", "670.`", "\<\"MenuView\"\>"},
    {"2677", "670.`", "\<\"MergeDifferences\"\>"},
    {"2678", "670.`", "\<\"Mesh\"\>"},
    {"2679", "670.`", "\<\"MeshFunctions\"\>"},
    {"2680", "670.`", "\<\"MeshRange\"\>"},
    {"2681", "670.`", "\<\"MeshShading\"\>"},
    {"2682", "670.`", "\<\"MeshStyle\"\>"},
    {"2683", "670.`", "\<\"Message\"\>"},
    {"2684", "670.`", "\<\"MessageDialog\"\>"},
    {"2685", "670.`", "\<\"MessageList\"\>"},
    {"2686", "670.`", "\<\"MessageOptions\"\>"},
    {"2687", "670.`", "\<\"MessagePacket\"\>"},
    {"2688", "670.`", "\<\"Messages\"\>"},
    {"2689", "670.`", "\<\"MessagesNotebook\"\>"},
    {"2690", "670.`", "\<\"MetaCharacters\"\>"},
    {"2691", "670.`", "\<\"MetaInformation\"\>"},
    {"2692", "670.`", "\<\"Method\"\>"},
    {"2693", "670.`", "\<\"MethodOptions\"\>"},
    {"2694", "670.`", "\<\"MexicanHatWavelet\"\>"},
    {"2695", "670.`", "\<\"MeyerWavelet\"\>"},
    {"2696", "670.`", "\<\"Min\"\>"},
    {"2697", "670.`", "\<\"MinDetect\"\>"},
    {"2698", "670.`", "\<\"MinFilter\"\>"},
    {"2699", "670.`", "\<\"MinimalPolynomial\"\>"},
    {"2700", "670.`", "\<\"MinimalStateSpaceModel\"\>"},
    {"2701", "670.`", "\<\"Minimize\"\>"},
    {"2702", "670.`", "\<\"Minors\"\>"},
    {"2703", "670.`", "\<\"MinRecursion\"\>"},
    {"2704", "670.`", "\<\"MinSize\"\>"},
    {"2705", "670.`", "\<\"MinStableDistribution\"\>"},
    {"2706", "670.`", "\<\"MinValue\"\>"},
    {"2707", "670.`", "\<\"Missing\"\>"},
    {"2708", "670.`", "\<\"MissingDataMethod\"\>"},
    {"2709", "670.`", "\<\"MittagLefflerE\"\>"},
    {"2710", "670.`", "\<\"MixedRadix\"\>"},
    {"2711", "670.`", "\<\"MixedRadixQuantity\"\>"},
    {"2712", "670.`", "\<\"MixtureDistribution\"\>"},
    {"2713", "670.`", "\<\"Modal\"\>"},
    {"2714", "670.`", "\<\"Mode\"\>"},
    {"2715", "670.`", "\<\"Modular\"\>"},
    {"2716", "670.`", "\<\"ModularLambda\"\>"},
    {"2717", "670.`", "\<\"Module\"\>"},
    {"2718", "670.`", "\<\"Modulus\"\>"},
    {"2719", "670.`", "\<\"MoebiusMu\"\>"},
    {"2720", "670.`", "\<\"Moment\"\>"},
    {"2721", "670.`", "\<\"Momentary\"\>"},
    {"2722", "670.`", "\<\"MomentConvert\"\>"},
    {"2723", "670.`", "\<\"MomentEvaluate\"\>"},
    {"2724", "670.`", "\<\"MomentGeneratingFunction\"\>"},
    {"2725", "670.`", "\<\"Monday\"\>"},
    {"2726", "670.`", "\<\"Monitor\"\>"},
    {"2727", "670.`", "\<\"MonomialList\"\>"},
    {"2728", "670.`", "\<\"MonomialOrder\"\>"},
    {"2729", "670.`", "\<\"MonsterGroupM\"\>"},
    {"2730", "670.`", "\<\"MorletWavelet\"\>"},
    {"2731", "670.`", "\<\"MorphologicalBinarize\"\>"},
    {"2732", "670.`", "\<\"MorphologicalBranchPoints\"\>"},
    {"2733", "670.`", "\<\"MorphologicalComponents\"\>"},
    {"2734", "670.`", "\<\"MorphologicalEulerNumber\"\>"},
    {"2735", "670.`", "\<\"MorphologicalGraph\"\>"},
    {"2736", "670.`", "\<\"MorphologicalPerimeter\"\>"},
    {"2737", "670.`", "\<\"MorphologicalTransform\"\>"},
    {"2738", "670.`", "\<\"Most\"\>"},
    {"2739", "670.`", "\<\"MouseAnnotation\"\>"},
    {"2740", "670.`", "\<\"MouseAppearance\"\>"},
    {"2741", "670.`", "\<\"MouseAppearanceTag\"\>"},
    {"2742", "670.`", "\<\"MouseButtons\"\>"},
    {"2743", "670.`", "\<\"Mouseover\"\>"},
    {"2744", "670.`", "\<\"MousePointerNote\"\>"},
    {"2745", "670.`", "\<\"MousePosition\"\>"},
    {"2746", "670.`", "\<\"MovingAverage\"\>"},
    {"2747", "670.`", "\<\"MovingMedian\"\>"},
    {"2748", "670.`", "\<\"MoyalDistribution\"\>"},
    {"2749", "670.`", "\<\"MultiedgeStyle\"\>"},
    {"2750", "670.`", "\<\"MultilaunchWarning\"\>"},
    {"2751", "670.`", "\<\"MultiLetterItalics\"\>"},
    {"2752", "670.`", "\<\"MultiLetterStyle\"\>"},
    {"2753", "670.`", "\<\"MultilineFunction\"\>"},
    {"2754", "670.`", "\<\"Multinomial\"\>"},
    {"2755", "670.`", "\<\"MultinomialDistribution\"\>"},
    {"2756", "670.`", "\<\"MultinormalDistribution\"\>"},
    {"2757", "670.`", "\<\"MultiplicativeOrder\"\>"},
    {"2758", "670.`", "\<\"Multiplicity\"\>"},
    {"2759", "670.`", "\<\"Multiselection\"\>"},
    {"2760", "670.`", "\<\"MultivariateHypergeometricDistribution\"\>"},
    {"2761", "670.`", "\<\"MultivariatePoissonDistribution\"\>"},
    {"2762", "670.`", "\<\"MultivariateTDistribution\"\>"},
    {"2763", "670.`", "\<\"N\"\>"},
    {"2764", "670.`", "\<\"NakagamiDistribution\"\>"},
    {"2765", "670.`", "\<\"NameQ\"\>"},
    {"2766", "670.`", "\<\"Names\"\>"},
    {"2767", "670.`", "\<\"NamespaceBox\"\>"},
    {"2768", "670.`", "\<\"NArgMax\"\>"},
    {"2769", "670.`", "\<\"NArgMin\"\>"},
    {"2770", "670.`", "\<\"NBernoulliB\"\>"},
    {"2771", "670.`", "\<\"NCache\"\>"},
    {"2772", "670.`", "\<\"NDSolve\"\>"},
    {"2773", "670.`", "\<\"NDSolveValue\"\>"},
    {"2774", "670.`", "\<\"Nearest\"\>"},
    {"2775", "670.`", "\<\"NearestFunction\"\>"},
    {"2776", "670.`", "\<\"NeedCurrentFrontEndPackagePacket\"\>"},
    {"2777", "670.`", "\<\"NeedCurrentFrontEndSymbolsPacket\"\>"},
    {"2778", "670.`", "\<\"NeedlemanWunschSimilarity\"\>"},
    {"2779", "670.`", "\<\"Needs\"\>"},
    {"2780", "670.`", "\<\"Negative\"\>"},
    {"2781", "670.`", "\<\"NegativeBinomialDistribution\"\>"},
    {"2782", "670.`", "\<\"NegativeMultinomialDistribution\"\>"},
    {"2783", "670.`", "\<\"NeighborhoodGraph\"\>"},
    {"2784", "670.`", "\<\"Nest\"\>"},
    {"2785", "670.`", "\<\"NestedScriptRules\"\>"},
    {"2786", "670.`", "\<\"NestList\"\>"},
    {"2787", "670.`", "\<\"NestWhile\"\>"},
    {"2788", "670.`", "\<\"NestWhileList\"\>"},
    {"2789", "670.`", "\<\"NevilleThetaC\"\>"},
    {"2790", "670.`", "\<\"NevilleThetaD\"\>"},
    {"2791", "670.`", "\<\"NevilleThetaN\"\>"},
    {"2792", "670.`", "\<\"NevilleThetaS\"\>"},
    {"2793", "670.`", "\<\"NewPrimitiveStyle\"\>"},
    {"2794", "670.`", "\<\"NExpectation\"\>"},
    {"2795", "670.`", "\<\"Next\"\>"},
    {"2796", "670.`", "\<\"NextPrime\"\>"},
    {"2797", "670.`", "\<\"NHoldAll\"\>"},
    {"2798", "670.`", "\<\"NHoldFirst\"\>"},
    {"2799", "670.`", "\<\"NHoldRest\"\>"},
    {"2800", "670.`", "\<\"NicholsGridLines\"\>"},
    {"2801", "670.`", "\<\"NicholsPlot\"\>"},
    {"2802", "670.`", "\<\"NIntegrate\"\>"},
    {"2803", "670.`", "\<\"NMaximize\"\>"},
    {"2804", "670.`", "\<\"NMaxValue\"\>"},
    {"2805", "670.`", "\<\"NMinimize\"\>"},
    {"2806", "670.`", "\<\"NMinValue\"\>"},
    {"2807", "670.`", "\<\"NominalVariables\"\>"},
    {"2808", "670.`", "\<\"NonAssociative\"\>"},
    {"2809", "670.`", "\<\"NoncentralBetaDistribution\"\>"},
    {"2810", "670.`", "\<\"NoncentralChiSquareDistribution\"\>"},
    {"2811", "670.`", "\<\"NoncentralFRatioDistribution\"\>"},
    {"2812", "670.`", "\<\"NoncentralStudentTDistribution\"\>"},
    {"2813", "670.`", "\<\"NonConstants\"\>"},
    {"2814", "670.`", "\<\"None\"\>"},
    {"2815", "670.`", "\<\"NonlinearModelFit\"\>"},
    {"2816", "670.`", "\<\"NonlocalMeansFilter\"\>"},
    {"2817", "670.`", "\<\"NonNegative\"\>"},
    {"2818", "670.`", "\<\"NonPositive\"\>"},
    {"2819", "670.`", "\<\"NorlundB\"\>"},
    {"2820", "670.`", "\<\"Norm\"\>"},
    {"2821", "670.`", "\<\"Normal\"\>"},
    {"2822", "670.`", "\<\"NormalDistribution\"\>"},
    {"2823", "670.`", "\<\"NormalGrouping\"\>"},
    {"2824", "670.`", "\<\"Normalize\"\>"},
    {"2825", "670.`", "\<\"NormalizedSquaredEuclideanDistance\"\>"},
    {"2826", "670.`", "\<\"NormalsFunction\"\>"},
    {"2827", "670.`", "\<\"NormFunction\"\>"},
    {"2828", "670.`", "\<\"Notebook\"\>"},
    {"2829", "670.`", "\<\"NotebookApply\"\>"},
    {"2830", "670.`", "\<\"NotebookAutoSave\"\>"},
    {"2831", "670.`", "\<\"NotebookClose\"\>"},
    {"2832", "670.`", "\<\"NotebookConvertSettings\"\>"},
    {"2833", "670.`", "\<\"NotebookCreate\"\>"},
    {"2834", "670.`", "\<\"NotebookCreateReturnObject\"\>"},
    {"2835", "670.`", "\<\"NotebookDefault\"\>"},
    {"2836", "670.`", "\<\"NotebookDelete\"\>"},
    {"2837", "670.`", "\<\"NotebookDirectory\"\>"},
    {"2838", "670.`", "\<\"NotebookDynamicExpression\"\>"},
    {"2839", "670.`", "\<\"NotebookEvaluate\"\>"},
    {"2840", "670.`", "\<\"NotebookEventActions\"\>"},
    {"2841", "670.`", "\<\"NotebookFileName\"\>"},
    {"2842", "670.`", "\<\"NotebookFind\"\>"},
    {"2843", "670.`", "\<\"NotebookFindReturnObject\"\>"},
    {"2844", "670.`", "\<\"NotebookGet\"\>"},
    {"2845", "670.`", "\<\"NotebookGetLayoutInformationPacket\"\>"},
    {"2846", "670.`", "\<\"NotebookGetMisspellingsPacket\"\>"},
    {"2847", "670.`", "\<\"NotebookInformation\"\>"},
    {"2848", "670.`", "\<\"NotebookInterfaceObject\"\>"},
    {"2849", "670.`", "\<\"NotebookLocate\"\>"},
    {"2850", "670.`", "\<\"NotebookObject\"\>"},
    {"2851", "670.`", "\<\"NotebookOpen\"\>"},
    {"2852", "670.`", "\<\"NotebookOpenReturnObject\"\>"},
    {"2853", "670.`", "\<\"NotebookPath\"\>"},
    {"2854", "670.`", "\<\"NotebookPrint\"\>"},
    {"2855", "670.`", "\<\"NotebookPut\"\>"},
    {"2856", "670.`", "\<\"NotebookPutReturnObject\"\>"},
    {"2857", "670.`", "\<\"NotebookRead\"\>"},
    {"2858", "670.`", "\<\"NotebookResetGeneratedCells\"\>"},
    {"2859", "670.`", "\<\"Notebooks\"\>"},
    {"2860", "670.`", "\<\"NotebookSave\"\>"},
    {"2861", "670.`", "\<\"NotebookSaveAs\"\>"},
    {"2862", "670.`", "\<\"NotebookSelection\"\>"},
    {"2863", "670.`", "\<\"NotebookSetupLayoutInformationPacket\"\>"},
    {"2864", "670.`", "\<\"NotebooksMenu\"\>"},
    {"2865", "670.`", "\<\"NotebookWrite\"\>"},
    {"2866", "670.`", "\<\"NProbability\"\>"},
    {"2867", "670.`", "\<\"NProduct\"\>"},
    {"2868", "670.`", "\<\"NProductFactors\"\>"},
    {"2869", "670.`", "\<\"NRoots\"\>"},
    {"2870", "670.`", "\<\"NSolve\"\>"},
    {"2871", "670.`", "\<\"NSum\"\>"},
    {"2872", "670.`", "\<\"NSumTerms\"\>"},
    {"2873", "670.`", "\<\"Null\"\>"},
    {"2874", "670.`", "\<\"NullRecords\"\>"},
    {"2875", "670.`", "\<\"NullSpace\"\>"},
    {"2876", "670.`", "\<\"NullWords\"\>"},
    {"2877", "670.`", "\<\"Number\"\>"},
    {"2878", "670.`", "\<\"NumberFieldClassNumber\"\>"},
    {"2879", "670.`", "\<\"NumberFieldDiscriminant\"\>"},
    {"2880", "670.`", "\<\"NumberFieldFundamentalUnits\"\>"},
    {"2881", "670.`", "\<\"NumberFieldIntegralBasis\"\>"},
    {"2882", "670.`", "\<\"NumberFieldNormRepresentatives\"\>"},
    {"2883", "670.`", "\<\"NumberFieldRegulator\"\>"},
    {"2884", "670.`", "\<\"NumberFieldRootsOfUnity\"\>"},
    {"2885", "670.`", "\<\"NumberFieldSignature\"\>"},
    {"2886", "670.`", "\<\"NumberForm\"\>"},
    {"2887", "670.`", "\<\"NumberFormat\"\>"},
    {"2888", "670.`", "\<\"NumberMarks\"\>"},
    {"2889", "670.`", "\<\"NumberMultiplier\"\>"},
    {"2890", "670.`", "\<\"NumberPadding\"\>"},
    {"2891", "670.`", "\<\"NumberPoint\"\>"},
    {"2892", "670.`", "\<\"NumberQ\"\>"},
    {"2893", "670.`", "\<\"NumberSeparator\"\>"},
    {"2894", "670.`", "\<\"NumberSigns\"\>"},
    {"2895", "670.`", "\<\"NumberString\"\>"},
    {"2896", "670.`", "\<\"Numerator\"\>"},
    {"2897", "670.`", "\<\"NumericFunction\"\>"},
    {"2898", "670.`", "\<\"NumericQ\"\>"},
    {"2899", "670.`", "\<\"NuttallWindow\"\>"},
    {"2900", "670.`", "\<\"NValues\"\>"},
    {"2901", "670.`", "\<\"NyquistGridLines\"\>"},
    {"2902", "670.`", "\<\"NyquistPlot\"\>"},
    {"2903", "670.`", "\<\"O\"\>"},
    {"2904", "670.`", "\<\"ObservabilityGramian\"\>"},
    {"2905", "670.`", "\<\"ObservabilityMatrix\"\>"},
    {"2906", "670.`", "\<\"ObservableDecomposition\"\>"},
    {"2907", "670.`", "\<\"ObservableModelQ\"\>"},
    {"2908", "670.`", "\<\"OddQ\"\>"},
    {"2909", "670.`", "\<\"Off\"\>"},
    {"2910", "670.`", "\<\"Offset\"\>"},
    {"2911", "670.`", "\<\"OLEData\"\>"},
    {"2912", "670.`", "\<\"On\"\>"},
    {"2913", "670.`", "\<\"ONanGroupON\"\>"},
    {"2914", "670.`", "\<\"OneIdentity\"\>"},
    {"2915", "670.`", "\<\"Opacity\"\>"},
    {"2916", "670.`", "\<\"Open\"\>"},
    {"2917", "670.`", "\<\"OpenAppend\"\>"},
    {"2918", "670.`", "\<\"Opener\"\>"},
    {"2919", "670.`", "\<\"OpenerBox\"\>"},
    {"2920", "670.`", "\<\"OpenerBoxOptions\"\>"},
    {"2921", "670.`", "\<\"OpenerView\"\>"},
    {"2922", "670.`", "\<\"OpenFunctionInspectorPacket\"\>"},
    {"2923", "670.`", "\<\"Opening\"\>"},
    {"2924", "670.`", "\<\"OpenRead\"\>"},
    {"2925", "670.`", "\<\"OpenSpecialOptions\"\>"},
    {"2926", "670.`", "\<\"OpenTemporary\"\>"},
    {"2927", "670.`", "\<\"OpenWrite\"\>"},
    {"2928", "670.`", "\<\"Operate\"\>"},
    {"2929", "670.`", "\<\"OperatingSystem\"\>"},
    {"2930", "670.`", "\<\"OptimumFlowData\"\>"},
    {"2931", "670.`", "\<\"OptionInspectorSettings\"\>"},
    {"2932", "670.`", "\<\"OptionQ\"\>"},
    {"2933", "670.`", "\<\"Options\"\>"},
    {"2934", "670.`", "\<\"OptionsPacket\"\>"},
    {"2935", "670.`", "\<\"OptionsPattern\"\>"},
    {"2936", "670.`", "\<\"OptionValue\"\>"},
    {"2937", "670.`", "\<\"OptionValueBox\"\>"},
    {"2938", "670.`", "\<\"OptionValueBoxOptions\"\>"},
    {"2939", "670.`", "\<\"Order\"\>"},
    {"2940", "670.`", "\<\"OrderDistribution\"\>"},
    {"2941", "670.`", "\<\"OrderedQ\"\>"},
    {"2942", "670.`", "\<\"Ordering\"\>"},
    {"2943", "670.`", "\<\"Orderless\"\>"},
    {"2944", "670.`", "\<\"OrnsteinUhlenbeckProcess\"\>"},
    {"2945", "670.`", "\<\"Orthogonalize\"\>"},
    {"2946", "670.`", "\<\"Out\"\>"},
    {"2947", "670.`", "\<\"Outer\"\>"},
    {"2948", "670.`", "\<\"OutputAutoOverwrite\"\>"},
    {"2949", "670.`", "\<\"OutputControllabilityMatrix\"\>"},
    {"2950", "670.`", "\<\"OutputControllableModelQ\"\>"},
    {"2951", "670.`", "\<\"OutputForm\"\>"},
    {"2952", "670.`", "\<\"OutputFormData\"\>"},
    {"2953", "670.`", "\<\"OutputGrouping\"\>"},
    {"2954", "670.`", "\<\"OutputMathEditExpression\"\>"},
    {"2955", "670.`", "\<\"OutputNamePacket\"\>"},
    {"2956", "670.`", "\<\"OutputResponse\"\>"},
    {"2957", "670.`", "\<\"OutputSizeLimit\"\>"},
    {"2958", "670.`", "\<\"OutputStream\"\>"},
    {"2959", "670.`", "\<\"Over\"\>"},
    {"2960", "670.`", "\<\"Overflow\"\>"},
    {"2961", "670.`", "\<\"Overlaps\"\>"},
    {"2962", "670.`", "\<\"Overlay\"\>"},
    {"2963", "670.`", "\<\"OverlayBox\"\>"},
    {"2964", "670.`", "\<\"OverlayBoxOptions\"\>"},
    {"2965", "670.`", "\<\"Overscript\"\>"},
    {"2966", "670.`", "\<\"OverscriptBoxOptions\"\>"},
    {"2967", "670.`", "\<\"OwenT\"\>"},
    {"2968", "670.`", "\<\"OwnValues\"\>"},
    {"2969", "670.`", "\<\"PackingMethod\"\>"},
    {"2970", "670.`", "\<\"PaddedForm\"\>"},
    {"2971", "670.`", "\<\"Padding\"\>"},
    {"2972", "670.`", "\<\"PadeApproximant\"\>"},
    {"2973", "670.`", "\<\"PadLeft\"\>"},
    {"2974", "670.`", "\<\"PadRight\"\>"},
    {"2975", "670.`", "\<\"PageBreakAbove\"\>"},
    {"2976", "670.`", "\<\"PageBreakBelow\"\>"},
    {"2977", "670.`", "\<\"PageBreakWithin\"\>"},
    {"2978", "670.`", "\<\"PageFooterLines\"\>"},
    {"2979", "670.`", "\<\"PageFooters\"\>"},
    {"2980", "670.`", "\<\"PageHeaderLines\"\>"},
    {"2981", "670.`", "\<\"PageHeaders\"\>"},
    {"2982", "670.`", "\<\"PageHeight\"\>"},
    {"2983", "670.`", "\<\"PageRankCentrality\"\>"},
    {"2984", "670.`", "\<\"PageWidth\"\>"},
    {"2985", "670.`", "\<\"PairedBarChart\"\>"},
    {"2986", "670.`", "\<\"PairedHistogram\"\>"},
    {"2987", "670.`", "\<\"PairedSmoothHistogram\"\>"},
    {"2988", "670.`", "\<\"PairedTTest\"\>"},
    {"2989", "670.`", "\<\"PairedZTest\"\>"},
    {"2990", "670.`", "\<\"PaletteNotebook\"\>"},
    {"2991", "670.`", "\<\"PalettePath\"\>"},
    {"2992", "670.`", "\<\"Pane\"\>"},
    {"2993", "670.`", "\<\"PaneBox\"\>"},
    {"2994", "670.`", "\<\"PaneBoxOptions\"\>"},
    {"2995", "670.`", "\<\"Panel\"\>"},
    {"2996", "670.`", "\<\"PanelBox\"\>"},
    {"2997", "670.`", "\<\"PanelBoxOptions\"\>"},
    {"2998", "670.`", "\<\"Paneled\"\>"},
    {"2999", "670.`", "\<\"PaneSelector\"\>"},
    {"3000", "670.`", "\<\"PaneSelectorBox\"\>"},
    {"3001", "670.`", "\<\"PaneSelectorBoxOptions\"\>"},
    {"3002", "670.`", "\<\"PaperWidth\"\>"},
    {"3003", "670.`", "\<\"ParabolicCylinderD\"\>"},
    {"3004", "670.`", "\<\"ParagraphIndent\"\>"},
    {"3005", "670.`", "\<\"ParagraphSpacing\"\>"},
    {"3006", "670.`", "\<\"ParallelArray\"\>"},
    {"3007", "670.`", "\<\"ParallelCombine\"\>"},
    {"3008", "670.`", "\<\"ParallelDo\"\>"},
    {"3009", "670.`", "\<\"ParallelEvaluate\"\>"},
    {"3010", "670.`", "\<\"Parallelization\"\>"},
    {"3011", "670.`", "\<\"Parallelize\"\>"},
    {"3012", "670.`", "\<\"ParallelMap\"\>"},
    {"3013", "670.`", "\<\"ParallelNeeds\"\>"},
    {"3014", "670.`", "\<\"ParallelProduct\"\>"},
    {"3015", "670.`", "\<\"ParallelSubmit\"\>"},
    {"3016", "670.`", "\<\"ParallelSum\"\>"},
    {"3017", "670.`", "\<\"ParallelTable\"\>"},
    {"3018", "670.`", "\<\"ParallelTry\"\>"},
    {"3019", "670.`", "\<\"Parameter\"\>"},
    {"3020", "670.`", "\<\"ParameterEstimator\"\>"},
    {"3021", "670.`", "\<\"ParameterMixtureDistribution\"\>"},
    {"3022", "670.`", "\<\"ParameterVariables\"\>"},
    {"3023", "670.`", "\<\"ParametricFunction\"\>"},
    {"3024", "670.`", "\<\"ParametricNDSolve\"\>"},
    {"3025", "670.`", "\<\"ParametricNDSolveValue\"\>"},
    {"3026", "670.`", "\<\"ParametricPlot\"\>"},
    {"3027", "670.`", "\<\"ParametricPlot3D\"\>"},
    {"3028", "670.`", "\<\"ParentConnect\"\>"},
    {"3029", "670.`", "\<\"ParentDirectory\"\>"},
    {"3030", "670.`", "\<\"ParentForm\"\>"},
    {"3031", "670.`", "\<\"Parenthesize\"\>"},
    {"3032", "670.`", "\<\"ParentList\"\>"},
    {"3033", "670.`", "\<\"ParetoDistribution\"\>"},
    {"3034", "670.`", "\<\"Part\"\>"},
    {"3035", "670.`", "\<\"PartialCorrelationFunction\"\>"},
    {"3036", "670.`", "\<\"PartialD\"\>"},
    {"3037", "670.`", "\<\"ParticleData\"\>"},
    {"3038", "670.`", "\<\"Partition\"\>"},
    {"3039", "670.`", "\<\"PartitionsP\"\>"},
    {"3040", "670.`", "\<\"PartitionsQ\"\>"},
    {"3041", "670.`", "\<\"ParzenWindow\"\>"},
    {"3042", "670.`", "\<\"PascalDistribution\"\>"},
    {"3043", "670.`", "\<\"PassEventsDown\"\>"},
    {"3044", "670.`", "\<\"PassEventsUp\"\>"},
    {"3045", "670.`", "\<\"Paste\"\>"},
    {"3046", "670.`", "\<\"PasteBoxFormInlineCells\"\>"},
    {"3047", "670.`", "\<\"PasteButton\"\>"},
    {"3048", "670.`", "\<\"Path\"\>"},
    {"3049", "670.`", "\<\"PathGraph\"\>"},
    {"3050", "670.`", "\<\"PathGraphQ\"\>"},
    {"3051", "670.`", "\<\"PatternSequence\"\>"},
    {"3052", "670.`", "\<\"PauliMatrix\"\>"},
    {"3053", "670.`", "\<\"PaulWavelet\"\>"},
    {"3054", "670.`", "\<\"Pause\"\>"},
    {"3055", "670.`", "\<\"PausedTime\"\>"},
    {"3056", "670.`", "\<\"PDF\"\>"},
    {"3057", "670.`", "\<\"PearsonChiSquareTest\"\>"},
    {"3058", "670.`", "\<\"PearsonCorrelationTest\"\>"},
    {"3059", "670.`", "\<\"PearsonDistribution\"\>"},
    {"3060", "670.`", "\<\"PerformanceGoal\"\>"},
    {"3061", "670.`", "\<\"PeriodicInterpolation\"\>"},
    {"3062", "670.`", "\<\"Periodogram\"\>"},
    {"3063", "670.`", "\<\"PeriodogramArray\"\>"},
    {"3064", "670.`", "\<\"PermutationCycles\"\>"},
    {"3065", "670.`", "\<\"PermutationCyclesQ\"\>"},
    {"3066", "670.`", "\<\"PermutationGroup\"\>"},
    {"3067", "670.`", "\<\"PermutationLength\"\>"},
    {"3068", "670.`", "\<\"PermutationList\"\>"},
    {"3069", "670.`", "\<\"PermutationListQ\"\>"},
    {"3070", "670.`", "\<\"PermutationMax\"\>"},
    {"3071", "670.`", "\<\"PermutationMin\"\>"},
    {"3072", "670.`", "\<\"PermutationOrder\"\>"},
    {"3073", "670.`", "\<\"PermutationPower\"\>"},
    {"3074", "670.`", "\<\"PermutationReplace\"\>"},
    {"3075", "670.`", "\<\"Permutations\"\>"},
    {"3076", "670.`", "\<\"PermutationSupport\"\>"},
    {"3077", "670.`", "\<\"Permute\"\>"},
    {"3078", "670.`", "\<\"PeronaMalikFilter\"\>"},
    {"3079", "670.`", "\<\"PERTDistribution\"\>"},
    {"3080", "670.`", "\<\"PetersenGraph\"\>"},
    {"3081", "670.`", "\<\"PhaseMargins\"\>"},
    {"3082", "670.`", "\<\"Pi\"\>"},
    {"3083", "670.`", "\<\"Pick\"\>"},
    {"3084", "670.`", "\<\"PIDData\"\>"},
    {"3085", "670.`", "\<\"PIDDerivativeFilter\"\>"},
    {"3086", "670.`", "\<\"PIDFeedforward\"\>"},
    {"3087", "670.`", "\<\"PIDTune\"\>"},
    {"3088", "670.`", "\<\"PiecewiseExpand\"\>"},
    {"3089", "670.`", "\<\"PieChart\"\>"},
    {"3090", "670.`", "\<\"PieChart3D\"\>"},
    {"3091", "670.`", "\<\"PillaiTrace\"\>"},
    {"3092", "670.`", "\<\"PillaiTraceTest\"\>"},
    {"3093", "670.`", "\<\"Pivoting\"\>"},
    {"3094", "670.`", "\<\"PixelConstrained\"\>"},
    {"3095", "670.`", "\<\"PixelValue\"\>"},
    {"3096", "670.`", "\<\"PixelValuePositions\"\>"},
    {"3097", "670.`", "\<\"Placed\"\>"},
    {"3098", "670.`", "\<\"Placeholder\"\>"},
    {"3099", "670.`", "\<\"PlaceholderReplace\"\>"},
    {"3100", "670.`", "\<\"Plain\"\>"},
    {"3101", "670.`", "\<\"PlanarGraphQ\"\>"},
    {"3102", "670.`", "\<\"Play\"\>"},
    {"3103", "670.`", "\<\"PlayRange\"\>"},
    {"3104", "670.`", "\<\"Plot\"\>"},
    {"3105", "670.`", "\<\"Plot3D\"\>"},
    {"3106", "670.`", "\<\"Plot3Matrix\"\>"},
    {"3107", "670.`", "\<\"PlotDivision\"\>"},
    {"3108", "670.`", "\<\"PlotJoined\"\>"},
    {"3109", "670.`", "\<\"PlotLabel\"\>"},
    {"3110", "670.`", "\<\"PlotLayout\"\>"},
    {"3111", "670.`", "\<\"PlotLegends\"\>"},
    {"3112", "670.`", "\<\"PlotMarkers\"\>"},
    {"3113", "670.`", "\<\"PlotPoints\"\>"},
    {"3114", "670.`", "\<\"PlotRange\"\>"},
    {"3115", "670.`", "\<\"PlotRangeClipping\"\>"},
    {"3116", "670.`", "\<\"PlotRangePadding\"\>"},
    {"3117", "670.`", "\<\"PlotRegion\"\>"},
    {"3118", "670.`", "\<\"PlotStyle\"\>"},
    {"3119", "670.`", "\<\"Pochhammer\"\>"},
    {"3120", "670.`", "\<\"PodStates\"\>"},
    {"3121", "670.`", "\<\"PodWidth\"\>"},
    {"3122", "670.`", "\<\"Point\"\>"},
    {"3123", "670.`", "\<\"Point3DBox\"\>"},
    {"3124", "670.`", "\<\"PointBox\"\>"},
    {"3125", "670.`", "\<\"PointFigureChart\"\>"},
    {"3126", "670.`", "\<\"PointForm\"\>"},
    {"3127", "670.`", "\<\"PointLegend\"\>"},
    {"3128", "670.`", "\<\"PointSize\"\>"},
    {"3129", "670.`", "\<\"PoissonConsulDistribution\"\>"},
    {"3130", "670.`", "\<\"PoissonDistribution\"\>"},
    {"3131", "670.`", "\<\"PoissonProcess\"\>"},
    {"3132", "670.`", "\<\"PoissonWindow\"\>"},
    {"3133", "670.`", "\<\"PolarAxes\"\>"},
    {"3134", "670.`", "\<\"PolarAxesOrigin\"\>"},
    {"3135", "670.`", "\<\"PolarGridLines\"\>"},
    {"3136", "670.`", "\<\"PolarPlot\"\>"},
    {"3137", "670.`", "\<\"PolarTicks\"\>"},
    {"3138", "670.`", "\<\"PoleZeroMarkers\"\>"},
    {"3139", "670.`", "\<\"PolyaAeppliDistribution\"\>"},
    {"3140", "670.`", "\<\"PolyGamma\"\>"},
    {"3141", "670.`", "\<\"Polygon\"\>"},
    {"3142", "670.`", "\<\"Polygon3DBox\"\>"},
    {"3143", "670.`", "\<\"Polygon3DBoxOptions\"\>"},
    {"3144", "670.`", "\<\"PolygonBox\"\>"},
    {"3145", "670.`", "\<\"PolygonBoxOptions\"\>"},
    {"3146", "670.`", "\<\"PolygonHoleScale\"\>"},
    {"3147", "670.`", "\<\"PolygonIntersections\"\>"},
    {"3148", "670.`", "\<\"PolygonScale\"\>"},
    {"3149", "670.`", "\<\"PolyhedronData\"\>"},
    {"3150", "670.`", "\<\"PolyLog\"\>"},
    {"3151", "670.`", "\<\"PolynomialExtendedGCD\"\>"},
    {"3152", "670.`", "\<\"PolynomialForm\"\>"},
    {"3153", "670.`", "\<\"PolynomialGCD\"\>"},
    {"3154", "670.`", "\<\"PolynomialLCM\"\>"},
    {"3155", "670.`", "\<\"PolynomialMod\"\>"},
    {"3156", "670.`", "\<\"PolynomialQ\"\>"},
    {"3157", "670.`", "\<\"PolynomialQuotient\"\>"},
    {"3158", "670.`", "\<\"PolynomialQuotientRemainder\"\>"},
    {"3159", "670.`", "\<\"PolynomialReduce\"\>"},
    {"3160", "670.`", "\<\"PolynomialRemainder\"\>"},
    {"3161", "670.`", "\<\"Polynomials\"\>"},
    {"3162", "670.`", "\<\"PopupMenu\"\>"},
    {"3163", "670.`", "\<\"PopupMenuBox\"\>"},
    {"3164", "670.`", "\<\"PopupMenuBoxOptions\"\>"},
    {"3165", "670.`", "\<\"PopupView\"\>"},
    {"3166", "670.`", "\<\"PopupWindow\"\>"},
    {"3167", "670.`", "\<\"Position\"\>"},
    {"3168", "670.`", "\<\"Positive\"\>"},
    {"3169", "670.`", "\<\"PositiveDefiniteMatrixQ\"\>"},
    {"3170", "670.`", "\<\"PossibleZeroQ\"\>"},
    {"3171", "670.`", "\<\"PostScript\"\>"},
    {"3172", "670.`", "\<\"PowerDistribution\"\>"},
    {"3173", "670.`", "\<\"PowerExpand\"\>"},
    {"3174", "670.`", "\<\"PowerMod\"\>"},
    {"3175", "670.`", "\<\"PowerModList\"\>"},
    {"3176", "670.`", "\<\"PowerSpectralDensity\"\>"},
    {"3177", "670.`", "\<\"PowersRepresentations\"\>"},
    {"3178", "670.`", "\<\"PowerSymmetricPolynomial\"\>"},
    {"3179", "670.`", "\<\"Precedence\"\>"},
    {"3180", "670.`", "\<\"PrecedenceForm\"\>"},
    {"3181", "670.`", "\<\"Precision\"\>"},
    {"3182", "670.`", "\<\"PrecisionGoal\"\>"},
    {"3183", "670.`", "\<\"PreemptProtect\"\>"},
    {"3184", "670.`", "\<\"PreferencesPath\"\>"},
    {"3185", "670.`", "\<\"Prepend\"\>"},
    {"3186", "670.`", "\<\"PrependTo\"\>"},
    {"3187", "670.`", "\<\"PreserveImageOptions\"\>"},
    {"3188", "670.`", "\<\"Previous\"\>"},
    {"3189", "670.`", "\<\"PriceGraphDistribution\"\>"},
    {"3190", "670.`", "\<\"PrimaryPlaceholder\"\>"},
    {"3191", "670.`", "\<\"Prime\"\>"},
    {"3192", "670.`", "\<\"PrimeNu\"\>"},
    {"3193", "670.`", "\<\"PrimeOmega\"\>"},
    {"3194", "670.`", "\<\"PrimePi\"\>"},
    {"3195", "670.`", "\<\"PrimePowerQ\"\>"},
    {"3196", "670.`", "\<\"PrimeQ\"\>"},
    {"3197", "670.`", "\<\"Primes\"\>"},
    {"3198", "670.`", "\<\"PrimeZetaP\"\>"},
    {"3199", "670.`", "\<\"PrimitiveRoot\"\>"},
    {"3200", "670.`", "\<\"PrincipalComponents\"\>"},
    {"3201", "670.`", "\<\"PrincipalValue\"\>"},
    {"3202", "670.`", "\<\"Print\"\>"},
    {"3203", "670.`", "\<\"PrintAction\"\>"},
    {"3204", "670.`", "\<\"PrintForm\"\>"},
    {"3205", "670.`", "\<\"PrintingCopies\"\>"},
    {"3206", "670.`", "\<\"PrintingOptions\"\>"},
    {"3207", "670.`", "\<\"PrintingPageRange\"\>"},
    {"3208", "670.`", "\<\"PrintingStartingPageNumber\"\>"},
    {"3209", "670.`", "\<\"PrintingStyleEnvironment\"\>"},
    {"3210", "670.`", "\<\"PrintPrecision\"\>"},
    {"3211", "670.`", "\<\"PrintTemporary\"\>"},
    {"3212", "670.`", "\<\"Prism\"\>"},
    {"3213", "670.`", "\<\"PrismBox\"\>"},
    {"3214", "670.`", "\<\"PrismBoxOptions\"\>"},
    {"3215", "670.`", "\<\"PrivateCellOptions\"\>"},
    {"3216", "670.`", "\<\"PrivateEvaluationOptions\"\>"},
    {"3217", "670.`", "\<\"PrivateFontOptions\"\>"},
    {"3218", "670.`", "\<\"PrivateFrontEndOptions\"\>"},
    {"3219", "670.`", "\<\"PrivateNotebookOptions\"\>"},
    {"3220", "670.`", "\<\"PrivatePaths\"\>"},
    {"3221", "670.`", "\<\"Probability\"\>"},
    {"3222", "670.`", "\<\"ProbabilityDistribution\"\>"},
    {"3223", "670.`", "\<\"ProbabilityPlot\"\>"},
    {"3224", "670.`", "\<\"ProbabilityScalePlot\"\>"},
    {"3225", "670.`", "\<\"ProbitModelFit\"\>"},
    {"3226", "670.`", "\<\"ProcessEstimator\"\>"},
    {"3227", "670.`", "\<\"ProcessParameterAssumptions\"\>"},
    {"3228", "670.`", "\<\"ProcessParameterQ\"\>"},
    {"3229", "670.`", "\<\"ProcessStateDomain\"\>"},
    {"3230", "670.`", "\<\"ProcessTimeDomain\"\>"},
    {"3231", "670.`", "\<\"ProductDistribution\"\>"},
    {"3232", "670.`", "\<\"ProductLog\"\>"},
    {"3233", "670.`", "\<\"ProgressIndicator\"\>"},
    {"3234", "670.`", "\<\"ProgressIndicatorBox\"\>"},
    {"3235", "670.`", "\<\"ProgressIndicatorBoxOptions\"\>"},
    {"3236", "670.`", "\<\"Projection\"\>"},
    {"3237", "670.`", "\<\"Prolog\"\>"},
    {"3238", "670.`", "\<\"PromptForm\"\>"},
    {"3239", "670.`", "\<\"Properties\"\>"},
    {"3240", "670.`", "\<\"Property\"\>"},
    {"3241", "670.`", "\<\"PropertyList\"\>"},
    {"3242", "670.`", "\<\"PropertyValue\"\>"},
    {"3243", "670.`", "\<\"Protect\"\>"},
    {"3244", "670.`", "\<\"Protected\"\>"},
    {"3245", "670.`", "\<\"ProteinData\"\>"},
    {"3246", "670.`", "\<\"Pruning\"\>"},
    {"3247", "670.`", "\<\"PseudoInverse\"\>"},
    {"3248", "670.`", "\<\"Pyramid\"\>"},
    {"3249", "670.`", "\<\"PyramidBox\"\>"},
    {"3250", "670.`", "\<\"PyramidBoxOptions\"\>"},
    {"3251", "670.`", "\<\"QBinomial\"\>"},
    {"3252", "670.`", "\<\"QFactorial\"\>"},
    {"3253", "670.`", "\<\"QGamma\"\>"},
    {"3254", "670.`", "\<\"QHypergeometricPFQ\"\>"},
    {"3255", "670.`", "\<\"QPochhammer\"\>"},
    {"3256", "670.`", "\<\"QPolyGamma\"\>"},
    {"3257", "670.`", "\<\"QRDecomposition\"\>"},
    {"3258", "670.`", "\<\"QuadraticIrrationalQ\"\>"},
    {"3259", "670.`", "\<\"Quantile\"\>"},
    {"3260", "670.`", "\<\"QuantilePlot\"\>"},
    {"3261", "670.`", "\<\"Quantity\"\>"},
    {"3262", "670.`", "\<\"QuantityForm\"\>"},
    {"3263", "670.`", "\<\"QuantityMagnitude\"\>"},
    {"3264", "670.`", "\<\"QuantityQ\"\>"},
    {"3265", "670.`", "\<\"QuantityUnit\"\>"},
    {"3266", "670.`", "\<\"Quartics\"\>"},
    {"3267", "670.`", "\<\"QuartileDeviation\"\>"},
    {"3268", "670.`", "\<\"Quartiles\"\>"},
    {"3269", "670.`", "\<\"QuartileSkewness\"\>"},
    {"3270", "670.`", "\<\"QueueingNetworkProcess\"\>"},
    {"3271", "670.`", "\<\"QueueingProcess\"\>"},
    {"3272", "670.`", "\<\"QueueProperties\"\>"},
    {"3273", "670.`", "\<\"Quiet\"\>"},
    {"3274", "670.`", "\<\"Quit\"\>"},
    {"3275", "670.`", "\<\"Quotient\"\>"},
    {"3276", "670.`", "\<\"QuotientRemainder\"\>"},
    {"3277", "670.`", "\<\"RadialityCentrality\"\>"},
    {"3278", "670.`", "\<\"RadicalBox\"\>"},
    {"3279", "670.`", "\<\"RadicalBoxOptions\"\>"},
    {"3280", "670.`", "\<\"RadioButton\"\>"},
    {"3281", "670.`", "\<\"RadioButtonBar\"\>"},
    {"3282", "670.`", "\<\"RadioButtonBox\"\>"},
    {"3283", "670.`", "\<\"RadioButtonBoxOptions\"\>"},
    {"3284", "670.`", "\<\"Radon\"\>"},
    {"3285", "670.`", "\<\"RamanujanTau\"\>"},
    {"3286", "670.`", "\<\"RamanujanTauL\"\>"},
    {"3287", "670.`", "\<\"RamanujanTauTheta\"\>"},
    {"3288", "670.`", "\<\"RamanujanTauZ\"\>"},
    {"3289", "670.`", "\<\"Random\"\>"},
    {"3290", "670.`", "\<\"RandomChoice\"\>"},
    {"3291", "670.`", "\<\"RandomComplex\"\>"},
    {"3292", "670.`", "\<\"RandomFunction\"\>"},
    {"3293", "670.`", "\<\"RandomGraph\"\>"},
    {"3294", "670.`", "\<\"RandomImage\"\>"},
    {"3295", "670.`", "\<\"RandomInteger\"\>"},
    {"3296", "670.`", "\<\"RandomPermutation\"\>"},
    {"3297", "670.`", "\<\"RandomPrime\"\>"},
    {"3298", "670.`", "\<\"RandomReal\"\>"},
    {"3299", "670.`", "\<\"RandomSample\"\>"},
    {"3300", "670.`", "\<\"RandomSeed\"\>"},
    {"3301", "670.`", "\<\"RandomVariate\"\>"},
    {"3302", "670.`", "\<\"RandomWalkProcess\"\>"},
    {"3303", "670.`", "\<\"Range\"\>"},
    {"3304", "670.`", "\<\"RangeFilter\"\>"},
    {"3305", "670.`", "\<\"RangeSpecification\"\>"},
    {"3306", "670.`", "\<\"RankedMax\"\>"},
    {"3307", "670.`", "\<\"RankedMin\"\>"},
    {"3308", "670.`", "\<\"Raster\"\>"},
    {"3309", "670.`", "\<\"Raster3D\"\>"},
    {"3310", "670.`", "\<\"Raster3DBox\"\>"},
    {"3311", "670.`", "\<\"Raster3DBoxOptions\"\>"},
    {"3312", "670.`", "\<\"RasterArray\"\>"},
    {"3313", "670.`", "\<\"RasterBox\"\>"},
    {"3314", "670.`", "\<\"RasterBoxOptions\"\>"},
    {"3315", "670.`", "\<\"Rasterize\"\>"},
    {"3316", "670.`", "\<\"RasterSize\"\>"},
    {"3317", "670.`", "\<\"Rational\"\>"},
    {"3318", "670.`", "\<\"RationalFunctions\"\>"},
    {"3319", "670.`", "\<\"Rationalize\"\>"},
    {"3320", "670.`", "\<\"Rationals\"\>"},
    {"3321", "670.`", "\<\"Ratios\"\>"},
    {"3322", "670.`", "\<\"Raw\"\>"},
    {"3323", "670.`", "\<\"RawArray\"\>"},
    {"3324", "670.`", "\<\"RawBoxes\"\>"},
    {"3325", "670.`", "\<\"RawData\"\>"},
    {"3326", "670.`", "\<\"RawMedium\"\>"},
    {"3327", "670.`", "\<\"RayleighDistribution\"\>"},
    {"3328", "670.`", "\<\"Re\"\>"},
    {"3329", "670.`", "\<\"Read\"\>"},
    {"3330", "670.`", "\<\"ReadList\"\>"},
    {"3331", "670.`", "\<\"ReadProtected\"\>"},
    {"3332", "670.`", "\<\"Real\"\>"},
    {"3333", "670.`", "\<\"RealBlockDiagonalForm\"\>"},
    {"3334", "670.`", "\<\"RealDigits\"\>"},
    {"3335", "670.`", "\<\"RealExponent\"\>"},
    {"3336", "670.`", "\<\"Reals\"\>"},
    {"3337", "670.`", "\<\"Reap\"\>"},
    {"3338", "670.`", "\<\"Record\"\>"},
    {"3339", "670.`", "\<\"RecordLists\"\>"},
    {"3340", "670.`", "\<\"RecordSeparators\"\>"},
    {"3341", "670.`", "\<\"Rectangle\"\>"},
    {"3342", "670.`", "\<\"RectangleBox\"\>"},
    {"3343", "670.`", "\<\"RectangleBoxOptions\"\>"},
    {"3344", "670.`", "\<\"RectangleChart\"\>"},
    {"3345", "670.`", "\<\"RectangleChart3D\"\>"},
    {"3346", "670.`", "\<\"RecurrenceFilter\"\>"},
    {"3347", "670.`", "\<\"RecurrenceTable\"\>"},
    {"3348", "670.`", "\<\"RecurringDigitsForm\"\>"},
    {"3349", "670.`", "\<\"Reduce\"\>"},
    {"3350", "670.`", "\<\"RefBox\"\>"},
    {"3351", "670.`", "\<\"ReferenceLineStyle\"\>"},
    {"3352", "670.`", "\<\"ReferenceMarkers\"\>"},
    {"3353", "670.`", "\<\"ReferenceMarkerStyle\"\>"},
    {"3354", "670.`", "\<\"Refine\"\>"},
    {"3355", "670.`", "\<\"ReflectionMatrix\"\>"},
    {"3356", "670.`", "\<\"ReflectionTransform\"\>"},
    {"3357", "670.`", "\<\"Refresh\"\>"},
    {"3358", "670.`", "\<\"RefreshRate\"\>"},
    {"3359", "670.`", "\<\"RegionBinarize\"\>"},
    {"3360", "670.`", "\<\"RegionFunction\"\>"},
    {"3361", "670.`", "\<\"RegionPlot\"\>"},
    {"3362", "670.`", "\<\"RegionPlot3D\"\>"},
    {"3363", "670.`", "\<\"RegularExpression\"\>"},
    {"3364", "670.`", "\<\"Regularization\"\>"},
    {"3365", "670.`", "\<\"Reinstall\"\>"},
    {"3366", "670.`", "\<\"Release\"\>"},
    {"3367", "670.`", "\<\"ReleaseHold\"\>"},
    {"3368", "670.`", "\<\"ReliabilityDistribution\"\>"},
    {"3369", "670.`", "\<\"ReliefImage\"\>"},
    {"3370", "670.`", "\<\"ReliefPlot\"\>"},
    {"3371", "670.`", "\<\"Remove\"\>"},
    {"3372", "670.`", "\<\"RemoveAlphaChannel\"\>"},
    {"3373", "670.`", "\<\"RemoveAsynchronousTask\"\>"},
    {"3374", "670.`", "\<\"Removed\"\>"},
    {"3375", "670.`", "\<\"RemoveInputStreamMethod\"\>"},
    {"3376", "670.`", "\<\"RemoveOutputStreamMethod\"\>"},
    {"3377", "670.`", "\<\"RemoveProperty\"\>"},
    {"3378", "670.`", "\<\"RemoveScheduledTask\"\>"},
    {"3379", "670.`", "\<\"RenameDirectory\"\>"},
    {"3380", "670.`", "\<\"RenameFile\"\>"},
    {"3381", "670.`", "\<\"RenderAll\"\>"},
    {"3382", "670.`", "\<\"RenderingOptions\"\>"},
    {"3383", "670.`", "\<\"RenewalProcess\"\>"},
    {"3384", "670.`", "\<\"RenkoChart\"\>"},
    {"3385", "670.`", "\<\"RepeatedString\"\>"},
    {"3386", "670.`", "\<\"Replace\"\>"},
    {"3387", "670.`", "\<\"ReplaceHeldPart\"\>"},
    {"3388", "670.`", "\<\"ReplaceImageValue\"\>"},
    {"3389", "670.`", "\<\"ReplaceList\"\>"},
    {"3390", "670.`", "\<\"ReplacePart\"\>"},
    {"3391", "670.`", "\<\"ReplacePixelValue\"\>"},
    {"3392", "670.`", "\<\"Resampling\"\>"},
    {"3393", "670.`", "\<\"Rescale\"\>"},
    {"3394", "670.`", "\<\"RescalingTransform\"\>"},
    {"3395", "670.`", "\<\"ResetDirectory\"\>"},
    {"3396", "670.`", "\<\"ResetMenusPacket\"\>"},
    {"3397", "670.`", "\<\"ResetScheduledTask\"\>"},
    {"3398", "670.`", "\<\"Residue\"\>"},
    {"3399", "670.`", "\<\"Resolve\"\>"},
    {"3400", "670.`", "\<\"Rest\"\>"},
    {"3401", "670.`", "\<\"Resultant\"\>"},
    {"3402", "670.`", "\<\"ResumePacket\"\>"},
    {"3403", "670.`", "\<\"Return\"\>"},
    {"3404", "670.`", "\<\"ReturnExpressionPacket\"\>"},
    {"3405", "670.`", "\<\"ReturnInputFormPacket\"\>"},
    {"3406", "670.`", "\<\"ReturnPacket\"\>"},
    {"3407", "670.`", "\<\"ReturnTextPacket\"\>"},
    {"3408", "670.`", "\<\"Reverse\"\>"},
    {"3409", "670.`", "\<\"ReverseBiorthogonalSplineWavelet\"\>"},
    {"3410", "670.`", "\<\"ReverseGraph\"\>"},
    {"3411", "670.`", "\<\"RevolutionAxis\"\>"},
    {"3412", "670.`", "\<\"RevolutionPlot3D\"\>"},
    {"3413", "670.`", "\<\"RGBColor\"\>"},
    {"3414", "670.`", "\<\"RiccatiSolve\"\>"},
    {"3415", "670.`", "\<\"RiceDistribution\"\>"},
    {"3416", "670.`", "\<\"RidgeFilter\"\>"},
    {"3417", "670.`", "\<\"RiemannR\"\>"},
    {"3418", "670.`", "\<\"RiemannSiegelTheta\"\>"},
    {"3419", "670.`", "\<\"RiemannSiegelZ\"\>"},
    {"3420", "670.`", "\<\"Riffle\"\>"},
    {"3421", "670.`", "\<\"Right\"\>"},
    {"3422", "670.`", "\<\"RightCosetRepresentative\"\>"},
    {"3423", "670.`", "\<\"RiskAchievementImportance\"\>"},
    {"3424", "670.`", "\<\"RiskReductionImportance\"\>"},
    {"3425", "670.`", "\<\"RogersTanimotoDissimilarity\"\>"},
    {"3426", "670.`", "\<\"Root\"\>"},
    {"3427", "670.`", "\<\"RootApproximant\"\>"},
    {"3428", "670.`", "\<\"RootIntervals\"\>"},
    {"3429", "670.`", "\<\"RootLocusPlot\"\>"},
    {"3430", "670.`", "\<\"RootMeanSquare\"\>"},
    {"3431", "670.`", "\<\"RootOfUnityQ\"\>"},
    {"3432", "670.`", "\<\"RootReduce\"\>"},
    {"3433", "670.`", "\<\"Roots\"\>"},
    {"3434", "670.`", "\<\"RootSum\"\>"},
    {"3435", "670.`", "\<\"Rotate\"\>"},
    {"3436", "670.`", "\<\"RotateLabel\"\>"},
    {"3437", "670.`", "\<\"RotateLeft\"\>"},
    {"3438", "670.`", "\<\"RotateRight\"\>"},
    {"3439", "670.`", "\<\"RotationAction\"\>"},
    {"3440", "670.`", "\<\"RotationBox\"\>"},
    {"3441", "670.`", "\<\"RotationBoxOptions\"\>"},
    {"3442", "670.`", "\<\"RotationMatrix\"\>"},
    {"3443", "670.`", "\<\"RotationTransform\"\>"},
    {"3444", "670.`", "\<\"Round\"\>"},
    {"3445", "670.`", "\<\"RoundingRadius\"\>"},
    {"3446", "670.`", "\<\"Row\"\>"},
    {"3447", "670.`", "\<\"RowAlignments\"\>"},
    {"3448", "670.`", "\<\"RowBackgrounds\"\>"},
    {"3449", "670.`", "\<\"RowBox\"\>"},
    {"3450", "670.`", "\<\"RowHeights\"\>"},
    {"3451", "670.`", "\<\"RowLines\"\>"},
    {"3452", "670.`", "\<\"RowMinHeight\"\>"},
    {"3453", "670.`", "\<\"RowReduce\"\>"},
    {"3454", "670.`", "\<\"RowsEqual\"\>"},
    {"3455", "670.`", "\<\"RowSpacings\"\>"},
    {"3456", "670.`", "\<\"RSolve\"\>"},
    {"3457", "670.`", "\<\"RudvalisGroupRu\"\>"},
    {"3458", "670.`", "\<\"RuleCondition\"\>"},
    {"3459", "670.`", "\<\"RuleForm\"\>"},
    {"3460", "670.`", "\<\"RulerUnits\"\>"},
    {"3461", "670.`", "\<\"Run\"\>"},
    {"3462", "670.`", "\<\"RunScheduledTask\"\>"},
    {"3463", "670.`", "\<\"RunThrough\"\>"},
    {"3464", "670.`", "\<\"RuntimeAttributes\"\>"},
    {"3465", "670.`", "\<\"RuntimeOptions\"\>"},
    {"3466", "670.`", "\<\"RussellRaoDissimilarity\"\>"},
    {"3467", "670.`", "\<\"SameTest\"\>"},
    {"3468", "670.`", "\<\"SampleDepth\"\>"},
    {"3469", "670.`", "\<\"SampledSoundFunction\"\>"},
    {"3470", "670.`", "\<\"SampledSoundList\"\>"},
    {"3471", "670.`", "\<\"SampleRate\"\>"},
    {"3472", "670.`", "\<\"SamplingPeriod\"\>"},
    {"3473", "670.`", "\<\"SARIMAProcess\"\>"},
    {"3474", "670.`", "\<\"SARMAProcess\"\>"},
    {"3475", "670.`", "\<\"SatisfiabilityCount\"\>"},
    {"3476", "670.`", "\<\"SatisfiabilityInstances\"\>"},
    {"3477", "670.`", "\<\"SatisfiableQ\"\>"},
    {"3478", "670.`", "\<\"Saturday\"\>"},
    {"3479", "670.`", "\<\"Save\"\>"},
    {"3480", "670.`", "\<\"Saveable\"\>"},
    {"3481", "670.`", "\<\"SaveAutoDelete\"\>"},
    {"3482", "670.`", "\<\"SaveDefinitions\"\>"},
    {"3483", "670.`", "\<\"SawtoothWave\"\>"},
    {"3484", "670.`", "\<\"Scale\"\>"},
    {"3485", "670.`", "\<\"Scaled\"\>"},
    {"3486", "670.`", "\<\"ScaleDivisions\"\>"},
    {"3487", "670.`", "\<\"ScaledMousePosition\"\>"},
    {"3488", "670.`", "\<\"ScaleOrigin\"\>"},
    {"3489", "670.`", "\<\"ScalePadding\"\>"},
    {"3490", "670.`", "\<\"ScaleRanges\"\>"},
    {"3491", "670.`", "\<\"ScaleRangeStyle\"\>"},
    {"3492", "670.`", "\<\"ScalingFunctions\"\>"},
    {"3493", "670.`", "\<\"ScalingMatrix\"\>"},
    {"3494", "670.`", "\<\"ScalingTransform\"\>"},
    {"3495", "670.`", "\<\"Scan\"\>"},
    {"3496", "670.`", "\<\"ScheduledTaskActiveQ\"\>"},
    {"3497", "670.`", "\<\"ScheduledTaskData\"\>"},
    {"3498", "670.`", "\<\"ScheduledTaskObject\"\>"},
    {"3499", "670.`", "\<\"ScheduledTasks\"\>"},
    {"3500", "670.`", "\<\"SchurDecomposition\"\>"},
    {"3501", "670.`", "\<\"ScientificForm\"\>"},
    {"3502", "670.`", "\<\"ScreenRectangle\"\>"},
    {"3503", "670.`", "\<\"ScreenStyleEnvironment\"\>"},
    {"3504", "670.`", "\<\"ScriptBaselineShifts\"\>"},
    {"3505", "670.`", "\<\"ScriptLevel\"\>"},
    {"3506", "670.`", "\<\"ScriptMinSize\"\>"},
    {"3507", "670.`", "\<\"ScriptRules\"\>"},
    {"3508", "670.`", "\<\"ScriptSizeMultipliers\"\>"},
    {"3509", "670.`", "\<\"Scrollbars\"\>"},
    {"3510", "670.`", "\<\"ScrollingOptions\"\>"},
    {"3511", "670.`", "\<\"ScrollPosition\"\>"},
    {"3512", "670.`", "\<\"Sec\"\>"},
    {"3513", "670.`", "\<\"Sech\"\>"},
    {"3514", "670.`", "\<\"SechDistribution\"\>"},
    {"3515", "670.`", "\<\"SectionGrouping\"\>"},
    {"3516", "670.`", "\<\"SectorChart\"\>"},
    {"3517", "670.`", "\<\"SectorChart3D\"\>"},
    {"3518", "670.`", "\<\"SectorOrigin\"\>"},
    {"3519", "670.`", "\<\"SectorSpacing\"\>"},
    {"3520", "670.`", "\<\"SeedRandom\"\>"},
    {"3521", "670.`", "\<\"Select\"\>"},
    {"3522", "670.`", "\<\"Selectable\"\>"},
    {"3523", "670.`", "\<\"SelectComponents\"\>"},
    {"3524", "670.`", "\<\"SelectedCells\"\>"},
    {"3525", "670.`", "\<\"SelectedNotebook\"\>"},
    {"3526", "670.`", "\<\"Selection\"\>"},
    {"3527", "670.`", "\<\"SelectionAnimate\"\>"},
    {"3528", "670.`", "\<\"SelectionCell\"\>"},
    {"3529", "670.`", "\<\"SelectionCellCreateCell\"\>"},
    {"3530", "670.`", "\<\"SelectionCellDefaultStyle\"\>"},
    {"3531", "670.`", "\<\"SelectionCellParentStyle\"\>"},
    {"3532", "670.`", "\<\"SelectionCreateCell\"\>"},
    {"3533", "670.`", "\<\"SelectionDebuggerTag\"\>"},
    {"3534", "670.`", "\<\"SelectionDuplicateCell\"\>"},
    {"3535", "670.`", "\<\"SelectionEvaluate\"\>"},
    {"3536", "670.`", "\<\"SelectionEvaluateCreateCell\"\>"},
    {"3537", "670.`", "\<\"SelectionMove\"\>"},
    {"3538", "670.`", "\<\"SelectionPlaceholder\"\>"},
    {"3539", "670.`", "\<\"SelectionSetStyle\"\>"},
    {"3540", "670.`", "\<\"SelectWithContents\"\>"},
    {"3541", "670.`", "\<\"SelfLoops\"\>"},
    {"3542", "670.`", "\<\"SelfLoopStyle\"\>"},
    {"3543", "670.`", "\<\"SemialgebraicComponentInstances\"\>"},
    {"3544", "670.`", "\<\"SendMail\"\>"},
    {"3545", "670.`", "\<\"Sequence\"\>"},
    {"3546", "670.`", "\<\"SequenceAlignment\"\>"},
    {"3547", "670.`", "\<\"SequenceForm\"\>"},
    {"3548", "670.`", "\<\"SequenceHold\"\>"},
    {"3549", "670.`", "\<\"SequenceLimit\"\>"},
    {"3550", "670.`", "\<\"Series\"\>"},
    {"3551", "670.`", "\<\"SeriesCoefficient\"\>"},
    {"3552", "670.`", "\<\"SeriesData\"\>"},
    {"3553", "670.`", "\<\"SessionTime\"\>"},
    {"3554", "670.`", "\<\"SetAccuracy\"\>"},
    {"3555", "670.`", "\<\"SetAlphaChannel\"\>"},
    {"3556", "670.`", "\<\"SetAttributes\"\>"},
    {"3557", "670.`", "\<\"Setbacks\"\>"},
    {"3558", "670.`", "\<\"SetBoxFormNamesPacket\"\>"},
    {"3559", "670.`", "\<\"SetDirectory\"\>"},
    {"3560", "670.`", "\<\"SetEnvironment\"\>"},
    {"3561", "670.`", "\<\"SetEvaluationNotebook\"\>"},
    {"3562", "670.`", "\<\"SetFileDate\"\>"},
    {"3563", "670.`", "\<\"SetFileLoadingContext\"\>"},
    {"3564", "670.`", "\<\"SetNotebookStatusLine\"\>"},
    {"3565", "670.`", "\<\"SetOptions\"\>"},
    {"3566", "670.`", "\<\"SetOptionsPacket\"\>"},
    {"3567", "670.`", "\<\"SetPrecision\"\>"},
    {"3568", "670.`", "\<\"SetProperty\"\>"},
    {"3569", "670.`", "\<\"SetSelectedNotebook\"\>"},
    {"3570", "670.`", "\<\"SetSharedFunction\"\>"},
    {"3571", "670.`", "\<\"SetSharedVariable\"\>"},
    {"3572", "670.`", "\<\"SetSpeechParametersPacket\"\>"},
    {"3573", "670.`", "\<\"SetStreamPosition\"\>"},
    {"3574", "670.`", "\<\"SetSystemOptions\"\>"},
    {"3575", "670.`", "\<\"Setter\"\>"},
    {"3576", "670.`", "\<\"SetterBar\"\>"},
    {"3577", "670.`", "\<\"SetterBox\"\>"},
    {"3578", "670.`", "\<\"SetterBoxOptions\"\>"},
    {"3579", "670.`", "\<\"Setting\"\>"},
    {"3580", "670.`", "\<\"SetValue\"\>"},
    {"3581", "670.`", "\<\"Shading\"\>"},
    {"3582", "670.`", "\<\"Shallow\"\>"},
    {"3583", "670.`", "\<\"ShannonWavelet\"\>"},
    {"3584", "670.`", "\<\"ShapiroWilkTest\"\>"},
    {"3585", "670.`", "\<\"Share\"\>"},
    {"3586", "670.`", "\<\"Sharpen\"\>"},
    {"3587", "670.`", "\<\"ShearingMatrix\"\>"},
    {"3588", "670.`", "\<\"ShearingTransform\"\>"},
    {"3589", "670.`", "\<\"ShenCastanMatrix\"\>"},
    {"3590", "670.`", "\<\"Short\"\>"},
    {"3591", "670.`", "\<\"Shortest\"\>"},
    {"3592", "670.`", "\<\"ShortestMatch\"\>"},
    {"3593", "670.`", "\<\"ShortestPathFunction\"\>"},
    {"3594", "670.`", "\<\"Show\"\>"},
    {"3595", "670.`", "\<\"ShowAutoStyles\"\>"},
    {"3596", "670.`", "\<\"ShowCellBracket\"\>"},
    {"3597", "670.`", "\<\"ShowCellLabel\"\>"},
    {"3598", "670.`", "\<\"ShowCellTags\"\>"},
    {"3599", "670.`", "\<\"ShowClosedCellArea\"\>"},
    {"3600", "670.`", "\<\"ShowContents\"\>"},
    {"3601", "670.`", "\<\"ShowControls\"\>"},
    {"3602", "670.`", "\<\"ShowCursorTracker\"\>"},
    {"3603", "670.`", "\<\"ShowGroupOpenCloseIcon\"\>"},
    {"3604", "670.`", "\<\"ShowGroupOpener\"\>"},
    {"3605", "670.`", "\<\"ShowInvisibleCharacters\"\>"},
    {"3606", "670.`", "\<\"ShowPageBreaks\"\>"},
    {"3607", "670.`", "\<\"ShowPredictiveInterface\"\>"},
    {"3608", "670.`", "\<\"ShowSelection\"\>"},
    {"3609", "670.`", "\<\"ShowShortBoxForm\"\>"},
    {"3610", "670.`", "\<\"ShowSpecialCharacters\"\>"},
    {"3611", "670.`", "\<\"ShowStringCharacters\"\>"},
    {"3612", "670.`", "\<\"ShowSyntaxStyles\"\>"},
    {"3613", "670.`", "\<\"ShrinkingDelay\"\>"},
    {"3614", "670.`", "\<\"ShrinkWrapBoundingBox\"\>"},
    {"3615", "670.`", "\<\"SiegelTheta\"\>"},
    {"3616", "670.`", "\<\"SiegelTukeyTest\"\>"},
    {"3617", "670.`", "\<\"Sign\"\>"},
    {"3618", "670.`", "\<\"Signature\"\>"},
    {"3619", "670.`", "\<\"SignedRankTest\"\>"},
    {"3620", "670.`", "\<\"SignificanceLevel\"\>"},
    {"3621", "670.`", "\<\"SignPadding\"\>"},
    {"3622", "670.`", "\<\"SignTest\"\>"},
    {"3623", "670.`", "\<\"SimilarityRules\"\>"},
    {"3624", "670.`", "\<\"SimpleGraph\"\>"},
    {"3625", "670.`", "\<\"SimpleGraphQ\"\>"},
    {"3626", "670.`", "\<\"Simplify\"\>"},
    {"3627", "670.`", "\<\"Sin\"\>"},
    {"3628", "670.`", "\<\"Sinc\"\>"},
    {"3629", "670.`", "\<\"SinghMaddalaDistribution\"\>"},
    {"3630", "670.`", "\<\"SingleEvaluation\"\>"},
    {"3631", "670.`", "\<\"SingleLetterItalics\"\>"},
    {"3632", "670.`", "\<\"SingleLetterStyle\"\>"},
    {"3633", "670.`", "\<\"SingularValueDecomposition\"\>"},
    {"3634", "670.`", "\<\"SingularValueList\"\>"},
    {"3635", "670.`", "\<\"SingularValuePlot\"\>"},
    {"3636", "670.`", "\<\"SingularValues\"\>"},
    {"3637", "670.`", "\<\"Sinh\"\>"},
    {"3638", "670.`", "\<\"SinhIntegral\"\>"},
    {"3639", "670.`", "\<\"SinIntegral\"\>"},
    {"3640", "670.`", "\<\"SixJSymbol\"\>"},
    {"3641", "670.`", "\<\"Skeleton\"\>"},
    {"3642", "670.`", "\<\"SkeletonTransform\"\>"},
    {"3643", "670.`", "\<\"SkellamDistribution\"\>"},
    {"3644", "670.`", "\<\"Skewness\"\>"},
    {"3645", "670.`", "\<\"SkewNormalDistribution\"\>"},
    {"3646", "670.`", "\<\"Skip\"\>"},
    {"3647", "670.`", "\<\"SliceDistribution\"\>"},
    {"3648", "670.`", "\<\"Slider\"\>"},
    {"3649", "670.`", "\<\"Slider2D\"\>"},
    {"3650", "670.`", "\<\"Slider2DBox\"\>"},
    {"3651", "670.`", "\<\"Slider2DBoxOptions\"\>"},
    {"3652", "670.`", "\<\"SliderBox\"\>"},
    {"3653", "670.`", "\<\"SliderBoxOptions\"\>"},
    {"3654", "670.`", "\<\"SlideView\"\>"},
    {"3655", "670.`", "\<\"Small\"\>"},
    {"3656", "670.`", "\<\"Smaller\"\>"},
    {"3657", "670.`", "\<\"SmithDelayCompensator\"\>"},
    {"3658", "670.`", "\<\"SmithWatermanSimilarity\"\>"},
    {"3659", "670.`", "\<\"SmoothDensityHistogram\"\>"},
    {"3660", "670.`", "\<\"SmoothHistogram\"\>"},
    {"3661", "670.`", "\<\"SmoothHistogram3D\"\>"},
    {"3662", "670.`", "\<\"SmoothKernelDistribution\"\>"},
    {"3663", "670.`", "\<\"SocialMediaData\"\>"},
    {"3664", "670.`", "\<\"Socket\"\>"},
    {"3665", "670.`", "\<\"SokalSneathDissimilarity\"\>"},
    {"3666", "670.`", "\<\"Solve\"\>"},
    {"3667", "670.`", "\<\"SolveAlways\"\>"},
    {"3668", "670.`", "\<\"SolveDelayed\"\>"},
    {"3669", "670.`", "\<\"Sort\"\>"},
    {"3670", "670.`", "\<\"SortBy\"\>"},
    {"3671", "670.`", "\<\"Sound\"\>"},
    {"3672", "670.`", "\<\"SoundAndGraphics\"\>"},
    {"3673", "670.`", "\<\"SoundNote\"\>"},
    {"3674", "670.`", "\<\"SoundVolume\"\>"},
    {"3675", "670.`", "\<\"Sow\"\>"},
    {"3676", "670.`", "\<\"SpaceForm\"\>"},
    {"3677", "670.`", "\<\"Spacer\"\>"},
    {"3678", "670.`", "\<\"Spacings\"\>"},
    {"3679", "670.`", "\<\"SpanAdjustments\"\>"},
    {"3680", "670.`", "\<\"SpanCharacterRounding\"\>"},
    {"3681", "670.`", "\<\"SpanFromAbove\"\>"},
    {"3682", "670.`", "\<\"SpanFromBoth\"\>"},
    {"3683", "670.`", "\<\"SpanFromLeft\"\>"},
    {"3684", "670.`", "\<\"SpanLineThickness\"\>"},
    {"3685", "670.`", "\<\"SpanMaxSize\"\>"},
    {"3686", "670.`", "\<\"SpanMinSize\"\>"},
    {"3687", "670.`", "\<\"SpanningCharacters\"\>"},
    {"3688", "670.`", "\<\"SpanSymmetric\"\>"},
    {"3689", "670.`", "\<\"SparseArray\"\>"},
    {"3690", "670.`", "\<\"SpatialGraphDistribution\"\>"},
    {"3691", "670.`", "\<\"Speak\"\>"},
    {"3692", "670.`", "\<\"SpeakTextPacket\"\>"},
    {"3693", "670.`", "\<\"SpearmanRankTest\"\>"},
    {"3694", "670.`", "\<\"SpearmanRho\"\>"},
    {"3695", "670.`", "\<\"Spectrogram\"\>"},
    {"3696", "670.`", "\<\"SpectrogramArray\"\>"},
    {"3697", "670.`", "\<\"Specularity\"\>"},
    {"3698", "670.`", "\<\"SpellingCorrection\"\>"},
    {"3699", "670.`", "\<\"SpellingDictionaries\"\>"},
    {"3700", "670.`", "\<\"SpellingDictionariesPath\"\>"},
    {"3701", "670.`", "\<\"SpellingOptions\"\>"},
    {"3702", "670.`", "\<\"SpellingSuggestionsPacket\"\>"},
    {"3703", "670.`", "\<\"Sphere\"\>"},
    {"3704", "670.`", "\<\"SphereBox\"\>"},
    {"3705", "670.`", "\<\"SphericalBesselJ\"\>"},
    {"3706", "670.`", "\<\"SphericalBesselY\"\>"},
    {"3707", "670.`", "\<\"SphericalHankelH1\"\>"},
    {"3708", "670.`", "\<\"SphericalHankelH2\"\>"},
    {"3709", "670.`", "\<\"SphericalHarmonicY\"\>"},
    {"3710", "670.`", "\<\"SphericalPlot3D\"\>"},
    {"3711", "670.`", "\<\"SphericalRegion\"\>"},
    {"3712", "670.`", "\<\"SpheroidalEigenvalue\"\>"},
    {"3713", "670.`", "\<\"SpheroidalJoiningFactor\"\>"},
    {"3714", "670.`", "\<\"SpheroidalPS\"\>"},
    {"3715", "670.`", "\<\"SpheroidalPSPrime\"\>"},
    {"3716", "670.`", "\<\"SpheroidalQS\"\>"},
    {"3717", "670.`", "\<\"SpheroidalQSPrime\"\>"},
    {"3718", "670.`", "\<\"SpheroidalRadialFactor\"\>"},
    {"3719", "670.`", "\<\"SpheroidalS1\"\>"},
    {"3720", "670.`", "\<\"SpheroidalS1Prime\"\>"},
    {"3721", "670.`", "\<\"SpheroidalS2\"\>"},
    {"3722", "670.`", "\<\"SpheroidalS2Prime\"\>"},
    {"3723", "670.`", "\<\"Splice\"\>"},
    {"3724", "670.`", "\<\"SplicedDistribution\"\>"},
    {"3725", "670.`", "\<\"SplineClosed\"\>"},
    {"3726", "670.`", "\<\"SplineDegree\"\>"},
    {"3727", "670.`", "\<\"SplineKnots\"\>"},
    {"3728", "670.`", "\<\"SplineWeights\"\>"},
    {"3729", "670.`", "\<\"Split\"\>"},
    {"3730", "670.`", "\<\"SplitBy\"\>"},
    {"3731", "670.`", "\<\"SpokenString\"\>"},
    {"3732", "670.`", "\<\"Sqrt\"\>"},
    {"3733", "670.`", "\<\"SqrtBox\"\>"},
    {"3734", "670.`", "\<\"SqrtBoxOptions\"\>"},
    {"3735", "670.`", "\<\"SquaredEuclideanDistance\"\>"},
    {"3736", "670.`", "\<\"SquareFreeQ\"\>"},
    {"3737", "670.`", "\<\"SquaresR\"\>"},
    {"3738", "670.`", "\<\"SquareWave\"\>"},
    {"3739", "670.`", "\<\"StabilityMargins\"\>"},
    {"3740", "670.`", "\<\"StabilityMarginsStyle\"\>"},
    {"3741", "670.`", "\<\"StableDistribution\"\>"},
    {"3742", "670.`", "\<\"Stack\"\>"},
    {"3743", "670.`", "\<\"StackBegin\"\>"},
    {"3744", "670.`", "\<\"StackComplete\"\>"},
    {"3745", "670.`", "\<\"StackInhibit\"\>"},
    {"3746", "670.`", "\<\"StandardDeviation\"\>"},
    {"3747", "670.`", "\<\"StandardDeviationFilter\"\>"},
    {"3748", "670.`", "\<\"StandardForm\"\>"},
    {"3749", "670.`", "\<\"Standardize\"\>"},
    {"3750", "670.`", "\<\"StandbyDistribution\"\>"},
    {"3751", "670.`", "\<\"StarGraph\"\>"},
    {"3752", "670.`", "\<\"StartAsynchronousTask\"\>"},
    {"3753", "670.`", "\<\"StartingStepSize\"\>"},
    {"3754", "670.`", "\<\"StartOfLine\"\>"},
    {"3755", "670.`", "\<\"StartOfString\"\>"},
    {"3756", "670.`", "\<\"StartScheduledTask\"\>"},
    {"3757", "670.`", "\<\"StartupSound\"\>"},
    {"3758", "670.`", "\<\"StateDimensions\"\>"},
    {"3759", "670.`", "\<\"StateFeedbackGains\"\>"},
    {"3760", "670.`", "\<\"StateOutputEstimator\"\>"},
    {"3761", "670.`", "\<\"StateResponse\"\>"},
    {"3762", "670.`", "\<\"StateSpaceModel\"\>"},
    {"3763", "670.`", "\<\"StateSpaceRealization\"\>"},
    {"3764", "670.`", "\<\"StateSpaceTransform\"\>"},
    {"3765", "670.`", "\<\"StationaryDistribution\"\>"},
    {"3766", "670.`", "\<\"StationaryWaveletPacketTransform\"\>"},
    {"3767", "670.`", "\<\"StationaryWaveletTransform\"\>"},
    {"3768", "670.`", "\<\"StatusArea\"\>"},
    {"3769", "670.`", "\<\"StatusCentrality\"\>"},
    {"3770", "670.`", "\<\"StepMonitor\"\>"},
    {"3771", "670.`", "\<\"StieltjesGamma\"\>"},
    {"3772", "670.`", "\<\"StirlingS1\"\>"},
    {"3773", "670.`", "\<\"StirlingS2\"\>"},
    {"3774", "670.`", "\<\"StopAsynchronousTask\"\>"},
    {"3775", "670.`", "\<\"StopScheduledTask\"\>"},
    {"3776", "670.`", "\<\"StrataVariables\"\>"},
    {"3777", "670.`", "\<\"StratonovichProcess\"\>"},
    {"3778", "670.`", "\<\"StreamColorFunction\"\>"},
    {"3779", "670.`", "\<\"StreamColorFunctionScaling\"\>"},
    {"3780", "670.`", "\<\"StreamDensityPlot\"\>"},
    {"3781", "670.`", "\<\"StreamPlot\"\>"},
    {"3782", "670.`", "\<\"StreamPoints\"\>"},
    {"3783", "670.`", "\<\"StreamPosition\"\>"},
    {"3784", "670.`", "\<\"Streams\"\>"},
    {"3785", "670.`", "\<\"StreamScale\"\>"},
    {"3786", "670.`", "\<\"StreamStyle\"\>"},
    {"3787", "670.`", "\<\"String\"\>"},
    {"3788", "670.`", "\<\"StringBreak\"\>"},
    {"3789", "670.`", "\<\"StringByteCount\"\>"},
    {"3790", "670.`", "\<\"StringCases\"\>"},
    {"3791", "670.`", "\<\"StringCount\"\>"},
    {"3792", "670.`", "\<\"StringDrop\"\>"},
    {"3793", "670.`", "\<\"StringForm\"\>"},
    {"3794", "670.`", "\<\"StringFormat\"\>"},
    {"3795", "670.`", "\<\"StringFreeQ\"\>"},
    {"3796", "670.`", "\<\"StringInsert\"\>"},
    {"3797", "670.`", "\<\"StringLength\"\>"},
    {"3798", "670.`", "\<\"StringMatchQ\"\>"},
    {"3799", "670.`", "\<\"StringPosition\"\>"},
    {"3800", "670.`", "\<\"StringQ\"\>"},
    {"3801", "670.`", "\<\"StringReplace\"\>"},
    {"3802", "670.`", "\<\"StringReplaceList\"\>"},
    {"3803", "670.`", "\<\"StringReplacePart\"\>"},
    {"3804", "670.`", "\<\"StringReverse\"\>"},
    {"3805", "670.`", "\<\"StringRotateLeft\"\>"},
    {"3806", "670.`", "\<\"StringRotateRight\"\>"},
    {"3807", "670.`", "\<\"StringSkeleton\"\>"},
    {"3808", "670.`", "\<\"StringSplit\"\>"},
    {"3809", "670.`", "\<\"StringTake\"\>"},
    {"3810", "670.`", "\<\"StringToStream\"\>"},
    {"3811", "670.`", "\<\"StringTrim\"\>"},
    {"3812", "670.`", "\<\"StripBoxes\"\>"},
    {"3813", "670.`", "\<\"StripOnInput\"\>"},
    {"3814", "670.`", "\<\"StripWrapperBoxes\"\>"},
    {"3815", "670.`", "\<\"StrokeForm\"\>"},
    {"3816", "670.`", "\<\"StructuralImportance\"\>"},
    {"3817", "670.`", "\<\"StructuredArray\"\>"},
    {"3818", "670.`", "\<\"StructuredSelection\"\>"},
    {"3819", "670.`", "\<\"StruveH\"\>"},
    {"3820", "670.`", "\<\"StruveL\"\>"},
    {"3821", "670.`", "\<\"Stub\"\>"},
    {"3822", "670.`", "\<\"StudentTDistribution\"\>"},
    {"3823", "670.`", "\<\"Style\"\>"},
    {"3824", "670.`", "\<\"StyleBox\"\>"},
    {"3825", "670.`", "\<\"StyleBoxAutoDelete\"\>"},
    {"3826", "670.`", "\<\"StyleBoxOptions\"\>"},
    {"3827", "670.`", "\<\"StyleData\"\>"},
    {"3828", "670.`", "\<\"StyleDefinitions\"\>"},
    {"3829", "670.`", "\<\"StyleForm\"\>"},
    {"3830", "670.`", "\<\"StyleKeyMapping\"\>"},
    {"3831", "670.`", "\<\"StyleMenuListing\"\>"},
    {"3832", "670.`", "\<\"StyleNameDialogSettings\"\>"},
    {"3833", "670.`", "\<\"StyleNames\"\>"},
    {"3834", "670.`", "\<\"StylePrint\"\>"},
    {"3835", "670.`", "\<\"StyleSheetPath\"\>"},
    {"3836", "670.`", "\<\"Subfactorial\"\>"},
    {"3837", "670.`", "\<\"Subgraph\"\>"},
    {"3838", "670.`", "\<\"SubresultantPolynomialRemainders\"\>"},
    {"3839", "670.`", "\<\"SubresultantPolynomials\"\>"},
    {"3840", "670.`", "\<\"Subresultants\"\>"},
    {"3841", "670.`", "\<\"Subscript\"\>"},
    {"3842", "670.`", "\<\"SubscriptBoxOptions\"\>"},
    {"3843", "670.`", "\<\"Subscripted\"\>"},
    {"3844", "670.`", "\<\"Subsets\"\>"},
    {"3845", "670.`", "\<\"Subsuperscript\"\>"},
    {"3846", "670.`", "\<\"SubsuperscriptBoxOptions\"\>"},
    {"3847", "670.`", "\<\"SubValues\"\>"},
    {"3848", "670.`", "\<\"SumConvergence\"\>"},
    {"3849", "670.`", "\<\"Sunday\"\>"},
    {"3850", "670.`", "\<\"Superscript\"\>"},
    {"3851", "670.`", "\<\"SuperscriptBoxOptions\"\>"},
    {"3852", "670.`", "\<\"Surd\"\>"},
    {"3853", "670.`", "\<\"SurdForm\"\>"},
    {"3854", "670.`", "\<\"SurfaceColor\"\>"},
    {"3855", "670.`", "\<\"SurfaceGraphics\"\>"},
    {"3856", "670.`", "\<\"SurvivalDistribution\"\>"},
    {"3857", "670.`", "\<\"SurvivalFunction\"\>"},
    {"3858", "670.`", "\<\"SurvivalModel\"\>"},
    {"3859", "670.`", "\<\"SurvivalModelFit\"\>"},
    {"3860", "670.`", "\<\"SuspendPacket\"\>"},
    {"3861", "670.`", "\<\"SuzukiDistribution\"\>"},
    {"3862", "670.`", "\<\"SuzukiGroupSuz\"\>"},
    {"3863", "670.`", "\<\"SwatchLegend\"\>"},
    {"3864", "670.`", "\<\"Switch\"\>"},
    {"3865", "670.`", "\<\"Symbol\"\>"},
    {"3866", "670.`", "\<\"SymbolName\"\>"},
    {"3867", "670.`", "\<\"SymletWavelet\"\>"},
    {"3868", "670.`", "\<\"Symmetric\"\>"},
    {"3869", "670.`", "\<\"SymmetricGroup\"\>"},
    {"3870", "670.`", "\<\"SymmetricMatrixQ\"\>"},
    {"3871", "670.`", "\<\"SymmetricPolynomial\"\>"},
    {"3872", "670.`", "\<\"SymmetricReduction\"\>"},
    {"3873", "670.`", "\<\"Symmetrize\"\>"},
    {"3874", "670.`", "\<\"SymmetrizedArray\"\>"},
    {"3875", "670.`", "\<\"SymmetrizedArrayRules\"\>"},
    {"3876", "670.`", "\<\"SymmetrizedDependentComponents\"\>"},
    {"3877", "670.`", "\<\"SymmetrizedIndependentComponents\"\>"},
    {"3878", "670.`", "\<\"SymmetrizedReplacePart\"\>"},
    {"3879", "670.`", "\<\"SynchronousInitialization\"\>"},
    {"3880", "670.`", "\<\"SynchronousUpdating\"\>"},
    {"3881", "670.`", "\<\"Syntax\"\>"},
    {"3882", "670.`", "\<\"SyntaxForm\"\>"},
    {"3883", "670.`", "\<\"SyntaxInformation\"\>"},
    {"3884", "670.`", "\<\"SyntaxLength\"\>"},
    {"3885", "670.`", "\<\"SyntaxPacket\"\>"},
    {"3886", "670.`", "\<\"SyntaxQ\"\>"},
    {"3887", "670.`", "\<\"SystemDialogInput\"\>"},
    {"3888", "670.`", "\<\"SystemException\"\>"},
    {"3889", "670.`", "\<\"SystemHelpPath\"\>"},
    {"3890", "670.`", "\<\"SystemInformation\"\>"},
    {"3891", "670.`", "\<\"SystemInformationData\"\>"},
    {"3892", "670.`", "\<\"SystemOpen\"\>"},
    {"3893", "670.`", "\<\"SystemOptions\"\>"},
    {"3894", "670.`", "\<\"SystemsModelDelay\"\>"},
    {"3895", "670.`", "\<\"SystemsModelDelayApproximate\"\>"},
    {"3896", "670.`", "\<\"SystemsModelDelete\"\>"},
    {"3897", "670.`", "\<\"SystemsModelDimensions\"\>"},
    {"3898", "670.`", "\<\"SystemsModelExtract\"\>"},
    {"3899", "670.`", "\<\"SystemsModelFeedbackConnect\"\>"},
    {"3900", "670.`", "\<\"SystemsModelLabels\"\>"},
    {"3901", "670.`", "\<\"SystemsModelOrder\"\>"},
    {"3902", "670.`", "\<\"SystemsModelParallelConnect\"\>"},
    {"3903", "670.`", "\<\"SystemsModelSeriesConnect\"\>"},
    {"3904", "670.`", "\<\"SystemsModelStateFeedbackConnect\"\>"},
    {"3905", "670.`", "\<\"SystemStub\"\>"},
    {"3906", "670.`", "\<\"TabFilling\"\>"},
    {"3907", "670.`", "\<\"Table\"\>"},
    {"3908", "670.`", "\<\"TableAlignments\"\>"},
    {"3909", "670.`", "\<\"TableDepth\"\>"},
    {"3910", "670.`", "\<\"TableDirections\"\>"},
    {"3911", "670.`", "\<\"TableForm\"\>"},
    {"3912", "670.`", "\<\"TableHeadings\"\>"},
    {"3913", "670.`", "\<\"TableSpacing\"\>"},
    {"3914", "670.`", "\<\"TableView\"\>"},
    {"3915", "670.`", "\<\"TableViewBox\"\>"},
    {"3916", "670.`", "\<\"TabSpacings\"\>"},
    {"3917", "670.`", "\<\"TabView\"\>"},
    {"3918", "670.`", "\<\"TabViewBox\"\>"},
    {"3919", "670.`", "\<\"TabViewBoxOptions\"\>"},
    {"3920", "670.`", "\<\"TagBox\"\>"},
    {"3921", "670.`", "\<\"TagBoxNote\"\>"},
    {"3922", "670.`", "\<\"TagBoxOptions\"\>"},
    {"3923", "670.`", "\<\"TaggingRules\"\>"},
    {"3924", "670.`", "\<\"TagSet\"\>"},
    {"3925", "670.`", "\<\"TagSetDelayed\"\>"},
    {"3926", "670.`", "\<\"TagStyle\"\>"},
    {"3927", "670.`", "\<\"TagUnset\"\>"},
    {"3928", "670.`", "\<\"Take\"\>"},
    {"3929", "670.`", "\<\"TakeWhile\"\>"},
    {"3930", "670.`", "\<\"Tally\"\>"},
    {"3931", "670.`", "\<\"Tan\"\>"},
    {"3932", "670.`", "\<\"Tanh\"\>"},
    {"3933", "670.`", "\<\"TargetFunctions\"\>"},
    {"3934", "670.`", "\<\"TargetUnits\"\>"},
    {"3935", "670.`", "\<\"TautologyQ\"\>"},
    {"3936", "670.`", "\<\"TelegraphProcess\"\>"},
    {"3937", "670.`", "\<\"TemplateBox\"\>"},
    {"3938", "670.`", "\<\"TemplateBoxOptions\"\>"},
    {"3939", "670.`", "\<\"TemplateSlotSequence\"\>"},
    {"3940", "670.`", "\<\"TemporalData\"\>"},
    {"3941", "670.`", "\<\"Temporary\"\>"},
    {"3942", "670.`", "\<\"TemporaryVariable\"\>"},
    {"3943", "670.`", "\<\"TensorContract\"\>"},
    {"3944", "670.`", "\<\"TensorDimensions\"\>"},
    {"3945", "670.`", "\<\"TensorExpand\"\>"},
    {"3946", "670.`", "\<\"TensorQ\"\>"},
    {"3947", "670.`", "\<\"TensorRank\"\>"},
    {"3948", "670.`", "\<\"TensorReduce\"\>"},
    {"3949", "670.`", "\<\"TensorSymmetry\"\>"},
    {"3950", "670.`", "\<\"TensorTranspose\"\>"},
    {"3951", "670.`", "\<\"Tetrahedron\"\>"},
    {"3952", "670.`", "\<\"TetrahedronBox\"\>"},
    {"3953", "670.`", "\<\"TetrahedronBoxOptions\"\>"},
    {"3954", "670.`", "\<\"TeXForm\"\>"},
    {"3955", "670.`", "\<\"TeXSave\"\>"},
    {"3956", "670.`", "\<\"Text\"\>"},
    {"3957", "670.`", "\<\"Text3DBox\"\>"},
    {"3958", "670.`", "\<\"Text3DBoxOptions\"\>"},
    {"3959", "670.`", "\<\"TextAlignment\"\>"},
    {"3960", "670.`", "\<\"TextBand\"\>"},
    {"3961", "670.`", "\<\"TextBoundingBox\"\>"},
    {"3962", "670.`", "\<\"TextBox\"\>"},
    {"3963", "670.`", "\<\"TextCell\"\>"},
    {"3964", "670.`", "\<\"TextClipboardType\"\>"},
    {"3965", "670.`", "\<\"TextData\"\>"},
    {"3966", "670.`", "\<\"TextForm\"\>"},
    {"3967", "670.`", "\<\"TextJustification\"\>"},
    {"3968", "670.`", "\<\"TextLine\"\>"},
    {"3969", "670.`", "\<\"TextPacket\"\>"},
    {"3970", "670.`", "\<\"TextParagraph\"\>"},
    {"3971", "670.`", "\<\"TextRecognize\"\>"},
    {"3972", "670.`", "\<\"TextRendering\"\>"},
    {"3973", "670.`", "\<\"TextStyle\"\>"},
    {"3974", "670.`", "\<\"Texture\"\>"},
    {"3975", "670.`", "\<\"TextureCoordinateFunction\"\>"},
    {"3976", "670.`", "\<\"TextureCoordinateScaling\"\>"},
    {"3977", "670.`", "\<\"ThermometerGauge\"\>"},
    {"3978", "670.`", "\<\"Thickness\"\>"},
    {"3979", "670.`", "\<\"Thinning\"\>"},
    {"3980", "670.`", "\<\"ThisLink\"\>"},
    {"3981", "670.`", "\<\"ThompsonGroupTh\"\>"},
    {"3982", "670.`", "\<\"Thread\"\>"},
    {"3983", "670.`", "\<\"ThreeJSymbol\"\>"},
    {"3984", "670.`", "\<\"Threshold\"\>"},
    {"3985", "670.`", "\<\"Through\"\>"},
    {"3986", "670.`", "\<\"Throw\"\>"},
    {"3987", "670.`", "\<\"Thumbnail\"\>"},
    {"3988", "670.`", "\<\"Thursday\"\>"},
    {"3989", "670.`", "\<\"Ticks\"\>"},
    {"3990", "670.`", "\<\"TicksStyle\"\>"},
    {"3991", "670.`", "\<\"TimeConstrained\"\>"},
    {"3992", "670.`", "\<\"TimeConstraint\"\>"},
    {"3993", "670.`", "\<\"TimeSeriesForecast\"\>"},
    {"3994", "670.`", "\<\"TimeSeriesInvertibility\"\>"},
    {"3995", "670.`", "\<\"TimeUsed\"\>"},
    {"3996", "670.`", "\<\"TimeValue\"\>"},
    {"3997", "670.`", "\<\"TimeZone\"\>"},
    {"3998", "670.`", "\<\"Timing\"\>"},
    {"3999", "670.`", "\<\"Tiny\"\>"},
    {"4000", "670.`", "\<\"TitleGrouping\"\>"},
    {"4001", "670.`", "\<\"TitsGroupT\"\>"},
    {"4002", "670.`", "\<\"ToBoxes\"\>"},
    {"4003", "670.`", "\<\"ToCharacterCode\"\>"},
    {"4004", "670.`", "\<\"ToColor\"\>"},
    {"4005", "670.`", "\<\"ToContinuousTimeModel\"\>"},
    {"4006", "670.`", "\<\"ToDate\"\>"},
    {"4007", "670.`", "\<\"ToDiscreteTimeModel\"\>"},
    {"4008", "670.`", "\<\"ToeplitzMatrix\"\>"},
    {"4009", "670.`", "\<\"ToExpression\"\>"},
    {"4010", "670.`", "\<\"ToFileName\"\>"},
    {"4011", "670.`", "\<\"Together\"\>"},
    {"4012", "670.`", "\<\"Toggle\"\>"},
    {"4013", "670.`", "\<\"ToggleFalse\"\>"},
    {"4014", "670.`", "\<\"Toggler\"\>"},
    {"4015", "670.`", "\<\"TogglerBar\"\>"},
    {"4016", "670.`", "\<\"TogglerBox\"\>"},
    {"4017", "670.`", "\<\"TogglerBoxOptions\"\>"},
    {"4018", "670.`", "\<\"ToHeldExpression\"\>"},
    {"4019", "670.`", "\<\"ToInvertibleTimeSeries\"\>"},
    {"4020", "670.`", "\<\"TokenWords\"\>"},
    {"4021", "670.`", "\<\"Tolerance\"\>"},
    {"4022", "670.`", "\<\"ToLowerCase\"\>"},
    {"4023", "670.`", "\<\"ToNumberField\"\>"},
    {"4024", "670.`", "\<\"TooBig\"\>"},
    {"4025", "670.`", "\<\"Tooltip\"\>"},
    {"4026", "670.`", "\<\"TooltipBox\"\>"},
    {"4027", "670.`", "\<\"TooltipBoxOptions\"\>"},
    {"4028", "670.`", "\<\"TooltipDelay\"\>"},
    {"4029", "670.`", "\<\"TooltipStyle\"\>"},
    {"4030", "670.`", "\<\"Top\"\>"},
    {"4031", "670.`", "\<\"TopHatTransform\"\>"},
    {"4032", "670.`", "\<\"TopologicalSort\"\>"},
    {"4033", "670.`", "\<\"ToRadicals\"\>"},
    {"4034", "670.`", "\<\"ToRules\"\>"},
    {"4035", "670.`", "\<\"ToString\"\>"},
    {"4036", "670.`", "\<\"Total\"\>"},
    {"4037", "670.`", "\<\"TotalHeight\"\>"},
    {"4038", "670.`", "\<\"TotalVariationFilter\"\>"},
    {"4039", "670.`", "\<\"TotalWidth\"\>"},
    {"4040", "670.`", "\<\"TouchscreenAutoZoom\"\>"},
    {"4041", "670.`", "\<\"TouchscreenControlPlacement\"\>"},
    {"4042", "670.`", "\<\"ToUpperCase\"\>"},
    {"4043", "670.`", "\<\"Tr\"\>"},
    {"4044", "670.`", "\<\"Trace\"\>"},
    {"4045", "670.`", "\<\"TraceAbove\"\>"},
    {"4046", "670.`", "\<\"TraceAction\"\>"},
    {"4047", "670.`", "\<\"TraceBackward\"\>"},
    {"4048", "670.`", "\<\"TraceDepth\"\>"},
    {"4049", "670.`", "\<\"TraceDialog\"\>"},
    {"4050", "670.`", "\<\"TraceForward\"\>"},
    {"4051", "670.`", "\<\"TraceInternal\"\>"},
    {"4052", "670.`", "\<\"TraceLevel\"\>"},
    {"4053", "670.`", "\<\"TraceOff\"\>"},
    {"4054", "670.`", "\<\"TraceOn\"\>"},
    {"4055", "670.`", "\<\"TraceOriginal\"\>"},
    {"4056", "670.`", "\<\"TracePrint\"\>"},
    {"4057", "670.`", "\<\"TraceScan\"\>"},
    {"4058", "670.`", "\<\"TrackedSymbols\"\>"},
    {"4059", "670.`", "\<\"TradingChart\"\>"},
    {"4060", "670.`", "\<\"TraditionalForm\"\>"},
    {"4061", "670.`", "\<\"TraditionalFunctionNotation\"\>"},
    {"4062", "670.`", "\<\"TraditionalNotation\"\>"},
    {"4063", "670.`", "\<\"TraditionalOrder\"\>"},
    {"4064", "670.`", "\<\"TransferFunctionCancel\"\>"},
    {"4065", "670.`", "\<\"TransferFunctionExpand\"\>"},
    {"4066", "670.`", "\<\"TransferFunctionFactor\"\>"},
    {"4067", "670.`", "\<\"TransferFunctionModel\"\>"},
    {"4068", "670.`", "\<\"TransferFunctionPoles\"\>"},
    {"4069", "670.`", "\<\"TransferFunctionTransform\"\>"},
    {"4070", "670.`", "\<\"TransferFunctionZeros\"\>"},
    {"4071", "670.`", "\<\"TransformationFunction\"\>"},
    {"4072", "670.`", "\<\"TransformationFunctions\"\>"},
    {"4073", "670.`", "\<\"TransformationMatrix\"\>"},
    {"4074", "670.`", "\<\"TransformedDistribution\"\>"},
    {"4075", "670.`", "\<\"TransformedField\"\>"},
    {"4076", "670.`", "\<\"Translate\"\>"},
    {"4077", "670.`", "\<\"TranslationTransform\"\>"},
    {"4078", "670.`", "\<\"TransparentColor\"\>"},
    {"4079", "670.`", "\<\"Transpose\"\>"},
    {"4080", "670.`", "\<\"TreeForm\"\>"},
    {"4081", "670.`", "\<\"TreeGraph\"\>"},
    {"4082", "670.`", "\<\"TreeGraphQ\"\>"},
    {"4083", "670.`", "\<\"TreePlot\"\>"},
    {"4084", "670.`", "\<\"TrendStyle\"\>"},
    {"4085", "670.`", "\<\"TriangleWave\"\>"},
    {"4086", "670.`", "\<\"TriangularDistribution\"\>"},
    {"4087", "670.`", "\<\"Trig\"\>"},
    {"4088", "670.`", "\<\"TrigExpand\"\>"},
    {"4089", "670.`", "\<\"TrigFactor\"\>"},
    {"4090", "670.`", "\<\"TrigFactorList\"\>"},
    {"4091", "670.`", "\<\"Trigger\"\>"},
    {"4092", "670.`", "\<\"TrigReduce\"\>"},
    {"4093", "670.`", "\<\"TrigToExp\"\>"},
    {"4094", "670.`", "\<\"TrimmedMean\"\>"},
    {"4095", "670.`", "\<\"True\"\>"},
    {"4096", "670.`", "\<\"TrueQ\"\>"},
    {"4097", "670.`", "\<\"TruncatedDistribution\"\>"},
    {"4098", "670.`", "\<\"TsallisQExponentialDistribution\"\>"},
    {"4099", "670.`", "\<\"TsallisQGaussianDistribution\"\>"},
    {"4100", "670.`", "\<\"TTest\"\>"},
    {"4101", "670.`", "\<\"Tube\"\>"},
    {"4102", "670.`", "\<\"TubeBezierCurveBox\"\>"},
    {"4103", "670.`", "\<\"TubeBezierCurveBoxOptions\"\>"},
    {"4104", "670.`", "\<\"TubeBox\"\>"},
    {"4105", "670.`", "\<\"TubeBSplineCurveBox\"\>"},
    {"4106", "670.`", "\<\"TubeBSplineCurveBoxOptions\"\>"},
    {"4107", "670.`", "\<\"Tuesday\"\>"},
    {"4108", "670.`", "\<\"TukeyLambdaDistribution\"\>"},
    {"4109", "670.`", "\<\"TukeyWindow\"\>"},
    {"4110", "670.`", "\<\"Tuples\"\>"},
    {"4111", "670.`", "\<\"TuranGraph\"\>"},
    {"4112", "670.`", "\<\"TuringMachine\"\>"},
    {"4113", "670.`", "\<\"UnateQ\"\>"},
    {"4114", "670.`", "\<\"Uncompress\"\>"},
    {"4115", "670.`", "\<\"Undefined\"\>"},
    {"4116", "670.`", "\<\"Underflow\"\>"},
    {"4117", "670.`", "\<\"Underlined\"\>"},
    {"4118", "670.`", "\<\"Underoverscript\"\>"},
    {"4119", "670.`", "\<\"UnderoverscriptBoxOptions\"\>"},
    {"4120", "670.`", "\<\"Underscript\"\>"},
    {"4121", "670.`", "\<\"UnderscriptBoxOptions\"\>"},
    {"4122", "670.`", "\<\"UndirectedGraph\"\>"},
    {"4123", "670.`", "\<\"UndirectedGraphQ\"\>"},
    {"4124", "670.`", "\<\"UndocumentedTestFEParserPacket\"\>"},
    {"4125", "670.`", "\<\"UndocumentedTestGetSelectionPacket\"\>"},
    {"4126", "670.`", "\<\"Unevaluated\"\>"},
    {"4127", "670.`", "\<\"UniformDistribution\"\>"},
    {"4128", "670.`", "\<\"UniformGraphDistribution\"\>"},
    {"4129", "670.`", "\<\"UniformSumDistribution\"\>"},
    {"4130", "670.`", "\<\"Uninstall\"\>"},
    {"4131", "670.`", "\<\"Unique\"\>"},
    {"4132", "670.`", "\<\"UnitBox\"\>"},
    {"4133", "670.`", "\<\"UnitConvert\"\>"},
    {"4134", "670.`", "\<\"UnitDimensions\"\>"},
    {"4135", "670.`", "\<\"UnitExchangeRate\"\>"},
    {"4136", "670.`", "\<\"Unitize\"\>"},
    {"4137", "670.`", "\<\"UnitRootTest\"\>"},
    {"4138", "670.`", "\<\"UnitSimplify\"\>"},
    {"4139", "670.`", "\<\"UnitStep\"\>"},
    {"4140", "670.`", "\<\"UnitTriangle\"\>"},
    {"4141", "670.`", "\<\"UnitVector\"\>"},
    {"4142", "670.`", "\<\"Unprotect\"\>"},
    {"4143", "670.`", "\<\"UnsavedVariables\"\>"},
    {"4144", "670.`", "\<\"Unset\"\>"},
    {"4145", "670.`", "\<\"UnsetShared\"\>"},
    {"4146", "670.`", "\<\"UntrackedVariables\"\>"},
    {"4147", "670.`", "\<\"Up\"\>"},
    {"4148", "670.`", "\<\"Update\"\>"},
    {"4149", "670.`", "\<\"UpdateDynamicObjects\"\>"},
    {"4150", "670.`", "\<\"UpdateDynamicObjectsSynchronous\"\>"},
    {"4151", "670.`", "\<\"UpdateInterval\"\>"},
    {"4152", "670.`", "\<\"UpperCaseQ\"\>"},
    {"4153", "670.`", "\<\"UpperTriangularize\"\>"},
    {"4154", "670.`", "\<\"Upsample\"\>"},
    {"4155", "670.`", "\<\"UpValues\"\>"},
    {"4156", "670.`", "\<\"URL\"\>"},
    {"4157", "670.`", "\<\"URLFetch\"\>"},
    {"4158", "670.`", "\<\"URLFetchAsynchronous\"\>"},
    {"4159", "670.`", "\<\"URLSave\"\>"},
    {"4160", "670.`", "\<\"URLSaveAsynchronous\"\>"},
    {"4161", "670.`", "\<\"UseGraphicsRange\"\>"},
    {"4162", "670.`", "\<\"Using\"\>"},
    {"4163", "670.`", "\<\"UsingFrontEnd\"\>"},
    {"4164", "670.`", "\<\"V2Get\"\>"},
    {"4165", "670.`", "\<\"ValidationLength\"\>"},
    {"4166", "670.`", "\<\"Value\"\>"},
    {"4167", "670.`", "\<\"ValueBox\"\>"},
    {"4168", "670.`", "\<\"ValueBoxOptions\"\>"},
    {"4169", "670.`", "\<\"ValueForm\"\>"},
    {"4170", "670.`", "\<\"ValueQ\"\>"},
    {"4171", "670.`", "\<\"ValuesData\"\>"},
    {"4172", "670.`", "\<\"Variables\"\>"},
    {"4173", "670.`", "\<\"Variance\"\>"},
    {"4174", "670.`", "\<\"VarianceEquivalenceTest\"\>"},
    {"4175", "670.`", "\<\"VarianceEstimatorFunction\"\>"},
    {"4176", "670.`", "\<\"VarianceGammaDistribution\"\>"},
    {"4177", "670.`", "\<\"VarianceTest\"\>"},
    {"4178", "670.`", "\<\"VectorAngle\"\>"},
    {"4179", "670.`", "\<\"VectorColorFunction\"\>"},
    {"4180", "670.`", "\<\"VectorColorFunctionScaling\"\>"},
    {"4181", "670.`", "\<\"VectorDensityPlot\"\>"},
    {"4182", "670.`", "\<\"VectorGlyphData\"\>"},
    {"4183", "670.`", "\<\"VectorPlot\"\>"},
    {"4184", "670.`", "\<\"VectorPlot3D\"\>"},
    {"4185", "670.`", "\<\"VectorPoints\"\>"},
    {"4186", "670.`", "\<\"VectorQ\"\>"},
    {"4187", "670.`", "\<\"Vectors\"\>"},
    {"4188", "670.`", "\<\"VectorScale\"\>"},
    {"4189", "670.`", "\<\"VectorStyle\"\>"},
    {"4190", "670.`", "\<\"Verbatim\"\>"},
    {"4191", "670.`", "\<\"Verbose\"\>"},
    {"4192", "670.`", "\<\"VerboseConvertToPostScriptPacket\"\>"},
    {"4193", "670.`", "\<\"VerifyConvergence\"\>"},
    {"4194", "670.`", "\<\"VerifySolutions\"\>"},
    {"4195", "670.`", "\<\"VerifyTestAssumptions\"\>"},
    {"4196", "670.`", "\<\"Version\"\>"},
    {"4197", "670.`", "\<\"VersionNumber\"\>"},
    {"4198", "670.`", "\<\"VertexAdd\"\>"},
    {"4199", "670.`", "\<\"VertexCapacity\"\>"},
    {"4200", "670.`", "\<\"VertexColors\"\>"},
    {"4201", "670.`", "\<\"VertexComponent\"\>"},
    {"4202", "670.`", "\<\"VertexConnectivity\"\>"},
    {"4203", "670.`", "\<\"VertexCoordinateRules\"\>"},
    {"4204", "670.`", "\<\"VertexCoordinates\"\>"},
    {"4205", "670.`", "\<\"VertexCorrelationSimilarity\"\>"},
    {"4206", "670.`", "\<\"VertexCosineSimilarity\"\>"},
    {"4207", "670.`", "\<\"VertexCount\"\>"},
    {"4208", "670.`", "\<\"VertexCoverQ\"\>"},
    {"4209", "670.`", "\<\"VertexDataCoordinates\"\>"},
    {"4210", "670.`", "\<\"VertexDegree\"\>"},
    {"4211", "670.`", "\<\"VertexDelete\"\>"},
    {"4212", "670.`", "\<\"VertexDiceSimilarity\"\>"},
    {"4213", "670.`", "\<\"VertexEccentricity\"\>"},
    {"4214", "670.`", "\<\"VertexInComponent\"\>"},
    {"4215", "670.`", "\<\"VertexInDegree\"\>"},
    {"4216", "670.`", "\<\"VertexIndex\"\>"},
    {"4217", "670.`", "\<\"VertexJaccardSimilarity\"\>"},
    {"4218", "670.`", "\<\"VertexLabeling\"\>"},
    {"4219", "670.`", "\<\"VertexLabels\"\>"},
    {"4220", "670.`", "\<\"VertexLabelStyle\"\>"},
    {"4221", "670.`", "\<\"VertexList\"\>"},
    {"4222", "670.`", "\<\"VertexNormals\"\>"},
    {"4223", "670.`", "\<\"VertexOutComponent\"\>"},
    {"4224", "670.`", "\<\"VertexOutDegree\"\>"},
    {"4225", "670.`", "\<\"VertexQ\"\>"},
    {"4226", "670.`", "\<\"VertexRenderingFunction\"\>"},
    {"4227", "670.`", "\<\"VertexReplace\"\>"},
    {"4228", "670.`", "\<\"VertexShape\"\>"},
    {"4229", "670.`", "\<\"VertexShapeFunction\"\>"},
    {"4230", "670.`", "\<\"VertexSize\"\>"},
    {"4231", "670.`", "\<\"VertexStyle\"\>"},
    {"4232", "670.`", "\<\"VertexTextureCoordinates\"\>"},
    {"4233", "670.`", "\<\"VertexWeight\"\>"},
    {"4234", "670.`", "\<\"Vertical\"\>"},
    {"4235", "670.`", "\<\"VerticalForm\"\>"},
    {"4236", "670.`", "\<\"VerticalGauge\"\>"},
    {"4237", "670.`", "\<\"VerticalSlider\"\>"},
    {"4238", "670.`", "\<\"ViewAngle\"\>"},
    {"4239", "670.`", "\<\"ViewCenter\"\>"},
    {"4240", "670.`", "\<\"ViewMatrix\"\>"},
    {"4241", "670.`", "\<\"ViewPoint\"\>"},
    {"4242", "670.`", "\<\"ViewPointSelectorSettings\"\>"},
    {"4243", "670.`", "\<\"ViewPort\"\>"},
    {"4244", "670.`", "\<\"ViewRange\"\>"},
    {"4245", "670.`", "\<\"ViewVector\"\>"},
    {"4246", "670.`", "\<\"ViewVertical\"\>"},
    {"4247", "670.`", "\<\"VirtualGroupData\"\>"},
    {"4248", "670.`", "\<\"Visible\"\>"},
    {"4249", "670.`", "\<\"VisibleCell\"\>"},
    {"4250", "670.`", "\<\"VoigtDistribution\"\>"},
    {"4251", "670.`", "\<\"VonMisesDistribution\"\>"},
    {"4252", "670.`", "\<\"WaitAll\"\>"},
    {"4253", "670.`", "\<\"WaitAsynchronousTask\"\>"},
    {"4254", "670.`", "\<\"WaitNext\"\>"},
    {"4255", "670.`", "\<\"WaitUntil\"\>"},
    {"4256", "670.`", "\<\"WakebyDistribution\"\>"},
    {"4257", "670.`", "\<\"WalleniusHypergeometricDistribution\"\>"},
    {"4258", "670.`", "\<\"WaringYuleDistribution\"\>"},
    {"4259", "670.`", "\<\"WatershedComponents\"\>"},
    {"4260", "670.`", "\<\"WatsonUSquareTest\"\>"},
    {"4261", "670.`", "\<\"WattsStrogatzGraphDistribution\"\>"},
    {"4262", "670.`", "\<\"WaveletBestBasis\"\>"},
    {"4263", "670.`", "\<\"WaveletFilterCoefficients\"\>"},
    {"4264", "670.`", "\<\"WaveletImagePlot\"\>"},
    {"4265", "670.`", "\<\"WaveletListPlot\"\>"},
    {"4266", "670.`", "\<\"WaveletMapIndexed\"\>"},
    {"4267", "670.`", "\<\"WaveletMatrixPlot\"\>"},
    {"4268", "670.`", "\<\"WaveletPhi\"\>"},
    {"4269", "670.`", "\<\"WaveletPsi\"\>"},
    {"4270", "670.`", "\<\"WaveletScale\"\>"},
    {"4271", "670.`", "\<\"WaveletScalogram\"\>"},
    {"4272", "670.`", "\<\"WaveletThreshold\"\>"},
    {"4273", "670.`", "\<\"WeaklyConnectedComponents\"\>"},
    {"4274", "670.`", "\<\"WeaklyConnectedGraphQ\"\>"},
    {"4275", "670.`", "\<\"WeakStationarity\"\>"},
    {"4276", "670.`", "\<\"WeatherData\"\>"},
    {"4277", "670.`", "\<\"WeberE\"\>"},
    {"4278", "670.`", "\<\"Wednesday\"\>"},
    {"4279", "670.`", "\<\"WeibullDistribution\"\>"},
    {"4280", "670.`", "\<\"WeierstrassHalfPeriods\"\>"},
    {"4281", "670.`", "\<\"WeierstrassInvariants\"\>"},
    {"4282", "670.`", "\<\"WeierstrassP\"\>"},
    {"4283", "670.`", "\<\"WeierstrassPPrime\"\>"},
    {"4284", "670.`", "\<\"WeierstrassSigma\"\>"},
    {"4285", "670.`", "\<\"WeierstrassZeta\"\>"},
    {"4286", "670.`", "\<\"WeightedAdjacencyGraph\"\>"},
    {"4287", "670.`", "\<\"WeightedAdjacencyMatrix\"\>"},
    {"4288", "670.`", "\<\"WeightedData\"\>"},
    {"4289", "670.`", "\<\"WeightedGraphQ\"\>"},
    {"4290", "670.`", "\<\"Weights\"\>"},
    {"4291", "670.`", "\<\"WelchWindow\"\>"},
    {"4292", "670.`", "\<\"WheelGraph\"\>"},
    {"4293", "670.`", "\<\"WhenEvent\"\>"},
    {"4294", "670.`", "\<\"Which\"\>"},
    {"4295", "670.`", "\<\"While\"\>"},
    {"4296", "670.`", "\<\"Whitespace\"\>"},
    {"4297", "670.`", "\<\"WhitespaceCharacter\"\>"},
    {"4298", "670.`", "\<\"WhittakerM\"\>"},
    {"4299", "670.`", "\<\"WhittakerW\"\>"},
    {"4300", "670.`", "\<\"WienerFilter\"\>"},
    {"4301", "670.`", "\<\"WienerProcess\"\>"},
    {"4302", "670.`", "\<\"WignerD\"\>"},
    {"4303", "670.`", "\<\"WignerSemicircleDistribution\"\>"},
    {"4304", "670.`", "\<\"WilksW\"\>"},
    {"4305", "670.`", "\<\"WilksWTest\"\>"},
    {"4306", "670.`", "\<\"WindowClickSelect\"\>"},
    {"4307", "670.`", "\<\"WindowElements\"\>"},
    {"4308", "670.`", "\<\"WindowFloating\"\>"},
    {"4309", "670.`", "\<\"WindowFrame\"\>"},
    {"4310", "670.`", "\<\"WindowFrameElements\"\>"},
    {"4311", "670.`", "\<\"WindowMargins\"\>"},
    {"4312", "670.`", "\<\"WindowMovable\"\>"},
    {"4313", "670.`", "\<\"WindowOpacity\"\>"},
    {"4314", "670.`", "\<\"WindowSelected\"\>"},
    {"4315", "670.`", "\<\"WindowSize\"\>"},
    {"4316", "670.`", "\<\"WindowStatusArea\"\>"},
    {"4317", "670.`", "\<\"WindowTitle\"\>"},
    {"4318", "670.`", "\<\"WindowToolbars\"\>"},
    {"4319", "670.`", "\<\"WindowWidth\"\>"},
    {"4320", "670.`", "\<\"With\"\>"},
    {"4321", "670.`", "\<\"WolframAlpha\"\>"},
    {"4322", "670.`", "\<\"WolframAlphaDate\"\>"},
    {"4323", "670.`", "\<\"WolframAlphaQuantity\"\>"},
    {"4324", "670.`", "\<\"WolframAlphaResult\"\>"},
    {"4325", "670.`", "\<\"Word\"\>"},
    {"4326", "670.`", "\<\"WordBoundary\"\>"},
    {"4327", "670.`", "\<\"WordCharacter\"\>"},
    {"4328", "670.`", "\<\"WordData\"\>"},
    {"4329", "670.`", "\<\"WordSearch\"\>"},
    {"4330", "670.`", "\<\"WordSeparators\"\>"},
    {"4331", "670.`", "\<\"WorkingPrecision\"\>"},
    {"4332", "670.`", "\<\"Write\"\>"},
    {"4333", "670.`", "\<\"WriteString\"\>"},
    {"4334", "670.`", "\<\"Wronskian\"\>"},
    {"4335", "670.`", "\<\"XMLElement\"\>"},
    {"4336", "670.`", "\<\"XMLObject\"\>"},
    {"4337", "670.`", "\<\"YuleDissimilarity\"\>"},
    {"4338", "670.`", "\<\"ZernikeR\"\>"},
    {"4339", "670.`", "\<\"ZeroSymmetric\"\>"},
    {"4340", "670.`", "\<\"ZeroTest\"\>"},
    {"4341", "670.`", "\<\"ZeroWidthTimes\"\>"},
    {"4342", "670.`", "\<\"Zeta\"\>"},
    {"4343", "670.`", "\<\"ZetaZero\"\>"},
    {"4344", "670.`", "\<\"ZipfDistribution\"\>"},
    {"4345", "670.`", "\<\"ZTest\"\>"},
    {"4346", "670.`", "\<\"ZTransform\"\>"},
    {"4347", "670.`", "\<\"$Aborted\"\>"},
    {"4348", "670.`", "\<\"$ActivationUserRegistered\"\>"},
    {"4349", "670.`", "\<\"$AssertFunction\"\>"},
    {"4350", "670.`", "\<\"$Assumptions\"\>"},
    {"4351", "670.`", "\<\"$AsynchronousTask\"\>"},
    {"4352", "670.`", "\<\"$BatchInput\"\>"},
    {"4353", "670.`", "\<\"$BatchOutput\"\>"},
    {"4354", "670.`", "\<\"$Canceled\"\>"},
    {"4355", "670.`", "\<\"$ConditionHold\"\>"},
    {"4356", "670.`", "\<\"$ControlActiveSetting\"\>"},
    {"4357", "670.`", "\<\"$CurrentLink\"\>"},
    {"4358", "670.`", "\<\"$DefaultFrontEnd\"\>"},
    {"4359", "670.`", "\<\"$DisplayFunction\"\>"},
    {"4360", "670.`", "\<\"$DynamicCurrencyConversion\"\>"},
    {"4361", "670.`", "\<\"$DynamicEvaluation\"\>"},
    {"4362", "670.`", "\<\"$Epilog\"\>"},
    {"4363", "670.`", "\<\"$Failed\"\>"},
    {"4364", "670.`", "\<\"$FormatType\"\>"},
    {"4365", "670.`", "\<\"$FrontEndSession\"\>"},
    {"4366", "670.`", "\<\"$IgnoreEOF\"\>"},
    {"4367", "670.`", "\<\"$InstallationDate\"\>"},
    {"4368", "670.`", "\<\"$Linked\"\>"},
    {"4369", "670.`", "\<\"$LinkSupported\"\>"},
    {"4370", "670.`", "\<\"$MessagePrePrint\"\>"},
    {"4371", "670.`", "\<\"$NetworkLicense\"\>"},
    {"4372", "670.`", "\<\"$NewMessage\"\>"},
    {"4373", "670.`", "\<\"$NewSymbol\"\>"},
    {"4374", "670.`", "\<\"$Notebooks\"\>"},
    {"4375", "670.`", "\<\"$NumberMarks\"\>"},
    {"4376", "670.`", "\<\"$Off\"\>"},
    {"4377", "670.`", "\<\"$PipeSupported\"\>"},
    {"4378", "670.`", "\<\"$Post\"\>"},
    {"4379", "670.`", "\<\"$Pre\"\>"},
    {"4380", "670.`", "\<\"$PrePrint\"\>"},
    {"4381", "670.`", "\<\"$PrintLiteral\"\>"},
    {"4382", "670.`", "\<\"$ScheduledTask\"\>"},
    {"4383", "670.`", "\<\"$SetParentLink\"\>"},
    {"4384", "670.`", "\<\"$SoundDisplayFunction\"\>"},
    {"4385", "670.`", "\<\"$SynchronousEvaluation\"\>"},
    {"4386", "670.`", "\<\"$SyntaxHandler\"\>"},
    {"4387", "670.`", "\<\"$TimedOut\"\>"},
    {"4388", "670.`", "\<\"$TraceOff\"\>"},
    {"4389", "670.`", "\<\"$TraceOn\"\>"},
    {"4390", "670.`", "\<\"$TracePattern\"\>"},
    {"4391", "670.`", "\<\"$TracePostAction\"\>"},
    {"4392", "670.`", "\<\"$TracePreAction\"\>"},
    {"4393", "670.`", "\<\"\[SystemsModelDelay]\"\>"},
    {"4394", "680.`", "\<\"PatternTest\"\>"},
    {"4395", "690.`", "\<\"SubsuperscriptBox\"\>"},
    {"4396", "695.`", "\<\"SubscriptBox\"\>"},
    {"4397", "700.`", "\<\"UnderoverscriptBox\"\>"},
    {"4398", "710.`", "\<\"OverscriptBox\"\>"},
    {"4399", "710.`", "\<\"UnderscriptBox\"\>"},
    {"4400", "720.`", "\<\"Get\"\>"},
    {"4401", "730.`", "\<\"Blank\"\>"},
    {"4402", "730.`", "\<\"BlankNullSequence\"\>"},
    {"4403", "730.`", "\<\"BlankSequence\"\>"},
    {"4404", "740.`", "\<\"Slot\"\>"},
    {"4405", "740.`", "\<\"SlotSequence\"\>"},
    {"4406", "750.`", "\<\"MessageName\"\>"},
    {"4407", "1000.`", "\<\"Black\"\>"},
    {"4408", "1000.`", "\<\"Blue\"\>"},
    {"4409", "1000.`", "\<\"Brown\"\>"},
    {"4410", "1000.`", "\<\"ComplexInfinity\"\>"},
    {"4411", "1000.`", "\<\"Cyan\"\>"},
    {"4412", "1000.`", "\<\"Dashed\"\>"},
    {"4413", "1000.`", "\<\"DotDashed\"\>"},
    {"4414", "1000.`", "\<\"Dotted\"\>"},
    {"4415", "1000.`", "\<\"Gray\"\>"},
    {"4416", "1000.`", "\<\"Green\"\>"},
    {"4417", "1000.`", "\<\"I\"\>"},
    {"4418", "1000.`", "\<\"Infinity\"\>"},
    {"4419", "1000.`", "\<\"LightBlue\"\>"},
    {"4420", "1000.`", "\<\"LightBrown\"\>"},
    {"4421", "1000.`", "\<\"LightCyan\"\>"},
    {"4422", "1000.`", "\<\"LightGray\"\>"},
    {"4423", "1000.`", "\<\"LightGreen\"\>"},
    {"4424", "1000.`", "\<\"LightMagenta\"\>"},
    {"4425", "1000.`", "\<\"LightOrange\"\>"},
    {"4426", "1000.`", "\<\"LightPink\"\>"},
    {"4427", "1000.`", "\<\"LightPurple\"\>"},
    {"4428", "1000.`", "\<\"LightRed\"\>"},
    {"4429", "1000.`", "\<\"LightYellow\"\>"},
    {"4430", "1000.`", "\<\"Magenta\"\>"},
    {"4431", "1000.`", "\<\"Orange\"\>"},
    {"4432", "1000.`", "\<\"Pink\"\>"},
    {"4433", "1000.`", "\<\"Purple\"\>"},
    {"4434", "1000.`", "\<\"Red\"\>"},
    {"4435", "1000.`", "\<\"Space\"\>"},
    {"4436", "1000.`", "\<\"System`$Version\"\>"},
    {"4437", "1000.`", "\<\"Tab\"\>"},
    {"4438", "1000.`", "\<\"Thick\"\>"},
    {"4439", "1000.`", "\<\"Thin\"\>"},
    {"4440", "1000.`", "\<\"Transparent\"\>"},
    {"4441", "1000.`", "\<\"White\"\>"},
    {"4442", "1000.`", "\<\"Yellow\"\>"},
    {"4443", "1000.`", "\<\"$ActivationGroupID\"\>"},
    {"4444", "1000.`", "\<\"$ActivationKey\"\>"},
    {"4445", "1000.`", "\<\"$AddOnsDirectory\"\>"},
    {"4446", "1000.`", "\<\"$BaseDirectory\"\>"},
    {"4447", "1000.`", "\<\"$BoxForms\"\>"},
    {"4448", "1000.`", "\<\"$ByteOrdering\"\>"},
    {"4449", "1000.`", "\<\"$CharacterEncoding\"\>"},
    {"4450", "1000.`", "\<\"$CharacterEncodings\"\>"},
    {"4451", "1000.`", "\<\"$CommandLine\"\>"},
    {"4452", "1000.`", "\<\"$CompilationTarget\"\>"},
    {"4453", "1000.`", "\<\"$ConfiguredKernels\"\>"},
    {"4454", "1000.`", "\<\"$Context\"\>"},
    {"4455", "1000.`", "\<\"$ContextPath\"\>"},
    {"4456", "1000.`", "\<\"$CreationDate\"\>"},
    {"4457", "1000.`", "\<\"$DateStringFormat\"\>"},
    {"4458", "1000.`", "\<\"$DefaultFont\"\>"},
    {"4459", "1000.`", "\<\"$DefaultPath\"\>"},
    {"4460", "1000.`", "\<\"$Display\"\>"},
    {"4461", "1000.`", "\<\"$DistributedContexts\"\>"},
    {"4462", "1000.`", "\<\"$Echo\"\>"},
    {"4463", "1000.`", "\<\"$ExportFormats\"\>"},
    {"4464", "1000.`", "\<\"$FinancialDataSource\"\>"},
    {"4465", "1000.`", "\<\"$FrontEnd\"\>"},
    {"4466", "1000.`", "\<\"$GeoLocation\"\>"},
    {"4467", "1000.`", "\<\"$HistoryLength\"\>"},
    {"4468", "1000.`", "\<\"$HomeDirectory\"\>"},
    {"4469", "1000.`", "\<\"$HTTPCookies\"\>"},
    {"4470", "1000.`", "\<\"$ImportFormats\"\>"},
    {"4471", "1000.`", "\<\"$InitialDirectory\"\>"},
    {"4472", "1000.`", "\<\"$Input\"\>"},
    {"4473", "1000.`", "\<\"$InputFileName\"\>"},
    {"4474", "1000.`", "\<\"$InputStreamMethods\"\>"},
    {"4475", "1000.`", "\<\"$Inspector\"\>"},
    {"4476", "1000.`", "\<\"$InstallationDirectory\"\>"},
    {"4477", "1000.`", "\<\"$InterfaceEnvironment\"\>"},
    {"4478", "1000.`", "\<\"$IterationLimit\"\>"},
    {"4479", "1000.`", "\<\"$KernelCount\"\>"},
    {"4480", "1000.`", "\<\"$KernelID\"\>"},
    {"4481", "1000.`", "\<\"$Language\"\>"},
    {"4482", "1000.`", "\<\"$LaunchDirectory\"\>"},
    {"4483", "1000.`", "\<\"$LibraryPath\"\>"},
    {"4484", "1000.`", "\<\"$LicenseExpirationDate\"\>"},
    {"4485", "1000.`", "\<\"$LicenseID\"\>"},
    {"4486", "1000.`", "\<\"$LicenseProcesses\"\>"},
    {"4487", "1000.`", "\<\"$LicenseServer\"\>"},
    {"4488", "1000.`", "\<\"$LicenseSubprocesses\"\>"},
    {"4489", "1000.`", "\<\"$LicenseType\"\>"},
    {"4490", "1000.`", "\<\"$Line\"\>"},
    {"4491", "1000.`", "\<\"$LoadedFiles\"\>"},
    {"4492", "1000.`", "\<\"$MachineAddresses\"\>"},
    {"4493", "1000.`", "\<\"$MachineDomain\"\>"},
    {"4494", "1000.`", "\<\"$MachineDomains\"\>"},
    {"4495", "1000.`", "\<\"$MachineEpsilon\"\>"},
    {"4496", "1000.`", "\<\"$MachineID\"\>"},
    {"4497", "1000.`", "\<\"$MachineName\"\>"},
    {"4498", "1000.`", "\<\"$MachinePrecision\"\>"},
    {"4499", "1000.`", "\<\"$MachineType\"\>"},
    {"4500", "1000.`", "\<\"$MaxExtraPrecision\"\>"},
    {"4501", "1000.`", "\<\"$MaxLicenseProcesses\"\>"},
    {"4502", "1000.`", "\<\"$MaxLicenseSubprocesses\"\>"},
    {"4503", "1000.`", "\<\"$MaxMachineNumber\"\>"},
    {"4504", "1000.`", "\<\"$MaxNumber\"\>"},
    {"4505", "1000.`", "\<\"$MaxPiecewiseCases\"\>"},
    {"4506", "1000.`", "\<\"$MaxPrecision\"\>"},
    {"4507", "1000.`", "\<\"$MaxRootDegree\"\>"},
    {"4508", "1000.`", "\<\"$MessageGroups\"\>"},
    {"4509", "1000.`", "\<\"$MessageList\"\>"},
    {"4510", "1000.`", "\<\"$Messages\"\>"},
    {"4511", "1000.`", "\<\"$MinMachineNumber\"\>"},
    {"4512", "1000.`", "\<\"$MinNumber\"\>"},
    {"4513", "1000.`", "\<\"$MinorReleaseNumber\"\>"},
    {"4514", "1000.`", "\<\"$MinPrecision\"\>"},
    {"4515", "1000.`", "\<\"$ModuleNumber\"\>"},
    {"4516", "1000.`", "\<\"$OperatingSystem\"\>"},
    {"4517", "1000.`", "\<\"$Output\"\>"},
    {"4518", "1000.`", "\<\"$OutputForms\"\>"},
    {"4519", "1000.`", "\<\"$OutputSizeLimit\"\>"},
    {"4520", "1000.`", "\<\"$OutputStreamMethods\"\>"},
    {"4521", "1000.`", "\<\"$Packages\"\>"},
    {"4522", "1000.`", "\<\"$ParentLink\"\>"},
    {"4523", "1000.`", "\<\"$ParentProcessID\"\>"},
    {"4524", "1000.`", "\<\"$PasswordFile\"\>"},
    {"4525", "1000.`", "\<\"$PatchLevelID\"\>"},
    {"4526", "1000.`", "\<\"$Path\"\>"},
    {"4527", "1000.`", "\<\"$PathnameSeparator\"\>"},
    {"4528", "1000.`", "\<\"$PerformanceGoal\"\>"},
    {"4529", "1000.`", "\<\"$PreferencesDirectory\"\>"},
    {"4530", "1000.`", "\<\"$PreRead\"\>"},
    {"4531", "1000.`", "\<\"$PrintForms\"\>"},
    {"4532", "1000.`", "\<\"$ProcessID\"\>"},
    {"4533", "1000.`", "\<\"$ProcessorCount\"\>"},
    {"4534", "1000.`", "\<\"$ProcessorType\"\>"},
    {"4535", "1000.`", "\<\"$ProductInformation\"\>"},
    {"4536", "1000.`", "\<\"$ProgramName\"\>"},
    {"4537", "1000.`", "\<\"$RandomState\"\>"},
    {"45