Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xPerm",
 FontColor->RGBColor[
  1, 0, 0]]], "Title",ExpressionUUID->"55ac65c9-c9ed-478d-8ce3-d2860a91bd1b"],

Cell[TextData[StyleBox["Fast manipulation of permutation groups",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subtitle",ExpressionUUID->"7b4a6ffc-9d02-42af-9b78-9750ca27a1f4"],

Cell[TextData[{
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a\n",
  FontSize->18],
 "(c) 2003-2026, under GPL",
 StyleBox["\n\n",
  FontSize->18],
 "jose@xact.es\nhttp://www.xact.es/\nhttp://groups.google.com/group/xAct"
}], "Subsubtitle",ExpressionUUID->"7928d062-f525-447a-a01b-6f5a870986d5"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["0. Info and copyright",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"f1bf8997-d929-41f8-9289-da0f85aeb4c4"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}],
    "*", " ", "0.", " ", "Info", " ", "and", " ", 
   RowBox[{"copyright", " ", "**", "**", "**"}]}], 
  "*****************)"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[1]:=",ExpressionUUID->"3d61e45f-7cb9-4ede-ad9e-df8f33deef89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "/@", 
  RowBox[{"Date", "[", "]"}]}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"36034fda-b163-4ea7-910b-c05ad70740d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2025", ",", "12", ",", "28", ",", "23", ",", "21", ",", "27"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",ExpressionUUID->"27c5f1eb-709c-40d4-8996-2a52e2d44a15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xPerm`$Version", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<1.2.4\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[3]:=",ExpressionUUID->"ab4362b6-e64f-4139-ad0c-a37a9b776121"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1.2.4\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",ExpressionUUID->"25390916-feee-4df8-96cd-6090bcd63f61"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$SessionID"], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"a7939b21-d6a0-419b-b3fc-4fe5267d1de4"],

Cell[BoxData["23259867208577765251"], "Output",
 CellLabel->"Out[4]=",ExpressionUUID->"67ca4ba3-7111-4172-8763-307bd0776b77"]
}, Open  ]],

Cell[CellGroupData[{

Cell["0.1. GPL", \
"Subsection",ExpressionUUID->"1212fc2d-590a-4c9a-a08a-b31476a0aa0e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xPerm", ",", " ", 
    RowBox[{
    "a", " ", "free", " ", "package", " ", "for", " ", "permutation", " ", 
     "groups", " ", "in", " ", "Mathematica"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Copyright", " ", 
     RowBox[{"(", "C", ")"}], " ", "2003"}], "-", 
    RowBox[{"2026", " ", "Jose", " ", 
     RowBox[{"M", ".", " ", "Martin"}]}], "-", "Garcia"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", "\[IndentingNewLine]", " ", 
      "it", " ", "under", " ", "the", " ", "terms", " ", "of", " ", "the", " ",
       "GNU", " ", "General", " ", "Public", " ", "License", " ", "as", " ", 
      "published", " ", "by", "\[IndentingNewLine]", " ", "the", " ", "Free", 
      " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", "of", " ", "the", " ", "License"}]}],
     ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], " ",
      "program", " ", "is", " ", "distributed", " ", "in", " ", "the", " ", 
     "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", "useful"}], 
    ",", " ", 
    RowBox[{
     RowBox[{
     "but", "\[IndentingNewLine]", " ", "WITHOUT", " ", "ANY", " ", 
      "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", " ", "MERCHANTABILITY", "\[IndentingNewLine]", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", " ", 
      "General", " ", "Public", " ", "License", "\[IndentingNewLine]", " ", 
      "for", " ", "more", " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], " ",
       "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ", 
      "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", " ", "along", "\[IndentingNewLine]", " ", "with", " ", 
      "this", " ", "program"}], ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", " ", 
     "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", " ", 
    RowBox[{"USA", "."}]}], "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[5]:=",ExpressionUUID->"99357c5b-f490-4059-9f5d-68555bb407de"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.2. Info package", \
"Subsection",ExpressionUUID->"826116cc-30b6-4a69-8e4d-f30989a65b99"],

Cell["\<\
(* :Title: xPerm *)

(* :Author: Jose M. Martin-Garcia *)

(* :Summary: Computational group theory for index canonicalization *)

(* :Brief Discussion:
    - Notations for permutations: It is not clear which one is better,
      so that four are encoded: Perm, Images, Cycles and Rules.
    - Permutations act on the right of lists or other permutations.
      This is the choice in GAP and Butler's book.
    - We follow Portugal's notation: permutations map slots to indices.
    - There are two main objectives in this package:
        a) Schreier-Sims algorithm (Butler's book)
        b) choice of coset and double-coset representatives
           (Portugal's papers).
    - This is the Mathematica code of the package. An external C code
      with a subset of capabilities can be linked via MathLink.
    - Mathematica 9 contains the Butler-Portugal algorithm, but xPerm
      does not yet link to it by default.  
*)
  
(* :Context: xAct`xPerm` *)

(* :Package Version: 1.2.4 *)

(* :Copyright: Jose M. Martin-Garcia 2003-2026 *)

(* :History: (see xPerm.History for details)
    - Version 0.1 (May 2003): Schreier-Sims coded from Butler's book.
      Portugal's routines encoded.
    - Version 0.2 (July 2003): Recoding in C, using Images notations,
      and connection through MathLink. Much faster.
    - Version 0.3 (August 2003): Recoded signed permutations. The basic
      mathematical structure is an algebra, and not the {-1,1} x Sn group.
    - Version 0.4 (March 2004): First public release.
    - Version 0.5 (July 2006) 
    - Version 0.6 (August 2007)
    - Version 0.7 (November 2007)
    - Version 1.0 (March 2008): Release for publication.
    - Version 1.1 (September 2010)
    - Version 1.2 (January 2013)
*)

(* :Keywords: permutations, index canonicalization, Butler-Portugal algorithm \
*)

(* :Source: xPerm.nb *)

(* :Mathematica Version: 5.0 and later *)

(* :Limitations: Only permutation symmetries, not multiterm symmetries *)\
\>", "Input",
 InitializationCell->
  True,ExpressionUUID->"adc0f781-8efb-48d8-9aca-6d7cbbd80c17"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.3. TODO", \
"Subsection",ExpressionUUID->"b62eda95-af53-4303-84d8-d180aeab6724"],

Cell[TextData[{
 "Link to the new canonicalizer in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 9, which is generally faster."
}], "Text",ExpressionUUID->"cc2941ab-e69e-45dc-9372-3c0e11413e20"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1. Begin package",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"476dfd8b-74c4-4187-8961-372e8f5feb22"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}],
    "*", " ", "1.", " ", "Begin", " ", "package"}], " ", 
  "***********************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2b8ed612-c52c-41e9-9c63-ccbd290de720"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"b4d84462-32f3-44aa-82a1-e1d4cf82afde"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.060214`", ",", "1.745241`6.693400400575256", ",", 
   "0.6074942587219296`"}], 
  "}"}]], "Output",ExpressionUUID->"b2b5ddfb-4719-430b-9e43-58d50d6d0473"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.1. Begin package", \
"Subsection",ExpressionUUID->"b790a7b6-307b-47ef-8a04-661cb0f1a012"],

Cell["Protect against multiple loading of the package:", \
"Text",ExpressionUUID->"d8ce889d-4013-412b-bd33-8fe6846029da"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xAct`xPerm`Private`xPermSymbols", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Names", "[", "\"\<xAct`xPerm`*\>\"", "]"}], ",", 
         RowBox[{"Names", "[", "\"\<xAct`xPerm`Private`*\>\"", "]"}]}], "]"}],
        ",", 
       RowBox[{"\"\<$Version\>\"", "|", "\"\<xAct`xPerm`$Version\>\""}]}], 
      "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "/@", "xAct`xPerm`Private`xPermSymbols"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Clear", "/@", "xAct`xPerm`Private`xPermSymbols"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[29]:=",ExpressionUUID->"bf973e2e-72a0-4ab1-842e-9cae89022cc1"],

Cell["\<\
Decide whether the package is being loaded from other package:\
\>", "Text",ExpressionUUID->"00fa0e03-6d96-40d9-bd4c-a3beceeacafd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{"xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`xPerm`\>\""}]}],
    "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[30]:=",ExpressionUUID->"1c44dc34-e53d-4757-818c-05aaad4274c1"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"2db387ab-f159-46e0-a4a9-f127111ba825"],

Cell[BoxData["\<\"xAct`xPerm`\"\>"], "Output",
 CellLabel->
  "Out[31]=",ExpressionUUID->"ab3de6ee-6432-4c97-90f4-046e029fb22c"]
}, Open  ]],

Cell[TextData[{
 "Temporary fix for the conflicts with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 8.0:"
}], "Text",ExpressionUUID->"01a8b104-2914-4d7f-b488-6c183a8e3dfb"],

Cell[BoxData[{
 RowBox[{"xAct`xPerm`Cycles", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xPerm`RightCosetRepresentative", ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"System`Cycles", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"System`Cycles", "::", "shdw"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[32]:=",ExpressionUUID->"b7b43797-12d8-4238-9bdc-3d6407155609"],

Cell[TextData[{
 "Start the ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " package. It needs the ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " package. From version 0.6.2 of ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " the package ",
 StyleBox["ExpressionManipulation",
  FontSlant->"Italic"],
 " is not automatically read."
}], "Text",ExpressionUUID->"2a9f2fac-b836-4b74-9de6-b007a85f8aec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`xPerm`\>\"", ",", 
   RowBox[{"{", "\"\<xAct`xCore`\>\"", "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[36]:=",ExpressionUUID->"4257458f-48bf-411f-a304-2e4a029653e9"],

Cell[BoxData["\<\"xAct`xPerm`\"\>"], "Output",
 CellLabel->
  "Out[36]=",ExpressionUUID->"ce391db3-3ee5-4a19-b3e9-d2c1ae7745ed"]
}, Open  ]],

Cell["Message:", \
"Text",ExpressionUUID->"5ae97faf-c7e8-404d-b208-dd358abc158a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"xAct`xCore`Private`$LastPackage", "=!=", "\"\<Tensors`\>\""}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Package xAct`xPerm`  version \>\"", ",", 
       RowBox[{"$Version", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
       RowBox[{"$Version", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", "\"\<CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under \
the General Public License.\>\"", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[37]:=",ExpressionUUID->"86ff9ea5-c56d-4334-ba98-3f83648140e6"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"4d40ce4e-6129-4e7e-a863-d922a4d2eadd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.4", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"791ed28a-89ea-4ddf-8bc9-7159005c6504"],

Cell[BoxData["\<\"CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"0d635ba6-ffec-4ef8-b993-1fb7ddf84659"]
}, Open  ]]
}, Open  ]],

Cell["\<\
The Disclaimer of GPL (remove temporarily the General::shdw message to avoid \
collision with the disclaimer messages of other packages):\
\>", "Text",ExpressionUUID->"d0bc990f-413d-43d8-a91a-4b1e69000869"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xPerm`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[38]:=",ExpressionUUID->"298f2e03-60ca-4b85-bb37-a6a2a940e21c"],

Cell[TextData[{
 "If ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " is not being called from other package then write this GPL short \
disclaimer:"
}], "Text",ExpressionUUID->"7865d911-24aa-4cb4-b609-95d85f185773"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`xPerm`\>\""}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Print", "[", "\"\<These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\>\"", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[41]:=",ExpressionUUID->"f12a5b14-899e-4fd8-8b9f-1a7774aebc78"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"e32975b6-3f9a-4228-92f4-ce0b48927730"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"e4d07b04-a384-4837-b1d6-5731268cc5e1"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"8dc9e15d-87b9-441d-a79e-6aa7f85b4e4b"]
}, Open  ]]
}, Open  ]],

Cell["This is the output of the Disclaimer[] command:", \
"Text",ExpressionUUID->"a582c3f2-733c-4fcb-91ca-be8d529d12fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Disclaimer", "[", "]"}]], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"5bedfa0f-9f40-4dd1-ac1e-e21329aff01f"],

Cell[BoxData["\<\"These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"0c04c98f-fa59-4557-917a-bcc25c765c62"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Usage messages", \
"Subsection",ExpressionUUID->"1c28e918-56d3-4778-b0c1-1bb852fd4a11"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Notations", " ", "and", " ", "translation"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Perm", "::", "usage"}], 
     "=", "\"\<Perm is the head for permutation lists of the form Perm[{n1, \
..., nk}]. Example: Perm[{6, 3, 2, 1, 5, 4}] means that the object in the \
first place goes to the fourth place and so on. Perm[{}] represents the \
identity.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cycles", "::", "usage"}], 
     "=", "\"\<Cycles is the head for permutations expressed in disjoint \
cyclic notation. Singletons are not included. Example: Cycles[{1, 4, 6}, {2, \
3}] represents the exchange of points 2 and 3, and the cycle 1->4->6->1. \
Cycles[] represents the identity.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Rules", "::", "usage"}], 
     "=", "\"\<Rules is the head for permutations expressed in rule notation. \
Singletons are not included. Example: Rules[1->4, 4->6, 6->1, 2->3, 3->2]. \
Rules[] represents the identity.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Images", "::", "usage"}], 
     "=", "\"\<Images is the head for permutations expressed as a list of \
images. Example: Images[{4, 3, 2, 6, 5, 1}]. Images[{}] represents the \
identity.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermQ", "::", "usage"}], 
     "=", "\"\<PermQ[ Perm[{n1, ..., nk}] ] yields True if the list {n1, ..., \
nk} of length k is a rearrangement of the numbers {1, ..., k}. PermQ[ \
Cycles[cyc1, cyc2, ...] ] gives True if there are no repeated points among \
cycles cyci. PermQ[ Rules[i1->i2, ...] ] gives True if the rules map a set of \
integers to itself. PermQ[ Images[{n1, ..., nk}] ] yields True if the list \
{n1, ..., nk} of length k is a rearrangement of the numbers {1, ..., k}. \
PermQ[ID] gives True. PermQ gives True on a linear combination of valid \
permutations. PermQ returns False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ID", "::", "usage"}], 
     "=", "\"\<ID represents the identity in all notations. ID[perm] gives \
the identity permutation in the notation used by perm.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NotationOfPerm", "::", "usage"}], 
     "=", "\"\<NotationOfPerm[perm] gives the notation of permutation perm. \
It can be one of {Perm, length}, {Images, length}, Cyles or Rules.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TranslatePerm", "::", "usage"}], 
     "=", "\"\<TranslatePerm[perm, notation] translates permutation perm, in \
any format, to the given notation, which must be one of Perm, {Perm, length}, \
Cycles, Rules, Images or {Images, length}. TranslatePerm[set, notation] \
returns the set (with head GenSet, StrongGenSet, Group or Coset) with all its \
permutations translated to notation.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RandomPerm", "::", "usage"}], 
     "=", "\"\<RandomPerm[deg] gives a random permutation in Perm notation. \
RandomPerm[deg, notation] constructs RandomPerm[deg] and then translates it \
to the given notation using TranslatePerm[perm, notation].\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c071c04e-2c21-4277-a253-e68d1c39f8df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Operations", " ", "with", " ", "permutations"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PermLength", "::", "usage"}], 
     "=", "\"\<PermLength[perm] gives the so-called length of permutation \
perm. If expressed in Perm or Images notation, the length of perm is the \
length of the list of points. In other cases, it returns \
PermDeg[perm].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermDeg", "::", "usage"}], 
     "=", "\"\<PermDeg[perm] gives the degree of permutation perm, defined as \
the largest point moved. The degree of (any form of) the identity is 0. \
PermDeg[set] gives the largest degree among the permutations of the set (a \
group, generating set, strong generating set or linear combination).\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermProduct", "::", "usage"}], 
     "=", "\"\<PermProduct[perm1, perm2] gives the composition of \
permutations perm1 and perm2, applied from left to right, that is, the result \
is equivalent to the application of perm2 after perm1 on a list of points. \
PermProduct[perm1, perm2, perm3, ...] composes all permutations, assuming \
that they all use the same notation. PermProduct[perm] gives perm and \
PermProduct[] gives ID.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InversePerm", "::", "usage"}], 
     "=", "\"\<InversePerm[perm] gives the inverse permutation of \
perm.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermPower", "::", "usage"}], 
     "=", "\"\<PermPower[perm, n] for positive n gives the composition of n \
copies of perm. For negative n it gives the composition of n copies of \
InversePerm[perm]. For zero n it gives ID[perm].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OnPoints", "::", "usage"}], 
     "=", "\"\<OnPoints[p, perm] yields the image of point p under \
permutation perm. OnPoints[{p1, ...}, perm] yields the list of images of \
points pi. Signs of permutations are not considered.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermSignature", "::", "usage"}], 
     "=", "\"\<PermSignature[perm] gives the signature of perm: +1 if perm \
can be written as an even number of transpositions, -1 if perm can be written \
as an odd number of transpositions.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Stabilization", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"StablePoints", "::", "usage"}], 
     "=", "\"\<StablePoints[perm, n] gives the points in {1, ..., n} that are \
fixed by permutation perm. StablePoints[GS, n] gives the points in {1, ..., \
n} that are fixed by all permutations in GS.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NonStablePoints", "::", "usage"}], 
     "=", "\"\<NonStablePoints[list, GS] enlarges list until none of the \
permutations in GS fixes all points in list. It tries to give the shortest \
result possible, not necessarily ordered.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Stabilizer", "::", "usage"}], 
     "=", "\"\<Stabilizer[{p1, ...}, GS] gives the subset of permutations in \
GS that fix all points pi. Stabilizer[{p1, ...}, SGS] returns a strong \
generating set for the stabilizer subgroup of the group SGS fixing all points \
pi. In this latter case a third argument can be given with the length of the \
internal Schreier vectors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetStabilizer", "::", "usage"}], 
     "=", "\"\<SetStabilizer[{p1, ...}, GS] gives the subset of permutations \
in GS that keep the points pi inside the list. SetStabilizer[{p1, ...}, SGS] \
returns a strong generating set for the setwise stabilizer of the list of \
points pi under the group generated by the strong generating set SGS.\>\""}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Permuting", " ", "lists"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermutationFromTo", "::", "usage"}], 
     "=", "\"\<PermutationFromTo[list1, list2] gives the permutation (in \
Images notation) that converts list1 into list2. Points in list1 or list2 can \
be repeated.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermuteList", "::", "usage"}], 
     "=", "\"\<PermuteList[list, perm] permutes the points of list according \
to the permutation perm.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Sorting", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortB", "::", "usage"}], 
     "=", "\"\<SortB[{e1, e2, ...}, B] sorts the elements ei according to the \
canonical order defined by list B. Elements not in B are sorted last, using \
Sort.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"MinB", "::", "usage"}], 
     "=", "\"\<MinB[list, B] gives the mininum element of list with respect \
to base B. If none of the elements of B is in list then the minimum of list \
with respect to the canonical order is returned.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermOrderedQ", "::", "usage"}], 
     "=", "\"\<PermOrderedQ[h[perm1, perm2]] gives True if perm1 maps \
integers to smaller points than perm2. It gives False if perm1 maps integers \
to larger points than perm2. It gives Null if perm1 and perm2 maps integers \
to the same points. PermOrderedQ[h[perm1, perm2], B] gives True if perm1 maps \
the points of base B to smaller (according to B) images than perm2. It gives \
False if perm1 maps the points of B to larger (according to B) images than \
perm2. It gives Null if perm1 and perm2 map the points of B to the same \
images.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermSort", "::", "usage"}], 
     "=", "\"\<PermSort[{perm1, perm2, ...}] sorts permutations permi \
according to PermOrderedQ. PermSort[{perm1, perm2, ...}, B] sorts \
permutations permi according to PermOrderedQ using base B.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermEqual", "::", "usage"}], 
     "=", "\"\<PermEqual[perm1, perm2] gives True if both permutations map \
all points to the same images, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermLess", "::", "usage"}], 
     "=", "\"\<PermLess[perm1, perm2] gives True if perm1 maps sorted \
integers to smaller points than perm2, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermGreater", "::", "usage"}], 
     "=", "\"\<PermGreater[perm1, perm2] gives True if perm1 maps sorted \
integers to larger points than perm2, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermLessEqual", "::", "usage"}], 
     "=", "\"\<PermLessEqual[perm1, perm2] gives True if perm1 maps sorted \
integers to smaller or equal points than perm2, and False otherwise.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermGreaterEqual", "::", "usage"}], 
     "=", "\"\<PermGreaterEqual[perm1, perm2] gives True if perm1 maps sorted \
integers to larger of equal points than perm2, and False otherwise.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fb7bb8fd-8171-46c9-ad1b-6f1479be4183"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Structures", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"GenSet", "::", "usage"}], 
     "=", "\"\<GenSet is the head for a generating set.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Group", "::", "usage"}], 
     "=", "\"\<Group is the head for a group of permutations.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Coset", "::", "usage"}], 
     "=", "\"\<Coset is the head for a coset of permutations.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Schreier", "::", "usage"}], 
     "=", "\"\<Schreier is the head for a Schreier vector. The format is \
Schreier[orbits, nu, w], where nu is the actual Schreier vector and w is the \
associated vector of backward pointers.\>\""}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"StrongGenSet", "::", "usage"}], 
     "=", "\"\<StrongGenSet is the head for a strong generating set. The \
format is StrongGenSet[base, GS].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dimino", "::", "usage"}], 
     "=", "\"\<Dimino[GenSet[perm1, ...]] gives the group generated by \
permutations permi, using Dimino's algorithm.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e00bafac-8ce1-4231-a54c-338818234ff0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Strong", " ", "generating", " ", "sets"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Orbit", "::", "usage"}], 
     "=", "\"\<Orbit[p, GS] gives the orbit of point p under the group \
generated by GS. The orbit is given as a (not necessarily ordered) list \
having p as first point.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbits", "::", "usage"}], 
     "=", "\"\<Orbits[GS, len] gives a list with all orbits of the group \
generated by permutations in GS, a partition of Range[len]. Orbits[GS, len, \
list] makes points in list to be the first points of the orbits. Orbits[GS] \
and Orbits[GS, list] compute len from GS using PermLength. GS can be a \
generating set (head GenSet) or a strong generating set (head \
StrongGenSet).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierOrbit", "::", "usage"}], 
     "=", "\"\<SchreierOrbit[p, GS, len] gives the orbit of point p under the \
group generated by GS, and its Schreier vector (of lenght len). \
SchreierOrbit[p, SGS, len] gives the same output, but the the first point of \
the orbit is now the minimum with respect to the base of the SGS. \
SchreierOrbit[p, gs] computes the length of the vectors from gs using \
PermLength. See notes for Schreier.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierOrbits", "::", "usage"}], 
     "=", "\"\<SchreierOrbits[GS, len] gives a compound Schreier vector \
(length len) of the orbits of the group generated by GS. SchreierOrbits[GS, \
len, list] makes points in list to be the first points of the orbits. \
SchreierOrbits[SGS, len] gives the same output, but the orbits now start with \
the points of the base of the SGS. SchreierOrbits[gs] computes len from gs \
using PermLength. See notes for Schreier.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TraceSchreier", "::", "usage"}], 
     "=", "\"\<TraceSchreier[p, Schreier[orbits, nu, w]] finds a permutation \
such that the image of the first point of the orbit of p is p.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"StabilizerChain", "::", "usage"}], 
     "=", "\"\<StabilizerChain[SGS] gives a list of strong generating sets \
corresponding to the chain of stabilizers of the group generated by SGS. The \
first one is SGS and the last one is the generating set of Group[ID].\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OrderOfGroup", "::", "usage"}], 
     "=", "\"\<OrderOfGroup[SGS] gives the order of the group generated by \
SGS.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermMemberQ", "::", "usage"}], 
     "=", "\"\<PermMemberQ[perm, SGS] gives True if permutation perm belongs \
to the group generated by SGS, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermWord", "::", "usage"}], 
     "=", "\"\<PermWord[perm, SGS] decompose the permutation perm as {pk, \
..., p0} where each of the permutations pi belong to the stabilizer subgroup \
of the first i points of the base of SGS. If pk == ID then perm belongs to \
the group and not otherwise. There is a third argument, used internally for \
iteration.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FromBaseImage", "::", "usage"}], 
     "=", "\"\<FromBaseImage[list, SGS] gives the permutation in the group \
described by SGS such that the images of the points in the base are the \
points in list (assumed to have the length of the base of the SGS). If no \
permutation in the group gives the list of points then an error message is \
thrown. A third argument can be given with the length of the internal \
Schreier vectors used.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AllBaseImages", "::", "usage"}], 
     "=", "\"\<AllBaseImages[SGS] gives a complete list of rules baseimages \
-> perm, where baseimages is a list of images of the base of SGS and perm is \
its corresponding permutation, as would be given by FromBaseImage[baseimages, \
SGS]. A second argument can be given with the length of the Schreier vectors \
used.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Search", "::", "usage"}], 
     "=", "\"\<Search[SGS, P, s, SGSK] returns the s-th stabilizer in the \
stabilizer-chain of the subgroup K of permutations obeying the property P in \
the group G (described by the strong generating set SGS). It is assumed \
P[perm] returns True or False on any permutation of the group G. The fourth \
argument is a strong generating set for a subgroup of K, possibly a deeper \
stabilizer in its stabilizer-chain.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BaseChange", "::", "usage"}], 
     "=", "\"\<BaseChange[SGS, newbase] gives a new strong generating set for \
the group described by SGS, having newbase as the first elements of its base. \
A third argument can be given specifying the length of the internal Schreier \
vectors used.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DeleteRedundantGenerators", "::", "usage"}], 
     "=", "\"\<DeleteRedundantGenerators[SGS] returns an equivalent strong \
generating set removing redundant generators from the generating set.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierSims", "::", "usage"}], 
     "=", "\"\<SchreierSims[initbase, GS, deg] generates a strong generating \
set for the group generated by GS (permutations of degree deg), using list \
initbase as the first points for the base. The final SGS is not reduced in \
general.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseRules", "::", "usage"}], 
     "=", "\"\<UseRules is an option for SchreierSims giving a set of rules \
replacing the permutations by strings. By default it is {}.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xPermVerbose", "::", "usage"}], 
     "=", "\"\<xPermVerbose is an option for SchreierSims, \
RightCosetRepresentative, DoubleCosetRepresentative and CanonicalPerm. \
xPermVerbose->True gives lots of information about the intermediate status of \
the process.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"db9e85ed-34a5-40d4-a746-5132f14adda5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Canonicalization", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"RightCosetRepresentative", "::", "usage"}], 
     "=", "\"\<RightCosetRepresentative[perm, n, SGS] for an unsigned \
permutation perm of degree n and a SGS for group S gives a canonical \
representative of the right coset S.perm of perm with respect to subgroup S \
of the symmetric group Sn. The criterium is the minimization of images of \
points of the base of SGS under the elements of the coset, following the \
order given by the base. A fourth argument can be used to give additional \
priority to some points (the free slots in the tensorial context)..\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DummySet", "::", "usage"}], 
     "=", "\"\<DummySet is the head of expressions DummySet[manifold, {{d1u, \
d1d}, {d2u, d2d}, ...}, metricsym] denoting a set of pairs of (names of) \
dummies {diu, did} on manifold, whose metric has symmetry metricsym (an \
integer with value 1 if the metric is symmetric, -1 if the metric is \
antisymmetric, or 0 if there is no metric).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RepeatedSet", "::", "usage"}], 
     "=", "\"\<RepeatedSet[{i1, i2, ...}] represents a list of names of \
repeated indices in the canonical configuration.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"JoinSGS", "::", "usage"}], 
     "=", "\"\<JoinSGS[StrongGenSet[base1, GS1], StrongGenSet[base2, GS2]] \
gives a strong generating set having base Join[base1, base2] (with base1 and \
base2 assumed to be disjoint) and generating set Union[GS1, GS2] (with GS1 \
and GS2 assumed to move disjoint sets of points).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SGSOfDummySet", "::", "usage"}], 
     "=", "\"\<SGSOfDummySet[ DummySet[...] ] gives a Strong Generating Set \
for the group of permutations associated to the given DummySet. There are \
always permutations coming from the exchange of dummies. There are \
permutations coming from the exchange of up/down indices in a pair if there \
is a metric for those indices. The GS is given in Cycles notation. See notes \
for DummySet.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DoubleCosetRepresentative", "::", "usage"}], 
     "=", "\"\<DoubleCosetRepresentative[perm, n, SGS, dummysets] returns a \
canonical representative of the double coset S.perm.D, where S is generated \
by the strong generating set SGS and D is the group of symmetries of the \
dummysets. The criterium is the sequential sorting of slots of permutation \
perm (from first to last), choosing the least index not yet used consistent \
with the symmetries S and D. The indices are chosen assuming that indices are \
numbered according to their canonical order.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CanonicalPerm", "::", "usage"}], 
     "=", "\"\<CanonicalPerm[perm, n, GS, {f1, f2, ...}, dummysets] gives a \
canonical representative of the double coset S.perm.D, where S is generated \
by GS and D is the group of symmetries of the dummysets of dummies. The \
algorithm RightCosetRepresentative is first applied to canonicalize free \
indices f1, f2, ..., and then algorithm DoubleCosetRepresentative is applied \
on the result of the latter.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OrderedBase", "::", "usage"}], 
     "=", "\"\<OrderedBase is an option for CanonicalPerm specifying that the \
base must be filled with the missing integers, in normal order.\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BaseChangeCheck", "::", "usage"}], 
     "=", "\"\<BaseChangeCheck is a Boolean option for \
RightCosetRepresentative that forces checking the need of a change of base to \
stabilize the group of symmetry slots. The default is False.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TimeVerbose", "::", "usage"}], 
     "=", "\"\<TimeVerbose is an option for CanonicalPerm. TimeVerbose->True \
outputs the time spent in the computation of the SGS, in the computation of \
the free-indices representative and in the computation of the dummy-indices \
representative.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MathLink", "::", "usage"}], 
     "=", "\"\<MathLink is a Boolean option for CanonicalPerm, SchreierSims \
and Orbit, indicating whether the external C executable xperm must be used to \
speed up computations. Its default value is given by the global variable \
$xpermQ for CanonicalPerm, and it is False for the other two \
functions.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"MathLink", " ", "connection"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$xpermQ", "::", "usage"}], 
     "=", "\"\<$xpermQ is a Boolean global variable containing whether the \
connection to the external C executable xperm has been possible or \
not.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$xpermExecutable", "::", "usage"}], 
     "=", "\"\<$xpermExecutable is a global variable containing the name of \
the xperm executable to which we have connected. If the connection was not \
possible then it is not assigned.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$xpermLink", "::", "usage"}], 
     "=", "\"\<$xpermLink is a global variable containing the link \
identification of the connection to the external excutable xperm. If the \
connection was not possible then it is not assigned.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Predefined", " ", "strong", " ", "generating", " ", "sets"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"System`$VersionNumber", "<", "8.5"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Symmetric", "::", "usage"}], 
        "=", "\"\<Symmetric[{p1, p2, ...}] represents the symmetry of a \
tensor that is symmetric in the slots pi. Symmetric[{p1, p2, ...}, notation] \
returns a strong generating set for the symmetric group on the set of points \
pi, using the indicated notation for signed permutations.\>\""}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Antisymmetric", "::", "usage"}], 
        "=", "\"\<Antisymmetric[{p1, p2, ...}] represents the symmetry of a \
tensor that is antisymmetric in the slots pi. Antisymmetric[{p1, p2, ...}, \
notation] returns a strong generating set for the antisymmetric group on the \
set of points pi, using the indicated notation for signed \
permutations.\>\""}], ";"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Symmetric", "::", "usage"}], "=", 
        RowBox[{
         RowBox[{"Symmetric", "::", "usage"}], 
         "<>", "\"\<\\n\\nxAct extension:\\nSymmetric[{p1, p2, ...}, \
notation] returns a strong generating set for the symmetric group on the set \
of points pi, using the indicated notation for signed permutations.\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Antisymmetric", "::", "usage"}], "=", 
        RowBox[{
         RowBox[{"Antisymmetric", "::", "usage"}], 
         "<>", "\"\<\\n\\nxAct extension:\\nAntisymmetric[{p1, p2, ...}, \
notation] returns a strong generating set for the antisymmetric group on the \
set of points pi, using the indicated notation for signed \
permutations.\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PairSymmetric", "::", "usage"}], 
     "=", "\"\<PairSymmetric[{{p1a, p1b}, {p2a, p2b}, ...}, sym1, sym2, \
notation] returns a Strong Generating Set for the symmetric (if sym1=1) or \
antisymmetric (if sym1=-1) group of permutations of the pairs {pia, pib}. The \
switch sym is an integer: 1 adds permutations Cycles[{pia, pib}]; -1 adds \
permutations -Cycles[{pia, pib}]; other values do nothing. The result is \
given in the using the indicated notation (Cycles by default).\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannSymmetric", "::", "usage"}], 
     "=", "\"\<RiemannSymmetric[{p1, p2, p3, p4}, notation] gives a strong \
generating set implementing the symmetries of the Riemann tensor \
R_{p1,p2,p3,p4}, using the indicated notation for signed permutations (Cycles \
by default).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannSymmetry", "::", "usage"}], 
     "=", "\"\<RiemannSymmetry = RiemannSymmetric. Kept for backward \
compatibility.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Transversals", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RightTransversal", "::", "usage"}], 
     "=", "\"\<RightTransversal[SGS, deg] returns a sorted list of \
permutations containing the canonical representative of each right coset of \
SGS in the symmetric group of degree deg. The choice of representative is \
based in the order induced on the permutations by the base of the SGS. \
RightTransversal[GS, deg] returns the same thing by first using SchreierSims.\
\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LeftTransversal", "::", "usage"}], 
     "=", "\"\<LeftTransversal[SGS, deg] returns a sorted list of \
permutations containing the canonical representative of each left coset of \
SGS in the symmetric group of degree deg. The choice of representative is \
based in the order induced on the **inverse** of the permutations by the base \
of the SGS. Efectively the transversal is simply the inverse of the \
corresponding right transversal. LeftTransversal[GS, deg] returns the same \
thing by first using SchreierSims.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DoubleTransversal", "::", "usage"}], 
     "=", "\"\<DoubleTransversal[SGS, dummysets] returns a sorted list of \
permutations containing the canonical representative of each double coset of \
SGS and the D-group of the dummysets in the symmetric group of degree \
deg.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2859c99e-16db-4cb1-8137-4c3921ba0ad5"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. Begin Private", \
"Subsection",ExpressionUUID->"03102d05-1de8-4250-a795-390f90c5d831"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6b5390ed-e9d9-4b2d-b18b-2e1bd9bf1c02"],

Cell[BoxData["\<\"xAct`xPerm`Private`\"\>"], \
"Output",ExpressionUUID->"a37c4113-9483-4f02-93b3-3e8dfeb5c040"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$xPermNames", "=", 
   RowBox[{"Names", "[", "\"\<xAct`xPerm`*\>\"", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a9b1cb57-787c-4b3a-b0f3-079782b0cc55"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "$xPermNames", 
  "]"}]], "Input",ExpressionUUID->"11eb1665-24dd-4905-bd21-8b0a72bf6d99"],

Cell[BoxData["76"], \
"Output",ExpressionUUID->"15733899-a8fb-4f88-8b96-f3ac31836380"]
}, Open  ]],

Cell["There are 76 public reserved words:", \
"Text",ExpressionUUID->"5fb28f70-fc9a-4347-961d-a610a63d27ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xAct`xPerm`*"}]], \
"Input",ExpressionUUID->"d5137be3-9298-4f80-a99e-c3c3f2cbe9b5"],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["xAct`xPerm`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["xAct`xPerm`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["AllBaseImages",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"AllBaseImages", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["LeftTransversal",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"LeftTransversal", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermMemberQ",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermMemberQ", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SchreierOrbits",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"SchreierOrbits", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["BaseChange",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"BaseChange", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["MathLink",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"MathLink", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermOrderedQ",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermOrderedQ", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SchreierSims",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"SchreierSims", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["BaseChangeCheck",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"BaseChangeCheck", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["MinB",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"MinB", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermPower",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermPower", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Search",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Search", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["CanonicalPerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"CanonicalPerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["NonStablePoints",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"NonStablePoints", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermProduct",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermProduct", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SetStabilizer",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"SetStabilizer", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Coset",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Coset", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["NotationOfPerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"NotationOfPerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermQ",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"PermQ", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SGSOfDummySet",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"SGSOfDummySet", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Cycles",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Cycles", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["OnPoints",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"OnPoints", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermSignature",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermSignature", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SortB",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"SortB", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["DeleteRedundantGenerators",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {
            "DeleteRedundantGenerators", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Orbit",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Orbit", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermSort",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermSort", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Stabilizer",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"Stabilizer", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Dimino",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Dimino", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Orbits",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Orbits", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermutationFromTo",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermutationFromTo", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["StabilizerChain",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"StabilizerChain", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Disclaimer",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"Disclaimer", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["OrderedBase",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"OrderedBase", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermuteList",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermuteList", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["StablePoints",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"StablePoints", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["DoubleCosetRepresentative",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {
            "DoubleCosetRepresentative", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["OrderOfGroup",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"OrderOfGroup", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermWord",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermWord", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["StrongGenSet",
          BaseStyle->"InformationLink",
          ButtonData:>{
           "Info1233729024179-5545305", {"StrongGenSet", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["DoubleTransversal",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"DoubleTransversal", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PairSymmetric",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PairSymmetric", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RandomPerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"RandomPerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["TimeVerbose",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"TimeVerbose", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["DummySet",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"DummySet", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Perm",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Perm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RepeatedSet",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"RepeatedSet", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["TraceSchreier",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"TraceSchreier", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["FromBaseImage",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"FromBaseImage", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermDeg",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermDeg", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RiemannSymmetric",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"RiemannSymmetric", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["TranslatePerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"TranslatePerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["GenSet",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"GenSet", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermEqual",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermEqual", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RiemannSymmetry",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"RiemannSymmetry", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["UseRules",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"UseRules", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Group",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Group", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermGreater",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermGreater", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RightCosetRepresentative",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {
            "RightCosetRepresentative", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["xPermVerbose",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"xPermVerbose", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["ID",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"ID", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermGreaterEqual",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermGreaterEqual", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RightTransversal",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"RightTransversal", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["$Version",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"$Version", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Images",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Images", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermLength",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermLength", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Rules",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info1233729024179-5545305", {"Rules", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["$xpermExecutable",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"$xpermExecutable", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["InversePerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"InversePerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermLess",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermLess", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Schreier",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"Schreier", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["$xpermLink",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"$xpermLink", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["JoinSGS",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"JoinSGS", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermLessEqual",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"PermLessEqual", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SchreierOrbit",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"SchreierOrbit", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["$xpermQ",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info1233729024179-5545305", {"$xpermQ", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.2375]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->
    Automatic]]], "Print", \
"InfoCell",ExpressionUUID->"f20a5899-41a8-405f-8fa3-e752d8728422"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2. Permutation Defs. Notation dependent",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"b0955849-4621-425c-ab38-61024e3540fa"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**"}], "*", " ", "2.", " ", 
   RowBox[{"Permutations", ".", " ", "Notation"}], " ", "dependent"}], " ", 
  "**************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3a1d7aac-f238-434c-8fed-36e52ed2c372"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"847e0754-803e-4561-8733-1b5addb6ab9a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.44151`", ",", "5.902525`7.222582828694269", ",", 
   "0.41364173111621244`"}], 
  "}"}]], "Output",ExpressionUUID->"4509dee4-bef7-4b61-b4a2-eb77bad04439"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "2.0. Comments. Relation with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s GroupTheory code"
}], "Subsection",ExpressionUUID->"352e385b-5285-45ee-abc7-bf83a581fc45"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"$ReadingVerbose", ",", 
   RowBox[{
   "Print", "[", "\"\<Reading section 2: Permutations. Notation dependent\>\"",
     "]"}], ",", "Null", ",", "Null"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"87bc7086-ee1b-4973-86ad-de4770ba2523"],

Cell["\<\
This section defines all those actions on permutations whose structure is \
different on different notations for the permutations.\
\>", "Text",ExpressionUUID->"83a1cde3-56fd-4a19-b33b-e00f32bc09c1"],

Cell[CellGroupData[{

Cell[TextData[{
 "2.0.1. Fake code in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 8 for pre8 versions"
}], "Subsubsection",ExpressionUUID->"e45f4bb0-1e2b-4469-bced-e84f10c9dd7e"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"System`$VersionNumber", "<", "8."}], ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PermutationListQ", "[", "list_", "]"}], ":=", 
     RowBox[{"SameQ", "[", 
      RowBox[{
       RowBox[{"Sort", "[", "list", "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"Length", "[", "list", "]"}], "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PermutationCyclesQ", "[", 
      RowBox[{"System`Cycles", "[", 
       RowBox[{"{", "cycs___", "}"}], "]"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Union", "[", "cycs", "]"}], "===", 
      RowBox[{"Sort", "[", 
       RowBox[{"Join", "[", "cycs", "]"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lastFalse", "[", 
      RowBox[{"{", 
       RowBox[{"___", ",", 
        RowBox[{"{", "pos_", "}"}]}], "}"}], "]"}], ":=", "pos"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lastFalse", "[", 
      RowBox[{"{", "}"}], "]"}], ":=", "0"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PermutationMax", "[", "list_List", "]"}], ":=", 
     RowBox[{"lastFalse", "[", 
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"Inner", "[", 
         RowBox[{"SameQ", ",", "list", ",", 
          RowBox[{"Sort", "[", "list", "]"}], ",", "List"}], "]"}], ",", 
        "False"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"InversePermutation", "[", "list_List", "]"}], ":=", 
     RowBox[{"Ordering", "[", "list", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"InversePermutation", "[", 
      RowBox[{"System`Cycles", "[", "cyclist_List", "]"}], "]"}], ":=", 
     RowBox[{"System`Cycles", "[", 
      RowBox[{"Reverse", "/@", "cyclist"}], "]"}]}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2d59cf8f-5fb1-4b04-986c-1783dc1a0830"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
2.0.2. Reuse code from System`. Beware of the opposite conventions in Mma8 \
and Mma9\
\>", "Subsubsection",ExpressionUUID->"58fe746d-dc8d-428c-b47f-96aa03bf7afa"],

Cell["\<\
Definitions are given so that they follow the conventions in Mathematica 9.\
\>", "Text",ExpressionUUID->"11ed0626-28dd-46f6-b78f-614bcf060eb8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"IfMathematica789", ",", "HoldAll"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IfMathematica789", "[", 
    RowBox[{"expr7_", ",", "expr8_", ",", "expr9_"}], "]"}], ":=", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"System`$VersionNumber", "<", "7.5"}], ",", "expr7", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"System`$VersionNumber", "<", "8.5"}], ",", "expr8", ",", 
     "\[IndentingNewLine]", "True", ",", "expr9"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"9119edb9-ffd6-4264-ad43-4c3a75444dd1"],

Cell[BoxData[
 RowBox[{"IfMathematica789", "[", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Mathematica", " ", "7"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"addsingletons", "[", 
      RowBox[{"cycs_", ",", "length_"}], "]"}], ":=", 
     RowBox[{"Join", "[", 
      RowBox[{"cycs", ",", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Complement", "[", 
          RowBox[{
           RowBox[{"Range", "@", "length"}], ",", 
           RowBox[{"Flatten", "@", "cycs"}]}], "]"}], ",", "1"}], "]"}]}], 
      "]"}]}], ";", 
    RowBox[{
     RowBox[{"PermutationFromCycles", "[", "cycs_List", "]"}], ":=", 
     RowBox[{"Last", "/@", 
      RowBox[{"Sort", "@", 
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "/@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RotateRight", "/@", "cycs"}], ",", "cycs"}], "}"}]}], 
        "]"}]}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PermList", "[", 
      RowBox[{
       RowBox[{"System`Cycles", "[", "cycslist_List", "]"}], ",", "length_"}],
       "]"}], ":=", 
     RowBox[{"PermutationFromCycles", "[", 
      RowBox[{"addsingletons", "[", 
       RowBox[{"cycslist", ",", "length"}], "]"}], "]"}]}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "8"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PermList", "[", 
     RowBox[{
      RowBox[{"System`Cycles", "[", "cycslist_List", "]"}], ",", " ", 
      "length_"}], "]"}], ":=", 
    RowBox[{"PermutationList", "[", 
     RowBox[{
      RowBox[{"System`Cycles", "[", 
       RowBox[{"Reverse", "/@", "cycslist"}], "]"}], ",", "length"}], "]"}]}],
    ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "9"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PermList", "[", 
     RowBox[{"perm_System`Cycles", ",", "length_"}], "]"}], ":=", 
    RowBox[{"PermutationList", "[", 
     RowBox[{"perm", ",", "length"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a5c5f230-4848-4185-9e5e-fff37a37280c"],

Cell[BoxData[
 RowBox[{"IfMathematica789", "[", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Mathematica", " ", "7"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PermList", "[", 
     RowBox[{"list_List", ",", "length_"}], "]"}], ":=", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{"list", "~", "Join", "~", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "list", "]"}], "+", "1"}], ",", "length"}], 
        "]"}]}], ",", "length"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "8"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PermList", "[", 
     RowBox[{"list_List", ",", " ", "length_"}], "]"}], ":=", 
    RowBox[{"PermutationList", "[", 
     RowBox[{"list", ",", "length"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "9"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PermList", "[", 
     RowBox[{"list_List", ",", "length_"}], "]"}], ":=", 
    RowBox[{"PermutationList", "[", 
     RowBox[{"list", ",", "length"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fd53e2ca-5c8b-40e8-88d1-1c87ceefbd97"],

Cell[BoxData[
 RowBox[{"IfMathematica789", "[", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Mathematica", " ", "7"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ToCycles", "[", "list_List", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"Take", "[", 
        RowBox[{"#", ",", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Rest", "@", "#"}], ",", 
            RowBox[{"First", "@", "#"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], "&"}], "/@", 
      RowBox[{"Fold", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"Flatten", "@", "#1"}], ",", "#2"}], "]"}], ",", "#1", ",", 
           RowBox[{"Append", "[", 
            RowBox[{"#1", ",", 
             RowBox[{"NestList", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"list", "[", 
                 RowBox[{"[", "#1", "]"}], "]"}], "&"}], ",", "#2", ",", 
               RowBox[{"Length", "@", "list"}]}], "]"}]}], "]"}]}], "]"}], 
         "&"}], ",", 
        RowBox[{"{", "}"}], ",", "list"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PermCycles", "[", "list_List", "]"}], ":=", 
     RowBox[{"System`Cycles", "[", 
      RowBox[{"Reverse", "/@", 
       RowBox[{"ToCycles", "[", 
        RowBox[{"Ordering", "@", "list"}], "]"}]}], "]"}]}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "8"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PermCycles", "[", "list_List", "]"}], ":=", 
    RowBox[{"Map", "[", 
     RowBox[{"Reverse", ",", 
      RowBox[{"PermutationCycles", "[", "list", "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "9"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PermCycles", "[", "list_List", "]"}], ":=", 
    RowBox[{"PermutationCycles", "[", "list", "]"}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"231f830d-0cec-4fd3-8584-3e849c116dce"],

Cell["\<\
Note that this is only defined for System`Cycles, for which conventions agree \
in Mma8 and Mma9:\
\>", "Text",ExpressionUUID->"ab7c65dd-2894-4af0-88e5-4b2955346fcd"],

Cell[BoxData[
 RowBox[{"IfMathematica789", "[", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Mathematica", " ", "7"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PermutationProduct", "[", 
     RowBox[{
      RowBox[{"System`Cycles", "[", "cycslist1_", "]"}], ",", 
      RowBox[{"System`Cycles", "[", "cycslist2_", "]"}]}], "]"}], ":=", 
    RowBox[{"System`Cycles", "[", 
     RowBox[{"List", "@@", 
      RowBox[{"TranslatePerm", "[", 
       RowBox[{
        RowBox[{"PermProduct", "[", 
         RowBox[{
          RowBox[{"TranslatePerm", "[", 
           RowBox[{
            RowBox[{"Cycles", "@@", "cycslist1"}], ",", "Rules"}], "]"}], ",", 
          RowBox[{"TranslatePerm", "[", 
           RowBox[{
            RowBox[{"Cycles", "@@", "cycslist2"}], ",", "Rules"}], "]"}]}], 
         "]"}], ",", "Cycles"}], "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "8"}], " ", "*)"}], "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "9"}], " ", "*)"}], "\[IndentingNewLine]", 
   "Null"}], "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"46532599-2e11-4e57-a1e7-702dd3d6b27a"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.0.3. Tests", \
"Subsubsection",ExpressionUUID->"efb56573-6662-408e-bf43-775642d0d573"],

Cell["This could be moved to xCore`.", \
"Text",ExpressionUUID->"8edb9b37-1475-44e6-a4e4-f606207a649f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"test", ",", "testcounter", ",", "testresult"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"test", ",", "HoldAll"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testcounter", "[", "symbol_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"testcounter", "[", "symbol", "]"}], "=", "0"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", 
    RowBox[{"symbol_", ",", "expr_", ",", "result_", ",", 
     RowBox[{"messageQ_", ":", "False"}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"symbol", ",", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"testcounter", "[", "symbol", "]"}], "++"}]}], ",", 
     RowBox[{
      RowBox[{"testresult", "[", 
       RowBox[{"symbol", ",", 
        RowBox[{"testcounter", "[", "symbol", "]"}]}], "]"}], "=", 
      RowBox[{"Check", "[", 
       RowBox[{
        RowBox[{"SameQ", "[", 
         RowBox[{"expr", ",", "result"}], "]"}], ",", "messageQ"}], "]"}]}]}],
     "}"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"be5f9eea-d061-44b5-b025-f314dcf1713e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"alltests", "[", "]"}], ":=", 
   RowBox[{"Last", "/@", 
    RowBox[{"DownValues", "[", "testresult", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"alltests", "[", "symbol_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{"DownValues", "[", "testresult", "]"}], ",", 
    RowBox[{
     RowBox[{"_", "[", 
      RowBox[{
       RowBox[{"_", "[", 
        RowBox[{"testresult", "[", 
         RowBox[{"symbol", ",", "_"}], "]"}], "]"}], ",", "result_"}], "]"}], 
     "\[RuleDelayed]", "result"}]}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"afe19eba-e8c5-4d09-9a6e-73879a4b2f71"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "2.0.4. Notation conversion to/from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s GroupTheory code"
}], "Subsubsection",ExpressionUUID->"e9d348c4-26d5-45dc-b1f7-f7440fe51bfa"],

Cell[TextData[{
 "From ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " notation. Note that SchreierSims can give a nonordered basis here. We need \
to find a way to avoid this call of SchreierSims."
}], "Text",ExpressionUUID->"072b3e4c-279e-4ce4-8179-713255eea56c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MathToxPermSym", "[", 
    RowBox[{"sym", ":", 
     RowBox[{"(", 
      RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], "]"}], ":=", 
   RowBox[{"SchreierSims", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "sym"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MathToxPermSym", "[", 
    RowBox[{"gs", ":", 
     RowBox[{"{", "___List", "}"}]}], "]"}], ":=", 
   RowBox[{"SchreierSims", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "@@", 
      RowBox[{"(", 
       RowBox[{"MathToxPermGen", "/@", "gs"}], ")"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"54488db9-9f55-4045-8fa2-6d58a0192fae"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MathToxPermGen", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"System`Cycles", "[", 
       RowBox[{"{", "cycs___", "}"}], "]"}], ",", "sign_"}], "}"}], "]"}], ":=", 
   RowBox[{"sign", " ", 
    RowBox[{"Cycles", "[", "cycs", "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d17d537d-a313-40df-a661-1b5460c8487a"],

Cell[TextData[{
 "From ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notation:"
}], "Text",ExpressionUUID->"192c3283-6ef3-4b6b-ba86-2397d80805d8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xPermToMathSym", "[", 
    RowBox[{"sym", ":", 
     RowBox[{"(", 
      RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], "]"}], ":=", 
   "sym"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xPermToMathSym", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{"base_List", ",", "GS_GenSet"}], "]"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"xPermToMathGen", "/@", 
      RowBox[{"List", "@@", "GS"}]}], ",", "base"}], "}"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"1d5f4066-0877-4a19-845b-b6a42fbbfb11"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xPermToMathGen", "[", 
    RowBox[{"sign_.", " ", 
     RowBox[{"Cycles", "[", "cycs___", "]"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"System`Cycles", "[", 
      RowBox[{"{", "cycs", "}"}], "]"}], ",", "sign"}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9ba2ef48-8bef-44d5-9353-27400ad222ec"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1. Notations for permutations. PermQ", \
"Subsection",ExpressionUUID->"8b19af08-ffa7-4a6a-9e50-4d70b8df1053"],

Cell[CellGroupData[{

Cell["2.1.1. Definitions", \
"Subsubsection",ExpressionUUID->"856b47f6-ab0f-49b6-801f-8456d05d37e7"],

Cell["\<\
This is the function in charge of certifying that something is a permutation:\
\
\>", "Text",ExpressionUUID->"4a71e150-aa16-4a96-9b18-3843f379d07f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermQ"}]], "Input",ExpressionUUID->"426b2f78-210b-42c5-997b-0544f915f0d8"],

Cell[BoxData[
 StyleBox["\<\"PermQ[ Perm[{n1, ..., nk}] ] yields True if the list {n1, ..., \
nk} of length k is a rearrangement of the numbers {1, ..., k}. PermQ[ \
Cycles[cyc1, cyc2, ...] ] gives True if there are no repeated points among \
cycles cyci. PermQ[ Rules[i1->i2, ...] ] gives True if the rules map a set of \
integers to itself. PermQ[ Images[{n1, ..., nk}] ] yields True if the list \
{n1, ..., nk} of length k is a rearrangement of the numbers {1, ..., k}. \
PermQ[ID] gives True. PermQ gives True on a linear combination of valid \
permutations. PermQ returns False otherwise.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977952-5455693",ExpressionUUID->"09130283-cbdf-4dbd-9ce2-\
321263806d60"]
}, Open  ]],

Cell["Identity:", \
"Text",ExpressionUUID->"d6005738-b53a-4a59-bc9b-70a35e776249"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ID"}]], "Input",ExpressionUUID->"d3320d10-aa15-4014-9b56-c8f0431a268f"],

Cell[BoxData[
 StyleBox["\<\"ID represents the identity in all notations. ID[perm] gives \
the identity permutation in the notation used by perm.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977953-5455693",ExpressionUUID->"298f2664-1e65-4a70-8966-\
2e789b706dcf"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermQ", "[", "ID", "]"}], ":=", "True"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"97271d7f-da2d-471f-acf7-cac6aa5313fa"],

Cell["\<\
Perm notation: A permutation is any of the n! rearrangements of the list of \
numbers {1,2,...,n}\
\>", "Text",ExpressionUUID->"03764e47-31d8-4f15-9897-2d9213bb26ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Perm"}]], "Input",ExpressionUUID->"b368add3-a93a-46a7-8ca2-0454a394093b"],

Cell[BoxData[
 StyleBox["\<\"Perm is the head for permutation lists of the form Perm[{n1, \
..., nk}]. Example: Perm[{6, 3, 2, 1, 5, 4}] means that the object in the \
first place goes to the fourth place and so on. Perm[{}] represents the \
identity.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977954-5455693",ExpressionUUID->"eb3d9aad-859e-4a72-8652-\
2285c26fcc44"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermQ", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"list", ":", 
      RowBox[{"{", "___Integer", "}"}]}], "]"}], "]"}], ":=", 
   RowBox[{"PermutationListQ", "[", "list", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"527d4dd8-7e98-43c4-b78d-458603e92f0c"],

Cell["\<\
Images notation: A permutation is any of the n! rearrangements of the list of \
numbers {1,2,...,n}\
\>", "Text",ExpressionUUID->"830384a0-2d6d-4653-a6b7-7c2a943bb7ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Images"}]], "Input",ExpressionUUID->"3890bb97-415b-4e3a-bb2a-6fcd29a7f267"],

Cell[BoxData[
 StyleBox["\<\"Images is the head for permutations expressed as a list of \
images. Example: Images[{4, 3, 2, 6, 5, 1}]. Images[{}] represents the \
identity.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977954-5455693",ExpressionUUID->"d82b5172-bc07-48bd-b6fd-\
f5d92499fabb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermQ", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"list", ":", 
      RowBox[{"{", "___Integer", "}"}]}], "]"}], "]"}], ":=", 
   RowBox[{"PermutationListQ", "[", "list", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"547027a3-21af-4e0c-b219-f737dc177112"],

Cell["\<\
Cycles notation: A permutation is any set of disjoint cycles (lists of \
different points)\
\>", "Text",ExpressionUUID->"aaa9859a-b4e1-4886-a70b-16304be20cd7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Cycles"}]], "Input",ExpressionUUID->"15a20558-a06e-4144-a32a-27f332cf4653"],

Cell[BoxData[
 StyleBox["\<\"Cycles is the head for permutations expressed in disjoint \
cyclic notation. Singletons are not included. Example: Cycles[{1, 4, 6}, {2, \
3}] represents the exchange of points 2 and 3, and the cycle 1->4->6->1. \
Cycles[] represents the identity.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977955-5455693",ExpressionUUID->"0240bc1c-d55c-405a-b7d7-\
8c237dbd66ba"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermQ", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{"cycs", ":", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"___Integer", "?", "Positive"}], "}"}], "..."}]}], "]"}], 
    "]"}], ":=", 
   RowBox[{"PermutationCyclesQ", "[", 
    RowBox[{"System`Cycles", "[", 
     RowBox[{"{", "cycs", "}"}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6cd22d39-8644-466a-9f1d-0e5d8f3a2dc3"],

Cell["\<\
Rules notation: A permutation is any collection of rules mapping a set of \
integers to itself\
\>", "Text",ExpressionUUID->"5250d23b-c99c-4b3c-bfa2-3342bec87e3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Rules"}]], "Input",ExpressionUUID->"27e06e8e-1396-4f9d-bdc5-fcd728194d67"],

Cell[BoxData[
 StyleBox["\<\"Rules is the head for permutations expressed in rule notation. \
Singletons are not included. Example: Rules[1->4, 4->6, 6->1, 2->3, 3->2]. \
Rules[] represents the identity.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977955-5455693",ExpressionUUID->"4f2d0a6b-075b-47b1-954a-\
afc12653e0d8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermQ", "[", 
    RowBox[{"Rules", "[", 
     RowBox[{"rules", ":", 
      RowBox[{
       RowBox[{"Rule", "[", 
        RowBox[{
         RowBox[{"_Integer", "?", "Positive"}], ",", 
         RowBox[{"_Integer", "?", "Positive"}]}], "]"}], ".."}]}], "]"}], 
    "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Union", "[", "#1", "]"}], "===", 
       RowBox[{"Sort", "[", 
        RowBox[{"Join", "[", "#2", "]"}], "]"}]}], "&"}], ",", 
     RowBox[{"Transpose", "[", 
      RowBox[{
       RowBox[{"{", "rules", "}"}], "/.", 
       RowBox[{"Rule", "\[Rule]", "List"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";", 
  RowBox[{
   RowBox[{"PermQ", "[", 
    RowBox[{"Rules", "[", "]"}], "]"}], ":=", "True"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"793143ce-fb76-4095-85a1-70b5a55957a7"],

Cell["\<\
Action on a linear combination. This is not an evident definition; here we \
have in mind a future generalization to the algebra of permutations:\
\>", "Text",ExpressionUUID->"8e56f279-91a0-4073-aa37-2d9a88f17f63"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermQ", "[", "expr_Plus", "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"And", ",", 
     RowBox[{"PermQ", "/@", 
      RowBox[{"List", "@@", "expr"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermQ", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumericQ"}], " ", "perm_"}], "]"}], ":=", 
   RowBox[{"PermQ", "[", "perm", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f8040c9f-8812-4a80-825c-dcc1e96e8c8d"],

Cell["Any other case:", \
"Text",ExpressionUUID->"22228f0e-d80e-45ab-8e26-caf4d984b55c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermQ", "[", "_", "]"}], ":=", "False"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"959d6b99-267a-4b1a-995e-b07ba8fd8166"],

Cell["Protect:", \
"Text",ExpressionUUID->"8733d176-66b9-4ed8-bc80-f323f7e06800"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermQ", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PermQ", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"285ac64d-b3c9-48fb-9197-1dd53eb946aa"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1.2. Examples", \
"Subsubsection",ExpressionUUID->"16e55ede-199e-40aa-b60b-800d2c6f8b28"],

Cell["\<\
In the following we do not check that arguments of functions are actually \
permutations, because that would slow down the computations. The function \
PermQ is given to test permutations in case of doubt.\
\>", "Text",ExpressionUUID->"dedc418e-48ca-462b-a5e9-a8e518f8311b"],

Cell["Examples:", \
"Text",ExpressionUUID->"ff19a57b-b0d4-4da0-90e7-196a7df073d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "+", 
     RowBox[{"2", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "5", ",", "2", ",", "1"}], "}"}], 
       "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", "True"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"2692bd59-cebb-4b30-905f-a7c5b096d6f5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"fc5a0650-252e-4963-b574-784195ad9d6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5", ",", "2", ",", "1"}], "}"}], "]"}]}], 
    "]"}], ",", "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"88899b5d-63db-4f65-a5ab-cea5bcd96a4b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"84fc8455-8168-409e-98ea-b180a449bb6c"]
}, Open  ]],

Cell["Perm[{}] represents the identity permutation.", \
"Text",ExpressionUUID->"6f9254c1-de55-4ee3-b838-33e4ef4d9766"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", "}"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "True"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e3fae86b-4db3-4596-a267-4bf5253775db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"36489dad-2238-46d3-aea2-ef9ec848aca8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Perm", "[", "]"}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"8e09413a-efef-46c2-b930-8d91201f52f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"959d83c8-8cc8-4023-82d0-92b339c13378"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"279a6c84-461d-48d4-976d-6ad40a6d9122"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"2c1bbd96-109f-4a1a-8e7a-3aff701f6d94"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"c0c3777a-fc47-4f98-a8db-01e3e614eac1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"f77ff8d3-8339-4abf-9a49-632491c80f6c"]
}, Open  ]],

Cell["Images[{}] represents the identity permutation.", \
"Text",ExpressionUUID->"280f0887-38b6-44a5-baa5-0aa4defd0ac2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"{", "}"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "True"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e7cdf85e-ed7a-42ac-b33c-09839a3c2f95"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"1e85a15d-87f5-46e6-a7fb-b8eb124c4786"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Images", "[", "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"5f9d233a-0ddc-4472-a265-6c1d3fffd4cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"b277fea2-7d8d-471a-8cb4-67bee8734f0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"f4e96cf1-26d0-4e8c-83c7-800471ebcbcb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "9", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d16694f5-e029-4786-adc7-34666f847970"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3e96873f-18e7-4d01-aac3-cbe9795eeb32"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "10", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"b01e58fc-8970-480e-af74-45b11e01c0dc"]
}, Open  ]],

Cell["Cycles:", "Text",ExpressionUUID->"0f71ca29-13a1-4ccf-b9dc-4e24a574dbc6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Cycles", "[", "]"}], "]"}], ",", "\[IndentingNewLine]", "True"}],
   "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"9b4802c6-e570-4efe-9684-d9489452a3bd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "11", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d96115f6-141b-413f-a8a5-8c17b31416f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"99570d0d-0be6-4adf-a1cb-5936f2889195"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "12", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"1a910909-e170-483c-9c51-142edf87f786"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "5", ",", "0"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"613a6131-9818-43a0-a26a-ab16a5732e65"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "13", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"cdc0e0cb-c601-4f9d-a428-6f901edc3838"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ccfb10bd-9a52-4ad4-9e71-72a4aa78166e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "14", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6057fdbe-e562-403e-94f2-5094a93963ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False", ",", "\[IndentingNewLine]", "True"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"410a6bdd-e037-4c87-88f3-afc002f8d51e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"System`Cycles", "::", "reppoint"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(System`Cycles[\\(\\({\\(\\({1, 3}\\)\\), \
\\(\\({1, 5}\\)\\)}\\)\\)]\\)\[NoBreak] contains repeated integers. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/Cycles\\\", ButtonNote -> \
\\\"Cycles::reppoint\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"8484c11a-eb7c-420b-bfd6-229ccf41719b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "15", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"e1eb64db-724f-4190-8b07-7ab03a295089"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False", ",", "\[IndentingNewLine]", "True"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"fed75f6f-8b14-45b4-aa30-ae0e986c3999"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"System`Cycles", "::", "reppoint"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(System`Cycles[\\(\\({\\(\\({1, 3, 1}\\)\\), \
\\(\\({2, 5}\\)\\)}\\)\\)]\\)\[NoBreak] contains repeated integers. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/Cycles\\\", ButtonNote -> \
\\\"Cycles::reppoint\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"1cb6804d-a59c-40fe-bade-a1bceef0ba6f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "16", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"bc083eb3-e1ca-4d13-8931-745e4962f608"]
}, Open  ]],

Cell["Rules:", "Text",ExpressionUUID->"3aab0700-e21d-4335-871a-953a817a8ef6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Rules", "[", "]"}], "]"}], ",", "\[IndentingNewLine]", "True"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"8be37de7-5cb6-4927-860c-97c71aab4858"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "17", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"72f41c56-6c5f-4451-bf1f-5c0f47d0fcdf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"5", "\[Rule]", "1"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"70f6d884-148a-4e70-ab24-52e1cbab8ee3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "18", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"b12f9961-f114-41aa-b64e-0917e41e8c47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermQ", "[", 
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"fce3cef4-e052-46ce-876c-c31c7b50e40b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermQ", ",", "19", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"9910940d-1f1a-4294-b6e5-7506f09b487b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{
  "alltests", "[", "PermQ", 
   "]"}]}]], "Input",ExpressionUUID->"e454118f-00c8-4922-adaa-291972e118ca"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e6217891-39d3-4860-8127-95a3ce15431a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1.3. Remove singletons in Cycles and Rules notations", \
"Subsubsection",ExpressionUUID->"98c8fcf3-91fd-4033-8ae3-ec0ecdfe2fff"],

Cell["\<\
We automatically remove singletons and empty cycles from the cyclic structure \
(I've tried to replace these definitions with a function DeleteSingletons to \
be used at the right places, but it is less efficient!)\
\>", "Text",ExpressionUUID->"b44cc55c-6c67-4367-aa9c-33f4b8e068e5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"cycs1___", ",", 
     RowBox[{"{", "}"}], ",", "cycs2___"}], "]"}], ":=", 
   RowBox[{"Cycles", "[", 
    RowBox[{"cycs1", ",", "cycs2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"cycs1___", ",", 
     RowBox[{"{", "_", "}"}], ",", "cycs2___"}], "]"}], ":=", 
   RowBox[{"Cycles", "[", 
    RowBox[{"cycs1", ",", "cycs2"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b3af4fe8-b34b-4405-bdf4-99984ea91182"],

Cell["And the same for rules:", \
"Text",ExpressionUUID->"6326c347-9d24-4bb4-8b38-f784205b2716"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Rules", "[", 
    RowBox[{"rules1___", ",", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{"x_", "\[Rule]", "x_"}], "]"}], ",", "rules2___"}], "]"}], ":=", 
   RowBox[{"Rules", "[", 
    RowBox[{"rules1", ",", "rules2"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"77c3708a-3770-4e0d-a67d-e78b18d2c95e"],

Cell["Examples:", \
"Text",ExpressionUUID->"91c1508c-0474-4f2d-811e-1740f8ff76d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"cae3b83b-074c-44a3-81dc-0ab72e30ee8b"],

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3"}], "}"}], 
  "]"}]], "Output",ExpressionUUID->"fefc8e65-f082-4fb8-867e-ac753c56fd91"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rules", "[", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "4"}]}], 
  "]"}]], "Input",ExpressionUUID->"4765cfb8-ad5d-4258-93b6-9a1fd74a165d"],

Cell[BoxData[
 RowBox[{"Rules", "[", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "4"}]}], 
  "]"}]], "Output",ExpressionUUID->"2f4a0303-1595-4cd1-bb0b-e7c638734d68"]
}, Open  ]],

Cell["Note that rules are not sorted:", \
"Text",ExpressionUUID->"d56bb41a-ba67-4d53-a280-4d04c5d9a744"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rules", "[", 
  RowBox[{
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"3", "\[Rule]", "4"}]}], 
  "]"}]], "Input",ExpressionUUID->"8d2801d7-a4ce-4f91-bc7f-80ed8297ab3f"],

Cell[BoxData[
 RowBox[{"Rules", "[", 
  RowBox[{
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"3", "\[Rule]", "4"}]}], 
  "]"}]], "Output",ExpressionUUID->"a7199ff2-0438-41aa-8ad8-022370e8a2dc"]
}, Open  ]],

Cell["Protect heads:", \
"Text",ExpressionUUID->"b78f605f-254b-437e-92e6-fe4c23598f94"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Perm", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Images", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"Perm", ",", "Cycles", ",", "Rules", ",", "Images"}], "]"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fb5e9012-0ec6-403c-b092-ed3341f1c474"],

Cell["\<\
It is important to note that a given permutation has a unique representation \
in Perm or Images notation (for a given list-length), but not in Cycles or \
Rules notation because the cycles and rules can be reordered in different \
ways. It would be simple to solve the problem in Rules notation by \
introducing the Orderless attribute, but then the computations would slow \
down. Even worse, it is not so simple for Cycles and actually we do not do it \
for neither of them. See section 3.1 for tests of equality of permutations.\
\>", "Text",ExpressionUUID->"8d9e2d04-225a-4fa9-9eab-cde08a7650ae"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1.4. More on Cycles notation. TOCOMPLETE", \
"Subsubsection",ExpressionUUID->"68b9a73b-e761-482d-87fb-7db29c42b0c4"],

Cell["\<\
Note that the opposite convention for multiplication would have made this \
nicer :\
\>", "Text",
 CellChangeTimes->{{3.458836210323723*^9, 
  3.458836243794829*^9}},ExpressionUUID->"6d0ef17d-e71e-4583-a2dc-\
3279e81aab09"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6", ",", "7", ",", "8", ",", "9"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"3948ef05-e7e4-46ba-aca7-233126cbb95f"],

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6", ",", "7", ",", "8", ",", "9"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"9b796a59-b2e1-4b1f-96c2-4a31ae325d37"]
}, Open  ]],

Cell["We have checked that this is the result in GAP as well :", "Text",
 CellChangeTimes->{{3.458836440040317*^9, 
  3.458836457821416*^9}},ExpressionUUID->"322ba9d5-39b7-42bb-b7f4-\
1f7d861cc57a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6", ",", "7", ",", "8", ",", "9"}], "}"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"172e32ad-7072-47c7-bf90-0c35b977c65b"],

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6", ",", "7", ",", "8", ",", "9"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"53c46f03-8374-4397-90c9-df3e504e84c8"]
}, Open  ]],

Cell["Ensure that cycles are properly sorted:", \
"Text",ExpressionUUID->"1400be82-973b-4083-aad6-c985356656f5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SortCycles", "[", "perm_Cycles", "]"}], ":=", 
   RowBox[{"Sort", "[", 
    RowBox[{"SortCycle", "/@", "perm"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortCycle", "[", "cyc_List", "]"}], ":=", 
   RowBox[{"Nest", "[", 
    RowBox[{"RotateLeft", ",", "cyc", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"cyc", ",", 
         RowBox[{"Min", "[", "cyc", "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortCycles", "[", "expr_", "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"perm_Cycles", "\[RuleDelayed]", 
     RowBox[{"SortCycles", "[", "perm", "]"}]}]}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.459278436019951*^9, 3.4592784814340677`*^9}, {
   3.4592785337331743`*^9, 3.459278630975389*^9}, {3.459278664498281*^9, 
   3.4592787468102016`*^9}, {3.459278782603794*^9, 3.4592788105303793`*^9}, 
   3.4592788680243597`*^9},ExpressionUUID->"6a06a46f-4c51-4948-a9c7-\
3a7959da6b10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "3"}], 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3", ",", "2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "1", ",", "7", ",", "8"}], "}"}]}], "]"}]}], "//", 
  "SortCycles"}]], "Input",
 CellChangeTimes->{{3.45927869550174*^9, 3.459278706913328*^9}, {
  3.459278823571581*^9, 3.459278840551702*^9}, {3.459278875816319*^9, 
  3.459278880519724*^9}},ExpressionUUID->"c5a32e59-a961-47b7-ad92-\
2f0fbce93535"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "7", ",", "8", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "4", ",", "3"}], "}"}]}], 
   "]"}]}]], "Output",ExpressionUUID->"bdf0c35f-eb54-4d43-ad40-9e2c66b76111"]
}, Open  ]],

Cell["\<\
Standard formatting for cyclic permutation. Note the exception of the \
identity.\
\>", "Text",
 CellChangeTimes->{{3.459352595261002*^9, 
  3.4593526131019983`*^9}},ExpressionUUID->"e0457fba-2673-47a4-88af-\
fb642a92d3a8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Cycles", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "]"}], ",", "\"\<id\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatcycle", "[", "cyc_List", "]"}], ":=", 
   RowBox[{"RowBox", "@", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "\"\<(\>\"", "}"}], ",", 
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"MakeBoxes", "/@", "cyc"}], ",", "\"\<,\>\""}], "]"}], ",", 
      RowBox[{"{", "\"\<)\>\"", "}"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", "cycs__List", "]"}]}], ",", "StandardForm"}], 
    "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", "cycs", "]"}]}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"formatcycle", "/@", 
         RowBox[{"{", "cycs", "}"}]}], ",", "\"\<-\>\""}], "]"}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"coeff_", "?", "NumberQ"}], " ", 
      RowBox[{"Cycles", "[", "cycs__List", "]"}]}], ",", "StandardForm"}], 
    "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{"coeff", " ", 
      RowBox[{"Cycles", "[", "cycs", "]"}]}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"formatcycle", "/@", 
         RowBox[{"{", "cycs", "}"}]}], ",", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"coeff", ",", "StandardForm"}], "]"}]}], "]"}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "cycs__List", "]"}], ",", "StandardForm"}], "]"}],
    ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "cycs", "]"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"formatcycle", "/@", 
       RowBox[{"{", "cycs", "}"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Cycles", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.459328165736621*^9, 3.4593282315036592`*^9}, {
  3.459328261825961*^9, 3.459328501493902*^9}, {3.459328734460535*^9, 
  3.459328769537201*^9}, {3.459328903453329*^9, 3.459328915833776*^9}, {
  3.4593289467193613`*^9, 3.459328971309409*^9}, {3.459329005153653*^9, 
  3.4593290615825*^9}, {3.459329749979547*^9, 3.459329776731907*^9}, {
  3.459329811488844*^9, 3.459329839031599*^9}, {3.459329908753956*^9, 
  3.459329979287959*^9}, {3.4593301019126663`*^9, 
  3.4593301988089*^9}},ExpressionUUID->"13cd2453-3dd3-4ad7-be25-1c212b8268a8"],

Cell["Examples :", "Text",
 CellChangeTimes->{{3.4593297090382223`*^9, 
  3.4593297131133432`*^9}},ExpressionUUID->"945d3b60-aa4c-4b3c-b047-\
158834185dd9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cycles", "[", "]"}]}]], "Input",
 CellChangeTimes->{{3.459352625420043*^9, 
  3.459352629173397*^9}},ExpressionUUID->"7ece536a-1684-4826-9ad6-\
c686d7dff4a9"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
  "Cycles", "[", 
   "]"}]}]], "Output",ExpressionUUID->"6124ebb2-3c74-4c4d-b965-61fa29f558c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.459328554680685*^9, 3.459328611851015*^9}, {
  3.459328985982842*^9, 3.459328990896435*^9}, {3.459329033044778*^9, 
  3.459329035877017*^9}},ExpressionUUID->"aafc596f-df3a-443a-ab19-\
50ae3e1123ed"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], 
   "]"}]}]], "Output",ExpressionUUID->"3943b101-9d4c-4cf4-b50d-fe86533100dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.459329129261324*^9, 
  3.459329135978319*^9}},ExpressionUUID->"7ba53bfd-24c7-4d08-9a23-\
b62484418c4f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], 
   "]"}]}]], "Output",ExpressionUUID->"3cafd548-861d-44ee-8d47-e09d7c65544a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "3"}], "/", "2"}], 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4593291382118483`*^9, 
  3.4593291452671337`*^9}},ExpressionUUID->"274d984a-025e-45cb-91de-\
de4bea3e7670"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["3", "2"]}], " ", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], 
   "]"}]}]], "Output",ExpressionUUID->"433b13a9-8814-4adc-ac49-c418b86ab03f"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
2.2. Degree and length of permutations. PermDeg, PermLength, NotationOfPerm\
\>", "Subsection",ExpressionUUID->"a8116098-bf8a-492c-aa0a-f6881e21b530"],

Cell[CellGroupData[{

Cell["2.2.1. PermDeg and PermLength", \
"Subsubsection",ExpressionUUID->"9ed50d76-d809-4a84-803c-17ae5ed84e8e"],

Cell["\<\
The length of a permutation is a notation-dependent concept. This is mostly \
used internally to avoid recomputing the degree of a permutation many times. \
Users should use PermDeg, which gives the true degree of a permutation, i.e., \
the largest point moved by the permutation (a notation-independent concept).\
\>", "Text",ExpressionUUID->"7554174f-cfc6-477b-9b29-b9e9cbe774ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermLength"}]], \
"Input",ExpressionUUID->"22b3b077-aaf9-4e89-8c95-65f80f408753"],

Cell[BoxData[
 StyleBox["\<\"PermLength[perm] gives the so-called length of permutation \
perm. If expressed in Perm or Images notation, the length of perm is the \
length of the list of points. In other cases, it returns PermDeg[perm].\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977958-5455693",ExpressionUUID->"03a91622-e7ba-4454-bf97-\
88c84727f0b0"]
}, Open  ]],

Cell["We need definitions on the two special cases:", \
"Text",ExpressionUUID->"fe09ac9e-3035-4cc8-8ec4-40013c014706"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermLength", "[", 
    RowBox[{"Perm", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"Length", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermLength", "[", 
    RowBox[{"Images", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"Length", "[", "list", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8cd9fbf2-565e-4f7f-b29f-ad149eb125d1"],

Cell["\<\
And definitions on sets of permutations. We take into account the base to \
compute the perm-length of a strong generating set.\
\>", "Text",ExpressionUUID->"8102ad3f-1062-47a0-b76d-527128a33ea7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PermLength", "[", "group_Group", "]"}], ":=", 
  RowBox[{"Max", "[", 
   RowBox[{"0", ",", 
    RowBox[{"PermLength", "/@", 
     RowBox[{"List", "@@", "group"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermLength", "[", "GS_GenSet", "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", 
     RowBox[{"PermLength", "/@", 
      RowBox[{"List", "@@", "GS"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermLength", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{"base_", ",", "GS_"}], "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"base", ",", 
     RowBox[{"PermLength", "[", "GS", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermLength", "[", 
    RowBox[{"Symmetric", "[", "list_", "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermLength", "[", 
    RowBox[{"Antisymmetric", "[", "list_", "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", "list"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"6ef9c4f5-887d-404f-aba3-7ef4c3353d47"],

Cell["In other cases change to PermDeg:", \
"Text",ExpressionUUID->"16225056-5596-4609-9f72-6b1c6f634aca"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermLength", "[", "x_", "]"}], ":=", 
   RowBox[{"PermDeg", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermLength", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PermLength", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c87679c4-c1e6-4038-a799-724bd52bc0a4"],

Cell["\<\
We define PermDeg here, because even though the concept is \
notation-independent, the internal definitions are different for different \
notations, to make it faster:\
\>", "Text",ExpressionUUID->"1246f061-9b67-4e66-8730-a9e321000b1a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermDeg"}]], \
"Input",ExpressionUUID->"25508824-c203-4dc8-b75d-65d5daa6a629"],

Cell[BoxData[
 StyleBox["\<\"PermDeg[perm] gives the degree of permutation perm, defined as \
the largest point moved. The degree of (any form of) the identity is 0. \
PermDeg[set] gives the largest degree among the permutations of the set (a \
group, generating set, strong generating set or linear combination).\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977959-5455693",ExpressionUUID->"7528b735-5d1d-401b-8471-\
a05dc3d16042"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{"Perm", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"PermutationMax", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{"Images", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"PermutationMax", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{"Cycles", "[", "cycs___List", "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", "cycs"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{"Rules", "[", "rules___Rule", "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", 
     RowBox[{"Apply", "[", 
      RowBox[{"List", ",", 
       RowBox[{"{", "rules", "}"}], ",", 
       RowBox[{"{", "1", "}"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", "ID", "]"}], ":=", "0"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"9b4de64f-ab5a-4259-aa2f-2fe803f64a86"],

Cell["We do not take into account the base to compute the degree:", \
"Text",ExpressionUUID->"4a295ce4-4c4c-44e9-a197-b7291173b379"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{"Group", "[", "perms___", "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", 
     RowBox[{"PermDeg", "/@", 
      RowBox[{"{", "perms", "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{"GenSet", "[", "perms___", "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", 
     RowBox[{"PermDeg", "/@", 
      RowBox[{"{", "perms", "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{"_List", ",", 
      RowBox[{"GenSet", "[", "perms___", "]"}]}], "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", 
     RowBox[{"PermDeg", "/@", 
      RowBox[{"{", "perms", "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{"Symmetric", "[", "list_", "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{"Antisymmetric", "[", "list_", "]"}], "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"0", ",", "list"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e9cc62a0-bfb6-47f7-897d-a08f1f77e94c"],

Cell["\<\
Again, this is just a tentative definition on linear combinations of \
permutations:\
\>", "Text",ExpressionUUID->"bf0a8fce-4375-4ca2-8af3-767f19d8b1c6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", "expr_Plus", "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"PermDeg", "/@", 
     RowBox[{"List", "@@", "expr"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumericQ"}], " ", "perm_"}], "]"}], ":=", 
   RowBox[{"PermDeg", "[", "perm", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3a63c8a0-67b1-496c-b782-da289b60d62c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermDeg", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"PermDeg", "::", "undef"}], ",", "\"\<degree\>\"", ",", "x"}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermDeg", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PermDeg", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"69ed06ef-6bcd-44fe-bdfa-cb3d02989556"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2.2. Examples", \
"Subsubsection",ExpressionUUID->"0c2857eb-3c92-475b-99f8-6c1c03ebf819"],

Cell["Note the difference between these two cases:", \
"Text",ExpressionUUID->"3af1a30c-2c42-4504-aab6-01b174160155"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermLength", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "4"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"1844e848-3e4b-48c9-bb48-3785c5291b1b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"98d430bc-c9e1-48c7-878a-b8c7251f90a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermDeg", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "0"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"f1359955-54e7-4e4a-82d0-e9359777c2b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"e7d57597-0a3e-43a8-b719-a51c127b846c"]
}, Open  ]],

Cell["or these:", \
"Text",ExpressionUUID->"19a7d17c-9e9b-47b1-9438-76b00dfbc007"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermLength", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "4"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"f5ff3f49-b378-4735-a5a8-0b49edbfdaca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"00fa06fb-6a8c-4ac4-b8cd-0da05c9b4882"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermDeg", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "3"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"a3e70940-8aac-4719-a3c8-92d0b606730f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"3eeae74a-d420-4bc4-acc2-0c24b9efa03a"]
}, Open  ]],

Cell["Special cases:", \
"Text",ExpressionUUID->"e94a0b28-4562-4088-b1c9-e592f54b5c0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermDeg", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", "}"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "0"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ca58013b-acf6-4fea-9e07-ba929a8753b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"5b24a6f9-1b7e-44f6-be20-9cd75ed527e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"Catch", "@", 
    RowBox[{"PermDeg", "[", 
     RowBox[{"Perm", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"97236427-0000-43b4-a7c1-c3adc7491845"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Perm", "::", "argx"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(Perm\\)\[NoBreak] called with \
\[NoBreak]\\!\\(0\\)\[NoBreak] arguments; 1 argument is expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argx\\\", \
ButtonNote -> \\\"xAct`xPerm`Perm::argx\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"d9c4da04-6169-4125-a8bf-007b43957ac9"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"PermDeg", "::", "undef"}], "MessageName"], ":", 
  " ", "\<\"Undefined \[NoBreak]\\!\\(\\\"degree\\\"\\)\[NoBreak] of \
\[NoBreak]\\!\\(Null\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"42da02aa-22e0-47db-b664-13a23d58a0a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4744eb70-1a2f-4ad0-9e81-39de889f143e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermDeg", "[", 
    RowBox[{"Rules", "[", "]"}], "]"}], ",", "\[IndentingNewLine]", "0"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"5f82b6e3-ac8b-4108-afbd-eada08b0ea0e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"1bad38f9-f30e-4808-98f4-c87d751f90cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermDeg", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"{", "}"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "0"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"617753ae-391e-4f2d-a2cc-ec40e5382884"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"cea4a1c5-45cc-433f-a609-b088719e1b5a"]
}, Open  ]],

Cell["Cycles and Rules notations:", \
"Text",ExpressionUUID->"d2420dda-5d81-4797-b49a-81d34925e6b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermDeg", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "5"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e661f504-2364-4661-b503-337e4a027b84"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "9", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"0c6afee2-cf80-44a6-886c-186e548545ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermDeg", "[", 
    RowBox[{"Cycles", "[", "]"}], "]"}], ",", "\[IndentingNewLine]", "0"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"74eaa8f5-ad08-40fa-88d4-dd345c43dfe5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "10", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"89505266-b707-407f-8bc1-60dd18250794"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermDeg", ",", "\[IndentingNewLine]", 
   RowBox[{"PermDeg", "[", 
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"5", "\[Rule]", "1"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "5"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"299fd4c5-52ce-4a59-ba9b-6059363a6eb6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermDeg", ",", "11", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"a9ddbd27-4a18-4555-864f-88102a1eddc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{
  "alltests", "[", "PermDeg", 
   "]"}]}]], "Input",ExpressionUUID->"8a18522c-f573-492c-8e70-aa1e16bdb342"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"b7054808-1073-4198-bbb7-9cd50e8abf1c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2.3. NotationOfPerm", \
"Subsubsection",ExpressionUUID->"d249bca5-0a0d-432b-9336-1d422ef38411"],

Cell["\<\
This simple function gives the notation in which a particular permutation is \
written. Note that it only acts on single (possibly signed) permutations.\
\>", "Text",ExpressionUUID->"8bb9b53d-bccd-4fb2-b2f5-9295d07d764f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "NotationOfPerm"}]], \
"Input",ExpressionUUID->"1f7e53cd-8e06-49e2-a6aa-b1544610c729"],

Cell[BoxData[
 StyleBox["\<\"NotationOfPerm[perm] gives the notation of permutation perm. \
It can be one of {Perm, length}, {Images, length}, Cyles or Rules.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977960-5455693",ExpressionUUID->"e806b97b-5f02-4bf6-80ab-\
9eafa83cf62d"]
}, Open  ]],

Cell["\<\
Note that for a generating set the NotationOfPerm is defined as the notation \
of the first permutation of the set:\
\>", "Text",ExpressionUUID->"5d856851-38a6-4ec3-bf7e-2a9e02aec8d0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"-", "g_"}], "]"}], ":=", 
   RowBox[{"NotationOfPerm", "[", "g", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"g", ":", 
     RowBox[{"Perm", "[", "_List", "]"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"Perm", ",", 
     RowBox[{"PermLength", "[", "g", "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"g", ":", 
     RowBox[{"Images", "[", "_List", "]"}]}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"Images", ",", 
     RowBox[{"PermLength", "[", "g", "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"Cycles", "[", "___List", "]"}], "]"}], ":=", "Cycles"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"Rules", "[", "___Rule", "]"}], "]"}], ":=", "Rules"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"GenSet", "[", "]"}], "]"}], ":=", "Cycles"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{"perm_", ",", "___"}], "]"}], "]"}], ":=", 
   RowBox[{"NotationOfPerm", "[", "perm", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"NotationOfPerm", "[", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"_", ",", "GS_"}], "]"}], "]"}], ":=", 
    RowBox[{"NotationOfPerm", "[", "GS", "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Arbitrary", " ", "decision"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"Symmetric", "[", "list_", "]"}], "]"}], ":=", "Cycles"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"Antisymmetric", "[", "list_", "]"}], "]"}], ":=", "Cycles"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"57b39707-4d1c-4007-89c4-3feeccd4bf05"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NotationOfPerm", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"NotationOfPerm", "::", "undef"}], ",", "\"\<notation\>\"", ",",
       "x"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"NotationOfPerm", ",", "1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "NotationOfPerm", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d1018ee1-7c16-4c64-a88f-c0c675002660"],

Cell["Examples:", \
"Text",ExpressionUUID->"6fd4b08b-9711-455f-8a11-bd6125b55e8b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"NotationOfPerm", ",", "\[IndentingNewLine]", 
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Perm", ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"35166edf-2fec-446c-aa84-51c7b36bb0f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NotationOfPerm", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"e05574f2-f8d9-4da8-9ddf-5c20f155c92a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"NotationOfPerm", ",", "\[IndentingNewLine]", 
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Images", ",", "4"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"9260d98c-9117-46b6-9cf3-0ee7ebc8fbd8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NotationOfPerm", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"bff9255d-7f3a-4b40-9d39-32ba11c97e03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"NotationOfPerm", ",", "\[IndentingNewLine]", 
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "Cycles"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"907c30b1-2fe2-4ec5-b7dd-4203a0c156d7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NotationOfPerm", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"a3daaee6-8203-43ae-9a66-8821feb98d00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"NotationOfPerm", ",", "\[IndentingNewLine]", 
   RowBox[{"NotationOfPerm", "[", 
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "100"}], ",", 
      RowBox[{"100", "\[Rule]", "1"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "Rules"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3e42b512-b1f1-417d-98a5-910da872557a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NotationOfPerm", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d0f3b69b-a440-4687-ad74-a8a18efc5056"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "NotationOfPerm", "[", "Hello", 
   "]"}]}]], "Input",ExpressionUUID->"2420a19e-9143-407b-95be-32b4ba340381"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NotationOfPerm", "::", "undef"}], "MessageName"], ":", 
  " ", "\<\"Undefined \[NoBreak]\\!\\(\\\"notation\\\"\\)\[NoBreak] of \
\[NoBreak]\\!\\(Hello\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"1bc8e403-f9a9-4868-85c0-09bd7227fa04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{
  "alltests", "[", "NotationOfPerm", 
   "]"}]}]], "Input",ExpressionUUID->"81fa528c-e61a-4878-9f78-659a21882241"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"6bbfb99e-7385-493d-8e89-178857c68414"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3. Identity. ID", \
"Subsection",ExpressionUUID->"6e1c830e-0a3c-4c86-9fe8-af16479f43a5"],

Cell[CellGroupData[{

Cell["2.3.1. Definitions", \
"Subsubsection",ExpressionUUID->"6e191472-db95-4c8e-9eb9-12bc11366563"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ID"}]], "Input",ExpressionUUID->"90b714a0-e395-41a9-b150-c9ab6a80baa8"],

Cell[BoxData[
 StyleBox["\<\"ID represents the identity in all notations. ID[perm] gives \
the identity permutation in the notation used by perm.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977961-5455693",ExpressionUUID->"72a76ccc-c953-440f-bfc7-\
1468163ef186"]
}, Open  ]],

Cell["\<\
Identity permutation in the notation given. Note that the length of the \
permutation is lost in Cycles and Rules notation:\
\>", "Text",ExpressionUUID->"93b2ccd5-feed-461b-b26f-1d3c924a92ab"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ID", "[", 
    RowBox[{"Perm", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"Perm", "[", 
    RowBox[{"Sort", "@", "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ID", "[", 
    RowBox[{"Images", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"Images", "[", 
    RowBox[{"Sort", "@", "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ID", "[", 
    RowBox[{"Cycles", "[", "___List", "]"}], "]"}], ":=", 
   RowBox[{"Cycles", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ID", "[", 
    RowBox[{"Rules", "[", "___Rule", "]"}], "]"}], ":=", 
   RowBox[{"Rules", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ID", "[", "ID", "]"}], ":=", "ID"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f0279a46-6ed8-4614-a0ae-1152e86436f0"],

Cell["\<\
It is not clear how to define ID on a sum, and so we do not do that.\
\>", "Text",ExpressionUUID->"d40715c6-e16a-4cce-bc7d-ff08f25bded2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ID", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumericQ"}], " ", "perm_"}], "]"}], ":=", 
   RowBox[{"ID", "[", "perm", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"58035d3b-4217-466f-938b-4ab6e6bf649f"],

Cell["Protection:", \
"Text",ExpressionUUID->"f42d5188-4909-4ed3-9453-8700ea79a520"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ID", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"ID", "::", "undef"}], ",", "\"\<identity for notation\>\"", ",",
       "x"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"ID", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ID", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"6c26da42-40fd-42e8-8689-7e7c89d70972"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3.2. Examples", \
"Subsubsection",ExpressionUUID->"fec84443-90c7-484f-8b31-b0f6b17b32b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"ID", ",", "\[IndentingNewLine]", 
   RowBox[{"ID", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7c7c97f8-74bf-4608-b0f8-79d16d8e9a65"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ID", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"64e4549c-84b4-4a82-b9d8-2c430a0eab9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"ID", ",", "\[IndentingNewLine]", 
   RowBox[{"ID", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", "}"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"80dc68ed-db78-47b8-917d-c0f005e025c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ID", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"ddf1cc96-b4df-409a-9aed-6ff6db4c1100"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"ID", ",", "\[IndentingNewLine]", 
   RowBox[{"ID", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"6e209904-907e-4de8-9c3f-ee0679f4e3be"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ID", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"5acdde66-c032-4056-9715-6f8b14f4a526"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"ID", ",", "\[IndentingNewLine]", 
   RowBox[{"ID", "[", 
    RowBox[{"-", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"450ab34a-9be5-40b3-ae18-b04db24dc6a9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ID", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"750ddaeb-2020-4a5d-a7b9-0854bdf0cae3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "Perm", "[", 
   "]"}]}]], "Input",ExpressionUUID->"3c2946bf-d7c5-4ce6-8746-e37b2b94afc5"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Perm", "::", "argx"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(Perm\\)\[NoBreak] called with \
\[NoBreak]\\!\\(0\\)\[NoBreak] arguments; 1 argument is expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argx\\\", \
ButtonNote -> \\\"xAct`xPerm`Perm::argx\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"b6d9466e-1353-4225-95c8-71e39c6db4d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{
  "alltests", "[", "ID", 
   "]"}]}]], "Input",ExpressionUUID->"275e4462-973f-4ea8-826c-c48244faa80a"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"82db8048-ae56-4984-a47b-05e70f8fb372"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4. Notation translations. TranslatePerm", \
"Subsection",ExpressionUUID->"e37ea58d-ae13-4a4b-a1b5-302e4a3f5814"],

Cell[CellGroupData[{

Cell["2.4.1. General definitions", \
"Subsubsection",ExpressionUUID->"24457fd0-6769-4e34-bb8a-b30247bc05bc"],

Cell[TextData[{
 "This function translates any valid permutation in ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " to any valid notation."
}], "Text",ExpressionUUID->"b583a222-d453-45b0-be80-67d24fff8f23"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "TranslatePerm"}]], \
"Input",ExpressionUUID->"2a06206d-f207-4d5a-b3a2-113bb46ac7c2"],

Cell[BoxData[
 StyleBox["\<\"TranslatePerm[perm, notation] translates permutation perm, in \
any format, to the given notation, which must be one of Perm, {Perm, length}, \
Cycles, Rules, Images or {Images, length}. TranslatePerm[set, notation] \
returns the set (with head GenSet, StrongGenSet, Group or Coset) with all its \
permutations translated to notation.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977962-5455693",ExpressionUUID->"fa6a4678-1081-4d71-92a8-\
51f745a58e1e"]
}, Open  ]],

Cell["Thread translate over lists and sets of permutations:", \
"Text",ExpressionUUID->"4aeafea6-965e-4376-9bfa-85ca7e3c85cd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"set", ":", 
      RowBox[{"(", 
       RowBox[{"_List", "|", "_GenSet", "|", "_Group", "|", "_Coset"}], 
       ")"}]}], ",", "notation_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"TranslatePerm", "[", 
      RowBox[{"#", ",", "notation"}], "]"}], "&"}], "/@", "set"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_List", ",", "GS_GenSet"}], "]"}], ",", "notation_"}], 
    "]"}], ":=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{"base", ",", 
     RowBox[{"TranslatePerm", "[", 
      RowBox[{"GS", ",", "notation"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Symmetric", "[", "list_", "]"}], ",", "notation_"}], "]"}], ":=", 
   RowBox[{"Symmetric", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Antisymmetric", "[", "list_", "]"}], ",", "notation_"}], "]"}], 
   ":=", 
   RowBox[{"Antisymmetric", "[", "list", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0b7a75e9-def1-43af-9469-4d6da08fdbeb"],

Cell["Linear combinations:", \
"Text",ExpressionUUID->"e70f1586-5de6-4f9b-84f2-164ed53f308d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"expr_Plus", ",", "notation_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"TranslatePerm", "[", 
      RowBox[{"#", ",", "notation"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], " ", "perm_"}], ",", "notation_"}], 
    "]"}], ":=", 
   RowBox[{"x", " ", 
    RowBox[{"TranslatePerm", "[", 
     RowBox[{"perm", ",", "notation"}], "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"1c958f97-20b0-44bb-8430-acf014cdf562"],

Cell["\<\
Translation to Perm and Images notations is given in terms of {Perm, length} \
and {Images, length}:\
\>", "Text",ExpressionUUID->"d1789613-4a6e-43a1-aeb9-c700e90c9baf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"perm_", ",", "Perm"}], "]"}], ":=", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"perm", ",", 
     RowBox[{"{", 
      RowBox[{"Perm", ",", 
       RowBox[{"PermLength", "@", "perm"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"perm_", ",", "Images"}], "]"}], ":=", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"perm", ",", 
     RowBox[{"{", 
      RowBox[{"Images", ",", 
       RowBox[{"PermLength", "@", "perm"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b5853de9-a89e-42ce-85b8-6e3e2d9f6dac"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.2. ID to ...", \
"Subsubsection",ExpressionUUID->"d4038564-2fc9-4ee4-811a-16c90bbc148b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"ID", ",", 
     RowBox[{"{", 
      RowBox[{"Perm", ",", "length_Integer"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Perm", "[", 
    RowBox[{"Range", "[", "length", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"ID", ",", 
     RowBox[{"{", 
      RowBox[{"Images", ",", "length_Integer"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Images", "[", 
    RowBox[{"Range", "[", "length", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"ID", ",", "Cycles"}], "]"}], ":=", 
   RowBox[{"Cycles", "[", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"ID", ",", "Rules"}], "]"}], ":=", 
   RowBox[{"Rules", "[", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7d070bee-2620-4ce8-b74f-97f5ab7f3ba3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"ID", ",", "Perm"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e07d115d-2fe1-4610-adf1-9e7fb6d99dfd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"ba8b7d86-9f53-45d1-b9b3-9da7e2b9cb6c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"-", "ID"}], ",", "Perm"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", "}"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"16657891-546c-4f38-bbfe-008225c4cd19"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"8b09992c-b7d4-4920-afe3-739d40b3a49c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"ID", ",", "Images"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"422d2ba3-3ef0-4054-9ff7-47757104269e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"920fe137-080e-47a9-b6ad-72889284f7f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"-", "ID"}], ",", "Images"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", "}"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"2b4058e9-b0cd-48dd-a4bf-ca9c80f7f6cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d187cdd1-ae6f-4fb4-bd7b-a4712f08c12f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.3. Cycles to ...", \
"Subsubsection",ExpressionUUID->"f1b4832b-3b86-4f7c-bf6e-3e99eb39ac9f"],

Cell["1) Cycles to Cycles:", \
"Text",ExpressionUUID->"a16d4fd2-d2c4-4323-bea9-48e0851f91a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"perm", ":", 
      RowBox[{"Cycles", "[", "___List", "]"}]}], ",", "Cycles"}], "]"}], ":=", 
   RowBox[{"Cycles", "@@", 
    RowBox[{"First", "[", 
     RowBox[{"System`Cycles", "[", 
      RowBox[{"List", "@@", "perm"}], "]"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"199947fb-0377-4052-8d2f-4afe5f1c9f48"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6", ",", "4"}], "}"}]}], "]"}], ",", "Cycles"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ce32fe5a-1b74-43d5-813b-c112c5b84524"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d7f98f2b-c111-4384-a8e4-d4fb7c4ca80e"]
}, Open  ]],

Cell["2) Cycles to Rules:", \
"Text",ExpressionUUID->"196336f7-d243-4ca0-a66e-9609c64254d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "cycs___List", "]"}], ",", "Rules"}], "]"}], ":=", 
   RowBox[{"Inner", "[", 
    RowBox[{"Rule", ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", "cycs", "}"}], "]"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"RotateLeft", "/@", 
       RowBox[{"{", "cycs", "}"}]}], "]"}], ",", "Rules"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e1934e8f-85ea-41dc-971f-f2db4d007a3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}]}], "]"}], ",", "Rules"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Rules", "[", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"39c597d5-67e9-4849-813c-0da91ec49c3f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"7d575f59-590e-4156-8bf3-8c343972e38b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", "Rules"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Rules", "[", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"f4f84a0b-bf68-4202-bc29-d086217ce854"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"958f1821-b8a3-4479-afe0-ad50a93c9bd6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"102", ",", "101"}], "}"}], "]"}], ",", "Rules"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"e28ad3bc-b2ee-49cf-8858-cff1b2983063"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"TranslatePerm", "[", 
     RowBox[{
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"102", ",", "101"}], "}"}], "]"}], ",", "Rules"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Inner", "[", 
     RowBox[{"Rule", ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"102", ",", "101"}], "}"}], "}"}], "]"}], ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{"RotateLeft", "/@", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"102", ",", "101"}], "}"}], "}"}]}], "]"}], ",", "Rules"}], 
     "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"102", ",", "101"}], "}"}], "}"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"102", ",", "101"}], "}"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"RotateLeft", "/@", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"102", ",", "101"}], "}"}], "}"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{"RotateLeft", "[", 
          RowBox[{"{", 
           RowBox[{"102", ",", "101"}], "}"}], "]"}], "}"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"RotateLeft", "[", 
           RowBox[{"{", 
            RowBox[{"102", ",", "101"}], "}"}], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{"101", ",", "102"}], "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"101", ",", "102"}], "}"}], "}"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"101", ",", "102"}], "}"}], "}"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"101", ",", "102"}], "}"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Inner", "[", 
     RowBox[{"Rule", ",", 
      RowBox[{"{", 
       RowBox[{"102", ",", "101"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"101", ",", "102"}], "}"}], ",", "Rules"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"102", "\[Rule]", "101"}], ",", 
      RowBox[{"101", "\[Rule]", "102"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"102", "\[Rule]", "101"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"102", "\[Rule]", "101"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"101", "\[Rule]", "102"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"101", "\[Rule]", "102"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"102", "\[Rule]", "101"}], ",", 
      RowBox[{"101", "\[Rule]", "102"}]}], "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"3de6eee5-9d04-4be5-80b1-da4cf3049fb8"]
}, Open  ]],

Cell["3) Cycles to Perm:", \
"Text",ExpressionUUID->"8f6a7be3-7869-4883-83a9-cd8fedb68eb7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"Cycles", "[", "cycs___List", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Perm", ",", "length_Integer"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Perm", "@", 
   RowBox[{"PermList", "[", 
    RowBox[{
     RowBox[{"System`Cycles", "[", 
      RowBox[{"Reverse", "/@", 
       RowBox[{"{", "cycs", "}"}]}], "]"}], ",", "length"}], 
    "]"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d6c2253d-ca3a-4d35-bc9a-4a1a9de12615"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Perm", ",", "9"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "1", ",", "2", ",", "7", ",", "5", ",", "6", ",", "4", ",", 
      "8", ",", "9"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"96686262-75b6-41b5-b0c9-28ac70b52643"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6151500c-bf38-410f-91ce-933155d46627"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7"}], "}"}]}], "]"}], ",", "Perm"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "1", ",", "2", ",", "7", ",", "5", ",", "6", ",", "4"}], "}"}],
     "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7654e18d-6a3f-414a-aab9-7ba48d29cd95"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "9", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"047118b7-86aa-46c0-ae7f-c17441b25384"]
}, Open  ]],

Cell["4) Cycles to Images:", \
"Text",ExpressionUUID->"39d4f754-c52d-4ed3-8599-dbce32791fec"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"perm", ":", 
      RowBox[{"Cycles", "[", "cycs___List", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"Images", ",", "length_Integer"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Images", "@", 
    RowBox[{"PermList", "[", 
     RowBox[{
      RowBox[{"System`Cycles", "[", 
       RowBox[{"{", "cycs", "}"}], "]"}], ",", "length"}], "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a9696bc6-629e-48ac-87f5-0e9083917203"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7"}], "}"}]}], "]"}], ",", "Images"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "3", ",", "1", ",", "7", ",", "5", ",", "6", ",", "4"}], "}"}],
     "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"6218bb6b-b73f-4c7a-9c11-668be0de6d9e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "10", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"afea193d-7ff2-4b3e-84c8-16e375441749"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "7"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"Images", ",", "8"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "7", ",", "5", ",", "6", ",", "4", ",", 
       "8"}], "}"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"62cb1a87-edb4-40d0-9ef8-85915fb922a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "11", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"cfa407f8-4834-42d9-9621-07b1b504d1ac"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.4. Perm to ...", \
"Subsubsection",ExpressionUUID->"b5a525d4-2443-4dff-9f73-60323e58e073"],

Cell["\<\
1) Perm to Perm. Note that if we require a larger length then we add more \
points:\
\>", "Text",ExpressionUUID->"a0290f35-b4ec-486a-9f92-86b29e85365e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", "list_List", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Perm", ",", "length_Integer"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Perm", "@", 
    RowBox[{"PermList", "[", 
     RowBox[{"list", ",", "length"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"573dc6b5-37d2-4802-856d-24d9b9db456b"],

Cell["2) Perm to Cycles:", \
"Text",ExpressionUUID->"3b045d43-31bb-4485-8bd2-4f66bf9d8ce9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", "list_List", "]"}], ",", "Cycles"}], "]"}], ":=", 
   RowBox[{"Cycles", "@@", 
    RowBox[{"(", 
     RowBox[{"Reverse", "/@", 
      RowBox[{"First", "[", 
       RowBox[{"PermCycles", "[", "list", "]"}], "]"}]}], ")"}]}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"25ab2d01-d56d-4f47-821d-e3be50fefe29"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "3", ",", "4", ",", "2", ",", "5", ",", "1", ",", "6", ",", "8", ",", 
        "7"}], "}"}], "]"}], ",", "Cycles"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "4", ",", "2", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "7"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3712b5a2-6a4f-4c6c-a339-44aa00ed7f28"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "12", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"375a62db-7ece-4c34-ab63-1e0ccb98aee8"]
}, Open  ]],

Cell["3) Perm to Rules (intermediate translation to Cycles):", \
"Text",ExpressionUUID->"03fdc692-872a-477a-9758-de4ce993f0a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"perm", ":", 
      RowBox[{"Perm", "[", "_List", "]"}]}], ",", "Rules"}], "]"}], ":=", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"TranslatePerm", "[", 
      RowBox[{"perm", ",", "Cycles"}], "]"}], ",", "Rules"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ccb587e8-8bb2-42aa-af04-c3cd7ba5ceb5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "3", ",", "4", ",", "2", ",", "5", ",", "1", ",", "6", ",", "8", ",", 
        "7"}], "}"}], "]"}], ",", "Rules"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Rules", "[", 
    RowBox[{
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"8", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"b412f2bb-0c30-4e99-b77f-5b7397b16d78"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "13", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"b22edb22-95fd-4f4e-8f25-f56dd60ebac5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", "}"}], "]"}], ",", "Rules"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Rules", "[", "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3634f224-d5ac-461b-b196-41b3d52603a7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "14", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"b141caf1-4eb7-4f86-bae5-f1a1bb4edd7d"]
}, Open  ]],

Cell["\<\
4) Perm To Images. Again, add points if we require a larger length:\
\>", "Text",ExpressionUUID->"6561a4e6-747e-478e-a989-7521c2d0a88e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", "list_List", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Images", ",", "length_Integer"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Images", "[", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Ordering", "[", "list", "]"}], "~", "Join", "~", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "list", "]"}], "+", "1"}], ",", "length"}], 
        "]"}]}], ",", "length"}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ff9743d5-ebc9-4efb-a4cf-c97cc38b0300"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "2", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], ",",
      "Images"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e38dbfca-3d26-4398-b3d5-5c6256744655"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "15", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"484a5f40-0dea-4637-a23e-5ea53c44aa6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "4", ",", "2", ",", "5", ",", "3", ",", "1", ",", "6", ",", "7", ",", 
        "8"}], "}"}], "]"}], ",", "Images"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "4", ",", "1", ",", "3", ",", "6", ",", "7", ",", 
      "8"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"b4364b19-2634-4785-968c-622e786dd5fb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "16", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"052a95e9-c64d-4a03-b360-5913d8d22b9a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "4", ",", "2", ",", "5", ",", "3", ",", "1", ",", "6", ",", "7", ",", 
        "8"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Images", ",", "5"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"c38bae70-ec92-44f6-9134-7ae73ec6022f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "17", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"1eb5e6f2-93ab-4c2a-ace4-e96348652fae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "4", ",", "2", ",", "5", ",", "3", ",", "1", ",", "6", ",", "7", ",", 
        "8"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Images", ",", "10"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "4", ",", "1", ",", "3", ",", "6", ",", "7", ",", 
      "8", ",", "9", ",", "10"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"29b0431e-eed2-4772-a3c5-eb367802132b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "18", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"8443463b-44a5-40e7-9ff0-05e6455b4865"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.5. Rules to ...", \
"Subsubsection",ExpressionUUID->"374c941a-2744-44fb-beff-9d8b924689fc"],

Cell["1) Rules to Rules:", \
"Text",ExpressionUUID->"1d3e9748-8352-4a36-b351-6d76bf8b9240"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"perm", ":", 
      RowBox[{"Rules", "[", "___Rule", "]"}]}], ",", "Rules"}], "]"}], ":=", 
   "perm"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3128a12b-13fe-4395-b7f0-959a9445353c"],

Cell["2) Rules to Cycles. Rewriting-rules coding:", \
"Text",ExpressionUUID->"fe6146c9-d63f-4db4-89c8-69e4c90e5a99"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"m1c", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n_", ",", "n_"}], "}"}], ",", "_"}], "]"}], ":=", 
   RowBox[{"Sequence", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"m1c", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n_", ",", "other__", ",", "n_"}], "}"}], ",", "_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"n", ",", "other"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"m1c", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"other___", ",", "n_"}], "}"}], ",", "rules_"}], "]"}], ":=", 
   RowBox[{"m1c", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"other", ",", "n", ",", 
       RowBox[{"n", "/.", "rules"}]}], "}"}], ",", "rules"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mcs", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n_", ",", "other___"}], "}"}], ",", "rules_", ",", 
     RowBox[{"{", "cycs___", "}"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cyc", "=", 
       RowBox[{"m1c", "[", 
        RowBox[{
         RowBox[{"{", "n", "}"}], ",", "rules"}], "]"}]}], "}"}], ",", 
     RowBox[{"mcs", "[", 
      RowBox[{
       RowBox[{"Complement", "[", 
        RowBox[{
         RowBox[{"{", "other", "}"}], ",", "cyc"}], "]"}], ",", "rules", ",", 
       
       RowBox[{"{", 
        RowBox[{"cycs", ",", "cyc"}], "}"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]",
 
 RowBox[{
  RowBox[{
   RowBox[{"mcs", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "_", ",", "cycs_"}], "]"}], ":=", "cycs"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Rules", "[", "rules___Rule", "]"}], ",", "Cycles"}], "]"}], ":=", 
   RowBox[{"Cycles", "@@", 
    RowBox[{"mcs", "[", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"PermDeg", "[", 
        RowBox[{"Rules", "[", "rules", "]"}], "]"}], "]"}], ",", 
      RowBox[{"{", "rules", "}"}], ",", 
      RowBox[{"{", "}"}]}], "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"18334795-3c45-41f1-8b6b-9a91b2aa7850"],

Cell["\<\
It would be nice to write a one-liner, but I don't know how to do it.\
\>", "Text",ExpressionUUID->"7fd64557-7d9a-4a31-8268-18fa1638b518"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "1"}]}], "]"}], ",", "Cycles"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e7168c91-22ee-4ccc-bfbf-abfa30b321b1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "19", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"5185886b-4784-4bbb-810a-abc60aefe08b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "1"}], ",", 
       RowBox[{"7", "\[Rule]", "8"}], ",", 
       RowBox[{"8", "\[Rule]", "7"}]}], "]"}], ",", "Cycles"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"a6a8f163-0a80-4b2b-ab97-db380703e3bb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "20", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"cc07a886-d2a8-4250-880c-bcf76a7df397"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Rules", "[", "]"}]}], ",", "Cycles"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"370abd6e-19b3-4b52-bf95-99cf16095f8e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "21", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"0f982ab8-08aa-4d5e-bc18-94b5ad926b2e"]
}, Open  ]],

Cell["3) Rules to Perm:", \
"Text",ExpressionUUID->"9349aa30-d892-4a14-bd60-03a0c6234a3f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"Rules", "[", "rules___Rule", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Perm", ",", "length_Integer"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Perm", "@", 
   RowBox[{"ReplacePart", "[", 
    RowBox[{
     RowBox[{"Range", "@", "length"}], ",", 
     RowBox[{"First", "/@", 
      RowBox[{"{", "rules", "}"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "}"}], "&"}], "/@", 
        RowBox[{"{", "rules", "}"}]}], ")"}], "/.", 
      RowBox[{
       RowBox[{"{", "}"}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", "}"}], "}"}]}]}], ",", 
     RowBox[{
      RowBox[{"Partition", "[", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{"Length", "[", 
          RowBox[{"{", "rules", "}"}], "]"}], "]"}], ",", "1"}], "]"}], "/.", 
      
      RowBox[{
       RowBox[{"{", "}"}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", "}"}], "}"}]}]}]}], "]"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4052072f-5c16-447c-9488-84bdc1d4eb80"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", "1"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Perm", ",", "7"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "1", ",", "3", ",", "4", ",", "2", ",", "6", ",", "7"}], "}"}],
     "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"c22524a8-85a7-441c-ac1d-a47652623b0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "22", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"e7686925-9c08-4d41-8d29-bb2e1fb56531"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "2"}], ",", 
        RowBox[{"2", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "1"}], ",", 
        RowBox[{"7", "\[Rule]", "8"}], ",", 
        RowBox[{"8", "\[Rule]", "7"}]}], "]"}]}], ",", "Perm"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{
      "5", ",", "1", ",", "3", ",", "4", ",", "2", ",", "6", ",", "8", ",", 
       "7"}], "}"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"4c5d0224-78e0-4b78-9600-a84cec870ca5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "23", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"225f0bbb-0f4a-499d-b976-5b6600d97041"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Rules", "[", "]"}], ",", "Perm"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"13782cff-6647-47e8-9cc3-7ef1cc18957e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "24", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"dab0356a-0911-4c06-b744-edbe2215e77e"]
}, Open  ]],

Cell["4) Rules to Images:", \
"Text",ExpressionUUID->"e067b351-be45-4bc0-b01f-2e7d96956367"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"perm", ":", 
     RowBox[{"Rules", "[", "___Rule", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"Images", ",", "length_Integer"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Images", "[", 
   RowBox[{
    RowBox[{"Range", "@", "length"}], "/.", 
    RowBox[{"List", "@@", "perm"}]}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"af7c84d3-c5e6-40e1-92c7-d15a2df6cfd5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"2", "\[Rule]", "4"}], ",", 
       RowBox[{"3", "\[Rule]", "2"}], ",", 
       RowBox[{"4", "\[Rule]", "1"}]}], "]"}], ",", "Images"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"63e00c07-5d23-4185-85b7-2422cb2f6466"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "25", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"ccc89b83-2add-4cdc-991d-285530925c8c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.6. Images to ...", \
"Subsubsection",ExpressionUUID->"7ac39c73-58c3-4fa3-a719-395ef44cb7ce"],

Cell["1) Images to Images:", \
"Text",ExpressionUUID->"381f902b-5847-4530-972d-d743a98c41cd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Images", "[", "list_List", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Images", ",", "length_Integer"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Images", "[", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{"list", "~", "Join", "~", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "list", "]"}], "+", "1"}], ",", "length"}], 
        "]"}]}], ",", "length"}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"41e49102-7c6f-4ed8-92c5-63a60a2c2856"],

Cell["2) Images to Perm:", \
"Text",ExpressionUUID->"41d7fa40-e013-4d17-8a68-9db3d220735a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Images", "[", "list_List", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Perm", ",", "length_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Perm", "[", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Ordering", "[", "list", "]"}], "~", "Join", "~", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "list", "]"}], "+", "1"}], ",", "length"}], 
        "]"}]}], ",", "length"}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f5dab01d-5e54-4c11-9c0d-e57b0a0872fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{
        "3", ",", "4", ",", "2", ",", "1", ",", "7", ",", "6", ",", "5"}], 
        "}"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"Images", ",", "9"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "4", ",", "3", ",", "1", ",", "2", ",", "7", ",", "6", ",", "5", ",", 
       "8", ",", "9"}], "}"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"17cca6a7-eea3-4a5e-b604-ee2008ae39fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "26", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"a6fe386a-d984-4371-8499-86c0a06ff301"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{
        "4", ",", "3", ",", "1", ",", "2", ",", "7", ",", "6", ",", "5", ",", 
         "8", ",", "9"}], "}"}], "]"}]}], ",", "Perm"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{
      "3", ",", "4", ",", "2", ",", "1", ",", "7", ",", "6", ",", "5", ",", 
       "8", ",", "9"}], "}"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"354ad0c5-b463-4e0c-a81e-4229aa99b10c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "27", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4c9f18db-11c8-40e4-ab94-1f651c4f858b"]
}, Open  ]],

Cell["3) Images to Cycles:", \
"Text",ExpressionUUID->"78d03023-25a3-450f-ac82-678b9eec6017"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Images", "[", "list_List", "]"}], ",", "Cycles"}], "]"}], ":=", 
   
   RowBox[{"Cycles", "@@", 
    RowBox[{"First", "[", 
     RowBox[{"PermCycles", "[", "list", "]"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"863a04b6-1a78-4793-9698-9293bada8a47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{
        "4", ",", "3", ",", "1", ",", "2", ",", "7", ",", "6", ",", "5"}], 
        "}"}], "]"}]}], ",", "Cycles"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "7"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"02c34399-5125-467a-b7c3-fae7f6778a0f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "28", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d26dfe6b-3ee9-432f-8ff3-e33c41faee2e"]
}, Open  ]],

Cell["4) Images to Rules:", \
"Text",ExpressionUUID->"63f03d43-dd01-4a3c-8df4-84c221fe38e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"Images", "[", "perm_List", "]"}], ",", "Rules"}], "]"}], ":=", 
   RowBox[{"Inner", "[", 
    RowBox[{"Rule", ",", 
     RowBox[{"Sort", "[", "perm", "]"}], ",", "perm", ",", "Rules"}], "]"}]}],
   ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"02ac6cc7-fdaa-464a-868a-bfb9c78d5c14"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TranslatePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{
        "4", ",", "3", ",", "1", ",", "2", ",", "7", ",", "6", ",", "5"}], 
        "}"}], "]"}]}], ",", "Rules"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "1"}], ",", 
      RowBox[{"4", "\[Rule]", "2"}], ",", 
      RowBox[{"5", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "5"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"803a900b-19f5-48a9-907d-51399725898f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TranslatePerm", ",", "29", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"9fe6f77d-c376-4919-83fd-5a57b552eff7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.7. Protection", \
"Subsubsection",ExpressionUUID->"3f4ea744-3253-4a80-acd6-896b2bee172c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"Cycles", "|", "Rules", "|", "Perm", "|", "Images", "|", 
      RowBox[{"{", 
       RowBox[{"Perm", ",", "_Integer"}], "}"}], "|", 
      RowBox[{"{", 
       RowBox[{"Images", ",", "_Integer"}], "}"}]}]}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"TranslatePerm", "::", "invalid"}], ",", "perm", 
      ",", "\"\<permutation\>\""}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"_", ",", "notation_"}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"TranslatePerm", "::", "unknown"}], ",", "\"\<notation\>\"", ",",
       "notation"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"TranslatePerm", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "TranslatePerm", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e6510ec9-5eee-4cd2-b2f6-3601618c2ffd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{"Hello", ",", "Cycles"}], 
   "]"}]}]], "Input",ExpressionUUID->"0859c519-6ce7-4d12-9d56-5b4b5b3c617e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"TranslatePerm", "::", "invalid"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(Hello\\)\[NoBreak] is not a valid \
\[NoBreak]\\!\\(\\\"permutation\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"d6669533-767e-4176-9f43-a78114edd32e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{"Hello", ",", "GoodBye"}], 
   "]"}]}]], "Input",ExpressionUUID->"76efc9b4-2111-481b-8b5d-8b9d4544738e"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"TranslatePerm", "::", "unknown"}], "MessageName"], ":", 
  " ", "\<\"Unknown \[NoBreak]\\!\\(\\\"notation\\\"\\)\[NoBreak] \
\[NoBreak]\\!\\(GoodBye\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"87a1e92f-f2f4-4ece-baa8-3cdae6e4a0e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{
  "alltests", "[", "TranslatePerm", 
   "]"}]}]], "Input",ExpressionUUID->"9cb6dcf2-be34-4688-80e2-e2a0ea409d99"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"d6897974-6da2-40f6-abe5-550a0bfffbb7"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5. Point images. OnPoints", \
"Subsection",ExpressionUUID->"1ff944bc-2ee3-48cf-9ad1-1c88c4d2e13c"],

Cell[CellGroupData[{

Cell["2.5.1. Definitions and examples", \
"Subsubsection",ExpressionUUID->"5bcb0675-c14d-4653-8187-9aea0145e16f"],

Cell["\<\
This is usually treated as a Power function on permutations. I don't like \
that at all.\
\>", "Text",ExpressionUUID->"cf4e93df-35dd-4ca0-a522-bd687010d052"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "OnPoints"}]], \
"Input",ExpressionUUID->"015ddb0c-76b2-41c2-94f4-d46c5ae78c4e"],

Cell[BoxData[
 StyleBox["\<\"OnPoints[p, perm] yields the image of point p under \
permutation perm. OnPoints[{p1, ...}, perm] yields the list of images of \
points pi. Signs of permutations are not considered.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977965-5455693",ExpressionUUID->"3796c172-0f56-480f-97e0-\
3cab4487bd50"]
}, Open  ]],

Cell["OnPoints is listable on its first argument:", \
"Text",ExpressionUUID->"5622f156-7470-4d26-8819-3baebe1d4d9e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"list_List", ",", "perm_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"OnPoints", "[", 
      RowBox[{"#", ",", "perm"}], "]"}], "&"}], "/@", "list"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8233fc0d-2a40-4855-9045-4f58c4246f37"],

Cell["Permutations acting on points:", \
"Text",ExpressionUUID->"b453820c-9662-4620-8ad1-9b15ab4a4a28"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"p_Integer", ",", "ID"}], "]"}], ":=", "p"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"cbeafc55-a5f9-4f34-9474-3bd1265b815e"],

Cell["\<\
HACK: OnPoints with negative permutations: forget about sign. Onpoints is not \
defined on sums or multiplications for scalars other than -1.\
\>", "Text",ExpressionUUID->"0409317e-1489-451e-a20a-8bb8480d95dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Sign", " ", "points"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"OnPoints", "[", 
      RowBox[{"0", ",", 
       RowBox[{"-", "perm_"}]}], "]"}], ":=", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OnPoints", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "perm_"}]}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OnPoints", "[", 
      RowBox[{"0", ",", "perm_"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OnPoints", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "perm_"}], "]"}], ":=", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Other", " ", "points"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OnPoints", "[", 
      RowBox[{"p_Integer", ",", 
       RowBox[{"-", "perm_"}]}], "]"}], ":=", 
     RowBox[{"OnPoints", "[", 
      RowBox[{"p", ",", "perm"}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"16ded87a-3c7d-4539-9392-4ac7f4e66b4c"],

Cell["1) Perm notation:", \
"Text",ExpressionUUID->"404fe9e9-52e2-4771-a4dd-4a36a38ce914"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"p_Integer", ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"list", ":", 
       RowBox[{"{", 
        RowBox[{"___", ",", "p_", ",", "___"}], "}"}]}], "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Position", "[", 
     RowBox[{"list", ",", "p"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"p_Integer", ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", "___", "}"}], "]"}]}], "]"}], ":=", "p"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3987cc54-4a65-462f-8276-23114d8573bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"5", ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "5"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ae952146-180d-4ff4-933d-7be626ee1554"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"67d94424-50a0-430b-a30d-d255c813b19f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"4", ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "2"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"a5626b80-fe48-4437-b3e9-c51d7af45e10"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6aa587cf-b285-4e8d-ae45-8de135f1f138"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", "}"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", "1"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"f1ac903a-70bd-4f54-848a-a5383a5500fe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"01e49b95-c632-4d62-9b7f-9829710a3fbc"]
}, Open  ]],

Cell["The function OnPoints is reasonably fast in Perm notation", \
"Text",ExpressionUUID->"6cb2d359-3571-4128-aa49-a21f615470c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"OnPoints", "[", 
   RowBox[{"4", ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}], 
   "]"}], "]"}]], \
"Input",ExpressionUUID->"0a1ce793-dddd-4960-8bb5-642cc740df89"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"OnPoints", "[", 
     RowBox[{"4", ",", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}],
      "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"Position", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], ",", 
       "4"}], "]"}], "\[LeftDoubleBracket]", 
     RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], ",", 
        "4"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"{", "3", "}"}], "}"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", "3", "}"}], "}"}], "\[LeftDoubleBracket]", 
     RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}],
    HoldForm], ",", 
   TagBox["3",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"f7c683a6-e03a-4e08-ac63-e51c7896ecfa"]
}, Open  ]],

Cell["2) Rules notation:", \
"Text",ExpressionUUID->"430fd783-7c63-43a4-87b0-6ad048634171"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"p_Integer", ",", 
     RowBox[{"Rules", "[", "rules___Rule", "]"}]}], "]"}], ":=", 
   RowBox[{"p", "/.", 
    RowBox[{"{", "rules", "}"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"18ff0e81-52d2-4494-9019-c09bdc6101f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"3", ",", 
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", "1"}], ",", 
       RowBox[{"6", "\[Rule]", "7"}], ",", 
       RowBox[{"7", "\[Rule]", "6"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "5"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ed68ce21-5503-4210-8c81-113b9afed472"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"ca4f0e54-d06c-4a70-b08b-e0b4ba4a19fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"3", ",", 
     RowBox[{"-", 
      RowBox[{"Rules", "[", "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   "3"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ef742ca4-cc21-418e-b287-9a61b2a37a72"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"89a69f26-c352-4ff4-bbe0-7eb8a8dd5e5c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", 
      RowBox[{"Rules", "[", "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   "0"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"fd85d4df-7bd4-44d3-bf40-e802cd57595f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"2ac2faa5-5537-4c85-8c45-143592495a18"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"OnPoints", "[", 
   RowBox[{"3", ",", 
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"5", "\[Rule]", "1"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "6"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"21eb472a-dd73-433c-a205-e0f9bf3ae563"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"1", "\[Rule]", "3"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"1", "\[Rule]", "3"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"3", "\[Rule]", "5"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"3", "\[Rule]", "5"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"5", "\[Rule]", "1"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"5", "\[Rule]", "1"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"6", "\[Rule]", "7"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"6", "\[Rule]", "7"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"7", "\[Rule]", "6"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"7", "\[Rule]", "6"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "1"}], ",", 
        RowBox[{"6", "\[Rule]", "7"}], ",", 
        RowBox[{"7", "\[Rule]", "6"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"OnPoints", "[", 
     RowBox[{"3", ",", 
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "1"}], ",", 
        RowBox[{"6", "\[Rule]", "7"}], ",", 
        RowBox[{"7", "\[Rule]", "6"}]}], "]"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"3", "/.", "\[VeryThinSpace]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", "1"}], ",", 
       RowBox[{"6", "\[Rule]", "7"}], ",", 
       RowBox[{"7", "\[Rule]", "6"}]}], "}"}]}],
    HoldForm], ",", 
   TagBox["5",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"37b5dc3b-31d1-406a-8222-e15427aea9a8"]
}, Open  ]],

Cell["3) Cycles notation:", \
"Text",ExpressionUUID->"95814f7d-621d-424e-8d1a-3958966118bd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"p_Integer", ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"___List", ",", 
       RowBox[{"{", 
        RowBox[{"___", ",", "p_", ",", "q_", ",", "___"}], "}"}], ",", 
       "___List"}], "]"}]}], "]"}], ":=", "q"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"p_Integer", ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"___List", ",", 
       RowBox[{"{", 
        RowBox[{"q_", ",", "___", ",", "p_"}], "}"}], ",", "___List"}], 
      "]"}]}], "]"}], ":=", "q"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"p_Integer", ",", 
     RowBox[{"Cycles", "[", "___List", "]"}]}], "]"}], ":=", "p"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f9d5830b-fd42-45ab-90a7-859e15a4e1ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"3", ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "4"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7a25df20-8fdf-4de2-aa5f-a2f083ea2a49"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"47c9cea1-5a08-41d2-8ffc-6a7e66ce59ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"3", ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4", ",", "3"}], "}"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "2"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"38bfd4e8-50a6-42b6-b91e-7e3c66de3476"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"7696a2c4-2373-4e87-a614-877efa37901e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"3", ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "3"}], 
  "]"}]], "Input",ExpressionUUID->"700d2a79-7ae4-4edd-8886-abbc33f193c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "9", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"070d6d92-64b9-4977-ac56-0b1fedd159ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"3", ",", 
     RowBox[{"Cycles", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", "3"}],
   "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ccac2c7c-4427-479d-9fdf-96fbbc2a8225"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "10", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"a9623fe1-036e-44fb-b376-757df1f1ef3f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "1", ",", "3", ",", "2"}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"892852c8-d411-43b2-8d49-0312b94597de"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "11", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"2dff645e-bdba-4248-b2a3-3c9ebfe3ab2d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", "1"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"212d599d-4919-4a88-9cea-d7b38d693f8a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "12", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"3b8ec075-a925-4216-a4d9-6927f32b116c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", "3"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"99b76b6b-686a-4a9e-8a7e-b6f1519c509f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "13", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"1ea8e4d5-8284-405b-8eac-218ea8ea8b59"]
}, Open  ]],

Cell["4) Images notation:", \
"Text",ExpressionUUID->"c2c58faa-7ba7-4ea5-b8f0-4ec07df26a05"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"p_Integer", ",", 
     RowBox[{"Images", "[", 
      RowBox[{"list", ":", 
       RowBox[{"{", 
        RowBox[{"___", ",", "p_", ",", "___"}], "}"}]}], "]"}]}], "]"}], ":=", 
   RowBox[{"list", "[", 
    RowBox[{"[", "p", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"p_Integer", ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", "___", "}"}], "]"}]}], "]"}], ":=", "p"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"382352dd-1d35-4f3b-83c3-b05872cf76ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "2"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"5595ebfa-0af4-4d7a-9c2a-4b83ee3f089f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "14", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"9e1061f6-f5f1-4d01-8caa-89e689304158"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"5", ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "5"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"4f915489-f572-4432-bdf3-ea3d83a4d6c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "15", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4a5af132-cd7e-475b-924f-484fb6794a42"]
}, Open  ]],

Cell["Protection:", \
"Text",ExpressionUUID->"6ef270dd-12cc-41cc-9b1b-206185541284"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"OnPoints", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "OnPoints", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"73c7b050-bf9b-493f-8159-4b7684e750a2"],

Cell["It is not defined on linear combinations:", \
"Text",ExpressionUUID->"8fb458b1-601e-4312-b45d-4ed4b5a95462"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], "+", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"a442f0ce-2770-49b2-bd47-7cb96cd23254"],

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], "+", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "]"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"a07abf9b-c7f4-423c-8efc-7faeb46e5d24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{"1", ",", 
   RowBox[{"3", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"f604f2e3-fdd2-4b03-bc1c-18dbddbaf1f3"],

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{"1", ",", 
   RowBox[{"3", " ", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"3e925320-8bf7-4717-b781-a63be576fc01"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5.2. Timings", \
"Subsubsection",ExpressionUUID->"3fa106a5-0dd9-4c78-858c-7193c80ef348"],

Cell["First we compare different notations:", \
"Text",ExpressionUUID->"20935078-c466-4dc8-a082-f073dab5d02c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"p", "=", "1"}], ";", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"OnPoints", "[", 
       RowBox[{"p", ",", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"5", ",", "1", ",", "6", ",", "2", ",", "3", ",", "4"}], 
          "}"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10000"}], "}"}]}], "]"}], ";", "p"}], 
  "]"}]], "Input",ExpressionUUID->"42907d66-632f-47dd-a9d5-fe2d4f0928cf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.11465699999999999503241809861719957553`5.080000487553353", ",", "3"}], 
  "}"}]], "Output",ExpressionUUID->"95ddd11f-0cf0-4e7b-9b60-e1d671e6cbde"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"p", "=", "1"}], ";", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"OnPoints", "[", 
       RowBox[{"p", ",", 
        RowBox[{"Images", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4", ",", "5", ",", "6", ",", "1", ",", "3"}], 
          "}"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10000"}], "}"}]}], "]"}], ";", "p"}], 
  "]"}]], "Input",ExpressionUUID->"7dacdc0b-4039-4668-864d-69caefdfa98d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.06862799999999999456257171459583332762`4.857101255873921", ",", "3"}], 
  "}"}]], "Output",ExpressionUUID->"0d9a3205-4e8d-4b35-9234-637ca91f0258"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"p", "=", "1"}], ";", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"OnPoints", "[", 
       RowBox[{"p", ",", 
        RowBox[{"Rules", "[", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "2"}], ",", 
          RowBox[{"2", "\[Rule]", "4"}], ",", 
          RowBox[{"4", "\[Rule]", "6"}], ",", 
          RowBox[{"6", "\[Rule]", "3"}], ",", 
          RowBox[{"3", "\[Rule]", "5"}], ",", 
          RowBox[{"5", "\[Rule]", "1"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10000"}], "}"}]}], "]"}], ";", "p"}], 
  "]"}]], "Input",ExpressionUUID->"9227a9ca-83ef-4c8d-bc1f-89f2285157a5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.18414400000000000212629913676209980622`5.2857574859989676", ",", "3"}], 
  "}"}]], "Output",ExpressionUUID->"548e1e7f-2f37-4db7-b520-b23c04ab0298"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"p", "=", "1"}], ";", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"OnPoints", "[", 
       RowBox[{"p", ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"5", ",", "1", ",", "2", ",", "4", ",", "6", ",", "3"}], 
          "}"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10000"}], "}"}]}], "]"}], ";", "p"}], 
  "]"}]], "Input",ExpressionUUID->"29a2776d-a1ce-46fe-888e-47c8451ad048"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.07227899999999999602895428552074008621`4.879612048625544", ",", "3"}], 
  "}"}]], "Output",ExpressionUUID->"2cd42573-5b07-438d-b6b4-03d9a2fbfcaa"]
}, Open  ]],

Cell["Now we include irrelevant points:", \
"Text",ExpressionUUID->"44852f4b-8de3-4ffb-ba30-7faadd7c6b72"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"p", "=", "1"}], ";", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"OnPoints", "[", 
       RowBox[{"p", ",", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{
          "5", ",", "1", ",", "6", ",", "2", ",", "3", ",", "4", ",", "7", ",",
            "8", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}], "]"}]}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10000"}], "}"}]}], "]"}], ";", "p"}], 
  "]"}]], "Input",ExpressionUUID->"d2ed32f6-cc74-4c9c-a1a9-1412109410b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.12138200000000000378097553266343311407`5.1047542023230825", ",", "3"}], 
  "}"}]], "Output",ExpressionUUID->"d0eb1ea3-0e0e-4d3b-90cf-2066b5c9ff3b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"p", "=", "1"}], ";", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"OnPoints", "[", 
       RowBox[{"p", ",", 
        RowBox[{"Images", "[", 
         RowBox[{"{", 
          RowBox[{
          "2", ",", "4", ",", "5", ",", "6", ",", "1", ",", "3", ",", "7", ",",
            "8", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}], "]"}]}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10000"}], "}"}]}], "]"}], ";", "p"}], 
  "]"}]], "Input",ExpressionUUID->"84cf55a4-f282-48ad-a793-441fbc1c571e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.07240499999999999714006548856559675187`4.880368471153997", ",", "3"}], 
  "}"}]], "Output",ExpressionUUID->"21255b71-5829-4836-b048-1ab04e172794"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"p", "=", "1"}], ";", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"OnPoints", "[", 
       RowBox[{"p", ",", 
        RowBox[{"Rules", "[", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "2"}], ",", 
          RowBox[{"2", "\[Rule]", "4"}], ",", 
          RowBox[{"4", "\[Rule]", "6"}], ",", 
          RowBox[{"6", "\[Rule]", "3"}], ",", 
          RowBox[{"3", "\[Rule]", "5"}], ",", 
          RowBox[{"5", "\[Rule]", "1"}], ",", 
          RowBox[{"7", "\[Rule]", "7"}], ",", 
          RowBox[{"8", "\[Rule]", "8"}], ",", 
          RowBox[{"9", "\[Rule]", "9"}], ",", 
          RowBox[{"10", "\[Rule]", "10"}], ",", 
          RowBox[{"11", "\[Rule]", "11"}], ",", 
          RowBox[{"12", "\[Rule]", "12"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10000"}], "}"}]}], "]"}], ";", "p"}], 
  "]"}]], "Input",ExpressionUUID->"56b2c357-9641-4e28-a8f9-d58b0821e934"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.76923600000000003085176558670355007052`5.906659514165224", ",", "3"}], 
  "}"}]], "Output",ExpressionUUID->"8f74f1d6-6c68-4714-8264-a56fc9673089"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"p", "=", "1"}], ";", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"OnPoints", "[", 
       RowBox[{"p", ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"5", ",", "1", ",", "2", ",", "4", ",", "6", ",", "3"}], 
           "}"}], ",", 
          RowBox[{"{", "7", "}"}], ",", 
          RowBox[{"{", "8", "}"}], ",", 
          RowBox[{"{", "9", "}"}], ",", 
          RowBox[{"{", "10", "}"}], ",", 
          RowBox[{"{", "11", "}"}], ",", 
          RowBox[{"{", "12", "}"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10000"}], "}"}]}], "]"}], ";", "p"}], 
  "]"}]], "Input",ExpressionUUID->"2aa36dd0-9c4f-481b-b316-fa1862429f7b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.29445500000000002227551476607914082706`5.489618846545511", ",", "3"}], 
  "}"}]], "Output",ExpressionUUID->"00770355-da7a-4df1-a795-a67fce1b3948"]
}, Open  ]],

Cell["\<\
It is clear that a lot of time is lost eliminating the points at the end of \
the permutations.\
\>", "Text",ExpressionUUID->"eb9add8c-9c50-4b04-8e7a-ccfe7147b89d"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6. Composition of permutations. PermProduct", \
"Subsection",ExpressionUUID->"23415e71-7bd0-4b4c-b971-64ff90eecd8f"],

Cell["\<\
Composition of two permutations is defined. Composition of permutations in \
different notations is not allowed. Note that this is an important point to \
speed up calculations. In particular, this is why we want to ensure that all \
permutations in Perm or Images notation have the same length.\
\>", "Text",ExpressionUUID->"aa7a13c1-a2d8-4c23-b006-a69fb9646678"],

Cell["\<\
Linear combinations (we shall need an algebra to work with Young tableaux):\
\>", "Text",ExpressionUUID->"5b7522d2-a318-49f6-a5b6-74d3cd7a0936"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"perm1_", ",", "expr_Plus"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"PermProduct", "[", 
      RowBox[{"perm1", ",", "#"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"expr_Plus", ",", "perm2_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"PermProduct", "[", 
      RowBox[{"#", ",", "perm2"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "?", "NumericQ"}], " ", "perm1_"}], ",", "perm2_"}], 
    "]"}], ":=", 
   RowBox[{"x", " ", 
    RowBox[{"PermProduct", "[", 
     RowBox[{"perm1", ",", "perm2"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"perm1_", ",", 
     RowBox[{
      RowBox[{"y_", "?", "NumericQ"}], " ", "perm2_"}]}], "]"}], ":=", 
   RowBox[{"y", " ", 
    RowBox[{"PermProduct", "[", 
     RowBox[{"perm1", ",", "perm2"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"perm_", ",", "0"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"0", ",", "perm_"}], "]"}], ":=", "0"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fd9d3b74-4227-4c69-bbae-c7e2ddd9b4b7"],

Cell["Identity:", \
"Text",ExpressionUUID->"88e2ab20-c301-4d41-8d77-f0ac01f600b7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", "]"}], ":=", "ID"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"perm_", ",", "ID"}], "]"}], ":=", "perm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"ID", ",", "perm_"}], "]"}], ":=", "perm"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"29eb105f-c7c4-4bf6-a7bf-4cde29c3cb7c"],

Cell["\<\
OneIdentity (this is given to be consistent with PermPower[perm, 1] below):\
\>", "Text",ExpressionUUID->"e9b9251c-fdd1-4f9a-95f9-4e86b821f443"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", "perm_", "]"}], ":=", "perm"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4c75b002-76e0-41ac-becd-38eb31f05b2e"],

Cell["Associativity (it doesn't matter which side we choose):", \
"Text",ExpressionUUID->"10baf7d4-0c5e-4b46-8384-9315ea496529"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"perm1_", ",", "perm2_", ",", "perm3__"}], "]"}], ":=", 
   RowBox[{"PermProduct", "[", 
    RowBox[{"perm1", ",", 
     RowBox[{"PermProduct", "[", 
      RowBox[{"perm2", ",", "perm3"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"856f3012-25c1-4156-b13b-e8c7bbe70dfc"],

Cell["Thread over lists:", \
"Text",ExpressionUUID->"ba790938-ff25-4542-a61b-48376b923654"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"list_List", ",", "perm_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"PermProduct", "[", 
      RowBox[{"#", ",", "perm"}], "]"}], "&"}], "/@", "list"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"perm_", ",", "list_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"PermProduct", "[", 
      RowBox[{"perm", ",", "#"}], "]"}], "&"}], "/@", "list"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fe9b1f57-e811-4ae7-bab1-b2f352826f26"],

Cell["Linearity:", \
"Text",ExpressionUUID->"3ef7e46e-16ea-4b5f-9b44-3ea36e4051cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], "+", 
    RowBox[{"3", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}]}]}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"5365007e-6e26-43e7-b10a-1bc7e977072d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PermProduct", "[", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}]}], "]"}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
    "]"}]}]}]], \
"Output",ExpressionUUID->"a2309963-207e-45ad-8037-d597bf3a211f"]
}, Open  ]],

Cell["\<\
1) Perm notation (note that we do not check lengths). This definition \
essentially defines the convention of multiplications: from left to right:\
\>", "Text",ExpressionUUID->"f2bd7690-e177-4938-b33e-5538d23e726d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Perm", "[", "list_List", "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", "}"}], "]"}]}], "]"}], ":=", 
   RowBox[{"Perm", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", "list_List", "]"}]}], "]"}], ":=", 
   RowBox[{"Perm", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Perm", "[", "list1_List", "]"}], ",", 
     RowBox[{"Perm", "[", "list2_List", "]"}]}], "]"}], ":=", 
   RowBox[{"Perm", "[", 
    RowBox[{"list1", "[", 
     RowBox[{"[", "list2", "]"}], "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b54839ab-bc23-4a65-a9cb-424ad3e82db9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2", ",", "6"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "6", ",", "2"}], "}"}],
       "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "1", ",", "3", ",", "6", ",", "4"}], "}"}], 
    "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7d891d28-b596-4250-a6f9-8b8d589dc436"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"8a148ed6-01c8-41d2-a1f1-69a252a68a67"]
}, Open  ]],

Cell["This is rather efficient:", \
"Text",ExpressionUUID->"5af271e4-d1e5-4125-bd45-c416b278b134"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"PermProduct", "[", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2", ",", "6"}], "}"}], 
     "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "6", ",", "2"}], "}"}], 
     "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"d2919634-24fe-421d-94cc-3daadca86ce9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"PermProduct", "[", 
     RowBox[{
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2", ",", "6"}], 
        "}"}], "]"}], ",", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "6", ",", "2"}], 
        "}"}], "]"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Perm", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2", ",", "6"}], "}"}],
       "\[LeftDoubleBracket]", 
      RowBox[{"{", 
       RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "6", ",", "2"}], "}"}],
       "\[RightDoubleBracket]"}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2", ",", "6"}], 
        "}"}], "\[LeftDoubleBracket]", 
       RowBox[{"{", 
        RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "6", ",", "2"}], 
        "}"}], "\[RightDoubleBracket]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"2", ",", "5", ",", "1", ",", "3", ",", "6", ",", "4"}], "}"}],
      
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "1", ",", "3", ",", "6", ",", "4"}], "}"}], 
     "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"ff75e4f3-2b93-402e-ab46-2cd65bd867d4"]
}, Open  ]],

Cell["2) Rules notation:", \
"Text",ExpressionUUID->"d7090345-9ee4-43eb-9cab-65117f371455"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PermProduct", "[", 
   RowBox[{
    RowBox[{"Rules", "[", "r1___Rule", "]"}], ",", 
    RowBox[{"Rules", "[", "r2___Rule", "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Inner", "[", 
     RowBox[{"Rule", ",", "#", ",", 
      RowBox[{
       RowBox[{"#", "/.", 
        RowBox[{"{", "r1", "}"}]}], "/.", 
       RowBox[{"{", "r2", "}"}]}], ",", "Rules"}], "]"}], "&"}], "@", 
   RowBox[{"Union", "[", 
    RowBox[{"Level", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r1", ",", "r2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"-", "1"}], "}"}]}], "]"}], "]"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ffb5233d-e898-4f5b-a749-b5ea949c6c9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"4", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "1"}]}], "]"}], ",", 
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"4", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "6"}], ",", 
       RowBox[{"6", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", "1"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Rules", "[", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"56c48d19-b14c-4445-be12-84515cfe55ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"3d6bcb5c-2040-40d7-9e5b-655d591f51f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "4"}], ",", 
        RowBox[{"4", "\[Rule]", "2"}], ",", 
        RowBox[{"2", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "1"}]}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "4"}], ",", 
        RowBox[{"4", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "2"}], ",", 
        RowBox[{"2", "\[Rule]", "6"}], ",", 
        RowBox[{"6", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "1"}]}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Rules", "[", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e68df576-d69b-4cc7-835a-df4179072932"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"45739dd9-46a0-47dc-87d6-5f55d764a467"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Rules", "[", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Rules", "[", "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Rules", "[", "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"da21af4e-6781-4e35-aa2e-4138688be70c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"09bcff2d-84da-4d2d-bb07-fd89e4abc7d4"]
}, Open  ]],

Cell["This is not very efficient:", \
"Text",ExpressionUUID->"38797fc1-0f7c-4389-977c-0367af059cf5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"PermProduct", "[", 
   RowBox[{
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"4", "\[Rule]", "2"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"5", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "1"}]}], "]"}], ",", 
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"4", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "2"}], ",", 
      RowBox[{"2", "\[Rule]", "6"}], ",", 
      RowBox[{"6", "\[Rule]", "5"}], ",", 
      RowBox[{"5", "\[Rule]", "1"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"705b173c-56f7-443c-af41-e77ec4eb9f4f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"1", "\[Rule]", "4"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"1", "\[Rule]", "4"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"4", "\[Rule]", "2"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"4", "\[Rule]", "2"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"2", "\[Rule]", "5"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"2", "\[Rule]", "5"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"5", "\[Rule]", "3"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"5", "\[Rule]", "3"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"3", "\[Rule]", "1"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"3", "\[Rule]", "1"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "4"}], ",", 
        RowBox[{"4", "\[Rule]", "2"}], ",", 
        RowBox[{"2", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "1"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"1", "\[Rule]", "4"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"1", "\[Rule]", "4"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"4", "\[Rule]", "3"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"4", "\[Rule]", "3"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"3", "\[Rule]", "2"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"3", "\[Rule]", "2"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"2", "\[Rule]", "6"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"2", "\[Rule]", "6"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"6", "\[Rule]", "5"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"6", "\[Rule]", "5"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"5", "\[Rule]", "1"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"5", "\[Rule]", "1"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "4"}], ",", 
        RowBox[{"4", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "2"}], ",", 
        RowBox[{"2", "\[Rule]", "6"}], ",", 
        RowBox[{"6", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "1"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"PermProduct", "[", 
     RowBox[{
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "4"}], ",", 
        RowBox[{"4", "\[Rule]", "2"}], ",", 
        RowBox[{"2", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "1"}]}], "]"}], ",", 
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "4"}], ",", 
        RowBox[{"4", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "2"}], ",", 
        RowBox[{"2", "\[Rule]", "6"}], ",", 
        RowBox[{"6", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "1"}]}], "]"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Inner", "[", 
        RowBox[{"Rule", ",", "#1", ",", 
         RowBox[{
          RowBox[{"#1", "/.", "\[VeryThinSpace]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "\[Rule]", "4"}], ",", 
             RowBox[{"4", "\[Rule]", "2"}], ",", 
             RowBox[{"2", "\[Rule]", "5"}], ",", 
             RowBox[{"5", "\[Rule]", "3"}], ",", 
             RowBox[{"3", "\[Rule]", "1"}]}], "}"}]}], "/.", 
          "\[VeryThinSpace]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "\[Rule]", "4"}], ",", 
            RowBox[{"4", "\[Rule]", "3"}], ",", 
            RowBox[{"3", "\[Rule]", "2"}], ",", 
            RowBox[{"2", "\[Rule]", "6"}], ",", 
            RowBox[{"6", "\[Rule]", "5"}], ",", 
            RowBox[{"5", "\[Rule]", "1"}]}], "}"}]}], ",", "Rules"}], "]"}], 
       "&"}], ")"}], "[", 
     RowBox[{"Union", "[", 
      RowBox[{"Level", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "4"}], ",", 
          RowBox[{"4", "\[Rule]", "2"}], ",", 
          RowBox[{"2", "\[Rule]", "5"}], ",", 
          RowBox[{"5", "\[Rule]", "3"}], ",", 
          RowBox[{"3", "\[Rule]", "1"}], ",", 
          RowBox[{"1", "\[Rule]", "4"}], ",", 
          RowBox[{"4", "\[Rule]", "3"}], ",", 
          RowBox[{"3", "\[Rule]", "2"}], ",", 
          RowBox[{"2", "\[Rule]", "6"}], ",", 
          RowBox[{"6", "\[Rule]", "5"}], ",", 
          RowBox[{"5", "\[Rule]", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}]}], "]"}], "]"}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"Level", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "\[Rule]", "4"}], ",", 
            RowBox[{"4", "\[Rule]", "2"}], ",", 
            RowBox[{"2", "\[Rule]", "5"}], ",", 
            RowBox[{"5", "\[Rule]", "3"}], ",", 
            RowBox[{"3", "\[Rule]", "1"}], ",", 
            RowBox[{"1", "\[Rule]", "4"}], ",", 
            RowBox[{"4", "\[Rule]", "3"}], ",", 
            RowBox[{"3", "\[Rule]", "2"}], ",", 
            RowBox[{"2", "\[Rule]", "6"}], ",", 
            RowBox[{"6", "\[Rule]", "5"}], ",", 
            RowBox[{"5", "\[Rule]", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"-", "1"}], "}"}]}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{
         "1", ",", "4", ",", "4", ",", "2", ",", "2", ",", "5", ",", "5", ",",
           "3", ",", "3", ",", "1", ",", "1", ",", "4", ",", "4", ",", "3", ",",
           "3", ",", "2", ",", "2", ",", "6", ",", "6", ",", "5", ",", "5", ",",
           "1"}], "}"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Union", "[", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "4", ",", "4", ",", "2", ",", "2", ",", "5", ",", "5", ",", 
         "3", ",", "3", ",", "1", ",", "1", ",", "4", ",", "4", ",", "3", ",",
          "3", ",", "2", ",", "2", ",", "6", ",", "6", ",", "5", ",", "5", ",",
          "1"}], "}"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}],
      
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Inner", "[", 
        RowBox[{"Rule", ",", "#1", ",", 
         RowBox[{
          RowBox[{"#1", "/.", "\[VeryThinSpace]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "\[Rule]", "4"}], ",", 
             RowBox[{"4", "\[Rule]", "2"}], ",", 
             RowBox[{"2", "\[Rule]", "5"}], ",", 
             RowBox[{"5", "\[Rule]", "3"}], ",", 
             RowBox[{"3", "\[Rule]", "1"}]}], "}"}]}], "/.", 
          "\[VeryThinSpace]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "\[Rule]", "4"}], ",", 
            RowBox[{"4", "\[Rule]", "3"}], ",", 
            RowBox[{"3", "\[Rule]", "2"}], ",", 
            RowBox[{"2", "\[Rule]", "6"}], ",", 
            RowBox[{"6", "\[Rule]", "5"}], ",", 
            RowBox[{"5", "\[Rule]", "1"}]}], "}"}]}], ",", "Rules"}], "]"}], 
       "&"}], ")"}], "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
     "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Inner", "[", 
     RowBox[{"Rule", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}],
       ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
         "}"}], "/.", "\[VeryThinSpace]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "4"}], ",", 
          RowBox[{"4", "\[Rule]", "2"}], ",", 
          RowBox[{"2", "\[Rule]", "5"}], ",", 
          RowBox[{"5", "\[Rule]", "3"}], ",", 
          RowBox[{"3", "\[Rule]", "1"}]}], "}"}]}], "/.", "\[VeryThinSpace]", 
       
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "4"}], ",", 
         RowBox[{"4", "\[Rule]", "3"}], ",", 
         RowBox[{"3", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "6"}], ",", 
         RowBox[{"6", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "1"}]}], "}"}]}], ",", "Rules"}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
          "}"}], "/.", "\[VeryThinSpace]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "\[Rule]", "4"}], ",", 
           RowBox[{"4", "\[Rule]", "2"}], ",", 
           RowBox[{"2", "\[Rule]", "5"}], ",", 
           RowBox[{"5", "\[Rule]", "3"}], ",", 
           RowBox[{"3", "\[Rule]", "1"}]}], "}"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3", ",", "6"}], 
         "}"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3", ",", "6"}], 
        "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "4"}], ",", 
         RowBox[{"4", "\[Rule]", "3"}], ",", 
         RowBox[{"3", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "6"}], ",", 
         RowBox[{"6", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "1"}]}], "}"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "4", ",", "6", ",", "2", ",", "5"}], "}"}],
      
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Inner", "[", 
     RowBox[{"Rule", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "4", ",", "6", ",", "2", ",", "5"}], "}"}],
       ",", "Rules"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"2", "\[Rule]", "1"}], ",", 
      RowBox[{"3", "\[Rule]", "4"}], ",", 
      RowBox[{"4", "\[Rule]", "6"}], ",", 
      RowBox[{"5", "\[Rule]", "2"}], ",", 
      RowBox[{"6", "\[Rule]", "5"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"1", "\[Rule]", "3"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"1", "\[Rule]", "3"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"2", "\[Rule]", "1"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"2", "\[Rule]", "1"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"3", "\[Rule]", "4"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"3", "\[Rule]", "4"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"4", "\[Rule]", "6"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"4", "\[Rule]", "6"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"5", "\[Rule]", "2"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"5", "\[Rule]", "2"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"6", "\[Rule]", "5"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"6", "\[Rule]", "5"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"2", "\[Rule]", "1"}], ",", 
      RowBox[{"3", "\[Rule]", "4"}], ",", 
      RowBox[{"4", "\[Rule]", "6"}], ",", 
      RowBox[{"5", "\[Rule]", "2"}], ",", 
      RowBox[{"6", "\[Rule]", "5"}]}], "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"c1edf10b-7ddb-459f-b5af-0cd0ec619d5d"]
}, Open  ]],

Cell["\<\
3) Cycles notation (just translation to Rules). This should be improved:\
\>", "Text",ExpressionUUID->"59b4df2f-7be5-46fa-a5d5-eb0cb87e042d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "]"}], ",", 
     RowBox[{"perm", ":", 
      RowBox[{"Cycles", "[", "___List", "]"}]}]}], "]"}], ":=", "perm"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"perm", ":", 
      RowBox[{"Cycles", "[", "___List", "]"}]}], ",", 
     RowBox[{"Cycles", "[", "]"}]}], "]"}], ":=", "perm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "cycs1___", "]"}], ",", 
     RowBox[{"Cycles", "[", "cycs2___", "]"}]}], "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Cycles", ",", 
     RowBox[{"First", "@", 
      RowBox[{"PermutationProduct", "[", 
       RowBox[{
        RowBox[{"System`Cycles", "[", 
         RowBox[{"{", "cycs1", "}"}], "]"}], ",", 
        RowBox[{"System`Cycles", "[", 
         RowBox[{"{", "cycs2", "}"}], "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"9975eedb-2f2d-40de-912b-16db0246316e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ac055f4c-8bac-4d47-af60-35a905d1d0c9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"e5afc156-dd34-4916-985c-4cbba4b9ce0b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"c7d0d949-653b-484b-882b-556789cb61ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"a81e07d3-188d-423d-922c-246824bc5de3"]
}, Open  ]],

Cell["4) Images notation:", \
"Text",ExpressionUUID->"c5f1b1de-9161-4678-bc5f-0de3f301a55c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Images", "[", "list1_List", "]"}], ",", 
     RowBox[{"Images", "[", "list2_List", "]"}]}], "]"}], ":=", 
   RowBox[{"Images", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"list1", ",", "list2"}], "]"}], "/.", 
      RowBox[{"Inner", "[", 
       RowBox[{"Rule", ",", 
        RowBox[{"Sort", "[", "list1", "]"}], ",", "list1", ",", "List"}], 
       "]"}]}], "/.", 
     RowBox[{"Inner", "[", 
      RowBox[{"Rule", ",", 
       RowBox[{"Sort", "[", "list2", "]"}], ",", "list2", ",", "List"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f63eb258-c209-411d-86bb-febeef8dfc7a"],

Cell["\<\
This definition is insensitive to the lengths of the lists of points of the \
permutations.\
\>", "Text",ExpressionUUID->"3f3c0257-d8ba-4678-ae27-49889c7c6c3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], "}"}],
       "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "6", ",", "2"}], 
        "}"}], "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "6", ",", "2"}], "}"}], 
     "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"887f4b32-cca6-43c9-8013-0e08b15fbde2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"f9cd2e81-da61-4215-b873-300c7164f6cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"PermProduct", "[", 
   RowBox[{
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], "}"}], 
     "]"}], ",", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "6", ",", "2"}], "}"}], 
     "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"7f698b39-1928-4ae8-9337-d3c9af3ad8d2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"PermProduct", "[", 
     RowBox[{
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], 
        "}"}], "]"}], ",", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "6", ",", "2"}], 
        "}"}], "]"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Images", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], 
         "}"}], "\[Union]", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "6", ",", "2"}], 
         "}"}]}], "/.", "\[VeryThinSpace]", 
       RowBox[{"Inner", "[", 
        RowBox[{"Rule", ",", 
         RowBox[{"Sort", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], 
           "}"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], 
          "}"}], ",", "List"}], "]"}]}], "/.", "\[VeryThinSpace]", 
      RowBox[{"Inner", "[", 
       RowBox[{"Rule", ",", 
        RowBox[{"Sort", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "6", ",", "2"}], 
          "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "6", ",", "2"}], 
         "}"}], ",", "List"}], "]"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], 
            "}"}], "\[Union]", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "6", ",", "2"}], 
            "}"}]}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
           "}"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"Sort", "[", 
             RowBox[{"{", 
              RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}],
               "}"}], "]"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"{", 
             RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
             "}"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"Inner", "[", 
           RowBox[{"Rule", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], 
             "}"}], ",", "List"}], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "\[Rule]", "2"}], ",", 
            RowBox[{"2", "\[Rule]", "3"}], ",", 
            RowBox[{"3", "\[Rule]", "4"}], ",", 
            RowBox[{"4", "\[Rule]", "1"}], ",", 
            RowBox[{"5", "\[Rule]", "5"}], ",", 
            RowBox[{"6", "\[Rule]", "6"}]}], "}"}],
          HoldForm], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"1", "\[Rule]", "2"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"1", "\[Rule]", "2"}],
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"2", "\[Rule]", "3"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"2", "\[Rule]", "3"}],
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"3", "\[Rule]", "4"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"3", "\[Rule]", "4"}],
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"4", "\[Rule]", "1"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"4", "\[Rule]", "1"}],
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"5", "\[Rule]", "5"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"5", "\[Rule]", "5"}],
            HoldForm]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"6", "\[Rule]", "6"}],
            HoldForm], ",", 
           TagBox[
            RowBox[{"6", "\[Rule]", "6"}],
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "\[Rule]", "2"}], ",", 
            RowBox[{"2", "\[Rule]", "3"}], ",", 
            RowBox[{"3", "\[Rule]", "4"}], ",", 
            RowBox[{"4", "\[Rule]", "1"}], ",", 
            RowBox[{"5", "\[Rule]", "5"}], ",", 
            RowBox[{"6", "\[Rule]", "6"}]}], "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
          "}"}], "/.", "\[VeryThinSpace]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "\[Rule]", "2"}], ",", 
           RowBox[{"2", "\[Rule]", "3"}], ",", 
           RowBox[{"3", "\[Rule]", "4"}], ",", 
           RowBox[{"4", "\[Rule]", "1"}], ",", 
           RowBox[{"5", "\[Rule]", "5"}], ",", 
           RowBox[{"6", "\[Rule]", "6"}]}], "}"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], 
         "}"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"Sort", "[", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "6", ",", "2"}], 
            "}"}], "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
           "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"Inner", "[", 
         RowBox[{"Rule", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "6", ",", "2"}], 
           "}"}], ",", "List"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "3"}], ",", 
          RowBox[{"2", "\[Rule]", "4"}], ",", 
          RowBox[{"3", "\[Rule]", "5"}], ",", 
          RowBox[{"4", "\[Rule]", "1"}], ",", 
          RowBox[{"5", "\[Rule]", "6"}], ",", 
          RowBox[{"6", "\[Rule]", "2"}]}], "}"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"1", "\[Rule]", "3"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"1", "\[Rule]", "3"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"2", "\[Rule]", "4"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"2", "\[Rule]", "4"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"3", "\[Rule]", "5"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"3", "\[Rule]", "5"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"4", "\[Rule]", "1"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"4", "\[Rule]", "1"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"5", "\[Rule]", "6"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"5", "\[Rule]", "6"}],
          HoldForm]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"6", "\[Rule]", "2"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"6", "\[Rule]", "2"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "3"}], ",", 
          RowBox[{"2", "\[Rule]", "4"}], ",", 
          RowBox[{"3", "\[Rule]", "5"}], ",", 
          RowBox[{"4", "\[Rule]", "1"}], ",", 
          RowBox[{"5", "\[Rule]", "6"}], ",", 
          RowBox[{"6", "\[Rule]", "2"}]}], "}"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5", ",", "6"}], 
        "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "3"}], ",", 
         RowBox[{"2", "\[Rule]", "4"}], ",", 
         RowBox[{"3", "\[Rule]", "5"}], ",", 
         RowBox[{"4", "\[Rule]", "1"}], ",", 
         RowBox[{"5", "\[Rule]", "6"}], ",", 
         RowBox[{"6", "\[Rule]", "2"}]}], "}"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "6", ",", "2"}], "}"}],
      
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "6", ",", "2"}], "}"}], 
     "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"3716a3c9-05d3-4974-bec5-a7a74e458928"]
}, Open  ]],

Cell["\<\
This is a very important point, because there is a choice between two \
possibilities. Our choice means that given a list omega we perform \
permutations in the form omega \[SmallCircle] perm = omega[[ perm ]]. For \
example, in Perm notation, if we are given two permutations perm1 and perm2, \
we can multiply them as perm1 \[SmallCircle] perm2, which means omega \
\[SmallCircle] ( perm1 \[SmallCircle] perm2 ) = omega [[ perm1 \[SmallCircle] \
perm2 ]] = omega[[ perm1 ]][[ perm2 ]] = omega[[ perm1[[ perm2 ]] ]]. \
Therefore it is consistent to define perm1 \[SmallCircle] perm2 = perm1[[ \
perm2 ]]. This is good to remember the order of everything. A posteriori, the \
main motivation is having, given a point alpha, that      ( alpha^perm1 \
)^perm2 = alpha^( perm1.perm2)\
\>", "Text",ExpressionUUID->"cb56d547-53bb-4b83-9597-7d1e97972edd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e7fc8bbd-d71a-46f9-b123-0fe5009a972f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4309f6af-34cf-4b8e-9c30-83a61f68ffef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"38de3e43-9e48-486d-b25a-00f4eaa9dc09"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "9", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"22571190-44af-4f5a-9085-7a98d7643978"]
}, Open  ]],

Cell["\<\
This is the choice in GAP, the choice in Butler's book, and the choice in \
Renato's papers.\
\>", "Text",ExpressionUUID->"78f75bf7-d960-4b9e-bfc2-88b7a208c742"],

Cell["This is the example given in GAP Reference, chapter 40:", \
"Text",ExpressionUUID->"422eb634-47d5-46a3-8b13-59a9b915c711"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"62606f1b-5c64-46f2-9409-2bd309b4fab5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "10", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"99662caf-4ba7-4baa-86c6-b80c5e30c727"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"17", ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "5", ",", "17", ",", "9", ",", "8"}], "}"}], "]"}]}],
     "]"}], ",", "\[IndentingNewLine]", "9"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3e6acf4e-3d5a-476a-a555-10c15dfa3bc4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "16", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4c659718-1654-44f5-9207-10c10ee8c109"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"aea73045-d521-4f42-a7a8-d3b27ce4bb54"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "11", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"a6f0790f-628e-4418-ac92-01185d1e9ffd"]
}, Open  ]],

Cell["\<\
Note that in the Perm and Images notations we do (implicitly) check the \
lengths, in the sense that errors quickly crop up:\
\>", "Text",ExpressionUUID->"daf573dc-db6f-4b3b-ab65-d0135b867856"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "1"}], "}"}], "]"}]}], "\[IndentingNewLine]",
   "]"}]], "Input",ExpressionUUID->"fcf87ee3-277f-4ddc-8147-5bb03db52cc3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "12", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"5c7b2e52-6499-4a7e-874c-018aa1badc5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "$Failed", ",", "\[IndentingNewLine]", "True"}], 
  "]"}]], "Input",ExpressionUUID->"9672d687-697e-47ae-9285-3fcf765ff143"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Part", "::", "partw"}], "MessageName"], ":", 
  " ", "\<\"Part \[NoBreak]\\!\\({2, 4, 1, 3}\\)\[NoBreak] of \
\[NoBreak]\\!\\({2, 1, 3}\\)\[NoBreak] does not exist. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/partw\\\", \
ButtonNote -> \\\"Part::partw\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"8e30d71b-b492-4004-899c-a4274975f587"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermProduct", ",", "13", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"e3d2fc80-748a-4dea-9df6-1cb4a010853a"]
}, Open  ]],

Cell["\<\
Cosets. We first check if the permutation is already in the set or not:\
\>", "Text",ExpressionUUID->"65509b8a-7e33-44c3-9847-da5b84fec5bb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Group", "[", "perms___", "]"}], ",", "perm_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"Or", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"PermEqual", "[", 
          RowBox[{"#", ",", "perm"}], "]"}], "&"}], "/@", 
        RowBox[{"{", "perms", "}"}]}], ")"}]}], ",", 
     RowBox[{"Group", "[", "perms", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"PermProduct", "[", 
        RowBox[{"#", ",", "perm"}], "]"}], "&"}], "/@", 
      RowBox[{"Coset", "[", "perms", "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"Group", "[", "perms___", "]"}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"Or", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"PermEqual", "[", 
          RowBox[{"perm", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", "perms", "}"}]}], ")"}]}], ",", 
     RowBox[{"Group", "[", "perms", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"PermProduct", "[", 
        RowBox[{"perm", ",", "#"}], "]"}], "&"}], "/@", 
      RowBox[{"Coset", "[", "perms", "]"}]}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fc03f9e5-02c9-46f6-ad41-229a825bb552"],

Cell["Protection. PermProduct can have any number of arguments:", \
"Text",ExpressionUUID->"7460f8ce-def0-452e-ab1b-67679406215d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protection", "[", "PermProduct", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f3038a4a-4f64-4942-8bb4-43916e3f6015"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7. Inverse permutation. InversePerm", \
"Subsection",ExpressionUUID->"0b438a31-1bca-4d2c-9e1b-42a672f93d4f"],

Cell[CellGroupData[{

Cell["2.7.1. Definitions", \
"Subsubsection",ExpressionUUID->"c929b6c5-803f-4e04-b4c4-e371d7a3d42e"],

Cell["\<\
The only nontrivial part is the use of the function Ordering:\
\>", "Text",ExpressionUUID->"7862eb9b-968c-4ed2-a36c-5e494ab58661"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "InversePerm"}]], \
"Input",ExpressionUUID->"1fbcbca1-7ca3-4fcc-97f8-bba6f43e6016"],

Cell[BoxData[
 StyleBox["\<\"InversePerm[perm] gives the inverse permutation of perm.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977969-5455693",ExpressionUUID->"8a349758-6b60-46e3-aebb-\
a30c10b6a26f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InversePerm", "[", 
    RowBox[{"Perm", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"Perm", "[", 
    RowBox[{"InversePermutation", "[", "list", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InversePerm", "[", 
    RowBox[{"Images", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"Images", "[", 
    RowBox[{"InversePermutation", "[", "list", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InversePerm", "[", 
    RowBox[{"Cycles", "[", "cycs___List", "]"}], "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Cycles", ",", 
     RowBox[{"First", "@", 
      RowBox[{"InversePermutation", "[", 
       RowBox[{"System`Cycles", "[", 
        RowBox[{"{", "cycs", "}"}], "]"}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InversePerm", "[", 
    RowBox[{"Rules", "[", "rules___Rule", "]"}], "]"}], ":=", 
   RowBox[{"Reverse", "/@", 
    RowBox[{"Rules", "[", "rules", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InversePerm", "[", "ID", "]"}], ":=", "ID"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InversePerm", "[", 
    RowBox[{
     RowBox[{"x_", "?", "NumericQ"}], " ", "perm_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"1", "/", "x"}], " ", 
    RowBox[{"InversePerm", "[", "perm", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"InversePerm", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "InversePerm", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0867e224-78e6-4703-8a72-3ddab9904cb8"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7.2. Examples", \
"Subsubsection",ExpressionUUID->"e3222ffc-5127-471a-bef6-939887b98d12"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"InversePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"InversePerm", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"746ab360-0e64-4049-ae52-fb87cd8a5815"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InversePerm", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"b2ad1e32-e15e-4ec8-8994-ae7377d54171"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"InversePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"InversePerm", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", "}"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"84b4614f-3464-419b-83fe-b39a6d07732c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InversePerm", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"7ec52ec1-4bbe-474c-92ee-46cf23702f6b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"InversePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"InversePerm", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"15914a8d-8d76-4e33-b98f-f04a47fac4f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InversePerm", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"88cc1ddc-72d6-4cfa-93ef-ddeabbe511db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"InversePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"InversePerm", "[", 
    RowBox[{"-", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"5e06ea3b-09d7-47c0-bd0e-7cd3855987da"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InversePerm", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"2bbf9a8d-95db-4cd0-b8d2-517392b4714c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"InversePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"InversePerm", "[", 
    RowBox[{"-", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6", ",", "1"}], "}"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "6", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"997e1237-35ad-4434-9a5f-9ffea538905c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InversePerm", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"3d36f361-3054-4901-bf8b-8be7f199d068"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"InversePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"InversePerm", "[", 
    RowBox[{"-", 
     RowBox[{"Cycles", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"aa805000-b180-4f31-99f5-b0a6f711af9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InversePerm", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"f4be82ca-f343-45ca-b871-018221cb3f7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"InversePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"InversePerm", "[", 
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"5", "\[Rule]", "1"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Rules", "[", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"070fcacf-00ff-4c1b-9726-ba589c7c56e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InversePerm", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"e832750a-a9a8-4807-881b-12e098c97c4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"InversePerm", ",", "\[IndentingNewLine]", 
   RowBox[{"InversePerm", "[", 
    RowBox[{"Rules", "[", "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Rules", "[", "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"dbae2b9e-3947-47a0-a365-2b09f4be72f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InversePerm", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"603a1bc7-8c8a-4ca7-a310-fef9d12e8dae"]
}, Open  ]],

Cell["InversePerm is not very efficient:", \
"Text",ExpressionUUID->"46315fc8-3c0a-47b4-9a5c-48ad96668b66"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"InversePerm", "[", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"f77255ab-8a9e-4ede-9f04-c2ded1012ecc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"InversePerm", "[", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Perm", "[", 
     RowBox[{"InversePermutation", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"InversePermutation", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"d9fd5d71-d830-4189-bdb5-70ee8cc5598a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"InversePerm", "[", 
   RowBox[{"Rules", "[", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"b31fdd9f-3757-4281-8775-021ba8ba84a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"1", "\[Rule]", "3"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"1", "\[Rule]", "3"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"3", "\[Rule]", "5"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"3", "\[Rule]", "5"}],
        HoldForm]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"5", "\[Rule]", "1"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"5", "\[Rule]", "1"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "1"}]}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"InversePerm", "[", 
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", "1"}]}], "]"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Reverse", "/@", 
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", "1"}]}], "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"Reverse", "[", 
       RowBox[{"1", "\[Rule]", "3"}], "]"}], ",", 
      RowBox[{"Reverse", "[", 
       RowBox[{"3", "\[Rule]", "5"}], "]"}], ",", 
      RowBox[{"Reverse", "[", 
       RowBox[{"5", "\[Rule]", "1"}], "]"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Reverse", "[", 
       RowBox[{"1", "\[Rule]", "3"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"3", "\[Rule]", "1"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"3", "\[Rule]", "1"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Reverse", "[", 
       RowBox[{"3", "\[Rule]", "5"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"5", "\[Rule]", "3"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"5", "\[Rule]", "3"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Reverse", "[", 
       RowBox[{"5", "\[Rule]", "1"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"1", "\[Rule]", "5"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"1", "\[Rule]", "5"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Rules", "[", 
     RowBox[{
      RowBox[{"3", "\[Rule]", "1"}], ",", 
      RowBox[{"5", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", "5"}]}], "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"90a276cb-dd25-4eae-9c34-217344740dc5"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.8. Permute lists. PermuteList, PermutationFromTo", \
"Subsection",ExpressionUUID->"17254a27-9bc4-4552-a5d7-55f8ef21698d"],

Cell[TextData[{
 "This function permutes the list according to permutation perm. We neglect \
signs. This function is used twice in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " and then here we use the (private) function SignedPermuteList (see section \
3.6 below)."
}], "Text",ExpressionUUID->"63aad4eb-e13e-40f3-8a30-618bf7367763"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermuteList"}]], \
"Input",ExpressionUUID->"923ddd6d-302a-46d2-92ac-9450904fb0cf"],

Cell[BoxData[
 StyleBox["\<\"PermuteList[list, perm] permutes the points of list according \
to the permutation perm.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977971-5455693",ExpressionUUID->"c3033755-f506-42f6-b89b-\
c388bcb91865"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermuteList", "[", 
    RowBox[{"list_", ",", 
     RowBox[{"-", "perm_"}]}], "]"}], ":=", 
   RowBox[{"PermuteList", "[", 
    RowBox[{"list", ",", "perm"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermuteList", "[", 
    RowBox[{"list_", ",", "perm_"}], "]"}], ":=", 
   RowBox[{"list", "[", 
    RowBox[{"[", 
     RowBox[{"First", "@", 
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"perm", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", 
          RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], "]"}]}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermuteList", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PermuteList", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a07d08c4-ccd2-457e-a5c3-9c8f6331c801"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermuteList", ",", "\[IndentingNewLine]", 
   RowBox[{"PermuteList", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"dd8feec6-2915-4b7f-9a11-76f41223dfca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermuteList", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"cd784729-dbd7-416b-8675-d232ff9726b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermuteList", ",", "\[IndentingNewLine]", 
   RowBox[{"PermuteList", "[", 
    RowBox[{
     RowBox[{"head", "[", 
      RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"head", "[", 
    RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"2b5f5dbb-e29f-4317-8ca1-c8f535118dc9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermuteList", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"3ae597a6-42ac-42f1-be72-d9e4cddb9e29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PermuteList", "[", 
   RowBox[{
    RowBox[{"head", "[", "]"}], ",", "ID"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"417c3ed4-fdf3-48e6-838a-44cc6209f350"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"PermuteList", "[", 
     RowBox[{
      RowBox[{"head", "[", "]"}], ",", "ID"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"head", "[", "]"}], "\[LeftDoubleBracket]", 
     RowBox[{"First", "[", 
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"ID", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", 
          RowBox[{"Length", "[", 
           RowBox[{"head", "[", "]"}], "]"}]}], "}"}]}], "]"}], "]"}], 
     "\[RightDoubleBracket]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TagBox[
            RowBox[{"Length", "[", 
             RowBox[{"head", "[", "]"}], "]"}],
            HoldForm], ",", 
           TagBox["0",
            HoldForm]}], "}"}], ",", 
         TagBox[
          RowBox[{"{", 
           RowBox[{"Perm", ",", "0"}], "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"TranslatePerm", "[", 
         RowBox[{"ID", ",", 
          RowBox[{"{", 
           RowBox[{"Perm", ",", "0"}], "}"}]}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Perm", "[", 
         RowBox[{"Range", "[", "0", "]"}], "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"Range", "[", "0", "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"Perm", "[", 
         RowBox[{"{", "}"}], "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"First", "[", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", "}"}], "]"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", "}"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"head", "[", "]"}], "\[LeftDoubleBracket]", 
     RowBox[{"{", "}"}], "\[RightDoubleBracket]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"head", "[", "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"3319bc67-bfdf-4010-a6ec-e15454b58b52"]
}, Open  ]],

Cell["\<\
We introduce a definition that always works, even if the elements are \
repeated, in the sense that it always returns a valid permutation\
\>", "Text",ExpressionUUID->"85286a7f-dc04-4930-a57f-973c7c8d6a54"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermutationFromTo"}]], \
"Input",ExpressionUUID->"b31eaf0b-c57e-4172-bcff-2ae04e9f35d7"],

Cell[BoxData[
 StyleBox["\<\"PermutationFromTo[list1, list2] gives the permutation (in \
Images notation) that converts list1 into list2. Points in list1 or list2 can \
be repeated.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977971-5455693",ExpressionUUID->"062b4ac5-1245-4ada-a0ee-\
26d1d4734793"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermutationFromTo", "::", "diff"}], 
   "=", "\"\<Lists`1` and `2` contain different points\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermutationFromTo", "[", 
    RowBox[{"list1_List", ",", "list2_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"PermProduct", "[", 
     RowBox[{
      RowBox[{"InversePerm", "@", 
       RowBox[{"Images", "@", 
        RowBox[{"Ordering", "[", "list1", "]"}]}]}], ",", 
      RowBox[{"Images", "@", 
       RowBox[{"Ordering", "[", "list2", "]"}]}]}], "]"}], "/;", 
    RowBox[{
     RowBox[{"Sort", "[", "list1", "]"}], "===", 
     RowBox[{"Sort", "[", "list2", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermutationFromTo", "[", 
    RowBox[{
     RowBox[{"list1", ":", 
      RowBox[{"head_", "[", "___", "]"}]}], ",", 
     RowBox[{"list2", ":", 
      RowBox[{"head_", "[", "___", "]"}]}]}], "]"}], ":=", 
   RowBox[{"PermutationFromTo", "[", 
    RowBox[{
     RowBox[{"List", "@@", "list1"}], ",", 
     RowBox[{"List", "@@", "list2"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermutationFromTo", "[", 
    RowBox[{"list1_List", ",", "list2_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Throw", "[", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"PermutationFromTo", "::", "diff"}], ",", "list1", ",", 
       "list2"}], "]"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"Sort", "[", "list1", "]"}], "=!=", 
     RowBox[{"Sort", "[", "list2", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermutationFromTo", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PermutationFromTo", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f0819faf-b242-496a-bd76-58e600776ae1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermutationFromTo", ",", "\[IndentingNewLine]", 
   RowBox[{"PermutationFromTo", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", 
       RowBox[{"-", "c"}], ",", "b", ",", "a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a", ",", 
       RowBox[{"-", "c"}], ",", "d", ",", "a", ",", "b"}], "}"}]}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "6", ",", "5", ",", "4"}], "}"}], 
    "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7bdbdf5a-f158-4427-9bee-508f35c027c9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermutationFromTo", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4d0a2b42-94c8-438b-aa45-626e4f11bc33"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermuteList", ",", "\[IndentingNewLine]", 
   RowBox[{"PermuteList", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", 
       RowBox[{"-", "c"}], ",", "b", ",", "a", ",", "d"}], "}"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "6", ",", "5", ",", "4"}], "}"}],
       "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", 
     RowBox[{"-", "c"}], ",", "d", ",", "a", ",", "b"}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"8dcd2f18-cdfa-4d9b-a6e4-dca62f892e67"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermuteList", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"966a42ad-d7ad-4e73-87cc-700865b3be72"]
}, Open  ]],

Cell["The internal order of the repeated points is not changed:", \
"Text",ExpressionUUID->"2b249c7e-f0cf-4508-9e5c-88612e04eef4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermuteList", ",", "\[IndentingNewLine]", 
   RowBox[{"PermuteList", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "b1", ",", 
       RowBox[{"-", "c"}], ",", "b2", ",", "a2", ",", "d"}], "}"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "6", ",", "5", ",", "4"}], "}"}],
       "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "a1", ",", 
     RowBox[{"-", "c"}], ",", "d", ",", "a2", ",", "b2"}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"9e9d9879-06b7-4792-832e-41d1952ce6ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermuteList", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"c6744b5f-4934-493c-8dfa-bff9b99f85be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermutationFromTo", ",", "\[IndentingNewLine]", 
   RowBox[{"PermutationFromTo", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7220f8ec-cc57-4ee0-bc19-e228daf8025e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermutationFromTo", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"f0d4f4cb-3699-4806-8092-c48291f6a0fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermutationFromTo", ",", "\[IndentingNewLine]", 
   RowBox[{"PermutationFromTo", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"0f904e3d-00c9-4d3b-bd94-0fcd4056ad8b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermutationFromTo", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"2bf9e5a7-aa6d-4f9a-8bd4-39afc479f9d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"PermutationFromTo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "2"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f7532fe0-1a78-4973-9475-620c6f661517"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"$IterationLimit", "::", "itlim"}], "MessageName"], ":", 
  " ", "\<\"Iteration limit of \[NoBreak]\\!\\(4096\\)\[NoBreak] exceeded. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\
\", ButtonNote -> \\\"$IterationLimit::itlim\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"b66d1f5b-066d-46fd-b36c-08ca5807a391"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"PermutationFromTo", "[", 
   RowBox[{
    RowBox[{"List", "@@", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}]}], ",", 
    RowBox[{"List", "@@", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "1", ",", "2"}], "}"}]}]}], "]"}], 
  "]"}]], "Output",ExpressionUUID->"1eee52f0-7001-442e-944c-0dcba2064c52"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.9. RandomPerm", \
"Subsection",ExpressionUUID->"d020c604-b0e7-4a75-87a9-9452d3c3b300"],

Cell["\<\
RandomPerm gives a random permutation of given degree and notation. It is \
constructed in Perm notation and then translated. Note that the given \
permutation could have lower degree than that asked for. It would be highly \
counterintuitive to impose that the last element must be necessarily moved, \
but not the others.\
\>", "Text",ExpressionUUID->"85fd1504-5bbe-482e-bac5-8168cb5a1df0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "RandomPerm"}]], \
"Input",ExpressionUUID->"075d97c6-ec08-4942-b5f4-a9bc63ca18c2"],

Cell[BoxData[
 StyleBox["\<\"RandomPerm[deg] gives a random permutation in Perm notation. \
RandomPerm[deg, notation] constructs RandomPerm[deg] and then translates it \
to the given notation using TranslatePerm[perm, notation].\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977972-5455693",ExpressionUUID->"2bfddacd-c60c-4949-827b-\
9c845410fd55"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rand", "[", "n_", "]"}], ":=", 
   RowBox[{"Random", "[", 
    RowBox[{"Integer", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"addrand", "[", "n_", "]"}], "[", 
    RowBox[{"list_List", ",", "m_"}], "]"}], ":=", 
   RowBox[{"Append", "[", 
    RowBox[{"list", ",", 
     RowBox[{
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"Range", "[", "n", "]"}], ",", "list"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"rand", "[", "m", "]"}], "]"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RandomPerm", "[", "deg_", "]"}], ":=", 
   RowBox[{"RandomPerm", "[", 
    RowBox[{"deg", ",", "Perm"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RandomPerm", "[", 
    RowBox[{"deg_", ",", "Perm"}], "]"}], ":=", 
   RowBox[{"Perm", "[", 
    RowBox[{"Fold", "[", 
     RowBox[{
      RowBox[{"addrand", "[", "deg", "]"}], ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"Reverse", "@", 
       RowBox[{"Range", "[", "deg", "]"}]}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RandomPerm", "[", 
    RowBox[{"deg_", ",", "notation_"}], "]"}], ":=", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"RandomPerm", "[", 
      RowBox[{"deg", ",", "Perm"}], "]"}], ",", "notation"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"RandomPerm", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "RandomPerm", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"16004c2d-5395-416c-a733-4ac61784752f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPerm", "[", 
  RowBox[{"15", ",", "Rules"}], 
  "]"}]], "Input",ExpressionUUID->"d40b0267-4382-43c5-9005-06000c12bc1d"],

Cell[BoxData[
 RowBox[{"Rules", "[", 
  RowBox[{
   RowBox[{"13", "\[Rule]", "1"}], ",", 
   RowBox[{"1", "\[Rule]", "13"}], ",", 
   RowBox[{"7", "\[Rule]", "14"}], ",", 
   RowBox[{"14", "\[Rule]", "11"}], ",", 
   RowBox[{"11", "\[Rule]", "6"}], ",", 
   RowBox[{"6", "\[Rule]", "10"}], ",", 
   RowBox[{"10", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "9"}], ",", 
   RowBox[{"9", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "7"}], ",", 
   RowBox[{"12", "\[Rule]", "4"}], ",", 
   RowBox[{"4", "\[Rule]", "12"}], ",", 
   RowBox[{"8", "\[Rule]", "5"}], ",", 
   RowBox[{"5", "\[Rule]", "8"}]}], 
  "]"}]], "Output",ExpressionUUID->"f9a7f1e1-4981-4ac7-b101-a4a901be8d99"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPerm", "[", 
  RowBox[{"4", ",", 
   RowBox[{"{", 
    RowBox[{"Images", ",", "7"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"3451bdee-4134-4689-b74e-abe56b5fb0f1"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "1", ",", "2", ",", "3", ",", "5", ",", "6", ",", "7"}], 
   "}"}], "]"}]], \
"Output",ExpressionUUID->"b874564a-c8ad-425f-8254-9728939eff66"]
}, Open  ]],

Cell["\<\
With notations Rules and Cycles and degree 1 we can only get the identity:\
\>", "Text",ExpressionUUID->"d14ad7c6-7530-4622-b8c2-9c854cd1c4ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPerm", "[", 
  RowBox[{"0", ",", "Rules"}], 
  "]"}]], "Input",ExpressionUUID->"0c9c7259-bb31-4e2a-9b74-fc45d28e26a7"],

Cell[BoxData[
 RowBox[{"Rules", "[", 
  "]"}]], "Output",ExpressionUUID->"154f06d6-3588-4dfa-a940-8fc1cd824f89"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPerm", "[", 
  RowBox[{"1", ",", "Cycles"}], 
  "]"}]], "Input",ExpressionUUID->"6e12f3f1-19ea-4088-953c-05fed98672b3"],

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  "]"}]], "Output",ExpressionUUID->"f273f620-0aac-41da-8842-afc98b803b13"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.10. PermSignature", \
"Subsection",ExpressionUUID->"464667e8-159e-416f-bde5-81398a044c21"],

Cell["\<\
Signature of permutation. We consider the sign as a transposition more.\
\>", "Text",ExpressionUUID->"8791a5ad-1d38-4886-9f2b-625b8c45fc5d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermSignature", "[", 
    RowBox[{"Perm", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"Signature", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermSignature", "[", 
    RowBox[{"Images", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"Signature", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"signofcycle", "[", "cyc_List", "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", 
     RowBox[{"Length", "[", "cyc", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermSignature", "[", "perm_Cycles", "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Times", ",", 
     RowBox[{"signofcycle", "/@", "perm"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermSignature", "[", "perm_Rules", "]"}], ":=", 
   RowBox[{"PermSignature", "[", 
    RowBox[{"TranslatePerm", "[", 
     RowBox[{"perm", ",", "Cycles"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermSignature", "[", 
    RowBox[{"-", "perm_"}], "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{"PermSignature", "[", "perm", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermSignature", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PermSignature", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"719dcea2-a1b6-41e6-91f0-1b4dfd08f7a2"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3. Permutation Defs. Notation independent",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"ae32f315-bed8-4f45-b1e8-f6119daf0563"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", " ", "3."}], " ", 
   RowBox[{"Permutations", ".", " ", "Notation"}], " ", "independent"}], " ", 
  "*************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bf6c342e-b451-425f-8868-0fda8e5edb10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"b39ec165-a9db-4ed8-9da7-b260cb1239d7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.051291`", ",", "26.902454`7.881336890972312", ",", 
   "0.2621067471925821`"}], 
  "}"}]], "Output",ExpressionUUID->"e289318f-0d76-4a53-8b6d-fe186b0ccb7a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.0. Comments", \
"Subsection",ExpressionUUID->"f56aa761-a69e-4063-a9be-1da6a3be1aa2"],

Cell["\<\
This section defines all those actions on permutations whose structure is the \
same on different notations for the permutations.\
\>", "Text",ExpressionUUID->"1c308b91-5507-49f0-92b3-138a5c3c1dd0"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"$ReadingVerbose", ",", 
   RowBox[{
   "Print", "[", "\"\<Reading section 3: Permutations. Notation independent\>\
\"", "]"}], ",", "Null", ",", "Null"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"66a142d9-39bf-473d-b98c-c7b3861a718c"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1. Sorting with a base", \
"Subsection",ExpressionUUID->"08413ed6-23bd-4f1c-96e2-77fd0a103c67"],

Cell["\<\
Given a set of points \[CapitalOmega], we can define inequivalent ways to \
sort them. This is very important because permutations will be sorted \
according to the order of points. Different orderings will be given using \
\"bases\": ordered subsets of \[CapitalOmega].\
\>", "Text",ExpressionUUID->"13f1acc2-3c2d-4bba-a67a-86e62b8653ea"],

Cell["\<\
Note that we do not introduce a head Base because List is natural enough.\
\>", "Text",ExpressionUUID->"e070542f-795a-4ffc-a903-0d354bd9a79f"],

Cell["\<\
We define three different functions to work with orderings. They have \
independent codings, but they could be written in terms of just one of them:\
\>", "Text",ExpressionUUID->"0e7c4a33-9193-4ccf-ab15-f4b9d745f0c8"],

Cell["\<\
1) First we define the function that sorts elements according to a given \
ordered set B. Note that points not appearing in the B list are sorted last, \
and sorted according to Sort:\
\>", "Text",ExpressionUUID->"21e557e1-3ae6-49cc-81c9-036da0d326a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SortB"}]], "Input",ExpressionUUID->"774a5df0-6a36-4cbc-bc53-0be9641d8fff"],

Cell[BoxData[
 StyleBox["\<\"SortB[{e1, e2, ...}, B] sorts the elements ei according to the \
canonical order defined by list B. Elements not in B are sorted last, using \
Sort.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977973-5455693",ExpressionUUID->"3b377111-e051-4f88-ae01-\
1dee45cd2323"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SortB", "[", 
    RowBox[{"list_List", ",", "B_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DeleteCases", "[", 
     RowBox[{"B", ",", 
      RowBox[{"Alternatives", "@@", 
       RowBox[{"Complement", "[", 
        RowBox[{"B", ",", "list"}], "]"}]}]}], "]"}], "~", "Join", "~", 
    RowBox[{"Complement", "[", 
     RowBox[{"list", ",", "B"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortB", "[", 
    RowBox[{
     RowBox[{"list", ":", 
      RowBox[{"{", "_", "}"}]}], ",", "_"}], "]"}], ":=", "list"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortB", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "_"}], "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortB", "[", "list_List", "]"}], ":=", 
   RowBox[{"Sort", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"SortB", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "SortB", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"98fc104d-f13c-42c6-97dd-d72d6eb42233"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SortB", ",", "\[IndentingNewLine]", 
   RowBox[{"SortB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "5", ",", "1", ",", "6"}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"6efe5fc7-996f-4197-89d6-32ecc91a9315"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SortB", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"07cf860c-b5e1-4703-94bd-e7f99283d7a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SortB", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"d5c37641-9ccc-4994-b8fb-e55f50178833"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"SortB", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}], ",", 
        RowBox[{"Alternatives", "@@", 
         RowBox[{"Complement", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}]}], 
          "]"}]}]}], "]"}], ",", 
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}]}], "]"}],
    
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"Complement", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}]}], 
           "]"}],
          HoldForm], ",", 
         TagBox[
          RowBox[{"{", "3", "}"}],
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"Alternatives", "@@", 
         RowBox[{"{", "3", "}"}]}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"Alternatives", "[", "3", "]"}],
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}], ",", 
        RowBox[{"Alternatives", "[", "3", "]"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"4", ",", "2", ",", "5"}], "}"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"Complement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "6"}], "}"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "2", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "6"}], "}"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "5", ",", "1", ",", "6"}], "}"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"104edca9-396b-4c25-8621-042ec0484a99"]
}, Open  ]],

Cell["\<\
2) This rather efficient function finds the minimum of a list with respect to \
a base:\
\>", "Text",ExpressionUUID->"38a78a6c-b868-41db-bc23-22049bc5b869"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "MinB"}]], "Input",ExpressionUUID->"984eb3e7-8384-471b-8ecc-2c62eb83c1ef"],

Cell[BoxData[
 StyleBox["\<\"MinB[list, B] gives the mininum element of list with respect \
to base B. If none of the elements of B is in list then the minimum of list \
with respect to the canonical order is returned.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977974-5455693",ExpressionUUID->"cd0c3a10-4e18-4b06-9a0e-\
f089aac13f18"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MinB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"___", ",", "p_", ",", "___"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p_", ",", "___"}], "}"}]}], "]"}], ":=", "p"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MinB", "[", 
    RowBox[{"list_List", ",", 
     RowBox[{"{", 
      RowBox[{"_", ",", "x___"}], "}"}]}], "]"}], ":=", 
   RowBox[{"MinB", "[", 
    RowBox[{"list", ",", 
     RowBox[{"{", "x", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MinB", "[", 
    RowBox[{"list_List", ",", 
     RowBox[{"{", "}"}]}], "]"}], ":=", 
   RowBox[{"Min", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MinB", "[", "list_List", "]"}], ":=", 
   RowBox[{"Min", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"MinB", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "MinB", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"675d3eb8-4ec4-4391-898a-6598250f4980"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MinB", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"2c0f196d-3007-4dea-b558-12dc848e9897"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"MinB", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}],
    HoldForm], ",", 
   TagBox["4",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"67ef12b4-869a-4ea4-a82d-a3589ddb52a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"MinB", ",", "\[IndentingNewLine]", 
   RowBox[{"MinB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "4"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"aeb6d2a1-5b81-4887-9981-8e0c2c596d3b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"MinB", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6951cc07-e881-4ec8-85b4-9d94f354831e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MinB", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "7"}], "}"}]}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"e5911d70-feaa-4231-9881-72a6edc15894"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"MinB", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "7"}], "}"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"MinB", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
      RowBox[{"{", "7", "}"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"MinB", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Min", "[", 
     RowBox[{"{", 
      RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}],
    HoldForm], ",", 
   TagBox["1",
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"e37f2c52-1101-4f09-8e05-5d0005353d3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"MinB", ",", "\[IndentingNewLine]", 
   RowBox[{"MinB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "1"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"cd91d413-044e-42b1-8007-45a1e1003be3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"MinB", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"81aa0290-1f12-471e-98ef-cb65838a88f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SortB", ",", "\[IndentingNewLine]", 
   RowBox[{"SortB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "6"}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"4bd0a2f5-dd0b-4868-848e-a612763587ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SortB", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"dc5a8c55-e00b-4642-8224-d994aef1a272"]
}, Open  ]],

Cell["\<\
3) We assume that the base does not have repeated points. If one of the \
points is in the base but not the other, then the canonical order is having \
the former point first. If none of the points is in the base then we use \
normal lexicographical order. This function is private.\
\>", "Text",ExpressionUUID->"bdd9b0d1-abf1-4a79-b27f-0d758ae235e7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LessB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_", ",", "z__"}], "}"}], ",", "base_List"}], "]"}],
    ":=", 
   RowBox[{
    RowBox[{"LessB", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "base"}], "]"}], "&&", 
    RowBox[{"LessB", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", ",", "z"}], "}"}], ",", "base"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LessB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "x_"}], "}"}], ",", "_List"}], "]"}], ":=", 
   "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LessB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"___", ",", "x_", ",", "___", ",", "y_", ",", "___"}], "}"}]}], 
    "]"}], ":=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LessB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"___", ",", "y_", ",", "___", ",", "x_", ",", "___"}], "}"}]}], 
    "]"}], ":=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LessB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"___", ",", "x_", ",", "___"}], "}"}]}], "]"}], ":=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LessB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"_", ",", "x_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"___", ",", "x_", ",", "___"}], "}"}]}], "]"}], ":=", "False"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LessB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}], ",", "_List"}], "]"}], ":=", 
   RowBox[{"Less", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"4a78b322-761a-4a4c-b5db-ded932ef004a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"LessB", ",", "\[IndentingNewLine]", 
   RowBox[{"LessB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"4e86a3e1-1e6e-45e6-a127-7a4622d2b9f5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"LessB", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6673c84f-350e-43cd-88de-796bb56075dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"LessB", ",", "\[IndentingNewLine]", 
   RowBox[{"LessB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"2441c262-67ba-48ee-a23f-f2d419d65a55"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"LessB", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"98296ee5-064a-4b9f-8e17-949aa8c404c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Less", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"08fadd4a-3412-4ee1-b933-f790a0e1a697"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"33b40273-c477-46de-b692-6773e082aef0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SortB", ",", "\[IndentingNewLine]", 
   RowBox[{"SortB", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "3", ",", "5"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "1"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"bcebf1b4-6b29-474c-814b-327882cedc8a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SortB", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"c022b8b7-dd0f-468c-93f1-8360bf561002"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. Sorting permutations. PermOrderedQ, PermSort", \
"Subsection",ExpressionUUID->"3f506a37-6e12-41bd-856f-435f080585a1"],

Cell[CellGroupData[{

Cell["3.2.0. Comments", \
"Subsubsection",ExpressionUUID->"f9af72e0-df25-49ba-a66d-e5e32381bb1b"],

Cell["\<\
There are two main ways of sorting permutations: using images of points or \
using the Perm notation. It turns out that using the former for a set of \
permutations is equivalent to using the latter for the set of inverses. \
PermOrderedQ returns Null when both permutations are equal (that is, they \
give same images for same points; this differs from the usual behaviour of \
OrderedQ).\
\>", "Text",ExpressionUUID->"f3c67918-88c0-47a1-bcb9-98e26199d8d9"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2.1. PermOrderedQ and PermSort", \
"Subsubsection",ExpressionUUID->"e2cd9223-37f2-4c4a-8182-7975abeefedb"],

Cell["\<\
Note that a linear combination of permutations would give errors because \
OnPoints is not defined on linear combinations. In PermOrderedQ head is \
needed but irrelevant. This definition means that we are sorting according to \
Images, and not Perm.\
\>", "Text",ExpressionUUID->"387239e0-151d-49f6-bd9c-04f696670091"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermOrderedQ"}]], \
"Input",ExpressionUUID->"bbe3d836-6905-4a84-bfd4-9564fe6dd132"],

Cell[BoxData[
 StyleBox["\<\"PermOrderedQ[h[perm1, perm2]] gives True if perm1 maps \
integers to smaller points than perm2. It gives False if perm1 maps integers \
to larger points than perm2. It gives Null if perm1 and perm2 maps integers \
to the same points. PermOrderedQ[h[perm1, perm2], B] gives True if perm1 maps \
the points of base B to smaller (according to B) images than perm2. It gives \
False if perm1 maps the points of B to larger (according to B) images than \
perm2. It gives Null if perm1 and perm2 map the points of B to the same \
images.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977975-5455693",ExpressionUUID->"709fe3f0-df3a-4dc4-9c2f-\
a22b4e702936"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermOrderedQ", "[", 
    RowBox[{"head_", "[", 
     RowBox[{
      RowBox[{"perm1_", "/;", 
       RowBox[{
        RowBox[{"Head", "[", "perm1", "]"}], "=!=", "Times"}]}], ",", 
      RowBox[{"-", "perm2_"}]}], "]"}], "]"}], ":=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermOrderedQ", "[", 
    RowBox[{"head_", "[", 
     RowBox[{
      RowBox[{"-", "perm1_"}], ",", 
      RowBox[{"perm2_", "/;", 
       RowBox[{
        RowBox[{"Head", "[", "perm2", "]"}], "=!=", "Times"}]}]}], "]"}], 
    "]"}], ":=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermOrderedQ", "[", 
    RowBox[{"head_", "[", 
     RowBox[{
      RowBox[{"-", "perm1_"}], ",", 
      RowBox[{"-", "perm2_"}]}], "]"}], "]"}], ":=", 
   RowBox[{"PermOrderedQ", "[", 
    RowBox[{"head", "[", 
     RowBox[{"perm1", ",", "perm2"}], "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"4a1b5eb9-78bc-4a36-9247-2caa7a2ec754"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermOrderedQ", "[", 
    RowBox[{"head_", "[", 
     RowBox[{"perm1_", ",", "perm2_"}], "]"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"len", "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"PermLength", "@", "perm1"}], ",", 
          RowBox[{"PermLength", "@", "perm2"}]}], "]"}]}], ",", "i", ",", 
       "p1", ",", "p2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", "len"}], ",", 
        RowBox[{"++", "i"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"p1", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{"i", ",", "perm1"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"p2", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{"i", ",", "perm2"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Which", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"p1", "<", "p2"}], ",", 
           RowBox[{"Return", "[", "True", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"p1", ">", "p2"}], ",", 
           RowBox[{"Return", "[", "False", "]"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "Null"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3f1a545a-a8fa-4129-bd2a-a196d5acf064"],

Cell["We define a new function that depends on a base of points.", \
"Text",ExpressionUUID->"5af68a23-d2a3-4886-97e6-c54f15b2ceff"],

Cell["\<\
This is the definition given by Renato for two different permutations. It is \
not equivalent to my definition below:\
\>", "Text",ExpressionUUID->"9cc9cf46-8425-46f7-a5f5-60cd95954fd2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermOrderedQ", "[", 
    RowBox[{
     RowBox[{"head_", "[", 
      RowBox[{"perm1_", ",", "perm2_"}], "]"}], ",", "base_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"deg", "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"PermDeg", "@", "perm1"}], ",", 
          RowBox[{"PermDeg", "@", "perm2"}]}], "]"}]}], ",", "i", ",", "p1", ",",
        "p2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", 
         RowBox[{"Length", "[", "base", "]"}]}], ",", 
        RowBox[{"++", "i"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"p1", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{
            RowBox[{"base", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "perm1"}], "]"}]}], ";", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"base", ",", "p1"}], "]"}], ",", 
           RowBox[{"p1", "=", 
            RowBox[{"p1", "+", "deg"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"p2", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{
            RowBox[{"base", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "perm2"}], "]"}]}], ";", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"base", ",", "p2"}], "]"}], ",", 
           RowBox[{"p2", "=", 
            RowBox[{"p2", "+", "deg"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Which", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"p1", "<", "p2"}], ",", 
           RowBox[{"Return", "[", "True", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"p1", ">", "p2"}], ",", 
           RowBox[{"Return", "[", "False", "]"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "Null"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"89d0a264-aaaf-4cbf-b359-bd60c6f544ab"],

Cell["\<\
(The addition of n is equivalent to our completion of the base.) The \
essential difference is that we use LessB comparisons and not the usual Less \
comparison.\
\>", "Text",ExpressionUUID->"22fc5e74-6326-4b8f-aa1d-2710f2b62384"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PermOrderedQ", "[", 
    RowBox[{
     RowBox[{"head_", "[", 
      RowBox[{"perm1_", ",", "perm2_"}], "]"}], ",", "base_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"len", "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"PermLength", "@", "perm1"}], ",", 
          RowBox[{"PermLength", "@", "perm2"}]}], "]"}]}], ",", "i", ",", "b",
        ",", "p1", ",", "p2", ",", "base2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"base2", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"base", ",", 
         RowBox[{"Complement", "[", 
          RowBox[{
           RowBox[{"Range", "[", "len", "]"}], ",", "base"}], "]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", "len"}], ",", 
        RowBox[{"++", "i"}], ",", 
        RowBox[{
         RowBox[{"b", "=", 
          RowBox[{"base2", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"p1", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{"b", ",", "perm1"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"p2", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{"b", ",", "perm2"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Which", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"LessB", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"p1", ",", "p2"}], "}"}], ",", "base"}], "]"}], ",", 
           RowBox[{"Return", "[", "True", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"LessB", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"p2", ",", "p1"}], "}"}], ",", "base"}], "]"}], ",", 
           RowBox[{"Return", "[", "False", "]"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "Null"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c34713e6-4ca7-4b72-bfc5-c0dc6ba7b556"],

Cell["Corresponding Sort function:", \
"Text",ExpressionUUID->"8fafe66a-50f7-4eb2-8c87-dbcedb1d62e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermSort", "[", 
    RowBox[{"head_", "[", "perms___", "]"}], "]"}], ":=", 
   RowBox[{"head", "@@", 
    RowBox[{"Sort", "[", 
     RowBox[{
      RowBox[{"{", "perms", "}"}], ",", 
      RowBox[{
       RowBox[{"PermOrderedQ", "[", 
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2"}], "}"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
"\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermSort", "[", 
    RowBox[{
     RowBox[{"head_", "[", "perms___", "]"}], ",", "base_List"}], "]"}], ":=", 
   RowBox[{"head", "@@", 
    RowBox[{"Sort", "[", 
     RowBox[{
      RowBox[{"{", "perms", "}"}], ",", 
      RowBox[{
       RowBox[{"PermOrderedQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#1", ",", "#2"}], "}"}], ",", "base"}], "]"}], "&"}]}], 
     "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e7197a17-9af5-4807-9592-bbe7cff5a8ce"],

Cell["Protection:", \
"Text",ExpressionUUID->"ca3bc25b-0397-4a3e-bbad-a10ce9693401"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermOrderedQ", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermSort", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"PermOrderedQ", ",", "PermSort"}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a9d30435-c4b0-4dbd-bf31-5f68019fcf59"],

Cell["These permutations are not sorted lexicographically:", \
"Text",ExpressionUUID->"9a688228-b40b-416f-9ee6-70a8afbca258"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"6df271a5-36df-4a9e-8098-98d1edb40f60"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"2e68ae76-32ae-4e34-add8-3cc1bd6f8d03"]
}, Open  ]],

Cell["\<\
but are sorted in such a way that their inverses are in lexicographical order:\
\>", "Text",ExpressionUUID->"aa990a54-5fba-4fbf-a6cf-1f1a08e7d722"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InversePerm", "/@", 
  "%"}]], "Input",ExpressionUUID->"d06ef2ae-442e-49d3-bdca-c828996eb076"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"6c8a89b3-aedc-432c-83c0-826c02e86522"]
}, Open  ]],

Cell["The problem is in these two permutations:", \
"Text",ExpressionUUID->"4034b702-47d7-495c-8bc7-e2e06fb2d0a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3bc51815-fb47-441b-ab79-db87a17cde85"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "17", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"22278a73-1b9a-40d9-97e2-8a2449ffb142"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"9c662b60-7397-4659-8ba4-b0e4e26597a9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "18", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"aae083b9-79a8-4690-a02d-f49df6373101"]
}, Open  ]],

Cell["\<\
Sorting the identity. Different forms of the identity are not sorted in a \
unique way. Compare the relative positions of Cycles[] and Perm[{}] in these \
two lists:\
\>", "Text",ExpressionUUID->"caab7459-531b-460e-b1c1-31a3d135cc5a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}], ",", "ID", ",", 
    RowBox[{"Cycles", "[", "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", "}"}], "]"}], ",", "ID"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"9fb02cab-f1d0-417f-bd15-4e065680cd11"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ID", ",", 
   RowBox[{"Cycles", "[", "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", "}"}], "]"}], ",", "ID", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"61110980-068c-4e1a-9f53-4663326a44f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}], ",", "ID", ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", "}"}], "]"}], ",", 
    RowBox[{"Cycles", "[", "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", "}"}], "]"}], ",", "ID"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"5bf46520-bf95-49d9-822f-98423f9a5cec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ID", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", "}"}], "]"}], ",", "ID", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"2d529676-224a-4b70-bf9c-45028f901f82"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.2.2. PermEqual, PermLess, PermGreater, PermLessEqual, PermGreaterEqual\
\>", "Subsubsection",ExpressionUUID->"c388bfaa-d51f-47ce-accd-50fdb845e0d2"],

Cell["We generalize comparatives (not for B-sorting):", \
"Text",ExpressionUUID->"49ebf631-8ab3-4c25-8a28-6ef5d2326e36"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermEqual", "[", "perms__", "]"}], ":=", 
   RowBox[{"And", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "===", "Null"}], "&"}], "/@", 
      RowBox[{"PermOrderedQ", "/@", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"{", "perms", "}"}], ",", "2", ",", "1"}], "]"}]}]}], 
     ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PermLessEqual", "[", "perms__", "]"}], ":=", 
   RowBox[{
    RowBox[{"{", "perms", "}"}], "===", 
    RowBox[{"PermSort", "[", 
     RowBox[{"{", "perms", "}"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PermGreaterEqual", "[", "perms__", "]"}], ":=", 
   RowBox[{"PermLessEqual", "@@", 
    RowBox[{"Reverse", "[", 
     RowBox[{"{", "perms", "}"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PermLess", "[", "perms__", "]"}], ":=", 
   RowBox[{"And", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"PermOrderedQ", "/@", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"{", "perms", "}"}], ",", "2", ",", "1"}], "]"}]}], "/.", 
      RowBox[{"Null", "\[Rule]", "False"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PermGreater", "[", "perms__", "]"}], ":=", 
   RowBox[{"PermLess", "@@", 
    RowBox[{"Reverse", "[", 
     RowBox[{"{", "perms", "}"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{
   "PermEqual", ",", "PermLess", ",", "PermGreater", ",", "PermLessEqual", ",",
     "PermGreaterEqual"}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"529dc258-e2da-4fde-a500-ddace4fdd653"],

Cell["Examples:", \
"Text",ExpressionUUID->"6eb6f45f-28d6-4228-b0f5-379188dcc8ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermEqual", ",", "\[IndentingNewLine]", 
   RowBox[{"PermEqual", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"10d305a5-8e1c-401d-9b15-da3dbb2a1a9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermEqual", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d34827f6-879a-4e1a-a9bb-4bd5f4023bc3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermEqual", ",", "\[IndentingNewLine]", 
   RowBox[{"PermEqual", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "]"}], ",", "ID"}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"288dc68a-6ab8-41ac-bd63-704208babcb5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermEqual", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"fdfb8ca0-024d-49dc-86e5-bdc1e3076d0f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermEqual", ",", "\[IndentingNewLine]", 
   RowBox[{"PermEqual", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"4555bf74-1b70-4963-9b6b-b488d721732d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermEqual", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"493da4ec-a42f-40e6-89ad-f8f12bff7727"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermEqual", ",", "\[IndentingNewLine]", 
   RowBox[{"PermEqual", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"5e310bf7-d347-4b1c-b88e-a3b7d18a7208"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermEqual", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"cb4ce867-a3f6-4a71-9d34-976caf0ea452"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermEqual", ",", "\[IndentingNewLine]", 
   RowBox[{"PermLess", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"b5ce3162-0a6a-4c25-8d99-86e92a0bcf44"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermEqual", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"323bc4dc-6e3e-40b6-a125-dd3f26c6da50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermEqual", ",", "\[IndentingNewLine]", 
   RowBox[{"PermLessEqual", "[", 
    RowBox[{"ID", ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"1cb5ec28-7f9d-43a5-8a64-42fe783075f9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermEqual", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"b9a8b45c-f728-4109-bc7f-f8b1d65d1c55"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermEqual", ",", "\[IndentingNewLine]", 
   RowBox[{"PermLess", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"358ea64c-70af-4656-b95d-71b836449267"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermEqual", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6f8f67b2-74f3-4297-bd52-96f6dd5dc85d"]
}, Open  ]],

Cell["\<\
Examples in GAP Reference, chapter 40 (the first should give True and the \
second False):\
\>", "Text",ExpressionUUID->"f3c39f7d-5844-4413-a455-1566e34ba861"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermEqual", ",", "\[IndentingNewLine]", 
   RowBox[{"PermLess", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"aff4f92c-4c55-49e4-886c-197e283ad69c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermEqual", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"222215c3-fd64-429e-a8ae-c4297cfc83b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermEqual", ",", "\[IndentingNewLine]", 
   RowBox[{"PermLess", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}]}], "]"}], ",",
    "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"9d49dc22-ca35-4484-81dd-85ebfcb1e2bf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermEqual", ",", "9", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"81fc2816-76d6-44d2-8a0b-ba4e30d1153f"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. Set of generators. GenSet", \
"Subsection",ExpressionUUID->"202e42ef-9e67-4ff3-bc2c-4dc52d10288c"],

Cell["\<\
Generator sets will be given as lists of permutations, with flat head GenSet. \
By convention we assume that we will never have the identity on a generator \
set, but we do not check that.\
\>", "Text",ExpressionUUID->"f10a0e0f-8bfb-4674-a78f-46050a5d0ccb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "GenSet"}]], "Input",ExpressionUUID->"eb0071fe-3273-4d5d-8835-d157afbb3f35"],

Cell[BoxData[
 StyleBox["\<\"GenSet is the head for a generating set.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977976-5455693",ExpressionUUID->"7092380f-d9e1-46de-9ec8-\
298dcdd2772c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenSet", "[", 
    RowBox[{"x___", ",", 
     RowBox[{"GenSet", "[", "y___", "]"}], ",", "z___"}], "]"}], ":=", 
   RowBox[{"GenSet", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e7d9921f-1e62-4f0d-a671-eb945662c332"],

Cell["\<\
GenSet extracts the generating set from a strong generating set:\
\>", "Text",ExpressionUUID->"3fe87873-8bba-4efd-bf23-a720532fceac"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenSet", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{"_", ",", "GS_GenSet"}], "]"}], "]"}], ":=", "GS"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2480e37d-4b84-473b-83f4-b2d744a61d60"],

Cell["Special cases:", \
"Text",ExpressionUUID->"c575b5ee-31d5-4582-8a68-faaad73160c9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Symmetric", "|", "Antisymmetric"}], ")"}], "[", 
     RowBox[{
      RowBox[{"{", "}"}], "|", 
      RowBox[{"{", "_", "}"}]}], "]"}], "]"}], ":=", 
   RowBox[{"GenSet", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GenSet", "[", 
    RowBox[{"Symmetric", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"DeleteDuplicates", "@", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Cycles", "[", 
       RowBox[{"list", "[", 
        RowBox[{"[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"Cycles", "[", "list", "]"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GenSet", "[", 
    RowBox[{"Antisymmetric", "[", "list_List", "]"}], "]"}], ":=", 
   RowBox[{"DeleteDuplicates", "@", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"list", "[", 
         RowBox[{"[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"Length", "[", "list", "]"}]}]}], 
       RowBox[{"Cycles", "[", "list", "]"}]}]}], "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8b9833de-053b-45bc-9092-858f7d486fa3"],

Cell["\<\
Empty generating sets represents the group Group[ ID ] and therefore it is \
reasonable to assign them degree 0:\
\>", "Text",ExpressionUUID->"a98fa113-5212-4f95-9e42-f2c3ec99c72b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "[", 
  RowBox[{"GenSet", "[", "]"}], 
  "]"}]], "Input",ExpressionUUID->"5eedd79c-0ed3-4442-a1a0-b036acc3163f"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"a477674a-703a-44af-9838-3efb8b7cb9bc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "GenSet", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"acd93e78-0602-4636-8b2b-ae94d4d6103f"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4. Powers. PermPower", \
"Subsection",ExpressionUUID->"08de288e-0952-41b2-b8fc-360b1775d876"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermPower"}]], \
"Input",ExpressionUUID->"21104fd8-b7da-4b0a-868b-b1b06627f7da"],

Cell[BoxData[
 StyleBox["\<\"PermPower[perm, n] for positive n gives the composition of n \
copies of perm. For negative n it gives the composition of n copies of \
InversePerm[perm]. For zero n it gives ID[perm].\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977977-5455693",ExpressionUUID->"1ba7b3a9-b918-43f9-8d66-\
9a0bcb401a82"]
}, Open  ]],

Cell["\<\
For powers of index larger than 10 we switch to a recursive algorithm, far \
more efficient than a simple listing of permutations:\
\>", "Text",ExpressionUUID->"5e5a49f7-1d4a-4e0f-9814-203e0ec333cf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermPower", "[", 
    RowBox[{"perm_", ",", "0"}], "]"}], ":=", 
   RowBox[{"ID", "[", "perm", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermPower", "[", 
    RowBox[{"perm_", ",", "1"}], "]"}], ":=", "perm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermPower", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"n_Integer", "?", "Negative"}]}], "]"}], ":=", 
   RowBox[{"PermPower", "[", 
    RowBox[{
     RowBox[{"InversePerm", "[", "perm", "]"}], ",", 
     RowBox[{"-", "n"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermPower", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"n_Integer", "?", "Positive"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"PermProduct", "@@", 
     RowBox[{"Table", "[", 
      RowBox[{"perm", ",", 
       RowBox[{"{", "n", "}"}]}], "]"}]}], "/;", 
    RowBox[{"n", "<", "10"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermPower", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"n_Integer", "?", "Positive"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", "=", 
       RowBox[{"IntegerPart", "[", 
        RowBox[{"n", "/", "2"}], "]"}]}], "}"}], ",", 
     RowBox[{"PermProduct", "[", 
      RowBox[{
       RowBox[{"PermPower", "[", 
        RowBox[{"perm", ",", "m"}], "]"}], ",", 
       RowBox[{"PermPower", "[", 
        RowBox[{"perm", ",", 
         RowBox[{"n", "-", "m"}]}], "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermPower", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"n_Integer", "?", "Positive"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pp", ",", "p"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"pp", "[", 
        RowBox[{"p_", ",", "0"}], "]"}], ":=", 
       RowBox[{"IP", "[", "p", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"pp", "[", 
        RowBox[{"p_", ",", "1"}], "]"}], ":=", "p"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"pp", "[", 
        RowBox[{"p_", ",", "k_"}], "]"}], ":=", 
       RowBox[{
        RowBox[{"pp", "[", 
         RowBox[{"p", ",", "k"}], "]"}], "=", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"m", "=", 
            RowBox[{"IntegerPart", "[", 
             RowBox[{"k", "/", "2"}], "]"}]}], "}"}], ",", 
          RowBox[{"PermProduct", "[", 
           RowBox[{
            RowBox[{"pp", "[", 
             RowBox[{"p", ",", "m"}], "]"}], ",", 
            RowBox[{"pp", "[", 
             RowBox[{"p", ",", 
              RowBox[{"k", "-", "m"}]}], "]"}]}], "]"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pp", "[", 
       RowBox[{"perm", ",", "n"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermPower", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PermPower", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"70b98123-fe37-495a-841c-5b639891c654"],

Cell["Examples:", \
"Text",ExpressionUUID->"57d92ec8-0ca4-4dcb-ac3f-e89ddd47dcbe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermPower", ",", "\[IndentingNewLine]", 
   RowBox[{"PermPower", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", "}"}], "]"}], ",", "7"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", "}"}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7f3e7b0e-ef9d-40e1-a3f6-6ded14710f02"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermPower", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"7c1056e1-9910-48a5-8334-f5f648b861ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermPower", ",", "\[IndentingNewLine]", 
   RowBox[{"PermPower", "[", 
    RowBox[{"ID", ",", "7"}], "]"}], ",", "\[IndentingNewLine]", "ID"}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"75a10e2d-f37f-484f-ac58-b531ec8a89d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermPower", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4f9ec419-806b-4341-84af-a5a1896a629f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"perm", "=", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"ff83a4af-9237-4adf-9b2a-9e287685fa38"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermPower", ",", "\[IndentingNewLine]", 
   RowBox[{"PermPower", "[", 
    RowBox[{"perm", ",", "0"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"74291052-9e9a-46ce-afb1-fc0d9ece3659"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermPower", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"61cdfde0-70b7-4248-a139-c616fcb81b6a"]
}, Open  ]],

Cell["This is a permutation of order 4:", \
"Text",ExpressionUUID->"72c17019-9a11-48df-aada-f90833de28e3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"PermPower", "[", 
   RowBox[{"perm", ",", "4"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"f8b7d71a-fb82-4c2f-8ad2-2df927abaf46"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00006999999999999999386775251242198692`1.8656979532938807", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"ee407b6a-a3dc-47d5-a90a-57d4973130db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"PermPower", "[", 
   RowBox[{"perm", ",", "40"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"5ce11ef6-1feb-4265-b1d5-e90b69a2d872"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0002680000000000000090483176506950258`2.4487347073084127", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"a83f2011-9355-448c-9f6d-ab083ee7de42"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"PermPower", "[", 
   RowBox[{"perm", ",", "4000"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"6a4bf3e0-151b-4792-9241-69718e425c00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.00059800000000000000724420523567914643`2.797301097268035", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"8bf394aa-2250-4da7-980a-7ce252130a47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"PermPower", "[", 
   RowBox[{"perm", ",", "4000000"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"2041d689-9b63-41e2-bbfa-0b82ef6d7bbd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00103499999999999989577781356331342977`3.0355402630725608", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"cdd33a3f-c7dd-4599-beb5-68af2e2090a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"PermPower", "[", 
   RowBox[{"perm", ",", "4567891"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"cf58e291-668f-448b-b5ae-6c3715940d48"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00118200000000000010787204463014177236`3.0932173898248605", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"6e2bec91-4dba-4607-a67e-c7b5481ff04b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{"PermPower", "[", 
   RowBox[{"perm", ",", 
    RowBox[{"-", "4567891"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"d8bb55af-306d-4140-867f-bdc81668a816"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.00113499999999999994122756863390577564`3.075595774808766", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"da785c97-e2ec-4828-9e27-94c48037cc01"]
}, Open  ]],

Cell["The growth is clearly not linear!", \
"Text",ExpressionUUID->"9318760f-063b-4f70-83b9-26dece21decb"],

Cell["Note that for negative n InversePerm is used  just once.", \
"Text",ExpressionUUID->"4772976a-b6aa-4508-a1e1-fddea8cfa040"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.5. Dimino algorithm. Dimino, Group", \
"Subsection",ExpressionUUID->"3db652a8-a606-4c6c-b1e4-099d74020cd0"],

Cell["\<\
And finally, this the simple Dimino algorithm to generate a group by \
generators. MakeGroup enlarges subgroup (assumed to be generated by all but \
the last generators in GS; not checked) to the group generated by all \
generators in GS. Note that we use MemberQ and FreeQ to test for membership \
of permutations; that is only valid for {Perm,length} and {Images,length} \
notations and hence we have to change to Perm notation initially.\
\>", "Text",ExpressionUUID->"0979e104-a0b4-4a0f-95cb-b3c20241a55a"],

Cell["This is algorithm 3.4 of Butler.", \
"Text",ExpressionUUID->"239aa264-a7e3-443a-92a9-3ee236fa5c50"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"cyclicGroup", "[", "perm_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"id", "=", 
       RowBox[{"ID", "[", "perm", "]"}]}], "}"}], ",", 
     RowBox[{"Group", "@@", 
      RowBox[{"RotateRight", "[", 
       RowBox[{"NestWhileList", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PermProduct", "[", 
           RowBox[{"#", ",", "perm"}], "]"}], "&"}], ",", "perm", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"#", "=!=", "id"}], ")"}], "&"}]}], "]"}], "]"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RightCoset", "[", 
    RowBox[{"subgroup_Group", ",", "perm_"}], "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"PermProduct", "[", 
       RowBox[{"#", ",", "perm"}], "]"}], "&"}], ",", "subgroup"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeGroup", "[", 
    RowBox[{"H_Group", ",", "gs_GenSet"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{"H", ",", 
       RowBox[{"Last", "[", "gs", "]"}]}], "]"}], ",", "H", ",", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ordH", "=", 
          RowBox[{"Length", "[", "H", "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"elts", "=", 
          RowBox[{"H", "~", "Join", "~", 
           RowBox[{"RightCoset", "[", 
            RowBox[{"H", ",", 
             RowBox[{"Last", "[", "gs", "]"}]}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ncoset", "=", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ordH", " ", "ncoset"}], "\[LessEqual]", 
           RowBox[{"Length", "[", "elts", "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"FreeQ", "[", 
                 RowBox[{"elts", ",", "#"}], "]"}], ",", 
                RowBox[{"elts", "=", 
                 RowBox[{"elts", "~", "Join", "~", 
                  RowBox[{"RightCoset", "[", 
                   RowBox[{"H", ",", "#"}], "]"}]}]}]}], "]"}], "&"}], ",", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"PermProduct", "[", 
                 RowBox[{
                  RowBox[{"elts", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"ordH", " ", 
                    RowBox[{"(", 
                    RowBox[{"ncoset", "-", "1"}], ")"}]}], "+", "1"}], "]"}], 
                   "]"}], ",", "#"}], "]"}], "&"}], ",", "gs"}], "]"}]}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"++", "ncoset"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "elts"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"7c8d93eb-986b-4842-bc4c-74ca84119bc9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Dimino"}]], "Input",ExpressionUUID->"86971e39-96bb-45d6-8fe7-964a50a6b8ac"],

Cell[BoxData[
 StyleBox["\<\"Dimino[GenSet[perm1, ...]] gives the group generated by \
permutations permi, using Dimino's algorithm.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977978-5455693",ExpressionUUID->"288dd8af-8df1-4d28-b89a-\
168d993528cc"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Dimino", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{"base_", ",", "GS_GenSet"}], "]"}], "]"}], ":=", 
   RowBox[{"Dimino", "[", "GS", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dimino", "[", "GS_GenSet", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"GSPerm", "=", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{"GS", ",", 
         RowBox[{"{", 
          RowBox[{"Perm", ",", 
           RowBox[{"PermDeg", "[", "GS", "]"}]}], "}"}]}], "]"}]}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"TranslatePerm", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Fold", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"MakeGroup", "[", 
           RowBox[{"#1", ",", "#2"}], "]"}], "&"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"cyclicGroup", "[", 
          RowBox[{"First", "[", "GSPerm", "]"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Rest", "[", 
          RowBox[{"FoldList", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Append", "[", 
              RowBox[{"#1", ",", "#2"}], "]"}], "&"}], ",", 
            RowBox[{"GenSet", "[", 
             RowBox[{"First", "[", "GSPerm", "]"}], "]"}], ",", 
            RowBox[{"List", "@@", 
             RowBox[{"Rest", "[", "GSPerm", "]"}]}]}], "]"}], "]"}]}], 
        "\[IndentingNewLine]", "]"}], ",", 
       RowBox[{"NotationOfPerm", "[", "GS", "]"}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", "]"}], "]"}], ":=", 
   RowBox[{"Group", "[", "ID", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"bab351ce-139f-482e-a175-bccbb29646f3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Dimino", "[", 
    RowBox[{"Symmetric", "[", "list_", "]"}], "]"}], ":=", 
   RowBox[{"Group", "@@", 
    RowBox[{"(", 
     RowBox[{"Images", "/@", 
      RowBox[{"Permutations", "[", "list", "]"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dimino", "[", 
    RowBox[{"Antisymmetric", "[", "list_", "]"}], "]"}], ":=", 
   RowBox[{"Group", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Signature", "[", "#", "]"}], 
         RowBox[{"Images", "[", "#", "]"}]}], ")"}], "&"}], "/@", 
      RowBox[{"Permutations", "[", "list", "]"}]}], ")"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e06cfe47-511c-40a4-9643-0b2a1edba6d3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Dimino", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"Dimino", ",", "Group"}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e72639ce-d41e-4315-a154-1c92477543f3"],

Cell["Examples:", \
"Text",ExpressionUUID->"d3e6bfac-1aa8-4bd8-b431-a17e7cc27f42"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Dimino", ",", "\[IndentingNewLine]", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], "]"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Group", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"275ffef4-4819-432e-9cd9-65df7c0ab09b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Dimino", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"cfc87fcc-c184-44f8-82bb-9d4a3c5262ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Dimino", ",", "\[IndentingNewLine]", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Group", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}]}], 
    "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"d20f62fd-464c-4813-a26b-41d45be9aceb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Dimino", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"2a5c0954-658d-4982-9d81-e267b2220a01"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Dimino", ",", "\[IndentingNewLine]", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], "]"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Group", "[", 
    RowBox[{
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7ebe9952-9e50-4b21-a9d9-9ee3d2987d8e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Dimino", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"7412902b-3da0-4c94-9c81-a1dc4b13cce4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Dimino", ",", "\[IndentingNewLine]", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"4", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Group", "[", 
    RowBox[{
     RowBox[{"Rules", "[", "]"}], ",", 
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"4", "\[Rule]", "1"}], ",", 
       RowBox[{"1", "\[Rule]", "2"}]}], "]"}], ",", 
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "1"}], ",", 
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"4", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "4"}]}], "]"}], ",", 
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"4", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "1"}], ",", 
       RowBox[{"1", "\[Rule]", "4"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"3d1cbea8-1cab-4f5c-b970-851fbedaf098"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Dimino", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"65ad93c8-811f-4fdb-abcb-537396e2370f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimino", "[", 
  RowBox[{"GenSet", "[", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"057aab0d-3768-4058-a16b-bcdf75963069"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"b63fc80c-3b47-4c28-8090-b433d196b74b"]
}, Open  ]],

Cell["\<\
Permutations in Cycles notation are not being returned sorted. Can we avoid \
that?\
\>", "Text",ExpressionUUID->"11730b2a-a787-456a-a21a-71be486d2c7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{"Dimino", "[", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], 
     "]"}], "]"}], "===", 
   RowBox[{"Group", "@@", 
    RowBox[{"Sort", "[", 
     RowBox[{"Perm", "/@", 
      RowBox[{"Permutations", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
     "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"abb553ca-b8b8-4c7d-92a6-7fc97cbf8423"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00118599999999999998825939151458896959`3.094684602307868", ",", "True"}],
   "}"}]], "Output",ExpressionUUID->"977f2951-64a8-43b0-83c2-68a9ff9faddc"]
}, Open  ]],

Cell["Recall that", \
"Text",ExpressionUUID->"868fd04a-7771-498e-94d8-c51217a697f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"5", "!"}], ",", 
   RowBox[{"6", "!"}], ",", 
   RowBox[{"7", "!"}]}], 
  "}"}]], "Input",ExpressionUUID->"5dcdb4a1-b9c9-4721-b974-76835ba1955e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"120", ",", "720", ",", "5040"}], 
  "}"}]], "Output",ExpressionUUID->"207ddc7e-99a4-4638-8813-c5f257405ad4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "@", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}],
      "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"f7778ec7-4f0f-4660-8355-4faf7727054d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00673499999999999966748820412476561614`3.8489375133386283", ",", "120"}],
   "}"}]], "Output",ExpressionUUID->"3aca17eb-95be-46c4-99fe-dfeafdeb5119"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "@", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"6", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5"}], 
        "}"}], "]"}], ",", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "6"}], 
        "}"}], "]"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"43c21dc0-ad93-41e5-a6c7-156f2074a925"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.12335999999999999743316436706663807854`5.111774273986505", ",", "720"}], 
  "}"}]], "Output",ExpressionUUID->"7297fa97-b0e8-4b83-9c1a-4338a45aaca9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "@", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{
        "7", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
        "}"}], "]"}], ",", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "]"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"dcb4d8ca-d182-42d8-abee-49ef9b9be2f4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.26540900000000000602540239924564957619`6.742032024706959", ",", "5040"}],
   "}"}]], "Output",ExpressionUUID->"45ed34c2-876b-42cd-8137-0bb45ba7bb21"]
}, Open  ]],

Cell["This is quite slow now... Compare with", \
"Text",ExpressionUUID->"c1e84dc5-9c6e-4e5f-8149-c0eaf4ca9748"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "@", 
   RowBox[{"Permutations", "[", 
    RowBox[{"Range", "[", "7", "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"b001787e-7326-4c20-8ba8-c2cebada0587"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00019599999999999999367172875963660772`2.3128559846361", ",", "5040"}], 
  "}"}]], "Output",ExpressionUUID->"8e315f92-ccce-439c-adf1-089bc83c2a53"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.6. Stabilization I", \
"Subsection",ExpressionUUID->"fb411a76-5a8f-4c0b-9ee2-b6642028d5ce"],

Cell[CellGroupData[{

Cell["3.6.1. StablePoints", \
"Subsubsection",ExpressionUUID->"0cc673f9-c891-4943-b275-d5b8022a3077"],

Cell["\<\
This function gives the points between 1 and n which remain at place under \
the permutation p, or under a generating set of permutations\
\>", "Text",ExpressionUUID->"f1277da5-147d-43b2-9c36-e3950eacc5ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "StablePoints"}]], \
"Input",ExpressionUUID->"41b5aa2d-24c0-4995-8ea9-6a9665eed049"],

Cell[BoxData[
 StyleBox["\<\"StablePoints[perm, n] gives the points in {1, ..., n} that are \
fixed by permutation perm. StablePoints[GS, n] gives the points in {1, ..., \
n} that are fixed by all permutations in GS.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977985-5455693",ExpressionUUID->"d6187a7a-f32a-4284-8e7a-\
ed3fd48aaf8a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StablePoints", "[", "perm_", "]"}], ":=", 
   RowBox[{"StablePoints", "[", 
    RowBox[{"perm", ",", 
     RowBox[{"PermLength", "[", "perm", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"StablePoints", "[", 
    RowBox[{
     RowBox[{"perm_", "?", "PermQ"}], ",", "n_Integer"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Range", "[", "n", "]"}], ",", 
        RowBox[{"OnPoints", "[", 
         RowBox[{
          RowBox[{"Range", "[", "n", "]"}], ",", "perm"}], "]"}]}], "}"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x_", ",", "x_"}], "}"}], "\[Rule]", "x"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"StablePoints", "[", 
    RowBox[{
     RowBox[{"GS", ":", 
      RowBox[{"GenSet", "[", "__", "]"}]}], ",", "n_Integer"}], "]"}], ":=", 
   RowBox[{"Intersection", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"StablePoints", "[", 
        RowBox[{"#", ",", "n"}], "]"}], "&"}], "/@", "GS"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"StablePoints", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", "]"}], ",", "n_Integer"}], "]"}], ":=", 
   RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"StablePoints", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "StablePoints", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7b2492c3-4a27-41e8-bc83-3e9528a2346b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"StablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"StablePoints", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{
      "3", ",", "2", ",", "1", ",", "4", ",", "7", ",", "5", ",", "6"}], 
      "}"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"fc0a8012-2a4a-4c67-8625-30891460857b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StablePoints", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"faa3eba3-8b1e-4ac2-8037-17951d6225a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"StablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"StablePoints", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "3", ",", "2", ",", "1", ",", "4", ",", "7", ",", "5", ",", "6"}], 
       "}"}], "]"}], ",", "8"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"b6fcff74-58f0-4396-9366-e2f694ae42ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StablePoints", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"945f3c1b-839c-4538-875e-3b182401ef22"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"StablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"StablePoints", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", "4"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"f0b7df74-1140-4f46-90b9-ae05950d2d5f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StablePoints", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4bbf7400-7d93-4e74-b16e-4401cde22a15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"StablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"StablePoints", "[", 
    RowBox[{"ID", ",", "0"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"c612ce68-7e98-4f00-b05d-751f5e80259f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StablePoints", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"646f6026-f4be-41e2-9831-4eb45e76a59b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"StablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"StablePoints", "[", 
    RowBox[{"ID", ",", "8"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"795a9ca2-0003-431c-96fe-b22ceff8b108"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StablePoints", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"058498af-d195-410d-b262-266f90e27087"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"StablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"StablePoints", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], 
        "]"}]}], "]"}], ",", "6"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "6"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"51919df1-4f89-489a-bc1e-cd68187c827d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StablePoints", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4731c6bc-cbf8-4936-b898-e9b873d54557"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"StablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"StablePoints", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], 
        "]"}]}], "]"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"c53175c7-6ef4-439d-9596-4599366f2dc7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StablePoints", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6a7fdf78-516a-482e-85a8-222a879d7876"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"StablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"StablePoints", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", "]"}], ",", "5"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"77b4f3d0-ee6f-4844-ac4e-5d7e5ad6afba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StablePoints", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"5a536428-386a-4585-9c4d-65a91404898d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"StablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"StablePoints", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", "]"}], ",", "0"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"2bcf86cd-793e-4742-baa5-d064b9fb54a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"StablePoints", ",", "9", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"cb94c1cf-4be9-4de7-b86a-7155c4f464af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{
  "alltests", "[", "StablePoints", 
   "]"}]}]], "Input",ExpressionUUID->"6a629ad2-a5b3-4e65-9298-f4986b21c431"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"1b9418fd-4aff-427a-b0c2-76672c66b740"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.6.2. NonStablePoints", \
"Subsubsection",ExpressionUUID->"02bd2734-90a6-4257-9904-a76daeaa1d23"],

Cell["\<\
This function gives the minimal number of points (trying to minimize them as \
well), including initB, such that none of the generators GS fixes all of them.\
\>", "Text",ExpressionUUID->"2ba3693e-6658-4020-816d-53f20d5b0779"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "NonStablePoints"}]], \
"Input",ExpressionUUID->"f202de14-7259-4ddb-adcd-9570dc725853"],

Cell[BoxData[
 StyleBox["\<\"NonStablePoints[list, GS] enlarges list until none of the \
permutations in GS fixes all points in list. It tries to give the shortest \
result possible, not necessarily ordered.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977986-5455693",ExpressionUUID->"219b1d65-0ef4-46cd-bb96-\
4d376dc2d993"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NonStablePoints", "[", 
   RowBox[{"initB_List", ",", 
    RowBox[{"GenSet", "[", "]"}]}], "]"}], ":=", "initB"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NonStablePoints", "[", 
    RowBox[{"initB_List", ",", 
     RowBox[{"GS", ":", 
      RowBox[{"GenSet", "[", "__", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"SubsetQ", ",", "stablepoints", ",", 
       RowBox[{"base", "=", "initB"}], ",", "candidates", ",", "check", ",", 
       RowBox[{"len", "=", 
        RowBox[{"PermLength", "[", "GS", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"SubsetQ", "[", 
        RowBox[{"large_List", ",", "small_List"}], "]"}], ":=", 
       RowBox[{"And", "@@", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"large", ",", "#"}], "]"}], "&"}], ")"}], "/@", 
         "small"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"stablepoints", "=", 
       RowBox[{"List", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"StablePoints", "[", 
            RowBox[{"#", ",", "len"}], "]"}], "&"}], "/@", "GS"}], ")"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"candidates", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{
             RowBox[{"Complement", "[", 
              RowBox[{
               RowBox[{"Range", "[", "len", "]"}], ",", "#"}], "]"}], ",", 
             "#"}], "]"}], "&"}], "@", 
          RowBox[{"Flatten", "[", 
           RowBox[{"Union", "/@", 
            RowBox[{"Sort", "@", 
             RowBox[{"Split", "@", 
              RowBox[{"Sort", "@", 
               RowBox[{"Flatten", "@", "stablepoints"}]}]}]}]}], "]"}]}], ",", 
         RowBox[{"Alternatives", "@@", 
          RowBox[{"Intersection", "@@", "stablepoints"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{"True", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"candidates", "=", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{"candidates", ",", 
            RowBox[{"Alternatives", "@@", "base"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"check", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"SubsetQ", "[", 
             RowBox[{"#", ",", "base"}], "]"}], "&"}], "/@", 
           "stablepoints"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Which", "[", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Correct", " ", 
            RowBox[{"base", ".", " ", "Break"}], " ", "while", " ", "loop"}], 
           " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Not", "[", 
            RowBox[{"Or", "@@", "check"}], "]"}], ",", 
           RowBox[{"Break", "[", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"No", " ", "candidate", " ", 
             RowBox[{"elements", ".", " ", "Throw"}], " ", "error"}], " ", 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"candidates", "===", 
            RowBox[{"{", "}"}]}], ",", 
           RowBox[{
           "Throw", "[", "\"\<Unable to find enough nonstable points.\>\"", 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"Incorrect", " ", 
             RowBox[{"base", ".", " ", "Add"}], " ", "new", " ", "point"}], 
            " ", "*)"}], "\[IndentingNewLine]", "True", ",", 
           RowBox[{"For", " ", "[", 
            RowBox[{
             RowBox[{"i", "=", "1"}], ",", 
             RowBox[{"i", "\[LessEqual]", 
              RowBox[{"Length", "[", "check", "]"}]}], ",", 
             RowBox[{"++", "i"}], ",", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"check", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", 
               RowBox[{
                RowBox[{"AppendTo", "[", 
                 RowBox[{"base", ",", 
                  RowBox[{"First", "[", 
                   RowBox[{"Cases", "[", 
                    RowBox[{"candidates", ",", 
                    RowBox[{"x_", "/;", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{
                    RowBox[{"stablepoints", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", "x"}], "]"}]}]}], 
                    "]"}], "]"}]}], "]"}], ";", 
                RowBox[{"Break", "[", "]"}]}]}], "]"}]}], 
            "\[IndentingNewLine]", "]"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "base"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"NonStablePoints", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "NonStablePoints", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7df6773a-02d7-4c45-ab08-9f5658a32f13"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonStablePoints", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"44026f81-2260-47ab-8521-edec3cb97a55"],

Cell[BoxData[
 RowBox[{"{", 
  "}"}]], "Output",ExpressionUUID->"e1df1d79-ef8e-44b7-a3f4-1f68fbed2d47"]
}, Open  ]],

Cell["From example 4 below:", \
"Text",ExpressionUUID->"ee8d6703-9947-434e-965a-b813fefede81"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"6a770aca-385e-45bc-9066-44b8fa2625eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"NonStablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"NonStablePoints", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"cc014e44-3263-437d-9bdb-5067a1258dea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NonStablePoints", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"efa46aa0-98af-4133-96e5-caad032343c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"NonStablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"NonStablePoints", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"b", ",", "c", ",", "a"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"96ebf0b3-55ed-42d6-a348-a3959f0c7de3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NonStablePoints", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"27aaba31-6800-4107-b20b-f28c27fcd3c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"NonStablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"NonStablePoints", "[", 
    RowBox[{
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "10"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"4767deb6-3d07-4701-9163-dd5734018737"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NonStablePoints", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"3128a86c-c737-4e0d-9426-da7a16bbbdf8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"NonStablePoints", ",", "\[IndentingNewLine]", 
   RowBox[{"NonStablePoints", "[", 
    RowBox[{
     RowBox[{"{", "9", "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"0f75092c-6d2c-4ce9-95fe-c00474e10ebf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NonStablePoints", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"18c9faff-0bbc-4c2f-8c3c-71fdf504e0da"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.6.3. Pointwise stabilization: Stabilizer", \
"Subsubsection",ExpressionUUID->"2ebeb642-63f1-43f9-979c-27972549c9d0"],

Cell["\<\
This function gives the subset of permutations that leave stable the set of \
points. Note that when there is no stabilizing permutation we return \
GenSet[], and not the identity permutation, if it was not in GS.\
\>", "Text",ExpressionUUID->"7704689d-a91e-4dab-a62c-cf51469cd54f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Stabilizer"}]], \
"Input",ExpressionUUID->"774a765f-9920-4e67-ae92-8776dbb8b0ca"],

Cell[BoxData[
 StyleBox["\<\"Stabilizer[{p1, ...}, GS] gives the subset of permutations in \
GS that fix all points pi. Stabilizer[{p1, ...}, SGS] returns a strong \
generating set for the stabilizer subgroup of the group SGS fixing all points \
pi. In this latter case a third argument can be given with the length of the \
internal Schreier vectors.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977986-5455693",ExpressionUUID->"e0fa1bcb-33b1-49dd-9656-\
c91ce05f7143"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Stabilizer", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "GS_GenSet"}], "]"}], ":=", "GS"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Stabilizer", "[", 
    RowBox[{
     RowBox[{"{", "p_Integer", "}"}], ",", "GS_GenSet"}], "]"}], ":=", 
   RowBox[{"GenSet", "@@", 
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p", ",", 
          RowBox[{"OnPoints", "[", 
           RowBox[{"p", ",", "#"}], "]"}], ",", "#"}], "}"}], "&"}], "/@", 
       "GS"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x_", ",", "x_", ",", "y_"}], "}"}], "\[Rule]", "y"}]}], 
     "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Stabilizer", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1_Integer", ",", "ps__Integer"}], "}"}], ",", "GS_GenSet"}], 
    "]"}], ":=", 
   RowBox[{"Stabilizer", "[", 
    RowBox[{
     RowBox[{"{", "ps", "}"}], ",", 
     RowBox[{"Stabilizer", "[", 
      RowBox[{
       RowBox[{"{", "p1", "}"}], ",", "GS"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Stabilizer", "[", 
    RowBox[{"ps_List", ",", 
     RowBox[{"Symmetric", "[", "list_", "]"}]}], "]"}], ":=", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"Complement", "[", 
     RowBox[{"list", ",", "ps"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Stabilizer", "[", 
    RowBox[{"ps_List", ",", 
     RowBox[{"Antisymmetric", "[", "list_", "]"}]}], "]"}], ":=", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"Complement", "[", 
     RowBox[{"list", ",", "ps"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Stabilizer", ",", "2"}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"72323a54-9de4-4010-ac25-60ace5671169"],

Cell["\<\
The function is not protected because it will be overloaded below with \
definitions on SGSs.\
\>", "Text",ExpressionUUID->"658133e0-8dbd-48d1-ad2c-80b136174d52"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stabilizer", "[", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "3", ",", "2", ",", "1", ",", "4", ",", "7", ",", "5", ",", "6"}], 
       "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5", ",", "7"}], 
       "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"604cfb69-fb9f-4f0a-964b-7a5d92be2ab7"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5", ",", "7"}],
     "}"}], "]"}], 
  "]"}]], "Output",ExpressionUUID->"09643e1d-447b-456c-a766-2999d513d931"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stabilizer", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "3", ",", "2", ",", "1", ",", "4", ",", "7", ",", "5", ",", "6"}], 
       "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5", ",", "7"}], 
       "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"8a425a67-d6f8-4e62-9873-84bc9228d414"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  "]"}]], "Output",ExpressionUUID->"b0f5dbd8-8c8b-406a-9e92-3d4cd2882a7b"]
}, Open  ]],

Cell["\<\
Remember that an empty generating set actually represents the Group[ ID ].\
\>", "Text",ExpressionUUID->"94f63b0f-9972-4049-b398-07713958010e"],

Cell["\<\
There is an important point to consider: The stabilizer of the generating set \
of a group is not necessarily a generating set of the stabilizer subgroup. \
For example\
\>", "Text",ExpressionUUID->"ea120ed5-ffc7-412c-b844-d5a22ea0d320"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stabilizer", "[", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"85c0c153-ddcb-4376-98e0-9f779cf0a90d"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  "]"}]], "Output",ExpressionUUID->"0fa68225-d729-469d-be5d-3c3dc8b2d795"]
}, Open  ]],

Cell["\<\
and not GenSet[Perm[{3,2,1}]]. This problem will be solved below using strong \
generating sets.\
\>", "Text",ExpressionUUID->"73d6c5b8-7a48-4f1a-bba0-1f5fd980d7a7"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.6.4. Set stabilization: SetStabilizer", \
"Subsubsection",ExpressionUUID->"2dc6bf16-bcd7-4a87-b80c-37e03ed73706"],

Cell["\<\
Now we do not require that all points in a given list are stable under the \
stabilizer. We just require that those points do not leave the list.\
\>", "Text",ExpressionUUID->"a68f7e4c-1270-4cd6-abf4-a2b12467c23f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SetStabilizer"}]], \
"Input",ExpressionUUID->"0ff9e178-b8dd-4774-8411-8a99cd5c34da"],

Cell[BoxData[
 StyleBox["\<\"SetStabilizer[{p1, ...}, GS] gives the subset of permutations \
in GS that keep the points pi inside the list. SetStabilizer[{p1, ...}, SGS] \
returns a strong generating set for the setwise stabilizer of the list of \
points pi under the group generated by the strong generating set SGS.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977987-5455693",ExpressionUUID->"b6f66c23-4a9d-4411-96c3-\
dc46fc578b9f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetStabilizer", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "GS_GenSet"}], "]"}], ":=", "GS"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetStabilizer", "[", 
    RowBox[{
     RowBox[{"{", "p_Integer", "}"}], ",", "GS_GenSet"}], "]"}], ":=", 
   RowBox[{"Stabilizer", "[", 
    RowBox[{
     RowBox[{"{", "p", "}"}], ",", "GS"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetStabilizer", "[", 
    RowBox[{"list_List", ",", "GS_GenSet"}], "]"}], ":=", 
   RowBox[{"setstabilizer", "[", 
    RowBox[{"list", ",", "GS", ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setstabilizer", "[", 
    RowBox[{"list_List", ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"perm1_", ",", "perms___"}], "]"}], ",", 
     RowBox[{"GenSet", "[", "stperms___", "]"}]}], "]"}], ":=", 
   RowBox[{"setstabilizer", "[", 
    RowBox[{"list", ",", 
     RowBox[{"GenSet", "[", "perms", "]"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"OnPoints", "[", 
           RowBox[{"list", ",", "perm1"}], "]"}], ",", "list"}], "]"}], "===", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"stperms", ",", "perm1"}], "]"}], ",", 
       RowBox[{"GenSet", "[", "stperms", "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"setstabilizer", "[", 
    RowBox[{"list_List", ",", 
     RowBox[{"GenSet", "[", "]"}], ",", "stableGS_"}], "]"}], ":=", 
   "stableGS"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"dc471362-e410-478a-8d08-c1a7e4ed778b"],

Cell["\<\
The function is not protected because it will be overloaded below with \
definitions on SGSs.\
\>", "Text",ExpressionUUID->"fee82bec-c353-46f0-81f2-32f3680580ef"],

Cell["\<\
Using the group S3 we see the difference between pointwise stabilization and \
setwise stabilization:\
\>", "Text",ExpressionUUID->"342b1e33-8e8b-4743-9b98-795da0e0e939"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GenSet", "@@", 
  RowBox[{"Dimino", "[", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}]}], "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"e933d6cb-6d33-497e-9ba4-abb4828b7054"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"9e0ca155-1f21-4634-8069-2b11f3ba8360"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stabilizer", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "%"}], 
  "]"}]], "Input",ExpressionUUID->"a1553462-9d04-4c34-9993-59d75eaebe01"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], 
  "]"}]], "Output",ExpressionUUID->"3ae71ec7-6798-4d92-bbfd-3625347e8bbe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetStabilizer", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "%%"}], 
  "]"}]], "Input",ExpressionUUID->"69ea862e-8b47-4bef-a323-c90ef13c89ac"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"a7efbdf1-f6c8-4d6e-a855-464c374052ef"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["4. Strong generating sets",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"f9d4e121-03df-4773-a78f-bb3e887b0b79"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", "**", " ", "4."}], " ", 
   "Strong", " ", "generating", " ", "sets"}], " ", 
  "***************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1b2cdf91-c590-4c86-b4ab-7a79324b7789"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"4ba8f6a6-10c1-4a6e-b40e-5c543750f051"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "13.401436000000002`", ",", "41.574118`8.070368037874692", ",", 
   "0.3223510025846834`"}], 
  "}"}]], "Output",ExpressionUUID->"bf54164f-ef30-4c2a-9e5d-f57c312ce1ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.0. Comments", \
"Subsection",ExpressionUUID->"7767c6a3-7a69-417d-b922-896b8cf86385"],

Cell["\<\
The fast manipulation of permutation groups is based on the combination of \
two \"complementary\" ideas: orbits (the description of how points move under \
the group) and stabilization (the description of how points don't move under \
the group). A strong generating sets (SGS) is a clever description of a group \
which allows efficient encoding of both simultaneously.\
\>", "Text",ExpressionUUID->"0fc6d484-e18a-49ca-8961-8984153a51b6"],

Cell[TextData[{
 "From now on most algorithms are encoded using an imperative paradigm (like \
C), to follow Butler as closely as possible, though this is rather \
inefficient in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It really doesn't matter because in the end we will recode the whole \
thing in C, much faster, where the imperative paradigm is natural. Therefore \
this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code can be considered as a testbed for new ideas and algorithms. Once \
they work here then they are transferred to the C code."
}], "Text",ExpressionUUID->"854d7702-2fa2-4ca6-bb35-8eb6a5466124"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"$ReadingVerbose", ",", 
   RowBox[{
   "Print", "[", "\"\<Reading section 4: Strong generating sets\>\"", "]"}], ",",
    "Null", ",", "Null"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"671a5ea9-72ea-4583-af32-1e70bff99a62"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1. Orbits and Schreier vectors", \
"Subsection",ExpressionUUID->"ebbe5520-6143-48b8-87f5-a3413f422e52"],

Cell[CellGroupData[{

Cell["4.1.0. Comments", \
"Subsubsection",ExpressionUUID->"5ea418a5-f554-4cb4-aa77-572b74428a7d"],

Cell["\<\
An orbit is an irreducible set of points closed under OnPoints. Given a group \
of permutations and a point of the orbit this is a well defined concept, \
independent of the notation used for the permutations. However, when we want \
to find all orbits we need to know in advance the length of the set of \
points, because we want to partition it in orbits. In the same way, in order \
to give a Schreier vector we need to know the length of the set to construct \
vectors of that length. That is why Orbit does not have a length argument, \
but Orbits, SchreierOrbit and SchreierOrbits do have it.\
\>", "Text",ExpressionUUID->"edd29278-beea-44a6-a703-af0bb88e439d"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1.1. Orbit", \
"Subsubsection",ExpressionUUID->"1a1f0658-19cf-4923-a934-88835e9c8f1f"],

Cell["\<\
Orbit and Orbits give the orbits without their Schreier vectors.When no \
generators are given it means that we are calculating the orbit of a point \
under the group {ID}. Points in the orbits are not sorted and the initial \
point is used as first point.\
\>", "Text",ExpressionUUID->"3510b569-3291-4de5-8ad5-57a3c4fcbba8"],

Cell["This is algorithm 7.1 of Butler:", \
"Text",ExpressionUUID->"dc3d0226-81df-496b-998e-35f1efe7ebcd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Orbit"}]], "Input",ExpressionUUID->"49a19c74-012e-446a-a778-3d636eef81b9"],

Cell[BoxData[
 StyleBox["\<\"Orbit[p, GS] gives the orbit of point p under the group \
generated by GS. The orbit is given as a (not necessarily ordered) list \
having p as first point.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977988-5455693",ExpressionUUID->"bc53c7fb-78c8-4ea0-af7c-\
b44f93631133"]
}, Open  ]],

Cell["Orbit is simply a driver for the Mathematica or the C codes:", \
"Text",ExpressionUUID->"6ee17438-e81d-4682-b5ab-0fb20b8d549b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Driver", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "Orbit", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{"MathLink", "\[RuleDelayed]", "$xpermQ"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbit", "[", 
      RowBox[{
       RowBox[{"point_Integer", "?", "Positive"}], ",", 
       RowBox[{"StrongGenSet", "[", 
        RowBox[{"base_", ",", "GS_"}], "]"}], ",", "options___"}], "]"}], ":=", 
     RowBox[{"Orbit", "[", 
      RowBox[{"point", ",", "GS", ",", "options"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbit", "[", 
      RowBox[{
       RowBox[{"point_Integer", "?", "Positive"}], ",", 
       RowBox[{"GenSet", "[", "]"}], ",", "options___"}], "]"}], ":=", 
     RowBox[{"{", "point", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbit", "[", 
      RowBox[{
       RowBox[{"point_Integer", "?", "Positive"}], ",", "GS_GenSet", ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"OptionValue", "[", "MathLink", "]"}], ",", "MathLinkOrbit", ",",
         "MathOrbit"}], "]"}], "[", 
      RowBox[{"point", ",", "GS"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbit", "[", 
      RowBox[{
       RowBox[{"point_Integer", "?", "Positive"}], ",", "GS_"}], "]"}], ":=", 
     
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"Orbit", "::", "unknown"}], ",", "\"\<generating set\>\"", ",",
         "GS"}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbit", "[", 
      RowBox[{"point_", ",", "GS_"}], "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"Orbit", "::", "unknown"}], ",", "\"\<point\>\"", ",", 
        "point"}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"Orbit", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "Orbit", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "code"}], " ", "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"MathOrbit", "[", 
      RowBox[{"point_", ",", "GS_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"orbit", "=", 
          RowBox[{"{", "point", "}"}]}], ",", 
         RowBox[{"np", "=", "1"}], ",", "gamma", ",", "newgamma"}], "}"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"np", "\[LessEqual]", 
           RowBox[{"Length", "[", "orbit", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"gamma", "=", 
            RowBox[{"orbit", "[", 
             RowBox[{"[", "np", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"FreeQ", "[", 
                 RowBox[{"orbit", ",", 
                  RowBox[{"newgamma", "=", 
                   RowBox[{"OnPoints", "[", 
                    RowBox[{"gamma", ",", "#"}], "]"}]}]}], "]"}], ",", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{"orbit", ",", "newgamma"}], "]"}]}], "]"}], "&"}], ",",
              "GS"}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"++", "np"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        "orbit"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e5adbfc2-e73a-41ab-9011-daf79b5e4365"],

Cell["Examples:", \
"Text",ExpressionUUID->"16827ae1-7184-420d-bc53-d238f518efa5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$xpermQ", "=", 
  "False"}]], "Input",ExpressionUUID->"bdcceb18-326c-4da9-b31f-f44bce7ee705"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"f9da3ec7-d429-4eef-8544-4729bf58fce5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbit", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbit", "[", 
    RowBox[{"1", ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], "]"}]}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"d03218a7-8ee7-4ce4-a04a-74c8d752a100"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbit", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"a8fc2e19-c49c-4baf-9c0c-4de29f0239a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbit", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbit", "[", 
    RowBox[{"5", ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"d0ea5ac3-6925-49e8-b6ea-fa060ccbba3b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbit", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4d325052-726a-4894-a955-1566bb2fb5ea"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1.2. Orbits", \
"Subsubsection",ExpressionUUID->"e82f1c73-c8e4-4187-b093-e19cbaa63cc4"],

Cell["\<\
In order to give all orbits we need to give the length of the set of points \
to partition:\
\>", "Text",ExpressionUUID->"0370e216-ce9d-41ab-bbc7-0766333e10d8"],

Cell["This is algorithm 7.2 of Butler:", \
"Text",ExpressionUUID->"f4e4edeb-f8c9-425e-a68a-a3a24bc22248"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Orbits"}]], "Input",ExpressionUUID->"c0e57778-17d4-48dc-a59d-ffdcddb908d3"],

Cell[BoxData[
 StyleBox["\<\"Orbits[GS, len] gives a list with all orbits of the group \
generated by permutations in GS, a partition of Range[len]. Orbits[GS, len, \
list] makes points in list to be the first points of the orbits. Orbits[GS] \
and Orbits[GS, list] compute len from GS using PermLength. GS can be a \
generating set (head GenSet) or a strong generating set (head \
StrongGenSet).\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977989-5455693",ExpressionUUID->"527763fb-0122-4e1f-b8c0-\
8d0ab7acd22a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Compute", " ", "PermLength", " ", "if", " ", "not", " ", "given"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Orbits", "[", 
      RowBox[{"gs_", ",", 
       RowBox[{"initpoints_List", ":", 
        RowBox[{"{", "}"}]}]}], "]"}], ":=", 
     RowBox[{"Orbits", "[", 
      RowBox[{"gs", ",", 
       RowBox[{"PermLength", "[", "gs", "]"}], ",", "initpoints"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Transform", " ", "SGS", " ", "to", " ", "GS"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbits", "[", 
      RowBox[{
       RowBox[{"StrongGenSet", "[", 
        RowBox[{"base_", ",", "GS_"}], "]"}], ",", "len_Integer", ",", 
       RowBox[{"initpoints_List", ":", 
        RowBox[{"{", "}"}]}]}], "]"}], ":=", 
     RowBox[{"Orbits", "[", 
      RowBox[{"GS", ",", "len", ",", "initpoints"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Compute", " ", "orbits", " ", "using", " ", "Orbit"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbits", "[", 
      RowBox[{"GS_GenSet", ",", "len_Integer", ",", 
       RowBox[{"initpoints_List", ":", 
        RowBox[{"{", "}"}]}]}], "]"}], ":=", 
     RowBox[{"Fold", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"Flatten", "[", "#1", "]"}], ",", "#2"}], "]"}], ",", 
          "#1", ",", 
          RowBox[{"Append", "[", 
           RowBox[{"#1", ",", 
            RowBox[{"Orbit", "[", 
             RowBox[{"#2", ",", "GS"}], "]"}]}], "]"}]}], "]"}], "&"}], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"initpoints", "~", "Join", "~", 
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"Range", "[", "len", "]"}], ",", "initpoints"}], "]"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Special", " ", "cases"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbits", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Symmetric", "|", "Antisymmetric"}], ")"}], "[", "list_List",
         "]"}], ",", "len_Integer"}], "]"}], ":=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", "list", "}"}], ",", 
       RowBox[{"List", "/@", 
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"Range", "[", "len", "]"}], ",", "list"}], "]"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Orbits", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Symmetric", "|", "Antisymmetric"}], ")"}], "[", "list_List",
         "]"}], ",", "len_Integer", ",", "initpoints_List"}], "]"}], ":=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"SortB", "[", 
         RowBox[{"list", ",", "initpoints"}], "]"}], "}"}], ",", 
       RowBox[{"List", "/@", 
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"Range", "[", "len", "]"}], ",", "list"}], "]"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"Orbits", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Protect", "[", "Orbits", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9632d932-0ea2-4c35-8463-4376f4d83f82"],

Cell["\<\
Recall that points in the orbits are not reordered after computation (we \
shall do that, however, when computing SchreierOrbit).\
\>", "Text",ExpressionUUID->"3b20242f-bdba-4150-a38b-3a48e6b51f4e"],

Cell["Examples:", \
"Text",ExpressionUUID->"0c2dfc50-8901-4cc5-a14a-9a5024adf14d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbits", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbits", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}], ",", "6"}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", "6", "}"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"2101087c-8073-4618-9673-6816fce13f32"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbits", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6fc463cb-7cf7-4954-bc11-a84642066ef2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbits", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbits", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "2"}], ",", 
        RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"4", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"97ebef2c-8210-4bcd-a681-4afd2473dfda"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbits", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"9b6c6cfc-70a4-42ae-a174-270f78d35cb2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbits", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbits", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", "]"}], ",", "5"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"4f922cfb-6f00-405d-b27c-ecdbf8ecfe33"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbits", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4155a05a-ab54-40ec-8994-9dadfa5bd3c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbits", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbits", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}], ",", "6", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "6", "}"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3eef2809-1d16-4951-a6fb-173e19d01c75"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbits", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"9f47761b-ead2-4dff-bd44-f6c9fe9a656d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbits", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbits", "[", 
    RowBox[{
     RowBox[{"Symmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "5"}], "}"}], "]"}], ",", "6"}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "6", "}"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7cf57315-ace2-4924-a7ce-4b3b793ac4e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbits", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6b7aee7d-ce0a-4083-a121-76fb7280030b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbits", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbits", "[", 
    RowBox[{
     RowBox[{"Antisymmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "5"}], "}"}], "]"}], ",", "6", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "6", "}"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"6882b778-4c37-4208-a1e4-9d663b297e58"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbits", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"424db050-622f-4c46-b0ce-7bbd152d945b"]
}, Open  ]],

Cell["\<\
If the given length is too low then we can miss some of the orbits (we are \
asking to partition {1,2,3} only):\
\>", "Text",ExpressionUUID->"8790d20c-d250-45e8-89a0-371ce593388f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbits", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbits", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}], ",", "3", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"9232f13b-1926-4a8d-bccd-685e0d3b88f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbits", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"8e8f2baa-a35d-4192-947b-bfd23f9313ce"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1.3. SchreierOrbit", \
"Subsubsection",ExpressionUUID->"94f154b6-b82b-4e58-86ef-9973efd5048c"],

Cell["\<\
We need to give the lenght of nu, w. When we supply a SGS instead of just the \
GS, we follow Canon code in this convention: use as first point of the orbit \
the mininum of the orbit with respect to the base of the SGS. We haven\.b4t \
done that in Orbit and Orbits.\
\>", "Text",ExpressionUUID->"623b4a63-546a-4e77-bdce-b67b71ec4e1f"],

Cell["\<\
The output is a Schreier structure, having three elements: the orbit, the nu \
vector of permutations and the w vector of backward pointers.\
\>", "Text",ExpressionUUID->"45a1990e-96c3-4498-9c82-cd3258557b16"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Schreier"}]], \
"Input",ExpressionUUID->"2ea6c1e8-4eac-4709-ac38-e6aedff29e1f"],

Cell[BoxData[
 StyleBox["\<\"Schreier is the head for a Schreier vector. The format is \
Schreier[orbits, nu, w], where nu is the actual Schreier vector and w is the \
associated vector of backward pointers.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977990-5455693",ExpressionUUID->"b06ac29c-7884-4704-93cd-\
2fc18bb91344"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Schreier", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Schreier", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c5ce7639-b4b2-4c08-9028-97500eda901f"],

Cell["Schreier orbit:", \
"Text",ExpressionUUID->"936b4a6c-6d5e-4aa6-822b-04f0762ad488"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SchreierOrbit"}]], \
"Input",ExpressionUUID->"4e5f02bb-5c67-4d65-b0e5-12d155feaef0"],

Cell[BoxData[
 StyleBox["\<\"SchreierOrbit[p, GS, len] gives the orbit of point p under the \
group generated by GS, and its Schreier vector (of lenght len). \
SchreierOrbit[p, SGS, len] gives the same output, but the the first point of \
the orbit is now the minimum with respect to the base of the SGS. \
SchreierOrbit[p, gs] computes the length of the vectors from gs using \
PermLength. See notes for Schreier.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977990-5455693",ExpressionUUID->"e1aabef8-9852-4bd8-b9ae-\
f7047370d57e"]
}, Open  ]],

Cell["\<\
Unfortunately, this line introduces a redundant computation of the orbit, but \
I don't see how to avoid it (MinB is, however, very efficient):\
\>", "Text",ExpressionUUID->"f454c824-d581-4023-82a2-52772cef20b7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"point_Integer", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"B_List", ",", "GS_GenSet"}], "]"}], ",", "deg_Integer"}], 
    "]"}], ":=", 
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{
     RowBox[{"MinB", "[", 
      RowBox[{
       RowBox[{"Orbit", "[", 
        RowBox[{"point", ",", "GS"}], "]"}], ",", "B"}], "]"}], ",", "GS", ",",
      "deg"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b4baf94d-c666-4e52-81ac-e513716ca649"],

Cell["\<\
For special cases perhaps there is a faster solution than this:\
\>", "Text",ExpressionUUID->"788d68af-fec3-4cf1-877a-265b56661b32"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"point_Integer", ",", 
     RowBox[{"sym", ":", 
      RowBox[{"(", 
       RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], ",", 
     "deg_Integer"}], "]"}], ":=", 
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"point", ",", 
     RowBox[{"SchreierSims", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "sym"}], "]"}], ",", "deg"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"56d4db4f-5207-4c19-be1f-9d7b2db3d848"],

Cell["This is algorithm 7.4 of Butler:", \
"Text",ExpressionUUID->"491d1a06-cd4e-493e-a2dd-360ba511bf86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SchreierOrbit", "::", "infty"}], 
   "=", "\"\<Found Infinity as a point, with generating set `1`.\>\""}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"dff68de4-54fe-40ff-843a-5a7fcb7d9f7e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{
     RowBox[{"point_Integer", "?", "Positive"}], ",", "gs_"}], "]"}], ":=", 
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"point", ",", "gs", ",", 
     RowBox[{"PermLength", "[", "gs", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{
     RowBox[{"point_Integer", "?", "Positive"}], ",", 
     RowBox[{"GenSet", "[", "]"}], ",", "len_Integer"}], "]"}], ":=", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", "point", "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "len", "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "len", "}"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{
     RowBox[{"point_Integer", "?", "Positive"}], ",", 
     RowBox[{"GS", ":", 
      RowBox[{"GenSet", "[", "__", "]"}]}], ",", "len_Integer"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"orbit", "=", 
        RowBox[{"{", "point", "}"}]}], ",", "nu", ",", "w", ",", 
       RowBox[{"np", "=", "1"}], ",", "gamma", ",", "newgamma"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"nu", "=", 
       RowBox[{"w", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", "len", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"np", "\[LessEqual]", 
         RowBox[{"Length", "[", "orbit", "]"}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{"gamma", "=", 
          RowBox[{"orbit", "[", 
           RowBox[{"[", "np", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"FreeQ", "[", 
               RowBox[{"orbit", ",", 
                RowBox[{"newgamma", "=", 
                 RowBox[{"OnPoints", "[", 
                  RowBox[{"gamma", ",", "#"}], "]"}]}]}], "]"}], ",", 
              RowBox[{
               RowBox[{"AppendTo", "[", 
                RowBox[{"orbit", ",", "newgamma"}], "]"}], ";", 
               RowBox[{
                RowBox[{"nu", "[", 
                 RowBox[{"[", "newgamma", "]"}], "]"}], "=", "#"}], ";", 
               RowBox[{
                RowBox[{"w", "[", 
                 RowBox[{"[", "newgamma", "]"}], "]"}], "=", "gamma"}]}]}], 
             "]"}], "&"}], ",", "GS"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"++", "np"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Schreier", "[", 
       RowBox[{"orbit", ",", "nu", ",", "w"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"Infinity", ",", "GS_", ",", "len_"}], "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"SchreierOrbit", "::", "infty"}], ",", "GS"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"SchreierOrbit", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "SchreierOrbit", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b1b5ec1b-f23f-40bd-bf47-e7cbd1589444"],

Cell["Examples:", \
"Text",ExpressionUUID->"7b7a4a91-7f91-4596-ab4e-1acd7cdd7dd4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbit", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"1", ",", 
     RowBox[{"GenSet", "[", "]"}], ",", "4"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"aea9aac6-2021-4b1f-907c-9d5565df16fa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbit", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"8e925e74-90f1-4411-816c-7cf786292ed1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbit", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"1", ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], "]"}]}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "4", ",", "1"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3a0cae2c-3ee6-47e5-9342-722a996bc072"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbit", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4e2a8cff-a756-4728-8711-27988177d9be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbit", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"5", ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}], ",", "6"}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}], ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "5", ",", "0", ",", "0"}], 
      "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"cb416c80-4c11-4410-9732-03a1aa596264"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbit", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"c5c5321f-9574-4e92-a790-95b06d652a99"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbit", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"3", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}], ",", 
     "4"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", "0", ",", 
       RowBox[{"-", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "0", ",", "3"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"4e30ca83-363e-46a2-954b-f1d9d5a83829"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbit", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"becc6f64-dd8b-4aca-87a5-70129210e427"]
}, Open  ]],

Cell["\<\
The key point is the fact that g=OnPoints[ w[[g]], nu[[g]] ] for any g. That \
is, we know that we can go from w[[g]] to g using nu[[g]].\
\>", "Text",ExpressionUUID->"eae0281d-eed1-4de8-9bea-ecf5f59396d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbit", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"2", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
     "3"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"d8580775-1415-4a74-88f7-8f8c0f58fc00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbit", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"c1f727c5-6100-4435-92cc-ea1922a5b3de"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1.4. SchreierOrbits", \
"Subsubsection",ExpressionUUID->"ec80fcd3-d562-407b-83cc-0cbf76cb330e"],

Cell["We can have all orbits together in a single vector:", \
"Text",ExpressionUUID->"22782f42-17ff-4547-aa7d-1c46cac7a2ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SchreierOrbits"}]], \
"Input",ExpressionUUID->"76222f55-773e-43b0-87ae-5a5db75cb13e"],

Cell[BoxData[
 StyleBox["\<\"SchreierOrbits[GS, len] gives a compound Schreier vector \
(length len) of the orbits of the group generated by GS. SchreierOrbits[GS, \
len, list] makes points in list to be the first points of the orbits. \
SchreierOrbits[SGS, len] gives the same output, but the orbits now start with \
the points of the base of the SGS. SchreierOrbits[gs] computes len from gs \
using PermLength. See notes for Schreier.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977991-5455693",ExpressionUUID->"a87116e5-2ce0-4b64-84a2-\
e5ef34f46caf"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Compute", " ", "len", " ", "from", " ", "gs", " ", "using", " ", 
    "PermLength"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{"gs_", ",", 
       RowBox[{"initpoints_List", ":", 
        RowBox[{"{", "}"}]}]}], "]"}], ":=", 
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{"gs", ",", 
       RowBox[{"PermLength", "[", "gs", "]"}], ",", "initpoints"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"GS", ":", " ", 
     RowBox[{
     "Compute", " ", "all", " ", "Schreier", " ", "orbits", " ", "from", " ", 
      "SchreierOrbit", " ", "and", " ", "Orbits"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{
       RowBox[{"GS", ":", 
        RowBox[{"GenSet", "[", "__", "]"}]}], ",", "len_Integer", ",", 
       RowBox[{"initpoints_List", ":", 
        RowBox[{"{", "}"}]}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"Schreier", "[", 
        RowBox[{
         RowBox[{"Sequence", "@@", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"Plus", "@@", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{"Plus", "@@", 
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], "&"}], "@", 
      RowBox[{"Transpose", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{"#", ",", "GS", ",", "len"}], "]"}], "&"}], "/@", 
         RowBox[{"First", "/@", 
          RowBox[{"Orbits", "[", 
           RowBox[{"GS", ",", "len", ",", "initpoints"}], "]"}]}]}], "/.", 
        RowBox[{"Schreier", "\[Rule]", "List"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"SGS", ":", " ", 
     RowBox[{
     "Use", " ", "base", " ", "as", " ", "initpoints", " ", "if", " ", 
      "initpoints", " ", "not", " ", "specified"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{
       RowBox[{"StrongGenSet", "[", 
        RowBox[{"B_List", ",", 
         RowBox[{"GS", ":", 
          RowBox[{"GenSet", "[", "__", "]"}]}]}], "]"}], ",", "len_Integer"}],
       "]"}], ":=", 
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{"GS", ",", "len", ",", "B"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{
       RowBox[{"StrongGenSet", "[", 
        RowBox[{"B_List", ",", 
         RowBox[{"GS", ":", 
          RowBox[{"GenSet", "[", "__", "]"}]}]}], "]"}], ",", "len_Integer", ",",
        "initpoints_List"}], "]"}], ":=", 
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{"GS", ",", "len", ",", "initpoints"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Special", " ", "cases"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{
       RowBox[{"sym", ":", 
        RowBox[{"(", 
         RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], ",", 
       "len_Integer", ",", 
       RowBox[{"initpoints_", ":", 
        RowBox[{"{", "}"}]}]}], "]"}], ":=", 
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{
       RowBox[{"GenSet", "[", "sym", "]"}], ",", "len", ",", "initpoints"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{
       RowBox[{"GenSet", "[", "]"}], ",", "len_Integer", ",", 
       RowBox[{"initpoints_", ":", 
        RowBox[{"{", "}"}]}]}], "]"}], ":=", 
     RowBox[{"Schreier", "[", 
      RowBox[{
       RowBox[{"Sequence", "@@", 
        RowBox[{"Orbits", "[", 
         RowBox[{
          RowBox[{"GenSet", "[", "]"}], ",", "len"}], "]"}]}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "len", "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "len", "}"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{
       RowBox[{"StrongGenSet", "[", 
        RowBox[{"_", ",", 
         RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "len_Integer"}], "]"}], ":=", 
     RowBox[{"Schreier", "[", 
      RowBox[{
       RowBox[{"Sequence", "@@", 
        RowBox[{"Orbits", "[", 
         RowBox[{
          RowBox[{"GenSet", "[", "]"}], ",", "len"}], "]"}]}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "len", "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "len", "}"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"SchreierOrbits", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Protect", "[", "SchreierOrbits", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"64f09ded-da7f-4531-a8c2-3ce630e6c6af"],

Cell["\<\
Examples. Note that the number of arguments of Schreier is finally #orbits + \
2.\
\>", "Text",ExpressionUUID->"ecd5fc1c-dcf4-430f-a3fc-d43c3573dbb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TracePrint", "[", 
  RowBox[{
   RowBox[{"SchreierOrbits", "[", 
    RowBox[{"GenSet", "[", "]"}], "]"}], ",", 
   RowBox[{"SchreierOrbits", "[", "___", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"bdb9232e-f657-4fbb-83a4-45b129f018a2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{" ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"SchreierOrbits", "[", 
     RowBox[{"GenSet", "[", "]"}], "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[1], 
   HoldForm[
    xAct`xPerm`SchreierOrbits[
     xAct`xPerm`GenSet[]]]],
  Editable->
   False]], "Print",ExpressionUUID->"81ecece4-973b-4963-b241-7abdc71e5e59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{" ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"SchreierOrbits", "[", 
     RowBox[{
      RowBox[{"GenSet", "[", "]"}], ",", 
      RowBox[{"PermLength", "[", 
       RowBox[{"GenSet", "[", "]"}], "]"}], ",", 
      RowBox[{"{", "}"}]}], "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[1], 
   HoldForm[
    xAct`xPerm`SchreierOrbits[
     xAct`xPerm`GenSet[], 
     xAct`xPerm`PermLength[
      xAct`xPerm`GenSet[]], {}]]],
  Editable->
   False]], "Print",ExpressionUUID->"094fec88-9dbe-4a60-89c7-b88f8d3eaf91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{" ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"SchreierOrbits", "[", 
     RowBox[{
      RowBox[{"GenSet", "[", "]"}], ",", "0", ",", 
      RowBox[{"{", "}"}]}], "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[1], 
   HoldForm[
    xAct`xPerm`SchreierOrbits[
     xAct`xPerm`GenSet[], 0, {}]]],
  Editable->
   False]], "Print",ExpressionUUID->"5af741a5-235d-4570-9cc5-b02c6fa9d90d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Schreier", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"7f1e2b18-bf63-4b44-83a0-0e02daf627a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbits", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbits", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", "]"}], ",", "5"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "]"}]}],
   "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"57d08318-fd7f-491b-be1e-42ff1fc178c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbits", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"4be105b5-d8af-408f-9b18-040fef9330af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbits", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbits", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "2"}], ",", 
        RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"4", "\[Rule]", "5"}], ",", 
        RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", "0", ",", "0", ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "4"}], "}"}]}], "]"}]}],
   "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"21746535-5285-43e8-a480-9b6574956185"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbits", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"74198e76-a0ef-48ae-8918-a0dadcee6c47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbits", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbits", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}], ",", "5", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", "0", ",", "0", ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "5", ",", "0"}], "}"}]}], "]"}]}],
   "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"feb9cbd3-bbdb-458f-9daa-568b711e88eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbits", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d303d844-d7b5-4a28-b67d-03834a69ca50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbits", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbits", "[", 
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "4"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Rules", "[", 
          RowBox[{
           RowBox[{"1", "\[Rule]", "2"}], ",", 
           RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
         RowBox[{"Rules", "[", 
          RowBox[{
           RowBox[{"4", "\[Rule]", "5"}], ",", 
           RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}]}], "]"}], ",", 
     "5"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", "0", ",", "0", ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "4"}], "}"}]}], "]"}]}],
   "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"04fce1ef-e53d-4dde-8b57-11d189e95a81"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbits", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"15c0f540-2cc8-43a2-8d36-79c309fd7b51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbits", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbits", "[", 
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "5"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Rules", "[", 
          RowBox[{
           RowBox[{"1", "\[Rule]", "2"}], ",", 
           RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", 
         RowBox[{"Rules", "[", 
          RowBox[{
           RowBox[{"4", "\[Rule]", "5"}], ",", 
           RowBox[{"5", "\[Rule]", "4"}]}], "]"}]}], "]"}]}], "]"}], ",", 
     "5"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "1"}]}], "]"}], ",", "0", ",", "0", ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}]}], "]"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "5", ",", "0"}], "}"}]}], "]"}]}],
   "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"f26021a6-0f03-4b67-ab92-ac70f29049ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbits", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"6ba0ea2f-5679-4d9e-912a-2ceeea7e5971"]
}, Open  ]],

Cell["Example from page 59 of Butler's book:", \
"Text",ExpressionUUID->"66dbacc2-0a2c-422b-8860-1ca95047193b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "4", ",", "5", ",", "11", ",", "6", ",", "10", ",", "3", ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "4", ",", "5", ",", "11", ",", "6", ",", "10", ",", "3", ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "9"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "11", ",", "10", ",", "6"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"72d8dce8-3fbf-4364-92bf-ccfb4a88c724"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbit", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbit", "[", 
    RowBox[{"7", ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"1bbf3649-857b-4730-803f-7ccf96549476"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbit", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"03d8f66f-02d5-44b7-9c33-a2fc506cf273"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbit", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SchreierOrbit", "[", 
     RowBox[{"7", ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "11"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"b", "\[Rule]", "\"\<b\>\""}], ",", 
      RowBox[{"c", "\[Rule]", "\"\<c\>\""}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
       ",", "\"\<a\>\"", ",", "\"\<b\>\"", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "7", ",", "8", ",", "0", ",", "0"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3599572a-5c0f-40af-a005-93363bae48e5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbit", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"255cd9cd-b702-41e6-a772-5c36bd6bcd0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbit", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbit", "[", 
    RowBox[{"1", ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "4", ",", "5", ",", "2", ",", "11", ",", "3", ",", "6", ",", 
     "10"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"5881c079-aa82-4b0c-8c39-e4bdc1b2fb40"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbit", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"454d1f28-5245-4c61-8781-e6d8ce5016b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbit", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SchreierOrbit", "[", 
     RowBox[{"1", ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"b", "\[Rule]", "\"\<b\>\""}], ",", 
      RowBox[{"c", "\[Rule]", "\"\<c\>\""}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "4", ",", "5", ",", "2", ",", "11", ",", "3", ",", "6", ",", 
       "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "\"\<c\>\"", ",", "\"\<c\>\"", ",", "\"\<a\>\"", 
       ",", "\"\<a\>\"", ",", "\"\<a\>\"", ",", "0", ",", "0", ",", "0", 
       ",", "\"\<c\>\"", ",", "\"\<a\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "4", ",", "2", ",", "1", ",", "4", ",", "11", ",", "0", ",", 
       "0", ",", "0", ",", "11", ",", "5"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"420f9a9e-24a2-4e5e-8379-36072cc5889a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbit", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"acfaf6ac-1aa6-4b11-9800-9d13fd6a5f02"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbits", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbits", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "4", ",", "5", ",", "2", ",", "11", ",", "3", ",", "6", ",", 
       "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ed00b36b-a614-44fc-8caf-ae309f95a095"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbits", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"838c9b95-621b-475d-b7bf-2542a481da11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbits", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SchreierOrbits", "[", 
     RowBox[{
      RowBox[{"GenSet", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "11"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"b", "\[Rule]", "\"\<b\>\""}], ",", 
      RowBox[{"c", "\[Rule]", "\"\<c\>\""}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "4", ",", "5", ",", "2", ",", "11", ",", "3", ",", "6", ",", 
       "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "\"\<c\>\"", ",", "\"\<c\>\"", ",", "\"\<a\>\"", 
       ",", "\"\<a\>\"", ",", "\"\<a\>\"", ",", "0", ",", "\"\<a\>\"", 
       ",", "\"\<b\>\"", ",", "\"\<c\>\"", ",", "\"\<a\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "4", ",", "2", ",", "1", ",", "4", ",", "11", ",", "0", ",", 
       "7", ",", "8", ",", "11", ",", "5"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"f0dbf872-0bf1-4723-b672-aea921a56276"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbits", ",", "6", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"f82bb71f-007b-4dcc-ba96-2505116dba4f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbits", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SchreierOrbits", "[", 
     RowBox[{
      RowBox[{"GenSet", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "11", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "8"}], "}"}]}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"b", "\[Rule]", "\"\<b\>\""}], ",", 
      RowBox[{"c", "\[Rule]", "\"\<c\>\""}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "11", ",", "6", ",", 
       "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "7", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", "0", ",", "\"\<c\>\"", ",", "\"\<a\>\"", 
       ",", "\"\<a\>\"", ",", "\"\<a\>\"", ",", "\"\<a\>\"", ",", "0", 
       ",", "\"\<b\>\"", ",", "\"\<c\>\"", ",", "\"\<a\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "0", ",", "2", ",", "1", ",", "4", ",", "11", ",", "8", ",", 
       "0", ",", "8", ",", "11", ",", "5"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"c5b68c38-08e5-4ebe-a3ef-20ab28948f8a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbits", ",", "7", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"8b57830f-dbe3-4060-a36d-5acac239a3de"]
}, Open  ]],

Cell["\<\
If no permutations are given, we just return the trivial sets. Note the \
relevance of the len argument:\
\>", "Text",ExpressionUUID->"0828cbda-a722-418e-b8d6-2744831710e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbit", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbit", "[", 
    RowBox[{"1", ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", "1", "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"369c02ce-4e0d-4f02-862d-2eecd5dde2b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbit", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"98b7c431-cdaf-4bab-864a-285ba2e82d0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbit", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbit", "[", 
    RowBox[{"1", ",", 
     RowBox[{"GenSet", "[", "]"}], ",", "3"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"29b11f7a-d515-43e6-a51f-7ff4d0e66dfb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbit", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"af9e1adc-7165-4962-b7e3-b9a77b06c669"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Orbits", ",", "\[IndentingNewLine]", 
   RowBox[{"Orbits", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", "]"}], ",", "3"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"9f623750-3099-42fb-8c6c-062467aeeb8f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Orbits", ",", "9", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"dff0c067-a970-446f-a311-aa2da7dd899b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbits", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierOrbits", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", "]"}], ",", "3"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"19ec6dcb-d04f-41dd-a77e-b4d453832498"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbits", ",", "8", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"2dc84504-0564-4b6f-b4f4-a55de8945c33"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1.5. TraceSchreier", \
"Subsubsection",ExpressionUUID->"5c2e03d7-a7fb-4252-88d7-5e5d7c975c0d"],

Cell["\<\
Finally, we can trace the Schreier vectors, which is the operation giving the \
permutation moving the first-point of an orbit to a given point:\
\>", "Text",ExpressionUUID->"9242a710-bc56-421b-b3aa-45f2ec530d63"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "TraceSchreier"}]], \
"Input",ExpressionUUID->"9eb1e59f-f8e1-4c72-980d-002d770e18b3"],

Cell[BoxData[
 StyleBox["\<\"TraceSchreier[p, Schreier[orbits, nu, w]] finds a permutation \
such that the image of the first point of the orbit of p is p.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977993-5455693",ExpressionUUID->"1d36a614-b56f-4ab1-9b12-\
8b19ccec1f1a"]
}, Open  ]],

Cell["This is algorithm 7.3 of Butler:", \
"Text",ExpressionUUID->"0bda1f16-0ebd-4d59-a6ce-729faa35004b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TraceSchreier", "::", "trace"}], 
   "=", "\"\<Cannot trace `1` with orbit `2`\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TraceSchreier", "[", 
    RowBox[{"p_Integer", ",", 
     RowBox[{"oS", ":", 
      RowBox[{"Schreier", "[", 
       RowBox[{"orbits___List", ",", "nu_", ",", "w_"}], "]"}]}]}], "]"}], ":=", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"First", "/@", 
        RowBox[{"{", "orbits", "}"}]}], ",", "p"}], "]"}], ",", "ID", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"p", "===", "0"}], ",", 
     RowBox[{"Throw", "[", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"TraceSchreier", "::", "trace"}], ",", "0", ",", "oS"}], 
       "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Length", "[", "nu", "]"}], "<", "p"}], ",", "ID", ",", 
     "\[IndentingNewLine]", "True", ",", 
     RowBox[{"PermProduct", "[", 
      RowBox[{
       RowBox[{"TraceSchreier", "[", 
        RowBox[{
         RowBox[{"w", "[", 
          RowBox[{"[", "p", "]"}], "]"}], ",", "oS"}], "]"}], ",", 
       RowBox[{"nu", "[", 
        RowBox[{"[", "p", "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TraceSchreier", "[", 
    RowBox[{"p_Integer", ",", "os_Schreier"}], "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"TraceSchreier", "::", "trace"}], ",", "p", ",", "os"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"TraceSchreier", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "TraceSchreier", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"41b713d7-5a77-42f3-8b40-0b3854ae0ef5"],

Cell["Examples:", \
"Text",ExpressionUUID->"bcce83b3-9560-4efd-80f2-c9614ac15cb8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierOrbit", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SchreierOrbit", "[", 
     RowBox[{"1", ",", 
      RowBox[{"GenSet", " ", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "11"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"b", "\[Rule]", "\"\<b\>\""}], ",", 
      RowBox[{"c", "\[Rule]", "\"\<c\>\""}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Schreier", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "4", ",", "5", ",", "2", ",", "11", ",", "3", ",", "6", ",", 
       "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "\"\<c\>\"", ",", "\"\<c\>\"", ",", "\"\<a\>\"", 
       ",", "\"\<a\>\"", ",", "\"\<a\>\"", ",", "0", ",", "0", ",", "0", 
       ",", "\"\<c\>\"", ",", "\"\<a\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "4", ",", "2", ",", "1", ",", "4", ",", "11", ",", "0", ",", 
       "0", ",", "0", ",", "11", ",", "5"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"597cf2a3-d7aa-4269-868c-20fb38bf30b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierOrbit", ",", "9", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"79220060-6bc3-4cf3-b2d4-ea9514fc3dc9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TraceSchreier", ",", "\[IndentingNewLine]", 
   RowBox[{"TraceSchreier", "[", 
    RowBox[{"11", ",", 
     RowBox[{"SchreierOrbit", "[", 
      RowBox[{"1", ",", 
       RowBox[{"GenSet", " ", "[", 
        RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "11"}], "]"}]}], "]"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "11", ",", "3", ",", "4", ",", "6", ",", "2", ",", "5", ",", 
       "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e30a39d0-7fca-4f4a-a9d0-e1c1f75fba67"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TraceSchreier", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"e057401d-fc6a-482c-8414-d4107aa7d0e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermPower", ",", "\[IndentingNewLine]", 
   RowBox[{"PermPower", "[", 
    RowBox[{"a", ",", "3"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "11", ",", "3", ",", "4", ",", "6", ",", "2", ",", "5", ",", 
       "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"b57288c2-52aa-465e-b94e-79d6f372bc47"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermPower", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"905eff17-2e3f-4f72-a488-659c07904f9c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TraceSchreier", ",", "\[IndentingNewLine]", 
   RowBox[{"TraceSchreier", "[", 
    RowBox[{"11", ",", 
     RowBox[{"SchreierOrbits", "[", 
      RowBox[{
       RowBox[{"GenSet", "[", 
        RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "11"}], "]"}]}], "]"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "11", ",", "3", ",", "4", ",", "6", ",", "2", ",", "5", ",", 
       "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"013b2865-a4d9-4b40-bc29-2fdb3af335d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TraceSchreier", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"644cea04-a8f8-4d82-815b-7b8c1c2e7736"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OnPoints", ",", "\[IndentingNewLine]", 
   RowBox[{"OnPoints", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "1", ",", "11", ",", "3", ",", "4", ",", "6", ",", "2", ",", "5", ",",
          "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "8"}], "}"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "11"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"2f60d6a6-9cd3-4db1-8554-b4bc12cc5d30"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OnPoints", ",", "19", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"72b8f5d3-3ede-4651-8e20-da5bb3e587b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TraceSchreier", ",", "\[IndentingNewLine]", 
   RowBox[{"TraceSchreier", "[", 
    RowBox[{"1", ",", 
     RowBox[{"SchreierOrbit", "[", 
      RowBox[{"1", ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "11"}], "]"}]}], "]"}],
    ",", "\[IndentingNewLine]", "ID"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7dbf7479-0138-4687-9e09-616f1af918a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TraceSchreier", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"c5bc90a0-d88f-4a55-8a80-9b68fd1616d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"TraceSchreier", "[", 
   RowBox[{"8", ",", 
    RowBox[{"SchreierOrbit", "[", 
     RowBox[{"1", ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "11"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"044dd764-9667-416a-a9dc-73dfc2a72ac1"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"TraceSchreier", "::", "trace"}], "MessageName"], ":", 
  " ", "\<\"Cannot trace \[NoBreak]\\!\\(0\\)\[NoBreak] with orbit \[NoBreak]\
\\!\\(Schreier[\\(\\(\\(\\({1, 4, 5, 2, 11, 3, 6, 10}\\)\\), \\(\\({0, \
\\(\\(Cycles[\\(\\(\\(\\({1, 4, 2, 3}\\)\\), \\(\\({5, 11, 10, \
6}\\)\\)\\)\\)]\\)\\), \\(\\(Cycles[\\(\\(\\(\\({1, 4, 2, 3}\\)\\), \\(\\({5, \
11, 10, 6}\\)\\)\\)\\)]\\)\\), \\(\\(Cycles[\\(\\(\\(\\({1, 4, 5, 11, 6, 10, \
3, 2}\\)\\), \\(\\({7, 8}\\)\\)\\)\\)]\\)\\), \\(\\(Cycles[\\(\\(\\(\\({1, 4, \
5, 11, 6, 10, 3, 2}\\)\\), \\(\\({7, 8}\\)\\)\\)\\)]\\)\\), \
\\(\\(Cycles[\\(\\(\\(\\({1, 4, 5, 11, 6, 10, 3, 2}\\)\\), \\(\\({7, 8}\\)\\)\
\\)\\)]\\)\\), 0, 0, 0, \\(\\(Cycles[\\(\\(\\(\\({1, 4, 2, 3}\\)\\), \
\\(\\({5, 11, 10, 6}\\)\\)\\)\\)]\\)\\), \\(\\(Cycles[\\(\\(\\(\\({1, 4, 5, \
11, 6, 10, 3, 2}\\)\\), \\(\\({7, 8}\\)\\)\\)\\)]\\)\\)}\\)\\), \\(\\({0, 4, \
2, 1, 4, 11, 0, 0, 0, 11, 5}\\)\\)\\)\\)]\\)\[NoBreak] \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/trace\\\", \
ButtonNote -> \\\"xAct`xPerm`TraceSchreier::trace\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"f6c17b6c-f9d8-444e-a3bf-226b5b0a8b52"]
}, Open  ]],

Cell["Note the following particular cases:", \
"Text",ExpressionUUID->"65d53d97-44d6-497c-af30-5a3a655de8bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"TraceSchreier", ",", "\[IndentingNewLine]", 
   RowBox[{"TraceSchreier", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Schreier", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "ID"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"5ddbf445-bf85-4c0e-91b2-6446f4ef0ea5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TraceSchreier", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"e4f7ba5d-69b5-4e83-9b88-6adcb40adaf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"TraceSchreier", "[", 
   RowBox[{"2", ",", 
    RowBox[{"Schreier", "[", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f940dc8c-c8cb-4a90-907f-741ad422efb7"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"TraceSchreier", "::", "trace"}], "MessageName"], ":", 
  " ", "\<\"Cannot trace \[NoBreak]\\!\\(0\\)\[NoBreak] with orbit \[NoBreak]\
\\!\\(Schreier[\\(\\(\\(\\({1}\\)\\), \\(\\({0, 0, 0}\\)\\), \\(\\({0, 0, \
0}\\)\\)\\)\\)]\\)\[NoBreak] \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/trace\\\", ButtonNote -> \
\\\"xAct`xPerm`TraceSchreier::trace\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"a2a38bbb-9fac-4868-bb0a-b115b5f71210"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.2. StabilizerChain", \
"Subsection",ExpressionUUID->"983315c6-1882-4114-a12d-fb385f19f8cd"],

Cell[CellGroupData[{

Cell["4.2.0. Comments", \
"Subsubsection",ExpressionUUID->"1f44decc-1911-418b-928d-a71397e8200a"],

Cell["\<\
In the MathLink connection section we shall give a definition for \
StrongGenSet with three arguments.\
\>", "Text",ExpressionUUID->"cba990cb-ecac-40eb-bd6c-c1b4b0a0b23e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"StrongGenSet", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "StrongGenSet", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d96828af-90a3-4ea8-ba0b-cd24814696cd"],

Cell["\<\
Now we deal with the stabilizing part of the SGSs. The key idea is that a SGS \
allows the construction of a hierarchy of subgroups: the stabilizers of \
consecutive points in the base.\
\>", "Text",ExpressionUUID->"03a5f4f3-9631-4612-bd1e-4ca2f6c8dd63"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.2.1. StabilizerChain", \
"Subsubsection",ExpressionUUID->"052c2edb-d95a-4532-8ce6-3f0f568db521"],

Cell["\<\
This function gives the chain of stabilizers associated to a SGS. There is no \
check of validity of the initial pair (base, GS):\
\>", "Text",ExpressionUUID->"b0c55de9-d6fa-4ee2-9289-fe1ab2781ad4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "StabilizerChain"}]], \
"Input",ExpressionUUID->"ef0ec1f0-506c-4c69-b8df-d512df138e29"],

Cell[BoxData[
 StyleBox["\<\"StabilizerChain[SGS] gives a list of strong generating sets \
corresponding to the chain of stabilizers of the group generated by SGS. The \
first one is SGS and the last one is the generating set of Group[ID].\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977994-5455693",ExpressionUUID->"5e5ec93f-81c7-436d-be0f-\
0fa04a3e566b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StabilizerChain", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{"base_List", ",", "GS_GenSet"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"DeleteCases", "[", 
        RowBox[{"base", ",", 
         RowBox[{"Alternatives", "@@", "#"}]}], "]"}], ",", 
       RowBox[{"Stabilizer", "[", 
        RowBox[{"#", ",", "GS"}], "]"}]}], "]"}], "&"}], "/@", 
    RowBox[{"FoldList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Append", "[", 
        RowBox[{"#1", ",", "#2"}], "]"}], "&"}], ",", 
      RowBox[{"{", "}"}], ",", "base"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"StabilizerChain", "[", 
    RowBox[{"sym", ":", 
     RowBox[{"(", 
      RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], "]"}], ":=", 
   RowBox[{"StabilizerChain", "[", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "sym"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"StabilizerChain", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "StabilizerChain", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"46854fda-147f-439a-aa4d-9bb824f2e63d"],

Cell["\<\
If there are no generators, the orbits have trivial structure:\
\>", "Text",ExpressionUUID->"07d4203e-7a94-4d00-8511-0511ee018365"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"afadeab7-8e93-4eff-b925-11ae05e51b49"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "2", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 2}, 
     xAct`xPerm`GenSet[]], 
    xAct`xPerm`StrongGenSet[{2}, 
     xAct`xPerm`GenSet[]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"d40c0149-8fe6-4b43-ac01-ffb24217d6d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"de4817d7-7112-4f25-aa9a-62cdec6cc9cc"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"af01ac52-e40e-418a-9c29-34da5b57e072"]
}, Open  ]],

Cell["\<\
Note that the first SGS is the original SGS and the last one is the empty SGS \
(generating Group[ID]):\
\>", "Text",ExpressionUUID->"8855423b-7f2e-44a6-835c-a0e5fab7457f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], 
         "}"}], "]"}]}], "]"}]}], "]"}], "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"a8ea2fbe-d341-425a-8759-eb14a1fd14e3"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Perm", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], 
           "}"}], "]"}], ",", 
         RowBox[{"Perm", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
           "}"}], "]"}], ",", 
         RowBox[{"Perm", "[", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], 
           "}"}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "3", "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
          "}"}], "]"}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Perm[{2, 1, 3, 4, 6, 5}], 
      xAct`xPerm`Perm[{1, 2, 4, 3, 6, 5}], 
      xAct`xPerm`Perm[{3, 4, 1, 2, 5, 6}]]], 
    xAct`xPerm`StrongGenSet[{3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Perm[{1, 2, 4, 3, 6, 5}]]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"a829d466-5d22-428d-becb-3732edf7c2f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], 
         "}"}], "]"}]}], "]"}]}], "]"}], "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"b2fec384-3ebb-4423-af47-84d57a80988e"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Perm", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], 
           "}"}], "]"}], ",", 
         RowBox[{"Perm", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
           "}"}], "]"}], ",", 
         RowBox[{"Perm", "[", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], 
           "}"}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
          "}"}], "]"}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
          "}"}], "]"}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "4", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 2, 3, 4}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Perm[{2, 1, 3, 4, 6, 5}], 
      xAct`xPerm`Perm[{1, 2, 4, 3, 6, 5}], 
      xAct`xPerm`Perm[{3, 4, 1, 2, 5, 6}]]], 
    xAct`xPerm`StrongGenSet[{2, 3, 4}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Perm[{1, 2, 4, 3, 6, 5}]]], 
    xAct`xPerm`StrongGenSet[{3, 4}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Perm[{1, 2, 4, 3, 6, 5}]]], 
    xAct`xPerm`StrongGenSet[{4}, 
     xAct`xPerm`GenSet[]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"003157f7-ab64-4a08-9aaf-e0e32040df63"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.3. Inductive foundation", \
"Subsection",ExpressionUUID->"1d315fce-6435-4d26-9af9-d0ec4d1aa16e"],

Cell[CellGroupData[{

Cell["4.3.0. Comments", \
"Subsubsection",ExpressionUUID->"83ee64b0-8537-4757-934c-b2befef8fa7a"],

Cell["\<\
Here we construct a number of commands which perform simple tasks using \
strong generating sets.

This is essentially chapter 10 of Butler's book. There are lots of examples \
there, which have been repeated (and some of them corrected) in the companion \
notebook ButlerExamples.nb.\
\>", "Text",ExpressionUUID->"867af8c3-b10c-470c-9998-39bf6d3a0bed"],

Cell["\<\
Recall that given the SGS of a group G with base {b1, b2, ..., bk} we can \
construct a hierarchy of stabilizers
\t\t\t{id} = Gk+1 < Gk < ... < G2 < G1 = G
where Gi is the stabilizer of the points {b1, ..., bi-1}. The notation is \
horrible because it should have been G0 = G and Gk = {id}, etc.

The group G1=G is divided in the subroup G2 (the stabilizer of b1) and its \
cosets. There is a one-to-one correspondence between those cosets and the \
points of the orbit b1^G. We select the smallest permutation u of those \
cosets, that will represent the coset in all of the following computations. \
Given any permutation g in G we compute b1^g; if we get b1 then that means \
that g is in G2 (the stabilizer of b1), but if we get another point in the \
orbit of b1 then we know that the permutation g belongs to the corresponding \
right coset G2 x g. If u is the representant of that coset, then h = g x u^-1 \
belongs to G2. Note that b1^g = b1^(h x u) = (b1^h)^u = b1^u. Now we can \
repeat the same process starting with the permutation h and the group G2, for \
which we have a SGS with base {b2, b3, ..., bk}. The length of the orbit b1^G \
is the number of cosets G:G2. Then the length of the orbit b2^G2 is the \
number of cosets G2:G3, etc. Finally the length of the orbit bk^Gk is the \
number of cosets Gk:{id}, which is the order of Gk. The orbit Delta^(i) = \
bi^Gi is called the basic orbit i and its length is called the basic index i.\
\
\>", "Text",ExpressionUUID->"fca0df69-717a-47ee-aa93-3185ccc5a0da"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.3.1. OrderOfGroup", \
"Subsubsection",ExpressionUUID->"b1ac2ee6-b099-44d9-9187-e9e1d3c4b654"],

Cell["\<\
This recursive function just multiplies the lengths of the basic orbits of \
the SGSs in the chain of stabilizers:\
\>", "Text",ExpressionUUID->"f580b4dd-cbe8-49c6-ae5a-c3a974860baf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "OrderOfGroup"}]], \
"Input",ExpressionUUID->"725ffbb8-af68-453b-bb17-dca0e7b666e9"],

Cell[BoxData[
 StyleBox["\<\"OrderOfGroup[SGS] gives the order of the group generated by \
SGS.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977995-5455693",ExpressionUUID->"8f8209f8-c1b3-49fc-bf0a-\
b01a29f1fc48"]
}, Open  ]],

Cell["\<\
Note that there are no options in OrderOfGroup, but we can pass the MathLink \
option to Orbit:\
\>", "Text",ExpressionUUID->"29b1a196-36b3-4f4a-aabd-4b7a234dc2e9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OrderOfGroup", "::", "nobase"}], 
   "=", "\"\<Found strong generating set with empty base but generators `1`. \
Assigning ficticious order 0.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OrderOfGroup", "[", 
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "___", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "options___"}], "]"}], ":=",
    "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OrderOfGroup", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "GS_GenSet"}], "]"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"OrderOfGroup", "::", "nobase"}], ",", "GS"}], "]"}], ";", 
     "0"}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OrderOfGroup", "[", 
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_List", ",", "GS_GenSet"}], "]"}], ",", "options___"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"Orbit", "[", 
      RowBox[{
       RowBox[{"First", "[", "base", "]"}], ",", "GS", ",", "options"}], 
      "]"}], "]"}], 
    RowBox[{"OrderOfGroup", "[", 
     RowBox[{
      RowBox[{"StrongGenSet", "[", 
       RowBox[{
        RowBox[{"Rest", "[", "base", "]"}], ",", 
        RowBox[{"Stabilizer", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"First", "[", "base", "]"}], "}"}], ",", "GS"}], "]"}]}], 
       "]"}], ",", "options"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"OrderOfGroup", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Symmetric", "|", "Antisymmetric"}], ")"}], "[", "list_List", 
     "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Length", "[", "list", "]"}], "!"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"OrderOfGroup", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "OrderOfGroup", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e036d71b-0fa1-43a6-ab94-1ef7de643797"],

Cell["Examples:", \
"Text",ExpressionUUID->"3f8b9abe-8405-46cf-8ad7-032456aa30a6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OrderOfGroup", ",", "\[IndentingNewLine]", 
   RowBox[{"OrderOfGroup", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], 
          "}"}], "]"}], ",", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
          "}"}], "]"}], ",", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], 
          "}"}], "]"}]}], "]"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "8"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"88b3683e-2018-4f7c-9286-d02063f523ca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OrderOfGroup", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"2631abf3-ac33-4577-9753-f0f9bb857fe0"]
}, Open  ]],

Cell["If there are no generators the group is just {ID}:", \
"Text",ExpressionUUID->"6bd7f548-7618-4f17-b0a3-45248e5061b2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OrderOfGroup", ",", "\[IndentingNewLine]", 
   RowBox[{"OrderOfGroup", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "1"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"cd3e353e-9193-43f9-b7a4-55896c8f434e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OrderOfGroup", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"34932bb8-75f8-4adc-9ba5-b9b7abb6325c"]
}, Open  ]],

Cell["\<\
Note that redundant points in the base do not change the result:\
\>", "Text",ExpressionUUID->"a30d2488-bce7-4d5e-b436-6ad41b497155"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OrderOfGroup", ",", "\[IndentingNewLine]", 
   RowBox[{"OrderOfGroup", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], 
          "}"}], "]"}], ",", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
          "}"}], "]"}], ",", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], 
          "}"}], "]"}]}], "]"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "8"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"b9d4bb07-595b-4e75-b316-ccbe1b50a101"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OrderOfGroup", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"0c3e0915-4fab-467c-b27b-4afdebd58441"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"OrderOfGroup", ",", "\[IndentingNewLine]", 
   RowBox[{"OrderOfGroup", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "1"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"887fe41f-d220-44fc-83a8-93a85785582d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OrderOfGroup", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"673859cd-439b-44ad-97bd-d7ddc47fc361"]
}, Open  ]],

Cell["\<\
These are the SGSs involved in the canonicalization of products of n \
(anti)symmetric 2-tensors:\
\>", "Text",ExpressionUUID->"6567aac6-a257-427e-b6f9-9da083142aea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sgs", "[", "n_", "]"}], ":=", 
  RowBox[{"StrongGenSet", "[", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"1", ",", 
      RowBox[{
       RowBox[{"2", "n"}], "-", "1"}], ",", "2"}], "]"}], ",", 
    RowBox[{"GenSet", "@@", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"i", "+", "1"}]}], "}"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{
            RowBox[{"2", "n"}], "-", "1"}], ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"i", "+", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", 
             RowBox[{"i", "+", "3"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{
            RowBox[{"2", "n"}], "-", "3"}], ",", "2"}], "}"}]}], "]"}]}], 
      "]"}]}]}], 
   "]"}]}]], "Input",ExpressionUUID->"55f7a42d-29a1-48ca-beec-d41c5e1bff54"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sgs", "[", "3", 
  "]"}]], "Input",ExpressionUUID->"cdbd85d4-1054-4f67-8238-81e21a23f27c"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "6"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"66c3ab6f-56ae-4469-a702-dcd5c25e552b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrderOfGroup", "[", 
    RowBox[{"sgs", "[", "#", "]"}], "]"}], "&"}], "/@", 
  RowBox[{
  "Range", "[", "25", 
   "]"}]}]], "Input",ExpressionUUID->"5618cea2-2dc9-4b9e-8898-cc8428da84ae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "8", ",", "48", ",", "384", ",", "3840", ",", "46080", ",", 
   "645120", ",", "10321920", ",", "185794560", ",", "3715891200", ",", 
   "81749606400", ",", "1961990553600", ",", "51011754393600", ",", 
   "1428329123020800", ",", "42849873690624000", ",", "1371195958099968000", ",",
    "46620662575398912000", ",", "1678343852714360832000", ",", 
   "63777066403145711616000", ",", "2551082656125828464640000", ",", 
   "107145471557284795514880000", ",", "4714400748520531002654720000", ",", 
   "216862434431944426122117120000", ",", "10409396852733332453861621760000", 
   ",", "520469842636666622693081088000000"}], 
  "}"}]], "Output",ExpressionUUID->"05240a7a-f5f6-41e3-acc4-1491a874813f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "N"}]], "Input",ExpressionUUID->"49ece3bb-5e38-4524-9a8c-1c43dc4fd53c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.`", ",", "8.`", ",", "48.`", ",", "384.`", ",", "3840.`", ",", "46080.`",
    ",", "645120.`", ",", "1.032192`*^7", ",", "1.8579456`*^8", ",", 
   "3.7158912`*^9", ",", "8.17496064`*^10", ",", "1.9619905536`*^12", ",", 
   "5.10117543936`*^13", ",", "1.4283291230208`*^15", ",", 
   "4.2849873690624`*^16", ",", "1.371195958099968`*^18", ",", 
   "4.662066257539891`*^19", ",", "1.6783438527143608`*^21", ",", 
   "6.377706640314571`*^22", ",", "2.5510826561258285`*^24", ",", 
   "1.071454715572848`*^26", ",", "4.714400748520531`*^27", ",", 
   "2.1686243443194444`*^29", ",", "1.0409396852733332`*^31", ",", 
   "5.204698426366666`*^32"}], 
  "}"}]], "Output",ExpressionUUID->"df812b6e-76f4-4b04-84af-0e7e0d21bee6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.3.2. Membership. PermMemberQ, PermWord", \
"Subsubsection",ExpressionUUID->"5b67694c-7aff-4f2c-be9e-5ca08c7c68b1"],

Cell["\<\
Recursive function that checks membership of a permutation in a group \
generated by a SGS:\
\>", "Text",ExpressionUUID->"c97baa82-d3f5-4bf5-8e50-b15434a99957"],

Cell["\<\
This is algorithm 10.2 of Butler. Algorithms 10.1 and 10.3 (which produce the \
same output) have not been implemented in xPerm.\
\>", "Text",ExpressionUUID->"b822e511-9533-4fcd-89df-e39f51ec1289"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermMemberQ"}]], \
"Input",ExpressionUUID->"c462efc3-cd38-4548-9682-cb1f74612861"],

Cell[BoxData[
 StyleBox["\<\"PermMemberQ[perm, SGS] gives True if permutation perm belongs \
to the group generated by SGS, and False otherwise.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977998-5455693",ExpressionUUID->"a72a8079-d7b5-4a9a-bcb7-\
918b383baf96"]
}, Open  ]],

Cell["\<\
This function is iterative, with output {residue, word}, and needs to store \
the previous stages of the computation, in the third argument.\
\>", "Text",ExpressionUUID->"bef62b3a-fc60-45ad-af63-e58ad4b9f4e3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermWord"}]], \
"Input",ExpressionUUID->"a9a597f8-386d-4457-8428-5262824b38ac"],

Cell[BoxData[
 StyleBox["\<\"PermWord[perm, SGS] decompose the permutation perm as {pk, \
..., p0} where each of the permutations pi belong to the stabilizer subgroup \
of the first i points of the base of SGS. If pk == ID then perm belongs to \
the group and not otherwise. There is a third argument, used internally for \
iteration.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977998-5455693",ExpressionUUID->"5006be29-0567-42df-9f3f-\
571790be039f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermWord", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_List", ",", "GS_GenSet"}], "]"}], ",", 
     RowBox[{"word_List", ":", 
      RowBox[{"{", "}"}]}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "base", "]"}], "===", "0"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Prepend", "[", 
      RowBox[{"word", ",", "perm"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Sorbit", "=", 
          RowBox[{"SchreierOrbit", "[", 
           RowBox[{
            RowBox[{"First", "[", "base", "]"}], ",", "GS", ",", 
            RowBox[{"Max", "[", 
             RowBox[{
              RowBox[{"PermDeg", "[", "perm", "]"}], ",", 
              RowBox[{"PermDeg", "[", "GS", "]"}]}], "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"point", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{
            RowBox[{"First", "[", "base", "]"}], ",", "perm"}], "]"}]}], ",", 
         "\[IndentingNewLine]", "u"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"First", "[", "Sorbit", "]"}], ",", "point"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"u", "=", 
           RowBox[{"TraceSchreier", "[", 
            RowBox[{"point", ",", "Sorbit"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"PermWord", "[", 
           RowBox[{
            RowBox[{"PermProduct", "[", 
             RowBox[{"perm", ",", 
              RowBox[{"InversePerm", "[", "u", "]"}]}], "]"}], ",", 
            RowBox[{"StrongGenSet", "[", 
             RowBox[{
              RowBox[{"Rest", "[", "base", "]"}], ",", 
              RowBox[{"Stabilizer", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"First", "[", "base", "]"}], "}"}], ",", "GS"}], 
               "]"}]}], "]"}], ",", 
            RowBox[{"Prepend", "[", 
             RowBox[{"word", ",", "u"}], "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Prepend", "[", 
          RowBox[{"word", ",", "perm"}], "]"}]}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermMemberQ", "[", 
    RowBox[{"perm_", ",", 
     RowBox[{"sym", ":", 
      RowBox[{"(", 
       RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}]}], "]"}], ":=", 
   
   RowBox[{"PermMemberQ", "[", 
    RowBox[{"perm", ",", 
     RowBox[{"SchreierSims", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "sym"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermMemberQ", "[", 
    RowBox[{"perm_", ",", "SGS_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"id", "=", 
        RowBox[{"ID", "[", "perm", "]"}]}], ",", 
       RowBox[{"first", "=", 
        RowBox[{"First", "@", 
         RowBox[{"PermWord", "[", 
          RowBox[{"perm", ",", "SGS"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"Or", "[", 
      RowBox[{
       RowBox[{"PermEqual", "[", 
        RowBox[{"first", ",", "id"}], "]"}], ",", 
       RowBox[{
        RowBox[{"PermEqual", "[", 
         RowBox[{"first", "===", 
          RowBox[{"-", "id"}]}], "]"}], "&&", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"SGS", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "first"}], "]"}]}]}], "]"}]}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermWord", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermMemberQ", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"PermWord", ",", "PermMemberQ"}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3a4bd614-f60c-49c3-8d88-a932820dbdb0"],

Cell["Special cases:", \
"Text",ExpressionUUID->"d61ef99c-d9a9-4b11-bf86-bf05504e8040"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermMemberQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermMemberQ", "[", 
    RowBox[{"ID", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"789eec8b-d3dd-465c-a57e-03b6268256ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermMemberQ", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"9ee38456-2387-4baf-804a-c2d50151a6bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermMemberQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermMemberQ", "[", 
    RowBox[{"ID", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"c1e77223-3679-4b68-9c9f-37afddbf4e24"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermMemberQ", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"2a8c4d96-31c0-4018-ae41-34adc59abeda"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermMemberQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermMemberQ", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"d81a6d9e-0f14-430a-835b-9ce5c4189dd9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermMemberQ", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"cce64449-ad63-4f3a-a78a-0bc787d3a405"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermMemberQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermMemberQ", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"ddd7a679-aabd-4be7-88af-f1c833b5f8da"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermMemberQ", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"fc934bd9-4abf-4ea5-87bc-6e15f178f2f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermMemberQ", ",", "\[IndentingNewLine]", 
   RowBox[{"PermMemberQ", "[", 
    RowBox[{
     RowBox[{"Rules", "[", "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"25728c54-76c4-4d88-a6d8-bebffbef94e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermMemberQ", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"88d9dc49-ff8d-4aa2-b5ba-15012c766ed5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermWord", ",", "\[IndentingNewLine]", 
   RowBox[{"PermWord", "[", 
    RowBox[{"ID", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"ID", ",", "ID"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"60ccec28-47a1-45da-81ad-76f3cb5478dd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermWord", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"becec8be-48d7-4d14-8aca-5e23f56fe97b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermWord", ",", "\[IndentingNewLine]", 
   RowBox[{"PermWord", "[", 
    RowBox[{"ID", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "ID", "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7bbb4221-a7c9-4f41-9ab8-fcc675cb0dde"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermWord", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"aed5f171-611a-47a5-bbb4-c563c880bc53"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermWord", ",", "\[IndentingNewLine]", 
   RowBox[{"PermWord", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "]"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"09709d15-e86c-4709-853e-0c0947aece5e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermWord", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"7bb47dfe-3494-48cf-b729-f661f3cb840a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermWord", ",", "\[IndentingNewLine]", 
   RowBox[{"PermWord", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "]"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"1313b913-18da-4d3f-923e-bf94b1485b2d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermWord", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"16ad82d2-046f-4df1-b1f7-f776ab40c6b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"PermWord", ",", "\[IndentingNewLine]", 
   RowBox[{"PermWord", "[", 
    RowBox[{
     RowBox[{"Rules", "[", "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Rules", "[", "]"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"7253c89c-7812-4fd5-9c91-1165af544606"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PermWord", ",", "5", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"89c5a160-e170-4f53-9d77-3df1cf15975a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.3.3. FromBaseImage", \
"Subsubsection",ExpressionUUID->"48728707-3e38-4dae-9938-c63afb45c75c"],

Cell["\<\
We know that a permutation is uniquely defined by the images of a base under \
that permutation. This function finds the permutation corresponding to a \
given list of images and a SGS.\
\>", "Text",ExpressionUUID->"78e10adb-4153-4d2f-9f8e-cd5fd7a3073b"],

Cell["This is algorithm 10.5 of Butler.", \
"Text",ExpressionUUID->"f4679ac6-519f-4cbc-b9d6-8874b79c3cda"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "FromBaseImage"}]], \
"Input",ExpressionUUID->"3016e032-1afa-49ae-9e4d-e6faa4f335a4"],

Cell[BoxData[
 StyleBox["\<\"FromBaseImage[list, SGS] gives the permutation in the group \
described by SGS such that the images of the points in the base are the \
points in list (assumed to have the length of the base of the SGS). If no \
permutation in the group gives the list of points then an error message is \
thrown. A third argument can be given with the length of the internal \
Schreier vectors used.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567977999-5455693",ExpressionUUID->"e0b3590a-559b-41ad-828a-\
edd574bea38f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FromBaseImage", "::", "noimgs"}], 
   "=", "\"\<Invalid list of images `1`.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FromBaseImage", "[", 
    RowBox[{"images_List", ",", 
     RowBox[{"sym", ":", 
      RowBox[{"(", 
       RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], ",", 
     "len___"}], "]"}], ":=", 
   RowBox[{"FromBaseImage", "[", 
    RowBox[{"images", ",", 
     RowBox[{"SchreierSims", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "sym"}], "]"}], ",", "len"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FromBaseImage", "[", 
    RowBox[{"images_List", ",", "SGS_StrongGenSet"}], "]"}], ":=", 
   RowBox[{"FromBaseImage", "[", 
    RowBox[{"images", ",", "SGS", ",", 
     RowBox[{"PermLength", "[", "SGS", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FromBaseImage", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "0"}], "]"}], ":=", "ID"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FromBaseImage", "[", 
    RowBox[{"images_List", ",", 
     RowBox[{"SGS", ":", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base_List", ",", "GS_GenSet"}], "]"}]}], ",", "len_Integer"}],
     "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", "u", ",", 
       RowBox[{"g", "=", "ID"}], ",", 
       RowBox[{"schvecs", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"SchreierOrbits", "[", 
           RowBox[{"#", ",", "len"}], "]"}], "&"}], "/@", 
         RowBox[{"StabilizerChain", "[", "SGS", "]"}]}]}], ",", 
       RowBox[{"imgs", "=", "images"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "images", "]"}], "=!=", 
         RowBox[{"Length", "[", "base", "]"}]}], ",", 
        RowBox[{"Throw", "[", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"FromBaseImage", "::", "noimgs"}], ",", "images"}], "]"}], 
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", 
         RowBox[{"Length", "[", "imgs", "]"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"schvecs", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
             RowBox[{"imgs", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ","}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"u", "=", 
          RowBox[{"TraceSchreier", "[", 
           RowBox[{
            RowBox[{"imgs", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"schvecs", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"g", "=", 
          RowBox[{"PermProduct", "[", 
           RowBox[{"u", ",", "g"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"imgs", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{"imgs", ",", 
            RowBox[{"InversePerm", "[", "u", "]"}]}], "]"}]}]}]}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{" ", 
         RowBox[{",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Throw", "[", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"FromBaseImage", "::", "noimgs"}], ",", "images"}], 
             "]"}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], "*)"}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"imgs", "\[Equal]", "base"}], ",", "g", ",", 
        RowBox[{"Throw", "[", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"FromBaseImage", "::", "noimgs"}], ",", "images"}], "]"}], 
         "]"}]}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"FromBaseImage", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "FromBaseImage", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"289b1398-8144-422b-bcbf-9cc2e7de8fea"],

Cell["Example:", \
"Text",ExpressionUUID->"ff8bea1c-0f65-415d-8e44-4fec95a15e30"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"GS", "=", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"7", ",", "8"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"9", ",", "10"}], "}"}], "]"}]}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "6"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "10"}], "}"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"base", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SGS", "=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{"base", ",", "GS"}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"0ff62a10-b47b-45ec-b0e1-d3490883ed19"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm", "=", 
  RowBox[{
  "PermProduct", "@@", 
   "GS"}]}]], "Input",ExpressionUUID->"e424255d-d688-4536-a588-3ef5b950a406"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cycles", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "10", ",", "7", ",", "6", ",", "3", ",", "2", ",", "9", ",", 
     "8", ",", "5", ",", "4"}], "}"}], 
   "]"}]}]], "Output",ExpressionUUID->"e93cde53-835d-4619-b8da-bbf6ade511cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{"base", ",", "perm"}], 
  "]"}]], "Input",ExpressionUUID->"fe63018c-d387-44a2-948c-08ad0772053b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "2", ",", "4", ",", "6", ",", "8"}], 
  "}"}]], "Output",ExpressionUUID->"d40de9e4-4ed2-4645-b5c3-835415fcd3c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"FromBaseImage", ",", "\[IndentingNewLine]", 
   RowBox[{"FromBaseImage", "[", 
    RowBox[{"%", ",", "SGS"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "10", ",", "7", ",", "6", ",", "3", ",", "2", ",", "9", ",", 
       "8", ",", "5", ",", "4"}], "}"}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"e3ae24fa-4c5a-400c-96d7-135e32c9655c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"FromBaseImage", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"a48ad87c-f543-4785-b3d9-b0b02577af45"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"word", "=", 
  RowBox[{"PermWord", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "10", ",", "7", ",", "6", ",", "3", ",", "2", ",", "9", ",", 
        "8", ",", "5", ",", "4"}], "}"}], "]"}]}], "\[IndentingNewLine]", ",",
     "SGS"}], 
   "]"}]}]], "Input",ExpressionUUID->"33959a55-f111-42ea-84af-c02c6ac77a0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cycles", "[", "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"9", ",", "10"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "10", ",", "8", ",", "6", ",", "4", ",", "2", ",", "9", ",", 
       "7", ",", "5", ",", "3"}], "}"}], "]"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"900cc4dd-068a-42b7-82a1-12e048d46de4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "@@", 
  "word"}]], "Input",ExpressionUUID->"42dfbcdd-25b0-402b-a439-30c6df256ee5"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cycles", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "10", ",", "7", ",", "6", ",", "3", ",", "2", ",", "9", ",", 
     "8", ",", "5", ",", "4"}], "}"}], 
   "]"}]}]], "Output",ExpressionUUID->"555b476d-30a2-43b6-994c-183283c0b4ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", 
  "perm"}]], "Input",ExpressionUUID->"61ff1929-c73e-4e18-96be-02c40c7dd25d"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"f7ea7a71-6b32-474d-b91d-d779f029670a"]
}, Open  ]],

Cell["\<\
Let us have a closer look at that example. The SGS gives the following chain \
of stabilizers:\
\>", "Text",ExpressionUUID->"207ac481-8ae8-4fbe-868d-be4ef7f77663"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"chain", "=", 
    RowBox[{"StabilizerChain", "[", "SGS", "]"}]}], ")"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"3d291de3-a7c5-4791-a329-6e49d232c732"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"5", ",", "6"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"7", ",", "8"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"9", ",", "10"}], "}"}], "]"}]}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"3", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "6"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"5", ",", "7"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"6", ",", "8"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"7", ",", "9"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"8", ",", "10"}], "}"}]}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5", ",", "7", ",", "9"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"5", ",", "6"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"7", ",", "8"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"9", ",", "10"}], "}"}], "]"}]}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"3", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "6"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"5", ",", "7"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"6", ",", "8"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"7", ",", "9"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"8", ",", "10"}], "}"}]}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "7", ",", "9"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"5", ",", "6"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"7", ",", "8"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"9", ",", "10"}], "}"}], "]"}]}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"5", ",", "7"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"6", ",", "8"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"7", ",", "9"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"8", ",", "10"}], "}"}]}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "9"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"7", ",", "8"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"9", ",", "10"}], "}"}], "]"}]}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"7", ",", "9"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"8", ",", "10"}], "}"}]}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "9", "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"-", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"9", ",", "10"}], "}"}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 3, 5, 7, 9}, 
     xAct`xPerm`GenSet[-xAct`xPerm`Cycles[{1, 2}], -
      xAct`xPerm`Cycles[{3, 4}], -xAct`xPerm`Cycles[{5, 6}], -
      xAct`xPerm`Cycles[{7, 8}], -xAct`xPerm`Cycles[{9, 10}], 
      xAct`xPerm`Cycles[{1, 3}, {2, 4}], 
      xAct`xPerm`Cycles[{3, 5}, {4, 6}], 
      xAct`xPerm`Cycles[{5, 7}, {6, 8}], 
      xAct`xPerm`Cycles[{7, 9}, {8, 10}]]], 
    xAct`xPerm`StrongGenSet[{3, 5, 7, 9}, 
     xAct`xPerm`GenSet[-xAct`xPerm`Cycles[{3, 4}], -
      xAct`xPerm`Cycles[{5, 6}], -xAct`xPerm`Cycles[{7, 8}], -
      xAct`xPerm`Cycles[{9, 10}], 
      xAct`xPerm`Cycles[{3, 5}, {4, 6}], 
      xAct`xPerm`Cycles[{5, 7}, {6, 8}], 
      xAct`xPerm`Cycles[{7, 9}, {8, 10}]]], 
    xAct`xPerm`StrongGenSet[{5, 7, 9}, 
     xAct`xPerm`GenSet[-xAct`xPerm`Cycles[{5, 6}], -
      xAct`xPerm`Cycles[{7, 8}], -xAct`xPerm`Cycles[{9, 10}], 
      xAct`xPerm`Cycles[{5, 7}, {6, 8}], 
      xAct`xPerm`Cycles[{7, 9}, {8, 10}]]], 
    xAct`xPerm`StrongGenSet[{7, 9}, 
     xAct`xPerm`GenSet[-xAct`xPerm`Cycles[{7, 8}], -
      xAct`xPerm`Cycles[{9, 10}], 
      xAct`xPerm`Cycles[{7, 9}, {8, 10}]]], 
    xAct`xPerm`StrongGenSet[{9}, 
     xAct`xPerm`GenSet[-xAct`xPerm`Cycles[{9, 10}]]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"61ee6984-aa6e-49b5-bac9-36c33ef03f5a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "/@", 
  "chain"}]], "Input",ExpressionUUID->"8c707eea-0981-4869-82a1-04e4a13e5786"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3840", ",", "384", ",", "48", ",", "8", ",", "2", ",", "1"}], 
  "}"}]], "Output",ExpressionUUID->"c4f938fd-4f80-447e-b768-e3e8696a5e8d"]
}, Open  ]],

Cell["\<\
The last permutation in the word is a permutation of the group, but not the \
first stabilizer. Previous perms in the word belong to more stabilizers. The \
last line shows simply the fact that the first element of the word (ID) \
belongs to the last stabilizer (the identity group).\
\>", "Text",ExpressionUUID->"edc967c1-0bb8-406d-aaba-10138d2689c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"PermMemberQ", ",", 
    RowBox[{"Reverse", "[", "word", "]"}], ",", "chain"}], "]"}], "//", 
  "MatrixForm"}]], \
"Input",ExpressionUUID->"e7f0286e-ecd1-4d5b-bfcb-f3a3e6d8313b"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"True", "False", "False", "False", "False", "False"},
     {"True", "True", "False", "False", "False", "False"},
     {"True", "True", "True", "False", "False", "False"},
     {"True", "True", "True", "True", "False", "False"},
     {"True", "True", "True", "True", "True", "False"},
     {"True", "True", "True", "True", "True", "True"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"d51ddb2e-09b2-47bc-89fe-e1406d59055f"]
}, Open  ]],

Cell["\<\
If the list of images does not correspond to an element of the group, then we \
get an error message:\
\>", "Text",ExpressionUUID->"7450dc8b-ac02-4872-bf3c-3a6bf091fb04"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"FromBaseImage", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "3", ",", "9", ",", "4"}], "}"}], ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{"base", ",", "GS"}], "]"}], ",", "10"}], 
   "]"}]}]], "Input",ExpressionUUID->"ee8773a7-54e3-4616-a339-c47fd8f6c351"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FromBaseImage", "::", "noimgs"}], "MessageName"], ":", 
  " ", "\<\"Invalid list of images \[NoBreak]\\!\\({5, 2, 3, 9, 4}\\)\
\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"58153a0c-b1ce-4015-b8a4-f4db595434a5"]
}, Open  ]],

Cell["We can get a residue:", \
"Text",ExpressionUUID->"9fffca01-eab9-45e1-9f2b-ca34987df8d7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"perm", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], "}"}],
     "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"eb11cc20-351e-4e23-8412-ca5a134a8a49"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermWord", "[", 
  RowBox[{"perm", ",", "SGS"}], 
  "]"}]], "Input",ExpressionUUID->"761e2072-63c8-49c7-a0ac-b8b0f482835e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "6", ",", "7"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"1b2d8d5b-bb0c-4347-a42f-ebb23613bf71"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "@@", 
  "%"}]], "Input",ExpressionUUID->"97594699-c5c8-430b-8122-ddb5baab8fe2"],

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
   "}"}], "]"}]], \
"Output",ExpressionUUID->"c0f50592-6554-49ff-9319-5385102cf7d1"]
}, Open  ]],

Cell["such that next permutation does belong to the group:", \
"Text",ExpressionUUID->"96e9164d-271d-403e-8f43-ec08861df1e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "@@", 
  RowBox[{
  "Rest", "[", "%%", 
   "]"}]}]], "Input",ExpressionUUID->"da6a2c5a-c8ae-4d9a-acb9-6c80052a4042"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}]}], 
   "]"}]}]], "Output",ExpressionUUID->"9acaf60c-8624-411f-b9ea-73b8e76383de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{"%", ",", "SGS"}], 
  "]"}]], "Input",ExpressionUUID->"e13c787b-4fe6-49cc-bab9-4137448e0d8d"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"a84133d5-e757-40fb-ad4e-10614b701c42"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"perm", "=."}], "\[IndentingNewLine]", 
 RowBox[{"GS", "=."}], "\[IndentingNewLine]", 
 RowBox[{"base", "=."}], "\[IndentingNewLine]", 
 RowBox[{"SGS", "=."}], "\[IndentingNewLine]", 
 RowBox[{"word", 
  "=."}]}], "Input",ExpressionUUID->"914a5255-4067-4d9b-ba51-1068e1d57ea2"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.3.4. Enumeration of all base images", \
"Subsubsection",ExpressionUUID->"b9801466-6308-4c11-8b37-aa0a80e789b2"],

Cell["This is algorithm 10.8 of Butler.", \
"Text",ExpressionUUID->"8343f7a7-035a-4ef8-81ee-94f3da55a864"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "AllBaseImages"}]], \
"Input",ExpressionUUID->"37bbb2cf-7319-4878-bb16-a108c723074b"],

Cell[BoxData[
 StyleBox["\<\"AllBaseImages[SGS] gives a complete list of rules baseimages \
-> perm, where baseimages is a list of images of the base of SGS and perm is \
its corresponding permutation, as would be given by FromBaseImage[baseimages, \
SGS]. A second argument can be given with the length of the Schreier vectors \
used.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567978001-5455693",ExpressionUUID->"6ed95006-c854-408b-9b27-\
9275ec886e35"]
}, Open  ]],

Cell["\<\
This function lists all elements of a group. Note that we use PermDeg and not \
PermLength because it produces shorter or equal Schreier vectors.\
\>", "Text",ExpressionUUID->"c0e9985c-39ac-4005-bf62-00369c48c8c9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AllBaseImages", "[", 
    RowBox[{"sym", ":", 
     RowBox[{"(", 
      RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], "]"}], ":=", 
   RowBox[{"AllBaseImages", "[", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "sym"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AllBaseImages", "[", 
    RowBox[{"SGS", ":", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_List", ",", "GS_GenSet"}], "]"}]}], "]"}], ":=", 
   RowBox[{"AllBaseImages", "[", 
    RowBox[{"SGS", ",", 
     RowBox[{"PermDeg", "[", "SGS", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AllBaseImages", "[", 
    RowBox[{
     RowBox[{"SGS", ":", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base_List", ",", "GS_GenSet"}], "]"}]}], ",", "len_Integer"}],
     "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"BaseImage", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Length", "[", "base", "]"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "ID", "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"SchreierOrbits", "[", 
        RowBox[{"#", ",", "len"}], "]"}], "&"}], "/@", 
      RowBox[{"StabilizerChain", "[", "SGS", "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"AllBaseImages", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "AllBaseImages", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a199699a-2a52-4488-82ed-6a1cdd27246b"],

Cell["Internal recursive part:", \
"Text",ExpressionUUID->"d6858fbb-f9bb-48a2-b1ca-f1539b38bc9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BaseImage", "[", 
    RowBox[{
    "i_", ",", "k_", ",", "points_List", ",", "word_List", ",", "schvecs_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "=", 
        RowBox[{"PermProduct", "@@", "word"}]}], ",", "ig", ",", "j", ",", 
       "u", ",", "Deltab"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"i", "\[Equal]", 
        RowBox[{"k", "+", "1"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"Rule", "[", 
         RowBox[{"points", ",", "g"}], "]"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ig", "=", 
         RowBox[{"InversePerm", "[", "g", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Deltab", "=", 
         RowBox[{"OnPoints", "[", 
          RowBox[{
           RowBox[{"schvecs", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "g"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "=", 
             RowBox[{"TraceSchreier", "[", 
              RowBox[{
               RowBox[{"OnPoints", "[", 
                RowBox[{
                 RowBox[{"Deltab", "[", 
                  RowBox[{"[", "j", "]"}], "]"}], ",", "ig"}], "]"}], ",", 
               RowBox[{"schvecs", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"BaseImage", "[", 
             RowBox[{
              RowBox[{"i", "+", "1"}], ",", "k", ",", 
              RowBox[{"Append", "[", 
               RowBox[{"points", ",", 
                RowBox[{"Deltab", "[", 
                 RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"u", ",", "g"}], "}"}], ",", "schvecs"}], "]"}]}], ",",
            "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "Deltab", "]"}]}], "}"}]}], "]"}], 
         "]"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"20fdd175-e86f-4744-abf4-44da8522d234"],

Cell["\<\
Examples. Note that not all combinations of images are allowed. For instance \
images {1,2} do not identify a valid permutation:\
\>", "Text",ExpressionUUID->"c7d19de3-3b34-4210-89f9-3a5ba252602e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AllBaseImages", "[", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
       RowBox[{"-", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}], "]"}], "//",
   "ColumnForm"}]], \
"Input",ExpressionUUID->"9408f224-f0e4-42e8-89e4-f9805b6125a4"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "ID"}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{{1, 3} -> 
    xAct`xPerm`ID, {1, 4} -> -xAct`xPerm`Cycles[{3, 4}], {2, 3} -> -
     xAct`xPerm`Cycles[{1, 2}], {2, 4} -> 
    xAct`xPerm`Cycles[{1, 2}, {3, 4}], {3, 1} -> 
    xAct`xPerm`Cycles[{1, 3}, {2, 4}], {3, 2} -> -
     xAct`xPerm`Cycles[{1, 3, 2, 4}], {4, 1} -> -
     xAct`xPerm`Cycles[{1, 4, 2, 3}], {4, 2} -> 
    xAct`xPerm`Cycles[{1, 4}, {2, 3}]}],
  Editable->
   False]], "Output",ExpressionUUID->"121d4a27-1abf-4ac5-90f7-477b5a38d2b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AllBaseImages", "[", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], "]"}], "//", 
  "Column"}]], "Input",ExpressionUUID->"33e8be77-2e6e-4324-8d95-793becd9ec13"],

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"AllBaseImages", "[", 
   RowBox[{"SchreierSims", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Antisymmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}], "]"}], 
  "]"}]], "Output",ExpressionUUID->"2d9e4e6a-1409-499c-80ad-8e7e9d3d908f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"FromBaseImage", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"00bbeacd-7091-40fe-a431-371214aacb0b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FromBaseImage", "::", "noimgs"}], "MessageName"], ":", 
  " ", "\<\"Invalid list of images \[NoBreak]\\!\\({1, \
2}\\)\[NoBreak].\"\>"}]], "Message", \
"MSG",ExpressionUUID->"b32df20c-c430-4bba-902f-1cd2d1c5eab9"]
}, Open  ]],

Cell["\<\
Note the order of the permutations. Ordering the bases with normal ordering, \
as we have just done produces also normal ordering in the group:\
\>", "Text",ExpressionUUID->"d7e65f37-ee65-4dce-90e4-a6a567beb8f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"group", "=", 
  RowBox[{"Dimino", "[", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"45b42137-1eca-4e71-850c-24def3980771"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], "]"}]}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"e5d24958-fcfa-400e-b321-e52888996052"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", "group", 
  "]"}]], "Input",ExpressionUUID->"3ac2624d-08af-4d84-a821-c326d66a82f8"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"3b4820f5-37e6-42ed-9ecf-e3c72f3ad2ee"]
}, Open  ]],

Cell["However, sorting with the base produces a different output:", \
"Text",ExpressionUUID->"cfa36a13-c67f-4fd1-8a50-9f1f48c47041"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", 
  RowBox[{"group", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"5e10244a-dad4-4878-81e1-10d1a232fcc9"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], "]"}]}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"990decfc-e4b6-45cd-ae28-d55c79ff8918"]
}, Open  ]],

Cell["\<\
v9 note : I have the impression that the ordering is not correct now...\
\>", "Text",ExpressionUUID->"69f94dab-ee8e-4f28-95bd-b40dc716a4e4"],

Cell["Special cases:", \
"Text",ExpressionUUID->"dea776c3-99a4-4f86-b7c3-77e79a43e18f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AllBaseImages", "[", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"f2b7aab3-e464-48cc-9315-f84c31cd8b97"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"{", "}"}], "\[Rule]", "ID"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{{} -> xAct`xPerm`ID}],
  Editable->
   False]], "Output",ExpressionUUID->"4e8baa85-25ad-40d7-a83b-2372c83d8e55"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AllBaseImages", "[", 
  RowBox[{"StrongGenSet", "[", 
   RowBox[{
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"GenSet", "[", "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"0242636f-13c6-4322-aab6-bc4c417c1751"],

Cell[BoxData[
 RowBox[{"{", 
  "}"}]], "Output",ExpressionUUID->"33ad132a-2463-4b2f-a36f-51803eeccec6"]
}, Open  ]],

Cell["The symmetric group. Here all base images are allowed:", \
"Text",ExpressionUUID->"adf2d1fe-24cc-41d8-bab8-6bcbc5354eed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SGS", "=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}], "]"}]}],
     "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"b36f9458-ebdc-4030-91bd-81e21d1d3cbe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AllBaseImages", "[", "SGS", "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"6d924f12-0415-48ad-8991-5ccfc25a7be6"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Rule]", "ID"}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "3"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2", ",", "1", ",", "3"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "3"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "2", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "2", ",", "3"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "3", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "3", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{{1, 2, 3} -> xAct`xPerm`ID, {1, 2, 4} -> 
    xAct`xPerm`Perm[{1, 2, 4, 3}], {1, 3, 2} -> 
    xAct`xPerm`Perm[{1, 3, 2, 4}], {1, 3, 4} -> 
    xAct`xPerm`Perm[{1, 4, 2, 3}], {1, 4, 2} -> 
    xAct`xPerm`Perm[{1, 3, 4, 2}], {1, 4, 3} -> 
    xAct`xPerm`Perm[{1, 4, 3, 2}], {2, 1, 3} -> 
    xAct`xPerm`Perm[{2, 1, 3, 4}], {2, 1, 4} -> 
    xAct`xPerm`Perm[{2, 1, 4, 3}], {2, 3, 1} -> 
    xAct`xPerm`Perm[{3, 1, 2, 4}], {2, 3, 4} -> 
    xAct`xPerm`Perm[{4, 1, 2, 3}], {2, 4, 1} -> 
    xAct`xPerm`Perm[{3, 1, 4, 2}], {2, 4, 3} -> 
    xAct`xPerm`Perm[{4, 1, 3, 2}], {3, 1, 2} -> 
    xAct`xPerm`Perm[{2, 3, 1, 4}], {3, 1, 4} -> 
    xAct`xPerm`Perm[{2, 4, 1, 3}], {3, 2, 1} -> 
    xAct`xPerm`Perm[{3, 2, 1, 4}], {3, 2, 4} -> 
    xAct`xPerm`Perm[{4, 2, 1, 3}], {3, 4, 1} -> 
    xAct`xPerm`Perm[{3, 4, 1, 2}], {3, 4, 2} -> 
    xAct`xPerm`Perm[{4, 3, 1, 2}], {4, 1, 2} -> 
    xAct`xPerm`Perm[{2, 3, 4, 1}], {4, 1, 3} -> 
    xAct`xPerm`Perm[{2, 4, 3, 1}], {4, 2, 1} -> 
    xAct`xPerm`Perm[{3, 2, 4, 1}], {4, 2, 3} -> 
    xAct`xPerm`Perm[{4, 2, 3, 1}], {4, 3, 1} -> 
    xAct`xPerm`Perm[{3, 4, 2, 1}], {4, 3, 2} -> 
    xAct`xPerm`Perm[{4, 3, 2, 1}]}],
  Editable->
   False]], "Output",ExpressionUUID->"d6702070-6929-4231-85f4-5f55b55fd1db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromBaseImage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "3"}], "}"}], ",", "SGS"}], 
  "]"}]], "Input",ExpressionUUID->"c0fa38f6-b4bf-4c63-ab96-3cec093e87e0"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "3", ",", "1"}], "}"}], 
  "]"}]], "Output",ExpressionUUID->"ba9e64d6-33dc-4ee6-bb18-3c53ac1d0817"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SGS", 
  "=."}]], "Input",ExpressionUUID->"c88c4776-8fb9-4f4e-943b-3a21df507e04"],

Cell["Let us now compare timings of Dimino and AllBaseImages:", \
"Text",ExpressionUUID->"4264e12c-d5a5-4ff7-b203-17a37e4a610b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SGS", "=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
     ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "3", ",", "2", ",", "4", ",", "5", ",", "6", ",", "7"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "4", ",", "3", ",", "5", ",", "6", ",", "7"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "5", ",", "4", ",", "6", ",", "7"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "5", ",", "7"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "7", ",", "6"}], 
         "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "7", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "1"}], 
         "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"5c50b4b6-aa47-4c81-85cc-3027fa249ac8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"permsMathematica", "=", 
    RowBox[{"Permutations", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
      "}"}], "]"}]}], ";"}], 
  "]"}]], "Input",ExpressionUUID->"962d7056-8f8d-4f3d-8407-395da2c8e383"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00011799999999999999508379366908172869`2.0924819205857492", ",", 
   "Null"}], 
  "}"}]], "Output",ExpressionUUID->"c1df7708-c0ae-4887-bfd5-787965b789ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"permsDimino", "=", 
    RowBox[{"Dimino", "[", 
     RowBox[{"SGS", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";"}], 
  "]"}]], "Input",ExpressionUUID->"5996e9dc-79fa-42dd-b18c-16063f4ef0c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.24029100000000000458832971617084695026`5.401337418067984", ",", "Null"}],
   "}"}]], "Output",ExpressionUUID->"ba55729b-1307-42f6-88c9-6668aeedd028"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"permsAllBases", "=", 
    RowBox[{"AllBaseImages", "[", "SGS", "]"}]}], ";"}], 
  "]"}]], "Input",ExpressionUUID->"92d79fe9-7109-45c9-aef8-345f0acbf06a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.01197099999999995389998730388469994068`6.025767980407482", ",", "Null"}],
   "}"}]], "Output",ExpressionUUID->"927c390b-3355-4b3e-b6e2-285442ddc031"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Length", "[", "permsMathematica", "]"}], ",", 
   RowBox[{"Length", "[", "permsDimino", "]"}], ",", 
   RowBox[{"Length", "[", "permsAllBases", "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"e9d5986d-179b-40f7-a1fc-4e50e1d6c416"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5040", ",", "5040", ",", "5040"}], 
  "}"}]], "Output",ExpressionUUID->"17ce1993-c1df-4063-98ad-397ced5716eb"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.4. Reordering points. Base-based ordering", \
"Subsection",ExpressionUUID->"f7fe3a24-c215-4351-8ab8-d5f7edee2f43"],

Cell["Example:", \
"Text",ExpressionUUID->"b214f933-092b-441f-9222-488b986a22d4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"GS", "=", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "4", ",", "3", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6", ",", "9", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "5", ",", "3", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "8", ",", "7", ",", "6"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "8"}], "}"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"base", "=", 
   RowBox[{"{", 
    RowBox[{"11", ",", "10", ",", "1", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SGS", "=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{"base", ",", "GS"}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"86f9e155-d07d-48a9-b87c-565b26494176"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "SGS", 
  "]"}]], "Input",ExpressionUUID->"a4b55f57-b8df-4ca7-b610-0535bc828e86"],

Cell[BoxData["7920"], \
"Output",ExpressionUUID->"1be964ab-4218-45f4-a946-266cdab693b9"]
}, Open  ]],

Cell["Take two permutations and their base images:", \
"Text",ExpressionUUID->"2efa12dd-5c4b-4ae3-a469-3b3bb4befbc5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm1", "=", 
  RowBox[{
  "PermProduct", "@@", 
   "GS"}]}]], "Input",ExpressionUUID->"370b1c31-7d0e-4af6-b777-5382a26512ae"],

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "4", ",", "9", ",", "6", ",", "8", ",", "5", ",", "2", ",", "7", 
    ",", "3", ",", "10", ",", "11"}], "}"}], 
  "]"}]], "Output",ExpressionUUID->"20fc6177-740d-4dd9-a876-f6535d23a7e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"baseimages1", "=", 
  RowBox[{"OnPoints", "[", 
   RowBox[{"base", ",", "perm1"}], 
   "]"}]}]], "Input",ExpressionUUID->"71e5a7fb-7dec-4d84-9bc9-0c3457d9d80a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "11", ",", "4", ",", "7"}], 
  "}"}]], "Output",ExpressionUUID->"29a58af9-7cdd-4c81-8476-d8e4babe72bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm2", "=", 
  RowBox[{"PermProduct", "@@", 
   RowBox[{"GS", "[", 
    RowBox[{"[", 
     RowBox[{"First", "@", 
      RowBox[{"RandomPerm", "[", "5", "]"}]}], "]"}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"ad45db77-81f3-442b-ade5-d27efc775af1"],

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "10", ",", "6", ",", "5", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "3", ",", "9", ",", "8"}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"597f0649-40f3-4b66-a68a-e7d350759f39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"baseimages2", "=", 
  RowBox[{"OnPoints", "[", 
   RowBox[{"base", ",", "perm2"}], 
   "]"}]}]], "Input",ExpressionUUID->"acaebd7c-82e3-4005-a3b9-129872f94c2a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "6", ",", "10", ",", "4"}], 
  "}"}]], "Output",ExpressionUUID->"448c0f56-0ba0-4f8d-86cc-afbfbf2632ed"]
}, Open  ]],

Cell["\<\
Now we can decide whether the permutations are sorted or not:\
\>", "Text",ExpressionUUID->"da5c4ec2-acd7-4fb0-83bb-70d2b1a8c771"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"comp", "[", 
    RowBox[{"i_", ",", "i_"}], "]"}], ":=", "Null"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"comp", "[", 
    RowBox[{"i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"i", "<", "j"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Catch", "@", 
  RowBox[{"Inner", "[", 
   RowBox[{"comp", ",", "baseimages1", ",", "baseimages2", ",", "List"}], 
   "]"}]}]}], "Input",ExpressionUUID->"6a855f6c-5d5a-499b-acbf-dd50c5a9bd0c"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"c17d98dd-4b5a-4a14-9647-5b29477379f2"]
}, Open  ]],

Cell["\<\
This is equivalent to lexicographic order of the permutations if we reorder \
the points so that the beginning of the set is given by the base:\
\>", "Text",ExpressionUUID->"ef96eb35-ec35-4d42-8486-6bde80b31b77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"points", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"base", ",", 
    RowBox[{
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"Range", "[", "11", "]"}], ",", "base"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"First", "@", 
       RowBox[{"RandomPerm", "[", "7", "]"}]}], "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"4911a57c-064f-4e34-8f48-b65bd9cce91b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "11", ",", "10", ",", "1", ",", "2", ",", "5", ",", "3", ",", "4", ",", "6",
    ",", "7", ",", "8", ",", "9"}], 
  "}"}]], "Output",ExpressionUUID->"d8486eb0-4093-4dbd-a894-3588daccf508"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"images1", "=", 
  RowBox[{"OnPoints", "[", 
   RowBox[{"points", ",", "perm1"}], 
   "]"}]}]], "Input",ExpressionUUID->"5e96525c-146a-4e16-9a50-b97621fbc6f8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "11", ",", "4", ",", "7", ",", "2", ",", "10", ",", "9", ",", "8",
    ",", "3", ",", "5", ",", "6"}], 
  "}"}]], "Output",ExpressionUUID->"3cf08350-ee35-4d45-9520-2d600141f660"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"images2", "=", 
  RowBox[{"OnPoints", "[", 
   RowBox[{"points", ",", "perm2"}], 
   "]"}]}]], "Input",ExpressionUUID->"0919ef29-fa07-4049-a2bc-7fd3fc37548a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "6", ",", "10", ",", "4", ",", "11", ",", "9", ",", "3", ",", "5",
    ",", "7", ",", "2", ",", "8"}], 
  "}"}]], "Output",ExpressionUUID->"473b9521-2abd-478c-aee0-40d1dd81b208"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Inner", "[", 
   RowBox[{"comp", ",", "images1", ",", "images2", ",", "List"}], 
   "]"}]}]], "Input",ExpressionUUID->"8f22127f-1e1f-4a32-86ba-ea4cb500a817"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"a3f98a2c-42f3-481a-a36a-666c769d37b4"]
}, Open  ]],

Cell["\<\
Note that the ordering of the points before mapping is independent of the \
order of points after mapping. In this example, for instance, we have used \
the ordering given by the base before mapping, and then the usual numeric \
order for integers.\
\>", "Text",ExpressionUUID->"623340fb-206e-4e86-9037-84c5ddcf2c65"],

Cell["\<\
However, the question is whether any ordering of the points after mapping has \
the identity as first element of a set of sorted permutations. We see that in \
our example that is false:\
\>", "Text",ExpressionUUID->"7e37b677-2ff6-43a1-bbb2-c4d5ae9921e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"perm0", "=", "ID"}], 
  ";"}]], "Input",ExpressionUUID->"211af279-53ed-48ab-a608-8cccccb4ccc2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"baseimages0", "=", 
  RowBox[{"OnPoints", "[", 
   RowBox[{"base", ",", "perm0"}], 
   "]"}]}]], "Input",ExpressionUUID->"398a01ab-d8ed-4c12-aaaa-ef9e22e85735"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11", ",", "10", ",", "1", ",", "2"}], 
  "}"}]], "Output",ExpressionUUID->"fabf548a-ce29-4c94-9095-9587691d93db"]
}, Open  ]],

Cell["\<\
Now we can decide whether the permutations are sorted or not:\
\>", "Text",ExpressionUUID->"46b0c9ea-fc81-4aef-8b58-2227e24e9401"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Inner", "[", 
   RowBox[{"comp", ",", "baseimages0", ",", "baseimages1", ",", "List"}], 
   "]"}]}]], "Input",ExpressionUUID->"0ead3785-80c3-47fc-874a-acf0f1bea8dd"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"ee7a151a-fd48-43e1-a0ef-9f182fcd82ce"]
}, Open  ]],

Cell["\<\
This is equivalent to lexicographic order of the permutations if we reorder \
the points so that the beginning of the set is given by the base:\
\>", "Text",ExpressionUUID->"f1ae994f-1ac4-4cc5-910f-404d1b31b610"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"images0", "=", 
  RowBox[{"OnPoints", "[", 
   RowBox[{"points", ",", "perm0"}], 
   "]"}]}]], "Input",ExpressionUUID->"8bb2da2b-0ac7-4830-91f9-78a98ea233bb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "11", ",", "10", ",", "1", ",", "2", ",", "5", ",", "3", ",", "4", ",", "6",
    ",", "7", ",", "8", ",", "9"}], 
  "}"}]], "Output",ExpressionUUID->"ae5f9913-4497-4673-a59c-2062abcb0159"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Inner", "[", 
   RowBox[{"comp", ",", "images0", ",", "images1", ",", "List"}], 
   "]"}]}]], "Input",ExpressionUUID->"806aa92c-1819-41ef-806d-cb409e803327"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"28439515-aa42-400c-8741-b4a6f57b1040"]
}, Open  ]],

Cell["\<\
Now we change to a new ordering based on the base, and now the identity is \
first:\
\>", "Text",ExpressionUUID->"40173da8-a7e4-40a9-8585-00e55f3edb1f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"compB", "[", 
    RowBox[{"i_", ",", "i_"}], "]"}], ":=", "Null"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"compB", "[", 
    RowBox[{"i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"LessB", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "j"}], "}"}], ",", "base"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Catch", "@", 
  RowBox[{"Inner", "[", 
   RowBox[{"compB", ",", "baseimages0", ",", "baseimages1", ",", "List"}], 
   "]"}]}]}], "Input",ExpressionUUID->"0c53a084-9232-4a2f-bfe8-17970940deaf"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"77be0c7f-b89b-4a06-850e-0cc8bc241a06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"Inner", "[", 
   RowBox[{"compB", ",", "images0", ",", "images1", ",", "List"}], 
   "]"}]}]], "Input",ExpressionUUID->"23380e9c-8d5e-4215-87aa-27aa4bbea13e"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e0bce08a-05ad-4a0f-8e2f-bfc4e44410b8"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.5. Backtrack search", \
"Subsection",ExpressionUUID->"349690bc-a576-4181-bc5a-011b00e83375"],

Cell[CellGroupData[{

Cell["4.5.0. Comments", \
"Subsubsection",ExpressionUUID->"eba7ffe3-d90a-47b1-a9fe-b0695849a936"],

Cell["\<\
Given a group G with a SGS we want to construct a subgroup H of G identifying \
another sgs for H with the same base. The subgroup H is identified by the \
decidable property P. The algorithm proceeds constructing subgroups Hi of the \
stabilizers Gi from the smallest stabilizers Gk, Gk-1, etc towards the \
largest stabilizers G2, G1. We first take the whole Gk-1 and construct Hk-1, \
checking P on all permutations of Gk-1. Now we go to Gk-2. The key point is \
that we do not have to check all permutations in Gk-2 \\ Gk-1 because we can \
use the cosets formed from the subgroup Hk-1. For example, if g is a \
permutation of Gk-2 obeying (or not obeying) the property P then it is clear \
that all permutations in Hk-1 x g will obey it too (or will not obey it \
either). This can be easily implemented through the use of base images.\
\>", "Text",ExpressionUUID->"4d3005ab-5dd0-476a-896f-8cf032dcaf57"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.5.1. Search and Generate", \
"Subsubsection",ExpressionUUID->"93af0442-587e-413b-a3b4-34ac0bfc5d18"],

Cell["\<\
The group G is described by its stabilizer-chain. The procedure is divided in \
two parts: there is a first routine constructing each stabilizer of the group \
K (function Search) and a recursive routine finding new permutations of their \
generating sets (funtion Generate). The \"property\" argument is a Boolean \
function acting on a permutation of G.\
\>", "Text",ExpressionUUID->"351da03d-a5e3-4c6e-b417-9ee3ce68df8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Search"}]], "Input",ExpressionUUID->"ce4b72c3-5d6c-4e04-8b31-dc13fd2580dc"],

Cell[BoxData[
 StyleBox["\<\"Search[SGS, P, s, SGSK] returns the s-th stabilizer in the \
stabilizer-chain of the subgroup K of permutations obeying the property P in \
the group G (described by the strong generating set SGS). It is assumed \
P[perm] returns True or False on any permutation of the group G. The fourth \
argument is a strong generating set for a subgroup of K, possibly a deeper \
stabilizer in its stabilizer-chain.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567978004-5455693",ExpressionUUID->"7d2a8652-19f2-4dd7-bd39-\
c8036dc0a91c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "Search", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"xPermVerbose", "\[Rule]", "False"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Search", "[", 
    RowBox[{
    "SGS_StrongGenSet", ",", "property_", ",", "s_Integer", ",", "SGSK_", ",",
      "options___"}], "]"}], ":=", 
   RowBox[{"Search", "[", 
    RowBox[{
     RowBox[{"StabilizerChain", "[", "SGS", "]"}], ",", "property", ",", "s", 
     ",", "SGSK", ",", "options"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Search", "[", 
    RowBox[{"chain_List", ",", "property_", ",", "s_Integer", ",", "SGSK_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"base", "=", 
        RowBox[{"chain", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"newSGSK", "=", "SGSK"}], ",", 
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"Length", "[", "chain", "]"}], "-", "1"}]}], ",", "Deltas", ",",
        "gammas", ",", "Korbit", ",", "verb"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"verb", "=", 
       RowBox[{"OptionValue", "[", "xPermVerbose", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"s", "\[Equal]", 
         RowBox[{"k", "+", "1"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"newSGSK", "=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{"base", ",", 
           RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"newSGSK", "=", 
          RowBox[{"Search", "[", 
           RowBox[{"chain", ",", "property", ",", 
            RowBox[{"s", "+", "1"}], ",", "SGSK", ",", "options"}], "]"}]}], ";",
          "\[IndentingNewLine]", 
         RowBox[{"Deltas", "=", 
          RowBox[{"Orbit", "[", 
           RowBox[{
            RowBox[{"base", "[", 
             RowBox[{"[", "s", "]"}], "]"}], ",", 
            RowBox[{"chain", "[", 
             RowBox[{"[", 
              RowBox[{"s", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Branching over points \>\"", ",", "Deltas"}], 
            "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Avoid", " ", "rechecking", " ", 
           RowBox[{"permutations", ".", " ", "Not"}], " ", "in", " ", 
           RowBox[{"Butler", "'"}], "s", " ", "algorithm"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"s", "=!=", "k"}], ",", 
           RowBox[{"Deltas", "=", 
            RowBox[{"Drop", "[", 
             RowBox[{"Deltas", ",", "1"}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"gammas", "=", 
             RowBox[{"Deltas", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"Korbit", "=", 
             RowBox[{"Orbit", "[", 
              RowBox[{"gammas", ",", 
               RowBox[{"newSGSK", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"gammas", "===", 
               RowBox[{"MinB", "[", 
                RowBox[{"Korbit", ",", "base"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"newSGSK", "=", 
                RowBox[{"Generate", "[", 
                 RowBox[{"chain", ",", "property", ",", "s", ",", 
                  RowBox[{"s", "+", "1"}], ",", 
                  RowBox[{"Append", "[", 
                   RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"base", ",", 
                    RowBox[{"s", "-", "1"}]}], "]"}], ",", "gammas"}], "]"}], 
                  ",", "newSGSK", ",", "verb"}], "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Head", "[", "newSGSK", "]"}], "===", "Times"}], ",", 
                 RowBox[{"newSGSK", "=", 
                  RowBox[{"-", "newSGSK"}]}]}], "]"}]}]}], "]"}]}], 
           "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "Deltas", "]"}]}], "}"}]}], "]"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "newSGSK"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Search", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Search", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"14adc0e9-03f9-4153-a740-48aed6b35941"],

Cell["\<\
When a new permutation is added to the SGS of K then we must return to \
Search, independently from the recursion level of Generate. To do that we use \
a dirty trick: marking the SGS of K with a minus sign in front.\
\>", "Text",ExpressionUUID->"4b261dc7-0ce9-4c2c-8521-ebc18ad470e1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Generate", "[", 
    RowBox[{
    "chain_List", ",", "property_", ",", "s_", ",", "i_", ",", "list_", ",", 
     "SGSK_", ",", "verb_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"base", "=", 
        RowBox[{"chain", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"k", "=", 
        RowBox[{
         RowBox[{"Length", "[", "chain", "]"}], "-", "1"}]}], ",", "g", ",", 
       RowBox[{"newSGSK", "=", "SGSK"}], ",", "Deltag", ",", "gammai", ",", 
       "otherSGSK"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g", "=", 
       RowBox[{"FromBaseImage", "[", 
        RowBox[{"list", ",", 
         RowBox[{"ReplacePart", "[", 
          RowBox[{
           RowBox[{"chain", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"Take", "[", 
            RowBox[{"base", ",", 
             RowBox[{"Length", "[", "list", "]"}]}], "]"}], ",", "1"}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i", "\[Equal]", 
         RowBox[{"k", "+", "1"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            
            RowBox[{"\"\<Generate at level \>\"", ",", "s", 
             ",", "\"\< with i=\>\"", ",", "i", ",", "\"\<. We have list \>\"",
              ",", "list", ",", "\"\< and permutation \>\"", ",", "g"}], 
            "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Not", "@", 
             RowBox[{"PermEqual", "[", 
              RowBox[{"g", ",", "ID"}], "]"}]}], "&&", 
            RowBox[{"property", "[", "g", "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"newSGSK", "=", 
             RowBox[{"-", 
              RowBox[{"StrongGenSet", "[", 
               RowBox[{
                RowBox[{"First", "@", "SGSK"}], ",", 
                RowBox[{"Append", "[", 
                 RowBox[{
                  RowBox[{"Last", "[", "SGSK", "]"}], ",", "g"}], "]"}]}], 
               "]"}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"verb", ",", 
              RowBox[{"Print", "[", 
               RowBox[{"\"\<  Added permutation \>\"", ",", "g"}], "]"}]}], 
             "]"}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Deltag", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{
            RowBox[{"Orbit", "[", 
             RowBox[{
              RowBox[{"base", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"chain", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}], ",", "g"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"verb", ",", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<Generating over points \>\"", ",", "Deltag"}], 
            "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"gammai", "=", 
             RowBox[{"Deltag", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"newSGSK", "=", 
             RowBox[{"Generate", "[", 
              RowBox[{"chain", ",", "property", ",", "s", ",", 
               RowBox[{"i", "+", "1"}], ",", 
               RowBox[{"Append", "[", 
                RowBox[{"list", ",", "gammai"}], "]"}], ",", "newSGSK", ",", 
               "verb"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Head", "[", "newSGSK", "]"}], "===", "Times"}], ",", 
              RowBox[{"Break", "[", "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "Deltag", "]"}]}], "}"}]}], "]"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "newSGSK"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fa9153f6-64a5-4d87-a661-d3d2eb51a3ce"],

Cell["\<\
Butler has additional improvements based on restrictions on image points, but \
we do not implement that here.\
\>", "Text",ExpressionUUID->"d75465e5-d9ac-4a96-b4ab-80efb509fd3e"],

Cell["Example: All permutations:", \
"Text",ExpressionUUID->"a77e5e7b-196e-4f7b-a525-474b35199a93"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Search", "[", 
  RowBox[{
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "3", ",", "4", ",", "1"}], "}"}], 
        "]"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"True", "&"}], ",", "1", ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "True"}]}], 
  "]"}]], "Input",ExpressionUUID->"44205eaa-7e42-4219-bad0-6badab27987e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}],
  SequenceForm["Branching over points ", {4, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"822d00e9-9c65-47f0-9543-400af5875a06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   "ID"}],
  SequenceForm[
  "Generate at level ", 4, " with i=", 5, ". We have list ", {1, 2, 3, 4}, 
   " and permutation ", xAct`xPerm`ID],
  Editable->
   False]], "Print",ExpressionUUID->"7995406c-ed2a-45fd-b584-0f2664553df8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 4, " with i=", 5, ". We have list ", {1, 2, 3, 5}, 
   " and permutation ", 
   xAct`xPerm`Perm[{1, 2, 3, 5, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"759ab061-ab25-4a3a-bca0-387355595676"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Perm[{1, 2, 3, 5, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"4e7fcf9b-3f4b-490b-b3e1-f981d1a55e3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}],
  SequenceForm["Branching over points ", {3, 4, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"e6460e4f-d957-49f4-b29f-5fd5dd542026"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Generating over points ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"20d468ac-cd8d-487c-8bef-7812913f48c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 3, " with i=", 5, ". We have list ", {1, 2, 4, 3}, 
   " and permutation ", 
   xAct`xPerm`Perm[{1, 2, 4, 3, 5}]],
  Editable->
   False]], "Print",ExpressionUUID->"56af0290-6864-46eb-b35c-1b2af3294e25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Perm[{1, 2, 4, 3, 5}]],
  Editable->
   False]], "Print",ExpressionUUID->"f9742ffe-ecf4-4675-b8a1-7b2f9effe9b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}]}],
  SequenceForm["Branching over points ", {2, 3, 4, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"420adf8b-61c7-4fea-b5a5-4cdec2ced662"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "5"}], "}"}]}],
  SequenceForm["Generating over points ", {2, 4, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"00ed0db0-c0e6-4709-b19e-6ed581d22ea9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}],
  SequenceForm["Generating over points ", {4, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"29db09ff-759e-46d7-b0d8-f62c06802a94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 5, ". We have list ", {1, 3, 2, 4}, 
   " and permutation ", 
   xAct`xPerm`Perm[{1, 3, 2, 4, 5}]],
  Editable->
   False]], "Print",ExpressionUUID->"5f2b5059-816f-4085-bf4b-40e431690e5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Perm[{1, 3, 2, 4, 5}]],
  Editable->
   False]], "Print",ExpressionUUID->"937ad586-f71b-452d-8fd1-8e619ce7c6a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Branching over points ", {1, 2, 5, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"90ba5b34-595e-4bce-b4ab-adba4a3e46ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "5"}], "}"}]}],
  SequenceForm["Generating over points ", {1, 3, 4, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"80677258-8b7c-4420-a206-5151f179263f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}],
  SequenceForm["Generating over points ", {3, 4, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"5602974b-5bd7-4f75-827e-b4e5176e7aff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}],
  SequenceForm["Generating over points ", {4, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"0e1dcc41-fb9e-407b-8240-e30225e1d375"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 5, ". We have list ", {2, 1, 3, 4}, 
   " and permutation ", 
   xAct`xPerm`Perm[{2, 1, 3, 4, 5}]],
  Editable->
   False]], "Print",ExpressionUUID->"a4ab089c-c506-45cc-8c83-57877c3fb32d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Perm[{2, 1, 3, 4, 5}]],
  Editable->
   False]], "Print",ExpressionUUID->"82e79653-9c15-4876-9843-6038356a3d78"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}], 
    "]"}]}], "]"}]], \
"Output",ExpressionUUID->"017152c8-6fdc-4573-8592-d563c90bd492"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"12e97681-54cc-43de-aea7-2614a8ff0631"],

Cell[BoxData["120"], \
"Output",ExpressionUUID->"d8c7d277-f609-4cd3-ae37-7e7bd134b146"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.5.2. Examples: Centralizer", \
"Subsubsection",ExpressionUUID->"5d6e9525-f566-44ac-b103-0bf553b45f24"],

Cell["There are two examples given by Butler in pages 100 and 101:", \
"Text",ExpressionUUID->"dac5aad8-b86a-446d-9e8d-f91a0a6621e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"3d813e65-75ab-4071-82f2-20ed7dec9a63"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"Search", "[", 
   RowBox[{
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "4"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"PermEqual", "[", 
      RowBox[{
       RowBox[{"PermProduct", "[", 
        RowBox[{"z", ",", "#"}], "]"}], ",", 
       RowBox[{"PermProduct", "[", 
        RowBox[{"#", ",", "z"}], "]"}]}], "]"}], "&"}], ",", "1", ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
    RowBox[{"xPermVerbose", "\[Rule]", "True"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"c0a12528-a7aa-4c80-923e-c74adee95851"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Branching over points ", {3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"7efbd492-40b5-414a-87d1-a0c8cdd7b168"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   "ID"}],
  SequenceForm[
  "Generate at level ", 3, " with i=", 4, ". We have list ", {1, 2, 3}, 
   " and permutation ", xAct`xPerm`ID],
  Editable->
   False]], "Print",ExpressionUUID->"d4a40bd0-6542-4837-9dc5-2f6d71177e99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 3, " with i=", 4, ". We have list ", {1, 2, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{3, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"93c452b6-9193-408a-84e0-415a59ef8a58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Branching over points ", {2, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d63c31b9-cf61-4f31-8002-2f82b189736e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"e39e7b85-7995-4926-a8bf-345383df6ddb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 3, 2}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"0d728a52-5382-432d-98cd-393cf776648b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 3, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 3, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"37784801-44a5-4a99-a0cf-481ad7c2b99f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}],
  SequenceForm["Generating over points ", {2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"775ef96d-218d-455d-bc34-8dc40a217e17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "3"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 4, 2}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 4, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"10eae8bb-2699-4f27-afec-25df95e73eac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 4, 3}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"ccef91e2-0f1f-4a1f-b7b4-c0b87dffc11b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Cycles[{2, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"91c59962-2a0d-4cd8-8365-4a265a3e8dfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}]}],
  SequenceForm["Branching over points ", {1, 2, 4, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"40a7447e-0d5d-4086-9f92-3ca48ed80b7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {1, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"0432f827-3f24-48bc-9dc7-4abbfc0554ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"6734ffcf-99c1-4049-a0d6-27bb859a0f92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {2, 1, 3}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 2}]],
  Editable->
   False]], "Print",ExpressionUUID->"4a147694-a85e-40f5-a3cf-e54ea3b55829"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {2, 1, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 2}, {3, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"28a91d69-6300-4917-a022-9261a430197b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Cycles[{1, 2}, {3, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"7045579d-8885-4c96-9a26-b5ae76cb0a04"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"fac7972a-3bd7-41e4-839f-bee700c33792"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", "SGS", "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"f0fd021a-06d7-4602-afaa-c2016a616b7a"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}], "]"}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "3", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 2, 3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{2, 4}], 
      xAct`xPerm`Cycles[{1, 2}, {3, 4}]]], 
    xAct`xPerm`StrongGenSet[{2, 3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{2, 4}]]], 
    xAct`xPerm`StrongGenSet[{3}, 
     xAct`xPerm`GenSet[]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"3349c409-dc04-4024-94de-f105ab0d968a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "SGS", 
  "]"}]], "Input",ExpressionUUID->"523b0563-7a73-41ee-b657-f82dc2c219dd"],

Cell[BoxData["8"], \
"Output",ExpressionUUID->"b419ba30-c9c5-4196-9de0-a269b6800e03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimino", "[", 
  RowBox[{"SGS", "[", 
   RowBox[{"[", "2", "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"ac936be8-1432-48f8-a433-e0244cf2e92b"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"64e025ef-3035-474a-9f1f-b0e8352fd8c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "Length"}]], "Input",ExpressionUUID->"f84433cb-dfc5-4e0c-a1eb-451cb7593e0d"],

Cell[BoxData["8"], \
"Output",ExpressionUUID->"b52705ed-5ef6-427e-898a-0cab2469f7ac"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"7c37ee78-9c7b-4ace-bcef-d52dca64ea07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"Search", "[", 
   RowBox[{
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "4"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"PermEqual", "[", 
      RowBox[{
       RowBox[{"PermProduct", "[", 
        RowBox[{"z", ",", "#"}], "]"}], ",", 
       RowBox[{"PermProduct", "[", 
        RowBox[{"#", ",", "z"}], "]"}]}], "]"}], "&"}], ",", "1", ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
    RowBox[{"xPermVerbose", "\[Rule]", "True"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"6968447e-5cb4-4884-aad5-8aeb79563bbb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Branching over points ", {3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"ddfb42ce-c682-407c-8e19-bfd4a2e98ff1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   "ID"}],
  SequenceForm[
  "Generate at level ", 3, " with i=", 4, ". We have list ", {1, 2, 3}, 
   " and permutation ", xAct`xPerm`ID],
  Editable->
   False]], "Print",ExpressionUUID->"3dce11c2-fcc8-41f2-ae77-52d0e9ba65f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 3, " with i=", 4, ". We have list ", {1, 2, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{3, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"0c8a51ad-7b43-4644-9fc9-d6ba64dc950c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Cycles[{3, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"4daaccd3-3994-4e2b-afbe-df045b85c23c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Branching over points ", {2, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"e0a401c5-3a19-4180-9559-2bf46c39e62a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"239dd8c6-9f5d-42cb-a731-ac26e16e6a6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 3, 2}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"1ceb29da-e39e-45ca-af9a-78275c7ba449"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 3, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 3, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"47bf3d5c-6d75-47d6-951b-18d4f62eabaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}]}],
  SequenceForm["Branching over points ", {1, 2, 4, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ff28de47-7e71-4246-96d3-ff35533692de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {1, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"dea9d3c1-38b5-4c8a-afb9-a18bc69f2d2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"dd8baa1a-5369-41fe-a0bb-12f335393866"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {2, 1, 3}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 2}]],
  Editable->
   False]], "Print",ExpressionUUID->"af914dc4-c27a-4ac8-9057-b400898127c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Cycles[{1, 2}]],
  Editable->
   False]], "Print",ExpressionUUID->"d4c9be8c-6680-41e3-8655-6493045f8bd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {1, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"de49791b-442a-4f33-9a45-77b107c3bb5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d0f59f43-7193-4bd6-b288-cc56a95bb9f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {3, 1, 2}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 3, 2}]],
  Editable->
   False]], "Print",ExpressionUUID->"2d1b0516-3b40-40d2-b005-da30a357e818"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {3, 1, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 3, 4, 2}]],
  Editable->
   False]], "Print",ExpressionUUID->"3a47ab43-5333-4722-b687-c480f5b3d199"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"72c7780d-fb84-4e83-bb64-55491e11b99e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {3, 2, 1}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"49369ce1-97ab-44be-972b-144818bc419a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {3, 2, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 3, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"232933ba-48ea-4d78-a3ee-6cd561db2049"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}],
  SequenceForm["Generating over points ", {1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b4ce8769-703b-4694-a912-20bd49103a32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {3, 4, 1}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 3}, {2, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"0ca495f3-bf96-4fee-8975-6465d57d70ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Cycles[{1, 3}, {2, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"228403ee-ce23-4a08-ac98-24b27adf7a01"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"1b20eb31-6e97-4a84-8d18-088203bce511"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", "SGS", "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"d590ab07-2c95-4371-bdf2-0c6e482d5ccb"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "3", "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 2, 3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{3, 4}], 
      xAct`xPerm`Cycles[{1, 2}], 
      xAct`xPerm`Cycles[{1, 3}, {2, 4}]]], 
    xAct`xPerm`StrongGenSet[{2, 3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{3, 4}]]], 
    xAct`xPerm`StrongGenSet[{3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{3, 4}]]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"9e40387a-2224-4b51-a4b4-bb9ea4179310"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "SGS", 
  "]"}]], "Input",ExpressionUUID->"40fee75f-f9c3-4124-a06d-6da9606f5148"],

Cell[BoxData["8"], \
"Output",ExpressionUUID->"4ea1b8f7-50d4-4aee-99a7-2ea7e3be5aae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimino", "[", 
  RowBox[{"SGS", "[", 
   RowBox[{"[", "2", "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"eee25ca5-c3f7-4681-bd09-7d4c05e73e4c"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"6285b3c3-64e4-4221-baad-10ecb80d4836"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "Length"}]], "Input",ExpressionUUID->"9e85aca0-c96d-4ad2-b820-cd4aefe136f9"],

Cell[BoxData["8"], \
"Output",ExpressionUUID->"68e6b6af-fd52-41dc-89f1-a1ad50264ffd"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.6. BaseChange, DeleteRedundantGenerators", \
"Subsection",ExpressionUUID->"8fac9906-8bb2-4792-afb8-38a8920126d7"],

Cell["\<\
We want to return a new SGS with points j and j+1 exchanged in base.\
\>", "Text",ExpressionUUID->"e07c52f5-cce1-43a8-bda8-d2adf827277b"],

Cell["Generalized basic orbit:", \
"Text",ExpressionUUID->"0f6f3694-c623-431b-9ad7-812850879fad"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasicOrbit", "[", 
    RowBox[{"j_Integer", ",", "k_Integer", ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_List", ",", "GS_GenSet"}], "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Orbit", "[", 
     RowBox[{
      RowBox[{"base", "[", 
       RowBox[{"[", "j", "]"}], "]"}], ",", 
      RowBox[{"Stabilizer", "[", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"base", ",", "k"}], "]"}], ",", "GS"}], "]"}]}], "]"}], "/;", 
    RowBox[{"k", "<", "j"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"63357bc1-04b4-4f29-9c6b-db12c117ae3d"],

Cell[TextData[{
 "This is algorithm 12.3 of Butler. Algorithms 12.1 and 12.2 are not \
programmed in ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 ". It is private:"
}], "Text",ExpressionUUID->"d418f554-3950-4c7b-af83-eaa69c60d235"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Interchange", "[", 
   RowBox[{
    RowBox[{"SGS", ":", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{"base_List", ",", "GS_GenSet"}], "]"}]}], ",", "j_Integer", ",",
     "len_Integer"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "Deltaj", ",", "Deltajp1", ",", "LDeltaBarjp1", ",", "T", ",", "Gamma", ",",
       "Delta", ",", "gamma", ",", "p", ",", "g1", ",", "g2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Deltaj", "=", 
      RowBox[{"BasicOrbit", "[", 
       RowBox[{"j", ",", 
        RowBox[{"j", "-", "1"}], ",", "SGS"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Deltajp1", "=", 
      RowBox[{"BasicOrbit", "[", 
       RowBox[{
        RowBox[{"j", "+", "1"}], ",", "j", ",", "SGS"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"LDeltaBarjp1", "=", 
      RowBox[{
       RowBox[{"Length", "[", "Deltajp1", "]"}], 
       RowBox[{
        RowBox[{"Length", "[", "Deltaj", "]"}], "/", 
        RowBox[{"Length", "[", 
         RowBox[{"BasicOrbit", "[", 
          RowBox[{
           RowBox[{"j", "+", "1"}], ",", 
           RowBox[{"j", "-", "1"}], ",", "SGS"}], "]"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"T", "=", 
      RowBox[{"Stabilizer", "[", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"base", ",", 
          RowBox[{"j", "+", "1"}]}], "]"}], ",", "GS"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Gamma", "=", 
      RowBox[{"Complement", "[", 
       RowBox[{"Deltaj", ",", 
        RowBox[{"base", "[", 
         RowBox[{"[", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"j", "+", "1"}]}], "}"}], "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Delta", "=", 
      RowBox[{"{", 
       RowBox[{"base", "[", 
        RowBox[{"[", "j", "]"}], "]"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "Delta", "]"}], "\[NotEqual]", 
        "LDeltaBarjp1"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"gamma", "=", 
         RowBox[{"First", "[", "Gamma", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"g1", "=", 
         RowBox[{"TraceSchreier", "[", 
          RowBox[{"gamma", ",", 
           RowBox[{"SchreierOrbit", "[", 
            RowBox[{
             RowBox[{"base", "[", 
              RowBox[{"[", "j", "]"}], "]"}], ",", 
             RowBox[{"StrongGenSet", "[", 
              RowBox[{
               RowBox[{"base", "[", 
                RowBox[{"[", 
                 RowBox[{"Range", "[", 
                  RowBox[{"j", ",", 
                   RowBox[{"Length", "[", "base", "]"}]}], "]"}], "]"}], 
                "]"}], ",", 
               RowBox[{"Stabilizer", "[", 
                RowBox[{
                 RowBox[{"base", "[", 
                  RowBox[{"[", 
                   RowBox[{"Range", "[", 
                    RowBox[{"j", "-", "1"}], "]"}], "]"}], "]"}], ",", "GS"}],
                 "]"}]}], "]"}], ",", "len"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"p", "=", 
         RowBox[{"OnPoints", "[", 
          RowBox[{
           RowBox[{"base", "[", 
            RowBox[{"[", 
             RowBox[{"j", "+", "1"}], "]"}], "]"}], ",", 
           RowBox[{"InversePerm", "[", "g1", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"Deltajp1", ",", "p"}], "]"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"g2", "=", 
            RowBox[{"TraceSchreier", "[", 
             RowBox[{"p", ",", 
              RowBox[{"SchreierOrbit", "[", 
               RowBox[{
                RowBox[{"base", "[", 
                 RowBox[{"[", 
                  RowBox[{"j", "+", "1"}], "]"}], "]"}], ",", 
                RowBox[{"StrongGenSet", "[", 
                 RowBox[{
                  RowBox[{"base", "[", 
                   RowBox[{"[", 
                    RowBox[{"Range", "[", 
                    RowBox[{
                    RowBox[{"j", "+", "1"}], ",", 
                    RowBox[{"Length", "[", "base", "]"}]}], "]"}], "]"}], 
                   "]"}], ",", 
                  RowBox[{"Stabilizer", "[", 
                   RowBox[{
                    RowBox[{"base", "[", 
                    RowBox[{"[", 
                    RowBox[{"Range", "[", "j", "]"}], "]"}], "]"}], ",", 
                    "GS"}], "]"}]}], "]"}], ",", "len"}], "]"}]}], "]"}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"T", ",", 
             RowBox[{"PermProduct", "[", 
              RowBox[{"g2", ",", "g1"}], "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Delta", "=", 
            RowBox[{"Orbit", "[", 
             RowBox[{
              RowBox[{"base", "[", 
               RowBox[{"[", "j", "]"}], "]"}], ",", "T"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Gamma", "=", 
            RowBox[{"Complement", "[", 
             RowBox[{"Gamma", ",", "Delta"}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Gamma", "=", 
           RowBox[{"Complement", "[", 
            RowBox[{"Gamma", ",", 
             RowBox[{"Orbit", "[", 
              RowBox[{"gamma", ",", "T"}], "]"}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"base", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"base", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "\[Rule]", 
           RowBox[{"base", "[", 
            RowBox[{"[", 
             RowBox[{"j", "+", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"base", "[", 
            RowBox[{"[", 
             RowBox[{"j", "+", "1"}], "]"}], "]"}], "\[Rule]", 
           RowBox[{"base", "[", 
            RowBox[{"[", "j", "]"}], "]"}]}]}], "}"}]}], ",", 
       RowBox[{"Union", "[", 
        RowBox[{"GS", ",", "T"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6c82e428-6aac-4e90-9cc2-d7fcba7f1121"],

Cell["Example (page 121 of Butler):", \
"Text",ExpressionUUID->"6eb76449-0081-4b9a-9523-ae371209d302"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"base", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "9", ",", "8", ",", "10", ",", "2", ",", "12"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GS", "=", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "6", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "7"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SGS", "=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{"base", ",", "GS"}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"1f8ceb67-44b0-45e3-9235-4ed58bfc1a2b"],

Cell["There are six elements in the base:", \
"Text",ExpressionUUID->"25fba08b-c8e7-44d1-a2e4-8d6784777d78"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BasicOrbit", "[", 
    RowBox[{"#", ",", 
     RowBox[{"#", "-", "1"}], ",", "SGS"}], "]"}], "&"}], "/@", 
  RowBox[{
  "Range", "[", "6", 
   "]"}]}]], "Input",ExpressionUUID->"bebfb49d-0455-4868-a151-5600ac84d1df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "8", ",", "9", ",", "13", ",", "18", ",", "16", ",", "21", ",", 
     "7", ",", "20", ",", "17", ",", "14", ",", "10", ",", "11", ",", "4", ",",
      "6", ",", "15", ",", "5", ",", "12", ",", "19", ",", "3", ",", "2"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9", ",", "18", ",", "20", ",", "17", ",", "15", ",", "12", ",", "19"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "8", ",", "13", ",", "16", ",", "21", ",", "14", ",", "10", ",", "11"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "20", ",", "15"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"0a2dedb3-fa8f-4da4-a632-4b522e261682"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  "%"}]], "Input",ExpressionUUID->"4e599c25-f7d1-438d-bb41-994d5120f61e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21", ",", "7", ",", "7", ",", "3", ",", "3", ",", "3"}], 
  "}"}]], "Output",ExpressionUUID->"7ebc45ff-f69c-4550-bffc-5188a808511e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "@@", 
  "%"}]], "Input",ExpressionUUID->"2ffed052-0fad-48a8-8d9a-408e502ca8b1"],

Cell[BoxData["27783"], \
"Output",ExpressionUUID->"f3a3eed1-e419-4673-b1a2-1f05cf36c786"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "SGS", 
  "]"}]], "Input",ExpressionUUID->"ea6ca0a3-b097-49c7-b3c6-36ba176e60ca"],

Cell[BoxData["27783"], \
"Output",ExpressionUUID->"bf674f89-2d43-4eee-944c-9da9718632fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newSGS", "=", 
  RowBox[{"Interchange", "[", 
   RowBox[{"SGS", ",", "1", ",", "21"}], 
   "]"}]}]], "Input",ExpressionUUID->"601d3032-cd90-47b9-aa88-060bb9910a64"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "1", ",", "8", ",", "10", ",", "2", ",", "12"}], "}"}], 
   ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "5", ",", "7"}], 
       "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "6", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "7"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"7999336d-407e-4107-b1af-402b27179705"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"Last", "[", "newSGS", "]"}], ",", "GS"}], 
  "]"}]], "Input",ExpressionUUID->"035f492b-7332-46f2-b695-2e698cc36baa"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  RowBox[{"Cycles", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "5", ",", "7"}],
     "}"}], "]"}], 
  "]"}]], "Output",ExpressionUUID->"8d8d2d23-3cec-411e-aa41-ad11a222e44f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newSGS", "=", 
  RowBox[{"Interchange", "[", 
   RowBox[{"newSGS", ",", "2", ",", "21"}], 
   "]"}]}]], "Input",ExpressionUUID->"836589df-5491-4a9a-97e3-68edc352f69e"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "1", ",", "10", ",", "2", ",", "12"}], "}"}], 
   ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "5", ",", "7"}], 
       "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "6", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "7"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"78ff61a9-2140-4b6d-8214-6cd26a4381ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "newSGS", 
  "]"}]], "Input",ExpressionUUID->"f8aaa1fc-a32e-4be2-a556-52442c8ca024"],

Cell[BoxData["27783"], \
"Output",ExpressionUUID->"fd0fc3c5-9a88-4b26-b244-581ef34d186e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"Last", "[", "newSGS", "]"}], ",", "GS"}], 
  "]"}]], "Input",ExpressionUUID->"9cd7d348-638c-4d7c-b3bc-49216417ec02"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  RowBox[{"Cycles", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "5", ",", "7"}],
     "}"}], "]"}], 
  "]"}]], "Output",ExpressionUUID->"d1a596a9-e407-4952-8f61-300d7ff28a53"]
}, Open  ]],

Cell["\<\
This is the complete algorithm. This is 12.5 of Butler. Note that the new \
base is not necessarily a simple reordering of the old base. It can have new \
points.\
\>", "Text",ExpressionUUID->"997e2337-78ee-41ca-b2f6-9c4ef54bd0cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "BaseChange"}]], \
"Input",ExpressionUUID->"5d132880-a00d-4cb6-8cbe-658d5ba4d9cf"],

Cell[BoxData[
 StyleBox["\<\"BaseChange[SGS, newbase] gives a new strong generating set for \
the group described by SGS, having newbase as the first elements of its base. \
A third argument can be given specifying the length of the internal Schreier \
vectors used.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567978007-5455693",ExpressionUUID->"7806f6cf-014c-427a-8258-\
e6019e325afe"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BaseChange", "[", 
    RowBox[{"SGS_", ",", "base_"}], "]"}], ":=", 
   RowBox[{"BaseChange", "[", 
    RowBox[{"SGS", ",", "base", ",", 
     RowBox[{"PermLength", "[", "SGS", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BaseChange", "[", 
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "base_", ",", "len_"}], 
    "]"}], ":=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{"base", ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BaseChange", "[", 
    RowBox[{
     RowBox[{"SGS", ":", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"b_", ",", "___"}], "}"}], ",", "_"}], "]"}]}], ",", 
     RowBox[{"{", "b_", "}"}], ",", "len_"}], "]"}], ":=", "SGS"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BaseChange", "[", 
    RowBox[{
     RowBox[{"SGS", ":", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base_List", ",", "GS_GenSet"}], "]"}]}], ",", "newbase_List", 
     ",", "len_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "=", "0"}], ",", "j", ",", 
       RowBox[{"g", "=", "ID"}], ",", "more", ",", 
       RowBox[{"B", "=", "base"}], ",", 
       RowBox[{"gs", "=", "GS"}], ",", "pos", ",", "newSGS"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"more", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "newbase", "]"}], ">", "0"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"BasicOrbit", "[", 
            RowBox[{"1", ",", "0", ",", "SGS"}], "]"}], ",", 
           RowBox[{"newbase", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "False"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{"more", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"i", "=", 
          RowBox[{"i", "+", "1"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"g", "=", 
          RowBox[{"PermProduct", "[", 
           RowBox[{
            RowBox[{"TraceSchreier", "[", 
             RowBox[{
              RowBox[{"OnPoints", "[", 
               RowBox[{
                RowBox[{"newbase", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{"InversePerm", "[", "g", "]"}]}], "]"}], ",", 
              RowBox[{"SchreierOrbits", "[", 
               RowBox[{"SGS", ",", "len"}], "]"}]}], "]"}], ",", "g"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"more", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"i", "+", "1"}], ")"}], "\[LessEqual]", 
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"Length", "[", "B", "]"}], ",", 
             RowBox[{"Length", "[", "newbase", "]"}]}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"more", ",", 
           RowBox[{"more", "=", 
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"OnPoints", "[", 
               RowBox[{
                RowBox[{"newbase", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", "+", "1"}], "]"}], "]"}], ",", 
                RowBox[{"InversePerm", "[", "g", "]"}]}], "]"}], ",", 
              RowBox[{"BasicOrbit", "[", 
               RowBox[{
                RowBox[{"i", "+", "1"}], ",", "i", ",", "SGS"}], "]"}]}], 
             "]"}]}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"PermEqual", "[", 
          RowBox[{"g", ",", "ID"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"B", "=", 
          RowBox[{"OnPoints", "[", 
           RowBox[{"B", ",", "g"}], "]"}]}], ";", 
         RowBox[{"gs", "=", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"PermProduct", "[", 
              RowBox[{
               RowBox[{"InversePerm", "[", "g", "]"}], ",", "#", ",", "g"}], 
              "]"}], "&"}], ",", "gs"}], "]"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"j", "=", 
         RowBox[{"i", "+", "1"}]}], ",", 
        RowBox[{"j", "\[LessEqual]", 
         RowBox[{"Length", "[", "newbase", "]"}]}], ",", 
        RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"B", ",", 
             RowBox[{"newbase", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"pos", "=", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"B", ",", 
               RowBox[{"newbase", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"AppendTo", "[", 
             RowBox[{"B", ",", 
              RowBox[{"newbase", "[", 
               RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ";", 
            RowBox[{"pos", "=", 
             RowBox[{"Length", "[", "B", "]"}]}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"While", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"pos", "\[NotEqual]", "j"}], " ", "&&", 
            RowBox[{"pos", ">", "1"}]}], ",", 
           RowBox[{
            RowBox[{"newSGS", "=", 
             RowBox[{"Interchange", "[", 
              RowBox[{
               RowBox[{"StrongGenSet", "[", 
                RowBox[{"B", ",", "gs"}], "]"}], ",", 
               RowBox[{"pos", "-", "1"}], ",", "len"}], "]"}]}], ";", 
            RowBox[{"B", "=", 
             RowBox[{"newSGS", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ";", 
            RowBox[{"gs", "=", 
             RowBox[{"newSGS", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ";", 
            RowBox[{"pos", "=", 
             RowBox[{"pos", "-", "1"}]}]}]}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"B", ",", "gs"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"BaseChange", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "BaseChange", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0a4ed10c-a12d-43ef-882f-8d598a3ec388"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BaseChange", "[", 
   RowBox[{"SGS", ",", 
    RowBox[{"{", "1", "}"}], ",", "21"}], "]"}], "//", 
  "Trace"}]], "Input",ExpressionUUID->"56b2a898-18fd-4189-9e23-b5d6d5c65cfe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox["SGS",
      HoldForm], ",", 
     TagBox[
      RowBox[{"StrongGenSet", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "9", ",", "8", ",", "10", ",", "2", ",", "12"}], 
         "}"}], ",", 
        RowBox[{"GenSet", "[", 
         RowBox[{
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "6", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "5", ",", "7"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
       "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"BaseChange", "[", 
     RowBox[{
      RowBox[{"StrongGenSet", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "9", ",", "8", ",", "10", ",", "2", ",", "12"}], 
         "}"}], ",", 
        RowBox[{"GenSet", "[", 
         RowBox[{
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "6", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "5", ",", "7"}], "}"}]}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
       "]"}], ",", 
      RowBox[{"{", "1", "}"}], ",", "21"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "9", ",", "8", ",", "10", ",", "2", ",", "12"}], 
       "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "6", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "5", ",", "7"}], "}"}]}], "]"}], ",", 
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
     "]"}],
    HoldForm]}], 
  "}"}]], "Output",ExpressionUUID->"8989314b-8ec8-4a04-8723-28ccc37b5f48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseChange", "[", 
  RowBox[{"SGS", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8"}], "}"}], ",", "21"}], 
  "]"}]], "Input",ExpressionUUID->"ce7707d1-71f4-4f8b-9bbd-a6a259ec52ca"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "1", ",", "3", ",", "15", ",", "10"}], "}"}], 
   ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "7", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "15", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "18", ",", "19"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"4a2cf0cd-fe0c-4785-ac37-220d744c5bad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"860772ac-6375-4059-820f-787f3485fb78"],

Cell[BoxData["27783"], \
"Output",ExpressionUUID->"0af843bc-b8e2-48fb-bd9c-78eb96802f9b"]
}, Open  ]],

Cell["\<\
The solution given by Butler is wrong because he gives a permutation which is \
not in the original group:\
\>", "Text",ExpressionUUID->"fbc1b12a-f7fb-4034-a175-898c60f2b7e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "7", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "11"}], "}"}]}], "]"}], ",", "SGS"}], 
  "]"}]], "Input",ExpressionUUID->"d9e0c59f-b6a5-49be-a836-9bb7fa9f28f7"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"feddd92a-e71f-4e0c-bcfe-c9fb3a96d012"]
}, Open  ]],

Cell["\<\
This is essentially algorithm 12.4 of Butler.  It is more complicated because \
Butler's algorithm's efficiency depends on the order of the generators in GS. \
We introduce a Permutations structure to consider all possible orderings of \
generators and take the most convenient case.\
\>", "Text",ExpressionUUID->"35679e05-037f-431d-aa4c-7d8c8f9c21f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DeleteRedundantGenerators"}]], \
"Input",ExpressionUUID->"b5fa0f02-40d5-4474-8dc5-a40337c1ca84"],

Cell[BoxData[
 StyleBox["\<\"DeleteRedundantGenerators[SGS] returns an equivalent strong \
generating set removing redundant generators from the generating set.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567978008-5455693",ExpressionUUID->"ffee05d0-bae4-4491-985c-\
7cae3c8bb605"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DeleteRedundantGenerators", "[", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{"base_", ",", "GS_GenSet"}], "]"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Si", ",", "Sip1", ",", "i", ",", 
       RowBox[{"T", "=", 
        RowBox[{"GenSet", "[", "]"}]}], ",", "orbit", ",", "gens", ",", 
       "pgens", ",", "check", ",", "toadd"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sip1", "=", 
       RowBox[{"GenSet", "[", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"check", "[", 
        RowBox[{"i_", ",", "gen_", ",", "t_"}], "]"}], ":=", 
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"Orbit", "[", 
          RowBox[{
           RowBox[{"base", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "t"}], "]"}], ",", 
         RowBox[{"OnPoints", "[", 
          RowBox[{
           RowBox[{"base", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "gen"}], "]"}]}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"toadd", "[", 
        RowBox[{"i_", ",", "gs_", ",", "T_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"TT", "=", "T"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"check", "[", 
               RowBox[{"i", ",", "#", ",", "TT"}], "]"}], ",", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"TT", ",", "#"}], "]"}]}], "]"}], "&"}], "/@", "gs"}], 
          ";", 
          RowBox[{"Complement", "[", 
           RowBox[{"TT", ",", "T"}], "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", 
         RowBox[{"Length", "[", "base", "]"}]}], ",", 
        RowBox[{"i", "\[GreaterEqual]", "1"}], ",", 
        RowBox[{"i", "--"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Si", "=", 
          RowBox[{"Stabilizer", "[", 
           RowBox[{
            RowBox[{"Take", "[", 
             RowBox[{"base", ",", 
              RowBox[{"i", "-", "1"}]}], "]"}], ",", "GS"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"gens", "=", 
          RowBox[{"Complement", "[", 
           RowBox[{"Si", ",", "Sip1"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"pgens", "=", 
          RowBox[{"Permutations", "[", "gens", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"T", "=", 
          RowBox[{"Join", "[", 
           RowBox[{"T", ",", 
            RowBox[{"First", "@", 
             RowBox[{"Sort", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"toadd", "[", 
                 RowBox[{"i", ",", "#", ",", "T"}], "]"}], "&"}], "/@", 
               "pgens"}], "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Sip1", "=", "Si"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base", ",", "T"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DeleteRedundantGenerators", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DeleteRedundantGenerators", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c26c649a-0ee3-424c-b127-7eb943ddf3c4"],

Cell["Examples:", \
"Text",ExpressionUUID->"b9272f90-ba6f-4fd0-9ebe-c2bebca987a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"Last", "[", "newSGS", "]"}], ",", 
   RowBox[{"Last", "[", 
    RowBox[{"DeleteRedundantGenerators", "[", "newSGS", "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"9b7ee6f7-6fdf-4b7f-9e7c-23c12d335496"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], 
  "]"}]], "Output",ExpressionUUID->"fa7ba85d-8e52-490d-8cb1-a88bf8fb0db8"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"base", "=."}], "\[IndentingNewLine]", 
 RowBox[{"GS", "=."}], "\[IndentingNewLine]", 
 RowBox[{"SGS", "=."}], "\[IndentingNewLine]", 
 RowBox[{"newSGS", 
  "=."}]}], "Input",ExpressionUUID->"e1a30201-a855-4472-97a6-85bed85306c1"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.7. Schreier-Sims methods 3 and 4", \
"Subsection",ExpressionUUID->"7729f11b-6aaf-40d4-9843-8a845b142d28"],

Cell["\<\
Notations changed from Butler's book:
\tcurrent_gens : Si
\told_gens : oldSi\
\>", "Text",ExpressionUUID->"733cce13-3830-44cc-9216-78ba42b5049b"],

Cell["\<\
Assuming that S^(i) is a GS for H^(i) and that B,S^(i+1) are base and SGS for \
H^(i+1), find base and SGS for H^(i). T is the set of additional generators \
in S^(i) since the previous call to the procedure with the present value of \
i. Assume that a base and SGS set of <S^(i)-T>, (the previous value of H^(i)) \
are included in B and S. The present value of nu^(i) must be an extension of \
the previous value. This function is private.\
\>", "Text",ExpressionUUID->"1012a58a-21da-48f6-949e-759de7a4d165"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SchreierSimsStep", "[", 
    RowBox[{
    "B_List", ",", "S_GenSet", ",", "len_Integer", ",", "i_Integer", ",", 
     "T_GenSet", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Si", ",", "oldSi", ",", "genset", ",", "Deltai", ",", "oldDeltai", ",",
        "gn", ",", "j", ",", "k", ",", "gamma", ",", "sn", ",", "s", ",", "g",
        ",", "gbar", ",", "newB", ",", "newS", ",", "level", ",", "n", ",", 
       "rules", ",", "method", ",", "verb", ",", "word", ",", "junk"}], "}"}],
      ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"rules", ",", "method", ",", "verb"}], "}"}], "=", 
       RowBox[{"OptionValue", "[", 
        RowBox[{"SchreierSims", ",", 
         RowBox[{"{", "options", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"UseRules", ",", "Method", ",", "xPermVerbose"}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"newB", "=", "B"}], ";", 
      RowBox[{"newS", "=", "S"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"verb", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Schreier-Sims-Step called with B=\>\"", ",", "B", 
          ",", "\"\<, S=\>\"", ",", 
          RowBox[{"S", "/.", "rules"}], ",", "\"\<, i=\>\"", ",", "i", 
          ",", "\"\<, T=\>\"", ",", 
          RowBox[{"T", "/.", "rules"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Original", " ", "generating", " ", "sets"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Si", "=", 
       RowBox[{"Stabilizer", "[", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"B", ",", 
           RowBox[{"i", "-", "1"}]}], "]"}], ",", "S"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"oldSi", "=", 
       RowBox[{"Complement", "[", 
        RowBox[{"Si", ",", "T"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Basic", " ", "orbits"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"oldDeltai", "=", 
       RowBox[{"SchreierOrbit", "[", 
        RowBox[{
         RowBox[{"B", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "oldSi", ",", "len"}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"Deltai", "=", 
       RowBox[{"SchreierOrbit", "[", 
        RowBox[{
         RowBox[{"B", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "Si", ",", "len"}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Check", " ", "that", " ", "Deltai", " ", "is", " ", "an", " ", 
        "extension", " ", "of", " ", "oldDeltai"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"n", "=", "1"}], ",", 
        RowBox[{"n", "\[LessEqual]", 
         RowBox[{"Length", "[", 
          RowBox[{"oldDeltai", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"++", "n"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Deltai", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "n"}], "]"}], "]"}], "=!=", 
             RowBox[{"oldDeltai", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "n"}], "]"}], "]"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"oldDeltai", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "n"}], "]"}], "]"}], "=!=", "0"}], ")"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{"verb", ",", 
             RowBox[{
             "Print", 
              "[", "\"\<Modifying orbit Delta to extend previous value.\>\"", 
              "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Deltai", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "n"}], "]"}], "]"}], "=", 
            RowBox[{"oldDeltai", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "n"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Deltai", "[", 
             RowBox[{"[", 
              RowBox[{"3", ",", "n"}], "]"}], "]"}], "=", 
            RowBox[{"oldDeltai", "[", 
             RowBox[{"[", 
              RowBox[{"3", ",", "n"}], "]"}], "]"}]}]}]}], 
         "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Loop", " ", "over", " ", "elements", " ", "gamma", " ", "of", " ", 
        "basic", " ", "orbit"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"gn", "=", "1"}], ",", 
        RowBox[{"gn", "\[LessEqual]", 
         RowBox[{"Length", "[", 
          RowBox[{"Deltai", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"++", "gn"}], ",", 
        RowBox[{
         RowBox[{"gamma", "=", 
          RowBox[{"Deltai", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "gn"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"First", "[", "oldDeltai", "]"}], ",", "gamma"}], "]"}], 
           ",", 
           RowBox[{"genset", "=", "T"}], ",", 
           RowBox[{"genset", "=", "Si"}]}], "]"}], ";", "\[IndentingNewLine]",
          "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Loop", " ", "sn", " ", "over", " ", "generators", " ", "s", " ", 
           "in", " ", "genset"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"sn", "=", "1"}], ",", 
           RowBox[{"sn", "\[LessEqual]", 
            RowBox[{"Length", "[", "genset", "]"}]}], ",", 
           RowBox[{"++", "sn"}], ",", 
           RowBox[{
            RowBox[{"s", "=", 
             RowBox[{"genset", "[", 
              RowBox[{"[", "sn", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"Compute", " ", "Schreier", " ", "generator"}], " ", 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{"g", "=", 
             RowBox[{"PermProduct", "[", 
              RowBox[{
               RowBox[{"TraceSchreier", "[", 
                RowBox[{"gamma", ",", "Deltai"}], "]"}], ",", "s", ",", 
               RowBox[{"InversePerm", "[", 
                RowBox[{"TraceSchreier", "[", 
                 RowBox[{
                  RowBox[{"OnPoints", "[", 
                   RowBox[{"gamma", ",", "s"}], "]"}], ",", "Deltai"}], "]"}],
                 "]"}]}], "]"}]}], ";", 
            RowBox[{"++", "num"}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "If", " ", "g", " ", "is", " ", "not", " ", "in", " ", 
              "subgroup", " ", 
              RowBox[{"H", "^", 
               RowBox[{"(", 
                RowBox[{"i", "+", "1"}], ")"}]}]}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"Not", "@", 
               RowBox[{"PermMemberQ", "[", 
                RowBox[{"g", ",", 
                 RowBox[{"StrongGenSet", "[", 
                  RowBox[{
                   RowBox[{"Drop", "[", 
                    RowBox[{"newB", ",", "i"}], "]"}], ",", 
                   RowBox[{"Stabilizer", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"newB", ",", "i"}], "]"}], ",", "newS"}], "]"}]}],
                   "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{"Length", "[", "newB", "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"Switch", "[", 
                RowBox[{
                "method", ",", "\[IndentingNewLine]", "\"\<Butler3\>\"", ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"gbar", "=", "g"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"j", "=", "1"}], ";", 
                  RowBox[{"While", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"j", "\[LessEqual]", "k"}], "&&", 
                    RowBox[{
                    RowBox[{"OnPoints", "[", 
                    RowBox[{
                    RowBox[{"newB", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], ",", "gbar"}], "]"}], "===", 
                    RowBox[{"newB", "[", 
                    RowBox[{"[", "j", "]"}], "]"}]}]}], ",", 
                    RowBox[{"j", "++"}]}], "]"}]}], ",", 
                 "\[IndentingNewLine]", "\"\<Butler4\>\"", ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"word", "=", 
                   RowBox[{"PermWord", "[", 
                    RowBox[{"g", ",", 
                    RowBox[{"StrongGenSet", "[", 
                    RowBox[{
                    RowBox[{"Drop", "[", 
                    RowBox[{"newB", ",", "i"}], "]"}], ",", 
                    RowBox[{"Stabilizer", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"newB", ",", "i"}], "]"}], ",", "newS"}], "]"}]}],
                     "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
                  RowBox[{"gbar", "=", 
                   RowBox[{"First", "[", "word", "]"}]}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"j", "=", 
                   RowBox[{"i", "+", 
                    RowBox[{"Length", "[", "word", "]"}]}]}]}], ",", 
                 "\[IndentingNewLine]", "_", ",", "\[IndentingNewLine]", 
                 RowBox[{"Throw", " ", "@", 
                  RowBox[{"Print", "[", 
                   
                   RowBox[{"\"\<Unknown Schreier-Sims variant method: \>\"", ",",
                     "method"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ";",
                "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{"Extend", " ", "GS"}], " ", "*)"}], 
               "\[IndentingNewLine]", 
               RowBox[{"AppendTo", "[", 
                RowBox[{"newS", ",", "gbar"}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{"verb", ",", 
                 RowBox[{"Print", "[", 
                  RowBox[{"\"\<Appended S[[\>\"", ",", 
                   RowBox[{"Length", "[", "newS", "]"}], ",", "\"\<]]=\>\"", ",", 
                   RowBox[{"gbar", "/.", "rules"}]}], "]"}]}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{"Extend", " ", "base"}], ",", " ", 
                 RowBox[{"if", " ", "necessary"}], ",", " ", 
                 RowBox[{
                 "so", " ", "that", " ", "no", " ", "strong", " ", 
                  "generator", " ", "fixes", " ", "all", " ", "base", " ", 
                  "points"}]}], " ", "*)"}], "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"j", "===", 
                  RowBox[{"k", "+", "1"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"AppendTo", "[", 
                   RowBox[{"newB", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{"Complement", "[", 
                    RowBox[{
                    RowBox[{"Range", "[", "len", "]"}], ",", 
                    RowBox[{"StablePoints", "[", 
                    RowBox[{"gbar", ",", "len"}], "]"}], ",", "newB", ",", 
                    RowBox[{"{", "0", "}"}]}], "]"}], "]"}]}], "]"}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"If", "[", 
                   RowBox[{"verb", ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\"\<Appended B[[\>\"", ",", 
                    RowBox[{"k", "+", "1"}], ",", "\"\<]]=\>\"", ",", 
                    RowBox[{"Last", "[", "newB", "]"}]}], "]"}]}], "]"}]}]}], 
                "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                "Ensure", " ", "we", " ", "still", " ", "have", " ", "a", " ",
                  "base", " ", "and", " ", "SGS", " ", "for", " ", 
                 RowBox[{"H", "^", 
                  RowBox[{"(", 
                   RowBox[{"i", "+", "1"}], ")"}]}]}], " ", "*)"}], 
               "\[IndentingNewLine]", 
               RowBox[{"For", "[", 
                RowBox[{
                 RowBox[{"level", "=", "j"}], ",", 
                 RowBox[{"level", "\[GreaterEqual]", 
                  RowBox[{"i", "+", "1"}]}], ",", 
                 RowBox[{"--", "level"}], ",", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"newB", ",", "newS"}], "}"}], "=", 
                  RowBox[{"SchreierSimsStep", "[", 
                   RowBox[{"newB", ",", "newS", ",", "len", ",", "level", ",", 
                    RowBox[{"GenSet", "[", "gbar", "]"}], ",", "options"}], 
                   "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{"verb", ",", 
                 RowBox[{"Print", "[", 
                  RowBox[{"\"\<Finished check of H(\>\"", ",", 
                   RowBox[{"i", "+", "1"}], ",", "\"\<) with base \>\"", ",", 
                   
                   RowBox[{"Drop", "[", 
                    RowBox[{"newB", ",", "i"}], "]"}], 
                   ",", "\"\< and SGS \>\"", ",", 
                   RowBox[{
                    RowBox[{"Stabilizer", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"newB", ",", "i"}], "]"}], ",", "newS"}], "]"}], "/.",
                     "rules"}]}], "]"}]}], "]"}], ";"}]}], 
             "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "]"}], ";", 
      RowBox[{"{", 
       RowBox[{"newB", ",", "newS"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"952ead22-9a2c-4227-93b7-39fca0b36f86"],

Cell["Old computation of j in Butler3:", \
"Text",ExpressionUUID->"4420d0ee-4e5b-447b-a890-6cab63a6891b"],

Cell[BoxData[
 RowBox[{"j", "=", 
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{"Complement", "[", 
     RowBox[{
      RowBox[{"Range", "[", "k", "]"}], ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Position", "[", 
          RowBox[{"newB", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"StablePoints", "[", 
         RowBox[{"gbar", ",", "len"}], "]"}]}], "]"}]}], "]"}], "/.", 
    RowBox[{
     RowBox[{"{", "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"k", "+", "1"}], "}"}]}]}], "]"}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"975456bd-9ee0-46ba-867c-a112da1c59af"],

Cell["\<\
This is the main driver for the Schreier-Sims algorithm. Note the ugly use of \
the global counter num:\
\>", "Text",ExpressionUUID->"92a7f631-ebb2-4a4b-816f-96946cf40b02"],

Cell["\<\
TODO: The resulting base contains a zero if using MathLink\[Rule]False or \
Images notation (perhaps other notations too). Detected by Alfonso, March \
2011.\
\>", "Text",ExpressionUUID->"fe894767-9baa-4522-8aaf-886f33fe6c25"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Main", " ", "driver"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "SchreierSims", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"MathLink", "\[RuleDelayed]", "$xpermQ"}], ",", 
       RowBox[{"UseRules", "\[RuleDelayed]", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"Method", "\[Rule]", "\"\<Butler3\>\""}], ",", 
       RowBox[{"xPermVerbose", "\[Rule]", "False"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierSims", "[", 
      RowBox[{"n_Integer", ",", "other__"}], "]"}], ":=", 
     RowBox[{"SchreierSims", "[", 
      RowBox[{
       RowBox[{"Range", "[", "n", "]"}], ",", "other"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierSims", "[", 
      RowBox[{"B_List", ",", 
       RowBox[{"Symmetric", "[", 
        RowBox[{"inds_List", ",", 
         RowBox[{"not_", ":", "xAct`xPerm`Cycles"}]}], "]"}], ",", 
       "options___"}], "]"}], ":=", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"Sort", "@", "inds"}], ",", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{
         RowBox[{"GenSet", "@@", 
          RowBox[{"(", 
           RowBox[{"xAct`xPerm`Cycles", "/@", 
            RowBox[{"Partition", "[", 
             RowBox[{
              RowBox[{"Sort", "@", "inds"}], ",", "2", ",", "1"}], "]"}]}], 
           ")"}]}], ",", "not"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierSims", "[", 
      RowBox[{"B_List", ",", 
       RowBox[{"Antisymmetric", "[", 
        RowBox[{"inds_List", ",", 
         RowBox[{"not_", ":", "xAct`xPerm`Cycles"}]}], "]"}], ",", 
       "options___"}], "]"}], ":=", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"Sort", "@", "inds"}], ",", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{
         RowBox[{"GenSet", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"xAct`xPerm`Cycles", "[", "#", "]"}]}], "&"}], "/@", 
            RowBox[{"Partition", "[", 
             RowBox[{
              RowBox[{"Sort", "@", "inds"}], ",", "2", ",", "1"}], "]"}]}], 
           ")"}]}], ",", "not"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierSims", "[", 
      RowBox[{"_", ",", 
       RowBox[{"GenSet", "[", "]"}], ",", "len_Integer", ",", "options___"}], 
      "]"}], ":=", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"SchreierSims", "[", 
      RowBox[{"B_List", ",", "GS_GenSet", ",", 
       RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
     RowBox[{"SchreierSims", "[", 
      RowBox[{"B", ",", "GS", ",", 
       RowBox[{"PermLength", "[", 
        RowBox[{"StrongGenSet", "[", 
         RowBox[{"B", ",", "GS"}], "]"}], "]"}], ",", "options"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SchreierSims", "[", 
      RowBox[{"B_List", ",", "GS_GenSet", ",", "len_Integer", ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"OptionValue", "[", "MathLink", "]"}], ",", 
        "MathLinkSchreierSims", ",", "MathSchreierSims"}], "]"}], "[", 
      RowBox[{"B", ",", "GS", ",", "len", ",", "options"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"SchreierSims", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Protect", "[", "SchreierSims", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Mathematica", " ", "code"}], " ", "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"MathSchreierSims", "[", 
      RowBox[{"B_List", ",", "GS_GenSet", ",", "len_Integer", ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"base", "=", "B"}], ",", "PBQ", ",", "genset", ",", "i", ",",
          "rules", ",", "verb"}], "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"rules", ",", "verb"}], "}"}], "=", 
         RowBox[{"OptionValue", "[", 
          RowBox[{"SchreierSims", ",", 
           RowBox[{"{", "options", "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"UseRules", ",", "xPermVerbose"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"num", "=", "0"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Eliminate", " ", "identity", " ", "from", " ", "GS"}], ",",
           " ", 
          RowBox[{"if", " ", "present"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"genset", "=", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{"GS", ",", 
           RowBox[{"ID", "[", 
            RowBox[{"First", "[", "GS", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Check", " ", "initial", " ", "base"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"base", "=", 
         RowBox[{"NonStablePoints", "[", 
          RowBox[{"B", ",", "genset"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k", "=", 
         RowBox[{"Length", "[", "base", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Recursive", " ", "call", " ", "to", " ", "SchreierSims"}], 
         " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "k"}], ",", 
          RowBox[{"i", "\[GreaterEqual]", "1"}], ",", 
          RowBox[{"--", "i"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"base", ",", "genset"}], "}"}], "=", 
            RowBox[{"Evaluate", "[", 
             RowBox[{"SchreierSimsStep", "[", 
              RowBox[{"base", ",", "genset", ",", "len", ",", "i", ",", 
               RowBox[{"Stabilizer", "[", 
                RowBox[{
                 RowBox[{"Take", "[", 
                  RowBox[{"base", ",", 
                   RowBox[{"i", "-", "1"}]}], "]"}], ",", "genset"}], "]"}], ",",
                "options"}], "]"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "Results", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"verb", ",", 
          RowBox[{"Print", "[", 
           
           RowBox[{"\"\<Checked \>\"", ",", "num", 
            ",", "\"\< generators and obtained group of order \>\"", ",", 
            RowBox[{"OrderOfGroup", "[", 
             RowBox[{"StrongGenSet", "[", 
              RowBox[{"base", ",", "genset"}], "]"}], "]"}]}], "]"}]}], "]"}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"StrongGenSet", "[", 
         RowBox[{
          RowBox[{"DeleteCases", "[", 
           RowBox[{"base", ",", "0"}], "]"}], ",", 
          RowBox[{"genset", "/.", "rules"}]}], "]"}]}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"38925186-d2b6-44d8-a07a-b9000a16ac7e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", "]"}], ",", "4"}], 
  "]"}]], "Input",ExpressionUUID->"b7201d78-4dae-4d43-9d3e-04fc61efa452"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"f8ee87cf-1339-4c55-86d5-6f4c23feb13f"]
}, Open  ]],

Cell["RiemannSymmetric:", \
"Text",ExpressionUUID->"c2e7caf1-d0a8-4269-af12-67210df47f8c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}]}], "]"}], ",",
    "4"}], "]"}]], \
"Input",ExpressionUUID->"3c7b21a8-0138-4f8e-ada2-5c7d62c97961"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}]}], 
    "]"}]}], "]"}]], \
"Output",ExpressionUUID->"c8fe91dc-fde1-4292-8a6e-eeceee34f155"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], "}"}],
       "]"}]}], "]"}], ",", "6"}], 
  "]"}]], "Input",ExpressionUUID->"184d6e37-3241-4ada-ab74-c89412213190"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], "}"}],
       "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"022e9dc1-7448-46ac-83a2-9f4737eadff7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"xAct`xPerm`Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "]"}]}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}], ",", "4"}], 
  "]"}]], "Input",ExpressionUUID->"75473e53-ed64-4efc-9621-13c20901232f"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "]"}]}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"cf2270ad-03d8-4cce-8c4d-75fbbae33dc6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}]}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}], ",", "6"}], 
  "]"}]], "Input",ExpressionUUID->"5eb6e969-2175-4fb7-a2ee-344d36b01948"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"c395e6bc-9aa7-48c1-8ca9-8c971574096a"]
}, Open  ]],

Cell["A nontrivial example:", \
"Text",ExpressionUUID->"2942098f-484b-4f62-8f5c-8d4e51a9d159"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "16", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "14", ",", "21"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "7", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"1875ea0e-3947-4fb6-94bd-2716900f44af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$xPermRules", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "\"\<a\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{"b", "\[Rule]", "\"\<b\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{"c", "\[Rule]", "\"\<c\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{"d", "\[Rule]", "\"\<d\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{"e", "\[Rule]", "\"\<e\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{"f", "\[Rule]", "\"\<f\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{"g", "\[Rule]", "\"\<g\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{"h", "\[Rule]", "\"\<h\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Perm", "[", 
       RowBox[{"Range", "[", "21", "]"}], "]"}], "\[Rule]", "\"\<id\>\""}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"a", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<a\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"b", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<b\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"c", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<c\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<d\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"e", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<e\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"f", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<f\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"g", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<g\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"h", ",", 
        RowBox[{"{", 
         RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<h\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"a", ",", "Rules"}], "]"}], "\[Rule]", "\"\<a\>\""}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"b", ",", "Rules"}], "]"}], "\[Rule]", "\"\<b\>\""}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"c", ",", "Rules"}], "]"}], "\[Rule]", "\"\<c\>\""}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sort", "[", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{"d", ",", "Rules"}], "]"}], "]"}], "\[Rule]", "\"\<d\>\""}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sort", "[", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{"e", ",", "Rules"}], "]"}], "]"}], "\[Rule]", "\"\<e\>\""}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sort", "[", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{"f", ",", "Rules"}], "]"}], "]"}], "\[Rule]", "\"\<f\>\""}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sort", "[", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{"g", ",", "Rules"}], "]"}], "]"}], "\[Rule]", "\"\<g\>\""}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sort", "[", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{"h", ",", "Rules"}], "]"}], "]"}], "\[Rule]", "\"\<h\>\""}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"a", ",", 
        RowBox[{"{", 
         RowBox[{"Images", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<a\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"b", ",", 
        RowBox[{"{", 
         RowBox[{"Images", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<b\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"c", ",", 
        RowBox[{"{", 
         RowBox[{"Images", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<c\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"Images", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<d\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"e", ",", 
        RowBox[{"{", 
         RowBox[{"Images", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<e\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"f", ",", 
        RowBox[{"{", 
         RowBox[{"Images", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<f\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"g", ",", 
        RowBox[{"{", 
         RowBox[{"Images", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<g\>\""}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TranslatePerm", "[", 
       RowBox[{"h", ",", 
        RowBox[{"{", 
         RowBox[{"Images", ",", "21"}], "}"}]}], "]"}], 
      "\[Rule]", "\"\<h\>\""}]}], "}"}]}], 
  ";"}]], "Input",ExpressionUUID->"606f5e74-f77a-48bf-99d2-f562954d0aa6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{
     RowBox[{"GenSet", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}], ",", "21", ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "True"}], ",", 
   RowBox[{"UseRules", "\[Rule]", "$xPermRules"}]}], 
  "]"}]], "Input",ExpressionUUID->"edbbf558-2f7f-4fca-8e34-28d6c2f6690a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "]"}], 
   "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"c\"\>", "]"}]}],
  SequenceForm["Schreier-Sims-Step called with B=", {9, 10}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c"], ", i=", 2, ", T=", 
   xAct`xPerm`GenSet["c"]],
  Editable->
   False]], "Print",ExpressionUUID->"1e32a2fe-e075-45c8-bf77-fd2e496e95ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "]"}], 
   "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "]"}]}],
  SequenceForm["Schreier-Sims-Step called with B=", {9, 10}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c"], ", i=", 1, ", T=", 
   xAct`xPerm`GenSet["a", "b", "c"]],
  Editable->
   False]], "Print",ExpressionUUID->"349a2f9d-eda8-4daf-adca-17cb7ae4b6a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Appended S[[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", "\<\"d\"\>"}],
  SequenceForm["Appended S[[", 4, "]]=", "d"],
  Editable->
   False]], "Print",ExpressionUUID->"38aba14f-ab98-418b-b8ca-4fe3601d3638"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}], "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", 
     ",", "\<\"d\"\>"}], "]"}], "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]",
    "2", "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"d\"\>", "]"}]}],
  SequenceForm["Schreier-Sims-Step called with B=", {9, 10}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d"], ", i=", 2, ", T=", 
   xAct`xPerm`GenSet["d"]],
  Editable->
   False]], "Print",ExpressionUUID->"6ae95517-b919-4039-bfaf-39ccb756fb6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Appended S[[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", "\<\"e\"\>"}],
  SequenceForm["Appended S[[", 5, "]]=", "e"],
  Editable->
   False]], "Print",ExpressionUUID->"24d0e985-b112-4bfe-9b94-218aa0faaec8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Appended B[[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["Appended B[[", 3, "]]=", 8],
  Editable->
   False]], "Print",ExpressionUUID->"8c8ad74d-c0b8-48f6-9a90-57b54dc61e14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>"}], "]"}], "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]",
    "3", "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"e\"\>", "]"}]}],
  SequenceForm["Schreier-Sims-Step called with B=", {9, 10, 8}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e"], ", i=", 3, ", T=", 
   xAct`xPerm`GenSet["e"]],
  Editable->
   False]], "Print",ExpressionUUID->"37c2abef-bed0-4159-9c20-c29963450c1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Finished check of H(\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\") with base \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}], "\[InvisibleSpace]", "\<\" and SGS \"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"e\"\>", "]"}]}],
  SequenceForm["Finished check of H(", 3, ") with base ", {8}, " and SGS ", 
   xAct`xPerm`GenSet["e"]],
  Editable->
   False]], "Print",ExpressionUUID->"6d9ca719-1844-4ce7-9538-623d5ac7f013"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Finished check of H(\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\") with base \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"10", ",", "8"}], "}"}], "\[InvisibleSpace]", "\<\" and SGS \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"c\"\>", ",", "\<\"d\"\>", ",", "\<\"e\"\>"}], "]"}]}],
  SequenceForm[
  "Finished check of H(", 2, ") with base ", {10, 8}, " and SGS ", 
   xAct`xPerm`GenSet["c", "d", "e"]],
  Editable->
   False]], "Print",ExpressionUUID->"835213be-cedd-440c-95c9-614ec146d18c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Appended S[[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", "\<\"f\"\>"}],
  SequenceForm["Appended S[[", 6, "]]=", "f"],
  Editable->
   False]], "Print",ExpressionUUID->"76a3d3e9-6b9f-47aa-833a-1b4d5bf5aba0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Appended B[[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Appended B[[", 4, "]]=", 2],
  Editable->
   False]], "Print",ExpressionUUID->"d10625d0-5b65-4288-95e6-64bd42caf1d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>"}], "]"}], 
   "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"f\"\>", "]"}]}],
  SequenceForm["Schreier-Sims-Step called with B=", {9, 10, 8, 2}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f"], ", i=", 4, ", T=", 
   xAct`xPerm`GenSet["f"]],
  Editable->
   False]], "Print",ExpressionUUID->"2aa14042-67b5-4788-a2ea-1a8a88f69237"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>"}], "]"}], 
   "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"f\"\>", "]"}]}],
  SequenceForm["Schreier-Sims-Step called with B=", {9, 10, 8, 2}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f"], ", i=", 3, ", T=", 
   xAct`xPerm`GenSet["f"]],
  Editable->
   False]], "Print",ExpressionUUID->"040d2de8-04a3-4634-8099-1062f76d2c47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>"}], "]"}], 
   "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"f\"\>", "]"}]}],
  SequenceForm["Schreier-Sims-Step called with B=", {9, 10, 8, 2}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f"], ", i=", 2, ", T=", 
   xAct`xPerm`GenSet["f"]],
  Editable->
   False]], "Print",ExpressionUUID->"57b24230-7ac9-48da-9dc4-2c843ee77914"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Finished check of H(\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\") with base \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"10", ",", "8", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and SGS \"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"c\"\>", ",", "\<\"d\"\>", ",", "\<\"e\"\>", 
     ",", "\<\"f\"\>"}], "]"}]}],
  SequenceForm[
  "Finished check of H(", 2, ") with base ", {10, 8, 2}, " and SGS ", 
   xAct`xPerm`GenSet["c", "d", "e", "f"]],
  Editable->
   False]], "Print",ExpressionUUID->"f2376f30-a7ee-4911-ac48-25c8901c4c57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Appended S[[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", "\<\"g\"\>"}],
  SequenceForm["Appended S[[", 7, "]]=", "g"],
  Editable->
   False]], "Print",ExpressionUUID->"d751f196-87b9-46f1-a98b-5b18aa559b35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Appended B[[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Appended B[[", 5, "]]=", 1],
  Editable->
   False]], "Print",ExpressionUUID->"d4626754-7d75-495e-9631-e97cd5fc0bc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "]"}], 
   "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"g\"\>", "]"}]}],
  SequenceForm[
  "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f", "g"], ", i=", 5, ", T=", 
   xAct`xPerm`GenSet["g"]],
  Editable->
   False]], "Print",ExpressionUUID->"06415d66-7266-4090-a75a-8e21c948117f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "]"}], 
   "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"g\"\>", "]"}]}],
  SequenceForm[
  "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f", "g"], ", i=", 4, ", T=", 
   xAct`xPerm`GenSet["g"]],
  Editable->
   False]], "Print",ExpressionUUID->"987d8047-a7cc-43c0-b4c1-a43a1f383d31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "]"}], 
   "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"g\"\>", "]"}]}],
  SequenceForm[
  "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f", "g"], ", i=", 3, ", T=", 
   xAct`xPerm`GenSet["g"]],
  Editable->
   False]], "Print",ExpressionUUID->"9acc6299-d1bf-4233-a618-79e1e20c433c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "]"}], 
   "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"g\"\>", "]"}]}],
  SequenceForm[
  "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f", "g"], ", i=", 2, ", T=", 
   xAct`xPerm`GenSet["g"]],
  Editable->
   False]], "Print",ExpressionUUID->"51ef94a9-699f-47fa-90fa-57fd9986d412"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Finished check of H(\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\") with base \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"10", ",", "8", ",", "2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and SGS \"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"c\"\>", ",", "\<\"d\"\>", ",", "\<\"e\"\>", ",", "\<\"f\"\>",
      ",", "\<\"g\"\>"}], "]"}]}],
  SequenceForm[
  "Finished check of H(", 2, ") with base ", {10, 8, 2, 1}, " and SGS ", 
   xAct`xPerm`GenSet["c", "d", "e", "f", "g"]],
  Editable->
   False]], "Print",ExpressionUUID->"af0bf51b-ec86-4be3-8d8b-63f0db33976c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Appended S[[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", "\<\"h\"\>"}],
  SequenceForm["Appended S[[", 8, "]]=", "h"],
  Editable->
   False]], "Print",ExpressionUUID->"e03f2ba1-61ff-44ee-88f8-d337549094ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Appended B[[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", "12"}],
  SequenceForm["Appended B[[", 6, "]]=", 12],
  Editable->
   False]], "Print",ExpressionUUID->"912261e1-8320-4062-ae75-2af7c9a60435"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", 
     ",", "\<\"h\"\>"}], "]"}], "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]",
    "6", "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"h\"\>", "]"}]}],
  SequenceForm[
  "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f", "g", "h"], ", i=", 6, 
   ", T=", 
   xAct`xPerm`GenSet["h"]],
  Editable->
   False]], "Print",ExpressionUUID->"98967a5f-29e3-4dbc-ba62-269258ee9407"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", 
     ",", "\<\"h\"\>"}], "]"}], "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]",
    "5", "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"h\"\>", "]"}]}],
  SequenceForm[
  "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f", "g", "h"], ", i=", 5, 
   ", T=", 
   xAct`xPerm`GenSet["h"]],
  Editable->
   False]], "Print",ExpressionUUID->"f04e7e2e-01b2-4607-8d0b-722c12d3e273"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", 
     ",", "\<\"h\"\>"}], "]"}], "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]",
    "4", "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"h\"\>", "]"}]}],
  SequenceForm[
  "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f", "g", "h"], ", i=", 4, 
   ", T=", 
   xAct`xPerm`GenSet["h"]],
  Editable->
   False]], "Print",ExpressionUUID->"e1f4bfba-00b1-43bd-8cd4-819712c7d997"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", 
     ",", "\<\"h\"\>"}], "]"}], "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]",
    "3", "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"h\"\>", "]"}]}],
  SequenceForm[
  "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f", "g", "h"], ", i=", 3, 
   ", T=", 
   xAct`xPerm`GenSet["h"]],
  Editable->
   False]], "Print",ExpressionUUID->"7290a760-8431-4f6c-8e61-1dd1af66c0ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Schreier-Sims-Step called with B=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], "}"}], 
   "\[InvisibleSpace]", "\<\", S=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", 
     ",", "\<\"h\"\>"}], "]"}], "\[InvisibleSpace]", "\<\", i=\"\>", "\[InvisibleSpace]",
    "2", "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", "\<\"h\"\>", "]"}]}],
  SequenceForm[
  "Schreier-Sims-Step called with B=", {9, 10, 8, 2, 1, 12}, ", S=", 
   xAct`xPerm`GenSet["a", "b", "c", "d", "e", "f", "g", "h"], ", i=", 2, 
   ", T=", 
   xAct`xPerm`GenSet["h"]],
  Editable->
   False]], "Print",ExpressionUUID->"70e4a27e-7a89-4eb0-9de7-883db6a6d887"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Finished check of H(\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\") with base \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"10", ",", "8", ",", "2", ",", "1", ",", "12"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and SGS \"\>", "\[InvisibleSpace]", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"c\"\>", ",", "\<\"d\"\>", ",", "\<\"e\"\>", ",", "\<\"f\"\>",
      ",", "\<\"g\"\>", ",", "\<\"h\"\>"}], "]"}]}],
  SequenceForm[
  "Finished check of H(", 2, ") with base ", {10, 8, 2, 1, 12}, " and SGS ", 
   xAct`xPerm`GenSet["c", "d", "e", "f", "g", "h"]],
  Editable->
   False]], "Print",ExpressionUUID->"5fbaa9f5-adc7-4429-84ce-e9b6dc44a5a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked \"\>", "\[InvisibleSpace]", "140", 
   "\[InvisibleSpace]", "\<\" generators and obtained group of order \"\>", "\[InvisibleSpace]",
    "27783"}],
  SequenceForm[
  "Checked ", 140, " generators and obtained group of order ", 27783],
  Editable->
   False]], "Print",ExpressionUUID->"8ccc990c-bdce-4182-adf8-2ba1afc97b44"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], "}"}], 
   ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>",
      ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", 
     ",", "\<\"h\"\>"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"5b2c61ea-c7e5-4be5-92e7-e58b47129bfb"]
}, Open  ]],

Cell["Note the influence of the notation:", \
"Text",ExpressionUUID->"2f8df695-4237-4807-89fc-11d5e4c1752a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"TranslatePerm", "[", 
     RowBox[{
      RowBox[{"GenSet", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Perm", ",", "21"}], "}"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"ae391e12-2052-457c-9997-8bee5a0ed28d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.47895999999999999685584839426155667752`5.700899158417253", ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], 
      "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "9", ",", "15", ",", "12", ",", "19", ",", "17", ",", "20", ",", 
          "18", ",", "1", ",", "8", ",", "3", ",", "2", ",", "10", ",", "7", ",",
           "4", ",", "11", ",", "5", ",", "16", ",", "13", ",", "14", ",", 
          "21", ",", "6"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "8", ",", "20", ",", "10", ",", "11", ",", "17", ",", "13", ",", 
          "14", ",", "15", ",", "16", ",", "19", ",", "9", ",", "12", ",", 
          "18", ",", "21"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "8", ",", "9", ",", "11", ",", "21", ",", "12", ",", "14", ",", 
          "16", ",", "15", ",", "13", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "10"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "21", ",", "9", ",", "16", ",", "11", ",", "12", ",", "8", ",", 
          "10", ",", "15", ",", "14", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "13"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "11", ",", "9", ",", "10", ",", "16", ",", "12", ",", "21", ",", 
          "13", ",", "15", ",", "8", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "14"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "6", ",", "2", ",", "5", ",", "7", ",", "3", ",", "4", ",",
           "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", 
          "14", ",", "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "21"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "6", ",", "2", ",", "5", ",", "3", ",", "4", ",", "7", ",", "1", ",",
           "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", 
          "14", ",", "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "21"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "8", ",", "9", ",", "10", ",", "11", ",", "15", ",", "13", ",", 
          "14", ",", "20", ",", "16", ",", "18", ",", "19", ",", "17", ",", 
          "12", ",", "21"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"56c5a3d9-6973-49c8-a083-f12c0d9f1736"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"1b6037f8-6abf-4dc0-9747-f915c10e8f5c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.27445300000000000251176857091195415705`5.459067895623801", ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], 
      "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"8", ",", "16", ",", "11"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"13", ",", "14", ",", "21"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "7", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
    "]"}]}], "}"}]], \
"Output",ExpressionUUID->"7c9bbb7a-9695-484b-bb15-0404df6badcf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"TranslatePerm", "[", 
     RowBox[{
      RowBox[{"GenSet", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "Rules"}], "]"}]}], 
   "]"}], "]"}]], \
"Input",ExpressionUUID->"c227e1c1-4966-4224-8803-aed5afe3491c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.31047799999999997622168734778824727982`5.512630745434407", ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], 
      "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "8"}], ",", 
         RowBox[{"8", "\[Rule]", "9"}], ",", 
         RowBox[{"9", "\[Rule]", "1"}], ",", 
         RowBox[{"2", "\[Rule]", "11"}], ",", 
         RowBox[{"11", "\[Rule]", "15"}], ",", 
         RowBox[{"15", "\[Rule]", "2"}], ",", 
         RowBox[{"3", "\[Rule]", "10"}], ",", 
         RowBox[{"10", "\[Rule]", "12"}], ",", 
         RowBox[{"12", "\[Rule]", "3"}], ",", 
         RowBox[{"4", "\[Rule]", "14"}], ",", 
         RowBox[{"14", "\[Rule]", "19"}], ",", 
         RowBox[{"19", "\[Rule]", "4"}], ",", 
         RowBox[{"5", "\[Rule]", "16"}], ",", 
         RowBox[{"16", "\[Rule]", "17"}], ",", 
         RowBox[{"17", "\[Rule]", "5"}], ",", 
         RowBox[{"6", "\[Rule]", "21"}], ",", 
         RowBox[{"21", "\[Rule]", "20"}], ",", 
         RowBox[{"20", "\[Rule]", "6"}], ",", 
         RowBox[{"7", "\[Rule]", "13"}], ",", 
         RowBox[{"13", "\[Rule]", "18"}], ",", 
         RowBox[{"18", "\[Rule]", "7"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"9", "\[Rule]", "18"}], ",", 
         RowBox[{"18", "\[Rule]", "20"}], ",", 
         RowBox[{"20", "\[Rule]", "9"}], ",", 
         RowBox[{"12", "\[Rule]", "19"}], ",", 
         RowBox[{"19", "\[Rule]", "17"}], ",", 
         RowBox[{"17", "\[Rule]", "12"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"10", "\[Rule]", "21"}], ",", 
         RowBox[{"21", "\[Rule]", "11"}], ",", 
         RowBox[{"11", "\[Rule]", "10"}], ",", 
         RowBox[{"13", "\[Rule]", "16"}], ",", 
         RowBox[{"16", "\[Rule]", "14"}], ",", 
         RowBox[{"14", "\[Rule]", "13"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"8", "\[Rule]", "13"}], ",", 
         RowBox[{"10", "\[Rule]", "14"}], ",", 
         RowBox[{"13", "\[Rule]", "21"}], ",", 
         RowBox[{"14", "\[Rule]", "16"}], ",", 
         RowBox[{"16", "\[Rule]", "10"}], ",", 
         RowBox[{"21", "\[Rule]", "8"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"8", "\[Rule]", "16"}], ",", 
         RowBox[{"11", "\[Rule]", "8"}], ",", 
         RowBox[{"13", "\[Rule]", "14"}], ",", 
         RowBox[{"14", "\[Rule]", "21"}], ",", 
         RowBox[{"16", "\[Rule]", "11"}], ",", 
         RowBox[{"21", "\[Rule]", "13"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"2", "\[Rule]", "3"}], ",", 
         RowBox[{"3", "\[Rule]", "6"}], ",", 
         RowBox[{"4", "\[Rule]", "7"}], ",", 
         RowBox[{"5", "\[Rule]", "4"}], ",", 
         RowBox[{"6", "\[Rule]", "2"}], ",", 
         RowBox[{"7", "\[Rule]", "5"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "7"}], ",", 
         RowBox[{"3", "\[Rule]", "4"}], ",", 
         RowBox[{"4", "\[Rule]", "5"}], ",", 
         RowBox[{"5", "\[Rule]", "3"}], ",", 
         RowBox[{"6", "\[Rule]", "1"}], ",", 
         RowBox[{"7", "\[Rule]", "6"}]}], "]"}], ",", 
       RowBox[{"Rules", "[", 
        RowBox[{
         RowBox[{"12", "\[Rule]", "20"}], ",", 
         RowBox[{"15", "\[Rule]", "12"}], ",", 
         RowBox[{"17", "\[Rule]", "19"}], ",", 
         RowBox[{"18", "\[Rule]", "17"}], ",", 
         RowBox[{"19", "\[Rule]", "18"}], ",", 
         RowBox[{"20", "\[Rule]", "15"}]}], "]"}]}], "]"}]}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"3ea0d4b5-4cad-4496-91ba-36c04ae6957c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"TranslatePerm", "[", 
     RowBox[{
      RowBox[{"GenSet", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Images", ",", "21"}], "}"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"9dd6bb94-7426-41ed-9048-3e5d13536963"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.44436199999999997922728312005347106606`5.668336826068854", ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "1", ",", "12"}], 
      "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{
         "8", ",", "11", ",", "10", ",", "14", ",", "16", ",", "21", ",", 
          "13", ",", "9", ",", "1", ",", "12", ",", "15", ",", "3", ",", "18",
           ",", "19", ",", "2", ",", "17", ",", "5", ",", "7", ",", "4", ",", 
          "6", ",", "20"}], "}"}], "]"}], ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "8", ",", "18", ",", "10", ",", "11", ",", "19", ",", "13", ",", 
          "14", ",", "15", ",", "16", ",", "12", ",", "20", ",", "17", ",", 
          "9", ",", "21"}], "}"}], "]"}], ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "8", ",", "9", ",", "21", ",", "10", ",", "12", ",", "16", ",", 
          "13", ",", "15", ",", "14", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "11"}], "}"}], "]"}], ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "13", ",", "9", ",", "14", ",", "11", ",", "12", ",", "21", ",", 
          "16", ",", "15", ",", "10", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "8"}], "}"}], "]"}], ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "16", ",", "9", ",", "10", ",", "8", ",", "12", ",", "14", ",", 
          "21", ",", "15", ",", "11", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "13"}], "}"}], "]"}], ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "3", ",", "6", ",", "7", ",", "4", ",", "2", ",", "5", ",",
           "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", 
          "14", ",", "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "21"}], "}"}], "]"}], ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{
         "7", ",", "2", ",", "4", ",", "5", ",", "3", ",", "1", ",", "6", ",",
           "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", 
          "14", ",", "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", 
          "20", ",", "21"}], "}"}], "]"}], ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",",
           "8", ",", "9", ",", "10", ",", "11", ",", "20", ",", "13", ",", 
          "14", ",", "12", ",", "16", ",", "19", ",", "17", ",", "18", ",", 
          "15", ",", "21"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"34aa991c-5470-4182-954e-e679ff0021d6"]
}, Open  ]],

Cell["Another example (Butler p. 133):", \
"Text",ExpressionUUID->"9db7c8c2-4623-4bb6-8125-bd1997ebf045"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "4", ",", "5", ",", "7", ",", "3", ",", "6"}], "}"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "6", ",", "3", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "7"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$xPermRules", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "->", "\"\<a\>\""}], ",", 
     RowBox[{"b", "->", "\"\<b\>\""}], ",", 
     RowBox[{"g1", "->", "\"\<g1\>\""}], ",", 
     RowBox[{"g2", "->", "\"\<g2\>\""}], ",", 
     RowBox[{"g3", "->", "\"\<g3\>\""}]}], "}"}]}], 
  ";"}]}], "Input",ExpressionUUID->"618a71a7-baae-4fc0-acd6-713f886f4217"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"UseRules", "\[Rule]", "$xPermRules"}]}], 
  "]"}]], "Input",ExpressionUUID->"98d7026a-e80e-450f-bf2c-687235655330"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"g1\"\>", 
     ",", "\<\"g3\"\>", ",", "\<\"g2\"\>"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"c750fd44-4f7c-45ac-a9ac-b36bdc7ec5ad"]
}, Open  ]],

Cell["\<\
The solution given by Butler is slightly different, because he is using \
algorithm \"Butler2\", which we have not encoded. We simply check that his \
permutation g3 is in our group:\
\>", "Text",ExpressionUUID->"3b3e813e-24c5-47de-a017-c64dcf929e58"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"692490d3-d34e-4547-b6f4-15ff7338656a"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "4", ",", "5", ",", "7", ",", "3", ",", "6"}], 
       "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "6", ",", "3", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "7"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"170a3e88-c1f0-4b66-ac55-26c5744b4a72"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7"}], "}"}]}], "]"}], ",", "%"}], 
  "]"}]], "Input",ExpressionUUID->"82c994b7-8b2f-47ba-bbe7-9e4ce7fc34bb"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"6d05449c-fcc7-4ccd-82c4-ef2d24e95b23"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
4.8. Some important SGS. Symmetric, Antisymmetric, PairSymmetric\
\>", "Subsection",ExpressionUUID->"fba3c482-0c60-4404-83e7-f54e5513d9de"],

Cell["Strong generating sets for important groups:", \
"Text",ExpressionUUID->"8415e558-2061-4f85-9012-3d0ebd389864"],

Cell[TextData[{
 "These two are now (from xPerm 1.2.0) inert heads, as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " v9 contains them as well in inert form:"
}], "Text",ExpressionUUID->"9a660282-5f44-4f33-85a7-5bc79beb3a44"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Symmetric", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Symmetric", "[", 
    RowBox[{"inds_List", ",", "not_"}], "]"}], ":=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"Sort", "@", "inds"}], ",", 
     RowBox[{"TranslatePerm", "[", 
      RowBox[{
       RowBox[{"GenSet", "@@", 
        RowBox[{"(", 
         RowBox[{"Cycles", "/@", 
          RowBox[{"Partition", "[", 
           RowBox[{
            RowBox[{"Sort", "@", "inds"}], ",", "2", ",", "1"}], "]"}]}], 
         ")"}]}], ",", "not"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Symmetric", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "_"}], "]"}], ":=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Symmetric", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c48ce0c1-dbc0-49e2-a9b0-499b952e07e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierSims", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierSims", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Symmetric", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "3", ",", "6"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5"}], "}"}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"803344c2-c207-475b-bb24-75052bc7d655"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierSims", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"24185840-addc-43a8-bad4-34e42c78dbb6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Symmetric", ",", "\[IndentingNewLine]", 
   RowBox[{"Symmetric", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "3", ",", "6"}], "}"}], ",", "Cycles"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5"}], "}"}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"64ba935c-92c0-4d44-9f51-a60192f69a3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Symmetric", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"c8359d67-a826-4ce9-af93-eff4513871c8"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "Antisymmetric", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"inds_List", ",", "not_"}], "]"}], ":=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"Sort", "@", "inds"}], ",", 
     RowBox[{"TranslatePerm", "[", 
      RowBox[{
       RowBox[{"GenSet", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Cycles", "[", "#", "]"}]}], "&"}], "/@", 
          RowBox[{"Partition", "[", 
           RowBox[{
            RowBox[{"Sort", "@", "inds"}], ",", "2", ",", "1"}], "]"}]}], 
         ")"}]}], ",", "not"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Antisymmetric", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "_"}], "]"}], ":=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"-", "ID"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Antisymmetric", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3c1289e5-9945-446b-b6e3-fc39d14bafea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"SchreierSims", ",", "\[IndentingNewLine]", 
   RowBox[{"SchreierSims", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Antisymmetric", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "3", ",", "6"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "5"}], "}"}], "]"}]}], ",", 
       RowBox[{"-", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"5", ",", "6"}], "}"}], "]"}]}]}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"b5dbf519-290a-4ff9-9664-b73b90c29078"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SchreierSims", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d7bca8e5-9535-4d84-9722-7582776d4e0c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"Antisymmetric", ",", "\[IndentingNewLine]", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "3", ",", "6"}], "}"}], ",", "Cycles"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "5"}], "}"}], "]"}]}], ",", 
       RowBox[{"-", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"5", ",", "6"}], "}"}], "]"}]}]}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3282c842-1a54-49fd-95d7-bb84718dba5b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Antisymmetric", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"d66758c4-9f62-4703-b86c-8331378758bc"]
}, Open  ]],

Cell["\<\
Here we are including the four points in the base, instead of only the two \
needed, just for aesthetics of the results when sorting indices:\
\>", "Text",ExpressionUUID->"2c09a559-46d5-4fdc-ac2b-2c389f427d9e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"RiemannSymmetric", "[", 
   RowBox[{
    RowBox[{"inds", ":", 
     RowBox[{"{", 
      RowBox[{"i1_", ",", "i2_", ",", "i3_", ",", "i4_"}], "}"}]}], ",", 
    RowBox[{"not_", ":", "Cycles"}]}], "]"}], ":=", 
  RowBox[{"StrongGenSet", "[", 
   RowBox[{
    RowBox[{"Sort", "@", "inds"}], ",", 
    RowBox[{"TranslatePerm", "[", 
     RowBox[{
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "i3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "i4"}], "}"}]}], "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "i2"}], "}"}], "]"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"i3", ",", "i4"}], "}"}], "]"}]}]}], "]"}], ",", "not"}], 
     "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RiemannSymmetry", "=", "RiemannSymmetric"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"2762641b-1f8a-49f1-a5fe-8186aeccb624"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"addperm", "[", 
    RowBox[{"sign", ":", 
     RowBox[{"(", 
      RowBox[{"1", "|", 
       RowBox[{"-", "1"}]}], ")"}]}], "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1a_", ",", "p1b_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"p2a_", ",", "p2b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"GenSet", "[", 
   RowBox[{"sign", " ", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1a", ",", "p2a"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"p1b", ",", "p2b"}], "}"}]}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"addperm", "[", 
    RowBox[{"sign", ":", 
     RowBox[{"(", 
      RowBox[{"1", "|", 
       RowBox[{"-", "1"}]}], ")"}]}], "]"}], "[", 
   RowBox[{"pair_List", ",", "pairs__List"}], "]"}], ":=", 
  RowBox[{"GenSet", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sign", "^", 
      RowBox[{"Length", "[", 
       RowBox[{"{", "pairs", "}"}], "]"}]}], " ", 
     RowBox[{"Cycles", "@@", 
      RowBox[{"Transpose", "@", 
       RowBox[{"RotateRight", "[", 
        RowBox[{"{", 
         RowBox[{"pair", ",", "pairs"}], "}"}], "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"addperm", "[", "sign", "]"}], "[", "pairs", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"addperm", "[", "_", "]"}], "[", "__", "]"}], ":=", 
  RowBox[{"GenSet", "[", "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c06c43eb-4a5c-4255-a3be-5aa51eec64a0"],

Cell["Again, now we add all points in the base:", \
"Text",ExpressionUUID->"16e65ef2-4f13-4763-999a-9c4375944993"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PairSymmetric", "[", 
    RowBox[{
     RowBox[{"pairs", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"_", ",", "_"}], "}"}], "..."}], "}"}]}], ",", "sym1_", ",", 
     "sym2_", ",", 
     RowBox[{"not_", ":", "Cycles"}]}], "]"}], ":=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"Sort", "[", 
      RowBox[{"Flatten", "@", "pairs"}], "]"}], ",", 
     RowBox[{"TranslatePerm", "[", 
      RowBox[{
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"addperm", "[", "sym1", "]"}], "@@", "pairs"}], ",", 
         RowBox[{"Switch", "[", 
          RowBox[{"sym2", ",", "1", ",", 
           RowBox[{"GenSet", "@@", 
            RowBox[{"Map", "[", 
             RowBox[{"Cycles", ",", "pairs"}], "]"}]}], ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"GenSet", "@@", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"Cycles", "[", "#", "]"}]}], "&"}], ",", "pairs"}], 
             "]"}]}], ",", "_", ",", 
           RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}], ",", "not"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"abf928b3-17a9-4434-899d-8fa65bee354d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairSymmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "14"}], "}"}]}], "}"}], ",", "1", ",", 
   RowBox[{"-", "1"}]}], 
  "]"}]], "Input",ExpressionUUID->"d6493491-163e-49dc-b8ac-b439d6319136"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14"}], 
    "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "1", ",", "3", ",", "5", ",", "7", ",", "9", ",", "11", ",", "13"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "2", ",", "4", ",", "6", ",", "8", ",", "10", ",", "12", ",", "14"}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5", ",", "7", ",", "9", ",", "11", ",", "13"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "6", ",", "8", ",", "10", ",", "12", ",", "14"}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "7", ",", "9", ",", "11", ",", "13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "8", ",", "10", ",", "12", ",", "14"}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "9", ",", "11", ",", "13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "10", ",", "12", ",", "14"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9", ",", "11", ",", "13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "12", ",", "14"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"11", ",", "13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "14"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"7", ",", "8"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"9", ",", "10"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"11", ",", "12"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"13", ",", "14"}], "}"}], "]"}]}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"535af08b-99ad-4008-b908-67284a99fa9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairSymmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "14"}], "}"}]}], "}"}], ",", "0", ",", 
   RowBox[{"-", "1"}]}], 
  "]"}]], "Input",ExpressionUUID->"0d732c5f-484f-4ebd-bb53-8f03beb718b7"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14"}], 
    "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"7", ",", "8"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"9", ",", "10"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"11", ",", "12"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"13", ",", "14"}], "}"}], "]"}]}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"2d866e96-dbb1-46b0-9400-d2cd22a9b72e"]
}, Open  ]],

Cell["\<\
Note there is no difference in the base between these two results:\
\>", "Text",ExpressionUUID->"9b25c113-cfa0-4910-bcf3-a6268f38bed2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairSymmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "1", ",", 
   RowBox[{"-", "1"}]}], 
  "]"}]], "Input",ExpressionUUID->"0154d912-f761-42d1-b650-c55c235bb2bc"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"d5ca1990-3c4f-4016-aaf0-ab1169c10fa2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSymmetric", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"16df8321-6c7b-4915-a67b-5c0aed27bae9"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"ed77bd61-d1c2-4e78-b3e7-75f357401a78"]
}, Open  ]],

Cell["More examples:", \
"Text",ExpressionUUID->"a2f0d342-1675-442f-b2b6-f5f9f5335db4"],

Cell["S2:", "Text",ExpressionUUID->"15ff9c47-44af-45ea-8f86-b4654ac490c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"e87512f0-143c-43fe-8697-55fecd7eebde"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"2cf8c91b-a929-468b-89ec-274961000fe8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "SGS", 
  "]"}]], "Input",ExpressionUUID->"a425b344-2630-4423-a73d-41f74d5543e8"],

Cell[BoxData["2"], \
"Output",ExpressionUUID->"c9b2bbe6-c935-4e89-8fff-9fd51285ddf1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", "SGS", "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"2ee0bb5f-8ea0-46a1-9a19-93e7919baae9"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{1, 2}]]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"6a597e93-3247-4ce9-8ef1-a884bc5e549d"]
}, Open  ]],

Cell["S3:", "Text",ExpressionUUID->"18dd1335-5a6f-4a55-b731-fa23daca0380"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"4dbbd814-7565-4647-8c96-f9014560bbe6"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"083b8ef0-8c3e-4c28-b9db-8361c88846ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "SGS", 
  "]"}]], "Input",ExpressionUUID->"de651a75-3885-49dd-92a5-ab611959bc94"],

Cell[BoxData["6"], \
"Output",ExpressionUUID->"bde61b8b-0f99-4601-8aa5-ca2f36269ebe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", "SGS", "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"4b634eac-3252-4a76-9764-f4b3cb1248bb"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "2", "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 2}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{1, 2}], 
      xAct`xPerm`Cycles[{2, 3}]]], 
    xAct`xPerm`StrongGenSet[{2}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{2, 3}]]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"c4c30bdb-68c6-4350-87b0-819958b83280"]
}, Open  ]],

Cell["S4:", "Text",ExpressionUUID->"38016f8a-b335-45c7-8df7-21baee96f17e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"65427cb1-38d0-4641-8dfe-e88935191847"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"ab918266-8572-4ec2-8076-7b1ed249fbaa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "SGS", 
  "]"}]], "Input",ExpressionUUID->"29bb912d-d1c2-4d82-858f-7f151962100d"],

Cell[BoxData["24"], \
"Output",ExpressionUUID->"3c28c379-b6aa-4c8f-aeaa-76eb7071b130"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", "SGS", "]"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"acbad649-0c33-4de6-815e-47ccab0f6ad6"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "3", "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}], "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 2, 3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{1, 2}], 
      xAct`xPerm`Cycles[{2, 3}], 
      xAct`xPerm`Cycles[{3, 4}]]], 
    xAct`xPerm`StrongGenSet[{2, 3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{2, 3}], 
      xAct`xPerm`Cycles[{3, 4}]]], 
    xAct`xPerm`StrongGenSet[{3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{3, 4}]]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->
   False]], "Output",ExpressionUUID->"bcd5bf22-bebf-4690-bd9b-a439e7404025"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.9. Stabilization II", \
"Subsection",ExpressionUUID->"8ce8f54c-0918-4266-b6fd-1c33c818a74a"],

Cell[CellGroupData[{

Cell["4.9.1. Stabilizer", \
"Subsubsection",ExpressionUUID->"1e8e6b73-732a-4bf6-bd5a-5bbbd9f99cd2"],

Cell["\<\
Given a group, this function gives the stabilizer subgroup of a list of \
points. It first constructs a new SGS with those points at the beginning of \
the base. Then it is trivial to compute the stabilizer:\
\>", "Text",ExpressionUUID->"494106f9-9ea4-464e-96ee-eb7f4d9c17ca"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Stabilizer", "[", 
    RowBox[{"points_List", ",", "SGS_"}], "]"}], ":=", 
   RowBox[{"Stabilizer", "[", 
    RowBox[{"points", ",", "SGS", ",", 
     RowBox[{"PermLength", "[", "SGS", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Stabilizer", "[", 
    RowBox[{"points_List", ",", 
     RowBox[{"SGS", ":", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base_", ",", "GS_"}], "]"}]}], ",", "len_Integer"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"DeleteCases", "[", 
        RowBox[{"#1", ",", 
         RowBox[{"Alternatives", "@@", "points"}]}], "]"}], ",", 
       RowBox[{"Stabilizer", "[", 
        RowBox[{"points", ",", "#2"}], "]"}]}], "]"}], "&"}], "@@", 
    RowBox[{"BaseChange", "[", 
     RowBox[{"SGS", ",", 
      RowBox[{"points", "~", "Join", "~", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"base", ",", 
         RowBox[{"Alternatives", "@@", "points"}]}], "]"}]}], ",", "len"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Stabilizer", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Stabilizer", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"beb60338-430d-424b-9af0-a7c30dcb7256"],

Cell["Compare:", \
"Text",ExpressionUUID->"724c810b-eba8-402d-9c52-f10b01a0ed57"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SGS", "=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"57f3f96e-76a5-4893-b5bb-ad905d6330e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "==", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"SGS", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"SGS", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", "3"}], 
   "]"}]}]], "Input",ExpressionUUID->"04574d60-a487-42ed-b9d0-75587f7e5f1a"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"198e146e-ac35-4dc7-bad0-8ae2de0caa72"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stabilizer", "[", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", "SGS", ",", "3"}], 
  "]"}]], "Input",ExpressionUUID->"fefa191c-e5fb-4551-bf9c-cdbdf0c0beaa"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "]"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"ea836faa-82d7-4e44-9210-b6690b8859de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stabilizer", "[", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"SGS", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"cc7f545e-7825-4542-8713-fe1b86026475"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  "]"}]], "Output",ExpressionUUID->"52bbbee8-7aba-4f6a-ae10-c8efb63a6159"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SGS", 
  "=."}]], "Input",ExpressionUUID->"673e9854-f050-4d61-847c-f551ee34b2c3"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.9.2. SetStabilizer", \
"Subsubsection",ExpressionUUID->"e4cda5f7-dabb-4a5f-a4d5-e8ee4f3057d9"],

Cell["\<\
Set-stabilization with strong generating sets is a simple application of the \
backtrack algorithm. See the Case Study 4 in page 113 of Butler's book.\
\>", "Text",ExpressionUUID->"bddc45f7-f92d-4c35-a8fd-b91fab981ae1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetStabilizerProperty", "[", 
    RowBox[{"points_List", ",", "perm_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Complement", "[", 
     RowBox[{
      RowBox[{"OnPoints", "[", 
       RowBox[{"points", ",", "perm"}], "]"}], ",", "points"}], "]"}], "===", 
    
    RowBox[{"{", "}"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"32ca0058-2066-4a3a-aa64-d0dcf83729b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "SetStabilizer", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MathLink", "\[RuleDelayed]", "$xpermQ"}], ",", 
     RowBox[{"xPermVerbose", "\[Rule]", "False"}], ",", 
     RowBox[{"OrderedBase", "\[Rule]", "False"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fcde4626-0523-4a47-8de9-13783866c8ea"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetStabilizer", "[", 
    RowBox[{"points_", ",", 
     RowBox[{"sgs", ":", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base_", ",", "GS_"}], "]"}]}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"OptionValue", "[", "MathLink", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"MathLinkSetStabilizer", "[", 
      RowBox[{"points", ",", 
       RowBox[{"Max", "[", 
        RowBox[{"points", ",", "base", ",", 
         RowBox[{"PermLength", "[", "GS", "]"}]}], "]"}], ",", "sgs", ",", 
       "options"}], "]"}], ",", 
     RowBox[{"Search", "[", 
      RowBox[{
       RowBox[{"StrongGenSet", "[", 
        RowBox[{"base", ",", "GS"}], "]"}], ",", 
       RowBox[{
        RowBox[{"SetStabilizerProperty", "[", 
         RowBox[{"points", ",", "#"}], "]"}], "&"}], ",", "1", ",", 
       RowBox[{"StrongGenSet", "[", 
        RowBox[{"base", ",", 
         RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "options"}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"SetStabilizer", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "SetStabilizer", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"632a9ed2-a903-4484-8357-7a0c7819bde3"],

Cell["Example:", \
"Text",ExpressionUUID->"d201bcf9-3b3f-4f18-904d-172ed7ef3e30"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"StrongGenSet", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"243bd3fc-de4a-485f-bd02-9694dfaf7095"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"fba36c70-ed88-4d69-86c3-3f83aba27794"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"a2ee90f4-01b6-4c54-9215-0fd4f73d50de"],

Cell[BoxData["24"], \
"Output",ExpressionUUID->"625c0c27-d158-4451-a82b-701b89b449fc"]
}, Open  ]],

Cell["\<\
The stabilizer of a set of points is always a subgroup of the set-stabilizer \
of those points:\
\>", "Text",ExpressionUUID->"a247c422-cc8a-43eb-a11f-6cc418f094f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stabilizer", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "SGS"}], 
  "]"}]], "Input",ExpressionUUID->"2beaee6b-446e-4eba-ad05-9a597663d7ca"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"dba69733-2506-4510-9009-759a07cc1661"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimino", "[", 
  RowBox[{"Last", "[", "%", "]"}], 
  "]"}]], "Input",ExpressionUUID->"df50c608-cc2e-4f01-acdb-40fc88dd276c"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"94999a82-2359-444a-b17e-56f71dc89de6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetStabilizer", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "SGS"}], 
  "]"}]], "Input",ExpressionUUID->"3663c817-a6a8-4a9e-b454-3fdbd969a704"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"7a03e583-31e8-496f-8e46-ffc3f7dbd139"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimino", "[", 
  RowBox[{"Last", "[", "%", "]"}], 
  "]"}]], "Input",ExpressionUUID->"7aeb3fd0-3a7a-4d58-9d82-f829022bd59c"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"39a3ee96-bd66-4de1-a953-0f73c568c19a"]
}, Open  ]],

Cell["Another example:", \
"Text",ExpressionUUID->"cbb8d2c0-0c88-44a8-87ec-20369601bbde"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stabilizer", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "SGS"}], 
  "]"}]], "Input",ExpressionUUID->"6abd7727-6ee1-4648-a77f-74a5bbb73276"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"43a5397c-f932-4ed7-80e6-738952be8415"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimino", "[", 
  RowBox[{"Last", "[", "%", "]"}], 
  "]"}]], "Input",ExpressionUUID->"920a11c7-c3fb-4fa3-9fb0-524d561fbbbd"],

Cell[BoxData[
 RowBox[{"Group", "[", "ID", 
  "]"}]], "Output",ExpressionUUID->"179182b8-2efc-4e70-93fe-765e2a622456"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetStabilizer", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "SGS"}], 
  "]"}]], "Input",ExpressionUUID->"63a11f0f-3bf4-45db-a7f5-7658fe35dcfb"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"b402dc72-bae0-4129-acda-29b8f073937c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimino", "[", 
  RowBox[{"Last", "[", "%", "]"}], 
  "]"}]], "Input",ExpressionUUID->"46dfd936-b187-4783-a401-773e5063493c"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"da563cb7-730e-43c7-8000-08aea572820b"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5. Canonicalization",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"deaf4245-fbe9-4b5f-947c-bd22d062cf32"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}],
    "*", " ", "5.", " ", "Canonicalization"}], " ", 
  "***********************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5cbf84aa-c471-48d8-9518-313e45246dda"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"cede4155-25e1-4ed0-baed-a329158ce383"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "21.818566999999998`", ",", "67.350692`8.279887055770832", ",", 
   "0.3239549227657802`"}], 
  "}"}]], "Output",ExpressionUUID->"80b022bb-4ecd-4a20-b990-28f6c247e141"]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.0. Comments", \
"Subsection",ExpressionUUID->"26b08ab3-3691-4527-8ac7-56ef2dbbf6e8"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"$ReadingVerbose", ",", 
   RowBox[{"Print", "[", "\"\<Reading section 5: Canonicalization\>\"", "]"}],
    ",", "Null", ",", "Null"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0c2f0fc4-8a65-4c77-8b14-538f59b1923c"],

Cell[TextData[{
 "The process of canonicalization is based on the use of two groups: the \
group S of slot-symmetries and the group D of dummy-symmetries. It is natural \
to send the information concerning S using slots, and the information \
concerning D using names (that is, positions in the canonical list) of \
indices, and we shall follow this convention here. However, the papers by \
Portugal et al. always use slots, having to use a permutation h which keeps \
track of the shifts of dummies. On the other hand each permutation can be \
given as it is or through its inverse. Unfortunately we use in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " precisely the opposite notation to that of Portugal et al, but still we \
want to use their algorithms as they are. We solve this conflict by having \
InversePerm at the input and at the output in the only CanonicalPerm call in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". That means that in this package we shall use Portugal's notation \
everywhere: permutations map slots to indices: the image of a slot under a \
permutation is the index at that slot. In other words, sorting according to a \
basis of S means deciding the priorities of the different slots."
}], "Text",ExpressionUUID->"e05d9f39-f79e-415b-8237-c056d1d6cd1f"]
}, Closed]],

Cell[CellGroupData[{

Cell["5.1. RightCosetRepresentative", \
"Subsection",ExpressionUUID->"b1a5dac9-03fa-4562-9db3-a4a6adb0e142"],

Cell[CellGroupData[{

Cell["5.1.0. Comments", \
"Subsubsection",ExpressionUUID->"6a33fb45-3904-427f-a0d4-1b5ba5353d13"],

Cell[TextData[{
 "From the point of view of tensor indices, we must distinguish two different \
numbered objects: slots and indices. We start from a given index \
configuration C={a, c, b, ...} which can be obtained from a standard \
configuration C0={a, b, c, ...} as C.g=C9 with a permutation g. On the other \
hand we have a symmetry group S of permutations of slots in the tensor, \
independently of which indices are in those slots. In this sense, two \
configurations C1 and C2 are equivalent if they can be related by C1=C2.s \
with s in S. If C1.g1=C0 and C2.g2=C0 then permutations g1 and g2 are \
equivalent if g2=s.g1. We see that S acts on the left on the permutations (we \
are working with right-cosets). In other words, s reshuffle the slots and \
then g maps slots to indices. In the RightCosetRepresentative we always use \
slots only.\n\nAs we said, this is the choice in the Portugal's papers: For \
instance, in page 5 of math-ph/0107031 he says that permutation (1,3,2,4) in \
cyclic notation converts T^{abcd} into T^{cdba}. To stress this point, \
starting version 0.6 (July 2007) of ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " we have changed the name CosetRepresentative to RightCosetRepresentative."
}], "Text",ExpressionUUID->"82443bf0-3df5-4dbc-9b5c-b16dc8136991"]
}, Closed]],

Cell[CellGroupData[{

Cell["5.1.1. Code", \
"Subsubsection",ExpressionUUID->"499ca870-2018-4df2-909a-0904d648c1da"],

Cell["\<\
September 2004. Important change: the subroutine is changed to imitate \
Canon's behaviour. This is not better or faster, I just want to facilitate \
comparison of both codes. There are two modifications:
\t1) new input: free. List of free slots. Only those slots need to be \
canonicalized. In our previous code all slots were canonicalized.
\t2) new output: apart from the canonical representative, we output the new \
list of free slots and the new SGS for the group S.\
\>", "Text",ExpressionUUID->"bd6c6eda-6fbb-44e5-8dc1-a5b937a281ad"],

Cell["\<\
February 2008. The If[Delta1=={},Continue[]] statement requires some \
additional comments. When this is executed we are leaving a base point \
without stabilization, and hence we will later stabilize base points which \
are not first in the base. This is not dangerous because of the following \
reason: if Delta1 is empty that means that the bi point under analysis \
belongs to an orbit Delta with no intersection with the free slots. That \
means that the slots in that orbit are decoupled from the eventual moves of \
other slots to canonicalize the given permutation with respect to free \
indices. When we find an orbit in which our free slots participate then that \
orbit is arranged properly until we drop all free slots from it, and so we go \
back to the previous case.\
\>", "Text",ExpressionUUID->"eda26a9e-b543-444e-8bda-ca222232609b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "RightCosetRepresentative"}]], \
"Input",ExpressionUUID->"c455ad3c-13c4-46df-b523-ed96d959d630"],

Cell[BoxData[
 StyleBox["\<\"RightCosetRepresentative[perm, n, SGS] for an unsigned \
permutation perm of degree n and a SGS for group S gives a canonical \
representative of the right coset S.perm of perm with respect to subgroup S \
of the symmetric group Sn. The criterium is the minimization of images of \
points of the base of SGS under the elements of the coset, following the \
order given by the base. A fourth argument can be used to give additional \
priority to some points (the free slots in the tensorial context)..\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567978014-5455693",ExpressionUUID->"5a2c9f76-c09d-465a-9c14-\
e4879e3750cb"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "xAct`xPerm`RightCosetRepresentative", "]"}], "=", 
   
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"xPermVerbose", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
     RowBox[{"BaseChangeCheck", "\[Rule]", "False"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"MathLink", "\[RuleDelayed]", "$xpermQ"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
    RowBox[{"p_", ",", "len_", ",", 
     RowBox[{"sym", ":", 
      RowBox[{"(", 
       RowBox[{"_Symmetric", "|", "_Antisymmetric"}], ")"}]}], ",", 
     "rest___"}], "]"}], ":=", 
   RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
    RowBox[{"p", ",", "len", ",", 
     RowBox[{"SchreierSims", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "sym"}], "]"}], ",", "rest"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
     RowBox[{
      RowBox[{"p_", "?", "PermQ"}], ",", "len_Integer", ",", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{"base_List", ",", "GS_GenSet"}], "]"}], ",", "free_List", ",", 
      
      RowBox[{"options", ":", 
       RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"perm", "=", "p"}], ",", 
        RowBox[{"newGS", "=", "GS"}], ",", 
        RowBox[{"newbase", "=", "base"}], ",", "newbase2", ",", "newGS2", ",", 
        RowBox[{"newfree", "=", "free"}], ",", "Delta", ",", "Delta1", ",", 
        "Deltap", ",", "k", ",", "pk", ",", "pp", ",", "om", ",", "bi", ",", 
        RowBox[{"n", "=", "0"}], ",", "verb", ",", "bcc"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"verb", ",", "bcc"}], "}"}], "=", 
        RowBox[{"OptionValue", "[", 
         RowBox[{"{", 
          RowBox[{"xPermVerbose", ",", "BaseChangeCheck"}], "}"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          
          RowBox[{"\"\<RIGHT-COSET-REPRESENTATIVE ALGORITHM for \>\"", ",", 
           "p"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<which corresponds to the index list: \>\"", ",", 
           RowBox[{"TranslatePerm", "[", 
            RowBox[{
             RowBox[{"InversePerm", "[", "p", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"Perm", ",", "len"}], "}"}]}], "]"}]}], "]"}]}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<base: \>\"", ",", "base"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Loop", " ", "over", " ", "elements", " ", "of", " ", "base"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{
          RowBox[{"i", "\[LessEqual]", 
           RowBox[{"Length", "[", "base", "]"}]}], "&&", 
          RowBox[{"n", "<", 
           RowBox[{"Length", "[", "free", "]"}]}]}], ",", 
         RowBox[{"++", "i"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"bi", "=", 
           RowBox[{"base", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<****** Analysing element i=\>\"", ",", "i", 
              ",", "\"\< of base: slot \>\"", ",", "bi", 
              ",", "\"\< ******\>\""}], "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Delta", "=", 
           RowBox[{"SchreierOrbit", "[", 
            RowBox[{"bi", ",", 
             RowBox[{"StrongGenSet", "[", 
              RowBox[{"newbase", ",", "newGS"}], "]"}], ",", "len"}], "]"}]}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<Symmetry orbit Delta of slots: \>\"", ",", 
              RowBox[{"First", "[", "Delta", "]"}]}], "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<Free slots: \>\"", ",", "newfree"}], "]"}]}], "]"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"Delta1", "=", 
           RowBox[{"Cases", "[", 
            RowBox[{
             RowBox[{"First", "[", "Delta", "]"}], ",", 
             RowBox[{"Alternatives", "@@", "newfree"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<Free slots that can go to that slot: \>\"", ",", 
              "Delta1"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Delta1", "\[Equal]", 
             RowBox[{"{", "}"}]}], ",", 
            RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Tensor", " ", 
            RowBox[{"notation", ":", " ", 
             RowBox[{
             "perm", " ", "acts", " ", "on", " ", "slots", " ", "giving", " ",
               "indices"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"Deltap", "=", 
           RowBox[{"OnPoints", "[", 
            RowBox[{"Delta1", ",", "perm"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<At those slots we respectively find indices Deltap: \
\>\"", ",", "Deltap"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"k", "=", 
           RowBox[{"MinB", "[", 
            RowBox[{"Deltap", ",", "base"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"pk", "=", 
           RowBox[{
            RowBox[{"Position", "[", 
             RowBox[{"Deltap", ",", "k"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<The least index is \>\"", ",", "k", 
              ",", "\"\<, found at position pk: \>\"", ",", "pk", 
              ",", "\"\< of Deltap\>\""}], "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"pp", "=", 
           RowBox[{"Delta1", "[", 
            RowBox[{"[", "pk", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<That index is found in tensor at slot pp: \>\"", ",",
               "pp"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"om", "=", 
           RowBox[{"TraceSchreier", "[", 
            RowBox[{"pp", ",", "Delta"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<We can move slot \>\"", ",", "pp", 
              ",", "\"\< to slot \>\"", ",", "bi", 
              ",", "\"\< using permutation om: \>\"", ",", "om", ",", 
              " ", "\"\< in S\>\""}], "]"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"perm", "=", 
           RowBox[{"PermProduct", "[", 
            RowBox[{"om", ",", "perm"}], "]"}]}], ";", "\[IndentingNewLine]", 
          
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<New indices list: \>\"", ",", 
              RowBox[{"TranslatePerm", "[", 
               RowBox[{
                RowBox[{"InversePerm", "[", "perm", "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Perm", ",", "len"}], "}"}]}], "]"}]}], "]"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "New", " ", "position", " ", "of", " ", "free", " ", "indices"}], 
           " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"newfree", "=", 
           RowBox[{"OnPoints", "[", 
            RowBox[{"newfree", ",", 
             RowBox[{"InversePerm", "[", "om", "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<Computing stabilizer in S of slot \>\"", ",", 
              "bi"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Ensure", " ", "bi", " ", "is", " ", "the", " ", "first", " ", 
            "point", " ", "of", " ", "the", " ", "base"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<SGS before change: \>\"", ",", 
              RowBox[{"StrongGenSet", "[", 
               RowBox[{"newbase", ",", "newGS"}], "]"}]}], "]"}]}], "]"}], ";",
           "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"newbase2", ",", "newGS2"}], "}"}], "=", 
           RowBox[{"List", "@@", 
            RowBox[{"BaseChange", "[", 
             RowBox[{
              RowBox[{"StrongGenSet", "[", 
               RowBox[{"newbase", ",", "newGS"}], "]"}], ",", 
              RowBox[{"{", "bi", "}"}], ",", "len"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<SGS after change: \>\"", ",", 
              RowBox[{"StrongGenSet", "[", 
               RowBox[{"newbase2", ",", "newGS2"}], "]"}]}], "]"}]}], "]"}], ";",
           "\[IndentingNewLine]", 
          RowBox[{"newbase2", "=", 
           RowBox[{"Drop", "[", 
            RowBox[{"newbase2", ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"newGS2", "=", 
           RowBox[{"Stabilizer", "[", 
            RowBox[{
             RowBox[{"{", "bi", "}"}], ",", "newGS2"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<SGS after stabilization: \>\"", ",", 
              RowBox[{"StrongGenSet", "[", 
               RowBox[{"newbase2", ",", "newGS2"}], "]"}]}], "]"}]}], "]"}], ";",
           "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Check", " ", "necessity", " ", "of", " ", "the", " ", "base", " ",
             "change"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"bcc", "&&", 
             RowBox[{"newbase2", "=!=", 
              RowBox[{"DeleteCases", "[", 
               RowBox[{"newbase", ",", "bi"}], "]"}]}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Print", "[", 
              
              RowBox[{"\"\<Checking \>\"", ",", "newbase", 
               ",", "\"\< vs. \>\"", ",", " ", "newbase2", 
               ",", "\"\< with point \>\"", ",", "bi"}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Block", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"$RecursionLimit", "=", "Infinity"}], "}"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"OrderOfGroup", "[", 
                   RowBox[{"StrongGenSet", "[", 
                    RowBox[{"newbase2", ",", "newGS2"}], "]"}], "]"}], "=!=", 
                  
                  RowBox[{"OrderOfGroup", "[", 
                   RowBox[{"StrongGenSet", "[", 
                    RowBox[{
                    RowBox[{"DeleteCases", "[", 
                    RowBox[{"newbase", ",", "bi"}], "]"}], ",", 
                    RowBox[{"Stabilizer", "[", 
                    RowBox[{
                    RowBox[{"{", "bi", "}"}], ",", "newGS"}], "]"}]}], "]"}], 
                   "]"}]}], ",", 
                 RowBox[{
                 "Print", "[", "\"\<Unavoidable base change. Contact JMM.\>\"",
                   "]"}]}], "]"}]}], "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"newbase", "=", "newbase2"}], ";", 
          RowBox[{"newGS", "=", "newGS2"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"verb", ",", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<newbase after change: \>\"", ",", "newbase"}], 
             "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"++", "n"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "We", " ", "return", " ", "the", " ", "canonical", " ", "permutation",
          " ", "and", " ", "the", " ", "new", " ", "SGS"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"perm", ",", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{"newbase", ",", "newGS"}], "]"}], ",", "newfree"}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Default", " ", "definition"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
    RowBox[{
     RowBox[{"p_", "?", "PermQ"}], ",", "len_Integer", ",", 
     "SGS_StrongGenSet", ",", "options___"}], "]"}], ":=", 
   RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
    RowBox[{"p", ",", "len", ",", "SGS", ",", 
     RowBox[{"Range", "[", "len", "]"}], ",", "options"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xAct`xPerm`RightCosetRepresentative", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "xAct`xPerm`RightCosetRepresentative", "]"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"69c6a43b-c159-45c5-9a1e-74e7503f6096"]
}, Closed]],

Cell[CellGroupData[{

Cell["5.1.2. Simple examples", \
"Subsubsection",ExpressionUUID->"8ca936ae-35b9-4a25-af30-305f5417cf22"],

Cell["\<\
Renato's example with the symmetries of a Riemann tensor. Note that he uses \
base {1,3}: the computation is faster (just two iterations of the loop), but \
we get an ugly result\
\>", "Text",ExpressionUUID->"14f01b6e-3172-4d15-ae07-7851d5512390"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"reducedSGS", "=", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], ",", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}]}], "]"}], ",",
     "4"}], "]"}]}]], \
"Input",ExpressionUUID->"65c61959-9da0-4bf6-827b-935f9439e848"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}]}], 
    "]"}]}], "]"}]], \
"Output",ExpressionUUID->"3904b71e-8dea-4074-90c2-09134a1143e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], ",", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}]}], "]"}], ",",
     "4"}], "]"}]}]], \
"Input",ExpressionUUID->"59b589eb-a89a-48e7-95e0-162ca2395960"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}]}], 
    "]"}]}], "]"}]], \
"Output",ExpressionUUID->"c54b6b13-b453-4ee6-8d82-2eee27d9658e"]
}, Open  ]],

Cell["This permutation represents R[b,c,a,d]:", \
"Text",ExpressionUUID->"63433f22-15b9-4e31-ad13-4a98c7bd698f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"perm", "=", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"1d3134d1-cca8-4f10-8047-05f7ccbd2b56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
  RowBox[{"perm", ",", "4", ",", "reducedSGS", ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "True"}]}], 
  "]"}]], "Input",ExpressionUUID->"3e3b8942-3c86-4490-b1a8-a01accd600b3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"RIGHT-COSET-REPRESENTATIVE ALGORITHM for \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["RIGHT-COSET-REPRESENTATIVE ALGORITHM for ", 
   xAct`xPerm`Perm[{3, 1, 2, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"a128ffe9-8e42-4ff0-bc03-33ea5ccb9d79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"which corresponds to the index list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["which corresponds to the index list: ", 
   xAct`xPerm`Perm[{2, 3, 1, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"34dc632a-cf2f-40dc-ba44-fa421515b569"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"base: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["base: ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"4e55430d-ee53-4e78-bff2-6a73b4ca1007"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 1, " of base: slot ", 1, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"fff89f81-121a-43ee-9d4e-9225dffe25a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {1, 2, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"8af359a6-1230-496d-99ce-6deec085ee5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Free slots: ", {1, 2, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"92fcbbb4-f5b3-40a8-a044-fac14e323008"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {1, 2, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"effe27cc-b659-4af2-83ed-b748aa95695d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"At those slots we respectively find indices Deltap: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm[
  "At those slots we respectively find indices Deltap: ", {2, 3, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"8b74fe41-151b-4264-b944-79fe9090c4aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The least index is \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", found at position pk: \"\>", "\[InvisibleSpace]",
    "3", "\[InvisibleSpace]", "\<\" of Deltap\"\>"}],
  SequenceForm[
  "The least index is ", 1, ", found at position pk: ", 3, " of Deltap"],
  Editable->
   False]], "Print",ExpressionUUID->"7614f25b-494b-4a89-b65f-9337ba8862b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"That index is found in tensor at slot pp: \"\>", "\[InvisibleSpace]",
    "3"}],
  SequenceForm["That index is found in tensor at slot pp: ", 3],
  Editable->
   False]], "Print",ExpressionUUID->"eba28fa4-1830-4a7f-b3ee-2cdde65b75ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"We can move slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" to slot \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" using permutation om: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], 
   "\[InvisibleSpace]", "\<\" in S\"\>"}],
  SequenceForm[
  "We can move slot ", 3, " to slot ", 1, " using permutation om: ", 
   xAct`xPerm`Perm[{3, 4, 1, 2}], " in S"],
  Editable->
   False]], "Print",ExpressionUUID->"02bdfe68-29bd-43a5-b204-45bb2db1fd64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New indices list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}]}],
  SequenceForm["New indices list: ", 
   xAct`xPerm`Perm[{1, 4, 2, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"7dea173d-2b1f-4e5b-a34f-24c8e098db9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computing stabilizer in S of slot \"\>", "\[InvisibleSpace]", 
   "1"}],
  SequenceForm["Computing stabilizer in S of slot ", 1],
  Editable->
   False]], "Print",ExpressionUUID->"e1af8027-ae41-4d6f-8337-5f333c3de278"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase before change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["newbase before change: ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"33841ee5-7178-4ac2-844a-c0274f6e4e44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase after change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "3", "}"}]}],
  SequenceForm["newbase after change: ", {3}],
  Editable->
   False]], "Print",ExpressionUUID->"d54f4215-9915-4c27-a416-70992fb1301e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 2, " of base: slot ", 3, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"e6f08913-3cd5-474b-b26f-c5ad7a70d597"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"3d50c99a-8db7-485c-ad38-4ee93bdd6f69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Free slots: ", {3, 4, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9aadba24-e3c0-4faf-bfc1-c540d11566e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"e82aad1a-74e5-4d1a-8452-86e7a9b90b9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"At those slots we respectively find indices Deltap: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}],
  SequenceForm["At those slots we respectively find indices Deltap: ", {2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"d0024325-5c40-42e3-9476-bf2f56f7008c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The least index is \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", found at position pk: \"\>", "\[InvisibleSpace]",
    "2", "\[InvisibleSpace]", "\<\" of Deltap\"\>"}],
  SequenceForm[
  "The least index is ", 3, ", found at position pk: ", 2, " of Deltap"],
  Editable->
   False]], "Print",ExpressionUUID->"a06571df-f419-409c-be49-68c033181cd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"That index is found in tensor at slot pp: \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm["That index is found in tensor at slot pp: ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"f6fb3f93-615e-4bb8-bfa8-411e28ac5318"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"We can move slot \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" to slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" using permutation om: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}], 
   "\[InvisibleSpace]", "\<\" in S\"\>"}],
  SequenceForm[
  "We can move slot ", 4, " to slot ", 3, " using permutation om: ", -
   xAct`xPerm`Perm[{1, 2, 4, 3}], " in S"],
  Editable->
   False]], "Print",ExpressionUUID->"3cdcbca6-2082-4878-8209-700d5e5b2917"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New indices list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}]}],
  SequenceForm["New indices list: ", -xAct`xPerm`Perm[{1, 4, 3, 2}]],
  Editable->
   False]], "Print",ExpressionUUID->"dee98583-d2c7-435e-bc9d-ff436d72e330"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computing stabilizer in S of slot \"\>", "\[InvisibleSpace]", 
   "3"}],
  SequenceForm["Computing stabilizer in S of slot ", 3],
  Editable->
   False]], "Print",ExpressionUUID->"10495bef-aad8-4163-8775-1aa163cc5053"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase before change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "3", "}"}]}],
  SequenceForm["newbase before change: ", {3}],
  Editable->
   False]], "Print",ExpressionUUID->"61315db3-ab07-4139-b696-05aec1754788"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase after change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["newbase after change: ", {}],
  Editable->
   False]], "Print",ExpressionUUID->"4c8a917a-8143-4c25-9ff4-5154fc5f21b5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"6fe09ee3-56ca-4841-8df1-7daf25fb6e24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}], ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}]}], 
   "}"}]}]], "Input",ExpressionUUID->"159b9de0-3bb5-4cdd-bbae-a83b4efedc2f"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"dd0ef04a-a831-4afe-b4d5-19547de3118c"]
}, Open  ]],

Cell["\<\
This result is equivalent to -R[a,d,c,b]. Note how the base {1,3} has placed \
the indices a, c in their canonical positions.\
\>", "Text",ExpressionUUID->"21ffc3b6-f940-408a-aef7-224c9ba08842"],

Cell["\<\
It is better if we fill in the gaps in the base. The computation is slower, \
but the result is nicer:\
\>", "Text",ExpressionUUID->"d9cdb697-2188-4730-9d47-288cd334e84c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
  RowBox[{"perm", ",", "4", ",", "SGS", ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "True"}]}], 
  "]"}]], "Input",ExpressionUUID->"c2506732-9c83-4b1f-a500-5cae6c62e984"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"RIGHT-COSET-REPRESENTATIVE ALGORITHM for \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["RIGHT-COSET-REPRESENTATIVE ALGORITHM for ", 
   xAct`xPerm`Perm[{3, 1, 2, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"50eea20d-7fc0-4485-b994-9b1abce7e8e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"which corresponds to the index list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["which corresponds to the index list: ", 
   xAct`xPerm`Perm[{2, 3, 1, 4}]],
  Editable->
   False]], "Print",ExpressionUUID->"4a413427-a249-48aa-8eac-5841bdd1ac52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"base: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["base: ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"5ee17f1a-0b16-43a7-82fd-36d5c9505dd6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 1, " of base: slot ", 1, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"f21e7539-c92f-451a-b881-3d7f0b9c1b00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {1, 2, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"afffbb94-e14f-4888-8bc9-b2f34a0948a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Free slots: ", {1, 2, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"7056881f-cf38-492a-a7d5-5e36b6df1f91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {1, 2, 3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"ccb43b1d-73cd-4a81-94ba-04dc87cb1b85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"At those slots we respectively find indices Deltap: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm[
  "At those slots we respectively find indices Deltap: ", {2, 3, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d2562d95-15cc-4915-a901-09e736c3f064"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The least index is \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", found at position pk: \"\>", "\[InvisibleSpace]",
    "3", "\[InvisibleSpace]", "\<\" of Deltap\"\>"}],
  SequenceForm[
  "The least index is ", 1, ", found at position pk: ", 3, " of Deltap"],
  Editable->
   False]], "Print",ExpressionUUID->"a645fa90-d1de-441d-b651-1eb396c3d687"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"That index is found in tensor at slot pp: \"\>", "\[InvisibleSpace]",
    "3"}],
  SequenceForm["That index is found in tensor at slot pp: ", 3],
  Editable->
   False]], "Print",ExpressionUUID->"f6b92dda-312a-416d-8d84-28706eee3979"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"We can move slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" to slot \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" using permutation om: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], 
   "\[InvisibleSpace]", "\<\" in S\"\>"}],
  SequenceForm[
  "We can move slot ", 3, " to slot ", 1, " using permutation om: ", 
   xAct`xPerm`Perm[{3, 4, 1, 2}], " in S"],
  Editable->
   False]], "Print",ExpressionUUID->"706c58a5-2261-4d40-8c6f-7aef36442736"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New indices list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}]}],
  SequenceForm["New indices list: ", 
   xAct`xPerm`Perm[{1, 4, 2, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"2305e21e-1d82-41f8-a765-2c6d20bfb6f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computing stabilizer in S of slot \"\>", "\[InvisibleSpace]", 
   "1"}],
  SequenceForm["Computing stabilizer in S of slot ", 1],
  Editable->
   False]], "Print",ExpressionUUID->"da82512b-c55e-4e85-81b1-b46b011844c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase before change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["newbase before change: ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"adeeeed0-b6fe-4368-bccd-b2ffe86295f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase after change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}],
  SequenceForm["newbase after change: ", {2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"a1dff7ff-e168-4343-a9c5-1fafc0ac759a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 2, " of base: slot ", 2, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"c8f4a0fd-c818-4401-88c8-753923327bbf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"8718f894-f61c-4818-bdf9-29e0f57811c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Free slots: ", {3, 4, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b450baef-91ed-4216-84e2-5b77e8c01c4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"326f80d5-579b-4123-9351-680d6b505e2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"At those slots we respectively find indices Deltap: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["At those slots we respectively find indices Deltap: ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"32004665-2af6-47bf-8a8c-c00c0d7eb84e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The least index is \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\", found at position pk: \"\>", "\[InvisibleSpace]",
    "1", "\[InvisibleSpace]", "\<\" of Deltap\"\>"}],
  SequenceForm[
  "The least index is ", 4, ", found at position pk: ", 1, " of Deltap"],
  Editable->
   False]], "Print",ExpressionUUID->"8c261f58-ab5c-456b-a0e4-d974527ebe50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"That index is found in tensor at slot pp: \"\>", "\[InvisibleSpace]",
    "2"}],
  SequenceForm["That index is found in tensor at slot pp: ", 2],
  Editable->
   False]], "Print",ExpressionUUID->"c8796d1d-1cc0-4124-914f-fb6095f6b5f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"We can move slot \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" to slot \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" using permutation om: \"\>", "\[InvisibleSpace]",
    "ID", "\[InvisibleSpace]", "\<\" in S\"\>"}],
  SequenceForm[
  "We can move slot ", 2, " to slot ", 2, " using permutation om: ", 
   xAct`xPerm`ID, " in S"],
  Editable->
   False]], "Print",ExpressionUUID->"e887a2ee-9ff7-4c64-b928-fc726e46c150"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New indices list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}]}],
  SequenceForm["New indices list: ", 
   xAct`xPerm`Perm[{1, 4, 2, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"3c777144-9d0d-44dd-b6d6-68924ac7815a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computing stabilizer in S of slot \"\>", "\[InvisibleSpace]", 
   "2"}],
  SequenceForm["Computing stabilizer in S of slot ", 2],
  Editable->
   False]], "Print",ExpressionUUID->"30727f1d-cc6a-474e-a28e-d083941da346"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase before change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}],
  SequenceForm["newbase before change: ", {2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"cb16c254-7ad3-439a-a249-8875affa51ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase after change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "3", "}"}]}],
  SequenceForm["newbase after change: ", {3}],
  Editable->
   False]], "Print",ExpressionUUID->"250c8cf3-5030-43de-aee6-d61c518195ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 3, " of base: slot ", 3, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"d0e14fa6-f4a0-41f0-92a7-b712a07e448b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"b4152b68-d3cb-48e6-950b-7caa8dafad89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Free slots: ", {3, 4, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"67fe2c10-55d1-4db7-b707-6e949caf661b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {3, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"8f300442-67a8-43fe-ba12-56b7bcb7f953"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"At those slots we respectively find indices Deltap: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}],
  SequenceForm["At those slots we respectively find indices Deltap: ", {2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e25d35fb-ac69-4296-a545-1c9fc0898f3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The least index is \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", found at position pk: \"\>", "\[InvisibleSpace]",
    "1", "\[InvisibleSpace]", "\<\" of Deltap\"\>"}],
  SequenceForm[
  "The least index is ", 2, ", found at position pk: ", 1, " of Deltap"],
  Editable->
   False]], "Print",ExpressionUUID->"497d5c8d-01ef-42f7-9445-5675cde16043"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"That index is found in tensor at slot pp: \"\>", "\[InvisibleSpace]",
    "3"}],
  SequenceForm["That index is found in tensor at slot pp: ", 3],
  Editable->
   False]], "Print",ExpressionUUID->"d614d0fe-0f34-4f21-8c9a-0a134d5c8654"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"We can move slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" to slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" using permutation om: \"\>", "\[InvisibleSpace]",
    "ID", "\[InvisibleSpace]", "\<\" in S\"\>"}],
  SequenceForm[
  "We can move slot ", 3, " to slot ", 3, " using permutation om: ", 
   xAct`xPerm`ID, " in S"],
  Editable->
   False]], "Print",ExpressionUUID->"04572d38-6954-41df-8a98-a54864b0b218"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New indices list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}]}],
  SequenceForm["New indices list: ", 
   xAct`xPerm`Perm[{1, 4, 2, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"34f061e5-4be9-4df4-977f-5b7b7d9ae282"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computing stabilizer in S of slot \"\>", "\[InvisibleSpace]", 
   "3"}],
  SequenceForm["Computing stabilizer in S of slot ", 3],
  Editable->
   False]], "Print",ExpressionUUID->"0115f4c0-05a7-4372-9c89-d94f42659f49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase before change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "3", "}"}]}],
  SequenceForm["newbase before change: ", {3}],
  Editable->
   False]], "Print",ExpressionUUID->"06bf71d8-e5ac-4e90-8914-a04a980d0091"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase after change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["newbase after change: ", {}],
  Editable->
   False]], "Print",ExpressionUUID->"bde5cb92-9a4c-4beb-9a84-79fd13618763"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"0ee66bed-f3ea-4aad-adeb-e6f653637d05"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}]}], 
   "}"}]}]], "Input",ExpressionUUID->"02e0f3e7-3044-4adb-b8f5-60efa38bea51"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"6eeece54-1633-430c-a40c-baec788d31a5"]
}, Open  ]],

Cell["This is equivalent to R[a,d,b,c].", \
"Text",ExpressionUUID->"e3b1d345-f5dc-4c79-b0f2-cf8acce2469d"],

Cell["Another permutation in the same right coset (R[d,a,c,b]):", \
"Text",ExpressionUUID->"71b98811-5ac1-4aa0-9f68-31efbaee0938"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"xAct`xPerm`RightCosetRepresentative", ",", "\[IndentingNewLine]", 
   RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], ",", "4", ",",
      "SGS"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}]}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"21969737-3195-46d0-a6a5-4e2f0d6c2471"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"RightCosetRepresentative", ",", "1", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"5f28f89c-0001-4fcf-89ac-f1a2c262b30b"]
}, Open  ]],

Cell["In other notations:", \
"Text",ExpressionUUID->"01eccd66-294e-4ff6-bd2f-f0d6f8dce29c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{"SGS", ",", "xAct`xPerm`Cycles"}], 
   "]"}]}]], "Input",ExpressionUUID->"85f716c6-1f3f-48db-b820-e46c13564619"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "]"}]}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "3"}], "}"}], "]"}]}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"eff20803-3b1f-47a3-b8f4-3edcdfe3dd95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"xAct`xPerm`RightCosetRepresentative", ",", "\[IndentingNewLine]", 
   RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
    RowBox[{
     RowBox[{"TranslatePerm", "[", 
      RowBox[{"perm", ",", "xAct`xPerm`Cycles"}], "]"}], ",", "4", ",", 
     "SGS"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}]}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3199ea4a-ebde-4ce8-859c-2d4b31bd94f4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"RightCosetRepresentative", ",", "2", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"ade47622-1a5a-47d8-af30-387cc5688464"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{"SGS", ",", "Rules"}], 
   "]"}]}]], "Input",ExpressionUUID->"362f3b9b-dcf4-4e96-b99f-60461ed8751a"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "1"}], ",", 
        RowBox[{"1", "\[Rule]", "2"}]}], "]"}]}], ",", 
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "1"}], ",", 
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"4", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "4"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Rules", "[", 
       RowBox[{
        RowBox[{"4", "\[Rule]", "3"}], ",", 
        RowBox[{"3", "\[Rule]", "4"}]}], "]"}]}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"eaabef72-8249-4745-86a1-30592d3cf9dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"xAct`xPerm`RightCosetRepresentative", ",", "\[IndentingNewLine]", 
   RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
    RowBox[{
     RowBox[{"TranslatePerm", "[", 
      RowBox[{"perm", ",", "Rules"}], "]"}], ",", "4", ",", "SGS"}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rules", "[", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "4"}], ",", 
       RowBox[{"3", "\[Rule]", "2"}], ",", 
       RowBox[{"4", "\[Rule]", "3"}]}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}]}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"3dea2935-d617-4745-bd25-ecd3fc452873"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"RightCosetRepresentative", ",", "3", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"84071ced-4f16-4f66-adfb-e20c165e1b39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{"SGS", ",", 
    RowBox[{"{", 
     RowBox[{"Images", ",", "4"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"31120b68-17f5-42d0-ba34-40d857468641"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}]}]}], 
    "]"}]}], "]"}]], \
"Output",ExpressionUUID->"9a4c3222-f1d4-4303-8b48-61e17fe595f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{"perm", ",", 
    RowBox[{"{", 
     RowBox[{"Images", ",", "4"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"97165c79-2c0b-41fa-ab82-df76a7cf244c"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], 
  "]"}]], "Output",ExpressionUUID->"2fbad9d6-04be-487a-8b13-f1c6904cb686"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "[", 
  RowBox[{"xAct`xPerm`RightCosetRepresentative", ",", "\[IndentingNewLine]", 
   RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
    RowBox[{"perm", ",", "4", ",", "SGS"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}]}], "}"}]}], 
  "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"1e9cae52-3025-43e5-a59a-9516b604282c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"RightCosetRepresentative", ",", "4", ",", "True"}], 
  "}"}]], "Output",ExpressionUUID->"7d290d70-6493-4299-8711-cd850e749bc0"]
}, Open  ]],

Cell["\<\
Let us analyze the situation more closely. This is the right coset S.g, in no \
particular order:\
\>", "Text",ExpressionUUID->"0400f921-7cb0-456c-8126-3d0e03ddac3b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coset", "=", 
  RowBox[{"PermProduct", "[", 
   RowBox[{
    RowBox[{"Dimino", "[", 
     RowBox[{"SGS", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "perm"}], 
   "]"}]}]], "Input",ExpressionUUID->"6c8887d8-fe01-4c6c-a420-7be1d4da06cf"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"c9c6c741-418b-438e-b8ef-bd234b78bfba"]
}, Open  ]],

Cell["\<\
Using the base {1,3} we see that the least permutation is -Perm[{1,4,3,2}]:\
\>", "Text",ExpressionUUID->"8638b28e-886e-43d3-9203-c2cde2332c1a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", 
  RowBox[{"coset", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"c3db60db-625f-41cb-9a0e-90c6bc7e2d93"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"5f33ddd0-6a99-46f9-bc47-8cce202dafe1"]
}, Open  ]],

Cell["\<\
But using the base {1,2,3,4} we see that the least permutation is \
Perm[{1,4,2,3}]:\
\>", "Text",ExpressionUUID->"7c3167c9-47e1-4ec0-8219-ba3772a4cae9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", "coset", 
  "]"}]], "Input",ExpressionUUID->"ee63f39f-e87a-4d6b-913a-83a9b4113512"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"46bd1142-c21b-452d-af8e-8f727be67553"]
}, Open  ]],

Cell["\<\
We can sort the left coset of inverses and take the inverse again:\
\>", "Text",ExpressionUUID->"dfbe4843-8bdb-4afe-b491-c7748cdd2878"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coset", "=", 
  RowBox[{"PermProduct", "[", 
   RowBox[{
    RowBox[{"InversePerm", "[", "perm", "]"}], ",", 
    RowBox[{"Dimino", "[", 
     RowBox[{"SGS", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"dae3e157-09f8-45ab-9e69-5369ca245df4"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "1", ",", "3"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"6d17c8a0-610b-4590-af52-288728ce86b1"]
}, Open  ]],

Cell["\<\
Using the base {1,3} we see that the least permutation is -Perm[{1,4,3,2}], \
with same inverse\
\>", "Text",ExpressionUUID->"2527b5cc-6e7c-43d2-9394-21e5103c4c47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InversePerm", "/@", 
  RowBox[{"PermSort", "[", 
   RowBox[{"coset", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"ab3c1817-e9e9-41a1-bc65-6011b59bf25d"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"0cc43348-542e-40d2-b0c3-6a4027c4dad7"]
}, Open  ]],

Cell["\<\
But using the base {1,2,3,4} we see that the least permutation is \
Perm[{1,3,4,2}], with inverse Perm[{1,4,2,3}]\
\>", "Text",ExpressionUUID->"e09330e5-7b2b-49c4-9e62-2b170212ebbf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InversePerm", "/@", 
  RowBox[{
  "PermSort", "[", "coset", 
   "]"}]}]], "Input",ExpressionUUID->"b2410dae-01ed-450f-9cee-9582b81728c1"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}]}], 
  "]"}]], "Output",ExpressionUUID->"5b39bd90-eb87-4618-bffd-6edd0b74fd32"]
}, Open  ]],

Cell["\<\
In this case we get the same results using canonicalization of left-cosets \
and right-cosets. This is not necessarily the case. The problem is that, \
given a base, the ordering of a set of permutations is not kept if we sort \
the set of inverses of permutations. For example, take these two permutations \
which are inverses of each other:\
\>", "Text",ExpressionUUID->"2bf93806-7726-4aad-add3-3a4d84c459fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"db7270f9-7055-4ded-a019-514f08daf863"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"fe950d16-661e-4846-bfae-5c69c106aaa6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"38eccd02-3bb0-43c9-ade0-9baeee9ecac0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"8f80e1bb-2e95-4ca9-9801-2b18cbf3d634"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InversePerm", "/@", 
  RowBox[{"PermSort", "[", 
   RowBox[{"InversePerm", "/@", "%%"}], 
   "]"}]}]], "Input",ExpressionUUID->"83854323-b08f-4fae-b2a2-b4e7c99c8944"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"f2ab2609-23f5-49d1-b4ed-6da1899edbe5"]
}, Open  ]],

Cell["\<\
In our problem the two alternatives have very different meanings: Sorting \
left-cosets inv(g).S would mean that we look for images of a base of indices; \
sorting right-cosets S.g would mean we look for images of a set of slots. The \
second option is more natural because we have a strong generating set for S, \
which gives a natural base of slots. There is no natural base of indices \
apart from the trivial one {1, 2, 3, ...}.\
\>", "Text",ExpressionUUID->"7dd75eba-d3f4-4851-ae8c-a0c3db701d21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}], "]"}]], \
"Input",ExpressionUUID->"adeb1284-b431-4809-b2b2-cf30074af565"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"2dca38a0-a4d1-4129-8abc-2ac64cafc324"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "2", ",", "6", ",", "5", ",", "1"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"96572721-7fcd-4140-94d9-8d6b72126184"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "2", ",", "6", ",", "5", ",", "1"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"dac4b828-9d25-4aa4-9c99-061e41bc367b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SchreierSims"}]], \
"Input",ExpressionUUID->"cf8d6b82-f5a5-474a-88e7-7c70459404ce"],

Cell[BoxData[
 StyleBox["\<\"SchreierSims[initbase, GS, deg] generates a strong generating \
set for the group generated by GS (permutations of degree deg), using list \
initbase as the first points for the base. The final SGS is not reduced in \
general.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567978016-5455693",ExpressionUUID->"2877dcdf-7e03-47fd-b9d6-\
e11a7865bd3a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierSims", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "2", ",", "6", ",", "5", ",", "1"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"xAct`xPerm`Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], "]"}]}], "]"}], ",", "6"}], 
  "]"}]], "Input",ExpressionUUID->"78d79e50-d3ca-47c3-a53d-3b5e3eeedf2a"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "2", ",", "6", ",", "5", ",", "1"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"86cdad8b-faf9-4a05-8ca7-b9bfad5fb4b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"23393c80-6e10-475a-a432-bc7132f1d324"],

Cell[BoxData["720"], \
"Output",ExpressionUUID->"38b3efc5-ceb8-4449-9bfd-87f536633920"]
}, Open  ]],

Cell["\<\
Recall that the list {2,5} gives the initial slots of the free indices, and \
not the names of the indices (which would be more natural).\
\>", "Text",ExpressionUUID->"d48fd91d-edc1-4fa8-9ecd-834c79de8c8e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
  RowBox[{
   RowBox[{"xAct`xPerm`Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "6", ",", "3", ",", "5"}], "}"}], "]"}], ",",
    "6", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"6", ",", "5", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}], ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "True"}]}], 
  "]"}]], "Input",ExpressionUUID->"a8fe6616-4569-45dc-a67e-c29525d7d3c2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"RIGHT-COSET-REPRESENTATIVE ALGORITHM for \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "6", ",", "3", ",", "5"}], "}"}], "]"}]}],
  SequenceForm["RIGHT-COSET-REPRESENTATIVE ALGORITHM for ", 
   xAct`xPerm`Cycles[{1, 4, 6, 3, 5}]],
  Editable->
   False]], "Print",ExpressionUUID->"4f140aab-6076-4c9a-8955-35716eea6b37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"which corresponds to the index list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "5", ",", "6", ",", "1", ",", "3"}], "}"}], 
    "]"}]}],
  SequenceForm["which corresponds to the index list: ", 
   xAct`xPerm`Perm[{4, 2, 5, 6, 1, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"d61badbe-1da3-4ae2-aa26-a2b2736368e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"base: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]}],
  SequenceForm["base: ", {1, 3, 4, 5, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"d5335799-a356-48d4-befb-ba32381626c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 1, " of base: slot ", 1, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"84b8776c-9156-4414-9d3c-1af6d47a0158"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {1, 3, 4, 5, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"a0adf5cc-f11b-49bd-83e5-a9337a66b419"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}]}],
  SequenceForm["Free slots: ", {2, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"1986144a-42b9-4308-975c-06e164aa4801"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "5", "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {5}],
  Editable->
   False]], "Print",ExpressionUUID->"41b59b82-e3b5-467c-b3d2-385281f9ee8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"At those slots we respectively find indices Deltap: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "1", "}"}]}],
  SequenceForm["At those slots we respectively find indices Deltap: ", {1}],
  Editable->
   False]], "Print",ExpressionUUID->"34f474a4-0ed5-4e3e-99ba-f8907eb0cc99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The least index is \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", found at position pk: \"\>", "\[InvisibleSpace]",
    "1", "\[InvisibleSpace]", "\<\" of Deltap\"\>"}],
  SequenceForm[
  "The least index is ", 1, ", found at position pk: ", 1, " of Deltap"],
  Editable->
   False]], "Print",ExpressionUUID->"be9058c4-89b2-4c6d-9447-a28937f2f658"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"That index is found in tensor at slot pp: \"\>", "\[InvisibleSpace]",
    "5"}],
  SequenceForm["That index is found in tensor at slot pp: ", 5],
  Editable->
   False]], "Print",ExpressionUUID->"2593168d-43c0-40c3-b678-4736e942050d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"We can move slot \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" to slot \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" using permutation om: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], 
   "\[InvisibleSpace]", "\<\" in S\"\>"}],
  SequenceForm[
  "We can move slot ", 5, " to slot ", 1, " using permutation om: ", 
   xAct`xPerm`Cycles[{1, 5, 4, 3}], " in S"],
  Editable->
   False]], "Print",ExpressionUUID->"b476a185-ce6d-447d-b10e-e858a4272a59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New indices list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "6", ",", "3"}], "}"}], 
    "]"}]}],
  SequenceForm["New indices list: ", 
   xAct`xPerm`Perm[{1, 2, 4, 5, 6, 3}]],
  Editable->
   False]], "Print",ExpressionUUID->"627e8573-5cd2-4436-b443-4668a7680871"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computing stabilizer in S of slot \"\>", "\[InvisibleSpace]", 
   "1"}],
  SequenceForm["Computing stabilizer in S of slot ", 1],
  Editable->
   False]], "Print",ExpressionUUID->"211f836a-bc6a-4dd7-85e4-ca519703cf06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase before change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]}],
  SequenceForm["newbase before change: ", {1, 3, 4, 5, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"b9bf958a-bb07-4634-8b9a-eaba9706a738"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase after change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}],
  SequenceForm["newbase after change: ", {3, 4, 5, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"22a9e9c2-5d6f-4e3d-bf14-80d36cfb4bde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 2, " of base: slot ", 3, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"9cee6fa4-1b68-4ff9-ad5a-75ee3d80c1b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {3, 4, 5, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"6a9b7f60-934c-4d48-b4cc-a3cab298d2fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}],
  SequenceForm["Free slots: ", {2, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"5a881ff3-ed33-457c-ac6d-3e34369a8de3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {}],
  Editable->
   False]], "Print",ExpressionUUID->"7c3a4ab9-13b5-4928-afc1-a3bbee7d8359"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 3, " of base: slot ", 4, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"69446a62-a2bf-4c29-a956-42f7e4c409df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {3, 4, 5, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"d29c6363-7583-405a-a786-7e7c331397be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}],
  SequenceForm["Free slots: ", {2, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"5abbebf4-8b54-4f37-96e3-8474824d96a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {}],
  Editable->
   False]], "Print",ExpressionUUID->"7588f0ce-f759-4ffe-a569-50f16582219f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 4, " of base: slot ", 5, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"a3dec69b-9e67-4f93-a249-2c4132f00a84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {3, 4, 5, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"25b7ba12-e791-4ce7-b35d-5cf6cf38bb27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}],
  SequenceForm["Free slots: ", {2, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"9f055440-aeea-429a-a557-010d7a13d327"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {}],
  Editable->
   False]], "Print",ExpressionUUID->"1ff82a48-5e99-43d2-b376-2b11aa77dedf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 5, " of base: slot ", 6, " ******"],
  Editable->
   False]], "Print",ExpressionUUID->"18efee8f-0bba-437b-b57a-36450afa0a83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {3, 4, 5, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"24414871-0d25-40fd-b04f-73cb3baf2b6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}],
  SequenceForm["Free slots: ", {2, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"52fb29ae-9497-43e1-a9f2-cbe135d7c855"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {}],
  Editable->
   False]], "Print",ExpressionUUID->"bb2c7c64-2edf-49c2-967b-6af1c8ae9eae"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}], "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5"}], "}"}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"1db9a7b2-a471-4014-ac24-f0c61423a805"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"xAct`xPerm`Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}], "]"}], ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"xAct`xPerm`Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
        RowBox[{"xAct`xPerm`Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"4", ",", "5"}], "}"}], "]"}], ",", 
        RowBox[{"xAct`xPerm`Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"5", ",", "6"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], 
   "}"}]}]], "Input",ExpressionUUID->"9e2bec34-33e4-4980-9dd4-43e75d411b20"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"55202bbe-ef65-4ede-9dc9-501acebd48c1"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
5.1.3. Nontrivial example. This takes several minutes to evaluate\
\>", "Subsubsection",ExpressionUUID->"2329869b-426b-47f3-bb2b-18f5190a06a6"],

Cell["From the permutations", \
"Text",ExpressionUUID->"19047436-8b97-4b6b-8bf5-40c5cfbae123"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"a", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"xAct`xPerm`Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Images", ",", "21"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"b", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"xAct`xPerm`Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Images", ",", "21"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"c", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"xAct`xPerm`Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Images", ",", "21"}], "}"}]}], 
   "]"}]}]}], "Input",ExpressionUUID->"b9e9f444-194a-468c-ad45-bac22adeb65a"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{
   "8", ",", "11", ",", "10", ",", "14", ",", "16", ",", "21", ",", "13", ",",
     "9", ",", "1", ",", "12", ",", "15", ",", "3", ",", "18", ",", "19", ",",
     "2", ",", "17", ",", "5", ",", "7", ",", "4", ",", "6", ",", "20"}], 
   "}"}], "]"}]], \
"Output",ExpressionUUID->"bb41cfda-bffb-4ef9-8c11-82ea74c4dec1"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
    ",", "18", ",", "10", ",", "11", ",", "19", ",", "13", ",", "14", ",", 
    "15", ",", "16", ",", "12", ",", "20", ",", "17", ",", "9", ",", "21"}], 
   "}"}], "]"}]], \
"Output",ExpressionUUID->"1e4d2b49-2ef3-4404-8218-b8ba3824e743"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
    ",", "9", ",", "21", ",", "10", ",", "12", ",", "16", ",", "13", ",", 
    "15", ",", "14", ",", "17", ",", "18", ",", "19", ",", "20", ",", "11"}], 
   "}"}], "]"}]], \
"Output",ExpressionUUID->"1159c28c-e350-4857-a561-d8326efaf99e"]
}, Open  ]],

Cell["we construct the group", \
"Text",ExpressionUUID->"2cd88f5e-4d86-49c7-a9f1-dc3d42c1a55e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"group", "=", 
    RowBox[{"Dimino", "[", 
     RowBox[{"GenSet", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"08403a1f-8cb8-4df8-aecc-bb520ad59375"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "30.64715400000000045110937207937240600586`7.506990063929052", ",", 
   "27783"}], 
  "}"}]], "Output",ExpressionUUID->"1e880d66-5ae3-4cd4-98d6-4288525c8438"]
}, Open  ]],

Cell["and its subgroup", \
"Text",ExpressionUUID->"5188397b-1b42-46a9-81ea-4318ea5f9030"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"subgroup", "=", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "subgroup", 
  "]"}]}], "Input",ExpressionUUID->"32c76a7d-6ac3-4fd8-8efe-c7bfe548a1a3"],

Cell[BoxData["81"], \
"Output",ExpressionUUID->"5926a9d5-7535-4fd9-a15b-0e8260e78225"]
}, Open  ]],

Cell["Therefore we have this number of cosets", \
"Text",ExpressionUUID->"7acd9835-eafa-48dc-b5fa-61ec7a4776d3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ncosets", "=", 
  RowBox[{
  "27783", "/", 
   "81"}]}]], "Input",ExpressionUUID->"e07072d2-f989-4c84-a45f-21638d0cb98a"],

Cell[BoxData["343"], \
"Output",ExpressionUUID->"aaa975f7-5ab5-44b7-bd9f-9293ee30d8fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS", "=", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", "21"}], 
   "]"}]}]], "Input",ExpressionUUID->"4295ea99-9ff5-46bc-8dde-bce7cc6b10d0"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "1"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "8", ",", "11", ",", "10", ",", "14", ",", "16", ",", "21", ",", "13", 
        ",", "9", ",", "1", ",", "12", ",", "15", ",", "3", ",", "18", ",", 
        "19", ",", "2", ",", "17", ",", "5", ",", "7", ",", "4", ",", "6", ",",
         "20"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
        "8", ",", "18", ",", "10", ",", "11", ",", "19", ",", "13", ",", "14",
         ",", "15", ",", "16", ",", "12", ",", "20", ",", "17", ",", "9", ",",
         "21"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
        "13", ",", "9", ",", "14", ",", "11", ",", "12", ",", "21", ",", "16",
         ",", "15", ",", "10", ",", "17", ",", "18", ",", "19", ",", "20", ",",
         "8"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "7", ",", "2", ",", "4", ",", "5", ",", "3", ",", "1", ",", "6", ",", 
        "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", 
        ",", "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", "20", ",",
         "21"}], "}"}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"ba96bf37-d7b7-497e-9e3c-99d29c842fe8"]
}, Open  ]],

Cell["Representatives (perform BaseChange checks):", \
"Text",ExpressionUUID->"c26f6e1b-ca97-4d7e-bb42-c0034589cc91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"xAct`xPerm`RightCosetRepresentative", ",", 
    RowBox[{"BaseChangeCheck", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",ExpressionUUID->"361425da-f3af-46aa-aa83-4638a19231d4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"result", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"First", "[", 
       RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
        RowBox[{"#", ",", "21", ",", "SGS"}], "]"}], "]"}], "&"}], "/@", 
     "group"}]}], ";"}], 
  "]"}]], "Input",ExpressionUUID->"72d6c959-7823-47d0-8b2c-66b29b71b65b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "119.93098500000000683485268382355570793152`8.099531313860268", ",", 
   "Null"}], 
  "}"}]], "Output",ExpressionUUID->"60fb3547-3326-4660-a900-40cdedba715b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"reps", "=", 
   RowBox[{"Union", "[", "result", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "[", "reps", "]"}], "===", 
  "ncosets"}]}], \
"Input",ExpressionUUID->"31ddc7b5-d154-4c3a-b081-1e4171190029"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"04c1b33e-f348-42ec-920f-8db1d550ccba"]
}, Open  ]],

Cell["We construct the right cosets of those representatives:", \
"Text",ExpressionUUID->"93a7c4cc-26a7-4b1b-8b5b-bc8e1d52eb15"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"cosetsR", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"PermProduct", "[", 
       RowBox[{"subgroup", ",", 
        RowBox[{"reps", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "ncosets"}], "}"}]}], "]"}]}], ";"}], 
  "]"}]], "Input",ExpressionUUID->"d38027d4-93a5-420e-9cbe-8065d9125277"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.90495400000000003615241439547389745712`6.71123485208227", ",", "Null"}], 
  "}"}]], "Output",ExpressionUUID->"2eac9068-0e8a-4ff8-afdc-b8aa621cf55d"]
}, Open  ]],

Cell["We check that those cosets form the whole group:", \
"Text",ExpressionUUID->"4076084e-e377-461c-a43a-78d9b76cf39b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Group", "@@", 
   RowBox[{"Sort", "[", 
    RowBox[{"Apply", "[", 
     RowBox[{"Sequence", ",", "cosetsR", ",", "1"}], "]"}], "]"}]}], "===", 
  RowBox[{
  "Sort", "[", "group", 
   "]"}]}]], "Input",ExpressionUUID->"a31f2d77-0b12-43ec-8ea3-2c324639ee39"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"1bd12b5d-c8b6-43fd-8fdb-17f0e9166508"]
}, Open  ]],

Cell["\<\
We also check that we have correctly found all members of all cosets:\
\>", "Text",ExpressionUUID->"b790e92e-afad-4aa1-b2f9-11c908aebd42"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sort", "[", 
       RowBox[{"group", "[", 
        RowBox[{"[", 
         RowBox[{"Flatten", "@", 
          RowBox[{"Position", "[", 
           RowBox[{"result", ",", 
            RowBox[{"reps", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "]"}], "]"}], "]"}], "===", 
      RowBox[{"Group", "@@", 
       RowBox[{"Sort", "[", 
        RowBox[{"cosetsR", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "ncosets"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"bdf7d924-e15a-4b30-9c1a-6e6463b6e26c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "14.07656599999999968986230669543147087097`7.169096634197456", ",", 
   "True"}], 
  "}"}]], "Output",ExpressionUUID->"a72d5281-2616-4760-a6ce-c939c3a119a5"]
}, Open  ]],

Cell["\<\
Now we check that the representative of each coset is correctly chosen:\
\>", "Text",ExpressionUUID->"b1da0a74-7c7e-4734-8907-4fc2ce9fe94b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"And", "@@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"First", "@", 
       RowBox[{"PermSort", "[", 
        RowBox[{
         RowBox[{"cosetsR", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "8", ",", "1"}], "}"}]}], "]"}]}], "===", 
      RowBox[{"reps", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "ncosets"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"0d529ad9-f855-4e5a-86df-8078760ca822"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "18.98217500000000157456270244438201189041`7.298945886195973", ",", 
   "True"}], 
  "}"}]], "Output",ExpressionUUID->"00384249-f541-4e02-99f2-93a7bdc4d233"]
}, Open  ]],

Cell["\<\
Note how different choices give different ways to sort the permutations:\
\>", "Text",ExpressionUUID->"d32c712c-0233-42dc-b69b-09a0a5901f7a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"reps", "[", 
  RowBox[{"[", "10", "]"}], 
  "]"}]], "Input",ExpressionUUID->"ea51c9e9-a909-42ec-b2c2-6c1dfdbd1f01"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "10",
     ",", "9", ",", "14", ",", "13", ",", "12", ",", "16", ",", "8", ",", 
    "15", ",", "11", ",", "17", ",", "18", ",", "19", ",", "20", ",", "21"}], 
   "}"}], "]"}]], \
"Output",ExpressionUUID->"7da66ee2-ddd4-42e7-a163-8a0e360a938e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"coset", "=", 
   RowBox[{"List", "@@", 
    RowBox[{"cosetsR", "[", 
     RowBox[{"[", "10", "]"}], "]"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"fe1735bf-dd02-4b91-bad4-cd8fe45ab426"],

Cell["\<\
Note in particular that sorting inverses does not give the same \"smallest \
permutation\" than sorting the original set:\
\>", "Text",ExpressionUUID->"0d3f1b2e-04a2-4329-a759-ef29b22952d8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PermSort", "[", "coset", "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"Range", "[", "5", "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"a18f9d6f-38ed-4d70-b903-0c30afa8b652"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "10", ",", "9", ",", "14", ",", "13", ",", "12", ",", "16", ",", "8", ",",
       "15", ",", "11", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "21"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "10", ",", "18", ",", "14", ",", "13", ",", "19", ",", "16", ",", "8", ",",
       "15", ",", "11", ",", "12", ",", "20", ",", "17", ",", "9", ",", 
      "21"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "10", ",", "20", ",", "14", ",", "13", ",", "17", ",", "16", ",", "8", ",",
       "15", ",", "11", ",", "19", ",", "9", ",", "12", ",", "18", ",", 
      "21"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "16", ",", "9", ",", "8", ",", "13", ",", "12", ",", "21", ",", "11", ",",
       "15", ",", "14", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "10"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "16", ",", "18", ",", "8", ",", "13", ",", "19", ",", "21", ",", "11", ",",
       "15", ",", "14", ",", "12", ",", "20", ",", "17", ",", "9", ",", 
      "10"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"16e8f997-f090-4c58-9ed6-916f7e565aa1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PermSort", "[", 
   RowBox[{"coset", ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "8", ",", "1"}], "}"}]}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"Range", "[", "5", "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"7d05ba8f-790a-4c0e-8c8c-f42ea5768080"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "10", ",", "9", ",", "14", ",", "13", ",", "12", ",", "16", ",", "8", ",",
       "15", ",", "11", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "21"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "6", ",", "2", ",", "5", ",", "3", ",", "4", ",", "7", ",", "1", ",", 
      "10", ",", "9", ",", "14", ",", "13", ",", "12", ",", "16", ",", "8", ",",
       "15", ",", "11", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "21"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "4", ",", "5", ",", "3", ",", "1", ",", "6", ",", 
      "10", ",", "9", ",", "14", ",", "13", ",", "12", ",", "16", ",", "8", ",",
       "15", ",", "11", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "21"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "16", ",", "9", ",", "8", ",", "13", ",", "12", ",", "21", ",", "11", ",",
       "15", ",", "14", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "10"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "6", ",", "2", ",", "5", ",", "3", ",", "4", ",", "7", ",", "1", ",", 
      "16", ",", "9", ",", "8", ",", "13", ",", "12", ",", "21", ",", "11", ",",
       "15", ",", "14", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "10"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"08ea88ad-15b8-48ba-84d9-8f719560b955"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InversePerm", "/@", 
  RowBox[{
   RowBox[{"PermSort", "[", 
    RowBox[{
     RowBox[{"InversePerm", "/@", "coset"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "8", ",", "1"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"Range", "[", "5", "]"}], "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"200f73dd-01e5-4d70-ab8f-94715a15858f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "16", ",", "9", ",", "8", ",", "13", ",", "12", ",", "21", ",", "11", ",",
       "15", ",", "14", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "10"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "4", ",", "5", ",", "3", ",", "1", ",", "6", ",", 
      "16", ",", "9", ",", "8", ",", "13", ",", "12", ",", "21", ",", "11", ",",
       "15", ",", "14", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "10"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "6", ",", "2", ",", "5", ",", "3", ",", "4", ",", "7", ",", "1", ",", 
      "16", ",", "9", ",", "8", ",", "13", ",", "12", ",", "21", ",", "11", ",",
       "15", ",", "14", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "10"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "10", ",", "9", ",", "14", ",", "13", ",", "12", ",", "16", ",", "8", ",",
       "15", ",", "11", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "21"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "4", ",", "5", ",", "3", ",", "1", ",", "6", ",", 
      "10", ",", "9", ",", "14", ",", "13", ",", "12", ",", "16", ",", "8", ",",
       "15", ",", "11", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
      "21"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"b52c126f-57de-424b-ad1b-2c63e320ad5e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["5.1.4. Example: S4 in S5", \
"Subsubsection",ExpressionUUID->"b760b00b-025d-448a-9e3e-2de255835c38"],

Cell["We construct the symmetric group of 5-perms:", \
"Text",ExpressionUUID->"49313c99-6639-4d44-bf01-e253cbd4ebb9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s5", "=", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}],
      "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "s5", 
  "]"}]}], "Input",ExpressionUUID->"ed2694aa-b67d-48f7-9d52-def1b7585041"],

Cell[BoxData["120"], \
"Output",ExpressionUUID->"5a6ed2d1-483c-467c-85ae-e2ddaf31a757"]
}, Open  ]],

Cell["It is not sorted, according to PermSort:", \
"Text",ExpressionUUID->"74c8fb00-4a78-4ec9-a161-fc1c03a88bc4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PermSort", "[", "s5", "]"}], "===", 
  "s5"}]], "Input",ExpressionUUID->"501f1f9b-eabd-41f6-bb5e-ca5d6b7608a5"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"ee5df6c9-d129-4f38-8e1e-aa77c2f76e11"]
}, Open  ]],

Cell["A subgroup of permutations is s4:", \
"Text",ExpressionUUID->"b90343e2-6ba2-4e0b-a36d-5669450ba428"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s4", "=", 
  RowBox[{"Group", "@@", 
   RowBox[{"Stabilizer", "[", 
    RowBox[{
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"GenSet", "@@", "s5"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"59ddfa4f-8ba0-4d60-98f4-8c19dc6fe90a"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "1", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2", ",", "1", ",", "5"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"ea36e455-5a54-45f1-8f3f-935bfa5b34c9"]
}, Open  ]],

Cell["described by", \
"Text",ExpressionUUID->"e3481c1a-4b16-4c03-8c39-cf4544195a70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSs4", "=", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}]}],
      "]"}], ",", "5"}], 
   "]"}]}]], "Input",ExpressionUUID->"6c67514f-bad0-4661-831b-f5fe9ba93a29"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}]}], 
    "]"}]}], "]"}]], \
"Output",ExpressionUUID->"6d63d425-ec2a-4309-bc85-c8faef8ec1d0"]
}, Open  ]],

Cell["We have 5 coset representatives:", \
"Text",ExpressionUUID->"3170212c-a1bd-4f1f-b247-d7dbcab59350"],

Cell[BoxData[
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
       RowBox[{"#", ",", "5", ",", "SGSs4"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{"List", "@@", "s5"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"8c103da6-d868-487f-acec-59663b8bce76"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"reps", "=", 
  RowBox[{
  "Union", "[", "result", 
   "]"}]}]], "Input",ExpressionUUID->"55f8879d-0d1c-4833-a070-d1325ff98a9c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"405d6c7b-b192-48c8-b91d-24c1a67e8737"]
}, Open  ]],

Cell["\<\
The representatives coincide with the smallest permutations of the right \
cosets:\
\>", "Text",ExpressionUUID->"b6592d30-166f-48c4-b6ec-ad2bce8fa8cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coset1", "=", 
  RowBox[{"PermSort", "[", 
   RowBox[{"PermProduct", "[", 
    RowBox[{"s4", ",", 
     RowBox[{"reps", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"78334702-2d93-447c-adc4-2dc0cf9af480"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "1", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "1", ",", "5"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"c1826079-0ca3-412d-b98b-9d891f5ba7cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coset1", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
  RowBox[{"reps", "[", 
   RowBox[{"[", "1", "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"97dec343-1d31-4c0e-a624-8fd177cbbc2b"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"59b5f063-563b-4717-86e9-728b06f19f39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coset2", "=", 
  RowBox[{"PermSort", "[", 
   RowBox[{"PermProduct", "[", 
    RowBox[{"s4", ",", 
     RowBox[{"reps", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"ba847d43-518c-4121-bfb0-b5ca8857c5af"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "5", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "5", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "5", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "5", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"b2e65a81-2ce0-4225-86a8-a3ac0a72565d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coset2", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
  RowBox[{"reps", "[", 
   RowBox[{"[", "2", "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"1bdad7ac-284c-47fc-af59-f8fb1078247c"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"d53980a3-eb81-47c8-8a41-38bcc4343699"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coset3", "=", 
  RowBox[{"PermSort", "[", 
   RowBox[{"PermProduct", "[", 
    RowBox[{"s4", ",", 
     RowBox[{"reps", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"3cabdfb8-c146-4493-afa0-9c07b590af08"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "5", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "5", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "5", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "2", ",", "5", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "5", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "1", ",", "5", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "5", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "2", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "2", ",", "1", ",", "3"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"2b3331d6-2e67-4582-a525-5e4676984be9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coset3", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
  RowBox[{"reps", "[", 
   RowBox[{"[", "3", "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"82a8a720-f61a-428f-9f90-5f936df0ec8a"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"699bfa90-ec19-43d7-b0d0-29398bb1e2c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coset4", "=", 
  RowBox[{"PermSort", "[", 
   RowBox[{"PermProduct", "[", 
    RowBox[{"s4", ",", 
     RowBox[{"reps", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}], "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"37d3ad76-4a52-4a46-a7eb-79015ea70a24"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "5", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "3", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "5", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "1", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"2eddf65f-ed5d-436e-8217-c703865c93a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coset4", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
  RowBox[{"reps", "[", 
   RowBox[{"[", "4", "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"b46a6278-1e9d-4496-aef7-0194fbe8bd00"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"793149c8-a04a-4085-be1b-a9d7fb31dc51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coset5", "=", 
  RowBox[{"PermSort", "[", 
   RowBox[{"PermProduct", "[", 
    RowBox[{"s4", ",", 
     RowBox[{"reps", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}], "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"a3e61021-3e22-4aa5-82b8-0dcfb7ecb11c"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "5", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "3", ",", "5", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "5", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2", ",", "5", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "5", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "5", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"511d6bb0-1b30-4cfd-9d7b-5155c9d61557"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coset5", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
  RowBox[{"reps", "[", 
   RowBox[{"[", "5", "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"8b22e077-c2ab-4265-a403-8aa031dffe24"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"36abcbb1-3031-4f9d-a9da-6b37f0e9d4f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Group", "@@", 
   RowBox[{"Union", "[", 
    RowBox[{
     RowBox[{"Coset", "@@", "coset1"}], ",", "coset2", ",", "coset3", ",", 
     "coset4", ",", "coset5"}], "]"}]}], "===", 
  RowBox[{
  "Sort", "[", "s5", 
   "]"}]}]], "Input",ExpressionUUID->"c8e1ed20-ce3d-4743-a8b2-81a9af866d9b"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"5f3e417f-70d2-4010-b609-eb0bfd9021c0"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["5.1.5. Example: S3 in S5", \
"Subsubsection",ExpressionUUID->"f2a5698b-4958-4ad8-a2c1-bc1f45e202c0"],

Cell["We construct the symmetric group of 5-perms:", \
"Text",ExpressionUUID->"fcbc44b6-4e14-4798-9c13-d5a57ebbefe1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s5", "=", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}],
      "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "s5", 
  "]"}]}], "Input",ExpressionUUID->"9d7d9e6a-b200-495a-81c4-572469abf026"],

Cell[BoxData["120"], \
"Output",ExpressionUUID->"d44d2b63-d534-49fa-a370-56bd267cb5b8"]
}, Open  ]],

Cell["It is not sorted, according to PermSort:", \
"Text",ExpressionUUID->"1227636f-0504-4c95-b568-5095238c36fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PermSort", "[", "s5", "]"}], "===", 
  "s5"}]], "Input",ExpressionUUID->"88117b11-8af4-4413-972c-2e4da8f1fd70"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"2dae939b-3b80-4b0a-a30a-ef6f03c956b0"]
}, Open  ]],

Cell["A subgroup of permutations is s3:", \
"Text",ExpressionUUID->"9541c500-1377-4d54-b17e-69dfaa753703"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{"Group", "@@", 
   RowBox[{"Stabilizer", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"GenSet", "@@", "s5"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"36af7dcb-da78-4a6b-9024-c7bf43d2d09f"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"9210ded6-c07b-4a96-8197-cc9a818c21b9"]
}, Open  ]],

Cell["described by", \
"Text",ExpressionUUID->"41a09a69-8c85-472c-bfc9-e0e4fef5f915"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSs3", "=", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}]}],
      "]"}], ",", "5"}], 
   "]"}]}]], "Input",ExpressionUUID->"73b0fa02-628e-404e-a298-9d346aca8571"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}]}], 
    "]"}]}], "]"}]], \
"Output",ExpressionUUID->"d690053d-58f1-4d32-84e3-8f5522546d3d"]
}, Open  ]],

Cell["We have 20 coset representatives:", \
"Text",ExpressionUUID->"eaf8bb1f-de2c-4d44-b79c-1102e8c41189"],

Cell[BoxData[
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
       RowBox[{"#", ",", "5", ",", "SGSs3"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{"List", "@@", "s5"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"0668c82b-f7a5-44f0-9af6-253cedc17d74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"reps", "=", 
  RowBox[{
  "Union", "[", "result", 
   "]"}]}]], "Input",ExpressionUUID->"4e6c09b9-792e-4b53-8151-59204b27fc21"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "5", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "5", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "5", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "5", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "5", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "5", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"6fb789b0-1c43-43b6-9ce9-55925d6749c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"cosets", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"PermSort", "[", 
       RowBox[{"PermProduct", "[", 
        RowBox[{"s3", ",", 
         RowBox[{"reps", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ")"}], "//", 
  "ColumnForm"}]], \
"Input",ExpressionUUID->"0b45d3e6-295b-4cb9-a48e-10233ea2cc90"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"Group", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "1", ",", "5", ",", "4"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "1", ",", "3", ",", "5"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "1", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "2", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "1", ",", "5", ",", "3"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "1", ",", "3", ",", "4"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "1", ",", "4", ",", "3"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "1", ",", "2", ",", "5"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "3", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "1", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "3", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "1", ",", "5", ",", "2"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "5", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "5", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "1", ",", "2", ",", "4"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "5", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "5", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "1", ",", "4", ",", "2"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "5", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "5", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "1", ",", "2", ",", "3"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "1", ",", "3", ",", "2"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "2", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "2", ",", "1", ",", "5"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "3", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "2", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "5", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "5", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "2", ",", "1", ",", "4"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "5", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "5", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "2", ",", "4", ",", "1"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "5", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "5", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "2", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "2", ",", "1", ",", "3"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "2", ",", "3", ",", "1"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "3", ",", "1", ",", "2"}], "}"}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"Coset", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5", ",", "2", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "5", ",", "2", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}], 
        "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`Group[
     xAct`xPerm`Images[{1, 2, 3, 4, 5}], 
     xAct`xPerm`Images[{1, 3, 2, 4, 5}], 
     xAct`xPerm`Images[{2, 1, 3, 4, 5}], 
     xAct`xPerm`Images[{2, 3, 1, 4, 5}], 
     xAct`xPerm`Images[{3, 1, 2, 4, 5}], 
     xAct`xPerm`Images[{3, 2, 1, 4, 5}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 2, 3, 5, 4}], 
     xAct`xPerm`Images[{1, 3, 2, 5, 4}], 
     xAct`xPerm`Images[{2, 1, 3, 5, 4}], 
     xAct`xPerm`Images[{2, 3, 1, 5, 4}], 
     xAct`xPerm`Images[{3, 1, 2, 5, 4}], 
     xAct`xPerm`Images[{3, 2, 1, 5, 4}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 2, 4, 3, 5}], 
     xAct`xPerm`Images[{1, 4, 2, 3, 5}], 
     xAct`xPerm`Images[{2, 1, 4, 3, 5}], 
     xAct`xPerm`Images[{2, 4, 1, 3, 5}], 
     xAct`xPerm`Images[{4, 1, 2, 3, 5}], 
     xAct`xPerm`Images[{4, 2, 1, 3, 5}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 2, 4, 5, 3}], 
     xAct`xPerm`Images[{1, 4, 2, 5, 3}], 
     xAct`xPerm`Images[{2, 1, 4, 5, 3}], 
     xAct`xPerm`Images[{2, 4, 1, 5, 3}], 
     xAct`xPerm`Images[{4, 1, 2, 5, 3}], 
     xAct`xPerm`Images[{4, 2, 1, 5, 3}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 2, 5, 3, 4}], 
     xAct`xPerm`Images[{1, 5, 2, 3, 4}], 
     xAct`xPerm`Images[{2, 1, 5, 3, 4}], 
     xAct`xPerm`Images[{2, 5, 1, 3, 4}], 
     xAct`xPerm`Images[{5, 1, 2, 3, 4}], 
     xAct`xPerm`Images[{5, 2, 1, 3, 4}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 2, 5, 4, 3}], 
     xAct`xPerm`Images[{1, 5, 2, 4, 3}], 
     xAct`xPerm`Images[{2, 1, 5, 4, 3}], 
     xAct`xPerm`Images[{2, 5, 1, 4, 3}], 
     xAct`xPerm`Images[{5, 1, 2, 4, 3}], 
     xAct`xPerm`Images[{5, 2, 1, 4, 3}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 3, 4, 2, 5}], 
     xAct`xPerm`Images[{1, 4, 3, 2, 5}], 
     xAct`xPerm`Images[{3, 1, 4, 2, 5}], 
     xAct`xPerm`Images[{3, 4, 1, 2, 5}], 
     xAct`xPerm`Images[{4, 1, 3, 2, 5}], 
     xAct`xPerm`Images[{4, 3, 1, 2, 5}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 3, 4, 5, 2}], 
     xAct`xPerm`Images[{1, 4, 3, 5, 2}], 
     xAct`xPerm`Images[{3, 1, 4, 5, 2}], 
     xAct`xPerm`Images[{3, 4, 1, 5, 2}], 
     xAct`xPerm`Images[{4, 1, 3, 5, 2}], 
     xAct`xPerm`Images[{4, 3, 1, 5, 2}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 3, 5, 2, 4}], 
     xAct`xPerm`Images[{1, 5, 3, 2, 4}], 
     xAct`xPerm`Images[{3, 1, 5, 2, 4}], 
     xAct`xPerm`Images[{3, 5, 1, 2, 4}], 
     xAct`xPerm`Images[{5, 1, 3, 2, 4}], 
     xAct`xPerm`Images[{5, 3, 1, 2, 4}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 3, 5, 4, 2}], 
     xAct`xPerm`Images[{1, 5, 3, 4, 2}], 
     xAct`xPerm`Images[{3, 1, 5, 4, 2}], 
     xAct`xPerm`Images[{3, 5, 1, 4, 2}], 
     xAct`xPerm`Images[{5, 1, 3, 4, 2}], 
     xAct`xPerm`Images[{5, 3, 1, 4, 2}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 4, 5, 2, 3}], 
     xAct`xPerm`Images[{1, 5, 4, 2, 3}], 
     xAct`xPerm`Images[{4, 1, 5, 2, 3}], 
     xAct`xPerm`Images[{4, 5, 1, 2, 3}], 
     xAct`xPerm`Images[{5, 1, 4, 2, 3}], 
     xAct`xPerm`Images[{5, 4, 1, 2, 3}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{1, 4, 5, 3, 2}], 
     xAct`xPerm`Images[{1, 5, 4, 3, 2}], 
     xAct`xPerm`Images[{4, 1, 5, 3, 2}], 
     xAct`xPerm`Images[{4, 5, 1, 3, 2}], 
     xAct`xPerm`Images[{5, 1, 4, 3, 2}], 
     xAct`xPerm`Images[{5, 4, 1, 3, 2}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{2, 3, 4, 1, 5}], 
     xAct`xPerm`Images[{2, 4, 3, 1, 5}], 
     xAct`xPerm`Images[{3, 2, 4, 1, 5}], 
     xAct`xPerm`Images[{3, 4, 2, 1, 5}], 
     xAct`xPerm`Images[{4, 2, 3, 1, 5}], 
     xAct`xPerm`Images[{4, 3, 2, 1, 5}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{2, 3, 4, 5, 1}], 
     xAct`xPerm`Images[{2, 4, 3, 5, 1}], 
     xAct`xPerm`Images[{3, 2, 4, 5, 1}], 
     xAct`xPerm`Images[{3, 4, 2, 5, 1}], 
     xAct`xPerm`Images[{4, 2, 3, 5, 1}], 
     xAct`xPerm`Images[{4, 3, 2, 5, 1}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{2, 3, 5, 1, 4}], 
     xAct`xPerm`Images[{2, 5, 3, 1, 4}], 
     xAct`xPerm`Images[{3, 2, 5, 1, 4}], 
     xAct`xPerm`Images[{3, 5, 2, 1, 4}], 
     xAct`xPerm`Images[{5, 2, 3, 1, 4}], 
     xAct`xPerm`Images[{5, 3, 2, 1, 4}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{2, 3, 5, 4, 1}], 
     xAct`xPerm`Images[{2, 5, 3, 4, 1}], 
     xAct`xPerm`Images[{3, 2, 5, 4, 1}], 
     xAct`xPerm`Images[{3, 5, 2, 4, 1}], 
     xAct`xPerm`Images[{5, 2, 3, 4, 1}], 
     xAct`xPerm`Images[{5, 3, 2, 4, 1}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{2, 4, 5, 1, 3}], 
     xAct`xPerm`Images[{2, 5, 4, 1, 3}], 
     xAct`xPerm`Images[{4, 2, 5, 1, 3}], 
     xAct`xPerm`Images[{4, 5, 2, 1, 3}], 
     xAct`xPerm`Images[{5, 2, 4, 1, 3}], 
     xAct`xPerm`Images[{5, 4, 2, 1, 3}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{2, 4, 5, 3, 1}], 
     xAct`xPerm`Images[{2, 5, 4, 3, 1}], 
     xAct`xPerm`Images[{4, 2, 5, 3, 1}], 
     xAct`xPerm`Images[{4, 5, 2, 3, 1}], 
     xAct`xPerm`Images[{5, 2, 4, 3, 1}], 
     xAct`xPerm`Images[{5, 4, 2, 3, 1}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{3, 4, 5, 1, 2}], 
     xAct`xPerm`Images[{3, 5, 4, 1, 2}], 
     xAct`xPerm`Images[{4, 3, 5, 1, 2}], 
     xAct`xPerm`Images[{4, 5, 3, 1, 2}], 
     xAct`xPerm`Images[{5, 3, 4, 1, 2}], 
     xAct`xPerm`Images[{5, 4, 3, 1, 2}]], 
    xAct`xPerm`Coset[
     xAct`xPerm`Images[{3, 4, 5, 2, 1}], 
     xAct`xPerm`Images[{3, 5, 4, 2, 1}], 
     xAct`xPerm`Images[{4, 3, 5, 2, 1}], 
     xAct`xPerm`Images[{4, 5, 3, 2, 1}], 
     xAct`xPerm`Images[{5, 3, 4, 2, 1}], 
     xAct`xPerm`Images[{5, 4, 3, 2, 1}]]}],
  Editable->
   False]], "Output",ExpressionUUID->"98020d33-24dd-4130-955e-6e6989a0dc71"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"cosets", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}], "\[Equal]", 
     RowBox[{"reps", "[", 
      RowBox[{"[", "i", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"4b541aa5-635b-4f2b-93f5-78435b14deb0"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"31f1a659-6998-4e15-b9ff-02962821c889"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Group", "@@", 
   RowBox[{"Union", "[", 
    RowBox[{"Apply", "[", 
     RowBox[{"Sequence", ",", "cosets", ",", "1"}], "]"}], "]"}]}], "===", 
  RowBox[{
  "Sort", "[", "s5", 
   "]"}]}]], "Input",ExpressionUUID->"724abad8-89c1-4626-90ea-3468a77e7b8b"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"b728d4e2-f601-447c-aa94-f6893c5b1891"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["5.1.6. Example: S3 in S6", \
"Subsubsection",ExpressionUUID->"4f610dba-eec7-4e5a-a500-01547adc17c3"],

Cell["We construct the symmetric group of 6-perms:", \
"Text",ExpressionUUID->"113a657d-25bc-4427-90f8-12b47877c9a7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s6", "=", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "6"}], 
        "}"}], "]"}], ",", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"6", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5"}], 
        "}"}], "]"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "s6", 
  "]"}]}], "Input",ExpressionUUID->"0bf82471-4942-4ec6-9e29-e4bc3711c8b1"],

Cell[BoxData["720"], \
"Output",ExpressionUUID->"f4433603-4ff7-4b74-bd29-a431fd8cec00"]
}, Open  ]],

Cell["It is not sorted, according to PermSort:", \
"Text",ExpressionUUID->"c4fec0e3-d39b-4b55-abb5-5cc3a115e2c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PermSort", "[", "s6", "]"}], "===", 
  "s6"}]], "Input",ExpressionUUID->"9fc0dfcc-6946-44cf-849b-635da49fc49d"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"0eaff63d-4735-4390-ae8a-60f0fe3c51d1"]
}, Open  ]],

Cell["A subgroup of permutations is s3:", \
"Text",ExpressionUUID->"6f5af860-edb6-4645-8121-07cbba9de5e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{"Group", "@@", 
   RowBox[{"Stabilizer", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"GenSet", "@@", "s6"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"360e87bb-77bb-45fd-b87a-571697391909"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}], "]"}]], \
"Output",ExpressionUUID->"a923764e-ae57-4906-82b4-7af0367c9cdc"]
}, Open  ]],

Cell["described by", \
"Text",ExpressionUUID->"7761f8cc-3edb-4f33-a7ef-c18cc99d4468"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSs3", "=", 
  RowBox[{"SchreierSims", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "6"}], 
        "}"}], "]"}], ",", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5", ",", "6"}], 
        "}"}], "]"}]}], "]"}], ",", "6"}], 
   "]"}]}]], "Input",ExpressionUUID->"cf241569-6ecc-429c-ab54-c09e415a1cec"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}],
       "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5", ",", "6"}], "}"}],
       "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5", ",", "6"}], "}"}],
       "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"d75fb8e0-5c70-4c44-8161-c3d00693a049"]
}, Open  ]],

Cell["We have 20 coset representatives:", \
"Text",ExpressionUUID->"571ebe4c-d69e-417c-83ce-55fd49c249d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{"xAct`xPerm`RightCosetRepresentative", "[", 
       RowBox[{"#", ",", "6", ",", "SGSs3"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{"List", "@@", "s6"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"d46a3398-8118-45de-9b42-62803a46dc07"],

Cell[BoxData[
 RowBox[{
  RowBox[{"reps", "=", 
   RowBox[{"Union", "[", "result", "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"c5c35403-90d3-4e25-a109-39e534898cff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"cosets", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PermSort", "[", 
      RowBox[{"PermProduct", "[", 
       RowBox[{"s3", ",", 
        RowBox[{"reps", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "120"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"b99b5a29-b7f8-4e56-bf40-e1a40b967214"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"(", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"cosets", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "1"}], "]"}], "]"}], "\[Equal]", 
      RowBox[{"reps", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "120"}], "}"}]}], "]"}], 
   ")"}]}]], "Input",ExpressionUUID->"15d69626-5ddb-4b92-ac4d-4408be7de40a"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"ca27c268-2908-4cac-9608-c7e0df1fb1c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Group", "@@", 
   RowBox[{"Union", "[", 
    RowBox[{"Apply", "[", 
     RowBox[{"Sequence", ",", "cosets", ",", "1"}], "]"}], "]"}]}], "===", 
  RowBox[{
  "Sort", "[", "s6", 
   "]"}]}]], "Input",ExpressionUUID->"b46b698d-e382-407b-8d22-aa2618a6bc8d"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"1f42e3c8-d0a6-4a12-abc6-aa02b4bb4132"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["5.2. DoubleCosetRepresentative", \
"Subsection",ExpressionUUID->"8f404493-a901-4782-a7d0-f76d27765f18"],

Cell[CellGroupData[{

Cell["5.2.1. DummySet and RepeatedSet", \
"Subsubsection",ExpressionUUID->"5e566103-d05f-4100-a845-486f6b1db314"],

Cell["\<\
We first define the concept of a dummyset. We need it because we can have a \
tensor with dummies coming from different manifolds. A DummySet is a set of \
pairs of dummies all belonging to the same manifold. In principle there is no \
reason to work simultaneously with two disjoint dummy sets on the same \
manifold. Therefore we also require that a DummySet is the set of all pairs \
of dummies belonging to the same manifold. In addition, we supply the \
symmetry of the metric of that manifold, with this convention: if the metric \
is symmetric then metricQ=1; if the metric is antisymmetric (spinor calculus) \
then metricQ=-1; if there is no metric in the manifold then metricQ=0. Note \
that in the list of pairs of dummies we are giving their names, that is, we \
are supplying their positions in the canonical configuration. This is because \
D is a group acting on indices and not on slots.\
\>", "Text",ExpressionUUID->"c8cf936b-155a-4050-af0c-d16c5a7bd3d3"],

Cell["\<\
The DoubleCosetAlgorithm requires changing the SGS of D by BaseChange and \
stabilization. However, it is easier to change the dummysets and reconstruct \
the associated SGS because it always has the same simple structure. This is \
done with SGSOfDummySet:\
\>", "Text",ExpressionUUID->"7734a037-2b6d-40e8-9142-cfce05c20045"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SGSOfDummySet"}]], \
"Input",ExpressionUUID->"1e3b4e04-9739-4baa-a9a5-4d4d9df7d5ad"],

Cell[BoxData[
 StyleBox["\<\"SGSOfDummySet[ DummySet[...] ] gives a Strong Generating Set \
for the group of permutations associated to the given DummySet. There are \
always permutations coming from the exchange of dummies. There are \
permutations coming from the exchange of up/down indices in a pair if there \
is a metric for those indices. The GS is given in Cycles notation. See notes \
for DummySet.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3567978211-5455693",ExpressionUUID->"900d75bf-be61-4cee-bbf1-\
2d3482c4162b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SGSOfDummySet", "[", 
    RowBox[{"DummySet", "[", 
     RowBox[{"_", ",", "pairs_List", ",", "metricQ_Integer"}], "]"}], "]"}], ":=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"First", "/@", "pairs"}], ",", "\[IndentingNewLine]", 
     RowBox[{"GenSet", "@@", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Switch", "[", 
         RowBox[{"metricQ", ",", "\[IndentingNewLine]", "1", ",", 
          RowBox[{"Cycles", "/@", "pairs"}], ",", "\[IndentingNewLine]", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"Minus", "/@", 
           RowBox[{"Cycles", "/@", "pairs"}]}], ",", "\[IndentingNewLine]", 
          "0", ",", 
          RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "_", ",", 
          RowBox[{"Throw", "[", 
           RowBox[{
           "Print", "[", "\"\<Invalid value for metricQ in SGSOfDummySet.\>\"",
             "]"}], "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Cycles", "@@", "#"}], "&"}], "/@", 
          RowBox[{"Transpose", "/@", 
           RowBox[{"Partition", "[", 
            RowBox[{"pairs", ",", "2", ",", "1"}], "]"}]}]}], "]"}]}], 
       "]"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"SGSOfDummySet", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DummySet", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f26c9bd3-70ef-40b2-a31c-4122712aaa0c"],

Cell["\<\
There are two operations defined on a dummyset: moving and removing indices. \
Removing a pair is straightforward:\
\>", "Text",ExpressionUUID->"5a0e1e76-4a12-4ee4-96e2-33cabb5d6bda"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RemovePairOf", "[", 
    RowBox[{"i_Integer", ",", 
     RowBox[{"DummySet", "[", 
      RowBox[{"m_", ",", "pairs_List", ",", "metricQ_Integer"}], "]"}]}], 
    "]"}], ":=", 
   RowBox[{"DummySet", "[", 
    RowBox[{"m", ",", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{"pairs", ",", 
       RowBox[{"{", 
        RowBox[{"___", ",", "i", ",", "___"}], "}"}]}], "]"}], ",", 
     "metricQ"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7f52904e-2c97-4021-ac2c-0d84fbc920b5"],

Cell["\<\
However, moving an index to the first position requires the convention of \
having all first indices with the same character and all second indices with \
the same character. This is because the exchange of dummies must be done \
among up-indices and among down-indices separately. It might seem that we \
need to worry about a sign in the spinor case in the second line, but this is \
not true: the actual order of the pairs is not relevant and that sign is \
stored in the permutations d1.\
\>", "Text",ExpressionUUID->"d7563e21-6138-4b2b-93ae-5f98d701616d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MovePairOf", "[", 
    RowBox[{"i_Integer", ",", 
     RowBox[{"DummySet", "[", 
      RowBox[{"m_", ",", 
       RowBox[{"{", 
        RowBox[{"p1___", ",", 
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], ",", "p2___"}], "}"}], ",", 
       "metricQ_Integer"}], "]"}]}], "]"}], ":=", 
   RowBox[{"DummySet", "[", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j"}], "}"}], ",", "p1", ",", "p2"}], "}"}], ",", 
     "metricQ"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MovePairOf", "[", 
    RowBox[{"i_Integer", ",", 
     RowBox[{"DummySet", "[", 
      RowBox[{"m_", ",", 
       RowBox[{"{", 
        RowBox[{"p1___", ",", 
         RowBox[{"{", 
          RowBox[{"j_", ",", "i_"}], "}"}], ",", "p2___"}], "}"}], ",", 
       "metricQ_Integer"}], "]"}]}], "]"}], ":=", 
   RowBox[{"DummySet", "[", 
    RowBox[{"m", ",", 
     RowBox[{"Reverse", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"j", ",", "i"}], "}"}], ",", "p1", ",", "p2"}], "}"}]}], ",",
      "metricQ"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MovePairOf", "[", 
    RowBox[{"i_Integer", ",", "DS_DummySet"}], "]"}], ":=", "DS"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"bbbf4e72-531c-490b-9e22-b0d3b6dc4de9"],

Cell["Examples:", \
"Text",ExpressionUUID->"cb249a33-1f5b-454e-a80a-b10997aa88d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSOfDummySet", "[", 
  RowBox[{"DummySet", "[", 
   RowBox[{"M2", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "0"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"b8c2e9df-1b5a-43eb-b34d-e3515646987a"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}], "]"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"db71d21b-a573-42c0-bb32-73fa6ee06750"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSOfDummySet", "[", 
  RowBox[{"DummySet", "[", 
   RowBox[{"M2", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "}"}], ",", "1"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"d79f4caa-2bfa-43c1-90c4-4684a3ae58c9"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"c19fa528-f48c-4d29-b186-3760746d82f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSOfDummySet", "[", 
  RowBox[{"DummySet", "[", 
   RowBox[{"M2", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "1"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"1fb0740b-daa9-48fd-a5c2-0292654390e5"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",ExpressionUUID->"a490ca52-f31b-4e38-9160-a80f0c688669"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSOfDummySet", "[", 
  RowBox[{"DummySet", "[", 
   RowBox[{"M2", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3