Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xPert",
 FontSlant->"Italic",
 FontColor->RGBColor[
  1, 0, 0]]], "Title",ExpressionUUID->"b4a30419-d71d-405f-9143-451b37b145d0"],

Cell[TextData[StyleBox["High-order perturbation theory in General Relativity",
 
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subtitle",ExpressionUUID->"a9e89d26-ef7f-4939-bff9-7a214c7016bb"],

Cell[TextData[{
 "David Brizuela, david.brizuela@ehu.eus\nJos\[EAcute] M. Mart\[IAcute]n-Garc\
\[IAcute]a, jose@xact.es\nGuillermo A. Mena Marug\[AAcute]n, \
mena@iem.cfmac.csic.es\n",
 StyleBox["\n(c) 2005-2026, under GPL\n\nhttp://www.xact.es/\n\
http://groups.google.com/group/xact",
  FontSize->16],
 "\n\n",
 StyleBox["October 2005 - May 2006: Version 0.5.0: First public version.",
  FontSize->12],
 "\n",
 StyleBox["September 2007: Version 0.7.0: Notebook adapted for version 0.9.2 \
of xAct.\nNovember 2007: Version 0.7.1: Notebook adapted for version 0.9.3 of \
xAct.\nMarch 2008: Version 0.7.2: Notebook adapted for version 0.9.4 of xAct.\
\nMay-June 2008: Version 1.0.0. Substantial update for publication.",
  FontSize->12]
}], "Subsubtitle",
 FontSize->18,ExpressionUUID->"e624e7dc-4f10-4f72-9a26-17d16c3f005d"],

Cell[TextData[{
 "This package expands any finite-order perturbation of any of the \
GR-relevant curvature tensors in terms of metric perturbations.\n\nThe \
package ",
 StyleBox["xPert",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is distributed under the GNU GPL License, and runs on top of ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", a free package for fast manipulation of abstract tensor expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"00f68a08-32b5-41e3-9e5b-42a09723d048"],

Cell[CellGroupData[{

Cell[BoxData["Today"], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"412b6038-520d-46f5-b92e-bc3c139b0d34"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Mon 29 Dec 2025\""}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{"2025", ",", "12", ",", "29"}], "}"}], ",", "\"Day\""}], 
     "]"}]},
  "DateObject",
  Editable->False]], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"436ef574-2913-499d-81e5-f518ad2fd041"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`xPert`$Version", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.0.6\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[2]:=",ExpressionUUID->"12bcd81d-5247-495e-934a-4243e1572425"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`xPert`$xTensorVersionExpected", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.1.4\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2020", ",", "2", ",", "16"}], "}"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[3]:=",ExpressionUUID->"cab1b3a7-4193-4cca-84cd-3744e4b3aec3"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1. Initialization",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subsection",ExpressionUUID->"6cde2511-43fc-4dcd-920c-a68e005e6e0d"],

Cell[CellGroupData[{

Cell["1.1. GPL", \
"Subsubsection",ExpressionUUID->"f9016208-c607-4ea7-90e3-ea03d20d081f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xPert", ",", " ", 
    RowBox[{
    "computer", " ", "algebra", " ", "for", " ", "perturbation", " ", 
     "theory", " ", "in", " ", "General", " ", "Relativity"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Copyright", " ", 
      RowBox[{"(", "C", ")"}], " ", "2005"}], "-", 
     RowBox[{"2026", " ", "David", " ", "Brizuela"}]}], ",", " ", 
    RowBox[{
     RowBox[{"Jose", " ", 
      RowBox[{"M", ".", " ", "Martin"}]}], "-", 
     RowBox[{"Garcia", " ", "and", " ", "Guillermo", " ", 
      RowBox[{"A", ".", " ", "Mena"}], " ", "Marugan"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], "\[IndentingNewLine]", " ", "modify", " ", 
      "it", " ", "under", " ", "the", " ", "terms", " ", "of", " ", "the", " ",
       "GNU", " ", "General", " ", "Public", " ", "License", " ", "as", "\[IndentingNewLine]",
       " ", "published", " ", "by", " ", "the", " ", "Free", " ", "Software", 
      " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", "\[IndentingNewLine]", 
      " ", "the", " ", "License"}]}], ",", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], " ",
      "program", " ", "is", " ", "distributed", " ", "in", " ", "the", " ", 
     "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", "useful"}], 
    ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", " ", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", "\[IndentingNewLine]",
       " ", "General", " ", "Public", " ", "License", " ", "for", " ", "more",
       " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], " ",
       "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ", 
      "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", "\[IndentingNewLine]", " ", "along", " ", "with", " ", 
      "this", " ", "program"}], ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", "\[IndentingNewLine]",
      " ", "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[4]:=",ExpressionUUID->"c950c986-24c2-4c41-93db-108fe9af47d3"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Info package", \
"Subsubsection",ExpressionUUID->"83e2ea91-f394-4998-9df3-f5df58f0ac4f"],

Cell["\<\
(* :Title: xPert *)

(* :Author: David Brizuela, Jose M. Martin-Garcia and 
\tGuillermo A. Mena Marugan *)

(* :Summary: Computer algebra for perturbation theory in General
    Relativity *)

(* :Brief Discussion:
   - Single-parameter metric perturbation theory
   - Inert-head Perturbation and explicit expansion formulas
     through ExpandPerturbation
   - Handles densities, derivatives and all index positions in
     tensors
   - Formula for arbitrary gauge change 
*)
  
(* :Context: xAct`xPert` *)

(* :Package Version: 1.0.6 *)

(* :Copyright: David Brizuela, Jose M. Martin-Garcia and 
\tGuillermo A. Mena Marugan (2005-2026) *)

(* :History: see xPert.History *)

(* :Keywords: *)

(* :Source: xPert.nb *)

(* :Warning: ToCanonical can only act on expressions with the
    Perturbation head with option UseMetricOnVBundle->None *)

(* :Mathematica Version: 6.0 and later *)

(* :Limitations: 
\t- Only one perturbation structure can be defined.
\t- Only single-parameter metric perturbation theory *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellLabel->"In[5]:=",ExpressionUUID->"eca838f5-0069-4365-9bf1-47e13e2058df"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. BeginPackage", \
"Subsubsection",ExpressionUUID->"e9a9d1c1-4ddd-4643-888a-7cafa662a4ff"],

Cell["Protect against multiple loading of the package:", \
"Text",ExpressionUUID->"d527be61-72bb-4717-8445-700080acbe13"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xAct`xPert`Private`xPertSymbols", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Names", "[", "\"\<xAct`xPert`*\>\"", "]"}], ",", 
         RowBox[{"Names", "[", "\"\<xAct`xPert`Private`*\>\"", "]"}]}], "]"}],
        ",", 
       RowBox[{"\"\<$Version\>\"", "|", "\"\<xAct`xPert`$Version\>\"", 
        "|", "\"\<$xTensorVersionExpected\>\"", 
        "|", "\"\<xAct`xPert`$xTensorVersionExpected\>\""}]}], "]"}]}], "}"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "/@", "xAct`xPert`Private`xPertSymbols"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Clear", "/@", "xAct`xPert`Private`xPertSymbols"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[30]:=",ExpressionUUID->"10cf685e-3ebe-430f-8fe1-70325ee9b404"],

Cell["Decide which is the last package being read:", \
"Text",ExpressionUUID->"1d285b3b-e080-407a-8e4a-da742f974c2a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{"xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`xPert`\>\""}]}],
    "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[31]:=",ExpressionUUID->"368a7299-ac42-41be-86f7-3aeca43531dc"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"d3307511-4e1e-46e7-8363-216c3291a518"],

Cell[BoxData["\<\"xAct`xPert`\"\>"], "Output",
 CellLabel->
  "Out[32]=",ExpressionUUID->"ec52022f-8904-409c-a918-86c513af1ac7"]
}, Open  ]],

Cell["\<\
Explicit (not hidden) import of other packages. QUESTION: Do we really need \
ExpressionManipulation?\
\>", "Text",ExpressionUUID->"bdfc1ba9-61b7-4c5e-b250-ad1ce1cab462"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`xPert`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", 
     ",", "\"\<xAct`xCore`\>\"", 
     ",", "\"\<xAct`ExpressionManipulation`\>\""}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[33]:=",ExpressionUUID->"2c6301bb-e735-49a4-ad9e-421061074998"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"71d2e9a4-dbd1-4ea7-ad79-7ad21b2d8110"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.4", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"2e993037-fcec-43df-8b39-9e656ea246ea"],

Cell[BoxData["\<\"CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"60b94e4c-e132-49b7-8a2d-bb322bd32472"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"e55a91bf-b168-496f-83bd-bd73bb8e0e05"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"b0ceae54-0023-438d-a778-b4da5e642c82"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"b7abe95d-622d-46af-ab9b-c5fa4528d003"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.3.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.3.0", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"e6608ad8-a39b-4080-bff5-c9ed354c5d9a"],

Cell[BoxData["\<\"CopyRight (C) 2002-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"0b8ff4c7-4e10-43ed-90c6-b664cd8fbead"]
}, Open  ]],

Cell[BoxData["\<\"xAct`xPert`\"\>"], "Output",
 CellLabel->
  "Out[33]=",ExpressionUUID->"afa6b6e3-67e4-4202-8002-950c12278041"]
}, Open  ]],

Cell[TextData[{
 "Check version of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". We simply compare dates:"
}], "Text",ExpressionUUID->"069893d6-5fdf-42b7-aae0-e9ea0b93b094"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Not", "@", 
    RowBox[{"OrderedQ", "@", 
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"{", 
        RowBox[{"$xTensorVersionExpected", ",", "xAct`xTensor`$Version"}], 
        "}"}]}], "]"}]}]}], ",", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"General", "::", "versions"}], ",", "\"\<xTensor\>\"", ",", 
      "xAct`xTensor`$Version", ",", "$xTensorVersionExpected"}], "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[34]:=",ExpressionUUID->"0d5c9762-26dd-4c98-a2a2-cba2b95cd814"],

Cell["Welcome message:", \
"Text",ExpressionUUID->"27a2f0a2-219f-43eb-a4ca-f176163e0400"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`xPert`  version \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", "\"\<CopyRight (C) 2005-2026, David Brizuela, Jose M. \
Martin-Garcia and Guillermo A. Mena Marugan, under the General Public \
License.\>\"", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[35]:=",ExpressionUUID->"9f05f673-eb2e-4b11-b4f3-56ef6c63fcfb"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"78bcc9c2-c179-4f43-9579-fc66b1a47c3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPert`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xPert`  version ", "1.0.6", ", ", {2018, 2, 28}],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"73fd0827-2f12-4792-b627-d0f56c55dd52"],

Cell[BoxData["\<\"CopyRight (C) 2005-2026, David Brizuela, Jose M. \
Martin-Garcia and Guillermo A. Mena Marugan, under the General Public \
License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"0ebc27ed-e601-468d-abcb-341220502500"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We specify the context xAct`xPert` to avoid overriding the Disclaimer of the \
other packages. However we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"9e231dfa-9c36-4028-857e-949a8cc3fcac"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xPert`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[38]:=",ExpressionUUID->"ed76cf79-0928-4aea-bdf8-e6a2d25b9c5f"],

Cell["If this is the last package show the GPL short disclaimer:", \
"Text",ExpressionUUID->"66c06c99-bc67-480d-9b70-d713edce3862"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`xPert`\>\""}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", "\"\<These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\>\"", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[41]:=",ExpressionUUID->"bc8e3b50-bdac-474a-acef-9fb0c17d0fa2"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"39eed08e-5116-4dac-9d73-e003bdc90cb0"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"9e324c87-0732-4c32-b3f1-2aad3ba06d51"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"3a775904-011a-4c63-8d6e-4cd0d085fea9"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Note that symbols in the Global` context cannot be accessed while building \
the package:\
\>", "Text",ExpressionUUID->"05438a5b-d7c8-4ffa-a6e6-aeb36ef2a70d"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"d6ef88b5-bb2b-419a-ab48-0074d7d24ca4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xPert`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`ExpressionManipulation`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[42]=",ExpressionUUID->"eb1a3549-f6ff-41c0-af5d-faac6d522901"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"06f8e3a5-a4d4-4dad-8427-40ea4d6731f3"],

Cell[BoxData["\<\"xAct`xPert`\"\>"], "Output",
 CellLabel->
  "Out[43]=",ExpressionUUID->"8a61b1a3-78e6-4ee3-9274-bd320921e6eb"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. Set up", \
"Subsubsection",ExpressionUUID->"0be88e1b-e424-4707-9608-9c2a648d5871"],

Cell["Screen all dollar indicess:", \
"Text",ExpressionUUID->"f3c5da4f-d05d-4b24-9eb6-d1db33f651ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSet", "[", 
   RowBox[{"$PrePrint", ",", "ScreenDollarIndices"}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"de6a5085-f560-490f-a9d9-050c142aaaf5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$PrePrint", 
   "\[InvisibleSpace]", "\<\" assigned value \"\>", "\[InvisibleSpace]", 
   "ScreenDollarIndices"}],
  SequenceForm[
  "** Variable ", $PrePrint, " assigned value ", 
   xAct`xTensor`ScreenDollarIndices],
  Editable->
   False]], "Print",ExpressionUUID->"4ad0935b-f8fe-4c8d-ac24-dd3a8adb9409"]
}, Open  ]],

Cell["Postfix format for derivatives:", \
"Text",ExpressionUUID->"b922ca56-b5ff-4215-abd8-5f4ad936ea45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSet", "[", 
   RowBox[{"$CovDFormat", ",", "\"\<Postfix\>\""}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"83b4b280-5961-4d8e-8718-beaec2875595"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$CovDFormat", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", 
   "\[InvisibleSpace]", "\<\"Prefix\"\>", "\[InvisibleSpace]", "\<\" to \"\>",
    "\[InvisibleSpace]", "\<\"Postfix\"\>"}],
  SequenceForm[
  "** Variable ", xAct`xTensor`$CovDFormat, " changed from ", "Prefix", 
   " to ", "Postfix"],
  Editable->
   False]], "Print",ExpressionUUID->"278cf04b-2d99-4de5-bf1b-95daaceacaa5"]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["xPert",
  FontSlant->"Italic"],
 " we shall allow metric contractions everywhere:"
}], "Text",ExpressionUUID->"68396195-952d-49c0-ba71-b9317f965758"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"ContractMetric", ",", 
    RowBox[{"AllowUpperDerivatives", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"90de22cd-4d71-47fb-875b-d921f42a2c8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->
   False]], "Print",ExpressionUUID->"d68b6f4d-6f0c-4c0b-9e89-4b858d4a36b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"MakeRule", ",", 
    RowBox[{"MetricOn", "\[Rule]", "All"}]}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6725986a-c2c6-4e4f-8de8-117cf4a66f03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "MetricOn", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "MakeRule", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "None",
    "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "All"}],
  SequenceForm[
  "** Option ", xAct`xTensor`MetricOn, " of ", xAct`xTensor`MakeRule, 
   " changed from ", None, " to ", All],
  Editable->
   False]], "Print",ExpressionUUID->"aef5031a-e47c-4a9a-a7a4-8eb2d8a408ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"MakeRule", ",", 
    RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"68bac3c3-6f96-4591-8d5d-14443107ef6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "ContractMetrics", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "MakeRule", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`ContractMetrics, " of ", xAct`xTensor`MakeRule, 
   " changed from ", False, " to ", True],
  Editable->
   False]], "Print",ExpressionUUID->"af8f4719-100a-4166-b8b3-3330a5dd8da7"]
}, Open  ]],

Cell["We do not modify the the option MathLink of CanonicalPerm:", \
"Text",ExpressionUUID->"48b3cec8-8327-450a-a991-19f0843d4f15"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "CanonicalPerm", 
  "]"}]], "Input",ExpressionUUID->"d1ea94ae-3297-4ea0-a95a-529051293911"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MathLink", "\[RuleDelayed]", "$xpermQ"}], ",", 
   RowBox[{"TimeVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"OrderedBase", "\[Rule]", "True"}]}], 
  "}"}]], "Output",ExpressionUUID->"eef9f623-1408-4b57-a926-ee9c390f56e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], \
"Input",ExpressionUUID->"ff1efe79-aa2c-418c-9a5c-4c257e7c562d"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"f15682be-c938-4865-8c0a-f2b06482094c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5. Usage messages", \
"Subsubsection",ExpressionUUID->"5e387c32-a1f0-44e1-9a71-ff137b1c7165"],

Cell["Define perturbation objects:", \
"Text",ExpressionUUID->"186e92fa-3d80-4c0c-bfab-ff25c8a144a6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "::", "usage"}], 
   "=", "\"\<Perturbation[expr] represents the perturbation of expr. \
Perturbation[expr, n] represents its n-th perturbation. Perturbation is an \
inert-head.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Perturbed", "::", "usage"}], 
   "=", "\"\<Perturbed[expr, n] returns the expansion of expr perturbed up to \
n-th order, using $PerturbationParameter.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$PerturbationParameter", "::", "usage"}], 
   "=", "\"\<$PerturbationParameter is a global variable containing the \
parameter used in the perturbative expansions.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PerturbationParameter", "::", "usage"}], 
   "=", "\"\<PerturbationParameter[metric] stores the perturbation parameter \
associated to the perturbation of the given metric.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbation", "::", "usage"}], 
   "=", "\"\<ExpandPerturbation[expr] returns expr with all Perturbation \
expressions expanded in terms of metric perturbations. It uses fast \
pre-stored formulas for the general term of the perturbative expansion of the \
most common curvature tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefTensorPerturbation", "::", "usage"}], 
   "=", "\"\<DefTensorPerturbation[pert[LI[n], inds], tensor[inds], args] \
defines pert to be the perturbation of tensor, with the same index \
configuration. There is an internal call to DefTensor[pert[LI[n], inds], \
args].\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PerturbationOrder", "::", "usage"}], 
   "=", "\"\<PerturbationOrder[expr] gives the perturbative order of \
expression, as given by the orders of its arguments. This function must be \
defined on those perturbations declared by the user.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GaugeChange", "::", "usage"}], 
   "=", "\"\<GaugeChange[pert, gen] returns the perturbative expression pert \
changed to a new gauge. The change of gauge is parametrized by the family of \
vector fields gen[LI[order], a]. Background objects are left \
untouched.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GeneralPerturbation", "::", "usage"}], 
   "=", "\"\<GeneralPerturbation[expr, n] returns \
ExpandPerturbation[Perturbation[expr, n]]. This is kept for backwards \
compatibility with older versions.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"58513da2-3d75-4491-8974-982d60f8f0ce"],

Cell["\<\
Perturbation structure on already existing vbundle and metric:\
\>", "Text",ExpressionUUID->"c591594c-a3ab-4afe-8295-26f8305dadbe"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefMetricPerturbation", "::", "usage"}], 
   "=", "\"\<DefMetricPerturbation[metric, pert, param] constructs a number \
of definitions for the perturbation of the given metric, which must exist \
already. A tensor pert[LI[order], -a, -b] is defined on the vbundle of the \
metric, and the parameter param will be defined and used to expand the \
perturbed expressions. DefMetricPerturbation[metric, pert] uses a default \
name for the parameter.\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bf3da170-5180-4cfa-a701-de63e26f036e"],

Cell["Versions:", \
"Text",ExpressionUUID->"3c61dfb5-210d-4c86-9909-bd51844384f1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xPert`$Version", "::", "usage"}], 
   "=", "\"\<$Version is a global variable giving the version of the package \
xPert in use.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xPert`$xTensorVersionExpected", "::", "usage"}], 
   "=", "\"\<$xTensorVersionExpected is a global variable giving the oldest \
possible version of the package xTensor which is required by the version of \
the package xPert in use.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cbb68910-a9c2-4e10-94bf-e589c1cc9f39"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.6. Begin private", \
"Subsubsection",ExpressionUUID->"1428882b-52c1-45fe-af8a-bfd706bcba0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<xAct`xPert`Private`\>\"", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d83004f8-2bc6-4b4d-9b8e-35e303108832"],

Cell[BoxData["\<\"xAct`xPert`Private`\"\>"], \
"Output",ExpressionUUID->"af939421-14e5-4f46-8577-70733187a041"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`xPert`*\>\"", 
  "]"}]], "Input",ExpressionUUID->"ebe8ee3c-34b5-422e-bbd6-496e118a4ca3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DefMetricPerturbation\"\>", 
   ",", "\<\"DefTensorPerturbation\"\>", ",", "\<\"Disclaimer\"\>", 
   ",", "\<\"ExpandPerturbation\"\>", ",", "\<\"GaugeChange\"\>", 
   ",", "\<\"GeneralPerturbation\"\>", ",", "\<\"Perturbation\"\>", 
   ",", "\<\"PerturbationOrder\"\>", ",", "\<\"PerturbationParameter\"\>", 
   ",", "\<\"Perturbed\"\>", ",", "\<\"$PerturbationParameter\"\>", 
   ",", "\<\"$Version\"\>", ",", "\<\"$xTensorVersionExpected\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"f76d8ee6-ba29-4c07-8e0e-17a0b936a6ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "Length"}]], "Input",ExpressionUUID->"996e508a-b974-4658-b988-8848d456758a"],

Cell[BoxData["13"], \
"Output",ExpressionUUID->"252c20a6-7e38-4c29-9b81-730566f61f54"]
}, Open  ]],

Cell["\<\
There are 12 symbols in this package, but only 4 are nontrivial.\
\>", "Text",ExpressionUUID->"c8f88c7b-3031-4ef8-be1a-a536e3f18ab6"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], \
"Input",ExpressionUUID->"5b4467e8-cfd0-47bd-9fd4-3988da525cf5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DocumentationSearch`\"\>", ",", "\<\"ResourceLocator`\"\>", 
   ",", "\<\"PacletManager`\"\>", ",", "\<\"xAct`xPert`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"xAct`ExpressionManipulation`\"\>", 
   ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"65823c0f-c7a0-4b0a-9261-8e2c7b166a97"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], \
"Input",ExpressionUUID->"8ab54fe6-4a08-4da6-b0f6-82fa1e3af641"],

Cell[BoxData["\<\"xAct`xPert`Private`\"\>"], \
"Output",ExpressionUUID->"d28e3947-a98f-4129-9bde-7e8bc2e2afd3"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2. Partitions",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subsection",ExpressionUUID->"a216a2cf-e38a-4e90-a741-91dccd0bf48e"],

Cell[CellGroupData[{

Cell["2.1. Sorted partitions", \
"Subsubsection",ExpressionUUID->"1792e218-a6cf-4157-8735-3c09d4360852"],

Cell[TextData[{
 "Generation of sorted partitions. The function group gives all partitions of \
length n-1 from a partition of length n. The function ",
 StyleBox["SortedPartitions",
  FontFamily->"Courier"],
 " simply computes all partitions starting from (1,1,...,1) applying group[ ] \
recursively until reaching length 0."
}], "Text",ExpressionUUID->"2768beb4-85de-4aef-a0db-2fbb655f5d74"],

Cell[BoxData[
 RowBox[{
  RowBox[{"group", "[", "list_List", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Take", "[", 
       RowBox[{"list", ",", 
        RowBox[{"i", "-", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "+", 
        RowBox[{"list", "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"Drop", "[", 
       RowBox[{"list", ",", 
        RowBox[{"i", "+", "1"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{
       RowBox[{"Length", "[", "list", "]"}], "-", "1"}]}], "}"}]}], 
   "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3a43ce51-4918-4529-a8fe-df114e4e875d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SortedPartitions", "[", 
   RowBox[{"n_Integer", "?", "Positive"}], "]"}], ":=", 
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"FixedPointList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Union", "@", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"group", "/@", "#"}], ",", "1"}], "]"}]}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"Table", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", "n", "}"}]}], "]"}], "}"}]}], "]"}], ",", "1"}], 
   "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c1e98256-95e5-4118-bd3e-9b32489c8591"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortedPartitions", "[", "5", 
  "]"}]], "Input",ExpressionUUID->"37f2c222-3506-4988-808a-95334b9b7fed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "5", "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"05809bbe-5592-4844-901b-8567b8dc05c0"]
}, Open  ]],

Cell["Lengths 2^(i-1):", \
"Text",ExpressionUUID->"c7f44dd0-cebe-4549-8610-f359149c36e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"Length", "[", 
      RowBox[{"SortedPartitions", "[", "i", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "12"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"a325ca07-71e9-4d6d-b4ac-49dea4e4b20d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "64"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "128"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "256"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "512"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "1024"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "2048"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"63f16104-9f7b-4617-9fe9-9ff21d7bc213"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. All partitions. Generalized Leibniz rule", \
"Subsubsection",ExpressionUUID->"3e122885-9b92-4711-b326-689dd616f438"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"addone", "[", "n_", "]"}], "[", 
    RowBox[{"{", "prev___Integer", "}"}], "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"prev", ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", 
       RowBox[{"n", "-", 
        RowBox[{"Total", "[", 
         RowBox[{"{", "prev", "}"}], "]"}]}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"onelevel", "[", "n_", "]"}], "[", "list_List", "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Join", ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"addone", "[", "n", "]"}], ",", "list"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"complete", "[", "n_", "]"}], "[", 
    RowBox[{"{", "prev___Integer", "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"prev", ",", 
     RowBox[{"n", "-", 
      RowBox[{"Total", "[", 
       RowBox[{"{", "prev", "}"}], "]"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"lastlevel", "[", "n_", "]"}], "[", "list_List", "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"complete", "[", "n", "]"}], ",", "list"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3fc362b8-99d3-4f1c-be0c-7fb0ca50768e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AllPartitions", "[", 
    RowBox[{"0", ",", "n_Integer"}], "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AllPartitions", "[", 
    RowBox[{"m_Integer", ",", "n_Integer"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"lastlevel", "[", "n", "]"}], "[", 
    RowBox[{"Nest", "[", 
     RowBox[{
      RowBox[{"onelevel", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", "}"}], "}"}], ",", 
      RowBox[{"m", "-", "1"}]}], "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"24b68d48-a555-4a22-8b85-6bcea22c0c8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AllPartitions", "[", 
  RowBox[{"4", ",", "3"}], 
  "]"}]], "Input",ExpressionUUID->"e5404a1f-3fde-4dd3-8e63-82387c63542c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"c8335270-cd5c-4d44-8312-c5b6641e970d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LeibnizDistribute", "[", 
    RowBox[{"operator_", ",", "n_", ",", 
     RowBox[{"f_", "[", "args___", "]"}], ",", "g_"}], "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"g", ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Multinomial", "@@", "#"}], " ", 
         RowBox[{"Inner", "[", 
          RowBox[{"operator", ",", 
           RowBox[{"{", "args", "}"}], ",", "#", ",", "f"}], "]"}]}], "&"}], ",", 
       RowBox[{"AllPartitions", "[", 
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"{", "args", "}"}], "]"}], ",", "n"}], "]"}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2f8b839d-5172-4a81-8461-d2e931179676"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c", "+", "d", "+", "e", "+", "f"}], ")"}], 
     "^", "20"}], "]"}], "//", "Length"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"3975a1ea-00cb-43bd-954a-bc1c4fc3188a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.13162`", ",", "53130"}], 
  "}"}]], "Output",ExpressionUUID->"9adcdd07-ec26-4fee-8b6f-5ead4495abd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AllPartitions", "[", 
    RowBox[{"6", ",", "20"}], "]"}], "//", "Length"}], "//", 
  "AbsoluteTiming"}]], \
"Input",ExpressionUUID->"12df1515-474a-417e-9f20-43c14625414c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.248154`", ",", "53130"}], 
  "}"}]], "Output",ExpressionUUID->"00a909df-a92e-4f09-b525-409a624032b0"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3. Folded partitions. Fa`a di Bruno rule", \
"Subsubsection",ExpressionUUID->"9bbb41fd-e28c-4d58-be1d-1ba6710a23b4"],

Cell["\<\
This are partitions {k1, ..., kn} of integer n obeying Sum[i*ki, {i,n}] \
\[Equal] n .\
\>", "Text",ExpressionUUID->"65901695-39b1-4c4f-aea6-97924e1dc576"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FoldedPartitions", "[", "n_", "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Fold", "[", 
      RowBox[{"step", ",", 
       RowBox[{"fpart", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "}"}], ",", "n"}], "}"}], ",", "n"}], "]"}], ",", 
       RowBox[{"Reverse", "@", 
        RowBox[{"Range", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"partition_", ",", "0"}], "}"}], "\[RuleDelayed]", 
      "partition"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a9e8c5dd-ba28-49c7-8ba1-933d995080ac"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fpart", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "part___", "}"}], ",", "0"}], "}"}], ",", "d_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "part"}], "}"}], ",", "0"}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fpart", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "part___", "}"}], ",", "m_"}], "}"}], ",", "d_"}], "]"}], 
   ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", "part"}], "}"}], ",", 
       RowBox[{"m", "-", 
        RowBox[{"d", " ", "#"}]}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"m", "/", "d"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"step", "[", 
    RowBox[{"pairs_List", ",", "d_"}], "]"}], ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"fpart", "[", 
        RowBox[{"#", ",", "d"}], "]"}], "&"}], "/@", "pairs"}], ",", "1"}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"01772064-4bfe-46bb-b2b0-706e74fdd13c"],

Cell["\<\
Folded partitions are currently being used by the GaugeChange formula.\
\>", "Text",ExpressionUUID->"ff6c08e1-8eec-44ea-a91c-5fdb6cb12a5e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldedPartitions", "[", "8", 
  "]"}]], "Input",ExpressionUUID->"efe4c9da-0613-4c8a-a21d-e2a0cf8f5ede"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "8", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "3", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "4", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "2", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "1"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"70911e4b-180a-4bac-b642-f67cff049436"]
}, Open  ]],

Cell["Fa`a di Bruno formula:", \
"Text",ExpressionUUID->"58151f20-b177-405d-b300-3664e9829f79"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"faa", "[", "expr_", "]"}], "[", 
    RowBox[{"ki_", ",", 
     RowBox[{"{", "0", "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Scalar", "[", "expr", "]"}], "^", "ki"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"faa", "[", "expr_", "]"}], "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "i_", "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Perturbation", "[", 
     RowBox[{"expr", ",", "i"}], "]"}], "/", 
    RowBox[{"i", "!"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"faa", "[", "expr_", "]"}], "[", 
    RowBox[{"ki_", ",", 
     RowBox[{"{", "i_", "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Scalar", "@", 
       RowBox[{"Perturbation", "[", 
        RowBox[{"expr", ",", "i"}], "]"}]}], "/", 
      RowBox[{"i", "!"}]}], ")"}], "^", "ki"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FaadiBruno1", "[", 
    RowBox[{"partition_", ",", 
     RowBox[{"function_", "[", "expr_", "]"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "=", 
        RowBox[{"partition", ".", 
         RowBox[{"Range", "[", 
          RowBox[{"Length", "[", "partition", "]"}], "]"}]}]}], ",", 
       RowBox[{"k", "=", 
        RowBox[{"Plus", "@@", "partition"}]}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"n", "!"}], "/", 
       RowBox[{"Apply", "[", 
        RowBox[{"Times", ",", 
         RowBox[{"Factorial", "/@", "partition"}]}], "]"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "k", "]"}], "[", "function", "]"}], "[", 
       "expr", "]"}], 
      RowBox[{"Times", "@@", 
       RowBox[{"MapIndexed", "[", 
        RowBox[{
         RowBox[{"faa", "[", "expr", "]"}], ",", "partition"}], "]"}]}]}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FaadiBruno1", "[", 
    RowBox[{"partition_", ",", 
     RowBox[{"Power", "[", 
      RowBox[{"expr_", ",", "exponent_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "=", 
        RowBox[{"partition", ".", 
         RowBox[{"Range", "[", 
          RowBox[{"Length", "[", "partition", "]"}], "]"}]}]}], ",", 
       RowBox[{"k", "=", 
        RowBox[{"Plus", "@@", "partition"}]}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"n", "!"}], "/", 
       RowBox[{"Apply", "[", 
        RowBox[{"Times", ",", 
         RowBox[{"Factorial", "/@", "partition"}]}], "]"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"k", ",", "0"}], "]"}], "[", "Power", "]"}], "[", 
       RowBox[{"expr", ",", "exponent"}], "]"}], 
      RowBox[{"Times", "@@", 
       RowBox[{"MapIndexed", "[", 
        RowBox[{
         RowBox[{"faa", "[", "expr", "]"}], ",", "partition"}], "]"}]}]}]}], 
    "]"}]}], ";"}]}], \
"Input",ExpressionUUID->"70b1e3f4-b83b-42ba-820e-1c8e0083c18b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FaadiBruno0", "[", 
   RowBox[{"expr_", ",", "order_"}], "]"}], ":=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Plus", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"FaadiBruno1", "[", 
       RowBox[{"#", ",", "expr"}], "]"}], "&"}], "/@", 
     RowBox[{"FoldedPartitions", "[", "order", "]"}]}]}], 
   "]"}]}]], "Input",ExpressionUUID->"6626aca3-386b-4783-8891-1124c8fce2a9"],

Cell[TextData[{
 "A simpler and more general version based on the Dt builtin of ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"],
 " Arguments of Power are wrapped with Scalar. Note however that this new \
version could be slower..."
}], "Text",ExpressionUUID->"7ae1966a-e9d5-44c8-a1b7-2c4e04d80d8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FaadiBruno", "[", 
    RowBox[{
     RowBox[{"function_", "[", "args__", "]"}], ",", "order_"}], "]"}], ":=", 
   
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Unique", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Length", "[", 
           RowBox[{"{", "args", "}"}], "]"}], "}"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "@", 
          RowBox[{"Nest", "[", 
           RowBox[{"Dt", ",", 
            RowBox[{"function", "@@", "vars"}], ",", "order"}], "]"}]}], "/.", 
         RowBox[{"Dt", "\[Rule]", "Perturbation"}]}], "/.", 
        RowBox[{
         RowBox[{"Power", "[", 
          RowBox[{"x_Perturbation", ",", "n_"}], "]"}], ":>", 
         RowBox[{
          RowBox[{"Scalar", "[", "x", "]"}], "^", "n"}]}]}], "/.", 
       RowBox[{
        RowBox[{
         RowBox[{"g_", "?", "ScalarFunctionQ"}], "@@", "vars"}], ":>", 
        RowBox[{"g", "[", "args", "]"}]}]}], "/.", 
      RowBox[{"Inner", "[", 
       RowBox[{"IndexRule", ",", "vars", ",", 
        RowBox[{"{", "args", "}"}], ",", "List"}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"122f61eb-589f-432b-91e7-385695b341b7"],

Cell["Tests:", "Text",ExpressionUUID->"288386c6-89c7-4306-9ab9-cd1489563599"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FaadiBruno", "[", 
    RowBox[{
     RowBox[{"function", "[", "x", "]"}], ",", "7"}], "]"}], "-", 
   RowBox[{"FaadiBruno0", "[", 
    RowBox[{
     RowBox[{"function", "[", "x", "]"}], ",", "7"}], "]"}]}], "//", 
  "NoScalar"}]], \
"Input",ExpressionUUID->"297e1595-6cfb-4710-a9aa-13990273e0f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{"Perturbation", "[", 
        RowBox[{"Perturbation", "[", 
         RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}], 
     "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "7"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"35", " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"21", " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"7", " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{"Perturbation", "[", 
        RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}], 
    "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"35", " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "3"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "4"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"21", " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "2"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "5"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"7", " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "1"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "6"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"105", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"70", " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], "2"], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"105", " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"105", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "2"}], "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "3"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"70", " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "1"}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "3"}], "]"}], "2"], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"105", " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "1"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "2"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "4"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"21", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "5"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"105", " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "3"], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "4", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"210", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "4", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "3"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "4", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"105", " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "1"}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "2"}], "]"}], "3"], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "4", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"210", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "2"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "3"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "4", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"35", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "3"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "4"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "4", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"105", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "2"], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "5", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"35", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "4"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "5", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"105", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "2"}], "]"}], "2"], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "5", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"35", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "4"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "3"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "5", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "5"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "6", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{"21", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "5"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "2"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "6", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "7"], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "7", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "7"], " ", 
   RowBox[{
    SuperscriptBox["function", 
     TagBox[
      RowBox[{"(", "7", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", 
    "]"}]}]}]], \
"Output",ExpressionUUID->"e9399bb9-c048-45ff-9080-f8b459278b87"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FaadiBruno", "[", 
     RowBox[{
      RowBox[{"x", "^", "5"}], ",", "4"}], "]"}], "-", 
    RowBox[{"FaadiBruno0", "[", 
     RowBox[{
      RowBox[{"x", "^", "5"}], ",", "4"}], "]"}]}], "//", "NoScalar"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"fe5f5f0f-2e49-4c5c-8711-fb8cd567fcac"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "5"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Log",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Log,
      Editable->False], "[", "x", "]"}], "4"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "5", "]"}], "4"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Log",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Log,
      Editable->False], "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "5", "]"}], "3"], " ", 
   RowBox[{"Perturbation", "[", "x", "]"}]}], "+", 
  RowBox[{"20", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Log",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Log,
      Editable->False], "[", "x", "]"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "5", "]"}], "3"], " ", 
   RowBox[{"Perturbation", "[", "x", "]"}]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "5", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "2"]}], "+", 
  RowBox[{"108", " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "5", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "2"]}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Log",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Log,
      Editable->False], "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "5", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "2"]}], "+", 
  RowBox[{"188", " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Perturbation", "[", "5", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "3"]}], "+", 
  RowBox[{"240", " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", "5", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "3"]}], "+", 
  RowBox[{"120", " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "4"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "5"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Log",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Log,
      Editable->False], "[", "x", "]"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "5", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "5", "]"}], "]"}]}], "+", 
  RowBox[{"24", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", "5", "]"}], " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "5", "]"}], "]"}]}], "+", 
  RowBox[{"60", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Log",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Log,
      Editable->False], "[", "x", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", "5", "]"}], " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "5", "]"}], "]"}]}], "+", 
  RowBox[{"54", " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "5", "]"}], "]"}]}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "5", "]"}], "]"}]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "5"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Log",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Log,
      Editable->False], "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "5", "]"}], "]"}], "2"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "5", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"30", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Log",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Log,
      Editable->False], "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "5", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"108", " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"Perturbation", "[", "5", "]"}], " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"240", " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", "5", "]"}], " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"360", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "5", "]"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"30", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "5", "]"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"60", " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "5"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Log",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Log,
      Editable->False], "[", "x", "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", "5", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "5", "]"}], "]"}], "]"}]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "5", "]"}], "]"}], "]"}]}], "+", 
  RowBox[{"20", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "5", "]"}], "]"}], "]"}]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"Perturbation", "[", "5", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}]}], "+", 
  RowBox[{"20", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", "5", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}]}], "+", 
  RowBox[{"80", " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"Perturbation", "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "5"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Log",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Log,
     Editable->False], "[", "x", "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", "5", "]"}], "]"}], "]"}], "]"}]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"Perturbation", "[", "x", "]"}], "]"}], "]"}], "]"}]}], "-", 
  RowBox[{"120", " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "4"]}], "-", 
  RowBox[{"360", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "1"}], "]"}], "2"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "2"}], "]"}]}], "-", 
  RowBox[{"60", " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox[
    RowBox[{"Perturbation", "[", 
     RowBox[{"x", ",", "2"}], "]"}], "2"]}], "-", 
  RowBox[{"80", " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "1"}], "]"}], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "3"}], "]"}]}], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"x", ",", "4"}], 
    "]"}]}]}]], \
"Output",ExpressionUUID->"faf6827c-4ca2-469c-9322-805203f13b06"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3. Perturbation structure",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subsection",ExpressionUUID->"8d3833b8-57e0-4d6c-b35e-7d109792be62"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"RuleDelayed", "::", "rhs"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"26ca5e0a-0944-4672-ae5e-d842bcbbae12"],

Cell[CellGroupData[{

Cell["3.1. DefTensorPerturbation", \
"Subsubsection",ExpressionUUID->"77f1af45-42e6-4384-9d72-bc4671e98e50"],

Cell["\<\
Given a tensor, we define its perturbation, with the same index structure and \
tensor properties:\
\>", "Text",ExpressionUUID->"962ae1d7-a47c-48c5-882c-91eea515994d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"makepattern", "[", "a_Symbol", "]"}], ":=", "a_Symbol"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makepattern", "[", 
    RowBox[{"-", "a_Symbol"}], "]"}], ":=", 
   RowBox[{"-", "a_Symbol"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b62bbb72-de01-4138-a83b-af5da0cd796f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefTensorPerturbation", "]"}], "=", 
   RowBox[{"Options", "[", "DefTensor", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefTensorPerturbation", "[", 
    RowBox[{
     RowBox[{"pert_", "[", 
      RowBox[{
       RowBox[{"LI", "[", "_", "]"}], ",", "inds___"}], "]"}], ",", 
     RowBox[{"tensor_", "[", "inds___", "]"}], ",", "args__"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"prot", ",", 
       RowBox[{"pinds", "=", 
        RowBox[{"makepattern", "/@", 
         RowBox[{"{", "inds", "}"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"DefTensor", "[", 
       RowBox[{
        RowBox[{"pert", "[", 
         RowBox[{
          RowBox[{"LI", "[", "\"\<order\>\"", "]"}], ",", "inds"}], "]"}], ",",
         "args"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
       RowBox[{"pert", ",", "Null", ",", 
        RowBox[{"{", "tensor", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"prot", "=", 
       RowBox[{"Unprotect", "[", 
        RowBox[{"tensor", ",", "pert"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"tensor", "/:", 
       RowBox[{"Perturbation", "[", 
        RowBox[{
         RowBox[{"tensor", "@@", "pinds"}], ",", 
         RowBox[{"Optional", "[", "order_Integer", "]"}]}], "]"}], ":=", 
       RowBox[{"pert", "[", 
        RowBox[{
         RowBox[{"LI", "[", "order", "]"}], ",", "inds"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"pert", "[", 
        RowBox[{
         RowBox[{"LI", "[", "0", "]"}], ",", "indices___"}], "]"}], ":=", 
       RowBox[{"tensor", "[", "indices", "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"pert", "/:", 
       RowBox[{"PerturbationOrder", "[", 
        RowBox[{"pert", "[", 
         RowBox[{
          RowBox[{"LI", "[", "order_", "]"}], ",", "indices___"}], "]"}], 
        "]"}], ":=", "order"}], ";", "\[IndentingNewLine]", 
      RowBox[{"pert", "/:", 
       RowBox[{"Perturbation", "[", 
        RowBox[{
         RowBox[{"pert", "[", 
          RowBox[{
           RowBox[{"LI", "[", "order_", "]"}], ",", 
           RowBox[{"Sequence", "@@", "pinds"}]}], "]"}], ",", "n_."}], "]"}], 
       ":=", 
       RowBox[{"pert", "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{"order", "+", "n"}], "]"}], ",", "inds"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", 
       RowBox[{"Evaluate", "[", "prot", "]"}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefTensorPerturbation", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DefTensorPerturbation", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"2a4d1d6e-1d2d-4745-84cb-1567a3089981"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. DefMetricPerturbation", \
"Subsubsection",ExpressionUUID->"7481155d-0660-48dc-8d7f-3ad667786d25"],

Cell["\<\
Jose: It is rather absurd that DefTensorPerturbation requires indices but \
DefMetricPerturbation does not.\
\>", "Text",ExpressionUUID->"e451b2aa-aa6d-4b97-ad89-28f1d4be3d05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DefMetricPerturbation"}]], \
"Input",ExpressionUUID->"da0f41fd-1230-40c9-a981-ba17ee70f90f"],

Cell[BoxData["\<\"DefMetricPerturbation[metric, pert, param] constructs a \
number of definitions for the perturbation of the given metric, which must \
exist already. A tensor pert[LI[order], -a, -b] is defined on the vbundle of \
the metric, and the parameter param will be defined and used to expand the \
perturbed expressions. DefMetricPerturbation[metric, pert] uses a default \
name for the parameter.\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info1033728976442-2355034",ExpressionUUID->"7dff76f8-233a-4c5b-a1ce-\
429888fcc4dd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefMetricPerturbation", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"PrintAs", "\[Rule]", "Identity"}], "}"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9d8ee76b-7774-4bd3-8bd4-457f27524fc8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefMetricPerturbation", "[", 
    RowBox[{"metric_", ",", "pert_Symbol", ",", 
     RowBox[{"param_Symbol", ":", "Automatic"}], ",", 
     RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "vbundle", ",", "manifold", ",", "indices", ",", "covd", ",", 
       "christoffel", ",", "riemann", ",", "ricci", ",", "ricciscalar", ",", 
       "einstein", ",", "weyl", ",", "tfricci", ",", "kretschmann", ",", 
       "pa"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", "pa", "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", "PrintAs", "}"}], "/.", 
         RowBox[{"CheckOptions", "[", "options", "]"}]}], "/.", 
        RowBox[{"Options", "[", "DefMetricPerturbation", "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Check", " ", "of", " ", "metric"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"MetricQ", "[", "metric", "]"}]}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"DefMetricPerturbation", "::", "unknown"}], 
           ",", "\"\<metric\>\"", ",", "metric"}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Define", " ", "parameter", " ", "if", " ", "it", " ", "does", " ", 
        "not", " ", "exist", " ", "yet"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"ParameterQ", "[", "param", "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"param", "===", "Automatic"}], ",", "\[IndentingNewLine]", 
          RowBox[{"DefParameter", "[", 
           RowBox[{
            RowBox[{"GiveSymbol", "[", 
             RowBox[{"PerturbationParameter", ",", "metric"}], "]"}], ",", 
            RowBox[{"PrintAs", "\[RuleDelayed]", 
             RowBox[{"GiveOutputString", "[", 
              RowBox[{"PerturbationParameter", ",", "metric"}], "]"}]}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"DefParameter", "[", "param", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"vbundle", "=", 
       RowBox[{"VBundleOfMetric", "[", "metric", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"manifold", "=", 
       RowBox[{"BaseOfVBundle", "[", "vbundle", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"indices", "=", 
       RowBox[{"GetIndicesOfVBundle", "[", 
        RowBox[{"vbundle", ",", "4"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DefTensorPerturbation", "[", 
       RowBox[{
        RowBox[{"pert", "[", 
         RowBox[{
          RowBox[{"LI", "[", "\"\<order\>\"", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", 
        RowBox[{"metric", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", 
        RowBox[{"DependenciesOfTensor", "[", "metric", "]"}], ",", 
        RowBox[{"Symmetric", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
        RowBox[{"PrintAs", "\[Rule]", "pa"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Store", " ", "perturbation", " ", "structure", " ", "in", " ", 
        "global", " ", "variables"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"covd", "=", 
       RowBox[{"CovDOfMetric", "[", "metric", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"christoffel", "=", 
       RowBox[{"Christoffel", "[", "covd", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"riemann", "=", 
       RowBox[{"Riemann", "[", "covd", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ricci", "=", 
       RowBox[{"Ricci", "[", "covd", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ricciscalar", "=", 
       RowBox[{"RicciScalar", "[", "covd", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"einstein", "=", 
       RowBox[{"Einstein", "[", "covd", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"weyl", "=", 
       RowBox[{"Weyl", "[", "covd", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"tfricci", "=", 
       RowBox[{"TFRicci", "[", "covd", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"kretschmann", "=", 
       RowBox[{"Kretschmann", "[", "covd", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"$PerturbationParameter", "=", "param"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Define", " ", "perturbation", " ", "definitions"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Unprotect", "[", 
       RowBox[{"Perturbation", ",", "GeneralPerturbation"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{
       "DefMetricPerturbation", ",", "\"\<Beginning\>\"", ",", "metric", ",", 
        "pert", ",", "param"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "=", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"b", "=", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"c", "=", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", 
          RowBox[{"d", "=", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"DefGenPertInvMetric", "[", 
          RowBox[{"vbundle", ",", 
           RowBox[{"metric", "[", 
            RowBox[{"a", ",", "b"}], "]"}], ",", "pert"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"DefGenPertDet", "[", 
          RowBox[{"vbundle", ",", "metric", ",", "pert"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"DefGenPertInvMetric", "[", 
          RowBox[{"vbundle", ",", 
           RowBox[{"metric", "[", 
            RowBox[{"a", ",", "b"}], "]"}], ",", "pert"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"DefGenPertChristoffel", "[", 
          RowBox[{"vbundle", ",", "covd", ",", "pert", ",", 
           RowBox[{"christoffel", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "b"}], ",", 
             RowBox[{"-", "c"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"DefGenPertRiemannFromChristoffel", "[", 
          RowBox[{"vbundle", ",", "covd", ",", "christoffel", ",", 
           RowBox[{"riemann", "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}], ",", 
             RowBox[{"-", "c"}], ",", "d"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"DefGenPertRiemann", "[", 
          RowBox[{"vbundle", ",", "covd", ",", "pert", ",", 
           RowBox[{"riemann", "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}], ",", 
             RowBox[{"-", "c"}], ",", "d"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"DefGenPertRicci", "[", 
          RowBox[{"vbundle", ",", "covd", ",", "pert", ",", "riemann", ",", 
           RowBox[{"ricci", "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"DefGenPertRicciScalar", "[", 
          RowBox[{
          "vbundle", ",", "metric", ",", "ricci", ",", "ricciscalar"}], "]"}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"DefGenPertEinstein", "[", 
          RowBox[{
          "vbundle", ",", "metric", ",", "ricci", ",", "ricciscalar", ",", 
           RowBox[{"einstein", "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"DefGenPertWeyl", "[", 
          RowBox[{"weyl", "[", 
           RowBox[{
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "d"}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"DefGenPertTFRicci", "[", 
          RowBox[{"tfricci", "[", 
           RowBox[{
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "b"}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"DefGenPertKretschmann", "[", 
          RowBox[{"vbundle", ",", "metric", ",", "riemann", ",", 
           RowBox[{"kretschmann", "[", "]"}]}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{
       "DefMetricPerturbation", ",", "\"\<End\>\"", ",", "metric", ",", 
        "pert", ",", "param"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", 
       RowBox[{"Perturbation", ",", "GeneralPerturbation"}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefMetricPerturbation", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DefMetricPerturbation", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f9a91e79-7a4b-4149-baf4-8b995472efbe"],

Cell["Store the perturbation parameters of the various metrics:", \
"Text",ExpressionUUID->"5d783442-a803-4c19-bfa4-065651c36661"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PerturbationParameter", "[", 
    RowBox[{"metric_", "?", "MetricQ"}], "]"}], ":=", 
   RowBox[{"GiveSymbol", "[", 
    RowBox[{"PerturbationParameter", ",", "metric"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PerturbationParameter", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Protect", "[", "PerturbationParameter", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAsCharacter", "[", "PerturbationParameter", "]"}], 
   "=", "\"\<\[CurlyEpsilon]\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"52de2f38-1321-4a2e-9ee8-6cb843025c41"],

Cell["Metric perturbations:", \
"Text",ExpressionUUID->"f9e94d80-bc7e-40f7-baf4-463409953d62"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "IndexForm", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IndexForm", "[", 
    RowBox[{"LI", "[", "x_", "]"}], "]"}], ":=", 
   RowBox[{"ColorString", "[", 
    RowBox[{
     RowBox[{"ToString", "[", "x", "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "IndexForm", "]"}], 
  ";"}]}], "Input",ExpressionUUID->"8a67637c-c5bc-43df-8595-ea46a1567a88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndexForm", "[", 
  RowBox[{"LI", "[", "1", "]"}], 
  "]"}]], "Input",ExpressionUUID->"4fec912f-d1a9-4859-8b53-55a4e3f9285b"],

Cell[BoxData["\<\"\\!\\(\\*StyleBox[\\\"1\\\",FontColor->RGBColor[0., 0., \
1.]]\\)\"\>"], "Output",ExpressionUUID->"4a2e9f16-a761-4f5b-8d8e-32152906192f"]
}, Open  ]],

Cell["Additional object:", \
"Text",ExpressionUUID->"a5333341-edc0-4bf7-943a-cdcdbd71e713"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ThreePert", "[", 
    RowBox[{"covd_", ",", "pert_"}], "]"}], "[", 
   RowBox[{
    RowBox[{"LI", "[", "order_", "]"}], ",", "a_", ",", "b_", ",", "c_"}], 
   "]"}], ":=", 
  RowBox[{
   RowBox[{"1", "/", "2"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"covd", "[", "c", "]"}], "[", 
      RowBox[{"pert", "[", 
       RowBox[{
        RowBox[{"LI", "[", "order", "]"}], ",", "a", ",", "b"}], "]"}], "]"}],
      "+", 
     RowBox[{
      RowBox[{"covd", "[", "b", "]"}], "[", 
      RowBox[{"pert", "[", 
       RowBox[{
        RowBox[{"LI", "[", "order", "]"}], ",", "a", ",", "c"}], "]"}], "]"}],
      "-", 
     RowBox[{
      RowBox[{"covd", "[", "a", "]"}], "[", 
      RowBox[{"pert", "[", 
       RowBox[{
        RowBox[{"LI", "[", "order", "]"}], ",", "b", ",", "c"}], "]"}], 
      "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e871be5e-9345-4c1e-a2eb-469b46aecc97"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. Perturbation", \
"Subsubsection",ExpressionUUID->"189bab46-9f95-4b9f-b2ec-ba6143070593"],

Cell[TextData[{
 "Main perturbation function, defined as inert-head. That means that the \
tensorial properties of ",
 StyleBox["Perturbation[",
  FontFamily->"Courier"],
 StyleBox["expr",
  FontFamily->"Courier",
  FontSlant->"Italic"],
 StyleBox["]",
  FontFamily->"Courier"],
 " are exactly those of ",
 StyleBox["expr",
  FontFamily->"Courier",
  FontSlant->"Italic"],
 ". The density definition must be given independently:"
}], "Text",ExpressionUUID->"801be4c8-0cb5-4392-a1ad-3b344e245a37"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DefInertHead", 
  "]"}]], "Input",ExpressionUUID->"2b824070-a5c5-4cd7-9cc6-3c2cf8251767"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LinearQ", "\[Rule]", "False"}], ",", 
   RowBox[{"ContractThrough", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"Master", "\[Rule]", "Null"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", 
   RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
   
   RowBox[{"DefInfo", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"inert head\"\>", ",", "\<\"\"\>"}], "}"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"5f6d6c43-6e10-44a6-bea7-b704f116c6ca"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Define", " ", "linear", " ", "inert", " ", "head"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"DefInertHead", "[", 
     RowBox[{"Perturbation", ",", 
      RowBox[{"PrintAs", "->", "\"\<\[EmptyUpTriangle]\>\""}], ",", 
      RowBox[{"DefInfo", "\[Rule]", "False"}], ",", 
      RowBox[{"ContractThrough", "\[Rule]", 
       RowBox[{"{", "delta", "}"}]}], ",", 
      RowBox[{"LinearQ", "\[Rule]", "True"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Perturbation", " ", "has", " ", "two", " ", "arguments"}], ",", 
     " ", 
     RowBox[{
     "but", " ", "the", " ", "second", " ", "defaults", " ", "to", " ", 
      "1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Default", "[", 
      RowBox[{"Perturbation", ",", "2"}], "]"}], ":=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Perturbation", "[", 
      RowBox[{"expr_", ",", "0"}], "]"}], ":=", "expr"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Perturbation", "[", 
      RowBox[{"expr_", ",", "1"}], "]"}], ":=", 
     RowBox[{"Perturbation", "[", "expr", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Perturbation", " ", "does", " ", "not", " ", "affect", " ", "the", " ", 
     "density", " ", "character"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"WeightOf", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{"expr_", ",", "_."}], "]"}], "]"}], "^:=", 
     RowBox[{"WeightOf", "[", "expr", "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c4721e3a-c196-48f4-a8d1-9d66ca144c0b"],

Cell["\<\
It acts as a derivative and commutes with covariant partial derivatives or \
derivatives of scalars. As suggested by Teake, we block perturbations on \
derivatives of scalar densities:\
\>", "Text",ExpressionUUID->"c170461d-a19f-4e8c-8d19-77acd9e2a977"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{
     RowBox[{"_", "?", "ConstantQ"}], ",", "_."}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{
     RowBox[{"delta", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], ",", "_."}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a_"}], "]"}], "[", "expr_", "]"}], ",", "n_."}], "]"}], ":=", 
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"expr", ",", "n"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Perturbation", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cd_Symbol", "?", "CovDQ"}], "[", 
        RowBox[{"-", "a_"}], "]"}], "[", 
       RowBox[{"expr_", "?", "ScalarQ"}], "]"}], ",", "n_."}], "]"}], "/;", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"WeightOf", "@", "expr"}], ",", 
      RowBox[{"WeightedWithBasis", "@", "cd"}]}], "]"}]}], ":=", 
   RowBox[{
    RowBox[{"cd", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"expr", ",", "n"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ParamD", "[", "ps__", "]"}], "[", "expr_", "]"}], ",", "n_."}],
     "]"}], ":=", 
   RowBox[{
    RowBox[{"ParamD", "[", "ps", "]"}], "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"expr", ",", "n"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{
     RowBox[{"OverDot", "[", "expr_", "]"}], ",", "n_."}], "]"}], ":=", 
   RowBox[{"OverDot", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"expr", ",", "n"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{
     RowBox[{"Scalar", "[", "expr_", "]"}], ",", "n_."}], "]"}], ":=", 
   RowBox[{"Scalar", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"expr", ",", "n"}], "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"17e295b2-2bd2-43f0-8ba9-5aaf65d632aa"],

Cell["\<\
It does not commute with covariant derivatives of general expressions:\
\>", "Text",ExpressionUUID->"fc1e2d01-a75c-4c31-9ef0-aea1b673fb96"],

Cell["Generalized Leibniz rule:", \
"Text",ExpressionUUID->"52638186-69d5-45d9-95d9-74946835140d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{"product_Times", ",", "n_."}], "]"}], ":=", 
   RowBox[{"LeibnizDistribute", "[", 
    RowBox[{"Perturbation", ",", "n", ",", "product", ",", "Plus"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e04cd0ca-3d28-4639-a517-3756db1e3193"],

Cell["Extend to other algebra products:", \
"Text",ExpressionUUID->"4a3c2527-c850-48fd-bc92-357394d5d945"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{
     RowBox[{"product", ":", 
      RowBox[{
       RowBox[{"_", "?", "ProductQ"}], "[", "__", "]"}]}], ",", "n_."}], 
    "]"}], ":=", 
   RowBox[{"LeibnizDistribute", "[", 
    RowBox[{"Perturbation", ",", "n", ",", "product", ",", "Plus"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"90caadec-e5dd-41ca-8c10-58cf455536aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Perturbation", "/:", 
   RowBox[{"Grade", "[", 
    RowBox[{
     RowBox[{"Perturbation", "[", 
      RowBox[{"expr_", ",", "n_."}], "]"}], ",", "prod_"}], "]"}], ":=", 
   RowBox[{"Grade", "[", 
    RowBox[{"expr", ",", "prod"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2cc6d86f-b8c3-437f-8a54-339c3186341e"],

Cell["Perturbation of a scalar function:", \
"Text",ExpressionUUID->"53e1fc5f-328f-4855-9109-f4861e4833c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{
     RowBox[{"expr", ":", 
      RowBox[{
       RowBox[{"_", "?", "ScalarFunctionQ"}], "[", "__", "]"}]}], ",", 
     "order_."}], "]"}], ":=", 
   RowBox[{"FaadiBruno", "[", 
    RowBox[{"expr", ",", "order"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e8272772-f340-4658-864e-8ce4a4d532ec"],

Cell[TextData[{
 "Formatting (note the redundant check ?InertHeadQ to avoid problems with the \
new definition-ordering rules in ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "6):"
}], "Text",ExpressionUUID->"bce3f36e-422c-4a5b-839a-b4d39e094506"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Perturbation", "?", "xAct`xTensor`Private`HeldInertHeadQ"}], "[",
       "expr_", "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{"Perturbation", "[", "expr", "]"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PrintAs", "[", "Perturbation", "]"}], ",", "\"\<[\>\"", ",", 
        
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"expr", ",", "StandardForm"}], "]"}], ",", "\"\<]\>\""}], 
       "}"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f3d237bd-9950-4fc3-9e05-2d9804265101"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Perturbation", "?", "xAct`xTensor`Private`HeldInertHeadQ"}], "[", 
      RowBox[{"expr_", ",", "n_"}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{"Perturbation", "[", 
      RowBox[{"expr", ",", "n"}], "]"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{
          RowBox[{"PrintAs", "[", "Perturbation", "]"}], ",", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}], ",", "\"\<[\>\"", ",", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"expr", ",", "StandardForm"}], "]"}], ",", "\"\<]\>\""}], 
       "}"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5285736d-3ff9-4432-9437-af29e9e53855"],

Cell["Perturbations are joined together:", \
"Text",ExpressionUUID->"c3a269b0-6999-43c3-b9a5-50f2464a48c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Perturbation", "[", 
    RowBox[{
     RowBox[{"Perturbation", "[", 
      RowBox[{"expr_", ",", "n_."}], "]"}], ",", "m_."}], "]"}], ":=", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"n", "+", "m"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1774ab3a-c174-4232-a979-c5d72c430c2b"],

Cell["Finally:", \
"Text",ExpressionUUID->"fe2673d0-d596-43e2-8805-dd157e0dcdf4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Perturbation", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Perturbation", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"dabf073c-1c7f-4aef-bb89-cadc901612e3"],

Cell["Examples:", \
"Text",ExpressionUUID->"1975c8dc-fcab-4c20-9c7e-f629aa0f91ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{"a", " ", "b", " ", "c"}], ",", "10"}], 
  "]"}]], "Input",ExpressionUUID->"70cbe2bf-ae36-40b9-9300-d33bc52adaea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"90", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 8],
    Editable->False]}], "+", 
  RowBox[{"10", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 9],
    Editable->False]}], "+", 
  RowBox[{"10", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 9],
    Editable->False]}], "+", 
  RowBox[{"b", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 10],
    Editable->False]}], "+", 
  RowBox[{"360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 2],
    Editable->False]}], "+", 
  RowBox[{"45", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 2],
    Editable->False]}], "+", 
  RowBox[{"840", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 3],
    Editable->False]}], "+", 
  RowBox[{"120", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 3],
    Editable->False]}], "+", 
  RowBox[{"1260", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 4],
    Editable->False]}], "+", 
  RowBox[{"210", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 4],
    Editable->False]}], "+", 
  RowBox[{"1260", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 5],
    Editable->False]}], "+", 
  RowBox[{"252", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 5],
    Editable->False]}], "+", 
  RowBox[{"840", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 6],
    Editable->False]}], "+", 
  RowBox[{"210", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 6],
    Editable->False]}], "+", 
  RowBox[{"360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 7],
    Editable->False]}], "+", 
  RowBox[{"120", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 7],
    Editable->False]}], "+", 
  RowBox[{"90", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 8],
    Editable->False]}], "+", 
  RowBox[{"45", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 8],
    Editable->False]}], "+", 
  RowBox[{"10", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 9],
    Editable->False]}], "+", 
  RowBox[{"10", " ", "a", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 9],
    Editable->False]}], "+", 
  RowBox[{"a", " ", "c", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 10],
    Editable->False]}], "+", 
  RowBox[{"360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 2],
    Editable->False]}], "+", 
  RowBox[{"45", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 2],
    Editable->False]}], "+", 
  RowBox[{"1260", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 2],
    Editable->False]}], "+", 
  RowBox[{"2520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 2],
    Editable->False]}], "+", 
  RowBox[{"3150", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 2],
    Editable->False]}], "+", 
  RowBox[{"2520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 2],
    Editable->False]}], "+", 
  RowBox[{"1260", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 2],
    Editable->False]}], "+", 
  RowBox[{"360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 2],
    Editable->False]}], "+", 
  RowBox[{"45", " ", "a", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 2],
    Editable->False]}], "+", 
  RowBox[{"840", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 3],
    Editable->False]}], "+", 
  RowBox[{"120", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 3],
    Editable->False]}], "+", 
  RowBox[{"2520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 3],
    Editable->False]}], "+", 
  RowBox[{"4200", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 3],
    Editable->False]}], "+", 
  RowBox[{"4200", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 3],
    Editable->False]}], "+", 
  RowBox[{"2520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 3],
    Editable->False]}], "+", 
  RowBox[{"840", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 3],
    Editable->False]}], "+", 
  RowBox[{"120", " ", "a", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 3],
    Editable->False]}], "+", 
  RowBox[{"1260", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 4],
    Editable->False]}], "+", 
  RowBox[{"210", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 4],
    Editable->False]}], "+", 
  RowBox[{"3150", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 4],
    Editable->False]}], "+", 
  RowBox[{"4200", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 4],
    Editable->False]}], "+", 
  RowBox[{"3150", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 4],
    Editable->False]}], "+", 
  RowBox[{"1260", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 4],
    Editable->False]}], "+", 
  RowBox[{"210", " ", "a", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 4],
    Editable->False]}], "+", 
  RowBox[{"1260", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 5],
    Editable->False]}], "+", 
  RowBox[{"252", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 5],
    Editable->False]}], "+", 
  RowBox[{"2520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 5],
    Editable->False]}], "+", 
  RowBox[{"2520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 5],
    Editable->False]}], "+", 
  RowBox[{"1260", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 5],
    Editable->False]}], "+", 
  RowBox[{"252", " ", "a", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 5],
    Editable->False]}], "+", 
  RowBox[{"840", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 6],
    Editable->False]}], "+", 
  RowBox[{"210", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 6],
    Editable->False]}], "+", 
  RowBox[{"1260", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 6],
    Editable->False]}], "+", 
  RowBox[{"840", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 6],
    Editable->False]}], "+", 
  RowBox[{"210", " ", "a", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 6],
    Editable->False]}], "+", 
  RowBox[{"360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 7],
    Editable->False]}], "+", 
  RowBox[{"120", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 7],
    Editable->False]}], "+", 
  RowBox[{"360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 7],
    Editable->False]}], "+", 
  RowBox[{"120", " ", "a", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 7],
    Editable->False]}], "+", 
  RowBox[{"90", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 8],
    Editable->False]}], "+", 
  RowBox[{"45", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 8],
    Editable->False]}], "+", 
  RowBox[{"45", " ", "a", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 8],
    Editable->False]}], "+", 
  RowBox[{"10", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "a", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 9],
    Editable->False]}], "+", 
  RowBox[{"10", " ", "a", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "b", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 9],
    Editable->False]}], "+", 
  RowBox[{"a", " ", "b", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "c", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`c, 10],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"ce20153e-9770-4c92-ad4e-88712e46610d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "5"}], 
  "]"}]], "Input",ExpressionUUID->"1710e285-116a-4810-9b09-72aabba2e74f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox["Cos",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Cos,
     Editable->False], "[", "x", "]"}], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 5],
    Editable->False]}], "-", 
  RowBox[{"10", " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Cos",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Cos,
     Editable->False], "[", "x", "]"}], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 3],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[
         RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPert`Perturbation[xAct`xPert`Private`x],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      xAct`xPert`Perturbation[xAct`xPert`Private`x]],
     Editable->False], "2"]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox["Cos",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Cos,
     Editable->False], "[", "x", "]"}], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[
         RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPert`Perturbation[xAct`xPert`Private`x],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      xAct`xPert`Perturbation[xAct`xPert`Private`x]],
     Editable->False], "5"]}], "-", 
  RowBox[{"15", " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Cos",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Cos,
     Editable->False], "[", "x", "]"}], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[
         RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      xAct`xPert`Perturbation[xAct`xPert`Private`x, 2]],
     Editable->False], "2"]}], "-", 
  RowBox[{"10", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 3],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Sin,
     Editable->False], "[", "x", "]"}]}], "-", 
  RowBox[{"5", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 4],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Sin,
     Editable->False], "[", "x", "]"}]}], "+", 
  RowBox[{"10", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[
         RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPert`Perturbation[xAct`xPert`Private`x],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      xAct`xPert`Perturbation[xAct`xPert`Private`x]],
     Editable->False], "3"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Sin,
     Editable->False], "[", "x", 
    "]"}]}]}]], \
"Output",ExpressionUUID->"7d008be7-ac6c-47e3-924f-1e3f0e6fcd45"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", "3"}], "]"}], ",", "6"}], 
  "]"}]], "Input",ExpressionUUID->"5fbd100e-a299-42d8-8f45-bb82a807fa47"],

Cell[BoxData[
 RowBox[{
  RowBox[{"360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 3],
    Editable->False]}], "+", 
  RowBox[{"90", " ", "x", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 4],
    Editable->False]}], "+", 
  RowBox[{"36", " ", "x", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 5],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 6],
    Editable->False]}], "+", 
  RowBox[{"90", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 4],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[
         RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPert`Perturbation[xAct`xPert`Private`x],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      xAct`xPert`Perturbation[xAct`xPert`Private`x]],
     Editable->False], "2"]}], "+", 
  RowBox[{"90", " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[
         RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      xAct`xPert`Perturbation[xAct`xPert`Private`x, 2]],
     Editable->False], "3"]}], "+", 
  RowBox[{"60", " ", "x", " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[
         RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPert`Perturbation[xAct`xPert`Private`x, 3],
        Editable->False], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[
      xAct`xPert`Perturbation[xAct`xPert`Private`x, 3]],
     Editable->False], 
    "2"]}]}]], "Output",ExpressionUUID->"f3b2546f-ab26-4700-8559-78c88ea17ce3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "6"}], 
  "]"}]], "Input",ExpressionUUID->"78379836-b2c0-45df-abde-b65f1d8a6354"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"45", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x, 3],
     Editable->False]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", 
     RowBox[{"5", "/", "2"}]]}]], "-", 
  FractionBox[
   RowBox[{"15", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x, 4],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["x", 
     RowBox[{"3", "/", "2"}]]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x, 5],
     Editable->False]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", 
     RowBox[{"3", "/", "2"}]]}]], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[xAct`xPert`Private`x, 6],
    Editable->False], 
   RowBox[{"2", " ", 
    SqrtBox["x"]}]], "+", 
  FractionBox[
   RowBox[{"45", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x, 4],
     Editable->False], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        InterpretationBox[
         StyleBox[
          RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPert`Perturbation[xAct`xPert`Private`x],
         Editable->False], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[
       xAct`xPert`Perturbation[xAct`xPert`Private`x]],
      Editable->False], "2"]}], 
   RowBox[{"8", " ", 
    SuperscriptBox["x", 
     RowBox[{"5", "/", "2"}]]}]], "-", 
  FractionBox[
   RowBox[{"75", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x, 3],
     Editable->False], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        InterpretationBox[
         StyleBox[
          RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPert`Perturbation[xAct`xPert`Private`x],
         Editable->False], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[
       xAct`xPert`Perturbation[xAct`xPert`Private`x]],
      Editable->False], "3"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["x", 
     RowBox[{"7", "/", "2"}]]}]], "+", 
  FractionBox[
   RowBox[{"1575", " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
     Editable->False], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        InterpretationBox[
         StyleBox[
          RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPert`Perturbation[xAct`xPert`Private`x],
         Editable->False], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[
       xAct`xPert`Perturbation[xAct`xPert`Private`x]],
      Editable->False], "4"]}], 
   RowBox[{"32", " ", 
    SuperscriptBox["x", 
     RowBox[{"9", "/", "2"}]]}]], "-", 
  FractionBox[
   RowBox[{"945", " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        InterpretationBox[
         StyleBox[
          RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPert`Perturbation[xAct`xPert`Private`x],
         Editable->False], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[
       xAct`xPert`Perturbation[xAct`xPert`Private`x]],
      Editable->False], "6"]}], 
   RowBox[{"64", " ", 
    SuperscriptBox["x", 
     RowBox[{"11", "/", "2"}]]}]], "-", 
  FractionBox[
   RowBox[{"675", " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        InterpretationBox[
         StyleBox[
          RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPert`Perturbation[xAct`xPert`Private`x],
         Editable->False], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[
       xAct`xPert`Perturbation[xAct`xPert`Private`x]],
      Editable->False], "2"], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        InterpretationBox[
         StyleBox[
          RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
         Editable->False], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[
       xAct`xPert`Perturbation[xAct`xPert`Private`x, 2]],
      Editable->False], "2"]}], 
   RowBox[{"16", " ", 
    SuperscriptBox["x", 
     RowBox[{"7", "/", "2"}]]}]], "+", 
  FractionBox[
   RowBox[{"45", " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        InterpretationBox[
         StyleBox[
          RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPert`Perturbation[xAct`xPert`Private`x, 2],
         Editable->False], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[
       xAct`xPert`Perturbation[xAct`xPert`Private`x, 2]],
      Editable->False], "3"]}], 
   RowBox[{"8", " ", 
    SuperscriptBox["x", 
     RowBox[{"5", "/", "2"}]]}]], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        InterpretationBox[
         StyleBox[
          RowBox[{"\[EmptyUpTriangle]", "[", "x", "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xPert`Perturbation[xAct`xPert`Private`x, 3],
         Editable->False], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[
       xAct`xPert`Perturbation[xAct`xPert`Private`x, 3]],
      Editable->False], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", 
     RowBox[{
     "3", "/", 
      "2"}]]}]]}]], \
"Output",ExpressionUUID->"1e49196c-676c-42d0-ba8a-247cd4e963e9"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "canonpert"}], 
   "=", "\"\<ToCanonical on Perturbation may incorrectly change index \
characters.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Private`Identify", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"expr_", ",", "n_."}], "]"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
         "UseMetricOnVBundle", "/.", "xAct`xTensor`Private`$TCOptions"}], 
         ")"}], "=!=", "None"}], ",", 
       RowBox[{"Message", "[", 
        RowBox[{"ToCanonical", "::", "canonpert"}], "]"}]}], "]"}], ";", 
     RowBox[{"xAct`xTensor`Private`addhead1A", "[", 
      RowBox[{
       RowBox[{"Perturbation", "[", 
        RowBox[{"expr", ",", "n"}], "]"}], ",", 
       RowBox[{
        RowBox[{"Perturbation", "[", 
         RowBox[{"#", ",", "n"}], "]"}], "&"}], ",", "expr"}], "]"}]}], 
    ")"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"869ddd90-5274-4d43-9968-62e900cae592"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4. Perturbed", \
"Subsubsection",ExpressionUUID->"a1b733eb-4bb2-4562-b6ec-8c23354d4a22"],

Cell[TextData[{
 "This function gives the total perturbation up to a given order. It is \
constructed in terms of ",
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 ", but could equally well be given in terms of ",
 StyleBox["GeneralPerturbation",
  FontFamily->"Courier"],
 ". Note the factor 1/n!"
}], "Text",ExpressionUUID->"f5992e1b-6b53-438e-83a8-32a85dbb31d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Perturbed"}]], \
"Input",ExpressionUUID->"df56e202-0a2d-4c83-988e-663492d0827a"],

Cell[BoxData["\<\"Perturbed[expr, n] returns the expansion of expr perturbed \
up to n-th order, using $PerturbationParameter.\"\>"], "Print", "PrintUsage",
 CellTags->
  "Info1453728976443-2355034",ExpressionUUID->"04231c6f-3e38-4a7a-a7f3-\
51f60db7bac3"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Perturbed", "[", 
    RowBox[{"expr_", ",", "order_Integer"}], "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"$PerturbationParameter", "^", "n"}], " ", 
      RowBox[{
       RowBox[{"Perturbation", "[", 
        RowBox[{"expr", ",", "n"}], "]"}], "/", 
       RowBox[{"n", "!"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "order"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Perturbed", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Perturbed", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"90d9e0f2-abea-4e0c-8051-bf008bb38f41"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.5. ExpandPerturbation", \
"Subsubsection",ExpressionUUID->"17657fa8-220f-4115-b7b5-79cba247b24f"],

Cell["\<\
This function knows nothing at the beginning. It must be trained little by \
little adding information to ExpandPerturbation1:\
\>", "Text",ExpressionUUID->"8b0d31a1-7378-4982-8ad5-557d127197b3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ExpandPerturbation", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SeparateMetric", "\[Rule]", "True"}], ",", 
     RowBox[{"OverDerivatives", "\[Rule]", "True"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbation", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"expr1_Perturbation", "\[RuleDelayed]", 
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{"expr1", ",", "options"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbation", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"tensor_Symbol", "?", "xTensorQ"}], ",", 
     RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"expr1", ":", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"tensor", "[", "___", "]"}], ",", "n_."}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{"expr1", ",", "options"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbation", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"list", ":", 
      RowBox[{"{", 
       RowBox[{"___Symbol", "?", "xTensorQ"}], "}"}]}], ",", 
     RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ExpandPerturbation", "[", 
       RowBox[{"#1", ",", "#2", ",", "options"}], "]"}], "&"}], ",", "expr", ",",
      "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"ExpandPerturbation", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ExpandPerturbation", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7ed9f0e1-a5b7-4833-8043-7ff905ecc245"],

Cell["\<\
General definition, in use when none of the particular definitions work:\
\>", "Text",ExpressionUUID->"2ab169dc-b21d-4665-baa8-b82947ce8d4e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ChangeCovD"}]], \
"Input",ExpressionUUID->"a880838c-3b7e-4822-b255-35d4df3d75c9"],

Cell[BoxData["\<\"ChangeCovD[expr, covd1, covd2] changes any instance of the \
covariant derivative covd1 in expr into a covariant derivative covd2 and \
Christoffel tensors relating both connections. The second argument is \
listable. ChangeCovD[expr, covd1] is converted into ChangeCovD[expr, covd1, \
PD]. ChangeCovD[expr] is converted into ChangeCovD[expr, $CovDs].\"\>"], \
"Print", "PrintUsage",
 CellTags->
  "Info1553728976443-2355034",ExpressionUUID->"74c3c6be-7b8e-4aa5-90c4-\
e1aa7ceabdec"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbation1", "[", 
    RowBox[{
     RowBox[{"Perturbation", "[", 
      RowBox[{"expr_", ",", "n_."}], "]"}], ",", "options___"}], "]"}], ":=", 
   
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sepmetric", ",", "od", ",", "tmp"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"sepmetric", ",", "od"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"SeparateMetric", ",", "OverDerivatives"}], "}"}], "/.", 
         RowBox[{"CheckOptions", "[", "options", "]"}]}], "/.", 
        RowBox[{"Options", "[", "ExpandPerturbation", "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Separate", " ", "metrics"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"Perturbation", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{"sepmetric", ",", 
           RowBox[{
            RowBox[{"SeparateMetric", "[", "]"}], "[", "expr", "]"}], ",", 
           "expr"}], "]"}], ",", "n"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Derivatives", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"od", ",", 
        RowBox[{"tmp", "=", 
         RowBox[{"tmp", "/.", 
          RowBox[{
           RowBox[{"expr1", ":", 
            RowBox[{"HoldPattern", "[", 
             RowBox[{"Perturbation", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"_Symbol", "?", "CovDQ"}], "[", "_", "]"}], "[", 
                 "_", "]"}], "|", 
                RowBox[{
                 RowBox[{"LieD", "[", "_", "]"}], "[", "_", "]"}], "|", 
                RowBox[{
                 RowBox[{"Bracket", "[", 
                  RowBox[{"_", ",", "_"}], "]"}], "[", "_", "]"}]}], ",", 
               "_."}], "]"}], "]"}]}], "\[RuleDelayed]", 
           RowBox[{"ExpandPerturbationDer", "[", "expr1", "]"}]}]}]}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Reexpand", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"tmp", "=!=", 
         RowBox[{"Perturbation", "[", 
          RowBox[{"expr", ",", "n"}], "]"}]}], ",", 
        RowBox[{"tmp", "=", 
         RowBox[{"ExpandPerturbation", "[", 
          RowBox[{"tmp", ",", "options"}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Return", " ", "result"}], " ", "*)"}], "\[IndentingNewLine]", 
      "tmp"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbation1", "[", 
    RowBox[{"expr_", ",", "options___"}], "]"}], ":=", "expr"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b348bee6-087a-480a-b09a-9fedc87d0471"],

Cell["For backwards compatibility:", \
"Text",ExpressionUUID->"d1de4994-509a-44a4-8d37-b850a4f59668"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GeneralPerturbation", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"order_", ":", "1"}]}], "]"}], ":=", 
   RowBox[{"ExpandPerturbation", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"expr", ",", "order"}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c5024849-9b7d-41c5-a3c5-9e6153a4ffe1"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.6. Perturbation of derivatives", \
"Subsubsection",ExpressionUUID->"e6269614-44e6-4adc-9e66-df248e3e624c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbationDer", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"cd_Symbol", "?", "CovDQ"}], "[", 
        RowBox[{"-", "a_"}], "]"}], "[", "expr_", "]"}], ",", "n_."}], "]"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"Perturbation", "[", 
      RowBox[{"expr", ",", "n"}], "]"}], "]"}], "+", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"vbundles", "=", 
        RowBox[{"VBundlesOfCovD", "[", "cd", "]"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"Plus", "@@", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"xAct`xTensor`Private`addChristoffel", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"-", "a"}]}], "]"}], ",", 
          RowBox[{"xAct`xTensor`Private`selecton", "[", 
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"FindFreeIndices", "[", "expr", "]"}], ",", "AIndexQ"}],
              "]"}], ",", "vbundles"}], "]"}]}], "]"}]}], "/.", 
       RowBox[{
        RowBox[{"expr1_", " ", 
         RowBox[{"xAct`xTensor`Private`CHR", "[", "indices__", "]"}]}], "\[RuleDelayed]", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"chr", "=", 
            RowBox[{
             RowBox[{"Christoffel", "[", "cd", "]"}], "[", "indices", "]"}]}],
            "}"}], ",", 
          RowBox[{
           RowBox[{"Perturbation", "[", 
            RowBox[{
             RowBox[{"expr1", " ", "chr"}], ",", "n"}], "]"}], "-", 
           RowBox[{"chr", " ", 
            RowBox[{"Perturbation", "[", 
             RowBox[{"expr1", ",", "n"}], "]"}]}]}]}], "]"}]}]}]}], "]"}], "+", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"basis", "=", 
         RowBox[{"WeightedWithBasis", "[", "cd", "]"}]}], ",", 
        RowBox[{"dummy", "=", 
         RowBox[{"DummyIn", "@", 
          RowBox[{"VBundleOfIndex", "[", "a", "]"}]}]}], ",", "weight"}], 
       "}"}], ",", 
      RowBox[{
       RowBox[{"weight", "=", 
        RowBox[{"WeightOf", "[", 
         RowBox[{"expr", ",", "basis"}], "]"}]}], ";", "\[IndentingNewLine]", 
       
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"weight", "===", "0"}], ",", "0", ",", 
         RowBox[{"weight", " ", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"chr", "=", 
              RowBox[{
               RowBox[{"Christoffel", "[", 
                RowBox[{"cd", ",", 
                 RowBox[{"xAct`xCoba`PDOfBasis", "[", "basis", "]"}]}], "]"}],
                "[", 
               RowBox[{"dummy", ",", 
                RowBox[{"-", "a"}], ",", 
                RowBox[{"-", "dummy"}]}], "]"}]}], "}"}], ",", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Perturbation", "[", 
               RowBox[{
                RowBox[{"chr", " ", "expr"}], ",", "n"}], "]"}]}], "+", 
             RowBox[{"chr", " ", 
              RowBox[{"Perturbation", "[", 
               RowBox[{"expr", ",", "n"}], "]"}]}]}]}], "]"}]}]}], "]"}]}]}], 
     "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5f587c03-ac27-4a59-ae08-2e3db6b16f50"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbationDer", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"LieD", "[", "v_", "]"}], "[", "expr_", "]"}], ",", "n_."}], 
     "]"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "lieD", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"LeibnizDistribute", "[", 
       RowBox[{"Perturbation", ",", "n", ",", 
        RowBox[{"lieD", "[", 
         RowBox[{"v", ",", "expr"}], "]"}], ",", "Plus"}], "]"}], "/.", 
      RowBox[{
       RowBox[{"lieD", "[", 
        RowBox[{"V_", ",", "EXPR_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"LieD", "[", "V", "]"}], "[", "EXPR", "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7422f806-9ba2-45c0-9756-44025e4ad5d8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExpandPerturbationDer", "[", 
    RowBox[{
     RowBox[{"Perturbation", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Bracket", "[", 
         RowBox[{"v1_", ",", "v2_"}], "]"}], "[", "a_Symbol", "]"}], ",", 
       "n_."}], "]"}], ",", "options___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "bracket", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"LeibnizDistribute", "[", 
       RowBox[{"Perturbation", ",", "n", ",", 
        RowBox[{
         RowBox[{"bracket", "[", "a", "]"}], "[", 
         RowBox[{"v1", ",", "v2"}], "]"}], ",", "Plus"}], "]"}], "/.", 
      RowBox[{
       RowBox[{
        RowBox[{"bracket", "[", "A_", "]"}], "[", 
        RowBox[{"V1_", ",", "V2_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"Bracket", "[", 
         RowBox[{"V1", ",", "V2"}], "]"}], "[", "A", "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"dfdd5505-8230-4f34-8300-428a8455a097"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.7. PerturbationOrder", \
"Subsubsection",ExpressionUUID->"f2b9bc06-9139-430c-8cee-f23c73799d9f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"homorder", "[", "list_List", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"Union", "[", "list", "]"}], "]"}], "===", "1"}], ",", 
     RowBox[{"First", "[", "list", "]"}], ",", "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PerturbationOrder", "[", "expr_Times", "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Plus", ",", 
     RowBox[{"Map", "[", 
      RowBox[{"PerturbationOrder", ",", 
       RowBox[{"List", "@@", "expr"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PerturbationOrder", "[", "expr_Plus", "]"}], ":=", 
   RowBox[{"homorder", "@", 
    RowBox[{"Map", "[", 
     RowBox[{"PerturbationOrder", ",", 
      RowBox[{"List", "@@", "expr"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PerturbationOrder", "[", 
    RowBox[{"Power", "[", 
     RowBox[{"expr_", ",", "n_"}], "]"}], "]"}], ":=", 
   RowBox[{"n", " ", 
    RowBox[{"PerturbationOrder", "[", "expr", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PerturbationOrder", "[", 
    RowBox[{"Perturbation", "[", 
     RowBox[{"expr_", ",", "n_."}], "]"}], "]"}], ":=", "n"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PerturbationOrder", "[", 
    RowBox[{
     RowBox[{"_", "?", "FirstDerQ"}], "[", "expr_", "]"}], "]"}], ":=", 
   RowBox[{"PerturbationOrder", "[", "expr", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PerturbationOrder", "[", "expr_", "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PerturbationOrder", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PerturbationOrder", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"920e96dc-da96-41c4-96e3-30c5da458935"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.8. GaugeChange", \
"Subsubsection",ExpressionUUID->"b28a2f71-2b85-4fa1-b474-b60e1e026fdb"],

Cell["\<\
Return perturbative expression in a different gauge. Background quantities \
are not changed. Nothing happens on inert heads.\
\>", "Text",ExpressionUUID->"dc85376f-f0a4-453b-aac6-ce55e45c281c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GaugeChange", "[", 
    RowBox[{"pert_Plus", ",", "gen_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"GaugeChange", "[", 
      RowBox[{"#", ",", "gen"}], "]"}], "&"}], "/@", "pert"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GaugeChange", "[", 
    RowBox[{"pert_Times", ",", "gen_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"GaugeChange", "[", 
      RowBox[{"#", ",", "gen"}], "]"}], "&"}], "/@", "pert"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GaugeChange", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"func_Symbol", "?", "ScalarFunction"}], "[", "args__", "]"}], ",",
      "gen_"}], "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"func", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"GaugeChange", "[", 
        RowBox[{"#", ",", "gen"}], "]"}], "&"}], "/@", 
      RowBox[{"{", "args", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GaugeChange", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Scalar", "[", "pert_", "]"}], "^", 
      RowBox[{"Optional", "[", "n_Integer", "]"}]}], ",", "gen_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Scalar", "[", 
     RowBox[{"xAct`xPert`GaugeChange", "[", 
      RowBox[{"pert", ",", "gen"}], "]"}], "]"}], "^", "n"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"GaugeChange", "[", 
    RowBox[{"expr_", ",", "gen_"}], "]"}], ":=", 
   RowBox[{"GaugeChange", "[", 
    RowBox[{"expr", ",", "gen", ",", 
     RowBox[{"PerturbationOrder", "[", "expr", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GaugeChange", "[", 
    RowBox[{"expr_", ",", "gen_", ",", "0"}], "]"}], ":=", "expr"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GaugeChange", "[", 
    RowBox[{"expr_Perturbation", ",", "gen_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Bruni", "[", 
    RowBox[{"expr", ",", "gen", ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GaugeChange", "[", 
    RowBox[{"expr_", ",", "gen_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sexpr", "=", 
       RowBox[{
        RowBox[{"SeparateMetric", "[", "]"}], "[", "expr", "]"}]}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"expr", "===", "sexpr"}], ",", 
       RowBox[{"Bruni", "[", 
        RowBox[{"expr", ",", "gen", ",", "n"}], "]"}], ",", 
       RowBox[{"GaugeChange", "[", 
        RowBox[{"sexpr", ",", "gen"}], "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Bruni", "[", 
    RowBox[{"expr_", ",", "gen_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"expr", "+", 
    RowBox[{"Expand", "@", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"n", "!"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "-", "m"}], ")"}], "!"}]}], "\[IndentingNewLine]", 
        RowBox[{"Apply", "[", 
         RowBox[{"Plus", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"BruniTerm", "[", 
             RowBox[{
              RowBox[{"Perturbation", "[", 
               RowBox[{"expr", ",", 
                RowBox[{"-", "m"}]}], "]"}], ",", "gen", ",", "#"}], "]"}], 
            "&"}], "/@", 
           RowBox[{"FoldedPartitions", "[", "m", "]"}]}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "1", ",", "n"}], "}"}]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"GaugeChange", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "GaugeChange", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d30db867-1034-4eca-b409-eecfd443bcfe"],

Cell["Single term in Bruni's formula:", \
"Text",ExpressionUUID->"7ee51c96-d582-4716-89c4-ef43c252eaf5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BruniTerm", "[", 
    RowBox[{"expr_", ",", "gen_", ",", "partition_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dummy", "=", 
        RowBox[{"DummyIn", "@", 
         RowBox[{"Last", "@", 
          RowBox[{"SlotsOfTensor", "[", "gen", "]"}]}]}]}], ",", 
       RowBox[{"range", "=", 
        RowBox[{"Range", "@", 
         RowBox[{"Length", "@", "partition"}]}]}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Inner", "[", 
         RowBox[{"Power", ",", 
          RowBox[{"Factorial", "[", "range", "]"}], ",", "partition", ",", 
          "Times"}], "]"}]}], "/", 
       RowBox[{"Times", "@@", 
        RowBox[{"Factorial", "[", "partition", "]"}]}]}], 
      RowBox[{"Fold", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Nest", "[", 
          RowBox[{
           RowBox[{"LieD", "[", 
            RowBox[{"gen", "[", 
             RowBox[{
              RowBox[{"LI", "[", 
               RowBox[{"First", "@", "#2"}], "]"}], ",", "dummy"}], "]"}], 
            "]"}], ",", "#1", ",", 
           RowBox[{"Last", "@", "#2"}]}], "]"}], "&"}], ",", "expr", ",", 
        RowBox[{"Reverse", "@", 
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{"range", ",", "partition"}], "}"}], "]"}]}]}], "]"}]}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"29fccc5e-ca79-4409-89fa-a7f069445791"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["4. Perturbations of curvature tensors",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subsection",ExpressionUUID->"8cb309de-88d2-4dcd-8433-40be3de8b9f6"],

Cell[CellGroupData[{

Cell["4.1. Perturbation of the metric tensor. Not used now", \
"Subsubsection",ExpressionUUID->"2193e795-58af-4cc1-aabe-8ee0ec13cce1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefPertMetric", "[", 
    RowBox[{
     RowBox[{"metric_", "[", 
      RowBox[{
       RowBox[{"-", "a_"}], ",", 
       RowBox[{"-", "b_"}]}], "]"}], ",", "pert_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"metric", "[", 
         RowBox[{
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}]}], "]"}], ",", "n_."}], "]"}], ":=", 
      RowBox[{"pert", "[", 
       RowBox[{
        RowBox[{"LI", "[", "n", "]"}], ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"pert", "[", 
         RowBox[{
          RowBox[{"LI", "[", "n1_", "]"}], ",", 
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}]}], "]"}], ",", "n_."}], "]"}], ":=", 
      RowBox[{"pert", "[", 
       RowBox[{
        RowBox[{"LI", "[", 
         RowBox[{"n1", "+", "n"}], "]"}], ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "]"}]}]}], "\[IndentingNewLine]", ")"}]}], 
  ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"6a0c5528-196a-4c07-a581-89a3689aeef5"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.2. Perturbation of the inverse metric tensor", \
"Subsubsection",ExpressionUUID->"f5c4fdcd-b6bd-42eb-940c-f23ecb758bbd"],

Cell[TextData[{
 "In order to construct the ",
 StyleBox["GeneralPerturbation",
  FontFamily->"Courier"],
 " term we need to define"
}], "Text",ExpressionUUID->"a61f9a84-f2a4-433b-a523-b665c6c30baf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"productPert", "[", 
    RowBox[{
     RowBox[{"{", "p_", "}"}], ",", "vbundle_", ",", "pert_"}], "]"}], "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"pert", "[", 
   RowBox[{
    RowBox[{"LI", "[", "p", "]"}], ",", "a", ",", "b"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"productPert", "[", 
     RowBox[{"partition_List", ",", "vbundle_", ",", "pert_"}], "]"}], "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m", "=", 
        RowBox[{"Length", "[", "partition", "]"}]}], ",", "i", ",", 
       "indices"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"indices", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"DummyIn", "[", "vbundle", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", "-", "1"}], "}"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"pert", "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{"partition", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "a", ",", 
         RowBox[{"indices", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"pert", "[", 
          RowBox[{
           RowBox[{"LI", "[", 
            RowBox[{"partition", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}], ",", 
           RowBox[{"ChangeIndex", "[", 
            RowBox[{"indices", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
           RowBox[{"indices", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"m", "-", "2"}]}], "}"}]}], "]"}], 
       RowBox[{"pert", "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{"partition", "[", 
           RowBox[{"[", "m", "]"}], "]"}], "]"}], ",", 
         RowBox[{"ChangeIndex", "[", 
          RowBox[{"indices", "[", 
           RowBox[{"[", 
            RowBox[{"m", "-", "1"}], "]"}], "]"}], "]"}], ",", "b"}], 
        "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"15bb0e6e-6053-42c7-a0d3-0ed5566de561"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertInvMetric", "[", 
    RowBox[{"vbundle_", ",", 
     RowBox[{"metric_", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], ",", "pert_"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{
       RowBox[{"Perturbation", "[", 
        RowBox[{
         RowBox[{"metric", "[", 
          RowBox[{"a_Symbol", ",", "b_Symbol"}], "]"}], ",", "order_."}], 
        "]"}], ",", "options___"}], "]"}], ":=", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"Length", "[", "#", "]"}]}], 
           RowBox[{"(", 
            RowBox[{"Multinomial", "@@", "#"}], ")"}], 
           RowBox[{
            RowBox[{"productPert", "[", 
             RowBox[{"#", ",", "vbundle", ",", "pert"}], "]"}], "[", 
            RowBox[{"a", ",", "b"}], "]"}]}], "&"}], ",", 
         RowBox[{"SortedPartitions", "[", "order", "]"}]}], "]"}], ")"}]}]}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"00d8daa3-a4fc-4fe6-a811-4f78f05b9128"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.3. Perturbation of the determinant of the metric", \
"Subsubsection",ExpressionUUID->"1ddabfaf-502c-482c-97f6-e8aa5a56c7f2"],

Cell["Original code:", \
"Text",ExpressionUUID->"0ad96964-4a39-4b77-b4b3-92c765812d1a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertDet", "[", 
    RowBox[{"vbundle_", ",", "metric_", ",", "pert_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dim", "=", 
        RowBox[{"DimOfVBundle", "[", "vbundle", "]"}]}], ",", 
       RowBox[{"metricepsilon", "=", 
        RowBox[{"epsilon", "[", "metric", "]"}]}], ",", 
       RowBox[{"mdet", "=", 
        RowBox[{
         RowBox[{"Determinant", "[", "metric", "]"}], "[", "]"}]}]}], "}"}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"ExpandPerturbation1", "[", 
        RowBox[{"Perturbation", "[", 
         RowBox[{"mdet", ",", "order_."}], "]"}], "]"}], ":=", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"inds", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"DummyIn", "[", "vbundle", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", "dim"}], "}"}]}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"inds1", "=", 
              RowBox[{"inds", "[", 
               RowBox[{"[", 
                RowBox[{"Range", "[", "dim", "]"}], "]"}], "]"}]}], ",", 
             RowBox[{"inds2", "=", 
              RowBox[{"inds", "[", 
               RowBox[{"[", 
                RowBox[{"Range", "[", 
                 RowBox[{
                  RowBox[{"dim", "+", "1"}], ",", 
                  RowBox[{"2", "dim"}]}], "]"}], "]"}], "]"}]}]}], "}"}], ",", 
           RowBox[{"ContractMetric", "[", 
            RowBox[{
             RowBox[{"mdet", "/", 
              RowBox[{"dim", "!"}]}], 
             RowBox[{"SignDetOfMetric", "[", "metric", "]"}], 
             RowBox[{"metricepsilon", "@@", "inds1"}], " ", 
             RowBox[{"metricepsilon", "@@", "inds2"}], " ", 
             RowBox[{"Perturbation", "[", 
              RowBox[{
               RowBox[{"Times", "@@", 
                RowBox[{"Apply", "[", 
                 RowBox[{"metric", ",", 
                  RowBox[{"Transpose", "[", 
                   RowBox[{"-", 
                    RowBox[{"{", 
                    RowBox[{"inds1", ",", "inds2"}], "}"}]}], "]"}], ",", 
                  RowBox[{"{", "1", "}"}]}], "]"}]}], ",", "order"}], "]"}]}],
             "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ExpandPerturbation1", "[", 
        RowBox[{"Perturbation", "[", 
         RowBox[{
          RowBox[{"metricepsilon", "[", 
           RowBox[{"superinds__", "?", "UpIndexQ"}], "]"}], ",", "order_."}], 
         "]"}], "]"}], ":=", 
       RowBox[{
        RowBox[{"metricepsilon", "[", "superinds", "]"}], 
        RowBox[{"Sqrt", "[", "mdet", "]"}], 
        RowBox[{"ExpandPerturbation", "[", 
         RowBox[{"Perturbation", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"Sqrt", "[", "mdet", "]"}]}], ",", "order"}], "]"}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ExpandPerturbation1", "[", 
        RowBox[{"Perturbation", "[", 
         RowBox[{
          RowBox[{"metricepsilon", "[", 
           RowBox[{"subinds__", "?", "DownIndexQ"}], "]"}], ",", "order_."}], 
         "]"}], "]"}], ":=", 
       RowBox[{
        RowBox[{
         RowBox[{"metricepsilon", "[", "subinds", "]"}], "/", 
         RowBox[{"Sqrt", "[", "mdet", "]"}]}], 
        RowBox[{"ExpandPerturbation", "[", 
         RowBox[{"Perturbation", "[", 
          RowBox[{
           RowBox[{"Sqrt", "[", "mdet", "]"}], ",", "order"}], "]"}], 
         "]"}]}]}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"74dab203-3f5e-4f9c-868d-fd16639ecf9d"],

Cell["\<\
New code, contributed by Cyril Pitrou. Perturbation from the Log-Trace \
formula. Should work in any dimension, even abstract dimensions, but it does \
not use the identities when the order of perturbation is higher than the \
dimension:\
\>", "Text",ExpressionUUID->"f4886da8-f306-45ac-9b1b-02d09c4ef0d1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"productPertDet0", "[", 
     RowBox[{
      RowBox[{"{", "p_", "}"}], ",", "vbundle_", ",", "pert_"}], "]"}], ":=", 
    
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ind", "=", 
        RowBox[{"DummyIn", "[", "vbundle", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"pert", "[", 
        RowBox[{
         RowBox[{"LI", "[", "p", "]"}], ",", 
         RowBox[{"-", "ind"}], ",", "ind"}], "]"}], "/", 
       RowBox[{"p", "!"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"productPertDet0", "[", 
     RowBox[{"partition_List", ",", "vbundle_", ",", "pert_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"m", "=", 
         RowBox[{"Length", "[", "partition", "]"}]}], ",", "i", ",", 
        "indices"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"indices", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"DummyIn", "[", "vbundle", "]"}], ",", 
          RowBox[{"{", "m", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Times", "@@", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "!"}], "&"}], ",", "partition"}], "]"}]}]}], "\[IndentingNewLine]",
         " ", 
        RowBox[{"pert", "[", 
         RowBox[{
          RowBox[{"LI", "[", 
           RowBox[{"partition", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
          RowBox[{"ChangeIndex", "[", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "m", "]"}], "]"}], "]"}], ",", 
          RowBox[{"indices", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], 
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"pert", "[", 
           RowBox[{
            RowBox[{"LI", "[", 
             RowBox[{"partition", "[", 
              RowBox[{"[", 
               RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}], ",", 
            RowBox[{"ChangeIndex", "[", 
             RowBox[{"indices", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
            RowBox[{"indices", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"m", "-", "1"}]}], "}"}]}], "]"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"productPertDet1", "[", 
     RowBox[{
     "partitionK_List", ",", "partitionL_List", ",", "vbundle_", ",", 
      "pert_"}], "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", "=", 
        RowBox[{"Length", "[", "partitionK", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", "m"}], "/", 
         RowBox[{"m", "!"}]}], "/", 
        RowBox[{"Times", "@@", "partitionK"}]}], " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"m", "\[GreaterEqual]", "2"}], ",", 
         RowBox[{"Product", "[", 
          RowBox[{
           RowBox[{"productPertDet0", "[", 
            RowBox[{
             RowBox[{"Take", "[", 
              RowBox[{"partitionL", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"1", "+", 
                  RowBox[{"Plus", "@@", 
                   RowBox[{"Take", "[", 
                    RowBox[{"partitionK", ",", 
                    RowBox[{"i", "-", "1"}]}], "]"}]}]}], ",", 
                 RowBox[{"Plus", "@@", 
                  RowBox[{"Take", "[", 
                   RowBox[{"partitionK", ",", "i"}], "]"}]}]}], "}"}]}], 
              "]"}], ",", "vbundle", ",", "pert"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "2", ",", "m"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "1"}], "]"}], "\[IndentingNewLine]", 
       RowBox[{"productPertDet0", "[", 
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"partitionL", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"partitionK", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
         "vbundle", ",", "pert"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"productPertDet2", "[", 
    RowBox[{"partition_List", ",", "vbundle_", ",", "pert_"}], "]"}], ":=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"Map", "[", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"productPertDet1", "[", 
        RowBox[{"#", ",", "partition", ",", "vbundle", ",", "pert"}], "]"}], 
       "&"}], ",", 
      RowBox[{"SortedPartitions", "[", 
       RowBox[{"Length", "[", "partition", "]"}], "]"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b9e074e4-edc2-4b2b-9811-a07d22fa177c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertDet", "[", 
    RowBox[{"vbundle_", ",", "metric_", ",", "pert_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"dim", "=", 
        RowBox[{"DimOfVBundle", "[", "vbundle", "]"}]}], ",", 
       RowBox[{"metricepsilon", "=", 
        RowBox[{"epsilon", "[", "metric", "]"}]}], ",", 
       RowBox[{"mdet", "=", 
        RowBox[{
         RowBox[{"Determinant", "[", "metric", "]"}], "[", "]"}]}]}], "}"}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"ExpandPerturbation1", "[", 
        RowBox[{"Perturbation", "[", 
         RowBox[{"mdet", ",", "order_."}], "]"}], "]"}], ":=", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"inds", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"DummyIn", "[", "vbundle", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"2", "dim"}], "}"}]}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"inds1", "=", 
               RowBox[{"Take", "[", 
                RowBox[{"inds", ",", "dim"}], "]"}]}], ",", 
              RowBox[{"inds2", "=", 
               RowBox[{"Take", "[", 
                RowBox[{"inds", ",", 
                 RowBox[{"-", "dim"}]}], "]"}]}]}], "}"}], ",", 
            RowBox[{"ContractMetric", "[", 
             RowBox[{
              RowBox[{"mdet", "/", 
               RowBox[{"dim", "!"}]}], 
              RowBox[{"SignDetOfMetric", "[", "metric", "]"}], 
              RowBox[{"metricepsilon", "@@", "inds1"}], " ", 
              RowBox[{"metricepsilon", "@@", "inds2"}], " ", 
              RowBox[{"Perturbation", "[", 
               RowBox[{
                RowBox[{"Times", "@@", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"metric", ",", 
                   RowBox[{"Transpose", "[", 
                    RowBox[{"-", 
                    RowBox[{"{", 
                    RowBox[{"inds1", ",", "inds2"}], "}"}]}], "]"}], ",", 
                   RowBox[{"{", "1", "}"}]}], "]"}]}], ",", "order"}], 
               "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
         "\[IndentingNewLine]", "]"}], "/;", 
        RowBox[{
         RowBox[{"IntegerQ", "[", "dim", "]"}], "&&", 
         RowBox[{"order", ">", "dim"}]}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ExpandPerturbation1", "[", 
        RowBox[{"Perturbation", "[", 
         RowBox[{"mdet", ",", "order_."}], "]"}], "]"}], ":=", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"mdet", " ", 
         RowBox[{"order", "!"}], 
         RowBox[{"Plus", "@@", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", 
               RowBox[{"Length", "[", "#", "]"}]}], 
              RowBox[{"productPertDet2", "[", 
               RowBox[{"#", ",", "vbundle", ",", "pert"}], "]"}]}], "&"}], ",", 
            RowBox[{"SortedPartitions", "[", "order", "]"}]}], "]"}]}]}], "/;", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"IntegerQ", "[", "dim", "]"}]}], "||", 
         RowBox[{"order", "\[LessEqual]", "dim"}]}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ExpandPerturbation1", "[", 
        RowBox[{"Perturbation", "[", 
         RowBox[{
          RowBox[{"metricepsilon", "[", 
           RowBox[{"superinds__", "?", "UpIndexQ"}], "]"}], ",", "order_."}], 
         "]"}], "]"}], ":=", 
       RowBox[{
        RowBox[{"metricepsilon", "[", "superinds", "]"}], 
        RowBox[{"Sqrt", "[", "mdet", "]"}], 
        RowBox[{"ExpandPerturbation", "[", 
         RowBox[{"Perturbation", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"Sqrt", "[", "mdet", "]"}]}], ",", "order"}], "]"}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ExpandPerturbation1", "[", 
        RowBox[{"Perturbation", "[", 
         RowBox[{
          RowBox[{"metricepsilon", "[", 
           RowBox[{"subinds__", "?", "DownIndexQ"}], "]"}], ",", "order_."}], 
         "]"}], "]"}], ":=", 
       RowBox[{
        RowBox[{
         RowBox[{"metricepsilon", "[", "subinds", "]"}], "/", 
         RowBox[{"Sqrt", "[", "mdet", "]"}]}], 
        RowBox[{"ExpandPerturbation", "[", 
         RowBox[{"Perturbation", "[", 
          RowBox[{
           RowBox[{"Sqrt", "[", "mdet", "]"}], ",", "order"}], "]"}], 
         "]"}]}]}], ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4ddaaa90-0417-44f7-8e85-0ba99c5ead58"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.4. Perturbation of the Christoffel tensor", \
"Subsubsection",ExpressionUUID->"c59cb947-867d-42fc-afd1-1532e43af5b9"],

Cell["General term:", \
"Text",ExpressionUUID->"1d164c06-0e96-47c0-8139-30bd02865048"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"productThreePert", "[", 
    RowBox[{
     RowBox[{"{", "p_", "}"}], ",", "vbundle_", ",", "covd_", ",", "pert_"}], 
    "]"}], "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"ThreePert", "[", 
    RowBox[{"covd", ",", "pert"}], "]"}], "[", 
   RowBox[{
    RowBox[{"LI", "[", "p", "]"}], ",", "a", ",", "b", ",", "c"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"productThreePert", "[", 
    RowBox[{"partition_List", ",", "vbundle_", ",", "covd_", ",", "pert_"}], 
    "]"}], "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"m", "=", 
       RowBox[{"Length", "[", "partition", "]"}]}], ",", "i", ",", 
      "indices"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"indices", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"DummyIn", "[", "vbundle", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", "-", "1"}], "}"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"pert", "[", 
       RowBox[{
        RowBox[{"LI", "[", 
         RowBox[{"partition", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "a", ",", 
        RowBox[{"indices", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}], 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"pert", "[", 
         RowBox[{
          RowBox[{"LI", "[", 
           RowBox[{"partition", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}], ",", 
          RowBox[{"ChangeIndex", "[", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
          RowBox[{"indices", "[", 
           RowBox[{"[", 
            RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"m", "-", "2"}]}], "}"}]}], "]"}], 
      RowBox[{
       RowBox[{"ThreePert", "[", 
        RowBox[{"covd", ",", "pert"}], "]"}], "[", 
       RowBox[{
        RowBox[{"LI", "[", 
         RowBox[{"partition", "[", 
          RowBox[{"[", "m", "]"}], "]"}], "]"}], ",", 
        RowBox[{"ChangeIndex", "[", 
         RowBox[{"indices", "[", 
          RowBox[{"[", 
           RowBox[{"m", "-", "1"}], "]"}], "]"}], "]"}], ",", "b", ",", "c"}],
        "]"}]}]}]}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"da88c88c-be44-4562-b2d4-a6b6ee288e96"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertChristoffel", "[", 
    RowBox[{"vbundle_", ",", "covd_", ",", "pert_", ",", 
     RowBox[{"christoffel_", "[", 
      RowBox[{"a_", ",", 
       RowBox[{"-", "b_"}], ",", 
       RowBox[{"-", "c_"}]}], "]"}]}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"christoffel", "[", 
         RowBox[{"a_Symbol", ",", 
          RowBox[{"-", "b_Symbol"}], ",", 
          RowBox[{"-", "c_Symbol"}]}], "]"}], ",", "order_."}], "]"}], "]"}], 
     ":=", 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", 
             RowBox[{"Length", "[", "#", "]"}]}]}], 
           RowBox[{"(", 
            RowBox[{"Multinomial", "@@", "#"}], ")"}], 
           RowBox[{
            RowBox[{"productThreePert", "[", 
             RowBox[{"#", ",", "vbundle", ",", "covd", ",", "pert"}], "]"}], "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "b"}], ",", 
             RowBox[{"-", "c"}]}], "]"}]}], "&"}], ",", 
         RowBox[{"SortedPartitions", "[", "order", "]"}]}], "]"}], ")"}]}]}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"52b720cb-1d5d-471b-9aea-72b91ea6f601"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.5. Perturbation of the Riemann tensor", \
"Subsubsection",ExpressionUUID->"dba08cc5-d13f-4117-99c7-9c5ac18ea6c1"],

Cell["\<\
General term. There is first the expression in terms of the perturbations of \
the Christoffel tensor. We give it here, but do not include it in the package:\
\>", "Text",ExpressionUUID->"b5c0a98d-0966-4dcb-8ead-6b4bfe4266e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertRiemannFromChristoffel", "[", 
    RowBox[{"vbundle_", ",", "covd_", ",", "christoffel_", ",", 
     RowBox[{"riemann_", "[", 
      RowBox[{
       RowBox[{"-", "a_"}], ",", 
       RowBox[{"-", "b_"}], ",", 
       RowBox[{"-", "c_"}], ",", "d_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"GeneralPerturbation0", "[", 
      RowBox[{
       RowBox[{"riemann", "[", 
        RowBox[{
         RowBox[{"-", "a_Symbol"}], ",", 
         RowBox[{"-", "b_Symbol"}], ",", 
         RowBox[{"-", "c_Symbol"}], ",", "d_Symbol"}], "]"}], ",", 
       "order_Integer"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"dummy", "=", 
         RowBox[{"DummyIn", "[", "vbundle", "]"}]}], "}"}], ",", 
       RowBox[{"2", "$RiemannSign", " ", 
        RowBox[{"Antisymmetrize", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"covd", "[", 
             RowBox[{"-", "b"}], "]"}], "[", 
            RowBox[{"Perturbation", "[", 
             RowBox[{
              RowBox[{"christoffel", "[", 
               RowBox[{"d", ",", 
                RowBox[{"-", "a"}], ",", 
                RowBox[{"-", "c"}]}], "]"}], ",", "order"}], "]"}], "]"}], "-", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Binomial", "[", 
               RowBox[{"order", ",", "k"}], "]"}], 
              RowBox[{"Perturbation", "[", 
               RowBox[{
                RowBox[{"christoffel", "[", 
                 RowBox[{"d", ",", 
                  RowBox[{"-", "dummy"}], ",", 
                  RowBox[{"-", "a"}]}], "]"}], ",", "k"}], "]"}], 
              RowBox[{"Perturbation", "[", 
               RowBox[{
                RowBox[{"christoffel", "[", 
                 RowBox[{"dummy", ",", 
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "c"}]}], "]"}], ",", 
                RowBox[{"order", "-", "k"}]}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "1", ",", 
               RowBox[{"order", "-", "1"}]}], "}"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "b"}]}], "}"}]}], "]"}]}]}], "]"}]}], ")"}]}], 
  ";"}]], "Input",ExpressionUUID->"b4aa36e1-9780-4ca3-add7-cbf8ddcca01d"],

Cell["\<\
Then we have an expression given directly in terms of the derivatives of the \
metric:\
\>", "Text",ExpressionUUID->"12b5381f-7fde-4b69-b1aa-a2f50074c4e5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"productRiemann1", "[", 
    RowBox[{
     RowBox[{"{", "p_", "}"}], ",", "vbundle_", ",", "covd_", ",", "pert_"}], 
    "]"}], "[", 
   RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"covd", "[", "a", "]"}], "[", 
   RowBox[{
    RowBox[{"ThreePert", "[", 
     RowBox[{"covd", ",", "pert"}], "]"}], "[", 
    RowBox[{
     RowBox[{"LI", "[", "p", "]"}], ",", "d", ",", "c", ",", "b"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"productRiemann1", "[", 
    RowBox[{"partition_List", ",", "vbundle_", ",", "covd_", ",", "pert_"}], 
    "]"}], "[", 
   RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"m", "=", 
       RowBox[{"Length", "[", "partition", "]"}]}], ",", "i", ",", 
      "indices"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"indices", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"DummyIn", "[", "vbundle", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", "-", "1"}], "}"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"pert", "[", 
       RowBox[{
        RowBox[{"LI", "[", 
         RowBox[{"partition", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "d", ",", 
        RowBox[{"indices", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}], 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"pert", "[", 
         RowBox[{
          RowBox[{"LI", "[", 
           RowBox[{"partition", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}], ",", 
          RowBox[{"ChangeIndex", "[", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
          RowBox[{"indices", "[", 
           RowBox[{"[", 
            RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"m", "-", "2"}]}], "}"}]}], "]"}], 
      RowBox[{
       RowBox[{"covd", "[", "a", "]"}], "[", 
       RowBox[{
        RowBox[{"ThreePert", "[", 
         RowBox[{"covd", ",", "pert"}], "]"}], "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{"partition", "[", 
           RowBox[{"[", "m", "]"}], "]"}], "]"}], ",", 
         RowBox[{"ChangeIndex", "[", 
          RowBox[{"indices", "[", 
           RowBox[{"[", 
            RowBox[{"m", "-", "1"}], "]"}], "]"}], "]"}], ",", "c", ",", 
         "b"}], "]"}], "]"}]}]}]}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"90bccd79-2f7e-420e-9689-10d62bc87e3f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"productRiemann2", "[", 
    RowBox[{
    "partition_List", ",", "s_", ",", "vbundle_", ",", "covd_", ",", 
     "pert_"}], "]"}], "[", 
   RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m", "=", 
        RowBox[{"Length", "[", "partition", "]"}]}], ",", "i", ",", 
       "indices"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"indices", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"DummyIn", "[", "vbundle", "]"}], ",", 
         RowBox[{"{", "s", "}"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{
        RowBox[{"ThreePert", "[", 
         RowBox[{"covd", ",", "pert"}], "]"}], "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{"partition", "[", 
           RowBox[{"[", "s", "]"}], "]"}], "]"}], ",", 
         RowBox[{"indices", "[", 
          RowBox[{"[", "s", "]"}], "]"}], ",", "d", ",", "a"}], "]"}], 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"pert", "[", 
          RowBox[{
           RowBox[{"LI", "[", 
            RowBox[{"partition", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
           RowBox[{"ChangeIndex", "[", 
            RowBox[{"indices", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}], ",", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"s", "-", "1"}], ",", "2", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], 
       RowBox[{
        RowBox[{"ThreePert", "[", 
         RowBox[{"covd", ",", "pert"}], "]"}], "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{"partition", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
         RowBox[{"ChangeIndex", "[", 
          RowBox[{"indices", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "b", ",", "c"}], 
        "]"}]}]}]}], "]"}], "/;", 
   RowBox[{"s", "\[Equal]", 
    RowBox[{"Length", "[", "partition", "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"productRiemann2", "[", 
    RowBox[{
    "partition_List", ",", "s_", ",", "vbundle_", ",", "covd_", ",", 
     "pert_"}], "]"}], "[", 
   RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m", "=", 
        RowBox[{"Length", "[", "partition", "]"}]}], ",", "i", ",", 
       "indices"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"indices", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"DummyIn", "[", "vbundle", "]"}], ",", 
         RowBox[{"{", "m", "}"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"pert", "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{"partition", "[", 
           RowBox[{"[", "m", "]"}], "]"}], "]"}], ",", "d", ",", 
         RowBox[{"indices", "[", 
          RowBox[{"[", "m", "]"}], "]"}]}], "]"}], 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"pert", "[", 
          RowBox[{
           RowBox[{"LI", "[", 
            RowBox[{"partition", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
           RowBox[{"ChangeIndex", "[", 
            RowBox[{"indices", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}], ",", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"m", "-", "1"}], ",", 
           RowBox[{"s", "+", "1"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], 
       RowBox[{
        RowBox[{"ThreePert", "[", 
         RowBox[{"covd", ",", "pert"}], "]"}], "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{"partition", "[", 
           RowBox[{"[", "s", "]"}], "]"}], "]"}], ",", 
         RowBox[{"indices", "[", 
          RowBox[{"[", "s", "]"}], "]"}], ",", 
         RowBox[{"ChangeIndex", "[", 
          RowBox[{"indices", "[", 
           RowBox[{"[", 
            RowBox[{"s", "+", "1"}], "]"}], "]"}], "]"}], ",", "a"}], "]"}], 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"pert", "[", 
          RowBox[{
           RowBox[{"LI", "[", 
            RowBox[{"partition", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
           RowBox[{"ChangeIndex", "[", 
            RowBox[{"indices", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", "1"}], "]"}], "]"}], "]"}], ",", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"s", "-", "1"}], ",", "2", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], 
       RowBox[{
        RowBox[{"ThreePert", "[", 
         RowBox[{"covd", ",", "pert"}], "]"}], "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{"partition", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
         RowBox[{"ChangeIndex", "[", 
          RowBox[{"indices", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "b", ",", "c"}], 
        "]"}]}]}]}], "]"}], "/;", 
   RowBox[{"2", "\[LessEqual]", "s", "<", 
    RowBox[{"Length", "[", "partition", "]"}]}]}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"90e2d71c-d0fc-4563-9852-a51164a37468"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"genpertriemann", "[", 
    RowBox[{"vbundle_", ",", "covd_", ",", "pert_", ",", 
     RowBox[{"IndexList", "[", 
      RowBox[{
       RowBox[{"-", "a_"}], ",", 
       RowBox[{"-", "b_"}], ",", 
       RowBox[{"-", "c_"}], ",", "d_"}], "]"}], ",", "order_"}], "]"}], ":=", 
   
   RowBox[{"2", "$RiemannSign", " ", 
    RowBox[{"Antisymmetrize", "[", 
     RowBox[{
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", 
             RowBox[{"Length", "[", "#", "]"}]}], 
            RowBox[{"(", 
             RowBox[{"Multinomial", "@@", "#"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"productRiemann1", "[", 
                RowBox[{"#", ",", "vbundle", ",", "covd", ",", "pert"}], 
                "]"}], "[", 
               RowBox[{
                RowBox[{"-", "a"}], ",", 
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
              RowBox[{"Sum", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"productRiemann2", "[", 
                  RowBox[{
                  "#", ",", "s", ",", "vbundle", ",", "covd", ",", "pert"}], 
                  "]"}], "[", 
                 RowBox[{
                  RowBox[{"-", "a"}], ",", 
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "c"}], ",", "d"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"s", ",", "2", ",", 
                  RowBox[{"Length", "[", "#", "]"}]}], "}"}]}], "]"}]}], 
             ")"}]}], "&"}], ",", 
          RowBox[{"SortedPartitions", "[", "order", "]"}]}], "]"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "}"}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ffa58011-2c6e-4563-baa2-0f4526ea990b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertRiemann", "[", 
    RowBox[{"vbundle_", ",", "covd_", ",", "pert_", ",", 
     RowBox[{"riemann_", "[", 
      RowBox[{
       RowBox[{"-", "a_"}], ",", 
       RowBox[{"-", "b_"}], ",", 
       RowBox[{"-", "c_"}], ",", "d_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"ExpandPerturbation1", "[", 
       RowBox[{"Perturbation", "[", 
        RowBox[{
         RowBox[{"riemann", "[", 
          RowBox[{
           RowBox[{"-", "a_Symbol"}], ",", 
           RowBox[{"-", "b_Symbol"}], ",", 
           RowBox[{"-", "c_Symbol"}], ",", "d_Symbol"}], "]"}], ",", 
         "order_."}], "]"}], "]"}], ":=", 
      RowBox[{"genpertriemann", "[", 
       RowBox[{"vbundle", ",", "covd", ",", "pert", ",", 
        RowBox[{"IndexList", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}], ",", "d"}], "]"}], ",", "order"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"ExpandPerturbation1", "[", 
       RowBox[{"Perturbation", "[", 
        RowBox[{
         RowBox[{"riemann", "[", 
          RowBox[{
           RowBox[{"-", "a_Symbol"}], ",", 
           RowBox[{"-", "b_Symbol"}], ",", 
           RowBox[{"-", "c_Symbol"}], ",", 
           RowBox[{"-", "d_Symbol"}]}], "]"}], ",", "order_."}], "]"}], "]"}],
       ":=", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"dummy", "=", 
           RowBox[{"DummyAs", "[", "c", "]"}]}], ",", 
          RowBox[{"metric", "=", 
           RowBox[{"xAct`xTensor`Private`FirstMetricOfVBundle", "[", 
            RowBox[{
             RowBox[{"VBundleOfIndex", "[", "d", "]"}], ",", "True"}], 
            "]"}]}]}], "}"}], ",", 
        RowBox[{"ExpandPerturbation", "@", 
         RowBox[{"Perturbation", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"riemann", "[", 
             RowBox[{
              RowBox[{"-", "a"}], ",", 
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "c"}], ",", "dummy"}], "]"}], 
            RowBox[{"metric", "[", 
             RowBox[{
              RowBox[{"-", "dummy"}], ",", 
              RowBox[{"-", "d"}]}], "]"}]}], ",", "order"}], "]"}]}]}], 
       "]"}]}]}], "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5536c5ab-165c-4f1a-b767-f8861baea3f0"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.6. Perturbation of the Ricci tensor", \
"Subsubsection",ExpressionUUID->"fc09f135-241f-4e2d-ac0f-723ed7493f7b"],

Cell["\<\
We can get the GeneralPerturbation term directly from that of the Riemann \
tensor:\
\>", "Text",ExpressionUUID->"26f8027a-95bf-4d24-8abf-aaa6b1ff4e7d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertRicci", "[", 
    RowBox[{"vbundle_", ",", "covd_", ",", "pert_", ",", "riemann_", ",", 
     RowBox[{"ricci_", "[", 
      RowBox[{
       RowBox[{"-", "a_"}], ",", 
       RowBox[{"-", "b_"}]}], "]"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"ricci", "[", 
         RowBox[{
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}]}], "]"}], ",", "order_."}], "]"}], "]"}], 
     ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"dummy", "=", 
         RowBox[{"DummyIn", "[", "vbundle", "]"}]}], "}"}], ",", 
       RowBox[{"$RicciSign", " ", 
        RowBox[{"genpertriemann", "[", 
         RowBox[{"vbundle", ",", "covd", ",", "pert", ",", 
          RowBox[{"IndexList", "[", 
           RowBox[{
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "dummy"}], ",", 
            RowBox[{"-", "b"}], ",", "dummy"}], "]"}], ",", "order"}], 
         "]"}]}]}], "]"}]}], ")"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"dbf18f6f-0a5b-487e-8796-e75cd19f3b90"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.7. Perturbation of the RicciScalar", \
"Subsubsection",ExpressionUUID->"bf1ddd1e-278d-4d22-8b1b-33896780662f"],

Cell["\<\
The perturbation of the RicciScalar is constructed from that of Ricci and the \
inverse metric:\
\>", "Text",ExpressionUUID->"5bbda944-eb75-4eb5-9d09-4ea988c1b04f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertRicciScalar", "[", 
    RowBox[{"vbundle_", ",", "metric_", ",", "ricci_", ",", "ricciscalar_"}], 
    "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"ricciscalar", "[", "]"}], ",", "order_."}], "]"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dummy1", "=", 
          RowBox[{"DummyIn", "[", "vbundle", "]"}]}], ",", 
         RowBox[{"dummy2", "=", 
          RowBox[{"DummyIn", "[", "vbundle", "]"}]}]}], "}"}], ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Binomial", "[", 
           RowBox[{"order", ",", "k"}], "]"}], 
          RowBox[{"ExpandPerturbation1", "@", 
           RowBox[{"Perturbation", "[", 
            RowBox[{
             RowBox[{"ricci", "[", 
              RowBox[{
               RowBox[{"-", "dummy1"}], ",", 
               RowBox[{"-", "dummy2"}]}], "]"}], ",", "k"}], "]"}]}], 
          RowBox[{"ExpandPerturbation1", "@", 
           RowBox[{"Perturbation", "[", 
            RowBox[{
             RowBox[{"metric", "[", 
              RowBox[{"dummy1", ",", "dummy2"}], "]"}], ",", 
             RowBox[{"order", "-", "k"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", "order"}], "}"}]}], "]"}]}], "]"}]}], 
    ")"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a579b0a7-c451-4f02-852f-dd37c10dda2d"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.8. Perturbation of the Einstein tensor", \
"Subsubsection",ExpressionUUID->"41cc12ba-68ae-413d-a73d-93ba0f2f51b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertEinstein", "[", 
    RowBox[{"vbundle_", ",", "metric_", ",", "ricci_", ",", "ricciscalar_", ",", 
     RowBox[{"einstein_", "[", 
      RowBox[{
       RowBox[{"-", "a_"}], ",", 
       RowBox[{"-", "b_"}]}], "]"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"einstein", "[", 
         RowBox[{
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}]}], "]"}], ",", "order_."}], "]"}], "]"}], 
     ":=", 
     RowBox[{
      RowBox[{"ExpandPerturbation1", "@", 
       RowBox[{"Perturbation", "[", 
        RowBox[{
         RowBox[{"ricci", "[", 
          RowBox[{
           RowBox[{"-", "a"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], ",", "order"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"1", "/", "2"}], 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Binomial", "[", 
           RowBox[{"order", ",", "k"}], "]"}], 
          RowBox[{"ExpandPerturbation1", "@", 
           RowBox[{"Perturbation", "[", 
            RowBox[{
             RowBox[{"metric", "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "b"}]}], "]"}], ",", "k"}], "]"}]}], 
          RowBox[{"ExpandPerturbation1", "@", 
           RowBox[{"Perturbation", "[", 
            RowBox[{
             RowBox[{"ricciscalar", "[", "]"}], ",", 
             RowBox[{"order", "-", "k"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", "order"}], "}"}]}], "]"}]}]}]}], 
    ")"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"af255a4f-06da-467e-b9b2-15225266656d"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.9. Perturbations of the Weyl tensor", \
"Subsubsection",ExpressionUUID->"f4e2ccb3-ca12-447e-a062-f56b09318b41"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertWeyl", "[", 
    RowBox[{"weyl_", "[", 
     RowBox[{
      RowBox[{"-", "a_"}], ",", 
      RowBox[{"-", "b_"}], ",", 
      RowBox[{"-", "c_"}], ",", 
      RowBox[{"-", "d_"}]}], "]"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"weyl", "[", 
         RowBox[{
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}], ",", 
          RowBox[{"-", "c_Symbol"}], ",", 
          RowBox[{"-", "d_Symbol"}]}], "]"}], ",", "order_."}], "]"}], "]"}], 
     ":=", 
     RowBox[{"ExpandPerturbation", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"WeylToRiemann", "[", 
         RowBox[{"weyl", "[", 
          RowBox[{
           RowBox[{"-", "a"}], ",", 
           RowBox[{"-", "b"}], ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "d"}]}], "]"}], "]"}], ",", "order"}], "]"}], "]"}]}],
     ")"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"283ab90a-3ed7-4dc6-88ab-7733154f074e"],

Cell["\<\
An expanded version of this formula was contributed by Cyril Pitrou (IAP, \
Paris) in Dec 2006:\
\>", "Text",ExpressionUUID->"250b1f11-68f4-4ea4-9cf0-5308e78baef4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertWeyl", "[", 
    RowBox[{
    "vbundle_", ",", "dimension_", ",", "metric_", ",", "ricci_", ",", 
     "ricciscalar_", ",", "riemann_", ",", 
     RowBox[{"weyl_", "[", 
      RowBox[{
       RowBox[{"-", "a_"}], ",", 
       RowBox[{"-", "b_"}], ",", 
       RowBox[{"-", "c_"}], ",", 
       RowBox[{"-", "d_"}]}], "]"}]}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"weyl", "[", 
         RowBox[{
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}], ",", 
          RowBox[{"-", "c_Symbol"}], ",", 
          RowBox[{"-", "d_Symbol"}]}], "]"}], ",", "order_."}], "]"}], "]"}], 
     ":=", " ", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"dummy", "=", 
         RowBox[{"DummyIn", "[", "vbundle", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Binomial", "[", 
            RowBox[{"order", ",", "k"}], "]"}], 
           RowBox[{"ExpandPerturbation1", "@", 
            RowBox[{"Perturbation", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{
                RowBox[{"-", "d"}], ",", 
                RowBox[{"-", "dummy"}]}], "]"}], ",", "k"}], "]"}]}], 
           RowBox[{"ExpandPerturbation1", "@", 
            RowBox[{"Perturbation", "[", 
             RowBox[{
              RowBox[{"riemann", "[", 
               RowBox[{
                RowBox[{"-", "a"}], ",", 
                RowBox[{"-", "b"}], ",", 
                RowBox[{"-", "c"}], ",", "dummy"}], "]"}], ",", 
              RowBox[{"order", "-", "k"}]}], "]"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "0", ",", "order"}], "}"}]}], "]"}], 
        "\[IndentingNewLine]", "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Binomial", "[", 
               RowBox[{"order", ",", "k"}], "]"}], 
              RowBox[{"ExpandPerturbation1", "@", 
               RowBox[{"Perturbation", "[", 
                RowBox[{
                 RowBox[{"metric", "[", 
                  RowBox[{
                   RowBox[{"-", "a"}], ",", 
                   RowBox[{"-", "c"}]}], "]"}], ",", "k"}], "]"}]}], 
              RowBox[{"ExpandPerturbation1", "@", 
               RowBox[{"Perturbation", "[", 
                RowBox[{
                 RowBox[{"ricci", "[", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "d"}]}], "]"}], ",", 
                 RowBox[{"order", "-", "k"}]}], "]"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "0", ",", "order"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "+", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Binomial", "[", 
               RowBox[{"order", ",", "k"}], "]"}], 
              RowBox[{"ExpandPerturbation1", "@", 
               RowBox[{"Perturbation", "[", 
                RowBox[{
                 RowBox[{"metric", "[", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "d"}]}], "]"}], ",", "k"}], "]"}]}], 
              RowBox[{"ExpandPerturbation1", "@", 
               RowBox[{"Perturbation", "[", 
                RowBox[{
                 RowBox[{"ricci", "[", 
                  RowBox[{
                   RowBox[{"-", "a"}], ",", 
                   RowBox[{"-", "c"}]}], "]"}], ",", 
                 RowBox[{"order", "-", "k"}]}], "]"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "0", ",", "order"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "-", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Binomial", "[", 
               RowBox[{"order", ",", "k"}], "]"}], 
              RowBox[{"ExpandPerturbation1", "@", 
               RowBox[{"Perturbation", "[", 
                RowBox[{
                 RowBox[{"metric", "[", 
                  RowBox[{
                   RowBox[{"-", "a"}], ",", 
                   RowBox[{"-", "d"}]}], "]"}], ",", "k"}], "]"}]}], 
              RowBox[{"ExpandPerturbation1", "@", 
               RowBox[{"Perturbation", "[", 
                RowBox[{
                 RowBox[{"ricci", "[", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "c"}]}], "]"}], ",", 
                 RowBox[{"order", "-", "k"}]}], "]"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "0", ",", "order"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "-", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Binomial", "[", 
               RowBox[{"order", ",", "k"}], "]"}], 
              RowBox[{"ExpandPerturbation1", "@", 
               RowBox[{"Perturbation", "[", 
                RowBox[{
                 RowBox[{"metric", "[", 
                  RowBox[{
                   RowBox[{"-", "b"}], ",", 
                   RowBox[{"-", "c"}]}], "]"}], ",", "k"}], "]"}]}], 
              RowBox[{"ExpandPerturbation1", "@", 
               RowBox[{"Perturbation", "[", 
                RowBox[{
                 RowBox[{"ricci", "[", 
                  RowBox[{
                   RowBox[{"-", "a"}], ",", 
                   RowBox[{"-", "d"}]}], "]"}], ",", 
                 RowBox[{"order", "-", "k"}]}], "]"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "0", ",", "order"}], "}"}]}], "]"}]}], ")"}], 
         "/", 
         RowBox[{"(", 
          RowBox[{"dimension", "-", "2"}], ")"}]}], "\[IndentingNewLine]", "+", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Binomial", "[", 
                RowBox[{"order", ",", "k"}], "]"}], 
               RowBox[{"ExpandPerturbation1", "@", 
                RowBox[{"Perturbation", "[", 
                 RowBox[{
                  RowBox[{"ricciscalar", "[", "]"}], ",", "k"}], "]"}]}], 
               RowBox[{"(", 
                RowBox[{"Sum", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"order", "-", "k"}], ",", "m"}], "]"}], 
                   RowBox[{"ExpandPerturbation1", "@", 
                    RowBox[{"Perturbation", "[", 
                    RowBox[{
                    RowBox[{"metric", "[", 
                    RowBox[{
                    RowBox[{"-", "a"}], ",", 
                    RowBox[{"-", "c"}]}], "]"}], ",", "m"}], "]"}]}], 
                   RowBox[{"ExpandPerturbation1", "@", 
                    RowBox[{"Perturbation", "[", 
                    RowBox[{
                    RowBox[{"metric", "[", 
                    RowBox[{
                    RowBox[{"-", "b"}], ",", 
                    RowBox[{"-", "d"}]}], "]"}], ",", 
                    RowBox[{"order", "-", "k", "-", "m"}]}], "]"}]}]}], ",", 
                  RowBox[{"{", 
                   RowBox[{"m", ",", "0", ",", 
                    RowBox[{"order", "-", "k"}]}], "}"}]}], "]"}], ")"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "0", ",", "order"}], "}"}]}], "]"}], 
            "\[IndentingNewLine]", "-", 
            RowBox[{"(", 
             RowBox[{"Sum", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Binomial", "[", 
                 RowBox[{"order", ",", "k"}], "]"}], 
                RowBox[{"ExpandPerturbation1", "@", 
                 RowBox[{"Perturbation", "[", 
                  RowBox[{
                   RowBox[{"ricciscalar", "[", "]"}], ",", "k"}], "]"}]}], 
                RowBox[{"(", 
                 RowBox[{"Sum", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Binomial", "[", 
                    RowBox[{
                    RowBox[{"order", "-", "k"}], ",", "m"}], "]"}], 
                    RowBox[{"ExpandPerturbation1", "@", 
                    RowBox[{"Perturbation", "[", 
                    RowBox[{
                    RowBox[{"metric", "[", 
                    RowBox[{
                    RowBox[{"-", "a"}], ",", 
                    RowBox[{"-", "d"}]}], "]"}], ",", "m"}], "]"}]}], 
                    RowBox[{"ExpandPerturbation1", "@", 
                    RowBox[{"Perturbation", "[", 
                    RowBox[{
                    RowBox[{"metric", "[", 
                    RowBox[{
                    RowBox[{"-", "b"}], ",", 
                    RowBox[{"-", "c"}]}], "]"}], ",", 
                    RowBox[{"order", "-", "k", "-", "m"}]}], "]"}]}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"m", ",", "0", ",", 
                    RowBox[{"order", "-", "k"}]}], "}"}]}], "]"}], ")"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "0", ",", "order"}], "}"}]}], "]"}], 
             ")"}]}], "\[IndentingNewLine]", ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"dimension", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"dimension", "-", "2"}], ")"}]}]}]}], "\[IndentingNewLine]",
       "]"}]}], ")"}]}], ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"5fe1cf03-3dc5-46c1-94d4-697996d7b7a3"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.10. Perturbations of the TFRicci tensor", \
"Subsubsection",ExpressionUUID->"424b3db6-2e29-4a4c-bdac-c0b0e4e159b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertTFRicci", "[", 
    RowBox[{"tfricci_", "[", 
     RowBox[{
      RowBox[{"-", "a_"}], ",", 
      RowBox[{"-", "b_"}]}], "]"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ExpandPerturbation1", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"tfricci", "[", 
         RowBox[{
          RowBox[{"-", "a_Symbol"}], ",", 
          RowBox[{"-", "b_Symbol"}]}], "]"}], ",", "order_."}], "]"}], "]"}], 
     ":=", 
     RowBox[{"ExpandPerturbation", "[", 
      RowBox[{"Perturbation", "[", 
       RowBox[{
        RowBox[{"TFRicciToRicci", "[", 
         RowBox[{"tfricci", "[", 
          RowBox[{
           RowBox[{"-", "a"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "order"}], "]"}], "]"}]}],
     ")"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6575cf04-bd1e-4c15-9969-1b55ba6ad307"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.11. Perturbations of the Kretchsmann scalar", \
"Subsubsection",ExpressionUUID->"bc8ddaf7-7ea7-42ef-8031-6efa07911680"],

Cell["This probably admits a simpler formula...", \
"Text",ExpressionUUID->"84d21a0a-3eb5-41d3-900c-a358832a5499"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGenPertKretschmann", "[", 
    RowBox[{"vbundle_", ",", "metric_", ",", "riemann_", ",", 
     RowBox[{"kretschmann_", "[", "]"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"inds", "=", 
       RowBox[{"GetIndicesOfVBundle", "[", 
        RowBox[{"vbundle", ",", "8"}], "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"ExpandPerturbation1", "[", 
       RowBox[{"Perturbation", "[", 
        RowBox[{
         RowBox[{"kretschmann", "[", "]"}], ",", "order_."}], "]"}], "]"}], ":=", 
      RowBox[{"ExpandPerturbation", "[", 
       RowBox[{"Perturbation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"metric", "[", 
           RowBox[{
            RowBox[{"inds", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"inds", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}], "]"}], 
          RowBox[{"metric", "[", 
           RowBox[{
            RowBox[{"inds", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"inds", "[", 
             RowBox[{"[", "6", "]"}], "]"}]}], "]"}], 
          RowBox[{"metric", "[", 
           RowBox[{
            RowBox[{"inds", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"inds", "[", 
             RowBox[{"[", "7", "]"}], "]"}]}], "]"}], 
          RowBox[{"metric", "[", 
           RowBox[{
            RowBox[{"inds", "[", 
             RowBox[{"[", "4", "]"}], "]"}], ",", 
            RowBox[{"inds", "[", 
             RowBox[{"[", "8", "]"}], "]"}]}], "]"}], 
          RowBox[{"riemann", "[", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"inds", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"inds", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"inds", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"inds", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}], 
          RowBox[{"riemann", "[", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"inds", "[", 
              RowBox[{"[", "5", "]"}], "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"inds", "[", 
              RowBox[{"[", "6", "]"}], "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"inds", "[", 
              RowBox[{"[", "7", "]"}], "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"inds", "[", 
              RowBox[{"[", "8", "]"}], "]"}]}]}], "]"}]}], ",", "order"}], 
        "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fc35c057-ad40-4d98-a6a6-685cf7d138f8"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5. End private and package",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subsection",ExpressionUUID->"fc65c3e6-3f22-40fe-919c-09bb34a7e44f"],

Cell[BoxData[
 RowBox[{"On", "[", 
  RowBox[{"RuleDelayed", "::", "rhs"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fc5f3ac9-704c-482c-bf90-f1955355e27d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"End", "[", "]"}], "\[IndentingNewLine]", 
 RowBox[{"EndPackage", "[", "]"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"14a6f854-859b-4138-82f1-d3f42e24fbe6"],

Cell[BoxData["\<\"xAct`xPert`Private`\"\>"], \
"Output",ExpressionUUID->"032a215a-3a6a-4185-9ffe-c0ccd4af063f"]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1016, 720},
WindowMargins->{{Automatic, 76}, {Automatic, 0}},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1,
FrontEndVersion->"15.0 for Mac OS X ARM (64-bit) (December 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a4e6dc8f-9038-4e96-90da-8cea27dddfcd"
]

